/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.analyzers;

import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.analyzers.JarManifestAnalyzer;
import org.kordamp.jarviz.util.StringUtils;

public class QueryJarManifestAnalyzer
implements JarManifestAnalyzer<Optional<String>> {
    private final String sectionName;
    private final String attributeName;
    private String result;

    public QueryJarManifestAnalyzer(String sectionName, String attributeName) {
        this.sectionName = sectionName;
        this.attributeName = attributeName;
    }

    public QueryJarManifestAnalyzer(String attributeName) {
        this(null, attributeName);
    }

    @Override
    public void handle(JarFile jarFile, Manifest manifest) throws JarvizException {
        if (null == manifest) {
            return;
        }
        if (StringUtils.isNotBlank(this.sectionName)) {
            Attributes attributes = manifest.getAttributes(this.sectionName);
            if (null != attributes) {
                this.result = attributes.getValue(this.attributeName);
            }
        } else {
            Attributes attributes = manifest.getMainAttributes();
            if (null != attributes) {
                this.result = attributes.getValue(this.attributeName);
            }
        }
    }

    @Override
    public Optional<String> getResult() {
        return Optional.ofNullable(this.result);
    }
}

