/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;

public class Truthy
extends TokenRule {
    private static final List<String> TRUTHY_TOKENS = Arrays.asList("YES", "Yes", "yes", "NO", "No", "no", "TRUE", "True", "true", "FALSE", "False", "false", "ON", "On", "on", "OFF", "Off", "off");
    public static final String OPTION_ALLOWED_VALUES = "allowed-values";
    public static final String OPTION_CHECK_KEYS = "check-keys";

    public Truthy() {
        this.registerListOption(OPTION_ALLOWED_VALUES, TRUTHY_TOKENS, Arrays.asList("true", "false"));
        this.registerOption(OPTION_CHECK_KEYS, true);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        List forbiddenTokens;
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (prev instanceof TagToken) {
            return problems;
        }
        if (!((Boolean)conf.get(OPTION_CHECK_KEYS)).booleanValue() && prev instanceof KeyToken && token instanceof ScalarToken) {
            return problems;
        }
        if (token instanceof ScalarToken && (forbiddenTokens = TRUTHY_TOKENS.stream().filter(i -> !((List)conf.get(OPTION_ALLOWED_VALUES)).contains(i)).collect(Collectors.toList())).stream().anyMatch(truthy -> truthy.equals(((ScalarToken)token).getValue())) && ((ScalarToken)token).getStyle() == DumperOptions.ScalarStyle.PLAIN) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, String.format("truthy value should be one of [%s]", String.join((CharSequence)", ", (List)conf.get(OPTION_ALLOWED_VALUES)))));
        }
        return problems;
    }
}

