/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public abstract class AbstractRepositoryTap<S extends AbstractRepositoryTap<S>>
extends AbstractActivatable<S>
implements RepositoryTap {
    private static final long serialVersionUID = 8737648708964053648L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private final String basename;
    @JsonIgnore
    private String tapName;
    private String owner;
    private String name;
    private String tagName;
    private String branch;
    private String branchPush;
    private String username;
    private String token;
    private String commitMessage;

    protected AbstractRepositoryTap(String basename, String tapName) {
        this.basename = basename;
        this.tapName = tapName;
    }

    @Override
    public String getBasename() {
        return this.basename;
    }

    public void setTapName(String tapName) {
        this.tapName = tapName;
    }

    protected String getTapName() {
        return this.tapName;
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.owner = this.merge(this.owner, ((AbstractRepositoryTap)source).getOwner());
        this.name = this.merge(this.name, ((AbstractRepositoryTap)source).getName());
        this.tagName = this.merge(this.tagName, ((AbstractRepositoryTap)source).getTagName());
        this.branch = this.merge(this.branch, ((AbstractRepositoryTap)source).getBranch());
        this.branchPush = this.merge(this.branchPush, ((AbstractRepositoryTap)source).getBranchPush());
        this.username = this.merge(this.username, ((AbstractRepositoryTap)source).getUsername());
        this.token = this.merge(this.token, ((AbstractRepositoryTap)source).getToken());
        this.commitMessage = this.merge(this.commitMessage, ((AbstractRepositoryTap)source).getCommitMessage());
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractRepositoryTap)source).getExtraProperties()));
    }

    @Override
    public String getCanonicalRepoName() {
        return this.owner + "/" + this.getResolvedName();
    }

    @Override
    public String getResolvedName() {
        if (StringUtils.isNotBlank((String)this.name)) {
            return this.name;
        }
        return this.tapName;
    }

    @Override
    public String getResolvedCommitMessage(JReleaserContext context, TemplateContext props) {
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.commitMessage, (TemplateContext)props);
    }

    @Override
    public String getResolvedTagName(JReleaserContext context, TemplateContext props) {
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.tagName, (TemplateContext)props);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public String getBranchPush() {
        return this.branchPush;
    }

    @Override
    public void setBranchPush(String branchPush) {
        this.branchPush = branchPush;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String getCommitMessage() {
        return this.commitMessage;
    }

    @Override
    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.put("owner", this.owner);
        map.put("name", this.getResolvedName());
        map.put("tagName", this.tagName);
        map.put("branch", this.branch);
        map.put("branchPush", this.branchPush);
        map.put("username", this.username);
        map.put("token", StringUtils.isNotBlank((String)this.token) ? "************" : "**unset**");
        map.put("commitMessage", this.commitMessage);
        map.put("extraProperties", this.getExtraProperties());
        return map;
    }
}

