/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExplicitBackingFieldForbiddenChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBackingFieldChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;)V", "getProperDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExplicitBackingFieldForbiddenChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExplicitBackingFieldForbiddenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExplicitBackingFieldForbiddenChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,59:1\n17#2:60\n26#2:61\n22#2:62\n18#2:63\n*S KotlinDebug\n*F\n+ 1 FirExplicitBackingFieldForbiddenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExplicitBackingFieldForbiddenChecker\n*L\n33#1:60\n41#1:61\n45#1:62\n54#1:63\n*E\n"})
public final class FirExplicitBackingFieldForbiddenChecker
extends FirDeclarationChecker<FirBackingField> {
    @NotNull
    public static final FirExplicitBackingFieldForbiddenChecker INSTANCE = new FirExplicitBackingFieldForbiddenChecker();

    private FirExplicitBackingFieldForbiddenChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirBackingField declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof FirDefaultPropertyBackingField) {
            return;
        }
        FirCallableSymbol $this$modality$iv = declaration.getPropertySymbol();
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getResolvedStatus().getModality() != Modality.FINAL) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), this.getProperDiagnostic(context2, declaration), null, 8, null);
        }
        if (FirDeclarationUtilKt.isExtension(declaration.getPropertySymbol())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_EXTENSION(), null, 8, null);
        }
        FirCallableSymbol $this$isExpect$iv = declaration.getPropertySymbol();
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getRawStatus().isExpect()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getPropertySymbol().getSource(), FirErrors.INSTANCE.getEXPECT_PROPERTY_WITH_EXPLICIT_BACKING_FIELD(), null, 8, null);
        }
        FirCallableSymbol $this$visibility$iv = declaration.getPropertySymbol();
        boolean $i$f$getVisibility = false;
        if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getResolvedStatus().getVisibility())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getPropertySymbol().getSource(), FirErrors.INSTANCE.getEXPLICIT_FIELD_VISIBILITY_MUST_BE_LESS_PERMISSIVE(), null, 8, null);
        }
    }

    private final KtDiagnosticFactory0 getProperDiagnostic(CheckerContext context2, FirBackingField declaration) {
        KtDiagnosticFactory0 ktDiagnosticFactory0;
        FirClassSymbol<?> firClassSymbol = FirHelpersKt.findClosestClassOrObject(context2);
        if ((firClassSymbol != null ? firClassSymbol.getClassKind() : null) == ClassKind.INTERFACE) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_INTERFACE();
        } else {
            FirCallableSymbol $this$isAbstract$iv = declaration.getPropertySymbol();
            boolean $i$f$isAbstract = false;
            ktDiagnosticFactory0 = $this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT ? FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_ABSTRACT_PROPERTY() : FirErrors.INSTANCE.getNON_FINAL_PROPERTY_WITH_EXPLICIT_BACKING_FIELD();
        }
        return ktDiagnosticFactory0;
    }
}

