/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.pipeline;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/pipeline/Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitorVoid;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitResolvedNamedReference", "resolvedNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "lookupInType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nreferenceAllCommonDependencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 referenceAllCommonDependencies.kt\norg/jetbrains/kotlin/fir/pipeline/Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 4 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt$forEachType$1\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,74:1\n1#2:75\n71#3,8:76\n79#3,13:85\n94#3:100\n72#4:84\n14060#5,2:98\n*S KotlinDebug\n*F\n+ 1 referenceAllCommonDependencies.kt\norg/jetbrains/kotlin/fir/pipeline/Visitor\n*L\n67#1:76,8\n67#1:85,13\n67#1:100\n67#1:84\n67#1:98,2\n*E\n"})
final class Visitor
extends FirDefaultVisitorVoid {
    @NotNull
    private final FirSession session;

    public Visitor(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (element instanceof FirExpression) {
            this.lookupInType(FirTypeUtilsKt.getResolvedType((FirExpression)element));
        }
        element.acceptChildren(this);
    }

    @Override
    public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression) {
        CallableId callableId;
        Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(qualifiedAccessExpression);
        CallableId callableId2 = callableId = firCallableSymbol != null ? firCallableSymbol.getCallableId() : null;
        if (callableId != null && callableId.getClassName() == null) {
            FirSymbolProviderKt.getSymbolProvider(this.session).getTopLevelCallableSymbols(callableId.getPackageName(), callableId.getCallableName());
        }
        super.visitQualifiedAccessExpression(qualifiedAccessExpression);
    }

    @Override
    public void visitResolvedNamedReference(@NotNull FirResolvedNamedReference resolvedNamedReference) {
        CallableId callableId;
        Intrinsics.checkNotNullParameter(resolvedNamedReference, "resolvedNamedReference");
        FirBasedSymbol<?> firBasedSymbol = resolvedNamedReference.getResolvedSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        CallableId it = callableId = symbol.getCallableId();
        boolean bl = false;
        CallableId callableId2 = it;
        CallableId callableId3 = !(!(callableId2 != null ? !callableId2.isLocal() : false) || it.getClassId() != null) ? callableId : null;
        if (callableId3 == null) {
            return;
        }
        CallableId id = callableId3;
        FirSymbolProviderKt.getSymbolProvider(this.session).getTopLevelCallableSymbols(id.getPackageName(), id.getCallableName());
    }

    @Override
    public void visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier) {
        Intrinsics.checkNotNullParameter(resolvedQualifier, "resolvedQualifier");
        this.lookupInType(FirTypeUtilsKt.getResolvedType(resolvedQualifier));
        this.visitElement(resolvedQualifier);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef) {
        Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
        this.lookupInType(resolvedTypeRef.getConeType());
    }

    private final void lookupInType(ConeKotlinType type) {
        ConeKotlinType $this$forEachType_u24default$iv = type;
        boolean $i$f$forEachType = false;
        ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[]{$this$forEachType_u24default$iv};
        List<ConeKotlinType> stack$iv = CollectionsKt.mutableListOf(coneKotlinTypeArray);
        while (!((Collection)stack$iv).isEmpty()) {
            ConeClassLikeLookupTag lookupTag;
            ConeKotlinType it;
            ConeKotlinType next$iv;
            ConeKotlinType coneKotlinType = AddToStdlibKt.popLast(stack$iv);
            boolean bl = false;
            it = next$iv = (it = coneKotlinType);
            boolean bl2 = false;
            if (ConeTypeUtilsKt.getClassLikeLookupTagIfAny(it) != null && !(lookupTag instanceof ConeClassLikeLookupTagWithFixedSymbol)) {
                FirSymbolProviderKt.getSymbolProvider(this.session).getClassLikeSymbolByClassId(lookupTag.getClassId());
            }
            ConeKotlinType coneKotlinType2 = next$iv;
            if (coneKotlinType2 instanceof ConeFlexibleType) {
                stack$iv.add(((ConeFlexibleType)next$iv).getLowerBound());
                if (((ConeFlexibleType)next$iv).isTrivial()) continue;
                stack$iv.add(((ConeFlexibleType)next$iv).getUpperBound());
                continue;
            }
            if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                stack$iv.add(((ConeDefinitelyNotNullType)next$iv).getOriginal());
                continue;
            }
            if (coneKotlinType2 instanceof ConeIntersectionType) {
                stack$iv.addAll(((ConeIntersectionType)next$iv).getIntersectedTypes());
                continue;
            }
            ConeTypeProjection[] $this$forEach$iv$iv = next$iv.getTypeArguments();
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ConeTypeProjection element$iv$iv;
                ConeTypeProjection it$iv = element$iv$iv = $this$forEach$iv$iv[i2];
                boolean bl3 = false;
                if (!(it$iv instanceof ConeKotlinTypeProjection)) continue;
                stack$iv.add(((ConeKotlinTypeProjection)it$iv).getType());
            }
        }
    }
}

