import type { AnyFunction } from '../types.ts';
import type { AnyThread, ThreadFunctions } from '../Thread.ts';
/**
 * A strategy for managing functions across threads that automatically releases
 * functions when they are no longer needed. This is done by deserializing functions
 * into a proxy that can be called, and wrapping that proxy in a `FinalizationRegistry`,
 * which allows us to send a message to the parent thread when the function is no
 * longer used.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/FinalizationRegistry
 */
export declare class ThreadFunctionsAutomatic implements ThreadFunctions {
    #private;
    get(id: string): Function | undefined;
    release(id: string): boolean;
    serialize(func: AnyFunction): string;
    deserialize(id: string, thread: AnyThread): Function;
}
//# sourceMappingURL=ThreadFunctionsAutomatic.d.ts.map