import type { Document } from './Document.ts';
import type { DocumentFragment } from './DocumentFragment.ts';
import type { Node } from './Node.ts';
import type { Comment } from './Comment.ts';
import type { ParentNode } from './ParentNode.ts';
import type { Element } from './Element.ts';
import type { CharacterData } from './CharacterData.ts';
import type { Text } from './Text.ts';
export declare function isCharacterData(node: Node): node is CharacterData;
export declare function isTextNode(node: Node): node is Text;
export declare function isCommentNode(node: Node): node is Comment;
export declare function isElementNode(node: Node): node is Element;
export declare function isDocumentFragmentNode(node: Node): node is DocumentFragment;
export declare function isParentNode(node: Node): node is ParentNode;
export declare function cloneNode(node: Node, deep?: boolean, document?: Document): Node;
export declare function descendants(node: Node): Node[];
export declare function selfAndDescendants(node: Node): Node[];
//# sourceMappingURL=shared.d.ts.map