import { Document } from './Document.ts';
import { Event } from './Event.ts';
import { EventTarget } from './EventTarget.ts';
import { CustomEvent } from './CustomEvent.ts';
import { ErrorEvent } from './ErrorEvent.ts';
import { PromiseRejectionEvent } from './PromiseRejectionEvent.ts';
import { ToggleEvent } from './ToggleEvent.ts';
import { FocusEvent } from './FocusEvent.ts';
import { ClipboardEvent } from './ClipboardEvent.ts';
import { Node } from './Node.ts';
import { ParentNode } from './ParentNode.ts';
import { ChildNode } from './ChildNode.ts';
import { Element } from './Element.ts';
import { HTMLElement } from './HTMLElement.ts';
import { SVGElement } from './SVGElement.ts';
import { CharacterData } from './CharacterData.ts';
import { Text } from './Text.ts';
import { Comment } from './Comment.ts';
import { DocumentFragment } from './DocumentFragment.ts';
import { HTMLTemplateElement } from './HTMLTemplateElement.ts';
import { CustomElementRegistryImplementation } from './CustomElementRegistry.ts';
import { MutationObserver } from './MutationObserver.ts';
import { HOOKS } from './constants.ts';
import type { Hooks } from './hooks.ts';
type OnErrorHandler = ((message: string, filename?: string, lineno?: number, colno?: number, error?: any) => void) | null;
export declare class Window extends EventTarget {
    #private;
    [HOOKS]: Partial<Hooks>;
    name: string;
    window: this;
    parent: this;
    self: this;
    top: this;
    document: Document;
    customElements: CustomElementRegistryImplementation;
    location: Location;
    navigator: Navigator;
    Event: typeof Event;
    ErrorEvent: typeof ErrorEvent;
    PromiseRejectionEvent: typeof PromiseRejectionEvent;
    ToggleEvent: typeof ToggleEvent;
    FocusEvent: typeof FocusEvent;
    ClipboardEvent: typeof ClipboardEvent;
    EventTarget: typeof EventTarget;
    CustomEvent: typeof CustomEvent;
    Node: typeof Node;
    ParentNode: typeof ParentNode;
    ChildNode: typeof ChildNode;
    DocumentFragment: typeof DocumentFragment;
    Document: typeof Document;
    CharacterData: typeof CharacterData;
    Comment: typeof Comment;
    Text: typeof Text;
    Element: typeof Element;
    HTMLElement: typeof HTMLElement;
    SVGElement: typeof SVGElement;
    HTMLTemplateElement: typeof HTMLTemplateElement;
    MutationObserver: typeof MutationObserver;
    get onerror(): OnErrorHandler;
    set onerror(handler: OnErrorHandler);
    get onunhandledrejection(): WindowEventHandlers['onunhandledrejection'];
    set onunhandledrejection(handler: WindowEventHandlers['onunhandledrejection']);
    static setGlobal(window: Window): void;
    static setGlobalThis(window: Window): void;
}
export {};
//# sourceMappingURL=Window.d.ts.map