import type { RemoteReceiverElement } from '@remote-dom/core/receivers';
import { type ComponentType } from 'react';
import { type RemoteElementPropsOptions } from './hooks/props-for-element.tsx';
import { REMOTE_ELEMENT_PROP, REMOTE_ELEMENT_ATTACHED_PROP } from './constants.ts';
import type { RemoteComponentRendererProps } from './types.ts';
/**
 * Additional props that are added to React components rendered by `createRemoteComponentRenderer`.
 */
export interface RemoteComponentRendererAdditionalProps {
    /**
     * The remote element that this component is rendering.
     */
    readonly [REMOTE_ELEMENT_PROP]: RemoteReceiverElement;
    readonly [REMOTE_ELEMENT_ATTACHED_PROP]: boolean;
}
export interface RemoteComponentRendererOptions<Props = {}> extends RemoteElementPropsOptions<Props> {
    /**
     * The display name of the resulting wrapper component. By default, a name derived
     * from the wrapped component is used, with a fallback to `RemoteComponentRenderer(Component)`.
     */
    name?: string;
    /**
     * Customizes the props your wrapper React component will have for event listeners
     * on the underlying custom element. The key is the prop name on the React component,
     * and the value is an options object containing the event name on the custom element.
     *
     * @example
     * ```tsx
     * const Button = createRemoteComponent(ButtonImplementation, {
     *   eventProps: {
     *     onClick: {event: 'click'},
     *   },
     * });
     *
     * function ButtonImplementation({children, onClick}) {
     *   // Default behavior: dispatch the `detail` of the event to the remote environment
     *   return <button onClick={onClick}>{children}</button>;
     *
     *   // Alternatively, dispatch a custom value to the remote environment, including potentially
     *   // omitting the event details entirely, like we do below:
     *   return <button onClick={() => onClick()}>{children}</button>;
     * }
     * ```
     */
    eventProps?: RemoteElementPropsOptions<Props>['eventProps'];
}
/**
 * Takes a React component, and returns a new component that can be used to render that
 * component from a remote element. This wrapper will handle subscribing to changes in that
 * element, and will normalize the properties on that remote element before passing them
 * to your React component.
 */
export declare function createRemoteComponentRenderer<Props extends Record<string, any> = {}>(Component: ComponentType<Props>, { name, eventProps }?: NoInfer<RemoteComponentRendererOptions<Props>>): ComponentType<RemoteComponentRendererProps>;
//# sourceMappingURL=component.d.ts.map