export declare const IFRAME_SRC_DOC = "<!DOCTYPE html>\n<html>\n<head>\n  <meta charset=\"utf-8\">\n</head>\n<body>\n  <div id=\"root\"></div>\n  <script>\n\"use strict\";\n(() => {\n  var __defProp = Object.defineProperty;\n  var __typeError = (msg) => {\n    throw TypeError(msg);\n  };\n  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;\n  var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== \"symbol\" ? key + \"\" : key, value);\n  var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError(\"Cannot \" + msg);\n  var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, \"read from private field\"), getter ? getter.call(obj) : member.get(obj));\n  var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError(\"Cannot add the same private member more than once\") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);\n  var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, \"write to private field\"), setter ? setter.call(obj, value) : member.set(obj, value), value);\n  var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, \"access private method\"), method);\n\n  // ../../../node_modules/.pnpm/@remote-dom+core@1.8.1_@preact+signals-core@1.10.0/node_modules/@remote-dom/core/build/esm/elements/RemoteEvent.mjs\n  var RemoteEvent = class extends CustomEvent {\n    /**\n     * The last value received from a `respondWith()` call.\n     */\n    /**\n     * Provides the `response` value to be sent as the return value for\n     * the remote property function that triggered this event.\n     */\n    respondWith(response) {\n      this.response = response;\n    }\n  };\n\n  // ../../../node_modules/.pnpm/@remote-dom+core@1.8.1_@preact+signals-core@1.10.0/node_modules/@remote-dom/core/build/esm/constants.mjs\n  var MUTATION_TYPE_INSERT_CHILD = 0;\n  var MUTATION_TYPE_REMOVE_CHILD = 1;\n  var MUTATION_TYPE_UPDATE_TEXT = 2;\n  var MUTATION_TYPE_UPDATE_PROPERTY = 3;\n  var UPDATE_PROPERTY_TYPE_PROPERTY = 1;\n  var UPDATE_PROPERTY_TYPE_ATTRIBUTE = 2;\n  var UPDATE_PROPERTY_TYPE_EVENT_LISTENER = 3;\n  var ROOT_ID = \"~\";\n\n  // ../../../node_modules/.pnpm/@remote-dom+core@1.8.1_@preact+signals-core@1.10.0/node_modules/@remote-dom/core/build/esm/elements/internals.mjs\n  var REMOTE_CONNECTIONS = /* @__PURE__ */ new WeakMap();\n  var REMOTE_IDS = /* @__PURE__ */ new WeakMap();\n  var id = 0;\n  function remoteId(node) {\n    let remoteID = REMOTE_IDS.get(node);\n    if (remoteID == null) {\n      remoteID = String(id++);\n      REMOTE_IDS.set(node, remoteID);\n    }\n    return remoteID;\n  }\n  var REMOTE_PROPERTIES = /* @__PURE__ */ new WeakMap();\n  function remoteProperties(node) {\n    return REMOTE_PROPERTIES.get(node);\n  }\n  var REMOTE_ATTRIBUTES = /* @__PURE__ */ new WeakMap();\n  function remoteAttributes(node) {\n    let attributes = REMOTE_ATTRIBUTES.get(node);\n    if (attributes != null) return attributes;\n    if (!(node instanceof Element) || node.tagName.includes(\"-\")) return void 0;\n    attributes = {};\n    for (const {\n      name,\n      value\n    } of node.attributes) {\n      attributes[name] = value;\n    }\n    return attributes;\n  }\n  var REMOTE_EVENT_LISTENERS = /* @__PURE__ */ new WeakMap();\n  function remoteEventListeners(node) {\n    return REMOTE_EVENT_LISTENERS.get(node);\n  }\n  function updateRemoteElementProperty(node, property, value) {\n    let properties = REMOTE_PROPERTIES.get(node);\n    if (properties == null) {\n      properties = {};\n      REMOTE_PROPERTIES.set(node, properties);\n    }\n    if (properties[property] === value) return;\n    properties[property] = value;\n    const connection = REMOTE_CONNECTIONS.get(node);\n    if (connection == null) return;\n    connection.mutate([[MUTATION_TYPE_UPDATE_PROPERTY, remoteId(node), property, value, UPDATE_PROPERTY_TYPE_PROPERTY]]);\n  }\n  function updateRemoteElementAttribute(node, attribute, value) {\n    let attributes = REMOTE_ATTRIBUTES.get(node);\n    if (attributes == null) {\n      attributes = {};\n      REMOTE_ATTRIBUTES.set(node, attributes);\n    }\n    if (attributes[attribute] === value) return;\n    if (value == null) {\n      delete attributes[attribute];\n    } else {\n      attributes[attribute] = String(value);\n    }\n    const connection = REMOTE_CONNECTIONS.get(node);\n    if (connection == null) return;\n    connection.mutate([[MUTATION_TYPE_UPDATE_PROPERTY, remoteId(node), attribute, value, UPDATE_PROPERTY_TYPE_ATTRIBUTE]]);\n  }\n  function updateRemoteElementEventListener(node, event, listener) {\n    let eventListeners = REMOTE_EVENT_LISTENERS.get(node);\n    if (eventListeners == null) {\n      eventListeners = {};\n      REMOTE_EVENT_LISTENERS.set(node, eventListeners);\n    }\n    if (eventListeners[event] === listener) return;\n    if (listener == null) {\n      delete eventListeners[event];\n    } else {\n      eventListeners[event] = listener;\n    }\n    const connection = REMOTE_CONNECTIONS.get(node);\n    if (connection == null) return;\n    connection.mutate([[MUTATION_TYPE_UPDATE_PROPERTY, remoteId(node), event, listener, UPDATE_PROPERTY_TYPE_EVENT_LISTENER]]);\n  }\n  function connectRemoteNode(node, connection) {\n    const existingConnection = REMOTE_CONNECTIONS.get(node);\n    if (existingConnection === connection) return;\n    REMOTE_CONNECTIONS.set(node, connection);\n    if (node.childNodes) {\n      for (let i = 0; i < node.childNodes.length; i++) {\n        connectRemoteNode(node.childNodes[i], connection);\n      }\n    }\n  }\n  function disconnectRemoteNode(node) {\n    const existingConnection = REMOTE_CONNECTIONS.get(node);\n    if (existingConnection == null) return;\n    REMOTE_CONNECTIONS.delete(node);\n    if (node.childNodes) {\n      for (let i = 0; i < node.childNodes.length; i++) {\n        disconnectRemoteNode(node.childNodes[i]);\n      }\n    }\n  }\n  function serializeRemoteNode(node) {\n    const {\n      nodeType\n    } = node;\n    switch (nodeType) {\n      // Element\n      case 1: {\n        return {\n          id: remoteId(node),\n          type: nodeType,\n          element: node.localName,\n          properties: cloneMaybeObject(remoteProperties(node)),\n          attributes: cloneMaybeObject(remoteAttributes(node)),\n          eventListeners: cloneMaybeObject(remoteEventListeners(node)),\n          children: Array.from(node.childNodes).map(serializeRemoteNode)\n        };\n      }\n      // TextNode\n      case 3:\n      // Comment\n      // eslint-disable-next-line no-fallthrough\n      case 8: {\n        return {\n          id: remoteId(node),\n          type: nodeType,\n          data: node.data\n        };\n      }\n      default: {\n        throw new Error(`Cannot serialize node of type ${node.nodeType} (${typeof node.nodeType})`);\n      }\n    }\n  }\n  function cloneMaybeObject(maybeObject) {\n    return maybeObject ? {\n      ...maybeObject\n    } : void 0;\n  }\n  function callRemoteElementMethod(node, method, ...args) {\n    const id2 = REMOTE_IDS.get(node);\n    const connection = REMOTE_CONNECTIONS.get(node);\n    if (id2 == null || connection == null) {\n      throw new Error(`Cannot call method ${method} on an unconnected node`);\n    }\n    return connection.call(id2, method, ...args);\n  }\n\n  // ../../../node_modules/.pnpm/@remote-dom+core@1.8.1_@preact+signals-core@1.10.0/node_modules/@remote-dom/core/build/esm/elements/RemoteElement.mjs\n  var EMPTY_DEFINITION = Object.freeze({});\n  var RemoteElement = class extends HTMLElement {\n    static get observedAttributes() {\n      return this.finalize().__observedAttributes;\n    }\n    /**\n     * The resolved property definitions for this remote element.\n     */\n    static get remotePropertyDefinitions() {\n      return this.finalize().__remotePropertyDefinitions;\n    }\n    /**\n     * The resolved attribute definitions for this remote element.\n     */\n    static get remoteAttributeDefinitions() {\n      return this.finalize().__remoteAttributeDefinitions;\n    }\n    /**\n     * The resolved event listener definitions for this remote element.\n     */\n    static get remoteEventDefinitions() {\n      return this.finalize().__remoteEventDefinitions;\n    }\n    /**\n     * The resolved slot definitions for this remote element.\n     */\n    static get remoteSlotDefinitions() {\n      return this.finalize().__remoteSlotDefinitions;\n    }\n    /**\n     * Creates a new definition for a property that will be synchronized between\n     * this remote element and its host representation.\n     */\n    static createProperty(name, definition) {\n      saveRemoteProperty(name, definition, this.observedAttributes, this.remotePropertyDefinitions, this.__attributeToPropertyMap, this.__eventToPropertyMap);\n    }\n    /**\n     * Consumes all the static members defined on the class and converts them\n     * into the internal representation used to handle properties, attributes,\n     * and event listeners.\n     */\n    static finalize() {\n      if (this.hasOwnProperty(\"__finalized\")) {\n        return this;\n      }\n      this.__finalized = true;\n      const {\n        slottable,\n        remoteSlots,\n        remoteProperties: remoteProperties2,\n        remoteAttributes: remoteAttributes2,\n        remoteEvents,\n        remoteMethods\n      } = this;\n      const SuperConstructor = Object.getPrototypeOf(this);\n      const observedAttributes = /* @__PURE__ */ new Set();\n      if (slottable) observedAttributes.add(\"slot\");\n      const attributeToPropertyMap = /* @__PURE__ */ new Map();\n      const eventToPropertyMap = /* @__PURE__ */ new Map();\n      const remoteSlotDefinitions = /* @__PURE__ */ new Map();\n      const remotePropertyDefinitions = /* @__PURE__ */ new Map();\n      const remoteAttributeDefinitions = /* @__PURE__ */ new Map();\n      const remoteEventDefinitions = /* @__PURE__ */ new Map();\n      if (typeof SuperConstructor.finalize === \"function\") {\n        SuperConstructor.finalize();\n        SuperConstructor.observedAttributes.forEach((attribute) => {\n          observedAttributes.add(attribute);\n        });\n        SuperConstructor.remotePropertyDefinitions.forEach((definition, property) => {\n          remotePropertyDefinitions.set(property, definition);\n        });\n        SuperConstructor.remoteAttributeDefinitions.forEach((definition, event) => {\n          remoteAttributeDefinitions.set(event, definition);\n        });\n        SuperConstructor.remoteEventDefinitions.forEach((definition, event) => {\n          remoteEventDefinitions.set(event, definition);\n        });\n        SuperConstructor.remoteSlotDefinitions.forEach((definition, slot) => {\n          remoteSlotDefinitions.set(slot, definition);\n        });\n      }\n      if (remoteSlots != null) {\n        const slotNames = Array.isArray(remoteSlots) ? remoteSlots : Object.keys(remoteSlots);\n        slotNames.forEach((slotName) => {\n          remoteSlotDefinitions.set(slotName, EMPTY_DEFINITION);\n        });\n      }\n      if (remoteProperties2 != null) {\n        if (Array.isArray(remoteProperties2)) {\n          remoteProperties2.forEach((propertyName) => {\n            saveRemoteProperty(propertyName, void 0, observedAttributes, remotePropertyDefinitions, attributeToPropertyMap, eventToPropertyMap);\n          });\n        } else {\n          Object.keys(remoteProperties2).forEach((propertyName) => {\n            saveRemoteProperty(propertyName, remoteProperties2[propertyName], observedAttributes, remotePropertyDefinitions, attributeToPropertyMap, eventToPropertyMap);\n          });\n        }\n      }\n      if (remoteAttributes2 != null) {\n        remoteAttributes2.forEach((attribute) => {\n          remoteAttributeDefinitions.set(attribute, EMPTY_DEFINITION);\n          observedAttributes.add(attribute);\n        });\n      }\n      if (remoteEvents != null) {\n        if (Array.isArray(remoteEvents)) {\n          remoteEvents.forEach((event) => {\n            remoteEventDefinitions.set(event, EMPTY_DEFINITION);\n          });\n        } else {\n          Object.keys(remoteEvents).forEach((event) => {\n            remoteEventDefinitions.set(event, remoteEvents[event]);\n          });\n        }\n      }\n      if (remoteMethods != null) {\n        if (Array.isArray(remoteMethods)) {\n          for (const method of remoteMethods) {\n            this.prototype[method] = function(...args) {\n              return this.callRemoteMethod(method, ...args);\n            };\n          }\n        } else {\n          Object.assign(this, remoteMethods);\n        }\n      }\n      Object.defineProperties(this, {\n        __observedAttributes: {\n          value: [...observedAttributes],\n          enumerable: false\n        },\n        __remoteSlotDefinitions: {\n          value: remoteSlotDefinitions,\n          enumerable: false\n        },\n        __remotePropertyDefinitions: {\n          value: remotePropertyDefinitions,\n          enumerable: false\n        },\n        __remoteAttributeDefinitions: {\n          value: remoteAttributeDefinitions,\n          enumerable: false\n        },\n        __remoteEventDefinitions: {\n          value: remoteEventDefinitions,\n          enumerable: false\n        },\n        __attributeToPropertyMap: {\n          value: attributeToPropertyMap,\n          enumerable: false\n        },\n        __eventToPropertyMap: {\n          value: eventToPropertyMap,\n          enumerable: false\n        }\n      });\n      return this;\n    }\n    // Just need to use these types so TS doesn\u2019t lose track of them.\n    /** @internal */\n    /** @internal */\n    /** @internal */\n    /** @internal */\n    constructor() {\n      super();\n      this.constructor.finalize();\n      const propertyDescriptors = {};\n      const initialPropertiesToSet = {};\n      const prototype = Object.getPrototypeOf(this);\n      const ThisClass = this.constructor;\n      for (const [property, description] of ThisClass.remotePropertyDefinitions.entries()) {\n        const aliasedName = description.name;\n        if (prototype.hasOwnProperty(property)) {\n          continue;\n        }\n        if (property === aliasedName) {\n          initialPropertiesToSet[property] = description.default;\n        }\n        const propertyDescriptor = {\n          configurable: true,\n          enumerable: property === aliasedName,\n          get: () => {\n            return remoteProperties(this)?.[aliasedName];\n          },\n          set: (value) => {\n            updateRemoteElementProperty(this, aliasedName, value);\n          }\n        };\n        propertyDescriptors[property] = propertyDescriptor;\n      }\n      for (const [event, definition] of ThisClass.remoteEventDefinitions.entries()) {\n        const propertyFromDefinition = definition.property ?? true;\n        if (!propertyFromDefinition) continue;\n        const property = propertyFromDefinition === true ? `on${event}` : propertyFromDefinition;\n        propertyDescriptors[property] = {\n          configurable: true,\n          enumerable: true,\n          get: () => {\n            return getRemoteEvents(this).properties.get(property) ?? null;\n          },\n          set: (value) => {\n            const remoteEvents = getRemoteEvents(this);\n            const currentListener = remoteEvents.properties.get(property);\n            if (typeof value === \"function\") {\n              let handler = function(...args) {\n                return value.call(this, ...args);\n              };\n              remoteEvents.properties.set(property, handler);\n              this.addEventListener(event, handler);\n            } else {\n              remoteEvents.properties.delete(property);\n            }\n            if (currentListener) {\n              this.removeEventListener(event, currentListener);\n            }\n          }\n        };\n      }\n      Object.defineProperties(this, propertyDescriptors);\n      Object.assign(this, initialPropertiesToSet);\n    }\n    attributeChangedCallback(attribute, _oldValue, newValue) {\n      if (attribute === \"slot\" && this.constructor.slottable) {\n        updateRemoteElementAttribute(this, attribute, newValue ? String(newValue) : void 0);\n        return;\n      }\n      const {\n        remotePropertyDefinitions,\n        remoteAttributeDefinitions,\n        __attributeToPropertyMap: attributeToPropertyMap\n      } = this.constructor;\n      if (remoteAttributeDefinitions.has(attribute)) {\n        updateRemoteElementAttribute(this, attribute, newValue);\n        return;\n      }\n      const property = attributeToPropertyMap.get(attribute);\n      const propertyDefinition = property == null ? property : remotePropertyDefinitions.get(property);\n      if (propertyDefinition == null) return;\n      this[property] = convertAttributeValueToProperty(newValue, propertyDefinition.type);\n    }\n    connectedCallback() {\n      for (const [event, descriptor] of this.constructor.remoteEventDefinitions.entries()) {\n        if (descriptor.bubbles) {\n          this.addEventListener(event, noopBubblesEventListener);\n        }\n      }\n    }\n    disconnectedCallback() {\n      for (const [event, descriptor] of this.constructor.remoteEventDefinitions.entries()) {\n        if (descriptor.bubbles) {\n          this.removeEventListener(event, noopBubblesEventListener);\n        }\n      }\n    }\n    addEventListener(type, listener, options) {\n      const {\n        remoteEventDefinitions,\n        __eventToPropertyMap: eventToPropertyMap\n      } = this.constructor;\n      const listenerDefinition = remoteEventDefinitions.get(type);\n      const property = eventToPropertyMap.get(type);\n      if (listenerDefinition == null && property == null) {\n        return super.addEventListener(type, listener, options);\n      }\n      const remoteEvents = getRemoteEvents(this);\n      const remoteEvent = getRemoteEventRecord.call(this, type, {\n        property,\n        definition: listenerDefinition\n      });\n      const normalizedListener = typeof options === \"object\" && options?.once ? (...args) => {\n        const result = typeof listener === \"object\" ? listener.handleEvent(...args) : listener.call(this, ...args);\n        removeRemoteListener.call(this, type, listener, listenerRecord);\n        return result;\n      } : listener;\n      const listenerRecord = [normalizedListener, remoteEvent];\n      remoteEvent.listeners.add(listener);\n      remoteEvents.listeners.set(listener, listenerRecord);\n      super.addEventListener(type, normalizedListener, options);\n      if (typeof options === \"object\" && options.signal) {\n        options.signal.addEventListener(\"abort\", () => {\n          removeRemoteListener.call(this, type, listener, listenerRecord);\n        }, {\n          once: true\n        });\n      }\n      if (listenerDefinition) {\n        updateRemoteElementEventListener(this, type, remoteEvent.dispatch);\n      } else {\n        updateRemoteElementProperty(this, property, remoteEvent.dispatch);\n      }\n    }\n    removeEventListener(type, listener, options) {\n      const listenerRecord = REMOTE_EVENTS.get(this)?.listeners.get(listener);\n      const normalizedListener = listenerRecord ? listenerRecord[0] : listener;\n      super.removeEventListener(type, normalizedListener, options);\n      if (listenerRecord == null) return;\n      removeRemoteListener.call(this, type, listener, listenerRecord);\n    }\n    /**\n     * Updates a single remote property on an element node. If the element is\n     * connected to a remote root, this function will also make a `mutate()` call\n     * to communicate the change to the host.\n     */\n    updateRemoteProperty(name, value) {\n      updateRemoteElementProperty(this, name, value);\n    }\n    /**\n     * Updates a single remote attribute on an element node. If the element is\n     * connected to a remote root, this function will also make a `mutate()` call\n     * to communicate the change to the host.\n     */\n    updateRemoteAttribute(name, value) {\n      updateRemoteElementAttribute(this, name, value);\n    }\n    /**\n     * Performs a method through `RemoteConnection.call()`, using the remote ID and\n     * connection for the provided node.\n     */\n    callRemoteMethod(method, ...args) {\n      return callRemoteElementMethod(this, method, ...args);\n    }\n  };\n  __publicField(RemoteElement, \"slottable\", true);\n  __publicField(RemoteElement, \"__finalized\", true);\n  __publicField(RemoteElement, \"__observedAttributes\", []);\n  __publicField(RemoteElement, \"__attributeToPropertyMap\", /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n  __publicField(RemoteElement, \"__eventToPropertyMap\", /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n  __publicField(RemoteElement, \"__remotePropertyDefinitions\", /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n  __publicField(RemoteElement, \"__remoteAttributeDefinitions\", /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n  __publicField(RemoteElement, \"__remoteEventDefinitions\", /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n  __publicField(RemoteElement, \"__remoteSlotDefinitions\", /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n  var REMOTE_EVENTS = /* @__PURE__ */ new WeakMap();\n  function getRemoteEvents(element) {\n    let events = REMOTE_EVENTS.get(element);\n    if (events) return events;\n    events = {\n      events: /* @__PURE__ */ new Map(),\n      properties: /* @__PURE__ */ new Map(),\n      listeners: /* @__PURE__ */ new WeakMap()\n    };\n    REMOTE_EVENTS.set(element, events);\n    return events;\n  }\n  function getRemoteEventRecord(type, {\n    property,\n    definition\n  }) {\n    const remoteEvents = getRemoteEvents(this);\n    let remoteEvent = remoteEvents.events.get(type);\n    if (remoteEvent == null) {\n      remoteEvent = {\n        name: type,\n        property,\n        definition,\n        listeners: /* @__PURE__ */ new Set(),\n        dispatch: (arg) => {\n          const event = definition?.dispatchEvent?.call(this, arg) ?? new RemoteEvent(type, {\n            detail: arg,\n            bubbles: definition?.bubbles\n          });\n          this.dispatchEvent(event);\n          return event.response;\n        }\n      };\n      remoteEvents.events.set(type, remoteEvent);\n    }\n    return remoteEvent;\n  }\n  function removeRemoteListener(type, listener, listenerRecord) {\n    const remoteEvents = getRemoteEvents(this);\n    const remoteEvent = listenerRecord[1];\n    remoteEvent.listeners.delete(listener);\n    remoteEvents.listeners.delete(listener);\n    if (remoteEvent.listeners.size > 0) return;\n    remoteEvents.events.delete(type);\n    if (remoteEvent.property) {\n      if (remoteProperties(this)?.[remoteEvent.property] === remoteEvent.dispatch) {\n        updateRemoteElementProperty(this, remoteEvent.property, void 0);\n      }\n    } else {\n      if (remoteEventListeners(this)?.[type] === remoteEvent.dispatch) {\n        updateRemoteElementEventListener(this, type, void 0);\n      }\n    }\n  }\n  function saveRemoteProperty(name, description, observedAttributes, remotePropertyDefinitions, attributeToPropertyMap, eventToPropertyMap) {\n    if (remotePropertyDefinitions.has(name)) {\n      return remotePropertyDefinitions.get(name);\n    }\n    const looksLikeEventCallback = name[0] === \"o\" && name[1] === \"n\";\n    const resolvedDescription = description ?? {};\n    let {\n      alias\n    } = resolvedDescription;\n    const {\n      type = looksLikeEventCallback ? Function : String,\n      attribute = type !== Function,\n      event = looksLikeEventCallback,\n      default: defaultValue = type === Boolean ? false : void 0\n    } = resolvedDescription;\n    if (alias == null) {\n      const lowercaseProperty = name.toLowerCase();\n      if (lowercaseProperty !== name) {\n        alias = [lowercaseProperty];\n      }\n      if (looksLikeEventCallback) {\n        alias ?? (alias = []);\n        alias.unshift(`_${name}`);\n      }\n    }\n    let attributeName;\n    if (attribute === true) {\n      attributeName = camelToKebabCase(name);\n    } else if (typeof attribute === \"string\") {\n      attributeName = attribute;\n    }\n    if (attributeName) {\n      if (Array.isArray(observedAttributes)) {\n        observedAttributes.push(attributeName);\n      } else {\n        observedAttributes.add(attributeName);\n      }\n      attributeToPropertyMap.set(attributeName, name);\n    }\n    let eventName;\n    if (event === true) {\n      eventName = camelToKebabCase(looksLikeEventCallback ? name.slice(2) : name);\n    } else if (typeof event === \"string\") {\n      eventName = event;\n    }\n    if (eventName) {\n      eventToPropertyMap.set(eventName, name);\n    }\n    const definition = {\n      name,\n      type,\n      alias,\n      event: eventName,\n      attribute: attributeName,\n      default: defaultValue\n    };\n    remotePropertyDefinitions.set(name, definition);\n    if (alias) {\n      for (const propertyAlias of alias) {\n        remotePropertyDefinitions.set(propertyAlias, definition);\n      }\n    }\n    return definition;\n  }\n  function convertAttributeValueToProperty(value, type) {\n    if (value == null) return void 0;\n    switch (type) {\n      case Boolean:\n        return value != null && value !== \"false\";\n      case Object:\n      case Array:\n        try {\n          return JSON.parse(value);\n        } catch {\n          return void 0;\n        }\n      case String:\n        return String(value);\n      case Number:\n        return Number.parseFloat(value);\n      case Function:\n        return void 0;\n      default: {\n        return type.parse?.(value);\n      }\n    }\n  }\n  function camelToKebabCase(str) {\n    return str.replace(/([a-z])([A-Z])/g, \"$1-$2\").toLowerCase();\n  }\n  function noopBubblesEventListener() {\n  }\n\n  // ../../../node_modules/.pnpm/@remote-dom+core@1.8.1_@preact+signals-core@1.10.0/node_modules/@remote-dom/core/build/esm/elements/RemoteMutationObserver.mjs\n  var RemoteMutationObserver = class extends MutationObserver {\n    constructor(connection) {\n      super((records) => {\n        const addedNodes = [];\n        const remoteRecords = [];\n        for (const record of records) {\n          const targetId = remoteId(record.target);\n          if (record.type === \"childList\") {\n            const position = record.previousSibling ? indexOf(record.previousSibling, record.target.childNodes) + 1 : 0;\n            record.removedNodes.forEach((node) => {\n              disconnectRemoteNode(node);\n              remoteRecords.push([MUTATION_TYPE_REMOVE_CHILD, targetId, position]);\n            });\n            record.addedNodes.forEach((node, index) => {\n              if (addedNodes.some((addedNode) => {\n                return addedNode === node || addedNode.contains(node);\n              })) {\n                return;\n              }\n              addedNodes.push(node);\n              connectRemoteNode(node, connection);\n              remoteRecords.push([MUTATION_TYPE_INSERT_CHILD, targetId, serializeRemoteNode(node), position + index]);\n            });\n          } else if (record.type === \"characterData\") {\n            remoteRecords.push([MUTATION_TYPE_UPDATE_TEXT, targetId, record.target.textContent ?? \"\"]);\n          } else if (record.type === \"attributes\" && record.attributeName != null && record.target instanceof Element && !record.target.tagName.includes(\"-\")) {\n            remoteRecords.push([MUTATION_TYPE_UPDATE_PROPERTY, targetId, record.attributeName, record.target.getAttribute(record.attributeName)]);\n          }\n        }\n        connection.mutate(remoteRecords);\n      });\n      this.connection = connection;\n    }\n    /**\n     * Starts watching changes to the element, and communicates changes to the\n     * host environment. By default, this method will also communicate any initial\n     * children of the element to the host environment.\n     */\n    observe(target, options) {\n      REMOTE_IDS.set(target, ROOT_ID);\n      if (options?.initial !== false && target.childNodes.length > 0) {\n        const records = [];\n        for (let i = 0; i < target.childNodes.length; i++) {\n          const node = target.childNodes[i];\n          connectRemoteNode(node, this.connection);\n          records.push([MUTATION_TYPE_INSERT_CHILD, ROOT_ID, serializeRemoteNode(node), i]);\n        }\n        this.connection.mutate(records);\n      }\n      super.observe(target, {\n        subtree: true,\n        childList: true,\n        attributes: true,\n        characterData: true,\n        ...options\n      });\n    }\n  };\n  function indexOf(node, list) {\n    for (let i = 0; i < list.length; i++) {\n      if (list[i] === node) return i;\n    }\n    return -1;\n  }\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/constants.mjs\n  var MESSAGE_CALL = 1;\n  var MESSAGE_CALL_RESULT = 2;\n  var MESSAGE_FUNCTION_CALL = 3;\n  var MESSAGE_FUNCTION_RESULT = 4;\n  var MESSAGE_FUNCTION_RELEASE = 5;\n  var SERIALIZE_METHOD = Symbol.for(\"quilt.threads.serialize\");\n  var TRANSFERABLE = Symbol.for(\"quilt.threads.transferable\");\n\n  // ../../../node_modules/.pnpm/@quilted+events@2.1.3/node_modules/@quilted/events/build/esm/abort/NestedAbortController.mjs\n  var NestedAbortController = class extends AbortController {\n    constructor(...parents) {\n      super();\n      const abortedSignal = parents.find((signal) => signal.aborted);\n      if (abortedSignal) {\n        this.abort(abortedSignal.reason);\n      } else {\n        const abort = (event) => this.abort(event.target.reason);\n        const options = {\n          signal: this.signal\n        };\n        for (const signal of parents) {\n          signal.addEventListener(\"abort\", abort, options);\n        }\n      }\n    }\n  };\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/errors.mjs\n  var ThreadClosedError = class extends Error {\n    constructor() {\n      super(\"You attempted to call a function on a closed thread.\");\n    }\n  };\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/nanoid.mjs\n  var a = \"useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict\";\n  function nanoid(e = 21) {\n    let t = \"\", r = crypto.getRandomValues(new Uint8Array(e));\n    for (let n = 0; n < e; n++) t += a[63 & r[n]];\n    return t;\n  }\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/functions/ThreadFunctionsAutomatic.mjs\n  var _functionsToId, _idsToFunction, _idsToProxy, _finalization, _ThreadFunctionsAutomatic_instances, finalizationRegistry_fn;\n  var ThreadFunctionsAutomatic = class {\n    constructor() {\n      __privateAdd(this, _ThreadFunctionsAutomatic_instances);\n      __privateAdd(this, _functionsToId, /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n      __privateAdd(this, _idsToFunction, /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n      __privateAdd(this, _idsToProxy, /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n      __privateAdd(this, _finalization, /* @__PURE__ */ (() => /* @__PURE__ */ new WeakMap())());\n    }\n    get(id2) {\n      return __privateGet(this, _idsToFunction).get(id2);\n    }\n    release(id2) {\n      const func = __privateGet(this, _idsToFunction).get(id2);\n      if (func) {\n        __privateGet(this, _idsToFunction).delete(id2);\n        __privateGet(this, _functionsToId).delete(func);\n      }\n      return Boolean(func);\n    }\n    serialize(func) {\n      let id2 = __privateGet(this, _functionsToId).get(func);\n      if (id2 == null) {\n        id2 = nanoid();\n        __privateGet(this, _functionsToId).set(func, id2);\n        __privateGet(this, _idsToFunction).set(id2, func);\n      }\n      return id2;\n    }\n    deserialize(id2, thread) {\n      let proxy = __privateGet(this, _idsToProxy).get(id2)?.deref();\n      if (proxy) return proxy;\n      proxy = (...args) => {\n        if (!__privateGet(this, _idsToProxy).has(id2)) {\n          throw new Error(\"You attempted to call a function that was already revoked.\");\n        }\n        return thread.call((callID, args2, transferable) => {\n          thread.messages.send([MESSAGE_FUNCTION_CALL, callID, id2, args2], transferable);\n        }, args);\n      };\n      __privateMethod(this, _ThreadFunctionsAutomatic_instances, finalizationRegistry_fn).call(this, thread)?.register(proxy, id2);\n      __privateGet(this, _idsToProxy).set(id2, new WeakRef(proxy));\n      return proxy;\n    }\n  };\n  _functionsToId = new WeakMap();\n  _idsToFunction = new WeakMap();\n  _idsToProxy = new WeakMap();\n  _finalization = new WeakMap();\n  _ThreadFunctionsAutomatic_instances = new WeakSet();\n  finalizationRegistry_fn = function(thread) {\n    let finalization = __privateGet(this, _finalization).get(thread);\n    if (typeof FinalizationRegistry === \"undefined\") {\n      return void 0;\n    }\n    if (!finalization) {\n      finalization = new FinalizationRegistry((id2) => {\n        thread.messages.send([MESSAGE_FUNCTION_RELEASE, id2]);\n      });\n      __privateGet(this, _finalization).set(thread, finalization);\n    }\n    return finalization;\n  };\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/serialization/shared.mjs\n  function isIterator(value) {\n    return value != null && (Symbol.asyncIterator in value || Symbol.iterator in value) && typeof value.next === \"function\";\n  }\n  function isBasicObject(value) {\n    if (value == null || typeof value !== \"object\") return false;\n    const prototype = Object.getPrototypeOf(value);\n    return prototype == null || prototype === Object.prototype;\n  }\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/serialization/ThreadSerializationStructuredClone.mjs\n  var FUNCTION = \"_@f\";\n  var ASYNC_ITERATOR = \"_@i\";\n  var _customSerializer, _customDeserializer, _ThreadSerializationStructuredClone_instances, serializeInternal_fn, deserializeInternal_fn;\n  var ThreadSerializationStructuredClone = class {\n    constructor(options) {\n      __privateAdd(this, _ThreadSerializationStructuredClone_instances);\n      __privateAdd(this, _customSerializer);\n      __privateAdd(this, _customDeserializer);\n      __privateSet(this, _customSerializer, options?.serialize);\n      __privateSet(this, _customDeserializer, options?.deserialize);\n    }\n    /**\n     * Serializes a value into a structured cloning-compatible format that can be transferred between threads.\n     */\n    serialize(value, thread, transferable) {\n      return __privateMethod(this, _ThreadSerializationStructuredClone_instances, serializeInternal_fn).call(this, value, thread, transferable);\n    }\n    /**\n     * Deserializes a structured cloning-compatible value from another thread.\n     */\n    deserialize(value, thread) {\n      return __privateMethod(this, _ThreadSerializationStructuredClone_instances, deserializeInternal_fn).call(this, value, thread);\n    }\n  };\n  _customSerializer = new WeakMap();\n  _customDeserializer = new WeakMap();\n  _ThreadSerializationStructuredClone_instances = new WeakSet();\n  serializeInternal_fn = function(value, thread, transferable, seen = /* @__PURE__ */ new Map(), isApplyingDefault = false) {\n    if (value == null) return value;\n    if (seen.has(value)) return seen.get(value);\n    seen.set(value, void 0);\n    if (typeof value === \"object\") {\n      if (__privateGet(this, _customSerializer) && !isApplyingDefault) {\n        const customValue = __privateGet(this, _customSerializer).call(this, value, (value2) => __privateMethod(this, _ThreadSerializationStructuredClone_instances, serializeInternal_fn).call(this, value2, thread, transferable, seen, true), thread, transferable);\n        if (customValue !== void 0) {\n          seen.set(value, customValue);\n          return customValue;\n        }\n      }\n      if (value[TRANSFERABLE]) {\n        transferable?.push(value);\n        seen.set(value, value);\n        return value;\n      }\n      const serializeValue = (value2) => {\n        return __privateMethod(this, _ThreadSerializationStructuredClone_instances, serializeInternal_fn).call(this, value2, thread, transferable, seen);\n      };\n      if (typeof value[SERIALIZE_METHOD] === \"function\") {\n        const result = value[SERIALIZE_METHOD]({\n          serialize: serializeValue\n        });\n        seen.set(value, result);\n        return result;\n      }\n      if (Array.isArray(value)) {\n        const result = value.map((item) => serializeValue(item));\n        seen.set(value, result);\n        return result;\n      }\n      if (value instanceof Map) {\n        const entries = [...value.entries()].map(([key, value2]) => {\n          return [serializeValue(key), serializeValue(value2)];\n        });\n        const result = new Map(entries);\n        seen.set(value, result);\n        return result;\n      }\n      if (value instanceof Set) {\n        const entries = [...value].map((entry) => serializeValue(entry));\n        const result = new Set(entries);\n        seen.set(value, result);\n        return result;\n      }\n      const valueIsIterator = isIterator(value);\n      if (isBasicObject(value) || valueIsIterator) {\n        const result = {};\n        for (const key of Object.keys(value)) {\n          result[key] = serializeValue(value[key]);\n        }\n        if (valueIsIterator) {\n          result.next ?? (result.next = serializeValue(value.next.bind(value)));\n          result.return ?? (result.return = serializeValue(value.return.bind(value)));\n          result.throw ?? (result.throw = serializeValue(value.throw.bind(value)));\n          result[ASYNC_ITERATOR] = true;\n        }\n        seen.set(value, result);\n        return result;\n      }\n    }\n    if (typeof value === \"function\") {\n      const serialized = thread.functions.serialize(value, thread, transferable);\n      const result = {\n        [FUNCTION]: serialized\n      };\n      seen.set(value, result);\n      return result;\n    }\n    seen.set(value, value);\n    return value;\n  };\n  deserializeInternal_fn = function(value, thread, isApplyingDefault = false) {\n    if (value == null) return value;\n    if (typeof value === \"object\") {\n      if (__privateGet(this, _customDeserializer) && !isApplyingDefault) {\n        const customValue = __privateGet(this, _customDeserializer).call(this, value, (value2) => __privateMethod(this, _ThreadSerializationStructuredClone_instances, deserializeInternal_fn).call(this, value2, thread, true), thread);\n        if (customValue !== void 0) {\n          return customValue;\n        }\n      }\n      if (value == null) {\n        return value;\n      }\n      if (Array.isArray(value)) {\n        return value.map((value2) => __privateMethod(this, _ThreadSerializationStructuredClone_instances, deserializeInternal_fn).call(this, value2, thread));\n      }\n      if (value instanceof Map) {\n        return new Map([...value].map(([key, value2]) => [__privateMethod(this, _ThreadSerializationStructuredClone_instances, deserializeInternal_fn).call(this, key, thread), __privateMethod(this, _ThreadSerializationStructuredClone_instances, deserializeInternal_fn).call(this, value2, thread)]));\n      }\n      if (value instanceof Set) {\n        return new Set([...value].map((entry) => __privateMethod(this, _ThreadSerializationStructuredClone_instances, deserializeInternal_fn).call(this, entry, thread)));\n      }\n      if (FUNCTION in value) {\n        const func = thread.functions.deserialize(value[FUNCTION], thread);\n        return func;\n      }\n      if (!isBasicObject(value)) {\n        return value;\n      }\n      const result = {};\n      for (const key of Object.keys(value)) {\n        if (key === ASYNC_ITERATOR) {\n          result[Symbol.asyncIterator] = () => result;\n        } else {\n          result[key] = __privateMethod(this, _ThreadSerializationStructuredClone_instances, deserializeInternal_fn).call(this, value[key], thread);\n        }\n      }\n      return result;\n    }\n    return value;\n  };\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/Thread.mjs\n  var _abort, _idsToResolver, _Thread_instances, callLocal_fn, handlerForCall_fn, resolveCall_fn, waitForResult_fn;\n  var Thread = class {\n    constructor(messages, {\n      imports,\n      exports,\n      functions = new ThreadFunctionsAutomatic(),\n      serialization = new ThreadSerializationStructuredClone(),\n      signal\n    } = {}) {\n      __privateAdd(this, _Thread_instances);\n      __privateAdd(this, _abort);\n      __privateAdd(this, _idsToResolver, /* @__PURE__ */ (() => /* @__PURE__ */ new Map())());\n      this.messages = messages;\n      __privateSet(this, _abort, signal ? new NestedAbortController(signal) : new AbortController());\n      this.exports = exports ?? {};\n      this.imports = createThreadImports(__privateMethod(this, _Thread_instances, handlerForCall_fn).bind(this), imports);\n      this.functions = functions;\n      this.serialization = serialization;\n      this.functions.start?.(this);\n      this.serialization.start?.(this);\n      this.signal.addEventListener(\"abort\", () => {\n        for (const id2 of __privateGet(this, _idsToResolver).keys()) {\n          __privateMethod(this, _Thread_instances, resolveCall_fn).call(this, id2, void 0, new ThreadClosedError());\n        }\n        __privateGet(this, _idsToResolver).clear();\n      }, {\n        once: true\n      });\n      messages.listen(async (rawData) => {\n        const isThreadMessageData = Array.isArray(rawData) && typeof rawData[0] === \"number\";\n        if (!isThreadMessageData) {\n          return;\n        }\n        const data = rawData;\n        switch (data[0]) {\n          case MESSAGE_CALL: {\n            const [, id2, property, args] = data;\n            const func = this.exports[property] ?? (() => {\n              throw new Error(`No '${property}' method is exported from this thread`);\n            });\n            await __privateMethod(this, _Thread_instances, callLocal_fn).call(this, func, args, (value, error, transferable) => {\n              this.messages.send([MESSAGE_CALL_RESULT, id2, value, error], transferable);\n            });\n            break;\n          }\n          case MESSAGE_FUNCTION_CALL: {\n            const [, callID, funcID, args] = data;\n            const func = this.functions.get(funcID, this) ?? missingThreadFunction;\n            await __privateMethod(this, _Thread_instances, callLocal_fn).call(this, func, args, (value, error, transferable) => {\n              this.messages.send([MESSAGE_FUNCTION_RESULT, callID, value, error], transferable);\n            });\n            break;\n          }\n          case MESSAGE_CALL_RESULT:\n          case MESSAGE_FUNCTION_RESULT: {\n            __privateMethod(this, _Thread_instances, resolveCall_fn).call(this, ...data.slice(1));\n            break;\n          }\n          case MESSAGE_FUNCTION_RELEASE: {\n            const id2 = data[1];\n            this.functions.release(id2, this);\n            break;\n          }\n        }\n      }, {\n        signal: this.signal\n      });\n    }\n    /**\n     * An object that exposes the methods that can be called on the paired thread.\n     * This object will automatically encode and decode arguments and return values\n     * as necessary.\n     */\n    /**\n     * An object that exposes the methods that can be called on this thread by the\n     * paired thread. To set these methods, pass the `exports` option when creating\n     * a new `Thread`.\n     */\n    /**\n     * An object that provides the message-passing interface that allows communication\n     * to flow between environments.\n     */\n    /**\n     * An object that manages how functions are proxied between threads.\n     */\n    /**\n     * An object that manages how values are serialized and deserialized between threads.\n     */\n    /**\n     * An `AbortSignal` that indicates whether the communication channel is still open.\n     */\n    get signal() {\n      return __privateGet(this, _abort).signal;\n    }\n    /**\n     * A boolean indicating whether the communication channel is still open.\n     */\n    get closed() {\n      return __privateGet(this, _abort).signal.aborted;\n    }\n    /**\n     * Closes the communication channel between the two threads. This will prevent\n     * any further communication between the threads, and will clean up any memory\n     * associated with in-progress communication. It will also reject any inflight\n     * function calls between threads with a `ThreadClosedError`.\n     */\n    close() {\n      __privateGet(this, _abort).abort();\n    }\n    /**\n     * Requests that the thread provide the context needed to make a function\n     * call between threads. You provide this method a function to call and the\n     * unserialized arguments you wish to call it with, and the thread will call\n     * the function you provided with a serialized call ID, the serialized arguments,\n     * and any transferable objects that need to be passed between threads.\n     */\n    call(func, args) {\n      if (this.closed) {\n        return Promise.reject(new ThreadClosedError());\n      }\n      const transferable = [];\n      const serialized = this.serialization.serialize(args, this, transferable);\n      const id2 = nanoid();\n      const done = __privateMethod(this, _Thread_instances, waitForResult_fn).call(this, id2);\n      func(id2, serialized, transferable);\n      return done;\n    }\n  };\n  _abort = new WeakMap();\n  _idsToResolver = new WeakMap();\n  _Thread_instances = new WeakSet();\n  callLocal_fn = async function(func, args, withResult) {\n    try {\n      const result = this.functions.call ? await this.functions.call(func, args, this) : await func(...this.serialization.deserialize(args, this));\n      const transferable = [];\n      const serialized = this.serialization.serialize(result, this, transferable);\n      withResult(serialized, void 0, transferable);\n    } catch (error) {\n      withResult(void 0, this.serialization.serialize(error, this));\n    }\n  };\n  handlerForCall_fn = function(property) {\n    return (...args) => {\n      try {\n        if (typeof property !== \"string\" && typeof property !== \"number\") {\n          throw new Error(`Can\u2019t call a symbol method on a thread: ${property.toString()}`);\n        }\n        return this.call((id2, serializedArgs, transferable) => {\n          this.messages.send([MESSAGE_CALL, id2, property, serializedArgs], transferable);\n        }, args);\n      } catch (error) {\n        return Promise.reject(error);\n      }\n    };\n  };\n  resolveCall_fn = function(...args) {\n    const callID = args[0];\n    const resolver = __privateGet(this, _idsToResolver).get(callID);\n    if (resolver) {\n      resolver(...args);\n      __privateGet(this, _idsToResolver).delete(callID);\n    }\n  };\n  waitForResult_fn = function(id2) {\n    const promise = new Promise((resolve, reject) => {\n      __privateGet(this, _idsToResolver).set(id2, (_, value, error) => {\n        if (error == null) {\n          resolve(this.serialization.deserialize(value, this));\n        } else {\n          reject(this.serialization.deserialize(error, this));\n        }\n      });\n    });\n    Object.defineProperty(promise, Symbol.asyncIterator, {\n      async *value() {\n        const result = await promise;\n        Object.defineProperty(result, Symbol.asyncIterator, {\n          value: () => result\n        });\n        yield* result;\n      }\n    });\n    return promise;\n  };\n  function createThreadImports(handlerForImport, imported) {\n    let call;\n    if (imported == null) {\n      if (typeof Proxy !== \"function\") {\n        throw new Error(`You must pass an array of callable methods in environments without Proxies.`);\n      }\n      const cache = /* @__PURE__ */ new Map();\n      call = new Proxy({}, {\n        get(_target, property) {\n          if (cache.has(property)) {\n            return cache.get(property);\n          }\n          const handler = handlerForImport(property);\n          cache.set(property, handler);\n          return handler;\n        }\n      });\n    } else {\n      call = {};\n      for (const method of imported) {\n        Object.defineProperty(call, method, {\n          value: handlerForImport(method),\n          writable: false,\n          configurable: true,\n          enumerable: true\n        });\n      }\n    }\n    return call;\n  }\n  function missingThreadFunction() {\n    throw new Error(`You attempted to call a function that is not stored. It may have already been released.`);\n  }\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/threads/window/shared.mjs\n  var CHECK_MESSAGE = \"quilt.threads.ping\";\n  var RESPONSE_MESSAGE = \"quilt.threads.pong\";\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/threads/window/ThreadNestedWindow.mjs\n  function nestedWindowToThreadTarget(parent, {\n    targetOrigin = \"*\"\n  } = {}) {\n    const ready = () => {\n      const respond = () => parent.postMessage(RESPONSE_MESSAGE, targetOrigin);\n      self.addEventListener(\"message\", ({\n        data,\n        source\n      }) => {\n        if (source !== parent) return;\n        if (data === CHECK_MESSAGE) respond();\n      });\n      respond();\n    };\n    if (document.readyState === \"complete\") {\n      ready();\n    } else {\n      document.addEventListener(\"readystatechange\", () => {\n        if (document.readyState === \"complete\") {\n          ready();\n        }\n      });\n    }\n    return {\n      send(message, transfer) {\n        return parent.postMessage(message, targetOrigin, transfer);\n      },\n      listen(listen, {\n        signal\n      }) {\n        self.addEventListener(\"message\", (event) => {\n          if (event.data === CHECK_MESSAGE) return;\n          listen(event.data);\n        }, {\n          signal\n        });\n      }\n    };\n  }\n\n  // ../../../node_modules/.pnpm/@quilted+threads@3.1.3_@preact+signals-core@1.10.0/node_modules/@quilted/threads/build/esm/threads/ThreadNestedIframe.mjs\n  var ThreadNestedIframe = class extends Thread {\n    constructor({\n      parent = globalThis.parent,\n      targetOrigin = \"*\",\n      ...options\n    } = {}) {\n      if (typeof self === \"undefined\" || parent == null) {\n        throw new Error(\"You are not inside an iframe, because there is no parent window.\");\n      }\n      super(nestedWindowToThreadTarget(parent, {\n        targetOrigin\n      }), options);\n      this.parent = parent;\n    }\n  };\n\n  // scripts/iframe-entry.js\n  new ThreadNestedIframe({\n    exports: {\n      async render(options, receiver, hostApi) {\n        if (options.remoteElements) {\n          options.remoteElements.forEach((def) => {\n            if (customElements.get(def.tagName)) return;\n            const remoteElement = class extends RemoteElement {\n              static get remoteAttributes() {\n                return def.remoteAttributes || [];\n              }\n              static get remoteEvents() {\n                return def.remoteEvents || [];\n              }\n            };\n            Object.defineProperty(remoteElement, \"name\", {\n              value: `Remote${def.tagName.replace(\n                /(^w|-w)/g,\n                (c) => c.replace(\"-\", \"\").toUpperCase()\n              )}`\n            });\n            customElements.define(def.tagName, remoteElement);\n          });\n        }\n        const root = document.querySelector(\"#root\");\n        const observer = new RemoteMutationObserver(receiver);\n        observer.observe(root);\n        const { code } = options;\n        if (code && root) {\n          try {\n            const scriptFunction = new Function(\"root\", \"console\", code);\n            scriptFunction(root, console);\n          } catch (e) {\n            console.error(\"Error executing remote script:\", e);\n          }\n        }\n      }\n    }\n  });\n})();\n\n  </script>\n</body>\n</html>";
//# sourceMappingURL=iframe-bundle.d.ts.map