import { updateRemoteElementProperty } from '../internals.mjs';

function remoteProperty(definition) {
  return (target, context) => {
    const property = context.name;
    context.addInitializer(function defineProperty() {
      this.constructor.createProperty(property, definition);
    });
    return {
      set(value) {
        target.set.call(this, value);
        updateRemoteElementProperty(this, property, value);
      },
      init(value) {
        updateRemoteElementProperty(this, property, value);
        return value;
      }
    };
  };
}

export { remoteProperty };
