'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const Event = require('./Event.cjs');

// https://w3c.github.io/clipboard-apis/#clipboardevent-interface
class ClipboardEvent extends Event.Event {
  constructor(type, eventInitDict = {}) {
    super(type, eventInitDict);
    this.clipboardData = eventInitDict.clipboardData ?? null;
  }
}

exports.ClipboardEvent = ClipboardEvent;
