/*-
 * Copyright 2003 John-Mark Gurney.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: mime.h,v 1.4 2003/09/15 23:37:19 jmg Exp $
 *
 */

#ifndef _MIME_H_
#define _MIME_H_

struct mime_header;
struct mime_message;

/* mime_header routines */
const char *mime_getvalue(struct mime_header *, const char *);
const char *mime_getvaluec(struct mime_header *, const char *, int *);
/* general mime parser routines */
struct mime_header *mime_parseheader(const char *, size_t, const char **, const char *);
void mime_headerdelete(struct mime_header *);

/* mime_message */
struct mime_message *mime_readmessage(const char *, size_t, const char *);
struct mime_message **mime_parsemultipart(const char *, size_t, const char *, int *, const char **, const char *);
struct mime_header *mime_getmsgheaders(struct mime_message *);
const char *mime_getmsgbody(struct mime_message *);
int mime_getmsgbodylen(struct mime_message *);
struct mime_message *mime_getattachment(struct mime_message *, int);
int mime_nattachment(struct mime_message *);
const char *mime_getmsgprolog(struct mime_message *);
int mime_getmsgprologlen(struct mime_message *);
const char *mime_getmsgepilog(struct mime_message *);
int mime_getmsgepiloglen(struct mime_message *);

int mime_estimaterawsize(struct mime_message *);
int mime_getrawbody(struct mime_message *, char *, int);

#endif /* _MIME_H_ */
