/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: FuncTransformOps.td                                                  *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir::transform {

/// Collects patterns that convert Func dialect ops to LLVM dialect ops.
///     These patterns require an "LLVMTypeConverter".
class ApplyFuncToLLVMConversionPatternsOp;

} // namespace mlir::transform
namespace mlir::transform {

/// Casts values to the signature of a function and replaces them with a call
/// This transform takes value handles to a set of `inputs` and `outputs` and
///     attempts to cast them to the function signature of the attached function
///     op, then builds a call to the function and replaces the users of the
///     outputs. It is the responsibility of the user to ensure that the slice of
///     the program replaced by this operation makes sense, i.e. there is no
///     verification that the inputs to this operation have any relation to the
///     outputs outside of basic dominance requirements needed for the call.
/// 
///     The casting materialization functions are specified in the graph region of
///     this op. They must implement the `TypeConverterBuilderOpInterface`. The
///     order of ops within the region is irrelevant.
/// 
///     The target function can be specified by a symbol name or by a handle to the
///     operation.
/// 
///     This transform only reads the operand handles and only replaces the users of
///     the outputs with the results of the call. No handles are consumed and no
///     operations are removed. Users are expected to run cleanup separately if
///     desired.
/// 
///     Warning: The replacement of the uses of the outputs could invalidate certain
///     restricted value handle types (e.g. `transform.block_arg` if it existed, by
///     replacing the use with something not coming from a block argument). The
///     value will still exist in such cases but wouldn't verify against the type.
///     See the discussion here for more information:
///     https://github.com/llvm/llvm-project/pull/78398#discussion_r1455070087
/// 
///     This transform will emit a silenceable failure if:
///      - The set of outputs isn't unique
///      - The handle for the insertion point does not include exactly one operation
///      - The insertion point op does not dominate any of the output users
///      - The insertion point op is not dominated by any of the inputs
///      - The function signature does not match the number of inputs/outputs
/// 
///     This transform will emit a definite failure if it fails to resolve the
///     target function, or if it fails to materialize the conversion casts of
///     either the inputs to the function argument types, or the call results to
///     the output types.
class CastAndCallOp;

} // namespace mlir::transform
namespace mlir::transform {

/// This transform takes a module and a function name, and deduplicates
///       the arguments of the function. The function is expected to be defined in
///       the module.
/// 
///       This transform will emit a silenceable failure if:
///        - The function with the given name does not exist in the module.
///        - The function does not have duplicate arguments.
///        - The function does not have a single call.
class DeduplicateFuncArgsOp;

} // namespace mlir::transform
namespace mlir::transform {

/// This transform takes a module and a function name, and replaces the
///       signature of the function by reordering the arguments and results
///       according to the interchange arrays. The function is expected to be
///       defined in the module, and the interchange arrays must match the number
///       of arguments and results of the function.
/// 
///       The `adjust_func_calls` attribute indicates whether the function calls
///       should be adjusted to match the new signature. If set to `true`, the
///       function calls will be adjusted to match the new signature, otherwise
///       they will not be adjusted.
/// 
///       This transform will emit a silenceable failure if:
///        - The function with the given name does not exist in the module.
///        - The interchange arrays do not match the number of arguments/results.
///        - The interchange arrays contain out of bound indices.
class ReplaceFuncSignatureOp;

} // namespace mlir::transform
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::ApplyFuncToLLVMConversionPatternsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ApplyFuncToLLVMConversionPatternsOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ApplyFuncToLLVMConversionPatternsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.apply_conversion_patterns.func.func_to_llvm", odsAttrs.getContext());
  }

  ApplyFuncToLLVMConversionPatternsOpGenericAdaptorBase(ApplyFuncToLLVMConversionPatternsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ApplyFuncToLLVMConversionPatternsOpGenericAdaptor : public detail::ApplyFuncToLLVMConversionPatternsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ApplyFuncToLLVMConversionPatternsOpGenericAdaptorBase;
public:
  ApplyFuncToLLVMConversionPatternsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ApplyFuncToLLVMConversionPatternsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ApplyFuncToLLVMConversionPatternsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ApplyFuncToLLVMConversionPatternsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ApplyFuncToLLVMConversionPatternsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ApplyFuncToLLVMConversionPatternsOpGenericAdaptor(RangeT values, const ApplyFuncToLLVMConversionPatternsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ApplyFuncToLLVMConversionPatternsOp, typename = std::enable_if_t<std::is_same_v<LateInst, ApplyFuncToLLVMConversionPatternsOp>>>
  ApplyFuncToLLVMConversionPatternsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ApplyFuncToLLVMConversionPatternsOpAdaptor : public ApplyFuncToLLVMConversionPatternsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ApplyFuncToLLVMConversionPatternsOpGenericAdaptor::ApplyFuncToLLVMConversionPatternsOpGenericAdaptor;
  ApplyFuncToLLVMConversionPatternsOpAdaptor(ApplyFuncToLLVMConversionPatternsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ApplyFuncToLLVMConversionPatternsOp : public ::mlir::Op<ApplyFuncToLLVMConversionPatternsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::transform::ConversionPatternDescriptorOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ApplyFuncToLLVMConversionPatternsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ApplyFuncToLLVMConversionPatternsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::transform::ConversionPatternDescriptorOpInterface::Trait<ApplyFuncToLLVMConversionPatternsOp>::populateConversionTargetRules;
  using ::mlir::transform::ConversionPatternDescriptorOpInterface::Trait<ApplyFuncToLLVMConversionPatternsOp>::getTypeConverter;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.apply_conversion_patterns.func.func_to_llvm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static ApplyFuncToLLVMConversionPatternsOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static ApplyFuncToLLVMConversionPatternsOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static ApplyFuncToLLVMConversionPatternsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static ApplyFuncToLLVMConversionPatternsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ApplyFuncToLLVMConversionPatternsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ApplyFuncToLLVMConversionPatternsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ApplyFuncToLLVMConversionPatternsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ApplyFuncToLLVMConversionPatternsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void populatePatterns(::mlir::TypeConverter &typeConverter, ::mlir::RewritePatternSet &patterns);
  ::llvm::LogicalResult verifyTypeConverter(TypeConverterBuilderOpInterface builder);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::ApplyFuncToLLVMConversionPatternsOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::CastAndCallOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CastAndCallOpGenericAdaptorBase {
public:
  struct Properties {
    using function_nameTy = ::mlir::SymbolRefAttr;
    function_nameTy function_name;

    auto getFunctionName() const {
      auto &propStorage = this->function_name;
      return ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(propStorage);
    }
    void setFunctionName(const ::mlir::SymbolRefAttr &propValue) {
      this->function_name = propValue;
    }
    using insert_afterTy = ::mlir::UnitAttr;
    insert_afterTy insert_after;

    auto getInsertAfter() const {
      auto &propStorage = this->insert_after;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setInsertAfter(const ::mlir::UnitAttr &propValue) {
      this->insert_after = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.function_name == this->function_name &&
        rhs.insert_after == this->insert_after &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CastAndCallOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.func.cast_and_call", odsAttrs.getContext());
  }

  CastAndCallOpGenericAdaptorBase(CastAndCallOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getInsertAfterAttr();
  bool getInsertAfter();
  ::mlir::SymbolRefAttr getFunctionNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(getProperties().function_name);
    return attr;
  }

  ::std::optional< ::mlir::SymbolRefAttr > getFunctionName();
  ::mlir::Region &getConversions() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class CastAndCallOpGenericAdaptor : public detail::CastAndCallOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CastAndCallOpGenericAdaptorBase;
  static constexpr int odsIndex_insertion_point = 0;
  static constexpr int odsIndex_inputs = 1;
  static constexpr int odsIndex_outputs = 2;
  static constexpr int odsIndex_function = 3;
public:
  CastAndCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CastAndCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CastAndCallOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CastAndCallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : CastAndCallOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CastAndCallOpGenericAdaptor(RangeT values, const CastAndCallOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CastAndCallOp, typename = std::enable_if_t<std::is_same_v<LateInst, CastAndCallOp>>>
  CastAndCallOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInsertionPoint() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInputs() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getOutputs() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getFunction() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CastAndCallOpAdaptor : public CastAndCallOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CastAndCallOpGenericAdaptor::CastAndCallOpGenericAdaptor;
  CastAndCallOpAdaptor(CastAndCallOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CastAndCallOp : public ::mlir::Op<CastAndCallOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::transform::TransformHandleTypeInterface>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::NoTerminator, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::transform::ReportTrackingListenerFailuresOpTrait, ::mlir::RegionKindInterface::Trait, ::mlir::OpTrait::HasOnlyGraphRegion> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CastAndCallOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CastAndCallOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_insertion_point = 0;
  static constexpr int odsIndex_inputs = 1;
  static constexpr int odsIndex_outputs = 2;
  static constexpr int odsIndex_function = 3;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::transform::TransformOpInterface::Trait<CastAndCallOp>::allowsRepeatedHandleOperands;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("function_name"), ::llvm::StringRef("insert_after"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFunctionNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFunctionNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getInsertAfterAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getInsertAfterAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.func.cast_and_call");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getInsertionPoint() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface> getInputs() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface>{} : ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface> getOutputs() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface>{} : ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformValueHandleTypeInterface>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getFunction() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>{} : ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*operands.begin());
  }

  ::mlir::OpOperand &getInsertionPointMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getInputsMutable();
  ::mlir::MutableOperandRange getOutputsMutable();
  ::mlir::MutableOperandRange getFunctionMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(0).begin());
  }

  ::mlir::Region &getConversions() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getInsertAfterAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().insert_after);
  }

  bool getInsertAfter();
  ::mlir::SymbolRefAttr getFunctionNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(getProperties().function_name);
  }

  ::std::optional< ::mlir::SymbolRefAttr > getFunctionName();
  void setInsertAfterAttr(::mlir::UnitAttr attr) {
    getProperties().insert_after = attr;
  }

  void setInsertAfter(bool attrValue);
  void setFunctionNameAttr(::mlir::SymbolRefAttr attr) {
    getProperties().function_name = attr;
  }

  ::mlir::Attribute removeInsertAfterAttr() {
      auto attr = getProperties().insert_after;
      getProperties().insert_after = {};
      return attr;
  }

  ::mlir::Attribute removeFunctionNameAttr() {
      auto attr = getProperties().function_name;
      getProperties().function_name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static CastAndCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static CastAndCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static CastAndCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static CastAndCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static CastAndCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static CastAndCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static CastAndCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static CastAndCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CastAndCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CastAndCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CastAndCallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CastAndCallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::DiagnosedSilenceableFailure apply(::mlir::transform::TransformRewriter &rewriter, ::mlir::transform::TransformResults &transformResults, ::mlir::transform::TransformState &state);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::CastAndCallOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::DeduplicateFuncArgsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DeduplicateFuncArgsOpGenericAdaptorBase {
public:
  struct Properties {
    using function_nameTy = ::mlir::SymbolRefAttr;
    function_nameTy function_name;

    auto getFunctionName() const {
      auto &propStorage = this->function_name;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setFunctionName(const ::mlir::SymbolRefAttr &propValue) {
      this->function_name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.function_name == this->function_name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeduplicateFuncArgsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.func.deduplicate_func_args", odsAttrs.getContext());
  }

  DeduplicateFuncArgsOpGenericAdaptorBase(DeduplicateFuncArgsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getFunctionNameAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().function_name);
    return attr;
  }

  ::mlir::SymbolRefAttr getFunctionName();
};

} // namespace detail
template <typename RangeT>
class DeduplicateFuncArgsOpGenericAdaptor : public detail::DeduplicateFuncArgsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeduplicateFuncArgsOpGenericAdaptorBase;
  static constexpr int odsIndex_module = 0;
public:
  DeduplicateFuncArgsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeduplicateFuncArgsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeduplicateFuncArgsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeduplicateFuncArgsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DeduplicateFuncArgsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeduplicateFuncArgsOpGenericAdaptor(RangeT values, const DeduplicateFuncArgsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeduplicateFuncArgsOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeduplicateFuncArgsOp>>>
  DeduplicateFuncArgsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getModule() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeduplicateFuncArgsOpAdaptor : public DeduplicateFuncArgsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeduplicateFuncArgsOpGenericAdaptor::DeduplicateFuncArgsOpGenericAdaptor;
  DeduplicateFuncArgsOpAdaptor(DeduplicateFuncArgsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeduplicateFuncArgsOp : public ::mlir::Op<DeduplicateFuncArgsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeduplicateFuncArgsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeduplicateFuncArgsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_module = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::transform::TransformOpInterface::Trait<DeduplicateFuncArgsOp>::allowsRepeatedHandleOperands;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("function_name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFunctionNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFunctionNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.func.deduplicate_func_args");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getModule() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getModuleMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTransformedModule() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTransformedFunction() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getFunctionNameAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().function_name);
  }

  ::mlir::SymbolRefAttr getFunctionName();
  void setFunctionNameAttr(::mlir::SymbolRefAttr attr) {
    getProperties().function_name = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name);
  static DeduplicateFuncArgsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name);
  static DeduplicateFuncArgsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name);
  static DeduplicateFuncArgsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name);
  static DeduplicateFuncArgsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeduplicateFuncArgsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeduplicateFuncArgsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeduplicateFuncArgsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeduplicateFuncArgsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::DiagnosedSilenceableFailure apply(::mlir::transform::TransformRewriter &rewriter, ::mlir::transform::TransformResults &transformResults, ::mlir::transform::TransformState &state);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::DeduplicateFuncArgsOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::ReplaceFuncSignatureOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ReplaceFuncSignatureOpGenericAdaptorBase {
public:
  struct Properties {
    using adjust_func_callsTy = ::mlir::UnitAttr;
    adjust_func_callsTy adjust_func_calls;

    auto getAdjustFuncCalls() const {
      auto &propStorage = this->adjust_func_calls;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setAdjustFuncCalls(const ::mlir::UnitAttr &propValue) {
      this->adjust_func_calls = propValue;
    }
    using args_interchangeTy = ::mlir::DenseI32ArrayAttr;
    args_interchangeTy args_interchange;

    auto getArgsInterchange() const {
      auto &propStorage = this->args_interchange;
      return ::llvm::cast<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setArgsInterchange(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->args_interchange = propValue;
    }
    using function_nameTy = ::mlir::SymbolRefAttr;
    function_nameTy function_name;

    auto getFunctionName() const {
      auto &propStorage = this->function_name;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setFunctionName(const ::mlir::SymbolRefAttr &propValue) {
      this->function_name = propValue;
    }
    using results_interchangeTy = ::mlir::DenseI32ArrayAttr;
    results_interchangeTy results_interchange;

    auto getResultsInterchange() const {
      auto &propStorage = this->results_interchange;
      return ::llvm::cast<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setResultsInterchange(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->results_interchange = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.adjust_func_calls == this->adjust_func_calls &&
        rhs.args_interchange == this->args_interchange &&
        rhs.function_name == this->function_name &&
        rhs.results_interchange == this->results_interchange &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ReplaceFuncSignatureOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("transform.func.replace_func_signature", odsAttrs.getContext());
  }

  ReplaceFuncSignatureOpGenericAdaptorBase(ReplaceFuncSignatureOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getFunctionNameAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().function_name);
    return attr;
  }

  ::mlir::SymbolRefAttr getFunctionName();
  ::mlir::DenseI32ArrayAttr getArgsInterchangeAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().args_interchange);
    return attr;
  }

  ::llvm::ArrayRef<int32_t> getArgsInterchange();
  ::mlir::DenseI32ArrayAttr getResultsInterchangeAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().results_interchange);
    return attr;
  }

  ::llvm::ArrayRef<int32_t> getResultsInterchange();
  ::mlir::UnitAttr getAdjustFuncCallsAttr();
  bool getAdjustFuncCalls();
};

} // namespace detail
template <typename RangeT>
class ReplaceFuncSignatureOpGenericAdaptor : public detail::ReplaceFuncSignatureOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ReplaceFuncSignatureOpGenericAdaptorBase;
  static constexpr int odsIndex_module = 0;
public:
  ReplaceFuncSignatureOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ReplaceFuncSignatureOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ReplaceFuncSignatureOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ReplaceFuncSignatureOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ReplaceFuncSignatureOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ReplaceFuncSignatureOpGenericAdaptor(RangeT values, const ReplaceFuncSignatureOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ReplaceFuncSignatureOp, typename = std::enable_if_t<std::is_same_v<LateInst, ReplaceFuncSignatureOp>>>
  ReplaceFuncSignatureOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getModule() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ReplaceFuncSignatureOpAdaptor : public ReplaceFuncSignatureOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ReplaceFuncSignatureOpGenericAdaptor::ReplaceFuncSignatureOpGenericAdaptor;
  ReplaceFuncSignatureOpAdaptor(ReplaceFuncSignatureOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ReplaceFuncSignatureOp : public ::mlir::Op<ReplaceFuncSignatureOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::transform::TransformOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ReplaceFuncSignatureOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ReplaceFuncSignatureOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_module = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::transform::TransformOpInterface::Trait<ReplaceFuncSignatureOp>::allowsRepeatedHandleOperands;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("adjust_func_calls"), ::llvm::StringRef("args_interchange"), ::llvm::StringRef("function_name"), ::llvm::StringRef("results_interchange")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAdjustFuncCallsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAdjustFuncCallsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getArgsInterchangeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getArgsInterchangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFunctionNameAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFunctionNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getResultsInterchangeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getResultsInterchangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("transform.func.replace_func_signature");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getModule() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getModuleMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTransformedModule() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(0).begin());
  }

  ::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface> getTransformedFunction() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::transform::TransformHandleTypeInterface>>(*getODSResults(1).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getFunctionNameAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().function_name);
  }

  ::mlir::SymbolRefAttr getFunctionName();
  ::mlir::DenseI32ArrayAttr getArgsInterchangeAttr() {
    return ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().args_interchange);
  }

  ::llvm::ArrayRef<int32_t> getArgsInterchange();
  ::mlir::DenseI32ArrayAttr getResultsInterchangeAttr() {
    return ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().results_interchange);
  }

  ::llvm::ArrayRef<int32_t> getResultsInterchange();
  ::mlir::UnitAttr getAdjustFuncCallsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().adjust_func_calls);
  }

  bool getAdjustFuncCalls();
  void setFunctionNameAttr(::mlir::SymbolRefAttr attr) {
    getProperties().function_name = attr;
  }

  void setArgsInterchangeAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().args_interchange = attr;
  }

  void setArgsInterchange(::llvm::ArrayRef<int32_t> attrValue);
  void setResultsInterchangeAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().results_interchange = attr;
  }

  void setResultsInterchange(::llvm::ArrayRef<int32_t> attrValue);
  void setAdjustFuncCallsAttr(::mlir::UnitAttr attr) {
    getProperties().adjust_func_calls = attr;
  }

  void setAdjustFuncCalls(bool attrValue);
  ::mlir::Attribute removeAdjustFuncCallsAttr() {
      auto attr = getProperties().adjust_func_calls;
      getProperties().adjust_func_calls = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls = nullptr);
  static ReplaceFuncSignatureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls = nullptr);
  static ReplaceFuncSignatureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls = nullptr);
  static ReplaceFuncSignatureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls = nullptr);
  static ReplaceFuncSignatureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls = false);
  static ReplaceFuncSignatureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls = false);
  static ReplaceFuncSignatureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls = false);
  static ReplaceFuncSignatureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls = false);
  static ReplaceFuncSignatureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReplaceFuncSignatureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReplaceFuncSignatureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReplaceFuncSignatureOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReplaceFuncSignatureOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::DiagnosedSilenceableFailure apply(::mlir::transform::TransformRewriter &rewriter, ::mlir::transform::TransformResults &transformResults, ::mlir::transform::TransformState &state);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::transform
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::transform::ReplaceFuncSignatureOp)


#endif // GET_OP_CLASSES

