# v7.2

This release brings several improvements for scripting environments in Javascript/Typescript and Python support. Core features include the new `--copy` flag for aliases to inherit shell configuration, and bugfixes to address autocomplete panics, expression error handling, and 3rd party integration issues.

## Breaking Changes

None

## v7.2.xxxx

### Features

* `alias`: new `--copy` flag to inherit shell configuration from aliased commands ([issue](https://github.com/lmorg/murex/issues/872))
* `args`: `StrictFlagPlacement` and `--` separator
* `fid-list`: rewrite to support filtering
* core: allow filterable function table
* cache.db: don't cache anything with a TTL < 1hr
* integrations: `yarn` refactor
* integrations: Python `uv` support
* integrations: Python virtual environment improvements ([issue](https://github.com/lmorg/murex/issues/960))
* integrations: `terraform-docs` summary
* makefile: add tags to make test
* wasm: support for builds via tinygo (EXPERIMENTAL)
* chore: update dependencies

### Bug Fixes

* autocomplete: fix panic when JSON struct is zero-length ([issue](https://github.com/lmorg/murex/issues/953))
* `foreach`: fix regression bug in `--parallel` after args rewrite
* escape builtins: use `IsMethod()` instead of `Parameters.Len()` ([issue](https://github.com/lmorg/murex/issues/857))
* integrations: `yarn` bug fix - resolve initialization hang with corepack ([issue](https://github.com/lmorg/murex/issues/956))
* expressions: caught error wasn't being returned correctly
* core: temp directory value is now immutable ([issue](https://github.com/lmorg/murex/issues/864))

## Special Thanks

Thank yous for this release go to [@priscira](https://github.com/priscira), [@lokalius](https://github.com/lokalius) and [@fyrak1s](https://github.com/fyrak1s), for your testing and feedback.

Also thank you to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) and all who raise bug reports.

You rock!

<hr>

Published: 01.02.2026 at 12:00

## See Also

* [Alias "shortcut": `alias`](../commands/alias.md):
  Create an alias for a command
* [Define Function Arguments: `args`](../commands/args.md):
  Command line flag parser for Murex shell scripting
* [Display Running Functions: `fid-list`](../commands/fid-list.md):
  Lists all running functions within the current Murex session
* [How To Contribute](../Murex/CONTRIBUTING.md):
  Murex is community project. We gratefully accept contributions
* [Integrations](../user-guide/integrations.md):
  Default integrations shipped with Murex
* [Quote String: `escape`](../commands/escape.md):
  Escape or unescape input
* [Tab Autocompletion: `autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [expressions](../changelog/expressions.md):
  

<hr/>

This document was generated from [gen/changelog/v7.2_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v7.2_doc.yaml).