IP network calculator
=====================
[![License Badge][]][License] [![GitHub Status][]][GitHub] [![Coverity Status][]][Coverity Scan]

netcalc is a slimmed down clone of [sipcalc][], using the output format
of [ipcalc][].  It is written in C and only depends on a POSIX compliant
C library.  Both IPv4 and IPv6 are supported.

![Image netcalc example run](./example.png "netcalc in action!")


Build & Install
---------------

### Debian/Ubuntu

    curl -sS https://deb.troglobit.com/pubkey.gpg | sudo tee /etc/apt/trusted.gpg.d/troglobit.asc
    echo "deb [arch=amd64] https://deb.troglobit.com/debian stable main" | sudo tee /etc/apt/sources.list.d/troglobit.list
    sudo apt-get update && sudo apt-get install netcalc

### Docker

Automatically built images available here:

* https://hub.docker.com/r/troglobit/netcalc

A Dockerfile is provided to simplify building and running `netcalc`.

    docker build -t netcalc:latest .
    docker run --rm netcalc:latest netcalc 172.16.10.10/16


### Building from Source

First download the latest official release from GitHub:

* https://github.com/troglobit/netcalc/releases

Always use the versioned tarballs, they contain all required files to be
able to build.


### Configure & Build

The GNU Configure & Build system use `/usr/local` as the default install
prefix.  Here we override that to use `/usr/`, the netcalc binary will
then be installed in `/usr/bin`:

    $ ./configure --prefix=/usr
    $ make -j5
    $ sudo make install-strip


### Building from GIT

If you want to contribute, or simply just try out the latest but
unreleased features, then you need to know a few things about the
[GNU build system][buildsystem]:

- `configure.ac` and a per-directory `Makefile.am` are key files
- `configure` and `Makefile.in` are generated from `autogen.sh`,
  they are not stored in GIT but automatically generated for the
  release tarballs
- `Makefile` is generated by `configure` script

To build from GIT; clone the repository and run the `autogen.sh` script.
This requires the GNU tools `automake`, `autoconf` and `libtool` to be
installed on your system.  Released tarballs do not require these tools.

    $ sudo apt install git automake autoconf

Then you can clone the repository and create the `configure` script,
which is not part of the GIT repo:

    git clone https://github.com/troglobit/netcalc.git
    cd netcalc/
    ./autogen.sh
    ./configure && make

GIT sources are a moving target and are not recommended for production
systems, unless you know what you are doing!


Origin & References
-------------------

The original `sipcalc` project was created by Simon Ekstrand in 2001.
It is no longer actively maintained, but has a lot of features and is
available on major Linux distributions and works on *BSD and Solaris.

[Use GitHub][home] to file bug reports, questions, feature requests or
patches — preferably as pull requests.

[ipcalc]:          http://jodies.de/ipcalc
[sipcalc]:         http://www.routemeister.net/
[home]:            https://github.com/troglobit/netcalc
[License]:         https://en.wikipedia.org/wiki/BSD_licenses
[License Badge]:   https://img.shields.io/badge/License-BSD%203--Clause-blue.svg
[GitHub]:          https://github.com/troglobit/smcroute/actions/workflows/build.yml/
[GitHub Status]:   https://github.com/troglobit/smcroute/actions/workflows/build.yml/badge.svg
[Coverity Scan]:   https://scan.coverity.com/projects/21276
[Coverity Status]: https://scan.coverity.com/projects/21276/badge.svg
