# 12 "lib/Toplevel_lexer.mll"
 
open Stdlib
open Migrate_ast

let newline lexbuf = Lexing.new_line lexbuf

# 9 "lib/Toplevel_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\001\000\005\000\254\255\006\000\255\255\002\000\007\000\
    \252\255\012\000\013\000\014\000\252\255\000\000\019\000\020\000\
    \255\255\029\000\021\000\254\255\004\000\253\255";
  Lexing.lex_backtrk =
   "\255\255\004\000\004\000\255\255\004\000\255\255\255\255\255\255\
    \255\255\002\000\255\255\255\255\255\255\003\000\003\000\003\000\
    \255\255\255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_default =
   "\001\000\006\000\255\255\000\000\006\000\000\000\006\000\006\000\
    \000\000\255\255\255\255\012\000\000\000\255\255\255\255\255\255\
    \000\000\255\255\255\255\000\000\255\255\000\000";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\003\000\008\000\008\000\004\000\009\000\009\000\
    \003\000\003\000\010\000\007\000\007\000\009\000\009\000\009\000\
    \014\000\010\000\010\000\015\000\019\000\017\000\017\000\017\000\
    \018\000\018\000\018\000\002\000\019\000\009\000\019\000\017\000\
    \000\000\000\000\018\000\000\000\009\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\020\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\021\000\000\000\020\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\013\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \005\000\255\255\255\255\000\000\000\000\000\000\255\255\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\001\000\006\000\000\000\002\000\002\000\
    \004\000\007\000\002\000\004\000\007\000\009\000\009\000\010\000\
    \011\000\009\000\010\000\011\000\014\000\014\000\015\000\018\000\
    \014\000\015\000\018\000\000\000\020\000\002\000\017\000\017\000\
    \255\255\255\255\017\000\255\255\009\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\014\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\013\000\255\255\017\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\011\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\001\000\006\000\255\255\255\255\255\255\004\000\007\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\011\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code =
   "\000\000\001\000\000\000\000\000\002\000\000\000\003\000\004\000\
    \004\000\000\000\000\000\005\000\000\000\000\000\006\000\007\000\
    \000\000\008\000\009\000\004\000\000\000\000\000";
  Lexing.lex_backtrk_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_default_code =
   "\001\000\001\000\000\000\000\000\001\000\000\000\001\000\001\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_trans_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\
    \001\000\001\000\001\000\001\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000";
  Lexing.lex_check_code =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\001\000\004\000\006\000\007\000\011\000\
    \014\000\015\000\017\000\018\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\001\000\004\000\006\000\007\000\255\255\255\255\255\255\
    \255\255\255\255";
  Lexing.lex_code =
   "\255\001\255\255\000\001\255";
}

let rec token lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1); __ocaml_lex_token_rec lexbuf 0
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 23 "lib/Toplevel_lexer.mll"
                 ( [] )
# 190 "lib/Toplevel_lexer.ml"

  | 1 ->
# 24 "lib/Toplevel_lexer.mll"
                 ( newline lexbuf;
                   `Output ("", Location.curr lexbuf) :: token lexbuf )
# 196 "lib/Toplevel_lexer.ml"

  | 2 ->
# 26 "lib/Toplevel_lexer.mll"
                 ( let pos_start = Lexing.lexeme_end_p lexbuf in
                   let c = phrase (Buffer.create 8) lexbuf in
                   `Command (c, pos_start) :: token lexbuf )
# 203 "lib/Toplevel_lexer.ml"

  | 3 ->
let
# 29 "lib/Toplevel_lexer.mll"
                            str
# 209 "lib/Toplevel_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0) in
# 30 "lib/Toplevel_lexer.mll"
                 ( newline lexbuf;
                   `Output (str, Location.curr lexbuf) :: token lexbuf )
# 214 "lib/Toplevel_lexer.ml"

  | 4 ->
let
# 32 "lib/Toplevel_lexer.mll"
        c
# 220 "lib/Toplevel_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 32 "lib/Toplevel_lexer.mll"
                 (
     let msg =
       Format.sprintf
         "unexpected character '%c'.\n\
          Hint: did you forget a space after the '#' at the start of the line?"
         c
     in
     raise (Syntaxerr.Error (Not_expecting (Location.curr lexbuf, msg))) )
# 231 "lib/Toplevel_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and phrase buf lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 2 (-1); __ocaml_lex_phrase_rec buf lexbuf 11
and __ocaml_lex_phrase_rec buf lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 42 "lib/Toplevel_lexer.mll"
             (
     let msg = "a toplevel phrase must end with `;;`." in
     raise (Syntaxerr.Error (Expecting (Location.curr lexbuf, msg))) )
# 245 "lib/Toplevel_lexer.ml"

  | 1 ->
let
# 45 "lib/Toplevel_lexer.mll"
                   nl
# 251 "lib/Toplevel_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0) in
# 46 "lib/Toplevel_lexer.mll"
      ( for _ = 1 to (Base.String.count ~f:(Char.equal '\n') nl) do
          newline lexbuf;
          Buffer.add_char buf '\n'
        done;
        phrase buf lexbuf )
# 259 "lib/Toplevel_lexer.ml"

  | 2 ->
# 51 "lib/Toplevel_lexer.mll"
             ( Buffer.add_string buf ";;"; Buffer.contents buf )
# 264 "lib/Toplevel_lexer.ml"

  | 3 ->
let
# 52 "lib/Toplevel_lexer.mll"
         c
# 270 "lib/Toplevel_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 52 "lib/Toplevel_lexer.mll"
             ( Buffer.add_char buf c; phrase buf lexbuf )
# 274 "lib/Toplevel_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_phrase_rec buf lexbuf __ocaml_lex_state

;;

# 54 "lib/Toplevel_lexer.mll"
 
let repl_file ~ocaml_version lx =
  let x = token lx in
  let open Ocamlformat_parser_extended.Parsetree in
  List.fold_left (fun acc -> function
      | `Command (cmd, pos_start) ->
          let cmd_lexbuf = Lexing.from_string cmd in
          let filename = (Location.curr lx).loc_start.pos_fname in
          Lexing.set_filename cmd_lexbuf filename ;
          Lexing.set_position cmd_lexbuf pos_start ;
          { prepl_phrase= Parse.toplevel_phrase ~ocaml_version cmd_lexbuf
          ; prepl_output= "" }
          :: acc
      | `Output ("", _) -> acc
      | `Output (line, loc) -> (
          match acc with
          | [] ->
              let msg =
                Format.sprintf
                  "%S.\n\
                   Hint: A toplevel block must start with a toplevel phrase \
                   starting with `# `." line
              in
              raise (Syntaxerr.Error (Not_expecting (loc, msg)))
          | {prepl_phrase; prepl_output} :: t ->
              {prepl_phrase; prepl_output= prepl_output ^ line}
              :: t )
    ) [] x
  |> List.rev

# 312 "lib/Toplevel_lexer.ml"
