/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gud\u017carati";
        final String metaValue_kn = "kannada";
        final String metaValue_ml = "malajalam";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_or = "orija";
        final String metaValue_phn = "fenicki";
        final String metaValue_te = "telugu";
        final String metaValue_ccp = "czakma";
        final Object[][] data = new Object[][] {
            { "001", "\u015bwiat" },
            { "002", "Afryka" },
            { "003", "Ameryka P\u00f3\u0142nocna" },
            { "005", "Ameryka Po\u0142udniowa" },
            { "009", "Oceania" },
            { "011", "Afryka Zachodnia" },
            { "013", "Ameryka \u015arodkowa" },
            { "014", "Afryka Wschodnia" },
            { "015", "Afryka P\u00f3\u0142nocna" },
            { "017", "Afryka \u015arodkowa" },
            { "018", "Afryka Po\u0142udniowa" },
            { "019", "Ameryka" },
            { "021", "Ameryka P\u00f3\u0142nocna (USA, Kanada)" },
            { "029", "Karaiby" },
            { "030", "Azja Wschodnia" },
            { "034", "Azja Po\u0142udniowa" },
            { "035", "Azja Po\u0142udniowo-Wschodnia" },
            { "039", "Europa Po\u0142udniowa" },
            { "053", "Australazja" },
            { "054", "Melanezja" },
            { "057", "Region Mikronezji" },
            { "061", "Polinezja" },
            { "142", "Azja" },
            { "143", "Azja \u015arodkowa" },
            { "145", "Azja Zachodnia" },
            { "150", "Europa" },
            { "151", "Europa Wschodnia" },
            { "154", "Europa P\u00f3\u0142nocna" },
            { "155", "Europa Zachodnia" },
            { "202", "Afryka Subsaharyjska" },
            { "419", "Ameryka \u0141aci\u0144ska" },
            { "AC", "Wyspa Wniebowst\u0105pienia" },
            { "AD", "Andora" },
            { "AE", "Zjednoczone Emiraty Arabskie" },
            { "AF", "Afganistan" },
            { "AG", "Antigua i Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktyda" },
            { "AR", "Argentyna" },
            { "AS", "Samoa Ameryka\u0144skie" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Wyspy Alandzkie" },
            { "AZ", "Azerbejd\u017can" },
            { "BA", "Bo\u015bnia i Hercegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesz" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bu\u0142garia" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermudy" },
            { "BN", "Brunei" },
            { "BO", "Boliwia" },
            { "BQ", "Niderlandy Karaibskie" },
            { "BR", "Brazylia" },
            { "BS", "Bahamy" },
            { "BT", "Bhutan" },
            { "BV", "Wyspa Bouveta" },
            { "BW", "Botswana" },
            { "BY", "Bia\u0142oru\u015b" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Wyspy Kokosowe" },
            { "CD", "Demokratyczna Republika Konga" },
            { "CF", "Republika \u015arodkowoafryka\u0144ska" },
            { "CG", "Kongo" },
            { "CH", "Szwajcaria" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Wyspy Cooka" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Chiny" },
            { "CO", "Kolumbia" },
            { "CP", "Wyspa Clippertona" },
            { "CR", "Kostaryka" },
            { "CU", "Kuba" },
            { "CV", "Republika Zielonego Przyl\u0105dka" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Wyspa Bo\u017cego Narodzenia" },
            { "CY", "Cypr" },
            { "CZ", "Czechy" },
            { "DE", "Niemcy" },
            { "DG", "Diego Garcia" },
            { "DJ", "D\u017cibuti" },
            { "DK", "Dania" },
            { "DM", "Dominika" },
            { "DO", "Dominikana" },
            { "DZ", "Algieria" },
            { "EA", "Ceuta i Melilla" },
            { "EC", "Ekwador" },
            { "EE", "Estonia" },
            { "EG", "Egipt" },
            { "EH", "Sahara Zachodnia" },
            { "ER", "Erytrea" },
            { "ES", "Hiszpania" },
            { "ET", "Etiopia" },
            { "EU", "Unia Europejska" },
            { "EZ", "strefa euro" },
            { "FI", "Finlandia" },
            { "FJ", "Fid\u017ci" },
            { "FK", "Falklandy" },
            { "FM", "Mikronezja" },
            { "FO", "Wyspy Owcze" },
            { "FR", "Francja" },
            { "GA", "Gabon" },
            { "GB", "Wielka Brytania" },
            { "GD", "Grenada" },
            { "GE", "Gruzja" },
            { "GF", "Gujana Francuska" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenlandia" },
            { "GM", "Gambia" },
            { "GN", "Gwinea" },
            { "GP", "Gwadelupa" },
            { "GQ", "Gwinea R\u00f3wnikowa" },
            { "GR", "Grecja" },
            { "GS", "Georgia Po\u0142udniowa i Sandwich Po\u0142udniowy" },
            { "GT", "Gwatemala" },
            { "GU", "Guam" },
            { "GW", "Gwinea Bissau" },
            { "GY", "Gujana" },
            { "HK", "SRA Hongkong (Chiny)" },
            { "HM", "Wyspy Heard i McDonalda" },
            { "HN", "Honduras" },
            { "HR", "Chorwacja" },
            { "HT", "Haiti" },
            { "HU", "W\u0119gry" },
            { "IC", "Wyspy Kanaryjskie" },
            { "ID", "Indonezja" },
            { "IE", "Irlandia" },
            { "IL", "Izrael" },
            { "IM", "Wyspa Man" },
            { "IN", "Indie" },
            { "IO", "Brytyjskie Terytorium Oceanu Indyjskiego" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "IT", "W\u0142ochy" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "JO", "Jordania" },
            { "JP", "Japonia" },
            { "KE", "Kenia" },
            { "KG", "Kirgistan" },
            { "KH", "Kambod\u017ca" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "Saint Kitts i Nevis" },
            { "KP", "Korea P\u00f3\u0142nocna" },
            { "KR", "Korea Po\u0142udniowa" },
            { "KW", "Kuwejt" },
            { "KY", "Kajmany" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litwa" },
            { "LU", "Luksemburg" },
            { "LV", "\u0141otwa" },
            { "LY", "Libia" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Mo\u0142dawia" },
            { "ME", "Czarnog\u00f3ra" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Wyspy Marshalla" },
            { "MK", "Macedonia P\u00f3\u0142nocna" },
            { "ML", "Mali" },
            { "MM", "Mjanma (Birma)" },
            { "MN", "Mongolia" },
            { "MO", "SRA Makau (Chiny)" },
            { "MP", "Mariany P\u00f3\u0142nocne" },
            { "MQ", "Martynika" },
            { "MR", "Mauretania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Meksyk" },
            { "MY", "Malezja" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Nowa Kaledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Holandia" },
            { "NO", "Norwegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nowa Zelandia" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinezja Francuska" },
            { "PG", "Papua-Nowa Gwinea" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "Polska" },
            { "PM", "Saint-Pierre i Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Portoryko" },
            { "PS", "Terytoria Palesty\u0144skie" },
            { "PT", "Portugalia" },
            { "PW", "Palau" },
            { "PY", "Paragwaj" },
            { "QA", "Katar" },
            { "QO", "Oceania \u2014 wyspy dalekie" },
            { "RE", "Reunion" },
            { "RO", "Rumunia" },
            { "RS", "Serbia" },
            { "RU", "Rosja" },
            { "RW", "Rwanda" },
            { "SA", "Arabia Saudyjska" },
            { "SB", "Wyspy Salomona" },
            { "SC", "Seszele" },
            { "SD", "Sudan" },
            { "SE", "Szwecja" },
            { "SG", "Singapur" },
            { "SH", "Wyspa \u015awi\u0119tej Heleny" },
            { "SI", "S\u0142owenia" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "SK", "S\u0142owacja" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sudan Po\u0142udniowy" },
            { "ST", "Wyspy \u015awi\u0119tego Tomasza i Ksi\u0105\u017c\u0119ca" },
            { "SV", "Salwador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks i Caicos" },
            { "TD", "Czad" },
            { "TF", "Francuskie Terytoria Po\u0142udniowe i Antarktyczne" },
            { "TG", "Togo" },
            { "TH", "Tajlandia" },
            { "TJ", "Tad\u017cykistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor Wschodni" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunezja" },
            { "TO", "Tonga" },
            { "TR", "Turcja" },
            { "TT", "Trynidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Dalekie Wyspy Mniejsze Stan\u00f3w Zjednoczonych" },
            { "UN", "Organizacja Narod\u00f3w Zjednoczonych" },
            { "US", "Stany Zjednoczone" },
            { "UY", "Urugwaj" },
            { "UZ", "Uzbekistan" },
            { "VA", "Watykan" },
            { "VC", "Saint Vincent i Grenadyny" },
            { "VE", "Wenezuela" },
            { "VG", "Brytyjskie Wyspy Dziewicze" },
            { "VI", "Wyspy Dziewicze Stan\u00f3w Zjednoczonych" },
            { "VN", "Wietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudoakcenty" },
            { "XB", "Pseudodwukierunkowe" },
            { "XK", "Kosowo" },
            { "YE", "Jemen" },
            { "YT", "Majotta" },
            { "ZA", "Republika Po\u0142udniowej Afryki" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Nieznany region" },
            { "aa", "afar" },
            { "ab", "abchaski" },
            { "ae", "awestyjski" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharski" },
            { "an", "arago\u0144ski" },
            { "ar", "arabski" },
            { "as", "asamski" },
            { "av", "awarski" },
            { "ay", "ajmara" },
            { "az", "azerbejd\u017ca\u0144ski" },
            { "ba", "baszkirski" },
            { "be", "bia\u0142oruski" },
            { "bg", "bu\u0142garski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengalski" },
            { "bo", "tybeta\u0144ski" },
            { "br", "breto\u0144ski" },
            { "bs", "bo\u015bniacki" },
            { "ca", "katalo\u0144ski" },
            { "ce", "czecze\u0144ski" },
            { "ch", "czamorro" },
            { "co", "korsyka\u0144ski" },
            { "cr", "kri" },
            { "cs", "czeski" },
            { "cu", "cerkiewnos\u0142owia\u0144ski" },
            { "cv", "czuwaski" },
            { "cy", "walijski" },
            { "da", "du\u0144ski" },
            { "de", "niemiecki" },
            { "dv", "malediwski" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "grecki" },
            { "en", "angielski" },
            { "eo", "esperanto" },
            { "es", "hiszpa\u0144ski" },
            { "et", "esto\u0144ski" },
            { "eu", "baskijski" },
            { "fa", "perski" },
            { "ff", "fulani" },
            { "fi", "fi\u0144ski" },
            { "fj", "fid\u017cijski" },
            { "fo", "farerski" },
            { "fr", "francuski" },
            { "fy", "zachodniofryzyjski" },
            { "ga", "irlandzki" },
            { "gd", "szkocki gaelicki" },
            { "gl", "galicyjski" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", "hebrajski" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "chorwacki" },
            { "ht", "kreolski haita\u0144ski" },
            { "hu", "w\u0119gierski" },
            { "hy", "ormia\u0144ski" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezyjski" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "syczua\u0144ski" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandzki" },
            { "it", "w\u0142oski" },
            { "iu", "inuktitut" },
            { "ja", "japo\u0144ski" },
            { "jv", "jawajski" },
            { "ka", "gruzi\u0144ski" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kwanyama" },
            { "kk", "kazachski" },
            { "kl", "grenlandzki" },
            { "km", "khmerski" },
            { "kn", metaValue_kn },
            { "ko", "korea\u0144ski" },
            { "kr", "kanuri" },
            { "ks", "kaszmirski" },
            { "ku", "kurdyjski" },
            { "kv", "komi" },
            { "kw", "kornijski" },
            { "ky", "kirgiski" },
            { "la", "\u0142aci\u0144ski" },
            { "lb", "luksemburski" },
            { "lg", "ganda" },
            { "li", "limburski" },
            { "ln", "lingala" },
            { "lo", "laota\u0144ski" },
            { "lt", "litewski" },
            { "lu", "luba-katanga" },
            { "lv", "\u0142otewski" },
            { "mg", "malgaski" },
            { "mh", "marszalski" },
            { "mi", "maoryjski" },
            { "mk", "macedo\u0144ski" },
            { "ml", metaValue_ml },
            { "mn", "mongolski" },
            { "mr", "marathi" },
            { "ms", "malajski" },
            { "mt", "malta\u0144ski" },
            { "my", "birma\u0144ski" },
            { "na", "naurua\u0144ski" },
            { "nb", "norweski (bokm\u00e5l)" },
            { "nd", "ndebele p\u00f3\u0142nocny" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "nl", "niderlandzki" },
            { "nn", "norweski (nynorsk)" },
            { "no", "norweski" },
            { "nr", "ndebele po\u0142udniowy" },
            { "nv", "nawaho" },
            { "ny", "njand\u017ca" },
            { "oc", "oksyta\u0144ski" },
            { "oj", "od\u017cibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osetyjski" },
            { "pa", "pend\u017cabski" },
            { "pi", "palijski" },
            { "pl", "polski" },
            { "ps", "paszto" },
            { "pt", "portugalski" },
            { "qu", "keczua" },
            { "rm", "retoroma\u0144ski" },
            { "rn", "rundi" },
            { "ro", "rumu\u0144ski" },
            { "ru", "rosyjski" },
            { "rw", "kinya-ruanda" },
            { "sa", "sanskryt" },
            { "sc", "sardy\u0144ski" },
            { "sd", "sindhi" },
            { "se", "p\u00f3\u0142nocnolapo\u0144ski" },
            { "sg", "sango" },
            { "sh", "serbsko-chorwacki" },
            { "si", "syngaleski" },
            { "sk", "s\u0142owacki" },
            { "sl", "s\u0142owe\u0144ski" },
            { "sm", "samoa\u0144ski" },
            { "sn", "shona" },
            { "so", "somalijski" },
            { "sq", "alba\u0144ski" },
            { "sr", "serbski" },
            { "ss", "suazi" },
            { "st", "sotho po\u0142udniowy" },
            { "su", "sundajski" },
            { "sv", "szwedzki" },
            { "sw", "suahili" },
            { "ta", "tamilski" },
            { "te", metaValue_te },
            { "tg", "tad\u017cycki" },
            { "th", "tajski" },
            { "ti", "tigrinia" },
            { "tk", "turkme\u0144ski" },
            { "tl", "tagalski" },
            { "tn", "setswana" },
            { "to", "tonga" },
            { "tr", "turecki" },
            { "ts", "tsonga" },
            { "tt", "tatarski" },
            { "tw", "twi" },
            { "ty", "tahita\u0144ski" },
            { "ug", "ujgurski" },
            { "uk", "ukrai\u0144ski" },
            { "ur", "urdu" },
            { "uz", "uzbecki" },
            { "ve", "venda" },
            { "vi", "wietnamski" },
            { "vo", "wolapik" },
            { "wa", "walo\u0144ski" },
            { "wo", "wolof" },
            { "xh", "khosa" },
            { "yi", "jidysz" },
            { "yo", "joruba" },
            { "za", "czuang" },
            { "zh", "chi\u0144ski" },
            { "zu", "zulu" },
            { "ace", "aceh" },
            { "ach", "aczoli" },
            { "ada", "adangme" },
            { "ady", "adygejski" },
            { "aeb", "tunezyjski arabski" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ajnu" },
            { "akk", "akadyjski" },
            { "akz", "alabama" },
            { "ale", "aleucki" },
            { "aln", "alba\u0144ski gegijski" },
            { "alt", "po\u0142udniowoa\u0142tajski" },
            { "ang", "staroangielski" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramejski" },
            { "arn", "mapudungun" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "algierski arabski" },
            { "ars", "arabski nad\u017cdyjski" },
            { "arw", "arawak" },
            { "ary", "maroka\u0144ski arabski" },
            { "arz", "egipski arabski" },
            { "asa", "asu" },
            { "ase", "ameryka\u0144ski j\u0119zyk migowy" },
            { "ast", "asturyjski" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "belud\u017ci" },
            { "ban", "balijski" },
            { "bar", "bawarski" },
            { "bas", "basaa" },
            { "bax", "bamum" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala" },
            { "bej", "bed\u017ca" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgn", "belud\u017ci p\u00f3\u0142nocny" },
            { "bho", "bhod\u017cpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bpy", "bisznuprija-manipuri" },
            { "bqi", "bachtiarski" },
            { "bra", "brad\u017a" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriacki" },
            { "bug", "bugijski" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "kaddo" },
            { "car", "karaibski" },
            { "cay", "kajuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebua\u0144ski" },
            { "cgg", "chiga" },
            { "chb", "czibcza" },
            { "chg", "czagatajski" },
            { "chk", "chuuk" },
            { "chm", "maryjski" },
            { "chn", "\u017cargon czinucki" },
            { "cho", "czoktawski" },
            { "chp", "czipewia\u0144ski" },
            { "chr", "czirokeski" },
            { "chy", "czeje\u0144ski" },
            { "ckb", "sorani" },
            { "clc", "chilcotin" },
            { "cop", "koptyjski" },
            { "cps", "capiznon" },
            { "crg", "miszif" },
            { "crh", "krymskotatarski" },
            { "crj", "kri po\u0142udniowo-wschodni" },
            { "crk", "kri r\u00f3wninny" },
            { "crl", "kri p\u00f3\u0142nocno-wschodni" },
            { "crm", "kri Moose" },
            { "crr", "algonki\u0144ski (Karolina P\u00f3\u0142nocna)" },
            { "crs", "kreolski seszelski" },
            { "csb", "kaszubski" },
            { "csw", "kri bagienny" },
            { "dak", "dakota" },
            { "dar", "dargwijski" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "d\u017cerma" },
            { "doi", "dogri" },
            { "dsb", "dolno\u0142u\u017cycki" },
            { "dtp", "dusun centralny" },
            { "dua", "duala" },
            { "dum", "\u015bredniowieczny niderlandzki" },
            { "dyo", "diola" },
            { "dyu", "diula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emilijski" },
            { "egy", "staroegipski" },
            { "eka", "ekajuk" },
            { "elx", "elamicki" },
            { "enm", "\u015brednioangielski" },
            { "esu", "yupik \u015brodkowosyberyjski" },
            { "ewo", "ewondo" },
            { "ext", "estremadurski" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipi\u0144ski" },
            { "fit", "me\u00e4nkieli" },
            { "fon", "fon" },
            { "frc", "caju\u0144ski" },
            { "frm", "\u015bredniofrancuski" },
            { "fro", "starofrancuski" },
            { "frp", "franko-prowansalski" },
            { "frr", "p\u00f3\u0142nocnofryzyjski" },
            { "frs", "wschodniofryzyjski" },
            { "fur", "friulski" },
            { "gaa", "ga" },
            { "gag", "gagauski" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "zaratusztria\u0144ski dari" },
            { "gez", "gyyz" },
            { "gil", "gilberta\u0144ski" },
            { "glk", "gilia\u0144ski" },
            { "gmh", "\u015brednio-wysoko-niemiecki" },
            { "goh", "staro-wysoko-niemiecki" },
            { "gom", "konkani (Goa)" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gocki" },
            { "grb", "grebo" },
            { "grc", "starogrecki" },
            { "gsw", "szwajcarski niemiecki" },
            { "guc", "way\u00fau" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "hak", "hakka" },
            { "haw", "hawajski" },
            { "hax", "haida po\u0142udniowy" },
            { "hif", "hindi fid\u017cyjskie" },
            { "hil", "hiligaynon" },
            { "hit", "hetycki" },
            { "hmn", "hmong" },
            { "hsb", "g\u00f3rno\u0142u\u017cycki" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut zachodniokanadyjski" },
            { "ilo", "ilokano" },
            { "inh", "inguski" },
            { "izh", "ingryjski" },
            { "jam", "jamajski" },
            { "jbo", "lojban" },
            { "jgo", "ngombe" },
            { "jmc", "machame" },
            { "jpr", "judeo-perski" },
            { "jrb", "judeoarabski" },
            { "jut", "jutlandzki" },
            { "kaa", "karaka\u0142packi" },
            { "kab", "kabylski" },
            { "kac", "kaczin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardyjski" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kreolski Wysp Zielonego Przyl\u0105dka" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "chota\u0144ski" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmand\u017cki" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permiacki" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", "kpelle" },
            { "krc", "karaczajsko-ba\u0142karski" },
            { "kri", "krio" },
            { "krj", "kinaraya" },
            { "krl", "karelski" },
            { "kru", "kurukh" },
            { "ksb", "sambala" },
            { "ksf", "bafia" },
            { "ksh", "gwara kolo\u0144ska" },
            { "kum", "kumycki" },
            { "kut", "kutenai" },
            { "kwk", "kwakiutl" },
            { "lad", "lady\u0144ski" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgijski" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "liguryjski" },
            { "lil", "lillooet" },
            { "liv", "liwski" },
            { "lkt", "lakota" },
            { "lmo", "lombardzki" },
            { "lol", "mongo" },
            { "lou", "kreolski luizja\u0144ski" },
            { "loz", "lozi" },
            { "lrc", "luryjski p\u00f3\u0142nocny" },
            { "lsm", "saamia" },
            { "ltg", "\u0142atgalski" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luhya" },
            { "lzh", "chi\u0144ski klasyczny" },
            { "lzz", "lazyjski" },
            { "mad", "madurski" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "masajski" },
            { "mde", "maba" },
            { "mdf", "moksza" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "kreolski Mauritiusa" },
            { "mga", "\u015brednioirlandzki" },
            { "mgh", "makua" },
            { "mgo", "meta" },
            { "mic", "mikmak" },
            { "min", "minangkabu" },
            { "mnc", "manchu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "zachodniomaryjski" },
            { "mua", "mundang" },
            { "mul", "wiele j\u0119zyk\u00f3w" },
            { "mus", "krik" },
            { "mwl", "mirandyjski" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "erzja" },
            { "mzn", "mazandera\u0144ski" },
            { "nan", "minna\u0144ski" },
            { "nap", "neapolita\u0144ski" },
            { "naq", "nama" },
            { "nds", "dolnoniemiecki" },
            { "new", "newarski" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "njo", "ao" },
            { "nmg", "ngumba" },
            { "nnh", "ngiemboon" },
            { "nog", "nogajski" },
            { "non", "staronordyjski" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho p\u00f3\u0142nocny" },
            { "nus", "nuer" },
            { "nwc", "newarski klasyczny" },
            { "nym", "niamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzema" },
            { "ojb", "od\u017cibwe p\u00f3\u0142nocno-zachodni" },
            { "ojc", "od\u017cibwe centralny" },
            { "ojs", "od\u017ci-kri" },
            { "ojw", "od\u017cibwe zachodni" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "osma\u0144sko-turecki" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampango" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "pikardyjski" },
            { "pcm", "pid\u017cyn nigeryjski" },
            { "pdc", "pensylwa\u0144ski" },
            { "pdt", "plautdietsch" },
            { "peo", "staroperski" },
            { "pfl", "palatynacki" },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pms", "piemoncki" },
            { "pnt", "pontyjski" },
            { "pon", "ponpejski" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "pruski" },
            { "pro", "staroprowansalski" },
            { "quc", "kicze" },
            { "qug", "keczua g\u00f3rski (Chimborazo)" },
            { "raj", "rad\u017aasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romagnol" },
            { "rhg", "rohingya" },
            { "rif", "tarifit" },
            { "rof", "rombo" },
            { "rom", "cyga\u0144ski" },
            { "rtm", "rotuma\u0144ski" },
            { "rue", "rusi\u0144ski" },
            { "rug", "roviana" },
            { "rup", "arumu\u0144ski" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakucki" },
            { "sam", "samaryta\u0144ski aramejski" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", "saurasztryjski" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sycylijski" },
            { "sco", "scots" },
            { "sdc", "sassarski" },
            { "sdh", "po\u0142udniowokurdyjski" },
            { "see", "seneka" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkupski" },
            { "ses", "koyraboro senni" },
            { "sga", "staroirlandzki" },
            { "sgs", "\u017cmudzki" },
            { "shi", "tashelhiyt" },
            { "shn", "szan" },
            { "shu", "arabski (Czad)" },
            { "sid", "sidamo" },
            { "slh", "lushootseed po\u0142udniowy" },
            { "sli", "dolno\u015bl\u0105ski" },
            { "sly", "selayar" },
            { "sma", "po\u0142udniowolapo\u0144ski" },
            { "smj", "lule" },
            { "smn", "inari" },
            { "sms", "skolt" },
            { "snk", "soninke" },
            { "sog", "sogdyjski" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "stq", "fryzyjski saterlandzki" },
            { "str", "salisz" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeryjski" },
            { "swb", "komoryjski" },
            { "syc", "syriacki" },
            { "syr", "syryjski" },
            { "szl", "\u015bl\u0105ski" },
            { "tce", "tutchone po\u0142udniowy" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "ateso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tiv", "tiw" },
            { "tkl", "tokelau" },
            { "tkr", "cachurski" },
            { "tlh", "klingo\u0144ski" },
            { "tli", "tlingit" },
            { "tly", "ta\u0142yski" },
            { "tmh", "tamaszek" },
            { "tog", "tonga (Niasa)" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoyo" },
            { "trv", "taroko" },
            { "tsd", "cako\u0144ski" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchone p\u00f3\u0142nocny" },
            { "ttt", "tacki" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuwi\u0144ski" },
            { "tzm", "tamazight (Atlas \u015arodkowy)" },
            { "udm", "udmurcki" },
            { "uga", "ugarycki" },
            { "umb", "umbundu" },
            { "und", "nieznany j\u0119zyk" },
            { "vai", "wai" },
            { "vec", "wenecki" },
            { "vep", "wepski" },
            { "vls", "zachodnioflamandzki" },
            { "vmf", "me\u0144ski franko\u0144ski" },
            { "vot", "wotiacki" },
            { "vro", "v\u00f5ro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolayta" },
            { "war", "waraj" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "ka\u0142mucki" },
            { "xmf", "megrelski" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "japski" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kanto\u0144ski" },
            { "zap", "zapotecki" },
            { "zbl", "bliss" },
            { "zea", "zelandzki" },
            { "zen", "zenaga" },
            { "zgh", "standardowy maroka\u0144ski tamazight" },
            { "zun", "zuni" },
            { "zxx", "brak tre\u015bci o charakterze j\u0119zykowym" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Arab", "arabskie" },
            { "Aran", "nastaliq" },
            { "Armi", "armi" },
            { "Armn", "ormia\u0144skie" },
            { "Avst", "awestyjskie" },
            { "Bali", "balijskie" },
            { "Bamu", "bamun" },
            { "Batk", "batak" },
            { "Beng", "bengalskie" },
            { "Blis", "symbole Blissa" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "Braille\u2019a" },
            { "Bugi", "bugi\u0144skie" },
            { "Buhd", "buhid" },
            { "Cakm", "chakma" },
            { "Cans", "zunifikowane symbole kanadyjskich autochton\u00f3w" },
            { "Cari", "karyjskie" },
            { "Cham", "czamskie" },
            { "Cher", "czirokeskie" },
            { "Cirt", "cirth" },
            { "Copt", "koptyjskie" },
            { "Cprt", "cypryjskie" },
            { "Cyrl", "cyrylica" },
            { "Cyrs", "cyrylica staro-cerkiewno-s\u0142owia\u0144ska" },
            { "Deva", "dewanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egipskie demotyczne" },
            { "Egyh", "egipskie hieratyczne" },
            { "Egyp", "hieroglify egipskie" },
            { "Ethi", "etiopskie" },
            { "Geok", "gruzi\u0144skie chucuri" },
            { "Geor", "gruzi\u0144skie" },
            { "Glag", "g\u0142agolica" },
            { "Goth", "gotyckie" },
            { "Grek", "greckie" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "chi\u0144skie z bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "chi\u0144skie" },
            { "Hano", "hanunoo" },
            { "Hans", "uproszczone" },
            { "Hant", "tradycyjne" },
            { "Hebr", "hebrajskie" },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "sylabariusze japo\u0144skie" },
            { "Hung", "starow\u0119gierskie" },
            { "Inds", "indus" },
            { "Ital", "starow\u0142oskie" },
            { "Jamo", "jamo" },
            { "Java", "jawajskie" },
            { "Jpan", "japo\u0144skie" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "charosti" },
            { "Khmr", "khmerskie" },
            { "Knda", metaValue_kn },
            { "Kore", "korea\u0144skie" },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "laota\u0144skie" },
            { "Latf", "\u0142aci\u0144ski - fraktura" },
            { "Latg", "\u0142aci\u0144ski - odmiana gaelicka" },
            { "Latn", "\u0142aci\u0144skie" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "linearne A" },
            { "Linb", "linearne B" },
            { "Lyci", "likijskie" },
            { "Lydi", "lidyjskie" },
            { "Mand", "mandejskie" },
            { "Mani", "manichejskie" },
            { "Maya", "hieroglify Maj\u00f3w" },
            { "Mero", "meroickie" },
            { "Mlym", metaValue_ml },
            { "Mong", "mongolskie" },
            { "Moon", "Moon\u2019a" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "birma\u0144skie" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogham" },
            { "Olck", "ol ciki" },
            { "Orkh", "orcho\u0144skie" },
            { "Orya", metaValue_or },
            { "Osma", "osmanya" },
            { "Perm", "staropermskie" },
            { "Phag", "phags-pa" },
            { "Phli", "inskrypcyjne pahlawi" },
            { "Phlp", "pahlawi psa\u0142terzowy" },
            { "Phlv", "pahlawi ksi\u0105\u017ckowy" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fonetyczny Pollard\u2019a" },
            { "Prti", "partyjski inskrypcyjny" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runiczne" },
            { "Samr", "samaryta\u0144ski" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "pismo znakowe" },
            { "Shaw", "shawa" },
            { "Sinh", "syngaleskie" },
            { "Sund", "sundajskie" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "syryjskie" },
            { "Syre", "syriacki estrangelo" },
            { "Syrj", "syryjski (odmiana zachodnia)" },
            { "Syrn", "syryjski (odmiana wschodnia)" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai le" },
            { "Talu", "nowy tai lue" },
            { "Taml", "tamilskie" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh (berberski)" },
            { "Tglg", "tagalog" },
            { "Thaa", "taana" },
            { "Thai", "tajskie" },
            { "Tibt", "tybeta\u0144skie" },
            { "Ugar", "ugaryckie" },
            { "Vaii", "vai" },
            { "Visp", "Visible Speech" },
            { "Xpeo", "staroperskie" },
            { "Xsux", "klinowe sumero-akadyjskie" },
            { "Yiii", "yi" },
            { "Zinh", "dziedziczone" },
            { "Zmth", "notacja matematyczna" },
            { "Zsye", "emoji" },
            { "Zsym", "symbole" },
            { "Zxxx", "j\u0119zyk bez systemu pisma" },
            { "Zyyy", "wsp\u00f3lne" },
            { "Zzzz", "nieznane pismo" },
            { "de_AT", "niemiecki austriacki" },
            { "de_CH", "wysokoniemiecki szwajcarski" },
            { "en_AU", "angielski australijski" },
            { "en_CA", "angielski kanadyjski" },
            { "en_GB", "angielski brytyjski" },
            { "en_US", "angielski ameryka\u0144ski" },
            { "es_ES", "europejski hiszpa\u0144ski" },
            { "es_MX", "meksyka\u0144ski hiszpa\u0144ski" },
            { "fa_AF", "dari" },
            { "fr_CA", "francuski kanadyjski" },
            { "fr_CH", "francuski szwajcarski" },
            { "nl_BE", "flamandzki" },
            { "pt_BR", "brazylijski portugalski" },
            { "pt_PT", "europejski portugalski" },
            { "ro_MD", "mo\u0142dawski" },
            { "sw_CD", "kongijski suahili" },
            { "%%1901", "tradycyjna ortografia niemiecka" },
            { "%%1994", "standardowa ortografia regionu Resia" },
            { "%%1996", "ortografia niemiecka z 1996 r." },
            { "ar_001", "wsp\u00f3\u0142czesny arabski" },
            { "es_419", "ameryka\u0144ski hiszpa\u0144ski" },
            { "key.ca", "kalendarz" },
            { "key.cf", "format waluty" },
            { "key.co", "kolejno\u015b\u0107 sortowania" },
            { "key.cu", "waluta" },
            { "key.hc", "cykl (12- lub 24-godzinny)" },
            { "key.lb", "styl podzia\u0142u wiersza" },
            { "key.ms", "system miar" },
            { "key.nu", "cyfry" },
            { "key.tz", "strefa czasowa" },
            { "key.va", "wariant regionalny" },
            { "nds_NL", "dolnosakso\u0144ski" },
            { "%%BISKE", "dialekt San Giorgio/Bila" },
            { "%%BOONT", "dialekt Boontling" },
            { "%%KKCOR", "ortografia wsp\u00f3lna" },
            { "%%LIPAW", "dialekt Lipovaz w regionie Resia" },
            { "%%NEDIS", "dialekt Natisone" },
            { "%%NJIVA", "dialekt Gniva/Njiva" },
            { "%%OSOJS", "dialekt Oseacco/Osojane" },
            { "%%POSIX", "komputerowy" },
            { "%%ROZAJ", "dialekt regionu Resia" },
            { "%%SAAHO", "dialekt Saho" },
            { "%%SOLBA", "dialekt Stolvizza/Solbica" },
            { "%%UCCOR", "ortografia ujednolicona" },
            { "hi_Latn", "hindi (alfabet \u0142aci\u0144ski)" },
            { "zh_Hans", "chi\u0144ski uproszczony" },
            { "zh_Hant", "chi\u0144ski tradycyjny" },
            { "%%FONIPA", "fonetyczny mi\u0119dzynarodowy" },
            { "%%FONUPA", "fonetyczny" },
            { "%%SCOUSE", "dialekt Scouse" },
            { "%%TARASK", "ortografia taraszkiewicka" },
            { "%%UCRCOR", "zreformowana ortografia ujednolicona" },
            { "%%AREVELA", "ormia\u0144ski wchodni" },
            { "%%AREVMDA", "ormia\u0144ski zachodni" },
            { "%%MONOTON", "monotoniczny" },
            { "%%POLYTON", "politoniczny" },
            { "%%REVISED", "ortografia zreformowana" },
            { "%%1606NICT", "szesnastowieczny francuski" },
            { "%%1694ACAD", "siedemnastowieczny francuski" },
            { "%%BAKU1926", "turecki zunifikowany alfabet \u0142aci\u0144ski" },
            { "%%SCOTLAND", "standardowy szkocki angielski" },
            { "%%VALENCIA", "walencki" },
            { "%%WADEGILE", "latynizacja Wade\u2019a i Gilesa" },
            { "type.ca.roc", "kalendarz Republiki Chi\u0144skiej" },
            { "type.co.eor", "europejskie regu\u0142y okre\u015blania kolejno\u015bci" },
            { "type.hc.h11", "system 12-godzinny (0\u201311)" },
            { "type.hc.h12", "system 12-godzinny (1\u201312)" },
            { "type.hc.h23", "system 24-godzinny (0\u201323)" },
            { "type.hc.h24", "system 24-godzinny (1\u201324)" },
            { "type.m0.bgn", "transliteracja BGN" },
            { "type.nu.arab", "cyfry arabsko-indyjskie" },
            { "type.nu.armn", "cyfry ormia\u0144skie" },
            { "type.nu.beng", "cyfry bengalskie" },
            { "type.nu.cakm", metaValue_ccp },
            { "type.nu.deva", "cyfry dewanagari" },
            { "type.nu.ethi", "cyfry etiopskie" },
            { "type.nu.geor", "cyfry gruzi\u0144skie" },
            { "type.nu.grek", "cyfry greckie" },
            { "type.nu.gujr", "cyfry gud\u017carati" },
            { "type.nu.guru", "cyfry gurmukhi" },
            { "type.nu.hans", "uproszczone cyfry chi\u0144skie" },
            { "type.nu.hant", "tradycyjne cyfry chi\u0144skie" },
            { "type.nu.hebr", "cyfry hebrajskie" },
            { "type.nu.java", "cyfry jawajskie" },
            { "type.nu.jpan", "cyfry japo\u0144skie" },
            { "type.nu.khmr", "cyfry khmerskie" },
            { "type.nu.knda", "cyfry kannada" },
            { "type.nu.laoo", "cyfry laota\u0144skie" },
            { "type.nu.latn", "cyfry arabskie" },
            { "type.nu.mlym", "cyfry malajalam" },
            { "type.nu.mong", "Cyfry mongolskie" },
            { "type.nu.mtei", "cyfry meetei mayek" },
            { "type.nu.mymr", "cyfry birma\u0144skie" },
            { "type.nu.olck", "cyfry ol ciki" },
            { "type.nu.orya", "cyfry orija" },
            { "type.nu.taml", "tradycyjne cyfry tamilskie" },
            { "type.nu.telu", "cyfry telugu" },
            { "type.nu.thai", "cyfry tajskie" },
            { "type.nu.tibt", "cyfry tybeta\u0144skie" },
            { "type.nu.vaii", "cyfry vai" },
            { "type.ca.dangi", "kalendarz korea\u0144ski" },
            { "type.co.ducet", "domy\u015blna kolejno\u015b\u0107 sortowania Unicode" },
            { "type.lb.loose", "lu\u017any styl podzia\u0142u wiersza" },
            { "type.nu.roman", "cyfry rzymskie" },
            { "type.ca.coptic", "kalendarz koptyjski" },
            { "type.ca.hebrew", "kalendarz hebrajski" },
            { "type.ca.indian", "narodowy kalendarz hinduski" },
            { "type.co.compat", "poprzedni porz\u0105dek sortowania, dla zgodno\u015bci" },
            { "type.co.pinyin", "porz\u0105dek sortowania pinyin" },
            { "type.co.search", "wyszukiwanie og\u00f3lnego zastosowania" },
            { "type.co.stroke", "sortowanie wg liczby kresek" },
            { "type.co.unihan", "sortowanie wg kluczy i ich liczby kresek" },
            { "type.co.zhuyin", "sortowanie zhuyin" },
            { "type.d0.fwidth", "pe\u0142na szeroko\u015b\u0107" },
            { "type.d0.hwidth", "po\u0142owa szeroko\u015bci" },
            { "type.lb.normal", "normalny styl podzia\u0142u wiersza" },
            { "type.lb.strict", "\u015bcis\u0142y styl podzia\u0142u wiersza" },
            { "type.m0.ungegn", "transliteracja UNGEGN" },
            { "type.ms.metric", "system metryczny" },
            { "type.nu.native", "cyfry macierzyste" },
            { "type.ca.chinese", "kalendarz chi\u0144ski" },
            { "type.ca.islamic", "kalendarz muzu\u0142ma\u0144ski" },
            { "type.ca.iso8601", "kalendarz ISO-8601" },
            { "type.ca.persian", "kalendarz perski" },
            { "type.cf.account", "ksi\u0119gowy format waluty" },
            { "type.co.big5han", "chi\u0144ski tradycyjny porz\u0105dek sortowania - Big5" },
            { "type.d0.npinyin", "Liczbowe" },
            { "type.nu.arabext", "rozszerzone cyfry arabsko-indyjskie" },
            { "type.nu.armnlow", "cyfry ormia\u0144skie (ma\u0142e litery)" },
            { "type.nu.finance", "Liczebniki ksi\u0119gowe" },
            { "type.nu.greklow", "cyfry greckie (ma\u0142e litery)" },
            { "type.nu.hanidec", "chi\u0144skie cyfry dziesi\u0119tne" },
            { "type.nu.hansfin", "uproszczone chi\u0144skie cyfry ksi\u0119gowe" },
            { "type.nu.hantfin", "tradycyjne chi\u0144skie cyfry ksi\u0119gowe" },
            { "type.nu.jpanfin", "japo\u0144skie cyfry ksi\u0119gowe" },
            { "type.nu.tamldec", "cyfry tamilskie" },
            { "type.ca.buddhist", "kalendarz buddyjski" },
            { "type.ca.ethiopic", "kalendarz etiopski" },
            { "type.ca.japanese", "kalendarz japo\u0144ski" },
            { "type.cf.standard", "standardowy format waluty" },
            { "type.co.phonetic", "sortowanie fonetyczne" },
            { "type.co.reformed", "sortowanie zreformowane" },
            { "type.co.searchjl", "Wyszukiwanie wed\u0142ug pocz\u0105tkowej sp\u00f3\u0142g\u0142oski hangul" },
            { "type.co.standard", "standardowa kolejno\u015b\u0107 sortowania" },
            { "type.ms.uksystem", "imperialny system miar" },
            { "type.ms.ussystem", "ameryka\u0144ski system miar" },
            { "type.nu.fullwide", "cyfry o pe\u0142nej szeroko\u015bci" },
            { "type.nu.romanlow", "cyfry rzymskie (ma\u0142e litery)" },
            { "type.ca.gregorian", "kalendarz gregoria\u0144ski" },
            { "type.co.gb2312han", "chi\u0144ski uproszczony porz\u0105dek sortowania - GB2312" },
            { "type.co.phonebook", "porz\u0105dek sortowania ksi\u0105\u017cki telefonicznej" },
            { "type.co.dictionary", "sortowanie s\u0142ownikowe" },
            { "type.co.traditional", "tradycyjny porz\u0105dek sortowania" },
            { "type.nu.traditional", "Liczebniki tradycyjne" },
            { "type.ca.islamic-rgsa", "kalendarz islamski (Arabia Saudyjska, metoda wzrokowa)" },
            { "type.ca.islamic-tbla", "kalendarz islamski (metoda obliczeniowa, epoka astronomiczna)" },
            { "type.ca.islamic-civil", "kalendarz islamski (metoda obliczeniowa)" },
            { "type.ca.islamic-umalqura", "kalendarz islamski (Umm al-Kura)" },
            { "type.ca.ethiopic-amete-alem", "kalendarz etiopski Amete Alem" },
        };
        return data;
    }
}
