/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_zu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Isikhathi sase-Greenwich Mean",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Isikhathi sase-Apia esivamile",
               "",
               "Isikhathi sase-Apia sasemini",
               "",
               "Isikhathi sase-Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Isikhathi esivamile sase-Cook Islands",
               "",
               "Isikhathi esiyingxenye yasehlobo sase-Cook Islands",
               "",
               "Isikhathi sase-Cook Islands",
               "",
            };
        final String[] Cuba = new String[] {
               "Isikhathi sase-Cuba esijwayelekile",
               "CST",
               "Isikhathi sase-Cuba sasemini",
               "CDT",
               "Isikhathi sase-Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Isikhathi esivamile sase-Fiji",
               "",
               "Isikhathi sehlobo sase-Fiji",
               "",
               "Isikhathi sase-Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Isikhathi esivamile sase-Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Isikhathi Esimisiwe sase-Hovd",
               "",
               "Isikhathi sehlobo e-Hovd",
               "",
               "Isikhathi sase-Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Isikhathi sase-Iran esivamile",
               "",
               "Isikhathi sase-Iran sasemini",
               "",
               "Isikhathi sase-Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Isikhathi sase-Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Isikhathi Esivamile sase-Omsk",
               "",
               "Isikhathi sasehlobo sase-Omsk",
               "",
               "Isikhathi sase-Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Isikhathi sase-Peru esivamile",
               "",
               "Isikhathi sase-Peru sasehlobo",
               "",
               "Isikhathi sase-Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Isikhathi sase-Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Isikhathi sase-Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Isikhathi sase-Chile esijwayelekile",
               "",
               "Isikhathi sase-Chile sasehlobo",
               "",
               "Isikhathi sase-Chile",
               "",
            };
        final String[] China = new String[] {
               "Isikhathi esivamile sase-China",
               "CST",
               "Isikhathi semini sase-China",
               "CDT",
               "Isikhathi sase-China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Isikhathi sase-Cocos Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Isikhathi sase-Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Isikhathi sase-India esivamile",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Isikhathi esivamile sase-Japan",
               "JST",
               "Isikhathi semini sase-Japan",
               "JDT",
               "Isikhathi sase-Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Isikhathi Esivamile sase-Korea",
               "KST",
               "Isikhathi semini sase-Korea",
               "KST",
               "Isikhathi sase-Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Isikhathi sase-Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Isikhathi sase-Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Isikhathi sase-Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Isikhathi sase-Samoa esivamile",
               "SST",
               "Isikhathi sase-Samoa sasemini",
               "SST",
               "Isikhathi sase-Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Isikhathi sase-Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Isikhathi sase-Tonga esivamile",
               "",
               "Isikhathi sase-Tonga sasehlobo",
               "",
               "Isikhathi sase-Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukon Time",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Isikhathi sase-Alaska esijwayelekile",
               "AKST",
               "Isikhathi sase-Alaska sasemini",
               "AKDT",
               "Isikhathi sase-Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Isikhathi sase-Amazon esijwayelekile",
               "",
               "Isikhathi sase-Amazon sasehlobo",
               "",
               "Isikhathi sase-Amazon",
               "",
            };
        final String[] Anadyr = new String[] {
               "esase-Anadyr Standard Time",
               "",
               "esase-Anadyr Summer Time",
               "",
               "esase-Anadyr Time",
               "",
            };
        final String[] Azores = new String[] {
               "Isikhathi esijwayelekile sase-Azores",
               "",
               "Isikhathi sasehlobo sase-Azores",
               "",
               "Isikhathi sase-Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Isikhathi sase-Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Isikhathi sase-Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Isikhathi sase-Easter Island esijwayelekile",
               "",
               "Isikhathi sase-Easter Island sasehlobo",
               "",
               "Isikhathi sase-Easter Island",
               "",
            };
        final String[] Guyana = new String[] {
               "Isikhathi sase-Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Isikhathi esivamile sase-Israel",
               "IST",
               "Isikhathi sasemini sakwa-Israel",
               "IDT",
               "Isikhathi sase-Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Isikhathi sase-Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Isikhathi sase-Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Isikhathi sase-Moscow esijwayelekile",
               "MSK",
               "Isikhathi sasehlobo e-Moscow",
               "MSK",
               "Isikhathi sase-Moscow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Isikhathi sase-Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "esase-Samara Standard Time",
               "",
               "esase-Samara Summer Time",
               "",
               "esase-Samara Time",
               "",
            };
        final String[] Tahiti = new String[] {
               "Isikhathi sase-Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Isikhathi esivamile sase-Taipei",
               "CST",
               "Isikhathi semini sase-Taipei",
               "CDT",
               "Isikhathi sase-Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Isikhathi sase-Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Isikhathi sase-Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Isikhathi sase-Wallis nase-Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Isikhathi esivamile sase-Arabian",
               "",
               "Isikhathi semini sase-Arabian",
               "",
               "Isikhathi sase-Arabian",
               "",
            };
        final String[] Armenia = new String[] {
               "Isikhathi esivamile sase-Armenia",
               "",
               "Isikhathi sehlobo sase-Armenia",
               "",
               "Isikhathi saseArmenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Isikhathi sase-Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Isikhathi esivamile sase-Chatham",
               "",
               "Isikhathi sasemini sase-Chatham",
               "",
               "Isikhathi sase-Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "isikhathi somhlaba esididiyelwe",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Isikhathi sase-Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Isikhathi sase-Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Isikhathi esivamile sase-Georgia",
               "",
               "Isikhathi sehlobo sase-Georgia",
               "",
               "Isikhathi sase-Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Isikhathi Esivamile sase-Irkutsk",
               "",
               "Isikhathi sasehlobo e-Irkutsk",
               "",
               "Isikhathi sase-Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Isikhathi Esivamile sase-Magadan",
               "",
               "Isikhathi sasehlobo e-Magadan",
               "",
               "Isikhathi sase-Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Isikhathi sase-Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Isikhathi sase-Norfolk Islands esivamile",
               "",
               "Isikhathi sase-Norfolk Islands sasehlobo",
               "",
               "Isikhathi sase-Norfolk Islands",
               "",
            };
        final String[] Noronha = new String[] {
               "Isikhathi sase-Fernando de Noronha esivamile",
               "",
               "Isikhathi sase-Fernando de Noronha sasehlobo",
               "",
               "Isikhathi sase-Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Isikhathi sase-Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Isikhathi sase-Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Isikhathi sase-Solomon Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Isikhathi sase-Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Isikhathi sase-Uruguay esijwayelekile",
               "",
               "Isikhathi sase-Uruguay sasehlobo",
               "",
               "Isikhathi sase-Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Isikhathi sase-Vanuatu esijwayelekile",
               "",
               "Isikhathi sase-Vanuatu sasehlobo",
               "",
               "Isikhathi sase-Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Isikhathi Esivamile sase-Yakutsk",
               "",
               "Isikhathi sasehlobo e-Yakutsk",
               "",
               "Isikhathi sase-Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Isikhathi sase-Atlantic esijwayelekile",
               "AST",
               "Isikhathi sase-Atlantic sasemini",
               "ADT",
               "Isikhathi sase-Atlantic",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Isikhathi sase-Brasilia esijwayelekile",
               "",
               "Isikhathi sase-Brasilia sasehlobo",
               "",
               "Isikhathi sase-Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Isikhathi esivamile sase-Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Isikhathi sase-Colombia esijwayelekile",
               "",
               "Isikhathi sase-Colombia sasehlobo",
               "",
               "Isikhathi sase-Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Isikhathi sase-Falkland Islands esijwayelekile",
               "",
               "Isikhathi sase-Falkland Islands sasehlobo",
               "",
               "Isikhathi sase-Falkland Islands",
               "",
            };
        final String[] Malaysia = new String[] {
               "Isikhathi sase-Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Isikhathi sase-Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Isikhathi Esimisiwe sase-Ulan Bator",
               "",
               "Isikhathi sehlobo e-Ulan Bator",
               "",
               "Isikhathi sase-Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Isikhathi sase-Pakistan esivamile",
               "PKT",
               "Isikhathi sase-Pakistan sasehlobo",
               "PKST",
               "Isikhathi sase-Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Isikhathi sase-Paraguay esivamile",
               "",
               "Isikhathi sase-Paraguay sasehlobo",
               "",
               "Isikhathi sase-Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Isikhathi sase-Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Isikhathi Esivamile sase-Sakhalin",
               "",
               "Isikhathi sasehlobo e-Sakhalin",
               "",
               "Isikhathi sase-Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Isikhathi sase-Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Isikhathi sase-Argentina esijwayelekile",
               "",
               "Isikhathi sase-Argentina sasehlobo",
               "",
               "Isikhathi sase-Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Isikhathi sase-Christmas Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Isikhathi sase-Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Isikhathi esivamile sase-Hong Kong",
               "HKT",
               "Isikhathi sehlobo sase-Hong Kong",
               "HKST",
               "Isikhathi sase-Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Isikhathi sase-Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "esase-Petropavlovsk-Kamchatski Standard Time",
               "",
               "esase-Petropavlovsk-Kamchatski Summer Time",
               "",
               "esase-Petropavlovsk-Kamchatski Time",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Isikhathi sase-Kyrgystan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Isikhathi sase-Lord Howe esivamile",
               "",
               "Isikhathi sase-Lord Howe sasemini",
               "",
               "Isikhathi sase-Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Isikhathi sase-Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Isikhathi esivamile sase-Mauritius",
               "",
               "Isikhathi sehlobo sase-Mauritius",
               "",
               "Isikhathi sase-Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Isikhathi esivamile sase-Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Isikhathi sase-Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Isikhathi Esivamile sase-Volgograd",
               "MSK",
               "Isikhathi sase-Volgograd sasehlobo",
               "MSK",
               "Isikhathi sase-Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Isikhathi esivamile sase-Azerbaijan",
               "",
               "Isikhathi sehlobo sase-Azerbaijan",
               "",
               "Isikhathi sase-Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Isikhathi sase-Bangladesh esivamile",
               "",
               "Isikhathi sase-Bangladesh sasehlobo",
               "",
               "Isikhathi sase-Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Isikhathi esezingeni sase-Cape Verde",
               "",
               "Isikhathi sehlobo sase-Cape Verde",
               "",
               "Isikhathi sase-Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Isikhathi sase-East Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Isikhathi sase-Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Isikhathi sase-Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Isikhathi esivamile sase-Uzbekistan",
               "",
               "Isikhathi sehlobo sase-Uzbekistan",
               "",
               "Isikhathi sase-Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Isikhathi sase-Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Isikhathi Esivamile sase-Krasnoyarsk",
               "",
               "Isikhathi sasehlobo e-Krasnoyarsk",
               "",
               "Isikhathi sase-Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Isikhathi esivamile sase-New Zealand",
               "NZST",
               "Isikhathi sasemini sase-New Zealand",
               "NZDT",
               "Isikhathi sase-New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Isikhathi Esivamile sase-Novosibirsk",
               "",
               "Isikhathi sasehlobo sase-Novosibirsk",
               "",
               "Isikhathi sase-Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Isikhathi esivamile sase-Philippine",
               "PST",
               "Isikhathi sehlobo sase-Philippine",
               "PDT",
               "Isikhathi sase-Philippine",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Isikhathi Esivamile sase-Vladivostok",
               "",
               "Isikhathi sasehlobo e-Vladivostok",
               "",
               "Isikhathi sase-Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Isikhathi sase-Indian Ocean",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Isikhathi sase-Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Isikhathi sase-Newfoundland esijwayelekile",
               "NST",
               "Isikhathi sase-Newfoundland sasemini",
               "NDT",
               "Isikhathi sase-Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Isikhathi esivamile sase-Turkmenistan",
               "",
               "Isikhathi sehlobo sase-Turkmenistan",
               "",
               "Isikhathi sase-Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Isikhathi sase-French Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Isikhathi sase-New Caledonia esivamile",
               "",
               "Isikhathi sase-New Caledonia sasehlobo",
               "",
               "Isikhathi sase-New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Isikhathi sase-South Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Isikhathi Esivamile sase-Yekaterinburg",
               "",
               "Isikhathi sasehlobo e-Yekaterinburg",
               "",
               "Isikhathi sase-Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Isikhathi sase-Central Africa",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Isikhathi saseMpumalanga Afrika",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Isikhathi esivamile saseNtshonalanga Afrika",
               "WAT",
               "Isikhathi sasehlobo saseNtshonalanga Afrika",
               "WAT",
               "Isikhathi saseNtshonalanga Afrika",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Isikhathi sase-Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Isikhathi esijwayelekile sase-Central Europe",
               "CET",
               "Isikhathi sasehlobo sase-Central Europe",
               "CEST",
               "Isikhathi sase-Central Europe",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Isikhathi esijwayelekile sase-Eastern Europe",
               "EET",
               "Isikhathi sasehlobo sase-Eastern Europe",
               "EEST",
               "Isikhathi sase-Eastern Europe",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Isikhathi esijwayelekile sase-Western Europe",
               "WET",
               "Isikhathi sasehlobo sase-Western Europe",
               "WEST",
               "Isikhathi sase-Western Europe",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Isikhathi sase-Mexican Pacific esijwayelekile",
               "MST",
               "Isikhathi sase-Mexican Pacific sasemini",
               "MDT",
               "Isikhathi sase-Mexican Pacific",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Isikhathi esivamile saseNingizimu Afrika",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Isikhathi sase-North American Central esijwayelekile",
               "CST",
               "Isikhathi sase-North American Central sasemini",
               "CDT",
               "Isikhathi sase-North American Central",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Isikhathi sase-North American East esijwayelekile",
               "EST",
               "Isikhathi sase-North American East sasemini",
               "EST",
               "Isikhathi sase-North American East",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Isikhathi sase-North American Pacific esijwayelekile",
               "PST",
               "Isikhathi sase-North American Pacific sasemini",
               "PDT",
               "Isikhathi sase-North American Pacific",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Isikhathi sase-French Southern nase-Antarctic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Isikhathi sase-Gilbert Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Isikhathi sase-Hawaii-Aleutia esijwayelekile",
               "HST",
               "Isikhathi sase-Hawaii-Aleutia sasemini",
               "HST",
               "Isikhathi sase-Hawaii-Aleutia",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Isikhathi sase-Phoenix Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Iikhathi sase-Saint Pierre nase-Miquelon esijwayelekile",
               "",
               "Isikhathi sase-Saint Pierre nase-Miquelon sasemini",
               "",
               "Isikhathi sase-Saint Pierre nase-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Isikhathi sase-North American Mountain esijwayelekile",
               "MST",
               "Isikhathi sase-North American Mountain sasemini",
               "MST",
               "Isikhathi sase-North American Mountain",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Isikhathi sase-Marshall Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Isikhathi sase-Northwest Mexico esijwayelekile",
               "",
               "Isikhathi sase-Northwest Mexico sasemini",
               "",
               "Isikhathi sase-Northwest Mexico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Isikhathi sase-Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Isikhathi sase-Australian Central esivamile",
               "ACST",
               "Isikhathi sase-Australian Central sasemini",
               "ACDT",
               "Isikhathi sase-Central Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Isikhathi esivamile sase-Australian East",
               "AEST",
               "Isikhathi sasemini sase-Australian East",
               "AEDT",
               "Isikhathi sase-Eastern Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Isikhathi sase-Australian Western esivamile",
               "AWST",
               "Isikhathi sase-Australian Western sasemini",
               "AWDT",
               "Isikhathi sase-Western Australia",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Isikhathi sase-East Greenland esijwayelekile",
               "",
               "Isikhathi sase-East Greenland sasemini",
               "",
               "Isikhathi sase-East Greenland",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Isikhathi sase-West Greenland esijwayelekile",
               "",
               "Isikhathi sase-West Greenland sasehlobo",
               "",
               "Isikhathi sase-West Greenland",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Isikhathi sase-Central Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Isikhathi sase-Eastern Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Isikhathi sase-Western Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Isikhathi sase-Mpumalanga ne-Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Isikhathi saseNtshonalanga ne-Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Isikhathi sase-Australian Central West esivamile",
               "",
               "Isikhathi sasemini sase-Australian Central West",
               "",
               "Isikhathi sase-Australian Central West",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Isikhathi sase-Greenwich Mean",
                    "GMT",
                    "isikhathi sase-Irish esivamile",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Isikhathi sase-Greenwich Mean",
                    "GMT",
                    "isikhathi sase-British sasehlobo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Isikhathi sase-Greenwich Mean",
                    "GMT",
                    "isikhathi sase-British sasehlobo",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "i-Aden" },
            { "timezone.excity.Asia/Baku", "i-Baku" },
            { "timezone.excity.Asia/Dili", "i-Dili" },
            { "timezone.excity.Asia/Gaza", "iGaza" },
            { "timezone.excity.Asia/Hovd", "i-Hovd" },
            { "timezone.excity.Asia/Omsk", "i-Omsk" },
            { "timezone.excity.Asia/Oral", "i-Oral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "i-Amman" },
            { "timezone.excity.Asia/Aqtau", "i-Aqtau" },
            { "timezone.excity.Asia/Chita", "i-Chita" },
            { "timezone.excity.Asia/Dhaka", "i-Dhaka" },
            { "timezone.excity.Asia/Dubai", "i-Dubai" },
            { "timezone.excity.Asia/Kabul", "i-Kabul" },
            { "timezone.excity.Asia/Macau", "i-Macau" },
            { "timezone.excity.Asia/Qatar", "i-Qatar" },
            { "timezone.excity.Asia/Seoul", "i-Seoul" },
            { "timezone.excity.Asia/Tokyo", "i-Tokyo" },
            { "timezone.excity.Asia/Tomsk", "i-Tomsk" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "iJuba" },
            { "timezone.excity.Africa/Lome", "i-Lome" },
            { "timezone.excity.Asia/Almaty", "i-Almaty" },
            { "timezone.excity.Asia/Anadyr", "i-Anadyr" },
            { "timezone.excity.Asia/Aqtobe", "i-Aqtobe" },
            { "timezone.excity.Asia/Beirut", "i-Beirut" },
            { "timezone.excity.Asia/Brunei", "i-Brunei" },
            { "timezone.excity.Asia/Hebron", "i-Hebron" },
            { "timezone.excity.Asia/Kuwait", "i-Kuwait" },
            { "timezone.excity.Asia/Manila", "i-Manila" },
            { "timezone.excity.Asia/Muscat", "i-Muscat" },
            { "timezone.excity.Asia/Riyadh", "i-Riyadh" },
            { "timezone.excity.Asia/Saigon", "i-Ho Chi Minh City" },
            { "timezone.excity.Asia/Taipei", "i-Taipei" },
            { "timezone.excity.Asia/Tehran", "i-Tehran" },
            { "timezone.excity.Asia/Urumqi", "i-Urumqi" },
            { "timezone.excity.Etc/Unknown", "idolobha elingaziwa" },
            { "timezone.excity.Europe/Kiev", "i-Kiev" },
            { "timezone.excity.Europe/Oslo", "i-Oslo" },
            { "timezone.excity.Europe/Riga", "i-Riga" },
            { "timezone.excity.Europe/Rome", "i-Rome" },
            { "timezone.excity.Indian/Mahe", "iMahe" },
            { "timezone.excity.Africa/Accra", "i-Accra" },
            { "timezone.excity.Africa/Cairo", "i-Cairo" },
            { "timezone.excity.Africa/Ceuta", "i-Ceuta" },
            { "timezone.excity.Africa/Dakar", "i-Dakar" },
            { "timezone.excity.Africa/Lagos", "i-Lagos" },
            { "timezone.excity.Africa/Tunis", "i-Tunis" },
            { "timezone.excity.America/Adak", "i-Adak" },
            { "timezone.excity.America/Lima", "i-Lima" },
            { "timezone.excity.America/Nome", "i-Nome" },
            { "timezone.excity.Asia/Baghdad", "i-Baghdad" },
            { "timezone.excity.Asia/Bahrain", "i-Bahrain" },
            { "timezone.excity.Asia/Bangkok", "i-Bangkok" },
            { "timezone.excity.Asia/Barnaul", "i-Barnaul" },
            { "timezone.excity.Asia/Bishkek", "i-Bishkek" },
            { "timezone.excity.Asia/Colombo", "i-Colombo" },
            { "timezone.excity.Asia/Irkutsk", "i-Irkutsk" },
            { "timezone.excity.Asia/Jakarta", "i-Jakarta" },
            { "timezone.excity.Asia/Karachi", "i-Karachi" },
            { "timezone.excity.Asia/Kuching", "i-Kuching" },
            { "timezone.excity.Asia/Magadan", "i-Magadan" },
            { "timezone.excity.Asia/Nicosia", "i-Nicosia" },
            { "timezone.excity.Asia/Rangoon", "i-Rangoon" },
            { "timezone.excity.Asia/Tbilisi", "i-Tbilisi" },
            { "timezone.excity.Asia/Thimphu", "i-Thimphu" },
            { "timezone.excity.Asia/Yakutsk", "i-Yakutsk" },
            { "timezone.excity.Asia/Yerevan", "i-Yerevan" },
            { "timezone.excity.Europe/Kirov", "i-Kirov" },
            { "timezone.excity.Europe/Malta", "i-Malta" },
            { "timezone.excity.Europe/Minsk", "i-Minsk" },
            { "timezone.excity.Europe/Paris", "i-Paris" },
            { "timezone.excity.Europe/Sofia", "i-Sofia" },
            { "timezone.excity.Europe/Vaduz", "i-Vaduz" },
            { "timezone.excity.Indian/Cocos", "i-Cocos" },
            { "timezone.excity.Pacific/Apia", "i-Apia" },
            { "timezone.excity.Pacific/Fiji", "i-Fiji" },
            { "timezone.excity.Pacific/Guam", "i-Guam" },
            { "timezone.excity.Pacific/Niue", "i-Niue" },
            { "timezone.excity.Pacific/Truk", "i-Chuuk" },
            { "timezone.excity.Pacific/Wake", "i-Wake" },
            { "timezone.excity.Africa/Asmera", "i-Asmara" },
            { "timezone.excity.Africa/Bamako", "i-Bamako" },
            { "timezone.excity.Africa/Bangui", "i-Bangui" },
            { "timezone.excity.Africa/Banjul", "i-Banjul" },
            { "timezone.excity.Africa/Bissau", "i-Bissau" },
            { "timezone.excity.Africa/Douala", "i-Douala" },
            { "timezone.excity.Africa/Harare", "i-Harare" },
            { "timezone.excity.Africa/Kigali", "i-Kigali" },
            { "timezone.excity.Africa/Luanda", "i-Luanda" },
            { "timezone.excity.Africa/Lusaka", "iLusaka" },
            { "timezone.excity.Africa/Malabo", "iMalabo" },
            { "timezone.excity.Africa/Maputo", "iMaputo" },
            { "timezone.excity.Africa/Maseru", "iMaseru" },
            { "timezone.excity.Africa/Niamey", "i-Niamey" },
            { "timezone.excity.America/Aruba", "i-Aruba" },
            { "timezone.excity.America/Bahia", "i-Bahia" },
            { "timezone.excity.America/Belem", "i-Belem" },
            { "timezone.excity.America/Boise", "i-Boise" },
            { "timezone.excity.America/Jujuy", "i-Jujuy" },
            { "timezone.excity.America/Sitka", "i-Sitka" },
            { "timezone.excity.America/Thule", "i-Thule" },
            { "timezone.excity.Asia/Ashgabat", "i-Ashgabat" },
            { "timezone.excity.Asia/Calcutta", "i-Kolkata" },
            { "timezone.excity.Asia/Damascus", "i-Damascus" },
            { "timezone.excity.Asia/Dushanbe", "i-Dushanbe" },
            { "timezone.excity.Asia/Jayapura", "i-Jayapura" },
            { "timezone.excity.Asia/Katmandu", "i-Kathmandu" },
            { "timezone.excity.Asia/Khandyga", "i-Khandyga" },
            { "timezone.excity.Asia/Makassar", "i-Makassar" },
            { "timezone.excity.Asia/Qostanay", "I-Kostanay" },
            { "timezone.excity.Asia/Sakhalin", "i-Sakhalin" },
            { "timezone.excity.Asia/Shanghai", "i-Shanghai" },
            { "timezone.excity.Asia/Tashkent", "i-Tashkent" },
            { "timezone.excity.Asia/Ust-Nera", "i-Ust-Nera" },
            { "timezone.excity.Europe/Athens", "i-Athens" },
            { "timezone.excity.Europe/Berlin", "i-Berlin" },
            { "timezone.excity.Europe/Dublin", "i-Dublin" },
            { "timezone.excity.Europe/Jersey", "i-Jersey" },
            { "timezone.excity.Europe/Lisbon", "i-Lisbon" },
            { "timezone.excity.Europe/London", "i-London" },
            { "timezone.excity.Europe/Madrid", "i-Madrid" },
            { "timezone.excity.Europe/Monaco", "i-Monaco" },
            { "timezone.excity.Europe/Moscow", "i-Moscow" },
            { "timezone.excity.Europe/Prague", "i-Prague" },
            { "timezone.excity.Europe/Samara", "i-Samara" },
            { "timezone.excity.Europe/Skopje", "i-Skopje" },
            { "timezone.excity.Europe/Tirane", "i-Tirane" },
            { "timezone.excity.Europe/Vienna", "i-Vienna" },
            { "timezone.excity.Europe/Warsaw", "i-Warsaw" },
            { "timezone.excity.Europe/Zagreb", "i-Zagreb" },
            { "timezone.excity.Europe/Zurich", "i-Zurich" },
            { "timezone.excity.Indian/Chagos", "i-Chagos" },
            { "timezone.excity.Indian/Comoro", "i-Comoro" },
            { "timezone.excity.Pacific/Efate", "i-Efate" },
            { "timezone.excity.Pacific/Nauru", "i-Nauru" },
            { "timezone.excity.Pacific/Palau", "i-Palau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "i-Abidjan" },
            { "timezone.excity.Africa/Algiers", "i-Algiers" },
            { "timezone.excity.Africa/Conakry", "i-Conakry" },
            { "timezone.excity.Africa/Kampala", "i-Kampala" },
            { "timezone.excity.Africa/Mbabane", "iMbabane" },
            { "timezone.excity.Africa/Nairobi", "i-Nairobi" },
            { "timezone.excity.Africa/Tripoli", "i-Tripoli" },
            { "timezone.excity.America/Belize", "i-Belize" },
            { "timezone.excity.America/Bogota", "i-Bogota" },
            { "timezone.excity.America/Cancun", "i-Cancun" },
            { "timezone.excity.America/Cayman", "i-Cayman" },
            { "timezone.excity.America/Cuiaba", "i-Cuiaba" },
            { "timezone.excity.America/Dawson", "i-Dawson" },
            { "timezone.excity.America/Denver", "i-Denver" },
            { "timezone.excity.America/Guyana", "i-Guyana" },
            { "timezone.excity.America/Havana", "i-Havana" },
            { "timezone.excity.America/Inuvik", "i-Inuvik" },
            { "timezone.excity.America/Juneau", "i-Juneau" },
            { "timezone.excity.America/La_Paz", "i-La Paz" },
            { "timezone.excity.America/Maceio", "i-Maceio" },
            { "timezone.excity.America/Manaus", "i-Manaus" },
            { "timezone.excity.America/Merida", "i-Merida" },
            { "timezone.excity.America/Nassau", "i-Nassau" },
            { "timezone.excity.America/Panama", "i-Panama" },
            { "timezone.excity.America/Recife", "i-Recife" },
            { "timezone.excity.America/Regina", "i-Regina" },
            { "timezone.excity.Asia/Hong_Kong", "i-Hong Kong" },
            { "timezone.excity.Asia/Jerusalem", "i-Jerusalem" },
            { "timezone.excity.Asia/Kamchatka", "i-Kamchatka" },
            { "timezone.excity.Asia/Pontianak", "i-Pontianak" },
            { "timezone.excity.Asia/Pyongyang", "i-Pyongyang" },
            { "timezone.excity.Asia/Qyzylorda", "i-Qyzylorda" },
            { "timezone.excity.Asia/Samarkand", "i-Samarkand" },
            { "timezone.excity.Asia/Singapore", "i-Singapore" },
            { "timezone.excity.Asia/Vientiane", "i-Vientiane" },
            { "timezone.excity.Europe/Andorra", "i-Andorra" },
            { "timezone.excity.Europe/Saratov", "i-Saratov" },
            { "timezone.excity.Europe/Tallinn", "i-Tallinn" },
            { "timezone.excity.Europe/Vatican", "i-Vatican" },
            { "timezone.excity.Europe/Vilnius", "i-Vilnius" },
            { "timezone.excity.Indian/Mayotte", "i-Mayotte" },
            { "timezone.excity.Indian/Reunion", "i-R\u00e9union" },
            { "timezone.excity.Pacific/Easter", "i-Easter" },
            { "timezone.excity.Pacific/Kosrae", "i-Kosrae" },
            { "timezone.excity.Pacific/Majuro", "i-Majuro" },
            { "timezone.excity.Pacific/Midway", "i-Midway" },
            { "timezone.excity.Pacific/Noumea", "i-Noumea" },
            { "timezone.excity.Pacific/Ponape", "i-Pohnpei" },
            { "timezone.excity.Pacific/Saipan", "i-Saipan" },
            { "timezone.excity.Pacific/Tahiti", "i-Tahiti" },
            { "timezone.excity.Pacific/Tarawa", "i-Tarawa" },
            { "timezone.excity.Pacific/Wallis", "i-Wallis" },
            { "timezone.excity.Africa/Blantyre", "i-Blantyre" },
            { "timezone.excity.Africa/Djibouti", "i-Djibouti" },
            { "timezone.excity.Africa/El_Aaiun", "i-El Aaiun" },
            { "timezone.excity.Africa/Freetown", "i-Freetown" },
            { "timezone.excity.Africa/Gaborone", "i-Gaborone" },
            { "timezone.excity.Africa/Khartoum", "i-Khartoum" },
            { "timezone.excity.Africa/Kinshasa", "i-Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "i-Monrovia" },
            { "timezone.excity.Africa/Ndjamena", "i-Ndjamena" },
            { "timezone.excity.Africa/Sao_Tome", "i-S\u00e3o Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "i-Windhoek" },
            { "timezone.excity.America/Antigua", "i-Antigua" },
            { "timezone.excity.America/Caracas", "i-Caracas" },
            { "timezone.excity.America/Cayenne", "i-Cayenne" },
            { "timezone.excity.America/Chicago", "i-Chicago" },
            { "timezone.excity.America/Cordoba", "i-Cordoba" },
            { "timezone.excity.America/Creston", "i-Creston" },
            { "timezone.excity.America/Curacao", "i-Cura\u00e7ao" },
            { "timezone.excity.America/Detroit", "i-Detroit" },
            { "timezone.excity.America/Godthab", "i-Nuuk" },
            { "timezone.excity.America/Grenada", "i-Grenada" },
            { "timezone.excity.America/Halifax", "i-Halifax" },
            { "timezone.excity.America/Iqaluit", "i-Iqaluit" },
            { "timezone.excity.America/Jamaica", "i-Jamaica" },
            { "timezone.excity.America/Managua", "i-Managua" },
            { "timezone.excity.America/Marigot", "i-Marigot" },
            { "timezone.excity.America/Mendoza", "i-Mendoza" },
            { "timezone.excity.America/Moncton", "i-Moncton" },
            { "timezone.excity.America/Nipigon", "i-Nipigon" },
            { "timezone.excity.America/Noronha", "i-Noronha" },
            { "timezone.excity.America/Ojinaga", "i-Ojinaga" },
            { "timezone.excity.America/Phoenix", "i-Phoenix" },
            { "timezone.excity.America/Tijuana", "i-Tijuana" },
            { "timezone.excity.America/Toronto", "i-Toronto" },
            { "timezone.excity.America/Tortola", "i-Tortola" },
            { "timezone.excity.America/Yakutat", "i-Yakutat" },
            { "timezone.excity.Asia/Choibalsan", "i-Choibalsan" },
            { "timezone.excity.Asia/Phnom_Penh", "i-Phnom Penh" },
            { "timezone.excity.Atlantic/Azores", "i-Azores" },
            { "timezone.excity.Atlantic/Canary", "i-Canary" },
            { "timezone.excity.Atlantic/Faeroe", "i-Faroe" },
            { "timezone.excity.Australia/Eucla", "i-Eucla" },
            { "timezone.excity.Australia/Perth", "i-Perth" },
            { "timezone.excity.Europe/Belgrade", "i-Belgrade" },
            { "timezone.excity.Europe/Brussels", "i-Brussels" },
            { "timezone.excity.Europe/Budapest", "i-Budapest" },
            { "timezone.excity.Europe/Busingen", "i-Busingen" },
            { "timezone.excity.Europe/Chisinau", "i-Chisinau" },
            { "timezone.excity.Europe/Guernsey", "i-Guernsey" },
            { "timezone.excity.Europe/Helsinki", "i-Helsinki" },
            { "timezone.excity.Europe/Istanbul", "i-Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "i-Sarajevo" },
            { "timezone.excity.Europe/Uzhgorod", "i-Uzhhorod" },
            { "timezone.excity.Indian/Maldives", "i-Maldives" },
            { "timezone.excity.Pacific/Chatham", "i-Chatham" },
            { "timezone.excity.Pacific/Fakaofo", "i-Fakaofo" },
            { "timezone.excity.Pacific/Gambier", "i-Gambier" },
            { "timezone.excity.Pacific/Norfolk", "i-Norfolk" },
            { "timezone.excity.Africa/Bujumbura", "i-Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "i-Mogadishu" },
            { "timezone.excity.America/Anguilla", "i-Anguilla" },
            { "timezone.excity.America/Asuncion", "i-Asunci\u00f3n" },
            { "timezone.excity.America/Barbados", "i-Barbados" },
            { "timezone.excity.America/Dominica", "i-Dominica" },
            { "timezone.excity.America/Edmonton", "i-Edmonton" },
            { "timezone.excity.America/Eirunepe", "i-Eirunepe" },
            { "timezone.excity.America/Mazatlan", "i-Mazatlan" },
            { "timezone.excity.America/Miquelon", "i-Miquelon" },
            { "timezone.excity.America/New_York", "i-New York" },
            { "timezone.excity.America/Resolute", "i-Resolute" },
            { "timezone.excity.America/Santarem", "i-Santarem" },
            { "timezone.excity.America/Santiago", "i-Santiago" },
            { "timezone.excity.America/St_Johns", "i-St. John\u2019s" },
            { "timezone.excity.America/St_Kitts", "i-St. Kitts" },
            { "timezone.excity.America/St_Lucia", "I-St. Lucia" },
            { "timezone.excity.America/Winnipeg", "i-Winnipeg" },
            { "timezone.excity.Antarctica/Casey", "i-Casey" },
            { "timezone.excity.Antarctica/Davis", "i-Davis" },
            { "timezone.excity.Antarctica/Syowa", "i-Syowa" },
            { "timezone.excity.Antarctica/Troll", "i-Troll" },
            { "timezone.excity.Asia/Krasnoyarsk", "i-Krasnoyarsk" },
            { "timezone.excity.Asia/Novosibirsk", "i-Novosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "i-Ulaanbaatar" },
            { "timezone.excity.Asia/Vladivostok", "i-Vladivostok" },
            { "timezone.excity.Atlantic/Bermuda", "i-Bermuda" },
            { "timezone.excity.Atlantic/Madeira", "i-Madeira" },
            { "timezone.excity.Atlantic/Stanley", "i-Stanley" },
            { "timezone.excity.Australia/Currie", "i-Currie" },
            { "timezone.excity.Australia/Darwin", "i-Darwin" },
            { "timezone.excity.Australia/Hobart", "i-Hobart" },
            { "timezone.excity.Australia/Sydney", "i-Sydney" },
            { "timezone.excity.Europe/Amsterdam", "i-Amsterdam" },
            { "timezone.excity.Europe/Astrakhan", "i-Astrakhan" },
            { "timezone.excity.Europe/Bucharest", "i-Bucharest" },
            { "timezone.excity.Europe/Gibraltar", "i-Gibraltar" },
            { "timezone.excity.Europe/Ljubljana", "i-Ljubljana" },
            { "timezone.excity.Europe/Mariehamn", "i-Mariehamn" },
            { "timezone.excity.Europe/Podgorica", "i-Podgorica" },
            { "timezone.excity.Europe/Stockholm", "i-Stockholm" },
            { "timezone.excity.Europe/Ulyanovsk", "i-Ulyanovsk" },
            { "timezone.excity.Europe/Volgograd", "i-Volgograd" },
            { "timezone.excity.Indian/Christmas", "Ukhisimusi" },
            { "timezone.excity.Indian/Kerguelen", "i-Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "i-Mauritius" },
            { "timezone.excity.Pacific/Auckland", "i-Auckland" },
            { "timezone.excity.Pacific/Funafuti", "i-Funafuti" },
            { "timezone.excity.Pacific/Honolulu", "i-Honolulu" },
            { "timezone.excity.Pacific/Johnston", "i-Johnston" },
            { "timezone.excity.Pacific/Pitcairn", "i-Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "i-Casablanca" },
            { "timezone.excity.Africa/Libreville", "i-Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "i-Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "i-Nouakchott" },
            { "timezone.excity.Africa/Porto-Novo", "i-Porto-Novo" },
            { "timezone.excity.America/Anchorage", "i-Anchorage" },
            { "timezone.excity.America/Araguaina", "i-Araguaina" },
            { "timezone.excity.America/Boa_Vista", "i-Boa Vista" },
            { "timezone.excity.America/Catamarca", "i-Catamarca" },
            { "timezone.excity.America/Chihuahua", "i-Chihuahua" },
            { "timezone.excity.America/Fortaleza", "i-Fortaleza" },
            { "timezone.excity.America/Glace_Bay", "i-Glace Bay" },
            { "timezone.excity.America/Goose_Bay", "i-Goose Bay" },
            { "timezone.excity.America/Guatemala", "i-Guatemala" },
            { "timezone.excity.America/Guayaquil", "i-Guayaquil" },
            { "timezone.excity.America/Matamoros", "i-Matamoros" },
            { "timezone.excity.America/Menominee", "i-Menominee" },
            { "timezone.excity.America/Monterrey", "i-Monterrey" },
            { "timezone.excity.America/Sao_Paulo", "i-Sao Paulo" },
            { "timezone.excity.America/St_Thomas", "i-St. Thomas" },
            { "timezone.excity.America/Vancouver", "i-Vancouver" },
            { "timezone.excity.Antarctica/Mawson", "i-Mawson" },
            { "timezone.excity.Antarctica/Palmer", "i-Palmer" },
            { "timezone.excity.Antarctica/Vostok", "i-Vostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "i-Kuala Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "i-Novokuznetsk" },
            { "timezone.excity.Europe/Bratislava", "i-Bratislava" },
            { "timezone.excity.Europe/Copenhagen", "i-Copenhagen" },
            { "timezone.excity.Europe/Luxembourg", "i-Luxembourg" },
            { "timezone.excity.Europe/San_Marino", "i-San Marino" },
            { "timezone.excity.Europe/Simferopol", "i-Simferopol" },
            { "timezone.excity.Europe/Zaporozhye", "i-Zaporozhye" },
            { "timezone.excity.Pacific/Enderbury", "i-Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "i-Galapagos" },
            { "timezone.excity.Pacific/Kwajalein", "i-Kwajalein" },
            { "timezone.excity.Pacific/Marquesas", "i-Marquesas" },
            { "timezone.excity.Pacific/Pago_Pago", "i-Pago Pago" },
            { "timezone.excity.Pacific/Rarotonga", "i-Rarotonga" },
            { "timezone.excity.Pacific/Tongatapu", "i-Tongatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "i-Addis Ababa" },
            { "timezone.excity.Africa/Brazzaville", "i-Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "i-Ouagadougou" },
            { "timezone.excity.America/Costa_Rica", "i-Costa Rica" },
            { "timezone.excity.America/Grand_Turk", "i-Grand Turk" },
            { "timezone.excity.America/Guadeloupe", "i-Guadeloupe" },
            { "timezone.excity.America/Hermosillo", "i-Hermosillo" },
            { "timezone.excity.America/Kralendijk", "i-Kralendijk" },
            { "timezone.excity.America/Louisville", "i-Louisville" },
            { "timezone.excity.America/Martinique", "i-Martinique" },
            { "timezone.excity.America/Metlakatla", "i-Metlakatla" },
            { "timezone.excity.America/Montevideo", "i-Montevideo" },
            { "timezone.excity.America/Montserrat", "i-Montserrat" },
            { "timezone.excity.America/Paramaribo", "i-Paramaribo" },
            { "timezone.excity.America/Rio_Branco", "i-Rio Branco" },
            { "timezone.excity.America/St_Vincent", "i-St. Vincent" },
            { "timezone.excity.America/Whitehorse", "i-Whitehorse" },
            { "timezone.excity.Antarctica/McMurdo", "i-McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "i-Rothera" },
            { "timezone.excity.Asia/Srednekolymsk", "i-Srednekolymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "i-Yekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "i-Reykjavik" },
            { "timezone.excity.Atlantic/St_Helena", "i-St. Helena" },
            { "timezone.excity.Australia/Adelaide", "i-Adelaide" },
            { "timezone.excity.Australia/Brisbane", "i-Brisbane" },
            { "timezone.excity.Australia/Lindeman", "i-Lindeman" },
            { "timezone.excity.Europe/Isle_of_Man", "i-Isle of Man" },
            { "timezone.excity.Europe/Kaliningrad", "i-Kaliningrad" },
            { "timezone.excity.Pacific/Kiritimati", "i-Kiritimati" },
            { "timezone.excity.Africa/Johannesburg", "i-Johannesburg" },
            { "timezone.excity.America/El_Salvador", "i-El Salvador" },
            { "timezone.excity.America/Fort_Nelson", "i-Fort Nelson" },
            { "timezone.excity.America/Los_Angeles", "i-Los Angeles" },
            { "timezone.excity.America/Mexico_City", "i-Mexico City" },
            { "timezone.excity.America/Pangnirtung", "i-Pangnirtung" },
            { "timezone.excity.America/Porto_Velho", "i-Porto Velho" },
            { "timezone.excity.America/Puerto_Rico", "i-Puerto Rico" },
            { "timezone.excity.America/Rainy_River", "i-Rainy River" },
            { "timezone.excity.America/Tegucigalpa", "i-Tegucigalpa" },
            { "timezone.excity.America/Thunder_Bay", "i-Thunder Bay" },
            { "timezone.excity.America/Yellowknife", "i-Yellowknife" },
            { "timezone.excity.Arctic/Longyearbyen", "i-Longyearbyen" },
            { "timezone.excity.Atlantic/Cape_Verde", "i-Cape Verde" },
            { "timezone.excity.Australia/Lord_Howe", "i-Lord Howe" },
            { "timezone.excity.Australia/Melbourne", "i-Melbourne" },
            { "timezone.excity.Indian/Antananarivo", "i-Antananarivo" },
            { "timezone.excity.Pacific/Guadalcanal", "i-Guadalcanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "i-Dar es Salaam" },
            { "timezone.excity.America/Blanc-Sablon", "i-Blanc-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "i-Buenos Aires" },
            { "timezone.excity.America/Campo_Grande", "i-Campo Grande" },
            { "timezone.excity.America/Danmarkshavn", "i-Danmarkshavn" },
            { "timezone.excity.America/Dawson_Creek", "i-Dawson Creek" },
            { "timezone.excity.America/Indiana/Knox", "i-Knox, Indiana" },
            { "timezone.excity.America/Indianapolis", "i-Indianapolis" },
            { "timezone.excity.America/Punta_Arenas", "i-Punta Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "i-Rankin Inlet" },
            { "timezone.excity.America/Santa_Isabel", "i-Santa Isabel" },
            { "timezone.excity.America/Scoresbysund", "i-Ittoqqortoormiit" },
            { "timezone.excity.Antarctica/Macquarie", "i-Macquarie" },
            { "timezone.excity.Pacific/Bougainville", "i-Bougainville" },
            { "timezone.excity.Pacific/Port_Moresby", "i-Port Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "i-Cambridge Bay" },
            { "timezone.excity.America/Coral_Harbour", "i-Atikokan" },
            { "timezone.excity.America/Indiana/Vevay", "i-Vevay, Indiana" },
            { "timezone.excity.America/Lower_Princes", "i-Lower Prince\u2019s Quarter" },
            { "timezone.excity.America/Port_of_Spain", "i-Port of Spain" },
            { "timezone.excity.America/Santo_Domingo", "i-Santo Domingo" },
            { "timezone.excity.America/St_Barthelemy", "i-St. Barth\u00e9lemy" },
            { "timezone.excity.America/Swift_Current", "i-Swift Current" },
            { "timezone.excity.Australia/Broken_Hill", "i-Broken Hill" },
            { "timezone.excity.America/Bahia_Banderas", "i-Bahia Banderas" },
            { "timezone.excity.America/Port-au-Prince", "i-Port-au-Prince" },
            { "timezone.excity.Atlantic/South_Georgia", "i-South Georgia" },
            { "timezone.excity.America/Argentina/Salta", "i-Salta" },
            { "timezone.excity.America/Indiana/Marengo", "i-Marengo, Indiana" },
            { "timezone.excity.America/Indiana/Winamac", "i-Winamac, Indiana" },
            { "timezone.excity.America/Argentina/Tucuman", "i-Tucuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "i-Ushuaia" },
            { "timezone.excity.America/Indiana/Tell_City", "i-Tell City, Indiana" },
            { "timezone.excity.America/Indiana/Vincennes", "i-Vincennes, Indiana" },
            { "timezone.excity.Antarctica/DumontDUrville", "i-Dumont d\u2019Urville" },
            { "timezone.excity.America/Argentina/La_Rioja", "i-La Rioja" },
            { "timezone.excity.America/Argentina/San_Juan", "i-San Juan" },
            { "timezone.excity.America/Argentina/San_Luis", "i-San Luis" },
            { "timezone.excity.America/Indiana/Petersburg", "i-Petersburg, Indiana" },
            { "timezone.excity.America/Kentucky/Monticello", "i-Monticello, Kentucky" },
            { "timezone.excity.America/North_Dakota/Beulah", "i-Beulah, North Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "i-Center, North Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "i-Rio Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "i-New Salem, North Dakota" },
        };
        return data;
    }
}
