/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_cy extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Amser Safonol Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Amser Safonol Apia",
               "",
               "Amser Haf Apia",
               "",
               "Amser Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Amser Safonol Ynysoedd Cook",
               "",
               "Amser Hanner Haf Ynysoedd Cook",
               "",
               "Amser Ynysoedd Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Amser Safonol Ciwba",
               "CST",
               "Amser Haf Ciwa",
               "CDT",
               "Amser Ciwba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Amser Safonol Fiji",
               "",
               "Amser Haf Fiji",
               "",
               "Amser Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Amser Safonol y Gwlff",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Amser Safonol Hovd",
               "",
               "Amser Haf Hovd",
               "",
               "Amser Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Amser Safonol Iran",
               "",
               "Amser Haf Iran",
               "",
               "Amser Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Amser Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Amser Safonol Omsk",
               "",
               "Amser Haf Omsk",
               "",
               "Amser Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Amser Safonol Periw",
               "",
               "Amser Haf Periw",
               "",
               "Amser Periw",
               "",
            };
        final String[] Truk = new String[] {
               "Amser Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Amser Ynys Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Amser Safonol Chile",
               "",
               "Amser Haf Chile",
               "",
               "Amser Chile",
               "",
            };
        final String[] China = new String[] {
               "Amser Safonol Tsieina",
               "CST",
               "Amser Haf Tsieina",
               "CDT",
               "Amser Tsieina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Amser Ynysoedd Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Amser Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Amser India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Amser Safonol Japan",
               "JST",
               "Amser Haf Japan",
               "JDT",
               "Amser Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Amser Safonol Corea",
               "KST",
               "Amser Haf Corea",
               "KST",
               "Amser Corea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Amser Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Amser Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Amser Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Amser Safonol Samoa",
               "SST",
               "Amser Haf Samoa",
               "SST",
               "Amser Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Amser Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Amser Safonol Tonga",
               "",
               "Amser Haf Tonga",
               "",
               "Amser Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Amser Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Amser Safonol Alaska",
               "AKST",
               "Amser Haf Alaska",
               "AKDT",
               "Amser Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amser Safonol Amazonas",
               "",
               "Amser Haf Amazonas",
               "",
               "Amser Amazonas",
               "",
            };
        final String[] Azores = new String[] {
               "Amser Safonol yr Azores",
               "",
               "Amser Haf yr Azores",
               "",
               "Amser yr Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Amser Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Amser Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Amser Safonol Ynys y Pasg",
               "",
               "Amser Haf Ynys y Pasg",
               "",
               "Amser Ynys y Pasg",
               "",
            };
        final String[] Guyana = new String[] {
               "Amser Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Amser Safonol Israel",
               "IST",
               "Amser Haf Israel",
               "IDT",
               "Amser Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Amser Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Amser Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Amser Safonol Moscfa",
               "MSK",
               "Amser Haf Moscfa",
               "MSK",
               "Amser Moscfa",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Amser Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Amser Safonol Samara",
               "",
               "Amser Haf Samara",
               "",
               "Amser Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Amser Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Amser Safonol Taipei",
               "CST",
               "Amser Haf Taipei",
               "CDT",
               "Amser Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Amser Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Amser Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Amser Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Amser Safonol Arabaidd",
               "",
               "Amser Haf Arabaidd",
               "",
               "Amser Arabaidd",
               "",
            };
        final String[] Armenia = new String[] {
               "Amser Safonol Armenia",
               "",
               "Amser Haf Armenia",
               "",
               "Amser Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Amser Bolifia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Amser Safonol Chatham",
               "",
               "Amser Haf Chatham",
               "",
               "Amser Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Amser Cyffredniol Cydlynol",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Amser Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Amser Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Amser Safonol Georgia",
               "",
               "Amser Haf Georgia",
               "",
               "Amser Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Amser Safonol Irkutsk",
               "",
               "Amser Haf Irkutsk",
               "",
               "Amser Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Amser Safonol Magadan",
               "",
               "Amser Haf Magadan",
               "",
               "Amser Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Amser Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Amser Safonol Ynys Norfolk",
               "",
               "Amser Haf Ynys Norfolk",
               "",
               "Amser Ynys Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Amser Safonol Fernando de Noronha",
               "",
               "Amser Haf Fernando de Noronha",
               "",
               "Amser Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Amser R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Amser Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Amser Ynysoedd Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Amser Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Amser Safonol Uruguay",
               "",
               "Amser Haf Uruguay",
               "",
               "Amser Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Amser Safonol Vanuatu",
               "",
               "Amser Haf Vanuatu",
               "",
               "Amser Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Amser Safonol Yakutsk",
               "",
               "Amser Haf Yakutsk",
               "",
               "Amser Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Amser Safonol Cefnfor yr Iwerydd",
               "AST",
               "Amser Haf Cefnfor yr Iwerydd",
               "ADT",
               "Amser Cefnfor yr Iwerydd",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Amser Safonol Bras\u00edlia",
               "",
               "Amser Haf Bras\u00edlia",
               "",
               "Amser Bras\u00edlia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Amser Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Amser Safonol Colombia",
               "",
               "Amser Haf Colombia",
               "",
               "Amser Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Amser Safonol Ynysoedd Falklands/Malvinas",
               "",
               "Amser Haf Ynysoedd Falklands/Malvinas",
               "",
               "Amser Ynysoedd Falklands/Malvinas",
               "",
            };
        final String[] Malaysia = new String[] {
               "Amser Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Amser Y Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Amser Safonol Ulan Bator",
               "",
               "Amser Haf Ulan Bator",
               "",
               "Amser Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Amser Safonol Pakistan",
               "PKT",
               "Amser Haf Pakistan",
               "PKST",
               "Amser Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Amser Safonol Paraguay",
               "",
               "Amser Haf Paraguay",
               "",
               "Amser Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Amser Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Amser Safonol Sakhalin",
               "",
               "Amser Haf Sakhalin",
               "",
               "Amser Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Amser Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Amser Safonol Ariannin",
               "",
               "Amser Haf Ariannin",
               "",
               "Amser yr Ariannin",
               "",
            };
        final String[] Christmas = new String[] {
               "Amser Ynys Y Nadolig",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Amser Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Amser Safonol Hong Kong",
               "HKT",
               "Amser Haf Hong Kong",
               "HKST",
               "Amser Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Amser Indo-Tsieina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Amser Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Amser Safonol yr Arglwydd Howe",
               "",
               "Amser Haf yr Arglwydd Howe",
               "",
               "Amser yr Arglwydd Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Amser Marquises",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Amser Safonol Mauritius",
               "",
               "Amser Haf Mauritius",
               "",
               "Amser Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Amser Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Amser Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Amser Safonol Volgograd",
               "MSK",
               "Amser Haf Volgograd",
               "MSK",
               "Amser Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Amser Safonol Aserbaijan",
               "",
               "Amser Haf Aserbaijan",
               "",
               "Amser Aserbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Amser Safonol Bangladesh",
               "",
               "Amser Haf Bangladesh",
               "",
               "Amser Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Amser Safonol Cabo Verde",
               "",
               "Amser Haf Cabo Verde",
               "",
               "Amser Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Amser Dwyrain Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Amser Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Amser Tajicistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Amser Safonol Uzbekistan",
               "",
               "Amser Haf Uzbekistan",
               "",
               "Amser Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Amser Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Amser Safonol Krasnoyarsk",
               "",
               "Amser Haf Krasnoyarsk",
               "",
               "Amser Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Amser Safonol Seland Newydd",
               "NZST",
               "Amser Haf Seland Newydd",
               "NZDT",
               "Amser Seland Newydd",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Amser Safonol Novosibirsk",
               "",
               "Amser Haf Novosibirsk",
               "",
               "Amser Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Amser Safonol Pilipinas",
               "PST",
               "Amser Haf Pilipinas",
               "PDT",
               "Amser Pilipinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Amser Safonol Vladivostok",
               "",
               "Amser Haf Vladivostok",
               "",
               "Amser Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Amser Cefnfor India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Amser Ynysoedd Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Amser Safonol Newfoundland",
               "NST",
               "Amser Haf Newfoundland",
               "NDT",
               "Amser Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Amser Safonol Tyrcmenistan",
               "",
               "Amser Haf Tyrcmenistan",
               "",
               "Amser Tyrcmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Amser Guyane Ffrengig",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Amser Safonol Caledonia Newydd",
               "",
               "Amser Haf Caledonia Newydd",
               "",
               "Amser Caledonia Newydd",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Amser De Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Amser Safonol Yekaterinburg",
               "",
               "Amser Haf Yekaterinburg",
               "",
               "Amser Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Amser Canolbarth Affrica",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Amser Dwyrain Affrica",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Amser Safonol Gorllewin Affrica",
               "WAT",
               "Amser Haf Gorllewin Affrica",
               "WAT",
               "Amser Gorllewin Affrica",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Amser Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Amser Safonol Canolbarth Ewrop",
               "CET",
               "Amser Haf Canolbarth Ewrop",
               "CEST",
               "Amser Canolbarth Ewrop",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Amser Safonol Dwyrain Ewrop",
               "EET",
               "Amser Haf Dwyrain Ewrop",
               "EEST",
               "Amser Dwyrain Ewrop",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Amser Safonol Gorllewin Ewrop",
               "WET",
               "Amser Haf Gorllewin Ewrop",
               "WEST",
               "Amser Gorllewin Ewrop",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Amser Safonol Pasiffig Mecsico",
               "MST",
               "Amser Haf Pasiffig Mecsico",
               "MDT",
               "Amser Pasiffig Mecsico",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Amser Safonol De Affrica",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Amser Safonol Canolbarth Gogledd America",
               "CST",
               "Amser Haf Canolbarth Gogledd America",
               "CDT",
               "Amser Canolbarth Gogledd America",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Amser Safonol Dwyrain Gogledd America",
               "EST",
               "Amser Haf Dwyrain Gogledd America",
               "EST",
               "Amser Dwyrain Gogledd America",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Amser Safonol Cefnfor Tawel Gogledd America",
               "PST",
               "Amser Haf Cefnfor Tawel Gogledd America",
               "PDT",
               "Amser Cefnfor Tawel Gogledd America",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Amser Tiroedd Ffrainc yn y De a\u2019r Antarctig",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Amser Ynysoedd Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Amser Safonol Hawaii-Aleutian",
               "HST",
               "Amser Haf Hawaii-Aleutian",
               "HST",
               "Amser Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Amser Ynysoedd Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Amser Safonol Saint-Pierre-et-Miquelon",
               "",
               "Amser Haf Saint-Pierre-et-Miquelon",
               "",
               "Amser Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Amser Safonol Mynyddoedd Gogledd America",
               "MST",
               "Amser Haf Mynyddoedd Gogledd America",
               "MST",
               "Amser Mynyddoedd Gogledd America",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Amser Ynysoedd Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Amser Safonol Gogledd Orllewin Mecsico",
               "",
               "Amser Haf Gogledd Orllewin Mecsico",
               "",
               "Amser Gogledd Orllewin Mecsico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Amser Papua Guinea Newydd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Amser Safonol Canolbarth Awstralia",
               "ACST",
               "Amser Haf Canolbarth Awstralia",
               "ACDT",
               "Amser Canolbarth Awstralia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Amser Safonol Dwyrain Awstralia",
               "AEST",
               "Amser Haf Dwyrain Awstralia",
               "AEDT",
               "Amser Dwyrain Awstralia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Amser Safonol Gorllewin Awstralia",
               "AWST",
               "Amser Haf Gorllewin Awstralia",
               "AWDT",
               "Amser Gorllewin Awstralia",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Amser Safonol Dwyrain yr Ynys Las",
               "",
               "Amser Haf Dwyrain yr Ynys Las",
               "",
               "Amser Dwyrain yr Ynys Las",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Amser Safonol Gorllewin yr Ynys Las",
               "",
               "Amser Haf Gorllewin yr Ynys Las",
               "",
               "Amser Gorllewin yr Ynys Las",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Amser Canolbarth Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Amser Dwyrain Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Amser Gorllewin Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Amser Dwyrain Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Amser Gorllewin Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Amser Safonol Canolbarth Gorllewin Awstralia",
               "",
               "Amser Haf Canolbarth Gorllewin Awstralia",
               "",
               "Amser Canolbarth Gorllewin Awstralia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Amser Safonol Greenwich",
                    "GMT",
                    "Amser Safonol Iwerddon",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Amser Safonol Greenwich",
                    "GMT",
                    "Amser Haf Prydain",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Amser Safonol Greenwich",
                    "GMT",
                    "Amser Haf Prydain",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "Gasa" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Saigon", "Dinas H\u00f4 Chi Minh" },
            { "timezone.excity.Etc/Unknown", "Dinas Anhysbys" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Rhufain" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Europe/Dublin", "Dulyn" },
            { "timezone.excity.Europe/London", "Llundain" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Vienna", "Fienna" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Jerusalem", "Jerwsalem" },
            { "timezone.excity.Europe/Vatican", "Y Fatican" },
            { "timezone.excity.Pacific/Easter", "Ynys y Pasg" },
            { "timezone.excity.Atlantic/Canary", "Yr Ynysoedd Dedwydd" },
            { "timezone.excity.Atlantic/Faeroe", "Ffaro" },
            { "timezone.excity.Europe/Brussels", "Brwsel" },
            { "timezone.excity.Europe/Guernsey", "Ynys y Garn" },
            { "timezone.excity.Europe/Istanbul", "Caergystennin" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhhorod" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/New_York", "Efrog Newydd" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Europe/Bucharest", "Bwcar\u00e9st" },
            { "timezone.excity.Indian/Christmas", "Ynys y Nadolig" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Europe/Luxembourg", "Lwcsembwrg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Europe/Isle_of_Man", "Ynys Manaw" },
            { "timezone.excity.America/Mexico_City", "Dinas Mecsico" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.America/Cambridge_Bay", "Bae Cambridge" },
            { "timezone.excity.America/Bahia_Banderas", "Bae Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "De Georgia" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Indiana/Tell_City", "Dinas Tell, Indiana" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Gogledd Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Gogledd Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Gogledd Dakota" },
        };
        return data;
    }
}
