/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_si extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_HT = "\u0dc4\u0dba\u0dd2\u0da7\u0dd2";
        final String metaValue_TO = "\u0da7\u0ddc\u0d82\u0d9c\u0dcf";
        final String metaValue_ar = "\u0d85\u0dbb\u0dcf\u0db6\u0dd2";
        final String metaValue_hy = "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_bn = "\u0db6\u0dd9\u0d82\u0d9c\u0dcf\u0dbd\u0dd2";
        final String metaValue_ccp = "\u0da0\u0d9a\u0dca\u0db8\u0dcf";
        final String metaValue_ka = "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_el = "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a";
        final String metaValue_gu = "\u0d9c\u0dd4\u0da2\u0dbb\u0dcf\u0da7\u0dd2";
        final String metaValue_he = "\u0dc4\u0dd3\u0db6\u0df2";
        final String metaValue_ja = "\u0da2\u0db4\u0db1\u0dca";
        final String metaValue_km = "\u0d9a\u0db8\u0dbb\u0dca";
        final String metaValue_kn = "\u0d9a\u0dab\u0dca\u0dab\u0da9";
        final String metaValue_ko = "\u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4";
        final String metaValue_lo = "\u0dbd\u0dcf\u0d95";
        final String metaValue_la = "\u0dbd\u0dad\u0dd2\u0db1\u0dca";
        final String metaValue_ml = "\u0db8\u0dbd\u0dba\u0dcf\u0dbd\u0db8\u0dca";
        final String metaValue_nqo = "\u0d91\u0db1\u0dca\u2018\u0d9a\u0ddd";
        final String metaValue_si = "\u0dc3\u0dd2\u0d82\u0dc4\u0dbd";
        final String metaValue_ta = "\u0daf\u0dd9\u0db8\u0dc5";
        final String metaValue_te = "\u0dad\u0dd9\u0dc5\u0dd2\u0d9f\u0dd4";
        final String metaValue_th = "\u0dad\u0dcf\u0dba\u0dd2";
        final String metaValue_type_hc_h11 = "\u0db4\u0dd0\u0dba 12 \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba";
        final String metaValue_type_hc_h23 = "\u0db4\u0dd0\u0dba 24 \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba";
        final Object[][] data = new Object[][] {
            { "001", "\u0dbd\u0ddd\u0d9a\u0dba" },
            { "002", "\u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "003", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "005", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "009", "\u0d95\u0dc2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "011", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "013", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "014", "\u0db4\u0dd9\u0dbb\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "015", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "017", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "018", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "019", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "021", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4\u0daf\u0dd2\u0d9c \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "029", "\u0d9a\u0dd0\u0dbb\u0dd3\u0db6\u0dd2\u0dba\u0db1\u0dca" },
            { "030", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "034", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "035", "\u0d85\u0d9c\u0dca\u0db1\u0dd2\u0daf\u0dd2\u0d9c \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "039", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4\u0daf\u0dd2\u0d9c \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "053", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dbd\u0dda\u0dc2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "054", "\u0db8\u0dd9\u0dbd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "057", "\u0db8\u0dba\u0dd2\u0d9a\u0dca\u200d\u0dbb\u0ddd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9a\u0dc5\u0dcf\u0db4\u0dba" },
            { "061", "\u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "142", "\u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "143", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "145", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d86\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "150", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "151", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "154", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "155", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dba" },
            { "202", "\u0d8b\u0db4-\u0dc3\u0dc4\u0dbb\u0dcf\u0db1\u0dd4 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "419", "\u0dbd\u0dad\u0dd2\u0db1\u0dca \u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "AC", "\u0d87\u0dc3\u0dd9\u0db1\u0dca\u0dc2\u0db1\u0dca \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1" },
            { "AD", "\u0d87\u0db1\u0dca\u0da9\u0ddd\u0dbb\u0dcf\u0dc0" },
            { "AE", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d91\u0db8\u0dd2\u0dbb\u0dca \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba" },
            { "AF", "\u0d87\u0dc6\u0dca\u0d9c\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "AG", "\u0d87\u0db1\u0dca\u0da7\u0dd2\u0d9c\u0dd4\u0dc0\u0dcf \u0dc3\u0dc4 \u0db6\u0dcf\u0db6\u0dd2\u0dba\u0dd4\u0da9\u0dcf\u0dc0" },
            { "AI", "\u0d87\u0db1\u0dca\u0d9c\u0dd4\u0dba\u0dd2\u0dbd\u0dcf\u0dc0" },
            { "AL", "\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AM", "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AO", "\u0d87\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dcf\u0dc0" },
            { "AQ", "\u0d87\u0db1\u0dca\u0da7\u0dcf\u0d9a\u0dca\u0da7\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "AR", "\u0d86\u0dbb\u0dca\u0da2\u0dd9\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf\u0dc0" },
            { "AS", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf" },
            { "AT", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AU", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "AW", "\u0d85\u0dbb\u0dd6\u0db6\u0dcf" },
            { "AX", "\u0d95\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "AZ", "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dba" },
            { "BA", "\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0dc4\u0dbb\u0dca\u0dc3\u0d9c\u0ddc\u0dc0\u0dd3\u0db1\u0dcf\u0dc0" },
            { "BB", "\u0db6\u0dcf\u0db6\u0da9\u0ddd\u0dc3\u0dca" },
            { "BD", "\u0db6\u0d82\u0d9c\u0dca\u0dbd\u0dcf\u0daf\u0dda\u0dc1\u0dba" },
            { "BE", "\u0db6\u0dd9\u0dbd\u0dca\u0da2\u0dd2\u0dba\u0db8" },
            { "BF", "\u0db6\u0dbb\u0dca\u0d9a\u0dd2\u0db1\u0dcf \u0dc6\u0dcf\u0dc3\u0ddd" },
            { "BG", "\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "BH", "\u0db6\u0dc4\u0dbb\u0dda\u0db1\u0dca" },
            { "BI", "\u0db6\u0dd4\u0dbb\u0dd4\u0db1\u0dca\u0daf\u0dd2" },
            { "BJ", "\u0db6\u0dd9\u0db1\u0dd2\u0db1\u0dca" },
            { "BL", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db6\u0dbb\u0dca\u0dad\u0dbd\u0dd9\u0db8\u0dd2" },
            { "BM", "\u0db6\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dd4\u0da9\u0dcf" },
            { "BN", "\u0db6\u0df2\u0db1\u0dcf\u0dba\u0dd2" },
            { "BO", "\u0db6\u0ddc\u0dbd\u0dd3\u0dc0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "BQ", "\u0d9a\u0dd0\u0dbb\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "BR", "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd\u0dba" },
            { "BS", "\u0db6\u0dc4\u0db8\u0dcf\u0dc3\u0dca" },
            { "BT", "\u0db7\u0dd6\u0dad\u0dcf\u0db1\u0dba" },
            { "BV", "\u0db6\u0dd4\u0dc0\u0da7\u0dca \u0daf\u0dd4\u0db4\u0dad\u0dca" },
            { "BW", "\u0db6\u0ddc\u0da7\u0dca\u0dc3\u0dca\u0dc0\u0dcf\u0db1\u0dcf" },
            { "BY", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd4\u0dc3\u0dca" },
            { "BZ", "\u0db6\u0dd9\u0dbd\u0dd3\u0dc3\u0dca" },
            { "CA", "\u0d9a\u0dd0\u0db1\u0da9\u0dcf\u0dc0" },
            { "CC", "\u0d9a\u0ddc\u0d9a\u0ddd\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "CD", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddd\u0dc0 (\u0da9\u0dd3\u0d86\u0dbb\u0dca\u0dc3\u0dd3)" },
            { "CF", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0da2\u0db1\u0dbb\u0da2\u0dba" },
            { "CG", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddc - \u0db6\u0dca\u200d\u0dbb\u0dc3\u0dcf\u0dc0\u0dd2\u0dbd\u0dca" },
            { "CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca\u0da7\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "CI", "\u0d9a\u0ddd\u0da7\u0dca \u0daf\u0dd2 \u0d85\u0dba\u0dd2\u0dc0\u0dbb\u0dd2" },
            { "CK", "\u0d9a\u0dd4\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "CL", "\u0da0\u0dd2\u0dbd\u0dd3" },
            { "CM", "\u0d9a\u0dd0\u0db8\u0dbb\u0dd6\u0db1\u0dca" },
            { "CN", "\u0da0\u0dd3\u0db1\u0dba" },
            { "CO", "\u0d9a\u0ddc\u0dc5\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "CP", "\u0d9a\u0dca\u0dbd\u0dd3\u0db4\u0dbb\u0dca\u0da7\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "CR", "\u0d9a\u0ddc\u0dc3\u0dca\u0da7\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "CU", "\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0dc0" },
            { "CV", "\u0d9a\u0dda\u0db4\u0dca \u0dc0\u0dbb\u0dca\u0da9\u0dca" },
            { "CW", "\u0d9a\u0dd4\u0dbb\u0d9a\u0dcf\u0dc0\u0ddd" },
            { "CX", "\u0d9a\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dca\u0db8\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "CY", "\u0dc3\u0dba\u0dd2\u0db4\u0dca\u200d\u0dbb\u0dc3\u0dba" },
            { "CZ", "\u0da0\u0dd9\u0da0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "DE", "\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dd2\u0dba" },
            { "DG", "\u0daf\u0dd2\u0dba\u0dcf\u0d9c\u0ddd \u0d9c\u0dcf\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf" },
            { "DJ", "\u0da2\u0dd2\u0db6\u0dd4\u0da7\u0dd2" },
            { "DK", "\u0da9\u0dd9\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dca\u0d9a\u0dba" },
            { "DM", "\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "DO", "\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf \u0da2\u0db1\u0dbb\u0da2\u0dba" },
            { "DZ", "\u0d87\u0dbd\u0dca\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "EA", "\u0dc3\u0dd9\u0dba\u0dd4\u0da7\u0dcf \u0dc3\u0dc4 \u0db8\u0dd9\u0dbd\u0dd2\u0dbd\u0dca\u0dbd\u0dcf" },
            { "EC", "\u0d89\u0d9a\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba" },
            { "EE", "\u0d91\u0dc3\u0dca\u0dad\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "EG", "\u0d8a\u0da2\u0dd2\u0db4\u0dca\u0dad\u0dd4\u0dc0" },
            { "EH", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dc3\u0dc4\u0dbb\u0dcf\u0dc0" },
            { "ER", "\u0d91\u0dbb\u0dd2\u0dad\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ES", "\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4\u0dba" },
            { "ET", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0dc0" },
            { "EU", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dcf \u0dc3\u0d82\u0d9c\u0db8\u0dba" },
            { "EZ", "\u0dba\u0dd4\u0dbb\u0ddd \u0d9a\u0dbd\u0dcf\u0db4\u0dba" },
            { "FI", "\u0dc6\u0dd2\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "FJ", "\u0dc6\u0dd3\u0da2\u0dd3" },
            { "FK", "\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0dad \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "FM", "\u0db8\u0dba\u0dd2\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "FO", "\u0dc6\u0dd0\u0dbb\u0ddd \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "FR", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1\u0dba" },
            { "GA", "\u0d9c\u0dd0\u0db6\u0ddc\u0db1\u0dca" },
            { "GB", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0dbb\u0dcf\u0da2\u0db0\u0dcf\u0db1\u0dd2\u0dba" },
            { "GD", "\u0d9c\u0dca\u200d\u0dbb\u0dd0\u0db1\u0da9\u0dcf\u0dc0" },
            { "GE", "\u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GF", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0d9c\u0dba\u0db1\u0dcf\u0dc0" },
            { "GG", "\u0d9c\u0dbb\u0dca\u0db1\u0dca\u0dc3\u0dd2\u0dba" },
            { "GH", "\u0d9d\u0dcf\u0db1\u0dcf\u0dc0" },
            { "GI", "\u0da2\u0dd2\u0db6\u0dca\u200d\u0dbb\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0" },
            { "GL", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "GM", "\u0d9c\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GN", "\u0d9c\u0dd2\u0dab\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GP", "\u0d9c\u0dca\u0dc0\u0ddd\u0da9\u0dbd\u0ddd\u0db4\u0dca" },
            { "GQ", "\u0dc3\u0db8\u0d9a \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "GR", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2\u0dba" },
            { "GS", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0da2\u0ddd\u0dbb\u0dca\u0da2\u0dd2\u0dba\u0dcf\u0dc0 \u0dc3\u0dc4 \u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd0\u0db1\u0dca\u0da9\u0dca\u0dc0\u0dd2\u0da0\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "GT", "\u0d9c\u0ddd\u0dad\u0db8\u0dcf\u0dbd\u0dcf\u0dc0" },
            { "GU", "\u0d9c\u0dd4\u0dc0\u0dcf\u0db8\u0dca" },
            { "GW", "\u0d9c\u0dd2\u0db1\u0dd2 \u0db6\u0dd2\u0dc3\u0dc0\u0dca" },
            { "GY", "\u0d9c\u0dba\u0db1\u0dcf\u0dc0" },
            { "HK", "\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0dc0\u0dd2\u0dc1\u0dda\u0dc2 \u0db4\u0dbb\u0dd2\u0db4\u0dcf\u0dbd\u0db1 \u0d9a\u0dbd\u0dcf\u0db4\u0dba \u0da0\u0dd3\u0db1\u0dba" },
            { "HM", "\u0dc4\u0dbb\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0dca\u0da9\u0ddc\u0db1\u0dbd\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "HN", "\u0dc4\u0ddc\u0db1\u0dca\u0da9\u0dd4\u0dbb\u0dcf\u0dc3\u0dca" },
            { "HR", "\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0d92\u0dc2\u0dd2\u0dba\u0dcf\u0dc0" },
            { "HT", metaValue_HT },
            { "HU", "\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IC", "\u0d9a\u0dd0\u0db1\u0dbb\u0dd2 \u0dc3\u0dd6\u0db4\u0dad\u0dca" },
            { "ID", "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IE", "\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "IL", "\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd\u0dba" },
            { "IM", "\u0d85\u0dba\u0dd2\u0dbd\u0dca \u0d94\u0dc6\u0dca \u0db8\u0dd1\u0db1\u0dca" },
            { "IN", "\u0d89\u0db1\u0dca\u0daf\u0dd2\u0dba\u0dcf\u0dc0" },
            { "IO", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0db1\u0dca\u0daf\u0dd3\u0dba \u0dc3\u0dcf\u0d9c\u0dbb \u0db6\u0dbd \u0db4\u0dca\u200d\u0dbb\u0daf\u0dda\u0dc1\u0dba" },
            { "IQ", "\u0d89\u0dbb\u0dcf\u0d9a\u0dba" },
            { "IR", "\u0d89\u0dbb\u0dcf\u0db1\u0dba" },
            { "IS", "\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "IT", "\u0d89\u0dad\u0dcf\u0dbd\u0dd2\u0dba" },
            { "JE", "\u0da2\u0dbb\u0dca\u0dc3\u0dd2" },
            { "JM", "\u0da2\u0dd0\u0db8\u0dd9\u0dba\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "JO", "\u0da2\u0ddd\u0dbb\u0dca\u0daf\u0dcf\u0db1\u0dba" },
            { "JP", "\u0da2\u0db4\u0dcf\u0db1\u0dba" },
            { "KE", "\u0d9a\u0dd9\u0db1\u0dca\u0dba\u0dcf\u0dc0" },
            { "KG", "\u0d9a\u0dd2\u0dbb\u0dca\u0d9c\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "KH", "\u0d9a\u0dcf\u0db8\u0dca\u0db6\u0ddd\u0da2\u0dba" },
            { "KI", "\u0d9a\u0dd2\u0dbb\u0dd2\u0db6\u0dad\u0dd2" },
            { "KM", "\u0d9a\u0ddc\u0db8\u0ddc\u0dbb\u0ddd\u0dc3\u0dca" },
            { "KN", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0d9a\u0dd2\u0da7\u0dca\u0dc3\u0dca \u0dc3\u0dc4 \u0db1\u0dda\u0dc0\u0dd2\u0dc3\u0dca" },
            { "KP", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "KR", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "KW", "\u0d9a\u0dd4\u0dc0\u0dda\u0da7\u0dba" },
            { "KY", "\u0d9a\u0dda\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "KZ", "\u0d9a\u0dc3\u0d9a\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "LA", "\u0dbd\u0dcf\u0d95\u0dc3\u0dba" },
            { "LB", "\u0dbd\u0dd9\u0db6\u0db1\u0db1\u0dba" },
            { "LC", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dbd\u0dd4\u0dc3\u0dd2\u0dba\u0dcf" },
            { "LI", "\u0dbd\u0dd2\u0d9a\u0dca\u0da7\u0db1\u0dca\u0dc3\u0dca\u0da7\u0dba\u0dd2\u0db1\u0dca" },
            { "LK", "\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf\u0dc0" },
            { "LR", "\u0dbd\u0dba\u0dd2\u0db6\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LS", "\u0dbd\u0dd9\u0dc3\u0dad\u0ddd" },
            { "LT", "\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LU", "\u0dbd\u0d9a\u0dca\u0dc1\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca" },
            { "LV", "\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0dc0" },
            { "LY", "\u0dbd\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MA", "\u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd\u0dc0" },
            { "MC", "\u0db8\u0ddc\u0db1\u0dcf\u0d9a\u0ddd\u0dc0" },
            { "MD", "\u0db8\u0ddc\u0dbd\u0dca\u0da9\u0ddd\u0dc0\u0dcf\u0dc0" },
            { "ME", "\u0db8\u0ddc\u0db1\u0dca\u0da7\u0dd9\u0db1\u0dd3\u0d9c\u0dca\u200d\u0dbb\u0ddd" },
            { "MF", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db8\u0dcf\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dca" },
            { "MG", "\u0db8\u0dd0\u0da9\u0d9c\u0dc3\u0dca\u0d9a\u0dbb\u0dba" },
            { "MH", "\u0db8\u0dcf\u0dc2\u0dbd\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "MK", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0db8\u0dd0\u0dc3\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ML", "\u0db8\u0dcf\u0dbd\u0dd2" },
            { "MM", "\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb\u0dba (\u0db6\u0dd4\u0dbb\u0dd4\u0db8\u0dba)" },
            { "MN", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MO", "\u0db8\u0dd0\u0d9a\u0dcf\u0dc0\u0dd4 \u0dc0\u0dd2\u0dc1\u0dda\u0dc2 \u0db4\u0dbb\u0dd2\u0db4\u0dcf\u0dbd\u0db1 \u0d9a\u0dbd\u0dcf\u0db4\u0dba \u0da0\u0dd3\u0db1\u0dba" },
            { "MP", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0db8\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dcf \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "MQ", "\u0db8\u0dbb\u0dca\u0da7\u0dd2\u0db1\u0dd2\u0d9a\u0dca" },
            { "MR", "\u0db8\u0ddc\u0dbb\u0dd2\u0da7\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MS", "\u0db8\u0ddc\u0db1\u0dca\u0dc3\u0dd9\u0dbb\u0dcf\u0da7\u0dca" },
            { "MT", "\u0db8\u0ddd\u0dbd\u0dca\u0da7\u0dcf\u0dc0" },
            { "MU", "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2\u0dba" },
            { "MV", "\u0db8\u0dcf\u0dbd \u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1" },
            { "MW", "\u0db8\u0dbd\u0dcf\u0dc0\u0dd2" },
            { "MX", "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0ddd\u0dc0" },
            { "MY", "\u0db8\u0dd0\u0dbd\u0dda\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "MZ", "\u0db8\u0ddc\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0d9a\u0dca" },
            { "NA", "\u0db1\u0dd0\u0db8\u0dd3\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "NC", "\u0db1\u0dc0 \u0d9a\u0dd0\u0dbd\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "NE", "\u0db1\u0dba\u0dd2\u0da2\u0dbb\u0dca" },
            { "NF", "\u0db1\u0ddd\u0dc6\u0ddd\u0d9a\u0dca \u0daf\u0dd6\u0db4\u0dad" },
            { "NG", "\u0db1\u0dba\u0dd2\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "NI", "\u0db1\u0dd2\u0d9a\u0dbb\u0d9c\u0dd4\u0dc0\u0dcf\u0dc0" },
            { "NL", "\u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "NO", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dda" },
            { "NP", "\u0db1\u0dda\u0db4\u0dcf\u0dbd\u0dba" },
            { "NR", "\u0db1\u0dcf\u0dc0\u0dd4\u0dbb\u0dd4" },
            { "NU", "\u0db1\u0dd2\u0dba\u0dd6" },
            { "NZ", "\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "OM", "\u0d95\u0db8\u0dcf\u0db1\u0dba" },
            { "PA", "\u0db4\u0dd0\u0db1\u0db8\u0dcf\u0dc0" },
            { "PE", "\u0db4\u0dda\u0dbb\u0dd4" },
            { "PF", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "PG", "\u0db4\u0dd0\u0db4\u0dd4\u0dc0\u0dcf \u0db1\u0dd2\u0dc0\u0dca \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "PH", "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1\u0dba" },
            { "PK", "\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "PL", "\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "PM", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db4\u0dd2\u0dba\u0dbb\u0dda \u0dc3\u0dc4 \u0db8\u0dd0\u0d9a\u0ddd\u0dbd\u0db1\u0dca" },
            { "PN", "\u0db4\u0dd2\u0da7\u0dca\u0d9a\u0dd9\u0dba\u0dca\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "PR", "\u0db4\u0dd4\u0dc0\u0dbb\u0dca\u0da7\u0ddd \u0dbb\u0dd2\u0d9a\u0ddd" },
            { "PS", "\u0db4\u0dbd\u0dc3\u0dca\u0dad\u0dd3\u0db1 \u0dbb\u0dcf\u0da2\u0dca\u200d\u0dba\u0dba" },
            { "PT", "\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dcf\u0dbd\u0dba" },
            { "PW", "\u0db4\u0dbd\u0dcf\u0dc0\u0dd4" },
            { "PY", "\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda" },
            { "QA", "\u0d9a\u0da7\u0dcf\u0dbb\u0dca" },
            { "QO", "\u0d88\u0dad \u0d95\u0dc2\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RE", "\u0dbb\u0dd3\u0dba\u0dd4\u0db1\u0dd2\u0dba\u0db1\u0dca" },
            { "RO", "\u0dbb\u0dd4\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RS", "\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RU", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "RW", "\u0dbb\u0dd4\u0dc0\u0db1\u0dca\u0da9\u0dcf\u0dc0" },
            { "SA", "\u0dc3\u0dde\u0daf\u0dd2 \u0d85\u0dbb\u0dcf\u0db6\u0dd2\u0dba" },
            { "SB", "\u0dc3\u0ddc\u0dbd\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "SC", "\u0dc3\u0dd3\u0dc1\u0dd9\u0dbd\u0dca\u0dc3\u0dca" },
            { "SD", "\u0dc3\u0dd6\u0da9\u0dcf\u0db1\u0dba" },
            { "SE", "\u0dc3\u0dca\u0dc0\u0dd3\u0da9\u0db1\u0dba" },
            { "SG", "\u0dc3\u0dd2\u0d82\u0d9c\u0db4\u0dca\u0db4\u0dd6\u0dbb\u0dd4\u0dc0" },
            { "SH", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dc4\u0dd9\u0dbd\u0dda\u0db1\u0dcf" },
            { "SI", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SJ", "\u0dc3\u0dca\u0dc0\u0dd9\u0dbd\u0dca\u0db6\u0dbb\u0dca\u0da9\u0dca \u0dc3\u0dc4 \u0da2\u0dda\u0db1\u0dca \u0db8\u0dba\u0dda\u0db1\u0dca" },
            { "SK", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dd0\u0d9a\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SL", "\u0dc3\u0dd2\u0dba\u0dbb\u0dcf\u0dbd\u0dd2\u0dba\u0ddd\u0db1\u0dca" },
            { "SM", "\u0dc3\u0dd0\u0db1\u0dca \u0db8\u0dd0\u0dbb\u0dd2\u0db1\u0ddd" },
            { "SN", "\u0dc3\u0dd9\u0db1\u0d9c\u0dcf\u0dbd\u0dba" },
            { "SO", "\u0dc3\u0ddd\u0db8\u0dcf\u0dbd\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SR", "\u0dc3\u0dd4\u0dbb\u0dd2\u0db1\u0dcf\u0db8\u0dba" },
            { "SS", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd4\u0da9\u0dcf\u0db1\u0dba" },
            { "ST", "\u0dc3\u0dcf\u0d95 \u0dad\u0ddd\u0db8\u0dca \u0dc3\u0dc4 \u0db4\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dc3\u0dd2\u0db4\u0dca" },
            { "SV", "\u0d91\u0dbd\u0dca \u0dc3\u0dd0\u0dbd\u0dca\u0dc0\u0daf\u0ddd\u0dbb\u0dba" },
            { "SX", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0db8\u0dcf\u0dbb\u0dca\u0da7\u0dd9\u0db1\u0dca" },
            { "SY", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dba\u0dcf\u0dc0" },
            { "SZ", "\u0d91\u0dc3\u0dca\u0dc0\u0dcf\u0da7\u0dd2\u0db1\u0dd2" },
            { "TA", "\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dca\u0da7\u0db1\u0dca \u0daf \u0d9a\u0dd4\u0db1\u0dca\u0dc4\u0dcf" },
            { "TC", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0dc3\u0dca \u0dc3\u0dc4 \u0d9a\u0dba\u0dd2\u0d9a\u0ddc\u0dc3\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "TD", "\u0da0\u0dd0\u0da0\u0dca" },
            { "TF", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0daf\u0dd6\u0db4\u0dad\u0dca \u0dc3\u0db8\u0dd6\u0dc4\u0dba" },
            { "TG", "\u0da7\u0ddc\u0d9c\u0ddd" },
            { "TH", "\u0dad\u0dcf\u0dba\u0dd2\u0dbd\u0db1\u0dca\u0dad\u0dba" },
            { "TJ", "\u0da7\u0da2\u0dd2\u0d9a\u0dd2\u0dc3\u0dca\u0dad\u0dcf\u0db1\u0dba" },
            { "TK", "\u0da7\u0ddc\u0d9a\u0dbd\u0dcf\u0dc0\u0dd4" },
            { "TL", "\u0da7\u0dd2\u0db8\u0ddd\u0dbb\u0dca - \u0dbd\u0dd9\u0dc3\u0dca\u0dad\u0dca" },
            { "TM", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "TN", "\u0da7\u0dd2\u0dba\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0dc0" },
            { "TO", metaValue_TO },
            { "TR", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2\u0dba" },
            { "TT", "\u0da7\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dd2\u0da9\u0dd1\u0da9\u0dca \u0dc3\u0dc4 \u0da7\u0ddc\u0db6\u0dd0\u0d9c\u0ddd" },
            { "TV", "\u0da7\u0dd4\u0dc0\u0dcf\u0dbd\u0dd6" },
            { "TW", "\u0dad\u0dcf\u0dba\u0dd2\u0dc0\u0dcf\u0db1\u0dba" },
            { "TZ", "\u0da7\u0dd0\u0db1\u0dca\u0dc3\u0dcf\u0db1\u0dd2\u0dba\u0dcf\u0dc0" },
            { "UA", "\u0dba\u0dd4\u0d9a\u0dca\u0dbb\u0dda\u0db1\u0dba" },
            { "UG", "\u0d8b\u0d9c\u0db1\u0dca\u0da9\u0dcf\u0dc0" },
            { "UM", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0db1\u0db4\u0daf \u0d88\u0dad \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "UN", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0dcf\u0dad\u0dd3\u0db1\u0dca" },
            { "US", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0da2\u0db1\u0db4\u0daf\u0dba" },
            { "UY", "\u0d8b\u0dbb\u0dd4\u0d9c\u0dd4\u0dc0\u0dda" },
            { "UZ", "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dba" },
            { "VA", "\u0dc0\u0dad\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db1\u0d9c\u0dbb\u0dba" },
            { "VC", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dc0\u0dd2\u0db1\u0dca\u0dc3\u0db1\u0dca\u0da7\u0dca \u0dc3\u0dc4 \u0d9c\u0dca\u200d\u0dbb\u0dd9\u0db1\u0da9\u0dd2\u0db1\u0dca\u0dc3\u0dca" },
            { "VE", "\u0dc0\u0dd9\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0dd4\u0dbd\u0dcf\u0dc0" },
            { "VG", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0dc0\u0dbb\u0dca\u0da2\u0dd2\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "VI", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc0\u0dbb\u0dca\u0da2\u0dd2\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca" },
            { "VN", "\u0dc0\u0dd2\u0dba\u0da7\u0dca\u0db1\u0dcf\u0db8\u0dba" },
            { "VU", "\u0dc0\u0db1\u0dd4\u0dc0\u0dcf\u0da7\u0dd4" },
            { "WF", "\u0dc0\u0dd0\u0dbd\u0dd2\u0dc3\u0dca \u0dc3\u0dc4 \u0dc6\u0dd4\u0da7\u0dd4\u0db1\u0dcf" },
            { "WS", "\u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf" },
            { "XA", "\u0dc0\u0dca\u200d\u0dba\u0dcf\u0da2-\u0d8b\u0da0\u0dca\u0da0\u0dcf\u0dbb\u0dab" },
            { "XB", "\u0dc0\u0dca\u200d\u0dba\u0dcf\u0da2-\u0db6\u0dd2\u0da9\u0dd2" },
            { "XK", "\u0d9a\u0ddc\u0dc3\u0ddd\u0dc0\u0ddd" },
            { "YE", "\u0dba\u0dda\u0db8\u0db1\u0dba" },
            { "YT", "\u0db8\u0dba\u0ddd\u0da7\u0dca" },
            { "ZA", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0dc0" },
            { "ZM", "\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0dc0" },
            { "ZW", "\u0dc3\u0dd2\u0db8\u0dca\u0db6\u0dcf\u0db6\u0dca\u0dc0\u0dda" },
            { "ZZ", "\u0dc4\u0db3\u0dd4\u0db1\u0dcf \u0db1\u0ddc\u0d9c\u0dad\u0dca \u0d9a\u0dc5\u0dcf\u0db4\u0dba" },
            { "aa", "\u0d85\u0dc6\u0dcf\u0dbb\u0dca" },
            { "ab", "\u0d87\u0db6\u0dca\u0d9a\u0dcf\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "af", "\u0d85\u0dc6\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dca\u0dc3\u0dca" },
            { "ak", "\u0d85\u0d9a\u0dcf\u0db1\u0dca" },
            { "am", "\u0d87\u0db8\u0dca\u0dc4\u0dcf\u0dbb\u0dd2\u0d9a\u0dca" },
            { "an", "\u0d87\u0dbb\u0d9c\u0ddc\u0db1\u0dd3\u0dc3\u0dca" },
            { "ar", metaValue_ar },
            { "as", "\u0d87\u0dc3\u0dd1\u0db8\u0dca" },
            { "av", "\u0d87\u0dc0\u0dbb\u0dd2\u0d9a\u0dca" },
            { "ay", "\u0d85\u0dba\u0dd2\u0db8\u0dbb\u0dcf" },
            { "az", "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dca" },
            { "ba", "\u0db6\u0dcf\u0dc2\u0dca\u0d9a\u0dd2\u0dbb\u0dca" },
            { "be", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "bg", "\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "bi", "\u0db6\u0dd2\u0dc3\u0dca\u0dbd\u0db8\u0dcf" },
            { "bm", "\u0db6\u0db8\u0dca\u0db6\u0dbb\u0dcf" },
            { "bn", metaValue_bn },
            { "bo", "\u0da7\u0dd2\u0db6\u0dd9\u0da7\u0dca" },
            { "br", "\u0db6\u0dca\u200d\u0dbb\u0dda\u0da7\u0ddc\u0db1\u0dca" },
            { "bs", "\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ca", "\u0d9a\u0dd0\u0da7\u0dbd\u0db1\u0dca" },
            { "ce", "\u0da0\u0dd9\u0da0\u0dca\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ch", "\u0da0\u0db8\u0ddc\u0dbb\u0ddc" },
            { "co", "\u0d9a\u0ddd\u0dc3\u0dd2\u0d9a\u0dcf\u0db1\u0dd4" },
            { "cs", "\u0da0\u0dd9\u0d9a\u0dca" },
            { "cu", "\u0da0\u0dbb\u0dca\u0da0\u0dca \u0dc3\u0dca\u0dbd\u0dd0\u0dc0\u0dd2\u0d9a\u0dca" },
            { "cv", "\u0da0\u0dc0\u0dda\u0dc2\u0dca" },
            { "cy", "\u0dc0\u0dd9\u0dbd\u0dca\u0dc2\u0dca" },
            { "da", "\u0da9\u0dd0\u0db1\u0dd2\u0dc1\u0dca" },
            { "de", "\u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "dv", "\u0da9\u0dd2\u0dc0\u0dd9\u0dc4\u0dd2" },
            { "dz", "\u0da9\u0dd2\u0dc3\u0ddc\u0db1\u0dca\u0d9a\u0dcf" },
            { "ee", "\u0d89\u0dc0\u0dca" },
            { "el", metaValue_el },
            { "en", "\u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "eo", "\u0d91\u0dc3\u0dca\u0db4\u0dd0\u0dbb\u0db1\u0dca\u0da7\u0ddd" },
            { "es", "\u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "et", "\u0d91\u0dc3\u0dca\u0dad\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "eu", "\u0db6\u0dcf\u0dc3\u0dca\u0d9a\u0dca" },
            { "fa", "\u0db4\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ff", "\u0dc6\u0dd4\u0dbd\u0dcf\u0dc4\u0dca" },
            { "fi", "\u0dc6\u0dd2\u0db1\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "fj", "\u0dc6\u0dd3\u0da2\u0dd2" },
            { "fo", "\u0dc6\u0dcf\u0dbb\u0ddd\u0dc3\u0dca" },
            { "fr", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "fy", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0dc6\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ga", "\u0d85\u0dba\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "gd", "\u0dc3\u0dca\u0d9a\u0ddc\u0da7\u0dca\u0da7\u0dd2\u0dc1\u0dca \u0d9c\u0dd9\u0dbd\u0dd2\u0d9a\u0dca" },
            { "gl", "\u0d9c\u0dd0\u0dbd\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "gn", "\u0d9c\u0dd4\u0dc0\u0dcf\u0dbb\u0db1\u0dd2" },
            { "gu", metaValue_gu },
            { "gv", "\u0db8\u0dd0\u0db1\u0dca\u0d9a\u0dca\u0dc3\u0dca" },
            { "ha", "\u0dc4\u0ddd\u0dc3\u0dcf" },
            { "he", metaValue_he },
            { "hi", "\u0dc4\u0dd2\u0db1\u0dca\u0daf\u0dd2" },
            { "hr", "\u0d9a\u0ddd\u0d92\u0dc2\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ht", metaValue_HT },
            { "hu", "\u0dc4\u0db1\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "hy", metaValue_hy },
            { "hz", "\u0dc4\u0dd9\u0dbb\u0dd9\u0dbb\u0ddc" },
            { "ia", "\u0d89\u0db1\u0dca\u0da7\u0dbd\u0dd2\u0db1\u0dca\u0d9c\u0dd4\u0d86" },
            { "id", "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ig", "\u0d89\u0d9c\u0dca\u0db6\u0ddd" },
            { "ii", "\u0dc3\u0dd2\u0da0\u0dd4\u0d86\u0db1\u0dca \u0dba\u0dd3" },
            { "io", "\u0d89\u0da9\u0ddc" },
            { "is", "\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad" },
            { "it", "\u0d89\u0dad\u0dcf\u0dbd\u0dd2" },
            { "iu", "\u0d89\u0db1\u0dd4\u0d9a\u0dca\u0da7\u0dd2\u0da7\u0dd4\u0da7\u0dca" },
            { "ja", metaValue_ja },
            { "jv", "\u0da2\u0dcf\u0dc0\u0dcf" },
            { "ka", metaValue_ka },
            { "ki", "\u0d9a\u0dd2\u0d9a\u0dd4\u0dba\u0dd4" },
            { "kj", "\u0d9a\u0dd4\u0dba\u0db1\u0dca\u0dba\u0db8\u0dcf" },
            { "kk", "\u0d9a\u0dc3\u0dcf\u0d9b\u0dca" },
            { "kl", "\u0d9a\u0dbd\u0dcf\u0dbd\u0dd2\u0dc3\u0da7\u0dca" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0d9a\u0db1\u0dd4\u0dbb\u0dd2" },
            { "ks", "\u0d9a\u0dcf\u0dc2\u0dca\u0db8\u0dd3\u0dbb\u0dca" },
            { "ku", "\u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2" },
            { "kv", "\u0d9a\u0ddc\u0db8\u0dd2" },
            { "kw", "\u0d9a\u0ddd\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ky", "\u0d9a\u0dd2\u0dbb\u0dca\u0d9c\u0dd2\u0dc3\u0dca" },
            { "la", metaValue_la },
            { "lb", "\u0dbd\u0d9a\u0dca\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dca" },
            { "lg", "\u0d9c\u0db1\u0dca\u0da9\u0dcf" },
            { "li", "\u0dbd\u0dd2\u0db8\u0dca\u0db6\u0dbb\u0dca\u0d9c\u0dd2\u0dc1\u0dca" },
            { "ln", "\u0dbd\u0dd2\u0db1\u0dca\u0d9c\u0dbd\u0dcf" },
            { "lo", metaValue_lo },
            { "lt", "\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "lu", "\u0dbd\u0dd4\u0db6\u0dcf-\u0d9a\u0da7\u0db1\u0dca\u0d9c\u0dcf" },
            { "lv", "\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "mg", "\u0db8\u0dbd\u0d9c\u0dcf\u0dc3\u0dd2" },
            { "mh", "\u0db8\u0dcf\u0dc1\u0dbd\u0dd3\u0dc3\u0dca" },
            { "mi", "\u0db8\u0dcf\u0dc0\u0ddc\u0dbb\u0dd2" },
            { "mk", "\u0db8\u0dd0\u0dc3\u0dd2\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ml", metaValue_ml },
            { "mn", "\u0db8\u0ddc\u0d82\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "mr", "\u0db8\u0dbb\u0dcf\u0dad\u0dd2" },
            { "ms", "\u0db8\u0dd0\u0dbd\u0dda" },
            { "mt", "\u0db8\u0ddc\u0dbd\u0dca\u0da7\u0dd2\u0dc3\u0dca" },
            { "my", "\u0db6\u0dd4\u0dbb\u0dd4\u0db8" },
            { "na", "\u0db1\u0dde\u0dbb\u0dd4" },
            { "nb", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dd3\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db6\u0ddc\u0d9a\u0dca\u0db8\u0dbd\u0dca" },
            { "nd", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d91\u0db1\u0dca\u0da9\u0dd2\u0db6\u0dd9\u0dbd\u0dd9" },
            { "ne", "\u0db1\u0dda\u0db4\u0dcf\u0dbd" },
            { "ng", "\u0db1\u0dca\u0da9\u0ddc\u0db1\u0dca\u0d9c\u0dcf" },
            { "nl", "\u0dbd\u0db1\u0dca\u0daf\u0dda\u0dc3\u0dd2" },
            { "nn", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dd3\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dba\u0dd2\u0db1\u0ddd\u0dbb\u0dca\u0dc3\u0dca\u0d9a\u0dca" },
            { "no", "\u0db1\u0ddd\u0dbb\u0dca\u0dc0\u0dd3\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "nr", "\u0dc3\u0dde\u0dad\u0dca \u0da9\u0dca\u0db6\u0dda\u0dbd\u0dca" },
            { "nv", "\u0db1\u0dc0\u0dcf\u0da2\u0ddc" },
            { "ny", "\u0db1\u0dca\u0dba\u0db1\u0dca\u0da2\u0dcf" },
            { "oc", "\u0d94\u0dc3\u0dd2\u0da7\u0dcf\u0db1\u0dca" },
            { "om", "\u0d94\u0dbb\u0ddc\u0db8\u0ddd" },
            { "or", "\u0d94\u0da9\u0dd2\u0dba\u0dcf" },
            { "os", "\u0d94\u0dc3\u0dd2\u0da7\u0dd9\u0d9a\u0dca" },
            { "pa", "\u0db4\u0db1\u0dca\u0da2\u0dcf\u0db6\u0dd2" },
            { "pl", "\u0db4\u0ddd\u0dbd\u0db1\u0dca\u0dad" },
            { "ps", "\u0db4\u0dc2\u0dca\u0da7\u0ddc" },
            { "pt", "\u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "qu", "\u0d9a\u0dca\u0dc0\u0dd3\u0da0\u0dd4\u0dc0\u0dcf" },
            { "rm", "\u0dbb\u0ddc\u0db8\u0dd1\u0db1\u0dca\u0dc1\u0dca" },
            { "rn", "\u0dbb\u0dd4\u0db1\u0dca\u0da9\u0dd2" },
            { "ro", "\u0dbb\u0ddc\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ru", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "rw", "\u0d9a\u0dd2\u0db1\u0dca\u0dba\u0dbb\u0dca\u0dc0\u0db1\u0dca\u0da9\u0dcf" },
            { "sa", "\u0dc3\u0d82\u0dc3\u0dca\u0d9a\u0dd8\u0dad" },
            { "sc", "\u0dc3\u0dcf\u0dbb\u0dca\u0da9\u0dd2\u0db1\u0dd2\u0d85\u0db1\u0dca" },
            { "sd", "\u0dc3\u0dd2\u0db1\u0dca\u0db0\u0dd2" },
            { "se", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "sg", "\u0dc3\u0db1\u0dca\u0d9c\u0dca\u200d\u0dbb\u0ddd" },
            { "si", metaValue_si },
            { "sk", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dd0\u0d9a\u0dca" },
            { "sl", "\u0dc3\u0dca\u0dbd\u0ddd\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "sm", "\u0dc3\u0dd1\u0db8\u0ddc\u0d85\u0db1\u0dca" },
            { "sn", "\u0dc1\u0ddd\u0db1\u0dcf" },
            { "so", "\u0dc3\u0ddd\u0db8\u0dcf\u0dbd\u0dd2" },
            { "sq", "\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "sr", "\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ss", "\u0dc3\u0dca\u0dc0\u0dad\u0dd2" },
            { "st", "\u0dc3\u0dad\u0dbb\u0dca\u0db1\u0dca \u0dc3\u0ddc\u0dad\u0ddc" },
            { "su", "\u0dc3\u0db1\u0dca\u0da9\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "sv", "\u0dc3\u0dca\u0dc0\u0dd3\u0da9\u0db1\u0dca" },
            { "sw", "\u0dc3\u0dca\u0dc0\u0dcf\u0dc4\u0dd2\u0dbd\u0dd2" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0da7\u0da2\u0dd2\u0d9a\u0dca" },
            { "th", metaValue_th },
            { "ti", "\u0da7\u0dd2\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dba\u0dcf" },
            { "tk", "\u0da7\u0dbb\u0dca\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dca" },
            { "tn", "\u0dc3\u0dca\u0dc0\u0db1\u0dcf" },
            { "to", metaValue_TO },
            { "tr", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2" },
            { "ts", "\u0dc3\u0ddc\u0db1\u0dca\u0d9c" },
            { "tt", "\u0da7\u0dcf\u0da7\u0dbb\u0dca" },
            { "ty", "\u0da7\u0dc4\u0dd2\u0da7\u0dd2\u0dba\u0db1\u0dca" },
            { "ug", "\u0d8b\u0dba\u0dd2\u0d9c\u0dbb\u0dca" },
            { "uk", "\u0dba\u0dd4\u0d9a\u0dca\u0dbb\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "ur", "\u0d8b\u0dbb\u0dca\u0daf\u0dd4" },
            { "uz", "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dca" },
            { "ve", "\u0dc0\u0dd9\u0db1\u0dca\u0da9\u0dcf" },
            { "vi", "\u0dc0\u0dd2\u0dba\u0da7\u0dca\u0db1\u0dcf\u0db8\u0dca" },
            { "vo", "\u0dc0\u0ddc\u0dbd\u0db4\u0dd6\u0d9a\u0dca" },
            { "wa", "\u0dc0\u0dd1\u0dbd\u0dd6\u0db1\u0dca" },
            { "wo", "\u0dc0\u0ddc\u0dbd\u0ddc\u0dc6\u0dca" },
            { "xh", "\u0dc1\u0ddd\u0dc3\u0dcf" },
            { "yi", "\u0dba\u0dd2\u0da9\u0dd2\u0dc1\u0dca" },
            { "yo", "\u0dba\u0ddc\u0dbb\u0dd6\u0db6\u0dcf" },
            { "zh", "\u0da0\u0dd3\u0db1" },
            { "zu", "\u0dc3\u0dd4\u0dbd\u0dd4" },
            { "ace", "\u0d85\u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "ada", "\u0d85\u0da9\u0db1\u0dca\u0d9c\u0dca\u0db8\u0dd9" },
            { "ady", "\u0d85\u0da9\u0dd2\u0d9d\u0dd9" },
            { "aeb", "\u0da7\u0dd2\u0dba\u0dd4\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0db1\u0dd4 \u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "agq", "\u0d87\u0d9c\u0db8\u0dca" },
            { "ain", "\u0d85\u0dba\u0dd2\u0db1\u0dd4" },
            { "ale", "\u0d87\u0dbd\u0dd4\u0d91\u0da7\u0dca" },
            { "alt", "\u0dc3\u0dad\u0dbb\u0dca\u0db1\u0dca \u0d85\u0dbd\u0dca\u0da7\u0dba\u0dca" },
            { "ann", "\u0d94\u0db6\u0dbd\u0ddd" },
            { "anp", "\u0d85\u0db1\u0dca\u0d9c\u0dd2\u0d9a" },
            { "arn", "\u0db8\u0db4\u0dd4\u0da0\u0dd9" },
            { "arp", "\u0d87\u0dbb\u0db4\u0dc4\u0ddc" },
            { "ars", "\u0db1\u0da2\u0dca\u0da9\u0dd2 \u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "asa", "\u0d85\u0dc3\u0dd4" },
            { "ast", "\u0d87\u0dc3\u0dca\u0da7\u0dd2\u0dba\u0dd4\u0dbb\u0dd2\u0dba\u0db1\u0dca" },
            { "atj", "\u0d87\u0da7\u0dd2\u0d9a\u0db8\u0dd9\u0d9a\u0dca\u0dc0\u0dca" },
            { "awa", "\u0d85\u0dc0\u0daf\u0dd2" },
            { "ban", "\u0db6\u0dd0\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dca" },
            { "bas", "\u0db6\u0dc3\u0dcf" },
            { "bem", "\u0db6\u0dd9\u0db8\u0dca\u0db6\u0dcf" },
            { "bez", "\u0db6\u0dd9\u0db1\u0dcf" },
            { "bgc", "\u0dc4\u0dbb\u0dca\u0dba\u0dcf\u0db1\u0dca\u0dc0\u0dd2" },
            { "bgn", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0db6\u0dbd\u0ddc\u0da0\u0dd2" },
            { "bho", "\u0db6\u0ddc\u0da2\u0dca\u0db4\u0dd4\u0dbb\u0dd2" },
            { "bin", "\u0db6\u0dd2\u0db1\u0dd2" },
            { "bla", "\u0dc3\u0dd2\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0dcf" },
            { "brx", "\u0db6\u0ddc\u0da9\u0ddc" },
            { "bug", "\u0db6\u0dd4\u0d9c\u0dd2\u0db1\u0dd3\u0dc3\u0dca" },
            { "byn", "\u0db6\u0dca\u0dbd\u0dd2\u0db1\u0dca" },
            { "cay", "\u0d9a\u0dba\u0dd4\u0d9c\u0dcf" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u0dc3\u0dd9\u0db6\u0dd4\u0d85\u0db1\u0ddc" },
            { "cgg", "\u0da0\u0dd2\u0d9c\u0dcf" },
            { "chk", "\u0da0\u0dd6\u0d9a\u0dd3\u0dc3\u0dca" },
            { "chm", "\u0db8\u0dbb\u0dd2" },
            { "cho", "\u0da0\u0ddc\u0d9a\u0dca\u0da7\u0ddc\u0dc0\u0dca" },
            { "chp", "\u0da0\u0dd2\u0db4\u0dd9\u0dc0\u0dd2\u0dba\u0db1\u0dca" },
            { "chr", "\u0da0\u0dd9\u0dbb\u0ddc\u0d9a\u0dd3" },
            { "chy", "\u0da0\u0dd9\u0dba\u0dd9\u0db1\u0dca\u0db1\u0dd9" },
            { "ckb", "\u0dc3\u0ddc\u0dbb\u0dcf\u0db1\u0dd2 \u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2\u0dc2\u0dca" },
            { "clc", "\u0da0\u0dd2\u0dbd\u0dca\u0d9a\u0ddc\u0da7\u0dd2\u0db1\u0dca" },
            { "crg", "\u0db8\u0dd2\u0da0\u0dd2\u0dc6\u0dca" },
            { "crj", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d9a\u0dca\u200d\u0dbb\u0dd3" },
            { "crk", "\u0db4\u0dca\u0dbd\u0dda\u0db1\u0dca\u0dc3\u0dca \u0d9a\u0dca\u200d\u0dbb\u0dd3" },
            { "crl", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d9a\u0dca\u200d\u0dbb\u0dd3" },
            { "crm", "\u0db8\u0dd6\u0dc3\u0dca \u0d9a\u0dca\u200d\u0dbb\u0dd3" },
            { "crr", "\u0d9a\u0dd0\u0dbb\u0ddc\u0dbd\u0dd2\u0db1\u0dcf \u0d87\u0dbd\u0dca\u0d9c\u0ddc\u0db1\u0dca\u0d9a\u0dd2\u0dba\u0db1\u0dca" },
            { "crs", "\u0dc3\u0dd9\u0dc3\u0dd9\u0dbd\u0dca\u0dc0 \u0d9a\u0dca\u200d\u0dbb\u0ddc\u0dbd\u0dca \u0dc6\u0dca\u200d\u0dbb\u0dd9\u0db1\u0dca\u0da0\u0dca" },
            { "csw", "\u0db8\u0da9 \u0dc0\u0d9c\u0dd4\u0dbb\u0dd4 \u0d9a\u0dca\u200d\u0dbb\u0dd3" },
            { "dak", "\u0da9\u0d9a\u0ddc\u0da7\u0dcf" },
            { "dar", "\u0da9\u0dcf\u0dbb\u0dca\u0d9c\u0dca\u0dc0\u0dcf" },
            { "dav", "\u0da7\u0dba\u0dd2\u0da7\u0dcf" },
            { "dgr", "\u0da9\u0ddc\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0db6\u0dca" },
            { "dje", "\u0dc3\u0dbb\u0dca\u0db8\u0dcf" },
            { "doi", "\u0da9\u0ddc\u0d9c\u0dca\u0dbb\u0dd2" },
            { "dsb", "\u0db4\u0dc4\u0dc5 \u0dc3\u0ddd\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "dua", "\u0da9\u0dd4\u0d86\u0dbd\u0dcf" },
            { "dyo", "\u0da2\u0ddc\u0dbd-\u0dc6\u0ddd\u0db1\u0dd2\u0dba\u0dd2" },
            { "dzg", "\u0da9\u0dc3\u0dcf\u0d9c\u0dcf" },
            { "ebu", "\u0d91\u0db8\u0dca\u0db6\u0dd4" },
            { "efi", "\u0d91\u0dc6\u0dd2\u0d9a\u0dca" },
            { "eka", "\u0d91\u0d9a\u0da2\u0dd4\u0d9a\u0dca" },
            { "ewo", "\u0d91\u0dc0\u0ddc\u0db1\u0dca\u0da9\u0ddc" },
            { "fil", "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1" },
            { "fon", "\u0dc6\u0ddc\u0db1\u0dca" },
            { "frc", "\u0d9a\u0da2\u0dd4\u0db1\u0dca \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "frr", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dc6\u0dca\u200d\u0dbb\u0dd2\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "fur", "\u0dc6\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dd4\u0dbd\u0dd2\u0dba\u0db1\u0dca" },
            { "gaa", "\u0d9c\u0dcf" },
            { "gag", "\u0d9c\u0d9c\u0dcf\u0dc3\u0dca" },
            { "gan", "\u0d9c\u0dd0\u0db1\u0dca \u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "gez", "\u0d9c\u0dd3\u0dc3\u0dca" },
            { "gil", "\u0d9c\u0dd2\u0dbd\u0dca\u0db6\u0dbb\u0dca\u0da7\u0dd3\u0dc3\u0dca" },
            { "gor", "\u0d9c\u0ddc\u0dbb\u0ddc\u0db1\u0dca\u0da7\u0dcf\u0dbd\u0ddc" },
            { "gsw", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0da2\u0dbb\u0dca\u0db8\u0dcf\u0db1\u0dd4" },
            { "guz", "\u0d9c\u0dd4\u0dc3\u0dd3" },
            { "gwi", "\u0d9c\u0dca\u0dc0\u0dd2\u0da0\u0dd2\u0db1\u0dca" },
            { "hai", "\u0dc4\u0dba\u0dd2\u0da9\u0dcf" },
            { "hak", "\u0dc4\u0d9a\u0dcf \u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "haw", "\u0dc4\u0dc0\u0dcf\u0dba\u0dd2" },
            { "hax", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc4\u0dba\u0dd2\u0da9\u0dcf" },
            { "hil", "\u0dc4\u0dd2\u0dbd\u0dd2\u0d9c\u0dd9\u0db1\u0db1\u0dca" },
            { "hmn", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0dca" },
            { "hsb", "\u0d89\u0dc4\u0dc5 \u0dc3\u0ddd\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "hsn", "\u0dc3\u0dd2\u0dba\u0dd0\u0db1\u0dca \u0da0\u0dd3\u0db1" },
            { "hup", "\u0dc4\u0dd4\u0db4\u0dcf" },
            { "hur", "\u0dc4\u0dbd\u0dca\u0d9a\u0ddc\u0db8\u0dbd\u0dd9\u0db8\u0dca" },
            { "iba", "\u0d89\u0db6\u0db1\u0dca" },
            { "ibb", "\u0d89\u0db6\u0dd2\u0db6\u0dd2\u0dba\u0ddc" },
            { "ikt", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0db1\u0dd4\u0d9a\u0dca\u0da7\u0dd2\u0da7\u0dd4\u0da7\u0dca" },
            { "ilo", "\u0d89\u0dbd\u0ddc\u0d9a\u0ddc" },
            { "inh", "\u0d89\u0db1\u0dca\u0d9c\u0dd4\u0dc2\u0dca" },
            { "jbo", "\u0dbd\u0ddc\u0da2\u0dca\u0db6\u0db1\u0dca" },
            { "jgo", "\u0db1\u0ddc\u0db8\u0dca\u0db6\u0dcf" },
            { "jmc", "\u0db8\u0dd0\u0d9a\u0dcf\u0db8\u0dd3" },
            { "kab", "\u0d9a\u0dcf\u0db6\u0dd2\u0dbd\u0dca" },
            { "kac", "\u0d9a\u0da0\u0dd2\u0db1\u0dca" },
            { "kaj", "\u0da2\u0dca\u0da2\u0dd4" },
            { "kam", "\u0d9a\u0dd0\u0db8\u0dca\u0db6\u0dcf" },
            { "kbd", "\u0d9a\u0db6\u0dcf\u0dbb\u0dca\u0da9\u0dd2\u0dba\u0db1\u0dca" },
            { "kcg", "\u0da7\u0dca\u0dba\u0db4\u0dca" },
            { "kde", "\u0db8\u0dd0\u0d9a\u0ddc\u0db1\u0dca\u0da9\u0dca" },
            { "kea", "\u0d9a\u0db6\u0dd4\u0dc0\u0dd9\u0dbb\u0dca\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "kfo", "\u0d9a\u0ddc\u0dbb\u0ddc" },
            { "kgp", "\u0d9a\u0dba\u0dd2\u0d82\u0d9c\u0d82" },
            { "kha", "\u0d9b\u0dc3\u0dd2" },
            { "khq", "\u0d9a\u0ddc\u0dba\u0dd2\u0dbb\u0dcf \u0da0\u0dd2\u0db1\u0dd2" },
            { "kkj", "\u0d9a\u0d9a\u0ddc" },
            { "kln", "\u0d9a\u0dbd\u0dd9\u0db1\u0dca\u0da2\u0db1\u0dca" },
            { "kmb", "\u0d9a\u0dd2\u0db8\u0dca\u0db6\u0dd4\u0db1\u0dca\u0da9\u0dd4" },
            { "koi", "\u0d9a\u0ddc\u0db8\u0dd2-\u0db4\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dcf\u0d9a\u0dca" },
            { "kok", "\u0d9a\u0ddc\u0db1\u0dca\u0d9a\u0db1\u0dd2" },
            { "kpe", "\u0d9a\u0dca\u0db4\u0dd9\u0dbd\u0dd9" },
            { "krc", "\u0d9a\u0dbb\u0db1\u0dca\u0da0\u0dd2-\u0db6\u0dcf\u0d9a\u0dbb\u0dca" },
            { "krl", "\u0d9a\u0dd0\u0dbb\u0dd9\u0dbd\u0dd2\u0dba\u0db1\u0dca" },
            { "kru", "\u0d9a\u0dd4\u0dbb\u0dd4\u0d9b\u0dca" },
            { "ksb", "\u0dc1\u0dcf\u0db8\u0dca\u0db6\u0dbd\u0dcf" },
            { "ksf", "\u0db6\u0dcf\u0dc6\u0dd2\u0dba\u0dcf" },
            { "ksh", "\u0d9a\u0ddc\u0dbd\u0ddc\u0d9c\u0dca\u0db1\u0dd2\u0dba\u0db1\u0dca" },
            { "kum", "\u0d9a\u0dd4\u0db8\u0dd2\u0d9a\u0dca" },
            { "kwk", "\u0d9a\u0dca\u0dc0\u0dcf\u0d9a\u0dca\u0dc0\u0dcf\u0dbd\u0dcf" },
            { "lad", "\u0dbd\u0da9\u0dd2\u0db1\u0ddc" },
            { "lag", "\u0dbd\u0d82\u0d9c\u0dd2" },
            { "lez", "\u0dbd\u0dd9\u0dc3\u0dca\u0d9c\u0dd2\u0dba\u0db1\u0dca" },
            { "lil", "\u0dbd\u0dd2\u0dbd\u0dd6\u0da7\u0dca" },
            { "lkt", "\u0dbd\u0d9a\u0ddc\u0da7" },
            { "lou", "\u0dbd\u0dd4\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dcf \u0d9a\u0dca\u200d\u0dbb\u0dd2\u0dba\u0ddd\u0dbd\u0dca" },
            { "loz", "\u0dbd\u0ddc\u0dc3\u0dd2" },
            { "lrc", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0dbd\u0dd4\u0dbb\u0dd2" },
            { "lsm", "\u0dc3\u0dcf\u0db8\u0dd2\u0dba\u0dcf" },
            { "lua", "\u0dbd\u0dd4\u0db6-\u0dbd\u0dd4\u0dbd\u0dd4\u0d85" },
            { "lun", "\u0dbd\u0dd4\u0db1\u0dca\u0da9" },
            { "luo", "\u0dbd\u0dd4\u0d94" },
            { "lus", "\u0db8\u0dd2\u0dc3\u0ddc" },
            { "luy", "\u0dbd\u0dd4\u0dba\u0dd2\u0dba\u0dcf" },
            { "mad", "\u0db8\u0daf\u0dd4\u0dbb\u0dd3\u0dc3\u0dca" },
            { "mag", "\u0db8\u0d9d\u0dc4\u0dd2" },
            { "mai", "\u0db8\u0dba\u0dd2\u0dad\u0dd2\u0dbd\u0dd2" },
            { "mak", "\u0db8\u0d9a\u0dcf\u0dc3\u0dcf\u0dbb\u0dca" },
            { "mas", "\u0db8\u0dc3\u0dcf\u0dba\u0dd2" },
            { "mdf", "\u0db8\u0ddc\u0d9a\u0dca\u0dc1\u0dcf" },
            { "men", "\u0db8\u0dd9\u0db1\u0dca\u0da9\u0dd9" },
            { "mer", "\u0db8\u0dd9\u0dbb\u0dd4" },
            { "mfe", "\u0db8\u0ddc\u0dbb\u0dd2\u0dc3\u0dca\u0dba\u0dd9\u0db8\u0dca" },
            { "mgh", "\u0db8\u0d9b\u0dd4\u0dc0\u0dcf-\u0db8\u0dd3\u0da7\u0ddd" },
            { "mgo", "\u0db8\u0dd9\u0da7\u0dcf" },
            { "mic", "\u0db8\u0dd2\u0d9a\u0dca\u0db8\u0dd0\u0d9a\u0dca" },
            { "min", "\u0db8\u0dd2\u0db1\u0db1\u0dca\u0d9c\u0dca\u0d9a\u0db6\u0dcf\u0dc0\u0dd4" },
            { "mni", "\u0db8\u0db1\u0dd2\u0db4\u0dd4\u0dbb\u0dd2" },
            { "moe", "\u0d89\u0db1\u0dd4-\u0d85\u0dba\u0dd2\u0db8\u0dd4\u0db1\u0dca" },
            { "moh", "\u0db8\u0ddc\u0dc4\u0ddc\u0dc0\u0dca\u0d9a\u0dca" },
            { "mos", "\u0db8\u0ddc\u0dc3\u0dca\u0dc3\u0dd2" },
            { "mua", "\u0db8\u0dd4\u0db1\u0dca\u0da9\u0db1\u0dca" },
            { "mul", "\u0db6\u0dc4\u0dd4 \u0db7\u0dcf\u0dc2\u0dcf" },
            { "mus", "\u0d9a\u0dca\u200d\u0dbb\u0dd3\u0d9a\u0dca" },
            { "mwl", "\u0db8\u0dd2\u0dbb\u0db1\u0dca\u0da9\u0dd3\u0dc3\u0dca" },
            { "myv", "\u0d91\u0dbb\u0dca\u0dc3\u0dca\u0dba\u0dcf" },
            { "mzn", "\u0db8\u0dd0\u0dc3\u0db1\u0dca\u0da9\u0dbb\u0db1\u0dd2" },
            { "nan", "\u0db8\u0dd2\u0db1\u0dca \u0db1\u0db1\u0dca \u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "nap", "\u0db1\u0dd2\u0dba\u0dcf\u0db4\u0ddc\u0dbd\u0dd2\u0da7\u0db1\u0dca" },
            { "naq", "\u0db1\u0dcf\u0db8\u0dcf" },
            { "nds", "\u0db4\u0dc4\u0dc5 \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "new", "\u0db1\u0dd9\u0dc0\u0dcf\u0dbb\u0dd2" },
            { "nia", "\u0db1\u0dd2\u0dba\u0dcf\u0dc3\u0dca" },
            { "niu", "\u0db1\u0dd2\u0dba\u0dd4\u0d91\u0db1\u0dca" },
            { "nmg", "\u0d9a\u0dd4\u0dc0\u0dcf\u0dc3\u0dd2\u0d94" },
            { "nnh", "\u0db1\u0dca\u0d9c\u0dd2\u0dba\u0dcf\u0db8\u0dca\u0db6\u0dd6\u0db1\u0dca" },
            { "nog", "\u0db1\u0ddc\u0d9c\u0dcf\u0dba\u0dd2" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0db1\u0ddc\u0daf\u0dbb\u0dca\u0db1\u0dca \u0dc3\u0ddc\u0dad\u0ddc" },
            { "nus", "\u0db1\u0ddc\u0dba\u0dbb\u0dca" },
            { "nyn", "\u0db1\u0dba\u0db1\u0dca\u0d9a\u0ddd\u0dbd\u0dd9" },
            { "ojb", "\u0dc0\u0dba\u0db9 \u0d94\u0da2\u0dd2\u0db6\u0dca\u0dc0\u0dcf" },
            { "ojc", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d94\u0da2\u0dd2\u0db6\u0dca\u0dc0\u0dcf" },
            { "ojs", "\u0d94\u0da2\u0dd2-\u0d9a\u0dca\u200d\u0dbb\u0dd3" },
            { "ojw", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d94\u0da2\u0dd2\u0db6\u0dca\u0dc0\u0dcf" },
            { "oka", "\u0d94\u0d9a\u0db1\u0d9c\u0db1\u0dca" },
            { "pag", "\u0db4\u0db1\u0dca\u0d9c\u0dc3\u0dd3\u0db1\u0db1\u0dca" },
            { "pam", "\u0db4\u0db1\u0dca\u0db4\u0db1\u0dca\u0d9c" },
            { "pap", "\u0db4\u0db4\u0dd2\u0dba\u0db8\u0dd9\u0db1\u0dca\u0da7\u0ddc" },
            { "pau", "\u0db4\u0dbd\u0dc0\u0dd4\u0dc0\u0db1\u0dca" },
            { "pcm", "\u0db1\u0ddb\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0db1\u0dca \u0db4\u0dd9\u0db1\u0dca\u0d9c\u0dd2\u0db1\u0dca" },
            { "pis", "\u0db4\u0dd2\u0da2\u0dd2\u0db1\u0dca" },
            { "pqm", "\u0db8\u0dbd\u0dd2\u0dc3\u0dd3\u0da7\u0dca-\u0db4\u0dc3\u0dca\u0dc3\u0db8\u0d9a\u0dd4\u0da9\u0dd2" },
            { "prg", "\u0db4\u0dd8\u0dc1\u0dd2\u0dba\u0db1\u0dca" },
            { "quc", "\u0d9a\u0dd2\u0dba\u0dd2\u0da0\u0dda" },
            { "raj", "\u0dbb\u0dcf\u0da2\u0dc3\u0dca\u0dae\u0dcf\u0db1\u0dd2" },
            { "rap", "\u0dbb\u0db4\u0db1\u0dd4\u0dba\u0dd2" },
            { "rar", "\u0dbb\u0dbb\u0ddc\u0da7\u0ddc\u0db1\u0dca\u0d9c\u0db1\u0dca" },
            { "rhg", "\u0dbb\u0ddd\u0dc4\u0dd2\u0db1\u0dca\u0d9c\u0dca\u200d\u0dba\u0dcf" },
            { "rof", "\u0dbb\u0ddd\u0db8\u0dca\u0db6\u0ddd" },
            { "rup", "\u0d87\u0dbb\u0ddc\u0db8\u0dcf\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "rwk", "\u0dbb\u0dca\u0dc0\u0dcf" },
            { "sad", "\u0dc3\u0db1\u0dca\u0da9\u0dc0\u0dd9" },
            { "sah", "\u0dc3\u0d9b\u0dcf" },
            { "saq", "\u0dc3\u0db8\u0dca\u0db6\u0dd4\u0dbb\u0dd4" },
            { "sat", "\u0dc3\u0dd1\u0db1\u0dca\u0da7\u0dbd\u0dd2" },
            { "sba", "\u0db1\u0dca\u0d9c\u0db8\u0dca\u0db6\u0dd9" },
            { "sbp", "\u0dc3\u0d82\u0d9c\u0dd4" },
            { "scn", "\u0dc3\u0dd2\u0dc3\u0dd2\u0dbd\u0dd2\u0dba\u0db1\u0dca" },
            { "sco", "\u0dc3\u0dca\u0d9a\u0ddc\u0da7\u0dca\u0dc3\u0dca" },
            { "sdh", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0dd4\u0dbb\u0dca\u0daf\u0dd2" },
            { "seh", "\u0dc3\u0dd9\u0db1\u0dcf" },
            { "ses", "\u0d9a\u0ddd\u0dba\u0dd2\u0dbb\u0dcf\u0db6\u0ddc\u0dbb\u0ddc \u0dc3\u0dd9\u0db1\u0dca\u0db1\u0dd2" },
            { "shi", "\u0da7\u0da0\u0dda\u0dbd\u0dca\u0dc4\u0dd2\u0da7\u0dca" },
            { "shn", "\u0dc1\u0dcf\u0db1\u0dca" },
            { "slh", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dbd\u0dd4\u0dc2\u0dd6\u0da7\u0dca\u0dc3\u0dd3\u0da9\u0dca" },
            { "sma", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "smj", "\u0dbd\u0dd4\u0dbd\u0dda \u0dc3\u0dcf\u0db8\u0dd2" },
            { "smn", "\u0d89\u0db1\u0dcf\u0dbb\u0dd2 \u0dc3\u0dcf\u0db8\u0dd2" },
            { "sms", "\u0dc3\u0dca\u0d9a\u0ddc\u0dbd\u0dca\u0da7\u0dca \u0dc3\u0dcf\u0db8\u0dd2" },
            { "snk", "\u0dc3\u0ddc\u0db1\u0dd2\u0db1\u0dca\u0d9a\u0dd9" },
            { "srn", "\u0dc3\u0dca\u200d\u0dbb\u0db1\u0dca \u0da7\u0ddc\u0db1\u0dca\u0d9c\u0ddc" },
            { "ssy", "\u0dc3\u0dc4\u0ddc" },
            { "str", "\u0dc3\u0dcf\u0dbd\u0dd2\u0dc2\u0dca\u0dc3 \u0db8\u0dd4\u0daf\u0dca\u0dbb \u0dc3\u0db1\u0dca\u0db0\u0dd2\u0dba" },
            { "suk", "\u0dc3\u0dd4\u0d9a\u0dd4\u0db8\u0dcf" },
            { "swb", "\u0d9a\u0ddc\u0db8\u0ddc\u0dbb\u0dd2\u0dba\u0db1\u0dca" },
            { "syr", "\u0dc3\u0dca\u200d\u0dbb\u0dba\u0dd1\u0d9a\u0dca" },
            { "tce", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0da7\u0da0\u0ddd\u0db1\u0dca" },
            { "tem", "\u0da7\u0dd2\u0db8\u0dca\u0db1\u0dd9" },
            { "teo", "\u0da7\u0dd9\u0dc3\u0ddd" },
            { "tet", "\u0da7\u0dda\u0da7\u0db8\u0dca" },
            { "tgx", "\u0da7\u0dd0\u0d9c\u0dd2\u0dc2\u0dca" },
            { "tht", "\u0da7\u0dd0\u0dbd\u0dca\u0da7\u0db1\u0dca" },
            { "tig", "\u0da7\u0dd3\u0d9c\u0dca\u200d\u0dbb\u0dd9" },
            { "tlh", "\u0d9a\u0dca\u0dbd\u0dd2\u0db1\u0dca\u0d9c\u0ddc\u0db1\u0dca" },
            { "tli", "\u0da7\u0dca\u0dbd\u0dd2\u0db1\u0dca\u0d9c\u0dd2\u0da7\u0dca" },
            { "tok", "\u0da7\u0ddd\u0d9a\u0dd2 \u0db4\u0ddc\u0db1\u0dcf" },
            { "tpi", "\u0da7\u0ddc\u0d9a\u0dca \u0db4\u0dd2\u0dc3\u0dd2\u0db1\u0dca" },
            { "trv", "\u0da7\u0dbb\u0ddc\u0d9a\u0ddc" },
            { "ttm", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0da7\u0da0\u0ddd\u0db1\u0dca" },
            { "tum", "\u0da7\u0dd4\u0db8\u0dca\u0db6\u0dd4\u0d9a\u0dcf" },
            { "tvl", "\u0da7\u0dd4\u0dc0\u0dcf\u0dbd\u0dd4" },
            { "twq", "\u0da7\u0dc3\u0dc0\u0dcf\u0d9a\u0dca" },
            { "tyv", "\u0da7\u0dd4\u0dc0\u0dd2\u0db1\u0dd2\u0dba\u0db1\u0dca" },
            { "tzm", "\u0db8\u0db0\u0dca\u200d\u0dba\u0db8 \u0d87\u0da7\u0dca\u0dbd\u0dc3\u0dca \u0da7\u0db8\u0dc3\u0dd2\u0da7\u0dca" },
            { "udm", "\u0d85\u0da9\u0dca\u0db8\u0dbb\u0dca\u0da7\u0dca" },
            { "umb", "\u0d8b\u0db6\u0dd4\u0db1\u0dca\u0da9\u0dd4" },
            { "und", "\u0db1\u0ddc\u0daf\u0db1\u0dca\u0db1\u0dcf \u0db7\u0dcf\u0dc2\u0dcf\u0dc0" },
            { "vai", "\u0dc0\u0dba\u0dd2" },
            { "vun", "\u0dc0\u0dd4\u0db1\u0dca\u0da2\u0ddd" },
            { "wae", "\u0dc0\u0ddc\u0dbd\u0dca\u0dc3\u0dbb\u0dca" },
            { "wal", "\u0dc0\u0ddc\u0dbd\u0dd9\u0da7\u0dca\u0da7" },
            { "war", "\u0dc0\u0ddc\u0dbb\u0dd9\u0dba\u0dca" },
            { "wbp", "\u0dc0\u0ddc\u0db4\u0dd2\u0dbb\u0dd2" },
            { "wuu", "\u0dc0\u0dd6 \u0da0\u0dba\u0dd2\u0db1\u0dd2\u0dc3\u0dca" },
            { "xal", "\u0d9a\u0dbd\u0dca\u0db8\u0dd2\u0d9a\u0dca" },
            { "xog", "\u0dc3\u0ddc\u0d9c\u0dcf" },
            { "yav", "\u0dba\u0db1\u0dca\u0d9c\u0dca\u0db6\u0dd9\u0db1\u0dca" },
            { "ybb", "\u0dba\u0dd9\u0db8\u0dca\u0db6\u0dcf" },
            { "yrl", "\u0db1\u0ddc\u0dc4\u0dd3\u0d9f\u0da7\u0dd4" },
            { "yue", "\u0d9a\u0dd0\u0db1\u0dca\u0da7\u0ddc\u0db1\u0dd3\u0dc3\u0dca" },
            { "zgh", "\u0dc3\u0db8\u0dca\u0db8\u0dad \u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd \u0da7\u0db8\u0dc3\u0dd2\u0d9c\u0dca\u0dad\u0dca" },
            { "zun", "\u0dc3\u0dd4\u0db1\u0dd2" },
            { "zxx", "\u0dc0\u0dcf\u0d9c\u0dca \u0dc0\u0dd2\u0daf\u0dca\u200d\u0dba\u0dcf \u0d85\u0db1\u0dca\u0dad\u0dbb\u0dca\u0d9c\u0dad\u0dba\u0d9a\u0dca \u0db1\u0dd0\u0dad" },
            { "zza", "\u0dc3\u0dcf\u0dc3\u0dcf" },
            { "Adlm", "\u0d87\u0da9\u0dca\u0dbd\u0db8\u0dca" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0db1\u0dc3\u0dca\u0da7\u0dcf\u0dbd\u0dd2\u0d9a\u0dca" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "\u0db6\u0ddc\u0db4\u0ddc\u0db8\u0ddc\u0dc6\u0ddd" },
            { "Brai", "\u0db6\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dca" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u0d92\u0d9a\u0dcf\u0db6\u0daf\u0dca\u0db0 \u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d86\u0daf\u0dd2\u0dc0\u0dcf\u0dc3\u0dd3 \u0dc0\u0dd2\u0dc2\u0dba \u0db1\u0dd2\u0dbb\u0dca\u0daf\u0dda\u0dc1" },
            { "Cher", "\u0da0\u0dd9\u0dbb\u0ddd\u0d9a\u0dd3" },
            { "Cyrl", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dbd\u0dd2\u0d9a\u0dca" },
            { "Deva", "\u0daf\u0dda\u0dc0\u0db1\u0dcf\u0d9c\u0dbb\u0dd3" },
            { "Ethi", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0d9c\u0dd4\u0dbb\u0dca\u0db8\u0dd4\u0d9b\u0dd2" },
            { "Hanb", "\u0dc4\u0dd0\u0db1\u0dca\u0da9\u0dca\u0db6\u0dca" },
            { "Hang", "\u0dc4\u0dd0\u0db1\u0dca\u0d9c\u0dd4\u0dbd\u0dca" },
            { "Hani", "\u0dc4\u0db1\u0dca" },
            { "Hans", "\u0dc3\u0dd4\u0dc5\u0dd4\u0d9a\u0dc5" },
            { "Hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0dc4\u0dd2\u0dbb\u0d9f\u0db1\u0dcf" },
            { "Hrkt", "\u0da2\u0dd1\u0db4\u0db1\u0dd3\u0dc3\u0dca \u0dc3\u0dd2\u0dbd\u0db6\u0dbb\u0dd3\u0dc3\u0dca" },
            { "Jamo", "\u0da2\u0dcf\u0db8\u0ddc" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u0d9a\u0dad\u0d9a\u0db1\u0dcf" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "Mtei", "\u0db8\u0dd9\u0dba\u0dd2\u0da7\u0dd9\u0dba\u0dd2 \u0db8\u0dba\u0d9a\u0dca" },
            { "Mymr", "\u0db8\u0dd2\u0dba\u0db1\u0dca\u0db8\u0dcf\u0dbb" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "\u0d94\u0dbd\u0dca \u0da0\u0dd2\u0d9a\u0dd2" },
            { "Orya", "\u0d94\u0dbb\u0dd2\u0dba\u0dcf" },
            { "Rohg", "\u0dc4\u0db1\u0dd2\u0dc6\u0dd2" },
            { "Sinh", metaValue_si },
            { "Sund", "\u0dc3\u0db1\u0dca\u0da9\u0db1\u0dd3\u0dc3\u0dca" },
            { "Syrc", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dba\u0dd0\u0d9a\u0dca" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "\u0da7\u0dd2\u0dc6\u0dd2\u0db1\u0dcf\u0d9c\u0dca" },
            { "Thaa", "\u0dad\u0dcf\u0db1" },
            { "Thai", metaValue_th },
            { "Tibt", "\u0da7\u0dd2\u200d\u0db6\u0dd9\u0da7\u0dca" },
            { "Vaii", "\u0dc0\u0dcf\u0dba\u0dd2" },
            { "Yiii", "\u0dba\u0dd3" },
            { "Zmth", "\u0d9c\u0dab\u0dd2\u0dad\u0db8\u0dba \u0dc3\u0d82\u0d9a\u0dda\u0dad" },
            { "Zsye", "\u0d89\u0db8\u0ddc\u0da2\u0dd2" },
            { "Zsym", "\u0dc3\u0d82\u0d9a\u0dda\u0dad" },
            { "Zxxx", "\u0d85\u0dbd\u0dd2\u0d9b\u0dd2\u0dad" },
            { "Zyyy", "\u0db4\u0ddc\u0daf\u0dd4" },
            { "Zzzz", "\u0db1\u0ddc\u0daf\u0dad\u0dca \u0d85\u0d9a\u0dd4\u0dbb\u0dd4 \u0db8\u0dcf\u0dbd\u0dcf\u0dc0" },
            { "de_AT", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "de_CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0d8b\u0dc3\u0dc3\u0dca \u0da2\u0dbb\u0dca\u0db8\u0db1\u0dca" },
            { "en_AU", "\u0d95\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "en_CA", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "en_GB", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "en_US", "\u0d87\u0db8\u0dd9\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d89\u0d82\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0dc3\u0dd2" },
            { "es_ES", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "es_MX", "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "fa_AF", "\u0da9\u0dcf\u0dbb\u0dd2" },
            { "fr_CA", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "fr_CH", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1" },
            { "nl_BE", "\u0dc6\u0dca\u0dbd\u0dd9\u0db8\u0dd2\u0dc1\u0dca" },
            { "pt_BR", "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd \u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "pt_PT", "\u0dba\u0dd4\u0dbb\u0ddd\u0db4\u0dd3\u0dba \u0db4\u0dd8\u0dad\u0dd4\u0d9c\u0dd3\u0dc3\u0dd2" },
            { "ro_MD", "\u0db8\u0ddc\u0dbd\u0dca\u0da9\u0dc0\u0dd2\u0d86\u0db1\u0dd4" },
            { "sw_CD", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddd \u0dc3\u0dca\u0dc0\u0dcf\u0dc4\u0dd2\u0dbd\u0dd2" },
            { "ar_001", "\u0db1\u0dd6\u0dad\u0db1 \u0dc3\u0db8\u0dca\u0db8\u0dad \u0d85\u0dbb\u0dcf\u0db6\u0dd2" },
            { "es_419", "\u0dbd\u0dad\u0dd2\u0db1\u0dca \u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0dca\u0db4\u0dcf\u0da4\u0dca\u0da4" },
            { "key.ca", "\u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "key.cf", "\u0db8\u0dd4\u0daf\u0dbd\u0dca \u0d86\u0d9a\u0dd8\u0dad\u0dd2" },
            { "key.co", "\u0db4\u0dd9\u0dc5\u0d9c\u0dd0\u0dc3\u0dca\u0db8" },
            { "key.cu", "\u0dc0\u0dd2\u0db1\u0dd2\u0db8\u0dba" },
            { "key.hc", "\u0db4\u0dd0\u0dba \u0da0\u0d9a\u0dca\u200d\u0dbb\u0dba" },
            { "key.lb", "\u0db4\u0dda\u0dc5\u0dd2 \u0d9a\u0da9\u0db1 \u0dc0\u0dd2\u0dbd\u0dcf\u0dc3\u0dba" },
            { "key.ms", "\u0db8\u0dd2\u0db1\u0dd4\u0db8\u0dca \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba" },
            { "key.nu", "\u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "nds_NL", "\u0db4\u0dc4\u0dc5 \u0dc3\u0dd0\u0d9a\u0dca\u0dc3\u0db1\u0dca" },
            { "zh_Hans", "\u0dc3\u0dbb\u0dbd \u0da0\u0dd3\u0db1" },
            { "zh_Hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0da0\u0dd3\u0db1" },
            { "type.ca.roc", "\u0db8\u0dd2\u0db1\u0dca\u0d9c\u0dcf \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.hc.h11", metaValue_type_hc_h11 },
            { "type.hc.h12", metaValue_type_hc_h11 },
            { "type.hc.h23", metaValue_type_hc_h23 },
            { "type.hc.h24", metaValue_type_hc_h23 },
            { "type.nu.arab", "\u0d89\u0db1\u0dca\u0daf\u0dd4 \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.armn", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.beng", "\u0db6\u0dd9\u0d82\u0d9c\u0dcf\u0dbd\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.cakm", "\u0da0\u0d9a\u0dca\u0db8\u0dcf \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.deva", "\u0daf\u0dda\u0dc0\u0db1\u0dcf\u0d9c\u0dbb\u0dd3 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.ethi", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.geor", "\u0da2\u0ddd\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.grek", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.gujr", "\u0d9c\u0dd4\u0da2\u0dbb\u0dcf\u0da7\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.guru", "\u0d9c\u0dd4\u0dbb\u0dca\u0db8\u0dd4\u0d9a\u0dd3 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.hans", "\u0dc3\u0dd4\u0dc5\u0dd4\u0d9a\u0dc5 \u0da0\u0dd3\u0db1 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.hant", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0da0\u0dd3\u0db1 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.hebr", "\u0dc4\u0dd3\u0db6\u0df2 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.java", "\u0da2\u0dcf\u0dc0\u0dcf\u0db1\u0dd4 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.jpan", "\u0da2\u0db4\u0dcf\u0db1 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.khmr", "\u0d9a\u0db8\u0dbb\u0dca \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.knda", "\u0d9a\u0db1\u0dca\u0db1\u0da9 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.laoo", "\u0dbd\u0dcf\u0d95 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.latn", "\u0db6\u0da7\u0dc4\u0dd2\u0dbb \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.mlym", "\u0db8\u0dbd\u0dba\u0dcf\u0dbd\u0db8\u0dca \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.mtei", "\u0db8\u0dd3\u0da7\u0dda\u0dba\u0dd2 \u0db8\u0dba\u0dd9\u0d9a\u0dca \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.mymr", "\u0db6\u0dd4\u0dbb\u0dd4\u0db8 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.olck", "\u0d94\u0dbd\u0dca \u0da0\u0dd2\u0d9a\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.orya", "\u0d94\u0dbb\u0dd2\u0dba\u0dcf \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.taml", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0daf\u0dd9\u0db8\u0dc5 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.telu", "\u0dad\u0dd9\u0dc5\u0dd2\u0d9f\u0dd4 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.thai", "\u0dad\u0dcf\u0dba\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.tibt", "\u0da7\u0dd2\u0db6\u0dd9\u0da7 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.vaii", "\u0dc0\u0dcf\u0dba\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.ca.dangi", "\u0da9\u0dd0\u0db1\u0dca\u0d9c\u0dd3 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.co.ducet", "\u0dba\u0dd4\u0db1\u0dd2\u0d9a\u0dda\u0dad \u0db4\u0dd9\u0dbb\u0db1\u0dd2\u0db8\u0dd2 \u0db4\u0dd9\u0dc5\u0d9c\u0dd0\u0dc3\u0dca\u0db8" },
            { "type.lb.loose", "\u0dbd\u0dd2\u0dc4\u0dd2\u0dbd\u0dca \u0d9a\u0da9\u0db1 \u0dc0\u0dd2\u0dbd\u0dcf\u0dc3\u0dba" },
            { "type.nu.roman", "\u0dbb\u0ddd\u0db8\u0dcf\u0db1\u0dd4 \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.ca.coptic", "\u0d9a\u0ddc\u0db4\u0dca\u0da7\u0dd2\u0d9a\u0dca \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.ca.hebrew", "\u0dc4\u0dd3\u0db6\u0df2 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.co.search", "\u0dc3\u0dcf\u0db8\u0dcf\u0db1\u0dca\u200d\u0dba \u0dc3\u0dd9\u0dc0\u0dd3\u0db8" },
            { "type.lb.normal", "\u0dc3\u0dcf\u0db8\u0dcf\u0db1\u0dca\u200d\u0dba \u0db4\u0dda\u0dc5\u0dd2 \u0d9a\u0da9\u0db1 \u0dc0\u0dd2\u0dbd\u0dcf\u0dc3\u0dba" },
            { "type.lb.strict", "\u0dad\u0daf \u0db4\u0dda\u0dc5\u0dd2 \u0d9a\u0da9\u0db1 \u0dc0\u0dd2\u0dbd\u0dcf\u0dc3\u0dba" },
            { "type.ms.metric", "\u0db8\u0dd9\u0da7\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dca \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba" },
            { "type.ca.chinese", "\u0da0\u0dd3\u0db1 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.ca.islamic", "\u0dc4\u0dd2\u0da2\u0dca\u0dbb\u0dd2 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.ca.iso8601", "\u0d85\u0d91\u0dc3\u0dca\u0d94-8601 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.ca.persian", "\u0db4\u0dbb\u0dca\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.cf.account", "\u0d9c\u0dd2\u0dab\u0dd4\u0db8\u0dca\u0d9a\u0dbb\u0dab \u0db8\u0dd4\u0daf\u0dbd\u0dca \u0d86\u0d9a\u0dd8\u0dad\u0dd2" },
            { "type.nu.arabext", "\u0dc0\u0dd0\u0da9\u0dd2 \u0d9a\u0dc5 \u0d89\u0db1\u0dca\u0daf\u0dd4 \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.armnlow", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0d9a\u0dd4\u0da9\u0dcf \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.greklow", "\u0d9c\u0dca\u200d\u0dbb\u0dd3\u0d9a \u0d9a\u0dd4\u0da9\u0dcf \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.hanidec", "\u0da0\u0dd3\u0db1 \u0daf\u0dc1\u0db8\u0dba \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.hansfin", "\u0dc3\u0dd4\u0dc5\u0dd4\u0d9a\u0dc5 \u0da0\u0dd3\u0db1 \u0db8\u0dd4\u0dbd\u0dca\u200d\u0dba\u0db8\u0dba \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.hantfin", "\u0dc3\u0dcf\u0db8\u0dca\u0db4\u0dca\u200d\u0dbb\u0daf\u0dcf\u0dba\u0dd2\u0d9a \u0da0\u0dd3\u0db1 \u0db8\u0dd4\u0dbd\u0dca\u200d\u0dba\u0db8\u0dba \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.jpanfin", "\u0da2\u0db4\u0dcf\u0db1 \u0db8\u0dd4\u0dbd\u0dca\u200d\u0dba\u0db8\u0dba \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.nu.tamldec", "\u0daf\u0dd9\u0db8\u0dc5 \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.ca.buddhist", "\u0db6\u0ddc\u0daf\u0dd4 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.ca.ethiopic", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.ca.japanese", "\u0da2\u0db4\u0db1\u0dca \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.cf.standard", "\u0dc3\u0db8\u0dca\u0db8\u0dad \u0db8\u0dd4\u0daf\u0dbd\u0dca \u0d86\u0d9a\u0dd8\u0dad\u0dd2" },
            { "type.co.standard", "\u0dc3\u0db8\u0dca\u0db8\u0dad \u0db4\u0dd9\u0dc5\u0d9c\u0dd0\u0dc3\u0dca\u0db8" },
            { "type.ms.uksystem", "\u0dbb\u0dcf\u0da2\u0d9a\u0dd3\u0dba \u0db8\u0dd2\u0db1\u0dd4\u0db8\u0dca \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba" },
            { "type.ms.ussystem", "\u0d91\u0da2 \u0db8\u0dd2\u0db1\u0dd4\u0db8\u0dca \u0d9a\u0dca\u200d\u0dbb\u0db8\u0dba" },
            { "type.nu.fullwide", "\u0dc3\u0db8\u0dca\u0db4\u0dd6\u0dbb\u0dca\u0dab \u0db4\u0dc5\u0dbd \u0d89\u0dbd\u0d9a\u0dca\u0d9a\u0db8\u0dca" },
            { "type.nu.romanlow", "\u0dbb\u0ddd\u0db8\u0dcf\u0db1\u0dd4 \u0d9a\u0dd4\u0da9\u0dcf \u0dc3\u0d82\u0d9b\u0dca\u200d\u0dba\u0dcf\u0d82\u0d9a\u0db1" },
            { "type.ca.gregorian", "\u0d9c\u0dca\u200d\u0dbb\u0dd9\u0d9c\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
            { "type.co.dictionary", "\u0dc1\u0db6\u0dca\u0daf\u0d9a\u0ddd\u0dc2 \u0db4\u0dd9\u0dc5\u0d9c\u0dd0\u0dc3\u0dca\u0db8" },
            { "type.ca.islamic-civil", "\u0dc4\u0dd2\u0da2\u0dca\u0dbb\u0dd2 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba (\u0dc0\u0d9c\u0dd4\u0dc0, \u0dc3\u0dd2\u0dc0\u0dd2\u0dbd\u0dca \u0dc0\u0dd3\u0dbb \u0d9a\u0dcf\u0dc0\u0dca\u200d\u0dba\u0dba)" },
            { "type.ca.islamic-umalqura", "\u0dc4\u0dd2\u0da2\u0dca\u0dbb\u0dd2 \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba (\u0d8b\u0db8\u0dca \u0d85\u0dbd\u0dca \u0d9a\u0dd4\u0dbb\u0dcf)" },
            { "type.ca.ethiopic-amete-alem", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0d9a\u0dca \u0d87\u0db8\u0dda\u0da7\u0dca \u0d87\u0dbd\u0db8\u0dca \u0daf\u0dd2\u0db1 \u0daf\u0dbb\u0dca\u0dc1\u0db1\u0dba" },
        };
        return data;
    }
}
