const DEFAULT_BLOCKED_UA_STRS = [
    'amazonbot',
    'amazonproductbot',
    'app.hypefactors.com',
    'applebot',
    'archive.org_bot',
    'awariobot',
    'backlinksextendedbot',
    'baiduspider',
    'bingbot',
    'bingpreview',
    'chrome-lighthouse',
    'dataforseobot',
    'deepscan',
    'duckduckbot',
    'facebookexternal',
    'facebookcatalog',
    'http://yandex.com/bots',
    'hubspot',
    'ia_archiver',
    'leikibot',
    'linkedinbot',
    'meta-externalagent',
    'mj12bot',
    'msnbot',
    'nessus',
    'petalbot',
    'pinterest',
    'prerender',
    'rogerbot',
    'screaming frog',
    'sebot-wa',
    'sitebulb',
    'slackbot',
    'slurp',
    'trendictionbot',
    'turnitin',
    'twitterbot',
    'vercel-screenshot',
    'vercelbot',
    'yahoo! slurp',
    'yandexbot',
    'zoombot',
    'bot.htm',
    'bot.php',
    '(bot;',
    'bot/',
    'crawler',
    'ahrefsbot',
    'ahrefssiteaudit',
    'semrushbot',
    'siteauditbot',
    'splitsignalbot',
    'gptbot',
    'oai-searchbot',
    'chatgpt-user',
    'perplexitybot',
    'better uptime bot',
    'sentryuptimebot',
    'uptimerobot',
    'headlesschrome',
    'cypress',
    'google-hoteladsverifier',
    'adsbot-google',
    'apis-google',
    'duplexweb-google',
    'feedfetcher-google',
    'google favicon',
    'google web preview',
    'google-read-aloud',
    'googlebot',
    'googleother',
    'google-cloudvertexbot',
    'googleweblight',
    'mediapartners-google',
    'storebot-google',
    'google-inspectiontool',
    'bytespider'
];
const isBlockedUA = function(ua, customBlockedUserAgents = []) {
    if (!ua) return false;
    const uaLower = ua.toLowerCase();
    return DEFAULT_BLOCKED_UA_STRS.concat(customBlockedUserAgents).some((blockedUA)=>{
        const blockedUaLower = blockedUA.toLowerCase();
        return -1 !== uaLower.indexOf(blockedUaLower);
    });
};
export { DEFAULT_BLOCKED_UA_STRS, isBlockedUA };
