import type { $ZodRegistry } from "./registries.cjs";
import type * as schemas from "./schemas.cjs";
import { type Processor, type RegistryToJSONSchemaParams, type ToJSONSchemaParams, type ZodStandardJSONSchemaPayload } from "./to-json-schema.cjs";
export declare const stringProcessor: Processor<schemas.$ZodString>;
export declare const numberProcessor: Processor<schemas.$ZodNumber>;
export declare const booleanProcessor: Processor<schemas.$ZodBoolean>;
export declare const bigintProcessor: Processor<schemas.$ZodBigInt>;
export declare const symbolProcessor: Processor<schemas.$ZodSymbol>;
export declare const nullProcessor: Processor<schemas.$ZodNull>;
export declare const undefinedProcessor: Processor<schemas.$ZodUndefined>;
export declare const voidProcessor: Processor<schemas.$ZodVoid>;
export declare const neverProcessor: Processor<schemas.$ZodNever>;
export declare const anyProcessor: Processor<schemas.$ZodAny>;
export declare const unknownProcessor: Processor<schemas.$ZodUnknown>;
export declare const dateProcessor: Processor<schemas.$ZodDate>;
export declare const enumProcessor: Processor<schemas.$ZodEnum>;
export declare const literalProcessor: Processor<schemas.$ZodLiteral>;
export declare const nanProcessor: Processor<schemas.$ZodNaN>;
export declare const templateLiteralProcessor: Processor<schemas.$ZodTemplateLiteral>;
export declare const fileProcessor: Processor<schemas.$ZodFile>;
export declare const successProcessor: Processor<schemas.$ZodSuccess>;
export declare const customProcessor: Processor<schemas.$ZodCustom>;
export declare const functionProcessor: Processor<schemas.$ZodFunction>;
export declare const transformProcessor: Processor<schemas.$ZodTransform>;
export declare const mapProcessor: Processor<schemas.$ZodMap>;
export declare const setProcessor: Processor<schemas.$ZodSet>;
export declare const arrayProcessor: Processor<schemas.$ZodArray>;
export declare const objectProcessor: Processor<schemas.$ZodObject>;
export declare const unionProcessor: Processor<schemas.$ZodUnion>;
export declare const intersectionProcessor: Processor<schemas.$ZodIntersection>;
export declare const tupleProcessor: Processor<schemas.$ZodTuple>;
export declare const recordProcessor: Processor<schemas.$ZodRecord>;
export declare const nullableProcessor: Processor<schemas.$ZodNullable>;
export declare const nonoptionalProcessor: Processor<schemas.$ZodNonOptional>;
export declare const defaultProcessor: Processor<schemas.$ZodDefault>;
export declare const prefaultProcessor: Processor<schemas.$ZodPrefault>;
export declare const catchProcessor: Processor<schemas.$ZodCatch>;
export declare const pipeProcessor: Processor<schemas.$ZodPipe>;
export declare const readonlyProcessor: Processor<schemas.$ZodReadonly>;
export declare const promiseProcessor: Processor<schemas.$ZodPromise>;
export declare const optionalProcessor: Processor<schemas.$ZodOptional>;
export declare const lazyProcessor: Processor<schemas.$ZodLazy>;
export declare const allProcessors: Record<string, Processor<any>>;
export declare function toJSONSchema<T extends schemas.$ZodType>(schema: T, params?: ToJSONSchemaParams): ZodStandardJSONSchemaPayload<T>;
export declare function toJSONSchema(registry: $ZodRegistry<{
    id?: string | undefined;
}>, params?: RegistryToJSONSchemaParams): {
    schemas: Record<string, ZodStandardJSONSchemaPayload<schemas.$ZodType>>;
};
