/**
 * OpenCode Command Adapter
 *
 * Formats commands for OpenCode following its frontmatter specification.
 */
import path from 'path';
/**
 * OpenCode adapter for command generation.
 * File path: .opencode/command/opsx-<id>.md
 * Frontmatter: description
 */
export const opencodeAdapter = {
    toolId: 'opencode',
    getFilePath(commandId) {
        return path.join('.opencode', 'command', `opsx-${commandId}.md`);
    },
    formatFile(content) {
        return `---
description: ${content.description}
---

${content.body}
`;
    },
};
//# sourceMappingURL=opencode.js.map