---
title: The pandoc family of libraries
author: John MacFarlane
---

The following Haskell libraries have been developed to support
pandoc:


[citeproc]
:   Citation processing using CSL stylesheets.

[commonmark], [commonmark-extensions], and [commonmark-pandoc]
:   Efficient, standards-compliant parser for commonmark and extensions.

[djot]
:   Parser and renderer for djot light markup syntax.

[doclayout]
:   Combinators for laying out a textual document, with support
    for line wrapping, tabular layout, and more.

[doctemplates]
:   Supports pandoc's templates.

[emojis]
:   Conversion between emoji characters and aliases.

[gridtables]
:   Support for parsing grid style textual tables.

[hslua-aeson]
:   Converter from aeson data types to Lua objects.

[hslua-cli]
:   Command-line interface mimicking the default `lua` executable.

[hslua-module-doclayout]
:   Lua bindings to the doclayout library mentioned above.

[hslua-module-path], [-system], [-text], and [-version]
:   Lua modules that expose functionality of basic Haskell
    libraries to Lua.

[hslua-objectorientation], [hslua-packaging]
:   Bindings, wrappers, and helper functions to access Haskell data
    types from Lua via an object-oriented interface.

[ipynb]
:   Representation of Jupyter notebooks and conversion to and
    from JSON.

[jira-wiki-markup]
:   Support for parsing Jira wiki syntax.

[rfc5051]
:   Simple unicode collation (used for citation sorting).

[skylighting-core] and [skylighting]
:   Syntax highlighting engine supporting over 140 languages.

[texmath]
:   Conversion of math between tex, Word equation, MathML, and GNU eqn.

[typst]
:   Parsing and evaluating typst syntax.

[typst-symbol]
:   Symbol and emoji lookup for typst language.

[unicode-collation]
:   Proper Unicode collation (sorting).

[zip-archive]
:   A pure zip file creator and extractor, used by pandoc for
    docx, ODT, and EPUB.

[citeproc]: https://hackage.haskell.org/package/citeproc
[commonmark-extensions]: https://hackage.haskell.org/package/commonmark-extensions
[commonmark-pandoc]: https://hackage.haskell.org/package/commonmark-pandoc
[commonmark]: https://hackage.haskell.org/package/commonmark
[djot]: https://hackage.haskell.org/package/djot
[doclayout]: https://hackage.haskell.org/package/doclayout
[doctemplates]: https://hackage.haskell.org/package/doctemplates
[emojis]: https://hackage.haskell.org/package/emojis
[gridtables]: https://hackage.haskell.org/package/gridtables
[hslua-aeson]: https://hackage.haskell.org/package/hslua-aeson
[hslua-cli]: https://hackage.haskell.org/package/hslua-cli
[hslua-module-doclayout]: https://hackage.haskell.org/package/hslua-module-doclayout
[hslua-module-path]: https://hackage.haskell.org/package/hslua-module-path
[-system]: https://hackage.haskell.org/package/hslua-module-system
[-text]: https://hackage.haskell.org/package/hslua-module-text
[-version]: https://hackage.haskell.org/package/hslua-module-version
[hslua-objectorientation]: https://hackage.haskell.org/package/hslua-objectorientation
[hslua-packaging]: https://hackage.haskell.org/package/hslua-packaging
[ipynb]: https://hackage.haskell.org/package/ipynb
[jira-wiki-markup]: https://hackage.haskell.org/package/jira-wiki-markup
[rfc5051]: https://hackage.haskell.org/package/rfc5051
[skylighting-core]: https://hackage.haskell.org/package/skylighting-core
[skylighting]: https://hackage.haskell.org/package/skylighting
[texmath]: https://hackage.haskell.org/package/texmath
[typst-symbol]: https://hackage.haskell.org/package/typst-symbol
[typst]: https://hackage.haskell.org/package/typst
[unicode-collation]: https://hackage.haskell.org/package/unicode-collation
[zip-archive]: https://hackage.haskell.org/package/zip-archive
