import types
from _typeshed import Incomplete
from typing import ClassVar

from pony.orm import dbapiprovider, dbschema
from pony.orm.dbapiprovider import DBAPIProvider
from pony.orm.sqlbuilding import SQLBuilder, Value
from pony.orm.sqltranslation import SQLTranslator

NoneType: type[None]
mysql_module_name: str

class MySQLColumn(dbschema.Column):
    auto_template: ClassVar[str]

class MySQLSchema(dbschema.DBSchema):
    dialect: ClassVar[str]
    column_class: ClassVar[type[MySQLColumn]]

class MySQLTranslator(SQLTranslator):
    dialect: ClassVar[str]

class MySQLValue(Value): ...

class MySQLBuilder(SQLBuilder):
    dialect: ClassVar[str]
    value_class: ClassVar[type[MySQLValue]]
    def CONCAT(builder, *args): ...
    def TRIM(builder, expr, chars=None): ...
    def LTRIM(builder, expr, chars=None): ...
    def RTRIM(builder, expr, chars=None): ...
    def TO_INT(builder, expr): ...
    def TO_REAL(builder, expr): ...
    def TO_STR(builder, expr): ...
    def YEAR(builder, expr): ...
    def MONTH(builder, expr): ...
    def DAY(builder, expr): ...
    def HOUR(builder, expr): ...
    def MINUTE(builder, expr): ...
    def SECOND(builder, expr): ...
    def DATE_ADD(builder, expr, delta): ...
    def DATE_SUB(builder, expr, delta): ...
    def DATE_DIFF(builder, expr1, expr2): ...
    def DATETIME_ADD(builder, expr, delta): ...
    def DATETIME_SUB(builder, expr, delta): ...
    def DATETIME_DIFF(builder, expr1, expr2): ...
    def JSON_QUERY(builder, expr, path): ...
    def JSON_VALUE(builder, expr, path, type): ...
    def JSON_NONZERO(builder, expr): ...
    def JSON_ARRAY_LENGTH(builder, value): ...
    def JSON_EQ(builder, left, right): ...
    def JSON_NE(builder, left, right): ...
    def JSON_CONTAINS(builder, expr, path, key): ...
    @classmethod
    def wrap_param_to_json_array(cls, values): ...
    def JSON_PARAM(builder, expr): ...

class MySQLStrConverter(dbapiprovider.StrConverter):
    def sql_type(converter): ...

class MySQLRealConverter(dbapiprovider.RealConverter):
    def sql_type(converter): ...

class MySQLBlobConverter(dbapiprovider.BlobConverter):
    def sql_type(converter): ...

class MySQLTimeConverter(dbapiprovider.TimeConverter):
    def sql2py(converter, val): ...

class MySQLTimedeltaConverter(dbapiprovider.TimedeltaConverter): ...

class MySQLUuidConverter(dbapiprovider.UuidConverter):
    def sql_type(converter): ...

class MySQLJsonConverter(dbapiprovider.JsonConverter):
    EQ: str
    NE: str
    def init(self, kwargs) -> None: ...

class MySQLProvider(DBAPIProvider):
    dialect: ClassVar[str]
    varchar_default_max_len: ClassVar[int]
    dbapi_module: ClassVar[types.ModuleType]
    dbschema_cls: ClassVar[type[MySQLSchema]]
    translator_cls: ClassVar[type[MySQLTranslator]]
    sqlbuilder_cls: ClassVar[type[MySQLBuilder]]
    fk_types: ClassVar[dict[str, str]]
    converter_classes: Incomplete
    def normalize_name(provider, name): ...
    def inspect_connection(provider, connection) -> None: ...
    def should_reconnect(provider, exc): ...
    def get_pool(provider, *args, **kwargs): ...
    def set_transaction_mode(provider, connection, cache) -> None: ...
    def release(provider, connection, cache=None) -> None: ...
    def table_exists(provider, connection, table_name, case_sensitive: bool = True): ...
    def index_exists(provider, connection, table_name, index_name, case_sensitive: bool = True): ...
    def fk_exists(provider, connection, table_name, fk_name, case_sensitive: bool = True): ...

provider_cls = MySQLProvider

def str2datetime(s): ...
