private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "MIPS"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_dvasprintf_cdnopuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdnopuxX"
		altNames = "_dvasprintf"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_788_1_4 {
	meta:
		name = "_Cnd_destroy"
		size = 28
		refs = "0008 pthread_cond_destroy"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_166_0_4 {
	meta:
		name = "_Exit"
		size = 16
		refs = "0008 _exit"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_616_0_4 {
	meta:
		name = "_LDscale"
		size = 28
		refs = "0008 _Dscale"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_360_0_4 {
	meta:
		name = "_LDtest"
		size = 28
		refs = "0008 _Dtest"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_522_0_4 {
	meta:
		name = "_LDunscale"
		size = 28
		refs = "0008 _Dunscale"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_174_9_4 {
	meta:
		name = "_Thrd_current"
		size = 28
		refs = "0008 pthread_self"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_174_4_4 {
	meta:
		name = "_Thrd_exit"
		size = 16
		refs = "0008 pthread_exit"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_174_6_4 {
	meta:
		name = "_Thrd_yield"
		size = 28
		refs = "0008 sched_yield"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_400_0_4 {
	meta:
		name = "_Tss_create"
		size = 28
		refs = "0008 pthread_key_create"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_400_1_4 {
	meta:
		name = "_Tss_delete"
		size = 28
		refs = "0008 pthread_key_delete"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_400_3_4 {
	meta:
		name = "_Tss_get"
		size = 28
		refs = "0008 pthread_getspecific"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_400_2_4 {
	meta:
		name = "_Tss_set"
		size = 28
		refs = "0008 pthread_setspecific"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_775_7_4 {
	meta:
		name = "_ZNKSt11logic_error8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_775_8_4 {
	meta:
		name = "_ZNKSt12length_error8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_775_6_4 {
	meta:
		name = "_ZNKSt12out_of_range8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_443_48_4 {
	meta:
		name = "_ZNKSt12system_error8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_775_3_4 {
	meta:
		name = "_ZNKSt13runtime_error8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_775_5_4 {
	meta:
		name = "_ZNKSt14overflow_error8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_775_9_4 {
	meta:
		name = "_ZNKSt16invalid_argument8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_634_52_4 {
	meta:
		name = "_ZNKSt8ios_base7failure8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_82_16_4 {
	meta:
		name = "_ZNKSt9bad_alloc8_DoraiseEv"
		size = 28
		refs = "0008 _ZSt6_ThrowRKSt9exception"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_156_1_4 {
	meta:
		name = "_ZNSt3tr114_Random_deviceEv"
		size = 28
		refs = "0008 rand"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_486_10_4 {
	meta:
		name = "_ZNSt6locale16_GetgloballocaleEv"
		size = 28
		refs = "0008 _Getgloballocale"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_486_11_4 {
	meta:
		name = "_ZNSt6locale16_SetgloballocaleEPv"
		size = 28
		refs = "0008 _Setgloballocale"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_38_0_4 {
	meta:
		name = "_ZStL8do_abortv"
		size = 28
		refs = "0008 abort"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_79_0_4 {
	meta:
		name = "_ZdaPv"
		size = 28
		refs = "0008 _ZdlPv"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_270_0_4 {
	meta:
		name = "_ZdaPvRKSt9nothrow_t"
		size = 28
		refs = "0008 _ZdlPvRKSt9nothrow_t"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_464_0_4 {
	meta:
		name = "_ZdlPvRKSt9nothrow_t"
		size = 28
		refs = "0008 _ZdlPv"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_428_0_4 {
	meta:
		name = "_Znam"
		size = 28
		refs = "0008 _Znwm"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_118_0_4 {
	meta:
		name = "_ZnamRKSt9nothrow_t"
		size = 28
		refs = "0008 _ZnwmRKSt9nothrow_t"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_892_1_0 {
	meta:
		name = "_dstrtod"
		size = 28
		refs = "0008 __strtod"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1125_0_0 {
	meta:
		name = "_dvasprintf_cdeEfFgGnopsuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "_dvasprintf_cdeEfFgGnopuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_551_0_0 {
	meta:
		name = "_dvasprintf_cdeEfFnopsuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_598_0_0 {
	meta:
		name = "_dvasprintf_cdeEfFnopuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdeEfFnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_664_0_0 {
	meta:
		name = "_dvasprintf_cdeEgGnopsuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "_dvasprintf_cdeEgGnopuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdeEgGnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_796_0_0 {
	meta:
		name = "_dvasprintf_cdeEnopsuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdeEnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_902_0_0 {
	meta:
		name = "_dvasprintf_cdeEnopuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdeEnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_505_0_0 {
	meta:
		name = "_dvasprintf_cdfFgGnopsuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_485_0_0 {
	meta:
		name = "_dvasprintf_cdfFgGnopuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdfFgGnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "_dvasprintf_cdfFnopsuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdfFnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "_dvasprintf_cdfFnopuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdfFnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_756_0_0 {
	meta:
		name = "_dvasprintf_cdgGnopsuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdgGnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1164_0_0 {
	meta:
		name = "_dvasprintf_cdgGnopuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdgGnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "_dvasprintf_cdnopsuxX"
		size = 28
		refs = "0008 _d__vasprintf_cdnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_997_0_0 {
	meta:
		name = "_dvasprintf_eE"
		size = 28
		refs = "0008 _d__vasprintf_eE"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1192_0_0 {
	meta:
		name = "_dvasprintf_eEfF"
		size = 28
		refs = "0008 _d__vasprintf_eEfF"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_827_0_0 {
	meta:
		name = "_dvasprintf_eEfFgG"
		size = 28
		refs = "0008 _d__vasprintf_eEfFgG"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "_dvasprintf_eEfFgGs"
		size = 28
		refs = "0008 _d__vasprintf_eEfFgGs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_845_0_0 {
	meta:
		name = "_dvasprintf_eEfFs"
		size = 28
		refs = "0008 _d__vasprintf_eEfFs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "_dvasprintf_eEgG"
		size = 28
		refs = "0008 _d__vasprintf_eEgG"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_513_0_0 {
	meta:
		name = "_dvasprintf_eEgGs"
		size = 28
		refs = "0008 _d__vasprintf_eEgGs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1171_0_0 {
	meta:
		name = "_dvasprintf_eEs"
		size = 28
		refs = "0008 _d__vasprintf_eEs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_785_0_0 {
	meta:
		name = "_dvasprintf_fF"
		size = 28
		refs = "0008 _d__vasprintf_fF"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_778_0_0 {
	meta:
		name = "_dvasprintf_fFgG"
		size = 28
		refs = "0008 _d__vasprintf_fFgG"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "_dvasprintf_fFgGs"
		size = 28
		refs = "0008 _d__vasprintf_fFgGs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1078_0_0 {
	meta:
		name = "_dvasprintf_fFs"
		size = 28
		refs = "0008 _d__vasprintf_fFs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "_dvasprintf_gG"
		size = 28
		refs = "0008 _d__vasprintf_gG"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_488_0_0 {
	meta:
		name = "_dvasprintf_gGs"
		size = 28
		refs = "0008 _d__vasprintf_gGs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "_dvasprintf_s"
		size = 28
		refs = "0008 _d__vasprintf_s"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1189_0_0 {
	meta:
		name = "_ivasprintf"
		size = 28
		refs = "0008 _i__vasprintf"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_880_0_0 {
	meta:
		name = "_vasprintf"
		size = 28
		refs = "0008 ___vasprintf"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "_vasprintf_cdeEfFgGnopsuxX"
		size = 28
		refs = "0008 ___vasprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_665_0_0 {
	meta:
		name = "_vasprintf_cdeEfFgGnopuxX"
		size = 28
		refs = "0008 ___vasprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "_vasprintf_cdeEfFnopsuxX"
		size = 28
		refs = "0008 ___vasprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1091_0_0 {
	meta:
		name = "_vasprintf_cdeEfFnopuxX"
		size = 28
		refs = "0008 ___vasprintf_cdeEfFnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_546_0_0 {
	meta:
		name = "_vasprintf_cdeEgGnopsuxX"
		size = 28
		refs = "0008 ___vasprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1116_0_0 {
	meta:
		name = "_vasprintf_cdeEgGnopuxX"
		size = 28
		refs = "0008 ___vasprintf_cdeEgGnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "_vasprintf_cdeEnopsuxX"
		size = 28
		refs = "0008 ___vasprintf_cdeEnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_707_0_0 {
	meta:
		name = "_vasprintf_cdeEnopuxX"
		size = 28
		refs = "0008 ___vasprintf_cdeEnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_583_0_0 {
	meta:
		name = "_vasprintf_cdfFgGnopsuxX"
		size = 28
		refs = "0008 ___vasprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_932_0_0 {
	meta:
		name = "_vasprintf_cdfFgGnopuxX"
		size = 28
		refs = "0008 ___vasprintf_cdfFgGnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_767_0_0 {
	meta:
		name = "_vasprintf_cdfFnopsuxX"
		size = 28
		refs = "0008 ___vasprintf_cdfFnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_825_0_0 {
	meta:
		name = "_vasprintf_cdfFnopuxX"
		size = 28
		refs = "0008 ___vasprintf_cdfFnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "_vasprintf_cdgGnopsuxX"
		size = 28
		refs = "0008 ___vasprintf_cdgGnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_853_0_0 {
	meta:
		name = "_vasprintf_cdgGnopuxX"
		size = 28
		refs = "0008 ___vasprintf_cdgGnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_516_0_0 {
	meta:
		name = "_vasprintf_cdnopsuxX"
		size = 28
		refs = "0008 ___vasprintf_cdnopsuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_959_0_0 {
	meta:
		name = "_vasprintf_cdnopuxX"
		size = 28
		refs = "0008 ___vasprintf_cdnopuxX"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "_vasprintf_eE"
		size = 28
		refs = "0008 ___vasprintf_eE"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1059_0_0 {
	meta:
		name = "_vasprintf_eEfF"
		size = 28
		refs = "0008 ___vasprintf_eEfF"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_662_0_0 {
	meta:
		name = "_vasprintf_eEfFgG"
		size = 28
		refs = "0008 ___vasprintf_eEfFgG"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "_vasprintf_eEfFgGs"
		size = 28
		refs = "0008 ___vasprintf_eEfFgGs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "_vasprintf_eEfFs"
		size = 28
		refs = "0008 ___vasprintf_eEfFs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "_vasprintf_eEgG"
		size = 28
		refs = "0008 ___vasprintf_eEgG"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_511_0_0 {
	meta:
		name = "_vasprintf_eEgGs"
		size = 28
		refs = "0008 ___vasprintf_eEgGs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_521_0_0 {
	meta:
		name = "_vasprintf_eEs"
		size = 28
		refs = "0008 ___vasprintf_eEs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_834_0_0 {
	meta:
		name = "_vasprintf_fF"
		size = 28
		refs = "0008 ___vasprintf_fF"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_556_0_0 {
	meta:
		name = "_vasprintf_fFgG"
		size = 28
		refs = "0008 ___vasprintf_fFgG"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1047_0_0 {
	meta:
		name = "_vasprintf_fFgGs"
		size = 28
		refs = "0008 ___vasprintf_fFgGs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "_vasprintf_fFs"
		size = 28
		refs = "0008 ___vasprintf_fFs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_504_0_0 {
	meta:
		name = "_vasprintf_gG"
		size = 28
		refs = "0008 ___vasprintf_gG"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "_vasprintf_gGs"
		size = 28
		refs = "0008 ___vasprintf_gGs"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1073_0_0 {
	meta:
		name = "_vasprintf_s"
		size = 28
		refs = "0008 ___vasprintf_s"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_705_0_4 {
	meta:
		name = "btowc"
		size = 28
		refs = "0008 _Btowc"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_804_0_4 {
	meta:
		name = "fgetpos"
		size = 28
		refs = "0008 _Fgpos"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_789_0_4 {
	meta:
		name = "getc"
		size = 28
		refs = "0008 fgetc"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_80_0_4 {
	meta:
		name = "getwc"
		size = 28
		refs = "0008 fgetwc"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_203_0_4 {
	meta:
		name = "iswctype"
		size = 28
		refs = "0008 _Iswctype"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_111_0_4 {
	meta:
		name = "nextafterl"
		size = 28
		refs = "0008 nexttowardl"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_432_0_4 {
	meta:
		name = "putc"
		size = 28
		refs = "0008 fputc"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1_0_4 {
	meta:
		name = "putwc"
		size = 28
		refs = "0008 fputwc"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_767_0_4 {
	meta:
		name = "rand_s"
		size = 28
		refs = "0008 rand"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_64_0_2 {
	meta:
		name = "sqrtf"
		size = 28
		refs = "0008 __sqrtsf2"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_604_1_0 {
	meta:
		name = "strtodf"
		size = 28
		refs = "0008 __strtof"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_604_0_0 {
	meta:
		name = "strtof"
		size = 28
		refs = "0008 __strtof"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_420_0_4 {
	meta:
		name = "strtoimax"
		size = 28
		refs = "0008 _Stoll"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_684_0_4 {
	meta:
		name = "strtoll"
		size = 28
		refs = "0008 _Stoll"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_412_0_4 {
	meta:
		name = "strtoul"
		size = 28
		refs = "0008 _Stoul"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_421_0_4 {
	meta:
		name = "strtoull"
		size = 28
		refs = "0008 _Stoull"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_377_0_4 {
	meta:
		name = "strtoumax"
		size = 28
		refs = "0008 _Stoull"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_188_0_4 {
	meta:
		name = "towctrans"
		size = 28
		refs = "0008 _Towctrans"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "vasprintf"
		size = 28
		refs = "0008 __vasprintf"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_348_0_4 {
	meta:
		name = "wcstoimax"
		size = 28
		refs = "0008 _WStoll"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_356_0_4 {
	meta:
		name = "wcstoll"
		size = 28
		refs = "0008 _WStoll"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_98_0_4 {
	meta:
		name = "wcstoul"
		size = 28
		refs = "0008 _WStoul"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_454_0_4 {
	meta:
		name = "wcstoull"
		size = 28
		refs = "0008 _WStoull"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_255_0_4 {
	meta:
		name = "wcstoumax"
		size = 28
		refs = "0008 _WStoull"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_312_0_4 {
	meta:
		name = "wctob"
		size = 28
		refs = "0008 _Wctob"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "_dvsprintf_eEgGs"
		size = 84
		refs = "002c _dvfprintf_eEgGs"
		altNames = "_dvsprintf _dvsprintf_eE _dvsprintf_eEgG"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "_dvsprintf_cdeEfFgGnopsuxX"
		size = 84
		refs = "002c _dvfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_685_0_0 {
	meta:
		name = "_dvsprintf_cdeEfFgGnopuxX"
		size = 84
		refs = "002c _dvfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_542_0_0 {
	meta:
		name = "_dvsprintf_cdeEfFnopsuxX"
		size = 84
		refs = "002c _dvfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1106_0_0 {
	meta:
		name = "_dvsprintf_cdeEfFnopuxX"
		size = 84
		refs = "002c _dvfprintf_cdeEfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "_dvsprintf_cdeEgGnopsuxX"
		size = 84
		refs = "002c _dvfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_721_0_0 {
	meta:
		name = "_dvsprintf_cdeEgGnopuxX"
		size = 84
		refs = "002c _dvfprintf_cdeEgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_859_0_0 {
	meta:
		name = "_dvsprintf_cdeEnopsuxX"
		size = 84
		refs = "002c _dvfprintf_cdeEnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_958_0_0 {
	meta:
		name = "_dvsprintf_cdeEnopuxX"
		size = 84
		refs = "002c _dvfprintf_cdeEnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_905_0_0 {
	meta:
		name = "_dvsprintf_cdfFgGnopsuxX"
		size = 84
		refs = "002c _dvfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "_dvsprintf_cdfFgGnopuxX"
		size = 84
		refs = "002c _dvfprintf_cdfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1161_0_0 {
	meta:
		name = "_dvsprintf_cdfFnopsuxX"
		size = 84
		refs = "002c _dvfprintf_cdfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_816_0_0 {
	meta:
		name = "_dvsprintf_cdfFnopuxX"
		size = 84
		refs = "002c _dvfprintf_cdfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_833_0_0 {
	meta:
		name = "_dvsprintf_cdgGnopsuxX"
		size = 84
		refs = "002c _dvfprintf_cdgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_949_0_0 {
	meta:
		name = "_dvsprintf_cdgGnopuxX"
		size = 84
		refs = "002c _dvfprintf_cdgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_688_0_0 {
	meta:
		name = "_dvsprintf_cdnopsuxX"
		size = 84
		refs = "002c _dvfprintf_cdnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "_dvsprintf_cdnopuxX"
		size = 84
		refs = "002c _dvfprintf_cdnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_998_0_0 {
	meta:
		name = "_dvsprintf_eEfF"
		size = 84
		refs = "002c _dvfprintf_eEfF"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "_dvsprintf_eEfFgG"
		size = 84
		refs = "002c _dvfprintf_eEfFgG"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "_dvsprintf_eEfFgGs"
		size = 84
		refs = "002c _dvfprintf_eEfFgGs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1017_0_0 {
	meta:
		name = "_dvsprintf_eEfFs"
		size = 84
		refs = "002c _dvfprintf_eEfFs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1062_0_0 {
	meta:
		name = "_dvsprintf_eEs"
		size = 84
		refs = "002c _dvfprintf_eEs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "_dvsprintf_fF"
		size = 84
		refs = "002c _dvfprintf_fF"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_822_0_0 {
	meta:
		name = "_dvsprintf_fFgG"
		size = 84
		refs = "002c _dvfprintf_fFgG"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "_dvsprintf_fFgGs"
		size = 84
		refs = "002c _dvfprintf_fFgGs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1061_0_0 {
	meta:
		name = "_dvsprintf_fFs"
		size = 84
		refs = "002c _dvfprintf_fFs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "_dvsprintf_gG"
		size = 84
		refs = "002c _dvfprintf_gG"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "_dvsprintf_gGs"
		size = 84
		refs = "002c _dvfprintf_gGs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1172_0_0 {
	meta:
		name = "_dvsprintf_s"
		size = 84
		refs = "002c _dvfprintf_s"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "_ivsprintf"
		size = 84
		refs = "002c _ivfprintf"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "_vsprintf"
		size = 84
		refs = "002c _vfprintf"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "_vsprintf_cdeEfFgGnopsuxX"
		size = 84
		refs = "002c _vfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_753_0_0 {
	meta:
		name = "_vsprintf_cdeEfFgGnopuxX"
		size = 84
		refs = "002c _vfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "_vsprintf_cdeEfFnopsuxX"
		size = 84
		refs = "002c _vfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_615_0_0 {
	meta:
		name = "_vsprintf_cdeEfFnopuxX"
		size = 84
		refs = "002c _vfprintf_cdeEfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_650_0_0 {
	meta:
		name = "_vsprintf_cdeEgGnopsuxX"
		size = 84
		refs = "002c _vfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1165_0_0 {
	meta:
		name = "_vsprintf_cdeEgGnopuxX"
		size = 84
		refs = "002c _vfprintf_cdeEgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_727_0_0 {
	meta:
		name = "_vsprintf_cdeEnopsuxX"
		size = 84
		refs = "002c _vfprintf_cdeEnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1050_0_0 {
	meta:
		name = "_vsprintf_cdeEnopuxX"
		size = 84
		refs = "002c _vfprintf_cdeEnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "_vsprintf_cdfFgGnopsuxX"
		size = 84
		refs = "002c _vfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_906_0_0 {
	meta:
		name = "_vsprintf_cdfFgGnopuxX"
		size = 84
		refs = "002c _vfprintf_cdfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "_vsprintf_cdfFnopsuxX"
		size = 84
		refs = "002c _vfprintf_cdfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "_vsprintf_cdfFnopuxX"
		size = 84
		refs = "002c _vfprintf_cdfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "_vsprintf_cdgGnopsuxX"
		size = 84
		refs = "002c _vfprintf_cdgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_vsprintf_cdgGnopuxX"
		size = 84
		refs = "002c _vfprintf_cdgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_863_0_0 {
	meta:
		name = "_vsprintf_cdnopsuxX"
		size = 84
		refs = "002c _vfprintf_cdnopsuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "_vsprintf_cdnopuxX"
		size = 84
		refs = "002c _vfprintf_cdnopuxX"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_757_0_0 {
	meta:
		name = "_vsprintf_eE"
		size = 84
		refs = "002c _vfprintf_eE"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_687_0_0 {
	meta:
		name = "_vsprintf_eEfF"
		size = 84
		refs = "002c _vfprintf_eEfF"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_780_0_0 {
	meta:
		name = "_vsprintf_eEfFgG"
		size = 84
		refs = "002c _vfprintf_eEfFgG"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "_vsprintf_eEfFgGs"
		size = 84
		refs = "002c _vfprintf_eEfFgGs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "_vsprintf_eEfFs"
		size = 84
		refs = "002c _vfprintf_eEfFs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_746_0_0 {
	meta:
		name = "_vsprintf_eEgG"
		size = 84
		refs = "002c _vfprintf_eEgG"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_544_0_0 {
	meta:
		name = "_vsprintf_eEgGs"
		size = 84
		refs = "002c _vfprintf_eEgGs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_vsprintf_eEs"
		size = 84
		refs = "002c _vfprintf_eEs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_601_0_0 {
	meta:
		name = "_vsprintf_fF"
		size = 84
		refs = "002c _vfprintf_fF"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_737_0_0 {
	meta:
		name = "_vsprintf_fFgG"
		size = 84
		refs = "002c _vfprintf_fFgG"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1144_0_0 {
	meta:
		name = "_vsprintf_fFgGs"
		size = 84
		refs = "002c _vfprintf_fFgGs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_805_0_0 {
	meta:
		name = "_vsprintf_fFs"
		size = 84
		refs = "002c _vfprintf_fFs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "_vsprintf_gG"
		size = 84
		refs = "002c _vfprintf_gG"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1213_0_0 {
	meta:
		name = "_vsprintf_gGs"
		size = 84
		refs = "002c _vfprintf_gGs"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_641_0_0 {
	meta:
		name = "_vsprintf_s"
		size = 84
		refs = "002c _vfprintf_s"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "vsprintf"
		size = 84
		refs = "002c vfprintf"
	strings:
		$1 = { D0 FF BD 27 FF 7F 02 24 28 00 B0 AF 20 00 A2 AF 21 80 80 00 C2 00 02 24 10 00 A4 27 2C 00 BF AF 10 00 B0 AF 18 00 B0 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A2 8F 00 00 40 A0 10 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "_vprintf_fFs"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_fFs"
		altNames = "_vprintf _vprintf_fF"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_821_0_0 {
	meta:
		name = "_dvprintf"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1060_0_0 {
	meta:
		name = "_dvprintf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_625_0_0 {
	meta:
		name = "_dvprintf_cdeEfFgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1216_0_0 {
	meta:
		name = "_dvprintf_cdeEfFnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_860_0_0 {
	meta:
		name = "_dvprintf_cdeEfFnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdeEfFnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1139_0_0 {
	meta:
		name = "_dvprintf_cdeEgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1071_0_0 {
	meta:
		name = "_dvprintf_cdeEgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdeEgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1175_0_0 {
	meta:
		name = "_dvprintf_cdeEnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdeEnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "_dvprintf_cdeEnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdeEnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_828_0_0 {
	meta:
		name = "_dvprintf_cdfFgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "_dvprintf_cdfFgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdfFgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "_dvprintf_cdfFnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdfFnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_974_0_0 {
	meta:
		name = "_dvprintf_cdfFnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdfFnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_847_0_0 {
	meta:
		name = "_dvprintf_cdgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1206_0_0 {
	meta:
		name = "_dvprintf_cdgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_587_0_0 {
	meta:
		name = "_dvprintf_cdnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_919_0_0 {
	meta:
		name = "_dvprintf_cdnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_cdnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1183_0_0 {
	meta:
		name = "_dvprintf_eE"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_eE"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_455_0_0 {
	meta:
		name = "_dvprintf_eEfF"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_eEfF"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_dvprintf_eEfFgG"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_eEfFgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "_dvprintf_eEfFgGs"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_eEfFgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1043_0_0 {
	meta:
		name = "_dvprintf_eEfFs"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_eEfFs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "_dvprintf_eEgG"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_eEgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "_dvprintf_eEgGs"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_eEgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_960_0_0 {
	meta:
		name = "_dvprintf_eEs"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_eEs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_887_0_0 {
	meta:
		name = "_dvprintf_fF"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_fF"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_520_0_0 {
	meta:
		name = "_dvprintf_fFgG"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_fFgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_770_0_0 {
	meta:
		name = "_dvprintf_fFgGs"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_fFgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1057_0_0 {
	meta:
		name = "_dvprintf_fFs"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_fFs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1082_0_0 {
	meta:
		name = "_dvprintf_gG"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_gG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_897_0_0 {
	meta:
		name = "_dvprintf_gGs"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_gGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_886_0_0 {
	meta:
		name = "_dvprintf_s"
		size = 44
		refs = "0004 _iob 0018 _dvfprintf_s"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "_dvscanf"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "_dvscanf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_901_0_0 {
	meta:
		name = "_dvscanf_cdeEfFgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_814_0_0 {
	meta:
		name = "_dvscanf_cdeEfFnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_992_0_0 {
	meta:
		name = "_dvscanf_cdeEfFnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdeEfFnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1088_0_0 {
	meta:
		name = "_dvscanf_cdeEgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "_dvscanf_cdeEgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdeEgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_553_0_0 {
	meta:
		name = "_dvscanf_cdeEnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdeEnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "_dvscanf_cdeEnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdeEnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_783_0_0 {
	meta:
		name = "_dvscanf_cdfFgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_720_0_0 {
	meta:
		name = "_dvscanf_cdfFgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdfFgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_866_0_0 {
	meta:
		name = "_dvscanf_cdfFnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdfFnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_725_0_0 {
	meta:
		name = "_dvscanf_cdfFnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdfFnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1093_0_0 {
	meta:
		name = "_dvscanf_cdgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_571_0_0 {
	meta:
		name = "_dvscanf_cdgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "_dvscanf_cdnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "_dvscanf_cdnopuxX"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_cdnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "_dvscanf_eE"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_eE"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "_dvscanf_eEfF"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_eEfF"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "_dvscanf_eEfFgG"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_eEfFgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1029_0_0 {
	meta:
		name = "_dvscanf_eEfFgGs"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_eEfFgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_580_0_0 {
	meta:
		name = "_dvscanf_eEfFs"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_eEfFs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_895_0_0 {
	meta:
		name = "_dvscanf_eEgG"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_eEgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_668_0_0 {
	meta:
		name = "_dvscanf_eEgGs"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_eEgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "_dvscanf_eEs"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_eEs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_875_0_0 {
	meta:
		name = "_dvscanf_fF"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_fF"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1075_0_0 {
	meta:
		name = "_dvscanf_fFgG"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_fFgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1137_0_0 {
	meta:
		name = "_dvscanf_fFgGs"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_fFgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "_dvscanf_fFs"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_fFs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "_dvscanf_gG"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_gG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_dvscanf_gGs"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_gGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_855_0_0 {
	meta:
		name = "_dvscanf_s"
		size = 44
		refs = "0004 _iob 0018 _dvfscanf_s"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "_ivprintf"
		size = 44
		refs = "0004 _iob 0018 _ivfprintf"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_484_0_0 {
	meta:
		name = "_ivscanf"
		size = 44
		refs = "0004 _iob 0018 _ivfscanf"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_933_0_0 {
	meta:
		name = "_vprintf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_719_0_0 {
	meta:
		name = "_vprintf_cdeEfFgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1209_0_0 {
	meta:
		name = "_vprintf_cdeEfFnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "_vprintf_cdeEfFnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdeEfFnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1094_0_0 {
	meta:
		name = "_vprintf_cdeEgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "_vprintf_cdeEgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdeEgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_710_0_0 {
	meta:
		name = "_vprintf_cdeEnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdeEnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1127_0_0 {
	meta:
		name = "_vprintf_cdeEnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdeEnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1208_0_0 {
	meta:
		name = "_vprintf_cdfFgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "_vprintf_cdfFgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdfFgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "_vprintf_cdfFnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdfFnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_810_0_0 {
	meta:
		name = "_vprintf_cdfFnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdfFnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_832_0_0 {
	meta:
		name = "_vprintf_cdgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1019_0_0 {
	meta:
		name = "_vprintf_cdgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_908_0_0 {
	meta:
		name = "_vprintf_cdnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "_vprintf_cdnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_cdnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_792_0_0 {
	meta:
		name = "_vprintf_eE"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_eE"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_945_0_0 {
	meta:
		name = "_vprintf_eEfF"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_eEfF"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "_vprintf_eEfFgG"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_eEfFgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "_vprintf_eEfFgGs"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_eEfFgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "_vprintf_eEfFs"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_eEfFs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "_vprintf_eEgG"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_eEgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_519_0_0 {
	meta:
		name = "_vprintf_eEgGs"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_eEgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "_vprintf_eEs"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_eEs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1191_0_0 {
	meta:
		name = "_vprintf_fFgG"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_fFgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_981_0_0 {
	meta:
		name = "_vprintf_fFgGs"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_fFgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "_vprintf_gG"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_gG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1114_0_0 {
	meta:
		name = "_vprintf_gGs"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_gGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "_vprintf_s"
		size = 44
		refs = "0004 _iob 0018 _vfprintf_s"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "_vscanf"
		size = 44
		refs = "0004 _iob 0018 _vfscanf"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_vscanf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "_vscanf_cdeEfFgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1031_0_0 {
	meta:
		name = "_vscanf_cdeEfFnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_759_0_0 {
	meta:
		name = "_vscanf_cdeEfFnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdeEfFnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_658_0_0 {
	meta:
		name = "_vscanf_cdeEgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "_vscanf_cdeEgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdeEgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_673_0_0 {
	meta:
		name = "_vscanf_cdeEnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdeEnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1051_0_0 {
	meta:
		name = "_vscanf_cdeEnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdeEnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_840_0_0 {
	meta:
		name = "_vscanf_cdfFgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_924_0_0 {
	meta:
		name = "_vscanf_cdfFgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdfFgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_811_0_0 {
	meta:
		name = "_vscanf_cdfFnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdfFnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "_vscanf_cdfFnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdfFnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_619_0_0 {
	meta:
		name = "_vscanf_cdgGnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdgGnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_637_0_0 {
	meta:
		name = "_vscanf_cdgGnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdgGnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "_vscanf_cdnopsuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdnopsuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_413_0_0 {
	meta:
		name = "_vscanf_cdnopuxX"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_cdnopuxX"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "_vscanf_eE"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_eE"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1030_0_0 {
	meta:
		name = "_vscanf_eEfF"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_eEfF"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "_vscanf_eEfFgG"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_eEfFgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "_vscanf_eEfFgGs"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_eEfFgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "_vscanf_eEfFs"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_eEfFs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1150_0_0 {
	meta:
		name = "_vscanf_eEgG"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_eEgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_731_0_0 {
	meta:
		name = "_vscanf_eEgGs"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_eEgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "_vscanf_eEs"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_eEs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_784_0_0 {
	meta:
		name = "_vscanf_fF"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_fF"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_968_0_0 {
	meta:
		name = "_vscanf_fFgG"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_fFgG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_694_0_0 {
	meta:
		name = "_vscanf_fFgGs"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_fFgGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "_vscanf_fFs"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_fFs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "_vscanf_gG"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_gG"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1104_0_0 {
	meta:
		name = "_vscanf_gGs"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_gGs"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_611_0_0 {
	meta:
		name = "_vscanf_s"
		size = 44
		refs = "0004 _iob 0018 _vfscanf_s"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_659_0_0 {
	meta:
		name = "vprintf"
		size = 44
		refs = "0004 _iob 0018 vfprintf"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1012_0_0 {
	meta:
		name = "vscanf"
		size = 44
		refs = "0004 _iob 0018 vfscanf"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C E8 FF BD 27 21 30 A0 00 ?? ?? 84 24 14 00 BF AF ?? ?? ?? 0? 21 28 40 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "_scanf_eEfFs"
		size = 64
		refs = "000c _iob 002c _vfscanf_eEfFs"
		altNames = "_scanf _scanf_eE _scanf_eEfF"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1007_0_0 {
	meta:
		name = "_dprintf"
		size = 64
		refs = "000c _iob 002c _dvfprintf"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_666_0_0 {
	meta:
		name = "_dprintf_cdeEfFgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "_dprintf_cdeEfFgGnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1103_0_0 {
	meta:
		name = "_dprintf_cdeEfFnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_734_0_0 {
	meta:
		name = "_dprintf_cdeEfFnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "_dprintf_cdeEgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_510_0_0 {
	meta:
		name = "_dprintf_cdeEgGnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_532_0_0 {
	meta:
		name = "_dprintf_cdeEnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_804_0_0 {
	meta:
		name = "_dprintf_cdeEnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "_dprintf_cdfFgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "_dprintf_cdfFgGnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "_dprintf_cdfFnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1156_0_0 {
	meta:
		name = "_dprintf_cdfFnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_621_0_0 {
	meta:
		name = "_dprintf_cdgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "_dprintf_cdgGnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "_dprintf_cdnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1025_0_0 {
	meta:
		name = "_dprintf_cdnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfprintf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_940_0_0 {
	meta:
		name = "_dprintf_eE"
		size = 64
		refs = "000c _iob 002c _dvfprintf_eE"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "_dprintf_eEfF"
		size = 64
		refs = "000c _iob 002c _dvfprintf_eEfF"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "_dprintf_eEfFgG"
		size = 64
		refs = "000c _iob 002c _dvfprintf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1084_0_0 {
	meta:
		name = "_dprintf_eEfFgGs"
		size = 64
		refs = "000c _iob 002c _dvfprintf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_589_0_0 {
	meta:
		name = "_dprintf_eEfFs"
		size = 64
		refs = "000c _iob 002c _dvfprintf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1101_0_0 {
	meta:
		name = "_dprintf_eEgG"
		size = 64
		refs = "000c _iob 002c _dvfprintf_eEgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1217_0_0 {
	meta:
		name = "_dprintf_eEgGs"
		size = 64
		refs = "000c _iob 002c _dvfprintf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "_dprintf_eEs"
		size = 64
		refs = "000c _iob 002c _dvfprintf_eEs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "_dprintf_fF"
		size = 64
		refs = "000c _iob 002c _dvfprintf_fF"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1095_0_0 {
	meta:
		name = "_dprintf_fFgG"
		size = 64
		refs = "000c _iob 002c _dvfprintf_fFgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1210_0_0 {
	meta:
		name = "_dprintf_fFgGs"
		size = 64
		refs = "000c _iob 002c _dvfprintf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "_dprintf_fFs"
		size = 64
		refs = "000c _iob 002c _dvfprintf_fFs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_653_0_0 {
	meta:
		name = "_dprintf_gG"
		size = 64
		refs = "000c _iob 002c _dvfprintf_gG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "_dprintf_gGs"
		size = 64
		refs = "000c _iob 002c _dvfprintf_gGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "_dprintf_s"
		size = 64
		refs = "000c _iob 002c _dvfprintf_s"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "_dscanf"
		size = 64
		refs = "000c _iob 002c _dvfscanf"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_928_0_0 {
	meta:
		name = "_dscanf_cdeEfFgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_486_0_0 {
	meta:
		name = "_dscanf_cdeEfFgGnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "_dscanf_cdeEfFnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_573_0_0 {
	meta:
		name = "_dscanf_cdeEfFnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_633_0_0 {
	meta:
		name = "_dscanf_cdeEgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_925_0_0 {
	meta:
		name = "_dscanf_cdeEgGnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1079_0_0 {
	meta:
		name = "_dscanf_cdeEnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "_dscanf_cdeEnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_563_0_0 {
	meta:
		name = "_dscanf_cdfFgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1111_0_0 {
	meta:
		name = "_dscanf_cdfFgGnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_584_0_0 {
	meta:
		name = "_dscanf_cdfFnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "_dscanf_cdfFnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "_dscanf_cdgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_941_0_0 {
	meta:
		name = "_dscanf_cdgGnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_489_0_0 {
	meta:
		name = "_dscanf_cdnopsuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1197_0_0 {
	meta:
		name = "_dscanf_cdnopuxX"
		size = 64
		refs = "000c _iob 002c _dvfscanf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "_dscanf_eE"
		size = 64
		refs = "000c _iob 002c _dvfscanf_eE"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1148_0_0 {
	meta:
		name = "_dscanf_eEfF"
		size = 64
		refs = "000c _iob 002c _dvfscanf_eEfF"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "_dscanf_eEfFgG"
		size = 64
		refs = "000c _iob 002c _dvfscanf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "_dscanf_eEfFgGs"
		size = 64
		refs = "000c _iob 002c _dvfscanf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1074_0_0 {
	meta:
		name = "_dscanf_eEfFs"
		size = 64
		refs = "000c _iob 002c _dvfscanf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "_dscanf_eEgG"
		size = 64
		refs = "000c _iob 002c _dvfscanf_eEgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "_dscanf_eEgGs"
		size = 64
		refs = "000c _iob 002c _dvfscanf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_889_0_0 {
	meta:
		name = "_dscanf_eEs"
		size = 64
		refs = "000c _iob 002c _dvfscanf_eEs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_715_0_0 {
	meta:
		name = "_dscanf_fF"
		size = 64
		refs = "000c _iob 002c _dvfscanf_fF"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_dscanf_fFgG"
		size = 64
		refs = "000c _iob 002c _dvfscanf_fFgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_672_0_0 {
	meta:
		name = "_dscanf_fFgGs"
		size = 64
		refs = "000c _iob 002c _dvfscanf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "_dscanf_fFs"
		size = 64
		refs = "000c _iob 002c _dvfscanf_fFs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_813_0_0 {
	meta:
		name = "_dscanf_gG"
		size = 64
		refs = "000c _iob 002c _dvfscanf_gG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "_dscanf_gGs"
		size = 64
		refs = "000c _iob 002c _dvfscanf_gGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_671_0_0 {
	meta:
		name = "_dscanf_s"
		size = 64
		refs = "000c _iob 002c _dvfscanf_s"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_490_0_0 {
	meta:
		name = "_iprintf"
		size = 64
		refs = "000c _iob 002c _ivfprintf"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "_iscanf"
		size = 64
		refs = "000c _iob 002c _ivfscanf"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_479_0_0 {
	meta:
		name = "_printf"
		size = 64
		refs = "000c _iob 002c _vfprintf"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "_printf_cdeEfFgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "_printf_cdeEfFgGnopuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_954_0_0 {
	meta:
		name = "_printf_cdeEfFnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "_printf_cdeEfFnopuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_487_0_0 {
	meta:
		name = "_printf_cdeEgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_475_0_0 {
	meta:
		name = "_printf_cdeEgGnopuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "_printf_cdeEnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1086_0_0 {
	meta:
		name = "_printf_cdeEnopuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "_printf_cdfFgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "_printf_cdfFgGnopuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1166_0_0 {
	meta:
		name = "_printf_cdfFnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1010_0_0 {
	meta:
		name = "_printf_cdfFnopuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "_printf_cdgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "_printf_cdgGnopuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_603_0_0 {
	meta:
		name = "_printf_cdnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "_printf_cdnopuxX"
		size = 64
		refs = "000c _iob 002c _vfprintf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "_printf_eE"
		size = 64
		refs = "000c _iob 002c _vfprintf_eE"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1080_0_0 {
	meta:
		name = "_printf_eEfF"
		size = 64
		refs = "000c _iob 002c _vfprintf_eEfF"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1000_0_0 {
	meta:
		name = "_printf_eEfFgG"
		size = 64
		refs = "000c _iob 002c _vfprintf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "_printf_eEfFgGs"
		size = 64
		refs = "000c _iob 002c _vfprintf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_690_0_0 {
	meta:
		name = "_printf_eEfFs"
		size = 64
		refs = "000c _iob 002c _vfprintf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_714_0_0 {
	meta:
		name = "_printf_eEgG"
		size = 64
		refs = "000c _iob 002c _vfprintf_eEgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_773_0_0 {
	meta:
		name = "_printf_eEgGs"
		size = 64
		refs = "000c _iob 002c _vfprintf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_750_0_0 {
	meta:
		name = "_printf_eEs"
		size = 64
		refs = "000c _iob 002c _vfprintf_eEs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "_printf_fF"
		size = 64
		refs = "000c _iob 002c _vfprintf_fF"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1058_0_0 {
	meta:
		name = "_printf_fFgG"
		size = 64
		refs = "000c _iob 002c _vfprintf_fFgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "_printf_fFgGs"
		size = 64
		refs = "000c _iob 002c _vfprintf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "_printf_fFs"
		size = 64
		refs = "000c _iob 002c _vfprintf_fFs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1097_0_0 {
	meta:
		name = "_printf_gG"
		size = 64
		refs = "000c _iob 002c _vfprintf_gG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_761_0_0 {
	meta:
		name = "_printf_gGs"
		size = 64
		refs = "000c _iob 002c _vfprintf_gGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_517_0_0 {
	meta:
		name = "_printf_s"
		size = 64
		refs = "000c _iob 002c _vfprintf_s"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_502_0_0 {
	meta:
		name = "_scanf_cdeEfFgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "_scanf_cdeEfFgGnopuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_935_0_0 {
	meta:
		name = "_scanf_cdeEfFnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1109_0_0 {
	meta:
		name = "_scanf_cdeEfFnopuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_841_0_0 {
	meta:
		name = "_scanf_cdeEgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_438_0_0 {
	meta:
		name = "_scanf_cdeEgGnopuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_920_0_0 {
	meta:
		name = "_scanf_cdeEnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_934_0_0 {
	meta:
		name = "_scanf_cdeEnopuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_922_0_0 {
	meta:
		name = "_scanf_cdfFgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_scanf_cdfFgGnopuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_524_0_0 {
	meta:
		name = "_scanf_cdfFnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_836_0_0 {
	meta:
		name = "_scanf_cdfFnopuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1170_0_0 {
	meta:
		name = "_scanf_cdgGnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_632_0_0 {
	meta:
		name = "_scanf_cdgGnopuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_808_0_0 {
	meta:
		name = "_scanf_cdnopsuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_747_0_0 {
	meta:
		name = "_scanf_cdnopuxX"
		size = 64
		refs = "000c _iob 002c _vfscanf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1153_0_0 {
	meta:
		name = "_scanf_eEfFgG"
		size = 64
		refs = "000c _iob 002c _vfscanf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1034_0_0 {
	meta:
		name = "_scanf_eEfFgGs"
		size = 64
		refs = "000c _iob 002c _vfscanf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_771_0_0 {
	meta:
		name = "_scanf_eEgG"
		size = 64
		refs = "000c _iob 002c _vfscanf_eEgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_492_0_0 {
	meta:
		name = "_scanf_eEgGs"
		size = 64
		refs = "000c _iob 002c _vfscanf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "_scanf_eEs"
		size = 64
		refs = "000c _iob 002c _vfscanf_eEs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_scanf_fF"
		size = 64
		refs = "000c _iob 002c _vfscanf_fF"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_789_0_0 {
	meta:
		name = "_scanf_fFgG"
		size = 64
		refs = "000c _iob 002c _vfscanf_fFgG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "_scanf_fFgGs"
		size = 64
		refs = "000c _iob 002c _vfscanf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_644_0_0 {
	meta:
		name = "_scanf_fFs"
		size = 64
		refs = "000c _iob 002c _vfscanf_fFs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_914_0_0 {
	meta:
		name = "_scanf_gG"
		size = 64
		refs = "000c _iob 002c _vfscanf_gG"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_540_0_0 {
	meta:
		name = "_scanf_gGs"
		size = 64
		refs = "000c _iob 002c _vfscanf_gGs"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "_scanf_s"
		size = 64
		refs = "000c _iob 002c _vfscanf_s"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_534_0_0 {
	meta:
		name = "printf"
		size = 64
		refs = "000c _iob 002c vfprintf"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "scanf"
		size = 64
		refs = "000c _iob 002c vfscanf"
	strings:
		$1 = { E0 FF BD 27 24 00 A2 27 21 18 80 00 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "wspace"
		size = 96
		refs = "0008 _ctype 001c fgetc 0044 ungetc"
	strings:
		$1 = { E0 FF BD 27 14 00 B0 AF ?? ?? 10 3C 18 00 B1 AF 1C 00 BF AF ?? ?? 11 3C ?? ?? 10 26 ?? ?? ?? 0? ?? ?? 24 8E 21 18 02 02 01 00 63 80 88 00 63 30 FA FF 60 14 FF FF 03 24 04 00 43 10 ?? ?? 03 3C ?? ?? 65 8C ?? ?? ?? 0? 21 20 40 00 1C 00 BF 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "range"
		size = 144
		refs = "0008 _ctype 0074 tolower"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF ?? ?? 10 3C ?? ?? 10 26 21 10 90 00 01 00 43 90 1C 00 BF AF 04 00 62 30 0A 00 40 10 21 38 80 00 D0 FF 87 24 2A 28 E5 00 FF 00 02 24 FF 00 E7 30 0B 10 E5 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 01 00 62 30 04 00 40 50 03 00 63 30 06 00 C0 14 00 00 00 00 03 00 63 30 F5 FF 60 10 FF 00 02 24 ?? ?? ?? 0? A9 FF E7 24 ?? ?? ?? 0? 10 00 A5 AF 21 80 50 00 21 38 40 00 01 00 03 92 ?? ?? ?? 0? 10 00 A5 8F }
	condition:
		$1
}

rule file_5_2_0 {
	meta:
		name = "_dvfscanf_cdeEfFnopsuxX"
		size = 2680
		refs = "000c _ctype 00bc atoi 0314 fgetc 068c ungetc 0840 strtof 0854 fptodp"
		altNames = "_dvfscanf _dvfscanf_cdeEfFgGnopsuxX _dvfscanf_cdeEfFgGnopuxX _dvfscanf_cdeEfFnopuxX _dvfscanf_cdeEgGnopsuxX _dvfscanf_cdeEgGnopuxX _dvfscanf_cdeEnopsuxX _dvfscanf_cdeEnopuxX _dvfscanf_cdfFgGnopsuxX _dvfscanf_cdfFgGnopuxX _dvfscanf_cdfFnopsuxX _dvfscanf_cdfFnopuxX _dvfscanf_cdgGnopsuxX _dvfscanf_cdgGnopuxX _dvfscanf_eE _dvfscanf_eEfF _dvfscanf_eEfFgG _dvfscanf_eEfFgGs _dvfscanf_eEfFs _dvfscanf_eEgG _dvfscanf_eEgGs _dvfscanf_eEs _dvfscanf_fF _dvfscanf_fFgG _dvfscanf_fFgGs _dvfscanf_fFs _dvfscanf_gG _dvfscanf_gGs"
	strings:
		$1 = { 70 FF BD 27 78 00 B4 AF 74 00 B3 AF ?? ?? 14 3C ?? ?? 13 3C 10 00 A2 27 7C 00 B5 AF 8C 00 BF AF 88 00 BE AF 84 00 B7 AF 80 00 B6 AF 70 00 B2 AF 6C 00 B1 AF 68 00 B0 AF ?? ?? 94 26 21 38 A0 00 98 00 A6 AF ?? ?? 64 AE 21 A8 00 00 58 00 A0 AF 50 00 A2 AF 00 00 F0 90 CA 00 00 12 8C 00 BF 8F 21 10 90 02 01 00 42 80 88 00 42 30 BE 00 40 14 01 00 E7 24 25 00 03 24 A6 00 03 16 ?? ?? 64 8E 04 00 04 24 00 00 F2 80 21 80 00 00 54 00 A4 AF 21 B8 00 00 04 00 1E 24 FF 00 52 32 79 00 42 2E 1C 00 40 14 01 00 F1 24 21 10 92 02 01 00 42 90 04 00 42 30 60 02 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 E0 00 00 00 32 82 ?? ?? 04 3C ?? ?? 84 24 20 84 02 7C 21 10 44 02 01 00 42 90 04 00 42 30 ED FF 40 10 21 38 20 02 01 00 E7 24 00 00 F2 80 21 10 92 02 01 00 42 90 04 00 42 30 FB FF 40 54 01 00 E7 24 FF 00 52 32 79 00 42 2E E6 FF 40 10 01 00 F1 24 ?? ?? 03 3C 80 10 12 00 ?? ?? 63 24 21 10 62 00 00 00 42 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0? 64 00 A7 AF 4D FF 02 12 64 00 A7 8F FF FF 03 24 BE 01 43 14 ?? ?? 03 3C 58 00 A3 8F 0B 10 63 00 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 ?? ?? ?? 0? 64 00 A7 AF 64 00 A7 8F 00 00 F0 90 3A FF 00 16 21 10 90 02 8C 00 BF 8F 58 00 A2 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 58 00 A2 8F 07 00 40 14 8C 00 BF 8F ?? ?? 63 8E FF FF 02 24 0C 00 63 94 10 00 63 30 0A 10 03 00 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 01 00 F7 26 FF 00 F7 32 00 00 32 82 ?? ?? ?? 0? 21 38 20 02 ?? ?? ?? 0? 00 00 00 00 1B 01 E0 12 98 00 A2 8F ?? ?? ?? 0? ?? ?? 64 8E FF FF 03 24 BE FF 43 10 01 00 43 24 1C 00 40 10 21 38 20 02 21 18 83 02 00 00 63 80 88 00 63 30 15 00 60 50 00 00 23 82 ?? ?? ?? 0? 00 00 00 00 03 00 E0 16 FF FF 10 26 00 00 C2 A2 01 00 D6 26 20 84 10 7C 44 01 00 12 00 00 00 00 ?? ?? ?? 0? ?? ?? 64 8E 01 00 43 24 02 00 64 2C 3E 01 80 14 21 18 83 02 00 00 63 80 88 00 63 30 3A 01 60 14 00 00 00 00 00 00 23 82 ED FF 62 14 01 00 27 26 E9 FE E0 56 00 00 F0 90 58 00 A4 8F 01 00 82 24 FF 00 42 30 58 00 A2 AF ?? ?? ?? 0? 00 00 C0 A2 21 38 20 02 08 00 12 24 ?? ?? ?? 0? 64 00 A7 AF ?? ?? 64 8E ?? ?? ?? 0? 5C 00 A0 AF 21 88 40 00 2D 00 02 24 55 00 22 12 64 00 A7 8F 21 20 20 02 21 28 40 02 21 30 A0 02 ?? ?? ?? 0? 64 00 A7 AF FF 00 03 24 5C 00 43 10 64 00 A7 8F 30 00 02 24 DF 00 22 12 ?? ?? 64 8E 21 18 00 00 FF 00 1E 24 02 18 72 70 21 20 20 02 21 28 40 02 21 30 A0 02 64 00 A7 AF FF FF 10 26 20 84 10 7C ?? ?? ?? 0? 60 00 A3 AF 60 00 A3 8F 64 00 A7 8F 0C 00 00 12 21 18 43 00 ?? ?? 64 8E ?? ?? ?? 0? 60 00 A3 AF 21 20 40 00 21 28 40 02 21 30 A0 02 ?? ?? ?? 0? 21 88 40 00 60 00 A3 8F E9 FF 5E 14 64 00 A7 8F 21 20 20 02 21 28 40 02 21 30 A0 02 60 00 A3 AF ?? ?? ?? 0? 64 00 A7 AF FF 00 04 24 60 00 A3 8F F9 00 44 10 64 00 A7 8F 5C 00 A4 8F 23 10 03 00 A4 FE E0 16 0B 18 44 00 58 00 A4 8F 01 00 82 24 54 00 A4 8F FF 00 42 30 58 00 A2 AF 04 00 02 24 04 00 82 10 54 00 A4 8F 02 00 02 24 F0 00 82 10 98 00 A4 8F 98 00 A4 8F 00 00 82 8C 04 00 84 24 98 00 A4 AF ?? ?? ?? 0? 00 00 43 AC 02 00 04 24 00 00 32 82 21 38 20 02 ?? ?? ?? 0? 54 00 A4 AF 21 38 20 02 ?? ?? ?? 0? 64 00 A7 AF ?? ?? 64 8E 5C 00 A0 AF ?? ?? ?? 0? 0A 00 12 24 21 88 40 00 2D 00 02 24 AD FF 22 16 64 00 A7 8F ?? ?? 02 3C ?? ?? 44 8C 01 00 03 24 ?? ?? ?? 0? 5C 00 A3 AF 64 00 A7 8F 21 88 40 00 21 20 20 02 21 28 40 02 21 30 A0 02 ?? ?? ?? 0? 64 00 A7 AF FF 00 03 24 A6 FF 43 14 64 00 A7 8F ?? ?? 65 8E ?? ?? ?? 0? 21 20 20 02 58 00 A4 8F 4E FF 80 14 21 10 80 00 ?? ?? 02 3C ?? ?? 43 8C FF FF 02 24 0C 00 63 94 10 00 63 30 ?? ?? ?? 0? 0A 10 03 00 21 38 20 02 10 00 12 24 ?? ?? ?? 0? 21 A8 00 00 68 00 E0 12 58 00 A3 8F FF FF 12 24 ?? ?? ?? 0? ?? ?? 64 8E C5 00 52 10 58 00 A3 8F 03 00 E0 16 FF FF 10 26 00 00 C2 A2 01 00 D6 26 20 84 10 7C F6 FF 00 1E 21 38 20 02 ?? ?? ?? 0? 00 00 F0 90 21 38 20 02 10 00 12 24 ?? ?? ?? 0? 01 00 15 24 54 00 A3 8F A8 00 7E 10 08 00 04 24 00 00 32 82 21 38 20 02 ?? ?? ?? 0? 54 00 A4 AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 64 8E 3B 00 02 24 ?? ?? ?? 0? 0A 80 50 00 2D 00 04 24 AB 00 44 10 10 00 A3 27 01 00 63 24 21 F0 00 00 ?? ?? ?? 0? 2E 00 12 24 21 20 82 02 01 00 84 90 04 00 84 30 0C 00 80 10 00 00 00 00 0F 00 52 10 FF FF 62 A0 ?? ?? 64 8E 01 00 63 24 ?? ?? ?? 0? 60 00 A3 AF 60 00 A3 8F FF FF 10 26 20 84 10 7C F1 FF 00 16 FF FF 76 24 07 00 C0 17 00 00 00 00 05 00 52 14 00 00 00 00 FF FF 72 A0 01 00 DE 27 ?? ?? ?? 0? FF 00 DE 33 07 00 00 12 FF FF 03 24 65 00 03 24 41 00 43 10 45 00 03 24 40 00 43 50 00 00 C2 A2 FF FF 03 24 04 00 43 10 00 00 C0 A2 ?? ?? 65 8E ?? ?? ?? 0? 21 20 40 00 50 00 A4 8F EC FE 96 10 58 00 A2 8F 11 FE E0 16 21 38 20 02 58 00 A4 8F 01 00 83 24 54 00 A4 8F FF 00 63 30 05 00 82 2C 69 00 40 14 58 00 A3 AF 98 00 A2 8F 10 00 A4 27 21 28 00 00 00 00 50 8C ?? ?? ?? 0? 64 00 B1 AF 98 00 A3 8F 21 20 40 00 04 00 71 24 ?? ?? ?? 0? 00 00 00 00 00 00 02 AE 04 00 03 AE 64 00 A7 8F ?? ?? ?? 0? 98 00 B1 AF 98 00 A4 8F 01 00 62 24 00 00 96 8C FF 00 42 30 04 00 84 24 58 00 A2 AF ?? ?? ?? 0? 98 00 A4 AF 00 00 56 8C 04 00 42 24 ?? ?? ?? 0? 98 00 A2 AF ?? ?? ?? 0? 64 00 A7 AF 78 00 03 24 2E 00 43 10 64 00 A7 8F 58 00 03 24 2E 00 43 14 ?? ?? 65 8E 2D 00 A0 12 21 20 40 00 ?? ?? 64 8E ?? ?? ?? 0? 64 00 A7 AF 21 88 40 00 ?? ?? ?? 0? 64 00 A7 8F 00 00 C2 A2 ?? ?? 64 8E FF FF 10 26 20 84 10 7C ?? ?? ?? 0? 01 00 D6 26 BC FF 00 12 FF FF 03 24 2D 00 03 24 52 00 43 10 2B 00 03 24 51 00 43 50 00 00 C2 A2 21 18 82 02 01 00 63 90 04 00 63 30 B1 FF 60 10 01 00 D2 26 FF FF 10 26 FF 00 10 32 ?? ?? ?? 0? 21 80 50 02 01 00 63 90 04 00 63 30 A9 FF 60 10 01 00 52 26 00 00 C2 A2 ?? ?? 64 8E ?? ?? ?? 0? 21 B0 40 02 F7 FF 50 56 21 18 82 02 ?? ?? ?? 0? FF FF 03 24 D8 FF A0 12 ?? ?? 64 8E ?? ?? 65 8E 21 20 40 00 ?? ?? ?? 0? 64 00 A7 AF ?? ?? ?? 0? 64 00 A7 8F B2 FD E0 16 21 38 20 02 ?? ?? ?? 0? 58 00 A4 8F ?? ?? 65 8E ?? ?? ?? 0? 21 20 20 02 64 00 A7 8F ?? ?? ?? 0? 60 00 A3 8F 00 00 82 8C 04 00 84 24 98 00 A4 AF ?? ?? ?? 0? 00 00 43 A4 00 00 32 82 ?? ?? ?? 0? 21 38 20 02 98 00 A4 8F 21 28 00 00 00 00 90 8C 10 00 A4 27 ?? ?? ?? 0? 64 00 B1 AF 21 20 40 00 98 00 A2 8F ?? ?? ?? 0? 04 00 51 24 FF FF 02 24 ?? ?? ?? 0? 0B 10 63 00 ?? ?? 03 3C ?? ?? 64 8C FF FF 10 26 10 00 A2 A3 ?? ?? ?? 0? 20 84 10 7C ?? ?? ?? 0? 11 00 A3 27 ?? ?? 65 8C ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 58 00 A2 8F ?? ?? ?? 0? ?? ?? 64 8E 39 FE 42 16 FF FF 03 24 ?? ?? ?? 0? 21 38 20 02 00 00 C2 A2 ?? ?? 64 8E FF FF 10 26 20 84 10 7C ?? ?? ?? 0? 01 00 D6 26 AB FF 00 56 21 18 82 02 ?? ?? ?? 0? FF FF 03 24 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "_sprintf_fFgGs"
		size = 104
		refs = "0040 _vfprintf_fFgGs"
		altNames = "_sprintf _sprintf_fF _sprintf_fFgG"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "_dsprintf"
		size = 104
		refs = "0040 _dvfprintf"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1039_0_0 {
	meta:
		name = "_dsprintf_cdeEfFgGnopsuxX"
		size = 104
		refs = "0040 _dvfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_547_0_0 {
	meta:
		name = "_dsprintf_cdeEfFgGnopuxX"
		size = 104
		refs = "0040 _dvfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "_dsprintf_cdeEfFnopsuxX"
		size = 104
		refs = "0040 _dvfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1108_0_0 {
	meta:
		name = "_dsprintf_cdeEfFnopuxX"
		size = 104
		refs = "0040 _dvfprintf_cdeEfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "_dsprintf_cdeEgGnopsuxX"
		size = 104
		refs = "0040 _dvfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1032_0_0 {
	meta:
		name = "_dsprintf_cdeEgGnopuxX"
		size = 104
		refs = "0040 _dvfprintf_cdeEgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1149_0_0 {
	meta:
		name = "_dsprintf_cdeEnopsuxX"
		size = 104
		refs = "0040 _dvfprintf_cdeEnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "_dsprintf_cdeEnopuxX"
		size = 104
		refs = "0040 _dvfprintf_cdeEnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_705_0_0 {
	meta:
		name = "_dsprintf_cdfFgGnopsuxX"
		size = 104
		refs = "0040 _dvfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1024_0_0 {
	meta:
		name = "_dsprintf_cdfFgGnopuxX"
		size = 104
		refs = "0040 _dvfprintf_cdfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1055_0_0 {
	meta:
		name = "_dsprintf_cdfFnopsuxX"
		size = 104
		refs = "0040 _dvfprintf_cdfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "_dsprintf_cdfFnopuxX"
		size = 104
		refs = "0040 _dvfprintf_cdfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_dsprintf_cdgGnopsuxX"
		size = 104
		refs = "0040 _dvfprintf_cdgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_596_0_0 {
	meta:
		name = "_dsprintf_cdgGnopuxX"
		size = 104
		refs = "0040 _dvfprintf_cdgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_550_0_0 {
	meta:
		name = "_dsprintf_cdnopsuxX"
		size = 104
		refs = "0040 _dvfprintf_cdnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_533_0_0 {
	meta:
		name = "_dsprintf_cdnopuxX"
		size = 104
		refs = "0040 _dvfprintf_cdnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_607_0_0 {
	meta:
		name = "_dsprintf_eE"
		size = 104
		refs = "0040 _dvfprintf_eE"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_990_0_0 {
	meta:
		name = "_dsprintf_eEfF"
		size = 104
		refs = "0040 _dvfprintf_eEfF"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "_dsprintf_eEfFgG"
		size = 104
		refs = "0040 _dvfprintf_eEfFgG"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_649_0_0 {
	meta:
		name = "_dsprintf_eEfFgGs"
		size = 104
		refs = "0040 _dvfprintf_eEfFgGs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_824_0_0 {
	meta:
		name = "_dsprintf_eEfFs"
		size = 104
		refs = "0040 _dvfprintf_eEfFs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "_dsprintf_eEgG"
		size = 104
		refs = "0040 _dvfprintf_eEgG"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "_dsprintf_eEgGs"
		size = 104
		refs = "0040 _dvfprintf_eEgGs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1026_0_0 {
	meta:
		name = "_dsprintf_eEs"
		size = 104
		refs = "0040 _dvfprintf_eEs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "_dsprintf_fF"
		size = 104
		refs = "0040 _dvfprintf_fF"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_680_0_0 {
	meta:
		name = "_dsprintf_fFgG"
		size = 104
		refs = "0040 _dvfprintf_fFgG"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_858_0_0 {
	meta:
		name = "_dsprintf_fFgGs"
		size = 104
		refs = "0040 _dvfprintf_fFgGs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1121_0_0 {
	meta:
		name = "_dsprintf_fFs"
		size = 104
		refs = "0040 _dvfprintf_fFs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "_dsprintf_gG"
		size = 104
		refs = "0040 _dvfprintf_gG"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1085_0_0 {
	meta:
		name = "_dsprintf_gGs"
		size = 104
		refs = "0040 _dvfprintf_gGs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_562_0_0 {
	meta:
		name = "_dsprintf_s"
		size = 104
		refs = "0040 _dvfprintf_s"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1160_0_0 {
	meta:
		name = "_isprintf"
		size = 104
		refs = "0040 _ivfprintf"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_758_0_0 {
	meta:
		name = "_sprintf_cdeEfFgGnopsuxX"
		size = 104
		refs = "0040 _vfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "_sprintf_cdeEfFgGnopuxX"
		size = 104
		refs = "0040 _vfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_sprintf_cdeEfFnopsuxX"
		size = 104
		refs = "0040 _vfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "_sprintf_cdeEfFnopuxX"
		size = 104
		refs = "0040 _vfprintf_cdeEfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "_sprintf_cdeEgGnopsuxX"
		size = 104
		refs = "0040 _vfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "_sprintf_cdeEgGnopuxX"
		size = 104
		refs = "0040 _vfprintf_cdeEgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_867_0_0 {
	meta:
		name = "_sprintf_cdeEnopsuxX"
		size = 104
		refs = "0040 _vfprintf_cdeEnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1009_0_0 {
	meta:
		name = "_sprintf_cdeEnopuxX"
		size = 104
		refs = "0040 _vfprintf_cdeEnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "_sprintf_cdfFgGnopsuxX"
		size = 104
		refs = "0040 _vfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "_sprintf_cdfFgGnopuxX"
		size = 104
		refs = "0040 _vfprintf_cdfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "_sprintf_cdfFnopsuxX"
		size = 104
		refs = "0040 _vfprintf_cdfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_590_0_0 {
	meta:
		name = "_sprintf_cdfFnopuxX"
		size = 104
		refs = "0040 _vfprintf_cdfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "_sprintf_cdgGnopsuxX"
		size = 104
		refs = "0040 _vfprintf_cdgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1163_0_0 {
	meta:
		name = "_sprintf_cdgGnopuxX"
		size = 104
		refs = "0040 _vfprintf_cdgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "_sprintf_cdnopsuxX"
		size = 104
		refs = "0040 _vfprintf_cdnopsuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1211_0_0 {
	meta:
		name = "_sprintf_cdnopuxX"
		size = 104
		refs = "0040 _vfprintf_cdnopuxX"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "_sprintf_eE"
		size = 104
		refs = "0040 _vfprintf_eE"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_579_0_0 {
	meta:
		name = "_sprintf_eEfF"
		size = 104
		refs = "0040 _vfprintf_eEfF"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "_sprintf_eEfFgG"
		size = 104
		refs = "0040 _vfprintf_eEfFgG"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1102_0_0 {
	meta:
		name = "_sprintf_eEfFgGs"
		size = 104
		refs = "0040 _vfprintf_eEfFgGs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_815_0_0 {
	meta:
		name = "_sprintf_eEfFs"
		size = 104
		refs = "0040 _vfprintf_eEfFs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1016_0_0 {
	meta:
		name = "_sprintf_eEgG"
		size = 104
		refs = "0040 _vfprintf_eEgG"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_451_0_0 {
	meta:
		name = "_sprintf_eEgGs"
		size = 104
		refs = "0040 _vfprintf_eEgGs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "_sprintf_eEs"
		size = 104
		refs = "0040 _vfprintf_eEs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "_sprintf_fFs"
		size = 104
		refs = "0040 _vfprintf_fFs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1002_0_0 {
	meta:
		name = "_sprintf_gG"
		size = 104
		refs = "0040 _vfprintf_gG"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_967_0_0 {
	meta:
		name = "_sprintf_gGs"
		size = 104
		refs = "0040 _vfprintf_gGs"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "_sprintf_s"
		size = 104
		refs = "0040 _vfprintf_s"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_498_0_0 {
	meta:
		name = "sprintf"
		size = 104
		refs = "0040 vfprintf"
	strings:
		$1 = { D0 FF BD 27 38 00 A2 27 38 00 A6 AF 10 00 A2 AF 21 30 40 00 FF 7F 02 24 28 00 B0 AF 24 00 A2 AF 21 80 80 00 C2 00 02 24 14 00 A4 27 2C 00 BF AF 14 00 B0 AF 1C 00 B0 AF 3C 00 A7 AF 18 00 A0 AF ?? ?? ?? 0? 20 00 A2 A7 14 00 A2 8F 00 00 40 A0 14 00 A2 8F 2C 00 BF 8F 23 10 50 00 28 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "_dvsscanf_cdeEgGnopuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdeEgGnopuxX"
		altNames = "_dvsscanf"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_494_0_0 {
	meta:
		name = "_dvsscanf_cdeEfFgGnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_912_0_0 {
	meta:
		name = "_dvsscanf_cdeEfFgGnopuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_896_0_0 {
	meta:
		name = "_dvsscanf_cdeEfFnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "_dvsscanf_cdeEfFnopuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdeEfFnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1168_0_0 {
	meta:
		name = "_dvsscanf_cdeEgGnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "_dvsscanf_cdeEnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdeEnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_523_0_0 {
	meta:
		name = "_dvsscanf_cdeEnopuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdeEnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_697_0_0 {
	meta:
		name = "_dvsscanf_cdfFgGnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "_dvsscanf_cdfFgGnopuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdfFgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1186_0_0 {
	meta:
		name = "_dvsscanf_cdfFnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdfFnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "_dvsscanf_cdfFnopuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdfFnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1179_0_0 {
	meta:
		name = "_dvsscanf_cdgGnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1052_0_0 {
	meta:
		name = "_dvsscanf_cdgGnopuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_503_0_0 {
	meta:
		name = "_dvsscanf_cdnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_564_0_0 {
	meta:
		name = "_dvsscanf_cdnopuxX"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_cdnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1147_0_0 {
	meta:
		name = "_dvsscanf_eE"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_eE"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "_dvsscanf_eEfF"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_eEfF"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_788_0_0 {
	meta:
		name = "_dvsscanf_eEfFgG"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_eEfFgG"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "_dvsscanf_eEfFgGs"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_eEfFgGs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_740_0_0 {
	meta:
		name = "_dvsscanf_eEfFs"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_eEfFs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "_dvsscanf_eEgG"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_eEgG"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_948_0_0 {
	meta:
		name = "_dvsscanf_eEgGs"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_eEgGs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_712_0_0 {
	meta:
		name = "_dvsscanf_eEs"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_eEs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "_dvsscanf_fF"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_fF"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1066_0_0 {
	meta:
		name = "_dvsscanf_fFgG"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_fFgG"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "_dvsscanf_fFgGs"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_fFgGs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_927_0_0 {
	meta:
		name = "_dvsscanf_fFs"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_fFs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_610_0_0 {
	meta:
		name = "_dvsscanf_gG"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_gG"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "_dvsscanf_gGs"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_gGs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "_dvsscanf_s"
		size = 72
		refs = "0014 strlen 0034 _dvfscanf_s"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_623_0_0 {
	meta:
		name = "_ivsscanf"
		size = 72
		refs = "0014 strlen 0034 _ivfscanf"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_819_0_0 {
	meta:
		name = "_vsscanf"
		size = 72
		refs = "0014 strlen 0034 _vfscanf"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_612_0_0 {
	meta:
		name = "_vsscanf_cdeEfFgGnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_593_0_0 {
	meta:
		name = "_vsscanf_cdeEfFgGnopuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_898_0_0 {
	meta:
		name = "_vsscanf_cdeEfFnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_512_0_0 {
	meta:
		name = "_vsscanf_cdeEfFnopuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdeEfFnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "_vsscanf_cdeEgGnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "_vsscanf_cdeEgGnopuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdeEgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_831_0_0 {
	meta:
		name = "_vsscanf_cdeEnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdeEnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_496_0_0 {
	meta:
		name = "_vsscanf_cdeEnopuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdeEnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_599_0_0 {
	meta:
		name = "_vsscanf_cdfFgGnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_738_0_0 {
	meta:
		name = "_vsscanf_cdfFgGnopuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdfFgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1159_0_0 {
	meta:
		name = "_vsscanf_cdfFnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdfFnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_645_0_0 {
	meta:
		name = "_vsscanf_cdfFnopuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdfFnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_975_0_0 {
	meta:
		name = "_vsscanf_cdgGnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "_vsscanf_cdgGnopuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "_vsscanf_cdnopsuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdnopsuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "_vsscanf_cdnopuxX"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_cdnopuxX"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_977_0_0 {
	meta:
		name = "_vsscanf_eE"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_eE"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1027_0_0 {
	meta:
		name = "_vsscanf_eEfF"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_eEfF"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1131_0_0 {
	meta:
		name = "_vsscanf_eEfFgG"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_eEfFgG"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "_vsscanf_eEfFgGs"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_eEfFgGs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_871_0_0 {
	meta:
		name = "_vsscanf_eEfFs"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_eEfFs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_663_0_0 {
	meta:
		name = "_vsscanf_eEgG"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_eEgG"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_987_0_0 {
	meta:
		name = "_vsscanf_eEgGs"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_eEgGs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "_vsscanf_eEs"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_eEs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_581_0_0 {
	meta:
		name = "_vsscanf_fF"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_fF"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1072_0_0 {
	meta:
		name = "_vsscanf_fFgG"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_fFgG"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_879_0_0 {
	meta:
		name = "_vsscanf_fFgGs"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_fFgGs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_907_0_0 {
	meta:
		name = "_vsscanf_fFs"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_fFs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "_vsscanf_gG"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_gG"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_616_0_0 {
	meta:
		name = "_vsscanf_gGs"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_gGs"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_605_0_0 {
	meta:
		name = "_vsscanf_s"
		size = 72
		refs = "0014 strlen 0034 _vfscanf_s"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_582_0_0 {
	meta:
		name = "vsscanf"
		size = 72
		refs = "0014 strlen 0034 vfscanf"
	strings:
		$1 = { C8 FF BD 27 34 00 BF AF 10 00 A4 AF 18 00 A4 AF 28 00 A5 AF ?? ?? ?? 0? 2C 00 A6 AF 28 00 A5 8F 2C 00 A6 8F 14 00 A2 AF 20 00 A2 AF 10 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "_fscanf_eEfFgG"
		size = 44
		refs = "0018 _vfscanf_eEfFgG"
		altNames = "_fscanf _fscanf_eE _fscanf_eEfF _fscanf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "_asprintf"
		size = 44
		refs = "0018 ___vasprintf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "_asprintf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0018 ___vasprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_985_0_0 {
	meta:
		name = "_asprintf_cdeEfFgGnopuxX"
		size = 44
		refs = "0018 ___vasprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_617_0_0 {
	meta:
		name = "_asprintf_cdeEfFnopsuxX"
		size = 44
		refs = "0018 ___vasprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "_asprintf_cdeEfFnopuxX"
		size = 44
		refs = "0018 ___vasprintf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_976_0_0 {
	meta:
		name = "_asprintf_cdeEgGnopsuxX"
		size = 44
		refs = "0018 ___vasprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "_asprintf_cdeEgGnopuxX"
		size = 44
		refs = "0018 ___vasprintf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_552_0_0 {
	meta:
		name = "_asprintf_cdeEnopsuxX"
		size = 44
		refs = "0018 ___vasprintf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "_asprintf_cdeEnopuxX"
		size = 44
		refs = "0018 ___vasprintf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_876_0_0 {
	meta:
		name = "_asprintf_cdfFgGnopsuxX"
		size = 44
		refs = "0018 ___vasprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "_asprintf_cdfFgGnopuxX"
		size = 44
		refs = "0018 ___vasprintf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1190_0_0 {
	meta:
		name = "_asprintf_cdfFnopsuxX"
		size = 44
		refs = "0018 ___vasprintf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_530_0_0 {
	meta:
		name = "_asprintf_cdfFnopuxX"
		size = 44
		refs = "0018 ___vasprintf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1129_0_0 {
	meta:
		name = "_asprintf_cdgGnopsuxX"
		size = 44
		refs = "0018 ___vasprintf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "_asprintf_cdgGnopuxX"
		size = 44
		refs = "0018 ___vasprintf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_868_0_0 {
	meta:
		name = "_asprintf_cdnopsuxX"
		size = 44
		refs = "0018 ___vasprintf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "_asprintf_cdnopuxX"
		size = 44
		refs = "0018 ___vasprintf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "_asprintf_eE"
		size = 44
		refs = "0018 ___vasprintf_eE"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_917_0_0 {
	meta:
		name = "_asprintf_eEfF"
		size = 44
		refs = "0018 ___vasprintf_eEfF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_849_0_0 {
	meta:
		name = "_asprintf_eEfFgG"
		size = 44
		refs = "0018 ___vasprintf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1202_0_0 {
	meta:
		name = "_asprintf_eEfFgGs"
		size = 44
		refs = "0018 ___vasprintf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_726_0_0 {
	meta:
		name = "_asprintf_eEfFs"
		size = 44
		refs = "0018 ___vasprintf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_asprintf_eEgG"
		size = 44
		refs = "0018 ___vasprintf_eEgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1169_0_0 {
	meta:
		name = "_asprintf_eEgGs"
		size = 44
		refs = "0018 ___vasprintf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1046_0_0 {
	meta:
		name = "_asprintf_eEs"
		size = 44
		refs = "0018 ___vasprintf_eEs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "_asprintf_fF"
		size = 44
		refs = "0018 ___vasprintf_fF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "_asprintf_fFgG"
		size = 44
		refs = "0018 ___vasprintf_fFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "_asprintf_fFgGs"
		size = 44
		refs = "0018 ___vasprintf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "_asprintf_fFs"
		size = 44
		refs = "0018 ___vasprintf_fFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "_asprintf_gG"
		size = 44
		refs = "0018 ___vasprintf_gG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1132_0_0 {
	meta:
		name = "_asprintf_gGs"
		size = 44
		refs = "0018 ___vasprintf_gGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "_asprintf_s"
		size = 44
		refs = "0018 ___vasprintf_s"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_509_0_0 {
	meta:
		name = "_dasprintf"
		size = 44
		refs = "0018 _d__vasprintf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1214_0_0 {
	meta:
		name = "_dasprintf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "_dasprintf_cdeEfFgGnopuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_639_0_0 {
	meta:
		name = "_dasprintf_cdeEfFnopsuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_848_0_0 {
	meta:
		name = "_dasprintf_cdeEfFnopuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "_dasprintf_cdeEgGnopsuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "_dasprintf_cdeEgGnopuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "_dasprintf_cdeEnopsuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_762_0_0 {
	meta:
		name = "_dasprintf_cdeEnopuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_956_0_0 {
	meta:
		name = "_dasprintf_cdfFgGnopsuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_497_0_0 {
	meta:
		name = "_dasprintf_cdfFgGnopuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_506_0_0 {
	meta:
		name = "_dasprintf_cdfFnopsuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_993_0_0 {
	meta:
		name = "_dasprintf_cdfFnopuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_755_0_0 {
	meta:
		name = "_dasprintf_cdgGnopsuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "_dasprintf_cdgGnopuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_732_0_0 {
	meta:
		name = "_dasprintf_cdnopsuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_741_0_0 {
	meta:
		name = "_dasprintf_cdnopuxX"
		size = 44
		refs = "0018 _d__vasprintf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_474_0_0 {
	meta:
		name = "_dasprintf_eE"
		size = 44
		refs = "0018 _d__vasprintf_eE"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1176_0_0 {
	meta:
		name = "_dasprintf_eEfF"
		size = 44
		refs = "0018 _d__vasprintf_eEfF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_751_0_0 {
	meta:
		name = "_dasprintf_eEfFgG"
		size = 44
		refs = "0018 _d__vasprintf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_dasprintf_eEfFgGs"
		size = 44
		refs = "0018 _d__vasprintf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "_dasprintf_eEfFs"
		size = 44
		refs = "0018 _d__vasprintf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_594_0_0 {
	meta:
		name = "_dasprintf_eEgG"
		size = 44
		refs = "0018 _d__vasprintf_eEgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_558_0_0 {
	meta:
		name = "_dasprintf_eEgGs"
		size = 44
		refs = "0018 _d__vasprintf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_752_0_0 {
	meta:
		name = "_dasprintf_eEs"
		size = 44
		refs = "0018 _d__vasprintf_eEs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "_dasprintf_fF"
		size = 44
		refs = "0018 _d__vasprintf_fF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "_dasprintf_fFgG"
		size = 44
		refs = "0018 _d__vasprintf_fFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_874_0_0 {
	meta:
		name = "_dasprintf_fFgGs"
		size = 44
		refs = "0018 _d__vasprintf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_854_0_0 {
	meta:
		name = "_dasprintf_fFs"
		size = 44
		refs = "0018 _d__vasprintf_fFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_394_0_0 {
	meta:
		name = "_dasprintf_gG"
		size = 44
		refs = "0018 _d__vasprintf_gG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_501_0_0 {
	meta:
		name = "_dasprintf_gGs"
		size = 44
		refs = "0018 _d__vasprintf_gGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1063_0_0 {
	meta:
		name = "_dasprintf_s"
		size = 44
		refs = "0018 _d__vasprintf_s"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "_dfprintf"
		size = 44
		refs = "0018 _dvfprintf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_969_0_0 {
	meta:
		name = "_dfprintf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0018 _dvfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_857_0_0 {
	meta:
		name = "_dfprintf_cdeEfFgGnopuxX"
		size = 44
		refs = "0018 _dvfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "_dfprintf_cdeEfFnopsuxX"
		size = 44
		refs = "0018 _dvfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_554_0_0 {
	meta:
		name = "_dfprintf_cdeEfFnopuxX"
		size = 44
		refs = "0018 _dvfprintf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "_dfprintf_cdeEgGnopsuxX"
		size = 44
		refs = "0018 _dvfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1187_0_0 {
	meta:
		name = "_dfprintf_cdeEgGnopuxX"
		size = 44
		refs = "0018 _dvfprintf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1199_0_0 {
	meta:
		name = "_dfprintf_cdeEnopsuxX"
		size = 44
		refs = "0018 _dvfprintf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_766_0_0 {
	meta:
		name = "_dfprintf_cdeEnopuxX"
		size = 44
		refs = "0018 _dvfprintf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "_dfprintf_cdfFgGnopsuxX"
		size = 44
		refs = "0018 _dvfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "_dfprintf_cdfFgGnopuxX"
		size = 44
		refs = "0018 _dvfprintf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "_dfprintf_cdfFnopsuxX"
		size = 44
		refs = "0018 _dvfprintf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "_dfprintf_cdfFnopuxX"
		size = 44
		refs = "0018 _dvfprintf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_953_0_0 {
	meta:
		name = "_dfprintf_cdgGnopsuxX"
		size = 44
		refs = "0018 _dvfprintf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "_dfprintf_cdgGnopuxX"
		size = 44
		refs = "0018 _dvfprintf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_493_0_0 {
	meta:
		name = "_dfprintf_cdnopsuxX"
		size = 44
		refs = "0018 _dvfprintf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_675_0_0 {
	meta:
		name = "_dfprintf_cdnopuxX"
		size = 44
		refs = "0018 _dvfprintf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "_dfprintf_eE"
		size = 44
		refs = "0018 _dvfprintf_eE"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_931_0_0 {
	meta:
		name = "_dfprintf_eEfF"
		size = 44
		refs = "0018 _dvfprintf_eEfF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1151_0_0 {
	meta:
		name = "_dfprintf_eEfFgG"
		size = 44
		refs = "0018 _dvfprintf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "_dfprintf_eEfFgGs"
		size = 44
		refs = "0018 _dvfprintf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_640_0_0 {
	meta:
		name = "_dfprintf_eEfFs"
		size = 44
		refs = "0018 _dvfprintf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "_dfprintf_eEgG"
		size = 44
		refs = "0018 _dvfprintf_eEgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1023_0_0 {
	meta:
		name = "_dfprintf_eEgGs"
		size = 44
		refs = "0018 _dvfprintf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "_dfprintf_eEs"
		size = 44
		refs = "0018 _dvfprintf_eEs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_482_0_0 {
	meta:
		name = "_dfprintf_fF"
		size = 44
		refs = "0018 _dvfprintf_fF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1201_0_0 {
	meta:
		name = "_dfprintf_fFgG"
		size = 44
		refs = "0018 _dvfprintf_fFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "_dfprintf_fFgGs"
		size = 44
		refs = "0018 _dvfprintf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "_dfprintf_fFs"
		size = 44
		refs = "0018 _dvfprintf_fFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "_dfprintf_gG"
		size = 44
		refs = "0018 _dvfprintf_gG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_648_0_0 {
	meta:
		name = "_dfprintf_gGs"
		size = 44
		refs = "0018 _dvfprintf_gGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_728_0_0 {
	meta:
		name = "_dfprintf_s"
		size = 44
		refs = "0018 _dvfprintf_s"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_790_0_0 {
	meta:
		name = "_dfscanf"
		size = 44
		refs = "0018 _dvfscanf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_535_0_0 {
	meta:
		name = "_dfscanf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0018 _dvfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "_dfscanf_cdeEfFgGnopuxX"
		size = 44
		refs = "0018 _dvfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_965_0_0 {
	meta:
		name = "_dfscanf_cdeEfFnopsuxX"
		size = 44
		refs = "0018 _dvfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "_dfscanf_cdeEfFnopuxX"
		size = 44
		refs = "0018 _dvfscanf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_903_0_0 {
	meta:
		name = "_dfscanf_cdeEgGnopsuxX"
		size = 44
		refs = "0018 _dvfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_457_0_0 {
	meta:
		name = "_dfscanf_cdeEgGnopuxX"
		size = 44
		refs = "0018 _dvfscanf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "_dfscanf_cdeEnopsuxX"
		size = 44
		refs = "0018 _dvfscanf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_970_0_0 {
	meta:
		name = "_dfscanf_cdeEnopuxX"
		size = 44
		refs = "0018 _dvfscanf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_749_0_0 {
	meta:
		name = "_dfscanf_cdfFgGnopsuxX"
		size = 44
		refs = "0018 _dvfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_918_0_0 {
	meta:
		name = "_dfscanf_cdfFgGnopuxX"
		size = 44
		refs = "0018 _dvfscanf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "_dfscanf_cdfFnopsuxX"
		size = 44
		refs = "0018 _dvfscanf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_655_0_0 {
	meta:
		name = "_dfscanf_cdfFnopuxX"
		size = 44
		refs = "0018 _dvfscanf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1089_0_0 {
	meta:
		name = "_dfscanf_cdgGnopsuxX"
		size = 44
		refs = "0018 _dvfscanf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "_dfscanf_cdgGnopuxX"
		size = 44
		refs = "0018 _dvfscanf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "_dfscanf_cdnopsuxX"
		size = 44
		refs = "0018 _dvfscanf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_636_0_0 {
	meta:
		name = "_dfscanf_cdnopuxX"
		size = 44
		refs = "0018 _dvfscanf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_973_0_0 {
	meta:
		name = "_dfscanf_eE"
		size = 44
		refs = "0018 _dvfscanf_eE"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_667_0_0 {
	meta:
		name = "_dfscanf_eEfF"
		size = 44
		refs = "0018 _dvfscanf_eEfF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_dfscanf_eEfFgG"
		size = 44
		refs = "0018 _dvfscanf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1145_0_0 {
	meta:
		name = "_dfscanf_eEfFgGs"
		size = 44
		refs = "0018 _dvfscanf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_717_0_0 {
	meta:
		name = "_dfscanf_eEfFs"
		size = 44
		refs = "0018 _dvfscanf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_986_0_0 {
	meta:
		name = "_dfscanf_eEgG"
		size = 44
		refs = "0018 _dvfscanf_eEgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "_dfscanf_eEgGs"
		size = 44
		refs = "0018 _dvfscanf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "_dfscanf_eEs"
		size = 44
		refs = "0018 _dvfscanf_eEs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1013_0_0 {
	meta:
		name = "_dfscanf_fF"
		size = 44
		refs = "0018 _dvfscanf_fF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1204_0_0 {
	meta:
		name = "_dfscanf_fFgG"
		size = 44
		refs = "0018 _dvfscanf_fFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_656_0_0 {
	meta:
		name = "_dfscanf_fFgGs"
		size = 44
		refs = "0018 _dvfscanf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1069_0_0 {
	meta:
		name = "_dfscanf_fFs"
		size = 44
		refs = "0018 _dvfscanf_fFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_850_0_0 {
	meta:
		name = "_dfscanf_gG"
		size = 44
		refs = "0018 _dvfscanf_gG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "_dfscanf_gGs"
		size = 44
		refs = "0018 _dvfscanf_gGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1162_0_0 {
	meta:
		name = "_dfscanf_s"
		size = 44
		refs = "0018 _dvfscanf_s"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_602_0_0 {
	meta:
		name = "_fprintf"
		size = 44
		refs = "0018 _vfprintf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "_fprintf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0018 _vfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_585_0_0 {
	meta:
		name = "_fprintf_cdeEfFgGnopuxX"
		size = 44
		refs = "0018 _vfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "_fprintf_cdeEfFnopsuxX"
		size = 44
		refs = "0018 _vfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "_fprintf_cdeEfFnopuxX"
		size = 44
		refs = "0018 _vfprintf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "_fprintf_cdeEgGnopsuxX"
		size = 44
		refs = "0018 _vfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1122_0_0 {
	meta:
		name = "_fprintf_cdeEgGnopuxX"
		size = 44
		refs = "0018 _vfprintf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_768_0_0 {
	meta:
		name = "_fprintf_cdeEnopsuxX"
		size = 44
		refs = "0018 _vfprintf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "_fprintf_cdeEnopuxX"
		size = 44
		refs = "0018 _vfprintf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_597_0_0 {
	meta:
		name = "_fprintf_cdfFgGnopsuxX"
		size = 44
		refs = "0018 _vfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1048_0_0 {
	meta:
		name = "_fprintf_cdfFgGnopuxX"
		size = 44
		refs = "0018 _vfprintf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_634_0_0 {
	meta:
		name = "_fprintf_cdfFnopsuxX"
		size = 44
		refs = "0018 _vfprintf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_fprintf_cdfFnopuxX"
		size = 44
		refs = "0018 _vfprintf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_909_0_0 {
	meta:
		name = "_fprintf_cdgGnopsuxX"
		size = 44
		refs = "0018 _vfprintf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_793_0_0 {
	meta:
		name = "_fprintf_cdgGnopuxX"
		size = 44
		refs = "0018 _vfprintf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "_fprintf_cdnopsuxX"
		size = 44
		refs = "0018 _vfprintf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "_fprintf_cdnopuxX"
		size = 44
		refs = "0018 _vfprintf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_624_0_0 {
	meta:
		name = "_fprintf_eE"
		size = 44
		refs = "0018 _vfprintf_eE"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_913_0_0 {
	meta:
		name = "_fprintf_eEfF"
		size = 44
		refs = "0018 _vfprintf_eEfF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1128_0_0 {
	meta:
		name = "_fprintf_eEfFgG"
		size = 44
		refs = "0018 _vfprintf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1124_0_0 {
	meta:
		name = "_fprintf_eEfFgGs"
		size = 44
		refs = "0018 _vfprintf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_921_0_0 {
	meta:
		name = "_fprintf_eEfFs"
		size = 44
		refs = "0018 _vfprintf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "_fprintf_eEgG"
		size = 44
		refs = "0018 _vfprintf_eEgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_955_0_0 {
	meta:
		name = "_fprintf_eEgGs"
		size = 44
		refs = "0018 _vfprintf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "_fprintf_eEs"
		size = 44
		refs = "0018 _vfprintf_eEs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_799_0_0 {
	meta:
		name = "_fprintf_fF"
		size = 44
		refs = "0018 _vfprintf_fF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "_fprintf_fFgG"
		size = 44
		refs = "0018 _vfprintf_fFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1140_0_0 {
	meta:
		name = "_fprintf_fFgGs"
		size = 44
		refs = "0018 _vfprintf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_576_0_0 {
	meta:
		name = "_fprintf_fFs"
		size = 44
		refs = "0018 _vfprintf_fFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_548_0_0 {
	meta:
		name = "_fprintf_gG"
		size = 44
		refs = "0018 _vfprintf_gG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_536_0_0 {
	meta:
		name = "_fprintf_gGs"
		size = 44
		refs = "0018 _vfprintf_gGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "_fprintf_s"
		size = 44
		refs = "0018 _vfprintf_s"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "_fscanf_cdeEfFgGnopsuxX"
		size = 44
		refs = "0018 _vfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "_fscanf_cdeEfFgGnopuxX"
		size = 44
		refs = "0018 _vfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_677_0_0 {
	meta:
		name = "_fscanf_cdeEfFnopsuxX"
		size = 44
		refs = "0018 _vfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "_fscanf_cdeEfFnopuxX"
		size = 44
		refs = "0018 _vfscanf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "_fscanf_cdeEgGnopsuxX"
		size = 44
		refs = "0018 _vfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1036_0_0 {
	meta:
		name = "_fscanf_cdeEgGnopuxX"
		size = 44
		refs = "0018 _vfscanf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_742_0_0 {
	meta:
		name = "_fscanf_cdeEnopsuxX"
		size = 44
		refs = "0018 _vfscanf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1146_0_0 {
	meta:
		name = "_fscanf_cdeEnopuxX"
		size = 44
		refs = "0018 _vfscanf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "_fscanf_cdfFgGnopsuxX"
		size = 44
		refs = "0018 _vfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_681_0_0 {
	meta:
		name = "_fscanf_cdfFgGnopuxX"
		size = 44
		refs = "0018 _vfscanf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_fscanf_cdfFnopsuxX"
		size = 44
		refs = "0018 _vfscanf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_660_0_0 {
	meta:
		name = "_fscanf_cdfFnopuxX"
		size = 44
		refs = "0018 _vfscanf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_899_0_0 {
	meta:
		name = "_fscanf_cdgGnopsuxX"
		size = 44
		refs = "0018 _vfscanf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_923_0_0 {
	meta:
		name = "_fscanf_cdgGnopuxX"
		size = 44
		refs = "0018 _vfscanf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "_fscanf_cdnopsuxX"
		size = 44
		refs = "0018 _vfscanf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "_fscanf_cdnopuxX"
		size = 44
		refs = "0018 _vfscanf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "_fscanf_eEfFs"
		size = 44
		refs = "0018 _vfscanf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "_fscanf_eEgG"
		size = 44
		refs = "0018 _vfscanf_eEgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_631_0_0 {
	meta:
		name = "_fscanf_eEgGs"
		size = 44
		refs = "0018 _vfscanf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_870_0_0 {
	meta:
		name = "_fscanf_eEs"
		size = 44
		refs = "0018 _vfscanf_eEs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_669_0_0 {
	meta:
		name = "_fscanf_fF"
		size = 44
		refs = "0018 _vfscanf_fF"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_fscanf_fFgG"
		size = 44
		refs = "0018 _vfscanf_fFgG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1154_0_0 {
	meta:
		name = "_fscanf_fFgGs"
		size = 44
		refs = "0018 _vfscanf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "_fscanf_fFs"
		size = 44
		refs = "0018 _vfscanf_fFs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "_fscanf_gG"
		size = 44
		refs = "0018 _vfscanf_gG"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_775_0_0 {
	meta:
		name = "_fscanf_gGs"
		size = 44
		refs = "0018 _vfscanf_gGs"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_991_0_0 {
	meta:
		name = "_fscanf_s"
		size = 44
		refs = "0018 _vfscanf_s"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "_iasprintf"
		size = 44
		refs = "0018 _i__vasprintf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_803_0_0 {
	meta:
		name = "_ifprintf"
		size = 44
		refs = "0018 _ivfprintf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_978_0_0 {
	meta:
		name = "_ifscanf"
		size = 44
		refs = "0018 _ivfscanf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1120_0_0 {
	meta:
		name = "asprintf"
		size = 44
		refs = "0018 __vasprintf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_699_0_0 {
	meta:
		name = "fprintf"
		size = 44
		refs = "0018 vfprintf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "fscanf"
		size = 44
		refs = "0018 vfscanf"
	strings:
		$1 = { E0 FF BD 27 28 00 A2 27 28 00 A6 AF 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "_sscanf_cdeEfFgGnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdeEfFgGnopsuxX"
		altNames = "_sscanf"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_701_0_0 {
	meta:
		name = "_dsscanf"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "_dsscanf_cdeEfFgGnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdeEfFgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "_dsscanf_cdeEfFgGnopuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_835_0_0 {
	meta:
		name = "_dsscanf_cdeEfFnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_609_0_0 {
	meta:
		name = "_dsscanf_cdeEfFnopuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdeEfFnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "_dsscanf_cdeEgGnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_772_0_0 {
	meta:
		name = "_dsscanf_cdeEgGnopuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdeEgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_851_0_0 {
	meta:
		name = "_dsscanf_cdeEnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdeEnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_467_0_0 {
	meta:
		name = "_dsscanf_cdeEnopuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdeEnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_706_0_0 {
	meta:
		name = "_dsscanf_cdfFgGnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_678_0_0 {
	meta:
		name = "_dsscanf_cdfFgGnopuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdfFgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_999_0_0 {
	meta:
		name = "_dsscanf_cdfFnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdfFnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "_dsscanf_cdfFnopuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdfFnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "_dsscanf_cdgGnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1135_0_0 {
	meta:
		name = "_dsscanf_cdgGnopuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1081_0_0 {
	meta:
		name = "_dsscanf_cdnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "_dsscanf_cdnopuxX"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_cdnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "_dsscanf_eE"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_eE"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_481_0_0 {
	meta:
		name = "_dsscanf_eEfF"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_eEfF"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1184_0_0 {
	meta:
		name = "_dsscanf_eEfFgG"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_eEfFgG"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_729_0_0 {
	meta:
		name = "_dsscanf_eEfFgGs"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_eEfFgGs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_526_0_0 {
	meta:
		name = "_dsscanf_eEfFs"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_eEfFs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "_dsscanf_eEgG"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_eEgG"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_695_0_0 {
	meta:
		name = "_dsscanf_eEgGs"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_eEgGs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_507_0_0 {
	meta:
		name = "_dsscanf_eEs"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_eEs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_891_0_0 {
	meta:
		name = "_dsscanf_fF"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_fF"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_951_0_0 {
	meta:
		name = "_dsscanf_fFgG"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_fFgG"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "_dsscanf_fFgGs"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_fFgGs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "_dsscanf_fFs"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_fFs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_461_0_0 {
	meta:
		name = "_dsscanf_gG"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_gG"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "_dsscanf_gGs"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_gGs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "_dsscanf_s"
		size = 84
		refs = "0020 strlen 0040 _dvfscanf_s"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_979_0_0 {
	meta:
		name = "_isscanf"
		size = 84
		refs = "0020 strlen 0040 _ivfscanf"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1014_0_0 {
	meta:
		name = "_sscanf_cdeEfFgGnopuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdeEfFgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "_sscanf_cdeEfFnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdeEfFnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_686_0_0 {
	meta:
		name = "_sscanf_cdeEfFnopuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdeEfFnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1152_0_0 {
	meta:
		name = "_sscanf_cdeEgGnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdeEgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1003_0_0 {
	meta:
		name = "_sscanf_cdeEgGnopuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdeEgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_446_0_0 {
	meta:
		name = "_sscanf_cdeEnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdeEnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_882_0_0 {
	meta:
		name = "_sscanf_cdeEnopuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdeEnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1005_0_0 {
	meta:
		name = "_sscanf_cdfFgGnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdfFgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1205_0_0 {
	meta:
		name = "_sscanf_cdfFgGnopuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdfFgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_447_0_0 {
	meta:
		name = "_sscanf_cdfFnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdfFnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "_sscanf_cdfFnopuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdfFnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1195_0_0 {
	meta:
		name = "_sscanf_cdgGnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdgGnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "_sscanf_cdgGnopuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdgGnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_980_0_0 {
	meta:
		name = "_sscanf_cdnopsuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdnopsuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1096_0_0 {
	meta:
		name = "_sscanf_cdnopuxX"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_cdnopuxX"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_926_0_0 {
	meta:
		name = "_sscanf_eE"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_eE"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_586_0_0 {
	meta:
		name = "_sscanf_eEfF"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_eEfF"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "_sscanf_eEfFgG"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_eEfFgG"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "_sscanf_eEfFgGs"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_eEfFgGs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1065_0_0 {
	meta:
		name = "_sscanf_eEfFs"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_eEfFs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1194_0_0 {
	meta:
		name = "_sscanf_eEgG"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_eEgG"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_1123_0_0 {
	meta:
		name = "_sscanf_eEgGs"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_eEgGs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_483_0_0 {
	meta:
		name = "_sscanf_eEs"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_eEs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_572_0_0 {
	meta:
		name = "_sscanf_fF"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_fF"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_809_0_0 {
	meta:
		name = "_sscanf_fFgG"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_fFgG"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "_sscanf_fFgGs"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_fFgGs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_722_0_0 {
	meta:
		name = "_sscanf_fFs"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_fFs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_sscanf_gG"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_gG"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "_sscanf_gGs"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_gGs"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "_sscanf_s"
		size = 84
		refs = "0020 strlen 0040 _vfscanf_s"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "sscanf"
		size = 84
		refs = "0020 strlen 0040 vfscanf"
	strings:
		$1 = { C8 FF BD 27 40 00 A3 27 34 00 BF AF 40 00 A6 AF 44 00 A7 AF 10 00 A3 AF 14 00 A4 AF 1C 00 A4 AF ?? ?? ?? 0? 28 00 A5 AF 10 00 A6 8F 28 00 A5 8F 18 00 A2 AF 24 00 A2 AF 14 00 A4 27 C1 00 02 24 ?? ?? ?? 0? 20 00 A2 A7 34 00 BF 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "_d__vasprintf_eE"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_eE 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_900_0_0 {
	meta:
		name = "___vasprintf"
		size = 188
		refs = "0028 malloc 0048 _vfprintf 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_670_0_0 {
	meta:
		name = "___vasprintf_cdeEfFgGnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdeEfFgGnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_961_0_0 {
	meta:
		name = "___vasprintf_cdeEfFgGnopuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdeEfFgGnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_557_0_0 {
	meta:
		name = "___vasprintf_cdeEfFnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdeEfFnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "___vasprintf_cdeEfFnopuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdeEfFnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_869_0_0 {
	meta:
		name = "___vasprintf_cdeEgGnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdeEgGnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "___vasprintf_cdeEgGnopuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdeEgGnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_748_0_0 {
	meta:
		name = "___vasprintf_cdeEnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdeEnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1044_0_0 {
	meta:
		name = "___vasprintf_cdeEnopuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdeEnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_638_0_0 {
	meta:
		name = "___vasprintf_cdfFgGnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdfFgGnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_676_0_0 {
	meta:
		name = "___vasprintf_cdfFgGnopuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdfFgGnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "___vasprintf_cdfFnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdfFnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "___vasprintf_cdfFnopuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdfFnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_629_0_0 {
	meta:
		name = "___vasprintf_cdgGnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdgGnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_839_0_0 {
	meta:
		name = "___vasprintf_cdgGnopuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdgGnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_947_0_0 {
	meta:
		name = "___vasprintf_cdnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_537_0_0 {
	meta:
		name = "___vasprintf_cdnopuxX"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_cdnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1173_0_0 {
	meta:
		name = "___vasprintf_eE"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_eE 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_555_0_0 {
	meta:
		name = "___vasprintf_eEfF"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_eEfF 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_569_0_0 {
	meta:
		name = "___vasprintf_eEfFgG"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_eEfFgG 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "___vasprintf_eEfFgGs"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_eEfFgGs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_812_0_0 {
	meta:
		name = "___vasprintf_eEfFs"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_eEfFs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "___vasprintf_eEgG"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_eEgG 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "___vasprintf_eEgGs"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_eEgGs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "___vasprintf_eEs"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_eEs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "___vasprintf_fF"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_fF 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "___vasprintf_fFgG"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_fFgG 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1181_0_0 {
	meta:
		name = "___vasprintf_fFgGs"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_fFgGs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_566_0_0 {
	meta:
		name = "___vasprintf_fFs"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_fFs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "___vasprintf_gG"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_gG 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_657_0_0 {
	meta:
		name = "___vasprintf_gGs"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_gGs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "___vasprintf_s"
		size = 188
		refs = "0028 malloc 0048 _vfprintf_s 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_684_0_0 {
	meta:
		name = "__vasprintf"
		size = 188
		refs = "0028 malloc 0048 vfprintf 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "_d__vasprintf"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_936_0_0 {
	meta:
		name = "_d__vasprintf_cdeEfFgGnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdeEfFgGnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "_d__vasprintf_cdeEfFgGnopuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdeEfFgGnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_937_0_0 {
	meta:
		name = "_d__vasprintf_cdeEfFnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdeEfFnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_843_0_0 {
	meta:
		name = "_d__vasprintf_cdeEfFnopuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdeEfFnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "_d__vasprintf_cdeEgGnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdeEgGnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "_d__vasprintf_cdeEgGnopuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdeEgGnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1142_0_0 {
	meta:
		name = "_d__vasprintf_cdeEnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdeEnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_911_0_0 {
	meta:
		name = "_d__vasprintf_cdeEnopuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdeEnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "_d__vasprintf_cdfFgGnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdfFgGnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1056_0_0 {
	meta:
		name = "_d__vasprintf_cdfFgGnopuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdfFgGnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "_d__vasprintf_cdfFnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdfFnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "_d__vasprintf_cdfFnopuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdfFnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_693_0_0 {
	meta:
		name = "_d__vasprintf_cdgGnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdgGnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1042_0_0 {
	meta:
		name = "_d__vasprintf_cdgGnopuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdgGnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_984_0_0 {
	meta:
		name = "_d__vasprintf_cdnopsuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdnopsuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_794_0_0 {
	meta:
		name = "_d__vasprintf_cdnopuxX"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_cdnopuxX 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_988_0_0 {
	meta:
		name = "_d__vasprintf_eEfF"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_eEfF 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_d__vasprintf_eEfFgG"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_eEfFgG 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1155_0_0 {
	meta:
		name = "_d__vasprintf_eEfFgGs"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_eEfFgGs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "_d__vasprintf_eEfFs"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_eEfFs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "_d__vasprintf_eEgG"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_eEgG 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "_d__vasprintf_eEgGs"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_eEgGs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_642_0_0 {
	meta:
		name = "_d__vasprintf_eEs"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_eEs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1107_0_0 {
	meta:
		name = "_d__vasprintf_fF"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_fF 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_1174_0_0 {
	meta:
		name = "_d__vasprintf_fFgG"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_fFgG 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_627_0_0 {
	meta:
		name = "_d__vasprintf_fFgGs"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_fFgGs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "_d__vasprintf_fFs"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_fFs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_654_0_0 {
	meta:
		name = "_d__vasprintf_gG"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_gG 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "_d__vasprintf_gGs"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_gGs 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "_d__vasprintf_s"
		size = 188
		refs = "0028 malloc 0048 _dvfprintf_s 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "_i__vasprintf"
		size = 188
		refs = "0028 malloc 0048 _ivfprintf 0064 realloc 009c free 00a8 errno"
	strings:
		$1 = { C0 FF BD 27 7F 00 02 24 34 00 B0 AF 21 80 80 00 80 00 04 24 3C 00 BF AF 38 00 B1 AF 28 00 A5 AF 2C 00 A6 AF 14 00 A2 AF ?? ?? ?? 0? 20 00 A2 AF 28 00 A5 8F 2C 00 A6 8F 10 00 A2 AF 18 00 A2 AF 10 00 A4 27 C2 00 02 24 ?? ?? ?? 0? 1C 00 A2 A7 0F 00 40 04 21 88 40 00 01 00 45 24 10 00 A2 8F 00 00 40 A0 ?? ?? ?? 0? 18 00 A4 8F 09 00 40 50 18 00 A4 8F 00 00 02 AE 3C 00 BF 8F 21 10 20 02 34 00 B0 8F 38 00 B1 8F 08 00 E0 03 40 00 BD 27 18 00 A4 8F 04 00 80 10 0C 00 03 24 ?? ?? ?? 0? 00 00 00 00 0C 00 03 24 ?? ?? 02 3C 00 00 00 AE FF FF 11 24 ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "_vfscanf_fFgG"
		size = 2684
		refs = "000c _ctype 00bc atoi 0314 fgetc 068c ungetc 0840 strtod 0850 fptodp 09e4 strtof"
		altNames = "_vfscanf_cdeEfFgGnopsuxX _vfscanf_cdeEfFgGnopuxX _vfscanf_cdeEfFnopsuxX _vfscanf_cdeEfFnopuxX _vfscanf_cdeEgGnopsuxX _vfscanf_cdeEgGnopuxX _vfscanf_cdeEnopsuxX _vfscanf_cdeEnopuxX _vfscanf_cdfFgGnopsuxX _vfscanf_cdfFgGnopuxX _vfscanf_cdfFnopsuxX _vfscanf_cdfFnopuxX _vfscanf_cdgGnopsuxX _vfscanf_cdgGnopuxX _vfscanf_eE _vfscanf_eEfF _vfscanf_eEfFgG _vfscanf_eEfFgGs _vfscanf_eEfFs _vfscanf_eEgG _vfscanf_eEgGs _vfscanf_eEs _vfscanf_fF _vfscanf_fFgGs _vfscanf_fFs _vfscanf_gG _vfscanf_gGs vfscanf"
	strings:
		$1 = { 70 FF BD 27 78 00 B4 AF 74 00 B3 AF ?? ?? 14 3C ?? ?? 13 3C 10 00 A2 27 7C 00 B5 AF 8C 00 BF AF 88 00 BE AF 84 00 B7 AF 80 00 B6 AF 70 00 B2 AF 6C 00 B1 AF 68 00 B0 AF ?? ?? 94 26 21 38 A0 00 98 00 A6 AF ?? ?? 64 AE 21 A8 00 00 58 00 A0 AF 50 00 A2 AF 00 00 F0 90 CA 00 00 12 8C 00 BF 8F 21 10 90 02 01 00 42 80 88 00 42 30 BE 00 40 14 01 00 E7 24 25 00 03 24 A6 00 03 16 ?? ?? 64 8E 04 00 04 24 00 00 F2 80 21 80 00 00 54 00 A4 AF 21 B8 00 00 04 00 1E 24 FF 00 52 32 79 00 42 2E 1C 00 40 14 01 00 F1 24 21 10 92 02 01 00 42 90 04 00 42 30 61 02 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 E0 00 00 00 32 82 ?? ?? 04 3C ?? ?? 84 24 20 84 02 7C 21 10 44 02 01 00 42 90 04 00 42 30 ED FF 40 10 21 38 20 02 01 00 E7 24 00 00 F2 80 21 10 92 02 01 00 42 90 04 00 42 30 FB FF 40 54 01 00 E7 24 FF 00 52 32 79 00 42 2E E6 FF 40 10 01 00 F1 24 ?? ?? 03 3C 80 10 12 00 ?? ?? 63 24 21 10 62 00 00 00 42 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0? 64 00 A7 AF 4D FF 02 12 64 00 A7 8F FF FF 03 24 BF 01 43 14 ?? ?? 03 3C 58 00 A3 8F 0B 10 63 00 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 ?? ?? ?? 0? 64 00 A7 AF 64 00 A7 8F 00 00 F0 90 3A FF 00 16 21 10 90 02 8C 00 BF 8F 58 00 A2 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 58 00 A2 8F 07 00 40 14 8C 00 BF 8F ?? ?? 63 8E FF FF 02 24 0C 00 63 94 10 00 63 30 0A 10 03 00 8C 00 BF 8F 88 00 BE 8F 84 00 B7 8F 80 00 B6 8F 7C 00 B5 8F 78 00 B4 8F 74 00 B3 8F 70 00 B2 8F 6C 00 B1 8F 68 00 B0 8F 08 00 E0 03 90 00 BD 27 01 00 F7 26 FF 00 F7 32 00 00 32 82 ?? ?? ?? 0? 21 38 20 02 ?? ?? ?? 0? 00 00 00 00 1A 01 E0 12 98 00 A2 8F ?? ?? ?? 0? ?? ?? 64 8E FF FF 03 24 BE FF 43 10 01 00 43 24 1C 00 40 10 21 38 20 02 21 18 83 02 00 00 63 80 88 00 63 30 15 00 60 50 00 00 23 82 ?? ?? ?? 0? 00 00 00 00 03 00 E0 16 FF FF 10 26 00 00 C2 A2 01 00 D6 26 20 84 10 7C 43 01 00 12 00 00 00 00 ?? ?? ?? 0? ?? ?? 64 8E 01 00 43 24 02 00 64 2C 3D 01 80 14 21 18 83 02 00 00 63 80 88 00 63 30 39 01 60 14 00 00 00 00 00 00 23 82 ED FF 62 14 01 00 27 26 E9 FE E0 56 00 00 F0 90 58 00 A4 8F 01 00 82 24 FF 00 42 30 58 00 A2 AF ?? ?? ?? 0? 00 00 C0 A2 21 38 20 02 08 00 12 24 ?? ?? ?? 0? 64 00 A7 AF ?? ?? 64 8E ?? ?? ?? 0? 5C 00 A0 AF 21 88 40 00 2D 00 02 24 55 00 22 12 64 00 A7 8F 21 20 20 02 21 28 40 02 21 30 A0 02 ?? ?? ?? 0? 64 00 A7 AF FF 00 03 24 5C 00 43 10 64 00 A7 8F 30 00 02 24 DE 00 22 12 ?? ?? 64 8E 21 18 00 00 FF 00 1E 24 02 18 72 70 21 20 20 02 21 28 40 02 21 30 A0 02 64 00 A7 AF FF FF 10 26 20 84 10 7C ?? ?? ?? 0? 60 00 A3 AF 60 00 A3 8F 64 00 A7 8F 0C 00 00 12 21 18 43 00 ?? ?? 64 8E ?? ?? ?? 0? 60 00 A3 AF 21 20 40 00 21 28 40 02 21 30 A0 02 ?? ?? ?? 0? 21 88 40 00 60 00 A3 8F E9 FF 5E 14 64 00 A7 8F 21 20 20 02 21 28 40 02 21 30 A0 02 60 00 A3 AF ?? ?? ?? 0? 64 00 A7 AF FF 00 04 24 60 00 A3 8F F8 00 44 10 64 00 A7 8F 5C 00 A4 8F 23 10 03 00 A4 FE E0 16 0B 18 44 00 58 00 A4 8F 01 00 82 24 54 00 A4 8F FF 00 42 30 58 00 A2 AF 04 00 02 24 04 00 82 10 54 00 A4 8F 02 00 02 24 EF 00 82 10 98 00 A4 8F 98 00 A4 8F 00 00 82 8C 04 00 84 24 98 00 A4 AF ?? ?? ?? 0? 00 00 43 AC 02 00 04 24 00 00 32 82 21 38 20 02 ?? ?? ?? 0? 54 00 A4 AF 21 38 20 02 ?? ?? ?? 0? 64 00 A7 AF ?? ?? 64 8E 5C 00 A0 AF ?? ?? ?? 0? 0A 00 12 24 21 88 40 00 2D 00 02 24 AD FF 22 16 64 00 A7 8F ?? ?? 02 3C ?? ?? 44 8C 01 00 03 24 ?? ?? ?? 0? 5C 00 A3 AF 64 00 A7 8F 21 88 40 00 21 20 20 02 21 28 40 02 21 30 A0 02 ?? ?? ?? 0? 64 00 A7 AF FF 00 03 24 A6 FF 43 14 64 00 A7 8F ?? ?? 65 8E ?? ?? ?? 0? 21 20 20 02 58 00 A4 8F 4E FF 80 14 21 10 80 00 ?? ?? 02 3C ?? ?? 43 8C FF FF 02 24 0C 00 63 94 10 00 63 30 ?? ?? ?? 0? 0A 10 03 00 21 38 20 02 10 00 12 24 ?? ?? ?? 0? 21 A8 00 00 67 00 E0 12 58 00 A3 8F FF FF 12 24 ?? ?? ?? 0? ?? ?? 64 8E C6 00 52 10 58 00 A3 8F 03 00 E0 16 FF FF 10 26 00 00 C2 A2 01 00 D6 26 20 84 10 7C F6 FF 00 1E 21 38 20 02 ?? ?? ?? 0? 00 00 F0 90 21 38 20 02 10 00 12 24 ?? ?? ?? 0? 01 00 15 24 54 00 A3 8F A7 00 7E 10 08 00 04 24 00 00 32 82 21 38 20 02 ?? ?? ?? 0? 54 00 A4 AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 64 8E 3B 00 02 24 ?? ?? ?? 0? 0A 80 50 00 2D 00 04 24 AC 00 44 10 10 00 A3 27 01 00 63 24 21 F0 00 00 ?? ?? ?? 0? 2E 00 12 24 21 20 82 02 01 00 84 90 04 00 84 30 0C 00 80 10 00 00 00 00 0F 00 52 10 FF FF 62 A0 ?? ?? 64 8E 01 00 63 24 ?? ?? ?? 0? 60 00 A3 AF 60 00 A3 8F FF FF 10 26 20 84 10 7C F1 FF 00 16 FF FF 76 24 07 00 C0 17 00 00 00 00 05 00 52 14 00 00 00 00 FF FF 72 A0 01 00 DE 27 ?? ?? ?? 0? FF 00 DE 33 07 00 00 12 FF FF 03 24 65 00 03 24 40 00 43 10 45 00 03 24 3F 00 43 50 00 00 C2 A2 FF FF 03 24 04 00 43 10 00 00 C0 A2 ?? ?? 65 8E ?? ?? ?? 0? 21 20 40 00 50 00 A4 8F EC FE 96 10 58 00 A2 8F 11 FE E0 16 21 38 20 02 58 00 A4 8F 01 00 83 24 54 00 A4 8F FF 00 63 30 05 00 82 2C 68 00 40 14 58 00 A3 AF 98 00 A2 8F 21 28 00 00 10 00 A4 27 00 00 50 8C ?? ?? ?? 0? 64 00 B1 AF 98 00 A3 8F 21 20 40 00 ?? ?? ?? 0? 04 00 71 24 00 00 02 AE 04 00 03 AE 64 00 A7 8F ?? ?? ?? 0? 98 00 B1 AF 98 00 A4 8F 01 00 62 24 00 00 96 8C FF 00 42 30 04 00 84 24 58 00 A2 AF ?? ?? ?? 0? 98 00 A4 AF 00 00 56 8C 04 00 42 24 ?? ?? ?? 0? 98 00 A2 AF ?? ?? ?? 0? 64 00 A7 AF 78 00 03 24 2E 00 43 10 64 00 A7 8F 58 00 03 24 2E 00 43 14 ?? ?? 65 8E 2D 00 A0 12 21 20 40 00 ?? ?? 64 8E ?? ?? ?? 0? 64 00 A7 AF 21 88 40 00 ?? ?? ?? 0? 64 00 A7 8F 00 00 C2 A2 ?? ?? 64 8E FF FF 10 26 20 84 10 7C ?? ?? ?? 0? 01 00 D6 26 BD FF 00 12 FF FF 03 24 2D 00 03 24 54 00 43 10 2B 00 03 24 53 00 43 50 00 00 C2 A2 21 18 82 02 01 00 63 90 04 00 63 30 B2 FF 60 10 01 00 D2 26 FF FF 10 26 FF 00 10 32 ?? ?? ?? 0? 21 80 50 02 01 00 63 90 04 00 63 30 AA FF 60 10 01 00 52 26 00 00 C2 A2 ?? ?? 64 8E ?? ?? ?? 0? 21 B0 40 02 F7 FF 50 56 21 18 82 02 ?? ?? ?? 0? FF FF 03 24 D8 FF A0 12 ?? ?? 64 8E ?? ?? 65 8E 21 20 40 00 ?? ?? ?? 0? 64 00 A7 AF ?? ?? ?? 0? 64 00 A7 8F B3 FD E0 16 21 38 20 02 ?? ?? ?? 0? 58 00 A4 8F ?? ?? 65 8E ?? ?? ?? 0? 21 20 20 02 64 00 A7 8F ?? ?? ?? 0? 60 00 A3 8F 00 00 82 8C 04 00 84 24 98 00 A4 AF ?? ?? ?? 0? 00 00 43 A4 00 00 32 82 ?? ?? ?? 0? 21 38 20 02 98 00 A4 8F 98 00 A2 8F 21 28 00 00 00 00 91 8C 10 00 A4 27 04 00 50 24 ?? ?? ?? 0? 64 00 A7 AF 00 00 22 AE 64 00 A7 8F ?? ?? ?? 0? 98 00 B0 AF FF FF 02 24 ?? ?? ?? 0? 0B 10 63 00 ?? ?? 03 3C ?? ?? 64 8C FF FF 10 26 10 00 A2 A3 ?? ?? ?? 0? 20 84 10 7C ?? ?? ?? 0? 11 00 A3 27 ?? ?? 65 8C ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 58 00 A2 8F ?? ?? ?? 0? ?? ?? 64 8E 38 FE 42 16 FF FF 03 24 ?? ?? ?? 0? 21 38 20 02 00 00 C2 A2 ?? ?? 64 8E FF FF 10 26 20 84 10 7C ?? ?? ?? 0? 01 00 D6 26 A9 FF 00 56 21 18 82 02 ?? ?? ?? 0? FF FF 03 24 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "_fassert"
		size = 128
		refs = "0004 __assfail 0044 _iob 0060 _fprintf_cdnopsuxX 0068 abort"
	strings:
		$1 = { 21 10 80 00 ?? ?? 04 3C D8 FF BD 27 ?? ?? 84 24 24 00 BF AF 21 18 A0 00 07 00 80 10 21 40 E0 00 ?? ?? 04 3C 21 28 C0 00 ?? ?? 84 24 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 0D 00 E0 10 ?? ?? 09 3C ?? ?? 29 25 ?? ?? 04 3C ?? ?? 05 3C ?? ?? 84 24 ?? ?? A5 24 21 38 60 00 14 00 A9 AF 18 00 A8 AF ?? ?? ?? 0? 10 00 A2 AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 09 3C ?? ?? 29 25 ?? ?? ?? 0? 21 40 20 01 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "_dvfprintf_cdnopuxX"
		size = 2736
		refs = "0094 _ctype 01a0 fputc 050c __udivdi3 0520 __umoddi3"
		altNames = "_dvfprintf_cdnopsuxX _vfprintf_cdnopsuxX _vfprintf_cdnopuxX"
	strings:
		$1 = { A8 FF BD 27 40 00 B4 AF 34 00 B1 AF 30 00 B0 AF 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 3C 00 B3 AF 38 00 B2 AF 21 A0 80 00 21 88 A0 00 60 00 A6 AF 21 80 00 00 00 00 24 82 40 00 80 10 10 00 A4 A3 25 00 02 24 54 00 82 14 01 00 32 26 02 00 22 26 FF FF 44 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 48 00 86 10 FF FF 51 24 2E 00 85 28 3E 00 A0 10 00 00 00 00 50 00 87 50 01 00 63 34 4C 00 89 50 02 00 63 34 ?? ?? 05 3C ?? ?? A5 24 21 10 A4 00 01 00 42 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 42 30 44 00 40 10 0B 18 A6 00 21 10 00 00 0A 00 06 24 02 28 46 70 01 00 31 26 ?? ?? 07 3C ?? ?? E7 24 21 10 A4 00 00 00 24 82 21 28 E4 00 01 00 A5 90 04 00 A5 30 F6 FF A0 14 D0 FF 42 24 2E 00 05 24 40 00 85 10 21 90 00 00 6C 00 05 24 10 00 07 24 00 80 06 24 10 00 A4 A3 49 01 85 10 01 00 31 26 6D 00 85 28 50 00 A0 10 73 00 05 24 63 00 05 24 31 01 85 10 64 00 85 28 29 01 A0 50 64 00 05 24 61 01 80 14 58 00 05 24 54 00 BF 8F 21 10 00 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 C7 FF 88 14 ?? ?? 05 3C 04 00 63 34 01 00 42 24 FF FF 44 80 BA FF 86 14 FF FF 51 24 08 00 63 34 ?? ?? ?? 0? 01 00 42 24 ?? ?? ?? 0? 21 28 80 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 42 24 ?? ?? ?? 0? 01 00 42 24 2A 00 05 24 C8 FF 85 14 21 10 00 00 60 00 A8 8F 01 00 31 26 00 00 24 82 00 00 02 8D 2E 00 05 24 04 00 08 25 60 00 A8 AF C2 FF 85 14 21 90 00 00 01 00 31 26 00 00 24 82 2A 00 05 24 F1 01 85 10 00 40 63 34 ?? ?? 06 3C ?? ?? C6 24 21 28 C4 00 01 00 A5 90 04 00 A5 30 B6 FF A0 10 0A 00 06 24 02 28 46 72 01 00 31 26 ?? ?? 07 3C ?? ?? E7 24 21 90 A4 00 00 00 24 82 21 28 E4 00 01 00 A5 90 04 00 A5 30 F6 FF A0 14 D0 FF 52 26 ?? ?? ?? 0? 6C 00 05 24 FC 00 85 10 74 00 85 28 D3 00 A0 10 75 00 05 24 6F 00 05 24 34 00 85 10 70 00 05 24 13 01 85 50 20 00 63 34 10 00 B5 27 01 00 1E 24 04 00 40 52 2B 90 C2 03 2B 20 5E 02 0B F0 44 02 2B 90 C2 03 23 10 5E 00 0A 10 12 00 08 00 76 30 0C 00 C0 16 21 90 40 00 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 53 16 21 28 80 02 ?? ?? ?? 0? FF FF 13 24 00 00 A4 82 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D3 17 21 28 80 02 4B FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 53 16 21 28 80 02 ?? ?? ?? 0? 00 00 24 82 40 00 63 34 C0 00 64 30 8F 00 80 14 20 26 03 7C AD 01 80 04 60 00 A7 8F 10 00 64 30 CF 00 80 10 60 00 A4 8F 60 00 A8 8F 00 00 05 8D 04 00 08 25 60 00 A8 AF C3 27 05 00 21 A8 A0 00 21 B0 80 00 05 00 81 04 23 20 04 00 23 A8 05 00 2B 28 15 00 03 00 63 34 23 B0 85 00 03 00 40 16 C0 00 73 30 25 90 B6 02 01 00 52 2E 40 00 04 24 54 01 64 12 41 00 64 2A 31 01 80 10 80 00 04 24 15 00 60 16 10 00 B7 83 01 00 04 24 B1 01 C0 12 10 00 A4 A3 ?? ?? 04 3C ?? ?? 84 24 02 00 07 24 02 00 17 24 ?? ?? ?? 0? 14 00 08 24 21 38 E0 02 04 00 85 8C 01 00 F7 26 2B 30 C5 02 90 01 C0 14 20 BC 17 7C 8B 01 B6 50 00 00 85 8C F7 FF E8 16 08 00 84 24 10 00 B7 A3 2A 20 F2 02 16 01 80 10 2A 20 57 02 20 BC 12 7C 10 00 B7 A3 05 00 40 10 00 40 64 30 03 00 64 30 2B 20 04 00 23 10 44 00 00 40 64 30 05 00 80 10 2A 28 E2 02 2A 20 42 02 23 10 52 00 0A 10 04 00 2A 28 E2 02 04 00 64 30 23 B8 57 00 DA 00 80 10 0A B8 05 00 02 00 62 30 52 01 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 28 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 65 30 89 00 E0 16 20 00 A5 AF FF FF 5E 26 ?? ?? 08 3C C0 90 1E 00 ?? ?? 08 25 03 00 02 24 21 90 12 01 41 00 64 2A 80 40 1E 00 20 00 63 30 02 F0 C2 73 40 10 16 00 1C 00 A2 AF 18 00 A4 AF ?? ?? ?? 0? 24 00 A3 AF 10 00 60 16 10 00 A4 83 00 00 46 8E 04 00 47 8E 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 28 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 28 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 80 02 ?? ?? ?? 0? 28 00 A8 AF 28 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 52 26 FC FF 08 25 FD FF DE 27 FD FF 02 24 8D 00 C2 13 40 00 02 24 6C 00 62 12 18 00 A5 8F DF FF A0 14 80 00 02 24 74 00 62 12 C0 00 02 24 DD FF 62 12 10 00 A4 83 ?? ?? ?? 0? 21 28 80 02 16 01 80 04 10 00 64 30 3D 00 80 10 60 00 A4 8F 60 00 A8 8F 21 B0 00 00 00 00 15 8D 04 00 08 25 ?? ?? ?? 0? 60 00 A8 AF 05 00 85 10 78 00 05 24 31 FF 85 14 10 00 B5 27 ?? ?? ?? 0? 80 00 63 34 ?? ?? ?? 0? C0 00 63 34 5C FF 85 10 69 00 05 24 5A FF 85 10 10 00 B5 27 ?? ?? ?? 0? 01 00 1E 24 60 00 A5 8F 10 00 66 30 01 00 A4 80 00 00 A7 8C 04 00 A5 24 40 00 C0 10 10 00 A4 A3 3F 00 80 50 14 00 A7 A3 FF FF 06 24 3C 00 86 50 14 00 A7 A3 14 00 A4 A3 15 00 A7 A3 02 00 1E 24 14 00 B5 27 ?? ?? ?? 0? 60 00 A5 AF 10 00 64 30 21 40 C0 00 0A 40 E4 00 25 18 03 01 FF FF 63 30 ?? ?? ?? 0? 00 00 24 82 60 00 A4 8F 00 00 85 8C 04 00 86 24 FF 00 A0 10 21 A8 A0 00 00 00 A4 80 06 00 80 10 21 F0 00 00 01 00 DE 27 21 20 BE 00 00 00 84 80 FD FF 80 54 01 00 DE 27 ?? ?? ?? 0? 60 00 A6 AF 21 B0 00 00 00 00 95 8C 04 00 84 24 ?? ?? ?? 0? 60 00 A4 AF 00 00 85 8C 04 00 84 24 60 00 A4 AF C3 27 05 00 21 A8 A0 00 ?? ?? ?? 0? 21 B0 80 00 F1 FE 85 14 10 00 B5 27 20 00 63 34 ?? ?? ?? 0? 80 00 63 34 30 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 2B 10 02 00 FF FF F7 26 21 80 02 02 F7 FF E0 16 28 00 A3 8F 08 00 66 30 ?? ?? ?? 0? 20 00 A6 AF 14 00 A7 A3 01 00 1E 24 14 00 B5 27 ?? ?? ?? 0? 60 00 A5 AF 1C 00 A6 8F 27 10 1E 00 06 20 D5 03 04 10 46 00 25 20 44 00 20 00 C3 33 06 10 D6 03 0B 20 43 00 07 00 84 30 30 00 84 24 ?? ?? ?? 0? 10 00 A4 A3 1C 00 A6 8F 27 18 08 00 06 10 15 01 04 18 66 00 25 10 62 00 06 28 16 01 20 00 06 31 ?? ?? 07 3C 0B 10 A6 00 24 00 A5 8F ?? ?? E3 24 ?? ?? 07 3C ?? ?? E4 24 0A 18 85 00 0F 00 42 30 21 18 62 00 00 00 64 80 ?? ?? ?? 0? 10 00 A4 A3 20 00 A7 8F 27 FE E0 50 00 00 24 82 25 FE E0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 80 02 27 10 02 00 2B 10 02 00 FF FF F7 26 F9 FF E0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 08 00 67 30 03 00 E0 12 20 00 A7 AF 11 00 E0 10 20 00 04 24 02 00 62 30 70 00 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 2B 10 02 00 21 80 02 02 ?? ?? ?? 0? 28 00 A3 8F 20 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 2B 10 02 00 FF FF F7 26 21 80 02 02 E8 FF E0 12 28 00 A3 8F 20 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 2B 10 02 00 FF FF F7 26 21 80 02 02 ED FF E0 16 28 00 A3 8F ?? ?? ?? 0? 02 00 62 30 ?? ?? ?? 0? 0B 90 E4 02 05 00 64 12 C0 00 04 24 CF FE 64 12 10 00 B7 83 ?? ?? ?? 0? 2A 20 F2 02 01 00 04 24 73 00 C0 12 10 00 A4 A3 02 00 17 24 02 00 0A 24 00 01 04 24 21 28 00 00 ?? ?? ?? 0? 10 00 0B 24 21 28 E0 00 21 50 E0 02 00 31 05 00 00 41 04 00 02 4F 04 00 25 48 26 01 21 30 00 01 2B 40 C5 02 01 00 4A 25 CC FE 00 15 21 38 20 01 58 00 C5 12 2B 20 A4 02 20 BC 0A 7C F1 FF EB 16 21 20 C0 00 ?? ?? ?? 0? 10 00 AB A3 01 00 04 24 5D 00 C0 12 10 00 A4 A3 40 00 04 24 21 28 00 00 C0 30 05 00 C0 40 04 00 02 00 17 24 42 4F 04 00 25 48 26 01 01 00 F7 26 21 30 00 01 2B 40 C5 02 02 00 0A 24 15 00 0B 24 20 BC 17 7C 11 00 00 15 21 38 20 01 12 00 C5 12 2B 20 A4 02 AF FE EB 12 21 20 C0 00 21 28 E0 00 C0 30 05 00 C0 40 04 00 42 4F 04 00 25 48 26 01 21 50 E0 02 21 30 00 01 01 00 F7 26 2B 40 C5 02 20 BC 17 7C F1 FF 00 11 21 38 20 01 10 00 AA A3 ?? ?? ?? 0? 21 B8 40 01 EE FF 80 10 00 00 00 00 10 00 AA A3 ?? ?? ?? 0? 21 B8 40 01 C1 FE 40 50 FF FF 5E 26 ?? ?? ?? 0? 20 00 04 24 BA FE 40 10 08 00 65 30 ?? ?? ?? 0? 20 00 04 24 60 00 A7 8F 01 00 31 26 00 00 24 82 00 00 F2 8C 04 00 E7 24 ?? ?? ?? 0? 60 00 A7 AF 60 00 A6 8F F8 FF 04 24 07 00 C5 24 24 20 A4 00 08 00 87 24 60 00 A7 AF 00 00 95 8C ?? ?? ?? 0? 04 00 96 8C F8 FF 04 24 07 00 E6 24 24 30 C4 00 00 00 C5 8C 04 00 C4 8C 08 00 C6 24 60 00 A6 AF 21 A8 A0 00 ?? ?? ?? 0? 21 B0 80 00 2B 28 A5 02 74 FE A0 10 00 00 00 00 10 00 A7 A3 ?? ?? ?? 0? 21 B8 E0 00 A9 FF 80 50 20 BC 0A 7C ?? ?? ?? 0? 10 00 B7 A3 ?? ?? 15 3C ?? ?? B5 26 ?? ?? ?? 0? 21 28 A0 02 10 00 A4 2E 8D FF 80 50 02 00 17 24 ?? ?? ?? 0? 01 00 17 24 08 00 A4 2E A3 FF 80 10 40 00 04 24 ?? ?? ?? 0? 01 00 17 24 0A 00 A4 2E 4F FE 80 10 ?? ?? 04 3C ?? ?? ?? 0? 01 00 17 24 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "_dsnprintf_cdfFgGnopsuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdfFgGnopsuxX"
		altNames = "_dsnprintf"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "_dsnprintf_cdeEfFgGnopsuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_696_0_0 {
	meta:
		name = "_dsnprintf_cdeEfFgGnopuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_797_0_0 {
	meta:
		name = "_dsnprintf_cdeEfFnopsuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_745_0_0 {
	meta:
		name = "_dsnprintf_cdeEfFnopuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "_dsnprintf_cdeEgGnopsuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "_dsnprintf_cdeEgGnopuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_709_0_0 {
	meta:
		name = "_dsnprintf_cdeEnopsuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "_dsnprintf_cdeEnopuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "_dsnprintf_cdfFgGnopuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "_dsnprintf_cdfFnopsuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_527_0_0 {
	meta:
		name = "_dsnprintf_cdfFnopuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "_dsnprintf_cdgGnopsuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_983_0_0 {
	meta:
		name = "_dsnprintf_cdgGnopuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "_dsnprintf_cdnopsuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_802_0_0 {
	meta:
		name = "_dsnprintf_cdnopuxX"
		size = 40
		refs = "0014 _dvsnprintf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "_dsnprintf_eE"
		size = 40
		refs = "0014 _dvsnprintf_eE"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "_dsnprintf_eEfF"
		size = 40
		refs = "0014 _dvsnprintf_eEfF"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_930_0_0 {
	meta:
		name = "_dsnprintf_eEfFgG"
		size = 40
		refs = "0014 _dvsnprintf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_718_0_0 {
	meta:
		name = "_dsnprintf_eEfFgGs"
		size = 40
		refs = "0014 _dvsnprintf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1167_0_0 {
	meta:
		name = "_dsnprintf_eEfFs"
		size = 40
		refs = "0014 _dvsnprintf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_782_0_0 {
	meta:
		name = "_dsnprintf_eEgG"
		size = 40
		refs = "0014 _dvsnprintf_eEgG"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "_dsnprintf_eEgGs"
		size = 40
		refs = "0014 _dvsnprintf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "_dsnprintf_eEs"
		size = 40
		refs = "0014 _dvsnprintf_eEs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_704_0_0 {
	meta:
		name = "_dsnprintf_fF"
		size = 40
		refs = "0014 _dvsnprintf_fF"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_801_0_0 {
	meta:
		name = "_dsnprintf_fFgG"
		size = 40
		refs = "0014 _dvsnprintf_fFgG"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "_dsnprintf_fFgGs"
		size = 40
		refs = "0014 _dvsnprintf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "_dsnprintf_fFs"
		size = 40
		refs = "0014 _dvsnprintf_fFs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "_dsnprintf_gG"
		size = 40
		refs = "0014 _dvsnprintf_gG"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "_dsnprintf_gGs"
		size = 40
		refs = "0014 _dvsnprintf_gGs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1049_0_0 {
	meta:
		name = "_dsnprintf_s"
		size = 40
		refs = "0014 _dvsnprintf_s"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1138_0_0 {
	meta:
		name = "_isnprintf"
		size = 40
		refs = "0014 _ivsnprintf"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1119_0_0 {
	meta:
		name = "_snprintf"
		size = 40
		refs = "0014 _vsnprintf"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "_snprintf_cdeEfFgGnopsuxX"
		size = 40
		refs = "0014 _vsnprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "_snprintf_cdeEfFgGnopuxX"
		size = 40
		refs = "0014 _vsnprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_698_0_0 {
	meta:
		name = "_snprintf_cdeEfFnopsuxX"
		size = 40
		refs = "0014 _vsnprintf_cdeEfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_snprintf_cdeEfFnopuxX"
		size = 40
		refs = "0014 _vsnprintf_cdeEfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1011_0_0 {
	meta:
		name = "_snprintf_cdeEgGnopsuxX"
		size = 40
		refs = "0014 _vsnprintf_cdeEgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "_snprintf_cdeEgGnopuxX"
		size = 40
		refs = "0014 _vsnprintf_cdeEgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_565_0_0 {
	meta:
		name = "_snprintf_cdeEnopsuxX"
		size = 40
		refs = "0014 _vsnprintf_cdeEnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "_snprintf_cdeEnopuxX"
		size = 40
		refs = "0014 _vsnprintf_cdeEnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_606_0_0 {
	meta:
		name = "_snprintf_cdfFgGnopsuxX"
		size = 40
		refs = "0014 _vsnprintf_cdfFgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_798_0_0 {
	meta:
		name = "_snprintf_cdfFgGnopuxX"
		size = 40
		refs = "0014 _vsnprintf_cdfFgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_575_0_0 {
	meta:
		name = "_snprintf_cdfFnopsuxX"
		size = 40
		refs = "0014 _vsnprintf_cdfFnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "_snprintf_cdfFnopuxX"
		size = 40
		refs = "0014 _vsnprintf_cdfFnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1087_0_0 {
	meta:
		name = "_snprintf_cdgGnopsuxX"
		size = 40
		refs = "0014 _vsnprintf_cdgGnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "_snprintf_cdgGnopuxX"
		size = 40
		refs = "0014 _vsnprintf_cdgGnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_628_0_0 {
	meta:
		name = "_snprintf_cdnopsuxX"
		size = 40
		refs = "0014 _vsnprintf_cdnopsuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_708_0_0 {
	meta:
		name = "_snprintf_cdnopuxX"
		size = 40
		refs = "0014 _vsnprintf_cdnopuxX"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "_snprintf_eE"
		size = 40
		refs = "0014 _vsnprintf_eE"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1133_0_0 {
	meta:
		name = "_snprintf_eEfF"
		size = 40
		refs = "0014 _vsnprintf_eEfF"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1076_0_0 {
	meta:
		name = "_snprintf_eEfFgG"
		size = 40
		refs = "0014 _vsnprintf_eEfFgG"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "_snprintf_eEfFgGs"
		size = 40
		refs = "0014 _vsnprintf_eEfFgGs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "_snprintf_eEfFs"
		size = 40
		refs = "0014 _vsnprintf_eEfFs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_422_0_0 {
	meta:
		name = "_snprintf_eEgG"
		size = 40
		refs = "0014 _vsnprintf_eEgG"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "_snprintf_eEgGs"
		size = 40
		refs = "0014 _vsnprintf_eEgGs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "_snprintf_eEs"
		size = 40
		refs = "0014 _vsnprintf_eEs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "_snprintf_fF"
		size = 40
		refs = "0014 _vsnprintf_fF"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_795_0_0 {
	meta:
		name = "_snprintf_fFgG"
		size = 40
		refs = "0014 _vsnprintf_fFgG"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "_snprintf_fFgGs"
		size = 40
		refs = "0014 _vsnprintf_fFgGs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "_snprintf_fFs"
		size = 40
		refs = "0014 _vsnprintf_fFs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1038_0_0 {
	meta:
		name = "_snprintf_gG"
		size = 40
		refs = "0014 _vsnprintf_gG"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "_snprintf_gGs"
		size = 40
		refs = "0014 _vsnprintf_gGs"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1207_0_0 {
	meta:
		name = "_snprintf_s"
		size = 40
		refs = "0014 _vsnprintf_s"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "snprintf"
		size = 40
		refs = "0014 vsnprintf"
	strings:
		$1 = { E0 FF BD 27 2C 00 A2 27 2C 00 A7 AF 21 38 40 00 1C 00 BF AF ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "atol"
		size = 160
		refs = "0034 _ctype"
	strings:
		$1 = { 20 00 02 24 09 00 05 24 00 00 83 90 FE FF 62 10 01 00 84 24 FD FF 65 50 00 00 83 90 2D 00 02 24 19 00 62 50 00 00 83 90 2B 00 02 24 19 00 62 10 21 40 00 00 ?? ?? 06 3C ?? ?? C6 24 21 10 C3 00 01 00 45 90 04 00 A5 30 0C 00 A0 10 21 10 00 00 0A 00 07 24 02 48 47 70 D0 FF 65 24 00 00 83 90 FF 00 A5 30 21 10 25 01 21 28 C3 00 01 00 A5 90 04 00 A5 30 F7 FF A0 14 01 00 84 24 23 18 02 00 08 00 E0 03 0B 10 68 00 01 00 08 24 ?? ?? ?? 0? 01 00 84 24 00 00 83 90 ?? ?? ?? 0? 01 00 84 24 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "scale"
		size = 472
		refs = "0030 _powers_ 00b4 dpmul 012c _npowers_"
	strings:
		$1 = { E0 FF BD 27 10 00 B0 AF 1C 00 BF AF 18 00 B2 AF 14 00 B1 AF 3B 00 80 04 21 80 80 00 6E 00 82 28 10 00 40 10 0B 00 82 28 5E 00 40 10 0A 00 02 24 ?? ?? 02 3C C0 80 04 00 ?? ?? 42 24 21 80 02 02 00 00 02 8E 04 00 04 8E 1C 00 BF 8F 21 18 80 00 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 64 00 02 24 1A 00 82 00 F4 01 40 00 ?? ?? 12 3C 0A 00 11 24 ?? ?? 52 26 10 10 00 00 12 18 00 00 1A 00 51 00 F4 01 20 02 12 00 63 24 C0 18 03 00 21 18 72 00 00 00 64 8C 04 00 65 8C 12 10 00 00 09 00 42 24 C0 10 02 00 21 10 52 00 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 1A 00 11 02 F4 01 20 02 21 20 40 00 21 28 60 00 10 80 00 00 C0 80 10 00 21 90 12 02 00 00 46 8E ?? ?? ?? 0? 04 00 47 8E 1C 00 BF 8F 21 20 60 00 21 18 80 00 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 23 80 04 00 6E 00 02 2A 1D 00 40 10 64 00 02 24 0B 00 02 2A 29 00 40 14 ?? ?? 02 3C 0A 00 02 24 1A 00 02 02 F4 01 40 00 ?? ?? 04 3C ?? ?? 82 24 10 80 00 00 12 18 00 00 09 00 63 24 C0 18 03 00 C0 80 10 00 21 80 02 02 21 18 62 00 00 00 64 8C 00 00 06 8E 04 00 07 8E ?? ?? ?? 0? 04 00 65 8C 1C 00 BF 8F 21 20 60 00 21 18 80 00 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 1A 00 02 02 F4 01 40 00 ?? ?? 12 3C 0A 00 11 24 ?? ?? 52 26 10 10 00 00 ?? ?? ?? 0? 12 18 00 00 1A 00 82 00 F4 01 40 00 ?? ?? 04 3C ?? ?? 82 24 10 80 00 00 ?? ?? ?? 0? 12 18 00 00 ?? ?? 42 24 C0 80 10 00 21 80 02 02 00 00 02 8E ?? ?? ?? 0? 04 00 04 8E }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "_dvfprintf_cdeEnopuxX"
		size = 6672
		refs = "009c _ctype 0164 fputc 0478 dpcmp 04fc dptoul 05c0 __udivdi3 05fc __umoddi3 0ab0 _npowers_ 0ad8 dpmul 0b70 dpadd 0bb4 __fixunsdfdi 0c3c dpdiv 0ff8 __floatunsidf 1010 dpsub 1294 __floatundidf 142c frexp"
		altNames = "_dvfprintf_cdeEnopsuxX"
	strings:
		$1 = { 98 FF BD 27 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 2C 00 A0 AF 30 00 A0 AF 21 80 00 00 00 00 24 82 68 00 80 10 10 00 A4 A3 25 00 02 24 53 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 47 02 46 10 FF FF 91 24 2E 00 45 28 3D 02 A0 10 00 00 00 00 4F 02 47 50 01 00 63 34 4B 02 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A4 24 21 28 82 00 01 00 A5 90 02 00 67 30 FE FF 66 30 0B 18 C7 00 08 00 67 30 FB FF 66 30 04 00 A5 30 43 02 A0 10 0B 18 C7 00 21 98 00 00 0A 00 06 24 02 28 66 72 01 00 31 26 21 98 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 73 26 2E 00 05 24 41 02 45 50 01 00 31 26 00 10 63 34 21 B8 00 00 ?? ?? 07 3C ?? ?? E6 24 10 00 08 24 00 80 07 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3D 00 A0 14 01 00 31 26 10 00 B5 27 01 00 1E 24 04 00 E0 12 2B 10 D3 03 2B 10 FE 02 0B F0 E2 02 2B 10 D3 03 08 00 76 30 23 98 7E 02 0B 00 C0 16 0A 98 02 00 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D4 57 00 00 A4 82 A5 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9A FF 80 14 10 00 A4 A3 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 80 20 04 00 21 20 C4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 63 34 80 00 63 34 00 07 62 30 B5 00 40 10 21 B0 60 00 00 10 65 30 06 00 04 24 10 00 62 30 87 01 40 10 0B B8 85 00 70 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 45 8C 04 00 54 8C 08 00 44 24 70 00 A4 AF 20 00 A5 AF 20 00 A6 8F 21 28 80 02 21 38 00 00 21 20 C0 00 21 30 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 76 34 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF DC 03 40 14 20 00 A3 8F 24 00 A0 AF 00 01 C2 32 6F 01 40 10 19 00 E2 2A 13 00 E2 2E AF 02 40 10 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 10 00 B7 A3 B1 02 40 14 10 00 A9 83 20 00 A2 8F 21 28 80 02 ?? ?? ?? 0? 21 20 40 00 21 A0 40 00 18 00 B5 8F ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF 73 26 03 00 C2 32 63 00 A3 26 2B 10 02 00 23 98 77 02 C7 00 63 2C 23 98 62 02 01 00 63 2C 04 00 C2 32 F3 02 40 10 23 98 63 02 02 00 C2 32 F5 04 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 60 1A 08 00 DE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 DE 32 10 00 A2 83 20 00 A6 8F 21 20 80 02 C0 10 02 00 21 10 C2 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 20 00 A7 8F 27 10 02 00 C0 18 03 00 21 18 E3 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A0 40 00 44 04 E0 16 21 A8 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 78 04 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 64 00 43 28 12 04 60 10 64 00 14 24 0A 00 14 24 1A 00 54 00 F4 01 80 02 21 28 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 64 FE C0 13 21 80 02 02 63 FE 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 63 34 00 01 63 34 00 07 62 30 4D FF 40 14 21 B0 60 00 C0 00 62 30 18 02 40 14 20 16 03 7C 4D 04 40 04 70 00 A7 8F 10 00 62 30 9D 02 40 10 70 00 A5 8F 70 00 A2 8F 00 00 44 8C 04 00 42 24 70 00 A2 AF C3 17 04 00 21 A8 80 00 21 B0 40 00 05 00 41 04 23 10 02 00 23 A8 04 00 2B 20 15 00 03 00 63 34 23 B0 44 00 03 00 E0 16 C0 00 74 30 25 B8 B6 02 01 00 F7 2E 40 00 02 24 72 03 82 12 41 00 82 2A 22 03 40 10 80 00 02 24 16 00 80 16 10 00 BE 83 01 00 02 24 9E 04 C0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 42 24 02 00 06 24 02 00 1E 24 ?? ?? ?? 0? 14 00 07 24 21 30 C0 03 04 00 44 8C 2B 28 C4 02 1B 03 A0 54 10 00 A6 A3 6F 04 96 50 00 00 44 8C 01 00 DE 27 20 F4 1E 7C F6 FF C7 17 08 00 42 24 10 00 BE A3 2A 10 D7 03 E8 02 40 10 2A 10 FE 02 20 F4 17 7C 10 00 BE A3 05 00 60 12 00 40 62 30 03 00 62 30 2B 10 02 00 23 98 62 02 00 40 62 30 05 00 40 10 2A 20 D3 03 2A 10 F3 02 23 98 77 02 0A 98 02 00 2A 20 D3 03 04 00 62 30 23 F0 7E 02 D8 02 40 10 0A F0 04 00 02 00 62 30 6E 03 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 64 30 0D 00 C0 13 24 00 A4 AF 21 98 60 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 08 00 65 32 21 18 60 02 24 00 A5 AF FF FF F7 26 ?? ?? 02 3C C0 98 17 00 ?? ?? 42 24 21 98 53 00 03 00 02 24 80 40 17 00 40 20 16 00 02 B8 E2 72 20 00 63 30 41 00 82 2A 28 00 BE AF 34 00 B1 AF 20 00 A3 AF 21 F0 80 00 ?? ?? ?? 0? 21 88 40 00 10 00 80 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 3C 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF F7 26 FD FF 02 24 7A 02 E2 12 40 00 02 24 6E 02 82 12 27 10 17 00 DF FF 20 16 80 00 02 24 58 02 82 12 C0 00 02 24 DD FF 82 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 C8 FD 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 BB FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 05 24 C7 FD 45 14 21 98 00 00 70 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D3 8C 2E 00 05 24 04 00 C6 24 C2 FD 45 14 70 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 05 24 1A 03 45 10 00 40 63 34 21 28 82 00 01 00 A5 90 21 B8 00 00 04 00 A5 30 B9 FD A0 10 0A 00 06 24 02 28 E6 72 01 00 31 26 21 B8 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF F7 26 ?? ?? ?? 0? ?? ?? 07 3C 70 00 A6 8F F8 FF 02 24 07 00 C4 24 24 10 82 00 00 00 47 8C 04 00 54 8C 08 00 42 24 20 00 A7 AF ?? ?? ?? 0? 70 00 A2 AF 40 00 40 10 24 00 A3 8F FF 00 F5 32 6E 00 A2 2E 79 03 40 14 0B 00 A2 2E EB 51 02 3C 1F 85 42 34 19 00 A2 02 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? 1E 3C ?? ?? DE 27 10 28 00 00 42 41 05 00 FF 00 02 31 12 00 42 24 C0 10 02 00 21 10 5E 00 00 00 44 8C 04 00 45 8C ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 64 00 04 24 CC CC 09 3C 02 28 04 71 CD CC 29 35 21 20 40 00 38 00 A9 AF 23 40 A5 02 FF 00 08 31 19 00 09 01 21 28 60 00 10 38 00 00 F8 07 E2 30 21 10 C2 03 48 00 46 8C ?? ?? ?? 0? 4C 00 47 8C 38 00 A9 8F 21 20 40 00 21 28 60 00 19 00 A9 02 0A 00 02 24 10 38 00 00 C2 18 07 00 02 30 62 70 23 10 A6 02 FF 00 42 30 C0 10 02 00 21 F0 5E 00 00 00 C6 8F ?? ?? ?? 0? 04 00 C7 8F 20 00 A8 8F 21 28 80 02 21 30 40 00 21 20 00 01 ?? ?? ?? 0? 21 38 60 00 20 00 A2 AF 21 A0 60 00 24 00 A3 8F 0A 00 62 28 14 00 40 10 30 00 A2 8F 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 B4 01 40 10 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 25 10 43 00 B2 01 40 14 21 A8 60 00 24 00 A4 8F 02 00 82 28 AE 01 40 14 30 00 A2 8F 2C 00 A3 8F 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 20 60 00 6A 01 41 04 24 00 A4 8F 24 00 A3 8F ED FF 68 24 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 3C 00 A8 AF 30 00 A3 AF 20 00 A6 8F 21 18 40 00 2C 00 A2 AF 30 00 A2 8F 21 20 C0 00 21 28 80 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 3C 00 A8 8F 21 F0 40 00 21 A8 60 00 20 00 A0 AF 28 00 A0 AF 01 00 02 24 55 03 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 05 24 02 00 07 24 ?? ?? ?? 0? 12 00 0A 24 21 38 A0 00 04 00 64 8C 2B 30 A4 02 81 02 C0 14 02 00 49 24 7C 02 95 50 00 00 64 8C 01 00 E5 24 01 00 42 24 20 2C 05 7C F5 FF 4A 14 08 00 63 24 10 00 A5 A3 14 00 09 24 23 A0 68 02 23 A0 97 02 2B 10 17 00 23 A0 89 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 43 02 40 10 23 A0 83 02 02 00 C2 32 DD 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 D6 32 24 00 B6 AF ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 73 26 C0 18 03 00 21 18 63 02 00 00 66 8C 04 00 67 8C 21 20 C0 03 ?? ?? ?? 0? 21 28 A0 02 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 E2 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 E2 2A 1B 02 40 14 20 14 17 7C 12 00 02 24 10 00 A2 A3 EE FF F7 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 21 28 60 00 28 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 FF FF 64 26 20 24 04 7C 21 A8 40 00 21 B0 60 00 27 00 60 12 10 00 A4 A3 ?? ?? 02 3C ?? ?? 42 24 21 98 20 02 20 00 A2 AF 21 88 40 00 C0 20 04 00 21 20 24 02 00 00 86 8C 04 00 87 8C 21 28 C0 02 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 BE 83 27 10 02 00 21 20 A0 02 C0 18 1E 00 21 18 23 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 C0 02 ?? ?? ?? 0? 21 80 02 02 FF FF C4 27 20 24 04 7C 21 A8 40 00 21 B0 60 00 E1 FF C0 17 10 00 A4 A3 21 88 60 02 0A 00 E0 12 24 00 A6 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF F7 26 F9 FF E0 16 21 80 02 02 24 00 A6 8F 46 FC C0 50 00 00 24 82 44 FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 24 02 40 04 10 00 62 30 82 00 40 10 70 00 A4 8F 70 00 A2 8F 21 B0 00 00 00 00 55 8C 04 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 12 00 02 24 21 28 80 02 21 20 60 00 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 10 00 A2 A3 53 FD 40 10 20 00 A2 8F 10 00 A9 83 24 00 A5 8F 38 00 A9 AF ?? ?? ?? 0? 23 20 A9 00 20 00 A6 8F 21 38 60 00 21 28 80 02 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 40 60 00 21 28 00 01 21 20 40 00 3C 00 A8 AF ?? ?? ?? 0? 21 F0 40 00 21 20 40 00 ?? ?? ?? 0? 21 A8 40 00 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "_vsnprintf_eEgG"
		size = 88
		refs = "003c _vfprintf_eEgG"
		altNames = "_vsnprintf _vsnprintf_eE _vsnprintf_eEgGs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_915_0_0 {
	meta:
		name = "_dvsnprintf"
		size = 88
		refs = "003c _dvfprintf"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_560_0_0 {
	meta:
		name = "_dvsnprintf_cdeEfFgGnopsuxX"
		size = 88
		refs = "003c _dvfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_608_0_0 {
	meta:
		name = "_dvsnprintf_cdeEfFgGnopuxX"
		size = 88
		refs = "003c _dvfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "_dvsnprintf_cdeEfFnopsuxX"
		size = 88
		refs = "003c _dvfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "_dvsnprintf_cdeEfFnopuxX"
		size = 88
		refs = "003c _dvfprintf_cdeEfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "_dvsnprintf_cdeEgGnopsuxX"
		size = 88
		refs = "003c _dvfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_366_0_0 {
	meta:
		name = "_dvsnprintf_cdeEgGnopuxX"
		size = 88
		refs = "003c _dvfprintf_cdeEgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "_dvsnprintf_cdeEnopsuxX"
		size = 88
		refs = "003c _dvfprintf_cdeEnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_499_0_0 {
	meta:
		name = "_dvsnprintf_cdeEnopuxX"
		size = 88
		refs = "003c _dvfprintf_cdeEnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_966_0_0 {
	meta:
		name = "_dvsnprintf_cdfFgGnopsuxX"
		size = 88
		refs = "003c _dvfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "_dvsnprintf_cdfFgGnopuxX"
		size = 88
		refs = "003c _dvfprintf_cdfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "_dvsnprintf_cdfFnopsuxX"
		size = 88
		refs = "003c _dvfprintf_cdfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1215_0_0 {
	meta:
		name = "_dvsnprintf_cdfFnopuxX"
		size = 88
		refs = "003c _dvfprintf_cdfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_518_0_0 {
	meta:
		name = "_dvsnprintf_cdgGnopsuxX"
		size = 88
		refs = "003c _dvfprintf_cdgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "_dvsnprintf_cdgGnopuxX"
		size = 88
		refs = "003c _dvfprintf_cdgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_545_0_0 {
	meta:
		name = "_dvsnprintf_cdnopsuxX"
		size = 88
		refs = "003c _dvfprintf_cdnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_679_0_0 {
	meta:
		name = "_dvsnprintf_cdnopuxX"
		size = 88
		refs = "003c _dvfprintf_cdnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_820_0_0 {
	meta:
		name = "_dvsnprintf_eE"
		size = 88
		refs = "003c _dvfprintf_eE"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_769_0_0 {
	meta:
		name = "_dvsnprintf_eEfF"
		size = 88
		refs = "003c _dvfprintf_eEfF"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "_dvsnprintf_eEfFgG"
		size = 88
		refs = "003c _dvfprintf_eEfFgG"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "_dvsnprintf_eEfFgGs"
		size = 88
		refs = "003c _dvfprintf_eEfFgGs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_468_0_0 {
	meta:
		name = "_dvsnprintf_eEfFs"
		size = 88
		refs = "003c _dvfprintf_eEfFs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "_dvsnprintf_eEgG"
		size = 88
		refs = "003c _dvfprintf_eEgG"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_630_0_0 {
	meta:
		name = "_dvsnprintf_eEgGs"
		size = 88
		refs = "003c _dvfprintf_eEgGs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1180_0_0 {
	meta:
		name = "_dvsnprintf_eEs"
		size = 88
		refs = "003c _dvfprintf_eEs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_938_0_0 {
	meta:
		name = "_dvsnprintf_fF"
		size = 88
		refs = "003c _dvfprintf_fF"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "_dvsnprintf_fFgG"
		size = 88
		refs = "003c _dvfprintf_fFgG"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "_dvsnprintf_fFgGs"
		size = 88
		refs = "003c _dvfprintf_fFgGs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "_dvsnprintf_fFs"
		size = 88
		refs = "003c _dvfprintf_fFs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "_dvsnprintf_gG"
		size = 88
		refs = "003c _dvfprintf_gG"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "_dvsnprintf_gGs"
		size = 88
		refs = "003c _dvfprintf_gGs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "_dvsnprintf_s"
		size = 88
		refs = "003c _dvfprintf_s"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_724_0_0 {
	meta:
		name = "_ivsnprintf"
		size = 88
		refs = "003c _ivfprintf"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_763_0_0 {
	meta:
		name = "_vsnprintf_cdeEfFgGnopsuxX"
		size = 88
		refs = "003c _vfprintf_cdeEfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_574_0_0 {
	meta:
		name = "_vsnprintf_cdeEfFgGnopuxX"
		size = 88
		refs = "003c _vfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "_vsnprintf_cdeEfFnopsuxX"
		size = 88
		refs = "003c _vfprintf_cdeEfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1188_0_0 {
	meta:
		name = "_vsnprintf_cdeEfFnopuxX"
		size = 88
		refs = "003c _vfprintf_cdeEfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "_vsnprintf_cdeEgGnopsuxX"
		size = 88
		refs = "003c _vfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_765_0_0 {
	meta:
		name = "_vsnprintf_cdeEgGnopuxX"
		size = 88
		refs = "003c _vfprintf_cdeEgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_893_0_0 {
	meta:
		name = "_vsnprintf_cdeEnopsuxX"
		size = 88
		refs = "003c _vfprintf_cdeEnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1001_0_0 {
	meta:
		name = "_vsnprintf_cdeEnopuxX"
		size = 88
		refs = "003c _vfprintf_cdeEnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_878_0_0 {
	meta:
		name = "_vsnprintf_cdfFgGnopsuxX"
		size = 88
		refs = "003c _vfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_760_0_0 {
	meta:
		name = "_vsnprintf_cdfFgGnopuxX"
		size = 88
		refs = "003c _vfprintf_cdfFgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1004_0_0 {
	meta:
		name = "_vsnprintf_cdfFnopsuxX"
		size = 88
		refs = "003c _vfprintf_cdfFnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_577_0_0 {
	meta:
		name = "_vsnprintf_cdfFnopuxX"
		size = 88
		refs = "003c _vfprintf_cdfFnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_944_0_0 {
	meta:
		name = "_vsnprintf_cdgGnopsuxX"
		size = 88
		refs = "003c _vfprintf_cdgGnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1141_0_0 {
	meta:
		name = "_vsnprintf_cdgGnopuxX"
		size = 88
		refs = "003c _vfprintf_cdgGnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "_vsnprintf_cdnopsuxX"
		size = 88
		refs = "003c _vfprintf_cdnopsuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1196_0_0 {
	meta:
		name = "_vsnprintf_cdnopuxX"
		size = 88
		refs = "003c _vfprintf_cdnopuxX"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "_vsnprintf_eEfF"
		size = 88
		refs = "003c _vfprintf_eEfF"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "_vsnprintf_eEfFgG"
		size = 88
		refs = "003c _vfprintf_eEfFgG"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "_vsnprintf_eEfFgGs"
		size = 88
		refs = "003c _vfprintf_eEfFgGs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1018_0_0 {
	meta:
		name = "_vsnprintf_eEfFs"
		size = 88
		refs = "003c _vfprintf_eEfFs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_647_0_0 {
	meta:
		name = "_vsnprintf_eEs"
		size = 88
		refs = "003c _vfprintf_eEs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_817_0_0 {
	meta:
		name = "_vsnprintf_fF"
		size = 88
		refs = "003c _vfprintf_fF"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_543_0_0 {
	meta:
		name = "_vsnprintf_fFgG"
		size = 88
		refs = "003c _vfprintf_fFgG"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_995_0_0 {
	meta:
		name = "_vsnprintf_fFgGs"
		size = 88
		refs = "003c _vfprintf_fFgGs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1112_0_0 {
	meta:
		name = "_vsnprintf_fFs"
		size = 88
		refs = "003c _vfprintf_fFs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "_vsnprintf_gG"
		size = 88
		refs = "003c _vfprintf_gG"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_711_0_0 {
	meta:
		name = "_vsnprintf_gGs"
		size = 88
		refs = "003c _vfprintf_gGs"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_522_0_0 {
	meta:
		name = "_vsnprintf_s"
		size = 88
		refs = "003c _vfprintf_s"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_862_0_0 {
	meta:
		name = "vsnprintf"
		size = 88
		refs = "003c vfprintf"
	strings:
		$1 = { D0 FF BD 27 02 00 A8 2C 2C 00 BF AF 21 18 80 00 0E 00 00 15 21 10 00 00 FF FF A2 24 20 00 A2 AF 21 28 C0 00 C2 00 02 24 10 00 A4 27 21 30 E0 00 10 00 A3 AF 18 00 A3 AF 14 00 A0 AF ?? ?? ?? 0? 1C 00 A2 A7 10 00 A3 8F 00 00 60 A0 2C 00 BF 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "strcasecmp"
		size = 104
		refs = "002c tolower"
	strings:
		$1 = { E0 FF BD 27 14 00 B1 AF 10 00 B0 AF 1C 00 BF AF 18 00 B2 AF 21 88 80 00 ?? ?? ?? 0? 21 80 A0 00 0C 00 40 10 21 10 40 02 00 00 24 92 ?? ?? ?? 0? 01 00 31 26 00 00 04 92 21 90 40 00 ?? ?? ?? 0? 01 00 10 26 23 90 42 02 F5 FF 40 12 1C 00 BF 8F 21 10 40 02 14 00 B1 8F 18 00 B2 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "strfmt"
		size = 256
	strings:
		$1 = { F8 FF BD 27 ?? ?? 02 3C ?? ?? 42 24 10 00 A3 27 10 00 A6 AF 14 00 A7 AF 00 00 A3 AF 25 00 0A 24 FC FF 4C 24 00 00 A3 80 08 00 60 50 00 00 80 A0 08 00 6A 10 01 00 A5 24 00 00 83 A0 00 00 A3 80 FB FF 60 14 01 00 84 24 00 00 80 A0 08 00 E0 03 08 00 BD 27 00 00 A7 80 D0 FF EB 24 0F 00 60 15 01 00 A5 24 00 00 A3 8F 00 00 66 8C 04 00 63 24 00 00 A3 AF 00 00 C3 80 EB FF 60 50 00 00 A3 80 00 00 83 A0 01 00 C6 24 00 00 C3 80 FC FF 60 14 01 00 84 24 ?? ?? ?? 0? 00 00 A3 80 00 00 A8 8F 80 18 0B 00 21 18 62 00 CF FF E7 24 00 00 63 8C 00 00 06 8D 80 38 07 00 04 00 08 25 00 00 A8 AF 21 38 47 00 21 40 80 00 1A 00 C3 00 F4 01 60 00 00 00 E3 8C FC FF E7 24 10 30 00 00 1A 00 C3 00 F4 01 60 00 12 48 00 00 30 00 29 25 00 00 09 A1 F7 FF EC 14 01 00 08 25 ?? ?? ?? 0? 21 20 8B 00 }
	condition:
		$1
}

rule file_63_1_0 {
	meta:
		name = "strftime"
		size = 1716
	strings:
		$1 = { A8 FF BD 27 4C 00 B7 AF 30 00 B0 AF FF FF A5 24 ?? ?? 17 3C ?? ?? 03 3C ?? ?? 10 3C 50 00 BE AF 48 00 B6 AF 44 00 B5 AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 34 00 B1 AF 54 00 BF AF 21 B0 80 00 21 A8 C0 00 21 F0 E0 00 21 A0 85 00 21 98 80 00 ?? ?? E2 26 ?? ?? 63 24 ?? ?? 12 3C ?? ?? 11 3C ?? ?? 10 26 00 00 A4 82 0B 00 80 50 00 00 60 A2 25 00 05 24 15 00 85 10 01 00 B5 26 7D 01 74 52 00 00 60 A2 00 00 64 A2 00 00 A4 82 F9 FF 80 14 01 00 73 26 00 00 60 A2 54 00 BF 8F 23 10 76 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 00 00 A4 82 DB FF 84 24 FF 00 84 30 55 00 85 2C 21 00 A0 14 01 00 B5 26 25 00 04 24 ?? ?? E4 A2 FF FF A4 82 FF FF A5 26 02 00 40 A0 0A A8 A4 00 01 00 44 A0 21 28 40 00 25 00 04 24 09 00 74 52 00 00 80 A2 00 00 64 A2 01 00 A5 24 00 00 A4 80 D1 FF 80 10 01 00 73 26 FB FF 74 56 00 00 64 A2 00 00 80 A2 54 00 BF 8F 21 10 00 00 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 80 20 04 00 21 20 64 00 00 00 84 8C 08 00 80 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 05 3C 25 00 04 24 ?? ?? ?? 0? ?? ?? A5 24 18 00 C5 8F ?? ?? 04 3C ?? ?? 84 24 80 28 05 00 21 20 A4 00 00 00 85 8C 00 00 A4 80 8A FF 80 14 00 00 00 00 ?? ?? ?? 0? 00 00 A4 82 10 00 C5 8F ?? ?? 04 3C ?? ?? 84 24 80 28 05 00 21 20 A4 00 00 00 85 8C 00 00 A4 80 7F FF 80 14 00 00 00 00 ?? ?? ?? 0? 00 00 A4 82 08 00 C6 8F ?? ?? 05 3C 21 20 40 00 ?? ?? A5 24 28 00 A2 AF ?? ?? ?? 0? 2C 00 A3 AF 28 00 A2 8F ?? ?? E4 82 2C 00 A3 8F 71 FF 80 14 21 28 40 00 ?? ?? ?? 0? 00 00 A4 82 08 00 C6 8F 0C 00 07 24 ?? ?? 05 3C 1A 00 C7 00 F4 01 E0 00 21 20 40 00 ?? ?? A5 24 10 30 00 00 ?? ?? ?? 0? 0A 30 E6 00 ?? ?? 05 3C 04 00 C6 8F 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C 00 00 C6 8F 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 1C 00 C6 8F 07 00 04 24 18 00 C7 8F 1A 00 C4 00 F4 01 80 00 ?? ?? 05 3C 21 20 40 00 ?? ?? A5 24 10 30 00 00 2A 30 E6 00 12 38 00 00 ?? ?? ?? 0? 21 30 C7 00 1C 00 C6 8F 07 00 07 24 18 00 C8 8F 1A 00 C7 00 F4 01 E0 00 ?? ?? 05 3C 06 00 08 25 21 20 40 00 ?? ?? A5 24 10 48 00 00 12 30 00 00 1A 00 07 01 F4 01 E0 00 10 38 00 00 2A 38 E9 00 ?? ?? ?? 0? 21 30 E6 00 00 00 C8 8F ?? ?? 05 3C 08 00 C6 8F 04 00 C7 8F 21 20 40 00 ?? ?? A5 24 10 00 A8 AF 28 00 A2 AF ?? ?? ?? 0? 2C 00 A3 AF 28 00 A2 8F ?? ?? E4 82 2C 00 A3 8F 2E FF 80 14 21 28 40 00 ?? ?? ?? 0? 00 00 A4 82 14 00 C6 8F 21 20 40 00 ?? ?? 25 26 ?? ?? ?? 0? 6C 07 C6 24 20 00 C4 8F F5 FE 80 50 00 00 A4 82 ?? ?? 44 26 04 00 85 8C 00 00 A4 80 1F FF 80 14 00 00 00 00 ?? ?? ?? 0? 00 00 A4 82 18 00 C4 8F 80 20 04 00 21 20 90 00 00 00 85 8C 00 00 A4 80 16 FF 80 14 00 00 00 00 ?? ?? ?? 0? 00 00 A4 82 10 00 C5 8F ?? ?? 04 3C ?? ?? 84 24 80 28 05 00 21 20 A4 00 00 00 85 8C 00 00 A4 80 0B FF 80 14 00 00 00 00 ?? ?? ?? 0? 00 00 A4 82 18 00 C5 8F 10 00 C6 8F ?? ?? 04 3C 80 28 05 00 80 30 06 00 ?? ?? 84 24 14 00 C8 8F 21 20 C4 00 21 28 B0 00 0C 00 CC 8F 08 00 CB 8F 04 00 CA 8F 00 00 C9 8F 00 00 A6 8C 00 00 87 8C ?? ?? 05 3C 21 20 40 00 6C 07 08 25 ?? ?? A5 24 28 00 A2 AF 2C 00 A3 AF 10 00 AC AF 14 00 AB AF 18 00 AA AF 1C 00 A9 AF ?? ?? ?? 0? 20 00 A8 AF 28 00 A2 8F ?? ?? E4 82 2C 00 A3 8F E9 FE 80 14 21 28 40 00 ?? ?? ?? 0? 00 00 A4 82 ?? ?? 05 3C 0C 00 C6 8F 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 1C 00 C6 8F ?? ?? 05 3C 21 20 40 00 ?? ?? A5 24 ?? ?? ?? 0? 01 00 C6 24 10 00 C6 8F ?? ?? 05 3C 21 20 40 00 ?? ?? A5 24 ?? ?? ?? 0? 01 00 C6 24 08 00 C4 8F 0C 00 84 28 33 00 80 54 ?? ?? 05 3C ?? ?? 05 3C 50 00 04 24 ?? ?? ?? 0? ?? ?? A5 24 ?? ?? 05 3C 18 00 C6 8F 21 20 40 00 ?? ?? ?? 0? ?? ?? A5 24 18 00 C5 8F 10 00 C6 8F 14 00 C8 8F 0C 00 C9 8F 80 28 05 00 ?? ?? 04 3C 80 30 06 00 21 28 B0 00 ?? ?? 84 24 21 20 C4 00 6C 07 08 25 00 00 A6 8C ?? ?? 05 3C 00 00 87 8C ?? ?? A5 24 21 20 40 00 10 00 A9 AF ?? ?? ?? 0? 14 00 A8 AF 14 00 C6 8F 64 00 04 24 ?? ?? 05 3C 1A 00 C4 00 F4 01 80 00 ?? ?? A5 24 21 20 40 00 ?? ?? ?? 0? 10 30 00 00 54 00 BF 8F 21 10 00 00 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 41 00 04 24 ?? ?? ?? 0? ?? ?? A5 24 }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "_vfscanf_cdnopuxX"
		size = 2180
		refs = "000c _ctype 00b0 atoi 0308 fgetc 05ec ungetc"
		altNames = "_dvfscanf_cdnopsuxX _dvfscanf_cdnopuxX _dvfscanf_s _ivfscanf _vfscanf _vfscanf_cdnopsuxX _vfscanf_s"
	strings:
		$1 = { B0 FF BD 27 40 00 B6 AF 38 00 B4 AF ?? ?? 16 3C ?? ?? 14 3C 3C 00 B5 AF 28 00 B0 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 34 00 B3 AF 30 00 B2 AF 2C 00 B1 AF ?? ?? D6 26 21 80 A0 00 58 00 A6 AF ?? ?? 84 AE 21 A8 00 00 18 00 A0 AF 00 00 11 92 C8 00 20 12 4C 00 BF 8F 21 10 D1 02 01 00 42 80 88 00 42 30 BD 00 40 14 01 00 10 26 25 00 02 24 A5 00 22 16 04 00 03 24 00 00 13 82 21 88 00 00 14 00 A3 AF 21 B8 00 00 04 00 1E 24 FF 00 73 32 79 00 62 2E 1C 00 40 14 01 00 12 26 21 10 D3 02 01 00 42 90 04 00 42 30 ED 01 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 00 00 53 82 ?? ?? 03 3C ?? ?? 63 24 20 8C 02 7C 21 10 63 02 01 00 42 90 04 00 42 30 ED FF 40 10 21 80 40 02 01 00 10 26 00 00 13 82 21 10 D3 02 01 00 42 90 04 00 42 30 FB FF 40 54 01 00 10 26 FF 00 73 32 79 00 62 2E E6 FF 40 10 01 00 12 26 ?? ?? 04 3C 80 10 13 00 ?? ?? 84 24 21 10 82 00 00 00 42 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0? ?? ?? 84 8E 4F FF 22 52 00 00 11 92 FF FF 03 24 4B 01 43 14 ?? ?? 03 3C 18 00 A3 8F 0B 10 63 00 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 ?? ?? ?? 0? 00 00 00 00 00 00 11 92 3C FF 20 16 21 10 D1 02 4C 00 BF 8F 18 00 A2 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 21 80 40 02 10 00 13 24 21 A8 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 84 8E ?? ?? ?? 0? 1C 00 A0 AF 21 90 40 00 2D 00 02 24 7A 00 42 12 ?? ?? 03 3C 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 21 30 A0 02 FF 00 03 24 80 00 43 10 ?? ?? 85 8E 30 00 02 24 E1 00 42 12 00 00 00 00 21 18 00 00 FF 00 1E 24 02 18 73 70 21 20 40 02 21 28 60 02 21 30 A0 02 FF FF 31 26 20 8C 11 7C ?? ?? ?? 0? 20 00 A3 AF 20 00 A3 8F 0B 00 20 12 21 18 43 00 ?? ?? 84 8E ?? ?? ?? 0? 20 00 A3 AF 21 20 40 00 21 28 60 02 21 30 A0 02 ?? ?? ?? 0? 21 90 40 00 EC FF 5E 14 20 00 A3 8F 21 20 40 02 21 28 60 02 21 30 A0 02 ?? ?? ?? 0? 20 00 A3 AF FF 00 04 24 E6 00 44 10 20 00 A3 8F 1C 00 A4 8F 23 10 03 00 F2 FE E0 16 0B 18 44 00 18 00 A4 8F 01 00 82 24 14 00 A4 8F FF 00 42 30 18 00 A2 AF 04 00 02 24 04 00 82 10 14 00 A4 8F 02 00 02 24 DC 00 82 10 58 00 A4 8F 58 00 A4 8F 00 00 82 8C 04 00 84 24 58 00 A4 AF ?? ?? ?? 0? 00 00 43 AC ?? ?? ?? 0? 00 00 00 00 A3 00 E0 12 58 00 A3 8F ?? ?? ?? 0? ?? ?? 84 8E FF FF 03 24 8E FF 43 10 01 00 43 24 1E 00 40 10 21 80 40 02 21 18 C3 02 00 00 63 80 88 00 63 30 17 00 60 50 00 00 43 82 ?? ?? ?? 0? 00 00 00 00 05 00 E0 16 FF FF 31 26 10 00 A4 8F 00 00 82 A0 01 00 84 24 10 00 A4 AF 20 8C 11 7C 7E 00 20 12 00 00 00 00 ?? ?? ?? 0? ?? ?? 84 8E 01 00 43 24 02 00 64 2C 78 00 80 14 21 18 C3 02 00 00 63 80 88 00 63 30 74 00 60 14 00 00 00 00 00 00 43 82 EB FF 62 14 01 00 50 26 B8 FE E0 56 00 00 11 92 18 00 A3 8F 10 00 A4 8F 01 00 62 24 FF 00 42 30 18 00 A2 AF ?? ?? ?? 0? 00 00 80 A0 ?? ?? ?? 0? 21 80 40 02 ?? ?? 84 8E ?? ?? ?? 0? 1C 00 A0 AF 21 90 40 00 2D 00 02 24 89 FF 42 16 08 00 13 24 ?? ?? 03 3C ?? ?? 64 8C 01 00 02 24 ?? ?? ?? 0? 1C 00 A2 AF 21 90 40 00 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 21 30 A0 02 FF 00 03 24 84 FF 43 14 30 00 02 24 ?? ?? 85 8E ?? ?? ?? 0? 21 20 40 02 18 00 A3 8F 6D 00 60 10 ?? ?? 02 3C 21 10 60 00 4C 00 BF 8F 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 02 00 02 24 00 00 53 82 21 80 40 02 ?? ?? ?? 0? 14 00 A2 AF 21 80 40 02 ?? ?? ?? 0? 0A 00 13 24 39 00 E0 12 18 00 A3 8F FF FF 10 24 ?? ?? ?? 0? ?? ?? 84 8E 75 00 50 10 18 00 A3 8F 05 00 E0 16 FF FF 31 26 10 00 A4 8F 00 00 82 A0 01 00 84 24 10 00 A4 AF 20 8C 11 7C F4 FF 20 1E 00 00 00 00 ?? ?? ?? 0? 21 80 40 02 21 80 40 02 10 00 13 24 ?? ?? ?? 0? 01 00 15 24 14 00 A4 8F 60 00 9E 10 08 00 02 24 00 00 53 82 21 80 40 02 ?? ?? ?? 0? 14 00 A2 AF 01 00 F7 26 FF 00 F7 32 00 00 53 82 ?? ?? ?? 0? 21 80 40 02 18 00 A3 8F C8 FF 60 14 21 10 60 00 ?? ?? 83 8E 4C 00 BF 8F FF FF 02 24 0C 00 63 94 48 00 BE 8F 44 00 B7 8F 10 00 63 30 0A 10 03 00 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 47 FE E0 16 21 80 40 02 ?? ?? ?? 0? 18 00 A3 8F 58 00 A4 8F 01 00 62 24 FF 00 42 30 00 00 84 8C 18 00 A2 AF 58 00 A2 8F 10 00 A4 AF 04 00 42 24 ?? ?? ?? 0? 58 00 A2 AF 58 00 A4 8F 00 00 63 8C 04 00 84 24 58 00 A4 AF ?? ?? ?? 0? 10 00 A3 AF ?? ?? ?? 0? ?? ?? 84 8E 78 00 03 24 1A 00 43 10 58 00 03 24 1A 00 43 14 ?? ?? 85 8E 18 00 A0 12 00 00 00 00 ?? ?? ?? 0? ?? ?? 84 8E ?? ?? ?? 0? 21 90 40 00 ?? ?? 43 8C 4C 00 BF 8F FF FF 02 24 0C 00 63 94 48 00 BE 8F 44 00 B7 8F 10 00 63 30 0A 10 03 00 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 EA FF A0 12 ?? ?? 85 8E ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 18 00 00 ?? ?? 85 8E ?? ?? ?? 0? 21 20 40 02 ?? ?? ?? 0? 20 00 A3 8F 00 00 82 8C 04 00 84 24 58 00 A4 AF ?? ?? ?? 0? 00 00 43 A4 00 00 53 82 ?? ?? ?? 0? 21 80 40 02 FF FF 02 24 ?? ?? ?? 0? 0B 10 63 00 ?? ?? 65 8C ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 18 00 A2 8F ?? ?? ?? 0? ?? ?? 84 8E 8A FF 62 12 FF FF 03 24 F6 FF 43 14 ?? ?? 03 3C 18 00 A4 8F ?? ?? ?? 0? 0B 10 84 00 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "_dvfprintf_fFs"
		size = 4288
		refs = "009c _ctype 01cc fputc 03e4 dpcmp 044c _npowers_ 0480 dpmul 0518 dpadd 055c __fixunsdfdi 0578 __floatundidf 0590 dpsub 06a0 __udivdi3 06b4 __umoddi3 0bec dpdiv 0e30 frexp"
		altNames = "_dvfprintf_fF"
	strings:
		$1 = { A0 FF BD 27 40 00 B2 AF 3C 00 B1 AF 38 00 B0 AF 5C 00 BF AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 21 90 80 00 21 88 A0 00 68 00 A6 AF 28 00 A0 AF 2C 00 A0 AF 21 80 00 00 00 00 24 82 40 00 80 10 10 00 A4 A3 25 00 02 24 8A 00 82 14 01 00 33 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 A8 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 7E 00 45 10 FF FF 71 24 2E 00 44 28 74 00 80 10 00 00 00 00 86 00 46 50 01 00 B5 36 82 00 48 50 02 00 B5 36 ?? ?? 04 3C ?? ?? 83 24 21 20 62 00 01 00 84 90 02 00 A6 32 FE FF A5 32 0B A8 A6 00 08 00 A6 32 FB FF A5 32 04 00 84 30 7A 00 80 10 0B A8 A6 00 21 F0 00 00 0A 00 05 24 02 20 C5 73 01 00 31 26 21 F0 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF DE 27 2E 00 04 24 78 00 44 50 01 00 31 26 00 10 B5 36 21 98 00 00 6C 00 03 24 10 00 05 24 00 80 04 24 10 00 A2 A3 94 00 43 10 01 00 31 26 6D 00 43 28 15 00 60 10 75 00 03 24 63 00 03 24 4E 02 43 10 66 00 03 24 94 00 43 50 00 04 B5 36 14 00 40 14 10 00 B4 27 5C 00 BF 8F 21 10 00 02 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 39 02 43 10 78 00 03 24 80 00 43 10 73 00 03 24 68 00 43 10 10 00 B4 27 01 00 17 24 04 00 60 52 2B 98 FE 02 2B 10 77 02 0B B8 62 02 2B 98 FE 02 23 F0 D7 03 0A F0 13 00 08 00 B6 32 0C 00 C0 16 21 98 C0 03 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 20 00 04 24 F8 FF 75 16 21 28 40 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 40 02 8A FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 20 00 04 24 F8 FF 74 16 21 28 40 02 ?? ?? ?? 0? 00 00 24 82 91 FF 47 14 ?? ?? 04 3C 04 00 B5 36 01 00 63 24 FF FF 62 80 84 FF 45 14 FF FF 71 24 08 00 B5 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 90 FF 44 14 21 F0 00 00 68 00 A5 8F 01 00 31 26 00 00 22 82 00 00 BE 8C 2E 00 04 24 04 00 A5 24 8B FF 44 14 68 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 86 02 44 10 00 40 B5 36 21 20 62 00 01 00 84 90 21 98 00 00 04 00 84 30 82 FF 80 10 0A 00 05 24 02 20 65 72 01 00 31 26 21 98 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 73 26 ?? ?? ?? 0? 6C 00 03 24 68 00 A7 8F 00 00 E3 8C 04 00 E4 24 4C 03 60 10 21 A0 60 00 00 00 62 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 77 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 68 00 A4 AF 10 00 A2 32 21 30 80 00 0A 30 A2 00 25 A8 D5 00 FF FF B5 32 ?? ?? ?? 0? 00 00 22 82 80 00 B5 36 00 07 A2 32 41 01 40 10 21 B8 A0 02 00 10 A4 32 06 00 03 24 10 00 A2 32 C3 01 40 14 0B 98 64 00 68 00 A7 8F F8 FF 02 24 07 00 E3 24 24 10 62 00 00 00 43 8C 04 00 54 8C 08 00 42 24 20 00 A3 AF 68 00 A2 AF 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 00 41 04 20 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 B7 36 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF 83 02 40 14 20 00 A3 8F 24 00 A0 AF 19 00 62 2A 40 00 40 10 24 00 A3 8F FF 00 75 32 6E 00 A2 2E AC 02 40 14 0B 00 A2 2E EB 51 02 3C 1F 85 42 34 19 00 A2 02 ?? ?? 16 3C ?? ?? D6 26 ?? ?? 05 3C ?? ?? A6 8C ?? ?? A7 8C 10 18 00 00 42 41 03 00 FF 00 02 31 12 00 42 24 C0 10 02 00 21 10 56 00 00 00 44 8C 04 00 45 8C ?? ?? ?? 0? 34 00 A8 AF 34 00 A8 8F 64 00 04 24 CC CC 09 3C 02 28 04 71 CD CC 29 35 21 20 40 00 34 00 A9 AF 23 40 A5 02 FF 00 08 31 19 00 09 01 21 28 60 00 10 38 00 00 F8 07 E2 30 21 10 C2 02 48 00 46 8C ?? ?? ?? 0? 4C 00 47 8C 34 00 A9 8F 21 20 40 00 21 28 60 00 19 00 A9 02 0A 00 02 24 10 38 00 00 C2 18 07 00 02 30 62 70 23 10 A6 02 FF 00 42 30 C0 10 02 00 21 B0 56 00 00 00 C6 8E ?? ?? ?? 0? 04 00 C7 8E 20 00 A8 8F 21 28 80 02 21 30 40 00 21 20 00 01 ?? ?? ?? 0? 21 38 60 00 20 00 A2 AF 21 A0 60 00 24 00 A3 8F 0A 00 62 28 96 01 40 10 2C 00 A2 8F 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 94 02 40 10 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 B0 40 00 25 10 43 00 83 01 40 10 21 A8 60 00 21 20 C0 02 ?? ?? ?? 0? 21 28 A0 02 20 00 A6 8F 21 28 80 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 20 00 A2 AF 24 00 A3 AF 18 00 A0 AF 21 40 00 00 01 00 02 24 B5 02 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 02 00 47 24 01 00 84 24 2B 30 A5 02 C5 01 C0 14 01 00 42 24 C0 01 B5 50 00 00 65 8C 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 A0 C8 03 23 A0 93 02 2B 10 13 00 23 A0 87 02 03 00 E3 32 23 A0 82 02 2B 18 03 00 04 00 E2 32 7D 01 40 10 23 A0 83 02 02 00 E2 32 57 02 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 1A 08 00 FE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 FE 32 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? B7 24 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 C0 02 21 28 A0 02 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 E6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 62 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 62 2A 56 01 40 14 20 14 13 7C 12 00 02 24 10 00 A2 A3 EE FF 73 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 21 28 60 00 24 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 27 00 A0 12 10 00 A2 A3 ?? ?? 06 3C ?? ?? D5 24 21 40 60 00 21 B8 C0 02 C0 10 02 00 21 10 A2 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 34 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B6 83 34 00 A8 8F 27 10 02 00 C0 18 16 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF C2 26 20 14 02 7C 21 40 60 00 DF FF C0 16 10 00 A2 A3 09 00 60 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 F8 FD C0 53 00 00 24 82 F6 FD 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 15 7C 89 01 40 04 10 00 A2 32 8D 00 40 10 68 00 A5 8F 68 00 A4 8F 21 B8 00 00 00 00 94 8C 04 00 84 24 68 00 A4 AF 03 00 60 16 C0 00 B6 32 25 98 97 02 01 00 73 2E 80 00 02 24 11 01 C2 12 C0 00 02 24 34 01 C2 12 10 00 A2 83 2A 18 53 00 CA 00 60 10 2A 18 62 02 20 14 13 7C 10 00 A2 A3 05 00 C0 13 00 40 A3 32 03 00 A3 32 2B 18 03 00 23 F0 C3 03 00 40 A3 32 05 00 60 10 2A 20 5E 00 2A 18 7E 02 23 F0 D3 03 0A F0 03 00 2A 20 5E 00 23 10 C2 03 0A 10 04 00 04 00 A3 32 DA 00 60 10 20 00 A2 AF 02 00 A2 32 8F 01 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A6 8F 0C 00 C0 50 08 00 B5 32 20 00 BE 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 20 00 BE AF 08 00 B5 32 24 00 B5 AF FF FF 68 26 C0 10 08 00 ?? ?? 04 3C 80 40 08 00 13 00 00 01 ?? ?? 95 24 40 18 17 00 21 40 60 02 30 00 B1 AF 21 A8 A2 02 80 00 1E 24 21 88 60 00 11 00 00 11 12 98 00 00 56 00 DE 12 FF FF 08 25 C0 00 05 24 44 00 C5 52 00 00 A6 8E 10 00 A4 83 21 28 40 02 ?? ?? ?? 0? 34 00 A8 AF 34 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F1 FF 00 15 FC FF 73 26 24 00 A7 8F 85 FD E0 10 30 00 B1 8F 20 00 A2 8F 82 FD 40 18 21 98 40 00 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 ?? ?? ?? 0? C0 00 B5 36 68 00 A3 8F 10 00 A5 32 01 00 62 80 00 00 64 8C 04 00 63 24 1B 00 A0 10 10 00 A2 A3 1A 00 40 50 14 00 A4 A3 FF FF 05 24 17 00 45 50 14 00 A4 A3 14 00 A2 A3 15 00 A4 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 68 00 A3 AF 68 00 A4 8F F8 FF 02 24 07 00 83 24 24 10 62 00 00 00 46 8C 08 00 45 24 68 00 A5 AF 20 00 A6 AF ?? ?? ?? 0? 04 00 54 8C 21 B8 00 00 00 00 B4 8C 04 00 A5 24 ?? ?? ?? 0? 68 00 A5 AF 14 00 A4 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 68 00 A3 AF 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 34 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 34 00 A8 8F 27 18 13 00 04 18 71 00 06 10 74 02 20 00 64 32 25 10 62 00 06 18 77 02 0B 10 64 00 ?? ?? 06 3C 0F 00 42 30 ?? ?? C6 24 21 10 C2 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 24 00 A4 8F 02 00 82 28 7B FE 40 14 2C 00 A2 8F 28 00 A3 8F 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 20 60 00 9B 00 41 04 24 00 A4 8F 24 00 A3 8F ED FF 68 24 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 34 00 A8 AF 2C 00 A3 AF 20 00 A6 8F 21 18 40 00 28 00 A2 AF 2C 00 A2 8F 21 20 C0 00 21 28 80 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 21 A8 60 00 20 00 A0 AF 24 00 A0 AF ?? ?? ?? 0? 34 00 A8 8F ?? ?? ?? 0? 0B 98 43 00 08 00 FE 32 0C 00 C0 17 02 00 E2 32 0A 00 80 1A 00 00 00 00 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 E2 32 C6 00 40 50 01 00 F7 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 10 00 A2 A3 AC FE 40 14 23 98 62 02 FF FF 02 24 ?? ?? ?? 0? 10 00 A2 A3 20 00 A7 8F C8 00 E0 14 08 00 A3 32 08 00 A2 32 24 00 A2 AF 02 00 A2 32 BF 00 40 50 01 00 B5 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 2B 28 C5 02 40 FE A0 50 20 24 04 7C ?? ?? ?? 0? 10 00 AA A3 68 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D3 8C 04 00 C6 24 ?? ?? ?? 0? 68 00 A6 AF 01 00 02 24 DC 00 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 19 04 00 02 00 02 24 02 47 04 00 25 40 06 01 01 00 42 24 21 30 60 00 2B 18 E5 02 02 00 09 24 10 00 0A 24 20 14 02 7C 11 00 60 14 21 38 00 01 B1 00 E5 52 2B 20 84 02 28 00 4A 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 19 04 00 02 47 04 00 25 40 06 01 21 48 40 00 21 30 60 00 01 00 42 24 2B 18 E5 02 20 14 02 7C F1 FF 60 10 21 38 00 01 10 00 A9 A3 ?? ?? ?? 0? 21 10 20 01 01 00 02 24 BC 00 E0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 02 00 02 24 02 00 05 24 ?? ?? ?? 0? 14 00 07 24 21 28 40 00 04 00 64 8C 2B 30 E4 02 0B 00 C0 14 01 00 A5 24 06 00 97 50 00 00 64 8C 20 14 05 7C F7 FF 47 14 08 00 63 24 ?? ?? ?? 0? 10 00 A7 A3 2B 20 84 02 FA FF 80 50 20 14 05 7C ?? ?? ?? 0? 10 00 A2 A3 EE FF 88 24 ?? ?? ?? 0? 18 00 A8 AF 21 28 80 02 18 00 A6 27 ?? ?? ?? 0? 21 20 60 00 18 00 A4 8F 03 00 03 24 0A 00 02 24 FF FF 84 24 02 18 83 70 1A 00 62 00 F4 01 40 00 12 20 00 00 00 00 82 28 23 20 82 00 24 00 A4 AF ?? ?? ?? 0? 23 20 04 00 21 28 60 00 20 00 A3 8F 21 20 40 00 21 38 80 02 ?? ?? ?? 0? 21 30 60 00 2C 00 A3 AF 28 00 A2 AF 21 18 40 00 2C 00 A2 8F 21 20 60 00 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 53 00 41 04 ?? ?? 02 3C 24 00 A3 8F FF FF 63 24 ?? ?? ?? 0? 24 00 A3 AF 68 00 A7 8F F8 FF 02 24 07 00 E3 24 24 10 62 00 08 00 43 24 68 00 A3 AF 00 00 54 8C ?? ?? ?? 0? 04 00 57 8C 55 00 40 54 ?? ?? 02 3C CC CC 02 3C CD CC 42 34 19 00 A2 02 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? 08 3C ?? ?? 08 25 34 00 A8 AF 10 28 00 00 C2 B0 05 00 FF 00 C2 32 09 00 42 24 C0 10 02 00 21 10 48 00 00 00 44 8C ?? ?? ?? 0? 04 00 45 8C 0A 00 04 24 02 28 C4 72 34 00 A8 8F 21 20 40 00 23 A8 A5 02 FF 00 B5 32 C0 A8 15 00 21 40 A8 02 00 00 06 8D 04 00 07 8D ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 20 00 A8 8F C7 FD E0 12 ?? ?? 05 3C ?? ?? ?? 0? 20 00 04 24 7C FE 40 10 20 00 A6 8F ?? ?? ?? 0? 20 00 04 24 B3 FD 40 10 20 00 04 24 ?? ?? ?? 0? 00 00 00 00 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 B0 40 00 ?? ?? ?? 0? 21 A8 60 00 7D FE A0 12 FF FF 68 26 ?? ?? ?? 0? 20 00 04 24 3A FF 60 14 24 00 A3 AF 20 00 BE 8F 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 ?? ?? ?? 0? 20 00 BE AF }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "strncasecmp"
		size = 136
		refs = "0044 tolower"
	strings:
		$1 = { D8 FF BD 27 20 00 B3 AF 24 00 BF AF 1C 00 B2 AF 18 00 B1 AF 14 00 B0 AF 13 00 C0 10 21 98 00 00 21 90 80 00 21 80 A0 00 ?? ?? ?? 0? 21 88 86 00 0E 00 40 10 24 00 BF 8F 0D 00 51 12 21 10 60 02 00 00 44 92 ?? ?? ?? 0? 01 00 52 26 00 00 04 92 21 98 40 00 ?? ?? ?? 0? 01 00 10 26 23 98 62 02 F3 FF 60 12 00 00 00 00 24 00 BF 8F 21 10 60 02 1C 00 B2 8F 20 00 B3 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "scale"
		size = 404
		refs = "0030 _powers_f 0094 fpmul 0100 _npowers_f"
	strings:
		$1 = { E0 FF BD 27 10 00 B0 AF 1C 00 BF AF 18 00 B2 AF 14 00 B1 AF 2F 00 80 04 21 80 80 00 6E 00 82 28 0E 00 40 10 0B 00 82 28 4E 00 40 10 0A 00 02 24 ?? ?? 02 3C ?? ?? 42 24 80 80 04 00 21 80 02 02 00 00 02 8E 1C 00 BF 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 64 00 02 24 1A 00 82 00 F4 01 40 00 ?? ?? 12 3C 0A 00 11 24 ?? ?? 52 26 10 10 00 00 1A 00 51 00 F4 01 20 02 4C 00 44 8E 12 10 00 00 09 00 42 24 80 10 02 00 21 10 52 00 ?? ?? ?? 0? 00 00 45 8C 1A 00 11 02 F4 01 20 02 21 20 40 00 10 80 00 00 80 80 10 00 21 90 12 02 ?? ?? ?? 0? 00 00 45 8E 1C 00 BF 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 23 80 04 00 20 84 10 7C 6E 00 02 2A 19 00 40 10 64 00 02 24 0B 00 02 2A 24 00 40 14 ?? ?? 02 3C 0A 00 02 24 1A 00 02 02 F4 01 40 00 ?? ?? 04 3C ?? ?? 82 24 10 80 00 00 12 18 00 00 09 00 63 24 80 18 03 00 80 80 10 00 21 80 02 02 21 18 62 00 00 00 05 8E ?? ?? ?? 0? 00 00 64 8C 1C 00 BF 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 1A 00 02 02 F4 01 40 00 ?? ?? 12 3C 0A 00 11 24 ?? ?? 52 26 ?? ?? ?? 0? 10 10 00 00 1A 00 82 00 F4 01 40 00 ?? ?? 04 3C ?? ?? 82 24 10 80 00 00 ?? ?? ?? 0? 12 18 00 00 ?? ?? 42 24 80 80 10 00 21 80 02 02 ?? ?? ?? 0? 00 00 02 8E }
	condition:
		$1
}

rule file_88_1_0 {
	meta:
		name = "_vfprintf_cdeEnopuxX"
		size = 6304
		refs = "000c _ctype 0160 fputc 046c __floatdisf 0484 fpcmp 04e8 fptoui 059c __udivdi3 05d8 __umoddi3 0a50 _npowers_f 0a7c fpmul 0b10 fpadd 0b8c fpdiv 0f08 __floatunsisf 0f18 fpsub 1188 __floatundisf 1358 frexpf"
		altNames = "_vfprintf_cdeEnopsuxX"
	strings:
		$1 = { 90 FF BD 27 68 00 BE AF 21 10 00 00 ?? ?? 1E 3C 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 64 00 B7 AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 21 90 80 00 21 88 A0 00 78 00 A6 AF 34 00 A2 AF 21 80 00 00 ?? ?? DE 27 00 00 24 82 68 00 80 10 10 00 A4 A3 25 00 02 24 3F 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 33 02 46 10 FF FF 91 24 2E 00 45 28 29 02 A0 10 00 00 00 00 3B 02 47 50 01 00 63 34 37 02 49 50 02 00 63 34 21 20 C2 03 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 31 02 80 10 0B 18 A6 00 21 A0 00 00 0A 00 05 24 02 20 85 72 01 00 31 26 21 A0 82 00 00 00 22 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 94 26 2E 00 04 24 2F 02 44 50 01 00 31 26 00 10 63 34 21 B8 00 00 10 00 07 24 00 80 06 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 41 00 A0 14 01 00 31 26 10 00 B3 27 01 00 06 24 04 00 E0 12 2B 10 D4 00 2B 10 E6 02 0B 30 E2 02 2B 10 D4 00 08 00 76 30 23 A0 86 02 0D 00 C0 16 0A A0 02 00 ?? ?? ?? 0? FF FF 15 24 21 28 40 02 ?? ?? ?? 0? 40 00 A6 AF 27 10 02 00 40 00 A6 8F 2B 10 02 00 21 80 02 02 FF FF 94 26 F7 FF 95 16 20 00 04 24 ?? ?? ?? 0? FF FF 15 24 21 28 40 02 ?? ?? ?? 0? 40 00 A6 AF 27 10 02 00 40 00 A6 8F 2B 10 02 00 01 00 73 26 21 80 02 02 FF FF C6 24 F6 FF D5 54 00 00 64 82 A5 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 93 16 20 00 04 24 00 00 24 82 9A FF 80 14 10 00 A4 A3 6C 00 BF 8F 21 10 00 02 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 ?? ?? 05 3C 80 20 04 00 ?? ?? A5 24 21 20 A4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 00 63 34 00 07 62 30 A9 00 40 10 21 B0 60 00 00 10 65 30 06 00 04 24 10 00 62 30 72 01 40 10 0B B8 85 00 78 00 AB 8F F8 FF 02 24 07 00 64 25 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 3C 00 A3 AF ?? ?? ?? 0? 78 00 A2 AF 3C 00 A3 8F 21 A8 40 00 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 3C 00 A3 AF 04 00 41 04 3C 00 A3 8F 00 80 02 3C 26 A8 55 00 03 00 76 34 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF A8 03 40 14 21 98 00 00 00 01 C2 32 59 01 40 10 19 00 E2 2A 13 00 E2 2E 7E 02 40 10 12 00 02 24 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 10 00 B7 A3 7E 02 40 14 10 00 A7 83 ?? ?? ?? 0? 21 20 A0 02 21 A8 40 00 ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF 93 26 03 00 C3 32 23 98 77 02 2B 18 03 00 04 00 C2 32 B1 02 40 10 23 98 63 02 02 00 C2 32 7A 04 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 C0 04 60 1A 08 00 CB 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 C2 32 28 00 A2 AF 10 00 A2 83 20 00 A7 8F 21 20 A0 02 C0 10 02 00 21 10 E2 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 20 00 A8 8F 27 10 02 00 C0 18 03 00 21 18 03 01 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A0 40 00 F5 03 E0 16 21 A8 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 2B 04 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 14 24 21 28 40 02 1A 00 54 00 F4 01 80 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 28 00 A2 8F 70 FE 40 50 00 00 24 82 6E FE 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 63 34 00 01 63 34 00 07 62 30 59 FF 40 14 21 B0 60 00 C0 00 62 30 EF 01 40 14 20 16 03 7C FF 03 40 04 78 00 A7 8F 10 00 62 30 5A 02 40 10 78 00 A9 8F 78 00 A8 8F 00 00 04 8D 04 00 08 25 78 00 A8 AF C3 17 04 00 21 98 80 00 21 B0 40 00 05 00 41 04 23 10 02 00 23 98 04 00 2B 20 13 00 03 00 63 34 23 B0 44 00 03 00 E0 16 C0 00 75 30 25 B8 76 02 01 00 F7 2E 40 00 02 24 56 03 A2 12 41 00 A2 2A FC 02 40 10 80 00 02 24 16 00 A0 16 10 00 A2 83 01 00 02 24 41 04 C0 12 10 00 A2 A3 ?? ?? 04 3C ?? ?? 84 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 08 24 21 38 40 00 04 00 85 8C 2B 30 C5 02 24 04 C0 54 10 00 A7 A3 1E 04 B6 50 00 00 85 8C 01 00 42 24 20 14 02 7C F6 FF 48 14 08 00 84 24 10 00 A2 A3 2A 20 57 00 B1 02 80 10 2A 20 E2 02 20 14 17 7C 10 00 A2 A3 05 00 80 12 00 40 64 30 03 00 64 30 2B 20 04 00 23 A0 84 02 00 40 64 30 05 00 80 10 2A 28 54 00 2A 20 F4 02 23 A0 97 02 0A A0 04 00 2A 28 54 00 23 10 82 02 0A 10 05 00 04 00 64 30 A0 02 80 10 24 00 A2 AF 02 00 62 30 4E 03 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 27 10 02 00 3C 00 A3 8F 2B 10 02 00 21 80 02 02 24 00 A7 8F 08 00 65 30 38 02 E0 14 30 00 A5 AF FF FF F7 26 03 00 02 24 ?? ?? 05 3C C0 A0 17 00 ?? ?? A5 24 80 40 17 00 41 00 A4 2A 02 B8 E2 72 20 00 63 30 40 10 16 00 21 A0 B4 00 28 00 A2 AF 20 00 A4 AF ?? ?? ?? 0? 2C 00 A3 AF 10 00 A0 16 10 00 A4 83 00 00 86 8E 04 00 87 8E 21 20 60 02 21 28 C0 02 ?? ?? ?? 0? 38 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 38 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 38 00 A8 AF 38 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 94 26 FC FF 08 25 FD FF F7 26 FD FF 02 24 4D 02 E2 12 40 00 02 24 3F 02 A2 12 20 00 A5 8F DF FF A0 14 80 00 02 24 28 02 A2 12 C0 00 02 24 DD FF A2 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 63 34 ?? ?? ?? 0? 80 00 63 34 DC FD 48 54 21 20 C2 03 04 00 63 34 01 00 84 24 FF FF 82 80 CF FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 D9 FD 44 14 21 A0 00 00 78 00 A5 8F 01 00 31 26 00 00 22 82 00 00 B4 8C 2E 00 04 24 04 00 A5 24 D4 FD 44 14 78 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 E7 02 44 10 00 40 63 34 21 20 C2 03 01 00 84 90 21 B8 00 00 04 00 84 30 CB FD 80 10 0A 00 05 24 02 20 E5 72 01 00 31 26 21 B8 82 00 00 00 22 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF F7 26 ?? ?? ?? 0? 10 00 07 24 78 00 A2 8F 00 00 55 8C 04 00 42 24 ?? ?? ?? 0? 78 00 A2 AF 3E 00 40 10 0A 00 62 2A FF 00 E3 32 6E 00 62 2C 41 03 40 14 0B 00 62 2C EB 51 02 3C 1F 85 42 34 19 00 62 00 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 06 3C ?? ?? C6 24 3C 00 A3 AF 40 00 A6 AF 10 48 00 00 42 39 09 00 FF 00 E2 30 12 00 42 24 80 10 02 00 21 10 46 00 00 00 44 8C ?? ?? ?? 0? 38 00 A7 AF 38 00 A7 8F 64 00 04 24 3C 00 A3 8F 02 28 E4 70 CC CC 08 3C CD CC 08 35 21 20 40 00 40 00 A6 8F 38 00 A8 AF 23 38 65 00 FF 00 E7 30 19 00 E8 00 10 58 00 00 C0 38 62 7D 09 00 42 24 80 10 02 00 21 10 46 00 ?? ?? ?? 0? 00 00 45 8C 3C 00 A3 8F 38 00 A8 8F 21 20 40 00 0A 00 02 24 19 00 68 00 40 00 A6 8F 10 48 00 00 C2 28 09 00 02 38 A2 70 23 10 67 00 FF 00 42 30 80 10 02 00 21 30 46 00 ?? ?? ?? 0? 00 00 C5 8C 21 20 A0 02 ?? ?? ?? 0? 21 28 40 00 21 A8 40 00 0A 00 62 2A 0D 00 40 10 ?? ?? 07 3C 21 20 A0 02 ?? ?? ?? 0? 21 28 00 00 90 01 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 A0 02 8F 01 40 54 21 20 40 00 02 00 63 2A 8B 01 60 14 ?? ?? 07 3C ?? ?? E7 24 34 00 A4 8F ?? ?? ?? 0? 00 00 E5 8C 43 01 41 04 EE FF 66 26 ED FF 66 26 18 00 A6 AF 20 24 06 7C ?? ?? ?? 0? 40 00 A6 AF 21 28 40 00 21 20 A0 02 ?? ?? ?? 0? 34 00 A2 AF ?? ?? ?? 0? 21 20 40 00 40 00 A6 8F 21 40 00 00 21 18 40 00 21 98 40 00 20 00 A8 AF 01 00 04 24 0A 00 62 2C 28 03 40 14 10 00 A4 A3 ?? ?? 04 3C ?? ?? 84 24 21 10 00 00 02 00 05 24 02 00 08 24 ?? ?? ?? 0? 12 00 09 24 21 40 A0 00 04 00 87 8C 6B 02 E0 14 02 00 4A 24 00 00 87 8C 2B 38 67 00 67 02 E0 14 01 00 42 24 01 00 05 25 20 2C 05 7C F5 FF 49 14 08 00 84 24 10 00 A5 A3 14 00 0A 24 23 A0 86 02 23 A0 97 02 2B 10 17 00 23 A0 8A 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 E4 01 40 10 23 A0 83 02 02 00 C2 32 BA 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 D6 32 24 00 B6 AF ?? ?? 0A 3C ?? ?? ?? 0? ?? ?? 55 25 C0 18 03 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 21 20 60 02 ?? ?? ?? 0? 21 28 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 E2 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 E2 2A FA 01 40 14 20 14 17 7C 12 00 02 24 10 00 A2 A3 EE FF F7 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 20 00 A5 8F 21 20 40 00 ?? ?? ?? 0? 21 B0 00 00 ?? ?? ?? 0? 21 20 40 00 21 A8 40 00 FF FF 62 26 20 14 02 7C 26 00 60 12 10 00 A2 A3 ?? ?? 0B 3C ?? ?? 6B 25 20 00 AB AF 20 00 A3 8F C0 10 02 00 21 20 A0 02 21 10 62 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B3 83 20 00 A4 8F 27 10 02 00 C0 18 13 00 21 18 83 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 C0 02 21 20 A0 02 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 FF FF 62 26 20 14 02 7C 21 B0 60 00 DF FF 60 16 10 00 A2 A3 0A 00 E0 12 24 00 A5 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF F7 26 F9 FF E0 16 21 80 02 02 24 00 A5 8F 7A FC A0 50 00 00 24 82 78 FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 00 02 40 04 10 00 62 30 68 00 40 10 78 00 A4 8F 78 00 A2 8F 21 B0 00 00 00 00 53 8C 04 00 42 24 ?? ?? ?? 0? 78 00 A2 AF 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 10 00 A2 A3 84 FD 40 10 10 00 A7 83 23 20 67 02 20 24 04 7C ?? ?? ?? 0? 38 00 A7 AF 21 28 40 00 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 ?? ?? ?? 0? 3C 00 A2 AF 21 20 40 00 ?? ?? ?? 0? 40 00 A2 AF 3C 00 A3 8F 21 28 40 00 ?? ?? ?? 0? 21 20 60 00 ?? ?? 05 3C ?? ?? A4 8C ?? ?? ?? 0? 21 28 40 00 3C 00 A3 8F 40 00 A6 8F 0B 00 40 1C 38 00 A7 8F ?? ?? 08 3C ?? ?? 05 8D ?? ?? ?? 0? 21 20 60 00 21 20 40 00 ?? ?? ?? 0? 3C 00 A2 AF 38 00 A7 8F 3C 00 A3 8F 21 30 40 00 01 00 E2 24 ?? ?? 09 3C ?? ?? 29 25 C0 10 02 00 21 10 22 01 04 00 44 8C 20 00 A9 AF 5F 01 80 14 21 A8 C0 00 00 00 42 8C 2B 10 C2 00 5C 01 40 14 20 00 AA 8F ?? ?? 02 3C ?? ?? 45 8C 01 00 73 26 21 20 60 00 ?? ?? ?? 0? 18 00 B3 AF ?? ?? ?? 0? 21 20 40 00 FB FF 93 26 03 00 C3 32 21 A8 40 00 23 98 77 02 2B 18 03 00 04 00 C2 32 51 FD 40 14 23 98 63 02 08 00 C3 32 0B 00 60 14 28 00 A3 AF 0A 00 60 1A 02 00 C2 32 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "strcat"
		size = 56
	strings:
		$1 = { 00 00 83 80 05 00 60 10 21 10 80 00 01 00 84 24 00 00 83 80 FE FF 60 54 01 00 84 24 00 00 A3 80 01 00 A5 24 00 00 83 A0 FC FF 60 14 01 00 84 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "_dvfprintf_eE"
		size = 5788
		refs = "009c _ctype 01a8 fputc 03d0 dpcmp 0450 dptoul 0510 __udivdi3 0548 __umoddi3 086c _npowers_ 0894 dpmul 08dc dpadd 0960 dpdiv 096c __fixunsdfdi 0de8 __floatunsidf 0e04 dpsub 1120 frexp 12a0 __floatundidf"
		altNames = "_dvfprintf_eEs"
	strings:
		$1 = { 98 FF BD 27 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 28 00 A0 AF 2C 00 A0 AF 21 80 00 00 00 00 24 82 40 00 80 10 10 00 A4 A3 25 00 02 24 54 00 82 14 01 00 33 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 A8 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 48 00 45 10 FF FF 71 24 2E 00 44 28 3E 00 80 10 00 00 00 00 50 00 46 50 01 00 B5 36 4C 00 48 50 02 00 B5 36 ?? ?? 04 3C ?? ?? 83 24 21 20 62 00 01 00 84 90 02 00 A6 32 FE FF A5 32 0B A8 A6 00 08 00 A6 32 FB FF A5 32 04 00 84 30 44 00 80 10 0B A8 A6 00 21 F0 00 00 0A 00 05 24 02 20 C5 73 01 00 31 26 21 F0 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF DE 27 2E 00 04 24 42 00 44 50 01 00 31 26 00 10 B5 36 21 98 00 00 6C 00 03 24 10 00 05 24 00 80 04 24 10 00 A2 A3 D7 02 43 10 01 00 31 26 6D 00 43 28 4C 00 60 10 75 00 03 24 63 00 03 24 D8 02 43 10 64 00 43 28 8C 00 60 50 65 00 03 24 EF 02 40 14 45 00 03 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C7 FF 47 14 ?? ?? 04 3C 04 00 B5 36 01 00 63 24 FF FF 62 80 BA FF 45 14 FF FF 71 24 08 00 B5 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 C6 FF 44 14 21 F0 00 00 70 00 A5 8F 01 00 31 26 00 00 22 82 00 00 BE 8C 2E 00 04 24 04 00 A5 24 C1 FF 44 14 70 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 BA 03 44 10 00 40 B5 36 21 20 62 00 01 00 84 90 21 98 00 00 04 00 84 30 B8 FF 80 10 0A 00 05 24 02 20 65 72 01 00 31 26 21 98 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 73 26 ?? ?? ?? 0? 6C 00 03 24 A2 02 43 10 78 00 03 24 9E 02 43 10 73 00 03 24 32 00 43 10 70 00 A7 8F 10 00 B4 27 01 00 17 24 04 00 60 52 2B 98 FE 02 2B 10 77 02 0B B8 62 02 2B 98 FE 02 23 F0 D7 03 0A F0 13 00 08 00 B6 32 0C 00 C0 16 21 98 C0 03 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 20 00 04 24 F8 FF 75 16 21 28 40 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 40 02 52 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 20 00 04 24 F8 FF 74 16 21 28 40 02 ?? ?? ?? 0? 00 00 24 82 00 00 E3 8C 04 00 E4 24 2D 04 60 10 21 A0 60 00 00 00 62 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 77 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A4 AF C1 FF 43 14 10 00 B4 27 00 01 B5 36 00 07 A2 32 AE 00 40 10 21 B0 A0 02 00 10 A4 32 06 00 03 24 10 00 A2 32 1C 01 40 10 0B 98 64 00 70 00 A4 8F F8 FF 02 24 07 00 83 24 24 10 62 00 00 00 46 8C 04 00 54 8C 08 00 45 24 70 00 A5 AF 20 00 A6 AF 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 00 41 04 20 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 B6 36 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF 44 03 40 14 20 00 A3 8F 24 00 A0 AF 00 01 C2 32 06 01 40 10 19 00 62 2A 13 00 62 2E 55 02 40 10 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 10 00 B3 A3 57 02 40 14 10 00 AA 83 20 00 A2 8F 21 28 80 02 ?? ?? ?? 0? 21 20 40 00 18 00 B4 8F ?? ?? 04 3C 21 B8 40 00 ?? ?? 95 24 63 00 83 26 FB FF DE 27 03 00 C2 32 2B 10 02 00 23 A0 D3 03 C7 00 63 2C 23 A0 82 02 01 00 63 2C 04 00 C2 32 9E 02 40 10 23 A0 83 02 02 00 C2 32 77 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 63 04 80 1A 08 00 C3 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 C4 32 20 00 A4 AF 10 00 A2 83 21 20 E0 02 21 28 00 00 C0 10 02 00 21 10 A2 02 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 21 20 E0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 E7 03 60 16 21 F0 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 13 04 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 64 00 43 28 C3 03 60 10 64 00 13 24 0A 00 13 24 1A 00 53 00 F4 01 60 02 21 28 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 73 00 F4 01 60 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A2 8F 90 FE 40 50 00 00 24 82 8E FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 15 7C E8 02 40 04 10 00 A2 32 A9 01 40 10 70 00 A5 8F 70 00 A4 8F 21 B8 00 00 00 00 94 8C 04 00 84 24 70 00 A4 AF 03 00 60 16 C0 00 B6 32 25 98 97 02 01 00 73 2E 80 00 02 24 85 02 C2 12 C0 00 02 24 6E 02 C2 12 10 00 A2 83 2A 18 53 00 69 02 60 10 2A 18 62 02 20 14 13 7C 10 00 A2 A3 05 00 C0 13 00 40 A3 32 03 00 A3 32 2B 18 03 00 23 F0 C3 03 00 40 A3 32 05 00 60 10 2A 20 5E 00 2A 18 7E 02 23 F0 D3 03 0A F0 03 00 2A 20 5E 00 23 10 C2 03 0A 10 04 00 04 00 A3 32 43 02 60 10 20 00 A2 AF 02 00 A2 32 C8 02 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A6 8F 0C 00 C0 50 08 00 B5 32 20 00 BE 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 20 00 BE AF 08 00 B5 32 24 00 B5 AF FF FF 68 26 C0 10 08 00 ?? ?? 04 3C 80 40 08 00 13 00 00 01 ?? ?? 95 24 40 18 17 00 21 40 60 02 30 00 B1 AF 21 A8 A2 02 80 00 1E 24 21 88 60 00 11 00 00 11 12 98 00 00 09 02 DE 12 FF FF 08 25 C0 00 05 24 F7 01 C5 52 00 00 A6 8E 10 00 A4 83 21 28 40 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F1 FF 00 15 FC FF 73 26 24 00 A7 8F 1D FE E0 10 30 00 B1 8F 20 00 A2 8F 1A FE 40 18 21 98 40 00 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A7 8F F8 FF 02 24 07 00 E3 24 24 10 62 00 00 00 43 8C 04 00 54 8C 08 00 42 24 20 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 2F 00 40 10 24 00 A3 8F FF 00 75 32 6E 00 A2 2E BA 02 40 10 EB 51 02 3C 0B 00 A2 2E 76 03 40 14 ?? ?? 02 3C CC CC 02 3C CD CC 42 34 19 00 A2 02 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? 08 3C ?? ?? 08 25 3C 00 A8 AF 10 28 00 00 C2 B8 05 00 FF 00 E2 32 09 00 42 24 C0 10 02 00 21 10 48 00 00 00 44 8C ?? ?? ?? 0? 04 00 45 8C 0A 00 04 24 02 28 E4 72 3C 00 A8 8F 21 20 40 00 23 A8 A5 02 FF 00 B5 32 C0 A8 15 00 21 40 A8 02 00 00 06 8D 04 00 07 8D ?? ?? ?? 0? 21 28 60 00 20 00 A8 8F 21 28 80 02 21 30 40 00 21 20 00 01 ?? ?? ?? 0? 21 38 60 00 20 00 A2 AF 21 A0 60 00 24 00 A3 8F 0A 00 62 28 0C 01 40 14 20 00 A3 8F 2C 00 A2 8F 28 00 A3 8F 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 20 60 00 4E 02 40 04 24 00 A3 8F 24 00 A4 8F EE FF 88 24 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 3C 00 A8 AF 2C 00 A3 AF 20 00 A6 8F 21 18 40 00 28 00 A2 AF 2C 00 A2 8F 21 20 C0 00 21 28 80 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 3C 00 A8 8F 21 B8 40 00 21 A8 60 00 20 00 A0 AF 24 00 A0 AF 01 00 02 24 34 03 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 02 00 47 24 01 00 84 24 2B 30 A5 02 B4 02 C0 14 01 00 42 24 AF 02 B5 50 00 00 65 8C 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 A0 C8 03 23 A0 93 02 2B 10 13 00 23 A0 87 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 7F 02 40 10 23 A0 83 02 02 00 C2 32 FC 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 1A 08 00 DE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 DE 32 ?? ?? 05 3C ?? ?? ?? 0? ?? ?? B6 24 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 E0 02 21 28 A0 02 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 C6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 62 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 62 2A 58 02 40 14 20 14 13 7C 12 00 02 24 10 00 A2 A3 EE FF 73 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 21 28 60 00 24 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 27 00 A0 12 10 00 A2 A3 ?? ?? 06 3C ?? ?? D5 24 21 40 60 00 21 B8 C0 02 C0 10 02 00 21 10 A2 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B6 83 3C 00 A8 8F 27 10 02 00 C0 18 16 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF C2 26 20 14 02 7C 21 40 60 00 DF FF C0 16 10 00 A2 A3 09 00 60 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 00 FD C0 53 00 00 24 82 FE FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 10 00 A2 32 21 30 80 00 0A 30 A2 00 25 A8 D5 00 FF FF B5 32 ?? ?? ?? 0? 00 00 22 82 70 00 A3 8F 10 00 A5 32 01 00 62 80 00 00 64 8C 04 00 63 24 19 00 A0 10 10 00 A2 A3 18 00 40 50 14 00 A4 A3 FF FF 05 24 15 00 45 50 14 00 A4 A3 14 00 A2 A3 15 00 A4 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF ?? ?? ?? 0? 80 00 B5 36 ?? ?? ?? 0? C0 00 B5 36 21 B8 00 00 00 00 B4 8C 04 00 A5 24 ?? ?? ?? 0? 70 00 A5 AF 5C FD 43 14 10 00 B4 27 ?? ?? ?? 0? 20 00 B5 36 14 00 A4 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 52 01 40 10 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 B8 40 00 25 10 43 00 50 01 40 14 21 A8 60 00 24 00 A4 8F 02 00 82 28 E5 FE 40 10 2C 00 A2 8F ?? ?? ?? 0? 21 20 E0 02 12 00 02 24 21 28 80 02 21 20 60 00 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 10 00 A2 A3 AD FD 40 10 20 00 A2 8F 10 00 AA 83 24 00 A5 8F 38 00 AA AF ?? ?? ?? 0? 23 20 AA 00 20 00 A6 8F 21 38 60 00 21 28 80 02 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 48 60 00 21 40 40 00 21 28 20 01 21 20 40 00 3C 00 A8 AF ?? ?? ?? 0? 34 00 A9 AF 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 3C 00 A8 8F 34 00 A9 8F 21 30 40 00 21 20 00 01 21 28 20 01 ?? ?? ?? 0? 21 38 60 00 ?? ?? 06 3C ?? ?? C4 8C ?? ?? C5 8C 21 38 60 00 ?? ?? ?? 0? 21 30 40 00 3C 00 A8 8F 34 00 A9 8F 12 00 40 1C 38 00 AA 8F ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 01 ?? ?? ?? 0? 21 28 20 01 21 48 60 00 21 40 40 00 21 28 20 01 21 20 40 00 3C 00 A8 AF ?? ?? ?? 0? 34 00 A9 AF 38 00 AA 8F 34 00 A9 8F 3C 00 A8 8F 21 A0 40 00 ?? ?? 03 3C 01 00 42 25 ?? ?? 75 24 C0 10 02 00 21 10 A2 02 04 00 43 8C 14 01 60 14 21 B8 80 02 00 00 42 8C 2B 10 82 02 11 01 40 14 C0 50 0A 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 24 00 A2 8F 21 20 00 01 21 28 20 01 01 00 54 24 ?? ?? ?? 0? 18 00 B4 AF 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 B8 40 00 63 00 83 26 FB FF DE 27 03 00 C2 32 2B 10 02 00 23 A0 D3 03 C7 00 63 2C 23 A0 82 02 01 00 63 2C 04 00 C2 32 64 FD 40 14 23 A0 83 02 08 00 C5 32 0B 00 A0 14 20 00 A5 AF 0A 00 80 1A 02 00 C2 32 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 C2 32 E4 00 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 3C 00 A8 8F 27 18 13 00 04 18 71 00 06 10 74 02 20 00 64 32 25 10 62 00 06 18 77 02 0B 10 64 00 ?? ?? 06 3C 0F 00 42 30 ?? ?? C6 24 21 10 C2 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 20 00 A7 8F 8E 00 E0 14 08 00 A3 32 08 00 A2 32 24 00 A2 AF 02 00 A2 32 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "strstr"
		size = 156
		refs = "0030 strchr 004c strlen 005c strncmp"
	strings:
		$1 = { E0 FF BD 27 18 00 B1 AF 14 00 B0 AF 1C 00 BF AF 21 88 80 00 15 00 80 10 21 80 A0 00 00 00 82 80 0A 00 40 14 1C 00 BF 8F ?? ?? ?? 0? 21 88 00 00 ?? ?? ?? 0? 00 00 05 82 0C 00 40 10 21 88 40 00 00 00 42 80 0F 00 40 10 1C 00 BF 8F ?? ?? ?? 0? 21 20 00 02 21 30 40 00 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 F2 FF 40 14 01 00 24 26 1C 00 BF 8F 21 10 20 02 14 00 B0 8F 18 00 B1 8F 08 00 E0 03 20 00 BD 27 21 88 00 00 21 10 20 02 14 00 B0 8F 18 00 B1 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "fround"
		size = 380
		refs = "002c _npowers_f 0044 fpmul"
	strings:
		$1 = { D8 FF BD 27 6E 00 82 2C 14 00 B0 AF 24 00 BF AF 20 00 B3 AF 1C 00 B2 AF 18 00 B1 AF 31 00 40 10 21 80 80 00 0B 00 82 2C 0F 00 40 10 ?? ?? 02 3C 80 80 04 00 ?? ?? 42 24 21 80 02 02 ?? ?? 02 3C 00 00 04 8E ?? ?? ?? 0? ?? ?? 45 8C 24 00 BF 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 CC CC 02 3C CD CC 42 34 19 00 82 00 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 11 3C ?? ?? 31 26 10 38 00 00 C2 90 07 00 FF 00 42 32 09 00 42 24 80 10 02 00 21 10 51 00 ?? ?? ?? 0? 00 00 44 8C 0A 00 03 24 02 20 43 72 23 80 04 02 21 20 40 00 FF 00 10 32 80 80 10 00 21 88 11 02 ?? ?? ?? 0? 00 00 25 8E 24 00 BF 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 EB 51 02 3C 1F 85 42 34 19 00 82 00 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 11 3C ?? ?? 31 26 10 18 00 00 42 91 03 00 FF 00 42 32 12 00 42 24 80 10 02 00 21 10 51 00 ?? ?? ?? 0? 00 00 44 8C 64 00 03 24 02 20 43 72 CC CC 12 3C CD CC 52 36 23 18 04 02 FF 00 63 30 19 00 72 00 21 20 40 00 10 38 00 00 C0 38 E2 7C 09 00 42 24 80 10 02 00 21 10 51 00 ?? ?? ?? 0? 00 00 45 8C 19 00 12 02 21 20 40 00 0A 00 02 24 10 98 00 00 C2 18 13 00 02 28 62 70 ?? ?? ?? 0? 23 80 05 02 }
	condition:
		$1
}

rule file_129_2_0 {
	meta:
		name = "_vfprintf_gG"
		size = 5592
		refs = "000c _ctype 01a8 fputc 03bc __floatdisf 03d4 fpcmp 0434 fpadd 0488 fpdiv 0490 fptoui 063c fpmul 0680 __udivdi3 0694 __umoddi3 0bb4 __floatundisf 0bc0 fpsub 0f00 frexpf 1214 __floatunsisf"
		altNames = "_vfprintf_gGs"
	strings:
		$1 = { 98 FF BD 27 60 00 BE AF 21 10 00 00 ?? ?? 1E 3C 4C 00 B3 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 21 98 80 00 21 88 A0 00 70 00 A6 AF 2C 00 A2 AF 21 80 00 00 ?? ?? DE 27 00 00 24 82 3E 00 80 10 10 00 A4 A3 25 00 02 24 52 00 82 14 01 00 32 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 46 00 46 10 FF FF 91 24 2E 00 45 28 3C 00 A0 10 00 00 00 00 4E 00 47 50 01 00 63 34 4A 00 49 50 02 00 63 34 21 20 C2 03 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 44 00 80 10 0B 18 A6 00 21 A8 00 00 0A 00 05 24 02 20 A5 72 01 00 31 26 21 A8 82 00 00 00 22 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF B5 26 2E 00 04 24 42 00 44 50 01 00 31 26 00 10 63 34 21 90 00 00 6C 00 04 24 10 00 06 24 00 80 05 24 10 00 A2 A3 33 02 44 10 01 00 31 26 6D 00 44 28 4C 00 80 10 75 00 04 24 63 00 04 24 34 02 44 10 64 00 44 28 8C 00 80 50 67 00 04 24 72 02 40 14 47 00 04 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C9 FF 48 54 21 20 C2 03 04 00 63 34 01 00 84 24 FF FF 82 80 BC FF 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 C6 FF 44 14 21 A8 00 00 70 00 A5 8F 01 00 31 26 00 00 22 82 00 00 B5 8C 2E 00 04 24 04 00 A5 24 C1 FF 44 14 70 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 00 03 44 10 00 40 63 34 21 20 C2 03 01 00 84 90 21 90 00 00 04 00 84 30 B8 FF 80 10 0A 00 05 24 02 20 45 72 01 00 31 26 21 90 82 00 00 00 22 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 52 26 ?? ?? ?? 0? 6C 00 04 24 FE 01 44 10 78 00 04 24 FA 01 44 10 73 00 04 24 32 00 44 10 70 00 A2 8F 10 00 B4 27 01 00 17 24 04 00 40 52 2B 90 F5 02 2B 10 57 02 0B B8 42 02 2B 90 F5 02 23 A8 B7 02 0A A8 12 00 08 00 76 30 0C 00 C0 16 21 90 A0 02 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 55 16 21 28 60 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 60 02 54 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 00 00 44 8C 04 00 45 24 2C 04 80 10 21 A0 80 00 00 00 82 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 97 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A5 AF C1 FF 44 14 10 00 B4 27 00 02 63 34 00 07 62 30 F5 00 40 10 20 00 A3 AF 00 10 65 30 06 00 04 24 10 00 62 30 90 01 40 10 0B 90 85 00 70 00 A5 8F F8 FF 02 24 07 00 A4 24 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 38 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 38 00 A3 8F 21 A0 40 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 05 00 41 04 38 00 A3 8F 00 80 02 3C 03 00 63 34 26 A0 54 00 20 00 A3 AF 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF BD 02 40 14 21 B8 00 00 20 00 A3 8F 00 02 62 30 38 01 40 14 FC FF E2 2A 19 00 42 2A 08 00 40 10 18 00 B6 8F ?? ?? ?? 0? FF 00 44 32 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 A0 40 00 18 00 B6 8F 0A 00 C2 2A A4 01 40 14 21 20 80 02 ?? ?? 03 3C ?? ?? 63 24 2C 00 A4 8F ?? ?? ?? 0? 00 00 65 8C 98 03 41 04 EE FF C3 26 ED FF C3 26 18 00 A3 AF 20 24 03 7C ?? ?? ?? 0? 38 00 A3 AF 21 28 40 00 21 20 80 02 ?? ?? ?? 0? 2C 00 A2 AF ?? ?? ?? 0? 21 20 40 00 38 00 A3 8F 21 B8 40 00 21 A0 40 00 21 B0 00 00 01 00 04 24 0A 00 E2 2E 3A 04 40 14 10 00 A4 A3 ?? ?? 04 3C ?? ?? 86 24 21 10 00 00 02 00 09 24 02 00 04 24 12 00 08 24 04 00 C5 8C 02 00 47 24 01 00 84 24 AA 02 A0 14 01 00 42 24 00 00 C5 8C 20 24 04 7C 2B 28 E5 02 A5 02 A0 14 08 00 C6 24 F5 FF 48 54 21 48 80 00 10 00 A4 A3 14 00 07 24 20 00 A4 8F 23 A8 A3 02 23 A8 B2 02 2B 10 12 00 23 A8 A7 02 03 00 83 30 23 A8 A2 02 2B 18 03 00 04 00 82 30 40 02 40 10 23 A8 A3 02 02 00 82 30 76 03 40 10 20 00 A5 8F 01 00 84 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 09 04 A0 1A 20 00 A7 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 20 00 A2 8F ?? ?? 07 3C ?? ?? E7 24 08 00 42 30 24 00 A2 AF 10 00 A2 83 21 20 80 02 21 28 00 00 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 E6 00 33 02 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A 80 03 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 28 C0 02 ?? ?? ?? 0? 21 20 40 00 21 B8 40 00 FF FF 82 26 20 14 02 7C 21 B0 00 00 25 00 80 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 C0 10 02 00 21 10 62 00 00 00 46 8C 04 00 47 8C 21 20 E0 02 ?? ?? ?? 0? 21 28 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B4 83 ?? ?? 04 3C ?? ?? 84 24 C0 18 14 00 21 18 83 00 00 00 66 8C 04 00 67 8C 27 10 02 00 2B 10 02 00 21 28 C0 02 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF 82 26 20 14 02 7C 21 B0 60 00 DD FF 80 16 10 00 A2 A3 0A 00 40 12 24 00 A5 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 24 00 A5 8F 4B FE A0 50 00 00 24 82 49 FE A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 03 7C 0C 02 40 04 10 00 62 30 BE 00 40 10 70 00 A7 8F 70 00 A5 8F 21 B8 00 00 00 00 B4 8C 04 00 A5 24 70 00 A5 AF 03 00 40 16 C0 00 76 30 25 90 97 02 01 00 52 2E 80 00 02 24 7A 01 C2 12 C0 00 02 24 63 01 C2 12 10 00 A2 83 2A 20 52 00 5E 01 80 10 2A 20 42 02 20 14 12 7C 10 00 A2 A3 05 00 A0 12 00 40 64 30 03 00 64 30 2B 20 04 00 23 A8 A4 02 00 40 64 30 05 00 80 10 2A 28 55 00 2A 20 55 02 23 A8 B2 02 0A A8 04 00 2A 28 55 00 23 10 A2 02 0A 10 05 00 04 00 64 30 3A 01 80 10 20 00 A2 AF 02 00 62 30 EC 01 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 60 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 20 00 A2 8F 8F 00 40 14 30 00 04 24 08 00 63 30 28 00 A3 AF FF FF 48 26 ?? ?? 05 3C C0 A8 08 00 ?? ?? A5 24 40 38 17 00 21 A8 B5 00 80 40 08 00 12 00 40 12 24 00 A7 AF 80 00 02 24 0C 01 C2 12 FF FF 52 26 C0 00 03 24 FA 00 C3 52 00 00 A6 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 34 00 A8 AF 34 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F0 FF 40 16 FC FF 08 25 28 00 A7 8F E6 FD E0 50 00 00 24 82 20 00 A2 8F E3 FD 40 58 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 20 00 A3 AF F7 FF 60 14 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 8E 00 40 10 2A 10 F2 02 6F 02 40 12 21 10 00 00 FF FF 52 26 13 00 42 2E 6A 02 40 14 12 00 02 24 10 00 A2 A3 21 20 80 02 ?? ?? ?? 0? 21 28 00 00 2E 02 40 14 10 00 A6 83 ?? ?? ?? 0? 21 20 80 02 ?? ?? 04 3C ?? ?? 84 24 21 B0 40 00 24 00 A4 AF 20 00 A2 8F FB FF B4 26 23 A0 92 02 03 00 43 30 2B 18 03 00 04 00 42 30 B8 01 40 10 23 A0 83 02 20 00 A3 8F 02 00 62 30 9B 02 40 10 20 00 A4 8F 01 00 64 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 00 03 80 1A 20 00 A5 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A7 8F 08 00 E7 30 ?? ?? ?? 0? 28 00 A7 AF 70 00 A7 8F 00 00 F4 8C 04 00 E7 24 ?? ?? ?? 0? 70 00 A7 AF 10 00 62 30 21 38 A0 00 0A 38 C2 00 25 18 E3 00 FF FF 63 30 ?? ?? ?? 0? 00 00 22 82 70 00 A4 8F 10 00 66 30 01 00 82 80 00 00 85 8C 04 00 84 24 40 00 C0 10 10 00 A2 A3 3F 00 40 50 14 00 A5 A3 FF FF 06 24 3C 00 46 50 14 00 A5 A3 14 00 A2 A3 15 00 A5 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF ?? ?? ?? 0? 80 00 63 34 ?? ?? ?? 0? C0 00 63 34 21 B8 00 00 00 00 F4 8C 04 00 E7 24 ?? ?? ?? 0? 70 00 A7 AF 30 00 04 24 21 28 60 02 ?? ?? ?? 0? 38 00 A3 AF 20 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 20 00 A4 AF 21 80 02 02 68 FF 80 10 38 00 A3 8F 30 00 04 24 21 28 60 02 ?? ?? ?? 0? 38 00 A3 AF 20 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 20 00 A4 AF 21 80 02 02 E9 FF 80 14 38 00 A3 8F ?? ?? ?? 0? 08 00 63 30 ?? ?? ?? 0? 21 28 00 00 10 02 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 80 02 0F 02 40 54 21 20 40 00 02 00 C3 2A 54 FE 60 50 ?? ?? 03 3C ?? ?? ?? 0? 21 20 40 00 D9 FD 44 14 10 00 B4 27 ?? ?? ?? 0? 20 00 63 34 14 00 A5 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF 72 FF 40 10 00 00 00 00 8C 02 E2 06 21 20 80 02 ?? ?? ?? 0? 21 20 80 02 21 B0 40 00 10 00 C0 12 21 20 00 00 ?? ?? 05 3C ?? ?? A5 24 21 10 00 00 13 00 06 24 04 00 A3 8C 01 00 42 24 08 00 60 14 21 20 40 00 00 00 A3 8C 2B 18 C3 02 04 00 60 14 08 00 A5 24 F8 FF 46 54 04 00 A3 8C 14 00 04 24 23 90 44 02 19 00 42 2A D1 01 40 14 00 00 00 00 ?? ?? ?? 0? 20 24 12 7C 21 B8 40 00 21 20 C0 02 ?? ?? ?? 0? 21 28 00 00 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 28 E0 02 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 00 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 B0 40 00 25 10 43 00 0F 00 40 10 21 B8 00 00 ?? ?? ?? 0? 18 00 B6 8F ?? ?? ?? 0? 00 00 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 25 10 43 00 04 FE 40 54 18 00 B6 8F FF FF 52 26 21 28 E0 02 21 20 C0 02 0A 00 06 24 EF FF 40 16 21 38 00 00 18 00 B6 8F 0A 00 C2 2A FE FD 40 10 ?? ?? 03 3C ?? ?? ?? 0? 21 20 80 02 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 34 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 34 00 A8 8F 24 00 A4 8F 27 18 08 00 06 10 14 01 04 18 64 00 25 10 62 00 20 00 04 31 06 18 17 01 0B 10 64 00 ?? ?? 05 3C 0F 00 42 30 ?? ?? A5 24 21 10 A2 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 20 00 A5 8F BB 00 A0 14 08 00 62 30 08 00 67 30 28 00 A7 AF 02 00 62 30 B2 00 40 10 01 00 63 30 2D 00 02 24 2B 00 04 24 0B 20 43 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 ?? ?? ?? 0? 0B 90 44 00 01 00 02 24 24 02 E0 12 10 00 A2 A3 ?? ?? 05 3C ?? ?? A4 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 08 24 21 38 40 00 04 00 85 8C 01 00 42 24 2B 30 E5 02 B1 01 C0 14 20 14 02 7C AC 01 B7 50 00 00 85 8C F7 FF 48 14 08 00 84 24 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 0A 02 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 41 04 00 02 00 02 24 02 4F 04 00 25 48 26 01 01 00 42 24 21 30 00 01 2B 40 E5 02 02 00 0A 24 10 00 0B 24 20 14 02 7C 11 00 00 15 21 38 20 01 67 01 E5 12 2B 20 84 02 E9 FF 4B 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 41 04 00 02 4F 04 00 25 48 26 01 21 50 40 00 21 30 00 01 01 00 42 24 2B 40 E5 02 20 14 02 7C F1 FF 00 11 21 38 20 01 10 00 AA A3 ?? ?? ?? 0? 21 10 40 01 70 00 A7 8F 01 00 31 26 00 00 22 82 00 00 F2 8C 04 00 E7 24 ?? ?? ?? 0? 70 00 A7 AF 20 00 A3 8F 08 00 63 30 0B 00 60 14 24 00 A3 AF 0A 00 A0 1A 20 00 A4 8F 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 20 00 A4 8F 02 00 82 30 17 01 40 14 01 00 84 30 20 00 A5 8F 01 00 A2 30 11 00 40 10 20 00 04 24 ?? ?? ?? 0? 00 00 00 00 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 ?? ?? 07 3C ?? ?? E7 24 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 20 80 02 21 28 00 00 21 30 E6 00 E8 FF 40 14 10 00 A3 A3 ?? ?? ?? 0? 18 00 A2 8F 21 20 80 02 ?? ?? ?? 0? 18 00 A5 27 18 00 B7 8F 03 00 03 24 0A 00 02 24 FF FF F7 26 02 B8 E3 72 1A 00 E2 02 F4 01 40 00 12 B8 00 00 96 01 E0 06 18 00 B7 AF 23 20 17 00 ?? ?? ?? 0? 20 24 04 7C 21 20 40 00 ?? ?? ?? 0? 21 28 80 02 2C 00 A2 AF ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 2C 00 A4 8F 00 01 42 04 FF FF F7 26 ?? ?? 02 3C ?? ?? 44 8C ?? ?? ?? 0? 2C 00 A5 8F 26 FD 40 1C 20 00 A3 8F 01 00 F7 26 ?? ?? ?? 0? 18 00 B7 AF ?? ?? ?? 0? 10 00 A9 A3 70 00 A7 8F F8 FF 02 24 07 00 E4 24 24 10 82 00 08 00 44 24 70 00 A4 AF 00 00 54 8C ?? ?? ?? 0? 04 00 57 8C 20 FE 40 10 20 00 A2 8F ?? ?? ?? 0? 20 00 04 24 21 FE 60 10 FF FF 48 26 ?? ?? ?? 0? 20 00 04 24 47 FF 40 14 28 00 A2 AF 20 00 04 24 21 28 60 02 ?? ?? ?? 0? 38 00 A3 AF 20 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 20 00 A4 AF }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "fputc"
		size = 320
		refs = "006c _outdone 00d4 fputc 00f8 write 0130 _flsbuf"
	strings:
		$1 = { 0C 00 A2 94 E0 FF BD 27 18 00 B1 AF 02 00 43 30 14 00 B0 AF 1C 00 BF AF 21 80 A0 00 19 00 60 10 FF FF 11 24 00 02 43 30 1C 00 60 10 04 00 A3 8C 00 02 42 34 0C 00 A2 A4 1D 00 60 10 FF 00 91 30 0A 00 04 24 20 00 24 12 80 00 42 30 10 00 02 8E 36 00 62 10 01 00 63 24 00 00 02 8E 04 00 03 AE 01 00 44 24 00 00 51 A0 01 00 03 24 ?? ?? 02 3C 00 00 04 AE ?? ?? 43 A0 0A 00 02 24 19 00 22 52 0C 00 02 96 1C 00 BF 8F 21 10 20 02 14 00 B0 8F 18 00 B1 8F 08 00 E0 03 20 00 BD 27 F9 FF 60 14 00 02 42 34 0C 00 A2 A4 FF 00 91 30 21 18 00 00 08 00 04 8E 00 00 04 AE 0A 00 04 24 E4 FF 24 56 10 00 02 8E 80 00 42 30 E1 FF 40 54 10 00 02 8E 0D 00 04 24 ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 04 00 03 8E 00 01 42 30 E7 FF 40 10 1C 00 BF 8F 0E 00 04 96 08 00 05 8E ?? ?? ?? 0? 04 00 06 8E 04 00 03 8E 06 00 43 50 08 00 02 8E 0C 00 02 96 FF FF 11 24 30 00 42 34 0C 00 02 A6 08 00 02 8E 04 00 00 AE ?? ?? ?? 0? 00 00 02 AE 20 24 11 7C ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 21 88 40 00 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "_bufallo"
		size = 84
		refs = "0034 errno 0044 sbrk"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 62 8C E8 FF BD 27 0D 00 40 10 14 00 BF AF 00 00 44 8C ?? ?? 64 AC FF FF 03 24 03 00 43 10 14 00 BF 8F 08 00 E0 03 18 00 BD 27 E9 66 04 24 ?? ?? 03 3C ?? ?? 64 AC 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 20 00 04 24 ?? ?? ?? 0? FF FF 03 24 }
	condition:
		$1
}

rule file_175_1_0 {
	meta:
		name = "_dvfprintf_cdeEfFnopsuxX"
		size = 6700
		refs = "009c _ctype 0164 fputc 0478 dpcmp 04fc dptoul 05c0 __udivdi3 05fc __umoddi3 0a70 _npowers_ 0a98 dpmul 0b30 dpadd 0b74 __fixunsdfdi 0bfc dpdiv 0f7c frexp 1084 __floatunsidf 109c dpsub 1380 __floatundidf"
		altNames = "_dvfprintf_cdeEfFnopuxX"
	strings:
		$1 = { 98 FF BD 27 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 2C 00 A0 AF 30 00 A0 AF 21 80 00 00 00 00 24 82 68 00 80 10 10 00 A4 A3 25 00 02 24 4D 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 41 02 46 10 FF FF 91 24 2E 00 45 28 37 02 A0 10 00 00 00 00 49 02 47 50 01 00 63 34 45 02 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A4 24 21 28 82 00 01 00 A5 90 02 00 67 30 FE FF 66 30 0B 18 C7 00 08 00 67 30 FB FF 66 30 04 00 A5 30 3D 02 A0 10 0B 18 C7 00 21 98 00 00 0A 00 06 24 02 28 66 72 01 00 31 26 21 98 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 73 26 2E 00 05 24 3B 02 45 50 01 00 31 26 00 10 63 34 21 B8 00 00 ?? ?? 07 3C ?? ?? E6 24 10 00 08 24 00 80 07 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3D 00 A0 14 01 00 31 26 10 00 B5 27 01 00 1E 24 04 00 E0 12 2B 10 D3 03 2B 10 FE 02 0B F0 E2 02 2B 10 D3 03 08 00 76 30 23 98 7E 02 0B 00 C0 16 0A 98 02 00 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D4 57 00 00 A4 82 A5 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9A FF 80 14 10 00 A4 A3 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 80 20 04 00 21 20 C4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 63 34 80 00 63 34 00 07 62 30 B5 00 40 10 21 B0 60 00 00 10 65 30 06 00 04 24 10 00 62 30 BA 02 40 10 0B B8 85 00 70 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 45 8C 04 00 54 8C 08 00 44 24 70 00 A4 AF 20 00 A5 AF 20 00 A6 8F 21 28 80 02 21 38 00 00 21 20 C0 00 21 30 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 76 34 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF B0 02 40 14 20 00 A3 8F 24 00 A0 AF 00 01 C2 32 5F 01 40 10 19 00 E2 2A 13 00 E2 2E D2 02 40 10 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 10 00 B7 A3 D4 02 40 14 10 00 A9 83 20 00 A2 8F 21 28 80 02 ?? ?? ?? 0? 21 20 40 00 21 A0 40 00 18 00 B5 8F ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF 73 26 03 00 C2 32 63 00 A3 26 2B 10 02 00 23 98 77 02 C7 00 63 2C 23 98 62 02 01 00 63 2C 04 00 C2 32 16 03 40 10 23 98 63 02 02 00 C2 32 F8 04 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 60 1A 08 00 DE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 DE 32 10 00 A2 83 20 00 A6 8F 21 20 80 02 C0 10 02 00 21 10 C2 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 20 00 A7 8F 27 10 02 00 C0 18 03 00 21 18 E3 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A0 40 00 39 04 E0 16 21 A8 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 73 04 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 64 00 43 28 5B 04 60 10 64 00 14 24 0A 00 14 24 1A 00 54 00 F4 01 80 02 21 28 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 64 FE C0 13 21 80 02 02 63 FE 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 63 34 00 01 63 34 00 07 62 30 4D FF 40 14 21 B0 60 00 C0 00 62 30 12 02 40 14 20 16 03 7C 51 04 40 04 10 00 62 30 BC 02 40 10 70 00 A5 8F 70 00 A2 8F 00 00 44 8C 04 00 42 24 70 00 A2 AF C3 17 04 00 21 A8 80 00 D3 02 40 04 21 B0 40 00 03 00 E0 16 C0 00 74 30 25 B8 B6 02 01 00 F7 2E 40 00 02 24 8E 03 82 12 41 00 82 2A 63 03 40 10 80 00 02 24 16 00 80 16 10 00 BE 83 01 00 02 24 AB 04 C0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 42 24 02 00 06 24 02 00 1E 24 ?? ?? ?? 0? 14 00 07 24 21 30 C0 03 04 00 44 8C 2B 28 C4 02 5C 03 A0 54 10 00 A6 A3 70 04 96 50 00 00 44 8C 01 00 DE 27 20 F4 1E 7C F6 FF C7 17 08 00 42 24 10 00 BE A3 2A 10 D7 03 47 03 40 10 2A 10 FE 02 20 F4 17 7C 10 00 BE A3 05 00 60 12 00 40 62 30 03 00 62 30 2B 10 02 00 23 98 62 02 00 40 62 30 05 00 40 10 2A 20 D3 03 2A 10 F3 02 23 98 77 02 0A 98 02 00 2A 20 D3 03 04 00 62 30 23 F0 7E 02 17 03 40 10 0A F0 04 00 02 00 62 30 77 03 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 64 30 0D 00 C0 13 24 00 A4 AF 21 98 60 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 08 00 65 32 21 18 60 02 24 00 A5 AF FF FF F7 26 ?? ?? 02 3C C0 98 17 00 ?? ?? 42 24 21 98 53 00 03 00 02 24 80 40 17 00 40 20 16 00 02 B8 E2 72 20 00 63 30 41 00 82 2A 28 00 BE AF 34 00 B1 AF 20 00 A3 AF 21 F0 80 00 ?? ?? ?? 0? 21 88 40 00 10 00 80 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 3C 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF F7 26 FD FF 02 24 BB 02 E2 12 40 00 02 24 9D 02 82 12 27 10 17 00 DF FF 20 16 80 00 02 24 A3 02 82 12 C0 00 02 24 DD FF 82 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 CE FD 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 C1 FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 05 24 CD FD 45 14 21 98 00 00 70 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D3 8C 2E 00 05 24 04 00 C6 24 C8 FD 45 14 70 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 05 24 32 03 45 10 00 40 63 34 21 28 82 00 01 00 A5 90 21 B8 00 00 04 00 A5 30 BF FD A0 10 0A 00 06 24 02 28 E6 72 01 00 31 26 21 B8 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF F7 26 ?? ?? ?? 0? ?? ?? 07 3C 40 00 40 10 24 00 A3 8F FF 00 F5 32 6E 00 A2 2E 8C 03 40 14 0B 00 A2 2E EB 51 02 3C 1F 85 42 34 19 00 A2 02 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? 1E 3C ?? ?? DE 27 10 28 00 00 42 41 05 00 FF 00 02 31 12 00 42 24 C0 10 02 00 21 10 5E 00 00 00 44 8C 04 00 45 8C ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 64 00 04 24 CC CC 09 3C 02 28 04 71 CD CC 29 35 21 20 40 00 38 00 A9 AF 23 40 A5 02 FF 00 08 31 19 00 09 01 21 28 60 00 10 38 00 00 F8 07 E2 30 21 10 C2 03 48 00 46 8C ?? ?? ?? 0? 4C 00 47 8C 38 00 A9 8F 21 20 40 00 21 28 60 00 19 00 A9 02 0A 00 02 24 10 38 00 00 C2 18 07 00 02 30 62 70 23 10 A6 02 FF 00 42 30 C0 10 02 00 21 F0 5E 00 00 00 C6 8F ?? ?? ?? 0? 04 00 C7 8F 20 00 A8 8F 21 28 80 02 21 30 40 00 21 20 00 01 ?? ?? ?? 0? 21 38 60 00 20 00 A2 AF 21 A0 60 00 24 00 A3 8F 0A 00 62 28 14 00 40 10 30 00 A2 8F 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 FF 01 40 10 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 25 10 43 00 FD 01 40 14 21 A8 60 00 24 00 A4 8F 02 00 82 28 F9 01 40 14 30 00 A2 8F 2C 00 A3 8F 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 20 60 00 9F 01 40 04 24 00 A3 8F 24 00 A4 8F EE FF 88 24 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 3C 00 A8 AF 30 00 A3 AF 20 00 A6 8F 21 18 40 00 2C 00 A2 AF 30 00 A2 8F 21 20 C0 00 21 28 80 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 3C 00 A8 8F 21 F0 40 00 21 A8 60 00 20 00 A0 AF 28 00 A0 AF 01 00 02 24 6C 03 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 05 24 02 00 07 24 ?? ?? ?? 0? 12 00 0A 24 21 38 A0 00 04 00 64 8C 2B 30 A4 02 A3 02 C0 14 02 00 49 24 9E 02 95 50 00 00 64 8C 01 00 E5 24 01 00 42 24 20 2C 05 7C F5 FF 4A 14 08 00 63 24 10 00 A5 A3 14 00 09 24 23 A0 68 02 23 A0 97 02 2B 10 17 00 23 A0 89 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 56 02 40 10 23 A0 83 02 02 00 C2 32 1A 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 D6 32 24 00 B6 AF ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 73 26 C0 18 03 00 21 18 63 02 00 00 66 8C 04 00 67 8C 21 20 C0 03 ?? ?? ?? 0? 21 28 A0 02 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 E2 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 E2 2A 2E 02 40 14 20 14 17 7C 12 00 02 24 10 00 A2 A3 EE FF F7 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 21 28 60 00 28 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 FF FF 64 26 20 24 04 7C 21 A8 40 00 21 B0 60 00 27 00 60 12 10 00 A4 A3 ?? ?? 02 3C ?? ?? 42 24 21 98 20 02 20 00 A2 AF 21 88 40 00 C0 20 04 00 21 20 24 02 00 00 86 8C 04 00 87 8C 21 28 C0 02 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 BE 83 27 10 02 00 21 20 A0 02 C0 18 1E 00 21 18 23 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 C0 02 ?? ?? ?? 0? 21 80 02 02 FF FF C4 27 20 24 04 7C 21 A8 40 00 21 B0 60 00 E1 FF C0 17 10 00 A4 A3 21 88 60 02 0A 00 E0 12 24 00 A6 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF F7 26 F9 FF E0 16 21 80 02 02 24 00 A6 8F 56 FC C0 50 00 00 24 82 54 FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A6 8F F8 FF 02 24 07 00 C4 24 24 10 82 00 00 00 47 8C 04 00 54 8C 08 00 42 24 20 00 A7 AF ?? ?? ?? 0? 70 00 A2 AF 37 02 40 04 10 00 62 30 B4 00 40 50 70 00 A4 8F 70 00 A2 8F 21 B0 00 00 00 00 55 8C 04 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 21 28 80 02 18 00 A6 27 ?? ?? ?? 0? 21 20 60 00 18 00 A4 8F 03 00 03 24 0A 00 02 24 FF FF 84 24 02 18 83 70 1A 00 62 00 F4 01 40 00 12 20 00 00 24 00 A4 AF 73 02 80 04 18 00 A4 AF 24 00 A5 8F ?? ?? ?? 0? 23 20 05 00 21 28 60 00 20 00 A3 8F 21 20 40 00 21 38 80 02 ?? ?? ?? 0? 21 30 60 00 30 00 A3 AF ?? ?? 06 3C 21 18 40 00 2C 00 A2 AF 30 00 A2 8F ?? ?? C7 8C ?? ?? C6 8C 21 20 60 00 ?? ?? ?? 0? 21 28 40 00 92 00 41 04 }
	condition:
		$1
}

rule file_198_2_0 {
	meta:
		name = "_vfprintf_cdeEfFgGnopsuxX"
		size = 6416
		refs = "009c _ctype 0168 fputc 0468 __floatdisf 0480 fpcmp 04e8 fpadd 0534 fpdiv 053c fptoui 066c __udivdi3 0680 __umoddi3 072c fpmul 0e80 __floatunsisf 0e8c fpsub 0f2c frexpf 1114 __floatundisf"
		altNames = "_vfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { 98 FF BD 27 21 10 00 00 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 30 00 A2 AF 21 80 00 00 00 00 24 82 69 00 80 10 10 00 A4 A3 25 00 02 24 A1 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 95 02 46 10 FF FF 91 24 2E 00 45 28 8B 02 A0 10 00 00 00 00 9D 02 47 50 01 00 63 34 99 02 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A5 24 21 20 A2 00 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 91 02 80 10 0B 18 A6 00 21 B8 00 00 0A 00 05 24 02 20 E5 72 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 B8 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF F7 26 2E 00 04 24 8D 02 44 50 01 00 31 26 00 10 63 34 21 98 00 00 10 00 07 24 00 80 06 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3E 00 A0 14 01 00 31 26 10 00 B5 27 01 00 1E 24 04 00 60 52 2B 98 D7 03 2B 10 7E 02 0B F0 62 02 2B 98 D7 03 23 B8 FE 02 0A B8 13 00 08 00 76 30 0B 00 C0 16 21 98 E0 02 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D4 57 00 00 A4 82 A4 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 99 FF 80 14 10 00 A4 A3 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 ?? ?? 02 3C ?? ?? 42 24 80 20 04 00 21 20 44 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 00 63 34 00 07 62 30 08 01 40 10 20 00 A3 AF 00 10 65 30 06 00 04 24 10 00 62 30 0F 02 40 10 0B 98 85 00 70 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 38 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 38 00 A3 8F 21 A0 40 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 05 00 41 04 38 00 A3 8F 00 80 02 3C 03 00 63 34 26 A0 54 00 20 00 A3 AF 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF 9D 02 40 14 21 B0 00 00 20 00 A3 8F 00 01 62 30 B9 01 40 14 00 02 62 30 B5 01 40 14 FC FF C2 2A 19 00 62 2A 08 00 40 10 18 00 BE 8F ?? ?? ?? 0? FF 00 64 32 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 A0 40 00 18 00 BE 8F 0A 00 C2 2B D0 02 40 14 21 20 80 02 ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 30 00 A4 8F 9C 04 43 04 EE FF DE 27 ED FF DE 27 18 00 BE AF ?? ?? ?? 0? 20 24 1E 7C 21 28 40 00 21 20 80 02 ?? ?? ?? 0? 30 00 A2 AF ?? ?? ?? 0? 21 20 40 00 21 20 00 00 21 B0 40 00 21 A8 40 00 28 00 A4 AF 01 00 03 24 0A 00 C2 2E DB 04 40 14 10 00 A3 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 08 24 02 00 04 24 ?? ?? ?? 0? 12 00 07 24 21 40 80 00 04 00 65 8C 5F 04 A0 14 02 00 46 24 00 00 65 8C 2B 28 C5 02 5B 04 A0 14 01 00 84 24 01 00 42 24 20 24 04 7C F5 FF 47 14 08 00 63 24 10 00 A4 A3 14 00 06 24 20 00 A5 8F 23 A0 FE 02 23 A0 93 02 2B 10 13 00 23 A0 86 02 03 00 A3 30 23 A0 82 02 2B 18 03 00 04 00 A2 30 2D 04 40 10 23 A0 83 02 02 00 A2 30 81 04 40 10 20 00 A6 8F 01 00 A4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 A9 04 80 1A 20 00 A7 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A2 8F 08 00 42 30 24 00 A2 AF ?? ?? 06 3C ?? ?? ?? 0? ?? ?? D6 24 C0 18 03 00 21 18 C3 02 00 00 66 8C 04 00 67 8C 21 20 A0 02 ?? ?? ?? 0? 21 28 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 62 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 62 2A 62 04 40 14 20 14 13 7C 12 00 02 24 10 00 A2 A3 EE FF 73 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 28 00 A5 8F 21 20 40 00 ?? ?? ?? 0? 21 B8 00 00 ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 23 00 A0 12 10 00 A2 A3 ?? ?? 07 3C ?? ?? FE 24 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 20 C0 02 ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B5 83 27 10 02 00 2B 10 02 00 C0 18 15 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 28 E0 02 21 20 C0 02 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 FF FF A2 26 20 14 02 7C 21 B8 60 00 E1 FF A0 16 10 00 A2 A3 0A 00 60 12 24 00 A2 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 24 00 A2 8F 10 FE 40 50 00 00 24 82 0E FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 63 34 00 01 63 34 00 07 62 30 FA FE 40 14 20 00 A3 AF C0 00 62 30 0F 01 40 14 20 16 03 7C AC 03 40 04 70 00 A4 8F 10 00 62 30 D1 01 40 10 70 00 A6 8F 70 00 A5 8F 00 00 A4 8C 04 00 A5 24 70 00 A5 AF C3 17 04 00 21 A8 80 00 21 B0 40 00 05 00 41 04 23 10 02 00 23 A8 04 00 2B 20 15 00 03 00 63 34 23 B0 44 00 03 00 60 16 C0 00 74 30 25 98 B6 02 01 00 73 2E 40 00 02 24 E1 02 82 12 41 00 82 2A D9 02 40 10 80 00 02 24 16 00 80 16 10 00 A2 83 01 00 02 24 09 04 C0 12 10 00 A2 A3 ?? ?? 04 3C ?? ?? 84 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 08 24 21 38 40 00 04 00 85 8C 2B 30 C5 02 9A 03 C0 54 10 00 A7 A3 94 03 B6 50 00 00 85 8C 01 00 42 24 20 14 02 7C F6 FF 48 14 08 00 84 24 10 00 A2 A3 2A 20 53 00 BD 02 80 10 2A 20 62 02 20 14 13 7C 10 00 A2 A3 05 00 E0 12 00 40 64 30 03 00 64 30 2B 20 04 00 23 B8 E4 02 00 40 64 30 05 00 80 10 2A 28 57 00 2A 20 77 02 23 B8 F3 02 0A B8 04 00 2A 28 57 00 04 00 64 30 23 10 E2 02 21 B8 00 00 80 02 80 10 0B B8 45 00 02 00 62 30 E7 02 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 67 30 02 02 E0 16 2C 00 A7 AF FF FF 62 26 ?? ?? 05 3C C0 98 02 00 ?? ?? BE 24 21 98 D3 03 03 00 1E 24 80 40 02 00 02 F0 5E 70 41 00 84 2A 40 10 16 00 20 00 63 30 24 00 A2 AF 20 00 A4 AF ?? ?? ?? 0? 28 00 A3 AF 10 00 80 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 34 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 34 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 34 00 A8 AF 34 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF DE 27 FD FF 02 24 33 02 C2 13 40 00 02 24 25 02 82 12 20 00 A5 8F DF FF A0 14 80 00 02 24 0E 02 82 12 C0 00 02 24 DD FF 82 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 63 34 ?? ?? ?? 0? 80 00 63 34 20 00 63 34 ?? ?? ?? 0? 00 02 63 34 7A FD 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 6D FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 7B FD 44 14 21 B8 00 00 70 00 A7 8F 01 00 31 26 00 00 22 82 00 00 F7 8C 2E 00 04 24 04 00 E7 24 76 FD 44 14 70 00 A7 AF 01 00 31 26 00 00 22 82 2A 00 04 24 7F 02 44 10 00 40 63 34 ?? ?? 05 3C ?? ?? A5 24 21 20 A2 00 01 00 84 90 21 98 00 00 04 00 84 30 6B FD 80 10 0A 00 05 24 02 20 65 72 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 98 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF 73 26 ?? ?? ?? 0? 10 00 07 24 3C 01 40 10 2A 10 D3 02 DD 00 60 12 21 10 00 00 20 00 A4 8F 40 02 82 7C 23 98 62 02 13 00 62 2E D6 00 40 14 12 00 02 24 10 00 A2 A3 21 20 80 02 ?? ?? ?? 0? 21 28 00 00 9E 00 40 14 10 00 A3 83 ?? ?? ?? 0? 21 20 80 02 ?? ?? 05 3C 21 A8 40 00 ?? ?? BE 24 20 00 A5 8F FB FF F4 26 23 A0 93 02 03 00 A3 30 2B 18 03 00 04 00 A2 30 2B 00 40 10 23 A0 83 02 02 00 A2 30 F6 00 40 10 20 00 A6 8F 01 00 A4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 16 03 80 1A 20 00 A7 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A2 8F 08 00 42 30 ?? ?? ?? 0? 28 00 A2 AF 70 00 A4 8F 00 00 94 8C 04 00 84 24 ?? ?? ?? 0? 70 00 A4 AF A8 02 40 04 10 00 62 30 BF 00 40 10 70 00 A6 8F 70 00 A5 8F 21 B0 00 00 00 00 B5 8C 04 00 A5 24 ?? ?? ?? 0? 70 00 A5 AF 20 00 A3 8F 08 00 63 30 0B 00 60 14 28 00 A3 AF 0A 00 80 1A 20 00 A4 8F 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A4 8F 02 00 82 30 B3 00 40 14 01 00 84 30 20 00 A5 8F 01 00 A2 30 B3 00 40 14 20 00 04 24 10 00 A2 83 21 20 A0 02 21 28 00 00 C0 10 02 00 21 10 C2 03 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 FB 01 60 16 21 B0 60 00 20 00 A5 8F 20 00 A2 30 02 00 40 14 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 33 02 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 13 24 21 28 40 02 1A 00 53 00 F4 01 60 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 73 00 F4 01 60 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 28 00 A2 8F 8A FC 40 50 00 00 24 82 88 FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 23 20 C3 02 20 24 04 7C ?? ?? ?? 0? 38 00 A3 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 21 20 40 00 ?? ?? ?? 0? 34 00 A2 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? 07 3C ?? ?? E7 24 00 00 E4 8C ?? ?? ?? 0? 21 28 40 00 38 00 A3 8F 0A 00 40 1C 34 00 A6 8F ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 38 00 A3 8F 21 30 40 00 ?? ?? 04 3C 01 00 62 24 ?? ?? 9E 24 C0 10 02 00 21 10 C2 03 04 00 44 8C 45 00 80 10 21 A8 C0 00 C0 18 03 00 21 18 C3 03 04 00 62 8C 22 02 40 50 00 00 62 8C ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? FF FF D6 26 21 10 60 02 ?? ?? ?? 0? 10 00 A2 A3 21 20 80 02 ?? ?? ?? 0? 18 00 A5 27 18 00 B6 8F 03 00 03 24 0A 00 02 24 FF FF D6 26 02 B0 C3 72 1A 00 C2 02 F4 01 40 00 12 B0 00 00 37 02 C0 06 18 00 B6 AF 23 20 16 00 ?? ?? ?? 0? 20 24 04 7C 21 20 40 00 ?? ?? ?? 0? 21 28 80 02 30 00 A2 AF ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 30 00 A4 8F 3A 00 41 04 ?? ?? 02 3C FF FF D6 26 ?? ?? ?? 0? 18 00 B6 AF 21 B0 00 00 00 00 D5 8C 04 00 C6 24 ?? ?? ?? 0? 70 00 A6 AF 00 00 C4 8C 04 00 C6 24 70 00 A6 AF C3 17 04 00 21 A8 80 00 ?? ?? ?? 0? 21 B0 40 00 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 01 00 C2 30 13 FF 40 10 20 00 04 24 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "abs"
		size = 16
		altNames = "labs"
	strings:
		$1 = { C3 1F 04 00 26 10 64 00 08 00 E0 03 23 10 43 00 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "fflush"
		size = 144
		refs = "0058 write"
	strings:
		$1 = { 0C 00 82 94 E8 FF BD 27 10 00 B0 AF 01 00 03 24 21 80 80 00 01 02 44 30 16 00 83 10 14 00 BF AF 02 02 44 30 02 02 03 24 05 00 83 10 21 10 00 00 14 00 BF 8F 10 00 B0 8F 08 00 E0 03 18 00 BD 27 08 00 05 8E FB FF A0 10 14 00 BF 8F 04 00 06 8E F9 FF C0 50 10 00 B0 8F ?? ?? ?? 0? 0E 00 04 96 04 00 03 8E 03 00 43 10 0C 00 02 96 30 00 42 34 0C 00 02 A6 08 00 04 8E 20 00 43 30 FF FF 02 24 04 00 00 AE 00 00 04 AE ?? ?? ?? 0? 0A 10 03 00 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "strcpy"
		size = 36
	strings:
		$1 = { 21 10 80 00 21 18 80 00 00 00 A4 80 01 00 A5 24 00 00 64 A0 FC FF 80 14 01 00 63 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_217_2_0 {
	meta:
		name = "_vfprintf_cdgGnopsuxX"
		size = 6460
		refs = "000c _ctype 0160 fputc 0464 __floatdisf 0484 fpcmp 0508 fptoui 0520 __floatundisf 052c fpsub 0728 __udivdi3 073c __umoddi3 0924 fpadd 0964 fpmul 0a38 fpdiv 131c frexpf 1554 __floatunsisf"
		altNames = "_vfprintf_cdgGnopuxX"
	strings:
		$1 = { 90 FF BD 27 64 00 B7 AF 21 10 00 00 ?? ?? 17 3C 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 68 00 BE AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 21 90 80 00 21 88 A0 00 78 00 A6 AF 34 00 A2 AF 21 80 00 00 ?? ?? F7 26 00 00 24 82 65 00 80 10 10 00 A4 A3 25 00 02 24 E1 01 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 D5 01 46 10 FF FF 91 24 2E 00 45 28 CB 01 A0 10 00 00 00 00 DD 01 47 50 01 00 63 34 D9 01 49 50 02 00 63 34 21 20 E2 02 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 D3 01 80 10 0B 18 A6 00 21 40 00 00 0A 00 05 24 02 20 05 71 01 00 31 26 21 40 82 00 00 00 22 82 21 20 E2 02 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 08 25 2E 00 04 24 D1 01 44 50 01 00 31 26 00 10 63 34 21 A0 00 00 10 00 07 24 00 80 06 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3E 00 A0 14 01 00 31 26 10 00 B3 27 01 00 1E 24 04 00 80 52 2B A0 C8 03 2B 10 9E 02 0B F0 82 02 2B A0 C8 03 23 40 1E 01 0A 40 14 00 08 00 76 30 0B 00 C0 16 21 A0 00 01 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 95 16 20 00 04 24 ?? ?? ?? 0? FF FF 15 24 21 28 40 02 ?? ?? ?? 0? 01 00 73 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D5 57 00 00 64 82 A8 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 93 16 20 00 04 24 00 00 24 82 9D FF 80 14 10 00 A4 A3 6C 00 BF 8F 21 10 00 02 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 ?? ?? 05 3C 80 20 04 00 ?? ?? A5 24 21 20 A4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 00 63 34 00 07 62 30 4E 00 40 10 21 B0 60 00 00 10 65 30 06 00 04 24 10 00 62 30 C1 02 40 10 0B A0 85 00 78 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 40 00 A3 AF 44 00 A8 AF ?? ?? ?? 0? 78 00 A2 AF 40 00 A3 8F 44 00 A8 8F 21 98 40 00 21 20 60 02 21 28 00 00 40 00 A3 AF ?? ?? ?? 0? 44 00 A8 AF 40 00 A3 8F 04 00 41 04 44 00 A8 8F 00 80 02 3C 26 98 53 00 03 00 76 34 21 20 60 02 21 28 00 00 44 00 A8 AF ?? ?? ?? 0? 18 00 A0 AF 44 00 A8 8F 96 03 40 14 21 18 00 00 00 02 C2 32 F3 00 40 14 FC FF 62 28 19 00 82 2A C1 02 40 14 FF 00 84 32 18 00 B5 8F 0A 00 A2 2A 46 01 40 10 ?? ?? 03 3C 21 20 60 02 21 28 00 00 ?? ?? ?? 0? 44 00 A8 AF AE 02 40 14 44 00 A8 8F 21 20 60 02 ?? ?? ?? 0? 44 00 A8 AF 44 00 A8 8F 21 20 40 00 21 28 00 00 44 00 A8 AF ?? ?? ?? 0? 21 F0 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 60 02 24 00 A2 AF 21 98 C0 03 18 00 A0 AF 21 A8 00 00 ?? ?? ?? 0? 44 00 A8 8F 20 00 63 34 00 02 63 34 00 07 62 30 B4 FF 40 14 21 B0 60 00 C0 00 62 30 7B 02 40 14 20 16 03 7C 44 04 40 04 78 00 A7 8F 10 00 62 30 88 02 40 10 78 00 A5 8F 78 00 A2 8F 00 00 44 8C 04 00 42 24 78 00 A2 AF C3 17 04 00 21 98 80 00 21 B0 40 00 05 00 41 04 23 10 02 00 23 98 04 00 2B 20 13 00 03 00 63 34 23 B0 44 00 03 00 80 16 C0 00 75 30 25 A0 76 02 01 00 94 2E 40 00 02 24 90 03 A2 12 41 00 A2 2A 2A 03 40 10 80 00 02 24 16 00 A0 16 10 00 A2 83 01 00 02 24 D0 04 C0 12 10 00 A2 A3 ?? ?? 04 3C ?? ?? 84 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 09 24 21 38 40 00 04 00 85 8C 2B 30 C5 02 4E 04 C0 54 10 00 A7 A3 48 04 B6 50 00 00 85 8C 01 00 42 24 20 14 02 7C F6 FF 49 14 08 00 84 24 10 00 A2 A3 2A 20 54 00 DF 02 80 10 2A 20 82 02 20 14 14 7C 10 00 A2 A3 05 00 00 11 00 40 64 30 03 00 64 30 2B 20 04 00 23 40 04 01 00 40 64 30 05 00 80 10 2A 28 48 00 2A 20 88 02 23 40 14 01 0A 40 04 00 2A 28 48 00 23 10 02 01 0A 10 05 00 04 00 64 30 CE 02 80 10 20 00 A2 AF 02 00 62 30 78 03 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 40 00 A3 AF 27 10 02 00 40 00 A3 8F 2B 10 02 00 21 80 02 02 20 00 A4 8F 08 00 62 30 75 02 80 14 30 00 A2 AF FF FF 82 26 ?? ?? 07 3C C0 A0 02 00 ?? ?? FE 24 21 A0 D4 03 03 00 1E 24 80 40 02 00 02 F0 5E 70 41 00 A4 2A 40 10 16 00 20 00 63 30 28 00 A2 AF 24 00 A4 AF ?? ?? ?? 0? 2C 00 A3 AF 10 00 A0 16 10 00 A4 83 00 00 86 8E 04 00 87 8E 21 20 60 02 21 28 C0 02 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 44 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 44 00 A8 AF 44 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 94 26 FC FF 08 25 FD FF DE 27 FD FF 02 24 7B 02 C2 13 40 00 02 24 6D 02 A2 12 24 00 A5 8F DF FF A0 14 80 00 02 24 56 02 A2 12 C0 00 02 24 DD FF A2 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 63 34 ?? ?? ?? 0? 80 00 63 34 3A FE 48 54 21 20 E2 02 04 00 63 34 01 00 84 24 FF FF 82 80 2D FE 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 37 FE 44 14 21 40 00 00 78 00 A5 8F 01 00 31 26 00 00 22 82 00 00 A8 8C 2E 00 04 24 04 00 A5 24 32 FE 44 14 78 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 11 03 44 10 00 40 63 34 21 20 E2 02 01 00 84 90 21 A0 00 00 04 00 84 30 29 FE 80 10 0A 00 05 24 02 20 85 72 01 00 31 26 21 A0 82 00 00 00 22 82 21 20 E2 02 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 94 26 ?? ?? ?? 0? 10 00 07 24 2A 01 40 14 2A 10 74 00 28 01 40 10 00 00 00 00 01 04 60 04 21 20 60 02 ?? ?? ?? 0? 44 00 A8 AF 44 00 A8 8F 21 A8 40 00 10 00 A0 12 21 28 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 13 00 06 24 04 00 64 8C 01 00 42 24 08 00 80 14 21 28 40 00 00 00 64 8C 2B 20 A4 02 05 00 80 54 23 A0 85 02 F7 FF 46 14 08 00 63 24 14 00 05 24 23 A0 85 02 19 00 82 2A 43 03 40 50 20 24 14 7C FF 00 84 32 ?? ?? ?? 0? 44 00 A8 AF 21 28 40 00 ?? ?? ?? 0? 21 20 60 02 20 24 14 7C ?? ?? ?? 0? 21 98 40 00 21 F0 40 00 E7 FE 80 12 44 00 A8 8F 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 44 00 A8 AF 21 28 40 00 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 C0 03 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 00 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 A8 40 00 25 10 43 00 21 F0 00 00 12 00 40 10 44 00 A8 8F ?? ?? ?? 0? 18 00 B5 8F 21 20 A0 02 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 A8 40 00 ?? ?? ?? 0? 21 F0 60 00 25 10 43 00 C0 FE 40 14 44 00 A8 8F FF FF 94 26 EF FF 80 16 21 28 C0 03 18 00 B5 8F 0A 00 A2 2A BE FE 40 14 21 20 60 02 ?? ?? 03 3C ?? ?? 63 24 34 00 A4 8F 00 00 65 8C ?? ?? ?? 0? 44 00 A8 AF 59 01 40 04 44 00 A8 8F EE FF B5 26 18 00 B5 AF 20 24 15 7C ?? ?? ?? 0? 44 00 A8 AF 21 28 40 00 21 20 60 02 ?? ?? ?? 0? 34 00 A2 AF ?? ?? ?? 0? 21 20 40 00 44 00 A8 8F 21 20 00 00 21 F0 40 00 21 98 40 00 24 00 A4 AF 01 00 03 24 0A 00 C2 2F A2 03 40 14 10 00 A3 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 09 24 02 00 04 24 ?? ?? ?? 0? 12 00 07 24 21 48 80 00 04 00 65 8C 42 02 A0 14 02 00 46 24 00 00 65 8C 2B 28 C5 03 3E 02 A0 14 01 00 84 24 01 00 42 24 20 24 04 7C F5 FF 47 14 08 00 63 24 10 00 A4 A3 14 00 06 24 23 A8 15 01 23 A8 B4 02 2B 10 14 00 23 A8 A6 02 03 00 C3 32 23 A8 A2 02 2B 18 03 00 04 00 C2 32 EC 01 40 10 23 A8 A3 02 02 00 C2 32 D4 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 A0 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 08 00 D6 32 20 00 B6 AF ?? ?? 07 3C ?? ?? ?? 0? ?? ?? F6 24 C0 18 03 00 21 18 C3 02 00 00 66 8C 04 00 67 8C 21 20 60 02 ?? ?? ?? 0? 21 28 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 82 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 82 2A C4 01 40 14 20 14 14 7C 12 00 02 24 10 00 A2 A3 EE FF 94 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 24 00 A5 8F ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 FF FF 62 26 20 14 02 7C 21 40 00 00 25 00 60 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 7E 24 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 C0 02 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B3 83 44 00 A8 8F 27 10 02 00 C0 18 13 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 C0 02 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 FF FF 62 26 20 14 02 7C 21 40 60 00 DF FF 60 16 10 00 A2 A3 0A 00 80 12 20 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A4 8F D0 FC 80 50 00 00 24 82 CE FC A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 61 02 80 16 21 10 00 00 10 00 A2 A3 21 20 60 02 21 28 00 00 40 00 A3 AF ?? ?? ?? 0? 44 00 A8 AF 40 00 A3 8F EC 01 40 14 44 00 A8 8F ?? ?? ?? 0? 21 20 60 02 44 00 A8 8F 21 A8 40 00 ?? ?? 02 3C ?? ?? 5E 24 FB FF 08 25 03 00 C3 32 23 98 14 01 2B 18 03 00 04 00 C2 32 C4 01 40 10 23 98 63 02 02 00 C2 32 4F 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 C7 02 60 1A 08 00 C5 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 C7 32 20 00 A7 AF 10 00 A2 83 21 20 A0 02 21 28 00 00 C0 10 02 00 21 10 C2 03 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 41 02 80 16 21 A8 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 7F 02 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 14 24 21 28 40 02 1A 00 54 00 F4 01 80 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A2 8F 51 FC 40 50 00 00 24 82 4F FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 78 00 A4 8F 00 00 93 8C 04 00 84 24 ?? ?? ?? 0? 78 00 A4 AF D4 01 40 04 10 00 62 30 0A 00 40 10 78 00 A7 8F 78 00 A5 8F 21 B0 00 00 00 00 B3 8C 04 00 A5 24 ?? ?? ?? 0? 78 00 A5 AF ED FF B5 26 ?? ?? ?? 0? 18 00 B5 AF 21 B0 00 00 00 00 F3 8C 04 00 E7 24 ?? ?? ?? 0? 78 00 A7 AF 00 00 A4 8C 04 00 A5 24 78 00 A5 AF C3 17 04 00 21 98 80 00 ?? ?? ?? 0? 21 B0 40 00 ?? ?? ?? 0? 21 20 60 02 54 FD 40 14 44 00 A8 8F 02 00 A3 2A 8C FE 60 10 ?? ?? 03 3C ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 44 00 A8 AF 21 28 40 00 ?? ?? ?? 0? 21 20 60 02 21 98 40 00 ?? ?? ?? 0? 44 00 A8 8F 10 00 62 30 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "strerror"
		size = 44
		refs = "000c sys_err"
	strings:
		$1 = { 13 00 82 2C 06 00 40 10 80 20 04 00 ?? ?? 02 3C ?? ?? 42 24 21 20 82 00 08 00 E0 03 00 00 82 8C ?? ?? 02 3C 08 00 E0 03 ?? ?? 42 24 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "fround"
		size = 416
		refs = "002c _npowers_ 004c dpmul"
	strings:
		$1 = { D8 FF BD 27 6E 00 82 2C 14 00 B0 AF 24 00 BF AF 20 00 B3 AF 1C 00 B2 AF 18 00 B1 AF 37 00 40 10 21 80 80 00 0B 00 82 2C 11 00 40 10 ?? ?? 02 3C C0 80 04 00 ?? ?? 42 24 21 80 02 02 ?? ?? 02 3C 00 00 04 8E 04 00 05 8E ?? ?? 46 8C ?? ?? ?? 0? ?? ?? 47 8C 24 00 BF 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 CC CC 02 3C CD CC 42 34 19 00 82 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? 11 3C ?? ?? 31 26 10 18 00 00 C2 90 03 00 FF 00 42 32 09 00 42 24 C0 10 02 00 21 10 51 00 00 00 44 8C ?? ?? ?? 0? 04 00 45 8C 0A 00 04 24 02 28 44 72 21 20 40 00 23 80 05 02 21 28 60 00 FF 00 10 32 C0 80 10 00 21 88 11 02 00 00 26 8E ?? ?? ?? 0? 04 00 27 8E 24 00 BF 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 EB 51 02 3C 1F 85 42 34 19 00 82 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? 11 3C ?? ?? 31 26 10 18 00 00 42 91 03 00 FF 00 42 32 12 00 42 24 C0 10 02 00 21 10 51 00 00 00 44 8C ?? ?? ?? 0? 04 00 45 8C 64 00 06 24 02 20 46 72 CC CC 12 3C CD CC 52 36 21 28 60 00 23 30 04 02 FF 00 C6 30 19 00 D2 00 21 20 40 00 10 38 00 00 F8 07 E2 30 21 10 22 02 48 00 46 8C ?? ?? ?? 0? 4C 00 47 8C 19 00 12 02 21 20 40 00 21 28 60 00 0A 00 02 24 10 98 00 00 C2 18 13 00 02 30 62 70 ?? ?? ?? 0? 23 80 06 02 }
	condition:
		$1
}

rule file_231_2_0 {
	meta:
		name = "_dvfprintf_fFgGs"
		size = 5972
		refs = "009c _ctype 01b0 fputc 03bc dpcmp 0428 dpadd 04ac dpdiv 04b8 __fixunsdfdi 05cc __udivdi3 05e0 __umoddi3 06a8 dpmul 0a00 dptoul 0bb8 __floatundidf 0bd0 dpsub 0fbc frexp 1308 __floatunsidf"
		altNames = "_dvfprintf_fFgG"
	strings:
		$1 = { 98 FF BD 27 4C 00 B3 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 21 98 80 00 21 88 A0 00 70 00 A6 AF 28 00 A0 AF 2C 00 A0 AF 21 80 00 00 00 00 24 82 42 00 80 10 10 00 A4 A3 25 00 02 24 56 00 82 14 01 00 32 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 A8 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 4A 00 45 10 FF FF 71 24 2E 00 44 28 40 00 80 10 00 00 00 00 52 00 46 50 01 00 B5 36 4E 00 48 50 02 00 B5 36 ?? ?? 04 3C ?? ?? 83 24 21 20 62 00 01 00 84 90 02 00 A6 32 FE FF A5 32 0B A8 A6 00 08 00 A6 32 FB FF A5 32 04 00 84 30 46 00 80 10 0B A8 A6 00 21 F0 00 00 0A 00 05 24 02 20 C5 73 01 00 31 26 21 F0 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF DE 27 2E 00 04 24 44 00 44 50 01 00 31 26 00 10 B5 36 21 90 00 00 67 00 03 24 73 00 05 24 6C 00 06 24 10 00 08 24 00 80 07 24 68 00 44 28 10 00 A2 A3 8E 00 43 10 01 00 31 26 4C 00 80 10 00 00 00 00 63 00 03 24 73 02 43 10 64 00 43 28 1A 02 60 50 66 00 03 24 A7 02 40 14 47 00 03 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C5 FF 47 14 ?? ?? 04 3C 04 00 B5 36 01 00 63 24 FF FF 62 80 B8 FF 45 14 FF FF 71 24 08 00 B5 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 C4 FF 44 14 21 F0 00 00 70 00 A5 8F 01 00 31 26 00 00 22 82 00 00 BE 8C 2E 00 04 24 04 00 A5 24 BF FF 44 14 70 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 95 03 44 10 00 40 B5 36 21 20 62 00 01 00 84 90 21 90 00 00 04 00 84 30 B6 FF 80 10 0A 00 05 24 02 20 45 72 01 00 31 26 21 90 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 52 26 ?? ?? ?? 0? 67 00 03 24 1A 02 45 10 74 00 44 28 C9 01 80 50 75 00 03 24 32 00 46 10 10 00 A2 32 10 00 B4 27 01 00 17 24 04 00 40 52 2B 90 FE 02 2B 10 57 02 0B B8 42 02 2B 90 FE 02 23 F0 D7 03 0A F0 12 00 08 00 B6 32 0C 00 C0 16 21 90 C0 03 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 55 16 21 28 60 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 60 02 50 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 21 20 E0 00 0A 20 02 01 00 00 22 82 25 A8 95 00 FF FF B5 32 68 00 44 28 10 00 A2 A3 74 FF 43 14 01 00 31 26 00 02 B5 36 00 07 A2 32 16 01 40 10 21 B0 A0 02 00 10 A4 32 06 00 03 24 10 00 A2 32 C9 01 40 10 0B 90 64 00 70 00 A4 8F F8 FF 02 24 07 00 83 24 24 10 62 00 00 00 46 8C 04 00 54 8C 08 00 45 24 70 00 A5 AF 20 00 A6 AF 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 00 41 04 20 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 B6 36 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF EF 02 40 14 21 B8 00 00 00 02 C2 32 70 01 40 14 FC FF E2 2A 19 00 42 2A 0C 00 40 10 18 00 A8 8F ?? ?? ?? 0? FF 00 44 32 20 00 A6 8F 21 28 80 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 20 00 A2 AF 21 A0 60 00 18 00 A8 8F 0A 00 02 29 C9 01 40 14 20 00 A3 8F 28 00 A3 8F 2C 00 A2 8F 3C 00 A8 AF 21 20 60 00 ?? ?? 03 3C ?? ?? 63 24 00 00 66 8C 04 00 67 8C ?? ?? ?? 0? 21 28 40 00 E3 03 41 04 3C 00 A8 8F ED FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 3C 00 A8 AF 2C 00 A3 AF 20 00 A6 8F 21 18 40 00 28 00 A2 AF 2C 00 A2 8F 21 20 C0 00 21 28 80 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 3C 00 A8 8F 21 B8 40 00 21 A8 60 00 20 00 A0 AF 24 00 A0 AF 01 00 02 24 8D 04 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 02 00 47 24 01 00 84 24 2B 30 A5 02 E1 02 C0 14 01 00 42 24 DC 02 B5 50 00 00 65 8C 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 A0 C8 03 23 A0 92 02 2B 10 12 00 23 A0 87 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 7B 02 40 10 23 A0 83 02 02 00 C2 32 C6 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 1A 08 00 DE 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 DE 32 ?? ?? 16 3C ?? ?? ?? 0? ?? ?? D6 26 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 E0 02 21 28 A0 02 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 C6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A 33 02 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 21 28 60 00 24 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 27 00 A0 12 10 00 A2 A3 ?? ?? 15 3C ?? ?? B5 26 21 40 60 00 21 B8 C0 02 C0 10 02 00 21 10 A2 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B6 83 3C 00 A8 8F 27 10 02 00 C0 18 16 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF C2 26 20 14 02 7C 21 40 60 00 DF FF C0 16 10 00 A2 A3 09 00 40 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 2D FE C0 53 00 00 24 82 2B FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 15 7C 34 02 40 04 10 00 A2 32 DF 00 40 10 70 00 A2 8F 70 00 A6 8F 21 B8 00 00 00 00 D4 8C 04 00 C6 24 70 00 A6 AF 03 00 40 16 C0 00 B6 32 25 90 97 02 01 00 52 2E 80 00 02 24 A4 01 C2 12 C0 00 02 24 8D 01 C2 12 10 00 A2 83 2A 18 52 00 75 01 60 10 2A 18 42 02 20 14 12 7C 10 00 A2 A3 05 00 C0 13 00 40 A3 32 03 00 A3 32 2B 18 03 00 23 F0 C3 03 00 40 A3 32 05 00 60 10 2A 20 5E 00 2A 18 5E 02 23 F0 D2 03 0A F0 03 00 2A 20 5E 00 23 10 C2 03 0A 10 04 00 04 00 A3 32 64 01 60 10 20 00 A2 AF 02 00 A2 32 25 02 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A3 8F 0C 00 60 50 08 00 B5 32 20 00 BE 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 20 00 BE AF 08 00 B5 32 24 00 B5 AF FF FF 48 26 C0 10 08 00 ?? ?? 15 3C 80 40 08 00 13 00 00 01 ?? ?? B5 26 40 18 17 00 21 40 40 02 30 00 B1 AF 21 A8 A2 02 80 00 1E 24 21 88 60 00 11 00 00 11 12 90 00 00 19 01 DE 12 FF FF 08 25 C0 00 02 24 24 01 C2 52 00 00 A6 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F1 FF 00 15 FC FF 52 26 24 00 A4 8F BA FD 80 10 30 00 B1 8F 20 00 A5 8F B7 FD A0 18 21 90 A0 00 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 74 FE 43 50 C0 00 B5 36 78 00 03 24 37 FE 43 14 10 00 B4 27 ?? ?? ?? 0? 80 00 B5 36 33 FE 43 14 10 00 B4 27 ?? ?? ?? 0? 00 04 B5 36 8E 00 40 10 2A 10 F2 02 B6 02 40 16 21 10 00 00 10 00 A2 A3 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 35 02 40 14 10 00 AA 83 20 00 A2 8F 21 28 80 02 ?? ?? 15 3C ?? ?? ?? 0? 21 20 40 00 18 00 B7 8F 20 00 A2 AF ?? ?? B5 26 FB FF D4 27 03 00 C2 32 63 00 E3 26 2B 10 02 00 23 A0 92 02 C7 00 63 2C 23 A0 82 02 01 00 63 2C 04 00 C2 32 B7 01 40 10 23 A0 83 02 02 00 C2 32 BA 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 2B 03 80 1A 08 00 C4 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 C5 32 ?? ?? ?? 0? 24 00 A5 AF 70 00 A2 8F 07 00 43 24 F8 FF 02 24 24 10 62 00 00 00 43 8C 04 00 54 8C 08 00 42 24 20 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 70 00 A5 8F 00 00 A3 8C 04 00 A4 24 98 02 60 10 21 A0 60 00 00 00 62 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 77 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A4 AF 70 00 A3 8F 10 00 A4 32 01 00 62 80 00 00 65 8C 04 00 63 24 91 00 80 10 10 00 A2 A3 90 00 40 50 14 00 A5 A3 FF FF 04 24 8D 00 44 50 14 00 A5 A3 14 00 A2 A3 15 00 A5 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF 21 B8 00 00 00 00 54 8C 04 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 3C 00 A8 AF 22 02 40 10 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 B8 40 00 25 10 43 00 21 A8 60 00 04 00 40 14 3C 00 A8 8F 02 00 02 29 27 FE 40 10 28 00 A3 8F 21 20 E0 02 ?? ?? ?? 0? 21 28 A0 02 20 00 A6 8F 21 28 80 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 20 00 A2 AF 24 00 A3 AF 18 00 A0 AF ?? ?? ?? 0? 21 40 00 00 A4 FD 43 14 10 00 B4 27 ?? ?? ?? 0? 20 00 B5 36 72 FF 40 10 00 00 00 00 B7 02 E0 06 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 B8 40 00 21 A8 60 00 25 10 F5 02 0F 00 40 10 21 30 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 13 00 07 24 04 00 64 8C 01 00 42 24 2B 28 A4 02 06 00 A0 14 21 30 40 00 3F 02 95 50 00 00 64 8C F8 FF 47 14 08 00 63 24 14 00 06 24 23 90 46 02 19 00 42 2A FE 01 40 10 00 00 00 00 ?? ?? ?? 0? FF 00 44 32 20 00 A6 8F 21 28 80 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 20 40 02 20 00 A2 AF ?? ?? ?? 0? 21 A0 60 00 21 40 40 00 E3 FD 40 12 21 48 60 00 21 20 E0 02 21 28 A0 02 3C 00 A8 AF ?? ?? ?? 0? 38 00 A9 AF 20 00 A7 8F 21 28 80 02 21 30 40 00 21 20 E0 00 ?? ?? ?? 0? 21 38 60 00 3C 00 A8 8F 38 00 A9 8F 21 20 40 00 21 28 60 00 21 30 00 01 ?? ?? ?? 0? 21 38 20 01 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 28 A0 02 21 20 E0 02 0A 00 06 24 C7 FD 40 12 21 38 00 00 ?? ?? ?? 0? 00 00 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 B8 40 00 ?? ?? ?? 0? 21 A8 60 00 25 10 43 00 F0 FF 40 50 FF FF 52 26 18 00 A8 8F 0A 00 02 29 BC FD 40 50 28 00 A3 8F ?? ?? ?? 0? 20 00 A3 8F 14 00 A5 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF 27 18 12 00 04 18 71 00 06 10 54 02 20 00 44 32 25 10 62 00 06 18 57 02 0B 10 64 00 ?? ?? 03 3C 0F 00 42 30 ?? ?? 63 24 21 10 62 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 3C 00 A8 8F ?? ?? ?? 0? 0B 90 43 00 20 00 A4 8F B5 00 80 14 08 00 A6 32 08 00 A5 32 24 00 A5 AF 02 00 A2 32 AC 00 40 50 01 00 B5 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 01 00 02 24 38 02 E0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 02 00 06 24 02 00 02 24 ?? ?? ?? 0? 14 00 07 24 21 30 40 00 04 00 64 8C 01 00 42 24 2B 28 E4 02 87 01 A0 14 20 14 02 7C 82 01 97 50 00 00 64 8C F7 FF 47 14 08 00 63 24 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 28 02 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 19 04 00 02 00 02 24 02 47 04 00 25 40 06 01 01 00 42 24 21 30 60 00 2B 18 E5 02 02 00 09 24 10 00 0A 24 20 14 02 7C 11 00 60 14 21 38 00 01 79 01 E5 52 2B 20 84 02 E9 FF 4A 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 19 04 00 02 47 04 00 25 40 06 01 21 48 40 00 21 30 60 00 01 00 42 24 2B 18 E5 02 20 14 02 7C F1 FF 60 10 21 38 00 01 10 00 A9 A3 ?? ?? ?? 0? 21 10 20 01 10 00 A2 A3 CF FD 40 14 23 90 42 02 FF FF 02 24 ?? ?? ?? 0? 10 00 A2 A3 08 00 DE 32 0C 00 C0 17 02 00 C2 32 0A 00 80 1A 00 00 00 00 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 C2 32 36 01 40 50 01 00 D6 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 20 00 A3 8F 21 28 80 02 18 00 A6 27 ?? ?? ?? 0? 21 20 60 00 18 00 B7 8F 03 00 03 24 0A 00 02 24 FF FF F7 26 02 B8 E3 72 1A 00 E2 02 F4 01 40 00 12 B8 00 00 C7 01 E0 06 18 00 B7 AF ?? ?? ?? 0? 23 20 17 00 21 28 60 00 20 00 A3 8F 21 20 40 00 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "strcspn"
		size = 108
		refs = "0040 strchr"
	strings:
		$1 = { E0 FF BD 27 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 1C 00 BF AF 00 00 82 80 21 88 80 00 21 80 A0 00 05 00 40 14 21 90 00 00 ?? ?? ?? 0? 1C 00 BF 8F 07 00 40 10 01 00 52 26 21 28 40 00 21 20 00 02 ?? ?? ?? 0? 01 00 31 26 F9 FF 40 50 00 00 22 82 1C 00 BF 8F 21 10 40 02 14 00 B1 8F 18 00 B2 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "div"
		size = 32
		altNames = "ldiv"
	strings:
		$1 = { 1A 00 A6 00 F4 01 C0 00 21 10 80 00 10 18 00 00 04 00 83 AC 12 28 00 00 08 00 E0 03 00 00 85 AC }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "_doatexit"
		size = 80
	strings:
		$1 = { E0 FF BD 27 18 00 B1 AF 14 00 B0 AF ?? ?? 11 3C ?? ?? 10 3C 1C 00 BF AF ?? ?? 31 26 ?? ?? 10 26 00 00 22 8E 03 00 40 10 00 00 00 00 09 F8 40 00 00 00 00 00 FA FF 30 16 FC FF 31 26 1C 00 BF 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_272_1_0 {
	meta:
		name = "atexit"
		size = 104
		refs = "0000 _atexitptr"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 8C 12 00 60 50 ?? ?? 03 3C ?? ?? 07 3C ?? ?? E7 24 21 10 E0 00 21 18 00 00 ?? ?? ?? 0? 20 00 06 24 01 00 63 24 0C 00 66 50 FF FF 02 24 00 00 45 8C FB FF A0 14 04 00 42 24 80 18 03 00 21 38 E3 00 00 00 E4 AC 08 00 E0 03 21 10 00 00 ?? ?? 63 24 ?? ?? ?? 0? ?? ?? 43 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "strchr"
		size = 40
	strings:
		$1 = { 21 10 80 00 20 2C 05 7C 00 00 43 80 04 00 65 10 00 00 00 00 FC FF 60 54 01 00 42 24 21 10 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_276_2_0 {
	meta:
		name = "_vfprintf_eEfFgG"
		size = 5592
		refs = "009c _ctype 01bc fputc 03a8 __floatdisf 03b8 fpcmp 0454 fptoui 0508 __udivdi3 0540 __umoddi3 0950 fpdiv 0968 __floatunsisf 0974 fpsub 0998 fpadd 0d50 fpmul 103c __floatundisf 115c frexpf"
		altNames = "_vfprintf_eEfFgGs"
	strings:
		$1 = { 98 FF BD 27 21 10 00 00 4C 00 B3 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 21 98 80 00 21 88 A0 00 70 00 A6 AF 2C 00 A2 AF 21 80 00 00 00 00 24 82 45 00 80 10 10 00 A4 A3 25 00 02 24 59 00 82 14 01 00 32 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 B0 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 4D 00 45 10 FF FF 71 24 2E 00 44 28 43 00 80 10 00 00 00 00 55 00 46 50 01 00 D6 36 51 00 48 50 02 00 D6 36 ?? ?? 04 3C ?? ?? 84 24 21 18 82 00 01 00 63 90 02 00 C5 32 FE FF C4 32 0B B0 85 00 08 00 C5 32 FB FF C4 32 04 00 63 30 49 00 60 10 0B B0 85 00 21 A0 00 00 0A 00 04 24 02 18 84 72 01 00 31 26 ?? ?? 05 3C ?? ?? A5 24 21 A0 62 00 00 00 22 82 21 18 A2 00 01 00 63 90 04 00 63 30 F6 FF 60 14 D0 FF 94 26 2E 00 03 24 45 00 43 50 01 00 31 26 00 10 D6 36 21 90 00 00 66 00 03 24 73 00 05 24 67 00 06 24 6C 00 07 24 10 00 09 24 00 80 08 24 67 00 44 28 10 00 A2 A3 9A 03 43 10 01 00 31 26 50 00 80 10 00 00 00 00 47 00 03 24 86 00 43 10 48 00 43 28 CB 01 60 50 63 00 03 24 66 03 40 14 45 00 03 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C2 FF 47 14 ?? ?? 04 3C 04 00 D6 36 01 00 63 24 FF FF 62 80 B5 FF 45 14 FF FF 71 24 08 00 D6 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 03 24 C3 FF 43 14 21 A0 00 00 70 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D4 8C 2E 00 03 24 04 00 C6 24 BE FF 43 14 70 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 03 24 1A 04 43 10 00 40 D6 36 ?? ?? 04 3C ?? ?? 84 24 21 18 82 00 01 00 63 90 21 90 00 00 04 00 63 30 B3 FF 60 10 0A 00 04 24 02 18 44 72 01 00 31 26 ?? ?? 05 3C ?? ?? A5 24 21 90 62 00 00 00 22 82 21 18 A2 00 01 00 63 90 04 00 63 30 F6 FF 60 14 D0 FF 52 26 ?? ?? ?? 0? 66 00 03 24 D2 03 45 10 74 00 44 28 83 01 80 50 75 00 03 24 36 00 46 10 00 02 DE 36 38 03 47 10 10 00 C2 32 10 00 B5 27 01 00 17 24 04 00 40 52 2B 90 F4 02 2B 10 57 02 0B B8 42 02 2B 90 F4 02 23 A0 97 02 0A A0 12 00 08 00 D6 32 0C 00 C0 16 21 90 80 02 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? FF FF 14 24 00 00 A4 82 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F4 16 21 28 60 02 47 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 20 00 D6 36 00 02 DE 36 00 07 C2 33 AF 00 40 10 20 00 BE AF 00 10 C4 33 06 00 03 24 10 00 C2 33 1B 01 40 10 0B 90 64 00 70 00 A2 8F 07 00 43 24 F8 FF 02 24 24 10 62 00 00 00 44 8C 04 00 45 8C 08 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 21 A8 40 00 21 20 A0 02 ?? ?? ?? 0? 21 28 00 00 06 00 41 04 21 20 A0 02 00 80 02 3C 03 00 DE 37 26 A8 55 00 20 00 BE AF 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF 5B 03 40 14 21 B0 00 00 20 00 A3 8F 00 01 62 30 08 00 40 14 00 02 62 30 BA 01 40 10 19 00 42 2A FC FF C2 2A 03 00 40 14 2A 10 D2 02 E4 02 40 14 00 00 00 00 77 01 40 12 21 10 00 00 20 00 A4 8F 40 02 82 7C 23 90 42 02 13 00 42 2E 70 01 40 14 12 00 02 24 10 00 A2 A3 21 20 A0 02 ?? ?? ?? 0? 21 28 00 00 3A 01 40 14 10 00 A3 83 ?? ?? ?? 0? 21 20 A0 02 ?? ?? 05 3C 21 A8 40 00 ?? ?? BE 24 20 00 A5 8F FB FF 94 26 23 A0 92 02 03 00 A3 30 2B 18 03 00 04 00 A2 30 10 01 40 10 23 A0 83 02 02 00 A2 30 AC 02 40 10 20 00 A6 8F 01 00 A4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 34 04 80 1A 20 00 A2 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A3 8F 08 00 63 30 28 00 A3 AF 10 00 A2 83 21 20 A0 02 21 28 00 00 C0 10 02 00 21 10 C2 03 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 57 03 40 16 21 B0 60 00 20 00 A3 8F 20 00 62 30 02 00 40 14 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 90 03 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 12 24 21 28 60 02 1A 00 52 00 F4 01 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 72 00 F4 01 40 02 21 28 60 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 28 00 A2 8F 93 FE 40 50 00 00 24 82 91 FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 1E 7C 0D 03 40 04 10 00 C2 33 9C 00 40 10 70 00 A5 8F 70 00 A4 8F 21 B8 00 00 00 00 95 8C 04 00 84 24 70 00 A4 AF 03 00 40 16 C0 00 D6 33 25 90 B7 02 01 00 52 2E 80 00 02 24 E5 00 C2 12 C0 00 02 24 08 01 C2 12 10 00 A2 83 2A 18 52 00 61 00 60 10 2A 18 42 02 20 14 12 7C 10 00 A2 A3 05 00 80 12 00 40 C3 33 03 00 C3 33 2B 18 03 00 23 A0 83 02 00 40 C3 33 05 00 60 10 2A 20 54 00 2A 18 54 02 23 A0 92 02 0A A0 03 00 2A 20 54 00 23 10 82 02 0A 10 04 00 04 00 C3 33 50 00 60 10 20 00 A2 AF 02 00 C2 33 F6 01 40 10 01 00 C2 33 01 00 C4 33 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 20 00 A6 8F 27 10 02 00 2B 10 02 00 0B 00 C0 10 21 80 02 02 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 20 00 A3 AF F7 FF 60 14 21 80 02 02 08 00 DE 33 FF FF 48 26 ?? ?? 04 3C C0 A0 08 00 28 00 BE AF 40 28 17 00 ?? ?? 9E 24 21 A0 D4 03 80 40 08 00 80 00 1E 24 24 00 A5 AF 12 00 40 12 28 00 A4 8F 5C 02 DE 12 FF FF 52 26 C0 00 06 24 68 02 C6 52 00 00 86 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 34 00 A8 AF 34 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 94 26 F1 FF 40 16 FC FF 08 25 28 00 A4 8F 25 FE 80 50 00 00 24 82 20 00 A5 8F 22 FE A0 58 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A6 8F 27 10 02 00 2B 10 02 00 FF FF C6 24 20 00 A6 AF F7 FF C0 14 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A3 8F 00 00 75 8C 04 00 63 24 ?? ?? ?? 0? 70 00 A3 AF ?? ?? ?? 0? 0B 90 43 00 20 00 A4 8F 93 01 80 14 08 00 C6 33 08 00 C5 33 28 00 A5 AF 02 00 C2 33 9E 01 40 50 01 00 DE 33 01 00 C4 33 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 48 26 ?? ?? 04 3C C0 A0 08 00 ?? ?? 9E 24 40 28 17 00 21 A0 D4 03 80 40 08 00 80 00 1E 24 ?? ?? ?? 0? 24 00 A5 AF 63 02 43 10 65 00 03 24 86 FE 43 14 10 00 B5 27 ?? ?? ?? 0? 00 01 DE 36 5B 02 43 10 78 00 03 24 80 FE 43 14 10 00 B5 27 ?? ?? ?? 0? 80 00 DE 36 21 B8 00 00 00 00 B5 8C 04 00 A5 24 ?? ?? ?? 0? 70 00 A5 AF 20 00 A4 8F 08 00 84 30 0B 00 80 14 28 00 A4 AF 0A 00 80 1A 20 00 A5 8F 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A5 8F 02 00 A2 30 93 01 40 10 20 00 A6 8F 01 00 A4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 ?? ?? 1E 3C 23 20 C3 02 20 24 04 7C ?? ?? ?? 0? 38 00 A3 AF 21 28 40 00 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 ?? ?? ?? 0? 21 B8 40 00 21 20 40 00 ?? ?? ?? 0? 34 00 A2 AF 21 28 40 00 ?? ?? ?? 0? 21 20 E0 02 ?? ?? C4 8F ?? ?? ?? 0? 21 28 40 00 38 00 A3 8F 09 00 40 1C 34 00 A6 8F ?? ?? C5 8F ?? ?? ?? 0? 21 20 E0 02 21 20 40 00 ?? ?? ?? 0? 21 B8 40 00 38 00 A3 8F 21 30 40 00 ?? ?? 04 3C 01 00 62 24 ?? ?? 9E 24 C0 10 02 00 21 10 C2 03 04 00 44 8C 4E 01 80 10 21 A8 C0 00 C0 18 03 00 21 18 C3 03 04 00 62 8C 90 02 40 50 00 00 62 8C ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? FF FF D6 26 21 10 40 02 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 E9 02 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 19 04 00 02 00 02 24 02 47 04 00 25 40 06 01 01 00 42 24 21 30 60 00 2B 18 E5 02 02 00 09 24 10 00 0A 24 20 14 02 7C 11 00 60 14 21 38 00 01 46 01 E5 52 2B 20 A4 02 23 00 4A 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 19 04 00 02 47 04 00 25 40 06 01 21 48 40 00 21 30 60 00 01 00 42 24 2B 18 E5 02 20 14 02 7C F1 FF 60 10 21 38 00 01 10 00 A9 A3 ?? ?? ?? 0? 21 10 20 01 01 00 02 24 C9 02 E0 12 10 00 A2 A3 ?? ?? 04 3C ?? ?? 83 24 02 00 06 24 02 00 02 24 ?? ?? ?? 0? 14 00 07 24 21 30 40 00 04 00 64 8C 01 00 42 24 2B 28 E4 02 48 02 A0 14 20 14 02 7C 43 02 97 50 00 00 64 8C F7 FF 47 14 08 00 63 24 ?? ?? ?? 0? 10 00 A2 A3 60 02 40 14 00 00 00 00 18 00 B7 8F 0A 00 E2 2A 0E 00 40 10 ?? ?? 02 3C 21 20 A0 02 ?? ?? ?? 0? 21 28 00 00 49 02 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 A0 02 48 02 40 14 21 20 40 00 02 00 E3 2A 46 02 60 14 21 28 00 00 ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 2C 00 A4 8F 35 02 42 04 ED FF F7 26 EE FF F7 26 18 00 B7 AF ?? ?? ?? 0? 20 24 17 7C 21 28 40 00 21 20 A0 02 ?? ?? ?? 0? 2C 00 A2 AF ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 21 A8 40 00 21 F0 00 00 01 00 03 24 0A 00 C2 2E 87 02 40 14 10 00 A3 A3 ?? ?? 02 3C ?? ?? 45 24 02 00 08 24 21 10 00 00 02 00 03 24 12 00 07 24 04 00 A4 8C 02 00 46 24 01 00 63 24 5D 02 80 14 01 00 42 24 00 00 A4 8C 20 1C 03 7C 2B 20 C4 02 58 02 80 14 08 00 A5 24 F5 FF 47 54 21 40 60 00 10 00 A3 A3 14 00 06 24 20 00 A4 8F 23 A0 97 02 23 A0 92 02 2B 10 12 00 23 A0 86 02 03 00 83 30 23 A0 82 02 2B 18 03 00 04 00 82 30 26 02 40 10 23 A0 83 02 02 00 82 30 4C 02 40 10 20 00 A5 8F 01 00 84 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 56 02 80 1A 20 00 A6 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A2 8F 08 00 42 30 24 00 A2 AF ?? ?? 06 3C ?? ?? ?? 0? ?? ?? D6 24 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 A0 02 21 28 00 00 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 C6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A FF 01 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 ?? ?? ?? 0? 21 28 C0 03 ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 21 B8 00 00 23 00 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 7E 24 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 20 C0 02 ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B5 83 27 10 02 00 2B 10 02 00 C0 18 15 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 28 E0 02 21 20 C0 02 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 FF FF A2 26 20 14 02 7C 21 B8 60 00 E1 FF A0 16 10 00 A2 A3 0A 00 40 12 24 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 24 00 A4 8F 86 FC 80 50 00 00 24 82 84 FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 6F FE C0 14 28 00 A6 AF 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 20 00 A3 AF F7 FF 60 14 21 80 02 02 02 00 C2 33 66 FE 40 14 01 00 C4 33 01 00 DE 33 6D FE C0 53 FF FF 48 26 ?? ?? ?? 0? 20 00 04 24 B0 01 40 14 20 00 A6 8F 1F FE C0 50 08 00 DE 33 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 20 00 A3 AF 0A FE 60 14 21 80 02 02 ?? ?? ?? 0? 08 00 DE 33 EB FC 43 14 10 00 B5 27 20 00 D6 36 ?? ?? ?? 0? 00 01 DE 36 00 00 42 8C 2B 10 C2 00 B1 FE 40 14 C0 18 03 00 ?? ?? 02 3C ?? ?? 45 8C 01 00 D6 26 21 20 E0 02 ?? ?? ?? 0? 18 00 B6 AF ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 A8 40 00 01 00 C2 30 5D FD 40 10 20 00 04 24 ?? ?? ?? 0? 00 00 00 00 01 00 C2 30 66 FD 40 10 10 00 A2 83 ?? ?? ?? 0? 20 00 04 24 BA FE 80 10 00 00 00 00 10 00 A9 A3 ?? ?? ?? 0? 21 10 20 01 21 20 00 01 0A 20 22 01 00 00 22 82 25 B0 96 00 FF FF D6 32 67 00 44 28 10 00 A2 A3 68 FC 43 14 01 00 31 26 ?? ?? ?? 0? 00 04 DE 36 38 01 C2 06 21 20 A0 02 ?? ?? ?? 0? 21 20 A0 02 21 B8 40 00 10 00 E0 12 21 20 00 00 ?? ?? 05 3C ?? ?? A5 24 21 10 00 00 13 00 06 24 04 00 A3 8C 01 00 42 24 08 00 60 14 21 20 40 00 00 00 A3 8C 2B 18 E3 02 04 00 60 14 08 00 A5 24 F8 FF 46 54 04 00 A3 8C 14 00 04 24 }
	condition:
		$1
}

rule file_279_1_0 {
	meta:
		name = "_vfprintf_cdeEfFnopsuxX"
		size = 6268
		refs = "009c _ctype 0164 fputc 0464 __floatdisf 047c fpcmp 04e0 fptoui 0594 __udivdi3 05d0 __umoddi3 0a24 _npowers_f 0a4c fpmul 0ad8 fpadd 0b50 fpdiv 0e94 frexpf 0f48 __floatunsisf 0f54 fpsub 11fc __floatundisf"
		altNames = "_vfprintf_cdeEfFnopuxX"
	strings:
		$1 = { 98 FF BD 27 21 10 00 00 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 30 00 A2 AF 21 80 00 00 00 00 24 82 68 00 80 10 10 00 A4 A3 25 00 02 24 37 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 2B 02 46 10 FF FF 91 24 2E 00 45 28 21 02 A0 10 00 00 00 00 33 02 47 50 01 00 63 34 2F 02 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A5 24 21 20 A2 00 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 27 02 80 10 0B 18 A6 00 21 98 00 00 0A 00 05 24 02 20 65 72 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 98 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF 73 26 2E 00 04 24 23 02 44 50 01 00 31 26 00 10 63 34 21 B8 00 00 10 00 07 24 00 80 06 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3D 00 A0 14 01 00 31 26 10 00 B4 27 01 00 1E 24 04 00 E0 12 2B 10 D3 03 2B 10 FE 02 0B F0 E2 02 2B 10 D3 03 08 00 76 30 23 98 7E 02 0B 00 C0 16 0A 98 02 00 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 75 16 20 00 04 24 ?? ?? ?? 0? FF FF 15 24 21 28 40 02 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D5 57 00 00 84 82 A5 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9A FF 80 14 10 00 A4 A3 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 ?? ?? 08 3C 80 20 04 00 ?? ?? 08 25 21 20 04 01 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 00 63 34 00 07 62 30 A9 00 40 10 21 A8 60 00 00 10 65 30 06 00 04 24 10 00 62 30 85 02 40 10 0B B8 85 00 70 00 A5 8F F8 FF 02 24 07 00 A4 24 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 38 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 38 00 A3 8F 21 A0 40 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 A0 54 00 03 00 75 34 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF 79 02 40 14 21 B0 00 00 00 01 A2 32 50 01 40 10 19 00 E2 2A 13 00 E2 2E 90 02 40 10 12 00 02 24 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 10 00 B7 A3 90 02 40 14 10 00 A6 83 ?? ?? ?? 0? 21 20 80 02 21 A0 40 00 ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF 73 26 03 00 A3 32 23 98 77 02 2B 18 03 00 04 00 A2 32 C0 02 40 10 23 98 63 02 02 00 A2 32 67 04 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 BB 04 60 1A 08 00 A2 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 A3 32 24 00 A3 AF 10 00 A2 83 20 00 A6 8F 21 20 80 02 C0 10 02 00 21 10 C2 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 20 00 A7 8F 27 10 02 00 C0 18 03 00 21 18 E3 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A0 40 00 E6 03 E0 16 21 B0 60 00 20 00 B5 32 02 00 A0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 22 04 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 14 24 21 28 40 02 1A 00 54 00 F4 01 80 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 24 00 A2 8F 70 FE 40 50 00 00 24 82 6E FE 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 63 34 80 00 63 34 00 07 62 30 59 FF 40 14 21 A8 60 00 C0 00 62 30 E4 01 40 14 20 16 03 7C D8 03 40 04 10 00 62 30 65 02 40 10 70 00 A8 8F 70 00 A7 8F 00 00 E4 8C 04 00 E7 24 70 00 A7 AF C3 17 04 00 21 A0 80 00 75 02 40 04 21 B0 40 00 03 00 E0 16 C0 00 75 30 25 B8 96 02 01 00 F7 2E 40 00 02 24 55 03 A2 12 41 00 A2 2A 18 03 40 10 80 00 02 24 16 00 A0 16 10 00 BE 83 01 00 02 24 40 04 C0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 42 24 02 00 06 24 02 00 1E 24 ?? ?? ?? 0? 14 00 07 24 21 30 C0 03 04 00 44 8C 2B 28 C4 02 07 04 A0 54 10 00 A6 A3 01 04 96 50 00 00 44 8C 01 00 DE 27 20 F4 1E 7C F6 FF C7 17 08 00 42 24 10 00 BE A3 2A 10 D7 03 FC 02 40 10 2A 10 FE 02 20 F4 17 7C 10 00 BE A3 05 00 60 12 00 40 62 30 03 00 62 30 2B 10 02 00 23 98 62 02 00 40 62 30 05 00 40 10 2A 20 D3 03 2A 10 F3 02 23 98 77 02 0A 98 02 00 2A 20 D3 03 04 00 62 30 23 F0 7E 02 C0 02 40 10 0A F0 04 00 02 00 62 30 44 03 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 64 30 61 02 C0 17 2C 00 A4 AF FF FF F7 26 03 00 02 24 ?? ?? 07 3C C0 98 17 00 ?? ?? E7 24 80 40 17 00 41 00 A4 2A 02 B8 E2 72 20 00 63 30 40 10 16 00 21 98 F3 00 24 00 A2 AF 20 00 A4 AF ?? ?? ?? 0? 28 00 A3 AF 10 00 A0 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 80 02 21 28 C0 02 ?? ?? ?? 0? 34 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 34 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 34 00 A8 AF 34 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF F7 26 FD FF 02 24 73 02 E2 12 40 00 02 24 65 02 A2 12 20 00 A5 8F DF FF A0 14 80 00 02 24 4E 02 A2 12 C0 00 02 24 DD FF A2 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 63 34 ?? ?? ?? 0? 00 01 63 34 E4 FD 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 D7 FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 E5 FD 44 14 21 98 00 00 70 00 A7 8F 01 00 31 26 00 00 22 82 00 00 F3 8C 2E 00 04 24 04 00 E7 24 E0 FD 44 14 70 00 A7 AF 01 00 31 26 00 00 22 82 2A 00 04 24 E8 02 44 10 00 40 63 34 ?? ?? 08 3C ?? ?? 08 25 21 20 02 01 01 00 84 90 21 B8 00 00 04 00 84 30 D5 FD 80 10 0A 00 05 24 02 20 E5 72 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 B8 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF F7 26 ?? ?? ?? 0? 10 00 07 24 3B 00 40 10 0A 00 C2 2A FF 00 FE 32 6E 00 C2 2F 2F 03 40 14 0B 00 C2 2F EB 51 02 3C 1F 85 42 34 19 00 C2 03 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 03 3C ?? ?? 63 24 38 00 A3 AF 10 48 00 00 42 31 09 00 FF 00 C2 30 12 00 42 24 80 10 02 00 21 10 43 00 00 00 44 8C ?? ?? ?? 0? 34 00 A6 AF 34 00 A6 8F 64 00 04 24 CC CC 07 3C 02 28 C4 70 CD CC E7 34 21 20 40 00 38 00 A3 8F 34 00 A7 AF 23 30 C5 03 FF 00 C6 30 19 00 C7 00 10 48 00 00 C0 38 22 7D 09 00 42 24 80 10 02 00 21 10 43 00 ?? ?? ?? 0? 00 00 45 8C 34 00 A7 8F 21 20 40 00 0A 00 02 24 19 00 C7 03 38 00 A3 8F 10 38 00 00 C2 28 07 00 02 30 A2 70 23 10 C6 03 FF 00 42 30 80 10 02 00 21 18 43 00 ?? ?? ?? 0? 00 00 65 8C 21 20 80 02 ?? ?? ?? 0? 21 28 40 00 21 A0 40 00 0A 00 C2 2A 0D 00 40 10 ?? ?? 06 3C 21 20 80 02 ?? ?? ?? 0? 21 28 00 00 BB 01 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 80 02 BA 01 40 54 21 20 40 00 02 00 C3 2A B6 01 60 14 ?? ?? 06 3C ?? ?? C6 24 30 00 A4 8F ?? ?? ?? 0? 00 00 C5 8C 60 01 42 04 ED FF D6 26 EE FF D6 26 18 00 B6 AF ?? ?? ?? 0? 20 24 16 7C 21 28 40 00 21 20 80 02 ?? ?? ?? 0? 30 00 A2 AF ?? ?? ?? 0? 21 20 40 00 21 38 00 00 21 F0 40 00 21 A0 40 00 20 00 A7 AF 01 00 03 24 0A 00 C2 2F 2D 03 40 14 10 00 A3 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 04 24 02 00 06 24 ?? ?? ?? 0? 12 00 07 24 21 30 80 00 04 00 65 8C 72 02 A0 14 02 00 48 24 00 00 65 8C 2B 28 C5 03 6E 02 A0 14 01 00 42 24 01 00 C4 24 20 24 04 7C F5 FF 47 14 08 00 63 24 10 00 A4 A3 14 00 08 24 23 98 76 02 23 98 77 02 2B 10 17 00 23 98 68 02 03 00 A3 32 23 98 62 02 2B 18 03 00 04 00 A2 32 05 02 40 10 23 98 63 02 02 00 A2 32 D5 02 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 60 5A 08 00 BE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 BE 32 ?? ?? 08 3C ?? ?? ?? 0? ?? ?? 15 25 C0 18 03 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 21 20 80 02 ?? ?? ?? 0? 21 28 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 E2 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 E2 2A F8 01 40 14 20 14 17 7C 12 00 02 24 10 00 A2 A3 EE FF F7 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 20 00 A5 8F 21 20 40 00 ?? ?? ?? 0? 21 B0 00 00 ?? ?? ?? 0? 21 20 40 00 21 A8 40 00 FF FF 82 26 20 14 02 7C 26 00 80 12 10 00 A2 A3 ?? ?? 09 3C ?? ?? 29 25 20 00 A9 AF 20 00 A3 8F C0 10 02 00 21 20 A0 02 21 10 62 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B4 83 20 00 A4 8F 27 10 02 00 C0 18 14 00 21 18 83 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 C0 02 21 20 A0 02 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 FF FF 82 26 20 14 02 7C 21 B0 60 00 DF FF 80 16 10 00 A2 A3 09 00 E0 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF F7 26 F9 FF E0 16 21 80 02 02 8A FC C0 53 00 00 24 82 88 FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A6 8F 00 00 D4 8C 04 00 C6 24 ?? ?? ?? 0? 70 00 A6 AF 02 02 40 04 10 00 62 30 8B 00 40 10 70 00 A6 8F 70 00 A5 8F 21 B0 00 00 00 00 B4 8C 04 00 A5 24 ?? ?? ?? 0? 70 00 A5 AF 21 20 80 02 ?? ?? ?? 0? 18 00 A5 27 18 00 B6 8F 03 00 03 24 0A 00 02 24 FF FF D6 26 02 B0 C3 72 1A 00 C2 02 F4 01 40 00 12 B0 00 00 39 02 C0 06 18 00 B6 AF 23 20 16 00 ?? ?? ?? 0? 20 24 04 7C 21 20 40 00 ?? ?? ?? 0? 21 28 80 02 30 00 A2 AF ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 30 00 A4 8F 72 00 41 04 ?? ?? 02 3C FF FF D6 26 ?? ?? ?? 0? 18 00 B6 AF 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 10 00 A2 A3 72 FD 40 10 10 00 A6 83 23 20 C6 02 20 24 04 7C ?? ?? ?? 0? 34 00 A6 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 F0 40 00 21 20 40 00 ?? ?? ?? 0? 38 00 A2 AF 21 28 40 00 ?? ?? ?? 0? 21 20 C0 03 ?? ?? 05 3C ?? ?? A4 8C ?? ?? ?? 0? 21 28 40 00 38 00 A3 8F 0A 00 40 1C 34 00 A6 8F ?? ?? 07 3C ?? ?? E5 8C ?? ?? ?? 0? 21 20 C0 03 21 20 40 00 ?? ?? ?? 0? 21 F0 40 00 34 00 A6 8F 21 18 40 00 01 00 C2 24 ?? ?? 08 3C ?? ?? 08 25 C0 10 02 00 21 10 02 01 04 00 44 8C 20 00 A8 AF 57 01 80 14 21 A0 60 00 00 00 42 8C 2B 10 62 00 54 01 40 14 20 00 A9 8F ?? ?? 02 3C ?? ?? 45 8C 01 00 D6 26 21 20 C0 03 ?? ?? ?? 0? 18 00 B6 AF ?? ?? ?? 0? 21 20 40 00 FB FF 73 26 03 00 A3 32 21 A0 40 00 23 98 77 02 }
	condition:
		$1
}

rule file_284_1_0 {
	meta:
		name = "_dvfprintf_cdfFnopsuxX"
		size = 5220
		refs = "009c _ctype 016c fputc 0488 dpcmp 04f4 _npowers_ 0528 dpmul 05c0 dpadd 0604 __fixunsdfdi 0618 __floatundidf 0630 dpsub 0850 __udivdi3 0864 __umoddi3 0af4 dpdiv 111c frexp"
		altNames = "_dvfprintf_cdfFnopuxX"
	strings:
		$1 = { 98 FF BD 27 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 28 00 A0 AF 2C 00 A0 AF 21 80 00 00 00 00 24 82 6C 00 80 10 10 00 A4 A3 25 00 02 24 57 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 4B 02 46 10 FF FF 91 24 2E 00 45 28 41 02 A0 10 00 00 00 00 53 02 47 50 01 00 63 34 4F 02 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A4 24 21 28 82 00 01 00 A5 90 02 00 67 30 FE FF 66 30 0B 18 C7 00 08 00 67 30 FB FF 66 30 04 00 A5 30 47 02 A0 10 0B 18 C7 00 21 F0 00 00 0A 00 06 24 02 28 C6 73 01 00 31 26 21 F0 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF DE 27 2E 00 05 24 45 02 45 50 01 00 31 26 00 10 63 34 21 B8 00 00 ?? ?? 07 3C ?? ?? E6 24 10 00 08 24 00 80 07 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 41 00 A0 14 01 00 31 26 10 00 B3 27 01 00 06 24 04 00 E0 52 2B A0 DE 00 2B 10 E6 02 0B 30 E2 02 2B A0 DE 00 23 F0 C6 03 0A F0 14 00 08 00 76 30 0D 00 C0 16 21 A0 C0 03 FF FF 15 24 ?? ?? ?? 0? 21 B8 C0 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 95 16 20 00 04 24 21 30 E0 02 FF FF 15 24 ?? ?? ?? 0? 21 B8 C0 00 21 28 40 02 ?? ?? ?? 0? 01 00 73 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 56 00 00 64 82 A1 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 93 16 20 00 04 24 00 00 24 82 96 FF 80 14 10 00 A4 A3 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 80 20 04 00 21 20 C4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 63 34 80 00 63 34 00 07 62 30 89 00 40 10 21 A0 60 00 00 10 65 30 06 00 04 24 10 00 62 30 71 02 40 10 0B B8 85 00 70 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 45 8C 04 00 53 8C 08 00 44 24 70 00 A4 AF 20 00 A5 AF 20 00 A6 8F 21 28 60 02 21 38 00 00 21 20 C0 00 21 30 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 98 62 02 03 00 74 34 20 00 A3 8F 21 28 60 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF 14 03 40 14 20 00 A3 8F 24 00 A0 AF 19 00 E2 2A 40 00 40 10 24 00 A3 8F FF 00 F5 32 6E 00 A2 2E 62 02 40 14 0B 00 A2 2E EB 51 02 3C 1F 85 42 34 19 00 A2 02 ?? ?? 16 3C ?? ?? D6 26 ?? ?? 05 3C ?? ?? A6 8C ?? ?? A7 8C 10 18 00 00 42 41 03 00 FF 00 02 31 12 00 42 24 C0 10 02 00 21 10 56 00 00 00 44 8C 04 00 45 8C ?? ?? ?? 0? 38 00 A8 AF 38 00 A8 8F 64 00 04 24 CC CC 09 3C 02 28 04 71 CD CC 29 35 21 20 40 00 38 00 A9 AF 23 40 A5 02 FF 00 08 31 19 00 09 01 21 28 60 00 10 38 00 00 F8 07 E2 30 21 10 C2 02 48 00 46 8C ?? ?? ?? 0? 4C 00 47 8C 38 00 A9 8F 21 20 40 00 21 28 60 00 19 00 A9 02 0A 00 02 24 10 38 00 00 C2 18 07 00 02 30 62 70 23 10 A6 02 FF 00 42 30 C0 10 02 00 21 B0 56 00 00 00 C6 8E ?? ?? ?? 0? 04 00 C7 8E 20 00 A8 8F 21 28 60 02 21 30 40 00 21 20 00 01 ?? ?? ?? 0? 21 38 60 00 20 00 A2 AF 21 98 60 00 24 00 A3 8F 0A 00 62 28 2E 01 40 10 2C 00 A2 8F 20 00 A3 8F 21 28 60 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 1B 01 40 14 20 00 A3 8F 21 28 60 02 ?? ?? ?? 0? 21 20 60 00 21 B0 40 00 21 A8 60 00 21 20 C0 02 ?? ?? ?? 0? 21 28 A0 02 20 00 A6 8F 21 28 60 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 20 00 A2 AF 24 00 A3 AF 18 00 A0 AF ?? ?? ?? 0? 21 40 00 00 00 04 63 34 00 07 62 30 79 FF 40 14 21 A0 60 00 C0 00 62 30 F5 01 40 14 20 16 03 7C 37 03 40 04 10 00 62 30 20 02 40 10 70 00 A2 8F 70 00 A7 8F 00 00 E4 8C 04 00 E7 24 70 00 A7 AF C3 17 04 00 21 98 80 00 2B 02 40 04 21 B0 40 00 03 00 E0 16 C0 00 75 30 25 B8 76 02 01 00 F7 2E 40 00 02 24 F2 02 A2 12 41 00 A2 2A 91 02 40 10 80 00 02 24 16 00 A0 16 10 00 A2 83 01 00 02 24 61 03 C0 12 10 00 A2 A3 ?? ?? 04 3C ?? ?? 84 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 08 24 21 38 40 00 04 00 85 8C 2B 30 C5 02 FD 02 C0 54 10 00 A7 A3 3F 03 B6 50 00 00 85 8C 01 00 42 24 20 14 02 7C F6 FF 48 14 08 00 84 24 10 00 A2 A3 2A 20 57 00 6A 02 80 10 2A 20 E2 02 20 14 17 7C 10 00 A2 A3 05 00 C0 13 00 40 64 30 03 00 64 30 2B 20 04 00 23 F0 C4 03 00 40 64 30 05 00 80 10 2A 28 5E 00 2A 20 FE 02 23 F0 D7 03 0A F0 04 00 2A 28 5E 00 23 10 C2 03 0A 10 05 00 04 00 64 30 42 02 80 10 24 00 A2 AF 02 00 62 30 B8 02 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 24 00 A5 8F 08 00 64 30 0F 00 A0 10 30 00 A4 AF 21 F0 A0 00 21 A0 60 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 08 00 86 32 24 00 BE AF 21 18 80 02 30 00 A6 AF FF FF F7 26 ?? ?? 14 3C C0 10 17 00 ?? ?? 94 26 21 A0 82 02 03 00 02 24 80 F0 17 00 02 B8 E2 72 40 20 16 00 41 00 A2 2A 20 00 63 30 21 40 C0 03 34 00 B1 AF 20 00 A3 AF 21 88 40 00 21 F0 E0 02 ?? ?? ?? 0? 21 B8 80 00 10 00 A0 16 10 00 A4 83 00 00 86 8E 04 00 87 8E 21 20 60 02 21 28 C0 02 ?? ?? ?? 0? 38 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 38 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 38 00 A8 AF 38 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 94 26 FC FF 08 25 FD FF DE 27 FD FF 02 24 C7 01 C2 13 40 00 02 24 BB 01 A2 12 27 10 1E 00 DF FF 20 16 80 00 02 24 A5 01 A2 12 C0 00 02 24 DD FF A2 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 70 00 A6 8F 70 00 A7 8F 01 00 C2 80 10 00 66 30 00 00 E5 8C 04 00 E4 24 8E 01 C0 10 10 00 A2 A3 8D 01 40 50 14 00 A5 A3 FF FF 06 24 8A 01 46 50 14 00 A5 A3 14 00 A2 A3 15 00 A5 A3 02 00 06 24 14 00 B3 27 ?? ?? ?? 0? 70 00 A4 AF ?? ?? ?? 0? C0 00 63 34 70 00 A5 8F 00 00 A4 8C 04 00 A5 24 A8 02 80 10 21 98 80 00 00 00 82 80 06 00 40 10 21 30 00 00 01 00 C6 24 21 10 86 00 00 00 42 80 FD FF 40 54 01 00 C6 24 ?? ?? ?? 0? 70 00 A5 AF ?? ?? ?? 0? 40 00 63 34 10 00 62 30 21 20 E0 00 0A 20 02 01 25 18 83 00 FF FF 63 30 ?? ?? ?? 0? 00 00 22 82 C4 FD 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 B7 FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 05 24 C3 FD 45 14 21 F0 00 00 70 00 A6 8F 01 00 31 26 00 00 22 82 00 00 DE 8C 2E 00 05 24 04 00 C6 24 BE FD 45 14 70 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 05 24 E5 01 45 10 00 40 63 34 21 28 82 00 01 00 A5 90 21 B8 00 00 04 00 A5 30 B5 FD A0 10 0A 00 06 24 02 28 E6 72 01 00 31 26 21 B8 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF F7 26 ?? ?? ?? 0? ?? ?? 07 3C 21 28 60 02 ?? ?? ?? 0? 21 20 60 00 21 B0 40 00 25 10 43 00 E5 FE 40 14 21 A8 60 00 24 00 A4 8F 02 00 82 28 E1 FE 40 14 2C 00 A2 8F 28 00 A3 8F 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 20 60 00 EA 00 40 04 24 00 A3 8F 24 00 A4 8F EE FF 88 24 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 38 00 A8 AF 2C 00 A3 AF 20 00 A6 8F 21 18 40 00 28 00 A2 AF 2C 00 A2 8F 21 20 C0 00 21 28 60 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 38 00 A8 8F 21 B0 40 00 21 A8 60 00 20 00 A0 AF 24 00 A0 AF 01 00 02 24 3C 02 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 05 24 02 00 07 24 ?? ?? ?? 0? 12 00 0A 24 21 38 A0 00 04 00 64 8C 2B 30 A4 02 68 01 C0 14 02 00 49 24 63 01 95 50 00 00 64 8C 01 00 E5 24 01 00 42 24 20 2C 05 7C F5 FF 4A 14 08 00 63 24 10 00 A5 A3 14 00 09 24 23 98 C8 03 23 98 77 02 2B 10 17 00 23 98 69 02 03 00 83 32 23 98 62 02 2B 18 03 00 04 00 82 32 1A 01 40 10 23 98 63 02 02 00 82 32 A3 01 40 10 01 00 82 32 01 00 84 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 60 1A 08 00 9E 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 9E 32 ?? ?? 14 3C ?? ?? ?? 0? ?? ?? 94 26 C0 18 03 00 21 18 83 02 00 00 66 8C 04 00 67 8C 21 20 C0 02 ?? ?? ?? 0? 21 28 A0 02 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 E2 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 E2 2A 0A 01 40 14 20 14 17 7C 12 00 02 24 10 00 A2 A3 EE FF F5 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 21 28 60 00 24 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 FF FF 82 26 20 14 02 7C 27 00 80 12 10 00 A2 A3 ?? ?? 14 3C ?? ?? 94 26 21 40 60 00 21 B8 C0 02 C0 10 02 00 21 10 82 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 38 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B6 83 38 00 A8 8F 27 10 02 00 C0 18 16 00 21 18 83 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF C2 26 20 14 02 7C 21 40 60 00 DF FF C0 16 10 00 A2 A3 09 00 A0 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 9B FC C0 53 00 00 24 82 99 FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A6 8F F8 FF 02 24 07 00 C4 24 24 10 82 00 00 00 47 8C 04 00 53 8C 08 00 42 24 20 00 A7 AF ?? ?? ?? 0? 70 00 A2 AF 3A 01 40 04 10 00 62 30 35 00 40 10 70 00 A2 8F 70 00 A7 8F 21 B0 00 00 00 00 F3 8C 04 00 E7 24 ?? ?? ?? 0? 70 00 A7 AF ED FF 68 24 ?? ?? ?? 0? 18 00 A8 AF 4F 01 40 54 ?? ?? 02 3C CC CC 02 3C CD CC 42 34 19 00 A2 02 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C ?? ?? 08 3C ?? ?? 08 25 38 00 A8 AF 10 28 00 00 C2 B0 05 00 FF 00 C2 32 09 00 42 24 C0 10 02 00 21 10 48 00 00 00 44 8C ?? ?? ?? 0? 04 00 45 8C 0A 00 04 24 02 28 C4 72 38 00 A8 8F 21 20 40 00 23 A8 A5 02 FF 00 B5 32 C0 A8 15 00 21 40 A8 02 00 00 06 8D 04 00 07 8D ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 20 00 A8 8F 00 00 44 8C 04 00 42 24 70 00 A2 AF C3 17 04 00 21 98 80 00 E3 FD 41 04 21 B0 40 00 ?? ?? ?? 0? 23 98 04 00 21 B0 00 00 00 00 53 8C 04 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 14 00 A5 A3 01 00 06 24 14 00 B3 27 ?? ?? ?? 0? 70 00 A4 AF 23 98 04 00 2B 20 13 00 23 10 02 00 03 00 63 34 ?? ?? ?? 0? 23 B0 44 00 27 18 08 00 04 18 77 00 06 10 13 01 25 10 62 00 06 28 16 01 20 00 06 31 0B 10 A6 00 20 00 A5 8F ?? ?? 04 3C ?? ?? 07 3C ?? ?? 83 24 ?? ?? E4 24 0A 18 85 00 0F 00 42 30 21 18 62 00 00 00 64 80 ?? ?? ?? 0? 10 00 A4 A3 04 10 57 00 06 20 D3 03 25 20 44 00 20 00 C3 33 06 10 D6 03 0B 20 43 00 07 00 84 30 30 00 84 24 ?? ?? ?? 0? 10 00 A4 A3 30 00 A6 8F 1D FC C0 10 34 00 B1 8F 24 00 A7 8F 1A FC E0 18 21 98 E0 00 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 }
	condition:
		$1
}

rule file_294_2_0 {
	meta:
		name = "_dvfprintf_cdfFgGnopuxX"
		size = 6796
		refs = "009c _ctype 0164 fputc 0478 dpcmp 0508 __fixunsdfdi 051c __floatundidf 0534 dpsub 075c __udivdi3 0770 __umoddi3 0958 dpadd 09bc dpmul 0a8c dpdiv 0de8 dptoul 1030 frexp 1630 __floatunsidf"
		altNames = "_dvfprintf_cdfFgGnopsuxX"
	strings:
		$1 = { 90 FF BD 27 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 68 00 BE AF 64 00 B7 AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 21 90 80 00 21 88 A0 00 78 00 A6 AF 2C 00 A0 AF 30 00 A0 AF 21 80 00 00 00 00 24 82 68 00 80 10 10 00 A4 A3 25 00 02 24 ED 01 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 E1 01 46 10 FF FF 91 24 2E 00 45 28 D7 01 A0 10 00 00 00 00 E9 01 47 50 01 00 63 34 E5 01 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A4 24 21 28 82 00 01 00 A5 90 02 00 67 30 FE FF 66 30 0B 18 C7 00 08 00 67 30 FB FF 66 30 04 00 A5 30 DD 01 A0 10 0B 18 C7 00 21 98 00 00 0A 00 06 24 02 28 66 72 01 00 31 26 21 98 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 73 26 2E 00 05 24 DB 01 45 50 01 00 31 26 00 10 63 34 21 A0 00 00 ?? ?? 07 3C ?? ?? E6 24 10 00 08 24 00 80 07 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3D 00 A0 14 01 00 31 26 10 00 B6 27 01 00 17 24 04 00 80 12 2B 10 F3 02 2B 10 97 02 0B B8 82 02 2B 10 F3 02 08 00 75 30 23 98 77 02 0B 00 A0 16 0A 98 02 00 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 D6 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F4 56 00 00 C4 82 A5 FF A0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9A FF 80 14 10 00 A4 A3 6C 00 BF 8F 21 10 00 02 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 80 20 04 00 21 20 C4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 63 34 80 00 63 34 00 07 62 30 4F 00 40 10 21 B8 60 00 00 10 65 30 06 00 04 24 10 00 62 30 E6 02 40 10 0B A0 85 00 78 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 45 8C 04 00 55 8C 08 00 44 24 78 00 A4 AF 20 00 A5 AF 20 00 A6 8F 21 28 A0 02 21 38 00 00 21 20 C0 00 21 30 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 A8 A2 02 03 00 77 34 20 00 A3 8F 21 28 A0 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF DC 02 40 14 21 B0 00 00 00 02 E2 32 00 01 40 14 FC FF C2 2A 19 00 82 2A 23 03 40 14 00 00 00 00 18 00 A8 8F 0A 00 02 29 54 01 40 10 30 00 A2 8F 20 00 A3 8F 21 28 A0 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 40 00 A8 AF FE 02 40 14 20 00 A3 8F 21 28 A0 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 21 B0 60 00 21 20 C0 03 ?? ?? ?? 0? 21 28 C0 02 20 00 A6 8F 21 28 A0 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 20 00 A2 AF 28 00 A3 AF 18 00 A0 AF ?? ?? ?? 0? 21 40 00 00 20 00 63 34 00 02 63 34 00 07 62 30 B3 FF 40 14 21 B8 60 00 C0 00 62 30 A4 02 40 14 20 16 03 7C 84 04 40 04 78 00 A6 8F 10 00 62 30 D7 02 40 10 78 00 A2 8F 78 00 A7 8F 00 00 E4 8C 04 00 E7 24 78 00 A7 AF C3 17 04 00 21 B0 80 00 21 B8 40 00 05 00 41 04 23 10 02 00 23 B0 04 00 2B 20 16 00 03 00 63 34 23 B8 44 00 03 00 80 16 C0 00 75 30 25 A0 D7 02 01 00 94 2E 40 00 02 24 CC 03 A2 12 41 00 A2 2A 77 03 40 10 80 00 02 24 16 00 A0 16 10 00 BE 83 01 00 02 24 19 05 E0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 42 24 02 00 06 24 02 00 1E 24 ?? ?? ?? 0? 14 00 07 24 21 30 C0 03 04 00 44 8C 2B 28 E4 02 70 03 A0 54 10 00 A6 A3 6D 04 97 50 00 00 44 8C 01 00 DE 27 20 F4 1E 7C F6 FF C7 17 08 00 42 24 10 00 BE A3 2A 10 D4 03 5B 03 40 10 2A 10 9E 02 20 F4 14 7C 10 00 BE A3 05 00 60 12 00 40 62 30 03 00 62 30 2B 10 02 00 23 98 62 02 00 40 62 30 05 00 40 10 2A 20 D3 03 2A 10 93 02 23 98 74 02 0A 98 02 00 2A 20 D3 03 04 00 62 30 23 F0 7E 02 2B 03 40 10 0A F0 04 00 02 00 62 30 79 03 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 62 30 0D 00 C0 13 24 00 A2 AF 21 98 60 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 08 00 64 32 21 18 60 02 24 00 A4 AF FF FF 94 26 ?? ?? 02 3C C0 98 14 00 ?? ?? 42 24 21 98 53 00 03 00 02 24 80 40 14 00 40 20 17 00 02 A0 82 72 20 00 63 30 41 00 A2 2A 28 00 BE AF 34 00 B1 AF 20 00 A3 AF 21 F0 80 00 ?? ?? ?? 0? 21 88 40 00 10 00 A0 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 40 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 40 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 40 00 A8 AF 40 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF 94 26 FD FF 02 24 CF 02 82 12 40 00 02 24 C3 02 A2 12 27 10 14 00 DF FF 20 16 80 00 02 24 AD 02 A2 12 C0 00 02 24 DD FF A2 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 2E FE 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 21 FE 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 05 24 2D FE 45 14 21 98 00 00 78 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D3 8C 2E 00 05 24 04 00 C6 24 28 FE 45 14 78 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 05 24 3C 03 45 10 00 40 63 34 21 28 82 00 01 00 A5 90 21 A0 00 00 04 00 A5 30 1F FE A0 10 0A 00 06 24 02 28 86 72 01 00 31 26 21 A0 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 94 26 ?? ?? ?? 0? ?? ?? 07 3C 3C 01 40 14 2A 10 D4 02 3A 01 40 10 00 00 00 00 4E 04 C0 06 20 00 A3 8F 21 28 A0 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 21 B0 60 00 25 10 D6 03 0F 00 40 10 21 30 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 13 00 07 24 04 00 64 8C 01 00 42 24 2B 28 C4 02 06 00 A0 14 21 30 40 00 A3 03 96 50 00 00 64 8C F8 FF 47 14 08 00 63 24 14 00 06 24 23 A0 86 02 19 00 82 2A 7C 03 40 10 00 00 00 00 ?? ?? ?? 0? FF 00 84 32 20 00 A6 8F 21 28 A0 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 20 80 02 20 00 A2 AF ?? ?? ?? 0? 21 A8 60 00 21 40 40 00 D6 FE 80 12 21 48 60 00 21 20 C0 03 21 28 C0 02 40 00 A8 AF ?? ?? ?? 0? 3C 00 A9 AF 20 00 A7 8F 21 28 A0 02 21 30 40 00 21 20 E0 00 ?? ?? ?? 0? 21 38 60 00 40 00 A8 8F 3C 00 A9 8F 21 20 40 00 21 28 60 00 21 30 00 01 ?? ?? ?? 0? 21 38 20 01 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 BD FE 80 12 21 28 C0 02 21 20 C0 03 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 F0 40 00 ?? ?? ?? 0? 21 B0 60 00 25 10 43 00 F1 FF 40 50 FF FF 94 26 18 00 A8 8F 0A 00 02 29 B0 FE 40 14 20 00 A3 8F 30 00 A2 8F 2C 00 A3 8F 40 00 A8 AF 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 20 60 00 9A 01 40 04 40 00 A8 8F EE FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 40 00 A8 AF 30 00 A3 AF 20 00 A6 8F 21 18 40 00 2C 00 A2 AF 30 00 A2 8F 21 20 C0 00 21 28 A0 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 40 00 A8 8F 21 F0 40 00 21 B0 60 00 20 00 A0 AF 28 00 A0 AF 01 00 02 24 E0 03 C0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 2B 30 C5 02 61 02 C0 14 02 00 47 24 5C 02 B6 50 00 00 65 8C 01 00 84 24 01 00 42 24 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 98 68 02 23 A8 74 02 2B 10 14 00 23 A8 A7 02 03 00 E3 32 23 A8 A2 02 2B 18 03 00 04 00 E2 32 30 02 40 10 23 A8 A3 02 02 00 E2 32 FF 02 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 A0 5A 08 00 F7 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 08 00 F7 32 24 00 B7 AF ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 73 26 C0 18 03 00 21 18 63 02 00 00 66 8C 04 00 67 8C 21 20 C0 03 ?? ?? ?? 0? 21 28 C0 02 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 82 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 82 2A E7 01 40 14 20 14 14 7C 12 00 02 24 10 00 A2 A3 EE FF 94 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 21 28 60 00 28 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 FF FF 64 26 20 24 04 7C 21 B0 40 00 21 B8 60 00 27 00 60 12 10 00 A4 A3 ?? ?? 02 3C ?? ?? 42 24 21 98 20 02 20 00 A2 AF 21 88 40 00 C0 20 04 00 21 20 24 02 00 00 86 8C 04 00 87 8C 21 28 E0 02 ?? ?? ?? 0? 21 20 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 BE 83 27 10 02 00 21 20 C0 02 C0 18 1E 00 21 18 23 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 E0 02 ?? ?? ?? 0? 21 80 02 02 FF FF C4 27 20 24 04 7C 21 B0 40 00 21 B8 60 00 E1 FF C0 17 10 00 A4 A3 21 88 60 02 0A 00 80 12 24 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 24 00 A4 8F B2 FC 80 50 00 00 24 82 B0 FC A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 8D 02 80 16 21 10 00 00 10 00 A2 A3 20 00 A3 8F 21 28 A0 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 02 40 14 10 00 AA 83 20 00 A2 8F 21 28 A0 02 ?? ?? ?? 0? 21 20 40 00 21 A8 40 00 18 00 B6 8F ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF 73 26 03 00 E2 32 63 00 C3 26 2B 10 02 00 23 98 74 02 C7 00 63 2C 23 98 62 02 01 00 63 2C 04 00 E2 32 D6 01 40 10 23 98 63 02 02 00 E2 32 74 02 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 60 1A 08 00 FE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 FE 32 10 00 A2 83 20 00 A3 8F 21 20 A0 02 C0 10 02 00 21 10 62 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 20 00 A4 8F 27 10 02 00 C0 18 03 00 21 18 83 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 62 02 80 16 21 A8 60 00 20 00 F7 32 02 00 E0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F B0 02 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 64 00 43 28 98 02 60 10 64 00 14 24 0A 00 14 24 1A 00 54 00 F4 01 80 02 21 28 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 29 FC C0 13 21 80 02 02 28 FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 78 00 A6 8F F8 FF 02 24 07 00 C4 24 24 10 82 00 00 00 47 8C 04 00 55 8C 08 00 42 24 20 00 A7 AF ?? ?? ?? 0? 78 00 A2 AF D8 01 40 04 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "strrchr"
		size = 76
		refs = "0010 strlen"
	strings:
		$1 = { E0 FF BD 27 18 00 B0 AF 10 00 A5 AF 1C 00 BF AF ?? ?? ?? 0? 21 80 80 00 10 00 A5 8F 21 10 02 02 20 2C 05 7C 00 00 43 80 05 00 65 10 1C 00 BF 8F FC FF 50 14 FF FF 42 24 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "bsearch"
		size = 248
	strings:
		$1 = { C8 FF BD 27 20 00 B3 AF 1C 00 B2 AF 18 00 B1 AF 14 00 B0 AF 34 00 BF AF 30 00 B7 AF 2C 00 B6 AF 28 00 B5 AF 24 00 B4 AF 21 80 80 00 21 88 A0 00 21 90 E0 00 48 00 B3 8F 19 00 C0 10 21 10 00 00 FF FF D4 24 ?? ?? ?? 0? 21 B0 00 00 13 00 80 06 2A 10 96 02 12 00 40 14 21 10 00 00 21 10 96 02 C2 AF 02 00 21 A8 A2 02 43 A8 15 00 02 10 B2 72 21 20 00 02 21 B8 51 00 09 F8 60 02 21 28 E0 02 12 00 40 10 34 00 BF 8F F0 FF 43 04 01 00 B6 26 FF FF B4 26 EF FF 81 06 2A 10 96 02 21 10 00 00 34 00 BF 8F 30 00 B7 8F 2C 00 B6 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 21 10 E0 02 2C 00 B6 8F 30 00 B7 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 }
	condition:
		$1
}

rule file_340_2_0 {
	meta:
		name = "vfprintf"
		size = 6960
		refs = "007c _ctype 0150 fputc 0444 __floatdisf 0454 fpcmp 04bc fpadd 0508 fpdiv 0510 fptoui 06a8 fpmul 06e8 __udivdi3 06fc __umoddi3 0fc0 __floatunsisf 0fcc fpsub 1158 frexpf 1328 __floatundisf"
	strings:
		$1 = { A0 FF BD 27 21 10 00 00 40 00 B2 AF 3C 00 B1 AF 38 00 B0 AF 5C 00 BF AF 58 00 BE AF 54 00 B7 AF 50 00 B6 AF 4C 00 B5 AF 48 00 B4 AF 44 00 B3 AF 21 90 80 00 21 88 A0 00 68 00 A6 AF 30 00 A2 AF 21 80 00 00 00 00 24 82 63 00 80 10 10 00 A4 A3 25 00 02 24 A4 02 82 14 01 00 33 26 02 00 23 26 21 B0 00 00 FF FF 62 80 E0 FF 44 24 FF 00 84 30 11 00 85 2C 75 02 A0 14 FF FF 71 24 ?? ?? 06 3C ?? ?? C6 24 21 18 C2 00 01 00 63 90 02 00 C5 32 FE FF C4 32 0B B0 85 00 08 00 C5 32 FB FF C4 32 04 00 63 30 98 02 60 10 0B B0 85 00 21 F0 00 00 0A 00 04 24 02 18 C4 73 01 00 31 26 ?? ?? 05 3C ?? ?? A5 24 21 F0 62 00 00 00 22 82 21 18 A2 00 01 00 63 90 04 00 63 30 F6 FF 60 14 D0 FF DE 27 2E 00 03 24 94 02 43 50 01 00 31 26 00 10 D6 36 21 98 00 00 ?? ?? 06 3C ?? ?? C5 24 10 00 07 24 00 80 06 24 FF 00 43 30 79 00 64 2C 10 00 A2 A3 3E 00 80 14 01 00 31 26 10 00 B5 27 01 00 17 24 04 00 60 52 2B 98 FE 02 2B 10 77 02 0B B8 62 02 2B 98 FE 02 23 F0 D7 03 0A F0 13 00 08 00 D6 32 0B 00 C0 16 21 98 C0 03 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F4 56 00 00 A4 82 AA FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9F FF 80 14 10 00 A4 A3 5C 00 BF 8F 21 10 00 02 58 00 BE 8F 54 00 B7 8F 50 00 B6 8F 4C 00 B5 8F 48 00 B4 8F 44 00 B3 8F 40 00 B2 8F 3C 00 B1 8F 38 00 B0 8F 08 00 E0 03 60 00 BD 27 80 18 03 00 21 18 A3 00 00 00 62 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 00 D6 36 00 07 C2 32 F1 00 40 10 C0 00 C2 32 00 10 C4 32 06 00 03 24 10 00 C2 32 CA 02 40 10 0B 98 64 00 68 00 A7 8F F8 FF 02 24 07 00 E3 24 24 10 62 00 00 00 44 8C 04 00 45 8C 08 00 42 24 ?? ?? ?? 0? 68 00 A2 AF 20 00 A2 AF 20 00 A4 8F ?? ?? ?? 0? 21 28 00 00 07 00 41 04 20 00 A4 8F 20 00 A4 8F 00 80 02 3C 03 00 D6 36 26 20 44 00 20 00 A4 AF 20 00 A4 8F 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF 32 03 40 14 21 A0 00 00 00 01 C2 32 C3 01 40 14 00 02 C2 32 BF 01 40 14 FC FF 82 2A 19 00 62 2A 08 00 40 10 18 00 B4 8F ?? ?? ?? 0? FF 00 64 32 20 00 A4 8F ?? ?? ?? 0? 21 28 40 00 20 00 A2 AF 18 00 B4 8F 0A 00 82 2A 60 03 40 14 20 00 A4 8F ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 30 00 A4 8F 29 05 43 04 EE FF 94 26 ED FF 94 26 18 00 B4 AF ?? ?? ?? 0? 20 24 14 7C 20 00 A4 8F 21 28 40 00 ?? ?? ?? 0? 30 00 A2 AF ?? ?? ?? 0? 21 20 40 00 21 18 00 00 21 B8 40 00 21 A8 40 00 20 00 A3 AF 01 00 03 24 0A 00 E2 2E 6E 05 40 14 10 00 A3 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 08 24 02 00 04 24 ?? ?? ?? 0? 12 00 07 24 21 40 80 00 04 00 65 8C EC 04 A0 14 02 00 46 24 00 00 65 8C 2B 28 E5 02 E8 04 A0 14 01 00 84 24 01 00 42 24 20 24 04 7C F5 FF 47 14 08 00 63 24 10 00 A4 A3 14 00 06 24 23 A0 D4 03 00 08 D7 32 23 A0 93 02 25 10 77 02 2B 10 02 00 23 A0 86 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 A6 04 40 10 23 A0 83 02 02 00 C2 32 0D 05 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 1A 10 00 A2 83 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 10 00 A2 83 08 00 DE 32 FF FF 43 24 20 1C 03 7C 9E 04 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 62 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 62 2A 04 05 40 14 20 14 13 7C 12 00 02 24 10 00 A2 A3 EE FF 73 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 20 00 A5 8F 21 20 40 00 ?? ?? ?? 0? 21 B0 00 00 ?? ?? ?? 0? 21 20 40 00 21 B8 40 00 FF FF A2 26 20 14 02 7C 25 00 A0 12 10 00 A2 A3 ?? ?? 05 3C ?? ?? A5 24 C0 10 02 00 21 10 A2 00 00 00 46 8C 04 00 47 8C 21 20 E0 02 ?? ?? ?? 0? 21 28 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B5 83 ?? ?? 06 3C ?? ?? C6 24 C0 18 15 00 21 18 C3 00 00 00 66 8C 04 00 67 8C 27 10 02 00 2B 10 02 00 21 28 C0 02 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF A2 26 20 14 02 7C 21 B0 60 00 DD FF A0 16 10 00 A2 A3 09 00 60 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 30 FE C0 53 00 00 24 82 2E FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 D6 36 00 01 D6 36 00 07 C2 32 13 FF 40 14 00 10 C4 32 C0 00 C2 32 E4 01 40 14 20 16 16 7C 4E 04 40 04 68 00 A7 8F 10 00 C2 32 7C 02 40 10 68 00 A4 8F 68 00 A2 8F 00 00 43 8C 04 00 42 24 68 00 A2 AF C3 17 03 00 21 A8 60 00 21 B8 40 00 05 00 41 04 23 10 02 00 23 A8 03 00 2B 18 15 00 03 00 D6 36 23 B8 43 00 03 00 60 16 C0 00 D4 32 25 98 B7 02 01 00 73 2E 40 00 02 24 D3 03 82 12 41 00 82 2A 95 03 40 10 80 00 02 24 16 00 80 16 10 00 A2 83 01 00 02 24 A7 04 E0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 02 00 06 24 02 00 02 24 ?? ?? ?? 0? 14 00 07 24 21 30 40 00 04 00 64 8C 2B 28 E4 02 3C 04 A0 54 10 00 A6 A3 36 04 97 50 00 00 64 8C 01 00 42 24 20 14 02 7C F6 FF 47 14 08 00 63 24 10 00 A2 A3 2A 18 53 00 3A 03 60 10 2A 18 62 02 20 14 13 7C 10 00 A2 A3 05 00 C0 13 00 40 C3 32 03 00 C3 32 2B 18 03 00 23 F0 C3 03 00 40 C3 32 04 00 60 10 C4 08 C4 32 2A 18 7E 02 23 F0 D3 03 0A F0 03 00 40 08 03 24 71 03 83 10 C0 08 C4 32 80 08 03 24 CB 03 83 10 03 00 C3 2B 2A 20 5E 00 23 10 C2 03 0A 10 04 00 04 00 C3 32 23 03 60 10 20 00 A2 AF 02 00 C2 32 82 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A4 8F 08 00 C3 32 A2 02 80 14 2C 00 A3 AF FF FF 62 26 ?? ?? 04 3C 03 00 1E 24 C0 98 02 00 ?? ?? 84 24 80 40 02 00 02 F0 5E 70 41 00 83 2A 40 10 17 00 21 98 93 00 28 00 A2 AF 24 00 A3 AF ?? ?? ?? 0? 20 00 D6 32 10 00 80 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 A0 02 21 28 E0 02 ?? ?? ?? 0? 34 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 34 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 34 00 A8 AF 34 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF DE 27 FD FF 02 24 D2 02 C2 13 40 00 02 24 C5 02 82 12 28 00 A3 8F 24 00 A4 8F DE FF 80 14 80 00 02 24 AE 02 82 12 C0 00 02 24 DC FF 82 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 D6 36 ?? ?? ?? 0? 80 00 D6 36 20 00 D6 36 ?? ?? ?? 0? 00 02 D6 36 ?? ?? 05 3C 80 20 04 00 ?? ?? A5 24 21 20 A4 00 00 00 84 8C 08 00 80 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 D6 36 ?? ?? ?? 0? 01 00 63 24 08 00 D6 36 ?? ?? ?? 0? 01 00 63 24 02 00 D6 36 ?? ?? ?? 0? 01 00 63 24 00 08 D6 36 ?? ?? ?? 0? 01 00 63 24 01 00 D6 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 2A 00 03 24 74 FD 43 14 21 F0 00 00 68 00 A6 8F 01 00 31 26 00 00 22 82 00 00 DE 8C 2E 00 03 24 04 00 C6 24 6F FD 43 14 68 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 03 24 30 03 43 10 00 40 D6 36 ?? ?? 07 3C ?? ?? E7 24 21 18 E2 00 01 00 63 90 21 98 00 00 04 00 63 30 64 FD 60 10 0A 00 04 24 02 18 64 72 01 00 31 26 ?? ?? 05 3C ?? ?? A5 24 21 98 62 00 00 00 22 82 21 18 A2 00 01 00 63 90 04 00 63 30 F6 FF 60 14 D0 FF 73 26 ?? ?? ?? 0? ?? ?? 06 3C C2 01 40 10 2A 10 93 02 69 01 60 12 21 10 00 00 40 02 C2 7E 23 98 62 02 13 00 62 2E 63 01 40 14 12 00 02 24 10 00 A2 A3 20 00 A4 8F ?? ?? ?? 0? 21 28 00 00 EF 00 40 14 10 00 A3 83 20 00 A4 8F ?? ?? 15 3C ?? ?? ?? 0? ?? ?? B5 26 24 00 A2 AF 00 0A C3 32 00 02 02 24 24 01 62 10 24 00 A6 8F FB FF D4 27 B1 00 60 16 23 A0 93 02 00 08 C2 32 AF 00 40 14 03 00 C3 32 2B 18 03 00 04 00 C2 32 B0 00 40 10 23 A0 83 02 02 00 C2 32 73 01 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 9E 03 80 1A 08 00 C7 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 C2 32 28 00 A2 AF 10 00 A2 83 24 00 A4 8F 21 28 00 00 C0 10 02 00 21 10 A2 02 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 24 00 A4 8F 27 10 02 00 C0 18 03 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 F0 40 00 04 00 60 16 21 40 60 00 00 08 C2 32 40 00 40 50 20 00 D6 32 2E 00 04 24 21 28 40 02 ?? ?? ?? 0? 34 00 A8 AF 10 00 A4 83 27 10 02 00 2B 18 02 00 FF FF 82 24 20 14 02 7C 24 00 A4 AF 21 80 03 02 10 00 A2 A3 25 00 80 10 34 00 A8 8F 00 02 C5 32 20 00 A5 AF 20 00 A6 8F 03 00 C0 10 25 18 C8 03 2A 00 60 50 10 00 A0 A3 C0 10 02 00 21 10 A2 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 C0 03 ?? ?? ?? 0? 34 00 A8 AF 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B7 83 34 00 A8 8F 27 10 02 00 C0 18 17 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 C0 03 ?? ?? ?? 0? 21 80 02 02 21 F0 40 00 FF FF E2 26 20 14 02 7C 21 40 60 00 DF FF E0 16 10 00 A2 A3 24 00 A7 8F 23 98 67 02 0A 00 60 52 20 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 85 02 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 13 24 21 28 40 02 1A 00 53 00 F4 01 60 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 73 00 F4 01 60 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 28 00 A2 8F 6D FC 40 50 00 00 24 82 6B FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 03 00 C3 32 FF FF 94 26 2B 18 03 00 04 00 C2 32 52 FF 40 14 23 A0 83 02 08 00 C3 32 0B 00 60 14 28 00 A3 AF 0A 00 80 1A 02 00 C2 32 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 C2 32 CA 00 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 68 00 A2 8F 68 00 A3 8F 00 00 42 8C 04 00 63 24 68 00 A3 AF ?? ?? ?? 0? 20 00 A2 AF 75 02 40 04 10 00 C2 32 95 00 40 10 68 00 A2 8F 68 00 A7 8F 21 B8 00 00 00 00 F5 8C 04 00 E7 24 ?? ?? ?? 0? 68 00 A7 AF ?? ?? 15 3C 23 20 83 02 20 24 04 7C ?? ?? ?? 0? 34 00 A3 AF 20 00 A4 8F ?? ?? ?? 0? 21 28 40 00 21 20 40 00 ?? ?? ?? 0? 20 00 A2 AF 21 20 40 00 ?? ?? ?? 0? 21 B8 40 00 20 00 A4 8F ?? ?? ?? 0? 21 28 40 00 ?? ?? A4 8E ?? ?? ?? 0? 21 28 40 00 09 00 40 1C 34 00 A3 8F 20 00 A4 8F ?? ?? ?? 0? ?? ?? A5 8E 21 20 40 00 ?? ?? ?? 0? 20 00 A2 AF }
	condition:
		$1
}

rule file_343_2_0 {
	meta:
		name = "_dvfprintf"
		size = 7392
		refs = "0084 _ctype 014c fputc 045c dpcmp 04d0 dpadd 0550 dpdiv 055c __fixunsdfdi 0690 __udivdi3 06a4 __umoddi3 075c dpmul 0cc4 dptoul 1108 __floatunsidf 1120 dpsub 12f8 frexp 1538 __floatundidf"
	strings:
		$1 = { 98 FF BD 27 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 34 00 A0 AF 38 00 A0 AF 21 80 00 00 00 00 24 82 62 00 80 10 10 00 A4 A3 25 00 02 24 DE 02 82 14 01 00 33 26 ?? ?? 02 3C 02 00 23 26 21 B0 00 00 ?? ?? 46 24 FF FF 62 80 E0 FF 44 24 FF 00 84 30 11 00 85 2C AF 02 A0 14 FF FF 71 24 ?? ?? 04 3C ?? ?? 83 24 21 20 62 00 01 00 84 90 02 00 C6 32 FE FF C5 32 0B B0 A6 00 08 00 C6 32 FB FF C5 32 04 00 84 30 D0 02 80 10 0B B0 A6 00 21 98 00 00 0A 00 05 24 02 20 65 72 01 00 31 26 21 98 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 73 26 2E 00 04 24 CE 02 44 50 01 00 31 26 00 10 D6 36 21 A8 00 00 ?? ?? 03 3C ?? ?? 65 24 10 00 07 24 00 80 06 24 FF 00 43 30 79 00 64 2C 10 00 A2 A3 3D 00 80 14 01 00 31 26 10 00 B7 27 01 00 1E 24 04 00 A0 12 2B 10 D3 03 2B 10 BE 02 0B F0 A2 02 2B 10 D3 03 08 00 D6 32 23 98 7E 02 0B 00 C0 16 0A 98 02 00 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 F7 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D4 57 00 00 E4 82 AB FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 A0 FF 80 14 10 00 A4 A3 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 80 18 03 00 21 18 A3 00 00 00 62 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 D6 36 80 00 D6 36 00 07 C2 32 23 01 40 10 C0 00 C2 32 00 10 C4 32 06 00 03 24 10 00 C2 32 16 03 40 10 0B A8 64 00 70 00 A7 8F F8 FF 02 24 07 00 E3 24 24 10 62 00 00 00 44 8C 04 00 54 8C 08 00 43 24 70 00 A3 AF 20 00 A4 AF 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 00 41 04 20 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 D6 36 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF 96 03 40 14 21 B8 00 00 00 01 C2 32 F7 01 40 14 00 02 C2 32 F3 01 40 14 FC FF E2 2A 19 00 A2 2A 0C 00 40 10 18 00 A8 8F ?? ?? ?? 0? FF 00 A4 32 20 00 A6 8F 21 28 80 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 20 00 A2 AF 21 A0 60 00 18 00 A8 8F 0A 00 02 29 CF 03 40 14 20 00 A3 8F 34 00 A3 8F 38 00 A2 8F ?? ?? 06 3C ?? ?? C7 8C ?? ?? C6 8C 21 20 60 00 21 28 40 00 ?? ?? ?? 0? 3C 00 A8 AF 82 05 41 04 3C 00 A8 8F ED FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 3C 00 A8 AF 38 00 A3 AF 34 00 A2 AF 21 18 40 00 20 00 A6 8F 38 00 A2 8F 21 28 80 02 21 20 C0 00 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 3C 00 A8 8F 21 F0 40 00 21 B8 60 00 28 00 A0 AF 30 00 A0 AF 01 00 02 24 C4 05 E0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 05 24 ?? ?? ?? 0? 12 00 09 24 21 50 A0 00 04 00 64 8C 2B 30 E4 02 3D 05 C0 14 02 00 47 24 38 05 97 50 00 00 64 8C 01 00 A5 24 01 00 42 24 20 2C 05 7C F5 FF 49 14 08 00 63 24 10 00 A5 A3 14 00 07 24 00 08 C3 32 23 A0 68 02 25 10 A3 02 23 A0 95 02 2B 10 02 00 20 00 A3 AF 23 A0 87 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 09 05 40 10 23 A0 83 02 02 00 C2 32 4F 05 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 D6 32 24 00 B6 AF ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 73 26 C0 18 03 00 21 18 63 02 00 00 66 8C 04 00 67 8C 21 20 C0 03 ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 A2 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 A2 2A 3A 05 40 14 20 14 15 7C 12 00 02 24 10 00 A2 A3 EE FF B5 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 21 28 60 00 30 00 A2 8F 28 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 FF FF 64 26 20 24 04 7C 21 B0 40 00 21 B8 60 00 27 00 60 12 10 00 A4 A3 ?? ?? 02 3C ?? ?? 42 24 21 98 20 02 28 00 A2 AF 21 88 40 00 C0 20 04 00 21 20 24 02 00 00 86 8C 04 00 87 8C 21 28 E0 02 ?? ?? ?? 0? 21 20 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 BE 83 27 10 02 00 21 20 C0 02 C0 18 1E 00 21 18 23 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 E0 02 ?? ?? ?? 0? 21 80 02 02 FF FF C4 27 20 24 04 7C 21 B0 40 00 21 B8 60 00 E1 FF C0 17 10 00 A4 A3 21 88 60 02 0A 00 A0 12 24 00 A6 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 24 00 A6 8F FE FD C0 50 00 00 24 82 FC FD 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 D6 36 00 01 D6 36 00 07 C2 32 E1 FE 40 14 00 10 C4 32 C0 00 C2 32 01 02 40 14 20 16 16 7C 81 04 40 04 70 00 A7 8F 10 00 C2 32 B9 02 40 10 70 00 A4 8F 70 00 A2 8F 00 00 43 8C 04 00 42 24 70 00 A2 AF C3 17 03 00 21 B8 60 00 21 F0 40 00 05 00 41 04 23 10 02 00 23 B8 03 00 2B 18 17 00 03 00 D6 36 23 F0 43 00 03 00 A0 16 C0 00 D4 32 25 A8 FE 02 01 00 B5 2E 40 00 02 24 E8 03 82 12 41 00 82 2A C8 03 40 10 80 00 02 24 16 00 80 16 10 00 A2 83 01 00 02 24 E6 04 C0 13 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 02 00 06 24 02 00 02 24 ?? ?? ?? 0? 14 00 07 24 21 30 40 00 04 00 64 8C 2B 28 C4 03 11 04 A0 54 10 00 A6 A3 69 04 9E 50 00 00 64 8C 01 00 42 24 20 14 02 7C F6 FF 47 14 08 00 63 24 10 00 A2 A3 2A 18 55 00 AC 03 60 10 2A 18 A2 02 20 14 15 7C 10 00 A2 A3 05 00 60 12 00 40 C3 32 03 00 C3 32 2B 18 03 00 23 98 63 02 00 40 C3 32 04 00 60 10 C4 08 C4 32 2A 18 B3 02 23 98 75 02 0A 98 03 00 40 08 03 24 A4 03 83 10 C0 08 C4 32 80 08 03 24 FD 03 83 10 03 00 63 2A 2A 20 53 00 23 10 62 02 0A 10 04 00 04 00 C3 32 60 03 60 10 24 00 A2 AF 02 00 C2 32 9B 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 24 00 A4 8F 08 00 C3 32 0D 00 80 10 30 00 A3 AF 21 98 80 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 C5 32 24 00 B3 AF 30 00 A5 AF FF FF B5 26 ?? ?? 02 3C C0 98 15 00 ?? ?? 42 24 21 98 53 00 03 00 02 24 20 00 D6 32 80 40 15 00 40 18 1E 00 02 A8 A2 72 41 00 82 2A 28 00 B1 AF 20 00 B6 AF 21 88 40 00 ?? ?? ?? 0? 21 B0 60 00 10 00 80 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 E0 02 21 28 C0 03 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 3C 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF B5 26 FD FF 02 24 05 03 A2 12 40 00 02 24 E7 02 82 12 27 10 15 00 DF FF 20 16 80 00 02 24 ED 02 82 12 C0 00 02 24 DD FF 82 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 D6 36 ?? ?? ?? 0? 00 02 D6 36 80 20 04 00 21 20 C4 00 00 00 84 8C 08 00 80 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 D6 36 ?? ?? ?? 0? 01 00 63 24 08 00 D6 36 ?? ?? ?? 0? 01 00 63 24 02 00 D6 36 ?? ?? ?? 0? 01 00 63 24 00 08 D6 36 ?? ?? ?? 0? 01 00 63 24 01 00 D6 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 2A 00 04 24 3A FD 44 14 21 98 00 00 70 00 A5 8F 01 00 31 26 00 00 22 82 00 00 B3 8C 2E 00 04 24 04 00 A5 24 35 FD 44 14 70 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 5B 03 44 10 00 40 D6 36 21 20 62 00 01 00 84 90 21 A8 00 00 04 00 84 30 2C FD 80 10 0A 00 05 24 02 20 A5 72 01 00 31 26 21 A8 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF B5 26 ?? ?? ?? 0? ?? ?? 03 3C 0D 02 40 10 2A 10 F5 02 99 01 A0 12 21 10 00 00 40 02 C2 7E 23 A8 A2 02 13 00 A2 2E 93 01 40 14 12 00 02 24 10 00 A2 A3 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 05 01 40 14 10 00 A8 83 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 24 00 A2 AF ?? ?? 02 3C ?? ?? 42 24 28 00 A2 AF 00 0A C3 32 00 02 02 24 4B 01 62 10 15 00 A3 2A FB FF 73 26 BC 00 A0 16 23 98 75 02 00 08 C2 32 BA 00 40 14 18 00 A3 8F 03 00 C2 32 2B 10 02 00 63 00 63 24 C7 00 63 2C 23 98 62 02 01 00 63 2C 04 00 C2 32 BB 00 40 10 23 98 63 02 02 00 C2 32 A1 01 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 C6 03 60 1A 08 00 C4 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 C5 32 20 00 A5 AF 10 00 A2 83 28 00 A7 8F 24 00 A4 8F C0 10 02 00 21 10 E2 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 28 00 A4 8F 27 10 02 00 C0 18 03 00 21 18 83 00 00 00 66 8C 04 00 67 8C 24 00 A4 8F 2B 10 02 00 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 04 00 A0 16 21 F0 60 00 00 08 C2 32 42 00 40 50 20 00 D6 32 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 10 00 B4 83 27 10 02 00 2B 18 02 00 FF FF 82 26 20 14 02 7C 21 80 03 02 2B 00 80 12 10 00 A2 A3 30 00 B1 AF 28 00 B1 8F 00 02 C3 32 24 00 B3 AF 21 40 C0 03 21 98 60 00 21 F0 E0 02 03 00 60 12 25 18 C8 03 F2 02 60 50 24 00 B3 8F C0 10 02 00 21 10 22 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 C0 03 ?? ?? ?? 0? 3C 00 A8 AF 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B7 83 3C 00 A8 8F 27 10 02 00 C0 18 17 00 21 18 23 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 C0 03 ?? ?? ?? 0? 21 80 02 02 21 F0 40 00 FF FF E2 26 20 14 02 7C 21 40 60 00 E0 FF E0 16 10 00 A2 A3 24 00 B3 8F 30 00 B1 8F 23 A8 B4 02 0A 00 A0 52 20 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F B3 02 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A3 8F 64 00 62 28 9B 02 40 10 64 00 14 24 0A 00 14 24 1A 00 74 00 F4 01 80 02 21 28 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A2 8F 26 FC 40 50 00 00 24 82 24 FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 18 00 A3 8F 03 00 C2 32 2B 10 02 00 63 00 63 24 FF FF 73 26 C7 00 63 2C 23 98 62 02 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "_ivfprintf"
		size = 2812
		refs = "0074 _ctype 01e8 fputc 048c __udivdi3 04a0 __umoddi3"
	strings:
		$1 = { A8 FF BD 27 40 00 B4 AF 34 00 B1 AF 30 00 B0 AF 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 44 00 B5 AF 3C 00 B3 AF 38 00 B2 AF 21 A0 80 00 21 88 A0 00 60 00 A6 AF 21 80 00 00 00 00 24 82 35 00 80 10 10 00 A4 A3 25 00 02 24 66 00 82 14 01 00 32 26 02 00 24 26 21 18 00 00 FF FF 82 80 E0 FF 45 24 FF 00 A5 30 11 00 A6 2C 37 00 C0 14 FF FF 91 24 ?? ?? 07 3C ?? ?? E7 24 21 20 E2 00 01 00 84 90 FE FF 65 30 02 00 66 30 0B 18 A6 00 08 00 68 30 FB FF 65 30 04 00 84 30 5A 00 80 10 0B 18 A8 00 21 20 00 00 0A 00 06 24 02 28 86 70 01 00 31 26 ?? ?? 07 3C ?? ?? E7 24 21 20 A2 00 00 00 22 82 21 28 E2 00 01 00 A5 90 04 00 A5 30 F6 FF A0 14 D0 FF 84 24 6C 00 05 24 10 00 07 24 00 80 06 24 10 00 A2 A3 71 01 45 10 01 00 31 26 6D 00 45 28 4E 00 A0 10 73 00 05 24 63 00 05 24 39 01 45 10 64 00 45 28 31 01 A0 50 64 00 05 24 7A 01 40 14 58 00 05 24 54 00 BF 8F 21 10 00 02 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 ?? ?? 06 3C 80 28 05 00 ?? ?? C6 24 21 28 C5 00 00 00 A5 8C 08 00 A0 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 00 63 34 ?? ?? ?? 0? 01 00 84 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 02 00 63 34 ?? ?? ?? 0? 01 00 84 24 00 08 63 34 ?? ?? ?? 0? 01 00 84 24 01 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 80 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 2A 00 05 24 B2 FF 45 14 21 20 00 00 60 00 A8 8F 01 00 22 82 01 00 31 26 00 00 04 8D 04 00 08 25 ?? ?? ?? 0? 60 00 A8 AF FF 00 45 10 74 00 45 28 DD 00 A0 10 75 00 05 24 6F 00 05 24 24 00 45 10 70 00 05 24 2E 01 45 50 20 00 63 34 10 00 B5 27 01 00 1E 24 2B 90 C4 03 23 20 9E 00 0A 20 12 00 08 00 76 30 04 01 C0 12 21 90 80 00 ?? ?? ?? 0? FF FF 13 24 21 28 80 02 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D3 57 00 00 A4 82 67 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 21 28 80 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 F9 FF 53 56 20 00 04 24 ?? ?? ?? 0? 00 00 24 82 40 00 63 34 C0 00 62 30 8C 00 40 14 20 16 03 7C D7 01 40 04 60 00 A7 8F 10 00 62 30 FA 00 40 10 60 00 A2 8F 60 00 A8 8F 00 00 05 8D 04 00 08 25 60 00 A8 AF C3 17 05 00 21 A8 A0 00 21 B0 40 00 88 00 41 04 C0 00 73 30 23 A8 05 00 23 10 02 00 2B 28 15 00 03 00 63 34 23 B0 45 00 C0 00 73 30 40 00 02 24 82 00 62 16 41 00 62 2A 01 00 02 24 E7 01 C0 12 10 00 A2 A3 02 00 02 24 02 00 17 24 40 00 06 24 21 38 00 00 ?? ?? ?? 0? 15 00 08 24 C0 28 07 00 C0 48 06 00 25 28 45 01 21 30 20 01 21 38 A0 00 21 B8 40 00 2B 28 C7 02 08 00 A0 54 10 00 A2 A3 6A 01 C7 12 2B 28 A6 02 01 00 E2 26 20 14 02 7C F2 FF 48 14 42 57 06 00 10 00 A8 A3 04 00 80 10 C4 08 66 30 03 00 65 30 2B 28 05 00 23 20 85 00 40 08 05 24 61 01 C5 10 C0 08 66 30 80 08 05 24 92 01 C5 10 03 00 85 28 2A B8 44 00 23 10 82 00 0A 10 17 00 04 00 65 30 0A 01 A0 10 21 B8 40 00 02 00 62 30 76 01 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 28 00 A3 AF 21 28 80 02 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 28 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 64 30 B8 00 E0 16 20 00 A4 AF 10 00 BE 83 ?? ?? 07 3C ?? ?? F2 24 FF FF DE 27 C0 10 1E 00 21 90 42 02 03 00 02 24 80 40 1E 00 41 00 64 2A 02 F0 C2 73 20 00 63 30 40 10 16 00 1C 00 A2 AF 18 00 A4 AF ?? ?? ?? 0? 24 00 A3 AF 10 00 60 16 10 00 A4 83 00 00 46 8E 04 00 47 8E 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 28 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 28 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 80 02 ?? ?? ?? 0? 28 00 A8 AF 28 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 52 26 FC FF 08 25 FD FF DE 27 FD FF 02 24 BB 00 C2 13 40 00 02 24 9A 00 62 12 18 00 A5 8F DF FF A0 14 80 00 02 24 A2 00 62 12 C0 00 02 24 DD FF 62 12 10 00 A4 83 ?? ?? ?? 0? 21 28 80 02 43 01 40 04 10 00 62 30 6B 00 40 14 60 00 A8 8F 60 00 A2 8F 21 B0 00 00 00 00 55 8C 04 00 42 24 60 00 A2 AF C0 00 73 30 40 00 02 24 80 FF 62 12 41 00 62 2A F5 00 40 10 80 00 02 24 95 FF 60 16 10 00 A2 83 01 00 02 24 58 01 C0 12 10 00 A2 A3 ?? ?? 05 3C ?? ?? A5 24 02 00 02 24 02 00 17 24 ?? ?? ?? 0? 14 00 08 24 21 B8 40 00 04 00 A6 8C 2B 38 C6 02 87 FF E0 54 10 00 A2 A3 3B 01 D6 50 00 00 A6 8C 01 00 E2 26 20 14 02 7C F6 FF 48 14 08 00 A5 24 ?? ?? ?? 0? 10 00 A8 A3 05 00 45 10 78 00 05 24 27 FF 45 14 10 00 B5 27 ?? ?? ?? 0? 80 00 63 34 ?? ?? ?? 0? C0 00 63 34 42 FF 45 10 69 00 05 24 40 FF 45 10 10 00 B5 27 ?? ?? ?? 0? 01 00 1E 24 60 00 A5 8F 10 00 66 30 01 00 A2 80 00 00 A7 8C 04 00 A5 24 51 00 C0 10 10 00 A2 A3 50 00 40 50 14 00 A7 A3 FF FF 06 24 4D 00 46 50 14 00 A7 A3 14 00 A2 A3 15 00 A7 A3 02 00 1E 24 14 00 B5 27 ?? ?? ?? 0? 60 00 A5 AF 60 00 A2 8F 00 00 45 8C 04 00 46 24 19 01 A0 10 21 A8 A0 00 00 00 A2 80 06 00 40 10 21 F0 00 00 01 00 DE 27 21 10 BE 00 00 00 42 80 FD FF 40 54 01 00 DE 27 60 00 A6 AF 2B 90 C4 03 23 20 9E 00 0A 20 12 00 08 00 76 30 FE FE C0 16 21 90 80 00 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 21 28 80 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 F9 FF 53 16 20 00 04 24 ?? ?? ?? 0? FF FF 13 24 10 00 62 30 21 40 C0 00 0A 40 E2 00 25 18 03 01 FF FF 63 30 ?? ?? ?? 0? 00 00 22 82 21 B0 00 00 00 00 15 8D 04 00 08 25 ?? ?? ?? 0? 60 00 A8 AF 00 00 45 8C 04 00 42 24 60 00 A2 AF C3 17 05 00 21 A8 A0 00 ?? ?? ?? 0? 21 B0 40 00 D6 FE 45 14 10 00 B5 27 20 00 63 34 ?? ?? ?? 0? 80 00 63 34 30 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 2B 10 02 00 FF FF F7 26 21 80 02 02 F7 FF E0 16 28 00 A3 8F 08 00 65 30 ?? ?? ?? 0? 20 00 A5 AF 14 00 A7 A3 01 00 1E 24 14 00 B5 27 ?? ?? ?? 0? 60 00 A5 AF 1C 00 A6 8F 27 10 1E 00 06 20 D5 03 04 10 46 00 25 20 44 00 20 00 C3 33 06 10 D6 03 0B 20 43 00 07 00 84 30 30 00 84 24 ?? ?? ?? 0? 10 00 A4 A3 1C 00 A6 8F 27 18 08 00 06 10 15 01 04 18 66 00 25 10 62 00 06 28 16 01 20 00 06 31 ?? ?? 07 3C 0B 10 A6 00 24 00 A5 8F ?? ?? E3 24 ?? ?? 07 3C ?? ?? E4 24 0A 18 85 00 0F 00 42 30 21 18 62 00 00 00 64 80 ?? ?? ?? 0? 10 00 A4 A3 20 00 A7 8F 19 FE E0 50 00 00 24 82 17 FE E0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 80 02 27 10 02 00 2B 10 02 00 FF FF F7 26 F9 FF E0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 08 00 66 30 03 00 40 10 20 00 A6 AF 2B 00 C0 10 20 00 04 24 02 00 62 30 64 00 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 28 00 A3 8F 2B 10 02 00 21 80 02 02 C0 08 62 30 40 08 04 24 93 00 44 10 30 00 04 24 80 08 04 24 F1 FE 44 54 10 00 BE 83 30 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 28 00 A3 8F 27 10 02 00 58 00 05 24 20 00 66 30 2B 10 02 00 78 00 04 24 0B 20 A6 00 21 80 02 02 21 28 80 02 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 ?? ?? ?? 0? 28 00 A3 8F 20 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 2B 10 02 00 FF FF F7 26 21 80 02 02 CE FF E0 12 28 00 A3 8F 20 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 27 10 02 00 2B 10 02 00 FF FF F7 26 21 80 02 02 ED FF E0 16 28 00 A3 8F ?? ?? ?? 0? 02 00 62 30 0C 00 62 12 C0 00 02 24 0B FF 62 12 10 00 A2 83 ?? ?? ?? 0? 00 00 00 00 97 FE A0 50 01 00 E2 26 ?? ?? ?? 0? 10 00 A2 A3 2B 28 04 00 ?? ?? ?? 0? 23 20 85 00 01 00 02 24 5E 00 C0 12 10 00 A2 A3 02 00 02 24 02 00 17 24 00 01 06 24 21 38 00 00 ?? ?? ?? 0? 10 00 08 24 00 29 07 00 00 49 06 00 25 28 45 01 21 30 20 01 21 38 A0 00 21 B8 40 00 2B 28 C7 02 84 FE A0 54 10 00 A2 A3 34 00 C7 12 2B 28 A6 02 01 00 E2 26 20 14 02 7C F2 FF 48 14 02 57 06 00 ?? ?? ?? 0? 10 00 A8 A3 A8 FF 40 10 C0 08 62 30 ?? ?? ?? 0? 20 00 04 24 31 00 40 14 80 08 02 24 C0 08 64 30 94 FE 82 54 08 00 64 30 30 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 28 00 A3 8F 27 10 02 00 58 00 05 24 20 00 66 30 2B 10 02 00 78 00 04 24 0B 20 A6 00 21 80 02 02 ?? ?? ?? 0? 21 28 80 02 FE FF 84 24 ?? ?? ?? 0? 0B 20 05 00 60 00 A6 8F F8 FF 02 24 07 00 C5 24 24 10 A2 00 08 00 47 24 60 00 A7 AF 00 00 55 8C ?? ?? ?? 0? 04 00 56 8C F8 FF 02 24 07 00 E6 24 24 30 C2 00 00 00 C5 8C 04 00 C2 8C 08 00 C6 24 60 00 A6 AF 21 A8 A0 00 ?? ?? ?? 0? 21 B0 40 00 CD FF A0 50 01 00 E2 26 ?? ?? ?? 0? 10 00 A2 A3 2B 30 A6 02 C5 FE C0 50 01 00 E2 26 ?? ?? ?? 0? 10 00 A2 A3 20 00 04 24 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF ?? ?? 15 3C ?? ?? B5 26 ?? ?? ?? 0? 21 28 A0 02 21 28 80 02 ?? ?? ?? 0? 28 00 A3 AF 0A 00 A2 2E A8 FE 40 10 ?? ?? 05 3C ?? ?? ?? 0? 01 00 02 24 10 00 A2 2E A2 FF 40 50 02 00 02 24 ?? ?? ?? 0? 01 00 02 24 08 00 A2 2E 19 FE 40 50 02 00 02 24 ?? ?? ?? 0? 01 00 02 24 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "memchr"
		size = 68
	strings:
		$1 = { 0C 00 C0 10 21 10 00 00 00 00 83 90 FF 00 A5 30 08 00 65 10 21 10 80 00 FF FF 82 24 21 30 46 00 06 00 86 10 01 00 84 24 00 00 82 90 FC FF 45 14 21 10 80 00 08 00 E0 03 00 00 00 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "_filbuf"
		size = 360
		refs = "0034 _outdone 0044 _iob 0074 fflush 0094 read"
	strings:
		$1 = { 0C 00 83 94 D0 FF BD 27 18 00 B0 AF 01 00 63 30 2C 00 BF AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 21 80 80 00 04 00 80 AC 27 00 60 10 FF FF 02 24 ?? ?? 14 3C ?? ?? 82 82 13 00 40 50 10 00 06 8E ?? ?? 11 3C ?? ?? 31 26 A0 00 33 26 ?? ?? ?? 0? 02 01 12 24 0B 00 33 52 ?? ?? 80 A2 0C 00 22 96 02 01 42 30 FB FF 52 54 14 00 31 26 21 20 20 02 ?? ?? ?? 0? 14 00 31 26 F9 FF 33 56 0C 00 22 96 ?? ?? 80 A2 10 00 06 8E 17 00 C0 10 0E 00 04 96 ?? ?? ?? 0? 08 00 05 8E 27 00 40 10 04 00 02 AE FF FF 03 24 2C 00 43 50 0C 00 02 96 08 00 03 8E FF FF 42 24 04 00 02 AE 00 00 03 AE 01 00 64 24 00 00 62 90 00 00 04 AE 2C 00 BF 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 04 00 00 AE 10 00 A5 27 ?? ?? ?? 0? 01 00 06 24 01 00 03 24 09 00 43 14 2C 00 BF 8F 10 00 A2 93 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 30 00 BD 27 0C 00 03 96 FF FF 02 24 10 00 63 34 ?? ?? ?? 0? 0C 00 03 A6 0C 00 02 96 10 00 42 34 0C 00 02 A6 08 00 03 8E 04 00 00 AE FF FF 02 24 ?? ?? ?? 0? 00 00 03 AE 30 00 42 34 ?? ?? ?? 0? 0C 00 02 A6 }
	condition:
		$1
}

rule file_370_1_0 {
	meta:
		name = "_vfprintf_cdfFnopuxX"
		size = 4980
		refs = "009c _ctype 0168 fputc 0468 __floatdisf 0480 fpcmp 04e4 _npowers_f 050c fpmul 0598 fpadd 05c4 fptoui 05d4 __floatundisf 05e0 fpsub 07bc __udivdi3 07d0 __umoddi3 0a24 fpdiv 10b8 frexpf"
		altNames = "_vfprintf_cdfFnopsuxX"
	strings:
		$1 = { 98 FF BD 27 21 10 00 00 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 30 00 A2 AF 21 80 00 00 00 00 24 82 69 00 80 10 10 00 A4 A3 25 00 02 24 2E 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 22 02 46 10 FF FF 91 24 2E 00 45 28 18 02 A0 10 00 00 00 00 2A 02 47 50 01 00 63 34 26 02 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A5 24 21 20 A2 00 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 1E 02 80 10 0B 18 A6 00 21 F0 00 00 0A 00 05 24 02 20 C5 73 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 F0 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF DE 27 2E 00 04 24 1A 02 44 50 01 00 31 26 00 10 63 34 21 B0 00 00 10 00 07 24 00 80 06 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3E 00 A0 14 01 00 31 26 10 00 B3 27 01 00 17 24 04 00 C0 52 2B A0 FE 02 2B 10 D7 02 0B B8 C2 02 2B A0 FE 02 23 F0 D7 03 0A F0 14 00 08 00 76 30 0B 00 C0 16 21 A0 C0 03 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 95 16 20 00 04 24 ?? ?? ?? 0? FF FF 15 24 21 28 40 02 ?? ?? ?? 0? 01 00 73 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 56 00 00 64 82 A4 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 93 16 20 00 04 24 00 00 24 82 99 FF 80 14 10 00 A4 A3 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 ?? ?? 08 3C 80 20 04 00 ?? ?? 08 25 21 20 04 01 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 00 63 34 00 07 62 30 78 00 40 10 21 A8 60 00 00 10 65 30 06 00 04 24 10 00 62 30 38 02 40 10 0B B0 85 00 70 00 A5 8F F8 FF 02 24 07 00 A4 24 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 3C 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 3C 00 A3 8F 21 98 40 00 21 20 60 02 21 28 00 00 ?? ?? ?? 0? 3C 00 A3 AF 04 00 41 04 3C 00 A3 8F 00 80 02 3C 26 98 53 00 03 00 75 34 21 20 60 02 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF 01 03 40 14 21 B8 00 00 19 00 C2 2A 3B 00 40 10 0A 00 E2 2A FF 00 D4 32 6E 00 82 2E 27 02 40 14 0B 00 82 2E EB 51 02 3C 1F 85 42 34 19 00 82 02 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 03 3C ?? ?? 63 24 3C 00 A3 AF 10 48 00 00 42 31 09 00 FF 00 C2 30 12 00 42 24 80 10 02 00 21 10 43 00 00 00 44 8C ?? ?? ?? 0? 38 00 A6 AF 38 00 A6 8F 64 00 04 24 CC CC 07 3C 02 28 C4 70 CD CC E7 34 21 20 40 00 3C 00 A3 8F 38 00 A7 AF 23 30 85 02 FF 00 C6 30 19 00 C7 00 10 48 00 00 C0 38 22 7D 09 00 42 24 80 10 02 00 21 10 43 00 ?? ?? ?? 0? 00 00 45 8C 38 00 A7 8F 21 20 40 00 0A 00 02 24 19 00 87 02 3C 00 A3 8F 10 38 00 00 C2 28 07 00 02 30 A2 70 23 10 86 02 FF 00 42 30 80 10 02 00 21 18 43 00 ?? ?? ?? 0? 00 00 65 8C 21 20 60 02 ?? ?? ?? 0? 21 28 40 00 21 98 40 00 0A 00 E2 2A 11 01 40 10 ?? ?? 06 3C 21 20 60 02 ?? ?? ?? 0? 21 28 00 00 05 01 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 21 28 00 00 ?? ?? ?? 0? 21 A0 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 60 02 21 B8 40 00 21 98 80 02 18 00 A0 AF ?? ?? ?? 0? 21 18 00 00 20 00 63 34 80 00 63 34 00 07 62 30 8A FF 40 14 21 A8 60 00 C0 00 62 30 C8 01 40 14 20 16 03 7C 12 03 40 04 10 00 62 30 F0 01 40 10 70 00 A6 8F 70 00 A5 8F 00 00 A4 8C 04 00 A5 24 70 00 A5 AF C3 17 04 00 21 98 80 00 FB 01 40 04 21 B8 40 00 03 00 C0 16 C0 00 75 30 25 B0 77 02 01 00 D6 2E 40 00 02 24 E1 02 A2 12 41 00 A2 2A 8C 02 40 10 80 00 02 24 16 00 A0 16 10 00 A2 83 01 00 02 24 38 03 E0 12 10 00 A2 A3 ?? ?? 04 3C ?? ?? 84 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 08 24 21 38 40 00 04 00 85 8C 2B 30 E5 02 16 03 C0 54 10 00 A7 A3 10 03 B7 50 00 00 85 8C 01 00 42 24 20 14 02 7C F6 FF 48 14 08 00 84 24 10 00 A2 A3 2A 20 56 00 1E 02 80 10 2A 20 C2 02 20 14 16 7C 10 00 A2 A3 05 00 C0 13 00 40 64 30 03 00 64 30 2B 20 04 00 23 F0 C4 03 00 40 64 30 05 00 80 10 2A 28 5E 00 2A 20 DE 02 23 F0 D6 03 0A F0 04 00 2A 28 5E 00 23 10 C2 03 0A 10 05 00 04 00 64 30 0D 02 80 10 20 00 A2 AF 02 00 62 30 A7 02 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 27 10 02 00 3C 00 A3 8F 2B 10 02 00 21 80 02 02 20 00 A5 8F 08 00 64 30 B9 01 A0 14 34 00 A4 AF FF FF D6 26 ?? ?? 05 3C C0 A0 16 00 ?? ?? BE 24 03 00 02 24 21 A0 D4 03 41 00 A4 2A 80 F0 16 00 20 00 63 30 02 B0 C2 72 40 10 17 00 28 00 A2 AF 24 00 A4 AF ?? ?? ?? 0? 2C 00 A3 AF 0E 00 A0 16 10 00 A4 83 00 00 86 8E 04 00 87 8E 21 20 60 02 ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 94 26 FC FF DE 27 FD FF D6 26 FD FF 02 24 BE 01 C2 12 40 00 02 24 9D 01 A2 12 24 00 A5 8F E3 FF A0 14 80 00 02 24 A5 01 A2 12 C0 00 02 24 E1 FF A2 12 10 00 A4 83 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 04 63 34 70 00 A4 8F 10 00 66 30 01 00 82 80 00 00 85 8C 04 00 84 24 72 01 C0 10 10 00 A2 A3 71 01 40 50 14 00 A5 A3 FF FF 06 24 6E 01 46 50 14 00 A5 A3 14 00 A2 A3 15 00 A5 A3 02 00 17 24 14 00 B3 27 ?? ?? ?? 0? 70 00 A4 AF 70 00 A2 8F 00 00 44 8C 04 00 45 24 93 02 80 10 21 98 80 00 00 00 82 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 97 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A5 AF ?? ?? ?? 0? 40 00 63 34 10 00 62 30 21 48 C0 00 0A 48 E2 00 25 18 23 01 FF FF 63 30 ?? ?? ?? 0? 00 00 22 82 ED FD 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 E0 FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 EE FD 44 14 21 F0 00 00 70 00 A7 8F 01 00 31 26 00 00 22 82 00 00 FE 8C 2E 00 04 24 04 00 E7 24 E9 FD 44 14 70 00 A7 AF 01 00 31 26 00 00 22 82 2A 00 04 24 EA 01 44 10 00 40 63 34 ?? ?? 08 3C ?? ?? 08 25 21 20 02 01 01 00 84 90 21 B0 00 00 04 00 84 30 DE FD 80 10 0A 00 05 24 02 20 C5 72 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 B0 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF D6 26 ?? ?? ?? 0? 10 00 07 24 ?? ?? ?? 0? 21 20 60 02 FC FE 40 54 21 20 40 00 02 00 E3 2A F8 FE 60 14 ?? ?? 06 3C ?? ?? C6 24 30 00 A4 8F ?? ?? ?? 0? 00 00 C5 8C D7 00 40 04 ED FF E3 26 EE FF E3 26 18 00 A3 AF 20 24 03 7C ?? ?? ?? 0? 3C 00 A3 AF 21 28 40 00 21 20 60 02 ?? ?? ?? 0? 30 00 A2 AF ?? ?? ?? 0? 21 20 40 00 3C 00 A3 8F 21 A0 40 00 21 98 40 00 21 B8 00 00 01 00 04 24 0A 00 82 2E 38 02 40 14 10 00 A4 A3 ?? ?? 04 3C ?? ?? 84 24 21 10 00 00 02 00 05 24 02 00 07 24 ?? ?? ?? 0? 12 00 08 24 21 38 A0 00 04 00 86 8C 86 01 C0 14 02 00 49 24 00 00 86 8C 2B 30 86 02 82 01 C0 14 01 00 42 24 01 00 E5 24 20 2C 05 7C F5 FF 48 14 08 00 84 24 10 00 A5 A3 14 00 09 24 23 A0 C3 03 23 A0 96 02 2B 10 16 00 23 A0 89 02 03 00 A3 32 23 A0 82 02 2B 18 03 00 04 00 A2 32 57 01 40 10 23 A0 83 02 02 00 A2 32 9A 01 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 5A 08 00 B5 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 B5 32 20 00 B5 AF ?? ?? 08 3C ?? ?? ?? 0? ?? ?? 15 25 C0 18 03 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 21 20 60 02 ?? ?? ?? 0? 21 28 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 C2 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 C2 2A 0E 01 40 14 20 14 16 7C 12 00 02 24 10 00 A2 A3 EE FF D3 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 ?? ?? ?? 0? 21 28 E0 02 ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 21 B8 00 00 23 00 A0 12 10 00 A2 A3 ?? ?? 09 3C ?? ?? 3E 25 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 20 C0 02 ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B5 83 27 10 02 00 2B 10 02 00 C0 18 15 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 28 E0 02 21 20 C0 02 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 FF FF A2 26 20 14 02 7C 21 B8 60 00 E1 FF A0 16 10 00 A2 A3 0A 00 60 12 20 00 A2 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 20 00 A2 8F D6 FC 40 50 00 00 24 82 D4 FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A6 8F 00 00 D3 8C 04 00 C6 24 ?? ?? ?? 0? 70 00 A6 AF 58 01 40 04 10 00 62 30 32 00 40 10 70 00 A2 8F 70 00 A9 8F 21 B8 00 00 00 00 33 8D 04 00 29 25 ?? ?? ?? 0? 70 00 A9 AF ?? ?? ?? 0? 18 00 A3 AF 55 01 40 54 ?? ?? 02 3C CC CC 02 3C CD CC 42 34 19 00 82 02 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 06 3C ?? ?? C6 24 38 00 A6 AF 10 48 00 00 C2 18 09 00 FF 00 62 30 09 00 42 24 80 10 02 00 21 10 46 00 00 00 44 8C ?? ?? ?? 0? 3C 00 A3 AF 3C 00 A3 8F 0A 00 04 24 38 00 A6 8F 02 28 64 70 21 20 40 00 23 18 85 02 FF 00 63 30 80 18 03 00 21 30 66 00 ?? ?? ?? 0? 00 00 C5 8C ?? ?? ?? 0? 21 20 60 02 00 00 C4 8C 04 00 C6 24 70 00 A6 AF C3 17 04 00 21 98 80 00 13 FE 41 04 21 B8 40 00 ?? ?? ?? 0? 23 98 04 00 21 B8 00 00 00 00 53 8C 04 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 14 00 A5 A3 01 00 17 24 14 00 B3 27 ?? ?? ?? 0? 70 00 A4 AF 23 98 04 00 2B 20 13 00 23 10 02 00 03 00 63 34 ?? ?? ?? 0? 23 B8 44 00 30 00 04 24 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 20 00 A6 8F 27 10 02 00 2B 10 02 00 FF FF C6 24 20 00 A6 AF 21 80 02 02 F5 FF C0 14 3C 00 A3 8F 08 00 67 30 ?? ?? ?? 0? 34 00 A7 AF 28 00 A3 8F 27 10 16 00 06 20 D3 02 04 10 43 00 25 20 44 00 20 00 C3 32 06 10 D7 02 0B 20 43 00 07 00 84 30 30 00 84 24 ?? ?? ?? 0? 10 00 A4 A3 28 00 A6 8F 27 18 1E 00 06 10 D3 03 04 18 66 00 2C 00 A9 8F 25 10 62 00 20 00 C6 33 06 28 D7 03 ?? ?? 07 3C ?? ?? 08 3C ?? ?? 04 25 ?? ?? E3 24 0B 10 A6 00 0A 18 89 00 0F 00 42 30 21 18 62 00 00 00 64 80 ?? ?? ?? 0? 10 00 A4 A3 34 00 A4 8F 4F FC 80 50 00 00 24 82 20 00 A5 8F 4C FC A0 58 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 20 00 A6 8F 27 10 02 00 2B 10 02 00 FF FF C6 24 20 00 A6 AF F7 FF C0 14 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 ?? ?? ?? 0? 0B B0 44 00 20 00 A9 8F 08 00 68 30 03 00 20 11 34 00 A8 AF 11 00 00 11 20 00 04 24 02 00 62 30 77 00 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 27 10 02 00 2B 10 02 00 21 80 02 02 ?? ?? ?? 0? 3C 00 A3 8F 20 00 04 24 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 20 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 20 00 A4 AF 21 80 02 02 E6 FF 80 10 3C 00 A3 8F 20 00 04 24 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 20 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 20 00 A4 AF 21 80 02 02 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "_dvfprintf_s"
		size = 2188
		refs = "0094 _ctype 01bc fputc 05e4 __udivdi3 05f8 __umoddi3"
		altNames = "_vfprintf _vfprintf_s"
	strings:
		$1 = { B0 FF BD 27 34 00 B3 AF 2C 00 B1 AF 28 00 B0 AF 4C 00 BF AF 48 00 BE AF 44 00 B7 AF 40 00 B6 AF 3C 00 B5 AF 38 00 B4 AF 30 00 B2 AF 21 98 80 00 21 88 A0 00 58 00 A6 AF 21 80 00 00 00 00 24 82 40 00 80 10 10 00 A4 A3 25 00 02 24 88 00 82 14 01 00 32 26 02 00 22 26 FF FF 43 80 2D 00 05 24 21 B0 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 7C 00 65 10 FF FF 51 24 2E 00 64 28 72 00 80 10 00 00 00 00 84 00 66 50 01 00 D6 36 80 00 68 50 02 00 D6 36 ?? ?? 04 3C ?? ?? 84 24 21 10 83 00 01 00 42 90 02 00 C5 32 FE 00 C4 32 0B B0 85 00 08 00 C5 32 FB 00 C4 32 04 00 42 30 78 00 40 10 0B B0 85 00 21 10 00 00 0A 00 05 24 02 20 45 70 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 10 83 00 00 00 23 82 21 20 C3 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF 42 24 2E 00 04 24 74 00 64 10 21 F0 00 00 73 00 04 24 63 00 06 24 6C 00 07 24 10 00 08 24 74 00 65 28 10 00 A3 A3 EE 00 64 10 01 00 31 26 14 00 A0 50 75 00 04 24 FE 00 66 50 58 00 A7 8F F7 00 67 50 10 00 C3 32 12 00 60 14 10 00 B4 27 4C 00 BF 8F 21 10 00 02 48 00 BE 8F 44 00 B7 8F 40 00 B6 8F 3C 00 B5 8F 38 00 B4 8F 34 00 B3 8F 30 00 B2 8F 2C 00 B1 8F 28 00 B0 8F 08 00 E0 03 50 00 BD 27 CD 00 64 10 78 00 04 24 6B 00 64 10 10 00 B4 27 01 00 17 24 04 00 C0 53 2B 90 E2 02 2B 18 D7 03 0B B8 C3 03 2B 90 E2 02 23 10 57 00 0A 10 12 00 08 00 D6 32 0C 00 C0 16 21 90 40 00 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 55 16 21 28 60 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 60 02 8C FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 93 FF 67 14 ?? ?? 04 3C 04 00 D6 36 01 00 42 24 FF FF 43 80 86 FF 65 14 FF FF 51 24 08 00 D6 36 ?? ?? ?? 0? 01 00 42 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 42 24 ?? ?? ?? 0? 01 00 42 24 2A 00 04 24 94 FF 64 14 21 10 00 00 58 00 A7 8F 01 00 31 26 00 00 23 82 00 00 E2 8C 2E 00 04 24 04 00 E7 24 58 00 A7 AF 8E FF 64 14 21 F0 00 00 01 00 31 26 00 00 23 82 2A 00 04 24 4B 01 64 10 ?? ?? 05 3C ?? ?? A5 24 21 20 A3 00 01 00 84 90 04 00 84 30 83 FF 80 10 0A 00 05 24 02 20 C5 73 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 F0 83 00 00 00 23 82 21 20 C3 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF DE 27 ?? ?? ?? 0? 73 00 04 24 80 00 D7 36 10 00 E3 32 62 00 60 10 58 00 A4 8F 58 00 A3 8F 21 B0 00 00 00 00 74 8C 04 00 63 24 58 00 A3 AF 03 00 C0 17 C0 00 F5 32 25 F0 96 02 01 00 DE 2F 80 00 03 24 E3 00 A3 12 C0 00 03 24 CC 00 A3 12 10 00 A3 83 2A 20 7E 00 C7 00 80 10 2A 20 C3 03 20 1C 1E 7C 10 00 A3 A3 05 00 40 10 2A 28 62 00 03 00 E4 32 2B 20 04 00 23 10 44 00 2A 28 62 00 23 18 43 00 0A 18 05 00 04 00 E4 32 A7 00 80 10 18 00 A3 AF 02 00 E2 32 F3 00 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A6 8F 64 00 C0 14 30 00 04 24 08 00 F7 32 20 00 B7 AF FF FF C8 27 ?? ?? 06 3C C0 90 08 00 ?? ?? C6 24 40 38 16 00 21 90 D2 00 80 40 08 00 80 00 17 24 11 00 C0 13 1C 00 A7 AF 7A 00 B7 12 FF FF DE 27 C0 00 02 24 68 00 A2 52 00 00 46 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 24 00 A8 AF 24 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 52 26 F1 FF C0 17 FC FF 08 25 20 00 A6 8F F4 FE C0 50 00 00 24 82 18 00 A7 8F F1 FE E0 58 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 18 00 A3 AF F7 FF 60 14 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 C0 00 D7 36 10 00 E3 32 A2 FF 60 14 58 00 A3 8F 58 00 A4 8F 21 B0 00 00 00 00 94 8C 04 00 84 24 ?? ?? ?? 0? 58 00 A4 AF 58 00 A6 8F 00 00 C4 8C 04 00 C5 24 DB 00 80 10 21 A0 80 00 00 00 83 80 06 00 60 10 21 B8 00 00 01 00 F7 26 21 18 97 00 00 00 63 80 FD FF 60 54 01 00 F7 26 ?? ?? ?? 0? 58 00 A5 AF 21 28 00 00 0A 28 03 01 25 B0 B6 00 ?? ?? ?? 0? 00 00 23 82 10 00 C6 32 01 00 E3 80 00 00 E5 8C 04 00 E4 24 0C 00 C0 10 10 00 A3 A3 0B 00 60 50 14 00 A5 A3 FF FF 06 24 08 00 66 50 14 00 A5 A3 14 00 A3 A3 15 00 A5 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 58 00 A4 AF 14 00 A5 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 58 00 A4 AF 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A7 8F 27 10 02 00 2B 10 02 00 FF FF E7 24 18 00 A7 AF 95 FF E0 10 21 80 02 02 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A7 8F 27 10 02 00 2B 10 02 00 FF FF E7 24 18 00 A7 AF ED FF E0 14 21 80 02 02 ?? ?? ?? 0? 08 00 F7 32 04 00 47 8E 21 20 80 02 21 28 C0 02 ?? ?? ?? 0? 24 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 24 00 A8 8F 1C 00 A4 8F 27 18 08 00 06 10 14 01 04 18 64 00 25 10 62 00 20 00 04 31 06 18 16 01 0B 10 64 00 ?? ?? 05 3C 0F 00 42 30 ?? ?? A5 24 21 10 A2 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 18 00 A2 8F 55 00 40 14 08 00 E4 32 08 00 E3 32 20 00 A3 AF 02 00 E2 32 4C 00 40 50 01 00 F7 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 ?? ?? ?? 0? 0B F0 64 00 01 00 03 24 73 00 C0 12 10 00 A3 A3 ?? ?? 05 3C ?? ?? A4 24 02 00 07 24 02 00 03 24 ?? ?? ?? 0? 14 00 08 24 21 38 60 00 04 00 85 8C 01 00 63 24 2B 30 C5 02 5B 00 C0 14 20 1C 03 7C 56 00 B6 50 00 00 85 8C F7 FF 68 14 08 00 84 24 ?? ?? ?? 0? 10 00 A3 A3 01 00 03 24 59 00 C0 12 10 00 A3 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 41 04 00 02 00 03 24 02 4F 04 00 25 48 26 01 01 00 63 24 21 30 00 01 2B 40 C5 02 02 00 0A 24 10 00 0B 24 20 1C 03 7C 11 00 00 15 21 38 20 01 39 00 C5 12 2B 20 84 02 E9 FF 6B 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 41 04 00 02 4F 04 00 25 48 26 01 21 50 60 00 21 30 00 01 01 00 63 24 2B 40 C5 02 20 1C 03 7C F1 FF 00 11 21 38 20 01 10 00 AA A3 ?? ?? ?? 0? 21 18 40 01 18 FF 40 10 18 00 A6 8F ?? ?? ?? 0? 20 00 04 24 19 FF E0 12 FF FF C8 27 ?? ?? ?? 0? 20 00 04 24 AD FF 80 14 20 00 A4 AF 21 28 60 02 ?? ?? ?? 0? 20 00 04 24 18 00 A5 8F 27 10 02 00 2B 10 02 00 FF FF A5 24 18 00 A5 AF A3 FF A0 10 21 80 02 02 21 28 60 02 ?? ?? ?? 0? 20 00 04 24 18 00 A5 8F 27 10 02 00 2B 10 02 00 FF FF A5 24 18 00 A5 AF ED FF A0 14 21 80 02 02 ?? ?? ?? 0? 02 00 E2 32 58 00 A6 8F 01 00 31 26 00 00 23 82 00 00 DE 8C 04 00 C6 24 ?? ?? ?? 0? 58 00 A6 AF C7 FF 80 10 00 00 00 00 10 00 AA A3 ?? ?? ?? 0? 21 18 40 01 2B 28 85 02 A9 FF A0 10 00 00 00 00 10 00 A7 A3 ?? ?? ?? 0? 21 18 E0 00 ?? ?? 14 3C ?? ?? 94 26 ?? ?? ?? 0? 21 20 80 02 10 00 83 2E A7 FF 60 10 00 01 04 24 ?? ?? ?? 0? 01 00 03 24 0A 00 83 2E 8D FF 60 10 ?? ?? 05 3C ?? ?? ?? 0? 01 00 03 24 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "exit"
		size = 52
		refs = "000c _cleanup 0014 _exit"
	strings:
		$1 = { E0 FF BD 27 10 00 A4 AF 1C 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 02 3C ?? ?? 42 24 03 00 40 10 10 00 A4 8F ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 }
	condition:
		$1
}

rule file_420_0_0 {
	meta:
		name = "atoll"
		size = 32
		refs = "000c strtoll"
	strings:
		$1 = { E8 FF BD 27 21 28 00 00 14 00 BF AF ?? ?? ?? 0? 0A 00 06 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_275_0_4 {
	meta:
		name = "atoi"
		size = 32
		refs = "000c _Stoul"
	strings:
		$1 = { E8 FF BD 27 21 28 00 00 14 00 BF AF ?? ?? ?? 0? 0A 00 06 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_8_0_4 {
	meta:
		name = "atol"
		size = 32
		refs = "000c _Stoul"
	strings:
		$1 = { E8 FF BD 27 21 28 00 00 14 00 BF AF ?? ?? ?? 0? 0A 00 06 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_248_0_4 {
	meta:
		name = "atoll"
		size = 32
		refs = "000c _Stoull"
	strings:
		$1 = { E8 FF BD 27 21 28 00 00 14 00 BF AF ?? ?? ?? 0? 0A 00 06 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "fclose"
		size = 252
		refs = "0044 fflush 006c close 0098 _tfilesptr 00d0 _buffree 00e0 remove"
	strings:
		$1 = { 0C 00 82 94 E0 FF BD 27 14 00 B1 AF 03 00 42 30 1C 00 BF AF 18 00 B2 AF 10 00 B0 AF 21 88 80 00 08 00 40 14 FF FF 03 24 1C 00 BF 8F 21 10 60 00 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 00 00 00 00 0C 00 30 96 08 00 24 8E F8 FE 02 32 04 00 80 10 0C 00 22 A6 08 00 42 30 1A 00 40 10 00 00 00 00 ?? ?? ?? 0? 0E 00 24 96 FF FF 04 24 EB FF 44 10 FF FF 03 24 0C 00 22 96 20 00 42 30 E7 FF 40 14 00 10 10 32 E5 FF 00 12 21 18 00 00 ?? ?? 12 3C ?? ?? 44 8E E1 FF 80 10 21 18 40 00 21 80 00 00 C0 02 03 24 54 00 82 8C 0A 00 51 10 00 00 00 00 58 00 10 26 FB FF 03 16 58 00 84 24 ?? ?? ?? 0? 21 18 00 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 08 00 20 AE ?? ?? ?? 0? 00 00 00 00 ?? ?? 42 8E 21 18 00 00 21 80 50 00 ?? ?? ?? 0? 54 00 00 AE }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "ultoa"
		size = 104
		altNames = "utoa"
	strings:
		$1 = { 21 10 80 00 ?? ?? ?? 0? 21 20 A0 00 21 10 60 00 1B 00 86 00 F4 01 C0 00 12 20 00 00 FB FF 80 14 01 00 43 24 00 00 60 A0 1B 00 A6 00 F4 01 C0 00 10 28 00 00 20 1C 05 7C 0A 00 64 28 12 40 00 00 07 00 67 24 02 00 80 14 12 28 00 00 20 1C 07 7C 30 00 63 24 00 00 43 A0 F3 FF 00 15 FF FF 42 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_434_1_0 {
	meta:
		name = "ltoa"
		size = 64
		refs = "0024 ultoa"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 14 00 BF AF 05 00 A1 04 21 80 80 00 2D 00 02 24 00 00 82 A0 23 28 05 00 01 00 84 24 ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_963_1_0 {
	meta:
		name = "itoa"
		size = 64
		refs = "0024 utoa"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 14 00 BF AF 05 00 A1 04 21 80 80 00 2D 00 02 24 00 00 82 A0 23 28 05 00 01 00 84 24 ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "fopen"
		size = 100
		refs = "0000 _iob 0050 freopen"
	strings:
		$1 = { ?? ?? 06 3C ?? ?? C6 24 0C 00 C2 94 E8 FF BD 27 03 00 42 30 0E 00 40 14 14 00 BF AF A0 00 C3 24 ?? ?? 06 3C ?? ?? C6 24 0C 00 C2 94 03 00 42 30 07 00 40 14 00 00 00 00 14 00 C6 24 FB FF C3 54 0C 00 C2 94 14 00 BF 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "atof"
		size = 28
		refs = "0008 strtof"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 28 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1020_0_0 {
	meta:
		name = "_datof"
		size = 28
		refs = "0008 _dstrtod"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 28 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_346_0_4 {
	meta:
		name = "ftell"
		size = 28
		refs = "0008 _Fgpos"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 28 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_487_0_4 {
	meta:
		name = "log"
		size = 28
		refs = "0008 _Log"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 28 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_438_0_4 {
	meta:
		name = "logf"
		size = 28
		refs = "0008 _FLog"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 28 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_374_0_4 {
	meta:
		name = "sin"
		size = 28
		refs = "0008 _Sin"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 28 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_223_0_4 {
	meta:
		name = "sinf"
		size = 28
		refs = "0008 _FSin"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 28 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_69_0_4 {
	meta:
		name = "strerror"
		size = 28
		refs = "0008 _Strerror"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 28 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_453_0_0 {
	meta:
		name = "atoi"
		size = 160
		refs = "0038 _ctype"
	strings:
		$1 = { 20 00 02 24 09 00 05 24 00 00 83 80 FE FF 62 50 01 00 84 24 03 00 65 54 2D 00 02 24 ?? ?? ?? 0? 01 00 84 24 18 00 62 50 01 00 84 24 2B 00 02 24 18 00 62 10 21 40 00 00 ?? ?? 06 3C ?? ?? C6 24 21 10 C3 00 01 00 45 90 04 00 A5 30 0B 00 A0 10 21 10 00 00 0A 00 07 24 02 28 47 70 01 00 84 24 21 10 A3 00 00 00 83 80 21 28 C3 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 42 24 23 18 02 00 08 00 E0 03 0B 10 68 00 00 00 83 80 ?? ?? ?? 0? 01 00 08 24 01 00 83 80 ?? ?? ?? 0? 01 00 84 24 }
	condition:
		$1
}

rule file_460_0_0 {
	meta:
		name = "strtok"
		size = 240
		refs = "0028 strspn 0064 strcspn"
	strings:
		$1 = { E0 FF BD 27 18 00 B2 AF 14 00 B1 AF 1C 00 BF AF 10 00 B0 AF 21 88 80 00 2B 00 80 10 21 90 A0 00 ?? ?? 10 3C 21 20 20 02 ?? ?? ?? 0? 21 28 40 02 21 88 22 02 00 00 22 82 09 00 40 14 1C 00 BF 8F 21 88 00 00 21 10 20 02 ?? ?? 00 AE 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 21 20 20 02 ?? ?? ?? 0? 21 28 40 02 21 10 22 02 ?? ?? 02 AE 00 00 44 80 09 00 80 14 ?? ?? 03 3C 1C 00 BF 8F 21 10 20 02 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F ?? ?? 60 AC 08 00 E0 03 20 00 BD 27 00 00 40 A0 1C 00 BF 8F 01 00 44 24 18 00 B2 8F 21 10 20 02 10 00 B0 8F 14 00 B1 8F ?? ?? 64 AC 08 00 E0 03 20 00 BD 27 ?? ?? 10 3C ?? ?? 11 8E D4 FF 20 16 1C 00 BF 8F 21 10 20 02 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_463_0_0 {
	meta:
		name = "uldiv"
		size = 32
		altNames = "udiv"
	strings:
		$1 = { 1B 00 A6 00 F4 01 C0 00 21 10 80 00 10 18 00 00 04 00 83 AC 12 28 00 00 08 00 E0 03 00 00 85 AC }
	condition:
		$1
}

rule file_466_0_0 {
	meta:
		name = "strncat"
		size = 112
	strings:
		$1 = { 00 00 83 80 05 00 60 10 21 10 80 00 01 00 84 24 00 00 83 80 FE FF 60 54 01 00 84 24 12 00 C0 10 21 18 80 00 00 00 A3 80 0D 00 60 10 00 00 83 A0 01 00 83 24 21 20 86 00 08 00 64 10 01 00 A5 24 00 00 A7 80 01 00 A5 24 05 00 E0 10 00 00 67 A0 01 00 63 24 FB FF 64 54 00 00 A7 80 00 00 60 A0 08 00 E0 03 00 00 00 00 08 00 E0 03 00 00 60 A0 }
	condition:
		$1
}

rule file_469_1_0 {
	meta:
		name = "_vfprintf_eEs"
		size = 5524
		refs = "000c _ctype 01a8 fputc 03c0 __floatdisf 03e0 fpcmp 0454 fptoui 050c __udivdi3 0548 __umoddi3 0818 _npowers_f 0844 fpmul 08d8 fpadd 0934 fpdiv 0ddc __floatunsisf 0de8 fpsub 10cc frexpf 1258 __floatundisf"
		altNames = "_vfprintf_eE"
	strings:
		$1 = { 98 FF BD 27 60 00 BE AF 21 10 00 00 ?? ?? 1E 3C 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 2C 00 A2 AF 21 80 00 00 ?? ?? DE 27 00 00 24 82 3E 00 80 10 10 00 A4 A3 25 00 02 24 52 00 82 14 01 00 33 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 30 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 46 00 45 10 FF FF 71 24 2E 00 44 28 3C 00 80 10 00 00 00 00 4E 00 47 50 01 00 C6 34 4A 00 49 50 02 00 C6 34 21 18 C2 03 01 00 63 90 02 00 C5 30 FE FF C4 30 0B 30 85 00 08 00 C5 30 FB FF C4 30 04 00 63 30 44 00 60 10 0B 30 85 00 21 18 00 00 0A 00 05 24 02 20 65 70 01 00 31 26 21 18 82 00 00 00 22 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 63 24 2E 00 04 24 42 00 44 50 01 00 31 26 00 10 C6 34 21 98 00 00 6C 00 04 24 10 00 07 24 00 80 05 24 10 00 A2 A3 C8 02 44 10 01 00 31 26 6D 00 44 28 4C 00 80 10 75 00 04 24 63 00 04 24 C9 02 44 10 64 00 44 28 8C 00 80 50 65 00 04 24 FA 02 40 14 45 00 04 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C9 FF 48 54 21 18 C2 03 04 00 C6 34 01 00 63 24 FF FF 62 80 BC FF 45 14 FF FF 71 24 08 00 C6 34 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 C6 FF 44 14 21 18 00 00 70 00 A5 8F 01 00 31 26 00 00 22 82 00 00 A3 8C 2E 00 04 24 04 00 A5 24 C1 FF 44 14 70 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 A6 03 44 10 00 40 C6 34 21 20 C2 03 01 00 84 90 21 98 00 00 04 00 84 30 B8 FF 80 10 0A 00 05 24 02 20 65 72 01 00 31 26 21 98 82 00 00 00 22 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 73 26 ?? ?? ?? 0? 6C 00 04 24 93 02 44 10 78 00 04 24 8F 02 44 10 73 00 04 24 32 00 44 10 70 00 A9 8F 10 00 B4 27 01 00 17 24 04 00 60 52 2B 98 E3 02 2B 10 77 02 0B B8 62 02 2B 98 E3 02 23 18 77 00 0A 18 13 00 08 00 D6 30 0C 00 C0 16 21 98 60 00 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 20 00 04 24 F8 FF 75 16 21 28 40 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 40 02 54 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 20 00 04 24 F8 FF 74 16 21 28 40 02 ?? ?? ?? 0? 00 00 24 82 00 00 24 8D 04 00 25 25 04 04 80 10 21 A0 80 00 00 00 82 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 97 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A5 AF C1 FF 44 14 10 00 B4 27 00 01 C6 34 00 07 C2 30 AC 00 40 10 21 B0 C0 00 00 10 C5 30 06 00 04 24 10 00 C2 30 10 01 40 10 0B 98 85 00 70 00 AB 8F F8 FF 02 24 07 00 64 25 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 38 00 A3 AF 34 00 A6 AF ?? ?? ?? 0? 70 00 A2 AF 38 00 A3 8F 34 00 A6 8F 21 A8 40 00 21 20 A0 02 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 34 00 A6 AF 38 00 A3 8F 04 00 41 04 34 00 A6 8F 00 80 02 3C 26 A8 55 00 03 00 D6 34 21 20 A0 02 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 18 00 A0 AF 21 B8 00 00 2B 03 40 14 38 00 A3 8F 00 01 C2 32 F1 00 40 10 19 00 62 2A 13 00 62 2E 56 02 40 10 12 00 02 24 21 20 A0 02 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 10 00 B3 A3 56 02 40 14 38 00 A3 8F ?? ?? ?? 0? 21 20 A0 02 21 A8 40 00 38 00 A3 8F ?? ?? 02 3C ?? ?? 42 24 24 00 A2 AF FB FF 63 24 03 00 C2 32 23 A0 73 00 2B 18 02 00 04 00 C2 32 8B 02 40 10 23 A0 83 02 02 00 C2 32 66 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 26 04 80 1A 08 00 CB 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 C2 32 28 00 A2 AF 10 00 A2 83 24 00 A7 8F 21 20 A0 02 C0 10 02 00 21 10 E2 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 24 00 A8 8F 27 10 02 00 C0 18 03 00 21 18 03 01 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 A7 03 60 16 21 B8 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F D8 03 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 13 24 21 28 40 02 1A 00 53 00 F4 01 60 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 73 00 F4 01 60 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 28 00 A2 8F 94 FE 40 50 00 00 24 82 92 FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 06 7C C9 02 40 04 10 00 C2 30 9C 01 40 10 70 00 AA 8F 70 00 A9 8F 21 B8 00 00 00 00 34 8D 04 00 29 25 70 00 A9 AF 03 00 60 16 C0 00 D6 30 25 98 97 02 01 00 73 2E 80 00 02 24 73 02 C2 12 C0 00 02 24 5C 02 C2 12 10 00 A2 83 2A 20 53 00 44 02 80 10 2A 20 62 02 20 14 13 7C 10 00 A2 A3 05 00 60 10 00 40 C4 30 03 00 C4 30 2B 20 04 00 23 18 64 00 00 40 C4 30 05 00 80 10 2A 28 43 00 2A 20 63 02 23 18 73 00 0A 18 04 00 2A 28 43 00 23 10 62 00 0A 10 05 00 04 00 C4 30 33 02 80 10 20 00 A2 AF 02 00 C2 30 A9 02 40 10 01 00 C2 30 01 00 C4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 21 28 40 02 ?? ?? ?? 0? 34 00 A6 AF 27 10 02 00 34 00 A6 8F 2B 10 02 00 21 80 02 02 20 00 AB 8F 6C 01 60 15 30 00 04 24 08 00 C6 30 28 00 A6 AF FF FF 68 26 ?? ?? 09 3C C0 A8 08 00 ?? ?? 29 25 40 50 17 00 21 A8 35 01 80 40 08 00 12 00 60 12 24 00 AA AF 80 00 0B 24 02 02 CB 12 FF FF 73 26 C0 00 02 24 F0 01 C2 52 00 00 A6 8E 10 00 A4 83 21 28 40 02 ?? ?? ?? 0? 30 00 A8 AF 30 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F0 FF 60 16 FC FF 08 25 28 00 A7 8F 2E FE E0 50 00 00 24 82 20 00 A8 8F 2B FE 00 59 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 20 00 A9 8F 27 10 02 00 2B 10 02 00 FF FF 29 25 20 00 A9 AF F7 FF 20 15 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A2 8F 00 00 55 8C 04 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 3F 00 40 10 0A 00 E2 2A FF 00 74 32 6E 00 82 2E A5 02 40 14 0B 00 82 2E EB 51 02 3C 1F 85 42 34 19 00 82 02 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 06 3C ?? ?? C6 24 38 00 A3 AF 34 00 A6 AF 10 48 00 00 42 39 09 00 FF 00 E2 30 12 00 42 24 80 10 02 00 21 10 46 00 00 00 44 8C ?? ?? ?? 0? 30 00 A7 AF 30 00 A7 8F 64 00 04 24 CC CC 08 3C 02 28 E4 70 CD CC 08 35 21 20 40 00 34 00 A6 8F 30 00 A8 AF 23 38 85 02 FF 00 E7 30 19 00 E8 00 10 58 00 00 C0 38 62 7D 09 00 42 24 80 10 02 00 21 10 46 00 ?? ?? ?? 0? 00 00 45 8C 30 00 A8 8F 21 20 40 00 0A 00 02 24 19 00 88 02 34 00 A6 8F 10 48 00 00 C2 28 09 00 02 38 A2 70 23 10 87 02 FF 00 42 30 80 10 02 00 21 30 46 00 ?? ?? ?? 0? 00 00 C5 8C 38 00 A3 8F 21 20 A0 02 21 28 40 00 ?? ?? ?? 0? 38 00 A3 AF 38 00 A3 8F 21 A8 40 00 0A 00 E2 2A 19 01 40 14 21 20 A0 02 ?? ?? 07 3C ?? ?? E7 24 2C 00 A4 8F 00 00 E5 8C ?? ?? ?? 0? 38 00 A3 AF 41 02 40 04 38 00 A3 8F EE FF E6 26 18 00 A6 AF 20 24 06 7C 38 00 A3 AF ?? ?? ?? 0? 34 00 A6 AF 21 28 40 00 21 20 A0 02 ?? ?? ?? 0? 2C 00 A2 AF ?? ?? ?? 0? 21 20 40 00 38 00 A3 8F 34 00 A6 8F 21 40 00 00 21 B8 40 00 21 A0 40 00 24 00 A8 AF 01 00 04 24 0A 00 E2 2E FF 02 40 14 10 00 A4 A3 ?? ?? 0A 3C ?? ?? 47 25 21 10 00 00 02 00 0A 24 02 00 04 24 12 00 09 24 04 00 E5 8C 02 00 48 24 01 00 84 24 90 02 A0 14 01 00 42 24 00 00 E5 8C 20 24 04 7C 2B 28 E5 02 8B 02 A0 14 08 00 E7 24 F5 FF 49 54 21 50 80 00 10 00 A4 A3 14 00 08 24 23 A8 66 00 23 A8 B3 02 2B 10 13 00 23 A8 A8 02 03 00 C3 32 23 A8 A2 02 2B 18 03 00 04 00 C2 32 67 02 40 10 23 A8 A3 02 02 00 C2 32 C7 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 A0 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 08 00 D6 32 ?? ?? ?? 0? 20 00 B6 AF 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 ?? ?? 0A 3C ?? ?? 4A 25 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 20 80 02 21 28 00 00 21 30 46 01 E8 FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 62 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 62 2A 1E 02 40 14 20 14 13 7C 12 00 02 24 10 00 A2 A3 EE FF 73 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 24 00 A5 8F 21 20 40 00 ?? ?? ?? 0? 21 B0 00 00 ?? ?? ?? 0? 21 20 40 00 21 B8 40 00 FF FF 82 26 20 14 02 7C 25 00 80 12 10 00 A2 A3 ?? ?? 0B 3C ?? ?? 6B 25 C0 10 02 00 21 10 62 01 00 00 46 8C 04 00 47 8C 21 20 E0 02 ?? ?? ?? 0? 21 28 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B4 83 ?? ?? 04 3C ?? ?? 84 24 C0 18 14 00 21 18 83 00 00 00 66 8C 04 00 67 8C 27 10 02 00 2B 10 02 00 21 28 C0 02 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF 82 26 20 14 02 7C 21 B0 60 00 DD FF 80 16 10 00 A2 A3 0A 00 60 12 20 00 A5 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 20 00 A5 8F 11 FD A0 50 00 00 24 82 0F FD A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 10 00 C2 30 21 40 A0 00 0A 40 E2 00 25 30 06 01 FF FF C6 30 ?? ?? ?? 0? 00 00 22 82 70 00 AA 8F 10 00 C7 30 01 00 42 81 00 00 45 8D 04 00 44 25 33 00 E0 10 10 00 A2 A3 32 00 40 50 14 00 A5 A3 FF FF 07 24 2F 00 47 50 14 00 A5 A3 14 00 A2 A3 15 00 A5 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF ?? ?? ?? 0? 80 00 C6 34 ?? ?? ?? 0? C0 00 C6 34 21 B8 00 00 00 00 54 8D 04 00 4A 25 ?? ?? ?? 0? 70 00 AA AF 30 00 04 24 21 28 40 02 ?? ?? ?? 0? 34 00 A6 AF 20 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 20 00 A3 AF 21 80 02 02 8B FE 60 10 34 00 A6 8F 30 00 04 24 21 28 40 02 ?? ?? ?? 0? 34 00 A6 AF 20 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 20 00 A3 AF 21 80 02 02 E9 FF 60 14 34 00 A6 8F ?? ?? ?? 0? 08 00 C6 30 51 FD 44 14 10 00 B4 27 ?? ?? ?? 0? 20 00 C6 34 14 00 A5 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 36 01 40 10 38 00 A3 8F ?? ?? ?? 0? 21 20 A0 02 36 01 40 14 38 00 A3 8F 02 00 E4 2A DE FE 80 10 ?? ?? 07 3C ?? ?? ?? 0? 21 20 40 00 21 20 A0 02 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 10 00 A2 A3 AC FD 40 10 38 00 A3 8F 10 00 A7 83 38 00 A3 AF 23 20 E7 02 20 24 04 7C ?? ?? ?? 0? 30 00 A7 AF 21 28 40 00 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 21 20 40 00 ?? ?? ?? 0? 34 00 A2 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? 05 3C ?? ?? A4 8C ?? ?? ?? 0? 21 28 40 00 38 00 A3 8F 34 00 A6 8F 0B 00 40 1C 30 00 A7 8F ?? ?? 08 3C ?? ?? 05 8D ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 30 00 A7 8F 38 00 A3 8F 21 30 40 00 01 00 E2 24 ?? ?? 09 3C ?? ?? 29 25 C0 10 02 00 21 10 22 01 04 00 44 8C 21 A8 C0 00 30 01 80 14 24 00 A9 AF 00 00 42 8C 2B 10 C2 00 2D 01 40 14 ?? ?? 0A 3C ?? ?? 02 3C ?? ?? 45 8C 01 00 F7 26 21 20 80 02 38 00 A3 AF ?? ?? ?? 0? 18 00 B7 AF ?? ?? ?? 0? 21 20 40 00 38 00 A3 8F 21 A8 40 00 03 00 C2 32 FB FF 63 24 23 A0 73 00 2B 18 02 00 04 00 C2 32 77 FD 40 14 23 A0 83 02 08 00 C3 32 0B 00 60 14 28 00 A3 AF 0A 00 80 1A 02 00 C2 32 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 C2 32 E5 00 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 30 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 30 00 A8 8F 24 00 A4 8F 27 18 08 00 06 10 14 01 04 18 64 00 25 10 62 00 20 00 04 31 06 18 17 01 0B 10 64 00 ?? ?? 05 3C 0F 00 42 30 ?? ?? A5 24 21 10 A2 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 ?? ?? ?? 0? 0B 98 44 00 20 00 A4 8F 7F 00 80 14 08 00 C7 30 08 00 C5 30 28 00 A5 AF 02 00 C2 30 76 00 40 50 01 00 C6 30 01 00 C4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 01 00 02 24 5E 01 E0 12 10 00 A2 A3 ?? ?? 0B 3C ?? ?? 64 25 }
	condition:
		$1
}

rule file_471_0_0 {
	meta:
		name = "qsort"
		size = 576
		refs = "00b4 memcpy 0188 free 01c8 _swap 0220 malloc"
	strings:
		$1 = { 18 FC BD 27 20 03 C2 2C DC 03 B7 AF D8 03 B6 AF C8 03 B2 AF E4 03 BF AF E0 03 BE AF D4 03 B5 AF D0 03 B4 AF CC 03 B3 AF C4 03 B1 AF C0 03 B0 AF 21 B0 C0 00 21 B8 80 00 78 00 40 10 21 90 E0 00 90 00 A3 27 B8 03 A3 AF 21 88 60 00 21 10 36 02 FF FF A5 24 00 00 40 A0 23 98 16 00 B4 03 A0 AF 10 00 A0 AF 14 00 A5 AF B4 03 A4 8F 10 00 A3 27 C0 10 04 00 21 10 62 00 00 00 5E 8C 04 00 42 8C FF FF 84 24 B4 03 A4 AF B0 03 A2 AF B0 03 A4 8F 21 30 C0 02 B0 03 B0 8F 21 10 9E 00 C2 2F 02 00 21 10 A2 00 43 28 02 00 02 10 B6 70 21 20 20 02 21 A0 C0 03 ?? ?? ?? 0? 21 28 57 00 02 10 96 72 21 28 20 02 21 A8 57 00 09 F8 40 02 21 20 A0 02 44 00 40 04 02 10 16 72 ?? ?? ?? 0? 21 18 57 00 FF FF 10 26 21 28 60 00 BC 03 A3 AF 09 F8 40 02 21 20 20 02 BC 03 A3 8F 21 30 60 00 F8 FF 40 04 21 18 73 00 2A 10 14 02 2D 00 40 10 21 20 C0 02 EB FF 40 10 02 10 96 72 B0 03 A4 8F 23 18 1E 02 23 10 94 00 2A 10 62 00 30 00 40 10 2A 10 D0 03 2A 10 84 02 0A 00 40 50 B0 03 B0 AF B4 03 A2 8F 10 00 A3 27 B0 03 B0 AF 01 00 42 24 B4 03 A2 AF C0 10 02 00 21 10 62 00 04 00 44 AC 00 00 54 AC B0 03 A4 8F 2A 10 C4 03 CA FF 40 54 21 30 C0 02 B4 03 A2 8F BD FF 43 04 B4 03 A4 8F B8 03 A3 8F 04 00 23 12 E4 03 BF 8F ?? ?? ?? 0? 21 20 20 02 E4 03 BF 8F E0 03 BE 8F DC 03 B7 8F D8 03 B6 8F D4 03 B5 8F D0 03 B4 8F CC 03 B3 8F C8 03 B2 8F C4 03 B1 8F C0 03 B0 8F 08 00 E0 03 E8 03 BD 27 21 28 A0 02 01 00 94 26 ?? ?? ?? 0? FF FF 10 26 2A 10 14 02 BA FF 40 10 02 10 96 72 ?? ?? ?? 0? B0 03 A4 8F ?? ?? ?? 0? 01 00 94 26 DC FF 40 50 21 F0 80 02 B4 03 A4 8F 10 00 A3 27 01 00 84 24 C0 10 04 00 21 10 62 00 00 00 5E AC B4 03 A4 AF 04 00 50 AC ?? ?? ?? 0? 21 F0 80 02 01 00 C4 24 ?? ?? ?? 0? BC 03 A5 AF 21 88 40 00 D8 FF 40 10 BC 03 A5 8F 90 00 A2 27 ?? ?? ?? 0? B8 03 A2 AF }
	condition:
		$1
}

rule file_508_0_0 {
	meta:
		name = "memcpy"
		size = 44
	strings:
		$1 = { 08 00 C0 10 21 10 80 00 21 18 80 00 21 30 86 00 00 00 A4 90 00 00 64 A0 01 00 63 24 FC FF 66 14 01 00 A5 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_525_2_0 {
	meta:
		name = "_dvfprintf_cdgGnopsuxX"
		size = 6744
		refs = "009c _ctype 0164 fputc 0478 dpcmp 0508 __fixunsdfdi 051c __floatundidf 0534 dpsub 075c __udivdi3 0770 __umoddi3 0958 dpadd 09bc dpmul 0a8c dpdiv 0de8 dptoul 1374 frexp 15d0 __floatunsidf"
		altNames = "_dvfprintf_cdgGnopuxX"
	strings:
		$1 = { 90 FF BD 27 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 68 00 BE AF 64 00 B7 AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 21 90 80 00 21 88 A0 00 78 00 A6 AF 2C 00 A0 AF 30 00 A0 AF 21 80 00 00 00 00 24 82 68 00 80 10 10 00 A4 A3 25 00 02 24 ED 01 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 E1 01 46 10 FF FF 91 24 2E 00 45 28 D7 01 A0 10 00 00 00 00 E9 01 47 50 01 00 63 34 E5 01 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A4 24 21 28 82 00 01 00 A5 90 02 00 67 30 FE FF 66 30 0B 18 C7 00 08 00 67 30 FB FF 66 30 04 00 A5 30 DD 01 A0 10 0B 18 C7 00 21 98 00 00 0A 00 06 24 02 28 66 72 01 00 31 26 21 98 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 73 26 2E 00 05 24 DB 01 45 50 01 00 31 26 00 10 63 34 21 A0 00 00 ?? ?? 07 3C ?? ?? E6 24 10 00 08 24 00 80 07 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3D 00 A0 14 01 00 31 26 10 00 B6 27 01 00 17 24 04 00 80 12 2B 10 F3 02 2B 10 97 02 0B B8 82 02 2B 10 F3 02 08 00 75 30 23 98 77 02 0B 00 A0 16 0A 98 02 00 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 D6 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F4 56 00 00 C4 82 A5 FF A0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9A FF 80 14 10 00 A4 A3 6C 00 BF 8F 21 10 00 02 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 80 20 04 00 21 20 C4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 63 34 80 00 63 34 00 07 62 30 4F 00 40 10 21 B8 60 00 00 10 65 30 06 00 04 24 10 00 62 30 E6 02 40 10 0B A0 85 00 78 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 45 8C 04 00 55 8C 08 00 44 24 78 00 A4 AF 20 00 A5 AF 20 00 A6 8F 21 28 A0 02 21 38 00 00 21 20 C0 00 21 30 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 A8 A2 02 03 00 77 34 20 00 A3 8F 21 28 A0 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF AD 03 40 14 21 B0 00 00 00 02 E2 32 00 01 40 14 FC FF C2 2A 19 00 82 2A F2 02 40 14 00 00 00 00 18 00 A8 8F 0A 00 02 29 54 01 40 10 30 00 A2 8F 20 00 A3 8F 21 28 A0 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 40 00 A8 AF D8 02 40 14 20 00 A3 8F 21 28 A0 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 21 B0 60 00 21 20 C0 03 ?? ?? ?? 0? 21 28 C0 02 20 00 A6 8F 21 28 A0 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 20 00 A2 AF 28 00 A3 AF 18 00 A0 AF ?? ?? ?? 0? 21 40 00 00 20 00 63 34 00 02 63 34 00 07 62 30 B3 FF 40 14 21 B8 60 00 C0 00 62 30 A4 02 40 14 20 16 03 7C 78 04 40 04 78 00 A6 8F 10 00 62 30 B1 02 40 10 78 00 A2 8F 78 00 A7 8F 00 00 E4 8C 04 00 E7 24 78 00 A7 AF C3 17 04 00 21 B0 80 00 21 B8 40 00 05 00 41 04 23 10 02 00 23 B0 04 00 2B 20 16 00 03 00 63 34 23 B8 44 00 03 00 80 16 C0 00 75 30 25 A0 D7 02 01 00 94 2E 40 00 02 24 AF 03 A2 12 41 00 A2 2A 38 03 40 10 80 00 02 24 16 00 A0 16 10 00 BE 83 01 00 02 24 11 05 E0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 42 24 02 00 06 24 02 00 1E 24 ?? ?? ?? 0? 14 00 07 24 21 30 C0 03 04 00 44 8C 2B 28 E4 02 31 03 A0 54 10 00 A6 A3 DC 04 97 50 00 00 44 8C 01 00 DE 27 20 F4 1E 7C F6 FF C7 17 08 00 42 24 10 00 BE A3 2A 10 D4 03 FE 02 40 10 2A 10 9E 02 20 F4 14 7C 10 00 BE A3 05 00 60 12 00 40 62 30 03 00 62 30 2B 10 02 00 23 98 62 02 00 40 62 30 05 00 40 10 2A 20 D3 03 2A 10 93 02 23 98 74 02 0A 98 02 00 2A 20 D3 03 04 00 62 30 23 F0 7E 02 EE 02 40 10 0A F0 04 00 02 00 62 30 7A 03 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 62 30 0D 00 C0 13 24 00 A2 AF 21 98 60 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 08 00 64 32 21 18 60 02 24 00 A4 AF FF FF 94 26 ?? ?? 02 3C C0 98 14 00 ?? ?? 42 24 21 98 53 00 03 00 02 24 80 40 14 00 40 20 17 00 02 A0 82 72 20 00 63 30 41 00 A2 2A 28 00 BE AF 34 00 B1 AF 20 00 A3 AF 21 F0 80 00 ?? ?? ?? 0? 21 88 40 00 10 00 A0 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 40 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 40 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 40 00 A8 AF 40 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF 94 26 FD FF 02 24 90 02 82 12 40 00 02 24 84 02 A2 12 27 10 14 00 DF FF 20 16 80 00 02 24 6E 02 A2 12 C0 00 02 24 DD FF A2 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 2E FE 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 21 FE 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 05 24 2D FE 45 14 21 98 00 00 78 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D3 8C 2E 00 05 24 04 00 C6 24 28 FE 45 14 78 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 05 24 23 03 45 10 00 40 63 34 21 28 82 00 01 00 A5 90 21 A0 00 00 04 00 A5 30 1F FE A0 10 0A 00 06 24 02 28 86 72 01 00 31 26 21 A0 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 94 26 ?? ?? ?? 0? ?? ?? 07 3C 3C 01 40 14 2A 10 D4 02 3A 01 40 10 00 00 00 00 3E 04 C0 06 20 00 A3 8F 21 28 A0 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 21 B0 60 00 25 10 D6 03 0F 00 40 10 21 30 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 13 00 07 24 04 00 64 8C 01 00 42 24 2B 28 C4 02 06 00 A0 14 21 30 40 00 97 03 96 50 00 00 64 8C F8 FF 47 14 08 00 63 24 14 00 06 24 23 A0 86 02 19 00 82 2A 64 03 40 10 00 00 00 00 ?? ?? ?? 0? FF 00 84 32 20 00 A6 8F 21 28 A0 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 20 80 02 20 00 A2 AF ?? ?? ?? 0? 21 A8 60 00 21 40 40 00 D6 FE 80 12 21 48 60 00 21 20 C0 03 21 28 C0 02 40 00 A8 AF ?? ?? ?? 0? 3C 00 A9 AF 20 00 A7 8F 21 28 A0 02 21 30 40 00 21 20 E0 00 ?? ?? ?? 0? 21 38 60 00 40 00 A8 8F 3C 00 A9 8F 21 20 40 00 21 28 60 00 21 30 00 01 ?? ?? ?? 0? 21 38 20 01 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 BD FE 80 12 21 28 C0 02 21 20 C0 03 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 F0 40 00 ?? ?? ?? 0? 21 B0 60 00 25 10 43 00 F1 FF 40 50 FF FF 94 26 18 00 A8 8F 0A 00 02 29 B0 FE 40 14 20 00 A3 8F 30 00 A2 8F 2C 00 A3 8F 40 00 A8 AF 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 20 60 00 74 01 40 04 40 00 A8 8F EE FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 40 00 A8 AF 30 00 A3 AF 20 00 A6 8F 21 18 40 00 2C 00 A2 AF 30 00 A2 8F 21 20 C0 00 21 28 A0 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 40 00 A8 8F 21 F0 40 00 21 B0 60 00 20 00 A0 AF 28 00 A0 AF 01 00 02 24 D3 03 C0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 2B 30 C5 02 48 02 C0 14 02 00 47 24 43 02 B6 50 00 00 65 8C 01 00 84 24 01 00 42 24 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 98 68 02 23 A8 74 02 2B 10 14 00 23 A8 A7 02 03 00 E3 32 23 A8 A2 02 2B 18 03 00 04 00 E2 32 F1 01 40 10 23 A8 A3 02 02 00 E2 32 E7 02 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 A0 5A 08 00 F7 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 08 00 F7 32 24 00 B7 AF ?? ?? 13 3C ?? ?? ?? 0? ?? ?? 73 26 C0 18 03 00 21 18 63 02 00 00 66 8C 04 00 67 8C 21 20 C0 03 ?? ?? ?? 0? 21 28 C0 02 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 82 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 82 2A A8 01 40 14 20 14 14 7C 12 00 02 24 10 00 A2 A3 EE FF 94 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 21 28 60 00 28 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 FF FF 64 26 20 24 04 7C 21 B0 40 00 21 B8 60 00 27 00 60 12 10 00 A4 A3 ?? ?? 02 3C ?? ?? 42 24 21 98 20 02 20 00 A2 AF 21 88 40 00 C0 20 04 00 21 20 24 02 00 00 86 8C 04 00 87 8C 21 28 E0 02 ?? ?? ?? 0? 21 20 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 BE 83 27 10 02 00 21 20 C0 02 C0 18 1E 00 21 18 23 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 E0 02 ?? ?? ?? 0? 21 80 02 02 FF FF C4 27 20 24 04 7C 21 B0 40 00 21 B8 60 00 E1 FF C0 17 10 00 A4 A3 21 88 60 02 0A 00 80 12 24 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 24 00 A4 8F B2 FC 80 50 00 00 24 82 B0 FC A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 76 02 80 16 21 10 00 00 10 00 A2 A3 20 00 A3 8F 21 28 A0 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 EC 01 40 14 10 00 AA 83 20 00 A2 8F 21 28 A0 02 ?? ?? ?? 0? 21 20 40 00 21 A8 40 00 18 00 B6 8F ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF 73 26 03 00 E2 32 63 00 C3 26 2B 10 02 00 23 98 74 02 C7 00 63 2C 23 98 62 02 01 00 63 2C 04 00 E2 32 BD 01 40 10 23 98 63 02 02 00 E2 32 5D 02 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 60 1A 08 00 FE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 FE 32 10 00 A2 83 20 00 A3 8F 21 20 A0 02 C0 10 02 00 21 10 62 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 20 00 A4 8F 27 10 02 00 C0 18 03 00 21 18 83 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 56 02 80 16 21 A8 60 00 20 00 F7 32 02 00 E0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F A0 02 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 64 00 43 28 32 02 60 10 64 00 14 24 0A 00 14 24 1A 00 54 00 F4 01 80 02 21 28 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 29 FC C0 13 21 80 02 02 28 FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 78 00 A6 8F F8 FF 02 24 07 00 C4 24 24 10 82 00 00 00 47 8C 04 00 55 8C 08 00 42 24 20 00 A7 AF ?? ?? ?? 0? 78 00 A2 AF CC 01 40 04 }
	condition:
		$1
}

rule file_528_0_0 {
	meta:
		name = "memcmp"
		size = 104
	strings:
		$1 = { 00 00 A4 AF 04 00 A5 AF 13 00 C0 10 21 10 00 00 00 00 83 90 00 00 A2 90 11 00 62 14 21 38 A0 03 ?? ?? ?? 0? 21 30 86 00 00 00 A2 8F 00 00 43 90 04 00 A2 8F 00 00 42 90 07 00 62 14 23 10 62 00 01 00 84 24 01 00 A5 24 00 00 E4 AC F6 FF 86 14 04 00 A5 AF 21 10 00 00 08 00 E0 03 00 00 00 00 08 00 E0 03 23 10 62 00 }
	condition:
		$1
}

rule file_539_0_0 {
	meta:
		name = "fgetc"
		size = 264
		refs = "00d4 _filbuf"
	strings:
		$1 = { 0C 00 83 94 E0 FF BD 27 10 00 B0 AF 01 00 02 24 21 80 80 00 11 00 64 30 1C 00 BF AF 18 00 B2 AF 1E 00 82 14 14 00 B1 AF 00 02 62 30 19 00 40 54 04 00 04 8E 04 00 02 8E FF FD 63 30 0C 00 03 A6 1A 00 11 24 0D 00 12 24 1F 00 40 18 FF FF 44 24 00 00 02 8E 04 00 04 AE 01 00 44 24 00 00 42 90 00 00 04 AE 80 00 64 30 05 00 80 14 1C 00 BF 8F 1C 00 51 50 08 00 02 8E 11 00 52 50 04 00 02 8E 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 E8 FF 80 10 21 10 00 00 1C 00 BF 8F 10 00 63 34 0C 00 03 A6 FF FF 02 24 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 E3 FF 40 1C FF FF 44 24 40 00 62 30 F3 FF 40 14 21 20 00 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 0C 00 03 96 EE FF 40 10 1C 00 BF 8F 04 00 04 8E 00 00 02 8E 01 00 84 24 FF FF 42 24 04 00 04 AE ?? ?? ?? 0? 00 00 02 AE }
	condition:
		$1
}

rule file_559_1_0 {
	meta:
		name = "_vfprintf_eEfFs"
		size = 5492
		refs = "009c _ctype 01b8 fputc 0584 __floatdisf 059c fpcmp 060c fptoui 06bc __udivdi3 06f4 __umoddi3 083c _npowers_f 0864 fpmul 08a0 fpadd 08f4 fpdiv 0d84 __floatunsisf 0d90 fpsub 105c frexpf 12a0 __floatundisf"
		altNames = "_vfprintf_eEfF"
	strings:
		$1 = { 98 FF BD 27 21 10 00 00 4C 00 B3 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 21 98 80 00 21 88 A0 00 70 00 A6 AF 28 00 A2 AF 21 80 00 00 00 00 24 82 44 00 80 10 10 00 A4 A3 25 00 02 24 58 00 82 14 01 00 32 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 B0 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 4C 00 45 10 FF FF 71 24 2E 00 44 28 42 00 80 10 00 00 00 00 54 00 46 50 01 00 D6 36 50 00 48 50 02 00 D6 36 ?? ?? 04 3C ?? ?? 84 24 21 18 82 00 01 00 63 90 02 00 C5 32 FE FF C4 32 0B B0 85 00 08 00 C5 32 FB FF C4 32 04 00 63 30 48 00 60 10 0B B0 85 00 21 18 00 00 0A 00 05 24 02 20 65 70 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 18 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF 63 24 2E 00 04 24 44 00 44 50 01 00 31 26 00 10 D6 36 21 90 00 00 66 00 04 24 73 00 06 24 6C 00 07 24 10 00 09 24 00 80 08 24 67 00 45 28 10 00 A2 A3 92 00 44 10 01 00 31 26 50 00 A0 10 00 00 00 00 63 00 04 24 AB 02 44 10 64 00 44 28 A4 01 80 50 65 00 04 24 E3 02 40 14 45 00 04 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C3 FF 47 14 ?? ?? 04 3C 04 00 D6 36 01 00 63 24 FF FF 62 80 B6 FF 45 14 FF FF 71 24 08 00 D6 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 C4 FF 44 14 21 18 00 00 70 00 A7 8F 01 00 31 26 00 00 22 82 00 00 E3 8C 2E 00 04 24 04 00 E7 24 BF FF 44 14 70 00 A7 AF 01 00 31 26 00 00 22 82 2A 00 04 24 B3 03 44 10 00 40 D6 36 ?? ?? 08 3C ?? ?? 08 25 21 20 02 01 01 00 84 90 21 90 00 00 04 00 84 30 B4 FF 80 10 0A 00 05 24 02 20 45 72 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 90 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF 52 26 ?? ?? ?? 0? 66 00 04 24 6F 02 46 10 74 00 45 28 A8 00 A0 50 75 00 04 24 32 00 47 10 10 00 C2 32 10 00 B4 27 01 00 17 24 04 00 40 52 2B 90 E3 02 2B 10 57 02 0B B8 42 02 2B 90 E3 02 23 18 77 00 0A 18 12 00 08 00 D6 32 0C 00 C0 16 21 90 60 00 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 55 16 21 28 60 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 60 02 4A FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 21 28 00 01 0A 28 22 01 00 00 22 82 25 B0 B6 00 FF FF D6 32 67 00 45 28 10 00 A2 A3 70 FF 44 14 01 00 31 26 00 04 DE 36 00 07 C2 33 72 00 40 14 21 B0 C0 03 20 16 1E 7C 5E 03 40 04 10 00 C2 33 37 02 40 50 70 00 A8 8F 70 00 A7 8F 21 B8 00 00 00 00 F4 8C 04 00 E7 24 70 00 A7 AF 03 00 40 16 C0 00 D6 33 25 90 97 02 01 00 52 2E 80 00 02 24 08 03 C2 12 C0 00 02 24 F1 02 C2 12 10 00 A2 83 2A 20 52 00 EC 02 80 10 2A 20 42 02 20 14 12 7C 10 00 A2 A3 05 00 60 10 00 40 C4 33 03 00 C4 33 2B 20 04 00 23 18 64 00 00 40 C4 33 05 00 80 10 2A 28 43 00 2A 20 43 02 23 18 72 00 0A 18 04 00 2A 28 43 00 23 10 62 00 0A 10 05 00 04 00 C4 33 C6 02 80 10 20 00 A2 AF 02 00 C2 33 3E 03 40 10 01 00 C2 33 01 00 C4 33 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A9 8F 09 02 20 15 30 00 04 24 08 00 DE 33 2C 00 BE AF FF FF 48 26 ?? ?? 09 3C C0 A8 08 00 ?? ?? 3E 25 40 10 17 00 21 A8 D5 03 80 40 08 00 80 00 1E 24 11 00 40 12 24 00 A2 AF 99 02 DE 12 FF FF 52 26 C0 00 03 24 87 02 C3 52 00 00 A6 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 30 00 A8 AF 30 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F1 FF 40 16 FC FF 08 25 2C 00 A6 8F D8 FE C0 50 00 00 24 82 20 00 A7 8F D5 FE E0 58 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A8 8F 27 10 02 00 2B 10 02 00 FF FF 08 25 20 00 A8 AF F7 FF 00 15 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 05 00 44 10 78 00 04 24 59 FF 44 14 10 00 B4 27 ?? ?? ?? 0? 80 00 DE 36 C0 00 DE 36 00 07 C2 33 90 FF 40 10 21 B0 C0 03 00 10 C5 33 06 00 04 24 10 00 C2 33 A4 00 40 10 0B 90 85 00 70 00 A8 8F F8 FF 02 24 07 00 04 25 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 38 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 38 00 A3 8F 21 A8 40 00 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 A8 55 00 03 00 D6 37 21 20 A0 02 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 18 00 A0 AF 21 B8 00 00 A1 02 40 14 38 00 A3 8F 00 01 C2 32 89 00 40 10 19 00 42 2A 13 00 42 2E D1 01 40 10 12 00 02 24 21 20 A0 02 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 10 00 B2 A3 D1 01 40 14 38 00 A3 8F ?? ?? ?? 0? 21 20 A0 02 38 00 A3 8F 21 A8 40 00 ?? ?? 02 3C ?? ?? 5E 24 FB FF 63 24 03 00 C2 32 23 A0 72 00 2B 18 02 00 04 00 C2 32 05 02 40 10 23 A0 83 02 02 00 C2 32 06 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 B1 03 80 1A 08 00 C5 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 C6 32 24 00 A6 AF 10 00 A2 83 21 20 A0 02 21 28 00 00 C0 10 02 00 21 10 C2 03 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 3E 03 40 16 21 B8 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 6D 03 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 12 24 21 28 60 02 1A 00 52 00 F4 01 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 72 00 F4 01 40 02 21 28 60 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 24 00 A2 8F 27 FE 40 50 00 00 24 82 25 FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 AD FE 44 14 10 00 B4 27 ?? ?? ?? 0? 00 01 DE 36 70 00 A9 8F 00 00 35 8D 04 00 29 25 ?? ?? ?? 0? 70 00 A9 AF 2B 00 40 10 0A 00 E2 2A FF 00 54 32 6E 00 82 2E AD 02 40 10 EB 51 02 3C 0B 00 82 2E 3C 03 40 14 ?? ?? 02 3C CC CC 02 3C CD CC 42 34 19 00 82 02 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 06 3C ?? ?? C6 24 38 00 A3 AF 30 00 A6 AF 10 48 00 00 C2 F0 09 00 FF 00 C2 33 09 00 42 24 80 10 02 00 21 10 46 00 ?? ?? ?? 0? 00 00 44 8C 0A 00 04 24 02 28 C4 73 30 00 A6 8F 21 20 40 00 23 A0 85 02 FF 00 94 32 80 A0 14 00 21 30 86 02 ?? ?? ?? 0? 00 00 C5 8C 38 00 A3 8F 21 20 A0 02 21 28 40 00 ?? ?? ?? 0? 38 00 A3 AF 38 00 A3 8F 21 A8 40 00 0A 00 E2 2A 10 01 40 14 21 20 A0 02 ?? ?? 02 3C ?? ?? 45 8C 28 00 A4 8F ?? ?? ?? 0? 38 00 A3 AF 59 02 41 04 38 00 A3 8F ED FF F7 26 18 00 B7 AF 20 24 17 7C ?? ?? ?? 0? 38 00 A3 AF 21 28 40 00 21 20 A0 02 ?? ?? ?? 0? 28 00 A2 AF ?? ?? ?? 0? 21 20 40 00 38 00 A3 8F 21 30 00 00 21 F0 40 00 21 A0 40 00 24 00 A6 AF 01 00 04 24 0A 00 C2 2F 08 03 40 14 10 00 A4 A3 ?? ?? 09 3C ?? ?? 26 25 21 10 00 00 02 00 09 24 02 00 04 24 12 00 08 24 04 00 C5 8C 02 00 47 24 01 00 84 24 32 02 A0 14 01 00 42 24 00 00 C5 8C 20 24 04 7C 2B 28 C5 03 2D 02 A0 14 08 00 C6 24 F5 FF 48 54 21 48 80 00 10 00 A4 A3 14 00 07 24 23 A8 77 00 23 A8 B2 02 2B 10 12 00 23 A8 A7 02 03 00 C3 32 23 A8 A2 02 2B 18 03 00 04 00 C2 32 E9 01 40 10 23 A8 A3 02 02 00 C2 32 2A 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 A0 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 08 00 D6 32 20 00 B6 AF ?? ?? 08 3C ?? ?? ?? 0? ?? ?? 16 25 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 80 02 21 28 00 00 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 C6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A 4F 02 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 24 00 A5 8F 21 20 40 00 ?? ?? ?? 0? 21 B8 00 00 ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 FF FF 82 26 20 14 02 7C 23 00 80 12 10 00 A2 A3 ?? ?? 09 3C ?? ?? 3E 25 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 20 C0 02 ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B4 83 27 10 02 00 2B 10 02 00 C0 18 14 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 28 E0 02 21 20 C0 02 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 FF FF 82 26 20 14 02 7C 21 B8 60 00 E1 FF 80 16 10 00 A2 A3 0A 00 40 12 20 00 A2 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 20 00 A2 8F 22 FD 40 50 00 00 24 82 20 FD A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A7 8F 10 00 C5 32 01 00 E2 80 00 00 E6 8C 04 00 E4 24 AB 00 A0 10 10 00 A2 A3 AA 00 40 50 14 00 A6 A3 FF FF 05 24 A7 00 45 50 14 00 A6 A3 14 00 A2 A3 15 00 A6 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF 70 00 A6 8F 00 00 C4 8C 04 00 C5 24 E2 01 80 10 21 A0 80 00 00 00 82 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 97 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A5 AF 21 B8 00 00 00 00 14 8D 04 00 08 25 ?? ?? ?? 0? 70 00 A8 AF 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 20 00 A3 AF F0 FD 60 10 21 80 02 02 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 20 00 A3 AF ED FF 60 14 21 80 02 02 ?? ?? ?? 0? 08 00 DE 33 6C FD 44 14 10 00 B4 27 20 00 D6 36 ?? ?? ?? 0? 00 01 DE 36 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 5F 01 40 10 38 00 A3 8F ?? ?? ?? 0? 21 20 A0 02 5F 01 40 14 38 00 A3 8F 02 00 E4 2A E7 FE 80 50 ?? ?? 02 3C ?? ?? ?? 0? 21 20 40 00 21 20 A0 02 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 10 00 A2 A3 31 FE 40 10 38 00 A3 8F 10 00 A7 83 38 00 A3 AF ?? ?? 1E 3C 23 20 E7 02 20 24 04 7C ?? ?? ?? 0? 34 00 A7 AF 21 28 40 00 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 21 20 40 00 ?? ?? ?? 0? 30 00 A2 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? C4 8F ?? ?? ?? 0? 21 28 40 00 38 00 A3 8F 30 00 A6 8F 0A 00 40 1C 34 00 A7 8F ?? ?? C5 8F ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 34 00 A7 8F 38 00 A3 8F 21 30 40 00 ?? ?? 04 3C 01 00 E2 24 ?? ?? 9E 24 C0 10 02 00 21 10 C2 03 04 00 44 8C 6B 01 80 14 21 A8 C0 00 00 00 42 8C 2B 10 C2 00 68 01 40 14 C0 38 07 00 ?? ?? 02 3C ?? ?? 45 8C 01 00 F7 26 21 20 80 02 38 00 A3 AF ?? ?? ?? 0? 18 00 B7 AF ?? ?? ?? 0? 21 20 40 00 38 00 A3 8F 21 A8 40 00 03 00 C2 32 FB FF 63 24 23 A0 72 00 2B 18 02 00 04 00 C2 32 FD FD 40 14 23 A0 83 02 08 00 C7 32 0B 00 E0 14 24 00 A7 AF 0A 00 80 1A 02 00 C2 32 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 C2 32 40 01 40 14 01 00 C4 32 01 00 C2 32 04 FE 40 10 10 00 A2 83 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 14 00 A6 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 30 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 30 00 A8 8F 24 00 A4 8F 27 18 08 00 06 10 14 01 04 18 64 00 25 10 62 00 20 00 04 31 06 18 17 01 0B 10 64 00 ?? ?? 05 3C 0F 00 42 30 ?? ?? A5 24 21 10 A2 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 20 00 A4 8F 9B 00 80 14 08 00 C6 33 08 00 C5 33 2C 00 A5 AF 02 00 C2 33 92 00 40 50 01 00 DE 33 01 00 C4 33 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 ?? ?? ?? 0? 0B 90 44 00 01 00 02 24 6B 01 E0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 44 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 08 24 21 38 40 00 04 00 85 8C 01 00 42 24 2B 30 E5 02 97 00 C0 14 20 14 02 7C 92 00 B7 50 00 00 85 8C F7 FF 48 14 08 00 84 24 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 5B 01 E0 12 10 00 A2 A3 02 00 02 24 02 00 0A 24 }
	condition:
		$1
}

rule file_614_2_0 {
	meta:
		name = "_dvfprintf_eEgGs"
		size = 5916
		refs = "009c _ctype 01b4 fputc 03c0 dpcmp 0430 __fixunsdfdi 04ac dpadd 04d4 __floatundidf 04ec dpsub 0500 dpmul 0530 __udivdi3 054c __umoddi3 061c dpdiv 0b30 dptoul 0e8c __floatunsidf 12bc frexp"
		altNames = "_dvfprintf_eEgG"
	strings:
		$1 = { 88 FF BD 27 5C 00 B3 AF 54 00 B1 AF 50 00 B0 AF 74 00 BF AF 70 00 BE AF 6C 00 B7 AF 68 00 B6 AF 64 00 B5 AF 60 00 B4 AF 58 00 B2 AF 21 98 80 00 21 88 A0 00 80 00 A6 AF 34 00 A0 AF 38 00 A0 AF 21 80 00 00 00 00 24 82 43 00 80 10 10 00 A4 A3 25 00 02 24 57 00 82 14 01 00 32 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 F0 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 4B 00 45 10 FF FF 71 24 2E 00 44 28 41 00 80 10 00 00 00 00 53 00 46 50 01 00 DE 37 4F 00 48 50 02 00 DE 37 ?? ?? 04 3C ?? ?? 83 24 21 20 62 00 01 00 84 90 02 00 C6 33 FE FF C5 33 0B F0 A6 00 08 00 C6 33 FB FF C5 33 04 00 84 30 47 00 80 10 0B F0 A6 00 21 A0 00 00 0A 00 05 24 02 20 85 72 01 00 31 26 21 A0 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 94 26 2E 00 04 24 45 00 44 50 01 00 31 26 00 10 DE 37 21 90 00 00 67 00 03 24 73 00 05 24 6C 00 06 24 10 00 08 24 00 80 07 24 68 00 44 28 10 00 A2 A3 8F 00 43 10 01 00 31 26 4D 00 80 10 00 00 00 00 47 00 03 24 8A 00 43 50 20 00 DE 37 48 00 43 28 C9 02 60 50 63 00 03 24 11 04 40 14 45 00 03 24 74 00 BF 8F 21 10 00 02 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 C4 FF 47 14 ?? ?? 04 3C 04 00 DE 37 01 00 63 24 FF FF 62 80 B7 FF 45 14 FF FF 71 24 08 00 DE 37 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 C3 FF 44 14 21 A0 00 00 80 00 A5 8F 01 00 31 26 00 00 22 82 00 00 B4 8C 2E 00 04 24 04 00 A5 24 BE FF 44 14 80 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 53 04 44 10 00 40 DE 37 21 20 62 00 01 00 84 90 21 90 00 00 04 00 84 30 B5 FF 80 10 0A 00 05 24 02 20 45 72 01 00 31 26 21 90 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 52 26 ?? ?? ?? 0? 67 00 03 24 92 03 45 10 74 00 44 28 78 02 80 50 75 00 03 24 32 00 46 10 10 00 C2 33 10 00 B5 27 01 00 16 24 04 00 40 52 2B 90 D4 02 2B 10 56 02 0B B0 42 02 2B 90 D4 02 23 A0 96 02 0A A0 12 00 08 00 DE 33 0C 00 C0 17 21 90 80 02 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? FF FF 14 24 00 00 A4 82 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF D6 26 F8 FF D4 16 21 28 60 02 4F FF C0 53 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 21 20 E0 00 0A 20 02 01 00 00 22 82 25 F0 9E 00 FF FF DE 33 68 00 44 28 10 00 A2 A3 73 FF 43 14 01 00 31 26 00 02 DE 37 00 07 C2 33 70 01 40 10 21 B8 C0 03 00 10 C4 33 06 00 03 24 10 00 C2 33 14 02 40 10 0B 90 64 00 80 00 A4 8F F8 FF 02 24 07 00 83 24 24 10 62 00 00 00 46 8C 04 00 56 8C 08 00 45 24 80 00 A5 AF 20 00 A6 AF 20 00 A3 8F 21 28 C0 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 00 41 04 20 00 A3 8F 00 80 02 3C 26 B0 C2 02 03 00 D7 37 21 28 C0 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF AE 03 40 14 21 A8 00 00 00 01 E2 32 B8 01 40 14 00 02 E2 32 39 03 40 10 19 00 42 2A FC FF A2 2A B3 01 40 14 2A 10 B2 02 B1 01 40 10 00 00 00 00 A4 04 A0 06 20 00 A3 8F 21 28 C0 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 21 A8 60 00 25 10 D5 03 0F 00 40 10 21 30 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 13 00 07 24 04 00 64 8C 01 00 42 24 2B 28 A4 02 06 00 A0 14 21 30 40 00 8C 04 95 50 00 00 64 8C F8 FF 47 14 08 00 63 24 14 00 06 24 23 90 46 02 19 00 42 2A 75 04 40 10 00 00 00 00 ?? ?? ?? 0? FF 00 44 32 20 00 A6 8F 21 28 C0 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 20 40 02 20 00 A2 AF ?? ?? ?? 0? 21 B0 60 00 28 00 A2 AF 25 00 40 12 2C 00 A3 AF 21 20 C0 03 ?? ?? ?? 0? 21 28 A0 02 20 00 A7 8F 21 28 C0 02 21 30 40 00 21 20 E0 00 ?? ?? ?? 0? 21 38 60 00 28 00 A6 8F 2C 00 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 28 A0 02 21 20 C0 03 0A 00 06 24 0D 00 40 12 21 38 00 00 ?? ?? ?? 0? 00 00 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 F0 40 00 ?? ?? ?? 0? 21 A8 60 00 25 10 43 00 F0 FF 40 50 FF FF 52 26 18 00 A8 8F 0A 00 02 29 15 00 40 10 34 00 A3 8F 20 00 A3 8F 21 28 C0 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 48 00 A8 AF F6 03 40 10 20 00 A3 8F 21 28 C0 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 25 10 43 00 21 A8 60 00 F3 03 40 14 48 00 A8 8F 02 00 02 29 F0 03 40 14 34 00 A3 8F 38 00 A2 8F ?? ?? 06 3C ?? ?? C7 8C ?? ?? C6 8C 21 20 60 00 21 28 40 00 ?? ?? ?? 0? 48 00 A8 AF D9 03 40 04 48 00 A8 8F EE FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 48 00 A8 AF 38 00 A3 AF 34 00 A2 AF 21 18 40 00 20 00 A6 8F 38 00 A2 8F 21 28 C0 02 21 20 C0 00 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 48 00 A8 8F 21 F0 40 00 21 A8 60 00 28 00 A0 AF 30 00 A0 AF 01 00 02 24 2F 04 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 02 00 47 24 01 00 84 24 2B 30 A5 02 F4 03 C0 14 01 00 42 24 EF 03 B5 50 00 00 65 8C 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 B0 88 02 23 B0 D2 02 2B 10 12 00 23 B0 C7 02 03 00 E3 32 23 B0 C2 02 2B 18 03 00 04 00 E2 32 C5 03 40 10 23 B0 C3 02 02 00 E2 32 F0 03 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 C0 5A 08 00 F7 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF D6 26 F9 FF C0 16 21 80 02 02 08 00 F7 32 20 00 B7 AF ?? ?? 14 3C ?? ?? ?? 0? ?? ?? 94 26 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 C0 03 21 28 A0 02 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 86 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A 7C 03 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 21 28 60 00 30 00 A2 8F 28 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 A8 40 00 FF FF 82 26 20 14 02 7C 21 B8 60 00 23 00 80 12 10 00 A2 A3 ?? ?? 1E 3C ?? ?? DE 27 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 20 A0 02 ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B4 83 27 10 02 00 2B 10 02 00 C0 18 14 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 28 E0 02 21 20 A0 02 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 FF FF 82 26 20 14 02 7C 21 B8 60 00 E1 FF 80 16 10 00 A2 A3 0A 00 40 12 20 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 20 00 A4 8F D2 FD 80 50 00 00 24 82 D0 FD C0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF D6 26 F9 FF C0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 1E 7C 83 02 40 04 10 00 C2 33 D1 00 40 10 80 00 A5 8F 80 00 A4 8F 21 B8 00 00 00 00 95 8C 04 00 84 24 80 00 A4 AF 03 00 40 16 C0 00 D6 33 25 90 B7 02 01 00 52 2E 80 00 02 24 84 01 C2 12 C0 00 02 24 A7 01 C2 12 10 00 A2 83 2A 18 52 00 9E 00 60 10 2A 18 42 02 20 14 12 7C 10 00 A2 A3 05 00 80 12 00 40 C3 33 03 00 C3 33 2B 18 03 00 23 A0 83 02 00 40 C3 33 05 00 60 10 2A 20 54 00 2A 18 54 02 23 A0 92 02 0A A0 03 00 2A 20 54 00 23 10 82 02 0A 10 04 00 04 00 C3 33 8D 00 60 10 20 00 A2 AF 02 00 C2 33 D1 01 40 54 01 00 C4 33 01 00 C2 33 D2 01 40 14 20 00 04 24 20 00 A6 8F 0C 00 C0 50 08 00 DE 33 20 00 B4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 B4 AF 08 00 DE 33 28 00 BE AF FF FF 48 26 C0 A0 08 00 ?? ?? 1E 3C 80 40 08 00 ?? ?? DE 27 13 00 00 01 40 18 17 00 21 40 40 02 21 A0 D4 03 30 00 B1 AF 80 00 1E 24 21 88 60 00 11 00 00 11 12 90 00 00 F5 01 DE 12 FF FF 08 25 C0 00 05 24 00 02 C5 52 00 00 86 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 48 00 A8 AF 48 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 94 26 F1 FF 00 15 FC FF 52 26 28 00 A2 8F 66 FD 40 10 30 00 B1 8F 20 00 A3 8F 63 FD 60 18 21 90 60 00 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 25 01 40 12 21 10 00 00 40 02 E2 7E 23 90 42 02 13 00 42 2E 1F 01 40 14 12 00 02 24 10 00 A2 A3 20 00 A3 8F 21 28 C0 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 CA 00 40 14 10 00 AB 83 20 00 A2 8F 21 28 C0 02 ?? ?? 1E 3C ?? ?? ?? 0? 21 20 40 00 18 00 B5 8F 21 B0 40 00 ?? ?? DE 27 FB FF 94 26 03 00 E2 32 63 00 B5 26 2B 10 02 00 23 A0 92 02 C7 00 B5 2E 23 A0 82 02 01 00 B5 2E 04 00 E2 32 4C 00 40 10 23 A0 95 02 02 00 E2 32 A3 01 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 CC 02 80 1A 08 00 E3 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 E4 32 ?? ?? ?? 0? 20 00 A4 AF 80 00 A2 8F 07 00 43 24 F8 FF 02 24 24 10 62 00 00 00 43 8C 04 00 56 8C 08 00 42 24 20 00 A3 AF ?? ?? ?? 0? 80 00 A2 AF ?? ?? ?? 0? 0B 90 43 00 20 00 A2 8F 4F 01 40 14 08 00 C4 33 08 00 C3 33 28 00 A3 AF 02 00 C2 33 59 01 40 50 01 00 DE 33 01 00 C4 33 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 C5 FD 43 50 C0 00 DE 37 78 00 03 24 88 FD 43 14 10 00 B5 27 ?? ?? ?? 0? 80 00 DE 37 FE 00 43 10 65 00 03 24 82 FD 43 14 10 00 B5 27 ?? ?? ?? 0? 00 01 DE 37 21 B8 00 00 00 00 B5 8C 04 00 A5 24 ?? ?? ?? 0? 80 00 A5 AF 08 00 E5 32 0B 00 A0 14 20 00 A5 AF 0A 00 80 1A 02 00 E2 32 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 E2 32 47 01 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 C0 02 21 28 00 00 C0 10 02 00 21 10 C2 03 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 20 C0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 89 01 40 16 21 B0 60 00 20 00 F7 32 02 00 E0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F D2 01 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A3 8F 64 00 62 28 BA 01 40 10 64 00 12 24 0A 00 12 24 1A 00 72 00 F4 01 40 02 21 28 60 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 72 00 F4 01 40 02 21 28 60 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A2 8F 8D FC 40 50 00 00 24 82 8B FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 23 20 AB 02 ?? ?? ?? 0? 44 00 AB AF 20 00 A6 8F 21 38 60 00 21 28 C0 02 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 50 60 00 21 48 40 00 21 28 40 01 21 20 40 00 3C 00 A9 AF ?? ?? ?? 0? 40 00 AA AF 21 20 40 00 ?? ?? ?? 0? 48 00 A2 AF 3C 00 A9 8F 40 00 AA 8F 21 30 40 00 21 20 20 01 21 28 40 01 ?? ?? ?? 0? 21 38 60 00 ?? ?? 06 3C ?? ?? C6 24 00 00 C4 8C 04 00 C5 8C 21 38 60 00 ?? ?? ?? 0? 21 30 40 00 48 00 A8 8F 3C 00 A9 8F 40 00 AA 8F 12 00 40 1C 44 00 AB 8F ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 20 01 ?? ?? ?? 0? 21 28 40 01 21 50 60 00 21 48 40 00 21 28 40 01 21 20 40 00 3C 00 A9 AF ?? ?? ?? 0? 40 00 AA AF 44 00 AB 8F 40 00 AA 8F 3C 00 A9 8F 21 40 40 00 ?? ?? 1E 3C 01 00 62 25 C0 10 02 00 ?? ?? DE 27 21 10 C2 03 04 00 43 8C 9B 00 60 10 21 B0 00 01 C0 58 0B 00 21 58 CB 03 04 00 62 8D 80 01 40 50 00 00 62 8D ?? ?? 02 3C ?? ?? 42 24 21 20 20 01 21 28 40 01 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? FF FF B5 26 21 10 40 02 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 DA 01 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 19 04 00 02 00 02 24 02 47 04 00 25 40 06 01 01 00 42 24 21 30 60 00 2B 18 E5 02 02 00 09 24 10 00 0A 24 20 14 02 7C 11 00 60 14 21 38 00 01 96 00 E5 52 2B 20 A4 02 23 00 4A 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 19 04 00 02 47 04 00 25 40 06 01 21 48 40 00 21 30 60 00 01 00 42 24 2B 18 E5 02 }
	condition:
		$1
}

rule file_618_2_0 {
	meta:
		name = "_vfprintf_fFgG"
		size = 5616
		refs = "000c _ctype 01b0 fputc 03a8 __floatdisf 03c0 fpcmp 0418 fpadd 0468 fpdiv 0470 fptoui 0584 __udivdi3 0598 __umoddi3 0650 fpmul 0c8c __floatundisf 0c98 fpsub 1068 frexpf 1274 __floatunsisf"
		altNames = "_vfprintf_fFgGs"
	strings:
		$1 = { 98 FF BD 27 60 00 BE AF 21 10 00 00 ?? ?? 1E 3C 4C 00 B3 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 21 98 80 00 21 88 A0 00 70 00 A6 AF 2C 00 A2 AF 21 80 00 00 ?? ?? DE 27 00 00 24 82 40 00 80 10 10 00 A4 A3 25 00 02 24 54 00 82 14 01 00 32 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 48 00 46 10 FF FF 91 24 2E 00 45 28 3E 00 A0 10 00 00 00 00 50 00 47 50 01 00 63 34 4C 00 49 50 02 00 63 34 21 20 C2 03 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 46 00 80 10 0B 18 A6 00 21 A8 00 00 0A 00 05 24 02 20 A5 72 01 00 31 26 21 A8 82 00 00 00 22 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF B5 26 2E 00 04 24 44 00 44 50 01 00 31 26 00 10 63 34 21 90 00 00 67 00 04 24 73 00 06 24 6C 00 07 24 10 00 09 24 00 80 08 24 68 00 45 28 10 00 A2 A3 8E 00 44 10 01 00 31 26 4C 00 A0 10 00 00 00 00 63 00 04 24 95 02 44 10 64 00 44 28 F9 01 80 50 66 00 04 24 DA 02 40 14 47 00 04 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C7 FF 48 54 21 20 C2 03 04 00 63 34 01 00 84 24 FF FF 82 80 BA FF 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 C4 FF 44 14 21 A8 00 00 70 00 A5 8F 01 00 31 26 00 00 22 82 00 00 B5 8C 2E 00 04 24 04 00 A5 24 BF FF 44 14 70 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 B7 03 44 10 00 40 63 34 21 20 C2 03 01 00 84 90 21 90 00 00 04 00 84 30 B6 FF 80 10 0A 00 05 24 02 20 45 72 01 00 31 26 21 90 82 00 00 00 22 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 52 26 ?? ?? ?? 0? 67 00 04 24 3C 02 46 10 74 00 45 28 A8 01 A0 50 75 00 04 24 32 00 47 10 10 00 62 30 10 00 B4 27 01 00 17 24 04 00 40 52 2B 90 F5 02 2B 10 57 02 0B B8 42 02 2B 90 F5 02 23 A8 B7 02 0A A8 12 00 08 00 76 30 0C 00 C0 16 21 90 A0 02 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 55 16 21 28 60 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 60 02 52 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 21 28 00 01 0A 28 22 01 00 00 22 82 25 18 A3 00 FF FF 63 30 68 00 45 28 10 00 A2 A3 74 FF 44 14 01 00 31 26 00 02 63 34 00 07 62 30 00 01 40 10 21 B0 60 00 00 10 65 30 06 00 04 24 10 00 62 30 F0 01 40 10 0B 90 85 00 70 00 A5 8F F8 FF 02 24 07 00 A4 24 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 38 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 38 00 A3 8F 21 A0 40 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 A0 54 00 03 00 76 34 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 18 00 A0 AF 1D 03 40 14 21 18 00 00 00 02 C2 32 50 01 40 14 FC FF 62 28 19 00 42 2A 08 00 40 10 18 00 B7 8F ?? ?? ?? 0? FF 00 44 32 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 A0 40 00 18 00 B7 8F 0A 00 E2 2A 0A 02 40 14 21 20 80 02 ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 2C 00 A4 8F B7 03 41 04 EE FF E6 26 ED FF E6 26 18 00 A6 AF 20 24 06 7C ?? ?? ?? 0? 34 00 A6 AF 21 28 40 00 21 20 80 02 ?? ?? ?? 0? 2C 00 A2 AF ?? ?? ?? 0? 21 20 40 00 34 00 A6 8F 21 18 40 00 21 A0 40 00 21 B8 00 00 01 00 04 24 0A 00 62 2C 49 04 40 14 10 00 A4 A3 ?? ?? 04 3C ?? ?? 87 24 21 10 00 00 02 00 0A 24 02 00 04 24 12 00 09 24 04 00 E5 8C 02 00 48 24 01 00 84 24 15 03 A0 14 01 00 42 24 00 00 E5 8C 20 24 04 7C 2B 28 65 00 10 03 A0 14 08 00 E7 24 F5 FF 49 54 21 50 80 00 10 00 A4 A3 14 00 08 24 23 A8 A6 02 23 A8 B2 02 2B 10 12 00 23 A8 A8 02 03 00 C3 32 23 A8 A2 02 2B 18 03 00 04 00 C2 32 BB 02 40 10 23 A8 A3 02 02 00 C2 32 85 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 A0 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 08 00 D6 32 24 00 B6 AF ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 96 24 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 80 02 21 28 00 00 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 C6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A 72 02 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 28 E0 02 ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 FF FF 82 26 20 14 02 7C 21 B8 00 00 26 00 80 12 10 00 A2 A3 ?? ?? 05 3C ?? ?? A5 24 20 00 A5 AF 20 00 A7 8F C0 10 02 00 21 20 C0 02 21 10 E2 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B4 83 20 00 A4 8F 27 10 02 00 C0 18 14 00 21 18 83 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 E0 02 21 20 C0 02 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 FF FF 82 26 20 14 02 7C 21 B8 60 00 DF FF 80 16 10 00 A2 A3 0A 00 40 12 24 00 A5 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 24 00 A5 8F 45 FE A0 50 00 00 24 82 43 FE A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 03 7C 69 02 40 04 10 00 62 30 17 01 40 10 70 00 A7 8F 70 00 A5 8F 21 B8 00 00 00 00 B4 8C 04 00 A5 24 70 00 A5 AF 03 00 40 16 C0 00 76 30 25 90 97 02 01 00 52 2E 80 00 02 24 E7 01 C2 12 C0 00 02 24 D0 01 C2 12 10 00 A2 83 2A 20 52 00 CB 01 80 10 2A 20 42 02 20 14 12 7C 10 00 A2 A3 05 00 A0 12 00 40 64 30 03 00 64 30 2B 20 04 00 23 A8 A4 02 00 40 64 30 05 00 80 10 2A 28 55 00 2A 20 55 02 23 A8 B2 02 0A A8 04 00 2A 28 55 00 23 10 A2 02 0A 10 05 00 04 00 64 30 A7 01 80 10 24 00 A2 AF 02 00 62 30 49 02 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 60 02 ?? ?? ?? 0? 38 00 A3 AF 27 10 02 00 38 00 A3 8F 2B 10 02 00 21 80 02 02 24 00 A2 8F E8 00 40 14 30 00 04 24 08 00 63 30 28 00 A3 AF FF FF 48 26 ?? ?? 05 3C C0 A8 08 00 ?? ?? A5 24 40 38 17 00 21 A8 B5 00 80 40 08 00 12 00 40 12 20 00 A7 AF 80 00 02 24 79 01 C2 12 FF FF 52 26 C0 00 03 24 67 01 C3 52 00 00 A6 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 30 00 A8 AF 30 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F0 FF 40 16 FC FF 08 25 28 00 A7 8F E0 FD E0 50 00 00 24 82 24 00 A2 8F DD FD 40 58 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 24 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 24 00 A3 AF F7 FF 60 14 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 95 FE 44 50 C0 00 63 34 78 00 04 24 58 FE 44 14 10 00 B4 27 ?? ?? ?? 0? 80 00 63 34 54 FE 44 14 10 00 B4 27 ?? ?? ?? 0? 00 04 63 34 E2 00 40 10 2A 10 72 00 9A 02 40 16 21 10 00 00 10 00 A2 A3 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 36 02 40 14 38 00 A3 8F ?? ?? ?? 0? 21 20 80 02 21 B8 40 00 ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF B4 26 03 00 C3 32 23 A0 92 02 2B 18 03 00 04 00 C2 32 0E 02 40 10 23 A0 83 02 02 00 C2 32 92 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 FB 02 80 1A 08 00 C7 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 C2 32 24 00 A2 AF 10 00 A2 83 20 00 A7 8F 21 20 E0 02 C0 10 02 00 21 10 E2 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 A3 83 20 00 A4 8F 27 10 02 00 C0 18 03 00 21 18 83 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 E0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 7B 02 40 16 21 A8 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F B8 02 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 12 24 21 28 60 02 1A 00 52 00 F4 01 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 72 00 F4 01 40 02 21 28 60 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 24 00 A2 8F 50 FD 40 50 00 00 24 82 4E FD 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A7 8F 00 00 F4 8C 04 00 E7 24 ?? ?? ?? 0? 70 00 A7 AF 70 00 A7 8F 00 00 E4 8C 04 00 E5 24 37 02 80 10 21 A0 80 00 00 00 82 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 97 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A5 AF 70 00 A4 8F 10 00 65 30 01 00 82 80 00 00 86 8C 04 00 84 24 9D 00 A0 10 10 00 A2 A3 9C 00 40 50 14 00 A6 A3 FF FF 05 24 99 00 45 50 14 00 A6 A3 14 00 A2 A3 15 00 A6 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF 21 B8 00 00 00 00 F4 8C 04 00 E7 24 ?? ?? ?? 0? 70 00 A7 AF 30 00 04 24 21 28 60 02 ?? ?? ?? 0? 38 00 A3 AF 24 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 24 00 A4 AF 21 80 02 02 0F FF 80 10 38 00 A3 8F 30 00 04 24 21 28 60 02 ?? ?? ?? 0? 38 00 A3 AF 24 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 24 00 A4 AF 21 80 02 02 E9 FF 80 14 38 00 A3 8F ?? ?? ?? 0? 08 00 63 30 ?? ?? ?? 0? 21 28 00 00 BA 01 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 80 02 05 00 40 54 21 20 40 00 02 00 E3 2A EE FD 60 50 ?? ?? 02 3C 21 20 40 00 21 28 00 00 ?? ?? ?? 0? 38 00 A2 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 38 00 A3 8F 21 B8 40 00 18 00 A0 AF 21 A0 60 00 ?? ?? ?? 0? 21 30 00 00 71 FD 44 14 10 00 B4 27 ?? ?? ?? 0? 20 00 63 34 1E FF 40 10 00 00 00 00 31 02 60 04 27 18 03 00 ?? ?? ?? 0? 21 20 80 02 21 B8 40 00 10 00 E0 12 21 20 00 00 ?? ?? 05 3C ?? ?? A5 24 21 10 00 00 13 00 06 24 04 00 A3 8C 01 00 42 24 08 00 60 14 21 20 40 00 00 00 A3 8C 2B 18 E3 02 04 00 60 14 08 00 A5 24 F8 FF 46 54 04 00 A3 8C 14 00 04 24 23 90 44 02 19 00 42 2A 95 01 40 10 00 00 00 00 ?? ?? ?? 0? FF 00 44 32 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 20 24 12 7C ?? ?? ?? 0? 21 A0 40 00 B2 FD 40 12 21 18 40 00 21 20 E0 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 38 00 A3 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 00 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 B8 40 00 25 10 43 00 0F 00 40 10 21 40 00 00 ?? ?? ?? 0? 18 00 B7 8F ?? ?? ?? 0? 00 00 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 B8 40 00 ?? ?? ?? 0? 30 00 A3 AF 25 10 43 00 8E FD 40 14 30 00 A8 8F FF FF 52 26 21 28 00 01 21 20 E0 02 0A 00 06 24 EF FF 40 16 21 38 00 00 18 00 B7 8F 0A 00 E2 2A 89 FD 40 10 ?? ?? 02 3C ?? ?? ?? 0? 21 20 80 02 14 00 A6 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 30 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 30 00 A8 8F 20 00 A4 8F 27 18 08 00 06 10 14 01 04 18 64 00 25 10 62 00 20 00 04 31 06 18 17 01 0B 10 64 00 ?? ?? 05 3C 0F 00 42 30 ?? ?? A5 24 21 10 A2 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 24 00 A5 8F AB 00 A0 14 08 00 62 30 08 00 67 30 28 00 A7 AF 02 00 62 30 A2 00 40 10 01 00 63 30 2D 00 02 24 2B 00 04 24 0B 20 43 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 ?? ?? ?? 0? 0B 90 44 00 01 00 02 24 B7 01 E0 12 10 00 A2 A3 ?? ?? 05 3C ?? ?? A4 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 08 24 21 38 40 00 04 00 85 8C 01 00 42 24 2B 30 E5 02 1D 01 C0 14 20 14 02 7C 18 01 B7 50 00 00 85 8C F7 FF 48 14 08 00 84 24 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 9D 01 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 41 04 00 02 00 02 24 02 4F 04 00 25 48 26 01 01 00 42 24 21 30 00 01 2B 40 E5 02 02 00 0A 24 10 00 0B 24 20 14 02 7C 11 00 00 15 21 38 20 01 10 01 E5 12 2B 20 84 02 E9 FF 4B 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 41 04 00 02 4F 04 00 25 48 26 01 21 50 40 00 21 30 00 01 01 00 42 24 2B 40 E5 02 20 14 02 7C F1 FF 00 11 21 38 20 01 10 00 AA A3 ?? ?? ?? 0? 21 10 40 01 10 00 A2 A3 90 FD 40 14 23 90 42 02 FF FF 02 24 ?? ?? ?? 0? 10 00 A2 A3 08 00 C3 32 0B 00 60 14 }
	condition:
		$1
}

rule file_620_0_0 {
	meta:
		name = "gmtime"
		size = 444
	strings:
		$1 = { 00 00 84 8C 3C 00 0A 24 18 00 0D 24 1A 00 8A 00 F4 01 40 01 ?? ?? 0E 3C 07 00 0C 24 ?? ?? C2 25 6D 01 05 24 46 00 03 24 46 00 09 24 02 00 06 24 46 00 07 24 64 00 08 24 90 01 0B 24 01 00 63 24 12 20 00 00 10 C0 00 00 ?? ?? D8 AD 1A 00 8A 00 F4 01 40 01 12 50 00 00 10 78 00 00 04 00 4F AC 1A 00 4D 01 F4 01 A0 01 12 20 00 00 04 00 8D 24 2A 28 85 00 10 70 00 00 08 00 4E AC 21 50 80 00 1A 00 AC 01 F4 01 80 01 10 60 00 00 23 00 A0 14 18 00 4C AC 0C 00 C0 14 6D 01 05 24 1B 00 E8 00 F4 01 00 01 2C 01 E9 24 10 30 00 00 06 00 C0 14 6E 01 05 24 1B 00 2B 01 F4 01 60 01 6D 01 06 24 10 38 00 00 0B 28 C7 00 03 00 66 30 23 20 85 00 21 38 60 00 0C 00 C0 14 6D 01 05 24 1B 00 68 00 F4 01 00 01 2C 01 69 24 10 50 00 00 06 00 40 15 6E 01 05 24 1B 00 2B 01 F4 01 60 01 6D 01 0A 24 10 48 00 00 0B 28 49 01 2A 28 85 00 21 48 60 00 21 50 80 00 DF FF A0 10 01 00 63 24 0C 00 4A AC 14 00 49 AC 07 00 C0 14 21 28 00 00 64 00 03 24 1B 00 E3 00 F4 01 60 00 10 18 00 00 18 00 60 10 02 00 05 24 0C 00 43 8C 1C 00 44 AC 1F 00 64 28 10 00 80 14 10 00 40 AC ?? ?? 08 3C 1F 00 06 24 21 20 00 00 ?? ?? 08 25 01 00 84 24 21 38 04 01 00 00 E7 90 42 28 05 00 23 18 66 00 25 30 A7 00 FF 00 C6 30 2A 38 66 00 F8 FF E0 50 01 00 84 24 10 00 44 AC 01 00 63 24 08 00 E0 03 0C 00 43 AC 90 01 03 24 2C 01 E7 24 1B 00 E3 00 F4 01 60 00 10 18 00 00 ?? ?? ?? 0? 0B 28 03 00 }
	condition:
		$1
}

rule file_620_1_0 {
	meta:
		name = "localtime"
		size = 56
		refs = "0000 time_zone 0024 gmtime"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 45 8C C4 FF 02 24 00 00 83 8C 02 30 A2 70 E0 FF BD 27 10 00 A4 27 1C 00 BF AF 21 10 C3 00 ?? ?? ?? 0? 10 00 A2 AF 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_620_2_0 {
	meta:
		name = "asctime"
		size = 684
	strings:
		$1 = { 18 00 82 8C 03 00 08 24 ?? ?? 06 3C 02 18 48 70 ?? ?? 05 3C ?? ?? C6 24 ?? ?? A2 24 0A 00 07 24 21 30 66 00 20 00 03 24 03 00 43 A0 01 00 C9 90 00 00 CA 90 02 00 C6 90 01 00 49 A0 ?? ?? AA A0 02 00 46 A0 10 00 86 8C ?? ?? 05 3C ?? ?? A5 24 02 48 C8 70 07 00 43 A0 21 28 25 01 01 00 A6 90 00 00 A8 90 02 00 A5 90 05 00 46 A0 04 00 48 A0 06 00 45 A0 0C 00 85 80 0A 00 43 A0 1A 00 A7 00 F4 01 E0 00 10 30 00 00 30 00 C6 24 12 28 00 00 20 2C 05 7C 53 00 A0 10 09 00 46 A0 30 00 A5 24 08 00 45 A0 08 00 85 80 0A 00 03 24 3A 00 07 24 1A 00 A3 00 F4 01 60 00 0D 00 47 A0 10 30 00 00 30 00 C6 24 12 18 00 00 20 1C 03 7C 52 00 60 10 0C 00 46 A0 30 00 63 24 0B 00 43 A0 04 00 85 80 0A 00 03 24 3A 00 07 24 1A 00 A3 00 F4 01 60 00 10 00 47 A0 10 30 00 00 30 00 C6 24 12 18 00 00 20 1C 03 7C 52 00 60 10 0F 00 46 A0 30 00 63 24 0E 00 43 A0 00 00 85 80 0A 00 03 24 20 00 07 24 1A 00 A3 00 F4 01 60 00 13 00 47 A0 10 30 00 00 30 00 C6 24 12 18 00 00 20 1C 03 7C 52 00 60 10 12 00 46 A0 30 00 63 24 11 00 43 A0 14 00 86 8C 64 00 05 24 0A 00 03 24 1A 00 C5 00 F4 01 A0 00 16 00 40 A0 12 28 00 00 13 00 A5 24 20 2C 05 7C 1A 00 A3 00 F4 01 60 00 10 30 00 00 30 00 C6 24 12 18 00 00 20 1C 03 7C 42 00 60 10 15 00 46 A0 30 00 63 24 14 00 43 A0 14 00 85 8C 64 00 04 24 0A 00 03 24 1A 00 A4 00 F4 01 80 00 0A 00 05 24 18 00 45 A0 10 20 00 00 1A 00 83 00 F4 01 60 00 10 28 00 00 30 00 A5 24 12 18 00 00 20 1C 03 7C 33 00 60 14 17 00 45 A0 30 00 03 24 08 00 E0 03 16 00 43 A0 08 00 43 A0 08 00 85 80 0A 00 03 24 3A 00 07 24 1A 00 A3 00 F4 01 60 00 0D 00 47 A0 10 30 00 00 30 00 C6 24 12 18 00 00 20 1C 03 7C B0 FF 60 14 0C 00 46 A0 30 00 03 24 0B 00 43 A0 04 00 85 80 0A 00 03 24 3A 00 07 24 1A 00 A3 00 F4 01 60 00 10 00 47 A0 10 30 00 00 30 00 C6 24 12 18 00 00 20 1C 03 7C B0 FF 60 14 0F 00 46 A0 30 00 03 24 0E 00 43 A0 00 00 85 80 0A 00 03 24 20 00 07 24 1A 00 A3 00 F4 01 60 00 13 00 47 A0 10 30 00 00 30 00 C6 24 12 18 00 00 20 1C 03 7C B0 FF 60 14 12 00 46 A0 30 00 03 24 ?? ?? ?? 0? 11 00 43 A0 20 00 03 24 ?? ?? ?? 0? 14 00 43 A0 30 00 63 24 08 00 E0 03 16 00 43 A0 }
	condition:
		$1
}

rule file_620_3_0 {
	meta:
		name = "ctime"
		size = 32
		refs = "0008 localtime 0018 asctime"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 14 00 BF 8F ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_626_2_0 {
	meta:
		name = "_dvfprintf_eEfFgGs"
		size = 6004
		refs = "009c _ctype 01b4 fputc 03a8 dpcmp 0458 dptoul 0514 __udivdi3 054c __umoddi3 0970 dpdiv 0998 __floatunsidf 09b4 dpsub 09fc dpadd 0bb8 __fixunsdfdi 0e3c dpmul 1134 __floatundidf 1248 frexp"
		altNames = "_dvfprintf_eEfFgG"
	strings:
		$1 = { 88 FF BD 27 5C 00 B3 AF 54 00 B1 AF 50 00 B0 AF 74 00 BF AF 70 00 BE AF 6C 00 B7 AF 68 00 B6 AF 64 00 B5 AF 60 00 B4 AF 58 00 B2 AF 21 98 80 00 21 88 A0 00 80 00 A6 AF 34 00 A0 AF 38 00 A0 AF 21 80 00 00 00 00 24 82 43 00 80 10 10 00 A4 A3 25 00 02 24 57 00 82 14 01 00 32 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 F0 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 4B 00 45 10 FF FF 71 24 2E 00 44 28 41 00 80 10 00 00 00 00 53 00 46 50 01 00 DE 37 4F 00 48 50 02 00 DE 37 ?? ?? 04 3C ?? ?? 83 24 21 20 62 00 01 00 84 90 02 00 C6 33 FE FF C5 33 0B F0 A6 00 08 00 C6 33 FB FF C5 33 04 00 84 30 47 00 80 10 0B F0 A6 00 21 A0 00 00 0A 00 05 24 02 20 85 72 01 00 31 26 21 A0 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 94 26 2E 00 04 24 45 00 44 50 01 00 31 26 00 10 DE 37 21 90 00 00 66 00 03 24 73 00 05 24 67 00 06 24 6C 00 07 24 10 00 09 24 00 80 08 24 67 00 44 28 10 00 A2 A3 D3 03 43 10 01 00 31 26 4C 00 80 10 00 00 00 00 47 00 03 24 82 00 43 10 48 00 43 28 D6 01 60 50 63 00 03 24 9D 03 40 14 45 00 03 24 74 00 BF 8F 21 10 00 02 70 00 BE 8F 6C 00 B7 8F 68 00 B6 8F 64 00 B5 8F 60 00 B4 8F 5C 00 B3 8F 58 00 B2 8F 54 00 B1 8F 50 00 B0 8F 08 00 E0 03 78 00 BD 27 C4 FF 47 14 ?? ?? 04 3C 04 00 DE 37 01 00 63 24 FF FF 62 80 B7 FF 45 14 FF FF 71 24 08 00 DE 37 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 C3 FF 44 14 21 A0 00 00 80 00 A5 8F 01 00 31 26 00 00 22 82 00 00 B4 8C 2E 00 04 24 04 00 A5 24 BE FF 44 14 80 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 5E 04 44 10 00 40 DE 37 21 20 62 00 01 00 84 90 21 90 00 00 04 00 84 30 B5 FF 80 10 0A 00 05 24 02 20 45 72 01 00 31 26 21 90 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 52 26 ?? ?? ?? 0? 66 00 03 24 33 04 45 10 74 00 44 28 92 01 80 50 75 00 03 24 36 00 46 50 00 02 DE 37 75 03 47 10 10 00 C2 33 10 00 B5 27 01 00 16 24 04 00 40 52 2B 90 D4 02 2B 10 56 02 0B B0 42 02 2B 90 D4 02 23 A0 96 02 0A A0 12 00 08 00 DE 33 0C 00 C0 17 21 90 80 02 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? FF FF 14 24 00 00 A4 82 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF D6 26 F8 FF D4 16 21 28 60 02 4D FF C0 53 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 20 00 DE 37 00 02 DE 37 00 07 C2 33 B9 00 40 10 21 B8 C0 03 00 10 C4 33 06 00 03 24 10 00 C2 33 21 01 40 10 0B 90 64 00 80 00 A4 8F F8 FF 02 24 07 00 83 24 24 10 62 00 00 00 46 8C 04 00 56 8C 08 00 45 24 80 00 A5 AF 20 00 A6 AF 20 00 A3 8F 21 28 C0 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 00 41 04 20 00 A3 8F 00 80 02 3C 26 B0 C2 02 03 00 D7 37 21 28 C0 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF 97 03 40 14 21 A8 00 00 00 01 E2 32 08 00 40 14 00 02 E2 32 E1 01 40 10 19 00 42 2A FC FF A2 2A 03 00 40 14 2A 10 B2 02 1F 03 40 14 00 00 00 00 9E 01 40 12 21 10 00 00 40 02 E2 7E 23 90 42 02 13 00 42 2E 98 01 40 14 12 00 02 24 10 00 A2 A3 20 00 A3 8F 21 28 C0 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 43 01 40 14 10 00 AB 83 20 00 A2 8F 21 28 C0 02 ?? ?? 1E 3C ?? ?? ?? 0? 21 20 40 00 18 00 B5 8F 21 B0 40 00 ?? ?? DE 27 FB FF 94 26 03 00 E2 32 63 00 B5 26 2B 10 02 00 23 A0 92 02 C7 00 B5 2E 23 A0 82 02 01 00 B5 2E 04 00 E2 32 15 01 40 10 23 A0 95 02 02 00 E2 32 CF 02 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 98 04 80 1A 08 00 E3 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 E4 32 20 00 A4 AF 10 00 A2 83 21 20 C0 02 21 28 00 00 C0 10 02 00 21 10 C2 03 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 20 C0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 96 03 40 16 21 B0 60 00 20 00 F7 32 02 00 E0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F DF 03 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A3 8F 64 00 62 28 C7 03 40 10 64 00 12 24 0A 00 12 24 1A 00 72 00 F4 01 40 02 21 28 60 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 72 00 F4 01 40 02 21 28 60 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A2 8F 8F FE 40 50 00 00 24 82 8D FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 1E 7C 4B 03 40 04 10 00 C2 33 A1 00 40 10 80 00 A5 8F 80 00 A4 8F 21 B8 00 00 00 00 95 8C 04 00 84 24 80 00 A4 AF 03 00 40 16 C0 00 D6 33 25 90 B7 02 01 00 52 2E 80 00 02 24 04 01 C2 12 C0 00 02 24 27 01 C2 12 10 00 A2 83 2A 18 52 00 62 00 60 10 2A 18 42 02 20 14 12 7C 10 00 A2 A3 05 00 80 12 00 40 C3 33 03 00 C3 33 2B 18 03 00 23 A0 83 02 00 40 C3 33 05 00 60 10 2A 20 54 00 2A 18 54 02 23 A0 92 02 0A A0 03 00 2A 20 54 00 23 10 82 02 0A 10 04 00 04 00 C3 33 51 00 60 10 20 00 A2 AF 02 00 C2 33 2D 02 40 54 01 00 C4 33 01 00 C2 33 2E 02 40 14 20 00 04 24 20 00 A6 8F 0C 00 C0 10 FF FF 48 26 20 00 B4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 B4 AF FF FF 48 26 08 00 DE 33 C0 A0 08 00 28 00 BE AF 80 40 08 00 ?? ?? 1E 3C ?? ?? DE 27 13 00 00 01 40 18 17 00 21 A0 D4 03 21 40 40 02 30 00 B1 AF 80 00 1E 24 21 88 60 00 12 90 00 00 12 00 00 51 28 00 A2 8F 94 02 DE 12 FF FF 08 25 C0 00 05 24 9F 02 C5 52 00 00 86 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 48 00 A8 AF 48 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 94 26 F1 FF 00 15 FC FF 52 26 28 00 A2 8F 22 FE 40 10 30 00 B1 8F 20 00 A3 8F 1F FE 60 18 21 90 60 00 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 80 00 A2 8F 07 00 43 24 F8 FF 02 24 24 10 62 00 00 00 43 8C 04 00 56 8C 08 00 42 24 20 00 A3 AF ?? ?? ?? 0? 80 00 A2 AF ?? ?? ?? 0? 0B 90 43 00 20 00 A2 8F CA 01 40 14 08 00 C4 33 08 00 C3 33 28 00 A3 AF 02 00 C2 33 D4 01 40 50 01 00 DE 33 01 00 C4 33 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 48 26 C0 A0 08 00 ?? ?? 1E 3C 80 40 08 00 ?? ?? DE 27 13 00 00 01 40 18 17 00 21 A0 D4 03 21 40 40 02 30 00 B1 AF 80 00 1E 24 21 88 60 00 ?? ?? ?? 0? 12 90 00 00 8D 02 43 10 65 00 03 24 77 FE 43 14 10 00 B5 27 ?? ?? ?? 0? 00 01 DE 37 85 02 43 10 78 00 03 24 71 FE 43 14 10 00 B5 27 ?? ?? ?? 0? 80 00 DE 37 21 B8 00 00 00 00 B5 8C 04 00 A5 24 ?? ?? ?? 0? 80 00 A5 AF 08 00 E5 32 0B 00 A0 14 20 00 A5 AF 0A 00 80 1A 02 00 E2 32 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 E2 32 C4 01 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 23 20 AB 02 ?? ?? ?? 0? 44 00 AB AF 20 00 A6 8F 21 38 60 00 21 28 C0 02 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 50 60 00 21 48 40 00 21 28 40 01 21 20 40 00 3C 00 A9 AF ?? ?? ?? 0? 40 00 AA AF 21 20 40 00 ?? ?? ?? 0? 48 00 A2 AF 3C 00 A9 8F 40 00 AA 8F 21 30 40 00 21 20 20 01 21 28 40 01 ?? ?? ?? 0? 21 38 60 00 ?? ?? 06 3C ?? ?? C6 24 00 00 C4 8C 04 00 C5 8C 21 38 60 00 ?? ?? ?? 0? 21 30 40 00 48 00 A8 8F 3C 00 A9 8F 40 00 AA 8F 12 00 40 1C 44 00 AB 8F ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 20 01 ?? ?? ?? 0? 21 28 40 01 21 50 60 00 21 48 40 00 21 28 40 01 21 20 40 00 3C 00 A9 AF ?? ?? ?? 0? 40 00 AA AF 44 00 AB 8F 40 00 AA 8F 3C 00 A9 8F 21 40 40 00 ?? ?? 1E 3C 01 00 62 25 C0 10 02 00 ?? ?? DE 27 21 10 C2 03 04 00 43 8C 68 01 60 10 21 B0 00 01 C0 58 0B 00 21 58 CB 03 04 00 62 8D C8 02 40 50 00 00 62 8D ?? ?? 02 3C ?? ?? 42 24 21 20 20 01 21 28 40 01 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? FF FF B5 26 21 10 40 02 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 2D 03 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 19 04 00 02 00 02 24 02 47 04 00 25 40 06 01 01 00 42 24 21 30 60 00 2B 18 E5 02 02 00 09 24 10 00 0A 24 20 14 02 7C 11 00 60 14 21 38 00 01 5A 01 E5 52 2B 20 A4 02 23 00 4A 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 19 04 00 02 47 04 00 25 40 06 01 21 48 40 00 21 30 60 00 01 00 42 24 2B 18 E5 02 20 14 02 7C F1 FF 60 10 21 38 00 01 10 00 A9 A3 ?? ?? ?? 0? 21 10 20 01 01 00 02 24 0D 03 E0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 02 00 06 24 02 00 02 24 ?? ?? ?? 0? 14 00 07 24 21 30 40 00 04 00 64 8C 01 00 42 24 2B 28 E4 02 77 02 A0 14 20 14 02 7C 72 02 97 50 00 00 64 8C F7 FF 47 14 08 00 63 24 ?? ?? ?? 0? 10 00 A2 A3 99 02 40 14 00 00 00 00 18 00 A8 8F 0A 00 02 29 15 00 40 10 34 00 A3 8F 20 00 A3 8F 21 28 C0 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 48 00 A8 AF 79 02 40 10 20 00 A3 8F 21 28 C0 02 ?? ?? ?? 0? 21 20 60 00 21 F0 40 00 25 10 43 00 21 A8 60 00 76 02 40 14 48 00 A8 8F 02 00 02 29 73 02 40 14 34 00 A3 8F 38 00 A2 8F ?? ?? 06 3C ?? ?? C7 8C ?? ?? C6 8C 21 20 60 00 21 28 40 00 ?? ?? ?? 0? 48 00 A8 AF 5C 02 40 04 48 00 A8 8F EE FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 48 00 A8 AF 38 00 A3 AF 34 00 A2 AF 21 18 40 00 20 00 A6 8F 38 00 A2 8F 21 28 C0 02 21 20 C0 00 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 48 00 A8 8F 21 F0 40 00 21 A8 60 00 28 00 A0 AF 30 00 A0 AF 01 00 02 24 B3 02 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 02 00 47 24 01 00 84 24 2B 30 A5 02 86 02 C0 14 01 00 42 24 81 02 B5 50 00 00 65 8C 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 B0 88 02 23 B0 D2 02 2B 10 12 00 23 B0 C7 02 03 00 E3 32 23 B0 C2 02 2B 18 03 00 04 00 E2 32 57 02 40 10 23 B0 C3 02 02 00 E2 32 7E 02 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 C0 5A 08 00 F7 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF D6 26 F9 FF C0 16 21 80 02 02 08 00 F7 32 20 00 B7 AF ?? ?? 14 3C ?? ?? ?? 0? ?? ?? 94 26 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 C0 03 21 28 A0 02 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 86 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A 0E 02 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 21 28 60 00 30 00 A2 8F 28 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 A8 40 00 FF FF 82 26 20 14 02 7C 21 B8 60 00 23 00 80 12 10 00 A2 A3 ?? ?? 1E 3C ?? ?? DE 27 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 20 A0 02 ?? ?? ?? 0? 21 28 E0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B4 83 27 10 02 00 2B 10 02 00 C0 18 14 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 28 E0 02 21 20 A0 02 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 FF FF 82 26 20 14 02 7C 21 B8 60 00 E1 FF 80 16 10 00 A2 A3 0A 00 40 12 20 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 20 00 A4 8F 4A FC 80 50 00 00 24 82 48 FC C0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF D6 26 F9 FF C0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 38 FE 80 14 28 00 A4 AF 20 00 B4 8F 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 C2 33 2F FE 40 14 20 00 B4 AF 01 00 DE 33 37 FE C0 53 FF FF 48 26 ?? ?? ?? 0? 20 00 04 24 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 B0 FC 43 14 10 00 B5 27 20 00 DE 37 ?? ?? ?? 0? 00 01 DE 37 3B FD 40 10 20 00 04 24 ?? ?? ?? 0? 00 00 00 00 00 00 42 8C 2B 10 02 01 97 FE 40 14 C0 58 0B 00 ?? ?? 03 3C }
	condition:
		$1
}

rule file_635_2_0 {
	meta:
		name = "_vfprintf_cdfFgGnopsuxX"
		size = 6508
		refs = "000c _ctype 0160 fputc 0464 __floatdisf 0484 fpcmp 0508 fptoui 0520 __floatundisf 052c fpsub 0710 __udivdi3 0724 __umoddi3 090c fpadd 094c fpmul 0a20 fpdiv 0f68 frexpf 15b0 __floatunsisf"
		altNames = "_vfprintf_cdfFgGnopuxX"
	strings:
		$1 = { 90 FF BD 27 64 00 B7 AF 21 10 00 00 ?? ?? 17 3C 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 68 00 BE AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 21 90 80 00 21 88 A0 00 78 00 A6 AF 34 00 A2 AF 21 80 00 00 ?? ?? F7 26 00 00 24 82 65 00 80 10 10 00 A4 A3 25 00 02 24 DB 01 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 CF 01 46 10 FF FF 91 24 2E 00 45 28 C5 01 A0 10 00 00 00 00 D7 01 47 50 01 00 63 34 D3 01 49 50 02 00 63 34 21 20 E2 02 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 CD 01 80 10 0B 18 A6 00 21 40 00 00 0A 00 05 24 02 20 05 71 01 00 31 26 21 40 82 00 00 00 22 82 21 20 E2 02 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 08 25 2E 00 04 24 CB 01 44 50 01 00 31 26 00 10 63 34 21 A0 00 00 10 00 07 24 00 80 06 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3E 00 A0 14 01 00 31 26 10 00 B3 27 01 00 1E 24 04 00 80 52 2B A0 C8 03 2B 10 9E 02 0B F0 82 02 2B A0 C8 03 23 40 1E 01 0A 40 14 00 08 00 76 30 0B 00 C0 16 21 A0 00 01 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 95 16 20 00 04 24 ?? ?? ?? 0? FF FF 15 24 21 28 40 02 ?? ?? ?? 0? 01 00 73 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D5 57 00 00 64 82 A8 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 13 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 94 26 F9 FF 93 16 20 00 04 24 00 00 24 82 9D FF 80 14 10 00 A4 A3 6C 00 BF 8F 21 10 00 02 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 ?? ?? 05 3C 80 20 04 00 ?? ?? A5 24 21 20 A4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 00 63 34 00 07 62 30 4E 00 40 10 21 B0 60 00 00 10 65 30 06 00 04 24 10 00 62 30 BB 02 40 10 0B A0 85 00 78 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 40 00 A3 AF 44 00 A8 AF ?? ?? ?? 0? 78 00 A2 AF 40 00 A3 8F 44 00 A8 8F 21 98 40 00 21 20 60 02 21 28 00 00 40 00 A3 AF ?? ?? ?? 0? 44 00 A8 AF 40 00 A3 8F 04 00 41 04 44 00 A8 8F 00 80 02 3C 26 98 53 00 03 00 76 34 21 20 60 02 21 28 00 00 44 00 A8 AF ?? ?? ?? 0? 18 00 A0 AF 44 00 A8 8F A9 02 40 14 21 18 00 00 00 02 C2 32 ED 00 40 14 FC FF 62 28 19 00 82 2A E5 02 40 14 FF 00 84 32 18 00 B5 8F 0A 00 A2 2A 40 01 40 10 ?? ?? 03 3C 21 20 60 02 21 28 00 00 ?? ?? ?? 0? 44 00 A8 AF CB 02 40 14 44 00 A8 8F 21 20 60 02 ?? ?? ?? 0? 44 00 A8 AF 44 00 A8 8F 21 20 40 00 21 28 00 00 44 00 A8 AF ?? ?? ?? 0? 21 F0 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 60 02 24 00 A2 AF 21 98 C0 03 18 00 A0 AF 21 A8 00 00 ?? ?? ?? 0? 44 00 A8 8F 20 00 63 34 00 02 63 34 00 07 62 30 B4 FF 40 14 21 B0 60 00 C0 00 62 30 75 02 40 14 20 16 03 7C 56 04 40 04 10 00 62 30 9F 02 40 10 78 00 A5 8F 78 00 A2 8F 00 00 44 8C 04 00 42 24 78 00 A2 AF C3 17 04 00 21 98 80 00 C9 02 40 04 21 B0 40 00 03 00 80 16 C0 00 75 30 25 A0 76 02 01 00 94 2E 40 00 02 24 B1 03 A2 12 41 00 A2 2A 68 03 40 10 80 00 02 24 16 00 A0 16 10 00 A2 83 01 00 02 24 E2 04 C0 12 10 00 A2 A3 ?? ?? 04 3C ?? ?? 84 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 09 24 21 38 40 00 04 00 85 8C 2B 30 C5 02 49 04 C0 54 10 00 A7 A3 43 04 B6 50 00 00 85 8C 01 00 42 24 20 14 02 7C F6 FF 49 14 08 00 84 24 10 00 A2 A3 2A 20 54 00 1D 03 80 10 2A 20 82 02 20 14 14 7C 10 00 A2 A3 05 00 00 11 00 40 64 30 03 00 64 30 2B 20 04 00 23 40 04 01 00 40 64 30 05 00 80 10 2A 28 48 00 2A 20 88 02 23 40 14 01 0A 40 04 00 2A 28 48 00 23 10 02 01 0A 10 05 00 04 00 64 30 0C 03 80 10 20 00 A2 AF 02 00 62 30 99 03 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 40 00 A3 AF 27 10 02 00 40 00 A3 8F 2B 10 02 00 21 80 02 02 20 00 A4 8F 08 00 62 30 B3 02 80 14 30 00 A2 AF FF FF 82 26 ?? ?? 07 3C C0 A0 02 00 ?? ?? FE 24 21 A0 D4 03 03 00 1E 24 80 40 02 00 02 F0 5E 70 41 00 A4 2A 40 10 16 00 20 00 63 30 28 00 A2 AF 24 00 A4 AF ?? ?? ?? 0? 2C 00 A3 AF 10 00 A0 16 10 00 A4 83 00 00 86 8E 04 00 87 8E 21 20 60 02 21 28 C0 02 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 44 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 44 00 A8 AF 44 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 94 26 FC FF 08 25 FD FF DE 27 FD FF 02 24 B9 02 C2 13 40 00 02 24 AB 02 A2 12 24 00 A5 8F DF FF A0 14 80 00 02 24 94 02 A2 12 C0 00 02 24 DD FF A2 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 63 34 ?? ?? ?? 0? 80 00 63 34 40 FE 48 54 21 20 E2 02 04 00 63 34 01 00 84 24 FF FF 82 80 33 FE 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 3D FE 44 14 21 40 00 00 78 00 A5 8F 01 00 31 26 00 00 22 82 00 00 A8 8C 2E 00 04 24 04 00 A5 24 38 FE 44 14 78 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 2E 03 44 10 00 40 63 34 21 20 E2 02 01 00 84 90 21 A0 00 00 04 00 84 30 2F FE 80 10 0A 00 05 24 02 20 85 72 01 00 31 26 21 A0 82 00 00 00 22 82 21 20 E2 02 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 94 26 ?? ?? ?? 0? 10 00 07 24 2A 01 40 14 2A 10 74 00 28 01 40 10 00 00 00 00 16 04 60 04 21 20 60 02 ?? ?? ?? 0? 44 00 A8 AF 44 00 A8 8F 21 A8 40 00 10 00 A0 12 21 28 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 13 00 06 24 04 00 64 8C 01 00 42 24 08 00 80 14 21 28 40 00 00 00 64 8C 2B 20 A4 02 05 00 80 54 23 A0 85 02 F7 FF 46 14 08 00 63 24 14 00 05 24 23 A0 85 02 19 00 82 2A 5E 03 40 50 20 24 14 7C FF 00 84 32 ?? ?? ?? 0? 44 00 A8 AF 21 28 40 00 ?? ?? ?? 0? 21 20 60 02 20 24 14 7C ?? ?? ?? 0? 21 98 40 00 21 F0 40 00 ED FE 80 12 44 00 A8 8F 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 44 00 A8 AF 21 28 40 00 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 ?? ?? ?? 0? 21 28 C0 03 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 00 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 A8 40 00 25 10 43 00 21 F0 00 00 12 00 40 10 44 00 A8 8F ?? ?? ?? 0? 18 00 B5 8F 21 20 A0 02 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 A8 40 00 ?? ?? ?? 0? 21 F0 60 00 25 10 43 00 C6 FE 40 14 44 00 A8 8F FF FF 94 26 EF FF 80 16 21 28 C0 03 18 00 B5 8F 0A 00 A2 2A C4 FE 40 14 21 20 60 02 ?? ?? 03 3C ?? ?? 63 24 34 00 A4 8F 00 00 65 8C ?? ?? ?? 0? 44 00 A8 AF 7A 01 40 04 44 00 A8 8F EE FF B5 26 18 00 B5 AF 20 24 15 7C ?? ?? ?? 0? 44 00 A8 AF 21 28 40 00 21 20 60 02 ?? ?? ?? 0? 34 00 A2 AF ?? ?? ?? 0? 21 20 40 00 44 00 A8 8F 21 20 00 00 21 F0 40 00 21 98 40 00 24 00 A4 AF 01 00 03 24 0A 00 C2 2F B4 03 40 14 10 00 A3 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 09 24 02 00 04 24 ?? ?? ?? 0? 12 00 07 24 21 48 80 00 04 00 65 8C 5F 02 A0 14 02 00 46 24 00 00 65 8C 2B 28 C5 03 5B 02 A0 14 01 00 84 24 01 00 42 24 20 24 04 7C F5 FF 47 14 08 00 63 24 10 00 A4 A3 14 00 06 24 23 A8 15 01 23 A8 B4 02 2B 10 14 00 23 A8 A6 02 03 00 C3 32 23 A8 A2 02 2B 18 03 00 04 00 C2 32 2A 02 40 10 23 A8 A3 02 02 00 C2 32 EB 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 A0 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 08 00 D6 32 20 00 B6 AF ?? ?? 07 3C ?? ?? ?? 0? ?? ?? F6 24 C0 18 03 00 21 18 C3 02 00 00 66 8C 04 00 67 8C 21 20 60 02 ?? ?? ?? 0? 21 28 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 82 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 82 2A 02 02 40 14 20 14 14 7C 12 00 02 24 10 00 A2 A3 EE FF 94 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 24 00 A5 8F ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 FF FF 62 26 20 14 02 7C 21 40 00 00 25 00 60 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 7E 24 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 C0 02 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B3 83 44 00 A8 8F 27 10 02 00 C0 18 13 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 C0 02 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 FF FF 62 26 20 14 02 7C 21 40 60 00 DF FF 60 16 10 00 A2 A3 0A 00 80 12 20 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A4 8F D6 FC 80 50 00 00 24 82 D4 FC A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 82 02 80 16 21 10 00 00 10 00 A2 A3 21 20 60 02 21 28 00 00 40 00 A3 AF ?? ?? ?? 0? 44 00 A8 AF 40 00 A3 8F 09 02 40 14 44 00 A8 8F ?? ?? ?? 0? 21 20 60 02 44 00 A8 8F 21 A8 40 00 ?? ?? 02 3C ?? ?? 5E 24 FB FF 08 25 03 00 C3 32 23 98 14 01 2B 18 03 00 04 00 C2 32 E1 01 40 10 23 98 63 02 02 00 C2 32 70 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 D9 02 60 1A 08 00 C5 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 C7 32 20 00 A7 AF 10 00 A2 83 21 20 A0 02 21 28 00 00 C0 10 02 00 21 10 C2 03 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 5A 02 80 16 21 A8 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 94 02 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 14 24 21 28 40 02 1A 00 54 00 F4 01 80 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A2 8F 57 FC 40 50 00 00 24 82 55 FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 78 00 A4 8F 00 00 93 8C 04 00 84 24 ?? ?? ?? 0? 78 00 A4 AF D9 01 40 04 10 00 62 30 34 00 40 10 78 00 A7 8F 78 00 A5 8F 21 B0 00 00 00 00 B3 8C 04 00 A5 24 ?? ?? ?? 0? 78 00 A5 AF 21 20 60 02 ?? ?? ?? 0? 18 00 A5 27 18 00 A4 8F 03 00 03 24 0A 00 02 24 FF FF 84 24 02 18 83 70 44 00 A8 8F 1A 00 62 00 F4 01 40 00 12 18 00 00 04 02 60 04 18 00 A3 AF 23 20 03 00 20 24 04 7C 40 00 A3 AF ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 34 00 A2 AF ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 34 00 A4 8F 40 00 A3 8F 2D 00 41 04 44 00 A8 8F FF FF 63 24 ?? ?? ?? 0? 18 00 A3 AF ED FF B5 26 ?? ?? ?? 0? 18 00 B5 AF 00 00 A4 8C 04 00 A5 24 78 00 A5 AF }
	condition:
		$1
}

rule file_651_2_0 {
	meta:
		name = "_vfprintf_eEgG"
		size = 5680
		refs = "000c _ctype 01b4 fputc 03ac __floatdisf 03c4 fpcmp 0438 fptoui 04ac fpadd 04d4 __floatundisf 04e0 fpsub 04ec fpmul 050c __umoddi3 052c __udivdi3 05f0 fpdiv 0e10 __floatunsisf 1238 frexpf"
		altNames = "_vfprintf_eEgGs"
	strings:
		$1 = { 98 FF BD 27 60 00 BE AF 21 10 00 00 ?? ?? 1E 3C 4C 00 B3 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 21 98 80 00 21 88 A0 00 70 00 A6 AF 2C 00 A2 AF 21 80 00 00 ?? ?? DE 27 00 00 24 82 41 00 80 10 10 00 A4 A3 25 00 02 24 55 00 82 14 01 00 32 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 A8 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 49 00 45 10 FF FF 71 24 2E 00 44 28 3F 00 80 10 00 00 00 00 51 00 46 50 01 00 B5 36 4D 00 48 50 02 00 B5 36 21 18 C2 03 01 00 63 90 02 00 A5 32 FE FF A4 32 0B A8 85 00 08 00 A5 32 FB FF A4 32 04 00 63 30 47 00 60 10 0B A8 85 00 21 40 00 00 0A 00 04 24 02 18 04 71 01 00 31 26 21 40 62 00 00 00 22 82 21 18 C2 03 01 00 63 90 04 00 63 30 F8 FF 60 14 D0 FF 08 25 2E 00 03 24 45 00 43 50 01 00 31 26 00 10 B5 36 21 90 00 00 67 00 03 24 73 00 05 24 6C 00 06 24 10 00 09 24 00 80 07 24 68 00 44 28 10 00 A2 A3 8F 00 43 10 01 00 31 26 4D 00 80 10 00 00 00 00 47 00 03 24 8A 00 43 50 20 00 B5 36 48 00 43 28 AC 02 60 50 63 00 03 24 F1 03 40 14 45 00 03 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C6 FF 47 54 21 18 C2 03 04 00 B5 36 01 00 63 24 FF FF 62 80 B9 FF 45 14 FF FF 71 24 08 00 B5 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 03 24 C3 FF 43 14 21 40 00 00 70 00 A4 8F 01 00 31 26 00 00 22 82 00 00 88 8C 2E 00 03 24 04 00 84 24 BE FF 43 14 70 00 A4 AF 01 00 31 26 00 00 22 82 2A 00 03 24 2D 04 43 10 00 40 B5 36 21 18 C2 03 01 00 63 90 21 90 00 00 04 00 63 30 B5 FF 60 10 0A 00 04 24 02 18 44 72 01 00 31 26 21 90 62 00 00 00 22 82 21 18 C2 03 01 00 63 90 04 00 63 30 F8 FF 60 14 D0 FF 52 26 ?? ?? ?? 0? 67 00 03 24 5E 03 45 10 74 00 44 28 5B 02 80 50 75 00 03 24 32 00 46 10 10 00 A2 32 10 00 B4 27 01 00 17 24 04 00 40 52 2B 90 E8 02 2B 10 57 02 0B B8 42 02 2B 90 E8 02 23 40 17 01 0A 40 12 00 08 00 B6 32 0C 00 C0 16 21 90 00 01 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 55 16 21 28 60 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 60 02 51 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 21 20 E0 00 0A 20 22 01 00 00 22 82 25 A8 95 00 FF FF B5 32 68 00 44 28 10 00 A2 A3 73 FF 43 14 01 00 31 26 00 02 B5 36 00 07 A2 32 63 01 40 10 20 00 B5 AF 00 10 A4 32 06 00 03 24 10 00 A2 32 FC 01 40 10 0B 90 64 00 70 00 A4 8F F8 FF 02 24 07 00 83 24 24 10 62 00 00 00 44 8C 04 00 45 8C 08 00 42 24 3C 00 A8 AF ?? ?? ?? 0? 70 00 A2 AF 3C 00 A8 8F 21 A0 40 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 3C 00 A8 AF 05 00 41 04 3C 00 A8 8F 00 80 02 3C 03 00 B5 36 26 A0 54 00 20 00 B5 AF 21 20 80 02 21 28 00 00 3C 00 A8 AF ?? ?? ?? 0? 18 00 A0 AF 21 B8 00 00 8D 03 40 14 3C 00 A8 8F 20 00 A3 8F 00 01 62 30 A2 01 40 14 00 02 62 30 02 03 40 10 19 00 42 2A FC FF E2 2A 9D 01 40 14 2A 10 F2 02 9B 01 40 10 00 00 00 00 66 04 E0 06 21 20 80 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 21 B0 40 00 10 00 C0 12 21 20 00 00 ?? ?? 05 3C ?? ?? A5 24 21 10 00 00 13 00 06 24 04 00 A3 8C 01 00 42 24 08 00 60 14 21 20 40 00 00 00 A3 8C 2B 18 C3 02 04 00 60 14 08 00 A5 24 F8 FF 46 54 04 00 A3 8C 14 00 04 24 23 90 44 02 19 00 42 2A 3B 04 40 50 20 24 12 7C FF 00 44 32 ?? ?? ?? 0? 3C 00 A8 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 20 24 12 7C ?? ?? ?? 0? 21 A0 40 00 21 A8 40 00 2B 00 40 12 3C 00 A8 8F 21 20 C0 02 21 28 00 00 ?? ?? ?? 0? 3C 00 A8 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 28 A0 02 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 00 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 A8 40 00 25 10 43 00 21 B0 00 00 0F 00 40 10 3C 00 A8 8F ?? ?? ?? 0? 18 00 B7 8F ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 A8 40 00 ?? ?? ?? 0? 21 B0 60 00 25 10 43 00 07 00 40 14 3C 00 A8 8F FF FF 52 26 21 28 C0 02 21 20 A0 02 0A 00 06 24 EF FF 40 16 21 38 00 00 18 00 B7 8F 0A 00 E2 2A 0F 00 40 10 ?? ?? 02 3C 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 3C 00 A8 AF C1 03 40 10 3C 00 A8 8F ?? ?? ?? 0? 21 20 80 02 C1 03 40 14 3C 00 A8 8F 02 00 E3 2A BF 03 60 14 21 20 40 00 ?? ?? 02 3C ?? ?? 45 8C 2C 00 A4 8F ?? ?? ?? 0? 3C 00 A8 AF AB 03 40 04 3C 00 A8 8F EE FF F7 26 18 00 B7 AF 20 24 17 7C ?? ?? ?? 0? 3C 00 A8 AF 21 28 40 00 21 20 80 02 ?? ?? ?? 0? 2C 00 A2 AF ?? ?? ?? 0? 21 20 40 00 3C 00 A8 8F 21 18 00 00 21 A8 40 00 21 A0 40 00 28 00 A3 AF 01 00 03 24 0A 00 A2 2E 02 04 40 14 10 00 A3 A3 ?? ?? 06 3C ?? ?? C5 24 21 10 00 00 02 00 09 24 02 00 03 24 12 00 07 24 04 00 A4 8C 02 00 46 24 01 00 63 24 CC 03 80 14 01 00 42 24 00 00 A4 8C 20 1C 03 7C 2B 20 A4 02 C7 03 80 14 08 00 A5 24 F5 FF 47 54 21 48 60 00 10 00 A3 A3 14 00 06 24 20 00 A4 8F 23 B0 17 01 23 B0 D2 02 2B 10 12 00 23 B0 C6 02 03 00 83 30 23 B0 C2 02 2B 18 03 00 04 00 82 30 96 03 40 10 23 B0 C3 02 02 00 82 30 BC 03 40 10 20 00 A6 8F 01 00 84 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 D1 03 C0 1A 20 00 A2 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF D6 26 F9 FF C0 16 21 80 02 02 20 00 A3 8F 08 00 63 30 24 00 A3 AF ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 95 24 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 80 02 21 28 00 00 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 A6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A 6E 03 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 28 00 A5 8F ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 20 40 00 21 B8 40 00 FF FF 82 26 20 14 02 7C 21 40 00 00 25 00 80 12 10 00 A2 A3 ?? ?? 06 3C ?? ?? D5 24 C0 10 02 00 21 10 A2 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B4 83 3C 00 A8 8F 27 10 02 00 C0 18 14 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF 82 26 20 14 02 7C 21 40 60 00 DF FF 80 16 10 00 A2 A3 0A 00 40 12 24 00 A2 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 24 00 A2 8F E1 FD 40 50 00 00 24 82 DF FD C0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF D6 26 F9 FF C0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 15 7C 6A 02 40 04 10 00 A2 32 C1 00 40 10 70 00 A3 8F 70 00 A2 8F 21 B8 00 00 00 00 54 8C 04 00 42 24 70 00 A2 AF 03 00 40 16 C0 00 B6 32 25 90 97 02 01 00 52 2E 80 00 02 24 5D 01 C2 12 C0 00 02 24 80 01 C2 12 10 00 A2 83 2A 18 52 00 8E 00 60 10 2A 18 42 02 20 14 12 7C 10 00 A2 A3 05 00 00 11 00 40 A3 32 03 00 A3 32 2B 18 03 00 23 40 03 01 00 40 A3 32 05 00 60 10 2A 20 48 00 2A 18 48 02 23 40 12 01 0A 40 03 00 2A 20 48 00 23 10 02 01 0A 10 04 00 04 00 A3 32 7D 00 60 10 20 00 A2 AF 02 00 A2 32 A8 01 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 20 00 A4 8F 27 10 02 00 2B 10 02 00 A1 01 80 14 21 80 02 02 08 00 B5 32 28 00 B5 AF FF FF 48 26 ?? ?? 03 3C C0 10 08 00 ?? ?? 75 24 40 20 17 00 21 A8 A2 02 80 40 08 00 12 00 40 12 24 00 A4 AF 80 00 06 24 F9 01 C6 12 FF FF 52 26 C0 00 02 24 E7 01 C2 52 00 00 A6 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F0 FF 40 16 FC FF 08 25 28 00 A2 8F 7E FD 40 50 00 00 24 82 20 00 A3 8F 7B FD 60 58 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 20 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 20 00 A4 AF F7 FF 80 14 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 04 01 40 12 21 10 00 00 20 00 A4 8F 40 02 82 7C 23 90 42 02 13 00 42 2E FD 00 40 14 12 00 02 24 10 00 A2 A3 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 3C 00 A8 AF C2 00 40 14 3C 00 A8 8F ?? ?? ?? 0? 21 20 80 02 3C 00 A8 8F ?? ?? 06 3C 21 B0 40 00 ?? ?? D5 24 20 00 A6 8F FB FF 14 25 23 A0 92 02 03 00 C3 30 2B 18 03 00 04 00 C2 30 48 00 40 10 23 A0 83 02 02 00 C2 30 9B 01 40 10 20 00 A3 8F 01 00 C4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 A9 02 80 1A 20 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A6 8F 08 00 C6 30 ?? ?? ?? 0? 28 00 A6 AF 70 00 A6 8F 00 00 D4 8C 04 00 C6 24 ?? ?? ?? 0? 70 00 A6 AF ?? ?? ?? 0? 0B 90 43 00 20 00 A2 8F 47 01 40 14 08 00 A4 32 08 00 A3 32 28 00 A3 AF 02 00 A2 32 D0 01 40 50 01 00 B5 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 E2 FD 43 50 C0 00 B5 36 78 00 03 24 A5 FD 43 14 10 00 B4 27 ?? ?? ?? 0? 80 00 B5 36 E7 00 43 10 65 00 03 24 9F FD 43 14 10 00 B4 27 ?? ?? ?? 0? 00 01 B5 36 21 B8 00 00 00 00 74 8C 04 00 63 24 ?? ?? ?? 0? 70 00 A3 AF 20 00 A2 8F 08 00 42 30 0B 00 40 14 28 00 A2 AF 0A 00 80 1A 20 00 A3 8F 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A3 8F 02 00 62 30 40 01 40 10 20 00 A4 8F 01 00 64 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 C0 02 21 28 00 00 C0 10 02 00 21 10 A2 02 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 21 20 C0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 82 01 40 16 21 B8 60 00 20 00 A3 8F 20 00 62 30 02 00 40 14 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F BC 01 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 12 24 21 28 60 02 1A 00 52 00 F4 01 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 72 00 F4 01 40 02 21 28 60 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 28 00 A2 8F AB FC 40 50 00 00 24 82 A9 FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 10 00 A3 83 3C 00 A8 AF ?? ?? 15 3C 23 20 E3 02 20 24 04 7C ?? ?? ?? 0? 38 00 A3 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 21 20 40 00 ?? ?? ?? 0? 34 00 A2 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? A4 8E ?? ?? ?? 0? 21 28 40 00 38 00 A3 8F 34 00 A6 8F 0A 00 40 1C 3C 00 A8 8F ?? ?? A5 8E ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 3C 00 A8 8F 38 00 A3 8F 21 30 40 00 ?? ?? 04 3C 01 00 62 24 ?? ?? 95 24 C0 10 02 00 21 10 A2 02 04 00 44 8C AB 00 80 10 21 B0 C0 00 C0 18 03 00 21 18 A3 02 04 00 62 8C 7D 01 40 50 00 00 62 8C ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? FF FF F7 26 21 10 40 02 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 D3 01 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 19 04 00 02 00 02 24 02 4F 04 00 25 48 26 01 01 00 42 24 21 30 60 00 2B 18 E5 02 02 00 0A 24 10 00 0B 24 20 14 02 7C 11 00 60 14 21 38 20 01 AA 00 E5 52 2B 20 84 02 23 00 4B 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 19 04 00 02 4F 04 00 25 48 26 01 21 50 40 00 21 30 60 00 01 00 42 24 2B 18 E5 02 20 14 02 7C F1 FF 60 10 21 38 20 01 10 00 AA A3 ?? ?? ?? 0? 21 10 40 01 01 00 02 24 A9 01 E0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 43 24 02 00 06 24 02 00 02 24 ?? ?? ?? 0? 14 00 07 24 21 30 40 00 04 00 64 8C 01 00 42 24 2B 28 E4 02 32 01 A0 14 20 14 02 7C 2D 01 97 50 00 00 64 8C F7 FF 47 14 08 00 63 24 ?? ?? ?? 0? 10 00 A2 A3 70 00 A3 8F 10 00 A5 32 01 00 62 80 00 00 64 8C 04 00 63 24 78 00 A0 10 10 00 A2 A3 77 00 40 50 14 00 A4 A3 FF FF 05 24 74 00 45 50 14 00 A4 A3 14 00 A2 A3 15 00 A4 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF 70 00 A6 8F 00 00 C3 8C 04 00 C4 24 3C 01 60 10 21 A0 60 00 00 00 62 80 06 00 40 10 }
	condition:
		$1
}

rule file_674_0_0 {
	meta:
		name = "calloc"
		size = 84
		refs = "0010 malloc"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 02 80 A4 70 14 00 BF AF ?? ?? ?? 0? 21 20 00 02 09 00 40 10 21 18 00 00 07 00 00 12 21 18 40 00 21 80 50 00 00 00 60 A0 01 00 63 24 FE FF 70 54 00 00 60 A0 21 18 40 00 14 00 BF 8F 21 10 60 00 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_683_0_0 {
	meta:
		name = "malloc"
		size = 600
		refs = "0008 __allocs 0038 __allocp 0100 sbrk 011c __alloct 0198 __allocx"
	strings:
		$1 = { C0 FF BD 27 28 00 B4 AF ?? ?? 14 3C ?? ?? 82 8E 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 30 00 B6 AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 1C 00 B1 AF 79 00 40 10 18 00 B0 AF ?? ?? 15 3C 0F 00 85 24 C2 28 05 00 C0 28 05 00 87 00 B1 24 C2 89 11 00 77 FF 02 34 ?? ?? A4 8E 04 00 B3 24 C0 89 11 00 BF FF B2 24 08 00 B6 24 2B 10 A2 00 40 98 13 00 21 38 00 00 3F 00 52 2E ?? ?? 10 3C ?? ?? 94 26 0A 88 C2 02 04 00 82 90 01 00 42 30 12 00 40 54 00 00 97 8C 00 00 82 8C 04 00 43 90 01 00 63 30 07 00 60 14 21 18 85 00 00 00 42 8C 04 00 43 90 01 00 63 30 FC FF 60 10 00 00 82 AC 21 18 85 00 2B 30 43 00 04 00 C0 54 00 00 97 8C 2F 00 A1 04 2B 10 62 00 00 00 97 8C FE FF 02 24 24 B8 E2 02 2B 20 97 00 E7 FF 80 14 21 20 E0 02 20 00 E0 10 21 18 20 02 0B 18 72 02 21 20 60 00 10 00 A3 AF ?? ?? ?? 0? 14 00 A5 AF FF FF 04 24 21 F0 40 00 10 00 A3 8F 39 00 44 10 14 00 A5 8F ?? ?? 04 8E 08 00 86 24 15 00 46 10 00 00 82 AC 04 00 86 90 01 00 C6 34 04 00 86 A0 F8 FF 63 24 21 18 43 00 04 00 64 90 00 00 43 AC ?? ?? 03 AE 01 00 84 34 04 00 64 A0 04 00 44 90 00 00 74 AC 21 38 00 00 FE 00 83 30 04 00 43 A0 ?? ?? ?? 0? 21 20 E0 02 01 00 07 24 ?? ?? ?? 0? 21 20 E0 02 04 00 86 90 FE 00 C6 30 ?? ?? ?? 0? 04 00 86 A0 0A 00 40 10 ?? ?? A3 AE 00 00 65 8C ?? ?? 02 3C 04 00 66 8C ?? ?? 45 AC 00 00 85 8C ?? ?? 42 24 04 00 46 AC 00 00 65 AC 04 00 60 A0 04 00 85 90 00 00 83 AC 08 00 82 24 01 00 A3 34 04 00 83 A0 3C 00 BF 8F 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? ?? 0? 21 20 C0 02 21 18 C0 02 C4 FF 5E 14 14 00 A5 8F ?? ?? ?? 0? 21 10 00 00 ?? ?? 82 26 04 00 46 90 0C 00 45 90 ?? ?? 03 3C ?? ?? 63 24 ?? ?? 15 3C 01 00 C6 34 01 00 A5 34 ?? ?? 07 3C ?? ?? 83 AE ?? ?? E3 AC 08 00 42 AC ?? ?? A2 AE 04 00 46 A0 ?? ?? ?? 0? 0C 00 45 A0 }
	condition:
		$1
}

rule file_683_1_0 {
	meta:
		name = "free"
		size = 28
	strings:
		$1 = { 04 00 80 10 00 00 00 00 FC FF 82 90 FE 00 42 30 FC FF 82 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_683_2_0 {
	meta:
		name = "realloc"
		size = 308
		refs = "0040 malloc 0080 memcpy 00a4 __allocx"
	strings:
		$1 = { D8 FF BD 27 1C 00 B3 AF 24 00 BF AF 20 00 B4 AF 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 37 00 A0 10 21 98 80 00 3B 00 80 10 24 00 BF 8F FC FF 83 80 F8 FF 90 8C 01 00 64 30 2D 00 80 14 FE FF 04 24 ?? ?? ?? 0? 21 20 A0 00 21 90 40 00 1F 00 40 10 21 88 00 00 1D 00 53 10 21 88 60 02 F8 FF 54 8C 23 80 13 02 C3 80 10 00 23 A0 82 02 C3 A0 14 00 2B 30 14 02 0A 80 86 02 21 28 60 02 21 20 40 00 ?? ?? ?? 0? C0 30 10 00 2B 10 53 02 0F 00 40 10 21 88 40 02 C0 A0 14 00 21 A0 54 02 2B 10 74 02 0A 00 40 10 ?? ?? 02 3C 23 98 93 02 ?? ?? 44 24 ?? ?? 43 8C C3 98 13 00 04 00 82 8C C0 98 13 00 21 98 53 02 00 00 63 AE 04 00 62 AE 24 00 BF 8F 21 10 20 02 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 24 18 64 00 ?? ?? ?? 0? FC FF 63 A2 F3 FF 80 10 21 88 00 00 FC FF 82 90 FE 00 42 30 ?? ?? ?? 0? FC FF 82 A0 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 21 20 A0 00 ?? ?? ?? 0? 28 00 BD 27 }
	condition:
		$1
}

rule file_703_0_0 {
	meta:
		name = "cgets"
		size = 268
		refs = "003c getche 00ac putch"
	strings:
		$1 = { D0 FF BD 27 28 00 B6 AF 24 00 B5 AF 1C 00 B3 AF 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 2C 00 BF AF 20 00 B4 AF 21 80 80 00 21 B0 80 00 0A 00 11 24 0D 00 12 24 15 00 13 24 FF FF 95 24 ?? ?? ?? 0? 00 00 00 00 0C 00 51 50 00 00 C0 A2 0B 00 43 28 1C 00 60 10 08 00 03 24 12 00 43 10 00 00 00 00 00 00 C2 A2 ?? ?? ?? 0? 01 00 D6 26 F8 FF 51 14 0B 00 43 28 00 00 C0 A2 2C 00 BF 8F 21 10 00 02 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 30 00 BD 27 E5 FF 16 12 00 00 00 00 ?? ?? ?? 0? 20 00 04 24 ?? ?? ?? 0? 08 00 04 24 ?? ?? ?? 0? FF FF D6 26 EC FF 52 50 00 00 C0 A2 E5 FF 53 54 00 00 C2 A2 2B 10 16 02 D8 FF 40 10 21 A0 C0 02 ?? ?? ?? 0? 08 00 04 24 ?? ?? ?? 0? 20 00 04 24 FF FF 94 26 ?? ?? ?? 0? 08 00 04 24 F8 FF 90 16 00 00 00 00 ?? ?? ?? 0? 01 00 B6 26 }
	condition:
		$1
}

rule file_733_0_0 {
	meta:
		name = "strpbrk"
		size = 120
		refs = "0038 strchr"
	strings:
		$1 = { E0 FF BD 27 18 00 B1 AF 14 00 B0 AF 1C 00 BF AF 00 00 82 80 21 88 80 00 06 00 40 14 21 80 A0 00 ?? ?? ?? 0? 1C 00 BF 8F 00 00 22 82 0C 00 40 10 1C 00 BF 8F 21 28 40 00 ?? ?? ?? 0? 21 20 00 02 F9 FF 40 50 01 00 31 26 1C 00 BF 8F 21 10 20 02 14 00 B0 8F 18 00 B1 8F 08 00 E0 03 20 00 BD 27 21 88 00 00 21 10 20 02 14 00 B0 8F 18 00 B1 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_735_0_0 {
	meta:
		name = "strtoul"
		size = 532
		refs = "003c errno 0040 _ctype 00ec toupper"
	strings:
		$1 = { C8 FF BD 27 18 00 B1 AF ?? ?? 11 3C 28 00 B5 AF 20 00 B3 AF 14 00 B0 AF 34 00 BF AF 30 00 B7 AF 2C 00 B6 AF 24 00 B4 AF 1C 00 B2 AF 21 80 A0 00 21 98 80 00 21 A8 C0 00 6E 00 A0 10 ?? ?? 20 AE ?? ?? 16 3C 00 00 A4 AC ?? ?? D6 26 00 00 64 82 21 10 C4 02 01 00 42 80 88 00 42 30 FB FF 40 14 01 00 73 26 2D 00 02 24 4A 00 82 10 2B 00 02 24 4C 00 82 10 21 90 00 00 30 00 02 24 3B 00 82 50 00 00 64 82 03 00 A0 16 21 B8 00 00 21 B8 00 00 0A 00 15 24 ?? ?? ?? 0? 21 A0 00 00 1A 00 60 10 2A 18 55 00 19 00 60 50 21 10 00 00 02 18 95 72 21 10 62 00 2B 18 54 00 28 00 60 54 22 00 02 24 00 00 64 82 21 A0 40 00 01 00 73 26 01 00 17 24 21 10 C4 02 01 00 43 90 D0 FF 82 24 20 14 02 7C 03 00 65 30 ED FF A0 10 04 00 63 30 ?? ?? ?? 0? 00 00 00 00 C9 FF 42 24 20 14 02 7C 2A 18 55 00 EB FF 60 14 02 18 95 72 21 10 00 00 04 00 E0 12 00 00 00 00 02 00 00 12 FF FF 73 26 00 00 13 AE 28 00 40 14 34 00 BF 8F 23 10 14 00 0B A0 52 00 21 10 80 02 30 00 B7 8F 2C 00 B6 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 22 AE 01 00 73 26 ?? ?? ?? 0? 01 00 02 24 10 00 A0 16 01 00 73 26 78 00 02 24 21 00 82 10 58 00 02 24 1F 00 82 10 08 00 02 24 0A A8 55 00 ?? ?? ?? 0? 01 00 17 24 00 00 64 82 01 00 12 24 ?? ?? ?? 0? 01 00 73 26 00 00 64 82 ?? ?? ?? 0? 01 00 73 26 10 00 02 24 EF FF A2 12 01 00 17 24 ?? ?? ?? 0? 21 A0 00 00 FF FF 14 24 21 10 80 02 30 00 B7 8F 2C 00 B6 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 ?? ?? 16 3C ?? ?? ?? 0? ?? ?? D6 26 00 00 64 82 10 00 15 24 01 00 73 26 ?? ?? ?? 0? 01 00 17 24 }
	condition:
		$1
}

rule file_735_1_0 {
	meta:
		name = "strtol"
		size = 324
		refs = "0008 errno 0028 _ctype 0084 strtoul"
	strings:
		$1 = { D8 FF BD 27 20 00 B4 AF ?? ?? 14 3C 1C 00 B3 AF 18 00 B2 AF 10 00 B0 AF 24 00 BF AF 14 00 B1 AF ?? ?? 80 AE 00 00 91 80 ?? ?? 02 3C ?? ?? 42 24 21 18 51 00 01 00 63 80 21 90 80 00 21 98 A0 00 88 00 63 30 08 00 60 10 21 80 80 00 01 00 10 26 00 00 11 82 21 18 51 00 01 00 63 80 88 00 63 30 FB FF 60 54 01 00 10 26 2D 00 02 24 22 00 22 12 2B 00 02 24 02 00 22 52 01 00 10 26 2B 00 11 24 21 20 00 02 ?? ?? ?? 0? 21 28 60 02 06 00 60 12 2B 00 03 24 00 00 63 8E 20 00 70 50 00 00 72 AE 1E 00 43 12 2B 00 03 24 15 00 23 12 2D 00 03 24 09 00 23 12 00 80 03 3C 24 00 BF 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 01 00 63 24 2B 18 43 00 F5 FF 60 14 23 10 02 00 22 00 02 24 ?? ?? 82 AE ?? ?? ?? 0? 00 80 02 3C ?? ?? ?? 0? 01 00 10 26 EE FF 41 04 24 00 BF 8F 22 00 02 24 ?? ?? 82 AE FF 7F 02 3C ?? ?? ?? 0? FF FF 42 34 E2 FF 40 10 2B 00 03 24 22 00 02 24 2D 00 03 24 ?? ?? 82 AE E1 FF 23 12 00 80 02 3C FF 7F 02 3C ?? ?? ?? 0? FF FF 42 34 }
	condition:
		$1
}

rule file_744_0_0 {
	meta:
		name = "rewind"
		size = 32
		refs = "000c fseek"
	strings:
		$1 = { E8 FF BD 27 21 28 00 00 14 00 BF AF ?? ?? ?? 0? 21 30 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_272_0_4 {
	meta:
		name = "atof"
		size = 32
		refs = "000c _Stod"
	strings:
		$1 = { E8 FF BD 27 21 28 00 00 14 00 BF AF ?? ?? ?? 0? 21 30 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_764_1_0 {
	meta:
		name = "_dvfprintf_eEfF"
		size = 5844
		refs = "009c _ctype 01b0 fputc 05b0 dpcmp 0634 dptoul 0738 _npowers_ 076c dpmul 0804 dpadd 0888 dpdiv 0894 __fixunsdfdi 09a8 __udivdi3 09bc __umoddi3 0cc0 __floatunsidf 0cdc dpsub 1180 frexp 13b0 __floatundidf"
		altNames = "_dvfprintf_eEfFs"
	strings:
		$1 = { 98 FF BD 27 4C 00 B3 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 21 98 80 00 21 88 A0 00 70 00 A6 AF 28 00 A0 AF 2C 00 A0 AF 21 80 00 00 00 00 24 82 42 00 80 10 10 00 A4 A3 25 00 02 24 56 00 82 14 01 00 32 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 A8 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 4A 00 45 10 FF FF 71 24 2E 00 44 28 40 00 80 10 00 00 00 00 52 00 46 50 01 00 B5 36 4E 00 48 50 02 00 B5 36 ?? ?? 04 3C ?? ?? 83 24 21 20 62 00 01 00 84 90 02 00 A6 32 FE FF A5 32 0B A8 A6 00 08 00 A6 32 FB FF A5 32 04 00 84 30 46 00 80 10 0B A8 A6 00 21 F0 00 00 0A 00 05 24 02 20 C5 73 01 00 31 26 21 F0 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF DE 27 2E 00 04 24 44 00 44 50 01 00 31 26 00 10 B5 36 21 90 00 00 66 00 03 24 73 00 05 24 6C 00 06 24 10 00 08 24 00 80 07 24 67 00 44 28 10 00 A2 A3 8E 00 43 10 01 00 31 26 4C 00 80 10 00 00 00 00 63 00 03 24 99 02 43 10 64 00 43 28 65 01 60 50 65 00 03 24 BB 02 40 14 45 00 03 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C5 FF 47 14 ?? ?? 04 3C 04 00 B5 36 01 00 63 24 FF FF 62 80 B8 FF 45 14 FF FF 71 24 08 00 B5 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 C4 FF 44 14 21 F0 00 00 70 00 A5 8F 01 00 31 26 00 00 22 82 00 00 BE 8C 2E 00 04 24 04 00 A5 24 BF FF 44 14 70 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 0A 04 44 10 00 40 B5 36 21 20 62 00 01 00 84 90 21 90 00 00 04 00 84 30 B6 FF 80 10 0A 00 05 24 02 20 45 72 01 00 31 26 21 90 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 52 26 ?? ?? ?? 0? 66 00 03 24 61 02 45 10 74 00 44 28 B4 00 80 50 75 00 03 24 32 00 46 10 10 00 A2 32 10 00 B4 27 01 00 17 24 04 00 40 52 2B 90 FE 02 2B 10 57 02 0B B8 42 02 2B 90 FE 02 23 F0 D7 03 0A F0 12 00 08 00 B6 32 0C 00 C0 16 21 90 C0 03 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 55 16 21 28 60 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 60 02 50 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 21 20 E0 00 0A 20 02 01 00 00 22 82 25 A8 95 00 FF FF B5 32 67 00 44 28 10 00 A2 A3 74 FF 43 14 01 00 31 26 00 04 B5 36 00 07 A2 32 7E 00 40 14 21 B0 A0 02 20 16 15 7C B9 03 40 04 10 00 A2 32 29 02 40 10 70 00 A2 8F 70 00 A7 8F 21 B8 00 00 00 00 F4 8C 04 00 E7 24 70 00 A7 AF 03 00 40 16 C0 00 B6 32 25 90 97 02 01 00 52 2E 80 00 02 24 56 03 C2 12 C0 00 02 24 3F 03 C2 12 10 00 A2 83 2A 18 52 00 27 03 60 10 2A 18 42 02 20 14 12 7C 10 00 A2 A3 05 00 C0 13 00 40 A3 32 03 00 A3 32 2B 18 03 00 23 F0 C3 03 00 40 A3 32 05 00 60 10 2A 20 5E 00 2A 18 5E 02 23 F0 D2 03 0A F0 03 00 2A 20 5E 00 23 10 C2 03 0A 10 04 00 04 00 A3 32 16 03 60 10 20 00 A2 AF 02 00 A2 32 99 03 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A3 8F 0C 00 60 50 08 00 B5 32 20 00 BE 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 20 00 BE AF 08 00 B5 32 24 00 B5 AF FF FF 48 26 C0 10 08 00 ?? ?? 15 3C 80 40 08 00 13 00 00 01 ?? ?? B5 26 40 18 17 00 21 40 40 02 30 00 B1 AF 21 A8 A2 02 80 00 1E 24 21 88 60 00 11 00 00 11 12 90 00 00 DA 02 DE 12 FF FF 08 25 C0 00 07 24 C8 02 C7 52 00 00 A6 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F1 FF 00 15 FC FF 52 26 24 00 A4 8F CF FE 80 10 30 00 B1 8F 20 00 A5 8F CC FE A0 18 21 90 A0 00 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 05 00 43 10 78 00 03 24 4D FF 43 14 10 00 B4 27 ?? ?? ?? 0? 80 00 B5 36 C0 00 B5 36 00 07 A2 32 84 FF 40 10 21 B0 A0 02 00 10 A4 32 06 00 03 24 10 00 A2 32 5D 00 40 10 0B 90 64 00 70 00 A2 8F 07 00 43 24 F8 FF 02 24 24 10 62 00 00 00 44 8C 04 00 54 8C 08 00 43 24 70 00 A3 AF 20 00 A4 AF 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 00 41 04 20 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 B6 36 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF E4 02 40 14 20 00 A3 8F 24 00 A0 AF 00 01 C2 32 47 00 40 10 19 00 42 2A 13 00 42 2E 93 01 40 10 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 10 00 B2 A3 95 01 40 14 10 00 AA 83 20 00 A2 8F 21 28 80 02 ?? ?? 15 3C ?? ?? ?? 0? 21 20 40 00 18 00 B4 8F 21 B8 40 00 ?? ?? B5 26 63 00 83 26 FB FF DE 27 03 00 C2 32 2B 10 02 00 23 A0 D2 03 C7 00 63 2C 23 A0 82 02 01 00 63 2C 04 00 C2 32 DC 01 40 10 23 A0 83 02 02 00 C2 32 92 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 F9 03 80 1A 08 00 C4 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 C5 32 ?? ?? ?? 0? 20 00 A5 AF E8 FE 43 14 10 00 B4 27 ?? ?? ?? 0? 00 01 B5 36 70 00 A5 8F F8 FF 02 24 07 00 A3 24 24 10 62 00 00 00 46 8C 04 00 54 8C 08 00 42 24 20 00 A6 AF ?? ?? ?? 0? 70 00 A2 AF 40 00 40 10 24 00 A3 8F FF 00 55 32 6E 00 A2 2E 2F 03 40 14 0B 00 A2 2E EB 51 02 3C 1F 85 42 34 19 00 A2 02 ?? ?? 17 3C ?? ?? F7 26 ?? ?? 03 3C ?? ?? 66 8C ?? ?? 67 8C 10 28 00 00 42 41 05 00 FF 00 02 31 12 00 42 24 C0 10 02 00 21 10 57 00 00 00 44 8C 04 00 45 8C ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 64 00 04 24 CC CC 09 3C 02 28 04 71 CD CC 29 35 21 20 40 00 34 00 A9 AF 23 40 A5 02 FF 00 08 31 19 00 09 01 21 28 60 00 10 38 00 00 F8 07 E2 30 21 10 E2 02 48 00 46 8C ?? ?? ?? 0? 4C 00 47 8C 34 00 A9 8F 21 20 40 00 21 28 60 00 19 00 A9 02 0A 00 02 24 10 38 00 00 C2 18 07 00 02 30 62 70 23 10 A6 02 FF 00 42 30 C0 10 02 00 21 B8 57 00 00 00 E6 8E ?? ?? ?? 0? 04 00 E7 8E 20 00 A8 8F 21 28 80 02 21 30 40 00 21 20 00 01 ?? ?? ?? 0? 21 38 60 00 20 00 A2 AF 21 A0 60 00 24 00 A3 8F 0A 00 62 28 DB 01 40 14 20 00 A3 8F 2C 00 A2 8F 28 00 A3 8F 21 28 40 00 ?? ?? 02 3C ?? ?? 42 24 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 20 60 00 C2 02 41 04 24 00 A4 8F 24 00 A3 8F ED FF 68 24 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 3C 00 A8 AF 2C 00 A3 AF 20 00 A6 8F 21 18 40 00 28 00 A2 AF 2C 00 A2 8F 21 20 C0 00 21 28 80 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 3C 00 A8 8F 21 B8 40 00 21 A8 60 00 20 00 A0 AF 24 00 A0 AF 01 00 02 24 78 03 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 02 00 47 24 01 00 84 24 2B 30 A5 02 97 02 C0 14 01 00 42 24 92 02 B5 50 00 00 65 8C 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 A0 C8 03 23 A0 92 02 2B 10 12 00 23 A0 87 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 58 02 40 10 23 A0 83 02 02 00 C2 32 92 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 1A 08 00 DE 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 DE 32 ?? ?? 16 3C ?? ?? ?? 0? ?? ?? D6 26 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 E0 02 21 28 A0 02 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 C6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A AF 02 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 21 28 60 00 24 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 27 00 A0 12 10 00 A2 A3 ?? ?? 15 3C ?? ?? B5 26 21 40 60 00 21 B8 C0 02 C0 10 02 00 21 10 A2 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B6 83 3C 00 A8 8F 27 10 02 00 C0 18 16 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF C2 26 20 14 02 7C 21 40 60 00 DF FF C0 16 10 00 A2 A3 09 00 40 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 36 FD C0 53 00 00 24 82 34 FD 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 70 00 A7 8F 10 00 A4 32 01 00 E2 80 00 00 E5 8C 04 00 E3 24 08 01 80 10 10 00 A2 A3 07 01 40 50 14 00 A5 A3 FF FF 04 24 04 01 44 50 14 00 A5 A3 14 00 A2 A3 15 00 A5 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF 70 00 A5 8F 00 00 A3 8C 04 00 A4 24 3B 02 60 10 21 A0 60 00 00 00 62 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 77 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A4 AF 21 B8 00 00 00 00 54 8C 04 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 90 FD 43 14 10 00 B4 27 20 00 B5 36 ?? ?? ?? 0? 00 01 B5 36 12 00 02 24 21 28 80 02 21 20 60 00 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 10 00 A2 A3 6F FE 40 10 20 00 A2 8F 10 00 AA 83 24 00 A5 8F 38 00 AA AF ?? ?? ?? 0? 23 20 AA 00 20 00 A6 8F 21 38 60 00 21 28 80 02 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 21 48 60 00 21 40 40 00 21 28 20 01 21 20 40 00 3C 00 A8 AF ?? ?? ?? 0? 34 00 A9 AF 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 3C 00 A8 8F 34 00 A9 8F 21 30 40 00 21 20 00 01 21 28 20 01 ?? ?? ?? 0? 21 38 60 00 ?? ?? 06 3C ?? ?? C4 8C ?? ?? C5 8C 21 38 60 00 ?? ?? ?? 0? 21 30 40 00 3C 00 A8 8F 34 00 A9 8F 12 00 40 1C 38 00 AA 8F ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 01 ?? ?? ?? 0? 21 28 20 01 21 48 60 00 21 40 40 00 21 28 20 01 21 20 40 00 3C 00 A8 AF ?? ?? ?? 0? 34 00 A9 AF 38 00 AA 8F 34 00 A9 8F 3C 00 A8 8F 21 A0 40 00 ?? ?? 15 3C 01 00 42 25 C0 10 02 00 ?? ?? B5 26 21 10 A2 02 04 00 43 8C C0 01 60 14 21 B8 80 02 00 00 42 8C 2B 10 82 02 BD 01 40 14 C0 50 0A 00 ?? ?? 02 3C 24 00 A3 8F ?? ?? 46 8C ?? ?? 47 8C 21 20 00 01 21 28 20 01 01 00 74 24 ?? ?? ?? 0? 18 00 B4 AF 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 B8 40 00 63 00 83 26 FB FF DE 27 03 00 C2 32 2B 10 02 00 23 A0 D2 03 C7 00 63 2C 23 A0 82 02 01 00 63 2C 04 00 C2 32 26 FE 40 14 23 A0 83 02 08 00 C6 32 0B 00 C0 14 20 00 A6 AF 0A 00 80 1A 02 00 C2 32 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 C2 32 A6 01 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 E0 02 21 28 00 00 C0 10 02 00 21 10 A2 02 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 21 20 E0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 9A 01 40 16 21 F0 60 00 20 00 D6 32 02 00 C0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F D5 01 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 64 00 43 28 B9 01 60 10 64 00 12 24 0A 00 12 24 1A 00 52 00 F4 01 40 02 21 28 60 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 72 00 F4 01 40 02 21 28 60 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A2 8F 3C FC 40 50 00 00 24 82 3A FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 FD 00 40 10 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 B8 40 00 25 10 43 00 FB 00 40 14 21 A8 60 00 24 00 A4 8F 02 00 82 28 16 FE 40 10 2C 00 A2 8F ?? ?? ?? 0? 21 20 E0 02 14 00 A5 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? }
	condition:
		$1
}

rule file_774_1_0 {
	meta:
		name = "_vfprintf_fF"
		size = 4156
		refs = "00a4 _ctype 01dc fputc 03e8 fpcmp 0454 _npowers_f 0480 fpmul 0514 fpadd 0548 fptoui 0564 __floatundisf 0570 fpsub 0680 __udivdi3 0694 __umoddi3 0a5c __floatdisf 0bb0 fpdiv 0dcc frexpf"
		altNames = "_vfprintf_fFs"
	strings:
		$1 = { 98 FF BD 27 60 00 BE AF 21 10 00 00 ?? ?? 1E 3C 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 4C 00 B3 AF 21 90 80 00 21 88 A0 00 70 00 A6 AF 28 00 A2 AF 21 80 00 00 ?? ?? DE 27 00 00 24 82 42 00 80 10 10 00 A4 A3 25 00 02 24 8C 00 82 14 01 00 33 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 B0 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 80 00 45 10 FF FF 71 24 2E 00 44 28 76 00 80 10 00 00 00 00 88 00 46 50 01 00 D6 36 84 00 48 50 02 00 D6 36 ?? ?? 04 3C ?? ?? 84 24 21 18 82 00 01 00 63 90 02 00 C5 32 FE FF C4 32 0B B0 85 00 08 00 C5 32 FB FF C4 32 04 00 63 30 7C 00 60 10 0B B0 85 00 21 18 00 00 0A 00 05 24 02 20 65 70 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 18 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF 63 24 2E 00 04 24 78 00 44 50 01 00 31 26 00 10 D6 36 21 98 00 00 6C 00 04 24 10 00 06 24 00 80 05 24 10 00 A2 A3 98 00 44 10 01 00 31 26 6D 00 44 28 15 00 80 10 75 00 04 24 63 00 04 24 2B 02 44 10 66 00 04 24 98 00 44 10 00 04 D5 36 14 00 40 14 10 00 B4 27 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 16 02 44 10 78 00 04 24 84 00 44 10 73 00 04 24 6C 00 44 10 10 00 B4 27 01 00 17 24 04 00 60 52 2B 98 E3 02 2B 10 77 02 0B B8 62 02 2B 98 E3 02 23 18 77 00 0A 18 13 00 08 00 D6 32 0C 00 C0 16 21 98 60 00 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 20 00 04 24 F8 FF 75 16 21 28 40 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 40 02 88 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 20 00 04 24 F8 FF 74 16 21 28 40 02 ?? ?? ?? 0? 00 00 24 82 8F FF 47 14 ?? ?? 04 3C 04 00 D6 36 01 00 63 24 FF FF 62 80 82 FF 45 14 FF FF 71 24 08 00 D6 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 90 FF 44 14 21 18 00 00 70 00 A7 8F 01 00 31 26 00 00 22 82 00 00 E3 8C 2E 00 04 24 04 00 E7 24 8B FF 44 14 70 00 A7 AF 01 00 31 26 00 00 22 82 2A 00 04 24 6A 02 44 10 00 40 D6 36 ?? ?? 08 3C ?? ?? 08 25 21 20 02 01 01 00 84 90 21 98 00 00 04 00 84 30 80 FF 80 10 0A 00 05 24 02 20 65 72 01 00 31 26 ?? ?? 06 3C ?? ?? C6 24 21 98 82 00 00 00 22 82 21 20 C2 00 01 00 84 90 04 00 84 30 F6 FF 80 14 D0 FF 73 26 ?? ?? ?? 0? 6C 00 04 24 70 00 A8 8F 00 00 04 8D 04 00 05 25 26 03 80 10 21 A0 80 00 00 00 82 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 97 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A5 AF 10 00 D5 32 21 38 A0 00 0A 38 D5 00 25 B0 F6 00 FF FF D6 32 ?? ?? ?? 0? 00 00 22 82 80 00 D5 36 00 07 A2 32 28 01 40 10 21 B0 A0 02 00 10 A5 32 06 00 04 24 10 00 A2 32 9C 01 40 14 0B 98 85 00 70 00 AB 8F 00 00 74 8D 04 00 6B 25 70 00 AB AF 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 04 00 41 04 38 00 A3 8F 00 80 02 3C 26 A0 54 00 03 00 B6 36 21 20 80 02 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 18 00 A0 AF 21 B8 00 00 6A 02 40 14 38 00 A3 8F 19 00 62 2A 3F 00 40 10 0A 00 E2 2A FF 00 75 32 6E 00 A2 2E 88 02 40 14 0B 00 A2 2E EB 51 02 3C 1F 85 42 34 19 00 A2 02 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 06 3C ?? ?? C6 24 38 00 A3 AF 34 00 A6 AF 10 48 00 00 42 39 09 00 FF 00 E2 30 12 00 42 24 80 10 02 00 21 10 46 00 00 00 44 8C ?? ?? ?? 0? 30 00 A7 AF 30 00 A7 8F 64 00 04 24 CC CC 08 3C 02 28 E4 70 CD CC 08 35 21 20 40 00 34 00 A6 8F 30 00 A8 AF 23 38 A5 02 FF 00 E7 30 19 00 E8 00 10 58 00 00 C0 38 62 7D 09 00 42 24 80 10 02 00 21 10 46 00 ?? ?? ?? 0? 00 00 45 8C 30 00 A8 8F 21 20 40 00 0A 00 02 24 19 00 A8 02 34 00 A6 8F 10 48 00 00 C2 28 09 00 02 38 A2 70 23 10 A7 02 FF 00 42 30 80 10 02 00 21 30 46 00 ?? ?? ?? 0? 00 00 C5 8C 38 00 A3 8F 21 28 40 00 21 20 80 02 ?? ?? ?? 0? 38 00 A3 AF 38 00 A3 8F 21 A0 40 00 0A 00 E2 2A 92 01 40 10 ?? ?? 06 3C 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 38 00 A3 AF 70 02 40 10 38 00 A3 8F ?? ?? ?? 0? 21 20 80 02 85 01 40 10 38 00 A3 8F 21 20 40 00 21 28 00 00 38 00 A3 AF ?? ?? ?? 0? 21 A8 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 38 00 A3 8F 21 B8 40 00 21 A0 A0 02 18 00 A0 AF 21 30 00 00 01 00 04 24 0A 00 A2 2E 9D 02 40 14 10 00 A4 A3 ?? ?? 08 3C ?? ?? 07 25 21 10 00 00 02 00 0A 24 02 00 04 24 12 00 09 24 04 00 E5 8C 02 00 48 24 01 00 84 24 B6 01 A0 14 01 00 42 24 00 00 E5 8C 20 24 04 7C 2B 28 A5 02 B1 01 A0 14 08 00 E7 24 F5 FF 49 54 21 50 80 00 10 00 A4 A3 14 00 08 24 23 A8 66 00 23 A8 B3 02 2B 10 13 00 23 A8 A8 02 03 00 C3 32 23 A8 A2 02 2B 18 03 00 04 00 C2 32 85 01 40 10 23 A8 A3 02 02 00 C2 32 3F 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 A0 5A 08 00 D6 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 08 00 D6 32 ?? ?? ?? 0? 20 00 B6 AF 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 80 02 21 28 00 00 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 C6 03 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 62 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 62 2A 5A 01 40 14 20 14 13 7C 12 00 02 24 10 00 A2 A3 EE FF 73 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B4 83 01 00 10 26 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 28 E0 02 ?? ?? ?? 0? 21 20 40 00 21 B8 40 00 FF FF 82 26 20 14 02 7C 21 B0 00 00 21 00 80 12 10 00 A2 A3 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 20 E0 02 ?? ?? ?? 0? 21 28 C0 02 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B4 83 27 10 02 00 2B 10 02 00 C0 18 14 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 28 C0 02 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF 82 26 20 14 02 7C 21 B0 60 00 E1 FF 80 16 10 00 A2 A3 0A 00 60 12 20 00 A8 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 20 00 A8 8F 0B FE 00 51 00 00 24 82 09 FE A0 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 15 7C 76 01 40 04 10 00 A2 32 82 00 40 10 70 00 A2 8F 70 00 AB 8F 21 B8 00 00 00 00 74 8D 04 00 6B 25 70 00 AB AF 03 00 60 16 C0 00 B6 32 25 98 97 02 01 00 73 2E 80 00 02 24 0A 01 C2 12 C0 00 02 24 2D 01 C2 12 10 00 A2 83 2A 20 53 00 FA 00 80 10 2A 20 62 02 20 14 13 7C 10 00 A2 A3 05 00 60 10 00 40 A4 32 03 00 A4 32 2B 20 04 00 23 18 64 00 00 40 A4 32 05 00 80 10 2A 28 43 00 2A 20 63 02 23 18 73 00 0A 18 04 00 2A 28 43 00 23 10 62 00 0A 10 05 00 04 00 A4 32 B8 00 80 10 20 00 A2 AF 02 00 A2 32 78 01 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A3 8F 54 00 60 14 30 00 04 24 08 00 B5 32 2C 00 B5 AF FF FF 68 26 C0 A8 08 00 40 48 17 00 21 A8 D5 03 80 40 08 00 12 00 60 12 24 00 A9 AF 80 00 0A 24 71 00 CA 12 FF FF 73 26 C0 00 0B 24 5F 00 CB 52 00 00 A6 8E 10 00 A4 83 21 28 40 02 ?? ?? ?? 0? 30 00 A8 AF 30 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F0 FF 60 16 FC FF 08 25 2C 00 A4 8F A9 FD 80 50 00 00 24 82 20 00 A5 8F A6 FD A0 58 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 20 00 A6 8F 27 10 02 00 2B 10 02 00 FF FF C6 24 20 00 A6 AF F7 FF C0 14 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 ?? ?? ?? 0? C0 00 D5 36 70 00 A9 8F 10 00 C6 32 01 00 22 81 00 00 25 8D 04 00 24 25 34 00 C0 10 10 00 A2 A3 33 00 40 50 14 00 A5 A3 FF FF 06 24 30 00 46 50 14 00 A5 A3 14 00 A2 A3 15 00 A5 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF 70 00 AA 8F F8 FF 02 24 07 00 44 25 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 38 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 21 A0 40 00 ?? ?? ?? 0? 38 00 A3 8F 21 B8 00 00 00 00 54 8C 04 00 42 24 ?? ?? ?? 0? 70 00 A2 AF 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 20 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 20 00 A4 AF A5 FF 80 10 21 80 02 02 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 20 00 A4 8F 27 10 02 00 2B 10 02 00 FF FF 84 24 20 00 A4 AF ED FF 80 14 21 80 02 02 ?? ?? ?? 0? 08 00 B5 32 14 00 A5 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A4 AF 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 30 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 30 00 A8 8F 24 00 A2 8F 27 18 08 00 20 00 04 31 04 18 62 00 06 10 14 01 25 10 62 00 06 18 17 01 0B 10 64 00 ?? ?? 03 3C 0F 00 42 30 ?? ?? 63 24 21 10 62 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 02 00 E4 2A 7A FE 80 14 ?? ?? 06 3C ?? ?? C6 24 28 00 A4 8F 00 00 C5 8C ?? ?? ?? 0? 38 00 A3 AF 8C 00 41 04 38 00 A3 8F ED FF E6 26 18 00 A6 AF 20 24 06 7C 38 00 A3 AF ?? ?? ?? 0? 34 00 A6 AF 21 28 40 00 21 20 80 02 ?? ?? ?? 0? 28 00 A2 AF ?? ?? ?? 0? 21 20 40 00 21 A8 40 00 21 A0 40 00 21 B8 00 00 38 00 A3 8F ?? ?? ?? 0? 34 00 A6 8F 20 00 A5 8F D6 00 A0 14 08 00 A7 32 08 00 A6 32 2C 00 A6 AF 02 00 A2 32 CD 00 40 50 01 00 B5 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 08 00 C7 32 0B 00 E0 14 20 00 A7 AF 0A 00 A0 1A 02 00 C2 32 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF B5 26 F9 FF A0 16 21 80 02 02 02 00 C2 32 A5 00 40 50 01 00 D6 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 ?? ?? ?? 0? 21 20 40 00 10 00 A2 A3 A8 FE 40 14 23 98 62 02 FF FF 02 24 ?? ?? ?? 0? 10 00 A2 A3 ?? ?? ?? 0? 0B 98 44 00 ?? ?? ?? 0? 10 00 AA A3 70 00 A9 8F 01 00 31 26 00 00 22 82 00 00 33 8D 04 00 29 25 ?? ?? ?? 0? 70 00 A9 AF 01 00 02 24 D8 00 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 41 04 00 02 00 02 24 02 4F 04 00 25 48 26 01 01 00 42 24 21 30 00 01 2B 40 E5 02 02 00 0A 24 10 00 0B 24 20 14 02 7C 11 00 00 15 21 38 20 01 AC 00 E5 12 2B 20 84 02 28 00 4B 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 41 04 00 02 4F 04 00 25 48 26 01 21 50 40 00 21 30 00 01 01 00 42 24 2B 40 E5 02 20 14 02 7C F1 FF 00 11 21 38 20 01 10 00 AA A3 ?? ?? ?? 0? 21 10 40 01 01 00 02 24 AE 00 E0 12 10 00 A2 A3 ?? ?? 09 3C ?? ?? 24 25 02 00 02 24 02 00 06 24 ?? ?? ?? 0? 14 00 08 24 21 30 40 00 04 00 85 8C 2B 38 E5 02 0B 00 E0 14 01 00 C6 24 06 00 B7 50 00 00 85 8C 20 14 06 7C F7 FF 48 14 08 00 84 24 ?? ?? ?? 0? 10 00 A8 A3 2B 28 85 02 FA FF A0 50 20 14 06 7C ?? ?? ?? 0? 10 00 A2 A3 EE FF E6 26 ?? ?? ?? 0? 18 00 A6 AF 18 00 A5 27 ?? ?? ?? 0? 21 20 80 02 18 00 B7 8F 03 00 04 24 0A 00 02 24 FF FF F7 26 02 B8 E4 72 1A 00 E2 02 F4 01 40 00 12 B8 00 00 00 00 E2 2A 23 B8 E2 02 23 20 17 00 ?? ?? ?? 0? 20 24 04 7C 21 20 40 00 ?? ?? ?? 0? 21 28 80 02 28 00 A2 AF ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 28 00 A4 8F 5B 00 41 04 38 00 A3 8F ?? ?? ?? 0? FF FF F7 26 70 00 A9 8F F8 FF 02 24 07 00 24 25 24 10 82 00 08 00 4A 24 70 00 AA AF 00 00 54 8C ?? ?? ?? 0? 04 00 57 8C 5C 00 40 14 ?? ?? 02 3C CC CC 02 3C CD CC 42 34 19 00 A2 02 ?? ?? 02 3C ?? ?? 45 8C ?? ?? 07 3C ?? ?? E7 24 38 00 A3 AF 30 00 A7 AF 10 48 00 00 C2 30 09 00 FF 00 C2 30 09 00 42 24 80 10 02 00 21 10 47 00 00 00 44 8C ?? ?? ?? 0? 34 00 A6 AF 34 00 A6 8F 0A 00 04 24 30 00 A7 8F 02 28 C4 70 21 20 40 00 23 30 A5 02 FF 00 C6 30 80 30 06 00 21 38 C7 00 ?? ?? ?? 0? 00 00 E5 8C 21 28 40 00 ?? ?? ?? 0? 38 00 A3 8F 93 FE 40 10 20 00 A3 8F ?? ?? ?? 0? 20 00 04 24 EF FD C0 12 20 00 04 24 ?? ?? ?? 0? 00 00 00 00 21 20 80 02 ?? ?? ?? 0? 38 00 A3 AF ?? ?? ?? 0? 38 00 A3 8F CB FD 40 10 20 00 04 24 ?? ?? ?? 0? 00 00 00 00 87 FE A0 12 FF FF 68 26 ?? ?? ?? 0? 20 00 04 24 2C FF E0 14 2C 00 A7 AF 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 20 00 A8 8F 27 10 02 00 2B 10 02 00 FF FF 08 25 20 00 A8 AF 22 FF 00 11 21 80 02 02 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 20 00 A8 8F 27 10 02 00 2B 10 02 00 FF FF 08 25 20 00 A8 AF ED FF 00 15 21 80 02 02 ?? ?? ?? 0? 02 00 A2 32 ?? ?? 02 3C ?? ?? 44 8C 28 00 A5 8F ?? ?? ?? 0? 38 00 A3 AF 01 00 42 28 21 B8 E2 02 ?? ?? ?? 0? 38 00 A3 8F 54 FF 80 10 00 00 00 00 10 00 AA A3 ?? ?? ?? 0? 21 10 40 01 ?? ?? 42 24 80 A8 15 00 21 A8 A2 02 ?? ?? 02 3C ?? ?? 45 8C 00 00 A4 8E ?? ?? ?? 0? 38 00 A3 AF 21 28 40 00 ?? ?? ?? 0? 38 00 A3 8F ?? ?? 14 3C }
	condition:
		$1
}

rule file_777_0_0 {
	meta:
		name = "_flsbuf"
		size = 324
		refs = "0060 write 0088 _bufallo"
	strings:
		$1 = { 0C 00 A2 94 E8 FF BD 27 10 00 B0 AF 40 00 43 30 14 00 BF AF 21 80 A0 00 32 00 60 14 18 00 A4 A3 02 00 43 30 38 00 60 50 30 00 42 34 10 00 A3 8C 39 00 60 14 0C 00 42 30 13 00 40 10 00 00 00 00 0C 00 02 96 0E 00 04 96 08 00 00 AE 04 00 42 34 10 00 00 AE 0C 00 02 A6 04 00 00 AE 18 00 A5 27 ?? ?? ?? 0? 01 00 06 24 01 00 03 24 22 00 43 54 0C 00 03 96 18 00 A2 93 14 00 BF 8F 10 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 00 00 00 00 FF FF 03 24 EA FF 43 10 08 00 02 AE 20 00 02 24 10 00 02 AE 01 00 03 24 08 00 02 8E 04 00 03 AE 18 00 A3 93 00 00 43 A0 08 00 05 8E 0C 00 03 96 FF FF 02 24 01 00 A5 24 20 00 64 30 EA FF 80 14 00 00 05 AE 00 02 63 34 18 00 A2 93 ?? ?? ?? 0? 0C 00 03 A6 14 00 BF 8F 20 14 04 7C 10 00 B0 8F 08 00 E0 03 18 00 BD 27 FF FF 02 24 30 00 63 34 ?? ?? ?? 0? 0C 00 03 A6 0C 00 A2 A4 04 00 A0 AC ?? ?? ?? 0? FF FF 02 24 0E 00 A4 94 04 00 06 8E ?? ?? ?? 0? 08 00 A5 8C 04 00 03 8E DE FF 43 10 01 00 03 24 0C 00 02 96 30 00 42 34 ?? ?? ?? 0? 0C 00 02 A6 }
	condition:
		$1
}

rule file_781_0_0 {
	meta:
		name = "putchar"
		size = 32
		refs = "000c fputc 0000 _iob"
	strings:
		$1 = { ?? ?? 05 3C E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_543_0_4 {
	meta:
		name = "putchar"
		size = 32
		refs = "000c fputc 0000 _Stdout"
	strings:
		$1 = { ?? ?? 05 3C E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_165_0_4 {
	meta:
		name = "putwchar"
		size = 32
		refs = "000c fputwc 0000 _Stdout"
	strings:
		$1 = { ?? ?? 05 3C E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? ?? ?? A5 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_787_0_0 {
	meta:
		name = "fputs"
		size = 120
		refs = "0024 fputc"
	strings:
		$1 = { E0 FF BD 27 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 1C 00 BF AF 21 90 80 00 21 80 A0 00 ?? ?? ?? 0? FF FF 11 24 ?? ?? ?? 0? 00 00 00 00 0C 00 51 10 1C 00 BF 8F 00 00 42 82 21 28 00 02 01 00 52 26 F8 FF 40 14 21 20 40 00 1C 00 BF 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 FF FF 02 24 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_787_1_0 {
	meta:
		name = "puts"
		size = 68
		refs = "0008 _iob 0014 fputs 0024 fputc"
	strings:
		$1 = { E0 FF BD 27 14 00 B0 AF ?? ?? 10 3C ?? ?? 05 26 1C 00 BF AF ?? ?? ?? 0? 18 00 B1 AF ?? ?? 05 26 0A 00 04 24 ?? ?? ?? 0? 21 88 40 00 1C 00 BF 8F 21 10 20 02 14 00 B0 8F 18 00 B1 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_791_0_0 {
	meta:
		name = "fread"
		size = 392
		refs = "00e4 memcpy 0118 fgetc"
	strings:
		$1 = { 0C 00 E2 94 D0 FF BD 27 14 00 B1 AF 11 00 43 30 21 88 A0 00 01 00 05 24 1C 00 B3 AF 18 00 B2 AF 2C 00 BF AF 28 00 B6 AF 24 00 B5 AF 20 00 B4 AF 10 00 B0 AF 21 98 E0 00 0E 00 65 10 21 90 C0 00 10 00 42 34 0C 00 62 A6 21 10 00 00 2C 00 BF 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 30 00 BD 27 00 02 43 30 04 00 60 10 02 A0 51 72 04 00 E3 8C EF FF 60 54 10 00 42 34 FF FD 43 30 0C 00 63 A6 ED FF 80 12 21 10 00 00 21 A8 80 00 FF FF 10 24 10 00 62 30 27 00 40 14 21 20 60 02 04 00 62 8E 18 00 40 10 00 00 00 00 10 00 65 8E 15 00 A0 10 80 00 63 30 2B B0 54 00 0A 10 96 02 21 B0 40 00 10 00 60 10 21 30 40 00 00 00 65 8E 21 20 A0 02 ?? ?? ?? 0? 23 A0 82 02 00 00 62 8E 04 00 63 8E 21 A8 B6 02 21 10 56 00 23 B0 76 00 00 00 62 AE 04 00 76 AE 10 00 80 12 FF FF 22 26 ?? ?? ?? 0? 0C 00 63 96 ?? ?? ?? 0? 00 00 00 00 20 16 02 7C 05 00 50 50 0C 00 63 96 00 00 A2 A2 FF FF 94 26 ?? ?? ?? 0? 01 00 B5 26 10 00 63 30 FB FF 60 50 00 00 A2 A2 FF FF 22 26 21 A0 54 00 1B 00 91 02 F4 01 20 02 2C 00 BF 8F 28 00 B6 8F 24 00 B5 8F 1C 00 B3 8F 14 00 B1 8F 10 00 B0 8F 12 A0 00 00 23 10 54 02 20 00 B4 8F 18 00 B2 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_800_0_0 {
	meta:
		name = "creat"
		size = 32
		refs = "000c open"
	strings:
		$1 = { E8 FF BD 27 02 00 05 24 14 00 BF AF ?? ?? ?? 0? B6 01 06 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_806_2_0 {
	meta:
		name = "_dvfprintf_gG"
		size = 5884
		refs = "009c _ctype 01a8 fputc 03d0 dpcmp 043c dpadd 04c0 dpdiv 04cc __fixunsdfdi 05e0 __udivdi3 05f4 __umoddi3 06bc dpmul 09f4 dptoul 0c5c __floatundidf 0c74 dpsub 0f4c frexp 127c __floatunsidf"
		altNames = "_dvfprintf_gGs"
	strings:
		$1 = { 98 FF BD 27 4C 00 B3 AF 44 00 B1 AF 40 00 B0 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 54 00 B5 AF 50 00 B4 AF 48 00 B2 AF 21 98 80 00 21 88 A0 00 70 00 A6 AF 28 00 A0 AF 2C 00 A0 AF 21 80 00 00 00 00 24 82 40 00 80 10 10 00 A4 A3 25 00 02 24 54 00 82 14 01 00 32 26 02 00 23 26 FF FF 62 80 2D 00 05 24 21 A8 00 00 30 00 07 24 20 00 06 24 2B 00 08 24 48 00 45 10 FF FF 71 24 2E 00 44 28 3E 00 80 10 00 00 00 00 50 00 46 50 01 00 B5 36 4C 00 48 50 02 00 B5 36 ?? ?? 04 3C ?? ?? 83 24 21 20 62 00 01 00 84 90 02 00 A6 32 FE FF A5 32 0B A8 A6 00 08 00 A6 32 FB FF A5 32 04 00 84 30 44 00 80 10 0B A8 A6 00 21 F0 00 00 0A 00 05 24 02 20 C5 73 01 00 31 26 21 F0 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF DE 27 2E 00 04 24 42 00 44 50 01 00 31 26 00 10 B5 36 21 90 00 00 6C 00 03 24 10 00 05 24 00 80 04 24 10 00 A2 A3 6A 02 43 10 01 00 31 26 6D 00 43 28 4C 00 60 10 75 00 03 24 63 00 03 24 6B 02 43 10 64 00 43 28 8C 00 60 50 67 00 03 24 97 02 40 14 47 00 03 24 64 00 BF 8F 21 10 00 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 C7 FF 47 14 ?? ?? 04 3C 04 00 B5 36 01 00 63 24 FF FF 62 80 BA FF 45 14 FF FF 71 24 08 00 B5 36 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 40 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 63 24 ?? ?? ?? 0? 01 00 63 24 2A 00 04 24 C6 FF 44 14 21 F0 00 00 70 00 A5 8F 01 00 31 26 00 00 22 82 00 00 BE 8C 2E 00 04 24 04 00 A5 24 C1 FF 44 14 70 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 29 03 44 10 00 40 B5 36 21 20 62 00 01 00 84 90 21 90 00 00 04 00 84 30 B8 FF 80 10 0A 00 05 24 02 20 45 72 01 00 31 26 21 90 82 00 00 00 22 82 21 20 62 00 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 52 26 ?? ?? ?? 0? 6C 00 03 24 35 02 43 10 78 00 03 24 31 02 43 10 73 00 03 24 32 00 43 10 70 00 A2 8F 10 00 B4 27 01 00 17 24 04 00 40 52 2B 90 FE 02 2B 10 57 02 0B B8 42 02 2B 90 FE 02 23 F0 D7 03 0A F0 12 00 08 00 B6 32 0C 00 C0 16 21 90 C0 03 ?? ?? ?? 0? FF FF 15 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 55 16 21 28 60 02 ?? ?? ?? 0? FF FF 15 24 00 00 84 82 ?? ?? ?? 0? 01 00 94 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F5 16 21 28 60 02 52 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 00 00 00 00 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 52 26 20 00 04 24 F8 FF 54 16 21 28 60 02 ?? ?? ?? 0? 00 00 24 82 00 00 43 8C 04 00 44 24 5E 04 60 10 21 A0 60 00 00 00 62 80 06 00 40 10 21 B8 00 00 01 00 F7 26 21 10 77 00 00 00 42 80 FD FF 40 54 01 00 F7 26 ?? ?? ?? 0? 70 00 A4 AF C1 FF 43 14 10 00 B4 27 00 02 B5 36 00 07 A2 32 16 01 40 10 21 B0 A0 02 00 10 A4 32 06 00 03 24 10 00 A2 32 C2 01 40 10 0B 90 64 00 70 00 A4 8F F8 FF 02 24 07 00 83 24 24 10 62 00 00 00 46 8C 04 00 54 8C 08 00 45 24 70 00 A5 AF 20 00 A6 AF 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 04 00 41 04 20 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 B6 36 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF CE 02 40 14 21 B8 00 00 00 02 C2 32 65 01 40 14 FC FF E2 2A 19 00 42 2A 0C 00 40 10 18 00 A8 8F ?? ?? ?? 0? FF 00 44 32 20 00 A6 8F 21 28 80 02 21 38 60 00 21 20 C0 00 ?? ?? ?? 0? 21 30 40 00 20 00 A2 AF 21 A0 60 00 18 00 A8 8F 0A 00 02 29 BE 01 40 14 20 00 A3 8F 28 00 A3 8F 2C 00 A2 8F 3C 00 A8 AF 21 20 60 00 ?? ?? 03 3C ?? ?? 63 24 00 00 66 8C 04 00 67 8C ?? ?? ?? 0? 21 28 40 00 BE 03 41 04 3C 00 A8 8F ED FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 3C 00 A8 AF 2C 00 A3 AF 20 00 A6 8F 21 18 40 00 28 00 A2 AF 2C 00 A2 8F 21 20 C0 00 21 28 80 02 21 30 60 00 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 3C 00 A8 8F 21 B8 40 00 21 A8 60 00 20 00 A0 AF 24 00 A0 AF 01 00 02 24 72 04 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 04 24 ?? ?? ?? 0? 12 00 09 24 21 50 80 00 04 00 65 8C 02 00 47 24 01 00 84 24 2B 30 A5 02 B9 02 C0 14 01 00 42 24 B4 02 B5 50 00 00 65 8C 20 24 04 7C F5 FF 49 14 08 00 63 24 10 00 A4 A3 14 00 07 24 23 A0 C8 03 23 A0 92 02 2B 10 12 00 23 A0 87 02 03 00 C3 32 23 A0 82 02 2B 18 03 00 04 00 C2 32 5A 02 40 10 23 A0 83 02 02 00 C2 32 AD 03 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 1A 08 00 DE 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 DE 32 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 96 24 04 00 C7 8C ?? ?? ?? 0? 00 00 C6 8C 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 21 20 E0 02 21 28 A0 02 FF FF 43 24 20 1C 03 7C C0 30 03 00 21 30 C6 02 EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 42 2A 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 42 2A 96 03 40 14 20 14 12 7C 12 00 02 24 10 00 A2 A3 EE FF 52 26 2E 00 04 24 ?? ?? ?? 0? 21 28 60 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 21 20 40 00 21 28 60 00 24 00 A2 8F 20 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 27 00 A0 12 10 00 A2 A3 ?? ?? 05 3C ?? ?? B5 24 21 40 60 00 21 B8 C0 02 C0 10 02 00 21 10 A2 02 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 60 02 10 00 B6 83 3C 00 A8 8F 27 10 02 00 C0 18 16 00 21 18 A3 02 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 21 80 02 02 21 B8 40 00 FF FF C2 26 20 14 02 7C 21 40 60 00 DF FF C0 16 10 00 A2 A3 09 00 40 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 28 FE C0 53 00 00 24 82 26 FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 16 15 7C 0C 02 40 04 10 00 A2 32 D4 00 40 10 70 00 A5 8F 70 00 A4 8F 21 B8 00 00 00 00 94 8C 04 00 84 24 70 00 A4 AF 03 00 40 16 C0 00 B6 32 25 90 97 02 01 00 52 2E 80 00 02 24 82 01 C2 12 C0 00 02 24 6B 01 C2 12 10 00 A2 83 2A 18 52 00 66 01 60 10 2A 18 42 02 20 14 12 7C 10 00 A2 A3 05 00 C0 13 00 40 A3 32 03 00 A3 32 2B 18 03 00 23 F0 C3 03 00 40 A3 32 05 00 60 10 2A 20 5E 00 2A 18 5E 02 23 F0 D2 03 0A F0 03 00 2A 20 5E 00 23 10 C2 03 0A 10 04 00 04 00 A3 32 40 01 60 10 20 00 A2 AF 02 00 A2 32 EC 01 40 10 01 00 A2 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 20 00 A6 8F 0C 00 C0 50 08 00 B5 32 20 00 BE 8F 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 20 00 BE AF 08 00 B5 32 24 00 B5 AF FF FF 48 26 C0 10 08 00 ?? ?? 05 3C 80 40 08 00 13 00 00 01 ?? ?? B5 24 40 18 17 00 21 40 40 02 30 00 B1 AF 21 A8 A2 02 80 00 1E 24 21 88 60 00 11 00 00 11 12 90 00 00 06 01 DE 12 FF FF 08 25 C0 00 06 24 F4 00 C6 52 00 00 A6 8E 10 00 A4 83 21 28 60 02 ?? ?? ?? 0? 3C 00 A8 AF 3C 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF B5 26 F1 FF 00 15 FC FF 52 26 24 00 A4 8F B5 FD 80 10 30 00 B1 8F 20 00 A5 8F B2 FD A0 18 21 90 A0 00 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 52 26 F9 FF 40 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 87 00 40 10 2A 10 F2 02 71 02 40 12 21 10 00 00 FF FF 52 26 13 00 42 2E 6C 02 40 14 12 00 02 24 10 00 A2 A3 20 00 A3 8F 21 28 80 02 21 30 00 00 21 20 60 00 ?? ?? ?? 0? 21 38 00 00 14 02 40 14 10 00 AA 83 20 00 A2 8F 21 28 80 02 ?? ?? ?? 0? 21 20 40 00 18 00 B7 8F 20 00 A2 AF ?? ?? 02 3C ?? ?? 55 24 FB FF D4 27 03 00 C2 32 63 00 E3 26 2B 10 02 00 23 A0 92 02 C7 00 63 2C 23 A0 82 02 01 00 63 2C 04 00 C2 32 96 01 40 10 23 A0 83 02 02 00 C2 32 9B 02 40 10 01 00 C2 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 21 80 02 02 17 03 80 1A 08 00 C3 32 30 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 C4 32 ?? ?? ?? 0? 24 00 A4 AF 70 00 A2 8F 07 00 43 24 F8 FF 02 24 24 10 62 00 00 00 43 8C 04 00 54 8C 08 00 42 24 20 00 A3 AF ?? ?? ?? 0? 70 00 A2 AF 10 00 A2 32 21 30 80 00 0A 30 A2 00 25 A8 D5 00 FF FF B5 32 ?? ?? ?? 0? 00 00 22 82 70 00 A3 8F 10 00 A5 32 01 00 62 80 00 00 64 8C 04 00 63 24 2E 00 A0 10 10 00 A2 A3 2D 00 40 50 14 00 A4 A3 FF FF 05 24 2A 00 45 50 14 00 A4 A3 14 00 A2 A3 15 00 A4 A3 02 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF ?? ?? ?? 0? 80 00 B5 36 ?? ?? ?? 0? C0 00 B5 36 21 B8 00 00 00 00 B4 8C 04 00 A5 24 ?? ?? ?? 0? 70 00 A5 AF 21 28 80 02 21 30 00 00 21 20 60 00 21 38 00 00 ?? ?? ?? 0? 3C 00 A8 AF 1D 02 40 10 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 B8 40 00 25 10 43 00 21 A8 60 00 1A 02 40 14 3C 00 A8 8F 02 00 02 29 32 FE 40 10 28 00 A3 8F ?? ?? ?? 0? 21 20 E0 02 B4 FD 43 14 10 00 B4 27 ?? ?? ?? 0? 20 00 B5 36 14 00 A4 A3 01 00 17 24 14 00 B4 27 ?? ?? ?? 0? 70 00 A3 AF 79 FF 40 10 00 00 00 00 AE 02 E0 06 20 00 A3 8F 21 28 80 02 ?? ?? ?? 0? 21 20 60 00 21 B8 40 00 21 A8 60 00 25 10 F5 02 0F 00 40 10 21 30 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 13 00 07 24 04 00 64 8C 01 00 42 24 2B 28 A4 02 06 00 A0 14 21 30 40 00 37 02 95 50 00 00 64 8C F8 FF 47 14 08 00 63 24 14 00 06 24 23 90 46 02 19 00 42 2A D4 01 40 14 00 00 00 00 ?? ?? ?? 0? 21 20 40 02 21 40 40 00 21 48 60 00 21 20 E0 02 21 28 A0 02 3C 00 A8 AF ?? ?? ?? 0? 38 00 A9 AF 20 00 A7 8F 21 28 80 02 21 30 40 00 21 20 E0 00 ?? ?? ?? 0? 21 38 60 00 3C 00 A8 8F 38 00 A9 8F 21 20 40 00 21 28 60 00 21 30 00 01 ?? ?? ?? 0? 21 38 20 01 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 28 A0 02 21 20 E0 02 0A 00 06 24 E4 FD 40 12 21 38 00 00 ?? ?? ?? 0? 00 00 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 21 38 00 00 21 B8 40 00 ?? ?? ?? 0? 21 A8 60 00 25 10 43 00 F0 FF 40 50 FF FF 52 26 18 00 A8 8F 0A 00 02 29 D9 FD 40 50 28 00 A3 8F ?? ?? ?? 0? 20 00 A3 8F 04 00 A7 8E 21 20 80 02 21 28 E0 02 ?? ?? ?? 0? 3C 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 20 24 02 7C 10 00 A4 A3 ?? ?? ?? 0? 3C 00 A8 8F 27 18 12 00 04 18 71 00 06 10 54 02 20 00 44 32 25 10 62 00 06 18 57 02 0B 10 64 00 ?? ?? 03 3C 0F 00 42 30 ?? ?? 63 24 21 10 62 00 00 00 44 80 ?? ?? ?? 0? 10 00 A4 A3 20 00 A2 8F B5 00 40 14 08 00 A4 32 08 00 A3 32 24 00 A3 AF 02 00 A2 32 AC 00 40 50 01 00 B5 32 01 00 A4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 ?? ?? ?? 0? 0B 90 43 00 01 00 02 24 44 02 E0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 02 00 06 24 02 00 02 24 ?? ?? ?? 0? 14 00 07 24 21 30 40 00 04 00 64 8C 01 00 42 24 2B 28 E4 02 BA 01 A0 14 20 14 02 7C B5 01 97 50 00 00 64 8C F7 FF 47 14 08 00 63 24 ?? ?? ?? 0? 10 00 A2 A3 01 00 02 24 2A 02 E0 12 10 00 A2 A3 00 01 04 24 21 28 00 00 00 31 05 00 00 19 04 00 02 00 02 24 02 47 04 00 25 40 06 01 01 00 42 24 21 30 60 00 2B 18 E5 02 02 00 09 24 10 00 0A 24 20 14 02 7C 11 00 60 14 21 38 00 01 75 01 E5 52 2B 20 84 02 E9 FF 4A 10 21 20 C0 00 21 28 E0 00 00 31 05 00 00 19 04 00 02 47 04 00 25 40 06 01 21 48 40 00 21 30 60 00 01 00 42 24 2B 18 E5 02 20 14 02 7C F1 FF 60 10 21 38 00 01 10 00 A9 A3 ?? ?? ?? 0? 21 10 20 01 70 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D2 8C 04 00 C6 24 ?? ?? ?? 0? 70 00 A6 AF 08 00 DE 32 0C 00 C0 17 02 00 C2 32 0A 00 80 1A 00 00 00 00 20 00 04 24 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 02 00 C2 32 30 01 40 50 01 00 D6 32 01 00 C4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 20 00 A3 8F 21 28 80 02 18 00 A6 27 ?? ?? ?? 0? 21 20 60 00 18 00 B7 8F 03 00 03 24 0A 00 02 24 FF FF F7 26 02 B8 E3 72 1A 00 E2 02 F4 01 40 00 12 B8 00 00 CD 01 E0 06 18 00 B7 AF ?? ?? ?? 0? 23 20 17 00 21 28 60 00 20 00 A3 8F 21 20 40 00 21 38 80 02 ?? ?? ?? 0? 21 30 60 00 2C 00 A3 AF ?? ?? 06 3C 21 18 40 00 28 00 A2 AF 2C 00 A2 8F ?? ?? C7 8C ?? ?? C6 8C 21 20 60 00 ?? ?? ?? 0? 21 28 40 00 1D 01 42 04 FF FF F7 26 ?? ?? 06 3C 28 00 A3 8F 2C 00 A2 8F ?? ?? C4 8C ?? ?? C5 8C 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 08 FD 40 1C 00 02 C2 32 01 00 F7 26 ?? ?? ?? 0? 18 00 B7 AF }
	condition:
		$1
}

rule file_807_0_0 {
	meta:
		name = "strlen"
		size = 28
	strings:
		$1 = { 21 18 80 00 00 00 65 80 FE FF A0 14 01 00 63 24 27 10 04 00 08 00 E0 03 21 10 62 00 }
	condition:
		$1
}

rule file_829_2_0 {
	meta:
		name = "_vfprintf_cdeEgGnopuxX"
		size = 6544
		refs = "000c _ctype 0160 fputc 0464 __floatdisf 0484 fpcmp 04fc fpadd 0554 fpdiv 055c fptoui 0690 __udivdi3 06a4 __umoddi3 074c fpmul 0ec8 __floatunsisf 0ed4 fpsub 0f7c frexpf 117c __floatundisf"
		altNames = "_vfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { 90 FF BD 27 64 00 B7 AF 21 10 00 00 ?? ?? 17 3C 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 68 00 BE AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 21 90 80 00 21 88 A0 00 78 00 A6 AF 34 00 A2 AF 21 80 00 00 ?? ?? F7 26 00 00 24 82 65 00 80 10 10 00 A4 A3 25 00 02 24 AB 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 9F 02 46 10 FF FF 91 24 2E 00 45 28 95 02 A0 10 00 00 00 00 A7 02 47 50 01 00 63 34 A3 02 49 50 02 00 63 34 21 20 E2 02 01 00 84 90 02 00 66 30 FE FF 65 30 0B 18 A6 00 08 00 66 30 FB FF 65 30 04 00 84 30 9D 02 80 10 0B 18 A6 00 21 40 00 00 0A 00 05 24 02 20 05 71 01 00 31 26 21 40 82 00 00 00 22 82 21 20 E2 02 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 08 25 2E 00 04 24 9B 02 44 50 01 00 31 26 00 10 63 34 21 98 00 00 10 00 07 24 00 80 06 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3E 00 A0 14 01 00 31 26 10 00 B5 27 01 00 1E 24 04 00 60 52 2B 98 C8 03 2B 10 7E 02 0B F0 62 02 2B 98 C8 03 23 40 1E 01 0A 40 13 00 08 00 76 30 0B 00 C0 16 21 98 00 01 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF DE 27 F8 FF D4 57 00 00 A4 82 A8 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9D FF 80 14 10 00 A4 A3 6C 00 BF 8F 21 10 00 02 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 ?? ?? 05 3C 80 20 04 00 ?? ?? A5 24 21 20 A4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 00 63 34 00 07 62 30 15 01 40 10 20 00 A3 AF 00 10 65 30 06 00 04 24 10 00 62 30 6A 02 40 10 0B 98 85 00 78 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 44 8C 04 00 45 8C 08 00 42 24 3C 00 A3 AF 40 00 A8 AF ?? ?? ?? 0? 78 00 A2 AF 3C 00 A3 8F 40 00 A8 8F 21 A0 40 00 21 20 80 02 21 28 00 00 3C 00 A3 AF ?? ?? ?? 0? 40 00 A8 AF 3C 00 A3 8F 05 00 41 04 40 00 A8 8F 00 80 02 3C 03 00 63 34 26 A0 54 00 20 00 A3 AF 21 20 80 02 21 28 00 00 40 00 A8 AF ?? ?? ?? 0? 18 00 A0 AF 21 B0 00 00 AD 02 40 14 40 00 A8 8F 20 00 A3 8F 00 01 62 30 BD 01 40 14 00 02 62 30 B9 01 40 14 FC FF C2 2A 19 00 62 2A 0A 00 40 10 18 00 BE 8F FF 00 64 32 ?? ?? ?? 0? 40 00 A8 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 40 00 A8 8F 21 A0 40 00 18 00 BE 8F 0A 00 C2 2B DD 02 40 14 21 20 80 02 ?? ?? 02 3C ?? ?? 45 8C 34 00 A4 8F ?? ?? ?? 0? 40 00 A8 AF 9C 04 40 04 40 00 A8 8F EE FF DE 27 18 00 BE AF 20 24 1E 7C ?? ?? ?? 0? 40 00 A8 AF 21 28 40 00 21 20 80 02 ?? ?? ?? 0? 34 00 A2 AF ?? ?? ?? 0? 21 20 40 00 40 00 A8 8F 21 20 00 00 21 B0 40 00 21 A8 40 00 28 00 A4 AF 01 00 03 24 0A 00 C2 2E EF 04 40 14 10 00 A3 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 09 24 02 00 04 24 ?? ?? ?? 0? 12 00 07 24 21 48 80 00 04 00 65 8C CA 04 A0 14 02 00 46 24 00 00 65 8C 2B 28 C5 02 C6 04 A0 14 01 00 84 24 01 00 42 24 20 24 04 7C F5 FF 47 14 08 00 63 24 10 00 A4 A3 14 00 06 24 20 00 A5 8F 23 A0 1E 01 23 A0 93 02 2B 10 13 00 23 A0 86 02 03 00 A3 30 23 A0 82 02 2B 18 03 00 04 00 A2 30 98 04 40 10 23 A0 83 02 02 00 A2 30 B4 04 40 10 20 00 A7 8F 01 00 A4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 C2 04 80 1A 20 00 A2 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A3 8F 08 00 63 30 24 00 A3 AF ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 56 24 C0 18 03 00 21 18 C3 02 00 00 66 8C 04 00 67 8C 21 20 A0 02 ?? ?? ?? 0? 21 28 00 00 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0C 00 40 18 13 00 62 2A 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 62 2A 4E 04 40 14 20 14 13 7C 12 00 02 24 10 00 A2 A3 EE FF 73 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B5 83 01 00 10 26 ?? ?? ?? 0? 21 20 A0 02 28 00 A5 8F ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 20 40 00 21 B0 40 00 FF FF A2 26 20 14 02 7C 21 40 00 00 25 00 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 7E 24 C0 10 02 00 21 10 C2 03 00 00 46 8C 04 00 47 8C 21 28 00 01 21 20 C0 02 ?? ?? ?? 0? 40 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B5 83 40 00 A8 8F 27 10 02 00 C0 18 15 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 28 00 01 21 20 C0 02 ?? ?? ?? 0? 21 80 02 02 21 B0 40 00 FF FF A2 26 20 14 02 7C 21 40 60 00 DF FF A0 16 10 00 A2 A3 0A 00 60 12 24 00 A4 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 24 00 A4 8F 07 FE 80 50 00 00 24 82 05 FE 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 63 34 00 01 63 34 00 07 62 30 ED FE 40 14 20 00 A3 AF C0 00 62 30 5D 01 40 14 20 16 03 7C B1 03 40 04 78 00 A7 8F 10 00 62 30 DC 01 40 10 78 00 A5 8F 78 00 A2 8F 00 00 44 8C 04 00 42 24 78 00 A2 AF C3 17 04 00 21 A8 80 00 21 B0 40 00 05 00 41 04 23 10 02 00 23 A8 04 00 2B 20 15 00 03 00 63 34 23 B0 44 00 03 00 60 16 C0 00 74 30 25 98 B6 02 01 00 73 2E 40 00 02 24 17 03 82 12 41 00 82 2A F1 02 40 10 80 00 02 24 16 00 80 16 10 00 A2 83 01 00 02 24 19 04 C0 12 10 00 A2 A3 ?? ?? 04 3C ?? ?? 84 24 02 00 07 24 02 00 02 24 ?? ?? ?? 0? 14 00 09 24 21 38 40 00 04 00 85 8C 2B 30 C5 02 96 03 C0 54 10 00 A7 A3 90 03 B6 50 00 00 85 8C 01 00 42 24 20 14 02 7C F6 FF 49 14 08 00 84 24 10 00 A2 A3 2A 20 53 00 D5 02 80 10 2A 20 62 02 20 14 13 7C 10 00 A2 A3 05 00 00 11 00 40 64 30 03 00 64 30 2B 20 04 00 23 40 04 01 00 40 64 30 05 00 80 10 2A 28 48 00 2A 20 68 02 23 40 13 01 0A 40 04 00 2A 28 48 00 23 10 02 01 0A 10 05 00 04 00 64 30 93 02 80 10 20 00 A2 AF 02 00 62 30 E1 02 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 27 10 02 00 3C 00 A3 8F 2B 10 02 00 21 80 02 02 20 00 A4 8F 08 00 62 30 12 02 80 14 30 00 A2 AF FF FF 62 26 ?? ?? 07 3C C0 98 02 00 ?? ?? FE 24 21 98 D3 03 03 00 1E 24 80 40 02 00 02 F0 5E 70 41 00 84 2A 40 10 16 00 20 00 63 30 28 00 A2 AF 24 00 A4 AF ?? ?? ?? 0? 2C 00 A3 AF 10 00 80 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 A0 02 21 28 C0 02 ?? ?? ?? 0? 40 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 40 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 40 00 A8 AF 40 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF DE 27 FD FF 02 24 42 02 C2 13 40 00 02 24 34 02 82 12 24 00 A5 8F DF FF A0 14 80 00 02 24 1D 02 82 12 C0 00 02 24 DD FF 82 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 63 34 ?? ?? ?? 0? 80 00 63 34 20 00 63 34 ?? ?? ?? 0? 00 02 63 34 70 FD 48 54 21 20 E2 02 04 00 63 34 01 00 84 24 FF FF 82 80 63 FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 04 24 6D FD 44 14 21 40 00 00 78 00 A5 8F 01 00 31 26 00 00 22 82 00 00 A8 8C 2E 00 04 24 04 00 A5 24 68 FD 44 14 78 00 A5 AF 01 00 31 26 00 00 22 82 2A 00 04 24 91 02 44 10 00 40 63 34 21 20 E2 02 01 00 84 90 21 98 00 00 04 00 84 30 5F FD 80 10 0A 00 05 24 02 20 65 72 01 00 31 26 21 98 82 00 00 00 22 82 21 20 E2 02 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 73 26 ?? ?? ?? 0? 10 00 07 24 4A 01 40 10 2A 10 D3 02 E9 00 60 12 21 10 00 00 20 00 A4 8F 40 02 82 7C 23 98 62 02 13 00 62 2E E2 00 40 14 12 00 02 24 10 00 A2 A3 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 40 00 A8 AF A5 00 40 14 40 00 A8 8F ?? ?? ?? 0? 21 20 80 02 40 00 A8 8F ?? ?? 05 3C 21 A8 40 00 ?? ?? BE 24 20 00 A5 8F FB FF 14 25 23 A0 93 02 03 00 A3 30 2B 18 03 00 04 00 A2 30 7A 00 40 10 23 A0 83 02 02 00 A2 30 F8 00 40 10 20 00 A7 8F 01 00 A4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 30 03 80 1A 20 00 A2 8F 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A3 8F 08 00 63 30 28 00 A3 AF 10 00 A2 83 21 20 A0 02 21 28 00 00 C0 10 02 00 21 10 C2 03 00 00 46 8C ?? ?? ?? 0? 04 00 47 8C 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 27 10 02 00 2B 10 02 00 C0 18 03 00 21 18 C3 03 00 00 66 8C 04 00 67 8C 21 20 A0 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A8 40 00 3A 02 60 16 21 B0 60 00 20 00 A3 8F 20 00 62 30 02 00 40 14 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 75 02 40 04 23 10 02 00 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 0A 00 13 24 21 28 40 02 1A 00 53 00 F4 01 60 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 73 00 F4 01 60 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 21 80 02 02 28 00 A2 8F A8 FC 40 50 00 00 24 82 A6 FC 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 78 00 A4 8F 00 00 94 8C 04 00 84 24 ?? ?? ?? 0? 78 00 A4 AF 4C 02 40 04 10 00 62 30 7C 00 40 10 78 00 A7 8F 78 00 A5 8F 21 B0 00 00 00 00 B5 8C 04 00 A5 24 ?? ?? ?? 0? 78 00 A5 AF 20 00 A4 8F 08 00 84 30 0B 00 80 14 28 00 A4 AF 0A 00 80 1A 20 00 A5 8F 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 20 00 A5 8F 02 00 A2 30 85 00 40 50 20 00 A7 8F 01 00 A4 30 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 10 00 A3 83 40 00 A8 AF 23 20 C3 02 20 24 04 7C ?? ?? ?? 0? 3C 00 A3 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 21 20 40 00 ?? ?? ?? 0? 38 00 A2 AF 21 28 40 00 ?? ?? ?? 0? 21 20 80 02 ?? ?? 07 3C ?? ?? E7 24 00 00 E4 8C ?? ?? ?? 0? 21 28 40 00 3C 00 A3 8F 38 00 A6 8F 0B 00 40 1C 40 00 A8 8F ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 21 20 80 02 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 40 00 A8 8F 3C 00 A3 8F 21 30 40 00 ?? ?? 04 3C 01 00 62 24 ?? ?? 9E 24 C0 10 02 00 21 10 C2 03 04 00 44 8C 3D 00 80 10 21 A8 C0 00 C0 18 03 00 21 18 C3 03 04 00 62 8C 16 02 40 50 00 00 62 8C ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? FF FF D6 26 21 10 60 02 ?? ?? ?? 0? 10 00 A2 A3 21 20 80 02 ?? ?? ?? 0? 18 00 A5 27 18 00 B6 8F 03 00 03 24 0A 00 02 24 FF FF D6 26 02 B0 C3 72 40 00 A8 8F 1A 00 C2 02 F4 01 40 00 12 B0 00 00 13 02 C0 06 18 00 B6 AF 23 20 16 00 20 24 04 7C ?? ?? ?? 0? 40 00 A8 AF 21 20 40 00 ?? ?? ?? 0? 21 28 80 02 34 00 A2 AF ?? ?? 02 3C ?? ?? 45 8C ?? ?? ?? 0? 34 00 A4 8F 38 00 41 04 40 00 A8 8F FF FF D6 26 ?? ?? ?? 0? 18 00 B6 AF 21 B0 00 00 00 00 F5 8C 04 00 E7 24 }
	condition:
		$1
}

rule file_830_0_0 {
	meta:
		name = "clock"
		size = 28
		refs = "0008 time"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 21 20 00 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_837_0_0 {
	meta:
		name = "strspn"
		size = 108
		refs = "0040 strchr"
	strings:
		$1 = { E0 FF BD 27 18 00 B2 AF 14 00 B1 AF 10 00 B0 AF 1C 00 BF AF 00 00 82 80 21 88 80 00 21 80 A0 00 05 00 40 14 21 90 00 00 ?? ?? ?? 0? 1C 00 BF 8F 07 00 40 10 01 00 52 26 21 28 40 00 21 20 00 02 ?? ?? ?? 0? 01 00 31 26 F9 FF 40 54 00 00 22 82 1C 00 BF 8F 21 10 40 02 14 00 B1 8F 18 00 B2 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_838_0_0 {
	meta:
		name = "strdup"
		size = 68
		refs = "000c strlen 0014 malloc 0028 strcpy"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF 18 00 B0 AF ?? ?? ?? 0? 10 00 A4 AF ?? ?? ?? 0? 01 00 44 24 21 80 40 00 03 00 40 10 10 00 A5 8F ?? ?? ?? 0? 21 20 40 00 1C 00 BF 8F 21 10 00 02 18 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_844_0_0 {
	meta:
		name = "_swap"
		size = 44
	strings:
		$1 = { 08 00 80 10 21 20 A4 00 00 00 C3 90 00 00 A2 80 00 00 A3 A0 01 00 A5 24 00 00 C2 A0 FA FF A4 14 01 00 C6 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_861_0_0 {
	meta:
		name = "fputc"
		size = 316
		refs = "0080 _outdone 00e0 fputc 00fc fflush 0118 fseek 012c _flsbuf"
	strings:
		$1 = { 0C 00 A2 94 E0 FF BD 27 18 00 B1 AF 02 00 43 30 14 00 B0 AF 1C 00 BF AF 21 80 A0 00 1F 00 60 10 FF FF 11 24 00 02 43 30 22 00 60 10 04 00 A3 8C 00 02 42 34 0C 00 A2 A4 22 00 60 10 FF 00 91 30 00 0C 44 30 00 0C 03 24 32 00 83 10 21 20 00 02 FF F7 42 30 0A 00 03 24 1D 00 23 12 0C 00 02 A6 04 00 02 8E 10 00 03 8E 2F 00 43 10 01 00 42 24 00 00 03 8E 04 00 02 AE 01 00 64 24 00 00 71 A0 ?? ?? 02 3C 01 00 03 24 00 00 04 AE ?? ?? 43 A0 0A 00 02 24 16 00 22 52 0C 00 02 96 1C 00 BF 8F 21 10 20 02 14 00 B0 8F 18 00 B1 8F 08 00 E0 03 20 00 BD 27 F9 FF 60 14 00 02 42 34 0C 00 A2 A4 FF 00 91 30 08 00 03 8E ?? ?? ?? 0? 00 00 03 AE 80 00 42 30 E3 FF 40 54 04 00 02 8E 0D 00 04 24 ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 04 00 02 8E 00 01 42 30 EA FF 40 10 1C 00 BF 8F ?? ?? ?? 0? 21 20 00 02 27 10 02 00 FF FF 03 24 ?? ?? ?? 0? 0A 88 62 00 21 28 00 00 ?? ?? ?? 0? 02 00 06 24 ?? ?? ?? 0? 0C 00 02 96 20 24 11 7C ?? ?? ?? 0? 21 28 00 02 ?? ?? ?? 0? 21 88 40 00 }
	condition:
		$1
}

rule file_881_0_0 {
	meta:
		name = "_dump_heap_info"
		size = 384
		refs = "0008 __alloct 0014 __allocs 0040 _heap 0044 _min_heap_size 0050 _iob 00cc _fprintf_cdnopsuxX 011c fprintf"
	strings:
		$1 = { A8 FF BD 27 44 00 B5 AF ?? ?? 15 3C ?? ?? A2 8E 34 00 B1 AF ?? ?? 11 3C ?? ?? 31 26 54 00 BF AF 50 00 BE AF 4C 00 B7 AF 48 00 B6 AF 40 00 B4 AF 3C 00 B3 AF 38 00 B2 AF 4C 00 51 10 30 00 B0 AF ?? ?? 16 3C ?? ?? 14 3C ?? ?? D6 26 ?? ?? 94 26 ?? ?? 02 3C 21 A0 D4 02 1C 00 A2 AF 18 00 A0 AF 21 80 00 00 FC FF 89 26 ?? ?? 48 24 ?? ?? 03 3C ?? ?? 1E 3C ?? ?? 17 3C 2A 20 36 02 2A 10 91 02 1B 00 80 14 00 00 32 8E 23 20 91 02 26 28 49 02 23 98 51 02 0A 98 85 00 ?? ?? EA 26 ?? ?? CB 27 21 30 20 02 21 20 00 01 ?? ?? 65 24 10 00 40 14 21 38 60 02 04 00 22 92 28 00 A3 AF 24 00 A8 AF 01 00 42 30 0A 50 62 01 20 00 A9 AF ?? ?? ?? 0? 10 00 AA AF 04 00 22 92 28 00 A3 8F 24 00 A8 8F 01 00 42 30 1B 00 40 10 20 00 A9 8F 21 80 13 02 04 00 40 12 ?? ?? A2 8E ?? ?? A2 8E DE FF 52 14 21 88 40 02 1C 00 A3 8F 18 00 A7 8F ?? ?? 05 3C 21 30 00 02 ?? ?? 64 24 ?? ?? A5 24 ?? ?? ?? 0? 10 00 A2 AF 54 00 BF 8F 50 00 BE 8F 4C 00 B7 8F 48 00 B6 8F 44 00 B5 8F 40 00 B4 8F 3C 00 B3 8F 38 00 B2 8F 34 00 B1 8F 30 00 B0 8F 08 00 E0 03 58 00 BD 27 18 00 A2 8F 21 10 53 00 E6 FF 40 16 18 00 A2 AF ?? ?? ?? 0? ?? ?? A2 8E ?? ?? 03 3C 18 00 A0 AF 21 80 00 00 ?? ?? ?? 0? 1C 00 A3 AF }
	condition:
		$1
}

rule file_884_0_0 {
	meta:
		name = "xtoi"
		size = 296
		refs = "0020 _ctype 00d4 tolower"
	strings:
		$1 = { D8 FF BD 27 1C 00 B2 AF 18 00 B1 AF 24 00 BF AF 20 00 B3 AF 14 00 B0 AF 21 90 80 00 00 00 84 80 ?? ?? 11 3C ?? ?? 31 26 21 10 24 02 01 00 42 80 88 00 42 30 09 00 40 10 2D 00 02 24 01 00 52 26 00 00 44 82 21 10 24 02 01 00 42 80 88 00 42 30 FB FF 40 54 01 00 52 26 2D 00 02 24 2B 00 82 10 2B 00 02 24 2D 00 82 10 21 80 00 00 21 10 24 02 01 00 42 90 44 00 43 30 1A 00 60 10 21 98 00 00 ?? ?? ?? 0? 01 00 52 26 21 10 24 02 01 00 42 90 A9 FF 83 24 04 00 42 30 02 00 40 10 D0 FF 84 24 21 18 80 00 00 00 44 82 FF 00 63 30 00 99 13 00 21 10 24 02 01 00 42 90 21 98 73 00 44 00 43 30 08 00 60 10 01 00 52 26 01 00 42 30 EF FF 40 10 21 10 24 02 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 20 24 02 7C 24 00 BF 8F 23 10 13 00 0B 98 50 00 21 10 60 02 1C 00 B2 8F 20 00 B3 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 01 00 52 26 01 00 10 24 ?? ?? ?? 0? 00 00 44 82 01 00 44 82 ?? ?? ?? 0? 01 00 52 26 }
	condition:
		$1
}

rule file_885_0_0 {
	meta:
		name = "_flsbuf"
		size = 300
		refs = "0048 write 0040 _sobuf"
	strings:
		$1 = { 0C 00 A2 94 E8 FF BD 27 10 00 B0 AF 40 00 43 30 14 00 BF AF 21 80 A0 00 1C 00 60 14 18 00 A4 A3 02 00 43 30 3D 00 60 50 30 00 42 34 10 00 A3 8C 1B 00 60 50 0E 00 A4 94 08 00 A5 8C 2D 00 A0 50 ?? ?? 05 3C 04 00 06 8E ?? ?? ?? 0? 0E 00 04 96 FF FF 02 24 08 00 03 8E 04 00 02 AE 18 00 A2 93 00 00 62 A0 18 00 A2 83 01 00 63 24 00 00 03 AE 0A 00 03 24 13 00 43 50 0C 00 03 96 14 00 BF 8F 10 00 B0 8F 08 00 E0 03 18 00 BD 27 14 00 BF 8F 20 14 04 7C 10 00 B0 8F 08 00 E0 03 18 00 BD 27 01 00 06 24 ?? ?? ?? 0? 18 00 A5 27 14 00 BF 8F 18 00 A2 83 04 00 00 AE 10 00 B0 8F 08 00 E0 03 18 00 BD 27 00 01 63 30 ED FF 60 10 14 00 BF 8F 0E 00 04 96 08 00 05 8E ?? ?? ?? 0? 04 00 06 8E 08 00 03 8E 18 00 A2 83 04 00 00 AE ?? ?? ?? 0? 00 00 03 AE ?? ?? A5 24 20 00 03 24 08 00 42 34 08 00 05 AE 00 00 05 AE 10 00 03 AE 04 00 03 AE 0C 00 02 A6 ?? ?? ?? 0? 20 00 06 24 0C 00 A2 A4 04 00 A0 AC ?? ?? ?? 0? FF FF 02 24 }
	condition:
		$1
}

rule file_890_0_0 {
	meta:
		name = "ftell"
		size = 108
		refs = "0018 lseek"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 80 80 00 0E 00 84 84 21 28 00 00 14 00 BF AF ?? ?? ?? 0? 01 00 06 24 04 00 03 8E 0F 00 62 04 04 00 00 AE 08 00 04 8E 05 00 80 10 14 00 BF 8F 0C 00 04 96 00 02 84 30 05 00 80 54 21 10 62 00 23 10 43 00 10 00 B0 8F 08 00 E0 03 18 00 BD 27 10 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 21 18 00 00 }
	condition:
		$1
}

rule file_890_1_0 {
	meta:
		name = "fseek"
		size = 444
		refs = "006c fflush 007c lseek 00b0 ftell"
	strings:
		$1 = { 0C 00 87 94 08 00 83 8C D8 FF BD 27 EF FF E7 30 18 00 B1 AF 14 00 B0 AF 24 00 BF AF 20 00 B3 AF 1C 00 B2 AF 21 80 80 00 21 88 A0 00 59 00 60 10 0C 00 87 A4 01 00 03 24 3B 00 C3 10 02 00 03 24 0A 00 C3 10 00 00 00 00 19 00 C0 10 FF FF 02 24 24 00 BF 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 00 00 00 00 0E 00 04 96 21 28 00 00 ?? ?? ?? 0? 01 00 06 24 0E 00 04 96 21 28 00 00 02 00 06 24 ?? ?? ?? 0? 21 98 40 00 0E 00 04 96 21 90 40 00 21 28 60 02 ?? ?? ?? 0? 21 30 00 00 21 88 32 02 ?? ?? ?? 0? 21 20 00 02 23 10 22 02 17 00 40 14 0C 00 03 96 03 00 65 30 01 00 04 24 1B 00 A4 54 00 02 63 30 19 00 42 04 00 02 63 30 04 00 04 8E 2A 28 82 00 14 00 A0 14 24 00 BF 8F 00 00 03 8E 23 20 82 00 21 10 62 00 00 00 02 AE 04 00 04 AE 21 10 00 00 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 00 08 63 34 ?? ?? ?? 0? 0C 00 03 A6 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 88 22 02 00 02 63 30 05 00 60 50 08 00 02 8E 04 00 02 8E 18 00 40 14 00 00 00 00 08 00 02 8E 0E 00 04 96 04 00 00 AE 00 00 02 AE 21 28 20 02 ?? ?? ?? 0? 21 30 00 00 24 00 BF 8F 00 00 43 28 FF FF 02 24 0A 10 03 00 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 0E 00 84 94 27 18 02 00 FF FF 02 24 ?? ?? ?? 0? 0B 10 03 00 ?? ?? ?? 0? 21 20 00 02 ?? ?? ?? 0? 08 00 02 8E }
	condition:
		$1
}

rule file_892_0_0 {
	meta:
		name = "strtod"
		size = 40
		refs = "0008 __strtod 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_30_1_2 {
	meta:
		name = "acosh"
		size = 40
		refs = "0008 acoshl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_30_2_2 {
	meta:
		name = "acoshf"
		size = 40
		refs = "0008 acoshl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_34_1_2 {
	meta:
		name = "asinh"
		size = 40
		refs = "0008 asinhl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_34_2_2 {
	meta:
		name = "asinhf"
		size = 40
		refs = "0008 asinhl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_20_1_2 {
	meta:
		name = "atanh"
		size = 40
		refs = "0008 atanhl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_20_2_2 {
	meta:
		name = "atanhf"
		size = 40
		refs = "0008 atanhl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_11_1_2 {
	meta:
		name = "cbrt"
		size = 40
		refs = "0008 cbrtl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_11_2_2 {
	meta:
		name = "cbrtf"
		size = 40
		refs = "0008 cbrtl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_10_2 {
	meta:
		name = "drem"
		size = 40
		refs = "0008 dreml 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_11_2 {
	meta:
		name = "dremf"
		size = 40
		refs = "0008 dreml 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_6_1_2 {
	meta:
		name = "expm1"
		size = 40
		refs = "0008 expm1l 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_6_2_2 {
	meta:
		name = "expm1f"
		size = 40
		refs = "0008 expm1l 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_10_1_2 {
	meta:
		name = "hypot"
		size = 40
		refs = "0008 hypotl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_10_2_2 {
	meta:
		name = "hypotf"
		size = 40
		refs = "0008 hypotl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_75_1_2 {
	meta:
		name = "log1p"
		size = 40
		refs = "0008 log1pl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_75_2_2 {
	meta:
		name = "log1pf"
		size = 40
		refs = "0008 log1pl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_4_2 {
	meta:
		name = "logb"
		size = 40
		refs = "0008 logbl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_41_5_2 {
	meta:
		name = "logbf"
		size = 40
		refs = "0008 logbl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_69_1_2 {
	meta:
		name = "rint"
		size = 40
		refs = "0008 rintl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_69_2_2 {
	meta:
		name = "rintf"
		size = 40
		refs = "0008 rintl 0014 dptofp"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_894_0_0 {
	meta:
		name = "srand"
		size = 28
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 44 AC ?? ?? 40 AC 01 00 03 24 ?? ?? 02 3C 08 00 E0 03 ?? ?? 43 A0 }
	condition:
		$1
}

rule file_894_1_0 {
	meta:
		name = "rand"
		size = 152
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 43 80 0C 00 60 14 01 00 03 24 95 4C 04 3C 51 58 05 3C ?? ?? 43 A0 2E 7F 84 34 ?? ?? 03 3C 2D F4 A5 34 51 58 02 3C 2D F4 42 34 ?? ?? 64 AC 08 00 E0 03 ?? ?? 65 AC ?? ?? 03 3C ?? ?? 67 8C 51 58 08 3C 95 4C 06 3C 2D 7F C6 24 2D F4 08 35 02 40 E8 70 ?? ?? 62 8C 19 00 E6 00 12 50 00 00 10 58 00 00 02 20 46 70 01 00 46 25 2B 38 CA 00 21 10 88 00 21 10 4B 00 21 10 E2 00 21 28 40 00 21 20 C0 00 00 F0 42 7C ?? ?? 64 AC 08 00 E0 03 ?? ?? 65 AC }
	condition:
		$1
}

rule file_910_0_0 {
	meta:
		name = "ps"
		size = 80
		refs = "001c _iob 0028 fputc"
	strings:
		$1 = { E0 FF BD 27 18 00 B1 AF 1C 00 BF AF 14 00 B0 AF 21 88 80 00 00 00 84 80 08 00 80 10 ?? ?? 10 3C ?? ?? 10 26 01 00 31 26 ?? ?? ?? 0? 21 28 00 02 00 00 24 82 FC FF 80 14 01 00 31 26 1C 00 BF 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_910_1_0 {
	meta:
		name = "perror"
		size = 76
		refs = "0020 strerror 001c errno 0038 fputc 0030 _iob"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 44 8C ?? ?? ?? 0? 21 20 40 00 ?? ?? 05 3C 0A 00 04 24 ?? ?? ?? 0? ?? ?? A5 24 14 00 BF 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_943_0_0 {
	meta:
		name = "ungetc"
		size = 116
	strings:
		$1 = { FF FF 03 24 03 00 83 14 21 10 80 00 08 00 E0 03 00 00 00 00 0C 00 A4 94 01 00 03 24 01 02 84 30 03 00 83 50 08 00 A6 8C 08 00 E0 03 FF FF 02 24 F6 FF C0 50 FF FF 02 24 04 00 A4 8C 10 00 A3 8C F2 FF 83 50 FF FF 02 24 00 00 A3 8C 06 00 C3 10 01 00 84 24 04 00 A4 AC FF FF 64 24 00 00 A4 AC 08 00 E0 03 FF FF 62 A0 01 00 63 24 ?? ?? ?? 0? 00 00 A3 AC }
	condition:
		$1
}

rule file_957_0_0 {
	meta:
		name = "strncmp"
		size = 116
	strings:
		$1 = { 13 00 C0 10 21 10 00 00 00 00 82 80 12 00 40 10 FF FF C6 24 00 00 A3 80 09 00 43 10 FF FF 07 24 ?? ?? ?? 0? FF 00 42 30 00 00 82 80 0A 00 40 10 01 00 A5 24 00 00 A3 80 0B 00 43 14 FF 00 42 30 FF FF C6 24 F8 FF C7 14 01 00 84 24 21 10 00 00 08 00 E0 03 00 00 00 00 00 00 A3 80 FF 00 63 30 08 00 E0 03 23 10 43 00 FF 00 63 30 08 00 E0 03 23 10 43 00 }
	condition:
		$1
}

rule file_989_0_0 {
	meta:
		name = "strncpy"
		size = 92
	strings:
		$1 = { 14 00 C0 10 21 10 80 00 00 00 A4 80 FF FF C6 24 01 00 43 24 00 00 44 A0 08 00 80 10 01 00 A5 24 0C 00 C0 10 FF FF C6 24 00 00 A4 80 01 00 A5 24 00 00 64 A0 FA FF 80 14 01 00 63 24 05 00 C0 10 21 20 66 00 00 00 60 A0 01 00 63 24 FE FF 64 54 00 00 60 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_994_0_0 {
	meta:
		name = "freopen"
		size = 556
		refs = "0024 fclose 00e4 open 0144 fseek 01bc close 0200 _bufallo"
	strings:
		$1 = { D0 FF BD 27 20 00 B1 AF 1C 00 B0 AF 21 88 C0 00 21 80 80 00 21 20 C0 00 10 00 A5 AF 2C 00 BF AF 28 00 B3 AF ?? ?? ?? 0? 24 00 B2 AF 0C 00 22 96 10 00 A5 8F 72 00 03 24 08 00 42 30 0C 00 22 A6 00 00 A2 80 0E 00 43 10 77 00 03 24 6A 00 43 10 61 00 03 24 0B 00 43 10 01 00 13 24 2C 00 BF 8F 21 88 00 00 21 10 20 02 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 21 98 00 00 21 90 00 00 62 00 03 24 2B 00 04 24 01 00 A5 24 00 00 A2 80 0D 00 40 50 01 00 02 24 32 00 43 50 0C 00 22 96 09 00 44 14 01 00 02 24 0C 00 22 96 01 00 A5 24 03 00 42 34 0C 00 22 A6 00 00 A2 80 F6 FF 40 14 02 00 12 24 01 00 02 24 29 00 62 12 02 00 02 24 2F 00 62 12 21 20 00 02 21 28 40 02 ?? ?? ?? 0? B6 01 06 24 20 16 02 7C 4B 00 40 04 0E 00 22 A6 0C 00 22 96 0C 00 42 30 3F 00 40 10 00 00 00 00 08 00 22 8E FF FF 03 24 41 00 43 50 0E 00 24 86 00 00 22 AE 2B 00 60 12 04 00 20 AE 0C 00 22 96 02 02 42 34 0C 00 22 A6 01 00 02 24 06 00 62 16 2C 00 BF 8F 21 20 20 02 21 28 00 00 ?? ?? ?? 0? 02 00 06 24 2C 00 BF 8F 21 10 20 02 28 00 B3 8F 24 00 B2 8F 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 30 00 BD 27 80 00 42 34 ?? ?? ?? 0? 0C 00 22 A6 02 00 05 24 21 20 00 02 0A 28 72 02 ?? ?? ?? 0? B6 01 06 24 20 16 02 7C D9 FF 41 04 0E 00 22 A6 21 20 00 02 02 00 05 24 ?? ?? ?? 0? B6 01 06 24 20 26 02 7C 1C 00 80 04 0E 00 24 A6 D1 FF 40 52 0C 00 22 96 ?? ?? ?? 0? 00 00 00 00 ?? ?? ?? 0? 21 20 00 02 0C 00 22 96 2C 00 BF 8F 28 00 B3 8F 01 00 42 34 0C 00 22 A6 24 00 B2 8F 21 10 20 02 1C 00 B0 8F 20 00 B1 8F 08 00 E0 03 30 00 BD 27 ?? ?? ?? 0? 02 00 13 24 ?? ?? ?? 0? 00 00 00 00 20 00 03 24 08 00 22 AE ?? ?? ?? 0? 10 00 23 AE ?? ?? ?? 0? 08 00 20 AE 0C 00 20 A6 ?? ?? ?? 0? 21 88 00 00 }
	condition:
		$1
}

rule file_1033_0_0 {
	meta:
		name = "fwrite"
		size = 460
		refs = "00d8 fputc 0160 memcpy 0090 _outdone 019c fflush 01bc fseek"
	strings:
		$1 = { 0C 00 E3 94 C8 FF BD 27 2C 00 B7 AF 21 B8 80 00 02 00 64 30 24 00 B5 AF 18 00 B2 AF 14 00 B1 AF 34 00 BF AF 30 00 BE AF 28 00 B6 AF 20 00 B4 AF 1C 00 B3 AF 10 00 B0 AF 21 A8 E0 00 21 88 A0 00 21 90 C0 00 31 00 80 10 21 10 00 00 00 02 62 30 3A 00 40 50 04 00 E4 8C 04 00 E2 8C 00 02 63 34 39 00 40 10 0C 00 E3 A4 00 0C 64 30 00 0C 02 24 51 00 82 10 21 20 A0 02 02 B0 51 72 FF F7 63 30 0C 00 A3 A6 21 00 C0 12 21 10 00 00 FF FF 10 24 ?? ?? 13 3C 01 00 14 24 08 00 A2 8E 0E 00 40 50 00 00 E4 82 0C 00 A2 96 80 00 42 30 0A 00 40 50 00 00 E4 82 04 00 A2 8E 10 00 BE 8E 23 F0 C2 03 2B 10 DE 02 23 00 40 54 21 F0 C0 02 22 00 C0 57 23 B0 DE 02 00 00 E4 82 ?? ?? ?? 0? 21 28 A0 02 04 00 50 10 01 00 F7 26 FF FF D6 26 EB FF C0 56 08 00 A2 8E FF FF 22 26 21 B0 56 00 1B 00 D1 02 F4 01 20 02 12 B0 00 00 23 10 56 02 34 00 BF 8F 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 F3 FF 80 14 00 02 63 34 0C 00 E3 A4 08 00 A2 8E ?? ?? ?? 0? 00 00 A2 AE 21 B0 00 00 00 00 A4 8E 21 28 E0 02 ?? ?? ?? 0? 21 30 C0 03 00 00 A4 8E 04 00 A2 8E 10 00 A3 8E 21 20 9E 00 21 10 C2 03 21 B8 FE 02 00 00 A4 AE 05 00 43 10 04 00 A2 AE C2 FF C0 16 ?? ?? 74 A2 ?? ?? ?? 0? FF FF 22 26 ?? ?? ?? 0? 21 20 A0 02 D1 FF 40 10 00 00 00 00 10 00 A2 8E ?? ?? ?? 0? 21 B0 C2 02 21 28 00 00 ?? ?? ?? 0? 02 00 06 24 ?? ?? ?? 0? 0C 00 A3 96 }
	condition:
		$1
}

rule file_1035_0_0 {
	meta:
		name = "__assfail"
		size = 68
		refs = "000c _iob 002c vfprintf"
	strings:
		$1 = { E0 FF BD 27 21 18 80 00 24 00 A2 27 ?? ?? 04 3C 24 00 A5 AF 28 00 A6 AF ?? ?? 84 24 21 28 60 00 21 30 40 00 1C 00 BF AF 2C 00 A7 AF ?? ?? ?? 0? 10 00 A2 AF 3F 00 00 70 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1037_0_0 {
	meta:
		name = "tolower"
		size = 36
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 03 3C ?? ?? 63 24 21 18 83 00 21 10 80 00 01 00 64 90 20 00 43 24 01 00 84 30 08 00 E0 03 0B 10 64 00 }
	condition:
		$1
}

rule file_1037_1_0 {
	meta:
		name = "toupper"
		size = 36
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 82 00 01 00 42 90 E0 FF 83 24 02 00 42 30 0B 20 62 00 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_1037_2_0 {
	meta:
		name = "isalnum"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 07 00 42 30 }
	condition:
		$1
}

rule file_1037_3_0 {
	meta:
		name = "isalpha"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 03 00 42 30 }
	condition:
		$1
}

rule file_1037_5_0 {
	meta:
		name = "iscntrl"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 20 00 42 30 }
	condition:
		$1
}

rule file_1037_6_0 {
	meta:
		name = "isdigit"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 04 00 42 30 }
	condition:
		$1
}

rule file_1037_7_0 {
	meta:
		name = "isgraph"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 17 00 42 30 }
	condition:
		$1
}

rule file_1037_8_0 {
	meta:
		name = "islower"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 02 00 42 30 }
	condition:
		$1
}

rule file_1037_9_0 {
	meta:
		name = "isprint"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 80 08 00 E0 03 97 00 42 30 }
	condition:
		$1
}

rule file_1037_10_0 {
	meta:
		name = "ispunct"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 10 00 42 30 }
	condition:
		$1
}

rule file_1037_11_0 {
	meta:
		name = "isspace"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 80 08 00 E0 03 88 00 42 30 }
	condition:
		$1
}

rule file_1037_12_0 {
	meta:
		name = "isupper"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 01 00 42 30 }
	condition:
		$1
}

rule file_1037_13_0 {
	meta:
		name = "isxdigit"
		size = 24
		refs = "0000 _ctype"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 24 21 10 44 00 01 00 42 90 08 00 E0 03 44 00 42 30 }
	condition:
		$1
}

rule file_1040_0_0 {
	meta:
		name = "strtoull"
		size = 680
		refs = "003c _ctype 011c toupper 0218 errno"
	strings:
		$1 = { C8 FF BD 27 1C 00 B3 AF 18 00 B2 AF 14 00 B1 AF 34 00 BF AF 30 00 BE AF 2C 00 B7 AF 28 00 B6 AF 24 00 B5 AF 20 00 B4 AF 10 00 B0 AF 21 88 A0 00 21 90 80 00 95 00 A0 10 21 98 C0 00 ?? ?? 16 3C 00 00 A4 AC ?? ?? D6 26 00 00 44 82 21 10 C4 02 01 00 42 80 88 00 42 30 FB FF 40 14 01 00 52 26 2D 00 02 24 7D 00 82 10 2B 00 02 24 7F 00 82 10 21 80 00 00 30 00 02 24 6E 00 82 10 0A 00 02 24 0A 98 53 00 21 B8 00 00 21 A0 00 00 21 A8 00 00 ?? ?? ?? 0? C3 F7 13 00 27 00 60 10 2A 18 53 00 25 00 60 10 C3 27 02 00 02 18 D4 73 19 00 93 02 12 40 00 00 10 48 00 00 02 28 75 72 21 18 A3 00 21 48 69 00 21 18 48 00 21 20 89 00 2B 10 62 00 21 10 44 00 2B 20 55 00 21 30 60 00 4D 00 80 14 21 38 40 00 49 00 55 50 2B 18 74 00 00 00 44 82 21 A0 C0 00 21 A8 E0 00 01 00 52 26 01 00 17 24 21 10 C4 02 01 00 43 90 D0 FF 82 24 20 14 02 7C 03 00 65 30 E0 FF A0 10 04 00 63 30 ?? ?? ?? 0? 00 00 00 00 C9 FF 42 24 20 14 02 7C 2A 18 53 00 DD FF 60 14 C3 27 02 00 21 20 80 02 21 18 A0 02 21 10 00 00 05 00 20 12 00 00 00 00 1A 00 E0 52 00 00 25 8E FF FF 52 26 00 00 32 AE 1C 00 40 14 34 00 BF 8F 06 00 00 12 23 20 04 00 2B 10 04 00 23 18 03 00 23 18 62 00 21 A0 80 00 21 A8 60 00 34 00 BF 8F 21 10 80 02 21 18 A0 02 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 00 00 A6 80 30 00 05 24 E5 FF C5 50 FF FF 52 26 E6 FF 40 10 34 00 BF 8F FF FF 14 24 FF FF 15 24 21 10 80 02 21 18 A0 02 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 B8 FF 60 50 00 00 44 82 22 00 03 24 ?? ?? 02 3C ?? ?? 43 AC 01 00 52 26 21 20 80 02 21 18 A0 02 ?? ?? ?? 0? 01 00 02 24 00 00 44 82 0F 00 60 16 01 00 52 26 78 00 02 24 14 00 82 10 58 00 02 24 12 00 82 10 08 00 02 24 ?? ?? ?? 0? 0A 98 53 00 00 00 44 82 01 00 10 24 ?? ?? ?? 0? 01 00 52 26 00 00 44 82 ?? ?? ?? 0? 01 00 52 26 10 00 02 24 82 FF 62 16 21 B8 00 00 ?? ?? ?? 0? 78 00 02 24 ?? ?? 16 3C ?? ?? ?? 0? ?? ?? D6 26 00 00 44 82 10 00 13 24 ?? ?? ?? 0? 01 00 52 26 }
	condition:
		$1
}

rule file_1040_1_0 {
	meta:
		name = "strtoll"
		size = 388
		refs = "001c _ctype 0078 strtoull 0120 errno"
	strings:
		$1 = { D8 FF BD 27 20 00 B3 AF 1C 00 B2 AF 14 00 B0 AF 24 00 BF AF 18 00 B1 AF 00 00 91 80 ?? ?? 02 3C ?? ?? 42 24 21 18 51 00 01 00 63 80 21 90 80 00 21 98 A0 00 88 00 63 30 08 00 60 10 21 80 80 00 01 00 10 26 00 00 11 82 21 18 51 00 01 00 63 80 88 00 63 30 FB FF 60 54 01 00 10 26 2D 00 02 24 29 00 22 12 2B 00 02 24 02 00 22 52 01 00 10 26 2B 00 11 24 21 20 00 02 ?? ?? ?? 0? 21 28 60 02 07 00 60 12 2B 00 04 24 00 00 64 8E 27 00 90 50 00 00 72 AE 26 00 44 12 25 20 43 00 2B 00 04 24 1B 00 24 12 2D 00 04 24 0C 00 24 12 00 80 04 3C 21 20 40 00 21 28 60 00 24 00 BF 8F 21 10 80 00 21 18 A0 00 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 01 00 85 24 2B 28 65 00 22 00 A0 50 22 00 03 24 1D 00 64 10 00 00 00 00 23 10 02 00 2B 20 02 00 23 18 03 00 ?? ?? ?? 0? 23 18 64 00 ?? ?? ?? 0? 01 00 10 26 21 20 40 00 E8 FF 61 04 21 28 60 00 22 00 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC 25 20 43 00 DB FF 80 10 2B 00 04 24 ?? ?? 02 3C 22 00 03 24 ?? ?? 43 AC 2D 00 02 24 21 20 00 00 DA FF 22 12 00 80 05 3C FF 7F 05 3C FF FF 04 24 ?? ?? ?? 0? FF FF A5 34 E4 FF 40 10 23 10 02 00 22 00 03 24 ?? ?? 02 3C ?? ?? 43 AC 21 20 00 00 ?? ?? ?? 0? 00 80 05 3C }
	condition:
		$1
}

rule file_1054_0_0 {
	meta:
		name = "fdopen"
		size = 348
		refs = "0008 _iob 0118 fseek 0148 _bufallo"
	strings:
		$1 = { E0 FF BD 27 14 00 B0 AF ?? ?? 10 3C ?? ?? 10 26 0C 00 02 96 1C 00 BF AF 18 00 B1 AF 03 00 42 30 0F 00 40 10 A0 00 03 26 14 00 10 26 0C 00 02 96 03 00 42 30 0B 00 40 50 00 00 A2 80 FB FF 03 16 14 00 10 26 21 80 00 00 1C 00 BF 8F 21 10 00 02 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 00 00 A2 80 72 00 03 24 32 00 43 10 77 00 03 24 05 00 43 10 61 00 03 24 F2 FF 43 14 01 00 11 24 ?? ?? ?? 0? 62 00 03 24 02 00 11 24 62 00 03 24 2B 00 06 24 80 00 07 24 01 00 A5 24 00 00 A2 80 0D 00 40 50 0C 00 02 96 FB FF 43 50 0C 00 07 A6 1D 00 46 14 FC FF 02 24 0C 00 02 96 01 00 A5 24 03 00 42 34 0C 00 02 A6 00 00 A2 80 F6 FF 40 14 00 00 00 00 0C 00 02 96 0E 00 04 A6 FF FD 42 30 0C 00 44 30 21 18 40 00 17 00 80 10 0C 00 02 A6 08 00 02 8E 00 00 02 AE 10 00 20 12 04 00 00 AE 02 02 63 34 01 00 02 24 CF FF 22 16 0C 00 03 A6 21 20 00 02 21 28 00 00 ?? ?? ?? 0? 02 00 06 24 ?? ?? ?? 0? 1C 00 BF 8F 0C 00 02 A6 ?? ?? ?? 0? 21 80 00 00 ?? ?? ?? 0? 21 88 00 00 01 00 63 34 ?? ?? ?? 0? 0C 00 03 A6 ?? ?? ?? 0? 00 00 00 00 08 00 02 AE ?? ?? ?? 0? 0C 00 03 96 }
	condition:
		$1
}

rule file_1064_2_0 {
	meta:
		name = "_dvfprintf_cdeEfFgGnopsuxX"
		size = 6776
		refs = "009c _ctype 0164 fputc 0470 dpcmp 04e0 dpadd 055c dpdiv 0568 __fixunsdfdi 087c __udivdi3 0890 __umoddi3 0a34 dptoul 0cfc __floatunsidf 0d18 dpsub 0df8 frexp 0e3c dpmul 103c __floatundidf"
		altNames = "_dvfprintf_cdeEfFgGnopuxX"
	strings:
		$1 = { 90 FF BD 27 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 68 00 BE AF 64 00 B7 AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 21 90 80 00 21 88 A0 00 78 00 A6 AF 34 00 A0 AF 38 00 A0 AF 21 80 00 00 00 00 24 82 68 00 80 10 10 00 A4 A3 25 00 02 24 38 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 2C 02 46 10 FF FF 91 24 2E 00 45 28 22 02 A0 10 00 00 00 00 34 02 47 50 01 00 63 34 30 02 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A4 24 21 28 82 00 01 00 A5 90 02 00 67 30 FE FF 66 30 0B 18 C7 00 08 00 67 30 FB FF 66 30 04 00 A5 30 28 02 A0 10 0B 18 C7 00 21 98 00 00 0A 00 06 24 02 28 66 72 01 00 31 26 21 98 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 73 26 2E 00 05 24 26 02 45 50 01 00 31 26 00 10 63 34 21 A8 00 00 ?? ?? 07 3C ?? ?? E6 24 10 00 08 24 00 80 07 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3D 00 A0 14 01 00 31 26 10 00 B6 27 01 00 17 24 04 00 A0 12 2B 10 F3 02 2B 10 B7 02 0B B8 A2 02 2B 10 F3 02 08 00 75 30 23 98 77 02 0B 00 A0 16 0A 98 02 00 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 D6 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F4 56 00 00 C4 82 A5 FF A0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9A FF 80 14 10 00 A4 A3 6C 00 BF 8F 21 10 00 02 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 80 20 04 00 21 20 C4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 63 34 80 00 63 34 00 07 62 30 97 00 40 10 21 B8 60 00 00 10 65 30 06 00 04 24 10 00 62 30 A9 01 40 10 0B A8 85 00 78 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 5E 8C 04 00 54 8C 08 00 44 24 78 00 A4 AF 21 20 C0 03 21 28 80 02 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 3C 00 A3 AF 04 00 41 04 3C 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 77 34 21 20 C0 03 21 28 80 02 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF 52 02 40 14 21 B0 00 00 00 01 E2 32 50 01 40 14 00 02 E2 32 4C 01 40 14 FC FF C2 2A 19 00 A2 2A 0B 00 40 10 18 00 A8 8F ?? ?? ?? 0? FF 00 A4 32 21 30 40 00 21 20 C0 03 21 28 80 02 ?? ?? ?? 0? 21 38 60 00 21 F0 40 00 21 A0 60 00 18 00 A8 8F 0A 00 02 29 8D 02 40 14 21 20 C0 03 34 00 A3 8F 38 00 A2 8F ?? ?? 06 3C ?? ?? C7 8C ?? ?? C6 8C 21 20 60 00 21 28 40 00 ?? ?? ?? 0? 44 00 A8 AF E9 04 41 04 44 00 A8 8F ED FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 44 00 A8 AF 38 00 A3 AF 34 00 A2 AF 21 18 40 00 38 00 A2 8F 21 20 C0 03 21 30 60 00 21 28 80 02 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 44 00 A8 8F 20 00 A2 AF 21 B0 60 00 28 00 A0 AF 2C 00 A0 AF 01 00 02 24 26 05 C0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 05 24 ?? ?? ?? 0? 12 00 09 24 21 50 A0 00 04 00 64 8C 2B 30 C4 02 A5 04 C0 14 02 00 47 24 9F 04 96 50 00 00 64 8C 01 00 A5 24 01 00 42 24 20 2C 05 7C F5 FF 49 14 08 00 63 24 10 00 A5 A3 14 00 07 24 23 A0 68 02 23 A0 95 02 2B 10 15 00 23 A0 87 02 03 00 E3 32 23 A0 82 02 2B 18 03 00 04 00 E2 32 F2 03 40 10 23 A0 83 02 02 00 E2 32 E4 04 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 F6 03 80 1A 08 00 FE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 08 00 FE 32 20 00 63 34 00 01 63 34 00 07 62 30 6B FF 40 14 21 B8 60 00 C0 00 62 30 1E 01 40 14 20 16 03 7C 71 04 40 04 78 00 A7 8F 10 00 62 30 FD 01 40 10 78 00 A5 8F 78 00 A2 8F 00 00 44 8C 04 00 42 24 78 00 A2 AF C3 17 04 00 21 B0 80 00 21 B8 40 00 05 00 41 04 23 10 02 00 23 B0 04 00 2B 20 16 00 03 00 63 34 23 B8 44 00 03 00 A0 16 C0 00 74 30 25 A8 D7 02 01 00 B5 2E 40 00 02 24 2F 03 82 12 41 00 82 2A 05 03 40 10 80 00 02 24 16 00 80 16 10 00 BE 83 01 00 02 24 CC 04 E0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 42 24 02 00 06 24 02 00 1E 24 ?? ?? ?? 0? 14 00 07 24 21 30 C0 03 04 00 44 8C 2B 28 E4 02 3A 03 A0 54 10 00 A6 A3 59 04 97 50 00 00 44 8C 01 00 DE 27 20 F4 1E 7C F6 FF C7 17 08 00 42 24 10 00 BE A3 2A 10 D5 03 E9 02 40 10 2A 10 BE 02 20 F4 15 7C 10 00 BE A3 05 00 60 12 00 40 62 30 03 00 62 30 2B 10 02 00 23 98 62 02 00 40 62 30 05 00 40 10 2A 20 D3 03 2A 10 B3 02 23 98 75 02 0A 98 02 00 2A 20 D3 03 04 00 62 30 23 F0 7E 02 B9 02 40 10 0A F0 04 00 02 00 62 30 FA 02 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 27 10 02 00 3C 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 64 30 0D 00 C0 13 28 00 A4 AF 21 98 60 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 08 00 65 32 21 18 60 02 28 00 A5 AF FF FF B5 26 ?? ?? 02 3C C0 98 15 00 ?? ?? 42 24 21 98 53 00 03 00 02 24 80 40 15 00 40 20 17 00 02 A8 A2 72 20 00 63 30 41 00 82 2A 2C 00 BE AF 30 00 B1 AF 20 00 A3 AF 21 F0 80 00 ?? ?? ?? 0? 21 88 40 00 10 00 80 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 44 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 44 00 A8 AF 44 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF B5 26 FD FF 02 24 5D 02 A2 12 40 00 02 24 51 02 82 12 27 10 15 00 DF FF 20 16 80 00 02 24 3B 02 82 12 C0 00 02 24 DD FF 82 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 63 34 ?? ?? ?? 0? 00 02 63 34 E3 FD 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 D6 FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 05 24 E2 FD 45 14 21 98 00 00 78 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D3 8C 2E 00 05 24 04 00 C6 24 DD FD 45 14 78 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 05 24 A1 02 45 10 00 40 63 34 21 28 82 00 01 00 A5 90 21 A8 00 00 04 00 A5 30 D4 FD A0 10 0A 00 06 24 02 28 A6 72 01 00 31 26 21 A8 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF B5 26 ?? ?? ?? 0? ?? ?? 07 3C 6F 01 40 10 2A 10 D5 02 FC 00 A0 12 21 10 00 00 40 02 E2 7E 23 A8 A2 02 13 00 A2 2E F6 00 40 14 12 00 02 24 10 00 A2 A3 21 20 C0 03 21 28 80 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 A4 00 40 14 10 00 AA 83 21 28 80 02 ?? ?? ?? 0? 21 20 C0 03 21 A0 40 00 18 00 B6 8F ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF 73 26 03 00 E2 32 63 00 D6 26 2B 10 02 00 23 98 75 02 C7 00 D6 2E 23 98 62 02 01 00 D6 2E 04 00 E2 32 2D 00 40 10 23 98 76 02 02 00 E2 32 15 01 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 31 00 60 5A 08 00 FE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 08 00 FE 32 78 00 A5 8F F8 FF 02 24 07 00 A4 24 24 10 82 00 00 00 5E 8C 04 00 54 8C 08 00 42 24 ?? ?? ?? 0? 78 00 A2 AF 5E 03 40 04 10 00 62 30 DC 00 40 10 78 00 A4 8F 78 00 A2 8F 21 B8 00 00 00 00 56 8C 04 00 42 24 ?? ?? ?? 0? 78 00 A2 AF 08 00 FE 32 0C 00 C0 17 02 00 E2 32 0A 00 60 1A 00 00 00 00 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 02 00 E2 32 D2 00 40 14 01 00 E4 32 01 00 E2 32 D3 00 40 14 20 00 04 24 10 00 A2 83 20 00 A3 8F 21 20 80 02 C0 10 02 00 21 10 62 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 20 00 A4 8F 27 10 02 00 C0 18 03 00 21 18 83 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A0 40 00 19 02 A0 16 21 B0 60 00 20 00 F7 32 02 00 E0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 67 02 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A3 8F 64 00 62 28 4F 02 40 10 64 00 14 24 0A 00 14 24 1A 00 74 00 F4 01 80 02 21 28 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 EF FC C0 13 21 80 02 02 EE FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 23 20 CA 02 ?? ?? ?? 0? 40 00 AA AF 21 30 40 00 21 38 60 00 21 20 C0 03 ?? ?? ?? 0? 21 28 80 02 21 48 60 00 21 40 40 00 21 28 20 01 21 20 40 00 44 00 A8 AF ?? ?? ?? 0? 3C 00 A9 AF 21 20 40 00 ?? ?? ?? 0? 21 F0 40 00 44 00 A8 8F 3C 00 A9 8F 21 30 40 00 21 20 00 01 21 28 20 01 ?? ?? ?? 0? 21 38 60 00 ?? ?? 07 3C ?? ?? E7 24 00 00 E4 8C 04 00 E5 8C 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 44 00 A8 8F 3C 00 A9 8F 12 00 40 1C 40 00 AA 8F ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 01 ?? ?? ?? 0? 21 28 20 01 21 48 60 00 21 40 40 00 21 28 20 01 21 20 40 00 44 00 A8 AF ?? ?? ?? 0? 3C 00 A9 AF 40 00 AA 8F 3C 00 A9 8F 44 00 A8 8F 21 F0 40 00 ?? ?? 02 3C 01 00 43 25 C0 18 03 00 ?? ?? 42 24 20 00 A2 AF 21 10 43 00 04 00 43 8C 4E 00 60 10 21 A0 C0 03 20 00 A4 8F C0 50 0A 00 21 50 8A 00 04 00 42 8D C4 02 40 14 ?? ?? 02 3C 00 00 42 8D 2B F0 C2 03 C0 02 C0 17 ?? ?? 02 3C ?? ?? ?? 0? 18 00 B6 8F 21 10 A0 02 ?? ?? ?? 0? 10 00 A2 A3 21 20 C0 03 21 28 80 02 ?? ?? ?? 0? 18 00 A6 27 18 00 B6 8F 03 00 03 24 0A 00 02 24 FF FF D6 26 02 B0 C3 72 1A 00 C2 02 F4 01 40 00 12 B0 00 00 E4 02 C0 06 18 00 B6 AF ?? ?? ?? 0? 23 20 16 00 21 20 40 00 21 28 60 00 21 30 C0 03 ?? ?? ?? 0? 21 38 80 02 38 00 A3 AF ?? ?? 06 3C 21 18 40 00 34 00 A2 AF 38 00 A2 8F ?? ?? C7 8C ?? ?? C6 8C 21 20 60 00 ?? ?? ?? 0? 21 28 40 00 43 00 41 04 ?? ?? 06 3C FF FF D6 26 ?? ?? ?? 0? 18 00 B6 AF 21 B8 00 00 00 00 96 8C 04 00 84 24 ?? ?? ?? 0? 78 00 A4 AF 00 00 A4 8C 04 00 A5 24 78 00 A5 AF C3 17 04 00 21 B0 80 00 ?? ?? ?? 0? 21 B8 40 00 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 F5 FE 40 10 20 00 04 24 ?? ?? ?? 0? 00 00 00 00 00 00 42 8C 2B 10 C2 03 B1 FF 40 54 20 00 A4 8F ?? ?? 03 3C ?? ?? 63 24 00 00 66 8C 04 00 67 8C 21 20 00 01 21 28 20 01 01 00 D6 26 ?? ?? ?? 0? 18 00 B6 AF 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 A0 40 00 21 28 80 02 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 44 00 A8 AF 6B 02 40 10 21 20 C0 03 ?? ?? ?? 0? 21 28 80 02 20 00 A2 AF 25 10 43 00 21 B0 60 00 68 02 40 14 44 00 A8 8F 02 00 02 29 65 FD 40 10 34 00 A3 8F ?? ?? ?? 0? 20 00 A4 8F 34 00 A3 8F 38 00 A2 8F ?? ?? C4 8C ?? ?? C5 8C 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 45 FD 40 1C 00 01 E2 32 01 00 D6 26 ?? ?? ?? 0? 18 00 B6 AF 91 FE 40 10 00 00 00 00 90 02 C0 06 21 20 C0 03 ?? ?? ?? 0? 21 28 80 02 21 40 40 00 21 B0 60 00 25 10 16 01 0F 00 40 10 21 30 00 00 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 13 00 07 24 04 00 64 8C 01 00 42 24 2B 28 C4 02 06 00 A0 14 21 30 40 00 79 02 96 50 }
	condition:
		$1
}

rule file_1077_0_0 {
	meta:
		name = "_cleanup"
		size = 88
		refs = "0000 _atexitptr 0024 _iob 0034 fclose"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C E0 FF BD 27 1C 00 BF AF 18 00 B1 AF 03 00 40 10 14 00 B0 AF 09 F8 40 00 00 00 00 00 ?? ?? 11 3C ?? ?? 31 26 A0 00 30 26 21 20 20 02 ?? ?? ?? 0? 14 00 31 26 FD FF 30 16 21 20 20 02 1C 00 BF 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_1099_0_0 {
	meta:
		name = "strcmp"
		size = 44
	strings:
		$1 = { 00 00 83 80 00 00 A2 90 01 00 84 24 23 10 62 00 20 14 02 7C 03 00 40 14 01 00 A5 24 F9 FF 60 54 00 00 83 80 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_1110_2_0 {
	meta:
		name = "_dvfprintf_cdeEgGnopuxX"
		size = 6776
		refs = "009c _ctype 0164 fputc 0470 dpcmp 04e0 dpadd 055c dpdiv 0568 __fixunsdfdi 0694 __udivdi3 06a8 __umoddi3 0760 dpmul 0c54 dptoul 0f38 __floatunsidf 0f54 dpsub 1034 frexp 1260 __floatundidf"
		altNames = "_dvfprintf_cdeEgGnopsuxX"
	strings:
		$1 = { 90 FF BD 27 50 00 B2 AF 4C 00 B1 AF 48 00 B0 AF 6C 00 BF AF 68 00 BE AF 64 00 B7 AF 60 00 B6 AF 5C 00 B5 AF 58 00 B4 AF 54 00 B3 AF 21 90 80 00 21 88 A0 00 78 00 A6 AF 34 00 A0 AF 38 00 A0 AF 21 80 00 00 00 00 24 82 68 00 80 10 10 00 A4 A3 25 00 02 24 C0 02 82 14 01 00 33 26 02 00 24 26 FF FF 82 80 2D 00 06 24 21 18 00 00 30 00 08 24 20 00 07 24 2B 00 09 24 B4 02 46 10 FF FF 91 24 2E 00 45 28 AA 02 A0 10 00 00 00 00 BC 02 47 50 01 00 63 34 B8 02 49 50 02 00 63 34 ?? ?? 05 3C ?? ?? A4 24 21 28 82 00 01 00 A5 90 02 00 67 30 FE FF 66 30 0B 18 C7 00 08 00 67 30 FB FF 66 30 04 00 A5 30 B0 02 A0 10 0B 18 C7 00 21 98 00 00 0A 00 06 24 02 28 66 72 01 00 31 26 21 98 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF 73 26 2E 00 05 24 AE 02 45 50 01 00 31 26 00 10 63 34 21 B0 00 00 ?? ?? 07 3C ?? ?? E6 24 10 00 08 24 00 80 07 24 FF 00 44 30 79 00 85 2C 10 00 A2 A3 3D 00 A0 14 01 00 31 26 10 00 B5 27 01 00 17 24 04 00 C0 12 2B 10 F3 02 2B 10 D7 02 0B B8 C2 02 2B 10 F3 02 08 00 76 30 23 98 77 02 0B 00 C0 16 0A 98 02 00 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 ?? ?? ?? 0? FF FF 14 24 21 28 40 02 ?? ?? ?? 0? 01 00 B5 26 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF F7 26 F8 FF F4 56 00 00 A4 82 A5 FF C0 52 00 00 24 82 ?? ?? ?? 0? FF FF 14 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 FF FF 73 26 F9 FF 74 16 20 00 04 24 00 00 24 82 9A FF 80 14 10 00 A4 A3 6C 00 BF 8F 21 10 00 02 68 00 BE 8F 64 00 B7 8F 60 00 B6 8F 5C 00 B5 8F 58 00 B4 8F 54 00 B3 8F 50 00 B2 8F 4C 00 B1 8F 48 00 B0 8F 08 00 E0 03 70 00 BD 27 80 20 04 00 21 20 C4 00 00 00 82 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 63 34 80 00 63 34 00 07 62 30 1F 01 40 10 21 B8 60 00 00 10 65 30 06 00 04 24 10 00 62 30 81 02 40 10 0B B0 85 00 78 00 A2 8F 07 00 44 24 F8 FF 02 24 24 10 82 00 00 00 5E 8C 04 00 54 8C 08 00 44 24 78 00 A4 AF 21 20 C0 03 21 28 80 02 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 3C 00 A3 AF 04 00 41 04 3C 00 A3 8F 00 80 02 3C 26 A0 82 02 03 00 77 34 21 20 C0 03 21 28 80 02 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 18 00 A0 AF E1 02 40 14 21 A8 00 00 00 01 E2 32 D8 01 40 14 00 02 E2 32 D4 01 40 14 FC FF A2 2A 19 00 C2 2A 0B 00 40 10 18 00 A8 8F ?? ?? ?? 0? FF 00 C4 32 21 30 40 00 21 20 C0 03 21 28 80 02 ?? ?? ?? 0? 21 38 60 00 21 F0 40 00 21 A0 60 00 18 00 A8 8F 0A 00 02 29 16 03 40 14 21 20 C0 03 34 00 A3 8F 38 00 A2 8F ?? ?? 06 3C ?? ?? C7 8C ?? ?? C6 8C 21 20 60 00 21 28 40 00 ?? ?? ?? 0? 44 00 A8 AF CE 04 40 04 44 00 A8 8F EE FF 08 25 18 00 A8 AF 21 20 00 01 ?? ?? ?? 0? 44 00 A8 AF 38 00 A3 AF 34 00 A2 AF 21 18 40 00 38 00 A2 8F 21 20 C0 03 21 30 60 00 21 28 80 02 ?? ?? ?? 0? 21 38 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 44 00 A8 8F 20 00 A2 AF 21 A8 60 00 28 00 A0 AF 2C 00 A0 AF 01 00 02 24 26 05 A0 12 10 00 A2 A3 ?? ?? 03 3C ?? ?? 63 24 21 10 00 00 02 00 0A 24 02 00 05 24 ?? ?? ?? 0? 12 00 09 24 21 50 A0 00 04 00 64 8C 2B 30 A4 02 FD 04 C0 14 02 00 47 24 F7 04 95 50 00 00 64 8C 01 00 A5 24 01 00 42 24 20 2C 05 7C F5 FF 49 14 08 00 63 24 10 00 A5 A3 14 00 07 24 23 A0 68 02 23 A0 96 02 2B 10 16 00 23 A0 87 02 03 00 E3 32 23 A0 82 02 2B 18 03 00 04 00 E2 32 CB 04 40 10 23 A0 83 02 02 00 E2 32 EC 04 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 80 1A 08 00 FE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 08 00 FE 32 ?? ?? 13 3C 21 B8 20 02 ?? ?? 73 26 ?? ?? ?? 0? 20 00 B1 8F C0 18 03 00 21 18 63 02 00 00 66 8C 04 00 67 8C 21 20 20 02 ?? ?? ?? 0? 21 28 A0 02 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 10 00 A2 83 FF FF 43 24 20 1C 03 7C EA FF 40 14 10 00 A3 A3 18 00 A2 8F 0B 00 40 18 21 88 E0 02 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 18 00 A3 8F 27 10 02 00 2B 10 02 00 FF FF 63 24 21 80 02 02 F7 FF 60 1C 18 00 A3 AF 13 00 C2 2A 81 04 40 14 20 14 16 7C 12 00 02 24 10 00 A2 A3 EE FF D6 26 2E 00 04 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 02 00 43 10 10 00 B3 83 01 00 10 26 ?? ?? ?? 0? 21 20 60 02 21 20 40 00 21 28 60 00 2C 00 A2 8F 28 00 A3 8F 21 38 40 00 ?? ?? ?? 0? 21 30 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 FF FF 64 26 20 24 04 7C 21 A8 40 00 2B 00 60 12 10 00 A4 A3 ?? ?? 02 3C ?? ?? 42 24 21 98 20 02 20 00 A2 AF 21 40 60 00 21 B8 A0 02 21 88 40 00 C0 20 04 00 21 20 24 02 00 00 86 8C 04 00 87 8C 21 28 00 01 21 20 E0 02 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 0A 00 06 24 21 38 00 00 ?? ?? ?? 0? 21 28 60 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 B5 83 44 00 A8 8F 27 10 02 00 C0 18 15 00 21 18 23 02 00 00 66 8C 04 00 67 8C 21 20 E0 02 2B 10 02 00 21 28 00 01 ?? ?? ?? 0? 21 80 02 02 FF FF A4 26 20 24 04 7C 21 B8 40 00 21 40 60 00 DF FF A0 16 10 00 A4 A3 21 88 60 02 09 00 C0 12 00 00 00 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF D6 26 F9 FF C0 16 21 80 02 02 FB FD C0 53 00 00 24 82 F9 FD 80 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 94 26 F9 FF 80 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 20 00 63 34 00 01 63 34 00 07 62 30 E3 FE 40 14 21 B8 60 00 C0 00 62 30 6E 01 40 14 20 16 03 7C D7 03 40 04 78 00 A7 8F 10 00 62 30 04 02 40 10 78 00 A5 8F 78 00 A2 8F 00 00 44 8C 04 00 42 24 78 00 A2 AF C3 17 04 00 21 A8 80 00 21 B8 40 00 05 00 41 04 23 10 02 00 23 A8 04 00 2B 20 15 00 03 00 63 34 23 B8 44 00 03 00 C0 16 C0 00 74 30 25 B0 B7 02 01 00 D6 2E 40 00 02 24 2E 03 82 12 41 00 82 2A 04 03 40 10 80 00 02 24 16 00 80 16 10 00 BE 83 01 00 02 24 44 04 E0 12 10 00 A2 A3 ?? ?? 02 3C ?? ?? 42 24 02 00 06 24 02 00 1E 24 ?? ?? ?? 0? 14 00 07 24 21 30 C0 03 04 00 44 8C 2B 28 E4 02 40 03 A0 54 10 00 A6 A3 BA 03 97 50 00 00 44 8C 01 00 DE 27 20 F4 1E 7C F6 FF C7 17 08 00 42 24 10 00 BE A3 2A 10 D6 03 E8 02 40 10 2A 10 DE 02 20 F4 16 7C 10 00 BE A3 05 00 60 12 00 40 62 30 03 00 62 30 2B 10 02 00 23 98 62 02 00 40 62 30 05 00 40 10 2A 20 D3 03 2A 10 D3 02 23 98 76 02 0A 98 02 00 2A 20 D3 03 04 00 62 30 23 F0 7E 02 B8 02 40 10 0A F0 04 00 02 00 62 30 F5 02 40 10 01 00 62 30 01 00 65 30 2D 00 02 24 2B 00 04 24 0B 20 45 00 21 28 40 02 ?? ?? ?? 0? 3C 00 A3 AF 27 10 02 00 3C 00 A3 8F 2B 10 02 00 21 80 02 02 08 00 64 30 0D 00 C0 13 28 00 A4 AF 21 98 60 00 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF DE 27 F9 FF C0 17 21 80 02 02 08 00 65 32 21 18 60 02 28 00 A5 AF FF FF D6 26 ?? ?? 02 3C C0 98 16 00 ?? ?? 42 24 21 98 53 00 03 00 02 24 80 40 16 00 40 20 17 00 02 B0 C2 72 20 00 63 30 41 00 82 2A 2C 00 BE AF 30 00 B1 AF 20 00 A3 AF 21 F0 80 00 ?? ?? ?? 0? 21 88 40 00 10 00 80 16 10 00 A4 83 00 00 66 8E 04 00 67 8E 21 20 A0 02 21 28 E0 02 ?? ?? ?? 0? 44 00 A8 AF 21 20 40 00 21 28 60 00 0A 00 06 24 ?? ?? ?? 0? 21 38 00 00 30 00 42 24 44 00 A8 8F 20 24 02 7C 10 00 A4 A3 21 28 40 02 ?? ?? ?? 0? 44 00 A8 AF 44 00 A8 8F 27 10 02 00 2B 10 02 00 21 80 02 02 F8 FF 73 26 FC FF 08 25 FD FF D6 26 FD FF 02 24 5C 02 C2 12 40 00 02 24 50 02 82 12 27 10 16 00 DF FF 20 16 80 00 02 24 3A 02 82 12 C0 00 02 24 DD FF 82 12 10 00 A4 83 ?? ?? ?? 0? 21 28 40 02 20 00 63 34 ?? ?? ?? 0? 00 02 63 34 5B FD 48 14 ?? ?? 05 3C 04 00 63 34 01 00 84 24 FF FF 82 80 4E FD 46 14 FF FF 91 24 08 00 63 34 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 21 28 40 02 FF FF 03 24 26 18 43 00 2B 18 03 00 21 88 60 02 ?? ?? ?? 0? 21 80 03 02 ?? ?? ?? 0? 01 00 84 24 ?? ?? ?? 0? 01 00 84 24 2A 00 05 24 5A FD 45 14 21 98 00 00 78 00 A6 8F 01 00 31 26 00 00 22 82 00 00 D3 8C 2E 00 05 24 04 00 C6 24 55 FD 45 14 78 00 A6 AF 01 00 31 26 00 00 22 82 2A 00 05 24 9B 02 45 10 00 40 63 34 21 28 82 00 01 00 A5 90 21 B0 00 00 04 00 A5 30 4C FD A0 10 0A 00 06 24 02 28 C6 72 01 00 31 26 21 B0 A2 00 00 00 22 82 21 28 82 00 01 00 A5 90 04 00 A5 30 F8 FF A0 14 D0 FF D6 26 ?? ?? ?? 0? ?? ?? 07 3C 70 01 40 10 2A 10 B6 02 03 01 C0 12 21 10 00 00 40 02 E2 7E 23 B0 C2 02 13 00 C2 2E FD 00 40 14 12 00 02 24 10 00 A2 A3 21 20 C0 03 21 28 80 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 AB 00 40 14 10 00 AA 83 21 28 80 02 ?? ?? ?? 0? 21 20 C0 03 21 A0 40 00 18 00 B5 8F ?? ?? 02 3C ?? ?? 42 24 20 00 A2 AF FB FF 73 26 03 00 E2 32 63 00 B5 26 2B 10 02 00 23 98 76 02 C7 00 B5 2E 23 98 62 02 01 00 B5 2E 04 00 E2 32 7D 00 40 10 23 98 75 02 02 00 E2 32 12 01 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 0A 00 60 5A 08 00 FE 32 30 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 08 00 FE 32 10 00 A2 83 20 00 A3 8F 21 20 80 02 C0 10 02 00 21 10 62 00 00 00 46 8C 04 00 47 8C ?? ?? ?? 0? 21 28 00 00 30 00 44 24 ?? ?? ?? 0? 21 28 40 02 10 00 A3 83 20 00 A4 8F 27 10 02 00 C0 18 03 00 21 18 83 00 00 00 66 8C 04 00 67 8C 2B 10 02 00 21 20 80 02 21 28 00 00 ?? ?? ?? 0? 21 80 02 02 21 A0 40 00 3F 02 C0 16 21 A8 60 00 20 00 F7 32 02 00 E0 16 45 00 04 24 65 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A2 8F 8D 02 40 04 2B 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 21 80 02 02 18 00 A3 8F 64 00 62 28 75 02 40 10 64 00 14 24 0A 00 14 24 1A 00 74 00 F4 01 80 02 21 28 40 02 12 20 00 00 ?? ?? ?? 0? 30 00 84 24 18 00 A3 8F 27 10 02 00 2B 10 02 00 1A 00 74 00 F4 01 80 02 21 28 40 02 21 80 02 02 10 20 00 00 ?? ?? ?? 0? 30 00 84 24 27 10 02 00 2B 10 02 00 8E FC C0 13 21 80 02 02 8D FC 60 5A 00 00 24 82 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 ?? ?? ?? 0? 00 00 24 82 78 00 A5 8F F8 FF 02 24 07 00 A4 24 24 10 82 00 00 00 5E 8C 04 00 54 8C 08 00 42 24 ?? ?? ?? 0? 78 00 A2 AF 61 02 40 04 10 00 62 30 93 00 40 10 78 00 A4 8F 78 00 A2 8F 21 B8 00 00 00 00 55 8C 04 00 42 24 ?? ?? ?? 0? 78 00 A2 AF 08 00 FE 32 0C 00 C0 17 02 00 E2 32 0A 00 60 1A 00 00 00 00 20 00 04 24 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 FF FF 73 26 F9 FF 60 16 21 80 02 02 02 00 E2 32 9F 00 40 10 01 00 E2 32 01 00 E4 32 2D 00 02 24 2B 00 03 24 0A 10 64 00 21 20 40 00 ?? ?? ?? 0? 21 28 40 02 27 10 02 00 2B 10 02 00 ?? ?? ?? 0? 21 80 02 02 23 20 AA 02 ?? ?? ?? 0? 40 00 AA AF 21 30 40 00 21 38 60 00 21 20 C0 03 ?? ?? ?? 0? 21 28 80 02 21 48 60 00 21 40 40 00 21 28 20 01 21 20 40 00 44 00 A8 AF ?? ?? ?? 0? 3C 00 A9 AF 21 20 40 00 ?? ?? ?? 0? 21 F0 40 00 44 00 A8 8F 3C 00 A9 8F 21 30 40 00 21 20 00 01 21 28 20 01 ?? ?? ?? 0? 21 38 60 00 ?? ?? 07 3C ?? ?? E7 24 00 00 E4 8C 04 00 E5 8C 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 44 00 A8 8F 3C 00 A9 8F 12 00 40 1C 40 00 AA 8F ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 01 ?? ?? ?? 0? 21 28 20 01 21 48 60 00 21 40 40 00 21 28 20 01 21 20 40 00 44 00 A8 AF ?? ?? ?? 0? 3C 00 A9 AF 40 00 AA 8F 3C 00 A9 8F 44 00 A8 8F 21 F0 40 00 ?? ?? 02 3C 01 00 43 25 C0 18 03 00 ?? ?? 42 24 20 00 A2 AF 21 10 43 00 04 00 43 8C 44 00 60 10 21 A0 C0 03 20 00 A4 8F C0 50 0A 00 21 50 8A 00 04 00 42 8D }
	condition:
		$1
}

rule file_1113_0_0 {
	meta:
		name = "setvbuf"
		size = 252
		refs = "009c _buffree 00dc _bufallo"
	strings:
		$1 = { E0 FF BD 27 04 00 02 24 18 00 B0 AF 1C 00 BF AF 1B 00 C2 10 21 80 80 00 00 01 02 24 03 00 C2 10 00 00 00 00 12 00 C0 14 FF FF 02 24 27 00 A0 50 08 00 05 8E 0C 00 02 96 08 00 42 34 0C 00 02 A6 0C 00 02 96 08 00 05 AE 10 00 07 AE FB FE 42 30 25 30 C2 00 0C 00 06 A6 04 00 00 AE 21 10 00 00 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 1C 00 BF 8F 18 00 B0 8F 08 00 E0 03 20 00 BD 27 0C 00 82 94 08 00 42 30 07 00 40 54 0C 00 02 96 08 00 84 8C 04 00 80 50 0C 00 02 96 ?? ?? ?? 0? 00 00 00 00 0C 00 02 96 00 00 00 AE 08 00 00 AE F7 FE 42 30 04 00 42 34 0C 00 02 A6 10 00 00 AE 04 00 00 AE ?? ?? ?? 0? 21 10 00 00 03 00 A0 10 00 00 00 00 ?? ?? ?? 0? 10 00 07 8E ?? ?? ?? 0? 10 00 A6 AF 21 28 40 00 10 00 A6 8F E0 FF A0 10 FF FF 02 24 ?? ?? ?? 0? 20 00 07 24 }
	condition:
		$1
}

rule file_1113_1_0 {
	meta:
		name = "setbuf"
		size = 28
		refs = "0008 setvbuf"
	strings:
		$1 = { 03 00 A0 10 21 30 00 00 ?? ?? ?? 0? 20 00 07 24 04 00 06 24 ?? ?? ?? 0? 21 38 00 00 }
	condition:
		$1
}

rule file_1117_0_0 {
	meta:
		name = "memmove"
		size = 100
	strings:
		$1 = { 2B 18 A4 00 21 10 80 00 0D 00 60 10 21 38 A0 00 21 28 A6 00 2B 18 45 00 09 00 60 10 21 18 46 00 23 30 66 00 FF FF A5 24 00 00 A4 90 FF FF 63 24 FC FF 66 14 00 00 64 A0 08 00 E0 03 00 00 00 00 FD FF C0 10 21 30 46 00 00 00 E3 90 00 00 83 A0 01 00 84 24 FC FF 86 14 01 00 E7 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_1143_0_0 {
	meta:
		name = "fgets"
		size = 240
		refs = "004c fgetc"
	strings:
		$1 = { D0 FF BD 27 02 00 A2 28 24 00 B4 AF 1C 00 B2 AF 2C 00 BF AF 28 00 B5 AF 20 00 B3 AF 18 00 B1 AF 14 00 B0 AF 21 90 80 00 1A 00 40 14 21 A0 C0 00 FF FF 90 24 21 80 05 02 21 A8 80 00 FF FF 11 24 0A 00 13 24 08 00 B0 12 21 20 80 02 ?? ?? ?? 0? 00 00 00 00 04 00 51 10 00 00 00 00 00 00 A2 A2 F8 FF 53 14 01 00 B5 26 15 00 55 12 2C 00 BF 8F 21 10 40 02 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 30 00 BD 27 2C 00 BF 8F 21 90 00 00 21 10 40 02 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 30 00 BD 27 00 00 40 A2 2C 00 BF 8F 21 90 00 00 21 10 40 02 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 30 00 BD 27 }
	condition:
		$1
}

rule file_1143_1_0 {
	meta:
		name = "gets"
		size = 76
		refs = "0018 fgets 0004 _iob 0028 strlen"
	strings:
		$1 = { FF 7F 05 3C ?? ?? 06 3C E8 FF BD 27 FF FF A5 34 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? ?? ?? C6 24 05 00 40 10 21 80 40 00 ?? ?? ?? 0? 21 20 40 00 21 10 02 02 FF FF 40 A0 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_1178_0_0 {
	meta:
		name = "signal"
		size = 48
	strings:
		$1 = { FF FF 84 24 06 00 83 2C 07 00 60 10 FF FF 02 24 ?? ?? 02 3C ?? ?? 42 24 80 20 04 00 21 20 82 00 00 00 82 8C 00 00 85 AC 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_1178_1_0 {
	meta:
		name = "raise"
		size = 112
		refs = "0068 exit"
	strings:
		$1 = { FF FF 82 24 E0 FF BD 27 06 00 43 2C 12 00 60 10 1C 00 BF AF ?? ?? 03 3C ?? ?? 63 24 80 10 02 00 21 10 43 00 00 00 43 8C 0F 00 60 10 FF FF 02 24 06 00 62 10 01 00 05 24 04 00 65 10 21 10 00 00 09 F8 60 00 10 00 A2 AF 10 00 A2 8F 1C 00 BF 8F 08 00 E0 03 20 00 BD 27 1C 00 BF 8F FF FF 02 24 08 00 E0 03 20 00 BD 27 ?? ?? ?? 0? 01 00 04 24 }
	condition:
		$1
}

rule file_1178_2_0 {
	meta:
		name = "abort"
		size = 24
		refs = "0008 raise 0010 exit"
	strings:
		$1 = { E8 FF BD 27 14 00 BF AF ?? ?? ?? 0? 01 00 04 24 ?? ?? ?? 0? 01 00 04 24 }
	condition:
		$1
}

rule file_1185_0_0 {
	meta:
		name = "memset"
		size = 40
	strings:
		$1 = { 07 00 C0 10 21 10 80 00 21 18 80 00 21 30 86 00 00 00 65 A0 01 00 63 24 FE FF 66 54 00 00 65 A0 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_1203_0_0 {
	meta:
		name = "ymd_to_scalar"
		size = 176
	strings:
		$1 = { 01 00 A3 24 F1 0B 02 24 02 10 62 70 EB 51 03 3C 1F 85 63 34 02 00 A5 2C 41 F4 42 24 19 00 43 00 10 18 00 00 42 11 03 00 08 00 A0 14 21 30 46 00 90 01 02 24 1B 00 82 00 F4 01 40 00 10 18 00 00 11 00 60 14 01 00 02 24 23 30 C2 00 EB 51 02 3C FF FF 84 24 1F 85 42 34 19 00 82 00 6D 01 03 24 82 10 04 00 10 48 00 00 02 28 83 70 42 19 09 00 21 20 A2 00 C2 29 09 00 21 10 85 00 23 10 43 00 08 00 E0 03 21 10 C2 00 03 00 83 30 EE FF 60 14 02 00 02 24 64 00 03 24 1B 00 83 00 F4 01 60 00 01 00 05 24 10 18 00 00 ?? ?? ?? 0? 0B 10 A3 00 }
	condition:
		$1
}

rule file_1203_1_0 {
	meta:
		name = "mktime"
		size = 252
	strings:
		$1 = { E0 FF BD 27 14 00 B1 AF 14 00 91 8C 10 00 B0 AF 1C 00 BF AF BA FF 23 26 0F 01 63 2C 18 00 B2 AF 21 80 80 00 2F 00 60 10 FF FF 02 24 10 00 85 8C 0C 00 86 8C 6C 07 24 26 ?? ?? ?? 0? 6B 07 31 26 B2 07 04 24 21 28 00 00 01 00 06 24 ?? ?? ?? 0? 21 90 40 00 23 20 42 02 07 00 03 24 1A 00 83 00 F4 01 60 00 18 00 0A 24 08 00 02 8E 3C 00 05 24 04 00 09 8E 82 40 11 00 00 00 07 8E 10 30 00 00 04 00 C6 24 02 58 8A 70 1A 00 C3 00 F4 01 60 00 21 10 62 01 10 18 00 00 18 00 03 AE EB 51 03 3C 1F 85 63 34 02 20 45 70 19 00 23 02 6D 01 03 24 21 10 89 00 10 58 00 00 C2 31 0B 00 02 20 23 72 42 19 0B 00 21 88 88 00 02 20 45 70 21 88 26 02 23 88 23 02 27 88 11 00 21 90 32 02 1C 00 12 AE 21 10 87 00 1C 00 BF 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "ieee754sp_nfrexp"
		size = 136
	strings:
		$1 = { C0 3D 83 7C 21 10 80 00 FF FF 64 24 FE 00 84 2C C2 3F 02 00 0E 00 80 10 00 B0 46 7C 80 00 02 3C 81 FF 63 24 25 30 C2 00 00 3A 07 00 7F FF 02 3C FF FF 42 34 7E 00 E7 34 01 00 63 24 24 30 C2 00 C0 3D 07 00 00 00 A3 AC 08 00 E0 03 25 10 C7 00 03 00 60 10 00 00 00 00 08 00 E0 03 00 00 A0 AC 07 00 C0 50 00 00 A0 AC 20 10 C2 70 F8 FF 42 24 82 FF 03 24 04 30 46 00 ?? ?? ?? 0? 23 18 62 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_2_1_1 {
	meta:
		name = "ieee754sp_frexp"
		size = 52
		refs = "0014 ieee754sp_nfrexp"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 80 80 00 21 20 A0 00 14 00 BF AF ?? ?? ?? 0? 21 28 C0 00 00 00 02 AE 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_85_1_1 {
	meta:
		name = "ieee754sp_modf"
		size = 52
		refs = "0014 ieee754sp_nmodf"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 80 80 00 21 20 A0 00 14 00 BF AF ?? ?? ?? 0? 21 28 C0 00 00 00 02 AE 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_3_0_1 {
	meta:
		name = "__sqrtsf2"
		size = 240
		altNames = "ieee754sp_nsqrt"
	strings:
		$1 = { C0 3D 83 7C FF FF 66 24 FE 00 C6 2C C2 2F 04 00 2B 00 C0 10 00 B0 82 7C 80 00 04 3C 81 FF 63 24 25 10 44 00 22 00 A0 14 01 00 65 30 40 20 02 00 0B 10 85 00 43 48 03 00 40 10 02 00 19 00 04 24 00 01 03 3C 21 40 00 00 21 38 00 00 21 28 E3 00 2B 30 45 00 04 00 C0 14 FF FF 84 24 21 38 A3 00 23 10 45 00 21 40 03 01 40 10 02 00 F7 FF 80 14 42 18 03 00 08 00 40 54 01 00 02 31 43 20 08 00 00 3F 02 3C 21 20 82 00 C0 1D 09 00 21 20 83 00 08 00 E0 03 21 10 80 00 ?? ?? ?? 0? 21 40 48 00 04 00 40 54 BF 7F 04 3C 0F 00 A0 50 21 10 80 00 BF 7F 04 3C FF FF 84 34 08 00 E0 03 21 10 80 00 F7 FF 60 14 00 00 00 00 07 00 40 50 21 10 80 00 20 18 43 70 F8 FF 63 24 82 FF 04 24 04 10 62 00 ?? ?? ?? 0? 23 18 83 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_4_0_1 {
	meta:
		name = "ieee754dp_mul"
		size = 1068
		refs = "024c __lshrdi3 03b0 __ashldi3"
		altNames = "__muldf3"
	strings:
		$1 = { B8 FF BD 27 20 00 B0 AF 00 55 B0 7C FF FF 02 26 FE 07 42 2C 40 00 BE AF 3C 00 B7 AF 34 00 B5 AF 24 00 B1 AF 44 00 BF AF 38 00 B6 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 21 88 C0 00 C2 F7 05 00 21 B8 80 00 A1 00 40 10 00 98 B5 7C 10 00 02 3C 25 A8 A2 02 01 FC 10 26 21 10 00 00 00 55 F4 7C FF FF 83 26 FE 07 63 2C C2 47 07 00 21 B0 20 02 82 00 60 10 00 98 E7 7C 10 00 03 3C 25 38 E3 00 01 FC 94 26 21 48 00 00 82 00 40 14 21 18 40 00 42 15 16 00 C0 3A 07 00 25 38 47 00 C0 4A 17 00 19 00 E9 00 42 BD 17 00 C0 AA 15 00 25 A8 F5 02 C0 B2 16 00 26 F0 1E 01 21 80 90 02 10 18 00 00 12 10 00 00 19 00 B6 02 12 50 00 00 10 58 00 00 21 40 6B 00 2B 28 03 01 19 00 C9 02 10 B8 00 00 21 10 E2 02 21 18 4A 00 12 B0 00 00 25 B0 76 00 2B B0 16 00 13 00 00 01 11 00 A0 00 2B 28 57 00 2B 10 62 00 01 00 F5 70 21 10 45 00 12 30 00 00 21 10 C2 00 2B 18 46 00 10 38 00 00 21 18 67 00 3A 00 60 04 25 10 56 00 C2 21 02 00 40 2E 03 00 7F 00 42 30 25 20 A4 00 2B 10 02 00 25 B0 44 00 C2 B9 03 00 FF 03 10 26 39 00 00 1A 01 00 02 24 07 00 C3 32 1D 00 60 14 C0 00 C2 7E FF 07 02 2A 55 00 40 10 C2 10 17 00 40 27 17 00 C2 B0 16 00 00 05 43 7C 4E 00 60 10 25 B0 96 00 00 98 42 7C C0 F2 1E 00 25 80 1E 02 00 85 10 00 21 90 C0 02 25 98 02 02 44 00 BF 8F 21 10 40 02 21 18 60 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 03 00 42 24 21 10 C2 02 2B 18 56 00 21 18 77 00 21 B0 40 00 00 06 62 7C DD FF 40 10 21 B8 60 00 42 10 16 00 C0 1F 03 00 25 18 62 00 42 10 17 00 21 B0 60 00 21 B8 40 00 ?? ?? ?? 0? 01 00 10 26 02 22 02 00 00 2E 03 00 FF 00 42 30 25 20 A4 00 2B 10 02 00 25 B0 44 00 02 BA 03 00 ?? ?? ?? 0? 01 00 10 26 23 80 50 00 38 00 02 2A 2D 00 40 50 01 00 16 24 21 30 00 02 21 20 C0 02 23 80 10 00 ?? ?? ?? 0? 21 28 E0 02 20 00 06 32 03 00 C0 14 04 20 16 02 04 80 17 02 25 20 16 02 2B 20 04 00 25 B0 82 00 21 B8 60 00 ?? ?? ?? 0? 01 00 10 24 1F 00 80 16 25 18 27 02 28 00 60 14 02 00 09 24 01 00 09 24 01 00 43 34 01 00 05 24 26 00 65 54 F7 7F 13 3C 26 40 1E 01 C0 9F 08 00 ?? ?? ?? 0? 21 90 00 00 ?? ?? ?? 0? 21 80 00 00 C0 F2 1E 00 FF 07 DE 37 00 9D 1E 00 ?? ?? ?? 0? 21 90 00 00 10 00 00 56 25 28 95 00 25 18 95 00 02 00 02 24 02 FC 10 24 01 00 05 24 0A 10 A3 00 ?? ?? ?? 0? 0A 80 03 00 21 B8 00 00 ?? ?? ?? 0? 01 00 10 24 08 00 60 54 08 00 09 24 04 00 09 24 ?? ?? ?? 0? 04 00 43 34 04 00 02 24 08 00 03 24 ?? ?? ?? 0? 0B 10 65 00 ?? ?? ?? 0? 08 00 43 34 02 FC 14 24 ?? ?? ?? 0? 02 00 43 34 08 00 65 30 FF FF 12 24 95 FF A0 14 FF FF 73 36 04 00 65 30 09 00 A0 10 01 00 63 30 91 FF 60 14 44 00 BF 8F 26 10 1E 01 C0 12 02 00 FF 07 42 34 00 9D 02 00 ?? ?? ?? 0? 21 90 00 00 CB FF 60 14 02 00 42 30 17 00 40 50 02 00 29 31 03 00 A0 16 20 50 AA 72 20 50 8A 70 20 00 4A 25 F5 FF 4A 25 10 00 40 51 02 00 29 31 21 28 A0 02 21 30 40 01 14 00 A7 AF 1C 00 A8 AF 18 00 A9 AF ?? ?? ?? 0? 10 00 AA AF 10 00 AA 8F 18 00 A9 8F 1C 00 A8 8F 14 00 A7 8F 21 B8 40 00 21 A8 60 00 23 80 0A 02 02 00 29 31 2E FF 20 11 42 15 16 00 03 00 E0 14 20 48 E9 70 20 48 29 72 20 00 29 25 F5 FF 29 25 27 FF 20 51 42 15 16 00 21 28 E0 00 21 30 20 01 21 20 20 02 1C 00 A8 AF ?? ?? ?? 0? 18 00 A9 AF 18 00 A9 8F 21 B0 40 00 21 38 60 00 23 A0 89 02 ?? ?? ?? 0? 1C 00 A8 8F }
	condition:
		$1
}

rule file_5_0_1 {
	meta:
		name = "__ledf2"
		size = 104
		refs = "003c __orderdf2"
		altNames = "__eqdf2 __ltdf2 __nedf2"
	strings:
		$1 = { F0 7F 02 3C 00 F0 A3 7C 01 00 48 24 2B 40 68 00 0E 00 00 51 01 00 02 24 0E 00 62 10 00 00 00 00 00 F0 E3 7C 01 00 48 24 2B 40 68 00 07 00 00 51 01 00 02 24 03 00 62 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 FD FF C0 10 01 00 02 24 08 00 E0 03 00 00 00 00 F2 FF 80 50 F0 7F 02 3C 01 00 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_6_0_1 {
	meta:
		name = "ieee754dp_abs"
		size = 24
		altNames = "__absdf2"
	strings:
		$1 = { 00 F0 A3 7C 00 00 A6 28 0B 28 66 00 21 10 80 00 08 00 E0 03 21 18 A0 00 }
	condition:
		$1
}

rule file_7_0_1 {
	meta:
		name = "__strtod"
		size = 1000
		refs = "0030 _ctype 00b8 __muldf3 00c8 __floatsidf 00dc __adddf3 01bc __ldexp 02d0 __negdf2 0380 __divdf3 03c8 errno"
	strings:
		$1 = { C0 FF BD 27 38 00 BE AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 3C 00 BF AF 34 00 B7 AF 30 00 B6 AF 28 00 B4 AF 1C 00 B1 AF 18 00 B0 AF 00 00 82 80 ?? ?? 1E 3C ?? ?? DE 27 21 18 C2 03 01 00 63 80 21 90 80 00 21 98 A0 00 88 00 63 30 08 00 60 10 21 A8 80 00 01 00 B5 26 00 00 A2 82 21 18 C2 03 01 00 63 80 88 00 63 30 FB FF 60 54 01 00 B5 26 2D 00 03 24 BC 00 43 10 2B 00 42 38 01 00 42 2C 21 A0 00 00 21 A8 A2 02 00 00 A2 82 21 18 C2 03 01 00 63 90 04 00 63 30 C2 00 60 10 21 B0 00 00 21 B8 00 00 21 88 00 00 21 28 E0 02 D0 FF 50 24 21 20 C0 02 21 30 00 00 ?? ?? ?? 0? 24 40 07 3C 21 20 00 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 30 40 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 21 38 60 00 01 00 B5 26 21 B0 40 00 00 00 A2 82 21 B8 60 00 21 18 C2 03 01 00 63 90 04 00 63 30 E9 FF 60 14 25 88 30 02 01 00 04 24 2E 00 03 24 71 00 43 50 01 00 B5 26 40 00 80 14 21 40 00 00 02 00 60 12 0A A8 44 02 00 00 75 AE 27 00 00 11 C3 17 08 00 26 98 48 00 ?? ?? 12 3C 23 98 62 02 ?? ?? 52 26 08 00 10 24 21 10 00 00 F0 3F 03 3C ?? ?? ?? 0? FF FF 15 24 0E 00 15 12 F8 FF 52 26 07 20 13 02 01 00 84 30 FB FF 80 10 FF FF 10 26 40 00 46 8E 44 00 47 8E 21 20 40 00 21 28 60 00 10 00 A8 AF ?? ?? ?? 0? F8 FF 52 26 F4 FF 15 16 10 00 A8 8F 77 00 00 05 21 38 60 00 21 20 C0 02 21 28 E0 02 21 30 40 00 ?? ?? ?? 0? 10 00 A8 AF 10 00 A8 8F 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 21 30 00 01 21 B0 40 00 21 B8 60 00 81 00 C0 12 00 F0 E2 7E 25 10 D7 02 79 00 40 10 00 00 00 00 30 00 80 16 3C 00 BF 8F 21 10 C0 02 21 18 E0 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 21 18 40 00 65 00 02 24 03 00 62 10 45 00 02 24 BC FF 62 14 01 00 04 24 01 00 B5 26 00 00 A2 82 2D 00 03 24 55 00 43 50 01 00 B5 26 2B 00 03 24 59 00 43 10 21 30 00 00 21 18 C2 03 01 00 64 90 04 00 84 30 0B 00 80 10 21 18 00 00 0A 00 05 24 02 20 65 70 01 00 B5 26 21 18 82 00 00 00 A2 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 63 24 23 10 03 00 0B 18 46 00 21 40 03 01 ?? ?? ?? 0? 01 00 04 24 21 20 C0 02 21 28 E0 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F ?? ?? ?? 0? 40 00 BD 27 00 00 A3 82 21 10 C3 03 01 00 45 90 04 00 A5 30 8B FF A0 10 21 10 60 00 21 40 00 00 21 28 E0 02 D0 FF 70 24 21 20 C0 02 21 30 00 00 24 40 07 3C ?? ?? ?? 0? 10 00 A8 AF 21 20 00 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 30 40 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 21 38 60 00 01 00 B5 26 21 B8 60 00 00 00 A3 82 21 B0 40 00 10 00 A8 8F 21 10 C3 03 01 00 42 90 25 88 30 02 04 00 42 30 E6 FF 40 14 FF FF 08 25 ?? ?? ?? 0? 65 00 02 24 01 00 B5 26 ?? ?? ?? 0? 01 00 14 24 21 20 C0 02 21 28 E0 02 21 30 40 00 ?? ?? ?? 0? 10 00 A8 AF 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 10 00 A8 8F 00 00 A2 82 ?? ?? ?? 0? 01 00 06 24 21 B8 00 00 21 20 00 00 ?? ?? ?? 0? 21 88 00 00 01 00 B5 26 ?? ?? ?? 0? 00 00 A2 82 87 FF 20 12 22 00 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC F0 7F 03 3C 7F FF 43 14 25 10 D7 02 ?? ?? ?? 0? 22 00 03 24 }
	condition:
		$1
}

rule file_110_0_1 {
	meta:
		name = "ieee754dp_nfstr"
		size = 1000
		refs = "0030 _ctype 00b8 ieee754dp_mul 00c8 ieee754dp_fint 00dc ieee754dp_add 01bc ieee754dp_nldexp 02d0 ieee754dp_neg 0380 ieee754dp_div 03c8 errno"
	strings:
		$1 = { C0 FF BD 27 38 00 BE AF 2C 00 B5 AF 24 00 B3 AF 20 00 B2 AF 3C 00 BF AF 34 00 B7 AF 30 00 B6 AF 28 00 B4 AF 1C 00 B1 AF 18 00 B0 AF 00 00 82 80 ?? ?? 1E 3C ?? ?? DE 27 21 18 C2 03 01 00 63 80 21 90 80 00 21 98 A0 00 88 00 63 30 08 00 60 10 21 A8 80 00 01 00 B5 26 00 00 A2 82 21 18 C2 03 01 00 63 80 88 00 63 30 FB FF 60 54 01 00 B5 26 2D 00 03 24 BC 00 43 10 2B 00 42 38 01 00 42 2C 21 A0 00 00 21 A8 A2 02 00 00 A2 82 21 18 C2 03 01 00 63 90 04 00 63 30 C2 00 60 10 21 B0 00 00 21 B8 00 00 21 88 00 00 21 28 E0 02 D0 FF 50 24 21 20 C0 02 21 30 00 00 ?? ?? ?? 0? 24 40 07 3C 21 20 00 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 30 40 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 21 38 60 00 01 00 B5 26 21 B0 40 00 00 00 A2 82 21 B8 60 00 21 18 C2 03 01 00 63 90 04 00 63 30 E9 FF 60 14 25 88 30 02 01 00 04 24 2E 00 03 24 71 00 43 50 01 00 B5 26 40 00 80 14 21 40 00 00 02 00 60 12 0A A8 44 02 00 00 75 AE 27 00 00 11 C3 17 08 00 26 98 48 00 ?? ?? 12 3C 23 98 62 02 ?? ?? 52 26 08 00 10 24 21 10 00 00 F0 3F 03 3C ?? ?? ?? 0? FF FF 15 24 0E 00 15 12 F8 FF 52 26 07 20 13 02 01 00 84 30 FB FF 80 10 FF FF 10 26 40 00 46 8E 44 00 47 8E 21 20 40 00 21 28 60 00 10 00 A8 AF ?? ?? ?? 0? F8 FF 52 26 F4 FF 15 16 10 00 A8 8F 77 00 00 05 21 38 60 00 21 20 C0 02 21 28 E0 02 21 30 40 00 ?? ?? ?? 0? 10 00 A8 AF 10 00 A8 8F 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 21 30 00 01 21 B0 40 00 21 B8 60 00 81 00 C0 12 00 F0 E2 7E 25 10 D7 02 79 00 40 10 00 00 00 00 30 00 80 16 3C 00 BF 8F 21 10 C0 02 21 18 E0 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 21 18 40 00 65 00 02 24 03 00 62 10 45 00 02 24 BC FF 62 14 01 00 04 24 01 00 B5 26 00 00 A2 82 2D 00 03 24 55 00 43 50 01 00 B5 26 2B 00 03 24 59 00 43 10 21 30 00 00 21 18 C2 03 01 00 64 90 04 00 84 30 0B 00 80 10 21 18 00 00 0A 00 05 24 02 20 65 70 01 00 B5 26 21 18 82 00 00 00 A2 82 21 20 C2 03 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 63 24 23 10 03 00 0B 18 46 00 21 40 03 01 ?? ?? ?? 0? 01 00 04 24 21 20 C0 02 21 28 E0 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F ?? ?? ?? 0? 40 00 BD 27 00 00 A3 82 21 10 C3 03 01 00 45 90 04 00 A5 30 8B FF A0 10 21 10 60 00 21 40 00 00 21 28 E0 02 D0 FF 70 24 21 20 C0 02 21 30 00 00 24 40 07 3C ?? ?? ?? 0? 10 00 A8 AF 21 20 00 02 21 B0 40 00 ?? ?? ?? 0? 21 B8 60 00 21 30 40 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 21 38 60 00 01 00 B5 26 21 B8 60 00 00 00 A3 82 21 B0 40 00 10 00 A8 8F 21 10 C3 03 01 00 42 90 25 88 30 02 04 00 42 30 E6 FF 40 14 FF FF 08 25 ?? ?? ?? 0? 65 00 02 24 01 00 B5 26 ?? ?? ?? 0? 01 00 14 24 21 20 C0 02 21 28 E0 02 21 30 40 00 ?? ?? ?? 0? 10 00 A8 AF 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 10 00 A8 8F 00 00 A2 82 ?? ?? ?? 0? 01 00 06 24 21 B8 00 00 21 20 00 00 ?? ?? ?? 0? 21 88 00 00 01 00 B5 26 ?? ?? ?? 0? 00 00 A2 82 87 FF 20 12 22 00 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC F0 7F 03 3C 7F FF 43 14 25 10 D7 02 ?? ?? ?? 0? 22 00 03 24 }
	condition:
		$1
}

rule file_8_0_1 {
	meta:
		name = "__extendsfdf2"
		size = 168
		altNames = "ieee754dp_fsp"
	strings:
		$1 = { C0 3D 82 7C FF FF 45 24 FE 00 A5 2C C2 1F 04 00 0F 00 A0 10 00 B0 84 7C 80 00 05 3C 81 FF 42 24 25 20 85 00 FF 03 42 24 C0 1A 03 00 25 10 43 00 C4 FD 04 7C 00 15 02 00 C2 28 04 00 40 37 04 00 25 38 45 00 21 10 C0 00 08 00 E0 03 21 18 E0 00 05 00 40 14 00 00 00 00 0D 00 80 14 C0 3F 03 00 ?? ?? ?? 0? 21 30 00 00 05 00 80 50 C0 1A 03 00 F7 7F 07 3C FF FF 06 24 ?? ?? ?? 0? FF FF E7 34 FF 07 63 34 00 3D 03 00 ?? ?? ?? 0? 21 30 00 00 20 10 82 70 F8 FF 42 24 82 FF 05 24 04 20 44 00 ?? ?? ?? 0? 23 10 A2 00 }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "ieee754sp_1e31"
		size = 16
	strings:
		$1 = { 00 12 04 00 9E 00 42 34 08 00 E0 03 C0 15 02 00 }
	condition:
		$1
}

rule file_10_0_1 {
	meta:
		name = "ieee754dp_nldexp"
		size = 464
		refs = "0128 __lshrdi3 01bc __ashldi3"
		altNames = "__ldexp"
	strings:
		$1 = { D8 FF BD 27 18 00 B2 AF 00 55 B2 7C FF FF 42 26 FE 07 42 2C 20 00 B4 AF 1C 00 B3 AF 21 A0 C0 00 24 00 BF AF 14 00 B1 AF 10 00 B0 AF C2 9F 05 00 21 30 80 00 48 00 40 10 00 98 A3 7C 10 00 02 3C 01 FC 52 26 25 18 62 00 FF 03 94 26 42 17 06 00 C0 88 03 00 21 90 92 02 25 88 51 00 2A 00 40 1A C0 80 06 00 07 00 03 32 17 00 60 14 C0 00 02 7E FF 07 42 2A 41 00 40 10 C2 30 11 00 40 1F 11 00 C2 20 10 00 00 05 C2 7C 3A 00 40 10 25 20 64 00 00 98 C6 7C C0 9A 13 00 25 90 53 02 00 1D 12 00 21 10 80 00 25 18 66 00 24 00 BF 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 03 00 42 24 21 10 02 02 2B 18 50 00 21 18 71 00 21 80 40 00 00 06 62 7C E3 FF 40 10 21 88 60 00 42 10 10 00 C0 1F 03 00 25 18 62 00 42 10 11 00 21 80 60 00 21 88 40 00 ?? ?? ?? 0? 01 00 52 26 01 00 02 24 23 90 52 00 38 00 42 2A 1E 00 40 50 01 00 10 24 21 30 40 02 21 20 00 02 23 90 12 00 ?? ?? ?? 0? 21 28 20 02 20 00 46 32 03 00 C0 14 04 20 50 02 04 90 51 02 25 20 50 02 2B 20 04 00 25 80 82 00 21 88 60 00 ?? ?? ?? 0? 01 00 12 24 04 00 40 16 21 10 80 00 25 10 83 00 0D 00 40 14 21 10 80 00 ?? ?? ?? 0? 21 18 A0 00 ?? ?? ?? 0? 21 90 00 00 C0 1A 13 00 FF 07 63 34 00 1D 03 00 ?? ?? ?? 0? 21 10 00 00 21 88 00 00 ?? ?? ?? 0? 01 00 12 24 03 00 60 14 20 88 71 70 20 88 91 70 20 00 31 26 F5 FF 31 26 A5 FF 20 12 02 FC 12 24 21 30 20 02 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 ?? ?? ?? 0? 23 90 51 02 }
	condition:
		$1
}

rule file_10_1_1 {
	meta:
		name = "ieee754dp_ldexp"
		size = 60
		refs = "0018 ieee754dp_nldexp"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 80 80 00 21 20 C0 00 28 00 A6 8F 14 00 BF AF ?? ?? ?? 0? 21 28 E0 00 00 00 02 AE 04 00 03 AE 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_98_1_1 {
	meta:
		name = "ieee754dp_frexp"
		size = 60
		refs = "0018 ieee754dp_nfrexp"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 80 80 00 21 20 C0 00 28 00 A6 8F 14 00 BF AF ?? ?? ?? 0? 21 28 E0 00 00 00 02 AE 04 00 03 AE 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_70_1_1 {
	meta:
		name = "ieee754dp_modf"
		size = 60
		refs = "0018 ieee754dp_nmodf"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 80 80 00 21 20 C0 00 28 00 A6 8F 14 00 BF AF ?? ?? ?? 0? 21 28 E0 00 00 00 02 AE 04 00 03 AE 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_11_0_1 {
	meta:
		name = "__fixdfdi"
		size = 240
		altNames = "ieee754dp_tlong"
	strings:
		$1 = { 00 55 A2 7C FF FF 43 24 FE 07 63 2C C2 4F 05 00 31 00 60 10 00 98 A5 7C 01 FC 43 24 3F 00 68 28 21 30 00 00 1C 00 00 11 00 80 07 3C 21 30 00 00 19 00 60 04 21 38 00 00 10 00 07 3C 35 00 66 28 18 00 C0 14 25 28 A7 00 CD FB 42 24 42 38 04 00 27 30 02 00 04 18 45 00 06 30 C7 00 20 00 45 30 25 18 C3 00 04 10 44 00 21 20 40 00 0A 10 65 00 0B 20 05 00 21 28 40 00 06 00 20 11 21 30 80 00 23 20 04 00 2B 30 04 00 23 28 05 00 23 28 A6 00 21 30 80 00 21 38 A0 00 21 10 C0 00 08 00 E0 03 21 18 E0 00 34 00 02 24 F3 FF 62 10 23 18 43 00 40 30 05 00 27 10 03 00 04 30 46 00 06 20 64 00 20 00 62 30 06 28 65 00 25 20 C4 00 0B 20 A2 00 ?? ?? ?? 0? 0B 28 02 00 21 30 00 00 EE FF 40 10 21 38 00 00 21 30 00 00 ?? ?? ?? 0? 00 80 07 3C }
	condition:
		$1
}

rule file_12_0_1 {
	meta:
		name = "__strtof"
		size = 856
		refs = "0030 _ctype 00ac __mulsf3 00b8 __floatsisf 00c4 __addsf3 0180 __ldexpf 028c __negsf2 0310 __divsf3 034c errno"
	strings:
		$1 = { C8 FF BD 27 2C 00 B7 AF 24 00 B5 AF 1C 00 B3 AF 18 00 B2 AF 34 00 BF AF 30 00 BE AF 28 00 B6 AF 20 00 B4 AF 14 00 B1 AF 10 00 B0 AF 00 00 82 80 ?? ?? 17 3C ?? ?? F7 26 21 18 E2 02 01 00 63 80 21 90 80 00 21 98 A0 00 88 00 63 30 08 00 60 10 21 A8 80 00 01 00 B5 26 00 00 A2 82 21 18 E2 02 01 00 63 80 88 00 63 30 FB FF 60 54 01 00 B5 26 2D 00 03 24 A3 00 43 10 2B 00 42 38 01 00 42 2C 21 A0 00 00 21 A8 A2 02 00 00 A2 82 21 18 E2 02 01 00 63 90 04 00 63 30 A4 00 60 10 21 B0 00 00 21 88 00 00 D0 FF 50 24 21 20 C0 02 ?? ?? ?? 0? 20 41 05 3C 21 20 00 02 ?? ?? ?? 0? 21 B0 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 C0 02 01 00 B5 26 21 B0 40 00 00 00 A2 82 21 18 E2 02 01 00 63 90 04 00 63 30 EF FF 60 14 25 88 30 02 01 00 04 24 2E 00 03 24 67 00 43 50 01 00 B5 26 37 00 80 14 21 F0 00 00 02 00 60 12 0A A8 44 02 00 00 75 AE 1F 00 C0 13 40 18 16 00 C3 17 1E 00 26 98 5E 00 ?? ?? 12 3C 23 98 62 02 ?? ?? 52 26 05 00 10 24 80 3F 02 3C ?? ?? ?? 0? FF FF 15 24 0B 00 15 12 FC FF 52 26 07 18 13 02 01 00 63 30 FB FF 60 10 FF FF 10 26 14 00 45 8E 21 20 40 00 ?? ?? ?? 0? FC FF 52 26 F8 FF 15 16 07 18 13 02 68 00 C0 07 21 20 C0 02 ?? ?? ?? 0? 21 28 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 C0 03 21 B0 40 00 40 18 16 00 00 FF 02 3C 6D 00 62 50 22 00 03 24 69 00 C0 12 00 00 00 00 2F 00 80 16 34 00 BF 8F 21 10 C0 02 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 21 18 40 00 65 00 02 24 03 00 62 10 45 00 02 24 C5 FF 62 14 01 00 04 24 01 00 B5 26 00 00 A2 82 2D 00 03 24 47 00 43 50 01 00 B5 26 2B 00 03 24 4A 00 43 10 21 30 00 00 21 18 E2 02 01 00 64 90 04 00 84 30 0B 00 80 10 21 18 00 00 0A 00 05 24 02 20 65 70 01 00 B5 26 21 18 82 00 00 00 A2 82 21 20 E2 02 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 63 24 23 10 03 00 0B 18 46 00 21 F0 C3 03 ?? ?? ?? 0? 01 00 04 24 21 20 C0 02 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F ?? ?? ?? 0? 38 00 BD 27 00 00 A3 82 21 10 E3 02 01 00 45 90 04 00 A5 30 95 FF A0 10 21 10 60 00 21 F0 00 00 D0 FF 70 24 21 20 C0 02 ?? ?? ?? 0? 20 41 05 3C 21 20 00 02 ?? ?? ?? 0? 21 B0 40 00 21 28 40 00 21 20 C0 02 ?? ?? ?? 0? 01 00 B5 26 00 00 A3 82 21 B0 40 00 25 88 30 02 21 10 E3 02 01 00 42 90 04 00 42 30 EE FF 40 14 FF FF DE 27 ?? ?? ?? 0? 65 00 02 24 01 00 B5 26 ?? ?? ?? 0? 01 00 14 24 ?? ?? ?? 0? 21 28 40 00 ?? ?? ?? 0? 21 20 40 00 00 00 A2 82 ?? ?? ?? 0? 01 00 06 24 21 20 00 00 ?? ?? ?? 0? 21 88 00 00 01 00 B5 26 ?? ?? ?? 0? 00 00 A2 82 97 FF 20 12 22 00 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_116_0_1 {
	meta:
		name = "ieee754sp_nfstr"
		size = 856
		refs = "0030 _ctype 00ac ieee754sp_mul 00b8 ieee754sp_fint 00c4 ieee754sp_add 0180 ieee754sp_nldexp 028c ieee754sp_neg 0310 ieee754sp_div 034c errno"
	strings:
		$1 = { C8 FF BD 27 2C 00 B7 AF 24 00 B5 AF 1C 00 B3 AF 18 00 B2 AF 34 00 BF AF 30 00 BE AF 28 00 B6 AF 20 00 B4 AF 14 00 B1 AF 10 00 B0 AF 00 00 82 80 ?? ?? 17 3C ?? ?? F7 26 21 18 E2 02 01 00 63 80 21 90 80 00 21 98 A0 00 88 00 63 30 08 00 60 10 21 A8 80 00 01 00 B5 26 00 00 A2 82 21 18 E2 02 01 00 63 80 88 00 63 30 FB FF 60 54 01 00 B5 26 2D 00 03 24 A3 00 43 10 2B 00 42 38 01 00 42 2C 21 A0 00 00 21 A8 A2 02 00 00 A2 82 21 18 E2 02 01 00 63 90 04 00 63 30 A4 00 60 10 21 B0 00 00 21 88 00 00 D0 FF 50 24 21 20 C0 02 ?? ?? ?? 0? 20 41 05 3C 21 20 00 02 ?? ?? ?? 0? 21 B0 40 00 21 28 40 00 ?? ?? ?? 0? 21 20 C0 02 01 00 B5 26 21 B0 40 00 00 00 A2 82 21 18 E2 02 01 00 63 90 04 00 63 30 EF FF 60 14 25 88 30 02 01 00 04 24 2E 00 03 24 67 00 43 50 01 00 B5 26 37 00 80 14 21 F0 00 00 02 00 60 12 0A A8 44 02 00 00 75 AE 1F 00 C0 13 40 18 16 00 C3 17 1E 00 26 98 5E 00 ?? ?? 12 3C 23 98 62 02 ?? ?? 52 26 05 00 10 24 80 3F 02 3C ?? ?? ?? 0? FF FF 15 24 0B 00 15 12 FC FF 52 26 07 18 13 02 01 00 63 30 FB FF 60 10 FF FF 10 26 14 00 45 8E 21 20 40 00 ?? ?? ?? 0? FC FF 52 26 F8 FF 15 16 07 18 13 02 68 00 C0 07 21 20 C0 02 ?? ?? ?? 0? 21 28 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 C0 03 21 B0 40 00 40 18 16 00 00 FF 02 3C 6D 00 62 50 22 00 03 24 69 00 C0 12 00 00 00 00 2F 00 80 16 34 00 BF 8F 21 10 C0 02 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 21 18 40 00 65 00 02 24 03 00 62 10 45 00 02 24 C5 FF 62 14 01 00 04 24 01 00 B5 26 00 00 A2 82 2D 00 03 24 47 00 43 50 01 00 B5 26 2B 00 03 24 4A 00 43 10 21 30 00 00 21 18 E2 02 01 00 64 90 04 00 84 30 0B 00 80 10 21 18 00 00 0A 00 05 24 02 20 65 70 01 00 B5 26 21 18 82 00 00 00 A2 82 21 20 E2 02 01 00 84 90 04 00 84 30 F8 FF 80 14 D0 FF 63 24 23 10 03 00 0B 18 46 00 21 F0 C3 03 ?? ?? ?? 0? 01 00 04 24 21 20 C0 02 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F ?? ?? ?? 0? 38 00 BD 27 00 00 A3 82 21 10 E3 02 01 00 45 90 04 00 A5 30 95 FF A0 10 21 10 60 00 21 F0 00 00 D0 FF 70 24 21 20 C0 02 ?? ?? ?? 0? 20 41 05 3C 21 20 00 02 ?? ?? ?? 0? 21 B0 40 00 21 28 40 00 21 20 C0 02 ?? ?? ?? 0? 01 00 B5 26 00 00 A3 82 21 B0 40 00 25 88 30 02 21 10 E3 02 01 00 42 90 04 00 42 30 EE FF 40 14 FF FF DE 27 ?? ?? ?? 0? 65 00 02 24 01 00 B5 26 ?? ?? ?? 0? 01 00 14 24 ?? ?? ?? 0? 21 28 40 00 ?? ?? ?? 0? 21 20 40 00 00 00 A2 82 ?? ?? ?? 0? 01 00 06 24 21 20 00 00 ?? ?? ?? 0? 21 88 00 00 01 00 B5 26 ?? ?? ?? 0? 00 00 A2 82 97 FF 20 12 22 00 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC }
	condition:
		$1
}

rule file_13_0_1 {
	meta:
		name = "__unordsf2"
		size = 44
	strings:
		$1 = { 00 FF 03 3C 40 20 04 00 01 00 63 24 2B 20 83 00 04 00 80 10 01 00 02 24 40 28 05 00 2B 18 A3 00 01 00 62 38 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_14_0_1 {
	meta:
		name = "ieee754sp_1e63"
		size = 16
	strings:
		$1 = { 00 12 04 00 BE 00 42 34 08 00 E0 03 C0 15 02 00 }
	condition:
		$1
}

rule file_15_0_1 {
	meta:
		name = "ieee754dp_class"
		size = 72
	strings:
		$1 = { 00 55 A3 7C FF FF 66 24 FE 07 C6 2C 00 98 A5 7C 03 00 C0 10 21 10 00 00 08 00 E0 03 00 00 00 00 05 00 60 14 25 28 85 00 02 00 02 24 01 00 03 24 08 00 E0 03 0A 10 65 00 08 00 03 24 04 00 02 24 08 00 E0 03 0B 10 65 00 }
	condition:
		$1
}

rule file_16_0_1 {
	meta:
		name = "ieee754dp_snan"
		size = 32
	strings:
		$1 = { C0 1A 04 00 FF 07 63 34 0F 00 02 3C FF FF 42 34 00 1D 03 00 25 18 62 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_18_0_1 {
	meta:
		name = "__gtdf2"
		size = 104
		refs = "003c __orderdf2"
		altNames = "__gedf2"
	strings:
		$1 = { F0 7F 02 3C 00 F0 A3 7C 01 00 48 24 2B 40 68 00 0E 00 00 51 FF FF 02 24 0E 00 62 10 00 00 00 00 00 F0 E3 7C 01 00 48 24 2B 40 68 00 07 00 00 51 FF FF 02 24 03 00 62 10 00 00 00 00 ?? ?? ?? 0? 00 00 00 00 FD FF C0 10 FF FF 02 24 08 00 E0 03 00 00 00 00 F2 FF 80 50 F0 7F 02 3C FF FF 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_19_0_1 {
	meta:
		name = "ieee754sp_tlong"
		size = 208
		altNames = "__fixsfdi"
	strings:
		$1 = { C0 3D 83 7C FF FF 65 24 FE 00 A5 2C C2 47 04 00 29 00 A0 10 00 B0 84 7C 81 FF 62 24 3F 00 45 28 21 30 00 00 1A 00 A0 10 00 80 07 3C 21 30 00 00 17 00 40 04 21 38 00 00 80 00 05 3C 18 00 46 28 25 20 85 00 15 00 C0 14 21 28 00 00 6A FF 63 24 20 00 62 30 42 30 04 00 27 28 03 00 04 18 64 00 06 28 A6 00 21 20 60 00 0B 20 02 00 0B 28 62 00 06 00 00 11 21 30 80 00 23 20 04 00 2B 10 04 00 23 28 05 00 23 28 A2 00 21 30 80 00 21 38 A0 00 21 10 C0 00 08 00 E0 03 21 18 E0 00 17 00 03 24 F3 FF 43 10 23 10 62 00 20 00 43 30 06 20 44 00 ?? ?? ?? 0? 0B 20 03 00 21 30 00 00 F4 FF 60 10 21 38 00 00 21 30 00 00 ?? ?? ?? 0? 00 80 07 3C }
	condition:
		$1
}

rule file_22_0_1 {
	meta:
		name = "ieee754dp_dump"
		size = 780
		refs = "003c _printf_cdnopsuxX 0068 ieee754dp_class 0080 abort"
	strings:
		$1 = { 21 28 80 00 ?? ?? 04 3C C8 FF BD 27 ?? ?? 84 24 34 00 BF AF 2C 00 B7 AF 14 00 B1 AF 21 B8 E0 00 10 00 B0 AF 30 00 BE AF 21 80 C0 00 28 00 B6 AF 24 00 B5 AF 20 00 B4 AF 1C 00 B3 AF ?? ?? ?? 0? 18 00 B2 AF ?? ?? 04 3C 21 30 00 02 21 38 E0 02 ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 21 20 00 02 ?? ?? ?? 0? 21 28 E0 02 21 88 40 00 09 00 42 2C 37 00 40 14 ?? ?? 02 3C ?? ?? ?? 0? 08 00 31 3A 51 00 05 24 53 00 02 24 0B 28 51 00 C2 37 17 00 2B 00 03 24 2D 00 02 24 0A 10 66 00 ?? ?? 04 3C ?? ?? 84 24 21 30 40 00 00 98 F1 7E ?? ?? ?? 0? ?? ?? 15 3C 33 00 1E 24 40 90 11 00 30 00 13 24 31 00 14 24 ?? ?? B5 26 FF FF 16 24 27 10 1E 00 04 10 52 00 06 28 D0 03 20 00 C3 33 25 28 45 00 06 10 D1 03 0B 28 43 00 01 00 A5 30 21 10 80 02 0A 10 65 02 FF FF DE 27 21 20 A0 02 ?? ?? ?? 0? 21 28 40 00 F2 FF D6 17 27 10 1E 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 34 00 BF 8F 21 10 00 02 21 18 E0 02 30 00 BE 8F 2C 00 B7 8F 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 38 00 BD 27 80 18 11 00 ?? ?? 42 24 21 10 43 00 00 00 42 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0? 51 00 05 24 C2 2F 17 00 2B 00 03 24 2D 00 02 24 0A 10 65 00 ?? ?? 04 3C ?? ?? 84 24 21 28 40 00 00 98 F1 7E ?? ?? ?? 0? ?? ?? 15 3C 33 00 1E 24 40 90 11 00 30 00 13 24 31 00 14 24 ?? ?? B5 26 FF FF 16 24 27 10 1E 00 04 10 52 00 06 28 D0 03 20 00 C3 33 25 28 45 00 06 10 D1 03 0B 28 43 00 01 00 A5 30 21 10 80 02 0A 10 65 02 FF FF DE 27 21 20 A0 02 ?? ?? ?? 0? 21 28 40 00 F2 FF D6 17 27 10 1E 00 00 55 E5 7E ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 01 FC A5 24 ?? ?? ?? 0? ?? ?? 04 3C ?? ?? 04 3C C2 2F 17 00 ?? ?? 84 24 2B 00 03 24 2D 00 02 24 0A 10 65 00 ?? ?? ?? 0? 21 28 40 00 ?? ?? ?? 0? ?? ?? 04 3C C2 2F 17 00 2B 00 03 24 2D 00 02 24 0A 10 65 00 ?? ?? 04 3C ?? ?? 84 24 21 28 40 00 00 98 F1 7E ?? ?? ?? 0? ?? ?? 15 3C 33 00 1E 24 40 90 11 00 30 00 13 24 31 00 14 24 ?? ?? B5 26 FF FF 16 24 27 10 1E 00 04 10 52 00 06 28 D0 03 20 00 C3 33 25 28 45 00 06 10 D1 03 0B 28 43 00 01 00 A5 30 21 10 80 02 0A 10 65 02 FF FF DE 27 21 20 A0 02 ?? ?? ?? 0? 21 28 40 00 F2 FF D6 17 27 10 1E 00 00 55 E5 7E ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 01 FC A5 24 ?? ?? ?? 0? ?? ?? 04 3C ?? ?? 04 3C C2 2F 17 00 ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_22_1_1 {
	meta:
		name = "ieee754sp_dump"
		size = 764
		refs = "0034 _printf_cdnopsuxX 0058 ieee754sp_class 0070 abort"
	strings:
		$1 = { D0 FF BD 27 21 10 80 00 ?? ?? 04 3C 24 00 B5 AF ?? ?? 84 24 21 A8 A0 00 21 28 40 00 2C 00 BF AF 10 00 B0 AF 28 00 B6 AF 20 00 B4 AF 1C 00 B3 AF 18 00 B2 AF ?? ?? ?? 0? 14 00 B1 AF ?? ?? 04 3C 21 28 A0 02 ?? ?? ?? 0? ?? ?? 84 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 ?? ?? ?? 0? 21 20 A0 02 21 80 40 00 09 00 42 2C 2D 00 40 14 ?? ?? 02 3C ?? ?? ?? 0? 08 00 10 3A 51 00 05 24 53 00 02 24 0B 28 50 00 C2 37 15 00 2B 00 03 24 2D 00 02 24 0A 10 66 00 ?? ?? 04 3C ?? ?? 84 24 21 30 40 00 ?? ?? ?? 0? ?? ?? 13 3C 16 00 16 24 00 B0 B0 7E 30 00 12 24 31 00 11 24 ?? ?? 73 26 FF FF 14 24 06 28 D0 02 01 00 A5 30 21 10 20 02 0A 10 45 02 FF FF D6 26 21 20 60 02 ?? ?? ?? 0? 21 28 40 00 F8 FF D4 16 06 28 D0 02 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 2C 00 BF 8F 21 10 A0 02 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 30 00 BD 27 80 18 10 00 ?? ?? 42 24 21 10 43 00 00 00 42 8C 08 00 40 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0? 51 00 05 24 C2 2F 15 00 2B 00 03 24 2D 00 02 24 0A 10 65 00 ?? ?? 04 3C ?? ?? 84 24 21 28 40 00 ?? ?? ?? 0? ?? ?? 13 3C 16 00 16 24 00 B0 B0 7E 30 00 12 24 31 00 11 24 ?? ?? 73 26 FF FF 14 24 06 28 D0 02 01 00 A5 30 21 10 20 02 0A 10 45 02 FF FF D6 26 21 20 60 02 ?? ?? ?? 0? 21 28 40 00 F8 FF D4 56 06 28 D0 02 C0 3D A5 7E ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 81 FF A5 24 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 2C 00 BF 8F 21 10 A0 02 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 30 00 BD 27 ?? ?? 04 3C C2 2F 15 00 ?? ?? 84 24 2B 00 03 24 2D 00 02 24 0A 10 65 00 ?? ?? ?? 0? 21 28 40 00 ?? ?? 04 3C ?? ?? ?? 0? ?? ?? 84 24 2C 00 BF 8F 21 10 A0 02 28 00 B6 8F 24 00 B5 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 30 00 BD 27 C2 2F 15 00 2B 00 03 24 2D 00 02 24 0A 10 65 00 ?? ?? 04 3C ?? ?? 84 24 21 28 40 00 ?? ?? ?? 0? ?? ?? 13 3C 16 00 16 24 00 B0 B0 7E 30 00 12 24 31 00 11 24 ?? ?? 73 26 FF FF 14 24 06 28 D0 02 01 00 A5 30 21 10 20 02 0A 10 45 02 FF FF D6 26 21 20 60 02 ?? ?? ?? 0? 21 28 40 00 F8 FF D4 56 06 28 D0 02 C0 3D A5 7E ?? ?? 04 3C ?? ?? 84 24 ?? ?? ?? 0? 81 FF A5 24 ?? ?? ?? 0? ?? ?? 04 3C ?? ?? 04 3C C2 2F 15 00 ?? ?? ?? 0? ?? ?? 84 24 }
	condition:
		$1
}

rule file_23_0_1 {
	meta:
		name = "ieee754sp_ten"
		size = 24
	strings:
		$1 = { 00 12 04 00 82 00 42 34 20 00 03 3C C0 15 02 00 08 00 E0 03 25 10 43 00 }
	condition:
		$1
}

rule file_24_0_1 {
	meta:
		name = "ieee754dp_1e63"
		size = 20
	strings:
		$1 = { C0 1A 04 00 3E 04 63 34 00 1D 03 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_25_0_1 {
	meta:
		name = "ieee754dp_add"
		size = 1148
		refs = "0388 __lshrdi3"
		altNames = "__adddf3"
	strings:
		$1 = { D8 FF BD 27 20 00 B3 AF 00 55 B3 7C FF FF 63 26 FE 07 63 2C 1C 00 B2 AF 24 00 BF AF 18 00 B1 AF 14 00 B0 AF C2 97 05 00 C7 00 60 10 00 98 AA 7C 10 00 02 3C 01 FC 73 26 25 50 42 01 21 18 00 00 00 55 E8 7C FF FF 0D 25 FE 07 AD 2D C2 67 07 00 21 58 C0 00 AA 00 A0 11 00 98 E9 7C 10 00 02 3C 25 48 22 01 01 FC 08 25 21 68 00 00 AA 00 60 14 21 10 60 00 42 2F 0B 00 C0 18 09 00 42 6F 04 00 C0 38 0A 00 25 18 A3 00 23 28 68 02 25 38 A7 01 C0 30 04 00 70 00 A0 18 C0 10 0B 00 38 00 A4 28 5A 00 80 50 01 00 02 24 27 20 05 00 40 50 03 00 23 40 05 00 04 50 8A 00 06 20 A2 00 20 00 A9 30 25 20 44 01 06 28 A3 00 20 00 0B 31 0B 20 A9 00 04 68 02 01 03 00 60 15 0B 28 09 00 04 40 03 01 25 68 02 01 2B 68 0D 00 25 10 A4 01 21 18 A0 00 49 00 4C 12 21 20 46 00 23 20 C2 00 2B 28 C4 00 23 10 E3 00 23 10 45 00 21 88 40 00 25 10 82 00 21 80 80 00 21 30 00 00 33 00 40 10 21 38 00 00 6D 00 20 06 23 10 04 00 03 00 20 16 20 10 22 72 20 10 02 72 20 00 42 24 F8 FF 42 24 0D 00 40 50 FF 03 73 26 42 28 10 00 27 20 02 00 04 18 51 00 06 28 85 00 04 80 50 00 20 00 44 30 25 18 A3 00 0B 18 04 02 21 88 60 00 0B 80 04 00 23 98 62 02 FF 03 73 26 7D 00 60 1A 01 00 02 24 07 00 03 32 0B 00 60 10 FF 07 62 2A C0 00 02 7E 03 00 42 24 21 10 02 02 2B 18 50 00 21 18 71 00 21 80 40 00 00 06 62 7C 44 00 40 14 21 88 60 00 FF 07 62 2A 81 00 40 10 C2 10 11 00 40 27 11 00 C2 80 10 00 00 05 43 7C 82 00 60 10 25 80 90 00 00 98 42 7C C0 92 12 00 25 98 72 02 00 9D 13 00 25 10 62 02 21 30 00 02 21 38 40 00 24 00 BF 8F 21 10 C0 00 21 18 E0 00 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 BA FF 4C 16 21 18 00 00 21 20 46 00 2B 28 82 00 21 10 67 00 21 10 A2 00 21 88 40 00 00 06 42 7C D0 FF 40 10 21 80 80 00 C0 1F 11 00 42 10 04 00 25 10 62 00 01 00 84 30 42 18 11 00 25 80 82 00 21 88 60 00 ?? ?? ?? 0? 01 00 73 26 A5 FF A0 10 23 20 05 00 38 00 89 28 23 00 20 11 21 98 00 01 27 48 04 00 40 58 07 00 04 58 2B 01 06 48 86 00 20 00 8A 30 25 48 69 01 06 20 87 00 20 00 AD 30 0B 48 8A 00 04 70 A6 00 03 00 A0 15 0B 20 0A 00 04 28 A7 00 25 70 A6 00 2B 70 0E 00 25 30 C9 01 21 38 80 00 ?? ?? ?? 0? 21 98 00 01 42 10 10 00 C0 1F 03 00 25 18 62 00 42 10 11 00 21 80 60 00 21 88 40 00 ?? ?? ?? 0? 01 00 73 26 2B 18 02 00 23 20 11 00 23 18 83 00 21 80 40 00 21 88 60 00 ?? ?? ?? 0? 21 90 80 01 01 00 06 24 ?? ?? ?? 0? 21 38 00 00 41 00 00 15 25 10 C9 00 55 00 40 14 02 00 0D 24 01 00 0D 24 01 00 62 34 01 00 0E 24 41 00 4E 14 03 00 0E 24 01 00 62 30 24 68 4D 00 2A 00 A0 11 01 00 02 24 28 00 4C 12 00 00 00 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 2B 00 60 16 25 40 8A 00 25 10 8A 00 02 00 03 24 02 FC 13 24 01 00 08 24 0A 18 02 01 ?? ?? ?? 0? 0A 98 02 00 23 98 53 00 38 00 62 2A 1D 00 40 50 01 00 10 24 21 30 60 02 21 20 00 02 23 98 13 00 ?? ?? ?? 0? 21 28 20 02 20 00 66 32 03 00 C0 14 04 20 70 02 04 98 71 02 25 20 70 02 2B 20 04 00 25 80 82 00 21 88 60 00 ?? ?? ?? 0? 01 00 13 24 C0 12 12 00 FF 07 42 34 00 15 02 00 21 30 00 00 ?? ?? ?? 0? 21 38 40 00 ?? ?? ?? 0? 21 98 00 00 84 FF 62 10 24 00 BF 8F 21 30 80 00 ?? ?? ?? 0? 21 38 A0 00 21 88 00 00 ?? ?? ?? 0? 01 00 13 24 04 00 03 24 08 00 02 24 ?? ?? ?? 0? 0B 18 48 00 04 00 40 54 08 00 0D 24 04 00 0D 24 ?? ?? ?? 0? 04 00 62 34 ?? ?? ?? 0? 08 00 62 34 BF FF 4E 10 08 00 4E 30 08 00 C0 15 04 00 42 30 10 FF 40 50 42 2F 0B 00 24 68 A3 01 0A 00 A0 11 04 00 02 24 E6 FF 4C 52 21 30 80 00 F7 7F 07 3C FF FF 06 24 ?? ?? ?? 0? FF FF E7 34 02 FC 08 24 ?? ?? ?? 0? 02 00 62 34 5F FF 62 14 24 00 BF 8F ?? ?? ?? 0? 21 30 80 00 }
	condition:
		$1
}

rule file_26_0_1 {
	meta:
		name = "__ordersf2"
		size = 72
		altNames = "ieee754sp_order"
	strings:
		$1 = { 0B 00 80 04 21 18 A0 00 0D 00 A2 04 00 80 03 3C 05 00 83 10 21 10 00 00 2A 20 64 00 01 00 02 24 FF FF 05 24 0A 10 A4 00 08 00 E0 03 00 00 00 00 00 80 02 3C F6 FF A1 04 23 20 44 00 00 80 03 3C ?? ?? ?? 0? 23 18 65 00 }
	condition:
		$1
}

rule file_27_0_1 {
	meta:
		name = "ieee754dp_max"
		size = 32
	strings:
		$1 = { C0 1A 04 00 FE 07 63 34 0F 00 02 3C FF FF 42 34 00 1D 03 00 25 18 62 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_28_0_1 {
	meta:
		name = "__lesf2"
		size = 60
		refs = "0024 __ordersf2"
		altNames = "__eqsf2 __ltsf2 __nesf2"
	strings:
		$1 = { 00 FF 02 3C 40 18 04 00 01 00 42 24 2B 18 62 00 06 00 60 10 40 30 05 00 2B 10 C2 00 05 00 40 50 01 00 02 24 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 01 00 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_29_0_1 {
	meta:
		name = "ieee754sp_flong"
		size = 544
		altNames = "__floatdisf"
	strings:
		$1 = { 25 18 85 00 47 00 60 10 21 10 00 00 01 00 02 24 46 00 82 10 C2 47 05 00 FF FF 02 24 65 00 82 10 0A 00 02 24 67 00 82 10 F6 FF 02 24 5A 00 82 10 FF FF 02 24 09 00 00 11 40 19 05 00 41 00 80 10 00 80 02 3C 23 20 04 00 23 28 05 00 2B 10 04 00 23 10 A2 00 21 28 40 00 40 19 05 00 C2 16 04 00 25 10 62 00 C2 1E 05 00 25 10 43 00 39 00 40 14 80 19 05 00 82 16 04 00 25 10 62 00 82 1E 05 00 25 18 43 00 53 00 60 14 1A 00 02 24 C2 3F 04 00 40 18 05 00 40 30 04 00 25 18 E3 00 21 20 C0 00 21 28 60 00 80 31 03 00 82 1E 04 00 25 18 C3 00 82 36 05 00 25 18 66 00 F4 FF 60 10 FF FF 42 24 7F 00 42 24 49 00 40 18 01 00 03 24 07 00 83 30 0A 00 60 10 FF 00 43 28 C0 00 83 7C 03 00 84 24 21 20 83 00 C2 1E 04 00 04 00 60 10 FF 00 43 28 42 20 04 00 01 00 42 24 FF 00 43 28 37 00 60 10 C2 20 04 00 C0 05 83 7C 02 00 60 50 21 10 00 00 00 B0 84 7C 00 42 08 00 25 10 48 00 C0 15 02 00 25 10 44 00 08 00 E0 03 00 00 00 00 BB FF A0 54 FF FF 02 24 00 12 08 00 7F 00 42 34 08 00 E0 03 C0 15 02 00 C0 FF A2 14 23 20 04 00 21 20 00 00 00 80 05 3C 1A 00 02 24 C0 37 05 00 42 18 04 00 25 18 C3 00 01 00 87 30 42 30 05 00 25 20 E3 00 21 28 C0 00 C2 1E 04 00 40 31 06 00 25 18 C3 00 C2 36 05 00 25 18 66 00 F3 FF 60 14 01 00 42 24 ?? ?? ?? 0? 7F 00 42 24 A6 FF A2 14 00 12 08 00 82 00 42 34 C0 15 02 00 20 00 03 3C 08 00 E0 03 25 10 43 00 9B FF A4 54 0A 00 02 24 ?? ?? ?? 0? 00 12 08 00 99 FF A0 54 F6 FF 02 24 ?? ?? ?? 0? 00 12 08 00 ?? ?? ?? 0? 99 00 02 24 00 12 08 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 23 10 62 00 1B 00 43 28 08 00 60 50 21 20 00 00 23 18 02 00 04 18 64 00 06 10 44 00 2B 20 03 00 25 20 82 00 ?? ?? ?? 0? 01 00 02 24 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_29_1_1 {
	meta:
		name = "ieee754sp_fulong"
		size = 52
		refs = "0010 ieee754sp_flong 002c ieee754sp_add"
	strings:
		$1 = { E8 FF BD 27 04 00 A0 04 14 00 BF AF 14 00 BF 8F ?? ?? ?? 0? 18 00 BD 27 ?? ?? ?? 0? 00 F0 A5 7C 21 28 40 00 14 00 BF 8F 00 5F 04 3C ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_30_0_1 {
	meta:
		name = "ieee754sp_nldexp"
		size = 260
		altNames = "__ldexpf"
	strings:
		$1 = { C0 3D 83 7C 21 10 80 00 FF FF 64 24 FE 00 84 2C C2 3F 02 00 2D 00 80 10 00 B0 46 7C 80 00 02 3C 81 FF 63 24 25 10 C2 00 7F 00 A5 24 21 18 A3 00 1A 00 60 18 C0 10 02 00 07 00 44 30 0F 00 80 14 C0 00 44 7C FF 00 64 28 29 00 80 50 00 12 07 00 C2 10 02 00 C0 05 44 7C 02 00 80 50 21 18 00 00 00 B0 42 7C 00 3A 07 00 25 18 67 00 C0 1D 03 00 25 10 62 00 08 00 E0 03 00 00 00 00 03 00 42 24 21 10 44 00 C2 26 02 00 EF FF 80 10 FF 00 64 28 42 10 02 00 ?? ?? ?? 0? 01 00 63 24 01 00 04 24 23 18 83 00 1B 00 64 28 14 00 80 50 21 10 00 00 23 20 03 00 04 20 82 00 06 18 62 00 2B 10 04 00 25 10 43 00 ?? ?? ?? 0? 01 00 03 24 E9 FF 60 14 00 00 00 00 E7 FF C0 10 20 18 C3 70 F8 FF 63 24 82 FF 04 24 04 10 66 00 ?? ?? ?? 0? 23 18 83 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 ?? ?? ?? 0? 21 18 00 00 }
	condition:
		$1
}

rule file_31_0_1 {
	meta:
		name = "ieee754sp_max"
		size = 28
	strings:
		$1 = { 00 22 04 00 FE 00 84 34 7F 00 02 3C C0 25 04 00 FF FF 42 34 08 00 E0 03 25 10 82 00 }
	condition:
		$1
}

rule file_32_0_1 {
	meta:
		name = "ieee754sp_fdp"
		size = 264
		altNames = "__truncdfsf2"
	strings:
		$1 = { 00 55 A3 7C FF FF 66 24 FE 07 C6 2C C2 17 05 00 32 00 C0 10 00 98 A5 7C 10 00 06 3C 25 28 A6 00 00 C8 87 7C 82 36 04 00 80 29 05 00 2B 20 07 00 25 30 A6 00 80 FC 63 24 1C 00 60 18 25 20 86 00 07 00 85 30 0D 00 A0 14 C0 00 85 7C FF 00 65 28 12 00 A0 10 C2 20 04 00 C0 05 85 7C 02 00 A0 50 21 18 00 00 00 B0 84 7C 00 12 02 00 25 10 62 00 C0 15 02 00 08 00 E0 03 25 10 44 00 03 00 84 24 21 20 85 00 C2 2E 04 00 F1 FF A0 10 FF 00 65 28 42 20 04 00 ?? ?? ?? 0? 01 00 63 24 00 12 02 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 01 00 05 24 23 18 A3 00 1B 00 65 28 0C 00 A0 50 21 20 00 00 23 28 03 00 04 28 A4 00 06 18 64 00 2B 20 05 00 25 20 83 00 ?? ?? ?? 0? 01 00 03 24 05 00 60 14 25 28 85 00 08 00 E0 03 C0 17 02 00 ?? ?? ?? 0? 21 18 00 00 EA FF A0 50 00 12 02 00 BF 7F 02 3C 08 00 E0 03 FF FF 42 34 }
	condition:
		$1
}

rule file_33_0_1 {
	meta:
		name = "ieee754sp_mul"
		size = 600
		altNames = "__mulsf3"
	strings:
		$1 = { C0 3D 82 7C FF FF 43 24 FE 00 63 2C C2 3F 04 00 56 00 60 10 00 B0 84 7C 80 00 03 3C 81 FF 42 24 25 20 83 00 21 30 00 00 C0 3D A3 7C FF FF 69 24 FE 00 29 2D C2 47 05 00 40 00 20 11 00 B0 A5 7C 80 00 09 3C 25 28 A9 00 81 FF 63 24 21 50 00 00 40 00 C0 14 21 48 C0 00 00 22 04 00 00 2A 05 00 19 00 A4 00 21 10 62 00 12 50 00 00 2B 20 0A 00 10 58 00 00 25 20 8B 00 1F 00 80 04 26 38 07 01 0F 00 83 30 2B 18 03 00 02 21 04 00 25 18 64 00 7F 00 42 24 1E 00 40 18 01 00 04 24 07 00 64 30 0D 00 80 14 C0 00 64 7C FF 00 44 28 37 00 80 10 C2 18 03 00 C0 05 64 7C 02 00 80 50 21 10 00 00 00 B0 63 7C 00 3A 07 00 25 10 47 00 C0 15 02 00 08 00 E0 03 25 10 43 00 03 00 63 24 21 18 64 00 C2 26 03 00 F1 FF 80 10 FF 00 44 28 42 18 03 00 ?? ?? ?? 0? 01 00 42 24 1F 00 83 30 2B 18 03 00 42 21 04 00 25 18 64 00 ?? ?? ?? 0? 01 00 42 24 23 10 82 00 1B 00 44 28 20 00 80 50 21 18 00 00 23 20 02 00 04 20 83 00 06 10 43 00 2B 18 04 00 25 18 62 00 ?? ?? ?? 0? 01 00 02 24 1C 00 60 14 00 00 00 00 2C 00 A0 14 02 00 0A 24 01 00 0A 24 01 00 C9 34 01 00 0B 24 1C 00 2B 15 08 00 2B 31 26 10 07 01 08 00 E0 03 C0 17 02 00 0D 00 40 54 04 00 06 24 02 00 06 24 82 FF 02 24 01 00 03 24 0A 30 64 00 ?? ?? ?? 0? 0A 10 04 00 00 12 07 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 ?? ?? ?? 0? 21 10 00 00 08 00 03 24 ?? ?? ?? 0? 0B 30 64 00 04 00 A0 54 08 00 0A 24 04 00 0A 24 ?? ?? ?? 0? 04 00 C9 34 ?? ?? ?? 0? 08 00 C9 34 1F 00 60 15 04 00 2B 31 0D 00 60 11 01 00 29 31 09 00 20 55 BF 7F 02 3C 26 10 07 01 00 12 02 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 82 FF 03 24 ?? ?? ?? 0? 02 00 C9 34 08 00 E0 03 FF FF 42 34 D5 FF 20 55 26 10 07 01 02 00 C6 30 05 00 C0 10 02 00 4A 31 20 30 86 70 F8 FF C6 24 04 20 C4 00 23 10 46 00 8A FF 40 51 00 22 04 00 20 30 A6 70 F8 FF C6 24 04 28 C5 00 ?? ?? ?? 0? 23 18 66 00 BF 7F 02 3C 08 00 E0 03 FF FF 42 34 }
	condition:
		$1
}

rule file_34_0_1 {
	meta:
		name = "ieee754dp_tulong"
		size = 124
		refs = "001c ieee754dp_order 0034 ieee754dp_sub 0040 ieee754dp_tlong"
	strings:
		$1 = { E0 FF BD 27 21 30 00 00 E0 43 07 3C 18 00 B1 AF 14 00 B0 AF 1C 00 BF AF 21 80 80 00 ?? ?? ?? 0? 21 88 A0 00 0F 00 40 04 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? E0 43 07 3C 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 1C 00 BF 8F 00 80 04 3C 25 18 64 00 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 21 28 20 02 1C 00 BF 8F 18 00 B1 8F 14 00 B0 8F ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_107_0_1 {
	meta:
		name = "__fixunsdfdi"
		size = 124
		refs = "001c __orderdf2 0034 __subdf3 0040 __fixdfdi"
	strings:
		$1 = { E0 FF BD 27 21 30 00 00 E0 43 07 3C 18 00 B1 AF 14 00 B0 AF 1C 00 BF AF 21 80 80 00 ?? ?? ?? 0? 21 88 A0 00 0F 00 40 04 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? E0 43 07 3C 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 1C 00 BF 8F 00 80 04 3C 25 18 64 00 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 21 28 20 02 1C 00 BF 8F 18 00 B1 8F 14 00 B0 8F ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_35_0_1 {
	meta:
		name = "ieee754dp_cmp"
		size = 244
	strings:
		$1 = { F0 7F 03 3C 00 F0 A8 7C 01 00 69 24 2B 48 09 01 08 00 20 11 10 00 A2 8F 17 00 03 11 00 00 00 00 00 F0 E8 7C 01 00 69 24 2B 48 09 01 03 00 20 15 00 00 00 00 08 00 E0 03 C0 00 42 7C 12 00 03 11 21 40 C0 00 18 00 A0 04 21 18 E0 00 1E 00 E2 04 23 40 06 00 2A 30 A3 00 24 00 C0 54 01 00 42 30 0D 00 65 10 2B 30 88 00 1D 00 88 10 00 00 00 00 08 00 E0 03 80 00 42 7C E9 FF 80 10 F0 7F 03 3C 08 00 E0 03 C0 00 42 7C EE FF C0 10 00 00 00 00 08 00 E0 03 C0 00 42 7C F3 FF C0 10 00 00 00 00 08 00 E0 03 01 00 42 30 23 20 04 00 2B 48 04 00 23 28 05 00 23 28 A9 00 00 80 09 3C E5 FF E1 04 26 28 A9 00 23 40 06 00 2B 18 08 00 23 38 07 00 23 18 E3 00 00 80 06 3C ?? ?? ?? 0? 26 18 66 00 02 00 A3 54 80 00 42 7C 40 00 42 7C 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_36_0_1 {
	meta:
		name = "ieee754sp_logb"
		size = 76
		refs = "0014 ieee754sp_fint"
	strings:
		$1 = { C0 3D 82 7C FF FF 43 24 FE 00 63 2C 03 00 60 10 00 B0 85 7C ?? ?? ?? 0? 81 FF 44 24 05 00 40 14 80 7F 02 3C 05 00 A0 14 80 FF 04 3C 08 00 E0 03 21 10 80 00 ?? ?? ?? 0? 0A 20 45 00 20 28 A5 70 8A FF 04 24 ?? ?? ?? 0? 23 20 85 00 }
	condition:
		$1
}

rule file_37_0_1 {
	meta:
		name = "ieee754dp_one"
		size = 20
	strings:
		$1 = { C0 1A 04 00 FF 03 63 34 00 1D 03 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_40_0_1 {
	meta:
		name = "ieee754dp_logb"
		size = 124
		refs = "0018 ieee754dp_fint"
	strings:
		$1 = { 00 55 A2 7C FF FF 46 24 FE 07 C6 2C 21 38 80 00 03 00 C0 10 00 98 A3 7C ?? ?? ?? 0? 01 FC 44 24 08 00 40 54 25 18 83 00 25 10 83 00 0A 00 40 14 21 20 00 00 F0 FF 05 3C 21 10 80 00 08 00 E0 03 21 18 A0 00 FD FF 60 54 21 10 80 00 21 20 00 00 ?? ?? ?? 0? F0 7F 05 3C 03 00 60 14 20 10 62 70 20 10 E2 70 20 00 42 24 F5 FF 42 24 02 FC 04 24 23 18 82 00 ?? ?? ?? 0? 0B 20 62 00 }
	condition:
		$1
}

rule file_42_0_1 {
	meta:
		name = "__fixunssfdi"
		size = 88
		refs = "0010 __ordersf2 0020 __subsf3 0028 __fixsfdi"
	strings:
		$1 = { E8 FF BD 27 00 5F 05 3C 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? 21 80 80 00 0B 00 40 04 21 20 00 02 ?? ?? ?? 0? 00 5F 05 3C ?? ?? ?? 0? 21 20 40 00 14 00 BF 8F 00 80 04 3C 25 18 64 00 10 00 B0 8F 08 00 E0 03 18 00 BD 27 14 00 BF 8F 10 00 B0 8F ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_55_0_1 {
	meta:
		name = "ieee754sp_tulong"
		size = 88
		refs = "0010 ieee754sp_order 0020 ieee754sp_sub 0028 ieee754sp_tlong"
	strings:
		$1 = { E8 FF BD 27 00 5F 05 3C 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? 21 80 80 00 0B 00 40 04 21 20 00 02 ?? ?? ?? 0? 00 5F 05 3C ?? ?? ?? 0? 21 20 40 00 14 00 BF 8F 00 80 04 3C 25 18 64 00 10 00 B0 8F 08 00 E0 03 18 00 BD 27 14 00 BF 8F 10 00 B0 8F ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_44_0_1 {
	meta:
		name = "__divsf3"
		size = 640
		altNames = "ieee754sp_div"
	strings:
		$1 = { C0 3D 82 7C FF FF 43 24 FE 00 63 2C C2 57 04 00 82 00 60 10 00 B0 84 7C 80 00 03 3C 25 20 83 00 81 FF 42 24 21 18 00 00 C0 3D A9 7C FF FF 26 25 FE 00 C6 2C C2 5F 05 00 45 00 C0 10 00 B0 A5 7C 80 00 06 3C 25 28 A6 00 81 FF 29 25 21 30 00 00 45 00 60 14 21 38 60 00 C0 20 04 00 C0 28 05 00 1A 00 03 24 00 02 06 3C 21 40 00 00 2B 38 85 00 04 00 E0 14 FF FF 63 24 23 20 85 00 26 00 80 10 25 40 06 01 40 20 04 00 F8 FF 60 14 42 30 06 00 40 40 08 00 01 00 03 35 0B 40 64 00 20 18 03 71 7F 00 42 24 FB FF 63 24 23 48 49 00 23 48 23 01 04 40 68 00 1A 00 20 19 26 50 6A 01 07 00 02 31 08 00 40 10 FF 00 22 29 C0 00 02 7D 03 00 08 25 21 40 02 01 C2 16 08 00 0D 00 40 54 42 40 08 00 FF 00 22 29 58 00 40 10 C2 40 08 00 C0 05 02 7D 02 00 40 50 21 48 00 00 00 B0 08 7D 00 12 0A 00 25 10 22 01 C0 15 02 00 08 00 E0 03 25 10 48 00 ?? ?? ?? 0? 01 00 29 25 ?? ?? ?? 0? 40 40 08 00 01 00 02 24 23 48 49 00 1B 00 22 29 1D 00 40 50 21 40 00 00 23 10 09 00 04 10 48 00 06 48 28 01 2B 40 02 00 25 40 09 01 ?? ?? ?? 0? 01 00 09 24 41 00 20 15 00 00 00 00 38 00 A0 14 02 00 06 24 01 00 06 24 01 00 67 34 08 00 E8 30 1B 00 00 15 04 00 E8 30 0F 00 00 51 01 00 E7 30 24 18 C3 00 17 00 60 14 BF 7F 02 3C 04 00 02 24 07 00 C2 10 26 10 6A 01 00 12 02 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 ?? ?? ?? 0? 21 48 00 00 08 00 E0 03 C0 17 02 00 0C 00 E0 50 02 00 63 30 01 00 02 24 FA FF C2 54 26 10 6A 01 F2 FF 66 54 26 10 6A 01 BF 7F 02 3C 08 00 E0 03 FF FF 42 34 BF 7F 02 3C 08 00 E0 03 FF FF 42 34 05 00 60 10 02 00 C6 30 20 18 83 70 F8 FF 63 24 04 20 64 00 23 10 43 00 96 FF C0 50 C0 20 04 00 20 18 A3 70 F8 FF 63 24 04 28 65 00 ?? ?? ?? 0? 23 48 23 01 13 00 40 54 04 00 03 24 02 00 03 24 82 FF 02 24 01 00 06 24 0A 18 C4 00 ?? ?? ?? 0? 0A 10 04 00 82 FF 09 24 ?? ?? ?? 0? 02 00 67 34 00 12 0A 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 07 00 A0 54 08 00 06 24 04 00 06 24 ?? ?? ?? 0? 04 00 67 34 08 00 06 24 ?? ?? ?? 0? 0B 18 C4 00 ?? ?? ?? 0? 08 00 67 34 }
	condition:
		$1
}

rule file_45_0_1 {
	meta:
		name = "__floatdidf"
		size = 824
		refs = "02e0 __lshrdi3"
		altNames = "ieee754dp_flong"
	strings:
		$1 = { D0 FF BD 27 25 10 85 00 18 00 B1 AF 14 00 B0 AF 2C 00 BF AF 28 00 B5 AF 24 00 B4 AF 20 00 B3 AF 1C 00 B2 AF 21 80 00 00 4B 00 40 10 21 88 00 00 01 00 02 24 5C 00 82 10 C2 A7 05 00 FF FF 02 24 7D 00 82 10 0A 00 02 24 84 00 82 10 F6 FF 02 24 66 00 82 10 FF FF 02 24 4A 00 80 16 21 90 80 00 21 98 A0 00 78 00 60 16 21 28 60 02 E8 FF 03 24 20 10 42 72 23 10 62 00 36 04 43 24 7B 00 40 18 00 00 00 00 27 20 02 00 40 40 13 00 23 30 02 00 04 40 88 00 06 20 52 00 20 00 47 30 25 20 04 01 06 10 53 00 20 00 C9 30 0B 20 47 00 04 50 D2 00 03 00 20 15 0B 10 07 00 04 28 C5 00 25 50 B2 00 2B 50 0A 00 25 90 44 01 21 98 40 00 7D 00 60 18 01 00 15 24 07 00 44 32 12 00 80 10 FF 07 62 28 C0 00 42 7E 03 00 42 24 21 10 42 02 2B 20 52 00 21 20 93 00 21 90 40 00 00 06 82 7C 08 00 40 10 21 98 80 00 42 10 12 00 C0 27 04 00 25 20 82 00 42 10 13 00 21 90 80 00 21 98 40 00 01 00 63 24 FF 07 62 28 7F 00 40 10 C2 10 13 00 40 2F 13 00 C2 90 12 00 00 05 44 7C 78 00 80 10 25 90 B2 00 00 98 42 7C C0 A2 14 00 25 18 74 00 00 1D 03 00 21 80 40 02 25 88 62 00 2C 00 BF 8F 21 10 00 02 21 18 20 02 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 30 00 BD 27 47 00 80 10 00 80 02 3C 23 20 04 00 2B 10 04 00 23 28 05 00 23 28 A2 00 21 90 80 00 ?? ?? ?? 0? 21 98 A0 00 A5 FF A0 14 FF FF 02 24 C0 A2 14 00 2C 00 BF 8F FF 03 94 36 00 8D 14 00 21 80 00 00 21 10 00 02 21 18 20 02 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 30 00 BD 27 9A FF A2 14 00 00 00 00 C0 A2 14 00 02 04 94 36 2C 00 BF 8F 00 A5 14 00 04 00 02 3C 25 88 82 02 21 80 00 00 21 10 00 02 21 18 20 02 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 30 00 BD 27 83 FF A4 14 00 00 00 00 ?? ?? ?? 0? C0 A2 14 00 08 00 03 24 20 10 62 72 23 10 62 00 ?? ?? ?? 0? 36 04 43 24 7C FF A0 14 00 00 00 00 ?? ?? ?? 0? C0 A2 14 00 9A FF 40 10 07 00 44 32 23 10 02 00 42 30 12 00 27 28 02 00 04 20 53 00 06 28 A6 00 04 90 52 00 25 20 A4 00 20 00 42 30 0B 20 42 02 21 98 80 00 ?? ?? ?? 0? 0B 90 02 00 BA FF A2 14 23 20 04 00 3E 04 03 24 08 00 02 24 00 80 05 3C 21 90 00 00 ?? ?? ?? 0? 00 80 13 3C 23 A8 A3 02 38 00 A2 2A 10 00 40 50 01 00 12 24 21 30 A0 02 21 20 40 02 23 A8 15 00 ?? ?? ?? 0? 21 28 60 02 20 00 A6 32 03 00 C0 14 04 20 B2 02 04 A8 B3 02 25 20 B2 02 2B 20 04 00 21 98 60 00 25 90 82 00 ?? ?? ?? 0? 01 00 03 24 21 98 00 00 ?? ?? ?? 0? 01 00 03 24 ?? ?? ?? 0? 21 18 00 00 C0 A2 14 00 FF 07 94 36 00 8D 14 00 ?? ?? ?? 0? 21 80 00 00 }
	condition:
		$1
}

rule file_46_0_1 {
	meta:
		name = "ieee754dp_floor"
		size = 100
		refs = "0008 ieee754dp_nmodf 0024 ieee754dp_cmp 0050 ieee754dp_sub"
	strings:
		$1 = { D8 FF BD 27 24 00 BF AF ?? ?? ?? 0? 18 00 A6 27 21 20 40 00 21 28 60 00 01 00 02 24 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 10 00 A2 AF 05 00 40 14 24 00 BF 8F 18 00 A2 8F 1C 00 A3 8F 08 00 E0 03 28 00 BD 27 18 00 A4 8F 1C 00 A5 8F 21 30 00 00 ?? ?? ?? 0? F0 3F 07 3C 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_46_1_1 {
	meta:
		name = "ieee754dp_ceil"
		size = 100
		refs = "0008 ieee754dp_nmodf 0024 ieee754dp_cmp 0050 ieee754dp_add"
	strings:
		$1 = { D8 FF BD 27 24 00 BF AF ?? ?? ?? 0? 18 00 A6 27 21 20 40 00 21 28 60 00 04 00 02 24 21 30 00 00 21 38 00 00 ?? ?? ?? 0? 10 00 A2 AF 05 00 40 14 24 00 BF 8F 18 00 A2 8F 1C 00 A3 8F 08 00 E0 03 28 00 BD 27 18 00 A4 8F 1C 00 A5 8F 21 30 00 00 ?? ?? ?? 0? F0 3F 07 3C 24 00 BF 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_46_2_1 {
	meta:
		name = "ieee754dp_trunc"
		size = 36
		refs = "0008 ieee754dp_nmodf"
	strings:
		$1 = { E0 FF BD 27 1C 00 BF AF ?? ?? ?? 0? 10 00 A6 27 1C 00 BF 8F 10 00 A2 8F 14 00 A3 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_49_0_1 {
	meta:
		name = "ieee754sp_min"
		size = 16
	strings:
		$1 = { 00 12 04 00 01 00 42 34 08 00 E0 03 C0 15 02 00 }
	condition:
		$1
}

rule file_50_0_1 {
	meta:
		name = "ieee754dp_div"
		size = 1200
		refs = "02b8 __lshrdi3 0434 __ashldi3"
		altNames = "__divdf3"
	strings:
		$1 = { B8 FF BD 27 20 00 B0 AF 00 55 B0 7C FF FF 02 26 FE 07 42 2C 40 00 BE AF 3C 00 B7 AF 34 00 B5 AF 24 00 B1 AF 44 00 BF AF 38 00 B6 AF 30 00 B4 AF 2C 00 B3 AF 28 00 B2 AF 21 88 C0 00 C2 F7 05 00 21 B8 80 00 C3 00 40 10 00 98 B5 7C 10 00 02 3C 25 A8 A2 02 01 FC 10 26 21 10 00 00 00 55 F4 7C FF FF 83 26 FE 07 63 2C C2 47 07 00 21 B0 20 02 9F 00 60 10 00 98 E7 7C 10 00 03 3C 25 38 E3 00 01 FC 94 26 21 48 00 00 9F 00 40 14 21 18 40 00 42 1F 16 00 42 17 17 00 C0 A8 15 00 C0 48 07 00 25 A8 55 00 25 48 69 00 C0 10 17 00 C0 B0 16 00 23 80 14 02 37 00 03 24 21 20 00 00 40 00 05 3C 21 60 00 00 ?? ?? ?? 0? 21 68 00 00 C2 27 02 00 40 A8 15 00 25 A8 95 00 40 10 02 00 21 20 C0 00 64 00 60 10 21 28 E0 00 42 30 04 00 C0 57 05 00 25 50 46 01 42 58 05 00 21 30 40 01 2B 50 A9 02 21 38 60 01 F1 FF 40 15 FF FF 63 24 25 78 A5 01 23 50 56 00 25 C0 84 01 21 28 E0 01 2B 58 4A 00 23 70 A9 02 21 20 00 03 03 00 35 15 2B 78 56 00 E7 FF E0 55 C2 27 02 00 23 A8 CB 01 21 10 40 01 25 50 55 01 21 60 80 00 E0 FF 40 15 21 68 A0 00 C2 17 04 00 40 B8 05 00 25 B8 57 00 40 B0 04 00 03 00 E0 16 20 10 E2 72 20 10 C2 72 20 00 42 24 F8 FF 42 24 0D 00 40 50 FF 03 10 26 42 28 16 00 27 20 02 00 04 18 57 00 06 28 85 00 04 B0 56 00 20 00 44 30 25 18 A3 00 0B 18 C4 02 21 B8 60 00 0B B0 04 00 23 80 02 02 FF 03 10 26 3A 00 00 1A 26 F0 1E 01 07 00 C3 32 0B 00 60 10 FF 07 02 2A C0 00 C2 7E 03 00 42 24 21 10 C2 02 2B 18 56 00 21 18 77 00 21 B0 40 00 00 06 62 7C 1D 00 40 14 21 B8 60 00 FF 07 02 2A 73 00 40 10 C2 10 17 00 40 27 17 00 C2 B0 16 00 00 05 43 7C 6C 00 60 10 25 B0 96 00 00 98 42 7C C0 F2 1E 00 25 80 1E 02 00 85 10 00 21 90 C0 02 25 98 02 02 44 00 BF 8F 21 10 40 02 21 18 60 02 40 00 BE 8F 3C 00 B7 8F 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 48 00 BD 27 42 10 16 00 C0 1F 03 00 25 18 62 00 42 10 17 00 21 B0 60 00 21 B8 40 00 ?? ?? ?? 0? 01 00 10 26 C2 1F 0C 00 40 B8 0D 00 25 A8 55 00 25 B8 77 00 B6 FF A0 12 40 B0 0C 00 01 00 C3 36 ?? ?? ?? 0? 21 B0 60 00 01 00 02 24 23 80 50 00 38 00 02 2A 10 00 40 50 01 00 16 24 21 30 00 02 21 20 C0 02 23 80 10 00 ?? ?? ?? 0? 21 28 E0 02 20 00 06 32 03 00 C0 14 04 20 16 02 04 80 17 02 25 20 16 02 2B 20 04 00 25 B0 82 00 21 B8 60 00 ?? ?? ?? 0? 01 00 10 24 ?? ?? ?? 0? 21 B8 00 00 24 00 80 16 25 18 27 02 1F 00 60 14 02 00 09 24 01 00 09 24 01 00 43 34 F7 7F 13 3C 08 00 65 30 FF FF 12 24 C1 FF A0 14 FF FF 73 36 04 00 65 30 2D 00 A0 50 01 00 63 30 24 10 22 01 BB FF 40 14 04 00 02 24 25 00 22 51 26 40 1E 01 26 10 1E 01 C0 12 02 00 FF 07 42 34 00 9D 02 00 ?? ?? ?? 0? 21 90 00 00 10 00 00 56 25 28 95 00 25 18 95 00 02 00 02 24 02 FC 10 24 01 00 05 24 0A 10 A3 00 ?? ?? ?? 0? 0A 80 03 00 02 FC 14 24 ?? ?? ?? 0? 02 00 43 34 08 00 60 54 08 00 09 24 04 00 09 24 ?? ?? ?? 0? 04 00 43 34 04 00 02 24 08 00 03 24 ?? ?? ?? 0? 0B 10 65 00 ?? ?? ?? 0? 08 00 43 34 ?? ?? ?? 0? 21 80 00 00 C0 F2 1E 00 FF 07 DE 37 00 9D 1E 00 ?? ?? ?? 0? 21 90 00 00 C0 9F 08 00 ?? ?? ?? 0? 21 90 00 00 08 00 60 50 02 00 42 30 01 00 03 24 F9 FF 23 55 26 40 1E 01 D4 FF 49 14 26 10 1E 01 ?? ?? ?? 0? 44 00 BF 8F 17 00 40 50 02 00 29 31 03 00 A0 16 20 50 AA 72 20 50 8A 70 20 00 4A 25 F5 FF 4A 25 10 00 40 51 02 00 29 31 21 28 A0 02 21 30 40 01 14 00 A7 AF 1C 00 A8 AF 18 00 A9 AF ?? ?? ?? 0? 10 00 AA AF 10 00 AA 8F 18 00 A9 8F 1C 00 A8 8F 14 00 A7 8F 21 B8 40 00 21 A8 60 00 23 80 0A 02 02 00 29 31 0D FF 20 11 42 1F 16 00 03 00 E0 14 20 48 E9 70 20 48 29 72 20 00 29 25 F5 FF 29 25 06 FF 20 51 42 1F 16 00 21 28 E0 00 21 30 20 01 21 20 20 02 1C 00 A8 AF ?? ?? ?? 0? 18 00 A9 AF 18 00 A9 8F 21 B0 40 00 21 38 60 00 23 A0 89 02 ?? ?? ?? 0? 1C 00 A8 8F }
	condition:
		$1
}

rule file_51_0_1 {
	meta:
		name = "ieee754sp_snan"
		size = 28
	strings:
		$1 = { 00 22 04 00 FF 00 84 34 7F 00 02 3C C0 25 04 00 FF FF 42 34 08 00 E0 03 25 10 82 00 }
	condition:
		$1
}

rule file_53_0_1 {
	meta:
		name = "__fixsfsi"
		size = 136
		altNames = "ieee754sp_tint"
	strings:
		$1 = { C0 3D 85 7C FF FF A3 24 FE 00 63 2C C2 3F 04 00 1A 00 60 10 00 B0 84 7C 81 FF A3 24 1F 00 66 28 0C 00 C0 10 00 80 02 24 0A 00 60 04 21 10 00 00 80 00 02 3C 18 00 66 28 08 00 C0 14 25 20 82 00 6A FF A5 24 04 20 A4 00 23 10 04 00 08 00 E0 03 0A 10 87 00 08 00 E0 03 00 00 00 00 17 00 02 24 FA FF 62 50 23 10 04 00 23 18 43 00 06 20 64 00 23 10 04 00 08 00 E0 03 0A 10 87 00 00 80 02 24 08 00 E0 03 0A 10 05 00 }
	condition:
		$1
}

rule file_54_0_1 {
	meta:
		name = "__sqrtdf2"
		size = 568
		refs = "0200 __ashldi3"
		altNames = "ieee754dp_nsqrt"
	strings:
		$1 = { D8 FF BD 27 14 00 B0 AF 00 55 B0 7C FF FF 06 26 FE 07 C6 2C 18 00 B1 AF 24 00 BF AF 20 00 B3 AF 1C 00 B2 AF C2 8F 05 00 21 10 80 00 66 00 C0 10 00 98 A3 7C 10 00 04 3C 01 FC 10 26 25 18 64 00 F7 7F 05 3C FF FF 04 24 4B 00 20 16 FF FF A5 34 01 00 04 32 57 00 80 14 40 20 02 00 40 30 02 00 2B 10 C2 00 40 18 03 00 43 80 10 00 21 10 43 00 36 00 0C 24 21 20 00 00 20 00 05 3C 21 70 00 00 21 78 00 00 21 50 00 00 21 58 00 00 21 18 44 01 42 48 04 00 2B 40 6A 00 C0 6F 05 00 21 38 65 01 25 68 A9 01 21 38 07 01 42 C0 05 00 21 40 A0 01 2B 68 47 00 21 48 00 03 1A 00 A0 15 FF FF 8C 25 21 68 C4 01 21 C0 64 00 21 C8 E5 00 21 98 E5 01 2B 90 03 03 2B 28 AE 01 21 88 A0 01 21 90 59 02 23 68 C3 00 21 98 B3 00 21 20 20 02 21 C8 40 02 2B 88 CD 00 23 90 47 00 21 28 60 02 03 00 E2 14 2B 18 C3 00 08 00 60 14 40 18 06 00 21 30 A0 01 23 10 51 02 21 50 00 03 21 58 20 03 21 70 80 00 21 78 A0 00 40 18 06 00 2B 20 66 00 40 10 02 00 21 10 82 00 21 30 60 00 21 20 00 01 D3 FF 80 15 21 28 20 01 25 10 62 00 14 00 40 14 01 00 C2 31 00 85 10 00 E0 3F 07 3C C0 27 0F 00 42 18 0E 00 21 80 07 02 43 10 0F 00 25 18 83 00 21 10 02 02 21 20 60 00 21 28 40 00 24 00 BF 8F 21 10 80 00 21 18 A0 00 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 21 18 4E 00 2B 10 62 00 21 20 4F 00 21 70 60 00 ?? ?? ?? 0? 21 78 80 00 2B 28 82 00 40 18 03 00 21 10 80 00 ?? ?? ?? 0? 21 18 A3 00 11 00 00 56 25 18 83 00 25 30 83 00 E9 FF C0 10 24 00 BF 8F 03 00 60 14 20 90 72 70 20 90 52 70 20 00 52 26 F5 FF 52 26 93 FF 40 12 02 FC 10 24 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 21 30 40 02 ?? ?? ?? 0? 23 80 12 02 05 00 60 10 00 00 00 00 F7 7F 05 3C FF FF 04 24 ?? ?? ?? 0? FF FF A5 34 FC FF 20 56 F7 7F 05 3C ?? ?? ?? 0? 24 00 BF 8F }
	condition:
		$1
}

rule file_56_0_1 {
	meta:
		name = "__floatsisf"
		size = 356
		altNames = "ieee754sp_fint"
	strings:
		$1 = { 33 00 80 10 21 10 00 00 01 00 02 24 32 00 82 10 C2 2F 04 00 FF FF 02 24 30 00 82 10 00 12 05 00 0A 00 02 24 39 00 82 10 00 12 05 00 F6 FF 02 24 36 00 82 10 00 12 05 00 06 00 A0 10 C2 16 04 00 00 80 02 3C 29 00 82 10 1A 00 02 24 23 20 04 00 C2 16 04 00 24 00 40 14 1A 00 03 24 20 10 82 70 FB FF 42 24 04 20 44 00 23 10 62 00 7F 00 42 24 2B 00 40 18 01 00 03 24 07 00 83 30 0A 00 60 10 FF 00 43 28 C0 00 83 7C 03 00 84 24 21 20 83 00 C2 1E 04 00 04 00 60 10 FF 00 43 28 42 20 04 00 01 00 42 24 FF 00 43 28 28 00 60 10 C2 20 04 00 C0 05 83 7C 02 00 60 50 21 10 00 00 00 B0 84 7C 00 2A 05 00 25 10 45 00 C0 15 02 00 25 10 44 00 08 00 E0 03 00 00 00 00 00 12 05 00 7F 00 42 34 08 00 E0 03 C0 15 02 00 1A 00 02 24 42 18 04 00 01 00 84 30 25 20 83 00 C2 1E 04 00 FB FF 60 14 01 00 42 24 ?? ?? ?? 0? 7F 00 42 24 82 00 42 34 C0 15 02 00 20 00 03 3C 08 00 E0 03 25 10 43 00 23 10 62 00 1B 00 43 28 0C 00 60 50 21 20 00 00 23 18 02 00 04 18 64 00 06 10 44 00 2B 20 03 00 25 20 82 00 ?? ?? ?? 0? 01 00 02 24 00 12 05 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 ?? ?? ?? 0? 21 10 00 00 }
	condition:
		$1
}

rule file_57_0_1 {
	meta:
		name = "ieee754dp_tuns"
		size = 124
		refs = "001c ieee754dp_order 0034 ieee754dp_sub 0040 ieee754dp_tint"
	strings:
		$1 = { E0 FF BD 27 21 30 00 00 E0 41 07 3C 18 00 B1 AF 14 00 B0 AF 1C 00 BF AF 21 80 80 00 ?? ?? ?? 0? 21 88 A0 00 0F 00 40 04 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? E0 41 07 3C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 1C 00 BF 8F 00 80 03 3C 25 10 43 00 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 21 28 20 02 1C 00 BF 8F 18 00 B1 8F 14 00 B0 8F ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_68_0_1 {
	meta:
		name = "__fixunsdfsi"
		size = 124
		refs = "001c __orderdf2 0034 __subdf3 0040 __fixdfsi"
	strings:
		$1 = { E0 FF BD 27 21 30 00 00 E0 41 07 3C 18 00 B1 AF 14 00 B0 AF 1C 00 BF AF 21 80 80 00 ?? ?? ?? 0? 21 88 A0 00 0F 00 40 04 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? E0 41 07 3C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 1C 00 BF 8F 00 80 03 3C 25 10 43 00 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 21 28 20 02 1C 00 BF 8F 18 00 B1 8F 14 00 B0 8F ?? ?? ?? 0? 20 00 BD 27 }
	condition:
		$1
}

rule file_60_0_1 {
	meta:
		name = "ieee754sp_inf"
		size = 16
	strings:
		$1 = { 00 12 04 00 FF 00 42 34 08 00 E0 03 C0 15 02 00 }
	condition:
		$1
}

rule file_61_0_1 {
	meta:
		name = "ieee754dp_fint"
		size = 148
		altNames = "__floatsidf"
	strings:
		$1 = { 21 30 00 00 15 00 80 10 21 38 00 00 C2 2F 04 00 05 00 A0 10 01 00 02 24 00 80 02 3C 19 00 82 10 23 20 04 00 01 00 02 24 0F 00 82 10 20 40 88 70 01 00 02 25 04 20 44 00 02 1B 04 00 00 15 04 00 1E 04 04 24 23 40 88 00 C0 2A 05 00 25 28 05 01 00 2D 05 00 21 30 40 00 25 38 A3 00 21 10 C0 00 08 00 E0 03 21 18 E0 00 C0 2A 05 00 FF 03 A5 34 00 3D 05 00 21 30 00 00 21 10 C0 00 08 00 E0 03 21 18 E0 00 1E 04 08 24 21 10 00 00 ?? ?? ?? 0? 21 18 00 00 }
	condition:
		$1
}

rule file_61_1_1 {
	meta:
		name = "ieee754dp_funs"
		size = 60
		refs = "0010 ieee754dp_fint 0034 ieee754dp_add"
	strings:
		$1 = { E8 FF BD 27 04 00 80 04 14 00 BF AF 14 00 BF 8F ?? ?? ?? 0? 18 00 BD 27 ?? ?? ?? 0? 00 00 00 00 21 30 40 00 14 00 BF 8F 21 38 60 00 21 20 00 00 E0 41 05 3C ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_64_0_1 {
	meta:
		name = "ieee754dp_tint"
		size = 128
		altNames = "__fixdfsi"
	strings:
		$1 = { 00 55 A3 7C FF FF 66 24 FE 07 C6 2C C2 3F 05 00 18 00 C0 10 00 98 A5 7C 01 FC 63 24 1F 00 66 28 12 00 C0 10 00 80 02 24 10 00 60 04 21 10 00 00 34 00 02 24 23 18 43 00 10 00 02 3C 25 28 A2 00 40 30 05 00 27 10 03 00 04 30 46 00 06 20 64 00 20 00 62 30 25 20 C4 00 06 18 65 00 0B 20 62 00 23 10 04 00 08 00 E0 03 0A 10 87 00 08 00 E0 03 00 00 00 00 00 80 02 24 08 00 E0 03 0A 10 03 00 }
	condition:
		$1
}

rule file_66_0_1 {
	meta:
		name = "ieee754sp_finite"
		size = 16
	strings:
		$1 = { 40 20 04 00 00 FF 02 3C 08 00 E0 03 2B 10 82 00 }
	condition:
		$1
}

rule file_66_1_1 {
	meta:
		name = "ieee754sp_copysign"
		size = 20
	strings:
		$1 = { 26 28 A4 00 00 80 02 3C 24 10 A2 00 08 00 E0 03 26 10 44 00 }
	condition:
		$1
}

rule file_67_0_1 {
	meta:
		name = "ieee754dp_1e31"
		size = 20
	strings:
		$1 = { C0 1A 04 00 1E 04 63 34 00 1D 03 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_70_0_1 {
	meta:
		name = "ieee754dp_nmodf"
		size = 452
		altNames = "__modf"
	strings:
		$1 = { 00 55 A3 7C FF FF 67 24 FE 07 E7 2C 21 10 80 00 C2 6F 05 00 5F 00 E0 10 00 98 A8 7C 01 FC 67 24 61 00 E0 04 34 00 E4 28 4D 00 80 10 34 00 04 24 10 00 09 3C 23 20 87 00 25 48 09 01 40 00 08 24 23 40 04 01 27 78 04 00 40 60 09 00 27 70 08 00 04 60 EC 01 06 28 82 00 42 C0 02 00 20 00 8B 30 06 50 89 00 06 C0 D8 01 25 28 85 01 04 48 09 01 20 00 0C 31 0B 28 4B 01 04 10 02 01 25 48 09 03 0B 48 4C 00 42 C0 05 00 0B 50 0B 00 06 78 F8 01 04 50 8A 00 0B 10 0C 00 40 C0 09 00 04 20 85 00 25 50 EA 01 06 10 02 01 C0 7A 0D 00 04 70 D8 01 EF FF 05 3C 0B 50 8B 00 06 40 09 01 FF FF A5 34 25 18 E3 01 25 10 C2 01 0B 10 0C 01 24 50 45 01 00 1D 03 00 0B 40 0C 00 0B 20 0B 00 25 50 43 01 25 28 48 00 00 00 C4 AC 26 00 A0 10 04 00 CA AC 21 00 00 11 20 18 03 71 3F 00 06 24 21 20 00 00 0F 00 66 10 21 28 00 00 01 00 66 24 27 48 06 00 42 50 02 00 06 50 2A 01 04 40 C8 00 20 00 C9 30 04 10 C2 00 25 40 48 01 0B 40 49 00 0B 10 09 00 00 35 08 00 02 23 02 00 25 20 C4 00 02 2B 08 00 0A 04 E7 24 23 18 E3 00 25 78 6F 00 00 7D 0F 00 25 28 AF 00 21 10 80 00 08 00 E0 03 21 18 A0 00 00 00 C2 AC 04 00 C5 AC 21 10 00 00 C0 2F 0D 00 08 00 E0 03 21 18 A0 00 20 18 43 70 ?? ?? ?? 0? 20 00 63 24 C0 2F 0D 00 21 10 00 00 08 00 E0 03 21 18 A0 00 09 00 60 54 00 00 C2 AC 25 40 88 00 06 00 00 51 00 00 C2 AC C0 6F 0D 00 04 00 CD AC 00 00 C0 AC 08 00 E0 03 21 18 A0 00 ?? ?? ?? 0? 04 00 C5 AC }
	condition:
		$1
}

rule file_71_0_1 {
	meta:
		name = "ieee754dp_qnan"
		size = 32
	strings:
		$1 = { C0 1A 04 00 FF 07 63 34 07 00 02 3C FF FF 42 34 00 1D 03 00 25 18 62 00 08 00 E0 03 FF FF 02 24 }
	condition:
		$1
}

rule file_73_0_1 {
	meta:
		name = "__frexp"
		size = 228
		refs = "00cc __ashldi3"
		altNames = "ieee754dp_nfrexp"
	strings:
		$1 = { D8 FF BD 27 14 00 B0 AF 00 55 B0 7C FF FF 02 26 FE 07 42 2C 1C 00 B2 AF 18 00 B1 AF 24 00 BF AF 21 88 C0 00 20 00 B3 AF C2 97 05 00 21 38 80 00 17 00 40 10 00 98 A6 7C 10 00 02 3C 01 FC 10 26 25 30 C2 00 C0 92 12 00 EF FF 05 3C FF FF A5 34 FE 03 52 36 01 00 10 26 24 30 C5 00 00 95 12 00 00 00 30 AE 21 20 E0 00 25 28 D2 00 24 00 BF 8F 21 10 80 00 21 18 A0 00 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 F6 FF 00 56 00 00 20 AE 25 10 86 00 03 00 40 14 00 00 00 00 ?? ?? ?? 0? 00 00 20 AE 03 00 C0 14 20 98 D3 70 20 98 93 70 20 00 73 26 F5 FF 73 26 E0 FF 60 12 02 FC 10 24 21 28 C0 00 ?? ?? ?? 0? 21 30 60 02 21 38 40 00 21 30 60 00 ?? ?? ?? 0? 23 80 13 02 }
	condition:
		$1
}

rule file_77_0_1 {
	meta:
		name = "ieee754dp_inf"
		size = 20
	strings:
		$1 = { C0 1A 04 00 FF 07 63 34 00 1D 03 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_78_0_1 {
	meta:
		name = "ieee754sp_cmp"
		size = 128
	strings:
		$1 = { 00 FF 02 3C 40 18 04 00 01 00 42 24 2B 18 62 00 19 00 60 50 C0 00 C2 7C 40 18 05 00 2B 10 62 00 15 00 40 10 C0 00 C2 7C 0E 00 80 04 21 18 A0 00 0A 00 A2 04 00 80 03 3C 2A 10 83 00 05 00 40 14 26 20 83 00 40 00 C2 7C 80 00 C6 7C 08 00 E0 03 0B 10 C4 00 08 00 E0 03 01 00 C2 30 ?? ?? ?? 0? 23 18 65 00 00 80 02 3C F3 FF A1 04 23 20 44 00 ?? ?? ?? 0? 00 80 03 3C 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_81_0_1 {
	meta:
		name = "__negdf2"
		size = 16
		altNames = "ieee754dp_neg"
	strings:
		$1 = { 00 80 03 3C 26 18 A3 00 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_85_0_1 {
	meta:
		name = "ieee754sp_nmodf"
		size = 332
		refs = "009c builddp"
	strings:
		$1 = { C0 3D 83 7C 21 10 80 00 FF FF 64 24 D8 FF BD 27 FE 00 84 2C 18 00 B2 AF 14 00 B1 AF 21 90 A0 00 24 00 BF AF 20 00 B4 AF 1C 00 B3 AF 10 00 B0 AF C2 8F 02 00 37 00 80 10 00 B0 45 7C 81 FF 70 24 38 00 00 06 17 00 04 2A 0B 00 80 14 17 00 13 24 00 00 42 AE C0 17 11 00 24 00 BF 8F 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 80 00 14 3C 23 98 70 02 25 A0 B4 00 06 30 74 02 7F FF 02 3C 04 30 66 02 FF FF 42 34 21 28 60 00 21 20 20 02 ?? ?? ?? 0? 24 30 C2 00 20 00 03 24 23 98 73 00 04 A0 74 02 06 A0 74 02 00 00 42 AE E7 FF 80 12 C0 17 11 00 20 18 83 72 1F 00 02 24 04 00 62 10 21 98 00 00 01 00 73 24 04 A0 74 02 42 9A 14 00 87 00 02 26 00 8A 11 00 23 10 43 00 24 00 BF 8F 25 10 51 00 C0 15 02 00 25 10 62 02 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 D0 FF 60 54 00 00 42 AE CE FF A0 50 00 00 42 AE 24 00 BF 8F C0 8F 11 00 00 00 51 AE 20 00 B4 8F 1C 00 B3 8F 18 00 B2 8F 14 00 B1 8F 10 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_86_0_1 {
	meta:
		name = "ieee754sp_class"
		size = 68
	strings:
		$1 = { C0 3D 83 7C FF FF 65 24 FE 00 A5 2C 00 B0 84 7C 03 00 A0 10 21 10 00 00 08 00 E0 03 00 00 00 00 05 00 60 14 08 00 03 24 02 00 02 24 01 00 03 24 08 00 E0 03 0A 10 64 00 04 00 02 24 08 00 E0 03 0B 10 64 00 }
	condition:
		$1
}

rule file_88_0_1 {
	meta:
		name = "ieee754dp_tstr"
		size = 1620
		refs = "0038 ieee754dp_finite 0058 ieee754dp_cmp 00a0 ieee754dp_zero 0194 malloc 01a4 ieee754dp_one 01b4 ieee754dp_nldexp 01dc ieee754dp_ten 01f8 ieee754dp_div 0208 ieee754dp_nmodf 021c ieee754dp_add 0238 ieee754dp_mul 0244 ieee754dp_tint 0530 ieee754dp_neg"
	strings:
		$1 = { 98 FF BD 27 54 00 B5 AF 50 00 B4 AF 64 00 BF AF 60 00 BE AF 5C 00 B7 AF 58 00 B6 AF 4C 00 B3 AF 48 00 B2 AF 44 00 B1 AF 40 00 B0 AF 68 00 A4 AF 6C 00 A5 AF 21 A0 C0 00 ?? ?? ?? 0? 21 A8 E0 00 3E 00 40 14 68 00 A4 8F 6C 00 A5 8F 0D 00 02 24 21 30 80 00 21 38 A0 00 ?? ?? ?? 0? 10 00 A2 AF 0F 00 40 10 ?? ?? 12 3C ?? ?? 52 26 64 00 BF 8F 21 10 40 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 ?? ?? ?? 0? 21 20 00 00 68 00 A4 8F 6C 00 A5 8F 21 30 40 00 21 38 60 00 01 00 02 24 ?? ?? ?? 0? 10 00 A2 AF 0F 00 40 10 64 00 BF 8F ?? ?? 12 3C ?? ?? 52 26 21 10 40 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 ?? ?? 12 3C ?? ?? 52 26 21 10 40 02 60 00 BE 8F 5C 00 B7 8F 58 00 B6 8F 54 00 B5 8F 50 00 B4 8F 4C 00 B3 8F 48 00 B2 8F 44 00 B1 8F 40 00 B0 8F 08 00 E0 03 68 00 BD 27 ?? ?? ?? 0? 21 20 00 00 68 00 A4 8F 6C 00 A5 8F 28 00 A2 AF 21 30 40 00 21 38 60 00 01 00 02 24 2C 00 A3 AF ?? ?? ?? 0? 10 00 A2 AF F0 00 40 14 68 00 A4 8F 6C 00 A5 8F 21 F0 00 00 28 00 A6 8F 2C 00 A7 8F 02 00 10 24 ?? ?? ?? 0? 10 00 B0 AF AA 00 40 10 21 B8 00 00 ?? ?? ?? 0? 25 00 04 24 B3 FF 40 10 21 90 40 00 ?? ?? ?? 0? 21 20 00 00 21 20 40 00 21 28 60 00 ?? ?? ?? 0? FA FF 06 24 30 00 A2 AF 34 00 A3 AF 24 00 50 26 24 00 40 A2 21 88 00 00 02 00 13 24 ?? ?? ?? 0? 24 00 16 24 ?? ?? ?? 0? FF FF 10 26 68 00 A4 8F 6C 00 A5 8F 21 38 60 00 21 30 40 00 38 00 A2 AF ?? ?? ?? 0? 3C 00 A3 AF 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 68 00 A6 27 30 00 A6 8F 34 00 A7 8F 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 38 00 A8 8F 3C 00 A9 8F 21 20 40 00 21 28 60 00 21 30 00 01 ?? ?? ?? 0? 21 38 20 01 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 30 00 42 24 01 00 31 26 09 00 36 12 00 00 02 A2 68 00 A4 8F 28 00 A6 8F 2C 00 A7 8F 6C 00 A5 8F ?? ?? ?? 0? 10 00 B3 AF D9 FF 40 10 21 20 00 00 00 00 82 2A 0B A0 02 00 01 00 82 26 2A 18 51 00 0E 00 60 10 21 88 37 02 21 10 02 02 00 00 43 80 00 00 40 A0 35 00 62 28 08 00 40 14 21 10 14 02 21 18 80 02 00 00 44 80 39 00 85 28 51 00 A0 10 FF FF 63 24 01 00 84 24 00 00 44 A0 04 00 C0 13 21 10 40 02 2D 00 02 24 00 00 42 A2 01 00 42 26 00 00 03 82 44 00 60 50 30 00 03 24 00 00 43 A0 01 00 10 26 01 00 42 24 FF FF 31 26 99 00 80 12 2E 00 03 24 00 00 43 A0 01 00 42 24 00 00 03 82 09 00 60 10 00 00 00 00 0F 00 80 52 45 00 03 24 00 00 43 A0 01 00 10 26 00 00 03 82 FF FF 94 26 F9 FF 60 14 01 00 42 24 06 00 80 1A 30 00 03 24 21 A0 54 00 00 00 43 A0 01 00 42 24 FE FF 54 54 00 00 43 A0 45 00 03 24 03 00 A3 12 47 00 B5 3A 65 00 04 24 0B 18 95 00 79 00 20 06 00 00 43 A0 2B 00 03 24 01 00 43 A0 2A 00 20 12 02 00 49 24 21 20 00 00 1B 00 A3 27 0A 00 05 24 1A 00 25 02 F4 01 A0 00 FF FF 63 24 01 00 84 24 10 30 00 00 30 00 C6 24 12 88 00 00 F8 FF 20 16 00 00 66 A0 01 00 02 24 70 00 82 10 30 00 02 24 FF FF 84 24 01 00 65 24 21 40 A4 00 ?? ?? ?? 0? 21 30 20 01 01 00 A5 24 00 00 67 90 21 18 A0 00 00 00 C7 A0 FB FF A8 14 01 00 C6 24 01 00 82 24 21 10 22 01 ?? ?? ?? 0? 00 00 40 A0 00 00 43 A0 ?? ?? ?? 0? 01 00 42 24 00 00 40 A0 AA FF 61 04 FF FF 42 24 FF FF 10 26 31 00 02 24 00 00 02 A2 ?? ?? ?? 0? 01 00 31 26 30 00 03 24 02 00 43 A0 03 00 43 A0 04 00 42 24 ?? ?? ?? 0? 00 00 40 A0 68 00 A4 8F 6C 00 A5 8F ?? ?? ?? 0? 20 00 A6 27 28 00 A6 8F 2C 00 A7 8F 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 10 00 B0 AF 48 00 40 10 00 00 00 00 ?? ?? ?? 0? 21 20 00 00 21 20 00 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 30 00 A2 AF 34 00 A3 AF ?? ?? ?? 0? 02 00 16 24 ?? ?? ?? 0? 01 00 F7 26 21 80 40 00 21 88 60 00 30 00 A6 8F 34 00 A7 8F 68 00 B2 8F 6C 00 B3 8F 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 38 60 00 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 21 30 40 00 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 20 00 A6 27 28 00 A6 8F 2C 00 A7 8F 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 10 00 B6 AF 21 20 00 02 21 28 20 02 30 00 A6 8F E2 FF 40 14 34 00 A7 8F 68 00 A4 8F 6C 00 A5 8F 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 68 00 A2 AF ?? ?? ?? 0? 6C 00 A3 AF 6C 00 A5 8F ?? ?? ?? 0? 01 00 1E 24 21 20 40 00 21 28 60 00 68 00 A2 AF ?? ?? ?? 0? 6C 00 A3 AF 2D 00 03 24 23 88 11 00 01 00 43 A0 ?? ?? ?? 0? 02 00 49 24 78 00 A3 8F 69 FF 60 50 00 00 03 82 ?? ?? ?? 0? 2E 00 03 24 00 00 22 A1 21 20 00 00 ?? ?? ?? 0? 01 00 29 25 ?? ?? ?? 0? 21 20 00 00 21 20 00 00 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 21 28 60 00 ?? ?? ?? 0? FF FF 06 24 30 00 A2 AF 34 00 A3 AF 02 00 12 24 34 00 A7 8F 30 00 A6 8F 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 68 00 A4 8F 6C 00 A5 8F 01 00 06 24 21 80 40 00 ?? ?? ?? 0? 21 88 60 00 21 20 40 00 21 38 20 02 21 30 00 02 21 28 60 00 68 00 A2 AF ?? ?? ?? 0? 6C 00 A3 AF 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 20 00 A6 27 28 00 A6 8F 2C 00 A7 8F 21 20 40 00 21 28 60 00 FF FF F7 26 ?? ?? ?? 0? 10 00 B2 AF E3 FF 40 50 34 00 A7 8F 68 00 A4 8F 6C 00 A5 8F 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 68 00 A2 AF ?? ?? ?? 0? 6C 00 A3 AF }
	condition:
		$1
}

rule file_90_0_1 {
	meta:
		name = "__gtsf2"
		size = 60
		refs = "0024 __ordersf2"
		altNames = "__gesf2"
	strings:
		$1 = { 00 FF 02 3C 40 18 04 00 01 00 42 24 2B 18 62 00 06 00 60 10 40 30 05 00 2B 10 C2 00 05 00 40 50 FF FF 02 24 ?? ?? ?? 0? 00 00 00 00 08 00 E0 03 FF FF 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_91_0_1 {
	meta:
		name = "ieee754dp_finite"
		size = 16
	strings:
		$1 = { 00 F0 A5 7C F0 7F 02 3C 08 00 E0 03 2B 10 A2 00 }
	condition:
		$1
}

rule file_91_1_1 {
	meta:
		name = "ieee754dp_copysign"
		size = 24
	strings:
		$1 = { 26 18 E5 00 00 80 02 3C 24 18 62 00 26 18 65 00 08 00 E0 03 21 10 80 00 }
	condition:
		$1
}

rule file_93_0_1 {
	meta:
		name = "__unorddf2"
		size = 104
	strings:
		$1 = { F0 7F 02 3C 00 F0 A5 7C 01 00 43 24 2B 18 A3 00 0F 00 60 50 01 00 02 24 0A 00 A2 10 F0 7F 03 3C 00 F0 E7 7C 01 00 64 24 2B 20 E4 00 08 00 80 10 01 00 02 24 08 00 E3 10 00 00 00 00 08 00 E0 03 21 10 00 00 F6 FF 80 10 00 00 00 00 01 00 02 24 08 00 E0 03 00 00 00 00 FD FF C0 50 21 10 00 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_94_1_1 {
	meta:
		name = "ieee754sp_funs"
		size = 56
		refs = "0010 ieee754sp_fint 0030 ieee754sp_add"
	strings:
		$1 = { E8 FF BD 27 04 00 80 04 14 00 BF AF 14 00 BF 8F ?? ?? ?? 0? 18 00 BD 27 C4 FF 04 7C ?? ?? ?? 0? 00 00 00 00 21 28 40 00 14 00 BF 8F 00 4F 04 3C ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_96_0_1 {
	meta:
		name = "ieee754dp_ten"
		size = 28
	strings:
		$1 = { C0 1A 04 00 02 04 63 34 04 00 02 3C 00 1D 03 00 25 18 62 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_101_1_1 {
	meta:
		name = "ieee754dp_fulong"
		size = 60
		refs = "0010 ieee754dp_flong 0034 ieee754dp_add"
	strings:
		$1 = { E8 FF BD 27 04 00 A0 04 14 00 BF AF 14 00 BF 8F ?? ?? ?? 0? 18 00 BD 27 ?? ?? ?? 0? 00 F0 A5 7C 21 30 40 00 14 00 BF 8F 21 38 60 00 21 20 00 00 E0 43 05 3C ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_103_0_1 {
	meta:
		name = "__addsf3"
		size = 692
		altNames = "ieee754sp_add"
	strings:
		$1 = { C0 3D 83 7C FF FF 66 24 FE 00 C6 2C 21 10 A0 00 C2 4F 04 00 70 00 C0 10 00 B0 87 7C 80 00 05 3C 81 FF 63 24 25 38 E5 00 21 40 00 00 C0 3D 45 7C FF FF AB 24 FE 00 6B 2D C2 57 02 00 55 00 60 11 00 B0 46 7C 80 00 0B 3C 25 30 CB 00 81 FF A5 24 21 60 00 00 55 00 00 15 21 58 00 01 23 28 65 00 C0 38 07 00 3D 00 A0 18 C0 30 06 00 1B 00 A2 28 2B 00 40 10 23 10 05 00 04 10 46 00 06 28 A6 00 2B 30 02 00 25 30 C5 00 28 00 2A 11 21 10 C7 00 23 30 E6 00 2F 00 C0 10 21 10 00 00 39 00 C2 04 23 30 06 00 20 20 C4 70 FB FF 84 24 04 10 86 00 23 18 64 00 7F 00 63 24 4F 00 60 18 01 00 04 24 07 00 44 30 0A 00 80 10 FF 00 64 28 C0 00 44 7C 03 00 42 24 21 10 44 00 C2 26 02 00 04 00 80 10 FF 00 64 28 42 10 02 00 01 00 63 24 FF 00 64 28 4C 00 80 50 00 12 09 00 C2 10 02 00 C0 05 44 7C 02 00 80 50 21 18 00 00 00 B0 42 7C 00 4A 09 00 25 18 69 00 C0 1D 03 00 08 00 E0 03 25 10 62 00 DB FF 2A 15 01 00 06 24 21 10 C7 00 C2 26 02 00 E1 FF 80 50 7F 00 63 24 42 20 02 00 01 00 42 30 01 00 63 24 ?? ?? ?? 0? 25 10 44 00 BF 7F 02 3C FF FF 42 34 08 00 E0 03 00 00 00 00 CA FF A0 10 23 10 05 00 1B 00 44 28 08 00 80 10 23 18 65 00 04 28 A7 00 06 10 47 00 2B 38 05 00 ?? ?? ?? 0? 25 38 E2 00 ?? ?? ?? 0? 21 48 40 01 ?? ?? ?? 0? 01 00 07 24 28 00 A0 14 00 00 00 00 32 00 C0 14 02 00 0C 24 01 00 0C 24 01 00 0B 35 01 00 0D 24 30 00 6D 15 03 00 0D 24 01 00 03 31 24 60 6C 00 1B 00 80 11 01 00 08 39 E2 FF 2A 51 0B 10 88 00 08 00 E0 03 21 10 00 00 1C 00 60 54 04 00 08 24 02 00 08 24 82 FF 03 24 01 00 05 24 0A 40 A7 00 ?? ?? ?? 0? 0A 18 07 00 23 18 83 00 1B 00 64 28 15 00 80 50 21 10 00 00 23 20 03 00 04 20 82 00 06 18 62 00 2B 10 04 00 25 10 43 00 ?? ?? ?? 0? 01 00 03 24 FF 00 42 34 08 00 E0 03 C0 15 02 00 08 00 E0 03 0B 10 88 00 09 00 C0 54 08 00 0C 24 04 00 0C 24 ?? ?? ?? 0? 04 00 0B 35 08 00 05 24 ?? ?? ?? 0? 0B 40 A7 00 ?? ?? ?? 0? 21 18 00 00 ?? ?? ?? 0? 08 00 0B 35 82 FF 05 24 ?? ?? ?? 0? 02 00 0B 35 D0 FF 6D 11 08 00 6D 31 B3 FF A0 15 04 00 6B 31 76 FF 60 51 23 28 65 00 24 60 88 01 06 00 80 51 04 00 08 39 AE FF 2A 11 21 10 80 00 BF 7F 02 3C 08 00 E0 03 FF FF 42 34 08 00 E0 03 0A 10 88 00 }
	condition:
		$1
}

rule file_105_0_1 {
	meta:
		name = "__fixunssfsi"
		size = 88
		refs = "0010 __ordersf2 0020 __subsf3 0028 __fixsfsi"
	strings:
		$1 = { E8 FF BD 27 00 4F 05 3C 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? 21 80 80 00 0B 00 40 04 21 20 00 02 ?? ?? ?? 0? 00 4F 05 3C ?? ?? ?? 0? 21 20 40 00 14 00 BF 8F 00 80 03 3C 25 10 43 00 10 00 B0 8F 08 00 E0 03 18 00 BD 27 14 00 BF 8F 10 00 B0 8F ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_113_0_1 {
	meta:
		name = "ieee754sp_tuns"
		size = 88
		refs = "0010 ieee754sp_order 0020 ieee754sp_sub 0028 ieee754sp_tint"
	strings:
		$1 = { E8 FF BD 27 00 4F 05 3C 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? 21 80 80 00 0B 00 40 04 21 20 00 02 ?? ?? ?? 0? 00 4F 05 3C ?? ?? ?? 0? 21 20 40 00 14 00 BF 8F 00 80 03 3C 25 10 43 00 10 00 B0 8F 08 00 E0 03 18 00 BD 27 14 00 BF 8F 10 00 B0 8F ?? ?? ?? 0? 18 00 BD 27 }
	condition:
		$1
}

rule file_109_0_1 {
	meta:
		name = "__orderdf2"
		size = 152
		altNames = "ieee754dp_order"
	strings:
		$1 = { 21 18 C0 00 19 00 A0 04 21 10 E0 00 0D 00 E2 04 23 18 06 00 11 00 83 10 00 00 00 00 2A 30 45 00 1B 00 C0 54 01 00 02 24 19 00 A2 14 FF FF 02 24 2B 20 64 00 16 00 80 10 00 00 00 00 08 00 E0 03 01 00 02 24 2B 10 03 00 23 38 07 00 23 10 E2 00 00 80 06 3C F1 FF 83 14 26 10 46 00 F0 FF A2 14 2A 30 45 00 08 00 E0 03 21 10 00 00 23 20 04 00 2B 40 04 00 23 28 05 00 23 28 A8 00 00 80 08 3C E4 FF E1 04 26 28 A8 00 ?? ?? ?? 0? 23 18 06 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_110_1_1 {
	meta:
		name = "ieee754dp_fstr"
		size = 56
		refs = "0014 ieee754dp_nfstr"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 80 80 00 21 20 A0 00 14 00 BF AF ?? ?? ?? 0? 21 28 C0 00 00 00 02 AE 04 00 03 AE 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_111_1_1 {
	meta:
		name = "ieee754dp_sqrt"
		size = 56
		refs = "0014 ieee754dp_nsqrt"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 28 E0 00 21 80 80 00 14 00 BF AF ?? ?? ?? 0? 21 20 C0 00 00 00 02 AE 04 00 03 AE 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_115_0_1 {
	meta:
		name = "ieee754sp_one"
		size = 16
	strings:
		$1 = { 00 12 04 00 7F 00 42 34 08 00 E0 03 C0 15 02 00 }
	condition:
		$1
}

rule file_117_1_1 {
	meta:
		name = "ieee754sp_sqrt"
		size = 48
		refs = "0010 ieee754sp_nsqrt"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 21 80 80 00 14 00 BF AF ?? ?? ?? 0? 21 20 A0 00 00 00 02 AE 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_118_0_1 {
	meta:
		name = "ieee754sp_qnan"
		size = 28
	strings:
		$1 = { 00 22 04 00 FF 00 84 34 3F 00 02 3C C0 25 04 00 FF FF 42 34 08 00 E0 03 25 10 82 00 }
	condition:
		$1
}

rule file_120_0_1 {
	meta:
		name = "ieee754dp_min"
		size = 20
	strings:
		$1 = { C0 1A 04 00 01 00 63 34 00 1D 03 00 08 00 E0 03 21 10 00 00 }
	condition:
		$1
}

rule file_0_0_2 {
	meta:
		name = "exsqrt"
		size = 664
	strings:
		$1 = { A0 00 A0 10 00 00 00 00 01 00 CF 30 0E 00 E0 11 00 00 00 00 F2 67 0A 3C 00 18 4A 35 19 00 AA 00 10 50 00 00 13 4D 01 3C 00 48 21 34 21 50 41 01 42 20 04 00 C0 7F 05 00 25 20 8F 00 42 28 05 00 07 00 00 10 01 00 C6 24 00 93 0A 3C 19 00 AA 00 10 50 00 00 FF 6C 01 3C 00 FC 21 34 21 50 41 01 43 30 06 00 FF 01 C6 24 42 20 04 00 C0 7F 05 00 25 20 8F 00 42 28 05 00 02 54 0A 00 F4 01 40 01 1B 00 AA 00 12 40 00 00 C0 53 0A 00 00 44 08 00 21 50 48 01 2B 78 48 01 23 50 4F 01 02 6C 0A 00 F4 01 A0 01 1B 00 AD 00 12 38 00 00 10 70 00 00 FF FF 4B 31 19 00 67 01 12 60 00 00 00 74 0E 00 02 7C 04 00 25 70 CF 01 2B 78 CC 01 06 00 E0 11 23 70 CC 01 FF FF E7 24 21 70 CA 01 2B 08 CA 01 FC FF 20 10 00 00 00 00 F4 01 A0 01 1B 00 CD 01 12 40 00 00 10 70 00 00 19 00 68 01 12 60 00 00 00 74 0E 00 FF FF 8F 30 25 70 CF 01 2B 78 CC 01 06 00 E0 11 23 70 CC 01 FF FF 08 25 21 70 CA 01 2B 08 CA 01 FC FF 20 10 00 00 00 00 00 7C 07 00 21 40 0F 01 42 50 0A 00 21 50 48 01 2B 78 48 01 23 50 4F 01 02 6C 0A 00 F4 01 A0 01 1B 00 AD 00 12 40 00 00 10 70 00 00 FF FF 4B 31 19 00 68 01 12 60 00 00 00 74 0E 00 02 7C 04 00 25 70 CF 01 2B 78 CC 01 06 00 E0 11 23 70 CC 01 FF FF 08 25 21 70 CA 01 2B 08 CA 01 FC FF 20 10 00 00 00 00 F4 01 A0 01 1B 00 CD 01 12 60 00 00 10 70 00 00 19 00 6C 01 12 68 00 00 00 74 0E 00 FF FF 8F 30 25 70 CF 01 2B 78 CD 01 06 00 E0 11 23 70 CD 01 FF FF 8C 25 21 70 CA 01 2B 08 CA 01 FC FF 20 10 00 00 00 00 00 44 08 00 21 40 0C 01 02 64 0A 00 F4 01 80 01 1B 00 CC 01 12 28 00 00 10 70 00 00 FF FF 4B 31 19 00 65 01 12 68 00 00 00 74 0E 00 2B 78 CD 01 06 00 E0 11 23 70 CD 01 FF FF A5 24 21 70 CA 01 2B 08 CA 01 FC FF 20 10 00 00 00 00 F4 01 80 01 1B 00 CC 01 12 38 00 00 10 70 00 00 19 00 67 01 12 68 00 00 00 74 0E 00 2B 78 CD 01 06 00 E0 11 23 70 CD 01 FF FF E7 24 21 70 CA 01 2B 08 CA 01 FC FF 20 10 00 00 00 00 00 7C 05 00 21 38 EF 00 C0 5F 0A 00 42 50 0A 00 21 38 EB 00 2B 78 EB 00 21 40 0A 01 21 40 0F 01 25 28 08 00 25 20 07 00 25 10 04 00 25 18 05 00 25 C0 06 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_0_1_2 {
	meta:
		name = "dpsqrt"
		size = 804
		refs = "0050 exsqrt"
	strings:
		$1 = { E8 FF BD 27 00 00 BF AF 02 45 05 00 C0 3A 05 00 42 7D 04 00 25 38 EF 00 C0 32 04 00 00 80 01 3C 25 38 E1 00 FF FF 0F 25 FE 07 E1 2D 88 00 20 10 00 00 00 00 04 00 A4 AF 08 00 A5 AF 0C 00 A6 AF 10 00 A7 AF 14 00 A8 AF 25 20 06 00 25 28 07 00 ?? ?? ?? 0? 25 30 08 00 25 58 18 00 25 50 03 00 25 48 02 00 14 00 A8 8F 10 00 A7 8F 0C 00 A6 8F 08 00 A5 8F 04 00 A4 8F 01 00 0F 31 05 00 E0 11 00 00 00 00 42 30 06 00 C0 7F 07 00 25 30 CF 00 42 38 07 00 19 00 49 01 12 68 00 00 10 60 00 00 2A 78 A0 01 21 68 AD 01 21 60 8C 01 21 60 8F 01 19 00 4A 01 12 20 00 00 10 70 00 00 21 60 84 01 19 00 29 01 12 70 00 00 10 20 00 00 21 68 A4 01 2B 78 A4 01 21 60 8F 01 23 60 86 01 25 78 8D 01 25 78 EE 01 49 00 E0 11 00 00 00 00 22 00 80 05 00 00 00 00 01 00 2F 2D FF FF 29 25 23 50 4F 01 01 00 CF 2D FF FF CE 25 00 00 E2 25 2B 78 A2 01 23 68 A2 01 23 60 8F 01 2B 78 C9 01 23 70 C9 01 2B 10 AF 01 23 68 AF 01 2B 78 AA 01 25 78 E2 01 23 68 AA 01 23 60 8F 01 2B 78 C9 01 23 70 C9 01 2B 10 AF 01 23 68 AF 01 2B 78 AA 01 25 78 E2 01 23 68 AA 01 23 60 8F 01 2C 00 80 05 00 00 00 00 25 78 8D 01 25 78 EE 01 E2 FF E0 15 00 00 00 00 26 00 00 10 00 00 00 00 01 00 29 25 01 00 2F 2D 21 50 4F 01 2B 78 4F 01 1D 00 E0 15 00 00 00 00 21 70 C9 01 2B 78 C9 01 21 68 AA 01 21 68 AF 01 02 00 AA 11 00 00 00 00 2B 78 AA 01 21 60 8F 01 21 70 C9 01 2B 78 C9 01 21 68 AA 01 21 68 AF 01 02 00 AA 11 00 00 00 00 2B 78 AA 01 21 60 8F 01 01 00 CF 2D FF FF CE 25 00 00 E2 25 2B 78 A2 01 23 68 A2 01 23 60 8F 01 E3 FF 80 05 00 00 00 00 25 78 8D 01 25 78 EE 01 04 00 E0 11 00 00 00 00 01 00 2F 2D FF FF 29 25 23 50 4F 01 00 04 29 25 00 04 2F 2D 21 50 4F 01 2B 78 4F 01 21 58 6F 01 C2 22 09 00 40 7D 0A 00 25 20 8F 00 40 28 0A 00 02 2B 05 00 00 7D 0B 00 25 28 AF 00 25 10 04 00 25 18 05 00 00 00 BF 8F 08 00 E0 03 18 00 BD 27 07 00 A1 04 00 00 00 00 40 78 05 00 25 78 E4 01 26 00 E0 15 00 00 00 00 F4 FF 00 10 00 00 00 00 1B 00 00 15 00 00 00 00 2A 78 C0 00 21 30 C6 00 21 38 E7 00 21 38 EF 00 25 78 E6 00 20 00 E0 11 00 00 00 00 08 00 E0 14 00 00 00 00 03 00 C0 14 00 00 00 00 63 FF 00 10 00 00 08 24 25 38 C0 00 00 00 06 24 E0 FF 08 25 20 60 EC 70 5D FF 80 11 00 00 00 00 23 40 0C 01 22 68 0C 00 06 68 A6 01 04 30 86 01 04 38 87 01 56 FF 00 10 25 38 ED 00 40 78 07 00 25 78 E6 01 04 00 E0 15 00 00 00 00 25 10 04 00 D3 FF 00 10 25 18 05 00 F8 FF 05 3C 00 00 04 24 25 10 04 00 CE FF 00 10 25 18 05 00 00 00 04 24 25 28 04 00 25 10 04 00 C9 FF 00 10 25 18 05 00 }
	condition:
		$1
}

rule file_1_0_2 {
	meta:
		name = "log10f"
		size = 192
		refs = "0000 math_errhandling 0020 fpcmp 003c dptofp 0030 errno 005c __mchp_log10f 0068 fptodp 0074 isinfl"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C E8 FF BD 27 10 00 B0 AF 01 00 42 30 14 00 BF AF 21 00 40 10 21 80 80 00 ?? ?? ?? 0? 21 28 00 00 0C 00 41 04 21 00 03 24 ?? ?? 02 3C 21 20 00 00 F8 FF 05 3C ?? ?? ?? 0? ?? ?? 43 AC 21 80 40 00 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 F2 FF 40 10 14 00 BF 8F ?? ?? 02 3C 22 00 03 24 ?? ?? 43 AC 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 21 80 40 00 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_5_0_2 {
	meta:
		name = "logf"
		size = 192
		refs = "0000 math_errhandling 0020 fpcmp 003c dptofp 0030 errno 005c __mchp_logf 0068 fptodp 0074 isinfl"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C E8 FF BD 27 10 00 B0 AF 01 00 42 30 14 00 BF AF 21 00 40 10 21 80 80 00 ?? ?? ?? 0? 21 28 00 00 0C 00 41 04 21 00 03 24 ?? ?? 02 3C 21 20 00 00 F8 FF 05 3C ?? ?? ?? 0? ?? ?? 43 AC 21 80 40 00 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 21 80 40 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 F2 FF 40 10 14 00 BF 8F ?? ?? 02 3C 22 00 03 24 ?? ?? 43 AC 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 ?? ?? ?? 0? 00 00 00 00 14 00 BF 8F 21 80 40 00 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_2_1_2 {
	meta:
		name = "fpadd"
		size = 620
	strings:
		$1 = { C2 4D 04 00 FF 00 29 31 C2 5D 05 00 FF 00 6B 31 00 80 07 3C 00 42 04 00 25 40 07 01 00 52 05 00 25 50 47 01 FF FF 2D 25 FE 00 A1 2D 61 00 20 10 00 00 00 00 FF FF 6D 25 FE 00 A1 2D 77 00 20 10 00 00 00 00 23 60 2B 01 0D 00 80 05 00 00 00 00 20 00 81 29 03 00 20 14 00 00 00 00 15 00 00 10 02 00 0A 24 25 30 0A 00 06 50 8A 01 04 68 8A 01 10 00 A6 11 00 00 00 00 0E 00 00 10 02 00 4A 35 25 48 0B 00 23 60 0C 00 20 00 81 29 03 00 20 14 00 00 00 00 07 00 00 10 02 00 08 24 25 30 08 00 06 40 88 01 04 68 88 01 02 00 A6 11 00 00 00 00 02 00 08 35 24 60 87 00 26 68 85 01 10 00 A0 05 00 00 00 00 21 40 0A 01 2B 68 0A 01 17 00 A0 11 00 00 00 00 01 00 0D 31 02 00 A0 11 00 00 00 00 02 00 08 35 42 40 08 00 01 00 29 25 FF 00 01 24 0E 00 21 15 00 00 00 00 0C 00 00 10 00 00 08 24 2B 68 0A 01 04 00 A0 11 23 40 0A 01 23 40 08 00 03 00 00 10 26 60 87 01 50 00 00 11 00 00 00 00 20 30 06 71 23 48 26 01 04 40 C8 00 0E 00 20 19 00 00 00 00 80 00 08 25 80 00 0D 2D 21 48 2D 01 02 6A 08 00 01 00 AD 31 23 40 0D 01 40 40 08 00 42 42 08 00 C0 6D 09 00 25 40 0D 01 25 10 0C 01 08 00 E0 03 00 00 00 00 01 00 06 24 23 30 C9 00 20 00 C1 2C 39 00 20 10 00 00 00 00 00 80 01 3C 25 40 01 01 20 00 0D 24 23 68 A6 01 04 48 A8 01 02 00 20 11 06 40 C8 00 01 00 08 35 00 00 09 24 80 00 0D 25 E3 FF A1 05 00 00 00 00 E1 FF 00 10 01 00 09 24 0E 00 20 15 00 00 00 00 21 40 08 01 05 00 00 11 00 00 00 00 20 60 0C 71 23 48 2C 01 98 FF 00 10 04 40 88 01 FF 00 01 24 0F 00 61 11 00 00 00 00 00 80 01 3C 18 00 A1 14 00 00 00 00 21 68 08 01 1B 00 A0 15 00 00 00 00 FF 00 01 24 14 00 61 15 00 00 00 00 26 68 85 00 15 00 A0 05 00 00 00 00 0D 00 00 10 00 00 00 00 08 00 60 15 00 00 00 00 21 50 4A 01 0A 00 40 11 00 00 00 00 20 60 4C 71 23 58 6C 01 82 FF 00 10 04 50 8A 01 21 68 4A 01 07 00 A0 15 00 00 00 00 C4 FF 00 10 25 10 05 00 C2 FF 00 10 25 10 04 00 C0 FF 00 10 00 00 02 24 BE FF 00 10 C0 FF 02 3C }
	condition:
		$1
}

rule file_2_2_2 {
	meta:
		name = "fpmul"
		size = 440
	strings:
		$1 = { C2 3D 04 00 FF 00 E7 30 C2 4D 05 00 FF 00 29 31 00 80 0A 3C 00 32 04 00 25 30 CA 00 00 42 05 00 25 40 0A 01 26 60 85 00 24 50 4C 01 FF FF EC 24 FE 00 81 2D 21 00 20 10 00 00 00 00 FF FF 2C 25 FE 00 81 2D 36 00 20 10 00 00 00 00 19 00 C8 00 12 58 00 00 02 00 60 11 10 30 00 00 01 00 C6 34 03 00 C0 04 00 00 00 00 40 30 06 00 FF FF E7 24 82 FF 2C 25 21 38 EC 00 FF FF EC 24 FE 00 81 2D 3A 00 20 10 00 00 00 00 80 00 C6 24 80 00 CC 2C 21 38 EC 00 02 62 06 00 01 00 8C 31 23 30 CC 00 40 30 06 00 42 32 06 00 C0 65 07 00 25 30 CC 00 25 10 CA 00 08 00 E0 03 00 00 00 00 0D 00 E0 14 00 00 00 00 21 30 C6 00 05 00 C0 10 00 00 00 00 20 58 CB 70 23 38 EB 00 D8 FF 00 10 04 30 66 01 FF 00 01 24 1F 00 21 11 00 00 00 00 15 00 00 10 00 00 00 00 21 60 C6 00 1A 00 80 15 00 00 00 00 04 00 20 15 00 00 00 00 21 60 08 01 15 00 80 11 00 00 00 00 FF 00 01 24 0F 00 21 15 00 00 00 00 0A 00 20 15 00 00 00 00 21 40 08 01 05 00 00 11 00 00 00 00 20 58 0B 71 23 48 2B 01 C3 FF 00 10 04 40 68 01 DB FF 00 10 25 10 0A 00 21 60 08 01 04 00 80 15 00 00 00 00 80 7F 01 3C D5 FF 00 10 25 10 41 01 D3 FF 00 10 C0 FF 02 3C FA FF E0 1C 00 00 00 00 01 00 0B 24 23 58 67 01 20 00 61 2D F0 FF 20 10 00 00 00 00 20 00 0C 24 23 60 8B 01 04 38 86 01 02 00 E0 10 06 30 66 01 02 00 C6 34 00 00 07 24 80 00 CC 24 B7 FF 81 05 00 00 00 00 B5 FF 00 10 01 00 07 24 }
	condition:
		$1
}

rule file_2_3_2 {
	meta:
		name = "fpdiv"
		size = 556
	strings:
		$1 = { 00 80 0B 3C C2 45 04 00 FF 00 08 31 C2 55 05 00 FF 00 4A 31 00 3A 04 00 25 38 EB 00 00 4A 05 00 25 48 2B 01 26 70 85 00 24 58 6E 01 FF FF 0E 25 FE 00 C1 2D 3F 00 20 10 00 00 00 00 FF FF 4E 25 FE 00 C1 2D 53 00 20 10 00 00 00 00 2B 08 E9 00 03 00 20 14 00 00 00 00 42 38 07 00 01 00 08 25 82 63 09 00 F4 01 80 01 1B 00 EC 00 12 20 00 00 10 30 00 00 FF 3F 2D 31 19 00 A4 01 12 28 00 00 80 33 06 00 2B 70 C5 00 04 00 C0 11 23 30 C5 00 FF FF 84 24 21 30 C9 00 2B 70 C9 00 F4 01 80 01 1B 00 CC 00 12 38 00 00 10 30 00 00 19 00 A7 01 12 28 00 00 80 33 06 00 2B 70 C5 00 04 00 C0 11 23 30 C5 00 FF FF E7 24 21 30 C9 00 2B 70 C9 00 80 73 04 00 21 38 EE 00 02 00 C0 10 00 39 07 00 01 00 E7 34 7E 00 0E 24 23 70 CA 01 21 40 0E 01 FF FF 0E 25 FE 00 C1 2D 34 00 20 10 00 00 00 00 80 00 E7 24 80 00 EE 2C 21 40 0E 01 02 72 07 00 01 00 CE 31 23 38 EE 00 40 38 07 00 42 3A 07 00 C0 75 08 00 25 38 EE 00 25 10 EB 00 08 00 E0 03 00 00 00 00 08 00 00 15 00 00 00 00 21 38 E7 00 05 00 E0 10 00 00 00 00 20 60 EC 70 23 40 0C 01 BA FF 00 10 04 38 87 01 04 00 48 15 00 00 00 00 21 70 29 01 2F 00 C0 11 00 00 00 00 FF 00 01 24 08 00 41 11 00 00 00 00 12 00 00 11 00 00 00 00 21 70 E7 00 27 00 C0 15 00 00 00 00 22 00 00 10 00 00 00 00 08 00 40 15 00 00 00 00 21 48 29 01 1D 00 20 11 00 00 00 00 20 60 2C 71 23 50 4C 01 A6 FF 00 10 04 48 89 01 21 70 29 01 19 00 C0 15 00 00 00 00 D9 FF 00 10 25 10 0B 00 12 00 00 1D 00 00 00 00 01 00 0C 24 23 60 88 01 20 00 81 2D F8 FF 20 10 00 00 00 00 20 00 0E 24 23 70 CC 01 04 40 C7 01 02 00 00 11 06 38 87 01 02 00 E7 34 00 00 08 24 80 00 EE 24 BD FF C1 05 00 00 00 00 BB FF 00 10 01 00 08 24 80 7F 01 3C C3 FF 00 10 25 10 61 01 C1 FF 00 10 C0 FF 02 3C }
	condition:
		$1
}

rule file_2_4_2 {
	meta:
		name = "sitofp"
		size = 92
	strings:
		$1 = { 00 80 01 3C 12 00 80 10 24 30 81 00 02 00 81 04 00 00 00 00 23 20 04 00 9E 00 05 24 20 38 87 70 23 28 A7 00 04 20 E4 00 80 00 84 24 80 00 88 2C 21 28 A8 00 03 42 04 00 01 00 08 31 23 20 88 00 40 20 04 00 42 22 04 00 C0 45 05 00 25 20 88 00 25 10 86 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_2_5_2 {
	meta:
		name = "uitofp"
		size = 76
	strings:
		$1 = { 0F 00 80 10 00 00 00 00 9E 00 06 24 20 28 85 70 23 30 C5 00 04 20 A4 00 80 00 84 24 80 00 87 2C 21 30 C7 00 02 3A 04 00 01 00 E7 30 23 20 87 00 40 20 04 00 42 22 04 00 C0 3D 06 00 25 20 87 00 25 10 04 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_2_6_2 {
	meta:
		name = "fptosi"
		size = 120
	strings:
		$1 = { 00 2A 04 00 00 80 01 3C 25 28 A1 00 C2 3D 04 00 FF 00 E7 30 9E 00 06 24 23 30 C7 00 0C 00 C0 18 00 00 00 00 20 00 C1 28 03 00 20 14 00 00 00 00 05 00 00 10 00 00 02 24 02 00 81 04 06 28 C5 00 23 28 05 00 25 10 05 00 08 00 E0 03 00 00 00 00 80 7F 01 3C 01 00 21 34 2B 08 81 00 03 00 20 14 00 00 00 00 F8 FF 00 10 00 80 02 3C FF 7F 02 3C F5 FF 00 10 FF FF 42 34 }
	condition:
		$1
}

rule file_2_7_2 {
	meta:
		name = "fptoul"
		size = 116
	strings:
		$1 = { 00 2A 04 00 00 80 01 3C 25 28 A1 00 C2 3D 04 00 FF 00 E7 30 9E 00 06 24 23 30 C7 00 0C 00 C0 04 00 00 00 00 20 00 C1 28 03 00 20 14 00 00 00 00 05 00 00 10 00 00 02 24 02 00 81 04 06 28 C5 00 23 28 05 00 25 10 05 00 08 00 E0 03 00 00 00 00 80 7F 01 3C 01 00 21 34 2B 08 81 00 03 00 20 14 00 00 00 00 F8 FF 00 10 00 80 02 3C F6 FF 00 10 FF FF 02 24 }
	condition:
		$1
}

rule file_2_8_2 {
	meta:
		name = "fpcmp"
		size = 148
	strings:
		$1 = { FE FF 08 24 40 30 04 00 40 38 05 00 25 48 C7 00 1B 00 20 11 00 00 00 00 00 FF 01 3C 01 00 21 34 2B 08 C1 00 19 00 20 10 00 00 00 00 00 FF 01 3C 01 00 21 34 2B 08 E1 00 14 00 20 10 00 00 00 00 02 00 81 04 42 30 06 00 23 30 06 00 02 00 A1 04 42 38 07 00 23 38 07 00 2A 08 C7 00 03 00 20 10 00 00 00 00 07 00 00 10 FF FF 02 24 2A 08 E6 00 03 00 20 10 00 00 00 00 02 00 00 10 01 00 02 24 00 00 02 24 08 00 E0 03 00 00 00 00 FD FF 00 10 25 10 08 00 }
	condition:
		$1
}

rule file_2_9_2 {
	meta:
		name = "fpfabs"
		size = 16
	strings:
		$1 = { 40 10 04 00 42 10 02 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_2_10_2 {
	meta:
		name = "__negsf2"
		size = 16
	strings:
		$1 = { 00 80 01 3C 26 10 81 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_2_11_2 {
	meta:
		name = "fpnan"
		size = 76
	strings:
		$1 = { 40 30 04 00 00 FF 01 3C 01 00 21 34 2B 08 C1 00 03 00 20 14 00 00 00 00 0A 00 00 10 01 00 02 24 40 30 05 00 00 FF 01 3C 01 00 21 34 2B 08 C1 00 03 00 20 14 00 00 00 00 02 00 00 10 01 00 02 24 00 00 02 24 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_3_0_2 {
	meta:
		name = "_d_cmp"
		size = 288
	strings:
		$1 = { 40 48 05 00 40 50 07 00 25 50 44 01 25 50 46 01 25 48 2A 01 03 00 20 15 00 00 00 00 3C 00 00 10 00 00 02 24 02 00 80 10 40 40 05 00 01 00 08 25 E0 FF 01 3C 01 00 21 34 2B 08 01 01 36 00 20 10 00 00 00 00 02 00 C0 10 40 40 07 00 01 00 08 25 E0 FF 01 3C 01 00 21 34 2B 08 01 01 2E 00 20 10 00 00 00 00 16 00 A1 04 00 00 00 00 03 00 E0 04 00 00 00 00 26 00 00 10 01 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 1C 00 00 10 02 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 17 00 00 10 01 00 02 24 15 00 00 10 00 00 02 24 03 00 E1 04 00 00 00 00 11 00 00 10 02 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 07 00 00 10 01 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 02 00 00 10 02 00 02 24 00 00 02 24 08 00 E0 03 00 00 00 00 FD FF 00 10 03 00 02 24 }
	condition:
		$1
}

rule file_3_1_2 {
	meta:
		name = "_d_feq"
		size = 288
	strings:
		$1 = { 40 48 05 00 40 50 07 00 25 50 44 01 25 50 46 01 25 48 2A 01 03 00 20 15 00 00 00 00 3C 00 00 10 01 00 02 24 02 00 80 10 40 40 05 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 36 00 20 10 00 00 00 00 02 00 C0 10 40 40 07 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 2E 00 20 10 00 00 00 00 16 00 A1 04 00 00 00 00 03 00 E0 04 00 00 00 00 26 00 00 10 00 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 1C 00 00 10 00 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 17 00 00 10 00 00 02 24 15 00 00 10 01 00 02 24 03 00 E1 04 00 00 00 00 11 00 00 10 00 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 07 00 00 10 00 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 02 00 00 10 00 00 02 24 01 00 02 24 08 00 E0 03 00 00 00 00 FD FF 00 10 00 00 02 24 }
	condition:
		$1
}

rule file_3_2_2 {
	meta:
		name = "_d_fge"
		size = 268
	strings:
		$1 = { 40 48 05 00 40 50 07 00 25 50 44 01 25 50 46 01 25 48 2A 01 03 00 20 15 00 00 00 00 37 00 00 10 01 00 02 24 02 00 80 10 40 40 05 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 31 00 20 10 00 00 00 00 02 00 C0 10 40 40 07 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 29 00 20 10 00 00 00 00 16 00 A1 04 00 00 00 00 03 00 E0 04 00 00 00 00 21 00 00 10 00 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 17 00 00 10 01 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 12 00 00 10 00 00 02 24 10 00 00 10 01 00 02 24 03 00 E1 04 00 00 00 00 0C 00 00 10 01 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 02 00 00 10 00 00 02 24 01 00 02 24 08 00 E0 03 00 00 00 00 FD FF 00 10 00 00 02 24 }
	condition:
		$1
}

rule file_3_3_2 {
	meta:
		name = "_d_fgt"
		size = 268
	strings:
		$1 = { 40 48 05 00 40 50 07 00 25 50 44 01 25 50 46 01 25 48 2A 01 03 00 20 15 00 00 00 00 37 00 00 10 00 00 02 24 02 00 80 10 40 40 05 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 31 00 20 10 00 00 00 00 02 00 C0 10 40 40 07 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 29 00 20 10 00 00 00 00 11 00 A1 04 00 00 00 00 03 00 E0 04 00 00 00 00 21 00 00 10 00 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 17 00 00 10 01 00 02 24 15 00 00 10 00 00 02 24 03 00 E1 04 00 00 00 00 11 00 00 10 01 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 07 00 00 10 00 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 02 00 00 10 01 00 02 24 00 00 02 24 08 00 E0 03 00 00 00 00 FD FF 00 10 00 00 02 24 }
	condition:
		$1
}

rule file_3_4_2 {
	meta:
		name = "_d_fle"
		size = 268
	strings:
		$1 = { 40 48 05 00 40 50 07 00 25 50 44 01 25 50 46 01 25 48 2A 01 03 00 20 15 00 00 00 00 37 00 00 10 01 00 02 24 02 00 80 10 40 40 05 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 31 00 20 10 00 00 00 00 02 00 C0 10 40 40 07 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 29 00 20 10 00 00 00 00 11 00 A1 04 00 00 00 00 03 00 E0 04 00 00 00 00 21 00 00 10 01 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 17 00 00 10 00 00 02 24 15 00 00 10 01 00 02 24 03 00 E1 04 00 00 00 00 11 00 00 10 00 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 07 00 00 10 01 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 02 00 00 10 00 00 02 24 01 00 02 24 08 00 E0 03 00 00 00 00 FD FF 00 10 00 00 02 24 }
	condition:
		$1
}

rule file_3_5_2 {
	meta:
		name = "_d_flt"
		size = 268
	strings:
		$1 = { 40 48 05 00 40 50 07 00 25 50 44 01 25 50 46 01 25 48 2A 01 03 00 20 15 00 00 00 00 37 00 00 10 00 00 02 24 02 00 80 10 40 40 05 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 31 00 20 10 00 00 00 00 02 00 C0 10 40 40 07 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 29 00 20 10 00 00 00 00 16 00 A1 04 00 00 00 00 03 00 E0 04 00 00 00 00 21 00 00 10 01 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 17 00 00 10 00 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 12 00 00 10 01 00 02 24 10 00 00 10 00 00 02 24 03 00 E1 04 00 00 00 00 0C 00 00 10 00 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 02 00 00 10 01 00 02 24 00 00 02 24 08 00 E0 03 00 00 00 00 FD FF 00 10 00 00 02 24 }
	condition:
		$1
}

rule file_3_6_2 {
	meta:
		name = "_d_fne"
		size = 288
	strings:
		$1 = { 40 48 05 00 40 50 07 00 25 50 44 01 25 50 46 01 25 48 2A 01 03 00 20 15 00 00 00 00 3C 00 00 10 00 00 02 24 02 00 80 10 40 40 05 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 36 00 20 10 00 00 00 00 02 00 C0 10 40 40 07 00 01 00 08 35 E0 FF 01 3C 01 00 21 34 2B 08 01 01 2E 00 20 10 00 00 00 00 16 00 A1 04 00 00 00 00 03 00 E0 04 00 00 00 00 26 00 00 10 01 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 1C 00 00 10 01 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 17 00 00 10 01 00 02 24 15 00 00 10 00 00 02 24 03 00 E1 04 00 00 00 00 11 00 00 10 01 00 02 24 2B 48 86 00 23 20 86 00 2B 50 A9 00 23 28 A9 00 2B 48 A7 00 25 48 2A 01 03 00 20 11 23 28 A7 00 07 00 00 10 01 00 02 24 25 48 A4 00 03 00 20 11 00 00 00 00 02 00 00 10 01 00 02 24 00 00 02 24 08 00 E0 03 00 00 00 00 FD FF 00 10 01 00 02 24 }
	condition:
		$1
}

rule file_4_0_2 {
	meta:
		name = "lltofp"
		size = 188
	strings:
		$1 = { 00 80 01 3C 24 48 A1 00 25 38 05 00 25 30 04 00 25 58 A4 00 26 00 60 11 00 00 00 00 05 00 A1 04 00 00 00 00 2B 58 06 00 23 30 06 00 23 38 07 00 23 38 EB 00 08 00 E0 14 BE 00 08 24 03 00 C0 14 00 00 00 00 0D 00 00 10 00 00 08 24 25 38 C0 00 00 00 06 24 E0 FF 08 25 20 50 EA 70 07 00 40 11 00 00 00 00 23 40 0A 01 22 20 0A 00 06 20 86 00 04 30 46 01 04 38 47 01 25 38 E4 00 02 00 C0 10 00 00 00 00 01 00 E7 34 80 00 E7 24 80 00 EB 2C 21 40 0B 01 02 5A 07 00 01 00 6B 31 23 38 EB 00 40 38 07 00 42 3A 07 00 C0 5D 08 00 25 38 EB 00 25 10 E9 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_4_1_2 {
	meta:
		name = "ulltofp"
		size = 180
	strings:
		$1 = { 25 38 05 00 25 30 04 00 25 50 A4 00 26 00 40 11 00 00 00 00 05 00 A1 04 00 00 00 00 2B 50 06 00 23 30 06 00 23 38 07 00 23 38 EA 00 08 00 E0 14 BE 00 08 24 03 00 C0 14 00 00 00 00 0D 00 00 10 00 00 08 24 25 38 C0 00 00 00 06 24 E0 FF 08 25 20 48 E9 70 07 00 20 11 00 00 00 00 23 40 09 01 22 20 09 00 06 20 86 00 04 30 26 01 04 38 27 01 25 38 E4 00 02 00 C0 10 00 00 00 00 01 00 E7 34 80 00 E7 24 80 00 EA 2C 21 40 0A 01 02 52 07 00 01 00 4A 31 23 38 EA 00 40 38 07 00 42 3A 07 00 C0 55 08 00 25 38 EA 00 25 10 07 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_4_2_2 {
	meta:
		name = "fptoll"
		size = 204
	strings:
		$1 = { C2 3D 04 00 FF 00 E7 30 00 32 04 00 00 80 01 3C 25 30 C1 00 00 00 05 24 BE 00 E1 28 1D 00 20 10 00 00 00 00 BE 00 09 24 23 38 27 01 20 00 E1 2C 05 00 20 14 00 00 00 00 25 28 06 00 00 00 06 24 FA FF A0 14 E0 FF E7 24 08 00 E0 10 00 00 00 00 25 40 06 00 06 28 E5 00 06 30 E6 00 20 00 09 24 23 38 27 01 04 40 E8 00 25 28 A8 00 05 00 81 04 00 00 00 00 2B 48 05 00 23 28 05 00 23 30 06 00 23 30 C9 00 25 10 05 00 25 18 06 00 08 00 E0 03 00 00 00 00 07 00 80 04 00 00 00 00 FF 00 01 24 06 00 E1 14 00 00 00 00 40 48 06 00 03 00 20 11 00 00 00 00 F3 FF 00 10 00 80 06 3C FF 7F 06 3C FF FF C6 34 EF FF 00 10 FF FF 05 24 }
	condition:
		$1
}

rule file_4_3_2 {
	meta:
		name = "fptoull"
		size = 204
	strings:
		$1 = { C2 3D 04 00 FF 00 E7 30 00 32 04 00 00 80 01 3C 25 30 C1 00 00 00 05 24 BF 00 E1 28 1D 00 20 10 00 00 00 00 BF 00 09 24 23 38 27 01 20 00 E1 2C 05 00 20 14 00 00 00 00 25 28 06 00 00 00 06 24 FA FF A0 14 E0 FF E7 24 08 00 E0 10 00 00 00 00 25 40 06 00 06 28 E5 00 06 30 E6 00 20 00 09 24 23 38 27 01 04 40 E8 00 25 28 A8 00 05 00 81 04 00 00 00 00 2B 48 05 00 23 28 05 00 23 30 06 00 23 30 C9 00 25 10 05 00 25 18 06 00 08 00 E0 03 00 00 00 00 07 00 80 04 00 00 00 00 FF 00 01 24 06 00 E1 14 00 00 00 00 40 48 06 00 03 00 20 11 00 00 00 00 F3 FF 00 10 00 80 06 3C FF 7F 06 3C FF FF C6 34 EF FF 00 10 FF FF 05 24 }
	condition:
		$1
}

rule file_6_0_2 {
	meta:
		name = "expm1l"
		size = 1204
		refs = "0034 dpcmp 0084 copysignl 00a0 dpmul 00b0 litodp 00c4 dpadd 00d0 dptoli 0110 dpsub 01bc exp__E 01d4 ldexp 028c finitel"
	strings:
		$1 = { C8 FF BD 27 21 30 80 00 21 38 A0 00 18 00 B1 AF 14 00 B0 AF 34 00 BF AF 30 00 B7 AF 2C 00 B6 AF 28 00 B5 AF 24 00 B4 AF 20 00 B3 AF 1C 00 B2 AF 21 88 80 00 ?? ?? ?? 0? 21 80 A0 00 85 00 40 14 ?? ?? 06 3C ?? ?? C7 8C ?? ?? C6 8C 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 8B 00 40 1C ?? ?? 04 3C ?? ?? 85 8C ?? ?? 84 8C 21 30 20 02 ?? ?? ?? 0? 21 38 00 02 B4 00 40 1C ?? ?? 02 3C ?? ?? 44 8C 21 30 20 02 ?? ?? ?? 0? 21 38 00 02 21 90 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 00 02 ?? ?? ?? 0? 21 20 20 02 21 20 40 02 21 A0 40 00 ?? ?? ?? 0? 21 A8 60 00 21 30 40 00 21 38 60 00 21 20 80 02 ?? ?? ?? 0? 21 28 A0 02 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 ?? ?? ?? 0? 21 A0 40 00 21 B0 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 C0 02 21 28 60 00 ?? ?? ?? 0? 21 B8 60 00 21 30 40 00 21 20 20 02 21 28 00 02 ?? ?? ?? 0? 21 38 60 00 21 90 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 21 98 60 00 21 30 40 00 21 20 40 02 21 28 60 02 21 38 60 00 21 B0 40 00 ?? ?? ?? 0? 21 A8 60 00 21 88 60 00 21 20 40 02 21 28 60 02 21 30 40 00 21 38 20 02 ?? ?? ?? 0? 21 80 40 00 21 20 40 00 21 28 60 00 21 30 C0 02 ?? ?? ?? 0? 21 38 A0 02 21 98 40 00 82 00 80 12 21 90 60 00 01 00 02 24 4B 00 82 12 36 00 82 2A AA 00 40 14 ?? ?? 02 3C 64 00 82 2A 87 00 40 10 21 30 60 02 21 38 60 00 ?? ?? 12 3C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 ?? ?? 45 8E ?? ?? 44 8E 23 30 14 00 21 B8 60 00 ?? ?? ?? 0? 21 B0 40 00 ?? ?? ?? 0? 21 20 40 00 21 30 40 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 21 30 00 02 21 28 60 00 ?? ?? ?? 0? 21 38 20 02 ?? ?? 44 8E 21 A8 40 00 21 98 60 00 21 10 00 00 21 18 80 00 21 38 60 00 21 20 A0 02 21 30 40 00 ?? ?? ?? 0? 21 28 60 02 21 20 40 00 21 28 60 00 ?? ?? ?? 0? 21 30 80 02 ?? ?? ?? 0? 21 20 40 00 21 88 40 00 21 80 60 00 34 00 BF 8F 21 10 20 02 21 18 00 02 30 00 B7 8F 2C 00 B6 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 F0 FF 40 10 34 00 BF 8F ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C ?? ?? ?? 0? 88 13 06 24 ?? ?? ?? 0? 21 20 40 00 21 88 40 00 ?? ?? ?? 0? 21 80 60 00 ?? ?? 06 3C ?? ?? C7 8C ?? ?? C6 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 49 00 40 04 ?? ?? 02 3C 21 20 00 02 21 30 60 02 21 28 20 02 ?? ?? ?? 0? 21 38 40 02 21 20 40 00 21 28 60 00 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 21 20 40 00 ?? ?? ?? 0? 00 00 00 00 21 20 40 00 21 30 40 00 21 28 60 00 ?? ?? ?? 0? 21 38 60 00 21 88 40 00 ?? ?? ?? 0? 21 80 60 00 21 20 20 02 ?? ?? ?? 0? 21 28 00 02 ?? ?? 02 3C ?? ?? 50 8C 34 00 BF 8F 21 88 00 00 21 10 20 02 21 18 00 02 30 00 B7 8F 2C 00 B6 8F 28 00 B5 8F 24 00 B4 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 38 00 BD 27 21 20 00 02 21 28 20 02 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 21 30 00 02 21 38 20 02 ?? ?? ?? 0? 21 28 60 00 21 88 40 00 ?? ?? ?? 0? 21 80 60 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 21 28 60 00 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 21 A8 40 00 ?? ?? 02 3C ?? ?? 44 8C 21 98 60 00 ?? ?? ?? 0? 21 10 00 00 ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 20 00 02 21 30 60 02 21 28 20 02 21 38 40 02 21 A8 40 00 ?? ?? ?? 0? 21 A0 60 00 21 20 40 00 21 28 60 00 21 30 A0 02 ?? ?? ?? 0? 21 38 80 02 ?? ?? 56 8C ?? ?? 57 8C 23 30 14 00 21 20 C0 02 ?? ?? ?? 0? 21 28 E0 02 ?? ?? ?? 0? 21 20 40 00 21 30 40 00 21 20 C0 02 21 28 E0 02 ?? ?? ?? 0? 21 38 60 00 21 30 60 02 21 20 00 02 21 28 20 02 21 38 40 02 21 A8 40 00 ?? ?? ?? 0? 21 98 60 00 21 20 40 00 21 28 60 00 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 ?? ?? ?? 0? 21 20 60 00 }
	condition:
		$1
}

rule file_7_0_2 {
	meta:
		name = "log10"
		size = 212
		refs = "0000 math_errhandling 002c dpcmp 0038 errno 0068 __mchp_log10 007c isinfl"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C D8 FF BD 27 20 00 B1 AF 01 00 42 30 1C 00 B0 AF 24 00 BF AF 21 80 80 00 23 00 40 10 21 88 A0 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 0B 00 41 04 ?? ?? 02 3C 21 00 03 24 ?? ?? 43 AC 21 80 00 00 F8 FF 03 3C 24 00 BF 8F 21 10 00 02 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 28 60 00 21 20 40 00 10 00 A3 AF ?? ?? ?? 0? 21 80 40 00 F1 FF 40 10 10 00 A3 8F 24 00 BF 8F ?? ?? 02 3C 22 00 04 24 ?? ?? 44 AC 20 00 B1 8F 21 10 00 02 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 00 00 00 00 24 00 BF 8F 21 80 40 00 21 10 00 02 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_8_0_2 {
	meta:
		name = "log"
		size = 212
		refs = "0000 math_errhandling 002c dpcmp 0038 errno 0068 __mchp_log 007c isinfl"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C D8 FF BD 27 20 00 B1 AF 01 00 42 30 1C 00 B0 AF 24 00 BF AF 21 80 80 00 23 00 40 10 21 88 A0 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 0B 00 41 04 ?? ?? 02 3C 21 00 03 24 ?? ?? 43 AC 21 80 00 00 F8 FF 03 3C 24 00 BF 8F 21 10 00 02 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 28 60 00 21 20 40 00 10 00 A3 AF ?? ?? ?? 0? 21 80 40 00 F1 FF 40 10 10 00 A3 8F 24 00 BF 8F ?? ?? 02 3C 22 00 04 24 ?? ?? 44 AC 20 00 B1 8F 21 10 00 02 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? ?? 0? 00 00 00 00 24 00 BF 8F 21 80 40 00 21 10 00 02 20 00 B1 8F 1C 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_9_0_2 {
	meta:
		name = "ldexpf"
		size = 100
		refs = "000c __mchp_ldexpf 0018 math_errhandling 002c fptodp 0038 isinfl 0048 errno"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 80 40 00 ?? ?? 02 3C ?? ?? 42 8C 01 00 42 30 0B 00 40 10 14 00 BF 8F ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 03 00 40 10 22 00 03 24 ?? ?? 02 3C ?? ?? 43 AC 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_58_0_2 {
	meta:
		name = "coshf"
		size = 100
		refs = "000c __mchp_coshf 0018 math_errhandling 002c fptodp 0038 isinfl 0048 errno"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 80 40 00 ?? ?? 02 3C ?? ?? 42 8C 01 00 42 30 0B 00 40 10 14 00 BF 8F ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 03 00 40 10 22 00 03 24 ?? ?? 02 3C ?? ?? 43 AC 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_16_0_2 {
	meta:
		name = "expf"
		size = 100
		refs = "000c __mchp_expf 0018 math_errhandling 002c fptodp 0038 isinfl 0048 errno"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 80 40 00 ?? ?? 02 3C ?? ?? 42 8C 01 00 42 30 0B 00 40 10 14 00 BF 8F ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 03 00 40 10 22 00 03 24 ?? ?? 02 3C ?? ?? 43 AC 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_74_0_2 {
	meta:
		name = "sinhf"
		size = 100
		refs = "000c __mchp_sinhf 0018 math_errhandling 002c fptodp 0038 isinfl 0048 errno"
	strings:
		$1 = { E8 FF BD 27 10 00 B0 AF 14 00 BF AF ?? ?? ?? 0? 00 00 00 00 21 80 40 00 ?? ?? 02 3C ?? ?? 42 8C 01 00 42 30 0B 00 40 10 14 00 BF 8F ?? ?? ?? 0? 21 20 00 02 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 03 00 40 10 22 00 03 24 ?? ?? 02 3C ?? ?? 43 AC 14 00 BF 8F 21 10 00 02 10 00 B0 8F 08 00 E0 03 18 00 BD 27 }
	condition:
		$1
}

rule file_10_0_2 {
	meta:
		name = "hypotl"
		size = 1060
		refs = "0038 finite 0050 dpcmp 00e4 copysign 00e0 errno 00ec litodp 0208 logb 0238 dpsub 0270 dpdiv 028c dpmul 02a0 dpadd 02ac sqrt"
	strings:
		$1 = { C0 FF BD 27 30 00 B6 AF 2C 00 B5 AF 1C 00 B1 AF 18 00 B0 AF 3C 00 BF AF 38 00 BE AF 34 00 B7 AF 28 00 B4 AF 24 00 B3 AF 20 00 B2 AF 21 B0 80 00 21 A8 A0 00 21 80 C0 00 ?? ?? ?? 0? 21 88 E0 00 3C 00 40 14 21 30 C0 02 21 20 C0 02 21 28 A0 02 ?? ?? ?? 0? 21 38 A0 02 1C 00 40 10 ?? ?? 02 3C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 0A 00 40 14 3C 00 BF 8F 21 30 00 02 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 20 02 9E 00 40 10 21 B0 00 02 21 A8 20 02 3C 00 BF 8F 21 10 C0 02 21 18 A0 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 ?? ?? 46 8C ?? ?? 47 8C 21 20 C0 02 21 28 A0 02 22 00 03 24 ?? ?? 02 3C ?? ?? ?? 0? ?? ?? 43 AC ?? ?? ?? 0? 21 20 40 00 3C 00 BF 8F 21 B0 40 00 21 A8 60 00 21 10 C0 02 21 18 A0 02 38 00 BE 8F 34 00 B7 8F 30 00 B6 8F 2C 00 B5 8F 28 00 B4 8F 24 00 B3 8F 20 00 B2 8F 1C 00 B1 8F 18 00 B0 8F 08 00 E0 03 40 00 BD 27 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 CD FF 40 10 21 30 00 02 ?? ?? 14 3C ?? ?? 88 8E ?? ?? 89 8E 21 28 A0 02 21 30 00 01 21 38 20 01 21 20 C0 02 10 00 A8 AF ?? ?? ?? 0? 14 00 A9 AF ?? ?? ?? 0? 21 20 40 00 10 00 A8 8F 14 00 A9 8F 21 28 20 02 21 20 00 02 21 30 00 01 21 38 20 01 21 98 60 00 ?? ?? ?? 0? 21 90 40 00 ?? ?? ?? 0? 21 20 40 00 21 30 40 00 21 20 40 02 21 28 60 02 21 38 60 00 21 80 40 00 21 B0 40 02 21 A8 60 02 ?? ?? ?? 0? 21 88 60 00 54 00 42 04 21 B0 00 02 21 20 C0 02 21 28 A0 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 51 00 40 10 21 20 00 02 21 28 20 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 A6 FF 40 10 3C 00 BF 8F 21 20 C0 02 ?? ?? ?? 0? 21 28 A0 02 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 90 40 00 23 90 42 02 1F 00 52 2A 9A FF 40 12 21 20 C0 02 21 30 00 02 21 28 A0 02 ?? ?? ?? 0? 21 38 20 02 21 30 40 00 21 20 00 02 21 28 20 02 21 38 60 00 21 90 40 00 ?? ?? ?? 0? 21 98 60 00 36 00 41 04 ?? ?? 1E 3C 21 20 C0 02 21 30 00 02 21 28 A0 02 ?? ?? ?? 0? 21 38 20 02 21 30 40 00 21 20 40 00 21 28 60 00 21 38 60 00 21 98 40 00 ?? ?? ?? 0? 21 90 60 00 ?? ?? 86 8E ?? ?? 87 8E 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 20 40 00 21 20 40 00 21 28 60 00 21 30 60 02 ?? ?? ?? 0? 21 38 40 02 21 20 00 02 21 30 40 00 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 30 40 00 21 20 C0 02 21 28 A0 02 ?? ?? ?? 0? 21 38 60 00 21 B0 40 00 ?? ?? ?? 0? 21 A8 60 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 21 A8 20 02 21 80 40 02 ?? ?? ?? 0? 21 88 60 02 21 B0 00 00 ?? ?? ?? 0? 21 A8 00 00 21 20 40 02 21 30 00 02 21 28 60 02 ?? ?? ?? 0? 21 38 20 02 ?? ?? C6 8F ?? ?? C7 8F 21 90 60 00 21 28 40 02 21 20 40 00 ?? ?? ?? 0? 21 98 40 00 21 20 40 00 21 30 60 02 21 38 40 02 ?? ?? ?? 0? 21 28 60 00 ?? ?? C6 8F ?? ?? C7 8F 21 A0 60 00 21 28 80 02 21 20 40 00 ?? ?? ?? 0? 21 B8 40 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 30 40 00 21 20 E0 02 21 28 80 02 ?? ?? ?? 0? 21 38 60 00 21 20 40 00 21 30 60 02 21 38 40 02 ?? ?? ?? 0? 21 28 60 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 ?? ?? 06 3C ?? ?? C7 8C ?? ?? C6 8C 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 ?? ?? ?? 0? 21 20 00 02 }
	condition:
		$1
}

rule file_11_0_2 {
	meta:
		name = "cbrtl"
		size = 820
		refs = "0054 dpcmp 0094 dpmul 00ec dpdiv 0118 dpadd 0218 dpsub"
	strings:
		$1 = { C0 FF BD 27 F0 7F 02 3C 2C 00 B3 AF 24 98 82 00 20 00 B0 AF 3C 00 BF AF 38 00 B6 AF 34 00 B5 AF 30 00 B4 AF 28 00 B2 AF 24 00 B1 AF 21 80 80 00 40 00 A4 AF 44 00 A5 AF 10 00 A0 AF AF 00 62 12 14 00 A0 AF 44 00 B2 8F 21 30 00 00 21 38 00 00 21 28 40 02 ?? ?? ?? 0? 21 A0 80 00 90 00 40 10 3C 00 BF 8F 00 80 14 3C 24 A0 14 02 26 80 90 02 96 00 60 16 40 00 B0 AF 50 43 02 3C 10 00 A2 AF 40 00 B2 8F 44 00 B3 8F 10 00 A4 8F 14 00 A5 8F 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 AA AA 04 3C AB AA 84 34 19 00 44 00 7F 29 02 3C 14 00 A3 AF 93 78 42 24 10 28 00 00 42 18 05 00 21 10 62 00 10 00 A2 AF 10 00 B0 8F 14 00 B1 8F 21 20 00 02 21 28 20 02 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 21 20 40 00 21 30 40 02 21 38 60 02 ?? ?? ?? 0? 21 28 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 A8 60 00 21 B0 40 00 21 18 40 00 ?? ?? 02 3C ?? ?? 46 8C ?? ?? 47 8C 21 28 A0 02 ?? ?? ?? 0? 21 20 60 00 21 40 40 00 ?? ?? 02 3C ?? ?? 44 8C ?? ?? 45 8C 21 30 C0 02 21 38 A0 02 18 00 A8 AF ?? ?? ?? 0? 1C 00 A3 AF 18 00 A8 8F 1C 00 A9 8F 21 30 40 00 21 20 00 01 21 28 20 01 ?? ?? ?? 0? 21 38 60 00 ?? ?? 04 3C ?? ?? 85 8C ?? ?? 84 8C 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 ?? ?? 04 3C ?? ?? 86 8C ?? ?? 87 8C 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 01 00 42 24 14 00 A0 AF 10 00 A2 AF 10 00 B0 8F 14 00 B1 8F 21 20 00 02 21 28 20 02 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 21 30 40 00 21 20 40 02 21 28 60 02 ?? ?? ?? 0? 21 38 60 00 21 90 60 00 21 28 40 02 21 20 40 00 21 30 00 02 21 38 20 02 ?? ?? ?? 0? 21 98 40 00 21 20 00 02 21 28 20 02 21 30 00 02 21 38 20 02 21 B0 40 00 ?? ?? ?? 0? 21 A8 60 00 21 20 40 00 21 38 40 02 21 28 60 00 ?? ?? ?? 0? 21 30 60 02 21 30 40 00 21 20 C0 02 21 28 A0 02 ?? ?? ?? 0? 21 38 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 10 00 A2 AF 14 00 A3 AF 14 00 B2 8F 25 A0 82 02 3C 00 BF 8F 21 10 80 02 21 18 40 02 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 AA AA 02 3C AB AA 42 34 19 00 02 02 9F 2A 02 3C 93 78 42 24 40 00 B2 8F 44 00 B3 8F 10 88 00 00 42 18 11 00 21 10 62 00 ?? ?? ?? 0? 10 00 A2 AF 44 00 B2 8F 3C 00 BF 8F 21 A0 80 00 21 10 80 02 21 18 40 02 38 00 B6 8F 34 00 B5 8F 30 00 B4 8F 2C 00 B3 8F 28 00 B2 8F 24 00 B1 8F 20 00 B0 8F 08 00 E0 03 40 00 BD 27 }
	condition:
		$1
}

rule file_12_0_2 {
	meta:
		name = "atan2"
		size = 196
		refs = "0000 math_errhandling 003c dpcmp 0058 __mchp_atan2 009c errno"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C D8 FF BD 27 20 00 B3 AF 01 00 42 30 1C 00 B2 AF 18 00 B1 AF 14 00 B0 AF 24 00 BF AF 21 80 80 00 21 88 A0 00 21 90 C0 00 06 00 40 10 21 98 E0 00 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 0D 00 40 10 21 20 40 02 21 20 00 02 21 28 20 02 21 30 40 02 ?? ?? ?? 0? 21 38 60 02 24 00 BF 8F 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 21 28 60 02 21 30 00 00 ?? ?? ?? 0? 21 38 00 00 F0 FF 40 14 21 20 00 02 24 00 BF 8F 21 00 03 24 ?? ?? 02 3C ?? ?? 43 AC 20 00 B3 8F 21 10 00 00 F8 FF 03 3C 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_13_0_2 {
	meta:
		name = "dpatan2"
		size = 736
		refs = "009c exdiv 00ac exatan 0100 exsub"
	strings:
		$1 = { D0 FF BD 27 00 00 BF AF 40 50 05 00 42 55 0A 00 C0 4A 05 00 42 7D 04 00 25 48 2F 01 C0 42 04 00 00 80 0E 3C 25 48 2E 01 40 68 07 00 42 6D 0D 00 C0 62 07 00 42 7D 06 00 25 60 8F 01 C0 5A 06 00 25 60 8E 01 24 70 C5 01 FF FF 4F 25 FE 07 E1 2D 5A 00 20 10 00 00 00 00 FF FF AF 25 FE 07 E1 2D 75 00 20 10 00 00 00 00 04 00 A4 AF 08 00 A5 AF 0C 00 A6 AF 10 00 A7 AF 20 00 AB AF 24 00 AC AF 28 00 AD AF 2C 00 AE AF 25 20 08 00 25 28 09 00 25 30 0A 00 25 38 0B 00 25 40 0C 00 ?? ?? ?? 0? 25 48 0D 00 25 20 02 00 25 28 03 00 ?? ?? ?? 0? 25 30 18 00 25 50 18 00 25 48 03 00 25 40 02 00 2C 00 AE 8F 28 00 AD 8F 24 00 AC 8F 20 00 AB 8F 10 00 A7 8F 0C 00 A6 8F 08 00 A5 8F 15 00 E1 04 04 00 A4 8F 25 20 08 00 25 28 09 00 25 30 0A 00 68 21 07 3C 35 C2 E7 34 0F C9 08 3C A2 DA 08 35 ?? ?? ?? 0? 00 04 09 24 25 50 18 00 25 48 03 00 25 40 02 00 2C 00 AE 8F 28 00 AD 8F 24 00 AC 8F 20 00 AB 8F 10 00 A7 8F 0C 00 A6 8F 08 00 A5 8F 04 00 A4 8F 14 00 40 1D 00 00 00 00 01 00 06 24 23 30 CA 00 20 00 C1 2C 05 00 20 14 00 00 00 00 25 40 09 00 00 00 09 24 FA FF 00 15 E0 FF C6 24 08 00 C0 10 00 00 00 00 25 50 09 00 06 40 C8 00 06 48 C9 00 20 00 0F 24 23 30 E6 01 04 50 CA 00 25 40 0A 01 00 00 0A 24 C2 22 08 00 40 7D 09 00 25 20 8F 00 40 28 09 00 02 2B 05 00 00 7D 0A 00 25 28 AF 00 25 28 AE 00 25 10 04 00 25 18 05 00 00 00 BF 8F 08 00 E0 03 30 00 BD 27 07 00 40 11 00 00 00 00 40 78 09 00 25 78 E8 01 41 00 E0 15 00 00 00 00 A0 FF 00 10 00 10 0A 24 2A 78 00 01 21 40 08 01 21 48 29 01 21 48 2F 01 08 00 20 15 00 00 00 00 03 00 00 15 00 00 00 00 96 FF 00 10 00 00 0A 24 25 48 00 01 00 00 08 24 E0 FF 4A 25 20 30 26 71 90 FF C0 10 00 00 00 00 23 50 46 01 22 20 06 00 06 20 88 00 04 40 C8 00 04 48 C9 00 89 FF 00 10 25 48 24 01 0A 00 A0 11 00 00 00 00 40 78 0C 00 25 78 EB 01 22 00 E0 15 00 00 00 00 00 10 0D 24 1F 00 4D 11 00 00 00 00 82 FF 00 10 00 00 00 00 2A 78 60 01 21 58 6B 01 21 60 8C 01 21 60 8F 01 25 78 28 01 25 78 EC 01 25 78 EB 01 14 00 E0 11 00 00 00 00 08 00 80 15 00 00 00 00 03 00 60 15 00 00 00 00 73 FF 00 10 00 00 0D 24 25 60 60 01 00 00 0B 24 E0 FF AD 25 20 30 86 71 6D FF C0 10 00 00 00 00 23 68 A6 01 22 20 06 00 06 20 8B 00 04 58 CB 00 04 60 CC 00 66 FF 00 10 25 60 84 01 F8 FF 05 3C B3 FF 00 10 00 00 04 24 }
	condition:
		$1
}

rule file_14_0_2 {
	meta:
		name = "asin"
		size = 160
		refs = "0000 math_errhandling 0028 fabs 0040 dpcmp 0054 __mchp_asin 007c errno"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C E0 FF BD 27 18 00 B1 AF 01 00 42 30 14 00 B0 AF 1C 00 BF AF 21 80 80 00 0B 00 40 10 21 88 A0 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 85 8C ?? ?? 84 8C 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 0B 00 40 04 1C 00 BF 8F 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 1C 00 BF 8F 21 20 60 00 21 18 80 00 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 21 00 03 24 ?? ?? 02 3C F8 7F 04 3C ?? ?? 43 AC 18 00 B1 8F 21 10 00 00 21 18 80 00 14 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_31_0_2 {
	meta:
		name = "acos"
		size = 160
		refs = "0000 math_errhandling 0028 fabs 0040 dpcmp 0054 __mchp_acos 007c errno"
	strings:
		$1 = { ?? ?? 02 3C ?? ?? 42 8C E0 FF BD 27 18 00 B1 AF 01 00 42 30 14 00 B0 AF 1C 00 BF AF 21 80 80 00 0B 00 40 10 21 88 A0 00 ?? ?? ?? 0? 00 00 00 00 ?? ?? 04 3C ?? ?? 85 8C ?? ?? 84 8C 21 30 40 00 ?? ?? ?? 0? 21 38 60 00 0B 00 40 04 1C 00 BF 8F 21 20 00 02 ?? ?? ?? 0? 21 28 20 02 1C 00 BF 8F 21 20 60 00 21 18 80 00 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 20 00 BD 27 21 00 03 24 ?? ?? 02 3C F8 7F 04 3C ?? ?? 43 AC 18 00 B1 8F 21 10 00 00 21 18 80 00 14 00 B0 8F 08 00 E0 03 20 00 BD 27 }
	condition:
		$1
}

rule file_15_0_2 {
	meta:
		name = "dpfloor"
		size = 264
	strings:
		$1 = { 00 80 01 3C 24 30 A1 00 40 38 05 00 42 3D 07 00 FF 07 01 24 2B 00 E1 10 00 00 00 00 33 04 09 24 23 38 27 01 35 00 E1 2C 0B 00 20 14 00 00 00 00 20 00 E0 04 00 00 00 00 2D 00 C0 10 00 00 00 00 40 48 05 00 25 48 24 01 26 00 20 15 00 00 00 00 27 00 00 10 00 00 00 00 05 00 C0 10 00 00 00 00 2B 48 04 00 23 20 04 00 23 28 05 00 23 28 A9 00 1F 00 E9 30 01 00 08 24 04 40 28 01 23 40 08 00 20 00 E1 2C 04 00 20 14 00 00 00 00 00 00 04 24 02 00 00 10 24 28 A8 00 24 20 88 00 05 00 C0 10 00 00 00 00 2B 48 04 00 23 20 04 00 23 28 05 00 23 28 A9 00 25 10 04 00 25 18 05 00 08 00 E0 03 00 00 00 00 0F 00 01 3C FF FF 21 34 24 48 A1 00 25 48 24 01 09 00 20 15 00 00 00 00 F5 FF 00 10 00 00 00 00 F0 BF 05 3C F2 FF 00 10 00 00 04 24 25 28 06 00 EF FF 00 10 00 00 04 24 F8 FF 05 3C EC FF 00 10 00 00 04 24 }
	condition:
		$1
}

rule file_17_0_2 {
	meta:
		name = "fpcos"
		size = 276
		refs = "0008 fpreduct 0070 _coscof 00a0 _sincof"
	strings:
		$1 = { F8 FF BD 27 00 00 BF AF ?? ?? ?? 0? 04 00 A4 AF 25 50 18 00 25 48 03 00 25 40 02 00 03 00 21 05 04 00 A4 8F 38 00 00 10 25 10 08 00 02 00 44 25 82 20 04 00 C0 27 04 00 19 00 08 01 10 38 00 00 7E 00 05 24 23 28 A9 00 40 28 05 00 20 00 A1 2C 02 00 20 14 00 00 00 00 00 00 07 34 06 38 A7 00 FF FF 4C 25 02 00 8C 31 0D 00 80 11 00 00 00 00 ?? ?? 0B 3C ?? ?? 6B 25 00 00 68 8D 04 00 6B 25 19 00 E8 00 10 40 00 00 00 00 66 8D 04 00 6B 25 FB FF C1 04 23 40 C8 00 12 00 00 10 7F 00 09 24 ?? ?? 0B 3C ?? ?? 6B 25 00 00 65 8D 04 00 6B 25 19 00 E5 00 10 28 00 00 00 00 66 8D 04 00 6B 25 FB FF C1 04 23 28 C5 00 03 00 A0 18 00 00 00 00 40 28 05 00 FF FF 29 25 01 00 29 25 19 00 05 01 10 40 00 00 03 00 00 19 00 00 00 00 40 40 08 00 FF FF 29 25 40 40 08 00 42 42 08 00 C0 65 09 00 25 40 0C 01 25 10 04 01 00 00 BF 8F 08 00 E0 03 08 00 BD 27 }
	condition:
		$1
}

rule file_18_0_2 {
	meta:
		name = "sigmax"
		size = 264
	strings:
		$1 = { FE 03 09 24 23 48 26 01 20 00 21 2D 05 00 20 14 00 00 00 00 25 20 05 00 00 00 05 24 FA FF 80 14 E0 FF 29 25 08 00 20 11 00 00 00 00 25 50 05 00 06 20 24 01 06 28 25 01 20 00 0C 24 23 48 89 01 04 50 2A 01 25 20 8A 00 00 00 0A 8D 04 00 08 25 00 00 0B 8D 04 00 08 25 19 00 AA 00 10 50 00 00 19 00 AB 00 12 48 00 00 10 30 00 00 21 50 49 01 2B 60 49 01 21 30 CC 00 19 00 8B 00 10 48 00 00 21 50 49 01 2B 60 49 01 05 00 61 05 21 30 CC 00 2B 60 44 01 23 50 44 01 23 30 CC 00 23 30 C5 00 25 58 06 00 00 00 09 8D 04 00 08 25 00 00 06 8D 04 00 08 25 21 50 49 01 2B 60 49 01 21 58 66 01 21 58 6C 01 FF FF E7 24 E3 FF E1 04 00 00 00 00 06 00 60 05 FF 03 06 24 2A 60 40 01 21 50 4A 01 21 58 6B 01 21 58 6C 01 FF FF C6 24 25 20 0A 00 25 28 0B 00 25 10 04 00 25 18 05 00 25 C0 06 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_18_1_2 {
	meta:
		name = "exmul"
		size = 204
	strings:
		$1 = { 19 00 A8 00 12 58 00 00 10 50 00 00 19 00 A7 00 12 68 00 00 10 60 00 00 21 58 6C 01 2B 78 6C 01 21 50 4F 01 19 00 88 00 12 70 00 00 10 60 00 00 21 70 CD 01 2B 78 CD 01 21 58 6C 01 21 58 6F 01 02 00 6C 11 00 00 00 00 2B 78 6C 01 21 50 4F 01 2A 78 C0 01 21 70 CE 01 21 58 6F 01 2B 78 6F 01 21 50 4F 01 0C 00 40 05 00 00 00 00 13 00 40 11 00 00 00 00 2A 78 C0 01 21 70 CE 01 2A 10 60 01 21 58 6B 01 21 58 6F 01 25 78 02 00 21 50 4A 01 21 50 4F 01 FF FF C6 24 21 30 C9 00 02 FC C6 24 25 20 0B 00 25 28 0A 00 25 10 04 00 25 18 05 00 25 C0 06 00 08 00 E0 03 00 00 00 00 00 00 06 24 25 28 06 00 F8 FF 00 10 25 20 06 00 }
	condition:
		$1
}

rule file_18_2_2 {
	meta:
		name = "exadd"
		size = 236
	strings:
		$1 = { 23 50 C9 00 12 00 40 05 00 00 00 00 20 00 41 2D 05 00 20 14 00 00 00 00 25 38 08 00 00 00 08 24 FA FF E0 14 E0 FF 4A 25 1B 00 40 11 00 00 00 00 25 58 08 00 06 38 47 01 06 40 48 01 20 00 0C 24 23 50 8A 01 04 58 4B 01 13 00 00 10 25 38 EB 00 25 30 09 00 23 50 0A 00 20 00 41 2D 05 00 20 14 00 00 00 00 25 20 05 00 00 00 05 24 FA FF 80 14 E0 FF 4A 25 08 00 40 11 00 00 00 00 25 58 05 00 06 20 44 01 06 28 45 01 20 00 0C 24 23 50 8A 01 04 58 4B 01 25 20 8B 00 21 20 87 00 2B 60 87 00 21 28 A8 00 21 28 AC 00 02 00 A8 10 00 00 00 00 2B 60 A8 00 08 00 80 11 00 00 00 00 42 20 04 00 C0 67 05 00 25 20 8C 00 42 28 05 00 00 80 01 3C 25 28 A1 00 01 00 C6 24 25 10 04 00 25 18 05 00 25 C0 06 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_18_3_2 {
	meta:
		name = "exsub"
		size = 176
	strings:
		$1 = { 23 50 26 01 20 00 41 2D 05 00 20 14 00 00 00 00 25 20 05 00 00 00 05 24 FA FF 80 14 E0 FF 4A 25 08 00 40 11 00 00 00 00 25 58 05 00 06 20 44 01 06 28 45 01 20 00 0C 24 23 50 8A 01 04 58 4B 01 25 20 8B 00 2B 60 E4 00 23 38 E4 00 23 40 0C 01 23 40 05 01 08 00 00 15 00 00 00 00 03 00 E0 14 00 00 00 00 0D 00 00 10 00 00 09 24 25 40 E0 00 00 00 07 24 E0 FF 29 25 20 50 0A 71 07 00 40 11 00 00 00 00 23 48 2A 01 22 58 0A 00 06 58 67 01 04 38 47 01 04 40 48 01 25 40 0B 01 25 10 07 00 25 18 08 00 25 C0 09 00 08 00 E0 03 00 00 00 00 }
	condition:
		$1
}

rule file_18_4_2 {
	meta:
		name = "exdiv"
		size = 612
	strings:
		$1 = { 94 00 00 11 00 00 00 00 23 30 C9 00 FF 03 C6 24 42 20 04 00 C0 77 05 00 25 20 8E 00 42 28 05 00 02 6C 08 00 F4 01 A0 01 1B 00 AD 00 12 50 00 00 10 28 00 00 FF FF 0B 31 19 00 6A 01 12 60 00 00 00 2C 05 00 02 74 04 00 25 28 AE 00 2B 70 AC 00 06 00 C0 11 23 28 AC 00 FF FF 4A 25 21 28 A8 00 2B 08 A8 00 FC FF 20 10 00 00 00 00 F4 01 A0 01 1B 00 AD 00 12 68 00 00 10 28 00 00 19 00 6D 01 12 60 00 00 00 2C 05 00 FF FF 8E 30 25 28 AE 00 2B 70 AC 00 06 00 C0 11 23 28 AC 00 FF FF AD 25 21 28 A8 00 2B 08 A8 00 FC FF 20 10 00 00 00 00 00 54 0A 00 21 50 4D 01 19 00 47 01 12 68 00 00 10 60 00 00 00 00 04 24 2B 70 8D 00 23 20 8D 00 2B 78 AE 00 23 28 AE 00 2B 70 AC 00 25 70 CF 01 0B 00 C0 11 23 28 AC 00 FF FF 4A 25 21 20 87 00 2B 70 87 00 21 28 A8 00 21 28 AE 00 02 00 A8 10 00 00 00 00 2B 70 A8 00 F7 FF C0 11 00 00 00 00 06 00 A8 14 00 00 00 00 25 60 07 00 25 28 04 00 00 00 0B 24 2A 00 00 10 25 68 0B 00 02 6C 08 00 F4 01 A0 01 1B 00 AD 00 12 58 00 00 10 28 00 00 FF FF 09 31 19 00 2B 01 12 60 00 00 00 2C 05 00 02 74 04 00 25 28 AE 00 2B 70 AC 00 06 00 C0 11 23 28 AC 00 FF FF 6B 25 21 28 A8 00 2B 08 A8 00 FC FF 20 10 00 00 00 00 F4 01 A0 01 1B 00 AD 00 12 68 00 00 10 28 00 00 19 00 2D 01 12 60 00 00 00 2C 05 00 FF FF 8E 30 25 28 AE 00 2B 70 AC 00 06 00 C0 11 23 28 AC 00 FF FF AD 25 21 28 A8 00 2B 08 A8 00 FC FF 20 10 00 00 00 00 00 5C 0B 00 21 58 6D 01 19 00 67 01 12 68 00 00 10 60 00 00 00 00 04 24 2B 70 8D 00 23 20 8D 00 2B 78 AE 00 23 28 AE 00 2B 70 AC 00 25 70 CF 01 0B 00 C0 11 23 28 AC 00 FF FF 6B 25 21 20 87 00 2B 70 87 00 21 28 A8 00 21 28 AE 00 02 00 A8 10 00 00 00 00 2B 70 A8 00 F7 FF C0 11 00 00 00 00 06 00 40 05 00 00 00 00 2A 70 60 01 21 58 6B 01 21 50 4A 01 21 50 4E 01 FF FF C6 24 25 28 0A 00 25 20 0B 00 25 10 04 00 25 18 05 00 25 C0 06 00 08 00 E0 03 00 00 00 00 FF 07 06 24 00 80 05 3C F8 FF 00 10 00 00 04 24 }
	condition:
		$1
}

rule file_19_0_2 {
	meta:
		name = "fpfloor"
		size = 176
	strings:
		$1 = { 00 80 01 3C 24 28 81 00 40 38 04 00 02 3E 07 00 FF 00 01 24 1B 00 E1 10 00 00 00 00 96 00 08 24 23 38 07 01 18 00 E1 2C 0A 00 20 14 00 00 00 00 11 00 E0 04 00 00 00 00 00 80 01 3C 01 00 21 34 2B 08 81 00 14 00 20 10 00 00 00 00 14 00 00 10 00 00 00 00 02 00 A0 10 00 00 00 00 23 20 04 00 01 00 06 24 04 30 E6 00 23 30 06 00 02 00 A0 10 24 20 86 00 23 20 04 00 25 10 04 00 08 00 E0 03 00 00 00 00 40 42 04 00 07 00 00 15 00 00 00 00 FA FF 00 10 25 10 04 00 F8 FF 00 10 80 BF 02 3C F6 FF 00 10 25 10 05 00 F4 FF 00 10 C0 FF 02 3C }
	condition:
		$1
}

rule file_20_0_2 {
	meta:
		name = "atanhl"
		size = 420
		refs = "002c copysignl 0050 litodp 006c dpcmp 0098 errno 00d4 dpsub 00e8 dpdiv 00fc dpadd 0108 log1pl 0138 dpmul"
	strings:
		$1 = { D8 FF BD 27 ?? ?? 02 3C 14 00 B0 AF 21 80 80 00 ?? ?? 44 8C 21 38 A0 00 21 30 00 02 24 00 BF AF 20 00 B3 AF 1C 00 B2 AF 18 00 B1 AF ?? ?? ?? 0? 21 88 A0 00 21 98 40 00 ?? ?? 02 3C ?? ?? 46 8C 21 28 20 02 ?? ?? ?? 0? 21 20 00 02 ?? ?? 12 3C ?? ?? ?? 0? 21 20 40 00 ?? ?? 46 8E ?? ?? 47 8E 21 88 60 00 21 20 40 00 21 28 20 02 ?? ?? ?? 0? 21 80 40 00 3D 00 40 10 ?? ?? 44 8E ?? ?? 45 8E 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 0E 00 41 04 24 00 BF 8F 21 00 03 24 ?? ?? 02 3C 21 28 00 00 F8 7F 04 3C ?? ?? 43 AC 20 00 B3 8F 21 10 A0 00 21 18 80 00 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 ?? ?? 44 8E ?? ?? 45 8E 21 30 00 02 ?? ?? ?? 0? 21 38 20 02 21 30 40 00 21 20 00 02 21 28 20 02 ?? ?? ?? 0? 21 38 60 00 21 30 40 00 21 38 60 00 21 20 40 00 ?? ?? ?? 0? 21 28 60 00 21 28 60 00 ?? ?? ?? 0? 21 20 40 00 21 90 40 00 ?? ?? ?? 0? 21 20 60 02 21 20 40 02 21 88 40 00 ?? ?? ?? 0? 21 80 60 00 21 20 40 00 21 28 60 00 21 30 20 02 ?? ?? ?? 0? 21 38 00 02 24 00 BF 8F 21 28 40 00 21 20 60 00 21 10 A0 00 21 18 80 00 20 00 B3 8F 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 24 00 BF 8F 22 00 03 24 ?? ?? 02 3C 21 28 00 00 F8 7F 04 3C ?? ?? 43 AC 20 00 B3 8F 21 10 A0 00 21 18 80 00 1C 00 B2 8F 18 00 B1 8F 14 00 B0 8F 08 00 E0 03 28 00 BD 27 }
	condition:
		$1
}

rule file_21_0_2 {
	meta:
		name = "fpceil"
		size = 172
	strings:
		$1 = { 00 80 01 3C 24 28 81 00 40 38 04 00 02 3E 07 00 FF 00 01 24 1A 00 E1 10 00 00 00 00 96 00 08 24 23 38 07 01 13 00 E0 18 00 00 00 00 18 00 E1 2C 07 00 20 14 00 00 00 00 18 00 A0 14 00 00 00 00 14 00 80 14 00 00 00 00 14 00 00 10 00 00 00 00 02 00 A0 14 00 00 00 00 23 20 04 00 01 00 06 24 04 30 E6 00 23 30 06 00 02 00 A0 14 24 20 86 00 23 20 04 00 25 10 04 00 08 00 E0 03 00 00 00 00 40 42 04 00 07 00 00 15 00 00 00 00 F9 FF 00 10 00 00 00 00 F8 FF 00 10 80 3F 02 3C F6 FF 00 10 25 10 05 00 F4 FF 00 10 C0 FF 02 3C }
	condition:
		$1
}

rule file_22_0_2 {
	meta:
		name = "__mchp_coshf"
		size = 304
		refs = "0038 fpexexp"
	strings:
		$1 = { F8 FF BD 27 00 00 BF AF C2 35 04 00 FF 00 C6 30 00 2A 04 00 00 80 01 3C 25 28 A1 00 00 00 07 24 FF 00 01 24 3B 00 C1 10 00 00 00 00 04 00 A4 AF 25 20 05 00 25 28 06 00 ?? ?? ?? 0? 25 30 07 00 25 38 18 00 25 30 03 00 25 28 02 00 36 00 A0 10 04 00 A4 8F 00 40 08 3C 21 58 C6 00 02 FF 6B 25 02 4C 05 00 F4 01 20 01 1B 00 09 01 12 50 00 00 10 40 00 00 FF FF AC 30 19 00 8A 01 12 68 00 00 00 44 08 00 2B 70 0D 01 06 00 C0 11 23 40 0D 01 FF FF 4A 25 21 40 05 01 2B 08 05 01 FC FF 20 10 00 00 00 00 F4 01 20 01 1B 00 09 01 12 40 00 00 00 74 0A 00 21 40 0E 01 20 00 61 2D 02 00 20 14 00 00 00 00 00 00 08 34 06 40 68 01 21 28 A8 00 2B 70 A8 00 03 00 C0 11 00 00 00 00 42 28 05 00 01 00 C6 24 FF FF C6 24 FF 00 C1 2C 0E 00 20 10 00 00 00 00 40 28 05 00 42 2A 05 00 C0 75 06 00 25 28 AE 00 25 10 05 00 00 00 BF 8F 08 00 E0 03 08 00 BD 27 21 70 A5 00 03 00 C0 11 00 00 00 00 F9 FF 00 10 C0 FF 02 3C F7 FF 00 10 80 7F 02 3C }
	condition:
		$1
}

rule file_22_1_2 {
	meta:
		name = "__mchp_sinhf"
		size = 468
		refs = "00cc fpexexp"
	strings:
		$1 = { D4 FF BD 27 00 00 BF AF C2 35 04 00 FF 00 C6 30 00 80 0C 3C 00 2A 04 00 25 28 AC 00 00 00 07 24 24 20 8C 00 FF 00 01 24 62 00 C1 10 00 00 00 00 7E 00 C1 2C 1E 00 20 10 00 00 00 00 19 00 A5 00 10 40 00 00 ?? ?? 0B 