private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
		size = 112
		refs = "002a __acrt_getptd 003a __acrt_update_locale_info 0044 __acrt_update_multibyte_info 0068 __acrt_initial_locale_pointers 006c __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 00 23 23 73 19 B1 0B 68 63 60 4B 68 06 E0 14 4B 1B 68 2B B9 12 4A 13 68 63 60 53 68 A3 60 1A E0 ?? ?? ?? ?? 20 60 C3 6C 21 1D 63 60 83 6C A3 60 ?? ?? ?? ?? 20 68 04 F1 08 01 ?? ?? ?? ?? 22 68 D2 F8 50 33 13 F0 02 0F 05 D1 43 F0 02 03 C2 F8 50 33 01 23 23 73 20 46 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QAA@XZ"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 03 7B 33 B1 02 68 D2 F8 50 33 23 F0 02 03 C2 F8 50 33 BD E8 00 88 }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "__acrt_locale_changed"
		size = 28
		refs = "0018 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 0B B1 01 20 00 E0 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_45_0 {
	meta:
		name = "?other_environment_exists@@YA_ND@Z"
		size = 28
		refs = "0018 _wenviron_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 0B B1 01 20 00 E0 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_46_0 {
	meta:
		name = "?other_environment_exists@@YA_N_W@Z"
		size = 28
		refs = "0018 _environ_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 0B B1 01 20 00 E0 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_4_0 {
	meta:
		name = "_mbsicmp"
		size = 16
		refs = "000c _mbsicmp_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_522_2_2 {
	meta:
		name = "_aligned_malloc"
		size = 16
		refs = "000c _aligned_offset_malloc_base"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_522_3_4 {
	meta:
		name = "_aligned_malloc_base"
		size = 16
		refs = "000c _aligned_offset_malloc_base"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_115_0 {
	meta:
		name = "_atodbl"
		size = 16
		refs = "000c ??$common_atodbl_l@ND@@YAHQANQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_118_2 {
	meta:
		name = "_atoflt"
		size = 16
		refs = "000c ??$common_atodbl_l@MD@@YAHQAMQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_56_3 {
	meta:
		name = "_atoldbl"
		size = 16
		refs = "000c _atoldbl_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_552_15_4 {
	meta:
		name = "_getws_s"
		size = 16
		refs = "000c ??$common_gets@_W@@YAPA_WQA_WI_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_205_4_2 {
	meta:
		name = "_ismbslead"
		size = 16
		refs = "000c _ismbslead_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_4_3 {
	meta:
		name = "_ismbstrail"
		size = 16
		refs = "000c _ismbstrail_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_4_0 {
	meta:
		name = "_mbbtype"
		size = 16
		refs = "000c _mbbtype_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_632_4_0 {
	meta:
		name = "_mbsbtype"
		size = 16
		refs = "000c _mbsbtype_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_4_0 {
	meta:
		name = "_mbschr"
		size = 16
		refs = "000c _mbschr_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_4_2 {
	meta:
		name = "_mbscmp"
		size = 16
		refs = "000c _mbscmp_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_502_4_4 {
	meta:
		name = "_mbscoll"
		size = 16
		refs = "000c _mbscoll_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_448_4_4 {
	meta:
		name = "_mbscspn"
		size = 16
		refs = "000c _mbscspn_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_367_4_2 {
	meta:
		name = "_mbsdec"
		size = 16
		refs = "000c _mbsdec_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_4_3 {
	meta:
		name = "_mbsicoll"
		size = 16
		refs = "000c _mbsicoll_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_6_3 {
	meta:
		name = "_mbslwr_s"
		size = 16
		refs = "000c _mbslwr_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_4_3 {
	meta:
		name = "_mbsnbcnt"
		size = 16
		refs = "000c _mbsnbcnt_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_253_4_2 {
	meta:
		name = "_mbsnccnt"
		size = 16
		refs = "000c _mbsnccnt_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_4_3 {
	meta:
		name = "_mbsnlen"
		size = 16
		refs = "000c _mbsnlen_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_545_4_3 {
	meta:
		name = "_mbspbrk"
		size = 16
		refs = "000c _mbspbrk_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_4_3 {
	meta:
		name = "_mbsrchr"
		size = 16
		refs = "000c _mbsrchr_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_4_4 {
	meta:
		name = "_mbsset"
		size = 16
		refs = "000c _mbsset_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_467_4_0 {
	meta:
		name = "_mbsspn"
		size = 16
		refs = "000c _mbsspn_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_420_4_0 {
	meta:
		name = "_mbsspnp"
		size = 16
		refs = "000c _mbsspnp_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_274_4_3 {
	meta:
		name = "_mbsstr"
		size = 16
		refs = "000c _mbsstr_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_450_6_0 {
	meta:
		name = "_mbsupr_s"
		size = 16
		refs = "000c _mbsupr_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_15_0 {
	meta:
		name = "_strlwr_s"
		size = 16
		refs = "000c _strlwr_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_15_0 {
	meta:
		name = "_strupr_s"
		size = 16
		refs = "000c _strupr_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_656_15_4 {
	meta:
		name = "_wcslwr_s"
		size = 16
		refs = "000c _wcslwr_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_217_14_2 {
	meta:
		name = "_wcsupr_s"
		size = 16
		refs = "000c _wcsupr_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_552_17_4 {
	meta:
		name = "gets_s"
		size = 16
		refs = "000c ??$common_gets@D@@YAPADQADI_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_300_5_2 {
	meta:
		name = "strcoll"
		size = 16
		refs = "000c _strcoll_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_125_0 {
	meta:
		name = "strtod"
		size = 16
		refs = "000c ??$common_strtod_l@ND@@YANQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_126_2 {
	meta:
		name = "strtof"
		size = 16
		refs = "000c ??$common_strtod_l@MD@@YAMQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_127_4 {
	meta:
		name = "strtold"
		size = 16
		refs = "000c ??$common_strtod_l@ND@@YANQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_128_4 {
	meta:
		name = "wcstod"
		size = 16
		refs = "000c ??$common_strtod_l@N_W@@YANQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_129_3 {
	meta:
		name = "wcstof"
		size = 16
		refs = "000c ??$common_strtod_l@M_W@@YAMQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_130_0 {
	meta:
		name = "wcstold"
		size = 16
		refs = "000c ??$common_strtod_l@N_W@@YANQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_5_0 {
	meta:
		name = "_mbsicmp_l"
		size = 360
		refs = "0012 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001e _errno 0026 _invalid_parameter_noinfo 0038 _stricmp_l 0082 __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8D B0 0D 46 06 46 08 A8 11 46 ?? ?? ?? ?? 4F F0 02 09 06 B1 35 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 87 E0 0A 9A 93 68 2B B9 09 AA 29 46 30 46 ?? ?? ?? ?? 87 E0 01 20 06 AF 0D F1 18 08 4F F0 04 0A 16 F8 01 1B 4F F0 10 0E 52 FA 81 F3 5B 7E 13 EA 0A 0F 26 D0 33 78 0B B9 00 24 2B E0 53 68 D2 F8 1C 12 04 90 03 93 73 1E 4F F4 00 72 09 A8 CD F8 08 90 01 97 CD F8 00 90 ?? ?? ?? ?? 01 28 02 D1 9D F8 18 40 08 E0 02 28 4F D1 9D F8 18 20 9D F8 19 30 03 EB 02 23 9C B2 0A 9A 76 1C 4F F0 10 0E 07 E0 88 18 43 7E 13 EA 0E 0F 01 D0 90 F8 19 11 0C 46 01 20 15 F8 01 1B 52 FA 81 F3 5B 7E 13 EA 0A 0F 25 D0 2B 78 0B B9 00 23 29 E0 53 68 D2 F8 1C 12 04 90 03 93 6B 1E 4F F4 00 72 09 A8 CD F8 08 90 CD F8 04 80 CD F8 00 90 ?? ?? ?? ?? 01 28 02 D1 9D F8 18 30 08 E0 02 28 16 D1 9D F8 18 20 9D F8 19 30 03 EB 02 23 9B B2 0A 9A 6D 1C 07 E0 88 18 43 7E 13 EA 0E 0F 01 D0 90 F8 19 11 0B 46 9C 42 0B D1 44 B1 01 20 8A E7 ?? ?? ?? ?? 16 23 03 60 6F F0 00 40 05 E0 00 20 03 E0 6F F0 00 00 88 BF 01 20 9D F8 2C 30 33 B1 08 9A D2 F8 50 33 23 EA 09 03 C2 F8 50 33 0D B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "??$__crt_interlocked_read@J@@YAJPDJ@Z"
		size = 16
		altNames = "??$__crt_interlocked_read@H@@YAHPDH@Z ??$__crt_interlocked_read_pointer@UHINSTANCE__@@@@YAPAUHINSTANCE__@@PDSAU0@@Z ??$__crt_interlocked_read_pointer@X@@YAPAXPDSAX@Z ?__crt_interlocked_read_32@@YAHPDH@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BF F3 5B 8F BD E8 00 88 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "?get_flags@__crt_stdio_stream@@QBAJXZ"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 D8 68 BF F3 5B 8F BD E8 00 88 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "?has_all_of@__crt_stdio_stream@@QBA_NJ@Z"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 0B 40 8B 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "?is_string_backed@__crt_stdio_stream@@QBA_NXZ"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 13 F4 80 5F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "?set_flags@__crt_stdio_stream@@QBA_NJ@Z"
		size = 52
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B BF F3 5B 8F 03 68 03 F1 0C 02 52 E8 00 4F 44 EA 01 00 42 E8 00 03 00 2B F7 D1 BF F3 5B 8F 0C 42 18 BF 01 20 08 BF 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "?unset_flags@__crt_stdio_stream@@QBA_NJ@Z"
		size = 54
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B BF F3 5B 8F 03 68 CC 43 03 F1 0C 02 52 E8 00 5F 05 EA 04 00 42 E8 00 03 00 2B F7 D1 BF F3 5B 8F 0D 42 18 BF 01 20 08 BF 00 20 BD E8 30 88 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "_ungetc_nolock"
		size = 340
		refs = "002a _fileno 0080 _errno 0088 _invalid_parameter_noinfo 00c4 __acrt_stdio_allocate_buffer_nolock 014c __badioinfo 0150 __pioinfo"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 01 F1 0C 06 33 68 0D 46 80 46 BF F3 5B 8F 13 F4 80 5F 18 BF 01 23 08 BF 00 23 6F F0 00 04 93 BB 28 46 ?? ?? ?? ?? DF F8 20 E1 46 4F A0 42 0C D0 10 F1 02 0F 09 D0 00 F0 3F 03 81 11 03 EB 43 02 5E F8 21 30 03 EB 02 13 00 E0 3B 46 93 F9 29 30 93 B9 A0 42 0B D0 10 F1 02 0F 08 D0 00 F0 3F 03 81 11 03 EB 43 02 5E F8 21 30 03 EB 02 17 97 F8 2D 30 13 F0 01 0F 06 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 5A E0 A0 45 58 D0 33 68 BF F3 5B 8F 13 F0 01 0F 33 68 18 BF 01 22 08 BF 00 22 BF F3 5B 8F 03 F0 06 03 06 2B 08 BF 01 23 18 BF 00 23 0A B9 00 2B 42 D0 6B 68 13 B9 28 46 ?? ?? ?? ?? D5 E9 00 23 9A 42 03 D1 AB 68 BB BB 53 1C 2B 60 33 68 BF F3 5B 8F 13 F4 80 5F 18 BF 01 23 08 BF 00 23 00 2B 2B 68 0A D0 59 1E 29 60 91 F9 00 30 4F FA 88 F2 93 42 06 D0 4B 1C 2B 60 1E E0 5B 1E 2B 60 83 F8 00 80 AB 68 5B 1C AB 60 BF F3 5B 8F 56 E8 00 1F 21 F0 08 02 46 E8 00 23 00 2B F7 D1 BF F3 5B 8F 56 E8 00 1F 41 F0 01 02 46 E8 00 23 00 2B F7 D1 BF F3 5B 8F 5F FA 88 F4 20 46 BD E8 F8 89 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "ungetc"
		size = 80
		refs = "0014 _errno 001c _invalid_parameter_noinfo 002e _lock_file 0036 _ungetc_nolock 003e _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 BE 48 0D F1 18 0B 6F 46 0C 46 7C 62 05 46 44 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 0E E0 6F F0 00 03 3B 60 20 46 ?? ?? ?? ?? 21 46 28 46 ?? ?? ?? ?? 38 60 78 6A ?? ?? ?? ?? 3B 68 7B 60 78 68 BD E8 BE 08 5D F8 0C FB }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "??$common_ftell@J@@YAJV__crt_stdio_stream@@@Z"
		size = 98
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0026 _lock_file 002e ??$common_ftell_nolock@_J@@YA_JV__crt_stdio_stream@@@Z 0050 _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 8E 48 0D F1 10 0B 6F 46 B8 61 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 19 E0 00 23 3B 60 ?? ?? ?? ?? B8 69 78 60 ?? ?? ?? ?? 00 29 0A DB 03 DC 6F F0 00 43 98 42 05 D9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 00 38 60 B8 69 ?? ?? ?? ?? 3B 68 7B 60 78 68 BD E8 8E 08 5D F8 0C FB }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "?fin$0@?0???$common_ftell@J@@YAJV__crt_stdio_stream@@@Z@4HA"
		size = 16
		refs = "0006 ?public_stream@__crt_stdio_stream@@QBAPAU_iobuf@@XZ 000a _unlock_file"
	strings:
		$1 = { 10 B5 17 F1 18 00 ?? ?? ?? ?? ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "??$common_ftell@_J@@YA_JV__crt_stdio_stream@@@Z"
		size = 86
		refs = "0012 _errno 001a _invalid_parameter_noinfo 002c _lock_file 0032 ??$common_ftell_nolock@_J@@YA_JV__crt_stdio_stream@@@Z 003c _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 80 48 0D F1 04 0B 85 B0 6F 46 38 62 48 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 BB 60 0F E0 00 23 3B 60 7B 60 ?? ?? ?? ?? 38 6A ?? ?? ?? ?? 38 60 79 60 38 6A ?? ?? ?? ?? 3B 68 BB 60 7B 68 FB 60 B8 68 F9 68 05 B0 BD E8 80 08 5D F8 0C FB }
	condition:
		$1
}

rule file_2_4_0 {
	meta:
		name = "?fin$0@?0???$common_ftell@_J@@YA_JV__crt_stdio_stream@@@Z@4HA"
		size = 16
		refs = "0006 ?public_stream@__crt_stdio_stream@@QBAPAU_iobuf@@XZ 000a _unlock_file"
	strings:
		$1 = { 10 B5 17 F1 20 00 ?? ?? ?? ?? ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_2_5_0 {
	meta:
		name = "??$common_ftell_nolock@J@@YAJV__crt_stdio_stream@@@Z"
		size = 48
		refs = "000a ??$common_ftell_nolock@_J@@YA_JV__crt_stdio_stream@@@Z 001c _errno"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 90 ?? ?? ?? ?? 00 29 0A DB 03 DC 6F F0 00 43 98 42 05 D9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 00 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_2_6_0 {
	meta:
		name = "??$common_ftell_nolock@_J@@YA_JV__crt_stdio_stream@@@Z"
		size = 380
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0024 _fileno 0044 _lseeki64 00cc ?common_ftell_translated_utf8_nolock@@YA_JV__crt_stdio_stream@@_J@Z 00f2 ?count_newline_bytes@@YA_JQBD0W4__crt_lowio_text_mode@@@Z 0146 ?common_ftell_read_mode_nolock@@YA_JV__crt_stdio_stream@@_J1@Z 0178 __pioinfo"
	strings:
		$1 = { 03 B4 2D E9 F0 4F 0D F1 1C 0B 85 B0 0E 90 48 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 25 46 A1 E0 ?? ?? ?? ?? 0E 9A 04 46 93 68 00 2B 01 DA 00 23 93 60 4F F0 01 0A 00 23 00 22 20 46 CD F8 00 A0 ?? ?? ?? ?? 0E 46 00 2E 07 46 00 DC E4 DB 0E 9B DB 68 BF F3 5B 8F 13 F0 C0 0F 18 BF 01 23 08 BF 00 23 33 B9 0E 9B 9A 68 BD 1A 66 EB E2 74 13 46 78 E0 DF F8 00 E1 04 F0 3F 03 A0 11 03 EB 43 08 5E F8 20 30 0E 99 03 EB 08 13 93 F9 29 90 D1 E9 00 23 D5 1A CB 68 EC 17 BF F3 5B 8F 13 F0 03 0F 18 BF 01 23 08 BF 00 23 33 B3 B9 F1 01 0F 10 D1 5E F8 20 30 03 EB 08 13 93 F8 2D 30 13 F0 02 0F 07 D0 0E 98 33 46 3A 46 ?? ?? ?? ?? 0C 46 05 46 48 E0 5E F8 20 30 03 EB 08 13 93 F8 28 30 13 F0 80 0F 19 D0 DD F8 38 80 4A 46 D8 E9 00 10 ?? ?? ?? ?? 2D 18 4C 41 11 E0 0E 9B DB 68 BF F3 5B 8F 13 F0 04 0F 18 BF 01 23 08 BF 00 23 23 B9 ?? ?? ?? ?? 16 23 03 60 7F E7 DD F8 38 80 57 EA 06 03 20 D0 D8 F8 0C 30 BF F3 5B 8F 13 EA 0A 0F 18 BF 01 23 08 BF 00 23 3B B1 0E 98 33 46 3A 46 00 95 01 94 ?? ?? ?? ?? C1 E7 B9 F1 01 0F 08 D1 15 EB D4 72 44 F1 00 01 CB 07 02 95 43 EA 52 05 4C 10 ED 19 74 41 28 46 21 46 05 B0 BD E8 F0 0F 5D F8 0C FB FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_7_0 {
	meta:
		name = "??$count_newlines_of_type@D@@YA_JQBD0@Z"
		size = 52
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 06 46 8A 1B 00 20 00 24 00 25 8E 42 88 BF 00 22 4A B1 16 F9 01 3B 0A 2B 02 D1 40 1C 44 F1 00 04 6D 1C 95 42 F5 D1 21 46 BD E8 78 88 }
	condition:
		$1
}

rule file_2_8_0 {
	meta:
		name = "??$count_newlines_of_type@_W@@YA_JQBD0@Z"
		size = 58
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 06 46 8B 1B 5B 1C 00 20 00 24 00 25 8E 42 98 BF 5A 08 88 BF 00 22 4A B1 36 F8 02 3B 0A 2B 02 D1 40 1C 44 F1 00 04 6D 1C 95 42 F5 D1 21 46 BD E8 78 88 }
	condition:
		$1
}

rule file_2_12_0 {
	meta:
		name = "?buffer_character_size@@YAIW4__crt_lowio_text_mode@@@Z"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 01 28 03 D0 02 28 18 BF 00 23 00 D1 01 23 0B B1 02 20 00 E0 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_2_13_0 {
	meta:
		name = "?buffer_contains_wide_characters@@YA_NW4__crt_lowio_text_mode@@@Z"
		size = 24
	strings:
		$1 = { 2D E9 00 48 EB 46 01 28 03 D0 02 28 18 BF 00 20 00 D1 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_2_14_0 {
	meta:
		name = "?common_ftell_read_mode_nolock@@YA_JV__crt_stdio_stream@@_J1@Z"
		size = 432
		refs = "0012 _fileno 0076 __rt_sdiv64 009a _lseeki64 00b0 ?count_newline_bytes@@YA_JQBD0W4__crt_lowio_text_mode@@@Z 01ac __pioinfo"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 85 B0 1E 46 17 46 0E 90 ?? ?? ?? ?? 65 4A 00 F0 3F 03 4F EA A0 1A 03 EB 43 01 52 F8 2A 30 04 46 03 91 03 EB 01 1E 9E F9 29 50 01 2D 02 D1 02 22 02 92 01 E0 01 23 02 93 0E 9B 98 68 00 28 00 F0 A9 80 D3 E9 00 23 D1 1A C3 17 11 EB 00 08 43 EB E1 79 9E F8 28 10 11 F0 80 0F 14 D1 42 46 DD F8 08 80 4B 46 00 21 40 46 00 B9 F9 DE ?? ?? ?? ?? 0D 46 04 46 DD E9 12 23 00 21 40 46 00 B9 F9 DE ?? ?? ?? ?? 81 E0 02 23 00 93 00 23 00 22 20 46 ?? ?? ?? ?? B8 42 17 D1 B1 42 15 D1 0E 9C 2A 46 60 68 08 EB 00 01 ?? ?? ?? ?? 10 EB 08 02 E3 68 41 EB 09 01 BF F3 5B 8F 13 F0 20 0F 18 BF 01 23 08 BF 00 23 00 2B 3E E0 00 23 00 93 33 46 3A 46 20 46 ?? ?? ?? ?? 00 EA 01 03 13 F1 01 0F 04 D1 6F F0 00 07 6F F0 00 06 54 E0 4F F4 00 72 B9 F1 00 0F 1A DC 01 DB 90 45 17 D8 0E 9B DB 68 BF F3 5B 8F 13 F0 40 0F 18 BF 01 23 08 BF 00 23 63 B1 0E 9B DB 68 BF F3 5B 8F 13 F4 80 7F 18 BF 01 23 08 BF 00 23 0B B9 00 21 03 E0 0E 9B 9A 69 13 46 D9 17 1B 4B 03 98 53 F8 2A 30 03 EB 00 13 93 F8 28 30 13 F0 04 0F 0D D0 01 2D 03 D0 02 2D 18 BF 00 23 00 D1 01 23 0B B1 02 23 00 E0 01 23 D2 18 41 F1 00 01 DD F8 08 80 0B 46 00 21 40 46 00 B9 F9 DE ?? ?? ?? ?? 0D 46 04 46 DD E9 12 23 00 21 40 46 00 B9 F9 DE ?? ?? ?? ?? 03 1B 61 EB 05 02 FF 18 56 41 38 46 31 46 05 B0 BD E8 F0 0F 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_15_0 {
	meta:
		name = "?common_ftell_translated_utf8_nolock@@YA_JV__crt_stdio_stream@@_J@Z"
		size = 328
		refs = "000a __security_push_cookie 0012 __chkstk 0026 _fileno 0072 _lseeki64 012e __security_pop_cookie 013c _lookuptrailbytes 0140 __imp_ReadFile 0144 __pioinfo"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 40 F2 08 44 ?? ?? ?? ?? AD EB 04 0D 1F 46 90 46 41 F2 48 0C 4D F8 0C 00 ?? ?? ?? ?? 41 F2 48 01 5D F8 01 10 02 90 8B 68 00 2B 74 D0 D1 E9 00 23 41 4D D3 1A D9 17 13 EB D1 72 41 F1 00 01 06 93 CB 07 43 EA 52 09 00 F0 3F 03 03 EB 43 04 00 23 86 11 00 93 55 F8 26 30 4F EA 61 0A 03 EB 04 13 D3 E9 08 23 ?? ?? ?? ?? 55 F8 26 30 0A 46 06 92 03 EB 04 14 D4 E9 08 31 04 90 98 42 48 D1 8A 42 46 D1 A0 69 2B 4C 00 25 03 AB 24 68 4F F4 80 52 08 A9 00 95 A0 47 D8 B3 02 98 3B 46 42 46 00 95 ?? ?? ?? ?? 00 29 00 DC 32 DB 03 9A BA F1 00 0F 02 DB 2D DC 91 45 2B D8 08 AB D4 18 08 AA 00 20 00 21 59 EA 0A 03 1A D0 19 4E 65 1E A2 42 16 D2 92 F9 00 30 0D 2B 07 D1 AA 42 08 D2 92 F9 01 30 0A 2B 04 D1 52 1C 02 E0 DB B2 9B 57 1A 44 40 1C 41 F1 00 01 52 1C 48 45 E8 D1 51 45 E6 D1 08 AB D3 1A 04 9A 13 EB 02 08 06 9A 42 EB E3 77 02 E0 6F F0 00 07 B8 46 40 46 39 46 41 F2 20 0C E5 44 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_16_0 {
	meta:
		name = "?count_newline_bytes@@YA_JQBD0W4__crt_lowio_text_mode@@@Z"
		size = 120
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 46 06 46 01 2A 03 D0 02 2A 18 BF 00 23 00 D1 01 23 CB B1 A3 1B 5B 1C 00 21 00 25 00 20 A6 42 98 BF 5A 08 88 BF 00 22 4A B1 36 F8 02 3B 0A 2B 02 D1 49 1C 45 F1 00 05 40 1C 90 42 F5 D1 CB 0F 48 00 43 EA 45 01 11 E0 00 20 00 21 00 25 A2 1B A6 42 88 BF 00 22 4A B1 16 F9 01 3B 0A 2B 02 D1 40 1C 41 F1 00 01 6D 1C 95 42 F5 D1 BD E8 78 88 }
	condition:
		$1
}

rule file_2_17_0 {
	meta:
		name = "?ctrl_z@__crt_stdio_stream@@QBA_NXZ"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 13 F0 20 0F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_2_20_0 {
	meta:
		name = "?has_any_of@__crt_stdio_stream@@QBA_NJ@Z"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 0B 42 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_2_21_0 {
	meta:
		name = "?has_big_buffer@__crt_stdio_stream@@QBA_NXZ"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 13 F0 C0 0F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_2_22_0 {
	meta:
		name = "?has_crt_buffer@__crt_stdio_stream@@QBA_NXZ"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 13 F0 40 0F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_2_23_0 {
	meta:
		name = "?has_setvbuf_buffer@__crt_stdio_stream@@QBA_NXZ"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 13 F4 80 7F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_2_25_0 {
	meta:
		name = "?valid@__crt_stdio_stream@@QBA_NXZ"
		size = 20
		altNames = "??B?$__crt_scoped_stack_ptr@D@@QBA_NXZ ??B?$__crt_scoped_stack_ptr@_W@@QBA_NXZ ??B?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QBA_NXZ ??B?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QBA_NXZ ??B?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QBA_NXZ ??B?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QBA_NXZ ?is_valid@?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QBA_NXZ ?is_valid@?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QBA_NXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 0B B1 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_2_26_0 {
	meta:
		name = "_ftell_nolock"
		size = 40
		refs = "0006 ??$common_ftell_nolock@_J@@YA_JV__crt_stdio_stream@@@Z 0018 _errno"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 00 29 0A DB 03 DC 6F F0 00 43 98 42 05 D9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "fesetround"
		size = 52
		refs = "0016 _getfpcontrolword 0022 _setfpcontrolword 0026 fegetround"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 00 F4 40 73 A3 42 01 D0 01 20 0C E0 ?? ?? ?? ?? 20 F4 40 73 43 EA 04 00 ?? ?? ?? ?? ?? ?? ?? ?? A0 42 F1 D1 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "cos"
		size = 640
		refs = "004a _controlfp_s 006e cos_piby4 008a _handle_nan 00ae _handle_error 01c4 __remainder_piby2 01e4 sin_piby4 0264 ??_C@_03LALBNOCG@cos?$AA@"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8B B0 54 EC 10 0B 9B 4B B0 EE 40 2B 24 F0 00 41 99 42 2B D8 02 D3 96 4B 98 42 27 D8 93 4B 99 42 1D D8 1C D2 B1 F1 79 5F 0E D8 0D D2 50 EA 01 03 02 D1 B7 EE 00 0B DB E0 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? F4 E7 22 EE 02 2B B6 EE 00 0B B7 EE 00 1B 22 EE 00 0B 31 EE 40 0B C8 E0 9F ED 80 1B B0 EE 42 0B ?? ?? ?? ?? C1 E0 7E 4A 04 EA 02 03 93 42 1A D1 23 46 6F F3 1F 53 03 43 03 D0 21 46 ?? ?? ?? ?? B3 E0 21 23 02 93 08 23 01 22 9F ED 73 1B 71 48 01 93 6F 4B 03 92 00 92 00 22 B0 EE 42 0B 12 21 ?? ?? ?? ?? A1 E0 A1 42 01 D0 B1 EE 42 2B 9F ED 66 0B B4 EE C0 2B F1 EE 10 FA 77 D2 62 4B 00 24 99 42 0E D8 02 D3 5E 4B 98 42 0A D8 5C 4B 99 42 05 D8 02 D3 59 4B 98 42 01 D8 01 20 1D E0 02 20 1B E0 54 4B 99 42 0E D8 02 D3 51 4B 98 42 0A D8 4F 4B 99 42 05 D8 02 D3 4C 4B 98 42 01 D8 03 20 0B E0 04 20 09 E0 9F ED 46 0B B6 EE 00 1B 02 EE 00 1B BD EE C1 0B 10 EE 10 0A 00 EE 10 0A 9F ED 3E 1B B8 EE C0 5B 9F ED 3A 0B 25 EE 01 1B 25 EE 00 3B 32 EE 41 4B 53 EC 14 2B C3 F3 0A 53 D3 EB 11 53 64 F1 00 01 09 B9 0F 2B 26 D9 9F ED 2F 0B B0 EE 44 2B 25 EE 00 3B 9F ED 2A 0B 34 EE 43 4B 25 EE 00 1B 32 EE 44 0B 30 EE 43 0B 31 EE 40 3B 09 B9 30 2B 11 D9 9F ED 20 0B B0 EE 44 2B 25 EE 00 3B 9F ED 1B 0B 34 EE 43 4B 25 EE 00 1B 32 EE 44 0B 30 EE 43 0B 31 EE 40 3B 34 EE 43 2B 00 F0 03 03 34 EE 42 0B 30 EE 43 1B 0B E0 05 AA 08 A9 06 A8 B0 EE 42 0B ?? ?? ?? ?? 9D ED 06 2B 9D ED 08 1B 05 9B 01 2B B0 EE 42 0B 0A D0 02 2B 05 D0 03 2B 7F F4 45 AF ?? ?? ?? ?? 06 E0 ?? ?? ?? ?? 01 E0 ?? ?? ?? ?? B1 EE 40 0B 0B B0 BD E8 10 88 FE DE C1 49 20 25 9A 83 7B 39 00 00 00 2E 8A 19 A3 3B 73 70 03 2E 8A 19 A3 3B 00 00 60 1A 61 B4 D0 3D 31 63 62 1A 61 B4 D0 3D 00 00 40 54 FB 21 F9 3F 83 C8 C9 6D 30 5F E4 3F 75 A7 BB E9 BB FD 15 40 BB B2 CC BE 3A 46 1C 40 D2 21 33 7F 7C D9 02 40 5E 38 55 29 7A 6A 0F 40 00 00 00 00 80 84 1E 41 00 00 F8 FF ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F0 7F 00 00 20 3F 18 2D 44 54 FB 21 E9 3F }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "cos_piby4"
		size = 172
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 06 8B 9F ED 26 2B 20 EE 00 AB 9F ED 22 4B 9F ED 1F 5B 9F ED 1C 7B 2A EE 02 2B B6 EE 00 3B 20 EE 01 6B 34 EE 42 2B 2A EE 03 8B 22 EE 0A 2B B7 EE 00 3B 9F ED 12 4B 2A EE 0A 1B 32 EE 45 2B 33 EE 48 9B 9F ED 0C 5B 02 EE 0A 7B 33 EE 49 3B 27 EE 0A 0B 33 EE 48 2B 30 EE 45 0B 00 EE 0A 4B 32 EE 46 0B 04 EE 01 0B 30 EE 09 0B BD EC 06 8B BD E8 00 88 FE DE 67 69 C1 16 6C C1 56 3F 55 55 55 55 55 55 A5 3F 90 EC F4 19 A0 01 FA 3E F6 65 7F A1 4F 7E 92 3E 78 AB 37 90 B6 EE 21 3E 42 5E CC 46 DB 07 A9 3D }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "raise_fpsw_flags"
		size = 26
		refs = "0012 _controlfp_s"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 01 46 00 23 0A 46 68 46 00 93 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "sin"
		size = 676
		refs = "004a _controlfp_s 006a sin_piby4 0086 _handle_nan 00aa _handle_error 01c6 __remainder_piby2 01f2 cos_piby4 0280 ??_C@_03BLEJJJBH@sin?$AA@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 8A B0 54 EC 10 0B A3 4B B0 EE 40 8B 24 F0 00 41 99 42 27 D8 02 D3 9E 4B 98 42 23 D8 9B 4B 99 42 19 D8 18 D2 B1 F1 79 5F 0C D8 0B D2 50 EA 01 03 00 F0 E7 80 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? DE E0 28 EE 08 0B 9F ED 8E 1B 20 EE 08 0B 00 EE 41 8B D5 E0 9F ED 88 1B B0 EE 48 0B ?? ?? ?? ?? CC E0 86 4A 04 EA 02 03 93 42 1A D1 23 46 6F F3 1F 53 03 43 03 D0 21 46 ?? ?? ?? ?? BE E0 21 23 02 93 08 23 01 22 9F ED 7B 1B 79 48 01 93 77 4B 03 92 00 92 00 22 B0 EE 48 0B 1E 21 ?? ?? ?? ?? AC E0 A1 42 08 BF 00 24 02 D0 01 24 B1 EE 48 8B 9F ED 6D 0B B4 EE C0 8B F1 EE 10 FA 77 D2 68 4B 00 25 99 42 0E D8 02 D3 65 4B 98 42 0A D8 62 4B 99 42 05 D8 02 D3 5F 4B 98 42 01 D8 01 20 1D E0 02 20 1B E0 5B 4B 99 42 0E D8 02 D3 58 4B 98 42 0A D8 55 4B 99 42 05 D8 02 D3 52 4B 98 42 01 D8 03 20 0B E0 04 20 09 E0 9F ED 4D 0B B6 EE 00 1B 08 EE 00 1B BD EE C1 0B 10 EE 10 0A 00 EE 10 0A 9F ED 45 1B B8 EE C0 5B 9F ED 41 0B 25 EE 01 1B 25 EE 00 3B 38 EE 41 4B 53 EC 14 2B C3 F3 0A 53 D3 EB 11 53 65 F1 00 01 09 B9 0F 2B 26 D9 9F ED 35 0B B0 EE 44 2B 25 EE 00 3B 9F ED 30 0B 34 EE 43 4B 25 EE 00 1B 32 EE 44 0B 30 EE 43 0B 31 EE 40 3B 09 B9 30 2B 11 D9 9F ED 27 0B B0 EE 44 2B 25 EE 00 3B 9F ED 22 0B 34 EE 43 4B 25 EE 00 1B 32 EE 44 0B 30 EE 43 0B 31 EE 40 3B 34 EE 43 2B 00 F0 03 03 34 EE 42 0B 30 EE 43 1B 0B E0 05 AA 08 A9 06 A8 B0 EE 48 0B ?? ?? ?? ?? 9D ED 06 2B 9D ED 08 1B 05 9B B0 EE 42 0B 74 B1 01 2B 09 D0 02 2B 3F F4 43 AF 03 2B 0E D0 ?? ?? ?? ?? B1 EE 40 8B 0D E0 ?? ?? ?? ?? F9 E7 01 2B 04 D0 02 2B F3 D0 03 2B F6 D0 31 E7 ?? ?? ?? ?? B0 EE 40 8B B0 EE 48 0B 0A B0 BD EC 02 8B BD E8 30 88 C1 49 20 25 9A 83 7B 39 00 00 00 2E 8A 19 A3 3B 73 70 03 2E 8A 19 A3 3B 00 00 60 1A 61 B4 D0 3D 31 63 62 1A 61 B4 D0 3D 00 00 40 54 FB 21 F9 3F 83 C8 C9 6D 30 5F E4 3F 75 A7 BB E9 BB FD 15 40 BB B2 CC BE 3A 46 1C 40 D2 21 33 7F 7C D9 02 40 5E 38 55 29 7A 6A 0F 40 00 00 00 00 80 84 1E 41 00 00 F8 FF ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F0 7F 55 55 55 55 55 55 C5 3F 00 00 20 3F 18 2D 44 54 FB 21 E9 3F }
	condition:
		$1
}

rule file_4_4_0 {
	meta:
		name = "sin_piby4"
		size = 200
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B B0 EE 40 5B 9F ED 2C 0B 25 EE 05 6B 9F ED 28 2B 9F ED 25 4B 9F ED 22 3B 26 EE 00 0B 9F ED 1E 8B B5 EE 40 1B 26 EE 05 7B 30 EE 42 2B F1 EE 10 FA 02 EE 06 4B 24 EE 06 2B 32 EE 43 2B 02 EE 06 8B 08 D1 9F ED 12 0B 28 EE 06 1B 31 EE 40 0B 00 EE 07 5B 11 E0 B6 EE 00 2B 28 EE 07 4B 21 EE 02 2B 9F ED 09 3B 32 EE 44 2B 22 EE 06 2B 32 EE 41 2B 07 EE 43 2B 35 EE 42 5B B0 EE 45 0B BD EC 02 8B BD E8 00 88 FE DE 55 55 55 55 55 55 C5 BF 55 55 55 55 55 55 C5 3F B3 0B 11 11 11 11 81 3F 5C 3E E8 19 A0 01 2A 3F 01 DE 6C 79 E3 1D C7 3E A7 DF 2F B4 00 E6 5A 3E B8 3B A4 F9 B2 E0 E5 3D }
	condition:
		$1
}

rule file_4_5_0 {
	meta:
		name = "val_with_flags"
		size = 44
		refs = "001a _controlfp_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 01 46 00 23 0A 46 68 46 B0 EE 40 8B 00 93 ?? ?? ?? ?? B0 EE 48 0B 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "??$?RPAU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QBAXQBQAU__crt_stdio_stream_data@@@Z"
		size = 16
		refs = "000c _free_base"
		altNames = "??$?RD@__crt_internal_free_policy@@QBAXQBD@Z ??$?RE@__crt_internal_free_policy@@QBAXQBE@Z ??$?RG@__crt_internal_free_policy@@QBAXQBG@Z ??$?RJ@__crt_internal_free_policy@@QBAXQBJ@Z ??$?RP6AXXZ@__crt_internal_free_policy@@QBAXQBQ6AXXZ@Z ??$?RPAD@__crt_internal_free_policy@@QBAXQBQAD@Z ??$?RPA_W@__crt_internal_free_policy@@QBAXQBQA_W@Z ??$?RU__acrt_ptd@@@__crt_internal_free_policy@@QBAXQBU__acrt_ptd@@@Z ??$?RU__acrt_thread_parameter@@@__crt_internal_free_policy@@QBAXQBU__acrt_thread_parameter@@@Z ??$?RU__crt_lc_time_data@@@__crt_internal_free_policy@@QBAXQBU__crt_lc_time_data@@@Z ??$?RU__crt_locale_data@@@__crt_internal_free_policy@@QBAXQBU__crt_locale_data@@@Z ??$?RU__crt_locale_pointers@@@__crt_internal_free_policy@@QBAXQBU__crt_locale_pointers@@@Z ??$?RU__crt_lowio_handle_data@@@__crt_internal_free_policy@@QBAXQBU__crt_lowio_handle_data@@@Z ??$?RU__crt_multibyte_data@@@__crt_internal_free_policy@@QBAXQBU__crt_multibyte_data@@@Z ??$?RU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QBAXQBU__crt_stdio_stream_data@@@Z ??$?RUlconv@@@__crt_internal_free_policy@@QBAXQBUlconv@@@Z ??$?RUprocess_handle_pair@?A0xe43b7539@@@__crt_internal_free_policy@@QBAXQBUprocess_handle_pair@?A0xe43b7539@@@Z ??$?RUtm@@@__crt_internal_free_policy@@QBAXQBUtm@@@Z ??$?R_W@__crt_internal_free_policy@@QBAXQB_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_1_2 {
	meta:
		name = "??$?RD@__crt_public_free_policy@@QBAXQBD@Z"
		size = 16
		refs = "000c free"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_3_4 {
	meta:
		name = "??$?R_W@__crt_public_free_policy@@QBAXQB_W@Z"
		size = 16
		refs = "000c free"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 46 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_3_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAA@XZ"
		size = 24
		refs = "000c _free_base"
		altNames = "??1?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAA@XZ ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAA@XZ ??1?$scanset_buffer@_W@__crt_stdio_input@@QAA@XZ ??1?$scanset_storage@$01@__crt_stdio_input@@QAA@XZ ?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAAXXZ ?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_249_12_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAA@XZ"
		size = 24
		refs = "000c free"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_249_13_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAA@XZ"
		size = 24
		refs = "000c free"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_587_19_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAAXXZ"
		size = 24
		refs = "000c free"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_249_25_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAAXXZ"
		size = 24
		refs = "000c free"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_5_5_0 {
	meta:
		name = "?detach@?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAAPAPAU__crt_stdio_stream_data@@XZ"
		size = 18
		altNames = "?detach@?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QAAPAUprocess_handle_pair@?A0xe43b7539@@XZ ?detach@?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QAAPAU_iobuf@@XZ ?detach@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAAPBDXZ ?detach@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAAPB_WXZ ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAAPADXZ ?detach@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAAPADXZ ?detach@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAAPAEXZ ?detach@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAAPAGXZ ?detach@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAAPAJXZ ?detach@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAAPAP6AXXZXZ ?detach@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAAPAPADXZ ?detach@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAAPAPA_WXZ ?detach@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAAPAU__acrt_ptd@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAAPAU__acrt_thread_parameter@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAAPAU__acrt_thread_parameter@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAAPAU__crt_lc_time_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAAPAU__crt_locale_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAAPAU__crt_locale_pointers@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAAPAU__crt_lowio_handle_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAAPAU__crt_multibyte_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAAPAU__crt_stdio_stream_data@@XZ ?detach@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAAPAUlconv@@XZ ?detach@?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAAPAUprocess_handle_pair@?A0xe43b7539@@XZ ?detach@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAAPAUtm@@XZ ?detach@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAAPA_WXZ ?detach@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAAPA_WXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 18 68 00 22 1A 60 BD E8 00 88 }
	condition:
		$1
}

rule file_5_7_0 {
	meta:
		name = "__acrt_initialize_stdio"
		size = 172
		refs = "001e _calloc_base 0026 _free_base 0060 __acrt_InitializeCriticalSectionEx 00a0 __pioinfo 00a4 _iob 00a8 _nstream"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 27 4C 20 68 10 B9 4F F4 00 70 02 E0 03 28 01 DA 03 20 20 60 04 21 ?? ?? ?? ?? 60 60 00 20 ?? ?? ?? ?? 63 68 73 B9 03 23 04 21 03 20 23 60 ?? ?? ?? ?? 60 60 00 20 ?? ?? ?? ?? 63 68 13 B9 6F F0 00 00 26 E0 15 4D 14 4F 00 26 6F F0 01 08 05 F1 20 00 00 22 4F F4 7A 61 ?? ?? ?? ?? 63 68 B1 11 43 F8 26 50 06 F0 3F 03 03 EB 43 02 57 F8 21 30 03 EB 02 13 9B 69 13 F1 01 0F 03 D0 13 F1 02 0F 00 D0 0B B9 C5 F8 10 80 76 1C 38 35 03 2E DE D1 00 20 BD E8 F8 89 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_8_0 {
	meta:
		name = "__acrt_iob_func"
		size = 24
		refs = "0014 _iob"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B C0 EB C0 02 03 EB C2 00 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_9_0 {
	meta:
		name = "__acrt_uninitialize_stdio"
		size = 72
		refs = "0008 _flushall 000c _fcloseall 001a __acrt_stdio_free_buffer_nolock 0032 _free_base 0040 __imp_DeleteCriticalSection 0044 __piob"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B ?? ?? ?? ?? ?? ?? ?? ?? 0C 4C 0B 4E 00 25 23 68 E8 58 ?? ?? ?? ?? 23 68 EB 58 03 F1 20 00 33 68 98 47 2D 1D 0C 2D F2 D1 20 68 ?? ?? ?? ?? 00 23 23 60 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_10_0 {
	meta:
		name = "_get_stream_buffer_pointers"
		size = 52
		refs = "000c _errno 0014 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 1C 46 38 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 09 E0 09 B1 03 1D 0B 60 02 B1 10 60 14 B1 00 F1 08 03 23 60 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_5_11_0 {
	meta:
		name = "_lock_file"
		size = 24
		refs = "0014 __imp_EnterCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 20 30 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_12_0 {
	meta:
		name = "_unlock_file"
		size = 24
		refs = "0014 __imp_LeaveCriticalSection"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 20 30 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "normf"
		size = 62
		refs = "0014 crealf 0024 cimagf"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? 68 EE 08 0A 40 EE 00 0A B0 EE 60 0A 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "_fpclass"
		size = 132
		refs = "001c _sptype"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 8D ED 00 0B 47 F6 F0 73 BD F8 06 20 02 EA 03 01 99 42 10 D1 ?? ?? ?? ?? 01 28 09 D0 02 28 05 D0 03 28 18 BF 01 20 27 D1 02 20 25 E0 04 20 23 E0 4F F4 00 70 20 E0 61 B9 01 9B 6F F3 1F 53 0B B9 00 9B 33 B1 12 F4 00 4F 18 BF 10 20 14 D1 80 20 12 E0 B5 EE 40 0B F1 EE 10 FA 06 D1 12 F4 00 4F 18 BF 20 20 08 D1 40 20 06 E0 12 F4 00 4F 18 BF 08 20 01 D1 4F F4 80 70 BD E8 0C 88 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "_isnan"
		size = 58
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 8D ED 00 0B 47 F6 F8 72 BD F8 06 30 03 EA 02 01 47 F6 F0 73 99 42 05 D1 01 9B 6F F3 DF 43 1B B9 00 9B 0B B9 91 42 01 D1 01 20 00 E0 00 20 BD E8 0C 88 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "_mbclen"
		size = 32
		refs = "000c _ismbblead"
		altNames = "_mbclen_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 78 ?? ?? ?? ?? 18 B1 63 78 0B B1 02 20 00 E0 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "cacosf"
		size = 592
		refs = "0016 crealf 002a cimagf 0034 _fdtest 00fa _FCbuild 00fe csqrtf 0172 conjf 0182 atan2f 01ea asinhf 020a logf 0240 _FInf_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 08 8B 85 B0 CD ED 03 0A 8D ED 02 0A ?? ?? ?? ?? DD ED 03 0A B0 EE 40 1A 9D ED 02 0A 8D ED 01 1A ?? ?? ?? ?? 01 A8 8D ED 00 0A ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 0B D1 DD ED 01 8A 02 28 02 D1 9D ED 00 8A E4 E0 01 28 14 D1 9D ED 00 0A 43 E0 02 28 12 D1 01 2C 05 D1 76 4B DD ED 00 8A 93 ED 00 8A D5 E0 24 B9 9D ED 00 8A DF ED 71 8A CF E0 DD ED 00 8A B0 EE 68 8A CA E0 01 2C 26 D1 9D ED 01 0A 01 28 0A D1 B5 EE C0 0A F1 EE 10 FA 02 D2 DF ED 6B 8A 0C E0 DF ED 69 8A 09 E0 B5 EE C0 0A F1 EE 10 FA 02 D2 DF ED 64 8A 01 E0 DF ED 5E 8A 60 4B 93 ED 00 0A BD F8 02 30 B1 EE 40 8A 13 F4 00 4F 00 F0 A5 80 B1 EE 48 8A A1 E0 9D ED 00 0A 01 28 04 D1 DF ED 56 8A B1 EE 40 8A 98 E0 9D ED 01 1A B7 EE 00 8A F1 EE 40 0A 31 EE 08 0A ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 00 2A DD ED 01 2A B0 EE 60 9A F0 EE 40 9A F1 EE 42 0A 38 EE 62 0A ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 60 8A F0 EE 40 8A B0 EE 69 0A F0 EE 49 0A ?? ?? ?? ?? F0 EE 49 0A F0 EE 40 AA B0 EE 69 0A ?? ?? ?? ?? F0 EE 48 0A B0 EE 40 AA B0 EE 68 0A ?? ?? ?? ?? F0 EE 48 0A B0 EE 40 8A B0 EE 68 0A ?? ?? ?? ?? F0 EE 49 0A B0 EE 40 BA B0 EE 69 0A ?? ?? ?? ?? ?? ?? ?? ?? F0 EE 40 0A B0 EE 4B 0A ?? ?? ?? ?? DF ED 2C 0A B0 EE 00 2A 60 EE 02 8A F4 EE EA 0A F1 EE 10 FA 06 D2 8B EE 2A 0A B0 EE 6A 9A 00 EE 0A 8A 1D E0 F4 EE CA 0A F1 EE 10 FA 04 D2 88 EE 0A 0A B0 EE 4A 9A 08 E0 B1 EE 4A 9A F4 EE C9 0A F1 EE 10 FA 06 D2 88 EE 09 0A B0 EE 4B 8A 00 EE 2A 8A 05 E0 28 EE 2A 8A 9F ED 15 9A 0B EE 0A 8A B0 EE 48 0A ?? ?? ?? ?? B5 EE 40 9A B0 EE 40 8A F1 EE 10 FA 0F D0 F5 EE C0 8A B0 EE 49 0A F1 EE 10 FA 04 DB ?? ?? ?? ?? 38 EE 00 8A 03 E0 ?? ?? ?? ?? 38 EE 40 8A F0 EE 48 0A B0 EE 68 0A ?? ?? ?? ?? 05 B0 BD EC 08 8B BD E8 10 88 FE DE 00 00 00 00 0A E8 7F 5E DB 0F C9 3F ?? ?? ?? ?? DB 0F 49 40 DB 0F 49 3F E4 CB 16 40 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_getpid"
		size = 20
		refs = "0010 __imp_GetCurrentProcessId"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_6_4 {
	meta:
		name = "??$__crt_get_proc_address@P6AXI@Z@@YAP6AXI@ZQAUHINSTANCE__@@QBD@Z"
		size = 20
		refs = "0010 __imp_GetProcAddress"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_64_0 {
	meta:
		name = "__threadhandle"
		size = 20
		refs = "0010 __imp_GetCurrentThread"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_65_0 {
	meta:
		name = "__threadid"
		size = 20
		refs = "0010 __imp_GetCurrentThreadId"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_0_2 {
	meta:
		name = "_beep"
		size = 20
		refs = "0010 __imp_Beep"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_0_2 {
	meta:
		name = "_getdrives"
		size = 20
		refs = "0010 __imp_GetLogicalDrives"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_176_0_2 {
	meta:
		name = "_seterrormode"
		size = 20
		refs = "0010 __imp_SetErrorMode"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_4_0 {
	meta:
		name = "_mbsnbcat"
		size = 16
		refs = "000c _mbsnbcat_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_522_12_2 {
	meta:
		name = "_aligned_realloc"
		size = 16
		refs = "000c _aligned_offset_realloc_base"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_522_13_2 {
	meta:
		name = "_aligned_realloc_base"
		size = 16
		refs = "000c _aligned_offset_realloc_base"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_0_3 {
	meta:
		name = "_mbscat_s"
		size = 16
		refs = "000c _mbscat_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_0_2 {
	meta:
		name = "_mbscpy_s"
		size = 16
		refs = "000c _mbscpy_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_309_4_2 {
	meta:
		name = "_mbsnbcmp"
		size = 16
		refs = "000c _mbsnbcmp_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_196_4_4 {
	meta:
		name = "_mbsnbcoll"
		size = 16
		refs = "000c _mbsnbcoll_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "_mbsnbcpy"
		size = 16
		refs = "000c _mbsnbcpy_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_571_4_2 {
	meta:
		name = "_mbsnbicmp"
		size = 16
		refs = "000c _mbsnbicmp_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_4_2 {
	meta:
		name = "_mbsnbicoll"
		size = 16
		refs = "000c _mbsnbicoll_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_133_4_3 {
	meta:
		name = "_mbsnbset"
		size = 16
		refs = "000c _mbsnbset_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_225_4_2 {
	meta:
		name = "_mbsncat"
		size = 16
		refs = "000c _mbsncat_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_647_4_2 {
	meta:
		name = "_mbsncmp"
		size = 16
		refs = "000c _mbsncmp_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_472_4_4 {
	meta:
		name = "_mbsncoll"
		size = 16
		refs = "000c _mbsncoll_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_423_4_4 {
	meta:
		name = "_mbsncpy"
		size = 16
		refs = "000c _mbsncpy_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_4_0 {
	meta:
		name = "_mbsnicmp"
		size = 16
		refs = "000c _mbsnicmp_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_358_4_4 {
	meta:
		name = "_mbsnicoll"
		size = 16
		refs = "000c _mbsnicoll_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_425_4_4 {
	meta:
		name = "_mbsnset"
		size = 16
		refs = "000c _mbsnset_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_474_0_2 {
	meta:
		name = "_mbsset_s"
		size = 16
		refs = "000c _mbsset_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_4_2 {
	meta:
		name = "_mbstok_s"
		size = 16
		refs = "000c _mbstok_s_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_80_0 {
	meta:
		name = "_spawnv"
		size = 16
		refs = "000c ??$common_spawnv@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_52_4 {
	meta:
		name = "_spawnvp"
		size = 16
		refs = "000c ??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_84_4 {
	meta:
		name = "_wspawnv"
		size = 16
		refs = "000c ??$common_spawnv@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_56_0 {
	meta:
		name = "_wspawnvp"
		size = 16
		refs = "000c ??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_5_4 {
	meta:
		name = "mbtowc"
		size = 16
		refs = "000c _mbtowc_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_5_2 {
	meta:
		name = "strxfrm"
		size = 16
		refs = "000c _strxfrm_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_331_8_4 {
	meta:
		name = "wcstombs"
		size = 16
		refs = "000c ?_wcstombs_l_helper@@YAIPADPB_WIPAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_5_2 {
	meta:
		name = "wcsxfrm"
		size = 16
		refs = "000c _wcsxfrm_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_5_0 {
	meta:
		name = "_mbsnbcat_l"
		size = 226
		refs = "0016 _errno 001e _invalid_parameter_noinfo 002e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 003e strncat 005e _mbsbtype_l"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 85 B0 16 46 00 2E 0F 46 04 46 62 D0 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 24 59 E0 00 2F F5 D0 68 46 19 46 ?? ?? ?? ?? 02 99 8B 68 33 B9 32 46 39 46 20 46 ?? ?? ?? ?? 04 46 3F E0 25 46 14 F8 01 3B 00 2B FB D1 64 1E AC 42 09 D0 63 1B 59 1E 01 AA 28 46 ?? ?? ?? ?? 01 28 02 99 08 BF 64 1E 17 F8 01 2B 76 1E 4F F0 00 08 53 18 5B 7E 04 F8 01 2B 13 F0 04 0F 0B D0 76 B1 3B 78 76 1E 07 F1 01 07 23 70 04 F1 01 04 1B B9 04 F8 02 8C 05 E0 22 B1 00 2E E4 D1 01 E0 04 F8 01 8C AC 42 0A D0 63 1B 59 1E 01 AA 28 46 ?? ?? ?? ?? 01 28 02 D1 04 F8 01 8C 01 E0 84 F8 00 80 2C 46 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 05 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "creall"
		size = 16
		altNames = "creal"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 8D ED 02 1B BD E8 0F 88 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "?initialize_multibyte@@YAHXZ"
		size = 22
		refs = "0006 __acrt_initialize_multibyte"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 08 B9 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_332_10_0 {
	meta:
		name = "?common_mktemp_s_continue@@YA_NQBD0@Z"
		size = 22
		refs = "0006 _ismbstrail"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 08 B9 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_14_16_0 {
	meta:
		name = "_chsize"
		size = 28
		refs = "000a _chsize_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 CB 17 0A 46 ?? ?? ?? ?? 00 28 6F F0 00 00 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_29_8_0 {
	meta:
		name = "__acrt_uninitialize_tmpfile"
		size = 18
		refs = "0006 __acrt_stdio_free_tmpfile_name_buffers_nolock 000e _rmtmp"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_17_0 {
	meta:
		name = "_chsize_nolock"
		size = 336
		refs = "0016 _lseeki64_nolock 0028 _errno 0064 _calloc_base 007a _setmode_nolock 0094 _write_nolock 00b8 _free_base 00e0 __doserrno 0120 _get_osfhandle 0148 __imp_GetLastError 014c __imp_SetEndOfFile"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 1E 46 01 23 00 93 17 46 00 23 00 22 80 46 ?? ?? ?? ?? 00 EA 01 04 14 F1 01 0F 8A 46 02 90 03 D1 ?? ?? ?? ?? 04 68 54 E0 02 23 00 93 00 23 00 22 40 46 ?? ?? ?? ?? 00 EA 01 03 13 F1 01 0F EF D0 3C 1A 66 EB 01 05 00 2D 4F F0 00 09 57 DB 01 DC 00 2C 51 D0 4F F4 80 57 38 46 01 21 ?? ?? ?? ?? 06 46 1E B9 ?? ?? ?? ?? 0C 23 3D E0 4F F4 00 41 40 46 ?? ?? ?? ?? 81 46 00 2D 04 DB 01 DC BC 42 01 D3 3A 46 00 E0 22 46 31 46 40 46 ?? ?? ?? ?? 10 F1 01 0F 20 D0 24 1A 65 EB E0 75 00 2D 02 DB EA DC 00 2C E8 D1 49 46 40 46 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 4F F0 00 09 02 9A 53 46 40 46 CD F8 00 90 ?? ?? ?? ?? 00 EA 01 03 13 F1 01 0F A7 D0 00 24 20 46 BD E8 FE 8F ?? ?? ?? ?? 03 68 05 2B 03 D1 ?? ?? ?? ?? 0D 23 03 60 ?? ?? ?? ?? 04 68 30 46 ?? ?? ?? ?? EC E7 00 2D DD DC DC DA 33 46 3A 46 40 46 CD F8 00 90 ?? ?? ?? ?? 00 EA 01 03 13 F1 01 0F 84 D0 40 46 ?? ?? ?? ?? 09 4B 1B 68 98 47 00 28 C8 D1 ?? ?? ?? ?? 0D 23 03 60 04 4B 1B 68 98 47 04 46 ?? ?? ?? ?? 04 60 70 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_18_0 {
	meta:
		name = "_chsize_s"
		size = 196
		refs = "001c __doserrno 0058 _errno 0076 _invalid_parameter_noinfo 0090 ??$?RV<lambda_3b12a17125e8c5b5e6e6f6c6050db0c1>@@AAV<lambda_522ac1b1e1a1180d6f374a882b81d1c8>@@V<lambda_e92b96cac182f562f30acc9fb7872857>@@@?$__crt_seh_guarded_call@H@@QAAH$$QAV<lambda_3b12a17125e8c5b5e6e6f6c6050db0c1>@@AAV<lambda_522ac1b1e1a1180d6f374a882b81d1c8>@@$$QAV<lambda_e92b96cac182f562f30acc9fb7872857>@@@Z 00bc __pioinfo 00c0 _nhandle"
	strings:
		$1 = { 0F B4 2D E9 30 48 0D F1 08 0B 86 B0 1D 46 04 46 CD E9 0C 25 0A 94 10 F1 02 0F 04 D1 ?? ?? ?? ?? 00 23 03 60 42 E0 00 2C 36 DB 25 4B 1B 68 9C 42 32 D2 22 49 04 F0 3F 03 A0 11 03 EB 43 02 51 F8 20 30 03 EB 02 13 93 F8 28 30 13 F0 01 0F 07 D1 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 09 24 09 E0 00 2D 0B DC 0A DA ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 16 24 04 60 ?? ?? ?? ?? 18 E0 0A AB 04 93 0C AB 05 93 01 AB 04 AA 02 A9 68 46 CD E9 01 44 ?? ?? ?? ?? 04 46 0A E0 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 09 23 03 60 ?? ?? ?? ?? 09 24 20 46 06 B0 BD E8 30 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "_mbsnbset_s"
		size = 20
		refs = "000c _mbsnbset_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_522_14_4 {
	meta:
		name = "_aligned_recalloc"
		size = 20
		refs = "000c _aligned_offset_recalloc_base"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_522_15_4 {
	meta:
		name = "_aligned_recalloc_base"
		size = 20
		refs = "000c _aligned_offset_recalloc_base"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_673_0_4 {
	meta:
		name = "_mbccpy_s"
		size = 20
		refs = "000c _mbccpy_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_111_0_3 {
	meta:
		name = "_mbsnbcat_s"
		size = 20
		refs = "000c _mbsnbcat_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_231_0_2 {
	meta:
		name = "_mbsnbcpy_s"
		size = 20
		refs = "000c _mbsnbcpy_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_372_0_2 {
	meta:
		name = "_mbsncat_s"
		size = 20
		refs = "000c _mbsncat_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "_mbsncpy_s"
		size = 20
		refs = "000c _mbsncpy_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_596_0_2 {
	meta:
		name = "_mbsnset_s"
		size = 20
		refs = "000c _mbsnset_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_661_25_3 {
	meta:
		name = "_ultoa_s"
		size = 20
		refs = "000c ??$common_xtox_s@KD@@YAHKQADII_N@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_661_27_3 {
	meta:
		name = "_ultow_s"
		size = 20
		refs = "000c ??$common_xtox_s@K_W@@YAHKQA_WII_N@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_652_7_0 {
	meta:
		name = "wctomb_s"
		size = 20
		refs = "000c _wctomb_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "nextafterf"
		size = 18
		refs = "000e nexttowardf"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE E0 1A BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "wcsncpy"
		size = 52
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 8A B1 09 1A 0B 5B 24 F8 02 3B 0B B1 52 1E F9 D1 4A B1 52 1E 07 D0 00 21 2A B1 04 EB 42 03 24 F8 02 1B 9C 42 FB D1 BD E8 18 88 }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "cprojl"
		size = 132
		refs = "0012 creall 0026 cimagl 0030 _ldtest 0074 _LInf_C 0080 _LZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 01 2C 06 D0 01 28 04 D0 9D ED 04 0B 9D ED 06 1B 0F E0 BD F8 06 30 13 F4 00 4F 05 D0 09 4B 93 ED 00 0B B1 EE 40 1B 01 E0 9F ED 04 1B 02 4B 93 ED 00 0B 09 B0 BD E8 10 88 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_229_1_0 {
	meta:
		name = "cproj"
		size = 132
		refs = "0012 creal 0026 cimag 0030 _dtest 0074 _Inf_C 0080 _Zero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 01 2C 06 D0 01 28 04 D0 9D ED 04 0B 9D ED 06 1B 0F E0 BD F8 06 30 13 F4 00 4F 05 D0 09 4B 93 ED 00 0B B1 EE 40 1B 01 E0 9F ED 04 1B 02 4B 93 ED 00 0B 09 B0 BD E8 10 88 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_copysign"
		size = 36
	strings:
		$1 = { 2D E9 00 48 EB 46 51 EC 10 0B 52 EC 11 3B 82 EA 01 03 13 F0 00 4F 03 D0 81 F0 00 43 43 EC 10 0B BD E8 00 88 }
	condition:
		$1
}

rule file_20_4_0 {
	meta:
		name = "_mbslen"
		size = 16
		refs = "000c _mbslen_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_357_2 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_358_0 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_359_3 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_718_3 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_719_3 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_720_3 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_721_0 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_722_0 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_723_3 {
	meta:
		name = "?type_case_c@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_360_3 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_361_2 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_362_2 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_724_4 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_725_2 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_726_0 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_727_4 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_728_0 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_729_3 {
	meta:
		name = "?type_case_c@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
		size = 16
		refs = "000c ?type_case_c_tchar@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_N_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_304_15_2 {
	meta:
		name = "_ismbbkana"
		size = 16
		refs = "000c _ismbbkana_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_386_5_3 {
	meta:
		name = "_ismbcalnum"
		size = 16
		refs = "000c _ismbcalnum_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_287_5_2 {
	meta:
		name = "_ismbcalpha"
		size = 16
		refs = "000c _ismbcalpha_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_537_5_4 {
	meta:
		name = "_ismbcblank"
		size = 16
		refs = "000c _ismbcblank_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_128_8_0 {
	meta:
		name = "_ismbcdigit"
		size = 16
		refs = "000c _ismbcdigit_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_5_3 {
	meta:
		name = "_ismbcgraph"
		size = 16
		refs = "000c _ismbcgraph_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_4_3 {
	meta:
		name = "_ismbchira"
		size = 16
		refs = "000c _ismbchira_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_6_2 {
	meta:
		name = "_ismbckata"
		size = 16
		refs = "000c _ismbckata_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_447_4_3 {
	meta:
		name = "_ismbcl0"
		size = 16
		refs = "000c _ismbcl0_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_447_6_4 {
	meta:
		name = "_ismbcl1"
		size = 16
		refs = "000c _ismbcl1_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_447_8_4 {
	meta:
		name = "_ismbcl2"
		size = 16
		refs = "000c _ismbcl2_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_277_4_4 {
	meta:
		name = "_ismbclegal"
		size = 16
		refs = "000c _ismbclegal_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_689_5_3 {
	meta:
		name = "_ismbclower"
		size = 16
		refs = "000c _ismbclower_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_5_2 {
	meta:
		name = "_ismbcprint"
		size = 16
		refs = "000c _ismbcprint_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_537_7_0 {
	meta:
		name = "_ismbcpunct"
		size = 16
		refs = "000c _ismbcpunct_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_517_8_3 {
	meta:
		name = "_ismbcspace"
		size = 16
		refs = "000c _ismbcspace_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_8_0 {
	meta:
		name = "_ismbcsymbol"
		size = 16
		refs = "000c _ismbcsymbol_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_5_4 {
	meta:
		name = "_ismbcupper"
		size = 16
		refs = "000c _ismbcupper_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_392_4_0 {
	meta:
		name = "_mbbtombc"
		size = 16
		refs = "000c _mbbtombc_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_615_4_4 {
	meta:
		name = "_mbcjistojms"
		size = 16
		refs = "000c _mbcjistojms_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_615_6_4 {
	meta:
		name = "_mbcjmstojis"
		size = 16
		refs = "000c _mbcjmstojis_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_368_0_3 {
	meta:
		name = "_mbctohira"
		size = 16
		refs = "000c _mbctohira_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_4_2 {
	meta:
		name = "_mbctolower"
		size = 16
		refs = "000c _mbctolower_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_392_6_4 {
	meta:
		name = "_mbctombb"
		size = 16
		refs = "000c _mbctombb_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_4_0 {
	meta:
		name = "_mbctoupper"
		size = 16
		refs = "000c _mbctoupper_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_4_2 {
	meta:
		name = "_mbsnextc"
		size = 16
		refs = "000c _mbsnextc_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_419_4_4 {
	meta:
		name = "_mbsrev"
		size = 16
		refs = "000c _mbsrev_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_634_11_0 {
	meta:
		name = "_mkgmtime32"
		size = 16
		refs = "000c ??$common_mktime@J@@YAJQAUtm@@_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_634_12_4 {
	meta:
		name = "_mkgmtime64"
		size = 16
		refs = "000c ??$common_mktime@_J@@YA_JQAUtm@@_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_51_0 {
	meta:
		name = "_putenv"
		size = 16
		refs = "000c ??$common_putenv@D@@YAHQBD0@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_53_2 {
	meta:
		name = "_wputenv"
		size = 16
		refs = "000c ??$common_putenv@_W@@YAHQB_W0@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_122_0 {
	meta:
		name = "_wtof"
		size = 16
		refs = "000c ??$common_atof_l@_W@@YANQB_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_124_0 {
	meta:
		name = "atof"
		size = 16
		refs = "000c ??$common_atof_l@D@@YANQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_271_5_2 {
	meta:
		name = "towlower"
		size = 16
		refs = "000c _towlower_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_582_5_3 {
	meta:
		name = "towupper"
		size = 16
		refs = "000c _towupper_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_5_0 {
	meta:
		name = "_mbslen_l"
		size = 90
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a strlen"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 02 9A 93 68 1B B9 20 46 ?? ?? ?? ?? 0F E0 23 78 00 20 0A E0 13 44 5B 7E 13 F0 04 0F 02 D0 64 1C 23 78 23 B1 14 F8 01 3F 40 1C 00 2B F2 D1 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "_ldclass"
		size = 22
		refs = "000e _ldtest"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "_dclass"
		size = 22
		refs = "000e _dtest"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_21_1_0 {
	meta:
		name = "_ldpcomp"
		size = 84
		refs = "0012 _ldtest"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 02 28 18 D0 02 A8 ?? ?? ?? ?? 02 28 13 D0 9D ED 00 0B 9D ED 02 1B B4 EE C1 0B F1 EE 10 FA 38 BF 01 20 09 D3 B4 EE C0 1B F1 EE 10 FA 38 BF 04 20 02 D3 02 20 00 E0 00 20 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_495_1_0 {
	meta:
		name = "_dpcomp"
		size = 84
		refs = "0012 _dtest"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 02 28 18 D0 02 A8 ?? ?? ?? ?? 02 28 13 D0 9D ED 00 0B 9D ED 02 1B B4 EE C1 0B F1 EE 10 FA 38 BF 01 20 09 D3 B4 EE C0 1B F1 EE 10 FA 38 BF 04 20 02 D3 02 20 00 E0 00 20 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_21_2_0 {
	meta:
		name = "_ldsign"
		size = 24
		altNames = "_dsign"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 8D ED 00 0B BD F8 06 30 03 F4 00 40 BD E8 0C 88 }
	condition:
		$1
}

rule file_21_3_0 {
	meta:
		name = "nanl"
		size = 20
		refs = "0010 _LNan_C"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 93 ED 00 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_495_3_0 {
	meta:
		name = "nan"
		size = 20
		refs = "0010 _Nan_C"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 93 ED 00 0B BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "catanf"
		size = 110
		refs = "0014 crealf 0024 cimagf 0030 _FCbuild 0034 catanhf"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F0 EE 48 0A B1 EE 40 0A ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 60 1A F0 EE 40 1A CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F1 EE 48 0A ?? ?? ?? ?? 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "casinf"
		size = 110
		refs = "0014 crealf 0024 cimagf 0030 _FCbuild 0034 casinhf"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F0 EE 48 0A B1 EE 40 0A ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 60 1A F0 EE 40 1A CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F1 EE 48 0A ?? ?? ?? ?? 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "csinf"
		size = 110
		refs = "0014 crealf 0024 cimagf 0030 _FCbuild 0034 csinhf"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F0 EE 48 0A B1 EE 40 0A ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 60 1A F0 EE 40 1A CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F1 EE 48 0A ?? ?? ?? ?? 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_688_0_0 {
	meta:
		name = "ctanf"
		size = 110
		refs = "0014 crealf 0024 cimagf 0030 _FCbuild 0034 ctanhf"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F0 EE 48 0A B1 EE 40 0A ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 60 1A F0 EE 40 1A CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F1 EE 48 0A ?? ?? ?? ?? 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "wcstok"
		size = 34
		refs = "000e __acrt_getptd 001a __acrt_wcstok_s_novalidation"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 1A B9 ?? ?? ?? ?? 00 F1 24 02 21 46 28 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "??$common_tox_l@$1?internal_islower_l@@YA_NHQAU__crt_locale_pointers@@@Z$1?internal_map_upper@@YAHH0@Z@@YAHHKQAU__crt_locale_pointers@@@Z"
		size = 214
		refs = "0012 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 ?internal_islower_l@@YA_NHQAU__crt_locale_pointers@@@Z 004a _isleadbyte_l 0062 _errno 009e __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8D B0 0E 46 04 46 08 A8 11 46 ?? ?? ?? ?? B4 F5 80 7F 0A D2 09 A9 20 46 ?? ?? ?? ?? 00 28 48 D0 09 9B D3 F8 98 30 1C 5D 43 E0 00 23 AD F8 18 30 8D F8 1A 30 09 9B 5B 68 01 2B 0E DD 25 12 E8 B2 09 A9 ?? ?? ?? ?? 40 B1 00 23 8D F8 1A 30 8D F8 18 50 8D F8 19 40 02 21 09 E0 ?? ?? ?? ?? 2A 23 03 60 00 23 8D F8 19 30 8D F8 18 40 01 21 00 23 09 9A AD F8 1C 30 8D F8 1E 30 01 23 04 93 93 68 00 91 D2 F8 A8 10 03 93 03 23 02 93 07 AB 01 93 06 AB 09 A8 32 46 ?? ?? ?? ?? 50 B1 01 28 02 D1 9D F8 1C 40 05 E0 9D F8 1C 20 9D F8 1D 30 43 EA 02 24 9D F8 2C 30 33 B1 08 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 0D B0 BD E8 70 88 }
	condition:
		$1
}

rule file_24_1_0 {
	meta:
		name = "??$common_tox_l@$1?internal_isupper_l@@YA_NHQAU__crt_locale_pointers@@@Z$1?internal_map_lower@@YAHH0@Z@@YAHHKQAU__crt_locale_pointers@@@Z"
		size = 214
		refs = "0012 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 ?internal_isupper_l@@YA_NHQAU__crt_locale_pointers@@@Z 004a _isleadbyte_l 0062 _errno 009e __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8D B0 0E 46 04 46 08 A8 11 46 ?? ?? ?? ?? B4 F5 80 7F 0A D2 09 A9 20 46 ?? ?? ?? ?? 00 28 48 D0 09 9B D3 F8 94 30 1C 5D 43 E0 00 23 AD F8 18 30 8D F8 1A 30 09 9B 5B 68 01 2B 0E DD 25 12 E8 B2 09 A9 ?? ?? ?? ?? 40 B1 00 23 8D F8 1A 30 8D F8 18 50 8D F8 19 40 02 21 09 E0 ?? ?? ?? ?? 2A 23 03 60 00 23 8D F8 19 30 8D F8 18 40 01 21 00 23 09 9A AD F8 1C 30 8D F8 1E 30 01 23 04 93 93 68 00 91 D2 F8 A8 10 03 93 03 23 02 93 07 AB 01 93 06 AB 09 A8 32 46 ?? ?? ?? ?? 50 B1 01 28 02 D1 9D F8 1C 40 05 E0 9D F8 1C 20 9D F8 1D 30 43 EA 02 24 9D F8 2C 30 33 B1 08 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 0D B0 BD E8 70 88 }
	condition:
		$1
}

rule file_24_5_0 {
	meta:
		name = "?internal_islower_l@@YA_NHQAU__crt_locale_pointers@@@Z"
		size = 62
		refs = "0018 _isctype_l 0026 __pctype_func"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 61 B1 0A 68 53 68 01 2B 04 DD 0A 46 02 21 ?? ?? ?? ?? 09 E0 13 68 33 F8 14 30 03 E0 ?? ?? ?? ?? 30 F8 14 30 03 F0 02 00 08 B1 01 20 00 E0 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_24_6_0 {
	meta:
		name = "?internal_isupper_l@@YA_NHQAU__crt_locale_pointers@@@Z"
		size = 62
		refs = "0018 _isctype_l 0026 __pctype_func"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 61 B1 0A 68 53 68 01 2B 04 DD 0A 46 01 21 ?? ?? ?? ?? 09 E0 13 68 33 F8 14 30 03 E0 ?? ?? ?? ?? 30 F8 14 30 03 F0 01 00 08 B1 01 20 00 E0 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_24_7_0 {
	meta:
		name = "?internal_map_lower@@YAHHQAU__crt_locale_pointers@@@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 68 D3 F8 94 30 18 5C BD E8 00 88 }
	condition:
		$1
}

rule file_24_8_0 {
	meta:
		name = "?internal_map_upper@@YAHHQAU__crt_locale_pointers@@@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 68 D3 F8 98 30 18 5C BD E8 00 88 }
	condition:
		$1
}

rule file_24_11_0 {
	meta:
		name = "_chvalidchk_l"
		size = 40
		refs = "0018 __pctype_func"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 22 B1 13 68 1B 68 33 F8 10 30 03 E0 ?? ?? ?? ?? 30 F8 15 30 03 EA 04 00 BD E8 30 88 }
	condition:
		$1
}

rule file_24_12_0 {
	meta:
		name = "_ischartype_l"
		size = 52
		refs = "0016 _isctype_l 0024 __pctype_func"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0D 46 06 46 52 B1 14 68 63 68 01 2B 02 DD ?? ?? ?? ?? 09 E0 23 68 33 F8 16 30 03 E0 ?? ?? ?? ?? 30 F8 16 30 03 EA 05 00 BD E8 78 88 }
	condition:
		$1
}

rule file_24_14_0 {
	meta:
		name = "_tolower_l"
		size = 212
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001e ?internal_isupper_l@@YA_NHQAU__crt_locale_pointers@@@Z 0048 _isleadbyte_l 0060 _errno 009c __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8D B0 04 46 08 A8 ?? ?? ?? ?? 4F F4 80 76 B4 42 0A D2 09 A9 20 46 ?? ?? ?? ?? 00 28 48 D0 09 9B D3 F8 94 30 1C 5D 43 E0 00 23 AD F8 18 30 8D F8 1A 30 09 9B 5B 68 01 2B 0E DD 25 12 E8 B2 09 A9 ?? ?? ?? ?? 40 B1 00 23 8D F8 1A 30 8D F8 18 50 8D F8 19 40 02 22 09 E0 ?? ?? ?? ?? 2A 23 03 60 00 23 8D F8 19 30 8D F8 18 40 01 22 00 23 09 99 AD F8 1C 30 8D F8 1E 30 01 23 04 93 8B 68 D1 F8 A8 10 00 92 03 93 03 23 02 93 07 AB 01 93 06 AB 09 A8 32 46 ?? ?? ?? ?? 50 B1 01 28 02 D1 9D F8 1C 40 05 E0 9D F8 1C 20 9D F8 1D 30 43 EA 02 24 9D F8 2C 30 33 B1 08 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 0D B0 BD E8 70 88 }
	condition:
		$1
}

rule file_24_16_0 {
	meta:
		name = "_toupper_l"
		size = 212
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001c ?internal_islower_l@@YA_NHQAU__crt_locale_pointers@@@Z 0046 _isleadbyte_l 005e _errno 009c __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 8C B0 04 46 08 A8 ?? ?? ?? ?? B4 F5 80 7F 0A D2 09 A9 20 46 ?? ?? ?? ?? 00 28 49 D0 09 9B D3 F8 98 30 1C 5D 44 E0 00 23 AD F8 18 30 8D F8 1A 30 09 9B 5B 68 01 2B 0E DD 25 12 E8 B2 09 A9 ?? ?? ?? ?? 40 B1 00 23 8D F8 1A 30 8D F8 18 50 8D F8 19 40 02 21 09 E0 ?? ?? ?? ?? 2A 23 03 60 00 23 8D F8 19 30 8D F8 18 40 01 21 00 23 09 9A AD F8 1C 30 8D F8 1E 30 01 23 04 93 93 68 00 91 D2 F8 A8 10 03 93 03 23 02 93 07 AB 01 93 06 AB 09 A8 4F F4 00 72 ?? ?? ?? ?? 50 B1 01 28 02 D1 9D F8 1C 40 05 E0 9D F8 1C 20 9D F8 1D 30 43 EA 02 24 9D F8 2C 30 33 B1 08 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 0C B0 BD E8 30 88 }
	condition:
		$1
}

rule file_24_17_0 {
	meta:
		name = "tolower"
		size = 40
		refs = "0012 _tolower_l 0024 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4B 1B 68 23 B1 00 21 BD E8 00 48 ?? ?? ?? ?? A0 F1 41 03 19 2B 00 D8 20 30 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_18_0 {
	meta:
		name = "toupper"
		size = 40
		refs = "0012 _toupper_l 0024 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4B 1B 68 23 B1 00 21 BD E8 00 48 ?? ?? ?? ?? A0 F1 61 03 19 2B 00 D8 20 38 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "??$common_tcsnset_s@D@@YAHQADIDI@Z"
		size = 100
		refs = "0052 _errno 005a _invalid_parameter_noinfo"
		altNames = "_strnset_s"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 1C 46 15 46 1C B9 18 B9 F9 B9 00 20 24 E0 E0 B1 D9 B1 90 F9 00 30 02 46 07 E0 4C B1 49 1E 06 D0 15 70 52 1C 92 F9 00 30 64 1E 00 2B F5 D1 44 B9 92 F9 00 30 03 E0 49 1E 03 D0 12 F9 01 3F 00 2B F9 D1 00 29 E1 D1 00 23 03 70 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 BD E8 30 88 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "scalbn"
		size = 64
		refs = "0014 _dtest 0020 _dscale 0030 _fperrraise"
		altNames = "scalbln"
	strings:
		$1 = { 03 B4 2D E9 1E 48 0D F1 10 0B 04 46 8D ED 00 0B 94 B1 68 46 ?? ?? ?? ?? 00 28 0B DA 68 46 21 46 ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 00 0B BD E8 1E 08 5D F8 0C FB }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "scalblnl"
		size = 64
		refs = "0014 _ldtest 0020 _ldscale 0030 _fperrraise"
	strings:
		$1 = { 03 B4 2D E9 1E 48 0D F1 10 0B 04 46 8D ED 00 0B 94 B1 68 46 ?? ?? ?? ?? 00 28 0B DA 68 46 21 46 ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 00 0B BD E8 1E 08 5D F8 0C FB }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "scalbnl"
		size = 64
		refs = "0014 _ldtest 0020 _ldscale 0030 _fperrraise"
	strings:
		$1 = { 03 B4 2D E9 1E 48 0D F1 10 0B 04 46 8D ED 00 0B 94 B1 68 46 ?? ?? ?? ?? 00 28 0B DA 68 46 21 46 ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 00 0B BD E8 1E 08 5D F8 0C FB }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "??$__crt_time_elapsed_leap_years@H@@YAHH@Z"
		size = 60
		altNames = "??$__crt_time_elapsed_leap_years@J@@YAJJ@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 44 1E 00 F2 2B 11 0A 48 81 FB 00 32 D3 11 03 EB D3 71 84 FB 00 32 53 11 03 EB D3 73 CA 1A 63 10 04 EB 93 73 02 EB A3 03 A3 F1 11 00 BD E8 18 88 1F 85 EB 51 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "??$__crt_time_is_leap_year@H@@YA_NH@Z"
		size = 84
		altNames = "??$__crt_time_is_leap_year@J@@YA_NJ@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 43 10 00 EB 93 73 9B 10 0F 4C B0 EB 83 03 0B D1 80 FB 04 32 53 11 03 EB D3 73 64 22 03 FB 02 F3 C3 1A 01 D0 01 20 0D E0 00 F2 6C 71 81 FB 04 32 D3 11 03 EB D3 72 4F F4 C8 73 02 FB 03 F3 CB 1A F0 D0 00 20 BD E8 18 88 1F 85 EB 51 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "??$common_gmtime@J@@YAPAUtm@@QBJ@Z"
		size = 34
		refs = "000a __getgmtimebuf 0014 ??$common_gmtime_s@J@@YAHQAUtm@@QBJ@Z"
		altNames = "_gmtime32"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 04 46 1C B1 29 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "??$common_gmtime@_J@@YAPAUtm@@QB_J@Z"
		size = 34
		refs = "000a __getgmtimebuf 0014 ??$common_gmtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 04 46 1C B1 29 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_570_0_0 {
	meta:
		name = "??$common_localtime@J@@YAPAUtm@@QBJ@Z"
		size = 34
		refs = "000a __getgmtimebuf 0014 ??$common_localtime_s@J@@YAHQAUtm@@QBJ@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 04 46 1C B1 29 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_570_1_0 {
	meta:
		name = "??$common_localtime@_J@@YAPAUtm@@QB_J@Z"
		size = 34
		refs = "000a __getgmtimebuf 0014 ??$common_localtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 04 46 1C B1 29 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_27_16_0 {
	meta:
		name = "_gmtime64"
		size = 34
		refs = "000a __getgmtimebuf 0014 ??$common_gmtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 04 46 1C B1 29 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_570_11_3 {
	meta:
		name = "_localtime32"
		size = 34
		refs = "000a __getgmtimebuf 0014 ??$common_localtime_s@J@@YAHQAUtm@@QBJ@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 04 46 1C B1 29 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_570_13_2 {
	meta:
		name = "_localtime64"
		size = 34
		refs = "000a __getgmtimebuf 0014 ??$common_localtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 04 46 1C B1 29 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_27_5_0 {
	meta:
		name = "??$common_gmtime_s@J@@YAHQAUtm@@QBJ@Z"
		size = 360
		refs = "000e _errno 0016 _invalid_parameter_noinfo 0024 memset 0140 _days 0144 _lpdays"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 04 46 0E 46 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 88 E0 24 22 FF 21 20 46 ?? ?? ?? ?? 00 2E F0 D0 31 68 4D 4B 99 42 04 DA ?? ?? ?? ?? 16 23 03 60 ED E7 CB 17 07 2B 03 DB F6 DC 46 4B 99 42 F3 D8 43 4B 00 20 81 FB 03 32 D3 15 03 EB D3 72 3F 4B 02 FB 03 F3 C9 1A 93 00 3B 4A 46 33 91 42 0C DB 89 1A 5B 1C 91 42 08 DB 89 1A 36 4A 5B 1C 91 42 02 DB 5B 1C 89 1A 00 E0 01 20 31 4F 63 61 81 FB 07 32 53 18 1B 14 03 EB D3 72 2C 4B E2 61 02 FB 03 F3 A1 EB 03 0E 08 B1 27 4A 00 E0 25 4A E5 69 53 68 01 21 AB 42 05 DA 10 1D 50 F8 04 3F 49 1C AB 42 FA DB 49 1E 21 61 52 F8 21 30 EB 1A E3 60 31 68 81 FB 07 32 53 18 1B 14 03 EB D3 73 19 1D 17 4B 81 FB 03 32 53 18 9B 10 03 EB D3 73 C3 EB C3 03 CB 1A A3 61 11 4B 8E FB 03 32 02 EB 0E 03 DB 12 03 EB D3 72 4F F4 61 63 02 FB 03 F3 A2 60 AE EB 03 01 08 4B 81 FB 03 32 53 18 5B 11 03 EB D3 73 63 60 C3 EB 03 13 A1 EB 83 03 23 60 00 23 23 62 00 20 BD E8 F0 88 89 88 88 88 C5 B3 A2 91 93 24 49 92 ?? ?? ?? ?? ?? ?? ?? ?? 80 51 01 00 07 45 2E C2 00 85 E2 01 80 33 E1 01 80 1F 86 07 79 2D 03 11 CF E1 58 93 40 57 FF FF }
	condition:
		$1
}

rule file_27_6_0 {
	meta:
		name = "??$common_gmtime_s@_J@@YAHQAUtm@@QB_J@Z"
		size = 312
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0026 memset 0064 ?compute_year@@YAHAA_JAA_N@Z 007a __rt_sdiv64 0124 _days 0128 _lpdays"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 85 B0 06 46 0F 46 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 7B E0 24 22 FF 21 30 46 ?? ?? ?? ?? 00 2F F0 D0 D7 E9 00 21 CD E9 02 21 B1 F1 FF 3F 08 DC 02 DB 3D 4B 9A 42 04 D2 ?? ?? ?? ?? 16 23 03 60 E6 E7 07 29 03 DB F7 DC 36 4B 9A 42 F4 D8 00 23 69 46 02 A8 8D F8 00 30 ?? ?? ?? ?? DF F8 C0 80 DD E9 02 45 70 61 40 46 2B 46 22 46 00 21 ?? ?? ?? ?? 80 FB 08 32 F0 61 B4 EB 03 09 9D F8 00 30 65 EB 02 0A 0B B1 25 4A 00 E0 23 4A F5 69 53 68 01 21 AB 42 05 DA 14 1D 54 F8 04 3F 49 1C AB 42 FA DB 49 1E 31 61 52 F8 21 30 40 46 EB 1A F3 60 D7 E9 00 23 00 21 ?? ?? ?? ?? 16 4B 01 1D 81 FB 03 32 53 18 9B 10 03 EB D3 73 C3 EB C3 03 CB 1A 4F F4 61 64 B3 61 53 46 4A 46 00 21 20 46 ?? ?? ?? ?? 80 FB 04 32 B0 60 B9 EB 03 04 6A EB 02 03 00 21 3C 20 22 46 ?? ?? ?? ?? C0 EB 00 13 A4 EB 83 03 C6 E9 00 30 00 23 33 62 00 20 05 B0 BD E8 F0 8F FE DE 93 24 49 92 ?? ?? ?? ?? ?? ?? ?? ?? 80 51 01 00 CF E1 58 93 40 57 FF FF }
	condition:
		$1
}

rule file_27_9_0 {
	meta:
		name = "?compute_year@@YAHAAJAA_N@Z"
		size = 104
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2C 68 15 4B 84 FB 03 32 D3 15 03 EB D3 72 11 4B 02 FB 03 F3 E3 1A 2B 60 93 00 0D 4A 03 F1 46 00 2B 68 93 42 10 DB 9B 1A 40 1C 2B 60 93 42 0B DB 9B 1A 06 4A 40 1C 2B 60 93 42 03 DB 40 1C 9B 1A 2B 60 01 E0 01 23 0B 70 BD E8 30 88 FE DE 00 85 E2 01 80 33 E1 01 80 1F 86 07 79 2D 03 11 }
	condition:
		$1
}

rule file_27_10_0 {
	meta:
		name = "?compute_year@@YAHAA_JAA_N@Z"
		size = 196
		refs = "001c __rt_sdiv64 008a ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
		$1 = { 2D E9 F8 4F 0D F1 20 0B 06 46 D6 E9 00 45 DF F8 B0 A0 88 46 2B 46 22 46 00 21 50 46 ?? ?? ?? ?? 00 F1 46 07 A7 F1 46 03 83 FB 0A 32 23 48 07 F2 2B 11 E3 1A 65 EB 02 02 C6 E9 00 32 81 FB 00 32 7D 1E D3 11 03 EB D3 71 85 FB 00 32 53 11 03 EB D3 73 CA 1A 6B 10 05 EB 93 73 DF F8 5C 90 02 EB A3 03 11 3B 83 FB 09 14 D6 E9 00 32 5B 1A A2 41 C6 E9 00 32 00 2A 14 DC 13 DA 13 EB 0A 03 42 F1 00 02 28 46 C6 E9 00 32 2F 46 ?? ?? ?? ?? 78 B1 D6 E9 00 32 13 EB 09 03 42 F1 00 02 C6 E9 00 32 03 E0 38 46 ?? ?? ?? ?? 10 B1 01 23 88 F8 00 30 38 46 BD E8 F8 8F FE DE 80 51 01 00 1F 85 EB 51 80 33 E1 01 }
	condition:
		$1
}

rule file_27_13_0 {
	meta:
		name = "__getgmtimebuf"
		size = 58
		refs = "0008 __acrt_getptd_noexit 0010 _errno 0022 _malloc_base 002a _free_base"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B ?? ?? ?? ?? 04 46 2C B9 ?? ?? ?? ?? 0C 23 03 60 00 20 0C E0 A3 6B 4B B9 24 20 ?? ?? ?? ?? A0 63 00 20 ?? ?? ?? ?? A3 6B 00 2B ED D0 A0 6B BD E8 18 88 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "strspn"
		size = 136
		refs = "0008 __security_push_cookie 007a __security_pop_cookie 0082 __report_rangecheckfailure"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 88 B0 0C 46 00 23 00 21 6A 46 20 2B 05 46 32 D2 99 54 5B 1C 20 2B FA DB 23 78 6B B1 68 46 01 26 D9 08 03 F0 07 03 06 FA 03 F2 0B 5C 13 43 0B 54 14 F8 01 3F 00 2B F3 D1 2A 78 B2 B1 02 F0 07 03 01 21 99 40 6B 46 D2 08 D3 5C 00 20 19 42 0D D0 01 26 6C 46 40 1C 42 5D 02 F0 07 03 06 FA 03 F1 D3 08 1B 5D 19 42 F5 D1 00 E0 00 20 08 B0 ?? ?? ?? ?? BD E8 70 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_29_5_0 {
	meta:
		name = "?is_in_use@__crt_stdio_stream@@QBA_NXZ"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 13 F4 00 5F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_29_9_0 {
	meta:
		name = "_rmtmp"
		size = 124
		refs = "0010 __acrt_lock 0030 _lock_file 004e _fclose_nolock 0058 _unlock_file 006a __acrt_unlock 0074 _nstream 0078 __piob"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 00 25 3D 60 08 20 ?? ?? ?? ?? 00 22 18 48 16 49 BA 60 0B 68 9A 42 22 D0 03 68 53 F8 22 40 7C 60 04 B9 1A E0 20 46 ?? ?? ?? ?? E3 68 BF F3 5B 8F 13 F4 00 5F 01 D0 01 23 00 E0 00 23 33 B1 E3 69 23 B1 20 46 ?? ?? ?? ?? 6B 1C 3B 60 78 68 ?? ?? ?? ?? 06 48 05 49 3D 68 BA 68 52 1C D8 E7 08 20 ?? ?? ?? ?? 38 68 BD E8 BE 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_10_0 {
	meta:
		name = "_rmtmp$fin$0"
		size = 16
		refs = "0004 ?public_stream@__crt_stdio_stream@@QBAPAU_iobuf@@XZ 0008 _unlock_file"
	strings:
		$1 = { 10 B5 38 1D ?? ?? ?? ?? ?? ?? ?? ?? 10 BD 00 00 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "_ldxp_addh"
		size = 676
		refs = "0028 _ldunscale 0036 _ldtest 0056 _fperrraise 01a6 _ld_int 01b0 _ldscale 02a0 _LNan_C"
	strings:
		$1 = { 03 B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B 89 B0 0E 46 00 2E 8D ED 02 0B 8D ED 04 0B 04 46 00 F0 33 81 04 A9 0D F1 02 00 ?? ?? ?? ?? 00 28 26 DD 02 28 1F D0 20 46 ?? ?? ?? ?? 00 28 1A DD 02 28 00 F0 22 81 E2 88 BD F8 0E 30 53 40 13 F4 00 4F 00 F0 1A 81 01 20 ?? ?? ?? ?? 91 4B 01 2E 93 ED 00 0B 84 ED 00 0B 40 F3 0F 81 9F ED 8B 0B 84 ED 02 0B 09 E1 9D ED 02 0B 84 ED 00 0B 04 E1 80 F2 03 81 00 25 00 2E 4F F4 00 68 40 F3 FD 80 9F ED 82 8B A6 F1 01 0A 04 EB C6 09 04 EB C5 07 06 A9 97 ED 00 0B 68 46 8D ED 06 0B ?? ?? ?? ?? 00 28 00 F3 EA 80 00 F0 DD 80 BD F9 00 20 BD F9 02 30 9D ED 02 1B D3 1A 13 F1 1A 0F 2A DC B5 EE 40 1B F1 EE 10 FA 25 D0 2B 46 3A 46 5B 1C 08 32 B3 42 06 DA 92 ED 00 0B B5 EE 40 0B F1 EE 10 FA F4 D1 53 45 B8 BF 5B 1C 02 DB B3 42 08 BF 5B 1E 9D 42 0A DA 04 EB C3 02 5B 1B 12 ED 02 0B 5B 1E 82 ED 00 0B A2 F1 08 02 F7 D1 87 ED 00 1B 8D ED 02 8B A3 E0 1A 2B 07 DB B5 EE 40 1B F1 EE 10 FA 02 D0 90 46 6D 1C 99 E0 97 ED 00 0B 30 EE 01 0B B5 EE 40 0B 87 ED 00 0B F1 EE 10 FA 1A D1 2A 46 3B 46 52 1C 08 33 B2 42 08 DA 93 ED 00 0B B5 EE 40 0B 03 ED 02 0B F1 EE 10 FA F2 D1 04 EB C6 03 03 ED 02 8B 97 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 F0 83 80 02 A9 0D F1 02 00 8D ED 02 0B ?? ?? ?? ?? BD F9 02 20 A8 F1 1A 03 93 42 3A DA A2 EB 08 03 1A 33 19 B2 02 A8 ?? ?? ?? ?? BD F9 02 10 02 A8 ?? ?? ?? ?? 97 ED 00 1B 9D ED 02 0B 31 EE 40 0B B5 EE 40 0B 87 ED 00 0B F1 EE 10 FA 0F D1 2B 46 5B 1C 08 37 B3 42 08 DA 97 ED 00 0B B5 EE 40 0B 07 ED 02 0B F1 EE 10 FA F2 D1 09 ED 02 8B 6D 1E 02 D1 4F F4 00 68 38 E0 04 EB C5 03 04 A9 13 ED 02 0B 68 46 8D ED 04 0B ?? ?? ?? ?? BD F9 00 80 2B E0 6D 1C B5 42 37 D0 97 ED 00 0B 39 46 68 46 8D ED 02 0B ?? ?? ?? ?? 1A 21 38 46 ?? ?? ?? ?? BD F9 00 10 38 46 ?? ?? ?? ?? 97 ED 00 1B 9D ED 02 0B BD F9 00 80 30 EE 41 0B B5 EE 40 0B 8D ED 02 0B F1 EE 10 FA 01 D1 B0 EE 41 0B 04 A9 0D F1 02 00 8D ED 04 0B ?? ?? ?? ?? B5 42 FF F6 15 AF 0A E0 9D ED 02 0B 04 EB C5 02 6B 1C B3 42 82 ED 00 0B 01 DA 82 ED 02 8B 20 46 09 B0 BD EC 02 8B BD E8 F0 0F 5D F8 0C FB 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "_dxp_addh"
		size = 676
		refs = "0028 _dunscale 0036 _dtest 0056 _fperrraise 01a6 _d_int 01b0 _dscale 02a0 _Nan_C"
	strings:
		$1 = { 03 B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B 89 B0 0E 46 00 2E 8D ED 02 0B 8D ED 04 0B 04 46 00 F0 33 81 04 A9 0D F1 02 00 ?? ?? ?? ?? 00 28 26 DD 02 28 1F D0 20 46 ?? ?? ?? ?? 00 28 1A DD 02 28 00 F0 22 81 E2 88 BD F8 0E 30 53 40 13 F4 00 4F 00 F0 1A 81 01 20 ?? ?? ?? ?? 91 4B 01 2E 93 ED 00 0B 84 ED 00 0B 40 F3 0F 81 9F ED 8B 0B 84 ED 02 0B 09 E1 9D ED 02 0B 84 ED 00 0B 04 E1 80 F2 03 81 00 25 00 2E 4F F4 00 68 40 F3 FD 80 9F ED 82 8B A6 F1 01 0A 04 EB C6 09 04 EB C5 07 06 A9 97 ED 00 0B 68 46 8D ED 06 0B ?? ?? ?? ?? 00 28 00 F3 EA 80 00 F0 DD 80 BD F9 00 20 BD F9 02 30 9D ED 02 1B D3 1A 13 F1 1A 0F 2A DC B5 EE 40 1B F1 EE 10 FA 25 D0 2B 46 3A 46 5B 1C 08 32 B3 42 06 DA 92 ED 00 0B B5 EE 40 0B F1 EE 10 FA F4 D1 53 45 B8 BF 5B 1C 02 DB B3 42 08 BF 5B 1E 9D 42 0A DA 04 EB C3 02 5B 1B 12 ED 02 0B 5B 1E 82 ED 00 0B A2 F1 08 02 F7 D1 87 ED 00 1B 8D ED 02 8B A3 E0 1A 2B 07 DB B5 EE 40 1B F1 EE 10 FA 02 D0 90 46 6D 1C 99 E0 97 ED 00 0B 30 EE 01 0B B5 EE 40 0B 87 ED 00 0B F1 EE 10 FA 1A D1 2A 46 3B 46 52 1C 08 33 B2 42 08 DA 93 ED 00 0B B5 EE 40 0B 03 ED 02 0B F1 EE 10 FA F2 D1 04 EB C6 03 03 ED 02 8B 97 ED 00 0B B5 EE 40 0B F1 EE 10 FA 00 F0 83 80 02 A9 0D F1 02 00 8D ED 02 0B ?? ?? ?? ?? BD F9 02 20 A8 F1 1A 03 93 42 3A DA A2 EB 08 03 1A 33 19 B2 02 A8 ?? ?? ?? ?? BD F9 02 10 02 A8 ?? ?? ?? ?? 97 ED 00 1B 9D ED 02 0B 31 EE 40 0B B5 EE 40 0B 87 ED 00 0B F1 EE 10 FA 0F D1 2B 46 5B 1C 08 37 B3 42 08 DA 97 ED 00 0B B5 EE 40 0B 07 ED 02 0B F1 EE 10 FA F2 D1 09 ED 02 8B 6D 1E 02 D1 4F F4 00 68 38 E0 04 EB C5 03 04 A9 13 ED 02 0B 68 46 8D ED 04 0B ?? ?? ?? ?? BD F9 00 80 2B E0 6D 1C B5 42 37 D0 97 ED 00 0B 39 46 68 46 8D ED 02 0B ?? ?? ?? ?? 1A 21 38 46 ?? ?? ?? ?? BD F9 00 10 38 46 ?? ?? ?? ?? 97 ED 00 1B 9D ED 02 0B BD F9 00 80 30 EE 41 0B B5 EE 40 0B 8D ED 02 0B F1 EE 10 FA 01 D1 B0 EE 41 0B 04 A9 0D F1 02 00 8D ED 04 0B ?? ?? ?? ?? B5 42 FF F6 15 AF 0A E0 9D ED 02 0B 04 EB C5 02 6B 1C B3 42 82 ED 00 0B 01 DA 82 ED 02 8B 20 46 09 B0 BD EC 02 8B BD E8 F0 0F 5D F8 0C FB 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1_0 {
	meta:
		name = "_ldxp_addx"
		size = 58
		refs = "0028 _ldxp_addh"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 1F 46 00 26 00 2F 15 46 88 46 04 46 0E DD 95 ED 00 0B B5 EE 40 0B F1 EE 10 FA 07 D0 41 46 20 46 ?? ?? ?? ?? 76 1C 08 35 BE 42 F0 DB 20 46 BD E8 F8 89 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "_dxp_addx"
		size = 58
		refs = "0028 _dxp_addh"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 1F 46 00 26 00 2F 15 46 88 46 04 46 0E DD 95 ED 00 0B B5 EE 40 0B F1 EE 10 FA 07 D0 41 46 20 46 ?? ?? ?? ?? 76 1C 08 35 BE 42 F0 DB 20 46 BD E8 F8 89 }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "_ldxp_getw"
		size = 92
		altNames = "_dxp_getw"
	strings:
		$1 = { 2D E9 00 48 EB 46 11 B9 9F ED 12 0B 1F E0 01 29 1B D0 90 ED 00 2B B5 EE 40 2B F1 EE 10 FA 14 D0 01 29 06 DD 90 ED 02 0B B5 EE 40 0B F1 EE 10 FA 0B D0 90 ED 02 0B 02 29 02 D1 30 EE 02 0B 06 E0 90 ED 04 1B 30 EE 01 0B F7 E7 90 ED 00 0B BD E8 00 88 FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "_ldxp_invx"
		size = 228
		refs = "0018 _ldtest 004c memcpy 0058 _ldxp_mulh 0074 _ldxp_setw 0096 _ldxp_mulx 00a2 _ldxp_addh 00be _ldxp_addx 00d8 _LInf_C"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 04 8B 82 B0 0D 46 00 2D 17 46 04 46 58 D0 ?? ?? ?? ?? 00 28 0C DB 01 28 02 D1 9F ED 2D 0B 04 E0 00 28 4D D1 2A 4B 93 ED 00 0B 84 ED 00 0B 47 E0 07 EB C5 06 94 ED 00 8B 30 46 EA 00 21 46 06 EB C5 09 ?? ?? ?? ?? BF EE 00 0B 29 46 30 46 ?? ?? ?? ?? 01 2D 03 DD 94 ED 02 0B 38 EE 00 8B B7 EE 00 9B 29 46 89 EE 08 0B 20 46 ?? ?? ?? ?? 4F F0 01 08 01 2D 24 DD EA 00 21 46 38 46 ?? ?? ?? ?? 2B 46 32 46 29 46 38 46 CD F8 00 90 ?? ?? ?? ?? B0 EE 49 0B 29 46 38 46 ?? ?? ?? ?? 2B 46 22 46 29 46 38 46 CD F8 00 90 ?? ?? ?? ?? 2B 46 3A 46 29 46 20 46 ?? ?? ?? ?? 4F EA 48 08 A8 45 DA DB 20 46 02 B0 BD EC 04 8B BD E8 F0 8B FE DE ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_3_0 {
	meta:
		name = "_dxp_invx"
		size = 228
		refs = "0018 _dtest 004c memcpy 0058 _dxp_mulh 0074 _dxp_setw 0096 _dxp_mulx 00a2 _dxp_addh 00be _dxp_addx 00d8 _Inf_C"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 04 8B 82 B0 0D 46 00 2D 17 46 04 46 58 D0 ?? ?? ?? ?? 00 28 0C DB 01 28 02 D1 9F ED 2D 0B 04 E0 00 28 4D D1 2A 4B 93 ED 00 0B 84 ED 00 0B 47 E0 07 EB C5 06 94 ED 00 8B 30 46 EA 00 21 46 06 EB C5 09 ?? ?? ?? ?? BF EE 00 0B 29 46 30 46 ?? ?? ?? ?? 01 2D 03 DD 94 ED 02 0B 38 EE 00 8B B7 EE 00 9B 29 46 89 EE 08 0B 20 46 ?? ?? ?? ?? 4F F0 01 08 01 2D 24 DD EA 00 21 46 38 46 ?? ?? ?? ?? 2B 46 32 46 29 46 38 46 CD F8 00 90 ?? ?? ?? ?? B0 EE 49 0B 29 46 38 46 ?? ?? ?? ?? 2B 46 22 46 29 46 38 46 CD F8 00 90 ?? ?? ?? ?? 2B 46 3A 46 29 46 20 46 ?? ?? ?? ?? 4F EA 48 08 A8 45 DA DB 20 46 02 B0 BD EC 04 8B BD E8 F0 8B FE DE ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_30_4_0 {
	meta:
		name = "_ldxp_ldexpx"
		size = 60
		refs = "001c ldexp"
		altNames = "_dxp_ldexpx"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0F 46 00 25 00 2F 90 46 06 46 10 DD 04 46 94 ED 00 0B 40 46 ?? ?? ?? ?? B5 EE 40 0B 84 ED 00 0B F1 EE 10 FA 03 D0 6D 1C 08 34 BD 42 EF DB 30 46 BD E8 F8 89 }
	condition:
		$1
}

rule file_30_5_0 {
	meta:
		name = "_ldxp_movx"
		size = 26
		refs = "0010 memcpy"
		altNames = "_dxp_movx"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 13 46 CA 00 19 46 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_30_6_0 {
	meta:
		name = "_ldxp_mulh"
		size = 324
		refs = "000c __security_push_cookie 0030 _ldtest 0040 _fperrraise 00cc _ldunscale 00d4 _ld_int 00de _ldscale 00ea _ldxp_addh 0130 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 04 8B ?? ?? ?? ?? 8D B0 0E 46 9F ED 49 8B 00 2E B0 EE 40 9B 04 46 1F DD 90 ED 00 2B 04 A8 22 EE 00 2B 8D ED 04 2B ?? ?? ?? ?? 05 46 00 2D 11 DB 02 2D 02 D1 01 20 ?? ?? ?? ?? 9D ED 04 0B 00 2D 84 ED 00 0B 6D DD 01 2E 6B DD 9F ED 39 0B 84 ED 02 0B 66 E0 84 ED 00 8B 01 25 00 27 00 2E 60 DD 0D F1 10 09 0D F1 10 08 04 2D 1F DA 7B 19 04 EB C3 02 09 EB C5 01 7B 19 B3 42 12 DA 92 ED 00 0B B5 EE 40 0B F1 EE 10 FA 0B D0 20 EE 09 0B 6D 1C 82 ED 00 8B 08 32 81 ED 00 0B 08 31 04 2D EA DB 04 E0 08 EB C5 03 08 25 83 ED 00 8B 9D ED 04 0B B5 EE 40 0B F1 EE 10 FA 33 D0 02 A9 68 46 8D ED 02 0B ?? ?? ?? ?? 1A 21 02 A8 ?? ?? ?? ?? BD F9 00 10 02 A8 ?? ?? ?? ?? 9D ED 02 0B 31 46 20 46 ?? ?? ?? ?? 9D ED 04 1B 9D ED 02 0B 31 46 20 46 31 EE 40 0B ?? ?? ?? ?? 01 22 01 2D 0D DD 06 AB 93 ED 00 0B B5 EE 40 0B 03 ED 02 0B F1 EE 10 FA 03 D0 52 1C 08 33 AA 42 F2 DB 7F 1C 6D 1E B7 42 A2 DB 20 46 0D B0 ?? ?? ?? ?? BD EC 04 8B BD E8 F0 8B 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_6_0 {
	meta:
		name = "_dxp_mulh"
		size = 324
		refs = "000c __security_push_cookie 0030 _dtest 0040 _fperrraise 00cc _dunscale 00d4 _d_int 00de _dscale 00ea _dxp_addh 0130 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 04 8B ?? ?? ?? ?? 8D B0 0E 46 9F ED 49 8B 00 2E B0 EE 40 9B 04 46 1F DD 90 ED 00 2B 04 A8 22 EE 00 2B 8D ED 04 2B ?? ?? ?? ?? 05 46 00 2D 11 DB 02 2D 02 D1 01 20 ?? ?? ?? ?? 9D ED 04 0B 00 2D 84 ED 00 0B 6D DD 01 2E 6B DD 9F ED 39 0B 84 ED 02 0B 66 E0 84 ED 00 8B 01 25 00 27 00 2E 60 DD 0D F1 10 09 0D F1 10 08 04 2D 1F DA 7B 19 04 EB C3 02 09 EB C5 01 7B 19 B3 42 12 DA 92 ED 00 0B B5 EE 40 0B F1 EE 10 FA 0B D0 20 EE 09 0B 6D 1C 82 ED 00 8B 08 32 81 ED 00 0B 08 31 04 2D EA DB 04 E0 08 EB C5 03 08 25 83 ED 00 8B 9D ED 04 0B B5 EE 40 0B F1 EE 10 FA 33 D0 02 A9 68 46 8D ED 02 0B ?? ?? ?? ?? 1A 21 02 A8 ?? ?? ?? ?? BD F9 00 10 02 A8 ?? ?? ?? ?? 9D ED 02 0B 31 46 20 46 ?? ?? ?? ?? 9D ED 04 1B 9D ED 02 0B 31 46 20 46 31 EE 40 0B ?? ?? ?? ?? 01 22 01 2D 0D DD 06 AB 93 ED 00 0B B5 EE 40 0B 03 ED 02 0B F1 EE 10 FA 03 D0 52 1C 08 33 AA 42 F2 DB 7F 1C 6D 1E B7 42 A2 DB 20 46 0D B0 ?? ?? ?? ?? BD EC 04 8B BD E8 F0 8B 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_30_7_0 {
	meta:
		name = "_ldxp_mulx"
		size = 172
		refs = "003e memcpy 004a _ldxp_mulh 008a _ldxp_addx"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 0E 46 00 2E 1F 46 14 46 05 46 48 D0 00 2F 46 D0 92 ED 00 1B B5 EE 40 1B F1 EE 10 FA 39 D0 92 ED 02 0B B5 EE 40 0B F1 EE 10 FA 32 D0 DD F8 20 80 01 46 F2 00 40 46 ?? ?? ?? ?? 94 ED 00 0B 31 46 28 46 ?? ?? ?? ?? 4F F0 01 09 01 2F 27 DD 08 34 94 ED 00 0B B5 EE 40 0B F1 EE 10 FA 1F D0 F2 00 41 46 08 EB C6 00 ?? ?? ?? ?? 94 ED 00 0B 31 46 08 EB C6 00 ?? ?? ?? ?? 33 46 08 EB C6 02 31 46 28 46 ?? ?? ?? ?? 09 F1 01 09 08 34 B9 45 DF DB 05 E0 B0 EE 41 0B 31 46 28 46 ?? ?? ?? ?? 28 46 BD E8 F0 8B }
	condition:
		$1
}

rule file_164_7_0 {
	meta:
		name = "_dxp_mulx"
		size = 172
		refs = "003e memcpy 004a _dxp_mulh 008a _dxp_addx"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 0E 46 00 2E 1F 46 14 46 05 46 48 D0 00 2F 46 D0 92 ED 00 1B B5 EE 40 1B F1 EE 10 FA 39 D0 92 ED 02 0B B5 EE 40 0B F1 EE 10 FA 32 D0 DD F8 20 80 01 46 F2 00 40 46 ?? ?? ?? ?? 94 ED 00 0B 31 46 28 46 ?? ?? ?? ?? 4F F0 01 09 01 2F 27 DD 08 34 94 ED 00 0B B5 EE 40 0B F1 EE 10 FA 1F D0 F2 00 41 46 08 EB C6 00 ?? ?? ?? ?? 94 ED 00 0B 31 46 08 EB C6 00 ?? ?? ?? ?? 33 46 08 EB C6 02 31 46 28 46 ?? ?? ?? ?? 09 F1 01 09 08 34 B9 45 DF DB 05 E0 B0 EE 41 0B 31 46 28 46 ?? ?? ?? ?? 28 46 BD E8 F0 8B }
	condition:
		$1
}

rule file_30_8_0 {
	meta:
		name = "_ldxp_setw"
		size = 220
		refs = "0026 _ldunscale 0046 _ld_int 0050 _ldscale"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 84 B0 0D 46 00 2D B0 EE 40 8B 8D ED 02 0B 04 46 54 DD 01 2D 50 D0 02 A9 68 46 ?? ?? ?? ?? 00 28 48 D0 08 DD 9D ED 02 1B 9F ED 27 0B 84 ED 00 1B 84 ED 02 0B 42 E0 02 A8 1A 21 ?? ?? ?? ?? BD F9 00 10 02 A8 ?? ?? ?? ?? 9D ED 02 0B 02 2D 38 EE 40 8B 84 ED 00 0B 84 ED 02 8B 2F DD B5 EE 40 8B F1 EE 10 FA 21 D0 68 46 04 F1 08 01 ?? ?? ?? ?? 1A 21 04 F1 08 00 ?? ?? ?? ?? BD F9 00 10 04 F1 08 00 ?? ?? ?? ?? 94 ED 02 0B 03 2D 38 EE 40 0B 84 ED 04 0B 12 DD B5 EE 40 0B F1 EE 10 FA 0D D0 9F ED 09 0B 84 ED 06 0B 08 E0 9F ED 07 0B 84 ED 04 0B 03 E0 9D ED 02 8B 84 ED 00 8B 20 46 04 B0 BD EC 02 8B BD E8 30 88 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_164_8_0 {
	meta:
		name = "_dxp_setw"
		size = 220
		refs = "0026 _dunscale 0046 _d_int 0050 _dscale"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 84 B0 0D 46 00 2D B0 EE 40 8B 8D ED 02 0B 04 46 54 DD 01 2D 50 D0 02 A9 68 46 ?? ?? ?? ?? 00 28 48 D0 08 DD 9D ED 02 1B 9F ED 27 0B 84 ED 00 1B 84 ED 02 0B 42 E0 02 A8 1A 21 ?? ?? ?? ?? BD F9 00 10 02 A8 ?? ?? ?? ?? 9D ED 02 0B 02 2D 38 EE 40 8B 84 ED 00 0B 84 ED 02 8B 2F DD B5 EE 40 8B F1 EE 10 FA 21 D0 68 46 04 F1 08 01 ?? ?? ?? ?? 1A 21 04 F1 08 00 ?? ?? ?? ?? BD F9 00 10 04 F1 08 00 ?? ?? ?? ?? 94 ED 02 0B 03 2D 38 EE 40 0B 84 ED 04 0B 12 DD B5 EE 40 0B F1 EE 10 FA 0D D0 9F ED 09 0B 84 ED 06 0B 08 E0 9F ED 07 0B 84 ED 04 0B 03 E0 9D ED 02 8B 84 ED 00 8B 20 46 04 B0 BD EC 02 8B BD E8 30 88 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_30_9_0 {
	meta:
		name = "_ldxp_sqrtx"
		size = 256
		refs = "0018 _ldtest 0052 _ldxp_setw 006c memcpy 0078 _ldxp_mulh 0088 _ldxp_mulx 00a4 _ldxp_addh 00e2 _fperrraise 00fc _LNan_C"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 04 8B 82 B0 0C 46 00 2C 17 46 05 46 6B D0 ?? ?? ?? ?? 00 28 58 DA 95 ED 00 1B B5 EE C0 1B F1 EE 10 FA 58 D3 07 EB C4 06 06 EB C4 08 01 2C 03 DD 95 ED 02 0B 31 EE 00 1B B1 EE C1 1B B7 EE 00 0B 21 46 80 EE 01 0B 30 46 ?? ?? ?? ?? 4F F0 02 09 02 2C 30 DD BE EE 00 8B B7 EE 08 9B E2 00 31 46 38 46 ?? ?? ?? ?? B0 EE 48 0B 21 46 38 46 ?? ?? ?? ?? 23 46 2A 46 21 46 38 46 CD F8 00 80 ?? ?? ?? ?? 23 46 32 46 21 46 38 46 CD F8 00 80 ?? ?? ?? ?? B0 EE 49 0B 21 46 38 46 ?? ?? ?? ?? 23 46 3A 46 21 46 30 46 CD F8 00 80 ?? ?? ?? ?? 4F EA 49 09 A1 45 D2 DB 23 46 32 46 21 46 28 46 CD F8 00 80 ?? ?? ?? ?? 0E E0 95 ED 00 0B B5 EE C0 0B F1 EE 10 FA 07 D2 01 20 ?? ?? ?? ?? 05 4B 93 ED 00 0B 85 ED 00 0B 28 46 02 B0 BD EC 04 8B BD E8 F0 8B ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_9_0 {
	meta:
		name = "_dxp_sqrtx"
		size = 256
		refs = "0018 _dtest 0052 _dxp_setw 006c memcpy 0078 _dxp_mulh 0088 _dxp_mulx 00a4 _dxp_addh 00e2 _fperrraise 00fc _Nan_C"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 2D ED 04 8B 82 B0 0C 46 00 2C 17 46 05 46 6B D0 ?? ?? ?? ?? 00 28 58 DA 95 ED 00 1B B5 EE C0 1B F1 EE 10 FA 58 D3 07 EB C4 06 06 EB C4 08 01 2C 03 DD 95 ED 02 0B 31 EE 00 1B B1 EE C1 1B B7 EE 00 0B 21 46 80 EE 01 0B 30 46 ?? ?? ?? ?? 4F F0 02 09 02 2C 30 DD BE EE 00 8B B7 EE 08 9B E2 00 31 46 38 46 ?? ?? ?? ?? B0 EE 48 0B 21 46 38 46 ?? ?? ?? ?? 23 46 2A 46 21 46 38 46 CD F8 00 80 ?? ?? ?? ?? 23 46 32 46 21 46 38 46 CD F8 00 80 ?? ?? ?? ?? B0 EE 49 0B 21 46 38 46 ?? ?? ?? ?? 23 46 3A 46 21 46 30 46 CD F8 00 80 ?? ?? ?? ?? 4F EA 49 09 A1 45 D2 DB 23 46 32 46 21 46 28 46 CD F8 00 80 ?? ?? ?? ?? 0E E0 95 ED 00 0B B5 EE C0 0B F1 EE 10 FA 07 D2 01 20 ?? ?? ?? ?? 05 4B 93 ED 00 0B 85 ED 00 0B 28 46 02 B0 BD EC 04 8B BD E8 F0 8B ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_10_0 {
	meta:
		name = "_ldxp_subx"
		size = 62
		refs = "002c _ldxp_addh"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 1F 46 00 26 00 2F 15 46 88 46 04 46 10 DD 95 ED 00 0B B5 EE 40 0B F1 EE 10 FA 09 D0 B1 EE 40 0B 41 46 20 46 ?? ?? ?? ?? 76 1C 08 35 BE 42 EE DB 20 46 BD E8 F8 89 }
	condition:
		$1
}

rule file_164_10_0 {
	meta:
		name = "_dxp_subx"
		size = 62
		refs = "002c _dxp_addh"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 1F 46 00 26 00 2F 15 46 88 46 04 46 10 DD 95 ED 00 0B B5 EE 40 0B F1 EE 10 FA 09 D0 B1 EE 40 0B 41 46 20 46 ?? ?? ?? ?? 76 1C 08 35 BE 42 EE DB 20 46 BD E8 F8 89 }
	condition:
		$1
}

rule file_30_11_0 {
	meta:
		name = "fmal"
		size = 400
		refs = "000c __security_push_cookie 003c _ldunscale 00be _ldscale 00ca _ldxp_setw 00ee _ldxp_mulh 0120 _ldxp_addx 0134 _ldxp_getw 0170 _fperrraise 0180 __security_pop_cookie 018c _LNan_C"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 06 8B ?? ?? ?? ?? A3 B0 04 A9 0D F1 02 00 B0 EE 42 9B B0 EE 41 AB B0 EE 40 8B 8D ED 06 2B 8D ED 0C 1B 8D ED 0E 0B 8D ED 04 0B 8D ED 0A 1B 8D ED 02 2B ?? ?? ?? ?? 05 46 02 2D 00 F0 99 80 0A A9 01 A8 ?? ?? ?? ?? 04 46 02 2C 02 D1 B0 EE 4A 8B 8E E0 02 A9 68 46 ?? ?? ?? ?? 02 28 02 D1 B0 EE 49 8B 85 E0 01 2D 6B D0 01 2C 69 D0 01 28 F6 D0 00 2D 74 D0 00 2C 72 D0 00 28 70 D0 BD F9 02 20 BD F9 04 30 9C 18 BD F9 00 30 BD F8 36 20 1B 1B 19 B2 BD F8 3E 30 AD F8 00 10 5A 40 BD F8 1E 30 53 40 13 F4 00 4F 5A D0 11 F1 02 0F 57 DB 02 29 55 DC 02 A8 ?? ?? ?? ?? 9D ED 04 0B 12 A8 04 21 ?? ?? ?? ?? 9D ED 0A 0B 06 A8 02 21 ?? ?? ?? ?? 9D ED 02 0B 0E A8 02 21 ?? ?? ?? ?? 9D ED 06 0B 12 A8 04 21 ?? ?? ?? ?? 9D ED 08 0B B5 EE 40 0B F1 EE 10 FA 11 D0 9D ED 04 0B 1A A8 04 21 ?? ?? ?? ?? 9D ED 08 0B 1A A8 04 21 ?? ?? ?? ?? 1A AA 12 A8 04 23 04 21 ?? ?? ?? ?? 0E AA 12 A8 02 23 04 21 ?? ?? ?? ?? 04 21 12 A8 ?? ?? ?? ?? 02 A8 21 46 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 8B 17 E0 85 B1 7C B1 01 28 0A D1 BD F8 36 20 BD F8 3E 30 5A 40 BD F8 1E 30 53 40 13 F4 00 4F 02 D1 08 EE 0A 9B 7C E7 01 20 ?? ?? ?? ?? 05 4B 93 ED 00 8B B0 EE 48 0B 23 B0 ?? ?? ?? ?? BD EC 06 8B BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_11_0 {
	meta:
		name = "fma"
		size = 400
		refs = "000c __security_push_cookie 003c _dunscale 00be _dscale 00ca _dxp_setw 00ee _dxp_mulh 0120 _dxp_addx 0134 _dxp_getw 0170 _fperrraise 0180 __security_pop_cookie 018c _Nan_C"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 06 8B ?? ?? ?? ?? A3 B0 04 A9 0D F1 02 00 B0 EE 42 9B B0 EE 41 AB B0 EE 40 8B 8D ED 06 2B 8D ED 0C 1B 8D ED 0E 0B 8D ED 04 0B 8D ED 0A 1B 8D ED 02 2B ?? ?? ?? ?? 05 46 02 2D 00 F0 99 80 0A A9 01 A8 ?? ?? ?? ?? 04 46 02 2C 02 D1 B0 EE 4A 8B 8E E0 02 A9 68 46 ?? ?? ?? ?? 02 28 02 D1 B0 EE 49 8B 85 E0 01 2D 6B D0 01 2C 69 D0 01 28 F6 D0 00 2D 74 D0 00 2C 72 D0 00 28 70 D0 BD F9 02 20 BD F9 04 30 9C 18 BD F9 00 30 BD F8 36 20 1B 1B 19 B2 BD F8 3E 30 AD F8 00 10 5A 40 BD F8 1E 30 53 40 13 F4 00 4F 5A D0 11 F1 02 0F 57 DB 02 29 55 DC 02 A8 ?? ?? ?? ?? 9D ED 04 0B 12 A8 04 21 ?? ?? ?? ?? 9D ED 0A 0B 06 A8 02 21 ?? ?? ?? ?? 9D ED 02 0B 0E A8 02 21 ?? ?? ?? ?? 9D ED 06 0B 12 A8 04 21 ?? ?? ?? ?? 9D ED 08 0B B5 EE 40 0B F1 EE 10 FA 11 D0 9D ED 04 0B 1A A8 04 21 ?? ?? ?? ?? 9D ED 08 0B 1A A8 04 21 ?? ?? ?? ?? 1A AA 12 A8 04 23 04 21 ?? ?? ?? ?? 0E AA 12 A8 02 23 04 21 ?? ?? ?? ?? 04 21 12 A8 ?? ?? ?? ?? 02 A8 21 46 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 8B 17 E0 85 B1 7C B1 01 28 0A D1 BD F8 36 20 BD F8 3E 30 5A 40 BD F8 1E 30 53 40 13 F4 00 4F 02 D1 08 EE 0A 9B 7C E7 01 20 ?? ?? ?? ?? 05 4B 93 ED 00 8B B0 EE 48 0B 23 B0 ?? ?? ?? ?? BD EC 06 8B BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "??$common_creat@D@@YAHQBDH@Z"
		size = 42
		refs = "001c _sopen_s"
		altNames = "_creat"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0B 46 00 93 01 46 6F F0 00 04 40 23 02 A8 40 F2 02 32 02 94 ?? ?? ?? ?? 00 B9 02 9C 20 46 BD E8 1E 88 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "??$common_creat@_W@@YAHQB_WH@Z"
		size = 42
		refs = "001c _wsopen_s"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0B 46 00 93 01 46 6F F0 00 04 40 23 02 A8 40 F2 02 32 02 94 ?? ?? ?? ?? 00 B9 02 9C 20 46 BD E8 1E 88 }
	condition:
		$1
}

rule file_31_5_0 {
	meta:
		name = "_wcreat"
		size = 42
		refs = "001c _wsopen_s"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0B 46 00 93 01 46 6F F0 00 04 40 23 02 A8 40 F2 02 32 02 94 ?? ?? ?? ?? 00 B9 02 9C 20 46 BD E8 1E 88 }
	condition:
		$1
}

rule file_31_2_0 {
	meta:
		name = "??$tsopen_s@PAHABQBDHHABH@?$__crt_char_traits@D@@SAH$$QAPAHABQBD$$QAH2ABH@Z"
		size = 32
		refs = "001c _sopen_s"
		altNames = "??$tsopen_s@PAHABQBDABHABHH@?$__crt_char_traits@D@@SAH$$QAPAHABQBDABH2$$QAH@Z ??$tsopen_s@PAHABQBDHHH@?$__crt_char_traits@D@@SAH$$QAPAHABQBD$$QAH22@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 9C 1B 68 12 68 24 68 09 68 00 68 04 94 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_11_0 {
	meta:
		name = "??$ftprintf@PAU_iobuf@@PBDABQBDABQBDABI@?$__crt_char_traits@D@@SAH$$QAPAU_iobuf@@$$QAPBDABQBD2ABI@Z"
		size = 32
		refs = "001c fprintf"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 9C 1B 68 12 68 24 68 09 68 00 68 04 94 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_12_0 {
	meta:
		name = "??$ftprintf@PAU_iobuf@@PB_WABQB_WABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPAU_iobuf@@$$QAPB_WABQB_W2ABI@Z"
		size = 32
		refs = "001c fwprintf"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 9C 1B 68 12 68 24 68 09 68 00 68 04 94 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_491_13_0 {
	meta:
		name = "??$tsopen_s@PAHABQB_WABHABHH@?$__crt_char_traits@_W@@SAH$$QAPAHABQB_WABH2$$QAH@Z"
		size = 32
		refs = "001c _wsopen_s"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 9C 1B 68 12 68 24 68 09 68 00 68 04 94 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_3_3 {
	meta:
		name = "??$tsopen_s@PAHABQB_WHHABH@?$__crt_char_traits@_W@@SAH$$QAPAHABQB_W$$QAH2ABH@Z"
		size = 32
		refs = "001c _wsopen_s"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 9C 1B 68 12 68 24 68 09 68 00 68 04 94 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_607_13_3 {
	meta:
		name = "??$tsopen_s@PAHABQB_WHHH@?$__crt_char_traits@_W@@SAH$$QAPAHABQB_W$$QAH22@Z"
		size = 32
		refs = "001c _wsopen_s"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 9C 1B 68 12 68 24 68 09 68 00 68 04 94 01 B0 BD E8 10 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "iswctype"
		size = 92
		refs = "0054 __imp_GetStringTypeW 0058 _pwctype"
	strings:
		$1 = { 2D E9 3C 48 0D F1 10 0B 4F F6 FF 73 98 42 0D 46 01 D1 00 20 1C E0 B0 F5 80 7F 06 D2 0E 4B 1B 68 33 F8 10 30 03 EA 05 00 12 E0 0A 4C 00 23 AD F8 02 00 AD F8 00 30 24 68 6B 46 01 22 0D F1 02 01 01 20 A0 47 00 28 E4 D0 BD F8 00 30 03 EA 05 00 BD E8 3C 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "_cabsf"
		size = 36
		refs = "001c _hypotf"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B B0 EE 40 2B 8D ED 00 0B B7 EE C2 0B F7 EE C1 0B 8D ED 02 1B ?? ?? ?? ?? BD E8 0F 88 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_hypotf"
		size = 216
		refs = "0070 _controlfp_s 00ba _handle_errorf 00cc ??_C@_07HIGHJEEA@_hypotf?$AA@"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 85 B0 B7 EE C0 2A B7 EE E0 3A 53 EC 12 6B 52 EC 13 5B 23 F0 00 41 F0 EE 60 4A 0B 0D 22 F0 00 42 40 F2 FF 70 B0 EE 40 4A 83 42 B7 EE C0 0A B7 EE E4 2A 4F EA 12 54 0B D1 6F F3 1F 51 56 EA 01 03 0D D0 84 42 06 D0 24 EE A4 0A 04 EE 04 0A 35 E0 84 42 10 D1 6F F3 1F 52 55 EA 02 03 F3 D1 00 23 04 A8 00 22 00 21 04 93 ?? ?? ?? ?? 4F F0 FF 43 00 EE 10 3A 22 E0 20 EE 00 0B 9F ED 13 1B 02 EE 02 0B B1 EE C0 0B B4 EE C1 0B F1 EE 10 FA 13 DD 02 23 03 93 22 23 02 93 11 23 01 93 03 23 09 48 00 93 00 23 18 21 F0 EE 64 0A B0 EE 44 0A 4F F0 FF 42 ?? ?? ?? ?? 01 E0 B7 EE C0 0B 05 B0 BD E8 70 88 FE DE ?? ?? ?? ?? 00 00 00 E0 FF FF EF 47 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "infinityf_with_flags"
		size = 34
		refs = "0012 _controlfp_s"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 01 46 00 23 0A 46 68 46 00 93 ?? ?? ?? ?? 4F F0 FF 43 00 EE 10 3A BD E8 0C 88 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "llround"
		size = 104
		refs = "000e _dtest 0020 round 0044 __dtoi64 004c _fperrraise"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 1C D0 01 DD 02 28 16 DD 9D ED 00 0B ?? ?? ?? ?? 9F ED 0E 2B 8D ED 00 0B B4 EE C0 2B F1 EE 10 FA 09 D8 9F ED 08 2B B4 EE C2 0B F1 EE 10 FA 02 D8 ?? ?? ?? ?? 04 E0 01 20 ?? ?? ?? ?? 00 20 00 21 BD E8 0C 88 00 00 00 00 00 00 E0 43 00 00 00 00 00 00 E0 C3 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "llroundl"
		size = 104
		refs = "000e _ldtest 0020 roundl 0044 __dtoi64 004c _fperrraise"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 1C D0 01 DD 02 28 16 DD 9D ED 00 0B ?? ?? ?? ?? 9F ED 0E 2B 8D ED 00 0B B4 EE C0 2B F1 EE 10 FA 09 D8 9F ED 08 2B B4 EE C2 0B F1 EE 10 FA 02 D8 ?? ?? ?? ?? 04 E0 01 20 ?? ?? ?? ?? 00 20 00 21 BD E8 0C 88 00 00 00 00 00 00 E0 43 00 00 00 00 00 00 E0 C3 }
	condition:
		$1
}

rule file_37_4_0 {
	meta:
		name = "_strnicoll"
		size = 32
		refs = "000c _strnicmp 0014 _strnicoll_l 001c __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4B 1B 68 13 B9 ?? ?? ?? ?? 02 E0 00 23 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_5_0 {
	meta:
		name = "_strnicoll_l"
		size = 162
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0022 _errno 002a _invalid_parameter_noinfo 005a _strnicmp_l 0074 __acrt_CompareStringA"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 88 B0 0E 46 07 46 04 A8 19 46 15 46 ?? ?? ?? ?? 0D B9 00 24 33 E0 07 B1 46 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 44 28 E0 6F F0 00 44 A5 42 06 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 1D E0 05 9B D3 F8 A4 10 39 B9 05 AB 2A 46 31 46 38 46 ?? ?? ?? ?? 04 46 11 E0 1B 69 05 A8 41 F2 01 02 03 93 3B 46 02 95 01 96 00 95 ?? ?? ?? ?? 20 B9 ?? ?? ?? ?? 16 23 03 60 00 E0 84 1E 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 08 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_38_5_0 {
	meta:
		name = "_mbsnbicoll_l"
		size = 156
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0024 _errno 002c _invalid_parameter_noinfo 005a _strnicoll_l 0078 __acrt_CompareStringA"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 89 B0 0E 46 07 46 04 A8 19 46 98 46 15 46 ?? ?? ?? ?? 0D B9 00 24 2F E0 07 B1 46 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 44 24 E0 6F F0 00 44 A5 42 06 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 19 E0 06 9A 93 68 3B B9 43 46 2A 46 31 46 38 46 ?? ?? ?? ?? 04 46 0E E0 53 68 D2 F8 1C 12 05 A8 03 93 3B 46 41 F2 01 02 02 95 01 96 00 95 ?? ?? ?? ?? 00 B1 84 1E 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 09 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "?_mbstowcs_l_helper@@YAIPA_WPBDIPAU__crt_locale_pointers@@@Z"
		size = 300
		refs = "0024 _errno 002c _invalid_parameter_noinfo 003a ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 009a _isleadbyte_l 00d8 strlen 0124 __imp_MultiByteToWideChar 0128 __imp_GetLastError"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 87 B0 06 46 00 25 AA 46 17 46 88 46 1E B1 07 B9 80 E0 A6 F8 00 A0 B8 F1 00 0F 08 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 05 72 E0 02 A8 19 46 ?? ?? ?? ?? 03 98 00 2E D0 F8 A8 30 45 D0 6B B9 00 2F 5C D0 15 F8 08 30 26 F8 02 3B 15 F9 08 30 00 2B 54 D0 6D 1C BD 42 F4 D3 50 E0 2F 4C 80 68 6F F0 00 05 24 68 2B 46 42 46 09 21 01 97 00 96 A0 47 00 28 42 D1 29 4B 1B 68 98 47 7A 28 1D D1 B9 46 44 46 77 B1 20 78 A9 F1 01 09 50 B1 03 A9 ?? ?? ?? ?? 10 B1 63 78 83 B1 64 1C 64 1C B9 F1 00 0F F0 D1 03 98 A4 EB 08 03 1B 4C 80 68 42 46 24 68 01 21 01 97 00 96 A0 47 50 B9 ?? ?? ?? ?? 2A 23 03 60 A6 F8 00 A0 19 E0 23 B9 40 46 ?? ?? ?? ?? 05 46 13 E0 10 4C 80 68 6F F0 00 05 24 68 2B 46 42 46 09 21 CD F8 04 A0 CD F8 00 A0 A0 47 20 B9 ?? ?? ?? ?? 2A 23 03 60 00 E0 45 1E 9D F8 14 30 33 B1 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 28 46 07 B0 BD E8 F0 8F ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "_mbstowcs_s_l"
		size = 208
		refs = "001e _errno 0026 _invalid_parameter_noinfo 003c ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 006a ?_mbstowcs_l_helper@@YAIPA_WPBDIPAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 85 B0 0C 46 00 25 AA 46 99 46 16 46 07 46 0C B9 5E B1 00 E0 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 25 4C E0 A4 F8 00 A0 0F B1 C7 F8 00 A0 0F 99 68 46 ?? ?? ?? ?? DD F8 38 80 32 46 6F F0 00 43 B0 45 98 BF 42 46 9A 42 07 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 25 27 E0 01 AB 49 46 20 46 ?? ?? ?? ?? B0 F1 FF 3F 06 D1 0C B1 A4 F8 00 A0 ?? ?? ?? ?? 05 68 18 E0 40 1C A4 B1 B0 42 0E D9 B8 F1 FF 3F 09 D0 A4 F8 00 A0 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 25 07 E0 30 46 50 25 04 EB 40 03 23 F8 02 AC 07 B1 38 60 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 28 46 05 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_39_7_0 {
	meta:
		name = "mbstowcs"
		size = 36
		refs = "0012 ?_mbstowcs_l_helper@@YAIPA_WPBDIPAU__crt_locale_pointers@@@Z 001c __acrt_initial_locale_pointers 0020 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 1B 68 0B B9 03 4B 00 E0 00 23 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_8_0 {
	meta:
		name = "mbstowcs_s"
		size = 24
		refs = "0010 _mbstowcs_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 01 94 06 9C 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_227_19_0 {
	meta:
		name = "_Strftime"
		size = 24
		refs = "0010 _Strftime_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 01 94 06 9C 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_493_30_0 {
	meta:
		name = "_Wcsftime"
		size = 24
		refs = "0010 _Wcsftime_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 01 94 06 9C 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_661_21_0 {
	meta:
		name = "_ui64toa_s"
		size = 24
		refs = "0010 ??$common_xtox_s@_KD@@YAH_KQADII_N@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 01 94 06 9C 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_661_23_4 {
	meta:
		name = "_ui64tow_s"
		size = 24
		refs = "0010 ??$common_xtox_s@_K_W@@YAH_KQA_WII_N@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 01 94 06 9C 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_331_9_3 {
	meta:
		name = "wcstombs_s"
		size = 24
		refs = "0010 _wcstombs_s_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 01 94 06 9C 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "??$common_refill_and_read_nolock@D@@YAHV__crt_stdio_stream@@@Z"
		size = 492
		refs = "000e _errno 0016 _invalid_parameter_noinfo 00bc __acrt_stdio_allocate_buffer_nolock 00ca _fileno 00d2 _read 01e4 __badioinfo 01e8 __pioinfo"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 04 90 60 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 20 46 BD E8 30 08 5D F8 0C FB C3 68 BF F3 5B 8F 13 F4 00 5F 01 D0 01 23 00 E0 00 23 00 2B ED D0 04 9B DB 68 BF F3 5B 8F 4F F4 80 55 2B 42 01 D0 01 23 00 E0 00 23 00 2B E0 D1 04 9B DB 68 BF F3 5B 8F 13 F0 02 0F 01 D0 01 23 00 E0 00 23 00 2B BF F3 5B 8F 04 9B 03 F1 0C 02 0A D0 52 E8 00 0F 40 F0 10 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F C4 E7 52 E8 00 0F 40 F0 01 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 04 9B DB 68 BF F3 5B 8F 13 F4 98 6F 01 D0 01 23 00 E0 00 23 13 B9 04 98 ?? ?? ?? ?? 04 9A 53 68 13 60 04 9C 20 46 ?? ?? ?? ?? A2 69 61 68 ?? ?? ?? ?? 04 9B 6F F0 00 04 98 60 04 99 8A 68 1A B1 A2 42 01 D0 01 23 00 E0 00 23 B3 B9 0A B1 10 25 00 E0 08 25 BF F3 5B 8F 04 9B 03 F1 0C 02 52 E8 00 0F 40 EA 05 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 04 9B 00 22 9A 60 7F E7 CB 68 BF F3 5B 8F 13 F0 06 0F 01 D0 01 23 00 E0 00 23 93 BB 04 98 ?? ?? ?? ?? A0 42 17 D0 04 98 ?? ?? ?? ?? 10 F1 02 0F 11 D0 04 98 ?? ?? ?? ?? 04 46 04 98 ?? ?? ?? ?? 24 49 00 F0 3F 03 A4 11 03 EB 43 02 51 F8 24 30 03 EB 02 13 00 E0 1D 4B 93 F8 28 30 03 F0 82 03 82 2B 0E D1 BF F3 5B 8F 04 9B 03 F1 0C 02 52 E8 00 0F 40 F0 20 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 04 9A 93 69 B3 F5 00 7F 17 D1 D3 68 BF F3 5B 8F 13 F0 40 0F 01 D0 01 23 00 E0 00 23 63 B1 04 9B DB 68 BF F3 5B 8F 13 F4 80 7F 01 D0 01 23 00 E0 00 23 0B B9 04 9B 9D 61 04 9A 93 68 5B 1E 93 60 13 68 13 F8 01 4B 13 60 1D E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "??$common_refill_and_read_nolock@_W@@YAHV__crt_stdio_stream@@@Z"
		size = 544
		refs = "000e _errno 0016 _invalid_parameter_noinfo 00ba __acrt_stdio_allocate_buffer_nolock 00e4 _fileno 00ec _read 0218 __badioinfo 021c __pioinfo"
	strings:
		$1 = { 03 B4 2D E9 FC 48 0D F1 18 0B 08 90 58 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 4F F6 FF 70 BD E8 FC 08 5D F8 0C FB C3 68 BF F3 5B 8F 13 F4 00 5F 01 D0 01 23 00 E0 00 23 00 2B EE D0 08 9B DB 68 BF F3 5B 8F 4F F4 80 56 33 42 01 D0 01 23 00 E0 00 23 00 2B E1 D1 08 9B DB 68 BF F3 5B 8F 13 F0 02 0F 01 D0 01 23 00 E0 00 23 00 2B BF F3 5B 8F 08 9B 03 F1 0C 02 0A D0 52 E8 00 0F 40 F0 10 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F C5 E7 52 E8 00 0F 40 F0 01 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 08 9B DB 68 BF F3 5B 8F 13 F4 98 6F 01 D0 01 23 00 E0 00 23 13 B9 08 98 ?? ?? ?? ?? 08 9A 93 68 01 2B 03 D1 13 68 01 25 1F 78 06 E0 00 23 AD F8 00 30 9D F8 01 70 9D F8 00 50 53 68 13 60 08 9C 20 46 ?? ?? ?? ?? A2 69 61 68 ?? ?? ?? ?? 08 9B 98 60 08 99 8B 68 33 B1 01 2B 04 D0 B3 F1 FF 3F 01 D0 01 22 00 E0 00 22 B2 B9 0B B1 10 24 00 E0 08 24 BF F3 5B 8F 08 9B 03 F1 0C 02 52 E8 00 0F 40 EA 04 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 08 9B 00 22 9A 60 6F E7 CB 68 BF F3 5B 8F 13 F0 06 0F 01 D0 01 23 00 E0 00 23 9B BB 08 98 ?? ?? ?? ?? B0 F1 FF 3F 17 D0 08 98 ?? ?? ?? ?? 10 F1 02 0F 11 D0 08 98 ?? ?? ?? ?? 04 46 08 98 ?? ?? ?? ?? 29 49 00 F0 3F 03 A4 11 03 EB 43 02 51 F8 24 30 03 EB 02 13 00 E0 23 4B 93 F8 28 30 03 F0 82 03 82 2B 0E D1 BF F3 5B 8F 08 9B 03 F1 0C 02 52 E8 00 0F 40 F0 20 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 08 9A 93 69 B3 F5 00 7F 17 D1 D3 68 BF F3 5B 8F 13 F0 40 0F 01 D0 01 23 00 E0 00 23 63 B1 08 9B DB 68 BF F3 5B 8F 13 F4 80 7F 01 D0 01 23 00 E0 00 23 0B B9 08 9B 9E 61 08 9A 13 68 45 B1 1B 78 47 EA 03 20 93 68 5B 1E 93 60 13 68 5B 1C 05 E0 18 88 93 68 9B 1E 93 60 13 68 9B 1C 13 60 03 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_6_0 {
	meta:
		name = "?get_context_nolock@@YA?AUfilwbuf_context@?A0x763516dc@@V__crt_stdio_stream@@_W@Z"
		size = 50
	strings:
		$1 = { 03 B4 2D E9 0C 48 0D F1 08 0B 04 90 83 68 01 2B 07 D1 01 23 8D F8 00 30 03 68 1B 78 8D F8 01 30 02 E0 00 23 AD F8 00 30 00 98 BD E8 0C 08 5D F8 0C FB }
	condition:
		$1
}

rule file_40_7_0 {
	meta:
		name = "?get_context_nolock@@YAHV__crt_stdio_stream@@D@Z"
		size = 18
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 00 20 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_40_10_0 {
	meta:
		name = "?has_any_buffer@__crt_stdio_stream@@QBA_NXZ"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 DB 68 BF F3 5B 8F 13 F4 98 6F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_40_13_0 {
	meta:
		name = "?is_buffer_valid_nolock@@YA_NV__crt_stdio_stream@@D@Z"
		size = 34
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 90 83 68 23 B1 B3 F1 FF 3F 18 BF 01 20 00 D1 00 20 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_40_14_0 {
	meta:
		name = "?is_buffer_valid_nolock@@YA_NV__crt_stdio_stream@@_W@Z"
		size = 38
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 90 83 68 33 B1 01 2B 04 D0 B3 F1 FF 3F 18 BF 01 20 00 D1 00 20 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_40_18_0 {
	meta:
		name = "?read_character_nolock@@YAEV__crt_stdio_stream@@HD@Z"
		size = 34
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 02 90 83 68 5B 1E 83 60 02 9A 13 68 13 F8 01 0B 13 60 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_40_19_0 {
	meta:
		name = "?read_character_nolock@@YA_WV__crt_stdio_stream@@Ufilwbuf_context@?A0x763516dc@@_W@Z"
		size = 70
	strings:
		$1 = { 0F B4 2D E9 00 48 EB 46 9D F8 0C 30 02 90 00 2B 03 68 0B D0 1A 78 9D F8 0D 30 43 EA 02 21 83 68 5B 1E 83 60 02 9A 13 68 5B 1C 06 E0 19 88 83 68 9B 1E 83 60 02 9A 13 68 9B 1C 13 60 08 46 5D F8 04 BB 5D F8 14 FB }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "cexpl"
		size = 448
		refs = "0016 creall 002a cimagl 0034 _ldtest 00d0 cos 00e8 sin 00f8 _fperrraise 017c _ldexp 01a0 _LCbuild 01b0 _LNan_C 01bc _LZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 06 8B 8D B0 8D ED 0A 1B 8D ED 08 0B ?? ?? ?? ?? 9D ED 0A 1B B0 EE 40 2B 9D ED 08 0B 8D ED 06 2B ?? ?? ?? ?? 06 A8 8D ED 04 0B ?? ?? ?? ?? 04 46 04 A8 ?? ?? ?? ?? 02 2C 09 D1 9D ED 06 8B 00 28 8D ED 00 8B 40 F0 84 80 9D ED 04 9B 73 E0 02 28 17 D1 01 2C 12 D1 9D ED 06 8B B5 EE C0 8B F1 EE 10 FA 06 D2 9F ED 51 9B B0 EE 49 8B 8D ED 00 9B 61 E0 9D ED 04 9B 8D ED 00 8B 5C E0 9D ED 04 8B 64 E0 01 2C 5A D1 9D ED 06 AB B5 EE C0 AB F1 EE 10 FA 29 D2 01 28 12 D1 9D ED 04 0B 9F ED 43 9B B5 EE C0 0B B0 EE 49 8B F1 EE 10 FA 8D ED 00 9B 41 D2 3F 4B 93 ED 00 0B B1 EE 40 9B 3B E0 9D ED 04 8B B0 EE 48 0B ?? ?? ?? ?? 9F ED 37 9B B0 EE 40 1B B0 EE 48 0B 21 EE 09 8B 8D ED 00 8B ?? ?? ?? ?? 20 EE 09 9B 26 E0 01 28 0A D1 01 20 ?? ?? ?? ?? 2C 4B 9D ED 06 8B 93 ED 00 9B 8D ED 00 8B 19 E0 30 B9 9D ED 04 9B B0 EE 4A 8B 8D ED 00 AB 11 E0 9D ED 04 8B B0 EE 48 0B ?? ?? ?? ?? B0 EE 40 1B B0 EE 48 0B 21 EE 0A 8B 8D ED 00 8B ?? ?? ?? ?? 20 EE 0A 9B 8D ED 02 9B 28 E0 01 28 0C D1 01 20 ?? ?? ?? ?? 17 4B 93 ED 00 8B 8D ED 00 8B B0 EE 48 9B 8D ED 02 8B 19 E0 9D ED 06 1B 9D ED 04 0B 8D ED 00 1B 8D ED 02 1B ?? ?? ?? ?? 68 46 00 21 ?? ?? ?? ?? 9D ED 04 0B ?? ?? ?? ?? 02 A8 00 21 ?? ?? ?? ?? 9D ED 00 8B 9D ED 02 9B B0 EE 49 1B B0 EE 48 0B ?? ?? ?? ?? 0D B0 BD EC 06 8B BD E8 10 88 FE DE ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "cexp"
		size = 448
		refs = "0016 creal 002a cimag 0034 _dtest 00d0 cos 00e8 sin 00f8 _fperrraise 017c _dexp 01a0 _Cbuild 01b0 _Nan_C 01bc _Zero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 06 8B 8D B0 8D ED 0A 1B 8D ED 08 0B ?? ?? ?? ?? 9D ED 0A 1B B0 EE 40 2B 9D ED 08 0B 8D ED 06 2B ?? ?? ?? ?? 06 A8 8D ED 04 0B ?? ?? ?? ?? 04 46 04 A8 ?? ?? ?? ?? 02 2C 09 D1 9D ED 06 8B 00 28 8D ED 00 8B 40 F0 84 80 9D ED 04 9B 73 E0 02 28 17 D1 01 2C 12 D1 9D ED 06 8B B5 EE C0 8B F1 EE 10 FA 06 D2 9F ED 51 9B B0 EE 49 8B 8D ED 00 9B 61 E0 9D ED 04 9B 8D ED 00 8B 5C E0 9D ED 04 8B 64 E0 01 2C 5A D1 9D ED 06 AB B5 EE C0 AB F1 EE 10 FA 29 D2 01 28 12 D1 9D ED 04 0B 9F ED 43 9B B5 EE C0 0B B0 EE 49 8B F1 EE 10 FA 8D ED 00 9B 41 D2 3F 4B 93 ED 00 0B B1 EE 40 9B 3B E0 9D ED 04 8B B0 EE 48 0B ?? ?? ?? ?? 9F ED 37 9B B0 EE 40 1B B0 EE 48 0B 21 EE 09 8B 8D ED 00 8B ?? ?? ?? ?? 20 EE 09 9B 26 E0 01 28 0A D1 01 20 ?? ?? ?? ?? 2C 4B 9D ED 06 8B 93 ED 00 9B 8D ED 00 8B 19 E0 30 B9 9D ED 04 9B B0 EE 4A 8B 8D ED 00 AB 11 E0 9D ED 04 8B B0 EE 48 0B ?? ?? ?? ?? B0 EE 40 1B B0 EE 48 0B 21 EE 0A 8B 8D ED 00 8B ?? ?? ?? ?? 20 EE 0A 9B 8D ED 02 9B 28 E0 01 28 0C D1 01 20 ?? ?? ?? ?? 17 4B 93 ED 00 8B 8D ED 00 8B B0 EE 48 9B 8D ED 02 8B 19 E0 9D ED 06 1B 9D ED 04 0B 8D ED 00 1B 8D ED 02 1B ?? ?? ?? ?? 68 46 00 21 ?? ?? ?? ?? 9D ED 04 0B ?? ?? ?? ?? 02 A8 00 21 ?? ?? ?? ?? 9D ED 00 8B 9D ED 02 9B B0 EE 49 1B B0 EE 48 0B ?? ?? ?? ?? 0D B0 BD EC 06 8B BD E8 10 88 FE DE ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "wcscmp"
		size = 50
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 88 03 88 9B 1A 06 D1 40 1A 22 B1 31 F8 02 2F 43 5A 9B 1A F9 D0 00 2B 02 DA 6F F0 00 00 03 E0 C8 BF 01 20 D8 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__remainder_piby2f_inline"
		size = 600
		refs = "0008 __security_push_cookie 023e __security_pop_cookie 0250 ?pibits@?1??__remainder_piby2f_inline@@9@9"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 96 B0 99 46 40 F2 FF 33 C1 F3 0A 54 6F F3 1F 51 4F F4 80 1A E4 1A 00 23 41 EA 0A 01 63 F3 1C 00 C9 00 41 EA 50 77 88 49 01 92 84 FB 01 10 C1 10 01 EB D1 76 83 4D 06 EB C6 01 A4 EB 81 0E F1 1C 05 EB C1 04 CD E9 0A 33 D4 E9 00 32 A7 FB 03 13 07 FB 02 30 08 91 54 F8 04 1C 00 F0 0F 03 09 93 54 F8 08 3C A7 FB 03 23 07 FB 01 33 12 EB 10 12 43 F1 00 00 00 F0 0F 03 CD E9 06 23 54 E9 04 31 A7 FB 03 23 07 FB 01 33 12 EB 10 14 43 F1 00 00 05 EB C6 03 00 F0 0F 08 D3 E9 00 21 CD E9 04 48 A2 FB 07 23 01 FB 07 33 12 EB 10 12 43 F1 00 03 0F 27 3B 40 CE F1 23 01 CD E9 02 23 C1 F1 20 03 48 EA 02 10 00 FA 03 F3 24 FA 01 F2 1A 43 A1 F1 20 03 20 FA 03 F3 13 43 03 F0 07 03 13 F0 01 02 00 92 CE F1 24 02 4F F0 01 00 30 D0 5B 10 5B 1C 03 F0 03 03 C9 F8 00 30 A2 F1 20 03 01 21 99 40 01 23 93 40 6F F0 00 02 9B 18 4A 41 22 EA 08 05 00 2D 23 EA 04 04 4F F4 80 31 0E D8 01 D3 8C 42 0B D2 04 AE F6 E9 02 23 40 1C 27 EA 03 03 43 EA 04 15 D4 43 0D B9 8C 42 F4 D3 02 AB 03 EB C0 02 93 68 DF 43 D3 68 0F 22 22 EA 03 06 25 E0 5B 10 C9 F8 00 30 A2 F1 20 03 01 21 99 40 01 23 93 40 6F F0 00 02 9B 18 4A 41 02 EA 08 05 1C 40 00 2D 4F F4 80 31 0C D8 01 D3 8C 42 09 D2 04 AE 22 01 F6 E9 02 43 40 1C 52 EA 03 05 01 D1 8C 42 F6 D3 02 AB 03 EB C0 03 D3 E9 02 76 4F F4 80 41 00 22 8D 42 0A D8 09 D2 A3 0E 43 EA 85 15 92 1D A4 01 8D 42 F8 D3 01 D8 00 2C F5 D3 55 45 0A D8 09 D2 E3 0F 43 EA 45 05 52 1C 64 00 55 45 F8 D3 01 D8 00 2C F5 D3 00 EB C0 03 AE EB 83 03 9B 1A 34 33 40 F2 FF 31 58 18 C2 F1 24 01 C1 F1 20 03 06 FA 03 F3 27 FA 01 F2 1A 43 A1 F1 20 03 26 FA 03 F3 13 43 26 FA 01 F2 43 EA 04 01 42 EA 05 03 00 9A 6F F3 1F 53 43 EA 00 53 0A B1 43 F0 00 43 9F ED 07 0B 43 EC 11 1B 01 9B 21 EE 00 0B 83 ED 00 0B 16 B0 ?? ?? ?? ?? BD E8 F0 8F FE DE 18 2D 44 54 FB 21 F9 3F ?? ?? ?? ?? 39 8E E3 38 }
	condition:
		$1
}

rule file_44_2_0 {
	meta:
		name = "tanf"
		size = 620
		refs = "004c _controlfp_s 006e tanf_piby4 009e _handle_nanf 00c6 _handle_errorf 01ce __remainder_piby2f_inline 0250 ??_C@_04MHPLPEIA@tanf?$AA@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 88 B0 B7 EE C0 2A 95 4B B0 EE 40 8A 54 EC 12 0B 24 F0 00 41 99 42 2F D8 02 D3 8F 4B 98 42 2B D8 B1 F1 7E 5F 1A D8 19 D2 8A 4B 99 42 0B D8 0A D2 50 EA 01 03 19 D0 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? 11 E0 22 EE 02 0B 9F ED 80 1B 20 EE 02 0B 00 EE 01 2B B7 EE C2 8B 06 E0 B7 EE C8 0A 00 20 ?? ?? ?? ?? B7 EE C0 8B B0 EE 48 0A 08 B0 BD EC 02 8B BD E8 30 88 73 4A 04 EA 02 03 93 42 1E D1 6F F3 1F 54 50 EA 04 03 07 D0 18 EE 10 0A 00 21 ?? ?? ?? ?? B0 EE 40 8A E6 E7 21 23 02 93 01 22 08 23 DF ED 64 0A 66 48 03 92 00 92 64 4A 01 93 00 23 20 21 B0 EE 48 0A ?? ?? ?? ?? EA E7 E4 0F 01 D0 B1 EE 42 2B 9F ED 5B 0B B4 EE C0 2B F1 EE 10 FA 73 D2 57 4B 00 25 99 42 0E D8 02 D3 53 4B 98 42 0A D8 51 4B 99 42 05 D8 02 D3 4E 4B 98 42 01 D8 01 20 1D E0 02 20 1B E0 49 4B 99 42 0E D8 02 D3 46 4B 98 42 0A D8 44 4B 99 42 05 D8 02 D3 41 4B 98 42 01 D8 03 20 0B E0 04 20 09 E0 9F ED 3B 0B B6 EE 00 1B 02 EE 00 1B BD EE C1 0B 10 EE 10 0A 00 EE 10 0A 9F ED 33 1B B8 EE C0 5B 9F ED 2F 0B 25 EE 01 1B 25 EE 00 0B 32 EE 41 4B 53 EC 14 2B C3 F3 0A 53 D3 EB 11 53 65 F1 00 01 09 B9 0F 2B 26 D9 9F ED 24 0B B0 EE 44 2B 25 EE 00 3B 9F ED 1F 0B 34 EE 43 4B 25 EE 00 1B 32 EE 44 0B 30 EE 43 0B 31 EE 40 0B 09 B9 30 2B 11 D9 9F ED 15 0B B0 EE 44 2B 25 EE 00 3B 9F ED 10 0B 34 EE 43 4B 25 EE 00 1B 32 EE 44 0B 30 EE 43 0B 31 EE 40 0B 34 EE 40 0B 00 F0 03 03 06 E0 04 AB 06 AA ?? ?? ?? ?? 9D ED 06 0B 04 9B 00 2C 03 F0 01 00 3F F4 46 AF ?? ?? ?? ?? B1 EE 40 0B 42 E7 C1 49 20 25 9A 83 7B 39 00 00 00 2E 8A 19 A3 3B 73 70 03 2E 8A 19 A3 3B 00 00 60 1A 61 B4 D0 3D 31 63 62 1A 61 B4 D0 3D 00 00 40 54 FB 21 F9 3F 83 C8 C9 6D 30 5F E4 3F 75 A7 BB E9 BB FD 15 40 BB B2 CC BE 3A 46 1C 40 D2 21 33 7F 7C D9 02 40 5E 38 55 29 7A 6A 0F 40 00 00 00 00 80 84 1E 41 00 00 C0 FF ?? ?? ?? ?? 00 00 F0 7F 55 55 55 55 55 55 D5 3F 00 00 20 3F 18 2D 44 54 FB 21 E9 3F }
	condition:
		$1
}

rule file_44_3_0 {
	meta:
		name = "tanf_piby4"
		size = 120
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 1A 2B 20 EE 00 6B 9F ED 16 3B 9F ED 13 4B 26 EE 02 5B 9F ED 0F 2B 06 EE 43 4B 26 EE 00 3B 35 EE 42 2B 9F ED 09 5B 24 EE 03 3B 02 EE 06 5B 83 EE 05 2B 32 EE 00 1B 18 B1 BF EE 00 0B 80 EE 01 1B B0 EE 41 0B BD E8 00 88 2E 3A E7 A3 84 7E F2 3F 1B 51 B3 D7 66 72 E0 3F 17 CB 56 DA B0 A8 D8 3F AD 6A FD 6E BA 9D 91 3F D9 92 C6 03 90 E2 92 3F }
	condition:
		$1
}

rule file_44_4_0 {
	meta:
		name = "valf_with_flags"
		size = 44
		refs = "001a _controlfp_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 01 46 00 23 0A 46 68 46 B0 EE 40 8A 00 93 ?? ?? ?? ?? B0 EE 48 0A 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "clogl"
		size = 460
		refs = "0016 creall 002a cimagl 0034 _ldtest 007e atan2 00e0 _fperrraise 011c _ld_int 0164 log1pl 017e log 01aa _LCbuild 01b8 _LInf_C"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 06 8B 8C B0 8D ED 0A 1B 8D ED 08 0B ?? ?? ?? ?? 9D ED 0A 1B B0 EE 40 2B 9D ED 08 0B 8D ED 00 2B ?? ?? ?? ?? 68 46 8D ED 02 0B ?? ?? ?? ?? 05 46 02 A8 ?? ?? ?? ?? 04 46 02 2D 09 D1 01 2C 02 D1 9D ED 00 1B A9 E0 9D ED 00 0B B0 EE 40 1B A7 E0 02 2C 07 D1 01 2D 02 D1 9D ED 02 1B 9D E0 9D ED 02 0B F2 E7 9D ED 00 8B 9D ED 02 9B B0 EE 48 1B B0 EE 49 0B ?? ?? ?? ?? 01 2D B0 EE 40 AB 00 F0 8A 80 01 2C 00 F0 87 80 B5 EE C0 8B F1 EE 10 FA 03 D2 B1 EE 48 8B 8D ED 00 8B B5 EE C0 9B F1 EE 10 FA 03 D2 B1 EE 49 9B 8D ED 02 9B B4 EE C9 8B F1 EE 10 FA 09 D2 B0 EE 48 0B B0 EE 49 8B 8D ED 00 9B B0 EE 40 9B 8D ED 02 0B B5 EE 40 8B F1 EE 10 FA 0A D1 04 20 ?? ?? ?? ?? 34 4B B0 EE 4A 1B 93 ED 00 0B B1 EE 40 0B 5A E0 9F ED 33 0B B4 EE C0 8B F1 EE 10 FA 39 D8 9F ED 2E 0B B4 EE C9 0B F1 EE 10 FA 32 D8 04 A8 1A 21 8D ED 04 8B 8D ED 06 9B ?? ?? ?? ?? 06 A8 1A 21 ?? ?? ?? ?? 9D ED 00 0B 9D ED 04 1B 30 EE 41 2B 30 EE 01 0B 21 EE 01 3B 22 EE 00 4B 9D ED 02 0B 9D ED 06 2B B7 EE 00 1B 33 EE 41 3B 30 EE 42 1B 30 EE 02 0B 02 EE 02 3B 01 EE 00 4B 34 EE 03 0B ?? ?? ?? ?? B6 EE 00 2B B0 EE 4A 1B 20 EE 02 0B 19 E0 B0 EE 48 0B 89 EE 08 8B ?? ?? ?? ?? B0 EE 40 9B 28 EE 08 0B ?? ?? ?? ?? B6 EE 00 2B B0 EE 4A 1B 00 EE 02 9B B0 EE 49 0B 04 E0 B0 EE 4A 1B 04 4B 93 ED 00 0B ?? ?? ?? ?? 0C B0 BD EC 06 8B BD E8 30 88 ?? ?? ?? ?? 9A 99 99 99 99 99 D9 3F CD CC CC CC CC CC EC 3F }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "??$common_strdate@D@@YAPADQAD@Z"
		size = 26
		refs = "000c ??$common_strdate_s@D@@YAHQADI@Z"
		altNames = "_strdate"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 21 04 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "??$common_strdate@_W@@YAPA_WQA_W@Z"
		size = 26
		refs = "000c ??$common_strdate_s@_W@@YAHQA_WI@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 21 04 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_376_0_2 {
	meta:
		name = "??$common_strtime@D@@YAPADQAD@Z"
		size = 26
		refs = "000c ??$common_strtime_s@D@@YAHQADI@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 21 04 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_376_1_0 {
	meta:
		name = "??$common_strtime@_W@@YAPA_WQA_W@Z"
		size = 26
		refs = "000c ??$common_strtime_s@_W@@YAHQA_WI@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 21 04 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_376_4_0 {
	meta:
		name = "_strtime"
		size = 26
		refs = "000c ??$common_strtime_s@D@@YAHQADI@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 21 04 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_46_6_4 {
	meta:
		name = "_wstrdate"
		size = 26
		refs = "000c ??$common_strdate_s@_W@@YAHQA_WI@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 21 04 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_376_6_3 {
	meta:
		name = "_wstrtime"
		size = 26
		refs = "000c ??$common_strtime_s@_W@@YAHQA_WI@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 21 04 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "??$common_strdate_s@D@@YAHQADI@Z"
		size = 204
		refs = "0008 __security_push_cookie 0020 _errno 00ae _invalid_parameter_noinfo 00b6 __security_pop_cookie 00c8 __imp_GetLocalTime"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? 85 B0 06 46 00 2E 48 D0 00 29 46 D0 00 27 37 70 09 29 03 D2 ?? ?? ?? ?? 22 24 41 E0 27 4B 68 46 1B 68 98 47 BD F8 00 10 23 4B BD F8 02 00 BD F8 06 40 81 FB 03 32 53 11 64 22 03 FB 02 F3 CD 1A 1C 49 80 FB 01 32 92 10 02 F1 30 03 33 70 02 EB 82 03 A0 EB 43 03 30 33 2F 20 73 70 B0 70 84 FB 01 32 92 10 02 F1 30 03 F3 70 02 EB 82 03 A4 EB 43 03 30 33 33 71 85 FB 01 32 70 71 93 10 03 EB D3 72 02 F1 30 03 B3 71 02 EB 82 03 A5 EB 43 03 30 33 F3 71 37 72 00 24 05 E0 ?? ?? ?? ?? 16 24 04 60 ?? ?? ?? ?? 20 46 05 B0 ?? ?? ?? ?? BD E8 F0 88 FE DE 67 66 66 66 1F 85 EB 51 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "??$common_strdate_s@_W@@YAHQA_WI@Z"
		size = 204
		refs = "0008 __security_push_cookie 0020 _errno 00ae _invalid_parameter_noinfo 00b6 __security_pop_cookie 00c8 __imp_GetLocalTime"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? 85 B0 06 46 00 2E 48 D0 00 29 46 D0 00 27 37 80 09 29 03 D2 ?? ?? ?? ?? 22 24 41 E0 27 4B 68 46 1B 68 98 47 BD F8 00 10 23 4B BD F8 02 00 BD F8 06 40 81 FB 03 32 53 11 64 22 03 FB 02 F3 CD 1A 1C 49 80 FB 01 32 92 10 02 F1 30 03 33 80 02 EB 82 03 A0 EB 43 03 30 33 2F 20 73 80 B0 80 84 FB 01 32 92 10 02 F1 30 03 F3 80 02 EB 82 03 A4 EB 43 03 30 33 33 81 85 FB 01 32 70 81 93 10 03 EB D3 72 02 F1 30 03 B3 81 02 EB 82 03 A5 EB 43 03 30 33 F3 81 37 82 00 24 05 E0 ?? ?? ?? ?? 16 24 04 60 ?? ?? ?? ?? 20 46 05 B0 ?? ?? ?? ?? BD E8 F0 88 FE DE 67 66 66 66 1F 85 EB 51 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_4_0 {
	meta:
		name = "__ascii_stricmp"
		size = 48
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 10 F8 01 2B 11 F8 01 4B A2 F1 41 03 19 2B A4 F1 41 03 98 BF 20 32 19 2B 98 BF 20 34 0A B1 A2 42 EE D0 10 1B BD E8 18 88 }
	condition:
		$1
}

rule file_47_5_0 {
	meta:
		name = "_stricmp"
		size = 60
		refs = "000e _errno 0016 _invalid_parameter_noinfo 0028 __ascii_stricmp 002e _stricmp_l 0038 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 0C 4B 1B 68 7B B9 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 40 08 E0 00 29 F4 D0 BD E8 00 48 ?? ?? ?? ?? 00 22 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_276_5_0 {
	meta:
		name = "wcscoll"
		size = 60
		refs = "000e _errno 0016 _invalid_parameter_noinfo 0028 wcscmp 002e _wcscoll_l 0038 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 0C 4B 1B 68 7B B9 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 40 08 E0 00 29 F4 D0 BD E8 00 48 ?? ?? ?? ?? 00 22 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_6_0 {
	meta:
		name = "_stricmp_l"
		size = 118
		refs = "0012 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a _errno 0022 _invalid_parameter_noinfo 0038 __ascii_stricmp 0044 _tolower_l"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 85 B0 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 05 B1 44 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 40 17 E0 01 9B D3 F8 A8 30 23 B9 21 46 28 46 ?? ?? ?? ?? 0E E0 2E 1B 30 5D 01 A9 ?? ?? ?? ?? 05 46 14 F8 01 0B 01 A9 ?? ?? ?? ?? 0D B1 85 42 F2 D0 28 1A 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 70 88 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "nexttowardl"
		size = 346
		refs = "0012 _ldtest 00f0 _fperrraise"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 04 46 02 2C 47 F6 F0 75 69 D0 02 A8 ?? ?? ?? ?? 9D ED 02 0B 02 28 00 F0 90 80 9D ED 00 1B B4 EE 40 1B F1 EE 10 FA 00 F0 88 80 01 2C 10 D1 BD F8 06 30 03 F4 00 42 6B 1E 13 43 9A B2 4F F6 FF 73 AD F8 04 30 6F F0 00 03 00 93 AD F8 06 20 48 E0 7C B9 B4 EE C0 1B F1 EE 10 FA 38 BF 00 23 01 D3 4F F4 00 43 9A B2 01 23 AD F8 00 30 AD F8 06 20 37 E0 B4 EE C0 1B F1 EE 10 FA 04 D2 B5 EE C0 1B F1 EE 10 FA 09 DC B4 EE C1 0B F1 EE 10 FA 33 D2 B5 EE C0 1B F1 EE 10 FA 2E D2 BD F8 00 30 5B 1C 9B B2 AD F8 00 30 D3 B9 BD F8 02 30 5B 1C 9B B2 AD F8 02 30 9B B9 BD F8 04 30 5B 1C 9B B2 AD F8 04 30 63 B9 BD F8 06 30 5B 1C 9A B2 22 F4 00 43 AB 42 AD F8 06 20 04 D1 08 20 ?? ?? ?? ?? BD F8 06 20 9D ED 00 0B 2A 42 04 D1 10 20 ?? ?? ?? ?? 9D ED 00 0B BD E8 3F 88 BD F8 00 30 4F F6 FF 72 13 44 9B B2 AD F8 00 30 93 42 E8 D1 BD F8 02 30 13 44 9B B2 AD F8 02 30 93 42 E0 D1 BD F8 04 30 13 44 9B B2 AD F8 04 30 93 42 D8 D1 BD F8 06 30 13 44 9A B2 AD F8 06 20 D3 E7 8D ED 00 0B BD F8 06 20 D0 E7 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "nexttoward"
		size = 346
		refs = "0012 _dtest 0022 _ldtest 00f0 _fperrraise"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 04 46 02 2C 47 F6 F0 75 69 D0 02 A8 ?? ?? ?? ?? 9D ED 02 0B 02 28 00 F0 90 80 9D ED 00 1B B4 EE 40 1B F1 EE 10 FA 00 F0 88 80 01 2C 10 D1 BD F8 06 30 03 F4 00 42 6B 1E 13 43 9A B2 4F F6 FF 73 AD F8 04 30 6F F0 00 03 00 93 AD F8 06 20 48 E0 7C B9 B4 EE C0 1B F1 EE 10 FA 38 BF 00 23 01 D3 4F F4 00 43 9A B2 01 23 AD F8 00 30 AD F8 06 20 37 E0 B4 EE C0 1B F1 EE 10 FA 04 D2 B5 EE C0 1B F1 EE 10 FA 09 DC B4 EE C1 0B F1 EE 10 FA 33 D2 B5 EE C0 1B F1 EE 10 FA 2E D2 BD F8 00 30 5B 1C 9B B2 AD F8 00 30 D3 B9 BD F8 02 30 5B 1C 9B B2 AD F8 02 30 9B B9 BD F8 04 30 5B 1C 9B B2 AD F8 04 30 63 B9 BD F8 06 30 5B 1C 9A B2 22 F4 00 43 AB 42 AD F8 06 20 04 D1 08 20 ?? ?? ?? ?? BD F8 06 20 9D ED 00 0B 2A 42 04 D1 10 20 ?? ?? ?? ?? 9D ED 00 0B BD E8 3F 88 BD F8 00 30 4F F6 FF 72 13 44 9B B2 AD F8 00 30 93 42 E8 D1 BD F8 02 30 13 44 9B B2 AD F8 02 30 93 42 E0 D1 BD F8 04 30 13 44 9B B2 AD F8 04 30 93 42 D8 D1 BD F8 06 30 13 44 9A B2 AD F8 06 20 D3 E7 8D ED 00 0B BD F8 06 20 D0 E7 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "_get_printf_count_output"
		size = 40
		refs = "0020 ?enable_percent_n@@3IA 0024 __security_cookie"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4B 1B 68 43 F0 01 02 04 4B 1B 68 93 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_1_0 {
	meta:
		name = "_set_printf_count_output"
		size = 56
		refs = "0030 ?enable_percent_n@@3IA 0034 __security_cookie"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4B 09 4A 04 46 1B 68 43 F0 01 01 13 68 8B 42 08 BF 01 20 18 BF 00 20 0C B1 11 60 01 E0 00 23 13 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_7_0 {
	meta:
		name = "??$common_expand_argv_wildcards@D@@YAHQAPADQAPAPAD@Z"
		size = 334
		refs = "0012 _errno 001a _invalid_parameter_noinfo 0046 strpbrk 0056 ??$copy_and_add_argument_to_buffer@D@@YAHQBD0IAAV?$argument_list@D@?A0x5f5c8891@@@Z 005e ??$expand_argument_wildcards@D@@YAHQAD0AAV?$argument_list@D@?A0x5f5c8891@@@Z 009a strlen 00b6 __acrt_allocate_buffer_for_argv 00ec strncpy_s 010a _free_base 0148 _invoke_watson"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 87 B0 89 46 03 91 07 46 39 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 26 89 E0 00 23 C9 F8 00 30 06 93 3B 68 00 24 00 25 CD E9 04 45 EB B1 43 F6 2A 74 38 68 02 A9 AD F8 08 40 8D F8 0A 50 ?? ?? ?? ?? 01 46 38 68 29 B9 04 AB 00 22 00 21 ?? ?? ?? ?? 02 E0 04 AA ?? ?? ?? ?? 06 46 8E B9 57 F8 04 3F 00 2B E5 D1 DD E9 04 45 2A 1B 93 10 03 F1 01 08 D3 1C 00 27 AC 42 4F F0 00 0A 04 D8 9E 08 03 E0 DD E9 04 45 3E E0 00 26 6E B1 A1 46 59 F8 04 0B ?? ?? ?? ?? 00 EB 0A 03 7F 1C 03 F1 01 0A B7 42 F4 D1 DD F8 0C 90 01 22 51 46 40 46 ?? ?? ?? ?? 06 46 16 B9 6F F0 00 06 22 E0 06 EB 88 03 03 93 98 46 27 46 AC 42 17 D0 38 68 ?? ?? ?? ?? 03 9B 42 1C 02 92 A3 EB 08 03 03 EB 0A 01 13 46 3A 68 40 46 ?? ?? ?? ?? 28 BB 33 1B 43 F8 07 80 02 9B 3F 1D AF 42 98 44 E7 D1 00 20 C9 F8 00 60 00 26 ?? ?? ?? ?? 2B 1B DB 1C 00 27 AC 42 98 BF 9D 08 88 BF 00 25 A0 46 35 B1 58 F8 04 0B ?? ?? ?? ?? 7F 1C AF 42 F8 D1 20 46 ?? ?? ?? ?? 30 46 07 B0 BD E8 F0 8F 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_50_8_0 {
	meta:
		name = "??$common_expand_argv_wildcards@_W@@YAHQAPA_WQAPAPA_W@Z"
		size = 344
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 0046 wcspbrk 0056 ??$copy_and_add_argument_to_buffer@_W@@YAHQB_W0IAAV?$argument_list@_W@?A0x5f5c8891@@@Z 005e ??$expand_argument_wildcards@_W@@YAHQA_W0AAV?$argument_list@_W@?A0x5f5c8891@@@Z 009a wcslen 00b6 __acrt_allocate_buffer_for_argv 00ec wcsncpy_s 010c _free_base 013c __security_pop_cookie 014e _invoke_watson"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8A B0 02 91 89 46 07 46 39 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 26 88 E0 00 23 C9 F8 00 30 06 93 3B 68 00 24 00 25 CD E9 04 45 DB B1 46 4C 38 68 08 A9 08 94 AD F8 24 50 ?? ?? ?? ?? 01 46 38 68 29 B9 04 AB 00 22 00 21 ?? ?? ?? ?? 02 E0 04 AA ?? ?? ?? ?? 06 46 8E B9 57 F8 04 3F 00 2B E6 D1 DD E9 04 45 2A 1B 93 10 03 F1 01 08 D3 1C 00 27 AC 42 4F F0 00 0A 04 D8 9E 08 03 E0 DD E9 04 45 3F E0 00 26 6E B1 A1 46 59 F8 04 0B ?? ?? ?? ?? 00 EB 0A 03 7F 1C 03 F1 01 0A B7 42 F4 D1 DD F8 08 90 02 22 51 46 40 46 ?? ?? ?? ?? 06 46 16 B9 6F F0 00 06 23 E0 06 EB 88 03 02 93 98 46 27 46 AC 42 18 D0 38 68 ?? ?? ?? ?? 02 9B 42 1C 08 92 A8 EB 03 03 AA EB 63 01 13 46 3A 68 40 46 ?? ?? ?? ?? 40 BB 33 1B 43 F8 07 80 08 9B 3F 1D AF 42 08 EB 43 08 E6 D1 00 20 C9 F8 00 60 00 26 ?? ?? ?? ?? 2B 1B DB 1C 00 27 AC 42 98 BF 9D 08 88 BF 00 25 A0 46 35 B1 58 F8 04 0B ?? ?? ?? ?? 7F 1C AF 42 F8 D1 20 46 ?? ?? ?? ?? 30 46 0A B0 ?? ?? ?? ?? BD E8 F0 8F 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE 2A 00 3F 00 }
	condition:
		$1
}

rule file_50_9_0 {
	meta:
		name = "??$copy_and_add_argument_to_buffer@D@@YAHQBD0IAAV?$argument_list@D@?A0x5f5c8891@@@Z"
		size = 236
		refs = "0010 strlen 002e _calloc_base 003c strncpy_s 006c _free_base 00a4 _recalloc_base 00d8 _invoke_watson"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 1D 46 17 46 8A 46 81 46 ?? ?? ?? ?? 00 F1 01 08 C7 F1 FF 34 A0 45 88 BF 0C 24 33 D8 08 EB 07 03 5C 1C 20 46 01 21 ?? ?? ?? ?? 06 46 37 B1 3B 46 52 46 21 46 ?? ?? ?? ?? 00 28 44 D1 E1 1B F0 19 43 46 4A 46 ?? ?? ?? ?? 00 28 43 D1 D5 E9 01 32 93 42 0E D1 28 68 C0 B9 04 21 04 20 ?? ?? ?? ?? 28 60 00 20 ?? ?? ?? ?? 2B 68 E3 B1 6B 60 10 33 AB 60 6B 68 1E 60 6B 68 1B 1D 6B 60 00 24 00 20 ?? ?? ?? ?? 20 46 BD E8 FE 8F 13 1A 9C 10 6F F0 00 43 9C 42 07 D8 67 00 39 46 04 22 ?? ?? ?? ?? 30 B9 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 0C 24 E6 E7 00 EB 84 03 C5 E9 00 03 00 EB 87 03 00 20 AB 60 ?? ?? ?? ?? D5 E7 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_50_10_0 {
	meta:
		name = "??$copy_and_add_argument_to_buffer@_W@@YAHQB_W0IAAV?$argument_list@_W@?A0x5f5c8891@@@Z"
		size = 238
		refs = "0010 wcslen 002e _calloc_base 003c wcsncpy_s 006e _free_base 00a6 _recalloc_base 00da _invoke_watson"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 1D 46 17 46 8A 46 81 46 ?? ?? ?? ?? 00 F1 01 08 C7 F1 FF 34 A0 45 88 BF 0C 24 34 D8 08 EB 07 03 5C 1C 20 46 02 21 ?? ?? ?? ?? 06 46 37 B1 3B 46 52 46 21 46 ?? ?? ?? ?? 00 28 45 D1 E1 1B 06 EB 47 00 43 46 4A 46 ?? ?? ?? ?? 00 28 43 D1 D5 E9 01 32 93 42 0E D1 28 68 C0 B9 04 21 04 20 ?? ?? ?? ?? 28 60 00 20 ?? ?? ?? ?? 2B 68 E3 B1 6B 60 10 33 AB 60 6B 68 1E 60 6B 68 1B 1D 6B 60 00 24 00 20 ?? ?? ?? ?? 20 46 BD E8 FE 8F 13 1A 9C 10 6F F0 00 43 9C 42 07 D8 67 00 39 46 04 22 ?? ?? ?? ?? 30 B9 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 0C 24 E6 E7 00 EB 84 03 C5 E9 00 03 00 EB 87 03 00 20 AB 60 ?? ?? ?? ?? D5 E7 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_50_11_0 {
	meta:
		name = "??$expand_argument_wildcards@D@@YAHQAD0AAV?$argument_list@D@?A0x5f5c8891@@@Z"
		size = 320
		refs = "0008 __security_push_cookie 002e _mbsdec 004e ??$copy_and_add_argument_to_buffer@D@@YAHQBD0IAAV?$argument_list@D@?A0x5f5c8891@@@Z 007e memset 010c qsort 0126 __security_pop_cookie 0130 __imp_FindClose 0134 ?<lambda_invoker_none>@<lambda_86056e3c024bff449830248dc1621ed2>@@CAHPBX0@Z 0138 __imp_FindNextFileA 013c __imp_FindFirstFileExA"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? D5 B0 17 46 05 46 0F E0 91 F9 00 30 2F 2B 05 D0 5C 2B 03 D0 3A 2B 18 BF 00 23 00 D1 01 23 2B B9 28 46 ?? ?? ?? ?? 01 46 A9 42 ED D1 91 F9 00 20 3A 2A 0A D1 6B 1C 99 42 07 D0 00 22 00 21 3B 46 28 46 ?? ?? ?? ?? 04 46 65 E0 2F 2A 05 D0 5C 2A 03 D0 3A 2A 18 BF 00 23 00 D1 01 23 1B B1 4B 1B 03 F1 01 09 01 E0 4F F0 00 09 04 A8 4F F4 A0 72 00 21 ?? ?? ?? ?? 2E 4C 00 23 04 AA 24 68 00 21 28 46 01 93 00 93 A0 47 06 46 02 96 B0 F1 FF 3F 07 D1 00 22 00 21 3B 46 28 46 ?? ?? ?? ?? 04 46 32 E0 D7 E9 00 32 D3 1A 4F EA A3 08 9D F9 3C 20 9D F9 3D 30 2E 2A 07 D1 73 B1 2E 2A 04 D1 2E 2B 02 D1 9D F9 3E 30 3B B1 0F A8 3B 46 4A 46 29 46 ?? ?? ?? ?? 04 46 BC B9 14 4B 04 A9 30 46 1B 68 98 47 08 B1 02 9E E1 E7 D7 E9 00 23 99 1A B8 EB A1 0F 07 D0 0C 4B 02 EB 88 00 C8 EB A1 01 04 22 ?? ?? ?? ?? 02 9E 00 24 B6 F1 FF 3F 03 D0 05 4B 30 46 1B 68 98 47 20 46 55 B0 ?? ?? ?? ?? BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_12_0 {
	meta:
		name = "??$expand_argument_wildcards@_W@@YAHQA_W0AAV?$argument_list@_W@?A0x5f5c8891@@@Z"
		size = 316
		refs = "0008 __security_push_cookie 0046 ??$copy_and_add_argument_to_buffer@_W@@YAHQB_W0IAAV?$argument_list@_W@?A0x5f5c8891@@@Z 0078 memset 0106 qsort 0122 __security_pop_cookie 012c __imp_FindClose 0130 ?<lambda_invoker_none>@<lambda_601ce2808d07e6dd980fd6da59ab4158>@@CAHPBX0@Z 0134 __imp_FindNextFileW 0138 __imp_FindFirstFileExW"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? AD F5 19 7D 17 46 05 46 0B E0 0B 88 2F 2B 05 D0 5C 2B 03 D0 3A 2B 18 BF 00 23 00 D1 01 23 13 B9 89 1E A9 42 F1 D1 0A 88 3A 2A 0A D1 AB 1C 99 42 07 D0 00 22 00 21 3B 46 28 46 ?? ?? ?? ?? 04 46 66 E0 2F 2A 05 D0 5C 2A 03 D0 3A 2A 18 BF 00 23 00 D1 01 23 23 B1 4B 1B 5B 10 03 F1 01 09 01 E0 4F F0 00 09 04 A8 4F F4 14 72 00 21 ?? ?? ?? ?? 2E 4C 00 23 04 AA 24 68 00 21 28 46 01 93 00 93 A0 47 06 46 02 96 B0 F1 FF 3F 07 D1 00 22 00 21 3B 46 28 46 ?? ?? ?? ?? 04 46 32 E0 D7 E9 00 32 D3 1A 4F EA A3 08 BD F8 3C 20 BD F8 3E 30 2E 2A 07 D1 73 B1 2E 2A 04 D1 2E 2B 02 D1 BD F8 40 30 3B B1 0F A8 3B 46 4A 46 29 46 ?? ?? ?? ?? 04 46 BC B9 15 4B 04 A9 30 46 1B 68 98 47 08 B1 02 9E E1 E7 D7 E9 00 23 99 1A B8 EB A1 0F 07 D0 0D 4B 02 EB 88 00 C8 EB A1 01 04 22 ?? ?? ?? ?? 02 9E 00 24 B6 F1 FF 3F 03 D0 05 4B 30 46 1B 68 98 47 20 46 0D F5 19 7D ?? ?? ?? ?? BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_13_0 {
	meta:
		name = "??$find_first_file_ex@ABQADW4_FINDEX_INFO_LEVELS@@PAU_WIN32_FIND_DATAA@@W4_FINDEX_SEARCH_OPS@@$$TH@?$__crt_char_traits@D@@SAPAXABQAD$$QAW4_FINDEX_INFO_LEVELS@@$$QAPAU_WIN32_FIND_DATAA@@$$QAW4_FINDEX_SEARCH_OPS@@$$QA$$T$$QAH@Z"
		size = 44
		refs = "0028 __imp_FindFirstFileExA"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 07 9C 1B 68 12 68 24 68 09 68 00 68 01 94 06 9C 24 68 00 94 02 4C 24 68 A0 47 BD E8 1E 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_14_0 {
	meta:
		name = "??$find_first_file_ex@ABQA_WW4_FINDEX_INFO_LEVELS@@PAU_WIN32_FIND_DATAW@@W4_FINDEX_SEARCH_OPS@@$$TH@?$__crt_char_traits@_W@@SAPAXABQA_W$$QAW4_FINDEX_INFO_LEVELS@@$$QAPAU_WIN32_FIND_DATAW@@$$QAW4_FINDEX_SEARCH_OPS@@$$QA$$T$$QAH@Z"
		size = 44
		refs = "0028 __imp_FindFirstFileExW"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 07 9C 1B 68 12 68 24 68 09 68 00 68 01 94 06 9C 24 68 00 94 02 4C 24 68 A0 47 BD E8 1E 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_15_0 {
	meta:
		name = "??$find_next_file@PAXPAU_WIN32_FIND_DATAA@@@?$__crt_char_traits@D@@SAH$$QAPAX$$QAPAU_WIN32_FIND_DATAA@@@Z"
		size = 24
		refs = "0014 __imp_FindNextFileA"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 09 68 00 68 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_16_0 {
	meta:
		name = "??$find_next_file@PAXPAU_WIN32_FIND_DATAW@@@?$__crt_char_traits@_W@@SAH$$QAPAX$$QAPAU_WIN32_FIND_DATAW@@@Z"
		size = 24
		refs = "0014 __imp_FindNextFileW"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 09 68 00 68 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_307_4_0 {
	meta:
		name = "??$get_current_directory@AAKAAPAD@?$__crt_char_traits@D@@SAKAAKAAPAD@Z"
		size = 24
		refs = "0014 __imp_GetCurrentDirectoryA"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 09 68 00 68 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_307_5_2 {
	meta:
		name = "??$get_current_directory@AAKAAPA_W@?$__crt_char_traits@_W@@SAKAAKAAPA_W@Z"
		size = 24
		refs = "0014 __imp_GetCurrentDirectoryW"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 09 68 00 68 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_11_3 {
	meta:
		name = "??$get_temp_path@KABQA_W@?$__crt_char_traits@_W@@SAK$$QAKABQA_W@Z"
		size = 24
		refs = "0014 __imp_GetTempPathW"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 09 68 00 68 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_14_0 {
	meta:
		name = "??$set_environment_variable@ABQADQAD@?$__crt_char_traits@D@@SAHABQAD$$QBQAD@Z"
		size = 24
		refs = "0014 __imp_SetEnvironmentVariableA"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 09 68 00 68 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_15_3 {
	meta:
		name = "??$set_environment_variable@ABQA_WQA_W@?$__crt_char_traits@_W@@SAHABQA_W$$QBQA_W@Z"
		size = 24
		refs = "0014 __imp_SetEnvironmentVariableW"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 09 68 00 68 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_17_0 {
	meta:
		name = "??$tcslen@AAPAD@?$__crt_char_traits@D@@SAIAAPAD@Z"
		size = 16
		refs = "000c strlen"
		altNames = "??$tcslen@AAPBD@?$__crt_char_traits@D@@SAIAAPBD@Z ??$tcslen@ABQAD@?$__crt_char_traits@D@@SAIABQAD@Z ??$tcslen@ABQBD@?$__crt_char_traits@D@@SAIABQBD@Z ??$tcslen@PAD@?$__crt_char_traits@D@@SAI$$QAPAD@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_192_5_3 {
	meta:
		name = "??$getc_nolock@PAU_iobuf@@@?$__crt_char_traits@D@@SAH$$QAPAU_iobuf@@@Z"
		size = 16
		refs = "000c _getc_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_552_6_3 {
	meta:
		name = "??$getc_nolock@PAU_iobuf@@@?$__crt_char_traits@_W@@SAG$$QAPAU_iobuf@@@Z"
		size = 16
		refs = "000c _getwc_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_406_10_2 {
	meta:
		name = "??$tasctime@PAUtm@@@?$__crt_char_traits@D@@SAPAD$$QAPAUtm@@@Z"
		size = 16
		refs = "000c asctime"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_406_11_4 {
	meta:
		name = "??$tasctime@PAUtm@@@?$__crt_char_traits@_W@@SAPA_W$$QAPAUtm@@@Z"
		size = 16
		refs = "000c _wasctime"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_18_4 {
	meta:
		name = "??$tcslen@AAPA_W@?$__crt_char_traits@_W@@SAIAAPA_W@Z"
		size = 16
		refs = "000c wcslen"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_27_3 {
	meta:
		name = "??$tcslen@AAPB_W@?$__crt_char_traits@_W@@SAIAAPB_W@Z"
		size = 16
		refs = "000c wcslen"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_15_3 {
	meta:
		name = "??$tcslen@ABQA_W@?$__crt_char_traits@_W@@SAIABQA_W@Z"
		size = 16
		refs = "000c wcslen"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_685_27_4 {
	meta:
		name = "??$tcslen@ABQB_W@?$__crt_char_traits@_W@@SAIABQB_W@Z"
		size = 16
		refs = "000c wcslen"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_33_3 {
	meta:
		name = "??$tcslen@PA_W@?$__crt_char_traits@_W@@SAI$$QAPA_W@Z"
		size = 16
		refs = "000c wcslen"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_27_4 {
	meta:
		name = "??$tcspbrk@AAPADAAY02$$CBD@?$__crt_char_traits@D@@SAPADAAPADAAY02$$CBD@Z"
		size = 16
		refs = "000c strpbrk"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_28_0 {
	meta:
		name = "??$tcspbrk@AAPA_WAAY02$$CB_W@?$__crt_char_traits@_W@@SAPA_WAAPA_WAAY02$$CB_W@Z"
		size = 16
		refs = "000c wcspbrk"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_607_10_0 {
	meta:
		name = "??$time@PAJ@?$__crt_integer_traits@J@@SAJ$$QAPAJ@Z"
		size = 16
		refs = "000c _time32"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_607_11_4 {
	meta:
		name = "??$time@PA_J@?$__crt_integer_traits@_J@@SA_J$$QAPA_J@Z"
		size = 16
		refs = "000c _time64"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_67_2 {
	meta:
		name = "??$ungettch_nolock@ABH@?$__crt_char_traits@D@@SAHABH@Z"
		size = 16
		refs = "000c _ungetch_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_516_16_0 {
	meta:
		name = "?lock@__crt_stdio_stream@@QBAXXZ"
		size = 16
		refs = "000c _lock_file"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_58_3 {
	meta:
		name = "?unlock@__crt_stdio_stream@@QBAXXZ"
		size = 16
		refs = "000c _unlock_file"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_21_0 {
	meta:
		name = "??$tcsncpy_s@AAPADIAAPADABI@?$__crt_char_traits@D@@SAHAAPAD$$QAI0ABI@Z"
		size = 22
		refs = "0012 strncpy_s"
		altNames = "??$tcsncpy_s@AAPADIAAPBDABI@?$__crt_char_traits@D@@SAHAAPAD$$QAIAAPBDABI@Z ??$tcsncpy_s@AAPADIAAPBDH@?$__crt_char_traits@D@@SAHAAPAD$$QAIAAPBD$$QAH@Z ??$tcsncpy_s@PADABIABQBDABI@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD1@Z ??$tcsncpy_s@PADIABQBDABI@?$__crt_char_traits@D@@SAH$$QAPAD$$QAIABQBDABI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_546_4_3 {
	meta:
		name = "??$capture_argv@PAPADABQBDPAPADH@?$__crt_char_traits@D@@SAPAPAD$$QAPAPADABQBD0$$QAH@Z"
		size = 22
		refs = "0012 __acrt_capture_narrow_argv"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_598_5_3 {
	meta:
		name = "??$capture_argv@PAPADABQB_WPAPA_WH@?$__crt_char_traits@_W@@SAPAPA_W$$QAPAPADABQB_W$$QAPAPA_W$$QAH@Z"
		size = 22
		refs = "0012 __acrt_capture_wide_argv"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_15_4 {
	meta:
		name = "??$itot_s@ABIPADIH@?$__crt_char_traits@D@@SAHABI$$QAPAD$$QAI$$QAH@Z"
		size = 22
		refs = "0012 _itoa_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_16_0 {
	meta:
		name = "??$itot_s@ABIPA_WIH@?$__crt_char_traits@_W@@SAHABI$$QAPA_W$$QAI$$QAH@Z"
		size = 22
		refs = "0012 _itow_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_2_2 {
	meta:
		name = "??$message_box@$$TABQBDABQBDK@?$__crt_char_traits@D@@SAH$$QA$$TABQBD1$$QAK@Z"
		size = 22
		refs = "0012 __acrt_MessageBoxA"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_3_4 {
	meta:
		name = "??$message_box@$$TABQB_WABQB_WK@?$__crt_char_traits@_W@@SAH$$QA$$TABQB_W1$$QAK@Z"
		size = 22
		refs = "0012 __acrt_MessageBoxW"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_4_0 {
	meta:
		name = "??$message_box@PAUHWND__@@ABQBDABQBDABI@?$__crt_char_traits@D@@SAH$$QAPAUHWND__@@ABQBD1ABI@Z"
		size = 22
		refs = "0012 __acrt_MessageBoxA"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_5_3 {
	meta:
		name = "??$message_box@PAUHWND__@@ABQB_WABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPAUHWND__@@ABQB_W1ABI@Z"
		size = 22
		refs = "0012 __acrt_MessageBoxW"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_241_5_3 {
	meta:
		name = "??$open_file@ABQBDABQBDABHPAU_iobuf@@@?$__crt_char_traits@D@@SAPAU_iobuf@@ABQBD0ABH$$QAPAU1@@Z"
		size = 22
		refs = "0012 _openfile"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_512_7_3 {
	meta:
		name = "??$open_file@ABQB_WABQB_WABHPAU_iobuf@@@?$__crt_char_traits@_W@@SAPAU_iobuf@@ABQB_W0ABH$$QAPAU1@@Z"
		size = 22
		refs = "0012 _wopenfile"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_12_0 {
	meta:
		name = "??$pack_command_line_and_environment@ABQBQBDABQBQBDPAPADPAPAD@?$__crt_char_traits@D@@SAHABQBQBD0$$QAPAPAD1@Z"
		size = 22
		refs = "0012 __acrt_pack_narrow_command_line_and_environment"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_13_0 {
	meta:
		name = "??$pack_command_line_and_environment@ABQBQB_WABQBQB_WPAPA_WPAPA_W@?$__crt_char_traits@_W@@SAHABQBQB_W0$$QAPAPA_W1@Z"
		size = 22
		refs = "0012 __acrt_pack_wide_command_line_and_environment"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_20_3 {
	meta:
		name = "??$tcsncat_s@AAPADABIABQBDI@?$__crt_char_traits@D@@SAHAAPADABIABQBD$$QAI@Z"
		size = 22
		refs = "0012 strncat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_21_4 {
	meta:
		name = "??$tcsncat_s@AAPA_WABIABQB_WI@?$__crt_char_traits@_W@@SAHAAPA_WABIABQB_W$$QAI@Z"
		size = 22
		refs = "0012 wcsncat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_35_0 {
	meta:
		name = "??$tcsncat_s@ABQADABIAAPBDI@?$__crt_char_traits@D@@SAHABQADABIAAPBD$$QAI@Z"
		size = 22
		refs = "0012 strncat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_36_0 {
	meta:
		name = "??$tcsncat_s@ABQADABIABQBDABI@?$__crt_char_traits@D@@SAHABQADABIABQBD1@Z"
		size = 22
		refs = "0012 strncat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_37_3 {
	meta:
		name = "??$tcsncat_s@ABQADABIPBDI@?$__crt_char_traits@D@@SAHABQADABI$$QAPBD$$QAI@Z"
		size = 22
		refs = "0012 strncat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_38_3 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIAAPB_WI@?$__crt_char_traits@_W@@SAHABQA_WABIAAPB_W$$QAI@Z"
		size = 22
		refs = "0012 wcsncat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_39_4 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIABQB_WABI@?$__crt_char_traits@_W@@SAHABQA_WABIABQB_W1@Z"
		size = 22
		refs = "0012 wcsncat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_40_2 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIPB_WI@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPB_W$$QAI@Z"
		size = 22
		refs = "0012 wcsncat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_22_4 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPA_WABI@?$__crt_char_traits@_W@@SAHAAPA_W$$QAI0ABI@Z"
		size = 22
		refs = "0012 wcsncpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_324_14_2 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPB_WABI@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIAAPB_WABI@Z"
		size = 22
		refs = "0012 wcsncpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_324_15_0 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPB_WH@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIAAPB_W$$QAH@Z"
		size = 22
		refs = "0012 wcsncpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_25_0 {
	meta:
		name = "??$tcsncpy_s@PA_WABIABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W1@Z"
		size = 22
		refs = "0012 wcsncpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_26_0 {
	meta:
		name = "??$tcsncpy_s@PA_WIABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAIABQB_WABI@Z"
		size = 22
		refs = "0012 wcsncpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_24_4 {
	meta:
		name = "??$tspawnve@ABHAAPADABQBQBDABQBQBD@?$__crt_char_traits@D@@SAHABHAAPADABQBQBD2@Z"
		size = 22
		refs = "0012 _spawnve"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_25_4 {
	meta:
		name = "??$tspawnve@ABHAAPA_WABQBQB_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHAAPA_WABQBQB_W2@Z"
		size = 22
		refs = "0012 _wspawnve"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_598_8_0 {
	meta:
		name = "??$tspawnve@ABHABQBDABQAPADABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQAPADABQBQBD@Z"
		size = 22
		refs = "0012 _spawnve"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_26_0 {
	meta:
		name = "??$tspawnve@ABHABQBDABQBQBDABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQBQBD2@Z"
		size = 22
		refs = "0012 _spawnve"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_598_9_0 {
	meta:
		name = "??$tspawnve@ABHABQB_WABQAPA_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQAPA_WABQBQB_W@Z"
		size = 22
		refs = "0012 _wspawnve"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_27_0 {
	meta:
		name = "??$tspawnve@ABHABQB_WABQBQB_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQBQB_W2@Z"
		size = 22
		refs = "0012 _wspawnve"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_546_8_2 {
	meta:
		name = "??$tspawnvpe@ABHABQBDABQAPADABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQAPADABQBQBD@Z"
		size = 22
		refs = "0012 _spawnvpe"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_546_9_0 {
	meta:
		name = "??$tspawnvpe@ABHABQB_WABQAPA_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQAPA_WABQBQB_W@Z"
		size = 22
		refs = "0012 _wspawnvpe"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_36_3 {
	meta:
		name = "??$ultot_s@AAIABQADABIH@?$__crt_char_traits@D@@SAHAAIABQADABI$$QAH@Z"
		size = 22
		refs = "0012 _ultoa_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_37_4 {
	meta:
		name = "??$ultot_s@AAIABQA_WABIH@?$__crt_char_traits@_W@@SAHAAIABQA_WABI$$QAH@Z"
		size = 22
		refs = "0012 _ultow_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 1B 68 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_35_0 {
	meta:
		name = "??0?$argument_list@D@?A0x5f5c8891@@QAA@XZ"
		size = 18
		altNames = "??0?$argument_list@_W@?A0x5f5c8891@@QAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 00 33 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_50_37_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QAA@XZ"
		size = 36
		refs = "0020 __imp_FindClose"
		altNames = "?close@?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QAAXXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 20 68 6F F0 00 05 A8 42 03 D0 02 4B 1B 68 98 47 25 60 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_1_2 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAA@XZ"
		size = 36
		refs = "0020 __imp_CloseHandle"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 20 68 6F F0 00 05 A8 42 03 D0 02 4B 1B 68 98 47 25 60 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_2_4 {
	meta:
		name = "?close@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAAXXZ"
		size = 36
		refs = "0020 __imp_CloseHandle"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 20 68 6F F0 00 05 A8 42 03 D0 02 4B 1B 68 98 47 25 60 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_43_0 {
	meta:
		name = "??1?$argument_list@D@?A0x5f5c8891@@QAA@XZ"
		size = 38
		refs = "0012 _free_base"
		altNames = "??1?$argument_list@_W@?A0x5f5c8891@@QAA@XZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 25 68 03 E0 55 F8 04 0B ?? ?? ?? ?? 63 68 9D 42 F8 D1 20 68 BD E8 30 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_54_0 {
	meta:
		name = "?append@?$argument_list@D@?A0x5f5c8891@@QAAHQAD@Z"
		size = 126
		refs = "001c _calloc_base 0024 _free_base 0054 _recalloc_base"
		altNames = "?append@?$argument_list@_W@?A0x5f5c8891@@QAAHQA_W@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 04 46 D4 E9 01 32 0D 46 93 42 0E D1 20 68 A0 B9 04 21 04 20 ?? ?? ?? ?? 20 60 00 20 ?? ?? ?? ?? 23 68 C3 B1 63 60 10 33 A3 60 63 68 1D 60 63 68 1B 1D 63 60 00 20 BD E8 F0 88 13 1A 9E 10 6F F0 00 43 9E 42 07 D8 77 00 39 46 04 22 ?? ?? ?? ?? 30 B9 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 0C 20 EA E7 00 EB 86 03 C4 E9 00 03 00 EB 87 03 00 20 A3 60 ?? ?? ?? ?? D9 E7 }
	condition:
		$1
}

rule file_50_59_0 {
	meta:
		name = "?close@__crt_findfile_traits@@SA_NPAX@Z"
		size = 28
		refs = "0018 __imp_FindClose"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 98 47 08 B1 01 20 00 E0 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_70_3 {
	meta:
		name = "?close@__crt_handle_traits@@SA_NPAX@Z"
		size = 28
		refs = "0018 __imp_CloseHandle"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 98 47 08 B1 01 20 00 E0 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_23_3 {
	meta:
		name = "?close@__crt_hmodule_traits@@SA_NPAUHINSTANCE__@@@Z"
		size = 28
		refs = "0018 __imp_FreeLibrary"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 98 47 08 B1 01 20 00 E0 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_67_0 {
	meta:
		name = "?expand_if_necessary@?$argument_list@D@?A0x5f5c8891@@AAAHXZ"
		size = 118
		refs = "001e _calloc_base 0026 _free_base 004c _recalloc_base"
		altNames = "?expand_if_necessary@?$argument_list@_W@?A0x5f5c8891@@AAAHXZ"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 D4 E9 01 32 93 42 01 D0 00 24 2C E0 20 68 78 B9 04 21 04 20 ?? ?? ?? ?? 20 60 00 20 ?? ?? ?? ?? 23 68 0B B9 0C 24 1E E0 63 60 10 33 A3 60 EB E7 13 1A 9D 10 6F F0 00 43 9D 42 F3 D8 6E 00 31 46 04 22 ?? ?? ?? ?? 02 46 08 B9 0C 24 08 E0 00 EB 85 03 C4 E9 00 03 00 EB 86 03 A3 60 00 22 00 24 10 46 ?? ?? ?? ?? 20 46 BD E8 78 88 }
	condition:
		$1
}

rule file_50_84_0 {
	meta:
		name = "?size@?$argument_list@D@?A0x5f5c8891@@QBAIXZ"
		size = 18
		altNames = "?size@?$argument_list@_W@?A0x5f5c8891@@QBAIXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 D0 E9 00 32 D3 1A 98 10 BD E8 00 88 }
	condition:
		$1
}

rule file_50_90_0 {
	meta:
		name = "_invoke_watson_if_error"
		size = 38
		refs = "0020 _invoke_watson"
	strings:
		$1 = { 2D E9 7E 48 0D F1 18 0B 1C 46 15 46 0E 46 08 B9 BD E8 7E 88 09 98 08 9B 22 46 00 90 30 46 29 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "fmaxl"
		size = 88
		refs = "0012 _ldtest"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 02 28 02 D1 9D ED 02 0B 19 E0 02 A8 ?? ?? ?? ?? 9D ED 00 0B 02 28 12 D0 9D ED 02 1B B4 EE C1 0B F1 EE 10 FA 09 D3 B4 EE 41 0B F1 EE 10 FA 06 D1 BD F8 06 30 13 F4 00 4F 01 D0 B0 EE 41 0B BD E8 0F 88 }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "fmax"
		size = 88
		refs = "0012 _dtest"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 02 28 02 D1 9D ED 02 0B 19 E0 02 A8 ?? ?? ?? ?? 9D ED 00 0B 02 28 12 D0 9D ED 02 1B B4 EE C1 0B F1 EE 10 FA 09 D3 B4 EE 41 0B F1 EE 10 FA 06 D1 BD F8 06 30 13 F4 00 4F 01 D0 B0 EE 41 0B BD E8 0F 88 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__acrt_errno_from_os_error"
		size = 72
		refs = "0044 ?errtable@@3QBUerrentry@?A0x31fdb9ec@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0E 49 00 22 0C 46 54 F8 08 3B 98 42 10 D0 52 1C 2C 2A F8 D3 A0 F1 13 03 11 2B 98 BF 0D 20 0A D9 A0 F1 BC 03 0E 2B 98 BF 08 20 04 D9 16 20 02 E0 0B 1D 53 F8 32 00 BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "__acrt_errno_map_os_error"
		size = 34
		refs = "000a __doserrno 0012 __acrt_errno_from_os_error 0018 _errno"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 04 60 20 46 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 04 60 BD E8 18 88 }
	condition:
		$1
}

rule file_52_2_0 {
	meta:
		name = "__doserrno"
		size = 28
		refs = "0006 __acrt_getptd_noexit 0018 ?doserrno_no_memory@@3KA"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 08 B9 02 48 00 E0 14 30 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_3_0 {
	meta:
		name = "_errno"
		size = 28
		refs = "0006 __acrt_getptd_noexit 0018 ?errno_no_memory@@3HA"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 08 B9 02 48 00 E0 10 30 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_4_0 {
	meta:
		name = "_get_doserrno"
		size = 34
		refs = "000c _invalid_parameter_noinfo 0014 __doserrno"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 1C B9 ?? ?? ?? ?? 16 20 04 E0 ?? ?? ?? ?? 03 68 00 20 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_52_5_0 {
	meta:
		name = "_get_errno"
		size = 34
		refs = "000c _invalid_parameter_noinfo 0014 _errno"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 1C B9 ?? ?? ?? ?? 16 20 04 E0 ?? ?? ?? ?? 03 68 00 20 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_52_6_0 {
	meta:
		name = "_set_doserrno"
		size = 32
		refs = "000a __acrt_getptd_noexit 0014 __doserrno"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 08 B9 0C 20 03 E0 ?? ?? ?? ?? 04 60 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_52_7_0 {
	meta:
		name = "_set_errno"
		size = 32
		refs = "000a __acrt_getptd_noexit 0014 _errno"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 08 B9 0C 20 03 E0 ?? ?? ?? ?? 04 60 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "_controlfp_s"
		size = 80
		refs = "0020 _control87 0026 _errno 002e _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 10 4B 0D 46 22 F4 00 21 05 EA 01 02 1A 42 04 46 0D D0 24 B1 00 21 00 20 ?? ?? ?? ?? 20 60 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 08 E0 28 46 1C B1 ?? ?? ?? ?? 20 60 01 E0 ?? ?? ?? ?? 00 20 BD E8 30 88 E0 FC F0 FC }
	condition:
		$1
}

rule file_54_5_0 {
	meta:
		name = "_mbsnicmp_l"
		size = 288
		refs = "001a ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 002a _strnicmp 0034 _errno 003c _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 85 B0 17 46 0E 46 05 46 0F B9 00 20 81 E0 68 46 19 46 ?? ?? ?? ?? 02 98 83 68 2B B9 3A 46 31 46 28 46 ?? ?? ?? ?? 6A E0 05 B1 46 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 40 5F E0 4F F0 04 0E 4F F0 10 08 15 F8 01 1B 7F 1E 50 FA 81 F3 5B 7E 13 EA 0E 0F 18 D0 2B 78 0B B9 00 21 1B E0 43 EA 01 21 83 89 6D 1C 99 42 04 D3 C3 89 99 42 01 D8 03 8A 06 E0 43 8A 99 42 0D D3 83 8A 99 42 0A D8 C3 8A 0B 44 99 B2 06 E0 0A 18 53 7E 13 EA 08 0F 01 D0 92 F8 19 11 16 F8 01 2B 50 FA 82 F3 5B 7E 13 EA 0E 0F 18 D0 33 78 0B B9 00 22 1B E0 43 EA 02 22 83 89 76 1C 9A 42 04 D3 C3 89 9A 42 01 D8 03 8A 06 E0 43 8A 9A 42 0D D3 83 8A 9A 42 0A D8 C3 8A 13 44 9A B2 06 E0 14 18 63 7E 13 EA 08 0F 01 D0 94 F8 19 21 91 42 04 D1 09 B1 00 2F A9 D1 00 20 03 E0 6F F0 00 00 88 BF 01 20 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_55_5_0 {
	meta:
		name = "_mbsicoll_l"
		size = 134
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001c _errno 0024 _invalid_parameter_noinfo 0036 _stricoll_l 0056 __acrt_CompareStringA"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 89 B0 0C 46 05 46 04 A8 11 46 16 46 ?? ?? ?? ?? 05 B1 34 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 1C E0 06 9A 93 68 2B B9 32 46 21 46 28 46 ?? ?? ?? ?? 17 E0 53 68 D2 F8 1C 12 05 A8 03 93 6F F0 00 03 02 93 00 93 2B 46 41 F2 01 02 01 94 ?? ?? ?? ?? 30 B9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 40 00 E0 80 1E 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 09 B0 BD E8 70 88 }
	condition:
		$1
}

rule file_56_3_0 {
	meta:
		name = "?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z"
		size = 156
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0070 _errno 0098 __imp_WideCharToMultiByte"
	strings:
		$1 = { 0F B4 2D E9 70 48 0D F1 0C 0B 8B B0 0C 46 15 99 05 46 06 A8 16 46 ?? ?? ?? ?? 14 9B 00 22 03 B1 1A 60 07 98 D0 F8 A8 30 4B B9 BD F8 4C 30 FF 2B 1A D8 23 70 0D B1 01 23 2B 60 00 20 1D E0 00 94 15 4C 00 23 04 93 80 68 24 68 04 AB 03 93 02 92 01 23 13 AA 00 21 01 96 A0 47 28 B1 04 9B 1B B9 00 2D EA D0 28 60 E8 E7 15 B1 6F F0 00 03 2B 60 ?? ?? ?? ?? 2A 23 03 60 2A 20 9D F8 24 30 33 B1 06 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 0B B0 BD E8 70 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_5_0 {
	meta:
		name = "internal_wcsrtombs"
		size = 300
		refs = "0008 __security_push_cookie 001a _errno 0022 _invalid_parameter_noinfo 003a ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0050 ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 00dc memcpy 0124 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8A B0 1D 46 0F 46 03 95 91 46 06 46 47 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 79 E0 00 23 D7 F8 00 80 04 A8 00 21 02 93 00 24 ?? ?? ?? ?? 2E BB 05 AB 01 93 B8 F8 00 30 08 A9 02 A8 05 22 00 95 ?? ?? ?? ?? 02 9A 00 2A 13 DD 03 9F 08 AD 05 AE 53 19 13 F9 01 3C 7B B1 38 F8 02 3F 14 44 05 22 08 A9 02 A8 01 96 00 97 ?? ?? ?? ?? 02 9A 00 2A EE DC 6F F0 00 04 41 E0 A3 18 39 E0 B9 F1 00 0F 3A D0 05 AA 05 9B 5B 68 99 45 02 D2 0D F1 20 0A 00 E0 B2 46 B8 F8 00 30 01 92 05 22 51 46 02 A8 00 95 ?? ?? ?? ?? 02 9D 00 2D 23 DD 56 45 0F D0 A9 45 21 D3 65 B1 36 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 04 E0 2A 46 08 A9 30 46 ?? ?? ?? ?? 2E 44 16 F9 01 3C 43 B1 2C 44 B9 EB 05 09 03 9D 08 F1 02 08 05 AA CD D1 06 E0 00 23 3B 60 63 19 5C 1E 03 E0 6F F0 00 04 C7 F8 00 80 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 0A B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_56_6_0 {
	meta:
		name = "memcpy_s"
		size = 94
		refs = "0016 _errno 001e _invalid_parameter_noinfo 0034 memcpy 003e memset"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 1C 46 16 46 0D 46 0C B9 00 24 07 E0 48 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 24 20 46 BD E8 78 88 36 B1 A5 42 04 D3 22 46 31 46 ?? ?? ?? ?? EA E7 2A 46 00 21 ?? ?? ?? ?? 1E B9 ?? ?? ?? ?? 16 24 04 E0 A5 42 E8 D2 ?? ?? ?? ?? 22 24 04 60 ?? ?? ?? ?? E2 E7 }
	condition:
		$1
}

rule file_56_7_0 {
	meta:
		name = "wcrtomb"
		size = 44
		refs = "0022 wcrtomb_s"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 13 46 0C 46 01 46 6F F0 00 02 02 92 09 B9 00 22 00 E0 05 22 00 93 23 46 02 A8 ?? ?? ?? ?? 02 98 BD E8 1E 88 }
	condition:
		$1
}

rule file_56_8_0 {
	meta:
		name = "wcrtomb_s"
		size = 86
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 0042 ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 004e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 87 B0 04 46 0C 98 41 B9 3A B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 12 E0 6F F0 00 05 02 95 00 90 29 B9 00 22 01 92 04 A9 02 A8 05 22 02 E0 00 25 01 95 02 A8 ?? ?? ?? ?? 0C B1 02 9B 23 60 07 B0 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_56_10_0 {
	meta:
		name = "wcsrtombs_s"
		size = 142
		refs = "0026 _errno 002e _invalid_parameter_noinfo 004c internal_wcsrtombs"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 06 46 1F 46 15 46 0C 46 6F F0 00 09 0E B1 C0 F8 00 90 4F F0 00 08 0C B9 5D B1 00 E0 3D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 29 E0 84 F8 00 80 00 2F F3 D0 08 9A 09 9B 39 46 AA 42 88 BF 2A 46 20 46 ?? ?? ?? ?? 48 45 06 D1 0C B1 84 F8 00 80 ?? ?? ?? ?? 00 68 13 E0 40 1C 74 B1 A8 42 09 D9 84 F8 00 80 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 20 05 E0 03 19 03 F8 01 8C 06 B1 30 60 00 20 BD E8 F0 8B }
	condition:
		$1
}

rule file_56_11_0 {
	meta:
		name = "wctob"
		size = 72
		refs = "0008 __security_push_cookie 002c ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 0040 __security_pop_cookie"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? 86 B0 02 46 4F F6 FF 73 9A 42 6F F0 00 04 0F D0 00 23 01 93 00 93 13 46 05 22 04 A9 02 A8 02 94 ?? ?? ?? ?? 20 B9 02 9B 01 2B 01 D1 9D F9 10 40 20 46 06 B0 ?? ?? ?? ?? BD E8 10 88 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "??$?B$$A6AHPA_WKJ@Z@__crt_fast_encoded_nullptr_t@@QBAP6AHPA_WKJ@ZXZ"
		size = 36
		refs = "0020 __security_cookie"
		altNames = "??$?B$$A6AHI@Z@__crt_fast_encoded_nullptr_t@@QBAP6AHI@ZXZ ??$?B$$A6AXH@Z@__crt_fast_encoded_nullptr_t@@QBAP6AXH@ZXZ ??$?B$$A6AXPAXK0@Z@__crt_fast_encoded_nullptr_t@@QBAP6AXPAXK0@ZXZ ??$?B$$A6AXXZ@__crt_fast_encoded_nullptr_t@@QBAP6AXXZXZ ??$?BP6AXXZ@__crt_fast_encoded_nullptr_t@@QBAPAP6AXXZXZ ??$?BX@__crt_fast_encoded_nullptr_t@@QBAPAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 00 21 1A 68 02 F0 1F 03 C3 F1 20 03 61 FA 03 F3 83 EA 02 00 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_6_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@P6AHPA_WKJ@Z@@YAP6AHPA_WKJ@ZQ6AH0KJ@Z@Z"
		size = 28
		refs = "0018 __security_cookie"
		altNames = "??$__crt_fast_decode_pointer@P6AHI@Z@@YAP6AHI@ZQ6AHI@Z@Z ??$__crt_fast_decode_pointer@P6AHPAU_exception@@@Z@@YAP6AHPAU_exception@@@ZQ6AH0@Z@Z ??$__crt_fast_decode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z ??$__crt_fast_decode_pointer@P6AXPAXK0@Z@@YAP6AXPAXK0@ZQ6AX0K0@Z@Z ??$__crt_fast_decode_pointer@P6AXPB_W00II@Z@@YAP6AXPB_W00II@ZQ6AX000II@Z@Z ??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z ??$__crt_fast_decode_pointer@PAX@@YAPAXQAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 03 F0 1F 02 43 40 63 FA 02 F0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_8_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@P6AHPA_WKJ@Z@@YAP6AHPA_WKJ@ZQ6AH0KJ@Z@Z"
		size = 36
		refs = "0020 __security_cookie"
		altNames = "??$__crt_fast_encode_pointer@P6AHI@Z@@YAP6AHI@ZQ6AHI@Z@Z ??$__crt_fast_encode_pointer@P6AHPAU_exception@@@Z@@YAP6AHPAU_exception@@@ZQ6AH0@Z@Z ??$__crt_fast_encode_pointer@P6AHXZ@@YAP6AHXZQ6AHXZ@Z ??$__crt_fast_encode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z ??$__crt_fast_encode_pointer@P6AXPAXK0@Z@@YAP6AXPAXK0@ZQ6AX0K0@Z@Z ??$__crt_fast_encode_pointer@P6AXPB_W00II@Z@@YAP6AXPB_W00II@ZQ6AX000II@Z@Z ??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z ??$__crt_fast_encode_pointer@PAX@@YAPAXQAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 1A 68 02 F0 1F 03 C3 F1 20 03 60 FA 03 F3 83 EA 02 00 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_10_0 {
	meta:
		name = "??$__crt_interlocked_exchange_pointer@UHINSTANCE__@@PAU1@@@YAPAUHINSTANCE__@@PDSAU0@QAU0@@Z"
		size = 32
		altNames = "??$__crt_interlocked_exchange_pointer@UHINSTANCE__@@PAX@@YAPAUHINSTANCE__@@PDSAU0@QAX@Z ??$__crt_interlocked_exchange_pointer@XPAX@@YAPAXPDSAXQAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 BF F3 5B 8F 50 E8 00 2F 40 E8 00 13 00 2B F9 D1 10 46 BF F3 5B 8F BD E8 00 88 }
	condition:
		$1
}

rule file_57_26_0 {
	meta:
		name = "?enum_system_locales_ex_nolock@@YAHQ6AHPA_WKJ@Z@Z"
		size = 80
		refs = "0040 ?<lambda_invoker_none>@<lambda_7d4667135db055c8f06ea521d776c6b7>@@CAHPA_W@Z 0044 __imp_EnumSystemLocalesW 0048 ?static_enum_proc@?1??enum_system_locales_ex_nolock@@YAHQ6AHPA_WKJ@Z@Z@4P6AH0KJ@ZA 004c __security_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 10 4C 0F 4D 01 21 22 68 02 F0 1F 03 C3 F1 20 03 60 FA 03 F3 53 40 2B 60 08 4B 07 48 1B 68 98 47 22 68 00 21 02 F0 1F 03 C3 F1 20 03 61 FA 03 F3 53 40 2B 60 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_28_0 {
	meta:
		name = "?try_get_AppPolicyGetProcessTerminationMethod@@YAP6AJPAXPAW4AppPolicyProcessTerminationMethod@@@ZXZ"
		size = 32
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0CF@OJOFEIGO@AppPolicyGetProcessTerminationMe@ 001c ?candidate_modules@?1??try_get_AppPolicyGetProcessTerminationMethod@@YAP6AJPAXPAW4AppPolicyProcessTerminationMethod@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 1D 1C 20 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_29_0 {
	meta:
		name = "?try_get_AppPolicyGetShowDeveloperDiagnostic@@YAP6AJPAXPAW4AppPolicyShowDeveloperDiagnostic@@@ZXZ"
		size = 32
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0CE@OICFMIKE@AppPolicyGetShowDeveloperDiagnos@ 001c ?candidate_modules@?1??try_get_AppPolicyGetShowDeveloperDiagnostic@@YAP6AJPAXPAW4AppPolicyShowDeveloperDiagnostic@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 1D 1E 20 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_30_0 {
	meta:
		name = "?try_get_AppPolicyGetThreadInitializationType@@YAP6AJPAXPAW4AppPolicyThreadInitializationType@@@ZXZ"
		size = 32
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0CF@NNDFDCOC@AppPolicyGetThreadInitialization@ 001c ?candidate_modules@?1??try_get_AppPolicyGetThreadInitializationType@@YAP6AJPAXPAW4AppPolicyThreadInitializationType@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 1D 1D 20 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_31_0 {
	meta:
		name = "?try_get_AppPolicyGetWindowingModel@@YAP6AJPAXPAW4AppPolicyWindowingModel@@@ZXZ"
		size = 32
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BL@ODDJNEDA@AppPolicyGetWindowingModel?$AA@ 001c ?candidate_modules@?1??try_get_AppPolicyGetWindowingModel@@YAP6AJPAXPAW4AppPolicyWindowingModel@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 1D 1F 20 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_32_0 {
	meta:
		name = "?try_get_AreFileApisANSI@@YAP6AHXZXZ"
		size = 32
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BA@FHFNEAED@AreFileApisANSI?$AA@ 001c ?candidate_modules@?1??try_get_AreFileApisANSI@@YAP6AHXZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 1D 00 20 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_33_0 {
	meta:
		name = "?try_get_CompareStringEx@@YAP6AHPB_WK0H0HPAU_nlsversioninfo@@PAXJ@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BA@IHGNDAEB@CompareStringEx?$AA@ 001c ?candidate_modules@?1??try_get_CompareStringEx@@YAP6AHPB_WK0H0HPAU_nlsversioninfo@@PAXJ@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 01 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_34_0 {
	meta:
		name = "?try_get_EnumSystemLocalesEx@@YAP6AHP6AHPA_WKJ@ZKJPAX@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BE@LJANKFHF@EnumSystemLocalesEx?$AA@ 001c ?candidate_modules@?1??try_get_EnumSystemLocalesEx@@YAP6AHP6AHPA_WKJ@ZKJPAX@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 02 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_35_0 {
	meta:
		name = "?try_get_FlsAlloc@@YAP6AKP6AXPAX@Z@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_08KNHFBNJ@FlsAlloc?$AA@ 001c ?candidate_modules@?1??try_get_FlsAlloc@@YAP6AKP6AXPAX@Z@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 03 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_36_0 {
	meta:
		name = "?try_get_FlsFree@@YAP6AHK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_07PEJMOBNF@FlsFree?$AA@ 001c ?candidate_modules@?1??try_get_FlsFree@@YAP6AHK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 04 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_37_0 {
	meta:
		name = "?try_get_FlsGetValue@@YAP6APAXK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0M@GDNOONDI@FlsGetValue?$AA@ 001c ?candidate_modules@?1??try_get_FlsGetValue@@YAP6APAXK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 05 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_38_0 {
	meta:
		name = "?try_get_FlsSetValue@@YAP6AHKPAX@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0M@JCPCPOEF@FlsSetValue?$AA@ 001c ?candidate_modules@?1??try_get_FlsSetValue@@YAP6AHKPAX@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 06 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_39_0 {
	meta:
		name = "?try_get_GetActiveWindow@@YAP6APAUHWND__@@XZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 001c ?candidate_modules@?1??try_get_GetActiveWindow@@YAP6APAUHWND__@@XZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 07 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_40_0 {
	meta:
		name = "?try_get_GetDateFormatEx@@YAP6AHPB_WKPBU_SYSTEMTIME@@0PA_WH0@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BA@EPCJIIPD@GetDateFormatEx?$AA@ 001c ?candidate_modules@?1??try_get_GetDateFormatEx@@YAP6AHPB_WKPBU_SYSTEMTIME@@0PA_WH0@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 08 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_41_0 {
	meta:
		name = "?try_get_GetEnabledXStateFeatures@@YAP6A_KXZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BJ@DIBIJBHA@GetEnabledXStateFeatures?$AA@ 001c ?candidate_modules@?1??try_get_GetEnabledXStateFeatures@@YAP6A_KXZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 09 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_42_0 {
	meta:
		name = "?try_get_GetLastActivePopup@@YAP6APAUHWND__@@PAU1@@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 001c ?candidate_modules@?1??try_get_GetLastActivePopup@@YAP6APAUHWND__@@PAU2@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 0A 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_43_0 {
	meta:
		name = "?try_get_GetLocaleInfoEx@@YAP6AHPB_WKPA_WH@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BA@ONOKGCMP@GetLocaleInfoEx?$AA@ 001c ?candidate_modules@?1??try_get_GetLocaleInfoEx@@YAP6AHPB_WKPA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 0B 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_44_0 {
	meta:
		name = "?try_get_GetProcessWindowStation@@YAP6APAUHWINSTA__@@XZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 001c ?candidate_modules@?1??try_get_GetProcessWindowStation@@YAP6APAUHWINSTA__@@XZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 0C 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_45_0 {
	meta:
		name = "?try_get_GetSystemTimePreciseAsFileTime@@YAP6AXPAU_FILETIME@@@ZXZ"
		size = 32
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BP@FPNJPEJC@GetSystemTimePreciseAsFileTime?$AA@ 001c ?candidate_modules@?1??try_get_GetSystemTimePreciseAsFileTime@@YAP6AXPAU_FILETIME@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 1D 0D 20 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_46_0 {
	meta:
		name = "?try_get_GetTimeFormatEx@@YAP6AHPB_WKPBU_SYSTEMTIME@@0PA_WH@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BA@CIJJKCJJ@GetTimeFormatEx?$AA@ 001c ?candidate_modules@?1??try_get_GetTimeFormatEx@@YAP6AHPB_WKPBU_SYSTEMTIME@@0PA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 0E 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_47_0 {
	meta:
		name = "?try_get_GetUserDefaultLocaleName@@YAP6AHPA_WH@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BJ@PBCCBIPI@GetUserDefaultLocaleName?$AA@ 001c ?candidate_modules@?1??try_get_GetUserDefaultLocaleName@@YAP6AHPA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 0F 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_48_0 {
	meta:
		name = "?try_get_GetUserObjectInformationW@@YAP6AHPAXH0KPAK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BK@DEKFELLI@GetUserObjectInformationW?$AA@ 001c ?candidate_modules@?1??try_get_GetUserObjectInformationW@@YAP6AHPAXH0KPAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 10 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_49_0 {
	meta:
		name = "?try_get_GetXStateFeaturesMask@@YAP6AHPAU_CONTEXT@@PA_K@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BG@IKLDMBLM@GetXStateFeaturesMask?$AA@ 001c ?candidate_modules@?1??try_get_GetXStateFeaturesMask@@YAP6AHPAU_CONTEXT@@PA_K@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 11 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_50_0 {
	meta:
		name = "?try_get_InitializeCriticalSectionEx@@YAP6AHPAU_RTL_CRITICAL_SECTION@@KK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BM@HCFOFFN@InitializeCriticalSectionEx?$AA@ 001c ?candidate_modules@?1??try_get_InitializeCriticalSectionEx@@YAP6AHPAU_RTL_CRITICAL_SECTION@@KK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 12 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_51_0 {
	meta:
		name = "?try_get_IsValidLocaleName@@YAP6AHPB_W@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BC@CELBKLLA@IsValidLocaleName?$AA@ 001c ?candidate_modules@?1??try_get_IsValidLocaleName@@YAP6AHPB_W@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_52_0 {
	meta:
		name = "?try_get_LCIDToLocaleName@@YAP6AHKPA_WHK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BB@CDHDDLLP@LCIDToLocaleName?$AA@ 001c ?candidate_modules@?1??try_get_LCIDToLocaleName@@YAP6AHKPA_WHK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 15 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_53_0 {
	meta:
		name = "?try_get_LCMapStringEx@@YAP6AHPB_WK0HPA_WHPAU_nlsversioninfo@@PAXJ@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0O@KKBNKAPF@LCMapStringEx?$AA@ 001c ?candidate_modules@?1??try_get_LCMapStringEx@@YAP6AHPB_WK0HPA_WHPAU_nlsversioninfo@@PAXJ@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 14 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_54_0 {
	meta:
		name = "?try_get_LocaleNameToLCID@@YAP6AKPB_WK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BB@HBDEELFH@LocaleNameToLCID?$AA@ 001c ?candidate_modules@?1??try_get_LocaleNameToLCID@@YAP6AKPB_WK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 16 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_55_0 {
	meta:
		name = "?try_get_LocateXStateFeature@@YAP6APAXPAU_CONTEXT@@KPAK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BE@KINNKFDA@LocateXStateFeature?$AA@ 001c ?candidate_modules@?1??try_get_LocateXStateFeature@@YAP6APAXPAU_CONTEXT@@KPAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 17 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_56_0 {
	meta:
		name = "?try_get_MessageBoxA@@YAP6AHPAUHWND__@@PBD1I@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0M@CHKKJDAI@MessageBoxA?$AA@ 001c ?candidate_modules@?1??try_get_MessageBoxA@@YAP6AHPAUHWND__@@PBD1I@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 18 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_57_0 {
	meta:
		name = "?try_get_MessageBoxW@@YAP6AHPAUHWND__@@PB_W1I@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0M@DLDCCGNP@MessageBoxW?$AA@ 001c ?candidate_modules@?1??try_get_MessageBoxW@@YAP6AHPAUHWND__@@PB_W1I@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 19 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_58_0 {
	meta:
		name = "?try_get_RoInitialize@@YAP6AJW4RO_INIT_TYPE@@@ZXZ"
		size = 32
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0N@PPOMPGGK@RoInitialize?$AA@ 001c ?candidate_modules@?1??try_get_RoInitialize@@YAP6AJW4RO_INIT_TYPE@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 1D 1A 20 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_59_0 {
	meta:
		name = "?try_get_RoUninitialize@@YAP6AXXZXZ"
		size = 32
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0P@LLFHBIJD@RoUninitialize?$AA@ 001c ?candidate_modules@?1??try_get_RoUninitialize@@YAP6AXXZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 13 1D 1B 20 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_60_0 {
	meta:
		name = "?try_get_SetThreadStackGuarantee@@YAP6AHPAK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BI@BKLFFAPO@SetThreadStackGuarantee?$AA@ 001c ?candidate_modules@?1??try_get_SetThreadStackGuarantee@@YAP6AHPAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 20 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_61_0 {
	meta:
		name = "?try_get_SystemFunction036@@YAP6AEPAXK@ZXZ"
		size = 32
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0018 ??_C@_0BC@JEAENNKH@SystemFunction036?$AA@ 001c ?candidate_modules@?1??try_get_SystemFunction036@@YAP6AEPAXK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 4A 03 49 21 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_62_0 {
	meta:
		name = "?try_get_first_available_module@@YAPAUHINSTANCE__@@QBW4module_id@?A0x391cf84c@@0@Z"
		size = 244
		refs = "0060 wcsncmp 00d8 __imp_LoadLibraryExW 00dc ?module_names@?A0x391cf84c@@3QBQB_WB 00e0 ??_C@_1BA@IAIFMGEF@?$AAe?$AAx?$AAt?$AA?9?$AAm?$AAs?$AA?9?$AA?$AA@ 00e4 ??_C@_1BA@PFFKHIOG@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AA?$AA@ 00e8 __imp_GetLastError 00ec __imp_FreeLibrary 00f0 ?module_handles@@3PAPAUHINSTANCE__@@A"
	strings:
		$1 = { 2D E9 F8 4F 0D F1 20 0B 0F 46 05 46 BD 42 5E D0 32 4A DF F8 DC A0 DF F8 C0 E0 DF F8 D0 90 6F F0 00 01 55 F8 04 3B 5A F8 23 40 0A EB 83 08 BF F3 5B 8F 14 B1 8C 42 45 D0 43 E0 52 F8 23 60 DE F8 00 30 4F F4 00 62 30 46 00 21 98 47 04 46 3C BB 25 4B 1B 68 98 47 57 28 13 D1 22 49 07 22 30 46 ?? ?? ?? ?? 68 B1 1E 49 07 22 30 46 ?? ?? ?? ?? 38 B1 19 4B 00 22 00 21 1B 68 30 46 98 47 04 46 00 E0 00 24 64 B9 BF F3 5B 8F 6F F0 00 01 58 E8 00 2F 48 E8 00 13 00 2B F9 D1 BF F3 5B 8F 11 E0 BF F3 5B 8F 58 E8 00 2F 48 E8 00 43 00 2B F9 D1 BF F3 5B 8F 1A B1 D9 F8 00 30 20 46 98 47 6F F0 00 01 2C B9 05 4A DF F8 10 E0 BD 42 A9 D1 00 24 20 46 BD E8 F8 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_63_0 {
	meta:
		name = "?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z"
		size = 156
		refs = "0034 ?try_get_first_available_module@@YAPAUHINSTANCE__@@QBW4module_id@?A0x391cf84c@@0@Z 0090 __imp_GetProcAddress 0094 __security_cookie 0098 ?encoded_function_pointers@@3PAPAXA"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 23 4C 88 46 04 EB 80 06 35 68 BF F3 5B 8F 1F 4F 38 68 00 F0 1F 04 68 40 E0 41 6F F0 00 04 A0 42 08 BF 00 20 2E D0 68 BB 19 46 10 46 ?? ?? ?? ?? A8 B1 15 4B 41 46 1B 68 98 47 80 B1 3A 68 02 F0 1F 03 C3 F1 20 03 60 FA 03 F3 5A 40 BF F3 5B 8F 56 E8 00 1F 46 E8 00 23 00 2B F9 D1 10 E0 3A 68 02 F0 1F 03 C3 F1 20 03 64 FA 03 F3 5A 40 BF F3 5B 8F 56 E8 00 1F 46 E8 00 23 00 2B F9 D1 00 20 BF F3 5B 8F BD E8 F8 89 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_64_0 {
	meta:
		name = "?try_get_module@@YAPAUHINSTANCE__@@W4module_id@?A0x391cf84c@@@Z"
		size = 200
		refs = "0048 wcsncmp 00ac __imp_FreeLibrary 00b0 __imp_LoadLibraryExW 00b4 ??_C@_1BA@IAIFMGEF@?$AAe?$AAx?$AAt?$AA?9?$AAm?$AAs?$AA?9?$AA?$AA@ 00b8 ??_C@_1BA@PFFKHIOG@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AA?$AA@ 00bc __imp_GetLastError 00c0 ?module_names@?A0x391cf84c@@3QBQB_WB 00c4 ?module_handles@@3PAPAUHINSTANCE__@@A"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 2E 4B 03 EB 80 05 2C 68 BF F3 5B 8F 24 B1 B4 F1 FF 3F 44 D1 00 24 42 E0 27 4B 4F F4 00 62 00 21 53 F8 20 60 20 4B 30 46 1B 68 98 47 04 46 3C BB 20 4B 1B 68 98 47 57 28 13 D1 1D 49 07 22 30 46 ?? ?? ?? ?? 68 B1 19 49 07 22 30 46 ?? ?? ?? ?? 38 B1 15 4B 00 22 00 21 1B 68 30 46 98 47 04 46 00 E0 00 24 64 B9 BF F3 5B 8F 6F F0 00 01 55 E8 00 2F 45 E8 00 13 00 2B F9 D1 BF F3 5B 8F C9 E7 BF F3 5B 8F 55 E8 00 2F 45 E8 00 43 00 2B F9 D1 BF F3 5B 8F 1A B1 03 4B 20 46 1B 68 98 47 20 46 BD E8 78 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_65_0 {
	meta:
		name = "?try_get_proc_address_from_first_available_module@@YAPAXQBDQBW4module_id@?A0x391cf84c@@1@Z"
		size = 44
		refs = "0010 ?try_get_first_available_module@@YAPAUHINSTANCE__@@QBW4module_id@?A0x391cf84c@@0@Z 0028 __imp_GetProcAddress"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0B 46 04 46 18 46 11 46 ?? ?? ?? ?? 08 B9 00 20 03 E0 03 4B 21 46 1B 68 98 47 BD E8 18 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_66_0 {
	meta:
		name = "?try_load_library_from_system_directory@@YAPAUHINSTANCE__@@QB_W@Z"
		size = 96
		refs = "0028 wcsncmp 0050 __imp_LoadLibraryExW 0054 ??_C@_1BA@IAIFMGEF@?$AAe?$AAx?$AAt?$AA?9?$AAm?$AAs?$AA?9?$AA?$AA@ 0058 ??_C@_1BA@PFFKHIOG@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AA?$AA@ 005c __imp_GetLastError"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 11 4B 4F F4 00 62 00 21 1B 68 04 46 98 47 C0 B9 10 4B 1B 68 98 47 57 28 12 D1 0D 49 07 22 20 46 ?? ?? ?? ?? 60 B1 09 49 07 22 20 46 ?? ?? ?? ?? 30 B1 05 4B 00 22 00 21 1B 68 20 46 98 47 00 E0 00 20 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_68_0 {
	meta:
		name = "__acrt_AppPolicyGetProcessTerminationMethodInternal"
		size = 64
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0034 __guard_check_icall_fptr 0038 ??_C@_0CF@OJOFEIGO@AppPolicyGetProcessTerminationMe@ 003c ?candidate_modules@?1??try_get_AppPolicyGetProcessTerminationMethod@@YAP6AJPAXPAW4AppPolicyProcessTerminationMethod@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4A 0B 49 05 46 13 1D 1C 20 ?? ?? ?? ?? 04 46 3C B1 06 4B 1B 68 98 47 6F F0 05 00 29 46 A0 47 00 E0 01 48 BD E8 30 88 25 02 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_69_0 {
	meta:
		name = "__acrt_AppPolicyGetShowDeveloperDiagnosticInternal"
		size = 64
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0034 __guard_check_icall_fptr 0038 ??_C@_0CE@OICFMIKE@AppPolicyGetShowDeveloperDiagnos@ 003c ?candidate_modules@?1??try_get_AppPolicyGetShowDeveloperDiagnostic@@YAP6AJPAXPAW4AppPolicyShowDeveloperDiagnostic@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4A 0B 49 05 46 13 1D 1E 20 ?? ?? ?? ?? 04 46 3C B1 06 4B 1B 68 98 47 6F F0 05 00 29 46 A0 47 00 E0 01 48 BD E8 30 88 25 02 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_70_0 {
	meta:
		name = "__acrt_AppPolicyGetThreadInitializationTypeInternal"
		size = 64
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0034 __guard_check_icall_fptr 0038 ??_C@_0CF@NNDFDCOC@AppPolicyGetThreadInitialization@ 003c ?candidate_modules@?1??try_get_AppPolicyGetThreadInitializationType@@YAP6AJPAXPAW4AppPolicyThreadInitializationType@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4A 0B 49 05 46 13 1D 1D 20 ?? ?? ?? ?? 04 46 3C B1 06 4B 1B 68 98 47 6F F0 05 00 29 46 A0 47 00 E0 01 48 BD E8 30 88 25 02 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_71_0 {
	meta:
		name = "__acrt_AppPolicyGetWindowingModelInternal"
		size = 64
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0034 __guard_check_icall_fptr 0038 ??_C@_0BL@ODDJNEDA@AppPolicyGetWindowingModel?$AA@ 003c ?candidate_modules@?1??try_get_AppPolicyGetWindowingModel@@YAP6AJPAXPAW4AppPolicyWindowingModel@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4A 0B 49 05 46 13 1D 1F 20 ?? ?? ?? ?? 04 46 3C B1 06 4B 1B 68 98 47 6F F0 05 00 29 46 A0 47 00 E0 01 48 BD E8 30 88 25 02 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_72_0 {
	meta:
		name = "__acrt_AreFileApisANSI"
		size = 52
		refs = "0010 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0028 __guard_check_icall_fptr 002c ??_C@_0BA@FHFNEAED@AreFileApisANSI?$AA@ 0030 ?candidate_modules@?1??try_get_AreFileApisANSI@@YAP6AHXZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 4A 08 49 00 20 13 1D ?? ?? ?? ?? 04 46 24 B1 03 4B 1B 68 98 47 A0 47 00 E0 01 20 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_73_0 {
	meta:
		name = "__acrt_CompareStringEx"
		size = 124
		refs = "001c ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 004e __acrt_LocaleNameToLCID 006c __imp_CompareStringW 0070 __guard_check_icall_fptr 0074 ??_C@_0BA@IHGNDAEB@CompareStringEx?$AA@ 0078 ?candidate_modules@?1??try_get_CompareStringEx@@YAP6AHPB_WK0H0HPAU_nlsversioninfo@@PAXJ@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 17 46 1A 4A 88 46 18 49 1E 46 81 46 02 F1 08 03 01 20 ?? ?? ?? ?? 05 46 95 B1 12 9C 12 4B 04 94 11 9C 1B 68 03 94 10 9C 02 94 0F 9C 01 94 0E 9C 00 94 98 47 48 46 41 46 3A 46 33 46 A8 47 0D E0 00 21 48 46 ?? ?? ?? ?? 0F 9B 05 4C 3A 46 01 93 0E 9B 24 68 41 46 00 93 33 46 A0 47 06 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_74_0 {
	meta:
		name = "__acrt_EnumSystemLocalesEx"
		size = 100
		refs = "001c ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0048 ??$?RV<lambda_907ee7f4bf33be32093fb97356e25c51>@@AAV<lambda_777d11615145f89ee95b9466d285deeb>@@V<lambda_837e4d9ce529d0ba20c549a471848991>@@@?$__crt_seh_guarded_call@H@@QAAH$$QAV<lambda_907ee7f4bf33be32093fb97356e25c51>@@AAV<lambda_777d11615145f89ee95b9466d285deeb>@@$$QAV<lambda_837e4d9ce529d0ba20c549a471848991>@@@Z 0058 __guard_check_icall_fptr 005c ??_C@_0BE@LJANKFHF@EnumSystemLocalesEx?$AA@ 0060 ?candidate_modules@?1??try_get_EnumSystemLocalesEx@@YAP6AHP6AHPA_WKJ@ZKJPAX@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B 85 B0 17 46 14 4A 88 46 12 49 1E 46 02 F1 08 03 02 20 ?? ?? ?? ?? 05 46 45 B1 0C 4C 24 68 A0 47 0C 98 41 46 3A 46 33 46 A8 47 0A E0 0C AB 02 93 04 23 01 93 03 93 01 AB 02 AA 03 A9 68 46 ?? ?? ?? ?? 05 B0 BD E8 F0 09 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_75_0 {
	meta:
		name = "__acrt_FlsAlloc"
		size = 68
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0034 __imp_TlsAlloc 0038 __guard_check_icall_fptr 003c ??_C@_08KNHFBNJ@FlsAlloc?$AA@ 0040 ?candidate_modules@?1??try_get_FlsAlloc@@YAP6AKP6AXPAX@Z@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4A 0C 49 05 46 02 F1 08 03 03 20 ?? ?? ?? ?? 04 46 2C B1 06 4B 1B 68 98 47 28 46 A0 47 02 E0 02 4B 1B 68 98 47 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_76_0 {
	meta:
		name = "__acrt_FlsFree"
		size = 68
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0034 __imp_TlsFree 0038 __guard_check_icall_fptr 003c ??_C@_07PEJMOBNF@FlsFree?$AA@ 0040 ?candidate_modules@?1??try_get_FlsFree@@YAP6AHK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4A 0C 49 04 46 02 F1 08 03 04 20 ?? ?? ?? ?? 05 46 2D B1 06 4B 1B 68 98 47 20 46 A8 47 03 E0 02 4B 20 46 1B 68 98 47 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_77_0 {
	meta:
		name = "__acrt_FlsGetValue"
		size = 68
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0034 __imp_TlsGetValue 0038 __guard_check_icall_fptr 003c ??_C@_0M@GDNOONDI@FlsGetValue?$AA@ 0040 ?candidate_modules@?1??try_get_FlsGetValue@@YAP6APAXK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4A 0C 49 04 46 02 F1 08 03 05 20 ?? ?? ?? ?? 05 46 2D B1 06 4B 1B 68 98 47 20 46 A8 47 03 E0 02 4B 20 46 1B 68 98 47 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_78_0 {
	meta:
		name = "__acrt_FlsSetValue"
		size = 76
		refs = "0016 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 003c __imp_TlsSetValue 0040 __guard_check_icall_fptr 0044 ??_C@_0M@JCPCPOEF@FlsSetValue?$AA@ 0048 ?candidate_modules@?1??try_get_FlsSetValue@@YAP6AHKPAX@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0F 4A 0C 46 0D 49 05 46 02 F1 08 03 06 20 ?? ?? ?? ?? 06 46 36 B1 08 4B 1B 68 98 47 28 46 21 46 B0 47 04 E0 03 4B 21 46 28 46 1B 68 98 47 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_79_0 {
	meta:
		name = "__acrt_GetDateFormatEx"
		size = 116
		refs = "001a ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0044 __acrt_LocaleNameToLCID 0064 __imp_GetDateFormatW 0068 __guard_check_icall_fptr 006c ??_C@_0BA@EPCJIIPD@GetDateFormatEx?$AA@ 0070 ?candidate_modules@?1??try_get_GetDateFormatEx@@YAP6AHPB_WKPBU_SYSTEMTIME@@0PA_WH0@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 FF 4B 0D F1 28 0B 17 46 19 4A 88 46 17 49 1E 46 81 46 02 F1 08 03 08 20 ?? ?? ?? ?? 05 46 75 B1 0E 9C 02 94 0D 9C 01 94 0C 9C 00 94 0E 4C 24 68 A0 47 48 46 41 46 3A 46 33 46 A8 47 0D E0 00 21 48 46 ?? ?? ?? ?? 0D 9B 06 4C 3A 46 01 93 0C 9B 24 68 41 46 00 93 33 46 A0 47 04 B0 BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_80_0 {
	meta:
		name = "__acrt_GetEnabledXStateFeatures"
		size = 56
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0026 abort 002c __guard_check_icall_fptr 0030 ??_C@_0BJ@DIBIJBHA@GetEnabledXStateFeatures?$AA@ 0034 ?candidate_modules@?1??try_get_GetEnabledXStateFeatures@@YAP6A_KXZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 4A 09 49 09 20 02 F1 08 03 ?? ?? ?? ?? 04 46 2C B1 04 4B 1B 68 98 47 A0 47 BD E8 18 88 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_81_0 {
	meta:
		name = "__acrt_GetLocaleInfoEx"
		size = 92
		refs = "001a ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0038 __acrt_LocaleNameToLCID 004c __imp_GetLocaleInfoW 0050 __guard_check_icall_fptr 0054 ??_C@_0BA@ONOKGCMP@GetLocaleInfoEx?$AA@ 0058 ?candidate_modules@?1??try_get_GetLocaleInfoEx@@YAP6AHPB_WKPA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 17 46 13 4A 88 46 11 49 1E 46 81 46 02 F1 08 03 0B 20 ?? ?? ?? ?? 05 46 45 B1 0B 4C 24 68 A0 47 48 46 41 46 3A 46 33 46 A8 47 09 E0 00 21 48 46 ?? ?? ?? ?? 03 4C 33 46 3A 46 24 68 41 46 A0 47 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_82_0 {
	meta:
		name = "__acrt_GetSystemTimePreciseAsFileTime"
		size = 68
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0034 __imp_GetSystemTimeAsFileTime 0038 __guard_check_icall_fptr 003c ??_C@_0BP@FPNJPEJC@GetSystemTimePreciseAsFileTime?$AA@ 0040 ?candidate_modules@?1??try_get_GetSystemTimePreciseAsFileTime@@YAP6AXPAU_FILETIME@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 4A 0C 49 04 46 13 1D 0D 20 ?? ?? ?? ?? 05 46 2D B1 07 4B 1B 68 98 47 20 46 A8 47 03 E0 03 4B 20 46 1B 68 98 47 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_83_0 {
	meta:
		name = "__acrt_GetTimeFormatEx"
		size = 108
		refs = "001a ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0040 __acrt_LocaleNameToLCID 005c __imp_GetTimeFormatW 0060 __guard_check_icall_fptr 0064 ??_C@_0BA@CIJJKCJJ@GetTimeFormatEx?$AA@ 0068 ?candidate_modules@?1??try_get_GetTimeFormatEx@@YAP6AHPB_WKPBU_SYSTEMTIME@@0PA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 FC 4B 0D F1 20 0B 17 46 17 4A 88 46 15 49 1E 46 81 46 02 F1 08 03 0E 20 ?? ?? ?? ?? 05 46 65 B1 0B 9C 01 94 0A 9C 00 94 0D 4C 24 68 A0 47 48 46 41 46 3A 46 33 46 A8 47 0D E0 00 21 48 46 ?? ?? ?? ?? 0B 9B 05 4C 3A 46 01 93 0A 9B 24 68 41 46 00 93 33 46 A0 47 BD E8 FC 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_84_0 {
	meta:
		name = "__acrt_GetUserDefaultLocaleName"
		size = 80
		refs = "0016 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0038 __acrt_LCIDToLocaleName 0040 __imp_GetUserDefaultLCID 0044 __guard_check_icall_fptr 0048 ??_C@_0BJ@PBCCBIPI@GetUserDefaultLocaleName?$AA@ 004c ?candidate_modules@?1??try_get_GetUserDefaultLocaleName@@YAP6AHPA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 10 4A 0D 46 0E 49 06 46 02 F1 08 03 0F 20 ?? ?? ?? ?? 04 46 34 B1 09 4B 1B 68 98 47 30 46 29 46 A0 47 07 E0 04 4B 1B 68 98 47 00 23 2A 46 31 46 ?? ?? ?? ?? BD E8 78 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_85_0 {
	meta:
		name = "__acrt_GetXStateFeaturesMask"
		size = 64
		refs = "0016 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 002e abort 0034 __guard_check_icall_fptr 0038 ??_C@_0BG@IKLDMBLM@GetXStateFeaturesMask?$AA@ 003c ?candidate_modules@?1??try_get_GetXStateFeaturesMask@@YAP6AHPAU_CONTEXT@@PA_K@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 4A 0D 46 0A 49 06 46 02 F1 08 03 11 20 ?? ?? ?? ?? 04 46 3C B1 05 4B 1B 68 98 47 30 46 29 46 A0 47 BD E8 78 88 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_86_0 {
	meta:
		name = "__acrt_InitializeCriticalSectionEx"
		size = 80
		refs = "0018 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0040 __imp_InitializeCriticalSectionAndSpinCount 0044 __guard_check_icall_fptr 0048 ??_C@_0BM@HCFOFFN@InitializeCriticalSectionEx?$AA@ 004c ?candidate_modules@?1??try_get_InitializeCriticalSectionEx@@YAP6AHPAU_RTL_CRITICAL_SECTION@@KK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 17 46 10 4A 0C 46 0E 49 05 46 02 F1 08 03 12 20 ?? ?? ?? ?? 06 46 3E B1 08 4B 1B 68 98 47 28 46 21 46 3A 46 B0 47 04 E0 03 4B 21 46 28 46 1B 68 98 47 BD E8 F0 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_87_0 {
	meta:
		name = "__acrt_IsValidLocaleName"
		size = 76
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 002c __acrt_LocaleNameToLCID 003c __imp_IsValidLocale 0040 __guard_check_icall_fptr 0044 ??_C@_0BC@CELBKLLA@IsValidLocaleName?$AA@ 0048 ?candidate_modules@?1??try_get_IsValidLocaleName@@YAP6AHPB_W@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0F 4A 0E 49 05 46 02 F1 08 03 13 20 ?? ?? ?? ?? 04 46 2C B1 08 4B 1B 68 98 47 28 46 A0 47 07 E0 00 21 28 46 ?? ?? ?? ?? 02 4B 01 21 1B 68 98 47 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_88_0 {
	meta:
		name = "__acrt_LCIDToLocaleName"
		size = 80
		refs = "001a ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 003a __acrt_DownlevelLCIDToLocaleName 0044 __guard_check_icall_fptr 0048 ??_C@_0BB@CDHDDLLP@LCIDToLocaleName?$AA@ 004c ?candidate_modules@?1??try_get_LCIDToLocaleName@@YAP6AHKPA_WHK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 15 46 10 4A 0E 46 0E 49 99 46 07 46 02 F1 08 03 15 20 ?? ?? ?? ?? 80 46 40 B1 08 4C 24 68 A0 47 38 46 31 46 2A 46 4B 46 C0 47 04 E0 2A 46 31 46 38 46 ?? ?? ?? ?? BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_89_0 {
	meta:
		name = "__acrt_LCMapStringEx"
		size = 124
		refs = "001c ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 004e __acrt_LocaleNameToLCID 006c __imp_LCMapStringW 0070 __guard_check_icall_fptr 0074 ??_C@_0O@KKBNKAPF@LCMapStringEx?$AA@ 0078 ?candidate_modules@?1??try_get_LCMapStringEx@@YAP6AHPB_WK0HPA_WHPAU_nlsversioninfo@@PAXJ@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 17 46 1A 4A 88 46 18 49 1E 46 81 46 02 F1 08 03 14 20 ?? ?? ?? ?? 05 46 95 B1 12 9C 12 4B 04 94 11 9C 1B 68 03 94 10 9C 02 94 0F 9C 01 94 0E 9C 00 94 98 47 48 46 41 46 3A 46 33 46 A8 47 0D E0 00 21 48 46 ?? ?? ?? ?? 0F 9B 05 4C 3A 46 01 93 0E 9B 24 68 41 46 00 93 33 46 A0 47 06 B0 BD E8 F0 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_90_0 {
	meta:
		name = "__acrt_LocaleNameToLCID"
		size = 68
		refs = "0016 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 002e __acrt_DownlevelLocaleNameToLCID 0038 __guard_check_icall_fptr 003c ??_C@_0BB@HBDEELFH@LocaleNameToLCID?$AA@ 0040 ?candidate_modules@?1??try_get_LocaleNameToLCID@@YAP6AKPB_WK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0D 4A 0E 46 0B 49 04 46 02 F1 08 03 16 20 ?? ?? ?? ?? 05 46 35 B1 06 4B 1B 68 98 47 20 46 31 46 A8 47 02 E0 20 46 ?? ?? ?? ?? BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_91_0 {
	meta:
		name = "__acrt_LocateXStateFeature"
		size = 68
		refs = "0018 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0032 abort 0038 __guard_check_icall_fptr 003c ??_C@_0BE@KINNKFDA@LocateXStateFeature?$AA@ 0040 ?candidate_modules@?1??try_get_LocateXStateFeature@@YAP6APAXPAU_CONTEXT@@KPAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 15 46 0D 4A 0E 46 0B 49 07 46 02 F1 08 03 17 20 ?? ?? ?? ?? 04 46 44 B1 05 4B 1B 68 98 47 38 46 31 46 2A 46 A0 47 BD E8 F0 88 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_92_0 {
	meta:
		name = "__acrt_MessageBoxA"
		size = 72
		refs = "001a ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0036 abort 003c __guard_check_icall_fptr 0040 ??_C@_0M@CHKKJDAI@MessageBoxA?$AA@ 0044 ?candidate_modules@?1??try_get_MessageBoxA@@YAP6AHPAUHWND__@@PBD1I@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 17 46 0E 4A 88 46 0C 49 1E 46 81 46 02 F1 08 03 18 20 ?? ?? ?? ?? 05 46 4D B1 06 4C 24 68 A0 47 48 46 41 46 3A 46 33 46 A8 47 BD E8 F0 8B ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_93_0 {
	meta:
		name = "__acrt_MessageBoxW"
		size = 72
		refs = "001a ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0036 abort 003c __guard_check_icall_fptr 0040 ??_C@_0M@DLDCCGNP@MessageBoxW?$AA@ 0044 ?candidate_modules@?1??try_get_MessageBoxW@@YAP6AHPAUHWND__@@PB_W1I@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 17 46 0E 4A 88 46 0C 49 1E 46 81 46 02 F1 08 03 19 20 ?? ?? ?? ?? 05 46 4D B1 06 4C 24 68 A0 47 48 46 41 46 3A 46 33 46 A8 47 BD E8 F0 8B ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_94_0 {
	meta:
		name = "__acrt_RoInitialize"
		size = 56
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 002c __guard_check_icall_fptr 0030 ??_C@_0N@PPOMPGGK@RoInitialize?$AA@ 0034 ?candidate_modules@?1??try_get_RoInitialize@@YAP6AJW4RO_INIT_TYPE@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4A 09 49 05 46 13 1D 1A 20 ?? ?? ?? ?? 04 46 2C B1 04 4B 1B 68 98 47 28 46 A0 47 00 E0 00 20 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_95_0 {
	meta:
		name = "__acrt_RoUninitialize"
		size = 48
		refs = "0010 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0024 __guard_check_icall_fptr 0028 ??_C@_0P@LLFHBIJD@RoUninitialize?$AA@ 002c ?candidate_modules@?1??try_get_RoUninitialize@@YAP6AXXZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 08 4A 07 49 1B 20 13 1D ?? ?? ?? ?? 04 46 1C B1 02 4B 1B 68 98 47 A0 47 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_96_0 {
	meta:
		name = "__acrt_RtlGenRandom"
		size = 64
		refs = "0016 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 002e abort 0034 __guard_check_icall_fptr 0038 ??_C@_0BC@JEAENNKH@SystemFunction036?$AA@ 003c ?candidate_modules@?1??try_get_SystemFunction036@@YAP6AEPAXK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 4A 0D 46 0A 49 06 46 02 F1 08 03 21 20 ?? ?? ?? ?? 04 46 3C B1 05 4B 1B 68 98 47 30 46 29 46 A0 47 BD E8 78 88 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_97_0 {
	meta:
		name = "__acrt_SetThreadStackGuarantee"
		size = 60
		refs = "0014 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0030 __guard_check_icall_fptr 0034 ??_C@_0BI@BKLFFAPO@SetThreadStackGuarantee?$AA@ 0038 ?candidate_modules@?1??try_get_SetThreadStackGuarantee@@YAP6AHPAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0B 4A 0A 49 05 46 02 F1 08 03 20 20 ?? ?? ?? ?? 04 46 2C B1 04 4B 1B 68 98 47 28 46 A0 47 00 E0 00 20 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_98_0 {
	meta:
		name = "__acrt_can_show_message_box"
		size = 76
		refs = "000a __acrt_get_windowing_model_policy 001c ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 003c ??_C@_0M@DLDCCGNP@MessageBoxW?$AA@ 0040 ?candidate_modules@?1??try_get_MessageBoxW@@YAP6AHPAUHWND__@@PB_W1I@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0044 ??_C@_0M@CHKKJDAI@MessageBoxA?$AA@ 0048 ?candidate_modules@?1??try_get_MessageBoxA@@YAP6AHPAUHWND__@@PBD1I@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 00 24 ?? ?? ?? ?? 01 28 10 D1 0D 4A 0B 49 18 20 02 F1 08 03 ?? ?? ?? ?? 40 B1 07 4A 05 49 19 20 02 F1 08 03 ?? ?? ?? ?? 00 B1 01 24 20 46 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_99_0 {
	meta:
		name = "__acrt_can_use_vista_locale_apis"
		size = 40
		refs = "0010 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0020 ??_C@_0BA@IHGNDAEB@CompareStringEx?$AA@ 0024 ?candidate_modules@?1??try_get_CompareStringEx@@YAP6AHPB_WK0H0HPAU_nlsversioninfo@@PAXJ@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4A 05 49 01 20 02 F1 08 03 ?? ?? ?? ?? 08 B1 01 20 00 E0 00 20 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_100_0 {
	meta:
		name = "__acrt_can_use_xstate_apis"
		size = 40
		refs = "0010 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0020 ??_C@_0BE@KINNKFDA@LocateXStateFeature?$AA@ 0024 ?candidate_modules@?1??try_get_LocateXStateFeature@@YAP6APAXPAU_CONTEXT@@KPAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4A 05 49 17 20 02 F1 08 03 ?? ?? ?? ?? 08 B1 01 20 00 E0 00 20 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_101_0 {
	meta:
		name = "__acrt_eagerly_load_locale_apis"
		size = 252
		refs = "000e ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 00a4 ??_C@_0BB@HBDEELFH@LocaleNameToLCID?$AA@ 00a8 ?candidate_modules@?1??try_get_LocaleNameToLCID@@YAP6AKPB_WK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00ac ??_C@_0BB@CDHDDLLP@LCIDToLocaleName?$AA@ 00b0 ?candidate_modules@?1??try_get_LCIDToLocaleName@@YAP6AHKPA_WHK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00b4 ??_C@_0O@KKBNKAPF@LCMapStringEx?$AA@ 00b8 ?candidate_modules@?1??try_get_LCMapStringEx@@YAP6AHPB_WK0HPA_WHPAU_nlsversioninfo@@PAXJ@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00bc ??_C@_0BC@CELBKLLA@IsValidLocaleName?$AA@ 00c0 ?candidate_modules@?1??try_get_IsValidLocaleName@@YAP6AHPB_W@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00c4 ??_C@_0BJ@PBCCBIPI@GetUserDefaultLocaleName?$AA@ 00c8 ?candidate_modules@?1??try_get_GetUserDefaultLocaleName@@YAP6AHPA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00cc ??_C@_0BA@CIJJKCJJ@GetTimeFormatEx?$AA@ 00d0 ?candidate_modules@?1??try_get_GetTimeFormatEx@@YAP6AHPB_WKPBU_SYSTEMTIME@@0PA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00d4 ??_C@_0BA@ONOKGCMP@GetLocaleInfoEx?$AA@ 00d8 ?candidate_modules@?1??try_get_GetLocaleInfoEx@@YAP6AHPB_WKPA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00dc ??_C@_0BA@EPCJIIPD@GetDateFormatEx?$AA@ 00e0 ?candidate_modules@?1??try_get_GetDateFormatEx@@YAP6AHPB_WKPBU_SYSTEMTIME@@0PA_WH0@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00e4 ??_C@_0BE@LJANKFHF@EnumSystemLocalesEx?$AA@ 00e8 ?candidate_modules@?1??try_get_EnumSystemLocalesEx@@YAP6AHP6AHPA_WKJ@ZKJPAX@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00ec ??_C@_0BA@IHGNDAEB@CompareStringEx?$AA@ 00f0 ?candidate_modules@?1??try_get_CompareStringEx@@YAP6AHPB_WK0H0HPAU_nlsversioninfo@@PAXJ@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00f4 ??_C@_0BA@FHFNEAED@AreFileApisANSI?$AA@ 00f8 ?candidate_modules@?1??try_get_AreFileApisANSI@@YAP6AHXZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 00 48 EB 46 3C 4A 3A 49 00 20 13 1D ?? ?? ?? ?? 37 4A 35 49 01 20 02 F1 08 03 ?? ?? ?? ?? 31 4A 30 49 02 20 02 F1 08 03 ?? ?? ?? ?? 2C 4A 2A 49 08 20 02 F1 08 03 ?? ?? ?? ?? 26 4A 25 49 0B 20 02 F1 08 03 ?? ?? ?? ?? 21 4A 1F 49 0E 20 02 F1 08 03 ?? ?? ?? ?? 1B 4A 1A 49 0F 20 02 F1 08 03 ?? ?? ?? ?? 16 4A 14 49 13 20 02 F1 08 03 ?? ?? ?? ?? 10 4A 0F 49 14 20 02 F1 08 03 ?? ?? ?? ?? 0B 4A 09 49 15 20 02 F1 08 03 ?? ?? ?? ?? 05 4A 04 49 16 20 02 F1 08 03 BD E8 00 48 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_102_0 {
	meta:
		name = "__acrt_get_parent_window"
		size = 100
		refs = "0012 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 0050 ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 0054 ?candidate_modules@?1??try_get_GetLastActivePopup@@YAP6APAUHWND__@@PAU2@@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0058 __guard_check_icall_fptr 005c ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 0060 ?candidate_modules@?1??try_get_GetActiveWindow@@YAP6APAUHWND__@@XZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 15 4A 14 49 07 20 02 F1 08 03 ?? ?? ?? ?? 04 46 0C B9 00 24 15 E0 0E 4D 20 46 2B 68 98 47 A0 47 04 46 00 2C F5 D0 09 4A 07 49 0A 20 02 F1 08 03 ?? ?? ?? ?? 06 46 26 B1 2B 68 98 47 20 46 B0 47 04 46 20 46 BD E8 78 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_103_0 {
	meta:
		name = "__acrt_initialize_winapi_thunks"
		size = 56
		refs = "0030 ?encoded_function_pointers@@3PAPAXA 0034 __security_cookie"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 4B 00 21 1A 68 02 F0 1F 03 C3 F1 20 03 61 FA 03 F3 5A 40 05 4B 03 F1 88 01 43 F8 04 2B 8B 42 FB D1 01 20 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_104_0 {
	meta:
		name = "__acrt_is_interactive"
		size = 140
		refs = "0008 __security_push_cookie 0018 ?try_get_function@@YAPAXW4function_id@?A0x391cf84c@@QBDQBW4module_id@2@2@Z 006e __security_pop_cookie 0078 __guard_check_icall_fptr 007c ??_C@_0BK@DEKFELLI@GetUserObjectInformationW?$AA@ 0080 ?candidate_modules@?1??try_get_GetUserObjectInformationW@@YAP6AHPAXH0KPAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0084 ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 0088 ?candidate_modules@?1??try_get_GetProcessWindowStation@@YAP6APAUHWINSTA__@@XZXZ@4QBW4module_id@?A0x391cf84c@@B"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? 85 B0 1E 4A 1C 49 0C 20 02 F1 08 03 ?? ?? ?? ?? 04 46 24 B3 17 4A 16 49 10 20 02 F1 08 03 ?? ?? ?? ?? 07 46 DF B1 11 4D 20 46 2B 68 98 47 A0 47 06 46 0E B9 00 20 13 E0 2C 68 00 23 38 46 CD E9 02 33 04 93 00 93 A0 47 30 46 01 21 02 AA 0C 23 B8 47 00 28 EE D0 04 9B 13 F0 01 0F EA D0 01 20 05 B0 ?? ?? ?? ?? BD E8 F0 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_105_0 {
	meta:
		name = "__acrt_uninitialize_winapi_thunks"
		size = 56
		refs = "0030 __imp_FreeLibrary 0034 ?module_handles@@3PAPAUHINSTANCE__@@A"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 78 B9 0A 4C 08 4E 00 27 04 F1 4C 05 20 68 28 B1 B0 F1 FF 3F 01 D0 33 68 98 47 27 60 24 1D AC 42 F4 D1 01 20 BD E8 F0 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_4_0 {
	meta:
		name = "_mbslwr"
		size = 36
		refs = "0016 _mbslwr_s_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 6F F0 00 01 04 B9 00 21 00 22 20 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_450_4_0 {
	meta:
		name = "_mbsupr"
		size = 36
		refs = "0016 _mbsupr_s_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 6F F0 00 01 04 B9 00 21 00 22 20 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_58_5_0 {
	meta:
		name = "_mbslwr_l"
		size = 36
		refs = "0016 _mbslwr_s_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 0A 46 6F F0 00 01 04 B9 00 21 20 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_450_5_0 {
	meta:
		name = "_mbsupr_l"
		size = 36
		refs = "0016 _mbsupr_s_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 0A 46 6F F0 00 01 04 B9 00 21 20 46 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_58_7_0 {
	meta:
		name = "_mbslwr_s_l"
		size = 240
		refs = "001e _errno 0026 _invalid_parameter_noinfo 0032 strnlen 0044 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0086 __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 8C B0 04 46 16 46 0D 46 1C B1 25 B1 5C B9 00 20 5D E0 00 2D FA D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 53 E0 29 46 20 46 ?? ?? ?? ?? A8 42 02 D3 00 23 23 70 EE E7 08 A8 31 46 ?? ?? ?? ?? 23 78 26 46 25 46 4F F0 02 08 9B B3 0A 9A 4F F0 01 09 06 AF 33 78 99 18 48 7E 10 F0 04 0F 1E D0 53 68 D2 F8 1C 12 4F F4 80 72 03 93 33 46 09 A8 CD F8 10 90 CD F8 08 80 01 97 CD F8 00 80 ?? ?? ?? ?? 38 B3 9D F8 18 30 0A 9A 76 1C 05 F8 01 3B 01 28 0B DD 9D F8 19 30 2B 70 6D 1C 06 E0 10 F0 10 0F 01 D0 91 F8 19 31 05 F8 01 3B 16 F8 01 3F 00 2B CF D1 00 23 2B 70 00 20 9D F8 2C 30 33 B1 08 9A D2 F8 50 33 23 EA 08 03 C2 F8 50 33 0C B0 BD E8 F0 8B ?? ?? ?? ?? 2A 23 03 60 00 23 23 70 ?? ?? ?? ?? 00 68 E8 E7 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "csinl"
		size = 110
		refs = "0014 creall 0024 cimagl 0030 _LCbuild 0034 csinhl"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B B1 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 2B B0 EE 40 3B 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B1 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_581_0_4 {
	meta:
		name = "casin"
		size = 110
		refs = "0014 creal 0024 cimag 0030 _Cbuild 0034 casinh"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B B1 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 2B B0 EE 40 3B 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B1 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_396_0_4 {
	meta:
		name = "casinl"
		size = 110
		refs = "0014 creall 0024 cimagl 0030 _LCbuild 0034 casinhl"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B B1 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 2B B0 EE 40 3B 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B1 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "catan"
		size = 110
		refs = "0014 creal 0024 cimag 0030 _Cbuild 0034 catanh"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B B1 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 2B B0 EE 40 3B 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B1 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_334_0_2 {
	meta:
		name = "catanl"
		size = 110
		refs = "0014 creall 0024 cimagl 0030 _LCbuild 0034 catanhl"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B B1 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 2B B0 EE 40 3B 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B1 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "csin"
		size = 110
		refs = "0014 creal 0024 cimag 0030 _Cbuild 0034 csinh"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B B1 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 2B B0 EE 40 3B 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B1 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_455_0_3 {
	meta:
		name = "ctan"
		size = 110
		refs = "0014 creal 0024 cimag 0030 _Cbuild 0034 ctanh"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B B1 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 2B B0 EE 40 3B 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B1 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_451_0_0 {
	meta:
		name = "ctanl"
		size = 110
		refs = "0014 creall 0024 cimagl 0030 _LCbuild 0034 ctanhl"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B B1 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 2B B0 EE 40 3B 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B1 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "wmemcpy"
		size = 16
		refs = "000c memcpy"
	strings:
		$1 = { 2D E9 00 48 EB 46 52 00 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "wmemmove"
		size = 16
		refs = "000c memmove"
	strings:
		$1 = { 2D E9 00 48 EB 46 52 00 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_1_0 {
	meta:
		name = "wmemcpy_s"
		size = 100
		refs = "0012 _errno 001a _invalid_parameter_noinfo 0030 memcpy"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 14 46 0B B9 00 24 07 E0 48 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 24 20 46 BD E8 30 88 34 B1 99 42 04 D3 5A 00 21 46 ?? ?? ?? ?? EA E7 39 B1 00 25 29 B1 00 EB 41 02 20 F8 02 5B 90 42 FB D1 1C B9 ?? ?? ?? ?? 16 24 04 E0 99 42 E3 D2 ?? ?? ?? ?? 22 24 04 60 ?? ?? ?? ?? DD E7 }
	condition:
		$1
}

rule file_60_2_0 {
	meta:
		name = "wmemset"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 32 B1 03 46 00 EB 42 02 23 F8 02 1B 93 42 FB D1 BD E8 00 88 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "mbrtoc32"
		size = 212
		refs = "00aa _errno 00cc ??_C@_00CNPNBAHC@?$AA@ 00d0 ?internal_pst@?1??mbrtoc32@@9@4U_Mbstatet@@A"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 1E 46 96 46 0F 46 06 B9 2F 4E F3 88 34 68 5D B2 1F B9 2C 4F 00 20 4F F0 01 0E 3A 46 BE F1 00 0F 39 D0 00 2D 0B DD 11 78 01 F0 C0 03 80 2B 38 D1 01 F0 3F 03 43 EA 84 14 6B 1E 5D B2 26 E0 14 78 14 F0 80 0F 22 D0 04 F0 E0 03 C0 2B 03 D1 04 F0 1F 04 01 25 1A E0 04 F0 F0 03 E0 2B 03 D1 04 F0 0F 04 02 25 12 E0 04 F0 F8 03 F0 2B 03 D1 04 F0 07 04 03 25 0A E0 04 F0 FC 03 F8 2B 08 BF 04 25 02 D0 FC 2B 0D D1 05 25 04 F0 03 04 85 B1 52 1C BE F1 01 0E C5 D1 34 60 F5 80 6F F0 01 00 BD E8 F0 88 ?? ?? ?? ?? 2A 23 03 60 6F F0 00 00 F6 E7 00 B1 04 60 00 23 F3 80 0C B9 00 20 EF E7 D3 1B 58 1C EC E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__strncnt"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 02 46 92 F9 00 30 00 20 03 E0 88 42 03 D0 40 1C 83 56 00 2B F9 D1 BD E8 00 88 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "wcsspn"
		size = 50
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 02 88 03 46 6A B1 0D 88 0E 46 AA 42 05 D0 2C 46 3C B1 36 F8 02 4F A2 42 FA D1 9B 1C 1A 88 00 2A F2 D1 1B 1A 58 10 BD E8 78 88 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "_FPE_Raise"
		size = 1300
		refs = "000a __security_push_cookie 04ee __security_pop_cookie 04fc __imp_RaiseException"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 82 B0 6F 46 79 63 06 46 5D F8 80 39 6B 46 0F 33 23 F0 0F 05 C1 F3 04 59 F1 EE 10 3A 4F F4 1F 44 83 EA 04 01 7B 6B 4F F0 01 0E 3D 60 13 EA 0E 0F 18 BF 01 22 08 BF 00 22 11 43 13 F0 02 0F 18 BF 02 22 08 BF 00 22 11 43 13 F0 04 0F 18 BF 04 22 08 BF 00 22 11 43 13 F0 08 0F 18 BF 08 22 08 BF 00 22 0A 43 13 F0 10 0F 18 BF 10 23 08 BF 00 23 43 EA 02 00 80 EA 04 03 E1 EE 10 3A 79 6B 4F F4 00 78 4F F4 80 6A 11 EA 0E 04 4F F4 80 7E 4F F4 00 63 4F F4 80 52 05 D0 10 EA 0E 0F 02 D0 DF F8 60 E4 22 E0 11 F0 02 0F 05 D0 10 EA 08 0F 02 D0 DF F8 4C E4 19 E0 11 F0 04 0F 05 D0 10 EA 0A 0F 02 D0 DF F8 34 E4 10 E0 11 F0 08 0F 04 D0 18 42 02 D0 DF F8 20 E4 08 E0 11 F0 10 0F 00 F0 F9 81 10 42 00 F0 F6 81 DF F8 08 E4 4F F4 40 08 10 EA 08 03 A8 F5 80 0A A8 F5 00 02 10 D0 93 42 0C D0 53 45 05 D0 43 45 0E D1 2B 68 43 F0 03 03 09 E0 01 22 2B 68 62 F3 01 03 04 E0 02 22 F9 E7 2B 68 23 F0 03 03 2B 60 2B 68 B9 F1 1A 0F 23 F0 1C 03 2B 60 20 D8 DF E8 09 F0 0E 0E 16 16 10 10 12 12 18 18 18 18 18 18 14 14 18 18 18 18 18 18 18 18 18 18 1A 1A 01 22 0A E0 07 22 08 E0 04 22 06 E0 03 22 04 E0 02 22 02 E0 08 22 00 E0 09 22 2B 68 62 F3 50 13 2B 60 6B 68 11 F0 10 0F 18 BF 01 22 08 BF 00 22 62 F3 00 03 6B 60 6B 68 11 F0 08 0F 18 BF 01 22 08 BF 00 22 83 EA 42 03 03 F0 02 02 6B 68 53 40 6B 60 6B 68 11 F0 04 0F 18 BF 01 22 08 BF 00 22 83 EA 82 03 03 F0 04 02 6B 68 53 40 6B 60 6B 68 11 F0 02 0F 18 BF 01 22 08 BF 00 22 83 EA C2 03 08 21 03 EA 01 02 6B 68 53 40 6B 60 0C B1 01 22 00 E0 00 22 6B 68 10 24 83 EA 02 13 03 EA 04 02 6B 68 53 40 6B 60 AB 68 10 F4 80 5F 18 BF 01 22 08 BF 00 22 62 F3 00 03 AB 60 AB 68 10 F4 00 6F 18 BF 01 22 08 BF 00 22 83 EA 42 03 03 F0 02 02 AB 68 53 40 AB 60 AB 68 10 F4 80 6F 18 BF 01 22 08 BF 00 22 83 EA 82 03 03 F0 04 02 AB 68 53 40 AB 60 AB 68 10 F4 00 7F 18 BF 01 22 08 BF 00 22 83 EA C2 03 03 EA 01 02 AB 68 53 40 AB 60 AB 68 10 F4 80 7F 18 BF 01 22 08 BF 00 22 83 EA 02 13 03 EA 04 02 AB 68 53 40 AB 60 EB 68 20 42 18 BF 01 22 08 BF 00 22 62 F3 00 03 EB 60 EB 68 08 42 18 BF 01 22 08 BF 00 22 83 EA 42 03 03 F0 02 02 EB 68 53 40 EB 60 EB 68 10 F0 04 0F 18 BF 01 22 08 BF 00 22 83 EA 82 03 03 F0 04 02 EB 68 53 40 EB 60 EB 68 10 F0 02 0F 18 BF 01 22 08 BF 00 22 83 EA C2 03 03 EA 01 02 EB 68 53 40 01 21 08 42 EB 60 EB 68 18 BF 01 22 08 BF 00 22 83 EA 02 13 03 EA 04 02 EB 68 53 40 EB 60 B9 F1 1A 0F 7C D8 DF E8 09 F0 0E 14 0E 14 0E 14 0E 14 0E 0E 0E 0E 0E 18 0E 14 14 14 14 14 14 1C 20 20 22 22 0E 0E 97 ED 0E 0B 03 22 85 ED 04 0B 12 E0 BB 6B 01 22 2B 61 0E E0 BB 6B 0B 22 2B 61 0A E0 BB 6B 11 22 2B 61 06 E0 0D 22 00 E0 13 22 BB 6B 2B 61 FB 6B 6B 61 2B 6A 62 F3 04 03 2B 62 DF E8 09 F0 0E 17 0E 17 0E 17 0E 17 1B 1B 1B 1B 1B 1B 0E 17 1B 1B 1B 1B 1B 1B 1B 1B 1B 1B 1B 1B 97 ED 10 0B 03 22 85 ED 0C 0B 2B 6C 62 F3 04 03 05 E0 3B 6C 01 22 2B 63 F7 E7 2B 6C 8B 43 2B 64 DF E8 09 F0 0E 14 0E 14 27 27 0E 14 16 1B 14 18 21 14 0E 14 0E 16 1B 18 21 14 0E 14 0E 14 0E 0E 97 ED 12 0B 03 22 85 ED 14 0B 15 E0 01 22 11 E0 0B 22 0F E0 BB 6C 11 22 0D E0 BB 6C 0D 22 2B 65 FB 6C 6B 65 08 E0 BB 6C 13 22 2B 65 FB 6C 6B 65 02 E0 17 22 BB 6C 2B 65 2B 6E 62 F3 04 03 2B 66 3B 4C 3B 46 01 22 24 68 00 21 70 46 A0 47 2B 68 00 22 13 F0 03 03 0B D0 01 2B 08 D0 02 2B 03 D0 03 2B 05 D1 42 46 03 E0 A8 F5 00 02 00 E0 52 46 AB 68 13 F0 01 0F 02 D0 4F F4 80 53 00 E0 00 23 1A 43 AB 68 13 F0 02 0F 02 D0 4F F4 00 63 00 E0 00 23 1A 43 AB 68 13 F0 04 0F 02 D0 4F F4 80 63 00 E0 00 23 1A 43 AB 68 13 F0 08 0F 02 D0 4F F4 00 73 00 E0 00 23 1A 43 AB 68 13 F0 10 0F 02 D0 4F F4 80 73 00 E0 00 23 1A 43 B9 F1 1A 0F 1D D8 DF E8 09 F0 0E 1A 0E 1A 1A 1A 0E 1A 1A 15 1A 13 15 1A 0E 1A 0E 1A 15 13 15 1A 0E 1A 0E 1A 0E 0E 95 ED 14 0B 87 ED 12 0B 08 E0 2B 6D 05 E0 2B 6D BB 64 6B 6D FB 64 01 E0 2B 6D BB 64 82 F4 1F 43 E1 EE 10 3A BB 6C 30 46 33 60 FB 6C 73 60 BD 46 02 B0 ?? ?? ?? ?? BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? 8F 00 00 C0 93 00 00 C0 91 00 00 C0 8E 00 00 C0 90 00 00 C0 }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "_strxfrm_l"
		size = 242
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 002a _errno 0032 _invalid_parameter_noinfo 0056 strncpy 005c strlen 0086 __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8B B0 88 46 05 46 06 A8 19 46 16 46 ?? ?? ?? ?? 6F F0 00 44 A6 42 04 D8 05 B9 16 B9 B8 F1 00 0F 06 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 35 E0 4F F0 00 09 15 B1 0E B1 85 F8 00 90 07 9A D2 F8 A4 10 59 B9 13 69 4B B9 32 46 41 46 28 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 04 46 1F E0 13 69 4F F0 01 0A 07 A8 03 93 6F F0 00 03 00 93 43 46 4F F4 80 62 CD F8 10 A0 CD F8 08 90 CD F8 04 90 ?? ?? ?? ?? 07 46 67 B3 B7 42 16 D9 35 B1 2E B1 85 F8 00 90 ?? ?? ?? ?? 22 23 03 60 7C 1E 9D F8 24 30 33 B1 06 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 0B B0 BD E8 F0 8F 07 99 07 A8 4F F4 80 62 0B 69 D1 F8 A4 10 CD F8 10 A0 03 93 6F F0 00 03 00 93 43 46 02 96 01 95 ?? ?? ?? ?? 00 28 DC D1 ?? ?? ?? ?? 2A 23 03 60 D8 E7 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "??$common_tcsset_s@_W@@YAHQA_WI_W@Z"
		size = 60
		refs = "0026 _errno 002e _invalid_parameter_noinfo"
		altNames = "_wcsset_s"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 68 B1 61 B1 03 88 04 46 04 E0 49 1E 04 D0 22 80 34 F8 02 3F 00 2B F8 D1 51 B9 00 23 03 80 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 BD E8 18 88 00 20 FB E7 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "_FCosh"
		size = 208
		refs = "0012 _fdtest 0056 _fdexp 00b0 _fperrraise 00c4 _FNan_C 00c8 _FInf_C 00cc _FXbig_C"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 68 46 CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? 04 46 01 A8 ?? ?? ?? ?? 00 2C 2E DA 00 28 2C DA DD ED 00 0A F5 EE C0 0A F1 EE 10 FA 03 D2 F1 EE 60 0A CD ED 00 0A 23 4B 6F F0 00 01 93 ED 00 0A F4 EE C0 0A F1 EE 10 FA 11 D2 B7 EE 00 0A 68 46 ?? ?? ?? ?? 9D ED 00 1A B5 EE 00 0A DD ED 01 0A 80 EE 01 0A 30 EE 01 0A 20 EE 20 0A 25 E0 9D ED 01 0A 68 46 ?? ?? ?? ?? 01 E0 02 2C 02 D1 9D ED 00 0A 1A E0 02 28 16 D0 01 2C 14 D1 60 B1 9D ED 01 0A 0B 4B B5 EE C0 0A 93 ED 00 0A F1 EE 10 FA 0B D2 B1 EE 40 0A 08 E0 01 20 ?? ?? ?? ?? 03 4B 93 ED 00 0A 01 E0 9D ED 01 0A BD E8 1E 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "ccoshf"
		size = 332
		refs = "0016 crealf 002a cimagf 0034 _fdtest 0058 _fperrraise 00de sinf 00f4 cosf 010e _FSinh 0126 _FCosh 012e _FCbuild 013c _FInf_C 0140 _FNan_C 0148 _FZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 85 B0 CD ED 03 0A 8D ED 02 0A ?? ?? ?? ?? DD ED 03 0A B0 EE 40 1A 9D ED 02 0A 8D ED 01 1A ?? ?? ?? ?? 01 A8 8D ED 00 0A ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 06 D1 3E 4B 93 ED 00 0A 30 BB DD ED 00 0A 6D E0 01 28 24 D1 01 20 ?? ?? ?? ?? 94 B9 9D ED 00 0A B5 EE C0 0A F1 EE 10 FA 05 D2 36 4B 93 ED 00 0A F1 EE 40 0A 01 E0 DF ED 32 0A 30 4B 93 ED 00 0A 54 E0 2E 4B 01 2C 05 D1 2C 4A D3 ED 00 0A 92 ED 00 0A 4B E0 93 ED 00 0A F0 EE 40 0A 46 E0 02 28 05 D1 26 4B 00 2C ED D1 DD ED 01 0A E6 E7 01 2C 24 D1 78 B9 9D ED 01 0A B5 EE C0 0A F1 EE 10 FA 04 D2 9D ED 00 0A F1 EE 40 0A 01 E0 DD ED 00 0A 1A 4B D3 E7 9D ED 00 8A B0 EE 48 0A ?? ?? ?? ?? 16 4B F0 EE 40 0A B0 EE 48 0A D3 ED 00 8A 20 EE A8 8A ?? ?? ?? ?? 20 EE 28 0A 15 E0 9D ED 00 0A ?? ?? ?? ?? F0 EE 40 0A 9D ED 01 0A ?? ?? ?? ?? B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F0 EE 40 0A 9D ED 01 0A ?? ?? ?? ?? F0 EE 48 0A ?? ?? ?? ?? 05 B0 BD EC 02 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "__wcsncnt"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 02 46 13 88 00 20 04 E0 88 42 04 D0 32 F8 02 3F 40 1C 00 2B F8 D1 BD E8 00 88 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "fegetenv"
		size = 28
		refs = "000a _getfpcontrolword 0010 _getfpstatusword"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 20 60 ?? ?? ?? ?? 60 60 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_70_5_0 {
	meta:
		name = "_mbctolower_l"
		size = 138
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 004c __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 8C B0 04 46 08 A8 ?? ?? ?? ?? 02 25 FF 2C 23 D9 0A 9A 23 0A DB B2 8D F8 18 30 13 44 8D F8 19 40 5B 7E 13 F0 04 0F 1F D0 01 23 04 93 53 68 D2 F8 1C 12 09 A8 03 93 07 AB 01 93 06 AB 4F F4 80 72 02 95 00 95 ?? ?? ?? ?? 70 B1 9D F8 1C 20 9D F8 1D 30 03 EB 02 24 07 E0 0A 9B 1A 19 53 7E 13 F0 10 0F 01 D0 92 F8 19 41 9D F8 2C 30 2B B1 08 9A D2 F8 50 33 AB 43 C2 F8 50 33 20 46 0C B0 BD E8 30 88 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "_dpow"
		size = 1372
		refs = "000e __security_push_cookie 002c _dunscale 0036 _d_int 00a8 _fperrraise 0150 _dlogpoly 01a8 lnbias 01c4 _Nan_C 028e _dxp_setw 02a6 _dxp_addx 02de _dxp_mulh 0348 _dxp_addh 03ea _dxp_getw 041a _dexp 049e __security_pop_cookie 0530 _Inf_C 0534 _Zero_C 0540 log2e"
	strings:
		$1 = { 03 B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 0E 8B ?? ?? ?? ?? B0 B0 80 46 68 46 02 A9 B0 EE 41 AB 8D ED 08 1B 8D ED 02 0B 8D ED 06 1B 00 26 ?? ?? ?? ?? 05 46 06 A8 00 21 ?? ?? ?? ?? 04 46 B8 F1 00 0F 02 D0 00 23 A8 F8 00 30 24 B9 B5 EE 40 AB F1 EE 10 FA 18 D0 9D ED 02 3B BD F9 00 20 B6 EE 00 BB 00 2D 80 F2 F6 81 01 2A 10 D1 B4 EE 4B 3B F1 EE 10 FA 08 D0 01 2C 09 D1 BE EE 00 0B B4 EE 40 3B F1 EE 10 FA 02 D1 B7 EE 00 3B 05 E2 00 2D 80 F2 E0 81 00 2C 00 F3 DD 81 BD F8 0E 30 13 F4 00 4F 06 D0 00 2C 04 DA 01 20 ?? ?? ?? ?? 45 4B F1 E1 B5 EE C0 3B 6F F0 00 07 F1 EE 10 FA 02 DD 00 23 0B 93 0C E0 B1 EE 43 0B 06 A8 39 46 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 3B BD F9 00 20 0B 90 B7 EE 00 EB B0 EE 00 DB 01 2A 0C D1 9F ED 34 0B B4 EE C0 3B F1 EE 10 FA 05 D2 00 22 B0 EE 4E CB 23 EE 0D 3B 15 E0 9F ED 2B 0B B0 EE 4B 1B 9F ED 27 2B B0 EE 4B CB 03 EE 00 1B BD EE C1 0B 10 EE 10 3A A3 F1 20 02 00 EE 10 2A B8 EE C0 0B 00 EE 02 CB 33 EE 4C 1B 3C EE 03 0B 1B 4B 8D ED 02 1B 81 EE 00 9B 03 EB 42 14 08 94 29 EE 09 8B B0 EE 48 0B ?? ?? ?? ?? 9D ED 02 4B 20 EE 08 0B 3E EE 4C 2B BD F9 00 30 94 ED 00 3B 30 EE 44 1B 9F ED 0C CB 00 EE 10 3A 02 EE 0D 1B B8 EE C0 0B 21 EE 09 9B 30 EE 03 5B 9F ED 04 8B 9F ED 01 1B 1C E0 FE DE 00 00 00 00 00 00 E0 C0 00 00 00 00 00 00 00 00 EF 39 FA FE 42 2E E6 3F ?? ?? ?? ?? 00 00 00 00 00 00 90 3F 00 00 00 00 00 00 50 40 CD 3B 7F 66 9E A0 E6 3F ?? ?? ?? ?? 39 EE 04 6B 86 EE 0C 0B 30 EE 05 0B 20 EE 0A 3B 8D ED 06 0B B4 EE C1 3B 8D ED 04 3B F1 EE 10 FA 38 BF 00 27 C0 F0 09 81 BA EE 0E 0B B4 EE C3 0B F1 EE 10 FA 39 D8 B2 EE 0E 0B B4 EE C0 3B F1 EE 10 FA 32 D8 9F ED D1 0B B4 EE CA 0B F1 EE 10 FA 2B D2 9F ED CC 0B B4 EE C0 AB F1 EE 10 FA 24 D2 B5 EE C0 3B F1 EE 10 FA 02 D2 33 EE 4B 0B 01 E0 33 EE 0B 0B BD EE C0 0B 94 ED 04 2B 94 ED 02 1B 10 EE 10 6A 26 EE 0A 3B 32 EE 01 0B 01 EE 10 6A 20 EE 0A 2B B8 EE C1 1B 25 EE 0A 0B 02 EE 0C 3B 30 EE 41 0B 00 EE 0C 3B C5 E0 9F ED B4 0B B4 EE C3 0B F1 EE 10 FA 38 BF 01 27 C0 F0 BE 80 20 A8 B0 EE 44 0B 04 21 ?? ?? ?? ?? 0C A8 B0 EE 49 0B 02 21 ?? ?? ?? ?? 0C AA 20 A8 02 23 04 21 ?? ?? ?? ?? 9D ED 20 0B B5 EE 40 0B F1 EE 10 FA 06 D1 10 A8 04 21 B0 EE 48 0B ?? ?? ?? ?? 32 E0 DF F8 78 92 10 AC 99 E8 0F 00 4D 46 10 35 0F C4 0F CD 0F C4 10 A8 04 21 ?? ?? ?? ?? 01 23 0A 93 0D F1 88 0A 9A ED 00 0B B5 EE 40 0B F1 EE 10 FA 18 D0 99 E8 0F 00 4E 46 28 AD 10 36 0F C5 1B CE 1B C5 04 21 28 A8 ?? ?? ?? ?? 04 23 28 AA 04 21 10 A8 ?? ?? ?? ?? 0A 9B 0A F1 08 0A 5B 1C 0A 93 04 2B DF DB 08 9C 10 A8 03 23 22 46 04 21 ?? ?? ?? ?? BD F9 00 30 10 A8 04 21 00 EE 10 3A B8 EE C0 0B ?? ?? ?? ?? 20 A8 B0 EE 4A 0B 02 21 ?? ?? ?? ?? 10 AC 0F CC 18 AD 0F C5 0F CC 9D ED 20 0B 0F C5 18 A8 04 21 ?? ?? ?? ?? 9D ED 22 0B B5 EE 40 0B F1 EE 10 FA 0F D0 10 AC 0F CC 28 AD 0F C5 0F CC 0F C5 28 A8 04 21 ?? ?? ?? ?? 28 AA 18 A8 04 23 04 21 ?? ?? ?? ?? 9D ED 18 1B B5 EE 40 1B 8D ED 02 1B F1 EE 10 FA 0E D0 9D ED 1A 2B B5 EE 40 2B F1 EE 10 FA 07 D0 9D ED 1C 0B 30 EE 02 0B 30 EE 01 0B 8D ED 02 0B 02 A8 00 21 ?? ?? ?? ?? 9D ED 02 0B 18 A8 04 21 B1 EE 40 0B ?? ?? ?? ?? 04 21 18 A8 ?? ?? ?? ?? 9D ED 02 2B 20 EE 0C 3B BD EE C2 2B 12 EE 10 6A 8D ED 04 3B 00 2F 0F DA B8 F1 00 0F 02 D0 A8 F8 00 60 00 26 04 A8 31 46 B0 EE 4E 0B ?? ?? ?? ?? 07 46 9D ED 04 3B 00 2F 08 D0 01 2F 0D D1 40 4B 08 20 93 ED 00 0B 8D ED 04 0B 02 E0 10 20 8D ED 04 8B ?? ?? ?? ?? 9D ED 04 3B 0B 9B 2B B3 B1 EE 43 3B 22 E0 02 2D 20 D0 02 2C 02 D1 B0 EE 4A 3B 1B E0 01 2D 2F D1 BD F8 0E 30 4F F4 00 45 2B 42 BD F8 26 30 04 D1 2B 42 0C D0 9F ED 2F 3B 0C E0 2B 42 15 D1 34 B9 06 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 47 DB 27 4B 93 ED 00 3B B0 EE 43 0B 30 B0 ?? ?? ?? ?? BD EC 0E 8B BD E8 F0 0F 5D F8 0C FB 00 2C E2 D1 06 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 DB DA 1C 4B 2F E0 BD F8 26 30 01 2C 08 D1 13 F4 00 4F 02 D1 00 2A DD DC CF E7 00 2A DA DD CC E7 4F F4 00 45 2B 42 0D D1 00 2C C6 D1 06 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 BF DA BD F8 0E 30 2B 42 BB D0 DE E7 04 20 ?? ?? ?? ?? 00 2C C2 D1 06 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 BB DA BD F8 0E 30 2B 42 B7 D0 03 4B 93 ED 00 0B B1 EE 40 3B B4 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 E0 40 00 00 00 00 00 00 44 40 00 00 00 00 00 00 44 C0 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "_ldpow"
		size = 1372
		refs = "000e __security_push_cookie 002c _ldunscale 0036 _ld_int 00a8 _fperrraise 0150 _ldlogpoly 01a8 lnbias 01c4 _LNan_C 028e _ldxp_setw 02a6 _ldxp_addx 02de _ldxp_mulh 0348 _ldxp_addh 03ea _ldxp_getw 041a _ldexp 049e __security_pop_cookie 0530 _LInf_C 0534 _LZero_C 0540 log2e"
	strings:
		$1 = { 03 B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 0E 8B ?? ?? ?? ?? B0 B0 80 46 68 46 02 A9 B0 EE 41 AB 8D ED 08 1B 8D ED 02 0B 8D ED 06 1B 00 26 ?? ?? ?? ?? 05 46 06 A8 00 21 ?? ?? ?? ?? 04 46 B8 F1 00 0F 02 D0 00 23 A8 F8 00 30 24 B9 B5 EE 40 AB F1 EE 10 FA 18 D0 9D ED 02 3B BD F9 00 20 B6 EE 00 BB 00 2D 80 F2 F6 81 01 2A 10 D1 B4 EE 4B 3B F1 EE 10 FA 08 D0 01 2C 09 D1 BE EE 00 0B B4 EE 40 3B F1 EE 10 FA 02 D1 B7 EE 00 3B 05 E2 00 2D 80 F2 E0 81 00 2C 00 F3 DD 81 BD F8 0E 30 13 F4 00 4F 06 D0 00 2C 04 DA 01 20 ?? ?? ?? ?? 45 4B F1 E1 B5 EE C0 3B 6F F0 00 07 F1 EE 10 FA 02 DD 00 23 0B 93 0C E0 B1 EE 43 0B 06 A8 39 46 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 3B BD F9 00 20 0B 90 B7 EE 00 EB B0 EE 00 DB 01 2A 0C D1 9F ED 34 0B B4 EE C0 3B F1 EE 10 FA 05 D2 00 22 B0 EE 4E CB 23 EE 0D 3B 15 E0 9F ED 2B 0B B0 EE 4B 1B 9F ED 27 2B B0 EE 4B CB 03 EE 00 1B BD EE C1 0B 10 EE 10 3A A3 F1 20 02 00 EE 10 2A B8 EE C0 0B 00 EE 02 CB 33 EE 4C 1B 3C EE 03 0B 1B 4B 8D ED 02 1B 81 EE 00 9B 03 EB 42 14 08 94 29 EE 09 8B B0 EE 48 0B ?? ?? ?? ?? 9D ED 02 4B 20 EE 08 0B 3E EE 4C 2B BD F9 00 30 94 ED 00 3B 30 EE 44 1B 9F ED 0C CB 00 EE 10 3A 02 EE 0D 1B B8 EE C0 0B 21 EE 09 9B 30 EE 03 5B 9F ED 04 8B 9F ED 01 1B 1C E0 FE DE 00 00 00 00 00 00 E0 C0 00 00 00 00 00 00 00 00 EF 39 FA FE 42 2E E6 3F ?? ?? ?? ?? 00 00 00 00 00 00 90 3F 00 00 00 00 00 00 50 40 CD 3B 7F 66 9E A0 E6 3F ?? ?? ?? ?? 39 EE 04 6B 86 EE 0C 0B 30 EE 05 0B 20 EE 0A 3B 8D ED 06 0B B4 EE C1 3B 8D ED 04 3B F1 EE 10 FA 38 BF 00 27 C0 F0 09 81 BA EE 0E 0B B4 EE C3 0B F1 EE 10 FA 39 D8 B2 EE 0E 0B B4 EE C0 3B F1 EE 10 FA 32 D8 9F ED D1 0B B4 EE CA 0B F1 EE 10 FA 2B D2 9F ED CC 0B B4 EE C0 AB F1 EE 10 FA 24 D2 B5 EE C0 3B F1 EE 10 FA 02 D2 33 EE 4B 0B 01 E0 33 EE 0B 0B BD EE C0 0B 94 ED 04 2B 94 ED 02 1B 10 EE 10 6A 26 EE 0A 3B 32 EE 01 0B 01 EE 10 6A 20 EE 0A 2B B8 EE C1 1B 25 EE 0A 0B 02 EE 0C 3B 30 EE 41 0B 00 EE 0C 3B C5 E0 9F ED B4 0B B4 EE C3 0B F1 EE 10 FA 38 BF 01 27 C0 F0 BE 80 20 A8 B0 EE 44 0B 04 21 ?? ?? ?? ?? 0C A8 B0 EE 49 0B 02 21 ?? ?? ?? ?? 0C AA 20 A8 02 23 04 21 ?? ?? ?? ?? 9D ED 20 0B B5 EE 40 0B F1 EE 10 FA 06 D1 10 A8 04 21 B0 EE 48 0B ?? ?? ?? ?? 32 E0 DF F8 78 92 10 AC 99 E8 0F 00 4D 46 10 35 0F C4 0F CD 0F C4 10 A8 04 21 ?? ?? ?? ?? 01 23 0A 93 0D F1 88 0A 9A ED 00 0B B5 EE 40 0B F1 EE 10 FA 18 D0 99 E8 0F 00 4E 46 28 AD 10 36 0F C5 1B CE 1B C5 04 21 28 A8 ?? ?? ?? ?? 04 23 28 AA 04 21 10 A8 ?? ?? ?? ?? 0A 9B 0A F1 08 0A 5B 1C 0A 93 04 2B DF DB 08 9C 10 A8 03 23 22 46 04 21 ?? ?? ?? ?? BD F9 00 30 10 A8 04 21 00 EE 10 3A B8 EE C0 0B ?? ?? ?? ?? 20 A8 B0 EE 4A 0B 02 21 ?? ?? ?? ?? 10 AC 0F CC 18 AD 0F C5 0F CC 9D ED 20 0B 0F C5 18 A8 04 21 ?? ?? ?? ?? 9D ED 22 0B B5 EE 40 0B F1 EE 10 FA 0F D0 10 AC 0F CC 28 AD 0F C5 0F CC 0F C5 28 A8 04 21 ?? ?? ?? ?? 28 AA 18 A8 04 23 04 21 ?? ?? ?? ?? 9D ED 18 1B B5 EE 40 1B 8D ED 02 1B F1 EE 10 FA 0E D0 9D ED 1A 2B B5 EE 40 2B F1 EE 10 FA 07 D0 9D ED 1C 0B 30 EE 02 0B 30 EE 01 0B 8D ED 02 0B 02 A8 00 21 ?? ?? ?? ?? 9D ED 02 0B 18 A8 04 21 B1 EE 40 0B ?? ?? ?? ?? 04 21 18 A8 ?? ?? ?? ?? 9D ED 02 2B 20 EE 0C 3B BD EE C2 2B 12 EE 10 6A 8D ED 04 3B 00 2F 0F DA B8 F1 00 0F 02 D0 A8 F8 00 60 00 26 04 A8 31 46 B0 EE 4E 0B ?? ?? ?? ?? 07 46 9D ED 04 3B 00 2F 08 D0 01 2F 0D D1 40 4B 08 20 93 ED 00 0B 8D ED 04 0B 02 E0 10 20 8D ED 04 8B ?? ?? ?? ?? 9D ED 04 3B 0B 9B 2B B3 B1 EE 43 3B 22 E0 02 2D 20 D0 02 2C 02 D1 B0 EE 4A 3B 1B E0 01 2D 2F D1 BD F8 0E 30 4F F4 00 45 2B 42 BD F8 26 30 04 D1 2B 42 0C D0 9F ED 2F 3B 0C E0 2B 42 15 D1 34 B9 06 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 47 DB 27 4B 93 ED 00 3B B0 EE 43 0B 30 B0 ?? ?? ?? ?? BD EC 0E 8B BD E8 F0 0F 5D F8 0C FB 00 2C E2 D1 06 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 DB DA 1C 4B 2F E0 BD F8 26 30 01 2C 08 D1 13 F4 00 4F 02 D1 00 2A DD DC CF E7 00 2A DA DD CC E7 4F F4 00 45 2B 42 0D D1 00 2C C6 D1 06 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 BF DA BD F8 0E 30 2B 42 BB D0 DE E7 04 20 ?? ?? ?? ?? 00 2C C2 D1 06 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 BB DA BD F8 0E 30 2B 42 B7 D0 03 4B 93 ED 00 0B B1 EE 40 3B B4 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 E0 40 00 00 00 00 00 00 44 40 00 00 00 00 00 00 44 C0 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "_dtgamma"
		size = 332
		refs = "0026 stirling 0102 _dunscale 0116 _dpoly 013c c 0140 s"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 04 8B 83 B0 9F ED 4D 0B 90 ED 00 9B 04 46 08 46 B4 EE C9 0B F1 EE 10 FA 03 D8 20 46 ?? ?? ?? ?? 82 E0 BE EE 00 0B B4 EE C0 9B F1 EE 10 FA 18 D2 B6 EE 00 2B B0 EE 49 1B B4 EE C9 2B 8D ED 00 9B F1 EE 10 FA B7 EE 00 0B 53 D3 39 EE 00 9B B4 EE C9 2B 21 EE 09 1B F1 EE 10 FA F6 D2 8D ED 00 1B 47 E0 B6 EE 00 0B B4 EE C0 9B F1 EE 10 FA 08 D2 B7 EE 00 0B 30 EE 09 0B 20 EE 09 0B 8D ED 00 0B 39 E0 B7 EE 08 0B B4 EE C0 9B F1 EE 10 FA 06 D2 B7 EE 00 0B B0 EE 49 1B 8D ED 00 9B 0C E0 B0 EE 04 1B B4 EE C1 9B F1 EE 10 FA 0A D2 B7 EE 00 1B B0 EE 00 0B 8D ED 00 1B 00 23 03 80 39 EE 40 9B 1E E0 B7 EE 00 0B B4 EE C9 1B B0 EE 40 2B 8D ED 00 0B F1 EE 10 FA 0A D2 39 EE 40 9B B4 EE C9 1B 82 EE 09 2B F1 EE 10 FA F6 D3 8D ED 00 2B B0 EE 00 0B 39 EE 40 9B 69 46 ?? ?? ?? ?? 9D ED 00 1B 0D 48 07 21 B0 EE 49 0B 84 ED 00 1B ?? ?? ?? ?? 08 48 B0 EE 40 8B B0 EE 49 0B 06 21 ?? ?? ?? ?? 88 EE 00 0B 20 EE 09 0B 03 B0 BD EC 04 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4B 40 }
	condition:
		$1
}

rule file_318_1_0 {
	meta:
		name = "_ldtgamma"
		size = 332
		refs = "0026 stirling 0102 _ldunscale 0116 _ldpoly 013c c 0140 s"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 04 8B 83 B0 9F ED 4D 0B 90 ED 00 9B 04 46 08 46 B4 EE C9 0B F1 EE 10 FA 03 D8 20 46 ?? ?? ?? ?? 82 E0 BE EE 00 0B B4 EE C0 9B F1 EE 10 FA 18 D2 B6 EE 00 2B B0 EE 49 1B B4 EE C9 2B 8D ED 00 9B F1 EE 10 FA B7 EE 00 0B 53 D3 39 EE 00 9B B4 EE C9 2B 21 EE 09 1B F1 EE 10 FA F6 D2 8D ED 00 1B 47 E0 B6 EE 00 0B B4 EE C0 9B F1 EE 10 FA 08 D2 B7 EE 00 0B 30 EE 09 0B 20 EE 09 0B 8D ED 00 0B 39 E0 B7 EE 08 0B B4 EE C0 9B F1 EE 10 FA 06 D2 B7 EE 00 0B B0 EE 49 1B 8D ED 00 9B 0C E0 B0 EE 04 1B B4 EE C1 9B F1 EE 10 FA 0A D2 B7 EE 00 1B B0 EE 00 0B 8D ED 00 1B 00 23 03 80 39 EE 40 9B 1E E0 B7 EE 00 0B B4 EE C9 1B B0 EE 40 2B 8D ED 00 0B F1 EE 10 FA 0A D2 39 EE 40 9B B4 EE C9 1B 82 EE 09 2B F1 EE 10 FA F6 D3 8D ED 00 2B B0 EE 00 0B 39 EE 40 9B 69 46 ?? ?? ?? ?? 9D ED 00 1B 0D 48 07 21 B0 EE 49 0B 84 ED 00 1B ?? ?? ?? ?? 08 48 B0 EE 40 8B B0 EE 49 0B 06 21 ?? ?? ?? ?? 88 EE 00 0B 20 EE 09 0B 03 B0 BD EC 04 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4B 40 }
	condition:
		$1
}

rule file_71_2_0 {
	meta:
		name = "stirling"
		size = 160
		refs = "0022 _dpow 004c _dpoly 006c exp 0094 approx0"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 2D ED 08 8B 90 ED 00 BB B6 EE 00 0B 06 46 08 46 3B EE 40 1B B0 EE 4B 0B 0D 46 ?? ?? ?? ?? B7 EE 00 1B B5 F9 00 30 81 EE 0B 2B 9F ED 19 1B 17 4C 5B 42 2B 80 32 EE 41 9B A0 69 B0 EE 40 AB B0 EE 49 0B 01 21 ?? ?? ?? ?? 20 69 B0 EE 40 8B B0 EE 49 0B 0D 21 ?? ?? ?? ?? B0 EE 40 1B B1 EE 4B 0B 88 EE 01 8B ?? ?? ?? ?? B0 EE 40 1B 9F ED 05 0B 21 EE 0A 1B 88 EE 01 1B 86 ED 00 1B BD EC 08 8B BD E8 78 88 00 00 00 00 00 00 00 00 ?? ?? ?? ?? DF 4A 35 D3 E6 E2 86 3F }
	condition:
		$1
}

rule file_318_3_0 {
	meta:
		name = "stirling"
		size = 160
		refs = "0022 _ldpow 004c _ldpoly 006c exp 0094 approx0"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 2D ED 08 8B 90 ED 00 BB B6 EE 00 0B 06 46 08 46 3B EE 40 1B B0 EE 4B 0B 0D 46 ?? ?? ?? ?? B7 EE 00 1B B5 F9 00 30 81 EE 0B 2B 9F ED 19 1B 17 4C 5B 42 2B 80 32 EE 41 9B A0 69 B0 EE 40 AB B0 EE 49 0B 01 21 ?? ?? ?? ?? 20 69 B0 EE 40 8B B0 EE 49 0B 0D 21 ?? ?? ?? ?? B0 EE 40 1B B1 EE 4B 0B 88 EE 01 8B ?? ?? ?? ?? B0 EE 40 1B 9F ED 05 0B 21 EE 0A 1B 88 EE 01 1B 86 ED 00 1B BD EC 08 8B BD E8 78 88 00 00 00 00 00 00 00 00 ?? ?? ?? ?? DF 4A 35 D3 E6 E2 86 3F }
	condition:
		$1
}

rule file_71_3_0 {
	meta:
		name = "tgamma"
		size = 500
		refs = "0018 _d_int 003c _fperrraise 00fe _dsin 0126 _dtgamma 0148 _dscale 01c8 _Inf_C 01dc _dgamma_big 01f0 _Nan_C"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 8A B0 06 A8 00 21 8D ED 02 0B 8D ED 06 0B ?? ?? ?? ?? 9D ED 02 2B 80 B1 01 28 04 D0 02 28 25 D1 9D ED 02 0B C5 E0 BD F8 0E 30 13 F4 00 4F F7 D0 01 20 ?? ?? ?? ?? 6B 4B B9 E0 B5 EE 40 2B F1 EE 10 FA 0E D1 04 20 ?? ?? ?? ?? BD F8 0E 30 13 F4 00 4F 5A 4B 93 ED 00 0B 00 F0 AB 80 B1 EE 40 0B A7 E0 B5 EE C0 2B F1 EE 10 FA E1 D3 9F ED 5C 0B B4 EE C0 2B F1 EE 10 FA 05 D8 10 20 ?? ?? ?? ?? 9F ED 55 0B 95 E0 52 4B 93 ED 00 0B B1 EE 40 0B B4 EE C0 2B F1 EE 10 FA 5E D2 9D ED 06 0B B1 EE 42 1B B7 EE 00 9B 04 A8 32 EE 40 0B 31 EE 49 1B 6F F0 00 01 8D ED 06 0B 8D ED 04 2B 8D ED 08 1B ?? ?? ?? ?? 9D ED 02 2B 9D ED 04 0B BF EE 00 1B 32 EE 40 0B B4 EE C1 0B 9D ED 06 0B F1 EE 10 FA 03 D2 B1 EE 40 0B 8D ED 06 0B 9F ED 37 8B 00 20 20 EE 08 0B ?? ?? ?? ?? 9D ED 02 2B 69 46 08 A8 B1 EE 42 1B 20 EE 02 2B 31 EE 49 0B 20 EE 02 0B B1 EE 40 0B 88 EE 00 0B 8D ED 04 0B ?? ?? ?? ?? 9D ED 04 2B 30 EE 09 0B 9D ED 08 1B BD F9 00 10 82 EE 00 0B 04 A8 20 EE 01 0B 8D ED 04 0B ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 04 0B 2C E0 9F ED 1A 0B B4 EE C0 2B F1 EE 10 FA 1F D8 69 46 02 A8 ?? ?? ?? ?? B7 EE 00 2B 9D ED 02 1B 8D ED 06 0B 30 EE 02 0B BD F9 00 30 02 A8 80 EE 01 0B 59 42 8D ED 02 0B ?? ?? ?? ?? 20 B1 01 28 7F F4 43 AF 08 20 00 E0 10 20 ?? ?? ?? ?? 3C E7 08 20 ?? ?? ?? ?? 04 4B 93 ED 00 0B 0A B0 BD EC 04 8B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 00 00 00 C0 65 40 18 2D 44 54 FB 21 09 40 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 C0 65 C0 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_318_4_0 {
	meta:
		name = "tgammal"
		size = 500
		refs = "0018 _ld_int 003c _fperrraise 00fe _ldsin 0126 _ldtgamma 0148 _ldscale 01c8 _LInf_C 01dc _ldgamma_big 01f0 _LNan_C"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 8A B0 06 A8 00 21 8D ED 02 0B 8D ED 06 0B ?? ?? ?? ?? 9D ED 02 2B 80 B1 01 28 04 D0 02 28 25 D1 9D ED 02 0B C5 E0 BD F8 0E 30 13 F4 00 4F F7 D0 01 20 ?? ?? ?? ?? 6B 4B B9 E0 B5 EE 40 2B F1 EE 10 FA 0E D1 04 20 ?? ?? ?? ?? BD F8 0E 30 13 F4 00 4F 5A 4B 93 ED 00 0B 00 F0 AB 80 B1 EE 40 0B A7 E0 B5 EE C0 2B F1 EE 10 FA E1 D3 9F ED 5C 0B B4 EE C0 2B F1 EE 10 FA 05 D8 10 20 ?? ?? ?? ?? 9F ED 55 0B 95 E0 52 4B 93 ED 00 0B B1 EE 40 0B B4 EE C0 2B F1 EE 10 FA 5E D2 9D ED 06 0B B1 EE 42 1B B7 EE 00 9B 04 A8 32 EE 40 0B 31 EE 49 1B 6F F0 00 01 8D ED 06 0B 8D ED 04 2B 8D ED 08 1B ?? ?? ?? ?? 9D ED 02 2B 9D ED 04 0B BF EE 00 1B 32 EE 40 0B B4 EE C1 0B 9D ED 06 0B F1 EE 10 FA 03 D2 B1 EE 40 0B 8D ED 06 0B 9F ED 37 8B 00 20 20 EE 08 0B ?? ?? ?? ?? 9D ED 02 2B 69 46 08 A8 B1 EE 42 1B 20 EE 02 2B 31 EE 49 0B 20 EE 02 0B B1 EE 40 0B 88 EE 00 0B 8D ED 04 0B ?? ?? ?? ?? 9D ED 04 2B 30 EE 09 0B 9D ED 08 1B BD F9 00 10 82 EE 00 0B 04 A8 20 EE 01 0B 8D ED 04 0B ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 04 0B 2C E0 9F ED 1A 0B B4 EE C0 2B F1 EE 10 FA 1F D8 69 46 02 A8 ?? ?? ?? ?? B7 EE 00 2B 9D ED 02 1B 8D ED 06 0B 30 EE 02 0B BD F9 00 30 02 A8 80 EE 01 0B 59 42 8D ED 02 0B ?? ?? ?? ?? 20 B1 01 28 7F F4 43 AF 08 20 00 E0 10 20 ?? ?? ?? ?? 3C E7 08 20 ?? ?? ?? ?? 04 4B 93 ED 00 0B 0A B0 BD EC 04 8B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 00 00 00 C0 65 40 18 2D 44 54 FB 21 09 40 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 C0 65 C0 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_3_0 {
	meta:
		name = "?__acrt_stdio_reset_buffer@@YAXV__crt_stdio_stream@@@Z"
		size = 28
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 90 43 68 00 22 03 60 02 9B 9A 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_72_11_0 {
	meta:
		name = "_fread_nolock"
		size = 28
		refs = "0014 _fread_nolock_s"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 1C 46 13 46 0A 46 6F F0 00 01 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_72_13_0 {
	meta:
		name = "fread"
		size = 28
		refs = "0014 fread_s"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 1C 46 13 46 0A 46 6F F0 00 01 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_72_12_0 {
	meta:
		name = "_fread_nolock_s"
		size = 578
		refs = "001a _errno 0022 _invalid_parameter_noinfo 0044 __rt_udiv 0058 memset 00fe memcpy 017c _fileno 0186 _read_nolock 019e __acrt_stdio_refill_and_read_narrow_nolock"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 87 B0 05 46 03 95 1C 46 91 46 0F 46 3A B1 34 B1 55 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 24 20 46 07 B0 BD E8 F0 8F DD F8 40 80 B8 F1 00 0F 08 D0 6F F0 00 01 48 46 00 B9 F9 DE ?? ?? ?? ?? 84 42 13 D9 17 F1 01 0F 04 D0 3A 46 00 21 28 46 ?? ?? ?? ?? B8 F1 00 0F DB D0 6F F0 00 01 48 46 00 B9 F9 DE ?? ?? ?? ?? 84 42 D2 D8 08 F1 0C 0E DE F8 00 30 CD F8 10 E0 BF F3 5B 8F 4F F4 98 61 0B 42 01 D0 01 23 00 E0 00 23 13 B1 D8 F8 18 20 01 E0 4F F4 80 52 09 FB 04 F0 2E 46 05 46 CD E9 01 20 00 28 00 96 BA 46 BA D0 DE F8 00 30 6F F0 00 40 BF F3 5B 8F 0B 42 01 D0 01 23 00 E0 00 23 FB B3 D8 F8 08 60 00 2E 3A D0 C0 F2 89 80 B5 42 00 D2 2E 46 56 45 77 D8 D8 F8 00 30 05 93 E6 B1 00 98 18 B9 ?? ?? ?? ?? 16 23 13 E0 33 B1 B2 45 04 D3 32 46 19 46 ?? ?? ?? ?? 0E E0 52 46 00 21 ?? ?? ?? ?? 05 9B 00 2B EC D0 B2 45 05 D2 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? D8 F8 08 30 AD 1B 01 9A 9B 1B C8 F8 08 30 D8 F8 00 30 AA EB 06 0A 33 44 C8 F8 00 30 00 9B 33 44 00 93 1E 46 3B E0 00 9E 95 42 26 D3 85 42 01 D9 06 46 00 E0 2E 46 32 B1 31 46 10 46 00 B9 F9 DE ?? ?? ?? ?? 76 1A 56 45 31 D8 D8 F8 04 30 40 46 C8 F8 00 30 00 23 C8 F8 08 30 ?? ?? ?? ?? 32 46 00 9E 31 46 ?? ?? ?? ?? 00 28 4D D0 40 DB 01 9A 2D 1A 06 44 AA EB 00 0A 10 E0 40 46 ?? ?? ?? ?? 10 F1 01 0F 2B D0 BA F1 00 0F 10 D0 06 F8 01 0B D8 F8 18 20 6D 1E AA F1 01 0A 01 92 00 96 00 2D 3F F4 31 AF 08 F1 0C 0E 4F F4 98 61 70 E7 17 F1 01 0F 04 D0 03 98 3A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 1B E7 BF F3 5B 8F 5E E8 00 1F 41 F0 10 02 4E E8 00 23 00 2B F7 D1 BF F3 5B 8F 02 9B 48 46 59 1B 00 B9 F9 DE ?? ?? ?? ?? 04 46 0A E7 BF F3 5B 8F 04 98 50 E8 00 1F 41 F0 10 02 40 E8 00 23 00 2B F7 D1 E8 E7 BF F3 5B 8F 04 98 50 E8 00 1F 41 F0 08 02 40 E8 00 23 00 2B F7 D1 DC E7 }
	condition:
		$1
}

rule file_72_14_0 {
	meta:
		name = "fread_s"
		size = 110
		refs = "0028 memset 002c _errno 0034 _invalid_parameter_noinfo 0040 _lock_file 004e _fread_nolock_s 0056 _unlock_file"
	strings:
		$1 = { 0F B4 2D E9 FC 4B 0D F1 20 0B 6F 46 82 B0 1E 46 91 46 0C 46 80 46 12 B3 0E B3 BD 6B 6D B9 B1 F1 FF 3F 03 D0 0A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 11 E0 00 23 7B 60 28 46 ?? ?? ?? ?? 00 95 33 46 4A 46 21 46 40 46 ?? ?? ?? ?? 78 60 B8 6B ?? ?? ?? ?? 7B 68 00 E0 00 23 3B 60 38 68 04 B0 BD E8 F0 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "asin"
		size = 600
		refs = "003a _handle_nan 0054 _controlfp_s 00c0 _handle_error 0238 ??_C@_04FIHNOPOL@asin?$AA@"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 04 8B 85 B0 51 EC 10 4B 90 4B 9F ED 8D 9B 21 F0 00 42 9A 42 B0 EE 40 8B 03 D3 00 D8 0C B1 01 20 00 E0 00 20 C1 F3 0A 53 A3 F2 FF 32 28 B1 20 46 ?? ?? ?? ?? B0 EE 40 8B BB E0 12 F1 1C 0F 07 DA 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? B0 E0 00 2A 33 DB B7 EE 00 0B B4 EE 40 8B F1 EE 10 FA 09 D1 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? 9F ED 72 8B 9D E0 BF EE 00 0B B4 EE 40 8B F1 EE 10 FA 09 D1 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? 9F ED 67 8B 8C E0 21 23 02 93 08 23 01 22 63 48 01 93 61 4B 03 92 00 92 00 22 B0 EE 49 1B B0 EE 48 0B 0E 21 ?? ?? ?? ?? BB E7 11 F0 00 43 01 D0 B1 EE 48 8B B2 F1 FF 3F 0D DB B7 EE 00 0B B6 EE 00 1B 30 EE 48 0B 01 23 20 EE 01 7B B1 EE C7 9B B0 EE 49 8B 02 E0 00 23 28 EE 08 7B 9F ED 4C 0B 9F ED 49 2B 9F ED 46 3B 9F ED 43 1B 9F ED 40 5B 07 EE 00 2B 9F ED 3C 4B 22 EE 07 0B 27 EE 01 2B 9F ED 37 1B 30 EE 43 0B 9F ED 33 3B 32 EE 41 1B 00 EE 07 5B 9F ED 2E 2B 01 EE 07 4B 25 EE 07 0B 24 EE 07 1B 30 EE 42 2B 9F ED 27 0B 02 EE 07 3B 9F ED 23 2B 31 EE 40 0B 23 EE 07 1B 00 EE 07 2B 81 EE 02 2B 2B B3 53 EC 19 2B B0 EE 00 6B 00 20 29 EE 06 0B 43 EC 11 0B 20 EE 02 5B 21 EE 01 0B 9F ED 15 4B 9F ED 12 3B 31 EE 09 2B 21 EE 06 1B 37 EE 40 0B 80 EE 02 0B 33 EE 41 1B 20 EE 06 0B 34 EE 40 0B 35 EE 40 0B 30 EE 41 0B 33 EE 40 8B 01 E0 02 EE 08 8B 11 F0 00 43 01 D0 B1 EE 48 8B B0 EE 48 0B 05 B0 BD EC 04 8B BD E8 10 88 FE DE 18 2D 44 54 FB 21 E9 3F 07 5C 14 33 26 A6 91 3C 28 F2 01 20 B1 D6 F5 3F EA CD 03 F9 46 46 0A 40 AC 9E 26 7E 29 7B DC 3F 34 98 02 80 41 1E CD 3F 8D F7 18 B4 4A 32 EE 3F FC CC 1D 57 21 20 06 40 59 EF B7 C1 BE A2 D1 3F 76 CE 82 29 42 1A BB 3F 90 96 C2 90 D3 28 AC 3F 35 21 A6 87 F8 E5 51 3F 61 10 32 5D 66 51 09 3F 00 00 F8 FF ?? ?? ?? ?? 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 F9 3F 00 00 00 00 00 00 00 00 00 00 F0 7F }
	condition:
		$1
}

rule file_74_2_0 {
	meta:
		name = "??0?$__crt_scoped_stack_ptr@_W@@QAA@U?$__crt_scoped_stack_ptr_tag@_W@@@Z"
		size = 18
		altNames = "??0?$__crt_scoped_stack_ptr@D@@QAA@U?$__crt_scoped_stack_ptr_tag@D@@@Z ??0?$__crt_scoped_stack_ptr@U_INPUT_RECORD@@@@QAA@U?$__crt_scoped_stack_ptr_tag@U_INPUT_RECORD@@@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 01 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_74_7_0 {
	meta:
		name = "??1?$__crt_scoped_stack_ptr@_W@@QAA@XZ"
		size = 38
		refs = "001e _free_base"
		altNames = "??1?$__crt_scoped_stack_ptr@D@@QAA@XZ ??1?$__crt_scoped_stack_ptr@U_INPUT_RECORD@@@@QAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 68 59 B1 51 F8 08 2C 4D F6 DD 53 9A 42 05 D1 A1 F1 08 00 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_74_12_0 {
	meta:
		name = "?InternalGetLocaleInfoA@@YAHQAU__crt_locale_pointers@@QB_WKQADH@Z"
		size = 288
		refs = "0008 __security_push_cookie 0020 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0032 __acrt_GetLocaleInfoEx 007c __chkstk 00a0 _malloc_base 00f6 _free_base 0112 __security_pop_cookie 011c __imp_WideCharToMultiByte"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 86 B0 6F 46 84 B0 0C 46 01 46 17 F1 08 00 99 46 92 46 3C 60 ?? ?? ?? ?? F8 68 00 22 51 46 83 68 20 46 7B 60 00 23 ?? ?? ?? ?? 80 46 08 B9 00 24 5D E0 4F EA 48 03 03 F1 08 02 9A 42 98 BF 00 22 4D F6 DD 56 6A B3 03 F1 08 02 9A 42 98 BF 00 22 B2 F5 80 6F 19 D8 03 F1 08 02 9A 42 98 BF 00 22 D3 1D 93 42 01 D8 6F F0 07 03 23 F0 07 03 9C 08 ?? ?? ?? ?? AD EB 04 0D 1D F1 10 05 03 D0 4C F6 CC 43 2B 60 08 35 3C 68 0C E0 03 F1 08 00 98 42 98 BF 00 20 ?? ?? ?? ?? 05 46 F5 B1 2E 60 08 35 00 E0 00 25 CD B1 43 46 2A 46 51 46 20 46 ?? ?? ?? ?? 90 B1 3B 6C 0B B9 4F F0 00 09 14 4C 78 68 00 22 24 68 01 93 03 92 02 92 D3 43 2A 46 00 21 CD F8 00 90 A0 47 04 46 00 E0 00 24 3D B1 55 F8 08 3C B3 42 03 D1 A5 F1 08 00 ?? ?? ?? ?? 3B 7D 33 B1 BA 68 D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 BD 46 06 B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_74_20_0 {
	meta:
		name = "_MallocaComputeSize"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 00 F1 08 03 83 42 98 BF 00 23 18 46 BD E8 00 88 }
	condition:
		$1
}

rule file_74_21_0 {
	meta:
		name = "_MarkAllocaS"
		size = 16
		altNames = "__fpecode"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 B1 01 60 08 30 BD E8 00 88 }
	condition:
		$1
}

rule file_74_22_0 {
	meta:
		name = "__acrt_GetLocaleInfoA"
		size = 276
		refs = "0008 __security_push_cookie 0028 ?InternalGetLocaleInfoA@@YAHQAU__crt_locale_pointers@@QB_WKQADH@Z 0032 _calloc_base 003a _free_base 004a strncpy_s 00ae __acrt_GetLocaleInfoEx 00f6 __security_pop_cookie 0108 _invoke_watson 0110 __imp_GetLastError"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? A4 B0 2E 9C 00 26 98 46 26 60 91 46 82 46 01 29 41 D1 80 23 00 93 04 AB 42 46 49 46 ?? ?? ?? ?? 05 46 95 B1 01 21 ?? ?? ?? ?? 20 60 00 20 ?? ?? ?? ?? 20 68 00 28 54 D0 6B 1E 04 AA 29 46 ?? ?? ?? ?? 00 28 55 D1 00 24 4D E0 2E 4B 1B 68 98 47 7A 28 46 D1 00 23 42 46 49 46 50 46 00 96 ?? ?? ?? ?? 07 46 EF B3 01 21 ?? ?? ?? ?? 05 46 06 46 5D B1 03 46 50 46 42 46 49 46 00 97 ?? ?? ?? ?? 18 B1 00 26 25 60 00 24 01 E0 6F F0 00 04 30 46 ?? ?? ?? ?? 27 E0 02 29 15 D1 00 23 00 22 41 46 48 46 ?? ?? ?? ?? 07 46 DF B1 02 21 ?? ?? ?? ?? 05 46 00 2D 06 46 E8 D0 02 46 48 46 3B 46 41 46 ?? ?? ?? ?? DC E7 61 B9 00 23 02 93 02 23 02 AA 48 F0 00 51 48 46 ?? ?? ?? ?? 10 B1 02 9B 23 70 B1 E7 6F F0 00 04 20 46 24 B0 ?? ?? ?? ?? BD E8 F0 8F 00 23 00 22 00 21 00 20 00 96 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_74_24_0 {
	meta:
		name = "_freea_crt"
		size = 32
		refs = "0018 _free_base"
	strings:
		$1 = { 2D E9 00 48 EB 46 48 B1 50 F8 08 2D 4D F6 DD 53 9A 42 03 D1 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "_FCmulcc"
		size = 114
		refs = "001c crealf 002c cimagf 0064 _FCbuild"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 84 B0 CD ED 03 0A 8D ED 02 0A CD ED 01 1A 8D ED 00 1A ?? ?? ?? ?? DD ED 03 0A B0 EE 40 9A 9D ED 02 0A ?? ?? ?? ?? DD ED 01 0A F0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? 68 EE 09 2A 60 EE 09 0A 20 EE 28 2A 48 EE 28 0A 32 EE C2 0A ?? ?? ?? ?? 04 B0 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_75_1_0 {
	meta:
		name = "_FCmulcr"
		size = 66
		refs = "0018 cimagf 0028 crealf 0034 _FCbuild"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 CD ED 01 0A 8D ED 00 0A F0 EE 41 8A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? 68 EE 28 0A 20 EE 28 0A ?? ?? ?? ?? 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_75_2_0 {
	meta:
		name = "cpowf"
		size = 188
		refs = "001c cimagf 0032 crealf 007a powf 0082 _FCbuild 0090 clogf 00a4 _FCmulcc 00a8 cexpf"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 CD ED 01 0A 8D ED 00 0A CD ED 03 1A 8D ED 02 1A ?? ?? ?? ?? B5 EE 40 0A F1 EE 10 FA 2E D1 9D ED 00 0A DD ED 01 0A ?? ?? ?? ?? B5 EE C0 0A F1 EE 10 FA 23 DB 9D ED 02 0A DD ED 03 0A ?? ?? ?? ?? B5 EE 40 0A F1 EE 10 FA 18 D1 9D ED 02 0A DD ED 03 0A ?? ?? ?? ?? DD ED 01 0A B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? F0 EE 48 0A 9F ED 10 8A ?? ?? ?? ?? F0 EE 48 0A ?? ?? ?? ?? 11 E0 9D ED 00 0A DD ED 01 0A ?? ?? ?? ?? F0 EE 60 1A DD ED 03 0A B0 EE 40 1A 9D ED 02 0A ?? ?? ?? ?? ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 FE DE 00 00 00 00 }
	condition:
		$1
}

rule file_76_26_0 {
	meta:
		name = "??0__crt_scoped_get_last_error_reset@@QAA@XZ"
		size = 28
		refs = "0018 __imp_GetLastError"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 03 4B 04 46 1B 68 98 47 20 60 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_28_0 {
	meta:
		name = "??1__crt_scoped_get_last_error_reset@@QAA@XZ"
		size = 24
		refs = "0014 __imp_SetLastError"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 00 68 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_6_0 {
	meta:
		name = "??$output_debug_string@ABQBD@?$__crt_char_traits@D@@SAXABQBD@Z"
		size = 24
		refs = "0014 __imp_OutputDebugStringA"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 00 68 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_7_0 {
	meta:
		name = "??$output_debug_string@ABQB_W@?$__crt_char_traits@_W@@SAXABQB_W@Z"
		size = 24
		refs = "0014 __imp_OutputDebugStringW"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 00 68 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_307_6_0 {
	meta:
		name = "??$set_current_directory@ABQBD@?$__crt_char_traits@D@@SAHABQBD@Z"
		size = 24
		refs = "0014 __imp_SetCurrentDirectoryA"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 00 68 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_307_7_0 {
	meta:
		name = "??$set_current_directory@ABQB_W@?$__crt_char_traits@_W@@SAHABQB_W@Z"
		size = 24
		refs = "0014 __imp_SetCurrentDirectoryW"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 00 68 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_42_0 {
	meta:
		name = "?construct_ptd@@YAXQAU__acrt_ptd@@QAPAU__crt_locale_data@@@Z"
		size = 124
		refs = "004a ??$?RV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@V<lambda_207f2d024fc103971653565357d6cd41>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@$$QAV<lambda_207f2d024fc103971653565357d6cd41>@@@Z 0064 ??$?RV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@V<lambda_9048902d66e8d99359bc9897bbb930a8>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@$$QAV<lambda_9048902d66e8d99359bc9897bbb930a8>@@@Z 0074 __acrt_initial_multibyte_data 0078 __acrt_exception_action_table"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 86 B0 01 21 08 90 1A 4A 81 61 08 9B 68 46 1A 60 08 9B 16 4A C3 F8 50 13 08 9B 05 A9 9A 64 08 9B 43 22 A3 F8 6C 20 08 9B A3 F8 72 21 08 9B 00 22 C3 F8 4C 23 08 AB 04 93 05 23 02 93 05 93 02 AB 04 AA ?? ?? ?? ?? 08 AB 02 93 09 AB 03 93 04 23 CD E9 04 33 05 AB 02 AA 04 A9 68 46 ?? ?? ?? ?? 06 B0 5D F8 04 BB 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_43_0 {
	meta:
		name = "?construct_ptd_array@@YAXQAU__acrt_ptd@@@Z"
		size = 128
		refs = "005a ??$?RV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@V<lambda_207f2d024fc103971653565357d6cd41>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@$$QAV<lambda_207f2d024fc103971653565357d6cd41>@@@Z 006a ??$?RV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@V<lambda_9048902d66e8d99359bc9897bbb930a8>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@$$QAV<lambda_9048902d66e8d99359bc9897bbb930a8>@@@Z 0074 __acrt_initial_multibyte_data 0078 __acrt_exception_action_table 007c __acrt_current_locale_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 01 AB 04 93 05 23 05 93 01 AB 08 93 02 AB 09 93 04 23 06 93 17 4B 01 21 CD E9 01 03 14 4A 81 61 01 9B 68 46 1A 60 01 9B 10 4A C3 F8 50 13 01 9B 05 A9 9A 64 01 9B 43 22 A3 F8 6C 20 01 9B A3 F8 72 21 01 9B 00 22 C3 F8 4C 23 05 23 03 93 03 AB 04 AA ?? ?? ?? ?? 04 23 05 93 05 AB 08 AA 06 A9 68 46 ?? ?? ?? ?? 0A B0 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_45_0 {
	meta:
		name = "?destroy_fls@@YAXPAX@Z"
		size = 26
		refs = "000c ?destroy_ptd_array@@YAXQAU__acrt_ptd@@@Z 0012 _free_base"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 24 B1 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? BD E8 18 88 }
	condition:
		$1
}

rule file_76_46_0 {
	meta:
		name = "?destroy_ptd@@YAXQAU__acrt_ptd@@@Z"
		size = 156
		refs = "0016 _free_base 0076 ??$?RV<lambda_38edbb1296d33220d7e4dd0ed76b244a>@@AAV<lambda_5ce1d447e08cb34b2473517608e21441>@@V<lambda_fb385d3da700c9147fc39e65dd577a8c>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_38edbb1296d33220d7e4dd0ed76b244a>@@AAV<lambda_5ce1d447e08cb34b2473517608e21441>@@$$QAV<lambda_fb385d3da700c9147fc39e65dd577a8c>@@@Z 008c ??$?RV<lambda_6affb1475c98b40b75cdec977db92e3c>@@AAV<lambda_b8d4b9c228a6ecc3f80208dbb4b4a104>@@V<lambda_608742c3c92a14382c1684fc64f96c88>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_6affb1475c98b40b75cdec977db92e3c>@@AAV<lambda_b8d4b9c228a6ecc3f80208dbb4b4a104>@@$$QAV<lambda_608742c3c92a14382c1684fc64f96c88>@@@Z 0098 __acrt_exception_action_table"
	strings:
		$1 = { 03 B4 2D E9 0F 48 0D F1 10 0B 23 4B 06 90 02 68 9A 42 03 D0 10 46 ?? ?? ?? ?? 06 98 C0 6B ?? ?? ?? ?? 06 9B 18 6B ?? ?? ?? ?? 06 9B 58 6B ?? ?? ?? ?? 06 9B 98 6B ?? ?? ?? ?? 06 9B 98 6A ?? ?? ?? ?? 06 9B D8 6A ?? ?? ?? ?? 06 9B 18 6C ?? ?? ?? ?? 06 9B 58 6C ?? ?? ?? ?? 06 9B D3 F8 60 03 ?? ?? ?? ?? 06 AB 02 93 05 23 01 93 03 93 01 AB 02 AA 03 A9 68 46 ?? ?? ?? ?? 06 AB 02 93 04 23 03 93 01 93 03 AB 02 AA 01 A9 68 46 ?? ?? ?? ?? BD E8 0F 08 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_47_0 {
	meta:
		name = "?destroy_ptd_array@@YAXQAU__acrt_ptd@@@Z"
		size = 156
		refs = "0024 _free_base 007e ??$?RV<lambda_38edbb1296d33220d7e4dd0ed76b244a>@@AAV<lambda_5ce1d447e08cb34b2473517608e21441>@@V<lambda_fb385d3da700c9147fc39e65dd577a8c>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_38edbb1296d33220d7e4dd0ed76b244a>@@AAV<lambda_5ce1d447e08cb34b2473517608e21441>@@$$QAV<lambda_fb385d3da700c9147fc39e65dd577a8c>@@@Z 008e ??$?RV<lambda_6affb1475c98b40b75cdec977db92e3c>@@AAV<lambda_b8d4b9c228a6ecc3f80208dbb4b4a104>@@V<lambda_608742c3c92a14382c1684fc64f96c88>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_6affb1475c98b40b75cdec977db92e3c>@@AAV<lambda_b8d4b9c228a6ecc3f80208dbb4b4a104>@@$$QAV<lambda_608742c3c92a14382c1684fc64f96c88>@@@Z 0098 __acrt_exception_action_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 88 B0 01 AB 03 93 05 23 04 93 01 AB 05 93 04 23 06 93 1F 4B 01 90 02 68 9A 42 03 D0 10 46 ?? ?? ?? ?? 01 98 C0 6B ?? ?? ?? ?? 01 9B 18 6B ?? ?? ?? ?? 01 9B 58 6B ?? ?? ?? ?? 01 9B 98 6B ?? ?? ?? ?? 01 9B 98 6A ?? ?? ?? ?? 01 9B D8 6A ?? ?? ?? ?? 01 9B 18 6C ?? ?? ?? ?? 01 9B 58 6C ?? ?? ?? ?? 01 9B D3 F8 60 03 ?? ?? ?? ?? 05 23 02 93 02 AB 03 AA 04 A9 68 46 ?? ?? ?? ?? 04 23 04 93 04 AB 05 AA 06 A9 68 46 ?? ?? ?? ?? 08 B0 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_51_0 {
	meta:
		name = "?internal_get_ptd_head@@YAPAU__acrt_ptd@@XZ"
		size = 224
		refs = "0014 __acrt_FlsGetValue 002c __acrt_FlsSetValue 003a _calloc_base 00ac ??$?RV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@V<lambda_207f2d024fc103971653565357d6cd41>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@$$QAV<lambda_207f2d024fc103971653565357d6cd41>@@@Z 00bc ??$?RV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@V<lambda_9048902d66e8d99359bc9897bbb930a8>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@$$QAV<lambda_9048902d66e8d99359bc9897bbb930a8>@@@Z 00c4 _free_base 00d0 __acrt_initial_multibyte_data 00d4 __acrt_exception_action_table 00d8 __acrt_current_locale_data 00dc ?__acrt_flsindex@@3KA"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8B B0 34 4D 28 68 10 F1 01 0F 09 D0 ?? ?? ?? ?? 04 46 24 B1 10 F1 01 0F 52 D1 00 24 50 E0 28 68 6F F0 00 01 ?? ?? ?? ?? 00 28 F6 D0 4F F4 59 71 01 20 ?? ?? ?? ?? 04 46 06 46 28 68 24 B1 31 46 ?? ?? ?? ?? 28 B9 28 68 00 21 ?? ?? ?? ?? 00 24 33 E0 01 AB 04 93 05 23 05 93 01 AB 08 93 02 AB 09 93 04 23 06 93 1A 4B 01 21 CD E9 01 43 17 4A A1 61 01 9B 68 46 1A 60 01 9B 13 4A C3 F8 50 13 01 9B 05 A9 9A 64 01 9B 43 22 A3 F8 6C 20 01 9B A3 F8 72 21 01 9B 00 22 C3 F8 4C 23 05 23 03 93 03 AB 04 AA ?? ?? ?? ?? 04 23 05 93 05 AB 08 AA 06 A9 68 46 ?? ?? ?? ?? 00 26 30 46 ?? ?? ?? ?? 20 46 0B B0 BD E8 70 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_52_0 {
	meta:
		name = "?internal_getptd_noexit@@YAPAU__acrt_ptd@@XZ"
		size = 256
		refs = "001c __acrt_FlsGetValue 0032 __acrt_FlsSetValue 0040 _calloc_base 0052 _free_base 00b6 ??$?RV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@V<lambda_207f2d024fc103971653565357d6cd41>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@$$QAV<lambda_207f2d024fc103971653565357d6cd41>@@@Z 00c8 ??$?RV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@V<lambda_9048902d66e8d99359bc9897bbb930a8>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@$$QAV<lambda_9048902d66e8d99359bc9897bbb930a8>@@@Z 00e8 __imp_SetLastError 00ec __acrt_initial_multibyte_data 00f0 __acrt_exception_action_table 00f4 __acrt_current_locale_data 00f8 ?__acrt_flsindex@@3KA 00fc __imp_GetLastError"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8B B0 3C 4B 1B 68 98 47 39 4D 06 46 28 68 10 F1 01 0F 08 D0 ?? ?? ?? ?? 04 46 1C B1 10 F1 01 0F 54 D0 52 E0 28 68 6F F0 00 01 ?? ?? ?? ?? 00 28 4C D0 4F F4 59 71 01 20 ?? ?? ?? ?? 04 46 28 68 34 B9 00 21 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 3D E0 21 46 ?? ?? ?? ?? 08 B9 28 68 F2 E7 01 AB 04 93 05 23 05 93 01 AB 08 93 02 AB 09 93 04 23 07 93 1E 4B 01 21 CD E9 01 43 1B 4A A1 61 01 9B 68 46 1A 60 01 9B 17 4A C3 F8 50 13 01 9B 05 A9 9A 64 01 9B 43 22 A3 F8 6C 20 01 9B A3 F8 72 21 01 9B 00 22 C3 F8 4C 23 05 23 03 93 03 AB 04 AA ?? ?? ?? ?? 04 23 06 93 06 AB 08 AA 07 A9 0D F1 01 00 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 04 B9 00 24 04 4B 30 46 1B 68 98 47 20 46 0B B0 BD E8 70 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_55_0 {
	meta:
		name = "?replace_current_thread_locale_nolock@@YAXQAU__acrt_ptd@@QAU__crt_locale_data@@@Z"
		size = 68
		refs = "0010 __acrt_release_locale_ref 0028 __acrt_free_locale 0032 __acrt_add_locale_ref 003c __acrt_initial_locale_data 0040 __acrt_current_locale_data"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 E8 6C 0C 46 68 B1 ?? ?? ?? ?? 0A 4B E8 6C 1B 68 98 42 06 D0 07 4B 98 42 03 D0 C3 68 0B B9 ?? ?? ?? ?? EC 64 14 B1 20 46 ?? ?? ?? ?? BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_56_0 {
	meta:
		name = "?try_get_ptd_head@@YAPAU__acrt_ptd@@XZ"
		size = 36
		refs = "0018 __acrt_FlsGetValue 0020 ?__acrt_flsindex@@3KA"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 18 68 B0 F1 FF 3F 01 D1 00 20 03 E0 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_58_0 {
	meta:
		name = "__acrt_freeptd"
		size = 56
		refs = "0012 __acrt_FlsGetValue 001e __acrt_FlsSetValue 0024 ?destroy_ptd_array@@YAXQAU__acrt_ptd@@@Z 002a _free_base 0034 ?__acrt_flsindex@@3KA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0A 4C 20 68 B0 F1 FF 3F 0D D0 ?? ?? ?? ?? 05 46 4D B1 20 68 00 21 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? BD E8 30 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_59_0 {
	meta:
		name = "__acrt_getptd"
		size = 268
		refs = "001c __acrt_FlsGetValue 0032 __acrt_FlsSetValue 0040 _calloc_base 0052 _free_base 00b6 ??$?RV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@V<lambda_207f2d024fc103971653565357d6cd41>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@$$QAV<lambda_207f2d024fc103971653565357d6cd41>@@@Z 00c8 ??$?RV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@V<lambda_9048902d66e8d99359bc9897bbb930a8>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@$$QAV<lambda_9048902d66e8d99359bc9897bbb930a8>@@@Z 00ec abort 00f4 __imp_SetLastError 00f8 __acrt_initial_multibyte_data 00fc __acrt_exception_action_table 0100 __acrt_current_locale_data 0104 ?__acrt_flsindex@@3KA 0108 __imp_GetLastError"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8B B0 3F 4B 1B 68 98 47 3C 4D 06 46 28 68 10 F1 01 0F 08 D0 ?? ?? ?? ?? 04 46 1C B1 10 F1 01 0F 53 D1 5B E0 28 68 6F F0 00 01 ?? ?? ?? ?? 00 28 54 D0 4F F4 59 71 01 20 ?? ?? ?? ?? 04 46 28 68 34 B9 00 21 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 45 E0 21 46 ?? ?? ?? ?? 08 B9 28 68 F2 E7 01 AB 04 93 05 23 05 93 01 AB 08 93 02 AB 09 93 04 23 07 93 21 4B 01 21 CD E9 01 43 1E 4A A1 61 01 9B 68 46 1A 60 01 9B 1A 4A C3 F8 50 13 01 9B 05 A9 9A 64 01 9B 43 22 A3 F8 6C 20 01 9B A3 F8 72 21 01 9B 00 22 C3 F8 4C 23 05 23 03 93 03 AB 04 AA ?? ?? ?? ?? 04 23 06 93 06 AB 08 AA 07 A9 0D F1 01 00 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 3C B1 07 4B 30 46 1B 68 98 47 20 46 0B B0 BD E8 70 88 03 4B 30 46 1B 68 98 47 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_60_0 {
	meta:
		name = "__acrt_getptd_head"
		size = 232
		refs = "0014 __acrt_FlsGetValue 002a __acrt_FlsSetValue 0038 _calloc_base 004a _free_base 00ae ??$?RV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@V<lambda_207f2d024fc103971653565357d6cd41>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@$$QAV<lambda_207f2d024fc103971653565357d6cd41>@@@Z 00be ??$?RV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@V<lambda_9048902d66e8d99359bc9897bbb930a8>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@$$QAV<lambda_9048902d66e8d99359bc9897bbb930a8>@@@Z 00d2 abort 00d8 __acrt_initial_multibyte_data 00dc __acrt_exception_action_table 00e0 __acrt_current_locale_data 00e4 ?__acrt_flsindex@@3KA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 8A B0 36 4D 28 68 10 F1 01 0F 08 D0 ?? ?? ?? ?? 04 46 1C B1 10 F1 01 0F 52 D1 56 E0 28 68 6F F0 00 01 ?? ?? ?? ?? 00 28 4F D0 4F F4 59 71 01 20 ?? ?? ?? ?? 04 46 28 68 34 B9 00 21 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 40 E0 21 46 ?? ?? ?? ?? 08 B9 28 68 F2 E7 01 AB 04 93 05 23 05 93 01 AB 08 93 02 AB 09 93 04 23 06 93 1B 4B 01 21 CD E9 01 43 18 4A A1 61 01 9B 68 46 1A 60 01 9B 14 4A C3 F8 50 13 01 9B 05 A9 9A 64 01 9B 43 22 A3 F8 6C 20 01 9B A3 F8 72 21 01 9B 00 22 C3 F8 4C 23 05 23 03 93 03 AB 04 AA ?? ?? ?? ?? 04 23 05 93 05 AB 08 AA 06 A9 68 46 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 1C B1 20 46 0A B0 BD E8 30 88 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_61_0 {
	meta:
		name = "__acrt_getptd_noexit"
		size = 264
		refs = "001c __acrt_FlsGetValue 0042 __acrt_FlsSetValue 0050 _calloc_base 0062 _free_base 00c6 ??$?RV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@V<lambda_207f2d024fc103971653565357d6cd41>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_15ade71b0218206bbe3333a0c9b79046>@@AAV<lambda_da44e0f8b0f19ba52fefafb335991732>@@$$QAV<lambda_207f2d024fc103971653565357d6cd41>@@@Z 00d8 ??$?RV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@V<lambda_9048902d66e8d99359bc9897bbb930a8>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_a7e850c220f1c8d1e6efeecdedd162c6>@@AAV<lambda_46720907175c18b6c9d2717bc0d2d362>@@$$QAV<lambda_9048902d66e8d99359bc9897bbb930a8>@@@Z 00f0 __imp_SetLastError 00f4 __acrt_initial_multibyte_data 00f8 __acrt_exception_action_table 00fc __acrt_current_locale_data 0100 ?__acrt_flsindex@@3KA 0104 __imp_GetLastError"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8B B0 3E 4B 1B 68 98 47 3B 4D 06 46 28 68 10 F1 01 0F 10 D0 ?? ?? ?? ?? 04 46 5C B1 10 F1 01 0F 5B D1 31 4B 30 46 1B 68 98 47 00 24 20 46 0B B0 BD E8 70 88 28 68 6F F0 00 01 ?? ?? ?? ?? 00 28 EF D0 4F F4 59 71 01 20 ?? ?? ?? ?? 04 46 28 68 34 B9 00 21 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? E0 E7 21 46 ?? ?? ?? ?? 08 B9 28 68 F2 E7 01 AB 04 93 05 23 05 93 01 AB 08 93 02 AB 09 93 04 23 07 93 1C 4B 01 21 CD E9 01 43 19 4A A1 61 01 9B 68 46 1A 60 01 9B 15 4A C3 F8 50 13 01 9B 05 A9 9A 64 01 9B 43 22 A3 F8 6C 20 01 9B A3 F8 72 21 01 9B 00 22 C3 F8 4C 23 05 23 03 93 03 AB 04 AA ?? ?? ?? ?? 04 23 06 93 06 AB 08 AA 07 A9 0D F1 01 00 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 00 2C A1 D0 02 4B 30 46 1B 68 98 47 A1 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_62_0 {
	meta:
		name = "__acrt_initialize_ptd"
		size = 56
		refs = "0008 __acrt_FlsAlloc 001a __acrt_getptd_noexit 0022 __acrt_uninitialize_ptd 0030 ?__acrt_flsindex@@3KA 0034 ?destroy_fls@@YAXPAX@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 48 ?? ?? ?? ?? 08 4B B0 F1 FF 3F 18 60 01 D1 00 20 07 E0 ?? ?? ?? ?? 18 B9 00 20 ?? ?? ?? ?? F6 E7 01 20 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_63_0 {
	meta:
		name = "__acrt_uninitialize_ptd"
		size = 36
		refs = "0014 __acrt_FlsFree 0020 ?__acrt_flsindex@@3KA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 4C 6F F0 00 05 20 68 A8 42 02 D0 ?? ?? ?? ?? 25 60 01 20 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_5_0 {
	meta:
		name = "_mbsrchr_l"
		size = 138
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a _errno 0022 _invalid_parameter_noinfo 0032 strrchr"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 85 B0 0E 46 04 46 68 46 11 46 00 25 ?? ?? ?? ?? 34 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 22 E0 02 98 83 68 2B B9 31 46 20 46 ?? ?? ?? ?? 05 46 19 E0 22 78 50 FA 82 F3 5B 7E 11 46 13 F0 04 0F 0A D0 64 1C 22 78 2A B1 42 EA 01 23 9E 42 06 D1 65 1E 04 E0 00 2D 00 E0 96 42 08 BF 25 46 00 2A 04 F1 01 04 E5 D1 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 28 46 05 B0 BD E8 70 88 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "_dlog"
		size = 500
		refs = "001a _dunscale 0044 _fperrraise 015c _Inf_C 01f0 _Nan_C"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 2D ED 04 8B 85 B0 04 46 68 46 02 A9 8D ED 02 0B ?? ?? ?? ?? 00 28 00 F0 8D 80 BD F8 0E 30 01 28 04 D0 02 28 05 D1 9D ED 02 0B 8B E0 13 F4 00 4F F8 E7 13 F4 00 4F 06 D0 01 20 ?? ?? ?? ?? 69 4B 93 ED 00 0B 7E E0 9F ED 65 0B 9D ED 02 1B BD F9 00 30 B4 EE C0 1B F1 EE 10 FA 03 D2 5B 1E 1B B2 31 EE 01 1B B7 EE 00 0B 9F ED 5B 4B 31 EE 40 9B 30 EE 01 0B 9F ED 56 1B 9F ED 53 5B 89 EE 00 8B 9F ED 4F 6B 9F ED 4C 2B 9F ED 49 3B 28 EE 08 7B 9F ED 45 0B 00 2C 07 EE 01 4B 01 EE 10 3A 04 EE 07 5B 05 EE 07 6B B8 EE C1 5B 06 EE 07 2B 02 EE 07 3B 03 EE 07 0B 20 EE 07 0B 39 EE 40 0B 20 EE 08 3B 0C D1 9F ED 36 0B 9F ED 33 1B 25 EE 00 0B 33 EE 40 0B 39 EE 40 0B 05 EE 01 0B 32 E0 18 DD 9F ED 2B 0B 9F ED 28 1B 9F ED 25 4B 23 EE 00 3B 9F ED 21 0B 25 EE 01 2B 29 EE 00 1B 33 EE 42 0B 9F ED 1B 2B 31 EE 40 0B 09 EE 04 0B 05 EE 02 0B 18 E0 9F ED 14 0B 9F ED 11 1B 29 EE 00 2B 23 EE 01 0B 9F ED 0C 1B 32 EE 40 0B 09 EE 01 0B 30 EE 05 0B 07 E0 04 20 ?? ?? ?? ?? 05 4B 93 ED 00 0B B1 EE 40 0B 05 B0 BD EC 04 8B BD E8 10 08 5D F8 0C FB ?? ?? ?? ?? 00 00 00 60 47 15 F7 3F FE 82 2B 65 47 15 F7 3F 44 DF 5D F8 0B AE 54 3E 00 00 00 00 13 44 D3 3F AB A6 32 0E E5 26 55 3E 00 00 00 00 7B CB DB 3F 7C C4 BC 7F DE 27 74 3E 0E E5 26 15 7B CB DB 3F 00 00 00 C0 42 2E E6 3F 9E BC 9A F7 1C 7D 7F 3E BC 55 55 55 55 55 E5 3F F7 5F 97 99 99 99 D9 3F 4A E9 8A 94 24 49 D2 3F C6 C9 12 DA C4 71 CC 3F 62 CB 68 D9 6F 46 C7 3F F7 DE 29 BF D8 F8 C2 3F F4 B3 FE CC 1A 99 C3 3F CD 3B 7F 66 9E A0 E6 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "_ldlog"
		size = 500
		refs = "001a _ldunscale 0044 _fperrraise 015c _LInf_C 01f0 _LNan_C"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 2D ED 04 8B 85 B0 04 46 68 46 02 A9 8D ED 02 0B ?? ?? ?? ?? 00 28 00 F0 8D 80 BD F8 0E 30 01 28 04 D0 02 28 05 D1 9D ED 02 0B 8B E0 13 F4 00 4F F8 E7 13 F4 00 4F 06 D0 01 20 ?? ?? ?? ?? 69 4B 93 ED 00 0B 7E E0 9F ED 65 0B 9D ED 02 1B BD F9 00 30 B4 EE C0 1B F1 EE 10 FA 03 D2 5B 1E 1B B2 31 EE 01 1B B7 EE 00 0B 9F ED 5B 4B 31 EE 40 9B 30 EE 01 0B 9F ED 56 1B 9F ED 53 5B 89 EE 00 8B 9F ED 4F 6B 9F ED 4C 2B 9F ED 49 3B 28 EE 08 7B 9F ED 45 0B 00 2C 07 EE 01 4B 01 EE 10 3A 04 EE 07 5B 05 EE 07 6B B8 EE C1 5B 06 EE 07 2B 02 EE 07 3B 03 EE 07 0B 20 EE 07 0B 39 EE 40 0B 20 EE 08 3B 0C D1 9F ED 36 0B 9F ED 33 1B 25 EE 00 0B 33 EE 40 0B 39 EE 40 0B 05 EE 01 0B 32 E0 18 DD 9F ED 2B 0B 9F ED 28 1B 9F ED 25 4B 23 EE 00 3B 9F ED 21 0B 25 EE 01 2B 29 EE 00 1B 33 EE 42 0B 9F ED 1B 2B 31 EE 40 0B 09 EE 04 0B 05 EE 02 0B 18 E0 9F ED 14 0B 9F ED 11 1B 29 EE 00 2B 23 EE 01 0B 9F ED 0C 1B 32 EE 40 0B 09 EE 01 0B 30 EE 05 0B 07 E0 04 20 ?? ?? ?? ?? 05 4B 93 ED 00 0B B1 EE 40 0B 05 B0 BD EC 04 8B BD E8 10 08 5D F8 0C FB ?? ?? ?? ?? 00 00 00 60 47 15 F7 3F FE 82 2B 65 47 15 F7 3F 44 DF 5D F8 0B AE 54 3E 00 00 00 00 13 44 D3 3F AB A6 32 0E E5 26 55 3E 00 00 00 00 7B CB DB 3F 7C C4 BC 7F DE 27 74 3E 0E E5 26 15 7B CB DB 3F 00 00 00 C0 42 2E E6 3F 9E BC 9A F7 1C 7D 7F 3E BC 55 55 55 55 55 E5 3F F7 5F 97 99 99 99 D9 3F 4A E9 8A 94 24 49 D2 3F C6 C9 12 DA C4 71 CC 3F 62 CB 68 D9 6F 46 C7 3F F7 DE 29 BF D8 F8 C2 3F F4 B3 FE CC 1A 99 C3 3F CD 3B 7F 66 9E A0 E6 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1_0 {
	meta:
		name = "_dlogpoly"
		size = 124
		altNames = "_ldlogpoly"
	strings:
		$1 = { 2D E9 00 48 EB 46 9F ED 1B 2B 9F ED 18 3B 9F ED 15 6B 9F ED 12 4B B0 EE 40 1B 00 EE 02 3B 9F ED 0D 5B 9F ED 0A 2B 03 EE 00 6B 9F ED 06 0B 06 EE 01 4B 04 EE 01 5B 05 EE 01 2B 02 EE 01 0B BD E8 00 88 FE DE BC 55 55 55 55 55 E5 3F F7 5F 97 99 99 99 D9 3F 4A E9 8A 94 24 49 D2 3F C6 C9 12 DA C4 71 CC 3F 62 CB 68 D9 6F 46 C7 3F F4 B3 FE CC 1A 99 C3 3F F7 DE 29 BF D8 F8 C2 3F }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "log1p"
		size = 164
		refs = "0012 _dtest 003e _fperrraise 0072 log 009c _Inf_C 00a0 _Nan_C"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 06 8B 82 B0 68 46 8D ED 00 0B ?? ?? ?? ?? C8 B3 01 28 01 D0 02 28 03 E0 BD F8 06 30 13 F4 00 4F 30 D0 9D ED 00 AB BF EE 00 0B B4 EE C0 AB F1 EE 10 FA 06 D2 01 20 ?? ?? ?? ?? 17 4B 93 ED 00 0B 22 E0 B4 EE 40 AB F1 EE 10 FA 08 D1 04 20 ?? ?? ?? ?? 10 4B 93 ED 00 0B B1 EE 40 0B 14 E0 B7 EE 00 8B 3A EE 08 9B B0 EE 49 0B ?? ?? ?? ?? 39 EE 48 1B B0 EE 40 2B 31 EE 4A 0B 80 EE 09 0B 32 EE 40 0B 01 E0 9D ED 00 0B 02 B0 BD EC 06 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "log1pl"
		size = 164
		refs = "0012 _ldtest 003e _fperrraise 0072 log 009c _LInf_C 00a0 _LNan_C"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 06 8B 82 B0 68 46 8D ED 00 0B ?? ?? ?? ?? C8 B3 01 28 01 D0 02 28 03 E0 BD F8 06 30 13 F4 00 4F 30 D0 9D ED 00 AB BF EE 00 0B B4 EE C0 AB F1 EE 10 FA 06 D2 01 20 ?? ?? ?? ?? 17 4B 93 ED 00 0B 22 E0 B4 EE 40 AB F1 EE 10 FA 08 D1 04 20 ?? ?? ?? ?? 10 4B 93 ED 00 0B B1 EE 40 0B 14 E0 B7 EE 00 8B 3A EE 08 9B B0 EE 49 0B ?? ?? ?? ?? 39 EE 48 1B B0 EE 40 2B 31 EE 4A 0B 80 EE 09 0B 32 EE 40 0B 01 E0 9D ED 00 0B 02 B0 BD EC 06 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_5_0 {
	meta:
		name = "_mbsset_l"
		size = 156
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a _errno 0022 _invalid_parameter_noinfo 0034 _strset"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 85 B0 0D 46 04 46 06 46 68 46 11 46 ?? ?? ?? ?? 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 26 2A E0 02 9B 9B 68 2B B9 29 46 20 46 ?? ?? ?? ?? 06 46 21 E0 2B 0A D9 B2 B9 B1 EA B2 2A B9 ?? ?? ?? ?? 16 23 20 21 03 60 20 22 23 78 A3 B1 20 20 21 70 14 F8 01 3F 13 B1 22 70 64 1C 01 E0 04 F8 01 0C 23 78 00 2B F3 D1 06 E0 23 78 02 E0 25 70 14 F8 01 3F 00 2B FA D1 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 30 46 05 B0 BD E8 70 88 }
	condition:
		$1
}

rule file_81_4_0 {
	meta:
		name = "__dcrt_multibyte_check_type"
		size = 98
		refs = "0038 __acrt_GetStringTypeA"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 86 B0 0F 46 1D 46 7B 68 16 46 9C 68 0C B3 5A 68 03 0A 8D F8 10 30 00 23 05 93 01 23 02 93 05 AB 00 93 8D F8 11 00 01 92 02 23 04 AA 01 21 38 46 ?? ?? ?? ?? 68 B1 BD F8 16 30 53 B9 BD F8 14 30 33 42 18 BF 01 23 08 BF 00 23 AB 42 08 BF 01 20 00 D0 00 20 06 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_81_6_0 {
	meta:
		name = "_ismbcgraph_l"
		size = 100
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0046 __dcrt_multibyte_check_type"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? FF 2C 12 D8 01 9B E1 B2 1B 68 33 F8 11 20 40 F2 17 13 1A 42 07 D1 02 9B 0B 44 5B 7E 13 F0 03 0F 08 BF 00 20 08 D0 01 20 06 E0 01 A9 01 23 40 F2 17 12 20 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_82_6_0 {
	meta:
		name = "_ismbcupper_l"
		size = 80
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0032 __dcrt_multibyte_check_type"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? FF 2C 09 D8 02 9B 23 44 5B 7E 13 F0 10 0F 18 BF 01 20 07 D1 00 20 05 E0 01 A9 01 23 01 22 20 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "_abs64"
		size = 28
		altNames = "llabs"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 29 02 DB 05 DC 00 28 03 D2 00 23 40 42 63 EB 01 01 BD E8 00 88 }
	condition:
		$1
}

rule file_83_1_0 {
	meta:
		name = "abs"
		size = 18
		altNames = "labs"
	strings:
		$1 = { 2D E9 00 48 EB 46 80 EA E0 73 A3 EB E0 70 BD E8 00 88 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "conj"
		size = 62
		refs = "0014 creal 0024 cimag"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 1B B0 EE 48 0B B1 EE 41 1B 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "conjl"
		size = 62
		refs = "0014 creall 0024 cimagl"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 1B B0 EE 48 0B B1 EE 41 1B 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "ldiv"
		size = 30
		refs = "0010 __rt_sdiv"
		altNames = "div"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 10 46 00 B9 F9 DE ?? ?? ?? ?? C4 E9 00 01 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_86_5_0 {
	meta:
		name = "_mbsnextc_l"
		size = 88
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0014 _errno 001c _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 04 46 68 46 00 25 ?? ?? ?? ?? 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0C E0 22 78 02 9B 13 44 5B 7E 13 F0 04 0F 03 D0 63 78 0B B1 15 02 64 1C 23 78 58 19 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "_drint"
		size = 198
		refs = "000c fegetround 0028 _d_int"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 8D ED 00 0B ?? ?? ?? ?? 90 B3 B0 F5 80 7F 1F D0 B0 F5 00 7F 0A D0 B0 F5 40 7F 03 D1 68 46 00 21 ?? ?? ?? ?? 9D ED 00 0B BD E8 0C 88 68 46 00 21 ?? ?? ?? ?? 00 28 F5 D0 BD F8 06 30 13 F4 00 4F F0 D1 9D ED 00 1B B7 EE 00 0B 30 EE 01 0B EB E7 68 46 00 21 ?? ?? ?? ?? 00 28 E3 D0 BD F8 06 30 13 F4 00 4F DE D0 9D ED 00 1B B7 EE 00 0B 23 E0 68 46 01 21 ?? ?? ?? ?? 78 B9 68 46 00 21 ?? ?? ?? ?? 00 28 CE D0 68 46 6F F0 00 01 ?? ?? ?? ?? 00 28 C7 D0 B0 EE 00 0B 07 E0 68 46 00 21 ?? ?? ?? ?? 00 28 BE D0 B7 EE 00 0B BD F8 06 30 9D ED 00 1B 13 F4 00 4F C8 D0 31 EE 40 0B B4 E7 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "_ldrint"
		size = 198
		refs = "000c fegetround 0028 _ld_int"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 8D ED 00 0B ?? ?? ?? ?? 90 B3 B0 F5 80 7F 1F D0 B0 F5 00 7F 0A D0 B0 F5 40 7F 03 D1 68 46 00 21 ?? ?? ?? ?? 9D ED 00 0B BD E8 0C 88 68 46 00 21 ?? ?? ?? ?? 00 28 F5 D0 BD F8 06 30 13 F4 00 4F F0 D1 9D ED 00 1B B7 EE 00 0B 30 EE 01 0B EB E7 68 46 00 21 ?? ?? ?? ?? 00 28 E3 D0 BD F8 06 30 13 F4 00 4F DE D0 9D ED 00 1B B7 EE 00 0B 23 E0 68 46 01 21 ?? ?? ?? ?? 78 B9 68 46 00 21 ?? ?? ?? ?? 00 28 CE D0 68 46 6F F0 00 01 ?? ?? ?? ?? 00 28 C7 D0 B0 EE 00 0B 07 E0 68 46 00 21 ?? ?? ?? ?? 00 28 BE D0 B7 EE 00 0B BD F8 06 30 9D ED 00 1B 13 F4 00 4F C8 D0 31 EE 40 0B B4 E7 }
	condition:
		$1
}

rule file_87_1_0 {
	meta:
		name = "rint"
		size = 78
		refs = "0012 _dtest 0024 _drint 003c _fperrraise"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 68 46 8D ED 00 0B ?? ?? ?? ?? 02 28 02 D8 9D ED 00 8B 0F E0 9D ED 00 0B ?? ?? ?? ?? 9D ED 00 2B B0 EE 40 8B B4 EE 42 0B F1 EE 10 FA 02 D0 20 20 ?? ?? ?? ?? B0 EE 48 0B 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_279_1_0 {
	meta:
		name = "rintl"
		size = 78
		refs = "0012 _ldtest 0024 _ldrint 003c _fperrraise"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 68 46 8D ED 00 0B ?? ?? ?? ?? 02 28 02 D8 9D ED 00 8B 0F E0 9D ED 00 0B ?? ?? ?? ?? 9D ED 00 2B B0 EE 40 8B B4 EE 42 0B F1 EE 10 FA 02 D0 20 20 ?? ?? ?? ?? B0 EE 48 0B 02 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_88_4_0 {
	meta:
		name = "__iswcsym"
		size = 34
		refs = "000e iswctype"
		altNames = "_iswcsym_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 40 F2 07 11 04 46 ?? ?? ?? ?? 18 B9 5F 2C 18 BF 00 20 00 D1 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_88_5_0 {
	meta:
		name = "__iswcsymf"
		size = 34
		refs = "000e iswctype"
		altNames = "_iswcsymf_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 40 F2 03 11 04 46 ?? ?? ?? ?? 18 B9 5F 2C 18 BF 00 20 00 D1 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_88_6_0 {
	meta:
		name = "_isleadbyte_l"
		size = 58
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9B E2 B2 1B 68 33 F8 12 10 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 01 F4 00 40 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_88_7_0 {
	meta:
		name = "_iswalnum_l"
		size = 18
		refs = "000e iswctype"
		altNames = "iswalnum"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 F2 07 11 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_8_0 {
	meta:
		name = "_iswalpha_l"
		size = 18
		refs = "000e iswctype"
		altNames = "iswalpha"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 F2 03 11 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_9_0 {
	meta:
		name = "_iswblank_l"
		size = 28
		refs = "0014 iswctype"
		altNames = "iswblank"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 28 01 D1 40 20 04 E0 40 21 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_88_10_0 {
	meta:
		name = "_iswcntrl_l"
		size = 16
		refs = "000c iswctype"
		altNames = "iswcntrl"
	strings:
		$1 = { 2D E9 00 48 EB 46 20 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_13_0 {
	meta:
		name = "_iswdigit_l"
		size = 16
		refs = "000c iswctype"
		altNames = "iswdigit"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_14_0 {
	meta:
		name = "_iswgraph_l"
		size = 18
		refs = "000e iswctype"
		altNames = "iswgraph"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 F2 17 11 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_15_0 {
	meta:
		name = "_iswlower_l"
		size = 16
		refs = "000c iswctype"
		altNames = "iswlower"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_664_1_0 {
	meta:
		name = "??$free_crt_array@D$01@@YAXAAY01PAD@Z"
		size = 16
		refs = "000c ?free_crt_array_internal@@YAXQAPBXI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_664_4_0 {
	meta:
		name = "??$free_crt_array@_W$01@@YAXAAY01PA_W@Z"
		size = 16
		refs = "000c ?free_crt_array_internal@@YAXQAPBXI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_16_0 {
	meta:
		name = "_iswprint_l"
		size = 18
		refs = "000e iswctype"
		altNames = "iswprint"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 F2 57 11 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_17_0 {
	meta:
		name = "_iswpunct_l"
		size = 16
		refs = "000c iswctype"
		altNames = "iswpunct"
	strings:
		$1 = { 2D E9 00 48 EB 46 10 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_67_0 {
	meta:
		name = "tmpfile_s"
		size = 16
		refs = "000c ?common_tmpfile@@YAHQAPAU_iobuf@@H@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 10 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_18_0 {
	meta:
		name = "_iswspace_l"
		size = 16
		refs = "000c iswctype"
		altNames = "iswspace"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_155_3 {
	meta:
		name = "?is_space@__crt_strtox@@YA_N_WPAU__crt_locale_pointers@@@Z"
		size = 24
		refs = "0008 iswctype"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 21 ?? ?? ?? ?? 08 B1 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_88_19_0 {
	meta:
		name = "_iswupper_l"
		size = 16
		refs = "000c iswctype"
		altNames = "iswupper"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_634_13_0 {
	meta:
		name = "_mktime32"
		size = 16
		refs = "000c ??$common_mktime@J@@YAJQAUtm@@_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_634_14_0 {
	meta:
		name = "_mktime64"
		size = 16
		refs = "000c ??$common_mktime@_J@@YA_JQAUtm@@_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_20_0 {
	meta:
		name = "_iswxdigit_l"
		size = 16
		refs = "000c iswctype"
		altNames = "iswxdigit"
	strings:
		$1 = { 2D E9 00 48 EB 46 80 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_88_21_0 {
	meta:
		name = "isleadbyte"
		size = 60
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 00 21 ?? ?? ?? ?? 01 9B E2 B2 1B 68 33 F8 12 10 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 01 F4 00 40 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_88_24_0 {
	meta:
		name = "iswascii"
		size = 20
		altNames = "__isascii"
	strings:
		$1 = { 2D E9 00 48 EB 46 80 28 38 BF 01 20 28 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "_fdquad"
		size = 896
		refs = "000c __security_push_cookie 0060 _fd_int 00d8 _fdunscale 00ec _fdxp_setw 0102 _fdscale 013c _fdxp_mulh 017c _fdxp_addx 01dc memcpy 02f2 _fdxp_getw 031e fmodf 0334 __security_pop_cookie 0348 __c 0360 __b"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 2D ED 06 8B ?? ?? ?? ?? 98 B0 DF ED DA 8A D0 ED 00 0A 9F ED D7 8A 07 46 F4 EE E0 8A CD ED 02 0A F1 EE 10 FA 4F D2 F4 EE C8 0A F1 EE 10 FA 4A D2 9F ED C4 0A 60 EE 80 0A B6 EE 00 0A F5 EE C0 0A F1 EE 10 FA 02 DB 30 EE 20 0A 01 E0 30 EE C0 0A 68 46 00 21 8D ED 00 0A ?? ?? ?? ?? DD ED 00 5A F5 EE 40 5A F1 EE 10 FA 2A D0 B5 EE 00 0A 9F ED B8 1B 25 EE 80 0A DF ED BD 3A 9D ED 02 5A 9F ED BA 2A B7 EE C0 0A DF ED B7 2A 9F ED B5 4A DF ED B3 4A 20 EE 01 0B B7 EE C0 3B 23 EE 23 0A 23 EE 22 1A 35 EE 40 0A 63 EE 04 1A 03 EE 42 0A 63 EE 24 0A 30 EE 41 0A 30 EE 61 0A 30 EE 60 0A 18 E1 9D ED 02 0A 15 E1 69 46 01 A8 05 26 CD ED 00 0A ?? ?? ?? ?? BD F9 04 30 21 2B 06 DA 9D ED 02 0A 06 A8 05 21 ?? ?? ?? ?? 46 E0 19 3B DB 10 1B B2 AD F8 04 30 DB 00 59 42 02 A8 ?? ?? ?? ?? 9D ED 02 0A 04 A8 02 21 ?? ?? ?? ?? BD F9 04 30 DF F8 48 82 06 AD 03 EB 83 03 08 EB 83 03 A3 F1 14 04 94 E8 0F 00 85 E8 0F 00 06 A8 05 21 23 69 9D ED 04 0A 2B 61 ?? ?? ?? ?? 9D ED 05 0A B5 EE 40 0A F1 EE 10 FA 18 D0 BD F9 04 30 0C AD 03 EB 83 03 08 EB 83 03 A3 F1 14 04 94 E8 0F 00 85 E8 0F 00 23 69 0C A8 05 21 2B 61 ?? ?? ?? ?? 0C AA 06 A8 05 23 05 21 ?? ?? ?? ?? 9F ED 75 9B 73 4C 9F ED 72 AA 9D ED 06 1A B4 EE E8 1A F1 EE 10 FA 04 D3 B4 EE C1 8A F1 EE 10 FA 56 D2 9D ED 07 0A 00 21 68 46 30 EE 01 0A 20 EE 0A 0A 8D ED 00 0A ?? ?? ?? ?? 9D ED 00 0A 02 21 04 A8 B1 EE 40 0A B7 EE C0 0A 20 EE 09 0B B7 EE C0 0B ?? ?? ?? ?? 5C 49 B2 00 0C A8 ?? ?? ?? ?? 9D ED 04 0A 31 46 0C A8 ?? ?? ?? ?? 9D ED 05 0A B5 EE 40 0A F1 EE 10 FA 23 D0 06 9B 03 A9 0D F1 06 00 03 93 ?? ?? ?? ?? BD F9 06 20 82 FB 04 31 8B 10 03 EB D3 73 9B 1C 5E 00 05 2E 4A 49 88 BF 05 26 B2 00 12 A8 ?? ?? ?? ?? 9D ED 05 0A 31 46 12 A8 ?? ?? ?? ?? 12 AA 0C A8 33 46 31 46 ?? ?? ?? ?? 0C AA 06 A8 33 46 31 46 ?? ?? ?? ?? 9C E7 9D ED 07 0A DF ED 3D 0A 30 EE 01 0A 60 EE 20 0A B6 EE 00 0A F5 EE C0 0A F1 EE 10 FA 02 DB 30 EE 20 0A 01 E0 30 EE C0 0A 68 46 00 21 8D ED 00 0A ?? ?? ?? ?? 9D ED 00 0A B5 EE 40 0A F1 EE 10 FA 2D D0 06 9B 03 A9 0D F1 06 00 03 93 ?? ?? ?? ?? BD F9 06 20 82 FB 04 31 8B 10 03 EB D3 73 9B 1C 5E 00 05 2E 24 49 88 BF 05 26 B2 00 12 A8 ?? ?? ?? ?? 9D ED 00 0A FD EE 00 0A 12 A8 31 46 20 EE 20 0A B7 EE C0 0A 20 EE 09 0B B7 EE C0 0B ?? ?? ?? ?? 12 AA 06 A8 33 46 31 46 ?? ?? ?? ?? 31 46 06 A8 ?? ?? ?? ?? DD ED 00 5A 9F ED 12 2A DF ED 10 0A 87 ED 00 0A F4 EE C2 5A F1 EE 10 FA 04 D3 F4 EE E5 0A F1 EE 10 FA 05 D2 B0 EE 65 0A ?? ?? ?? ?? F0 EE 40 5A BD EE E5 0A 10 EE 10 3A 03 F0 03 00 18 B0 ?? ?? ?? ?? BD EC 06 8B BD E8 F0 89 00 00 00 4F 00 00 00 CF ?? ?? ?? ?? 83 F9 22 3F 83 F9 22 3E AB AA AA 2A 00 00 00 00 00 00 30 3F ?? ?? ?? ?? 00 30 C2 2E 00 00 34 33 00 20 A2 3A 00 A0 FD 40 00 00 C9 46 83 F9 22 45 83 F9 22 C5 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "_fdquadph"
		size = 220
		refs = "0014 _fdquad 0022 _fd_int 004e fmodf"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 82 B0 04 46 B0 EE 40 8A ?? ?? ?? ?? 05 46 68 46 01 21 8D ED 00 8A ?? ?? ?? ?? 9F ED 2C 2A DD ED 00 1A DF ED 29 0A F4 EE C2 1A 38 EE 61 8A F1 EE 10 FA 04 D3 F4 EE E1 0A F1 EE 10 FA 05 D2 B0 EE 61 0A ?? ?? ?? ?? F0 EE 40 1A B0 EE 00 0A 94 ED 00 1A 21 EE 80 0A 9F ED 1B 2A DF ED 19 0A F0 EE 41 1A BD EE C0 0A 48 EE 02 1A 10 EE 10 3A 03 F0 03 03 58 19 F4 EE E1 0A F1 EE 10 FA 05 D8 B6 EE 00 0A 40 1C 38 EE 40 0A 0B E0 9F ED 0C 0A F4 EE C0 1A F1 EE 10 FA 09 D8 B6 EE 00 0A 40 1E 30 EE 08 0A 00 EE 02 1A 84 ED 00 1A 01 E0 C4 ED 00 1A 02 B0 BD EC 02 8B BD E8 30 88 FE DE DB 0F 49 BF DB 0F 49 3F DB 0F 49 40 00 00 80 4E 00 00 80 CE }
	condition:
		$1
}

rule file_89_2_0 {
	meta:
		name = "_fdsin"
		size = 268
		refs = "0012 _fdtest 0024 _fdquad 00ba _fperrraise 00ec _FNan_C 0108 _FRteps_C"
	strings:
		$1 = { 03 B4 2D E9 18 48 0D F1 08 0B 04 46 68 46 8D ED 00 0A ?? ?? ?? ?? 00 28 55 D0 01 28 4C D0 02 28 47 D0 68 46 ?? ?? ?? ?? 37 4B 9D ED 00 2A 02 19 D3 ED 00 0A B1 EE 60 0A B4 EE C2 0A F1 EE 10 FA 0A D2 B4 EE E0 2A F1 EE 10 FA 05 D2 12 F0 01 0F 2C D0 B7 EE 00 2A 29 E0 62 EE 02 2A 12 F0 01 0F 12 D0 9F ED 28 0A DF ED 26 0A 9F ED 24 1A B7 EE 00 2A 22 EE 80 0A 30 EE C0 0A 20 EE 22 0A 30 EE 41 0A 00 EE 22 2A 11 E0 9F ED 1B 0A DF ED 19 0A 9F ED 17 1A 62 EE 82 1A 22 EE 80 0A 30 EE C0 0A 20 EE 22 0A 30 EE 41 0A 00 EE 21 2A 12 F0 02 0F 13 E0 9D ED 00 2A 13 E0 01 20 ?? ?? ?? ?? 0B 4B 93 ED 00 2A 0C E0 14 F0 01 0F 02 D0 B7 EE 00 2A 01 E0 9D ED 00 2A 14 F0 02 0F 01 D0 B1 EE 42 2A B0 EE 42 0A BD E8 18 08 5D F8 0C FB ?? ?? ?? ?? A1 AA 2A 3E 42 83 08 3C 6E 8C 4C 39 DF FF FF 3E 36 A0 2A 3D 93 49 B2 3A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_3_0 {
	meta:
		name = "get_acsize"
		size = 56
		refs = "0010 _fdunscale"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 01 A9 68 46 8D ED 01 0A ?? ?? ?? ?? BD F9 00 10 06 4B 81 FB 03 32 93 10 03 EB D3 73 9B 1C 58 00 05 28 88 BF 05 20 BD E8 0C 88 FE DE AB AA AA 2A }
	condition:
		$1
}

rule file_89_4_0 {
	meta:
		name = "lgamma_big"
		size = 136
		refs = "0012 _fdlog 002a _fdunscale 0048 _fdscale 006c _fperrraise"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 82 B0 00 20 F0 EE 40 8A ?? ?? ?? ?? B6 EE 00 2A 01 A9 38 EE C2 2A 68 46 B0 EE 40 8A 8D ED 01 2A ?? ?? ?? ?? B7 EE 00 9A DD ED 01 2A 38 EE 49 2A BD F9 00 10 01 A8 22 EE 22 2A 8D ED 01 2A ?? ?? ?? ?? 00 28 0C DA DF ED 0C 0A 9F ED 0A 1A C9 EE 28 1A 9D ED 01 0A 01 EE A0 1A 30 EE 01 0A 04 E0 08 20 ?? ?? ?? ?? 9D ED 01 0A 02 B0 BD EC 04 8B BD E8 00 88 FE DE 1D 7F D6 3E AB AA AA 3D }
	condition:
		$1
}

rule file_89_5_0 {
	meta:
		name = "lgammaf"
		size = 488
		refs = "001a _fd_int 003e _fperrraise 0070 _fdsin 0082 _fdlog 0092 lgamma_big 00fe _fdpoly 0172 _fdtgamma 01b2 log1pf 01d0 approx 01d8 rootapprox 01e0 _fdgamma_big 01e4 _FInf_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 83 B0 02 A8 00 21 8D ED 01 0A 8D ED 02 0A ?? ?? ?? ?? 9D ED 01 1A 30 B1 01 28 0C D0 02 28 0E D1 B0 EE 41 0A C5 E0 B5 EE C0 1A F1 EE 10 FA 06 D8 04 20 ?? ?? ?? ?? 68 4B 93 ED 00 0A B9 E0 65 4B D3 ED 00 0A B1 EE 60 0A B4 EE C0 1A F1 EE 10 FA 1E D2 9D ED 02 0A 9F ED 5E 8A 00 20 31 EE 40 0A 20 EE 08 0A ?? ?? ?? ?? DD ED 01 0A 00 20 20 EE 20 0A 88 EE 00 0A ?? ?? ?? ?? 9D ED 01 2A B0 EE 40 8A B1 EE 42 0A ?? ?? ?? ?? 38 EE 40 0A 90 E0 F4 EE C1 0A F1 EE 10 FA 04 D8 B0 EE 41 0A ?? ?? ?? ?? 86 E0 49 49 00 23 0A 46 92 ED 00 0A B4 EE C1 0A F1 EE 10 FA 06 D2 92 ED 01 0A B4 EE C0 1A F1 EE 10 FA 03 D3 5B 1C 18 32 0C 2B ED D3 0C 2B 12 D2 03 EB 43 03 01 EB C3 03 D3 E9 04 01 93 ED 02 0A D3 ED 03 0A 31 EE 40 0A 30 EE 60 0A 8D ED 02 0A ?? ?? ?? ?? 5C E0 9F ED 33 0A B4 EE C1 0A F1 EE 10 FA 2D D2 B7 EE 08 0A B4 EE C0 1A F1 EE 10 FA 26 D2 2B 49 00 23 0A 46 92 ED 00 0A B4 EE C0 1A F1 EE 10 FA 03 D3 5B 1C 18 32 01 2B F4 D3 03 EB 43 03 01 EB C3 04 D4 E9 02 01 94 ED 01 0A 31 EE 40 0A 8D ED 02 0A ?? ?? ?? ?? D4 E9 04 01 B0 EE 40 8A 9D ED 02 0A ?? ?? ?? ?? 88 EE 00 0A 27 E0 69 46 01 A8 ?? ?? ?? ?? DD ED 01 0A 8D ED 02 0A 00 20 B0 EE E0 0A ?? ?? ?? ?? BD F9 00 30 DF ED 0F 1A B1 EE 40 2A 5B 42 9F ED 0C 1A 00 EE 90 3A 9D ED 02 0A F8 EE E0 0A 00 EE A1 2A 00 EE 81 2A 8D ED 01 2A ?? ?? ?? ?? DD ED 01 0A 30 EE 20 0A 03 B0 BD EC 02 8B BD E8 10 88 16 72 31 3F E8 E8 FB 33 ?? ?? ?? ?? 9A 99 99 3F ?? ?? ?? ?? DB 0F 49 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_2_0 {
	meta:
		name = "?initialize@?$dual_state_global@H@__crt_state_management@@QAAXH@Z"
		size = 42
		altNames = "?initialize@?$dual_state_global@J@__crt_state_management@@QAAXJ@Z ?initialize@?$dual_state_global@P6AHI@Z@__crt_state_management@@QAAXQ6AHI@Z@Z ?initialize@?$dual_state_global@P6AHPAU_exception@@@Z@__crt_state_management@@QAAXQ6AHPAU_exception@@@Z@Z ?initialize@?$dual_state_global@P6AXH@Z@__crt_state_management@@QAAXQ6AXH@Z@Z ?initialize@?$dual_state_global@PAPAD@__crt_state_management@@QAAXQAPAD@Z ?initialize@?$dual_state_global@PAPA_W@__crt_state_management@@QAAXQAPA_W@Z ?initialize@?$dual_state_global@PAU__crt_locale_data@@@__crt_state_management@@QAAXQAU__crt_locale_data@@@Z ?initialize@?$dual_state_global@PAU__crt_multibyte_data@@@__crt_state_management@@QAAXQAU__crt_multibyte_data@@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 02 1D 13 1A DB 1C 00 24 90 42 98 BF 9B 08 88 BF 00 23 23 B1 64 1C 9C 42 40 F8 04 1B FA D1 BD E8 18 88 }
	condition:
		$1
}

rule file_90_7_0 {
	meta:
		name = "__acrt_initialize_timeset"
		size = 52
		refs = "0024 ?_tzname@@3V?$dual_state_global@PAPAD@__crt_state_management@@A 0028 ?tzname_states@@3PAY01PADA 0030 ?_timezone@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 4A 4F F4 E1 43 13 60 01 23 53 60 06 4B 00 20 93 60 03 4A 02 4B 1A 60 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? F0 F1 FF FF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_8_0 {
	meta:
		name = "__daylight"
		size = 16
		refs = "000c ?_daylight@@3V?$dual_state_global@H@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_34_4 {
	meta:
		name = "?get_argv@@YAAAPAPADD@Z"
		size = 16
		refs = "000c __argv"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_35_4 {
	meta:
		name = "?get_argv@@YAAAPAPA_W_W@Z"
		size = 16
		refs = "000c __wargv"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_45_4 {
	meta:
		name = "?get_assert_format@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_0CK@CFPGFGGO@Assertion?5failed?3?5?$CFTs?0?5file?5?$CFTs?0@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_46_4 {
	meta:
		name = "?get_assert_format@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1FE@LHBLIKM@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_47_4 {
	meta:
		name = "?get_banner_text@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_48_0 {
	meta:
		name = "?get_banner_text@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_49_0 {
	meta:
		name = "?get_box_intro@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_50_0 {
	meta:
		name = "?get_box_intro@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1CE@OJBNHDMO@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CB?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_51_0 {
	meta:
		name = "?get_dot_dot_dot@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_03KHICJKCI@?4?4?4?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_52_0 {
	meta:
		name = "?get_dot_dot_dot@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_53_3 {
	meta:
		name = "?get_double_newline@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_02PHMGELLB@?6?6?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_54_2 {
	meta:
		name = "?get_double_newline@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_55_4 {
	meta:
		name = "?get_dual_state_environment_nolock@@YAAAV?$dual_state_global@PAPAD@__crt_state_management@@D@Z"
		size = 16
		refs = "000c _environ_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_56_0 {
	meta:
		name = "?get_dual_state_environment_nolock@@YAAAV?$dual_state_global@PAPA_W@__crt_state_management@@_W@Z"
		size = 16
		refs = "000c _wenviron_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_49_0 {
	meta:
		name = "?get_environment@@YAAAPAPADD@Z"
		size = 16
		refs = "000c _environ_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_50_3 {
	meta:
		name = "?get_environment@@YAAAPAPA_W_W@Z"
		size = 16
		refs = "000c _wenviron_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_57_3 {
	meta:
		name = "?get_environment_nolock@@YAAAPAPADD@Z"
		size = 16
		refs = "000c _environ_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_58_3 {
	meta:
		name = "?get_environment_nolock@@YAAAPAPA_W_W@Z"
		size = 16
		refs = "000c _wenviron_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_55_3 {
	meta:
		name = "?get_expression_intro@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_0N@MEECIJGN@Expression?3?5?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_56_2 {
	meta:
		name = "?get_expression_intro@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_14_3 {
	meta:
		name = "?get_failure_string@@YAPADD@Z"
		size = 16
		refs = "000c ??_C@_0EA@FCLIIPNN@Visual?5C?$CL?$CL?5CRT?3?5Not?5enough?5memor@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_15_3 {
	meta:
		name = "?get_failure_string@@YAPA_W_W@Z"
		size = 16
		refs = "000c ??_C@_1IA@JENHHBGD@?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAC?$AAR?$AAT?$AA?3?$AA?5?$AAN?$AAo?$AAt?$AA?5?$AAe?$AAn?$AAo?$AAu?$AAg?$AAh?$AA?5?$AAm?$AAe?$AAm?$AAo?$AAr@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_57_3 {
	meta:
		name = "?get_file_intro@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_06IGPBOHMJ@File?3?5?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_58_3 {
	meta:
		name = "?get_file_intro@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1O@HEMHKNDC@?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_60_3 {
	meta:
		name = "?get_help_intro@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_0DN@EBBNMLME@?$CIPress?5Retry?5to?5debug?5the?5applic@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_61_3 {
	meta:
		name = "?get_help_intro@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1HK@POCJMFGK@?$AA?$CI?$AAP?$AAr?$AAe?$AAs?$AAs?$AA?5?$AAR?$AAe?$AAt?$AAr?$AAy?$AA?5?$AAt?$AAo?$AA?5?$AAd?$AAe?$AAb?$AAu?$AAg?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAa?$AAp?$AAp?$AAl?$AAi?$AAc@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_62_0 {
	meta:
		name = "?get_info_intro@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_0HA@OJHAGA@For?5information?5on?5how?5your?5prog@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_63_4 {
	meta:
		name = "?get_info_intro@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1OA@EGMLFBHJ@?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr?$AAo?$AAg@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_51_4 {
	meta:
		name = "?get_initial_environment@@YAAAPAPADD@Z"
		size = 16
		refs = "000c __dcrt_initial_narrow_environment"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_52_0 {
	meta:
		name = "?get_initial_environment@@YAAAPAPA_W_W@Z"
		size = 16
		refs = "000c __dcrt_initial_wide_environment"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_64_3 {
	meta:
		name = "?get_line_intro@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_06FIEBOLOH@Line?3?5?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_65_2 {
	meta:
		name = "?get_line_intro@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1O@KCAFKHJE@?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_66_2 {
	meta:
		name = "?get_newline@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_67_0 {
	meta:
		name = "?get_newline@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_53_3 {
	meta:
		name = "?get_other_environment@@YAAAPAPAD_W@Z"
		size = 16
		refs = "000c _environ_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_54_4 {
	meta:
		name = "?get_other_environment@@YAAAPAPA_WD@Z"
		size = 16
		refs = "000c _wenviron_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_68_3 {
	meta:
		name = "?get_program_intro@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_09KLGCKDOD@Program?3?5?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_69_2 {
	meta:
		name = "?get_program_intro@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1BE@PHKBBGE@?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_70_3 {
	meta:
		name = "?get_program_name_unknown_text@@YAPBDD@Z"
		size = 16
		refs = "000c ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_71_3 {
	meta:
		name = "?get_program_name_unknown_text@@YAPB_W_W@Z"
		size = 16
		refs = "000c ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_229_0 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_230_3 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_231_0 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_467_0 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_468_3 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_469_3 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_470_4 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_471_3 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_472_0 {
	meta:
		name = "?narrow_null_string@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_232_4 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_233_0 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_234_0 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_473_4 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_474_0 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_475_0 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_476_2 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_477_4 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_478_3 {
	meta:
		name = "?narrow_null_string@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPADXZ"
		size = 16
		refs = "000c ??_C@_06OJHGLDPL@?$CInull?$CJ?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_330_4 {
	meta:
		name = "?state_transition_table@?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c format_validation_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_669_3 {
	meta:
		name = "?state_transition_table@?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c format_validation_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_670_0 {
	meta:
		name = "?state_transition_table@?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c format_validation_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_331_0 {
	meta:
		name = "?state_transition_table@?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c format_validation_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_671_3 {
	meta:
		name = "?state_transition_table@?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c format_validation_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_672_3 {
	meta:
		name = "?state_transition_table@?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c format_validation_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_332_3 {
	meta:
		name = "?state_transition_table@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c standard_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_673_0 {
	meta:
		name = "?state_transition_table@?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c standard_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_674_3 {
	meta:
		name = "?state_transition_table@?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c standard_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_333_3 {
	meta:
		name = "?state_transition_table@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c standard_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_675_4 {
	meta:
		name = "?state_transition_table@?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c standard_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_676_4 {
	meta:
		name = "?state_transition_table@?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@KAPBEXZ"
		size = 16
		refs = "000c standard_lookup_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_455_3 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_456_4 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_457_4 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_917_0 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_918_0 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_919_2 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_920_0 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_921_0 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_922_4 {
	meta:
		name = "?wide_null_string@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_458_3 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_459_3 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_460_2 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_923_2 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_924_0 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_925_0 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_926_0 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_927_2 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_928_0 {
	meta:
		name = "?wide_null_string@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CAPA_WXZ"
		size = 16
		refs = "000c ??_C@_1O@CEDCILHN@?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_9_3 {
	meta:
		name = "__dstbias"
		size = 16
		refs = "000c ?_dstbias@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_74_4 {
	meta:
		name = "__local_stdio_printf_options"
		size = 16
		refs = "000c ?_OptionsStorage@?1??__local_stdio_printf_options@@9@4_KA"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_518_2_4 {
	meta:
		name = "__p___argc"
		size = 16
		refs = "000c __argc"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_518_3_0 {
	meta:
		name = "__p___argv"
		size = 16
		refs = "000c __argv"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_518_4_3 {
	meta:
		name = "__p___wargv"
		size = 16
		refs = "000c __wargv"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_518_5_3 {
	meta:
		name = "__p__acmdln"
		size = 16
		refs = "000c _acmdln"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_666_0_0 {
	meta:
		name = "__p__commode"
		size = 16
		refs = "000c _commode"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_78_2 {
	meta:
		name = "__p__environ"
		size = 16
		refs = "000c _environ_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_259_2_4 {
	meta:
		name = "__p__fmode"
		size = 16
		refs = "000c _fmode"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_518_6_0 {
	meta:
		name = "__p__pgmptr"
		size = 16
		refs = "000c _pgmptr"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_518_7_2 {
	meta:
		name = "__p__wcmdln"
		size = 16
		refs = "000c _wcmdln"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_79_0 {
	meta:
		name = "__p__wenviron"
		size = 16
		refs = "000c _wenviron_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_518_8_3 {
	meta:
		name = "__p__wpgmptr"
		size = 16
		refs = "000c _wpgmptr"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_0_2 {
	meta:
		name = "__sys_errlist"
		size = 16
		refs = "000c _sys_errlist"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "__sys_nerr"
		size = 16
		refs = "000c _sys_nerr"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_10_2 {
	meta:
		name = "__timezone"
		size = 16
		refs = "000c ?_timezone@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_11_0 {
	meta:
		name = "__tzname"
		size = 20
		refs = "0010 ?_tzname@@3V?$dual_state_global@PAPAD@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_4_0 {
	meta:
		name = "?get_command_line@@YAPADD@Z"
		size = 20
		refs = "0010 _acmdln"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_5_0 {
	meta:
		name = "?get_command_line@@YAPA_W_W@Z"
		size = 20
		refs = "0010 _wcmdln"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_614_0_4 {
	meta:
		name = "?select_heap@@YAPAXQAX@Z"
		size = 20
		refs = "0010 __acrt_heap"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_0_3 {
	meta:
		name = "__acrt_getheap"
		size = 20
		refs = "0010 __acrt_heap"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_456_38_2 {
	meta:
		name = "__p__mbcasemap"
		size = 20
		refs = "0010 _mbcasemap"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_456_39_2 {
	meta:
		name = "__p__mbctype"
		size = 20
		refs = "0010 _mbctype"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_433_1_4 {
	meta:
		name = "__pwctype_func"
		size = 20
		refs = "0010 _pwctype"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_3_2 {
	meta:
		name = "_get_heap_handle"
		size = 20
		refs = "0010 __acrt_heap"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_244_5_0 {
	meta:
		name = "_query_app_type"
		size = 20
		refs = "0010 ?__acrt_app_type@@3W4_crt_app_type@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 68 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_12_0 {
	meta:
		name = "_get_daylight"
		size = 40
		refs = "0008 _errno 0010 _invalid_parameter_noinfo 0024 ?_daylight@@3V?$dual_state_global@H@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 38 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 03 E0 02 4B 1B 68 03 60 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_13_0 {
	meta:
		name = "_get_dstbias"
		size = 40
		refs = "0008 _errno 0010 _invalid_parameter_noinfo 0024 ?_dstbias@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 38 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 03 E0 02 4B 1B 68 03 60 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_14_0 {
	meta:
		name = "_get_timezone"
		size = 40
		refs = "0008 _errno 0010 _invalid_parameter_noinfo 0024 ?_timezone@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 38 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 03 E0 02 4B 1B 68 03 60 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_15_0 {
	meta:
		name = "_get_tzname"
		size = 112
		refs = "002e strlen 0040 _errno 0048 _invalid_parameter_noinfo 0064 strcpy_s 006c ?_tzname@@3V?$dual_state_global@PAPAD@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0D 46 1E 46 14 46 07 46 A5 B1 AC B1 0D B1 00 23 2B 70 8F B1 0E B1 01 2E 0E D1 DF F8 48 80 D8 F8 00 30 53 F8 26 00 ?? ?? ?? ?? 43 1C 3B 60 5D B9 00 20 15 E0 00 2C E9 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 0B E0 A3 42 88 BF 22 20 07 D8 D8 F8 00 30 21 46 28 46 53 F8 26 20 ?? ?? ?? ?? BD E8 F8 89 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "_hypot"
		size = 404
		refs = "0060 _controlfp_s 0160 _handle_error 017c ??_C@_06MEIMCGCF@_hypot?$AA@"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 53 EC 10 7B 4F F0 00 08 23 F0 00 40 53 EC 11 4B 06 0D 23 F0 00 41 40 F2 FF 72 0D 0D 96 42 B0 EE 40 2B C1 46 0B D1 6F F3 1F 50 57 EA 00 03 0D D0 95 42 06 D0 21 EE 01 0B 02 EE 02 0B 93 E0 95 42 10 D1 6F F3 1F 51 54 EA 01 03 F3 D1 00 23 04 A8 00 22 00 21 04 93 ?? ?? ?? ?? 44 4B 00 22 43 EC 10 2B 80 E0 72 1B 57 EA 00 03 40 EC 15 7B 41 EC 10 4B 4F F0 00 0E 76 D0 54 EA 01 03 02 D1 B0 EE 45 0B 70 E0 02 F1 36 03 6C 2B 6A D8 40 F2 F3 53 B8 F1 00 0F 2F D8 01 D3 9E 42 2C D8 B9 F1 00 0F 29 D8 01 D3 9D 42 26 D8 40 F2 0B 23 9E 42 05 D3 B9 F1 00 0F 29 D8 01 D3 9D 42 26 D2 4F F0 16 52 DF F8 C4 E0 9F ED 2E 1B 33 00 02 F5 80 16 05 D1 83 19 43 EC 10 7B 30 EE 41 5B 02 E0 83 18 43 EC 15 7B 2B 00 05 D1 8B 19 43 EC 10 4B 30 EE 41 0B 0B E0 8B 18 07 E0 4F F0 16 52 83 1A 4F F4 16 7E 43 EC 15 7B 8B 1A 43 EC 10 4B 20 EE 00 2B 40 F2 FF 33 13 EB 0E 03 05 EE 05 2B B1 EE C2 4B 1B 05 00 22 9F ED 14 3B 43 EC 12 2B 24 EE 02 1B B4 EE C3 1B F1 EE 10 FA 11 DD 02 23 03 93 22 23 02 93 11 23 01 93 03 23 0A 48 00 93 08 4B B0 EE 40 1B B0 EE 45 0B 18 21 ?? ?? ?? ?? 04 E0 B0 EE 41 0B 01 E0 30 EE 05 0B 06 B0 BD E8 F0 8B FE DE 00 00 F0 7F ?? ?? ?? ?? FF FF FF FF FF FF EF 7F 00 00 00 00 00 00 90 25 A8 FD FF FF }
	condition:
		$1
}

rule file_91_2_0 {
	meta:
		name = "infinity_with_flags"
		size = 40
		refs = "0012 _controlfp_s"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 01 46 00 23 0A 46 68 46 00 93 ?? ?? ?? ?? 03 4B 00 22 43 EC 10 2B BD E8 0C 88 FE DE 00 00 F0 7F }
	condition:
		$1
}

rule file_91_4_0 {
	meta:
		name = "scaleDouble_1"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 40 F2 FF 33 1B 18 1B 05 00 22 43 EC 12 2B 22 EE 00 0B BD E8 00 88 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "ceil"
		size = 184
		refs = "003a _handle_nan"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 54 EC 10 0B 4F F0 00 41 24 EA 01 02 27 4B 94 42 08 BF 00 25 18 BF 01 25 9A 42 B0 EE 40 1B 0D D3 01 D8 00 28 0A D3 20 4B 9A 42 36 D3 00 D8 A0 B3 21 46 ?? ?? ?? ?? B0 EE 40 1B 2E E0 19 4B 9A 42 0C D8 0B D2 50 EA 02 03 27 D0 2B 00 03 D0 00 23 41 EC 11 3B 21 E0 B7 EE 00 1B 1E E0 C4 F3 0A 52 40 F2 33 43 9A 1A A2 F1 20 03 01 21 99 40 01 23 93 40 6F F0 00 02 9B 18 4A 41 24 EA 02 02 20 EA 03 01 2B 00 42 EC 11 1B 07 D1 81 42 01 D1 A2 42 03 D0 B7 EE 00 0B 31 EE 00 1B B0 EE 41 0B BD E8 30 88 FE DE 00 00 F0 3F 00 00 F0 7F 00 00 40 43 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "__dcrt_lowio_initialize_console_output"
		size = 60
		refs = "0030 __dcrt_lowio_console_output_handle 0034 ??_C@_1BA@BALFACEM@?$AAC?$AAO?$AAN?$AAO?$AAU?$AAT?$AA$?$AA?$AA@ 0038 __imp_CreateFileW"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 0B 4C 00 23 02 93 01 93 03 23 07 48 24 68 00 93 00 23 03 22 4F F0 80 41 A0 47 02 4B 18 60 05 B0 BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_1_0 {
	meta:
		name = "__dcrt_terminate_console_output"
		size = 40
		refs = "0020 __imp_CloseHandle 0024 __dcrt_lowio_console_output_handle"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4B 18 68 B0 F1 FF 3F 05 D0 10 F1 02 0F 02 D0 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "__dcrt_terminate_console_input"
		size = 40
		refs = "0020 __imp_CloseHandle 0024 __dcrt_lowio_console_input_handle"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4B 18 68 B0 F1 FF 3F 05 D0 10 F1 02 0F 02 D0 02 4B 1B 68 98 47 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "_LCmulcc"
		size = 114
		refs = "001c creall 002c cimagl 0064 _LCbuild"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 06 8B 88 B0 8D ED 06 1B 8D ED 04 0B 8D ED 02 3B 8D ED 00 2B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 AB 9D ED 04 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 9B 9D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? 28 EE 0A 3B 20 EE 0A 1B 20 EE 09 2B 08 EE 09 1B 33 EE 42 0B ?? ?? ?? ?? 08 B0 BD EC 06 8B BD E8 00 88 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "_Cmulcc"
		size = 114
		refs = "001c creal 002c cimag 0064 _Cbuild"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 06 8B 88 B0 8D ED 06 1B 8D ED 04 0B 8D ED 02 3B 8D ED 00 2B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 AB 9D ED 04 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 9B 9D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? 28 EE 0A 3B 20 EE 0A 1B 20 EE 09 2B 08 EE 09 1B 33 EE 42 0B ?? ?? ?? ?? 08 B0 BD EC 06 8B BD E8 00 88 }
	condition:
		$1
}

rule file_95_1_0 {
	meta:
		name = "_LCmulcr"
		size = 66
		refs = "0018 cimagl 0028 creall 0034 _LCbuild"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 84 B0 8D ED 02 1B 8D ED 00 0B B0 EE 42 9B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? 28 EE 09 1B 20 EE 09 0B ?? ?? ?? ?? 04 B0 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_341_1_0 {
	meta:
		name = "_Cmulcr"
		size = 66
		refs = "0018 cimag 0028 creal 0034 _Cbuild"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 84 B0 8D ED 02 1B 8D ED 00 0B B0 EE 42 9B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? 28 EE 09 1B 20 EE 09 0B ?? ?? ?? ?? 04 B0 BD EC 04 8B BD E8 00 88 }
	condition:
		$1
}

rule file_95_2_0 {
	meta:
		name = "cpowl"
		size = 192
		refs = "001c cimagl 0032 creall 007a pow 0082 _LCbuild 0090 clogl 00a4 _LCmulcc 00a8 cexpl"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 88 B0 8D ED 02 1B 8D ED 00 0B 8D ED 06 3B 8D ED 04 2B ?? ?? ?? ?? B5 EE 40 0B F1 EE 10 FA 2E D1 9D ED 00 0B 9D ED 02 1B ?? ?? ?? ?? B5 EE C0 0B F1 EE 10 FA 23 DB 9D ED 04 0B 9D ED 06 1B ?? ?? ?? ?? B5 EE 40 0B F1 EE 10 FA 18 D1 9D ED 04 0B 9D ED 06 1B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B 9F ED 10 8B ?? ?? ?? ?? B0 EE 48 1B ?? ?? ?? ?? 11 E0 9D ED 00 0B 9D ED 02 1B ?? ?? ?? ?? B0 EE 41 3B 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B ?? ?? ?? ?? ?? ?? ?? ?? 08 B0 BD EC 02 8B BD E8 00 88 FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_341_2_0 {
	meta:
		name = "cpow"
		size = 192
		refs = "001c cimag 0032 creal 007a pow 0082 _Cbuild 0090 clog 00a4 _Cmulcc 00a8 cexp"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 88 B0 8D ED 02 1B 8D ED 00 0B 8D ED 06 3B 8D ED 04 2B ?? ?? ?? ?? B5 EE 40 0B F1 EE 10 FA 2E D1 9D ED 00 0B 9D ED 02 1B ?? ?? ?? ?? B5 EE C0 0B F1 EE 10 FA 23 DB 9D ED 04 0B 9D ED 06 1B ?? ?? ?? ?? B5 EE 40 0B F1 EE 10 FA 18 D1 9D ED 04 0B 9D ED 06 1B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B 9F ED 10 8B ?? ?? ?? ?? B0 EE 48 1B ?? ?? ?? ?? 11 E0 9D ED 00 0B 9D ED 02 1B ?? ?? ?? ?? B0 EE 41 3B 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B ?? ?? ?? ?? ?? ?? ?? ?? 08 B0 BD EC 02 8B BD E8 00 88 FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "initialize_global_variables"
		size = 28
		refs = "0014 __acrt_current_locale_data 0018 __acrt_initial_locale_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4A 02 4B 01 20 1A 60 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_1_0 {
	meta:
		name = "initialize_c"
		size = 32
		refs = "0008 _initialize_onexit_table 0018 __acrt_at_quick_exit_table 001c __acrt_atexit_table"
	strings:
		$1 = { 2D E9 00 48 EB 46 05 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 01 20 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_4_0 {
	meta:
		name = "uninitialize_environment"
		size = 16
		refs = "0006 __dcrt_uninitialize_environments_nolock"
		altNames = "?is_zero@__crt_strtox@@YA_NABUbig_integer@1@@Z ?state_case_dot@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ ?state_case_dot@?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAA_NXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_170_72_0 {
	meta:
		name = "?close@stream_traits@?A0xe43b7539@@SA_NPAU_iobuf@@@Z"
		size = 16
		refs = "0006 fclose"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_96_20_0 {
	meta:
		name = "__acrt_thread_detach"
		size = 16
		refs = "0006 __acrt_freeptd"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_96_22_0 {
	meta:
		name = "__acrt_uninitialize_critical"
		size = 16
		refs = "0006 __acrt_uninitialize_ptd"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_96_7_0 {
	meta:
		name = "initialize_pointers"
		size = 76
		refs = "001e __acrt_initialize_invalid_parameter_handler 0026 __acrt_initialize_new_handler 002e __acrt_initialize_signal_handlers 0036 __acrt_initialize_user_matherr 003e __acrt_initialize_thread_local_exit_callback 0048 __security_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0F 4B 00 22 1D 68 05 F0 1F 03 C3 F1 20 03 62 FA 03 F4 84 EA 05 00 ?? ?? ?? ?? 84 EA 05 00 ?? ?? ?? ?? 84 EA 05 00 ?? ?? ?? ?? 84 EA 05 00 ?? ?? ?? ?? 84 EA 05 00 ?? ?? ?? ?? 01 20 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_8_0 {
	meta:
		name = "uninitialize_vcruntime"
		size = 16
		refs = "000c __vcrt_uninitialize"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_227_14_0 {
	meta:
		name = "_Getdays"
		size = 16
		refs = "000c _Getdays_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_227_16_0 {
	meta:
		name = "_Getmonths"
		size = 16
		refs = "000c _Getmonths_l"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_409_9_0 {
	meta:
		name = "_fgetchar"
		size = 20
		refs = "0008 __acrt_iob_func 0010 fgetc"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_460_8_3 {
	meta:
		name = "_fgetwchar"
		size = 20
		refs = "0008 __acrt_iob_func 0010 fgetwc"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_409_14_0 {
	meta:
		name = "getchar"
		size = 20
		refs = "0008 __acrt_iob_func 0010 fgetc"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_460_13_0 {
	meta:
		name = "getwchar"
		size = 20
		refs = "0008 __acrt_iob_func 0010 fgetwc"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 ?? ?? ?? ?? BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_641_0_4 {
	meta:
		name = "remainder"
		size = 16
		refs = "000c remquo"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_630_0_3 {
	meta:
		name = "remainderf"
		size = 16
		refs = "000c remquof"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_655_0_3 {
	meta:
		name = "remainderl"
		size = 16
		refs = "000c remquol"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_9_0 {
	meta:
		name = "uninitialize_allocated_memory"
		size = 92
		refs = "000c ??$uninitialize@V<lambda_af42a3ee9806e9a7305d451646e05244>@@@?$dual_state_global@PAU__crt_multibyte_data@@@__crt_state_management@@QAAX$$QAV<lambda_af42a3ee9806e9a7305d451646e05244>@@@Z 0014 _free_base 0048 __wargv 004c __argv 0050 __acrt_stderr_buffer 0054 __acrt_stdout_buffer 0058 __acrt_current_multibyte_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 13 48 69 46 ?? ?? ?? ?? 10 4C 20 68 ?? ?? ?? ?? 00 23 23 60 0C 4C 20 68 ?? ?? ?? ?? 00 23 23 60 08 4C 20 68 ?? ?? ?? ?? 00 23 23 60 04 4C 20 68 ?? ?? ?? ?? 00 23 23 60 01 20 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_18_0 {
	meta:
		name = "__acrt_initialize"
		size = 24
		refs = "0010 __acrt_execute_initializers 0014 __acrt_initializers"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 48 00 F1 78 01 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_21_0 {
	meta:
		name = "__acrt_uninitialize"
		size = 24
		refs = "0010 __acrt_execute_uninitializers 0014 __acrt_initializers"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 48 00 F1 78 01 BD E8 00 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_19_0 {
	meta:
		name = "__acrt_thread_attach"
		size = 22
		refs = "0006 __acrt_getptd_noexit"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 08 B9 00 20 00 E0 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_97_3_0 {
	meta:
		name = "?_mbrtowc_s_l@@YAHPAHPA_WPBDIPAU_Mbstatet@@PAU__crt_locale_pointers@@@Z"
		size = 372
		refs = "0034 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 00b4 _errno 00c6 _isleadbyte_l 00f0 strlen 0170 __imp_MultiByteToWideChar"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 87 B0 9A 46 0E 46 00 23 17 46 05 46 06 B1 33 80 00 2F 00 F0 A2 80 BA F1 00 0F 00 F0 9E 80 97 F9 00 40 00 2C 00 F0 99 80 11 99 02 A8 ?? ?? ?? ?? 03 98 D0 F8 A8 30 D0 F8 04 90 9B B9 0E B1 3B 78 33 80 0D B1 01 23 2B 60 00 20 9D F8 14 30 00 2B 00 F0 86 80 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 7D E0 DD F8 40 80 D8 F8 00 30 2B B3 3B 78 B9 F1 01 0F 88 F8 01 30 15 DD 0E B1 01 23 00 E0 00 23 39 4C 80 68 01 93 24 68 02 23 42 46 09 21 00 96 A0 47 38 B1 00 24 C8 F8 00 40 00 2D D3 D0 C5 F8 00 90 D0 E7 00 24 C8 F8 00 40 ?? ?? ?? ?? 2A 23 03 60 00 2E 48 D0 46 E0 38 78 03 A9 ?? ?? ?? ?? 58 B3 CA 45 07 D2 3B 78 00 2D 88 F8 00 30 BA D0 6F F0 01 03 B6 E7 B9 F1 01 0F 19 DD 0E B1 01 24 00 E0 00 24 38 46 ?? ?? ?? ?? 6F F0 00 43 98 42 03 D2 38 46 ?? ?? ?? ?? 03 46 03 98 01 94 19 4C 80 68 3A 46 24 68 09 21 00 96 A0 47 00 28 C4 D1 97 F9 01 30 00 2B C0 D1 C4 E7 0E B1 01 23 00 E0 00 23 03 98 10 4C 01 93 80 68 24 68 01 23 3A 46 09 21 00 96 A0 47 00 28 82 D1 ?? ?? ?? ?? 2A 23 03 60 0E B1 00 24 34 80 15 B1 6F F0 00 03 2B 60 ?? ?? ?? ?? 00 68 77 E7 05 B1 2B 60 00 20 07 B0 BD E8 F0 8F FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_4_0 {
	meta:
		name = "?_mbsrtowcs_helper@@YAIPA_WPAPBDIPAU_Mbstatet@@@Z"
		size = 232
		refs = "0014 _errno 001c _invalid_parameter_noinfo 0032 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0054 ?_mbrtowc_s_l@@YAHPAHPA_WPBDIPAU_Mbstatet@@PAU__crt_locale_pointers@@@Z 00e4 ?mbst@?1??_mbsrtowcs_helper@@YAIPA_WPAPBDIPAU_Mbstatet@@@Z@4U2@A"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 89 B0 0E 46 98 46 91 46 07 46 46 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 5A E0 00 23 35 68 04 A8 00 21 03 93 00 24 ?? ?? ?? ?? B8 F1 00 0F 01 D1 DF F8 A4 80 17 BB 05 AB 01 93 6F F0 00 43 02 A9 03 A8 2A 46 CD F8 00 80 ?? ?? ?? ?? 03 9B 00 2B 11 DB 05 AE 00 2B 31 D0 1D 44 2A 46 6F F0 00 43 02 A9 03 A8 64 1C 01 96 CD F8 00 80 ?? ?? ?? ?? 03 9B 00 2B EF DA 6F F0 00 04 1F E0 B9 F1 00 0F 1B D0 0D F1 14 0A 6F F0 00 43 2A 46 39 46 03 A8 CD F8 04 A0 CD F8 00 80 ?? ?? ?? ?? 03 9B 00 2B 09 DB 06 D0 64 1C 1D 44 BF 1C B9 F1 01 09 EA D1 03 E0 00 25 01 E0 6F F0 00 04 35 60 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 09 B0 BD E8 F0 8F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_6_0 {
	meta:
		name = "btowc"
		size = 82
		refs = "0036 ?_mbrtowc_s_l@@YAHPAHPA_WPBDIPAU_Mbstatet@@PAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 86 B0 6F F0 00 02 90 42 02 D1 4F F6 FF 70 1A E0 00 23 CD E9 04 33 AD F8 0A 30 01 93 04 AB 00 93 8D F8 08 00 03 92 01 23 02 AA 0D F1 0A 01 03 A8 ?? ?? ?? ?? 03 9B 00 2B 02 DA 4F F6 FF 73 01 E0 BD F8 0A 30 98 B2 06 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_97_7_0 {
	meta:
		name = "mbrlen"
		size = 48
		refs = "0022 ?_mbrtowc_s_l@@YAHPAHPA_WPBDIPAU_Mbstatet@@PAU__crt_locale_pointers@@@Z 002c ?mbst@?1??mbrlen@@9@4U_Mbstatet@@A"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 6F F0 00 03 02 93 04 46 02 B9 06 4A 00 23 01 93 0B 46 00 92 02 A8 00 21 22 46 ?? ?? ?? ?? 02 98 BD E8 1E 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_8_0 {
	meta:
		name = "mbrtowc"
		size = 76
		refs = "0038 ?_mbrtowc_s_l@@YAHPAHPA_WPBDIPAU_Mbstatet@@PAU__crt_locale_pointers@@@Z 0044 ??_C@_00CNPNBAHC@?$AA@ 0048 ?mbst@?1??mbrtowc@@9@4U_Mbstatet@@A"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 04 46 6F F0 00 00 02 90 49 B1 03 B9 0C 4B 00 20 00 93 13 46 01 90 0A 46 02 A8 21 46 08 E0 03 B9 07 4B 00 22 00 93 01 92 04 4A 02 A8 01 23 00 21 ?? ?? ?? ?? 02 98 BD E8 1E 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_97_10_0 {
	meta:
		name = "mbsrtowcs_s"
		size = 146
		refs = "0026 _errno 002e _invalid_parameter_noinfo 004c ?_mbsrtowcs_helper@@YAIPA_WPAPBDIPAU_Mbstatet@@@Z"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 06 46 1F 46 15 46 0C 46 6F F0 00 09 0E B1 C0 F8 00 90 4F F0 00 08 0C B9 5D B1 00 E0 3D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 2B E0 A4 F8 00 80 00 2F F3 D0 08 9A 09 9B 39 46 AA 42 88 BF 2A 46 20 46 ?? ?? ?? ?? 48 45 06 D1 0C B1 A4 F8 00 80 ?? ?? ?? ?? 00 68 15 E0 40 1C 84 B1 85 42 0A D2 A4 F8 00 80 0B D9 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 20 06 E0 04 EB 40 03 23 F8 02 8C 06 B1 30 60 00 20 BD E8 F0 8B }
	condition:
		$1
}

rule file_99_9_0 {
	meta:
		name = "__acrt_GetStringTypeA"
		size = 316
		refs = "0008 __security_push_cookie 0022 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0098 __chkstk 00b8 _malloc_base 00d2 memset 010e _free_base 012a __security_pop_cookie 0134 __imp_GetStringTypeW 0138 __imp_MultiByteToWideChar"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 88 B0 6F 46 82 B0 B9 60 01 46 1C 46 15 46 17 F1 10 00 C7 E9 00 45 ?? ?? ?? ?? D7 F8 4C 90 B9 F1 00 0F 02 D1 7B 69 D3 F8 08 90 3B 6D 0B B1 09 21 00 E0 01 21 00 23 01 93 00 93 23 46 3B 4C 2A 46 48 46 24 68 A0 47 82 46 08 B9 00 24 5B E0 4F EA 4A 06 06 F1 08 03 B3 42 98 BF 00 23 4D F6 DD 58 63 B3 06 F1 08 03 B3 42 98 BF 00 23 B3 F5 80 6F 17 D8 06 F1 08 03 B3 42 98 BF 00 23 DA 1D 9A 42 01 D8 6F F0 07 02 22 F0 07 03 9C 08 ?? ?? ?? ?? AD EB 04 0D 1D F1 08 05 11 D0 4C F6 CC 43 2B 60 0A E0 06 F1 08 00 B0 42 98 BF 00 20 ?? ?? ?? ?? 05 46 F5 B1 C0 F8 00 80 08 35 00 E0 00 25 C5 B1 32 46 00 21 28 46 ?? ?? ?? ?? 18 4C D7 E9 00 32 01 21 24 68 48 46 CD F8 04 A0 00 95 A0 47 40 B1 11 4C BB 6C 02 46 24 68 B8 68 29 46 A0 47 04 46 00 E0 00 24 3D B1 55 F8 08 3C 43 45 03 D1 A5 F1 08 00 ?? ?? ?? ?? 3B 7F 33 B1 3A 69 D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 BD 46 08 B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "clogf"
		size = 448
		refs = "0016 crealf 002a cimagf 0034 _fdtest 007e atan2f 00e0 _fperrraise 011c _fd_int 0164 log1pf 018a logf 01a6 _FCbuild 01b4 _FInf_C"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 04 8B 86 B0 CD ED 05 0A 8D ED 04 0A ?? ?? ?? ?? DD ED 05 0A B0 EE 40 1A 9D ED 04 0A 8D ED 00 1A ?? ?? ?? ?? 68 46 8D ED 01 0A ?? ?? ?? ?? 05 46 01 A8 ?? ?? ?? ?? 04 46 02 2D 09 D1 01 2C 02 D1 DD ED 00 0A A7 E0 9D ED 00 0A F0 EE 40 0A A5 E0 02 2C 07 D1 01 2D 02 D1 DD ED 01 0A 9B E0 9D ED 01 0A F2 E7 9D ED 00 8A DD ED 01 8A F0 EE 48 0A B0 EE 68 0A ?? ?? ?? ?? 01 2D B0 EE 40 9A 00 F0 88 80 01 2C 00 F0 85 80 B5 EE C0 8A F1 EE 10 FA 03 D2 B1 EE 48 8A 8D ED 00 8A F5 EE C0 8A F1 EE 10 FA 03 D2 F1 EE 68 8A CD ED 01 8A B4 EE E8 8A F1 EE 10 FA 09 D2 B0 EE 48 0A B0 EE 68 8A CD ED 00 8A F0 EE 40 8A 8D ED 01 0A B5 EE 40 8A F1 EE 10 FA 0A D1 04 20 ?? ?? ?? ?? 33 4B F0 EE 49 0A 93 ED 00 0A B1 EE 40 0A 58 E0 9F ED 31 0A B4 EE C0 8A F1 EE 10 FA 39 D8 9F ED 2D 0A B4 EE E8 0A F1 EE 10 FA 32 D8 02 A8 0B 21 8D ED 02 8A CD ED 03 8A ?? ?? ?? ?? 03 A8 0B 21 ?? ?? ?? ?? 9D ED 00 0A DD ED 02 0A 30 EE 60 1A 30 EE 20 0A 60 EE A0 1A 21 EE 00 2A 9D ED 01 0A 9D ED 03 1A F7 EE 00 0A 71 EE E0 1A 70 EE 41 0A 30 EE 01 0A 41 EE 01 1A 00 EE 80 2A 32 EE 21 0A ?? ?? ?? ?? B6 EE 00 1A F0 EE 49 0A 20 EE 01 0A 17 E0 88 EE 88 0A 20 EE 00 0A ?? ?? ?? ?? B0 EE 40 8A 9D ED 00 0A ?? ?? ?? ?? B6 EE 00 2A F0 EE 49 0A 08 EE 02 0A 04 E0 F0 EE 49 0A 04 4B 93 ED 00 0A ?? ?? ?? ?? 06 B0 BD EC 04 8B BD E8 30 88 ?? ?? ?? ?? CD CC CC 3E 66 66 66 3F }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "feclearexcept"
		size = 64
		refs = "000e _getfpstatusword 001a __acrt_fenv_get_fp_status_word_from_exception_mask 0024 _setfpstatusword 002e fetestexcept"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 10 F0 1F 04 15 D0 ?? ?? ?? ?? 05 46 25 42 10 D0 20 46 ?? ?? ?? ?? 25 EA 00 04 20 46 ?? ?? ?? ?? 04 F0 1F 04 20 46 ?? ?? ?? ?? A0 42 18 BF 01 20 00 D1 00 20 BD E8 30 88 }
	condition:
		$1
}

rule file_103_1_0 {
	meta:
		name = "__get_machine_status"
		size = 68
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 00 20 13 F0 1F 0F 17 D0 13 F0 10 0F 18 BF 01 20 13 F0 08 0F 01 D0 40 F0 02 00 13 F0 04 0F 01 D0 40 F0 04 00 13 F0 02 0F 01 D0 40 F0 08 00 13 F0 01 0F 01 D0 40 F0 10 00 BD E8 00 88 }
	condition:
		$1
}

rule file_103_2_0 {
	meta:
		name = "_getfpcontrolword"
		size = 24
		refs = "000a _controlfp"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 00 20 ?? ?? ?? ?? 40 F2 1F 33 18 40 BD E8 00 88 }
	condition:
		$1
}

rule file_103_3_0 {
	meta:
		name = "_getfpstatusword"
		size = 18
		refs = "0006 _statusfp"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 00 F0 1F 00 BD E8 00 88 }
	condition:
		$1
}

rule file_103_4_0 {
	meta:
		name = "_setfpcontrolword"
		size = 20
		refs = "000c _controlfp"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 49 BD E8 00 48 ?? ?? ?? ?? 1F 03 08 00 }
	condition:
		$1
}

rule file_103_5_0 {
	meta:
		name = "_setfpstatusword"
		size = 36
		refs = "000e __get_machine_status"
	strings:
		$1 = { 2D E9 00 48 EB 46 F1 EE 10 3A 83 F4 1F 42 ?? ?? ?? ?? 22 F0 1F 03 03 43 83 F4 1F 43 E1 EE 10 3A BD E8 00 88 }
	condition:
		$1
}

rule file_104_11_0 {
	meta:
		name = "rewind"
		size = 236
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0020 _fileno 0028 _lock_file 002e __acrt_stdio_flush_nolock 00b8 _lseek 00dc _unlock_file 00e4 __badioinfo 00e8 __pioinfo"
	strings:
		$1 = { 2D E9 BE 48 0D F1 18 0B 6F 46 04 46 3C 60 34 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 60 E0 20 46 ?? ?? ?? ?? 05 46 20 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 7C 60 63 68 23 60 00 23 A3 60 BF F3 5B 8F 0C 34 54 E8 00 1F 21 F0 18 02 44 E8 00 23 00 2B F7 D1 BF F3 5B 8F B5 F1 FF 3F 0D D0 15 F1 02 0F 0A D0 A8 11 20 49 05 F0 3F 03 03 EB 43 02 51 F8 20 30 03 EB 02 12 00 E0 1A 4A 92 F8 28 30 03 F0 FD 03 82 F8 28 30 23 68 BF F3 5B 8F 13 F0 04 0F 01 D0 01 23 00 E0 00 23 5B B1 BF F3 5B 8F 54 E8 00 1F 21 F0 03 02 44 E8 00 23 00 2B F7 D1 BF F3 5B 8F 00 22 00 21 28 46 ?? ?? ?? ?? B0 F1 FF 3F 0B D1 BF F3 5B 8F 54 E8 00 1F 41 F0 10 02 44 E8 00 23 00 2B F7 D1 BF F3 5B 8F 38 68 ?? ?? ?? ?? BD E8 BE 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "nearbyint"
		size = 34
		refs = "000e _dtest 001a _drint"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 9D ED 00 0B 02 28 01 D9 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "nearbyintl"
		size = 34
		refs = "000e _ldtest 001a _ldrint"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 9D ED 00 0B 02 28 01 D9 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "??$common_wincmdln@D@@YAPADXZ"
		size = 88
		refs = "0008 __acrt_initialize_multibyte 002e _ismbblead 0050 ?empty_string@?1???$common_wincmdln@D@@YAPADXZ@4PADA 0054 _acmdln"
		altNames = "_get_narrow_winmain_command_line"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 11 4B 1C 68 04 B9 0F 4C 00 25 94 F9 00 00 20 28 01 DC 78 B1 75 B1 22 28 03 D1 0D B9 01 25 00 E0 00 25 ?? ?? ?? ?? 00 B1 64 1C 64 1C ED E7 20 2B 04 DC 64 1C 94 F9 00 30 00 2B F8 D1 20 46 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "??$common_wincmdln@_W@@YAPA_WXZ"
		size = 68
		refs = "003c ?empty_string@?1???$common_wincmdln@_W@@YAPA_WXZ@4PA_WA 0040 _wcmdln"
		altNames = "_get_wide_winmain_command_line"
	strings:
		$1 = { 2D E9 00 48 EB 46 0E 4B 18 68 00 B9 0B 48 00 23 02 88 20 2A 01 D8 5A B1 53 B1 22 2A 03 D1 0B B9 01 23 00 E0 00 23 80 1C F2 E7 20 2B 03 D8 80 1C 03 88 00 2B F9 D1 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_6_0 {
	meta:
		name = "?should_copy_another_character@@YA_ND@Z"
		size = 22
		refs = "0006 _ismbblead"
		altNames = "?is_lead_byte@@YA_ND@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 08 B1 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_107_7_0 {
	meta:
		name = "?_strlwr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z"
		size = 386
		refs = "0008 __security_push_cookie 0018 _errno 0020 _invalid_parameter_noinfo 002c strnlen 0080 __acrt_LCMapStringA 00e4 __chkstk 0100 _malloc_base 0152 strcpy_s 0172 _free_base 017a __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 6F 46 86 B0 05 46 92 46 88 46 3D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 25 A6 E0 41 46 28 46 ?? ?? ?? ?? 40 45 02 D3 00 23 2B 70 EE E7 DA F8 00 30 D3 F8 A8 10 81 B9 95 F9 00 30 09 E0 95 F9 00 30 41 2B 03 DB 5A 2B 01 DC 20 33 2B 70 15 F9 01 3F 00 2B F3 D1 00 25 87 E0 9B 68 00 24 01 22 03 93 E3 43 00 93 04 92 2B 46 4F F4 80 72 50 46 02 94 01 94 ?? ?? ?? ?? 06 46 3E B9 ?? ?? ?? ?? 2A 23 03 60 ?? ?? ?? ?? 05 68 6E E0 B0 45 08 D2 2C 70 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 25 63 E0 06 F1 08 00 B0 42 03 46 98 BF 00 23 4D F6 DD 59 3B B3 B0 42 03 46 98 BF 00 23 B3 F5 80 6F 15 D8 B0 42 98 BF 00 20 C3 1D 83 42 01 D8 6F F0 07 03 23 F0 07 03 9C 08 ?? ?? ?? ?? AD EB 04 0D 1D F1 18 04 0F D0 4C F6 CC 43 23 60 08 E0 B0 42 98 BF 00 20 ?? ?? ?? ?? 04 46 2C B1 C0 F8 00 90 08 34 00 E0 00 24 3C B9 ?? ?? ?? ?? 0C 23 03 60 ?? ?? ?? ?? 05 68 1F E0 DA F8 00 10 01 23 04 93 8B 68 D1 F8 A8 10 4F F4 80 72 03 93 6F F0 00 03 00 93 2B 46 50 46 02 96 01 94 ?? ?? ?? ?? 30 B1 22 46 41 46 28 46 ?? ?? ?? ?? 05 46 04 E0 ?? ?? ?? ?? 2A 23 03 60 2A 25 3C B1 54 F8 08 3C 4B 45 03 D1 A4 F1 08 00 ?? ?? ?? ?? 28 46 BD 46 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_107_13_0 {
	meta:
		name = "_strlwr"
		size = 88
		refs = "0012 _errno 001a _invalid_parameter_noinfo 004a _strlwr_s_l 0054 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 12 4B 04 46 1B 68 CB B9 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 24 15 E0 94 F9 00 30 22 46 09 E0 92 F9 00 30 41 2B 03 DB 5A 2B 01 DC 20 33 13 70 12 F9 01 3F 00 2B F3 D1 04 E0 00 22 D1 43 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_14_0 {
	meta:
		name = "_strlwr_l"
		size = 26
		refs = "0010 _strlwr_s_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 46 6F F0 00 01 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_114_14_0 {
	meta:
		name = "_strupr_l"
		size = 26
		refs = "0010 _strupr_s_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 46 6F F0 00 01 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_656_14_0 {
	meta:
		name = "_wcslwr_l"
		size = 26
		refs = "0010 _wcslwr_s_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 46 6F F0 00 01 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_217_13_0 {
	meta:
		name = "_wcsupr_l"
		size = 26
		refs = "0010 _wcsupr_s_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0A 46 6F F0 00 01 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_107_16_0 {
	meta:
		name = "_strlwr_s_l"
		size = 56
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a ?_strlwr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 01 AA 21 46 28 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_114_16_0 {
	meta:
		name = "_strupr_s_l"
		size = 56
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a ?_strupr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 01 AA 21 46 28 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_656_16_0 {
	meta:
		name = "_wcslwr_s_l"
		size = 56
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a ?_wcslwr_s_l_stat@@YAHPA_WIPAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 01 AA 21 46 28 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_217_15_0 {
	meta:
		name = "_wcsupr_s_l"
		size = 56
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a ?_wcsupr_s_l_stat@@YAHQA_WIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 01 AA 21 46 28 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_108_3_0 {
	meta:
		name = "?common_mbstrlen_l@@YAIQBDIQAU__crt_locale_pointers@@@Z"
		size = 164
		refs = "0012 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0022 strnlen 0040 _errno 005e _isleadbyte_l 00a0 __imp_MultiByteToWideChar"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 86 B0 0E 46 07 46 02 A8 11 46 ?? ?? ?? ?? 03 98 43 68 01 2B 05 D1 31 46 38 46 ?? ?? ?? ?? 05 46 2B E0 1D 4C 80 68 00 23 24 68 01 93 00 93 33 46 3A 46 09 21 A0 47 30 B9 ?? ?? ?? ?? 2A 23 03 60 6F F0 00 05 19 E0 00 25 00 24 AE B1 97 F9 00 30 83 B1 D8 B2 03 A9 ?? ?? ?? ?? 30 B1 64 1C B4 42 0A D2 7F 1C 97 F9 00 30 23 B1 64 1C 6D 1C 7F 1C B4 42 EB D3 B4 42 00 D3 35 46 9D F8 14 30 33 B1 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 28 46 06 B0 BD E8 F0 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_5_0 {
	meta:
		name = "_mbstrlen"
		size = 36
		refs = "0010 strlen 0018 ?common_mbstrlen_l@@YAIQBDIQAU__crt_locale_pointers@@@Z 0020 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 1B 68 1B B9 BD E8 00 48 ?? ?? ?? ?? 00 22 D1 43 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_6_0 {
	meta:
		name = "_mbstrlen_l"
		size = 20
		refs = "0010 ?common_mbstrlen_l@@YAIQBDIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 46 6F F0 00 01 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_7_0 {
	meta:
		name = "_mbstrnlen"
		size = 44
		refs = "0008 _errno 0010 _invalid_parameter_noinfo 0024 ?common_mbstrlen_l@@YAIQBDIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 00 06 E0 6F F0 00 43 99 42 F2 D8 00 22 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_108_8_0 {
	meta:
		name = "_mbstrnlen_l"
		size = 42
		refs = "0008 _errno 0010 _invalid_parameter_noinfo 0022 ?common_mbstrlen_l@@YAIQBDIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 00 05 E0 6F F0 00 43 99 42 F2 D8 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_110_6_0 {
	meta:
		name = "_ismbcprint_l"
		size = 98
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0044 __dcrt_multibyte_check_type"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? FF 2C 12 D8 01 9B E1 B2 1B 68 33 F8 11 20 40 F2 57 13 1A 42 07 D1 02 9B 0B 44 5B 7E 13 F0 03 0F 08 BF 00 20 07 D0 01 20 05 E0 01 A9 00 23 20 22 20 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_112_13_0 {
	meta:
		name = "?ctrlevent_capture@@YAHK@Z"
		size = 144
		refs = "0014 __acrt_lock 0056 __acrt_unlock 0080 __guard_check_icall_fptr 0084 ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0088 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 008c __security_cookie"
	strings:
		$1 = { 2D E9 9F 48 0D F1 18 0B 6F 46 04 46 00 23 7B 60 BB 60 03 20 ?? ?? ?? ?? 1C 4B 1A 68 02 F0 1F 00 2C B9 19 49 0B 68 53 40 C3 41 02 24 04 E0 15 49 0B 68 53 40 C3 41 15 24 7B 60 BC 60 53 B1 01 2B 08 D0 3B 78 3B 70 C0 F1 20 03 00 20 60 FA 03 F3 53 40 0B 60 03 20 ?? ?? ?? ?? 7C 68 0C B9 00 23 08 E0 01 2C 05 D0 20 46 05 4B 1B 68 98 47 B8 68 A0 47 01 23 FB 60 F8 68 04 B0 BD E8 90 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_16_0 {
	meta:
		name = "?get_global_action_nolock@@YAPAP6AXH@ZH@Z"
		size = 64
		refs = "0030 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0034 ?term_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0038 ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 003c ?abort_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 28 0F D0 06 28 07 D0 0F 28 09 D0 15 28 05 D0 16 28 18 BF 00 20 06 D1 07 48 04 E0 05 48 02 E0 03 48 00 E0 01 48 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_18_0 {
	meta:
		name = "?siglookup@@YAPAU__crt_signal_action_t@@HQAU1@@Z"
		size = 44
		refs = "0028 __acrt_signal_action_table_count"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 4B 1B 68 03 EB 43 03 01 EB 83 02 03 E0 4B 68 83 42 03 D0 0C 31 91 42 F9 D1 00 21 08 46 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_19_0 {
	meta:
		name = "?signal_failed@@YAP6AXH@ZH@Z"
		size = 42
		refs = "001a _errno"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 28 0B D0 03 28 09 D0 0D 28 07 D0 0F 28 01 DD 11 28 03 DD ?? ?? ?? ?? 16 23 03 60 6F F0 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_112_21_0 {
	meta:
		name = "__acrt_get_sigabrt_handler"
		size = 32
		refs = "0016 ??$?RV<lambda_cbab9ec6f41b0180b23cc171c22676b0>@@AAV<lambda_44731a7d0e6d81c3e6aa82d741081786>@@V<lambda_4b292cb8dd18144e164572427af410ab>@@@?$__crt_seh_guarded_call@P6AXH@Z@@QAAP6AXH@Z$$QAV<lambda_cbab9ec6f41b0180b23cc171c22676b0>@@AAV<lambda_44731a7d0e6d81c3e6aa82d741081786>@@$$QAV<lambda_4b292cb8dd18144e164572427af410ab>@@@Z"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 03 23 CD E9 01 33 01 AB 6A 46 02 A9 68 46 ?? ?? ?? ?? 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_112_22_0 {
	meta:
		name = "__acrt_initialize_signal_handlers"
		size = 44
		refs = "001c ?term_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0020 ?abort_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0024 ?ctrlbreak_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0028 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 4B 18 60 06 4B 18 60 04 4B 18 60 02 4B 18 60 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_24_0 {
	meta:
		name = "__pxcptinfoptrs"
		size = 16
		refs = "0006 __acrt_getptd"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 00 1D BD E8 00 88 }
	condition:
		$1
}

rule file_112_25_0 {
	meta:
		name = "raise"
		size = 464
		refs = "0042 _errno 004a _invalid_parameter_noinfo 0056 ?get_global_action_nolock@@YAPAP6AXH@ZH@Z 005e __acrt_getptd_noexit 009c __acrt_lock 00da __acrt_unlock 00e0 _exit 0100 __acrt_getptd 01bc __guard_check_icall_fptr 01c0 __acrt_signal_action_fpe_count 01c4 __acrt_signal_action_first_fpe_index 01c8 __security_cookie 01cc __acrt_signal_action_table_count"
	strings:
		$1 = { 03 B4 2D E9 F0 4B 0D F1 18 0B 86 B0 6F 46 04 46 BC 63 00 26 7E 60 00 23 3B 61 01 25 3D 70 08 2C 07 DC 1C D0 02 2C 15 D0 04 2C 18 D0 06 2C 11 D0 07 E0 0B 2C 13 D0 0F 2C 0C D0 14 2C 01 DD 16 2C 08 DD ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 AC E0 20 46 ?? ?? ?? ?? 81 46 1A E0 ?? ?? ?? ?? 06 46 7E 60 00 2E F1 D0 32 68 57 4B 1B 68 03 EB 43 03 02 EB 83 01 03 E0 53 68 A3 42 03 D0 0C 32 8A 42 F9 D1 00 22 00 2A DA D0 02 F1 08 09 00 25 3D 70 00 23 FB 60 15 B1 03 20 ?? ?? ?? ?? 00 23 BB 60 7B 70 DF F8 20 81 D8 F8 00 10 3D B1 D9 F8 00 30 01 F0 1F 02 4B 40 63 FA 02 F2 01 E0 D9 F8 00 20 BA 60 01 2A 01 D1 01 23 00 E0 00 23 7B 70 FB BB 32 B9 15 B1 03 20 ?? ?? ?? ?? 03 20 ?? ?? ?? ?? 08 2C 05 D0 0B 2C 03 D0 04 2C 01 D0 00 25 0F E0 73 68 FB 60 00 25 75 60 08 2C 07 D1 ?? ?? ?? ?? 83 68 3B 61 ?? ?? ?? ?? 8C 23 83 60 D8 F8 00 10 08 2C 11 D1 2A 4B 1B 68 03 EB 43 02 33 68 03 EB 82 02 26 4B 1B 68 03 EB 43 03 02 EB 83 03 9A 42 0E D0 95 60 0C 32 FA E7 3B 78 BB 70 01 F0 1F 03 C3 F1 20 03 00 22 62 FA 03 F3 4B 40 C9 F8 00 30 3B 78 13 B1 03 20 ?? ?? ?? ?? 7B 78 23 BB BE 6B 08 2E 0B D1 ?? ?? ?? ?? 85 68 BC 68 20 46 12 4B 1B 68 98 47 08 20 29 46 A0 47 06 E0 BC 68 20 46 0D 4B 1B 68 98 47 30 46 A0 47 08 2E 03 D0 0B 2E 01 D0 04 2E 08 D1 7A 68 FB 68 53 60 08 2E 03 D1 ?? ?? ?? ?? 3B 69 83 60 00 23 7B 60 78 68 06 B0 BD E8 F0 0B 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_27_0 {
	meta:
		name = "signal"
		size = 356
		refs = "003e __acrt_getptd_noexit 005a _malloc_base 006a memcpy 00ba __acrt_lock 00e6 __doserrno 00f2 ?get_global_action_nolock@@YAPAP6AXH@ZH@Z 011c __acrt_unlock 0130 ?signal_failed@@YAP6AXH@ZH@Z 0144 __security_cookie 0148 __imp_GetLastError 014c __imp_SetConsoleCtrlHandler 0150 ?ctrlevent_capture@@YAHK@Z 0154 ?console_ctrl_handler_installed@@3_NA 0158 __acrt_signal_action_table_count 015c __acrt_signal_action_table_size 0160 __acrt_exception_action_table"
	strings:
		$1 = { 03 B4 2D E9 FF 4B 0D F1 28 0B 6F 46 0E 46 05 46 3D 63 04 2E 00 F0 8B 80 03 2E 00 F0 88 80 02 2D 47 D0 15 2D 45 D0 16 2D 43 D0 06 2D 41 D0 0F 2D 3F D0 08 2D 03 D0 04 2D 01 D0 0B 2D 77 D1 ?? ?? ?? ?? 04 46 00 2C 72 D0 23 68 DF F8 14 81 43 45 0D D1 DF F8 08 91 D9 F8 00 00 ?? ?? ?? ?? 20 60 00 28 64 D0 D9 F8 00 20 41 46 ?? ?? ?? ?? 20 68 02 46 39 4B 1B 68 03 EB 43 04 00 EB 84 01 88 42 05 D0 53 68 AB 42 03 D0 0C 32 8A 42 F9 D1 00 22 00 2A 4C D0 91 68 02 2E 09 D0 00 EB 84 00 04 E0 53 68 AB 42 03 D1 96 60 0C 32 82 42 F8 D1 79 60 41 E0 00 23 3B 70 BB 60 03 20 ?? ?? ?? ?? 02 2D 01 D0 15 2D 14 D1 23 4C 23 78 8B B9 01 21 20 48 1E 4B 1B 68 98 47 10 B1 01 23 23 70 08 E0 1A 4B 1B 68 98 47 04 46 ?? ?? ?? ?? 04 60 01 23 3B 70 28 46 ?? ?? ?? ?? 80 B1 02 68 12 4B 19 68 01 F0 1F 04 81 EA 02 03 E3 41 BB 60 02 2E 05 D0 C4 F1 20 03 66 FA 03 F3 4B 40 03 60 03 20 ?? ?? ?? ?? 3B 78 0B B1 38 6B 03 E0 BB 68 7B 60 03 E0 28 46 ?? ?? ?? ?? 78 60 78 68 04 B0 BD E8 F0 0B 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_4_0 {
	meta:
		name = "_mbscpy_s_l"
		size = 238
		refs = "0018 _errno 0020 _invalid_parameter_noinfo 0030 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0040 strcpy_s"
	strings:
		$1 = { 2D E9 FF 48 0D F1 20 0B 04 46 16 46 0D 46 1C B1 15 B1 5E B9 00 23 23 70 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 04 B0 BD E8 F0 88 68 46 19 46 ?? ?? ?? ?? 02 9F BB 68 2B B9 32 46 29 46 20 46 ?? ?? ?? ?? 47 E0 22 46 16 F8 01 3B 02 F8 01 3B 0B B1 6D 1E F8 D1 05 BB 33 78 A3 B9 50 1E 01 46 A0 42 08 D3 04 25 0B 78 3B 44 5B 7E 2B 42 02 D0 49 1E A1 42 F7 D2 43 1A 13 F0 01 0F 03 D0 00 23 02 F8 01 3C 20 E0 00 23 23 70 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 20 1D E0 90 1E 01 46 A0 42 08 D3 04 25 0B 78 3B 44 5B 7E 2B 42 02 D0 49 1E A1 42 F7 D2 43 1A 13 F0 01 0F 0B D0 93 1E A3 42 08 D3 00 23 02 F8 02 3C ?? ?? ?? ?? 2A 23 03 60 2A 20 00 E0 00 20 9D F8 0C 30 00 2B A3 D0 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 9B E7 }
	condition:
		$1
}

rule file_114_7_0 {
	meta:
		name = "?_strupr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z"
		size = 386
		refs = "0008 __security_push_cookie 0018 _errno 0020 _invalid_parameter_noinfo 002c strnlen 0080 __acrt_LCMapStringA 00e4 __chkstk 0100 _malloc_base 0152 strcpy_s 0172 _free_base 017a __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 6F 46 86 B0 05 46 92 46 88 46 3D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 25 A6 E0 41 46 28 46 ?? ?? ?? ?? 40 45 02 D3 00 23 2B 70 EE E7 DA F8 00 30 D3 F8 A8 10 81 B9 95 F9 00 30 09 E0 95 F9 00 30 61 2B 03 DB 7A 2B 01 DC 20 3B 2B 70 15 F9 01 3F 00 2B F3 D1 00 25 87 E0 9B 68 00 24 01 22 03 93 E3 43 00 93 04 92 2B 46 4F F4 00 72 50 46 02 94 01 94 ?? ?? ?? ?? 06 46 3E B9 ?? ?? ?? ?? 2A 23 03 60 ?? ?? ?? ?? 05 68 6E E0 B0 45 08 D2 2C 70 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 25 63 E0 06 F1 08 00 B0 42 03 46 98 BF 00 23 4D F6 DD 59 3B B3 B0 42 03 46 98 BF 00 23 B3 F5 80 6F 15 D8 B0 42 98 BF 00 20 C3 1D 83 42 01 D8 6F F0 07 03 23 F0 07 03 9C 08 ?? ?? ?? ?? AD EB 04 0D 1D F1 18 04 0F D0 4C F6 CC 43 23 60 08 E0 B0 42 98 BF 00 20 ?? ?? ?? ?? 04 46 2C B1 C0 F8 00 90 08 34 00 E0 00 24 3C B9 ?? ?? ?? ?? 0C 23 03 60 ?? ?? ?? ?? 05 68 1F E0 DA F8 00 10 01 23 04 93 8B 68 D1 F8 A8 10 4F F4 00 72 03 93 6F F0 00 03 00 93 2B 46 50 46 02 96 01 94 ?? ?? ?? ?? 30 B1 22 46 41 46 28 46 ?? ?? ?? ?? 05 46 04 E0 ?? ?? ?? ?? 2A 23 03 60 2A 25 3C B1 54 F8 08 3C 4B 45 03 D1 A4 F1 08 00 ?? ?? ?? ?? 28 46 BD 46 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_114_13_0 {
	meta:
		name = "_strupr"
		size = 88
		refs = "0012 _errno 001a _invalid_parameter_noinfo 004a _strupr_s_l 0054 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 12 4B 04 46 1B 68 CB B9 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 24 15 E0 94 F9 00 30 22 46 09 E0 92 F9 00 30 61 2B 03 DB 7A 2B 01 DC 20 3B 13 70 12 F9 01 3F 00 2B F3 D1 04 E0 00 22 D1 43 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "_abstract_cw"
		size = 148
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 00 20 13 F4 80 7F 18 BF 10 20 13 F4 00 7F 01 D0 40 F0 08 00 13 F4 80 6F 01 D0 40 F0 04 00 13 F4 00 6F 01 D0 40 F0 02 00 13 F4 80 5F 01 D0 40 F0 01 00 13 F4 00 4F 01 D0 40 F4 00 20 13 F4 40 02 10 D0 B2 F5 80 0F 0B D0 B2 F5 00 0F 05 D0 B2 F5 40 0F 07 D1 40 F4 40 70 04 E0 40 F4 80 70 01 E0 40 F4 00 70 4F F0 40 72 13 40 B3 F1 80 7F 0A D0 B3 F1 00 7F 04 D0 93 42 06 D1 40 F0 80 70 03 E0 40 F0 00 70 00 E0 10 43 BD E8 00 88 }
	condition:
		$1
}

rule file_115_1_0 {
	meta:
		name = "_abstract_sw"
		size = 78
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 00 20 13 F0 9F 0F 1C D0 13 F0 01 0F 18 BF 10 20 13 F0 02 0F 01 D0 40 F0 08 00 13 F0 04 0F 01 D0 40 F0 04 00 13 F0 08 0F 01 D0 40 F0 02 00 13 F0 10 0F 01 D0 40 F0 01 00 13 F0 80 0F 01 D0 40 F4 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_115_2_0 {
	meta:
		name = "_clearfp"
		size = 34
		refs = "001e _abstract_sw"
	strings:
		$1 = { 2D E9 00 48 EB 46 F1 EE 10 3A 83 F4 1F 40 80 F4 1F 43 23 F0 9F 03 E1 EE 10 3A BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_3_0 {
	meta:
		name = "_control87"
		size = 76
		refs = "0018 _abstract_cw 002c _hw_cw"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0F 4B 04 46 19 40 F1 EE 10 3A 83 F4 1F 45 28 46 ?? ?? ?? ?? 20 EA 01 02 04 EA 01 03 13 43 83 42 0B D0 18 46 ?? ?? ?? ?? 05 F0 9F 03 18 43 80 F4 1F 43 E1 EE 10 3A ?? ?? ?? ?? BD E8 30 88 FE DE 1F 03 08 03 }
	condition:
		$1
}

rule file_115_4_0 {
	meta:
		name = "_controlfp"
		size = 18
		refs = "000e _control87"
		altNames = "_set_controlfp"
	strings:
		$1 = { 2D E9 00 48 EB 46 21 F4 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_115_5_0 {
	meta:
		name = "_fpreset"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 E1 EE 10 3A BD E8 00 88 }
	condition:
		$1
}

rule file_115_6_0 {
	meta:
		name = "_hw_cw"
		size = 150
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 00 20 13 F0 10 0F 4F F4 80 71 18 BF 08 46 13 F0 08 0F 01 D0 40 F4 00 70 13 F0 04 0F 01 D0 40 F4 80 60 13 F0 02 0F 01 D0 40 F4 00 60 13 F0 01 0F 01 D0 40 F4 80 50 13 F4 00 2F 01 D0 40 F4 00 40 13 F4 40 72 0F D0 8A 42 0B D0 B2 F5 00 7F 05 D0 B2 F5 40 7F 07 D1 40 F4 40 00 04 E0 40 F4 80 00 01 E0 40 F4 00 00 4F F0 40 72 13 40 B3 F1 80 7F 0A D0 B3 F1 00 7F 04 D0 93 42 06 D1 40 F0 80 70 03 E0 40 F0 00 70 00 E0 10 43 BD E8 00 88 }
	condition:
		$1
}

rule file_115_8_0 {
	meta:
		name = "_statusfp"
		size = 22
		refs = "0012 _abstract_sw"
	strings:
		$1 = { 2D E9 00 48 EB 46 F1 EE 10 3A 83 F4 1F 40 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "llrintf"
		size = 132
		refs = "0012 _fdtest 0024 nearbyintf 003c _fperrraise 0060 __stoi64"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 68 46 8D ED 00 0A ?? ?? ?? ?? 00 28 28 D0 01 DD 02 28 22 DD 9D ED 00 0A ?? ?? ?? ?? 9D ED 00 2A B0 EE 40 8A B4 EE 42 0A F1 EE 10 FA 02 D0 20 20 ?? ?? ?? ?? 9F ED 0F 2A B4 EE C8 2A F1 EE 10 FA 0B D8 9F ED 0B 2A B4 EE C2 8A F1 EE 10 FA 04 D8 B0 EE 48 0A ?? ?? ?? ?? 04 E0 01 20 ?? ?? ?? ?? 00 20 00 21 02 B0 BD EC 02 8B BD E8 00 88 FE DE 00 00 00 5F 00 00 00 DF }
	condition:
		$1
}

rule file_118_4_0 {
	meta:
		name = "?internal_to_string@@YAHQADIQAU_strflt@@HQAH2@Z"
		size = 98
		refs = "0018 _errno 0020 _invalid_parameter_noinfo 0034 __acrt_fp_strflt_to_string"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 1C 46 00 2C D8 BF 00 23 9B 1C 99 42 15 46 07 D2 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 24 19 E0 8B 1E 9C 42 A8 BF 1C 46 22 46 2B 46 ?? ?? ?? ?? 04 46 1C B1 ?? ?? ?? ?? 04 60 0B E0 2B 68 2D 2B 05 9B 08 BF 01 22 18 BF 00 22 1A 60 6A 68 04 9B 00 24 1A 60 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_118_6_0 {
	meta:
		name = "?try_get_ptd_buffer@@YAPADXZ"
		size = 46
		refs = "0008 __acrt_getptd_noexit 001c _malloc_base 0024 _free_base"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B ?? ?? ?? ?? 04 46 0C B9 00 20 0A E0 E3 6B 3B B9 40 F2 5D 10 ?? ?? ?? ?? E0 63 00 20 ?? ?? ?? ?? E0 6B BD E8 18 88 }
	condition:
		$1
}

rule file_118_7_0 {
	meta:
		name = "_ecvt"
		size = 102
		refs = "0018 __acrt_getptd_noexit 0028 _malloc_base 0030 _free_base 0052 _ecvt_s"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 2D ED 02 8B 83 B0 17 46 88 46 06 46 B0 EE 40 8B ?? ?? ?? ?? 05 46 DD B1 EC 6B 4C B9 40 F2 5D 10 ?? ?? ?? ?? E8 63 00 20 ?? ?? ?? ?? EC 6B 7C B1 40 F2 5B 13 9E 42 A8 BF 1E 46 32 46 43 46 B0 EE 48 0B 40 F2 5D 11 20 46 00 97 ?? ?? ?? ?? 00 B1 00 24 20 46 03 B0 BD EC 02 8B BD E8 F0 89 }
	condition:
		$1
}

rule file_118_8_0 {
	meta:
		name = "_ecvt_s"
		size = 144
		refs = "000a __security_push_cookie 001e _errno 0026 _invalid_parameter_noinfo 0058 __acrt_fltout 006a ?internal_to_string@@YAHQADIQAU_strflt@@HQAH2@Z 0084 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? DF B0 DD F8 B0 81 05 46 1F 46 14 46 0E 46 3D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 29 E0 00 2E F5 D0 4F F0 00 09 85 F8 00 90 00 2F EF D0 B8 F1 00 0F EC D0 00 23 CD E9 02 33 04 93 4F F4 AF 73 4F EA 03 00 06 AA 02 A9 ?? ?? ?? ?? 02 AA 23 46 31 46 28 46 CD F8 04 80 00 97 ?? ?? ?? ?? B3 1E 9C 42 A8 BF 1C 46 00 2C 03 DB 2B 57 0B B1 05 F8 04 90 5F B0 ?? ?? ?? ?? BD E8 F0 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_118_9_0 {
	meta:
		name = "_fcvt"
		size = 148
		refs = "000e __security_push_cookie 001e __acrt_getptd_noexit 002e _malloc_base 0036 _free_base 0056 __acrt_fltout 0078 _fcvt_s 0084 __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B 2D ED 02 8B ?? ?? ?? ?? DE B0 17 46 88 46 06 46 B0 EE 40 8B ?? ?? ?? ?? 05 46 5D B3 EC 6B 4C B9 40 F2 5D 10 ?? ?? ?? ?? E8 63 00 20 ?? ?? ?? ?? EC 6B FC B1 00 23 CD E9 02 33 04 93 4F F4 AF 73 4F EA 03 00 06 AA 02 A9 B0 EE 48 0B ?? ?? ?? ?? 03 9B 40 F2 5B 12 B0 EE 48 0B D3 1A 9E 42 A8 BF 1E 46 32 46 43 46 40 F2 5D 11 20 46 00 97 ?? ?? ?? ?? 00 B1 00 24 20 46 5E B0 ?? ?? ?? ?? BD EC 02 8B BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_118_10_0 {
	meta:
		name = "_fcvt_s"
		size = 134
		refs = "000a __security_push_cookie 001c _errno 0024 _invalid_parameter_noinfo 004e __acrt_fltout 0074 ?internal_to_string@@YAHQADIQAU_strflt@@HQAH2@Z 007a __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? DE B0 6A 9E 04 46 1F 46 90 46 0D 46 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 25 E0 00 2D F5 D0 00 23 23 70 00 2F F1 D0 00 2E EF D0 CD E9 02 33 04 93 4F F4 AF 73 4F EA 03 00 06 AA 02 A9 ?? ?? ?? ?? 03 9A B8 F1 00 0F 02 EB 08 03 05 DD 00 2A 03 DD 43 45 01 DA 6F F0 00 43 02 AA 29 46 20 46 01 96 00 97 ?? ?? ?? ?? 5E B0 ?? ?? ?? ?? BD E8 F0 09 5D F8 14 FB }
	condition:
		$1
}

rule file_119_27_0 {
	meta:
		name = "_getmaxstdio"
		size = 32
		refs = "0016 ??$?RV<lambda_8f60530dd27be0f4f899ea86a2700793>@@AAV<lambda_310477c8b9c73405e9396a64630870ce>@@V<lambda_0616a966f7212e22a6e633c5ba37eae1>@@@?$__crt_seh_guarded_call@H@@QAAH$$QAV<lambda_8f60530dd27be0f4f899ea86a2700793>@@AAV<lambda_310477c8b9c73405e9396a64630870ce>@@$$QAV<lambda_0616a966f7212e22a6e633c5ba37eae1>@@@Z"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 08 23 CD E9 01 33 01 AB 6A 46 02 A9 68 46 ?? ?? ?? ?? 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_119_28_0 {
	meta:
		name = "_setmaxstdio"
		size = 72
		refs = "0016 _errno 001e _invalid_parameter_noinfo 003a ??$?RV<lambda_5c0a79d5036aea052eca0e4ed02cad2d>@@AAV<lambda_e7c03df1dbe441d4546fa0d4addf2a3b>@@V<lambda_b377d5973d50906754e22cc2e95f3a8e>@@@?$__crt_seh_guarded_call@H@@QAAH$$QAV<lambda_5c0a79d5036aea052eca0e4ed02cad2d>@@AAV<lambda_e7c03df1dbe441d4546fa0d4addf2a3b>@@$$QAV<lambda_b377d5973d50906754e22cc2e95f3a8e>@@@Z"
	strings:
		$1 = { 03 B4 2D E9 0F 48 0D F1 10 0B C2 1E 41 F6 FD 73 9A 42 06 90 08 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 00 0A E0 06 AB 02 93 08 23 01 93 03 93 01 AB 02 AA 03 A9 68 46 ?? ?? ?? ?? 04 B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "_mbsnbcpy_l"
		size = 174
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 _errno 0028 _invalid_parameter_noinfo 003c strncpy"
	strings:
		$1 = { 2D E9 FF 48 0D F1 20 0B 0E 46 04 46 07 46 68 46 19 46 15 46 ?? ?? ?? ?? 04 B9 0D B9 46 B9 3D B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 27 26 E0 02 99 8B 68 AB BB 2A 46 31 46 20 46 ?? ?? ?? ?? 07 46 1C E0 16 F8 01 2B 6D 1E 53 18 5B 7E 13 F0 04 0F 22 D0 22 70 3D B3 33 78 6D 1E 06 F1 01 06 63 70 04 F1 02 04 E3 B9 00 23 04 F8 02 3C 35 B1 00 22 25 B1 63 19 04 F8 01 2B 9C 42 FB D1 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 38 46 04 B0 BD E8 F0 88 04 F8 01 2B 00 2A E5 D0 00 2D CE D1 EA E7 00 23 23 70 E7 E7 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "lroundl"
		size = 108
		refs = "000e _ldtest 0020 roundl 0050 _fperrraise"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 1E D0 01 DD 02 28 18 DD 9D ED 00 0B ?? ?? ?? ?? 9F ED 0F 2B 8D ED 00 0B B4 EE C0 2B F1 EE 10 FA 0B D8 9F ED 09 2B B4 EE C2 0B F1 EE 10 FA 04 D8 BD EE C0 0B 10 EE 10 0A 03 E0 01 20 ?? ?? ?? ?? 00 20 BD E8 0C 88 FE DE 00 00 C0 FF FF FF DF 41 00 00 00 00 00 00 E0 C1 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "lround"
		size = 108
		refs = "000e _dtest 0020 round 0050 _fperrraise"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 1E D0 01 DD 02 28 18 DD 9D ED 00 0B ?? ?? ?? ?? 9F ED 0F 2B 8D ED 00 0B B4 EE C0 2B F1 EE 10 FA 0B D8 9F ED 09 2B B4 EE C2 0B F1 EE 10 FA 04 D8 BD EE C0 0B 10 EE 10 0A 03 E0 01 20 ?? ?? ?? ?? 00 20 BD E8 0C 88 FE DE 00 00 C0 FF FF FF DF 41 00 00 00 00 00 00 E0 C1 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "_strset"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 90 F9 00 30 02 46 02 E0 01 70 10 F9 01 3F 00 2B FA D1 10 46 BD E8 00 88 }
	condition:
		$1
}

rule file_123_5_0 {
	meta:
		name = "_mbsnlen_l"
		size = 110
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001e strnlen"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 02 99 8B 68 23 B9 21 46 28 46 ?? ?? ?? ?? 17 E0 00 20 00 22 9C B1 2B 78 7B B1 0B 44 5B 7E 13 F0 04 0F 05 D0 52 1C A2 42 09 D2 6D 1C 2B 78 23 B1 52 1C 40 1C 6D 1C A2 42 ED D3 A2 42 00 D3 20 46 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "imaxabs"
		size = 24
	strings:
		$1 = { 2D E9 00 48 EB 46 00 29 04 DC 03 DA 00 23 40 42 63 EB 01 01 BD E8 00 88 }
	condition:
		$1
}

rule file_125_1_0 {
	meta:
		name = "tan"
		size = 644
		refs = "0048 _controlfp_s 006a tan_piby4 0096 _handle_nan 00ba _handle_error 01d6 __remainder_piby2 0260 ??_C@_03IIINPABG@tan?$AA@"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 8A B0 54 EC 10 0B 9B 4B B0 EE 40 8B 24 F0 00 41 99 42 2F D8 02 D3 96 4B 98 42 2B D8 93 4B 99 42 18 D8 17 D2 B1 F1 79 5F 0B D8 0A D2 50 EA 01 03 19 D0 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? 11 E0 28 EE 08 0B 9F ED 87 1B 20 EE 08 0B 00 EE 01 8B 08 E0 9F ED 80 1B 00 20 B0 EE 48 0B ?? ?? ?? ?? B0 EE 40 8B B0 EE 48 0B 0A B0 BD EC 02 8B BD E8 30 88 7A 4A 04 EA 02 03 93 42 1A D1 23 46 6F F3 1F 53 03 43 03 D0 21 46 ?? ?? ?? ?? E8 E7 21 23 02 93 08 23 01 22 9F ED 6F 1B 6D 48 01 93 6B 4B 03 92 00 92 00 22 B0 EE 48 0B 20 21 ?? ?? ?? ?? D6 E7 A1 42 01 D1 00 24 02 E0 01 24 B1 EE 48 8B 9F ED 61 0B B4 EE C0 8B F1 EE 10 FA 77 D2 5C 4B 00 25 99 42 0E D8 02 D3 59 4B 98 42 0A D8 56 4B 99 42 05 D8 02 D3 53 4B 98 42 01 D8 01 20 1D E0 02 20 1B E0 4F 4B 99 42 0E D8 02 D3 4C 4B 98 42 0A D8 49 4B 99 42 05 D8 02 D3 46 4B 98 42 01 D8 03 20 0B E0 04 20 09 E0 9F ED 41 0B B6 EE 00 1B 08 EE 00 1B BD EE C1 0B 10 EE 10 0A 00 EE 10 0A 9F ED 39 1B B8 EE C0 5B 9F ED 35 0B 25 EE 01 1B 25 EE 00 3B 38 EE 41 4B 53 EC 14 2B C3 F3 0A 53 D3 EB 11 53 65 F1 00 01 09 B9 0F 2B 26 D9 9F ED 29 0B B0 EE 44 2B 25 EE 00 3B 9F ED 24 0B 34 EE 43 4B 25 EE 00 1B 32 EE 44 0B 30 EE 43 0B 31 EE 40 3B 09 B9 30 2B 11 D9 9F ED 1B 0B B0 EE 44 2B 25 EE 00 3B 9F ED 16 0B 34 EE 43 4B 25 EE 00 1B 32 EE 44 0B 30 EE 43 0B 31 EE 40 3B 34 EE 43 2B 00 F0 03 03 34 EE 42 0B 30 EE 43 1B 0B E0 05 AA 08 A9 06 A8 B0 EE 48 0B ?? ?? ?? ?? 9D ED 06 2B 9D ED 08 1B 05 9B 00 2C 03 F0 01 00 B0 EE 42 0B 3F F4 3C AF ?? ?? ?? ?? B1 EE 40 8B 3A E7 C1 49 20 25 9A 83 7B 39 00 00 00 2E 8A 19 A3 3B 73 70 03 2E 8A 19 A3 3B 00 00 60 1A 61 B4 D0 3D 31 63 62 1A 61 B4 D0 3D 00 00 40 54 FB 21 F9 3F 83 C8 C9 6D 30 5F E4 3F 75 A7 BB E9 BB FD 15 40 BB B2 CC BE 3A 46 1C 40 D2 21 33 7F 7C D9 02 40 5E 38 55 29 7A 6A 0F 40 00 00 00 00 80 84 1E 41 00 00 F8 FF ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F0 7F 55 55 55 55 55 55 D5 3F 00 00 20 3F 18 2D 44 54 FB 21 E9 3F }
	condition:
		$1
}

rule file_125_2_0 {
	meta:
		name = "tan_piby4"
		size = 420
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 04 8B 9F ED 63 2B B0 EE 40 7B B0 EE 41 8B 4F F0 00 03 B4 EE C2 0B F1 EE 10 FA 09 DD 9F ED 59 2B 9F ED 56 3B 01 23 32 EE 40 2B 33 EE 41 0B 10 E0 9F ED 56 0B B4 EE C0 7B F1 EE 10 FA 0D D2 9F ED 50 0B 9F ED 4D 1B 6F F0 00 03 37 EE 00 2B 38 EE 01 0B 9F ED 47 8B 32 EE 00 7B B0 EE 00 9B 27 EE 07 6B 27 EE 09 0B 9F ED 40 1B 9F ED 3D 3B 9F ED 3A 2B 9F ED 37 4B 00 EE 08 6B 9F ED 33 5B 26 EE 01 0B 26 EE 03 1B 32 EE 40 2B 9F ED 2D 3B 31 EE 44 0B 22 EE 06 1B 9F ED 28 2B 00 EE 06 5B 26 EE 07 0B 31 EE 43 1B 25 EE 00 0B 01 EE 06 2B 80 EE 02 0B 30 EE 08 5B D3 B1 01 EE 10 3A 35 EE 07 0B B8 EE C1 1B 20 EE 09 2B B7 EE 00 3B 40 B1 30 EE 43 0B 82 EE 00 0B 30 EE 43 0B 20 EE 01 4B 26 E0 30 EE 03 0B 82 EE 00 0B 33 EE 40 0B F5 E7 E0 B1 35 EE 07 1B BF EE 00 0B 52 EC 11 0B 80 EE 01 3B 00 25 53 EC 13 1B 42 EC 11 5B 00 24 B7 EE 00 2B 43 EC 14 4B 31 EE 47 0B 04 EE 01 2B 35 EE 40 0B 00 EE 04 2B 02 EE 03 4B 01 E0 35 EE 07 4B B0 EE 44 0B BD EC 04 8B BD E8 30 88 B8 40 AA 8C CB DF F1 3F 0F B9 9E 49 46 80 E0 3F 4A 56 38 66 0F D5 D7 3F BB 9A 56 C7 24 7C 97 3F CF 0A 0A F8 F4 B0 9A 3F 5A 38 9C 28 AF 5D 2D 3F F8 98 6D EF 17 75 2E 3F 00 00 00 00 00 00 00 00 06 5C 14 33 26 A6 81 3C 18 2D 44 54 FB 21 E9 3F C3 F5 28 5C 8F C2 E5 BF C3 F5 28 5C 8F C2 E5 3F }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "_fdpow"
		size = 1188
		refs = "000e __security_push_cookie 002c _fdunscale 0036 _fd_int 00a2 _fperrraise 0110 _fdlogpoly 0154 _FNan_C 0206 _fdxp_setw 021e _fdxp_addx 024e _fdxp_mulh 029e _fdxp_addh 0348 _fdxp_getw 0372 _fdexp 03f8 __security_pop_cookie 0488 _FInf_C 048c _FZero_C 0494 log2e"
	strings:
		$1 = { 03 B4 2D E9 F0 4F 0D F1 1C 0B 2D ED 06 8B ?? ?? ?? ?? 96 B0 07 46 01 A8 69 46 B0 EE 60 9A CD ED 04 0A 8D ED 00 0A CD ED 03 0A 00 26 ?? ?? ?? ?? 05 46 03 A8 00 21 ?? ?? ?? ?? 04 46 0F B1 00 23 3B 80 24 B9 B5 EE 40 9A F1 EE 10 FA 18 D0 DD ED 00 1A BD F9 04 20 F6 EE 00 9A 00 2D 80 F2 A6 81 01 2A 10 D1 F4 EE 69 1A F1 EE 10 FA 08 D0 01 2C 09 D1 BE EE 00 0A F4 EE 40 1A F1 EE 10 FA 02 D1 F7 EE 00 1A B5 E1 00 2D 80 F2 90 81 00 2C 00 F3 8D 81 BD F8 02 30 13 F4 00 4F 06 D0 00 2C 04 DA 01 20 ?? ?? ?? ?? 2B 4B A1 E1 F5 EE C0 1A 6F F0 00 05 F1 EE 10 FA 02 DD 4F F0 00 0A 0C E0 B1 EE 61 0A 03 A8 29 46 8D ED 00 0A ?? ?? ?? ?? DD ED 00 1A BD F9 04 20 82 46 9F ED 1D 0A F4 EE C0 1A F1 EE 10 FA 06 D2 B0 EE 00 0A 53 1E 61 EE 80 1A AD F8 04 30 F7 EE 00 AA 71 EE EA 0A 31 EE AA 0A CD ED 00 0A C0 EE 80 8A 28 EE A8 8A B0 EE 48 0A ?? ?? ?? ?? 9D ED 00 2A 60 EE 08 0A BD F9 04 30 9F ED 0A AA 9F ED 08 1A 70 EE C2 0A 00 EE 10 3A 60 EE A8 8A F8 EE C0 2A 38 EE 82 3A 9F ED 01 8A 0A E0 FE DE 00 00 00 00 00 00 00 C7 18 72 31 3F F3 04 35 3F ?? ?? ?? ?? 83 EE 0A 0A 30 EE 22 0A 60 EE 09 1A 8D ED 03 0A F4 EE C1 1A CD ED 02 1A F1 EE 10 FA 38 BF 00 25 C0 F0 F2 80 BA EE 08 0A B4 EE E1 0A F1 EE 10 FA 2F D8 B2 EE 08 0A F4 EE C0 1A F1 EE 10 FA 28 D8 9F ED C1 0A B4 EE C9 0A F1 EE 10 FA 21 D2 9F ED BD 0A B4 EE C0 9A F1 EE 10 FA 1A D2 F5 EE C0 1A F1 EE 10 FA 02 D2 31 EE E9 0A 01 E0 31 EE A9 0A BD EE C0 0A 62 EE 89 0A 10 EE 10 6A 63 EE 09 1A 00 EE 10 6A B8 EE C0 0A 30 EE C0 0A 40 EE 0A 1A B8 E0 9F ED AB 0A B4 EE E1 0A F1 EE 10 FA 38 BF 01 25 C0 F0 B1 80 12 A8 B0 EE 42 0A 04 21 ?? ?? ?? ?? 04 A8 B0 EE 68 0A 02 21 ?? ?? ?? ?? 04 AA 12 A8 02 23 04 21 ?? ?? ?? ?? 9D ED 12 0A B5 EE 40 0A F1 EE 10 FA 06 D1 06 A8 04 21 B0 EE 48 0A ?? ?? ?? ?? 27 E0 DF F8 54 92 06 AC 99 E8 0F 00 0F C4 06 A8 04 21 ?? ?? ?? ?? 4F F0 01 08 13 AE 96 ED 00 0A B5 EE 40 0A F1 EE 10 FA 13 D0 99 E8 0F 00 0E AC 0F C4 04 21 0E A8 ?? ?? ?? ?? 04 23 0E AA 04 21 06 A8 ?? ?? ?? ?? 08 F1 01 08 36 1D B8 F1 04 0F E4 DB BD F9 04 30 06 A8 04 21 00 EE 10 3A B8 EE C0 0A ?? ?? ?? ?? 12 A8 B0 EE 49 0A 02 21 ?? ?? ?? ?? 06 9B 9D ED 12 0A 0A A8 0A 93 07 9B 04 21 0B 93 08 9B 0C 93 09 9B 0D 93 ?? ?? ?? ?? 9D ED 13 0A B5 EE 40 0A F1 EE 10 FA 11 D0 06 9B 0E A8 04 21 0E 93 07 9B 0F 93 08 9B 10 93 09 9B 11 93 ?? ?? ?? ?? 0E AA 0A A8 04 23 04 21 ?? ?? ?? ?? DD ED 0A 0A F5 EE 40 0A CD ED 00 0A F1 EE 10 FA 0E D0 9D ED 0B 1A B5 EE 40 1A F1 EE 10 FA 07 D0 9D ED 0C 0A 30 EE 01 0A 30 EE 20 0A 8D ED 00 0A 68 46 00 21 ?? ?? ?? ?? 9D ED 00 0A 0A A8 04 21 B1 EE 40 0A ?? ?? ?? ?? 04 21 0A A8 ?? ?? ?? ?? 9D ED 00 2A 60 EE 0A 1A BD EE C2 2A 12 EE 10 6A CD ED 02 1A 00 2D 0C DA 0F B1 3E 80 00 26 02 A8 31 46 B0 EE 6A 0A ?? ?? ?? ?? 05 46 DD ED 02 1A 00 2D 08 D0 01 2D 0D D1 40 4B 08 20 93 ED 00 0A 8D ED 02 0A 02 E0 10 20 8D ED 02 8A ?? ?? ?? ?? DD ED 02 1A BA F1 00 0F 25 D0 F1 EE 61 1A 22 E0 02 2D 20 D0 02 2C 02 D1 F0 EE 49 1A 1B E0 01 2D 2F D1 BD F8 02 30 4F F4 00 45 2B 42 BD F8 12 30 04 D1 2B 42 0C D0 DF ED 2F 1A 0C E0 2B 42 15 D1 34 B9 03 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 47 DB 26 4B D3 ED 00 1A B0 EE 61 0A 16 B0 ?? ?? ?? ?? BD EC 06 8B BD E8 F0 0F 5D F8 0C FB 00 2C E2 D1 03 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 DB DA 1C 4B 2F E0 BD F8 12 30 01 2C 08 D1 13 F4 00 4F 02 D1 00 2A DD DC CF E7 00 2A DA DD CC E7 4F F4 00 45 2B 42 0D D1 00 2C C6 D1 03 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 BF DA BD F8 02 30 2B 42 BB D0 DE E7 04 20 ?? ?? ?? ?? 00 2C C2 D1 03 A8 6F F0 00 01 ?? ?? ?? ?? 00 28 BB DA BD F8 02 30 2B 42 B7 D0 02 4B 93 ED 00 0A F1 EE 40 1A B4 E7 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 47 00 00 20 42 00 00 20 C2 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "_fdtgamma"
		size = 372
		refs = "0026 stirling 00fa _fdunscale"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 81 B0 90 ED 00 8A B3 EE 0F 0A 04 46 08 46 B4 EE C8 0A F1 EE 10 FA 03 D8 20 46 ?? ?? ?? ?? 8E E0 BE EE 00 0A B4 EE C0 8A F1 EE 10 FA 18 D2 B6 EE 00 1A F0 EE 48 0A B4 EE C8 1A 8D ED 00 8A F1 EE 10 FA B7 EE 00 0A 4F D3 38 EE 00 8A B4 EE C8 1A 60 EE 88 0A F1 EE 10 FA F6 D2 CD ED 00 0A 43 E0 B6 EE 00 0A B4 EE C0 8A F1 EE 10 FA 08 D2 B7 EE 00 0A 30 EE 08 0A 20 EE 08 0A 8D ED 00 0A 35 E0 B7 EE 08 0A B4 EE C0 8A F1 EE 10 FA 04 D2 B7 EE 00 0A F0 EE 48 2A 0A E0 F0 EE 04 0A B4 EE E0 8A F1 EE 10 FA 08 D2 B0 EE 00 0A F7 EE 00 2A 00 23 03 80 38 EE 40 8A 1E E0 B7 EE 00 0A F4 EE C8 0A B0 EE 40 1A 8D ED 00 0A F1 EE 10 FA 0A D2 38 EE 40 8A F4 EE C8 0A 81 EE 08 1A F1 EE 10 FA F6 D3 8D ED 00 1A B0 EE 00 0A 38 EE 40 8A 69 46 ?? ?? ?? ?? DD ED 00 2A 9F ED 1B 0A DF ED 19 0A DF ED 17 1A 9F ED 15 2A 28 EE 00 1A 9F ED 12 0A 48 EE 20 1A DF ED 0F 0A C4 ED 00 2A 31 EE 40 0A 9F ED 0B 1A 00 EE 08 2A 9F ED 08 0A 01 EE 88 1A 02 EE 08 0A 41 EE 08 0A 80 EE 80 0A 20 EE 08 0A 01 B0 BD EC 02 8B BD E8 10 88 B3 14 83 3F 10 C7 DB 3E FC AC DD 3E A6 2C 45 3E C0 53 91 3C 74 A3 1A 3C 91 00 59 3C 2B E5 11 3D }
	condition:
		$1
}

rule file_127_2_0 {
	meta:
		name = "stirling"
		size = 152
		refs = "0022 _fdpow 004c _fdpoly 006c expf 0090 approx0"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 2D ED 04 8B D0 ED 00 9A B6 EE 00 0A 06 46 08 46 79 EE C0 0A B0 EE 69 0A 0D 46 ?? ?? ?? ?? F7 EE 00 0A B5 F9 00 30 80 EE A9 1A DF ED 18 0A 16 4C 5B 42 2B 80 71 EE 60 8A 20 69 B0 EE 40 9A B0 EE 68 0A 01 21 ?? ?? ?? ?? A0 68 B0 EE 40 8A B0 EE 68 0A 07 21 ?? ?? ?? ?? F0 EE 40 0A B1 EE 69 0A 88 EE 20 8A ?? ?? ?? ?? F0 EE 40 0A 9F ED 05 0A 60 EE 89 0A C8 EE 20 0A C6 ED 00 0A BD EC 04 8B BD E8 78 88 00 00 00 00 ?? ?? ?? ?? EC AA C5 3C }
	condition:
		$1
}

rule file_127_3_0 {
	meta:
		name = "tgammaf"
		size = 484
		refs = "0018 _fd_int 003c _fperrraise 00fe _fdsin 0126 _fdtgamma 0148 _fdscale 01c8 _FInf_C 01d4 _fdgamma_big 01e0 _FNan_C"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 86 B0 03 A8 00 21 8D ED 01 0A 8D ED 03 0A ?? ?? ?? ?? 9D ED 01 1A 80 B1 01 28 04 D0 02 28 25 D1 9D ED 01 0A C5 E0 BD F8 06 30 13 F4 00 4F F7 D0 01 20 ?? ?? ?? ?? 67 4B B9 E0 B5 EE 40 1A F1 EE 10 FA 0E D1 04 20 ?? ?? ?? ?? BD F8 06 30 13 F4 00 4F 5A 4B 93 ED 00 0A 00 F0 AB 80 B1 EE 40 0A A7 E0 B5 EE C0 1A F1 EE 10 FA E1 D3 9F ED 59 0A B4 EE C0 1A F1 EE 10 FA 05 D8 10 20 ?? ?? ?? ?? 9F ED 53 0A 95 E0 50 4B 93 ED 00 0A B1 EE 40 0A B4 EE C0 1A F1 EE 10 FA 5E D2 9D ED 03 0A F1 EE 41 0A F7 EE 00 8A 02 A8 31 EE 40 0A 70 EE E8 0A 6F F0 00 01 8D ED 03 0A 8D ED 02 1A CD ED 04 0A ?? ?? ?? ?? 9D ED 01 1A 9D ED 02 0A FF EE 00 0A 31 EE 40 0A B4 EE E0 0A 9D ED 03 0A F1 EE 10 FA 03 D2 B1 EE 40 0A 8D ED 03 0A 9F ED 36 8A 00 20 20 EE 08 0A ?? ?? ?? ?? 9D ED 01 1A 69 46 04 A8 F1 EE 41 0A 20 EE 01 1A 30 EE E8 0A 20 EE 01 0A B1 EE 40 0A 88 EE 00 0A 8D ED 02 0A ?? ?? ?? ?? 9D ED 02 1A 30 EE 28 0A DD ED 04 0A BD F9 00 10 81 EE 00 0A 02 A8 20 EE 20 0A 8D ED 02 0A ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 02 0A 2C E0 9F ED 1A 0A B4 EE C0 1A F1 EE 10 FA 1F D8 69 46 01 A8 ?? ?? ?? ?? B7 EE 00 1A DD ED 01 0A 8D ED 03 0A 30 EE 01 0A BD F9 00 30 01 A8 80 EE 20 0A 59 42 8D ED 01 0A ?? ?? ?? ?? 20 B1 01 28 7F F4 43 AF 08 20 00 E0 10 20 ?? ?? ?? ?? 3C E7 08 20 ?? ?? ?? ?? 04 4B 93 ED 00 0A 06 B0 BD EC 02 8B BD E8 00 88 FE DE ?? ?? ?? ?? 00 00 18 42 DB 0F 49 40 ?? ?? ?? ?? 00 00 00 00 00 00 18 C2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_128_9_0 {
	meta:
		name = "_ismbcdigit_l"
		size = 92
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0024 _isctype_l 003e __dcrt_multibyte_check_type"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? FF 2C 0F D8 01 9A 53 68 01 2B 05 DD 01 AA 04 21 20 46 ?? ?? ?? ?? 0B E0 13 68 33 F8 14 30 03 F0 04 00 05 E0 01 A9 01 23 04 22 20 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "_ldquad"
		size = 940
		refs = "000c __security_push_cookie 0060 _ld_int 00d4 _ldunscale 00e8 _ldxp_setw 00fe _ldscale 0124 memcpy 0130 _ldxp_mulh 016e _ldxp_addx 02dc _ldxp_getw 030c fmod 0322 __security_pop_cookie 0350 __c 0370 __b"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 2D ED 08 8B ?? ?? ?? ?? B0 B0 9F ED E4 AB 90 ED 00 1B 9F ED E0 8B 05 46 B4 EE C1 AB 8D ED 04 1B F1 EE 10 FA 4D D2 B4 EE C8 1B F1 EE 10 FA 48 D2 9F ED C6 0B 21 EE 00 1B B6 EE 00 0B B5 EE C0 1B F1 EE 10 FA 02 DB 30 EE 01 0B 01 E0 31 EE 40 0B 02 A8 00 21 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 8B B5 EE 40 8B F1 EE 10 FA 28 D0 B5 EE 00 0B 9F ED B4 1B 28 EE 00 0B 9F ED C5 4B 9F ED C2 2B 9D ED 04 6B 20 EE 01 7B 9F ED BD 3B 9F ED BA 5B 27 EE 04 0B 27 EE 02 1B 36 EE 40 0B 27 EE 03 2B 30 EE 41 0B 27 EE 05 3B 30 EE 42 0B 9F ED B0 1B 30 EE 43 2B 27 EE 01 0B 32 EE 40 0B 0F E1 9D ED 04 0B 0C E1 02 A9 68 46 06 24 8D ED 02 1B ?? ?? ?? ?? BD F9 00 30 56 2B 06 DA 9D ED 04 0B 0C A8 06 21 ?? ?? ?? ?? 41 E0 36 3B 5B 11 1B B2 AD F8 00 30 5B 01 59 42 04 A8 ?? ?? ?? ?? 9D ED 04 0B 08 A8 02 21 ?? ?? ?? ?? BD F9 00 30 97 4E 0C A8 03 EB 43 03 06 EB 03 13 A3 F1 30 01 30 22 ?? ?? ?? ?? 9D ED 08 0B 0C A8 06 21 ?? ?? ?? ?? 9D ED 0A 9B B5 EE 40 9B F1 EE 10 FA 17 D0 BD F9 00 30 18 A8 30 22 03 EB 43 03 06 EB 03 13 A3 F1 30 01 ?? ?? ?? ?? 18 A8 B0 EE 49 0B 06 21 ?? ?? ?? ?? 18 AA 0C A8 06 23 06 21 ?? ?? ?? ?? 7E 4E 9F ED 7B 9B 9F ED 78 BB 9D ED 0C 2B B4 EE CA 2B F1 EE 10 FA 04 D3 B4 EE C2 8B F1 EE 10 FA 52 D2 9D ED 0E 0B 00 21 02 A8 30 EE 02 0B 20 EE 09 0B 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 0B 02 21 08 A8 20 EE 0B 0B ?? ?? ?? ?? 64 49 E2 00 18 A8 ?? ?? ?? ?? 9D ED 08 0B 21 46 18 A8 ?? ?? ?? ?? 9D ED 0A 0B B5 EE 40 0B F1 EE 10 FA 25 D0 9D ED 0C 0B 06 A9 0D F1 02 00 8D ED 06 0B ?? ?? ?? ?? BD F9 02 20 82 FB 06 31 0B 11 03 EB D3 73 5B 00 5C 1D 06 2C 52 49 88 BF 06 24 E2 00 24 A8 ?? ?? ?? ?? 9D ED 0A 0B 21 46 24 A8 ?? ?? ?? ?? 24 AA 18 A8 23 46 21 46 ?? ?? ?? ?? 18 AA 0C A8 23 46 21 46 ?? ?? ?? ?? A0 E7 9D ED 0E 0B 9F ED 45 1B 30 EE 02 0B 20 EE 01 1B B6 EE 00 0B B5 EE C0 1B F1 EE 10 FA 02 DB 30 EE 01 0B 01 E0 31 EE 40 0B 02 A8 00 21 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 0B B5 EE 40 0B F1 EE 10 FA 2D D0 9D ED 0C 0B 06 A9 0D F1 02 00 8D ED 06 0B ?? ?? ?? ?? BD F9 02 20 82 FB 06 31 0B 11 03 EB D3 73 5B 00 5C 1D 06 2C 2B 49 88 BF 06 24 E2 00 24 A8 ?? ?? ?? ?? 9D ED 02 0B BD EE 00 1B 24 A8 21 46 20 EE 01 1B 9F ED 21 0B 21 EE 00 0B ?? ?? ?? ?? 24 AA 0C A8 23 46 21 46 ?? ?? ?? ?? 21 46 0C A8 ?? ?? ?? ?? 9D ED 02 8B 9F ED 16 2B 85 ED 00 0B B4 EE C2 8B F1 EE 10 FA 06 D3 9F ED 10 2B B4 EE C8 2B F1 EE 10 FA 07 D2 9F ED 0A 1B B0 EE 48 0B ?? ?? ?? ?? B0 EE 40 8B BD EE C8 0B 10 EE 10 3A 03 F0 03 00 30 B0 ?? ?? ?? ?? BD EC 08 8B BD E8 70 88 FE DE 00 00 00 00 00 00 E0 41 00 00 C0 FF FF FF DF 41 00 00 C0 FF FF FF DF C1 00 00 00 00 00 00 50 3E ?? ?? ?? ?? 83 C8 C9 6D 30 5F E4 3F 00 00 00 00 00 00 50 BE 83 C8 C9 6D 30 5F C4 3F ED 73 48 4D ?? ?? ?? ?? 00 00 00 20 9A 83 3B 3B 00 00 00 00 5C 14 D3 3C 00 00 00 20 26 A6 51 3E 00 00 00 60 B4 10 11 40 00 00 00 50 FB 21 B9 41 83 C8 C9 6D 30 5F 94 41 83 C8 C9 6D 30 5F 94 C1 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "_dquad"
		size = 940
		refs = "000c __security_push_cookie 0060 _d_int 00d4 _dunscale 00e8 _dxp_setw 00fe _dscale 0124 memcpy 0130 _dxp_mulh 016e _dxp_addx 02dc _dxp_getw 030c fmod 0322 __security_pop_cookie 0350 __c 0370 __b"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 2D ED 08 8B ?? ?? ?? ?? B0 B0 9F ED E4 AB 90 ED 00 1B 9F ED E0 8B 05 46 B4 EE C1 AB 8D ED 04 1B F1 EE 10 FA 4D D2 B4 EE C8 1B F1 EE 10 FA 48 D2 9F ED C6 0B 21 EE 00 1B B6 EE 00 0B B5 EE C0 1B F1 EE 10 FA 02 DB 30 EE 01 0B 01 E0 31 EE 40 0B 02 A8 00 21 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 8B B5 EE 40 8B F1 EE 10 FA 28 D0 B5 EE 00 0B 9F ED B4 1B 28 EE 00 0B 9F ED C5 4B 9F ED C2 2B 9D ED 04 6B 20 EE 01 7B 9F ED BD 3B 9F ED BA 5B 27 EE 04 0B 27 EE 02 1B 36 EE 40 0B 27 EE 03 2B 30 EE 41 0B 27 EE 05 3B 30 EE 42 0B 9F ED B0 1B 30 EE 43 2B 27 EE 01 0B 32 EE 40 0B 0F E1 9D ED 04 0B 0C E1 02 A9 68 46 06 24 8D ED 02 1B ?? ?? ?? ?? BD F9 00 30 56 2B 06 DA 9D ED 04 0B 0C A8 06 21 ?? ?? ?? ?? 41 E0 36 3B 5B 11 1B B2 AD F8 00 30 5B 01 59 42 04 A8 ?? ?? ?? ?? 9D ED 04 0B 08 A8 02 21 ?? ?? ?? ?? BD F9 00 30 97 4E 0C A8 03 EB 43 03 06 EB 03 13 A3 F1 30 01 30 22 ?? ?? ?? ?? 9D ED 08 0B 0C A8 06 21 ?? ?? ?? ?? 9D ED 0A 9B B5 EE 40 9B F1 EE 10 FA 17 D0 BD F9 00 30 18 A8 30 22 03 EB 43 03 06 EB 03 13 A3 F1 30 01 ?? ?? ?? ?? 18 A8 B0 EE 49 0B 06 21 ?? ?? ?? ?? 18 AA 0C A8 06 23 06 21 ?? ?? ?? ?? 7E 4E 9F ED 7B 9B 9F ED 78 BB 9D ED 0C 2B B4 EE CA 2B F1 EE 10 FA 04 D3 B4 EE C2 8B F1 EE 10 FA 52 D2 9D ED 0E 0B 00 21 02 A8 30 EE 02 0B 20 EE 09 0B 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 0B 02 21 08 A8 20 EE 0B 0B ?? ?? ?? ?? 64 49 E2 00 18 A8 ?? ?? ?? ?? 9D ED 08 0B 21 46 18 A8 ?? ?? ?? ?? 9D ED 0A 0B B5 EE 40 0B F1 EE 10 FA 25 D0 9D ED 0C 0B 06 A9 0D F1 02 00 8D ED 06 0B ?? ?? ?? ?? BD F9 02 20 82 FB 06 31 0B 11 03 EB D3 73 5B 00 5C 1D 06 2C 52 49 88 BF 06 24 E2 00 24 A8 ?? ?? ?? ?? 9D ED 0A 0B 21 46 24 A8 ?? ?? ?? ?? 24 AA 18 A8 23 46 21 46 ?? ?? ?? ?? 18 AA 0C A8 23 46 21 46 ?? ?? ?? ?? A0 E7 9D ED 0E 0B 9F ED 45 1B 30 EE 02 0B 20 EE 01 1B B6 EE 00 0B B5 EE C0 1B F1 EE 10 FA 02 DB 30 EE 01 0B 01 E0 31 EE 40 0B 02 A8 00 21 8D ED 02 0B ?? ?? ?? ?? 9D ED 02 0B B5 EE 40 0B F1 EE 10 FA 2D D0 9D ED 0C 0B 06 A9 0D F1 02 00 8D ED 06 0B ?? ?? ?? ?? BD F9 02 20 82 FB 06 31 0B 11 03 EB D3 73 5B 00 5C 1D 06 2C 2B 49 88 BF 06 24 E2 00 24 A8 ?? ?? ?? ?? 9D ED 02 0B BD EE 00 1B 24 A8 21 46 20 EE 01 1B 9F ED 21 0B 21 EE 00 0B ?? ?? ?? ?? 24 AA 0C A8 23 46 21 46 ?? ?? ?? ?? 21 46 0C A8 ?? ?? ?? ?? 9D ED 02 8B 9F ED 16 2B 85 ED 00 0B B4 EE C2 8B F1 EE 10 FA 06 D3 9F ED 10 2B B4 EE C8 2B F1 EE 10 FA 07 D2 9F ED 0A 1B B0 EE 48 0B ?? ?? ?? ?? B0 EE 40 8B BD EE C8 0B 10 EE 10 3A 03 F0 03 00 30 B0 ?? ?? ?? ?? BD EC 08 8B BD E8 70 88 FE DE 00 00 00 00 00 00 E0 41 00 00 C0 FF FF FF DF 41 00 00 C0 FF FF FF DF C1 00 00 00 00 00 00 50 3E ?? ?? ?? ?? 83 C8 C9 6D 30 5F E4 3F 00 00 00 00 00 00 50 BE 83 C8 C9 6D 30 5F C4 3F ED 73 48 4D ?? ?? ?? ?? 00 00 00 20 9A 83 3B 3B 00 00 00 00 5C 14 D3 3C 00 00 00 20 26 A6 51 3E 00 00 00 60 B4 10 11 40 00 00 00 50 FB 21 B9 41 83 C8 C9 6D 30 5F 94 41 83 C8 C9 6D 30 5F 94 C1 }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "_ldquadph"
		size = 252
		refs = "0014 _ldquad 0022 _ld_int 0052 fmod"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 82 B0 04 46 B0 EE 40 8B ?? ?? ?? ?? 05 46 68 46 01 21 8D ED 00 8B ?? ?? ?? ?? 9F ED 33 2B 9D ED 00 3B B4 EE C2 3B 38 EE 43 8B F1 EE 10 FA 06 D3 9F ED 2B 2B B4 EE C3 2B F1 EE 10 FA 07 D2 9F ED 26 1B B0 EE 43 0B ?? ?? ?? ?? B0 EE 40 3B B0 EE 00 0B 94 ED 00 2B 23 EE 00 0B 9F ED 1D 4B 9F ED 1A 1B B0 EE 42 3B BD EE C0 0B 08 EE 04 3B 10 EE 10 3A 03 F0 03 03 58 19 B4 EE C3 1B F1 EE 10 FA 05 D8 B6 EE 00 0B 40 1C 38 EE 40 0B 0B E0 9F ED 0C 0B B4 EE C0 3B F1 EE 10 FA 09 D8 B6 EE 00 0B 40 1E 30 EE 08 0B 00 EE 04 2B 84 ED 00 2B 01 E0 84 ED 00 3B 02 B0 BD EC 02 8B BD E8 30 88 FE DE 18 2D 44 54 FB 21 E9 BF 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 09 40 00 00 00 00 00 00 D0 41 00 00 80 FF FF FF CF 41 00 00 80 FF FF FF CF C1 }
	condition:
		$1
}

rule file_214_1_0 {
	meta:
		name = "_dquadph"
		size = 252
		refs = "0014 _dquad 0022 _d_int 0052 fmod"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 82 B0 04 46 B0 EE 40 8B ?? ?? ?? ?? 05 46 68 46 01 21 8D ED 00 8B ?? ?? ?? ?? 9F ED 33 2B 9D ED 00 3B B4 EE C2 3B 38 EE 43 8B F1 EE 10 FA 06 D3 9F ED 2B 2B B4 EE C3 2B F1 EE 10 FA 07 D2 9F ED 26 1B B0 EE 43 0B ?? ?? ?? ?? B0 EE 40 3B B0 EE 00 0B 94 ED 00 2B 23 EE 00 0B 9F ED 1D 4B 9F ED 1A 1B B0 EE 42 3B BD EE C0 0B 08 EE 04 3B 10 EE 10 3A 03 F0 03 03 58 19 B4 EE C3 1B F1 EE 10 FA 05 D8 B6 EE 00 0B 40 1C 38 EE 40 0B 0B E0 9F ED 0C 0B B4 EE C0 3B F1 EE 10 FA 09 D8 B6 EE 00 0B 40 1E 30 EE 08 0B 00 EE 04 2B 84 ED 00 2B 01 E0 84 ED 00 3B 02 B0 BD EC 02 8B BD E8 30 88 FE DE 18 2D 44 54 FB 21 E9 BF 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 09 40 00 00 00 00 00 00 D0 41 00 00 80 FF FF FF CF 41 00 00 80 FF FF FF CF C1 }
	condition:
		$1
}

rule file_129_2_0 {
	meta:
		name = "_ldsin"
		size = 396
		refs = "0012 _ldtest 0024 _ldquad 00f2 _fperrraise 0124 _LNan_C 0188 _LRteps_C"
	strings:
		$1 = { 03 B4 2D E9 1E 48 0D F1 10 0B 04 46 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 71 D0 01 28 68 D0 02 28 63 D0 68 46 ?? ?? ?? ?? 57 4B 9D ED 00 6B 02 19 93 ED 00 1B B1 EE 41 0B B4 EE C6 0B F1 EE 10 FA 0A D2 B4 EE C1 6B F1 EE 10 FA 05 D2 12 F0 01 0F 48 D0 B7 EE 00 6B 45 E0 26 EE 06 7B 12 F0 01 0F 20 D0 9F ED 47 0B 9F ED 44 1B 9F ED 41 2B 9F ED 3E 3B 27 EE 00 0B 9F ED 3A 4B B7 EE 00 6B 30 EE 41 0B 9F ED 35 1B 00 EE 07 2B 22 EE 07 0B 30 EE 43 0B 00 EE 07 1B 21 EE 07 0B 30 EE 44 0B 00 EE 07 6B 1F E0 9F ED 2A 0B 9F ED 27 1B 9F ED 24 2B 9F ED 21 3B 27 EE 00 0B 9F ED 1D 4B 9F ED 1A 5B 30 EE 41 0B 27 EE 06 1B 00 EE 07 2B 22 EE 07 0B 30 EE 43 0B 00 EE 07 4B 24 EE 07 0B 30 EE 45 0B 00 EE 01 6B 12 F0 02 0F 13 E0 9D ED 00 6B 13 E0 01 20 ?? ?? ?? ?? 0B 4B 93 ED 00 6B 0C E0 14 F0 01 0F 02 D0 B7 EE 00 6B 01 E0 9D ED 00 6B 14 F0 02 0F 01 D0 B1 EE 46 6B B0 EE 46 0B BD E8 1E 08 5D F8 0C FB ?? ?? ?? ?? 42 55 55 55 55 55 C5 3F FA F0 10 11 11 11 81 3F 3E E3 B5 19 A0 01 2A 3F 4D AD E4 4F E3 1D C7 3E 8F 0C 73 A1 E1 E5 5A 3E B0 8F 2F C3 10 D8 E5 3D B1 02 55 55 55 55 A5 3F AE FF FF FF FF FF DF 3F F6 FB 51 16 6C C1 56 3F 63 AC 30 90 9F 01 FA 3E 3B A8 61 C6 F9 7D 92 3E 09 26 0A 10 39 BA 21 3E ?? ?? ?? ?? }
	condition:
		$1
}

rule file_214_2_0 {
	meta:
		name = "_dsin"
		size = 396
		refs = "0012 _dtest 0024 _dquad 00f2 _fperrraise 0124 _Nan_C 0188 _Rteps_C"
	strings:
		$1 = { 03 B4 2D E9 1E 48 0D F1 10 0B 04 46 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 71 D0 01 28 68 D0 02 28 63 D0 68 46 ?? ?? ?? ?? 57 4B 9D ED 00 6B 02 19 93 ED 00 1B B1 EE 41 0B B4 EE C6 0B F1 EE 10 FA 0A D2 B4 EE C1 6B F1 EE 10 FA 05 D2 12 F0 01 0F 48 D0 B7 EE 00 6B 45 E0 26 EE 06 7B 12 F0 01 0F 20 D0 9F ED 47 0B 9F ED 44 1B 9F ED 41 2B 9F ED 3E 3B 27 EE 00 0B 9F ED 3A 4B B7 EE 00 6B 30 EE 41 0B 9F ED 35 1B 00 EE 07 2B 22 EE 07 0B 30 EE 43 0B 00 EE 07 1B 21 EE 07 0B 30 EE 44 0B 00 EE 07 6B 1F E0 9F ED 2A 0B 9F ED 27 1B 9F ED 24 2B 9F ED 21 3B 27 EE 00 0B 9F ED 1D 4B 9F ED 1A 5B 30 EE 41 0B 27 EE 06 1B 00 EE 07 2B 22 EE 07 0B 30 EE 43 0B 00 EE 07 4B 24 EE 07 0B 30 EE 45 0B 00 EE 01 6B 12 F0 02 0F 13 E0 9D ED 00 6B 13 E0 01 20 ?? ?? ?? ?? 0B 4B 93 ED 00 6B 0C E0 14 F0 01 0F 02 D0 B7 EE 00 6B 01 E0 9D ED 00 6B 14 F0 02 0F 01 D0 B1 EE 46 6B B0 EE 46 0B BD E8 1E 08 5D F8 0C FB ?? ?? ?? ?? 42 55 55 55 55 55 C5 3F FA F0 10 11 11 11 81 3F 3E E3 B5 19 A0 01 2A 3F 4D AD E4 4F E3 1D C7 3E 8F 0C 73 A1 E1 E5 5A 3E B0 8F 2F C3 10 D8 E5 3D B1 02 55 55 55 55 A5 3F AE FF FF FF FF FF DF 3F F6 FB 51 16 6C C1 56 3F 63 AC 30 90 9F 01 FA 3E 3B A8 61 C6 F9 7D 92 3E 09 26 0A 10 39 BA 21 3E ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_4_0 {
	meta:
		name = "get_acsize"
		size = 56
		refs = "0010 _ldunscale"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 02 A9 68 46 8D ED 02 0B ?? ?? ?? ?? BD F9 00 10 06 4B 81 FB 03 32 13 11 03 EB D3 73 5B 00 58 1D 06 28 88 BF 06 20 04 B0 BD E8 00 88 ED 73 48 4D }
	condition:
		$1
}

rule file_214_3_0 {
	meta:
		name = "get_acsize"
		size = 56
		refs = "0010 _dunscale"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 02 A9 68 46 8D ED 02 0B ?? ?? ?? ?? BD F9 00 10 06 4B 81 FB 03 32 13 11 03 EB D3 73 5B 00 58 1D 06 28 88 BF 06 20 04 B0 BD E8 00 88 ED 73 48 4D }
	condition:
		$1
}

rule file_129_5_0 {
	meta:
		name = "lgamma_big"
		size = 184
		refs = "001a _ldlog 0036 _ldunscale 0050 _ldscale 0084 _fperrraise"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 08 8B 84 B0 B7 EE 00 9B 00 20 89 EE 00 BB B0 EE 40 8B ?? ?? ?? ?? B6 EE 00 2B 02 A9 38 EE 42 2B 68 46 B0 EE 40 8B 2B EE 0B AB 8D ED 02 2B ?? ?? ?? ?? 9D ED 02 2B 38 EE 49 0B BD F9 00 10 02 A8 20 EE 02 0B 8D ED 02 0B ?? ?? ?? ?? 00 28 14 DA 9F ED 15 0B 9F ED 12 1B 9F ED 0F 2B 9F ED 0C 3B 2A EE 00 0B 30 EE 41 0B 9D ED 02 1B 00 EE 0A 2B 02 EE 0B 3B 33 EE 01 0B 04 E0 08 20 ?? ?? ?? ?? 9D ED 02 0B 04 B0 BD EC 08 8B BD E8 00 88 FE DE 69 7D C9 90 E3 CF DA 3F 55 55 55 55 55 55 B5 3F 17 6C C1 16 6C C1 66 3F 1A A0 01 1A A0 01 4A 3F }
	condition:
		$1
}

rule file_214_5_0 {
	meta:
		name = "lgamma_big"
		size = 184
		refs = "001a _dlog 0036 _dunscale 0050 _dscale 0084 _fperrraise"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 08 8B 84 B0 B7 EE 00 9B 00 20 89 EE 00 BB B0 EE 40 8B ?? ?? ?? ?? B6 EE 00 2B 02 A9 38 EE 42 2B 68 46 B0 EE 40 8B 2B EE 0B AB 8D ED 02 2B ?? ?? ?? ?? 9D ED 02 2B 38 EE 49 0B BD F9 00 10 02 A8 20 EE 02 0B 8D ED 02 0B ?? ?? ?? ?? 00 28 14 DA 9F ED 15 0B 9F ED 12 1B 9F ED 0F 2B 9F ED 0C 3B 2A EE 00 0B 30 EE 41 0B 9D ED 02 1B 00 EE 0A 2B 02 EE 0B 3B 33 EE 01 0B 04 E0 08 20 ?? ?? ?? ?? 9D ED 02 0B 04 B0 BD EC 08 8B BD E8 00 88 FE DE 69 7D C9 90 E3 CF DA 3F 55 55 55 55 55 55 B5 3F 17 6C C1 16 6C C1 66 3F 1A A0 01 1A A0 01 4A 3F }
	condition:
		$1
}

rule file_129_6_0 {
	meta:
		name = "lgammal"
		size = 500
		refs = "001a _ld_int 003e _fperrraise 0070 _ldsin 0082 _ldlog 0092 lgamma_big 00fe _ldpoly 016e _ldtgamma 01ae log1pl 01d4 approx 01e0 rootapprox 01ec _ldgamma_big 01f0 _LInf_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 87 B0 04 A8 00 21 8D ED 02 0B 8D ED 04 0B ?? ?? ?? ?? 9D ED 02 2B 30 B1 01 28 0C D0 02 28 0E D1 B0 EE 42 0B C3 E0 B5 EE C0 2B F1 EE 10 FA 06 D8 04 20 ?? ?? ?? ?? 6B 4B 93 ED 00 0B B7 E0 68 4B 93 ED 00 1B B1 EE 41 0B B4 EE C0 2B F1 EE 10 FA 1E D2 9D ED 04 0B 9F ED 60 8B 00 20 32 EE 40 0B 20 EE 08 0B ?? ?? ?? ?? 9D ED 02 1B 00 20 20 EE 01 0B 88 EE 00 0B ?? ?? ?? ?? 9D ED 02 2B B0 EE 40 8B B1 EE 42 0B ?? ?? ?? ?? 38 EE 40 0B 8E E0 B4 EE C2 1B F1 EE 10 FA 04 D8 B0 EE 42 0B ?? ?? ?? ?? 84 E0 4B 49 00 23 0A 46 92 ED 00 0B B4 EE C2 0B F1 EE 10 FA 06 D2 92 ED 02 0B B4 EE C0 2B F1 EE 10 FA 03 D3 5B 1C 28 32 0B 2B ED D3 0B 2B 12 D2 03 EB 83 03 01 EB C3 03 D3 E9 08 01 93 ED 04 0B 93 ED 06 1B 32 EE 40 0B 30 EE 41 0B 8D ED 04 0B ?? ?? ?? ?? 5A E0 9F ED 34 0B B4 EE C2 0B F1 EE 10 FA 2B D2 B7 EE 08 0B B4 EE C0 2B F1 EE 10 FA 24 D2 2C 49 00 23 0A 46 92 ED 00 0B B4 EE C0 2B F1 EE 10 FA 03 D3 5B 1C 20 32 01 2B F4 D3 01 EB 43 14 D4 E9 04 01 94 ED 02 0B 32 EE 40 0B 8D ED 04 0B ?? ?? ?? ?? D4 E9 06 01 B0 EE 40 8B 9D ED 04 0B ?? ?? ?? ?? 88 EE 00 0B 27 E0 69 46 02 A8 ?? ?? ?? ?? 9D ED 02 1B 8D ED 04 0B 00 20 B0 EE C1 0B ?? ?? ?? ?? BD F9 00 30 9F ED 10 3B B1 EE 40 4B 5B 42 9F ED 0C 2B 01 EE 10 3A 9D ED 04 0B B8 EE C1 1B 01 EE 03 4B 01 EE 02 4B 8D ED 02 4B ?? ?? ?? ?? 9D ED 02 1B 30 EE 01 0B 07 B0 BD EC 02 8B BD E8 10 88 00 00 00 C0 42 2E E6 3F 9E BC 9A F7 1C 7D 7F 3E ?? ?? ?? ?? 33 33 33 33 33 33 F3 3F ?? ?? ?? ?? 18 2D 44 54 FB 21 09 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_214_4_0 {
	meta:
		name = "lgamma"
		size = 500
		refs = "001a _d_int 003e _fperrraise 0070 _dsin 0082 _dlog 0092 lgamma_big 00fe _dpoly 016e _dtgamma 01ae log1p 01d4 approx 01e0 rootapprox 01ec _dgamma_big 01f0 _Inf_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 87 B0 04 A8 00 21 8D ED 02 0B 8D ED 04 0B ?? ?? ?? ?? 9D ED 02 2B 30 B1 01 28 0C D0 02 28 0E D1 B0 EE 42 0B C3 E0 B5 EE C0 2B F1 EE 10 FA 06 D8 04 20 ?? ?? ?? ?? 6B 4B 93 ED 00 0B B7 E0 68 4B 93 ED 00 1B B1 EE 41 0B B4 EE C0 2B F1 EE 10 FA 1E D2 9D ED 04 0B 9F ED 60 8B 00 20 32 EE 40 0B 20 EE 08 0B ?? ?? ?? ?? 9D ED 02 1B 00 20 20 EE 01 0B 88 EE 00 0B ?? ?? ?? ?? 9D ED 02 2B B0 EE 40 8B B1 EE 42 0B ?? ?? ?? ?? 38 EE 40 0B 8E E0 B4 EE C2 1B F1 EE 10 FA 04 D8 B0 EE 42 0B ?? ?? ?? ?? 84 E0 4B 49 00 23 0A 46 92 ED 00 0B B4 EE C2 0B F1 EE 10 FA 06 D2 92 ED 02 0B B4 EE C0 2B F1 EE 10 FA 03 D3 5B 1C 28 32 0B 2B ED D3 0B 2B 12 D2 03 EB 83 03 01 EB C3 03 D3 E9 08 01 93 ED 04 0B 93 ED 06 1B 32 EE 40 0B 30 EE 41 0B 8D ED 04 0B ?? ?? ?? ?? 5A E0 9F ED 34 0B B4 EE C2 0B F1 EE 10 FA 2B D2 B7 EE 08 0B B4 EE C0 2B F1 EE 10 FA 24 D2 2C 49 00 23 0A 46 92 ED 00 0B B4 EE C0 2B F1 EE 10 FA 03 D3 5B 1C 20 32 01 2B F4 D3 01 EB 43 14 D4 E9 04 01 94 ED 02 0B 32 EE 40 0B 8D ED 04 0B ?? ?? ?? ?? D4 E9 06 01 B0 EE 40 8B 9D ED 04 0B ?? ?? ?? ?? 88 EE 00 0B 27 E0 69 46 02 A8 ?? ?? ?? ?? 9D ED 02 1B 8D ED 04 0B 00 20 B0 EE C1 0B ?? ?? ?? ?? BD F9 00 30 9F ED 10 3B B1 EE 40 4B 5B 42 9F ED 0C 2B 01 EE 10 3A 9D ED 04 0B B8 EE C1 1B 01 EE 03 4B 01 EE 02 4B 8D ED 02 4B ?? ?? ?? ?? 9D ED 02 1B 30 EE 01 0B 07 B0 BD EC 02 8B BD E8 10 88 00 00 00 C0 42 2E E6 3F 9E BC 9A F7 1C 7D 7F 3E ?? ?? ?? ?? 33 33 33 33 33 33 F3 3F ?? ?? ?? ?? 18 2D 44 54 FB 21 09 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "_lderfc"
		size = 88
		refs = "0020 _ldpoly 003c _ldexp 0050 _c 0054 _s"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 82 B0 20 EE 00 2B 10 48 06 21 B0 EE 40 9B B1 EE 42 2B 8D ED 00 2B ?? ?? ?? ?? 0A 48 B0 EE 40 8B B0 EE 49 0B 06 21 ?? ?? ?? ?? 68 46 88 EE 00 0B 00 21 ?? ?? ?? ?? 9D ED 00 0B 02 B0 BD EC 04 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "_derfc"
		size = 88
		refs = "0020 _dpoly 003c _dexp 0050 _c 0054 _s"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 82 B0 20 EE 00 2B 10 48 06 21 B0 EE 40 9B B1 EE 42 2B 8D ED 00 2B ?? ?? ?? ?? 0A 48 B0 EE 40 8B B0 EE 49 0B 06 21 ?? ?? ?? ?? 68 46 88 EE 00 0B 00 21 ?? ?? ?? ?? 9D ED 00 0B 02 B0 BD EC 04 8B BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_130_1_0 {
	meta:
		name = "erfl"
		size = 372
		refs = "000e _ldtest 00c0 _lderfc 0104 _lderf_one 0170 _lderf_small"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 72 D0 01 28 65 D0 02 28 6E D0 54 4B 9D ED 00 5B 93 ED 00 0B B0 EE C5 1B B4 EE C0 1B F1 EE 10 FA 3A D2 9F ED 4C 0B 9F ED 49 2B 9F ED 46 1B 9F ED 43 3B 25 EE 05 4B 04 EE 00 2B 9F ED 3E 0B 04 EE 01 3B 9F ED 3A 1B 03 EE 04 0B 9F ED 36 3B 02 EE 04 1B 9F ED 32 2B 01 EE 04 3B 9F ED 2E 1B 00 EE 04 2B 9F ED 2A 0B 03 EE 04 1B 9F ED 26 3B 02 EE 04 0B 9F ED 22 2B 01 EE 04 3B 9F ED 1E 1B 00 EE 04 2B B7 EE 00 0B 02 EE 04 1B 03 EE 04 0B 81 EE 00 0B 20 EE 05 0B 29 E0 15 4B 93 ED 00 2B B4 EE C2 1B F1 EE 10 FA 0A D2 B0 EE 41 0B ?? ?? ?? ?? B7 EE 00 1B 9D ED 00 5B 31 EE 40 0B 01 E0 B7 EE 00 0B B5 EE C0 5B F1 EE 10 FA 0F D2 B1 EE 40 0B 0C E0 BD F8 06 30 13 F4 00 4F 02 D0 BF EE 00 0B 04 E0 B7 EE 00 0B 01 E0 9D ED 00 0B BD E8 0C 88 ?? ?? ?? ?? 6D 9B 42 50 D7 0D F2 3F 86 72 09 F2 96 95 C6 3F E4 49 ED C8 3B 57 DF 3F 0A CE FC 99 24 7C AA 3F 6F FF 10 D7 6A EC BB 3F 62 5B 02 D3 36 85 6C 3F DF 10 9A 9A C7 40 8D 3F E6 74 61 30 1C 3D 53 3F 3E 30 56 72 0A 80 35 3F 69 20 49 94 93 9E E2 3E 67 3E 76 81 41 29 80 3E E5 70 D2 CE CB 9F 0E 3F D1 53 87 C9 F7 96 B7 3E ?? ?? ?? ?? }
	condition:
		$1
}

rule file_246_1_0 {
	meta:
		name = "erf"
		size = 372
		refs = "000e _dtest 00c0 _derfc 0104 _derf_one 0170 _derf_small"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 72 D0 01 28 65 D0 02 28 6E D0 54 4B 9D ED 00 5B 93 ED 00 0B B0 EE C5 1B B4 EE C0 1B F1 EE 10 FA 3A D2 9F ED 4C 0B 9F ED 49 2B 9F ED 46 1B 9F ED 43 3B 25 EE 05 4B 04 EE 00 2B 9F ED 3E 0B 04 EE 01 3B 9F ED 3A 1B 03 EE 04 0B 9F ED 36 3B 02 EE 04 1B 9F ED 32 2B 01 EE 04 3B 9F ED 2E 1B 00 EE 04 2B 9F ED 2A 0B 03 EE 04 1B 9F ED 26 3B 02 EE 04 0B 9F ED 22 2B 01 EE 04 3B 9F ED 1E 1B 00 EE 04 2B B7 EE 00 0B 02 EE 04 1B 03 EE 04 0B 81 EE 00 0B 20 EE 05 0B 29 E0 15 4B 93 ED 00 2B B4 EE C2 1B F1 EE 10 FA 0A D2 B0 EE 41 0B ?? ?? ?? ?? B7 EE 00 1B 9D ED 00 5B 31 EE 40 0B 01 E0 B7 EE 00 0B B5 EE C0 5B F1 EE 10 FA 0F D2 B1 EE 40 0B 0C E0 BD F8 06 30 13 F4 00 4F 02 D0 BF EE 00 0B 04 E0 B7 EE 00 0B 01 E0 9D ED 00 0B BD E8 0C 88 ?? ?? ?? ?? 6D 9B 42 50 D7 0D F2 3F 86 72 09 F2 96 95 C6 3F E4 49 ED C8 3B 57 DF 3F 0A CE FC 99 24 7C AA 3F 6F FF 10 D7 6A EC BB 3F 62 5B 02 D3 36 85 6C 3F DF 10 9A 9A C7 40 8D 3F E6 74 61 30 1C 3D 53 3F 3E 30 56 72 0A 80 35 3F 69 20 49 94 93 9E E2 3E 67 3E 76 81 41 29 80 3E E5 70 D2 CE CB 9F 0E 3F D1 53 87 C9 F7 96 B7 3E ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_3_0 {
	meta:
		name = "?fast_check@@YAHHH@Z"
		size = 28
		refs = "0018 __acrt_initial_locale_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 1B 68 33 F8 10 30 03 EA 01 00 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_7_0 {
	meta:
		name = "__iscsym"
		size = 68
		refs = "0014 _isalnum_l 003c __acrt_initial_locale_data 0040 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0D 4B C4 B2 1B 68 23 B1 00 21 20 46 ?? ?? ?? ?? 07 E0 08 4B 1B 68 33 F8 14 20 40 F2 07 13 02 EA 03 00 18 B9 5F 2C 18 BF 00 20 00 D1 01 20 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_8_0 {
	meta:
		name = "__iscsymf"
		size = 64
		refs = "0012 _isalpha_l 0038 __acrt_initial_locale_data 003c __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 4B 04 46 1B 68 1B B1 00 21 ?? ?? ?? ?? 07 E0 07 4B 1B 68 33 F8 14 20 40 F2 03 13 02 EA 03 00 18 B9 5F 2C 18 BF 00 20 00 D1 01 20 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_11_0 {
	meta:
		name = "_isalnum_l"
		size = 80
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0022 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 06 DD 01 AA 40 F2 07 11 20 46 ?? ?? ?? ?? 06 E0 13 68 33 F8 14 20 40 F2 07 13 02 EA 03 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_12_0 {
	meta:
		name = "_isalpha_l"
		size = 80
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0022 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 06 DD 01 AA 40 F2 03 11 20 46 ?? ?? ?? ?? 06 E0 13 68 33 F8 14 20 40 F2 03 13 02 EA 03 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_13_0 {
	meta:
		name = "_isblank_l"
		size = 82
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 09 2C 08 BF 40 20 0E D0 01 9A 53 68 01 2B 05 DD 01 AA 40 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 40 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_15_0 {
	meta:
		name = "_iscntrl_l"
		size = 74
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 20 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 20 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_16_0 {
	meta:
		name = "_iscsym_l"
		size = 30
		refs = "000a _isalnum_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 18 B9 5F 2C 18 BF 00 20 00 D1 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_131_17_0 {
	meta:
		name = "_iscsymf_l"
		size = 30
		refs = "000a _isalpha_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 18 B9 5F 2C 18 BF 00 20 00 D1 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_131_18_0 {
	meta:
		name = "_isdigit_l"
		size = 74
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 04 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 04 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_19_0 {
	meta:
		name = "_isgraph_l"
		size = 80
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0022 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 06 DD 01 AA 40 F2 17 11 20 46 ?? ?? ?? ?? 06 E0 13 68 33 F8 14 20 40 F2 17 13 02 EA 03 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_20_0 {
	meta:
		name = "_islower_l"
		size = 74
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 02 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 02 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_21_0 {
	meta:
		name = "_isprint_l"
		size = 80
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0022 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 06 DD 01 AA 40 F2 57 11 20 46 ?? ?? ?? ?? 06 E0 13 68 33 F8 14 20 40 F2 57 13 02 EA 03 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_22_0 {
	meta:
		name = "_ispunct_l"
		size = 74
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 10 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 10 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_23_0 {
	meta:
		name = "_isspace_l"
		size = 74
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 08 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 08 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_24_0 {
	meta:
		name = "_isupper_l"
		size = 74
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 01 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 01 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_25_0 {
	meta:
		name = "_isxdigit_l"
		size = 74
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0020 _isctype_l"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 80 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 80 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_131_26_0 {
	meta:
		name = "isalnum"
		size = 52
		refs = "0012 _isalnum_l 002c __acrt_initial_locale_data 0030 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 4B 1B 68 23 B1 00 21 BD E8 00 48 ?? ?? ?? ?? 05 4B 1B 68 33 F8 10 20 40 F2 07 13 02 EA 03 00 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_27_0 {
	meta:
		name = "isalpha"
		size = 52
		refs = "0012 _isalpha_l 002c __acrt_initial_locale_data 0030 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 4B 1B 68 23 B1 00 21 BD E8 00 48 ?? ?? ?? ?? 05 4B 1B 68 33 F8 10 20 40 F2 03 13 02 EA 03 00 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_28_0 {
	meta:
		name = "isblank"
		size = 56
		refs = "0012 _isblank_l 0030 __acrt_initial_locale_data 0034 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 4B 1B 68 23 B1 00 21 BD E8 00 48 ?? ?? ?? ?? 09 28 01 D1 40 20 05 E0 04 4B 1B 68 33 F8 10 30 03 F0 40 00 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_29_0 {
	meta:
		name = "iscntrl"
		size = 104
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _isctype_l 0060 __acrt_initial_locale_data 0064 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 16 4B 04 46 1B 68 EB B1 68 46 00 21 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 20 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 20 00 9D F8 0C 30 6B B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 E0 04 4B 1B 68 33 F8 14 30 03 F0 20 00 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_30_0 {
	meta:
		name = "isdigit"
		size = 104
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _isctype_l 0060 __acrt_initial_locale_data 0064 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 16 4B 04 46 1B 68 EB B1 68 46 00 21 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 04 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 04 00 9D F8 0C 30 6B B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 E0 04 4B 1B 68 33 F8 14 30 03 F0 04 00 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_31_0 {
	meta:
		name = "isgraph"
		size = 52
		refs = "0012 _isgraph_l 002c __acrt_initial_locale_data 0030 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 4B 1B 68 23 B1 00 21 BD E8 00 48 ?? ?? ?? ?? 05 4B 1B 68 33 F8 10 20 40 F2 17 13 02 EA 03 00 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_32_0 {
	meta:
		name = "islower"
		size = 104
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _isctype_l 0060 __acrt_initial_locale_data 0064 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 16 4B 04 46 1B 68 EB B1 68 46 00 21 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 02 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 02 00 9D F8 0C 30 6B B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 E0 04 4B 1B 68 33 F8 14 30 03 F0 02 00 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_33_0 {
	meta:
		name = "isprint"
		size = 52
		refs = "0012 _isprint_l 002c __acrt_initial_locale_data 0030 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 4B 1B 68 23 B1 00 21 BD E8 00 48 ?? ?? ?? ?? 05 4B 1B 68 33 F8 10 20 40 F2 57 13 02 EA 03 00 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_34_0 {
	meta:
		name = "ispunct"
		size = 104
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _isctype_l 0060 __acrt_initial_locale_data 0064 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 16 4B 04 46 1B 68 EB B1 68 46 00 21 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 10 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 10 00 9D F8 0C 30 6B B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 E0 04 4B 1B 68 33 F8 14 30 03 F0 10 00 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_35_0 {
	meta:
		name = "isspace"
		size = 104
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _isctype_l 0060 __acrt_initial_locale_data 0064 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 16 4B 04 46 1B 68 EB B1 68 46 00 21 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 08 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 08 00 9D F8 0C 30 6B B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 E0 04 4B 1B 68 33 F8 14 30 03 F0 08 00 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_36_0 {
	meta:
		name = "isupper"
		size = 104
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _isctype_l 0060 __acrt_initial_locale_data 0064 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 16 4B 04 46 1B 68 EB B1 68 46 00 21 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 01 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 01 00 9D F8 0C 30 6B B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 E0 04 4B 1B 68 33 F8 14 30 03 F0 01 00 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_37_0 {
	meta:
		name = "isxdigit"
		size = 104
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _isctype_l 0060 __acrt_initial_locale_data 0064 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 16 4B 04 46 1B 68 EB B1 68 46 00 21 ?? ?? ?? ?? 01 9A 53 68 01 2B 05 DD 01 AA 80 21 20 46 ?? ?? ?? ?? 04 E0 13 68 33 F8 14 30 03 F0 80 00 9D F8 0C 30 6B B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 E0 04 4B 1B 68 33 F8 14 30 03 F0 80 00 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__acrt_initialize_locks"
		size = 68
		refs = "0016 __acrt_InitializeCriticalSectionEx 0030 __acrt_uninitialize_locks 003c ?__acrt_locks_initialized@@3IA 0040 ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0D 4D 0C 4E 00 24 00 22 4F F4 7A 61 28 46 ?? ?? ?? ?? 40 B1 33 68 64 1C 18 35 5B 1C 33 60 0E 2C F1 D3 01 20 03 E0 00 20 ?? ?? ?? ?? 00 20 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_1_0 {
	meta:
		name = "__acrt_lock"
		size = 36
		refs = "001c __imp_EnterCriticalSection 0020 ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 00 EB 40 02 03 EB C2 00 02 4B 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_3_0 {
	meta:
		name = "__acrt_unlock"
		size = 36
		refs = "001c __imp_LeaveCriticalSection 0020 ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 00 EB 40 02 03 EB C2 00 02 4B 1B 68 98 47 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_2_0 {
	meta:
		name = "__acrt_uninitialize_locks"
		size = 68
		refs = "0038 __imp_DeleteCriticalSection 003c ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 0040 ?__acrt_locks_initialized@@3IA"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0D 4D 2C 68 8C B1 0B 4B 04 EB 44 02 08 4F 03 EB C2 03 A3 F1 18 06 3B 68 30 46 98 47 2B 68 64 1E 18 3E 5B 1E 2B 60 00 2C F5 D1 01 20 BD E8 F0 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_4_0 {
	meta:
		name = "_lock_locales"
		size = 16
		refs = "000c __acrt_lock"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_5_0 {
	meta:
		name = "_unlock_locales"
		size = 16
		refs = "000c __acrt_unlock"
	strings:
		$1 = { 2D E9 00 48 EB 46 04 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_133_5_0 {
	meta:
		name = "_mbsnbset_l"
		size = 166
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0024 _strnset 0030 _errno 0038 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 FF 48 0D F1 20 0B 0E 46 05 46 07 46 68 46 19 46 14 46 ?? ?? ?? ?? 02 9B 9B 68 33 B9 22 46 31 46 38 46 ?? ?? ?? ?? 07 46 2E E0 45 B9 3C B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 27 24 E0 33 0A D9 B2 F9 B1 F2 B2 92 B9 ?? ?? ?? ?? 16 23 20 21 03 60 20 22 0B E0 2B 78 64 1E AB B1 00 2C A4 F1 01 04 07 D0 6B 78 2B B1 29 70 6A 70 AD 1C 00 2C F1 D1 09 E0 20 23 2B 70 06 E0 2B 78 64 1E 1B B1 05 F8 01 6B 00 2C F8 D1 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 38 46 04 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "truncf"
		size = 28
		refs = "0010 _fd_int"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 00 21 8D ED 00 0A ?? ?? ?? ?? 9D ED 00 0A BD E8 0C 88 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_putw"
		size = 110
		refs = "0016 _errno 001e _invalid_parameter_noinfo 0030 _lock_file 0046 _fputc_nolock 0050 ferror 005c _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 FE 49 0D F1 20 0B 6F 46 0D 46 FD 62 80 46 B8 62 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 1C E0 6F F0 00 03 3B 60 28 46 ?? ?? ?? ?? 17 F1 2C 06 17 F1 28 04 B4 42 06 D0 94 F9 00 00 29 46 ?? ?? ?? ?? 64 1C F6 E7 28 46 ?? ?? ?? ?? 08 B9 C7 F8 00 80 F8 6A ?? ?? ?? ?? 3B 68 7B 60 78 68 BD E8 FE 09 5D F8 0C FB }
	condition:
		$1
}

rule file_136_4_0 {
	meta:
		name = "_stricoll"
		size = 36
		refs = "0010 _stricmp 0016 _stricoll_l 0020 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 1B 68 1B B9 BD E8 00 48 ?? ?? ?? ?? 00 22 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_136_5_0 {
	meta:
		name = "_stricoll_l"
		size = 128
		refs = "0012 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a _errno 0022 _invalid_parameter_noinfo 0034 _stricmp 0050 __acrt_CompareStringA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 88 B0 0C 46 05 46 04 A8 11 46 ?? ?? ?? ?? 05 B1 34 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 1A E0 05 9B D3 F8 A4 10 21 B9 21 46 28 46 ?? ?? ?? ?? 15 E0 1B 69 05 A8 41 F2 01 02 03 93 6F F0 00 03 02 93 00 93 2B 46 01 94 ?? ?? ?? ?? 30 B9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 40 00 E0 80 1E 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 08 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "dekker_mul12"
		size = 76
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 54 EC 10 3B 55 EC 11 2B 03 F0 78 43 02 F0 78 42 44 EC 14 3B 45 EC 16 2B 20 EE 01 3B 26 EE 04 2B 31 EE 46 5B 30 EE 44 0B 32 EE 43 1B 80 ED 00 3B 05 EE 04 1B 06 EE 00 1B 05 EE 00 1B 81 ED 00 1B BD E8 30 88 }
	condition:
		$1
}

rule file_137_1_0 {
	meta:
		name = "fmod"
		size = 716
		refs = "006a _handle_nan 009c _handle_error 01c6 __dtoi64 01ca __i64tod 02c8 ??_C@_04KEPJIHGP@fmod?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 2D ED 0A 8B 85 B0 5E EC 10 5B 58 EC 11 4B CE F3 0A 51 4F F0 00 4A 01 29 B0 EE 40 AB 2E EA 0A 07 28 EA 0A 06 C8 F3 0A 50 40 F2 FE 79 10 DB 49 45 10 DC 42 1E 40 F2 FD 73 9A 42 09 D8 A5 42 66 D1 B7 42 64 D1 0E EA 0A 03 00 22 43 EC 1A 2B 0C E0 49 45 22 DD 73 46 6F F3 1F 53 2B 43 0C D0 28 46 71 46 ?? ?? ?? ?? B0 EE 40 AB B0 EE 4A 0B 05 B0 BD EC 0A 8B BD E8 F0 8F 02 23 03 93 21 23 02 93 08 23 01 93 01 23 8E 48 00 93 8C 4B 00 22 B0 EE 4A 0B 16 21 ?? ?? ?? ?? E5 E7 48 45 07 DD 43 46 6F F3 1F 53 23 43 E0 D0 20 46 41 46 D9 E7 55 EA 07 03 03 D1 54 EA 06 03 D7 D1 DD E7 54 EA 06 03 DA D0 4F F4 80 1E 01 29 0F DA 2A 46 B8 46 77 45 0A D8 09 D2 D3 0F 43 EA 48 08 49 1E 52 00 F0 45 F8 D3 01 D8 00 2A F5 D3 49 1C 01 28 0F DA 22 46 B0 46 76 45 0A D8 09 D2 D3 0F 43 EA 48 08 40 1E 52 00 F0 45 F8 D3 01 D8 00 2A F5 D3 40 1C 47 EC 1B 5B 46 EC 1C 4B B7 42 0D D8 01 D3 A5 42 0A D2 B5 EE C0 AB F1 EE 10 FA 02 D2 B1 EE 4B AB 9C E7 B0 EE 4B AB 99 E7 F1 EE 10 3A 83 F4 1F 47 81 42 01 DC 00 26 07 E0 5C 4B 09 1A 81 FB 03 32 13 11 13 EB D3 76 02 D1 B7 EE 00 8B 2A E0 34 23 06 FB 03 F5 54 4B 85 FB 03 32 02 EB D2 74 2B 1B 40 F2 FF 30 03 EB D3 71 23 18 1B 05 4F F0 00 0E 10 EB 61 02 43 EC 10 EB 20 EE 0C 1B 13 05 00 22 43 EC 10 2B A5 EB 61 03 1B 1B 21 EE 00 1B 1B 18 1B 05 00 21 43 4A 43 EC 10 1B 00 23 21 EE 00 CB 42 EC 18 3B 4F F0 78 44 00 2E 34 DD 8B EE 0C 0B ?? ?? ?? ?? ?? ?? ?? ?? 51 EC 10 3B 50 EC 1C 2B 23 40 22 40 41 EC 17 3B 40 EC 11 2B 20 EE 0C 3B 27 EE 01 2B 30 EE 47 6B 3C EE 41 4B 32 EE 43 5B 3B EE 43 2B 06 EE 01 5B 3B EE 42 0B 07 EE 04 5B 30 EE 43 0B 06 EE 04 5B 30 EE 45 0B 30 EE 02 BB B5 EE C0 BB F1 EE 10 FA 01 D2 3B EE 0C BB 28 EE 0C CB 76 1E CA D1 8B EE 0C 8B B0 EE 48 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 40 9B B0 EE 48 0B ?? ?? ?? ?? 51 EC 1C 3B 50 EC 19 2B 23 40 22 40 41 EC 13 3B 40 EC 17 2B 29 EE 0C 4B 27 EE 03 2B 39 EE 47 6B 3C EE 43 1B 32 EE 44 5B 3B EE 44 2B 06 EE 03 5B 3B EE 42 0B 07 EE 01 5B 30 EE 44 0B 06 EE 01 5B 30 EE 45 0B 30 EE 02 0B B5 EE C0 0B F1 EE 10 FA 01 D2 30 EE 0C 0B 87 F4 1F 43 E1 EE 10 3A B5 EE C0 AB F1 EE 10 FA BF F4 DE AE B1 EE 40 AB DC E6 00 00 B0 3C 56 55 55 55 4F EC C4 4E 00 00 F8 FF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_137_2_0 {
	meta:
		name = "scaleDouble_3"
		size = 84
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 11 4B 80 FB 03 32 02 EB D2 75 43 1B 40 F2 FF 34 03 EB D3 71 2B 19 1B 05 00 26 14 EB 61 02 43 EC 12 6B 22 EE 00 1B 13 05 00 22 43 EC 10 2B A0 EB 61 03 5B 1B 21 EE 00 1B 1B 19 1B 05 43 EC 10 2B 21 EE 00 0B BD E8 78 88 56 55 55 55 }
	condition:
		$1
}

rule file_138_4_0 {
	meta:
		name = "__ascii_memicmp"
		size = 74
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 00 25 00 24 D2 B1 46 1A 73 5C 11 F8 01 0B 52 1E 83 42 11 D0 41 2B 04 D3 5A 2B 02 D8 03 F1 20 05 00 E0 1D 46 41 28 04 D3 5A 28 02 D8 00 F1 20 04 00 E0 04 46 A5 42 01 D1 00 2A E5 D1 28 1B BD E8 78 88 }
	condition:
		$1
}

rule file_138_5_0 {
	meta:
		name = "_memicmp"
		size = 60
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0028 __ascii_memicmp 0030 _memicmp_l 0038 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 0C 4B 1B 68 83 B9 48 B9 42 B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 40 08 E0 09 B9 00 2A F3 D1 ?? ?? ?? ?? 02 E0 00 23 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_138_6_0 {
	meta:
		name = "_memicmp_l"
		size = 140
		refs = "0018 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 _errno 0030 _invalid_parameter_noinfo 0048 __ascii_memicmp 005a _tolower_l"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 85 B0 0F 46 80 46 68 46 19 46 14 46 00 25 00 26 ?? ?? ?? ?? B8 F1 00 0F 00 D1 0C B9 4F B9 44 B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 40 1B E0 01 9B D3 F8 A8 30 A3 B9 22 46 39 46 40 46 ?? ?? ?? ?? 11 E0 64 1E B5 42 0D D1 18 F8 01 0B 01 A9 ?? ?? ?? ?? 05 46 17 F8 01 0B 01 A9 ?? ?? ?? ?? 06 46 00 2C EE D1 A8 1B 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "??$common_lseek@J@@YAJHJH@Z"
		size = 204
		refs = "001a __doserrno 0022 _errno 005c __acrt_lowio_lock_fh 0090 ??$common_lseek_nolock@J@@YAJHJH@Z 0098 __acrt_lowio_unlock_fh 00b0 _invalid_parameter_noinfo 00c4 __pioinfo 00c8 _nhandle"
	strings:
		$1 = { 0F B4 2D E9 FE 4F 0D F1 28 0B 6F 46 15 46 0E 46 04 46 3C 63 10 F1 02 0F 08 D1 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 09 23 03 60 43 E0 00 2C 37 DB 25 4B 1B 68 9C 42 33 D2 4F EA A4 18 DF F8 84 90 04 F0 3F 03 03 EB 43 0A 59 F8 28 30 03 EB 0A 13 93 F8 28 30 13 F0 01 0F 22 D0 20 46 ?? ?? ?? ?? 6F F0 00 03 7B 60 59 F8 28 30 03 EB 0A 13 93 F8 28 30 13 F0 01 0F 08 D1 ?? ?? ?? ?? 09 23 03 60 ?? ?? ?? ?? 00 23 03 60 05 E0 2A 46 31 46 20 46 ?? ?? ?? ?? 78 60 38 6B ?? ?? ?? ?? 7B 68 0B E0 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 09 23 03 60 ?? ?? ?? ?? 6F F0 00 03 3B 60 38 68 BD E8 FE 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_7_0 {
	meta:
		name = "_write"
		size = 204
		refs = "001a __doserrno 0022 _errno 005c __acrt_lowio_lock_fh 0090 _write_nolock 0098 __acrt_lowio_unlock_fh 00b0 _invalid_parameter_noinfo 00c4 __pioinfo 00c8 _nhandle"
	strings:
		$1 = { 0F B4 2D E9 FE 4F 0D F1 28 0B 6F 46 15 46 0E 46 04 46 3C 63 10 F1 02 0F 08 D1 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 09 23 03 60 43 E0 00 2C 37 DB 25 4B 1B 68 9C 42 33 D2 4F EA A4 18 DF F8 84 90 04 F0 3F 03 03 EB 43 0A 59 F8 28 30 03 EB 0A 13 93 F8 28 30 13 F0 01 0F 22 D0 20 46 ?? ?? ?? ?? 6F F0 00 03 7B 60 59 F8 28 30 03 EB 0A 13 93 F8 28 30 13 F0 01 0F 08 D1 ?? ?? ?? ?? 09 23 03 60 ?? ?? ?? ?? 00 23 03 60 05 E0 2A 46 31 46 20 46 ?? ?? ?? ?? 78 60 38 6B ?? ?? ?? ?? 7B 68 0B E0 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 09 23 03 60 ?? ?? ?? ?? 6F F0 00 03 3B 60 38 68 BD E8 FE 0F 5D F8 14 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_2_0 {
	meta:
		name = "??$common_lseek@_J@@YA_JH_JH@Z"
		size = 224
		refs = "001e __doserrno 0026 _errno 005c __acrt_lowio_lock_fh 0096 ??$common_lseek_nolock@_J@@YA_JH_JH@Z 00a0 __acrt_lowio_unlock_fh 00bc _invalid_parameter_noinfo 00d8 __pioinfo 00dc _nhandle"
	strings:
		$1 = { 0F B4 2D E9 F0 4F 0D F1 1C 0B 85 B0 6F 46 82 B0 99 46 92 46 04 46 BC 63 10 F1 02 0F 08 D1 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 09 23 03 60 47 E0 00 2C 3B DB 29 4B 1B 68 9C 42 37 D2 A5 11 26 4E 04 F0 3F 03 03 EB 43 08 56 F8 25 30 03 EB 08 13 93 F8 28 30 13 F0 01 0F 28 D0 20 46 ?? ?? ?? ?? 6F F0 00 03 BB 60 FB 60 56 F8 25 30 03 EB 08 13 93 F8 28 30 13 F0 01 0F 08 D1 ?? ?? ?? ?? 09 23 03 60 ?? ?? ?? ?? 00 23 03 60 08 E0 BB 6C 00 93 4B 46 52 46 20 46 ?? ?? ?? ?? B8 60 F9 60 B8 6B ?? ?? ?? ?? BB 68 3B 60 FB 68 0C E0 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 09 23 03 60 ?? ?? ?? ?? 6F F0 00 03 3B 60 7B 60 38 68 79 68 07 B0 BD E8 F0 0F 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_4_0 {
	meta:
		name = "??$common_lseek_nolock@J@@YAJHJH@Z"
		size = 96
		refs = "000e _get_osfhandle 001a _errno 0028 ?common_lseek_do_seek_nolock@@YAJQAXJH@Z 005c __pioinfo"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 15 46 0F 46 06 46 ?? ?? ?? ?? 6F F0 00 04 A0 42 04 D1 ?? ?? ?? ?? 09 23 03 60 17 E0 2A 46 39 46 ?? ?? ?? ?? 05 46 A5 42 10 D0 0A 49 06 F0 3F 03 B0 11 03 EB 43 02 51 F8 20 30 2C 46 03 EB 02 12 92 F8 28 30 03 F0 FD 03 82 F8 28 30 20 46 BD E8 F0 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_5_0 {
	meta:
		name = "??$common_lseek_nolock@_J@@YA_JH_JH@Z"
		size = 144
		refs = "0010 _get_osfhandle 001c _errno 0042 __acrt_errno_map_os_error 0084 __pioinfo 0088 __imp_GetLastError 008c __imp_SetFilePointerEx"
	strings:
		$1 = { 0F B4 2D E9 FF 48 0D F1 20 0B 1D 46 17 46 06 46 ?? ?? ?? ?? 6F F0 00 04 A0 42 05 D1 ?? ?? ?? ?? 09 23 03 60 20 46 26 E0 0E 9B 18 49 3A 46 01 93 09 68 02 AB 00 93 2B 46 88 47 28 B9 12 4B 1B 68 98 47 ?? ?? ?? ?? ED E7 DD E9 02 05 00 EA 05 03 A3 42 E7 D0 0B 49 06 F0 3F 03 B4 11 03 EB 43 02 51 F8 24 30 2C 46 03 EB 02 12 92 F8 28 30 03 F0 FD 03 82 F8 28 30 21 46 04 B0 BD E8 F0 08 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_6_0 {
	meta:
		name = "?common_lseek_do_seek_nolock@@YAJQAXJH@Z"
		size = 144
		refs = "0030 __acrt_errno_map_os_error 0076 _errno 0088 __imp_SetFilePointerEx 008c __imp_GetLastError"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 88 B0 00 23 CD E9 04 33 01 23 1D 4C 01 93 06 AB 00 93 05 9B 17 46 04 9A 24 68 0E 46 05 46 A0 47 28 B9 18 4B 1B 68 98 47 ?? ?? ?? ?? 23 E0 14 49 00 22 CD E9 02 22 09 68 02 AA 00 92 32 46 F3 17 28 46 01 97 88 47 00 28 EB D0 DD E9 02 03 00 2B 13 DB 03 DC 6F F0 00 43 98 42 0E D9 08 49 00 23 06 9A 01 93 00 93 07 9B 09 68 28 46 88 47 ?? ?? ?? ?? 16 23 03 60 6F F0 00 00 08 B0 BD E8 F0 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_7_0 {
	meta:
		name = "?common_lseek_do_seek_nolock@@YA_JQAX_JH@Z"
		size = 68
		refs = "0020 __acrt_errno_map_os_error 003c __imp_GetLastError 0040 __imp_SetFilePointerEx"
	strings:
		$1 = { 0F B4 2D E9 0F 48 0D F1 10 0B 0A 99 01 91 02 A9 00 91 0B 49 09 68 88 47 40 B9 08 4B 1B 68 98 47 ?? ?? ?? ?? 6F F0 00 00 01 46 01 E0 DD E9 02 01 04 B0 5D F8 04 BB 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_4_0 {
	meta:
		name = "_wcsxfrm_l"
		size = 232
		refs = "0018 _errno 0020 _invalid_parameter_noinfo 0036 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0048 wcsncpy 004e wcslen 006c __acrt_LCMapStringW"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 17 46 6F F0 00 45 AF 42 88 46 06 46 06 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 5C E0 0E B9 00 2F F5 D1 B8 F1 00 0F F2 D0 02 A8 19 46 ?? ?? ?? ?? 03 9B D3 F8 A4 00 48 B9 3A 46 41 46 30 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 05 46 3A E0 4F F0 00 09 6F EA 09 03 42 46 4F F4 80 61 CD F8 04 90 CD F8 00 90 ?? ?? ?? ?? 04 46 2C B9 ?? ?? ?? ?? 2A 23 03 60 2C 46 24 E0 BC 42 19 DC 03 9A 6F F0 00 03 4F F4 80 61 D2 F8 A4 00 42 46 01 97 00 96 ?? ?? ?? ?? 04 46 00 2C E8 D0 02 46 64 1E 82 B1 06 EB 40 01 52 1E B3 5C 21 F8 02 3D FA D1 08 E0 36 B1 2F B1 A6 F8 00 90 ?? ?? ?? ?? 22 23 03 60 64 1E 25 46 9D F8 14 30 33 B1 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 28 46 06 B0 BD E8 F0 8B }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "log"
		size = 564
		refs = "002e _handle_nan 005e _handle_error 01c4 ?ln_tail_table@?1??log@@9@9 01c8 ?ln_lead_table@?1??log@@9@9 0220 ??_C@_03MGHMBJCF@log?$AA@"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 2D ED 02 8B 85 B0 88 4A 54 EC 10 5B B0 EE 40 2B 04 EA 02 03 93 42 21 D1 23 46 6F F3 1F 53 2B 43 06 D0 28 46 21 46 ?? ?? ?? ?? B0 EE 40 2B B5 E0 14 F0 00 4F 00 F0 B2 80 21 22 02 92 01 23 08 22 03 93 00 93 77 4B 01 92 9F ED 74 1B 72 48 00 22 B0 EE 42 0B 1A 21 ?? ?? ?? ?? E6 E7 4F F0 00 42 24 EA 02 03 2B 43 09 D1 01 23 03 93 22 23 02 93 04 23 01 93 02 23 00 93 66 4B E5 E7 14 42 DB D1 63 4B E2 18 61 4B 9A 42 28 D8 00 D3 35 BB B7 EE 00 0B B0 EE 00 1B 32 EE 40 7B 9F ED 5A 3B 9F ED 57 6B 37 EE 01 0B 9F ED 53 4B 9F ED 50 5B 87 EE 00 0B 20 EE 07 2B 30 EE 00 0B 20 EE 00 1B 01 EE 03 6B 21 EE 00 0B 06 EE 01 4B 04 EE 01 5B 25 EE 00 0B 30 EE 42 0B 30 EE 07 2B 5F E0 B4 F5 80 1F 0C D8 0B D2 44 F0 74 73 9F ED 3E 1B 43 EC 10 5B 3C 26 30 EE 41 0B 54 EC 10 5B 00 E0 00 26 A3 0B 03 F0 3F 03 62 0B 43 F0 40 01 02 F0 01 03 C8 18 9F ED 32 1B 00 EE 10 0A 22 46 40 F2 FE 33 B8 EE C0 0B 63 F3 1F 52 B6 EE 00 2B 20 EE 01 1B 42 EC 10 5B 9F ED 28 3B 9F ED 25 6B 9F ED 22 8B C4 F3 0A 53 9B 1B 30 EE 41 0B 1D 49 A3 F2 FF 33 1B 4A 00 EE 02 1B 02 EB C0 02 9F ED 16 2B 80 EE 01 7B 00 EE 10 3A 27 EE 07 1B 01 EB C0 03 12 ED 80 5B B8 EE C0 4B 01 EE 03 6B 9F ED 0C 0B 13 ED 80 3B 06 EE 01 8B 04 EE 00 3B 28 EE 01 1B 01 EE 07 7B 37 EE 05 0B 04 EE 02 0B 30 EE 03 2B B0 EE 42 0B 05 B0 BD EC 02 8B BD E8 70 88 FE DE 00 00 00 E0 42 2E E6 3F 3C 79 35 EF 39 FA 6E 3E ?? ?? ?? ?? ?? ?? ?? ?? 57 55 55 55 55 55 B5 3F DE 5E 86 99 99 99 89 3F 41 47 D9 3B 42 49 62 3F 00 00 00 00 00 00 80 3F 00 00 00 00 00 00 D0 03 E6 54 55 55 55 55 B5 3F D4 C6 BA 99 99 99 89 3F 9F 51 F1 07 23 49 62 3F F0 FF 5D C8 34 80 3C 3F 82 F8 02 00 56 F0 11 C0 00 00 F0 FF ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F8 FF 00 00 F0 7F }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "_wrename"
		size = 48
		refs = "0016 __acrt_errno_map_os_error 0028 __imp_GetLastError 002c __imp_MoveFileExW"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 4B 02 22 1B 68 98 47 38 B9 05 4B 1B 68 98 47 ?? ?? ?? ?? 6F F0 00 00 00 E0 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_7_0 {
	meta:
		name = "_fputc_nolock"
		size = 40
		refs = "0014 __acrt_stdio_flush_and_write_narrow_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 8B 68 5B 1E 8B 60 00 2B 03 DA BD E8 00 48 ?? ?? ?? ?? 0B 68 18 70 0B 68 C0 B2 5B 1C 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_143_8_0 {
	meta:
		name = "_fputchar"
		size = 28
		refs = "000c __acrt_iob_func 0018 fputc"
		altNames = "putchar"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 01 20 ?? ?? ?? ?? 01 46 20 46 BD E8 18 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_9_0 {
	meta:
		name = "_fputwchar"
		size = 28
		refs = "000c __acrt_iob_func 0018 fputwc"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 01 20 ?? ?? ?? ?? 01 46 20 46 BD E8 18 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_14_0 {
	meta:
		name = "putwchar"
		size = 28
		refs = "000c __acrt_iob_func 0018 fputwc"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 01 20 ?? ?? ?? ?? 01 46 20 46 BD E8 18 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_10_0 {
	meta:
		name = "fputc"
		size = 240
		refs = "0014 _errno 001c _invalid_parameter_noinfo 002c _lock_file 0048 _fileno 00ba __jump_unwind 00c2 _fputc_nolock 00ca _unlock_file 00e4 $LN36 00e8 __pioinfo 00ec __badioinfo"
	strings:
		$1 = { 03 B4 2D E9 FE 49 0D F1 20 0B 6F 46 0C 46 FC 62 06 46 44 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 57 E0 00 23 7B 60 20 46 ?? ?? ?? ?? 3C 60 E3 68 BF F3 5B 8F 13 F4 80 5F 01 D0 01 23 00 E0 00 23 DB BB 20 46 ?? ?? ?? ?? 6F F0 00 08 40 45 0E D0 10 F1 02 0F 0B D0 81 11 22 4D 00 F0 3F 03 03 EB 43 02 55 F8 21 30 03 EB 02 13 1F 4A 02 E0 1E 4A 13 46 1C 4D 93 F9 29 30 93 B9 40 45 0B D0 10 F1 02 0F 08 D0 81 11 00 F0 3F 03 03 EB 43 02 55 F8 21 30 03 EB 02 12 92 F8 2D 30 13 F0 01 0F 0C D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? C7 F8 08 80 0B 49 07 F1 30 00 ?? ?? ?? ?? 21 46 30 46 ?? ?? ?? ?? 78 60 F8 6A ?? ?? ?? ?? 7B 68 01 E0 00 BF BB 68 3B 60 38 68 BD E8 FE 09 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "catanh"
		size = 636
		refs = "0016 creal 002a cimag 0034 _dtest 0194 log1p 01c0 atan2 01da _fperrraise 0202 log 0244 _Cbuild 025c _Inf_C 0278 _Zero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 08 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 17 D1 02 28 02 D1 9D ED 02 8B 27 E0 01 28 0B D1 9D ED 00 0B 9F ED 86 8B B5 EE C0 0B F1 EE 10 FA 35 D2 9F ED 7E 1B EA E0 9D ED 02 8B B0 EE 48 1B E5 E0 02 28 15 D1 01 2C 03 D0 14 B1 9D ED 00 8B F4 E7 BD F8 0E 30 13 F4 00 4F 05 D0 7A 4B 93 ED 00 0B B1 EE 40 8B 01 E0 9F ED 75 8B 9D ED 00 1B CD E0 01 2C 16 D1 9D ED 02 0B B5 EE C0 0B F1 EE 10 FA 05 D2 70 4B 93 ED 00 0B B1 EE 40 8B 01 E0 9F ED 6B 8B BD F8 06 30 13 F4 00 4F C9 D1 9F ED 60 1B B4 E0 BD F8 06 30 9D ED 00 9B 13 F4 00 4F 02 D0 B1 EE 49 BB 01 E0 B0 EE 49 BB 9D ED 02 2B B5 EE C0 2B F1 EE 10 FA 05 D2 B1 EE 42 2B 01 24 8D ED 02 2B 04 E0 B1 EE 49 9B 00 24 8D ED 00 9B 9F ED 55 0B B4 EE C2 0B F1 EE 10 FA 11 D2 89 EE 02 1B B7 EE 00 AB 8A EE 02 0B 01 EE 01 AB 80 EE 0A 8B B5 EE C0 9B F1 EE 10 FA 12 D2 9F ED 48 1B 77 E0 B4 EE CB 0B F1 EE 10 FA 0D D2 82 EE 09 1B B7 EE 00 2B 81 EE 09 0B 01 EE 01 2B 80 EE 02 8B E7 E7 9F ED 3B 1B 64 E0 B7 EE 00 AB B4 EE 4A 2B F1 EE 10 FA 2A D0 2B EE 0B 9B 3A EE 42 8B B1 EE 00 0B B0 EE 49 1B 22 EE 00 0B 08 EE 08 1B 80 EE 01 0B ?? ?? ?? ?? 9D ED 02 2B 9D ED 00 4B B0 EE 00 3B B0 EE 40 5B 32 EE 0A 2B 24 EE 03 0B 22 EE 08 2B B5 EE 00 3B 32 EE 49 1B 25 EE 03 8B ?? ?? ?? ?? B6 EE 00 1B 20 EE 01 1B 32 E0 B5 EE 40 9B F1 EE 10 FA 08 D1 04 20 ?? ?? ?? ?? 1F 4B 9D ED 00 1B 93 ED 00 8B 24 E0 B1 EE 00 2B B1 EE CB 3B 09 EE 09 2B B1 EE C2 2B B1 EE C2 2B 82 EE 03 0B ?? ?? ?? ?? B0 EE 00 1B B0 EE 40 8B B0 EE 4B 0B ?? ?? ?? ?? 9F ED 0F 2B B6 EE 00 3B B5 EE C0 9B 32 EE 00 2B F1 EE 10 FA 22 EE 03 1B 01 D2 B1 EE 41 1B 14 B1 B1 EE 48 8B 01 E0 B1 EE 41 1B B0 EE 48 0B ?? ?? ?? ?? 09 B0 BD EC 08 8B BD E8 10 88 FE DE 18 2D 44 54 FB 21 F9 3F ?? ?? ?? ?? 18 2D 44 54 FB 21 F9 BF 7B 52 82 BD 3A FB CF 5F 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_504_1_0 {
	meta:
		name = "catanhl"
		size = 636
		refs = "0016 creall 002a cimagl 0034 _ldtest 0194 log1pl 01c0 atan2 01da _fperrraise 0202 log 0244 _LCbuild 025c _LInf_C 0278 _LZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 08 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 17 D1 02 28 02 D1 9D ED 02 8B 27 E0 01 28 0B D1 9D ED 00 0B 9F ED 86 8B B5 EE C0 0B F1 EE 10 FA 35 D2 9F ED 7E 1B EA E0 9D ED 02 8B B0 EE 48 1B E5 E0 02 28 15 D1 01 2C 03 D0 14 B1 9D ED 00 8B F4 E7 BD F8 0E 30 13 F4 00 4F 05 D0 7A 4B 93 ED 00 0B B1 EE 40 8B 01 E0 9F ED 75 8B 9D ED 00 1B CD E0 01 2C 16 D1 9D ED 02 0B B5 EE C0 0B F1 EE 10 FA 05 D2 70 4B 93 ED 00 0B B1 EE 40 8B 01 E0 9F ED 6B 8B BD F8 06 30 13 F4 00 4F C9 D1 9F ED 60 1B B4 E0 BD F8 06 30 9D ED 00 9B 13 F4 00 4F 02 D0 B1 EE 49 BB 01 E0 B0 EE 49 BB 9D ED 02 2B B5 EE C0 2B F1 EE 10 FA 05 D2 B1 EE 42 2B 01 24 8D ED 02 2B 04 E0 B1 EE 49 9B 00 24 8D ED 00 9B 9F ED 55 0B B4 EE C2 0B F1 EE 10 FA 11 D2 89 EE 02 1B B7 EE 00 AB 8A EE 02 0B 01 EE 01 AB 80 EE 0A 8B B5 EE C0 9B F1 EE 10 FA 12 D2 9F ED 48 1B 77 E0 B4 EE CB 0B F1 EE 10 FA 0D D2 82 EE 09 1B B7 EE 00 2B 81 EE 09 0B 01 EE 01 2B 80 EE 02 8B E7 E7 9F ED 3B 1B 64 E0 B7 EE 00 AB B4 EE 4A 2B F1 EE 10 FA 2A D0 2B EE 0B 9B 3A EE 42 8B B1 EE 00 0B B0 EE 49 1B 22 EE 00 0B 08 EE 08 1B 80 EE 01 0B ?? ?? ?? ?? 9D ED 02 2B 9D ED 00 4B B0 EE 00 3B B0 EE 40 5B 32 EE 0A 2B 24 EE 03 0B 22 EE 08 2B B5 EE 00 3B 32 EE 49 1B 25 EE 03 8B ?? ?? ?? ?? B6 EE 00 1B 20 EE 01 1B 32 E0 B5 EE 40 9B F1 EE 10 FA 08 D1 04 20 ?? ?? ?? ?? 1F 4B 9D ED 00 1B 93 ED 00 8B 24 E0 B1 EE 00 2B B1 EE CB 3B 09 EE 09 2B B1 EE C2 2B B1 EE C2 2B 82 EE 03 0B ?? ?? ?? ?? B0 EE 00 1B B0 EE 40 8B B0 EE 4B 0B ?? ?? ?? ?? 9F ED 0F 2B B6 EE 00 3B B5 EE C0 9B 32 EE 00 2B F1 EE 10 FA 22 EE 03 1B 01 D2 B1 EE 41 1B 14 B1 B1 EE 48 8B 01 E0 B1 EE 41 1B B0 EE 48 0B ?? ?? ?? ?? 09 B0 BD EC 08 8B BD E8 10 88 FE DE 18 2D 44 54 FB 21 F9 3F ?? ?? ?? ?? 18 2D 44 54 FB 21 F9 BF 7B 52 82 BD 3A FB CF 5F 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_4_0 {
	meta:
		name = "_mblen_l"
		size = 156
		refs = "001c ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0024 _isleadbyte_l 0098 __imp_MultiByteToWideChar"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 86 B0 05 46 0C 46 F5 B3 90 F9 00 30 DB B3 D4 B3 02 A8 11 46 ?? ?? ?? ?? 28 78 03 A9 ?? ?? ?? ?? 00 28 03 98 15 D0 43 68 01 2B 1D DD 6F F0 00 42 94 42 19 D8 9C 42 17 DB 15 4C 80 68 00 22 24 68 01 92 00 92 2A 46 09 21 A0 47 68 B1 03 9B 58 68 0E E0 0F 4C 80 68 00 22 24 68 01 92 00 92 01 23 2A 46 09 21 A0 47 10 B9 6F F0 00 00 00 E0 01 20 9D F8 14 30 43 B1 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 00 E0 00 20 06 B0 BD E8 30 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_145_5_0 {
	meta:
		name = "mblen"
		size = 36
		refs = "0012 _mblen_l 001c __acrt_initial_locale_pointers 0020 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 1B 68 0B B9 03 4A 00 E0 00 22 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "remquof"
		size = 380
		refs = "0016 _fdtest 007e _fdunscale 00ae _fdscale 0162 _fperrraise 0178 _FNan_C"
	strings:
		$1 = { 03 B4 2D E9 FF 4B 0D F1 28 0B 07 46 01 A8 CD ED 03 0A 8D ED 01 0A ?? ?? ?? ?? 04 46 03 A8 ?? ?? ?? ?? 0F B1 00 23 3B 60 00 2C 80 F2 8B 80 00 28 80 F2 88 80 DD ED 03 0A F5 EE C0 0A F1 EE 10 FA 05 D2 F1 EE 60 0A 01 26 CD ED 03 0A 00 E0 00 26 9D ED 01 0A B5 EE C0 0A F1 EE 10 FA 09 D2 B1 EE 40 0A 01 23 9B 1B 8D ED 01 0A 1E B2 4F F0 01 08 01 E0 4F F0 00 08 02 A9 68 46 CD ED 02 0A ?? ?? ?? ?? 01 9B 00 25 4F F0 01 09 02 93 02 A9 0D F1 02 00 ?? ?? ?? ?? 38 B3 BD F9 00 20 BD F9 02 30 9C 1A 00 2C 20 DB 03 9B 21 46 02 A8 02 93 ?? ?? ?? ?? 9D ED 02 0A DD ED 01 0A B4 EE E0 0A F1 EE 10 FA 03 D9 64 1E 00 2C ED DA 08 E0 70 EE C0 0A 20 2C CD ED 01 0A 02 D2 09 FA 04 F3 1D 44 CD ED 02 0A 00 2C D2 DA 01 E0 DD ED 01 0A F5 EE C0 0A F1 EE 10 FA 1A DD 9D ED 03 1A B6 EE 00 0A 21 EE 00 0A B4 EE E0 0A F1 EE 10 FA 04 D2 B5 EE C0 0A F1 EE 10 FA 07 DC B4 EE 60 0A F1 EE 10 FA 05 D1 15 F0 01 0F 02 D0 70 EE C1 0A 6D 1C 27 B1 25 F0 00 43 06 B1 5B 42 3B 60 B8 F1 00 0F 16 D0 F1 EE 60 0A 13 E0 02 2C 02 D1 DD ED 01 0A 0E E0 02 28 02 D1 DD ED 03 0A 09 E0 01 2C 01 D0 00 28 F3 D1 01 20 ?? ?? ?? ?? 04 4B D3 ED 00 0A B0 EE 60 0A BD E8 FF 0B 5D F8 0C FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_147_1_0 {
	meta:
		name = "cargl"
		size = 58
		refs = "0014 creall 0024 cimagl 0036 atan2"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B 04 B0 BD EC 02 8B BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "carg"
		size = 58
		refs = "0014 creal 0024 cimag 0036 atan2"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B 04 B0 BD EC 02 8B BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "clog10f"
		size = 36
		refs = "0010 clogf 0018 _FCmulcr"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? 9F ED 02 1A ?? ?? ?? ?? BD E8 0C 88 D9 5B DE 3E }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "logbl"
		size = 88
		refs = "0010 _ldunscale 0040 _fperrraise 0054 _LInf_C"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 02 A9 68 46 8D ED 02 0B ?? ?? ?? ?? 98 B1 01 28 0D D0 02 28 08 D0 BD F9 00 30 5B 1E 1B B2 00 EE 10 3A B8 EE C0 0B 0E E0 9D ED 02 0B 0B E0 07 4B 93 ED 00 0B 07 E0 04 20 ?? ?? ?? ?? 03 4B 93 ED 00 0B B1 EE 40 0B BD E8 0F 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_561_0_0 {
	meta:
		name = "logb"
		size = 88
		refs = "0010 _dunscale 0040 _fperrraise 0054 _Inf_C"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 02 A9 68 46 8D ED 02 0B ?? ?? ?? ?? 98 B1 01 28 0D D0 02 28 08 D0 BD F9 00 30 5B 1E 1B B2 00 EE 10 3A B8 EE C0 0B 0E E0 9D ED 02 0B 0B E0 07 4B 93 ED 00 0B 07 E0 04 20 ?? ?? ?? ?? 03 4B 93 ED 00 0B B1 EE 40 0B BD E8 0F 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "modf"
		size = 196
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 54 EC 10 5B 4F F0 00 42 24 EA 02 01 A2 F1 73 53 99 42 B0 EE 40 1B 14 D3 01 D8 00 2D 11 D3 26 4B 99 42 06 D3 00 D8 25 B1 80 ED 00 1B 31 EE 01 1B 38 E0 04 EA 02 03 00 22 80 ED 00 1B 43 EC 11 2B 30 E0 1C 4B 99 42 08 D8 07 D2 04 EA 02 03 00 22 43 EC 10 2B 80 ED 00 0B 24 E0 C4 F3 0A 52 40 F2 33 43 9A 1A A2 F1 20 03 01 21 99 40 01 23 93 40 5B 1E 61 F1 00 01 25 EA 03 02 24 EA 01 03 43 EC 10 2B B4 EE 40 1B 80 ED 00 0B F1 EE 10 FA 07 D1 B5 EE C0 1B F1 EE 10 FA 02 D2 9F ED 04 1B 01 E0 31 EE 40 1B B0 EE 41 0B BD E8 30 88 00 00 00 00 00 00 00 80 00 00 F0 3F 00 00 F0 7F }
	condition:
		$1
}

rule file_153_5_0 {
	meta:
		name = "_mbsnbcnt_l"
		size = 106
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0018 _errno 0020 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 45 B9 3C B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 13 E0 2A 46 84 B1 02 99 13 78 64 1E 63 B1 0B 44 5B 7E 13 F0 04 0F 02 D0 52 1C 13 78 1B B1 52 1C 00 2C F1 D1 00 E0 52 1E 50 1B 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "_mbsninc"
		size = 30
		refs = "0014 _mbsnbcnt_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 0C B9 00 20 04 E0 00 22 20 46 ?? ?? ?? ?? 20 44 BD E8 18 88 }
	condition:
		$1
}

rule file_154_1_0 {
	meta:
		name = "_mbsninc_l"
		size = 28
		refs = "0012 _mbsnbcnt_l"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 0C B9 00 20 03 E0 20 46 ?? ?? ?? ?? 20 44 BD E8 18 88 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "strncat"
		size = 48
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 10 F9 01 3B 00 2B FB D1 40 1E 05 E0 11 F9 01 3B 52 1E 00 F8 01 3B 1B B1 00 2A F7 D1 00 23 03 70 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "lrintf"
		size = 128
		refs = "0012 _fdtest 0024 nearbyintf 003c _fperrraise"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 68 46 8D ED 00 0A ?? ?? ?? ?? 00 28 28 D0 01 DD 02 28 22 DD 9D ED 00 0A ?? ?? ?? ?? 9D ED 00 2A B0 EE 40 8A B4 EE 42 0A F1 EE 10 FA 02 D0 20 20 ?? ?? ?? ?? 9F ED 0E 2A B4 EE C8 2A F1 EE 10 FA 0B D8 9F ED 0A 2A B4 EE C2 8A F1 EE 10 FA 04 D8 BD EE C8 0A 10 EE 10 0A 03 E0 01 20 ?? ?? ?? ?? 00 20 02 B0 BD EC 02 8B BD E8 00 88 00 00 00 4F 00 00 00 CF }
	condition:
		$1
}

rule file_157_2_0 {
	meta:
		name = "log2l"
		size = 18
		refs = "000e _ldlog"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 00 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_536_2_0 {
	meta:
		name = "log2f"
		size = 18
		refs = "000e _fdlog"
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 00 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_6_0 {
	meta:
		name = "?InternalCompareStringA@@YAHPAU__crt_locale_pointers@@PB_WKPBDH2HH@Z"
		size = 672
		refs = "0008 __security_push_cookie 002c __strncnt 0156 __chkstk 0174 _malloc_base 0256 __acrt_CompareStringEx 026e _free_base 028e __security_pop_cookie 0298 __imp_MultiByteToWideChar 029c __imp_GetCPInfo"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8C B0 6F 46 86 B0 D7 F8 5C A0 99 46 C7 E9 03 21 C7 F8 04 A0 BD 6D 04 46 00 2D 0F DD 29 46 18 46 ?? ?? ?? ?? 05 46 D7 F8 60 80 B8 F1 00 0F 0A DD 41 46 50 46 ?? ?? ?? ?? 80 46 07 E0 B5 F1 FF 3F F1 DA 00 24 1A E1 B8 F1 FF 3F FA DB 7E 6E 3E 60 16 B9 23 68 9E 68 3E 60 15 B1 B8 F1 00 0F 47 D1 45 45 01 D1 02 24 09 E1 B8 F1 01 0F 01 DD 01 24 04 E1 01 2D 01 DD 03 24 00 E1 85 4B 17 F1 18 01 30 46 1B 68 98 47 00 28 DB D0 00 2D 16 DD BB 69 02 2B F0 D3 BB 7F 17 F1 1E 02 00 2B EB D0 51 78 00 29 E8 D0 99 F8 00 00 13 78 98 42 01 D3 88 42 D8 D9 12 F8 02 3F 00 2B F1 D1 DC E7 B8 F1 00 0F 16 DD BB 69 02 2B D2 D3 BB 7F 17 F1 1E 02 00 2B CD D0 51 78 00 29 CA D0 9A F8 00 00 13 78 98 42 01 D3 88 42 BE D9 12 F8 02 3F 00 2B F1 D1 BE E7 66 4C 00 23 01 93 24 68 00 93 2B 46 4A 46 09 21 30 46 A0 47 B8 60 00 28 9B D0 43 00 03 F1 08 02 9A 42 98 BF 00 22 4C F6 CC 41 4D F6 DD 5A 62 B3 03 F1 08 02 9A 42 98 BF 00 22 B2 F5 80 6F 16 D8 03 F1 08 02 9A 42 98 BF 00 22 D3 1D 93 42 01 D8 6F F0 07 03 23 F0 07 03 9C 08 ?? ?? ?? ?? AD EB 04 0D 1D F1 18 06 11 D0 31 60 08 36 0E E0 03 F1 08 00 98 42 98 BF 00 20 ?? ?? ?? ?? 06 46 16 B1 C0 F8 00 A0 08 36 B8 68 00 E0 00 26 00 2E 73 D0 42 4C 2B 46 3D 68 24 68 01 90 4A 46 01 21 28 46 00 96 A0 47 00 28 67 D0 3C 4C 7A 68 00 23 24 68 01 93 00 93 43 46 09 21 28 46 A0 47 81 46 00 28 5A D0 43 00 03 F1 08 02 9A 42 98 BF 00 22 62 B3 03 F1 08 02 9A 42 98 BF 00 22 B2 F5 80 6F 17 D8 03 F1 08 02 9A 42 98 BF 00 22 D3 1D 93 42 01 D8 6F F0 07 03 23 F0 07 03 9C 08 ?? ?? ?? ?? AD EB 04 0D 1D F1 18 05 11 D0 4C F6 CC 43 2B 60 0A E0 03 F1 08 00 98 42 98 BF 00 20 ?? ?? ?? ?? 05 46 FD B1 C0 F8 00 A0 08 35 00 E0 00 25 CD B1 1B 4C D7 E9 00 02 43 46 24 68 01 21 CD F8 04 90 00 95 A0 47 70 B1 00 23 D7 E9 03 10 04 93 03 93 02 93 BB 68 32 46 CD F8 04 90 00 95 ?? ?? ?? ?? 04 46 00 E0 00 24 4D B1 55 F8 08 3C 53 45 05 D1 A5 F1 08 00 ?? ?? ?? ?? 00 E0 00 24 3E B1 56 F8 08 3C 53 45 03 D1 A6 F1 08 00 ?? ?? ?? ?? 20 46 BD 46 0C B0 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_10_0 {
	meta:
		name = "__acrt_CompareStringA"
		size = 78
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0030 ?InternalCompareStringA@@YAHPAU__crt_locale_pointers@@PB_WKPBDH2HH@Z"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 89 B0 0E 46 01 46 04 A8 1C 46 15 46 ?? ?? ?? ?? 11 98 23 46 2A 46 03 90 10 98 31 46 02 90 0F 98 01 90 0E 98 00 90 05 A8 ?? ?? ?? ?? 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 09 B0 BD E8 70 88 }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "_gcvt"
		size = 32
		refs = "0012 _gcvt_s"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 02 46 20 46 6F F0 00 01 ?? ?? ?? ?? 00 B1 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_159_5_0 {
	meta:
		name = "_gcvt_s"
		size = 314
		refs = "000a __security_push_cookie 001e _errno 0026 _invalid_parameter_noinfo 0056 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 007e __acrt_fltout 00bc __acrt_fp_format 012e __security_pop_cookie"
	strings:
		$1 = { 0F B4 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? AD F5 43 7D 04 46 16 46 8D ED 08 0B 0D 46 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 25 7C E0 1D B9 ?? ?? ?? ?? 16 25 08 E0 4F F0 00 09 84 F8 00 90 AE 42 06 D3 ?? ?? ?? ?? 22 25 05 60 ?? ?? ?? ?? 6A E0 0E A8 00 21 ?? ?? ?? ?? 0F 9B 9D ED 08 0B 4F F4 AF 77 D3 F8 88 30 6A AA 0A A9 1B 68 38 46 93 F9 00 80 00 23 CD E9 0A 33 0C 93 3B 46 ?? ?? ?? ?? 0B 99 4A 1E B2 F1 FF 3F 08 DB 73 1E 9A 42 05 DC 10 23 04 93 73 1A 02 93 66 23 04 E0 10 23 04 93 73 1E 02 93 65 23 01 93 12 AB 08 A8 2A 46 21 46 CD F8 14 90 CD F8 18 90 00 97 ?? ?? ?? ?? 05 46 35 B1 ?? ?? ?? ?? 05 60 23 E0 43 45 04 D0 64 1C 94 F9 00 30 00 2B F8 D1 94 F9 00 30 C3 B1 14 F9 01 3F 04 E0 65 2B 04 D0 64 1C 94 F9 00 30 00 2B F8 D1 22 46 14 F9 01 3D 02 E0 64 1E 94 F9 00 30 30 2B FA D0 12 F9 01 3B 04 F8 01 3F 00 2B F9 D1 00 25 9D F8 44 30 33 B1 0E 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 28 46 0D F5 43 7D ?? ?? ?? ?? BD E8 F0 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_160_1_0 {
	meta:
		name = "??$thread_start@P6AIPAX@Z@@YAKQAX@Z"
		size = 104
		refs = "001a __acrt_getptd 0022 __acrt_get_begin_thread_init_policy 002c __acrt_RoInitialize 004a _endthreadex 004e _exit 005c __guard_check_icall_fptr 0060 __imp_ExitThread 0064 __imp_GetLastError"
	strings:
		$1 = { 2D E9 B8 48 0D F1 10 0B 6F 46 04 46 2C B9 15 4B 1B 68 98 47 12 4B 1B 68 98 47 ?? ?? ?? ?? C0 F8 60 43 ?? ?? ?? ?? 02 28 07 D1 01 20 ?? ?? ?? ?? 08 B9 01 23 00 E0 00 23 23 74 25 68 64 68 28 46 06 4B 1B 68 98 47 20 46 A8 47 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 00 E0 38 68 BD E8 B8 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_3_0 {
	meta:
		name = "??$thread_start@P6AXPAX@Z@@YAKQAX@Z"
		size = 108
		refs = "001a __acrt_getptd 0022 __acrt_get_begin_thread_init_policy 002c __acrt_RoInitialize 004c _endthreadex 0050 _exit 0060 __guard_check_icall_fptr 0064 __imp_ExitThread 0068 __imp_GetLastError"
	strings:
		$1 = { 2D E9 B8 48 0D F1 10 0B 6F 46 04 46 2C B9 16 4B 1B 68 98 47 13 4B 1B 68 98 47 ?? ?? ?? ?? C0 F8 60 43 ?? ?? ?? ?? 02 28 07 D1 01 20 ?? ?? ?? ?? 08 B9 01 23 00 E0 00 23 23 74 25 68 64 68 28 46 07 4B 1B 68 98 47 20 46 A8 47 00 20 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 00 E0 38 68 BD E8 B8 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_8_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAA@XZ"
		size = 56
		refs = "0024 _free_base 0030 __imp_FreeLibrary 0034 __imp_CloseHandle"
		altNames = "?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAAXXZ"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2C 68 64 B1 A0 68 10 B1 08 4B 1B 68 98 47 E0 68 10 B1 04 4B 1B 68 98 47 20 46 ?? ?? ?? ?? 00 23 2B 60 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_10_0 {
	meta:
		name = "??Rthread_parameter_free_policy@?A0x4e93fcdd@@QAAXQAU__acrt_thread_parameter@@@Z"
		size = 52
		refs = "0022 _free_base 002c __imp_FreeLibrary 0030 __imp_CloseHandle"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 64 B1 A0 68 10 B1 07 4B 1B 68 98 47 E0 68 10 B1 04 4B 1B 68 98 47 20 46 ?? ?? ?? ?? BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_11_0 {
	meta:
		name = "?common_end_thread@@YAXI@Z"
		size = 104
		refs = "000a __acrt_getptd_noexit 002a __acrt_RoUninitialize 005c __imp_ExitThread 0060 __imp_FreeLibraryAndExitThread 0064 __imp_CloseHandle"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 18 B9 12 4B 28 46 1B 68 98 47 D0 F8 60 43 1C B9 0F 4B 28 46 1B 68 98 47 23 7C 0B B1 ?? ?? ?? ?? A0 68 B0 F1 FF 3F 03 D0 10 B1 0A 4B 1B 68 98 47 E0 68 B0 F1 FF 3F 04 D0 18 B1 05 4B 29 46 1B 68 98 47 02 4B 28 46 1B 68 98 47 FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_12_0 {
	meta:
		name = "?create_thread_parameter@@YAPAU__acrt_thread_parameter@@QAX0@Z"
		size = 112
		refs = "0010 _calloc_base 001c _free_base 0064 __imp_FreeLibrary 0068 __imp_CloseHandle 006c __imp_GetModuleHandleExW"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 0F 46 06 46 14 21 01 20 ?? ?? ?? ?? 05 46 04 46 00 20 00 95 ?? ?? ?? ?? 0D B9 00 25 0A E0 11 4B C5 E9 00 67 05 F1 0C 02 1B 68 31 46 04 20 98 47 00 24 00 94 74 B1 A0 68 18 B1 09 4B 1B 68 98 47 00 9C E0 68 18 B1 05 4B 1B 68 98 47 00 9C 20 46 ?? ?? ?? ?? 28 46 BD E8 FC 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_16_0 {
	meta:
		name = "?invoke_thread_procedure@@YAIQ6AIPAX@ZQAX@Z"
		size = 32
		refs = "001c __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 4B 0C 46 05 46 1B 68 98 47 20 46 A8 47 BD E8 30 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_17_0 {
	meta:
		name = "?invoke_thread_procedure@@YAIQ6AXPAX@ZQAX@Z"
		size = 32
		refs = "001c __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 4B 0C 46 05 46 1B 68 98 47 20 46 A8 47 00 20 BD E8 30 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_21_0 {
	meta:
		name = "_beginthread"
		size = 176
		refs = "000c _errno 0014 _invalid_parameter_noinfo 0020 ?create_thread_parameter@@YAPAU__acrt_thread_parameter@@QAX0@Z 004e __acrt_errno_map_os_error 0074 _free_base 0098 __imp_ResumeThread 009c __imp_FreeLibrary 00a0 __imp_CloseHandle 00a4 __imp_GetLastError 00a8 ??$thread_start@P6AXPAX@Z@@YAKQAX@Z 00ac __imp_CreateThread"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 2C E0 11 46 ?? ?? ?? ?? 05 46 02 95 A5 B1 00 23 03 93 03 AB 21 46 1E 4C 01 93 04 23 1B 4A 24 68 00 93 03 46 00 20 A0 47 04 46 DC B9 16 4B 1B 68 98 47 ?? ?? ?? ?? 02 9D 6F F0 00 04 75 B1 A8 68 18 B1 10 4B 1B 68 98 47 02 9D E8 68 18 B1 0C 4B 1B 68 98 47 02 9D 28 46 ?? ?? ?? ?? 20 46 04 B0 BD E8 30 88 05 4B AC 60 20 46 1B 68 98 47 10 F1 01 0F DB D0 00 25 02 95 E0 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_22_0 {
	meta:
		name = "_beginthreadex"
		size = 160
		refs = "000e _errno 0016 _invalid_parameter_noinfo 0022 ?create_thread_parameter@@YAPAU__acrt_thread_parameter@@QAX0@Z 004a __acrt_errno_map_os_error 0070 _free_base 008c __imp_FreeLibrary 0090 __imp_CloseHandle 0094 __imp_GetLastError 0098 ??$thread_start@P6AIPAX@Z@@YAKQAX@Z 009c __imp_CreateThread"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 3A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 24 2A E0 19 46 10 46 ?? ?? ?? ?? 02 90 90 B1 03 AB 01 93 08 9B 21 46 1A 4C 18 4A 00 93 24 68 03 46 28 46 A0 47 04 46 DC B9 13 4B 1B 68 98 47 ?? ?? ?? ?? 02 98 00 24 78 B1 83 68 23 B1 18 46 0D 4B 1B 68 98 47 02 98 C3 68 23 B1 18 46 08 4B 1B 68 98 47 02 98 ?? ?? ?? ?? 20 46 04 B0 BD E8 30 88 09 9A 0A B1 03 9B 13 60 00 20 02 90 E3 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "_realloc_base"
		size = 120
		refs = "0010 _malloc_base 001a _free_base 003e _query_new_mode 0046 _callnewh 0060 _errno 0070 __imp_HeapReAlloc 0074 __acrt_heap"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 06 46 0D 46 1E B9 08 46 ?? ?? ?? ?? 29 E0 1D B9 30 46 ?? ?? ?? ?? 23 E0 15 F1 20 0F 1C D8 DF F8 4C 80 11 4C 2B 46 D8 F8 00 00 24 68 32 46 00 21 A0 47 B0 B9 0C 4F ?? ?? ?? ?? 68 B1 28 46 ?? ?? ?? ?? 48 B1 D8 F8 00 00 3C 68 2B 46 32 46 00 21 A0 47 00 28 EF D0 04 E0 ?? ?? ?? ?? 0C 23 03 60 00 20 BD E8 F8 89 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_1_0 {
	meta:
		name = "__acrt_initialize_heap"
		size = 36
		refs = "001c __acrt_heap 0020 __imp_GetProcessHeap"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 1B 68 98 47 03 4B 18 60 08 B9 00 20 00 E0 01 20 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_2_0 {
	meta:
		name = "__acrt_uninitialize_heap"
		size = 24
		refs = "0014 __acrt_heap"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 00 22 01 20 1A 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "_LSinh"
		size = 384
		refs = "0014 _ldtest 00cc _ldexp 011e _fperrraise 0144 _LNan_C 0148 _LXbig_C 017c _LRteps_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 04 46 02 A8 ?? ?? ?? ?? 00 2C 6D DA 00 28 6B DA 9D ED 00 6B B5 EE C0 6B F1 EE 10 FA 05 D2 B1 EE 46 6B 01 24 8D ED 00 6B 00 E0 00 24 4D 4B 93 ED 00 0B B4 EE C0 6B F1 EE 10 FA 04 D2 9D ED 02 0B 26 EE 00 0B 4C E0 9F ED 45 0B B4 EE C0 6B F1 EE 10 FA 22 D2 9F ED 3F 1B 9F ED 3C 2B 9F ED 39 0B 26 EE 06 5B 9F ED 35 4B 9D ED 02 3B 05 EE 01 2B 25 EE 00 1B 9F ED 2F 0B 02 EE 05 4B 25 EE 06 2B 31 EE 40 1B B7 EE 00 0B 04 EE 02 6B 01 EE 05 0B 86 EE 00 0B 20 EE 03 0B 22 E0 25 4B 6F F0 00 01 93 ED 00 0B B4 EE C0 6B F1 EE 10 FA 11 D2 B7 EE 00 0B 68 46 ?? ?? ?? ?? 9D ED 00 2B B5 EE 00 0B 9D ED 02 1B 80 EE 02 0B 32 EE 40 0B 20 EE 01 0B 06 E0 9D ED 02 0B 68 46 ?? ?? ?? ?? 9D ED 00 0B 04 B3 B1 EE 40 0B 1D E0 02 2C 02 D1 9D ED 00 0B 18 E0 02 28 02 D1 9D ED 02 0B 13 E0 01 2C 08 D1 00 28 09 D1 01 20 ?? ?? ?? ?? 08 4B 93 ED 00 0B 08 E0 0C B9 01 28 F4 E7 9D ED 02 1B 9D ED 00 0B 20 EE 01 0B 05 B0 BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? 66 9F 96 B7 80 0F 95 3F 72 82 62 3E 65 B3 C2 3F A2 64 E9 3D 4F D7 24 3F 3B 78 52 CC 86 BE 74 3F DC 4A FD 3F A1 0F 0C 3F 0B 03 AD 7A EA 93 E1 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_660_0_0 {
	meta:
		name = "_Sinh"
		size = 384
		refs = "0014 _dtest 00cc _dexp 011e _fperrraise 0144 _Nan_C 0148 _Xbig_C 017c _Rteps_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 04 46 02 A8 ?? ?? ?? ?? 00 2C 6D DA 00 28 6B DA 9D ED 00 6B B5 EE C0 6B F1 EE 10 FA 05 D2 B1 EE 46 6B 01 24 8D ED 00 6B 00 E0 00 24 4D 4B 93 ED 00 0B B4 EE C0 6B F1 EE 10 FA 04 D2 9D ED 02 0B 26 EE 00 0B 4C E0 9F ED 45 0B B4 EE C0 6B F1 EE 10 FA 22 D2 9F ED 3F 1B 9F ED 3C 2B 9F ED 39 0B 26 EE 06 5B 9F ED 35 4B 9D ED 02 3B 05 EE 01 2B 25 EE 00 1B 9F ED 2F 0B 02 EE 05 4B 25 EE 06 2B 31 EE 40 1B B7 EE 00 0B 04 EE 02 6B 01 EE 05 0B 86 EE 00 0B 20 EE 03 0B 22 E0 25 4B 6F F0 00 01 93 ED 00 0B B4 EE C0 6B F1 EE 10 FA 11 D2 B7 EE 00 0B 68 46 ?? ?? ?? ?? 9D ED 00 2B B5 EE 00 0B 9D ED 02 1B 80 EE 02 0B 32 EE 40 0B 20 EE 01 0B 06 E0 9D ED 02 0B 68 46 ?? ?? ?? ?? 9D ED 00 0B 04 B3 B1 EE 40 0B 1D E0 02 2C 02 D1 9D ED 00 0B 18 E0 02 28 02 D1 9D ED 02 0B 13 E0 01 2C 08 D1 00 28 09 D1 01 20 ?? ?? ?? ?? 08 4B 93 ED 00 0B 08 E0 0C B9 01 28 F4 E7 9D ED 02 1B 9D ED 00 0B 20 EE 01 0B 05 B0 BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? 66 9F 96 B7 80 0F 95 3F 72 82 62 3E 65 B3 C2 3F A2 64 E9 3D 4F D7 24 3F 3B 78 52 CC 86 BE 74 3F DC 4A FD 3F A1 0F 0C 3F 0B 03 AD 7A EA 93 E1 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_2_0 {
	meta:
		name = "csinhl"
		size = 256
		refs = "0016 creall 002a cimagl 0034 _ldtest 0058 _fperrraise 0096 sin 00ac cos 00ca _LCosh 00e2 _LSinh 00ea _LCbuild 00f8 _LInf_C 00fc _LNan_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 00 2B ?? ?? ?? ?? 68 46 8D ED 02 0B ?? ?? ?? ?? 04 46 02 A8 ?? ?? ?? ?? 02 2C 06 D1 2D 4B 93 ED 00 0B 68 B9 9D ED 02 1B 4B E0 01 28 11 D1 01 20 ?? ?? ?? ?? 3C B1 01 2C 05 D0 26 4B 93 ED 00 0B B0 EE 40 1B 3D E0 23 4B 9D ED 00 0B 93 ED 00 1B 37 E0 02 28 EE D0 01 2C 1B D1 20 B9 9D ED 02 1B 9D ED 00 0B 2D E0 9D ED 02 8B B0 EE 48 0B ?? ?? ?? ?? 17 4B B0 EE 40 1B B0 EE 48 0B 93 ED 00 2B 21 EE 02 8B ?? ?? ?? ?? 9D ED 00 2B 20 EE 02 0B 15 E0 9D ED 02 0B ?? ?? ?? ?? B0 EE 40 1B 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 8B 9D ED 02 0B ?? ?? ?? ?? B0 EE 40 1B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B ?? ?? ?? ?? 09 B0 BD EC 02 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_660_1_0 {
	meta:
		name = "csinh"
		size = 256
		refs = "0016 creal 002a cimag 0034 _dtest 0058 _fperrraise 0096 sin 00ac cos 00ca _Cosh 00e2 _Sinh 00ea _Cbuild 00f8 _Inf_C 00fc _Nan_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 00 2B ?? ?? ?? ?? 68 46 8D ED 02 0B ?? ?? ?? ?? 04 46 02 A8 ?? ?? ?? ?? 02 2C 06 D1 2D 4B 93 ED 00 0B 68 B9 9D ED 02 1B 4B E0 01 28 11 D1 01 20 ?? ?? ?? ?? 3C B1 01 2C 05 D0 26 4B 93 ED 00 0B B0 EE 40 1B 3D E0 23 4B 9D ED 00 0B 93 ED 00 1B 37 E0 02 28 EE D0 01 2C 1B D1 20 B9 9D ED 02 1B 9D ED 00 0B 2D E0 9D ED 02 8B B0 EE 48 0B ?? ?? ?? ?? 17 4B B0 EE 40 1B B0 EE 48 0B 93 ED 00 2B 21 EE 02 8B ?? ?? ?? ?? 9D ED 00 2B 20 EE 02 0B 15 E0 9D ED 02 0B ?? ?? ?? ?? B0 EE 40 1B 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 8B 9D ED 02 0B ?? ?? ?? ?? B0 EE 40 1B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B ?? ?? ?? ?? 09 B0 BD EC 02 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "norml"
		size = 62
		refs = "0014 creall 0024 cimagl"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? 28 EE 08 1B 00 EE 00 1B B0 EE 41 0B 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_590_0_0 {
	meta:
		name = "norm"
		size = 62
		refs = "0014 creal 0024 cimag"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? 28 EE 08 1B 00 EE 00 1B B0 EE 41 0B 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "_fderfc"
		size = 120
		refs = "0050 _fdexp"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 9F ED 1A 2A DF ED 18 2A 9F ED 16 4A 9F ED 14 3A 20 EE 02 2A DF ED 11 3A DF ED 0F 4A 68 46 32 EE C2 2A DF ED 0C 2A 40 EE 03 3A 02 EE 00 4A 20 EE 00 2A 44 EE 00 4A 43 EE 80 2A F1 EE 42 0A 00 21 84 EE A2 0A CD ED 00 0A ?? ?? ?? ?? 9D ED 00 0A BD E8 0C 88 1A 8A 57 3F 66 C7 53 3F 6E 61 A3 3F 0B BE 3C 3F 8A EF C7 3E BB 89 5C 3B F6 AE 47 39 }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "erff"
		size = 248
		refs = "000e _fdtest 0090 _fderfc 00d4 _fderf_one 00f4 _fderf_small"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0A ?? ?? ?? ?? 00 28 5A D0 01 28 4D D0 02 28 56 D0 35 4B DD ED 00 3A 93 ED 00 0A F0 EE E3 0A F4 EE C0 0A F1 EE 10 FA 22 D2 DF ED 2E 0A DF ED 2C 2A 9F ED 2A 0A 9F ED 28 1A 23 EE A3 3A DF ED 25 1A 9F ED 23 2A 43 EE 20 2A 03 EE 00 1A DF ED 1F 0A 42 EE 83 1A 01 EE 03 2A B7 EE 00 0A 41 EE 83 0A 02 EE 03 0A 80 EE 80 0A 20 EE 23 0A 29 E0 15 4B 93 ED 00 2A F4 EE C2 0A F1 EE 10 FA 0A D2 B0 EE 60 0A ?? ?? ?? ?? F7 EE 00 0A DD ED 00 3A 30 EE C0 0A 01 E0 B7 EE 00 0A F5 EE C0 3A F1 EE 10 FA 0F D2 B1 EE 40 0A 0C E0 BD F8 02 30 13 F4 00 4F 02 D0 BF EE 00 0A 04 E0 B7 EE 00 0A 01 E0 9D ED 00 0A BD E8 0C 88 ?? ?? ?? ?? BB 6E 90 3F DE 40 E6 3E EE 78 06 3E 19 A2 A7 3D 1F 7F D0 3B A6 AB 13 3D C7 0D 89 39 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "asinhf"
		size = 148
		refs = "000e _fdtest 006c log1pf 0076 logf 0090 _FEps_C"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 68 46 8D ED 00 0A ?? ?? ?? ?? 02 28 02 D8 9D ED 00 0A 35 E0 DD ED 00 1A F5 EE C0 1A F1 EE 10 FA 05 D2 F1 EE 61 1A 01 24 CD ED 00 1A 00 E0 00 24 15 4B F0 EE 00 0A 93 ED 00 0A 80 EE 80 0A F4 EE C0 1A F1 EE 10 FA 10 D2 21 EE A1 1A F7 EE 00 0A 31 EE 20 0A B1 EE C0 0A 30 EE 20 0A 81 EE 00 0A 30 EE 21 0A ?? ?? ?? ?? 07 E0 B0 EE 61 0A ?? ?? ?? ?? DF ED 04 0A 30 EE 20 0A 0C B1 B1 EE 40 0A BD E8 18 88 18 72 31 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "log2"
		size = 608
		refs = "002e _handle_nan 005e _handle_error 01f0 ?ln_tail_table@?1??log2@@9@9 01f4 ?ln_lead_table@?1??log2@@9@9 024c ??_C@_04KGLCPMCP@log2?$AA@"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 2D ED 08 8B 85 B0 93 4A 54 EC 10 5B B0 EE 40 4B 04 EA 02 03 93 42 21 D1 23 46 6F F3 1F 53 2B 43 06 D0 28 46 21 46 ?? ?? ?? ?? B0 EE 40 4B CC E0 14 F0 00 4F 00 F0 C9 80 21 22 02 92 01 23 08 22 03 93 00 93 82 4B 01 92 9F ED 7F 1B 7D 48 00 22 B0 EE 44 0B 1A 21 ?? ?? ?? ?? E6 E7 4F F0 00 42 24 EA 02 03 2B 43 09 D1 01 23 03 93 22 23 02 93 04 23 01 93 02 23 00 93 71 4B E5 E7 14 42 DB D1 6E 4B E2 18 6C 4B 9A 42 3B D8 00 D3 CD BB B7 EE 00 0B B0 EE 00 1B 34 EE 40 9B 9F ED 65 4B 9F ED 62 6B 39 EE 01 0B 9F ED 5E 7B 9F ED 5B 8B 89 EE 00 0B 9F ED 4B AB 9F ED 48 BB 52 EC 19 3B 20 EE 09 5B 30 EE 00 0B 00 21 20 EE 00 2B 42 EC 13 1B 02 EE 04 6B 22 EE 00 0B 06 EE 02 7B 39 EE 43 1B 23 EE 0A 4B 07 EE 02 8B 28 EE 00 0B 30 EE 45 0B 30 EE 01 0B 00 EE 0A 4B 00 EE 0B 4B 03 EE 0B 4B 63 E0 B4 F5 80 1F 0C D8 0B D2 44 F0 74 73 9F ED 40 1B 43 EC 10 5B 3C 26 30 EE 41 0B 54 EC 10 5B 00 E0 00 26 A3 0B 03 F0 3F 03 62 0B 43 F0 40 01 02 F0 01 03 C8 18 9F ED 34 1B 00 EE 10 0A 22 46 40 F2 FE 33 B8 EE C0 0B 63 F3 1F 52 B6 EE 00 2B 20 EE 01 1B 42 EC 10 5B 9F ED 29 3B 9F ED 26 6B 9F ED 23 8B 21 4B 20 4A 9F ED 1D AB 30 EE 41 0B 03 EB C0 01 C4 F3 0A 53 00 EE 02 1B 9B 1B A3 F2 FF 33 80 EE 01 7B 02 EB C0 02 11 ED 80 5B 00 EE 10 3A 27 EE 07 1B 12 ED 80 4B B8 EE C0 2B 01 EE 03 6B 25 EE 0A 3B 9F ED 0C BB 06 EE 01 8B 05 EE 0B 2B 28 EE 01 1B 01 EE 07 7B 37 EE 04 0B 00 EE 0A 3B 00 EE 0B 3B 32 EE 03 4B B0 EE 44 0B 05 B0 BD EC 08 8B BD E8 70 88 00 00 00 00 44 15 F7 3F BE BB F0 17 5C 29 CB 3E ?? ?? ?? ?? ?? ?? ?? ?? 57 55 55 55 55 55 B5 3F DE 5E 86 99 99 99 89 3F 41 47 D9 3B 42 49 62 3F 00 00 00 00 00 00 80 3F 00 00 00 00 00 00 D0 03 E6 54 55 55 55 55 B5 3F D4 C6 BA 99 99 99 89 3F 9F 51 F1 07 23 49 62 3F F0 FF 5D C8 34 80 3C 3F 82 F8 02 00 56 F0 11 C0 00 00 F0 FF ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F8 FF 00 00 F0 7F }
	condition:
		$1
}

rule file_170_3_0 {
	meta:
		name = "??$common_popen@D@@YAPAU_iobuf@@QBD0@Z"
		size = 310
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 00b6 _pipe 00e4 __acrt_lock 00f8 ??$common_popen_nolock@D@@YAPAU_iobuf@@QBD0HAAY01H@Z 011c _close 0126 __acrt_unlock"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 88 B0 6F 46 06 46 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 23 85 E0 00 29 F5 D0 00 23 BB 80 BB 71 BC 88 3C 80 BD 79 00 E0 49 1C 91 F9 00 30 20 2B FA D0 5B B2 77 2B 09 D0 72 2B 07 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 3C 80 1A E0 3B 70 11 F9 01 3F 02 E0 49 1C 91 F9 00 30 20 2B FA D0 91 F9 00 30 53 B1 74 2B 08 D0 62 2B 06 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 E0 7B 70 3B 88 3B 80 1C 46 BC 80 BD 71 97 F9 00 30 00 2B C1 D0 80 22 97 F9 01 30 74 2B 01 D1 4F F4 81 42 62 2B 01 D1 42 F4 00 42 17 F1 18 00 4F F4 80 61 ?? ?? ?? ?? 10 F1 01 0F AD D0 97 F9 04 30 77 2B BB 69 FA 69 02 D1 00 24 3B 61 01 E0 01 24 3A 61 0C B9 7A 61 00 E0 7B 61 00 23 BB 60 0A 20 ?? ?? ?? ?? ?? ?? ?? ?? 05 68 17 F1 10 03 39 1D 22 46 30 46 ?? ?? ?? ?? 04 46 BC 60 ?? ?? ?? ?? 05 60 6C B9 17 F1 18 05 17 F1 10 04 AC 42 07 D0 20 68 10 F1 01 0F 01 D0 ?? ?? ?? ?? 24 1D F5 E7 0A 20 ?? ?? ?? ?? BB 68 7B 60 78 68 08 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_170_5_0 {
	meta:
		name = "??$common_popen@_W@@YAPAU_iobuf@@QB_W0@Z"
		size = 300
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 00ac _pipe 00d8 __acrt_lock 00ec ??$common_popen_nolock@_W@@YAPAU_iobuf@@QB_W0HAAY01H@Z 010e _close 0118 __acrt_unlock 0124 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? 88 B0 6F 46 80 46 38 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 23 7C E0 00 29 F5 D0 00 23 BB 61 BB 83 1D 46 3D 60 BE 8B 00 E0 89 1C 0B 88 20 2B FB D0 9C B2 77 2C 0A D0 72 2C 08 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 7B 88 3C 88 17 E0 3C 80 31 F8 02 3F 01 E0 89 1C 0B 88 20 2B FB D0 0B 88 5B B1 74 2B 09 D0 62 2B 07 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 7B 88 00 E0 7B 80 3D 68 BD 61 BE 83 00 2C C6 D0 80 22 74 2B 01 D1 4F F4 81 42 62 2B 01 D1 42 F4 00 42 17 F1 10 00 4F F4 80 61 ?? ?? ?? ?? 10 F1 01 0F B4 D0 3B 8B 77 2B 3B 69 7A 69 02 D1 00 24 3B 60 01 E0 01 24 3A 60 0C B9 7A 60 00 E0 7B 60 00 23 BB 60 0A 20 ?? ?? ?? ?? ?? ?? ?? ?? 05 68 3B 46 17 F1 18 01 22 46 40 46 ?? ?? ?? ?? 04 46 BC 60 ?? ?? ?? ?? 05 60 64 B9 17 F1 08 05 3C 46 AC 42 07 D0 20 68 10 F1 01 0F 01 D0 ?? ?? ?? ?? 24 1D F5 E7 0A 20 ?? ?? ?? ?? BB 68 3B 60 38 68 08 B0 ?? ?? ?? ?? BD E8 F0 89 }
	condition:
		$1
}

rule file_170_7_0 {
	meta:
		name = "??$common_popen_nolock@D@@YAPAU_iobuf@@QBD0HAAY01H@Z"
		size = 576
		refs = "0058 _close 0066 _fdopen 0076 ?idtab@@YAPAUprocess_handle_pair@?A0xe43b7539@@QAU_iobuf@@@Z 008e _dupenv_s 00aa memset 00d0 strlen 00f0 _calloc_base 00fe strcpy_s 010e strcat_s 0126 ??$get_executable_path@D@@YAPBDQBD@Z 01a4 _free_base 01c8 fclose 01f0 _invoke_watson 0220 __imp_CloseHandle 0224 __imp_CreateProcessA 0228 ?slash_c@?1???$common_popen_nolock@D@@YAPAU_iobuf@@QBD0HAAY01H@Z@4QBDB 022c __pioinfo 0230 ?default_cmd_exe@?1???$common_popen_nolock@D@@YAPAU_iobuf@@QBD0HAAY01H@Z@4QBDB 0234 ?comspec_name@?1???$get_comspec@D@@YAPBDXZ@4QBDB 0238 __imp_DuplicateHandle 023c __imp_GetCurrentProcess"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B A5 B0 8C 4C 1F 46 92 46 24 68 88 46 09 90 A0 47 3C 68 84 49 6F F0 00 03 A6 11 04 F0 3F 04 04 EB 44 05 51 F8 26 40 06 93 02 23 04 EB 05 14 A1 69 7F 4C 02 93 01 23 24 68 01 93 4F F0 00 09 06 AB 02 46 CD F8 00 90 A0 47 08 B9 00 24 BA E0 38 68 ?? ?? ?? ?? 78 68 6F F0 00 03 41 46 3B 60 ?? ?? ?? ?? 07 46 07 97 0F B9 00 24 A7 E0 00 20 ?? ?? ?? ?? 06 46 0A 96 0E B9 00 24 9C E0 6B 4A 00 23 08 A8 00 21 08 93 ?? ?? ?? ?? 00 28 4E D0 16 28 00 F0 A4 80 4F F0 00 09 DF F8 8C 81 15 A8 40 22 00 21 ?? ?? ?? ?? 44 23 14 93 4F F4 80 73 1F 93 5C 4B BA F1 00 0F 1A 68 3F D1 06 9B 22 93 93 6C 23 93 93 6F 40 46 24 93 ?? ?? ?? ?? 05 46 54 48 ?? ?? ?? ?? DD F8 24 A0 04 46 50 46 ?? ?? ?? ?? 2B 19 1C 18 60 1C 01 21 ?? ?? ?? ?? 05 46 00 2D 58 D0 42 46 61 1C ?? ?? ?? ?? 00 28 40 F0 84 80 47 4A 61 1C 28 46 ?? ?? ?? ?? 00 28 75 D1 52 46 61 1C 28 46 ?? ?? ?? ?? 00 28 67 D1 40 46 ?? ?? ?? ?? F8 B3 40 45 0F D0 07 46 0E E0 DD F8 20 90 B9 F1 00 0F B0 D0 C8 46 B0 E7 93 69 BA F1 01 0F 22 93 BC D1 06 9B BB E7 00 27 00 23 CD E9 0C 33 CD E9 0E 33 CD E9 10 33 CD E9 12 33 10 AB 05 93 14 AB 2E 4C 04 93 00 23 03 93 02 93 01 93 24 68 01 23 00 93 00 23 00 22 29 46 A0 47 10 B9 0A 9E 00 24 0A E0 07 9C 00 23 07 93 23 4B 11 98 1B 68 98 47 10 9B C6 E9 00 43 00 26 38 46 ?? ?? ?? ?? 07 9F 00 E0 00 24 28 46 ?? ?? ?? ?? 48 46 ?? ?? ?? ?? 4F F0 00 09 0E B1 C6 E9 00 99 17 B1 38 46 ?? ?? ?? ?? 06 98 6F F0 00 03 98 42 02 D0 12 4B 1B 68 98 47 20 46 25 B0 BD E8 F0 8F 00 23 00 22 00 21 00 20 CD F8 00 90 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_8_0 {
	meta:
		name = "??$common_popen_nolock@_W@@YAPAU_iobuf@@QB_W0HAAY01H@Z"
		size = 576
		refs = "0058 _close 0066 _wfdopen 0076 ?idtab@@YAPAUprocess_handle_pair@?A0xe43b7539@@QAU_iobuf@@@Z 008e _wdupenv_s 00aa memset 00d0 wcslen 00f0 _calloc_base 00fe wcscpy_s 010e wcscat_s 0126 ??$get_executable_path@_W@@YAPB_WQB_W@Z 01a4 _free_base 01c8 fclose 01f0 _invoke_watson 0220 __imp_CloseHandle 0224 __imp_CreateProcessW 0228 ?slash_c@?1???$common_popen_nolock@_W@@YAPAU_iobuf@@QB_W0HAAY01H@Z@4QB_WB 022c __pioinfo 0230 ?default_cmd_exe@?1???$common_popen_nolock@_W@@YAPAU_iobuf@@QB_W0HAAY01H@Z@4QB_WB 0234 ?comspec_name@?1???$get_comspec@_W@@YAPB_WXZ@4QB_WB 0238 __imp_DuplicateHandle 023c __imp_GetCurrentProcess"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B A5 B0 8C 4C 1F 46 92 46 24 68 88 46 09 90 A0 47 3C 68 84 49 6F F0 00 03 A6 11 04 F0 3F 04 04 EB 44 05 51 F8 26 40 06 93 02 23 04 EB 05 14 A1 69 7F 4C 02 93 01 23 24 68 01 93 4F F0 00 09 06 AB 02 46 CD F8 00 90 A0 47 08 B9 00 24 BA E0 38 68 ?? ?? ?? ?? 78 68 6F F0 00 03 41 46 3B 60 ?? ?? ?? ?? 07 46 07 97 0F B9 00 24 A7 E0 00 20 ?? ?? ?? ?? 06 46 0A 96 0E B9 00 24 9C E0 6B 4A 00 23 08 A8 00 21 08 93 ?? ?? ?? ?? 00 28 4E D0 16 28 00 F0 A4 80 4F F0 00 09 DF F8 8C 81 15 A8 40 22 00 21 ?? ?? ?? ?? 44 23 14 93 4F F4 80 73 1F 93 5C 4B BA F1 00 0F 1A 68 3F D1 06 9B 22 93 93 6C 23 93 93 6F 40 46 24 93 ?? ?? ?? ?? 05 46 54 48 ?? ?? ?? ?? DD F8 24 A0 04 46 50 46 ?? ?? ?? ?? 2B 19 1C 18 60 1C 02 21 ?? ?? ?? ?? 05 46 00 2D 58 D0 42 46 61 1C ?? ?? ?? ?? 00 28 40 F0 84 80 47 4A 61 1C 28 46 ?? ?? ?? ?? 00 28 75 D1 52 46 61 1C 28 46 ?? ?? ?? ?? 00 28 67 D1 40 46 ?? ?? ?? ?? F8 B3 40 45 0F D0 07 46 0E E0 DD F8 20 90 B9 F1 00 0F B0 D0 C8 46 B0 E7 93 69 BA F1 01 0F 22 93 BC D1 06 9B BB E7 00 27 00 23 CD E9 0C 33 CD E9 0E 33 CD E9 10 33 CD E9 12 33 10 AB 05 93 14 AB 2E 4C 04 93 00 23 03 93 02 93 01 93 24 68 01 23 00 93 00 23 00 22 29 46 A0 47 10 B9 0A 9E 00 24 0A E0 07 9C 00 23 07 93 23 4B 11 98 1B 68 98 47 10 9B C6 E9 00 43 00 26 38 46 ?? ?? ?? ?? 07 9F 00 E0 00 24 28 46 ?? ?? ?? ?? 48 46 ?? ?? ?? ?? 4F F0 00 09 0E B1 C6 E9 00 99 17 B1 38 46 ?? ?? ?? ?? 06 98 6F F0 00 03 98 42 02 D0 12 4B 1B 68 98 47 20 46 25 B0 BD E8 F0 8F 00 23 00 22 00 21 00 20 CD F8 00 90 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_9_0 {
	meta:
		name = "??$convert_popen_type_to_fdopen_mode@D@@YA?AU?$fdopen_mode@D@?A0xe43b7539@@QBD@Z"
		size = 130
		refs = "0038 _errno 0040 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 00 23 AD F8 04 30 8D F8 06 30 BD F8 04 30 AD F8 00 30 9D F8 06 30 8D F8 02 30 00 E0 40 1C 90 F9 00 30 20 2B FA D0 5B B2 77 2B 09 D0 72 2B 07 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 01 98 1A E0 8D F8 00 30 10 F9 01 3F 02 E0 40 1C 90 F9 00 30 20 2B FA D0 90 F9 00 30 53 B1 74 2B 08 D0 62 2B 06 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 01 E0 8D F8 01 30 00 98 BD E8 0C 88 }
	condition:
		$1
}

rule file_170_10_0 {
	meta:
		name = "??$convert_popen_type_to_fdopen_mode@_W@@YA?AU?$fdopen_mode@_W@?A0xe43b7539@@QB_W@Z"
		size = 96
		refs = "002e _errno 0036 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 04 46 00 23 00 93 AD F8 04 30 23 60 BD F8 04 30 A3 80 00 E0 89 1C 0B 88 20 2B FB D0 9B B2 77 2B 08 D0 72 2B 06 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 0E E0 23 80 31 F8 02 3F 01 E0 89 1C 0B 88 20 2B FB D0 0B 88 1B B1 74 2B 01 D0 62 2B EA D1 63 80 20 46 BD E8 1E 88 }
	condition:
		$1
}

rule file_170_11_0 {
	meta:
		name = "??$create_process@ABQBDPAD$$T$$THH$$T$$TPAU_STARTUPINFOA@@PAU_PROCESS_INFORMATION@@@?$__crt_char_traits@D@@SAHABQBD$$QAPAD$$QA$$T2$$QAH322$$QAPAU_STARTUPINFOA@@$$QAPAU_PROCESS_INFORMATION@@@Z"
		size = 72
		refs = "0044 __imp_CreateProcessA"
		altNames = "??$create_process@PADPAD$$T$$THAAKPAD$$TPAU_STARTUPINFOA@@PAU_PROCESS_INFORMATION@@@?$__crt_char_traits@D@@SAH$$QAPAD0$$QA$$T1$$QAHAAK01$$QAPAU_STARTUPINFOA@@$$QAPAU_PROCESS_INFORMATION@@@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 87 B0 0F 9C 1B 68 12 68 24 68 09 68 00 68 05 94 0E 9C 24 68 04 94 0D 9C 24 68 03 94 0C 9C 24 68 02 94 0B 9C 24 68 01 94 0A 9C 24 68 00 94 03 4C 24 68 A0 47 07 B0 BD E8 10 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_12_0 {
	meta:
		name = "??$create_process@ABQB_WPA_W$$T$$THH$$T$$TPAU_STARTUPINFOW@@PAU_PROCESS_INFORMATION@@@?$__crt_char_traits@_W@@SAHABQB_W$$QAPA_W$$QA$$T2$$QAH322$$QAPAU_STARTUPINFOW@@$$QAPAU_PROCESS_INFORMATION@@@Z"
		size = 72
		refs = "0044 __imp_CreateProcessW"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 87 B0 0F 9C 1B 68 12 68 24 68 09 68 00 68 05 94 0E 9C 24 68 04 94 0D 9C 24 68 03 94 0C 9C 24 68 02 94 0B 9C 24 68 01 94 0A 9C 24 68 00 94 03 4C 24 68 A0 47 07 B0 BD E8 10 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_9_0 {
	meta:
		name = "??$create_process@PA_WPA_W$$T$$THAAKPA_W$$TPAU_STARTUPINFOW@@PAU_PROCESS_INFORMATION@@@?$__crt_char_traits@_W@@SAH$$QAPA_W0$$QA$$T1$$QAHAAK01$$QAPAU_STARTUPINFOW@@$$QAPAU_PROCESS_INFORMATION@@@Z"
		size = 72
		refs = "0044 __imp_CreateProcessW"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 87 B0 0F 9C 1B 68 12 68 24 68 09 68 00 68 05 94 0E 9C 24 68 04 94 0D 9C 24 68 03 94 0C 9C 24 68 02 94 0B 9C 24 68 01 94 0A 9C 24 68 00 94 03 4C 24 68 A0 47 07 B0 BD E8 10 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_13_0 {
	meta:
		name = "??$get_comspec@D@@YAPBDXZ"
		size = 60
		refs = "0012 _dupenv_s 0032 _invoke_watson 0038 ?comspec_name@?1???$get_comspec@D@@YAPBDXZ@4QBDB"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 0B 4A 00 23 02 A8 00 21 02 93 ?? ?? ?? ?? 18 B1 16 28 05 D0 00 20 00 E0 02 98 04 B0 BD E8 00 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_14_0 {
	meta:
		name = "??$get_comspec@_W@@YAPB_WXZ"
		size = 60
		refs = "0012 _wdupenv_s 0032 _invoke_watson 0038 ?comspec_name@?1???$get_comspec@_W@@YAPB_WXZ@4QB_WB"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 0B 4A 00 23 02 A8 00 21 02 93 ?? ?? ?? ?? 18 B1 16 28 05 D0 00 20 00 E0 02 98 04 B0 BD E8 00 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_17_0 {
	meta:
		name = "??$get_path@D@@YAPBDXZ"
		size = 60
		refs = "0012 _dupenv_s 0032 _invoke_watson 0038 ?path_name@?1???$get_path@D@@YAPBDXZ@4QBDB"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 0B 4A 00 23 02 A8 00 21 02 93 ?? ?? ?? ?? 18 B1 16 28 05 D0 00 20 00 E0 02 98 04 B0 BD E8 00 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_18_2 {
	meta:
		name = "??$get_path@_W@@YAPB_WXZ"
		size = 60
		refs = "0012 _wdupenv_s 0032 _invoke_watson 0038 ?path_name@?1???$get_path@_W@@YAPB_WXZ@4QB_WB"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 0B 4A 00 23 02 A8 00 21 02 93 ?? ?? ?? ?? 18 B1 16 28 05 D0 00 20 00 E0 02 98 04 B0 BD E8 00 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_12_2 {
	meta:
		name = "??$get_tmp_directory@D@@YAPBDXZ"
		size = 60
		refs = "0012 _dupenv_s 0032 _invoke_watson 0038 ?tmp_name@?1???$get_tmp_directory@D@@YAPBDXZ@4QBDB"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 0B 4A 00 23 02 A8 00 21 02 93 ?? ?? ?? ?? 18 B1 16 28 05 D0 00 20 00 E0 02 98 04 B0 BD E8 00 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_13_2 {
	meta:
		name = "??$get_tmp_directory@_W@@YAPB_WXZ"
		size = 60
		refs = "0012 _wdupenv_s 0032 _invoke_watson 0038 ?tmp_name@?1???$get_tmp_directory@_W@@YAPB_WXZ@4QB_WB"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 0B 4A 00 23 02 A8 00 21 02 93 ?? ?? ?? ?? 18 B1 16 28 05 D0 00 20 00 E0 02 98 04 B0 BD E8 00 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_15_0 {
	meta:
		name = "??$get_executable_path@D@@YAPBDQBD@Z"
		size = 276
		refs = "000c _access_s 001c _calloc_base 0034 _dupenv_s 004a strlen 0060 _mbsrchr 0080 strcat_s 00b8 __acrt_getpath 00c6 _free_base 00e8 _invoke_watson 010c ?backslash@?L@???$get_executable_path@D@@YAPBDQBD@Z@4QBDB 0110 ?path_name@?1???$get_path@D@@YAPBDXZ@4QBDB"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 00 21 05 46 ?? ?? ?? ?? 00 28 5D D0 4F F4 82 79 48 46 01 21 ?? ?? ?? ?? 06 46 80 46 0E B9 00 25 4F E0 39 4A 00 23 02 A8 00 21 02 93 ?? ?? ?? ?? 18 B1 16 28 4F D0 00 27 00 E0 02 9F 38 46 34 E0 30 46 ?? ?? ?? ?? 84 19 A6 42 18 D0 14 F9 01 3C 5C 2B 0A D1 5C 21 30 46 ?? ?? ?? ?? 63 1E 83 42 18 BF 01 23 04 D1 00 23 02 E0 2F 2B 07 D0 01 23 2B B1 24 4A 49 46 30 46 ?? ?? ?? ?? 90 BB 30 46 ?? ?? ?? ?? 04 46 28 46 ?? ?? ?? ?? 23 18 4B 45 13 D2 2A 46 49 46 30 46 ?? ?? ?? ?? 48 BB 00 21 30 46 ?? ?? ?? ?? 90 B1 50 46 40 F2 03 12 31 46 ?? ?? ?? ?? 82 46 00 28 C2 D1 00 25 38 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 28 46 BD E8 FE 8F 4F F0 00 08 35 46 F2 E7 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_16_0 {
	meta:
		name = "??$get_executable_path@_W@@YAPB_WQB_W@Z"
		size = 252
		refs = "000c _waccess_s 001c _calloc_base 0034 _wdupenv_s 004a wcslen 0068 wcscat_s 00a0 __acrt_wgetpath 00ae _free_base 00d0 _invoke_watson 00f4 ?backslash@?L@???$get_executable_path@_W@@YAPB_WQB_W@Z@4QB_WB 00f8 ?path_name@?1???$get_path@_W@@YAPB_WXZ@4QB_WB"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 00 21 05 46 ?? ?? ?? ?? 00 28 51 D0 4F F4 82 79 48 46 02 21 ?? ?? ?? ?? 06 46 80 46 0E B9 00 25 43 E0 33 4A 00 23 02 A8 00 21 02 93 ?? ?? ?? ?? 18 B1 16 28 43 D0 00 27 00 E0 02 9F 38 46 28 E0 30 46 ?? ?? ?? ?? 06 EB 40 03 9E 42 0B D0 33 F8 02 3C 5C 2B 07 D0 2F 2B 05 D0 24 4A 49 46 30 46 ?? ?? ?? ?? 90 BB 30 46 ?? ?? ?? ?? 04 46 28 46 ?? ?? ?? ?? 23 18 4B 45 13 D2 2A 46 49 46 30 46 ?? ?? ?? ?? 48 BB 00 21 30 46 ?? ?? ?? ?? 90 B1 50 46 40 F2 03 12 31 46 ?? ?? ?? ?? 82 46 00 28 CE D1 00 25 38 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 28 46 BD E8 FE 8F 4F F0 00 08 35 46 F2 E7 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_19_0 {
	meta:
		name = "??$taccess_s@ABQBDH@?$__crt_char_traits@D@@SAHABQBD$$QAH@Z"
		size = 18
		refs = "000e _access_s"
		altNames = "??$taccess_s@AAPADH@?$__crt_char_traits@D@@SAHAAPAD$$QAH@Z ??$taccess_s@AAPBDH@?$__crt_char_traits@D@@SAHAAPBD$$QAH@Z ??$taccess_s@ABQADH@?$__crt_char_traits@D@@SAHABQAD$$QAH@Z ??$taccess_s@PADH@?$__crt_char_traits@D@@SAH$$QAPAD$$QAH@Z ??$taccess_s@PBDH@?$__crt_char_traits@D@@SAH$$QAPBD$$QAH@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_607_6_3 {
	meta:
		name = "??$futime@AAHABQAU__utimbuf32@@@?$__crt_integer_traits@J@@SAHAAHABQAU__utimbuf32@@@Z"
		size = 18
		refs = "000e ??$common_futime@JU__utimbuf32@@@@YAHHPAU__utimbuf32@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_607_7_3 {
	meta:
		name = "??$futime@AAHABQAU__utimbuf64@@@?$__crt_integer_traits@_J@@SAHAAHABQAU__utimbuf64@@@Z"
		size = 18
		refs = "000e ??$common_futime@_JU__utimbuf64@@@@YAHHPAU__utimbuf64@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_10_2 {
	meta:
		name = "??$get_temp_path@KABQAD@?$__crt_char_traits@D@@SAK$$QAKABQAD@Z"
		size = 18
		refs = "000e __acrt_GetTempPathA"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_4_3 {
	meta:
		name = "??$gmtime_s@ABQAUtm@@ABQBJ@?$__crt_integer_traits@J@@SAHABQAUtm@@ABQBJ@Z"
		size = 18
		refs = "000e _gmtime32_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_5_3 {
	meta:
		name = "??$gmtime_s@ABQAUtm@@ABQB_J@?$__crt_integer_traits@_J@@SAHABQAUtm@@ABQB_J@Z"
		size = 18
		refs = "000e _gmtime64_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_6_4 {
	meta:
		name = "??$gmtime_s@ABQAUtm@@PAJ@?$__crt_integer_traits@J@@SAHABQAUtm@@$$QAPAJ@Z"
		size = 18
		refs = "000e _gmtime32_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_7_3 {
	meta:
		name = "??$gmtime_s@ABQAUtm@@PA_J@?$__crt_integer_traits@_J@@SAHABQAUtm@@$$QAPA_J@Z"
		size = 18
		refs = "000e _gmtime64_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_634_6_3 {
	meta:
		name = "??$gmtime_s@PAUtm@@PAJ@?$__crt_integer_traits@J@@SAH$$QAPAUtm@@$$QAPAJ@Z"
		size = 18
		refs = "000e _gmtime32_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_634_7_2 {
	meta:
		name = "??$gmtime_s@PAUtm@@PA_J@?$__crt_integer_traits@_J@@SAH$$QAPAUtm@@$$QAPA_J@Z"
		size = 18
		refs = "000e _gmtime64_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_8_2 {
	meta:
		name = "??$localtime_s@ABQAUtm@@ABQBJ@?$__crt_integer_traits@J@@SAHABQAUtm@@ABQBJ@Z"
		size = 18
		refs = "000e ??$common_localtime_s@J@@YAHQAUtm@@QBJ@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_9_2 {
	meta:
		name = "??$localtime_s@ABQAUtm@@ABQB_J@?$__crt_integer_traits@_J@@SAHABQAUtm@@ABQB_J@Z"
		size = 18
		refs = "000e ??$common_localtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_406_8_0 {
	meta:
		name = "??$localtime_s@PAUtm@@ABQBJ@?$__crt_integer_traits@J@@SAH$$QAPAUtm@@ABQBJ@Z"
		size = 18
		refs = "000e _localtime32_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_406_9_3 {
	meta:
		name = "??$localtime_s@PAUtm@@ABQB_J@?$__crt_integer_traits@_J@@SAH$$QAPAUtm@@ABQB_J@Z"
		size = 18
		refs = "000e _localtime64_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_607_8_0 {
	meta:
		name = "??$localtime_s@PAUtm@@PAJ@?$__crt_integer_traits@J@@SAH$$QAPAUtm@@$$QAPAJ@Z"
		size = 18
		refs = "000e _localtime32_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_634_9_3 {
	meta:
		name = "??$localtime_s@PAUtm@@PA_J@?$__crt_integer_traits@_J@@SAH$$QAPAUtm@@$$QAPA_J@Z"
		size = 18
		refs = "000e _localtime64_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_20_3 {
	meta:
		name = "??$set_variable_in_environment_nolock@PADH@?$__crt_char_traits@D@@SAH$$QAPAD$$QAH@Z"
		size = 18
		refs = "000e __dcrt_set_variable_in_narrow_environment_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_21_4 {
	meta:
		name = "??$set_variable_in_environment_nolock@PA_WH@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAH@Z"
		size = 18
		refs = "000e __dcrt_set_variable_in_wide_environment_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_5_2 {
	meta:
		name = "??$taccess_s@AAPA_WH@?$__crt_char_traits@_W@@SAHAAPA_W$$QAH@Z"
		size = 18
		refs = "000e _waccess_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_15_2 {
	meta:
		name = "??$taccess_s@AAPB_WH@?$__crt_char_traits@_W@@SAHAAPB_W$$QAH@Z"
		size = 18
		refs = "000e _waccess_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_17_2 {
	meta:
		name = "??$taccess_s@ABQA_WH@?$__crt_char_traits@_W@@SAHABQA_W$$QAH@Z"
		size = 18
		refs = "000e _waccess_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_19_2 {
	meta:
		name = "??$taccess_s@ABQB_WH@?$__crt_char_traits@_W@@SAHABQB_W$$QAH@Z"
		size = 18
		refs = "000e _waccess_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_22_4 {
	meta:
		name = "??$taccess_s@PA_WH@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAH@Z"
		size = 18
		refs = "000e _waccess_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_21_4 {
	meta:
		name = "??$taccess_s@PB_WH@?$__crt_char_traits@_W@@SAH$$QAPB_W$$QAH@Z"
		size = 18
		refs = "000e _waccess_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_6_3 {
	meta:
		name = "??$tcscat_s@AAPADABIAAY01$$CBD@?$__crt_char_traits@D@@SAHAAPADABIAAY01$$CBD@Z"
		size = 18
		refs = "000e strcat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_7_3 {
	meta:
		name = "??$tcscat_s@AAPADABIAAY02$$CBD@?$__crt_char_traits@D@@SAHAAPADABIAAY02$$CBD@Z"
		size = 18
		refs = "000e strcat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_4_2 {
	meta:
		name = "??$tcscat_s@AAPADHAAY01$$CBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHAAY01$$CBD@Z"
		size = 18
		refs = "000e strcat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_16_0 {
	meta:
		name = "??$tcscat_s@AAPA_WABIAAY01$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIAAY01$$CB_W@Z"
		size = 18
		refs = "000e wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_9_0 {
	meta:
		name = "??$tcscat_s@AAPA_WABIAAY02$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIAAY02$$CB_W@Z"
		size = 18
		refs = "000e wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_6_4 {
	meta:
		name = "??$tcscat_s@AAPA_WHAAY01$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHAAY01$$CB_W@Z"
		size = 18
		refs = "000e wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_10_4 {
	meta:
		name = "??$tcscat_s@ABQADABIAAY02$$CBD@?$__crt_char_traits@D@@SAHABQADABIAAY02$$CBD@Z"
		size = 18
		refs = "000e strcat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_11_4 {
	meta:
		name = "??$tcscat_s@ABQA_WABIAAY02$$CB_W@?$__crt_char_traits@_W@@SAHABQA_WABIAAY02$$CB_W@Z"
		size = 18
		refs = "000e wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_23_0 {
	meta:
		name = "??$tcscat_s@PADABIAAY01$$CBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAY01$$CBD@Z"
		size = 18
		refs = "000e strcat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_23_2 {
	meta:
		name = "??$tcscat_s@PADABIAAY04$$CBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAY04$$CBD@Z"
		size = 18
		refs = "000e strcat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_25_3 {
	meta:
		name = "??$tcscat_s@PADHAAY01$$CBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAHAAY01$$CBD@Z"
		size = 18
		refs = "000e strcat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_26_0 {
	meta:
		name = "??$tcscat_s@PA_WABIAAY01$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAY01$$CB_W@Z"
		size = 18
		refs = "000e wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_27_0 {
	meta:
		name = "??$tcscat_s@PA_WABIAAY04$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAY04$$CB_W@Z"
		size = 18
		refs = "000e wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_29_0 {
	meta:
		name = "??$tcscat_s@PA_WHAAY01$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAHAAY01$$CB_W@Z"
		size = 18
		refs = "000e wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_19_4 {
	meta:
		name = "??$tcscpy_s@AAPADABIAAY0L@$$CBD@?$__crt_char_traits@D@@SAHAAPADABIAAY0L@$$CBD@Z"
		size = 18
		refs = "000e strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_20_2 {
	meta:
		name = "??$tcscpy_s@AAPADHAAY04$$CBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHAAY04$$CBD@Z"
		size = 18
		refs = "000e strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_22_0 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIAAY0L@$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIAAY0L@$$CB_W@Z"
		size = 18
		refs = "000e wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_21_0 {
	meta:
		name = "??$tcscpy_s@AAPA_WHAAY04$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHAAY04$$CB_W@Z"
		size = 18
		refs = "000e wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_23_0 {
	meta:
		name = "??$tcscpy_s@PADABIAAY02$$CBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAY02$$CBD@Z"
		size = 18
		refs = "000e strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_25_3 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAY02$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAY02$$CB_W@Z"
		size = 18
		refs = "000e wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_8_4 {
	meta:
		name = "??$tcsnlen@ABQADABI@?$__crt_char_traits@D@@SAIABQADABI@Z"
		size = 18
		refs = "000e strnlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_9_3 {
	meta:
		name = "??$tcsnlen@ABQA_WABI@?$__crt_char_traits@_W@@SAIABQA_WABI@Z"
		size = 18
		refs = "000e wcsnlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_111_2 {
	meta:
		name = "??$tcsnlen@ABQBDABI@?$__crt_char_traits@D@@SAIABQBDABI@Z"
		size = 18
		refs = "000e strnlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_685_30_2 {
	meta:
		name = "??$tcsnlen@ABQBDH@?$__crt_char_traits@D@@SAIABQBD$$QAH@Z"
		size = 18
		refs = "000e strnlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_112_0 {
	meta:
		name = "??$tcsnlen@ABQB_WABI@?$__crt_char_traits@_W@@SAIABQB_WABI@Z"
		size = 18
		refs = "000e wcsnlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_25_4 {
	meta:
		name = "??$tcsnlen@ABQB_WH@?$__crt_char_traits@_W@@SAIABQB_W$$QAH@Z"
		size = 18
		refs = "000e wcsnlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_26_2 {
	meta:
		name = "??$tcsnlen@PBDH@?$__crt_char_traits@D@@SAI$$QAPBD$$QAH@Z"
		size = 18
		refs = "000e strnlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_27_4 {
	meta:
		name = "??$tcsnlen@PB_WH@?$__crt_char_traits@_W@@SAI$$QAPB_W$$QAH@Z"
		size = 18
		refs = "000e wcsnlen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_34_2 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY03$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY03$$CBD@Z"
		size = 18
		refs = "000e _dupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_20_4 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY04$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY04$$CBD@Z"
		size = 18
		refs = "000e _dupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_638_6_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY07$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY07$$CBD@Z"
		size = 18
		refs = "000e _dupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_34_4 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY0L@$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY0L@$$CBD@Z"
		size = 18
		refs = "000e _dupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_35_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY03$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY03$$CB_W@Z"
		size = 18
		refs = "000e _wdupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_21_2 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY04$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY04$$CB_W@Z"
		size = 18
		refs = "000e _wdupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_42_2 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY07$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY07$$CB_W@Z"
		size = 18
		refs = "000e _wdupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_35_2 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY0L@$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY0L@$$CB_W@Z"
		size = 18
		refs = "000e _wdupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_43_3 {
	meta:
		name = "??$tfdopen@AAHABQBD@?$__crt_char_traits@D@@SAPAU_iobuf@@AAHABQBD@Z"
		size = 18
		refs = "000e _fdopen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_44_2 {
	meta:
		name = "??$tfdopen@AAHABQB_W@?$__crt_char_traits@_W@@SAPAU_iobuf@@AAHABQB_W@Z"
		size = 18
		refs = "000e _wfdopen"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_8_4 {
	meta:
		name = "??$tgetcwd@ABQADH@?$__crt_char_traits@D@@SAPADABQAD$$QAH@Z"
		size = 18
		refs = "000e _getcwd"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_9_4 {
	meta:
		name = "??$tgetcwd@ABQA_WH@?$__crt_char_traits@_W@@SAPA_WABQA_W$$QAH@Z"
		size = 18
		refs = "000e _wgetcwd"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_116_0 {
	meta:
		name = "??$ungettc_nolock@ABHPAU_iobuf@@@?$__crt_char_traits@D@@SAHABH$$QAPAU_iobuf@@@Z"
		size = 18
		refs = "000e _ungetc_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_24_0 {
	meta:
		name = "??$tcscat_s@PADABIABQBD@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD@Z"
		size = 20
		refs = "0010 strcat_s"
		altNames = "??$tcscat_s@AAPADABIPAD@?$__crt_char_traits@D@@SAHAAPADABI$$QAPAD@Z ??$tcscat_s@AAPADHABQBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHABQBD@Z ??$tcscat_s@ABQADABIAAPAD@?$__crt_char_traits@D@@SAHABQADABIAAPAD@Z ??$tcscat_s@ABQADABIABQBD@?$__crt_char_traits@D@@SAHABQADABIABQBD@Z ??$tcscat_s@ABQADABIPBD@?$__crt_char_traits@D@@SAHABQADABI$$QAPBD@Z ??$tcscat_s@PADABIAAPBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAPBD@Z ??$tcscat_s@PADHABQBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAHABQBD@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_466_4_4 {
	meta:
		name = "??$lseek_nolock@ABHABJH@?$__crt_integer_traits@J@@SAJABHABJ$$QAH@Z"
		size = 20
		refs = "0010 _lseek_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_466_6_0 {
	meta:
		name = "??$lseek_nolock@ABHHH@?$__crt_integer_traits@J@@SAJABH$$QAH1@Z"
		size = 20
		refs = "0010 _lseek_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_406_12_3 {
	meta:
		name = "??$tasctime_s@ABQADABIPAUtm@@@?$__crt_char_traits@D@@SAHABQADABI$$QAPAUtm@@@Z"
		size = 20
		refs = "0010 asctime_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_406_13_2 {
	meta:
		name = "??$tasctime_s@ABQA_WABIPAUtm@@@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPAUtm@@@Z"
		size = 20
		refs = "0010 _wasctime_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_17_4 {
	meta:
		name = "??$tcscat_s@AAPA_WABIPA_W@?$__crt_char_traits@_W@@SAHAAPA_WABI$$QAPA_W@Z"
		size = 20
		refs = "0010 wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_7_0 {
	meta:
		name = "??$tcscat_s@AAPA_WHABQB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHABQB_W@Z"
		size = 20
		refs = "0010 wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_22_2 {
	meta:
		name = "??$tcscat_s@ABQA_WABIAAPA_W@?$__crt_char_traits@_W@@SAHABQA_WABIAAPA_W@Z"
		size = 20
		refs = "0010 wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_23_3 {
	meta:
		name = "??$tcscat_s@ABQA_WABIABQB_W@?$__crt_char_traits@_W@@SAHABQA_WABIABQB_W@Z"
		size = 20
		refs = "0010 wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_24_3 {
	meta:
		name = "??$tcscat_s@ABQA_WABIPB_W@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPB_W@Z"
		size = 20
		refs = "0010 wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_391_25_0 {
	meta:
		name = "??$tcscat_s@PA_WABIAAPB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAPB_W@Z"
		size = 20
		refs = "0010 wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_19_0 {
	meta:
		name = "??$tcscat_s@PA_WABIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W@Z"
		size = 20
		refs = "0010 wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_30_3 {
	meta:
		name = "??$tcscat_s@PA_WHABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAHABQB_W@Z"
		size = 20
		refs = "0010 wcscat_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_18_0 {
	meta:
		name = "??$tcscpy_s@AAPADAAIABQBD@?$__crt_char_traits@D@@SAHAAPADAAIABQBD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_18_4 {
	meta:
		name = "??$tcscpy_s@AAPADABIAAPAD@?$__crt_char_traits@D@@SAHAAPADABI0@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_18_0 {
	meta:
		name = "??$tcscpy_s@AAPADABIABQAD@?$__crt_char_traits@D@@SAHAAPADABIABQAD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_685_20_3 {
	meta:
		name = "??$tcscpy_s@AAPADABIABQBD@?$__crt_char_traits@D@@SAHAAPADABIABQBD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_20_2 {
	meta:
		name = "??$tcscpy_s@AAPADIABQBD@?$__crt_char_traits@D@@SAHAAPAD$$QAIABQBD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_21_4 {
	meta:
		name = "??$tcscpy_s@AAPA_WAAIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_WAAIABQB_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_19_2 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIAAPA_W@?$__crt_char_traits@_W@@SAHAAPA_WABI0@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_19_4 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIABQA_W@?$__crt_char_traits@_W@@SAHAAPA_WABIABQA_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_685_21_2 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIABQB_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_9_4 {
	meta:
		name = "??$tcscpy_s@AAPA_WIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIABQB_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_10_0 {
	meta:
		name = "??$tcscpy_s@ABQADABIAAPAD@?$__crt_char_traits@D@@SAHABQADABIAAPAD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_20_4 {
	meta:
		name = "??$tcscpy_s@ABQADABIABQAD@?$__crt_char_traits@D@@SAHABQADABI0@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_685_22_2 {
	meta:
		name = "??$tcscpy_s@ABQADABIABQBD@?$__crt_char_traits@D@@SAHABQADABIABQBD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_27_4 {
	meta:
		name = "??$tcscpy_s@ABQADABIPBD@?$__crt_char_traits@D@@SAHABQADABI$$QAPBD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_11_0 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIAAPA_W@?$__crt_char_traits@_W@@SAHABQA_WABIAAPA_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_21_4 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIABQA_W@?$__crt_char_traits@_W@@SAHABQA_WABI0@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_685_23_0 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIABQB_W@?$__crt_char_traits@_W@@SAHABQA_WABIABQB_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_28_2 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIPB_W@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPB_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_22_3 {
	meta:
		name = "??$tcscpy_s@PADABIAAPAD@?$__crt_char_traits@D@@SAH$$QAPADABIAAPAD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_22_4 {
	meta:
		name = "??$tcscpy_s@PADABIAAPBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAPBD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_31_3 {
	meta:
		name = "??$tcscpy_s@PADABIABQBD@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_19_2 {
	meta:
		name = "??$tcscpy_s@PADIABQBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAIABQBD@Z"
		size = 20
		refs = "0010 strcpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_23_2 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAPA_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAPA_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_494_24_0 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAPB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAPB_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_20_4 {
	meta:
		name = "??$tcscpy_s@PA_WABIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_572_21_2 {
	meta:
		name = "??$tcscpy_s@PA_WIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAIABQB_W@Z"
		size = 20
		refs = "0010 wcscpy_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_14_4 {
	meta:
		name = "??$tcserror_s@PADIABH@?$__crt_char_traits@D@@SAH$$QAPAD$$QAIABH@Z"
		size = 20
		refs = "0010 strerror_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_15_0 {
	meta:
		name = "??$tcserror_s@PA_WIABH@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAIABH@Z"
		size = 20
		refs = "0010 _wcserror_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_685_28_0 {
	meta:
		name = "??$tcsnicoll@AAPADABQBDABI@?$__crt_char_traits@D@@SAHAAPADABQBDABI@Z"
		size = 20
		refs = "0010 _strnicoll"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_685_29_4 {
	meta:
		name = "??$tcsnicoll@AAPA_WABQB_WABI@?$__crt_char_traits@_W@@SAHAAPA_WABQB_WABI@Z"
		size = 20
		refs = "0010 _wcsnicoll"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_26_2 {
	meta:
		name = "??$tcsnicoll@ABQBDAAPADABI@?$__crt_char_traits@D@@SAHABQBDAAPADABI@Z"
		size = 20
		refs = "0010 _strnicoll"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_677_27_2 {
	meta:
		name = "??$tcsnicoll@ABQB_WAAPA_WABI@?$__crt_char_traits@_W@@SAHABQB_WAAPA_WABI@Z"
		size = 20
		refs = "0010 _wcsnicoll"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_128_3 {
	meta:
		name = "??$tcstol@AAPBDPAPADH@?$__crt_char_traits@D@@SAJAAPBD$$QAPAPAD$$QAH@Z"
		size = 20
		refs = "0010 strtol"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_244_0 {
	meta:
		name = "??$tcstol@AAPB_WPAPA_WH@?$__crt_char_traits@_W@@SAJAAPB_W$$QAPAPA_W$$QAH@Z"
		size = 20
		refs = "0010 wcstol"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_245_4 {
	meta:
		name = "??$tcstol@PBDPAPADH@?$__crt_char_traits@D@@SAJ$$QAPBD$$QAPAPAD$$QAH@Z"
		size = 20
		refs = "0010 strtol"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_131_2 {
	meta:
		name = "??$tcstol@PB_WPAPA_WH@?$__crt_char_traits@_W@@SAJ$$QAPB_W$$QAPAPA_W$$QAH@Z"
		size = 20
		refs = "0010 wcstol"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_113_2 {
	meta:
		name = "??$tcstoull@AAPB_WPAPA_WH@?$__crt_char_traits@_W@@SA_KAAPB_W$$QAPAPA_W$$QAH@Z"
		size = 20
		refs = "0010 wcstoull"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_28_3 {
	meta:
		name = "??$tcstoull@ABQAD$$TH@?$__crt_char_traits@D@@SA_KABQAD$$QA$$T$$QAH@Z"
		size = 20
		refs = "0010 strtoull"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_29_0 {
	meta:
		name = "??$tcstoull@ABQA_W$$TH@?$__crt_char_traits@_W@@SA_KABQA_W$$QA$$T$$QAH@Z"
		size = 20
		refs = "0010 wcstoull"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_65_2 {
	meta:
		name = "??$tcstoull@PBDPAPADH@?$__crt_char_traits@D@@SA_K$$QAPBD$$QAPAPAD$$QAH@Z"
		size = 20
		refs = "0010 strtoull"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_18_3 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TABQBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TABQBD@Z"
		size = 20
		refs = "0010 _dupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_19_2 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TABQB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TABQB_W@Z"
		size = 20
		refs = "0010 _wdupenv_s"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_20_2 {
	meta:
		name = "??$tfullpath@ABQADABQBDABI@?$__crt_char_traits@D@@SAPADABQADABQBDABI@Z"
		size = 20
		refs = "0010 _fullpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_21_2 {
	meta:
		name = "??$tfullpath@ABQA_WABQB_WABI@?$__crt_char_traits@_W@@SAPA_WABQA_WABQB_WABI@Z"
		size = 20
		refs = "0010 _wfullpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_22_4 {
	meta:
		name = "??$tgetpath@AAPADAAPADH@?$__crt_char_traits@D@@SAPADAAPAD0$$QAH@Z"
		size = 20
		refs = "0010 __acrt_getpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_22_4 {
	meta:
		name = "??$tgetpath@AAPADAAPADI@?$__crt_char_traits@D@@SAPADAAPAD0$$QAI@Z"
		size = 20
		refs = "0010 __acrt_getpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_23_4 {
	meta:
		name = "??$tgetpath@AAPA_WAAPA_WH@?$__crt_char_traits@_W@@SAPA_WAAPA_W0$$QAH@Z"
		size = 20
		refs = "0010 __acrt_wgetpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_23_0 {
	meta:
		name = "??$tgetpath@AAPA_WAAPA_WI@?$__crt_char_traits@_W@@SAPA_WAAPA_W0$$QAI@Z"
		size = 20
		refs = "0010 __acrt_wgetpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_45_0 {
	meta:
		name = "??$tgetpath@AAPBDPADH@?$__crt_char_traits@D@@SAPADAAPBD$$QAPAD$$QAH@Z"
		size = 20
		refs = "0010 __acrt_getpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_46_3 {
	meta:
		name = "??$tgetpath@AAPB_WPA_WH@?$__crt_char_traits@_W@@SAPA_WAAPB_W$$QAPA_W$$QAH@Z"
		size = 20
		refs = "0010 __acrt_wgetpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_24_3 {
	meta:
		name = "??$tgetpath@ABQADAAPADI@?$__crt_char_traits@D@@SAPADABQADAAPAD$$QAI@Z"
		size = 20
		refs = "0010 __acrt_getpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_25_0 {
	meta:
		name = "??$tgetpath@ABQA_WAAPA_WI@?$__crt_char_traits@_W@@SAPA_WABQA_WAAPA_W$$QAI@Z"
		size = 20
		refs = "0010 __acrt_wgetpath"
	strings:
		$1 = { 2D E9 00 48 EB 46 12 68 09 68 00 68 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_56_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QAA@XZ"
		size = 22
		altNames = "?close@?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QAAXXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 1B B1 00 22 C3 E9 00 22 02 60 BD E8 00 88 }
	condition:
		$1
}

rule file_170_57_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QAA@XZ"
		size = 26
		refs = "000e fclose"
		altNames = "?close@?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 18 B1 ?? ?? ?? ?? 00 23 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_170_65_0 {
	meta:
		name = "?__crt_stdio_path_requires_backslash@@YA_NQBD@Z"
		size = 64
		refs = "000a strlen 0024 _mbsrchr"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 ?? ?? ?? ?? 44 19 A5 42 01 D1 00 20 11 E0 14 F9 01 3C 5C 2B 0A D1 5C 21 28 46 ?? ?? ?? ?? 63 1E 83 42 18 BF 01 20 04 D1 00 20 02 E0 2F 2B EC D0 01 20 BD E8 30 88 }
	condition:
		$1
}

rule file_170_66_0 {
	meta:
		name = "?__crt_stdio_path_requires_backslash@@YA_NQB_W@Z"
		size = 44
		refs = "000a wcslen"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 04 EB 40 03 9C 42 01 D1 00 20 06 E0 33 F8 02 3C 5C 2B F9 D0 2F 2B F7 D0 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_170_71_0 {
	meta:
		name = "?close@process_handle_pair_traits@?A0xe43b7539@@SA_NPAUprocess_handle_pair@2@@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 00 33 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_170_88_0 {
	meta:
		name = "?idtab@@YAPAUprocess_handle_pair@?A0xe43b7539@@QAU_iobuf@@@Z"
		size = 108
		refs = "0044 _recalloc_base 004c _free_base 0064 ?__idpairs@@3PAUprocess_handle_pair@?A0xe43b7539@@A 0068 ?__idtabsiz@@3IA"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 17 4D 16 4E 2C 68 37 68 07 EB C4 01 8F 42 3A 46 05 D0 52 F8 08 3B 83 42 04 D0 8A 42 F9 D1 20 B1 00 20 19 E0 A2 F1 08 00 16 E0 61 1C A1 42 F7 D3 6F F0 60 43 99 42 F3 D2 08 22 38 46 ?? ?? ?? ?? 04 46 00 20 ?? ?? ?? ?? 00 2C E9 D0 2B 68 34 60 04 EB C3 00 5B 1C 2B 60 BD E8 F0 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_97_0 {
	meta:
		name = "_invoke_watson_if_oneof"
		size = 42
		refs = "0024 _invoke_watson"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 1C 46 18 B1 88 42 03 D0 90 42 01 D0 BD E8 1E 88 09 9A 08 9B 06 99 00 92 07 9A 20 46 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_170_98_0 {
	meta:
		name = "_pclose"
		size = 152
		refs = "000e _errno 0016 _invalid_parameter_noinfo 002a __acrt_lock 0030 ?idtab@@YAPAUprocess_handle_pair@?A0xe43b7539@@QAU_iobuf@@@Z 0044 fclose 0064 _cwait 008a __acrt_unlock"
	strings:
		$1 = { 2D E9 FE 49 0D F1 20 0B 6F 46 04 46 44 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 37 E0 6F F0 00 08 C7 F8 04 80 0A 20 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 05 46 25 B9 ?? ?? ?? ?? 09 23 03 60 22 E0 20 46 ?? ?? ?? ?? 6C 68 00 26 2E 60 6E 60 ?? ?? ?? ?? 05 68 ?? ?? ?? ?? 06 60 3E 60 38 46 01 22 21 46 ?? ?? ?? ?? 40 45 08 D1 ?? ?? ?? ?? 03 68 04 2B 03 D0 ?? ?? ?? ?? 05 60 04 E0 ?? ?? ?? ?? 05 60 3B 68 7B 60 0A 20 ?? ?? ?? ?? 7B 68 3B 60 38 68 BD E8 FE 89 }
	condition:
		$1
}

rule file_171_1_0 {
	meta:
		name = "cacoshl"
		size = 660
		refs = "0016 creall 002a cimagl 0034 _ldtest 00fa _LCbuild 00fe csqrtl 01c8 asinhl 01e8 log 0230 atan2 0278 _LInf_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 0C 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 11 D1 02 28 04 D1 9D ED 02 8B 9D ED 00 1B F8 E0 01 28 05 D1 9D ED 02 1B 87 4B 93 ED 00 8B F0 E0 9D ED 02 8B 08 E0 02 28 09 D1 01 2C 02 D1 9D ED 00 1B F1 E7 9D ED 00 8B B0 EE 48 1B E1 E0 01 2C 20 D1 7C 4B 9D ED 02 0B 01 28 93 ED 00 8B 0A D1 B5 EE C0 0B F1 EE 10 FA 02 D2 9F ED 7B 1B 0C E0 9F ED 78 1B 09 E0 B5 EE C0 0B F1 EE 10 FA 02 D2 9F ED 72 1B 01 E0 9F ED 67 1B BD F8 06 30 13 F4 00 4F BB E0 9D ED 00 0B 01 28 0D D1 6A 4B B5 EE C0 0B F1 EE 10 FA 93 ED 00 8B 02 D2 9F ED 64 1B AF E0 9F ED 60 1B AC E0 9D ED 02 2B B7 EE 00 DB B1 EE 40 1B 32 EE 4D 0B ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 02 2B B0 EE 41 AB 9D ED 00 1B B0 EE 40 BB 32 EE 0D 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 8B B0 EE 40 9B B0 EE 4B 0B B0 EE 4A 1B ?? ?? ?? ?? B0 EE 4A 1B B0 EE 40 CB B0 EE 4B 0B ?? ?? ?? ?? B0 EE 48 1B B0 EE 40 AB B0 EE 49 0B ?? ?? ?? ?? B0 EE 48 1B B0 EE 40 8B B0 EE 49 0B ?? ?? ?? ?? 9F ED 3F 1B 01 24 B0 EE 40 BB B4 EE CC 1B F1 EE 10 FA 08 D2 88 EE 0C 2B B0 EE 4C 9B 22 EE 0A 2B 30 EE 42 0B 1F E0 B4 EE CA 1B F1 EE 10 FA 04 D2 8B EE 0A 0B B0 EE 4A 9B 08 E0 B1 EE 4A 9B B4 EE C9 1B F1 EE 10 FA 06 D2 8B EE 09 0B 20 EE 0C 0B 30 EE 48 0B 07 E0 2B EE 0C 3B 28 EE 0A 2B 9F ED 25 9B 33 EE 42 0B ?? ?? ?? ?? B5 EE 40 9B B0 EE 40 8B F1 EE 10 FA 0F D0 B5 EE C0 0B B0 EE 49 0B F1 EE 10 FA 04 DB ?? ?? ?? ?? 38 EE 00 8B 03 E0 ?? ?? ?? ?? 38 EE 40 8B BD F8 06 30 13 F4 00 4F 06 D0 9D ED 00 0B B1 EE 40 1B 8D ED 00 1B 02 E0 9D ED 00 1B 00 24 9D ED 02 2B 32 EE 4D 0B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 4B 1B ?? ?? ?? ?? B0 EE 00 1B 00 2C 20 EE 01 1B 01 D0 B1 EE 41 1B B0 EE 48 0B ?? ?? ?? ?? 09 B0 BD EC 0C 8B BD E8 10 88 FE DE 00 00 00 00 00 00 00 00 7B 52 82 BD 3A FB CF 5F 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 F9 BF ?? ?? ?? ?? 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 E9 3F D2 21 33 7F 7C D9 02 40 }
	condition:
		$1
}

rule file_529_0_0 {
	meta:
		name = "cacosh"
		size = 660
		refs = "0016 creal 002a cimag 0034 _dtest 00fa _Cbuild 00fe csqrt 01c8 asinh 01e8 log 0230 atan2 0278 _Inf_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 0C 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 11 D1 02 28 04 D1 9D ED 02 8B 9D ED 00 1B F8 E0 01 28 05 D1 9D ED 02 1B 87 4B 93 ED 00 8B F0 E0 9D ED 02 8B 08 E0 02 28 09 D1 01 2C 02 D1 9D ED 00 1B F1 E7 9D ED 00 8B B0 EE 48 1B E1 E0 01 2C 20 D1 7C 4B 9D ED 02 0B 01 28 93 ED 00 8B 0A D1 B5 EE C0 0B F1 EE 10 FA 02 D2 9F ED 7B 1B 0C E0 9F ED 78 1B 09 E0 B5 EE C0 0B F1 EE 10 FA 02 D2 9F ED 72 1B 01 E0 9F ED 67 1B BD F8 06 30 13 F4 00 4F BB E0 9D ED 00 0B 01 28 0D D1 6A 4B B5 EE C0 0B F1 EE 10 FA 93 ED 00 8B 02 D2 9F ED 64 1B AF E0 9F ED 60 1B AC E0 9D ED 02 2B B7 EE 00 DB B1 EE 40 1B 32 EE 4D 0B ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 02 2B B0 EE 41 AB 9D ED 00 1B B0 EE 40 BB 32 EE 0D 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 41 8B B0 EE 40 9B B0 EE 4B 0B B0 EE 4A 1B ?? ?? ?? ?? B0 EE 4A 1B B0 EE 40 CB B0 EE 4B 0B ?? ?? ?? ?? B0 EE 48 1B B0 EE 40 AB B0 EE 49 0B ?? ?? ?? ?? B0 EE 48 1B B0 EE 40 8B B0 EE 49 0B ?? ?? ?? ?? 9F ED 3F 1B 01 24 B0 EE 40 BB B4 EE CC 1B F1 EE 10 FA 08 D2 88 EE 0C 2B B0 EE 4C 9B 22 EE 0A 2B 30 EE 42 0B 1F E0 B4 EE CA 1B F1 EE 10 FA 04 D2 8B EE 0A 0B B0 EE 4A 9B 08 E0 B1 EE 4A 9B B4 EE C9 1B F1 EE 10 FA 06 D2 8B EE 09 0B 20 EE 0C 0B 30 EE 48 0B 07 E0 2B EE 0C 3B 28 EE 0A 2B 9F ED 25 9B 33 EE 42 0B ?? ?? ?? ?? B5 EE 40 9B B0 EE 40 8B F1 EE 10 FA 0F D0 B5 EE C0 0B B0 EE 49 0B F1 EE 10 FA 04 DB ?? ?? ?? ?? 38 EE 00 8B 03 E0 ?? ?? ?? ?? 38 EE 40 8B BD F8 06 30 13 F4 00 4F 06 D0 9D ED 00 0B B1 EE 40 1B 8D ED 00 1B 02 E0 9D ED 00 1B 00 24 9D ED 02 2B 32 EE 4D 0B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 4B 1B ?? ?? ?? ?? B0 EE 00 1B 00 2C 20 EE 01 1B 01 D0 B1 EE 41 1B B0 EE 48 0B ?? ?? ?? ?? 09 B0 BD EC 0C 8B BD E8 10 88 FE DE 00 00 00 00 00 00 00 00 7B 52 82 BD 3A FB CF 5F 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 F9 BF ?? ?? ?? ?? 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 E9 3F D2 21 33 7F 7C D9 02 40 }
	condition:
		$1
}

rule file_172_7_0 {
	meta:
		name = "??0__acrt_stdio_temporary_buffering_guard@@QAA@QAU_iobuf@@@Z"
		size = 26
		refs = "000e __acrt_stdio_begin_temporary_buffering_nolock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 08 46 21 60 ?? ?? ?? ?? 20 71 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_172_9_0 {
	meta:
		name = "??1__acrt_stdio_temporary_buffering_guard@@QAA@XZ"
		size = 18
		refs = "000e __acrt_stdio_end_temporary_buffering_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 68 00 79 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_172_17_0 {
	meta:
		name = "puts"
		size = 224
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0024 __acrt_iob_func 003e _fileno 00a6 strlen 00c6 ??$?RV<lambda_cd71a80a2e07be5c049dbac2d42b50cf>@@AAV<lambda_3126a0d026c48c72336a1719c85146ae>@@V<lambda_054a4245c223b8b973249f076dad6b96>@@@?$__crt_seh_guarded_call@H@@QAAH$$QAV<lambda_cd71a80a2e07be5c049dbac2d42b50cf>@@AAV<lambda_3126a0d026c48c72336a1719c85146ae>@@$$QAV<lambda_054a4245c223b8b973249f076dad6b96>@@@Z 00d8 __badioinfo 00dc __pioinfo"
	strings:
		$1 = { 03 B4 2D E9 70 48 0D F1 0C 0B 89 B0 0E 90 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 54 E0 01 20 ?? ?? ?? ?? 01 90 C3 68 BF F3 5B 8F 13 F4 80 5F 18 BF 01 23 08 BF 00 23 93 BB ?? ?? ?? ?? 6F F0 00 04 25 4E 23 4D A0 42 0C D0 10 F1 02 0F 09 D0 00 F0 3F 03 81 11 03 EB 43 02 56 F8 21 30 03 EB 02 13 00 E0 2B 46 93 F9 29 30 93 B9 A0 42 0B D0 10 F1 02 0F 08 D0 00 F0 3F 03 81 11 03 EB 43 02 56 F8 21 30 03 EB 02 15 95 F8 2D 30 13 F0 01 0F 06 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 13 E0 0E 98 ?? ?? ?? ?? 01 AB 06 93 0E AB 07 93 02 AB 08 93 01 9B CD E9 02 03 06 AA 04 93 03 AB 04 A9 68 46 ?? ?? ?? ?? 04 46 20 46 09 B0 BD E8 70 08 5D F8 0C FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "_wcsnset"
		size = 32
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 00 24 05 46 32 B1 2B 88 23 B1 64 1C 94 42 25 F8 02 1B F8 D1 BD E8 30 88 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "setbuf"
		size = 30
		refs = "0016 setvbuf"
	strings:
		$1 = { 2D E9 00 48 EB 46 19 B9 00 23 04 22 00 21 02 E0 4F F4 00 73 00 22 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_177_1_0 {
	meta:
		name = "sqrtf"
		size = 108
		refs = "0024 _handle_nanf 0048 _handle_errorf 0064 ??_C@_05KGFAIMPG@sqrtf?$AA@"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 10 EE 10 0A 4F F0 00 42 00 F0 FF 43 B3 F1 FF 4F 19 D1 03 46 6F F3 DF 53 1B B1 00 21 ?? ?? ?? ?? 18 E0 10 42 0F D0 21 22 02 92 08 22 01 23 DF ED 0C 0A 0A 48 01 92 08 4A 03 93 00 93 00 23 05 21 ?? ?? ?? ?? 06 E0 10 42 02 D0 30 EA 02 03 EA D1 B1 EE C0 0A BD E8 0F 88 00 00 C0 FF ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "??$common_tcscpy_s@D@@YAHQADIQBD@Z"
		size = 88
		refs = "0014 _errno 003a _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 13 46 D8 B1 D1 B1 2B B9 00 23 03 70 ?? ?? ?? ?? 16 24 0D E0 02 46 1C 1A A3 56 02 F8 01 3B 0B B1 49 1E F9 D1 41 B9 00 23 03 70 ?? ?? ?? ?? 22 24 04 60 ?? ?? ?? ?? 08 E0 00 24 06 E0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_178_1_0 {
	meta:
		name = "strcpy_s"
		size = 80
		refs = "0014 _errno 001c _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 13 46 18 B1 11 B1 53 B9 00 23 03 70 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 BD E8 18 88 02 46 1C 1A A3 56 02 F8 01 3B 0B B1 49 1E F9 D1 49 B9 00 23 03 70 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 20 EA E7 00 20 E8 E7 }
	condition:
		$1
}

rule file_179_6_0 {
	meta:
		name = "__acrt_has_user_matherr"
		size = 44
		refs = "0024 ?user_matherr@@3V?$dual_state_global@P6AHPAU_exception@@@Z@__crt_state_management@@A 0028 __security_cookie"
	strings:
		$1 = { 2D E9 00 48 EB 46 08 4B 19 68 06 4B 01 F0 1F 02 1B 68 4B 40 D3 41 18 BF 01 20 08 BF 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_179_7_0 {
	meta:
		name = "__acrt_initialize_user_matherr"
		size = 20
		refs = "0010 ?user_matherr@@3V?$dual_state_global@P6AHPAU_exception@@@Z@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_669_7_4 {
	meta:
		name = "__acrt_initialize_invalid_parameter_handler"
		size = 20
		refs = "0010 ?__acrt_invalid_parameter_handler@@3V?$dual_state_global@P6AXPB_W00II@Z@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_457_9_4 {
	meta:
		name = "__acrt_initialize_new_handler"
		size = 20
		refs = "0010 ?__acrt_new_handler@@3V?$dual_state_global@P6AHI@Z@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_34_3 {
	meta:
		name = "__acrt_initialize_thread_local_exit_callback"
		size = 20
		refs = "0010 ?thread_local_exit_callback_func@@3P6AXPAXK0@ZA"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_244_6_3 {
	meta:
		name = "_set_app_type"
		size = 20
		refs = "0010 ?__acrt_app_type@@3W4_crt_app_type@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_47_2 {
	meta:
		name = "_set_pgmptr"
		size = 20
		refs = "0010 _pgmptr"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_48_2 {
	meta:
		name = "_set_wpgmptr"
		size = 20
		refs = "0010 _wpgmptr"
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 18 60 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_179_8_0 {
	meta:
		name = "__acrt_invoke_user_matherr"
		size = 64
		refs = "0034 __guard_check_icall_fptr 0038 ?user_matherr@@3V?$dual_state_global@P6AHPAU_exception@@@Z@__crt_state_management@@A 003c __security_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4B 05 46 19 68 0A 4B 01 F0 1F 02 1B 68 4B 40 73 FA 02 F4 08 BF 00 20 05 D0 04 4B 20 46 1B 68 98 47 28 46 A0 47 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_179_9_0 {
	meta:
		name = "__setusermatherr"
		size = 40
		refs = "0020 ?user_matherr@@3V?$dual_state_global@P6AHPAU_exception@@@Z@__crt_state_management@@A 0024 __security_cookie"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4B 05 4A 19 68 01 F0 1F 03 C3 F1 20 03 60 FA 03 F3 4B 40 13 60 BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "wcscat"
		size = 38
	strings:
		$1 = { 2D E9 00 48 EB 46 03 88 02 46 01 E0 92 1C 13 88 00 2B FB D1 52 1A 0B 88 53 52 01 F1 02 01 00 2B F9 D1 BD E8 00 88 }
	condition:
		$1
}

rule file_181_9_0 {
	meta:
		name = "__acrt_stdio_free_buffer_nolock"
		size = 96
		refs = "0038 _free_base"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 00 F1 0C 04 23 68 05 46 BF F3 5B 8F 13 F4 00 5F 18 BF 01 23 08 BF 00 23 E3 B1 23 68 BF F3 5B 8F 13 F0 40 0F 18 BF 01 23 08 BF 00 23 93 B1 68 68 ?? ?? ?? ?? BF F3 5B 8F 54 E8 00 1F 21 F4 A0 72 44 E8 00 23 00 2B F7 D1 BF F3 5B 8F 00 23 C5 E9 00 33 AB 60 BD E8 30 88 }
	condition:
		$1
}

rule file_182_4_0 {
	meta:
		name = "_mbtowc_l"
		size = 208
		refs = "002c ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 005c _isleadbyte_l 00bc _errno 00cc __imp_MultiByteToWideChar"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 86 B0 0E 46 17 46 05 46 36 B1 2F B1 91 F9 00 40 34 B9 0D B1 00 23 2B 80 00 20 06 B0 BD E8 F0 88 02 A8 19 46 ?? ?? ?? ?? 03 9B D3 F8 A8 30 7B B9 0D B1 33 78 2B 80 01 20 9D F8 14 30 00 2B EC D0 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 E4 E7 30 78 03 A9 ?? ?? ?? ?? E0 B1 03 98 43 68 01 2B 10 DD 9F 42 0E DB 0D B1 01 22 00 E0 00 22 15 4C 80 68 01 92 24 68 32 46 09 21 00 95 A0 47 00 28 03 98 05 D1 43 68 9F 42 14 D3 96 F9 01 30 8B B1 40 68 D1 E7 0D B1 01 23 00 E0 00 23 03 98 09 4C 01 93 80 68 24 68 01 23 32 46 09 21 00 95 A0 47 00 28 C0 D1 ?? ?? ?? ?? 2A 23 03 60 6F F0 00 00 BA E7 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_4_0 {
	meta:
		name = "_mbccpy_s_l"
		size = 180
		refs = "0024 _errno 002c _invalid_parameter_noinfo 003c ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 FF 4B 0D F1 28 0B 14 46 1E 46 0F 46 05 46 4F F0 00 08 0C B1 C2 F8 00 80 1D B1 17 B1 5E B9 85 F8 00 80 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 04 B0 BD E8 F0 8B 0C 99 68 46 ?? ?? ?? ?? 32 78 02 9B 4F F0 02 09 13 44 5B 7E 13 F0 04 0F 1F D0 73 78 53 B9 85 F8 00 80 0C B1 01 23 23 60 ?? ?? ?? ?? 2A 23 03 60 2A 20 17 E0 02 2F 09 D2 85 F8 00 80 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 20 0B E0 2A 70 73 78 6B 70 34 B1 C4 F8 00 90 03 E0 2A 70 0C B1 01 23 23 60 00 20 9D F8 0C 30 00 2B C6 D0 00 9A D2 F8 50 33 23 EA 09 03 C2 F8 50 33 BE E7 }
	condition:
		$1
}

rule file_184_3_0 {
	meta:
		name = "?LongLongSub@@YAJ_J0PA_J@Z"
		size = 100
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 84 1A 61 EB 03 00 00 29 02 DC B8 BF 01 22 00 DB 00 22 00 2B 02 DC B8 BF 01 23 00 DB 00 23 9A 42 14 D0 00 29 02 DC B8 BF 01 23 00 DB 00 23 00 28 02 DC B8 BF 01 22 00 DB 00 22 93 42 06 D0 04 9B 6F F0 00 02 04 48 C3 E9 00 22 03 E0 04 9B C3 E9 00 40 00 20 BD E8 18 88 16 02 07 80 }
	condition:
		$1
}

rule file_184_6_0 {
	meta:
		name = "?common_fseek@@YAHV__crt_stdio_stream@@_JH@Z"
		size = 98
		refs = "0016 _errno 001e _invalid_parameter_noinfo 003a _lock_file 0046 ?common_fseek_nolock@@YAHV__crt_stdio_stream@@_JH@Z 004e _unlock_file"
	strings:
		$1 = { 0F B4 2D E9 FC 48 0D F1 18 0B 6F 46 82 B0 1D 46 16 46 38 62 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 15 E0 3C 6B 1C B1 01 2C 01 D0 02 2C F0 D1 6F F0 00 03 7B 60 ?? ?? ?? ?? 00 94 2B 46 32 46 38 6A ?? ?? ?? ?? 78 60 38 6A ?? ?? ?? ?? 7B 68 3B 60 38 68 04 B0 BD E8 F0 08 5D F8 14 FB }
	condition:
		$1
}

rule file_184_7_0 {
	meta:
		name = "?fin$0@?0??common_fseek@@YAHV__crt_stdio_stream@@_JH@Z@4HA"
		size = 16
		refs = "0006 ?public_stream@__crt_stdio_stream@@QBAPAU_iobuf@@XZ 000a _unlock_file"
	strings:
		$1 = { 1C B5 17 F1 20 00 ?? ?? ?? ?? ?? ?? ?? ?? 1C BD }
	condition:
		$1
}

rule file_184_8_0 {
	meta:
		name = "?common_fseek_binary_mode_read_only_fast_track_nolock@@YA_NV__crt_stdio_stream@@_JH@Z"
		size = 244
		refs = "0084 _lseeki64_nolock 00a4 ?LongLongSub@@YAJ_J0PA_J@Z 00f0 __pioinfo"
	strings:
		$1 = { 0F B4 2D E9 FC 48 0D F1 18 0B 0C 9F 1E 46 15 46 02 2F CD E9 0A 56 08 90 65 D0 C3 68 BF F3 5B 8F 13 F4 98 6F 18 BF 01 23 08 BF 00 23 00 2B 5A D0 08 9B DB 68 BF F3 5B 8F 13 F0 06 0F 18 BF 01 23 08 BF 00 23 00 2B 4E D1 08 9A 93 68 00 2B 4A DD 10 69 BF F3 5B 8F 26 49 00 F0 3F 03 84 11 03 EB 43 02 51 F8 24 30 03 EB 02 12 92 F8 28 30 13 F0 80 0F 38 D1 92 F9 29 30 AB BB D7 B9 01 23 00 93 00 23 00 22 ?? ?? ?? ?? 0F 46 00 2F 00 DC 2A DB 08 9C 0A AB 00 93 A3 68 C2 1A 19 46 67 EB E3 73 31 46 28 46 ?? ?? ?? ?? 00 28 1C DB DD E9 0A 56 00 E0 08 9C D4 E9 00 13 5A 1A D3 17 B3 42 12 DC 01 DB AA 42 0F D8 A2 68 13 46 B6 EB E2 7F 02 DB 09 DC 95 42 07 D8 6B 18 23 60 08 9A 93 68 5B 1B 93 60 01 20 00 E0 00 20 BD E8 FC 08 5D F8 14 FB ?? ?? ?? ?? }
	condition:
		$1
}

rule file_184_9_0 {
	meta:
		name = "?common_fseek_nolock@@YAHV__crt_stdio_stream@@_JH@Z"
		size = 270
		refs = "0024 _errno 005a ?common_fseek_binary_mode_read_only_fast_track_nolock@@YA_NV__crt_stdio_stream@@_JH@Z 0068 _ftelli64_nolock 0074 __acrt_stdio_flush_nolock 00f4 _lseeki64_nolock"
	strings:
		$1 = { 0F B4 2D E9 7E 48 0D F1 18 0B 08 90 C1 68 1C 46 15 46 BF F3 5B 8F 11 F4 00 5F 18 BF 01 21 08 BF 00 21 31 B9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 00 69 E0 BF F3 5B 8F 08 9B 03 F1 0C 02 52 E8 00 0F 20 F0 08 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 0C 9E 08 98 23 46 2A 46 00 96 ?? ?? ?? ?? 00 28 50 D1 01 2E 05 D1 08 98 ?? ?? ?? ?? 2D 18 4C 41 00 26 08 98 ?? ?? ?? ?? 08 9A 53 68 13 60 00 23 93 60 08 9B DB 68 BF F3 5B 8F 13 F0 04 0F 18 BF 01 23 08 BF 00 23 7B B1 BF F3 5B 8F 08 9B 03 F1 0C 02 52 E8 00 0F 20 F0 03 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 16 E0 08 9B DB 68 BF F3 5B 8F 03 F0 41 03 41 2B 0E D1 08 9B DB 68 BF F3 5B 8F 13 F4 80 7F 18 BF 01 23 08 BF 00 23 1B B9 08 9B 4F F4 00 72 9A 61 08 9B 18 69 BF F3 5B 8F 23 46 2A 46 00 96 ?? ?? ?? ?? 00 EA 01 03 6F F0 00 00 83 42 00 D0 00 20 BD E8 7E 08 5D F8 14 FB }
	condition:
		$1
}

rule file_184_15_0 {
	meta:
		name = "?lowio_handle@__crt_stdio_stream@@QBAHXZ"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 18 69 BF F3 5B 8F BD E8 00 88 }
	condition:
		$1
}

rule file_184_19_0 {
	meta:
		name = "_fseek_nolock"
		size = 22
		refs = "000e ?common_fseek_nolock@@YAHV__crt_stdio_stream@@_JH@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 00 92 0A 46 CB 17 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_184_22_0 {
	meta:
		name = "fseek"
		size = 22
		refs = "000e ?common_fseek@@YAHV__crt_stdio_stream@@_JH@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 00 92 0A 46 CB 17 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "?write_binary_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z"
		size = 96
		refs = "0054 __imp_GetLastError 0058 __imp_WriteFile 005c __pioinfo"
	strings:
		$1 = { 2D E9 FE 49 0D F1 20 0B 14 4D 8E 11 01 F0 3F 01 01 EB 41 04 55 F8 26 10 96 46 1F 46 01 EB 04 11 0D 4C 80 46 88 69 00 22 00 23 C8 E9 00 23 C8 F8 08 30 24 68 00 92 08 F1 04 03 3A 46 71 46 A0 47 20 B9 04 4B 1B 68 98 47 C8 F8 00 00 40 46 BD E8 FE 89 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_1_0 {
	meta:
		name = "?write_double_translated_ansi_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z"
		size = 416
		refs = "0008 __security_push_cookie 008a __pctype_func 00a4 mbtowc 0184 __security_pop_cookie 018c __imp_GetLastError 0190 __imp_WriteFile 0194 __imp_WideCharToMultiByte 0198 __imp_GetConsoleCP 019c __pioinfo"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 90 B0 DF F8 8C 91 4F EA A1 18 01 F0 3F 01 01 EB 41 0A 59 F8 28 10 14 46 E7 18 5C 4B 01 EB 0A 11 8A 69 1B 68 08 94 06 92 05 46 0A 97 98 47 00 23 C5 E9 00 33 AB 60 07 90 26 46 BC 42 80 F0 9A 80 64 1C 59 F8 28 30 00 22 AD F8 10 20 03 EB 0A 12 92 F8 2D 10 96 F9 00 00 4F F0 04 0E 11 EA 0E 0F 09 90 0C D0 92 F8 2E 30 8D F8 31 00 8D F8 30 30 01 F0 FB 03 82 F8 2D 30 02 22 0C A9 16 E0 ?? ?? ?? ?? 33 78 30 F8 13 30 13 F4 00 4F 0C D0 BC 42 57 D2 02 22 31 46 04 A8 ?? ?? ?? ?? 10 F1 01 0F 68 D0 76 1C 64 1C 07 E0 01 22 31 46 04 A8 ?? ?? ?? ?? 10 F1 01 0F 5D D0 64 1C 00 23 0B 94 32 4C 03 93 02 93 05 23 01 93 24 68 07 98 0E AB 00 93 01 23 04 AA 00 21 76 1C A0 47 07 46 00 2F 49 D0 28 4C 00 23 02 46 24 68 06 98 00 93 05 AB 0E A9 A0 47 D8 B3 AB 68 08 9A 9B 1A 33 44 6B 60 05 9B BB 42 37 D3 09 9B 0A 2B 16 D1 1E 4C 0D 23 AD F8 12 30 24 68 06 98 00 23 00 93 05 AB 01 22 0D F1 12 01 A0 47 10 B3 05 9B 01 2B 23 D3 AB 68 5B 1C AB 60 6B 68 5B 1C 6B 60 0A 9F BE 42 1A D2 0B 9C 7F E7 59 F8 28 30 03 EB 0A 12 33 78 82 F8 2E 30 59 F8 28 30 03 EB 0A 12 92 F8 2D 30 43 F0 04 03 82 F8 2D 30 6B 68 5B 1C 6B 60 03 E0 04 4B 1B 68 98 47 28 60 28 46 10 B0 ?? ?? ?? ?? BD E8 F0 8F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_2_0 {
	meta:
		name = "?write_double_translated_unicode_nolock@@YA?AUwrite_result@?A0x17268360@@QBDI@Z"
		size = 92
		refs = "001c _putwch_nolock 0058 __imp_GetLastError"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 04 46 00 23 0E 46 C4 E9 00 33 B7 18 15 E0 36 F8 02 5B 28 46 ?? ?? ?? ?? A8 42 12 D1 63 68 9B 1C 63 60 0A 2D 0A D1 0D 20 ?? ?? ?? ?? 0D 28 08 D1 63 68 5B 1C 63 60 A3 68 5B 1C A3 60 BE 42 E6 D3 03 E0 03 4B 1B 68 98 47 20 60 20 46 BD E8 F0 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_3_0 {
	meta:
		name = "?write_requires_double_translation_nolock@@YA_NH@Z"
		size = 116
		refs = "000a _isatty 0032 __acrt_getptd 006c __imp_GetConsoleMode 0070 __pioinfo"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 ?? ?? ?? ?? 08 B9 00 20 28 E0 16 4E 04 F0 3F 03 A5 11 03 EB 43 04 56 F8 25 30 03 EB 04 13 93 F8 28 30 13 F0 80 0F EE D0 ?? ?? ?? ?? C3 6C D3 F8 A8 30 3B B9 56 F8 25 30 03 EB 04 13 93 F9 29 30 00 2B E0 D0 56 F8 25 30 69 46 03 EB 04 13 98 69 04 4B 1B 68 98 47 00 28 D5 D0 01 20 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_4_0 {
	meta:
		name = "?write_text_ansi_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z"
		size = 208
		refs = "0008 __security_push_cookie 0010 __chkstk 00ba __security_pop_cookie 00c4 __imp_GetLastError 00c8 __imp_WriteFile 00cc __pioinfo"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 40 F2 04 54 ?? ?? ?? ?? AD EB 04 0D 2C 4C 8D 11 01 F0 3F 01 06 46 01 EB 41 00 54 F8 25 10 02 EB 03 08 4F F0 00 0E 01 EB 00 11 88 69 00 23 17 46 C6 E9 00 E3 03 90 B3 60 47 45 34 D2 1F 4C 0D 25 41 F2 0F 49 E9 44 0D F1 10 0A 04 AA 47 45 0D D2 97 F9 00 10 7F 1C 0A 29 04 D1 B3 68 15 70 5B 1C B3 60 52 1C 02 F8 01 1B 4A 45 EF D3 24 68 A2 EB 0A 05 2A 46 02 AB 04 A9 CD F8 00 E0 A0 47 70 B1 73 68 02 9A 13 44 73 60 AA 42 0C D3 0B 4C 03 98 47 45 4F F0 0D 05 4F F0 00 0E D6 D3 03 E0 06 4B 1B 68 98 47 30 60 30 46 41 F2 10 4C E5 44 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_5_0 {
	meta:
		name = "?write_text_utf16le_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z"
		size = 208
		refs = "0008 __security_push_cookie 0010 __chkstk 00ba __security_pop_cookie 00c4 __imp_GetLastError 00c8 __imp_WriteFile 00cc __pioinfo"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 40 F2 04 54 ?? ?? ?? ?? AD EB 04 0D 2C 4C 8D 11 01 F0 3F 01 06 46 01 EB 41 00 54 F8 25 10 17 46 FD 18 01 EB 00 11 88 69 00 23 C6 E9 00 33 03 90 B3 60 AF 42 37 D2 21 4C 41 F2 0E 49 E9 44 0D F1 10 0A 4F F0 0D 0E 04 AA AF 42 0D D2 39 88 BF 1C 0A 29 05 D1 B3 68 A2 F8 00 E0 9B 1C B3 60 92 1C 22 F8 02 1B 4A 45 EF D3 A2 EB 0A 03 4F EA 63 08 24 68 00 23 00 93 02 AB 4F EA 48 02 04 A9 A0 47 68 B1 73 68 02 9A 13 44 73 60 B2 EB 48 0F 0A D3 0A 4C 03 98 AF 42 4F F0 0D 0E D4 D3 03 E0 06 4B 1B 68 98 47 30 60 30 46 41 F2 10 4C E5 44 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_6_0 {
	meta:
		name = "?write_text_utf8_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z"
		size = 244
		refs = "0008 __security_push_cookie 0010 __chkstk 00da __security_pop_cookie 00e4 __imp_GetLastError 00e8 __imp_WriteFile 00ec __imp_WideCharToMultiByte 00f0 __pioinfo"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 40 F2 08 54 ?? ?? ?? ?? AD EB 04 0D 35 4C 8D 11 01 F0 3F 01 06 46 01 EB 41 00 54 F8 25 10 91 46 01 EB 00 11 8A 69 09 EB 03 0A 00 23 04 92 00 22 C6 E9 00 23 B3 60 4F 46 D1 45 44 D2 DF F8 A0 E0 0D F5 D8 61 0D F5 D9 64 06 AD 06 AB 40 F6 55 50 4F F0 0D 08 57 45 0A D2 3A 88 BF 1C 0A 2A 02 D1 A3 F8 00 80 9B 1C 23 F8 02 2B 8B 42 F2 D3 00 22 00 94 DE F8 00 40 5B 1B 03 92 02 92 01 90 06 AA 5B 10 00 21 4F F6 E9 50 A0 47 80 46 B8 B1 00 25 80 B1 12 4C 04 98 00 23 24 68 0D F5 D9 61 00 93 05 AB A8 EB 05 02 29 44 A0 47 40 B1 05 9B 1D 44 45 45 EE D3 A7 EB 09 03 73 60 57 45 BD E7 06 4B 1B 68 98 47 30 60 30 46 41 F2 20 4C E5 44 ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_9_0 {
	meta:
		name = "_write_nolock"
		size = 564
		refs = "0018 __doserrno 0020 _errno 0028 _invalid_parameter_noinfo 0074 _lseeki64_nolock 0082 _isatty 009e __acrt_getptd 00f2 _putwch_nolock 0138 ?write_double_translated_ansi_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z 016a ?write_text_utf16le_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z 0186 ?write_text_utf8_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z 019a ?write_text_ansi_nolock@@YA?AUwrite_result@?A0x17268360@@HQBDI@Z 01e8 __acrt_errno_map_os_error 0224 __imp_GetLastError 0228 __imp_WriteFile 022c __pioinfo 0230 __imp_GetConsoleMode"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 9F B0 16 46 0F 46 05 46 0E B9 00 20 02 E1 67 B9 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 00 F4 E0 DF F8 F8 81 05 F0 3F 03 4F EA A5 1A 03 EB 43 09 58 F8 2A 30 CD F8 24 90 03 EB 09 13 93 F9 29 40 02 2C 01 D0 01 2C 02 D1 16 F0 01 0F DB D1 93 F8 28 30 13 F0 20 0F 06 D0 02 23 00 93 00 23 00 22 28 46 ?? ?? ?? ?? 00 23 28 46 CD E9 0A 33 0C 93 ?? ?? ?? ?? 00 21 00 28 5C D0 58 F8 2A 30 03 EB 09 13 93 F8 28 30 13 F0 80 0F 53 D0 ?? ?? ?? ?? C3 6C D3 F8 A8 30 3B B9 58 F8 2A 30 03 EB 09 13 93 F9 29 30 00 2B 44 D0 58 F8 2A 30 1D A9 03 EB 09 13 98 69 5A 4B 1B 68 98 47 D0 B3 7C B3 63 1E 01 2B 4F D8 00 23 07 EB 06 09 CD E9 03 33 DD E9 03 45 02 93 B8 46 4F 45 15 D2 38 F8 02 6B 30 46 ?? ?? ?? ?? B0 42 14 D1 A4 1C 03 94 0A 2E 08 D1 0D 20 ?? ?? ?? ?? 0D 28 0B D1 64 1C 6D 1C CD E9 03 45 C8 45 E9 D3 02 98 DF F8 10 81 DD F8 24 90 54 E0 3F 4B 1B 68 98 47 DD E9 03 45 F4 E7 0E A8 33 46 3A 46 29 46 ?? ?? ?? ?? DD E9 0E 04 10 9D 44 E0 00 21 58 F8 2A 30 03 EB 09 12 92 F8 28 30 13 F0 80 0F 26 D0 DC B1 01 2C 0F D0 02 2C 09 D1 12 A8 33 46 3A 46 29 46 ?? ?? ?? ?? DD E9 12 04 14 9D 2B E0 DD E9 0B 45 0A 98 27 E0 16 A8 33 46 3A 46 29 46 ?? ?? ?? ?? DD E9 16 04 18 9D 1D E0 1A A8 33 46 3A 46 29 46 ?? ?? ?? ?? DD E9 1A 04 1C 9D 13 E0 20 4C 90 69 00 23 CD E9 06 33 08 93 24 68 00 91 07 AB 32 46 39 46 A0 47 18 B9 18 4B 1B 68 98 47 00 E0 06 98 DD E9 07 45 24 BB 68 B1 05 28 08 D1 ?? ?? ?? ?? 09 23 03 60 ?? ?? ?? ?? 05 23 03 60 21 E7 ?? ?? ?? ?? 1E E7 58 F8 2A 30 03 EB 09 13 93 F8 28 30 13 F0 40 0F 04 D0 97 F9 00 30 1A 2B 3F F4 04 AF ?? ?? ?? ?? 1C 23 03 60 ?? ?? ?? ?? 00 23 E4 E7 60 1B 1F B0 BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "acosh"
		size = 184
		refs = "000e _dtest 003e _fperrraise 0086 log1p 0090 log 00a8 _Eps_C 00b4 _Nan_C"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 01 28 04 D0 02 28 07 D1 9D ED 00 0B 3D E0 BD F8 06 30 13 F4 00 4F F6 E7 9D ED 00 2B B7 EE 00 3B B4 EE C3 2B F1 EE 10 FA 06 D2 01 20 ?? ?? ?? ?? 1C 4B 93 ED 00 0B 28 E0 B4 EE 43 2B F1 EE 10 FA 02 D1 9F ED 15 0B 20 E0 13 4B B0 EE 00 1B 93 ED 00 0B 81 EE 00 0B B4 EE C0 2B F1 EE 10 FA 0C D2 32 EE 43 1B 32 EE 03 0B 20 EE 01 0B B1 EE C0 0B 30 EE 01 0B ?? ?? ?? ?? 07 E0 B0 EE 42 0B ?? ?? ?? ?? 9F ED 02 1B 30 EE 01 0B BD E8 0C 88 EF 39 FA FE 42 2E E6 3F ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "acoshl"
		size = 184
		refs = "000e _ldtest 003e _fperrraise 0086 log1pl 0090 log 00a8 _LEps_C 00b4 _LNan_C"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 01 28 04 D0 02 28 07 D1 9D ED 00 0B 3D E0 BD F8 06 30 13 F4 00 4F F6 E7 9D ED 00 2B B7 EE 00 3B B4 EE C3 2B F1 EE 10 FA 06 D2 01 20 ?? ?? ?? ?? 1C 4B 93 ED 00 0B 28 E0 B4 EE 43 2B F1 EE 10 FA 02 D1 9F ED 15 0B 20 E0 13 4B B0 EE 00 1B 93 ED 00 0B 81 EE 00 0B B4 EE C0 2B F1 EE 10 FA 0C D2 32 EE 43 1B 32 EE 03 0B 20 EE 01 0B B1 EE C0 0B 30 EE 01 0B ?? ?? ?? ?? 07 E0 B0 EE 42 0B ?? ?? ?? ?? 9F ED 02 1B 30 EE 01 0B BD E8 0C 88 EF 39 FA FE 42 2E E6 3F ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "wcscspn"
		size = 52
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 03 88 02 46 73 B1 0C 88 0D 46 3C B1 16 88 23 46 9E 42 07 D0 35 F8 02 3F 00 2B F9 D1 92 1C 13 88 00 2B F1 D1 13 1A 58 10 BD E8 78 88 }
	condition:
		$1
}

rule file_188_4_0 {
	meta:
		name = "_strncoll"
		size = 84
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 003c strncmp 0044 _strncoll_l 0050 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 11 4B 1B 68 CB B9 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 44 13 E0 00 29 F4 D0 6F F0 00 44 A2 42 06 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 06 E0 ?? ?? ?? ?? 02 E0 00 23 ?? ?? ?? ?? 04 46 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_454_5_0 {
	meta:
		name = "_strnicmp"
		size = 84
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 003c __ascii_strnicmp 0044 _strnicmp_l 0050 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 11 4B 1B 68 CB B9 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 44 13 E0 00 29 F4 D0 6F F0 00 44 A2 42 06 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 06 E0 ?? ?? ?? ?? 02 E0 00 23 ?? ?? ?? ?? 04 46 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_503_4_0 {
	meta:
		name = "_wcsncoll"
		size = 84
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 003c wcsncmp 0044 _wcsncoll_l 0050 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 11 4B 1B 68 CB B9 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 44 13 E0 00 29 F4 D0 6F F0 00 44 A2 42 06 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 06 E0 ?? ?? ?? ?? 02 E0 00 23 ?? ?? ?? ?? 04 46 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_188_5_0 {
	meta:
		name = "_strncoll_l"
		size = 162
		refs = "0018 _errno 0020 _invalid_parameter_noinfo 0048 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 005a strncmp 0074 __acrt_CompareStringA"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 88 B0 15 46 0E 46 07 46 0D B9 00 24 41 E0 47 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 44 37 E0 00 2E F4 D0 6F F0 00 44 A5 42 06 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 2A E0 04 A8 19 46 ?? ?? ?? ?? 05 9B D3 F8 A4 10 31 B9 2A 46 31 46 38 46 ?? ?? ?? ?? 04 46 11 E0 1B 69 05 A8 4F F4 80 52 03 93 3B 46 02 95 01 96 00 95 ?? ?? ?? ?? 20 B9 ?? ?? ?? ?? 16 23 03 60 00 E0 84 1E 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 08 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "atan2"
		size = 1528
		refs = "009e _handle_nan 00ce _controlfp_s 05b0 ?atan_jby256_tail@?1??atan2@@9@9 05bc ?atan_jby256_lead@?1??atan2@@9@9"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 2D ED 06 8B 83 B0 58 EC 11 9B 57 EC 10 5B 4F F0 00 46 28 EA 06 02 59 EA 02 03 B0 EE 41 AB B0 EE 40 8B 27 EA 06 01 C8 F3 0A 54 02 D1 01 20 00 90 01 E0 00 23 00 93 55 EA 01 03 02 D1 4F F0 01 0E 01 E0 4F F0 00 0E DF F8 E0 A1 52 45 05 D3 02 D8 B9 F1 00 0F 01 D0 01 20 00 E0 00 20 51 45 03 D3 00 D8 0D B1 01 23 00 E0 00 23 B9 F1 00 0F 03 D1 52 45 08 BF 01 22 00 D0 00 22 02 92 1D B9 51 45 08 BF 01 22 00 D0 00 22 C7 F3 0A 51 0C 1B 01 92 30 B1 48 46 41 46 ?? ?? ?? ?? B0 EE 40 8B 48 E2 13 B1 28 46 39 46 F6 E7 BE F1 00 0F 1A D0 18 EA 06 03 00 F0 3E 82 17 EA 06 03 09 D0 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED 55 8B 30 E2 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED 4E 8B 26 E2 00 9B AB B1 17 EA 06 03 09 D0 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED 44 8B 17 E2 00 23 68 46 10 22 10 21 00 93 ?? ?? ?? ?? C7 F3 0A 51 40 F2 FD 33 C8 F3 0A 52 9A 42 35 DA 99 42 33 DA 39 4A B1 EE 00 0B 18 EA 0A 0F 0E D1 48 EA 02 03 43 EC 11 9B 18 EA 06 03 02 D0 31 EE 00 1B 01 E0 31 EE 40 1B 51 EC 11 9B 01 E0 08 F1 80 41 17 EA 0A 0F 0E D1 47 EA 02 03 43 EC 11 5B 17 EA 06 03 02 D0 30 EE 01 0B 01 E0 31 EE 40 0B 53 EC 10 5B 01 E0 07 F1 80 43 43 EC 18 5B C3 F3 0A 52 C1 F3 0A 53 D4 1A 41 EC 1A 9B 38 2C 0C DD 17 EA 06 03 AB D1 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED 17 8B C3 E1 14 F1 1C 0F 80 F2 8B 80 18 EA 06 03 40 F0 87 80 11 4B 9C 42 35 DA 17 EA 06 03 09 D0 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED 08 8B AB E1 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED 01 8B A1 E1 FE DE 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 80 CE FB FF FF 18 2D 44 54 FB 21 F9 3F 00 00 10 40 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 09 C0 00 00 F0 7F EF 4B 9C 42 47 DA ED 4B 00 22 43 EC 10 2B 20 EE 08 0B 80 EE 0A 0B 53 EC 10 2B 23 EA 06 04 03 EA 06 05 C4 F3 0A 53 64 3B 00 2B 04 DD 6F F3 1E 54 44 EA 03 53 20 E0 01 21 CB 1A 36 2B 61 F3 1E 54 02 DD 00 22 00 23 17 E0 58 1E C0 F1 20 03 04 FA 03 F3 C2 40 1A 43 A0 F1 20 03 24 FA 03 F3 24 FA 00 F0 42 EA 03 01 C3 07 43 EA 51 02 01 F0 01 03 00 21 D2 18 41 EB 50 03 2B 43 13 EA 0A 0F 43 EC 18 2B 40 F0 40 81 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 37 E1 88 EE 0A 8B 34 E1 14 F1 38 0F 03 DA 18 EA 06 03 7F F4 F0 AE 01 9B 93 B3 02 9B 83 B3 18 EA 06 03 16 D0 17 EA 06 03 09 D0 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED B9 8B 19 E1 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED B2 8B 0F E1 17 EA 06 03 09 D0 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED AA 8B 02 E1 00 23 02 A8 10 22 10 21 02 93 ?? ?? ?? ?? 9F ED A3 8B F8 E0 18 EA 06 03 01 D0 B1 EE 4A AB 17 EA 06 03 01 D0 B1 EE 48 8B B4 EE C8 AB F1 EE 10 FA 08 D2 B0 EE 4A 0B B0 EE 48 AB B0 EE 40 8B 4F F0 01 0E 01 E0 4F F0 00 0E 9F ED 92 0B 88 EE 0A 9B B4 EE C0 9B F1 EE 10 FA 6F DD 9F ED 8C 0B B6 EE 00 1B 53 EC 1A 1B 09 EE 00 1B 87 4A C3 F3 0A 53 40 F2 FF 34 BD EE C1 0B 1B 1B 10 EE 10 5A 58 42 9F ED 7F 1B 02 EB C5 03 00 EE 10 5A 00 EB D0 72 B8 EE 40 0B 13 ED 20 7B 14 EB 62 03 20 EE 01 6B 1B 05 00 21 43 EC 10 1B A0 EB 62 03 1B 19 20 EE 0A 1B 1B 05 00 22 43 EC 10 2B 00 EB D0 72 14 EB 62 03 21 EE 00 4B 1B 05 43 EC 10 1B A0 EB 62 03 1A 19 20 EE 08 3B 51 EC 14 3B 12 05 03 F0 78 43 00 20 41 EC 10 3B 42 EC 11 0B 20 EE 06 2B 34 EE 40 0B 23 EE 01 3B 61 4B 20 EE 06 1B 9F ED 5D 5B 33 EE 42 0B 06 EE 03 4B 30 EE 41 0B 03 EB C5 03 9F ED 56 3B 80 EE 04 4B 13 ED 20 0B 24 EE 04 1B 30 EE 04 2B 21 EE 05 0B 33 EE 40 0B 20 EE 01 0B 20 EE 04 0B 32 EE 40 9B 48 E0 9F ED 4A 0B B4 EE C0 9B F1 EE 10 FA 3F D3 9F ED 44 0B 29 EE 09 7B 9F ED 40 1B 53 EC 1A 0B 27 EE 00 0B 52 EC 19 1B 31 EE 40 0B 00 24 00 25 20 EE 07 1B 43 EC 12 4B 9F ED 36 0B 30 EE 41 0B 42 EC 16 5B 20 EE 07 3B 26 EE 02 5B 9F ED 2F 0B 3A EE 42 1B 30 EE 43 0B 39 EE 46 4B 21 EE 06 2B 38 EE 45 1B 20 EE 07 3B 24 EE 0A 4B 9F ED 25 0B 31 EE 42 1B 30 EE 43 0B 27 EE 09 5B 31 EE 44 2B 20 EE 05 1B 82 EE 0A 0B 30 EE 41 0B 39 EE 00 9B 9F ED 1A 7B BE F1 00 0F 07 D0 9F ED 16 0B 9F ED 13 1B 30 EE 47 7B 31 EE 49 9B 18 EA 06 03 07 D0 9F ED 0C 0B 9F ED 09 1B 30 EE 47 7B 31 EE 49 9B 39 EE 07 8B 17 EA 06 03 01 D0 B1 EE 48 8B B0 EE 48 0B 03 B0 BD EC 06 8B BD E8 F0 8F 63 62 1A 61 B4 10 61 3E 00 00 00 50 FB 21 09 40 07 5C 14 33 26 A6 91 3C 18 2D 44 54 FB 21 F9 3F 00 00 00 00 00 00 00 00 38 55 55 55 55 55 D5 3F A3 43 96 99 99 99 C9 3F E1 6B BD 82 24 49 C2 3F EB C4 B8 39 88 71 BC 3F C2 51 D7 92 31 0C B7 3F 3A 8C 30 E2 8E 79 45 3E 77 08 55 55 55 55 D5 3F 7D 2D 80 B9 92 99 C9 3F ?? ?? ?? ?? 00 00 00 00 00 00 70 3F ?? ?? ?? ?? 00 00 00 00 00 00 70 40 00 00 00 00 00 00 B0 3F 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 E9 BF D2 21 33 7F 7C D9 02 40 D2 21 33 7F 7C D9 02 C0 00 00 30 46 02 FC FF FF }
	condition:
		$1
}

rule file_189_3_0 {
	meta:
		name = "scaleDouble_2"
		size = 54
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 00 EB D0 72 40 F2 FF 31 11 EB 62 03 1B 05 00 24 43 EC 12 4B A0 EB 62 03 5B 18 22 EE 00 1B 1B 05 00 22 43 EC 10 2B 21 EE 00 0B BD E8 18 88 }
	condition:
		$1
}

rule file_189_4_0 {
	meta:
		name = "scaleDownDouble"
		size = 120
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 21 F0 00 44 01 F0 00 47 C4 F3 0A 51 8A 1A 00 2A 1E 46 05 46 04 DD 6F F3 1E 54 44 EA 02 52 21 E0 01 23 63 F3 1E 54 9B 1A 36 2B 02 DD 00 25 00 22 18 E0 58 1E C0 F1 20 03 04 FA 03 F3 25 FA 00 F2 1A 43 A0 F1 20 03 24 FA 03 F3 24 FA 00 F0 42 EA 03 01 C3 07 43 EA 51 02 01 F0 01 03 00 21 D5 18 41 EB 50 02 42 EA 07 03 C6 E9 00 53 BD E8 F0 88 }
	condition:
		$1
}

rule file_189_5_0 {
	meta:
		name = "scaleUpDouble1024"
		size = 68
	strings:
		$1 = { 2D E9 00 48 EB 46 0E 4B 19 42 10 D1 0B 4B B1 EE 00 0B 0B 43 11 F0 00 4F 43 EC 11 0B 02 D0 30 EE 01 0B 01 E0 31 EE 40 0B 53 EC 10 0B 01 E0 01 F1 80 43 10 60 53 60 BD E8 00 88 FE DE 00 00 10 40 00 00 F0 7F }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "fputws"
		size = 100
		refs = "0014 _errno 001c _invalid_parameter_noinfo 0032 _lock_file 003c _fputwc_nolock 0052 _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 BE 48 0D F1 18 0B 6F 46 0D 46 7D 62 04 46 44 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 03 18 E0 00 2D F4 D0 6F F0 00 03 7B 60 28 46 ?? ?? ?? ?? 20 88 40 B1 29 46 ?? ?? ?? ?? 4F F6 FF 73 98 42 03 D0 A4 1C F4 E7 00 23 7B 60 78 6A ?? ?? ?? ?? 7B 68 3B 60 38 68 BD E8 BE 08 5D F8 0C FB }
	condition:
		$1
}

rule file_191_5_0 {
	meta:
		name = "_mbctoupper_l"
		size = 138
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 004c __acrt_LCMapStringA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 8C B0 04 46 08 A8 ?? ?? ?? ?? 02 25 FF 2C 23 D9 0A 9A 23 0A DB B2 8D F8 18 30 13 44 8D F8 19 40 5B 7E 13 F0 04 0F 1F D0 01 23 04 93 53 68 D2 F8 1C 12 09 A8 03 93 07 AB 01 93 06 AB 4F F4 00 72 02 95 00 95 ?? ?? ?? ?? 70 B1 9D F8 1C 20 9D F8 1D 30 03 EB 02 24 07 E0 0A 9B 1A 19 53 7E 13 F0 20 0F 01 D0 92 F8 19 41 9D F8 2C 30 2B B1 08 9A D2 F8 50 33 AB 43 C2 F8 50 33 20 46 0C B0 BD E8 30 88 }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "??$common_fgets@D@@YAPADQADHV__crt_stdio_stream@@@Z"
		size = 136
		refs = "0016 _errno 001e _invalid_parameter_noinfo 0038 _lock_file 003e ?validate_stream_is_ansi_if_required@?$__acrt_stdio_char_traits@D@@SA_NQAU_iobuf@@@Z 004e _getc_nolock 0076 _unlock_file"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 3A 63 0E 46 80 46 40 B9 4E B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 23 2A E0 00 2E F5 DB 00 2A F3 D0 00 2E F7 D0 00 23 7B 60 10 46 ?? ?? ?? ?? 38 6B ?? ?? ?? ?? B8 B1 44 46 01 25 B5 42 0F D0 38 6B ?? ?? ?? ?? B0 F1 FF 3F 02 D1 44 45 0B D0 06 E0 20 70 64 1C C3 B2 0A 2B 01 D0 6D 1C ED E7 00 23 23 70 C7 F8 04 80 38 6B ?? ?? ?? ?? 7B 68 3B 60 38 68 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_192_2_0 {
	meta:
		name = "?fin$0@?0???$common_fgets@D@@YAPADQADHV__crt_stdio_stream@@@Z@4HA"
		size = 16
		refs = "0006 ?public_stream@__crt_stdio_stream@@QBAPAU_iobuf@@XZ 000a _unlock_file"
		altNames = "?fin$0@?0???$common_fgets@_W@@YAPA_WQA_WHV__crt_stdio_stream@@@Z@4HA"
	strings:
		$1 = { 10 B5 17 F1 30 00 ?? ?? ?? ?? ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "??$common_fgets@_W@@YAPA_WQA_WHV__crt_stdio_stream@@@Z"
		size = 130
		refs = "0016 _errno 001e _invalid_parameter_noinfo 0038 _lock_file 0046 _getwc_nolock 0070 _unlock_file"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 6F 46 3A 63 0E 46 80 46 40 B9 4E B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 23 27 E0 00 2E F5 DB 00 2A F3 D0 00 2E F7 D0 00 23 7B 60 10 46 ?? ?? ?? ?? 44 46 01 25 B5 42 10 D0 38 6B ?? ?? ?? ?? 4F F6 FF 73 98 42 02 D1 44 45 0B D0 06 E0 83 B2 23 80 A4 1C 0A 2B 01 D0 6D 1C EC E7 00 23 23 80 C7 F8 04 80 38 6B ?? ?? ?? ?? 7B 68 3B 60 38 68 BD E8 FE 09 5D F8 14 FB }
	condition:
		$1
}

rule file_192_13_0 {
	meta:
		name = "?validate_stream_is_ansi_if_required@?$__acrt_stdio_char_traits@D@@SA_NQAU_iobuf@@@Z"
		size = 148
		refs = "001c _fileno 0074 _errno 007c _invalid_parameter_noinfo 008c __badioinfo 0090 __pioinfo"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B C3 68 BF F3 5B 8F 13 F4 80 5F 18 BF 01 23 08 BF 00 23 9B BB ?? ?? ?? ?? 1B 4D 1A 4C B0 F1 FF 3F 0C D0 10 F1 02 0F 09 D0 00 F0 3F 03 81 11 03 EB 43 02 55 F8 21 30 03 EB 02 13 00 E0 23 46 93 F9 29 30 9B B9 B0 F1 FF 3F 0B D0 10 F1 02 0F 08 D0 00 F0 3F 03 81 11 03 EB 43 02 55 F8 21 30 03 EB 02 14 94 F8 2D 30 13 F0 01 0F 07 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 00 E0 01 20 BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "_calloc_base"
		size = 108
		refs = "0016 __rt_udiv 0038 _query_new_mode 0040 _callnewh 0056 _errno 0064 __imp_HeapAlloc 0068 __acrt_heap"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 0D 46 3C B1 6F F0 1F 01 00 B9 F9 DE ?? ?? ?? ?? A8 42 1B D3 04 FB 05 F4 04 B9 01 24 10 4E 0E 4B 22 46 30 68 1B 68 08 21 98 47 A0 B9 0B 4D ?? ?? ?? ?? 58 B1 20 46 ?? ?? ?? ?? 38 B1 30 68 2B 68 22 46 08 21 98 47 00 28 F1 D0 04 E0 ?? ?? ?? ?? 0C 23 03 60 00 20 BD E8 78 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "fgetpos"
		size = 62
		refs = "000c _errno 0014 _invalid_parameter_noinfo 0022 _ftelli64"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 00 0D E0 00 2C F4 D0 ?? ?? ?? ?? 02 46 0B 46 C4 E9 00 01 13 40 6F F0 00 00 83 42 18 BF 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "acos"
		size = 604
		refs = "003a _handle_nan 0054 _controlfp_s 00b2 _handle_error 024c ??_C@_04PDIFKINK@acos?$AA@"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 04 8B 85 B0 51 EC 10 4B 91 4B 9F ED 8E 6B 21 F0 00 42 9A 42 B0 EE 40 7B 03 D3 00 D8 0C B1 01 20 00 E0 00 20 C1 F3 0A 53 A3 F2 FF 32 28 B1 20 46 ?? ?? ?? ?? B0 EE 40 6B C2 E0 12 F1 38 0F 09 DA 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? 9F ED 5F 6B B5 E0 00 2A 2A DB B7 EE 00 0B B4 EE 40 7B F1 EE 10 FA 00 F0 AC 80 BF EE 00 0B B4 EE 40 7B F1 EE 10 FA 09 D1 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? 9F ED 56 6B 9A E0 21 23 02 93 08 23 01 22 6B 48 01 93 69 4B 03 92 00 92 00 22 B0 EE 46 1B B0 EE 47 0B 0D 21 ?? ?? ?? ?? C2 E7 11 F0 00 43 02 D0 B1 EE 47 8B 01 E0 B0 EE 47 8B B2 F1 FF 3F 0D DB B7 EE 00 0B B6 EE 00 1B 30 EE 48 0B 01 23 20 EE 01 9B B1 EE C9 6B B0 EE 46 8B 02 E0 00 23 28 EE 08 9B 9F ED 53 0B 9F ED 50 2B 9F ED 4D 3B 9F ED 4A 1B 9F ED 47 5B 09 EE 00 2B 9F ED 43 4B 22 EE 09 0B 29 EE 01 2B 9F ED 3E 1B 30 EE 43 0B 9F ED 3A 3B 32 EE 41 1B 00 EE 09 5B 9F ED 35 2B 01 EE 09 4B 25 EE 09 0B 24 EE 09 1B 30 EE 42 2B 9F ED 2E 0B 02 EE 09 3B 9F ED 2A 2B 31 EE 40 0B 23 EE 09 1B 00 EE 09 2B 81 EE 02 1B 6B B3 11 F0 00 43 10 D0 9F ED 1F 0B 21 EE 08 1B B0 EE 00 2B 31 EE 40 0B 9F ED 1D 1B 30 EE 06 0B 20 EE 02 0B 31 EE 40 6B 23 E0 53 EC 16 2B B0 EE 00 4B 00 21 28 EE 04 0B 43 EC 13 1B 20 EE 01 2B 23 EE 03 0B 33 EE 06 1B 39 EE 40 0B 80 EE 01 0B 00 EE 04 2B B0 EE 42 6B 03 EE 04 6B 09 E0 9F ED 0A 0B 9F ED 07 2B 01 EE 47 0B 37 EE 40 0B 32 EE 40 6B B0 EE 46 0B 05 B0 BD EC 04 8B BD E8 10 88 18 2D 44 54 FB 21 F9 3F 07 5C 14 33 26 A6 91 3C 18 2D 44 54 FB 21 09 40 28 F2 01 20 B1 D6 F5 3F EA CD 03 F9 46 46 0A 40 AC 9E 26 7E 29 7B DC 3F 34 98 02 80 41 1E CD 3F 8D F7 18 B4 4A 32 EE 3F FC CC 1D 57 21 20 06 40 59 EF B7 C1 BE A2 D1 3F 76 CE 82 29 42 1A BB 3F 90 96 C2 90 D3 28 AC 3F 35 21 A6 87 F8 E5 51 3F 61 10 32 5D 66 51 09 3F 00 00 F8 FF ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F0 7F }
	condition:
		$1
}

rule file_196_5_0 {
	meta:
		name = "_mbsnbcoll_l"
		size = 168
		refs = "001a _errno 0022 _invalid_parameter_noinfo 004a ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 005c _strncoll_l 007a __acrt_CompareStringA"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 89 B0 15 46 98 46 0E 46 07 46 0D B9 00 24 43 E0 47 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 44 39 E0 00 2E F4 D0 6F F0 00 44 A5 42 06 D9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 2C E0 04 A8 41 46 ?? ?? ?? ?? 06 9A 93 68 3B B9 43 46 2A 46 31 46 38 46 ?? ?? ?? ?? 04 46 13 E0 53 68 D2 F8 1C 12 05 A8 03 93 3B 46 4F F4 80 52 02 95 01 96 00 95 ?? ?? ?? ?? 20 B9 ?? ?? ?? ?? 16 23 03 60 00 E0 84 1E 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 09 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_197_22_0 {
	meta:
		name = "_fwrite_nolock"
		size = 390
		refs = "0018 _errno 0020 _invalid_parameter_noinfo 003a __rt_udiv 009a memcpy 00ce __acrt_stdio_flush_nolock 00fa _fileno 0102 _write 012e __acrt_stdio_flush_and_write_narrow_nolock"
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 06 46 00 96 1F 46 14 46 88 46 39 B1 34 B1 4F B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 24 20 46 BD E8 FE 8F 00 2E F3 D0 6F F0 00 01 40 46 00 B9 F9 DE ?? ?? ?? ?? 84 42 EA D8 07 F1 0C 00 03 68 01 90 BF F3 5B 8F 13 F4 98 6F 01 D0 01 23 00 E0 00 23 13 B1 D7 F8 18 90 01 E0 4F F4 80 59 08 FB 04 FA 55 46 BA F1 00 0F D9 D0 03 68 C0 22 BF F3 5B 8F 13 42 01 D0 01 23 00 E0 00 23 BB B1 BE 68 00 2E 13 D0 62 DB B5 42 00 D2 2E 46 38 68 00 99 32 46 ?? ?? ?? ?? BB 68 AD 1B 9B 1B BB 60 3B 68 33 44 3B 60 00 9B 33 44 00 93 36 E0 00 9E 4D 45 35 D3 03 68 BF F3 5B 8F 13 42 01 D0 01 23 00 E0 00 23 23 B1 38 46 ?? ?? ?? ?? 00 28 4A D1 B9 F1 00 0F 07 D0 29 46 48 46 00 B9 F9 DE ?? ?? ?? ?? 6E 1A 00 E0 2E 46 16 F1 02 0F 01 D3 6F F0 01 06 38 46 ?? ?? ?? ?? 00 99 32 46 ?? ?? ?? ?? 10 F1 01 0F 38 D0 B0 42 01 D9 33 46 00 E0 03 46 00 9A ED 1A 1A 44 00 92 B0 42 2D D3 00 9E 10 E0 16 F9 01 0B 39 46 00 96 ?? ?? ?? ?? 10 F1 01 0F 19 D0 D7 F8 18 90 6D 1E B9 F1 00 0F 01 DC 4F F0 01 09 00 2D 3F F4 6C AF 07 F1 0C 00 8E E7 BF F3 5B 8F 50 E8 00 1F 41 F0 10 02 40 E8 00 23 00 2B F7 D1 BF F3 5B 8F AA EB 05 01 40 46 00 B9 F9 DE ?? ?? ?? ?? 04 46 53 E7 BF F3 5B 8F 01 98 E8 E7 }
	condition:
		$1
}

rule file_197_23_0 {
	meta:
		name = "fwrite"
		size = 84
		refs = "001a _errno 0022 _invalid_parameter_noinfo 004e ??$?RV<lambda_cd3bfd923e8d1349099e544c97b1bd8e>@@AAV<lambda_54dcfcba6f8e0c549fa430f4d53fb7dd>@@V<lambda_5e1d0fa2aa2b73b187bf8b7e1d30c7f8>@@@?$__crt_seh_guarded_call@I@@QAAI$$QAV<lambda_cd3bfd923e8d1349099e544c97b1bd8e>@@AAV<lambda_54dcfcba6f8e0c549fa430f4d53fb7dd>@@$$QAV<lambda_5e1d0fa2aa2b73b187bf8b7e1d30c7f8>@@@Z"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 89 B0 1C 46 0F 94 0E 92 0D 91 39 B1 32 B1 5C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 09 B0 BD E8 10 08 5D F8 14 FB 0F AB 04 93 0C AB 05 93 0D AB 06 93 0E AB 07 93 01 AB 04 AA 02 A9 68 46 CD E9 01 44 ?? ?? ?? ?? E9 E7 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "atan2f"
		size = 1044
		refs = "00a6 _handle_nanf 00d0 _controlfp_s 03d4 ?atan_jby256@?1??atan2f@@9@9"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 2D ED 04 8B 83 B0 B7 EE E0 9A B7 EE C0 8A 57 EC 19 2B 55 EC 18 1B 4F F0 00 44 27 EA 04 00 52 EA 00 03 25 EA 04 06 04 D1 4F F0 01 0E CD F8 04 E0 01 E0 00 23 01 93 DF F8 D0 A3 51 EA 06 03 08 BF 01 23 18 BF 00 23 00 93 50 45 04 D3 00 D8 12 B1 4F F0 01 0E 01 E0 4F F0 00 0E 56 45 03 D3 00 D8 09 B1 01 23 00 E0 00 23 22 B9 50 45 02 D1 4F F0 01 09 01 E0 4F F0 00 09 21 B9 56 45 02 D1 4F F0 01 08 01 E0 4F F0 00 08 C7 F3 0A 52 C5 F3 0A 51 8E 1A BE F1 00 0F 05 D0 10 EE 90 0A 00 21 ?? ?? ?? ?? 71 E1 13 B1 10 EE 10 0A F7 E7 00 9B D3 B1 17 EA 04 03 00 F0 A5 80 15 EA 04 03 09 D0 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 9F ED CD 0A 5A E1 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 9F ED C7 0A 50 E1 01 9B 9B B1 15 EA 04 03 09 D0 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 9F ED BF 0A 41 E1 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 1A 2E 0C DD 15 EA 04 03 E9 D1 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 9F ED B3 0A 2B E1 16 F1 0D 0F 6D DA 17 EA 04 03 6A D1 16 F1 96 0F 16 DA 15 EA 04 03 09 D0 00 23 01 A8 12 22 12 21 01 93 ?? ?? ?? ?? 9F ED A7 0A 15 E1 00 23 01 A8 12 22 12 21 01 93 ?? ?? ?? ?? 9F ED 99 0A 0B E1 16 F1 7E 0F 48 DA 9E 4B 00 22 43 EC 10 2B 20 EE 08 0B 80 EE 09 0B 53 EC 10 2B 03 EA 04 05 23 EA 04 04 C4 F3 0A 53 64 3B 00 2B 04 DD 6F F3 1E 54 44 EA 03 53 20 E0 01 21 CB 1A 36 2B 61 F3 1E 54 02 DD 00 22 00 23 17 E0 58 1E C0 F1 20 03 04 FA 03 F3 C2 40 1A 43 A0 F1 20 03 24 FA 03 F3 24 FA 00 F0 42 EA 03 01 C3 07 43 EA 51 02 01 F0 01 03 00 21 D2 18 41 EB 50 03 2B 43 13 EA 0A 0F 43 EC 18 2B 06 D1 00 23 01 A8 12 22 12 21 01 93 ?? ?? ?? ?? B7 EE C8 0B BF E0 88 EE 09 0B B7 EE C0 0B BA E0 16 F1 1A 0F 03 DA 17 EA 04 03 7F F4 4C AF B8 F1 00 0F 33 D0 B9 F1 00 0F 30 D0 17 EA 04 03 16 D0 15 EA 04 03 09 D0 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 9F ED 69 0A 9D E0 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 9F ED 63 0A 93 E0 15 EA 04 03 09 D0 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 9F ED 5B 0A 86 E0 00 23 01 A8 10 22 10 21 01 93 ?? ?? ?? ?? 9F ED 55 0A 7C E0 17 EA 04 03 01 D0 B1 EE 49 9B 15 EA 04 03 01 D0 B1 EE 48 8B B4 EE C8 9B F1 EE 10 FA 07 D2 B0 EE 49 0B B0 EE 48 9B B0 EE 40 8B 01 21 00 E0 00 21 9F ED 46 0B 88 EE 09 5B B4 EE C0 5B F1 EE 10 FA 2B DD 9F ED 3F 1B B6 EE 00 0B 3C 4B 9F ED 3A 4B 05 EE 01 0B 29 EE 01 5B BD EE C0 0B 28 EE 01 3B 10 EE 10 2A 03 EB C2 03 00 EE 10 2A 13 ED 20 2B B8 EE 40 0B 20 EE 09 1B 00 EE 08 5B 33 EE 41 0B 80 EE 05 1B 21 EE 01 0B 32 EE 01 2B 20 EE 01 0B 20 EE 04 0B 32 EE 40 5B 1C E0 9F ED 24 0B B4 EE C0 5B F1 EE 10 FA 15 D3 9F ED 1F 0B 25 EE 05 4B 9F ED 1B 1B 9F ED 18 2B 24 EE 00 0B 24 EE 05 3B 31 EE 40 0B 20 EE 04 0B 32 EE 40 0B 20 EE 03 0B 35 EE 40 5B 19 B1 9F ED 0D 0B 30 EE 45 5B 17 EA 04 03 03 D0 9F ED 08 0B 30 EE 45 5B 15 EA 04 03 01 D0 B1 EE 45 5B B7 EE C5 0B 03 B0 BD EC 04 8B BD E8 F0 8F FE DE 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 F9 3F 38 55 55 55 55 55 D5 3F A3 43 96 99 99 99 C9 3F E1 6B BD 82 24 49 C2 3F 2D 43 1C EB E2 36 1A 3F 77 08 55 55 55 55 D5 3F ?? ?? ?? ?? 00 00 00 00 00 00 70 40 00 00 00 00 00 00 B0 3F DB 0F 49 3F DB 0F 49 BF E4 CB 16 40 E4 CB 16 C0 00 00 30 46 00 00 00 80 DB 0F C9 3F DB 0F C9 BF DB 0F 49 40 DB 0F 49 C0 00 00 F0 7F }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "fesetenv"
		size = 60
		refs = "0012 _setfpcontrolword 0018 _setfpstatusword 001e fegetenv"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 04 46 20 68 00 23 CD E9 00 33 ?? ?? ?? ?? 60 68 ?? ?? ?? ?? 68 46 ?? ?? ?? ?? 22 68 00 9B 9A 42 05 D1 62 68 01 9B 9A 42 08 BF 00 20 00 D0 01 20 BD E8 1E 88 }
	condition:
		$1
}

rule file_200_1_0 {
	meta:
		name = "??$assemble_floating_point_ind@M@__crt_strtox@@YAXAAM@Z"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 02 4B 03 60 BD E8 00 88 FE DE 00 00 C0 FF }
	condition:
		$1
}

rule file_200_2_0 {
	meta:
		name = "??$assemble_floating_point_ind@N@__crt_strtox@@YAXAAN@Z"
		size = 52
	strings:
		$1 = { 2D E9 00 48 EB 46 D0 E9 00 23 43 F0 00 43 C0 E9 00 23 11 46 1A 46 06 4B 01 60 13 43 43 60 6F F3 12 03 43 F4 00 23 00 22 C0 E9 00 23 BD E8 00 88 00 00 F0 7F }
	condition:
		$1
}

rule file_200_3_0 {
	meta:
		name = "??$assemble_floating_point_infinity@M@__crt_strtox@@YAX_NAAM@Z"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 08 B1 01 23 00 E0 00 23 DB 07 43 F0 FF 43 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_4_0 {
	meta:
		name = "??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAAN@Z"
		size = 64
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 08 B1 01 20 00 E0 00 20 D4 E9 00 23 23 F0 00 43 43 EA C0 73 C4 E9 00 23 11 46 1A 46 05 4B 21 60 13 43 63 60 6F F3 13 03 00 22 C4 E9 00 23 BD E8 18 88 00 00 F0 7F }
	condition:
		$1
}

rule file_200_5_0 {
	meta:
		name = "??$assemble_floating_point_qnan@M@__crt_strtox@@YAX_NAAM@Z"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 08 B1 01 22 00 E0 00 22 6F F0 00 43 43 EA C2 73 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_6_0 {
	meta:
		name = "??$assemble_floating_point_qnan@N@__crt_strtox@@YAX_NAAN@Z"
		size = 72
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 08 B1 01 20 00 E0 00 20 D4 E9 00 23 23 F0 00 43 43 EA C0 73 C4 E9 00 23 11 46 1A 46 07 4B 21 60 6F F0 00 01 13 43 C4 E9 00 13 1A 46 4F F4 80 13 5B 1E 13 43 63 60 BD E8 18 88 00 00 F0 7F }
	condition:
		$1
}

rule file_200_7_0 {
	meta:
		name = "??$assemble_floating_point_snan@M@__crt_strtox@@YAX_NAAM@Z"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 08 B1 01 22 00 E0 00 22 03 4B 43 EA C2 73 0B 60 BD E8 00 88 FE DE 01 00 80 7F }
	condition:
		$1
}

rule file_200_8_0 {
	meta:
		name = "??$assemble_floating_point_snan@N@__crt_strtox@@YAX_NAAN@Z"
		size = 64
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 08 B1 01 20 00 E0 00 20 D4 E9 00 23 23 F0 00 43 43 EA C0 73 C4 E9 00 23 11 46 1A 46 05 4B 21 60 13 43 63 60 6F F3 13 03 01 22 C4 E9 00 23 BD E8 18 88 00 00 F0 7F }
	condition:
		$1
}

rule file_200_9_0 {
	meta:
		name = "??$assemble_floating_point_value_t@M@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAAM@Z"
		size = 36
	strings:
		$1 = { 2D E9 00 48 EB 46 01 F1 7F 03 DB 05 03 F0 FF 43 6F F3 DF 52 13 43 43 EA C0 72 02 9B 00 20 1A 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_10_0 {
	meta:
		name = "??$assemble_floating_point_value_t@N@__crt_strtox@@YA?AW4SLD_STATUS@@_NH_KAAN@Z"
		size = 70
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 06 9E D6 E9 00 54 24 F0 00 44 44 EA C0 70 C6 E9 00 50 01 F2 FF 34 71 68 6F F3 DF 24 28 46 6F F3 1E 51 41 EA 04 51 C6 E9 00 01 59 40 73 68 6F F3 1F 51 32 60 4B 40 73 60 00 20 BD E8 78 88 }
	condition:
		$1
}

rule file_200_11_0 {
	meta:
		name = "??$assemble_floating_point_zero@M@__crt_strtox@@YAX_NAAM@Z"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 08 B1 01 23 00 E0 00 23 DB 07 0B 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_12_0 {
	meta:
		name = "??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAAN@Z"
		size = 58
	strings:
		$1 = { 2D E9 00 48 EB 46 08 B1 01 20 00 E0 00 20 D1 E9 00 23 23 F0 00 43 43 EA C0 73 C1 E9 00 23 13 46 4A 68 0B 60 6F F3 1E 52 13 46 4A 60 6F F3 13 03 00 22 C1 E9 00 23 BD E8 00 88 }
	condition:
		$1
}

rule file_200_13_0 {
	meta:
		name = "??$common_cscanf@D@@YAH_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 128
		refs = "0008 __security_push_cookie 0018 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0032 memset 005e ?process@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QAAHXZ 0078 __security_pop_cookie"
		altNames = "__conio_common_vcscanf"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? A0 B0 0D 46 04 46 68 46 19 46 16 46 ?? ?? ?? ?? 00 23 13 A8 20 22 00 21 CD E9 05 53 CD E9 0A 63 04 94 CD E9 08 45 ?? ?? ?? ?? 00 23 0C 93 AD F8 34 30 8D F8 36 30 CD E9 0E 33 10 93 8D F8 44 30 12 93 01 AB 1C 93 26 9B 04 A8 1D 93 00 23 CD E9 1E 33 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 B0 ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_200_14_0 {
	meta:
		name = "??$common_cscanf@_W@@YAH_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 122
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 004e ?process@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAAHXZ 0056 _free_base"
		altNames = "__conio_common_vcwscanf"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 9B B0 0D 46 04 46 68 46 19 46 16 46 ?? ?? ?? ?? 00 23 CD E9 05 53 CD E9 0B 33 CD E9 14 33 0D 93 8D F8 38 30 CD E9 10 33 12 93 8D F8 4C 30 01 AB 16 93 20 9B 04 A8 04 94 17 93 00 23 CD E9 18 33 CD E9 08 45 0A 96 ?? ?? ?? ?? 04 46 15 98 ?? ?? ?? ?? 00 23 15 93 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 1B B0 BD E8 70 88 }
	condition:
		$1
}

rule file_200_15_0 {
	meta:
		name = "??$convert_decimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAM@Z"
		size = 26
		refs = "0012 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 00 91 00 23 69 46 8D F8 04 30 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_200_17_0 {
	meta:
		name = "??$convert_hexadecimal_string_to_floating_type@M@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAM@Z"
		size = 26
		refs = "0012 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 00 91 00 23 69 46 8D F8 04 30 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_200_16_0 {
	meta:
		name = "??$convert_decimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAN@Z"
		size = 26
		refs = "0012 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 00 91 01 23 69 46 8D F8 04 30 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_200_18_0 {
	meta:
		name = "??$convert_hexadecimal_string_to_floating_type@N@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@0@AAN@Z"
		size = 26
		refs = "0012 ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 00 91 01 23 69 46 8D F8 04 30 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_200_25_0 {
	meta:
		name = "??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
		size = 60
	strings:
		$1 = { 2D E9 00 48 EB 46 19 46 10 F0 04 0F 01 D0 01 20 12 E0 10 F0 01 0F 0E D0 10 F0 02 03 05 D0 B1 F1 00 4F 02 D3 F3 D8 00 2A F1 D1 23 B9 6F F0 00 43 99 42 00 D3 EB D8 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_26_0 {
	meta:
		name = "??$istspace@ABE@?$__crt_char_traits@D@@SAHABE@Z"
		size = 16
		refs = "000c isspace"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 78 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_27_0 {
	meta:
		name = "??$istspace@AB_W@?$__crt_char_traits@_W@@SAHAB_W@Z"
		size = 18
		refs = "000e iswctype"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 88 08 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_28_0 {
	meta:
		name = "??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z"
		size = 32
		altNames = "??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z ??$make_input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QAV?$string_input_adapter@D@__crt_stdio_input@@_KQA_N@Z ??$make_input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QAV?$string_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA@QAV?$string_input_adapter@D@__crt_stdio_input@@_KQA_N@Z ??0?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA@QAV?$string_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 E9 02 23 00 23 C0 E9 04 33 02 9B 01 60 83 61 0B B1 01 22 1A 70 BD E8 00 88 }
	condition:
		$1
}

rule file_200_30_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAM@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_200_31_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAN@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_200_32_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_200_33_4 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_452_45_4 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAM@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_452_46_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAN@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_452_47_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_452_48_2 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_452_49_4 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QAM@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_452_50_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@QAN@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_452_51_0 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_452_52_3 {
	meta:
		name = "??$parse_floating_point@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z"
		size = 102
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 003e ??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z 0046 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 005e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 7D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 01 20 11 E0 00 28 ED D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? A1 69 29 B1 D4 E9 04 23 13 43 01 D1 00 23 0B 70 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_200_34_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z"
		size = 1156
		refs = "001c _errno 0024 _invalid_parameter_noinfo 0036 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 005a _isctype_l 006e __pctype_func 0114 _ungetch_nolock 0246 ??R<lambda_dfcc39eeb01418904072ef28aad1c215>@@QBA_NXZ 0466 ??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@_K@Z 0474 ??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8B B0 0C 46 23 68 07 46 90 46 04 92 02 97 0B B1 A3 69 3B B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 07 20 25 E2 23 69 20 46 06 93 63 69 07 93 ?? ?? ?? ?? 6B 46 CD E9 08 43 06 AB 0A 93 8D F8 00 00 C5 B2 87 B1 3A 68 53 68 01 2B 06 DD 3A 46 08 21 28 46 ?? ?? ?? ?? 03 46 0B E0 13 68 33 F8 15 30 03 F0 08 03 07 E0 ?? ?? ?? ?? 30 F8 15 30 03 F0 08 03 9D F9 00 00 1B B1 20 46 ?? ?? ?? ?? DD E7 2D 28 08 BF 01 23 18 BF 00 23 88 F8 08 33 2D 28 01 D0 2B 28 04 D1 20 46 ?? ?? ?? ?? 8D F8 00 00 49 28 00 F0 DF 81 69 28 00 F0 DC 81 4E 28 00 F0 D2 81 6E 28 00 F0 CF 81 4F F0 00 0A 6F EA 0A 09 30 28 31 D1 D4 E9 04 56 20 46 ?? ?? ?? ?? 78 28 21 D0 58 28 1F D0 D4 E9 04 32 A1 68 13 EB 09 03 42 EB 09 02 C4 E9 04 32 E2 68 51 EA 02 03 06 D0 D4 E9 04 53 93 42 0B D8 01 D3 8D 42 08 D8 38 B1 48 45 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 9D F9 00 00 08 E0 20 46 4F F0 01 0A ?? ?? ?? ?? 8D F8 00 00 CD E9 06 56 08 F1 08 09 08 F5 42 76 00 25 03 96 C8 46 01 95 30 28 07 D1 01 25 20 46 ?? ?? ?? ?? 8D F8 00 00 30 28 F8 D0 00 27 BA F1 00 0F 18 BF 0F 22 08 BF 09 22 30 28 04 DB 39 28 02 DC A0 F1 30 03 0F E0 61 28 04 DB 7A 28 02 DC A0 F1 57 03 08 E0 41 28 04 DB 5A 28 02 DC A0 F1 37 03 01 E0 6F F0 00 03 93 42 0C D8 01 25 B0 45 02 D0 88 F8 00 30 A8 44 20 46 7F 1C ?? ?? ?? ?? 8D F8 00 00 D3 E7 01 97 02 9F 3B 68 D3 F8 88 30 1B 68 93 F9 00 30 98 42 3F D1 20 46 ?? ?? ?? ?? 8D F8 00 00 C8 45 0D D1 30 28 0B D1 01 9E 01 25 20 46 76 1E ?? ?? ?? ?? 8D F8 00 00 30 28 F7 D0 01 96 03 9E BA F1 00 0F 18 BF 0F 22 08 BF 09 22 30 28 04 DB 39 28 02 DC A0 F1 30 03 0F E0 61 28 04 DB 7A 28 02 DC A0 F1 57 03 08 E0 41 28 04 DB 5A 28 02 DC A0 F1 37 03 01 E0 6F F0 00 03 93 42 0B D8 01 25 B0 45 02 D0 88 F8 00 30 A8 44 20 46 ?? ?? ?? ?? 8D F8 00 00 D4 E7 5D B9 08 A8 ?? ?? ?? ?? 00 28 3F F4 EC AE BA F1 00 0F 3F F4 E8 AE 02 20 0D E1 D4 E9 04 32 6F F0 00 07 D4 E9 02 51 DB 19 7A 41 C4 E9 04 32 55 EA 01 03 06 D0 D4 E9 04 23 8B 42 0B D8 01 D3 AA 42 08 D8 38 B1 B8 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 23 69 20 46 06 93 63 69 07 93 ?? ?? ?? ?? 00 23 8D F8 00 00 45 28 07 D0 50 28 03 D0 65 28 03 D0 70 28 07 D1 53 46 05 E0 BA F1 00 0F 08 BF 01 23 18 BF 00 23 00 26 00 2B 41 F2 50 49 78 D0 20 46 ?? ?? ?? ?? 2D 28 08 BF 01 27 18 BF 00 27 2B 28 8D F8 00 00 01 D0 2D 28 04 D1 20 46 ?? ?? ?? ?? 8D F8 00 00 00 25 30 28 08 D1 01 25 20 46 ?? ?? ?? ?? 8D F8 00 00 30 28 F8 D0 30 28 06 DB 39 28 04 DC A0 F1 30 02 6F F0 00 01 10 E0 61 28 04 DB 7A 28 02 DC A0 F1 57 02 F5 E7 41 28 04 DB 5A 28 02 DC A0 F1 37 02 EE E7 6F F0 00 01 0A 46 0A 2A 0E D2 06 EB 86 03 02 EB 43 06 01 25 4E 45 05 DC 20 46 ?? ?? ?? ?? 8D F8 00 00 D6 E7 41 F2 51 46 30 28 04 DB 39 28 02 DC A0 F1 30 03 0E E0 61 28 04 DB 7A 28 02 DC A0 F1 57 03 07 E0 41 28 04 DB 5A 28 02 DC A0 F1 37 03 00 E0 0B 46 0A 2B 07 D2 20 46 ?? ?? ?? ?? 8D F8 00 00 6F F0 00 01 DF E7 07 B1 76 42 55 B9 08 A8 ?? ?? ?? ?? 00 28 3F F4 38 AE 20 46 ?? ?? ?? ?? 8D F8 00 00 6F F0 00 07 D4 E9 04 32 D4 E9 02 51 DB 19 7A 41 C4 E9 04 32 55 EA 01 03 06 D0 D4 E9 04 23 8B 42 0B D8 01 D3 AA 42 08 D8 38 B1 B8 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 04 98 00 F1 08 01 88 45 3F F4 28 AF 18 F8 01 3C 1B B9 A8 F1 01 08 88 45 F8 D1 88 45 3F F4 1E AF 4E 45 01 DD 09 20 29 E0 16 4A 96 42 01 DA 08 20 24 E0 01 9D BA F1 00 0F 18 BF 04 23 08 BF 01 23 03 FB 05 63 4B 45 ED DC 93 42 F0 DB 03 60 A8 EB 01 03 BA F1 00 0F 43 60 18 BF 01 20 0E D1 00 20 0C E0 DD E9 06 23 68 46 21 46 ?? ?? ?? ?? 05 E0 DD E9 06 23 68 46 21 46 ?? ?? ?? ?? 0B B0 BD E8 F0 8F FE DE B0 EB FF FF }
	condition:
		$1
}

rule file_200_35_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@AAUfloating_point_string@0@@Z"
		size = 2344
		refs = "001a _errno 0022 _invalid_parameter_noinfo 0036 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 004a iswctype 00f0 _ungetwch_nolock 048c ??R<lambda_98f31d9ba9b79953c6b659ba96648114>@@QBA_NXZ 090c ??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@_K@Z 091a ??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8F B0 0F 46 3B 68 91 46 08 92 06 90 0B B1 BB 69 43 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 07 20 00 F0 79 BC 3B 69 38 46 0A 93 7B 69 0B 93 ?? ?? ?? ?? 6B 46 CD E9 0C 73 0A AB 0E 93 08 21 AD F8 00 00 ?? ?? ?? ?? 18 B1 38 46 ?? ?? ?? ?? F5 E7 BD F8 00 00 2D 28 08 BF 01 23 18 BF 00 23 89 F8 08 33 2D 28 01 D0 2B 28 04 D1 38 46 ?? ?? ?? ?? AD F8 00 00 49 28 00 F0 48 84 69 28 00 F0 45 84 4E 28 00 F0 3B 84 6E 28 00 F0 38 84 4F F0 00 08 CD F8 1C 80 4F F6 FF 7A 30 28 35 D1 D7 E9 04 45 38 46 ?? ?? ?? ?? 78 28 23 D0 58 28 21 D0 D7 E9 04 32 6F EA 08 0E B9 68 13 EB 0E 03 42 EB 0E 02 C7 E9 04 32 FA 68 51 EA 02 03 06 D0 D7 E9 04 43 93 42 0B D8 01 D3 8C 42 08 D8 38 B1 50 45 05 D0 3A 68 13 68 5B 1E 13 60 ?? ?? ?? ?? BD F8 00 00 0A E0 4F F0 01 08 38 46 CD F8 1C 80 ?? ?? ?? ?? AD F8 00 00 CD E9 0A 45 09 F1 08 0A 00 24 09 F5 42 75 CD F8 14 A0 D1 46 CD E9 01 4A 30 28 07 D1 01 24 38 46 ?? ?? ?? ?? AD F8 00 00 30 28 F8 D0 4F F6 10 76 4F F4 CC 6A B8 F1 00 0F 18 BF 0F 22 08 BF 09 22 30 28 40 F6 E6 1E 40 F6 66 11 4F F4 DE 63 C0 F0 8D 80 3A 28 02 D2 A0 F1 30 03 84 E0 B0 42 7B D2 50 45 C0 F0 83 80 40 F2 6A 66 B0 42 4F F6 10 76 02 D2 A0 EB 0A 03 76 E0 98 42 77 D3 40 F2 FA 6A 50 45 4F F4 CC 6A 01 D2 C3 1A 6C E0 88 42 6D D3 B0 F5 17 6F 38 BF 43 1A 65 D3 70 45 66 D3 B0 F5 1F 6F 02 D2 A0 EB 0E 03 5D E0 40 F6 66 23 98 42 5C D3 B0 F5 27 6F E7 D3 40 F6 E6 23 98 42 55 D3 B0 F5 2F 6F E0 D3 40 F6 66 33 98 42 4E D3 B0 F5 37 6F D9 D3 40 F6 66 43 98 42 47 D3 B0 F5 47 6F D2 D3 40 F6 E6 43 98 42 40 D3 B0 F5 4F 6F CB D3 40 F6 66 53 98 42 39 D3 B0 F5 57 6F C4 D3 4F F4 65 63 98 42 32 D3 40 F6 5A 61 88 42 BC D3 4F F4 6D 63 98 42 2A D3 40 F6 DA 61 88 42 B4 D3 50 33 98 42 23 D3 50 31 88 42 AE D3 4F F4 82 53 98 42 1C D3 41 F2 4A 01 88 42 A6 D3 4F F4 BF 53 98 42 14 D3 41 F2 EA 71 88 42 9E D3 30 33 98 42 0D D3 30 31 88 42 0A D2 97 E7 4F F6 1A 73 98 42 6F F0 00 03 38 BF 83 1B 13 F1 01 0F 13 D1 41 28 01 D3 5A 28 03 D9 61 28 0B D3 7A 28 09 D8 61 28 04 D3 7A 28 02 D8 A0 F1 20 03 00 E0 03 46 37 3B 01 E0 6F F0 00 03 93 42 0E D8 01 24 A9 45 02 D0 89 F8 00 30 A1 44 01 9B 38 46 5B 1C 01 93 ?? ?? ?? ?? AD F8 00 00 3E E7 DD E9 05 A6 CD F8 08 90 33 68 D3 F8 88 30 1B 68 93 F9 00 30 98 42 40 F0 D6 80 38 46 ?? ?? ?? ?? AD F8 00 00 D1 45 11 D1 30 28 0F D1 DD F8 04 90 01 24 38 46 A9 F1 01 09 ?? ?? ?? ?? AD F8 00 00 30 28 F6 D0 CD F8 04 90 DD F8 08 90 4F F6 10 76 4F F4 CC 6A B8 F1 00 0F 18 BF 0F 22 08 BF 09 22 30 28 C0 F0 8A 80 3A 28 02 D2 A0 F1 30 03 81 E0 B0 42 78 D2 50 45 C0 F0 80 80 40 F2 6A 63 98 42 02 D2 A0 EB 0A 03 75 E0 4F F4 DE 63 98 42 74 D3 40 F2 FA 61 88 42 01 D2 C3 1A 6B E0 40 F6 66 13 98 42 6A D3 B0 F5 17 6F F6 D3 40 F6 E6 13 98 42 63 D3 B0 F5 1F 6F EF D3 40 F6 66 23 98 42 5C D3 B0 F5 27 6F E8 D3 40 F6 E6 23 98 42 55 D3 B0 F5 2F 6F E1 D3 40 F6 66 33 98 42 4E D3 B0 F5 37 6F DA D3 40 F6 66 43 98 42 47 D3 B0 F5 47 6F D3 D3 40 F6 E6 43 98 42 40 D3 B0 F5 4F 6F CC D3 40 F6 66 53 98 42 39 D3 B0 F5 57 6F C5 D3 4F F4 65 63 98 42 32 D3 40 F6 5A 61 88 42 BD D3 4F F4 6D 63 98 42 2A D3 40 F6 DA 61 88 42 B5 D3 50 33 98 42 23 D3 50 31 88 42 AF D3 4F F4 82 53 98 42 1C D3 41 F2 4A 01 88 42 A7 D3 4F F4 BF 53 98 42 14 D3 41 F2 EA 71 88 42 9F D3 30 33 98 42 0D D3 30 31 88 42 0A D2 98 E7 4F F6 1A 73 98 42 6F F0 00 03 38 BF 83 1B 13 F1 01 0F 13 D1 41 28 01 D3 5A 28 03 D9 61 28 0B D3 7A 28 09 D8 61 28 04 D3 7A 28 02 D8 A0 F1 20 03 00 E0 03 46 37 3B 01 E0 6F F0 00 03 93 42 0B D8 01 24 A9 45 02 D0 89 F8 00 30 A1 44 38 46 ?? ?? ?? ?? AD F8 00 00 4A E7 DD F8 14 A0 CD F8 08 90 5C B9 0C A8 ?? ?? ?? ?? 00 28 3F F4 C8 AD B8 F1 00 0F 3F F4 C4 AD 02 20 3D E2 D7 E9 04 32 6F F0 00 01 BC 68 5B 18 4A 41 C7 E9 04 32 FA 68 54 EA 02 03 06 D0 D7 E9 04 13 93 42 0D D8 01 D3 A1 42 0A D8 48 B1 4F F6 FF 73 98 42 05 D0 3A 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 3B 69 38 46 0A 93 7B 69 0B 93 ?? ?? ?? ?? 00 23 AD F8 00 00 45 28 07 D0 50 28 03 D0 65 28 03 D0 70 28 07 D1 43 46 05 E0 B8 F1 00 0F 08 BF 01 23 18 BF 00 23 00 25 03 95 41 F2 50 48 00 2B 00 F0 A6 81 38 46 ?? ?? ?? ?? 2D 28 08 BF 01 26 18 BF 00 26 06 96 AD F8 00 00 2B 28 01 D0 2D 28 04 D1 38 46 ?? ?? ?? ?? AD F8 00 00 00 24 04 94 30 28 09 D1 01 24 04 94 38 46 ?? ?? ?? ?? AD F8 00 00 30 28 F8 D0 30 28 C0 F0 8A 80 3A 28 02 D2 A0 F1 30 02 80 E0 4F F6 10 73 98 42 76 D2 4F F4 CC 63 98 42 7C D3 40 F2 6A 62 90 42 01 D2 C2 1A 72 E0 4F F4 DE 63 98 42 72 D3 40 F2 FA 62 90 42 F5 D3 40 F6 66 13 98 42 6A D3 B0 F5 17 6F EE D3 40 F6 E6 13 98 42 63 D3 B0 F5 1F 6F E7 D3 40 F6 66 23 98 42 5C D3 B0 F5 27 6F E0 D3 40 F6 E6 23 98 42 55 D3 B0 F5 2F 6F D9 D3 40 F6 66 33 98 42 4E D3 B0 F5 37 6F D2 D3 40 F6 66 43 98 42 47 D3 B0 F5 47 6F CB D3 40 F6 E6 43 98 42 40 D3 B0 F5 4F 6F C4 D3 40 F6 66 53 98 42 39 D3 B0 F5 57 6F BD D3 4F F4 65 63 98 42 32 D3 40 F6 5A 62 90 42 B5 D3 4F F4 6D 63 98 42 2A D3 40 F6 DA 62 90 42 AD D3 50 33 98 42 23 D3 50 32 90 42 A7 D3 4F F4 82 53 98 42 1C D3 41 F2 4A 02 90 42 9F D3 4F F4 BF 53 98 42 14 D3 41 F2 EA 72 90 42 97 D3 30 33 98 42 0D D3 30 32 90 42 0A D2 90 E7 4F F6 1A 72 90 42 8C D3 6F F0 00 02 6F F0 00 03 9A 42 14 D1 41 28 01 D3 5A 28 03 D9 61 28 0C D3 7A 28 0A D8 61 28 04 D3 7A 28 02 D8 A0 F1 20 03 00 E0 03 46 A3 F1 37 02 01 E0 6F F0 00 02 0A 2A 11 D2 05 EB 85 03 02 EB 43 05 01 24 CD E9 03 54 45 45 05 DC 38 46 ?? ?? ?? ?? AD F8 00 00 4C E7 41 F2 51 45 03 95 4F F6 10 78 4F F4 CC 6A 4F F4 DE 66 40 F6 66 14 40 F6 E6 15 40 F6 66 29 30 28 C0 F0 8E 80 3A 28 02 D2 A0 F1 30 03 84 E0 40 45 79 D2 50 45 C0 F0 84 80 40 F2 6A 63 98 42 02 D2 A0 EB 0A 03 78 E0 B0 42 7A D3 40 F2 FA 63 98 42 38 BF 83 1B 70 D3 A0 42 72 D3 B0 F5 17 6F 38 BF 03 1B 69 D3 A8 42 6B D3 B0 F5 1F 6F 38 BF 43 1B 62 D3 48 45 64 D3 B0 F5 27 6F 02 D2 A0 EB 09 03 5A E0 40 F6 E6 23 98 42 5A D3 B0 F5 2F 6F 01 D2 C3 1A 51 E0 40 F6 66 33 98 42 51 D3 B0 F5 37 6F F6 D3 40 F6 66 43 98 42 4A D3 B0 F5 47 6F EF D3 40 F6 E6 43 98 42 43 D3 B0 F5 4F 6F E8 D3 40 F6 66 53 98 42 3C D3 B0 F5 57 6F E1 D3 4F F4 65 63 98 42 35 D3 40 F6 5A 62 90 42 D9 D3 4F F4 6D 63 98 42 2D D3 40 F6 DA 62 90 42 D1 D3 50 33 98 42 26 D3 50 32 90 42 CB D3 4F F4 82 53 98 42 1F D3 41 F2 4A 02 90 42 C3 D3 4F F4 BF 53 98 42 17 D3 41 F2 EA 72 90 42 BB D3 30 33 98 42 10 D3 30 32 90 42 0D D2 B4 E7 4F F6 1A 73 98 42 02 D2 A0 EB 08 03 01 E0 6F F0 00 03 6F F0 00 02 93 42 13 D1 41 28 01 D3 5A 28 03 D9 61 28 0B D3 7A 28 09 D8 61 28 04 D3 7A 28 02 D8 A0 F1 20 03 00 E0 03 46 37 3B 01 E0 6F F0 00 03 0A 2B 05 D2 38 46 ?? ?? ?? ?? AD F8 00 00 52 E7 DD E9 05 A6 DD E9 03 54 DD F8 08 90 41 F2 50 48 06 B1 6D 42 54 B9 0C A8 ?? ?? ?? ?? 00 28 3F F4 E1 AB 38 46 ?? ?? ?? ?? AD F8 00 00 D7 E9 04 32 6F F0 00 01 5B 18 4A 41 B9 68 C7 E9 04 32 FA 68 51 EA 02 03 06 D0 D7 E9 04 43 93 42 0D D8 01 D3 8C 42 0A D8 48 B1 4F F6 FF 73 98 42 05 D0 3A 68 13 68 5B 1E 13 60 ?? ?? ?? ?? D1 45 3F F4 F6 AD 19 F8 01 3C 1B B9 A9 F1 01 09 D1 45 F8 D1 D1 45 3F F4 EC AD 45 45 01 DD 09 20 27 E0 15 4A 95 42 01 DA 08 20 22 E0 07 99 09 B1 04 23 00 E0 01 23 01 9C 03 FB 04 53 43 45 EE DC 93 42 F1 DB 08 9A 13 60 A9 EB 0A 03 53 60 09 B1 01 20 0E E0 00 20 0C E0 DD E9 0A 23 68 46 39 46 ?? ?? ?? ?? 05 E0 DD E9 0A 23 68 46 39 46 ?? ?? ?? ?? 0F B0 BD E8 F0 8F B0 EB FF FF }
	condition:
		$1
}

rule file_200_36_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 288
		refs = "0032 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 0078 _ungetch_nolock 00fc ??R<lambda_2a4fdd323818dc2cff2f25dd401c4574>@@QBA_NXZ 0110 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0114 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0118 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 011c ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB"
	strings:
		$1 = { 0F B4 2D E9 FF 4B 0D F1 28 0B 0C 46 06 46 0E AB 42 4F DF F8 04 81 CD E9 00 46 02 93 00 25 96 F9 00 20 EB 57 9A 42 03 D0 15 F9 08 30 9A 42 64 D1 20 46 ?? ?? ?? ?? 6D 1C 03 2D 30 70 EF D1 D4 E9 04 32 6F F0 00 09 D4 E9 02 15 13 EB 09 03 42 EB 09 02 C4 E9 04 32 51 EA 05 03 06 D0 D4 E9 04 23 AB 42 0B D8 01 D3 8A 42 08 D8 38 B1 48 45 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 23 69 20 46 0E 93 63 69 0F 93 ?? ?? ?? ?? 22 4F DF F8 80 80 30 70 00 25 96 F9 00 20 EB 57 9A 42 03 D0 15 F9 08 30 9A 42 2E D1 20 46 ?? ?? ?? ?? 6D 1C 05 2D 30 70 EF D1 D4 E9 04 32 D4 E9 02 15 13 EB 09 03 42 EB 09 02 C4 E9 04 32 51 EA 05 03 06 D0 D4 E9 04 23 AB 42 0B D8 01 D3 8A 42 08 D8 38 B1 48 45 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 03 20 04 B0 BD E8 F0 0B 5D F8 14 FB 68 46 ?? ?? ?? ?? 07 20 F5 E7 68 46 ?? ?? ?? ?? 00 28 EF D1 F7 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_37_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 292
		refs = "0030 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 007a _ungetwch_nolock 00fe ??R<lambda_8ab1cb5bdccd73fa737a005aefa23fc8>@@QBA_NXZ 0114 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0118 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 011c ?inf_lowercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 0120 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB"
	strings:
		$1 = { 0F B4 2D E9 FE 4F 0D F1 28 0B 0C 46 06 46 0E AB 43 4F DF F8 08 81 CD E9 00 46 02 93 00 25 32 88 EB 5B 9A 42 03 D0 35 F8 08 30 9A 42 66 D1 20 46 ?? ?? ?? ?? AD 1C 06 2D 30 80 F0 D1 D4 E9 04 32 6F F0 00 0A D4 E9 02 51 13 EB 0A 03 42 EB 0A 02 C4 E9 04 32 55 EA 01 03 4F F6 FF 77 06 D0 D4 E9 04 23 8B 42 0B D8 01 D3 AA 42 08 D8 38 B1 B8 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 23 69 20 46 0E 93 63 69 0F 93 ?? ?? ?? ?? DF F8 88 80 DF F8 80 90 30 80 00 25 32 88 35 F8 08 30 9A 42 03 D0 35 F8 09 30 9A 42 2D D1 20 46 ?? ?? ?? ?? AD 1C 0A 2D 30 80 EF D1 D4 E9 04 32 D4 E9 02 15 13 EB 0A 03 42 EB 0A 02 C4 E9 04 32 51 EA 05 03 06 D0 D4 E9 04 23 AB 42 0B D8 01 D3 8A 42 08 D8 38 B1 B8 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 03 20 BD E8 FE 0F 5D F8 14 FB 68 46 ?? ?? ?? ?? 07 20 F6 E7 68 46 ?? ?? ?? ?? 00 28 F0 D1 F7 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_38_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@_K@Z"
		size = 396
		refs = "0032 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 0074 _ungetch_nolock 008e ??R<lambda_2ae569978801c347efc54b41596a5e71>@@QBA_NXZ 00ae ??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z 00f6 ??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z 0184 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB 0188 ?uppercase@?1???$parse_floating_point_possible_nan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@_K@Z@4QBDB"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 0C 46 05 46 0C AB 5D 4F DF F8 70 81 CD E9 00 45 02 93 00 26 95 F9 00 20 F3 57 9A 42 03 D0 16 F9 08 30 9A 42 33 D1 20 46 ?? ?? ?? ?? 76 1C 03 2E 28 70 EF D1 D4 E9 04 32 6F F0 00 07 D4 E9 02 16 DB 19 7A 41 C4 E9 04 32 51 EA 06 03 06 D0 D4 E9 04 23 B3 42 0B D8 01 D3 8A 42 08 D8 38 B1 B8 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 23 69 20 46 0C 93 63 69 0D 93 ?? ?? ?? ?? 28 70 28 28 0A D0 68 46 ?? ?? ?? ?? 00 28 70 D1 02 E0 68 46 ?? ?? ?? ?? 07 20 6B E0 20 46 ?? ?? ?? ?? 28 70 28 46 21 46 ?? ?? ?? ?? F0 B1 D4 E9 04 32 95 F9 00 00 D4 E9 02 15 DB 19 7A 41 C4 E9 04 32 51 EA 05 03 06 D0 D4 E9 04 23 AB 42 0B D8 01 D3 8A 42 08 D8 38 B1 B8 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 05 20 43 E0 21 46 28 46 ?? ?? ?? ?? F0 B1 D4 E9 04 32 95 F9 00 00 D4 E9 02 15 DB 19 7A 41 C4 E9 04 32 51 EA 05 03 06 D0 D4 E9 04 23 AB 42 0B D8 01 D3 8A 42 08 D8 38 B1 B8 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 06 20 1F E0 95 F9 00 30 29 2B 16 D0 95 F9 00 20 9A B1 A2 F1 30 03 09 2B 09 D9 A2 F1 61 03 19 2B 05 D9 A2 F1 41 03 19 2B 01 D9 5F 2A 93 D1 20 46 ?? ?? ?? ?? 28 70 29 28 E8 D1 95 F9 00 30 29 2B 89 D1 04 20 BD E8 FE 09 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_39_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@0@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@_K@Z"
		size = 400
		refs = "0030 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 007a _ungetwch_nolock 0094 ??R<lambda_136dcf69874064575ae1b89ff2a94cd1>@@QBA_NXZ 00b4 ??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z 00fe ??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z 0188 ?lowercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB 018c ?uppercase@?1???$parse_floating_point_possible_nan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@_K@__crt_strtox@@YA?AW4floating_point_parse_result@1@AA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@_K@Z@4QB_WB"
	strings:
		$1 = { 0F B4 2D E9 FE 49 0D F1 20 0B 0C 46 05 46 0C AB 5E 4F DF F8 74 81 CD E9 00 45 02 93 00 26 2A 88 F3 5B 9A 42 03 D0 36 F8 08 30 9A 42 37 D1 20 46 ?? ?? ?? ?? B6 1C 06 2E 28 80 F0 D1 D4 E9 04 32 6F F0 00 08 D4 E9 02 71 13 EB 08 03 42 EB 08 02 C4 E9 04 32 57 EA 01 03 4F F6 FF 76 06 D0 D4 E9 04 23 8B 42 0B D8 01 D3 BA 42 08 D8 38 B1 B0 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 23 69 20 46 0C 93 63 69 0D 93 ?? ?? ?? ?? 28 80 28 28 0A D0 68 46 ?? ?? ?? ?? 00 28 6F D1 02 E0 68 46 ?? ?? ?? ?? 07 20 6A E0 20 46 ?? ?? ?? ?? 28 80 28 46 21 46 ?? ?? ?? ?? F8 B1 D4 E9 04 32 28 88 D4 E9 02 15 13 EB 08 03 42 EB 08 02 C4 E9 04 32 51 EA 05 03 06 D0 D4 E9 04 23 AB 42 0B D8 01 D3 8A 42 08 D8 38 B1 B0 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 05 20 41 E0 21 46 28 46 ?? ?? ?? ?? F8 B1 D4 E9 04 32 28 88 D4 E9 02 15 13 EB 08 03 42 EB 08 02 C4 E9 04 32 51 EA 05 03 06 D0 D4 E9 04 23 AB 42 0B D8 01 D3 8A 42 08 D8 38 B1 B0 42 05 D0 22 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 06 20 1C E0 2B 88 29 2B 15 D0 2A 88 9A B1 A2 F1 30 03 09 2B 09 D9 A2 F1 61 03 19 2B 05 D9 A2 F1 41 03 19 2B 01 D9 5F 2A 93 D1 20 46 ?? ?? ?? ?? 28 80 29 28 E9 D1 2B 88 29 2B 8A D1 04 20 BD E8 FE 09 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_40_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0024 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 003c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0040 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0D 4E 0C 4F 88 46 05 46 00 24 95 F9 00 20 A3 57 9A 42 02 D0 E3 57 9A 42 09 D1 40 46 ?? ?? ?? ?? 64 1C 04 2C 28 70 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_65_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0024 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 003c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0040 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0D 4E 0C 4F 88 46 05 46 00 24 95 F9 00 20 A3 57 9A 42 02 D0 E3 57 9A 42 09 D1 40 46 ?? ?? ?? ?? 64 1C 04 2C 28 70 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_66_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0024 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 003c ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0040 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0D 4E 0C 4F 88 46 05 46 00 24 95 F9 00 20 A3 57 9A 42 02 D0 E3 57 9A 42 09 D1 40 46 ?? ?? ?? ?? 64 1C 04 2C 28 70 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_41_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0022 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0C 4E 0B 4F 88 46 05 46 00 24 2A 88 A3 5B 9A 42 02 D0 E3 5B 9A 42 09 D1 40 46 ?? ?? ?? ?? A4 1C 08 2C 28 80 F1 D1 01 20 BD E8 F8 89 00 20 FB E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_67_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0022 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0C 4E 0B 4F 88 46 05 46 00 24 2A 88 A3 5B 9A 42 02 D0 E3 5B 9A 42 09 D1 40 46 ?? ?? ?? ?? A4 1C 08 2C 28 80 F1 D1 01 20 BD E8 F8 89 00 20 FB E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_68_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0022 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0C 4E 0B 4F 88 46 05 46 00 24 2A 88 A3 5B 9A 42 02 D0 E3 5B 9A 42 09 D1 40 46 ?? ?? ?? ?? A4 1C 08 2C 28 80 F1 D1 01 20 BD E8 F8 89 00 20 FB E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_42_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0024 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 003c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0040 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0D 4E 0C 4F 88 46 05 46 00 24 95 F9 00 20 A3 57 9A 42 02 D0 E3 57 9A 42 09 D1 40 46 ?? ?? ?? ?? 64 1C 05 2C 28 70 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_69_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0024 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 003c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0040 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0D 4E 0C 4F 88 46 05 46 00 24 95 F9 00 20 A3 57 9A 42 02 D0 E3 57 9A 42 09 D1 40 46 ?? ?? ?? ?? 64 1C 05 2C 28 70 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_70_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 68
		refs = "0024 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 003c ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB 0040 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@1@@Z@4QBDB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0D 4E 0C 4F 88 46 05 46 00 24 95 F9 00 20 A3 57 9A 42 02 D0 E3 57 9A 42 09 D1 40 46 ?? ?? ?? ?? 64 1C 05 2C 28 70 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_43_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0022 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0C 4E 0B 4F 88 46 05 46 00 24 2A 88 A3 5B 9A 42 02 D0 E3 5B 9A 42 09 D1 40 46 ?? ?? ?? ?? A4 1C 0A 2C 28 80 F1 D1 01 20 BD E8 F8 89 00 20 FB E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_71_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0022 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0C 4E 0B 4F 88 46 05 46 00 24 2A 88 A3 5B 9A 42 02 D0 E3 5B 9A 42 09 D1 40 46 ?? ?? ?? ?? A4 1C 0A 2C 28 80 F1 D1 01 20 BD E8 F8 89 00 20 FB E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_72_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0022 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB 003c ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@1@@Z@4QB_WB"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0C 4E 0B 4F 88 46 05 46 00 24 2A 88 A3 5B 9A 42 02 D0 E3 5B 9A 42 09 D1 40 46 ?? ?? ?? ?? A4 1C 0A 2C 28 80 F1 D1 01 20 BD E8 F8 89 00 20 FB E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_44_0 {
	meta:
		name = "??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z"
		size = 208
		refs = "0028 ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z 003a ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 0C 46 09 28 43 D8 DF E8 00 F0 05 0E 17 21 2B 36 3E 40 45 4F 00 23 69 46 20 46 8D F8 04 30 00 92 ?? ?? ?? ?? 34 E0 00 23 69 46 20 46 8D F8 04 30 00 92 ?? ?? ?? ?? 2B E0 94 F8 08 33 0B B1 01 23 00 E0 00 23 DB 07 13 60 00 20 21 E0 94 F8 08 33 0B B1 01 23 00 E0 00 23 DB 07 43 F0 FF 43 F2 E7 94 F8 08 33 0B B1 01 21 00 E0 00 21 6F F0 00 43 43 EA C1 73 E7 E7 94 F8 08 33 0B B1 01 21 00 E0 00 21 10 4B F4 E7 0E 4B DD E7 00 23 13 60 01 20 BD E8 1E 88 94 F8 08 33 0B B1 01 23 00 E0 00 23 DB 07 13 60 02 20 F3 E7 94 F8 08 33 0B B1 01 23 00 E0 00 23 DB 07 43 F0 FF 43 13 60 03 20 E7 E7 00 00 C0 FF 01 00 80 7F }
	condition:
		$1
}

rule file_200_45_0 {
	meta:
		name = "??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z"
		size = 204
		refs = "002a ?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z 003c ?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z 0048 ??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAAN@Z 0056 ??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAAN@Z 0062 ??$assemble_floating_point_qnan@N@__crt_strtox@@YAX_NAAN@Z 006e ??$assemble_floating_point_snan@N@__crt_strtox@@YAX_NAAN@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 14 46 0A 46 09 28 49 D8 DF E8 00 F0 05 0E 17 1E 24 2A 30 44 4B 52 01 23 69 46 10 46 8D F8 04 30 00 94 ?? ?? ?? ?? 3A E0 01 23 69 46 10 46 8D F8 04 30 00 94 ?? ?? ?? ?? 31 E0 92 F8 08 03 21 46 ?? ?? ?? ?? 00 20 2A E0 92 F8 08 03 21 46 ?? ?? ?? ?? F7 E7 92 F8 08 03 21 46 ?? ?? ?? ?? F1 E7 92 F8 08 03 21 46 ?? ?? ?? ?? EB E7 D4 E9 00 23 43 F0 00 43 C4 E9 00 23 11 46 1A 46 10 4B 21 60 13 43 63 60 6F F3 12 03 43 F4 00 23 00 22 C4 E9 00 23 D7 E7 21 46 00 20 ?? ?? ?? ?? 01 20 BD E8 1E 88 92 F8 08 03 21 46 ?? ?? ?? ?? 02 20 F6 E7 92 F8 08 03 21 46 ?? ?? ?? ?? 03 20 EF E7 FE DE 00 00 F0 7F }
	condition:
		$1
}

rule file_200_46_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@H_N@Z"
		size = 838
		refs = "001a _errno 0022 _invalid_parameter_noinfo 0050 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0060 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ 0078 _isctype_l 0150 _ungetch_nolock 0178 __rt_udiv64 0294 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8B B0 0D 46 2C 68 1E 46 90 46 01 46 0C B1 AB 69 83 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A9 69 29 B1 D5 E9 04 23 13 43 01 D1 00 23 0B 70 00 26 00 27 7F E1 B8 F1 00 0F 05 D0 B8 F1 02 0F E8 DB B8 F1 24 0F E5 DC 06 A8 ?? ?? ?? ?? 2B 69 28 46 00 27 04 93 6B 69 05 93 ?? ?? ?? ?? 4F F0 08 0A 07 9A 04 46 E0 B2 53 68 01 2B 04 DD 07 AA 08 21 ?? ?? ?? ?? 04 E0 13 68 33 F8 10 30 03 EA 0A 00 18 B1 28 46 ?? ?? ?? ?? EA E7 16 B1 4F F0 01 09 01 E0 4F F0 00 09 02 23 2D 2C 4F F0 00 0A 03 D1 49 EA 03 09 2D 2C 01 D0 2B 2C 03 D1 28 46 ?? ?? ?? ?? 04 46 6F F0 00 06 B8 F1 00 0F 02 D0 B8 F1 10 0F 4D D1 30 2C 04 DB 39 2C 02 DC A4 F1 30 03 0E E0 61 2C 04 DB 7A 2C 02 DC A4 F1 57 03 07 E0 41 2C 04 DB 5A 2C 02 DC A4 F1 37 03 00 E0 33 46 2B B1 B8 F1 00 0F 33 D1 4F F0 0A 08 30 E0 28 46 ?? ?? ?? ?? 78 28 22 D0 58 28 20 D0 B8 F1 00 0F 01 D1 4F F0 08 08 D5 E9 04 32 A9 68 9B 19 72 41 C5 E9 04 32 EA 68 51 EA 02 03 06 D0 D5 E9 04 E3 93 42 15 D8 01 D3 8E 45 12 D8 88 B1 B0 42 0F D0 2A 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 08 E0 B8 F1 00 0F 01 D1 4F F0 10 08 28 46 ?? ?? ?? ?? 04 46 33 46 32 46 4F EA E8 71 40 46 08 B9 01 B9 F9 DE ?? ?? ?? ?? CD E9 00 32 0B 46 02 46 CD E9 02 32 00 21 30 2C 04 DB 39 2C 02 DC A4 F1 30 0E 0E E0 61 2C 04 DB 7A 2C 02 DC A4 F1 57 0E 07 E0 41 2C 04 DB 5A 2C 02 DC A4 F1 37 0E 00 E0 B6 46 B6 45 2A D0 C6 45 28 D2 49 F0 08 09 9F 42 10 D3 01 D8 92 45 0D D3 92 45 08 D1 9F 42 06 D1 00 9B 99 42 03 D8 05 D3 01 9B 9E 45 02 D9 49 F0 04 09 0C E0 4F EA E8 73 03 FB 0A F3 08 FB 07 32 A8 FB 0A 13 13 44 11 EB 0E 0A 43 F1 00 07 28 46 ?? ?? ?? ?? DD E9 02 32 04 46 BB E7 D5 E9 04 32 A9 68 9B 19 72 41 C5 E9 04 32 EA 68 51 EA 02 03 06 D0 D5 E9 04 03 93 42 0C D8 01 D3 88 42 09 D8 44 B1 B4 42 06 D0 2A 68 20 46 13 68 5B 1E 13 60 ?? ?? ?? ?? 19 F0 08 0F 1F D1 D5 E9 04 32 04 99 00 20 99 42 02 D1 05 9B 93 42 01 D0 AB 69 18 70 9D F8 24 30 33 B1 06 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 A9 69 00 29 3F F4 DB AE D5 E9 04 23 13 43 7F F4 D6 AE 08 70 D3 E6 3B 46 52 46 48 46 ?? ?? ?? ?? A8 B3 ?? ?? ?? ?? 22 23 03 60 19 F0 01 0F 03 D1 B2 46 37 46 02 21 33 E0 02 21 9D F8 24 30 19 EA 01 0F 12 D0 2B B1 06 9A D2 F8 50 33 8B 43 C2 F8 50 33 A9 69 29 B1 D5 E9 04 23 13 43 01 D1 00 23 0B 70 00 26 4F F0 00 47 2C E0 2B B1 06 9A D2 F8 50 33 8B 43 C2 F8 50 33 A9 69 29 B1 D5 E9 04 23 13 43 01 D1 00 23 0B 70 6F F0 00 47 1A E0 02 21 19 EA 01 0F 04 D0 00 23 DA F1 00 0A 63 EB 07 07 9D F8 24 30 2B B1 06 9A D2 F8 50 33 8B 43 C2 F8 50 33 A9 69 29 B1 D5 E9 04 23 13 43 01 D1 00 23 0B 70 56 46 30 46 39 46 0B B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_200_47_0 {
	meta:
		name = "??$parse_integer@_KV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z"
		size = 1394
		refs = "001c _errno 0024 _invalid_parameter_noinfo 0052 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0066 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ 006e iswctype 0262 _ungetwch_nolock 028e __rt_udiv64 04c2 ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8D B0 0D 46 2C 68 1E 46 92 46 01 92 01 46 0C B1 AB 69 83 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? A9 69 29 B1 D5 E9 04 23 13 43 01 D1 00 23 0B 70 00 27 B8 46 94 E2 BA F1 00 0F 05 D0 BA F1 02 0F E8 DB BA F1 24 0F E5 DC 08 A8 ?? ?? ?? ?? 00 23 00 93 98 46 2B 69 05 93 6B 69 06 93 28 46 ?? ?? ?? ?? 08 21 04 46 ?? ?? ?? ?? 00 28 F6 D1 16 B1 4F F0 01 09 01 E0 4F F0 00 09 02 23 2D 2C 03 D1 49 EA 03 09 2D 2C 01 D0 2B 2C 03 D1 28 46 ?? ?? ?? ?? 04 46 4F F6 10 73 4F F4 CC 62 4F F4 DE 61 40 F6 66 10 40 F6 E6 16 40 F6 66 2E 6F F0 00 07 BA F1 00 0F 03 D0 BA F1 10 0F 40 F0 DC 80 30 2C C0 F0 86 80 3A 2C 02 D2 A4 F1 30 03 7E E0 9C 42 77 D2 94 42 7C D3 40 F2 6A 63 9C 42 38 BF A3 1A 74 D3 8C 42 74 D3 40 F2 FA 63 9C 42 38 BF 63 1A 6C D3 84 42 6C D3 B4 F5 17 6F 38 BF 23 1A 65 D3 B4 42 65 D3 B4 F5 1F 6F 38 BF A3 1B 5E D3 74 45 5E D3 B4 F5 27 6F 02 D2 A4 EB 0E 03 56 E0 40 F6 E6 23 9C 42 54 D3 B4 F5 2F 6F 01 D2 E3 1A 4D E0 40 F6 66 33 9C 42 4B D3 B4 F5 37 6F F6 D3 40 F6 66 43 9C 42 44 D3 B4 F5 47 6F EF D3 40 F6 E6 43 9C 42 3D D3 B4 F5 4F 6F E8 D3 40 F6 66 53 9C 42 36 D3 B4 F5 57 6F E1 D3 4F F4 65 63 9C 42 2F D3 40 F6 5A 62 94 42 D9 D3 4F F4 6D 63 9C 42 27 D3 40 F6 DA 62 94 42 D1 D3 50 33 9C 42 20 D3 50 32 94 42 CB D3 4F F4 82 53 9C 42 19 D3 41 F2 4A 02 94 42 C3 D3 4F F4 BF 53 9C 42 11 D3 41 F2 EA 72 94 42 BB D3 30 33 9C 42 0A D3 30 32 94 42 07 D2 B4 E7 4F F6 1A 72 94 42 B0 D3 3B 46 BB 42 12 D1 41 2C 01 D3 5A 2C 03 D9 61 2C 0B D3 7A 2C 09 D8 61 2C 04 D3 7A 2C 02 D8 A4 F1 20 03 00 E0 23 46 37 3B 00 E0 3B 46 3B B1 BA F1 00 0F 3B D1 4F F0 0A 0A CD F8 04 A0 36 E0 28 46 ?? ?? ?? ?? 78 28 26 D0 58 28 24 D0 BA F1 00 0F 03 D1 4F F0 08 0A CD F8 04 A0 D5 E9 04 32 A9 68 DB 19 7A 41 C5 E9 04 32 EA 68 51 EA 02 03 06 D0 D5 E9 04 63 93 42 19 D8 01 D3 8E 42 16 D8 A8 B1 4F F6 FF 73 98 42 11 D0 2A 68 13 68 5B 1E 13 60 ?? ?? ?? ?? 0A E0 BA F1 00 0F 03 D1 4F F0 10 0A CD F8 04 A0 28 46 ?? ?? ?? ?? 04 46 3B 46 3A 46 4F EA EA 71 50 46 08 B9 01 B9 F9 DE ?? ?? ?? ?? 9E 46 CD E9 03 32 03 46 02 93 8A 46 30 2C C0 F0 87 80 3A 2C 02 D2 A4 F1 30 06 7F E0 4F F6 10 71 8C 42 76 D2 4F F4 CC 61 8C 42 79 D3 40 F2 6A 60 84 42 01 D2 66 1A 71 E0 4F F4 DE 61 8C 42 6F D3 40 F2 FA 60 84 42 F5 D3 40 F6 66 11 8C 42 67 D3 B4 F5 17 6F EE D3 40 F6 E6 11 8C 42 60 D3 B4 F5 1F 6F E7 D3 40 F6 66 21 8C 42 59 D3 B4 F5 27 6F E0 D3 40 F6 E6 21 8C 42 52 D3 B4 F5 2F 6F D9 D3 40 F6 66 31 8C 42 4B D3 B4 F5 37 6F D2 D3 40 F6 66 41 8C 42 44 D3 B4 F5 47 6F CB D3 40 F6 E6 41 8C 42 3D D3 B4 F5 4F 6F C4 D3 40 F6 66 51 8C 42 36 D3 B4 F5 57 6F BD D3 4F F4 65 61 8C 42 2F D3 40 F6 5A 60 84 42 B5 D3 4F F4 6D 61 8C 42 27 D3 40 F6 DA 60 84 42 AD D3 50 31 8C 42 20 D3 50 30 84 42 A7 D3 4F F4 82 51 8C 42 19 D3 41 F2 4A 00 84 42 9F D3 4F F4 BF 51 8C 42 11 D3 41 F2 EA 70 84 42 97 D3 30 31 8C 42 0A D3 30 30 84 42 07 D2 90 E7 4F F6 1A 70 84 42 8C D3 3E 46 BE 42 16 D1 41 2C 01 D3 5A 2C 03 D9 61 2C 0D D3 7A 2C 0B D8 61 2C 04 D3 7A 2C 02 D8 A4 F1 20 03 00 E0 23 46 A3 F1 37 06 02 9B 00 E0 3E 46 BE 42 2B D0 01 99 8E 42 28 D2 00 98 49 F0 08 09 D0 45 0F D3 01 D8 98 42 0C D3 98 42 07 D1 D0 45 05 D1 00 23 73 45 02 D8 04 D3 96 42 02 D9 49 F0 04 09 0B E0 CB 17 03 FB 00 F3 01 FB 08 32 A1 FB 00 13 13 44 8A 19 00 92 43 F1 00 08 28 46 ?? ?? ?? ?? DD E9 02 3E 04 9A 04 46 32 E7 D5 E9 04 32 A9 68 DB 19 7A 41 C5 E9 04 32 EA 68 51 EA 02 03 06 D0 D5 E9 04 03 93 42 0E D8 01 D3 88 42 0B D8 54 B1 4F F6 FF 73 9C 42 06 D0 2A 68 20 46 13 68 5B 1E 13 60 ?? ?? ?? ?? 19 F0 08 0F 1F D1 D5 E9 04 32 05 99 00 20 99 42 02 D1 06 9B 93 42 01 D0 AB 69 18 70 9D F8 2C 30 33 B1 08 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 A9 69 00 29 3F F4 C6 AD D5 E9 04 23 13 43 7F F4 C1 AD 08 70 BE E5 00 9C 43 46 48 46 22 46 ?? ?? ?? ?? A8 B3 ?? ?? ?? ?? 22 23 03 60 19 F0 01 0F 03 D1 3C 46 B8 46 02 21 32 E0 02 21 9D F8 2C 30 19 EA 01 0F 12 D0 2B B1 08 9A D2 F8 50 33 8B 43 C2 F8 50 33 A9 69 29 B1 D5 E9 04 23 13 43 01 D1 00 23 0B 70 00 27 4F F0 00 48 2B E0 2B B1 08 9A D2 F8 50 33 8B 43 C2 F8 50 33 A9 69 29 B1 D5 E9 04 23 13 43 01 D1 00 23 0B 70 6F F0 00 48 19 E0 02 21 19 EA 01 0F 03 D0 00 23 64 42 63 EB 08 08 9D F8 2C 30 2B B1 08 9A D2 F8 50 33 8B 43 C2 F8 50 33 A8 69 28 B1 D5 E9 04 23 13 43 01 D1 00 23 03 70 27 46 38 46 41 46 0D B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_200_48_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQBD0IAADAAV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0028 ?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 00 27 1D 46 90 46 0C 46 8A B1 06 1B 95 F9 00 10 30 57 81 42 03 D0 94 F9 00 00 81 42 0A D1 08 98 ?? ?? ?? ?? 7F 1C 64 1C 47 45 28 70 EE D1 01 20 BD E8 F8 89 00 20 FB E7 }
	condition:
		$1
}

rule file_452_79_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQBD0IAADAAV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0028 ?get@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 00 27 1D 46 90 46 0C 46 8A B1 06 1B 95 F9 00 10 30 57 81 42 03 D0 94 F9 00 00 81 42 0A D1 08 98 ?? ?? ?? ?? 7F 1C 64 1C 47 45 28 70 EE D1 01 20 BD E8 F8 89 00 20 FB E7 }
	condition:
		$1
}

rule file_452_80_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQBD0IAADAAV?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@0@@Z"
		size = 64
		refs = "0028 ?get@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 00 27 1D 46 90 46 0C 46 8A B1 06 1B 95 F9 00 10 30 57 81 42 03 D0 94 F9 00 00 81 42 0A D1 08 98 ?? ?? ?? ?? 7F 1C 64 1C 47 45 28 70 EE D1 01 20 BD E8 F8 89 00 20 FB E7 }
	condition:
		$1
}

rule file_200_49_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQB_W0IAA_WAAV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 60
		refs = "0024 ?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 00 27 1D 46 90 46 0C 46 7A B1 06 1B 29 88 30 5B 81 42 02 D0 20 88 81 42 0A D1 08 98 ?? ?? ?? ?? 7F 1C A4 1C 47 45 28 80 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 }
	condition:
		$1
}

rule file_452_81_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQB_W0IAA_WAAV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 60
		refs = "0024 ?get@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 00 27 1D 46 90 46 0C 46 7A B1 06 1B 29 88 30 5B 81 42 02 D0 20 88 81 42 0A D1 08 98 ?? ?? ?? ?? 7F 1C A4 1C 47 45 28 80 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 }
	condition:
		$1
}

rule file_452_82_0 {
	meta:
		name = "??$parse_next_characters_from_source@_WV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_NQB_W0IAA_WAAV?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@0@@Z"
		size = 60
		refs = "0024 ?get@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 00 27 1D 46 90 46 0C 46 7A B1 06 1B 29 88 30 5B 81 42 02 D0 20 88 81 42 0A D1 08 98 ?? ?? ?? ?? 7F 1C A4 1C 47 45 28 80 F0 D1 01 20 BD E8 F8 89 00 20 FB E7 }
	condition:
		$1
}

rule file_200_50_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 132
		refs = "0028 ??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0032 ??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAM@Z 005e _errno 0066 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8D B0 00 23 8D F8 08 30 9F ED 1B 0A 02 AB 04 46 A2 6A 00 93 E3 6A 00 F1 08 01 04 A8 8D ED 03 0A ?? ?? ?? ?? 01 46 20 6E 03 AA ?? ?? ?? ?? 9D F8 08 30 B3 B1 01 28 14 D0 94 F8 26 30 0B B1 01 20 10 E0 62 6E 53 42 03 F0 03 03 13 44 1B 1D 63 66 53 F8 04 2C 4A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0D B0 BD E8 10 88 A3 6E 5B 1C A3 66 03 9B 13 60 E3 E7 FE DE 00 00 00 00 }
	condition:
		$1
}

rule file_452_83_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 132
		refs = "0028 ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0032 ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAM@Z 005e _errno 0066 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8D B0 00 23 8D F8 08 30 9F ED 1B 0A 02 AB 04 46 A2 6A 00 93 E3 6A 00 F1 08 01 04 A8 8D ED 03 0A ?? ?? ?? ?? 01 46 20 6E 03 AA ?? ?? ?? ?? 9D F8 08 30 B3 B1 01 28 14 D0 94 F8 26 30 0B B1 01 20 10 E0 62 6E 53 42 03 F0 03 03 13 44 1B 1D 63 66 53 F8 04 2C 4A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0D B0 BD E8 10 88 A3 6E 5B 1C A3 66 03 9B 13 60 E3 E7 FE DE 00 00 00 00 }
	condition:
		$1
}

rule file_200_51_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 132
		refs = "0028 ??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0032 ??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z 005e _errno 0066 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8D B0 00 23 8D F8 08 30 9F ED 1B 0A 02 AB 04 46 22 6B 00 93 63 6B 00 F1 08 01 04 A8 8D ED 03 0A ?? ?? ?? ?? 01 46 A0 6C 03 AA ?? ?? ?? ?? 9D F8 08 30 B3 B1 01 28 14 D0 94 F8 28 30 0B B1 01 20 10 E0 E2 6C 53 42 03 F0 03 03 13 44 1B 1D E3 64 53 F8 04 2C 4A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0D B0 BD E8 10 88 23 6D 5B 1C 23 65 03 9B 13 60 E3 E7 FE DE 00 00 00 00 }
	condition:
		$1
}

rule file_452_85_0 {
	meta:
		name = "??$process_floating_point_specifier_t@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 132
		refs = "0028 ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0032 ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAM@Z 005e _errno 0066 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8D B0 00 23 8D F8 08 30 9F ED 1B 0A 02 AB 04 46 22 6B 00 93 63 6B 00 F1 08 01 04 A8 8D ED 03 0A ?? ?? ?? ?? 01 46 A0 6C 03 AA ?? ?? ?? ?? 9D F8 08 30 B3 B1 01 28 14 D0 94 F8 28 30 0B B1 01 20 10 E0 E2 6C 53 42 03 F0 03 03 13 44 1B 1D E3 64 53 F8 04 2C 4A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0D B0 BD E8 10 88 23 6D 5B 1C 23 65 03 9B 13 60 E3 E7 FE DE 00 00 00 00 }
	condition:
		$1
}

rule file_200_52_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 140
		refs = "0028 ??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0032 ??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAN@Z 005e _errno 0066 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8F B0 00 23 8D F8 08 30 9F ED 1C 0B 02 AB 04 46 A2 6A 00 93 E3 6A 00 F1 08 01 06 A8 8D ED 04 0B ?? ?? ?? ?? 01 46 20 6E 04 AA ?? ?? ?? ?? 9D F8 08 30 B3 B1 01 28 14 D0 94 F8 26 30 0B B1 01 20 10 E0 62 6E 53 42 03 F0 03 03 13 44 1B 1D 63 66 53 F8 04 2C 4A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0F B0 BD E8 10 88 A3 6E 5B 1C A3 66 04 9B 13 60 05 9B 53 60 E1 E7 FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_452_87_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 140
		refs = "0028 ??$make_input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAV?$stream_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0032 ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@0@QAN@Z 005e _errno 0066 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8F B0 00 23 8D F8 08 30 9F ED 1C 0B 02 AB 04 46 A2 6A 00 93 E3 6A 00 F1 08 01 06 A8 8D ED 04 0B ?? ?? ?? ?? 01 46 20 6E 04 AA ?? ?? ?? ?? 9D F8 08 30 B3 B1 01 28 14 D0 94 F8 26 30 0B B1 01 20 10 E0 62 6E 53 42 03 F0 03 03 13 44 1B 1D 63 66 53 F8 04 2C 4A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0F B0 BD E8 10 88 A3 6E 5B 1C A3 66 04 9B 13 60 05 9B 53 60 E1 E7 FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_200_53_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 140
		refs = "0028 ??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0032 ??$parse_floating_point@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z 005e _errno 0066 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8F B0 00 23 8D F8 08 30 9F ED 1C 0B 02 AB 04 46 22 6B 00 93 63 6B 00 F1 08 01 06 A8 8D ED 04 0B ?? ?? ?? ?? 01 46 A0 6C 04 AA ?? ?? ?? ?? 9D F8 08 30 B3 B1 01 28 14 D0 94 F8 28 30 0B B1 01 20 10 E0 E2 6C 53 42 03 F0 03 03 13 44 1B 1D E3 64 53 F8 04 2C 4A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0F B0 BD E8 10 88 23 6D 5B 1C 23 65 04 9B 13 60 05 9B 53 60 E1 E7 FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_452_89_0 {
	meta:
		name = "??$process_floating_point_specifier_t@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 140
		refs = "0028 ??$make_input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAV?$stream_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 0032 ??$parse_floating_point@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@0@QAN@Z 005e _errno 0066 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 8F B0 00 23 8D F8 08 30 9F ED 1C 0B 02 AB 04 46 22 6B 00 93 63 6B 00 F1 08 01 06 A8 8D ED 04 0B ?? ?? ?? ?? 01 46 A0 6C 04 AA ?? ?? ?? ?? 9D F8 08 30 B3 B1 01 28 14 D0 94 F8 28 30 0B B1 01 20 10 E0 E2 6C 53 42 03 F0 03 03 13 44 1B 1D E3 64 53 F8 04 2C 4A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 0F B0 BD E8 10 88 23 6D 5B 1C 23 65 04 9B 13 60 05 9B 53 60 E1 E7 FE DE 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_200_54_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@D@Z"
		size = 384
		refs = "002a _errno 0032 _invalid_parameter_noinfo 006a _getche_nolock 0140 _ungetch_nolock"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 85 B0 90 F8 26 30 00 26 0F 46 04 46 13 BB 62 6E 53 42 03 F0 03 03 13 44 1A 1D 62 66 52 F8 04 6C 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 9F E0 23 68 13 F0 01 0F 18 BF 01 23 08 BF 00 23 43 B1 53 42 03 F0 03 03 13 44 1B 1D 63 66 53 F8 04 5C 01 E0 6F F0 00 05 95 B9 23 68 13 F0 04 0F 09 D0 ?? ?? ?? ?? 10 F1 01 0F 02 D0 A3 68 5B 1C A3 60 00 23 33 70 ?? ?? ?? ?? 0C 23 03 60 D6 E7 D4 E9 0A 01 32 46 CD E9 00 21 02 90 AA 46 27 B1 15 F1 01 0F 01 D0 A5 F1 01 0A 4F F0 00 09 40 EA 01 03 C8 46 03 93 1B B1 81 45 01 D1 88 45 48 D0 ?? ?? ?? ?? 10 F1 01 0F 38 D0 A3 68 5B 1C A3 60 D7 B1 01 2F 12 D0 08 2F 30 D1 C1 B2 CB 10 A1 EB C3 03 01 22 9A 40 04 EB D1 03 93 F8 3C 30 1A 42 18 BF 01 23 08 BF 00 23 00 2B 04 E0 A0 F1 09 03 04 2B 1B D9 20 28 19 D0 94 F8 26 30 4B B9 BA F1 00 0F 0F D0 00 9A AA F1 01 0A 02 F8 01 0B 00 92 00 E0 00 9A 19 F1 01 09 DD E9 01 10 03 9B 48 F1 00 08 C0 E7 15 F1 01 0F A5 D0 A2 E7 10 F1 01 0F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? DD E9 01 10 00 9A 59 EA 08 03 3F F4 72 AF 47 B9 81 45 01 D1 88 45 04 D0 23 68 13 F0 04 0F 3F F4 68 AF 94 F8 26 30 2B B9 0F B1 00 23 13 70 A3 6E 5B 1C A3 66 01 20 05 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_200_55_0 {
	meta:
		name = "??$process_string_specifier_tchar@D@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@D@Z"
		size = 366
		refs = "002a _errno 0032 _invalid_parameter_noinfo 006a _getwche_nolock 00d8 ?is_character_allowed_in_string@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABA_NW4conversion_mode@2@G@Z 00fa ?write_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQADIAAPADAAI_W@Z 012c _ungetwch_nolock"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 89 B0 90 F8 28 30 00 26 05 91 04 46 13 BB E2 6C 53 42 03 F0 03 03 13 44 1A 1D E2 64 52 F8 04 6C 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 96 E0 23 68 13 F0 01 0F 18 BF 01 23 08 BF 00 23 43 B1 53 42 03 F0 03 03 13 44 1B 1D E3 64 53 F8 04 5C 01 E0 6F F0 00 05 9D B9 23 68 13 F0 04 0F 0A D0 ?? ?? ?? ?? 4F F6 FF 73 98 42 02 D0 A3 68 5B 1C A3 60 00 23 33 70 ?? ?? ?? ?? 0C 23 03 60 D5 E7 D4 E9 0C 02 06 96 AA 46 CD E9 02 20 04 95 31 B1 15 F1 01 0F 03 D0 A5 F1 01 0A CD F8 10 A0 40 EA 02 03 07 93 4F F0 00 08 00 27 1B B1 80 45 01 D1 97 42 3A D0 ?? ?? ?? ?? 81 46 4F F6 FF 73 99 45 02 D0 A3 68 5B 1C A3 60 05 99 4A 46 20 46 ?? ?? ?? ?? F0 B1 94 F8 28 30 7B B9 BA F1 00 0F 14 D0 04 AB 00 93 06 AB 2A 46 31 46 20 46 CD F8 04 90 ?? ?? ?? ?? B8 B1 DD F8 10 A0 18 F1 01 08 DD E9 02 20 07 9B 47 F1 00 07 CF E7 15 F1 01 0F B2 D0 AF E7 4F F6 FF 73 99 45 05 D0 A3 68 48 46 5B 1E A3 60 ?? ?? ?? ?? DD E9 02 20 58 EA 07 03 3F F4 7D AF 05 99 41 B9 80 45 01 D1 97 42 04 D0 23 68 13 F0 04 0F 3F F4 72 AF 94 F8 28 30 33 B9 11 B1 06 9B 00 22 1A 70 23 6D 5B 1C 23 65 01 20 09 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_200_56_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@_W@Z"
		size = 398
		refs = "002a _errno 0032 _invalid_parameter_noinfo 006a _getche_nolock 0120 ?write_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQFA_WIAAPFA_WAAID@Z 014e _ungetch_nolock"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 87 B0 90 F8 26 30 00 26 0F 46 04 46 13 BB 62 6E 53 42 03 F0 03 03 13 44 1A 1D 62 66 52 F8 04 6C 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 A6 E0 23 68 13 F0 01 0F 18 BF 01 23 08 BF 00 23 43 B1 53 42 03 F0 03 03 13 44 1B 1D 63 66 53 F8 04 5C 01 E0 6F F0 00 05 95 B9 23 68 13 F0 04 0F 09 D0 ?? ?? ?? ?? 10 F1 01 0F 02 D0 A3 68 5B 1C A3 60 00 23 33 80 ?? ?? ?? ?? 0C 23 03 60 D6 E7 D4 E9 0A 12 CD E9 04 56 AA 46 CD E9 02 21 37 B1 15 F1 01 0F 03 D0 A5 F1 01 0A CD F8 10 A0 4F F0 00 09 41 EA 02 03 C8 46 06 93 1B B1 89 45 01 D1 90 45 4C D0 ?? ?? ?? ?? 10 F1 01 0F 3D D0 A3 68 5B 1C A3 60 D7 B1 01 2F 12 D0 08 2F 35 D1 C1 B2 CB 10 A1 EB C3 03 01 22 9A 40 04 EB D1 03 93 F8 3C 30 1A 42 18 BF 01 23 08 BF 00 23 00 2B 04 E0 A0 F1 09 03 04 2B 20 D9 20 28 1E D0 94 F8 26 30 7B B9 BA F1 00 0F 14 D0 43 B2 01 93 04 AB 00 93 05 AB 2A 46 31 46 20 46 ?? ?? ?? ?? A8 B1 DD F8 10 A0 19 F1 01 09 DD E9 02 21 06 9B 48 F1 00 08 BB E7 15 F1 01 0F 9E D0 9B E7 10 F1 01 0F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? DD E9 02 21 59 EA 08 03 3F F4 6C AF 47 B9 89 45 01 D1 90 45 04 D0 23 68 13 F0 04 0F 3F F4 62 AF 94 F8 26 30 33 B9 17 B1 05 9B 00 22 1A 80 A3 6E 5B 1C A3 66 01 20 07 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_200_57_0 {
	meta:
		name = "??$process_string_specifier_tchar@_W@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@_W@Z"
		size = 352
		refs = "002a _errno 0032 _invalid_parameter_noinfo 006a _getwche_nolock 00d6 ?is_character_allowed_in_string@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABA_NW4conversion_mode@2@G@Z 0120 _ungetwch_nolock"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 85 B0 90 F8 28 30 00 26 03 91 04 46 13 BB E2 6C 53 42 03 F0 03 03 13 44 1A 1D E2 64 52 F8 04 6C 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 8F E0 23 68 13 F0 01 0F 18 BF 01 23 08 BF 00 23 43 B1 53 42 03 F0 03 03 13 44 1B 1D E3 64 53 F8 04 5C 01 E0 6F F0 00 05 9D B9 23 68 13 F0 04 0F 0A D0 ?? ?? ?? ?? 4F F6 FF 73 98 42 02 D0 A3 68 5B 1C A3 60 00 23 33 80 ?? ?? ?? ?? 0C 23 03 60 D5 E7 D4 E9 0C E0 32 46 CD E9 00 20 CD F8 08 E0 AA 46 21 B1 15 F1 01 0F 01 D0 A5 F1 01 0A 4E EA 00 03 04 93 4F F0 00 08 00 27 1B B1 F0 45 01 D1 87 42 36 D0 ?? ?? ?? ?? 81 46 4F F6 FF 73 99 45 02 D0 A3 68 5B 1C A3 60 03 99 4A 46 20 46 ?? ?? ?? ?? C8 B1 94 F8 28 30 4B B9 BA F1 00 0F 0F D0 00 9A AA F1 01 0A 22 F8 02 9B 00 92 00 E0 00 9A 18 F1 01 08 DD E9 01 0E 04 9B 47 F1 00 07 D4 E7 15 F1 01 0F B8 D0 B5 E7 4F F6 FF 73 99 45 05 D0 A3 68 48 46 5B 1E A3 60 ?? ?? ?? ?? DD E9 01 0E 00 9A 58 EA 07 03 82 D0 03 99 41 B9 F0 45 01 D1 87 42 04 D0 23 68 13 F0 04 0F 3F F4 78 AF 94 F8 28 30 2B B9 09 B1 00 23 13 80 23 6D 5B 1C 23 65 01 20 05 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_200_58_0 {
	meta:
		name = "??$reset_buffer@D@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQFADI@Z"
		size = 20
		altNames = "??$reset_buffer@D@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQFADI@Z ??$reset_buffer@D@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQFADI@Z ??$reset_buffer@D@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQFADI@Z ??$reset_buffer@D@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQFADI@Z ??$reset_buffer@D@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQFADI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 B1 F1 FF 3F 01 D0 00 23 03 70 BD E8 00 88 }
	condition:
		$1
}

rule file_200_60_0 {
	meta:
		name = "??$reset_buffer@_W@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQFA_WI@Z"
		size = 20
		altNames = "??$reset_buffer@_W@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQFA_WI@Z ??$reset_buffer@_W@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@CAXQFA_WI@Z ??$reset_buffer@_W@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQFA_WI@Z ??$reset_buffer@_W@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQFA_WI@Z ??$reset_buffer@_W@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@CAXQFA_WI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 B1 F1 FF 3F 01 D0 00 23 03 80 BD E8 00 88 }
	condition:
		$1
}

rule file_200_62_0 {
	meta:
		name = "??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAAV?$console_input_adapter@D@0@QAU__crt_locale_pointers@@@Z"
		size = 84
		refs = "000c _getche_nolock 0030 _isctype_l 003e __pctype_func"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0D 46 07 46 ?? ?? ?? ?? 04 46 B0 F1 FF 3F 1A D0 3B 68 E6 B2 5B 1C 3B 60 6D B1 2A 68 53 68 01 2B 05 DD 2A 46 08 21 30 46 ?? ?? ?? ?? 09 E0 13 68 33 F8 16 30 03 E0 ?? ?? ?? ?? 30 F8 16 30 03 F0 08 00 00 28 DE D1 20 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_200_63_0 {
	meta:
		name = "??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$console_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z"
		size = 50
		refs = "000e _getwche_nolock 0024 iswctype"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 06 46 4F F6 FF 75 ?? ?? ?? ?? 04 46 AC 42 09 D0 33 68 5B 1C 33 60 AC 42 04 D0 08 21 ?? ?? ?? ?? 00 28 F0 D1 20 46 BD E8 78 88 }
	condition:
		$1
}

rule file_200_66_0 {
	meta:
		name = "??$ungettch_nolock@ABG@?$__crt_char_traits@_W@@SAGABG@Z"
		size = 16
		refs = "000c _ungetwch_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 88 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_606_107_0 {
	meta:
		name = "??$puttch_nolock@AB_W@?$__crt_char_traits@_W@@SAGAB_W@Z"
		size = 16
		refs = "000c _putwch_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 88 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_68_0 {
	meta:
		name = "??$write_floating_point@M@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NABM@Z"
		size = 58
		refs = "001a _errno 0022 _invalid_parameter_noinfo"
		altNames = "??$write_floating_point@M@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NABM@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 42 6E 53 42 03 F0 03 03 13 44 1B 1D 43 66 53 F8 04 2C 3A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 05 E0 83 6E 5B 1C 83 66 0B 68 01 20 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_69_0 {
	meta:
		name = "??$write_floating_point@M@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NABM@Z"
		size = 58
		refs = "001a _errno 0022 _invalid_parameter_noinfo"
		altNames = "??$write_floating_point@M@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NABM@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 C2 6C 53 42 03 F0 03 03 13 44 1B 1D C3 64 53 F8 04 2C 3A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 05 E0 03 6D 5B 1C 03 65 0B 68 01 20 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_70_0 {
	meta:
		name = "??$write_floating_point@N@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NABN@Z"
		size = 62
		refs = "001a _errno 0022 _invalid_parameter_noinfo"
		altNames = "??$write_floating_point@N@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NABN@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 42 6E 53 42 03 F0 03 03 13 44 1B 1D 43 66 53 F8 04 2C 3A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 07 E0 83 6E 5B 1C 83 66 0B 68 01 20 13 60 4B 68 53 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_71_0 {
	meta:
		name = "??$write_floating_point@N@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NABN@Z"
		size = 62
		refs = "001a _errno 0022 _invalid_parameter_noinfo"
		altNames = "??$write_floating_point@N@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NABN@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 C2 6C 53 42 03 F0 03 03 13 44 1B 1D C3 64 53 F8 04 2C 3A B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 07 E0 03 6D 5B 1C 03 65 0B 68 01 20 13 60 4B 68 53 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_81_0 {
	meta:
		name = "??0?$format_string_parser@D@__crt_stdio_input@@QAA@_KQBE@Z"
		size = 58
		refs = "001c memset"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 C4 E9 00 23 04 9B 00 25 2C 30 20 22 00 21 C4 E9 02 35 ?? ?? ?? ?? 25 61 25 75 65 75 A5 75 C4 E9 06 55 25 62 84 F8 24 50 A5 62 20 46 BD E8 30 88 }
	condition:
		$1
}

rule file_200_82_0 {
	meta:
		name = "??0?$format_string_parser@_W@__crt_stdio_input@@QAA@_KQB_W@Z"
		size = 44
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 E9 00 23 02 9B 83 60 00 23 C3 60 C0 E9 0C 33 03 61 83 82 C3 82 03 76 C0 E9 08 33 83 62 80 F8 2C 30 BD E8 00 88 }
	condition:
		$1
}

rule file_200_85_0 {
	meta:
		name = "??0?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QAA@ABV?$console_input_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 84
		refs = "002a memset"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 C5 E9 00 23 09 68 00 F1 10 04 00 26 A9 60 C4 E9 00 23 06 9B 20 22 04 F1 2C 00 00 21 C4 E9 02 36 ?? ?? ?? ?? 07 9B 26 61 26 75 66 75 A6 75 C4 E9 06 66 26 62 84 F8 24 60 A6 62 2B 66 08 9B C5 E9 19 36 EE 66 28 46 BD E8 78 88 }
	condition:
		$1
}

rule file_200_86_0 {
	meta:
		name = "??0?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAA@ABV?$console_input_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 66
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 E9 00 23 09 68 81 60 C0 E9 04 23 02 9B 00 22 C0 E9 06 32 03 9B C0 E9 10 22 02 62 82 84 C2 84 80 F8 28 20 C0 E9 0C 22 82 63 80 F8 3C 20 83 64 04 9B C0 E9 13 32 42 65 BD E8 00 88 }
	condition:
		$1
}

rule file_200_87_0 {
	meta:
		name = "??0?$scanset_buffer@E@__crt_stdio_input@@QAA@XZ"
		size = 24
		refs = "000e memset"
		altNames = "??0?$scanset_storage@$00@__crt_stdio_input@@QAA@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 20 22 00 21 04 46 ?? ?? ?? ?? 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_200_92_0 {
	meta:
		name = "??0big_integer@__crt_strtox@@QAA@ABU01@@Z"
		size = 114
		refs = "001c _errno 0024 _invalid_parameter_noinfo 0042 memcpy 0052 memset"
		altNames = "??4big_integer@__crt_strtox@@QAAAAU01@ABU01@@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0F 46 3B 68 04 46 23 60 3B 68 9E 00 56 B3 10 F1 04 0F 08 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 20 46 BD E8 F0 88 4F F4 E6 75 17 F1 04 0F 09 D0 AE 42 07 D8 39 1D 20 1D 32 46 ?? ?? ?? ?? 20 46 BD E8 F0 88 2A 46 00 21 20 1D ?? ?? ?? ?? 17 F1 04 0F DF D0 AE 42 05 D9 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 20 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_200_94_0 {
	meta:
		name = "??0floating_point_value@__crt_strtox@@QAA@QAM@Z"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 03 71 01 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_95_0 {
	meta:
		name = "??0floating_point_value@__crt_strtox@@QAA@QAN@Z"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 01 23 03 71 01 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_97_0 {
	meta:
		name = "??1?$format_string_parser@_W@__crt_stdio_input@@QAA@XZ"
		size = 24
		refs = "000c _free_base"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 60 6B ?? ?? ?? ?? 00 23 63 63 BD E8 18 88 }
	condition:
		$1
}

rule file_200_98_0 {
	meta:
		name = "??1?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA@XZ"
		size = 26
		altNames = "??1?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA@XZ ??1?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA@XZ ??1?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA@XZ ??1?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA@XZ ??1?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 81 69 29 B1 D0 E9 04 23 13 43 01 D1 00 23 0B 70 BD E8 00 88 }
	condition:
		$1
}

rule file_200_100_0 {
	meta:
		name = "??1?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAA@XZ"
		size = 24
		refs = "000c _free_base"
		altNames = "??1?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAA@XZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 60 6C ?? ?? ?? ?? 00 23 63 64 BD E8 18 88 }
	condition:
		$1
}

rule file_200_104_0 {
	meta:
		name = "??4?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAAAAV0@$$QAV0@@Z"
		size = 34
		refs = "000e _free_base"
		altNames = "??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAAAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAAAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAAAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAAAAV0@$$QAV0@@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 28 68 0C 46 ?? ?? ?? ?? 00 22 2A 60 23 68 28 46 2B 60 22 60 BD E8 30 88 }
	condition:
		$1
}

rule file_200_107_0 {
	meta:
		name = "??M__crt_strtox@@YA_NABUbig_integer@0@0@Z"
		size = 96
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 46 05 46 2B 68 22 68 93 42 02 D9 00 20 BD E8 78 88 1E D3 59 1E 11 F1 01 0F 0C D0 04 EB 81 00 2E 1B 33 18 5A 68 43 68 9A 42 07 D1 49 1E 00 1F 11 F1 01 0F F5 D1 00 20 BD E8 78 88 11 F1 01 0F F9 D0 05 EB 81 03 04 EB 81 02 59 68 53 68 99 42 DC D8 01 20 BD E8 78 88 }
	condition:
		$1
}

rule file_200_115_0 {
	meta:
		name = "?accumulate_decimal_digits_into_big_integer@__crt_strtox@@YAXQBE0AAUbig_integer@1@@Z"
		size = 980
		refs = "0008 __security_push_cookie 0104 memset 011a memcpy 0184 _errno 01ae _invalid_parameter_noinfo 03b6 __security_pop_cookie 03c0 ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 03c4 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 03c8 ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? AD F5 72 7D 0E 46 4F F0 00 08 C1 46 B0 42 17 46 00 F0 C9 81 DF F8 AC E3 C2 46 00 24 B9 F1 09 0F 40 D1 3D 68 CD B1 00 24 39 1D 0B 68 A3 FB 0E 32 1B 19 42 F1 00 04 6D 1E 41 F8 04 3B F5 D1 5C B1 3B 68 73 2B 06 D2 07 EB 83 03 5C 60 3B 68 5B 1C 3B 60 01 E0 C7 F8 00 A0 00 24 B8 F1 00 0F 1E D0 3B 68 00 21 5B B1 3A 46 52 F8 04 3F 13 EB 08 03 13 60 3B 68 44 F1 00 08 49 1C 99 42 F4 D1 B8 F1 00 0F 0C D0 3B 68 73 2B 07 D2 07 EB 83 03 C3 F8 04 80 3B 68 5B 1C 3B 60 01 E0 C7 F8 00 A0 4F F0 00 08 C1 46 10 F8 01 3B 08 EB 88 02 09 F1 01 09 03 EB 42 08 B0 42 B1 D1 B9 F1 00 0F 00 F0 73 81 BF 4B A9 FB 03 32 D3 08 08 93 9A 46 06 93 00 F0 1C 81 BA 4A BA F1 26 0F 88 BF 26 23 98 BF 53 46 02 EB 83 05 15 F8 01 4C 15 F8 02 6C 05 93 7F A8 33 19 B2 00 00 21 7E 93 ?? ?? ?? ?? 35 F8 04 3C AD 49 A2 00 01 EB 83 01 7F AB 03 EB 86 00 ?? ?? ?? ?? 7E 9B 01 2B 26 D8 7F 98 10 B9 00 23 3B 60 E9 E0 01 28 00 F0 E7 80 3C 68 00 2C 00 F0 E3 80 3D 1D 00 21 2B 68 A0 FB 03 32 5B 18 42 F1 00 01 64 1E 45 F8 04 3B F5 D1 00 29 00 F0 D4 80 3B 68 73 2B 05 D2 07 EB 83 03 59 60 3B 68 5B 1C DE E7 00 23 3B 60 C8 E0 3D 68 01 2D 31 D8 7D 68 9A 00 3C 1D 3B 60 BA B1 1C B9 ?? ?? ?? ?? 16 23 0F E0 4F F4 E6 73 9A 42 20 46 03 D8 7F A9 ?? ?? ?? ?? 09 E0 1A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 00 2D B8 D0 01 2D 00 F0 A3 80 38 68 00 28 00 F0 9F 80 00 21 23 68 A5 FB 03 32 5B 18 42 F1 00 01 40 1E 44 F8 04 3B F5 D1 BB E7 AB 42 04 D2 7F A9 38 1D 01 90 9E 46 04 E0 39 1D 7F AA AE 46 01 92 1D 46 00 22 00 24 0A 92 CD F8 00 E0 BE F1 00 0F 60 D0 0A AB 0A AE CB 1A 07 93 99 59 04 91 31 B9 94 42 51 D1 00 22 72 60 62 1C 0A 92 4C E0 00 23 03 93 4F F0 00 0A 20 46 00 2D 42 D0 01 99 B6 46 02 91 04 99 73 28 1F D0 90 42 05 D1 23 44 00 22 5B 1C CE F8 04 20 0A 93 02 9A 52 F8 04 3B 02 92 A3 FB 01 21 5E F8 04 3F 9B 18 41 F1 00 02 13 EB 0A 03 CE F8 00 30 03 9B 42 F1 00 0A 0A 9A 5B 1C 40 1C 03 93 AB 42 DC D1 BA F1 00 0F 17 D0 0A AB 03 EB 80 01 73 28 53 D0 90 42 03 D1 00 23 4B 60 43 1C 0A 93 51 F8 04 3F 00 22 13 EB 0A 03 42 EB 02 0A 40 1C 0B 60 0A 9A BA F1 00 0F EA D1 DD F8 00 E0 73 28 3C D0 07 9B 64 1C 36 1D 74 45 A4 D1 DD F8 18 A0 3A 60 92 00 1A D0 17 F1 04 0F 03 D1 ?? ?? ?? ?? 16 23 10 E0 4F F4 E6 73 9A 42 04 D8 0B A9 38 1D ?? ?? ?? ?? 0A E0 1A 46 00 21 38 1D ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 01 23 93 B1 05 9B BA EB 03 0A CD F8 18 A0 7F F4 E5 AE 08 9B 03 EB 83 03 B9 EB 43 02 25 D0 27 4B 03 EB 82 03 53 F8 04 0C 28 B9 00 20 38 60 1D E0 00 20 38 60 FA E7 01 28 17 D0 3C 68 AC B1 3D 1D 00 21 2B 68 A0 FB 03 32 5B 18 42 F1 00 01 64 1E 45 F8 04 3B F5 D1 41 B1 3B 68 73 2B E5 D2 07 EB 83 03 59 60 3B 68 5B 1C 3B 60 00 20 B8 F1 00 0F 1E D0 3B 68 00 21 63 B1 3A 46 00 24 52 F8 04 3F 13 EB 08 03 13 60 3B 68 44 F1 00 08 49 1C 99 42 F4 D1 B8 F1 00 0F 0B D0 3B 68 73 2B 07 D2 07 EB 83 03 C3 F8 04 80 3B 68 5B 1C 3B 60 00 E0 38 60 0D F5 72 7D ?? ?? ?? ?? BD E8 F0 8F FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? CD CC CC CC 00 CA 9A 3B }
	condition:
		$1
}

rule file_200_116_0 {
	meta:
		name = "?add@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 82
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 11 B9 01 20 BD E8 30 88 03 68 00 24 5B B1 02 46 00 25 52 F8 04 3F 5B 18 13 60 03 68 45 F1 00 01 64 1C 9C 42 F5 D1 41 B1 03 68 73 2B 08 D2 00 EB 83 03 59 60 03 68 5B 1C 03 60 01 20 BD E8 30 88 00 23 03 60 00 20 BD E8 30 88 }
	condition:
		$1
}

rule file_200_117_0 {
	meta:
		name = "?add_carry@__crt_strtox@@YAIAAIII@Z"
		size = 30
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 68 00 20 5B 18 40 EB 00 01 9B 18 48 41 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_200_118_0 {
	meta:
		name = "?add_multiply_carry@__crt_strtox@@YAIAAIIII@Z"
		size = 34
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 A1 FB 02 14 2A 68 52 18 44 F1 00 01 9B 18 41 F1 00 00 2B 60 BD E8 30 88 }
	condition:
		$1
}

rule file_200_119_0 {
	meta:
		name = "?advance@?$format_string_parser@D@__crt_stdio_input@@QAA_NXZ"
		size = 288
		refs = "0032 isspace 0078 ?scan_optional_field_width@?$format_string_parser@D@__crt_stdio_input@@AAA_NXZ 0082 ?scan_optional_length_modifier@?$format_string_parser@D@__crt_stdio_input@@AAAXXZ 00aa ?scan_conversion_specifier@?$format_string_parser@D@__crt_stdio_input@@AAA_NXZ 00de __pctype_func 011c ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 E3 68 00 2B 7D D1 A3 68 00 25 25 61 25 75 65 75 A5 75 C4 E9 06 55 25 62 80 F8 24 50 A5 62 18 78 10 B9 01 23 23 61 6C E0 ?? ?? ?? ?? 60 B1 02 23 23 61 A3 68 02 E0 A3 68 5B 1C A3 60 18 78 ?? ?? ?? ?? 00 28 F7 D1 61 E0 A2 68 13 78 25 2B 35 D1 53 78 25 2B 32 D0 04 23 52 1C 23 61 A2 60 13 78 01 26 2A 2B 02 D1 53 1C A3 60 A6 75 20 46 ?? ?? ?? ?? 00 28 45 D0 20 46 ?? ?? ?? ?? A2 68 13 78 77 2B 02 D1 53 1C A3 60 07 E0 43 2B 03 D0 53 2B 18 BF 00 23 00 D1 01 23 0B B1 84 F8 24 60 20 46 ?? ?? ?? ?? 68 B3 A3 6A 03 EB 43 02 23 6A 03 EB 82 02 17 4B D3 5C 4B BB 16 23 17 E0 03 23 23 61 13 78 23 75 13 78 25 2B 18 BF 01 23 08 BF 02 23 13 44 A3 60 ?? ?? ?? ?? 23 7D 30 F8 13 30 13 F4 00 4F 13 D0 A3 68 1A 78 6A B9 2A 23 A5 62 84 F8 24 50 C4 E9 07 55 A5 61 A5 75 65 75 25 75 C4 E9 03 35 00 20 03 E0 5B 1C A3 60 62 75 01 20 BD E8 78 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_120_0 {
	meta:
		name = "?advance@?$format_string_parser@_W@__crt_stdio_input@@QAA_NXZ"
		size = 284
		refs = "0036 iswctype 007e ?scan_optional_field_width@?$format_string_parser@_W@__crt_stdio_input@@AAA_NXZ 0088 ?scan_optional_length_modifier@?$format_string_parser@_W@__crt_stdio_input@@AAAXXZ 00c2 ?scan_conversion_specifier@?$format_string_parser@_W@__crt_stdio_input@@AAA_NXZ 0118 ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 04 46 E3 68 0B B1 00 20 7F E0 A3 68 00 25 25 61 A5 82 E5 82 25 76 C4 E9 08 55 A5 62 84 F8 2C 50 25 63 18 88 10 B9 01 23 23 61 EC E7 08 21 ?? ?? ?? ?? 68 B1 02 23 23 61 A3 68 02 E0 A3 68 9B 1C A3 60 18 88 08 21 ?? ?? ?? ?? 00 28 F6 D1 5B E0 A2 68 13 88 25 2B 4A D1 53 88 25 2B 47 D0 04 23 92 1C 23 61 A2 60 13 88 01 26 2A 2B 02 D1 93 1C A3 60 26 76 20 46 ?? ?? ?? ?? 00 28 C3 D0 20 46 ?? ?? ?? ?? A2 68 13 88 77 2B 02 D1 93 1C A3 60 10 E0 43 2B 0C D0 53 2B 0A D0 A3 6A 0B 2B 09 D0 23 68 13 F0 02 0F 18 BF 01 23 02 D1 00 23 00 E0 00 23 0B B1 84 F8 2C 60 20 46 ?? ?? ?? ?? 00 28 A1 D0 23 6B 03 EB 43 02 A3 6A 03 EB 82 02 10 4B D3 5C CB B9 16 23 C4 E9 03 35 A5 82 E5 82 25 76 C4 E9 08 55 A5 62 84 F8 2C 50 25 63 8B E7 03 23 23 61 13 88 A3 82 13 88 25 2B 18 BF 01 23 08 BF 02 23 02 EB 43 03 A3 60 01 20 BD E8 78 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_121_0 {
	meta:
		name = "?as_double@floating_point_value@__crt_strtox@@QBAAANXZ"
		size = 52
		refs = "0020 _invoke_watson 0028 ??_C@_1BG@GEMHBGAF@?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$AA@ 002c ??_C@_1FM@FELNCOBF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA_?$AAv?$AAa?$AAl@ 0030 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 03 79 13 B1 00 68 BD E8 0C 88 07 4A 05 49 04 48 00 23 00 93 40 F2 9F 13 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_122_0 {
	meta:
		name = "?as_float@floating_point_value@__crt_strtox@@QBAAAMXZ"
		size = 52
		refs = "0020 _invoke_watson 0028 ??_C@_1BI@BANMPGJI@?$AA?$CB?$AA_?$AAi?$AAs?$AA_?$AAd?$AAo?$AAu?$AAb?$AAl?$AAe?$AA?$AA@ 002c ??_C@_1FK@JOJELFFO@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAr?$AAt?$AAo?$AAx?$AA?3?$AA?3?$AAf?$AAl?$AAo?$AAa?$AAt?$AAi?$AAn?$AAg?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA_?$AAv?$AAa?$AAl@ 0030 ??_C@_1GE@DPGDJKLM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 03 79 13 B9 00 68 BD E8 0C 88 07 4A 05 49 04 48 00 23 00 93 40 F2 A5 13 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_123_0 {
	meta:
		name = "?assemble_floating_point_infinity@__crt_strtox@@YAX_NABVfloating_point_value@1@@Z"
		size = 42
		refs = "0010 ??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAAN@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 79 23 B1 09 68 BD E8 00 48 ?? ?? ?? ?? 0A 68 08 B1 01 23 00 E0 00 23 DB 07 43 F0 FF 43 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_124_0 {
	meta:
		name = "?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1ABVfloating_point_value@1@@Z"
		size = 1056
		refs = "007e ??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAAN@Z 0174 fegetround 0210 ??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAAN@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 89 B0 0E 46 1F 46 96 46 07 92 05 46 6F F0 00 09 76 B9 4D 45 0C D8 B0 FA 80 F4 01 22 C4 F1 1F 03 A2 EB 54 14 E4 B2 0C B1 5B 1C 0E E0 00 23 0C E0 B6 FA 86 F3 01 21 C3 F1 1F 02 A1 EB 53 13 DB B2 0B B1 53 1C 00 E0 00 23 20 33 13 9C 21 79 09 B1 35 22 00 E0 18 22 A2 EB 03 08 AE EB 08 0A 40 F2 FF 3E 73 46 CD F8 08 A0 01 B9 7F 23 9A 45 10 DD 21 B1 21 68 38 46 ?? ?? ?? ?? 08 E0 22 68 0F B1 01 23 00 E0 00 23 DB 07 43 F0 FF 43 13 60 03 20 BD E1 09 B1 DF 4B 01 E0 6F F0 7D 03 01 20 02 05 C0 05 40 1E 52 1E CD E9 00 20 9A 45 80 F2 CF 80 73 46 01 B9 7F 23 53 44 43 44 58 1E 03 90 73 46 01 B9 7F 23 C3 F1 00 0A CD F8 08 A0 00 28 80 F2 A7 80 C0 F1 00 0A BA F1 40 0F 80 F0 91 80 AA F1 01 02 A2 F1 20 03 01 21 01 FA 03 FE 01 23 03 FA 02 F9 6F F0 00 02 19 EB 02 03 05 93 4E EB 02 03 06 93 AA F1 20 03 01 22 02 FA 03 F1 01 23 03 FA 0A F3 03 EA 05 02 01 EA 06 03 13 43 02 D0 01 21 04 91 01 E0 00 23 04 93 09 EA 05 02 0E EA 06 03 13 43 02 D0 4F F0 01 0A 01 E0 4F F0 00 0A 9D F8 48 30 4B B1 05 9B 03 EA 05 02 06 9B 33 40 13 43 02 D1 4F F0 00 09 01 E0 4F F0 01 09 BA F1 00 0F 04 D1 B9 F1 00 0F 08 BF 00 21 0D D0 ?? ?? ?? ?? 50 B3 B0 F5 80 7F 25 D0 B0 F5 00 7F 18 BF 00 21 01 D1 57 B3 00 21 03 98 C0 F1 00 0E CE F1 20 03 06 FA 03 F3 25 FA 0E F2 1A 43 AE F1 20 03 26 FA 03 F3 13 43 5D 18 26 FA 0E F2 42 F1 00 06 55 EA 06 03 25 D0 21 79 DD F8 04 E0 81 B1 00 9B 6F F0 00 02 0E E0 39 46 DE E7 BA F1 00 0F DA D0 B9 F1 00 0F 02 D1 04 9B 00 2B D4 D0 01 21 D3 E7 72 46 00 23 9E 42 C0 F0 E0 80 02 D8 95 42 40 F2 DC 80 07 9B 1B 1A A3 EB 08 03 A3 F1 01 0A 00 9A 20 E0 23 79 23 B1 21 68 38 46 ?? ?? ?? ?? 06 E0 22 68 0F B1 01 23 00 E0 00 23 DB 07 13 60 02 20 F6 E0 C0 F1 20 03 25 FA 03 F3 06 FA 00 F2 1A 43 A0 F1 20 03 05 FA 03 F3 85 40 42 EA 03 06 00 9A DD F8 04 E0 00 29 00 F0 B3 80 6F F0 00 03 B1 E0 B8 F1 00 0F 80 F2 96 80 C8 F1 00 0A BA F1 40 0F 02 D3 00 25 00 26 62 E0 AA F1 01 02 A2 F1 20 03 01 21 01 FA 03 F0 01 23 03 FA 02 FE 1E EB 09 08 40 EB 09 03 07 93 AA F1 20 03 01 22 02 FA 03 F1 01 23 03 FA 0A F3 03 EA 05 02 01 EA 06 03 13 43 02 D0 01 21 04 91 01 E0 00 23 04 93 0E EA 05 02 00 EA 06 03 13 43 02 D0 4F F0 01 09 01 E0 4F F0 00 09 9D F8 48 30 43 B1 07 9B 08 EA 05 02 33 40 13 43 02 D1 4F F0 00 08 01 E0 4F F0 01 08 B9 F1 00 0F 04 D1 B8 F1 00 0F 01 D1 00 21 0A E0 ?? ?? ?? ?? 28 B3 B0 F5 80 7F 20 D0 B0 F5 00 7F F4 D1 3F B3 00 21 CA F1 20 03 06 FA 03 F3 25 FA 0A F2 1A 43 AA F1 20 03 26 FA 03 F3 13 43 5D 18 26 FA 0A F2 42 F1 00 06 6F F0 00 09 40 F2 FF 3E 21 79 89 B1 4F F4 00 13 5B 1E 4A 46 0F E0 39 46 E1 E7 B9 F1 00 0F DD D0 B8 F1 00 0F 02 D1 04 9B 00 2B D7 D0 01 21 D6 E7 6F F0 7F 42 00 23 9E 42 21 D3 01 D8 95 42 1E D9 DD F8 08 A0 F3 07 43 EA 55 05 76 08 0A F1 01 0A 73 46 01 B9 7F 23 9A 45 7F F7 5E AF 76 E6 7F F7 5C AF C8 F1 20 03 25 FA 03 F3 06 FA 08 F2 1A 43 A8 F1 20 03 05 FA 03 F3 05 FA 08 F5 4A E7 DD F8 08 A0 49 E7 DD F8 08 A0 26 E7 73 46 00 22 1D 40 16 40 E9 B1 20 68 D0 E9 00 23 23 F0 00 43 43 EA C7 73 C0 E9 00 23 40 F2 FF 33 0A EB 03 01 43 68 6F F3 DF 21 02 60 6F F3 1E 53 43 EA 01 53 83 EA 06 02 6F F3 1F 52 C0 E9 00 53 53 40 43 60 0B E0 0A F1 7F 03 DB 05 03 F0 FF 43 22 68 43 EA C7 73 6F F3 DF 55 2B 43 13 60 00 20 09 B0 BD E8 F0 8F 02 FC FF FF }
	condition:
		$1
}

rule file_200_125_0 {
	meta:
		name = "?assemble_floating_point_value_from_big_integer@__crt_strtox@@YA?AW4SLD_STATUS@@ABUbig_integer@1@I_N1ABVfloating_point_value@1@@Z"
		size = 336
		refs = "0146 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 87 B0 DD F8 40 E0 15 46 99 46 9E F8 04 40 05 95 06 46 0C B1 35 20 00 E0 18 20 A0 F1 01 0A 40 29 13 D8 33 68 0B B1 70 68 00 E0 00 20 01 2B 01 D9 B1 68 00 E0 00 21 B9 F1 00 0F 08 BF 01 23 18 BF 00 23 00 93 2B 46 52 46 77 E0 01 F0 1F 02 4F EA 51 18 04 92 A8 F1 01 01 A8 F1 02 07 EA B9 06 EB 81 03 58 68 B9 F1 00 0F 06 EB 87 03 5C 68 08 BF 01 22 18 BF 00 22 4F B1 39 46 56 F8 04 3F 0B B9 01 23 00 E0 00 23 1A 40 49 1E F6 D1 00 92 01 46 0A EB 47 12 20 46 2B 46 4F E0 01 23 93 40 5B 1E 02 93 02 EB 47 13 06 93 06 EB 87 03 5B 68 C2 F1 40 05 03 93 06 EB 81 03 58 68 A5 F1 20 01 C1 F1 20 03 20 FA 03 F2 A1 F1 20 03 00 FA 03 F3 42 EA 03 04 06 EB 88 03 5B 68 DD F8 08 80 88 40 03 EA 08 02 C5 F1 20 03 22 FA 03 F1 A5 F1 20 03 02 FA 03 F3 AA 40 0B 43 12 18 44 EB 03 01 DD E9 03 40 24 EA 08 03 C3 40 D0 18 41 F1 00 01 B9 F1 00 0F 04 D1 14 EA 08 0F 08 BF 01 22 00 D0 00 22 47 B1 56 F8 04 3F 0B B9 01 23 00 E0 00 23 1A 40 7F 1E F6 D1 00 92 DD E9 05 32 52 44 CD F8 04 E0 ?? ?? ?? ?? 07 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_200_126_0 {
	meta:
		name = "?assemble_floating_point_zero@__crt_strtox@@YAX_NABVfloating_point_value@1@@Z"
		size = 38
		refs = "0010 ??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAAN@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 79 23 B1 09 68 BD E8 00 48 ?? ?? ?? ?? 0A 68 08 B1 01 23 00 E0 00 23 DB 07 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_127_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAIABUbig_integer@1@@Z"
		size = 62
	strings:
		$1 = { 2D E9 00 48 EB 46 01 68 11 B9 00 20 BD E8 00 88 50 F8 21 30 01 20 B3 FA 83 F3 C3 F1 1F 02 A0 EB 53 13 DB B2 2B B1 52 1C 4B 1E 02 EB 43 10 BD E8 00 88 00 22 4B 1E 02 EB 43 10 BD E8 00 88 }
	condition:
		$1
}

rule file_200_128_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAII@Z"
		size = 36
	strings:
		$1 = { 2D E9 00 48 EB 46 B0 FA 80 F3 01 21 C3 F1 1F 02 A1 EB 53 13 DB B2 13 B1 50 1C BD E8 00 88 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_129_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAI_K@Z"
		size = 100
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 A9 B9 B0 F1 FF 3F 12 D8 B0 FA 80 F3 01 21 C3 F1 1F 02 A1 EB 53 13 DB B2 23 B1 50 1C 5D F8 04 BB 5D F8 0C FB 00 20 5D F8 04 BB 5D F8 0C FB B1 FA 81 F3 01 21 C3 F1 1F 02 A1 EB 53 13 DB B2 33 B1 53 1C 03 F1 20 00 5D F8 04 BB 5D F8 0C FB 00 23 03 F1 20 00 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_200_132_0 {
	meta:
		name = "?convert_decimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
		size = 5076
		refs = "0008 __security_push_cookie 0160 memset 017a memcpy 0208 _errno 0210 _invalid_parameter_noinfo 0694 ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 0698 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 069c ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 06ec ?as_double@floating_point_value@__crt_strtox@@QBAAANXZ 06f4 ??$assemble_floating_point_infinity@N@__crt_strtox@@YAX_NAAN@Z 06fa ?as_float@floating_point_value@__crt_strtox@@QBAAAMXZ 0702 ??$assemble_floating_point_infinity@M@__crt_strtox@@YAX_NAAM@Z 07c8 memcpy_s 0f6c ??$assemble_floating_point_zero@N@__crt_strtox@@YAX_NAAN@Z 12a6 ?divide@__crt_strtox@@YA_KAAUbig_integer@1@ABU21@@Z 1392 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1ABVfloating_point_value@1@@Z 13ae ?assemble_floating_point_value_from_big_integer@__crt_strtox@@YA?AW4SLD_STATUS@@ABUbig_integer@1@I_N1ABVfloating_point_value@1@@Z 13b6 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? AD F5 33 6D 0B 79 04 46 0F 91 0D 94 0B B1 35 23 00 E0 18 23 5B 1C 10 93 D4 E9 00 32 DF F8 68 96 DF F8 70 86 00 2B B8 BF 00 23 93 42 19 46 28 BF 11 46 5B 1A 07 93 63 18 03 F1 08 00 A3 18 08 33 0A 93 1B 1A 00 27 08 34 00 21 09 93 05 90 02 97 14 97 BE 46 84 42 00 F0 D9 81 14 AE 14 AD 8A 46 09 29 41 D1 EF B1 DF F8 30 56 00 21 14 A8 50 F8 04 3F A3 FB 05 32 5B 18 42 F1 00 01 7F 1E 03 60 F5 D1 05 98 14 AD 59 B1 14 9B 73 2B 06 D2 06 EB 83 03 59 60 14 9F 7F 1C 14 97 02 E0 00 27 FB E7 14 9F BE F1 00 0F 1C D0 00 21 67 B1 14 AA 52 F8 04 3F 13 EB 0E 03 13 60 14 9F 4A F1 00 0E 49 1C 02 97 B9 42 F3 D1 BE F1 00 0F 0A D0 73 2F 06 D2 05 EB 87 03 C3 F8 04 E0 14 9F 7F 1C 00 E0 00 27 14 97 4F F0 00 0E 00 21 14 F8 01 3B 0E EB 8E 02 49 1C 03 EB 42 0E 84 42 B2 D1 02 97 02 97 02 97 02 97 02 97 11 91 CD F8 20 E0 00 29 00 F0 7E 81 A1 FB 08 32 D3 08 0C 93 98 46 04 93 00 F0 2A 81 DD F8 54 A0 B8 F1 26 0F 02 D9 4F F0 26 09 00 E0 C1 46 DF F8 5C 35 0D F2 C4 50 00 21 03 EB 89 05 15 F8 01 4C 15 F8 02 6C CD F8 18 90 33 19 B2 00 CD F8 C0 35 ?? ?? ?? ?? 35 F8 04 3C DF F8 2C 15 A2 00 01 EB 83 01 0D F2 C4 53 03 EB 86 00 ?? ?? ?? ?? DD F8 C0 55 01 2D 29 D8 DD F8 C4 05 10 B9 00 27 14 97 E9 E0 01 28 00 F0 E8 80 00 2F 00 F0 E5 80 00 21 14 AC 54 F8 04 3F A0 FB 03 32 5B 18 42 F1 00 01 7F 1E 23 60 F5 D1 00 29 00 F0 D4 80 14 9A 73 2A 06 D2 14 AB 03 EB 82 03 59 60 14 9F 7F 1C DE E7 00 27 02 97 14 97 00 23 C7 E0 01 2F 31 D8 2F 46 02 97 54 46 14 95 AA 00 16 D0 4F F4 E6 73 9A 42 05 D8 0D F2 C4 51 15 A8 ?? ?? ?? ?? 0A E0 15 A8 1A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 14 9F 02 97 00 2C B7 D0 01 2C 00 F0 A3 80 00 2F 00 F0 A0 80 00 21 14 A8 50 F8 04 3F A4 FB 03 32 5B 18 42 F1 00 01 7F 1E 03 60 F5 D1 B9 E7 BD 42 05 D2 0D F2 C4 52 29 46 15 AB 3D 46 03 E0 15 AA 0D F2 C4 53 39 46 00 27 00 24 CD E9 02 71 FC 97 0E 93 00 29 65 D0 FC AB FC AE D3 1A 0B 93 53 F8 06 90 B9 F1 00 0F 07 D1 BC 42 52 D1 00 22 67 1C 72 60 02 97 FC 97 4C E0 4F F0 00 0A D0 46 20 46 00 2D 44 D0 0E 9B B6 46 1A 46 73 28 21 D0 B8 42 06 D1 00 23 CE F8 04 30 08 EB 04 03 5B 1C FC 93 52 F8 04 3B 08 F1 01 08 12 92 A3 FB 09 21 5E F8 04 3F 9B 18 41 F1 00 02 13 EB 0A 03 CE F8 00 30 FC 9F 42 F1 00 0A 40 1C 02 97 A8 45 01 D0 12 9A DB E7 BA F1 00 0F 18 D0 FC AB 03 EB 80 02 73 28 68 D0 B8 42 03 D1 00 23 53 60 43 1C FC 93 52 F8 04 3F 00 21 13 EB 0A 03 41 EB 01 0A 40 1C 13 60 FC 9F BA F1 00 0F EA D1 02 97 0B 9B 03 99 73 28 50 D0 64 1C 36 1D 8C 42 A1 D1 DD F8 10 80 DD F8 18 90 14 97 BA 00 15 D0 4F F4 E6 73 9A 42 04 D8 FD A9 15 A8 ?? ?? ?? ?? 0A E0 15 A8 1A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 14 9F 02 97 01 23 6B B3 B8 EB 09 08 CD F8 10 80 7F F4 DA AE 11 99 0C 9B DF F8 14 93 03 EB 83 03 B1 EB 43 03 23 D0 09 EB 83 03 53 F8 04 0C C8 B1 01 28 1C D0 DF B1 00 21 14 AC 54 F8 04 3F A0 FB 03 32 5B 18 42 F1 00 01 7F 1E 23 60 F5 D1 61 B1 14 9A 73 2A 06 D2 14 AB 03 EB 82 03 59 60 14 9F 7F 1C 00 E0 00 27 14 97 00 E0 14 9F 02 97 08 98 F0 B1 00 21 67 B1 14 AA 00 24 52 F8 04 3F 1B 18 13 60 14 9F 44 F1 00 00 49 1C 02 97 B9 42 F4 D1 70 B1 DF F8 A8 82 73 2F 08 D2 14 AB 03 EB 87 03 58 60 14 9F 7F 1C 02 97 14 97 03 E0 00 27 FA E7 DF F8 88 82 07 99 DD F8 54 A0 00 29 00 F0 76 81 A1 FB 08 32 D3 08 CD E9 0B 33 98 46 00 F0 21 81 01 E0 DD F8 54 A0 B8 F1 26 0F 02 D9 4F F0 26 09 00 E0 C1 46 94 4B 0D F2 C4 50 00 21 03 EB 89 05 15 F8 01 4C 15 F8 02 6C CD F8 18 90 33 19 B2 00 CD F8 C0 35 ?? ?? ?? ?? 35 F8 04 3C 89 49 A2 00 01 EB 83 01 0D F2 C4 53 03 EB 86 00 ?? ?? ?? ?? DD F8 C0 45 01 2C 29 D8 DD F8 C4 05 10 B9 00 27 14 97 E3 E0 01 28 00 F0 E2 80 00 2F 00 F0 DF 80 00 21 14 AC 54 F8 04 3F A0 FB 03 32 5B 18 42 F1 00 01 7F 1E 23 60 F5 D1 00 29 00 F0 CE 80 14 9A 73 2A 06 D2 14 AB 03 EB 82 03 59 60 14 9F 7F 1C DE E7 00 27 02 97 14 97 00 23 C1 E0 01 2F 31 D8 27 46 02 97 55 46 14 94 A2 00 16 D0 4F F4 E6 73 9A 42 05 D8 0D F2 C4 51 15 A8 ?? ?? ?? ?? 0A E0 15 A8 1A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 14 9F 02 97 00 2D B7 D0 01 2D 00 F0 9D 80 00 2F 00 F0 9A 80 00 21 14 A8 50 F8 04 3F A5 FB 03 32 5B 18 42 F1 00 01 7F 1E 03 60 F5 D1 B9 E7 BC 42 06 D2 0D F2 C4 52 A6 46 0D F1 54 0A 3C 46 03 E0 15 AA 0D F2 C4 5A BE 46 00 27 00 25 CD E9 02 7E FC 97 CD F8 10 A0 BE F1 00 0F 5C D0 FC AB FC AE D3 1A 08 93 53 F8 06 90 B9 F1 00 0F 07 D1 BD 42 47 D1 00 22 6F 1C 72 60 02 97 FC 97 41 E0 00 21 88 46 28 46 D4 B3 B6 46 73 28 1D D0 B8 42 06 D1 00 23 CE F8 04 30 08 EB 05 03 5B 1C FC 93 5A F8 04 3B 08 F1 01 08 A3 FB 09 32 C9 18 5E F8 04 3F 42 F1 00 02 5B 18 CE F8 00 30 FC 9F 42 F1 00 01 40 1C 02 97 A0 45 DF D1 B1 B1 FC AB 03 EB 80 02 73 28 77 D0 B8 42 03 D1 00 23 53 60 43 1C FC 93 52 F8 04 3F 00 27 5B 18 47 EB 07 01 40 1C 13 60 FC 9F 00 29 EC D1 02 97 DD F8 0C E0 73 28 61 D0 08 9B 6D 1C DD F8 10 A0 36 1D 75 45 AA D1 DD F8 2C 80 DD F8 18 90 14 97 BA 00 15 D0 4F F4 E6 73 9A 42 04 D8 FD A9 15 A8 ?? ?? ?? ?? 0A E0 15 A8 1A 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 14 9F 02 97 01 23 DB B3 B8 EB 09 08 CD F8 2C 80 7F F4 E2 AE 0C 9B 07 99 03 EB 83 03 B1 EB 43 03 47 D0 04 4A 02 EB 83 03 53 F8 04 0C 68 B9 00 27 02 97 14 97 3E E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? CD CC CC CC 00 CA 9A 3B 01 28 31 D0 8F B3 00 21 14 AC 54 F8 04 3F A0 FB 03 32 5B 18 42 F1 00 01 7F 1E 23 60 F5 D1 09 B3 14 9A 73 2A 07 D2 14 AB 03 EB 82 03 59 60 14 9F 7F 1C 14 97 17 E0 0F 9D 0D 9A 2B 79 92 F8 08 43 28 46 33 B1 ?? ?? ?? ?? 01 46 20 46 ?? ?? ?? ?? 05 E0 ?? ?? ?? ?? 01 46 20 46 ?? ?? ?? ?? 03 20 00 F0 53 BE 14 9F 02 97 0F B9 00 21 11 E0 14 AB 53 F8 27 30 01 21 B3 FA 83 F3 C3 F1 1F 02 A1 EB 53 13 DB B2 0B B1 52 1C 00 E0 00 22 7B 1E 02 EB 43 11 10 9B 0E 91 99 42 80 F0 2A 86 09 98 00 28 00 F0 2A 86 DD F8 14 90 DD F8 28 A0 4F F0 00 08 00 26 00 21 D1 45 CD F8 20 82 00 F0 31 82 88 AD 88 AC 00 27 00 20 8E 46 09 29 5F D1 B8 F1 00 0F 2B D0 DF F8 54 4C 00 21 88 A8 50 F8 04 3F A3 FB 04 32 5B 18 42 F1 00 01 B8 F1 01 08 03 60 F4 D1 88 AC B9 B1 88 9B 73 2B 09 D2 05 EB 83 03 59 60 DD F8 20 82 08 F1 01 08 CD F8 20 82 0C E0 00 23 0D F2 94 72 89 A8 4F F4 E6 71 88 93 CD F8 90 E7 ?? ?? ?? ?? DD F8 20 82 00 20 5E B3 00 21 B8 F1 00 0F 0C D0 88 AA 8E 46 52 F8 04 3F 9B 19 13 60 DD F8 20 82 4E F1 00 06 49 1C 41 45 F4 D1 CE B1 B8 F1 73 0F 09 D2 04 EB 88 03 5E 60 DD F8 20 82 08 F1 01 08 CD F8 20 82 0C E0 88 90 00 23 0D F2 94 72 89 A8 4F F4 E6 71 CD F8 90 77 ?? ?? ?? ?? DD F8 20 82 00 26 00 21 00 20 86 46 19 F8 01 3B 06 EB 86 02 49 1C 03 EB 42 06 D1 45 94 D1 02 9F 11 96 08 91 00 29 00 F0 BA 81 DF F8 78 3B A1 FB 03 32 D2 08 13 46 06 93 0C 92 00 F0 30 81 DF F8 60 2B 26 2B 88 BF 26 23 02 EB 83 05 15 F8 01 4C 15 F8 02 6C 04 93 0D F2 C4 50 33 19 B2 00 00 21 CD F8 C0 35 ?? ?? ?? ?? 35 F8 04 3C DF F8 2C 1B A2 00 01 EB 83 01 0D F2 C4 53 03 EB 86 00 ?? ?? ?? ?? DD F8 C0 35 01 2B 44 D8 DD F8 C4 05 80 B9 00 23 0D F2 94 72 89 A8 4F F4 E6 71 CD F8 90 37 88 93 ?? ?? ?? ?? DD F8 20 82 01 23 4F F4 E6 75 EC E0 01 28 F9 D0 B8 F1 00 0F F6 D0 00 21 88 AC 54 F8 04 3F A0 FB 03 32 5B 18 42 F1 00 01 B8 F1 01 08 23 60 F4 D1 00 29 E5 D0 88 9A 73 2A 0A D2 88 AB 03 EB 82 03 59 60 DD F8 20 82 08 F1 01 08 CD F8 20 82 D9 E7 00 23 0D F2 94 72 89 A8 4F F4 E6 71 CD F8 90 37 88 93 ?? ?? ?? ?? DD F8 20 82 00 23 CB E7 B8 F1 01 0F 3A D8 4F F4 E6 75 89 9C 88 93 29 46 9B 00 0D F2 C4 52 89 A8 ?? ?? ?? ?? 34 B9 00 23 CD F8 90 37 88 93 0D F2 94 72 9E E0 DD F8 20 82 01 2C 00 F0 A0 80 B8 F1 00 0F 00 F0 9C 80 00 21 88 A8 50 F8 04 3F A4 FB 03 32 5B 18 42 F1 00 01 B8 F1 01 08 03 60 F4 D1 00 29 00 F0 8A 80 88 9A 73 2A 0A D2 88 AB 03 EB 82 03 59 60 DD F8 20 82 08 F1 01 08 CD F8 20 82 7D E0 A3 E0 43 45 05 D2 0D F2 C4 51 89 A8 07 90 1E 46 05 E0 89 A9 0D F2 C4 52 46 46 07 92 98 46 00 22 00 24 FC 92 05 96 00 2E 5D D0 FC AB FC AD CB 1A 03 93 53 F8 05 A0 BA F1 00 0F 06 D1 94 42 4E D1 00 22 6A 60 62 1C FC 92 49 E0 4F F0 00 0E F1 46 20 46 B8 F1 00 0F 40 D0 07 9B 2E 46 19 46 73 28 1E D0 90 42 05 D1 00 23 73 60 09 EB 04 03 5B 1C FC 93 51 F8 04 3B 09 F1 01 09 A3 FB 0A 32 0A 91 13 EB 0E 01 56 F8 04 3F 42 F1 00 02 5B 18 42 F1 00 0E 40 1C 33 60 FC 9A C1 45 01 D0 0A 99 DE E7 BE F1 00 0F 17 D0 FC AB 03 EB 80 01 73 28 12 D0 90 42 03 D1 00 23 4B 60 43 1C FC 93 51 F8 04 3F 00 22 13 EB 0E 03 42 EB 02 0E 40 1C 0B 60 FC 9A BE F1 00 0F EA D1 05 9E 03 9B 73 28 33 D0 64 1C 2D 1D B4 42 A5 D1 88 92 93 00 FD AA 4F F4 E6 75 29 46 89 A8 ?? ?? ?? ?? DD F8 20 82 01 23 AB B1 06 9B 04 9A 9B 1A 06 93 7F F4 D2 AE 08 99 0C 9A 02 EB 82 03 B1 EB 43 03 4A D0 DF F8 EC 28 02 EB 83 03 53 F8 04 0C F0 B9 4F F4 E6 75 00 23 0D F2 94 72 89 A8 29 46 CD F8 90 37 88 93 ?? ?? ?? ?? DD F8 20 82 36 E0 4F F4 E6 75 00 23 0D F2 94 72 89 A8 29 46 CD F8 90 37 88 93 ?? ?? ?? ?? DD F8 20 82 00 23 CB E7 01 28 22 D0 B8 F1 00 0F 1F D0 00 21 88 AC 54 F8 04 3F A0 FB 03 32 5B 18 42 F1 00 01 B8 F1 01 08 23 60 F4 D1 79 B1 88 9A 4F F4 E6 75 73 2A CA D2 88 AB 03 EB 82 03 59 60 DD F8 20 82 08 F1 01 08 CD F8 20 82 03 E0 DD F8 20 82 4F F4 E6 75 11 98 58 B3 00 21 B8 F1 00 0F 0C D0 88 AA 00 24 52 F8 04 3F 1B 18 13 60 DD F8 20 82 44 F1 00 00 49 1C 41 45 F4 D1 C8 B1 B8 F1 73 0F 0A D2 88 AB 03 EB 88 03 58 60 DD F8 20 82 08 F1 01 08 CD F8 20 82 0B E0 00 23 0D F2 94 72 89 A8 29 46 CD F8 90 37 88 93 ?? ?? ?? ?? DD F8 20 82 09 98 0D 9A 13 68 00 2B 01 DA C0 1A 09 90 00 23 FE 93 DF F8 F0 37 4F F0 01 0A CD E9 FC AA A0 FB 03 32 D1 46 CD F8 08 A0 D2 08 13 46 0B 93 08 92 00 F0 57 81 DF F8 CC 27 26 2B 88 BF 26 23 02 EB 83 05 15 F8 01 4C 15 F8 02 6C 06 93 0D F2 94 70 33 19 B2 00 00 21 CD F8 90 37 ?? ?? ?? ?? 35 F8 04 3C DF F8 98 17 A2 00 01 EB 83 01 0D F2 94 73 03 EB 86 00 ?? ?? ?? ?? DD F8 90 37 01 2B 4A D8 DD F8 94 07 A0 B9 00 23 0D F2 C4 52 FD A8 4F F4 E6 71 CD F8 C0 35 FC 93 ?? ?? ?? ?? DD F8 F0 93 DD F8 F4 A3 CD F8 08 90 01 23 4F F4 E6 74 0F E1 01 28 F9 D0 B9 F1 00 0F F6 D0 00 21 FC AC 54 F8 04 3F A0 FB 03 32 5B 18 42 F1 00 01 B9 F1 01 09 23 60 F4 D1 00 29 E1 D0 FC 9A 73 2A 0A D2 FC AB 03 EB 82 03 59 60 DD F8 F0 93 09 F1 01 09 CD F8 F0 93 D5 E7 00 23 0D F2 94 72 FD A8 4F F4 E6 71 CD F8 90 37 FC 93 ?? ?? ?? ?? DD E9 FC 9A 00 23 CD F8 08 90 C9 E7 B9 F1 01 0F 4F D8 4F F4 E6 74 FC 93 21 46 9B 00 0D F2 94 72 FD A8 ?? ?? ?? ?? BA F1 00 0F 07 D1 00 23 0D F2 94 72 CD F8 90 37 FC 93 FD A8 BA E0 DD F8 F0 93 BA F1 01 0F CD F8 08 90 00 F0 BA 80 B9 F1 00 0F 00 F0 B6 80 00 21 FC A8 50 F8 04 3F AA FB 03 32 5B 18 42 F1 00 01 B9 F1 01 09 03 60 F4 D1 00 29 00 F0 A2 80 FC 9A 73 2A 0A D2 FC AB 03 EB 82 03 59 60 DD F8 F0 93 09 F1 01 09 CD F8 F0 93 95 E0 00 23 CD F8 90 37 0D F2 94 72 00 23 FD A8 21 46 FC 93 ?? ?? ?? ?? DD F8 F0 93 00 23 CD F8 08 90 87 E0 4B 45 05 D2 0D F2 94 71 FD A8 07 90 9E 46 05 E0 FD A9 0D F2 94 72 CE 46 07 92 99 46 00 22 00 24 CD F8 C0 25 CD F8 14 E0 BE F1 00 0F 61 D0 0D F5 B8 63 0D F5 B8 65 CB 1A 03 93 59 59 0A 91 39 B9 94 42 52 D1 00 22 6A 60 62 1C CD F8 C0 25 4C E0 00 26 B2 46 20 46 B9 F1 00 0F 44 D0 07 9B AE 46 04 93 73 28 22 D0 90 42 07 D1 00 23 CE F8 04 30 0A EB 04 03 5B 1C CD F8 C0 35 04 9A 0A F1 01 0A 52 F8 04 3B 04 92 A3 FB 01 21 5E F8 04 3F 9B 18 41 F1 00 02 9B 19 42 F1 00 06 40 1C CE F8 00 30 DD F8 C0 25 CA 45 01 D0 0A 99 DA E7 C6 B1 0D F5 B8 63 03 EB 80 01 73 28 12 D0 90 42 04 D1 00 23 4B 60 43 1C CD F8 C0 35 51 F8 04 3F 00 22 9B 19 42 EB 02 06 40 1C 0B 60 DD F8 C0 25 00 2E EA D1 DD F8 14 E0 03 9B 73 28 3D D0 64 1C 2D 1D 74 45 A3 D1 FC 92 93 00 0D F2 C4 52 FD A8 4F F4 E6 74 21 46 ?? ?? ?? ?? DD F8 F0 93 CD F8 08 90 01 23 DD F8 F4 A3 7B B3 0B 9B 06 9A 9B 1A 0B 93 7F F4 AB AE DD E9 08 20 02 EB 82 03 B0 EB 43 03 15 D0 DF F8 0C 25 02 EB 83 03 53 F8 04 0C E8 B9 00 23 0D F6 64 12 FD A8 4F F4 E6 71 CD F8 60 39 FC 93 ?? ?? ?? ?? DD F8 F0 93 CD F8 08 90 B8 F1 00 0F 50 D1 00 22 61 E0 00 23 CD F8 60 39 0D F6 64 12 4F F4 E6 74 38 E7 21 46 23 E0 01 28 EE D0 B9 F1 00 0F EB D0 00 21 FC AC 54 F8 04 3F A0 FB 03 32 5B 18 42 F1 00 01 B9 F1 01 09 23 60 F4 D1 00 29 D8 D0 FC 9A 73 2A 0A D2 FC AB 03 EB 82 03 59 60 DD F8 F0 93 09 F1 01 09 CD F8 F0 93 CC E7 4F F4 E6 71 00 23 0D F6 64 12 FD A8 CD F8 60 39 FC 93 ?? ?? ?? ?? 0D 9B 0F 9D 93 F8 08 43 2B 79 28 46 33 B1 ?? ?? ?? ?? 01 46 20 46 ?? ?? ?? ?? 07 E0 ?? ?? ?? ?? 0C B1 01 23 00 E0 00 23 DB 07 03 60 02 20 15 E2 88 AB 53 F8 28 30 01 21 B3 FA 83 F3 C3 F1 1F 02 A1 EB 53 13 DB B2 0B B1 52 1C 00 E0 00 22 A8 F1 01 03 02 EB 43 12 B9 F1 00 0F 17 D0 FC AB 53 F8 29 30 01 20 B3 FA 83 F3 C3 F1 1F 01 A0 EB 53 13 DB B2 0B B1 49 1C 00 E0 00 21 A9 F1 01 03 01 EB 43 13 93 42 02 D9 A3 EB 02 0A 01 E0 4F F0 00 0A CD F8 0C A0 BA F1 00 0F 00 F0 93 80 0A F0 1F 01 C1 F1 20 03 01 22 0A 93 02 FA }
	condition:
		$1
}

rule file_200_133_0 {
	meta:
		name = "?convert_hexadecimal_string_to_floating_type_common@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@ABVfloating_point_value@1@@Z"
		size = 152
		refs = "0090 ?assemble_floating_point_value@__crt_strtox@@YA?AW4SLD_STATUS@@_KH_N1ABVfloating_point_value@1@@Z"
	strings:
		$1 = { 2D E9 FE 49 0D F1 20 0B 0C 46 23 79 00 27 06 46 BE 46 0B B1 35 22 00 E0 18 22 33 68 06 F1 08 01 13 44 A3 F1 01 08 73 68 33 44 03 F1 08 00 81 42 1C D0 25 79 2D B1 4F F4 00 13 5B 1E 6F F0 00 02 02 E0 6F F0 7F 42 00 23 9E 45 0F D8 01 D3 97 42 0C D8 3B 0F 43 EA 0E 12 0B 78 A8 F1 04 08 13 EB 07 17 42 F1 00 0E 49 1C 81 42 E3 D1 01 23 06 E0 3B B1 11 F8 01 3B 0B B9 01 23 00 E0 00 23 81 42 F6 D1 00 93 96 F8 08 33 42 46 71 46 38 46 01 94 ?? ?? ?? ?? BD E8 FE 89 }
	condition:
		$1
}

rule file_200_134_0 {
	meta:
		name = "?count_sequential_high_zeroes@__crt_strtox@@YAII@Z"
		size = 38
	strings:
		$1 = { 2D E9 00 48 EB 46 B0 FA 80 F3 01 21 C3 F1 1F 02 A1 EB 53 13 DB B2 1B B1 C2 F1 1F 00 BD E8 00 88 20 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_136_0 {
	meta:
		name = "?data@?$scanset_storage@$01@__crt_stdio_input@@QBAPAEXZ"
		size = 46
		refs = "0014 _calloc_base 001c _free_base"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 68 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 28 68 ?? ?? ?? ?? 00 20 2C 60 ?? ?? ?? ?? 28 68 BD E8 30 88 }
	condition:
		$1
}

rule file_200_137_0 {
	meta:
		name = "?denormal_mantissa_mask@floating_point_value@__crt_strtox@@QBA_KXZ"
		size = 34
	strings:
		$1 = { 2D E9 00 48 EB 46 03 79 2B B1 4F F4 80 11 49 1E 6F F0 00 00 03 E0 4F F4 00 00 40 1E 00 21 BD E8 00 88 }
	condition:
		$1
}

rule file_200_138_0 {
	meta:
		name = "?divide@__crt_strtox@@YA_KAAUbig_integer@1@ABU21@@Z"
		size = 848
		refs = "005c __rt_udiv 0098 __rt_udiv64"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8F B0 07 46 3A 68 0E 46 07 96 0A 97 32 B9 4F F0 00 0A 50 46 00 21 0F B0 BD E8 F0 8F 33 68 00 2B F5 D0 A2 F1 01 09 5B 1E 4B D1 76 68 01 2E 08 D1 D7 F8 04 A0 00 23 3B 60 00 21 50 46 0F B0 BD E8 F0 8F B9 F1 00 0F 11 D1 79 68 00 23 30 46 3B 60 00 B9 F9 DE ?? ?? ?? ?? 82 46 79 60 00 29 E9 D0 01 23 3B 60 00 21 0F B0 BD E8 F0 8F 00 21 00 22 00 23 B9 F1 FF 3F 4F F0 00 0A 11 D0 07 EB 89 04 09 F1 01 05 13 46 62 68 00 21 30 46 00 B9 F9 DE ?? ?? ?? ?? 0B 91 51 46 24 1F 82 46 6D 1E F1 D1 00 20 C7 E9 00 02 BB 60 2B B1 02 23 3B 60 50 46 0F B0 BD E8 F0 8F 01 23 3B 60 50 46 0F B0 BD E8 F0 8F 4B 45 A3 D8 03 F1 01 0E A9 EB 03 00 CD F8 14 E0 81 45 4A 46 10 DB A9 EB 00 03 06 EB 83 03 07 EB 89 01 5C 68 4D 68 AC 42 05 D1 52 1E 1B 1F 09 1F 82 42 F6 DA 00 E0 00 D2 40 1C 00 28 86 D0 06 EB 8E 01 56 F8 2E 60 51 F8 04 4C 01 25 B6 FA 86 F3 C3 F1 1F 02 A5 EB 53 13 DB B2 CD E9 02 64 13 B1 C2 F1 1F 05 00 E0 20 25 00 95 C5 F1 20 08 8D B1 24 FA 08 F2 06 FA 05 F3 42 EA 03 06 AC 40 CD E9 02 64 BE F1 02 0F 05 D9 51 F8 08 3C 23 FA 08 F3 1C 43 03 94 42 1E 00 21 08 92 00 2A 4F F0 00 0A C0 F2 D5 80 96 44 07 EB 82 03 07 EB 8E 08 00 9F CD F8 10 E0 01 93 00 20 C7 F1 20 01 CE 45 02 D8 D8 F8 04 20 00 E0 00 22 58 F8 04 49 06 92 0D 90 D8 F8 00 50 CD F8 24 80 13 46 DF B1 C7 F1 20 03 25 FA 03 F0 24 FA 01 F3 BA 40 42 EA 03 01 A7 F1 20 03 04 FA 03 F3 04 FA 07 F2 0B 43 BD 40 BE F1 03 0F 40 EA 02 04 05 D3 58 F8 04 1C C7 F1 20 02 D1 40 0D 43 22 46 00 21 30 46 00 B9 F9 DE ?? ?? ?? ?? DD F8 08 E0 00 24 0D 93 88 46 06 46 89 B1 73 1C 6F EA 04 01 48 EB 01 00 A3 FB 0E 13 4F F0 00 08 00 FB 0E 33 52 18 53 F1 00 04 6F F0 00 03 1E 46 01 E0 6F F0 00 03 00 2C 18 D8 01 D3 9A 42 15 D8 03 98 6F F0 00 07 A0 FB 06 13 00 FB 08 33 93 42 0B D3 01 D8 A9 42 08 D9 F6 19 48 EB 07 08 12 EB 0E 02 44 F1 00 04 00 2C ED D0 00 9F B8 F1 00 0F 01 D1 00 2E 44 D0 05 99 00 24 00 20 C9 B1 07 9B 01 9D 8E 46 99 46 59 F8 04 1F A1 FB 06 23 01 FB 08 33 12 19 43 EB 00 04 6B 68 00 20 93 42 01 D2 64 1C 40 41 9B 1A 45 F8 04 3F BE F1 01 0E EA D1 05 99 00 23 83 42 1E D8 02 D3 06 9B A3 42 1A D2 00 22 91 B1 01 9B 07 9C 0D 46 18 46 00 27 50 F8 04 3F D2 18 54 F8 04 3F 47 F1 00 01 9B 18 41 F1 00 02 6D 1E 03 60 F2 D1 00 9F 6F F0 00 03 F6 18 43 EB 08 03 0D 93 DD F8 10 E0 AE F1 01 09 01 E0 DD F8 10 E0 DD E9 08 28 01 9B 51 46 52 1E 1B 1F AE F1 01 0E B2 46 02 9E 08 92 01 93 00 2A CD F8 10 E0 4F F0 00 00 BF F6 36 AF 0A 9F 3B 68 09 F1 01 04 22 46 9C 42 08 D2 07 EB 84 00 00 25 40 F8 04 5F 3B 68 52 1C 9A 42 F9 D3 3C 60 34 B1 3A 68 57 F8 22 30 13 B9 53 1E 3B 60 F8 D1 50 46 0F B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_200_141_0 {
	meta:
		name = "?exponent_bias@floating_point_value@__crt_strtox@@QBAHXZ"
		size = 20
		altNames = "?maximum_binary_exponent@floating_point_value@__crt_strtox@@QBAHXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 79 40 F2 FF 30 03 B9 7F 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_143_0 {
	meta:
		name = "?get@?$console_input_adapter@D@__crt_stdio_input@@QAAHXZ"
		size = 30
		refs = "000a _getche_nolock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? B0 F1 FF 3F 02 D0 23 68 5B 1C 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_200_144_0 {
	meta:
		name = "?get@?$console_input_adapter@_W@__crt_stdio_input@@QAAGXZ"
		size = 32
		refs = "000a _getwche_nolock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 4F F6 FF 73 98 42 02 D0 23 68 5B 1C 23 60 BD E8 18 88 }
	condition:
		$1
}

rule file_200_145_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAADXZ"
		size = 74
		refs = "0030 _getche_nolock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B D0 E9 04 32 D0 E9 02 14 5B 1C 42 F1 00 02 C0 E9 04 32 51 EA 04 03 06 D0 D0 E9 04 23 A3 42 02 D3 0C D8 8A 42 0A D8 04 68 ?? ?? ?? ?? B0 F1 FF 3F 04 D0 23 68 40 B2 5B 1C 23 60 00 E0 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_146_0 {
	meta:
		name = "?get@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_WXZ"
		size = 76
		refs = "0030 _getwche_nolock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B D0 E9 04 32 D0 E9 02 14 5B 1C 42 F1 00 02 C0 E9 04 32 51 EA 04 03 06 D0 D0 E9 04 23 A3 42 02 D3 0D D8 8A 42 0B D8 04 68 ?? ?? ?? ?? 4F F6 FF 72 90 42 04 D0 23 68 5B 1C 23 60 90 42 00 D1 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_147_0 {
	meta:
		name = "?invert@?$scanset_buffer@E@__crt_stdio_input@@QAAXXZ"
		size = 40
	strings:
		$1 = { 2D E9 00 48 EB 46 00 F1 20 03 1A 1A 00 21 98 42 88 BF 00 22 32 B1 03 78 49 1C DB 43 00 F8 01 3B 91 42 F8 D1 BD E8 00 88 }
	condition:
		$1
}

rule file_200_148_0 {
	meta:
		name = "?invert@?$scanset_buffer@_W@__crt_stdio_input@@QAAXXZ"
		size = 76
		refs = "0016 _calloc_base 001e _free_base"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2B 68 4F F4 00 56 5B B9 01 21 30 46 ?? ?? ?? ?? 04 46 28 68 ?? ?? ?? ?? 00 20 2C 60 ?? ?? ?? ?? 29 68 00 20 8B 19 5A 1A 99 42 88 BF 00 22 32 B1 0B 78 40 1C DB 43 01 F8 01 3B 90 42 F8 D1 BD E8 78 88 }
	condition:
		$1
}

rule file_200_149_0 {
	meta:
		name = "?is_character_allowed_in_string@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABA_NW4conversion_mode@2@H@Z"
		size = 78
		altNames = "?is_character_allowed_in_string@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABA_NW4conversion_mode@2@H@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 B2 F1 FF 3F 01 D1 00 20 1C E0 D1 B1 01 29 12 D0 08 29 F8 D1 D1 B2 CB 10 A1 EB C3 03 01 22 9A 40 00 EB D1 03 93 F8 3C 30 1A 42 18 BF 01 23 08 BF 00 23 00 2B 04 E0 A2 F1 09 03 04 2B E3 D9 20 2A E1 D0 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_150_0 {
	meta:
		name = "?is_character_allowed_in_string@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABA_NW4conversion_mode@2@G@Z"
		size = 114
		refs = "002c _calloc_base 0034 _free_base"
		altNames = "?is_character_allowed_in_string@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABA_NW4conversion_mode@2@G@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 15 46 4F F6 FF 73 9D 42 06 46 01 D1 00 20 2A E0 41 B3 01 29 20 D0 08 29 F8 D1 73 6C 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 70 6C ?? ?? ?? ?? 00 20 74 64 ?? ?? ?? ?? EB 10 A5 EB C3 03 01 22 02 FA 03 F1 73 6C EA 08 D3 5C 19 42 18 BF 01 23 08 BF 00 23 00 2B 04 E0 09 2D 01 D3 0D 2D D5 D9 20 2D D3 D0 01 20 BD E8 78 88 }
	condition:
		$1
}

rule file_200_151_0 {
	meta:
		name = "?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
		size = 44
	strings:
		$1 = { 2D E9 00 48 EB 46 A0 F1 30 03 09 2B 01 D8 01 20 0A E0 A0 F1 61 03 19 2B F9 D9 A0 F1 41 03 19 2B F5 D9 5F 28 F3 D0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_153_0 {
	meta:
		name = "?is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@1@W4length_modifier@1@@Z"
		size = 36
		refs = "0020 ?constraints@?1??is_length_valid@__crt_stdio_input@@YA_NW4conversion_mode@2@W4length_modifier@2@@Z@4QAY0M@$$CBEA"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 EB 40 03 01 EB 83 02 04 4B D3 5C 0B B1 01 20 00 E0 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_154_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_NDQAU__crt_locale_pointers@@@Z"
		size = 64
		refs = "001a _isctype_l 0028 __pctype_func"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B C4 B2 69 B1 0A 68 53 68 01 2B 05 DD 0A 46 08 21 20 46 ?? ?? ?? ?? 09 E0 13 68 33 F8 14 30 03 E0 ?? ?? ?? ?? 30 F8 14 30 03 F0 08 00 08 B1 01 20 00 E0 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_156_0 {
	meta:
		name = "?is_usable@?$scanset_buffer@E@__crt_stdio_input@@QAA_NXZ"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 08 B1 01 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_157_0 {
	meta:
		name = "?is_usable@?$scanset_buffer@_W@__crt_stdio_input@@QAA_NXZ"
		size = 54
		refs = "0014 _calloc_base 001c _free_base"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 68 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 28 68 ?? ?? ?? ?? 00 20 2C 60 ?? ?? ?? ?? 2B 68 0B B1 01 20 00 E0 00 20 BD E8 30 88 }
	condition:
		$1
}

rule file_200_161_0 {
	meta:
		name = "?length@?$format_string_parser@D@__crt_stdio_input@@QBAIXZ"
		size = 102
	strings:
		$1 = { 2D E9 00 48 EB 46 83 6A 00 2B 09 DB 01 2B 24 DD 06 2B 12 DD 07 2B 06 D0 08 2B 1E D0 09 2B 0C D0 00 20 BD E8 00 88 03 6A 2B B1 03 2B 01 D0 08 2B F6 D1 08 20 F5 E7 04 20 F3 E7 02 6A 0A 2A EF D8 DF E8 02 F0 08 0F 09 08 07 07 08 08 06 08 07 07 E6 E7 EE E7 EF E7 02 20 E3 E7 90 F8 24 30 00 2B F9 D1 01 20 DD E7 }
	condition:
		$1
}

rule file_200_162_0 {
	meta:
		name = "?length@?$format_string_parser@_W@__crt_stdio_input@@QBAIXZ"
		size = 102
	strings:
		$1 = { 2D E9 00 48 EB 46 03 6B 00 2B 09 DB 01 2B 24 DD 06 2B 12 DD 07 2B 06 D0 08 2B 1E D0 09 2B 0C D0 00 20 BD E8 00 88 83 6A 2B B1 03 2B 01 D0 08 2B F6 D1 08 20 F5 E7 04 20 F3 E7 82 6A 0A 2A EF D8 DF E8 02 F0 08 0F 09 08 07 07 08 08 06 08 07 07 E6 E7 EE E7 EF E7 02 20 E3 E7 90 F8 2C 30 00 2B F9 D1 01 20 DD E7 }
	condition:
		$1
}

rule file_200_166_0 {
	meta:
		name = "?make_big_integer@__crt_strtox@@YA?AUbig_integer@1@_K@Z"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 00 21 C0 E9 00 12 83 60 1B B9 01 23 03 60 BD E8 00 88 02 23 03 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_167_0 {
	meta:
		name = "?mantissa_bits@floating_point_value@__crt_strtox@@QBAHXZ"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 03 79 0B B1 35 20 00 E0 18 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_169_0 {
	meta:
		name = "?maximum_signed_value@__crt_strtox@@YA_J_K@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 6F F0 00 00 6F F0 00 41 BD E8 00 88 }
	condition:
		$1
}

rule file_200_170_0 {
	meta:
		name = "?minimum_binary_exponent@floating_point_value@__crt_strtox@@QBAHXZ"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 03 79 0B B1 03 48 01 E0 6F F0 7D 00 BD E8 00 88 FE DE 02 FC FF FF }
	condition:
		$1
}

rule file_200_171_0 {
	meta:
		name = "?minimum_signed_value@__crt_strtox@@YA_J_K@Z"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 00 20 4F F0 00 41 BD E8 00 88 }
	condition:
		$1
}

rule file_200_174_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAAUbig_integer@1@ABU21@@Z"
		size = 652
		refs = "0008 __security_push_cookie 0026 __security_pop_cookie 00b0 _errno 00cc memcpy 00d8 memset 00f6 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? FA B0 0D 46 2B 68 80 46 01 2B 39 D8 6D 68 45 B9 00 23 C8 F8 00 30 01 20 7A B0 ?? ?? ?? ?? BD E8 F0 8F 01 2D 1D D0 D8 F8 00 40 D4 B1 08 F1 04 01 00 20 51 F8 04 3B A5 FB 03 32 1B 18 42 F1 00 00 64 1E 41 F8 04 3C F4 D1 58 B1 D8 F8 00 30 73 2B 0D D2 08 EB 83 03 58 60 D8 F8 00 30 5B 1C C8 F8 00 30 01 20 7A B0 ?? ?? ?? ?? BD E8 F0 8F 00 23 C8 F8 00 30 00 20 7A B0 ?? ?? ?? ?? BD E8 F0 8F D8 F8 00 00 02 90 01 28 4F D8 D8 F8 04 70 C8 F8 00 30 2B 68 08 F1 04 04 4F EA 83 09 B9 F1 00 0F 25 D0 1C B9 ?? ?? ?? ?? 16 23 1D E0 4F F4 E6 76 15 F1 04 0F 07 D0 B1 45 05 D8 4A 46 29 1D 20 46 ?? ?? ?? ?? 13 E0 32 46 00 21 20 46 ?? ?? ?? ?? 15 F1 04 0F 03 D1 ?? ?? ?? ?? 16 23 04 E0 B1 45 05 D9 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 00 2F 8E D0 01 2F B5 D0 D8 F8 00 00 00 28 B1 D0 00 21 54 F8 04 3B A7 FB 03 32 5B 18 42 F1 00 01 40 1E 44 F8 04 3C F4 D1 00 29 A3 D0 D8 F8 00 30 73 2B A5 D2 08 EB 83 03 59 60 96 E7 83 42 05 D2 08 F1 04 04 01 94 29 1D 1F 46 06 E0 07 46 18 46 2A 1D CD E9 01 20 08 F1 04 01 00 22 00 25 06 92 00 97 00 2F 5A D0 06 AB CB 1A 0D F1 18 0A 03 93 00 21 53 F8 0A 90 B9 F1 00 0F 06 D1 95 42 48 D1 6A 1C CA F8 04 10 06 92 43 E0 00 26 B6 46 2C 46 E8 B3 01 9B 57 46 19 46 73 2C 1E D0 94 42 05 D1 00 23 7B 60 0E EB 05 03 5B 1C 06 93 51 F8 04 2B 57 F8 04 3F 0E F1 01 0E 04 91 A2 FB 09 12 C8 18 42 F1 00 03 82 19 02 98 43 F1 00 06 3A 60 06 9A 64 1C 86 45 01 D0 04 99 DE E7 AE B1 06 AB 03 EB 84 01 73 2C 2D D0 94 42 03 D1 00 23 4B 60 63 1C 06 93 51 F8 04 3F 00 22 9B 19 42 EB 02 06 64 1C 0B 60 06 9A 00 2E EC D1 03 9B 00 9F 00 21 73 2C 17 D0 6D 1C BD 42 0A F1 04 0A AA D1 C8 F8 00 20 92 00 30 D0 18 F1 04 0F 14 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 01 20 7A B0 ?? ?? ?? ?? BD E8 F0 8F 00 23 C8 F8 00 30 00 20 7A B0 ?? ?? ?? ?? BD E8 F0 8F 4F F4 E6 76 B2 42 08 F1 04 00 08 D8 07 A9 ?? ?? ?? ?? 01 20 7A B0 ?? ?? ?? ?? BD E8 F0 8F 32 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 01 20 7A B0 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_200_175_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 92
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 21 B9 00 23 03 60 01 20 BD E8 78 88 01 29 FA D0 04 68 00 2C F7 D0 06 1D 00 25 56 F8 04 3B A1 FB 03 32 5B 19 42 F1 00 05 64 1E 46 F8 04 3C F4 D1 45 B1 03 68 73 2B 08 D2 00 EB 83 03 5D 60 03 68 5B 1C 03 60 01 20 BD E8 78 88 00 23 03 60 00 20 BD E8 78 88 }
	condition:
		$1
}

rule file_200_176_0 {
	meta:
		name = "?multiply_64_32@__crt_strtox@@YA_K_KI@Z"
		size = 18
	strings:
		$1 = { 2D E9 00 48 EB 46 A2 FB 00 03 02 FB 01 31 BD E8 00 88 }
	condition:
		$1
}

rule file_200_177_0 {
	meta:
		name = "?multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 852
		refs = "0008 __security_push_cookie 002a ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 0036 ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 0060 memset 0074 memcpy 00da __security_pop_cookie 00fe _errno 0124 _invalid_parameter_noinfo 02b0 ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? AD F5 72 7D CF 4B 08 91 81 46 A1 FB 03 32 D3 08 1F 46 CD E9 06 73 4F F0 00 06 00 F0 3E 81 ?? ?? ?? ?? C0 F2 00 0A 4F F4 E6 78 ?? ?? ?? ?? C0 F2 00 02 26 2F 88 BF 26 23 98 BF 3B 46 02 EB 83 05 15 F8 01 4C 15 F8 02 6C 05 93 7F A8 33 19 B2 00 00 21 7E 93 ?? ?? ?? ?? 35 F8 04 3C 7F A8 A2 00 0A EB 83 01 00 EB 86 00 ?? ?? ?? ?? 7E 9B 01 2B 31 D8 7F 9D 0D B9 00 23 1D E0 01 2D 1D D0 D9 F8 00 40 D4 B1 09 F1 04 01 00 20 51 F8 04 3B A5 FB 03 32 1B 18 42 F1 00 00 64 1E 41 F8 04 3C F4 D1 58 B1 D9 F8 00 30 73 2B 57 D2 09 EB 83 03 58 60 D9 F8 00 30 5B 1C C9 F8 00 30 01 23 00 2B 40 F0 E4 80 00 23 C9 F8 00 30 00 20 0D F5 72 7D ?? ?? ?? ?? BD E8 F0 8F D9 F8 00 50 00 95 01 2D 40 D8 D9 F8 04 50 9A 00 C9 F8 00 30 09 F1 04 04 AA B1 1C B9 ?? ?? ?? ?? 16 23 0D E0 42 45 20 46 03 D8 7F A9 ?? ?? ?? ?? 09 E0 42 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 0D B9 00 23 C9 E7 01 2D C9 D0 D9 F8 00 00 00 28 C5 D0 00 21 54 F8 04 3B A5 FB 03 32 5B 18 42 F1 00 01 40 1E 44 F8 04 3C F4 D1 00 29 B7 D0 D9 F8 00 30 73 2B 03 D2 09 EB 83 03 59 60 AA E7 00 23 C9 F8 00 30 AC E7 AB 42 05 D2 09 F1 04 00 03 90 7F A9 9A 46 06 E0 AA 46 1D 46 7F AA 00 95 09 F1 04 01 03 92 00 22 0A 92 96 46 CD F8 04 A0 BA F1 00 0F 5B D0 0A AB 0A A8 CB 1A 04 93 02 90 53 F8 00 80 B8 F1 00 0F 07 D1 96 45 46 D1 00 22 42 60 0E F1 01 02 0A 92 40 E0 00 27 00 26 74 46 D5 B3 03 9B 05 46 9A 46 73 2C 1A D0 94 42 05 D1 00 23 6B 60 06 EB 0E 03 5B 1C 0A 93 5A F8 04 2B 55 F8 04 3F A2 FB 08 12 C8 18 42 F1 00 03 C2 19 43 F1 00 07 00 9B 76 1C 2A 60 0A 9A 64 1C 9E 42 E2 D1 AF B1 0A AB 03 EB 84 01 73 2C 5F D0 94 42 03 D1 00 23 4B 60 63 1C 0A 93 51 F8 04 3F 00 22 DB 19 42 EB 02 07 64 1C 0B 60 0A 9A 00 2F EC D1 04 9B DD E9 00 5A 02 98 73 2C 48 D0 0E F1 01 0E 00 1D 02 90 D6 45 AB D1 06 9F 4F F4 E6 78 C9 F8 00 20 92 00 18 D0 19 F1 04 0F 03 D1 ?? ?? ?? ?? 16 23 0E E0 42 45 09 F1 04 00 03 D8 0B A9 ?? ?? ?? ?? 09 E0 42 46 00 21 ?? ?? ?? ?? ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? ?? ?? ?? ?? C0 F2 00 0A 05 9B FF 1A 06 97 7F F4 CB AE DD E9 07 31 00 26 03 EB 83 03 B1 EB 43 02 0A D0 ?? ?? ?? ?? C0 F2 00 03 03 EB 82 03 53 F8 04 5C A5 B9 C9 F8 00 60 01 20 0D F5 72 7D ?? ?? ?? ?? BD E8 F0 8F 00 23 C9 F8 00 30 C9 F8 00 30 00 20 0D F5 72 7D ?? ?? ?? ?? BD E8 F0 8F 01 2D EA D0 D9 F8 00 40 00 2C E6 D0 09 F1 04 01 00 20 51 F8 04 3B A5 FB 03 32 1B 18 42 F1 00 00 64 1E 41 F8 04 3C F4 D1 00 28 D6 D0 D9 F8 00 30 73 2B 0E D2 09 EB 83 03 58 60 D9 F8 00 30 5B 1C C9 F8 00 30 01 20 0D F5 72 7D ?? ?? ?? ?? BD E8 F0 8F C9 F8 00 60 00 20 0D F5 72 7D ?? ?? ?? ?? BD E8 F0 8F CD CC CC CC }
	condition:
		$1
}

rule file_200_178_0 {
	meta:
		name = "?multiply_core@__crt_strtox@@YAIQAIII@Z"
		size = 44
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 00 20 61 B1 55 F8 04 3B A2 FB 03 34 1B 18 44 F1 00 00 49 1E 45 F8 04 3C F4 D1 BD E8 30 88 BD E8 30 88 }
	condition:
		$1
}

rule file_200_179_0 {
	meta:
		name = "?normal_mantissa_mask@floating_point_value@__crt_strtox@@QBA_KXZ"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 03 79 2B B1 4F F4 00 11 49 1E 6F F0 00 00 02 E0 6F F0 7F 40 00 21 BD E8 00 88 }
	condition:
		$1
}

rule file_200_180_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAID@Z"
		size = 50
	strings:
		$1 = { 2D E9 00 48 EB 46 30 28 03 DB 39 28 D8 BF 30 38 0D DD 61 28 03 DB 7A 28 D8 BF 57 38 07 DD 41 28 03 DB 5A 28 D8 BF 37 38 01 DD 6F F0 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_200_181_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAI_W@Z"
		size = 372
	strings:
		$1 = { 2D E9 00 48 EB 46 30 28 C0 F0 9F 80 3A 28 02 D2 A0 F1 30 03 96 E0 4F F6 10 72 90 42 80 F0 8C 80 B0 F5 CC 6F C0 F0 91 80 40 F2 6A 63 98 42 02 D2 A0 F5 CC 63 86 E0 B0 F5 DE 6F C0 F0 86 80 40 F2 FA 63 98 42 02 D2 A0 F5 DE 63 7B E0 40 F6 66 13 98 42 7A D3 B0 F5 17 6F 01 D2 C3 1A 72 E0 40 F6 E6 13 98 42 71 D3 B0 F5 1F 6F F6 D3 40 F6 66 23 98 42 6A D3 B0 F5 27 6F EF D3 40 F6 E6 23 98 42 63 D3 B0 F5 2F 6F E8 D3 40 F6 66 33 98 42 5C D3 B0 F5 37 6F E1 D3 40 F6 66 43 98 42 55 D3 B0 F5 47 6F DA D3 40 F6 E6 43 98 42 4E D3 B0 F5 4F 6F D3 D3 40 F6 66 53 98 42 47 D3 B0 F5 57 6F CC D3 B0 F5 65 6F 41 D3 40 F6 5A 63 98 42 02 D2 A0 F5 65 63 37 E0 B0 F5 6D 6F 37 D3 40 F6 DA 63 98 42 02 D2 A0 F5 6D 63 2D E0 B0 F5 72 6F 2D D3 40 F6 2A 73 98 42 02 D2 A0 F5 72 63 23 E0 B0 F5 82 5F 23 D3 41 F2 4A 03 98 42 02 D2 A0 F5 82 53 19 E0 B0 F5 BF 5F 19 D3 41 F2 EA 73 98 42 02 D2 A0 F5 BF 53 0F E0 41 F6 10 02 90 42 0E D3 41 F6 1A 03 98 42 0A D2 83 1A 05 E0 4F F6 1A 73 98 42 F9 D3 6F F0 00 03 13 F1 01 0F 11 D1 41 28 01 D3 5A 28 03 D9 61 28 09 D3 7A 28 07 D8 61 28 02 D3 7A 28 98 BF 20 38 A0 F1 37 03 01 E0 6F F0 00 03 18 46 BD E8 00 88 }
	condition:
		$1
}

rule file_200_182_0 {
	meta:
		name = "?process@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@QAAHXZ"
		size = 128
		refs = "000e _errno 001e ?process_state@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ 0028 ?advance@?$format_string_parser@D@__crt_stdio_input@@QAA_NXZ 0036 _getche_nolock 0058 _ungetch_nolock 0076 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 A3 69 53 B9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 05 2C E0 20 46 ?? ?? ?? ?? 28 B1 04 F1 10 00 ?? ?? ?? ?? 00 28 F5 D1 D4 E9 1A 53 93 B9 ?? ?? ?? ?? 10 F1 01 0F 03 D0 A3 68 5B 1C A3 60 01 E0 6F F0 00 05 10 F1 01 0F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 23 68 13 F0 01 0F 18 BF 01 23 08 BF 00 23 33 B1 E4 69 24 B1 ?? ?? ?? ?? 04 60 ?? ?? ?? ?? 28 46 BD E8 30 88 }
	condition:
		$1
}

rule file_200_183_0 {
	meta:
		name = "?process@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@QAAHXZ"
		size = 130
		refs = "000e _errno 001e ?process_state@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ 0028 ?advance@?$format_string_parser@_W@__crt_stdio_input@@QAA_NXZ 0036 _getwche_nolock 005a _ungetwch_nolock 0078 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 A3 69 53 B9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 05 2D E0 20 46 ?? ?? ?? ?? 28 B1 04 F1 10 00 ?? ?? ?? ?? 00 28 F5 D1 D4 E9 14 53 9B B9 ?? ?? ?? ?? 4F F6 FF 72 90 42 04 D0 A3 68 5B 1C A3 60 90 42 03 D1 6F F0 00 05 90 42 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 23 68 13 F0 01 0F 18 BF 01 23 08 BF 00 23 33 B1 E4 69 24 B1 ?? ?? ?? ?? 04 60 ?? ?? ?? ?? 28 46 BD E8 30 88 }
	condition:
		$1
}

rule file_200_184_0 {
	meta:
		name = "?process_character_count_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 32
		refs = "0018 ?write_integer@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 90 F8 26 30 0B B1 01 20 04 E0 82 68 00 23 00 93 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_200_185_0 {
	meta:
		name = "?process_character_count_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 32
		refs = "0018 ?write_integer@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 90 F8 28 30 0B B1 01 20 04 E0 82 68 00 23 00 93 ?? ?? ?? ?? BD E8 0C 88 }
	condition:
		$1
}

rule file_200_186_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 180
		refs = "0022 ?length@?$format_string_parser@D@__crt_stdio_input@@QBAIXZ 0034 ??$process_string_specifier_tchar@_W@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@_W@Z 0040 ??$process_string_specifier_tchar@D@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@D@Z 004a ?process_string_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@2@@Z 0072 ?process_integer_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NI_N@Z 0090 ?process_floating_point_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ 00a8 ?write_integer@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 04 46 A2 6B 09 2A 4E D8 DF E8 02 F0 05 19 2C 32 35 38 3A 3D 1E 41 04 F1 10 00 ?? ?? ?? ?? 01 28 07 D0 02 28 3F D1 00 22 00 21 20 46 ?? ?? ?? ?? 3A E0 00 22 00 21 20 46 ?? ?? ?? ?? 34 E0 01 21 20 46 ?? ?? ?? ?? 2F E0 04 F1 10 00 ?? ?? ?? ?? 01 28 04 D0 02 28 26 D1 00 22 08 21 E5 E7 00 22 08 21 E8 E7 01 22 00 21 20 46 ?? ?? ?? ?? 1B E0 01 22 0A 21 F8 E7 00 22 08 21 F5 E7 00 22 F8 E7 00 22 10 21 F0 E7 20 46 ?? ?? ?? ?? 0C E0 94 F8 26 30 0B B1 01 20 07 E0 A2 68 00 23 20 46 00 93 ?? ?? ?? ?? 00 E0 00 20 BD E8 1E 88 }
	condition:
		$1
}

rule file_200_187_0 {
	meta:
		name = "?process_conversion_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 180
		refs = "0022 ?length@?$format_string_parser@_W@__crt_stdio_input@@QBAIXZ 0034 ??$process_string_specifier_tchar@_W@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@_W@Z 0040 ??$process_string_specifier_tchar@D@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@D@Z 004a ?process_string_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@2@@Z 0072 ?process_integer_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NI_N@Z 0090 ?process_floating_point_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ 00a8 ?write_integer@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 04 46 22 6C 09 2A 4E D8 DF E8 02 F0 05 19 2C 32 35 38 3A 3D 1E 41 04 F1 10 00 ?? ?? ?? ?? 01 28 07 D0 02 28 3F D1 00 22 00 21 20 46 ?? ?? ?? ?? 3A E0 00 22 00 21 20 46 ?? ?? ?? ?? 34 E0 01 21 20 46 ?? ?? ?? ?? 2F E0 04 F1 10 00 ?? ?? ?? ?? 01 28 04 D0 02 28 26 D1 00 22 08 21 E5 E7 00 22 08 21 E8 E7 01 22 00 21 20 46 ?? ?? ?? ?? 1B E0 01 22 0A 21 F8 E7 00 22 08 21 F5 E7 00 22 F8 E7 00 22 10 21 F0 E7 20 46 ?? ?? ?? ?? 0C E0 94 F8 28 30 0B B1 01 20 07 E0 A2 68 00 23 20 46 00 93 ?? ?? ?? ?? 00 E0 00 20 BD E8 1E 88 }
	condition:
		$1
}

rule file_200_188_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 72
		refs = "000e ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAAV?$console_input_adapter@D@0@QAU__crt_locale_pointers@@@Z 001e _ungetch_nolock 0026 ?length@?$format_string_parser@D@__crt_stdio_input@@QBAIXZ 0038 ??$process_floating_point_specifier_t@N@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ 0040 ??$process_floating_point_specifier_t@M@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 21 6E 08 30 ?? ?? ?? ?? B0 F1 FF 3F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 04 F1 10 00 ?? ?? ?? ?? 04 28 07 D0 08 28 18 BF 00 20 06 D1 20 46 ?? ?? ?? ?? 02 E0 20 46 ?? ?? ?? ?? BD E8 18 88 }
	condition:
		$1
}

rule file_200_189_0 {
	meta:
		name = "?process_floating_point_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 74
		refs = "000e ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$console_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z 0020 _ungetwch_nolock 0028 ?length@?$format_string_parser@_W@__crt_stdio_input@@QBAIXZ 003a ??$process_floating_point_specifier_t@N@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ 0042 ??$process_floating_point_specifier_t@M@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 A1 6C 08 30 ?? ?? ?? ?? 4F F6 FF 73 98 42 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 04 F1 10 00 ?? ?? ?? ?? 04 28 07 D0 08 28 18 BF 00 20 06 D1 20 46 ?? ?? ?? ?? 02 E0 20 46 ?? ?? ?? ?? BD E8 18 88 }
	condition:
		$1
}

rule file_200_190_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NI_N@Z"
		size = 116
		refs = "0014 ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAAV?$console_input_adapter@D@0@QAU__crt_locale_pointers@@@Z 0024 _ungetch_nolock 003c ??$make_input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@QAV?$console_input_adapter@D@__crt_stdio_input@@_KQA_N@Z 0048 ??$parse_integer@_KV?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@0@H_N@Z 006a ?write_integer@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8D B0 04 46 0E 46 21 6E 08 30 15 46 ?? ?? ?? ?? B0 F1 FF 3F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 00 23 8D F8 08 30 02 AB A2 6A 00 93 E3 6A 04 A8 04 F1 08 01 ?? ?? ?? ?? 01 46 20 6E 2B 46 32 46 ?? ?? ?? ?? 9D F8 08 30 0B B9 00 20 0B E0 94 F8 26 30 0B B1 01 20 06 E0 01 23 00 93 02 46 0B 46 20 46 ?? ?? ?? ?? 0D B0 BD E8 70 88 }
	condition:
		$1
}

rule file_200_191_0 {
	meta:
		name = "?process_integer_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NI_N@Z"
		size = 118
		refs = "0014 ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$console_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z 0026 _ungetwch_nolock 003e ??$make_input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@YA?AV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@QAV?$console_input_adapter@_W@__crt_stdio_input@@_KQA_N@Z 004a ??$parse_integer@_KV?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@@__crt_strtox@@YA_KQAU__crt_locale_pointers@@V?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@0@H_N@Z 006c ?write_integer@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B 8D B0 04 46 0E 46 A1 6C 08 30 15 46 ?? ?? ?? ?? 4F F6 FF 73 98 42 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 00 23 8D F8 08 30 02 AB 22 6B 00 93 63 6B 04 A8 04 F1 08 01 ?? ?? ?? ?? 01 46 A0 6C 2B 46 32 46 ?? ?? ?? ?? 9D F8 08 30 0B B9 00 20 0B E0 94 F8 28 30 0B B1 01 20 06 E0 01 23 00 93 02 46 0B 46 20 46 ?? ?? ?? ?? 0D B0 BD E8 70 88 }
	condition:
		$1
}

rule file_200_192_0 {
	meta:
		name = "?process_literal_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 60
		refs = "000a _getche_nolock 0028 _ungetch_nolock 0036 ?process_literal_character_tchar@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_ND@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? B0 F1 FF 3F 0B D0 A3 68 5B 1C A3 60 94 F8 24 30 98 42 07 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 00 20 BD E8 18 88 41 B2 20 46 ?? ?? ?? ?? F8 E7 }
	condition:
		$1
}

rule file_200_193_0 {
	meta:
		name = "?process_literal_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 60
		refs = "000a _getwche_nolock 0030 _ungetwch_nolock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 4F F6 FF 72 90 42 04 D0 A3 68 5B 1C A3 60 90 42 01 D1 00 20 09 E0 A3 8C 98 42 05 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? F4 E7 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_194_0 {
	meta:
		name = "?process_literal_character_tchar@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_ND@Z"
		size = 96
		refs = "000c __pctype_func 001c _getche_nolock 0040 _ungetch_nolock"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 46 04 46 ?? ?? ?? ?? EB B2 30 F8 13 30 13 F4 00 4F 1E D0 ?? ?? ?? ?? 10 F1 01 0F 02 D0 A3 68 5B 1C A3 60 94 F8 25 30 98 42 12 D0 10 F1 01 0F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 15 F1 01 0F 05 D0 A3 68 28 46 5B 1E A3 60 ?? ?? ?? ?? 00 20 00 E0 01 20 BD E8 30 88 }
	condition:
		$1
}

rule file_200_196_0 {
	meta:
		name = "?process_state@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 118
		refs = "0018 ?process_conversion_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ 0026 _getche_nolock 0044 _ungetch_nolock 0050 ?process_literal_character_tchar@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_ND@Z 005c ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAAV?$console_input_adapter@D@0@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 6A 02 2B 22 D0 03 2B 08 D0 04 2B 17 D1 ?? ?? ?? ?? 48 B3 E3 6E 5B 1C E3 66 25 E0 ?? ?? ?? ?? B0 F1 FF 3F 0B D0 A3 68 5B 1C A3 60 94 F8 24 30 98 42 06 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 00 20 12 E0 41 B2 20 46 ?? ?? ?? ?? 0D E0 21 6E 04 F1 08 00 ?? ?? ?? ?? B0 F1 FF 3F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_197_0 {
	meta:
		name = "?process_state@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 118
		refs = "001e ?process_conversion_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ 002c _getwche_nolock 004e _ungetwch_nolock 005a ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$console_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 6A 02 2B 21 D0 03 2B 0B D0 04 2B 01 D0 00 20 2A E0 20 46 ?? ?? ?? ?? 30 B3 63 6D 5B 1C 63 65 22 E0 ?? ?? ?? ?? 4F F6 FF 72 90 42 EF D0 A3 68 5B 1C A3 60 90 42 EA D0 A3 8C 98 42 13 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? E1 E7 A1 6C 04 F1 08 00 ?? ?? ?? ?? 4F F6 FF 73 98 42 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_198_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@2@@Z"
		size = 86
		refs = "0014 ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAAV?$console_input_adapter@D@0@QAU__crt_locale_pointers@@@Z 0024 _ungetch_nolock 002c ?length@?$format_string_parser@D@__crt_stdio_input@@QBAIXZ 0042 ??$process_string_specifier_tchar@_W@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@_W@Z 004e ??$process_string_specifier_tchar@D@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 46 01 2D 04 46 0B D1 21 6E 08 30 ?? ?? ?? ?? B0 F1 FF 3F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 04 F1 10 00 ?? ?? ?? ?? 01 28 09 D0 02 28 18 BF 00 20 0A D1 00 22 29 46 20 46 ?? ?? ?? ?? 04 E0 00 22 29 46 20 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_200_199_0 {
	meta:
		name = "?process_string_specifier@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@2@@Z"
		size = 88
		refs = "0014 ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$console_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z 0026 _ungetwch_nolock 002e ?length@?$format_string_parser@_W@__crt_stdio_input@@QBAIXZ 0044 ??$process_string_specifier_tchar@_W@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@_W@Z 0050 ??$process_string_specifier_tchar@D@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NW4conversion_mode@1@D@Z"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 46 01 2D 04 46 0C D1 A1 6C 08 30 ?? ?? ?? ?? 4F F6 FF 73 98 42 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 04 F1 10 00 ?? ?? ?? ?? 01 28 09 D0 02 28 18 BF 00 20 0A D1 00 22 29 46 20 46 ?? ?? ?? ?? 04 E0 00 22 29 46 20 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_200_200_0 {
	meta:
		name = "?process_whitespace@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 40
		refs = "000e ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@D@__crt_stdio_input@@YAHAAV?$console_input_adapter@D@0@QAU__crt_locale_pointers@@@Z 001e _ungetch_nolock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 21 6E 08 30 ?? ?? ?? ?? B0 F1 FF 3F 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_201_0 {
	meta:
		name = "?process_whitespace@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NXZ"
		size = 42
		refs = "000e ??$skip_whitespace@Vconsole_input_adapter@__crt_stdio_input@@_W@__crt_stdio_input@@YAGAAV?$console_input_adapter@_W@0@QAU__crt_locale_pointers@@@Z 0020 _ungetwch_nolock"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 A1 6C 08 30 ?? ?? ?? ?? 4F F6 FF 73 98 42 04 D0 A3 68 5B 1E A3 60 ?? ?? ?? ?? 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_203_0 {
	meta:
		name = "?reset@?$scanset_buffer@E@__crt_stdio_input@@QAAXXZ"
		size = 20
		refs = "000c memset"
	strings:
		$1 = { 2D E9 00 48 EB 46 18 B1 20 22 00 21 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_200_204_0 {
	meta:
		name = "?reset@?$scanset_buffer@_W@__crt_stdio_input@@QAAXXZ"
		size = 58
		refs = "0014 _calloc_base 001c _free_base 0032 memset"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 05 46 2B 68 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 28 68 ?? ?? ?? ?? 00 20 2C 60 ?? ?? ?? ?? 28 68 20 B1 4F F4 00 52 00 21 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_200_205_0 {
	meta:
		name = "?reset_token_state@?$format_string_parser@D@__crt_stdio_input@@AAAXXZ"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 03 61 03 75 43 75 83 75 C0 E9 06 33 03 62 80 F8 24 30 83 62 BD E8 00 88 }
	condition:
		$1
}

rule file_200_206_0 {
	meta:
		name = "?reset_token_state@?$format_string_parser@_W@__crt_stdio_input@@AAAXXZ"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 03 61 83 82 C3 82 03 76 C0 E9 08 33 83 62 80 F8 2C 30 03 63 BD E8 00 88 }
	condition:
		$1
}

rule file_200_207_0 {
	meta:
		name = "?reset_token_state_for_error@?$format_string_parser@D@__crt_stdio_input@@AAAXH@Z"
		size = 34
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 03 13 03 75 43 75 83 75 C0 E9 06 33 03 62 80 F8 24 30 83 62 BD E8 00 88 }
	condition:
		$1
}

rule file_200_208_0 {
	meta:
		name = "?reset_token_state_for_error@?$format_string_parser@_W@__crt_stdio_input@@AAAXH@Z"
		size = 34
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 C0 E9 03 13 83 82 C3 82 03 76 C0 E9 08 33 83 62 80 F8 2C 30 03 63 BD E8 00 88 }
	condition:
		$1
}

rule file_200_209_0 {
	meta:
		name = "?restore_state@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA_N_K@Z"
		size = 36
		altNames = "?restore_state@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_N_K@Z ?restore_state@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA_N_K@Z ?restore_state@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_N_K@Z ?restore_state@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAA_N_K@Z ?restore_state@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAA_N_K@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B D0 E9 04 14 8A 42 03 D1 A3 42 08 BF 01 20 03 D0 83 69 00 22 00 20 1A 70 BD E8 18 88 }
	condition:
		$1
}

rule file_200_211_0 {
	meta:
		name = "?right_shift_with_rounding@__crt_strtox@@YA_K_N_KI0@Z"
		size = 226
		refs = "0096 fegetround"
	strings:
		$1 = { 2D E9 F8 4F 0D F1 20 0B DD F8 28 80 1F 46 92 46 B8 F1 40 0F 04 46 02 D3 00 20 00 21 57 E0 A8 F1 01 02 A2 F1 20 03 01 21 01 FA 03 F0 01 23 03 FA 02 F5 6F F0 00 03 15 EB 03 0E 43 41 00 93 A8 F1 20 03 01 22 02 FA 03 F1 01 23 03 FA 08 F3 03 EA 0A 02 01 EA 07 03 13 43 02 D0 4F F0 01 09 01 E0 4F F0 00 09 05 EA 0A 02 00 EA 07 03 13 43 9D F8 2C 30 18 BF 01 26 08 BF 00 26 3B B1 00 9B 0E EA 0A 02 3B 40 13 43 08 BF 00 25 00 D0 01 25 16 B9 0D B9 00 24 0A E0 ?? ?? ?? ?? D0 B1 B0 F5 80 7F 04 D0 B0 F5 00 7F F4 D1 CC B1 00 24 C8 F1 20 03 07 FA 03 F3 2A FA 08 F2 1A 43 A8 F1 20 03 27 FA 03 F3 13 43 18 19 27 FA 08 F2 42 F1 00 01 BD E8 F8 8F 00 2E E9 D0 15 B9 B9 F1 00 0F E5 D0 01 24 E4 E7 }
	condition:
		$1
}

rule file_200_212_0 {
	meta:
		name = "?save_state@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBA_KXZ"
		size = 16
		altNames = "?save_state@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBA_KXZ ?save_state@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBA_KXZ ?save_state@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBA_KXZ ?save_state@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBA_KXZ ?save_state@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBA_KXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 D3 E9 04 01 BD E8 00 88 }
	condition:
		$1
}

rule file_200_214_0 {
	meta:
		name = "?scan_conversion_specifier@?$format_string_parser@D@__crt_stdio_input@@AAA_NXZ"
		size = 278
		refs = "00ec ?scan_scanset_range@?$format_string_parser@D@__crt_stdio_input@@AAA_NXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 81 68 0B 78 A3 F1 41 02 37 2A 70 D8 DF E8 02 F0 55 6F 1C 6F 55 55 55 6F 49 6F 6F 6F 6F 6F 6F 6F 6F 6F 38 6F 6F 6F 6F 51 6F 6F 57 6F 6F 6F 6F 6F 55 6F 1C 4B 55 55 55 6F 49 6F 6F 6F 6F 6D 53 4F 6F 6F 38 6F 4D 6F 6F 51 D0 E9 06 23 13 43 4F F0 01 02 A2 F1 01 03 01 D1 C0 E9 06 23 04 6A 02 2C 01 D1 80 F8 24 30 03 2C 03 D0 04 2C 01 D0 08 2C 01 D1 80 F8 24 20 83 62 4B 1C 83 60 01 20 44 E0 03 6A 02 2B 02 D1 00 22 80 F8 24 20 01 22 03 2B 03 D0 04 2B 01 D0 08 2B 01 D1 80 F8 24 20 82 62 EA E7 02 23 E7 E7 03 23 E5 E7 05 23 E3 E7 09 23 03 62 06 23 DF E7 04 23 DD E7 07 23 DB E7 03 6A 02 2B 02 D1 00 22 80 F8 24 20 03 2B 03 D0 04 2B 01 D0 08 2B 02 D1 01 23 80 F8 24 30 08 23 83 62 4B 1C 83 60 ?? ?? ?? ?? 0F E0 09 23 C3 E7 00 23 03 61 03 75 43 75 83 75 C0 E9 06 33 03 62 80 F8 24 30 83 62 16 23 C3 60 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_215_0 {
	meta:
		name = "?scan_conversion_specifier@?$format_string_parser@_W@__crt_stdio_input@@AAA_NXZ"
		size = 278
		refs = "00ec ?scan_scanset_range@?$format_string_parser@_W@__crt_stdio_input@@AAA_NXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 81 68 0B 88 A3 F1 41 02 37 2A 70 D8 DF E8 02 F0 55 6F 1C 6F 55 55 55 6F 49 6F 6F 6F 6F 6F 6F 6F 6F 6F 38 6F 6F 6F 6F 51 6F 6F 57 6F 6F 6F 6F 6F 55 6F 1C 4B 55 55 55 6F 49 6F 6F 6F 6F 6D 53 4F 6F 6F 38 6F 4D 6F 6F 51 D0 E9 08 23 13 43 4F F0 01 02 A2 F1 01 03 01 D1 C0 E9 08 23 84 6A 02 2C 01 D1 80 F8 2C 30 03 2C 03 D0 04 2C 01 D0 08 2C 01 D1 80 F8 2C 20 03 63 8B 1C 83 60 01 20 44 E0 83 6A 02 2B 02 D1 00 22 80 F8 2C 20 01 22 03 2B 03 D0 04 2B 01 D0 08 2B 01 D1 80 F8 2C 20 02 63 EA E7 02 23 E7 E7 03 23 E5 E7 05 23 E3 E7 09 23 83 62 06 23 DF E7 04 23 DD E7 07 23 DB E7 83 6A 02 2B 02 D1 00 22 80 F8 2C 20 03 2B 03 D0 04 2B 01 D0 08 2B 02 D1 01 23 80 F8 2C 30 08 23 03 63 8B 1C 83 60 ?? ?? ?? ?? 0F E0 09 23 C3 E7 00 23 03 61 83 82 C3 82 03 76 C0 E9 08 33 83 62 80 F8 2C 30 03 63 16 23 C3 60 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_216_0 {
	meta:
		name = "?scan_optional_assignment_suppressor@?$format_string_parser@D@__crt_stdio_input@@AAAXXZ"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 82 68 13 78 2A 2B 03 D1 01 23 83 75 53 1C 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_217_0 {
	meta:
		name = "?scan_optional_assignment_suppressor@?$format_string_parser@_W@__crt_stdio_input@@AAAXXZ"
		size = 26
	strings:
		$1 = { 2D E9 00 48 EB 46 82 68 13 88 2A 2B 03 D1 01 23 03 76 93 1C 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_200_218_0 {
	meta:
		name = "?scan_optional_field_width@?$format_string_parser@D@__crt_stdio_input@@AAA_NXZ"
		size = 130
		refs = "0048 strtoull"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 A0 68 90 F9 00 30 30 2B 03 DB 39 2B D8 BF 30 3B 0D DD 61 2B 03 DB 7A 2B D8 BF 57 3B 07 DD 41 2B 03 DB 5A 2B D8 BF 37 3B 01 DD 6F F0 00 03 09 2B 01 D9 01 20 1E E0 00 23 69 46 0A 22 00 93 ?? ?? ?? ?? 50 EA 01 03 07 D0 A3 68 00 9A 9A 42 03 D0 C4 E9 06 01 A2 60 EC E7 00 23 23 61 23 75 63 75 A3 75 C4 E9 06 33 23 62 84 F8 24 30 A3 62 16 23 E3 60 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_219_0 {
	meta:
		name = "?scan_optional_field_width@?$format_string_parser@_W@__crt_stdio_input@@AAA_NXZ"
		size = 448
		refs = "0186 wcstoull"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 A0 68 02 88 30 2A C0 F0 9F 80 3A 2A 02 D2 A2 F1 30 03 96 E0 4F F6 10 71 8A 42 80 F0 8C 80 B2 F5 CC 6F C0 F0 91 80 40 F2 6A 63 9A 42 02 D2 A2 F5 CC 63 86 E0 B2 F5 DE 6F C0 F0 86 80 40 F2 FA 63 9A 42 02 D2 A2 F5 DE 63 7B E0 40 F6 66 13 9A 42 7A D3 B2 F5 17 6F 01 D2 D3 1A 72 E0 40 F6 E6 13 9A 42 71 D3 B2 F5 1F 6F F6 D3 40 F6 66 23 9A 42 6A D3 B2 F5 27 6F EF D3 40 F6 E6 23 9A 42 63 D3 B2 F5 2F 6F E8 D3 40 F6 66 33 9A 42 5C D3 B2 F5 37 6F E1 D3 40 F6 66 43 9A 42 55 D3 B2 F5 47 6F DA D3 40 F6 E6 43 9A 42 4E D3 B2 F5 4F 6F D3 D3 40 F6 66 53 9A 42 47 D3 B2 F5 57 6F CC D3 B2 F5 65 6F 41 D3 40 F6 5A 63 9A 42 02 D2 A2 F5 65 63 37 E0 B2 F5 6D 6F 37 D3 40 F6 DA 63 9A 42 02 D2 A2 F5 6D 63 2D E0 B2 F5 72 6F 2D D3 40 F6 2A 73 9A 42 02 D2 A2 F5 72 63 23 E0 B2 F5 82 5F 23 D3 41 F2 4A 03 9A 42 02 D2 A2 F5 82 53 19 E0 B2 F5 BF 5F 19 D3 41 F2 EA 73 9A 42 02 D2 A2 F5 BF 53 0F E0 41 F6 10 01 8A 42 0E D3 41 F6 1A 03 9A 42 0A D2 53 1A 05 E0 4F F6 1A 73 9A 42 F9 D3 6F F0 00 03 13 F1 01 0F 11 D1 41 2A 01 D3 5A 2A 03 D9 61 2A 09 D3 7A 2A 07 D8 61 2A 02 D3 7A 2A 98 BF 20 3A A2 F1 37 03 01 E0 6F F0 00 03 09 2B 01 D9 01 20 1E E0 00 23 69 46 0A 22 00 93 ?? ?? ?? ?? 50 EA 01 03 07 D0 A3 68 00 9A 9A 42 03 D0 C4 E9 08 01 A2 60 EC E7 00 23 23 61 A3 82 E3 82 23 76 C4 E9 08 33 A3 62 84 F8 2C 30 23 63 16 23 E3 60 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_220_0 {
	meta:
		name = "?scan_optional_length_modifier@?$format_string_parser@D@__crt_stdio_input@@AAAXXZ"
		size = 198
	strings:
		$1 = { 2D E9 00 48 EB 46 82 68 13 78 6A 2B 40 DC 3B D0 49 2B 18 D0 4C 2B 12 D0 54 2B 0C D0 68 2B 50 D1 53 78 68 2B 03 D1 93 1C 83 60 01 23 48 E0 53 1C 83 60 02 23 44 E0 53 1C 83 60 0B 23 40 E0 53 1C 83 60 08 23 3C E0 51 78 33 29 06 D1 93 78 32 2B 03 D1 D3 1C 83 60 09 23 32 E0 36 29 06 D1 93 78 34 2B 03 D1 D3 1C 83 60 0A 23 29 E0 64 29 09 D0 69 29 07 D0 6F 29 05 D0 75 29 03 D0 78 29 01 D0 58 29 1E D1 53 1C E5 E7 53 1C 83 60 05 23 17 E0 6C 2B 0B D0 74 2B 05 D0 7A 2B 12 D1 53 1C 83 60 06 23 0D E0 53 1C 83 60 07 23 09 E0 53 78 6C 2B 03 D1 93 1C 83 60 04 23 02 E0 53 1C 83 60 03 23 03 62 BD E8 00 88 }
	condition:
		$1
}

rule file_200_221_0 {
	meta:
		name = "?scan_optional_length_modifier@?$format_string_parser@_W@__crt_stdio_input@@AAAXXZ"
		size = 198
	strings:
		$1 = { 2D E9 00 48 EB 46 82 68 13 88 6A 2B 40 DC 3B D0 49 2B 18 D0 4C 2B 12 D0 54 2B 0C D0 68 2B 50 D1 53 88 68 2B 03 D1 13 1D 83 60 01 23 48 E0 93 1C 83 60 02 23 44 E0 93 1C 83 60 0B 23 40 E0 93 1C 83 60 08 23 3C E0 51 88 33 29 06 D1 93 88 32 2B 03 D1 93 1D 83 60 09 23 32 E0 36 29 06 D1 93 88 34 2B 03 D1 93 1D 83 60 0A 23 29 E0 64 29 09 D0 69 29 07 D0 6F 29 05 D0 75 29 03 D0 78 29 01 D0 58 29 1E D1 93 1C E5 E7 93 1C 83 60 05 23 17 E0 6C 2B 0B D0 74 2B 05 D0 7A 2B 12 D1 93 1C 83 60 06 23 0D E0 93 1C 83 60 07 23 09 E0 53 88 6C 2B 03 D1 13 1D 83 60 04 23 02 E0 93 1C 83 60 03 23 83 62 BD E8 00 88 }
	condition:
		$1
}

rule file_200_222_0 {
	meta:
		name = "?scan_optional_literal_character_trail_bytes_tchar@?$format_string_parser@D@__crt_stdio_input@@AAA_ND@Z"
		size = 74
		refs = "000a __pctype_func"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 23 7D 30 F8 13 30 13 F4 00 4F 14 D0 A3 68 13 F8 01 2B 72 B9 00 23 23 61 23 75 63 75 A3 75 C4 E9 06 33 23 62 84 F8 24 30 A3 62 2A 23 E3 60 00 20 02 E0 62 75 A3 60 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_200_224_0 {
	meta:
		name = "?scan_optional_wide_modifier@?$format_string_parser@D@__crt_stdio_input@@AAAXXZ"
		size = 46
	strings:
		$1 = { 2D E9 00 48 EB 46 82 68 13 78 77 2B 02 D1 53 1C 83 60 07 E0 43 2B 03 D0 53 2B 18 BF 00 23 00 D1 01 23 13 B1 01 23 80 F8 24 30 BD E8 00 88 }
	condition:
		$1
}

rule file_200_225_0 {
	meta:
		name = "?scan_optional_wide_modifier@?$format_string_parser@_W@__crt_stdio_input@@AAAXXZ"
		size = 64
	strings:
		$1 = { 2D E9 00 48 EB 46 82 68 13 88 77 2B 02 D1 93 1C 83 60 10 E0 43 2B 0C D0 53 2B 0A D0 83 6A 0B 2B 09 D0 03 68 13 F0 02 0F 18 BF 01 23 02 D1 00 23 00 E0 00 23 13 B1 01 23 80 F8 2C 30 BD E8 00 88 }
	condition:
		$1
}

rule file_200_226_0 {
	meta:
		name = "?scan_scanset_range@?$format_string_parser@D@__crt_stdio_input@@AAA_NXZ"
		size = 308
		refs = "0036 memset"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 04 46 10 F1 2C 05 0E D1 00 23 23 61 23 75 63 75 A3 75 C4 E9 06 33 23 62 80 F8 24 30 A3 62 0C 23 E3 60 00 20 80 E0 25 B1 20 22 00 21 28 46 ?? ?? ?? ?? A2 68 13 78 5E 2B 03 D1 01 20 53 1C A3 60 00 E0 00 20 A2 68 13 78 5D 2B 07 D1 53 1C A3 60 94 F8 37 30 43 F0 20 03 84 F8 37 30 A6 68 33 78 5D 2B 3D D0 4F F0 01 09 C8 46 A3 68 1A 78 BA B3 2D 2A 23 D1 B3 42 21 D0 59 78 5D 29 1E D0 13 F8 01 2C 8A 42 02 D9 13 46 0A 46 19 46 4B 1C DF B2 BA 42 1F D0 96 46 D3 10 A2 EB C3 03 04 EB DE 01 09 FA 03 F2 91 F8 2C 30 13 43 81 F8 2C 30 0E F1 01 03 DA B2 96 46 BA 42 ED D1 0B E0 D3 10 A2 EB C3 03 04 EB D2 01 08 FA 03 F2 91 F8 2C 30 13 43 81 F8 2C 30 A3 68 5B 1C A3 60 1B 78 5D 2B C4 D1 A3 68 1B 78 63 B9 00 23 23 61 23 75 63 75 A3 75 C4 E9 06 33 23 62 84 F8 24 30 A3 62 16 23 8F E7 70 B1 05 F1 20 03 5A 1B 00 21 9D 42 88 BF 00 22 32 B1 2B 78 49 1C DB 43 05 F8 01 3B 91 42 F8 D1 A3 68 5B 1C A3 60 01 20 BD E8 F0 8B }
	condition:
		$1
}

rule file_200_227_0 {
	meta:
		name = "?scan_scanset_range@?$format_string_parser@_W@__crt_stdio_input@@AAA_NXZ"
		size = 448
		refs = "0014 _calloc_base 001c _free_base 0072 memset 01b0 ?invert@?$scanset_buffer@_W@__crt_stdio_input@@QAAXXZ"
	strings:
		$1 = { 2D E9 F8 4F 0D F1 20 0B 05 46 6B 6B 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 68 6B ?? ?? ?? ?? 00 20 6C 63 ?? ?? ?? ?? 6B 6B 73 B9 00 23 2B 61 AB 82 EB 82 2B 76 C5 E9 08 33 AB 62 85 F8 2C 30 2B 63 0C 23 EB 60 00 20 B8 E0 6B 6B 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 68 6B ?? ?? ?? ?? 00 20 6C 63 ?? ?? ?? ?? 68 6B 20 B1 4F F4 00 52 00 21 ?? ?? ?? ?? AA 68 13 88 5E 2B 03 D1 01 27 93 1C AB 60 00 E0 00 27 AA 68 13 88 5D 2B 15 D1 93 1C AB 60 6B 6B 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 68 6B ?? ?? ?? ?? 00 20 6C 63 ?? ?? ?? ?? 6A 6B D3 7A 43 F0 20 03 D3 72 D5 F8 08 80 B8 F8 00 30 CD F8 00 80 5D 2B 44 D0 4F F0 01 09 AB 68 1E 88 FE B3 2D 2E 4D D1 43 45 4B D0 5A 88 5D 2A 48 D0 33 F8 02 6C 96 42 02 D9 33 46 16 46 1A 46 53 1C 1F FA 83 F9 4E 45 24 D0 B2 46 4F F0 01 08 6B 6B 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 68 6B ?? ?? ?? ?? 00 20 6C 63 ?? ?? ?? ?? 69 6B F3 10 A6 EB C3 03 4F EA DA 00 08 FA 03 F2 43 5C 13 43 43 54 0A F1 01 03 9E B2 B2 46 4E 45 DF D1 DD F8 00 80 4F F0 01 09 AB 68 9B 1C AB 60 1B 88 5D 2B BC D1 AB 68 1B 88 33 BB 00 23 2B 61 AB 82 EB 82 2B 76 C5 E9 08 33 AB 62 85 F8 2C 30 2B 63 16 23 66 E7 6B 6B 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 68 6B ?? ?? ?? ?? 00 20 6C 63 ?? ?? ?? ?? 69 6B F3 10 A6 EB C3 03 F0 08 09 FA 03 F2 43 5C 13 43 43 54 CF E7 1F B1 05 F1 34 00 ?? ?? ?? ?? AB 68 9B 1C AB 60 01 20 BD E8 F8 8F }
	condition:
		$1
}

rule file_200_230_0 {
	meta:
		name = "?secure_buffers@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABA_NXZ"
		size = 24
		altNames = "?secure_buffers@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABA_NXZ ?secure_buffers@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@ABA_NXZ ?secure_buffers@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABA_NXZ ?secure_buffers@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABA_NXZ ?secure_buffers@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@ABA_NXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 13 F0 01 0F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_232_0 {
	meta:
		name = "?set@?$scanset_buffer@E@__crt_stdio_input@@QAAXE@Z"
		size = 30
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B CB 10 A1 EB C3 03 01 22 CC 08 9A 40 23 5C 13 43 23 54 BD E8 18 88 }
	condition:
		$1
}

rule file_200_233_0 {
	meta:
		name = "?set@?$scanset_buffer@_W@__crt_stdio_input@@QAAX_W@Z"
		size = 66
		refs = "0016 _calloc_base 001e _free_base"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2B 68 0E 46 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 28 68 ?? ?? ?? ?? 00 20 2C 60 ?? ?? ?? ?? 28 68 F3 10 A6 EB C3 03 01 22 F4 08 9A 40 23 5C 13 43 23 54 BD E8 78 88 }
	condition:
		$1
}

rule file_200_234_0 {
	meta:
		name = "?set_wide_for_c_s_or_scanset@?$format_string_parser@D@__crt_stdio_input@@AAAXXZ"
		size = 40
	strings:
		$1 = { 2D E9 00 48 EB 46 03 6A 02 2B 02 D1 00 22 80 F8 24 20 03 2B 03 D0 04 2B 01 D0 08 2B 02 D1 01 23 80 F8 24 30 BD E8 00 88 }
	condition:
		$1
}

rule file_200_235_0 {
	meta:
		name = "?set_wide_for_c_s_or_scanset@?$format_string_parser@_W@__crt_stdio_input@@AAAXXZ"
		size = 40
	strings:
		$1 = { 2D E9 00 48 EB 46 83 6A 02 2B 02 D1 00 22 80 F8 2C 20 03 2B 03 D0 04 2B 01 D0 08 2B 02 D1 01 23 80 F8 2C 30 BD E8 00 88 }
	condition:
		$1
}

rule file_200_236_0 {
	meta:
		name = "?shift_left@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 272
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 01 F0 1F 0A CA F1 20 03 01 22 07 46 02 FA 03 F3 4E 09 39 68 5B 1E 02 93 50 F8 21 30 01 20 B3 FA 83 F3 C3 F1 1F 02 A0 EB 53 13 DB B2 00 2B 18 BF 53 1C 08 BF 00 23 C3 F1 20 03 9A 45 02 D9 4F F0 01 08 01 E0 4F F0 00 08 31 44 73 29 88 BF 01 22 98 BF 00 22 73 29 CD E9 00 18 04 D1 B8 F1 00 0F 18 BF 01 23 00 D1 00 23 00 2A 48 D1 00 2B 46 D1 72 29 01 D3 72 21 00 91 8E 46 11 F1 01 0F 2C D0 8C 1B DD F8 08 80 07 EB 81 09 07 EB 84 05 CA F1 20 01 B6 45 1F D3 3A 68 94 42 01 D2 68 68 00 E0 00 20 63 1E 93 42 01 D2 2B 68 00 E0 00 23 23 EA 08 03 23 FA 01 F2 00 EA 08 03 03 FA 0A F3 13 43 AE F1 01 0E C9 F8 04 30 64 1E 2D 1F A9 F1 04 09 1E F1 01 0F DD D1 DD E9 00 18 46 B1 3B 1D 00 20 2E B1 03 EB 86 02 43 F8 04 0B 93 42 FB D1 B8 F1 00 0F 18 BF 49 1C 39 60 01 20 BD E8 FE 8F 00 23 3B 60 00 20 BD E8 FE 8F }
	condition:
		$1
}

rule file_200_237_0 {
	meta:
		name = "?should_default_to_wide@?$format_string_parser@D@__crt_stdio_input@@AAA_NE@Z"
		size = 24
	strings:
		$1 = { 2D E9 00 48 EB 46 43 29 03 D0 53 29 18 BF 00 20 00 D1 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_238_0 {
	meta:
		name = "?should_default_to_wide@?$format_string_parser@_W@__crt_stdio_input@@AAA_N_W@Z"
		size = 46
	strings:
		$1 = { 2D E9 00 48 EB 46 43 29 0E D0 53 29 0C D0 83 6A 0B 2B 08 BF 01 20 08 D0 03 68 13 F0 02 0F 18 BF 01 20 02 D1 00 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_239_0 {
	meta:
		name = "?should_round_up@__crt_strtox@@YA_N_N000@Z"
		size = 66
		refs = "0018 fegetround"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 17 46 1D 46 0E 46 04 46 17 B9 0D B9 00 24 0A E0 ?? ?? ?? ?? 50 B1 B0 F5 80 7F 04 D0 B0 F5 00 7F F4 D1 44 B1 00 24 20 46 BD E8 F0 88 00 2F F9 D0 0D B9 00 2E F6 D0 01 24 F5 E7 }
	condition:
		$1
}

rule file_200_244_0 {
	meta:
		name = "?test@?$scanset_buffer@E@__crt_stdio_input@@QBA_NE@Z"
		size = 34
	strings:
		$1 = { 2D E9 00 48 EB 46 CB 10 A1 EB C3 03 01 22 9A 40 CB 08 1B 5C 1A 42 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_245_0 {
	meta:
		name = "?test@?$scanset_buffer@_W@__crt_stdio_input@@QBA_N_W@Z"
		size = 74
		refs = "0016 _calloc_base 001e _free_base"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 2B 68 0E 46 63 B9 01 21 4F F4 00 50 ?? ?? ?? ?? 04 46 28 68 ?? ?? ?? ?? 00 20 2C 60 ?? ?? ?? ?? F3 10 A6 EB C3 03 01 22 02 FA 03 F4 2B 68 F2 08 D3 5C 1C 42 18 BF 01 20 08 BF 00 20 BD E8 78 88 }
	condition:
		$1
}

rule file_200_246_0 {
	meta:
		name = "?to_floating_point_length@__crt_stdio_input@@YAIW4length_modifier@1@@Z"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 38 B1 03 28 03 D0 08 28 18 BF 00 20 02 D1 08 20 00 E0 04 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_247_0 {
	meta:
		name = "?to_integer_length@__crt_stdio_input@@YAIW4length_modifier@1@@Z"
		size = 48
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 28 0F D8 DF E8 00 F0 06 08 0A 06 0C 0C 06 06 0E 06 0C 0C 04 20 06 E0 01 20 04 E0 02 20 02 E0 08 20 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_248_0 {
	meta:
		name = "?unget@?$console_input_adapter@D@__crt_stdio_input@@QAAXH@Z"
		size = 32
		refs = "0018 _ungetch_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 B1 F1 FF 3F 07 D0 03 68 5B 1E 03 60 08 46 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_200_249_0 {
	meta:
		name = "?unget@?$console_input_adapter@_W@__crt_stdio_input@@QAAXG@Z"
		size = 34
		refs = "001a _ungetwch_nolock"
	strings:
		$1 = { 2D E9 00 48 EB 46 4F F6 FF 73 99 42 07 D0 03 68 5B 1E 03 60 08 46 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_200_250_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QAAXD@Z"
		size = 72
		refs = "0040 _ungetch_nolock"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B D0 E9 04 32 6F F0 00 06 D0 E9 02 45 9B 19 72 41 C0 E9 04 32 54 EA 05 03 06 D0 D0 E9 04 23 AB 42 0C D8 01 D3 A2 42 09 D8 41 B1 B1 42 06 D0 02 68 08 46 13 68 5B 1E 13 60 ?? ?? ?? ?? BD E8 78 88 }
	condition:
		$1
}

rule file_200_251_0 {
	meta:
		name = "?unget@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QAAX_W@Z"
		size = 76
		refs = "0044 _ungetwch_nolock"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B D0 E9 04 32 6F F0 00 04 C5 68 1B 19 62 41 84 68 C0 E9 04 32 54 EA 05 03 06 D0 D0 E9 04 23 AB 42 0E D8 01 D3 A2 42 0B D8 51 B1 4F F6 FF 73 99 42 06 D0 02 68 08 46 13 68 5B 1E 13 60 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_200_254_0 {
	meta:
		name = "?validate@?$format_string_parser@D@__crt_stdio_input@@QBA_NXZ"
		size = 32
		refs = "000a _errno 0012 _invalid_parameter_noinfo"
		altNames = "?validate@?$format_string_parser@_W@__crt_stdio_input@@QBA_NXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 83 68 3B B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 00 E0 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_256_0 {
	meta:
		name = "?validate@?$input_adapter_character_source@V?$console_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBA_NXZ"
		size = 38
		refs = "000a _errno 0012 _invalid_parameter_noinfo"
		altNames = "?validate@?$input_adapter_character_source@V?$console_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBA_NXZ ?validate@?$input_adapter_character_source@V?$stream_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBA_NXZ ?validate@?$input_adapter_character_source@V?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBA_NXZ ?validate@?$input_adapter_character_source@V?$string_input_adapter@D@__crt_stdio_input@@@__crt_strtox@@QBA_NXZ ?validate@?$input_adapter_character_source@V?$string_input_adapter@_W@__crt_stdio_input@@@__crt_strtox@@QBA_NXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 3B B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 03 E0 83 69 00 2B F4 D0 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_258_0 {
	meta:
		name = "?wide_character_to_digit@__crt_strtox@@YAH_W@Z"
		size = 326
	strings:
		$1 = { 2D E9 00 48 EB 46 30 28 C0 F0 99 80 3A 28 38 BF 30 38 C0 F0 96 80 4F F6 10 72 90 42 80 F0 89 80 B0 F5 CC 6F C0 F0 8B 80 40 F2 6A 63 98 42 02 D2 A0 F5 CC 60 85 E0 B0 F5 DE 6F C0 F0 80 80 40 F2 FA 63 98 42 02 D2 A0 F5 DE 60 7A E0 40 F6 66 13 98 42 74 D3 B0 F5 17 6F 01 D2 C0 1A 71 E0 40 F6 E6 13 98 42 6B D3 B0 F5 1F 6F F6 D3 40 F6 66 23 98 42 64 D3 B0 F5 27 6F EF D3 40 F6 E6 23 98 42 5D D3 B0 F5 2F 6F E8 D3 40 F6 66 33 98 42 56 D3 B0 F5 37 6F E1 D3 40 F6 66 43 98 42 4F D3 B0 F5 47 6F DA D3 40 F6 E6 43 98 42 48 D3 B0 F5 4F 6F D3 D3 40 F6 66 53 98 42 41 D3 B0 F5 57 6F CC D3 B0 F5 65 6F 3B D3 40 F6 5A 63 98 42 02 D2 A0 F5 65 60 36 E0 B0 F5 6D 6F 31 D3 40 F6 DA 63 98 42 02 D2 A0 F5 6D 60 2C E0 B0 F5 72 6F 27 D3 40 F6 2A 73 98 42 02 D2 A0 F5 72 60 22 E0 B0 F5 82 5F 1D D3 41 F2 4A 03 98 42 02 D2 A0 F5 82 50 18 E0 B0 F5 BF 5F 13 D3 41 F2 EA 73 98 42 02 D2 A0 F5 BF 50 0E E0 41 F6 10 02 90 42 08 D3 41 F6 1A 03 01 E0 4F F6 1A 73 98 42 38 BF 80 1A 01 D3 6F F0 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_200_259_0 {
	meta:
		name = "?width@?$format_string_parser@D@__crt_stdio_input@@QBA_KXZ"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 D3 E9 06 01 BD E8 00 88 }
	condition:
		$1
}

rule file_200_260_0 {
	meta:
		name = "?width@?$format_string_parser@_W@__crt_stdio_input@@QBA_KXZ"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 03 46 D3 E9 08 01 BD E8 00 88 }
	condition:
		$1
}

rule file_200_261_0 {
	meta:
		name = "?write_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQADIAAPADAAID@Z"
		size = 34
		altNames = "?write_character@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQADIAAPADAAID@Z ?write_character@?$input_processor@DV?$string_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQADIAAPADAAID@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 19 68 9D F8 0C 20 0A 70 1A 68 52 1C 1A 60 02 9A 13 68 5B 1E 13 60 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_262_0 {
	meta:
		name = "?write_character@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQFA_WIAAPFA_WAAID@Z"
		size = 108
		refs = "001a __pctype_func 002a _getche_nolock 0050 _mbtowc_l"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 9D F9 1C 50 1E 46 00 23 8D F8 00 50 04 46 8D F8 01 30 ?? ?? ?? ?? EA B2 30 F8 12 20 12 F4 00 4F 09 D0 ?? ?? ?? ?? B0 F1 FF 3F 02 D0 A2 68 52 1C A2 60 8D F8 01 00 3F 23 AD F8 02 30 23 6E 69 46 0D F1 02 00 1A 68 52 68 ?? ?? ?? ?? 33 68 06 9A 1D 80 33 68 9B 1C 33 60 13 68 5B 1E 13 60 01 20 BD E8 78 88 }
	condition:
		$1
}

rule file_200_263_0 {
	meta:
		name = "?write_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQADIAAPADAAI_W@Z"
		size = 136
		refs = "0020 wctomb_s 0082 _invoke_watson"
		altNames = "?write_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQADIAAPADAAI_W@Z ?write_character@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQADIAAPADAAI_W@Z"
	strings:
		$1 = { 2D E9 7E 48 0D F1 18 0B 1C 46 0D 46 21 68 B2 F1 FF 3F 16 D1 00 23 02 93 BD F8 24 30 02 A8 05 22 ?? ?? ?? ?? 20 B1 16 28 26 D0 22 28 21 D1 23 E0 23 68 02 99 08 9A 0B 44 23 60 13 68 5B 1A 13 60 17 E0 08 9E 00 23 02 93 32 68 BD F8 24 30 02 A8 ?? ?? ?? ?? 22 28 03 D1 00 23 2B 70 00 20 09 E0 02 9A 00 2A 05 DD 23 68 13 44 23 60 33 68 9B 1A 33 60 01 20 BD E8 7E 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_200_264_0 {
	meta:
		name = "?write_character@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQFA_WIAAPFA_WAAI_W@Z"
		size = 34
		altNames = "?write_character@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQFA_WIAAPFA_WAAI_W@Z ?write_character@?$input_processor@_WV?$string_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_NQFA_WIAAPFA_WAAI_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 19 68 BD F8 0C 20 0A 80 1A 68 92 1C 1A 60 02 9A 13 68 5B 1E 13 60 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_200_265_0 {
	meta:
		name = "?write_integer@?$input_processor@DV?$console_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
		size = 104
		refs = "0020 _errno 0028 _invalid_parameter_noinfo 003e ?length@?$format_string_parser@D@__crt_stdio_input@@QBAIXZ"
		altNames = "?write_integer@?$input_processor@DV?$stream_input_adapter@D@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 44 6E 1E 46 15 46 61 42 01 F0 03 01 21 44 09 1D 41 66 51 F8 04 4C 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 19 E0 9D F8 18 30 13 B1 83 6E 5B 1C 83 66 10 30 ?? ?? ?? ?? 01 28 0C D0 02 28 08 D0 04 28 04 D0 08 28 EC D1 C4 E9 00 56 04 E0 25 60 02 E0 25 80 00 E0 25 70 01 20 BD E8 78 88 }
	condition:
		$1
}

rule file_200_266_0 {
	meta:
		name = "?write_integer@?$input_processor@_WV?$console_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
		size = 104
		refs = "0020 _errno 0028 _invalid_parameter_noinfo 003e ?length@?$format_string_parser@_W@__crt_stdio_input@@QBAIXZ"
		altNames = "?write_integer@?$input_processor@_WV?$stream_input_adapter@_W@__crt_stdio_input@@@__crt_stdio_input@@AAA_N_K_N@Z"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B C4 6C 1E 46 15 46 61 42 01 F0 03 01 21 44 09 1D C1 64 51 F8 04 4C 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 19 E0 9D F8 18 30 13 B1 03 6D 5B 1C 03 65 10 30 ?? ?? ?? ?? 01 28 0C D0 02 28 08 D0 04 28 04 D0 08 28 EC D1 C4 E9 00 56 04 E0 25 60 02 E0 25 80 00 E0 25 70 01 20 BD E8 78 88 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "fmaxf"
		size = 88
		refs = "0012 _fdtest"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 68 46 CD ED 01 0A 8D ED 00 0A ?? ?? ?? ?? 02 28 02 D1 9D ED 01 0A 19 E0 01 A8 ?? ?? ?? ?? 9D ED 00 0A 02 28 12 D0 DD ED 01 0A B4 EE E0 0A F1 EE 10 FA 09 D3 B4 EE 60 0A F1 EE 10 FA 06 D1 BD F8 02 30 13 F4 00 4F 01 D0 B0 EE 60 0A BD E8 0C 88 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "_LCosh"
		size = 212
		refs = "0014 _ldtest 0058 _ldexp 00b2 _fperrraise 00c8 _LNan_C 00cc _LInf_C 00d0 _LXbig_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 04 46 02 A8 ?? ?? ?? ?? 00 2C 2E DA 00 28 2C DA 9D ED 00 1B B5 EE C0 1B F1 EE 10 FA 03 D2 B1 EE 41 1B 8D ED 00 1B 24 4B 6F F0 00 01 93 ED 00 0B B4 EE C0 1B F1 EE 10 FA 11 D2 B7 EE 00 0B 68 46 ?? ?? ?? ?? 9D ED 00 2B B5 EE 00 0B 9D ED 02 1B 80 EE 02 0B 30 EE 02 0B 20 EE 01 0B 25 E0 9D ED 02 0B 68 46 ?? ?? ?? ?? 01 E0 02 2C 02 D1 9D ED 00 0B 1A E0 02 28 16 D0 01 2C 14 D1 60 B1 9D ED 02 0B 0C 4B B5 EE C0 0B 93 ED 00 0B F1 EE 10 FA 0B D2 B1 EE 40 0B 08 E0 01 20 ?? ?? ?? ?? 04 4B 93 ED 00 0B 01 E0 9D ED 02 0B 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_535_0_0 {
	meta:
		name = "_Cosh"
		size = 212
		refs = "0014 _dtest 0058 _dexp 00b2 _fperrraise 00c8 _Nan_C 00cc _Inf_C 00d0 _Xbig_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 68 46 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 04 46 02 A8 ?? ?? ?? ?? 00 2C 2E DA 00 28 2C DA 9D ED 00 1B B5 EE C0 1B F1 EE 10 FA 03 D2 B1 EE 41 1B 8D ED 00 1B 24 4B 6F F0 00 01 93 ED 00 0B B4 EE C0 1B F1 EE 10 FA 11 D2 B7 EE 00 0B 68 46 ?? ?? ?? ?? 9D ED 00 2B B5 EE 00 0B 9D ED 02 1B 80 EE 02 0B 30 EE 02 0B 20 EE 01 0B 25 E0 9D ED 02 0B 68 46 ?? ?? ?? ?? 01 E0 02 2C 02 D1 9D ED 00 0B 1A E0 02 28 16 D0 01 2C 14 D1 60 B1 9D ED 02 0B 0C 4B B5 EE C0 0B 93 ED 00 0B F1 EE 10 FA 0B D2 B1 EE 40 0B 08 E0 01 20 ?? ?? ?? ?? 04 4B 93 ED 00 0B 01 E0 9D ED 02 0B 05 B0 BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_1_0 {
	meta:
		name = "ccoshl"
		size = 336
		refs = "0016 creall 002a cimagl 0034 _ldtest 0058 _fperrraise 00de sin 00f4 cos 010e _LSinh 0126 _LCosh 012e _LCbuild 013c _LInf_C 0140 _LNan_C 014c _LZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 04 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 06 D1 3E 4B 93 ED 00 0B 30 BB 9D ED 00 1B 6D E0 01 28 24 D1 01 20 ?? ?? ?? ?? 94 B9 9D ED 00 0B B5 EE C0 0B F1 EE 10 FA 05 D2 37 4B 93 ED 00 0B B1 EE 40 1B 01 E0 9F ED 32 1B 30 4B 93 ED 00 0B 54 E0 2E 4B 01 2C 05 D1 2C 4A 93 ED 00 1B 92 ED 00 0B 4B E0 93 ED 00 0B B0 EE 40 1B 46 E0 02 28 05 D1 26 4B 00 2C ED D1 9D ED 02 1B E6 E7 01 2C 24 D1 78 B9 9D ED 02 0B B5 EE C0 0B F1 EE 10 FA 04 D2 9D ED 00 0B B1 EE 40 1B 01 E0 9D ED 00 1B 1A 4B D3 E7 9D ED 00 8B B0 EE 48 0B ?? ?? ?? ?? 16 4B B0 EE 40 1B B0 EE 48 0B 93 ED 00 9B 21 EE 09 8B ?? ?? ?? ?? 20 EE 09 0B 15 E0 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 1B 9D ED 02 0B ?? ?? ?? ?? B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 1B 9D ED 02 0B ?? ?? ?? ?? B0 EE 48 1B ?? ?? ?? ?? 09 B0 BD EC 04 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_535_1_0 {
	meta:
		name = "ccosh"
		size = 336
		refs = "0016 creal 002a cimag 0034 _dtest 0058 _fperrraise 00de sin 00f4 cos 010e _Sinh 0126 _Cosh 012e _Cbuild 013c _Inf_C 0140 _Nan_C 014c _Zero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 04 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 06 D1 3E 4B 93 ED 00 0B 30 BB 9D ED 00 1B 6D E0 01 28 24 D1 01 20 ?? ?? ?? ?? 94 B9 9D ED 00 0B B5 EE C0 0B F1 EE 10 FA 05 D2 37 4B 93 ED 00 0B B1 EE 40 1B 01 E0 9F ED 32 1B 30 4B 93 ED 00 0B 54 E0 2E 4B 01 2C 05 D1 2C 4A 93 ED 00 1B 92 ED 00 0B 4B E0 93 ED 00 0B B0 EE 40 1B 46 E0 02 28 05 D1 26 4B 00 2C ED D1 9D ED 02 1B E6 E7 01 2C 24 D1 78 B9 9D ED 02 0B B5 EE C0 0B F1 EE 10 FA 04 D2 9D ED 00 0B B1 EE 40 1B 01 E0 9D ED 00 1B 1A 4B D3 E7 9D ED 00 8B B0 EE 48 0B ?? ?? ?? ?? 16 4B B0 EE 40 1B B0 EE 48 0B 93 ED 00 9B 21 EE 09 8B ?? ?? ?? ?? 20 EE 09 0B 15 E0 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 1B 9D ED 02 0B ?? ?? ?? ?? B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 1B 9D ED 02 0B ?? ?? ?? ?? B0 EE 48 1B ?? ?? ?? ?? 09 B0 BD EC 04 8B BD E8 10 88 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "strncmp"
		size = 170
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 15 46 00 24 00 2D 46 D0 04 2D 42 D3 2E 1F 40 D0 00 1D 10 F9 04 2C 09 1D 5A B3 11 F9 04 3C 9A 42 27 D1 10 F9 03 2C FA B1 11 F9 03 3C 9A 42 1B D1 10 F9 02 2C 9A B1 11 F9 02 3C 9A 42 0F D1 10 F9 01 2C 3A B1 11 F9 01 3C 9A 42 03 D1 24 1D B4 42 DE D3 1E E0 10 F8 01 2C 11 F8 01 3C 0D E0 10 F8 02 2C 11 F8 02 3C 08 E0 10 F8 03 2C 11 F8 03 3C 03 E0 10 F8 04 2C 11 F8 04 3C D0 1A 0C E0 90 F9 00 20 5A B1 91 F9 00 30 9A 42 07 D1 40 1C 64 1C 49 1C AC 42 F3 D3 00 20 BD E8 78 88 02 78 0B 78 EB E7 }
	condition:
		$1
}

rule file_205_5_0 {
	meta:
		name = "_ismbslead_l"
		size = 120
		refs = "000e _errno 0016 _invalid_parameter_noinfo 0026 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 04 46 0D 46 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 13 E0 00 2D F5 D0 68 46 11 46 ?? ?? ?? ?? 02 9A 93 68 EB B9 00 20 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 23 78 00 2B EE D0 13 44 5B 7E 13 F0 04 0F 06 D0 AC 42 04 F1 01 04 06 D0 23 78 00 2B E2 D0 64 1C AC 42 ED D9 DE E7 6F F0 00 00 DC E7 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "ceilf"
		size = 124
		refs = "002e _handle_nanf"
	strings:
		$1 = { 2D E9 00 48 EB 46 10 EE 10 0A 4F F0 00 41 20 EA 01 03 98 42 18 BF 01 22 08 BF 00 22 B3 F1 97 4F F0 EE 40 0A 08 D3 B3 F1 FF 4F 23 D9 00 21 ?? ?? ?? ?? F0 EE 40 0A 1D E0 B3 F1 7E 5F 07 D2 CB B1 12 B1 00 EE 90 1A 15 E0 F7 EE 00 0A 12 E0 C0 F3 C7 53 C3 F1 96 03 01 21 01 FA 03 F3 5B 1E 20 EA 03 03 00 EE 90 3A 2A B9 98 42 03 D0 B7 EE 00 0A 70 EE 80 0A B0 EE 60 0A BD E8 00 88 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "_swab"
		size = 62
		refs = "000a _errno 0012 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 30 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 10 E0 00 29 F6 D0 00 2A F4 DB 01 2A 0A DD 93 1E 5B 08 5C 1C 43 78 02 78 80 1C 0B 70 4A 70 89 1C 64 1E F7 D1 BD E8 18 88 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "_strrev"
		size = 46
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 01 46 10 F9 01 3B 00 2B FB D1 80 1E 05 E0 10 F8 01 39 0A 78 01 F8 01 3B 42 70 81 42 F7 D3 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_210_1_0 {
	meta:
		name = "powf"
		size = 796
		refs = "0090 _handle_nanf 00fa _handle_errorf 0114 _controlfp_s 024e log2 025a _exp2 02fc ??_C@_04MBFDLNIM@powf?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 2D ED 02 8B 87 B0 10 EE 10 7A 4F F0 00 4A 27 EA 0A 02 BA 42 F0 EE 60 8A B0 EE 40 8A 02 D1 4F F0 01 0E 01 E0 4F F0 00 0E 18 EE 90 4A 4F F0 7E 50 24 EA 0A 06 A6 42 08 BF 01 21 18 BF 00 21 87 42 10 D1 B7 EE 00 1A 78 EE 81 0A B0 EE 00 0A F4 EE 40 0A F1 EE 10 FA 40 F0 46 81 BF F3 5B 8F 01 23 04 93 40 E1 26 B9 B7 EE 00 1A 78 EE 01 0A EC E7 4F F0 FF 45 02 EA 05 09 A9 45 0A D1 13 46 6F F3 DF 53 33 B1 38 46 00 21 ?? ?? ?? ?? B0 EE 40 1A 29 E1 06 EA 05 08 A8 45 05 D1 33 46 6F F3 DF 53 0B B1 20 46 EF E7 84 42 02 D1 B0 EE 48 1A 1A E1 B8 F1 9E 4F 4A D9 AE 42 08 BF 01 23 18 BF 00 23 91 B3 12 B9 9F ED 8C 1A 0D E1 82 42 14 D2 00 2B F8 D1 02 23 03 93 22 23 02 93 12 23 01 93 04 23 00 22 00 93 83 48 B0 EE 48 0A F0 EE 68 0A 00 23 1D 21 ?? ?? ?? ?? C9 E7 02 D1 B7 EE 00 1A F2 E0 4B B1 00 23 04 93 04 A8 00 22 00 21 ?? ?? ?? ?? 01 EE 10 5A E7 E0 02 23 03 93 22 23 02 93 11 23 01 93 03 23 2A 46 DC E7 32 B9 22 22 02 92 02 23 04 22 01 92 03 93 F5 E7 82 42 05 D2 00 2B EA D0 00 23 05 93 05 A8 DF E7 C1 D1 D6 E7 C4 F3 C7 53 7E 3B 01 2B 4F F0 01 08 08 DB 18 2B 10 DC C3 F1 18 00 01 23 83 40 5B 1E 23 42 01 D0 00 23 08 E0 24 EA 03 03 C3 40 13 EA 08 0F 18 BF 01 23 00 D1 02 23 A9 45 11 D1 BE F1 00 0F 02 D0 00 29 99 D0 8B E7 01 2B 04 D1 00 29 87 D1 9F ED 5D 1A A2 E0 00 29 8F D0 B1 EE 48 1A 9D E0 62 BB BE F1 00 0F 0C D0 00 29 7F F4 79 AF 22 22 02 92 02 23 04 22 65 F3 1E 07 01 92 3A 46 03 93 8A E7 11 B1 01 2B E8 D1 6A E7 47 48 01 2B F0 EE 68 0A B0 EE 48 0A 08 D1 22 22 02 92 02 23 04 22 01 92 03 93 47 4A 00 93 7C E7 22 22 02 92 02 23 04 22 01 92 03 93 00 93 2A 46 73 E7 00 24 BE F1 00 0F 05 D1 73 B1 08 EE 10 2A 01 2B 08 D1 01 24 B6 F1 3A 5F 10 D2 B7 EE 00 0A 38 EE 80 1A 5D E0 00 24 F5 E7 02 23 03 93 21 23 02 93 08 23 33 4A 01 93 CD F8 00 80 50 E7 B7 EE C8 0A ?? ?? ?? ?? B7 EE E8 1A 21 EE 00 0B ?? ?? ?? ?? 9F ED 2A 2B B0 EE 40 1B B4 EE C2 0B F1 EE 10 FA 15 DD 22 48 F0 EE 68 0A B0 EE 48 0A 3C B1 02 23 03 93 22 23 02 93 11 23 01 93 03 23 B4 E7 02 23 03 93 22 23 02 93 11 23 01 93 03 23 B5 E7 9F ED 18 0B B4 EE C0 1B F1 EE 10 FA 19 D2 14 48 F0 EE 68 0A B0 EE 48 0A 4C B1 02 23 03 93 22 23 02 93 12 23 01 93 04 23 00 93 52 46 15 E7 02 23 03 93 22 23 02 93 12 23 01 93 04 23 00 93 00 22 0B E7 24 B1 B1 EE 41 0B B7 EE C0 1B 01 E0 B7 EE C1 1B B0 EE 41 0A 07 B0 BD EC 02 8B BD E8 F0 8F ?? ?? ?? ?? 00 00 00 00 00 00 A0 36 00 00 00 E0 FF FF EF 47 00 00 C0 FF 00 00 80 FF 00 00 00 80 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "__acrt_GetTempPathA"
		size = 112
		refs = "0008 __security_push_cookie 001c memset 0032 __acrt_AreFileApisANSI 005e __security_pop_cookie 0068 __imp_WideCharToMultiByte 006c __imp_GetTempPathW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 07 7D 0C 46 05 46 04 A8 00 21 40 F2 0A 22 ?? ?? ?? ?? 12 4B 04 A9 40 F2 05 10 1B 68 98 47 08 B9 00 20 13 E0 ?? ?? ?? ?? 08 B9 01 20 00 E0 00 20 00 94 09 4C 00 23 03 93 24 68 02 93 DB 43 04 AA 00 21 01 95 A0 47 00 28 EA D0 40 1E 0D F5 07 7D ?? ?? ?? ?? BD E8 30 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "_FHypot"
		size = 404
		refs = "0018 _fdunscale 00e6 _fdscale 0180 _FInf_C"
	strings:
		$1 = { 03 B4 2D E9 3F 48 0D F1 18 0B 04 46 68 46 01 A9 CD ED 02 0A 8D ED 01 0A ?? ?? ?? ?? 05 46 0D F1 02 00 02 A9 ?? ?? ?? ?? 00 23 23 60 01 2D 00 F0 9F 80 01 28 00 F0 9C 80 02 2D 02 D1 9D ED 01 0A 99 E0 02 28 02 D1 9D ED 02 0A 94 E0 9D ED 01 0A B5 EE C0 0A F1 EE 10 FA 03 D2 B1 EE 40 0A 8D ED 01 0A DD ED 02 0A F5 EE C0 0A F1 EE 10 FA 03 D2 F1 EE 60 0A CD ED 02 0A F5 EE 40 0A F1 EE 10 FA 0A D1 B5 EE 40 0A F1 EE 10 FA 02 D1 9F ED 40 0A 71 E0 BD F9 00 20 1A E0 B5 EE 40 0A BD F9 00 20 BD F9 02 10 F1 EE 10 FA 07 D0 8A 42 05 DB 0E D1 B4 EE E0 0A F1 EE 10 FA 09 D2 13 46 AD F8 02 30 0A 46 AD F8 00 10 CD ED 01 0A 8D ED 02 0A 53 10 02 EB 93 73 9B 10 5B 00 23 60 01 D1 02 23 23 60 23 68 01 A8 D1 1A ?? ?? ?? ?? 22 68 BD F9 02 30 02 A8 99 1A ?? ?? ?? ?? 9D ED 01 4A DD ED 02 3A 34 EE 63 0A B4 EE 44 0A F1 EE 10 FA 33 D0 F4 EE C0 3A F1 EE 10 FA 0A D2 C4 EE 23 0A B7 EE 00 0A 00 EE A0 0A B1 EE C0 0A 30 EE 20 0A 1B E0 80 EE 23 3A B0 EE 00 1A DF ED 15 1A 9F ED 13 2A 33 EE 01 0A DF ED 10 2A 60 EE 03 0A 30 EE 81 0A B1 EE C0 0A 30 EE 21 0A 80 EE 80 0A 30 EE 02 0A 30 EE 03 0A 30 EE 22 0A 83 EE 80 0A 30 EE 04 0A 02 E0 03 4B 93 ED 00 0A BD E8 3F 08 5D F8 0C FB FE DE ?? ?? ?? ?? 41 82 1A 40 F3 89 63 37 F3 04 B5 3F 00 00 00 00 }
	condition:
		$1
}

rule file_212_1_0 {
	meta:
		name = "csqrtf"
		size = 388
		refs = "0016 crealf 002a cimagf 0034 _fdtest 0058 _FHypot 007c ldexp 016a _FCbuild 0178 _FInf_C 0180 _FZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 02 8B 87 B0 CD ED 05 0A 8D ED 04 0A ?? ?? ?? ?? DD ED 05 0A B0 EE 40 1A 9D ED 04 0A 8D ED 01 1A ?? ?? ?? ?? 68 46 8D ED 00 0A ?? ?? ?? ?? 04 46 01 2C 02 D1 DD ED 00 0A 8F E0 01 A8 ?? ?? ?? ?? 01 28 59 D0 DD ED 00 0A 9D ED 01 0A 02 A8 ?? ?? ?? ?? 02 9C B0 EE 40 8A 24 B9 9D ED 00 2A 60 EE 02 0A 7D E0 9D ED 01 0A 60 42 B0 EE C0 0A B7 EE C0 0A ?? ?? ?? ?? F0 EE 00 8A B7 EE C0 0B 04 EB D4 73 5B 10 30 EE 08 0A 58 1E 20 EE 28 0A B1 EE C0 0A B7 EE C0 0A ?? ?? ?? ?? 9D ED 01 2A F7 EE C0 0B B5 EE C0 2A F1 EE 10 FA 08 DB DD ED 00 2A 20 EE A8 2A B0 EE 60 0A C2 EE 82 0A 50 E0 BD F8 02 30 9D ED 00 1A 13 F4 00 4F 08 D0 20 EE A8 0A F1 EE 60 0A 81 EE 00 0A B1 EE 40 0A 40 E0 B5 EE 40 1A F1 EE 10 FA 02 D1 9F ED 22 0A 38 E0 20 EE A8 0A 81 EE 00 0A 33 E0 02 2C 0E D1 DD ED 01 0A F5 EE C0 0A F1 EE 10 FA 02 D2 9D ED 00 0A 27 E0 9D ED 04 0A DD ED 05 0A 24 E0 9D ED 01 0A BD F8 02 30 B5 EE C0 0A F1 EE 10 FA 0B D2 13 F4 00 4F 0F 4B 04 D0 93 ED 00 0A F1 EE 40 0A D4 E7 D3 ED 00 0A D1 E7 13 F4 00 4F 05 D0 0A 4B 93 ED 00 0A F1 EE 40 0A 01 E0 DF ED 06 0A 04 4B 93 ED 00 0A ?? ?? ?? ?? 07 B0 BD EC 02 8B BD E8 10 88 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "ldexpf"
		size = 22
		refs = "000a ldexp"
	strings:
		$1 = { 2D E9 00 48 EB 46 B7 EE C0 0A ?? ?? ?? ?? B7 EE C0 0B BD E8 00 88 }
	condition:
		$1
}

rule file_213_12_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAA@XZ"
		size = 32
		refs = "001c __imp_FreeLibrary"
		altNames = "?close@?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAAXXZ"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 20 B1 03 4B 1B 68 98 47 00 23 23 60 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_430_5_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QAA@XZ"
		size = 32
		refs = "001c __imp_FreeEnvironmentStringsW"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 20 B1 03 4B 1B 68 98 47 00 23 23 60 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_430_11_0 {
	meta:
		name = "?close@?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QAAXXZ"
		size = 32
		refs = "001c __imp_FreeEnvironmentStringsW"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 20 68 20 B1 03 4B 1B 68 98 47 00 23 23 60 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_21_0 {
	meta:
		name = "?atexit_exception_filter@@YAHK@Z"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 04 4B 98 42 08 BF 01 20 18 BF 00 20 BD E8 00 88 FE DE 63 73 6D E0 }
	condition:
		$1
}

rule file_213_24_0 {
	meta:
		name = "?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
		size = 144
		refs = "004c ?try_cor_exit_process@@YAXI@Z 0072 ??$?RV<lambda_03b1d95aef87969028cfba75ccab2455>@@AAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@V<lambda_22bdf7517842c4b3e53723af5aa32b9e>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_03b1d95aef87969028cfba75ccab2455>@@AAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@$$QAV<lambda_22bdf7517842c4b3e53723af5aa32b9e>@@@Z 0086 ?exit_or_terminate_process@@YAXI@Z 008c __imp_GetModuleHandleW"
	strings:
		$1 = { 0F B4 2D E9 10 48 0D F1 04 0B 87 B0 0C 92 04 46 F2 B9 1E 4B 00 20 1B 68 98 47 C8 B1 02 88 45 F6 4D 23 9A 42 14 D1 C3 6B 1A 58 19 18 44 F2 50 53 9A 42 0D D1 0A 8B 40 F2 0B 13 9A 42 08 D1 4B 6F 0E 2B 05 D9 D1 F8 E8 30 13 B1 20 46 ?? ?? ?? ?? 00 23 8D F8 00 30 0B AB 04 93 0C AB 05 93 6B 46 06 93 02 23 CD E9 01 33 01 AB 04 AA 02 A9 0D F1 01 00 ?? ?? ?? ?? 0C 9B 23 B1 07 B0 BD E8 10 08 5D F8 14 FB 20 46 ?? ?? ?? ?? FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_25_0 {
	meta:
		name = "?exit_or_terminate_process@@YAXI@Z"
		size = 76
		refs = "000a __acrt_get_process_end_policy 0030 ?try_cor_exit_process@@YAXI@Z 0040 __imp_ExitProcess 0044 __imp_TerminateProcess 0048 __imp_GetCurrentProcess"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 01 28 0D D0 1D EE 50 3F 1B 6B 9B 6E 13 F4 80 7F 06 D1 09 4B 1B 68 98 47 07 4B 21 46 1B 68 98 47 20 46 ?? ?? ?? ?? 02 4B 20 46 1B 68 98 47 FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_29_0 {
	meta:
		name = "?is_managed_app@@YA_NXZ"
		size = 80
		refs = "004c __imp_GetModuleHandleW"
	strings:
		$1 = { 2D E9 00 48 EB 46 11 4B 00 20 1B 68 98 47 08 B9 00 20 18 E0 02 88 45 F6 4D 23 9A 42 F8 D1 C3 6B 1A 58 19 18 44 F2 50 53 9A 42 F1 D1 0A 8B 40 F2 0B 13 9A 42 EC D1 4B 6F 0E 2B E9 D9 D1 F8 E8 30 00 2B E5 D0 01 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_30_0 {
	meta:
		name = "?should_call_terminate_process@@YA_NXZ"
		size = 38
		refs = "0006 __acrt_get_process_end_policy"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 01 28 01 D1 00 20 07 E0 1D EE 50 3F 1B 6B 9B 6E 13 F4 80 7F F6 D1 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_213_31_0 {
	meta:
		name = "?try_cor_exit_process@@YAXI@Z"
		size = 92
		refs = "0044 __imp_FreeLibrary 0048 __guard_check_icall_fptr 004c ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 0050 __imp_GetProcAddress 0054 ??_C@_1BI@BGOHAHKC@?$AAm?$AAs?$AAc?$AAo?$AAr?$AAe?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0058 __imp_GetModuleHandleExW"
	strings:
		$1 = { 2D E9 3C 48 0D F1 10 0B 00 23 00 93 12 4B 11 49 05 46 1B 68 6A 46 00 20 98 47 58 B1 0C 4B 00 98 0A 49 1B 68 98 47 04 46 24 B1 07 4B 1B 68 98 47 28 46 A0 47 00 98 10 B1 02 4B 1B 68 98 47 BD E8 3C 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_33_0 {
	meta:
		name = "_Exit"
		size = 18
		refs = "000e ?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
		altNames = "_exit"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 02 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_35_0 {
	meta:
		name = "_c_exit"
		size = 72
		refs = "0032 ??$?RV<lambda_03b1d95aef87969028cfba75ccab2455>@@AAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@V<lambda_22bdf7517842c4b3e53723af5aa32b9e>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_03b1d95aef87969028cfba75ccab2455>@@AAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@$$QAV<lambda_22bdf7517842c4b3e53723af5aa32b9e>@@@Z 0042 ?exit_or_terminate_process@@YAXI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 01 23 01 93 02 23 02 93 00 23 8D F8 00 30 02 AB 06 93 01 AB 07 93 6B 46 08 93 02 23 CD E9 03 33 03 AB 06 AA 04 A9 0D F1 01 00 ?? ?? ?? ?? 01 9B 13 B1 0A B0 BD E8 00 88 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_213_36_0 {
	meta:
		name = "_cexit"
		size = 70
		refs = "0030 ??$?RV<lambda_03b1d95aef87969028cfba75ccab2455>@@AAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@V<lambda_22bdf7517842c4b3e53723af5aa32b9e>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_03b1d95aef87969028cfba75ccab2455>@@AAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@$$QAV<lambda_22bdf7517842c4b3e53723af5aa32b9e>@@@Z 0040 ?exit_or_terminate_process@@YAXI@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 8A B0 01 23 01 93 00 23 02 93 8D F8 00 30 02 AB 06 93 01 AB 07 93 6B 46 08 93 02 23 CD E9 03 33 03 AB 06 AA 04 A9 0D F1 01 00 ?? ?? ?? ?? 01 9B 13 B1 0A B0 BD E8 00 88 00 20 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_213_38_0 {
	meta:
		name = "_is_c_termination_complete"
		size = 24
		refs = "0014 ?c_termination_complete@@3JA"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 18 68 BF F3 5B 8F BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_548_4_0 {
	meta:
		name = "_query_new_mode"
		size = 24
		refs = "0014 ?__acrt_global_new_mode@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 4B 18 68 BF F3 5B 8F BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_39_0 {
	meta:
		name = "_register_thread_local_exe_atexit_callback"
		size = 64
		refs = "0030 terminate 0038 ?thread_local_exit_callback_func@@3P6AXPAXK0@ZA 003c __security_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 4B 0B 4D 19 68 01 F0 1F 03 C3 F1 20 04 00 23 E3 41 83 EA 01 02 2B 68 93 42 05 D1 60 FA 04 F3 4B 40 2B 60 BD E8 30 88 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_40_0 {
	meta:
		name = "exit"
		size = 18
		refs = "000e ?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_41_0 {
	meta:
		name = "quick_exit"
		size = 18
		refs = "000e ?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 00 22 01 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_5_0 {
	meta:
		name = "_ismbchira_l"
		size = 70
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 02 9B 5B 68 B3 F5 69 7F 06 D1 48 F2 9F 23 E3 1A 52 2B 98 BF 01 20 00 D9 00 20 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_215_7_0 {
	meta:
		name = "_ismbckata_l"
		size = 78
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 02 9B 5B 68 B3 F5 69 7F 0A D1 48 F2 40 33 E3 1A 56 2B 05 D8 48 F2 7F 33 9C 42 18 BF 01 20 00 D1 00 20 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_215_9_0 {
	meta:
		name = "_ismbcsymbol_l"
		size = 78
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 02 9B 5B 68 B3 F5 69 7F 0A D1 48 F2 41 13 E3 1A 6B 2B 05 D8 48 F2 7F 13 9C 42 18 BF 01 20 00 D1 00 20 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "??$convert_mantissa_to_ld12@$09@@YAXQBEIQAU_LDBL12@@@Z"
		size = 348
	strings:
		$1 = { 2D E9 FE 4F 0D F1 28 0B 14 46 00 23 C4 E9 00 33 A3 60 43 18 A3 EB 00 0E 98 42 4F F0 00 09 88 BF CE 46 BE F1 00 0F 00 90 67 D0 00 26 00 20 00 25 A3 68 27 68 82 0F 01 93 B3 0F B1 00 43 EA 80 00 D4 F8 04 80 42 EA 85 03 01 EB 07 0A C4 E9 00 10 A3 60 06 46 C4 F8 00 A0 8A 45 03 D3 BA 45 28 BF 00 22 00 D2 01 22 62 B1 42 1C 10 46 62 60 B2 42 03 D3 01 2A 28 BF 00 22 00 D2 01 22 0A B1 5B 1C A3 60 08 EB 00 05 65 60 85 42 03 D3 45 45 28 BF 00 22 00 D2 01 22 0A B1 5B 1C A3 60 01 9A 4F EA 4A 01 21 60 1A 44 6B 00 43 EA DA 77 53 00 C4 E9 01 72 00 9A 43 EA D5 75 A5 60 12 F8 01 3B 38 46 CE 18 26 60 8E 42 00 92 03 D3 9E 42 28 BF 00 23 00 D2 01 23 5B B1 78 1C 60 60 B8 42 03 D3 01 28 28 BF 00 23 00 D2 01 23 0B B1 6D 1C A5 60 09 F1 01 09 F1 45 C4 E9 01 05 9A D1 A3 68 44 F2 4E 00 8B B9 D4 E9 00 21 4F F6 F0 75 4F EA 12 43 0E 0C 43 EA 01 41 00 EB 05 03 98 B2 4F EA 02 42 F4 D0 C4 E9 00 21 A6 60 A1 68 4F F4 00 47 39 42 12 D1 D4 E9 00 56 4F F6 FF 7E EB 0F F2 0F 43 EA 46 06 00 EB 0E 03 42 EA 41 01 6D 00 98 B2 39 42 F3 D0 C4 E9 00 56 A1 60 60 81 BD E8 FE 8F }
	condition:
		$1
}

rule file_216_1_0 {
	meta:
		name = "??$convert_mantissa_to_ld12@$0BA@@@YAXQBEIQAU_LDBL12@@@Z"
		size = 230
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 14 46 00 23 C4 E9 00 33 A3 60 43 18 80 46 1E 1A 00 27 98 45 88 BF 00 26 86 B3 00 25 00 20 4F F0 00 0E 4F EA 1E 73 2A 0F 43 EA 05 15 42 EA 00 10 4F EA 0E 11 C4 E9 01 50 21 60 18 F8 01 3B A9 46 01 EB 03 0E C4 F8 00 E0 8E 45 03 D3 9E 45 28 BF 00 23 00 D2 01 23 63 B1 6B 1C 1D 46 63 60 4B 45 03 D3 01 2B 28 BF 00 23 00 D2 01 23 0B B1 40 1C A0 60 7F 1C B7 42 C4 E9 01 50 D2 D1 A3 68 44 F2 4E 00 8B B9 D4 E9 00 21 4F F6 F0 75 4F EA 12 43 0E 0C 43 EA 01 41 00 EB 05 03 98 B2 4F EA 02 42 F4 D0 C4 E9 00 21 A6 60 A1 68 4F F4 00 47 39 42 12 D1 D4 E9 00 56 4F F6 FF 7E EB 0F F2 0F 43 EA 46 06 00 EB 0E 03 42 EA 41 01 6D 00 98 B2 39 42 F3 D0 C4 E9 00 56 A1 60 60 81 BD E8 F0 8B }
	condition:
		$1
}

rule file_216_2_0 {
	meta:
		name = "??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z"
		size = 18
		altNames = "??$make_c_string_character_source@DPAPAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBDQAPAD@Z ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_W$$T@Z ??$make_c_string_character_source@_WPAPA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QB_WQAPA_W@Z ??0?$c_string_character_source@D@__crt_strtox@@QAA@QBDQAPBD@Z ??0?$c_string_character_source@_W@__crt_strtox@@QAA@QB_WQAPB_W@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 E9 00 12 02 B1 11 60 BD E8 00 88 }
	condition:
		$1
}

rule file_216_3_0 {
	meta:
		name = "??$multiply_ld12_by@$09@@YAXQAU_LDBL12@@@Z"
		size = 142
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 45 68 06 68 D0 F8 08 E0 29 46 32 46 8B 00 94 00 43 EA 96 72 73 46 9B 00 43 EA 95 77 A1 19 C0 E9 00 42 87 60 01 60 A1 42 03 D3 B1 42 28 BF 00 23 00 D2 01 23 5B B1 53 1C 43 60 93 42 03 D3 01 2B 28 BF 00 23 00 D2 01 23 0B B1 7B 1C 83 60 43 68 EA 18 42 60 9A 42 03 D3 AA 42 28 BF 00 23 00 D2 01 23 13 B1 83 68 5B 1C 83 60 4B 00 03 60 53 00 43 EA D1 73 43 60 83 68 73 44 5B 00 43 EA D2 73 83 60 BD E8 F0 88 }
	condition:
		$1
}

rule file_216_4_0 {
	meta:
		name = "??$multiply_ld12_by@$0BA@@@YAXQAU_LDBL12@@@Z"
		size = 36
		altNames = "??$shl_ld12@$03@@YAXQAU_LDBL12@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 D0 E9 00 21 13 01 03 60 0B 01 43 EA 12 73 43 60 83 68 1B 01 43 EA 11 73 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_216_5_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAU_LDBL12@@@Z"
		size = 86
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 0036 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@D@0@AAUfloating_point_string@0@@Z 003e ??$parse_floating_point_write_result@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAU_LDBL12@@@Z 004e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 5D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 01 20 0D E0 00 28 F1 D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_373_22_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAM@Z"
		size = 86
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 0036 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@D@0@AAUfloating_point_string@0@@Z 003e ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 004e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 5D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 01 20 0D E0 00 28 F1 D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_373_23_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAN@Z"
		size = 86
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 0036 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@D@0@AAUfloating_point_string@0@@Z 003e ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 004e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 5D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 01 20 0D E0 00 28 F1 D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_382_24_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QAM@Z"
		size = 86
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 0036 ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@_W@0@AAUfloating_point_string@0@@Z 003e ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAM@Z 004e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 5D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 01 20 0D E0 00 28 F1 D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_382_25_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QAN@Z"
		size = 86
		refs = "0008 __security_push_cookie 0016 _errno 001e _invalid_parameter_noinfo 0036 ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@_W@0@AAUfloating_point_string@0@@Z 003e ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAN@Z 004e __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 43 7D 15 46 0C 46 5D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 01 20 0D E0 00 28 F1 D0 6A 46 21 46 ?? ?? ?? ?? 69 46 2A 46 ?? ?? ?? ?? 62 68 0A B1 23 68 13 60 0D F5 43 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_216_6_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QAU__crt_locale_pointers@@AAV?$c_string_character_source@D@0@AAUfloating_point_string@0@@Z"
		size = 1028
		refs = "0016 _errno 001e _invalid_parameter_noinfo 004a _isctype_l 0058 __pctype_func 03ea ??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$c_string_character_source@D@0@PBD@Z 03f6 ??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$c_string_character_source@D@0@PBD@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 85 B0 0D 46 2F 68 91 46 03 92 80 46 3F B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 07 20 E9 E1 97 F9 00 40 7B 1C 2B 60 8D F8 00 40 E6 B2 B8 F1 00 0F 0E D0 D8 F8 00 20 53 68 01 2B 05 DD 42 46 08 21 30 46 ?? ?? ?? ?? 09 E0 13 68 33 F8 16 30 03 E0 ?? ?? ?? ?? 30 F8 16 30 03 F0 08 00 18 B1 2B 68 13 F9 01 4B DE E7 2D 2C 08 BF 01 23 18 BF 00 23 89 F8 08 33 2D 2C 01 D0 2B 2C 05 D1 2B 68 13 F9 01 4B 8D F8 00 40 2B 60 49 2C 00 F0 AD 81 69 2C 00 F0 AA 81 4E 2C 00 F0 A1 81 6E 2C 00 F0 9E 81 4F F0 00 0A 16 26 CD F8 08 A0 30 2C 1D D1 29 68 91 F9 00 20 4B 1C 2B 60 78 2A 0E D0 58 2A 0C D0 5B 1E 2B 60 8A B1 93 F9 00 30 93 42 0D D0 ?? ?? ?? ?? 06 60 ?? ?? ?? ?? 07 E0 13 F9 01 4B 4F F0 01 0A CD F8 08 A0 2B 60 0F 46 09 F1 08 0E 09 F5 42 70 4F F0 00 09 00 21 CD F8 04 90 76 46 30 2C 06 D1 2B 68 01 21 13 F9 01 4B 2B 60 30 2C FA D0 BA F1 00 0F 18 BF 0F 22 08 BF 09 22 30 2C 04 DB 39 2C 02 DC A4 F1 30 03 0F E0 61 2C 04 DB 7A 2C 02 DC A4 F1 57 03 08 E0 41 2C 04 DB 5A 2C 02 DC A4 F1 37 03 01 E0 6F F0 00 03 93 42 0B D8 01 21 86 42 01 D0 33 70 76 1C 2B 68 09 F1 01 09 13 F9 01 4B 2B 60 D4 E7 D8 F8 00 30 CD F8 04 90 D3 F8 88 30 1B 68 93 F9 00 30 9C 42 3D D1 2B 68 93 F9 00 40 5A 1C 2A 60 76 45 0D D1 30 2C 0B D1 01 21 92 F9 00 40 53 1C A9 F1 01 09 30 2C 1A 46 2B 60 F6 D0 CD F8 04 90 BA F1 00 0F 18 BF 0F 22 08 BF 09 22 30 2C 04 DB 39 2C 02 DC A4 F1 30 03 0F E0 61 2C 04 DB 7A 2C 02 DC A4 F1 57 03 08 E0 41 2C 04 DB 5A 2C 02 DC A4 F1 37 03 01 E0 6F F0 00 03 93 42 09 D8 01 21 86 42 01 D0 33 70 76 1C 2B 68 13 F9 01 4B 2B 60 D6 E7 2B 68 99 B9 5B 1E 2B 60 4C B1 93 F9 00 30 A3 42 05 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 2F 60 BA F1 00 0F 3F F4 FD AE 02 20 E6 E0 5B 1E 2B 60 4C B1 93 F9 00 30 A3 42 05 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? D5 F8 00 80 00 23 98 F9 00 20 08 F1 01 09 C5 F8 00 90 45 2A 07 D0 50 2A 03 D0 65 2A 03 D0 70 2A 07 D1 53 46 05 E0 BA F1 00 0F 08 BF 01 23 18 BF 00 23 00 24 00 2B 41 F2 50 4A 76 D0 99 F9 00 20 09 F1 01 03 2B 60 2D 2A 08 BF 01 27 18 BF 00 27 2B 2A 01 D0 2D 2A 02 D1 13 F9 01 2B 2B 60 00 20 30 2A 07 D1 2B 68 01 20 13 F9 01 2B 2B 60 30 2A FA D0 30 2A 04 DB 39 2A 02 DC A2 F1 30 01 0F E0 61 2A 04 DB 7A 2A 02 DC A2 F1 57 01 08 E0 41 2A 04 DB 5A 2A 02 DC A2 F1 37 01 01 E0 6F F0 00 01 0A 29 0D D2 04 EB 84 03 01 EB 43 04 01 20 54 45 04 DC 2B 68 13 F9 01 2B 2B 60 DA E7 41 F2 51 44 30 2A 04 DB 39 2A 02 DC A2 F1 30 03 0F E0 61 2A 04 DB 7A 2A 02 DC A2 F1 57 03 08 E0 41 2A 04 DB 5A 2A 02 DC A2 F1 37 03 01 E0 6F F0 00 03 0A 2B 04 D2 2B 68 13 F9 01 2B 2B 60 E1 E7 07 B1 64 42 98 B9 2B 68 5B 1E 2B 60 4A B1 93 F9 00 30 93 42 05 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? C5 F8 00 80 98 F9 00 20 C5 F8 00 90 2B 68 5B 1E 2B 60 4A B1 93 F9 00 30 93 42 05 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 03 9F 07 F1 08 00 86 42 3F F4 48 AF 16 F8 01 3C 13 B9 76 1E 86 42 F9 D1 86 42 3F F4 3F AF 54 45 01 DD 09 20 23 E0 13 4A 94 42 01 DA 08 20 1E E0 02 99 09 B1 04 23 00 E0 01 23 01 9D 03 FB 05 43 53 45 EE DC 93 42 F1 DB 3B 60 33 1A 7B 60 09 B1 01 20 0C E0 00 20 0A E0 68 46 3A 46 29 46 ?? ?? ?? ?? 04 E0 68 46 3A 46 29 46 ?? ?? ?? ?? 05 B0 BD E8 F0 8F B0 EB FF FF }
	condition:
		$1
}

rule file_216_7_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$c_string_character_source@D@0@PBD@Z"
		size = 268
		refs = "0048 _errno 004e _invalid_parameter_noinfo 00fc ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 0100 ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 0104 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 0108 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB"
	strings:
		$1 = { 0F B4 2D E9 F8 49 0D F1 18 0B 3F 4E 3D 4F 05 46 00 20 90 46 0C 46 95 F9 00 10 83 57 99 42 02 D0 C3 57 99 42 42 D1 23 68 40 1C 03 28 13 F9 01 1B 23 60 29 70 EF D1 23 68 16 27 5B 1E 23 60 41 B1 93 F9 00 30 8B 42 04 D0 ?? ?? ?? ?? 07 60 ?? ?? ?? ?? D4 F8 00 80 2A 48 28 4E 98 F8 00 20 08 F1 01 03 23 60 2A 70 00 21 95 F9 00 20 0B 56 9A 42 02 D0 8B 57 9A 42 2B D1 23 68 49 1C 05 29 13 F9 01 2B 23 60 2A 70 EF D1 23 68 5B 1E 23 60 42 B1 93 F9 00 30 93 42 04 D0 ?? ?? ?? ?? 07 60 ?? ?? ?? ?? 03 20 BD E8 F8 09 5D F8 14 FB 23 68 95 F9 00 20 5B 1E 23 60 4A B1 93 F9 00 30 93 42 05 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 07 20 0F E0 23 68 95 F9 00 20 5B 1E 23 60 42 B1 93 F9 00 30 93 42 04 D0 ?? ?? ?? ?? 07 60 ?? ?? ?? ?? 03 20 00 23 2B 70 C4 F8 00 80 D4 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_8_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AADAAV?$c_string_character_source@D@0@PBD@Z"
		size = 380
		refs = "0048 _errno 004e _invalid_parameter_noinfo 0074 ??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@0@@Z 00c4 ??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@0@@Z 0174 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB 0178 ?uppercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AADAAV?$c_string_character_source@D@1@PBD@Z@4QBDB"
	strings:
		$1 = { 0F B4 2D E9 F8 49 0D F1 18 0B 5B 4E 59 4F 0C 46 00 21 90 46 05 46 95 F9 00 00 8B 57 98 42 02 D0 CB 57 98 42 3A D1 23 68 49 1C 03 29 13 F9 01 0B 23 60 28 70 EF D1 23 68 16 26 5B 1E 23 60 40 B1 93 F9 00 30 83 42 04 D0 ?? ?? ?? ?? 06 60 ?? ?? ?? ?? D4 F8 00 80 98 F9 00 20 08 F1 01 03 23 60 2A 70 23 68 28 2A 62 D1 13 F8 01 2B 21 46 28 46 23 60 2A 70 ?? ?? ?? ?? 10 B3 23 68 95 F9 00 20 5B 1E 23 60 42 B1 93 F9 00 30 93 42 04 D0 ?? ?? ?? ?? 06 60 ?? ?? ?? ?? 05 20 66 E0 23 68 95 F9 00 20 5B 1E 23 60 4A B1 93 F9 00 30 93 42 05 D0 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 07 20 43 E0 21 46 28 46 ?? ?? ?? ?? 80 B1 23 68 95 F9 00 20 5B 1E 23 60 42 B1 93 F9 00 30 93 42 04 D0 ?? ?? ?? ?? 06 60 ?? ?? ?? ?? 06 20 3E E0 95 F9 00 30 29 2B 17 D0 95 F9 00 20 A2 B1 A2 F1 30 03 09 2B 09 D9 A2 F1 61 03 19 2B 05 D9 A2 F1 41 03 19 2B 01 D9 5F 2A 1D D1 23 68 13 F9 01 2B 23 60 2A 70 29 2A E7 D1 95 F9 00 20 29 2A 1D D0 23 68 5B 1E 23 60 42 B1 93 F9 00 30 93 42 04 D0 ?? ?? ?? ?? 06 60 ?? ?? ?? ?? 04 20 00 23 2B 70 C4 F8 00 80 0B E0 23 68 95 F9 00 20 5B 1E 23 60 00 2A F2 D0 93 F9 00 30 93 42 E8 E7 04 20 BD E8 F8 09 5D F8 14 FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_9_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@0@@Z"
		size = 64
		refs = "0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@1@@Z@4QBDB 003c ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@1@@Z@4QBDB"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 4D 0B 4E 00 24 90 F9 00 20 63 57 9A 42 02 D0 A3 57 9A 42 0A D1 0B 68 64 1C 04 2C 13 F8 01 2B 0B 60 02 70 EF D1 01 20 BD E8 78 88 00 20 FB E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_10_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@0@@Z"
		size = 64
		refs = "0038 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@1@@Z@4QBDB 003c ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAADAAV?$c_string_character_source@D@1@@Z@4QBDB"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0C 4D 0B 4E 00 24 90 F9 00 20 63 57 9A 42 02 D0 A3 57 9A 42 0A D1 0B 68 64 1C 05 2C 13 F8 01 2B 0B 60 02 70 EF D1 01 20 BD E8 78 88 00 20 FB E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_11_0 {
	meta:
		name = "??$parse_floating_point_write_result@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@ABUfloating_point_string@0@QAU_LDBL12@@@Z"
		size = 200
		refs = "0020 ?common_convert_to_ldbl12@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@_NAAU_LDBL12@@@Z 0050 ?assemble_floating_point_infinity@__crt_strtox@@YAX_NAAU_LDBL12@@@Z 005c ?assemble_floating_point_qnan@__crt_strtox@@YAX_NAAU_LDBL12@@@Z 0068 ?assemble_floating_point_snan@__crt_strtox@@YAX_NAAU_LDBL12@@@Z"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0C 46 09 28 42 D8 DF E8 00 F0 05 0A 0C 1C 22 28 2E 3A 44 54 00 21 20 46 ?? ?? ?? ?? 37 E0 01 21 F9 E7 94 F8 08 33 13 B1 4F F4 00 41 00 E0 00 21 00 23 13 80 C2 F8 02 30 C2 F8 06 30 51 81 00 20 25 E0 94 F8 08 03 11 46 ?? ?? ?? ?? F7 E7 94 F8 08 03 11 46 ?? ?? ?? ?? F1 E7 94 F8 08 03 11 46 ?? ?? ?? ?? EB E7 00 23 13 80 C2 F8 02 30 4F F0 40 43 C2 F8 06 30 4F F6 FF 73 53 81 DF E7 00 23 13 80 C2 F8 02 30 C2 F8 06 30 53 81 01 20 BD E8 18 88 94 F8 08 33 13 B1 4F F4 00 41 00 E0 00 21 00 23 13 80 C2 F8 02 30 C2 F8 06 30 51 81 02 20 ED E7 94 F8 08 03 11 46 ?? ?? ?? ?? 03 20 E6 E7 }
	condition:
		$1
}

rule file_216_12_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQBD0IAADAAV?$c_string_character_source@D@0@@Z"
		size = 70
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 1D 46 90 46 4F F0 00 0E A2 B1 08 9E 47 1A 95 F9 00 40 78 56 84 42 03 D0 91 F9 00 00 84 42 0C D1 33 68 0E F1 01 0E 49 1C 13 F8 01 2B C6 45 33 60 2A 70 EC D1 01 20 BD E8 F8 89 00 20 FB E7 }
	condition:
		$1
}

rule file_216_13_0 {
	meta:
		name = "??$shl_ld12@$00@@YAXQAU_LDBL12@@@Z"
		size = 36
	strings:
		$1 = { 2D E9 00 48 EB 46 D0 E9 00 21 53 00 03 60 4B 00 43 EA D2 73 43 60 83 68 5B 00 43 EA D1 73 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_216_14_0 {
	meta:
		name = "??$shl_ld12@$01@@YAXQAU_LDBL12@@@Z"
		size = 36
	strings:
		$1 = { 2D E9 00 48 EB 46 D0 E9 00 21 93 00 03 60 8B 00 43 EA 92 73 43 60 83 68 9B 00 43 EA 91 73 83 60 BD E8 00 88 }
	condition:
		$1
}

rule file_216_21_0 {
	meta:
		name = "??1?$c_string_character_source@D@__crt_strtox@@QAA@XZ"
		size = 18
		altNames = "??1?$c_string_character_source@_W@__crt_strtox@@QAA@XZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 42 68 0A B1 03 68 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_216_27_0 {
	meta:
		name = "?add_ld12@@YAXQAU_LDBL12@@QBU1@@Z"
		size = 104
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0D 46 2C 68 03 68 1A 19 02 60 9A 42 03 D3 A2 42 28 BF 00 23 00 D2 01 23 6B B1 43 68 5A 1C 42 60 9A 42 03 D3 01 2A 28 BF 00 23 00 D2 01 23 13 B1 83 68 5B 1C 83 60 69 68 43 68 5A 18 42 60 9A 42 03 D3 8A 42 28 BF 00 23 00 D2 01 23 13 B1 83 68 5B 1C 83 60 82 68 AB 68 13 44 83 60 BD E8 30 88 }
	condition:
		$1
}

rule file_216_28_0 {
	meta:
		name = "?add_uint32_carry@@YA_NIIQAI@Z"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 43 18 13 60 83 42 03 D3 8B 42 28 BF 00 20 00 D2 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_216_29_0 {
	meta:
		name = "?assemble_floating_point_ind@__crt_strtox@@YAXAAU_LDBL12@@@Z"
		size = 32
	strings:
		$1 = { 2D E9 00 48 EB 46 00 23 03 80 C0 F8 02 30 4F F0 40 43 C0 F8 06 30 4F F6 FF 73 43 81 BD E8 00 88 }
	condition:
		$1
}

rule file_216_30_0 {
	meta:
		name = "?assemble_floating_point_infinity@__crt_strtox@@YAX_NAAU_LDBL12@@@Z"
		size = 40
	strings:
		$1 = { 2D E9 00 48 EB 46 10 B1 4F F4 00 42 00 E0 00 22 00 23 0B 80 C1 F8 02 30 C1 F8 06 30 47 F6 FF 73 13 43 4B 81 BD E8 00 88 }
	condition:
		$1
}

rule file_216_31_0 {
	meta:
		name = "?assemble_floating_point_qnan@__crt_strtox@@YAX_NAAU_LDBL12@@@Z"
		size = 46
	strings:
		$1 = { 2D E9 00 48 EB 46 10 B1 4F F4 00 42 00 E0 00 22 4F F6 FF 73 0B 80 6F F0 00 03 C1 F8 02 30 C1 F8 06 30 47 F6 FF 73 13 43 4B 81 BD E8 00 88 }
	condition:
		$1
}

rule file_216_32_0 {
	meta:
		name = "?assemble_floating_point_snan@__crt_strtox@@YAX_NAAU_LDBL12@@@Z"
		size = 50
	strings:
		$1 = { 2D E9 00 48 EB 46 10 B1 4F F4 00 42 00 E0 00 22 4F F6 FF 73 0B 80 6F F0 00 03 C1 F8 02 30 6F F0 80 43 C1 F8 06 30 47 F6 FF 73 13 43 4B 81 BD E8 00 88 }
	condition:
		$1
}

rule file_216_33_0 {
	meta:
		name = "?assemble_floating_point_zero@__crt_strtox@@YAX_NAAU_LDBL12@@@Z"
		size = 34
	strings:
		$1 = { 2D E9 00 48 EB 46 10 B1 4F F4 00 43 00 E0 00 23 00 22 0A 80 C1 F8 02 20 C1 F8 06 20 4B 81 BD E8 00 88 }
	condition:
		$1
}

rule file_216_34_0 {
	meta:
		name = "?common_convert_to_ldbl12@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@_NAAU_LDBL12@@@Z"
		size = 2052
		refs = "0008 __security_push_cookie 001e memcpy 07ea __security_pop_cookie 07f8 ?ld12_pow10_negative@@3QBU_LDBL12@@B 07fc ?ld12_pow10_positive@@3QBU_LDBL12@@B"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? AD F5 50 7D 0D 46 01 46 14 46 0C A8 4F F4 43 72 03 94 ?? ?? ?? ?? 0D 98 18 28 0E D9 0D B1 08 22 00 E0 05 22 9D F8 50 30 93 42 04 DB 9D F8 4F 30 5B 1C 8D F8 4F 30 18 20 0D 90 0D B1 04 23 00 E0 01 23 03 FB 00 F2 0C 9B 00 2D A3 EB 02 0A CD F8 04 A0 CD F8 30 A0 00 F0 8C 81 0E AB C2 18 0E AB D6 1A 0E AB 00 27 0D F1 38 08 93 42 88 BF 00 26 C4 E9 00 77 A7 60 BE 46 3E B3 00 20 00 21 00 25 0A 0F 42 EA 05 15 18 F8 01 2B 0B 01 43 EA 10 71 03 01 98 18 98 42 03 D3 90 42 28 BF 00 23 00 D2 01 23 5B B1 0B 46 4A 1C 11 46 9A 42 03 D3 01 2A 28 BF 00 23 00 D2 01 23 03 B1 6D 1C 0E F1 01 0E B6 45 DD D1 C4 E9 00 01 A5 60 A3 68 44 F2 4E 01 8B B9 D4 E9 00 20 4F F6 F0 75 4F EA 12 43 06 0C 43 EA 00 40 01 EB 05 03 99 B2 4F EA 02 42 F4 D0 C4 E9 00 20 A6 60 A0 68 4F F4 00 49 4F F6 FF 7E 10 EA 09 0F 11 D1 D4 E9 00 56 EB 0F F2 0F 43 EA 46 06 01 EB 0E 03 42 EA 40 00 6D 00 99 B2 10 EA 09 0F F2 D0 C4 E9 00 56 A0 60 00 23 AD F8 20 30 CD F8 22 30 43 F6 FF 73 53 44 9A B2 00 23 CD E9 04 33 06 93 82 EA 01 03 61 81 AD F8 2A 20 6F F3 DF 31 6F F3 DF 32 03 EA 09 05 4F F0 00 46 47 F6 FF 7E 88 18 01 95 71 45 CD F8 26 60 80 F0 F6 80 72 45 80 F0 F3 80 4B F6 FD 73 98 42 00 F2 EE 80 43 F6 BF 73 98 42 01 D8 A7 60 EF E0 51 B9 43 1C 98 B2 A3 68 B3 43 05 D1 63 68 1B B9 23 68 0B B9 67 81 0B E3 4A B9 43 1C 98 B2 0A 9B B3 43 04 D1 09 9B 13 B9 08 9B 00 2B E6 D0 00 26 04 A9 05 25 A8 46 00 2D 2C DD 0D F1 28 09 04 EB 46 0A 01 24 39 F8 02 29 3A F8 02 3B 26 42 02 FB 03 F2 0B 68 03 EB 02 0E 09 D0 9E 45 03 D3 96 45 28 BF 00 23 00 D2 01 23 C1 F8 00 E0 08 E0 C1 F8 00 E0 9E 45 03 D3 96 45 28 BF 00 23 00 D2 01 23 13 B1 8B 88 5B 1C 8B 80 A8 F1 01 08 B8 F1 00 0F D8 DC 03 9C 6D 1E 89 1C 76 1C 00 2D CA DC 4C F2 02 03 06 9D 04 9E 03 44 05 98 4F F0 00 48 4F F6 FF 7A 99 B2 0B B2 00 2B 0F DD 15 EA 08 0F 0C D1 F3 0F C2 0F 43 EA 40 00 42 EA 45 05 76 00 CD E9 05 05 04 96 01 EB 0A 03 EB E7 0B B2 00 2B 32 DC 01 EB 0A 03 99 B2 0B B2 00 2B 4F F0 00 0E 2A DA 4F F0 01 09 BD F8 10 30 13 EA 09 0F 01 D0 4F F0 01 0E 15 EA 09 0F 42 46 08 BF 00 22 10 EA 09 0F 43 46 08 BF 00 23 43 EA 56 06 4B 1C 99 B2 0B B2 6D 08 00 2B 42 EA 50 00 04 96 E3 DB CD E9 05 05 BE F1 00 0F 07 D0 BD F8 10 30 43 EA 09 03 AD F8 10 30 04 9E 01 E0 BD F8 10 30 4F F4 00 49 4B 45 04 D8 6F F3 5F 46 B6 F5 C0 3F 27 D1 DD F8 12 30 13 F1 01 0F 1E D1 00 23 CD F8 12 30 DD F8 16 30 13 F1 01 0F 11 D1 00 23 CD F8 16 30 BD F8 1A 30 05 98 53 45 04 D1 4B 1C 99 B2 AD F8 1A 90 02 E0 5B 1C AD F8 1A 30 06 9D 08 E0 5B 1C CD F8 16 30 06 9D 02 E0 5B 1C CD F8 12 30 05 98 47 F6 FF 7E 71 45 02 D3 01 9B 00 2B 0B E0 BD F8 12 30 C4 F8 02 00 C4 F8 06 50 23 80 01 9B 0B 43 63 81 2F E2 00 2D 02 D0 DF F8 84 34 01 E0 DF F8 8C 34 A3 60 C4 E9 00 77 24 E2 0E AB C2 18 0E AB A2 EB 03 08 0E AB 00 27 93 42 88 BF B8 46 B8 F1 00 0F C4 E9 00 77 A7 60 B9 46 6A D0 00 21 00 20 00 25 0E AF A3 68 D4 F8 00 E0 82 0F 00 93 8B 0F 89 00 43 EA 80 00 D4 F8 04 A0 42 EA 85 03 0E EB 01 06 C4 E9 00 10 A3 60 26 60 8E 42 02 90 03 D3 76 45 28 BF 00 22 00 D2 01 22 6A B1 02 99 42 1C 10 46 8A 42 62 60 03 D3 01 2A 28 BF 00 22 00 D2 01 22 0A B1 5B 1C A3 60 0A EB 00 01 61 60 81 42 03 D3 51 45 28 BF 00 22 00 D2 01 22 0A B1 5B 1C A3 60 00 9A 1A 44 4B 00 43 EA D6 7E 53 00 43 EA D1 75 17 F8 01 3B C4 E9 01 E2 70 46 03 EB 46 01 21 60 B1 EB 46 0F A5 60 03 D3 99 42 28 BF 00 23 00 D2 01 23 63 B1 0E F1 01 00 60 60 70 45 03 D3 01 28 28 BF 00 23 00 D2 01 23 0B B1 6D 1C A5 60 09 F1 01 09 C1 45 C4 E9 01 05 9B D1 DD F8 04 A0 00 27 A3 68 44 F2 4E 00 8B B9 D4 E9 00 21 4F F6 F0 75 4F EA 01 43 0E 0C 43 EA 12 41 00 EB 05 03 98 B2 4F EA 02 42 F4 D0 C4 E9 00 21 A6 60 A1 68 4F F4 00 49 4F F6 FF 7E 11 EA 09 0F 11 D1 D4 E9 00 56 EB 0F F2 0F 43 EA 46 06 00 EB 0E 03 42 EA 41 01 6D 00 98 B2 11 EA 09 0F F2 D0 C4 E9 00 56 A1 60 60 81 BA F1 00 0F 00 F0 72 81 C6 4B A3 F1 60 02 04 DA C3 4B CA F1 00 0A A3 F1 60 02 BA F1 00 0F 00 F0 65 81 4F F0 00 48 4B F6 FD 75 43 F6 BF 76 00 21 54 32 1A F0 07 03 4F EA EA 0A CD E9 00 2A 4F F0 00 0E 00 F0 39 81 03 EB 43 03 02 EB 83 00 03 88 4B 45 0B D3 03 68 08 93 43 68 09 93 83 68 0A 93 DD F8 22 30 5B 1E CD F8 22 30 08 A8 62 89 CD E9 04 1E 41 89 00 23 06 93 82 EA 01 03 03 EA 09 03 6F F3 DF 32 6F F3 DF 31 47 F6 FF 7E 02 93 02 EB 01 09 72 45 80 F0 23 81 71 45 80 F0 20 81 A9 45 00 F2 1D 81 B1 45 07 D8 A7 60 C4 E9 00 77 00 9A 4F F4 00 49 00 21 01 E1 6A B9 09 F1 01 03 1F FA 83 F9 A3 68 33 EA 08 03 05 D1 63 68 1B B9 23 68 0B B9 67 81 EB E7 61 B9 09 F1 01 03 1F FA 83 F9 83 68 33 EA 08 03 04 D1 43 68 13 B9 03 68 00 2B DA D0 04 AD 05 26 4F F0 00 0E B0 46 00 2E 2B DD 04 EB 4E 07 01 24 00 F1 08 0A 3A F8 02 29 37 F8 02 3B 1E EA 04 0F 02 FB 03 F2 2B 68 09 D0 99 18 99 42 03 D3 91 42 28 BF 00 23 00 D2 01 23 29 60 08 E0 99 18 29 60 99 42 03 D3 91 42 28 BF 00 23 00 D2 01 23 13 B1 AB 88 5B 1C AB 80 A8 F1 01 08 B8 F1 00 0F D9 DC 03 9C 76 1E AD 1C 00 2E 0E F1 01 0E CA DC 4C F2 02 03 4B 44 1F FA 83 FE 0F FA 8E F3 DD E9 05 10 04 9D 00 2B 4F F0 00 48 16 DD 4F F6 FF 7A 10 EA 08 0F 11 D1 EB 0F CA 0F 43 EA 41 01 0E EB 0A 03 1F FA 83 FE 0F FA 8E F3 6D 00 42 EA 40 00 00 2B CD E9 04 51 06 90 EA DC 0F FA 8E F3 00 2B 4F F0 00 07 4F F6 FF 7A 33 DC 0E EB 0A 03 1F FA 83 FE 0F FA 8E F3 00 26 00 2B 2A DA 4F F0 01 09 BD F8 10 30 42 46 13 EA 09 0F 18 BF 01 26 10 EA 09 0F 08 BF 00 22 11 EA 09 0F 43 46 08 BF 00 23 43 EA 55 05 0E F1 01 03 1F FA 83 FE 0F FA 8E F3 40 08 00 2B 42 EA 51 01 04 95 E1 DB CD E9 05 10 3E B1 BD F8 10 30 43 EA 09 03 AD F8 10 30 04 9D 01 E0 BD F8 10 30 4F F4 00 49 4B 45 04 D8 6F F3 5F 45 B5 F5 C0 3F 29 D1 DD F8 12 30 13 F1 01 0F 20 D1 00 23 CD F8 12 30 DD F8 16 30 13 F1 01 0F 13 D1 00 23 CD F8 16 30 BD F8 1A 30 05 99 53 45 06 D1 0E F1 01 03 1F FA 83 FE AD F8 1A 90 02 E0 5B 1C AD F8 1A 30 06 98 08 E0 5B 1C CD F8 16 30 06 98 02 E0 5B 1C CD F8 12 30 05 99 47 F6 FF 73 9E 45 16 D3 02 9B 0B B1 1F 4B 01 E0 A8 F5 00 43 C4 E9 01 73 27 60 DD E9 00 2A 4B F6 FD 75 43 F6 BF 76 00 21 47 F6 FF 7E BA F1 00 0F 7F F4 B6 AE 14 E0 BD F8 12 30 C4 F8 02 10 C4 F8 06 00 23 80 02 9B 43 EA 0E 03 63 81 E5 E7 0B B1 0E 4B 01 E0 A8 F5 00 43 A3 60 DE E6 47 F6 FF 7E 9D F8 38 33 1B B1 63 89 43 EA 09 03 63 81 63 89 6F F3 DF 33 73 45 08 BF 03 20 18 BF 00 20 0D F5 50 7D ?? ?? ?? ?? BD E8 F0 8F FE DE 00 80 FF FF ?? ?? ?? ?? ?? ?? ?? ?? 00 80 FF 7F }
	condition:
		$1
}

rule file_216_35_0 {
	meta:
		name = "?convert_decimal_string_to_floating_type@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@AAU_LDBL12@@@Z"
		size = 18
		refs = "000e ?common_convert_to_ldbl12@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@_NAAU_LDBL12@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 46 00 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_36_0 {
	meta:
		name = "?convert_hexadecimal_string_to_floating_type@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@AAU_LDBL12@@@Z"
		size = 18
		refs = "000e ?common_convert_to_ldbl12@__crt_strtox@@YA?AW4SLD_STATUS@@ABUfloating_point_string@1@_NAAU_LDBL12@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 0A 46 01 21 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_37_0 {
	meta:
		name = "?convert_ld12_to_ldouble@@YAXQBU_LDBL12@@QAU_LDOUBLE@@@Z"
		size = 142
		refs = "0008 __security_push_cookie 0086 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? 83 B0 42 89 D0 F8 06 40 4F F0 00 47 13 46 6F F3 DF 33 1E 46 03 88 02 F4 00 4E D0 F8 02 20 1B 04 02 93 3B 42 0D 46 00 94 21 D0 BB 43 1F D0 53 1C 01 93 93 42 03 D3 01 2B 28 BF 00 23 00 D2 01 23 00 21 68 46 8B B1 50 F8 04 39 5A 1C 42 60 9A 42 03 D3 01 2A 28 BF 00 23 00 D2 01 23 49 1E 00 29 F0 DA 13 B1 3C 46 76 1C 00 E0 00 9C 01 9A 4E EA 06 03 2B 81 C5 E9 00 24 03 B0 ?? ?? ?? ?? BD E8 F0 88 }
	condition:
		$1
}

rule file_216_38_0 {
	meta:
		name = "?get@?$c_string_character_source@D@__crt_strtox@@QAADXZ"
		size = 20
	strings:
		$1 = { 2D E9 00 48 EB 46 02 46 13 68 13 F9 01 0B 13 60 BD E8 00 88 }
	condition:
		$1
}

rule file_216_39_0 {
	meta:
		name = "?increment_mantissa@@YA_NQAIH@Z"
		size = 100
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0B 11 01 EB D3 63 5A 11 A1 EB 42 13 C3 F1 1F 03 01 21 04 46 01 FA 03 F0 54 F8 22 30 19 18 44 F8 22 10 99 42 03 D3 81 42 28 BF 00 20 00 D2 01 20 52 1E 00 2A 10 DB 04 EB 82 04 68 B1 54 F8 04 39 59 1C 61 60 99 42 03 D3 01 29 28 BF 00 20 00 D2 01 20 52 1E 00 2A F0 DA BD E8 18 88 }
	condition:
		$1
}

rule file_216_42_0 {
	meta:
		name = "?mantissa_has_zero_tail@@YA_NQAIH@Z"
		size = 74
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 0B 11 01 EB D3 63 5C 11 A1 EB 44 13 C3 F1 1F 03 6F F0 00 02 9A 40 50 F8 24 30 33 EA 02 0C 01 D0 00 20 0C E0 64 1C 03 2C 08 DA 00 EB 84 02 52 F8 04 3B 00 2B F4 D1 64 1C 03 2C F8 DB 01 20 BD E8 18 88 }
	condition:
		$1
}

rule file_216_43_0 {
	meta:
		name = "?multiply_ld12@@YAXQAU_LDBL12@@QBU1@@Z"
		size = 596
		refs = "0008 __security_push_cookie 0244 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 86 B0 42 89 4C 89 00 23 CD E9 02 33 04 93 82 EA 04 03 6F F3 DF 32 6F F3 DF 34 15 46 8E 46 22 46 03 F4 00 41 47 F6 FF 73 AC 18 9D 42 CD E9 00 10 80 F0 F8 80 9A 42 80 F0 F5 80 4B F6 FD 73 9C 42 00 F2 F0 80 43 F6 BF 73 9C 42 02 D8 00 23 83 60 EF E0 4F F0 00 49 65 B9 63 1C 9C B2 83 68 33 EA 09 03 06 D1 43 68 23 B9 03 68 13 B9 00 23 43 81 E1 E0 6A B9 63 1C 9C B2 DE F8 08 30 33 EA 09 03 06 D1 DE F8 04 30 1B B9 DE F8 00 30 00 2B DD D0 00 27 02 A9 05 25 A8 46 00 2D 2A DD 00 EB 47 09 01 20 0E F1 08 0A 3A F8 02 29 39 F8 02 3B 07 42 02 FB 03 F2 0B 68 09 D0 9E 18 9E 42 03 D3 96 42 28 BF 00 23 00 D2 01 23 0E 60 08 E0 9E 18 0E 60 9E 42 03 D3 96 42 28 BF 00 23 00 D2 01 23 13 B1 8B 88 5B 1C 8B 80 A8 F1 01 08 B8 F1 00 0F DA DC 01 98 6D 1E 89 1C 7F 1C 00 2D CC DC 4C F2 02 03 DD E9 02 61 23 44 04 9C 4F F6 FF 7E 4F F0 00 49 9D B2 2B B2 00 2B 0F DD 14 EA 09 0F 0C D1 F3 0F CA 0F 43 EA 41 01 42 EA 44 04 76 00 CD E9 03 14 02 96 05 EB 0E 03 EB E7 2B B2 00 2B 2E DC 05 EB 0E 03 9D B2 2B B2 00 27 00 2B 27 DA 4F F0 01 0A BD F8 08 30 4A 46 13 EA 0A 0F 18 BF 01 27 14 EA 0A 0F 08 BF 00 22 11 EA 0A 0F 4B 46 08 BF 00 23 43 EA 56 06 6B 1C 9D B2 2B B2 64 08 00 2B 42 EA 51 01 02 96 E4 DB CD E9 03 14 3F B1 BD F8 08 30 43 EA 0A 03 AD F8 08 30 02 9E 01 E0 BD F8 08 30 4F F4 00 42 93 42 04 D8 6F F3 5F 46 B6 F5 C0 3F 27 D1 DD F8 0A 30 B3 F1 FF 3F 1E D1 00 23 CD F8 0A 30 DD F8 0E 30 B3 F1 FF 3F 11 D1 00 23 CD F8 0E 30 BD F8 12 30 03 99 73 45 04 D1 6B 1C 9D B2 AD F8 12 20 02 E0 5B 1C AD F8 12 30 04 9C 08 E0 5B 1C CD F8 0E 30 04 9C 02 E0 5B 1C CD F8 0A 30 03 99 47 F6 FF 73 9D 42 02 D3 00 9B 00 2B 0A E0 BD F8 0A 30 C0 F8 02 10 C0 F8 06 40 03 80 00 9B 2B 43 24 E7 00 29 01 D0 06 4B 00 E0 04 4B 83 60 00 23 C0 E9 00 33 06 B0 ?? ?? ?? ?? BD E8 F0 8F 00 80 FF 7F 00 80 FF FF }
	condition:
		$1
}

rule file_216_44_0 {
	meta:
		name = "?multiply_ten_pow_ld12@@YAXQAU_LDBL12@@H@Z"
		size = 756
		refs = "0008 __security_push_cookie 02e0 __security_pop_cookie 02ec ?ld12_pow10_negative@@3QBU_LDBL12@@B 02f0 ?ld12_pow10_positive@@3QBU_LDBL12@@B"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8E B0 8E 46 03 90 00 29 00 F0 63 81 B5 4B A3 F1 60 02 04 DA B2 4B C1 F1 00 0E A3 F1 60 02 BE F1 00 0F 00 F0 56 81 4F F4 00 46 75 1E 00 21 89 46 4F F0 00 48 4B F6 FD 77 43 F6 BF 7A 54 32 1E F0 07 03 4F EA EE 0E CD F8 10 E0 00 92 00 F0 3D 81 03 EB 43 03 02 EB 83 04 23 88 B3 42 0B D3 23 68 0A 93 63 68 0B 93 A3 68 0C 93 DD F8 2A 30 5B 1E CD F8 2A 30 0A AC 42 89 CD E9 06 19 61 89 00 23 08 93 82 EA 01 03 33 40 6F F3 DF 32 6F F3 DF 31 01 93 02 EB 01 09 AA 42 80 F0 0A 81 A9 42 80 F0 07 81 B9 45 00 F2 04 81 D1 45 02 D8 00 21 81 60 05 E1 72 B9 09 F1 01 03 1F FA 83 F9 83 68 33 EA 08 03 06 D1 43 68 23 B9 03 68 13 B9 00 23 43 81 F7 E0 61 B9 09 F1 01 03 1F FA 83 F9 A3 68 33 EA 08 03 04 D1 63 68 13 B9 23 68 00 2B DE D0 00 27 06 AD 05 26 4F F0 01 0E B0 46 00 2E 2C DD 00 EB 47 03 02 93 18 46 04 F1 08 0A 3A F8 02 29 30 F8 02 3B 17 EA 0E 0F 02 FB 03 F2 2B 68 09 D0 99 18 99 42 03 D3 91 42 28 BF 00 23 00 D2 01 23 29 60 08 E0 99 18 29 60 99 42 03 D3 91 42 28 BF 00 23 00 D2 01 23 13 B1 AB 88 5B 1C AB 80 A8 F1 01 08 B8 F1 00 0F D9 DC 03 98 76 1E AD 1C 7F 1C 00 2E CA DC 4C F2 02 03 4B 44 9F B2 3B B2 DD E9 07 14 06 9D 00 2B 4F F0 00 48 13 DD 4F F6 FF 76 14 EA 08 0F 0E D1 EB 0F CA 0F 43 EA 41 01 BB 19 9F B2 3B B2 6D 00 42 EA 44 04 00 2B CD E9 06 51 08 94 ED DC 3B B2 DD F8 10 E0 00 2B 4F F6 FF 79 2E DC 07 EB 09 03 9F B2 3B B2 00 26 00 2B 27 DA 4F F0 01 0A BD F8 18 30 42 46 13 EA 0A 0F 18 BF 01 26 14 EA 0A 0F 08 BF 00 22 11 EA 0A 0F 43 46 08 BF 00 23 43 EA 55 05 7B 1C 9F B2 3B B2 64 08 00 2B 42 EA 51 01 06 95 E4 DB CD E9 07 14 3E B1 BD F8 18 30 43 EA 0A 03 AD F8 18 30 06 9D 01 E0 BD F8 18 30 4F F4 00 46 B3 42 04 D8 6F F3 5F 45 B5 F5 C0 3F 27 D1 DD F8 1A 30 13 F1 01 0F 1E D1 00 23 CD F8 1A 30 DD F8 1E 30 13 F1 01 0F 11 D1 00 23 CD F8 1E 30 BD F8 22 30 07 99 4B 45 04 D1 7B 1C 9F B2 AD F8 22 60 02 E0 5B 1C AD F8 22 30 08 9C 08 E0 5B 1C CD F8 1E 30 08 9C 02 E0 5B 1C CD F8 1A 30 07 99 47 F6 FF 75 AF 42 0A D3 01 9B 0B B1 16 4B 01 E0 A8 F5 00 43 4B F6 FD 77 43 F6 BF 7A 13 E0 BD F8 1A 30 C0 F8 02 10 C0 F8 06 40 03 80 01 9B 43 F6 BF 7A 3B 43 43 81 4B F6 FD 77 08 E0 0B B1 0A 4B 01 E0 A8 F5 00 43 00 21 83 60 C0 E9 00 11 00 9A 4F F0 00 09 00 21 BE F1 00 0F 7F F4 B5 AE 0E B0 ?? ?? ?? ?? BD E8 F0 8F 00 80 FF FF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_45_0 {
	meta:
		name = "?multiply_two_pow_ld12@@YAXQAU_LDBL12@@H@Z"
		size = 608
		refs = "0008 __security_push_cookie 0250 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 8A B0 00 23 AD F8 18 30 CD F8 1A 30 43 F6 FF 73 0B 44 42 89 99 B2 00 23 CD E9 02 33 04 93 81 EA 02 03 AD F8 22 10 03 F4 00 45 6F F3 DF 32 6F F3 DF 31 47 F6 FF 73 4F F0 00 4A 54 18 9A 42 CD F8 1E A0 00 95 80 F0 F4 80 99 42 80 F0 F1 80 4B F6 FD 73 9C 42 00 F2 EC 80 43 F6 BF 73 9C 42 02 D8 00 23 83 60 EB E0 62 B9 63 1C 9C B2 83 68 33 EA 0A 03 06 D1 43 68 23 B9 03 68 13 B9 00 23 43 81 DF E0 51 B9 63 1C 9C B2 08 9B 33 EA 0A 03 04 D1 07 9B 13 B9 06 9B 00 2B E2 D0 00 26 02 A9 05 25 4F F0 01 0A AE 46 00 2D 29 DD 0D F1 20 08 00 EB 46 09 39 F8 02 2B 38 F8 02 39 16 EA 0A 0F 02 FB 03 F2 0B 68 09 D0 9F 18 9F 42 03 D3 97 42 28 BF 00 23 00 D2 01 23 0F 60 08 E0 9F 18 0F 60 9F 42 03 D3 97 42 28 BF 00 23 00 D2 01 23 13 B1 8B 88 5B 1C 8B 80 AE F1 01 0E BE F1 00 0F D9 DC 6D 1E 89 1C 76 1C 00 2D CD DC 4C F2 02 03 DD E9 03 15 02 9E 23 44 4F F6 FF 7E 4F F0 00 4A 9C B2 23 B2 00 2B 0F DD 15 EA 0A 0F 0C D1 F3 0F CA 0F 43 EA 41 01 42 EA 45 05 76 00 CD E9 03 15 02 96 04 EB 0E 03 EB E7 23 B2 00 2B 2E DC 04 EB 0E 03 9C B2 23 B2 00 27 00 2B 27 DA 4F F0 01 08 BD F8 08 30 52 46 13 EA 08 0F 18 BF 01 27 15 EA 08 0F 08 BF 00 22 11 EA 08 0F 53 46 08 BF 00 23 43 EA 56 06 63 1C 9C B2 23 B2 6D 08 00 2B 42 EA 51 01 02 96 E4 DB CD E9 03 15 3F B1 BD F8 08 30 43 EA 08 03 AD F8 08 30 02 9E 01 E0 BD F8 08 30 4F F4 00 42 93 42 04 D8 6F F3 5F 46 B6 F5 C0 3F 27 D1 DD F8 0A 30 B3 F1 FF 3F 1E D1 00 23 CD F8 0A 30 DD F8 0E 30 B3 F1 FF 3F 11 D1 00 23 CD F8 0E 30 BD F8 12 30 03 99 73 45 04 D1 63 1C 9C B2 AD F8 12 20 02 E0 5B 1C AD F8 12 30 04 9D 08 E0 5B 1C CD F8 0E 30 04 9D 02 E0 5B 1C CD F8 0A 30 03 99 47 F6 FF 73 9C 42 02 D3 00 9B 00 2B 0A E0 BD F8 0A 30 C0 F8 02 10 C0 F8 06 50 03 80 00 9B 23 43 26 E7 00 2D 01 D0 06 4B 00 E0 04 4B 83 60 00 23 C0 E9 00 33 0A B0 ?? ?? ?? ?? BD E8 F0 8F 00 80 FF 7F 00 80 FF FF }
	condition:
		$1
}

rule file_216_48_0 {
	meta:
		name = "?round_mantissa@@YA_NQAIH@Z"
		size = 228
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 4C 1E 62 1C 13 11 02 EB D3 63 5E 11 A2 EB 46 13 C3 F1 1F 07 01 23 03 FA 07 F2 50 F8 26 30 00 25 6F EA 05 0E 1A 42 3F D0 50 F8 26 30 0E FA 07 F2 31 46 33 EA 02 0C 0B D1 49 1C 03 29 34 DA 00 EB 81 02 52 F8 04 3B 1B B9 49 1C 03 29 F9 DB 2B E0 23 11 04 EB D3 63 5A 11 A4 EB 42 13 C3 F1 1F 03 01 21 01 FA 03 F4 50 F8 22 30 19 19 40 F8 22 10 99 42 03 D3 A1 42 28 BF 00 23 00 D2 01 23 52 1E 00 2A 1D 46 10 DB 00 EB 82 04 6D B1 54 F8 04 39 59 1C 61 60 99 42 03 D3 01 29 28 BF 00 25 00 D2 01 25 52 1E 00 2A F0 DA 50 F8 26 30 0E FA 07 F2 13 40 72 1C 03 2A 40 F8 26 30 0C DA 03 21 00 EB 82 03 8A 1A 4F F0 00 01 05 D0 03 EB 82 02 43 F8 04 1B 93 42 FB D1 28 46 BD E8 F0 88 }
	condition:
		$1
}

rule file_216_50_0 {
	meta:
		name = "?shr_ld12@@YAXQAU_LDBL12@@@Z"
		size = 56
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B D0 E9 01 43 4F F0 00 42 11 46 13 F0 01 0F 08 BF 00 21 14 F0 01 0F 08 BF 00 22 5B 08 83 60 41 EA 54 03 43 60 03 68 42 EA 53 03 03 60 BD E8 18 88 }
	condition:
		$1
}

rule file_216_51_0 {
	meta:
		name = "?transform_into_return_value@@YAHW4SLD_STATUS@@@Z"
		size = 28
	strings:
		$1 = { 2D E9 00 48 EB 46 02 28 05 D0 03 28 18 BF 00 20 02 D1 03 20 00 E0 04 20 BD E8 00 88 }
	condition:
		$1
}

rule file_216_52_0 {
	meta:
		name = "?unget@?$c_string_character_source@D@__crt_strtox@@QAAXD@Z"
		size = 42
		refs = "0016 _errno 0022 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 5B 1E 03 60 59 B1 93 F9 00 30 8B 42 07 D0 ?? ?? ?? ?? 16 23 03 60 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 }
	condition:
		$1
}

rule file_216_53_0 {
	meta:
		name = "?validate@?$c_string_character_source@D@__crt_strtox@@QBA_NXZ"
		size = 32
		refs = "000a _errno 0012 _invalid_parameter_noinfo"
		altNames = "?validate@?$c_string_character_source@_W@__crt_strtox@@QBA_NXZ ?validate@?$stream_input_adapter@_W@__crt_stdio_input@@QBA_NXZ ?validate@?$stream_output_adapter@_W@__crt_stdio_output@@QBA_NXZ ?validate@?$string_output_adapter@D@__crt_stdio_output@@QBA_NXZ ?validate@?$string_output_adapter@_W@__crt_stdio_output@@QBA_NXZ"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 68 3B B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 00 E0 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_216_57_0 {
	meta:
		name = "_atoldbl_l"
		size = 224
		refs = "0008 __security_push_cookie 0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0028 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QBD$$T@Z 0032 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@QAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QAU_LDBL12@@@Z 00d8 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? 8B B0 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 00 23 08 A8 00 22 21 46 CD E9 04 33 06 93 ?? ?? ?? ?? 01 46 01 A8 04 AA ?? ?? ?? ?? BD F8 1A 20 DD F8 16 10 4F F0 00 47 13 46 6F F3 DF 33 1C 46 BD F8 10 30 02 F4 00 4E DD F8 12 20 1B 04 0A 93 3B 42 06 46 08 91 21 D0 BB 43 1F D0 53 1C 09 93 93 42 03 D3 01 2B 28 BF 00 23 00 D2 01 23 00 21 08 A8 8B B1 50 F8 04 39 5A 1C 42 60 9A 42 03 D3 01 2A 28 BF 00 23 00 D2 01 23 49 1E 00 29 F0 DA 13 B1 39 46 64 1C 00 E0 08 99 09 9A 4E EA 04 03 2B 81 C5 E9 00 21 02 2E 05 D0 03 2E 18 BF 00 20 02 D1 03 20 00 E0 04 20 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 0B B0 ?? ?? ?? ?? BD E8 F0 88 }
	condition:
		$1
}

rule file_217_6_0 {
	meta:
		name = "?_wcsupr_s_l_stat@@YAHQA_WIQAU__crt_locale_pointers@@@Z"
		size = 376
		refs = "0008 __security_push_cookie 0018 _errno 0020 _invalid_parameter_noinfo 002c wcsnlen 0074 __acrt_LCMapStringW 00e0 __chkstk 0100 _malloc_base 0148 wcscpy_s 0168 _free_base 0170 __security_pop_cookie"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B ?? ?? ?? ?? 6F 46 82 B0 05 46 92 46 0E 46 3D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 25 A1 E0 31 46 28 46 ?? ?? ?? ?? B0 42 02 D3 00 23 2B 80 EE E7 DA F8 00 30 D3 F8 A8 00 80 B9 2B 88 63 B1 4F F6 E0 72 2B 88 61 2B 03 D3 7A 2B 01 D8 13 44 2B 80 35 F8 02 3F 00 2B F4 D1 00 25 82 E0 00 24 E3 43 2A 46 4F F4 00 71 01 94 00 94 ?? ?? ?? ?? 81 46 38 B9 ?? ?? ?? ?? 2A 23 03 60 ?? ?? ?? ?? 05 68 6F E0 4E 45 08 D2 2C 80 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 25 64 E0 4F EA 49 03 03 F1 08 02 9A 42 98 BF 00 22 4D F6 DD 58 62 B3 03 F1 08 02 9A 42 98 BF 00 22 B2 F5 80 6F 17 D8 03 F1 08 02 9A 42 98 BF 00 22 D3 1D 93 42 01 D8 6F F0 07 03 23 F0 07 03 9C 08 ?? ?? ?? ?? AD EB 04 0D 1D F1 08 04 11 D0 4C F6 CC 43 23 60 0A E0 03 F1 08 00 98 42 98 BF 00 20 ?? ?? ?? ?? 04 46 2C B1 C0 F8 00 80 08 34 00 E0 00 24 3C B9 ?? ?? ?? ?? 0C 23 03 60 ?? ?? ?? ?? 05 68 1A E0 DA F8 00 20 6F F0 00 03 4F F4 00 71 D2 F8 A8 00 2A 46 CD F8 04 90 00 94 ?? ?? ?? ?? 30 B1 22 46 31 46 28 46 ?? ?? ?? ?? 05 46 04 E0 ?? ?? ?? ?? 2A 23 03 60 2A 25 3C B1 54 F8 08 3C 43 45 03 D1 A4 F1 08 00 ?? ?? ?? ?? 28 46 BD 46 ?? ?? ?? ?? BD E8 F0 8F }
	condition:
		$1
}

rule file_217_12_0 {
	meta:
		name = "_wcsupr"
		size = 88
		refs = "0012 _errno 001a _invalid_parameter_noinfo 004a _wcsupr_s_l 0054 __acrt_locale_changed_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 12 4B 04 46 1B 68 CB B9 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 24 15 E0 23 88 22 46 93 B1 4F F6 E0 71 13 88 61 2B 03 D3 7A 2B 01 D8 0B 44 13 80 32 F8 02 3F 00 2B F4 D1 04 E0 00 22 D1 43 20 46 ?? ?? ?? ?? 20 46 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_5_0 {
	meta:
		name = "_mbschr_l"
		size = 130
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0016 _errno 001e _invalid_parameter_noinfo 002e strchr"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0D 46 04 46 68 46 11 46 ?? ?? ?? ?? 34 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 1F E0 02 99 8B 68 BB B9 29 46 20 46 ?? ?? ?? ?? 04 46 17 E0 51 FA 82 F3 5B 7E 13 F0 04 0F 08 D0 64 1C 23 78 6B B1 43 EA 02 23 9D 42 03 D1 64 1E 08 E0 95 42 06 D0 64 1C 22 78 00 2A EA D1 95 42 00 D0 00 24 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "mbrtoc16"
		size = 280
		refs = "00ba _errno 0110 ??_C@_00CNPNBAHC@?$AA@ 0114 ?internal_pst@?1??mbrtoc16@@9@4U_Mbstatet@@A"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 1D 46 96 46 05 B9 41 4D EB 88 2C 68 5B B2 19 B9 3D 49 00 20 4F F0 01 0E 0A 46 1F 46 3C E0 BE F1 00 0F 69 D0 00 2F 0B DD 16 78 06 F0 C0 03 80 2B 3F D1 06 F0 3F 03 43 EA 84 14 7B 1E 5B B2 26 E0 14 78 14 F0 80 0F 22 D0 04 F0 E0 03 C0 2B 03 D1 04 F0 1F 04 01 23 1A E0 04 F0 F0 03 E0 2B 03 D1 04 F0 0F 04 02 23 12 E0 04 F0 F8 03 F0 2B 03 D1 04 F0 07 04 03 23 0A E0 04 F0 FC 03 F8 2B 08 BF 04 23 02 D0 FC 2B 14 D1 05 23 04 F0 03 04 1F 46 B3 B1 52 1C AE F1 01 0E 10 2B C0 D1 18 B1 37 23 63 F3 9F 24 04 80 00 23 EB 80 6F F0 02 00 BD E8 F0 88 ?? ?? ?? ?? 2A 23 03 60 6F F0 00 00 F6 E7 10 4B 9C 42 F5 D8 4F F6 FF 73 9C 42 0C D9 30 B1 4F F6 C0 73 03 EB 94 23 43 F4 58 43 03 80 10 23 EB 80 53 1A 58 1C E2 E7 00 B1 04 80 00 23 EB 80 00 2C F6 D1 00 20 DA E7 2C 60 EB 80 6F F0 01 00 D5 E7 FE DE FF FF 10 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "free"
		size = 30
		refs = "001a _free_base"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B BF F3 5B 8F 00 23 00 93 00 9B BF F3 5B 8F BD E8 0C 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "asinhl"
		size = 152
		refs = "000e _ldtest 006c log1pl 0076 log 0094 _LEps_C"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 02 28 02 D8 9D ED 00 0B 35 E0 9D ED 00 3B B5 EE C0 3B F1 EE 10 FA 05 D2 B1 EE 43 3B 01 24 8D ED 00 3B 00 E0 00 24 16 4B B0 EE 00 1B 93 ED 00 0B 81 EE 00 0B B4 EE C0 3B F1 EE 10 FA 10 D2 23 EE 03 2B B7 EE 00 1B 32 EE 01 0B B1 EE C0 0B 30 EE 01 0B 82 EE 00 0B 30 EE 03 0B ?? ?? ?? ?? 07 E0 B0 EE 43 0B ?? ?? ?? ?? 9F ED 04 1B 30 EE 01 0B 0C B1 B1 EE 40 0B BD E8 1E 88 EF 39 FA FE 42 2E E6 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "asinh"
		size = 152
		refs = "000e _dtest 006c log1p 0076 log 0094 _Eps_C"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 68 46 8D ED 00 0B ?? ?? ?? ?? 02 28 02 D8 9D ED 00 0B 35 E0 9D ED 00 3B B5 EE C0 3B F1 EE 10 FA 05 D2 B1 EE 43 3B 01 24 8D ED 00 3B 00 E0 00 24 16 4B B0 EE 00 1B 93 ED 00 0B 81 EE 00 0B B4 EE C0 3B F1 EE 10 FA 10 D2 23 EE 03 2B B7 EE 00 1B 32 EE 01 0B B1 EE C0 0B 30 EE 01 0B 82 EE 00 0B 30 EE 03 0B ?? ?? ?? ?? 07 E0 B0 EE 43 0B ?? ?? ?? ?? 9F ED 04 1B 30 EE 01 0B 0C B1 B1 EE 40 0B BD E8 1E 88 EF 39 FA FE 42 2E E6 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "CountryEnumProc"
		size = 144
		refs = "0008 __security_push_cookie 0010 __acrt_getptd 0020 LcidFromHexString 0048 _wcsicmp 007e __security_pop_cookie 0088 __rglangidNotDefault 008c __imp_GetLocaleInfoW"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? BD B0 04 46 ?? ?? ?? ?? 07 46 ?? ?? ?? ?? D0 F8 4C 53 20 46 ?? ?? ?? ?? 7B 6E 06 46 41 F2 02 01 03 B1 07 21 16 4C 78 23 6A 46 24 68 30 46 A0 47 10 B9 00 23 2B 60 18 E0 78 6D 69 46 ?? ?? ?? ?? 78 B9 0E 49 B0 B2 00 22 31 F8 02 3B 98 42 08 D0 52 1C 0A 2A F8 D3 2B 68 C5 E9 01 66 43 F0 04 03 2B 60 2B 68 13 F0 04 0F 01 D1 01 20 00 E0 00 20 3D B0 ?? ?? ?? ?? BD E8 F0 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "GetLcidFromCountry"
		size = 68
		refs = "000a __acrt_getptd 0012 wcslen 003c CountryEnumProc 0040 __imp_EnumSystemLocalesW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 05 46 68 6D ?? ?? ?? ?? 03 28 08 BF 01 23 18 BF 00 23 6B 66 07 4B 05 48 01 21 1B 68 98 47 23 68 13 F0 04 0F 01 D1 00 23 23 60 BD E8 30 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_2_0 {
	meta:
		name = "GetLcidFromDefault"
		size = 36
		refs = "0020 __imp_GetUserDefaultLCID"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 23 68 43 F4 82 73 23 60 03 4B 1B 68 98 47 C4 E9 01 00 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_3_0 {
	meta:
		name = "GetLcidFromLangCountry"
		size = 136
		refs = "000a __acrt_getptd 0012 wcslen 0080 LangCountryEnumProc 0084 __imp_EnumSystemLocalesW"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 ?? ?? ?? ?? 04 46 20 6D ?? ?? ?? ?? 03 28 60 6D 08 BF 01 23 18 BF 00 23 23 66 ?? ?? ?? ?? 03 28 08 BF 01 23 18 BF 00 23 00 26 63 66 6E 60 23 6E 93 B1 02 21 11 4B 0F 48 E1 65 1B 68 01 21 98 47 2A 68 02 F4 40 73 B3 F5 40 7F 02 D1 12 F0 07 0F 00 D1 2E 60 BD E8 78 88 22 6D 00 21 32 F8 02 3B 41 2B 01 D3 5A 2B 03 D9 61 2B E3 D3 7A 2B E1 D8 49 1C F3 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_4_0 {
	meta:
		name = "GetLcidFromLanguage"
		size = 104
		refs = "000a __acrt_getptd 0014 wcslen 0060 LanguageEnumProc 0064 __imp_EnumSystemLocalesW"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 05 46 ?? ?? ?? ?? 06 46 34 6D 20 46 ?? ?? ?? ?? 03 28 08 BF 01 23 18 BF 00 23 33 66 73 B1 02 22 0E 4B 0D 48 F2 65 1B 68 01 21 98 47 2B 68 13 F0 04 0F 01 D1 00 23 2B 60 BD E8 78 88 00 22 34 F8 02 3B 41 2B 01 D3 5A 2B 03 D9 61 2B E8 D3 7A 2B E6 D8 52 1C F3 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_5_0 {
	meta:
		name = "GetPrimaryLen"
		size = 38
	strings:
		$1 = { 2D E9 00 48 EB 46 02 46 00 20 32 F8 02 3B 41 2B 01 D3 5A 2B 03 D9 61 2B 03 D3 7A 2B 01 D8 40 1C F3 E7 BD E8 00 88 }
	condition:
		$1
}

rule file_222_6_0 {
	meta:
		name = "LangCountryEnumProc"
		size = 404
		refs = "0008 __security_push_cookie 0010 __acrt_getptd 0020 LcidFromHexString 0048 _wcsicmp 008e _wcsnicmp 00a0 wcslen 012e TestDefaultLanguage 0184 __security_pop_cookie 018c __imp_GetLocaleInfoW 0190 __rglangidNotDefault"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? BE B0 04 46 ?? ?? ?? ?? 06 46 ?? ?? ?? ?? D0 F8 4C 53 20 46 ?? ?? ?? ?? 73 6E 07 46 41 F2 02 01 03 B1 07 21 56 4C 78 23 02 AA 24 68 38 46 A0 47 10 B9 00 23 2B 60 9B E0 70 6D 02 A9 ?? ?? ?? ?? 41 F2 01 08 F8 BB 33 6E 0B B1 03 21 00 E0 41 46 4B 4C 78 23 02 AA 24 68 38 46 A0 47 00 28 E8 D0 30 6D 02 A9 ?? ?? ?? ?? 2B 68 18 B9 43 F4 41 73 6F 60 26 E0 13 F0 02 0F 25 D1 F2 6D 8A B1 30 6D 02 A9 ?? ?? ?? ?? 60 B9 2B 68 AF 60 43 F0 02 03 2B 60 30 6D ?? ?? ?? ?? F3 6D 98 42 13 D1 6F 60 11 E0 29 68 11 F0 01 0F 0D D1 36 48 BC B2 00 22 30 F8 02 3B 9C 42 06 D0 52 1C 0A 2A F8 D3 41 F0 01 03 AF 60 2B 60 2B 68 03 F4 40 73 B3 F5 40 7F 4A D0 33 6E 0B B1 4F F0 03 08 29 4C 78 23 02 AA 24 68 41 46 38 46 A0 47 00 28 A2 D0 30 6D 02 A9 ?? ?? ?? ?? C0 B9 2B 68 43 F4 00 74 2C 60 33 6E 13 B1 44 F4 80 73 2B E0 D6 F8 5C 80 B8 F1 00 0F F7 D0 30 6D ?? ?? ?? ?? 40 45 F2 D1 2A 46 01 21 38 46 ?? ?? ?? ?? 17 E0 33 6E EB B9 F3 6D DB B1 30 6D 02 A9 ?? ?? ?? ?? B0 B9 ?? ?? ?? ?? 10 4C 38 46 4F F0 00 51 24 68 6F F3 9F 20 02 23 6A 46 49 1C 40 F4 80 60 A0 47 30 B1 2B 68 43 F4 80 73 2B 60 6B 68 03 B9 6F 60 2B 68 13 F0 04 0F 01 D1 01 20 00 E0 00 20 3E B0 ?? ?? ?? ?? BD E8 F0 89 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_7_0 {
	meta:
		name = "LanguageEnumProc"
		size = 188
		refs = "0008 __security_push_cookie 0010 __acrt_getptd 0020 LcidFromHexString 0048 _wcsicmp 005c TestDefaultLanguage 00ae __security_pop_cookie 00b8 __imp_GetLocaleInfoW"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? BE B0 04 46 ?? ?? ?? ?? 07 46 ?? ?? ?? ?? D0 F8 4C 53 20 46 ?? ?? ?? ?? 3B 6E 06 46 41 F2 01 01 03 B1 03 21 21 4C 78 23 02 AA 24 68 30 46 A0 47 10 B9 00 23 2B 60 30 E0 38 6D 02 A9 ?? ?? ?? ?? 3B 6E 4F F0 04 08 30 B9 EB B9 2A 46 01 21 30 46 ?? ?? ?? ?? 16 E0 E3 B9 FB 6D D3 B1 38 6D 02 A9 ?? ?? ?? ?? A8 B9 ?? ?? ?? ?? 10 4C 30 46 4F F0 00 51 24 68 6F F3 9F 20 02 23 6A 46 49 1C 40 F4 80 60 A0 47 28 B1 2B 68 C5 E9 01 66 43 EA 08 03 2B 60 2B 68 13 EA 08 0F 01 D1 01 20 00 E0 00 20 3E B0 ?? ?? ?? ?? BD E8 F0 89 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_8_0 {
	meta:
		name = "LcidFromHexString"
		size = 68
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 03 88 00 22 BB B1 4F F6 D9 71 4F F6 F9 74 80 1C 61 2B 03 D3 66 2B 98 BF 5B 18 04 D9 41 2B 03 D3 46 2B 01 D8 23 44 9B B2 03 EB 02 13 A3 F1 30 02 03 88 00 2B EB D1 10 46 BD E8 18 88 }
	condition:
		$1
}

rule file_222_9_0 {
	meta:
		name = "ProcessCodePage"
		size = 124
		refs = "0014 wcscmp 003e _wtol 0068 __imp_GetACP 0070 __imp_GetLocaleInfoW 0074 ??_C@_17CIKBIHLH@?$AAO?$AAC?$AAP?$AA?$AA@ 0078 ??_C@_17DNCLJFIF@?$AAA?$AAC?$AAP?$AA?$AA@"
	strings:
		$1 = { 2D E9 3C 48 0D F1 10 0B 04 46 0D 46 D4 B1 23 88 C3 B1 19 49 ?? ?? ?? ?? A0 B1 16 49 20 46 ?? ?? ?? ?? 58 B9 12 4C A8 68 4F F0 00 51 24 68 02 23 6A 46 0B 31 A0 47 68 B1 00 98 12 E0 20 46 ?? ?? ?? ?? 0E E0 0A 4C A8 68 08 49 24 68 02 23 6A 46 A0 47 08 B9 00 20 04 E0 00 98 10 B9 02 4B 1B 68 98 47 BD E8 3C 88 FE DE ?? ?? ?? ?? 04 10 00 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_10_0 {
	meta:
		name = "TestDefaultCountry"
		size = 40
		refs = "0024 __rglangidNotDefault"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 49 80 B2 00 22 31 F8 02 3B 98 42 04 D0 52 1C 0A 2A F8 D3 01 20 00 E0 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_11_0 {
	meta:
		name = "TestDefaultLanguage"
		size = 108
		refs = "000c __acrt_getptd 0058 wcslen 0068 __imp_GetLocaleInfoW"
	strings:
		$1 = { 2D E9 FC 48 0D F1 18 0B 0D 46 06 46 ?? ?? ?? ?? 4F F0 00 54 61 1C 34 46 6F F3 9F 24 07 46 44 F4 80 60 11 4C 02 23 6A 46 24 68 A0 47 08 B9 00 20 17 E0 00 9B 9E 42 13 D0 95 B1 3A 6D 00 24 32 F8 02 3B 41 2B 01 D3 5A 2B 03 D9 61 2B 03 D3 7A 2B 01 D8 64 1C F3 E7 38 6D ?? ?? ?? ?? 84 42 E6 D0 01 20 BD E8 FC 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_12_0 {
	meta:
		name = "TranslateName"
		size = 80
		refs = "0026 _wcsicmp"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0D 46 00 26 00 2D 17 46 80 46 12 DB 73 19 03 EB D3 73 5C 10 04 EB 44 03 58 F8 23 10 38 68 ?? ?? ?? ?? 00 28 08 D0 B8 BF 65 1E A8 BF 66 1C AE 42 EC DD 00 20 BD E8 F8 89 04 EB 44 03 08 EB 83 03 1B 1D 3B 60 01 20 F5 E7 }
	condition:
		$1
}

rule file_222_13_0 {
	meta:
		name = "__acrt_get_qualified_locale_downlevel"
		size = 552
		refs = "0008 __security_push_cookie 0014 __acrt_getptd 0046 TranslateName 0060 GetLcidFromLangCountry 0068 GetLcidFromLanguage 00b0 wcslen 0106 wcscmp 0132 _wtol 0192 __acrt_LCIDToLocaleName 01da _itow_s 01e6 __security_pop_cookie 01f0 __imp_GetLocaleInfoW 01f4 __imp_IsValidLocale 01f8 __imp_IsValidCodePage 01fc __imp_GetACP 0204 ??_C@_17CIKBIHLH@?$AAO?$AAC?$AAP?$AA?$AA@ 0208 ??_C@_17DNCLJFIF@?$AAA?$AAC?$AAP?$AA?$AA@ 020c __imp_GetUserDefaultLCID 0210 CountryEnumProc 0214 __imp_EnumSystemLocalesW 0218 __acrt_rg_language 021c __acrt_rg_language_count 0220 __acrt_rg_country 0224 __acrt_rg_country_count"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B ?? ?? ?? ?? 85 B0 90 46 89 46 07 46 ?? ?? ?? ?? 00 23 CD E9 02 33 04 93 06 46 ?? ?? ?? ?? 02 AB C0 F8 4C 33 17 F1 80 03 C6 E9 14 73 09 D0 1B 88 3B B1 7A 4B 78 48 06 F1 54 02 1B 68 59 1E ?? ?? ?? ?? 00 23 02 93 33 6D 33 B3 1B 88 23 B3 73 6D 2B B1 1B 88 1B B1 02 A8 ?? ?? ?? ?? 02 E0 02 A8 ?? ?? ?? ?? 02 9B AB B9 6A 4B 69 48 06 F1 50 02 1B 68 59 1E ?? ?? ?? ?? 30 B1 73 6D 33 B1 1B 88 23 B1 02 A8 ?? ?? ?? ?? 04 9D 2B E0 02 A8 ?? ?? ?? ?? F9 E7 04 9D 28 E0 73 6D D3 B1 1B 88 C3 B1 ?? ?? ?? ?? 04 46 60 6D ?? ?? ?? ?? 03 28 08 BF 01 23 18 BF 00 23 63 66 54 4B 53 48 01 21 1B 68 98 47 02 9B 04 9D 13 F0 04 0F 0C D1 00 23 02 93 09 E0 4F F4 82 73 02 93 4A 4B 1B 68 98 47 05 46 CD E9 03 55 02 9B 00 2B 77 D0 17 B1 07 F5 80 74 00 E0 00 24 E4 B1 23 88 D3 B1 41 49 20 46 ?? ?? ?? ?? A8 B1 3D 49 20 46 ?? ?? ?? ?? 60 B9 36 4C 4F F0 00 51 02 23 24 68 6A 46 0B 31 28 46 A0 47 00 28 5A D0 00 9D 12 E0 20 46 ?? ?? ?? ?? 0D E0 2D 4C 31 49 02 23 24 68 6A 46 28 46 A0 47 00 28 4B D0 00 9D 2D B9 2B 4B 1B 68 98 47 05 46 00 2D 43 D0 4F F6 E8 53 9D 42 3F D0 5B 1C 9D 42 3C D0 23 4B A8 B2 1B 68 98 47 B8 B3 20 4B 03 98 01 21 1B 68 98 47 88 B3 B9 F1 00 0F 01 D0 C9 F8 00 50 03 98 06 F5 28 71 00 23 55 22 ?? ?? ?? ?? B8 F1 00 0F 20 D0 03 98 08 F5 90 71 00 23 55 22 ?? ?? ?? ?? 11 4C 03 98 40 23 24 68 42 46 41 F2 01 01 A0 47 90 B1 0C 4C 04 98 40 23 24 68 08 F1 80 02 41 F2 02 01 A0 47 40 B1 0A 23 10 22 08 F5 80 71 28 46 ?? ?? ?? ?? 01 20 00 E0 00 20 05 B0 ?? ?? ?? ?? BD E8 F0 8B FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 10 00 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "cosh"
		size = 704
		refs = "0038 _controlfp_s 0052 _handle_nan 00aa _handle_error 00d8 splitexp 0224 ?sinh_lead@?1??cosh@@9@9 0228 ?cosh_lead@?1??cosh@@9@9 022c ?sinh_tail@?1??cosh@@9@9 0238 ?cosh_tail@?1??cosh@@9@9 02a4 ??_C@_04HPJJNFIM@cosh?$AA@"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 0A 8B 8B B0 51 EC 10 0B AA 4B B0 EE 40 2B 21 F0 00 42 9A 42 0E D8 0D D2 50 EA 02 03 02 D1 B7 EE 00 0B EC E0 00 23 04 A8 10 22 10 21 04 93 ?? ?? ?? ?? F4 E7 9E 4C A2 42 14 D3 01 D8 00 28 11 D3 A2 42 04 D3 00 D8 10 B1 ?? ?? ?? ?? D7 E0 00 23 04 A8 00 22 00 21 04 93 ?? ?? ?? ?? 00 23 44 EC 10 3B CC E0 8A 42 02 D1 B0 EE 42 BB 01 E0 B1 EE 42 BB 9F ED 8C 0B B4 EE C0 BB F1 EE 10 FA 12 DB 01 23 03 93 22 23 02 93 11 23 01 93 9F ED 84 1B 82 48 03 23 00 93 00 22 23 46 B0 EE 42 0B 13 21 ?? ?? ?? ?? AB E0 B3 EE 04 2B B4 EE C2 BB F1 EE 10 FA 3A DB 9F ED 77 4B 9F ED 74 3B 9F ED 71 2B 06 AA 08 A9 04 A8 B7 EE 00 1B B0 EE 4B 0B ?? ?? ?? ?? 04 98 9D ED 06 2B 9D ED 08 0B 40 1E 00 F2 FE 32 40 F2 FD 73 9A 42 30 EE 02 0B 07 D8 40 F2 FF 33 1B 18 1B 05 00 22 43 EC 11 2B 12 E0 00 EB D0 72 40 F2 FF 31 11 EB 62 03 1B 05 00 24 A0 EB 62 02 43 EC 11 4B 53 18 21 EE 00 1B 1B 05 00 22 43 EC 10 2B 21 EE 00 0B 69 E0 BD EE CB 0B 9F ED 52 5B 9F ED 4F AB 10 EE 10 4A 9F ED 4B 9B 9F ED 48 1B 9F ED 45 8B 00 EE 10 4A 9F ED 41 7B 9F ED 3E 6B 9F ED 3B 2B B8 EE C0 0B 9F ED 37 4B 9F ED 34 3B 32 4B 3B EE 40 CB 9F ED 2F 0B 2D 4A 2C EE 0C BB 03 EB C4 03 29 49 28 48 0B EE 05 AB 0B EE 01 8B 0A EE 0B 9B 08 EE 0B 6B 09 EE 0B 7B 9F ED 20 1B 06 EE 0B 0B 07 EE 0B 2B 00 EE 0B 3B 02 EE 0B 4B B6 EE 00 0B 03 EE 0B 1B 9F ED 17 2B 04 EE 0B 0B 01 EE 0B 2B 20 EE 0B 6B 93 ED 00 4B 2B EE 0C 0B 02 EB C4 03 24 EE 06 3B 22 EE 00 5B 01 EB C4 02 93 ED 00 0B 00 EB C4 03 00 EE 05 3B 92 ED 00 2B 93 ED 00 1B 00 EE 0C 3B 33 EE 04 0B 02 EE 06 0B 01 EE 05 0B 01 EE 0C 0B 30 EE 02 0B 0B B0 BD EC 0A 8B BD E8 10 88 FE DE 55 55 55 55 55 55 C5 3F FD 10 11 11 11 11 81 3F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7D 3E E1 A4 E3 1D C7 3E ?? ?? ?? ?? 80 EE 01 1A A0 01 2A 3F 02 55 55 55 55 55 A5 3F E5 12 C2 16 6C C1 56 3F C0 61 BE 0F 46 E6 5A 3E 11 90 07 19 A0 01 FA 3E BE B7 DC 2B CB 11 E6 3D 8B A0 1E 92 25 41 6B 3D 55 CB F1 69 50 7E 92 3E 20 7B 5B 38 56 EE 21 3E D7 FC 63 7F 4B 98 A9 3D FE 82 2B 65 47 15 47 40 00 00 00 FE 42 2E 96 3F 8E 27 AF E6 3D 47 CF 3D ?? ?? ?? ?? 00 00 00 00 00 00 00 00 7E F8 B9 8F CE 33 86 40 00 00 F0 7F 00 00 30 3E }
	condition:
		$1
}

rule file_223_5_0 {
	meta:
		name = "splitexp"
		size = 260
		refs = "00ec ?two_to_jby32_lead_table@?1??splitexp@@9@9 00f8 ?two_to_jby32_trail_table@?1??splitexp@@9@9"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 2D ED 04 8B 20 EE 02 6B B0 EE 40 8B 15 46 B5 EE C0 6B 0E 46 F1 EE 10 FA B0 EE 44 5B B0 EE 41 9B B6 EE 00 7B 06 DD 36 EE 07 6B BD EE C6 6B 16 EE 10 4A 05 E0 36 EE 47 0B BD EE C0 0B 10 EE 10 4A 00 EE 10 4A 63 42 9F ED 2B 4B 29 4A B8 EE C0 0B 01 EE 10 3A 20 EE 03 0B B8 EE C1 1B 38 EE 40 2B 9F ED 21 3B 1F 4B 04 F0 1F 01 21 EE 05 0B 22 EE 09 6B 20 EE 09 5B 9F ED 19 2B 03 EB C1 03 9F ED 15 0B 02 EB C1 02 35 EE 06 1B 61 1A 01 EE 04 3B 21 EE 01 4B 03 EE 01 0B 92 ED 00 3B 00 EE 01 2B 02 EE 01 7B 93 ED 00 2B 0B 11 01 EB D3 63 07 EE 04 5B 33 EE 02 1B 5B 11 35 EE 06 0B 03 60 86 ED 00 2B 00 EE 01 3B 85 ED 00 3B BD EC 04 8B BD E8 78 88 FE DE 4E 5D 54 55 55 55 A5 3F 7C 8F 54 55 55 55 C5 3F ?? ?? ?? ?? 5E 90 AA B7 15 11 81 3F ?? ?? ?? ?? 65 97 73 8D 72 C1 56 3F }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "ilogbf"
		size = 54
		refs = "0010 _fdunscale"
	strings:
		$1 = { 2D E9 0C 48 0D F1 08 0B 01 A9 68 46 8D ED 01 0A ?? ?? ?? ?? 58 B1 01 28 06 D0 02 28 04 D0 BD F9 00 30 5B 1E 18 B2 04 E0 6F F0 00 40 01 E0 4F F0 00 40 BD E8 0C 88 }
	condition:
		$1
}

rule file_225_5_0 {
	meta:
		name = "_mbsncat_l"
		size = 212
		refs = "0016 _errno 001e _invalid_parameter_noinfo 002e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 003e strncat 0058 _ismbslead_l 0096 _mbsbtype_l"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 85 B0 17 46 00 2F 0E 46 04 46 5B D0 3C B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 24 52 E0 00 2E F5 D0 68 46 19 46 ?? ?? ?? ?? 02 9B 9B 68 33 B9 3A 46 31 46 20 46 ?? ?? ?? ?? 04 46 38 E0 25 46 14 F8 01 3B 00 2B FB D1 64 1E 21 46 01 AA 28 46 ?? ?? ?? ?? 00 B1 64 1E 02 99 16 F8 01 2B 7F 1E 4F F0 00 08 53 18 5B 7E 13 F0 04 0F 16 D0 22 70 33 78 06 F1 01 06 63 70 04 F1 02 04 93 B9 04 F8 02 8C AC 42 11 D0 63 1B 59 1E 01 AA 28 46 ?? ?? ?? ?? 01 28 09 D1 04 F8 01 8C 08 E0 04 F8 01 2B 00 2A EE D0 00 2F D8 D1 EB E7 84 F8 00 80 2C 46 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 05 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_226_1_0 {
	meta:
		name = "cprojf"
		size = 128
		refs = "0012 crealf 0026 cimagf 0030 _fdtest 0074 _FInf_C 007c _FZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 CD ED 03 0A 8D ED 02 0A ?? ?? ?? ?? DD ED 03 0A B0 EE 40 1A 9D ED 02 0A 8D ED 01 1A ?? ?? ?? ?? 01 A8 8D ED 00 0A ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 01 2C 06 D0 01 28 04 D0 9D ED 02 0A DD ED 03 0A 0F E0 BD F8 02 30 13 F4 00 4F 05 D0 08 4B 93 ED 00 0A F1 EE 40 0A 01 E0 DF ED 04 0A 02 4B 93 ED 00 0A 05 B0 BD E8 10 88 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_227_15_0 {
	meta:
		name = "_Getdays_l"
		size = 212
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0022 strlen 003a _malloc_base 005e strcpy_s 0096 _free_base 00c0 _invoke_watson"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 01 46 02 A8 ?? ?? ?? ?? 03 9B 00 26 07 27 D3 F8 9C 80 45 46 55 F8 04 0B ?? ?? ?? ?? 04 46 A8 69 ?? ?? ?? ?? 03 19 33 44 9E 1C 7F 1E F2 D1 70 1C ?? ?? ?? ?? 04 46 0C B9 00 24 26 E0 25 46 00 27 4F F0 3A 09 05 F8 01 9B 58 F8 04 2B 63 1B 33 44 59 1C 28 46 ?? ?? ?? ?? 78 BB 28 46 ?? ?? ?? ?? 05 44 05 F8 01 9B D8 F8 18 20 63 1B 33 44 59 1C 28 46 ?? ?? ?? ?? C8 B9 28 46 ?? ?? ?? ?? 7F 1C 05 44 07 2F DE D3 00 23 2B 70 00 20 ?? ?? ?? ?? 9D F8 14 30 33 B1 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 06 B0 BD E8 F0 8B 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_227_17_0 {
	meta:
		name = "_Getmonths_l"
		size = 220
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0022 strlen 003e _malloc_base 0062 strcpy_s 009e _free_base 00c8 _invoke_watson"
	strings:
		$1 = { 2D E9 F0 4B 0D F1 18 0B 86 B0 01 46 02 A8 ?? ?? ?? ?? 03 9B 00 27 4F F0 0C 08 D3 F8 9C 60 35 46 A8 6B ?? ?? ?? ?? 04 46 A8 6E ?? ?? ?? ?? 03 19 3B 44 9F 1C 2D 1D B8 F1 01 08 F1 D1 78 1C ?? ?? ?? ?? 04 46 0C B9 00 24 28 E0 25 46 4F F0 00 08 4F F0 3A 09 05 F8 01 9B B2 6B 63 1B 3B 44 59 1C 28 46 ?? ?? ?? ?? 88 BB 28 46 ?? ?? ?? ?? 05 44 05 F8 01 9B B2 6E 63 1B 3B 44 59 1C 28 46 ?? ?? ?? ?? E0 B9 28 46 ?? ?? ?? ?? 08 F1 01 08 05 44 36 1D B8 F1 0C 0F DD D3 00 23 2B 70 00 20 ?? ?? ?? ?? 9D F8 14 30 33 B1 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 06 B0 BD E8 F0 8B 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_227_20_0 {
	meta:
		name = "_Strftime_l"
		size = 280
		refs = "0016 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0036 _errno 003e _invalid_parameter_noinfo 0062 __acrt_errno_map_os_error 006c _malloc_base 0098 _free_base 00d0 _Wcsftime_l 010c __imp_GetLastError 0110 __imp_WideCharToMultiByte 0114 __imp_MultiByteToWideChar"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 89 B0 0F 46 13 99 80 46 04 A8 99 46 15 46 ?? ?? ?? ?? 05 9C B8 F1 00 0F D4 F8 14 A0 07 D0 37 B1 00 23 88 F8 00 30 15 B1 B9 F1 00 0F 06 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 10 E0 33 4C 01 93 00 93 24 68 6F F0 00 03 2A 46 00 21 50 46 A0 47 04 46 34 B9 2B 4B 1B 68 98 47 ?? ?? ?? ?? 00 24 18 E0 60 00 ?? ?? ?? ?? 06 46 7E B1 01 94 27 4C 6F F0 00 03 2A 46 24 68 00 21 50 46 00 96 A0 47 B0 B9 20 4B 1B 68 98 47 ?? ?? ?? ?? 00 24 30 46 ?? ?? ?? ?? 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 20 46 09 B0 BD E8 F0 8F 78 00 ?? ?? ?? ?? 05 46 E5 B1 13 9A 4B 46 39 46 01 92 12 9A 00 92 32 46 ?? ?? ?? ?? 90 B1 0E 4C 00 22 03 92 24 68 02 92 D3 43 2A 46 00 21 50 46 01 97 CD F8 00 80 A0 47 48 B9 06 4B 1B 68 98 47 ?? ?? ?? ?? 00 24 28 46 ?? ?? ?? ?? C7 E7 44 1E F9 E7 FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_227_23_0 {
	meta:
		name = "_strftime_l"
		size = 24
		refs = "0010 _Strftime_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 06 9C 01 94 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_493_36_0 {
	meta:
		name = "_wcsftime_l"
		size = 24
		refs = "0010 _Wcsftime_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 06 9C 01 94 00 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_227_24_0 {
	meta:
		name = "strftime"
		size = 22
		refs = "000e _Strftime_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 01 94 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_493_37_0 {
	meta:
		name = "wcsftime"
		size = 22
		refs = "000e _Wcsftime_l"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 00 24 01 94 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "?get_terminate_or_default@@YAP6AXXZQBU__acrt_ptd@@@Z"
		size = 20
		refs = "0010 abort"
	strings:
		$1 = { 2D E9 00 48 EB 46 C0 68 00 B9 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_228_1_0 {
	meta:
		name = "_get_terminate"
		size = 24
		refs = "0006 __acrt_getptd 0014 abort"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? C0 68 00 B9 01 48 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_228_2_0 {
	meta:
		name = "set_terminate"
		size = 32
		refs = "000a __acrt_getptd 001c abort"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 03 46 D8 68 00 B9 01 48 DC 60 BD E8 18 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_228_3_0 {
	meta:
		name = "terminate"
		size = 40
		refs = "000a __acrt_getptd 001c abort 0024 __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 90 48 0D F1 08 0B 6F 46 ?? ?? ?? ?? C4 68 24 B1 20 46 03 4B 1B 68 98 47 A0 47 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "strtok"
		size = 32
		refs = "000c __acrt_getptd 0018 __acrt_strtok_s_novalidation"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 0C 46 05 46 ?? ?? ?? ?? 00 F1 1C 02 28 46 21 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "?xcptlookup@@YAPAU__crt_signal_action_t@@KQAU1@@Z"
		size = 36
	strings:
		$1 = { 2D E9 00 48 EB 46 01 F1 90 02 03 E0 51 F8 0C 3B 83 42 04 D0 91 42 F9 D1 00 20 BD E8 00 88 A1 F1 0C 00 FA E7 }
	condition:
		$1
}

rule file_232_1_0 {
	meta:
		name = "_seh_filter_dll"
		size = 36
		refs = "0016 _seh_filter_exe"
	strings:
		$1 = { 2D E9 00 48 EB 46 06 4B 98 42 01 D0 00 20 04 E0 18 46 BD E8 00 48 ?? ?? ?? ?? BD E8 00 88 FE DE 63 73 6D E0 }
	condition:
		$1
}

rule file_232_2_0 {
	meta:
		name = "_seh_filter_exe"
		size = 300
		refs = "000c __acrt_getptd_noexit 0104 __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 0F 46 04 46 ?? ?? ?? ?? 05 46 0D B9 00 20 73 E0 29 68 01 F1 90 00 81 42 0A 46 05 D0 52 F8 0C 3B A3 42 0D D0 82 42 F9 D1 00 23 00 2B EE D0 9E 68 00 2E EB D0 05 2E 06 D1 00 22 9A 60 01 20 5B E0 A2 F1 0C 03 F1 E7 01 2E 54 D0 D5 F8 04 80 6F 60 5C 68 08 2C 44 D1 01 F1 24 02 02 F1 6C 01 8A 42 04 D0 00 20 90 60 0C 32 8A 42 FB D1 1A 68 2C 4B AF 68 9A 42 16 D8 13 D0 28 4B 9A 42 0E D0 26 4B 9A 42 09 D0 23 4B 9A 42 04 D0 21 4B 9A 42 1D D1 81 23 1A E0 86 23 18 E0 83 23 16 E0 82 23 14 E0 84 23 12 E0 19 4B 9A 42 0E D0 17 4B 9A 42 09 D0 14 4B 9A 42 04 D0 12 4B 9A 42 07 D1 8D 23 04 E0 8E 23 02 E0 85 23 00 E0 8A 23 AB 60 0B 4B AC 68 30 46 1B 68 98 47 08 20 21 46 B0 47 AF 60 07 E0 00 22 9A 60 05 4B 30 46 1B 68 98 47 20 46 B0 47 C5 F8 04 80 6F F0 00 00 BD E8 F8 89 ?? ?? ?? ?? B5 02 00 C0 B4 02 00 C0 93 00 00 C0 92 00 00 C0 90 00 00 C0 8F 00 00 C0 8E 00 00 C0 8D 00 00 C0 91 00 00 C0 }
	condition:
		$1
}

rule file_233_1_0 {
	meta:
		name = "wmemmove_s"
		size = 74
		refs = "000e _errno 0016 _invalid_parameter_noinfo 003e memmove"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 14 46 D3 B1 38 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 24 12 E0 1C B9 ?? ?? ?? ?? 16 24 04 E0 99 42 06 D2 ?? ?? ?? ?? 22 24 04 60 ?? ?? ?? ?? 04 E0 5A 00 21 46 ?? ?? ?? ?? 00 24 20 46 BD E8 18 88 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "ldexp"
		size = 340
		refs = "001e _ctrlfp 0036 _sptype 0052 _handle_qnan2 007e _decomp 00b8 _set_exp 0110 _copysign 012a _except2 0140 _d_inf"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 2D ED 02 8B 84 B0 4D 49 04 46 4F F4 1F 40 B0 EE 40 8B 8D ED 02 0B ?? ?? ?? ?? BD F8 0E 30 47 F6 F0 72 05 46 13 40 93 42 1D D1 B0 EE 48 0B ?? ?? ?? ?? 00 28 0C DD 02 28 5C DD 03 28 08 D1 01 EE 10 4A B0 EE 48 0B B8 EE C1 1B ?? ?? ?? ?? 6A E0 00 EE 10 4A B7 EE 00 2B 19 21 B8 EE C0 1B 32 EE 08 2B 08 20 5A E0 B5 EE 40 8B F1 EE 10 FA 41 D0 68 46 B0 EE 48 0B ?? ?? ?? ?? 00 9A B0 EE 40 3B 00 2C 05 DA 4F F0 00 43 1B 1B 9A 42 16 DB 04 E0 6F F0 00 43 1B 1B 9A 42 31 DC 10 19 B0 F5 20 6F 2D DC B0 F5 80 6F 06 DD A0 F5 C0 60 B0 EE 43 0B ?? ?? ?? ?? 2A E0 24 4B 98 42 0A DA 9F ED 20 2B 00 EE 10 4A 19 21 23 EE 02 2B B8 EE C0 1B 12 20 24 E0 6F F4 7F 73 98 42 B0 EE 43 0B 06 DA 00 F5 C0 60 ?? ?? ?? ?? 19 21 12 20 11 E0 ?? ?? ?? ?? B0 EE 40 8B 11 49 28 46 ?? ?? ?? ?? 15 E0 0E 4B B0 EE 43 1B 93 ED 00 0B ?? ?? ?? ?? 19 21 11 20 01 EE 10 4A B0 EE 40 2B B8 EE C1 1B 2A 46 B0 EE 48 0B ?? ?? ?? ?? B0 EE 40 8B B0 EE 48 0B 04 B0 BD EC 02 8B BD E8 30 88 ?? ?? ?? ?? 00 9F C0 03 00 00 00 00 00 00 00 00 03 F6 FF FF }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "_lrotl"
		size = 30
		altNames = "_rotl"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 F0 1F 01 C1 F1 20 03 20 FA 03 F2 00 FA 01 F3 42 EA 03 00 BD E8 00 88 }
	condition:
		$1
}

rule file_235_2_0 {
	meta:
		name = "_rotl64"
		size = 88
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 02 F0 3F 06 C6 F1 40 04 C4 F1 20 03 01 FA 03 F3 20 FA 04 F2 1A 43 A4 F1 20 03 21 FA 03 F3 42 EA 03 05 C6 F1 20 03 20 FA 03 F3 01 FA 06 F2 21 FA 04 F4 42 EA 03 01 A6 F1 20 03 00 FA 03 F3 0B 43 00 FA 06 F2 44 EA 03 01 45 EA 02 00 BD E8 78 88 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "cabs"
		size = 58
		refs = "0014 cimag 0024 creal 002c hypot"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_540_0_0 {
	meta:
		name = "cabsl"
		size = 58
		refs = "0014 cimagl 0024 creall 002c _hypot"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 84 B0 8D ED 02 1B 8D ED 00 0B ?? ?? ?? ?? 9D ED 02 1B B0 EE 40 8B 9D ED 00 0B ?? ?? ?? ?? B0 EE 48 1B ?? ?? ?? ?? 04 B0 BD EC 02 8B BD E8 00 88 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "llrint"
		size = 140
		refs = "0012 _dtest 0024 nearbyint 003c _fperrraise 0060 __dtoi64"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 28 D0 01 DD 02 28 22 DD 9D ED 00 0B ?? ?? ?? ?? 9D ED 00 2B B0 EE 40 8B B4 EE 42 0B F1 EE 10 FA 02 D0 20 20 ?? ?? ?? ?? 9F ED 10 2B B4 EE C8 2B F1 EE 10 FA 0B D8 9F ED 0B 2B B4 EE C2 8B F1 EE 10 FA 04 D8 B0 EE 48 0B ?? ?? ?? ?? 04 E0 01 20 ?? ?? ?? ?? 00 20 00 21 02 B0 BD EC 02 8B BD E8 00 88 FE DE 00 00 00 00 00 00 E0 43 00 00 00 00 00 00 E0 C3 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "llrintl"
		size = 140
		refs = "0012 _ldtest 0024 nearbyintl 003c _fperrraise 0060 __dtoi64"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 02 8B 82 B0 68 46 8D ED 00 0B ?? ?? ?? ?? 00 28 28 D0 01 DD 02 28 22 DD 9D ED 00 0B ?? ?? ?? ?? 9D ED 00 2B B0 EE 40 8B B4 EE 42 0B F1 EE 10 FA 02 D0 20 20 ?? ?? ?? ?? 9F ED 10 2B B4 EE C8 2B F1 EE 10 FA 0B D8 9F ED 0B 2B B4 EE C2 8B F1 EE 10 FA 04 D8 B0 EE 48 0B ?? ?? ?? ?? 04 E0 01 20 ?? ?? ?? ?? 00 20 00 21 02 B0 BD EC 02 8B BD E8 00 88 FE DE 00 00 00 00 00 00 E0 43 00 00 00 00 00 00 E0 C3 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "strpbrk"
		size = 116
		refs = "0008 __security_push_cookie 0066 __security_pop_cookie 006e __report_rangecheckfailure"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? 88 B0 0C 46 00 23 00 21 6A 46 20 2B 29 D2 99 54 5B 1C 20 2B FA DB 23 78 6B B1 6D 46 01 26 D9 08 03 F0 07 03 06 FA 03 F2 4B 5D 13 43 4B 55 14 F8 01 3F 00 2B F3 D1 01 78 69 B1 01 25 6C 46 01 F0 07 03 05 FA 03 F2 CB 08 1B 5D 1A 42 04 D1 10 F8 01 1F 00 29 F3 D1 00 20 08 B0 ?? ?? ?? ?? BD E8 70 88 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "nexttowardf"
		size = 290
		refs = "0014 _fdtest 0020 _ldtest 00d0 _fperrraise"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 68 46 8D ED 02 1B 8D ED 00 0A ?? ?? ?? ?? 04 46 02 2C 5A D0 02 A8 ?? ?? ?? ?? 9D ED 02 2B 02 28 73 D0 9D ED 00 1A B7 EE C1 0A B4 EE 42 0B F1 EE 10 FA 6A D0 01 2C 0E D1 BD F8 02 30 03 F4 00 42 47 F6 7F 73 13 43 9A B2 4F F6 FF 73 AD F8 02 20 AD F8 00 30 3B E0 B7 EE C1 0A 5C B9 B4 EE C2 0B F1 EE 10 FA 38 BF 00 23 01 D3 4F F4 00 43 9A B2 01 23 EB E7 B4 EE C2 0B F1 EE 10 FA 04 D2 B5 EE C0 1A F1 EE 10 FA 0B DC B7 EE C1 0A B4 EE C0 2B F1 EE 10 FA 28 D2 B5 EE C0 1A F1 EE 10 FA 23 D2 BD F8 00 30 5B 1C 9B B2 AD F8 00 30 6B B9 BD F8 02 30 5B 1C 9A B2 22 F4 00 43 B3 F5 FF 4F AD F8 02 20 04 D1 08 20 ?? ?? ?? ?? BD F8 02 20 9D ED 00 0A 12 F4 FF 4F 04 D1 10 20 ?? ?? ?? ?? 9D ED 00 0A 05 B0 BD E8 10 88 BD F8 00 30 4F F6 FF 72 13 44 9B B2 AD F8 00 30 93 42 E6 D1 BD F8 02 30 13 44 9A B2 AD F8 02 20 E1 E7 B7 EE C2 0B 8D ED 00 0A BD F8 02 20 DC E7 }
	condition:
		$1
}

rule file_240_1_0 {
	meta:
		name = "??$common_find_first_narrow@U_wfinddata32_t@@U_finddata32_t@@@@YAHQBDQAU_finddata32_t@@@Z"
		size = 100
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 002c __acrt_copy_path_to_wide_string 0036 ??$common_find_first_wide@U_wfinddata32_t@@@@YAHQB_WQAU_wfinddata32_t@@@Z 0046 ??$copy_wide_to_narrow_find_data@U_wfinddata32_t@@U_finddata32_t@@@@YA_NABU_wfinddata32_t@@AAU_finddata32_t@@@Z 0052 _free_base 005c __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 09 7D 0D 46 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 17 E0 00 23 69 46 00 93 ?? ?? ?? ?? 60 B1 00 98 02 A9 ?? ?? ?? ?? 04 46 10 F1 01 0F 04 D0 02 A8 29 46 ?? ?? ?? ?? 08 B9 6F F0 00 04 00 98 ?? ?? ?? ?? 20 46 0D F5 09 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_240_2_0 {
	meta:
		name = "??$common_find_first_narrow@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YAHQBDQAU_finddata32i64_t@@@Z"
		size = 100
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 002c __acrt_copy_path_to_wide_string 0036 ??$common_find_first_wide@U_wfinddata32i64_t@@@@YAHQB_WQAU_wfinddata32i64_t@@@Z 0046 ??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z 0052 _free_base 005c __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 0B 7D 0D 46 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 17 E0 00 23 69 46 00 93 ?? ?? ?? ?? 60 B1 00 98 02 A9 ?? ?? ?? ?? 04 46 10 F1 01 0F 04 D0 02 A8 29 46 ?? ?? ?? ?? 08 B9 6F F0 00 04 00 98 ?? ?? ?? ?? 20 46 0D F5 0B 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_240_3_0 {
	meta:
		name = "??$common_find_first_narrow@U_wfinddata64_t@@U__finddata64_t@@@@YAHQBDQAU__finddata64_t@@@Z"
		size = 100
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 002c __acrt_copy_path_to_wide_string 0036 ??$common_find_first_wide@U_wfinddata64_t@@@@YAHQB_WQAU_wfinddata64_t@@@Z 0046 ??$copy_wide_to_narrow_find_data@U_wfinddata64_t@@U__finddata64_t@@@@YA_NABU_wfinddata64_t@@AAU__finddata64_t@@@Z 0052 _free_base 005c __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 0F 7D 0D 46 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 17 E0 00 23 69 46 00 93 ?? ?? ?? ?? 60 B1 00 98 02 A9 ?? ?? ?? ?? 04 46 10 F1 01 0F 04 D0 02 A8 29 46 ?? ?? ?? ?? 08 B9 6F F0 00 04 00 98 ?? ?? ?? ?? 20 46 0D F5 0F 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_240_4_0 {
	meta:
		name = "??$common_find_first_narrow@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YAHQBDQAU_finddata64i32_t@@@Z"
		size = 100
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 002c __acrt_copy_path_to_wide_string 0036 ??$common_find_first_wide@U_wfinddata64i32_t@@@@YAHQB_WQAU_wfinddata64i32_t@@@Z 0046 ??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z 0052 _free_base 005c __security_pop_cookie"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 0F 7D 0D 46 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 17 E0 00 23 69 46 00 93 ?? ?? ?? ?? 60 B1 00 98 02 A9 ?? ?? ?? ?? 04 46 10 F1 01 0F 04 D0 02 A8 29 46 ?? ?? ?? ?? 08 B9 6F F0 00 04 00 98 ?? ?? ?? ?? 20 46 0D F5 0F 7D ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_240_5_0 {
	meta:
		name = "??$common_find_first_wide@U_wfinddata32_t@@@@YAHQB_WQAU_wfinddata32_t@@@Z"
		size = 212
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 0080 ??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z 00a4 wcscpy_s 00b2 __security_pop_cookie 00c4 _invoke_watson 00cc __imp_GetLastError 00d0 __imp_FindFirstFileExW"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? AD F5 17 7D 0D 46 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 42 E0 00 28 F4 D0 29 4C 00 27 00 23 24 68 02 AA 00 21 01 97 00 97 A0 47 06 46 FC 43 A6 42 17 D1 21 4B 1B 68 98 47 02 28 05 D3 03 28 0C D9 08 28 06 D0 12 28 08 D0 ?? ?? ?? ?? 16 23 03 60 23 E0 ?? ?? ?? ?? 0C 23 F9 E7 ?? ?? ?? ?? 02 23 F5 E7 02 9B 80 2B 08 BF 00 23 03 A8 2B 60 ?? ?? ?? ?? 68 60 05 A8 ?? ?? ?? ?? A8 60 07 A8 ?? ?? ?? ?? 0A 9B C5 E9 03 03 0D AA 05 F1 14 00 4F F4 82 71 ?? ?? ?? ?? 38 B9 34 46 20 46 0D F5 17 7D ?? ?? ?? ?? BD E8 F0 88 00 23 00 22 00 21 00 20 00 97 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_6_0 {
	meta:
		name = "??$common_find_first_wide@U_wfinddata32i64_t@@@@YAHQB_WQAU_wfinddata32i64_t@@@Z"
		size = 216
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 0080 ??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z 00a8 wcscpy_s 00b6 __security_pop_cookie 00c8 _invoke_watson 00d0 __imp_GetLastError 00d4 __imp_FindFirstFileExW"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? AD F5 17 7D 0D 46 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 44 E0 00 28 F4 D0 2A 4C 00 27 00 23 24 68 02 AA 00 21 01 97 00 97 A0 47 06 46 FC 43 A6 42 17 D1 22 4B 1B 68 98 47 02 28 05 D3 03 28 0C D9 08 28 06 D0 12 28 08 D0 ?? ?? ?? ?? 16 23 03 60 25 E0 ?? ?? ?? ?? 0C 23 F9 E7 ?? ?? ?? ?? 02 23 F5 E7 02 9B 80 2B 08 BF 00 23 03 A8 2B 60 ?? ?? ?? ?? 68 60 05 A8 ?? ?? ?? ?? A8 60 07 A8 ?? ?? ?? ?? DD E9 09 23 C5 E9 03 03 05 F1 18 00 6A 61 0D AA 4F F4 82 71 ?? ?? ?? ?? 38 B9 34 46 20 46 0D F5 17 7D ?? ?? ?? ?? BD E8 F0 88 00 23 00 22 00 21 00 20 00 97 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_7_0 {
	meta:
		name = "??$common_find_first_wide@U_wfinddata64_t@@@@YAHQB_WQAU_wfinddata64_t@@@Z"
		size = 220
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 0080 ??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z 00ae wcscpy_s 00bc __security_pop_cookie 00ce _invoke_watson 00d4 __imp_GetLastError 00d8 __imp_FindFirstFileExW"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? AD F5 17 7D 0D 46 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 47 E0 00 28 F4 D0 2B 4C 00 27 00 23 24 68 02 AA 00 21 01 97 00 97 A0 47 06 46 FC 43 A6 42 17 D1 23 4B 1B 68 98 47 02 28 05 D3 03 28 0C D9 08 28 06 D0 12 28 08 D0 ?? ?? ?? ?? 16 23 03 60 28 E0 ?? ?? ?? ?? 0C 23 F9 E7 ?? ?? ?? ?? 02 23 F5 E7 02 9B 80 2B 08 BF 00 23 03 A8 2B 60 ?? ?? ?? ?? C5 E9 02 01 05 A8 ?? ?? ?? ?? C5 E9 04 01 07 A8 ?? ?? ?? ?? DD E9 09 23 C5 E9 06 01 05 F1 28 00 C5 E9 08 32 0D AA 4F F4 82 71 ?? ?? ?? ?? 38 B9 34 46 20 46 0D F5 17 7D ?? ?? ?? ?? BD E8 F0 88 00 23 00 22 00 21 00 20 00 97 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_8_0 {
	meta:
		name = "??$common_find_first_wide@U_wfinddata64i32_t@@@@YAHQB_WQAU_wfinddata64i32_t@@@Z"
		size = 216
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 0080 ??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z 00aa wcscpy_s 00b8 __security_pop_cookie 00ca _invoke_watson 00d0 __imp_GetLastError 00d4 __imp_FindFirstFileExW"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B ?? ?? ?? ?? AD F5 17 7D 0D 46 45 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 45 E0 00 28 F4 D0 2A 4C 00 27 00 23 24 68 02 AA 00 21 01 97 00 97 A0 47 06 46 FC 43 A6 42 17 D1 22 4B 1B 68 98 47 02 28 05 D3 03 28 0C D9 08 28 06 D0 12 28 08 D0 ?? ?? ?? ?? 16 23 03 60 26 E0 ?? ?? ?? ?? 0C 23 F9 E7 ?? ?? ?? ?? 02 23 F5 E7 02 9B 80 2B 08 BF 00 23 03 A8 2B 60 ?? ?? ?? ?? C5 E9 02 01 05 A8 ?? ?? ?? ?? C5 E9 04 01 07 A8 ?? ?? ?? ?? 0A 9B C5 E9 06 01 0D AA 05 F1 24 00 4F F4 82 71 2B 62 ?? ?? ?? ?? 38 B9 34 46 20 46 0D F5 17 7D ?? ?? ?? ?? BD E8 F0 88 00 23 00 22 00 21 00 20 00 97 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_9_0 {
	meta:
		name = "??$common_find_next_narrow@U_wfinddata32_t@@U_finddata32_t@@@@YAHHQAU_finddata32_t@@@Z"
		size = 60
		refs = "0008 __security_push_cookie 0014 ??$common_find_next_wide@U_wfinddata32_t@@@@YAHHQAU_wfinddata32_t@@@Z 0026 ??$copy_wide_to_narrow_find_data@U_wfinddata32_t@@U_finddata32_t@@@@YA_NABU_wfinddata32_t@@AAU_finddata32_t@@@Z 0034 __security_pop_cookie"
		altNames = "_findnext32"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 08 7D 0E 46 69 46 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 05 D0 68 46 31 46 ?? ?? ?? ?? 00 B1 2C 46 20 46 0D F5 08 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_10_0 {
	meta:
		name = "??$common_find_next_narrow@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YAHHQAU_finddata32i64_t@@@Z"
		size = 60
		refs = "0008 __security_push_cookie 0014 ??$common_find_next_wide@U_wfinddata32i64_t@@@@YAHHQAU_wfinddata32i64_t@@@Z 0026 ??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z 0034 __security_pop_cookie"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 08 7D 0E 46 69 46 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 05 D0 68 46 31 46 ?? ?? ?? ?? 00 B1 2C 46 20 46 0D F5 08 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_38_0 {
	meta:
		name = "_findnext32i64"
		size = 60
		refs = "0008 __security_push_cookie 0014 ??$common_find_next_wide@U_wfinddata32i64_t@@@@YAHHQAU_wfinddata32i64_t@@@Z 0026 ??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z 0034 __security_pop_cookie"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 08 7D 0E 46 69 46 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 05 D0 68 46 31 46 ?? ?? ?? ?? 00 B1 2C 46 20 46 0D F5 08 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_11_0 {
	meta:
		name = "??$common_find_next_narrow@U_wfinddata64_t@@U__finddata64_t@@@@YAHHQAU__finddata64_t@@@Z"
		size = 60
		refs = "0008 __security_push_cookie 0014 ??$common_find_next_wide@U_wfinddata64_t@@@@YAHHQAU_wfinddata64_t@@@Z 0026 ??$copy_wide_to_narrow_find_data@U_wfinddata64_t@@U__finddata64_t@@@@YA_NABU_wfinddata64_t@@AAU__finddata64_t@@@Z 0034 __security_pop_cookie"
		altNames = "_findnext64"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 0C 7D 0E 46 69 46 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 05 D0 68 46 31 46 ?? ?? ?? ?? 00 B1 2C 46 20 46 0D F5 0C 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_12_0 {
	meta:
		name = "??$common_find_next_narrow@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YAHHQAU_finddata64i32_t@@@Z"
		size = 60
		refs = "0008 __security_push_cookie 0014 ??$common_find_next_wide@U_wfinddata64i32_t@@@@YAHHQAU_wfinddata64i32_t@@@Z 0026 ??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z 0034 __security_pop_cookie"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 0C 7D 0E 46 69 46 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 05 D0 68 46 31 46 ?? ?? ?? ?? 00 B1 2C 46 20 46 0D F5 0C 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_40_0 {
	meta:
		name = "_findnext64i32"
		size = 60
		refs = "0008 __security_push_cookie 0014 ??$common_find_next_wide@U_wfinddata64i32_t@@@@YAHHQAU_wfinddata64i32_t@@@Z 0026 ??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z 0034 __security_pop_cookie"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 0C 7D 0E 46 69 46 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 05 D0 68 46 31 46 ?? ?? ?? ?? 00 B1 2C 46 20 46 0D F5 0C 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_13_0 {
	meta:
		name = "??$common_find_next_wide@U_wfinddata32_t@@@@YAHHQAU_wfinddata32_t@@@Z"
		size = 216
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 0086 ??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z 00aa wcscpy_s 00b8 __security_pop_cookie 00ca _invoke_watson 00d0 __imp_GetLastError 00d4 __imp_FindNextFileW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 17 7D 0D 46 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 45 E0 6F F0 00 04 A0 42 06 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 3A E0 00 2D F6 D0 24 4B 02 A9 1B 68 98 47 B8 B9 21 4B 1B 68 98 47 02 28 05 D3 03 28 0C D9 08 28 06 D0 12 28 08 D0 ?? ?? ?? ?? 16 23 03 60 23 E0 ?? ?? ?? ?? 0C 23 F9 E7 ?? ?? ?? ?? 02 23 F5 E7 02 9B 80 2B 08 BF 00 23 03 A8 2B 60 ?? ?? ?? ?? 68 60 05 A8 ?? ?? ?? ?? A8 60 07 A8 ?? ?? ?? ?? 0A 9B C5 E9 03 03 0D AA 05 F1 14 00 4F F4 82 71 ?? ?? ?? ?? 38 B9 00 24 20 46 0D F5 17 7D ?? ?? ?? ?? BD E8 30 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_14_0 {
	meta:
		name = "??$common_find_next_wide@U_wfinddata32i64_t@@@@YAHHQAU_wfinddata32i64_t@@@Z"
		size = 220
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 0086 ??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z 00ae wcscpy_s 00bc __security_pop_cookie 00ce _invoke_watson 00d4 __imp_GetLastError 00d8 __imp_FindNextFileW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 17 7D 0D 46 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 47 E0 6F F0 00 04 A0 42 06 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 3C E0 00 2D F6 D0 25 4B 02 A9 1B 68 98 47 B8 B9 22 4B 1B 68 98 47 02 28 05 D3 03 28 0C D9 08 28 06 D0 12 28 08 D0 ?? ?? ?? ?? 16 23 03 60 25 E0 ?? ?? ?? ?? 0C 23 F9 E7 ?? ?? ?? ?? 02 23 F5 E7 02 9B 80 2B 08 BF 00 23 03 A8 2B 60 ?? ?? ?? ?? 68 60 05 A8 ?? ?? ?? ?? A8 60 07 A8 ?? ?? ?? ?? DD E9 09 23 C5 E9 03 03 05 F1 18 00 6A 61 0D AA 4F F4 82 71 ?? ?? ?? ?? 38 B9 00 24 20 46 0D F5 17 7D ?? ?? ?? ?? BD E8 30 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_15_0 {
	meta:
		name = "??$common_find_next_wide@U_wfinddata64_t@@@@YAHHQAU_wfinddata64_t@@@Z"
		size = 228
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 0086 ??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z 00b4 wcscpy_s 00c2 __security_pop_cookie 00d4 _invoke_watson 00dc __imp_GetLastError 00e0 __imp_FindNextFileW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 17 7D 0D 46 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 4A E0 6F F0 00 04 A0 42 06 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 3F E0 00 2D F6 D0 27 4B 02 A9 1B 68 98 47 B8 B9 24 4B 1B 68 98 47 02 28 05 D3 03 28 0C D9 08 28 06 D0 12 28 08 D0 ?? ?? ?? ?? 16 23 03 60 28 E0 ?? ?? ?? ?? 0C 23 F9 E7 ?? ?? ?? ?? 02 23 F5 E7 02 9B 80 2B 08 BF 00 23 03 A8 2B 60 ?? ?? ?? ?? C5 E9 02 01 05 A8 ?? ?? ?? ?? C5 E9 04 01 07 A8 ?? ?? ?? ?? DD E9 09 23 C5 E9 06 01 05 F1 28 00 C5 E9 08 32 0D AA 4F F4 82 71 ?? ?? ?? ?? 38 B9 00 24 20 46 0D F5 17 7D ?? ?? ?? ?? BD E8 30 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_16_0 {
	meta:
		name = "??$common_find_next_wide@U_wfinddata64i32_t@@@@YAHHQAU_wfinddata64i32_t@@@Z"
		size = 224
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 0086 ??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z 00b0 wcscpy_s 00be __security_pop_cookie 00d0 _invoke_watson 00d8 __imp_GetLastError 00dc __imp_FindNextFileW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 17 7D 0D 46 40 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 48 E0 6F F0 00 04 A0 42 06 D1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 3D E0 00 2D F6 D0 26 4B 02 A9 1B 68 98 47 B8 B9 23 4B 1B 68 98 47 02 28 05 D3 03 28 0C D9 08 28 06 D0 12 28 08 D0 ?? ?? ?? ?? 16 23 03 60 26 E0 ?? ?? ?? ?? 0C 23 F9 E7 ?? ?? ?? ?? 02 23 F5 E7 02 9B 80 2B 08 BF 00 23 03 A8 2B 60 ?? ?? ?? ?? C5 E9 02 01 05 A8 ?? ?? ?? ?? C5 E9 04 01 07 A8 ?? ?? ?? ?? 0A 9B C5 E9 06 01 0D AA 05 F1 24 00 4F F4 82 71 2B 62 ?? ?? ?? ?? 38 B9 00 24 20 46 0D F5 17 7D ?? ?? ?? ?? BD E8 30 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_18_0 {
	meta:
		name = "??$convert_file_size_to_integer@_J@@YA_JKK@Z"
		size = 16
	strings:
		$1 = { 2D E9 00 48 EB 46 0B 46 01 46 18 46 BD E8 00 88 }
	condition:
		$1
}

rule file_240_19_0 {
	meta:
		name = "??$convert_file_time_to_time_t@J@@YAJABU_FILETIME@@@Z"
		size = 112
		refs = "0006 __security_push_cookie 0058 __loctotime32_t 005e __security_pop_cookie 0068 __imp_SystemTimeToTzSpecificLocalTime 006c __imp_FileTimeToSystemTime"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 8D B0 03 68 23 B9 43 68 13 B9 6F F0 00 00 20 E0 14 4B 08 A9 1B 68 98 47 00 28 F6 D0 10 4B 04 AA 08 A9 1B 68 00 20 98 47 00 28 EE D0 6F F0 00 03 02 93 BD F8 1C 30 BD F8 16 20 BD F8 12 10 01 93 BD F8 1A 30 BD F8 10 00 00 93 BD F8 18 30 ?? ?? ?? ?? 0D B0 ?? ?? ?? ?? BD E8 00 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_20_0 {
	meta:
		name = "??$convert_file_time_to_time_t@_J@@YA_JABU_FILETIME@@@Z"
		size = 112
		refs = "0006 __security_push_cookie 005a __loctotime64_t 0060 __security_pop_cookie 0068 __imp_SystemTimeToTzSpecificLocalTime 006c __imp_FileTimeToSystemTime"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 8D B0 03 68 2B B9 43 68 1B B9 6F F0 00 01 08 46 20 E0 13 4B 08 A9 1B 68 98 47 00 28 F5 D0 0F 4B 04 AA 08 A9 1B 68 00 20 98 47 00 28 ED D0 6F F0 00 03 02 93 BD F8 1C 30 BD F8 16 20 BD F8 12 10 01 93 BD F8 1A 30 BD F8 10 00 00 93 BD F8 18 30 ?? ?? ?? ?? 0D B0 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_21_0 {
	meta:
		name = "??$convert_system_time_to_time_t@J@@YAJABU_SYSTEMTIME@@@Z"
		size = 40
		refs = "001e __loctotime32_t"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 6F F0 00 03 02 93 83 89 C2 88 41 88 01 93 43 89 00 93 03 89 00 88 ?? ?? ?? ?? 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_240_22_0 {
	meta:
		name = "??$convert_system_time_to_time_t@_J@@YA_JABU_SYSTEMTIME@@@Z"
		size = 40
		refs = "001e __loctotime64_t"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 6F F0 00 03 02 93 83 89 C2 88 41 88 01 93 43 89 00 93 03 89 00 88 ?? ?? ?? ?? 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_240_23_0 {
	meta:
		name = "??$copy_wide_to_narrow_find_data@U_wfinddata32_t@@U_finddata32_t@@@@YA_NABU_wfinddata32_t@@AAU_finddata32_t@@@Z"
		size = 96
		refs = "0014 __acrt_copy_to_char 0028 strcpy_s 0030 _free_base 005a _invoke_watson"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 00 23 02 A9 14 30 02 93 ?? ?? ?? ?? 08 B9 00 20 15 E0 02 9A 04 F1 14 00 4F F4 82 71 ?? ?? ?? ?? 80 B9 02 98 ?? ?? ?? ?? 2B 68 01 20 23 60 6B 68 63 60 AB 68 A3 60 EB 68 E3 60 2B 69 23 61 04 B0 BD E8 30 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_240_24_0 {
	meta:
		name = "??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z"
		size = 100
		refs = "0014 __acrt_copy_to_char 0028 strcpy_s 0030 _free_base 005e _invoke_watson"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 00 23 02 A9 18 30 02 93 ?? ?? ?? ?? 08 B9 00 20 17 E0 02 9A 04 F1 18 00 4F F4 82 71 ?? ?? ?? ?? 90 B9 02 98 ?? ?? ?? ?? 2B 68 01 20 23 60 6B 68 63 60 AB 68 A3 60 EB 68 E3 60 2B 69 23 61 6B 69 63 61 04 B0 BD E8 30 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_240_25_0 {
	meta:
		name = "??$copy_wide_to_narrow_find_data@U_wfinddata64_t@@U__finddata64_t@@@@YA_NABU_wfinddata64_t@@AAU__finddata64_t@@@Z"
		size = 112
		refs = "0014 __acrt_copy_to_char 0028 strcpy_s 0030 _free_base 006a _invoke_watson"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 00 23 02 A9 28 30 02 93 ?? ?? ?? ?? 08 B9 00 20 1D E0 02 9A 04 F1 28 00 4F F4 82 71 ?? ?? ?? ?? C0 B9 02 98 ?? ?? ?? ?? 2B 68 01 20 23 60 AB 68 A3 60 EB 68 E3 60 2B 69 23 61 6B 69 63 61 AB 69 A3 61 EB 69 E3 61 2B 6A 23 62 6B 6A 63 62 04 B0 BD E8 30 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_240_26_0 {
	meta:
		name = "??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z"
		size = 108
		refs = "0014 __acrt_copy_to_char 0028 strcpy_s 0030 _free_base 0066 _invoke_watson"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 00 23 02 A9 24 30 02 93 ?? ?? ?? ?? 08 B9 00 20 1B E0 02 9A 04 F1 24 00 4F F4 82 71 ?? ?? ?? ?? B0 B9 02 98 ?? ?? ?? ?? 2B 68 01 20 23 60 AB 68 A3 60 EB 68 E3 60 2B 69 23 61 6B 69 63 61 AB 69 A3 61 EB 69 E3 61 2B 6A 23 62 04 B0 BD E8 30 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_240_32_0 {
	meta:
		name = "_findclose"
		size = 40
		refs = "000e _errno 0024 __imp_FindClose"
	strings:
		$1 = { 2D E9 00 48 EB 46 07 4B 1B 68 98 47 30 B9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 00 00 E0 00 20 BD E8 00 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_33_0 {
	meta:
		name = "_findfirst32"
		size = 118
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 002c __acrt_copy_path_to_wide_string 0036 _free_base 003e ??$common_find_first_wide@U_wfinddata32_t@@@@YAHQB_WQAU_wfinddata32_t@@@Z 0058 ??$copy_wide_to_narrow_find_data@U_wfinddata32_t@@U_finddata32_t@@@@YA_NABU_wfinddata32_t@@AAU_finddata32_t@@@Z 006e __security_pop_cookie"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 0A 7D 0E 46 46 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 20 E0 00 23 69 46 00 93 ?? ?? ?? ?? 00 28 00 98 02 D1 ?? ?? ?? ?? F1 E7 02 A9 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 03 D1 00 98 ?? ?? ?? ?? 09 E0 02 A8 31 46 ?? ?? ?? ?? 00 28 00 98 F5 D0 ?? ?? ?? ?? 2C 46 20 46 0D F5 0A 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_34_0 {
	meta:
		name = "_findfirst32i64"
		size = 118
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 002c __acrt_copy_path_to_wide_string 0036 _free_base 003e ??$common_find_first_wide@U_wfinddata32i64_t@@@@YAHQB_WQAU_wfinddata32i64_t@@@Z 0058 ??$copy_wide_to_narrow_find_data@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YA_NABU_wfinddata32i64_t@@AAU_finddata32i64_t@@@Z 006e __security_pop_cookie"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 0A 7D 0E 46 46 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 20 E0 00 23 69 46 00 93 ?? ?? ?? ?? 00 28 00 98 02 D1 ?? ?? ?? ?? F1 E7 02 A9 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 03 D1 00 98 ?? ?? ?? ?? 09 E0 02 A8 31 46 ?? ?? ?? ?? 00 28 00 98 F5 D0 ?? ?? ?? ?? 2C 46 20 46 0D F5 0A 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_35_0 {
	meta:
		name = "_findfirst64"
		size = 118
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 002c __acrt_copy_path_to_wide_string 0036 _free_base 003e ??$common_find_first_wide@U_wfinddata64_t@@@@YAHQB_WQAU_wfinddata64_t@@@Z 0058 ??$copy_wide_to_narrow_find_data@U_wfinddata64_t@@U__finddata64_t@@@@YA_NABU_wfinddata64_t@@AAU__finddata64_t@@@Z 006e __security_pop_cookie"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 0E 7D 0E 46 46 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 20 E0 00 23 69 46 00 93 ?? ?? ?? ?? 00 28 00 98 02 D1 ?? ?? ?? ?? F1 E7 02 A9 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 03 D1 00 98 ?? ?? ?? ?? 09 E0 02 A8 31 46 ?? ?? ?? ?? 00 28 00 98 F5 D0 ?? ?? ?? ?? 2C 46 20 46 0D F5 0E 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_240_36_0 {
	meta:
		name = "_findfirst64i32"
		size = 118
		refs = "0008 __security_push_cookie 0014 _errno 001c _invalid_parameter_noinfo 002c __acrt_copy_path_to_wide_string 0036 _free_base 003e ??$common_find_first_wide@U_wfinddata64i32_t@@@@YAHQB_WQAU_wfinddata64i32_t@@@Z 0058 ??$copy_wide_to_narrow_find_data@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YA_NABU_wfinddata64i32_t@@AAU_finddata64i32_t@@@Z 006e __security_pop_cookie"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 0E 7D 0E 46 46 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 6F F0 00 04 20 E0 00 23 69 46 00 93 ?? ?? ?? ?? 00 28 00 98 02 D1 ?? ?? ?? ?? F1 E7 02 A9 ?? ?? ?? ?? 05 46 6F F0 00 04 A5 42 03 D1 00 98 ?? ?? ?? ?? 09 E0 02 A8 31 46 ?? ?? ?? ?? 00 28 00 98 F5 D0 ?? ?? ?? ?? 2C 46 20 46 0D F5 0E 7D ?? ?? ?? ?? BD E8 70 88 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "??$common_freopen@D@@YAHQAPAU_iobuf@@QBD1V__crt_stdio_stream@@H@Z"
		size = 272
		refs = "0018 _errno 0020 _invalid_parameter_noinfo 005c _lock_file 0078 _fclose_nolock 00ce _openfile 00fe _unlock_file"
	strings:
		$1 = { 0F B4 2D E9 FC 4B 0D F1 20 0B 6F 46 1C 46 7C 63 90 46 0D 46 06 46 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 23 6D E0 4F F0 00 09 C6 F8 00 90 25 B9 ?? ?? ?? ?? 09 23 03 60 63 E0 B8 F1 00 0F EA D0 00 2C E8 D0 95 F9 00 30 23 B9 ?? ?? ?? ?? 16 23 03 60 E6 E7 00 23 7B 60 20 46 ?? ?? ?? ?? 7B 6B DB 68 BF F3 5B 8F 13 F4 00 5F 01 D0 01 23 00 E0 00 23 13 B1 78 6B ?? ?? ?? ?? 7B 6B C3 F8 00 90 7B 6B C3 F8 04 90 7B 6B C3 F8 08 90 BF F3 5B 8F 7B 6B 03 F1 0C 02 52 E8 00 0F 00 F0 00 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 7B 6B 03 F1 0C 02 52 E8 00 0F 40 F4 00 51 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 7B 6B BA 6B 41 46 28 46 ?? ?? ?? ?? 30 60 90 B9 BF F3 5B 8F 7B 6B 03 F1 0C 02 52 E8 00 0F 20 F4 00 51 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F ?? ?? ?? ?? 03 68 7B 60 78 6B ?? ?? ?? ?? 7B 68 3B 60 38 68 BD E8 FC 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_241_2_0 {
	meta:
		name = "?fin$0@?0???$common_freopen@D@@YAHQAPAU_iobuf@@QBD1V__crt_stdio_stream@@H@Z@4HA"
		size = 16
		refs = "0006 ?public_stream@__crt_stdio_stream@@QBAPAU_iobuf@@XZ 000a _unlock_file"
		altNames = "?fin$0@?0???$common_freopen@_W@@YAHQAPAU_iobuf@@QB_W1V__crt_stdio_stream@@H@Z@4HA"
	strings:
		$1 = { 10 B5 17 F1 34 00 ?? ?? ?? ?? ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_241_3_0 {
	meta:
		name = "??$common_freopen@_W@@YAHQAPAU_iobuf@@QB_W1V__crt_stdio_stream@@H@Z"
		size = 270
		refs = "0018 _errno 0020 _invalid_parameter_noinfo 005a _lock_file 0076 _fclose_nolock 00cc _wopenfile 00fc _unlock_file"
	strings:
		$1 = { 0F B4 2D E9 FC 4B 0D F1 20 0B 6F 46 1C 46 7C 63 90 46 0D 46 06 46 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 23 6C E0 4F F0 00 09 C6 F8 00 90 25 B9 ?? ?? ?? ?? 09 23 03 60 62 E0 B8 F1 00 0F EA D0 00 2C E8 D0 2B 88 23 B9 ?? ?? ?? ?? 16 23 03 60 E7 E7 00 23 7B 60 20 46 ?? ?? ?? ?? 7B 6B DB 68 BF F3 5B 8F 13 F4 00 5F 01 D0 01 23 00 E0 00 23 13 B1 78 6B ?? ?? ?? ?? 7B 6B C3 F8 00 90 7B 6B C3 F8 04 90 7B 6B C3 F8 08 90 BF F3 5B 8F 7B 6B 03 F1 0C 02 52 E8 00 0F 00 F0 00 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 7B 6B 03 F1 0C 02 52 E8 00 0F 40 F4 00 51 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 7B 6B BA 6B 41 46 28 46 ?? ?? ?? ?? 30 60 90 B9 BF F3 5B 8F 7B 6B 03 F1 0C 02 52 E8 00 0F 20 F4 00 51 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F ?? ?? ?? ?? 03 68 7B 60 78 6B ?? ?? ?? ?? 7B 68 3B 60 38 68 BD E8 FC 0B 5D F8 14 FB }
	condition:
		$1
}

rule file_241_16_0 {
	meta:
		name = "_wfreopen"
		size = 36
		refs = "0018 ??$common_freopen@_W@@YAHQAPAU_iobuf@@QB_W1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 13 46 0A 46 01 46 00 20 02 90 40 20 00 90 02 A8 ?? ?? ?? ?? 02 98 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_241_18_0 {
	meta:
		name = "freopen"
		size = 36
		refs = "0018 ??$common_freopen@D@@YAHQAPAU_iobuf@@QBD1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 13 46 0A 46 01 46 00 20 02 90 40 20 00 90 02 A8 ?? ?? ?? ?? 02 98 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_241_17_0 {
	meta:
		name = "_wfreopen_s"
		size = 20
		refs = "000c ??$common_freopen@_W@@YAHQAPAU_iobuf@@QB_W1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 80 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_241_19_0 {
	meta:
		name = "freopen_s"
		size = 20
		refs = "000c ??$common_freopen@D@@YAHQAPAU_iobuf@@QBD1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 80 24 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_242_3_0 {
	meta:
		name = "__acrt_update_locale_info"
		size = 52
		refs = "0020 __acrt_update_thread_locale_data 002c __globallocalestatus 0030 __acrt_current_locale_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 4B 0C 46 22 68 1B 68 9A 42 08 D0 05 4B D0 F8 50 23 1B 68 1A 42 02 D1 ?? ?? ?? ?? 20 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_242_4_0 {
	meta:
		name = "__acrt_update_multibyte_info"
		size = 52
		refs = "0020 __acrt_update_thread_multibyte_data 002c __globallocalestatus 0030 __acrt_current_multibyte_data"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 09 4B 0C 46 22 68 1B 68 9A 42 08 D0 05 4B D0 F8 50 23 1B 68 1A 42 02 D1 ?? ?? ?? ?? 20 60 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "__remainder_piby2"
		size = 1336
		refs = "000c __security_push_cookie 0502 __security_pop_cookie 0530 ?pibits@?1??__remainder_piby2@@9@9"
	strings:
		$1 = {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}
	condition:
		$1
}

rule file_244_1_0 {
	meta:
		name = "?should_write_error_to_console@@YA_NXZ"
		size = 40
		refs = "0008 _set_error_mode 0024 ?__acrt_app_type@@3W4_crt_app_type@@A"
	strings:
		$1 = { 2D E9 00 48 EB 46 03 20 ?? ?? ?? ?? 01 28 01 D1 01 20 05 E0 18 B9 03 4B 1B 68 01 2B F8 D0 00 20 BD E8 00 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_244_2_0 {
	meta:
		name = "?write_string_to_console@@YAXQB_W@Z"
		size = 104
		refs = "0008 __security_push_cookie 0056 __security_pop_cookie 0060 __imp_WriteFile 0064 __imp_GetStdHandle"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B ?? ?? ?? ?? AD F5 02 7D 14 4B 04 46 6F F0 0B 00 1B 68 98 47 C8 B1 B0 F1 FF 3F 16 D0 04 A9 81 AA 34 F8 02 3B 01 F8 01 3B 91 42 01 D0 00 2B F7 D1 09 4C 00 23 04 AA 8D F8 03 32 02 93 24 68 8A 1A 00 93 02 AB 52 1E 04 A9 A0 47 0D F5 02 7D ?? ?? ?? ?? BD E8 10 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_244_3_0 {
	meta:
		name = "__acrt_report_runtime_error"
		size = 384
		refs = "0008 __security_push_cookie 0014 _set_error_mode 0030 wcscpy_s 006a wcslen 008e wcsncpy_s 009e wcscat_s 00ba __acrt_show_wide_message_box 0104 __security_pop_cookie 0116 _invoke_watson 0154 __imp_WriteFile 0158 __imp_GetStdHandle 015c ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0164 ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@ 0168 ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@ 016c ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 0170 __imp_GetModuleFileNameW 0174 ??_C@_1DE@JNGNBFGO@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?$CB?$AA?6?$AA?6?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@ 0178 ?outmsg@?9??__acrt_report_runtime_error@@9@4PA_WA 017c ?__acrt_app_type@@3W4_crt_app_type@@A"
	strings:
		$1 = { 2D E9 70 48 0D F1 0C 0B ?? ?? ?? ?? AD F5 02 7D 05 46 03 20 ?? ?? ?? ?? 01 28 51 D0 18 B9 57 4B 1B 68 01 2B 4C D0 54 4C 52 4A 4F F4 45 71 20 46 ?? ?? ?? ?? 00 28 40 F0 85 80 00 23 A4 F8 3A 32 4B 4B 4F F4 82 72 04 F1 32 01 1B 68 00 20 98 47 40 F2 FB 26 38 B9 45 4A 04 F1 32 00 31 46 ?? ?? ?? ?? 00 28 52 D1 04 F1 32 00 ?? ?? ?? ?? 43 1C 3C 2B 10 D9 A0 F1 3B 02 04 F1 32 03 03 EB 42 00 04 F1 32 03 38 4A C3 1A A6 EB 63 01 03 23 ?? ?? ?? ?? 00 28 41 D1 33 4A 4F F4 45 71 20 46 ?? ?? ?? ?? 00 28 47 D1 2A 46 4F F4 45 71 20 46 ?? ?? ?? ?? C8 BB 2A 4A 29 49 20 46 ?? ?? ?? ?? 1F E0 25 4B 6F F0 0B 00 1B 68 98 47 C8 B1 B0 F1 FF 3F 16 D0 04 A9 81 AA 35 F8 02 3B 01 F8 01 3B 91 42 01 D0 00 2B F7 D1 1B 4C 00 23 04 AA 8D F8 03 32 02 93 24 68 8A 1A 00 93 02 AB 52 1E 04 A9 A0 47 0D F5 02 7D ?? ?? ?? ?? BD E8 70 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 20 01 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_4_0 {
	meta:
		name = "?get_drive_number_from_path@@YAHQB_W@Z"
		size = 38
	strings:
		$1 = { 2D E9 00 48 EB 46 02 88 52 B1 43 88 3A 2B 07 D1 61 2A 02 D3 7A 2A 98 BF 20 3A A2 F1 40 00 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_245_6_0 {
	meta:
		name = "_chdrive"
		size = 108
		refs = "0006 __security_push_cookie 0038 __acrt_errno_map_os_error 0042 __doserrno 004a _errno 0052 _invalid_parameter_noinfo 005c __security_pop_cookie 0064 __imp_GetLastError 0068 __imp_SetCurrentDirectoryW"
	strings:
		$1 = { 2D E9 00 48 EB 46 ?? ?? ?? ?? 83 B0 01 28 18 DB 1A 28 16 DC 00 F1 40 03 AD F8 00 30 3A 23 AD F8 02 30 00 23 AD F8 04 30 0F 4B 68 46 1B 68 98 47 28 B9 0C 4B 1B 68 98 47 ?? ?? ?? ?? 0B E0 00 20 0B E0 ?? ?? ?? ?? 0F 23 03 60 ?? ?? ?? ?? 0D 23 03 60 ?? ?? ?? ?? 6F F0 00 00 03 B0 ?? ?? ?? ?? BD E8 00 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_7_0 {
	meta:
		name = "_getdrive"
		size = 168
		refs = "0008 __security_push_cookie 0018 memset 0056 _calloc_base 006a _errno 0076 _free_base 0080 __security_pop_cookie 00a4 __imp_GetCurrentDirectoryW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? AD F5 03 7D 68 46 40 F2 0A 22 00 21 ?? ?? ?? ?? 21 4B 69 46 40 F2 05 10 1B 68 98 47 04 46 B0 F5 82 7F 10 D8 BD F8 00 20 5A B1 BD F8 02 30 3A 2B 07 D1 61 2A 02 D3 7A 2A 98 BF 20 3A A2 F1 40 04 15 E0 00 24 13 E0 02 21 60 1C ?? ?? ?? ?? 05 46 2D B1 11 4B 01 46 60 1C 1B 68 98 47 70 B9 ?? ?? ?? ?? 0C 23 03 60 00 24 28 46 ?? ?? ?? ?? 20 46 0D F5 03 7D ?? ?? ?? ?? BD E8 30 88 2A 88 00 2A F1 D0 6B 88 3A 2B EE D1 61 2A 02 D3 7A 2A 00 D8 20 3A A2 F1 40 04 E7 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "_chgsign"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 53 EC 10 2B 83 F0 00 43 43 EC 10 2B BD E8 00 88 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "atanh"
		size = 156
		refs = "000e _dtest 0044 _fperrraise 0078 log1p 0094 _Inf_C 0098 _Nan_C"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 68 46 8D ED 00 0B ?? ?? ?? ?? D8 B3 02 28 39 D0 9D ED 00 2B B5 EE C0 2B F1 EE 10 FA 05 D2 B1 EE 42 2B 01 24 8D ED 00 2B 00 E0 00 24 B7 EE 00 1B B4 EE C2 1B F1 EE 10 FA 06 D2 01 20 ?? ?? ?? ?? 13 4B 93 ED 00 0B 1F E0 B4 EE 41 2B F1 EE 10 FA 06 D1 04 20 ?? ?? ?? ?? 0C 4B 93 ED 00 0B 0D E0 B0 EE 00 0B 31 EE 42 1B 22 EE 00 0B 80 EE 01 0B ?? ?? ?? ?? B6 EE 00 1B 20 EE 01 0B 24 B1 B1 EE 40 0B 01 E0 9D ED 00 0B BD E8 1E 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "atanhl"
		size = 156
		refs = "000e _ldtest 0044 _fperrraise 0078 log1pl 0094 _LInf_C 0098 _LNan_C"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 68 46 8D ED 00 0B ?? ?? ?? ?? D8 B3 02 28 39 D0 9D ED 00 2B B5 EE C0 2B F1 EE 10 FA 05 D2 B1 EE 42 2B 01 24 8D ED 00 2B 00 E0 00 24 B7 EE 00 1B B4 EE C2 1B F1 EE 10 FA 06 D2 01 20 ?? ?? ?? ?? 13 4B 93 ED 00 0B 1F E0 B4 EE 41 2B F1 EE 10 FA 06 D1 04 20 ?? ?? ?? ?? 0C 4B 93 ED 00 0B 0D E0 B0 EE 00 0B 31 EE 42 1B 22 EE 00 0B 80 EE 01 0B ?? ?? ?? ?? B6 EE 00 1B 20 EE 01 0B 24 B1 B1 EE 40 0B 01 E0 9D ED 00 0B BD E8 1E 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_2_0 {
	meta:
		name = "??$common_fullpath@D@@YAPADQADQBDIH1H@Z"
		size = 148
		refs = "0016 ??$common_fullpath_user_buffer@D@@YAPADQADQBDI@Z 0032 __acrt_errno_map_os_error 0044 calloc 004c _errno 0056 free 007e _getcwd 008c __imp_GetLastError 0090 __imp_GetFullPathNameA"
		altNames = "_fullpath"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0E 46 15 46 8E B3 91 F9 00 30 73 B3 10 B1 ?? ?? ?? ?? 32 E0 1C 4C 00 23 00 22 24 68 00 21 30 46 A0 47 30 B9 17 4B 1B 68 98 47 ?? ?? ?? ?? 00 24 24 E0 85 42 98 BF 05 46 28 46 01 21 ?? ?? ?? ?? 04 46 3C B9 ?? ?? ?? ?? 0C 23 03 60 20 46 ?? ?? ?? ?? EC E7 2A 46 31 46 20 46 ?? ?? ?? ?? 00 28 F4 D0 00 20 ?? ?? ?? ?? 08 E0 6F F0 00 43 9D 42 28 BF 1D 46 29 46 ?? ?? ?? ?? 04 46 20 46 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_3_0 {
	meta:
		name = "??$common_fullpath@_W@@YAPA_WQA_WQB_WIHQBDH@Z"
		size = 144
		refs = "0014 ??$common_fullpath_user_buffer@_W@@YAPA_WQA_WQB_WI@Z 0030 __acrt_errno_map_os_error 0042 calloc 004a _errno 0054 free 007c _wgetcwd 0088 __imp_GetLastError 008c __imp_GetFullPathNameW"
		altNames = "_wfullpath"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 0E 46 15 46 86 B3 33 88 73 B3 10 B1 ?? ?? ?? ?? 32 E0 1C 4C 00 23 00 22 24 68 00 21 30 46 A0 47 30 B9 17 4B 1B 68 98 47 ?? ?? ?? ?? 00 24 24 E0 85 42 98 BF 05 46 28 46 02 21 ?? ?? ?? ?? 04 46 3C B9 ?? ?? ?? ?? 0C 23 03 60 20 46 ?? ?? ?? ?? EC E7 2A 46 31 46 20 46 ?? ?? ?? ?? 00 28 F4 D0 00 20 ?? ?? ?? ?? 08 E0 6F F0 00 43 9D 42 28 BF 1D 46 29 46 ?? ?? ?? ?? 04 46 20 46 BD E8 78 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_4_0 {
	meta:
		name = "??$common_fullpath_dynamic_buffer@D@@YAPADQBDIH0H@Z"
		size = 108
		refs = "0020 __acrt_errno_map_os_error 0032 calloc 003c _errno 004c ??$common_fullpath_user_buffer@D@@YAPADQADQBDI@Z 005a free 0064 __imp_GetLastError 0068 __imp_GetFullPathNameA"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 17 4C 0D 46 00 23 24 68 00 22 00 21 07 46 A0 47 30 B9 12 4B 1B 68 98 47 ?? ?? ?? ?? 00 24 1A E0 85 42 98 BF 05 46 28 46 01 21 ?? ?? ?? ?? 04 46 06 46 24 B9 ?? ?? ?? ?? 0C 23 03 60 05 E0 2A 46 39 46 20 46 ?? ?? ?? ?? 08 B9 00 24 00 E0 00 26 30 46 ?? ?? ?? ?? 20 46 BD E8 F0 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_5_0 {
	meta:
		name = "??$common_fullpath_dynamic_buffer@_W@@YAPA_WQB_WIHQBDH@Z"
		size = 108
		refs = "0020 __acrt_errno_map_os_error 0032 calloc 003c _errno 004c ??$common_fullpath_user_buffer@_W@@YAPA_WQA_WQB_WI@Z 005a free 0064 __imp_GetLastError 0068 __imp_GetFullPathNameW"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 17 4C 0D 46 00 23 24 68 00 22 00 21 07 46 A0 47 30 B9 12 4B 1B 68 98 47 ?? ?? ?? ?? 00 24 1A E0 85 42 98 BF 05 46 28 46 02 21 ?? ?? ?? ?? 04 46 06 46 24 B9 ?? ?? ?? ?? 0C 23 03 60 05 E0 2A 46 39 46 20 46 ?? ?? ?? ?? 08 B9 00 24 00 E0 00 26 30 46 ?? ?? ?? ?? 20 46 BD E8 F0 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_6_0 {
	meta:
		name = "??$common_fullpath_user_buffer@D@@YAPADQADQBDI@Z"
		size = 88
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0042 __acrt_errno_map_os_error 0050 __imp_GetLastError 0054 __imp_GetFullPathNameA"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 16 46 0C 46 05 46 36 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 13 E0 20 46 0C 4C 00 23 2A 46 24 68 31 46 A0 47 B0 42 04 D3 ?? ?? ?? ?? 22 23 03 60 05 E0 28 B9 04 4B 1B 68 98 47 ?? ?? ?? ?? 00 25 28 46 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_7_0 {
	meta:
		name = "??$common_fullpath_user_buffer@_W@@YAPA_WQA_WQB_WI@Z"
		size = 88
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0042 __acrt_errno_map_os_error 0050 __imp_GetLastError 0054 __imp_GetFullPathNameW"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 16 46 0C 46 05 46 36 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 13 E0 20 46 0C 4C 00 23 2A 46 24 68 31 46 A0 47 B0 42 04 D3 ?? ?? ?? ?? 22 23 03 60 05 E0 28 B9 04 4B 1B 68 98 47 ?? ?? ?? ?? 00 25 28 46 BD E8 78 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_20_0 {
	meta:
		name = "?get_full_path_name@@YAIQADQBDI@Z"
		size = 36
		refs = "0020 __imp_GetFullPathNameA"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 14 46 0D 46 21 46 04 4C 02 46 00 23 24 68 28 46 A0 47 BD E8 30 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_21_0 {
	meta:
		name = "?get_full_path_name@@YAIQA_WQB_WI@Z"
		size = 36
		refs = "0020 __imp_GetFullPathNameW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 14 46 0D 46 21 46 04 4C 02 46 00 23 24 68 28 46 A0 47 BD E8 30 88 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "casinhf"
		size = 588
		refs = "0016 crealf 002a cimagf 0034 _fdtest 00ea _FCbuild 00ee csqrtf 01c4 asinhf 01e4 logf 0206 _FCmulcc 0216 atan2f 0240 _FZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 08 8B 85 B0 CD ED 03 0A 8D ED 02 0A ?? ?? ?? ?? DD ED 03 0A B0 EE 40 1A 9D ED 02 0A 8D ED 01 1A ?? ?? ?? ?? 01 A8 8D ED 00 0A ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 11 D1 02 28 0A D0 48 B1 01 28 04 D1 9D ED 00 8A 9D ED 01 0A E0 E0 9D ED 01 8A 0A E0 9D ED 01 8A 9D ED 00 0A D8 E0 02 28 06 D1 01 2C F6 D0 9D ED 00 8A B0 EE 48 0A CF E0 01 2C 1E D1 9D ED 01 8A 01 28 0C D1 9D ED 00 0A B5 EE C0 0A F1 EE 10 FA 02 D2 9F ED 6C 0A BF E0 9F ED 6A 0A BC E0 BD F8 02 30 13 F4 00 4F 05 D0 65 4B 93 ED 00 0A B1 EE 40 0A B1 E0 9F ED 5E 0A AE E0 01 28 0C D1 9D ED 00 8A B5 EE C0 8A F1 EE 10 FA 02 D2 9F ED 5B 0A A2 E0 9F ED 58 0A 9F E0 9D ED 00 0A DD ED 01 0A B7 EE 00 8A 38 EE 40 0A ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 01 2A DD ED 00 2A B0 EE 60 AA F0 EE 40 AA F1 EE 42 0A 32 EE 88 0A ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 01 8A B0 EE 60 BA F0 EE 40 BA B5 EE 40 8A F1 EE 10 FA 66 D0 B0 EE 6A 0A F0 EE 4A 0A ?? ?? ?? ?? F0 EE 4A 0A B0 EE 40 9A B0 EE 6A 0A ?? ?? ?? ?? F0 EE 4B 0A B0 EE 40 8A B0 EE 6B 0A ?? ?? ?? ?? F0 EE 4B 0A F0 EE 40 9A B0 EE 6B 0A ?? ?? ?? ?? DF ED 33 0A F4 EE C9 0A F1 EE 10 FA 08 D2 89 EE 89 2A F0 EE 49 8A 22 EE 08 2A 32 EE 40 0A 1F E0 F4 EE C8 0A F1 EE 10 FA 04 D2 80 EE 08 0A F0 EE 48 8A 08 E0 F1 EE 48 8A F4 EE E8 0A F1 EE 10 FA 06 D2 80 EE 28 0A 20 EE 09 0A 39 EE C0 0A 07 E0 69 EE 88 2A 20 EE 09 2A DF ED 1C 8A 32 EE C2 0A ?? ?? ?? ?? F5 EE 40 8A B0 EE 40 8A F1 EE 10 FA 0F D0 B5 EE C0 0A B0 EE 68 0A F1 EE 10 FA 04 DB ?? ?? ?? ?? 38 EE 00 8A 03 E0 ?? ?? ?? ?? 38 EE 40 8A F0 EE 4B 1A B0 EE 6B 1A F0 EE 4A 0A B0 EE 6A 0A ?? ?? ?? ?? ?? ?? ?? ?? F0 EE 40 0A 9D ED 00 0A ?? ?? ?? ?? F0 EE 40 0A B0 EE 48 0A ?? ?? ?? ?? 05 B0 BD EC 08 8B BD E8 10 88 00 00 00 00 0A E8 7F 5E DB 0F C9 3F DB 0F C9 BF ?? ?? ?? ?? DB 0F 49 3F DB 0F 49 BF }
	condition:
		$1
}

rule file_252_5_0 {
	meta:
		name = "_mbstok_s_l"
		size = 362
		refs = "0014 _errno 001c _invalid_parameter_noinfo 0036 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 004a strtok_s"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 85 B0 17 46 1D 46 88 46 04 46 3F B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 9F E0 B8 F1 00 0F F4 D0 14 B9 3B 68 00 2B F0 D0 68 46 29 46 ?? ?? ?? ?? DD F8 08 90 D9 F8 08 30 2B B9 3A 46 41 46 20 46 ?? ?? ?? ?? 7F E0 04 B9 3C 68 22 78 4F F0 04 0A B2 B3 2A 26 98 F8 00 30 45 46 13 E0 29 78 01 EB 09 03 5B 7E 13 EA 0A 0F 08 D0 68 78 68 B1 91 42 02 D1 63 78 98 42 0E D0 6D 1C 01 E0 91 42 0A D0 6D 1C 2B 78 00 2B E9 D1 05 E0 6D 1C ?? ?? ?? ?? 06 60 DD F8 08 90 2B 78 93 B1 23 78 4B 44 5B 7E 13 EA 0A 0F 02 D0 64 1C 23 78 23 B1 64 1C 22 78 00 2A CF D1 04 E0 ?? ?? ?? ?? 06 60 DD F8 08 90 23 78 20 46 DB B3 98 F8 00 E0 00 26 BE F1 00 0F 42 46 1B D0 15 78 05 EB 09 03 5B 7E 13 EA 0A 0F 09 D0 51 78 89 B1 23 78 9D 42 02 D1 63 78 99 42 09 D0 52 1C 02 E0 23 78 9D 42 07 D0 52 1C 13 78 00 2B E7 D1 02 E0 01 26 00 E0 52 1C 13 78 83 B9 23 78 4B 44 5B 7E 13 EA 0A 0F 02 D0 63 78 2B B1 64 1C 64 1C 23 78 00 2B CF D1 08 E0 00 23 23 70 05 E0 00 23 23 70 64 1C 0E B1 23 70 64 1C A0 42 08 BF 00 20 3C 60 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_253_5_0 {
	meta:
		name = "_mbsnccnt_l"
		size = 110
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0018 _errno 0020 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 45 B9 3C B1 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 15 E0 00 20 9C B1 02 9A 2B 78 64 1E 7B B1 13 44 5B 7E 13 F0 04 0F 06 D0 00 2C A4 F1 01 04 06 D0 6D 1C 2B 78 1B B1 40 1C 6D 1C 00 2C EC D1 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_254_3_0 {
	meta:
		name = "?__acrt_fp_classify@@YA?AW4__acrt_fp_class@@ABN@Z"
		size = 78
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B D0 E9 00 41 40 F2 FF 73 C1 F3 0A 52 9A 42 17 D1 0A 46 6F F3 1F 52 54 EA 02 03 08 BF 01 20 10 D0 11 F0 00 4F 05 D0 24 B9 B2 F5 00 2F 08 BF 04 20 07 D0 11 F4 00 2F 18 BF 02 20 02 D1 03 20 00 E0 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_254_4_0 {
	meta:
		name = "?__acrt_fp_is_negative@@YA_NABN@Z"
		size = 24
	strings:
		$1 = { 2D E9 00 48 EB 46 43 68 13 F0 00 4F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_254_5_0 {
	meta:
		name = "?fp_format_a@@YAHQBNPADIQADIH_NIQAU__crt_locale_pointers@@@Z"
		size = 744
		refs = "0026 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0032 _errno 003a _invalid_parameter_noinfo 006e ?fp_format_e@@YAHQBNQADI1IH_NIQAU__crt_locale_pointers@@@Z 007e strrchr 025c __rt_sdiv64"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8D B0 17 9E 0D 46 1A 99 00 2E B8 BF 00 26 07 46 4F F0 00 0A 08 A8 99 46 90 46 85 F8 00 A0 ?? ?? ?? ?? 06 F1 0B 04 A0 45 07 D8 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 20 43 E1 D7 E9 00 31 06 93 40 F2 FF 73 C1 F3 0A 52 9A 42 23 D1 19 9B 42 46 29 46 03 93 16 9B 38 46 CD F8 10 A0 00 93 4B 46 CD F8 08 A0 01 96 ?? ?? ?? ?? 10 B1 85 F8 00 A0 27 E1 65 21 28 46 ?? ?? ?? ?? 00 28 00 F0 20 81 9D F8 60 30 0B B1 50 23 00 E0 70 23 03 70 80 F8 03 A0 15 E1 4F F0 2D 08 11 F0 00 4F 02 D0 85 F8 00 80 6D 1C 9D F8 60 00 08 B1 41 23 00 E0 61 23 7A 68 A3 F1 3A 0A 89 4B 40 F2 FF 39 4F F0 30 0E 1A 42 0D D1 05 F8 01 EB D7 E9 00 23 6F F3 1F 53 13 43 02 D1 4F F0 00 09 05 E0 40 F2 FE 39 02 E0 31 23 05 F8 01 3B 2C 46 6D 1C 0E B9 00 23 04 E0 09 9B D3 F8 88 30 1B 68 1B 78 23 70 D7 E9 00 23 6F F3 1F 53 0B B9 00 2A 6B D0 30 20 4F F0 00 08 4F F4 70 2E 00 2E 25 DD 3B 68 03 EA 08 02 7B 68 C2 40 03 EA 0E 01 6F F3 1F 51 C0 F1 20 03 01 FA 03 F3 1A 43 A0 F1 20 03 21 FA 03 F3 13 43 30 33 9B B2 39 2B 01 D9 53 44 9B B2 2B 70 4F EA 0E 73 43 EA 18 18 03 1F 18 B2 6D 1C 76 1E 00 28 4F EA 1E 1E D7 DA 00 28 36 DB 3B 68 03 EA 08 02 7B 68 C2 40 03 EA 0E 01 6F F3 1F 51 C0 F1 20 03 01 FA 03 F3 1A 43 A0 F1 20 03 21 FA 03 F3 13 43 9B B2 08 2B 4F F0 30 0E 20 D9 6A 1E 92 F9 00 30 66 2B 01 D0 46 2B 02 D1 02 F8 01 E9 F6 E7 A2 42 0D D0 92 F9 00 30 9D F8 60 00 4F F0 2D 08 39 2B 02 D1 0A F1 3A 03 00 E0 5B 1C 13 70 0A E0 12 F8 01 3D 5B 1C 13 70 01 E0 4F F0 30 0E 9D F8 60 00 4F F0 2D 08 00 2E 08 DD 30 21 2B 46 26 B1 AA 19 03 F8 01 1B 93 42 FB D1 35 44 94 F9 00 30 03 B9 25 46 08 B1 50 23 00 E0 70 23 2B 70 7B 68 00 22 C3 F3 0A 53 B3 EB 09 04 62 EB 02 06 00 2E 06 DB 01 DC 00 2C 03 D3 2B 23 6B 70 AD 1C 06 E0 85 F8 01 80 AD 1C 00 23 64 42 63 EB 06 06 2F 46 85 F8 00 E0 4F F4 7A 70 00 2E 22 DB 01 DC 84 42 0D D3 33 46 22 46 00 21 ?? ?? ?? ?? 1E 46 00 F1 30 03 2B 70 6D 1C BD 42 14 46 07 91 04 D1 00 2E 0F DB 01 DC 64 2C 0C D3 00 21 64 20 33 46 22 46 ?? ?? ?? ?? 1E 46 00 F1 30 03 05 F8 01 3B 14 46 07 91 BD 42 04 D1 00 2E 0F DB 01 DC 0A 2C 0C D3 33 46 22 46 00 21 0A 20 ?? ?? ?? ?? 14 46 00 F1 30 02 2A 70 07 91 6D 1C 07 93 04 F1 30 03 2B 70 00 23 6B 70 00 20 9D F8 2C 30 33 B1 08 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 0D B0 BD E8 F0 8F 00 00 F0 7F }
	condition:
		$1
}

rule file_254_6_0 {
	meta:
		name = "?fp_format_e@@YAHQBNQADI1IH_NIQAU__crt_locale_pointers@@@Z"
		size = 146
		refs = "001e __acrt_fltout 0062 __acrt_fp_strflt_to_string 0088 ?fp_format_e_internal@@YAHQADIH_NIQAU_strflt@@1QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 88 B0 0F 9D 90 ED 00 0B 1C 46 0E 9B 17 46 0E 46 68 1C 04 A9 22 46 ?? ?? ?? ?? 6F F0 00 04 04 98 A7 42 0B D0 2D 28 08 BF 01 22 18 BF 00 22 00 2D C8 BF 01 23 D8 BF 00 23 FB 1A 9C 1A 2D 28 08 BF 01 21 18 BF 00 21 00 2D C8 BF 01 22 D8 BF 00 22 0A 44 90 19 6A 1C 04 AB 21 46 ?? ?? ?? ?? 10 B1 00 23 33 70 0E E0 12 9B 2A 46 39 46 03 93 00 23 02 93 04 AB 01 93 11 9B 30 46 00 93 9D F8 40 30 ?? ?? ?? ?? 08 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_254_7_0 {
	meta:
		name = "?fp_format_e_internal@@YAHQADIH_NIQAU_strflt@@1QAU__crt_locale_pointers@@@Z"
		size = 364
		refs = "0022 _errno 002a _invalid_parameter_noinfo 0036 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 005a strlen 0064 memmove 00ae strcpy_s 0158 _invoke_watson 0168 ??_C@_05KLBDPFGC@e?$CL000?$AA@"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 87 B0 15 46 00 2D 14 46 D8 BF 00 24 9A 46 04 F1 09 03 88 46 98 45 06 46 07 D8 ?? ?? ?? ?? 22 23 03 60 ?? ?? ?? ?? 22 20 8A E0 13 99 02 A8 ?? ?? ?? ?? 9D F8 48 90 11 9F B9 F1 00 0F 10 D0 3B 68 2D 2B 08 BF 01 23 18 BF 00 23 9C 19 00 2D 07 DD 20 46 ?? ?? ?? ?? 42 1C 60 1C 21 46 ?? ?? ?? ?? 3B 68 2D 21 32 46 2D 2B 01 D1 31 70 72 1C 00 2D 08 DD 53 78 13 70 03 9B 52 1C D3 F8 88 30 1B 68 1B 78 13 70 B9 F1 00 0F 18 BF 00 23 08 BF 01 23 13 44 6F F0 00 01 5C 19 88 45 02 D0 33 1B 03 EB 08 01 2F 4A 20 46 ?? ?? ?? ?? 00 28 4B D1 BA F1 00 0F 01 D0 45 23 23 70 BB 68 93 F9 00 30 30 2B 27 D0 7B 68 59 1E 00 29 02 DA 49 42 2D 23 63 70 64 29 0C DB 21 4B 81 FB 03 32 53 11 03 EB D3 72 A3 78 13 44 A3 70 64 23 02 FB 03 F3 C9 1A 0A 29 0C DB 19 4B 81 FB 03 32 93 10 03 EB D3 72 E3 78 13 44 E3 70 02 EB 82 03 A1 EB 43 01 23 79 0B 44 23 71 10 9B 02 2B 08 D1 94 F9 02 30 30 2B 04 D1 E1 1C 03 22 A0 1C ?? ?? ?? ?? 9D F8 14 30 33 B1 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 00 20 07 B0 BD E8 F0 8F 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE FE DE 67 66 66 66 1F 85 EB 51 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_8_0 {
	meta:
		name = "?fp_format_f@@YAHQBNQADI1IHQAU__crt_locale_pointers@@@Z"
		size = 122
		refs = "0026 __acrt_fltout 0054 __acrt_fp_strflt_to_string 0070 ?fp_format_f_internal@@YAHQADIHQAU_strflt@@_NQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 86 B0 1C 46 0D 9F 00 23 90 ED 00 0B CD E9 02 33 04 93 0C 9B 16 46 0D 46 02 A9 22 46 38 46 ?? ?? ?? ?? 6F F0 00 04 02 99 A6 42 05 D0 2D 29 08 BF 01 23 18 BF 00 23 F4 1A 2D 29 03 9A 08 BF 01 21 18 BF 00 21 48 19 21 46 02 AB 3A 44 ?? ?? ?? ?? 10 B1 00 23 2B 70 09 E0 0E 9B 3A 46 31 46 01 93 00 23 00 93 02 AB 28 46 ?? ?? ?? ?? 06 B0 BD E8 F0 88 }
	condition:
		$1
}

rule file_254_9_0 {
	meta:
		name = "?fp_format_f_internal@@YAHQADIHQAU_strflt@@_NQAU__crt_locale_pointers@@@Z"
		size = 218
		refs = "0014 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0056 strlen 0060 memmove 00ba memset"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 85 B0 0D 99 05 46 68 46 1E 46 14 46 ?? ?? ?? ?? 72 68 9D F8 30 80 30 27 51 1E B8 F1 00 0F 0C D0 A1 42 0A D1 32 68 2D 2A 08 BF 01 23 18 BF 00 23 0B 44 2B 44 00 22 5A 70 1F 70 33 68 2D 2B 02 D1 2D 23 2B 70 6D 1C 73 68 00 2B 0A DC 28 46 ?? ?? ?? ?? 42 1C 68 1C 29 46 ?? ?? ?? ?? 2F 70 6F 1C 00 E0 5F 19 00 2C 26 DD 38 46 ?? ?? ?? ?? 7D 1C 42 1C 28 46 39 46 ?? ?? ?? ?? 01 9B D3 F8 88 30 1B 68 1B 78 3B 70 72 68 00 2A 14 DA B8 F1 00 0F 02 D1 53 42 A3 42 00 DA 54 42 3C B1 28 46 ?? ?? ?? ?? 42 1C 60 19 29 46 ?? ?? ?? ?? 22 46 30 21 28 46 ?? ?? ?? ?? 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 00 20 05 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_254_10_0 {
	meta:
		name = "?fp_format_g@@YAHQBNQADI1IH_NIQAU__crt_locale_pointers@@@Z"
		size = 188
		refs = "0026 __acrt_fltout 004e __acrt_fp_strflt_to_string 0092 ?fp_format_f_internal@@YAHQADIHQAU_strflt@@_NQAU__crt_locale_pointers@@@Z 00b2 ?fp_format_e_internal@@YAHQADIH_NIQAU_strflt@@1QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 87 B0 1C 46 0F 9F 00 23 90 ED 00 0B CD E9 04 33 06 93 0E 9B 16 46 0D 46 04 A9 22 46 38 46 ?? ?? ?? ?? 04 9B 6F F0 00 01 3A 46 2D 2B 08 BF 01 20 05 9B 18 BF 00 20 44 19 8E 42 18 BF 31 1A A3 F1 01 08 04 AB 20 46 ?? ?? ?? ?? 10 B1 00 23 2B 70 2D E0 05 9B 5B 1E 98 45 B8 BF 01 22 A8 BF 00 22 13 F1 04 0F 14 DB BB 42 12 DA 32 B1 14 F9 01 3B 00 2B FB D1 00 23 04 F8 02 3C 12 9B 3A 46 31 46 01 93 01 23 00 93 04 AB 28 46 ?? ?? ?? ?? 0E E0 12 9B 3A 46 31 46 03 93 01 23 02 93 04 AB 01 93 11 9B 28 46 00 93 9D F8 40 30 ?? ?? ?? ?? 07 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_254_11_0 {
	meta:
		name = "?fp_format_nan_or_infinity@@YAHW4__acrt_fp_class@@_NPADI1@Z"
		size = 220
		refs = "0008 __security_push_cookie 007a strlen 0098 strcpy_s 00a2 __security_pop_cookie 00b6 _invoke_watson 00bc ??_C@_08OFCDMILK@nan?$CIind?$CJ?$AA@ 00c0 ??_C@_08IKHNHAJ@NAN?$CIIND?$CJ?$AA@ 00c4 ??_C@_09IPFBKMDL@nan?$CIsnan?$CJ?$AA@ 00c8 ??_C@_09OFJJIMPC@NAN?$CISNAN?$CJ?$AA@ 00cc ??_C@_03OJHLLCGB@inf?$AA@ 00d0 ??_C@_03LHCJEHON@nan?$AA@ 00d4 ??_C@_03LKNCIKJB@NAN?$AA@ 00d8 ??_C@_03OEIAHPBN@INF?$AA@"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? 92 B0 1E 46 0C 1D A6 42 15 46 03 D2 00 23 2B 70 0C 20 3F E0 4F F0 00 08 29 B1 2D 23 2B 70 6D 1C 85 F8 00 80 76 1E 29 4B 27 4A 26 49 CD E9 02 33 23 4B 47 1E CD E9 05 32 04 93 20 4B CD E9 07 21 CD E9 09 13 1C 4B CD E9 0B 23 1A 4B CD E9 0D 13 17 4B CD E9 0F 23 9D F8 68 30 11 91 0B B1 00 24 00 E0 02 24 04 EB 87 02 02 AB 53 F8 22 00 ?? ?? ?? ?? 86 42 98 BF 01 23 88 BF 00 23 03 EB 87 03 1A 19 02 AB 53 F8 22 20 31 46 28 46 ?? ?? ?? ?? 28 B9 00 20 12 B0 ?? ?? ?? ?? BD E8 F0 89 00 23 00 22 00 21 00 20 CD F8 00 80 ?? ?? ?? ?? FE DE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_12_0 {
	meta:
		name = "?shift_bytes@@YAXQADI0H@Z"
		size = 34
		refs = "0010 strlen 001a memmove"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 1C 46 15 46 3C B1 10 46 ?? ?? ?? ?? 42 1C 28 19 29 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_254_14_0 {
	meta:
		name = "__acrt_fp_format"
		size = 366
		refs = "0016 _errno 001e _invalid_parameter_noinfo 005e ?__acrt_fp_classify@@YA?AW4__acrt_fp_class@@ABN@Z 007a ?fp_format_nan_or_infinity@@YAHW4__acrt_fp_class@@_NPADI1@Z 00ba ?fp_format_a@@YAHQBNPADIQADIH_NIQAU__crt_locale_pointers@@@Z 00e0 ?fp_format_g@@YAHQBNQADI1IH_NIQAU__crt_locale_pointers@@@Z 00fc __acrt_fltout 012a __acrt_fp_strflt_to_string 0146 ?fp_format_f_internal@@YAHQADIHQAU_strflt@@_NQAU__crt_locale_pointers@@@Z 0164 ?fp_format_e@@YAHQBNQADI1IH_NIQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 8B B0 0D 46 9E 46 06 93 16 46 81 46 3D B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 A0 E0 00 2E F5 D0 BE F1 00 0F F2 D0 DD F8 50 A0 BA F1 00 0F ED D0 15 9C 41 2C 07 D0 45 2C 05 D0 46 2C 03 D0 47 2C 18 BF 00 27 00 D1 01 27 DD F8 60 80 18 F0 08 0F 13 D1 48 46 ?? ?? ?? ?? 68 B1 D9 F8 04 30 2A 46 00 97 13 F0 00 4F 18 BF 01 21 08 BF 00 21 33 46 ?? ?? ?? ?? 73 E0 DD F8 18 E0 18 F0 10 0F 18 BF 03 22 08 BF 02 22 61 2C 15 DC 05 D0 41 2C 03 D0 45 2C 56 D0 46 2C 11 E0 1A 9B 03 92 32 46 04 93 16 9B 29 46 48 46 01 93 73 46 02 97 CD F8 00 A0 ?? ?? ?? ?? 53 E0 65 2C 43 D0 66 2C 0E D0 1A 9B 03 92 32 46 04 93 16 9B 29 46 48 46 01 93 73 46 02 97 CD F8 00 A0 ?? ?? ?? ?? 40 E0 16 9F 99 ED 00 0B 00 23 CD E9 08 33 0A 93 38 46 08 A9 53 46 72 46 ?? ?? ?? ?? 6F F0 00 04 08 9A A6 42 05 D0 2D 2A 08 BF 01 23 18 BF 00 23 F4 1A 2D 2A 09 9A 08 BF 01 21 18 BF 00 21 48 19 21 46 08 AB 3A 44 ?? ?? ?? ?? 10 B1 00 23 2B 70 18 E0 1A 9B 3A 46 31 46 01 93 00 23 00 93 08 AB 28 46 ?? ?? ?? ?? 0D E0 1A 9B 03 92 32 46 04 93 16 9B 29 46 48 46 01 93 73 46 02 97 CD F8 00 A0 ?? ?? ?? ?? 0B B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "_d_int"
		size = 196
		refs = "00bc ?sub@?3??_d_int@@9@9 00c0 ?mask@?3??_d_int@@9@9"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B C2 88 47 F6 F0 73 13 40 1C 09 40 F2 FF 73 9C 42 0C D1 12 F0 0F 0F 07 D1 83 88 2B B9 43 88 1B B9 03 88 0B B9 01 20 42 E0 02 20 40 E0 32 F4 00 43 07 D1 83 88 2B B9 43 88 1B B9 03 88 0B B9 00 20 35 E0 40 F2 33 43 1B 1B 5B 1A 1C B2 00 2C F6 DD 35 2C 08 DB 02 F4 00 43 00 22 82 80 42 80 02 80 C3 80 D0 43 23 E0 14 4B 04 F0 0F 02 24 11 33 F8 12 10 10 4B 53 F8 24 20 30 F8 12 30 19 40 4B 40 20 F8 12 30 00 22 01 2C 09 D0 02 2C 04 D0 03 2C 08 D1 83 88 82 80 19 43 43 88 42 80 19 43 03 88 02 80 19 43 6F F0 00 03 01 B9 00 23 18 B2 BD E8 18 88 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_255_1_0 {
	meta:
		name = "_dtest"
		size = 84
	strings:
		$1 = { 2D E9 00 48 EB 46 C2 88 47 F6 F0 73 02 EA 03 01 99 42 0C D1 12 F0 0F 0F 07 D1 83 88 2B B9 43 88 1B B9 03 88 0B B9 01 20 12 E0 02 20 10 E0 32 F4 00 43 07 D1 83 88 2B B9 43 88 1B B9 03 88 0B B9 00 20 05 E0 11 B9 6F F0 01 00 01 E0 6F F0 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_255_2_0 {
	meta:
		name = "_fd_int"
		size = 148
		refs = "008c ?sub@?3??_fd_int@@9@9 0090 ?mask@?3??_fd_int@@9@9"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 62 88 02 F4 FF 43 D8 09 FF 28 08 D1 12 F0 7F 0F 03 D1 23 88 0B B9 01 20 31 E0 02 20 2F E0 32 F4 00 43 03 D1 23 88 0B B9 00 20 28 E0 C0 F1 96 03 5B 1A 18 B2 00 28 F7 DD 18 28 06 DB 02 F4 00 43 63 80 00 23 23 80 D8 43 19 E0 0E 4B 00 F0 0F 02 00 11 33 F8 12 10 0A 4B 53 F8 20 20 34 F8 12 30 19 40 4B 40 24 F8 12 30 00 28 03 DD 23 88 19 43 00 23 23 80 6F F0 00 03 01 B9 00 23 18 B2 BD E8 18 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_255_3_0 {
	meta:
		name = "_fdtest"
		size = 66
	strings:
		$1 = { 2D E9 00 48 EB 46 43 88 03 F4 FF 42 B2 F5 FF 4F 08 D1 13 F0 7F 0F 03 D1 03 88 0B B9 01 20 0E E0 02 20 0C E0 33 F4 00 43 03 D1 03 88 0B B9 00 20 05 E0 12 B9 6F F0 01 00 01 E0 6F F0 00 00 BD E8 00 88 }
	condition:
		$1
}

rule file_255_4_0 {
	meta:
		name = "_fperrraise"
		size = 128
		refs = "000e fegetexceptflag 0052 __acrt_fenv_get_fp_status_word_from_exception_mask 0060 fesetexceptflag 0066 _errno"
	strings:
		$1 = { 2D E9 3C 48 0D F1 10 0B 04 46 01 A8 1F 21 ?? ?? ?? ?? 01 9B 00 20 14 F0 18 0F 00 93 01 D0 44 F0 20 04 14 F0 20 0F 18 BF 01 20 14 F0 10 0F 01 D0 40 F0 02 00 14 F0 08 0F 01 D0 40 F0 04 00 14 F0 04 0F 01 D0 40 F0 08 00 14 F0 01 05 01 D0 40 F0 10 00 ?? ?? ?? ?? 00 9B 1F 21 03 43 68 46 00 93 ?? ?? ?? ?? 1D B1 ?? ?? ?? ?? 21 23 05 E0 14 F0 1C 0F 03 D0 ?? ?? ?? ?? 22 23 03 60 BD E8 3C 88 }
	condition:
		$1
}

rule file_255_7_0 {
	meta:
		name = "fperrraise_with"
		size = 122
		refs = "0048 __acrt_fenv_get_fp_status_word_from_exception_mask 0056 fesetexceptflag 005c _errno"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B 04 46 00 20 14 F0 18 0F 01 D0 44 F0 20 04 14 F0 20 0F 18 BF 01 20 14 F0 10 0F 01 D0 40 F0 02 00 14 F0 08 0F 01 D0 40 F0 04 00 14 F0 04 0F 01 D0 40 F0 08 00 14 F0 01 05 01 D0 40 F0 10 00 ?? ?? ?? ?? 05 9B 1F 21 03 43 05 A8 05 93 ?? ?? ?? ?? 1D B1 ?? ?? ?? ?? 21 23 05 E0 14 F0 1C 0F 03 D0 ?? ?? ?? ?? 22 23 03 60 BD E8 30 08 5D F8 0C FB }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "_dpoly"
		size = 40
		altNames = "_ldpoly"
	strings:
		$1 = { 2D E9 00 48 EB 46 B0 EE 40 1B 90 ED 00 0B 06 E0 08 30 90 ED 00 2B 00 EE 01 2B B0 EE 42 0B 49 1E 00 29 F5 DA BD E8 00 88 }
	condition:
		$1
}

rule file_256_1_0 {
	meta:
		name = "erfc"
		size = 556
		refs = "0012 _dtest 003e erf 010e _fperrraise 0174 _d_int 018c exp 01a8 _dexp 01e0 approx 01ec c01 01f8 s01 020c c00 0218 s00"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 06 8B 84 B0 02 A8 8D ED 02 0B ?? ?? ?? ?? 00 28 00 F0 D6 80 01 28 00 F0 CB 80 02 28 00 F0 C5 80 9F ED 7E 2B 9D ED 02 3B B4 EE C2 3B F1 EE 10 FA 08 D2 B0 EE 43 0B ?? ?? ?? ?? B7 EE 00 1B 31 EE 40 0B BF E0 9F ED 73 0B B4 EE C0 3B F1 EE 10 FA 4A D2 B7 EE 00 0B B4 EE C0 3B F1 EE 10 FA 22 D2 B6 EE 08 0B 6A 4B 9F ED 68 2B 33 EE 40 3B 07 22 08 33 52 1E 93 ED 00 0B 00 2A 02 EE 03 0B B0 EE 40 2B F5 DA 5F 4B 9F ED 5D 1B 08 22 08 33 52 1E 93 ED 00 0B 00 2A 01 EE 03 0B B0 EE 40 1B F5 DA 82 EE 01 0B 8E E0 9F ED 53 0B 51 4B 9F ED 4E 2B 07 22 33 EE 40 3B 08 33 52 1E 93 ED 00 0B 00 2A 02 EE 03 0B B0 EE 40 2B F5 DA 46 4B 9F ED 43 1B 08 22 08 33 52 1E 93 ED 00 0B 00 2A 01 EE 03 0B B0 EE 40 1B F5 DA DB E7 3B 49 00 23 0A 46 92 ED 00 0B B4 EE C0 3B F1 EE 10 FA 09 D3 5B 1C 20 32 06 2B F4 D3 10 20 ?? ?? ?? ?? 9F ED 31 0B 59 E0 01 EB 43 11 B7 EE 00 0B 91 ED 02 1B 80 EE 03 0B D1 E9 04 23 30 EE 41 1B 8D ED 00 1B 92 ED 00 AB 06 E0 08 32 92 ED 00 0B 0A EE 01 0B B0 EE 40 AB 5B 1E 00 2B F5 DA D1 E9 06 23 92 ED 00 9B 06 E0 08 32 92 ED 00 0B 09 EE 01 0B B0 EE 40 9B 5B 1E 00 2B F5 DA 68 46 11 21 8D ED 00 3B ?? ?? ?? ?? 9D ED 00 8B 9D ED 02 0B 38 EE 40 1B 30 EE 08 0B 21 EE 00 0B ?? ?? ?? ?? 28 EE 08 1B 8A EE 09 2B B1 EE 41 1B 68 46 20 EE 02 0B 00 21 8D ED 00 1B ?? ?? ?? ?? 9D ED 00 0B 0C E0 9D ED 02 0B 09 E0 BD F8 0E 30 13 F4 00 4F A7 D0 B0 EE 00 0B 01 E0 B7 EE 00 0B 04 B0 BD EC 06 8B BD E8 00 88 FE DE 00 00 00 00 00 00 00 00 ?? ?? ?? ?? EC F4 CD C2 BC 5B 21 3F ?? ?? ?? ?? 59 20 36 18 2F 33 E0 3E ?? ?? ?? ?? 00 00 00 00 00 80 F4 3F 49 B8 C7 5A 1F B3 CF BE ?? ?? ?? ?? A9 9B E2 EB 08 E3 2A 3F ?? ?? ?? ?? 91 ED 7C 3F 35 5E F8 3F 0A C0 24 BB 1F 86 DE 3F }
	condition:
		$1
}

rule file_257_9_0 {
	meta:
		name = "?ungetwc_binary_mode_nolock@@YAGGV__crt_stdio_stream@@@Z"
		size = 164
	strings:
		$1 = { 03 B4 2D E9 18 48 0D F1 08 0B 05 91 4B 68 04 46 9A 1C 0B 68 93 42 09 D2 8B 68 13 B1 4F F6 FF 74 3B E0 8B 69 02 2B F9 D3 0A 60 05 99 CB 68 BF F3 5B 8F 13 F4 80 5F 18 BF 01 23 08 BF 00 23 00 2B 0B 68 07 D0 9A 1E 0A 60 13 88 A3 42 05 D0 93 1C 0B 60 E3 E7 9B 1E 0B 60 1C 80 05 9A 93 68 9B 1C 93 60 BF F3 5B 8F 05 9B 03 F1 0C 02 52 E8 00 0F 20 F0 08 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 05 9B 03 F1 0C 02 52 E8 00 0F 40 F0 01 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 20 46 BD E8 18 08 5D F8 0C FB }
	condition:
		$1
}

rule file_257_10_0 {
	meta:
		name = "?ungetwc_text_mode_nolock@@YAGGV__crt_stdio_stream@@@Z"
		size = 300
		refs = "000a __security_push_cookie 001a _fileno 0070 wctomb_s 0116 __security_pop_cookie 0124 __badioinfo 0128 __pioinfo"
	strings:
		$1 = { 03 B4 2D E9 30 48 0D F1 08 0B ?? ?? ?? ?? 85 B0 05 46 AD F8 28 00 08 46 0B 91 ?? ?? ?? ?? B0 F1 FF 3F 17 D0 0B 98 ?? ?? ?? ?? 10 F1 02 0F 11 D0 0B 98 ?? ?? ?? ?? 04 46 0B 98 ?? ?? ?? ?? 3A 49 00 F0 3F 03 A4 11 03 EB 43 02 51 F8 24 30 03 EB 02 13 00 E0 33 4B 93 F9 29 30 00 22 00 92 8D F8 08 20 CD F8 09 20 5B B9 02 A9 68 46 2B 46 05 22 ?? ?? ?? ?? 10 B1 4F F6 FF 75 4A E0 00 99 09 E0 9D F8 28 30 02 21 8D F8 08 30 9D F8 29 30 00 91 8D F8 09 30 0B 9A 53 68 58 18 13 68 83 42 08 D2 93 68 00 2B E7 D1 93 69 99 42 E4 DC 10 60 0B 9A 00 99 48 1E 00 28 0D DB 02 AB C1 18 13 68 40 1E 5B 1E 13 60 1A 46 11 F8 01 39 00 28 13 70 0B 9A F4 DA 00 99 93 68 0B 44 93 60 BF F3 5B 8F 0B 9B 03 F1 0C 02 52 E8 00 0F 20 F0 08 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 0B 9B 03 F1 0C 02 52 E8 00 0F 40 F0 01 01 42 E8 00 13 00 2B F7 D1 BF F3 5B 8F 28 46 05 B0 ?? ?? ?? ?? BD E8 30 08 5D F8 0C FB FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_12_0 {
	meta:
		name = "_ungetwc_nolock"
		size = 212
		refs = "0056 __acrt_stdio_allocate_buffer_nolock 0070 _fileno 00ba ?ungetwc_text_mode_nolock@@YAGGV__crt_stdio_stream@@@Z 00c4 ?ungetwc_binary_mode_nolock@@YAGGV__crt_stdio_stream@@@Z 00cc __badioinfo 00d0 __pioinfo"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 06 46 4F F6 FF 70 86 42 0D 46 59 D0 EB 68 BF F3 5B 8F 13 F0 01 0F EB 68 18 BF 01 21 08 BF 00 21 BF F3 5B 8F 13 F0 04 0F EB 68 18 BF 01 22 08 BF 00 22 BF F3 5B 8F 13 F0 02 0F 18 BF 01 23 08 BF 00 23 09 B9 E2 B3 DB BB 6B 68 13 B9 28 46 ?? ?? ?? ?? EB 68 BF F3 5B 8F 13 F4 80 5F 18 BF 01 23 08 BF 00 23 43 BB 28 46 ?? ?? ?? ?? B0 F1 FF 3F 17 D0 28 46 ?? ?? ?? ?? 10 F1 02 0F 11 D0 28 46 ?? ?? ?? ?? 04 46 28 46 ?? ?? ?? ?? 0E 49 00 F0 3F 03 A4 11 03 EB 43 02 51 F8 24 30 03 EB 02 13 00 E0 08 4B 93 F8 28 30 13 F0 80 0F 04 D0 29 46 30 46 ?? ?? ?? ?? 03 E0 29 46 30 46 ?? ?? ?? ?? BD E8 78 88 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_13_0 {
	meta:
		name = "ungetwc"
		size = 80
		refs = "0014 _errno 001c _invalid_parameter_noinfo 002e _lock_file 0036 _ungetwc_nolock 003e _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 BE 48 0D F1 18 0B 6F 46 0C 46 7C 62 05 46 44 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 4F F6 FF 73 0E E0 4F F6 FF 73 3B 80 20 46 ?? ?? ?? ?? 21 46 28 46 ?? ?? ?? ?? 38 80 78 6A ?? ?? ?? ?? 3B 88 BB 80 B8 88 BD E8 BE 08 5D F8 0C FB }
	condition:
		$1
}

rule file_262_11_0 {
	meta:
		name = "fputwc"
		size = 80
		refs = "0014 _errno 001c _invalid_parameter_noinfo 002e _lock_file 0036 _fputwc_nolock 003e _unlock_file"
	strings:
		$1 = { 03 B4 2D E9 BE 48 0D F1 18 0B 6F 46 0C 46 7C 62 05 46 44 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 4F F6 FF 73 0E E0 4F F6 FF 73 3B 80 20 46 ?? ?? ?? ?? 21 46 28 46 ?? ?? ?? ?? 38 80 78 6A ?? ?? ?? ?? 3B 88 BB 80 B8 88 BD E8 BE 08 5D F8 0C FB }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "_fdpoly"
		size = 40
	strings:
		$1 = { 2D E9 00 48 EB 46 F0 EE 40 0A 90 ED 00 0A 06 E0 00 1D 90 ED 00 2A 00 EE 20 2A B0 EE 42 0A 49 1E 00 29 F5 DA BD E8 00 88 }
	condition:
		$1
}

rule file_258_1_0 {
	meta:
		name = "erfcf"
		size = 528
		refs = "0012 _fdtest 003e erff 010e _fperrraise 0178 _fd_int 0190 expf 01ac _fdexp 01e0 approx 01e8 c01 01f0 s01 01fc c00 0204 s00"
	strings:
		$1 = { 2D E9 00 48 EB 46 2D ED 04 8B 82 B0 01 A8 8D ED 01 0A ?? ?? ?? ?? 00 28 00 F0 D8 80 01 28 00 F0 CD 80 02 28 00 F0 C7 80 9F ED 78 2A 9D ED 01 1A B4 EE C2 1A F1 EE 10 FA 08 D2 B0 EE 41 0A ?? ?? ?? ?? F7 EE 00 0A 30 EE C0 0A C1 E0 9F ED 6E 0A B4 EE C0 1A F1 EE 10 FA 4A D2 B7 EE 00 0A B4 EE C0 1A F1 EE 10 FA 22 D2 B6 EE 08 0A 65 4B 71 EE 40 1A 9F ED 63 1A 03 22 1B 1D 52 1E 93 ED 00 0A 00 2A 01 EE 21 0A B0 EE 40 1A F5 DA 5B 4B DF ED 5A 0A 03 22 1B 1D 52 1E 93 ED 00 0A 00 2A 00 EE A1 0A F0 EE 40 0A F5 DA 81 EE 20 0A 90 E0 9F ED 51 0A 4F 4B 03 22 71 EE 40 1A 9F ED 4C 1A 1B 1D 52 1E 93 ED 00 0A 00 2A 01 EE 21 0A B0 EE 40 1A F5 DA 45 4B DF ED 43 0A 03 22 1B 1D 52 1E 93 ED 00 0A 00 2A 00 EE A1 0A F0 EE 40 0A F5 DA DB E7 3B 49 00 23 0A 46 92 ED 00 0A B4 EE C0 1A F1 EE 10 FA 09 D3 5B 1C 18 32 08 2B F4 D3 10 20 ?? ?? ?? ?? 9F ED 32 0A 5B E0 03 EB 43 03 01 EB C3 01 B7 EE 00 0A D1 ED 01 0A 80 EE 01 0A D1 E9 02 23 70 EE 60 0A CD ED 00 0A 92 ED 00 9A 06 E0 12 1D 92 ED 00 0A 09 EE 20 0A B0 EE 40 9A 5B 1E 00 2B F5 DA D1 E9 04 23 D2 ED 00 8A 06 E0 12 1D 92 ED 00 0A 08 EE A0 0A F0 EE 40 8A 5B 1E 00 2B F5 DA 68 46 08 21 8D ED 00 1A ?? ?? ?? ?? 9D ED 00 8A 9D ED 01 0A 78 EE 40 0A 30 EE 08 0A 20 EE 80 0A ?? ?? ?? ?? 68 EE 08 0A 89 EE 28 1A F1 EE 60 0A 68 46 20 EE 01 0A 00 21 CD ED 00 0A ?? ?? ?? ?? 9D ED 00 0A 0C E0 9D ED 01 0A 09 E0 BD F8 06 30 13 F4 00 4F A5 D0 B0 EE 00 0A 01 E0 B7 EE 00 0A 02 B0 BD EC 04 8B BD E8 00 88 FE DE 00 00 00 00 ?? ?? ?? ?? 46 01 37 3D ?? ?? ?? ?? 54 21 8C 3C ?? ?? ?? ?? 00 00 A4 3F 6C D1 56 3D ?? ?? ?? ?? F9 2E A9 3C ?? ?? ?? ?? AA F1 C2 3F FE 30 F4 3E }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "_initterm"
		size = 64
		refs = "003c __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 F8 49 0D F1 18 0B 07 46 CB 1B DB 1C 00 26 8F 42 98 BF 9C 08 88 BF 00 24 64 B1 DF F8 1C 80 57 F8 04 5B 25 B1 D8 F8 00 30 28 46 98 47 A8 47 76 1C A6 42 F4 D1 BD E8 F8 89 FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_261_1_0 {
	meta:
		name = "_initterm_e"
		size = 48
		refs = "002c __guard_check_icall_fptr"
	strings:
		$1 = { 2D E9 F0 48 0D F1 10 0B 0E 46 04 46 B4 42 0A D0 06 4F 54 F8 04 5B 25 B1 3B 68 28 46 98 47 A8 47 10 B9 B4 42 F5 D1 00 20 BD E8 F0 88 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_4_0 {
	meta:
		name = "?fputwc_binary_nolock@@YAG_WV__crt_stdio_stream@@@Z"
		size = 50
		refs = "0018 __acrt_stdio_flush_and_write_wide_nolock"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 03 91 8B 68 9B 1E 8B 60 03 99 8B 68 00 2B 03 DA ?? ?? ?? ?? 80 B2 04 E0 0B 68 18 80 0B 68 9B 1C 0B 60 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_262_8_0 {
	meta:
		name = "_fputwc_nolock"
		size = 292
		refs = "0008 __security_push_cookie 002a _fileno 00c0 wctomb_s 00da _fputc_nolock 00fc __acrt_stdio_flush_and_write_wide_nolock 0112 __security_pop_cookie 011c __badioinfo 0120 __pioinfo"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B ?? ?? ?? ?? 84 B0 0D 46 EB 68 06 46 BF F3 5B 8F 13 F4 80 5F 18 BF 01 23 08 BF 00 23 00 2B 62 D1 28 46 ?? ?? ?? ?? DF F8 F0 80 3A 4F 10 F1 01 0F 16 D0 28 46 ?? ?? ?? ?? 10 F1 02 0F 10 D0 28 46 ?? ?? ?? ?? 04 46 28 46 ?? ?? ?? ?? 00 F0 3F 03 A1 11 03 EB 43 02 58 F8 21 30 03 EB 02 13 00 E0 3B 46 93 F9 29 30 02 2B 3D D0 01 2B 3B D0 28 46 ?? ?? ?? ?? 10 F1 01 0F 15 D0 28 46 ?? ?? ?? ?? 10 F1 02 0F 0F D0 28 46 ?? ?? ?? ?? 04 46 28 46 ?? ?? ?? ?? 00 F0 3F 03 A1 11 03 EB 43 02 58 F8 21 30 03 EB 02 17 97 F8 28 30 13 F0 80 0F 1A D0 02 A9 68 46 33 46 05 22 ?? ?? ?? ?? 10 B1 4F F6 FF 76 20 E0 00 9B 00 24 00 2B 1C DD 02 AF E0 57 29 46 ?? ?? ?? ?? 10 F1 01 0F F0 D0 00 9B 64 1C 9C 42 F4 DB 0F E0 AB 68 9B 1E AB 60 00 2B 05 DA 29 46 30 46 ?? ?? ?? ?? 86 B2 04 E0 2B 68 1E 80 2B 68 9B 1C 2B 60 30 46 04 B0 ?? ?? ?? ?? BD E8 F0 89 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_5_0 {
	meta:
		name = "_mbbtype_l"
		size = 110
		refs = "0010 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 3F 48 0D F1 18 0B 0C 46 05 46 68 46 11 46 ?? ?? ?? ?? 02 9B 01 2C 13 D0 2B 44 59 7E 11 F0 04 0F 18 BF 01 20 15 D1 01 9B 1B 68 33 F8 15 20 40 F2 57 13 1A 42 02 D1 11 F0 03 0F 08 D0 00 20 08 E0 2B 44 5B 7E 13 F0 08 0F 18 BF 02 20 01 D1 6F F0 00 00 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 04 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "_cgets"
		size = 70
		refs = "000c __doserrno 0014 _errno 001c _invalid_parameter_noinfo 0036 _cgets_s"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 64 B9 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 20 BD E8 18 88 94 F9 00 10 00 29 EE DD 00 23 6A 46 A0 1C 00 93 ?? ?? ?? ?? 00 9B 00 28 63 70 EE D1 A0 1C ED E7 }
	condition:
		$1
}

rule file_264_1_0 {
	meta:
		name = "_cgets_s"
		size = 200
		refs = "0014 __doserrno 001c _errno 0024 _invalid_parameter_noinfo 004e __acrt_lock 0064 _cgetws_s 007a wctomb_s 00a0 __acrt_unlock 00c0 __console_wchar_buffer_used 00c4 __console_wchar_buffer"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 85 B0 6F 46 15 46 0E 46 04 46 64 B9 ?? ?? ?? ?? 00 23 03 60 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 23 3B 60 43 E0 00 2E F0 D0 4F F0 00 08 84 F8 00 80 25 B9 ?? ?? ?? ?? C0 F8 00 80 EA E7 00 23 FB 60 BC 60 09 20 ?? ?? ?? ?? C5 F8 00 80 76 1E C7 F8 10 80 17 F1 10 02 38 1D 02 21 ?? ?? ?? ?? F8 60 C0 B9 BB 88 B3 B1 C7 F8 00 80 38 46 32 46 21 46 ?? ?? ?? ?? 40 B9 3A 68 14 44 BC 60 2B 68 13 44 2B 60 B6 1A E3 D1 05 E0 0C 4A BB 88 13 80 09 4B 01 22 1A 60 09 20 ?? ?? ?? ?? 00 22 BB 68 1A 70 FC 68 14 B1 ?? ?? ?? ?? 04 60 3C 60 38 68 05 B0 BD E8 F0 89 FE DE ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "rand_s"
		size = 58
		refs = "0008 _errno 0010 _invalid_parameter_noinfo 001e __acrt_RtlGenRandom"
	strings:
		$1 = { 2D E9 00 48 EB 46 38 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 0E E0 00 23 04 21 03 60 ?? ?? ?? ?? 38 B9 ?? ?? ?? ?? 0C 23 03 60 ?? ?? ?? ?? 00 68 00 E0 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "ilogbl"
		size = 56
		refs = "0010 _ldunscale"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 02 A9 68 46 8D ED 02 0B ?? ?? ?? ?? 58 B1 01 28 06 D0 02 28 04 D0 BD F9 00 30 5B 1E 18 B2 04 E0 6F F0 00 40 01 E0 4F F0 00 40 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "ilogb"
		size = 56
		refs = "0010 _dunscale"
	strings:
		$1 = { 2D E9 0F 48 0D F1 10 0B 02 A9 68 46 8D ED 02 0B ?? ?? ?? ?? 58 B1 01 28 06 D0 02 28 04 D0 BD F9 00 30 5B 1E 18 B2 04 E0 6F F0 00 40 01 E0 4F F0 00 40 04 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "??$common_strerror@D@@YAPADH@Z"
		size = 124
		refs = "000a __acrt_getptd_noexit 001e _calloc_base 0026 _free_base 0030 __sys_nerr 003a __sys_errlist 005a strncpy_s 0070 _invoke_watson 0078 ??_C@_0EA@FCLIIPNN@Visual?5C?$CL?$CL?5CRT?3?5Not?5enough?5memor@"
		altNames = "strerror"
	strings:
		$1 = { 2D E9 3C 48 0D F1 10 0B 04 46 ?? ?? ?? ?? 05 46 0D B9 19 48 25 E0 2B 6C 53 B9 01 21 86 20 ?? ?? ?? ?? 28 64 00 20 ?? ?? ?? ?? 2B 6C 00 2B F0 D0 ?? ?? ?? ?? 03 68 9C 42 08 D3 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 03 68 54 F8 23 20 03 E0 ?? ?? ?? ?? 50 F8 24 20 28 6C 85 23 86 21 ?? ?? ?? ?? 10 B9 28 6C BD E8 3C 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_3_0 {
	meta:
		name = "??$common_strerror@_W@@YAPA_WH@Z"
		size = 128
		refs = "000a __acrt_getptd_noexit 001e _calloc_base 0026 _free_base 0030 __sys_nerr 003a __sys_errlist 005e mbstowcs_s 0074 _invoke_watson 007c ??_C@_1IA@JENHHBGD@?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAC?$AAR?$AAT?$AA?3?$AA?5?$AAN?$AAo?$AAt?$AA?5?$AAe?$AAn?$AAo?$AAu?$AAg?$AAh?$AA?5?$AAm?$AAe?$AAm?$AAo?$AAr@"
		altNames = "_wcserror"
	strings:
		$1 = { 2D E9 3C 48 0D F1 10 0B 04 46 ?? ?? ?? ?? 05 46 0D B9 1A 48 27 E0 6B 6C 53 B9 02 21 86 20 ?? ?? ?? ?? 68 64 00 20 ?? ?? ?? ?? 6B 6C 00 2B F0 D0 ?? ?? ?? ?? 03 68 9C 42 08 D3 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 03 68 54 F8 23 30 03 E0 ?? ?? ?? ?? 50 F8 24 30 69 6C 85 22 00 92 86 22 00 20 ?? ?? ?? ?? 10 B9 68 6C BD E8 3C 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE FE DE ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_4_0 {
	meta:
		name = "??$common_strerror_s@D@@YAHQADIH@Z"
		size = 120
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0024 __sys_nerr 002e __sys_errlist 0050 strncpy_s 0072 _invoke_watson"
		altNames = "strerror_s"
	strings:
		$1 = { 2D E9 7E 48 0D F1 18 0B 06 46 14 46 0D 46 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 21 E0 00 2D F5 D0 ?? ?? ?? ?? 03 68 9C 42 08 D3 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 03 68 54 F8 23 20 03 E0 ?? ?? ?? ?? 50 F8 24 20 6F F0 00 03 29 46 30 46 ?? ?? ?? ?? 18 B1 16 28 06 D0 22 28 04 D0 50 28 08 BF 00 20 BD E8 7E 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_268_5_0 {
	meta:
		name = "??$common_strerror_s@_W@@YAHQA_WIH@Z"
		size = 124
		refs = "0010 _errno 0018 _invalid_parameter_noinfo 0024 __sys_nerr 002e __sys_errlist 0054 mbstowcs_s 0076 _invoke_watson"
		altNames = "_wcserror_s"
	strings:
		$1 = { 2D E9 7E 48 0D F1 18 0B 06 46 14 46 0D 46 3E B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 20 23 E0 00 2D F5 D0 ?? ?? ?? ?? 03 68 9C 42 08 D3 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 03 68 54 F8 23 30 03 E0 ?? ?? ?? ?? 50 F8 24 30 6F F0 00 02 00 92 2A 46 31 46 00 20 ?? ?? ?? ?? 18 B1 16 28 06 D0 22 28 04 D0 50 28 08 BF 00 20 BD E8 7E 88 00 23 00 22 00 21 00 20 00 93 ?? ?? ?? ?? FE DE }
	condition:
		$1
}

rule file_268_10_0 {
	meta:
		name = "?copy_string_into_buffer@@YAHQBDQADII@Z"
		size = 26
		refs = "0012 strncpy_s"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 14 46 0D 46 02 46 21 46 28 46 ?? ?? ?? ?? BD E8 30 88 }
	condition:
		$1
}

rule file_268_11_0 {
	meta:
		name = "?copy_string_into_buffer@@YAHQBDQA_WII@Z"
		size = 24
		refs = "0010 mbstowcs_s"
	strings:
		$1 = { 2D E9 1E 48 0D F1 10 0B 1C 46 03 46 00 20 00 94 ?? ?? ?? ?? BD E8 1E 88 }
	condition:
		$1
}

rule file_268_20_0 {
	meta:
		name = "_get_sys_err_msg"
		size = 50
		refs = "000a __sys_nerr 0014 __sys_errlist"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 ?? ?? ?? ?? 03 68 9C 42 08 D3 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 03 68 54 F8 23 00 03 E0 ?? ?? ?? ?? 50 F8 24 00 BD E8 18 88 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "scalbnf"
		size = 64
		refs = "0014 _fdtest 0020 _fdscale 0030 _fperrraise"
		altNames = "scalblnf"
	strings:
		$1 = { 03 B4 2D E9 18 48 0D F1 08 0B 04 46 8D ED 00 0A 94 B1 68 46 ?? ?? ?? ?? 00 28 0B DA 68 46 21 46 ?? ?? ?? ?? 18 B1 01 28 04 D1 08 20 00 E0 10 20 ?? ?? ?? ?? 9D ED 00 0A BD E8 18 08 5D F8 0C FB }
	condition:
		$1
}

rule file_270_1_0 {
	meta:
		name = "casinhl"
		size = 612
		refs = "0016 creall 002a cimagl 0034 _ldtest 00ea _LCbuild 00ee csqrtl 01c4 asinhl 01e4 log 0206 _LCmulcc 0216 atan2 0250 _LZero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 11 D1 02 28 0A D0 48 B1 01 28 04 D1 9D ED 00 8B 9D ED 02 0B E0 E0 9D ED 02 8B 0A E0 9D ED 02 8B 9D ED 00 0B D8 E0 02 28 06 D1 01 2C F6 D0 9D ED 00 8B B0 EE 48 0B CF E0 01 2C 1E D1 9D ED 02 8B 01 28 0C D1 9D ED 00 0B B5 EE C0 0B F1 EE 10 FA 02 D2 9F ED 71 0B BF E0 9F ED 6E 0B BC E0 BD F8 06 30 13 F4 00 4F 05 D0 69 4B 93 ED 00 0B B1 EE 40 0B B1 E0 9F ED 5E 0B AE E0 01 28 0C D1 9D ED 00 8B B5 EE C0 8B F1 EE 10 FA 02 D2 9F ED 5E 0B A2 E0 9F ED 5A 0B 9F E0 9D ED 00 0B 9D ED 02 1B B7 EE 00 8B 38 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 02 2B 9D ED 00 3B B0 EE 41 CB B0 EE 40 DB B1 EE 42 1B 33 EE 08 0B ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 02 8B B0 EE 41 EB B0 EE 40 FB B5 EE 40 8B F1 EE 10 FA 66 D0 B0 EE 4D 0B B0 EE 4C 1B ?? ?? ?? ?? B0 EE 4C 1B B0 EE 40 AB B0 EE 4D 0B ?? ?? ?? ?? B0 EE 4E 1B B0 EE 40 8B B0 EE 4F 0B ?? ?? ?? ?? B0 EE 4E 1B B0 EE 40 BB B0 EE 4F 0B ?? ?? ?? ?? 9F ED 34 1B B4 EE CA 1B F1 EE 10 FA 08 D2 8B EE 0A 2B B0 EE 4A 9B 22 EE 08 2B 32 EE 40 0B 1F E0 B4 EE C8 1B F1 EE 10 FA 04 D2 80 EE 08 0B B0 EE 48 9B 08 E0 B1 EE 48 9B B4 EE C9 1B F1 EE 10 FA 06 D2 80 EE 09 0B 20 EE 0A 0B 3B EE 40 0B 07 E0 2B EE 08 3B 20 EE 0A 2B 9F ED 1C 9B 33 EE 42 0B ?? ?? ?? ?? B5 EE 40 9B B0 EE 40 8B F1 EE 10 FA 0F D0 B5 EE C0 0B B0 EE 49 0B F1 EE 10 FA 04 DB ?? ?? ?? ?? 38 EE 00 8B 03 E0 ?? ?? ?? ?? 38 EE 40 8B B0 EE 4E 3B B0 EE 4F 2B B0 EE 4C 1B B0 EE 4D 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 40 1B 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 1B B0 EE 48 0B ?? ?? ?? ?? 09 B0 BD EC 10 8B BD E8 10 88 00 00 00 00 00 00 00 00 7B 52 82 BD 3A FB CF 5F 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 F9 BF ?? ?? ?? ?? 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 E9 BF }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "casinh"
		size = 612
		refs = "0016 creal 002a cimag 0034 _dtest 00ea _Cbuild 00ee csqrt 01c4 asinh 01e4 log 0206 _Cmulcc 0216 atan2 0250 _Zero_C"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 2D ED 10 8B 89 B0 8D ED 06 1B 8D ED 04 0B ?? ?? ?? ?? 9D ED 06 1B B0 EE 40 2B 9D ED 04 0B 8D ED 02 2B ?? ?? ?? ?? 02 A8 8D ED 00 0B ?? ?? ?? ?? 04 46 68 46 ?? ?? ?? ?? 02 2C 11 D1 02 28 0A D0 48 B1 01 28 04 D1 9D ED 00 8B 9D ED 02 0B E0 E0 9D ED 02 8B 0A E0 9D ED 02 8B 9D ED 00 0B D8 E0 02 28 06 D1 01 2C F6 D0 9D ED 00 8B B0 EE 48 0B CF E0 01 2C 1E D1 9D ED 02 8B 01 28 0C D1 9D ED 00 0B B5 EE C0 0B F1 EE 10 FA 02 D2 9F ED 71 0B BF E0 9F ED 6E 0B BC E0 BD F8 06 30 13 F4 00 4F 05 D0 69 4B 93 ED 00 0B B1 EE 40 0B B1 E0 9F ED 5E 0B AE E0 01 28 0C D1 9D ED 00 8B B5 EE C0 8B F1 EE 10 FA 02 D2 9F ED 5E 0B A2 E0 9F ED 5A 0B 9F E0 9D ED 00 0B 9D ED 02 1B B7 EE 00 8B 38 EE 40 0B ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 02 2B 9D ED 00 3B B0 EE 41 CB B0 EE 40 DB B1 EE 42 1B 33 EE 08 0B ?? ?? ?? ?? ?? ?? ?? ?? 9D ED 02 8B B0 EE 41 EB B0 EE 40 FB B5 EE 40 8B F1 EE 10 FA 66 D0 B0 EE 4D 0B B0 EE 4C 1B ?? ?? ?? ?? B0 EE 4C 1B B0 EE 40 AB B0 EE 4D 0B ?? ?? ?? ?? B0 EE 4E 1B B0 EE 40 8B B0 EE 4F 0B ?? ?? ?? ?? B0 EE 4E 1B B0 EE 40 BB B0 EE 4F 0B ?? ?? ?? ?? 9F ED 34 1B B4 EE CA 1B F1 EE 10 FA 08 D2 8B EE 0A 2B B0 EE 4A 9B 22 EE 08 2B 32 EE 40 0B 1F E0 B4 EE C8 1B F1 EE 10 FA 04 D2 80 EE 08 0B B0 EE 48 9B 08 E0 B1 EE 48 9B B4 EE C9 1B F1 EE 10 FA 06 D2 80 EE 09 0B 20 EE 0A 0B 3B EE 40 0B 07 E0 2B EE 08 3B 20 EE 0A 2B 9F ED 1C 9B 33 EE 42 0B ?? ?? ?? ?? B5 EE 40 9B B0 EE 40 8B F1 EE 10 FA 0F D0 B5 EE C0 0B B0 EE 49 0B F1 EE 10 FA 04 DB ?? ?? ?? ?? 38 EE 00 8B 03 E0 ?? ?? ?? ?? 38 EE 40 8B B0 EE 4E 3B B0 EE 4F 2B B0 EE 4C 1B B0 EE 4D 0B ?? ?? ?? ?? ?? ?? ?? ?? B0 EE 40 1B 9D ED 00 0B ?? ?? ?? ?? B0 EE 40 1B B0 EE 48 0B ?? ?? ?? ?? 09 B0 BD EC 10 8B BD E8 10 88 00 00 00 00 00 00 00 00 7B 52 82 BD 3A FB CF 5F 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 F9 BF ?? ?? ?? ?? 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 E9 BF }
	condition:
		$1
}

rule file_271_4_0 {
	meta:
		name = "_towlower_l"
		size = 152
		refs = "001a ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0046 iswctype 0068 __acrt_LCMapStringW"
	strings:
		$1 = { 03 B4 2D E9 10 48 0D F1 04 0B 89 B0 4F F6 FF 73 98 42 AD F8 30 00 3A D0 04 A8 ?? ?? ?? ?? 05 9B D3 F8 A8 40 44 B9 BD F8 30 30 41 2B 02 D3 5A 2B 98 BF 20 33 99 B2 1F E0 BD F8 30 00 4F F4 80 71 88 42 0A D2 01 21 ?? ?? ?? ?? 80 B1 05 9B D3 F8 94 20 BD F8 30 30 99 5C 0E E0 01 23 01 93 02 AB 00 93 01 23 0C AA 20 46 ?? ?? ?? ?? 10 B9 BD F8 30 10 01 E0 BD F8 08 10 9D F8 1C 30 33 B1 04 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 08 46 09 B0 BD E8 10 08 5D F8 0C FB }
	condition:
		$1
}

rule file_272_33_0 {
	meta:
		name = "?common_flush_all@@YAH_N@Z"
		size = 68
		refs = "002a ??$?RV<lambda_2cc53f568c5a2bb6f192f930a45d44ea>@@AAV<lambda_ab61a845afdef5b7c387490eaf3616ee>@@V<lambda_c2ffc0b7726aa6be21d5f0026187e748>@@@?$__crt_seh_guarded_call@X@@QAAX$$QAV<lambda_2cc53f568c5a2bb6f192f930a45d44ea>@@AAV<lambda_ab61a845afdef5b7c387490eaf3616ee>@@$$QAV<lambda_c2ffc0b7726aa6be21d5f0026187e748>@@@Z"
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 8A B0 00 23 CD E9 01 33 01 AB 06 93 0C AB 07 93 02 AB 08 93 08 23 CD E9 03 33 03 AB 06 AA 04 A9 68 46 ?? ?? ?? ?? 9D F8 30 30 0B B1 01 98 00 E0 02 98 0A B0 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_272_34_0 {
	meta:
		name = "?common_flush_all_should_try_to_flush_stream@@YA_NV__crt_stdio_stream@@QAH@Z"
		size = 76
	strings:
		$1 = { 03 B4 2D E9 00 48 EB 46 02 90 08 B9 00 20 19 E0 C2 68 BF F3 5B 8F 12 F4 00 5F 18 BF 01 23 08 BF 00 23 00 2B F2 D0 02 F0 03 03 02 2B 02 D1 12 F0 C0 0F 06 D1 12 F4 00 6F 03 D1 0B 68 5B 1C 0B 60 E4 E7 01 20 5D F8 04 BB 5D F8 0C FB }
	condition:
		$1
}

rule file_272_37_0 {
	meta:
		name = "?is_stream_allocated@@YA_NJ@Z"
		size = 22
	strings:
		$1 = { 2D E9 00 48 EB 46 10 F4 00 5F 18 BF 01 20 08 BF 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_272_38_0 {
	meta:
		name = "?is_stream_flushable@@YA_NJ@Z"
		size = 30
	strings:
		$1 = { 2D E9 00 48 EB 46 00 F0 03 03 02 2B 01 D0 00 20 03 E0 10 F0 C0 0F FA D0 01 20 BD E8 00 88 }
	condition:
		$1
}

rule file_272_39_0 {
	meta:
		name = "?is_stream_flushable_or_commitable@@YA_NJ@Z"
		size = 36
	strings:
		$1 = { 2D E9 00 48 EB 46 00 F0 03 03 02 2B 04 D1 10 F0 C0 0F 01 D0 01 20 03 E0 10 F4 00 6F FA D1 00 20 BD E8 00 88 }
	condition:
		$1
}

rule file_272_44_0 {
	meta:
		name = "__acrt_stdio_flush_nolock"
		size = 146
		refs = "0032 _fileno 003a _write"
	strings:
		$1 = { 2D E9 78 48 0D F1 10 0B 00 F1 0C 05 2A 68 04 46 BF F3 5B 8F 02 F0 03 03 02 2B 37 D1 12 F0 C0 0F 34 D0 D4 E9 00 32 9E 1A 00 23 22 60 A3 60 00 2E 2C DD ?? ?? ?? ?? 61 68 32 46 ?? ?? ?? ?? 86 42 0E D0 BF F3 5B 8F 55 E8 00 1F 41 F0 10 02 45 E8 00 23 00 2B F7 D1 BF F3 5B 8F 6F F0 00 00 16 E0 2B 68 BF F3 5B 8F 13 F0 04 0F 18 BF 01 23 08 BF 00 23 5B B1 BF F3 5B 8F 55 E8 00 1F 21 F0 02 02 45 E8 00 23 00 2B F7 D1 BF F3 5B 8F 00 20 BD E8 78 88 }
	condition:
		$1
}

rule file_272_45_0 {
	meta:
		name = "_fflush_nolock"
		size = 74
		refs = "000e ?common_flush_all@@YAH_N@Z 0016 __acrt_stdio_flush_nolock 0038 _fileno 003c _commit"
	strings:
		$1 = { 2D E9 18 48 0D F1 08 0B 04 46 1C B9 00 20 ?? ?? ?? ?? 18 E0 20 46 ?? ?? ?? ?? 10 B1 6F F0 00 00 11 E0 E3 68 BF F3 5B 8F 13 F4 00 6F 18 BF 01 23 08 BF 00 23 33 B1 20 46 ?? ?? ?? ?? ?? ?? ?? ?? 00 28 EB D1 00 20 BD E8 18 88 }
	condition:
		$1
}

rule file_272_46_0 {
	meta:
		name = "_flushall"
		size = 16
		refs = "000c ?common_flush_all@@YAH_N@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 01 20 BD E8 00 48 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_272_47_0 {
	meta:
		name = "fflush"
		size = 78
		refs = "000e ?common_flush_all@@YAH_N@Z 0044 ??$?RV<lambda_6d20deecaf4856105ebacbad442d1079>@@AAV<lambda_9a32fed5bf61b6b509b2d3f6003082a1>@@V<lambda_63ea2239ed67c638ddbae41947fdf875>@@@?$__crt_seh_guarded_call@H@@QAAH$$QAV<lambda_6d20deecaf4856105ebacbad442d1079>@@AAV<lambda_9a32fed5bf61b6b509b2d3f6003082a1>@@$$QAV<lambda_63ea2239ed67c638ddbae41947fdf875>@@@Z"
	strings:
		$1 = { 2D E9 00 48 EB 46 86 B0 01 90 18 B9 00 20 ?? ?? ?? ?? 19 E0 C2 68 BF F3 5B 8F 02 F0 03 03 02 2B 02 D1 12 F0 C0 0F 04 D1 12 F4 00 6F 08 BF 00 20 0A D0 01 AB 03 93 01 9B 03 AA 04 A9 02 93 04 93 02 AB 68 46 ?? ?? ?? ?? 06 B0 BD E8 00 88 }
	condition:
		$1
}

rule file_274_5_0 {
	meta:
		name = "_mbsstr_l"
		size = 194
		refs = "0012 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 0024 strstr 002e _errno 0036 _invalid_parameter_noinfo 0064 strlen"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 85 B0 0E 46 05 46 68 46 11 46 ?? ?? ?? ?? DD F8 08 80 D8 F8 08 30 2B B9 31 46 28 46 ?? ?? ?? ?? 05 46 07 E0 A6 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 00 25 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 28 46 05 B0 BD E8 F0 89 33 78 00 2B EE D0 00 2D E5 D0 28 46 ?? ?? ?? ?? 04 46 30 46 ?? ?? ?? ?? 23 1A 5F 19 2B 78 00 2B DF D0 AA 1B BD 42 DC D8 15 F8 01 4B 31 46 44 B1 08 78 30 B1 53 5C 83 42 03 D1 49 1C 53 5C 00 2B F6 D1 0B 78 7B B1 04 EB 08 03 5B 7E 02 F1 01 02 13 F0 04 0F 03 D0 2B 78 0B B1 6D 1C 52 1C 2B 78 00 2B DF D1 BD E7 6D 1E BC E7 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__acrt_CompareStringW"
		size = 102
		refs = "001a wcsnlen 0048 __acrt_CompareStringEx"
	strings:
		$1 = { 2D E9 F0 49 0D F1 14 0B 87 B0 1C 46 00 2C 16 46 0F 46 80 46 04 DD 19 46 10 46 ?? ?? ?? ?? 04 46 0F 98 0E 9D 00 28 03 DD 01 46 28 46 ?? ?? ?? ?? 6C B1 60 B1 00 23 04 93 03 93 02 93 01 90 23 46 32 46 39 46 40 46 00 95 ?? ?? ?? ?? 08 E0 23 1A 08 BF 02 20 04 D0 00 2B B8 BF 01 20 A8 BF 03 20 07 B0 BD E8 F0 89 }
	condition:
		$1
}

rule file_276_4_0 {
	meta:
		name = "_wcscoll_l"
		size = 120
		refs = "0012 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 001a _errno 0022 _invalid_parameter_noinfo 0034 wcscmp 0048 __acrt_CompareStringW"
	strings:
		$1 = { 2D E9 30 48 0D F1 08 0B 86 B0 0C 46 05 46 02 A8 11 46 ?? ?? ?? ?? 05 B1 34 B9 ?? ?? ?? ?? 16 23 03 60 ?? ?? ?? ?? 16 E0 03 9B D3 F8 A4 00 20 B9 21 46 28 46 ?? ?? ?? ?? 11 E0 6F F0 00 03 2A 46 4F F4 80 51 01 93 00 94 ?? ?? ?? ?? 30 B9 ?? ?? ?? ?? 16 23 03 60 6F F0 00 40 00 E0 80 1E 9D F8 14 30 33 B1 02 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 06 B0 BD E8 30 88 }
	condition:
		$1
}

rule file_277_5_0 {
	meta:
		name = "_ismbclegal_l"
		size = 78
		refs = "000e ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 04 46 68 46 ?? ?? ?? ?? 02 9A 23 0A 52 FA 83 F3 5B 7E 13 F0 04 0F 07 D0 52 FA 84 F3 5B 7E 13 F0 08 0F 18 BF 01 20 00 D1 00 20 9D F8 0C 30 33 B1 00 9A D2 F8 50 33 23 F0 02 03 C2 F8 50 33 05 B0 BD E8 10 88 }
	condition:
		$1
}

rule file_278_1_0 {
	meta:
		name = "sqrt"
		size = 124
		refs = "0026 _handle_nan 004a _handle_error 006c ??_C@_04EIAKFFMI@sqrt?$AA@"
	strings:
		$1 = { 2D E9 10 48 0D F1 04 0B 85 B0 1B 4A 51 EC 10 0B 4F F0 00 44 01 EA 02 03 93 42 19 D1 0B 46 6F F3 1F 53 03 43 02 D0 ?? ?? ?? ?? 19 E0 21 42 0F D0 21 22 02 92 01 23 08 22 9F ED 0D 1B 0B 48 03 93 00 93 09 4B 01 92 00 22 05 21 ?? ?? ?? ?? 07 E0 21 42 03 D0 21 EA 04 03 03 43 E9 D1 B1 EE C0 0B 05 B0 BD E8 10 88 FE DE 00 00 F8 FF ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F0 7F }
	condition:
		$1
}

rule file_280_4_0 {
	meta:
		name = "_mbsnset_s_l"
		size = 396
		refs = "0036 ??0_LocaleUpdate@@QAA@QAU__crt_locale_pointers@@@Z 004c _strnset_s 013e _errno 0146 _invalid_parameter_noinfo"
	strings:
		$1 = { 2D E9 F0 4F 0D F1 1C 0B 85 B0 00 25 98 46 16 46 0C 46 07 46 4F F0 00 09 2B B9 3F B9 00 2C 40 F0 AB 80 00 20 AF E0 00 2F 00 F0 A6 80 00 2C 00 F0 A3 80 0E 99 68 46 ?? ?? ?? ?? DD F8 08 E0 DE F8 08 30 33 B9 43 46 32 46 21 46 38 46 ?? ?? ?? ?? 87 E0 33 0A D9 B2 3A 46 F6 B2 4F F0 00 0A 89 B3 B6 B3 01 EB 0E 03 5B 7E 04 20 03 42 30 D0 3B 78 1F E0 B8 F1 00 0F 47 D0 64 1E 42 D0 53 78 DB B1 0D B1 00 25 04 E0 13 78 73 44 5B 7E 03 EA 00 05 11 70 52 1C 64 1E 34 D0 0D B1 00 25 04 E0 13 78 73 44 5B 7E 03 EA 00 05 16 70 52 1C 13 78 A8 F1 01 08 00 2B DD D1 24 E0 82 F8 00 A0 64 1C 4F F0 01 09 1E E0 06 EB 0E 03 5B 7E 04 20 03 42 02 D0 00 23 3B 70 3E E0 3B 7