private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__wstrdate"
		size = 125
		refs = "000f __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8D 45 F0 50 FF 15 ?? ?? ?? ?? 0F B7 45 F0 99 6A 64 59 F7 F9 0F B7 75 F2 8B C6 6A 0A 5E 8B 4D 08 0F B7 7D F6 66 83 61 10 00 66 C7 41 0A 2F 00 66 C7 41 04 2F 00 8B DA 99 F7 FE 83 C0 30 66 89 01 83 C2 30 66 89 51 02 8B C7 99 F7 FE 5F 83 C0 30 66 89 41 06 83 C2 30 66 89 51 08 8B C3 99 F7 FE 5E 5B 83 C0 30 83 C2 30 66 89 41 0C 66 89 51 0E 8B C1 C9 C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__wspawnlpe"
		size = 37
		refs = "001d __wspawnvpe"
	strings:
		$1 = { 8D 44 24 0C 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_642_0_0 {
	meta:
		name = "__spawnle"
		size = 37
		refs = "001d __spawnve"
	strings:
		$1 = { 8D 44 24 0C 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "__spawnlpe"
		size = 37
		refs = "001d __spawnvpe"
	strings:
		$1 = { 8D 44 24 0C 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_601_0_0 {
	meta:
		name = "__wspawnle"
		size = 37
		refs = "001d __wspawnve"
	strings:
		$1 = { 8D 44 24 0C 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "_memchr"
		size = 173
	strings:
		$1 = { 8B 44 24 0C 53 85 C0 74 52 8B 54 24 08 33 DB 8A 5C 24 0C F7 C2 03 00 00 00 74 16 8A 0A 83 C2 01 32 CB 74 72 83 E8 01 74 32 F7 C2 03 00 00 00 75 EA 83 E8 04 72 12 57 8B FB C1 E3 08 03 DF 8B FB C1 E3 10 03 DF EB 1B 5F 83 C0 04 74 0E 8A 0A 83 C2 01 32 CB 74 40 83 E8 01 75 F2 5B C3 83 E8 04 72 E5 8B 0A 33 CB BF FF FE FE 7E 03 F9 83 F1 FF 33 CF 83 C2 04 81 E1 00 01 01 81 74 E0 8B 4A FC 32 CB 74 23 32 EB 74 19 C1 E9 10 32 CB 74 0C 32 EB 74 02 EB C8 5F 8D 42 FF 5B C3 8D 42 FE 5F 5B C3 8D 42 FD 5F 5B C3 8D 42 FC 5F 5B C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "_comexecmd"
		size = 83
		refs = "0017 __cenvarg 0035 __dospawn 003f _free"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 0C 8D 45 F8 50 8D 45 FC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 04 0B C0 C9 C3 56 FF 75 F8 FF 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "_wcomexecmd"
		size = 83
		refs = "0017 __wcenvarg 0035 __wdospawn 003f _free"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 0C 8D 45 F8 50 8D 45 FC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 04 0B C0 C9 C3 56 FF 75 F8 FF 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_3_1_0 {
	meta:
		name = "__spawnve"
		size = 329
		refs = "0011 __mbsrchr 002e __mbschr 003c _strlen 0045 _malloc 0052 ??_C@_02CEGDFPFP@?4?2?$AA@ 0058 _strcpy 005f _strcat 008b __access 00a5 _comexecmd 00e8 _ext_strings 012e _free"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 0C 56 57 6A 5C 53 8B FB E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 45 85 F6 75 4B 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 75 3B 53 E8 ?? ?? ?? ?? 83 C0 03 50 E8 ?? ?? ?? ?? 8B F8 85 FF 59 59 74 7D 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 53 57 E8 ?? ?? ?? ?? 83 C4 10 8D 77 02 EB 0A 85 F6 74 04 3B C6 76 02 8B F0 83 4D F8 FF 6A 2E 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 2D 6A 00 57 E8 ?? ?? ?? ?? 83 F8 FF 59 59 0F 84 9C 00 00 00 FF 75 14 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 E9 82 00 00 00 57 E8 ?? ?? ?? ?? 83 C0 05 50 E8 ?? ?? ?? ?? 8B D8 85 DB 59 59 89 5D FC 75 05 83 C8 FF EB 71 57 53 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 03 F3 BB ?? ?? ?? ?? FF 33 56 E8 ?? ?? ?? ?? 6A 00 FF 75 FC E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 0D 83 EB 04 81 FB ?? ?? ?? ?? 7D DB EB 17 FF 75 14 FF 75 10 FF 75 FC FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 FF 75 FC E8 ?? ?? ?? ?? 8B 5D 0C 59 3B FB 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 F8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__CItan"
		size = 178
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003e ___fastflag 0045 __fast_exit 0050 _NAME_ 0055 __math_exit 005b __pi_by_2_to_61 0072 __convertTOStoQNaN 008a __indefinite 00ac __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 54 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 F2 9B DF E0 9E 7A 1F DD D8 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 F2 DD D8 EB CB E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "_tolower"
		size = 213
		refs = "0007 ___lc_handle 001a ___lc_clike 0038 ___mb_cur_max 0041 __isctype 004a __pctype 0088 ___lc_codepage 009f ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 51 51 83 3D ?? ?? ?? ?? 00 53 8B 5D 08 56 57 0F 84 A9 00 00 00 83 3D ?? ?? ?? ?? 00 74 09 83 FB 7F 0F 86 97 00 00 00 33 F6 BF 00 01 00 00 46 3B DF 73 22 39 35 ?? ?? ?? ?? 7E 0B 56 53 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B6 04 58 23 C6 85 C0 74 76 8B 15 ?? ?? ?? ?? 8B C3 C1 F8 08 0F B6 C8 F6 44 4A 01 80 74 0F 6A 02 88 45 FC 88 5D FD C6 45 FE 00 58 EB 09 88 5D FC C6 45 FD 00 8B C6 56 FF 35 ?? ?? ?? ?? 8D 4D F8 6A 03 51 50 8D 45 FC 50 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 24 3B C6 75 06 0F B6 45 F8 EB 1C 0F B6 4D F9 33 C0 8A 65 F8 0B C1 EB 0F 83 FB 41 7C 08 83 FB 5A 8D 43 20 7E 02 8B C3 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__mbctokata"
		size = 35
		refs = "0007 __ismbchira"
	strings:
		$1 = { 56 8B 74 24 08 56 E8 ?? ?? ?? ?? 85 C0 59 74 0F 81 C6 A1 00 00 00 81 FE 7F 83 00 00 72 01 46 8B C6 5E C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__ismbcalpha"
		size = 137
		refs = "0023 ___ismbcodepage 0035 ___mblcid 003e ___mbcodepage 004c ___crtGetStringTypeA 0070 __pctype 007e __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5C 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 74 54 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 2E 66 83 7D FE 00 75 27 66 F7 45 FC 03 01 74 1F 33 C0 40 C9 C3 0F B6 C1 8B 0D ?? ?? ?? ?? 66 F7 04 41 03 01 75 EA F6 80 ?? ?? ?? ?? 01 75 E1 33 C0 C9 C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__purecall"
		size = 20
		refs = "0001 ___pPurecall 000e __amsg_exit"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 02 FF D0 6A 19 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_strtod"
		size = 152
		refs = "000a ___mb_cur_max 0018 __isctype 0022 __pctype 003a _strlen 0042 __fltin 0075 __HUGE 007f _errno"
	strings:
		$1 = { 56 57 8B 7C 24 0C 8B F7 83 3D ?? ?? ?? ?? 01 0F B6 06 7E 0C 6A 08 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 08 85 C0 74 03 46 EB D4 6A 00 6A 00 56 E8 ?? ?? ?? ?? 59 50 56 E8 ?? ?? ?? ?? 8B 4C 24 20 83 C4 10 85 C9 74 07 8B 50 04 03 D6 89 11 8B 10 66 F7 C2 40 02 74 0A 85 C9 D9 EE 74 2E 89 39 EB 2A F6 C2 81 74 19 80 3E 2D DD 05 ?? ?? ?? ?? 75 02 D9 E0 C7 05 ?? ?? ?? ?? 22 00 00 00 EB 0C F6 C6 01 74 04 D9 EE EB EB DD 40 10 5F 5E C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_ctime"
		size = 25
		refs = "0005 _localtime 0010 _asctime"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? 85 C0 59 74 08 50 E8 ?? ?? ?? ?? 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__ctime64"
		size = 25
		refs = "0005 __localtime64 0010 _asctime"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? 85 C0 59 74 08 50 E8 ?? ?? ?? ?? 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_613_0_0 {
	meta:
		name = "__wctime"
		size = 25
		refs = "0005 _localtime 0010 __wasctime"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? 85 C0 59 74 08 50 E8 ?? ?? ?? ?? 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_658_0_0 {
	meta:
		name = "__wctime64"
		size = 25
		refs = "0005 __localtime64 0010 __wasctime"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? 85 C0 59 74 08 50 E8 ?? ?? ?? ?? 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "__mbsnextc"
		size = 41
		refs = "000c __mbctype"
	strings:
		$1 = { 8B 4C 24 04 0F B6 01 56 33 F6 F6 80 ?? ?? ?? ?? 04 74 0F 8D 51 01 80 3A 00 74 07 C1 E0 08 8B F0 8B CA 0F B6 01 03 C6 5E C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "?name@type_info@@QBEPBDXZ"
		size = 112
		refs = "0010 _free 0015 _malloc 0022 ___unDName 0031 _strlen 005d _strcpy"
	strings:
		$1 = { 56 57 8B F9 83 7F 04 00 75 60 68 00 28 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 8D 47 09 50 6A 00 E8 ?? ?? ?? ?? 8B F0 83 C4 18 85 F6 74 3E 56 E8 ?? ?? ?? ?? 48 59 03 C6 EB 04 C6 00 00 48 80 38 20 74 F7 56 E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 85 C0 59 59 89 47 04 74 09 56 50 E8 ?? ?? ?? ?? 59 59 56 E8 ?? ?? ?? ?? 59 8B 47 04 5F 5E C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__mbsnbicoll"
		size = 63
		refs = "000f ___mbcodepage 0023 ___mblcid 0028 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 FF 35 ?? ?? ?? ?? FF 75 10 FF 75 0C FF 75 10 FF 75 08 6A 01 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 07 B8 FF FF FF 7F 5D C3 83 C0 FE 5D C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__aulldvrm"
		size = 149
	strings:
		$1 = { 56 8B 44 24 14 0B C0 75 28 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B D8 8B 44 24 08 F7 F1 8B F0 8B C3 F7 64 24 10 8B C8 8B C6 F7 64 24 10 03 D1 EB 47 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 14 8B C8 8B 44 24 10 F7 E6 03 D1 72 0E 3B 54 24 0C 77 08 72 0F 3B 44 24 08 76 09 4E 2B 44 24 10 1B 54 24 14 33 DB 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 5E C2 10 00 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__strncoll"
		size = 102
		refs = "001a _errno 0027 ___lc_handle 0037 _strncmp 0042 ___lc_collate_cp 0055 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 8B 4D 10 85 C9 75 04 33 C0 5D C3 56 BE FF FF FF 7F 3B CE 76 0E C7 05 ?? ?? ?? ?? 16 00 00 00 8B C6 EB 3D A1 ?? ?? ?? ?? 85 C0 75 11 51 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 23 FF 35 ?? ?? ?? ?? 51 FF 75 0C 51 FF 75 08 68 00 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 B8 83 C0 FE 5E 5D C3 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__wcsncoll"
		size = 102
		refs = "001a _errno 0027 ___lc_handle 0037 _wcsncmp 0042 ___lc_collate_cp 0055 ___crtCompareStringW"
	strings:
		$1 = { 55 8B EC 8B 4D 10 85 C9 75 04 33 C0 5D C3 56 BE FF FF FF 7F 3B CE 76 0E C7 05 ?? ?? ?? ?? 16 00 00 00 8B C6 EB 3D A1 ?? ?? ?? ?? 85 C0 75 11 51 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 23 FF 35 ?? ?? ?? ?? 51 FF 75 0C 51 FF 75 08 68 00 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 B8 83 C0 FE 5E 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__mbsncpy"
		size = 118
		refs = "0005 ___ismbcodepage 001b _strncpy 0037 __mbctype"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 56 57 8B 7D 08 8B F7 75 11 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C EB 42 8B 4D 10 85 C9 74 39 8B 55 0C 53 8A 02 0F B6 D8 49 F6 83 ?? ?? ?? ?? 04 88 07 74 2A 47 42 8A 02 88 07 47 42 84 C0 75 24 88 47 FE 85 C9 74 10 8B D1 C1 E9 02 33 C0 F3 AB 8B CA 83 E1 03 F3 AA 5B 8B C6 5F 5E 5D C3 47 42 84 C0 74 DF 85 C9 75 BB EB ED }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_fwprintf"
		size = 50
		refs = "0009 __stbuf 001a __woutput 0025 __ftbuf"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 08 8B F8 56 E8 ?? ?? ?? ?? 83 C4 18 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "_fprintf"
		size = 50
		refs = "0009 __stbuf 001a __output 0025 __ftbuf"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 08 8B F8 56 E8 ?? ?? ?? ?? 83 C4 18 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "___libm_error_support"
		size = 652
		refs = "0007 ___security_cookie 0051 ??_C@_03KHJOGHMM@exp?$AA@ 0070 ??_C@_05HGHHAHAP@log10?$AA@ 008b ??_C@_03MGHMBJCF@log?$AA@ 00ad ??_C@_03JGHBODFD@pow?$AA@ 011c __pmatherr 0182 ??_C@_04KGLCPMCP@log2?$AA@ 01a5 ??_C@_05EOHGHCHD@exp10?$AA@ 01b5 ??_C@_04HPAFEEIN@exp2?$AA@ 01e6 _errno 0212 ??_C@_04EHEDPDJG@modf?$AA@ 022a ??_C@_05PBJFFIGL@floor?$AA@ 0233 ??_C@_04GFPJNGEK@ceil?$AA@ 023c ??_C@_04MLLJIGOK@atan?$AA@ 0286 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 89 45 FC 8B 45 14 B9 A1 00 00 00 3B C1 56 0F 8F 13 01 00 00 0F 84 01 01 00 00 83 F8 18 0F 8F 88 00 00 00 74 73 6A 02 59 2B C1 74 5D 48 74 4E 83 E8 05 74 3A 48 74 2B 83 E8 05 74 13 48 0F 85 33 02 00 00 C7 45 E0 ?? ?? ?? ?? E9 9D 00 00 00 C7 45 DC 03 00 00 00 C7 45 E0 ?? ?? ?? ?? E9 4C 01 00 00 C7 45 E0 ?? ?? ?? ?? E9 A6 01 00 00 89 4D DC C7 45 E0 ?? ?? ?? ?? E9 31 01 00 00 C7 45 E0 ?? ?? ?? ?? E9 8B 01 00 00 89 4D DC C7 45 E0 ?? ?? ?? ?? E9 16 01 00 00 C7 45 DC 03 00 00 00 C7 45 E0 ?? ?? ?? ?? E9 03 01 00 00 83 E8 19 74 35 48 74 26 48 74 1A 48 0F 84 50 01 00 00 48 0F 85 B2 01 00 00 C7 45 E0 ?? ?? ?? ?? E9 65 01 00 00 C7 45 DC 02 00 00 00 EB C6 8B 45 10 D9 E8 DD 18 E9 91 01 00 00 C7 45 E0 ?? ?? ?? ?? 8B 45 08 DD 00 8B 45 0C 8B 75 10 DD 5D E4 DD 00 8D 45 DC DD 5D EC 50 DD 06 C7 45 DC 04 00 00 00 DD 5D F4 FF 15 ?? ?? ?? ?? 59 E9 56 01 00 00 C7 45 DC 03 00 00 00 E9 80 00 00 00 B9 EA 03 00 00 3B C1 0F 8F BD 00 00 00 0F 84 AE 00 00 00 2D A2 00 00 00 74 5F 83 E8 04 74 4A 83 E8 04 74 35 48 74 26 2D 3D 03 00 00 74 13 48 0F 85 1A 01 00 00 C7 45 E0 ?? ?? ?? ?? E9 CD 00 00 00 C7 45 E0 ?? ?? ?? ?? E9 C1 00 00 00 C7 45 E0 ?? ?? ?? ?? E9 94 00 00 00 C7 45 DC 02 00 00 00 C7 45 E0 ?? ?? ?? ?? EB 1E C7 45 DC 03 00 00 00 C7 45 E0 ?? ?? ?? ?? EB 0E C7 45 DC 04 00 00 00 C7 45 E0 ?? ?? ?? ?? 8B 45 08 DD 00 8B 45 0C 8B 75 10 DD 5D E4 DD 00 8D 45 DC DD 5D EC 50 DD 06 DD 5D F4 FF 15 ?? ?? ?? ?? 85 C0 59 0F 85 98 00 00 00 C7 05 ?? ?? ?? ?? 22 00 00 00 E9 89 00 00 00 C7 45 E0 ?? ?? ?? ?? EB 44 2D EB 03 00 00 74 36 48 74 2A 48 74 1E 48 74 0C 48 75 72 C7 45 E0 ?? ?? ?? ?? EB 28 C7 45 E0 ?? ?? ?? ?? 8B 45 08 8B 75 10 EB 23 C7 45 E0 ?? ?? ?? ?? EB 10 C7 45 E0 ?? ?? ?? ?? EB 07 C7 45 E0 ?? ?? ?? ?? 8B 45 08 DD 00 8B 75 10 DD 1E DD 00 8B 45 0C DD 5D E4 C7 45 DC 01 00 00 00 DD 00 8D 45 DC DD 5D EC 50 DD 06 DD 5D F4 FF 15 ?? ?? ?? ?? 85 C0 59 75 0A C7 05 ?? ?? ?? ?? 21 00 00 00 DD 45 F4 DD 1E 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__mbstok"
		size = 150
		refs = "0008 ___ismbcodepage 0011 _strtok 001e ?nextoken@?1??_mbstok@@9@9 0028 __mbsspnp 003f __mbctype 0050 __mbspbrk"
	strings:
		$1 = { 55 8B EC 53 33 DB 39 1D ?? ?? ?? ?? 75 07 5B 5D E9 ?? ?? ?? ?? 39 5D 08 74 5F 8B 45 08 A3 ?? ?? ?? ?? 56 FF 75 0C 50 E8 ?? ?? ?? ?? 8B F0 3B F3 59 59 74 5C 8A 06 3A C3 74 56 0F B6 C0 F6 80 ?? ?? ?? ?? 04 74 05 38 5E 01 74 45 FF 75 0C 56 E8 ?? ?? ?? ?? 3B C3 59 59 74 2C 8A 08 3A CB 74 26 0F B6 C9 F6 81 ?? ?? ?? ?? 04 74 03 88 18 40 88 18 40 A3 ?? ?? ?? ?? EB 13 A1 ?? ?? ?? ?? 3B C3 75 A0 33 C0 EB 0D 89 1D ?? ?? ?? ?? 8B C6 EB 02 33 C0 5E 5B 5D C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "_wcsncmp"
		size = 53
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 8B 4D 08 8B 55 0C FF 4D 10 74 13 66 8B 01 66 85 C0 74 0B 66 3B 02 75 06 41 41 42 42 EB E8 0F B7 01 0F B7 0A 2B C1 5D C3 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsW"
		size = 362
		refs = "0003 ?f_use@?1??__crtGetEnvironmentStringsW@@9@9 000b __imp__GetEnvironmentStringsW@0 0031 __imp__GetLastError@0 007e _malloc 008e __imp__FreeEnvironmentStringsW@4 009d _memcpy 00b1 __imp__GetEnvironmentStrings@0 00cc __imp__MultiByteToWideChar@24 00d8 _strlen 0131 _wcslen 0145 __imp__FreeEnvironmentStringsA@4 0159 _free"
	strings:
		$1 = { 51 51 A1 ?? ?? ?? ?? 53 55 8B 2D ?? ?? ?? ?? 56 57 33 DB 33 F6 33 FF 3B C3 75 2E FF D5 8B F0 3B F3 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 1F FF 15 ?? ?? ?? ?? 83 F8 78 75 0A 6A 02 58 A3 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 83 F8 01 75 58 3B F3 75 0F FF D5 8B F0 3B F3 75 07 33 C0 E9 EC 00 00 00 66 39 1E 8B C6 74 0E 40 40 66 39 18 75 F9 40 40 66 39 18 75 F2 2B C6 40 40 8B E8 55 E8 ?? ?? ?? ?? 8B F8 3B FB 59 75 10 33 FF 56 FF 15 ?? ?? ?? ?? 8B C7 E9 B4 00 00 00 55 56 57 E8 ?? ?? ?? ?? 83 C4 0C EB E5 83 F8 02 74 04 3B C3 75 AB FF 15 ?? ?? ?? ?? 8B E8 3B EB 74 9F 38 5D 00 8B F5 74 23 53 53 6A FF 56 6A 01 53 FF 15 ?? ?? ?? ?? 3B C3 74 86 56 03 F8 E8 ?? ?? ?? ?? 8D 74 06 01 38 1E 59 75 DD 47 8D 04 3F 50 89 7C 24 18 E8 ?? ?? ?? ?? 3B C3 59 89 44 24 10 74 62 38 5D 00 8B FD 8B F0 74 3A 8B 4C 24 14 8B C6 2B 44 24 10 D1 F8 2B C8 51 56 6A FF 57 6A 01 53 FF 15 ?? ?? ?? ?? 85 C0 74 2F 57 E8 ?? ?? ?? ?? 56 8D 7C 07 01 E8 ?? ?? ?? ?? 38 1F 59 59 8D 74 46 02 75 C6 55 66 89 1E FF 15 ?? ?? ?? ?? 8B 44 24 10 5F 5E 5D 5B 59 59 C3 FF 74 24 10 E8 ?? ?? ?? ?? 59 55 FF 15 ?? ?? ?? ?? E9 F0 FE FF FF }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "_parse_cmdline"
		size = 405
		refs = "005f __mbctype"
	strings:
		$1 = { 55 8B EC 51 83 20 00 83 7D 08 00 53 8B 5D 0C 56 57 8B FA 8B F1 C7 03 01 00 00 00 8B CF 74 09 8B 55 08 83 45 08 04 89 32 85 F6 74 05 8A 17 88 16 46 FF 00 83 65 FC 00 80 39 22 75 10 33 D2 39 55 FC 0F 94 C2 41 89 55 FC B2 22 EB 2D FF 00 85 F6 74 05 8A 11 88 16 46 8A 11 0F B6 FA 41 F6 87 ?? ?? ?? ?? 04 74 0F FF 00 85 F6 74 08 8A 19 88 1E 8B 5D 0C 46 41 84 D2 74 32 83 7D FC 00 75 B8 80 FA 20 74 05 80 FA 09 75 AE 85 F6 74 04 C6 46 FF 00 33 FF 80 39 00 0F 84 E8 00 00 00 8A 11 80 FA 20 74 05 80 FA 09 75 06 41 EB F1 49 EB E3 80 39 00 0F 84 CD 00 00 00 83 7D 08 00 74 09 8B 55 08 83 45 08 04 89 32 FF 03 85 F6 74 05 8A 11 88 16 46 FF 00 C7 45 FC 01 00 00 00 33 DB EB 02 41 43 80 39 5C 74 F9 80 39 22 75 24 F6 C3 01 75 1D 85 FF 74 0C 8D 51 01 80 3A 22 75 04 8B CA EB 04 83 65 FC 00 33 D2 85 FF 0F 94 C2 8B FA D1 EB 85 DB 74 0F 8B D3 85 F6 74 04 C6 06 5C 46 FF 00 4A 75 F3 8A 11 84 D2 74 4B 85 FF 75 0A 80 FA 20 74 42 80 FA 09 74 3D 83 7D FC 00 74 31 85 F6 74 19 0F B6 DA F6 83 ?? ?? ?? ?? 04 74 06 88 16 46 41 FF 00 8A 11 88 16 46 EB 12 0F B6 D2 F6 82 ?? ?? ?? ?? 04 74 06 8B 10 41 42 89 10 FF 00 41 E9 61 FF FF FF 85 F6 74 04 C6 06 00 46 FF 00 8B 5D 0C E9 0F FF FF FF 8B 45 08 85 C0 74 03 83 20 00 FF 03 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_24_1_0 {
	meta:
		name = "___setargv"
		size = 169
		refs = "000c ___mbctype_initialized 0013 ___initmbctable 001d ?_pgmname@?1??__setargv@@9@9 002c __imp__GetModuleFileNameA@12 0031 __acmdln 0039 __pgmptr 0055 _parse_cmdline 0066 _malloc 0091 ___argc 0097 ___argv 009c __cwild"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 33 FF 39 3D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 68 04 01 00 00 BE ?? ?? ?? ?? 56 57 C6 05 ?? ?? ?? ?? 00 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B C7 89 35 ?? ?? ?? ?? 74 07 80 38 00 8B D8 75 02 8B DE 8D 45 FC 50 57 8D 45 F8 33 C9 8B D3 E8 ?? ?? ?? ?? 8B 75 FC 8B 45 F8 C1 E6 02 03 C6 50 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 05 83 C8 FF EB 2C 8D 45 FC 50 8D 0C 3E 57 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 FC 59 48 59 A3 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? F7 D8 1B C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "___crtExitProcess"
		size = 48
		refs = "0001 ??_C@_0M@MBOPBNBK@mscoree?4dll?$AA@ 0007 __imp__GetModuleHandleA@4 0010 ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 0017 __imp__GetProcAddress@8 002b __imp__ExitProcess@4"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 16 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 FF 74 24 04 FF D0 FF 74 24 04 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "__initterm"
		size = 24
	strings:
		$1 = { 56 8B F0 EB 0B 8B 06 85 C0 74 02 FF D0 83 C6 04 3B 74 24 08 72 EF 5E C3 }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "__initterm_e"
		size = 30
	strings:
		$1 = { 56 8B F0 33 C0 EB 0F 85 C0 75 11 8B 0E 85 C9 74 02 FF D1 83 C6 04 3B 74 24 08 72 EB 5E C3 }
	condition:
		$1
}

rule file_25_3_0 {
	meta:
		name = "__cinit"
		size = 106
		refs = "0001 __FPinit 0013 ___xi_a 0018 ___xi_z 003c __RTC_Terminate 0041 _atexit 0046 ___xc_a 004d ___xc_z"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 07 FF 74 24 04 FF D0 59 56 57 B9 ?? ?? ?? ?? BF ?? ?? ?? ?? 33 C0 3B CF 8B F1 73 17 85 C0 75 3F 8B 0E 85 C9 74 02 FF D1 83 C6 04 3B F7 72 ED 85 C0 75 2C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 8B C6 BF ?? ?? ?? ?? 3B C7 59 73 0F 8B 06 85 C0 74 02 FF D0 83 C6 04 3B F7 72 F1 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_25_4_0 {
	meta:
		name = "_doexit"
		size = 193
		refs = "0009 __C_Exit_Done 0015 __imp__GetCurrentProcess@0 001c __imp__TerminateProcess@8 0029 __C_Termination_Done 002e __exitflag 0036 ___onexitbegin 003f ___onexitend 0068 ___xp_a 006d ___xp_z 0087 ___xt_a 008c ___xt_z 00bb ___crtExitProcess"
	strings:
		$1 = { 55 8B EC 56 33 F6 46 39 35 ?? ?? ?? ?? 57 75 10 FF 75 08 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 7D 0C 00 8A 45 10 89 35 ?? ?? ?? ?? A2 ?? ?? ?? ?? 75 52 8B 0D ?? ?? ?? ?? 85 C9 74 29 A1 ?? ?? ?? ?? 83 E8 04 3B C1 EB 16 8B 00 85 C0 74 02 FF D0 A1 ?? ?? ?? ?? 83 E8 04 3B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 73 E3 B8 ?? ?? ?? ?? BE ?? ?? ?? ?? 3B C6 8B F8 73 0F 8B 07 85 C0 74 02 FF D0 83 C7 04 3B FE 72 F1 B8 ?? ?? ?? ?? BE ?? ?? ?? ?? 3B C6 8B F8 73 0F 8B 07 85 C0 74 02 FF D0 83 C7 04 3B FE 72 F1 83 7D 10 00 5F 5E 75 12 FF 75 08 C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_25_5_0 {
	meta:
		name = "_exit"
		size = 17
		refs = "0009 _doexit"
	strings:
		$1 = { 6A 00 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_25_6_0 {
	meta:
		name = "__exit"
		size = 17
		refs = "0009 _doexit"
	strings:
		$1 = { 6A 00 6A 01 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__mbsbtype"
		size = 57
		refs = "0002 ___ismbcodepage 001f __mbbtype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 03 33 C0 C3 56 8B 74 24 08 83 C8 FF 33 C9 8A 0E 84 C9 74 18 50 51 E8 ?? ?? ?? ?? 59 59 8B 4C 24 0C 46 FF 4C 24 0C 85 C9 75 E2 5E C3 83 C8 FF 5E C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__ceil_default"
		size = 211
		refs = "000f _newcw 0014 __ctrlfp 0032 __sptype 0052 __handle_qnan1 006f __real@3ff0000000000000 0087 __frnd 00c8 __except1"
	strings:
		$1 = { 55 8B EC 51 51 53 56 BE FF FF 00 00 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 45 08 59 59 8B D8 8B 45 0E 51 66 25 F0 7F 66 3D F0 7F 51 DD 1C 24 75 55 E8 ?? ?? ?? ?? 85 C0 59 59 7E 2D 83 F8 02 7E 1A 83 F8 03 75 23 DD 45 08 53 51 51 DD 1C 24 6A 0C E8 ?? ?? ?? ?? 83 C4 10 EB 74 56 53 E8 ?? ?? ?? ?? DD 45 08 59 59 EB 66 DD 45 08 53 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0C 6A 08 EB 41 E8 ?? ?? ?? ?? DD 5D F8 DD 45 08 59 DD 45 F8 59 DA E9 DF E0 F6 C4 44 7A 0E 56 53 E8 ?? ?? ?? ?? DD 45 F8 59 59 EB 22 F6 C3 20 75 ED DD 45 F8 53 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0C 6A 10 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__mbsnbset"
		size = 124
		refs = "000b ___ismbcodepage 001c __strnset"
	strings:
		$1 = { 55 8B EC 8B 4D 08 53 33 DB 39 1D ?? ?? ?? ?? 57 8B F9 75 11 FF 75 10 FF 75 0C 51 E8 ?? ?? ?? ?? 83 C4 0C EB 53 8B 45 0C 8B D0 C1 EA 08 3A D3 56 74 3E 84 C0 75 04 B2 20 8A C2 8B 5D 10 EB 1C 4B 80 39 00 74 30 8B F3 4B 85 F6 74 15 8D 71 01 80 3E 00 74 0D 88 11 8B CE 88 01 41 85 DB 75 E0 EB 14 C6 01 20 EB 0F FF 4D 10 38 19 74 08 88 01 41 39 5D 10 75 F1 8B C7 5E 5F 5B 5D C3 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__creat"
		size = 22
		refs = "000e __open"
	strings:
		$1 = { FF 74 24 08 68 02 03 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "__wcreat"
		size = 22
		refs = "000e __wopen"
	strings:
		$1 = { FF 74 24 08 68 02 03 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__ismbcl0"
		size = 59
		refs = "0002 ___mbcodepage 001a __mbctype"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 75 2C 8B 44 24 04 8B C8 C1 E9 08 0F B6 C9 F6 81 ?? ?? ?? ?? 04 74 17 0F B6 C8 F6 81 ?? ?? ?? ?? 08 74 0B 3D 9F 88 00 00 73 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "__ismbcl1"
		size = 66
		refs = "0002 ___mbcodepage 001a __mbctype"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 75 33 8B 44 24 04 8B C8 C1 E9 08 0F B6 C9 F6 81 ?? ?? ?? ?? 04 74 1E 0F B6 C8 F6 81 ?? ?? ?? ?? 08 74 12 3D 9F 88 00 00 72 0B 3D 72 98 00 00 77 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "__ismbcl2"
		size = 66
		refs = "0002 ___mbcodepage 001a __mbctype"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 75 33 8B 44 24 04 8B C8 C1 E9 08 0F B6 C9 F6 81 ?? ?? ?? ?? 04 74 1E 0F B6 C8 F6 81 ?? ?? ?? ?? 08 74 12 3D 9F 98 00 00 72 0B 3D A4 EA 00 00 77 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__wcsupr"
		size = 267
		refs = "0003 $T19490 0008 __SEH_prolog 0012 ___lc_handle 004d ___lc_codepage 005f ___crtLCMapStringW 0080 __alloca_probe 009a __resetstkoflw 00b2 _malloc 00ed _wcscpy 00fa _free 0106 __SEH_epilog"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 A1 ?? ?? ?? ?? 3B C3 75 31 8B 45 08 8B C8 66 39 18 0F 84 DA 00 00 00 33 D2 66 8B 11 66 83 FA 61 72 0C 66 83 FA 7A 77 06 83 C2 E0 66 89 11 41 41 66 39 19 75 E2 E9 B7 00 00 00 FF 35 ?? ?? ?? ?? 53 53 6A FF FF 75 08 68 00 02 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 8B F0 89 75 E0 3B F3 0F 84 8C 00 00 00 89 5D FC 8D 04 36 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D DC 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 33 FF 83 4D FC FF 8B 75 E0 3B FB 75 17 8D 04 36 50 E8 ?? ?? ?? ?? 59 8B F8 C7 45 E4 01 00 00 00 3B FB 74 2F FF 35 ?? ?? ?? ?? 56 57 6A FF FF 75 08 68 00 02 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 0B 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 39 5D E4 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 08 8D 65 D0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__EH_prolog"
		size = 31
	strings:
		$1 = { 6A FF 50 64 A1 00 00 00 00 50 8B 44 24 0C 64 89 25 00 00 00 00 89 6C 24 0C 8D 6C 24 0C 50 C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "__wutime64"
		size = 55
		refs = "000b __wopen 0023 __futime64 002b __close"
	strings:
		$1 = { 56 68 02 80 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 7D 05 83 C8 FF 5E C3 57 FF 74 24 10 56 E8 ?? ?? ?? ?? 56 8B F8 E8 ?? ?? ?? ?? 83 C4 0C 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_256_1_0 {
	meta:
		name = "__utime"
		size = 55
		refs = "000b __open 0023 __futime 002b __close"
	strings:
		$1 = { 56 68 02 80 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 7D 05 83 C8 FF 5E C3 57 FF 74 24 10 56 E8 ?? ?? ?? ?? 56 8B F8 E8 ?? ?? ?? ?? 83 C4 0C 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_72_1_0 {
	meta:
		name = "__utime64"
		size = 55
		refs = "000b __open 0023 __futime64 002b __close"
	strings:
		$1 = { 56 68 02 80 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 7D 05 83 C8 FF 5E C3 57 FF 74 24 10 56 E8 ?? ?? ?? ?? 56 8B F8 E8 ?? ?? ?? ?? 83 C4 0C 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "__wutime"
		size = 55
		refs = "000b __wopen 0023 __futime 002b __close"
	strings:
		$1 = { 56 68 02 80 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 7D 05 83 C8 FF 5E C3 57 FF 74 24 10 56 E8 ?? ?? ?? ?? 56 8B F8 E8 ?? ?? ?? ?? 83 C4 0C 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__mbstrlen"
		size = 85
		refs = "0002 ___mb_cur_max 000a _strlen 001e ___lc_codepage 0024 __imp__MultiByteToWideChar@24 0037 __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 75 05 E9 ?? ?? ?? ?? 56 8B 74 24 08 6A 00 6A 00 6A FF 56 6A 09 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF 5E C3 33 C0 EB 18 8B 15 ?? ?? ?? ?? 0F B6 C9 F6 44 4A 01 80 74 06 46 80 3E 00 74 08 40 46 8A 0E 84 C9 75 E2 5E C3 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_iswctype"
		size = 90
		refs = "001a __pwctype 0026 ___lc_handle 002f ___lc_codepage 003d ___crtGetStringTypeW"
	strings:
		$1 = { 55 8B EC 51 66 81 7D 08 FF FF 74 3C 66 81 7D 08 00 01 73 10 0F B7 45 08 8B 0D ?? ?? ?? ?? 66 8B 04 41 EB 2B FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 01 8D 45 08 50 6A 01 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 04 33 C0 EB 03 8B 45 FC 0F B7 4D 0C 0F B7 C0 23 C1 C9 C3 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_wcsrchr"
		size = 48
	strings:
		$1 = { 8B 44 24 04 8B D0 66 8B 08 40 40 66 85 C9 75 F6 66 8B 4C 24 08 48 48 3B C2 74 05 66 39 08 75 F5 66 8B 10 66 2B D1 66 F7 DA 1B D2 F7 D2 23 C2 C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__ftol"
		size = 39
	strings:
		$1 = { 55 8B EC 83 C4 F4 9B D9 7D FE 9B 66 8B 45 FE 80 CC 0C 66 89 45 FC D9 6D FC DF 7D F4 D9 6D FE 8B 45 F4 8B 55 F8 C9 C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "_modf"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __modf_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "_ceil"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __ceil_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_690_0_0 {
	meta:
		name = "_floor"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __floor_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "__modf_pentium4"
		size = 264
		refs = "000a _Bns 0031 _Sign 00a9 _Mantissa 00b1 _Zero 00fc ___libm_error_support"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 C8 66 0F 28 E0 66 0F 28 F0 66 0F 73 F0 01 66 0F 73 D0 35 66 0F 73 D3 34 66 0F 54 25 ?? ?? ?? ?? 66 0F 7E C0 66 0F FA D0 8B 4C 24 0C 66 0F D3 CA 66 0F F3 CA 66 0F 7E DA 3D FF 03 00 00 7C 1E 3D 32 04 00 00 7F 20 66 0F D6 09 F2 0F 5C F1 66 0F 56 F4 66 0F D6 74 24 04 DD 44 24 04 C3 66 0F D6 21 DD 44 24 04 C3 3D FF 07 00 00 F3 0F 7E 44 24 04 74 11 66 0F D6 01 81 FA 00 08 00 00 D9 EE 7C 02 D9 E0 C3 66 0F 28 C8 F2 0F 58 C0 66 0F D6 01 66 0F 54 05 ?? ?? ?? ?? 66 0F C2 05 ?? ?? ?? ?? 04 66 0F C5 C0 00 66 0F 54 C1 66 0F 56 C4 BA EF 03 00 00 83 F8 00 75 0B 66 0F D6 44 24 04 DD 44 24 04 C3 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__CIexp_pentium4"
		size = 704
		refs = "0026 cv 002e Shifter 00ab Tbl_addr 00cf mmask 00db bias 0146 emask 0205 ___libm_error_support 0239 XMAX 024c XMIN 0278 INF 027f ZERO 02a8 ONE_val"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F C5 C0 03 25 FF 7F 00 00 BA 8F 40 00 00 2B D0 2D 90 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 28 02 00 00 66 0F 59 C8 66 0F 58 CE 66 0F 28 F9 66 0F 5C CE 66 0F 59 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 7E F8 8B C8 83 E1 3F C1 E1 04 C1 F8 06 8B D0 66 0F 5C C3 66 0F 28 91 ?? ?? ?? ?? 66 0F 59 E0 66 0F 28 C8 66 0F 59 C0 66 0F 58 EC F2 0F 59 C0 F2 0F 58 CA 66 0F 15 D2 66 0F 6F 35 ?? ?? ?? ?? 66 0F DB FE 66 0F 6F 35 ?? ?? ?? ?? 66 0F D4 FE 66 0F 73 F7 2E 66 0F 59 C5 F2 0F 58 C8 66 0F 56 D7 66 0F 15 C0 F2 0F 58 C1 81 C2 7E 03 00 00 81 FA 7C 07 00 00 77 19 F2 0F 59 C2 83 EC 10 F2 0F 58 C2 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 83 EC 12 9B D9 7C 24 10 66 8B 54 24 10 66 81 CA 00 03 66 89 14 24 D9 2C 24 8B D0 D1 F8 2B D0 66 0F 6F 35 ?? ?? ?? ?? 66 0F DF F2 05 FF 03 00 00 66 0F 6E D8 66 0F 73 F3 34 66 0F 56 F3 81 C2 FF 03 00 00 66 0F 6E E2 66 0F 73 F4 34 66 0F 13 04 24 DD 04 24 66 0F 13 74 24 08 DD 44 24 08 DC C9 DE C1 66 0F 13 24 24 DD 04 24 DE C9 DD 1C 24 66 0F 12 04 24 D9 6C 24 10 83 C4 12 66 0F C5 C8 03 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 73 27 83 F9 00 74 29 EB 5A 81 F9 00 00 00 80 72 18 81 F9 2B 23 86 C0 72 4A 77 15 8B 54 24 04 81 FA EF 39 FA FE 72 3C EB 07 BA 0E 00 00 00 EB 05 BA 0F 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 1C 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 3D 00 00 F0 7F 73 31 8B 44 24 08 3D 00 00 00 80 73 13 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 BA 0E 00 00 00 EB 9C 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 BA 0F 00 00 00 EB 89 8B 54 24 04 3D 00 00 F0 7F 77 1E 83 FA 00 75 19 8B 44 24 08 3D 00 00 F0 7F 75 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 BA EA 03 00 00 E9 56 FF FF FF 8B 44 24 08 25 FF FF FF 7F 3D 00 00 90 40 73 85 66 0F 12 44 24 04 F2 0F 58 05 ?? ?? ?? ?? 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 8D 49 00 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "_parse_cmdline"
		size = 364
		refs = "0049 __mbctype"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 0C 33 D2 39 55 08 57 89 16 8B F9 C7 03 01 00 00 00 74 09 8B 4D 08 83 45 08 04 89 39 80 38 22 75 0E 33 C9 85 D2 0F 94 C1 40 8B D1 B1 22 EB 2D FF 06 85 FF 74 05 8A 08 88 0F 47 8A 08 0F B6 D9 40 F6 83 ?? ?? ?? ?? 04 74 0C FF 06 85 FF 74 05 8A 18 88 1F 47 40 84 C9 8B 5D 0C 74 32 85 D2 75 BC 80 F9 20 74 05 80 F9 09 75 B2 85 FF 74 04 C6 47 FF 00 83 65 FC 00 80 38 00 0F 84 D6 00 00 00 8A 08 80 F9 20 74 05 80 F9 09 75 06 40 EB F1 48 EB E1 80 38 00 0F 84 BB 00 00 00 83 7D 08 00 74 09 8B 4D 08 83 45 08 04 89 39 FF 03 33 DB 43 33 D2 EB 02 40 42 80 38 5C 74 F9 80 38 22 75 26 F6 C2 01 75 1F 83 7D FC 00 74 0C 8D 48 01 80 39 22 75 04 8B C1 EB 02 33 DB 33 C9 39 4D FC 0F 94 C1 89 4D FC D1 EA 85 D2 74 0D 85 FF 74 04 C6 07 5C 47 FF 06 4A 75 F3 8A 08 84 C9 74 48 83 7D FC 00 75 0A 80 F9 20 74 3D 80 F9 09 74 38 85 DB 74 2E 85 FF 74 19 0F B6 D1 F6 82 ?? ?? ?? ?? 04 74 06 88 0F 47 40 FF 06 8A 08 88 0F 47 EB 0F 0F B6 C9 F6 81 ?? ?? ?? ?? 04 74 03 40 FF 06 FF 06 40 E9 68 FF FF FF 85 FF 74 04 C6 07 00 47 FF 06 8B 5D 0C E9 21 FF FF FF 8B 45 08 85 C0 74 03 83 20 00 FF 03 5F 5B C9 C3 }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "__setargv"
		size = 162
		refs = "000c ___mbctype_initialized 0013 ___initmbctable 001d ?_pgmname@?1??_setargv@@9@9 002c __imp__GetModuleFileNameA@12 0031 __acmdln 0039 __pgmptr 0055 _parse_cmdline 0066 _malloc 0090 ___argc 0097 ___argv"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 33 FF 39 3D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 68 04 01 00 00 BE ?? ?? ?? ?? 56 57 C6 05 ?? ?? ?? ?? 00 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B C7 89 35 ?? ?? ?? ?? 74 07 80 38 00 8B D8 75 02 8B DE 8D 45 FC 50 57 8D 75 F8 33 C9 8B C3 E8 ?? ?? ?? ?? 8B 75 FC 8B 45 F8 C1 E6 02 03 C6 50 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 05 83 C8 FF EB 25 8D 45 FC 50 8D 0C 3E 57 8D 75 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 48 59 A3 ?? ?? ?? ?? 59 89 3D ?? ?? ?? ?? 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "_ldiv"
		size = 26
		altNames = "_div"
	strings:
		$1 = { 8B 44 24 04 99 F7 7C 24 08 83 7C 24 04 00 7D 09 85 D2 7E 05 40 2B 54 24 08 C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "_strncnt"
		size = 28
	strings:
		$1 = { 8B 4C 24 04 85 C9 74 0B 49 80 38 00 74 06 40 85 C9 75 F5 49 8B 44 24 04 2B C1 48 C3 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "___crtLCMapStringA"
		size = 956
		refs = "0003 $T20214 0008 __SEH_prolog 0010 ?f_use@?1??__crtLCMapStringA@@9@9 001d ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0029 __imp__LCMapStringW@24 003b __imp__GetLastError@0 009e ___lc_codepage 00c2 __imp__MultiByteToWideChar@24 00e4 __alloca_probe 00fe __resetstkoflw 011b _malloc 022f __imp__WideCharToMultiByte@32 023e _free 0266 ___lc_handle 027e ___ansicp 02a9 ___convertcp 02c5 __imp__LCMapStringA@24 02f0 _memset 03b7 __SEH_epilog"
	strings:
		$1 = { 6A 38 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 39 1D ?? ?? ?? ?? 75 38 53 53 33 F6 46 56 68 ?? ?? ?? ?? 68 00 01 00 00 53 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 35 ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 39 5D 14 7E 1B 8B 4D 14 8B 45 10 49 38 18 74 08 40 3B CB 75 F6 83 C9 FF 83 C8 FF 2B C1 01 45 14 A1 ?? ?? ?? ?? 83 F8 02 0F 84 DC 01 00 00 3B C3 0F 84 D4 01 00 00 83 F8 01 0F 85 FE 01 00 00 33 FF 89 7D D4 89 5D C8 89 5D CC 39 5D 20 75 08 A1 ?? ?? ?? ?? 89 45 20 53 53 FF 75 14 FF 75 10 33 C0 39 5D 24 0F 95 C0 8D 04 C5 01 00 00 00 50 FF 75 20 FF 15 ?? ?? ?? ?? 8B F0 89 75 D0 3B F3 0F 84 B8 01 00 00 C7 45 FC 01 00 00 00 8D 04 36 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 E4 83 4D FC FF EB 1B 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 89 5D E4 83 4D FC FF 8B 7D D4 8B 75 D0 39 5D E4 75 1C 8D 04 36 50 E8 ?? ?? ?? ?? 59 89 45 E4 3B C3 0F 84 60 01 00 00 C7 45 C8 01 00 00 00 56 FF 75 E4 FF 75 14 FF 75 10 6A 01 FF 75 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E6 00 00 00 53 53 56 FF 75 E4 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 8B F8 89 7D D4 3B FB 0F 84 C7 00 00 00 F6 45 0D 04 74 2D 39 5D 1C 0F 84 B8 00 00 00 3B 7D 1C 0F 8F AF 00 00 00 FF 75 1C FF 75 18 56 FF 75 E4 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? E9 94 00 00 00 C7 45 FC 02 00 00 00 8D 04 3F 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 E0 83 4D FC FF EB 1B 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 89 5D E0 83 4D FC FF 8B 7D D4 8B 75 D0 39 5D E0 75 18 8D 04 3F 50 E8 ?? ?? ?? ?? 59 89 45 E0 3B C3 74 40 C7 45 CC 01 00 00 00 57 FF 75 E0 56 FF 75 E4 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 21 53 53 39 5D 1C 75 04 53 53 EB 06 FF 75 1C FF 75 18 57 FF 75 E0 53 FF 75 20 FF 15 ?? ?? ?? ?? 8B F8 39 5D CC 74 09 FF 75 E0 E8 ?? ?? ?? ?? 59 39 5D C8 74 09 FF 75 E4 E8 ?? ?? ?? ?? 59 8B C7 E9 5B 01 00 00 89 5D D8 33 FF 89 5D C4 39 5D 08 75 08 A1 ?? ?? ?? ?? 89 45 08 39 5D 20 75 08 A1 ?? ?? ?? ?? 89 45 20 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 C0 83 F8 FF 75 07 33 C0 E9 21 01 00 00 3B 45 20 0F 84 EE 00 00 00 53 53 8D 4D 14 51 FF 75 10 50 FF 75 20 E8 ?? ?? ?? ?? 83 C4 18 89 45 D8 3B C3 74 D4 53 53 FF 75 14 50 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 8B F0 89 75 DC 3B F3 0F 84 A2 00 00 00 89 5D FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D BC 56 53 57 E8 ?? ?? ?? ?? 83 C4 0C EB 10 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 33 FF 83 4D FC FF 3B FB 75 23 FF 75 DC E8 ?? ?? ?? ?? 59 8B F8 3B FB 74 31 FF 75 DC 53 57 E8 ?? ?? ?? ?? 83 C4 0C C7 45 C4 01 00 00 00 FF 75 DC 57 FF 75 14 FF 75 D8 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 89 45 DC 3B C3 75 04 33 F6 EB 26 FF 75 1C FF 75 18 8D 45 DC 50 57 FF 75 20 FF 75 C0 E8 ?? ?? ?? ?? 83 C4 18 8B F0 F7 DE 1B F6 F7 DE EB 03 8B 75 B8 39 5D C4 74 23 57 E8 ?? ?? ?? ?? 59 EB 1A FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 8B F0 39 5D D8 74 09 FF 75 D8 E8 ?? ?? ?? ?? 59 8B C6 8D 65 AC E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "_fsetpos"
		size = 24
		refs = "0010 __fseeki64"
	strings:
		$1 = { 8B 44 24 08 6A 00 FF 70 04 FF 30 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__wmkdir"
		size = 44
		refs = "0008 __imp__CreateDirectoryW@8 0012 __imp__GetLastError@0 0020 __dosmaperr"
	strings:
		$1 = { 6A 00 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_694_0_0 {
	meta:
		name = "__mkdir"
		size = 44
		refs = "0008 __imp__CreateDirectoryA@8 0012 __imp__GetLastError@0 0020 __dosmaperr"
	strings:
		$1 = { 6A 00 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "_TranslateName"
		size = 96
		refs = "002e __stricmp"
	strings:
		$1 = { 55 8B EC 33 C0 53 33 DB 40 39 5D 0C 7C 46 56 57 85 C0 74 3E 8B 45 0C 03 C3 99 2B C2 8B F0 8B 45 08 D1 FE 8D 3C F0 FF 37 8B 45 10 FF 30 E8 ?? ?? ?? ?? 85 C0 59 59 75 0A 8B 4D 10 83 C7 04 89 39 EB 0B 7D 06 4E 89 75 0C EB 03 8D 5E 01 3B 5D 0C 7E BE 5F 5E 33 C9 85 C0 0F 94 C1 5B 8B C1 5D C3 }
	condition:
		$1
}

rule file_49_1_0 {
	meta:
		name = "_GetLcidFromDefault"
		size = 26
		refs = "0003 _iLcidState 000b __imp__GetUserDefaultLCID@0 0010 _lcidCountry 0015 _lcidLanguage"
	strings:
		$1 = { 66 81 0D ?? ?? ?? ?? 04 01 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_49_2_0 {
	meta:
		name = "_ProcessCodePage"
		size = 118
		refs = "0007 ___security_cookie 001b ??_C@_03DFHEHBHG@ACP?$AA@ 0021 _strcmp 002c ??_C@_03NFKLAGEF@OCP?$AA@ 0053 _lcidCountry 0059 _pfnGetLocaleInfoA 0066 _atol 0070 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 56 8B F1 85 F6 89 45 FC 74 31 80 3E 00 74 2C 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 1B 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 28 6A 08 8D 45 F4 50 6A 0B EB 0B 6A 08 8D 45 F4 50 68 04 10 00 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 0A 8D 75 F4 56 E8 ?? ?? ?? ?? 59 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_49_3_0 {
	meta:
		name = "_TestDefaultCountry"
		size = 30
		refs = "000a ___rglangidNotDefault"
	strings:
		$1 = { 33 C0 66 8B 4C 24 04 66 3B 88 ?? ?? ?? ?? 74 0B 40 40 83 F8 14 72 EB 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_49_4_0 {
	meta:
		name = "_crtGetLocaleInfoA@16"
		size = 227
		refs = "001d ___rgLocInfo 0040 __imp__GetLocaleInfoA@16 00cf _strncpy"
	strings:
		$1 = { 55 8B EC 53 56 57 6A 1A 33 F6 5F 8B 5D 14 8D 04 37 99 2B C2 D1 F8 8B C8 6B C9 2C 8B 89 ?? ?? ?? ?? 39 4D 08 74 25 73 05 8D 78 FF EB 03 8D 70 01 3B F7 7E D7 53 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5F 5E 5B 5D C2 10 00 8B 4D 0C 49 74 5B 49 49 74 4D 83 E9 04 74 3E 83 E9 04 74 2F 81 E9 F6 0F 00 00 74 1C 49 74 0E 49 49 75 C6 6B C0 2C 05 ?? ?? ?? ?? EB 3C 6B C0 2C 8B 80 ?? ?? ?? ?? EB 31 6B C0 2C 8B 80 ?? ?? ?? ?? EB 26 6B C0 2C 05 ?? ?? ?? ?? EB 1C 6B C0 2C 05 ?? ?? ?? ?? EB 12 6B C0 2C 05 ?? ?? ?? ?? EB 08 6B C0 2C 05 ?? ?? ?? ?? 85 C0 0F 84 78 FF FF FF 83 FB 01 0F 8C 6F FF FF FF 8B 75 10 8D 4B FF 51 50 56 E8 ?? ?? ?? ?? 33 C0 83 C4 0C C6 44 1E FF 00 40 E9 61 FF FF FF }
	condition:
		$1
}

rule file_49_5_0 {
	meta:
		name = "_LcidFromHexString"
		size = 53
	strings:
		$1 = { 33 C0 EB 2A 42 80 F9 61 7C 0A 80 F9 66 7F 05 80 C1 D9 EB 0D 80 F9 41 7C 08 80 F9 46 7F 03 80 C1 F9 05 FD FF FF 0F 0F BE C9 C1 E0 04 03 C1 8A 0A 84 C9 75 D0 C3 }
	condition:
		$1
}

rule file_49_6_0 {
	meta:
		name = "_GetPrimaryLen"
		size = 29
	strings:
		$1 = { 33 C0 8A 0A 42 80 F9 41 7C 05 80 F9 5A 7E 0A 80 F9 61 7C 08 80 F9 7A 7F 03 40 EB E6 C3 }
	condition:
		$1
}

rule file_49_7_0 {
	meta:
		name = "_CountryEnumProc@4"
		size = 148
		refs = "0007 ___security_cookie 0013 _LcidFromHexString 0020 _bAbbrevCountry 0036 _pfnGetLocaleInfoA 0040 _iLcidState 004d _pchCountry 0052 __stricmp 005e _TestDefaultCountry 0070 _lcidCountry 0076 _lcidLanguage 008c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 8B 55 08 56 89 45 FC E8 ?? ?? ?? ?? 8B F0 6A 78 8D 45 84 50 A1 ?? ?? ?? ?? F7 D8 1B C0 25 05 F0 FF FF 05 02 10 00 00 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 09 21 05 ?? ?? ?? ?? 40 EB 40 8D 45 84 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 75 1E 56 E8 ?? ?? ?? ?? 85 C0 59 74 13 83 0D ?? ?? ?? ?? 04 89 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 02 F7 D0 83 E0 01 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_49_8_0 {
	meta:
		name = "_TestDefaultLanguage"
		size = 113
		refs = "0007 ___security_cookie 0026 _pfnGetLocaleInfoA 0032 _LcidFromHexString 0044 _pchLanguage 0049 _strlen 0057 _GetPrimaryLen 006b @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 89 45 FC 6A 78 8D 45 84 50 8B 45 08 25 FF 03 00 00 6A 01 0D 00 04 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 74 32 8D 55 84 E8 ?? ?? ?? ?? 39 45 08 74 29 83 7D 0C 00 74 23 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 59 8B F0 E8 ?? ?? ?? ?? 3B C6 5E 75 04 33 C0 EB 03 33 C0 40 8B 4D FC E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_49_9_0 {
	meta:
		name = "_LangCountryEnumProc@4"
		size = 538
		refs = "0007 ___security_cookie 0013 _LcidFromHexString 0020 _bAbbrevCountry 0036 _pfnGetLocaleInfoA 0040 _iLcidState 0052 _pchCountry 0057 __stricmp 0076 _bAbbrevLanguage 0098 _pchLanguage 00b2 _lcidLanguage 00c2 _iPrimaryLen 00d6 __strnicmp 00f0 _lcidCountry 00f5 _strlen 0115 _TestDefaultCountry 01df _TestDefaultLanguage 0212 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 8B 55 08 56 89 45 FC E8 ?? ?? ?? ?? 8B F0 6A 78 8D 45 84 50 A1 ?? ?? ?? ?? F7 D8 1B C0 25 05 F0 FF FF 05 02 10 00 00 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 0C 21 05 ?? ?? ?? ?? 40 E9 C3 01 00 00 53 57 8D 45 84 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 BB 02 F0 FF FF BF 01 10 00 00 0F 85 BC 00 00 00 6A 78 8D 45 84 50 A1 ?? ?? ?? ?? F7 D8 1B C0 23 C3 03 C7 50 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CD 00 00 00 8D 45 84 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 75 11 66 81 0D ?? ?? ?? ?? 04 03 89 35 ?? ?? ?? ?? EB 6D F6 05 ?? ?? ?? ?? 02 75 6A A1 ?? ?? ?? ?? 85 C0 74 40 50 8D 45 84 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 29 FF 35 ?? ?? ?? ?? 83 0D ?? ?? ?? ?? 02 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 59 75 29 89 35 ?? ?? ?? ?? EB 21 F6 05 ?? ?? ?? ?? 01 75 18 56 E8 ?? ?? ?? ?? 85 C0 59 74 0D 83 0D ?? ?? ?? ?? 01 89 35 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? B8 00 03 00 00 23 C8 3B C8 0F 84 BE 00 00 00 6A 78 8D 45 84 50 A1 ?? ?? ?? ?? F7 D8 1B C0 23 C3 03 C7 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 0F 83 25 ?? ?? ?? ?? 00 33 C0 40 E9 9D 00 00 00 8D 45 84 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 33 FF 85 C0 59 75 2F 80 0D ?? ?? ?? ?? 02 39 3D ?? ?? ?? ?? 75 55 39 3D ?? ?? ?? ?? 74 4D FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 59 75 39 6A 01 EB 29 39 3D ?? ?? ?? ?? 75 42 A1 ?? ?? ?? ?? 3B C7 74 39 50 8D 45 84 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 22 57 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 15 80 0D ?? ?? ?? ?? 01 39 3D ?? ?? ?? ?? 75 06 89 35 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 02 F7 D0 83 E0 01 5F 5B 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_49_10_0 {
	meta:
		name = "_LanguageEnumProc@4"
		size = 203
		refs = "0007 ___security_cookie 0013 _LcidFromHexString 0020 _bAbbrevLanguage 0036 _pfnGetLocaleInfoA 0040 _iLcidState 004d _pchLanguage 0052 __stricmp 0072 _iPrimaryLen 0086 __strnicmp 0094 _TestDefaultLanguage 00a7 _lcidCountry 00ad _lcidLanguage 00c3 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 8B 55 08 56 89 45 FC E8 ?? ?? ?? ?? 8B F0 6A 78 8D 45 84 50 A1 ?? ?? ?? ?? F7 D8 1B C0 25 02 F0 FF FF 05 01 10 00 00 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 09 21 05 ?? ?? ?? ?? 40 EB 77 8D 45 84 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 75 0C 39 05 ?? ?? ?? ?? 75 3A 6A 01 EB 2A 83 3D ?? ?? ?? ?? 00 75 40 A1 ?? ?? ?? ?? 85 C0 74 37 50 8D 45 84 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 20 50 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 13 83 0D ?? ?? ?? ?? 04 89 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 02 F7 D0 83 E0 01 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_49_11_0 {
	meta:
		name = "_GetLcidFromCountry"
		size = 55
		refs = "0002 _pchCountry 0007 _strlen 0017 _CountryEnumProc@4 001c _bAbbrevCountry 0022 __imp__EnumSystemLocalesA@8 0028 _iLcidState"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E8 03 F7 D8 59 1B C0 6A 01 40 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F6 05 ?? ?? ?? ?? 04 75 07 83 25 ?? ?? ?? ?? 00 C3 }
	condition:
		$1
}

rule file_49_12_0 {
	meta:
		name = "_GetLcidFromLangCountry"
		size = 134
		refs = "0002 _pchLanguage 0007 _strlen 000d _pchCountry 001a _bAbbrevLanguage 002c _lcidLanguage 003c _bAbbrevCountry 0044 _iPrimaryLen 0055 _GetPrimaryLen 0061 _LangCountryEnumProc@4 0067 __imp__EnumSystemLocalesA@8 006c _iLcidState"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 83 E8 03 F7 D8 1B C0 40 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E8 03 F7 D8 1B C0 83 25 ?? ?? ?? ?? 00 40 83 3D ?? ?? ?? ?? 00 59 59 A3 ?? ?? ?? ?? 74 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? F6 C4 01 74 09 F6 C4 02 74 04 A8 07 75 07 83 25 ?? ?? ?? ?? 00 C3 }
	condition:
		$1
}

rule file_49_13_0 {
	meta:
		name = "_GetLcidFromLanguage"
		size = 85
		refs = "0002 _pchLanguage 0007 _strlen 0015 _bAbbrevLanguage 001d _iPrimaryLen 002e _GetPrimaryLen 003a _LanguageEnumProc@4 0040 __imp__EnumSystemLocalesA@8 0046 _iLcidState"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E8 03 F7 D8 1B C0 40 59 A3 ?? ?? ?? ?? 74 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 10 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F6 05 ?? ?? ?? ?? 04 75 07 83 25 ?? ?? ?? ?? 00 C3 }
	condition:
		$1
}

rule file_49_14_0 {
	meta:
		name = "___get_qualified_locale"
		size = 437
		refs = "0005 _pfnGetLocaleInfoA 000e __osplatform 0016 __imp__GetLocaleInfoA@16 0027 _crtGetLocaleInfoA@16 0040 _pchLanguage 0045 _pchCountry 0057 ___rg_country 005c _TranslateName 0072 _iLcidState 0085 _GetLcidFromLangCountry 008c _GetLcidFromLanguage 00a0 ___rg_language 00d4 _GetLcidFromCountry 00db _GetLcidFromDefault 00f6 _ProcessCodePage 010a __imp__IsValidCodePage@4 011a _lcidLanguage 0120 __imp__IsValidLocale@8 013d _lcidCountry 015c ??_C@_0BC@NFIEMBLL@Norwegian?9Nynorsk?$AA@ 0162 _strcpy 01a3 __itoa"
	strings:
		$1 = { 53 33 DB 39 1D ?? ?? ?? ?? 56 75 1F 83 3D ?? ?? ?? ?? 02 75 0C A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 0A C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 74 24 0C 3B F3 0F 84 A3 00 00 00 8D 46 40 3B C3 8B CE 89 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? 74 23 38 18 74 1F 68 ?? ?? ?? ?? 6A 16 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C4 0C 3B CB 89 1D ?? ?? ?? ?? 74 53 38 19 74 4F 3B C3 74 0B 38 18 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 39 1D ?? ?? ?? ?? 75 56 68 ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 2F A1 ?? ?? ?? ?? 3B C3 74 0B 38 18 74 07 E8 ?? ?? ?? ?? EB 1B E8 ?? ?? ?? ?? EB 14 3B C3 74 0B 38 18 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 39 1D ?? ?? ?? ?? 75 07 33 C0 E9 C4 00 00 00 57 8D 8E 80 00 00 00 E8 ?? ?? ?? ?? 8B F8 3B FB 0F 84 AB 00 00 00 0F B7 C7 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 99 00 00 00 6A 01 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 83 00 00 00 8B 44 24 14 3B C3 8B 0D ?? ?? ?? ?? 74 12 66 8B 15 ?? ?? ?? ?? 66 89 08 66 89 50 02 66 89 78 04 8B 74 24 18 3B F3 74 56 66 81 38 14 08 75 0F 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 EB 13 6A 40 56 68 01 10 00 00 51 FF 15 ?? ?? ?? ?? 85 C0 74 32 6A 40 8D 46 40 50 68 02 10 00 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 17 6A 0A 81 C6 80 00 00 00 56 57 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 40 EB 02 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "_towlower"
		size = 129
		refs = "0014 ___lc_handle 003e _iswctype 0050 ___lc_codepage 006c ___crtLCMapStringW"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 66 3D FF FF 75 05 66 0B C0 C9 C3 83 3D ?? ?? ?? ?? 00 75 19 66 3D 41 00 72 0E 66 3D 5A 00 77 08 0F B7 C0 83 C0 20 C9 C3 0F B7 C0 C9 C3 66 3D 00 01 73 14 6A 01 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 06 66 8B 45 08 C9 C3 FF 35 ?? ?? ?? ?? 8D 45 FC 6A 01 50 6A 01 8D 45 08 50 68 00 01 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 66 8B 45 08 74 04 66 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "??_N@YGXPAXIHP6EX0@Z1@Z"
		size = 98
		refs = "0003 $T330 0008 __SEH_prolog 0043 __SEH_epilog 005d ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 45 E0 89 45 FC 89 45 E4 33 FF 47 8B 45 E4 3B 45 10 7D 14 57 8B 75 08 8B CE FF 55 14 03 75 0C 89 75 08 FF 45 E4 EB E4 89 7D E0 83 4D FC FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 14 00 83 7D E0 00 75 11 FF 75 18 FF 75 E4 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__wexecvpe"
		size = 335
		refs = "0010 __wexecve 0019 _errno 0028 _wcschr 005a ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 005f __wgetenv 0078 _malloc 00c8 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 00ce _wcscat 00d6 _wcslen 0142 _free"
	strings:
		$1 = { 55 8B EC 51 56 FF 75 10 8B 75 08 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 02 0F 85 25 01 00 00 6A 5C 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 13 01 00 00 6A 2F 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 01 01 00 00 66 39 06 74 0B 66 83 7E 02 3A 0F 84 F1 00 00 00 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 59 89 5D FC 0F 84 D7 00 00 00 57 68 08 02 00 00 E8 ?? ?? ?? ?? 8B F8 85 FF 59 8B F7 0F 84 BE 00 00 00 EB 1C 66 3D 3B 00 74 1E 8D 8F 08 04 00 00 3B F1 73 14 66 89 06 46 46 43 43 33 C0 89 5D FC 66 8B 03 66 85 C0 75 DC 66 83 26 00 8D 46 FE 66 8B 00 66 3D 5C 00 8B F7 74 13 66 3D 2F 00 74 0D 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 57 E8 ?? ?? ?? ?? FF 75 08 8B D8 E8 ?? ?? ?? ?? 03 D8 81 FB 04 01 00 00 59 59 73 50 FF 75 08 57 E8 ?? ?? ?? ?? FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 14 83 3D ?? ?? ?? ?? 02 74 1F 66 8B 07 66 3D 5C 00 74 06 66 3D 2F 00 75 20 66 8B 47 02 66 3D 5C 00 74 06 66 3D 2F 00 75 10 8B 5D FC 66 83 3B 00 74 07 43 43 E9 64 FF FF FF 57 E8 ?? ?? ?? ?? 59 5F 5B 83 C8 FF 5E C9 C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__chdir"
		size = 323
		refs = "0006 $T20171 000b __SEH_prolog 0010 ___security_cookie 0031 __imp__SetCurrentDirectoryA@4 0047 __imp__GetCurrentDirectoryA@8 0068 __alloca_probe 0081 __resetstkoflw 0090 _malloc 00dd __mbctoupper 00ff __imp__SetEnvironmentVariableA@8 010f __imp__GetLastError@0 0115 __dosmaperr 0124 _free 0139 @__security_check_cookie@4 013e __SEH_epilog"
	strings:
		$1 = { 68 28 01 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 8D BD DC FE FF FF 33 DB 89 9D D0 FE FF FF 83 8D D4 FE FF FF FF FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D0 00 00 00 8B C7 50 68 05 01 00 00 FF 15 ?? ?? ?? ?? 8B F0 89 B5 CC FE FF FF 81 FE 04 01 00 00 7E 63 89 5D FC 8D 46 01 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 BD C8 FE FF FF EB 32 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 8B B5 CC FE FF FF 8D 46 01 50 E8 ?? ?? ?? ?? 59 8B F8 33 DB 3B FB 75 04 33 F6 EB 0A C7 85 D0 FE FF FF 01 00 00 00 83 4D FC FF 3B F3 74 5A 57 46 56 FF 15 ?? ?? ?? ?? 8B F0 3B F3 74 4B 8A 07 3C 5C 74 04 3C 2F 75 05 3A 47 01 74 36 C6 85 D8 FE FF FF 3D 0F B6 07 50 E8 ?? ?? ?? ?? 59 88 85 D9 FE FF FF C6 85 DA FE FF FF 3A 88 9D DB FE FF FF 57 8D 85 D8 FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 89 9D D4 FE FF FF FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 39 9D D0 FE FF FF 74 07 57 E8 ?? ?? ?? ?? 59 8B 85 D4 FE FF FF 8D A5 BC FE FF FF 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__CIsqrt"
		size = 186
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0031 __load_CW 0040 ___fastflag 0047 __fast_exit 0052 _NAME_ 0057 __math_exit 0073 __convertTOStoQNaN 0092 __indefinite 00b4 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 8B 44 24 0C 74 51 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? A9 00 00 00 80 75 1F D9 FA 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? A9 00 00 F0 7F 75 2C A9 FF FF 0F 00 75 25 83 7C 24 08 00 75 1E EB CC E8 ?? ?? ?? ?? EB 22 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB 25 00 00 00 80 74 B0 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__assert"
		size = 981
		refs = "000a ___security_cookie 0012 ___error_mode 0029 ___app_type 003b ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@ 0041 _strcpy 0047 _dblnewline 0053 _strcat 005e ??_C@_09KLGCKDOD@Program?3?5?$AA@ 0080 __imp__GetModuleFileNameA@12 008f ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 00a5 _strlen 00c6 _dotdotdot 00d1 _strncpy 00e8 _newline 00ff ??_C@_06IGPBOHMJ@File?3?5?$AA@ 0166 _strncat 024e ??_C@_06FIEBOLOH@Line?3?5?$AA@ 0276 __itoa 0293 ??_C@_0N@MEECIJGN@Expression?3?5?$AA@ 0323 ??_C@_0HA@OJHAGA@For?5information?5on?5how?5your?5prog@ 0346 ??_C@_0DN@EBBNMLME@?$CIPress?5Retry?5to?5debug?5the?5applic@ 035c ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 0362 ___crtMessageBoxA 0371 _raise 0379 __exit 0389 @__security_check_cookie@4 0399 __iob 03ac _setvbuf 03bd __assertstring 03c3 _fprintf 03c9 _fflush 03d1 _abort"
	strings:
		$1 = { 55 8B EC 81 EC 2C 03 00 00 A1 ?? ?? ?? ?? 89 45 FC A1 ?? ?? ?? ?? 53 33 DB 83 F8 01 56 0F 84 73 03 00 00 3B C3 75 0D 83 3D ?? ?? ?? ?? 01 0F 84 62 03 00 00 8D 85 E0 FD FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 8D 85 E0 FD FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 68 04 01 00 00 8D 85 D8 FC FF FF 50 53 88 9D DC FD FF FF FF 15 ?? ?? ?? ?? 85 C0 75 13 8D 85 D8 FC FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 8D B5 D8 FC FF FF 8B C6 50 E8 ?? ?? ?? ?? 83 C0 0B 83 F8 3C 59 76 26 8B C6 50 E8 ?? ?? ?? ?? 8B F0 8D 85 D8 FC FF FF 6A 03 FF 35 ?? ?? ?? ?? 83 E8 31 03 F0 56 E8 ?? ?? ?? ?? 83 C4 10 57 8D 85 E0 FD FF FF 56 50 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 8D 85 E0 FD FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 7D 0C 57 E8 ?? ?? ?? ?? 83 C4 1C 83 C0 08 83 F8 3C 57 0F 86 05 01 00 00 E8 ?? ?? ?? ?? 8B F0 8A 44 3E FF 33 D2 42 3C 5C 59 74 14 8D 4C 3E FF 3C 2F 74 0C 3B D6 73 08 42 49 8A 01 3C 5C 75 F0 8B DE 2B DA 83 FB 23 76 32 83 FA 11 73 2A 6A 31 58 2B C2 50 8D 85 E0 FD FF FF 57 50 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 03 DF 53 EB 3B 83 FB 23 73 47 6A 31 58 D1 EA 2B C2 50 8D 85 E0 FD FF FF 57 50 89 95 D4 FC FF FF E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 2B B5 D4 FC FF FF 03 F7 56 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C EB 68 6A 20 8D 85 E0 FD FF FF 57 50 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 6A 07 03 DF 8D 85 E0 FD FF FF 53 50 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 8D 44 3E F9 50 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 30 EB 0E 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 59 59 FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 8D 85 E0 FD FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 8D 85 E0 FD FF FF 6A 0A 50 E8 ?? ?? ?? ?? 59 8D 84 05 E0 FD FF FF 50 FF 75 10 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 8D 85 E0 FD FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 8B F0 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 8D 84 06 B0 00 00 00 83 C4 24 3D 1C 02 00 00 5F 8D 85 E0 FD FF FF 76 34 50 E8 ?? ?? ?? ?? B9 69 01 00 00 2B C8 51 FF 75 08 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 EB 0B FF 75 08 50 E8 ?? ?? ?? ?? 59 59 FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 8D 85 E0 FD FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 8D 85 E0 FD FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 12 20 01 00 8D 85 E0 FD FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 2C 83 F8 03 75 0F 6A 16 E8 ?? ?? ?? ?? 59 6A 03 E8 ?? ?? ?? ?? 83 F8 04 75 0D CC 8B 4D FC 5E 5B E8 ?? ?? ?? ?? C9 C3 83 F8 05 75 3C EB ED 66 F7 05 ?? ?? ?? ?? 0C 01 BE ?? ?? ?? ?? 75 0D 53 6A 04 53 56 E8 ?? ?? ?? ?? 83 C4 10 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "_$$$00001"
		size = 168
		refs = "0068 __rtindfpop 0070 __piby2 0094 __rtindfnpop 00a4 __rtchsifneg"
	strings:
		$1 = { E8 37 00 00 00 86 E9 EB 22 E8 2E 00 00 00 D9 C9 EB 19 D9 E1 D9 E8 8A E9 32 C9 EB 0F C6 85 70 FF FF FF FE D9 E1 D9 C9 D9 E1 D9 C9 D9 F3 0A C9 74 04 D9 EB DE E1 0A ED 74 02 D9 E0 C3 D9 E1 D9 C0 D9 C0 D9 E8 DE E1 D9 C9 D9 E8 DE C1 DE C9 D9 E4 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 01 75 05 32 ED D9 FA C3 58 E9 ?? ?? ?? ?? DD D8 DB 2D ?? ?? ?? ?? C3 DD D8 0A C9 74 0B DD D8 D9 EB 0A ED 74 02 D9 E0 C3 DD D8 D9 EE 0A ED 74 F7 D9 E0 C3 DD D8 E9 ?? ?? ?? ?? DD D8 8A CD EB 00 E8 C9 FF FF FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "??__C@YGXPAX0IHP6EX00@ZP6EX0@Z@Z"
		size = 102
		refs = "0003 $T330 0008 __SEH_prolog 0047 __SEH_epilog 0061 ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 45 E0 89 45 FC 89 45 E4 8B 45 E4 3B 45 14 7D 17 FF 75 0C 8B 4D 08 FF 55 18 8B 45 10 01 45 08 01 45 0C FF 45 E4 EB E1 C7 45 E0 01 00 00 00 83 4D FC FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 18 00 83 7D E0 00 75 11 FF 75 1C FF 75 E4 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "__fstati64"
		size = 662
		refs = "000f __nhandle 0024 ___pioinfo 0044 __imp__GetFileType@4 006a _errno 00d5 __imp__PeekNamedPipe@24 0110 __imp__GetFileInformationByHandle@8 011a __imp__GetLastError@0 0120 __dosmaperr 0148 __imp__FileTimeToLocalFileTime@8 015e __imp__FileTimeToSystemTime@8 018d ___loctotime_t 025c __allmul"
	strings:
		$1 = { 55 8B EC 83 EC 54 53 8B 5D 08 57 33 FF 3B 1D ?? ?? ?? ?? 89 7D FC 0F 83 69 02 00 00 8B C3 C1 F8 05 8D 04 85 ?? ?? ?? ?? 83 E3 1F 89 45 F8 8B 00 C1 E3 03 03 C3 F6 40 04 01 0F 84 46 02 00 00 56 FF 30 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 93 00 00 00 83 F8 02 74 24 83 F8 03 74 2A 3B C7 0F 85 B0 00 00 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 4D FC FF 8B 45 FC 5E E9 13 02 00 00 8B 75 0C 66 C7 46 06 00 20 EB 09 8B 75 0C 66 C7 46 06 00 10 83 F8 02 8B 4D 08 89 0E 89 4E 10 66 C7 46 08 01 00 66 89 7E 04 66 89 7E 0C 66 89 7E 0A 89 7E 28 89 7E 24 89 7E 20 75 08 89 7E 18 89 7E 1C EB B3 57 8D 45 08 50 8B 45 F8 8B 00 57 57 57 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 74 DE 8B 45 08 99 89 46 18 89 56 1C EB 8D 8B 75 0C 8D 45 AC 50 8B 45 F8 66 89 7E 06 66 89 7E 0C 66 89 7E 0A 66 89 7E 04 66 C7 46 08 01 00 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E9 48 FF FF FF F6 45 AC 01 74 08 66 81 4E 06 24 01 EB 06 66 81 4E 06 B6 01 8D 45 F0 50 8D 45 C0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 1E FF FF FF 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 08 FF FF FF 0F B7 45 EC 83 CB FF 53 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 39 7D B8 89 46 24 75 05 39 7D BC 74 53 8D 45 F0 50 8D 45 B8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C6 00 00 00 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B0 00 00 00 0F B7 45 EC 53 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 39 7D B0 89 46 20 75 0A 39 7D B4 75 05 8B 46 24 EB 4B 8D 45 F0 50 8D 45 B0 50 FF 15 ?? ?? ?? ?? 85 C0 74 65 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 74 53 0F B7 45 EC 53 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 6A 01 57 57 FF 75 CC 89 46 28 E8 ?? ?? ?? ?? 8B 4D D0 33 DB 03 C1 13 D3 80 4E 07 80 89 46 18 89 56 1C 89 3E 89 7E 10 E9 F9 FD FF FF 89 5D FC E9 F1 FD FF FF C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5B C9 C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__execle"
		size = 33
		refs = "0019 __execve"
	strings:
		$1 = { 8D 44 24 08 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_615_0_0 {
	meta:
		name = "__execlpe"
		size = 33
		refs = "0019 __execvpe"
	strings:
		$1 = { 8D 44 24 08 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_528_0_0 {
	meta:
		name = "__wexecle"
		size = 33
		refs = "0019 __wexecve"
	strings:
		$1 = { 8D 44 24 08 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__wexeclpe"
		size = 33
		refs = "0019 __wexecvpe"
	strings:
		$1 = { 8D 44 24 08 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "_strcmp"
		size = 136
	strings:
		$1 = { 8B 54 24 04 8B 4C 24 08 F7 C2 03 00 00 00 75 3C 8B 02 3A 01 75 2E 0A C0 74 26 3A 61 01 75 25 0A E4 74 1D C1 E8 10 3A 41 02 75 19 0A C0 74 11 3A 61 03 75 10 83 C1 04 83 C2 04 0A E4 75 D2 8B FF 33 C0 C3 90 1B C0 D1 E0 83 C0 01 C3 F7 C2 01 00 00 00 74 18 8A 02 83 C2 01 3A 01 75 E7 83 C1 01 0A C0 74 DC F7 C2 02 00 00 00 74 A4 66 8B 02 83 C2 02 3A 01 75 CE 0A C0 74 C6 3A 61 01 75 C5 0A E4 74 BD 83 C1 02 EB 88 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__ValidateEH3RN"
		size = 553
		refs = "0088 _nValidPages 009d _rgValidPages 00b5 __imp__VirtualQuery@12 012d _lModifying 0133 __imp__InterlockedExchange@8"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 8B 75 08 8B 5E 08 F6 C3 03 75 1B 64 A1 18 00 00 00 89 45 08 8B 45 08 8B 48 08 3B D9 89 4D FC 72 0C 3B 58 04 73 07 33 C0 E9 F0 01 00 00 57 8B 7E 0C 83 FF FF 75 08 33 C0 40 E9 DE 01 00 00 33 D2 89 55 08 8B C3 8B 08 83 F9 FF 74 08 3B CA 0F 83 45 01 00 00 83 78 04 00 74 03 FF 45 08 42 83 C0 0C 3B D7 76 E0 83 7D 08 00 74 14 8B 46 F8 3B 45 FC 0F 82 22 01 00 00 3B C6 0F 83 1A 01 00 00 A1 ?? ?? ?? ?? 8B FB 81 E7 00 F0 FF FF 33 F6 85 C0 7E 12 39 3C B5 ?? ?? ?? ?? 0F 84 FE 00 00 00 46 3B F0 7C EE 6A 1C 8D 45 E0 50 53 FF 15 ?? ?? ?? ?? 85 C0 0F 84 60 01 00 00 81 7D F8 00 00 00 01 0F 85 53 01 00 00 F6 45 F4 CC 74 56 8B 4D E4 66 81 39 4D 5A 0F 85 3F 01 00 00 8B 41 3C 03 C1 81 38 50 45 00 00 0F 85 2E 01 00 00 66 81 78 18 0B 01 0F 85 22 01 00 00 2B D9 66 83 78 06 00 0F B7 48 14 8D 4C 01 18 0F 86 0D 01 00 00 8B 41 0C 3B D8 72 0F 8B 51 08 03 D0 3B DA 73 06 F6 41 27 80 75 77 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 FF FE FF FF 8B 0D ?? ?? ?? ?? 85 C9 8B D1 7E 13 8D 04 8D ?? ?? ?? ?? 39 38 74 08 4A 83 E8 04 85 D2 7F F4 85 D2 75 2D 6A 0F 5B 3B CB 7F 02 8B D9 33 D2 85 DB 7C 12 8D 04 95 ?? ?? ?? ?? 8B 30 42 3B D3 89 38 8B FE 7E EE 83 F9 10 7D 07 41 89 0D ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E9 9D FE FF FF 33 C0 EB 7F 85 F6 0F 8E 91 FE FF FF 8B 1D ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? FF D3 85 C0 0F 85 7A FE FF FF 39 3C B5 ?? ?? ?? ?? 74 2E A1 ?? ?? ?? ?? 8D 70 FF 85 F6 7C 10 39 3C B5 ?? ?? ?? ?? 74 03 4E 79 F4 85 F6 7D 10 83 F8 10 7D 06 40 A3 ?? ?? ?? ?? 8D 70 FF EB 02 74 18 33 C9 85 F6 7C 12 8D 04 8D ?? ?? ?? ?? 8B 10 41 3B CE 89 38 8B FA 7E EE 6A 00 68 ?? ?? ?? ?? FF D3 E9 1D FE FF FF 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__close"
		size = 179
		refs = "000a __nhandle 0021 ___pioinfo 0033 __get_osfhandle 0067 __imp__CloseHandle@4 0071 __imp__GetLastError@0 007d __free_osfhnd 008f __dosmaperr 009c __doserrno 00a3 _errno"
	strings:
		$1 = { 53 55 56 57 8B 7C 24 14 3B 3D ?? ?? ?? ?? 0F 83 86 00 00 00 8B C7 C1 F8 05 8B F7 83 E6 1F 8D 1C 85 ?? ?? ?? ?? 8B 03 C1 E6 03 F6 44 30 04 01 74 69 57 E8 ?? ?? ?? ?? 83 F8 FF 59 74 3C 83 FF 01 74 05 83 FF 02 75 16 6A 02 E8 ?? ?? ?? ?? 6A 01 8B E8 E8 ?? ?? ?? ?? 3B C5 59 59 74 1C 57 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 8B E8 EB 02 33 ED 57 E8 ?? ?? ?? ?? 85 ED 8B 03 59 C6 44 30 04 00 74 09 55 E8 ?? ?? ?? ?? 59 EB 15 33 C0 EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "_strtoxl"
		size = 429
		refs = "0015 ___mb_cur_max 0023 __isctype 002d __pctype 0167 _errno"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 53 56 8B 75 08 8A 1E 57 8D 7E 01 83 3D ?? ?? ?? ?? 01 0F B6 C3 7E 0C 6A 08 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 08 85 C0 74 05 8A 1F 47 EB D2 80 FB 2D 75 06 83 4D 14 02 EB 05 80 FB 2B 75 03 8A 1F 47 8B 45 10 85 C0 0F 8C 3E 01 00 00 83 F8 01 0F 84 35 01 00 00 83 F8 24 0F 8F 2C 01 00 00 85 C0 6A 10 59 75 24 80 FB 30 74 09 C7 45 10 0A 00 00 00 EB 2E 8A 07 3C 78 74 0D 3C 58 74 09 C7 45 10 08 00 00 00 EB 1B 89 4D 10 39 4D 10 75 13 80 FB 30 75 0E 8A 07 3C 78 74 04 3C 58 75 04 47 8A 1F 47 33 D2 83 C8 FF F7 75 10 8B CA 8B D0 8B 35 ?? ?? ?? ?? 0F B6 C3 66 8B 04 46 A8 04 74 08 0F BE F3 83 EE 30 EB 1E 66 A9 03 01 74 43 80 FB 61 7C 0D 80 FB 7A 7F 08 0F BE F3 83 EE 20 EB 03 0F BE F3 83 C6 C9 3B 75 10 73 26 83 4D 14 08 39 55 FC 72 0C 75 04 3B F1 76 06 83 4D 14 04 EB 0C 8B 45 FC 0F AF 45 10 03 C6 89 45 FC 8A 1F 47 EB 9E 8B 4D 14 4F F6 C1 08 75 0F 83 7D 0C 00 74 03 8B 7D 08 83 65 FC 00 EB 4D F6 C1 04 B8 FF FF FF 7F 75 1E F6 C1 01 75 3E 8B D1 83 E2 02 74 09 81 7D FC 00 00 00 80 77 09 85 D2 75 2A 39 45 FC 76 25 F6 C1 01 C7 05 ?? ?? ?? ?? 22 00 00 00 74 06 83 4D FC FF EB 10 8A D1 80 E2 02 F6 DA 1B D2 F7 DA 03 D0 89 55 FC 8B 45 0C 85 C0 74 02 89 38 F6 C1 02 74 03 F7 5D FC 8B 45 FC EB 0B 8B 45 0C 85 C0 74 02 89 30 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "_strtol"
		size = 23
		refs = "000f _strtoxl"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_79_4_0 {
	meta:
		name = "__aligned_realloc"
		size = 23
		refs = "000f __aligned_offset_realloc"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "__spawnv"
		size = 23
		refs = "000f __spawnve"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__spawnvp"
		size = 23
		refs = "000f __spawnvpe"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_519_1_0 {
	meta:
		name = "__strtoi64"
		size = 23
		refs = "000f _strtoxq"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_544_1_0 {
	meta:
		name = "__wcstoi64"
		size = 23
		refs = "000f _wcstoxq"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_576_0_0 {
	meta:
		name = "__wspawnv"
		size = 23
		refs = "000f __wspawnve"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "__wspawnvp"
		size = 23
		refs = "000f __wspawnvpe"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "_wcstol"
		size = 23
		refs = "000f _wcstoxl"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "_strtoul"
		size = 23
		refs = "000f _strtoxl"
	strings:
		$1 = { 6A 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_519_2_0 {
	meta:
		name = "__strtoui64"
		size = 23
		refs = "000f _strtoxq"
	strings:
		$1 = { 6A 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_544_2_0 {
	meta:
		name = "__wcstoui64"
		size = 23
		refs = "000f _wcstoxq"
	strings:
		$1 = { 6A 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "_wcstoul"
		size = 23
		refs = "000f _wcstoxl"
	strings:
		$1 = { 6A 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "_fputs"
		size = 67
		refs = "000a _strlen 0014 __stbuf 0024 _fwrite 002f __ftbuf"
	strings:
		$1 = { 55 8B EC 53 56 57 FF 75 08 E8 ?? ?? ?? ?? FF 75 0C 8B F0 E8 ?? ?? ?? ?? FF 75 0C 8B F8 56 6A 01 FF 75 08 E8 ?? ?? ?? ?? FF 75 0C 8B D8 57 E8 ?? ?? ?? ?? 83 C4 20 33 C0 3B DE 0F 94 C0 5F 5E 5B 48 5D C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__wstripquote"
		size = 87
		refs = "0008 _wcslen 0012 _malloc 004d _free"
	strings:
		$1 = { 56 57 8B F0 56 33 FF E8 ?? ?? ?? ?? 8D 44 00 02 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 36 66 8B 0E 66 85 C9 8B D0 74 25 66 83 F9 22 75 05 46 46 47 EB 07 66 89 08 40 40 46 46 66 8B 0E 66 85 C9 75 E6 85 FF 74 07 66 21 08 8B C2 EB 09 52 E8 ?? ?? ?? ?? 59 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "__wtempnam"
		size = 384
		refs = "000b ??_C@_17DDHKMLLK@?$AAT?$AAM?$AAP?$AA?$AA@ 0016 __wgetenv 0027 __waccess 0034 __wstripquote 0067 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0078 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 0085 _wcslen 00aa _malloc 00bf _wcscat 010a __old_pfxlen 0113 __tempoff 0144 __ultow 0159 _errno 0164 _free"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 33 DB 68 ?? ?? ?? ?? 89 5D F8 89 5D FC E8 ?? ?? ?? ?? 8B F8 83 CE FF 3B FB 59 74 2D 53 57 E8 ?? ?? ?? ?? 3B C6 59 59 75 4B 8B C7 E8 ?? ?? ?? ?? 3B C3 89 45 FC 74 12 53 50 E8 ?? ?? ?? ?? 3B C6 59 59 74 05 8B 7D FC EB 2B 8B 7D 08 3B FB 74 0D 53 57 E8 ?? ?? ?? ?? 3B C6 59 59 75 17 53 BF ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 3B C6 59 59 75 05 BF ?? ?? ?? ?? 39 5D 0C 74 0C FF 75 0C E8 ?? ?? ?? ?? 59 89 45 F8 57 E8 ?? ?? ?? ?? 59 8B 4D F8 8D 44 08 0C 3D 04 01 00 00 0F 87 C7 00 00 00 03 C0 50 E8 ?? ?? ?? ?? 8B F0 3B F3 59 0F 84 B7 00 00 00 57 56 66 89 1E E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8D 44 47 FE 66 8B 00 83 C4 0C 66 3D 5C 00 74 13 66 3D 2F 00 74 0D 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 39 5D 0C 74 0B FF 75 0C 56 E8 ?? ?? ?? ?? 59 59 56 E8 ?? ?? ?? ?? 8D 3C 46 8B 45 F8 39 05 ?? ?? ?? ?? 59 73 0A C7 05 ?? ?? ?? ?? 01 00 00 00 8B 1D ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B C3 3D FF 7F 00 00 77 28 6A 0A 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 56 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 CF 83 3D ?? ?? ?? ?? 0D 74 C6 EB 0E 56 E8 ?? ?? ?? ?? 59 33 F6 EB 03 8B 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 5F 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "__fsqrt"
		size = 17
	strings:
		$1 = { 51 51 DD 44 24 0C D9 FA DD 1C 24 DD 04 24 59 59 C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "_comexecmd"
		size = 86
		refs = "0017 __cenvarg 0033 __p_overlay 0038 __dospawn 0042 _free"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 08 8D 45 F8 50 8D 45 FC 50 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 04 0B C0 C9 C3 56 FF 75 F8 FF 75 FC FF 75 08 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "_wcomexecmd"
		size = 86
		refs = "0017 __wcenvarg 0033 __p_overlay 0038 __wdospawn 0042 _free"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 08 8D 45 F8 50 8D 45 FC 50 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 04 0B C0 C9 C3 56 FF 75 F8 FF 75 FC FF 75 08 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "__execve"
		size = 320
		refs = "0011 __mbsrchr 002e __mbschr 003c _strlen 0045 _malloc 0052 ??_C@_02CEGDFPFP@?4?2?$AA@ 0058 _strcpy 005f _strcat 008b __access 00a2 _comexecmd 00e2 _ext_strings 0125 _free"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 08 56 57 6A 5C 53 8B FB E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 45 85 F6 75 4B 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 75 3B 53 E8 ?? ?? ?? ?? 83 C0 03 50 E8 ?? ?? ?? ?? 8B F8 85 FF 59 59 74 77 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 53 57 E8 ?? ?? ?? ?? 83 C4 10 8D 77 02 EB 0A 85 F6 74 04 3B C6 76 02 8B F0 83 4D F8 FF 6A 2E 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 27 6A 00 57 E8 ?? ?? ?? ?? 83 F8 FF 59 59 0F 84 93 00 00 00 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 EB 7F 57 E8 ?? ?? ?? ?? 83 C0 05 50 E8 ?? ?? ?? ?? 8B D8 85 DB 59 59 89 5D FC 75 05 83 C8 FF EB 6E 57 53 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 03 F3 BB ?? ?? ?? ?? FF 33 56 E8 ?? ?? ?? ?? 6A 00 FF 75 FC E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 0D 83 EB 04 81 FB ?? ?? ?? ?? 7D DB EB 14 FF 75 10 FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 FF 75 FC E8 ?? ?? ?? ?? 8B 5D 08 59 3B FB 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 F8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "___ld12mul"
		size = 562
		refs = "0007 ___security_cookie 0100 ___addl 0147 ___shl_12 0188 ___shr_12 022c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 53 8B 5D 0C 89 45 FC 33 C0 33 C9 66 8B 4B 0A 56 8B 75 08 89 45 E4 89 45 F0 89 45 F4 89 45 F8 66 8B 46 0A 57 8B F9 BA FF 7F 00 00 23 CA 33 F8 23 C2 81 E7 00 80 00 00 66 3D FF 7F 8D 14 01 89 55 08 0F 83 B8 01 00 00 66 81 F9 FF 7F 0F 83 AD 01 00 00 66 81 FA FD BF 0F 87 A2 01 00 00 66 81 FA BF 3F 77 04 33 C0 EB 3A 66 85 C0 BA FF FF FF 7F 75 18 FF 45 08 33 C0 85 56 08 75 10 39 46 04 75 0B 39 06 75 07 E9 6F 01 00 00 33 C0 66 3B C8 75 1E FF 45 08 85 53 08 75 16 39 43 04 75 11 39 03 75 0D 89 46 08 89 46 04 89 06 E9 6B 01 00 00 89 45 E8 8D 45 F4 89 45 EC C7 45 0C 05 00 00 00 8B 45 E8 03 C0 83 7D 0C 00 7E 49 03 C6 89 45 DC 8B 45 0C 8D 4B 08 89 4D E0 89 45 D8 8B 45 E0 8B 4D DC 0F B7 09 0F B7 00 0F AF C1 8B 4D EC 83 C1 FC 51 50 FF 31 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 06 8B 45 EC 66 FF 00 83 45 DC 02 83 6D E0 02 FF 4D D8 75 C8 83 45 EC 02 FF 45 E8 FF 4D 0C 83 7D 0C 00 7F 9C 81 45 08 02 C0 00 00 66 83 7D 08 00 7E 25 F6 45 FB 80 75 18 8D 45 F0 50 E8 ?? ?? ?? ?? 81 45 08 FF FF 00 00 66 83 7D 08 00 59 7F E2 66 83 7D 08 00 7F 39 81 45 08 FF FF 00 00 66 83 7D 08 00 7D 2B 8B 45 08 F7 D8 0F B7 D8 01 5D 08 F6 45 F0 01 74 03 FF 45 E4 8D 45 F0 50 E8 ?? ?? ?? ?? 4B 59 75 EA 83 7D E4 00 74 04 80 4D F0 01 66 81 7D F0 00 80 77 0F 8B 45 F0 25 FF FF 01 00 3D 00 80 01 00 75 35 83 7D F2 FF 75 2C 83 65 F2 00 83 7D F6 FF 75 1D 83 65 F6 00 66 81 7D FA FF FF 75 0B FF 45 08 66 C7 45 FA 00 80 EB 0E 66 FF 45 FA EB 08 FF 45 F6 EB 03 FF 45 F2 8B 45 08 66 3D FF 7F 73 1B 66 8B 4D F2 66 89 0E 8B 4D F4 89 4E 02 8B 4D F8 89 4E 06 0B C7 66 89 46 0A EB 1B 66 F7 DF 1B FF 83 66 04 00 81 E7 00 00 00 80 81 C7 00 80 FF 7F 83 26 00 89 7E 08 8B 4D FC 5F 5E 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "___multtenpow12"
		size = 134
		refs = "0007 ___security_cookie 000d __pow10pos 0024 __pow10neg 006c ___ld12mul 0080 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 53 BB ?? ?? ?? ?? 33 C9 83 EB 60 39 4D 0C 89 45 FC 74 5D 7D 0B F7 5D 0C BB ?? ?? ?? ?? 83 EB 60 39 4D 10 75 06 8B 45 08 66 89 08 39 4D 0C 74 40 56 57 8B 45 0C C1 7D 0C 03 83 E0 07 83 C3 54 3B C1 74 26 8D 04 40 8D 34 83 66 81 3E 00 80 72 0C 8D 7D F0 A5 A5 A5 FF 4D F2 8D 75 F0 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 33 C9 39 4D 0C 75 C4 5F 5E 8B 4D FC 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "_ctrlevent_capture@4"
		size = 56
		refs = "0008 _ctrlc_action 0016 _ctrlbreak_action"
	strings:
		$1 = { 83 7C 24 04 00 75 0E A1 ?? ?? ?? ?? B9 ?? ?? ?? ?? 6A 02 EB 0C A1 ?? ?? ?? ?? B9 ?? ?? ?? ?? 6A 15 85 C0 5A 74 0F 83 F8 01 74 07 83 21 00 52 FF D0 59 33 C0 40 C2 04 00 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "_siglookup"
		size = 57
		refs = "0002 __XcptActTabCount 0007 __XcptActTab"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? B8 ?? ?? ?? ?? 56 39 50 04 74 11 8D 34 49 83 C0 0C 8D 34 B5 ?? ?? ?? ?? 3B C6 72 EA 8D 0C 49 8D 0C 8D ?? ?? ?? ?? 3B C1 5E 73 05 39 50 04 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_71_2_0 {
	meta:
		name = "_signal"
		size = 264
		refs = "0047 _siglookup 0059 __XcptActTabCount 0066 __XcptActTab 007e _ConsoleCtrlHandler_Installed 0088 _ctrlevent_capture@4 008e __imp__SetConsoleCtrlHandler@8 00af _abort_action 00bd __imp__GetLastError@0 00c2 __doserrno 00c8 _errno 00d9 _ctrlbreak_action 00e7 _term_action 00f5 _ctrlc_action"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 0C 83 FF 04 0F 84 B5 00 00 00 83 FF 03 0F 84 AC 00 00 00 8B 75 08 83 FE 02 74 5A 83 FE 15 74 55 83 FE 16 74 70 83 FE 0F 74 6B 83 FE 08 74 0E 83 FE 04 74 09 83 FE 0B 0F 85 82 00 00 00 8B D6 E8 ?? ?? ?? ?? 85 C0 74 77 8B 48 08 EB 1E 89 78 08 8B 15 ?? ?? ?? ?? 8D 14 52 83 C0 0C 8D 14 95 ?? ?? ?? ?? 3B C2 0F 83 92 00 00 00 39 70 04 74 DD E9 88 00 00 00 83 3D ?? ?? ?? ?? 00 75 17 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 01 75 24 A3 ?? ?? ?? ?? 4E 4E 74 53 83 EE 0D 74 40 83 EE 06 74 2D 4E 75 54 8B 0D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 49 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF 5F 5E 5D C3 8B 0D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 1F 8B 0D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 11 8B 0D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 03 8B 4D 0C 8B C1 EB CB }
	condition:
		$1
}

rule file_71_3_0 {
	meta:
		name = "_raise"
		size = 297
		refs = "0033 _abort_action 0040 _ctrlbreak_action 004d _term_action 005b _siglookup 0068 _ctrlc_action 0081 __exit 0099 __pxcptinfoptrs 00aa __fpecode 00c5 __First_FPE_Indx 00cb __Num_FPE 00db __XcptActTab"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 8B C7 48 48 74 58 48 48 74 46 83 E8 04 74 41 83 E8 03 74 3C 83 E8 04 74 2A 83 E8 06 74 18 48 74 08 83 C8 FF E9 F4 00 00 00 8B 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? EB 33 8B 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? EB 26 8B 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? EB 19 8B D7 E8 ?? ?? ?? ?? 83 C0 08 8B 30 EB 0B 8B 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? 83 FE 01 0F 84 A9 00 00 00 85 F6 75 07 6A 03 E8 ?? ?? ?? ?? 53 6A 08 59 3B F9 74 0A 83 FF 0B 74 05 83 FF 04 75 26 8B 1D ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 3B F9 75 44 8B 15 ?? ?? ?? ?? 89 55 08 C7 05 ?? ?? ?? ?? 8C 00 00 00 EB 03 8B 5D 08 3B F9 75 28 A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 03 C8 3B C1 7D 1E 8D 14 40 8D 14 95 ?? ?? ?? ?? 2B C8 83 22 00 83 C2 0C 49 75 F7 EB 07 83 20 00 3B F9 75 0E FF 35 ?? ?? ?? ?? 6A 08 FF D6 59 59 EB 0E 57 FF D6 83 FF 0B 59 74 05 83 FF 04 75 13 83 FF 08 89 1D ?? ?? ?? ?? 75 08 8B 45 08 A3 ?? ?? ?? ?? 5B 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__futime64"
		size = 330
		refs = "0013 __time64 002c __localtime64 0037 _errno 0081 __imp__SystemTimeToFileTime@8 00a5 __imp__LocalFileTimeToFileTime@8 0125 __get_osfhandle 012d __imp__SetFileTime@16"
	strings:
		$1 = { 55 8B EC 83 EC 38 57 8B 7D 0C 85 FF 75 19 8D 45 D0 50 E8 ?? ?? ?? ?? 8B 45 D0 89 45 C8 8B 45 D4 59 89 45 CC 8D 7D C8 8D 47 08 50 E8 ?? ?? ?? ?? 85 C0 59 75 12 C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 00 01 00 00 66 8B 48 14 66 81 C1 6C 07 66 89 4D D8 66 8B 48 10 66 41 66 89 4D DA 66 8B 48 0C 66 89 4D DE 66 8B 48 08 66 89 4D E0 66 8B 48 04 66 89 4D E2 66 8B 00 66 83 65 E6 00 56 8B 35 ?? ?? ?? ?? 66 89 45 E4 8D 45 F8 50 8D 45 D8 50 FF D6 85 C0 0F 84 9E 00 00 00 8D 45 F0 50 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 88 00 00 00 57 E8 ?? ?? ?? ?? 85 C0 59 74 7D 66 8B 48 14 66 81 C1 6C 07 66 89 4D D8 66 8B 48 10 66 41 66 89 4D DA 66 8B 48 0C 66 89 4D DE 66 8B 48 08 66 89 4D E0 66 8B 48 04 66 89 4D E2 66 8B 00 66 83 65 E6 00 66 89 45 E4 8D 45 F8 50 8D 45 D8 50 FF D6 85 C0 74 34 8D 45 E8 50 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 74 22 8D 45 F0 50 8D 45 E8 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 0D C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF 5E 5F C9 C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__ismbcpunct"
		size = 133
		refs = "0023 ___ismbcodepage 0035 ___mblcid 003e ___mbcodepage 004c ___crtGetStringTypeA 006e __pctype 007a __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5A 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 74 50 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 2A 66 83 7D FE 00 75 23 F6 45 FC 10 74 1D 33 C0 40 C9 C3 0F B6 C1 8B 0D ?? ?? ?? ?? F6 04 41 10 75 EC F6 80 ?? ?? ?? ?? 02 75 E3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "_setbuf"
		size = 37
		refs = "001d _setvbuf"
	strings:
		$1 = { 33 C0 39 44 24 08 75 06 50 6A 04 50 EB 0A 68 00 02 00 00 50 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__tell"
		size = 17
		refs = "0009 __lseek"
	strings:
		$1 = { 6A 01 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_1_0 {
	meta:
		name = "__ismbbkalnum"
		size = 17
		refs = "0009 _x_ismbbtype"
	strings:
		$1 = { 6A 01 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__setjmp3"
		size = 123
		refs = "0028 __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 C7 42 20 30 32 43 56 C7 42 24 00 00 00 00 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 3B 8B 4C 24 08 0B C9 74 0A 8B 44 24 0C 89 42 24 49 75 08 8B 40 0C 89 42 1C EB 21 8B 44 24 10 89 42 1C 49 74 17 56 57 8D 74 24 1C 8D 7A 28 83 F9 06 76 05 B9 06 00 00 00 F3 A5 5F 5E 2B C0 C3 }
	condition:
		$1
}

rule file_78_1_0 {
	meta:
		name = "___initstdio"
		size = 166
		refs = "0001 __nstream 0023 _calloc 002c ___piob 0053 __iob 007e ___pioinfo"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 56 6A 14 5E 75 07 B8 00 02 00 00 EB 06 3B C6 7D 07 8B C6 A3 ?? ?? ?? ?? 6A 04 50 E8 ?? ?? ?? ?? 85 C0 59 59 A3 ?? ?? ?? ?? 75 1E 6A 04 56 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 A3 ?? ?? ?? ?? 75 05 6A 1A 58 5E C3 33 D2 B9 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 89 0C 02 83 C1 20 83 C2 04 81 F9 ?? ?? ?? ?? 7C EA 33 D2 B9 ?? ?? ?? ?? 8B C2 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B F2 83 E6 1F 8B 04 F0 83 F8 FF 74 04 85 C0 75 03 83 09 FF 83 C1 20 42 81 F9 ?? ?? ?? ?? 7C D4 33 C0 5E C3 }
	condition:
		$1
}

rule file_78_2_0 {
	meta:
		name = "___endstdio"
		size = 20
		refs = "0001 __flushall 0007 __exitflag 000f __fcloseall"
	strings:
		$1 = { E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__aligned_offset_malloc"
		size = 121
		refs = "000d _errno 0054 _malloc"
	strings:
		$1 = { 8B 44 24 08 8D 48 FF 85 C8 74 0D C7 05 ?? ?? ?? ?? 16 00 00 00 33 C0 C3 8B 4C 24 04 53 8B 5C 24 10 3B D9 72 12 85 DB 74 0E C7 05 ?? ?? ?? ?? 16 00 00 00 33 C0 5B C3 83 F8 04 77 03 6A 04 58 56 8B F3 F7 DE 57 8D 78 FF 83 E6 03 8D 04 0E 8D 44 38 04 50 E8 ?? ?? ?? ?? 59 8B C8 85 C9 74 16 8D 04 31 03 C7 8D 44 18 04 F7 D7 23 C7 2B C3 8B D0 2B D6 89 4A FC 5F 5E 5B C3 }
	condition:
		$1
}

rule file_79_1_0 {
	meta:
		name = "__aligned_free"
		size = 21
		refs = "000f _free"
	strings:
		$1 = { 8B 44 24 04 85 C0 74 0C 83 E0 FC FF 70 FC E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_79_2_0 {
	meta:
		name = "__aligned_malloc"
		size = 19
		refs = "000b __aligned_offset_malloc"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_702_0_0 {
	meta:
		name = "__execv"
		size = 19
		refs = "000b __execve"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_611_0_0 {
	meta:
		name = "__execvp"
		size = 19
		refs = "000b __execvpe"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_573_0_0 {
	meta:
		name = "__wexecv"
		size = 19
		refs = "000b __wexecve"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__wexecvp"
		size = 19
		refs = "000b __wexecvpe"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_79_3_0 {
	meta:
		name = "__aligned_offset_realloc"
		size = 335
		refs = "001a __aligned_offset_malloc 002c __aligned_free 0044 _errno 008f __msize 00c1 __expand 00d2 _malloc 012a _memmove 0139 _free"
	strings:
		$1 = { 55 8B EC 83 EC 18 33 C0 39 45 08 89 45 F8 75 13 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C C9 C3 39 45 0C 75 0D FF 75 08 E8 ?? ?? ?? ?? 59 33 C0 C9 C3 56 8B 75 14 3B 75 0C 72 15 3B F0 74 11 C7 05 ?? ?? ?? ?? 16 00 00 00 33 C0 E9 F9 00 00 00 8B 45 08 53 83 E0 FC 8B 58 FC 57 8B 7D 10 8D 47 FF 85 C7 89 5D EC 74 0C C7 05 ?? ?? ?? ?? 16 00 00 00 EB 67 83 FF 04 77 03 6A 04 5F 8B 45 08 2B C3 F7 DE 53 4F 83 E6 03 89 45 F0 E8 ?? ?? ?? ?? 59 8B CB 2B 4D 08 03 C1 8B 4D 0C 3B C1 89 45 F4 76 03 89 4D F4 8D 04 0E 8D 0C 1E 8D 44 38 04 8D 4C 39 04 3B 4D 08 89 45 E8 50 72 12 53 E8 ?? ?? ?? ?? 85 C0 59 59 89 45 FC 75 1D FF 75 E8 E8 ?? ?? ?? ?? 85 C0 59 89 45 FC 75 04 33 C0 EB 68 C7 45 F8 01 00 00 00 EB 03 89 45 EC 8B 45 08 8B 4D FC 8B D0 2B 55 F0 3B CA 75 0E 8D 14 06 03 55 14 8B DF F7 D3 85 D3 74 3F 8B 45 14 FF 75 F4 03 CE 03 CF 8D 5C 01 04 F7 D7 23 DF 8B 7D EC 2B D8 8B 45 F0 03 C7 50 53 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F8 00 74 07 57 E8 ?? ?? ?? ?? 59 8B 4D FC 8B C3 2B C6 89 48 FC 8B C3 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__wchartodigit"
		size = 374
	strings:
		$1 = { 66 8B 44 24 04 66 3D 30 00 0F 82 63 01 00 00 66 3D 3A 00 73 07 0F B7 C0 83 E8 30 C3 B9 10 FF 00 00 66 3B C1 0F 83 3C 01 00 00 B9 60 06 00 00 66 3B C1 0F 82 3A 01 00 00 66 3D 6A 06 0F 82 2A 01 00 00 B9 F0 06 00 00 66 3B C1 0F 82 22 01 00 00 66 3D FA 06 0F 82 12 01 00 00 B9 66 09 00 00 66 3B C1 0F 82 0A 01 00 00 66 3D 70 09 0F 82 FA 00 00 00 B9 E6 09 00 00 66 3B C1 0F 82 F2 00 00 00 66 3D F0 09 0F 82 E2 00 00 00 B9 66 0A 00 00 66 3B C1 0F 82 DA 00 00 00 66 3D 70 0A 0F 82 CA 00 00 00 B9 E6 0A 00 00 66 3B C1 0F 82 C2 00 00 00 66 3D F0 0A 0F 82 B2 00 00 00 B9 66 0B 00 00 66 3B C1 0F 82 AA 00 00 00 66 3D 70 0B 0F 82 9A 00 00 00 B9 66 0C 00 00 66 3B C1 0F 82 92 00 00 00 66 3D 70 0C 0F 82 82 00 00 00 B9 E6 0C 00 00 66 3B C1 72 7E 66 3D F0 0C 72 72 B9 66 0D 00 00 66 3B C1 72 6E 66 3D 70 0D 72 62 B9 50 0E 00 00 66 3B C1 72 5E 66 3D 5A 0E 72 52 B9 D0 0E 00 00 66 3B C1 72 4E 66 3D DA 0E 72 42 83 C1 50 66 3B C1 72 40 66 3D 2A 0F 72 34 B9 40 10 00 00 66 3B C1 72 30 66 3D 4A 10 72 24 B9 E0 17 00 00 66 3B C1 72 20 66 3D EA 17 72 14 83 C1 30 66 3B C1 72 12 66 3D 1A 18 EB 04 66 3D 1A FF 73 06 0F B7 C0 2B C1 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "_clearerr"
		size = 46
		refs = "0018 ___pioinfo 0025 ___badioinfo"
	strings:
		$1 = { 8B 44 24 04 83 60 0C CF 8B 40 10 83 F8 FF 74 14 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F 8D 04 C1 EB 05 B8 ?? ?? ?? ?? 80 60 04 FD C3 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "__putws"
		size = 92
		refs = "0008 __iob 0013 __stbuf 0024 _fputwc 004f __ftbuf"
	strings:
		$1 = { 55 8B EC 51 53 56 57 BE ?? ?? ?? ?? 56 BB FF FF 00 00 E8 ?? ?? ?? ?? 8B 7D 08 89 45 FC 59 33 C0 EB 0F 50 E8 ?? ?? ?? ?? 47 59 47 66 3B C3 59 74 19 66 8B 07 66 85 C0 56 75 E8 6A 0A E8 ?? ?? ?? ?? 66 3B C3 59 59 74 02 33 DB 56 FF 75 FC E8 ?? ?? ?? ?? 59 59 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__d_inttype"
		size = 110
		refs = "000e __fpclass 0021 __frnd 003f __real@4000000000000000"
	strings:
		$1 = { 55 8B EC 51 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? A8 90 59 59 75 52 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F8 59 DD 45 08 59 DD 45 F8 DA E9 DF E0 F6 C4 44 7A 31 DD 45 08 51 DC 35 ?? ?? ?? ?? 51 DD 5D F8 DD 45 F8 DD 1C 24 E8 ?? ?? ?? ?? DD 45 F8 DA E9 59 59 DF E0 F6 C4 44 7A 05 6A 02 58 C9 C3 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "__powhlp"
		size = 354
		refs = "000b __real@0000000000000000 0038 __real@3ff0000000000000 0060 __d_ind 00a2 __d_inf 0102 __d_inttype 0146 __d_mzero"
	strings:
		$1 = { 55 8B EC 51 51 DD 45 08 56 DC 15 ?? ?? ?? ?? 33 D2 33 F6 DF E0 F6 C4 05 7A 02 D9 E0 B8 00 00 F0 7F DD 5D F8 39 45 14 B9 00 00 F0 FF 75 3E 39 55 10 75 78 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 0F 84 82 00 00 00 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 8B 45 18 0F 8B 89 00 00 00 DD 05 ?? ?? ?? ?? 33 F6 46 E9 EF 00 00 00 39 4D 14 75 3A 39 55 10 75 35 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 07 D9 EE E9 CB 00 00 00 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 8B 45 18 7A BE DD 05 ?? ?? ?? ?? E9 B0 00 00 00 39 45 0C 75 3F 39 55 08 0F 85 A4 00 00 00 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0B DD 05 ?? ?? ?? ?? E9 84 00 00 00 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 8B 45 18 7A 04 D9 EE EB 70 D9 E8 EB 6C 39 4D 0C 75 69 39 55 08 75 64 DD 45 10 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 10 59 DC 1D ?? ?? ?? ?? 59 8B C8 DF E0 F6 C4 41 75 15 83 F9 01 DD 05 ?? ?? ?? ?? 75 02 D9 E0 DD 5D 10 DD 45 10 EB 29 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 17 83 F9 01 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 EE DD 5D 10 DD 45 10 EB 02 D9 E8 8B 45 18 DD 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "__twoToTOS"
		size = 21
	strings:
		$1 = { D9 C0 D9 FC DC E1 D9 C9 D9 E0 D9 F0 D9 E8 DE C1 D9 FD DD D9 C3 }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "__load_CW"
		size = 23
	strings:
		$1 = { 8B 54 24 04 81 E2 00 03 00 00 83 CA 7F 66 89 54 24 06 D9 6C 24 06 C3 }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "__convertTOStoQNaN"
		size = 25
		refs = "000f One"
	strings:
		$1 = { A9 00 00 08 00 74 06 B8 07 00 00 00 C3 DC 05 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "__fload_withFB"
		size = 67
	strings:
		$1 = { 8B 42 04 25 00 00 F0 7F 3D 00 00 F0 7F 74 03 DD 02 C3 8B 42 04 83 EC 0A 0D 00 00 FF 7F 89 44 24 06 8B 42 04 8B 0A 0F A4 C8 0B C1 E1 0B 89 44 24 04 89 0C 24 DB 2C 24 83 C4 0A A9 00 00 00 00 8B 42 04 C3 }
	condition:
		$1
}

rule file_86_4_0 {
	meta:
		name = "__checkTOS_withFB"
		size = 22
	strings:
		$1 = { 8B 44 24 08 25 00 00 F0 7F 3D 00 00 F0 7F 74 01 C3 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_86_6_0 {
	meta:
		name = "__math_exit"
		size = 42
		refs = "001f __startOneArgErrorHandling"
	strings:
		$1 = { 66 8B 04 24 66 3D 7F 02 74 1E 66 83 E0 20 74 15 9B DF E0 66 83 E0 20 74 0C B8 08 00 00 00 E8 ?? ?? ?? ?? 5A C3 D9 2C 24 5A C3 }
	condition:
		$1
}

rule file_86_7_0 {
	meta:
		name = "__check_overflow_exit"
		size = 20
	strings:
		$1 = { 83 EC 08 DD 14 24 8B 44 24 04 83 C4 08 25 00 00 F0 7F EB 14 }
	condition:
		$1
}

rule file_86_8_0 {
	meta:
		name = "__check_range_exit"
		size = 163
		refs = "003f __startOneArgErrorHandling 0046 __startTwoArgErrorHandling 0053 IeeeAdjU 0063 DblMin 0074 _zero 007c IeeeAdjO 008c DblMax 009d _infinity"
	strings:
		$1 = { 83 EC 08 DD 14 24 8B 44 24 04 83 C4 08 25 00 00 F0 7F 74 3D 3D 00 00 F0 7F 74 5F 66 8B 04 24 66 3D 7F 02 74 2A 66 83 E0 20 75 21 9B DF E0 66 83 E0 20 74 18 B8 08 00 00 00 83 FA 1D 74 07 E8 ?? ?? ?? ?? 5A C3 E8 ?? ?? ?? ?? 5A C3 D9 2C 24 5A C3 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E B8 04 00 00 00 73 C7 DC 0D ?? ?? ?? ?? EB BF DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E B8 03 00 00 00 76 9E DC 0D ?? ?? ?? ?? EB 96 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "__ZeroTail"
		size = 50
	strings:
		$1 = { 8B 44 24 08 6A 20 59 99 F7 F9 6A 1F 59 2B CA 83 CA FF D3 E2 8B 4C 24 04 F7 D2 85 14 81 74 09 33 C0 C3 83 3C 81 00 75 F7 40 83 F8 03 7C F4 33 C0 40 C3 }
	condition:
		$1
}

rule file_87_1_0 {
	meta:
		name = "__IncMan"
		size = 77
		refs = "0024 ___addl"
	strings:
		$1 = { 8B 44 24 08 56 57 6A 20 59 99 F7 F9 8B 7C 24 0C 8B F0 8D 04 B7 50 6A 1F 59 2B CA 33 D2 42 D3 E2 52 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 4E 78 1C 8D 3C B7 85 C0 74 15 57 6A 01 FF 37 E8 ?? ?? ?? ?? 83 C4 0C 4E 83 EF 04 85 F6 7D E7 5F 5E C3 }
	condition:
		$1
}

rule file_87_2_0 {
	meta:
		name = "__RoundMan"
		size = 114
		refs = "0034 __ZeroTail 0043 __IncMan"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 53 56 57 8B 7D 0C 4F 6A 20 8D 47 01 59 99 F7 F9 6A 1F 5E 2B F2 33 D2 42 8B CE D3 E2 8B D8 8B 45 08 85 14 98 74 21 8D 4F 01 51 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 0E 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 FC 8B 45 08 83 CA FF 8B CE D3 E2 6A 03 59 21 14 98 43 3B D9 7D 09 8D 3C 98 2B CB 33 C0 F3 AB 8B 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_87_3_0 {
	meta:
		name = "__CopyMan"
		size = 27
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 04 6A 03 5A 2B C8 56 8B 30 89 34 01 83 C0 04 4A 75 F5 5E C3 }
	condition:
		$1
}

rule file_87_5_0 {
	meta:
		name = "__IsZeroMan"
		size = 25
	strings:
		$1 = { 33 C0 8B 4C 24 04 83 3C 81 00 75 0A 40 83 F8 03 7C F0 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_87_6_0 {
	meta:
		name = "__ShrMan"
		size = 123
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 0C 53 56 57 6A 20 5E 99 8B CE F7 F9 8B 5D 08 83 CF FF 89 75 0C 8B CA D3 E7 89 45 F8 33 C0 29 55 0C F7 D7 89 45 FC 8B 34 83 8B CE 23 CF 89 4D F4 8B CA D3 EE 8B 4D 0C 0B 75 FC 89 34 83 8B 75 F4 D3 E6 40 83 F8 03 89 75 FC 7C DB 6A 02 58 8B C8 2B 4D F8 8D 0C 8B 3B 45 F8 7C 07 8B 11 89 14 83 EB 04 83 24 83 00 48 83 E9 04 85 C0 7D E8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_87_7_0 {
	meta:
		name = "__ld12cvt"
		size = 344
		refs = "004e __IsZeroMan 006e __CopyMan 007a __RoundMan 00b7 __ShrMan"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 0F B7 48 0A 53 56 8B 75 10 57 8B F9 81 E1 00 80 00 00 89 4D 08 8B 48 06 89 4D F4 8B 48 02 0F B7 00 C1 E0 10 81 E7 FF 7F 00 00 81 EF FF 3F 00 00 81 FF 01 C0 FF FF 89 45 FC 8D 45 F4 89 4D F8 50 75 1E 33 DB E8 ?? ?? ?? ?? 85 C0 59 0F 85 BD 00 00 00 8D 7D F4 AB AB AB 6A 02 58 E9 B1 00 00 00 8D 45 E8 50 E8 ?? ?? ?? ?? FF 76 08 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 01 47 8B 46 04 8B C8 2B 4E 08 3B F9 7D 0A 33 C0 8D 7D F4 AB AB AB EB 3C 3B F8 7F 3C 2B C7 8B F8 8D 45 E8 50 8D 45 F4 50 E8 ?? ?? ?? ?? 8D 45 F4 57 50 E8 ?? ?? ?? ?? FF 76 08 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 46 0C 40 50 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 20 33 DB EB 85 3B 3E FF 76 0C 7C 21 33 C0 8D 7D F4 AB AB AB 80 4D F7 80 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 5E 14 03 1E 59 33 C0 59 40 EB 16 8B 5E 14 80 65 F7 7F 8D 45 F4 50 03 DF E8 ?? ?? ?? ?? 59 59 33 C0 6A 1F 59 2B 4E 0C 8B 76 10 D3 E3 8B 4D 08 F7 D9 1B C9 81 E1 00 00 00 80 0B D9 0B 5D F4 83 FE 40 75 0D 8B 4D 0C 8B 55 F8 89 59 04 89 11 EB 0A 83 FE 20 75 05 8B 4D 0C 89 19 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_87_8_0 {
	meta:
		name = "__ld12tod"
		size = 22
		refs = "0001 _DoubleFormat 000e __ld12cvt"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_87_9_0 {
	meta:
		name = "__ld12tof"
		size = 22
		refs = "0001 _FloatFormat 000e __ld12cvt"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_87_10_0 {
	meta:
		name = "__ld12told"
		size = 124
		refs = "0041 __RoundMan"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 83 65 FC 00 33 C9 66 8B 48 0A 56 57 6A 40 8B F1 81 E1 00 80 00 00 8B F9 8B 48 06 89 4D F0 8B 48 02 0F B7 00 C1 E0 10 89 45 F8 8D 45 F0 50 81 E6 FF 7F 00 00 89 4D F4 E8 ?? ?? ?? ?? 85 C0 59 59 74 08 B9 00 00 00 80 46 EB 03 8B 4D F0 66 81 FE FF 7F 75 07 C7 45 FC 01 00 00 00 8B 45 0C 0B FE 89 48 04 8B 4D F4 66 89 78 08 5F 89 08 8B 45 FC 5E C9 C3 }
	condition:
		$1
}

rule file_87_11_0 {
	meta:
		name = "__atodbl"
		size = 61
		refs = "0007 ___security_cookie 0020 ___strgtold12 002c __ld12tod 0037 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 89 45 FC 33 C0 50 50 50 50 FF 75 0C 8D 45 EC 50 8D 45 F0 50 E8 ?? ?? ?? ?? FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 24 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_87_13_0 {
	meta:
		name = "__atoflt"
		size = 61
		refs = "0007 ___security_cookie 0020 ___strgtold12 002c __ld12tof 0037 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 89 45 FC 33 C0 50 50 50 50 FF 75 0C 8D 45 EC 50 8D 45 F0 50 E8 ?? ?? ?? ?? FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 24 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_87_12_0 {
	meta:
		name = "__atoldbl"
		size = 62
		refs = "0007 ___security_cookie 0021 ___strgtold12 002d __ld12told 0038 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 89 45 FC 33 C0 50 50 50 6A 01 FF 75 0C 8D 45 EC 50 8D 45 F0 50 E8 ?? ?? ?? ?? FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 24 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "_fabs"
		size = 177
		refs = "0013 __ctrlfp 0031 __sptype 0046 __real@3ff0000000000000 005c __except1 006d __handle_qnan1"
	strings:
		$1 = { 55 8B EC 51 51 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 0E 66 25 F0 7F 66 3D F0 7F 59 59 75 68 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 48 59 59 74 4A 48 74 39 48 DD 45 08 57 74 21 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 15 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 48 51 51 DD 1C 24 6A 15 E8 ?? ?? ?? ?? 83 C4 10 EB 37 56 57 E8 ?? ?? ?? ?? DD 45 08 D9 E0 EB 27 56 57 E8 ?? ?? ?? ?? DD 45 08 EB 1B 8B 45 0C 25 FF FF FF 7F 89 45 FC 8B 45 08 56 57 89 45 F8 E8 ?? ?? ?? ?? DD 45 F8 59 59 5F 5E C9 C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__ioinit"
		size = 427
		refs = "0009 _malloc 001b ___pioinfo 0021 __nhandle 0059 __imp__GetStartupInfoA@4 0100 __imp__GetFileType@4 0159 __imp__GetStdHandle@4 019e __imp__SetHandleCount@4"
	strings:
		$1 = { 83 EC 44 68 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 59 75 08 83 C8 FF E9 8D 01 00 00 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 20 00 00 00 8D 88 00 01 00 00 EB 1A 83 08 FF C6 40 04 00 C6 40 05 0A 8B 0D ?? ?? ?? ?? 83 C0 08 81 C1 00 01 00 00 3B C1 72 E2 53 56 57 8D 44 24 0C 50 FF 15 ?? ?? ?? ?? 66 83 7C 24 3E 00 0F 84 C7 00 00 00 8B 44 24 40 85 C0 0F 84 BB 00 00 00 8B 30 55 8D 68 04 B8 00 08 00 00 3B F0 8D 1C 2E 7C 02 8B F0 39 35 ?? ?? ?? ?? 7D 52 BF ?? ?? ?? ?? 68 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 59 74 38 83 05 ?? ?? ?? ?? 20 89 07 8D 88 00 01 00 00 EB 16 83 08 FF C6 40 04 00 C6 40 05 0A 8B 0F 83 C0 08 81 C1 00 01 00 00 3B C1 72 E6 83 C7 04 39 35 ?? ?? ?? ?? 7C BB EB 06 8B 35 ?? ?? ?? ?? 33 FF 85 F6 7E 46 8B 03 83 F8 FF 74 36 8A 4D 00 F6 C1 01 74 2E F6 C1 08 75 0B 50 FF 15 ?? ?? ?? ?? 85 C0 74 1E 8B C7 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B CF 83 E1 1F 8D 04 C8 8B 0B 89 08 8A 4D 00 88 48 04 47 45 83 C3 04 3B FE 7C BA 5D 33 DB A1 ?? ?? ?? ?? 8D 34 D8 83 3E FF 75 4D 85 DB C6 46 04 81 75 05 6A F6 58 EB 0A 8B C3 48 F7 D8 1B C0 83 C0 F5 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 74 17 57 FF 15 ?? ?? ?? ?? 85 C0 74 0C 25 FF 00 00 00 83 F8 02 89 3E 75 06 80 4E 04 40 EB 0F 83 F8 03 75 0A 80 4E 04 08 EB 04 80 4E 04 80 43 83 FB 03 7C 9C FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5F 5E 33 C0 5B 83 C4 44 C3 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "__ioterm"
		size = 35
		refs = "0002 ___pioinfo 000e _free"
	strings:
		$1 = { 56 BE ?? ?? ?? ?? 8B 06 85 C0 74 0A 50 E8 ?? ?? ?? ?? 83 26 00 59 83 C6 04 81 FE ?? ?? ?? ?? 7C E5 5E C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "_write_char"
		size = 37
		refs = "0012 _fputwc"
	strings:
		$1 = { F6 40 0C 40 74 06 83 78 08 00 74 16 50 FF 74 24 08 E8 ?? ?? ?? ?? 66 3D FF FF 59 59 75 04 83 0E FF C3 FF 06 C3 }
	condition:
		$1
}

rule file_90_1_0 {
	meta:
		name = "_write_multi_char"
		size = 37
		refs = "0012 _write_char"
	strings:
		$1 = { 55 8B EC 56 8B F0 EB 14 FF 75 08 8B 45 10 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 59 74 06 83 7D 0C 00 7F E6 5E 5D C3 }
	condition:
		$1
}

rule file_90_2_0 {
	meta:
		name = "_write_string"
		size = 61
		refs = "0027 _write_char"
	strings:
		$1 = { F6 47 0C 40 53 56 8B F0 8B D9 74 27 83 7F 08 00 75 21 8B 44 24 0C 01 06 EB 20 FF 4C 24 0C 33 C0 66 8B 03 50 8B C7 E8 ?? ?? ?? ?? 43 43 83 3E FF 59 74 07 83 7C 24 0C 00 7F E0 5E 5B C3 }
	condition:
		$1
}

rule file_90_5_0 {
	meta:
		name = "__woutput"
		size = 2096
		refs = "000f ___security_cookie 0067 ___lookuptable 008e $L2734 0259 _write_char 02e2 ___nullstring 0304 __pctype 0377 ___mb_cur_max 038b _mbtowc 0473 _malloc 04b4 __cfltcvt_tab 04f5 _strlen 0543 ___wnullstring 0686 __aulldvrm 0725 _write_multi_char 073c _write_string 07dc _free 0804 @__security_check_cookie@4 0810 $NORMAL_STATE$2348 0814 $L2349 0818 $L2350 081c $L2360 0820 $L2364 0824 $L2365 0828 $L2369 082c $L2385"
	strings:
		$1 = { 55 8D AC 24 28 FC FF FF 81 EC 58 04 00 00 A1 ?? ?? ?? ?? 8B 95 E4 03 00 00 89 85 D4 03 00 00 33 C0 53 66 8B 1A 33 C9 66 3B D8 89 45 C8 89 45 C0 89 45 A8 0F 84 C0 07 00 00 56 57 EB 03 8B 4D 98 6A 02 5F 01 BD E4 03 00 00 83 7D C0 00 0F 8C A4 07 00 00 6A 20 5E 66 3B DE 72 15 66 83 FB 78 77 0F 0F B7 C3 0F BE 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 0F BE 84 C1 ?? ?? ?? ?? 6A 07 C1 F8 04 59 3B C1 89 45 98 0F 87 5A 07 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 4D CC FF 89 45 94 89 45 A4 89 45 B8 89 45 BC 89 45 D0 89 45 B4 E9 36 07 00 00 0F B7 C3 2B C6 74 3B 83 E8 03 74 2D 83 E8 08 74 1F 2B C7 74 12 83 E8 03 0F 85 18 07 00 00 83 4D D0 08 E9 0F 07 00 00 83 4D D0 04 E9 06 07 00 00 83 4D D0 01 E9 FD 06 00 00 80 4D D0 80 E9 F4 06 00 00 09 7D D0 E9 EC 06 00 00 66 83 FB 2A 75 27 83 85 E8 03 00 00 04 8B 85 E8 03 00 00 8B 40 FC 85 C0 89 45 B8 0F 8D CB 06 00 00 83 4D D0 04 F7 5D B8 E9 BF 06 00 00 8B 45 B8 0F B7 CB 8D 04 80 8D 44 41 D0 89 45 B8 E9 AA 06 00 00 83 65 CC 00 E9 A1 06 00 00 66 83 FB 2A 75 24 83 85 E8 03 00 00 04 8B 85 E8 03 00 00 8B 40 FC 85 C0 89 45 CC 0F 8D 80 06 00 00 83 4D CC FF E9 77 06 00 00 8B 45 CC 0F B7 CB 8D 04 80 8D 44 41 D0 89 45 CC E9 62 06 00 00 0F B7 C3 83 F8 49 74 2D 83 F8 68 74 20 83 F8 6C 74 12 83 F8 77 0F 85 47 06 00 00 80 4D D1 08 E9 3E 06 00 00 83 4D D0 10 E9 35 06 00 00 09 75 D0 E9 2D 06 00 00 8B 85 E4 03 00 00 66 8B 00 66 3D 36 00 75 1D 8B 8D E4 03 00 00 66 83 79 02 34 75 10 83 85 E4 03 00 00 04 80 4D D1 80 E9 01 06 00 00 66 3D 33 00 75 1D 8B 8D E4 03 00 00 66 83 79 02 32 75 10 83 85 E4 03 00 00 04 80 65 D1 7F E9 DE 05 00 00 66 3D 64 00 0F 84 D4 05 00 00 66 3D 69 00 0F 84 CA 05 00 00 66 3D 6F 00 0F 84 C0 05 00 00 66 3D 75 00 0F 84 B6 05 00 00 66 3D 78 00 0F 84 AC 05 00 00 66 3D 58 00 0F 84 A2 05 00 00 83 65 98 00 8B 85 E0 03 00 00 53 8D 75 C0 C7 45 B4 01 00 00 00 E8 ?? ?? ?? ?? E9 82 05 00 00 0F B7 C3 83 F8 67 0F 8F 91 02 00 00 83 F8 65 0F 8D B3 00 00 00 83 F8 58 0F 8F 1B 01 00 00 0F 84 EE 02 00 00 83 E8 43 0F 84 BB 00 00 00 2B C7 0F 84 8A 00 00 00 2B C7 0F 84 82 00 00 00 83 E8 0C 0F 85 26 04 00 00 66 F7 45 D0 30 08 75 03 09 75 D0 8B 55 CC 83 FA FF 75 05 BA FF FF FF 7F 83 85 E8 03 00 00 04 F6 45 D0 20 8B 85 E8 03 00 00 8B 40 FC 89 45 C4 0F 84 61 02 00 00 85 C0 75 08 A1 ?? ?? ?? ?? 89 45 C4 83 65 C8 00 85 D2 8B 45 C4 0F 8E D6 03 00 00 8A 08 84 C9 0F 84 CC 03 00 00 8B 35 ?? ?? ?? ?? 0F B6 C9 F6 44 4E 01 80 74 01 40 40 FF 45 C8 39 55 C8 7C DC E9 AD 03 00 00 C7 45 94 01 00 00 00 03 DE 83 4D D0 40 83 7D CC 00 8D 75 D4 89 75 C4 0F 8D 03 01 00 00 C7 45 CC 06 00 00 00 E9 3F 01 00 00 66 F7 45 D0 30 08 75 03 09 75 D0 83 85 E8 03 00 00 04 8B 85 E8 03 00 00 0F B7 40 FC 33 F6 46 F6 45 D0 20 89 75 B4 89 45 90 74 6B FF 35 ?? ?? ?? ?? 88 45 AC 8D 45 AC 50 8D 45 D4 50 C6 45 AD 00 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7D 4E 89 75 A4 EB 49 83 E8 5A 74 52 83 E8 09 74 B0 48 0F 85 22 03 00 00 83 4D D0 40 C7 45 C8 0A 00 00 00 8B 5D D0 BE 00 80 00 00 85 DE 0F 84 23 02 00 00 8B 8D E8 03 00 00 8B 01 8B 51 04 83 C1 08 89 8D E8 03 00 00 E9 38 02 00 00 66 89 45 D4 8D 45 D4 89 45 C4 89 75 C8 E9 DC 02 00 00 83 85 E8 03 00 00 04 8B 85 E8 03 00 00 8B 40 FC 85 C0 74 2D 8B 48 04 85 C9 74 26 F6 45 D1 08 0F BF 00 89 4D C4 74 11 99 2B C2 D1 F8 C7 45 B4 01 00 00 00 E9 A1 02 00 00 83 65 B4 00 E9 98 02 00 00 A1 ?? ?? ?? ?? 89 45 C4 50 E9 B3 00 00 00 75 0F 66 83 FB 67 75 40 C7 45 CC 01 00 00 00 EB 37 B8 00 02 00 00 39 45 CC 7E 03 89 45 CC BF A3 00 00 00 39 7D CC 7E 20 8B 45 CC 05 5D 01 00 00 50 E8 ?? ?? ?? ?? 85 C0 59 89 45 A8 74 07 89 45 C4 8B F0 EB 03 89 7D CC 8B 85 E8 03 00 00 8B 08 FF 75 94 83 C0 08 FF 75 CC 89 85 E8 03 00 00 8B 40 FC 89 45 84 0F BE C3 50 8D 45 80 56 50 89 4D 80 FF 15 ?? ?? ?? ?? 8B 7D D0 83 C4 14 81 E7 80 00 00 00 74 0E 83 7D CC 00 75 08 56 FF 15 ?? ?? ?? ?? 59 66 83 FB 67 75 0C 85 FF 75 08 56 FF 15 ?? ?? ?? ?? 59 80 3E 2D 75 08 80 4D D1 01 46 89 75 C4 56 E8 ?? ?? ?? ?? 59 E9 CC 01 00 00 83 E8 69 0F 84 A4 FE FF FF 83 E8 05 0F 84 A9 00 00 00 48 0F 84 88 00 00 00 48 74 52 83 E8 03 0F 84 8F FD FF FF 2B C7 0F 84 84 FE FF FF 83 E8 03 0F 85 99 01 00 00 C7 45 9C 27 00 00 00 EB 39 85 C0 75 08 A1 ?? ?? ?? ?? 89 45 C4 8B 45 C4 C7 45 B4 01 00 00 00 EB 09 4A 66 83 38 00 74 06 03 C7 85 D2 75 F3 2B 45 C4 D1 F8 E9 5E 01 00 00 C7 45 CC 08 00 00 00 89 4D 9C F6 45 D0 80 C7 45 C8 10 00 00 00 0F 84 2F FE FF FF 8B 45 9C 83 C0 51 66 C7 45 B0 30 00 66 89 45 B2 89 7D BC E9 17 FE FF FF F6 45 D0 80 C7 45 C8 08 00 00 00 0F 84 06 FE FF FF 80 4D D1 02 E9 FD FD FF FF 83 85 E8 03 00 00 04 F6 45 D0 20 8B 85 E8 03 00 00 8B 40 FC 74 09 66 8B 4D C0 66 89 08 EB 05 8B 4D C0 89 08 C7 45 A4 01 00 00 00 E9 E8 01 00 00 83 85 E8 03 00 00 04 F6 C3 20 8B 85 E8 03 00 00 74 12 F6 C3 40 74 07 0F BF 40 FC 99 EB 10 0F B7 40 FC EB F7 F6 C3 40 8B 40 FC 75 EF 33 D2 F6 C3 40 74 15 85 D2 7F 11 7C 04 85 C0 73 0B F7 D8 83 D2 00 F7 DA 80 4D D1 01 85 75 D0 8B D8 8B FA 75 02 33 FF 83 7D CC 00 7D 09 C7 45 CC 01 00 00 00 EB 11 83 65 D0 F7 B8 00 02 00 00 39 45 CC 7E 03 89 45 CC 8B C3 0B C7 75 04 83 65 BC 00 8D B5 D3 01 00 00 8B 45 CC FF 4D CC 85 C0 7F 06 8B C3 0B C7 74 24 8B 45 C8 99 52 50 57 53 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 5D 8C 8B D8 8B FA 7E 03 03 4D 9C 88 0E 4E EB CC 8D 85 D3 01 00 00 2B C6 46 F6 45 D1 02 89 45 C8 89 75 C4 74 18 8B CE 80 39 30 75 04 85 C0 75 0D FF 4D C4 8B 4D C4 C6 01 30 40 89 45 C8 83 7D A4 00 0F 85 FA 00 00 00 8B 45 D0 A8 40 74 2A F6 C4 01 74 08 66 C7 45 B0 2D 00 EB 16 A8 01 74 08 66 C7 45 B0 2B 00 EB 0A A8 02 74 0D 66 C7 45 B0 20 00 C7 45 BC 01 00 00 00 8B 5D B8 2B 5D BC 2B 5D C8 F6 45 D0 0C 75 14 FF B5 E0 03 00 00 8D 45 C0 53 6A 20 E8 ?? ?? ?? ?? 83 C4 0C FF 75 BC 8B BD E0 03 00 00 8D 45 C0 8D 4D B0 E8 ?? ?? ?? ?? F6 45 D0 08 59 74 15 F6 45 D0 04 75 0F 57 53 6A 30 8D 45 C0 E8 ?? ?? ?? ?? 83 C4 0C 83 7D B4 00 75 47 8B 45 C8 85 C0 7E 40 8B 7D C4 89 45 A0 FF 35 ?? ?? ?? ?? FF 4D A0 8D 45 90 57 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 89 45 8C 7E 2C FF 75 90 8B 85 E0 03 00 00 8D 75 C0 E8 ?? ?? ?? ?? 03 7D 8C 83 7D A0 00 59 7F C8 EB 0F FF 75 C8 8B 4D C4 8D 45 C0 E8 ?? ?? ?? ?? 59 F6 45 D0 04 74 14 FF B5 E0 03 00 00 8D 45 C0 53 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 83 7D A8 00 74 0D FF 75 A8 E8 ?? ?? ?? ?? 83 65 A8 00 59 8B 85 E4 03 00 00 66 8B 18 66 85 DB 0F 85 46 F8 FF FF 5F 5E 8B 8D D4 03 00 00 8B 45 C0 5B E8 ?? ?? ?? ?? 81 C5 D8 03 00 00 C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "_wcsstr"
		size = 94
	strings:
		$1 = { 8B 4C 24 08 66 83 39 00 8B 44 24 04 57 8B F8 74 47 33 D2 66 8B 10 66 85 D2 53 74 39 2B C1 66 85 D2 8B 4C 24 10 74 1C 66 8B 11 66 85 D2 74 2B 0F B7 1C 08 0F B7 D2 2B DA 75 09 41 41 66 83 3C 08 00 75 E4 66 83 39 00 74 11 47 47 66 8B 17 40 40 66 85 D2 75 C9 33 C0 5B 5F C3 8B C7 EB F9 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__aulldiv"
		size = 104
	strings:
		$1 = { 53 56 8B 44 24 18 0B C0 75 18 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B D8 8B 44 24 0C F7 F1 8B D3 EB 41 8B C8 8B 5C 24 14 8B 54 24 10 8B 44 24 0C D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 18 8B C8 8B 44 24 14 F7 E6 03 D1 72 0E 3B 54 24 10 77 08 72 07 3B 44 24 0C 76 01 4E 33 D2 8B C6 5E 5B C2 10 00 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "_init_namebuf"
		size = 97
		refs = "0007 _namebuf0 000e _namebuf1 0013 ??_C@_01KICIPPFI@?2?$AA@ 0019 _strcpy 0047 __getpid 004d __ultoa 0052 ??_C@_01LFCBOECM@?4?$AA@ 0058 _strcat"
	strings:
		$1 = { 83 7C 24 04 00 56 BE ?? ?? ?? ?? 74 05 BE ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 8D 46 01 59 8A 48 FF 80 F9 5C 74 09 80 F9 2F 74 04 C6 00 5C 40 83 7C 24 08 00 74 05 C6 00 74 EB 03 C6 00 73 40 6A 20 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 14 5E C3 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "_genfname"
		size = 71
		refs = "000b __mbsrchr 0018 _strtoul 0034 __ultoa 003b _strcpy"
	strings:
		$1 = { 55 8B EC 51 56 6A 2E FF 75 08 E8 ?? ?? ?? ?? 8B F0 6A 20 46 6A 00 56 E8 ?? ?? ?? ?? 83 C4 14 40 3D FF 7F 00 00 72 05 83 C8 FF EB 18 6A 20 8D 4D FC 51 50 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C9 C3 }
	condition:
		$1
}

rule file_93_3_0 {
	meta:
		name = "_tmpnam"
		size = 78
		refs = "0006 _namebuf0 0014 _init_namebuf 001d _genfname 002a __access 0043 _strcpy"
	strings:
		$1 = { 56 57 33 FF 80 3D ?? ?? ?? ?? 00 BE ?? ?? ?? ?? 75 09 57 E8 ?? ?? ?? ?? 59 EB 0B 56 E8 ?? ?? ?? ?? 85 C0 59 75 23 6A 00 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 E7 8B 7C 24 0C 85 FF 75 04 8B FE EB 09 56 57 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_93_4_0 {
	meta:
		name = "_tmpfile"
		size = 215
		refs = "0007 _namebuf1 0017 _init_namebuf 0020 _genfname 002f __getstream 003b _errno 0059 __sopen 009a __strdup 00aa __close 00ba __commode"
	strings:
		$1 = { 51 83 24 24 00 80 3D ?? ?? ?? ?? 00 57 BF ?? ?? ?? ?? 75 0A 6A 01 E8 ?? ?? ?? ?? 59 EB 0F 57 E8 ?? ?? ?? ?? 85 C0 59 0F 85 A3 00 00 00 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 0F C7 05 ?? ?? ?? ?? 18 00 00 00 E9 87 00 00 00 53 55 68 80 01 00 00 6A 40 BB 42 85 00 00 53 57 E8 ?? ?? ?? ?? 8B E8 83 C4 10 83 FD FF 75 31 83 3D ?? ?? ?? ?? 11 75 23 57 E8 ?? ?? ?? ?? 85 C0 59 75 18 68 80 01 00 00 6A 40 53 57 E8 ?? ?? ?? ?? 8B E8 83 C4 10 83 FD FF 74 D4 83 FD FF 74 35 57 E8 ?? ?? ?? ?? 59 33 C9 3B C1 89 46 1C 75 09 55 E8 ?? ?? ?? ?? 59 EB 1C 89 4E 04 89 0E 89 4E 08 A1 ?? ?? ?? ?? 0D 80 00 00 00 89 46 0C 89 6E 10 89 74 24 10 5D 5B 5E 8B 44 24 04 5F 59 C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__hextodec"
		size = 77
		refs = "0010 ___mb_cur_max 001b __isctype 0025 __pctype 003c _iswctype"
	strings:
		$1 = { 66 F7 C6 00 FF 75 31 8B C6 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 04 66 8B C6 C3 6A 02 56 E8 ?? ?? ?? ?? 59 85 C0 59 8D 46 D9 75 03 8D 46 F9 C3 }
	condition:
		$1
}

rule file_96_3_0 {
	meta:
		name = "__whiteout"
		size = 26
		refs = "0004 __getwche 000c _iswspace"
	strings:
		$1 = { 57 FF 06 E8 ?? ?? ?? ?? 8B F8 57 E8 ?? ?? ?? ?? 85 C0 59 75 EC 66 8B C7 5F C3 }
	condition:
		$1
}

rule file_96_4_0 {
	meta:
		name = "_input"
		size = 3666
		refs = "0006 $T21120 000b __SEH_prolog 0010 ___security_cookie 0056 _iswctype 006d __getwche 0075 _iswspace 0080 __un_inc 0117 ___mb_cur_max 0122 __isctype 012f __pctype 0428 ___decimal_point 0434 _mbtowc 05bb _malloc 05d4 _wcstombs 05ea __cfltcvt_tab 05f0 _free 077e __alloca_probe 079b __resetstkoflw 07eb _memset 09b5 _wctomb 0b1d __allmul 0b85 __hextodec 0e48 @__security_check_cookie@4 0e4d __SEH_epilog"
	strings:
		$1 = { 68 24 03 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 33 DB 89 9D E8 FC FF FF 89 9D D4 FC FF FF 89 9D 04 FD FF FF 89 9D 10 FD FF FF 88 9D 0E FD FF FF 89 9D 20 FD FF FF 89 9D E0 FC FF FF 8B 45 08 0F B7 00 66 85 C0 0F 84 D1 0D 00 00 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 3C FF 8D 20 FD FF FF FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 85 C0 75 E8 56 E8 ?? ?? ?? ?? 59 83 45 08 02 8B 45 08 0F B7 00 50 E8 ?? ?? ?? ?? 59 85 C0 75 EB EB A7 8B 75 08 66 83 3E 25 0F 85 4F 0D 00 00 33 C0 89 85 FC FC FF FF 89 85 EC FC FF FF 89 85 08 FD FF FF 89 85 E4 FC FF FF 89 85 18 FD FF FF 88 85 F3 FC FF FF 88 85 0F FD FF FF 88 85 1D FD FF FF 88 85 27 FD FF FF 88 85 17 FD FF FF 88 85 1F FD FF FF C6 85 1E FD FF FF 01 89 85 D8 FC FF FF BE FF 00 00 00 8B 55 08 42 42 89 55 08 0F B7 3A 66 F7 C7 00 FF 75 4B 8B C7 23 C6 83 3D ?? ?? ?? ?? 01 7E 0F 6A 04 50 E8 ?? ?? ?? ?? 59 59 8B 55 08 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 1E FF 85 E4 FC FF FF 8B 85 18 FD FF FF 8D 04 80 8D 44 47 D0 89 85 18 FD FF FF E9 D7 00 00 00 83 FF 4E 0F 8F 9D 00 00 00 0F 84 C8 00 00 00 83 FF 2A 0F 84 86 00 00 00 83 FF 46 0F 84 B6 00 00 00 83 FF 49 74 14 83 FF 4C 0F 85 86 00 00 00 FE 85 1E FD FF FF E9 9D 00 00 00 66 8B 4A 02 66 83 F9 36 75 24 8D 42 04 66 83 38 34 75 1B 8B D0 89 55 08 FF 85 D8 FC FF FF 83 A5 F4 FC FF FF 00 83 A5 F8 FC FF FF 00 EB 6F 66 83 F9 33 75 10 8D 42 04 66 83 38 32 75 07 8B D0 89 55 08 EB 59 66 83 F9 64 74 53 66 83 F9 69 74 4D 66 83 F9 6F 74 47 66 83 F9 78 74 41 66 83 F9 58 75 19 EB 39 FE 85 1D FD FF FF EB 31 83 FF 68 74 20 83 FF 6C 74 0D 83 FF 77 74 0E FE 85 27 FD FF FF EB 1A FE 85 1E FD FF FF FE 85 1F FD FF FF EB 0C FE 8D 1E FD FF FF FE 8D 1F FD FF FF 80 BD 27 FD FF FF 00 0F 84 C2 FE FF FF 80 BD 1D FD FF FF 00 75 18 8B 45 0C 89 85 CC FC FF FF 83 C0 04 89 45 0C 8B 40 FC 89 85 04 FD FF FF C6 85 27 FD FF FF 00 80 BD 1F FD FF FF 00 75 1D 66 8B 02 66 3D 53 00 74 0D 66 3D 43 00 C6 85 1F FD FF FF 01 75 07 C6 85 1F FD FF FF FF 0F B7 3A 83 CF 20 89 BD 00 FD FF FF 83 FF 6E 74 39 83 FF 63 74 21 83 FF 7B 74 1C FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 85 C0 75 E8 8B DE EB 0D FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 8B B5 E4 FC FF FF 33 C9 3B F1 74 0C 39 8D 18 FD FF FF 0F 84 2C 0B 00 00 83 FF 6F 0F 8F E9 03 00 00 0F 84 29 07 00 00 83 FF 63 0F 84 F4 02 00 00 83 FF 64 0F 84 17 07 00 00 0F 8E F5 03 00 00 83 FF 67 7E 45 83 FF 69 74 21 83 FF 6E 0F 85 E2 03 00 00 8B 85 20 FD FF FF 80 BD 1D FD FF FF 00 0F 84 74 0A 00 00 E9 A7 0A 00 00 6A 64 5F 89 BD 00 FD FF FF 66 83 FB 2D 0F 85 8C 05 00 00 C6 85 0F FD FF FF 01 E9 86 05 00 00 8D BD 28 FD FF FF 66 83 FB 2D 75 0F 66 89 9D 28 FD FF FF 8D BD 2A FD FF FF EB 06 66 83 FB 2B 75 19 FF 8D 18 FD FF FF FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 83 BD E4 FC FF FF 00 74 0C 81 BD 18 FD FF FF 5D 01 00 00 7E 0A C7 85 18 FD FF FF 5D 01 00 00 F6 C7 FF 75 62 BE FF 00 00 00 8B C3 23 C6 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 33 8B 85 18 FD FF FF FF 8D 18 FD FF FF 85 C0 74 23 FF 85 08 FD FF FF 66 89 1F 47 47 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF F6 C7 FF 74 A3 FF 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 DC FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B B5 18 FD FF FF 66 39 9D DC FC FF FF 75 79 8B C6 4E 85 C0 74 72 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 66 8B 85 DC FC FF FF 66 89 07 47 47 EB 4C 8B C3 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 2A 8B C6 4E 85 C0 74 23 FF 85 08 FD FF FF 66 89 1F 47 47 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF F6 C7 FF 74 A9 83 BD 08 FD FF FF 00 0F 84 AA 00 00 00 66 83 FB 65 74 0A 66 83 FB 45 0F 85 9A 00 00 00 8B C6 4E 85 C0 0F 84 8F 00 00 00 66 C7 07 65 00 47 47 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 66 83 FB 2D 75 07 66 89 1F 47 47 EB 06 66 83 FB 2B 75 5D 8B C6 4E 85 C0 75 43 33 F6 EB 52 8B C3 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 2A 8B C6 4E 85 C0 74 23 FF 85 08 FD FF FF 66 89 1F 47 47 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF F6 C7 FF 74 A9 FF 8D 20 FD FF FF 53 E8 ?? ?? ?? ?? 59 83 BD 08 FD FF FF 00 0F 84 8F 08 00 00 80 BD 1D FD FF FF 00 0F 85 48 08 00 00 FF 85 E0 FC FF FF 66 83 27 00 8D 85 28 FD FF FF 2B F8 D1 FF 8D 74 3F 02 56 E8 ?? ?? ?? ?? 59 8B F8 85 FF 0F 84 59 08 00 00 56 8D 85 28 FD FF FF 50 57 E8 ?? ?? ?? ?? 57 FF B5 04 FD FF FF 0F BE 85 1E FD FF FF 48 50 FF 15 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 1C E9 ED 07 00 00 3B F1 75 10 C7 85 E4 FC FF FF 01 00 00 00 FF 85 18 FD FF FF 80 BD 1F FD FF FF 00 7E 07 C6 85 17 FD FF FF 01 8B B5 04 FD FF FF FF 8D 20 FD FF FF 53 E8 ?? ?? ?? ?? 59 83 BD E4 FC FF FF 00 74 14 8B 85 18 FD FF FF FF 8D 18 FD FF FF 85 C0 0F 84 89 03 00 00 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 83 FF 63 74 4B 83 FF 73 75 12 66 83 FB 09 72 06 66 83 FB 0D 76 06 66 83 FB 20 75 34 83 FF 7B 0F 85 44 03 00 00 0F B7 C3 8B C8 83 E1 07 33 D2 42 D3 E2 C1 E8 03 8B 8D E8 FC FF FF 0F BE 04 08 0F BE 8D F3 FC FF FF 33 C1 85 D0 0F 84 19 03 00 00 80 BD 1D FD FF FF 00 0F 85 05 03 00 00 80 BD 17 FD FF FF 00 0F 84 E0 02 00 00 8B 85 04 FD FF FF 66 89 18 83 85 04 FD FF FF 02 E9 51 FF FF FF 8B C7 83 E8 70 0F 84 34 03 00 00 83 E8 03 0F 84 1A FF FF FF 48 48 0F 84 2A 03 00 00 83 E8 03 0F 84 44 FC FF FF 83 E8 03 74 2D 8B 45 08 66 39 18 0F 85 04 07 00 00 FE 8D 0E FD FF FF 80 BD 1D FD FF FF 00 0F 85 BE 06 00 00 8B 85 CC FC FF FF 89 45 0C E9 B0 06 00 00 80 BD 1F FD FF FF 00 7E 07 C6 85 17 FD FF FF 01 8B 75 08 46 46 89 75 08 89 B5 D0 FC FF FF 66 83 3E 5E 75 10 83 C6 02 89 B5 D0 FC FF FF C6 85 F3 FC FF FF FF 39 8D E8 FC FF FF 75 68 89 4D FC B8 00 20 00 00 E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 85 E8 FC FF FF 83 4D FC FF EB 4A 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 E8 FC FF FF 85 C0 75 09 83 4D FC FF E9 66 06 00 00 C7 85 D4 FC FF FF 01 00 00 00 83 4D FC FF 8B B5 D0 FC FF FF 8B 9D 10 FD FF FF 8B BD 00 FD FF FF 68 00 20 00 00 6A 00 FF B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 83 FF 7B 75 1A 6A 5D 58 66 39 06 75 12 89 85 EC FC FF FF 46 46 8B 85 E8 FC FF FF C6 40 0B 20 33 C0 E9 A2 00 00 00 46 46 66 3D 2D 00 75 7B 66 83 BD EC FC FF FF 00 74 71 33 C9 66 8B 0E 66 83 F9 5D 74 66 46 46 66 39 8D EC FC FF FF 73 04 8B C1 EB 0C 8B 85 EC FC FF FF 89 8D EC FC FF FF 66 39 85 EC FC FF FF 77 39 0F B7 BD EC FC FF FF 2B 85 EC FC FF FF 40 0F B7 D0 8B C7 C1 E8 03 8B 8D E8 FC FF FF 03 C1 8B CF 83 E1 07 B3 01 D2 E3 08 18 47 4A 75 E4 8B 9D 10 FD FF FF 8B BD 00 FD FF FF 83 A5 EC FC FF FF 00 EB 1F 89 85 EC FC FF FF 0F B7 C8 8B C1 C1 E8 03 8B 95 E8 FC FF FF 03 C2 83 E1 07 B2 01 D2 E2 08 10 66 8B 06 66 3D 5D 00 0F 85 51 FF FF FF 66 85 C0 0F 84 53 05 00 00 83 FF 7B 0F 85 47 FD FF FF 89 75 08 E9 3F FD FF FF 66 83 FB 2B 75 28 FF 8D 18 FD FF FF 75 0D 3B F1 74 09 C6 85 27 FD FF FF 01 EB 13 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 66 83 FB 30 0F 85 4C 01 00 00 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 66 83 FB 78 74 4A 66 83 FB 58 74 44 C7 85 08 FD FF FF 01 00 00 00 83 FF 78 74 20 85 F6 74 0E FF 8D 18 FD FF FF 75 06 FE 85 27 FD FF FF 6A 6F 5F 89 BD 00 FD FF FF E9 FE 00 00 00 FF 8D 20 FD FF FF 53 E8 ?? ?? ?? ?? 59 6A 30 5B E9 E3 00 00 00 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 85 F6 74 16 83 AD 18 FD FF FF 02 83 BD 18 FD FF FF 01 7D 06 FE 85 27 FD FF FF 6A 78 EB AE 53 FF B5 04 FD FF FF E8 ?? ?? ?? ?? 59 01 85 04 FD FF FF E9 6D FC FF FF 46 46 E9 67 FC FF FF FF 8D 20 FD FF FF 53 E8 ?? ?? ?? ?? 59 3B B5 04 FD FF FF 0F 84 3E 04 00 00 80 BD 1D FD FF FF 00 0F 85 F7 03 00 00 FF 85 E0 FC FF FF 83 FF 63 0F 84 E8 03 00 00 8B 85 04 FD FF FF 80 BD 17 FD FF FF 00 74 09 66 83 20 00 E9 D0 03 00 00 C6 00 00 E9 C8 03 00 00 C6 85 1E FD FF FF 01 66 83 FB 2D 75 09 C6 85 0F FD FF FF 01 EB 06 66 83 FB 2B 75 28 FF 8D 18 FD FF FF 75 0D 3B F1 74 09 C6 85 27 FD FF FF 01 EB 13 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 83 BD D8 FC FF FF 00 0F 84 C3 01 00 00 80 BD 27 FD FF FF 00 0F 85 85 01 00 00 BF FF 00 00 00 83 BD 00 FD FF FF 78 0F 84 9E 00 00 00 83 BD 00 FD FF FF 70 0F 84 91 00 00 00 F6 C7 FF 0F 85 E6 00 00 00 8B C3 23 C7 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 0F 84 B8 00 00 00 83 BD 00 FD FF FF 6F 75 2E 66 83 FB 38 0F 83 A5 00 00 00 8B 85 F4 FC FF FF 8B 8D F8 FC FF FF 0F A4 C1 03 C1 E0 03 89 85 F4 FC FF FF 89 8D F8 FC FF FF E9 87 00 00 00 6A 00 6A 0A FF B5 F8 FC FF FF FF B5 F4 FC FF FF E8 ?? ?? ?? ?? 89 85 F4 FC FF FF 89 95 F8 FC FF FF EB 64 F6 C7 FF 75 59 8B C3 23 C7 83 3D ?? ?? ?? ?? 01 7E 0F 68 80 00 00 00 50 E8 ?? ?? ?? ?? 59 59 EB 0F 8B 0D ?? ?? ?? ?? 0F B6 04 41 25 80 00 00 00 85 C0 74 2A 8B 85 F4 FC FF FF 8B 8D F8 FC FF FF 0F A4 C1 04 C1 E0 04 89 85 F4 FC FF FF 89 8D F8 FC FF FF 8B F3 E8 ?? ?? ?? ?? 8B D8 EB 06 FE 85 27 FD FF FF 80 BD 27 FD FF FF 00 75 42 FF 85 08 FD FF FF 0F B7 C3 83 E8 30 99 01 85 F4 FC FF FF 11 95 F8 FC FF FF 83 BD E4 FC FF FF 00 74 11 FF 8D 18 FD FF FF 75 09 C6 85 27 FD FF FF 01 EB 1C FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 EB 0D FF 8D 20 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 27 FD FF FF 00 0F 84 8C FE FF FF 89 9D 10 FD FF FF 8B BD 00 FD FF FF 80 BD 0F FD FF FF 00 0F 84 72 01 00 00 8B 85 F4 FC FF FF F7 D8 8B 8D F8 FC FF FF 83 D1 00 F7 D9 89 85 F4 FC FF FF 89 8D F8 FC FF FF E9 4E 01 00 00 80 BD 27 FD FF FF 00 0F 85 32 01 00 00 BF FF 00 00 00 83 BD 00 FD FF FF 78 74 67 83 BD 00 FD FF FF 70 74 5E F6 C7 FF 0F 85 9B 00 00 00 8B C3 23 C7 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 71 83 BD 00 FD FF FF 6F 75 0F 66 83 FB 38 73 62 C1 A5 FC FC FF FF 03 EB 5F 8B 85 FC FC FF FF 8D 04 80 D1 E0 89 85 FC FC FF FF EB 4C F6 C7 FF 75 41 8B C3 23 C7 83 3D ?? ?? ?? ?? 01 7E 0F 68 80 00 00 00 50 E8 ?? ?? ?? ?? 59 59 EB 0F 8B 0D ?? ?? ?? ?? 0F B6 04 41 25 80 00 00 00 85 C0 74 12 C1 A5 FC FC FF FF 04 8B F3 E8 ?? ?? ?? ?? 8B D8 EB 06 FE 85 27 FD FF FF 80 BD 27 FD FF FF 00 75 42 FF 85 08 FD FF FF 0F B7 C3 8B 8D FC FC FF FF 8D 44 01 D0 89 85 FC FC FF FF 83 BD E4 FC FF FF 00 74 11 FF 8D 18 FD FF FF 75 09 C6 85 27 FD FF FF 01 EB 1C FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 EB 0D FF 8D 20 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 27 FD FF FF 00 0F 84 DF FE FF FF 89 9D 10 FD FF FF 8B BD 00 FD FF FF 80 BD 0F FD FF FF 00 74 06 F7 9D FC FC FF FF 83 FF 46 75 07 83 A5 08 FD FF FF 00 83 BD 08 FD FF FF 00 0F 84 87 00 00 00 80 BD 1D FD FF FF 00 75 44 FF 85 E0 FC FF FF 8B 85 FC FC FF FF 83 BD D8 FC FF FF 00 74 19 8B 8D F4 FC FF FF 8B 85 04 FD FF FF 89 08 8B 8D F8 FC FF FF 89 48 04 EB 16 8B 8D 04 FD FF FF 80 BD 1E FD FF FF 00 74 04 89 01 EB 03 66 89 01 FE 85 0E FD FF FF 83 45 08 02 E9 4B F2 FF FF FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 66 8B 06 46 46 89 75 08 66 3B C3 0F 84 27 F2 FF FF 53 E8 ?? ?? ?? ?? 59 83 BD D4 FC FF FF 01 75 0C FF B5 E8 FC FF FF E8 ?? ?? ?? ?? 59 8B 85 E0 FC FF FF 8D A5 C0 FC FF FF 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_96_5_0 {
	meta:
		name = "__cwscanf"
		size = 17
		refs = "000a _input"
		altNames = "__cscanf"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_425_7_0 {
	meta:
		name = "__cprintf"
		size = 17
		refs = "000a _output"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_363_6_0 {
	meta:
		name = "__cwprintf"
		size = 17
		refs = "000a _output"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "__execlp"
		size = 17
		refs = "000a __execvp"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_716_0_0 {
	meta:
		name = "__wexeclp"
		size = 17
		refs = "000a __wexecvp"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__lseek"
		size = 140
		refs = "0006 __nhandle 001c ___pioinfo 002e __get_osfhandle 0045 __imp__SetFilePointer@16 0052 __imp__GetLastError@0 0060 __dosmaperr 0076 __doserrno 007d _errno"
	strings:
		$1 = { 8B 44 24 04 3B 05 ?? ?? ?? ?? 53 56 57 73 65 8B C8 C1 F9 05 8B F0 83 E6 1F 8D 3C 8D ?? ?? ?? ?? 8B 0F C1 E6 03 F6 44 31 04 01 74 48 50 E8 ?? ?? ?? ?? 83 F8 FF 59 74 43 FF 74 24 18 6A 00 FF 74 24 1C 50 FF 15 ?? ?? ?? ?? 8B D8 83 FB FF 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 EB 1E 8B 07 8D 44 30 04 80 20 FD 8B C3 EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5E 5B C3 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "___addl"
		size = 33
	strings:
		$1 = { 8B 54 24 04 56 8B 74 24 0C 8D 0C 32 33 C0 3B CA 72 04 3B CE 73 03 33 C0 40 8B 54 24 10 89 0A 5E C3 }
	condition:
		$1
}

rule file_98_1_0 {
	meta:
		name = "___add_12"
		size = 94
		refs = "0010 ___addl"
	strings:
		$1 = { 56 8B 74 24 08 57 8B 7C 24 10 56 FF 37 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 17 8D 46 04 50 6A 01 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 03 FF 46 08 8D 46 04 50 FF 77 04 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 03 FF 46 08 8D 46 08 50 FF 77 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C3 }
	condition:
		$1
}

rule file_98_2_0 {
	meta:
		name = "___shl_12"
		size = 46
	strings:
		$1 = { 8B 44 24 04 56 8B 30 8B CE 03 F6 57 8B 78 04 C1 E9 1F 89 30 8D 34 3F 0B F1 8B 48 08 8B D7 C1 EA 1F D1 E1 0B CA 5F 89 70 04 89 48 08 5E C3 }
	condition:
		$1
}

rule file_98_3_0 {
	meta:
		name = "___shr_12"
		size = 45
	strings:
		$1 = { 8B 44 24 04 8B 50 08 8B 48 04 56 57 8B F9 8B F2 D1 E9 C1 E6 1F 0B CE 89 48 04 8B 08 C1 E7 1F D1 E9 0B CF D1 EA 5F 89 50 08 89 08 5E C3 }
	condition:
		$1
}

rule file_98_4_0 {
	meta:
		name = "___mtold12"
		size = 222
		refs = "0007 ___security_cookie 0039 ___shl_12 0049 ___add_12 00d8 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 53 8B 5D 10 33 D2 89 45 FC 8B 45 0C 3B C2 56 57 C7 45 EC 4E 40 00 00 89 13 89 53 04 89 53 08 76 4F 89 45 10 8B F3 8D 7D F0 A5 A5 53 A5 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8D 45 F0 50 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B 45 08 0F BE 00 83 65 F4 00 83 65 F8 00 89 45 F0 8D 45 F0 50 53 E8 ?? ?? ?? ?? 83 C4 1C FF 45 08 FF 4D 10 75 B6 33 D2 39 53 08 75 2F 8B 7B 08 8B 4B 04 81 45 EC F0 FF 00 00 8B C1 C1 E8 10 8B F8 8B 03 8B F0 C1 EE 10 C1 E1 10 0B F1 C1 E0 10 3B FA 89 73 04 89 03 74 D7 89 7B 08 BE 00 80 00 00 EB 0E 53 E8 ?? ?? ?? ?? 81 45 EC FF FF 00 00 59 85 73 08 74 ED 66 8B 45 EC 8B 4D FC 5F 5E 66 89 43 0A 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__wsplitpath"
		size = 347
		refs = "0012 _wcslen 002f _wcsncpy"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 08 56 57 33 FF 53 89 7D FC E8 ?? ?? ?? ?? 83 F8 01 59 72 26 66 83 7B 02 3A 75 1F 8B 75 0C 3B F7 74 10 6A 02 53 56 E8 ?? ?? ?? ?? 83 C4 0C 66 89 7E 04 83 C3 04 89 5D 08 EB 0A 8B 45 0C 3B C7 74 03 66 89 38 33 C0 66 8B 03 66 85 C0 89 7D F8 8B FB BE FF 00 00 00 74 61 66 3D 2F 00 74 11 66 3D 5C 00 74 0B 66 3D 2E 00 75 0B 89 7D FC EB 06 8D 47 02 89 45 F8 47 47 66 8B 07 66 85 C0 75 D9 8B 45 F8 85 C0 74 33 83 7D 10 00 74 23 2B C3 D1 E8 3B C6 8B D8 72 02 8B DE 53 FF 75 08 FF 75 10 E8 ?? ?? ?? ?? 8B 45 10 83 C4 0C 66 83 24 58 00 8B 45 F8 89 45 08 8B D8 EB 0B 8B 45 10 85 C0 74 04 66 83 20 00 8B 45 FC 85 C0 74 53 3B C3 72 4F 83 7D 14 00 74 23 2B C3 D1 E8 3B C6 8B D8 72 02 8B DE 53 FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 8B 45 14 83 C4 0C 66 83 24 58 00 8B 5D 18 85 DB 74 4F 2B 7D FC D1 EF 3B FE 73 02 8B F7 56 FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 0C 66 83 24 73 00 EB 30 83 7D 14 00 74 1F 2B FB D1 EF 3B FE 73 02 8B F7 56 53 FF 75 14 E8 ?? ?? ?? ?? 8B 45 14 83 C4 0C 66 83 24 70 00 8B 45 18 85 C0 74 04 66 83 20 00 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__wmktemp"
		size = 159
		refs = "000e __getpid 0051 _errno 0066 __waccess"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 8B F7 33 DB E8 ?? ?? ?? ?? 66 39 1F 74 23 46 46 66 83 3E 00 75 F8 EB 19 66 83 3E 58 75 71 83 FB 05 7D 14 6A 0A 33 D2 59 F7 F1 43 83 C2 30 66 89 16 4E 4E 3B F7 73 E1 66 83 3E 58 75 52 83 FB 05 7C 4D 66 C7 06 61 00 A1 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 6A 62 5B 89 45 08 6A 00 57 E8 ?? ?? ?? ?? 85 C0 59 59 74 09 83 3D ?? ?? ?? ?? 0D 75 12 33 C0 83 FB 7B A3 ?? ?? ?? ?? 74 08 66 89 1E 43 EB D7 8B C7 8B 4D 08 89 0D ?? ?? ?? ?? EB 02 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__getw"
		size = 62
		refs = "0020 __filbuf"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 57 6A 04 8D 7D 08 5B FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 88 07 47 4B 75 E4 F6 46 0C 30 5F 5E 5B 75 05 8B 45 08 5D C3 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__mbctolower"
		size = 120
		refs = "001d __mbctype 002b ___mbcodepage 0042 ___mblcid 0047 ___crtLCMapStringA 006d __mbcasemap"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 81 FB FF 00 00 00 76 51 8B C3 C1 E8 08 88 45 0A 0F B6 C0 F6 80 ?? ?? ?? ?? 04 88 5D 0B 74 4C 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC 6A 02 50 6A 02 8D 45 0A 50 68 00 01 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 21 0F B6 45 FC 0F B6 4D FD C1 E0 08 03 C1 EB 14 F6 83 ?? ?? ?? ?? 10 74 09 0F B6 83 ?? ?? ?? ?? EB 02 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__wdospawn"
		size = 477
		refs = "0035 _errno 003f __doserrno 0071 _memset 007a __nhandle 0090 ___pioinfo 00b5 _calloc 0168 __imp__CreateProcessW@40 0170 __imp__GetLastError@0 017a _free 0185 __dosmaperr 0197 __exit 01a0 __imp__CloseHandle@4 01ad __imp__WaitForSingleObject@8 01ba __imp__GetExitCodeProcess@8"
	strings:
		$1 = { 55 8B EC 83 EC 68 8B 45 08 53 33 DB 3B C3 89 5D F4 88 5D FF 74 15 83 F8 01 74 10 7E 16 83 F8 03 7E 09 83 F8 04 75 0C C6 45 FF 01 8B 45 10 89 45 F0 EB 2E C7 05 ?? ?? ?? ?? 16 00 00 00 89 1D ?? ?? ?? ?? 83 C8 FF E9 8F 01 00 00 40 40 66 39 18 75 F9 8D 48 02 66 39 19 74 07 66 C7 00 20 00 8B C1 66 39 18 75 E5 56 6A 44 5E 56 8D 45 98 53 50 E8 ?? ?? ?? ?? 89 75 98 8B 35 ?? ?? ?? ?? 83 C4 0C 3B F3 74 20 8D 46 FF 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 8B D0 83 E2 1F 38 5C D1 04 75 06 4E 48 3B F3 75 E3 8D 44 B6 04 66 89 45 CA 57 0F B7 C0 6A 01 50 E8 ?? ?? ?? ?? 3B F3 89 45 CC 59 89 30 8B 45 CC 59 89 5D F8 8D 48 04 8D 54 30 04 7E 39 8B 45 F8 8B 7D F8 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E7 1F 8D 3C F8 8A 47 04 A8 10 75 08 88 01 8B 07 89 02 EB 05 88 19 83 0A FF FF 45 F8 41 83 C2 04 39 75 F8 7C CA 8B 45 CC 38 5D FF 74 2C 8D 48 04 33 D2 8D 44 30 04 83 FE 03 7D 04 8B FE EB 03 6A 03 5F 3B D7 7D 0C 88 19 83 08 FF 42 41 83 C0 04 EB E4 C7 45 F4 08 00 00 00 8D 45 DC 50 8D 45 98 50 8B 45 F4 53 FF 75 14 0D 00 04 00 00 50 6A 01 53 53 FF 75 F0 89 1D ?? ?? ?? ?? FF 75 0C 89 1D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? FF 75 CC 8B F8 E8 ?? ?? ?? ?? 3B F3 59 75 0C 57 E8 ?? ?? ?? ?? 59 83 C8 FF EB 49 83 7D 08 02 75 06 53 E8 ?? ?? ?? ?? 39 5D 08 8B 35 ?? ?? ?? ?? 75 22 6A FF FF 75 DC FF 15 ?? ?? ?? ?? 8D 45 EC 50 FF 75 DC FF 15 ?? ?? ?? ?? 8B 5D EC FF 75 DC FF D6 EB 09 83 7D 08 04 74 F3 8B 5D DC FF 75 E0 FF D6 8B C3 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__time64"
		size = 60
		refs = "000b __imp__GetSystemTimeAsFileTime@4 002a __aulldiv"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 45 F8 8B 4D FC 6A 00 05 00 80 C1 2A 68 80 96 98 00 81 D1 21 4E 62 FE 51 50 E8 ?? ?? ?? ?? 8B 4D 08 85 C9 74 05 89 01 89 51 04 C9 C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__wputenv"
		size = 203
		refs = "000a ___env_initialized 0017 _wcslen 0021 _malloc 0033 _wcscpy 003e ___crtwsetenv 0052 _free 005e __environ 0068 __imp__WideCharToMultiByte@32 00a7 ___crtsetenv"
	strings:
		$1 = { 55 8B EC 51 51 56 33 F6 39 35 ?? ?? ?? ?? 89 75 F8 74 44 FF 75 08 E8 ?? ?? ?? ?? 8D 44 00 02 50 E8 ?? ?? ?? ?? 3B C6 59 59 89 45 F8 74 29 FF 75 08 50 E8 ?? ?? ?? ?? 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 13 39 75 F8 74 09 FF 75 F8 E8 ?? ?? ?? ?? 59 83 C8 FF EB 6C 39 35 ?? ?? ?? ?? 53 57 74 5E 8B 3D ?? ?? ?? ?? 56 56 56 56 6A FF FF 75 08 89 75 FC 56 56 FF D7 8B D8 3B DE 74 3D 53 E8 ?? ?? ?? ?? 3B C6 59 89 45 FC 74 2F 56 56 53 50 6A FF FF 75 08 56 56 FF D7 85 C0 74 15 8D 45 FC 56 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 13 39 75 FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "__ismbcgraph"
		size = 137
		refs = "0023 ___ismbcodepage 0035 ___mblcid 003e ___mbcodepage 004c ___crtGetStringTypeA 0070 __pctype 007e __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5C 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 74 54 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 2E 66 83 7D FE 00 75 27 66 F7 45 FC 17 01 74 1F 33 C0 40 C9 C3 0F B6 C1 8B 0D ?? ?? ?? ?? 66 F7 04 41 17 01 75 EA F6 80 ?? ?? ?? ?? 03 75 E1 33 C0 C9 C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "_setvbuf"
		size = 161
		refs = "0039 __flush 003f __freebuf 0067 _malloc 0072 __cflush"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 53 8B 5D 10 83 FB 04 57 8B 7D 14 74 1B 83 FF 02 72 11 81 FF FF FF FF 7F 77 09 85 DB 74 0A 83 FB 40 74 05 83 C8 FF EB 6D 56 8B 75 08 56 83 E7 FE E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 66 81 66 0C F3 C2 F6 C3 04 59 59 8B 4E 0C 74 0B 6A 02 83 C9 04 8D 46 14 5F EB 2C 8B 45 0C 85 C0 75 1F 57 E8 ?? ?? ?? ?? 85 C0 59 75 0C FF 05 ?? ?? ?? ?? 83 4D FC FF EB 1D 66 81 4E 0C 08 04 EB 09 81 C9 00 05 00 00 89 4E 0C 83 66 04 00 89 7E 18 89 46 08 89 06 8B 45 FC 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "__mbscoll"
		size = 48
		refs = "0002 ___mbcodepage 0016 ___mblcid 001b ___crtCompareStringA"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? 6A FF FF 74 24 10 6A FF FF 74 24 14 6A 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 06 B8 FF FF FF 7F C3 83 C0 FE C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__heapchk"
		size = 83
		refs = "0002 ___active_heap 000e ___sbh_heap_check 001f __crtheap 0025 __imp__HeapValidate@12 002f __imp__GetLastError@0 003c __doserrno 0042 _errno"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 03 56 6A FE 5E 75 0C E8 ?? ?? ?? ?? 85 C0 7D 03 6A FC 5E 6A 00 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 22 FF 15 ?? ?? ?? ?? 6A 78 59 3B C1 75 12 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 28 00 00 00 EB 03 6A FC 5E 8B C6 5E C3 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__startTwoArgErrorHandling"
		size = 23
	strings:
		$1 = { 55 8B EC 83 C4 E0 89 45 E0 8B 45 18 89 45 F0 8B 45 1C 89 45 F4 EB 09 }
	condition:
		$1
}

rule file_115_1_0 {
	meta:
		name = "__startOneArgErrorHandling"
		size = 60
		refs = "0025 __87except"
	strings:
		$1 = { 55 8B EC 83 C4 E0 89 45 E0 DD 5D F8 89 4D E4 8B 45 10 8B 4D 14 89 45 E8 89 4D EC 8D 45 08 8D 4D E0 50 51 52 E8 ?? ?? ?? ?? 83 C4 0C DD 45 F8 66 81 7D 08 7F 02 74 03 D9 6D 08 C9 C3 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "_strxfrm"
		size = 155
		refs = "001a ___lc_handle 0022 ___lc_collate_cp 0034 _strncpy 003c _strlen 005a ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 10 57 BF FF FF FF 7F 3B DF 89 7D FC 76 04 8B C7 EB 7E A1 ?? ?? ?? ?? 85 C0 8B 0D ?? ?? ?? ?? 75 1D 85 C9 75 19 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 EB 52 56 6A 01 51 6A 00 6A 00 6A FF FF 75 0C BE 00 04 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 2E 3B C3 89 45 FC 7F 27 6A 01 FF 35 ?? ?? ?? ?? 53 FF 75 08 6A FF FF 75 0C 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 03 89 7D FC 8B 45 FC 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__amsg_exit"
		size = 37
		refs = "0002 ___error_mode 000a __FF_MSGBANNER 0013 __NMSG_WRITE 001e __aexit_rtn"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? FF 74 24 04 E8 ?? ?? ?? ?? 68 FF 00 00 00 FF 15 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "_fast_error_exit"
		size = 36
		refs = "0002 ___error_mode 000a __FF_MSGBANNER 0013 __NMSG_WRITE 001d ___crtExitProcess"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? FF 74 24 04 E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "_check_managed_app"
		size = 86
		refs = "0004 __imp__GetModuleHandleA@4"
	strings:
		$1 = { 6A 00 FF 15 ?? ?? ?? ?? 66 81 38 4D 5A 75 1F 8B 48 3C 03 C8 81 39 50 45 00 00 75 12 0F B7 41 18 3D 0B 01 00 00 74 1D 3D 0B 02 00 00 74 03 33 C0 C3 33 C0 83 B9 84 00 00 00 0E 76 19 39 81 F8 00 00 00 EB 0E 33 C0 83 79 74 0E 76 09 39 81 E8 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "_wmainCRTStartup"
		size = 454
		refs = "0003 $T20686 0008 __SEH_prolog 0014 __alloca_probe 0022 __imp__GetVersionExA@4 002b __osplatform 0033 __winmajor 003c __winminor 004b __osver 0066 __winver 006f __imp__GetModuleHandleA@4 00c7 __heap_init 00d2 ___error_mode 00da __FF_MSGBANNER 00e1 __NMSG_WRITE 00eb ___crtExitProcess 00f2 __RTC_Initialize 00fa __ioinit 0105 __amsg_exit 010b ___crtGetCommandLineW 0110 __wcmdln 0115 ___crtGetEnvironmentStringsW 011a __wenvptr 011f __wsetargv 0130 __wsetenvp 0143 __cinit 0157 __wenviron 015c ___winitenv 0163 ___wargv 0169 ___argc 016e _wmain 0181 _exit 0186 __cexit 0199 __XcptFilter 01ae __exit 01b3 __c_exit 01c1 __SEH_epilog"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 89 65 E8 8B F4 89 3E 56 FF 15 ?? ?? ?? ?? 8B 4E 10 89 0D ?? ?? ?? ?? 8B 46 04 A3 ?? ?? ?? ?? 8B 56 08 89 15 ?? ?? ?? ?? 8B 76 0C 81 E6 FF 7F 00 00 89 35 ?? ?? ?? ?? 83 F9 02 74 0C 81 CE 00 80 00 00 89 35 ?? ?? ?? ?? C1 E0 08 03 C2 A3 ?? ?? ?? ?? 33 FF 57 FF 15 ?? ?? ?? ?? 66 81 38 4D 5A 75 1F 8B 48 3C 03 C8 81 39 50 45 00 00 75 12 0F B7 41 18 3D 0B 01 00 00 74 1F 3D 0B 02 00 00 74 05 89 7D E4 EB 27 83 B9 84 00 00 00 0E 76 F2 33 C0 39 B9 F8 00 00 00 EB 0E 83 79 74 0E 76 E2 33 C0 39 B9 E8 00 00 00 0F 95 C0 89 45 E4 57 E8 ?? ?? ?? ?? 59 85 C0 75 21 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? 6A 1C E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 89 7D FC E8 ?? ?? ?? ?? 85 C0 7D 08 6A 1B E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 89 45 DC 3B C7 74 07 50 E8 ?? ?? ?? ?? 59 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 50 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B F0 89 75 D8 39 7D E4 75 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2B 8B 45 EC 8B 08 8B 09 89 4D E0 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 75 E0 83 7D E4 00 75 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D FC FF 8B C6 8D 65 CC E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "_memset"
		size = 96
	strings:
		$1 = { 8B 54 24 0C 8B 4C 24 04 85 D2 74 4F 33 C0 8A 44 24 08 57 8B F9 83 FA 04 72 31 F7 D9 83 E1 03 74 0C 2B D1 88 07 83 C7 01 83 E9 01 75 F6 8B C8 C1 E0 08 03 C1 8B C8 C1 E0 10 03 C1 8B CA 83 E2 03 C1 E9 02 74 06 F3 AB 85 D2 74 0A 88 07 83 C7 01 83 EA 01 75 F6 8B 44 24 08 5F C3 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__fltinf"
		size = 162
		refs = "0007 ___security_cookie 0027 ___strgtold12 004d __ld12tod 0079 _flt 009c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 53 57 6A 01 FF 75 14 33 FF FF 75 10 89 45 FC 57 FF 75 08 8D 45 E4 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B D8 83 C4 1C F6 C3 04 74 0F 83 65 E8 00 83 65 EC 00 BF 00 02 00 00 EB 2E 8D 45 E8 50 8D 45 F0 50 E8 ?? ?? ?? ?? F6 C3 02 59 59 75 05 83 F8 01 75 05 BF 80 00 00 00 F6 C3 01 75 05 83 F8 02 75 06 81 CF 00 01 00 00 8B 4D E4 2B 4D 08 A1 ?? ?? ?? ?? 39 4D 0C 89 48 04 74 03 83 CF 40 8B 4D E8 89 48 10 8B 4D EC 89 38 89 48 14 8B 4D FC 5F 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_wcscmp"
		size = 50
	strings:
		$1 = { 8B 54 24 04 56 8B 74 24 0C 57 EB 09 66 85 C9 74 11 42 42 46 46 66 8B 0E 0F B7 02 0F B7 F9 2B C7 74 EA 85 C0 5F 5E 7D 04 83 C8 FF C3 7E 03 33 C0 40 C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "__filelengthi64"
		size = 158
		refs = "000c __nhandle 001a ___pioinfo 0034 __lseeki64 0087 __doserrno 0091 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 10 57 8B 7D 08 3B 3D ?? ?? ?? ?? 73 73 8B C7 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B CF 83 E1 1F F6 44 C8 04 01 74 5B 53 56 6A 01 33 F6 56 56 57 E8 ?? ?? ?? ?? 8B D8 23 C2 89 55 F4 83 CA FF 83 C4 10 3B C2 75 08 89 55 F8 89 55 FC EB 2A 6A 02 56 56 57 E8 ?? ?? ?? ?? 83 C4 10 3B D8 89 45 F8 89 55 FC 75 05 39 55 F4 74 0E 56 FF 75 F4 53 57 E8 ?? ?? ?? ?? 83 C4 10 8B 45 F8 8B 55 FC 5E 5B EB 16 83 25 ?? ?? ?? ?? 00 83 CA FF C7 05 ?? ?? ?? ?? 09 00 00 00 8B C2 5F C9 C3 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "_wcsncpy"
		size = 61
	strings:
		$1 = { 8B 4C 24 0C 85 C9 56 57 8B 7C 24 0C 8B F7 74 28 8B 54 24 10 66 8B 02 66 89 07 47 47 42 42 66 85 C0 74 03 49 75 EE 85 C9 74 0E 49 74 0B 33 C0 D1 E9 F3 AB 13 C9 66 F3 AB 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "_swscanf"
		size = 54
		refs = "0018 _wcslen 002d __winput"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 50 C7 45 EC 49 00 00 00 89 45 E8 89 45 E0 E8 ?? ?? ?? ?? D1 E0 89 45 E4 8D 45 10 50 FF 75 0C 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 C9 C3 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__wfindfirsti64"
		size = 251
		refs = "000a ___security_cookie 001e __imp__FindFirstFileW@8 002b __imp__GetLastError@0 0047 _errno 008f ___timet_from_ft 00c4 __allmul 00e6 _wcscpy 00f5 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 89 45 FC 57 8D 85 AC FD FF FF 50 FF 75 08 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 42 FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 28 83 F8 08 74 17 83 F8 12 74 1E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 99 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EC 89 0D ?? ?? ?? ?? EB E4 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 53 56 8B 75 0C 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 6A 00 6A 00 FF B5 C8 FD FF FF 89 46 0C E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 DB 03 C1 13 D3 89 46 10 8D 85 D8 FD FF FF 89 56 14 50 83 C6 18 56 E8 ?? ?? ?? ?? 59 59 5E 8B C7 5B 8B 4D FC 5F E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "__wfindnexti64"
		size = 246
		refs = "000a ___security_cookie 001d __imp__FindNextFileW@8 0027 __imp__GetLastError@0 0043 _errno 008b ___timet_from_ft 00c0 __allmul 00e2 _wcscpy 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 89 45 FC 8D 85 AC FD FF FF 50 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 42 FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 28 83 F8 08 74 17 83 F8 12 74 1E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 99 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EC 89 0D ?? ?? ?? ?? EB E4 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 56 8B 75 0C 89 06 8D 85 B0 FD FF FF 57 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 6A 00 6A 00 FF B5 C8 FD FF FF 89 46 0C E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 FF 03 C1 13 D7 89 46 10 8D 85 D8 FD FF FF 89 56 14 50 83 C6 18 56 E8 ?? ?? ?? ?? 59 59 5F 33 C0 5E 8B 4D FC E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__fputchar"
		size = 47
		refs = "0002 __iob 0028 __flsbuf"
	strings:
		$1 = { FF 0D ?? ?? ?? ?? 78 16 8A 44 24 04 8B 0D ?? ?? ?? ?? 88 01 FF 05 ?? ?? ?? ?? 0F B6 C0 C3 68 ?? ?? ?? ?? FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "__fptostr"
		size = 119
		refs = "0062 _strlen 006b _memmove"
	strings:
		$1 = { 55 8B EC 8B 55 10 8B 4A 0C 53 8B 5D 0C 85 DB 56 8B 75 08 57 8D 7E 01 C6 06 30 8B C7 7E 1F 89 5D 08 33 DB 8A 11 84 D2 74 06 0F BE D2 41 EB 03 6A 30 5A 88 10 40 FF 4D 08 75 E9 8B 55 10 85 DB C6 00 00 7C 12 80 39 35 7C 0D EB 03 C6 00 30 48 80 38 39 74 F7 FE 00 80 3E 31 75 05 FF 42 04 EB 12 57 E8 ?? ?? ?? ?? 40 50 57 56 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "_freopen"
		size = 52
		refs = "000d _fclose 002b __openfile"
	strings:
		$1 = { 56 8B 74 24 10 F6 46 0C 83 74 07 56 E8 ?? ?? ?? ?? 59 56 6A 40 FF 74 24 14 33 C0 FF 74 24 14 89 46 08 89 06 89 46 0C 89 46 04 E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "__wfreopen"
		size = 52
		refs = "000d _fclose 002b __wopenfile"
	strings:
		$1 = { 56 8B 74 24 10 F6 46 0C 83 74 07 56 E8 ?? ?? ?? ?? 59 56 6A 40 FF 74 24 14 33 C0 FF 74 24 14 89 46 08 89 06 89 46 0C 89 46 04 E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "_$$$00001"
		size = 27
		refs = "0017 __rtindfnpop"
	strings:
		$1 = { 0A C9 75 12 D9 FA C3 0A C9 75 0B C3 D9 E4 9B DF E0 9B 9E 75 EB C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "_wcstoxl"
		size = 453
		refs = "0024 _iswctype 006b __wchartodigit 017f _errno"
	strings:
		$1 = { 55 8B EC 51 51 83 65 FC 00 53 8B 5D 08 56 57 33 F6 66 8B 33 8D 7B 02 EB 07 33 F6 66 8B 37 47 47 6A 08 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 EB 66 83 FE 2D 75 06 83 4D 14 02 EB 06 66 83 FE 2B 75 05 66 8B 37 47 47 8B 45 10 85 C0 0F 8C 65 01 00 00 83 F8 01 0F 84 5C 01 00 00 83 F8 24 0F 8F 53 01 00 00 85 C0 6A 10 5B 75 2F 56 E8 ?? ?? ?? ?? 85 C0 59 74 09 C7 45 10 0A 00 00 00 EB 43 66 8B 07 66 3D 78 00 74 0F 66 3D 58 00 74 09 C7 45 10 08 00 00 00 EB 2B 89 5D 10 39 5D 10 75 23 56 E8 ?? ?? ?? ?? 85 C0 59 75 18 66 8B 07 66 3D 78 00 74 06 66 3D 58 00 75 09 47 47 33 F6 66 8B 37 47 47 83 C8 FF 33 D2 F7 75 10 89 55 F8 8B D8 56 E8 ?? ?? ?? ?? 83 F8 FF 59 75 32 66 83 FE 41 72 06 66 83 FE 5A 76 0C 66 83 FE 61 72 4E 66 83 FE 7A 77 48 66 83 FE 61 72 0E 66 83 FE 7A 77 08 0F B7 C6 83 E8 20 EB 03 0F B7 C6 83 C0 C9 3B 45 10 73 29 83 4D 14 08 39 5D FC 72 0D 75 05 3B 45 F8 76 06 83 4D 14 04 EB 0C 8B 4D FC 0F AF 4D 10 03 C8 89 4D FC 66 8B 37 47 47 EB 94 8B 55 14 4F 4F F6 C2 08 75 0F 83 7D 0C 00 74 03 8B 7D 08 83 65 FC 00 EB 4D F6 C2 04 B8 FF FF FF 7F 75 1E F6 C2 01 75 3E 8B CA 83 E1 02 74 09 81 7D FC 00 00 00 80 77 09 85 C9 75 2A 39 45 FC 76 25 F6 C2 01 C7 05 ?? ?? ?? ?? 22 00 00 00 74 06 83 4D FC FF EB 10 8A CA 80 E1 02 F6 D9 1B C9 F7 D9 03 C8 89 4D FC 8B 45 0C 85 C0 74 02 89 38 F6 C2 02 74 03 F7 5D FC 8B 45 FC EB 0B 8B 45 0C 85 C0 74 02 89 18 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "__get_sbh_threshold"
		size = 21
		refs = "0001 ___active_heap 0010 ___sbh_threshold"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 E8 03 F7 D8 1B C0 F7 D0 23 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "___sbh_heap_init"
		size = 72
		refs = "0009 __crtheap 000f __imp__HeapAlloc@12 0016 ___sbh_pHeaderList 0023 ___sbh_pHeaderDefer 002a ___sbh_cntHeaderList 0030 ___sbh_pHeaderScan 0038 ___sbh_threshold 003e ___sbh_sizeHeaderList"
	strings:
		$1 = { 68 40 01 00 00 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 75 01 C3 8B 4C 24 04 83 25 ?? ?? ?? ?? 00 83 25 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 33 C0 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 10 00 00 00 40 C3 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "___sbh_find_block"
		size = 43
		refs = "0001 ___sbh_cntHeaderList 0009 ___sbh_pHeaderList"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8D 0C 80 A1 ?? ?? ?? ?? 8D 0C 88 EB 12 8B 54 24 04 2B 50 0C 81 FA 00 00 10 00 72 09 83 C0 14 3B C1 72 EA 33 C0 C3 }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "___sbh_free_block"
		size = 792
		refs = "021d ___sbh_pHeaderDefer 022b ___sbh_indGroupDefer 0231 __imp__VirtualFree@12 02b0 __crtheap 02b6 __imp__HeapFree@12 02bb ___sbh_cntHeaderList 02c1 ___sbh_pHeaderList 02df _memmove 0301 ___sbh_pHeaderScan"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 4D 08 8B 41 10 56 8B 75 0C 57 8B FE 2B 79 0C 83 C6 FC C1 EF 0F 8B CF 69 C9 04 02 00 00 8D 8C 01 44 01 00 00 89 4D F0 8B 0E 49 F6 C1 01 89 4D FC 0F 85 D7 02 00 00 53 8D 1C 31 8B 13 89 55 F4 8B 56 FC 89 55 F8 8B 55 F4 F6 C2 01 89 5D 0C 75 74 C1 FA 04 4A 83 FA 3F 76 03 6A 3F 5A 8B 4B 04 3B 4B 08 75 42 83 FA 20 BB 00 00 00 80 73 19 8B CA D3 EB 8D 4C 02 04 F7 D3 21 5C B8 44 FE 09 75 23 8B 4D 08 21 19 EB 1C 8D 4A E0 D3 EB 8D 4C 02 04 F7 D3 21 9C B8 C4 00 00 00 FE 09 75 06 8B 4D 08 21 59 04 8B 5D 0C 8B 53 08 8B 5B 04 8B 4D FC 03 4D F4 89 5A 04 8B 55 0C 8B 5A 04 8B 52 08 89 53 08 89 4D FC 8B D1 C1 FA 04 4A 83 FA 3F 76 03 6A 3F 5A 8B 5D F8 83 E3 01 89 5D F4 0F 85 8F 00 00 00 2B 75 F8 8B 5D F8 C1 FB 04 6A 3F 89 75 0C 4B 5E 3B DE 76 02 8B DE 03 4D F8 8B D1 C1 FA 04 4A 3B D6 89 4D FC 76 02 8B D6 3B DA 74 5E 8B 4D 0C 8B 71 04 3B 71 08 75 3B 83 FB 20 BE 00 00 00 80 73 17 8B CB D3 EE F7 D6 21 74 B8 44 FE 4C 03 04 75 21 8B 4D 08 21 31 EB 1A 8D 4B E0 D3 EE F7 D6 21 B4 B8 C4 00 00 00 FE 4C 03 04 75 06 8B 4D 08 21 71 04 8B 4D 0C 8B 71 08 8B 49 04 89 4E 04 8B 4D 0C 8B 71 04 8B 49 08 89 4E 08 8B 75 0C EB 03 8B 5D 08 83 7D F4 00 75 08 3B DA 0F 84 80 00 00 00 8B 4D F0 8D 0C D1 8B 59 04 89 4E 08 89 5E 04 89 71 04 8B 4E 04 89 71 08 8B 4E 04 3B 4E 08 75 60 8A 4C 02 04 88 4D 0F FE C1 83 FA 20 88 4C 02 04 73 25 80 7D 0F 00 75 0E 8B CA BB 00 00 00 80 D3 EB 8B 4D 08 09 19 BB 00 00 00 80 8B CA D3 EB 8D 44 B8 44 09 18 EB 29 80 7D 0F 00 75 10 8D 4A E0 BB 00 00 00 80 D3 EB 8B 4D 08 09 59 04 8D 4A E0 BA 00 00 00 80 D3 EA 8D 84 B8 C4 00 00 00 09 10 8B 45 FC 89 06 89 44 30 FC 8B 45 F0 FF 08 0F 85 F7 00 00 00 A1 ?? ?? ?? ?? 85 C0 0F 84 DC 00 00 00 8B 0D ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 00 40 00 00 C1 E1 0F 03 48 0C BB 00 80 00 00 53 51 FF D6 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? BA 00 00 00 80 D3 EA 09 50 08 A1 ?? ?? ?? ?? 8B 40 10 8B 0D ?? ?? ?? ?? 83 A4 88 C4 00 00 00 00 A1 ?? ?? ?? ?? 8B 40 10 FE 48 43 A1 ?? ?? ?? ?? 8B 48 10 80 79 43 00 75 09 83 60 04 FE A1 ?? ?? ?? ?? 83 78 08 FF 75 69 53 6A 00 FF 70 0C FF D6 A1 ?? ?? ?? ?? FF 70 10 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8D 04 80 C1 E0 02 8B C8 A1 ?? ?? ?? ?? 2B C8 8D 4C 11 EC 51 8D 48 14 51 50 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C FF 0D ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 76 04 83 6D 08 14 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 45 08 A3 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "___sbh_alloc_new_region"
		size = 183
		refs = "0001 ___sbh_cntHeaderList 0007 ___sbh_sizeHeaderList 001c ___sbh_pHeaderList 0023 __crtheap 0029 __imp__HeapReAlloc@16 0062 __imp__HeapAlloc@12 0080 __imp__VirtualAlloc@16 0097 __imp__HeapFree@12"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 57 33 FF 3B C1 75 34 8D 44 89 50 C1 E0 02 50 FF 35 ?? ?? ?? ?? 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B C7 75 04 33 C0 5F C3 83 05 ?? ?? ?? ?? 10 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 56 68 C4 41 00 00 6A 08 FF 35 ?? ?? ?? ?? 8D 04 80 8D 34 81 FF 15 ?? ?? ?? ?? 3B C7 89 46 10 75 04 33 C0 EB 43 6A 04 68 00 20 00 00 68 00 00 10 00 57 FF 15 ?? ?? ?? ?? 3B C7 89 46 0C 75 12 FF 76 10 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? EB D0 83 4E 08 FF 89 3E 89 7E 04 FF 05 ?? ?? ?? ?? 8B 46 10 83 08 FF 8B C6 5E 5F C3 }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "___sbh_alloc_new_group"
		size = 262
		refs = "0054 __imp__VirtualAlloc@16"
	strings:
		$1 = { 55 8B EC 51 51 8B 4D 08 8B 41 08 53 56 8B 71 10 57 33 DB EB 03 D1 E0 43 85 C0 7D F9 8B C3 69 C0 04 02 00 00 8D 84 30 44 01 00 00 6A 3F 89 45 F8 5A 89 40 08 89 40 04 83 C0 08 4A 75 F4 6A 04 8B FB 68 00 10 00 00 C1 E7 0F 03 79 0C 68 00 80 00 00 57 FF 15 ?? ?? ?? ?? 85 C0 75 08 83 C8 FF E9 9D 00 00 00 8D 97 00 70 00 00 3B FA 89 55 FC 77 43 8B CA 2B CF C1 E9 0C 8D 47 10 41 83 48 F8 FF 83 88 EC 0F 00 00 FF 8D 90 FC 0F 00 00 89 10 8D 90 FC EF FF FF C7 40 FC F0 0F 00 00 89 50 04 C7 80 E8 0F 00 00 F0 0F 00 00 05 00 10 00 00 49 75 CB 8B 55 FC 8B 45 F8 05 F8 01 00 00 8D 4F 0C 89 48 04 89 41 08 8D 4A 0C 89 48 08 89 41 04 83 64 9E 44 00 33 FF 47 89 BC 9E C4 00 00 00 8A 46 43 8A C8 FE C1 84 C0 8B 45 08 88 4E 43 75 03 09 78 04 BA 00 00 00 80 8B CB D3 EA F7 D2 21 50 08 8B C3 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_134_6_0 {
	meta:
		name = "___sbh_resize_block"
		size = 735
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 4D 08 8B 41 10 53 56 8B 75 10 57 8B 7D 0C 8B D7 2B 51 0C 83 C6 17 C1 EA 0F 8B CA 69 C9 04 02 00 00 8D 8C 01 44 01 00 00 89 4D F4 8B 4F FC 83 E6 F0 49 3B F1 8D 7C 39 FC 8B 1F 89 4D 10 89 5D FC 0F 8E 55 01 00 00 F6 C3 01 0F 85 45 01 00 00 03 D9 3B F3 0F 8F 3B 01 00 00 8B 4D FC C1 F9 04 49 83 F9 3F 89 4D F8 76 06 6A 3F 59 89 4D F8 8B 5F 04 3B 5F 08 75 43 83 F9 20 BB 00 00 00 80 73 1A D3 EB 8B 4D F8 8D 4C 01 04 F7 D3 21 5C 90 44 FE 09 75 26 8B 4D 08 21 19 EB 1F 83 C1 E0 D3 EB 8B 4D F8 8D 4C 01 04 F7 D3 21 9C 90 C4 00 00 00 FE 09 75 06 8B 4D 08 21 59 04 8B 4F 08 8B 5F 04 89 59 04 8B 4F 04 8B 7F 08 89 79 08 8B 4D 10 2B CE 01 4D FC 83 7D FC 00 0F 8E A5 00 00 00 8B 7D FC 8B 4D 0C C1 FF 04 4F 83 FF 3F 8D 4C 31 FC 76 03 6A 3F 5F 8B 5D F4 8D 1C FB 89 5D 10 8B 5B 04 89 59 04 8B 5D 10 89 59 08 89 4B 04 8B 59 04 89 4B 08 8B 59 04 3B 59 08 75 57 8A 4C 07 04 88 4D 13 FE C1 83 FF 20 88 4C 07 04 73 1C 80 7D 13 00 75 0E 8B CF BB 00 00 00 80 D3 EB 8B 4D 08 09 19 8D 44 90 44 8B CF EB 20 80 7D 13 00 75 10 8D 4F E0 BB 00 00 00 80 D3 EB 8B 4D 08 09 59 04 8D 84 90 C4 00 00 00 8D 4F E0 BA 00 00 00 80 D3 EA 09 10 8B 55 0C 8B 4D FC 8D 44 32 FC 89 08 89 4C 01 FC EB 03 8B 55 0C 8D 46 01 89 42 FC 89 44 32 F8 E9 3C 01 00 00 33 C0 E9 38 01 00 00 0F 8D 2F 01 00 00 8B 5D 0C 29 75 10 8D 4E 01 89 4B FC 8D 5C 33 FC 8B 75 10 C1 FE 04 4E 83 FE 3F 89 5D 0C 89 4B FC 76 03 6A 3F 5E F6 45 FC 01 0F 85 80 00 00 00 8B 75 FC C1 FE 04 4E 83 FE 3F 76 03 6A 3F 5E 8B 4F 04 3B 4F 08 75 42 83 FE 20 BB 00 00 00 80 73 19 8B CE D3 EB 8D 74 06 04 F7 D3 21 5C 90 44 FE 0E 75 23 8B 4D 08 21 19 EB 1C 8D 4E E0 D3 EB 8D 4C 06 04 F7 D3 21 9C 90 C4 00 00 00 FE 09 75 06 8B 4D 08 21 59 04 8B 5D 0C 8B 4F 08 8B 77 04 89 71 04 8B 77 08 8B 4F 04 89 71 08 8B 75 10 03 75 FC 89 75 10 C1 FE 04 4E 83 FE 3F 76 03 6A 3F 5E 8B 4D F4 8D 0C F1 8B 79 04 89 4B 08 89 7B 04 89 59 04 8B 4B 04 89 59 08 8B 4B 04 3B 4B 08 75 57 8A 4C 06 04 88 4D 0F FE C1 83 FE 20 88 4C 06 04 73 1C 80 7D 0F 00 75 0E 8B CE BF 00 00 00 80 D3 EF 8B 4D 08 09 39 8D 44 90 44 8B CE EB 20 80 7D 0F 00 75 10 8D 4E E0 BF 00 00 00 80 D3 EF 8B 4D 08 09 79 04 8D 84 90 C4 00 00 00 8D 4E E0 BA 00 00 00 80 D3 EA 09 10 8B 45 10 89 03 89 44 18 FC 33 C0 40 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_134_7_0 {
	meta:
		name = "___sbh_heapmin"
		size = 209
		refs = "0001 ___sbh_pHeaderDefer 000f ___sbh_indGroupDefer 0026 __imp__VirtualFree@12 007f ___sbh_cntHeaderList 008d __crtheap 0093 __imp__HeapFree@12 009e ___sbh_pHeaderList 00bc _memmove"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 0F 84 C3 00 00 00 8B 0D ?? ?? ?? ?? 68 00 40 00 00 C1 E1 0F 03 48 0C 68 00 80 00 00 51 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? BA 00 00 00 80 D3 EA 09 50 08 A1 ?? ?? ?? ?? 8B 40 10 8B 0D ?? ?? ?? ?? 83 A4 88 C4 00 00 00 00 A1 ?? ?? ?? ?? 8B 40 10 FE 48 43 A1 ?? ?? ?? ?? 8B 48 10 80 79 43 00 75 09 83 60 04 FE A1 ?? ?? ?? ?? 83 78 08 FF 75 4C 83 3D ?? ?? ?? ?? 01 7E 43 FF 70 10 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8D 04 80 C1 E0 02 8B C8 A1 ?? ?? ?? ?? 2B C8 8D 4C 11 EC 51 8D 48 14 51 50 E8 ?? ?? ?? ?? 83 C4 0C FF 0D ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 C3 }
	condition:
		$1
}

rule file_134_8_0 {
	meta:
		name = "___sbh_heap_check"
		size = 793
		refs = "000a ___sbh_cntHeaderList 0017 ___sbh_pHeaderList 001d __imp__IsBadWritePtr@8"
	strings:
		$1 = { 55 8B EC 81 EC 38 01 00 00 A1 ?? ?? ?? ?? 8D 04 80 C1 E0 02 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 05 83 C8 FF C9 C3 53 8B 1D ?? ?? ?? ?? 56 57 33 FF 39 3D ?? ?? ?? ?? 89 5D CC 89 7D E4 7F 09 33 C0 5F 5E 5B C9 C3 33 FF 8B 73 10 68 C4 41 00 00 56 FF 15 ?? ?? ?? ?? 85 C0 0F 85 76 02 00 00 8B 43 0C 89 45 F8 8D 86 44 01 00 00 89 45 DC 8B 43 08 81 C6 C4 00 00 00 89 45 E0 89 7D F0 89 7D EC 89 7D F4 89 75 C8 EB 02 33 FF 89 7D D8 89 7D E8 89 7D FC 6A 40 33 C0 39 45 E0 59 8D BD C8 FE FF FF F3 AB 0F 8C C5 01 00 00 68 00 80 00 00 FF 75 F8 FF 15 ?? ?? ?? ?? 85 C0 0F 85 1E 02 00 00 8B 55 F8 33 DB 81 C2 FC 0F 00 00 83 BA 0C F0 FF FF FF 8D B2 10 F0 FF FF 0F 85 10 02 00 00 83 3A FF 0F 85 07 02 00 00 8B 0E F6 C1 01 8B F9 74 12 49 81 F9 00 04 00 00 0F 8F E5 01 00 00 FF 45 FC EB 17 8B C1 C1 F8 04 48 83 F8 3F 7E 03 6A 3F 58 8D 84 85 C8 FE FF FF FF 00 83 F9 10 0F 8C C8 01 00 00 F6 C1 0F 0F 85 BF 01 00 00 81 F9 F0 0F 00 00 0F 8F B3 01 00 00 8D 04 31 39 78 FC 0F 85 A3 01 00 00 8B F0 3B F2 72 9E 0F 85 97 01 00 00 81 C2 00 10 00 00 43 83 FB 08 0F 8C 6C FF FF FF 8B 45 FC 8B 7D DC 39 07 0F 85 85 01 00 00 33 F6 83 65 FC 00 8D 5F 08 8B 43 FC 3B C7 89 7D D4 89 5D D0 0F 84 B2 00 00 00 8B 4D FC 3B 8C B5 C8 FE FF FF 74 7F 8B 4D F8 3B C1 0F 82 64 01 00 00 81 C1 00 80 00 00 3B C1 0F 83 56 01 00 00 8B C8 81 E1 00 F0 FF FF 83 C1 0C 8D 91 F0 0F 00 00 3B CA 0F 84 31 01 00 00 3B C8 74 0E 8B 19 83 E3 FE 03 CB 3B CA 8B 5D D0 75 EE 3B CA 0F 84 17 01 00 00 8B 08 C1 F9 04 49 83 F9 3F 7E 03 6A 3F 59 3B CE 0F 85 05 01 00 00 8B 4D D4 39 48 08 0F 85 FD 00 00 00 FF 45 FC 89 45 D4 8B 40 04 3B C7 0F 85 75 FF FF FF 83 7D FC 00 74 21 83 FE 20 B8 00 00 00 80 7D 0C 8B CE D3 E8 09 45 D8 09 45 F0 EB 0B 8D 4E E0 D3 E8 09 45 E8 09 45 EC 8B 45 D4 39 78 04 0F 85 C5 00 00 00 8B 4D FC 3B 8C B5 C8 FE FF FF 0F 85 B5 00 00 00 39 03 0F 85 A9 00 00 00 46 83 FE 40 8B FB 0F 8C 06 FF FF FF 8B 75 C8 8B 5D CC 8B 45 D8 3B 46 80 0F 85 93 00 00 00 8B 45 E8 3B 06 0F 85 88 00 00 00 81 45 F8 00 80 00 00 81 45 DC 04 02 00 00 D1 65 E0 FF 45 F4 83 C6 04 83 7D F4 20 89 75 C8 0F 8C DF FD FF FF 8B 45 F0 3B 03 75 61 8B 45 EC 3B 43 04 75 59 83 C3 14 FF 45 E4 8B 45 E4 3B 05 ?? ?? ?? ?? 89 5D CC 0F 8C 76 FD FF FF E9 6A FD FF FF 6A FE 58 E9 64 FD FF FF 6A FC EB F6 6A FA EB F2 6A F8 EB EE 6A F9 EB EA 6A FB EB E6 6A F7 EB E2 6A F5 EB DE 6A F4 EB DA 6A F3 EB D6 6A F6 EB D2 6A F1 EB CE 6A F2 EB CA 6A F0 EB C6 6A EF EB C2 }
	condition:
		$1
}

rule file_134_9_0 {
	meta:
		name = "__set_sbh_threshold"
		size = 91
		refs = "0001 ___active_heap 0016 ___sbh_threshold 0039 ___sbh_heap_init"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 03 75 17 8B 44 24 04 3D F8 03 00 00 77 09 A3 ?? ?? ?? ?? 33 C0 40 C3 33 C0 C3 83 F8 01 56 75 30 8B 74 24 08 85 F6 76 28 81 FE F8 03 00 00 77 20 56 E8 ?? ?? ?? ?? 85 C0 59 74 15 33 C0 89 35 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 03 00 00 00 40 5E C3 33 C0 5E C3 }
	condition:
		$1
}

rule file_134_10_0 {
	meta:
		name = "___sbh_alloc_block"
		size = 764
		refs = "000a ___sbh_cntHeaderList 0010 ___sbh_pHeaderList 004b ___sbh_pHeaderScan 0151 ___sbh_alloc_new_region 0160 ___sbh_alloc_new_group 02d7 ___sbh_pHeaderDefer 02e2 ___sbh_indGroupDefer"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 4D 08 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C1 17 83 E1 F0 53 89 4D F0 C1 F9 04 56 8D 04 80 57 49 83 F9 20 8D 3C 82 89 7D FC 7D 0B 83 CE FF D3 EE 83 4D F8 FF EB 0D 83 C1 E0 83 C8 FF 33 F6 D3 E8 89 45 F8 A1 ?? ?? ?? ?? 8B D8 89 75 F4 3B DF EB 14 8B 4B 04 8B 3B 23 4D F8 23 FE 0B CF 75 0B 83 C3 14 3B 5D FC 89 5D 08 72 E7 3B 5D FC 75 24 8B DA EB 11 8B 4B 04 8B 3B 23 4D F8 23 FE 0B CF 75 0A 83 C3 14 3B D8 89 5D 08 72 E8 3B D8 0F 84 94 00 00 00 89 1D ?? ?? ?? ?? 8B 43 10 8B 10 83 FA FF 89 55 FC 74 14 8B 8C 90 C4 00 00 00 8B 7C 90 44 23 4D F8 23 FE 0B CF 75 36 8B 90 C4 00 00 00 23 55 F8 83 65 FC 00 8D 48 44 8B 31 23 75 F4 0B D6 8B 75 F4 75 17 8B 91 84 00 00 00 23 55 F8 FF 45 FC 83 C1 04 8B 39 23 FE 0B D7 74 E9 8B 55 FC 8B CA 69 C9 04 02 00 00 8D 8C 01 44 01 00 00 89 4D F4 8B 4C 90 44 33 FF 23 CE 75 6D 8B 8C 90 C4 00 00 00 23 4D F8 6A 20 5F EB 5E 83 7B 08 00 75 0B 83 C3 14 89 5D 08 3B 5D FC 72 EF 3B 5D FC 75 26 8B DA EB 09 83 7B 08 00 75 0A 83 C3 14 3B D8 89 5D 08 72 F0 3B D8 75 0E E8 ?? ?? ?? ?? 8B D8 85 DB 89 5D 08 74 18 53 E8 ?? ?? ?? ?? 59 8B 4B 10 89 01 8B 43 10 83 38 FF 0F 85 24 FF FF FF 33 C0 E9 7A 01 00 00 D1 E1 47 85 C9 7D F9 8B 4D F4 8B 54 F9 04 8B 0A 2B 4D F0 8B F1 C1 FE 04 4E 83 FE 3F 89 4D F8 7E 03 6A 3F 5E 3B F7 0F 84 01 01 00 00 8B 4A 04 3B 4A 08 75 5C 83 FF 20 BB 00 00 00 80 7D 26 8B CF D3 EB 8B 4D FC 8D 7C 38 04 F7 D3 89 5D EC 23 5C 88 44 89 5C 88 44 FE 0F 75 33 8B 4D EC 8B 5D 08 21 0B EB 2C 8D 4F E0 D3 EB 8B 4D FC 8D 8C 88 C4 00 00 00 8D 7C 38 04 F7 D3 21 19 FE 0F 89 5D EC 75 0B 8B 5D 08 8B 4D EC 21 4B 04 EB 03 8B 5D 08 83 7D F8 00 8B 4A 08 8B 7A 04 89 79 04 8B 4A 04 8B 7A 08 89 79 08 0F 84 8D 00 00 00 8B 4D F4 8D 0C F1 8B 79 04 89 4A 08 89 7A 04 89 51 04 8B 4A 04 89 51 08 8B 4A 04 3B 4A 08 75 5E 8A 4C 06 04 88 4D 0B FE C1 83 FE 20 88 4C 06 04 7D 23 80 7D 0B 00 75 0B BF 00 00 00 80 8B CE D3 EF 09 3B 8B CE BF 00 00 00 80 D3 EF 8B 4D FC 09 7C 88 44 EB 29 80 7D 0B 00 75 0D 8D 4E E0 BF 00 00 00 80 D3 EF 09 7B 04 8B 4D FC 8D BC 88 C4 00 00 00 8D 4E E0 BE 00 00 00 80 D3 EE 09 37 8B 4D F8 85 C9 74 0B 89 0A 89 4C 11 FC EB 03 8B 4D F8 8B 75 F0 03 D1 8D 4E 01 89 0A 89 4C 32 FC 8B 75 F4 8B 0E 85 C9 8D 79 01 89 3E 75 1A 3B 1D ?? ?? ?? ?? 75 12 8B 4D FC 3B 0D ?? ?? ?? ?? 75 07 83 25 ?? ?? ?? ?? 00 8B 4D FC 89 08 8D 42 04 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__fullpath"
		size = 164
		refs = "0022 _malloc 002f _errno 004b __imp__GetFullPathNameA@16 005c _free 0081 __imp__GetLastError@0 0087 __dosmaperr 009a __getcwd"
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 85 DB 57 0F 84 83 00 00 00 80 3B 00 74 7E 8B 7D 08 85 FF 75 24 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F8 85 FF 59 75 0C C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 32 C7 45 10 04 01 00 00 8D 45 0C 50 57 FF 75 10 53 FF 15 ?? ?? ?? ?? 3B 45 10 72 1B 83 7D 08 00 75 07 57 E8 ?? ?? ?? ?? 59 C7 05 ?? ?? ?? ?? 22 00 00 00 33 C0 EB 31 85 C0 75 1C 39 45 08 75 07 57 E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 EB 10 8B C7 EB 0D FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5F 5B 5D C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__ismbclower"
		size = 126
		refs = "0023 ___ismbcodepage 0039 ___mblcid 0042 ___mbcodepage 0050 ___crtGetStringTypeA 006f __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5E 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 75 04 33 C0 C9 C3 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 D6 66 83 7D FE 00 75 CF F6 45 FC 02 74 C9 33 C0 40 C9 C3 8A 81 ?? ?? ?? ?? 24 20 2C 20 F6 D8 1B C0 40 C9 C3 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "_longjmp"
		size = 121
		refs = "000c __except_list 0014 __global_unwind2 0025 __rt_probe_read4@4 0049 __local_unwind2 0056 __NLG_Notify"
	strings:
		$1 = { 8B 5C 24 04 8B 2B 8B 73 18 64 3B 35 ?? ?? ?? ?? 74 09 56 E8 ?? ?? ?? ?? 83 C4 04 83 FE 00 74 30 8D 43 20 50 E8 ?? ?? ?? ?? 0B C0 74 16 8B 43 20 3D 30 32 43 56 75 0C 8B 43 24 0B C0 74 12 53 FF D0 EB 0D 8B 43 1C 50 56 E8 ?? ?? ?? ?? 83 C4 08 6A 00 8B 43 14 E8 ?? ?? ?? ?? 8B D3 8B 5A 04 8B 7A 08 8B 72 0C 8B 44 24 08 83 F8 01 83 D0 00 8B 62 10 83 C4 04 FF 62 14 C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "_sprintf"
		size = 88
		refs = "002b __output 004c __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 8B 75 08 57 8D 45 10 50 FF 75 0C 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 E8 ?? ?? ?? ?? 83 C4 0C 85 F6 8B F8 74 1A FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E C9 C3 }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "__scprintf"
		size = 49
		refs = "0028 __output"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 E8 00 83 65 E0 00 8D 45 0C 50 FF 75 08 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_176_1_0 {
	meta:
		name = "__scwprintf"
		size = 49
		refs = "0028 __woutput"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 E8 00 83 65 E0 00 8D 45 0C 50 FF 75 08 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__strset"
		size = 33
	strings:
		$1 = { 55 8B EC 57 8B 7D 08 8B D7 33 C0 83 C9 FF F2 AE 83 C1 02 F7 D9 8A 45 0C 8B FA F3 AA 8B C2 5F C9 C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__allshl"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 8B D0 33 C0 80 E1 1F D3 E2 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "_fix_grouping"
		size = 51
	strings:
		$1 = { 32 D2 38 11 74 17 53 56 8A 01 3C 30 7C 10 3C 39 7F 0C 2C 30 88 01 41 38 11 75 ED 5E 5B C3 3C 3B 75 F4 8B C1 8D 70 01 8A 1E 88 18 8B C6 38 10 75 F3 EB E4 }
	condition:
		$1
}

rule file_148_1_0 {
	meta:
		name = "___free_lconv_num"
		size = 64
		refs = "000d ___lconv_c 0015 _free"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 35 8B 06 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 04 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 76 08 3B 35 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_148_2_0 {
	meta:
		name = "___init_numeric"
		size = 326
		refs = "0006 ___lc_handle 0018 ___lconv 001d ___free_lconv_num 0023 ___lconv_intl 0028 _free 002d ___lconv_c 0041 _calloc 0071 ___lc_id 007c ___getlocaleinfo 012f ___decimal_point 0135 ___decimal_point_length"
	strings:
		$1 = { 53 55 33 DB 39 1D ?? ?? ?? ?? 56 57 75 2E 39 1D ?? ?? ?? ?? 75 26 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? BD ?? ?? ?? ?? 89 1D ?? ?? ?? ?? E9 E7 00 00 00 6A 30 6A 01 E8 ?? ?? ?? ?? 8B E8 3B EB 59 59 75 08 33 C0 40 E9 EC 00 00 00 8B 35 ?? ?? ?? ?? 6A 0C 59 8B FD F3 A5 39 1D ?? ?? ?? ?? 0F 84 81 00 00 00 0F B7 35 ?? ?? ?? ?? 55 6A 0E 56 6A 01 E8 ?? ?? ?? ?? 8B D8 8D 45 04 50 6A 0F 56 6A 01 E8 ?? ?? ?? ?? 8D 7D 08 57 6A 10 56 6A 01 0B D8 E8 ?? ?? ?? ?? 83 C4 30 0B C3 74 14 55 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 83 C8 FF E9 84 00 00 00 8B 07 EB 12 8A 08 80 F9 30 7C 12 80 F9 39 7F 0D 80 E9 30 88 08 40 80 38 00 75 E9 EB 2F 80 F9 3B 75 F3 8B C8 8D 71 01 8A 16 88 11 8B CE 80 39 00 75 F2 EB E2 A1 ?? ?? ?? ?? 89 45 00 A1 ?? ?? ?? ?? 89 45 04 A1 ?? ?? ?? ?? 89 45 08 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 8B 45 00 8A 00 A2 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 59 59 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "?set_new_handler@@YAP6AXXZP6AXXZ@Z"
		size = 38
		refs = "000a ??_C@_0M@OELBDKFJ@setnewh?4cpp?$AA@ 000f ??_C@_0L@OOOPIKCK@new_p?5?$DN?$DN?50?$AA@ 0014 __assert 001e ?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
	strings:
		$1 = { 83 7C 24 04 00 74 14 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 59 33 C0 C3 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__snwprintf"
		size = 112
		refs = "002b __woutput 004b __flsbuf"
		altNames = "?swprintf@@YAHPA_WIPB_WZZ"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 89 45 E8 89 45 E0 8B 45 0C 03 C0 89 45 E4 56 8D 45 14 50 FF 75 10 8D 45 E0 50 C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C FF 4D E4 8B F0 78 0B 8B 45 E0 C6 00 00 FF 45 E0 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "_fgetwc"
		size = 240
		refs = "0023 ___pioinfo 0030 ___badioinfo 0052 __filbuf 0067 __pctype 009a _ungetc 00b5 _mbtowc 00c3 _errno 00e7 __filwbuf"
	strings:
		$1 = { 55 8B EC 51 56 8B 75 08 F6 46 0C 40 57 0F 85 C0 00 00 00 8B 46 10 83 F8 FF 74 14 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F 8D 04 C1 EB 05 B8 ?? ?? ?? ?? F6 40 04 80 0F 84 95 00 00 00 33 FF 47 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 83 F8 FF 75 09 66 0D FF FF E9 87 00 00 00 8B 0D ?? ?? ?? ?? 88 45 FC 0F B6 C0 F6 44 41 01 80 74 33 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 83 F8 FF 75 12 0F BE 45 FC 56 50 E8 ?? ?? ?? ?? 59 66 0D FF FF EB 46 6A 02 88 45 FD 5F 57 8D 45 FC 50 8D 45 0A 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 0C C7 05 ?? ?? ?? ?? 2A 00 00 00 EB 8F 66 8B 45 0A EB 19 83 46 04 FE 78 0C 8B 0E 66 8B 01 83 C1 02 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 5F 5E C9 C3 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "__flsbuf"
		size = 278
		refs = "0055 __iob 0065 __isatty 0070 __getbuf 0099 __write 00af ___pioinfo 00be ___badioinfo 00ce __lseek"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 0C 8B 46 0C A8 82 8B 5E 10 0F 84 F3 00 00 00 A8 40 0F 85 EB 00 00 00 A8 01 74 17 83 66 04 00 A8 10 0F 84 DB 00 00 00 8B 4E 08 83 E0 FE 89 0E 89 46 0C 8B 46 0C 83 66 04 00 83 65 0C 00 83 E0 EF 83 C8 02 66 A9 0C 01 89 46 0C 75 22 81 FE ?? ?? ?? ?? 74 08 81 FE ?? ?? ?? ?? 75 0B 53 E8 ?? ?? ?? ?? 85 C0 59 75 07 56 E8 ?? ?? ?? ?? 59 66 F7 46 0C 08 01 57 74 61 8B 46 08 8B 3E 8D 48 01 89 0E 8B 4E 18 2B F8 49 85 FF 89 4E 04 7E 0D 57 50 53 E8 ?? ?? ?? ?? 89 45 0C EB 30 83 FB FF 74 16 8B C3 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B CB 83 E1 1F 8D 04 C8 EB 05 B8 ?? ?? ?? ?? F6 40 04 20 74 0D 6A 02 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 8B 46 08 8A 4D 08 88 08 EB 14 33 FF 47 57 8D 45 08 50 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 0C 39 7D 0C 5F 74 06 83 4E 0C 20 EB 10 8B 45 08 25 FF 00 00 00 EB 09 83 C8 20 89 46 0C 83 C8 FF 5E 5B 5D C3 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "___loctotime64_t"
		size = 374
		refs = "002b __days 006e ___tzset 00b1 __allmul 0108 __timezone 0147 __daylight 0153 __isindst 015d __dstbias"
	strings:
		$1 = { 55 8B EC 83 EC 28 56 8B 75 08 81 EE 6C 07 00 00 83 FE 46 0F 8C 55 01 00 00 81 FE 4B 04 00 00 0F 8F 49 01 00 00 8B 45 0C 8B 0C 85 ?? ?? ?? ?? 53 57 8B C6 6A 04 99 5F F7 FF 03 4D 10 BF 90 01 00 00 89 4D 08 85 D2 75 0C 8B C6 6A 64 99 5B F7 FB 85 D2 75 0F 8D 86 6C 07 00 00 99 8B DF F7 FB 85 D2 75 0A 83 7D 0C 02 7E 04 41 89 4D 08 E8 ?? ?? ?? ?? 8D 86 2B 01 00 00 99 F7 FF 6A 64 5B 8D 4E FF 6A 04 8B F8 8B C1 99 F7 FB 2B F8 8B C1 99 59 F7 F9 6A 00 68 6D 01 00 00 8D 44 07 EF 99 8B D8 8B C2 89 45 FC 8B C6 99 83 E8 46 83 DA 00 52 50 E8 ?? ?? ?? ?? 03 D8 8B 45 FC 13 C2 89 45 FC 8B 45 08 99 03 D8 8B 45 FC 13 C2 33 FF 57 6A 18 50 53 E8 ?? ?? ?? ?? 8B C8 8B 45 14 8B DA 99 57 03 C8 6A 3C 13 DA 53 51 E8 ?? ?? ?? ?? 8B C8 8B 45 18 8B DA 99 57 03 C8 6A 3C 13 DA 53 51 E8 ?? ?? ?? ?? 8B 4D 1C 8B F8 A1 ?? ?? ?? ?? 8B DA 99 03 F8 13 DA 8B C1 99 03 F8 8B 45 08 13 DA 89 45 F4 8B 45 0C 48 83 7D 20 01 89 45 E8 8B 45 14 89 45 E0 8B 45 18 89 75 EC 89 45 DC 89 4D D8 74 1D 83 7D 20 FF 75 21 83 3D ?? ?? ?? ?? 00 74 18 8D 45 D8 50 E8 ?? ?? ?? ?? 85 C0 59 74 0A A1 ?? ?? ?? ?? 99 03 F8 13 DA 8B C7 5F 8B D3 5B EB 05 83 CA FF 8B C2 5E C9 C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "__putw"
		size = 63
		refs = "0023 __flsbuf"
	strings:
		$1 = { 53 56 8B 74 24 10 57 6A 04 8D 7C 24 14 5B FF 4E 04 78 0A 8B 06 8A 0F 88 08 FF 06 EB 0C 0F BE 07 56 50 E8 ?? ?? ?? ?? 59 59 47 4B 75 E1 F6 46 0C 20 5F 5E 5B 74 04 83 C8 FF C3 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "__ismbslead"
		size = 61
		refs = "0002 ___ismbcodepage 001a __mbctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 2D 8B 44 24 04 EB 21 8A 08 84 C9 74 21 0F B6 C9 F6 81 ?? ?? ?? ?? 04 74 0E 8B C8 40 3B 4C 24 08 74 0F 80 38 00 74 07 40 3B 44 24 08 76 D9 33 C0 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "__wopenfile"
		size = 367
		refs = "0014 __commode 013f __wsopen 0156 __cflush"
	strings:
		$1 = { 55 8B EC 51 51 8B 55 0C 0F B7 02 53 33 DB 83 F8 61 56 8B 35 ?? ?? ?? ?? 89 5D F8 89 5D FC 74 1C 83 F8 72 74 10 83 F8 77 0F 85 1F 01 00 00 B9 01 03 00 00 EB 0C 33 C9 83 CE 01 EB 08 B9 09 01 00 00 83 CE 02 57 33 FF 47 E9 D7 00 00 00 3B FB 0F 84 DD 00 00 00 0F B7 C0 83 F8 54 7F 71 74 62 83 E8 2B 74 47 83 E8 19 74 38 83 E8 0E 74 1F 48 0F 85 91 00 00 00 39 5D FC 0F 85 88 00 00 00 C7 45 FC 01 00 00 00 83 C9 20 E9 97 00 00 00 39 5D FC 75 74 C7 45 FC 01 00 00 00 83 C9 10 E9 83 00 00 00 F6 C1 40 75 60 83 C9 40 EB 79 F6 C1 02 75 56 83 E1 FE 83 E6 FC 83 C9 02 81 CE 80 00 00 00 EB 63 B8 00 10 00 00 85 C8 75 3C 0B C8 EB 56 83 E8 62 74 46 48 74 2B 83 E8 0B 74 12 83 E8 06 75 26 F6 C5 C0 75 21 81 C9 00 40 00 00 EB 37 39 5D F8 75 14 C7 45 F8 01 00 00 00 81 E6 FF BF FF FF EB 23 39 5D F8 74 04 33 FF EB 1A C7 45 F8 01 00 00 00 81 CE 00 40 00 00 EB 0B F6 C5 C0 75 E8 81 C9 00 80 00 00 42 42 66 8B 02 66 3B C3 0F 85 1B FF FF FF 68 A4 01 00 00 FF 75 10 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B C8 3B CB 5F 7D 04 33 C0 EB 1A 8B 45 14 FF 05 ?? ?? ?? ?? 89 70 0C 89 58 04 89 18 89 58 08 89 58 1C 89 48 10 5E 5B C9 C3 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "__execl"
		size = 20
		refs = "000c __execve"
	strings:
		$1 = { 6A 00 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_679_0_0 {
	meta:
		name = "__wexecl"
		size = 20
		refs = "000c __wexecve"
	strings:
		$1 = { 6A 00 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "_$$$00001"
		size = 16
	strings:
		$1 = { 8D 42 FF 5B C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_161_1_0 {
	meta:
		name = "_strchr"
		size = 190
	strings:
		$1 = { 33 C0 8A 44 24 08 53 8B D8 C1 E0 08 8B 54 24 08 F7 C2 03 00 00 00 74 15 8A 0A 83 C2 01 38 D9 74 CF 84 C9 74 51 F7 C2 03 00 00 00 75 EB 0B D8 57 8B C3 C1 E3 10 56 0B D8 8B 0A BF FF FE FE 7E 8B C1 8B F7 33 CB 03 F0 03 F9 83 F1 FF 83 F0 FF 33 CF 33 C6 83 C2 04 81 E1 00 01 01 81 75 1C 25 00 01 01 81 74 D3 25 00 01 01 01 75 08 81 E6 00 00 00 80 75 C4 5E 5F 5B 33 C0 C3 8B 42 FC 38 D8 74 36 84 C0 74 EF 38 DC 74 27 84 E4 74 E7 C1 E8 10 38 D8 74 15 84 C0 74 DC 38 DC 74 06 84 E4 74 D4 EB 96 5E 5F 8D 42 FF 5B C3 8D 42 FE 5E 5F 5B C3 8D 42 FD 5E 5F 5B C3 8D 42 FC 5E 5F 5B C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__isatty"
		size = 39
		refs = "0006 __nhandle 0017 ___pioinfo"
	strings:
		$1 = { 8B 44 24 04 3B 05 ?? ?? ?? ?? 72 03 33 C0 C3 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F 0F BE 44 C1 04 83 E0 40 C3 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__copysign"
		size = 33
	strings:
		$1 = { 55 8B EC 51 51 8B 45 08 89 45 F8 8B 45 14 33 45 0C 25 FF FF FF 7F 33 45 14 89 45 FC DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "__chgsign"
		size = 38
	strings:
		$1 = { 55 8B EC 51 51 8B 45 08 89 45 F8 8B 45 0C 8B C8 F7 D1 33 C8 81 E1 FF FF FF 7F F7 D0 33 C8 89 4D FC DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_164_2_0 {
	meta:
		name = "__scalb"
		size = 22
		refs = "000e _ldexp"
	strings:
		$1 = { FF 74 24 0C DD 44 24 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_164_3_0 {
	meta:
		name = "__logb"
		size = 235
		refs = "0012 __ctrlfp 0030 __sptype 0050 __handle_qnan1 006d __real@3ff0000000000000 0086 __real@0000000000000000 0098 __d_inf 00b1 __except1 00c7 __decomp"
	strings:
		$1 = { 55 8B EC 51 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 0E 66 25 F0 7F 66 3D F0 7F 59 59 75 5D DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 7E 2D 83 F8 02 7E 1D 83 F8 03 75 23 DD 45 08 57 51 51 DD 1C 24 6A 25 E8 ?? ?? ?? ?? 83 C4 10 E9 8B 00 00 00 56 57 E8 ?? ?? ?? ?? 59 59 EB 7D DD 45 08 57 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 25 6A 08 EB 2C DD 05 ?? ?? ?? ?? DD 45 08 DA E9 DF E0 F6 C4 44 7A 24 DD 05 ?? ?? ?? ?? 57 83 EC 10 D9 E0 DD 5C 24 08 DD 45 08 DD 1C 24 6A 25 6A 04 E8 ?? ?? ?? ?? 83 C4 1C EB 2D DD 45 08 8D 45 FC 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 FC DD D8 48 89 45 0C DB 45 0C 56 57 DD 5D 08 E8 ?? ?? ?? ?? 83 C4 14 DD 45 08 5F 5E C9 C3 }
	condition:
		$1
}

rule file_164_4_0 {
	meta:
		name = "__nextafter"
		size = 675
		refs = "0015 __ctrlfp 00d2 __real@0000000000000000 01b2 __decomp 01ce __set_exp 0268 __except2 0297 __handle_qnan2"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B 7D 0E 8B 55 08 59 89 45 FC 59 B9 F0 7F 00 00 8B C7 66 23 C1 66 3B C1 74 0B 8B 45 16 66 23 C1 66 3B C1 75 6C B8 F8 7F 00 00 23 F8 66 3B F9 BB FF FF 07 00 75 09 85 5D 0C 75 19 85 D2 75 15 8B 75 16 23 F0 66 3B F1 75 31 85 5D 14 75 06 83 7D 10 00 74 26 FF 75 FC DD 45 08 DC 45 10 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 08 E9 D4 01 00 00 66 3B F8 0F 84 E5 01 00 00 66 3B F0 0F 84 DC 01 00 00 BE FF FF 00 00 DD 45 08 D9 C0 DD 45 10 DA E9 DF E0 F6 C4 44 7A 15 56 DD D8 FF 75 FC E8 ?? ?? ?? ?? DD 45 08 59 59 E9 CE 01 00 00 DD 05 ?? ?? ?? ?? D9 C0 D9 C2 DA E9 DF E0 F6 C4 44 7A 20 DD 45 10 C7 45 E4 01 00 00 00 D8 DA DF E0 F6 C4 41 75 06 83 65 E8 00 EB 07 C7 45 E8 00 00 00 80 D9 C1 D8 D9 DF E0 F6 C4 41 75 0C DD 45 10 D8 DA DF E0 F6 C4 05 7B 17 D9 C1 D8 D9 DF E0 F6 C4 05 7A 23 DD 45 10 D8 DA DF E0 F6 C4 41 75 17 85 D2 DD D8 8D 42 FF DD D8 89 45 E4 8B 45 0C 89 45 E8 75 4B 48 EB 41 D9 C1 D8 D9 DF E0 F6 C4 41 75 0C DD 45 10 D8 DA DF E0 F6 C4 41 74 19 D9 C1 DE D9 DF E0 F6 C4 05 7A 24 DD 45 10 DE D9 DF E0 F6 C4 05 7A 1A EB 04 DD D8 DD D8 8B 45 0C 42 89 55 E4 89 45 E8 75 08 40 89 45 E8 EB 02 DD D8 66 85 4D EA 75 62 F7 45 E8 FF FF 0F 00 75 06 83 7D E4 00 74 53 DD 45 E4 8D 45 F8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 F8 DD 5D F0 DD 45 F0 83 C4 0C 05 00 06 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E4 FF 75 FC DD 45 E4 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 12 EB 6F 81 7D E8 00 00 F0 7F 75 06 83 7D E4 00 74 0F 81 7D E8 00 00 F0 FF 75 61 83 7D E4 00 75 5B DD 45 E4 8D 45 F8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 F8 DD 5D F0 DD 45 F0 83 C4 0C 05 00 FA FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E4 FF 75 FC DD 45 E4 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 11 E8 ?? ?? ?? ?? 83 C4 24 EB 2D 56 FF 75 FC E8 ?? ?? ?? ?? DD 45 E4 59 59 EB 1D FF 75 FC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_164_5_0 {
	meta:
		name = "__finite"
		size = 21
	strings:
		$1 = { 66 8B 44 24 0A 66 25 F0 7F 33 C9 66 3D F0 7F 0F 95 C1 8B C1 C3 }
	condition:
		$1
}

rule file_164_6_0 {
	meta:
		name = "__isnan"
		size = 46
	strings:
		$1 = { 8B 44 24 0A B9 F8 7F 00 00 23 C1 66 3D F0 7F 75 11 F7 44 24 08 FF FF 07 00 75 0C 83 7C 24 04 00 75 05 66 3B C1 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_164_7_0 {
	meta:
		name = "__fpclass"
		size = 156
		refs = "001d __sptype 006e __real@0000000000000000"
	strings:
		$1 = { 55 8B EC 8B 45 0E B9 F0 7F 00 00 8B D0 23 D1 66 3B D1 75 2D DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 48 59 59 74 14 48 74 0D 48 74 05 33 C0 40 5D C3 6A 02 58 5D C3 6A 04 EB F9 B8 00 02 00 00 5D C3 25 00 80 00 00 66 85 D2 8B C8 75 1F F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 10 8B C1 F7 D8 1B C0 83 E0 90 05 80 00 00 00 5D C3 DD 05 ?? ?? ?? ?? DD 45 08 DA E9 DF E0 F6 C4 44 8B C1 7A 0C F7 D8 1B C0 83 E0 E0 83 C0 40 5D C3 F7 D8 1B C0 25 08 FF FF FF 05 00 01 00 00 5D C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__Getdays"
		size = 127
		refs = "0006 ___lc_time_curr 0013 _strlen 0032 _malloc 004a _strcpy"
	strings:
		$1 = { 53 55 56 57 8B 3D ?? ?? ?? ?? 33 F6 33 DB FF 74 9F 1C E8 ?? ?? ?? ?? FF 34 9F 8B E8 E8 ?? ?? ?? ?? 03 C6 43 83 FB 07 59 59 8D 74 28 02 72 DF 46 56 E8 ?? ?? ?? ?? 8B E8 85 ED 59 74 3B 8B F5 33 DB C6 06 3A FF 34 9F 46 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 03 F0 C6 06 3A FF 74 9F 1C 46 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 03 F0 43 83 FB 07 72 CC C6 06 00 5F 5E 8B C5 5D 5B C3 }
	condition:
		$1
}

rule file_165_1_0 {
	meta:
		name = "__Getmonths"
		size = 149
		refs = "000e ___lc_time_curr 0020 _strlen 0044 _malloc 0061 _strcpy"
	strings:
		$1 = { 55 8B EC 51 51 83 65 FC 00 53 56 57 8B 3D ?? ?? ?? ?? 8D 77 38 C7 45 F8 0C 00 00 00 FF 76 30 E8 ?? ?? ?? ?? FF 36 8B D8 E8 ?? ?? ?? ?? 03 45 FC 59 8D 44 18 02 83 C6 04 FF 4D F8 59 89 45 FC 75 DB 40 50 E8 ?? ?? ?? ?? 8B F0 85 F6 59 89 75 F8 74 3B 6A 0C 83 C7 68 5B C6 06 3A FF 77 D0 46 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 03 F0 C6 06 3A FF 37 46 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 03 F0 83 C7 04 4B 75 CE C6 06 00 8B 45 F8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_165_2_0 {
	meta:
		name = "__Gettnames"
		size = 563
		refs = "000a ___lc_time_curr 001f _strlen 00ca _malloc 00ee _memcpy 0113 _strcpy"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 7D FC 8B 5D FC C1 E3 02 FF 74 33 1C E8 ?? ?? ?? ?? FF 34 33 89 45 F0 E8 ?? ?? ?? ?? 03 C7 FF 45 FC 83 7D FC 07 59 59 8B 4D F0 8D 7C 08 02 72 D2 8D 46 38 89 45 F4 C7 45 F8 0C 00 00 00 8B 5D F4 FF 73 30 E8 ?? ?? ?? ?? FF 33 89 45 F0 E8 ?? ?? ?? ?? 83 45 F4 04 59 59 8B 4D F0 03 C7 FF 4D F8 8D 7C 08 02 75 D7 FF B6 98 00 00 00 E8 ?? ?? ?? ?? FF B6 9C 00 00 00 8B D8 E8 ?? ?? ?? ?? FF B6 A0 00 00 00 03 C7 8D 7C 18 02 E8 ?? ?? ?? ?? FF B6 A4 00 00 00 8D 7C 07 01 E8 ?? ?? ?? ?? FF B6 A8 00 00 00 8D 7C 07 01 E8 ?? ?? ?? ?? 8D 44 07 01 05 B4 00 00 00 50 E8 ?? ?? ?? ?? 8B D8 83 C4 18 85 DB 0F 84 51 01 00 00 68 B4 00 00 00 FF 35 ?? ?? ?? ?? 8D BB B4 00 00 00 53 E8 ?? ?? ?? ?? 83 65 FC 00 8D 46 1C 89 5D F4 83 C4 0C 29 75 F4 89 45 F8 8B 45 FC 89 3C 83 8B 45 F8 FF 70 E4 57 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 4D F4 8D 7C 07 01 8B 45 F8 89 3C 01 FF 30 57 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 45 F8 04 83 C4 18 FF 45 FC 83 7D FC 07 8D 7C 07 01 72 B9 8D 43 68 89 45 FC 8D 46 38 89 45 F8 C7 45 F0 0C 00 00 00 EB 03 8B 45 F8 8B 4D F4 89 3C 08 FF 30 57 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 7C 07 01 8B 45 FC 89 38 8B 45 F8 FF 70 30 57 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 45 F8 04 83 45 FC 04 83 C4 18 FF 4D F0 8D 7C 07 01 75 BA 89 BB 98 00 00 00 FF B6 98 00 00 00 57 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 7C 07 01 89 BB 9C 00 00 00 FF B6 9C 00 00 00 57 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 7C 07 01 89 BB A0 00 00 00 FF B6 A0 00 00 00 57 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 7C 07 01 89 BB A4 00 00 00 FF B6 A4 00 00 00 57 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8D 44 07 01 89 83 A8 00 00 00 FF B6 A8 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 38 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_165_3_0 {
	meta:
		name = "__store_str"
		size = 32
	strings:
		$1 = { 83 38 00 56 8B F2 74 16 57 8A 16 84 D2 74 0E 8B 39 88 17 FF 01 46 FF 08 83 38 00 75 EC 5F 5E C3 }
	condition:
		$1
}

rule file_165_4_0 {
	meta:
		name = "__store_number"
		size = 54
	strings:
		$1 = { 83 3E 01 8B 0F 53 76 19 6A 0A 99 5B F7 FB 80 C2 30 88 11 41 FF 0E 85 C0 8B 16 7E 05 83 FA 01 77 E7 8B 07 89 0F 49 8A 18 8A 11 88 19 49 88 10 40 3B C1 72 F2 5B C3 }
	condition:
		$1
}

rule file_165_5_0 {
	meta:
		name = "__store_num"
		size = 121
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 33 D2 39 55 08 89 55 FC 74 35 83 39 01 8B 37 76 19 6A 0A 99 5B F7 FB 80 C2 30 88 16 46 FF 09 85 C0 8B 11 7E 05 83 FA 01 77 E7 8B 07 89 37 4E 8A 10 8A 0E 88 16 4E 88 08 40 3B C6 72 F2 EB 2E 3B 31 73 28 4E 8D 56 01 85 D2 74 17 6A 0A 99 5B F7 FB 8B 1F 80 C2 30 FF 45 FC 88 14 1E 4E 83 FE FF 75 E9 8B 45 FC 01 07 29 01 EB 02 89 11 5E 5B C9 C3 }
	condition:
		$1
}

rule file_165_6_0 {
	meta:
		name = "__expandtime"
		size = 608
		refs = "00cb __store_num 00de __store_winword 01ec ___tzset 01fb __tzname 0255 __store_str"
	strings:
		$1 = { 55 8B EC 0F BE C0 83 F8 5A 56 8B 75 08 57 8B F9 0F 8F 1D 01 00 00 0F 84 CF 01 00 00 83 F8 4D 7F 75 74 69 83 E8 25 74 56 83 E8 1C 74 42 48 74 30 83 E8 06 74 21 48 0F 85 1D 02 00 00 8B 46 08 99 6A 0C 59 F7 F9 8B C2 85 C0 0F 85 7F 01 00 00 51 58 E9 78 01 00 00 FF 75 10 8B 46 08 6A 02 EB 67 8B 56 10 8B 75 0C 8B 54 96 68 E9 E1 01 00 00 8B 56 18 8B 75 0C 8B 54 96 1C E9 D2 01 00 00 8B 07 C6 00 25 FF 07 FF 0B E9 CD 01 00 00 FF 75 10 8B 46 04 6A 02 EB 31 83 E8 53 0F 84 8B 00 00 00 48 48 74 62 48 48 74 4D 48 74 2B 48 0F 85 A8 01 00 00 8B 46 14 99 6A 64 59 F7 F9 FF 75 10 6A 04 83 C0 13 6B C0 64 03 C2 5A 8B CB E8 ?? ?? ?? ?? 59 E9 84 01 00 00 FF 75 0C 53 57 56 6A 02 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 6C 01 00 00 33 C0 E9 68 01 00 00 8B 46 18 85 C0 75 05 6A 06 59 EB 08 8D 48 FF EB 03 8B 4E 18 39 4E 1C 7D 07 33 C0 E9 BA 00 00 00 8B 46 1C 6A 07 99 5E F7 FE 3B D1 0F 8C A9 00 00 00 E9 A3 00 00 00 FF 75 10 8B 06 6A 02 EB 94 83 F8 6D 0F 8F 9C 00 00 00 0F 84 88 00 00 00 83 E8 61 74 75 48 74 63 48 74 27 48 74 17 83 E8 06 0F 85 00 01 00 00 FF 75 10 8B 46 1C 40 6A 03 E9 60 FF FF FF FF 75 10 8B 46 0C 6A 02 E9 53 FF FF FF 83 7D 10 00 FF 75 0C 53 57 56 74 29 6A 01 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 5B FF FF FF 83 3B 00 0F 84 52 FF FF FF 8B 07 C6 00 20 FF 07 FF 0B E9 2C FF FF FF 6A 00 EB D5 8B 56 10 8B 75 0C 8B 54 96 38 E9 94 00 00 00 8B 56 18 8B 75 0C 8B 14 96 E9 86 00 00 00 8B 46 10 40 FF 75 10 6A 02 E9 EF FE FF FF 83 E8 70 74 5C 83 E8 07 74 49 48 74 2C 48 74 19 48 75 6E E8 ?? ?? ?? ?? 33 D2 39 56 20 0F 95 C2 8B 14 95 ?? ?? ?? ?? EB 4F FF 75 10 8B 46 14 99 6A 64 59 F7 F9 8B C2 EB C0 83 7D 10 00 FF 75 0C 53 57 56 74 07 6A 01 E9 B9 FE FF FF 6A 00 E9 B2 FE FF FF FF 75 10 8B 46 18 33 D2 42 E9 8F FE FF FF 83 7E 08 0B 8B 55 0C 7F 08 8B 92 98 00 00 00 EB 06 8B 92 9C 00 00 00 8B CF 8B C3 E8 ?? ?? ?? ?? 33 C0 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_165_7_0 {
	meta:
		name = "__store_winword"
		size = 1162
		refs = "0003 $T20692 0008 __SEH_prolog 004c __imp__GetDateFormatA@24 0053 __imp__GetTimeFormatA@24 00c1 __alloca_probe 00db __resetstkoflw 00f2 _malloc 014c _free 0158 __SEH_epilog 01c2 ??_C@_05JAMEPDIN@am?1pm?$AA@ 01cb ___ascii_stricmp 022c ??_C@_03EBAPMIKO@a?1p?$AA@ 026f __pctype 042b __expandtime"
	strings:
		$1 = { 6A 38 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 33 F6 2B C6 74 16 48 8B 45 18 74 08 8B 80 A8 00 00 00 EB 11 8B 80 A4 00 00 00 EB 09 8B 45 18 8B 80 A0 00 00 00 89 45 E0 8B 4D 18 83 B9 B0 00 00 00 01 0F 84 16 01 00 00 83 7D 08 02 A1 ?? ?? ?? ?? 75 05 A1 ?? ?? ?? ?? 89 45 D0 8B 5D 0C 66 8B 53 14 66 81 C2 6C 07 66 89 55 B8 66 8B 53 10 66 42 66 89 55 BA 66 8B 53 0C 66 89 55 BE 66 8B 53 08 66 89 55 C0 66 8B 53 04 66 89 55 C2 66 8B 13 66 89 55 C4 66 89 75 C6 56 56 FF 75 E0 8D 55 B8 52 56 FF B1 AC 00 00 00 FF D0 89 45 D4 3B C6 0F 84 AC 00 00 00 89 75 CC 89 75 FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D C8 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 FF 83 4D FC FF 8B 5D 0C 33 F6 3B FE 75 16 FF 75 D4 E8 ?? ?? ?? ?? 59 8B F8 3B FE 74 63 C7 45 CC 01 00 00 00 89 7D DC FF 75 D4 57 FF 75 E0 8D 45 B8 50 56 8B 45 18 FF B0 AC 00 00 00 FF 55 D0 48 3B C6 7E 20 8B 75 14 8B 4D 10 83 3E 00 76 15 8B 11 8B 5D DC 8A 1B 88 1A FF 01 FF 45 DC FF 0E 48 85 C0 7F E6 83 7D CC 00 74 07 57 E8 ?? ?? ?? ?? 59 33 C0 40 8D 65 AC E8 ?? ?? ?? ?? C3 8B 5D 0C 8B 45 E0 8A 08 84 C9 74 E8 8B 7D 14 8B 75 10 EB 03 8B 5D 0C 83 3F 00 74 D8 C6 45 E7 00 33 D2 89 55 D8 8B 45 E0 40 42 38 08 74 FA 89 45 DC 0F BE C9 83 F9 64 0F 8F 56 01 00 00 0F 84 1C 01 00 00 83 F9 27 0F 84 A2 00 00 00 83 F9 41 74 13 83 F9 48 74 5B 83 F9 4D 74 22 83 F9 61 0F 85 55 02 00 00 68 ?? ?? ?? ?? 8B 5D E0 53 E8 ?? ?? ?? ?? 59 59 85 C0 75 56 83 C3 05 EB 65 8B CA 49 74 1F 49 74 23 49 74 10 49 0F 85 2A 02 00 00 C6 45 E7 42 E9 21 02 00 00 C6 45 E7 62 E9 18 02 00 00 C7 45 D8 01 00 00 00 C6 45 E7 6D E9 08 02 00 00 8B CA 49 74 08 49 74 0C E9 FB 01 00 00 C7 45 D8 01 00 00 00 C6 45 E7 48 E9 EB 01 00 00 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 85 C0 75 06 83 C3 03 89 5D DC C6 45 E7 70 E9 CB 01 00 00 01 55 E0 F6 C2 01 0F 84 1A 02 00 00 8B 45 E0 EB 4D 8B 0F 85 C9 0F 84 0B 02 00 00 3C 27 74 4A 0F B6 D0 8B 1D ?? ?? ?? ?? F6 44 53 01 80 74 1E 83 F9 01 76 19 8B 4D E0 41 80 39 00 0F 84 F7 01 00 00 8B 16 88 02 FF 06 8B C1 FF 0F EB 03 8B 45 E0 8B 0E 8A 10 88 11 FF 06 40 89 45 E0 FF 0F 8A 00 84 C0 75 AD E9 BD 01 00 00 FF 45 E0 E9 B5 01 00 00 8B CA 49 74 1F 49 74 23 49 74 10 49 0F 85 48 01 00 00 C6 45 E7 41 E9 3F 01 00 00 C6 45 E7 61 E9 36 01 00 00 C7 45 D8 01 00 00 00 C6 45 E7 64 E9 26 01 00 00 83 E9 68 0F 84 08 01 00 00 83 E9 05 0F 84 E8 00 00 00 83 E9 06 0F 84 C8 00 00 00 49 74 29 83 E9 05 0F 85 FF 00 00 00 8B CA 49 49 74 11 49 49 0F 85 F1 00 00 00 C6 45 E7 59 E9 E8 00 00 00 C6 45 E7 79 E9 DF 00 00 00 8B 45 18 83 7B 08 0B 7F 08 8B 80 98 00 00 00 EB 06 8B 80 9C 00 00 00 83 FA 01 75 78 83 3F 00 76 73 8A 08 0F B6 D1 8B 1D ?? ?? ?? ?? F6 44 53 01 80 74 17 83 3F 01 76 12 40 80 38 00 0F 84 0A 01 00 00 8B 16 88 0A FF 06 FF 0F 8B 0E 8A 00 88 01 FF 06 FF 0F E9 A6 00 00 00 83 3F 00 0F 86 9D 00 00 00 0F B6 D1 8B 1D ?? ?? ?? ?? F6 44 53 01 80 74 17 83 3F 01 76 12 40 80 38 00 0F 84 CB 00 00 00 8B 16 88 0A FF 06 FF 0F 8B 0E 8A 10 88 11 FF 06 40 FF 0F 8A 08 84 C9 75 BF EB 63 8B CA 49 74 05 49 74 09 EB 39 C7 45 D8 01 00 00 00 C6 45 E7 53 EB 2C 8B CA 49 74 05 49 74 09 EB 22 C7 45 D8 01 00 00 00 C6 45 E7 4D EB 15 8B CA 49 74 05 49 74 09 EB 0B C7 45 D8 01 00 00 00 C6 45 E7 49 8A 45 E7 84 C0 74 1E FF 75 D8 FF 75 18 FF 75 0C 8B DF 8B CE E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 4D 8B 45 DC EB 33 8B 45 E0 8A 08 0F B6 D1 8B 1D ?? ?? ?? ?? F6 44 53 01 80 74 13 83 3F 01 76 0E 40 80 38 00 74 28 8B 16 88 0A FF 06 FF 0F 8B 0E 8A 10 88 11 FF 06 40 FF 0F 89 45 E0 8B 45 E0 8A 08 84 C9 0F 85 F3 FC FF FF E9 CE FC FF FF 33 C0 E9 CA FC FF FF }
	condition:
		$1
}

rule file_165_8_0 {
	meta:
		name = "__Strftime"
		size = 200
		refs = "000c ___lc_time_curr 003e __pctype 008d __expandtime"
	strings:
		$1 = { 55 8B EC 51 8B 45 18 85 C0 75 05 A1 ?? ?? ?? ?? 57 8B 7D 0C 85 FF 89 45 FC 75 07 33 C0 E9 A3 00 00 00 85 FF 53 56 89 7D 18 0F 86 83 00 00 00 8B 75 10 8A 06 84 C0 74 67 3C 25 74 37 8B 15 ?? ?? ?? ?? 0F B6 C8 F6 44 4A 01 80 74 17 83 7D 18 01 76 11 46 80 3E 00 74 5A 8B 4D 08 88 01 FF 45 08 FF 4D 18 8A 06 8B 4D 08 88 01 FF 45 08 46 FF 4D 18 EB 26 46 33 C0 80 3E 23 75 02 40 46 50 FF 75 FC 8A 06 FF 75 14 8D 5D 18 8D 4D 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 1A 46 83 7D 18 00 77 93 83 7D 18 00 76 11 8B 45 08 C6 00 00 8B C7 2B 45 18 EB 11 83 7D 18 00 75 03 FF 4D 08 8B 45 08 C6 00 00 33 C0 5E 5B 5F C9 C3 }
	condition:
		$1
}

rule file_165_9_0 {
	meta:
		name = "_strftime"
		size = 27
		refs = "0013 __Strftime"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "___getlocaleinfo"
		size = 328
		refs = "000e ___security_cookie 0039 ___crtGetLocaleInfoA 0048 __imp__GetLastError@0 006a _malloc 00aa _free 00b9 @__security_check_cookie@4 00c3 _strncpy 00e3 ?wcbuffer@?4??__getlocaleinfo@@9@9 00ef ___crtGetLocaleInfoW 0102 ___mb_cur_max 0112 __isctype 011c __pctype"
	strings:
		$1 = { 55 8B EC 81 EC 84 00 00 00 83 7D 08 01 A1 ?? ?? ?? ?? 53 56 89 45 FC 57 0F 85 BA 00 00 00 33 DB 53 8D BD 7C FF FF FF 68 80 00 00 00 8B C7 50 FF 75 10 89 5D 08 FF 75 0C E8 ?? ?? ?? ?? 8B F0 83 C4 14 3B F3 75 4D FF 15 ?? ?? ?? ?? 83 F8 7A 75 5E 53 53 53 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 8B F0 83 C4 14 3B F3 74 47 56 E8 ?? ?? ?? ?? 8B F8 3B FB 59 74 3A 53 56 57 FF 75 10 C7 45 08 01 00 00 00 FF 75 0C E8 ?? ?? ?? ?? 8B F0 83 C4 14 3B F3 74 15 56 E8 ?? ?? ?? ?? 3B C3 59 8B 4D 14 89 01 75 1C 39 5D 08 74 07 57 E8 ?? ?? ?? ?? 59 83 C8 FF 8B 4D FC 5F 5E 5B E8 ?? ?? ?? ?? C9 C3 56 57 50 E8 ?? ?? ?? ?? 83 C4 0C 39 5D 08 74 72 57 E8 ?? ?? ?? ?? 59 EB 69 83 7D 08 00 75 D1 6A 00 6A 04 BE ?? ?? ?? ?? 56 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 B5 8B 7D 14 C6 07 00 83 3D ?? ?? ?? ?? 01 8A 1E 0F B6 C3 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 16 8A 07 B1 0A F6 E9 02 C3 2C 30 46 46 81 FE ?? ?? ?? ?? 88 07 7C BF 33 C0 E9 6A FF FF FF }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "_strstr"
		size = 134
		refs = "0075 ___from_strstr_to_strchr"
	strings:
		$1 = { 8B 4C 24 08 57 53 56 8A 11 8B 7C 24 10 84 D2 74 6F 8A 71 01 84 F6 74 55 8B F7 8B 4C 24 14 8A 07 83 C6 01 38 D0 74 17 84 C0 74 0D 8A 06 83 C6 01 38 D0 74 0A 84 C0 75 F3 5E 5B 5F 33 C0 C3 8A 06 83 C6 01 38 F0 75 E9 8D 7E FF 8A 61 02 84 E4 74 28 8A 06 83 C6 02 38 E0 75 BE 8A 41 03 84 C0 74 18 8A 66 FF 83 C1 02 38 E0 74 DF EB AB 33 C0 5E 5B 5F 8A C2 E9 ?? ?? ?? ?? 8D 47 FF 5E 5B 5F C3 8B C7 5E 5B 5F C3 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "__alloc_osfhnd"
		size = 157
		refs = "000c ___pioinfo 005a _malloc 0065 __nhandle"
	strings:
		$1 = { 53 55 56 57 83 CB FF 33 F6 33 D2 B9 ?? ?? ?? ?? BF 00 01 00 00 8B 01 85 C0 74 3D 8D A8 00 01 00 00 EB 0D F6 40 04 01 74 0D 8B 29 83 C0 08 03 EF 3B C5 72 EF EB 11 83 08 FF 2B 01 C1 F8 03 03 C2 8B D8 83 FB FF 75 4F 83 C1 04 46 83 C2 20 81 F9 ?? ?? ?? ?? 7C BF EB 3E 57 E8 ?? ?? ?? ?? 85 C0 59 74 33 83 05 ?? ?? ?? ?? 20 8D 0C B5 ?? ?? ?? ?? 89 01 8D 90 00 01 00 00 EB 12 83 08 FF C6 40 04 00 C6 40 05 0A 8B 11 83 C0 08 03 D7 3B C2 72 EA C1 E6 05 8B DE 5F 5E 5D 8B C3 5B C3 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "__set_osfhnd"
		size = 119
		refs = "0006 __nhandle 001b ___pioinfo 002c ___app_type 0052 __imp__SetStdHandle@8 0062 __doserrno 0069 _errno"
	strings:
		$1 = { 8B 44 24 04 3B 05 ?? ?? ?? ?? 56 57 73 52 8B C8 C1 F9 05 8B F0 83 E6 1F 8D 3C 8D ?? ?? ?? ?? 8B 0F C1 E6 03 83 3C 0E FF 75 36 83 3D ?? ?? ?? ?? 01 53 8B 5C 24 14 75 1E 83 E8 00 74 10 48 74 08 48 75 13 53 6A F4 EB 08 53 6A F5 EB 03 53 6A F6 FF 15 ?? ?? ?? ?? 8B 07 89 1C 06 33 C0 5B EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5E C3 }
	condition:
		$1
}

rule file_168_2_0 {
	meta:
		name = "__free_osfhnd"
		size = 122
		refs = "0006 __nhandle 0018 ___pioinfo 0033 ___app_type 0055 __imp__SetStdHandle@8 0065 __doserrno 006c _errno"
	strings:
		$1 = { 8B 4C 24 04 3B 0D ?? ?? ?? ?? 56 57 73 55 8B C1 C1 F8 05 8B F1 8D 3C 85 ?? ?? ?? ?? 8B 07 83 E6 1F C1 E6 03 03 C6 F6 40 04 01 74 37 83 38 FF 74 32 83 3D ?? ?? ?? ?? 01 75 1F 33 C0 2B C8 74 10 49 74 08 49 75 13 50 6A F4 EB 08 50 6A F5 EB 03 50 6A F6 FF 15 ?? ?? ?? ?? 8B 07 83 0C 06 FF 33 C0 EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5E C3 }
	condition:
		$1
}

rule file_168_3_0 {
	meta:
		name = "__get_osfhandle"
		size = 60
		refs = "0006 __nhandle 0014 ___pioinfo 0029 __doserrno 0030 _errno"
	strings:
		$1 = { 8B 44 24 04 3B 05 ?? ?? ?? ?? 73 1B 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F 8D 04 C1 F6 40 04 01 74 03 8B 00 C3 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF C3 }
	condition:
		$1
}

rule file_168_4_0 {
	meta:
		name = "__open_osfhandle"
		size = 157
		refs = "0026 __imp__GetFileType@4 0030 __imp__GetLastError@0 0036 __dosmaperr 0054 __alloc_osfhnd 0063 __doserrno 006a _errno 0079 __set_osfhnd 0086 ___pioinfo"
	strings:
		$1 = { 55 8B EC 53 32 DB F6 45 0C 08 74 03 80 C3 20 F6 45 0D 40 74 03 80 CB 80 F6 45 0C 80 74 03 80 CB 10 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF EB 5A 83 F8 02 75 05 80 CB 40 EB 08 83 F8 03 75 03 80 CB 08 56 E8 ?? ?? ?? ?? 8B F0 83 C8 FF 3B F0 75 13 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 18 00 00 00 EB 25 FF 75 08 56 E8 ?? ?? ?? ?? 59 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 59 80 CB 01 8B CE 83 E1 1F 88 5C C8 04 8B C6 5E 5B 5D C3 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "_add"
		size = 59
		refs = "0003 _malloc 001a _arghead 0025 _argend"
		altNames = "_wadd"
	strings:
		$1 = { 6A 08 E8 ?? ?? ?? ?? 85 C0 59 75 04 83 C8 FF C3 8B 4C 24 04 83 60 04 00 83 3D ?? ?? ?? ?? 00 89 08 74 0B 8B 0D ?? ?? ?? ?? 89 41 04 EB 05 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_169_1_0 {
	meta:
		name = "_sort"
		size = 53
		refs = "000f __mbsicmp"
	strings:
		$1 = { 57 8B F8 85 FF 74 2C 56 EB 21 FF 37 FF 36 E8 ?? ?? ?? ?? 85 C0 59 59 7D 08 8B 0E 8B 07 89 0F 89 06 8B 76 04 85 F6 75 E2 8B 7F 04 8B 77 04 85 F6 75 D8 5E 5F C3 }
	condition:
		$1
}

rule file_644_1_0 {
	meta:
		name = "_wsort"
		size = 53
		refs = "000f __wcsicmp"
	strings:
		$1 = { 57 8B F8 85 FF 74 2C 56 EB 21 FF 37 FF 36 E8 ?? ?? ?? ?? 85 C0 59 59 7D 08 8B 0E 8B 07 89 0F 89 06 8B 76 04 85 F6 75 E2 8B 7F 04 8B 77 04 85 F6 75 D8 5E 5F C3 }
	condition:
		$1
}

rule file_169_2_0 {
	meta:
		name = "_find"
		size = 138
		refs = "0009 ?findbuf@?1??find@@9@9 0016 _malloc 0025 ?_WildFindHandle@?1??find@@9@9 0030 __imp__FindClose@4 0047 __imp__FindFirstFileA@8 006c __imp__FindNextFileA@8"
	strings:
		$1 = { 83 7C 24 04 00 74 57 83 3D ?? ?? ?? ?? 00 75 14 68 44 02 00 00 E8 ?? ?? ?? ?? 85 C0 59 A3 ?? ?? ?? ?? 74 63 A1 ?? ?? ?? ?? 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 FF 35 ?? ?? ?? ?? FF 74 24 08 FF 15 ?? ?? ?? ?? 83 F8 FF A3 ?? ?? ?? ?? 74 32 A1 ?? ?? ?? ?? 83 C0 2C C3 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 E1 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 33 C0 C3 }
	condition:
		$1
}

rule file_169_3_0 {
	meta:
		name = "_match"
		size = 360
		refs = "002b __mbsdec 005e _find 006e _argend 0076 ??_C@_01LFCBOECM@?4?$AA@ 007c __mbscmp 0087 ??_C@_02DJGKEECL@?4?4?$AA@ 00a7 __strdup 00b5 _add 00be _strlen 00c8 _malloc 00d9 __mbsnbcpy 00e4 _strcpy 0124 _arghead 0133 __mbsicmp"
	strings:
		$1 = { 55 8B EC 51 51 53 56 33 DB 57 8B 7D 08 8B F0 89 5D FC EB 1F 8A 06 3C 5C 74 1D 3C 2F 74 19 3C 3A 74 1A 4E 3B F7 76 0E 46 56 57 E8 ?? ?? ?? ?? 59 59 8B F0 3B F7 75 DD 80 3E 3A 75 0D 8D 47 01 3B F0 74 06 57 E9 14 01 00 00 8A 06 3C 5C 74 08 3C 2F 74 04 3C 3A 75 05 8B DE 2B DF 43 57 E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 84 ED 00 00 00 A1 ?? ?? ?? ?? 89 45 F8 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 85 C0 59 59 74 74 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 85 C0 59 59 74 63 8A 06 3C 5C 74 1F 3C 3A 74 1B 3C 2F 74 17 57 E8 ?? ?? ?? ?? 85 C0 59 89 45 08 74 6A 50 E8 ?? ?? ?? ?? 59 EB 37 57 E8 ?? ?? ?? ?? 8D 44 18 01 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 4B 57 53 FF 75 08 50 E8 ?? ?? ?? ?? 03 C3 83 C4 0C 50 E8 ?? ?? ?? ?? 2B C3 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 26 FF 45 FC 6A 00 E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 85 69 FF FF FF 39 45 FC 74 49 8B 45 F8 85 C0 74 0A 8B 70 04 EB 0B 83 C8 FF EB 41 8B 35 ?? ?? ?? ?? 85 F6 74 2A EB 21 FF 36 FF 37 E8 ?? ?? ?? ?? 85 C0 59 59 7D 08 8B 0F 8B 06 89 0E 89 07 8B 7F 04 85 FF 75 E2 8B 76 04 8B 7E 04 85 FF 75 D8 33 C0 EB 09 FF 75 08 E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_169_4_0 {
	meta:
		name = "__cwild"
		size = 194
		refs = "0003 ___argv 000c _argend 0012 _arghead 0026 _add 0040 ??_C@_02GNLKMPOH@?$CK?$DP?$AA@ 0046 __mbspbrk 0053 _match 006a _malloc 0087 ___argc 00ac _free"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 1A 8B 06 8A 08 40 80 F9 22 89 06 75 1B 50 E8 ?? ?? ?? ?? 85 C0 59 75 44 83 C6 04 39 3E 75 E2 A1 ?? ?? ?? ?? 33 F6 EB 1E 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 3B C7 59 59 FF 36 74 D3 E8 ?? ?? ?? ?? EB D1 8B 40 04 46 3B C7 75 F8 8D 04 B5 04 00 00 00 50 E8 ?? ?? ?? ?? 3B C7 59 75 05 83 C8 FF EB 47 8B 0D ?? ?? ?? ?? 3B CF A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 8B D1 74 0E 8B 32 89 30 8B 52 04 83 C0 04 3B D7 75 F2 89 38 EB 16 8B 49 04 50 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 0D ?? ?? ?? ?? 3B CF 8B C1 75 E4 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__chmod"
		size = 65
		refs = "0006 __imp__GetFileAttributesA@4 0025 __imp__SetFileAttributesA@8 002f __imp__GetLastError@0 0035 __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 83 F8 FF 74 1E F6 44 24 08 80 74 05 83 E0 FE EB 03 83 C8 01 50 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_513_0_0 {
	meta:
		name = "__wchmod"
		size = 65
		refs = "0006 __imp__GetFileAttributesW@4 0025 __imp__SetFileAttributesW@8 002f __imp__GetLastError@0 0035 __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 83 F8 FF 74 1E F6 44 24 08 80 74 05 83 E0 FE EB 03 83 C8 01 50 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__filelength"
		size = 120
		refs = "0007 __nhandle 0015 ___pioinfo 002d __lseek 0064 __doserrno 006b _errno"
	strings:
		$1 = { 56 8B 74 24 08 3B 35 ?? ?? ?? ?? 73 55 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B CE 83 E1 1F F6 44 C8 04 01 74 3D 53 57 6A 01 6A 00 56 E8 ?? ?? ?? ?? 8B F8 83 CB FF 83 C4 0C 3B FB 74 1F 6A 02 6A 00 56 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 3B FB 74 0C 6A 00 57 56 E8 ?? ?? ?? ?? 83 C4 0C 5F 8B C3 5B 5E C3 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5E C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "___initconin"
		size = 31
		refs = "000f ??_C@_06GDENEHCP@CONIN$?$AA@ 0015 __imp__CreateFileA@28 001a __coninpfh"
	strings:
		$1 = { 33 C0 50 50 6A 03 50 6A 03 68 00 00 00 C0 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "___initconout"
		size = 31
		refs = "000f ??_C@_07GPDNMNG@CONOUT$?$AA@ 0015 __imp__CreateFileA@28 001a __confh"
	strings:
		$1 = { 33 C0 50 50 6A 03 50 6A 03 68 00 00 00 40 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_172_2_0 {
	meta:
		name = "___termcon"
		size = 45
		refs = "0001 __confh 000b __imp__CloseHandle@4 001a __coninpfh"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 56 8B 35 ?? ?? ?? ?? 74 08 83 F8 FE 74 03 50 FF D6 A1 ?? ?? ?? ?? 83 F8 FF 74 08 83 F8 FE 74 03 50 FF D6 5E C3 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__access"
		size = 68
		refs = "0006 __imp__GetFileAttributesA@4 0011 __imp__GetLastError@0 0017 __dosmaperr 002d _errno 0037 __doserrno"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 83 F8 FF 75 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 A8 01 74 1D F6 44 24 08 02 74 16 C7 05 ?? ?? ?? ?? 0D 00 00 00 C7 05 ?? ?? ?? ?? 05 00 00 00 EB DB 33 C0 C3 }
	condition:
		$1
}

rule file_713_0_0 {
	meta:
		name = "__waccess"
		size = 68
		refs = "0006 __imp__GetFileAttributesW@4 0011 __imp__GetLastError@0 0017 __dosmaperr 002d _errno 0037 __doserrno"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 83 F8 FF 75 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 A8 01 74 1D F6 44 24 08 02 74 16 C7 05 ?? ?? ?? ?? 0D 00 00 00 C7 05 ?? ?? ?? ?? 05 00 00 00 EB DB 33 C0 C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "__msize"
		size = 56
		refs = "0002 ___active_heap 0010 ___sbh_find_block 002c __crtheap 0032 __imp__HeapSize@12"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 03 56 75 1A 8B 74 24 08 56 E8 ?? ?? ?? ?? 85 C0 59 74 08 8B 46 FC 83 E8 09 5E C3 56 EB 04 FF 74 24 08 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "_swprintf"
		size = 111
		refs = "002a __woutput 004a __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 89 45 E8 89 45 E0 56 8D 45 10 50 FF 75 0C 8D 45 E0 50 C7 45 EC 42 00 00 00 C7 45 E4 FF FF FF 7F E8 ?? ?? ?? ?? 83 C4 0C FF 4D E4 8B F0 78 0B 8B 45 E0 C6 00 00 FF 45 E0 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "_mbstowcs"
		size = 263
		refs = "0022 ___lc_handle 0056 __imp__MultiByteToWideChar@24 0063 ___lc_codepage 0073 __imp__GetLastError@0 007e _errno 009e __pctype 00dd _strlen"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 33 F6 33 C0 3B DE 57 0F 84 BC 00 00 00 8B 55 10 3B D6 0F 84 E2 00 00 00 39 35 ?? ?? ?? ?? 75 29 3B D6 0F 86 D2 00 00 00 8B 4D 0C 03 C8 66 0F B6 31 66 89 33 80 39 00 0F 84 BD 00 00 00 40 43 43 3B C2 72 E4 E9 B1 00 00 00 8B 7D 0C 8B 35 ?? ?? ?? ?? 52 53 6A FF 57 6A 09 FF 35 ?? ?? ?? ?? FF D6 85 C0 0F 85 90 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 7A 74 0F C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 77 8B 45 10 89 45 08 8B C7 8A 08 FF 4D 08 84 C9 74 1D 8B 15 ?? ?? ?? ?? 0F B6 C9 F6 44 4A 01 80 74 06 40 80 38 00 74 CA 40 83 7D 08 00 75 DA FF 75 10 2B C7 53 50 57 6A 01 FF 35 ?? ?? ?? ?? FF D6 85 C0 75 33 EB AB 39 35 ?? ?? ?? ?? 75 0B FF 75 0C E8 ?? ?? ?? ?? 59 EB 1E 56 56 6A FF FF 75 0C 6A 09 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B C6 0F 84 7B FF FF FF 48 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "_strrchr"
		size = 45
	strings:
		$1 = { 55 8B EC 57 8B 7D 08 33 C0 83 C9 FF F2 AE 83 C1 01 F7 D9 83 EF 01 8A 45 0C FD F2 AE 83 C7 01 38 07 74 04 33 C0 EB 02 8B C7 FC 5F C9 C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "__set_error_mode"
		size = 40
		refs = "0013 ___error_mode"
	strings:
		$1 = { 8B 4C 24 04 85 C9 7C 1C 83 F9 02 7E 0B 83 F9 03 75 12 A1 ?? ?? ?? ?? C3 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__putch"
		size = 68
		refs = "0006 __confh 0014 ___initconout 0031 __imp__WriteConsoleA@20"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? FE 8A 45 08 88 45 0B 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 74 1D 6A 00 8D 4D FC 51 6A 01 8D 4D 0B 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 0F B6 45 0B C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__wfdopen"
		size = 222
		refs = "0006 __nhandle 0015 ___pioinfo 0050 __commode 00b3 __getstream 00bf _errno 00ce __cflush"
	strings:
		$1 = { 8B 44 24 04 3B 05 ?? ?? ?? ?? 53 73 2C 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F F6 44 C1 04 01 74 16 8B 4C 24 0C 0F B7 01 83 F8 61 74 13 83 F8 72 74 09 83 F8 77 74 09 33 C0 5B C3 33 DB 43 EB 03 6A 02 5B 56 33 F6 57 46 33 D2 33 FF 0B 1D ?? ?? ?? ?? EB 52 85 F6 74 58 0F B7 C0 83 E8 2B 74 39 83 E8 37 74 0D 48 74 1F 83 E8 0B 74 0D 83 E8 06 75 04 85 FF 74 1E 33 F6 EB 2C 85 D2 75 F8 42 81 E3 FF BF FF FF EB 1F 85 D2 75 EB 42 81 CB 00 40 00 00 EB 12 33 FF 47 EB 0D 84 DB 78 D9 83 E3 FC 81 CB 80 00 00 00 41 41 66 8B 01 66 85 C0 75 A4 E8 ?? ?? ?? ?? 85 C0 5F 5E 75 0F C7 05 ?? ?? ?? ?? 18 00 00 00 E9 6D FF FF FF FF 05 ?? ?? ?? ?? 8B 4C 24 08 89 58 0C 89 48 10 5B C3 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__cputs"
		size = 72
		refs = "0009 __confh 0011 ___initconout 0027 _strlen 0038 __imp__WriteConsoleA@20"
	strings:
		$1 = { 55 8B EC 51 56 33 F6 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 74 22 56 8D 45 FC 50 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 75 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 03 83 CE FF 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_189_1_0 {
	meta:
		name = "__strcats"
		size = 36
		refs = "0018 _strcat"
	strings:
		$1 = { 57 8B 7C 24 0C 85 FF 7E 19 56 8D 74 24 10 83 C6 04 FF 36 FF 74 24 10 E8 ?? ?? ?? ?? 4F 59 59 75 ED 5E 5F C3 }
	condition:
		$1
}

rule file_189_2_0 {
	meta:
		name = "___lc_strtolc"
		size = 220
		refs = "0011 _memset 0038 _strncpy 00c0 ??_C@_03EGDHDPFD@_?4?0?$AA@ 00c6 _strcspn"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 68 90 00 00 00 6A 00 57 E8 ?? ?? ?? ?? 8B 75 0C 8A 06 83 C4 0C 84 C0 74 25 3C 2E 75 28 8D 46 01 80 38 00 74 20 6A 0F 50 8D 87 80 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C C6 87 8F 00 00 00 00 33 C0 E9 87 00 00 00 83 65 0C 00 53 EB 6B 83 7D 0C 00 8D 3C 30 8A 1F 75 11 83 F8 40 73 6C 80 FB 2E 74 67 50 56 FF 75 08 EB 38 83 7D 0C 01 75 13 83 F8 40 73 55 80 FB 5F 74 50 50 8B 45 08 83 C0 40 EB 1D 83 7D 0C 02 75 41 83 F8 10 73 3C 84 DB 74 05 80 FB 2C 75 33 50 8B 45 08 05 80 00 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 80 FB 2C 74 23 84 DB 74 1F FF 45 0C 8D 77 01 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 84 83 C8 FF 5B 5F 5E 5D C3 33 C0 EB F7 }
	condition:
		$1
}

rule file_189_3_0 {
	meta:
		name = "___lc_lctostr"
		size = 78
		refs = "000b _strcpy 001b ??_C@_01IDAFKMJL@_?$AA@ 0026 __strcats 003b ??_C@_01LFCBOECM@?4?$AA@"
	strings:
		$1 = { 56 8B 74 24 0C 56 FF 74 24 0C E8 ?? ?? ?? ?? 8D 46 40 80 38 00 59 59 74 14 50 68 ?? ?? ?? ?? 6A 02 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 10 8D 86 80 00 00 00 80 38 00 5E 74 14 50 68 ?? ?? ?? ?? 6A 02 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_189_4_0 {
	meta:
		name = "__setlocale_get_all"
		size = 191
		refs = "0001 ___lc_category 0013 _malloc 0030 ??_C@_01NEMOKFLO@?$DN?$AA@ 0044 __strcats 0053 ??_C@_01ICJEACDI@?$DL?$AA@ 005e _strcat 006a _strcmp 00ac _free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 55 33 ED 45 85 C0 75 16 68 51 03 00 00 E8 ?? ?? ?? ?? 85 C0 59 A3 ?? ?? ?? ?? 75 02 5D C3 53 56 57 C6 00 00 FF 35 ?? ?? ?? ?? BF ?? ?? ?? ?? 57 FF 35 ?? ?? ?? ?? 6A 03 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 83 C4 14 8B DE 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C6 0C FF 36 FF 33 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 02 33 ED FF 36 8B DE 57 FF 76 FC 6A 03 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 81 FE ?? ?? ?? ?? 7C BB 85 ED 5F 5E 5B 75 07 A1 ?? ?? ?? ?? 5D C3 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 A1 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_189_5_0 {
	meta:
		name = "__expandlocale"
		size = 348
		refs = "000a ___security_cookie 005f _strlen 006c ?cachein@?1??_expandlocale@@9@9 0074 ?cacheout@?1??_expandlocale@@9@9 0079 _strcmp 009d ___lc_strtolc 00af ?cacheid@?1??_expandlocale@@9@9 00b5 ___get_qualified_locale 00cf ?cachecp@?1??_expandlocale@@9@9 00e0 ___lc_lctostr 00f7 ??_C@_00CNPNBAHC@?$AA@ 0106 _strncpy 011e _memcpy 0147 _strcpy 0156 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 94 00 00 00 A1 ?? ?? ?? ?? 56 8B 75 08 33 D2 3B F2 89 45 FC 75 07 33 C0 E9 2F 01 00 00 80 3E 43 75 34 80 7E 01 00 75 2E 8B 45 0C 8B 4D 10 3B CA C6 00 43 C6 40 01 00 74 0B 66 89 11 66 89 51 02 66 89 51 04 8B 4D 14 3B CA 0F 84 FD 00 00 00 89 11 E9 F6 00 00 00 53 57 56 E8 ?? ?? ?? ?? BF 82 00 00 00 3B C7 59 BB ?? ?? ?? ?? 73 22 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 86 00 00 00 56 53 E8 ?? ?? ?? ?? 85 C0 59 59 74 79 8D 85 6C FF FF FF 56 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 19 8D 85 6C FF FF FF 50 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 07 33 C0 E9 88 00 00 00 0F B7 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8D 85 6C FF FF FF 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3E 00 59 59 74 0B 56 E8 ?? ?? ?? ?? 3B C7 59 72 05 BE ?? ?? ?? ?? 57 56 53 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 10 00 74 12 6A 06 68 ?? ?? ?? ?? FF 75 10 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 74 12 6A 04 68 ?? ?? ?? ?? FF 75 14 E8 ?? ?? ?? ?? 83 C4 0C BE ?? ?? ?? ?? 56 FF 75 0C E8 ?? ?? ?? ?? 59 59 8B C6 5F 5B 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_189_6_0 {
	meta:
		name = "__setlocale_set_cat"
		size = 655
		refs = "000c ___security_cookie 002a __expandlocale 0042 ___lc_category 004b _strcmp 0065 _strlen 006c _malloc 0090 ___lc_handle 00a2 ___lc_id 00b7 _memcpy 00bc ___lc_codepage 00d1 _strcpy 010c ?_Lcid_c@?1??_setlocale_set_cat@@9@9 01b8 __first_127char 01bf ___crtGetStringTypeA 01e6 __ctype_loc_style 01ec _memcmp 0215 ___lc_clike 0225 ___lc_collate_cp 0246 _free 0268 __clocalestr 0286 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC C0 01 00 00 A1 ?? ?? ?? ?? 89 45 70 56 8D 85 E4 FE FF FF 50 8D 85 C8 FE FF FF 50 8D 45 EC 50 FF 75 7C E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 84 49 02 00 00 53 8D 1C 76 C1 E3 02 FF B3 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 0B 8B 83 ?? ?? ?? ?? E9 21 02 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 85 C0 59 59 89 85 DC FE FF FF 0F 84 01 02 00 00 8B 83 ?? ?? ?? ?? 57 89 85 E0 FE FF FF 8D 3C B5 ?? ?? ?? ?? 8B 07 89 85 C4 FE FF FF 8D 04 76 8D 04 45 ?? ?? ?? ?? 6A 06 50 89 85 E8 FE FF FF 8D 85 B4 FE FF FF 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 85 D8 FE FF FF 8D 45 EC 50 FF B5 DC FE FF FF E8 ?? ?? ?? ?? 89 83 ?? ?? ?? ?? 0F B7 85 C8 FE FF FF 89 07 6A 06 8D 85 C8 FE FF FF 50 FF B5 E8 FE FF FF E8 ?? ?? ?? ?? 83 C4 20 83 FE 02 0F 85 15 01 00 00 8B 85 E4 FE FF FF 8B 0D ?? ?? ?? ?? 83 A5 E8 FE FF FF 00 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 85 D4 FE FF FF B8 ?? ?? ?? ?? 8B 95 E4 FE FF FF 3B 10 74 34 8B 10 FF 85 E8 FE FF FF 89 08 8B 8D D4 FE FF FF 89 95 BC FE FF FF 8B 50 04 89 48 04 8B 8D BC FE FF FF 83 C0 08 3D ?? ?? ?? ?? 89 95 D4 FE FF FF 7C C4 EB 2D 8B 85 E8 FE FF FF 85 C0 74 23 8D 04 C5 ?? ?? ?? ?? 8B 10 89 15 ?? ?? ?? ?? 8B 50 04 89 15 ?? ?? ?? ?? 89 08 8B 8D D4 FE FF FF 89 48 04 83 BD E8 FE FF FF 05 75 6F 6A 01 FF 35 ?? ?? ?? ?? 8D 85 EC FE FF FF FF B5 E4 FE FF FF 50 6A 7F 68 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 30 33 C0 80 A4 45 ED FE FF FF 01 40 83 F8 7F 72 F2 68 FE 00 00 00 8D 85 EC FE FF FF 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 40 EB 02 33 C0 8B 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 FE 01 75 0B 8B 85 E4 FE FF FF A3 ?? ?? ?? ?? FF 93 ?? ?? ?? ?? 85 C0 74 2F 8B 85 E0 FE FF FF FF B5 DC FE FF FF 89 83 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 C4 FE FF FF 89 07 8B 85 D8 FE FF FF A3 ?? ?? ?? ?? 59 33 C0 EB 1E 81 BD E0 FE FF FF ?? ?? ?? ?? 74 0C FF B5 E0 FE FF FF E8 ?? ?? ?? ?? 59 8B 83 ?? ?? ?? ?? 5F 5B 8B 4D 70 E8 ?? ?? ?? ?? 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_189_7_0 {
	meta:
		name = "_setlocale"
		size = 499
		refs = "000c ___security_cookie 0039 __setlocale_set_cat 0049 ___lc_category 0085 ??_C@_02BALPLPBG@?$DN?$DL?$AA@ 008b _strpbrk 00c5 _strncmp 00d3 _strlen 00ed ??_C@_01ICJEACDI@?$DL?$AA@ 00f3 _strcspn 0117 _strncpy 014c __setlocale_get_all 0162 __expandlocale 0183 _strcmp 01c4 _free 01ea @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 90 81 EC 90 00 00 00 A1 ?? ?? ?? ?? 53 56 8B 75 78 33 DB 3B F3 89 45 6C 57 0F 8C BE 01 00 00 83 FE 05 0F 8F B5 01 00 00 3B F3 74 22 39 5D 7C 74 0E FF 75 7C E8 ?? ?? ?? ?? 59 E9 0D 01 00 00 8D 04 76 8B 34 85 ?? ?? ?? ?? E9 00 01 00 00 8B 7D 7C 3B FB C7 45 E4 01 00 00 00 89 5D 78 0F 84 E4 00 00 00 80 3F 4C 0F 85 E9 00 00 00 80 7F 01 43 0F 85 DF 00 00 00 80 7F 02 5F 0F 85 D5 00 00 00 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B D8 85 DB 59 59 0F 84 46 01 00 00 2B C7 89 45 E4 0F 84 3B 01 00 00 80 3B 3B 0F 84 32 01 00 00 C7 45 E0 01 00 00 00 BE ?? ?? ?? ?? EB 03 8B 45 E4 50 57 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0D FF 36 E8 ?? ?? ?? ?? 39 45 E4 59 74 0E FF 45 E0 83 C6 0C 81 FE ?? ?? ?? ?? 7E D2 43 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B F8 85 FF 59 59 75 09 80 3B 3B 0F 85 D9 00 00 00 8B 75 E0 83 FE 05 7F 23 57 8D 45 E8 53 50 E8 ?? ?? ?? ?? 8D 45 E8 50 C6 44 3D E8 00 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 03 FF 45 78 03 FB 80 3F 00 74 0A 47 80 3F 00 0F 85 40 FF FF FF 33 F6 39 75 78 74 07 E8 ?? ?? ?? ?? 8B F0 8B C6 E9 8A 00 00 00 53 53 53 8D 45 E8 50 57 E8 ?? ?? ?? ?? 8B F0 83 C4 14 3B F3 74 E3 BF ?? ?? ?? ?? 33 F6 8B DF 3B DF 74 27 FF 33 8D 45 E8 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 13 8D 45 E8 50 E8 ?? ?? ?? ?? 85 C0 59 75 05 21 45 E4 EB 03 FF 45 78 83 C3 0C 46 81 FB ?? ?? ?? ?? 7E C9 33 FF 39 7D E4 74 1B E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 59 89 3D ?? ?? ?? ?? EB 81 39 7D 78 0F 85 71 FF FF FF 33 F6 E9 71 FF FF FF 33 C0 8B 4D 6C 5F 5E 5B E8 ?? ?? ?? ?? 83 C5 70 C9 C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "__mbsnbcpy"
		size = 129
		refs = "0005 ___ismbcodepage 001b _strncpy 0037 __mbctype"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 57 8B 7D 08 89 7D 08 75 11 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C EB 48 8B 4D 10 85 C9 74 3E 8B 55 0C 56 8A 02 0F B6 F0 49 F6 86 ?? ?? ?? ?? 04 88 07 74 2F 47 42 85 C9 74 35 8A 02 49 88 07 47 42 84 C0 75 24 88 47 FE 85 C9 74 10 8B D1 C1 E9 02 33 C0 F3 AB 8B CA 83 E1 03 F3 AA 5E 8B 45 08 5F 5D C3 47 42 84 C0 74 DF 85 C9 75 B6 EB ED C6 47 FF 00 EB E7 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__amsg_exit"
		size = 37
		refs = "0002 ___error_mode 000a __FF_MSGBANNER 0013 __NMSG_WRITE 001e __aexit_rtn"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? FF 74 24 04 E8 ?? ?? ?? ?? 68 FF 00 00 00 FF 15 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "_fast_error_exit"
		size = 36
		refs = "0002 ___error_mode 000a __FF_MSGBANNER 0013 __NMSG_WRITE 001d ___crtExitProcess"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? FF 74 24 04 E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "_wWinMainCRTStartup"
		size = 475
		refs = "0003 $T20693 0008 __SEH_prolog 0014 __alloca_probe 0022 __imp__GetVersionExA@4 002b __osplatform 0033 __winmajor 003c __winminor 004b __osver 0066 __winver 006f __imp__GetModuleHandleA@4 00c9 __heap_init 00d4 ___error_mode 00dc __FF_MSGBANNER 00e3 __NMSG_WRITE 00ed ___crtExitProcess 00f4 __RTC_Initialize 00fc __ioinit 0107 __amsg_exit 010d ___crtGetCommandLineW 0112 __wcmdln 0117 ___crtGetEnvironmentStringsW 011c __wenvptr 0121 __wsetargv 0132 __wsetenvp 0145 __cinit 0161 __imp__GetStartupInfoW@4 0166 __wwincmdln 0186 _wWinMain@16 0196 _exit 019b __cexit 01ae __XcptFilter 01c3 __exit 01c8 __c_exit 01d6 __SEH_epilog"
	strings:
		$1 = { 6A 60 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 89 65 E8 8B F4 89 3E 56 FF 15 ?? ?? ?? ?? 8B 4E 10 89 0D ?? ?? ?? ?? 8B 46 04 A3 ?? ?? ?? ?? 8B 56 08 89 15 ?? ?? ?? ?? 8B 76 0C 81 E6 FF 7F 00 00 89 35 ?? ?? ?? ?? 83 F9 02 74 0C 81 CE 00 80 00 00 89 35 ?? ?? ?? ?? C1 E0 08 03 C2 A3 ?? ?? ?? ?? 33 F6 56 8B 3D ?? ?? ?? ?? FF D7 66 81 38 4D 5A 75 1F 8B 48 3C 03 C8 81 39 50 45 00 00 75 12 0F B7 41 18 3D 0B 01 00 00 74 1F 3D 0B 02 00 00 74 05 89 75 E4 EB 27 83 B9 84 00 00 00 0E 76 F2 33 C0 39 B1 F8 00 00 00 EB 0E 83 79 74 0E 76 E2 33 C0 39 B1 E8 00 00 00 0F 95 C0 89 45 E4 56 E8 ?? ?? ?? ?? 59 85 C0 75 21 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? 6A 1C E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 89 75 FC E8 ?? ?? ?? ?? 85 C0 7D 08 6A 1B E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 89 45 D8 3B C6 74 07 50 E8 ?? ?? ?? ?? 59 89 75 BC 8D 45 90 50 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 F6 45 BC 01 74 06 0F B7 45 C0 EB 03 6A 0A 58 50 FF 75 E0 56 56 FF D7 50 E8 ?? ?? ?? ?? 8B F8 89 7D D4 39 75 E4 75 06 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2B 8B 45 EC 8B 08 8B 09 89 4D DC 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 7D DC 83 7D E4 00 75 06 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D FC FF 8B C7 8D 65 84 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "__wcsnicmp"
		size = 158
		refs = "0010 ___lc_handle 006b _towlower"
	strings:
		$1 = { 55 8B EC 33 C0 39 45 10 0F 84 8E 00 00 00 39 05 ?? ?? ?? ?? 53 75 45 8B 55 0C 8B 4D 08 33 C0 66 8B 01 66 3D 41 00 72 09 66 3D 5A 00 8D 58 20 76 02 8B D8 33 C0 66 8B 02 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 41 41 42 42 FF 4D 10 74 43 66 85 DB 74 3E 66 3B D8 74 C3 EB 37 56 8B 75 08 57 8B 7D 0C 33 C0 66 8B 06 50 E8 ?? ?? ?? ?? 46 46 8B D8 33 C0 66 8B 07 50 E8 ?? ?? ?? ?? 47 59 47 FF 4D 10 59 74 0A 66 85 DB 74 05 66 3B D8 74 D3 5F 5E 0F B7 C8 0F B7 C3 2B C1 5B 5D C3 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "_wcscspn"
		size = 67
	strings:
		$1 = { 8B 44 24 04 66 83 38 00 53 56 57 74 2C 8B 5C 24 14 33 FF 66 8B 3B 66 85 FF 8B D3 74 14 66 8B 30 8B CF 66 3B CE 74 12 42 42 66 8B 0A 66 85 C9 75 F1 40 40 66 83 38 00 75 DD 2B 44 24 10 5F 5E D1 F8 5B C3 }
	condition:
		$1
}

rule file_195_1_0 {
	meta:
		name = "__unloaddll"
		size = 23
		refs = "0006 __imp__FreeLibrary@4 0010 __imp__GetLastError@0"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 06 FF 25 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__mbsrev"
		size = 92
		refs = "0002 ___ismbcodepage 0015 __strrev 0021 __mbctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 8B 4C 24 04 56 57 8B F9 8B F1 75 28 51 E8 ?? ?? ?? ?? 59 EB 3D 0F B6 C2 8A 80 ?? ?? ?? ?? 24 04 41 84 C0 74 0F 8A 11 84 D2 74 11 8A 41 FF 88 01 88 51 FF 41 8A 11 84 D2 75 DB EB 0F 49 C6 01 00 EB 09 8A 16 8A 01 88 06 46 88 11 49 3B F1 72 F2 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "___mbtow_environ"
		size = 130
		refs = "0009 __environ 001b __imp__MultiByteToWideChar@24 0033 _malloc 0055 ___crtwsetenv 0078 _free"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B 35 ?? ?? ?? ?? 33 DB 89 5D FC 8B 06 3B C3 57 74 4F 8B 3D ?? ?? ?? ?? 53 53 6A FF 50 53 53 FF D7 3B C3 89 45 F8 74 4E 03 C0 50 E8 ?? ?? ?? ?? 3B C3 59 89 45 FC 74 3E FF 75 F8 50 6A FF FF 36 53 53 FF D7 85 C0 74 25 8D 45 FC 53 50 E8 ?? ?? ?? ?? 85 C0 59 59 7C 10 83 C6 04 8B 06 3B C3 75 B7 33 C0 5F 5E 5B C9 C3 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 83 C8 FF EB E8 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "_IsRootUNCName"
		size = 109
		refs = "0002 _strlen"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 83 F8 05 59 72 5E 8A 06 3C 5C 74 04 3C 2F 75 54 8A 46 01 3C 5C 74 04 3C 2F 75 49 8D 46 03 8A 08 32 D2 3A CA 74 3E 80 F9 5C 74 0C 80 F9 2F 74 07 40 8A 08 3A CA 75 EF 38 10 74 29 40 38 10 74 24 8A 08 3A CA 74 1A 80 F9 5C 74 0C 80 F9 2F 74 07 40 8A 08 3A CA 75 EF 38 10 74 05 38 50 01 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_198_1_0 {
	meta:
		name = "__stat64"
		size = 894
		refs = "000c ___security_cookie 0015 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 001e __mbspbrk 002c _errno 0031 __doserrno 006b __mbctolower 0076 __getdrive 008b __imp__FindFirstFileA@8 00a1 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 00c3 __fullpath 00d2 _strlen 00dd _IsRootUNCName 00e8 __imp__GetDriveTypeA@4 011e ___loctotime64_t 0160 __imp__FileTimeToLocalFileTime@8 017c __imp__FileTimeToSystemTime@8 02f8 __imp__FindClose@4 0306 ___dtoxmode 0321 __allmul 0355 __imp__GetLastError@0 035b __dosmaperr 0375 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 90 81 EC 68 02 00 00 A1 ?? ?? ?? ?? 56 8B 75 78 68 ?? ?? ?? ?? 56 89 45 6C E8 ?? ?? ?? ?? 85 C0 59 59 74 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 33 03 00 00 53 33 DB 80 7E 01 3A 75 2F 8A 06 3A C3 74 1A 38 5E 02 75 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 09 03 00 00 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 08 FE FF FF 57 8D 85 2C FF FF FF 50 56 FF 15 ?? ?? ?? ?? 83 CF FF 3B C7 89 85 14 FE FF FF 0F 85 B0 00 00 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 89 00 00 00 68 04 01 00 00 8D 85 28 FE FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 3B F3 74 6E 56 E8 ?? ?? ?? ?? 83 F8 03 59 74 09 E8 ?? ?? ?? ?? 85 C0 74 59 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 4D 8B 75 7C 57 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 85 2C FF FF FF 10 00 00 00 89 9D 48 FF FF FF 89 9D 4C FF FF FF 88 9D 58 FF FF FF E8 ?? ?? ?? ?? 8B CA 83 C4 1C 89 46 28 89 56 2C 89 46 20 89 4E 24 89 46 30 89 4E 34 E9 BE 01 00 00 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 1C 02 00 00 8D 85 0C FE FF FF 50 8D 85 40 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E7 01 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CB 01 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 8B 75 7C 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 39 9D 38 FF FF FF 89 46 28 89 56 2C 75 12 39 9D 3C FF FF FF 75 0A 89 46 20 8B C2 89 46 24 EB 77 8D 85 0C FE FF FF 50 8D 85 38 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 53 01 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 37 01 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 89 56 24 39 9D 30 FF FF FF 75 16 39 9D 34 FF FF FF 75 0E 8B 46 28 89 46 30 8B 46 2C 89 46 34 EB 77 8D 85 0C FE FF FF 50 8D 85 30 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BE 00 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A2 00 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 30 89 56 34 FF B5 14 FE FF FF FF 15 ?? ?? ?? ?? FF 75 78 FF B5 2C FF FF FF E8 ?? ?? ?? ?? 59 59 6A 01 53 53 FF B5 48 FF FF FF 66 89 46 06 66 C7 46 08 01 00 E8 ?? ?? ?? ?? 8B 8D 4C FF FF FF 33 FF 03 C1 89 46 18 8B 85 08 FE FF FF 13 D7 48 89 06 89 46 10 89 56 1C 66 89 5E 04 66 89 5E 0C 66 89 5E 0A 33 C0 EB 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 14 FE FF FF FF 15 ?? ?? ?? ?? 8B C7 5F 5B 8B 4D 6C 5E E8 ?? ?? ?? ?? 83 C5 70 C9 C3 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "__mbsnicmp"
		size = 350
		refs = "0011 ___ismbcodepage 0022 __strnicmp 0032 ___mbulinfo 004a __mbctype 00b3 __mbcasemap"
	strings:
		$1 = { 55 8B EC 51 51 83 7D 10 00 75 04 33 C0 C9 C3 83 3D ?? ?? ?? ?? 00 75 13 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 8B 4D 0C 56 66 8B 35 ?? ?? ?? ?? 57 8B 7D 08 66 0F B6 07 FF 4D 10 47 89 45 F8 0F B6 C0 F6 80 ?? ?? ?? ?? 04 74 51 8A 07 84 C0 75 06 83 65 F8 00 EB 5D 33 D2 8A 75 F8 47 8A D0 66 8B C2 66 3B C6 89 55 F8 72 13 66 3B 05 ?? ?? ?? ?? 77 0A A1 ?? ?? ?? ?? 01 45 F8 EB 37 66 3B 05 ?? ?? ?? ?? 72 2E 66 3B 05 ?? ?? ?? ?? 77 25 66 03 05 ?? ?? ?? ?? 66 89 45 F8 EB 18 0F B7 45 F8 F6 80 ?? ?? ?? ?? 10 74 08 66 0F B6 80 ?? ?? ?? ?? 89 45 F8 66 0F B6 01 41 89 45 FC 0F B6 C0 F6 80 ?? ?? ?? ?? 04 74 51 8A 01 84 C0 75 06 83 65 FC 00 EB 5D 33 D2 8A 75 FC 41 8A D0 66 8B C2 66 3B C6 89 55 FC 72 13 66 3B 05 ?? ?? ?? ?? 77 0A A1 ?? ?? ?? ?? 01 45 FC EB 37 66 3B 05 ?? ?? ?? ?? 72 2E 66 3B 05 ?? ?? ?? ?? 77 25 66 03 05 ?? ?? ?? ?? 66 89 45 FC EB 18 0F B7 45 FC F6 80 ?? ?? ?? ?? 10 74 08 66 0F B6 80 ?? ?? ?? ?? 89 45 FC 66 8B 45 F8 66 39 45 FC 75 15 66 85 C0 74 0A 83 7D 10 00 0F 85 EA FE FF FF 33 C0 5F 5E C9 C3 1B C0 83 E0 02 48 EB F4 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_strcspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 73 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_203_1_0 {
	meta:
		name = "__RTC_GetErrDesc"
		size = 24
		refs = "0010 __RTC_errlist"
	strings:
		$1 = { 8B 44 24 04 85 C0 7C 0D 83 F8 04 7D 08 8B 04 85 ?? ?? ?? ?? C3 33 C0 C3 }
	condition:
		$1
}

rule file_203_2_0 {
	meta:
		name = "__RTC_SetErrorType"
		size = 33
		refs = "0014 ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 8B 44 24 04 85 C0 7C 15 83 F8 04 7D 10 8B 54 24 08 8D 0C 85 ?? ?? ?? ?? 8B 01 89 11 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "?_set_new_mode@@YAHH@Z"
		size = 29
		refs = "0012 __newmode"
	strings:
		$1 = { 8B 4C 24 04 8B C1 83 E0 01 3B C1 74 04 83 C8 FF C3 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__wcsset"
		size = 25
	strings:
		$1 = { 8B 4C 24 04 8B C1 EB 0A 66 8B 54 24 08 66 89 11 41 41 66 83 39 00 75 F0 C3 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "_wscanf"
		size = 23
		refs = "000a __iob 000f __winput"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_557_0_0 {
	meta:
		name = "_scanf"
		size = 23
		refs = "000a __iob 000f __input"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__heapmin"
		size = 68
		refs = "0002 ___active_heap 000a ___sbh_heapmin 0012 __crtheap 0018 __imp__HeapCompact@8 0022 __imp__GetLastError@0 002f __doserrno 0035 _errno"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 03 75 05 E8 ?? ?? ?? ?? 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 21 FF 15 ?? ?? ?? ?? 6A 78 59 3B C1 75 10 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 28 00 00 00 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "__cwait"
		size = 139
		refs = "0017 __imp__WaitForSingleObject@8 0026 __imp__GetExitCodeProcess@8 0034 __imp__GetLastError@0 0043 _errno 004d __doserrno 0057 __dosmaperr 0066 __imp__CloseHandle@4"
	strings:
		$1 = { 55 8B EC 57 8B 7D 0C 83 FF FF 74 6F 83 FF FE 74 6A 56 6A FF 57 FF 15 ?? ?? ?? ?? 85 C0 75 13 8D 45 0C 50 57 FF 15 ?? ?? ?? ?? 85 C0 74 04 8B F7 EB 31 8B 35 ?? ?? ?? ?? FF D6 6A 06 59 3B C1 75 12 C7 05 ?? ?? ?? ?? 0A 00 00 00 89 0D ?? ?? ?? ?? EB 09 FF D6 50 E8 ?? ?? ?? ?? 59 83 CE FF 83 4D 0C FF 57 FF 15 ?? ?? ?? ?? 8B 45 08 85 C0 74 05 8B 4D 0C 89 08 8B C6 5E EB 0D C7 05 ?? ?? ?? ?? 0A 00 00 00 83 C8 FF 5F 5D C3 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__heapwalk"
		size = 280
		refs = "0003 $T19728 0008 __SEH_prolog 002e __crtheap 0034 __imp__HeapWalk@8 0042 __imp__GetLastError@0 004f __doserrno 0055 _errno 007b __imp__HeapValidate@12 0113 __SEH_epilog"
	strings:
		$1 = { 6A 2C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 E0 FE FF FF FF 33 DB 66 89 5D CE 88 5D CD 8B 75 08 8B 06 89 45 C4 3B C3 75 43 8D 45 C4 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 B1 00 00 00 FF 15 ?? ?? ?? ?? 6A 78 59 3B C1 75 17 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 28 00 00 00 6A FB E9 8A 00 00 00 6A FD E9 83 00 00 00 83 7E 08 01 75 18 50 53 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 69 66 C7 45 CE 04 00 89 5D FC 89 5D E4 8D 45 C4 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 07 C7 45 E4 01 00 00 00 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 C7 45 E4 02 00 00 00 83 4D FC FF 33 DB 8B 75 08 83 7D E4 01 75 19 FF 15 ?? ?? ?? ?? 3D 03 01 00 00 74 83 6A 78 59 3B C1 75 0B E9 67 FF FF FF 83 7D E4 02 75 05 6A FC 58 EB 21 F6 45 CE 03 75 92 8B 45 C4 89 06 8B 45 C8 89 46 04 0F B6 45 CE C1 E8 02 83 E0 01 89 46 08 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "__CIasin"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 0048 ___fastflag 004f __fast_exit 005a _NAME_ 005f __math_exit 0080 __piby2 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2B D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0E 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 3A 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 29 81 E1 00 00 00 80 DD D8 DB 2D ?? ?? ?? ?? 74 C0 D9 E0 EB BC E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0E 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "__byteswap_ulong"
		size = 35
	strings:
		$1 = { 8B 4C 24 04 8B C1 25 00 FF 00 00 8B D1 C1 E2 10 03 C2 33 D2 8A 74 24 06 C1 E0 08 C1 E9 18 03 C2 03 C1 C3 }
	condition:
		$1
}

rule file_211_1_0 {
	meta:
		name = "__byteswap_ushort"
		size = 16
	strings:
		$1 = { 66 0F B6 4C 24 05 8B 44 24 04 C1 E0 08 03 C1 C3 }
	condition:
		$1
}

rule file_211_2_0 {
	meta:
		name = "__byteswap_uint64"
		size = 172
		refs = "0023 __allmul"
	strings:
		$1 = { 53 55 56 8B 74 24 14 57 8B 7C 24 14 33 C0 50 68 00 00 01 00 56 8B EF 57 81 E5 00 FF 00 00 89 44 24 24 E8 ?? ?? ?? ?? 03 E8 8B 44 24 14 6A 00 BB 00 00 01 00 53 13 C2 50 55 E8 ?? ?? ?? ?? 8B CF 33 ED 81 E1 00 00 FF 00 55 03 C1 53 13 D5 52 50 E8 ?? ?? ?? ?? 8B CF BB 00 00 00 FF 23 CB 55 03 C1 68 00 01 00 00 13 D5 52 50 E8 ?? ?? ?? ?? 8B CE C1 E9 08 81 E1 00 FF 00 00 03 C1 13 D5 8B CF 8B EE 0F AC E9 08 23 CB 33 DB 03 C1 13 D3 8B CE 0F AC CF 18 81 E7 00 00 FF 00 33 C9 03 C7 13 D1 C1 EE 18 5F 03 C6 5E 5D 13 D1 5B C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "_wcsncat"
		size = 61
	strings:
		$1 = { 55 8B EC 8B 4D 08 8B C1 66 8B 11 41 41 66 85 D2 75 F6 49 49 83 7D 10 00 56 74 1B 8B 75 0C 66 8B 16 FF 4D 10 66 89 11 41 41 46 46 66 85 D2 74 0A 83 7D 10 00 75 E8 66 83 21 00 5E 5D C3 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "__RTC_Initialize"
		size = 68
		refs = "0003 $T18815 0008 __SEH_prolog 000f ___rtc_iaa 0016 ___rtc_izz 003f __SEH_epilog"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 E4 ?? ?? ?? ?? 81 7D E4 ?? ?? ?? ?? 73 22 83 65 FC 00 8B 45 E4 8B 00 85 C0 74 0B FF D0 EB 07 33 C0 40 C3 8B 65 E8 83 4D FC FF 83 45 E4 04 EB D5 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_213_1_0 {
	meta:
		name = "__RTC_Terminate"
		size = 68
		refs = "0003 $T18832 0008 __SEH_prolog 000f ___rtc_taa 0016 ___rtc_tzz 003f __SEH_epilog"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 E4 ?? ?? ?? ?? 81 7D E4 ?? ?? ?? ?? 73 22 83 65 FC 00 8B 45 E4 8B 00 85 C0 74 0B FF D0 EB 07 33 C0 40 C3 8B 65 E8 83 4D FC FF 83 45 E4 04 EB D5 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__flush"
		size = 93
		refs = "002d __write"
	strings:
		$1 = { 53 56 8B 74 24 0C 8B 46 0C 8B C8 80 E1 03 33 DB 80 F9 02 75 3A 66 A9 08 01 74 34 8B 46 08 57 8B 3E 2B F8 85 FF 7E 27 57 50 FF 76 10 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 75 0F 8B 46 0C 84 C0 79 0F 83 E0 FD 89 46 0C EB 07 83 4E 0C 20 83 CB FF 5F 8B 46 08 83 66 04 00 89 06 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_214_1_0 {
	meta:
		name = "_fflush"
		size = 59
		refs = "000b _flsall 0014 __flush 002c __commit"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 75 09 56 E8 ?? ?? ?? ?? 59 5E C3 56 E8 ?? ?? ?? ?? 85 C0 59 74 05 83 C8 FF 5E C3 F6 46 0D 40 74 0F FF 76 10 E8 ?? ?? ?? ?? 59 F7 D8 1B C0 5E C3 33 C0 5E C3 }
	condition:
		$1
}

rule file_214_2_0 {
	meta:
		name = "_flsall"
		size = 109
		refs = "000b __nstream 0012 ___piob 002e _fflush"
	strings:
		$1 = { 53 56 57 33 F6 33 DB 33 FF 39 35 ?? ?? ?? ?? 7E 4D A1 ?? ?? ?? ?? 8B 04 B0 85 C0 74 38 8B 48 0C F6 C1 83 74 30 83 7C 24 10 01 75 0F 50 E8 ?? ?? ?? ?? 83 F8 FF 59 74 1D 43 EB 1A 83 7C 24 10 00 75 13 F6 C1 02 74 0E 50 E8 ?? ?? ?? ?? 83 F8 FF 59 75 02 0B F8 46 3B 35 ?? ?? ?? ?? 7C B3 83 7C 24 10 01 8B C3 74 02 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "__wtol"
		size = 95
		refs = "0015 _iswctype 0047 __wchartodigit"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 EB 02 46 46 33 C0 66 8B 06 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 EB 0F B7 06 46 46 83 F8 2D 89 45 08 74 05 83 F8 2B 75 05 0F B7 06 46 46 33 FF EB 0B 8D 0C BF 8D 3C 48 0F B7 06 46 46 50 E8 ?? ?? ?? ?? 83 F8 FF 59 75 E9 83 7D 08 2D 8B C7 75 02 F7 D8 5F 5E 5D C3 }
	condition:
		$1
}

rule file_215_2_0 {
	meta:
		name = "__wtoi64"
		size = 142
		refs = "0019 _iswctype 004a __allmul 006b __wchartodigit"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 8B 75 08 57 EB 02 46 46 33 C0 66 8B 06 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 EB 0F B7 06 46 46 83 F8 2D 89 45 FC 74 05 83 F8 2B 75 05 0F B7 06 46 46 33 DB 89 5D F8 EB 28 6A 00 6A 0A FF 75 F8 53 E8 ?? ?? ?? ?? 8B C8 8B C2 89 45 08 8B C7 99 03 C8 8B 45 08 13 C2 89 45 F8 0F B7 06 46 8B D9 46 50 E8 ?? ?? ?? ?? 8B F8 83 FF FF 59 75 CA 83 7D FC 2D 8B 55 F8 8B C3 75 07 F7 D8 83 D2 00 F7 DA 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__aullrem"
		size = 117
	strings:
		$1 = { 53 8B 44 24 14 0B C0 75 18 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B 44 24 08 F7 F1 8B C2 33 D2 EB 50 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B C8 F7 64 24 14 91 F7 64 24 10 03 D1 72 0E 3B 54 24 0C 77 08 72 0E 3B 44 24 08 76 08 2B 44 24 10 1B 54 24 14 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 5B C2 10 00 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__strtime"
		size = 103
		refs = "000f __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8D 45 F0 50 FF 15 ?? ?? ?? ?? 0F B7 45 F8 99 6A 0A 5B F7 FB 8B 4D 08 0F B7 75 FA B3 30 6A 0A 0F B7 7D FC C6 41 05 3A C6 41 02 3A C6 41 08 00 02 C3 88 01 02 D3 88 51 01 8B C6 99 5E F7 FE 02 C3 88 41 03 02 D3 88 51 04 8B C7 99 F7 FE 5F 5E 02 C3 02 D3 88 41 06 88 51 07 8B C1 5B C9 C3 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "__wsetlocale"
		size = 228
		refs = "0018 _wcstombs 002a _malloc 005d _free 0069 _setlocale 007e ?outwlocale@?1??_wsetlocale@@9@9 009c _mbstowcs"
	strings:
		$1 = { 53 56 57 33 DB 33 FF 39 5C 24 14 74 56 68 FF FF FF 7F FF 74 24 18 53 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 46 0F 84 AF 00 00 00 56 E8 ?? ?? ?? ?? 85 C0 59 0F 84 A0 00 00 00 56 E8 ?? ?? ?? ?? 8B F8 3B FB 59 0F 84 8F 00 00 00 56 FF 74 24 18 57 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 08 57 E8 ?? ?? ?? ?? EB 73 57 FF 74 24 14 E8 ?? ?? ?? ?? 57 8B F0 E8 ?? ?? ?? ?? 83 C4 0C 3B F3 74 5B 39 1D ?? ?? ?? ?? 75 14 68 A2 06 00 00 E8 ?? ?? ?? ?? 3B C3 59 A3 ?? ?? ?? ?? 74 3F 53 56 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 2F 40 3D 51 03 00 00 77 27 50 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 16 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 59 33 C0 EB 05 A1 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "__fputwchar"
		size = 17
		refs = "0001 __iob 000a _fputwc"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_532_8_0 {
	meta:
		name = "_iswalnum"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 07 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_532_1_0 {
	meta:
		name = "_iswalpha"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 03 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_532_10_0 {
	meta:
		name = "_iswgraph"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 17 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_532_9_0 {
	meta:
		name = "_iswprint"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 57 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_532_5_0 {
	meta:
		name = "_iswxdigit"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 80 00 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "__wfindfirst64"
		size = 260
		refs = "000a ___security_cookie 001e __imp__FindFirstFileW@8 002b __imp__GetLastError@0 0047 _errno 008f ___time64_t_from_ft 00cd __allmul 00ef _wcscpy 00fe @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 89 45 FC 57 8D 85 AC FD FF FF 50 FF 75 08 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 42 FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 28 83 F8 08 74 17 83 F8 12 74 1E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 A2 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EC 89 0D ?? ?? ?? ?? EB E4 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 53 56 8B 75 0C 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 6A 00 6A 00 FF B5 C8 FD FF FF 89 46 18 89 56 1C E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 DB 03 C1 13 D3 89 46 20 8D 85 D8 FD FF FF 89 56 24 50 83 C6 28 56 E8 ?? ?? ?? ?? 59 59 5E 8B C7 5B 8B 4D FC 5F E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_220_1_0 {
	meta:
		name = "__wfindnext64"
		size = 255
		refs = "000a ___security_cookie 001d __imp__FindNextFileW@8 0027 __imp__GetLastError@0 0043 _errno 008b ___time64_t_from_ft 00c9 __allmul 00eb _wcscpy 00f9 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 89 45 FC 8D 85 AC FD FF FF 50 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 42 FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 28 83 F8 08 74 17 83 F8 12 74 1E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 A2 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EC 89 0D ?? ?? ?? ?? EB E4 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 56 8B 75 0C 89 06 8D 85 B0 FD FF FF 57 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 6A 00 6A 00 FF B5 C8 FD FF FF 89 46 18 89 56 1C E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 FF 03 C1 13 D7 89 46 20 8D 85 D8 FD FF FF 89 56 24 50 83 C6 28 56 E8 ?? ?? ?? ?? 59 59 5F 33 C0 5E 8B 4D FC E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__memccpy"
		size = 91
	strings:
		$1 = { 8B 4C 24 10 53 85 C9 74 46 8A 7C 24 10 56 F7 C1 01 00 00 00 8B 44 24 0C 8B 74 24 10 74 13 8A 1E 83 C6 01 88 18 83 C0 01 38 FB 74 2C 83 E9 01 74 1D 8A 1E 83 C6 02 38 FB 74 19 88 18 8A 5E FF 88 58 01 83 C0 02 38 FB 74 0F 83 E9 02 75 E3 5E 33 C0 5B C3 88 18 83 C0 01 5E 5B C3 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "_extend_ioinfo_arrays"
		size = 96
		refs = "0002 __nhandle 000b ___pioinfo 001b _malloc"
	strings:
		$1 = { 3B 1D ?? ?? ?? ?? 56 57 7C 4C BE ?? ?? ?? ?? BF 00 01 00 00 83 3E 00 75 32 57 E8 ?? ?? ?? ?? 85 C0 59 74 37 83 05 ?? ?? ?? ?? 20 89 06 8D 88 00 01 00 00 EB 12 83 08 FF C6 40 04 00 C6 40 05 0A 8B 0E 83 C0 08 03 CF 3B C1 72 EA 83 C6 04 3B 1D ?? ?? ?? ?? 7D BE 33 C0 5F 5E C3 83 C8 FF EB F8 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "__dup2"
		size = 281
		refs = "0008 __nhandle 0022 ___pioinfo 0052 _extend_ioinfo_arrays 005c _errno 0095 __close 009c __imp__GetCurrentProcess@0 00b1 __get_osfhandle 00bc __imp__DuplicateHandle@28 00c6 __imp__GetLastError@0 00d3 __set_osfhnd 00e1 __dosmaperr 0102 __doserrno"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 0D ?? ?? ?? ?? 53 56 8B 75 08 3B F1 57 0F 83 E6 00 00 00 8B C6 C1 F8 05 8D 04 85 ?? ?? ?? ?? 8B FE 83 E7 1F 89 45 F8 8B 00 C1 E7 03 F6 44 38 04 01 0F 84 C2 00 00 00 8B 5D 0C 81 FB 00 08 00 00 0F 83 B3 00 00 00 3B D9 7C 18 E8 ?? ?? ?? ?? 85 C0 74 0F C7 05 ?? ?? ?? ?? 0C 00 00 00 E9 A8 00 00 00 3B F3 0F 84 8B 00 00 00 8B C3 C1 F8 05 8D 04 85 ?? ?? ?? ?? 8B F3 83 E6 1F 89 45 F4 8B 00 C1 E6 03 F6 44 06 04 01 74 09 FF 75 0C E8 ?? ?? ?? ?? 59 8B 1D ?? ?? ?? ?? 6A 02 6A 01 6A 00 8D 45 FC 50 FF D3 50 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF D3 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 0F FF 75 FC FF 75 0C E8 ?? ?? ?? ?? 59 59 33 C0 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 EB 29 8B 45 F8 8B 00 8A 44 38 04 8B 4D F4 8B 09 24 EF 88 44 0E 04 33 C0 EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__wgetenv"
		size = 130
		refs = "0002 ___env_initialized 000a __wenviron 001c __environ 0023 ___mbtow_environ 003f _wcslen 0060 __wcsnicoll"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 5E C3 85 F6 53 57 75 1B 39 35 ?? ?? ?? ?? 74 52 E8 ?? ?? ?? ?? 85 C0 75 49 8B 35 ?? ?? ?? ?? 85 F6 74 3F 8B 5C 24 10 85 DB 74 37 53 E8 ?? ?? ?? ?? 59 8B F8 EB 26 50 E8 ?? ?? ?? ?? 3B C7 59 76 18 8B 06 66 83 3C 78 3D 75 0F 57 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 06 85 C0 75 D4 33 C0 5F 5B 5E C3 8B 06 8D 44 78 02 EB F4 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__getdllprocaddr"
		size = 47
		refs = "0025 __imp__GetProcAddress@8"
	strings:
		$1 = { 55 8B EC 83 7D 0C 00 75 0E 81 7D 10 FF FF 00 00 7F 19 FF 75 10 EB 09 83 7D 10 FF 75 0E FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "_atan"
		size = 63
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_0_0 {
	meta:
		name = "_log"
		size = 63
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_551_0_0 {
	meta:
		name = "_log10"
		size = 63
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_227_2_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_671_2_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_551_2_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_630_2_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_227_3_0 {
	meta:
		name = "__CIatan_default"
		size = 159
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 0038 ___fastflag 003f __fast_exit 004a _NAME_ 004f __math_exit 0054 __convertTOStoQNaN 006c __piby2 0099 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 36 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 E8 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 26 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? A9 00 00 00 80 74 BF D9 E0 EB BB B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__fgetchar"
		size = 35
		refs = "0002 __iob 001d __filbuf"
	strings:
		$1 = { FF 0D ?? ?? ?? ?? 78 0F A1 ?? ?? ?? ?? 0F B6 00 FF 05 ?? ?? ?? ?? C3 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "__mbsncat"
		size = 161
		refs = "0015 ___ismbcodepage 0024 _strncat 0041 __ismbslead 0057 __mbctype 007a __mbsbtype"
	strings:
		$1 = { 55 8B EC 57 8B 7D 10 85 FF 75 08 8B 45 08 E9 8B 00 00 00 83 3D ?? ?? ?? ?? 00 75 11 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 71 56 8B 75 08 89 75 10 8A 06 46 84 C0 75 F9 4E 56 FF 75 10 E8 ?? ?? ?? ?? 85 C0 59 59 74 01 4E 8B 4D 0C 8A 01 0F B6 D0 4F F6 82 ?? ?? ?? ?? 04 88 06 74 2B 46 41 8A 01 88 06 46 41 84 C0 75 25 88 46 FE 8B C6 2B 45 10 48 50 FF 75 10 E8 ?? ?? ?? ?? 83 F8 01 59 59 75 12 C6 46 FF 00 EB 0F 46 41 84 C0 74 DE 85 FF 75 BA EB D8 C6 06 00 8B 45 10 5E 5F 5D C3 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "___wdtoxmode"
		size = 195
		refs = "0059 _wcsrchr 0066 ??_C@_19DOGDICKI@?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 006c __wcsicmp 0077 ??_C@_19BDKLHPGC@?$AA?4?$AAc?$AAm?$AAd?$AA?$AA@ 0088 ??_C@_19PINKOIBI@?$AA?4?$AAb?$AAa?$AAt?$AA?$AA@ 0099 ??_C@_19CDGLJBOD@?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@"
	strings:
		$1 = { 8B 44 24 04 56 8B 74 24 0C 25 FF 00 00 00 66 83 7E 02 3A 57 8B CE 75 03 8D 4E 04 66 8B 11 66 83 FA 5C 74 06 66 83 FA 2F 75 07 66 83 79 02 00 74 0E A8 10 75 0A 66 85 D2 BF 00 80 00 00 75 05 BF 40 40 00 00 C1 E0 07 F6 D0 6A 2E 56 25 80 00 00 00 0D 00 01 00 00 0B F8 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 74 47 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 33 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 22 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 11 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 03 83 CF 40 8B C7 C1 E8 03 83 E0 38 0B F8 8B C7 C1 E8 06 83 E0 07 0B C7 5F 5E C3 }
	condition:
		$1
}

rule file_230_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 139
		refs = "0002 _wcslen"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 83 F8 05 59 72 7C 66 8B 06 66 3D 5C 00 74 06 66 3D 2F 00 75 6D 66 8B 46 02 66 3D 5C 00 74 06 66 3D 2F 00 75 5D 8D 46 06 66 8B 08 33 D2 66 3B CA 74 50 66 83 F9 5C 74 10 66 83 F9 2F 74 0A 40 40 66 8B 08 66 3B CA 75 EA 66 39 10 74 35 83 C0 02 66 39 10 74 2D 66 8B 08 66 3B CA 74 21 66 83 F9 5C 74 10 66 83 F9 2F 74 0A 40 40 66 8B 08 66 3B CA 75 EA 66 39 10 74 06 66 39 50 02 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_230_2_0 {
	meta:
		name = "__wstat"
		size = 753
		refs = "000f ___security_cookie 001b ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0027 _wcspbrk 0035 _errno 003a __doserrno 0075 _towlower 0083 __getdrive 0095 __imp__FindFirstFileW@8 00a8 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00c3 __wfullpath 00d2 _wcslen 00dd _IsRootUNCName 00e8 __imp__GetDriveTypeW@4 011c ___loctotime_t 0156 __imp__FileTimeToLocalFileTime@8 016c __imp__FileTimeToSystemTime@8 0280 __imp__FindClose@4 0291 ___wdtoxmode 02c5 __imp__GetLastError@0 02cb __dosmaperr 02e5 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 04 FC FF FF 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 56 8B B5 04 04 00 00 68 ?? ?? ?? ?? 56 89 85 F8 03 00 00 E8 ?? ?? ?? ?? 85 C0 59 59 74 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 97 02 00 00 57 33 FF 66 83 7E 02 3A 75 32 66 8B 06 66 3B C7 74 1B 66 39 7E 04 75 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 69 02 00 00 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 45 80 53 8D 85 A8 01 00 00 50 56 FF 15 ?? ?? ?? ?? 83 CB FF 3B C3 89 45 8C 0F 85 A2 00 00 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 7F 68 04 01 00 00 8D 45 A0 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 3B F7 74 67 56 E8 ?? ?? ?? ?? 83 F8 03 59 74 09 E8 ?? ?? ?? ?? 85 C0 74 52 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 46 53 57 57 57 6A 01 6A 01 68 BC 07 00 00 C7 85 A8 01 00 00 10 00 00 00 89 BD C4 01 00 00 89 BD C8 01 00 00 66 89 BD D4 01 00 00 E8 ?? ?? ?? ?? 8B B5 08 04 00 00 83 C4 1C 89 46 1C 89 46 18 89 46 20 E9 4D 01 00 00 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 90 01 00 00 8D 45 84 50 8D 85 BC 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 61 01 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 4B 01 00 00 0F B7 45 9C 53 50 0F B7 45 9A 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 8B B5 08 04 00 00 83 C4 1C 39 BD B4 01 00 00 89 46 1C 75 08 39 BD B8 01 00 00 74 56 8D 45 84 50 8D 85 B4 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F2 00 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 DC 00 00 00 0F B7 45 9C 53 50 0F B7 45 9A 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 83 C4 1C 39 BD AC 01 00 00 89 46 18 75 0D 39 BD B0 01 00 00 75 05 8B 46 1C EB 52 8D 45 84 50 8D 85 AC 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 84 00 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 74 72 0F B7 45 9C 53 50 0F B7 45 9A 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 83 C4 1C FF 75 8C 89 46 20 FF 15 ?? ?? ?? ?? FF B5 04 04 00 00 FF B5 A8 01 00 00 E8 ?? ?? ?? ?? 66 89 46 06 8B 85 C8 01 00 00 89 46 14 8B 45 80 48 59 89 06 89 46 10 59 66 C7 46 08 01 00 66 89 7E 04 66 89 7E 0C 66 89 7E 0A 33 C0 EB 18 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF 75 8C FF 15 ?? ?? ?? ?? 8B C3 5B 5F 8B 8D F8 03 00 00 5E E8 ?? ?? ?? ?? 81 C5 FC 03 00 00 C9 C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__mbsnbcat"
		size = 184
		refs = "0018 ___ismbcodepage 0026 _strncat 004c __mbsbtype 0063 __mbctype"
	strings:
		$1 = { 55 8B EC 53 57 8B 7D 10 33 DB 3B FB 75 08 8B 45 08 E9 9E 00 00 00 39 1D ?? ?? ?? ?? 75 14 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 82 00 00 00 56 8B 75 08 89 75 10 8A 06 46 84 C0 75 F9 4E 8B C6 2B 45 10 48 50 FF 75 10 E8 ?? ?? ?? ?? 83 F8 01 59 59 75 01 4E 8B 4D 0C 8A 01 0F B6 D0 4F F6 82 ?? ?? ?? ?? 04 88 06 74 31 46 41 8B C7 4F 85 C0 74 34 8A 01 88 06 46 41 3A C3 75 24 88 5E FE 8B C6 2B 45 10 48 50 FF 75 10 E8 ?? ?? ?? ?? 83 F8 01 59 59 75 16 88 5E FF EB 13 46 41 3A C3 74 DF 3B FB 75 B4 EB D9 88 5E FF EB D4 88 1E 8B 45 10 5E 5F 5B 5D C3 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__wstrtime"
		size = 119
		refs = "000f __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8D 45 F0 50 FF 15 ?? ?? ?? ?? 0F B7 45 F8 99 6A 0A 5B F7 FB 8B 4D 08 0F B7 75 FA 53 0F B7 7D FC 66 83 61 10 00 66 C7 41 0A 3A 00 66 C7 41 04 3A 00 83 C0 30 66 89 01 83 C2 30 66 89 51 02 8B C6 99 5E F7 FE 53 5E 83 C0 30 66 89 41 06 83 C2 30 66 89 51 08 8B C7 99 F7 FE 5F 5E 5B 83 C0 30 83 C2 30 66 89 41 0C 66 89 51 0E 8B C1 C9 C3 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "__strerror"
		size = 118
		refs = "000a ?bldmsg@?1??_strerror@@9@9 0023 __mbsnbcat 0028 ??_C@_02LMMGGCAJ@?3?5?$AA@ 002e _strcat 0036 _errno 003e __sys_nerr 004c _strlen 005b __sys_errlist 0061 _strncat 0066 ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 8B 44 24 04 85 C0 56 57 C6 05 ?? ?? ?? ?? 00 BE ?? ?? ?? ?? 74 1F 80 38 00 74 1A 68 82 00 00 00 50 56 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 14 A1 ?? ?? ?? ?? 85 C0 8B 3D ?? ?? ?? ?? 7C 06 3B C7 7D 02 8B F8 56 E8 ?? ?? ?? ?? B9 84 00 00 00 2B C8 51 FF 34 BD ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 18 5F 5E C3 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__rt_probe_read4@4"
		size = 66
		refs = "0003 $T19196 0008 __SEH_prolog 003b __SEH_epilog"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 8B 45 08 8B 00 33 C0 40 89 45 E4 EB 19 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 33 C0 83 4D FC FF E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "___time64_t_from_ft"
		size = 102
		refs = "001b __imp__FileTimeToLocalFileTime@8 002d __imp__FileTimeToSystemTime@8 0056 ___loctotime64_t"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 83 38 00 75 06 83 78 04 00 74 4B 8D 4D F8 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 3C 8D 45 E8 50 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 74 2A 0F B7 45 F4 6A FF 50 0F B7 45 F2 50 0F B7 45 F0 50 0F B7 45 EE 50 0F B7 45 EA 50 0F B7 45 E8 50 E8 ?? ?? ?? ?? 83 C4 1C C9 C3 83 CA FF 8B C2 C9 C3 }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "__findfirst64"
		size = 256
		refs = "000f ___security_cookie 0026 __imp__FindFirstFileA@8 0033 __imp__GetLastError@0 004f _errno 0091 ___time64_t_from_ft 00c6 __allmul 00e2 _strcpy 00f4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 3C FF FF FF 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 89 85 C0 00 00 00 57 8D 45 80 50 FF B5 CC 00 00 00 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 42 FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 28 83 F8 08 74 17 83 F8 12 74 1E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 8D 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EC 89 0D ?? ?? ?? ?? EB E4 8B 45 80 2D 80 00 00 00 F7 D8 1B C0 23 45 80 53 56 8B B5 D0 00 00 00 89 06 8D 45 84 50 E8 ?? ?? ?? ?? 89 46 08 8D 45 8C 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 45 94 50 89 56 14 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 6A 00 6A 00 FF 75 9C 89 46 18 89 56 1C E8 ?? ?? ?? ?? 8B 4D A0 33 DB 03 C1 13 D3 89 46 20 8D 45 AC 89 56 24 50 83 C6 28 56 E8 ?? ?? ?? ?? 59 59 5E 8B C7 5B 8B 8D C0 00 00 00 5F E8 ?? ?? ?? ?? 81 C5 C4 00 00 00 C9 C3 }
	condition:
		$1
}

rule file_236_2_0 {
	meta:
		name = "__findnext64"
		size = 251
		refs = "000f ___security_cookie 0025 __imp__FindNextFileA@8 002f __imp__GetLastError@0 004b _errno 008d ___time64_t_from_ft 00c2 __allmul 00de _strcpy 00ef @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 3C FF FF FF 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 89 85 C0 00 00 00 8D 45 80 50 FF B5 CC 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 42 FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 28 83 F8 08 74 17 83 F8 12 74 1E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 8D 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EC 89 0D ?? ?? ?? ?? EB E4 8B 45 80 2D 80 00 00 00 F7 D8 1B C0 23 45 80 56 8B B5 D0 00 00 00 89 06 8D 45 84 57 50 E8 ?? ?? ?? ?? 89 46 08 8D 45 8C 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 45 94 50 89 56 14 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 6A 00 6A 00 FF 75 9C 89 46 18 89 56 1C E8 ?? ?? ?? ?? 8B 4D A0 33 FF 03 C1 13 D7 89 46 20 8D 45 AC 89 56 24 50 83 C6 28 56 E8 ?? ?? ?? ?? 59 59 5F 33 C0 5E 8B 8D C0 00 00 00 E8 ?? ?? ?? ?? 81 C5 C4 00 00 00 C9 C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__strlwr"
		size = 251
		refs = "0003 $T19488 0008 __SEH_prolog 0012 ___lc_handle 0046 ___lc_codepage 0058 ___crtLCMapStringA 0074 __alloca_probe 008a __resetstkoflw 009e _malloc 00dd _strcpy 00ea _free 00f6 __SEH_epilog"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 A1 ?? ?? ?? ?? 3B C3 75 28 8B 45 08 8B D0 38 18 0F 84 CB 00 00 00 8A 0A 80 F9 41 7C 0A 80 F9 5A 7F 05 80 C1 20 88 0A 42 38 1A 75 EA E9 B0 00 00 00 6A 01 FF 35 ?? ?? ?? ?? 53 53 6A FF FF 75 08 68 00 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 E4 3B C3 0F 84 85 00 00 00 89 5D FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B F4 89 75 DC EB 10 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 33 F6 83 4D FC FF 3B F3 75 16 FF 75 E4 E8 ?? ?? ?? ?? 59 8B F0 C7 45 E0 01 00 00 00 3B F3 74 33 6A 01 FF 35 ?? ?? ?? ?? FF 75 E4 56 6A FF FF 75 08 68 00 01 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 0B 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 39 5D E0 74 07 56 E8 ?? ?? ?? ?? 59 8B 45 08 8D 65 D0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsA"
		size = 290
		refs = "0003 ?f_use@?1??__crtGetEnvironmentStringsA@@9@9 000d __imp__GetEnvironmentStringsW@0 0032 __imp__GetLastError@0 0071 __imp__WideCharToMultiByte@32 0090 _malloc 00b3 _free 00c3 __imp__FreeEnvironmentStringsW@4 00d9 __imp__GetEnvironmentStrings@0 010b _memcpy 0115 __imp__FreeEnvironmentStringsA@4"
	strings:
		$1 = { 51 51 A1 ?? ?? ?? ?? 53 55 56 57 8B 3D ?? ?? ?? ?? 33 DB 33 F6 3B C3 6A 02 5D 75 2D FF D7 8B F0 3B F3 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 1E FF 15 ?? ?? ?? ?? 83 F8 78 75 09 8B C5 A3 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 83 F8 01 75 7D 3B F3 75 08 FF D7 8B F0 3B F3 74 79 66 39 1E 8B C6 74 0E 03 C5 66 39 18 75 F9 03 C5 66 39 18 75 F2 8B 3D ?? ?? ?? ?? 53 53 53 2B C6 53 D1 F8 40 50 56 53 53 89 44 24 34 FF D7 8B E8 3B EB 74 32 55 E8 ?? ?? ?? ?? 3B C3 59 89 44 24 10 74 23 53 53 55 50 FF 74 24 24 56 53 53 FF D7 85 C0 75 0E FF 74 24 10 E8 ?? ?? ?? ?? 59 89 5C 24 10 8B 5C 24 10 56 FF 15 ?? ?? ?? ?? 8B C3 EB 50 3B C5 74 08 3B C3 74 04 33 C0 EB 44 FF 15 ?? ?? ?? ?? 8B F0 3B F3 74 F0 38 1E 74 0A 40 38 18 75 FB 40 38 18 75 F6 2B C6 40 8B E8 55 E8 ?? ?? ?? ?? 8B F8 3B FB 59 75 04 33 FF EB 0B 55 56 57 E8 ?? ?? ?? ?? 83 C4 0C 56 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5D 5B 59 59 C3 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "__trandisp1"
		size = 103
		refs = "0029 XAMtoTagTab"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 9B 8A 8D 61 FF FF FF D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 }
	condition:
		$1
}

rule file_239_1_0 {
	meta:
		name = "__trandisp2"
		size = 140
		refs = "0029 XAMtoTagTab"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 D9 C9 8A 8D 61 FF FF FF D9 E5 9B DD BD 60 FF FF FF D9 C9 8A AD 61 FF FF FF D0 E5 D0 FD D0 C5 8A C5 24 0F D7 8A E0 D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 D0 E4 D0 E4 0A C4 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 }
	condition:
		$1
}

rule file_239_2_0 {
	meta:
		name = "_$$$00003"
		size = 215
		refs = "0045 One 00b9 __indefinite"
	strings:
		$1 = { E8 C1 00 00 00 D9 C9 DD D8 C3 E8 B7 00 00 00 EB F6 DD D8 DD D8 D9 EE C3 DD D8 DD D8 D9 E8 C3 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 08 C6 85 70 FF FF FF 07 C3 C6 85 70 FF FF FF 01 DC 05 ?? ?? ?? ?? C3 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 07 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 20 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 07 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 DD D8 DD D8 DB 2D ?? ?? ?? ?? 80 BD 70 FF FF FF 00 7F 07 C6 85 70 FF FF FF 01 0A C9 C3 0A C9 74 02 D9 E0 C3 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "_ungetwc"
		size = 268
		refs = "0007 ___security_cookie 0036 __getbuf 0057 ___pioinfo 0064 ___badioinfo 0074 _wctomb 0081 _errno 0094 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 53 8B 5D 08 66 81 FB FF FF 56 89 45 FC 57 74 6E 8B 75 0C 8B 46 0C A8 01 75 08 84 C0 79 60 A8 02 75 5C 33 FF 39 7E 08 75 07 56 E8 ?? ?? ?? ?? 59 8B 4E 0C 83 E1 40 0F 85 81 00 00 00 8B 46 10 83 F8 FF 74 14 8B D0 C1 FA 05 8B 14 95 ?? ?? ?? ?? 83 E0 1F 8D 04 C2 EB 05 B8 ?? ?? ?? ?? F6 40 04 80 74 5A 8D 45 F4 53 50 E8 ?? ?? ?? ?? 83 F8 FF 59 59 75 1B C7 05 ?? ?? ?? ?? 2A 00 00 00 66 0D FF FF 8B 4D FC 5F 5E 5B E8 ?? ?? ?? ?? C9 C3 8B 4E 08 03 C8 39 0E 73 0C 39 7E 04 75 E1 3B 46 18 7F DC 89 0E 8D 48 FF 3B CF 7C 0D FF 0E 49 8A 54 0D F5 8B 3E 88 17 79 F3 01 46 04 EB 33 8B 46 08 83 C0 02 39 06 73 0D 39 7E 04 75 B2 83 7E 18 02 72 AC 89 06 83 06 FE 3B CF 8B 06 74 0C 66 39 18 74 0A 83 C0 02 89 06 EB 95 66 89 18 83 46 04 02 8B 46 0C 83 E0 EF 83 C8 01 89 46 0C 66 8B C3 EB 81 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "_vfprintf"
		size = 49
		refs = "0009 __stbuf 0019 __output 0024 __ftbuf"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 08 E8 ?? ?? ?? ?? FF 75 10 8B F0 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 08 8B F8 56 E8 ?? ?? ?? ?? 83 C4 18 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_578_0_0 {
	meta:
		name = "_vfwprintf"
		size = 49
		refs = "0009 __stbuf 0019 __woutput 0024 __ftbuf"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 08 E8 ?? ?? ?? ?? FF 75 10 8B F0 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 08 8B F8 56 E8 ?? ?? ?? ?? 83 C4 18 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "__CIcos"
		size = 174
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003c ___fastflag 0043 __fast_exit 004e _NAME_ 0053 __math_exit 0059 __pi_by_2_to_61 006e __convertTOStoQNaN 0086 __indefinite 00a8 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 50 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FF 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FF EB CD E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "__CIlog10_pentium4"
		size = 656
		refs = "0039 emask 0041 CC 0049 One 0051 Magic 0059 hi_mask 0077 CB_Tbl 007f T_Tbl 00e1 coeff 010d LOG10_2 0119 place_L 0180 Zero 01cf Infs 01fa Two52 024b ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 BE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E9 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 08 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 17 FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 09 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E9 03 00 00 EB A6 8D A4 24 00 00 00 00 05 00 00 00 00 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "___dtold"
		size = 186
	strings:
		$1 = { 55 8B EC 51 8B 55 0C 33 C0 66 8B 42 06 53 56 57 BF FF 07 00 00 BE 00 00 00 80 89 75 FC 8B C8 C1 E9 04 25 00 80 00 00 23 CF 89 45 0C 8B 42 04 8B 12 0F B7 D9 25 FF FF 0F 00 85 DB 74 13 3B DF 74 08 8D B9 00 3C 00 00 EB 28 BF FF 7F 00 00 EB 21 33 DB 3B C3 75 12 3B D3 75 0E 8B 45 08 89 58 04 89 18 66 89 58 08 EB 4D 8D B9 01 3C 00 00 89 5D FC 8B CA C1 E9 15 C1 E0 0B 0B C8 0B 4D FC 8B 45 08 C1 E2 0B 85 CE 89 48 04 89 10 75 1F 8B 08 8B 50 04 8B D9 D1 E2 C1 EB 1F 0B D3 03 C9 81 C7 FF FF 00 00 85 D6 89 50 04 89 08 74 E1 8B 4D 0C 0B CF 66 89 48 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_244_1_0 {
	meta:
		name = "__fltout"
		size = 116
		refs = "0007 ___security_cookie 0019 ___dtold 0020 _fos 0035 _$I10_OUTPUT 003d _ret 006c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 89 45 FC 56 57 8D 45 08 50 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 68 ?? ?? ?? ?? 6A 00 6A 11 83 EC 0C 8D 75 F0 8B FC A5 A5 66 A5 E8 ?? ?? ?? ?? 8B 4D FC A3 ?? ?? ?? ?? 0F BE 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 0F BF 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C4 18 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E C9 C3 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_wparse_cmdline"
		size = 369
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 0C 56 57 8B 7D 10 33 F6 39 75 08 89 37 C7 03 01 00 00 00 74 09 8B 4D 08 83 45 08 04 89 11 3B D6 74 08 66 8B 08 66 89 0A 42 42 FF 07 6A 22 59 66 39 08 75 10 33 DB 85 F6 0F 94 C3 40 40 8B F3 8B 5D 0C EB 18 FF 07 85 D2 74 08 66 8B 08 66 89 0A 42 42 66 8B 08 40 40 66 85 C9 74 3B 85 F6 75 CC 66 83 F9 20 74 06 66 83 F9 09 75 C0 85 D2 74 05 66 83 62 FE 00 83 65 FC 00 33 F6 66 39 30 0F 84 D6 00 00 00 66 8B 08 66 83 F9 20 74 06 66 83 F9 09 75 08 40 40 EB ED 48 48 EB DA 66 39 30 0F 84 B6 00 00 00 39 75 08 74 09 8B 4D 08 83 45 08 04 89 11 FF 03 3B D6 74 08 66 8B 08 66 89 0A 42 42 FF 07 33 F6 46 33 DB EB 03 40 40 43 66 83 38 5C 74 F7 66 83 38 22 75 2A F6 C3 01 75 23 83 7D FC 00 74 0D 8D 48 02 66 83 39 22 75 04 8B C1 EB 02 33 F6 8B 7D 10 33 C9 39 4D FC 0F 94 C1 89 4D FC D1 EB 85 DB 74 10 85 D2 74 07 66 C7 02 5C 00 42 42 FF 07 4B 75 F0 66 8B 08 66 85 C9 74 28 83 7D FC 00 75 0C 66 83 F9 20 74 1C 66 83 F9 09 74 16 85 F6 74 0B 85 D2 74 05 66 89 0A 42 42 FF 07 40 40 E9 7C FF FF FF 85 D2 74 06 66 83 22 00 42 42 FF 07 8B 5D 0C E9 1F FF FF FF 8B 45 08 3B C6 74 02 89 30 FF 03 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "___wsetargv"
		size = 159
		refs = "000e ?_pgmname@?1??__wsetargv@@9@9 001f __imp__GetModuleFileNameW@12 0024 __wcmdln 002c __wpgmptr 0049 _wparse_cmdline 005a _malloc 0087 ___argc 008d ___wargv 0092 __wcwild"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 68 04 01 00 00 BE ?? ?? ?? ?? 33 FF 56 57 66 89 3D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B C7 89 35 ?? ?? ?? ?? 74 07 66 39 38 8B D8 75 02 8B DE 8D 45 F8 50 8D 45 FC 50 57 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 7D FC 8B 45 F8 8D 04 78 D1 E0 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 85 F6 75 05 83 C8 FF EB 2E 8D 45 F8 50 8D 45 FC 50 8D 14 BE 56 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 0C 48 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? F7 D8 1B C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "__ismbcupper"
		size = 126
		refs = "0023 ___ismbcodepage 0039 ___mblcid 0042 ___mbcodepage 0050 ___crtGetStringTypeA 006f __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5E 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 75 04 33 C0 C9 C3 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 D6 66 83 7D FE 00 75 CF F6 45 FC 01 74 C9 33 C0 40 C9 C3 8A 81 ?? ?? ?? ?? 24 10 2C 10 F6 D8 1B C0 40 C9 C3 }
	condition:
		$1
}

rule file_248_3_0 {
	meta:
		name = "_mainCRTStartup"
		size = 455
		refs = "0003 $T20505 0008 __SEH_prolog 0014 __alloca_probe 0022 __imp__GetVersionExA@4 002b __osplatform 0033 __winmajor 003c __winminor 004b __osver 0066 __winver 006f __imp__GetModuleHandleA@4 00c7 __heap_init 00d2 ___error_mode 00da __FF_MSGBANNER 00e1 __NMSG_WRITE 00eb ___crtExitProcess 00f2 __RTC_Initialize 00fa __ioinit 0105 __amsg_exit 010c __imp__GetCommandLineA@0 0111 __acmdln 0116 ___crtGetEnvironmentStringsA 011b __aenvptr 0120 __setargv 0131 __setenvp 0144 __cinit 0158 __environ 015d ___initenv 0164 ___argv 016a ___argc 016f _main 0182 _exit 0187 __cexit 019a __XcptFilter 01af __exit 01b4 __c_exit 01c2 __SEH_epilog"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 89 65 E8 8B F4 89 3E 56 FF 15 ?? ?? ?? ?? 8B 4E 10 89 0D ?? ?? ?? ?? 8B 46 04 A3 ?? ?? ?? ?? 8B 56 08 89 15 ?? ?? ?? ?? 8B 76 0C 81 E6 FF 7F 00 00 89 35 ?? ?? ?? ?? 83 F9 02 74 0C 81 CE 00 80 00 00 89 35 ?? ?? ?? ?? C1 E0 08 03 C2 A3 ?? ?? ?? ?? 33 FF 57 FF 15 ?? ?? ?? ?? 66 81 38 4D 5A 75 1F 8B 48 3C 03 C8 81 39 50 45 00 00 75 12 0F B7 41 18 3D 0B 01 00 00 74 1F 3D 0B 02 00 00 74 05 89 7D E4 EB 27 83 B9 84 00 00 00 0E 76 F2 33 C0 39 B9 F8 00 00 00 EB 0E 83 79 74 0E 76 E2 33 C0 39 B9 E8 00 00 00 0F 95 C0 89 45 E4 57 E8 ?? ?? ?? ?? 59 85 C0 75 21 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? 6A 1C E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 89 7D FC E8 ?? ?? ?? ?? 85 C0 7D 08 6A 1B E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 89 45 DC 3B C7 74 07 50 E8 ?? ?? ?? ?? 59 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 50 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B F0 89 75 D8 39 7D E4 75 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2B 8B 45 EC 8B 08 8B 09 89 4D E0 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 75 E0 83 7D E4 00 75 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D FC FF 8B C6 8D 65 CC E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "_vsprintf"
		size = 87
		refs = "002a __output 004b __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 8B 75 08 57 FF 75 10 8D 45 E0 FF 75 0C C7 45 E4 FF FF FF 7F 50 C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 E8 ?? ?? ?? ?? 83 C4 0C 85 F6 8B F8 74 1A FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E C9 C3 }
	condition:
		$1
}

rule file_249_1_0 {
	meta:
		name = "__vscprintf"
		size = 48
		refs = "0027 __output"
	strings:
		$1 = { 55 8B EC 83 EC 20 FF 75 0C 83 65 E8 00 FF 75 08 83 65 E0 00 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_500_1_0 {
	meta:
		name = "__vscwprintf"
		size = 48
		refs = "0027 __woutput"
	strings:
		$1 = { 55 8B EC 83 EC 20 FF 75 0C 83 65 E8 00 FF 75 08 83 65 E0 00 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "?terminate@@YAXXZ"
		size = 45
		refs = "0003 $T18705 0008 __SEH_prolog 000d ?__pTerminate@@3P6AXXZA 0029 _abort"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 13 83 65 FC 00 FF D0 EB 07 33 C0 40 C3 8B 65 E8 83 4D FC FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_2_0 {
	meta:
		name = "?_inconsistency@@YAXXZ"
		size = 45
		refs = "0003 $T18727 0008 __SEH_prolog 000d ?__pInconsistency@@3P6AXXZA 0029 ?terminate@@YAXXZ"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 13 83 65 FC 00 FF D0 EB 07 33 C0 40 C3 8B 65 E8 83 4D FC FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "?unexpected@@YAXXZ"
		size = 16
		refs = "0001 ?__pUnexpected@@3P6AXXZA 000c ?terminate@@YAXXZ"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 02 FF D0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "__ceil_pentium4"
		size = 221
		refs = "000a _Bns 0023 _S 0076 ___libm_error_support 00a7 _One 00bc _NegZero 00c5 _Zero"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 F8 66 0F 73 D0 34 66 0F 7E C0 66 0F 54 05 ?? ?? ?? ?? 66 0F FA D0 66 0F D3 CA A9 00 08 00 00 74 4C 3D FF 0B 00 00 7C 7D 66 0F F3 CA 3D 32 0C 00 00 7F 0B 66 0F D6 4C 24 04 DD 44 24 04 C3 66 0F 2E FF 7B 24 BA EC 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 F3 0F 7E 44 24 04 66 0F F3 CA 66 0F 28 D8 66 0F C2 C1 06 3D FF 03 00 00 7C 25 3D 32 04 00 00 7F B0 66 0F 54 05 ?? ?? ?? ?? F2 0F 58 C8 66 0F D6 4C 24 04 DD 44 24 04 C3 DD 05 ?? ?? ?? ?? C3 66 0F C2 1D ?? ?? ?? ?? 06 66 0F 54 1D ?? ?? ?? ?? 66 0F D6 5C 24 04 DD 44 24 04 C3 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "_free"
		size = 56
		refs = "000b ___active_heap 0014 ___sbh_find_block 0020 ___sbh_free_block 002c __crtheap 0032 __imp__HeapFree@12"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 2D 83 3D ?? ?? ?? ?? 03 56 75 15 E8 ?? ?? ?? ?? 85 C0 59 56 74 0A 50 E8 ?? ?? ?? ?? 59 59 5E C3 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "__setenvp"
		size = 199
		refs = "0005 ___mbctype_initialized 000e ___initmbctable 0014 __aenvptr 0027 _strlen 003f _malloc 004a __environ 007d _strcpy 0093 _free 00a1 ___env_initialized"
	strings:
		$1 = { 53 33 DB 39 1D ?? ?? ?? ?? 56 57 75 05 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 33 FF 3B F3 75 12 EB 30 3C 3D 74 01 47 56 E8 ?? ?? ?? ?? 59 8D 74 06 01 8A 06 3A C3 75 EA 8D 04 BD 04 00 00 00 50 E8 ?? ?? ?? ?? 8B F8 3B FB 59 89 3D ?? ?? ?? ?? 75 05 83 C8 FF EB 58 8B 35 ?? ?? ?? ?? 55 EB 2A 56 E8 ?? ?? ?? ?? 8B E8 45 80 3E 3D 59 74 19 55 E8 ?? ?? ?? ?? 3B C3 59 89 07 74 37 56 50 E8 ?? ?? ?? ?? 59 59 83 C7 04 03 F5 38 1E 75 D2 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 1F C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 59 5D 5F 5E 5B C3 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__lfind"
		size = 50
	strings:
		$1 = { 55 8B EC 53 56 8B 75 10 57 33 FF 39 3E 76 18 8B 5D 0C 53 FF 75 08 FF 55 18 85 C0 59 59 74 0F 03 5D 14 47 3B 3E 72 EB 33 C0 5F 5E 5B 5D C3 8B C3 EB F7 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__futime"
		size = 324
		refs = "0013 _time 0026 _localtime 0031 _errno 007b __imp__SystemTimeToFileTime@8 009f __imp__LocalFileTimeToFileTime@8 011f __get_osfhandle 0127 __imp__SetFileTime@16"
	strings:
		$1 = { 55 8B EC 83 EC 30 57 8B 7D 0C 85 FF 75 13 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 59 89 45 F8 8D 7D F8 8D 47 04 50 E8 ?? ?? ?? ?? 85 C0 59 75 12 C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 00 01 00 00 66 8B 48 14 66 81 C1 6C 07 66 89 4D D0 66 8B 48 10 66 41 66 89 4D D2 66 8B 48 0C 66 89 4D D6 66 8B 48 08 66 89 4D D8 66 8B 48 04 66 89 4D DA 66 8B 00 66 83 65 DE 00 56 8B 35 ?? ?? ?? ?? 66 89 45 DC 8D 45 F0 50 8D 45 D0 50 FF D6 85 C0 0F 84 9E 00 00 00 8D 45 E8 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 88 00 00 00 57 E8 ?? ?? ?? ?? 85 C0 59 74 7D 66 8B 48 14 66 81 C1 6C 07 66 89 4D D0 66 8B 48 10 66 41 66 89 4D D2 66 8B 48 0C 66 89 4D D6 66 8B 48 08 66 89 4D D8 66 8B 48 04 66 89 4D DA 66 8B 00 66 83 65 DE 00 66 89 45 DC 8D 45 F0 50 8D 45 D0 50 FF D6 85 C0 74 34 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 74 22 8D 45 E8 50 8D 45 E0 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 0D C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF 5E 5F C9 C3 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "___ascii_strnicmp"
		size = 97
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 4D 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 0A E4 8A 07 74 27 0A C0 74 23 83 C6 01 83 C7 01 38 FC 72 06 38 DC 77 02 02 E6 38 F8 72 06 38 D8 77 02 02 C6 38 C4 75 0B 83 E9 01 75 D1 33 C9 38 C4 74 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_258_2_0 {
	meta:
		name = "__ctrlfp"
		size = 36
	strings:
		$1 = { 55 8B EC 51 9B D9 7D FC 8B 45 0C 8B 4D 08 23 4D 0C F7 D0 23 45 FC 0B C1 89 45 0C D9 6D 0C 0F BF 45 FC C9 C3 }
	condition:
		$1
}

rule file_258_3_0 {
	meta:
		name = "__set_statfp"
		size = 86
		refs = "000d _over 0032 _under"
	strings:
		$1 = { 51 51 8A 4C 24 0C F6 C1 01 74 0B DB 2D ?? ?? ?? ?? DB 5C 24 0C 9B F6 C1 08 74 10 9B DF E0 DB 2D ?? ?? ?? ?? DD 1C 24 9B 9B DF E0 F6 C1 10 74 0A DB 2D ?? ?? ?? ?? DD 1C 24 9B F6 C1 04 74 09 D9 EE D9 E8 DE F1 DD D8 9B F6 C1 20 74 06 D9 EB DD 1C 24 9B 59 59 C3 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 52
		refs = "0001 __ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z 0006 __EH_prolog 001a ??2@YAPAXI@Z 002d __except_list"
	strings:
		$1 = { B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 51 51 83 65 FC 00 53 56 57 89 65 F0 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 EC 8B 4D F4 8B 45 EC 5F 5E 64 89 0D ?? ?? ?? ?? 5B C9 C3 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "__getws"
		size = 61
		refs = "000a __iob 001e _fgetwc"
	strings:
		$1 = { 53 8B 5C 24 08 56 57 8B F3 BF ?? ?? ?? ?? EB 0C 3D FF FF 00 00 74 1E 66 89 06 46 46 57 E8 ?? ?? ?? ?? 0F B7 C0 83 F8 0A 59 75 E5 66 83 26 00 5F 5E 8B C3 5B C3 3B F3 75 F2 33 DB EB F2 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "__snscanf"
		size = 49
		refs = "0028 __input"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 89 45 E8 89 45 E0 8B 45 0C 89 45 E4 8D 45 14 50 FF 75 10 8D 45 E0 50 C7 45 EC 49 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "_frexp"
		size = 172
		refs = "0011 __ctrlfp 0035 __sptype 0055 __handle_qnan1 0060 __d_ind 006b __real@3ff0000000000000 0082 __except1 0094 __decomp"
	strings:
		$1 = { 55 8B EC 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? DD 45 08 8B F8 8B 45 0E 66 25 F0 7F 66 3D F0 7F 59 59 75 62 8B 45 10 83 08 FF 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 7E 27 83 F8 02 7E 1A 83 F8 03 75 1D DD 45 08 57 51 51 DD 1C 24 6A 17 E8 ?? ?? ?? ?? 83 C4 10 EB 4A DD 05 ?? ?? ?? ?? EB 09 DD 45 08 DC 05 ?? ?? ?? ?? 57 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 1D FF 75 10 51 51 DD 1C 24 E8 ?? ?? ?? ?? 56 DD 5D 08 57 E8 ?? ?? ?? ?? DD 45 08 83 C4 14 5F 5E 5D C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "__localtime64"
		size = 526
		refs = "003b ___tzset 0053 __timezone 0067 __gmtime64 006d __daylight 007c __isindst 008a __dstbias 0114 __allrem 0135 __alldiv"
	strings:
		$1 = { 55 8B EC 51 51 53 57 8B 7D 08 8B 4F 04 8B 07 33 DB 3B CB 0F 8C EF 01 00 00 7F 08 3B C3 0F 82 E5 01 00 00 81 F9 00 10 00 00 0F 8F D9 01 00 00 7C 08 3B C3 0F 87 CF 01 00 00 56 E8 ?? ?? ?? ?? 8B 4F 04 3B CB 8B 37 7C 65 7F 08 81 FE 80 F4 03 00 76 5B A1 ?? ?? ?? ?? 99 2B F0 8D 45 F8 1B CA 50 89 75 F8 89 4D FC E8 ?? ?? ?? ?? 39 1D ?? ?? ?? ?? 59 8B F0 0F 84 89 01 00 00 56 E8 ?? ?? ?? ?? 85 C0 59 0F 84 7A 01 00 00 A1 ?? ?? ?? ?? 99 29 45 F8 8D 45 F8 50 19 55 FC E8 ?? ?? ?? ?? 8B F0 59 C7 46 20 01 00 00 00 E9 56 01 00 00 57 E8 ?? ?? ?? ?? 39 1D ?? ?? ?? ?? 59 8B F0 74 39 56 E8 ?? ?? ?? ?? 85 C0 59 74 2E 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 03 C1 99 8B C8 8B 06 8B FA 99 2B C1 1B D7 89 45 F8 89 55 FC C7 46 20 01 00 00 00 8B 7D FC 8B 4D F8 EB 17 8B 06 99 8B C8 A1 ?? ?? ?? ?? 8B FA 99 2B C8 1B FA 89 4D F8 89 7D FC 53 6A 3C 57 51 E8 ?? ?? ?? ?? 3B C3 89 06 7D 0D 83 C0 3C 89 06 83 45 F8 C4 83 55 FC FF 53 6A 3C FF 75 FC FF 75 F8 E8 ?? ?? ?? ?? 8B C8 8B 46 04 8B FA 99 03 C8 53 13 FA 6A 3C 57 51 89 4D F8 89 7D FC E8 ?? ?? ?? ?? 3B C3 89 46 04 7D 0E 83 C0 3C 89 46 04 83 45 F8 C4 83 55 FC FF 53 6A 3C FF 75 FC FF 75 F8 E8 ?? ?? ?? ?? 8B C8 8B 46 08 8B FA 99 03 C8 53 13 FA 6A 18 57 51 89 4D F8 89 7D FC E8 ?? ?? ?? ?? 3B C3 89 46 08 7D 0E 83 C0 18 89 46 08 83 45 F8 E8 83 55 FC FF 53 6A 18 FF 75 FC FF 75 F8 E8 ?? ?? ?? ?? 3B D3 89 45 F8 89 55 FC 7F 42 7C 04 3B C3 73 3C 8B 4E 18 8D 44 01 07 99 6A 07 59 F7 F9 89 56 18 8B 45 F8 01 46 0C 8B 46 0C 3B C3 7F 19 83 C0 1F FF 4E 14 89 46 0C C7 46 1C 6C 01 00 00 C7 46 10 0B 00 00 00 EB 06 8B 45 F8 01 46 1C 8B C6 5E EB 02 33 C0 5F 5B C9 C3 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "_strncpy"
		size = 292
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 0F 84 92 00 00 00 56 53 8B D9 8B 74 24 14 F7 C6 03 00 00 00 8B 7C 24 10 75 0B C1 E9 02 0F 85 85 00 00 00 EB 27 8A 06 83 C6 01 88 07 83 C7 01 83 E9 01 74 2B 84 C0 74 2F F7 C6 03 00 00 00 75 E5 8B D9 C1 E9 02 75 61 83 E3 03 74 13 8A 06 83 C6 01 88 07 83 C7 01 84 C0 74 37 83 EB 01 75 ED 8B 44 24 10 5B 5E 5F C3 F7 C7 03 00 00 00 74 16 88 07 83 C7 01 83 E9 01 0F 84 98 00 00 00 F7 C7 03 00 00 00 75 EA 8B D9 C1 E9 02 75 74 88 07 83 C7 01 83 EB 01 75 F6 5B 5E 8B 44 24 08 5F C3 89 17 83 C7 04 83 E9 01 74 9F BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DC 84 D2 74 2C 84 F6 74 1E F7 C2 00 00 FF 00 74 0C F7 C2 00 00 00 FF 75 C4 89 17 EB 18 81 E2 FF FF 00 00 89 17 EB 0E 81 E2 FF 00 00 00 89 17 EB 04 33 D2 89 17 83 C7 04 33 C0 83 E9 01 74 0C 33 C0 89 07 83 C7 04 83 E9 01 75 F6 83 E3 03 0F 85 77 FF FF FF 8B 44 24 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "__commit"
		size = 87
		refs = "0006 __nhandle 0014 ___pioinfo 0026 __get_osfhandle 002e __imp__FlushFileBuffers@4 0038 __imp__GetLastError@0 0045 __doserrno 004b _errno"
	strings:
		$1 = { 8B 44 24 04 3B 05 ?? ?? ?? ?? 73 3D 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 8B D0 83 E2 1F F6 44 D1 04 01 74 25 50 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 12 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF C3 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "__heap_alloc"
		size = 70
		refs = "0002 ___active_heap 0010 ___sbh_threshold 0018 ___sbh_alloc_block 003a __crtheap 0040 __imp__HeapAlloc@12"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 03 56 8B 74 24 08 75 13 3B 35 ?? ?? ?? ?? 77 0B 56 E8 ?? ?? ?? ?? 85 C0 59 75 23 85 F6 75 01 46 83 3D ?? ?? ?? ?? 01 74 06 83 C6 0F 83 E6 F0 56 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_266_1_0 {
	meta:
		name = "__nh_malloc"
		size = 44
		refs = "000c __heap_alloc 0020 __callnewh"
	strings:
		$1 = { 83 7C 24 04 E0 77 22 FF 74 24 04 E8 ?? ?? ?? ?? 85 C0 59 75 16 39 44 24 08 74 10 FF 74 24 04 E8 ?? ?? ?? ?? 85 C0 59 75 DE 33 C0 C3 }
	condition:
		$1
}

rule file_266_2_0 {
	meta:
		name = "_malloc"
		size = 18
		refs = "0002 __newmode 000b __nh_malloc"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "__wspawnl"
		size = 24
		refs = "0010 __wspawnve"
	strings:
		$1 = { 6A 00 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_563_0_0 {
	meta:
		name = "__spawnl"
		size = 24
		refs = "0010 __spawnve"
	strings:
		$1 = { 6A 00 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "_perror"
		size = 108
		refs = "0010 _strlen 0019 __write 0020 ??_C@_02LMMGGCAJ@?3?5?$AA@ 002f _errno 0037 __sys_nerr 0046 __sys_errlist 005c ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 25 80 3E 00 74 20 56 E8 ?? ?? ?? ?? 50 56 6A 02 E8 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 1C A1 ?? ?? ?? ?? 85 C0 8B 0D ?? ?? ?? ?? 7C 04 3B C1 7C 02 8B C1 8B 34 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 50 56 6A 02 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 1C 5E C3 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "??_L@YGXPAXIHP6EX0@Z1@Z"
		size = 98
		refs = "0003 $T327 0008 __SEH_prolog 0043 __SEH_epilog 005d ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 45 E0 89 45 FC 89 45 E4 8B 45 E4 3B 45 10 7D 13 8B 75 08 8B CE FF 55 14 03 75 0C 89 75 08 FF 45 E4 EB E5 C7 45 E0 01 00 00 00 83 4D FC FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 14 00 83 7D E0 00 75 11 FF 75 18 FF 75 E4 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__CxxThrowException@8"
		size = 58
		refs = "000f ?ExceptionTemplate@?1??_CxxThrowException@@9@8@4UEHExceptionRecord@@B 0030 __imp__RaiseException@16"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 56 57 6A 08 59 BE ?? ?? ?? ?? 8D 7D E0 F3 A5 89 45 F8 8B 45 0C 89 45 FC 8D 45 F4 50 FF 75 F0 FF 75 E4 FF 75 E0 FF 15 ?? ?? ?? ?? 5F 5E C9 C2 08 00 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "__forcdecpt"
		size = 88
		refs = "000a _tolower 0017 ___mb_cur_max 0025 __isctype 002f __pctype 0042 ___decimal_point"
	strings:
		$1 = { 56 8B 74 24 08 0F BE 06 50 E8 ?? ?? ?? ?? 83 F8 65 59 74 2A 46 83 3D ?? ?? ?? ?? 01 0F BE 06 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 75 D6 8A 06 8A 0D ?? ?? ?? ?? 88 0E 46 8A 0E 88 06 8A C1 8A 0E 46 84 C9 75 F3 5E C3 }
	condition:
		$1
}

rule file_272_1_0 {
	meta:
		name = "__cropzeros"
		size = 75
		refs = "0007 ___decimal_point"
	strings:
		$1 = { 8B 44 24 04 53 8A 1D ?? ?? ?? ?? EB 05 3A CB 74 07 40 8A 08 84 C9 75 F5 8A 08 40 84 C9 74 2A EB 0B 80 F9 65 74 0C 80 F9 45 74 07 40 8A 08 84 C9 75 EF 8B D0 48 80 38 30 74 FA 38 18 75 01 48 8A 0A 40 42 84 C9 88 08 75 F6 5B C3 }
	condition:
		$1
}

rule file_272_2_0 {
	meta:
		name = "__positive"
		size = 26
		refs = "0008 __real@0000000000000000"
	strings:
		$1 = { 8B 44 24 04 DD 00 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_272_3_0 {
	meta:
		name = "__fassign"
		size = 62
		refs = "0013 __atodbl 002e __atoflt"
	strings:
		$1 = { 55 8B EC 51 51 83 7D 08 00 FF 75 10 74 1B 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 0C 59 59 8B 4D F8 89 08 8B 4D FC 89 48 04 C9 C3 8D 45 08 50 E8 ?? ?? ?? ?? 8B 45 0C 59 59 8B 4D 08 89 08 C9 C3 }
	condition:
		$1
}

rule file_272_4_0 {
	meta:
		name = "__shift"
		size = 29
		refs = "0009 _strlen 0014 _memmove"
	strings:
		$1 = { 85 FF 56 8B F0 74 14 56 E8 ?? ?? ?? ?? 40 50 56 03 F7 56 E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_272_5_0 {
	meta:
		name = "__cftoe"
		size = 241
		refs = "0005 _g_fmt 0013 _g_pflt 0030 __shift 003f __fltout 0063 __fptostr 0083 ___decimal_point 0094 ??_C@_05KLBDPFGC@e?$CL000?$AA@ 00a1 _strcpy"
	strings:
		$1 = { 55 8B EC 80 3D ?? ?? ?? ?? 00 53 56 57 74 27 8B 5D 10 A1 ?? ?? ?? ?? 33 C9 85 DB 0F 9F C1 33 D2 83 38 2D 8B F0 0F 94 C2 8B F9 03 55 0C 8B C2 E8 ?? ?? ?? ?? EB 34 8B 45 08 FF 70 04 FF 30 E8 ?? ?? ?? ?? 8B 5D 10 8B F0 56 8D 43 01 50 33 C0 83 3E 2D 0F 94 C0 33 C9 85 DB 0F 9F C1 03 45 0C 03 C8 51 E8 ?? ?? ?? ?? 83 C4 14 83 3E 2D 8B 45 0C 75 04 C6 00 2D 40 85 DB 7E 11 8D 78 01 8A 0F 88 08 8A 0D ?? ?? ?? ?? 8B C7 88 08 33 C9 38 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 0F 94 C1 03 C8 03 CB 51 E8 ?? ?? ?? ?? 83 7D 14 00 59 59 8B C8 74 03 C6 01 45 8B 46 0C 41 80 38 30 74 2E 8B 46 04 48 79 05 F7 D8 C6 01 2D 41 83 F8 64 7C 0A 99 6A 64 5E F7 FE 00 01 8B C2 41 83 F8 0A 7C 0A 99 6A 0A 5E F7 FE 00 01 8B C2 00 41 01 8B 45 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_272_6_0 {
	meta:
		name = "__cftoe_g"
		size = 39
		refs = "0006 _g_fmt 0018 __cftoe"
	strings:
		$1 = { FF 74 24 10 C6 05 ?? ?? ?? ?? 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C6 05 ?? ?? ?? ?? 00 C3 }
	condition:
		$1
}

rule file_272_7_0 {
	meta:
		name = "__cftof"
		size = 221
		refs = "0002 _g_fmt 0012 _g_magnitude 001c _g_pflt 0043 __fltout 005e __fptostr 007f __shift 009b ___decimal_point 00cf _memset"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 53 8B 5C 24 0C 55 56 57 74 28 A1 ?? ?? ?? ?? 3B 44 24 1C 8B 35 ?? ?? ?? ?? 75 43 33 C9 83 3E 2D 0F 94 C1 03 C8 03 CB 8B C1 C6 00 30 C6 40 01 00 EB 2C 8B 44 24 14 FF 70 04 FF 30 E8 ?? ?? ?? ?? 8B F0 8B 46 04 03 44 24 24 56 50 33 C0 83 3E 2D 0F 94 C0 03 C3 50 E8 ?? ?? ?? ?? 83 C4 14 83 3E 2D 8B EB 75 06 C6 03 2D 8D 6B 01 8B 46 04 33 FF 47 85 C0 7F 0E 8B C5 E8 ?? ?? ?? ?? C6 45 00 30 45 EB 02 03 E8 83 7C 24 1C 00 7E 43 8B C5 E8 ?? ?? ?? ?? A0 ?? ?? ?? ?? 88 45 00 8B 76 04 45 85 F6 7D 2C F7 DE 80 3D ?? ?? ?? ?? 00 75 06 39 74 24 1C 7C 04 89 74 24 1C 8B 7C 24 1C 8B C5 E8 ?? ?? ?? ?? 57 6A 30 55 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5D 8B C3 5B C3 }
	condition:
		$1
}

rule file_272_8_0 {
	meta:
		name = "__cftof_g"
		size = 35
		refs = "0006 _g_fmt 0014 __cftof"
	strings:
		$1 = { FF 74 24 0C C6 05 ?? ?? ?? ?? 01 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C6 05 ?? ?? ?? ?? 00 C3 }
	condition:
		$1
}

rule file_272_9_0 {
	meta:
		name = "__cftog"
		size = 170
		refs = "000f __fltout 001c _g_magnitude 002b _g_pflt 0036 __fptostr 0059 _g_round_expansion 0077 _g_fmt 007e __cftof 0097 __cftoe"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 57 FF 76 04 FF 36 E8 ?? ?? ?? ?? 8B 48 04 8B 5D 10 49 89 0D ?? ?? ?? ?? 33 C9 83 38 2D 50 0F 94 C1 53 A3 ?? ?? ?? ?? 03 4D 0C 8B F9 57 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 40 04 83 C4 14 48 39 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 0F 9C C1 83 F8 FC 88 0D ?? ?? ?? ?? 7C 28 3B C3 7D 24 84 C9 74 0A 8A 07 47 84 C0 75 F9 88 47 FE 53 FF 75 0C C6 05 ?? ?? ?? ?? 01 56 E8 ?? ?? ?? ?? 83 C4 0C EB 17 FF 75 14 C6 05 ?? ?? ?? ?? 01 53 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 5F 5E C6 05 ?? ?? ?? ?? 00 5B 5D C3 }
	condition:
		$1
}

rule file_272_10_0 {
	meta:
		name = "__cfltcvt"
		size = 81
		refs = "001f __cftof 0035 __cftog 0048 __cftoe"
	strings:
		$1 = { 55 8B EC 83 7D 10 65 74 32 83 7D 10 45 74 2C 83 7D 10 66 75 13 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? EB 11 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "_strncat"
		size = 309
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 0F 84 B7 00 00 00 8B 7C 24 08 56 F7 C7 03 00 00 00 53 74 11 8A 07 83 C7 01 84 C0 74 39 F7 C7 03 00 00 00 75 EF 8B 07 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C7 04 A9 00 01 01 81 74 E8 8B 47 FC 84 C0 74 21 84 E4 74 18 A9 00 00 FF 00 74 0C A9 00 00 00 FF 75 CF 83 EF 01 EB 0D 83 EF 02 EB 08 83 EF 03 EB 03 83 EF 04 8B 74 24 14 F7 C6 03 00 00 00 75 09 8B D9 C1 E9 02 75 5C EB 22 8A 16 83 C6 01 84 D2 74 3D 88 17 83 C7 01 83 E9 01 74 29 F7 C6 03 00 00 00 75 E5 8B D9 C1 E9 02 75 38 8B CB 83 E1 03 74 13 8A 16 83 C6 01 88 17 83 C7 01 84 D2 74 07 83 E9 01 75 ED 88 0F 5B 5E 8B 44 24 08 5F C3 88 17 8B 44 24 10 5B 5E 5F C3 89 17 83 C7 04 83 E9 01 74 C8 BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DC 84 D2 74 CE 84 F6 74 2A F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 75 C4 89 17 8B 44 24 10 5B 5E 5F C3 66 89 17 33 D2 8B 44 24 10 88 57 02 5B 5E 5F C3 66 89 17 8B 44 24 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "_xtoa"
		size = 62
	strings:
		$1 = { 83 7C 24 08 00 74 06 C6 01 2D 41 F7 D8 56 8B F1 33 D2 F7 74 24 08 83 FA 09 76 05 80 C2 57 EB 03 80 C2 30 88 11 41 85 C0 77 E6 C6 01 00 49 8A 16 8A 01 88 11 49 88 06 46 3B F1 72 F2 5E C3 }
	condition:
		$1
}

rule file_276_1_0 {
	meta:
		name = "__itoa"
		size = 42
		refs = "001f _xtoa"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 8B 45 08 75 0A 85 C0 7D 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 0C 59 59 5D C3 }
	condition:
		$1
}

rule file_276_2_0 {
	meta:
		name = "__ltoa"
		size = 39
		refs = "001c _xtoa"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 10 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 10 8B 45 08 E8 ?? ?? ?? ?? 8B 45 0C 59 59 5D C3 }
	condition:
		$1
}

rule file_276_3_0 {
	meta:
		name = "__ultoa"
		size = 26
		refs = "000f _xtoa"
	strings:
		$1 = { 8B 4C 24 08 8B 44 24 04 6A 00 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 10 59 59 C3 }
	condition:
		$1
}

rule file_276_4_0 {
	meta:
		name = "_x64toa@20"
		size = 109
		refs = "002f __aulldvrm"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 08 56 33 C9 39 4D 14 8B F0 8B 45 0C 57 74 0A C6 06 2D 46 F7 DB 13 C1 F7 D8 8B FE 89 4D 0C FF 75 0C FF 75 10 50 53 E8 ?? ?? ?? ?? 83 F9 09 89 5D FC 8B D8 8B C2 76 05 80 C1 57 EB 03 80 C1 30 88 0E 46 85 C0 77 D8 72 04 85 DB 77 D2 C6 06 00 4E 8A 0F 8A 06 88 0E 4E 88 07 47 3B FE 72 F2 5F 5E 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_276_5_0 {
	meta:
		name = "__i64toa"
		size = 49
		refs = "0028 _x64toa@20"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 14 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 50 FF 75 14 8B 45 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_276_6_0 {
	meta:
		name = "__ui64toa"
		size = 27
		refs = "0012 _x64toa@20"
	strings:
		$1 = { 55 8B EC 8B 45 10 6A 00 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__validdrive"
		size = 55
		refs = "0021 __imp__GetDriveTypeA@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 24 04 40 88 45 08 8D 45 08 50 C6 45 09 3A C6 45 0A 5C C6 45 0B 00 FF 15 ?? ?? ?? ?? 85 C0 74 0A 83 F8 01 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "__getdcwd"
		size = 231
		refs = "000a ___security_cookie 001b __validdrive 0026 __doserrno 0030 _errno 003f @__security_check_cookie@4 0070 __imp__GetFullPathNameA@16 0084 __imp__GetCurrentDirectoryA@8 00a5 _malloc 00dc _strcpy"
	strings:
		$1 = { 55 8B EC 81 EC 0C 01 00 00 A1 ?? ?? ?? ?? 53 8B 5D 08 85 DB 89 45 FC 74 5D 53 E8 ?? ?? ?? ?? 85 C0 59 75 21 C7 05 ?? ?? ?? ?? 0F 00 00 00 C7 05 ?? ?? ?? ?? 0D 00 00 00 33 C0 8B 4D FC 5B E8 ?? ?? ?? ?? C9 C3 8D 85 F4 FE FF FF 50 8D 85 F8 FE FF FF 50 68 04 01 00 00 8D 45 08 80 C3 40 50 88 5D 08 C6 45 09 3A C6 45 0A 2E C6 45 0B 00 FF 15 ?? ?? ?? ?? EB 12 8D 85 F8 FE FF FF 50 68 04 01 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 AC 40 3D 04 01 00 00 77 A4 8B 4D 0C 85 C9 75 24 3B 45 10 7F 03 8B 45 10 50 E8 ?? ?? ?? ?? 59 8B C8 85 C9 75 23 C7 05 ?? ?? ?? ?? 0C 00 00 00 E9 79 FF FF FF 3B 45 10 7E 0F C7 05 ?? ?? ?? ?? 22 00 00 00 E9 65 FF FF FF 8D 85 F8 FE FF FF 50 51 E8 ?? ?? ?? ?? 59 59 E9 53 FF FF FF }
	condition:
		$1
}

rule file_277_2_0 {
	meta:
		name = "__getcwd"
		size = 19
		refs = "000b __getdcwd"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 6A 00 E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_508_1_0 {
	meta:
		name = "__wgetcwd"
		size = 19
		refs = "000b __wgetdcwd"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 6A 00 E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__except_handler2"
		size = 174
		refs = "0057 __global_unwind2 0064 __local_unwind2"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 75 77 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 14 8B 73 0C 8B 7B 08 83 FE FF 74 56 8D 0C 76 83 7C 8F 04 00 74 3A 56 55 8B 6B 10 FF 54 8F 04 5D 5E 8B 5D 0C 0B C0 74 28 78 31 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8B 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 8B 04 8F 89 43 0C FF 54 8F 08 8B 7B 08 8D 0C 76 8B 34 8F EB AC B8 00 00 00 00 EB 1C B8 01 00 00 00 EB 15 55 8B 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "__umask"
		size = 22
		refs = "0005 __umaskval"
	strings:
		$1 = { 8B 4C 24 04 A1 ?? ?? ?? ?? 81 E1 80 01 00 00 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "_mbtowc"
		size = 200
		refs = "002b ___lc_handle 0046 __pctype 0055 ___mb_cur_max 0075 ___lc_codepage 007b __imp__MultiByteToWideChar@24 0094 _errno"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 0C 33 DB 3B F3 74 15 39 5D 10 74 10 8A 06 3A C3 75 10 8B 45 08 3B C3 74 03 66 89 18 33 C0 5E 5B 5D C3 39 1D ?? ?? ?? ?? 75 13 8B 4D 08 3B CB 74 07 66 0F B6 C0 66 89 01 33 C0 40 EB E1 8B 0D ?? ?? ?? ?? 0F B6 C0 F6 44 41 01 80 74 4D A1 ?? ?? ?? ?? 83 F8 01 7E 2A 39 45 10 7C 28 33 C9 39 5D 08 0F 95 C1 51 FF 75 08 50 56 6A 09 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 A1 ?? ?? ?? ?? 75 9D 39 45 10 72 05 38 5E 01 75 93 C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF EB 84 33 C0 39 5D 08 0F 95 C0 50 FF 75 08 6A 01 56 6A 09 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 79 FF FF FF EB CA }
	condition:
		$1
}

rule file_281_1_0 {
	meta:
		name = "__wexecve"
		size = 317
		refs = "0011 _wcsrchr 002e _wcschr 003c _wcslen 0046 _malloc 0053 ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 0059 _wcscpy 0060 _wcscat 008c __waccess 00a3 _wcomexecmd 00e3 _ext_strings 0122 _free"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 08 56 57 6A 5C 53 8B FB E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 46 85 F6 75 4C 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 75 3C 53 E8 ?? ?? ?? ?? 8D 44 00 06 50 E8 ?? ?? ?? ?? 8B F8 85 FF 59 59 74 75 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 53 57 E8 ?? ?? ?? ?? 83 C4 10 8D 77 04 EB 0A 85 F6 74 04 3B C6 76 02 8B F0 83 4D FC FF 6A 2E 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 27 6A 00 57 E8 ?? ?? ?? ?? 83 F8 FF 59 59 0F 84 8F 00 00 00 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC EB 7B 57 E8 ?? ?? ?? ?? 8D 44 00 0A 50 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 75 05 83 C8 FF EB 6C 57 56 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8D 04 46 83 C4 0C 89 45 F8 BB ?? ?? ?? ?? FF 33 FF 75 F8 E8 ?? ?? ?? ?? 6A 00 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 0D 83 EB 04 81 FB ?? ?? ?? ?? 7D DB EB 12 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 56 E8 ?? ?? ?? ?? 8B 5D 08 59 3B FB 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "_DllMain@12"
		size = 32
		refs = "0009 __pRawDllMain 0016 __imp__DisableThreadLibraryCalls@4"
	strings:
		$1 = { 83 7C 24 08 01 75 13 83 3D ?? ?? ?? ?? 00 75 0A FF 74 24 04 FF 15 ?? ?? ?? ?? 33 C0 40 C2 0C 00 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "__wcsdup"
		size = 46
		refs = "000b _wcslen 0015 _malloc 0022 _wcscpy"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 21 56 E8 ?? ?? ?? ?? 8D 44 00 02 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 0B 56 50 E8 ?? ?? ?? ?? 59 59 5E C3 33 C0 5E C3 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__snprintf"
		size = 87
		refs = "002a __output 004b __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 0C 56 8B 75 08 89 45 E4 57 8D 45 14 50 FF 75 10 8D 45 E0 50 C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 E8 ?? ?? ?? ?? 83 C4 0C 85 F6 8B F8 74 1A FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E C9 C3 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "__ismbchira"
		size = 39
		refs = "0002 ___mbcodepage"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 75 18 81 7C 24 04 9F 82 00 00 72 0E 81 7C 24 04 F1 82 00 00 77 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_286_1_0 {
	meta:
		name = "__ismbckata"
		size = 44
		refs = "0002 ___mbcodepage"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 75 1D 8B 44 24 04 3D 40 83 00 00 72 12 3D 96 83 00 00 77 0B 3D 7F 83 00 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_286_2_0 {
	meta:
		name = "__ismbcsymbol"
		size = 44
		refs = "0002 ___mbcodepage"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 75 1D 8B 44 24 04 3D 41 81 00 00 72 12 3D AC 81 00 00 77 0B 3D 7F 81 00 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "_strncmp"
		size = 57
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 E3 27 8B D9 8B 7D 08 8B F7 33 C0 F2 AE F7 D9 03 CB 8B FE 8B 75 0C F3 A6 8A 46 FF 33 C9 3A 47 FF 77 05 74 05 83 E9 02 F7 D1 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__CallSettingFrame@12"
		size = 76
		refs = "001f __NLG_Notify1"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 51 8B 45 0C 83 C0 0C 89 45 FC 8B 45 08 55 FF 75 10 8B 4D 10 8B 6D FC E8 ?? ?? ?? ?? 56 57 FF D0 5F 5E 8B DD 5D 8B 4D 10 55 8B EB 81 F9 00 01 00 00 75 05 B9 02 00 00 00 51 E8 ?? ?? ?? ?? 5D 59 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__wcserror"
		size = 47
		refs = "0007 __sys_nerr 0019 __sys_errlist 001e ?errmsg@?1??_wcserror@@9@9 0024 _mbstowcs"
	strings:
		$1 = { 8B 4C 24 04 85 C9 A1 ?? ?? ?? ?? 7C 06 3B C8 7D 02 8B C1 56 6A 28 FF 34 85 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 5E C3 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__wincmdln"
		size = 93
		refs = "0006 ___mbctype_initialized 000d ___initmbctable 0013 __acmdln 001c ??_C@_00CNPNBAHC@?$AA@ 0040 __ismbblead"
	strings:
		$1 = { 56 57 33 FF 39 3D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 85 F6 75 05 BE ?? ?? ?? ?? 8A 06 3C 20 77 08 84 C0 74 2E 85 FF 74 24 3C 22 75 09 33 C9 85 FF 0F 94 C1 8B F9 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 74 01 46 46 EB D3 3C 20 77 07 46 8A 06 84 C0 75 F5 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__lrotr"
		size = 29
		altNames = "__rotr"
	strings:
		$1 = { 83 64 24 08 1F 8B 54 24 04 6A 20 59 2B 4C 24 08 8B C2 D3 E0 8B 4C 24 08 D3 EA 0B C2 C3 }
	condition:
		$1
}

rule file_292_2_0 {
	meta:
		name = "__rotr64"
		size = 56
		refs = "0016 __allshl 0028 __aullshr"
	strings:
		$1 = { 55 8B EC 83 65 10 3F 8B 45 08 8B 55 0C 56 57 6A 40 59 2B 4D 10 E8 ?? ?? ?? ?? 8B 4D 10 8B F0 8B 45 08 8B FA 8B 55 0C E8 ?? ?? ?? ?? 0B F0 0B FA 8B D7 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_485_2_0 {
	meta:
		name = "__rotl64"
		size = 56
		refs = "0016 __aullshr 0028 __allshl"
	strings:
		$1 = { 55 8B EC 83 65 10 3F 8B 45 08 8B 55 0C 56 57 6A 40 59 2B 4D 10 E8 ?? ?? ?? ?? 8B 4D 10 8B F0 8B 45 08 8B FA 8B 55 0C E8 ?? ?? ?? ?? 0B F0 0B FA 8B D7 5F 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "__dup"
		size = 207
		refs = "000b __nhandle 001d ___pioinfo 0034 __alloc_osfhnd 0042 _errno 004f __imp__GetCurrentProcess@0 0062 __get_osfhandle 006d __imp__DuplicateHandle@28 0078 __imp__GetLastError@0 0085 __set_osfhnd 0093 __dosmaperr 00c3 __doserrno"
	strings:
		$1 = { 55 8B EC 51 53 57 8B 7D 08 3B 3D ?? ?? ?? ?? 0F 83 A2 00 00 00 8B C7 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B CF 83 E1 1F 8A 5C C8 04 F6 C3 01 0F 84 84 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 89 45 08 75 0C C7 05 ?? ?? ?? ?? 18 00 00 00 EB 75 56 8B 35 ?? ?? ?? ?? 6A 02 6A 01 6A 00 8D 45 FC 50 FF D6 50 57 E8 ?? ?? ?? ?? 59 50 FF D6 50 FF 15 ?? ?? ?? ?? 85 C0 5E 75 08 FF 15 ?? ?? ?? ?? EB 0F FF 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 59 33 C0 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 EB 2E 8B 45 08 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 80 E3 EF 8B D0 83 E2 1F 88 5C D1 04 EB 14 C7 05 ?? ?? ?? ?? 09 00 00 00 83 25 ?? ?? ?? ?? 00 83 C8 FF 5F 5B C9 C3 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__mbsspn"
		size = 119
		refs = "0008 ___ismbcodepage 0011 _strspn 002e __mbctype"
	strings:
		$1 = { 55 8B EC 53 33 DB 39 1D ?? ?? ?? ?? 75 07 5B 5D E9 ?? ?? ?? ?? 8B 45 08 38 18 74 55 56 8B 75 0C 57 38 1E 8B CE 74 2E 8A 11 0F B6 FA F6 87 ?? ?? ?? ?? 04 74 17 3A 10 75 08 8A 51 01 3A 50 01 74 14 8D 51 01 38 1A 74 0D 8B CA EB 04 3A 10 74 05 41 38 19 75 D2 38 19 74 16 0F B6 08 F6 81 ?? ?? ?? ?? 04 74 05 40 38 18 74 05 40 38 18 75 B2 5F 5E 2B 45 08 5B 5D C3 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__splitpath"
		size = 328
		refs = "0011 _strlen 002d __mbsnbcpy 0060 __mbctype"
	strings:
		$1 = { 55 8B EC 51 51 83 65 FC 00 53 8B 5D 08 56 57 53 E8 ?? ?? ?? ?? 83 F8 01 59 72 21 80 7B 01 3A 75 1B 8B 75 0C 85 F6 74 10 6A 02 53 56 E8 ?? ?? ?? ?? 83 C4 0C C6 46 02 00 43 43 EB 0A 8B 45 0C 85 C0 74 03 C6 00 00 83 65 08 00 80 3B 00 8B C3 89 45 F8 BE FF 00 00 00 74 65 8A 08 0F B6 D1 F6 82 ?? ?? ?? ?? 04 74 03 40 EB 1A 80 F9 2F 74 0F 80 F9 5C 74 0A 80 F9 2E 75 0B 89 45 FC EB 06 8D 48 01 89 4D 08 40 80 38 00 75 CF 8B 7D 08 85 FF 89 45 F8 74 2A 83 7D 10 00 74 1F 2B FB 3B FE 72 02 8B FE 57 53 FF 75 10 E8 ?? ?? ?? ?? 8B 45 10 C6 04 07 00 8B 45 F8 83 C4 0C 8B 5D 08 EB 0A 8B 4D 10 85 C9 74 03 C6 01 00 8B 7D FC 85 FF 74 4C 3B FB 72 48 83 7D 14 00 74 1F 2B FB 3B FE 72 02 8B FE 57 53 FF 75 14 E8 ?? ?? ?? ?? 8B 45 14 C6 04 07 00 8B 45 F8 83 C4 0C 8B 7D 18 85 FF 74 44 2B 45 FC 3B C6 73 02 8B F0 56 FF 75 FC 57 E8 ?? ?? ?? ?? 83 C4 0C C6 04 3E 00 EB 28 8B 7D 14 85 FF 74 17 2B C3 3B C6 73 02 8B F0 56 53 57 E8 ?? ?? ?? ?? 83 C4 0C C6 04 3E 00 8B 45 18 85 C0 74 03 C6 00 00 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__wgetpath"
		size = 137
	strings:
		$1 = { 55 8B EC 8B 4D 08 56 57 6A 02 5F EB 02 03 CF 66 83 39 3B 74 F8 FF 4D 10 8B 75 0C 8B C1 74 5A EB 46 66 83 FA 3B 74 4A 03 CF 66 83 FA 22 74 0E 66 89 16 03 F7 FF 4D 10 75 2E 8B C1 EB 3C 66 8B 11 66 85 D2 74 2E 66 83 FA 22 74 14 66 89 16 03 F7 03 CF FF 4D 10 74 E2 66 8B 11 66 85 D2 75 E6 66 83 39 00 74 0E 03 CF 66 8B 11 66 85 D2 75 B2 EB 02 03 CF 66 83 39 3B 74 F8 66 83 26 00 2B C1 F7 D8 1B C0 5F 23 C1 5E 5D C3 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "_exp"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __exp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 6E 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 41 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_298_2_0 {
	meta:
		name = "__CIexp"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIexp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 3C 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 0F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "_abort"
		size = 24
		refs = "0003 __NMSG_WRITE 000a _raise 0013 __exit"
	strings:
		$1 = { 6A 0A E8 ?? ?? ?? ?? 6A 16 E8 ?? ?? ?? ?? 59 59 6A 03 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "_wfindenv"
		size = 81
		refs = "0003 __wenviron 0010 __wcsnicoll"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? EB 26 57 50 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 11 8B 06 66 8B 04 78 66 3D 3D 00 74 1D 66 85 C0 74 18 83 C6 04 8B 06 85 C0 75 D4 8B C6 2B 05 ?? ?? ?? ?? 5E C1 F8 02 F7 D8 C3 8B C6 2B 05 ?? ?? ?? ?? 5E C1 F8 02 C3 }
	condition:
		$1
}

rule file_302_1_0 {
	meta:
		name = "_copy_environ"
		size = 97
		refs = "0027 _malloc 0038 __amsg_exit 0045 __wcsdup"
	strings:
		$1 = { 55 8B EC 51 33 C9 85 FF 8B C7 75 02 C9 C3 83 3F 00 74 09 83 C0 04 41 83 38 00 75 F7 53 8D 04 8D 04 00 00 00 56 50 E8 ?? ?? ?? ?? 8B F0 85 F6 59 89 75 FC 75 08 6A 09 E8 ?? ?? ?? ?? 59 8B 07 8B DF EB 11 50 E8 ?? ?? ?? ?? 89 06 83 C6 04 83 C3 04 8B 03 59 85 C0 75 EB 21 06 8B 45 FC 5E 5B C9 C3 }
	condition:
		$1
}

rule file_342_1_0 {
	meta:
		name = "_copy_environ"
		size = 97
		refs = "0027 _malloc 0038 __amsg_exit 0045 __strdup"
	strings:
		$1 = { 55 8B EC 51 33 C9 85 FF 8B C7 75 02 C9 C3 83 3F 00 74 09 83 C0 04 41 83 38 00 75 F7 53 8D 04 8D 04 00 00 00 56 50 E8 ?? ?? ?? ?? 8B F0 85 F6 59 89 75 FC 75 08 6A 09 E8 ?? ?? ?? ?? 59 8B 07 8B DF EB 11 50 E8 ?? ?? ?? ?? 89 06 83 C6 04 83 C3 04 8B 03 59 85 C0 75 EB 21 06 8B 45 FC 5E 5B C9 C3 }
	condition:
		$1
}

rule file_302_2_0 {
	meta:
		name = "___crtwsetenv"
		size = 716
		refs = "0027 _wcschr 0044 __wenviron 004a ___winitenv 0053 _copy_environ 0067 __environ 0072 ___mbtow_environ 0092 _malloc 00d0 _wfindenv 00e8 _free 0118 _realloc 0172 _wcslen 0194 _wcscpy 01a6 ?f_use@?1??__crtwsetenv@@9@9 01bd __imp__SetEnvironmentVariableW@8 01c7 __imp__GetLastError@0 01f1 __imp__WideCharToMultiByte@32 0279 __imp__SetEnvironmentVariableA@8"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 56 33 F6 3B C6 89 75 FC 75 05 83 C8 FF EB 67 53 57 8B 38 3B FE 89 7D F4 74 57 6A 3D 57 E8 ?? ?? ?? ?? 8B D8 3B DE 59 59 74 47 3B FB 74 43 33 C0 66 39 73 02 0F 94 C0 89 45 F8 A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 0F 8B F8 E8 ?? ?? ?? ?? 8B 7D F4 A3 ?? ?? ?? ?? 3B C6 75 5A 39 75 0C A1 ?? ?? ?? ?? 74 15 3B C6 74 11 E8 ?? ?? ?? ?? 85 C0 74 43 83 C8 FF 5F 5B 5E C9 C3 39 75 F8 0F 85 3A 02 00 00 3B C6 75 1B 6A 04 E8 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 74 DA 89 30 39 35 ?? ?? ?? ?? 75 13 6A 04 E8 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 74 BF 89 30 A1 ?? ?? ?? ?? 2B DF D1 FB 57 8B FB 89 45 E8 89 5D EC E8 ?? ?? ?? ?? 8B D8 3B DE 59 7C 49 8B 7D E8 39 37 74 42 8D 3C 9F FF 37 E8 ?? ?? ?? ?? 39 75 F8 59 75 15 8B 45 F4 89 07 8B 45 08 89 30 EB 67 8B 47 04 89 07 43 83 C7 04 39 37 75 F3 8B C3 C1 E0 02 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B C6 59 59 74 43 EB 3C 39 75 F8 0F 85 8A 01 00 00 3B DE 7D 02 F7 DB 8D 04 9D 08 00 00 00 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B C6 59 59 0F 84 2A FF FF FF 8B 4D F4 8D 1C 98 89 0B 8B 4D 08 89 73 04 89 31 A3 ?? ?? ?? ?? 39 75 0C 0F 84 33 01 00 00 FF 75 F4 E8 ?? ?? ?? ?? 8D 44 00 04 50 E8 ?? ?? ?? ?? 8B F8 3B FE 59 59 89 7D E8 0F 84 12 01 00 00 FF 75 F4 57 E8 ?? ?? ?? ?? 8B 45 EC 8D 1C 47 66 89 33 43 59 43 83 3D ?? ?? ?? ?? 01 59 75 2E 8B 45 F8 F7 D8 1B C0 F7 D0 23 C3 50 57 FF 15 ?? ?? ?? ?? 85 C0 75 17 FF 15 ?? ?? ?? ?? 83 F8 78 75 08 89 35 ?? ?? ?? ?? EB 10 83 4D FC FF 39 35 ?? ?? ?? ?? 0F 85 B2 00 00 00 56 56 56 56 6A FF 57 8B 3D ?? ?? ?? ?? 56 56 89 75 EC 89 75 F0 FF D7 3B C6 89 45 08 74 7B 50 E8 ?? ?? ?? ?? 3B C6 59 89 45 EC 74 6D 56 56 FF 75 08 50 6A FF FF 75 E8 56 56 FF D7 85 C0 74 5A 39 75 F8 75 35 56 56 56 56 6A FF 53 56 56 FF D7 3B C6 89 45 08 74 43 50 E8 ?? ?? ?? ?? 3B C6 59 89 45 F0 74 35 56 56 FF 75 08 50 6A FF 53 56 56 FF D7 85 C0 75 04 83 4D FC FF 83 7D FC FF 74 1E 8B 45 F8 F7 D8 1B C0 F7 D0 23 45 F0 50 FF 75 EC FF 15 ?? ?? ?? ?? 85 C0 75 04 83 4D FC FF FF 75 F0 E8 ?? ?? ?? ?? FF 75 EC E8 ?? ?? ?? ?? 8B 7D E8 59 59 57 E8 ?? ?? ?? ?? 59 39 75 F8 74 09 FF 75 F4 E8 ?? ?? ?? ?? 59 8B 45 FC E9 C6 FD FF FF FF 75 F4 E8 ?? ?? ?? ?? 8B 45 08 59 89 30 33 C0 E9 B1 FD FF FF }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "__mbsinc"
		size = 28
		refs = "0009 __mbctype"
	strings:
		$1 = { 8B 44 24 04 0F B6 08 8A 89 ?? ?? ?? ?? 80 E1 04 40 84 C9 74 06 80 38 00 74 01 40 C3 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "_sscanf"
		size = 52
		refs = "0018 _strlen 002b __input"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 50 C7 45 EC 49 00 00 00 89 45 E8 89 45 E0 E8 ?? ?? ?? ?? 89 45 E4 8D 45 10 50 FF 75 0C 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 C9 C3 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "_wcsncnt"
		size = 30
	strings:
		$1 = { 8B 4C 24 04 85 C9 74 0D 49 66 83 38 00 74 07 40 40 85 C9 75 F3 49 8B 44 24 04 2B C1 48 C3 }
	condition:
		$1
}

rule file_306_1_0 {
	meta:
		name = "___crtLCMapStringW"
		size = 601
		refs = "0003 $T20174 0008 __SEH_prolog 0013 ?f_use@?1??__crtLCMapStringW@@9@9 001d ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0029 __imp__LCMapStringW@24 003b __imp__GetLastError@0 00ae ___lc_handle 00bb ___lc_codepage 00c6 ___ansicp 00e8 __imp__WideCharToMultiByte@32 0104 __alloca_probe 011e __resetstkoflw 0137 _malloc 0176 __imp__LCMapStringA@24 0206 _strncpy 0227 __imp__MultiByteToWideChar@24 023a _free 0254 __SEH_epilog"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 33 FF 47 39 1D ?? ?? ?? ?? 75 35 53 53 57 68 ?? ?? ?? ?? 68 00 01 00 00 53 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 3D ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 39 5D 14 7E 1D 8B 4D 14 8B 45 10 49 66 39 18 74 09 40 40 3B CB 75 F4 83 C9 FF 83 C8 FF 2B C1 01 45 14 A1 ?? ?? ?? ?? 3B C7 75 1D FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? E9 BA 01 00 00 83 F8 02 74 04 3B C3 75 54 89 5D DC 89 5D D4 89 5D D8 39 5D 08 75 08 A1 ?? ?? ?? ?? 89 45 08 39 5D 20 75 08 A1 ?? ?? ?? ?? 89 45 20 FF 75 08 E8 ?? ?? ?? ?? 59 39 45 20 74 08 83 F8 FF 74 03 89 45 20 53 53 53 53 FF 75 14 FF 75 10 53 FF 75 20 FF 15 ?? ?? ?? ?? 89 45 E0 3B C3 75 07 33 C0 E9 56 01 00 00 89 5D FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 E4 83 4D FC FF EB 18 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 89 5D E4 83 4D FC FF 33 FF 47 39 5D E4 75 13 FF 75 E0 E8 ?? ?? ?? ?? 59 89 45 E4 3B C3 74 B0 89 7D D4 53 53 FF 75 E0 FF 75 E4 FF 75 14 FF 75 10 53 FF 75 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CA 00 00 00 53 53 FF 75 E0 FF 75 E4 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 8B F0 89 75 D0 3B F3 0F 84 A9 00 00 00 89 7D FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D CC 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 33 FF 83 4D FC FF 8B 75 D0 3B FB 75 14 56 E8 ?? ?? ?? ?? 59 8B F8 3B FB 74 68 C7 45 D8 01 00 00 00 56 57 FF 75 E0 FF 75 E4 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 49 F6 45 0D 04 74 1F 89 75 DC 39 5D 1C 74 3B 39 75 1C 7D 03 8B 75 1C 56 57 FF 75 18 E8 ?? ?? ?? ?? 83 C4 0C EB 24 39 5D 1C 75 04 53 53 EB 06 FF 75 1C FF 75 18 56 57 6A 01 FF 75 20 FF 15 ?? ?? ?? ?? 89 45 DC EB 03 8B 7D CC 39 5D D8 74 07 57 E8 ?? ?? ?? ?? 59 39 5D D4 74 09 FF 75 E4 E8 ?? ?? ?? ?? 59 8B 45 DC 8D 65 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_307_1_0 {
	meta:
		name = "___free_lconv_mon"
		size = 137
		refs = "000e ___lconv_c 0016 _free"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 7E 8B 46 0C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 10 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 14 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 18 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 1C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 20 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 76 24 3B 35 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_307_2_0 {
	meta:
		name = "___init_monetary"
		size = 511
		refs = "0006 ___lc_handle 0018 ___lconv_intl 001d ___free_lconv_mon 0028 _free 002e ___lconv 0032 ___lconv_c 0046 _calloc 0065 ___lc_id 0073 ___getlocaleinfo"
	strings:
		$1 = { 53 55 33 DB 39 1D ?? ?? ?? ?? 56 57 75 33 39 1D ?? ?? ?? ?? 75 2B FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 1D ?? ?? ?? ?? E9 B5 01 00 00 6A 30 6A 01 E8 ?? ?? ?? ?? 8B E8 3B EB 59 59 0F 84 17 01 00 00 39 1D ?? ?? ?? ?? 0F 84 46 01 00 00 0F B7 35 ?? ?? ?? ?? 8D 45 0C 50 6A 15 56 6A 01 E8 ?? ?? ?? ?? 8B F8 8D 45 10 50 6A 14 56 6A 01 E8 ?? ?? ?? ?? 0B F8 8D 45 14 50 6A 16 56 6A 01 E8 ?? ?? ?? ?? 0B F8 8D 45 18 50 6A 17 56 6A 01 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 45 1C 50 6A 18 56 6A 01 E8 ?? ?? ?? ?? 0B F8 8D 45 20 50 6A 50 56 6A 01 E8 ?? ?? ?? ?? 0B F8 8D 45 24 50 6A 51 56 6A 01 E8 ?? ?? ?? ?? 0B F8 8D 45 28 50 6A 1A 56 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 45 29 50 6A 19 56 53 E8 ?? ?? ?? ?? 0B F8 8D 45 2A 50 6A 54 56 53 E8 ?? ?? ?? ?? 0B F8 8D 45 2B 50 6A 55 56 53 E8 ?? ?? ?? ?? 0B F8 8D 45 2C 50 6A 56 56 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 45 2D 50 6A 57 56 53 E8 ?? ?? ?? ?? 0B F8 8D 45 2E 50 6A 52 56 53 E8 ?? ?? ?? ?? 0B F8 8D 45 2F 50 6A 53 56 53 E8 ?? ?? ?? ?? 83 C4 30 0B C7 74 16 55 E8 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 59 59 33 C0 40 E9 85 00 00 00 8B 45 1C EB 12 8A 08 80 F9 30 7C 11 80 F9 39 7F 0C 80 E9 30 88 08 40 38 18 75 EA EB 22 80 F9 3B 75 F4 8B F0 8D 7E 01 8A 0F 88 0E 8B F7 38 1E 75 F3 EB E4 6A 0C 59 BE ?? ?? ?? ?? 8B FD F3 A5 A1 ?? ?? ?? ?? 8B 00 89 45 00 A1 ?? ?? ?? ?? 8B 40 04 89 45 04 A1 ?? ?? ?? ?? 8B 40 08 89 45 08 FF 35 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 59 59 33 C0 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "_wcsftime"
		size = 335
		refs = "0003 $T20363 0008 __SEH_prolog 0015 _wcslen 0036 __alloca_probe 0050 __resetstkoflw 006e _malloc 00e7 _wcstombs 0101 __Strftime 0114 _mbstowcs 0131 _free 014a __SEH_epilog"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E0 FF 75 10 E8 ?? ?? ?? ?? 59 8B F0 46 89 75 DC 89 7D D8 89 7D D4 89 7D FC 8B 5D 0C 8D 04 1B 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 E4 83 4D FC FF EB 1C 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 83 65 E4 00 83 4D FC FF 8B 5D 0C 8B 75 DC 33 FF 39 7D E4 75 1F 8D 04 1B 50 E8 ?? ?? ?? ?? 59 89 45 E4 3B C7 75 07 33 C0 E9 C5 00 00 00 C7 45 D8 01 00 00 00 C7 45 FC 01 00 00 00 8D 04 36 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D D0 83 4D FC FF EB 18 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 FF 83 4D FC FF 8B 5D 0C 8B 75 DC 85 FF 75 17 8D 04 36 50 E8 ?? ?? ?? ?? 59 8B F8 85 FF 74 50 C7 45 D4 01 00 00 00 8D 04 36 50 FF 75 10 57 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 34 6A 00 FF 75 14 57 8D 04 1B 50 FF 75 E4 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 1B 53 FF 75 E4 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 83 F8 FF 75 04 83 65 E0 00 83 7D D8 00 74 09 FF 75 E4 E8 ?? ?? ?? ?? 59 83 7D D4 00 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 E0 8D 65 C4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__setmode"
		size = 130
		refs = "0006 __nhandle 001b ___pioinfo 0069 _errno"
	strings:
		$1 = { 8B 44 24 04 3B 05 ?? ?? ?? ?? 56 73 66 8B C8 83 E0 1F C1 E0 03 C1 F9 05 8D 0C 8D ?? ?? ?? ?? 8B D0 8B 01 0F BE 44 10 04 A8 01 74 47 BE 00 80 00 00 25 80 00 00 00 39 74 24 0C 75 0B 8B 09 8D 4C 11 04 80 21 7F EB 13 81 7C 24 0C 00 40 00 00 75 16 8B 09 8D 4C 11 04 80 09 80 F7 D8 1B C0 25 00 C0 FF FF 03 C6 5E C3 C7 05 ?? ?? ?? ?? 16 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5E C3 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__mbsnccnt"
		size = 55
		refs = "001b __mbctype"
	strings:
		$1 = { 56 8B 74 24 0C 33 C0 85 F6 74 2A 8B 4C 24 08 8A 11 4E 84 D2 74 1F 0F B6 D2 F6 82 ?? ?? ?? ?? 04 74 0D 8B D6 4E 85 D2 74 0C 41 80 39 00 74 06 40 41 85 F6 75 DA 5E C3 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "___crtGetStringTypeA"
		size = 442
		refs = "0003 $T20117 0008 __SEH_prolog 0010 ?f_use@?1??__crtGetStringTypeA@@9@9 001f ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0026 __imp__GetStringTypeW@16 0038 __imp__GetLastError@0 0076 ___lc_codepage 009a __imp__MultiByteToWideChar@24 00bb __alloca_probe 00cc _memset 00e1 __resetstkoflw 00f6 _calloc 0139 _free 014c ___lc_handle 015f ___ansicp 017f ___convertcp 019e __imp__GetStringTypeA@20 01b5 __SEH_epilog"
	strings:
		$1 = { 6A 1C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 35 ?? ?? ?? ?? 75 35 8D 45 E4 50 33 FF 47 57 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 3D ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 A1 ?? ?? ?? ?? 83 F8 02 0F 84 EA 00 00 00 3B C6 0F 84 E2 00 00 00 83 F8 01 0F 85 FF 00 00 00 89 75 DC 89 75 E0 39 75 18 75 08 A1 ?? ?? ?? ?? 89 45 18 56 56 FF 75 10 FF 75 0C 33 C0 39 75 20 0F 95 C0 8D 04 C5 01 00 00 00 50 FF 75 18 FF 15 ?? ?? ?? ?? 8B F8 89 7D D8 85 FF 0F 84 BE 00 00 00 83 65 FC 00 8D 1C 3F 8B C3 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B F4 89 75 D4 53 6A 00 56 E8 ?? ?? ?? ?? 83 C4 0C 83 4D FC FF EB 15 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 F6 83 4D FC FF 8B 7D D8 85 F6 75 17 57 6A 02 E8 ?? ?? ?? ?? 59 59 8B F0 85 F6 74 67 C7 45 E0 01 00 00 00 57 56 FF 75 10 FF 75 0C 6A 01 FF 75 18 FF 15 ?? ?? ?? ?? 85 C0 74 11 FF 75 14 50 56 FF 75 08 FF 15 ?? ?? ?? ?? 89 45 DC 83 7D E0 00 74 07 56 E8 ?? ?? ?? ?? 59 8B 45 DC EB 6E 8B 5D 1C 3B DE 75 06 8B 1D ?? ?? ?? ?? 8B 7D 18 85 FF 75 06 8B 3D ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 83 F8 FF 75 04 33 C0 EB 44 3B C7 74 1E 6A 00 6A 00 8D 4D 10 51 FF 75 0C 50 57 E8 ?? ?? ?? ?? 83 C4 18 8B F0 85 F6 74 DD 89 75 0C FF 75 14 FF 75 10 FF 75 0C FF 75 08 53 FF 15 ?? ?? ?? ?? 8B F8 85 F6 74 07 56 E8 ?? ?? ?? ?? 59 8B C7 8D 65 C8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__get_lc_time"
		size = 871
		refs = "000a ___lc_id 0030 ___getlocaleinfo"
	strings:
		$1 = { 55 8B EC 51 51 85 F6 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 89 45 FC 89 4D F8 75 05 83 C8 FF C9 C3 53 57 8D 4E 04 51 6A 31 33 DB 50 43 53 E8 ?? ?? ?? ?? 8B F8 8D 46 08 50 6A 32 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 0C 50 6A 33 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 10 50 6A 34 FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 46 14 50 6A 35 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 18 50 6A 36 FF 75 FC 53 E8 ?? ?? ?? ?? 56 6A 37 FF 75 FC 0B F8 53 E8 ?? ?? ?? ?? 0B F8 8D 46 20 50 6A 2A FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 46 24 50 6A 2B FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 28 50 6A 2C FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 2C 50 6A 2D FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 30 50 6A 2E FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 46 34 50 6A 2F FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 1C 50 6A 30 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 38 50 6A 44 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 3C 50 6A 45 FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 46 40 50 6A 46 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 44 50 6A 47 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 48 50 6A 48 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 4C 50 6A 49 FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 46 50 50 6A 4A FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 54 50 6A 4B FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 58 50 6A 4C FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 5C 50 6A 4D FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 46 60 50 6A 4E FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 64 50 6A 4F FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 68 50 6A 38 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 6C 50 6A 39 FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 46 70 50 6A 3A FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 74 50 6A 3B FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 78 50 6A 3C FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 46 7C 50 6A 3D FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 86 80 00 00 00 50 6A 3E FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 86 84 00 00 00 50 6A 3F FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 86 88 00 00 00 50 6A 40 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 86 8C 00 00 00 50 6A 41 FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 86 90 00 00 00 50 6A 42 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 86 94 00 00 00 50 6A 43 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 86 98 00 00 00 50 6A 28 FF 75 FC 53 E8 ?? ?? ?? ?? 0B F8 8D 86 9C 00 00 00 50 6A 29 FF 75 FC 53 E8 ?? ?? ?? ?? 83 C4 40 0B F8 8D 86 A0 00 00 00 50 6A 1F FF 75 F8 53 E8 ?? ?? ?? ?? 0B F8 8D 86 A4 00 00 00 50 6A 20 FF 75 F8 53 E8 ?? ?? ?? ?? 0B F8 8D 86 A8 00 00 00 50 68 03 10 00 00 FF 75 F8 53 E8 ?? ?? ?? ?? 8B 5D F8 0B F8 8D 86 B0 00 00 00 50 68 09 10 00 00 53 6A 00 E8 ?? ?? ?? ?? 83 C4 40 0B F8 89 9E AC 00 00 00 8B C7 5F 5B C9 C3 }
	condition:
		$1
}

rule file_312_1_0 {
	meta:
		name = "___free_lc_time"
		size = 400
		refs = "0011 _free"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 0F 84 81 01 00 00 FF 76 04 E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? FF 76 0C E8 ?? ?? ?? ?? FF 76 10 E8 ?? ?? ?? ?? FF 76 14 E8 ?? ?? ?? ?? FF 76 18 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? FF 76 20 E8 ?? ?? ?? ?? FF 76 24 E8 ?? ?? ?? ?? FF 76 28 E8 ?? ?? ?? ?? FF 76 2C E8 ?? ?? ?? ?? FF 76 30 E8 ?? ?? ?? ?? FF 76 34 E8 ?? ?? ?? ?? FF 76 1C E8 ?? ?? ?? ?? FF 76 38 E8 ?? ?? ?? ?? FF 76 3C E8 ?? ?? ?? ?? 83 C4 40 FF 76 40 E8 ?? ?? ?? ?? FF 76 44 E8 ?? ?? ?? ?? FF 76 48 E8 ?? ?? ?? ?? FF 76 4C E8 ?? ?? ?? ?? FF 76 50 E8 ?? ?? ?? ?? FF 76 54 E8 ?? ?? ?? ?? FF 76 58 E8 ?? ?? ?? ?? FF 76 5C E8 ?? ?? ?? ?? FF 76 60 E8 ?? ?? ?? ?? FF 76 64 E8 ?? ?? ?? ?? FF 76 68 E8 ?? ?? ?? ?? FF 76 6C E8 ?? ?? ?? ?? FF 76 70 E8 ?? ?? ?? ?? FF 76 74 E8 ?? ?? ?? ?? FF 76 78 E8 ?? ?? ?? ?? FF 76 7C E8 ?? ?? ?? ?? 83 C4 40 FF B6 80 00 00 00 E8 ?? ?? ?? ?? FF B6 84 00 00 00 E8 ?? ?? ?? ?? FF B6 88 00 00 00 E8 ?? ?? ?? ?? FF B6 8C 00 00 00 E8 ?? ?? ?? ?? FF B6 90 00 00 00 E8 ?? ?? ?? ?? FF B6 94 00 00 00 E8 ?? ?? ?? ?? FF B6 98 00 00 00 E8 ?? ?? ?? ?? FF B6 9C 00 00 00 E8 ?? ?? ?? ?? FF B6 A0 00 00 00 E8 ?? ?? ?? ?? FF B6 A4 00 00 00 E8 ?? ?? ?? ?? FF B6 A8 00 00 00 E8 ?? ?? ?? ?? 83 C4 2C 5E C3 }
	condition:
		$1
}

rule file_312_2_0 {
	meta:
		name = "___init_time"
		size = 140
		refs = "0002 ___lc_handle 0012 _calloc 0022 __get_lc_time 002c ___free_lc_time 0032 _free 003d ___lc_time_intl 0043 ___lc_time_curr 006b ___lc_time_c"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 56 74 55 68 B4 00 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 75 03 40 5E C3 E8 ?? ?? ?? ?? 85 C0 74 11 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 33 C0 40 EB 4D FF 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? EB 27 FF 35 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 33 C0 59 59 5E C3 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__cgetws"
		size = 673
		refs = "0014 __coninpfh 0022 ___initconin 003e __imp__GetConsoleMode@8 004c __imp__SetConsoleMode@8 0052 _bUseW 006e __imp__ReadConsoleW@20 0084 __imp__GetLastError@0 010f __imp__GetConsoleCP@0 0118 ?in_buff@?L@??_cgetws@@9@9 0126 ?AStr@?L@??_cgetws@@9@9 0132 __imp__ReadConsoleA@20 01b2 __imp__IsDBCSLeadByteEx@8 01da __imp__MultiByteToWideChar@24 0201 _strlen 020c ?was_buff_full@?L@??_cgetws@@9@9 0277 _memmove"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 8B 75 08 57 33 FF 66 89 7E 02 83 3D ?? ?? ?? ?? FE 8D 5E 04 89 5D FC 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 75 07 33 C0 E9 65 02 00 00 8D 4D EC 51 50 FF 15 ?? ?? ?? ?? 6A 07 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 39 3D ?? ?? ?? ?? 0F 84 AE 00 00 00 57 8D 45 F8 50 0F B7 06 50 53 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 1F 83 3D ?? ?? ?? ?? 02 89 7D FC 75 7C FF 15 ?? ?? ?? ?? 83 F8 78 75 71 89 3D ?? ?? ?? ?? EB 75 3B DF C7 05 ?? ?? ?? ?? 01 00 00 00 0F 84 E3 01 00 00 8B 45 F8 8D 0C 46 66 83 39 0D 75 0F 83 C0 FE 66 89 46 02 66 89 39 E9 C8 01 00 00 0F B7 16 3B C2 75 15 66 83 79 02 0D 75 0E 48 66 89 46 02 66 89 79 02 E9 AC 01 00 00 83 F8 01 75 12 66 83 3B 0A 75 0C 66 89 3B 66 89 7E 02 E9 95 01 00 00 66 89 46 02 66 89 7C 46 04 39 3D ?? ?? ?? ?? 0F 85 80 01 00 00 89 7D 08 FF 15 ?? ?? ?? ?? 89 45 F0 39 3D ?? ?? ?? ?? 75 69 57 8D 45 F8 50 6A 40 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 03 89 7D FC 39 7D FC 74 45 8B 4D F8 8D 81 ?? ?? ?? ?? 80 38 0D 75 05 C6 00 00 EB 32 83 F9 41 75 12 80 3D ?? ?? ?? ?? 0D 75 1D C6 05 ?? ?? ?? ?? 00 EB 1B 83 F9 01 75 0F 66 83 3E 0A 75 09 C6 05 ?? ?? ?? ?? 00 EB 07 C6 81 ?? ?? ?? ?? 00 33 DB 38 1D ?? ?? ?? ?? 74 62 83 FB 40 73 5D 0F B7 06 39 45 08 73 55 33 C0 8D BB ?? ?? ?? ?? 8A 07 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 33 C9 85 C0 8B 45 08 0F 95 C1 41 89 4D F4 0F B7 0E 2B C8 51 8D 44 46 04 50 FF 75 F4 57 6A 09 FF 75 F0 FF 15 ?? ?? ?? ?? 85 C0 74 03 01 45 08 03 5D F4 33 FF 80 BB ?? ?? ?? ?? 00 75 9E 39 3D ?? ?? ?? ?? 74 25 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B D8 59 75 16 39 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 74 19 89 3D ?? ?? ?? ?? EB 05 83 FB 40 72 0C 0F B7 06 39 45 08 0F 82 E5 FE FF FF 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B D8 59 73 3E 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 40 59 75 0A C7 05 ?? ?? ?? ?? 01 00 00 00 6A 41 58 2B C3 50 8D 83 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 66 89 7C 46 04 66 89 46 02 FF 75 EC FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__mbsspnp"
		size = 141
		refs = "0005 ___ismbcodepage 0016 _strspn 0040 __mbctype"
	strings:
		$1 = { 53 33 DB 39 1D ?? ?? ?? ?? 56 75 1A FF 74 24 10 8B 74 24 10 56 E8 ?? ?? ?? ?? 03 C6 59 59 8A 08 F6 D9 1B C9 EB 62 8B 4C 24 0C 38 19 74 54 8B 74 24 10 57 38 1E 8B C6 74 2E 8A 10 0F B6 FA F6 87 ?? ?? ?? ?? 04 74 17 3A 11 75 08 8A 50 01 3A 51 01 74 14 8D 50 01 38 1A 74 0D 8B C2 EB 04 3A 11 74 05 40 38 18 75 D2 38 18 74 16 0F B6 01 F6 80 ?? ?? ?? ?? 04 74 05 41 38 19 74 05 41 38 19 75 B2 5F 8A 01 F6 D8 1B C0 5E 23 C1 5B C3 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "__strnicmp"
		size = 85
		refs = "000b ___lc_handle 0014 ___ascii_strnicmp 0026 _tolower"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 74 48 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 53 56 8B 75 08 57 8B 7D 0C 0F B6 06 50 E8 ?? ?? ?? ?? 8B D8 0F B6 07 50 46 E8 ?? ?? ?? ?? 59 47 FF 4D 10 59 8B C8 74 08 85 DB 74 04 3B D9 74 D9 5F 8B C3 5E 2B C1 5B 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "__mbctoupper"
		size = 120
		refs = "001d __mbctype 002b ___mbcodepage 0042 ___mblcid 0047 ___crtLCMapStringA 006d __mbcasemap"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 81 FB FF 00 00 00 76 51 8B C3 C1 E8 08 88 45 0A 0F B6 C0 F6 80 ?? ?? ?? ?? 04 88 5D 0B 74 4C 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC 6A 02 50 6A 02 8D 45 0A 50 68 00 02 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 21 0F B6 45 FC 0F B6 4D FD C1 E0 08 03 C1 EB 14 F6 83 ?? ?? ?? ?? 20 74 09 0F B6 83 ?? ?? ?? ?? EB 02 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "__ms_p5_test_fdiv"
		size = 64
		refs = "0008 __real@4147ffff80000000 0011 __real@4150017ec0000000 002c __real@3ff0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 18 DD 05 ?? ?? ?? ?? DD 5D F8 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DC 75 F8 DC 4D F8 DC 6D F0 DD 5D E8 DD 45 E8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 05 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_318_1_0 {
	meta:
		name = "__ms_p5_mp_test_fdiv"
		size = 41
		refs = "0001 ??_C@_08CPNIBGIE@KERNEL32?$AA@ 0007 __imp__GetModuleHandleA@4 0010 ??_C@_0BK@NHEOCAHP@IsProcessorFeaturePresent?$AA@ 0017 __imp__GetProcAddress@8 0025 __ms_p5_test_fdiv"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 15 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 6A 00 FF D0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "_ldexp"
		size = 491
		refs = "0014 __ctrlfp 0032 __sptype 0060 __handle_qnan2 0072 __real@3ff0000000000000 009b __real@0000000000000000 00c9 __decomp 00ff __d_inf 0107 __copysign 013f __set_exp 01c3 __except2"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 0E 66 25 F0 7F 66 3D F0 7F 59 59 75 70 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 7E 30 83 F8 02 7E 6A 83 F8 03 75 26 DB 45 10 57 83 EC 10 DD 5D F4 DD 45 F4 DD 5C 24 08 DD 45 08 DD 1C 24 6A 19 E8 ?? ?? ?? ?? 83 C4 18 E9 7B 01 00 00 DD 45 08 57 DC 05 ?? ?? ?? ?? 83 EC 18 DD 5C 24 10 DB 45 10 DD 5D F4 DD 45 F4 DD 5C 24 08 DD 45 08 DD 1C 24 6A 19 6A 08 E9 29 01 00 00 DD 05 ?? ?? ?? ?? DD 45 08 DA E9 DF E0 F6 C4 44 7A 11 56 57 E8 ?? ?? ?? ?? DD 45 08 59 59 E9 2B 01 00 00 DD 45 08 8D 45 FC 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 10 DD 5D F4 83 C4 0C 85 C0 8B C8 7D 02 F7 D9 81 F9 FF FF FF 7F 7F 05 8B 4D FC 03 C1 3D 00 0A 00 00 DD 45 F4 7E 37 57 83 EC 10 DD 5C 24 08 DD 05 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DD 5C 24 08 DB 45 10 DD 5D F4 DD 45 F4 DD 1C 24 51 51 DD 45 08 DD 1C 24 6A 19 6A 11 E9 96 00 00 00 3D 00 04 00 00 7E 30 05 00 FA FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F4 83 C4 0C DD 45 F4 57 83 EC 18 DD 5C 24 10 DB 45 10 DD 5D F4 DD 45 F4 DD 5C 24 08 EB BA 3D 03 F6 FF FF 7D 19 DC 0D ?? ?? ?? ?? 57 83 EC 18 DD 5C 24 10 DB 45 10 DD 5D F4 DD 45 F4 EB 31 3D 03 FC FF FF 7D 42 05 00 06 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F4 83 C4 0C DD 45 F4 57 83 EC 18 DD 5C 24 10 DB 45 10 DD 5D F4 DD 45 F4 DD 5C 24 08 DD 45 08 DD 1C 24 6A 19 6A 12 E8 ?? ?? ?? ?? 83 C4 24 EB 1B 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 56 DD 5D F4 57 E8 ?? ?? ?? ?? DD 45 F4 83 C4 14 5F 5E C9 C3 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "__mbslwr"
		size = 114
		refs = "0014 __mbctype 0021 ___mbcodepage 0035 ___mblcid 003a ___crtLCMapStringA 005c __mbcasemap"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 80 3F 00 8B F7 74 59 0F B6 06 8A 88 ?? ?? ?? ?? F6 C1 04 74 37 6A 01 FF 35 ?? ?? ?? ?? 8D 45 08 6A 02 50 6A 02 56 68 00 01 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 29 83 F8 01 8B 4D 08 88 0E 7E 13 46 88 2E EB 0E F6 C1 10 74 07 0F B6 80 ?? ?? ?? ?? 88 06 46 80 3E 00 75 A7 8B C7 5F 5E 5D C3 33 C0 EB F8 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "_strcoll"
		size = 70
		refs = "0001 ___lc_handle 000a _strcmp 0010 ___lc_collate_cp 0027 ___crtCompareStringA 0034 _errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 75 05 E9 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 6A FF FF 74 24 10 6A FF FF 74 24 14 68 00 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 10 C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F C3 83 C0 FE C3 }
	condition:
		$1
}

rule file_554_0_0 {
	meta:
		name = "_wcscoll"
		size = 70
		refs = "0001 ___lc_handle 000a _wcscmp 0010 ___lc_collate_cp 0027 ___crtCompareStringW 0034 _errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 75 05 E9 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 6A FF FF 74 24 10 6A FF FF 74 24 14 68 00 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 10 C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F C3 83 C0 FE C3 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "__strnicoll"
		size = 102
		refs = "001a _errno 0027 ___lc_handle 0037 __strnicmp 0042 ___lc_collate_cp 0055 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 8B 4D 10 85 C9 75 04 33 C0 5D C3 56 BE FF FF FF 7F 3B CE 76 0E C7 05 ?? ?? ?? ?? 16 00 00 00 8B C6 EB 3D A1 ?? ?? ?? ?? 85 C0 75 11 51 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 23 FF 35 ?? ?? ?? ?? 51 FF 75 0C 51 FF 75 08 68 01 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 B8 83 C0 FE 5E 5D C3 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "_$$$00001"
		size = 43
		refs = "0027 __rtindfnpop"
	strings:
		$1 = { D9 FF 9B DF E0 9B 9E 7A 16 C3 D9 FE 9B DF E0 9B 9E 7A 0C C3 D9 F2 9B DF E0 DD D8 9E 7A 01 C3 C6 85 70 FF FF FF 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "_getSystemCP"
		size = 70
		refs = "0002 _fSystemSet 0018 __imp__GetOEMCP@0 002d __imp__GetACP@0 0037 ___lc_codepage"
	strings:
		$1 = { 83 25 ?? ?? ?? ?? 00 83 F8 FE 75 10 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 25 ?? ?? ?? ?? 83 F8 FD 75 10 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 25 ?? ?? ?? ?? 83 F8 FC 75 0F A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 C3 }
	condition:
		$1
}

rule file_331_1_0 {
	meta:
		name = "_CPtoLCID"
		size = 47
	strings:
		$1 = { 2D A4 03 00 00 74 22 83 E8 04 74 17 83 E8 0D 74 0C 48 74 03 33 C0 C3 B8 04 04 00 00 C3 B8 12 04 00 00 C3 B8 04 08 00 00 C3 B8 11 04 00 00 C3 }
	condition:
		$1
}

rule file_331_2_0 {
	meta:
		name = "_setSBCS"
		size = 41
		refs = "0007 __mbctype 0011 ___mbcodepage 0016 ___ismbcodepage 001b ___mblcid 0020 ___mbulinfo"
	strings:
		$1 = { 57 6A 40 33 C0 59 BF ?? ?? ?? ?? F3 AB AA 33 C0 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? BF ?? ?? ?? ?? AB AB AB 5F C3 }
	condition:
		$1
}

rule file_331_3_0 {
	meta:
		name = "_setSBUpLow"
		size = 396
		refs = "000a ___security_cookie 0018 ___mbcodepage 001e __imp__GetCPInfo@8 0086 ___mblcid 00a2 ___crtGetStringTypeA 00c6 ___crtLCMapStringA 0106 __mbctype 0114 __mbcasemap 0186 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 18 05 00 00 A1 ?? ?? ?? ?? 89 45 FC 56 8D 45 E8 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 01 BE 00 01 00 00 0F 85 0D 01 00 00 33 C0 88 84 05 E8 FE FF FF 40 3B C6 72 F4 8A 45 EE 84 C0 C6 85 E8 FE FF FF 20 74 36 53 8D 55 EF 57 0F B6 0A 0F B6 C0 3B C1 77 1D 2B C8 41 8B D9 C1 E9 02 8D BC 05 E8 FE FF FF B8 20 20 20 20 F3 AB 8B CB 83 E1 03 F3 AA 42 8A 02 42 84 C0 75 D1 5F 5B 6A 00 FF 35 ?? ?? ?? ?? 8D 85 E8 FA FF FF FF 35 ?? ?? ?? ?? 50 56 8D 85 E8 FE FF FF 50 6A 01 E8 ?? ?? ?? ?? 6A 00 FF 35 ?? ?? ?? ?? 8D 85 E8 FD FF FF 56 50 56 8D 85 E8 FE FF FF 50 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 FF 35 ?? ?? ?? ?? 8D 85 E8 FC FF FF 56 50 56 8D 85 E8 FE FF FF 50 68 00 02 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 5C 33 C0 66 8B 8C 45 E8 FA FF FF F6 C1 01 74 16 80 88 ?? ?? ?? ?? 10 8A 8C 05 E8 FD FF FF 88 88 ?? ?? ?? ?? EB 1C F6 C1 02 74 10 80 88 ?? ?? ?? ?? 20 8A 8C 05 E8 FC FF FF EB E3 C6 80 ?? ?? ?? ?? 00 40 3B C6 72 BC EB 44 33 C0 83 F8 41 72 19 83 F8 5A 77 14 80 88 ?? ?? ?? ?? 10 8A C8 80 C1 20 88 88 ?? ?? ?? ?? EB 1F 83 F8 61 72 13 83 F8 7A 77 0E 80 88 ?? ?? ?? ?? 20 8A C8 80 E9 20 EB E0 C6 80 ?? ?? ?? ?? 00 40 3B C6 72 BE 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_331_4_0 {
	meta:
		name = "__setmbcp"
		size = 486
		refs = "0007 ___security_cookie 001b _fSystemSet 002d __imp__GetOEMCP@0 0044 __imp__GetACP@0 0050 ___lc_codepage 0065 ___mbcodepage 007d ___rgcode_page_info 0095 __imp__GetCPInfo@8 00a8 __mbctype 00bd ___mblcid 0122 ___rgctypeflag 014f ___ismbcodepage 0158 _CPtoLCID 0163 ___mbulinfo 01c9 _setSBCS 01ce _setSBUpLow 01e0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 53 56 8B 75 08 33 DB 83 FE FE 89 45 FC 57 89 1D ?? ?? ?? ?? 75 12 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? EB 2B 83 FE FD 75 12 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? EB 14 83 FE FC 75 14 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 89 45 08 8B F0 3B 35 ?? ?? ?? ?? 0F 84 63 01 00 00 3B F3 0F 84 51 01 00 00 33 D2 33 C0 39 B0 ?? ?? ?? ?? 74 67 83 C0 30 42 3D F0 00 00 00 72 ED 8D 45 E8 50 56 FF 15 ?? ?? ?? ?? 83 F8 01 0F 85 1E 01 00 00 6A 40 33 C0 59 BF ?? ?? ?? ?? F3 AB AA 33 FF 47 39 7D E8 89 35 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 0F 86 E7 00 00 00 80 7D EE 00 0F 84 B8 00 00 00 8D 4D EF 8A 11 84 D2 0F 84 AB 00 00 00 0F B6 41 FF 0F B6 D2 E9 8F 00 00 00 6A 40 33 C0 59 BF ?? ?? ?? ?? F3 AB 8D 0C 52 C1 E1 04 89 5D E4 AA 8D 99 ?? ?? ?? ?? 8A 03 8B F3 EB 29 8A 56 01 84 D2 74 26 0F B6 C0 0F B6 FA 3B C7 77 14 8B 55 E4 8A 92 ?? ?? ?? ?? 08 90 ?? ?? ?? ?? 40 3B C7 76 F5 46 46 8A 06 84 C0 75 D3 FF 45 E4 83 C3 08 83 7D E4 04 72 C1 8B 45 08 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 8D B1 ?? ?? ?? ?? BF ?? ?? ?? ?? A5 A5 A3 ?? ?? ?? ?? A5 EB 5C 80 88 ?? ?? ?? ?? 04 40 3B C2 76 F4 41 41 80 79 FF 00 0F 85 4B FF FF FF 8B C7 80 88 ?? ?? ?? ?? 08 40 3D FF 00 00 00 72 F1 8B C6 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 06 89 1D ?? ?? ?? ?? 33 C0 BF ?? ?? ?? ?? AB AB AB EB 0D 39 1D ?? ?? ?? ?? 74 0E E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 03 83 C8 FF 8B 4D FC 5F 5E 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_331_5_0 {
	meta:
		name = "__getmbcp"
		size = 16
		refs = "0001 ___ismbcodepage 000b ___mbcodepage"
	strings:
		$1 = { A1 ?? ?? ?? ?? F7 D8 1B C0 23 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_331_6_0 {
	meta:
		name = "___initmbctable"
		size = 30
		refs = "0002 ___mbctype_initialized 000c __setmbcp"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 12 6A FD E8 ?? ?? ?? ?? 59 C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 C3 }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "__wcsrev"
		size = 50
	strings:
		$1 = { 8B 4C 24 04 8B C1 8B D1 56 66 8B 31 41 41 66 85 F6 75 F6 83 E9 04 3B D1 73 16 57 66 8B 39 66 8B 32 66 89 3A 42 42 66 89 31 49 49 3B D1 72 EC 5F 5E C3 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "___security_error_handler"
		size = 328
		refs = "0006 $T19949 000b __SEH_prolog 0010 ___security_cookie 0018 _user_handler 0048 ??_C@_0CD@GMKACBEK@Unknown?5security?5failure?5detecte@ 0052 ??_C@_0LB@BPLHHLFD@A?5security?5error?5of?5unknown?5caus@ 005e ??_C@_0BJ@MDEKIEOJ@Buffer?5overrun?5detected?$CB?$AA@ 0068 ??_C@_0KA@JEHFIFGP@A?5buffer?5overrun?5has?5been?5detect@ 0083 __imp__GetModuleFileNameA@12 008c ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 0098 _strcpy 00a8 _strlen 00cd ??_C@_03KHICJKCI@?4?4?4?$AA@ 00d3 _strncpy 00ec __alloca_probe 00fd ??_C@_02PHMGELLB@?6?6?$AA@ 0104 _strcat 0109 ??_C@_09KLGCKDOD@Program?3?5?$AA@ 0133 ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 0139 ___crtMessageBoxA 0143 __exit"
	strings:
		$1 = { 68 18 01 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 A1 ?? ?? ?? ?? 33 C9 3B C1 74 1F 89 4D FC FF 75 0C FF 75 08 FF D0 59 59 83 4D FC FF E9 08 01 00 00 33 C0 40 C3 8B 65 E8 EB EE 8B 45 08 48 74 16 BF ?? ?? ?? ?? C7 85 D8 FE FF FF ?? ?? ?? ?? BE D4 00 00 00 EB 14 BF ?? ?? ?? ?? C7 85 D8 FE FF FF ?? ?? ?? ?? BE B9 00 00 00 88 4D E0 68 04 01 00 00 8D 85 DC FE FF FF 50 51 FF 15 ?? ?? ?? ?? 85 C0 75 13 68 ?? ?? ?? ?? 8D 85 DC FE FF FF 50 E8 ?? ?? ?? ?? 59 59 8D 9D DC FE FF FF 8B C3 50 E8 ?? ?? ?? ?? 59 83 C0 0B 83 F8 3C 76 25 8B C3 50 E8 ?? ?? ?? ?? 8B D8 8D 85 DC FE FF FF 83 E8 31 03 D8 6A 03 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 10 53 E8 ?? ?? ?? ?? 59 8D 44 30 0C 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B F4 57 56 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? FF B5 D8 FE FF FF 56 E8 ?? ?? ?? ?? 68 10 20 01 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 3C 6A 03 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "__getwch"
		size = 366
		refs = "000c _wchbuf 002b __coninpfh 0043 ___initconin 0055 __imp__GetConsoleMode@8 005b __imp__SetConsoleMode@8 006d _bUseW 0084 __imp__ReadConsoleInputW@16 009b __imp__GetLastError@0 00d8 __imp__ReadConsoleInputA@16 0118 __getextendedkeycode 0161 __imp__GetConsoleCP@0 0168 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 33 DB 66 81 3D ?? ?? ?? ?? FF FF 89 5D F8 74 13 A1 ?? ?? ?? ?? 66 81 0D ?? ?? ?? ?? FF FF E9 1E 01 00 00 A1 ?? ?? ?? ?? 83 F8 FF 75 09 66 0D FF FF E9 0B 01 00 00 83 F8 FE 75 05 E8 ?? ?? ?? ?? 56 57 8D 45 F0 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 53 FF 35 ?? ?? ?? ?? FF D7 33 F6 46 39 1D ?? ?? ?? ?? 74 54 8D 45 F4 50 56 8D 45 DC 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 24 83 3D ?? ?? ?? ?? 02 0F 85 B2 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 78 0F 85 A3 00 00 00 89 1D ?? ?? ?? ?? EB 06 89 35 ?? ?? ?? ?? 39 5D F4 0F 84 8C 00 00 00 39 1D ?? ?? ?? ?? 75 1E 8D 45 F4 50 56 8D 45 DC 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 6B 39 5D F4 74 66 66 39 75 DC 75 80 39 5D E0 0F 84 77 FF FF FF 39 1D ?? ?? ?? ?? 74 0D 8B 45 EA 66 3B C3 89 45 F8 75 30 EB 0A 8A 45 EA 3A C3 88 45 FF 75 41 8D 45 E0 50 E8 ?? ?? ?? ?? 3B C3 59 0F 84 46 FF FF FF 66 0F B6 08 89 4D F8 66 0F B6 40 01 66 A3 ?? ?? ?? ?? FF 75 F0 FF 35 ?? ?? ?? ?? FF D7 66 8B 45 F8 5F 5E 5B C9 C3 C7 45 F8 FF FF 00 00 EB E3 56 8D 45 F8 50 56 8D 45 FF 50 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? EB C9 }
	condition:
		$1
}

rule file_334_1_0 {
	meta:
		name = "__getwche"
		size = 65
		refs = "0003 _wchbuf 001c __getwch 002b __putwch"
	strings:
		$1 = { 66 81 3D ?? ?? ?? ?? FF FF 74 0F A1 ?? ?? ?? ?? 66 81 0D ?? ?? ?? ?? FF FF C3 56 E8 ?? ?? ?? ?? 8B F0 66 81 FE FF FF 74 12 56 E8 ?? ?? ?? ?? 66 3D FF FF 59 74 05 66 8B C6 5E C3 66 0D FF FF 5E C3 }
	condition:
		$1
}

rule file_334_2_0 {
	meta:
		name = "__ungetwch"
		size = 38
		refs = "000e _wchbuf"
	strings:
		$1 = { 66 8B 44 24 04 66 3D FF FF 74 16 66 81 3D ?? ?? ?? ?? FF FF 75 0B 66 25 FF 00 66 A3 ?? ?? ?? ?? C3 66 0D FF FF C3 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "__itow"
		size = 59
		refs = "0007 ___security_cookie 0019 __itoa 0027 _mbstowcs 0035 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? FF 75 10 89 45 FC 8D 45 D4 50 FF 75 08 E8 ?? ?? ?? ?? 6A 28 8D 45 D4 50 FF 75 0C E8 ?? ?? ?? ?? 8B 4D FC 8B 45 0C 83 C4 18 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_336_1_0 {
	meta:
		name = "__ltow"
		size = 59
		refs = "0007 ___security_cookie 0019 __ltoa 0027 _mbstowcs 0035 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? FF 75 10 89 45 FC 8D 45 D4 50 FF 75 08 E8 ?? ?? ?? ?? 6A 28 8D 45 D4 50 FF 75 0C E8 ?? ?? ?? ?? 8B 4D FC 8B 45 0C 83 C4 18 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_336_2_0 {
	meta:
		name = "__ultow"
		size = 59
		refs = "0007 ___security_cookie 0019 __ultoa 0027 _mbstowcs 0035 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? FF 75 10 89 45 FC 8D 45 D4 50 FF 75 08 E8 ?? ?? ?? ?? 6A 28 8D 45 D4 50 FF 75 0C E8 ?? ?? ?? ?? 8B 4D FC 8B 45 0C 83 C4 18 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_336_3_0 {
	meta:
		name = "__i64tow"
		size = 62
		refs = "0007 ___security_cookie 001c __i64toa 002a _mbstowcs 0038 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? FF 75 14 89 45 FC 8D 45 AC 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 6A 50 8D 45 AC 50 FF 75 10 E8 ?? ?? ?? ?? 8B 4D FC 8B 45 10 83 C4 1C E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_336_4_0 {
	meta:
		name = "__ui64tow"
		size = 62
		refs = "0007 ___security_cookie 001c __ui64toa 002a _mbstowcs 0038 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? FF 75 14 89 45 FC 8D 45 AC 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 6A 50 8D 45 AC 50 FF 75 10 E8 ?? ?? ?? ?? 8B 4D FC 8B 45 10 83 C4 1C E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "__getbuf"
		size = 68
		refs = "0002 __cflush 000c _malloc"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 68 00 10 00 00 E8 ?? ?? ?? ?? 85 C0 59 8B 4C 24 04 89 41 08 74 0D 83 49 0C 08 C7 41 18 00 10 00 00 EB 11 83 49 0C 04 8D 41 14 89 41 08 C7 41 18 02 00 00 00 8B 41 08 83 61 04 00 89 01 C3 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "__getstream"
		size = 114
		refs = "0005 __nstream 0015 ___piob 003a _malloc"
	strings:
		$1 = { 53 56 57 8B 3D ?? ?? ?? ?? 33 DB 33 F6 33 C0 3B FB 7E 59 8B 0D ?? ?? ?? ?? 8B 14 81 3B D3 74 12 F6 42 0C 83 74 07 40 3B C7 7C EE EB 3F 8B 34 81 EB 24 8B F8 6A 20 C1 E7 02 E8 ?? ?? ?? ?? 59 8B 0D ?? ?? ?? ?? 89 04 0F A1 ?? ?? ?? ?? 8B 3C 07 3B FB 74 18 8B F7 3B F3 74 12 83 4E 10 FF 89 5E 04 89 5E 0C 89 5E 08 89 1E 89 5E 1C 5F 8B C6 5E 5B C3 }
	condition:
		$1
}

rule file_339_1_0 {
	meta:
		name = "__cfltcvt_init"
		size = 56
		refs = "0001 __cfltcvt 0006 __cfltcvt_tab 0010 __cropzeros 001a __fassign 0024 __forcdecpt 002e __positive"
	strings:
		$1 = { B8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_339_3_0 {
	meta:
		name = "__fpmath"
		size = 30
		refs = "0001 __cfltcvt_init 0006 __ms_p5_mp_test_fdiv 0010 __adjust_fdiv 0017 __setdefaultprecision"
	strings:
		$1 = { E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7C 24 04 00 A3 ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? DB E2 C3 }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "_strpbrk"
		size = 64
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 8B FF 8A 06 0A C0 74 0C 83 C6 01 0F A3 04 24 73 F1 8D 46 FF 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "?_ValidateRead@@YAHPBXI@Z"
		size = 28
		refs = "000e __imp__IsBadReadPtr@8"
	strings:
		$1 = { 56 FF 74 24 0C 33 F6 FF 74 24 0C 46 FF 15 ?? ?? ?? ?? 85 C0 74 02 33 F6 8B C6 5E C3 }
	condition:
		$1
}

rule file_341_1_0 {
	meta:
		name = "?_ValidateWrite@@YAHPAXI@Z"
		size = 28
		refs = "000e __imp__IsBadWritePtr@8"
	strings:
		$1 = { 56 FF 74 24 0C 33 F6 FF 74 24 0C 46 FF 15 ?? ?? ?? ?? 85 C0 74 02 33 F6 8B C6 5E C3 }
	condition:
		$1
}

rule file_341_2_0 {
	meta:
		name = "?_ValidateExecute@@YAHP6GHXZ@Z"
		size = 24
		refs = "000a __imp__IsBadCodePtr@4"
	strings:
		$1 = { 56 FF 74 24 08 33 F6 46 FF 15 ?? ?? ?? ?? 85 C0 74 02 33 F6 8B C6 5E C3 }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "_findenv"
		size = 77
		refs = "0003 __environ 0010 __mbsnbicoll"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? EB 22 57 50 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0D 8B 06 8A 04 07 3C 3D 74 1C 84 C0 74 18 83 C6 04 8B 06 85 C0 75 D8 8B C6 2B 05 ?? ?? ?? ?? 5E C1 F8 02 F7 D8 C3 8B C6 2B 05 ?? ?? ?? ?? 5E C1 F8 02 C3 }
	condition:
		$1
}

rule file_342_2_0 {
	meta:
		name = "___crtsetenv"
		size = 469
		refs = "0027 __mbschr 003e __environ 0047 ___initenv 0053 _copy_environ 0067 __wenviron 006e ___wtomb_environ 008a _malloc 00c5 _findenv 00da _free 010a _realloc 0160 _strlen 0179 _strcpy 0199 __imp__SetEnvironmentVariableA@8"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 53 33 DB 3B C3 57 89 5D F0 75 05 83 C8 FF EB 61 56 8B 30 3B F3 89 75 FC 74 53 6A 3D 56 E8 ?? ?? ?? ?? 3B C3 59 59 89 45 F4 74 42 3B F0 74 3E 33 C9 38 58 01 A1 ?? ?? ?? ?? 0F 94 C1 3B 05 ?? ?? ?? ?? 89 4D F8 75 0C 8B F8 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 3B C3 75 55 39 5D 0C 74 19 39 1D ?? ?? ?? ?? 74 11 E8 ?? ?? ?? ?? 85 C0 74 3F 83 C8 FF 5E 5F 5B C9 C3 39 5D F8 74 04 33 C0 EB F2 6A 04 E8 ?? ?? ?? ?? 3B C3 59 A3 ?? ?? ?? ?? 74 DE 89 18 39 1D ?? ?? ?? ?? 75 13 6A 04 E8 ?? ?? ?? ?? 3B C3 59 A3 ?? ?? ?? ?? 74 C3 89 18 8B 7D F4 2B 7D FC FF 75 FC 8B 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 3B FB 59 7C 46 39 1E 74 42 8D 34 BE FF 36 E8 ?? ?? ?? ?? 39 5D F8 59 75 15 8B 45 FC 89 06 8B 45 08 89 18 EB 67 8B 46 04 89 06 47 83 C6 04 39 1E 75 F3 8B C7 C1 E0 02 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B C3 59 59 74 43 EB 3C 39 5D F8 0F 85 A3 00 00 00 3B FB 7D 02 F7 DF 8D 04 BD 08 00 00 00 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B C3 59 59 0F 84 34 FF FF FF 8B 55 FC 8D 0C B8 89 11 89 59 04 8B 4D 08 89 19 A3 ?? ?? ?? ?? 39 5D 0C 74 50 FF 75 FC E8 ?? ?? ?? ?? 40 40 50 E8 ?? ?? ?? ?? 8B F0 3B F3 59 59 74 38 FF 75 FC 56 E8 ?? ?? ?? ?? 8B C6 2B 45 FC 59 03 45 F4 59 8B 4D F8 88 18 40 F7 D9 1B C9 F7 D1 23 C8 51 56 FF 15 ?? ?? ?? ?? 85 C0 75 04 83 4D F0 FF 56 E8 ?? ?? ?? ?? 59 39 5D F8 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F0 E9 B7 FE FF FF FF 75 FC E8 ?? ?? ?? ?? 8B 45 08 59 89 18 E9 AE FE FF FF }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "__cenvarg"
		size = 525
		refs = "0012 _strlen 0026 _malloc 003c _errno 0046 __doserrno 007a _strcpy 00b2 __aenvptr 00bb ___crtGetEnvironmentStringsA 014a _free 01b3 _memcpy"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 57 6A 02 5E 8B FE EB 0E 50 E8 ?? ?? ?? ?? 59 8D 7C 07 01 83 C3 04 8B 03 85 C0 75 EC 57 E8 ?? ?? ?? ?? 85 C0 59 8B 4D 10 89 01 75 1C 8B 45 14 83 20 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 EB 78 8B 7D 0C 85 FF 75 54 8B 45 14 21 38 8B 5D 08 8B 7D 08 8B 45 10 8B 30 8B 45 08 89 45 10 8B 00 85 C0 0F 84 13 01 00 00 50 56 E8 ?? ?? ?? ?? 8B 45 08 FF 30 E8 ?? ?? ?? ?? 8D 74 06 01 8B 45 08 83 C4 0C 83 C0 04 89 45 10 E9 EE 00 00 00 50 E8 ?? ?? ?? ?? 59 8D 74 06 01 83 C7 04 8B 07 85 C0 75 EC A1 ?? ?? ?? ?? 85 C0 75 16 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 75 08 83 C8 FF E9 38 01 00 00 33 DB 38 18 74 22 8A 08 8B F8 80 F9 3D 74 19 57 E8 ?? ?? ?? ?? 8D 5C 03 01 A1 ?? ?? ?? ?? 8D 3C 18 59 8A 0F 84 C9 75 E2 8B FB 03 C3 EB 27 80 78 01 00 74 26 80 78 02 3A 75 20 80 78 03 3D 75 1A 83 C0 04 50 E8 ?? ?? ?? ?? 8D 7C 07 05 A1 ?? ?? ?? ?? 59 03 C7 80 38 3D 74 D4 8B C7 2B C3 03 C6 50 E8 ?? ?? ?? ?? 85 C0 59 8B 4D 14 89 01 0F 85 1E FF FF FF 8B 75 10 FF 36 E8 ?? ?? ?? ?? 83 26 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 83 C8 FF E9 9A 00 00 00 50 56 E8 ?? ?? ?? ?? 8B 45 10 FF 30 E8 ?? ?? ?? ?? 03 F0 83 C4 0C 83 45 10 04 C6 06 20 46 8B 45 10 8B 00 85 C0 75 D9 83 7D 0C 00 88 46 FF 88 06 8B 45 14 8B 30 74 3D 8B C7 2B C3 50 A1 ?? ?? ?? ?? 03 C3 50 56 E8 ?? ?? ?? ?? 2B FB 83 C4 0C 03 F7 8B 7D 0C EB 18 50 56 E8 ?? ?? ?? ?? FF 37 E8 ?? ?? ?? ?? 83 C4 0C 8D 74 06 01 83 C7 04 8B 07 85 C0 75 E2 85 F6 74 0E 8B 45 14 3B 30 75 04 C6 06 00 46 C6 06 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 33 C0 59 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "__global_unwind2"
		size = 32
		refs = "000c _gu_return 0014 _RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 53 56 57 55 6A 00 6A 00 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_344_1_0 {
	meta:
		name = "__unwind_handler"
		size = 34
	strings:
		$1 = { 8B 4C 24 04 F7 41 04 06 00 00 00 B8 01 00 00 00 74 0F 8B 44 24 08 8B 54 24 10 89 02 B8 03 00 00 00 C3 }
	condition:
		$1
}

rule file_344_2_0 {
	meta:
		name = "__local_unwind2"
		size = 104
		refs = "000b __unwind_handler"
	strings:
		$1 = { 53 56 57 8B 44 24 10 50 6A FE 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 8B 44 24 20 8B 58 08 8B 70 0C 83 FE FF 74 2E 3B 74 24 24 74 28 8D 34 76 8B 0C B3 89 4C 24 08 89 48 0C 83 7C B3 04 00 75 12 68 01 01 00 00 8B 44 B3 08 E8 40 00 00 00 FF 54 B3 08 EB C3 64 8F 05 00 00 00 00 83 C4 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_344_3_0 {
	meta:
		name = "__abnormal_termination"
		size = 35
		refs = "000c __unwind_handler"
	strings:
		$1 = { 33 C0 64 8B 0D 00 00 00 00 81 79 04 ?? ?? ?? ?? 75 10 8B 51 0C 8B 52 0C 39 51 08 75 05 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_344_5_0 {
	meta:
		name = "__NLG_Notify"
		size = 24
		refs = "0003 __NLG_Destination"
	strings:
		$1 = { 53 51 BB ?? ?? ?? ?? 8B 4D 08 89 4B 08 89 43 04 89 6B 0C 59 5B C2 04 00 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__mktemp"
		size = 175
		refs = "0010 __getpid 0026 __ismbstrail 0062 _errno 0077 __access"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 83 65 08 00 8B F7 E8 ?? ?? ?? ?? 80 3F 00 8B D8 74 33 46 80 3E 00 75 FA EB 2B 56 57 E8 ?? ?? ?? ?? 85 C0 59 59 75 23 80 3E 58 75 73 83 7D 08 05 7D 18 6A 0A 8B C3 33 D2 59 F7 F1 FF 45 08 80 C2 30 88 16 8B D8 4E 3B F7 73 D0 80 3E 58 75 50 83 7D 08 05 7C 4A C6 06 61 A1 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 6A 62 5B 89 45 08 6A 00 57 E8 ?? ?? ?? ?? 85 C0 59 59 74 09 83 3D ?? ?? ?? ?? 0D 75 11 33 C0 83 FB 7B A3 ?? ?? ?? ?? 74 07 88 1E 43 EB D8 8B C7 8B 4D 08 89 0D ?? ?? ?? ?? EB 02 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "__mbbtombc"
		size = 101
		refs = "0002 ___mbcodepage 001e _mbbtable 0040 _mbctable"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 8B 44 24 04 75 54 83 F8 20 72 0E 83 F8 7E 77 09 0F B7 04 45 ?? ?? ?? ?? C3 3D DC 00 00 00 75 06 B8 8F 83 00 00 C3 3D A1 00 00 00 72 2D 3D DF 00 00 00 77 26 8A 0D ?? ?? ?? ?? 33 D2 EB 0F 0F B6 C9 3B C1 74 0D 8A 0C 95 ?? ?? ?? ?? 42 84 C9 75 ED C3 0F B7 04 95 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_346_1_0 {
	meta:
		name = "__mbctombb"
		size = 119
		refs = "0002 ___mbcodepage 0016 _mbbtable 0030 _mbctable"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 8B 44 24 04 75 66 33 C9 0F B7 14 4D ?? ?? ?? ?? 3B C2 74 4B 41 83 F9 5E 7E EE 3D 96 83 00 00 56 77 49 33 F6 80 3D ?? ?? ?? ?? 00 74 3E 0F B7 14 B5 ?? ?? ?? ?? 8B C8 2B CA 74 28 33 D0 F6 C6 FF 75 10 85 C9 7E 0C 0F BE 14 B5 ?? ?? ?? ?? 2B CA 78 11 46 80 3C B5 ?? ?? ?? ?? 00 75 D0 5E C3 8D 41 20 C3 0F B6 04 B5 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "__wtof"
		size = 214
		refs = "0003 $T1558 0008 __SEH_prolog 001a _iswctype 0040 _wcstombs 005b __alloca_probe 0072 __resetstkoflw 007f _malloc 008c _errno 009b __real@0000000000000000 00b5 _atof 00c5 _free 00d1 __SEH_epilog"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 6A 08 8B 75 08 33 C0 66 8B 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 18 46 46 6A 08 33 C0 66 8B 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EB 89 75 08 53 56 53 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 89 75 E4 9B 89 5D FC 8D 44 36 02 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D E0 9B EB 3A 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 8B 75 E4 8D 44 36 02 50 E8 ?? ?? ?? ?? 59 8B F8 85 FF 75 17 C7 05 ?? ?? ?? ?? 0C 00 00 00 9B 83 4D FC FF DD 05 ?? ?? ?? ?? EB 2C 33 DB 43 83 4D FC FF 46 56 FF 75 08 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 10 DD 5D D8 85 DB 74 07 57 E8 ?? ?? ?? ?? 59 DD 45 D8 8D 65 CC E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "_iszerod"
		size = 24
	strings:
		$1 = { F7 44 24 08 FF FF FF 7F 75 0B 83 7C 24 04 00 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "_isinfd"
		size = 30
	strings:
		$1 = { 8B 44 24 08 25 FF FF FF 7F 3D 00 00 F8 7F 75 0B 83 7C 24 04 00 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "_issnand"
		size = 40
	strings:
		$1 = { 8B 44 24 08 25 00 00 F8 7F 3D 00 00 F0 7F 75 15 F7 44 24 08 FF FF 07 00 75 07 83 7C 24 04 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_348_3_0 {
	meta:
		name = "_isnand"
		size = 39
	strings:
		$1 = { 8B 4C 24 08 B8 00 00 F0 7F 23 C8 3B C8 75 15 F7 44 24 08 FF FF 0F 00 75 07 83 7C 24 04 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_348_5_0 {
	meta:
		name = "_isdenormald"
		size = 33
	strings:
		$1 = { 66 F7 44 24 0A F0 7F 75 15 F7 44 24 08 FF FF 0F 00 75 07 83 7C 24 04 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_348_6_0 {
	meta:
		name = "_isdenormalf"
		size = 26
	strings:
		$1 = { 66 F7 44 24 06 80 7F 75 0E F7 44 24 04 FF FF 7F 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_348_7_0 {
	meta:
		name = "_Fill_FPIEEE_RECORD"
		size = 193
	strings:
		$1 = { 8B 48 20 8B 50 10 33 11 83 E2 03 31 11 8B 50 14 8B 48 20 C1 E2 02 33 11 83 E2 1C 31 11 8B 10 8B 48 20 C1 EA 05 F7 D2 33 51 08 83 E2 01 31 51 08 8B 10 8B 48 20 C1 EA 03 F7 D2 33 51 08 83 E2 02 31 51 08 8B 10 8B 48 20 D1 EA F7 D2 33 51 08 83 E2 04 31 51 08 8B 10 8B 48 20 D1 E2 F7 D2 33 51 08 83 E2 08 31 51 08 8B 10 8B 48 20 C1 E2 04 F7 D2 33 51 08 83 E2 10 31 51 08 8B 48 20 83 61 0C FE 8B 48 20 83 61 0C FD 8B 48 20 83 61 0C FB 8B 48 20 83 61 0C F7 8B 48 20 83 61 0C EF 8B 48 20 83 61 04 FE 8B 48 20 83 61 04 FD 8B 48 20 83 61 04 FB 8B 48 20 83 61 04 F7 8B 40 20 83 60 04 EF C3 }
	condition:
		$1
}

rule file_348_8_0 {
	meta:
		name = "_XMMI2_FP_Emulation"
		size = 5272
		refs = "000c ___security_cookie 005e $L24695 0065 $L24775 0084 _isdenormald 0094 __real@0000000000000000 00c3 $L24776 0137 __control87 01c2 __statusfp 01e5 _Fill_FPIEEE_RECORD 020a _isnand 02bb _MIN_DOUBLE_NORMALA 02c1 _memcpy 02cb _MAX_DOUBLE_NORMALA 02db _POSINFDEA 02eb _NEGINFDEA 02fb _TWO_TO_1536A 030b _TWO_TO_M1536A 054b _ZERODA 0563 _NZERODA 063b @__security_check_cookie@4 071b $L24696 0722 $L24777 072f _issnand 07ed $L24697 07f4 $L24778 0868 $L24698 086f $L24779 0b79 _isdenormalf 0b89 __real@00000000 0efc _MIN_SINGLE_NORMALA 0f21 _MAX_SINGLE_NORMALA 1013 _ZEROFA 102b _NZEROFA 1401 $L24176 1405 $L24553 1409 $L24513 140d $L24269 1411 $L24332 1415 $L24411 1419 $L24443 141d $L24461 1421 $L24365 1425 $L24378 1448 $L24184 1450 $L24185 1458 $L24186 1460 $L24187 1468 $L24277 146c $L24282 1478 $L24328 147c $L24327"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC 94 00 00 00 A1 ?? ?? ?? ?? 53 56 89 45 70 57 DB E3 8B 75 7C 8B 46 20 8B 08 33 4E 10 83 65 00 00 83 65 F0 00 83 E1 03 31 08 8B 4E 14 8B 46 20 C1 E1 02 33 08 BB FF 0F 00 00 83 E1 1C 31 08 8B 4E 20 8B 11 C1 EA 05 23 D3 8D 7A BD 83 FF 1E 0F 87 D9 05 00 00 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7E 0C 00 DD 41 10 DD 5D 14 DD 41 30 DD 5D 0C 74 40 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C DD 45 14 DC 0D ?? ?? ?? ?? DD 5D 14 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C DD 45 0C DC 0D ?? ?? ?? ?? DD 5D 0C 83 FF 07 77 39 FF 24 BD ?? ?? ?? ?? 8B 01 25 3F 00 FE FF 83 C8 20 EB 24 8B 01 25 5F 00 FE FF 83 C8 40 EB 18 8B 01 25 7F 00 FE FF 83 C8 60 EB 0C 8B 01 25 9F 00 FE FF 0D 80 00 00 00 89 01 8B 46 10 83 E8 00 BF 00 01 00 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 12 B8 00 02 00 00 EB 0B 8B C7 EB 07 33 C0 EB 03 8B 45 7C 0D 1F 00 09 00 68 1F 03 0B 00 50 89 45 E4 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 23 C3 48 59 59 74 5D 48 74 3E 48 74 1F 48 75 6E DB E2 DD 45 14 DD 45 0C DE F9 DD 5D F8 DB E2 DD 45 14 DD 45 0C DE F9 DB 7D 1C EB 52 DB E2 DD 45 14 DD 45 0C DE C9 DD 5D F8 DB E2 DD 45 14 DD 45 0C DE C9 DB 7D 1C EB 36 DB E2 DD 45 14 DD 45 0C DE E9 DD 5D F8 DB E2 DD 45 14 DD 45 0C DE E9 DB 7D 1C EB 1A DB E2 DD 45 14 DD 45 0C DE C1 DD 5D F8 DB E2 DD 45 14 DD 45 0C DE C1 DB 7D 1C E8 ?? ?? ?? ?? A8 08 89 45 7C 74 08 25 FF FF F7 FF 89 45 7C 8B 16 33 DB 43 84 D3 75 23 A8 10 74 1F 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 09 5E 04 8B 76 20 83 4E 04 10 8B C3 E9 33 04 00 00 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 2C 04 00 00 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 15 04 00 00 F6 C2 02 75 13 F6 45 7E 08 74 0D 8B C6 E8 ?? ?? ?? ?? 83 4E 04 02 EB B3 F6 C2 04 75 21 F6 45 7C 08 74 1B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 08 83 4E 04 04 8B 76 20 83 4E 04 08 EB 8D DD 45 F8 51 51 DD 55 04 DD 14 24 E8 ?? ?? ?? ?? 85 C0 59 59 74 26 8B 46 20 09 58 60 8B 46 20 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE E9 3A 0F 00 00 F6 45 7E 08 DD D8 74 04 83 4E 04 02 6A 0A 8D 45 64 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 45 58 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 45 40 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 45 34 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 45 4C 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 45 28 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 48 DB 6D 1C DB 6D 64 D9 E0 DE D9 9B DD 7D E8 D9 EE DB 6D 1C DE D9 9B DD 7D E0 DB 6D 1C D9 EE DE D9 9B DD 7D EC DB 6D 64 DB 6D 1C DE D9 9B DD 7D F4 8B 45 E8 B9 00 45 00 00 66 23 C1 66 3B C7 75 0B 8B 45 E0 66 23 C1 66 3B C7 74 16 8B 45 EC 66 23 C1 66 3B C7 75 0E 8B 45 F4 66 23 C1 66 3B C7 75 03 89 5D 00 DB 6D 1C DB 6D 34 DE D9 9B DD 7D E8 DB 6D 58 D9 E0 DB 6D 1C DE D9 9B DD 7D E0 DB 6D 1C DB 6D 58 DE D9 9B DD 7D EC DB 6D 40 DB 6D 1C DE D9 9B DD 7D F4 8B 45 E8 66 23 C1 66 3B C7 75 0B 8B 45 E0 66 23 C1 66 3B C7 74 16 8B 45 EC 66 23 C1 66 3B C7 75 0E 8B 45 F4 66 23 C1 66 3B C7 75 03 89 5D F0 8B 06 A8 10 75 2C 83 7D 00 00 74 26 DB 6D 1C DB 6D 4C DE C9 DD 5D F8 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 02 8B 46 20 83 4E 04 10 83 48 04 02 EB 2E A8 08 75 51 83 7D F0 00 74 4B DB 6D 1C DB 6D 28 DE C9 DD 5D F8 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 8B 46 20 DD 45 F8 09 58 60 84 5D 7C 8B 46 20 DD 58 50 0F 84 A5 FD FF FF 8B 46 20 09 58 0C 83 4E 04 20 E9 96 FD FF FF 68 1F 03 0B 00 FF 75 E4 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 59 59 74 30 48 74 20 48 74 10 48 75 32 DD 45 14 DD 45 0C DE F9 DD 5D 04 EB 25 DD 45 14 DD 45 0C DE C9 DD 5D 04 EB 18 DD 45 14 DD 45 0C DE E9 DD 5D 04 EB 0B DD 45 14 DD 45 0C DE C1 DD 5D 04 E8 ?? ?? ?? ?? 8B C8 33 FF 84 CB 74 08 39 7D 00 74 03 83 C9 02 F6 06 20 0F 85 9C 00 00 00 84 CB 75 12 39 7E 08 0F 84 8F 00 00 00 39 7D 00 0F 84 86 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 39 7D 00 74 0B 8B 46 20 83 48 0C 02 83 4E 04 10 39 7D F0 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 7E 08 74 36 39 7D 00 74 31 DD 45 04 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 16 DD 45 04 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 09 DD 05 ?? ?? ?? ?? DD 5D 04 8B 46 20 DD 45 04 DD 58 50 E9 82 FC FF FF 8B 46 20 09 58 60 F6 C1 02 8B 46 20 74 0A 83 48 0C 02 83 4E 04 10 EB 04 83 60 0C FD F6 C1 04 8B 46 20 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 84 CB 8B 46 20 74 09 09 58 0C 83 4E 04 20 EB 04 83 60 0C FE 39 7E 08 74 4B 39 7D 00 74 46 DD 45 04 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 16 DD 45 04 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 09 DD 05 ?? ?? ?? ?? DD 5D 04 8B 46 20 09 58 0C 83 4E 04 20 8B 46 20 83 48 0C 02 83 4E 04 10 F6 C1 08 DD 45 04 8B 46 20 DD 58 50 8B 46 20 0F 84 54 0C 00 00 83 48 0C 08 83 4E 04 04 8B 76 20 83 66 0C EF 33 C0 8B 4D 70 5F 5E 5B E8 ?? ?? ?? ?? 83 C5 74 C9 C3 8B 46 20 DD 45 14 09 58 60 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 74 1D DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 74 0A DD 45 14 DD 5D F8 80 4D FE 08 8B 46 20 DD 45 F8 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 45 7C 10 74 86 E9 40 0B 00 00 83 7E 0C 00 DD 41 10 DD 5D 14 DD 41 30 DD 5D 0C 74 40 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 DD 45 14 D8 C9 DD 5D 14 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 DD 45 0C D8 C9 DD 5D 0C DD D8 8B 01 8B 7E 18 25 FF 00 FE FF 33 DB 83 E7 07 0D E0 00 00 00 43 83 FF 07 89 01 77 4A 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 19 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 05 21 45 7C EB 03 89 5D 7C E8 ?? ?? ?? ?? A8 10 74 03 89 5D 7C 33 D2 39 55 7C 74 08 84 1E 0F 84 71 FA FF FF DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 05 01 00 00 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 EE 00 00 00 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 A7 0B 00 00 DD 45 14 DC 5D 0C DF E0 F6 C4 05 7A 4F 83 FF 07 0F 87 8F 00 00 00 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 50 FF FF FF DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 39 FF FF FF 21 45 7C 33 D2 E9 41 FF FF FF DD 45 14 DC 5D 0C DF E0 F6 C4 41 75 14 83 FF 03 76 31 83 FF 07 77 32 83 4D 04 FF 83 4D 08 FF EB 28 DD 45 0C DD 45 14 DA E9 DF E0 F6 C4 44 7A 19 83 FF 07 77 14 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 89 55 04 89 55 08 8B 46 20 DD 45 04 09 58 60 8B 46 20 DD 58 50 E9 D2 09 00 00 83 FF 02 76 0A 83 FF 06 76 3E 83 FF 07 75 06 89 55 04 89 55 08 8B 46 20 DD 45 04 09 58 60 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 39 55 7C E9 CE FD FF FF 83 4D 04 FF 83 4D 08 FF EB C3 83 7E 0C 00 DD 41 10 DD 5D 14 DD 41 30 DD 5D 0C 74 40 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 DD 45 14 D8 C9 DD 5D 14 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 08 DD 45 0C D8 C9 DD 5D 0C DD D8 83 EA 53 6A 01 5B 74 3E 4A 75 65 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 18 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 04 33 FF EB 02 8B FB E8 ?? ?? ?? ?? A8 10 74 31 8B FB EB 2D DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 75 E9 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 75 D6 33 FF EB 03 8B 7D 7C 8B 46 20 8B 08 81 E1 FF 00 FE FF 81 C9 E0 00 00 00 85 FF 89 08 74 08 84 1E 0F 84 1F F8 FF FF DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 A3 00 00 00 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 8C 00 00 00 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 55 09 00 00 DD 45 14 DC 5D 0C DF E0 F6 C4 41 75 0B 66 81 66 1C 2A F7 E9 21 08 00 00 DD 45 14 DC 5D 0C DF E0 F6 C4 05 7A 0C 8B 46 1C 25 2B F7 FF FF 0B C3 EB 1E DD 45 0C DD 45 14 DA E9 DF E0 F6 C4 44 0F 8A F5 07 00 00 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C E9 E2 07 00 00 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 85 FF E9 F5 FB FF FF 8B 41 10 89 45 E4 8B 46 10 83 E8 00 BF 00 01 00 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 12 B8 00 02 00 00 EB 0B 8B C7 EB 07 33 C0 EB 03 8B 45 7C 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 DB 45 E4 D9 5D 7C E8 ?? ?? ?? ?? 33 DB 43 F6 06 20 75 35 84 C3 74 31 8B C6 E8 ?? ?? ?? ?? 8B 46 20 8B 08 81 E1 1F 01 FE FF 0B CF 89 08 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 E9 F3 04 00 00 8B 4E 20 D9 45 7C 09 59 60 8B 4E 20 D9 59 50 84 C3 8B 46 20 0F 84 09 07 00 00 09 58 0C 83 4E 04 20 E9 01 07 00 00 83 7E 0C 00 D9 41 10 D9 5D 7C 74 1F D9 45 7C 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C D9 45 7C D8 0D ?? ?? ?? ?? D9 5D 7C 83 EA 5E BF 00 01 00 00 74 0E 4A 75 19 8B 01 25 1F 01 FE FF 0B C7 EB 0C 8B 01 25 5F 05 FE FF 0D 40 05 00 00 89 01 8B 46 20 8B 00 C1 E8 05 23 C3 83 F8 08 74 0C 83 F8 2A 75 23 BF 00 03 00 00 EB 1F 8B 46 10 83 E8 00 74 10 48 74 14 48 74 03 48 EB E6 BF 00 02 00 00 EB 07 33 FF EB 03 8B 7D 7C 81 CF 1F 00 0A 00 68 1F 03 0B 00 57 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 7C DB 5D F4 E8 ?? ?? ?? ?? 33 DB 43 84 1E 75 08 A8 10 0F 85 C3 F5 FF FF 8B 55 F4 8B 4E 20 89 51 50 F6 06 20 75 08 84 C3 0F 85 64 07 00 00 8B 4E 20 09 59 60 84 C3 8B 4E 20 0F 84 88 01 00 00 09 59 0C 83 4E 04 20 E9 80 01 00 00 83 7E 0C 00 DD 41 10 DD 5D 14 74 20 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C DD 45 14 DC 0D ?? ?? ?? ?? DD 5D 14 83 FA 55 BF 00 01 00 00 72 1F 83 FA 56 76 0F 83 FA 58 76 30 83 FA 60 74 2B 83 FA 61 75 0B 8B 01 25 1F 01 FE FF 0B C7 89 01 8B 46 20 8B 00 C1 E8 05 23 C3 83 F8 08 74 1A 83 F8 2A 75 31 BF 00 03 00 00 EB 2D 8B 01 25 5F 05 FE FF 0D 40 05 00 00 EB D5 8B 46 10 83 E8 00 74 10 48 74 14 48 74 03 48 EB D8 BF 00 02 00 00 EB 07 33 FF EB 03 8B 7D 7C 81 CF 1F 00 09 00 68 1F 03 0B 00 57 E8 ?? ?? ?? ?? 59 59 DB E2 DD 45 14 DB 5D F4 E9 FC FE FF FF 83 7E 0C 00 D9 41 10 D9 5D 7C 74 1F D9 45 7C 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C D9 45 7C D8 0D ?? ?? ?? ?? D9 5D 7C 8B 01 25 1F 01 FE FF BF 00 01 00 00 0B C7 89 01 8B 46 10 83 E8 00 74 17 48 74 1B 48 74 0A 48 75 12 BF 00 03 00 00 EB 0E BF 00 02 00 00 EB 07 33 FF EB 03 8B 7D 7C 68 1F 03 0B 00 81 CF 1F 00 09 00 57 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 7C DD 5D 04 E8 ?? ?? ?? ?? 8B 0E 33 DB 43 84 CB 75 08 A8 10 0F 85 41 F4 FF FF 8B D0 81 E2 00 00 08 00 74 04 83 4E 04 02 F6 C1 02 75 08 85 D2 0F 85 BF 05 00 00 8B 4E 20 DD 45 04 DD 59 50 8B 4E 20 09 59 60 8B 4E 20 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 E9 B5 F8 FF FF 83 7E 0C 00 DD 41 10 DD 5D 14 74 20 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C DD 45 14 DC 0D ?? ?? ?? ?? DD 5D 14 8B 01 25 1F 01 FE FF BF 00 01 00 00 0B C7 89 01 8B 46 10 83 E8 00 74 17 48 74 1B 48 74 0A 48 75 12 BF 00 03 00 00 EB 0E BF 00 02 00 00 EB 07 33 FF EB 03 8B 7D 7C 68 1F 03 0B 00 81 CF 1F 00 0A 00 57 E8 ?? ?? ?? ?? 59 59 DB E2 DD 45 14 D9 5D 7C E8 ?? ?? ?? ?? 33 DB 8B D0 8B 06 43 84 C3 75 09 F6 C2 10 0F 85 5E F3 FF FF 8B CA 81 E1 00 00 08 00 6A 02 5F 74 03 09 7E 04 A8 02 75 08 85 C9 0F 85 DB 04 00 00 DD 45 14 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 2A 02 00 00 DD 45 14 B8 FF FF FF 7F DD 5D F8 8B 4D FC 23 C8 81 F9 00 00 F8 7F 75 0A 83 7D F8 00 0F 84 08 02 00 00 DD 45 14 DD 5D F8 85 45 FC 75 0A 83 7D F8 00 0F 84 F3 01 00 00 DB E2 DD 45 14 D9 E8 DE C9 DD 5D F8 DD 05 ?? ?? ?? ?? D9 E0 DC 5D F8 DF E0 F6 C4 05 7A 13 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 03 89 5D 00 DD 05 ?? ?? ?? ?? D9 C0 D9 E0 DC 5D F8 DF E0 F6 C4 41 74 0C DC 5D F8 DF E0 F6 C4 05 7A 07 EB 02 DD D8 89 5D F0 8B 06 A8 10 75 1F 83 7D 00 00 74 19 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 78 0C 8B 46 20 83 4E 04 10 09 78 04 EB 23 A8 08 75 2B 83 7D F0 00 74 25 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 8B 76 20 83 66 60 FE E9 62 F2 FF FF A8 20 0F 85 A0 00 00 00 84 D3 75 14 83 7E 08 00 0F 84 92 00 00 00 83 7D 00 00 0F 84 88 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 83 7D 00 00 74 0A 8B 46 20 09 78 0C 83 4E 04 10 33 C9 39 4D F0 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 4E 08 74 36 39 4D 00 74 }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "_memcmp"
		size = 184
	strings:
		$1 = { 8B 44 24 0C 85 C0 74 4A 8B 54 24 04 56 57 8B F2 8B 7C 24 10 0B D7 83 E2 03 74 38 A9 01 00 00 00 74 11 8A 0E 3A 0F 75 58 83 C6 01 83 C7 01 83 E8 01 74 1D 8A 0E 8A 17 38 D1 75 45 8A 4E 01 8A 57 01 38 D1 75 3B 83 C7 02 83 C6 02 83 E8 02 75 E3 5F 5E C3 8B C8 83 E0 03 C1 E9 02 74 2B F3 A7 74 27 8B 4E FC 8B 57 FC 38 D1 75 10 38 F5 75 0C C1 E9 10 C1 EA 10 38 D1 75 02 38 F5 B8 00 00 00 00 1B C0 5F 83 D8 FF 5E C3 85 C0 74 C4 8B 16 8B 0F 38 CA 75 E7 83 E8 01 74 1C 38 EE 75 DE 83 E8 01 74 13 81 E1 00 00 FF 00 81 E2 00 00 FF 00 3B D1 75 C9 83 E8 01 5F 5E C3 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "__wchdir"
		size = 324
		refs = "0006 $T20401 000b __SEH_prolog 0010 ___security_cookie 0031 __imp__SetCurrentDirectoryW@4 0047 __imp__GetCurrentDirectoryW@8 0069 __alloca_probe 0082 __resetstkoflw 0092 _malloc 00e6 _towupper 0100 __imp__SetEnvironmentVariableW@8 0110 __imp__GetLastError@0 0116 __dosmaperr 0125 _free 013a @__security_check_cookie@4 013f __SEH_epilog"
	strings:
		$1 = { 68 30 02 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 8D BD D0 FD FF FF 33 DB 89 9D C8 FD FF FF 83 8D CC FD FF FF FF FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D1 00 00 00 8B C7 50 68 05 01 00 00 FF 15 ?? ?? ?? ?? 8B F0 89 B5 C4 FD FF FF 81 FE 04 01 00 00 7E 65 89 5D FC 8D 44 36 02 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 BD C0 FD FF FF EB 33 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 8B B5 C4 FD FF FF 8D 44 36 02 50 E8 ?? ?? ?? ?? 59 8B F8 33 DB 3B FB 75 04 33 F6 EB 0A C7 85 C8 FD FF FF 01 00 00 00 83 4D FC FF 3B F3 74 59 57 46 56 FF 15 ?? ?? ?? ?? 8B F0 3B F3 74 4A 66 8B 07 66 3D 5C 00 74 06 66 3D 2F 00 75 06 66 3B 47 02 74 2F 66 C7 45 DC 3D 00 33 C0 66 8B 07 50 E8 ?? ?? ?? ?? 59 66 89 45 DE 66 C7 45 E0 3A 00 66 89 5D E2 57 8D 45 DC 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 89 9D CC FD FF FF FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 39 9D C8 FD FF FF 74 07 57 E8 ?? ?? ?? ?? 59 8B 85 CC FD FF FF 8D A5 B4 FD FF FF 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "??1type_info@@UAE@XZ"
		size = 21
		refs = "0002 ??_7type_info@@6B@ 000f _free"
	strings:
		$1 = { C7 01 ?? ?? ?? ?? 8B 49 04 85 C9 74 07 51 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_353_1_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1type_info@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_18_0 {
	meta:
		name = "??_G__non_rtti_object@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1__non_rtti_object@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_16_0 {
	meta:
		name = "??_Gbad_cast@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1bad_cast@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_17_0 {
	meta:
		name = "??_Gbad_typeid@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1bad_typeid@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_14_0 {
	meta:
		name = "??_Gexception@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1exception@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_353_2_0 {
	meta:
		name = "??8type_info@@QBEHABV0@@Z"
		size = 27
		refs = "000d _strcmp"
	strings:
		$1 = { 8B 44 24 04 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 40 C2 04 00 }
	condition:
		$1
}

rule file_353_3_0 {
	meta:
		name = "??9type_info@@QBEHABV0@@Z"
		size = 28
		refs = "000d _strcmp"
	strings:
		$1 = { 8B 44 24 04 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 F7 D8 C2 04 00 }
	condition:
		$1
}

rule file_353_4_0 {
	meta:
		name = "?before@type_info@@QBEHABV1@@Z"
		size = 31
		refs = "000d _strcmp"
	strings:
		$1 = { 8B 44 24 04 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? 59 59 33 C9 85 C0 0F 9F C1 8B C1 C2 04 00 }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__filwbuf"
		size = 233
		refs = "0035 __getbuf 004b __read 007c ___pioinfo 0089 ___badioinfo"
	strings:
		$1 = { 56 8B 74 24 08 8B 46 0C A8 83 0F 84 D2 00 00 00 A8 40 0F 85 CA 00 00 00 A8 02 74 0B 83 C8 20 89 46 0C E9 BB 00 00 00 83 C8 01 66 A9 0C 01 89 46 0C 75 09 56 E8 ?? ?? ?? ?? 59 EB 05 8B 46 08 89 06 FF 76 18 FF 76 08 FF 76 10 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 89 46 04 74 78 83 F8 01 74 73 83 F8 FF 74 6E 8B 56 0C F6 C2 82 75 37 8B 4E 10 83 F9 FF 57 74 14 8B F9 C1 FF 05 8B 3C BD ?? ?? ?? ?? 83 E1 1F 8D 3C CF EB 05 BF ?? ?? ?? ?? 8A 4F 04 80 E1 82 80 F9 82 5F 75 09 81 CA 00 20 00 00 89 56 0C 81 7E 18 00 02 00 00 75 14 8B 4E 0C F6 C1 08 74 0C F6 C5 04 75 07 C7 46 18 00 10 00 00 8B 0E 83 C0 FE 89 46 04 0F B7 01 83 C1 02 89 0E 5E C3 F7 D8 1B C0 83 E0 10 83 C0 10 09 46 0C 83 66 04 00 B8 FF FF 00 00 5E C3 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "_rename"
		size = 46
		refs = "000a __imp__MoveFileA@8 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "__wrename"
		size = 46
		refs = "000a __imp__MoveFileW@8 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "__rmdir"
		size = 42
		refs = "0006 __imp__RemoveDirectoryA@4 0010 __imp__GetLastError@0 001e __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_556_0_0 {
	meta:
		name = "__wremove"
		size = 42
		refs = "0006 __imp__DeleteFileW@4 0010 __imp__GetLastError@0 001e __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_512_0_0 {
	meta:
		name = "__wrmdir"
		size = 42
		refs = "0006 __imp__RemoveDirectoryW@4 0010 __imp__GetLastError@0 001e __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "_remove"
		size = 42
		refs = "0006 __imp__DeleteFileA@4 0010 __imp__GetLastError@0 001e __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__wspawnvpe"
		size = 319
		refs = "0012 __wspawnve 0027 _errno 0038 _wcschr 0048 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 004d __wgetenv 0063 _malloc 008c _wcslen 00a5 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 00ab _wcscat 011e __wgetpath 0132 _free"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 89 45 F8 0F 85 15 01 00 00 83 3D ?? ?? ?? ?? 02 0F 85 08 01 00 00 6A 2F FF 75 0C E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 F4 00 00 00 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 84 DD 00 00 00 56 68 08 02 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 59 0F 84 C6 00 00 00 53 BB 03 01 00 00 53 56 57 E9 9D 00 00 00 66 83 3E 00 0F 84 A6 00 00 00 56 E8 ?? ?? ?? ?? 8D 44 46 FE 66 8B 00 66 3D 5C 00 59 74 13 66 3D 2F 00 74 0D 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 56 E8 ?? ?? ?? ?? FF 75 0C 8B F8 E8 ?? ?? ?? ?? 03 F8 81 FF 04 01 00 00 59 59 73 63 FF 75 0C 56 E8 ?? ?? ?? ?? FF 75 14 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 83 F8 FF 89 45 F8 75 40 83 3D ?? ?? ?? ?? 02 74 1F 66 8B 06 66 3D 5C 00 74 06 66 3D 2F 00 75 28 66 8B 46 02 66 3D 5C 00 74 06 66 3D 2F 00 75 18 53 56 FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 89 45 FC 0F 85 50 FF FF FF 56 E8 ?? ?? ?? ?? 59 5B 5E 5F 8B 45 F8 C9 C3 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "__CRT_INIT@12"
		size = 267
		refs = "0014 __alloca_probe 0023 __imp__GetVersionExA@4 0030 __osplatform 0038 __winmajor 0041 __winminor 0053 __osver 006e __winver 0073 __heap_init 007d __RTC_Initialize 0083 __imp__GetCommandLineA@0 0088 __acmdln 008d ___crtGetEnvironmentStringsA 0092 __aenvptr 0097 __ioinit 00a0 __heap_term 00a9 __setargv 00b2 __setenvp 00bc __cinit 00c7 ___proc_attached 00d7 __ioterm 00f4 __C_Termination_Done 00fb __cexit"
	strings:
		$1 = { 55 8B EC 83 7D 0C 01 56 0F 85 CF 00 00 00 B8 94 00 00 00 E8 ?? ?? ?? ?? 8B F4 56 C7 06 94 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 79 8B 4E 10 89 0D ?? ?? ?? ?? 8B 46 04 A3 ?? ?? ?? ?? 8B 56 08 89 15 ?? ?? ?? ?? 8B 76 0C 81 E6 FF 7F 00 00 83 F9 02 89 35 ?? ?? ?? ?? 74 0C 81 CE 00 80 00 00 89 35 ?? ?? ?? ?? C1 E0 08 03 C2 33 F6 56 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 28 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 09 E8 ?? ?? ?? ?? 33 C0 EB 26 E8 ?? ?? ?? ?? 85 C0 7C 25 E8 ?? ?? ?? ?? 85 C0 7C 1C 56 E8 ?? ?? ?? ?? 85 C0 59 75 11 FF 05 ?? ?? ?? ?? 33 C0 40 8D 65 FC 5E 5D C2 0C 00 E8 ?? ?? ?? ?? EB C2 33 F6 39 75 0C 75 E7 39 35 ?? ?? ?? ?? 7E B8 FF 0D ?? ?? ?? ?? 39 35 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB C0 }
	condition:
		$1
}

rule file_358_1_0 {
	meta:
		name = "__DllMainCRTStartup@12"
		size = 228
		refs = "0003 $T20501 0008 __SEH_prolog 001d ___proc_attached 0034 __pRawDllMain 0059 __CRT_INIT@12 006d _DllMain@12 00cc ___CppXcptFilter 00dd __SEH_epilog"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 40 89 45 E4 8B 75 0C 33 FF 3B F7 75 0C 39 3D ?? ?? ?? ?? 0F 84 B3 00 00 00 89 7D FC 3B F0 74 05 83 FE 02 75 31 A1 ?? ?? ?? ?? 3B C7 74 0C FF 75 10 56 FF 75 08 FF D0 89 45 E4 39 7D E4 0F 84 85 00 00 00 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 89 45 E4 3B C7 74 72 8B 5D 10 53 56 FF 75 08 E8 ?? ?? ?? ?? 89 45 E4 83 FE 01 75 0E 3B C7 75 0A 53 57 FF 75 08 E8 ?? ?? ?? ?? 3B F7 74 05 83 FE 03 75 29 53 56 FF 75 08 E8 ?? ?? ?? ?? 85 C0 75 03 89 7D E4 39 7D E4 74 13 A1 ?? ?? ?? ?? 3B C7 74 0A 53 56 FF 75 08 FF D0 89 45 E4 83 4D FC FF 8B 45 E4 EB 1A 8B 45 EC 8B 08 8B 09 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 83 4D FC FF 33 C0 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_358_2_0 {
	meta:
		name = "__amsg_exit"
		size = 51
		refs = "0001 ___error_mode 0010 ___app_type 0018 __FF_MSGBANNER 0021 __NMSG_WRITE 002c __aexit_rtn"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 01 74 0D 85 C0 75 0E 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? FF 74 24 04 E8 ?? ?? ?? ?? 68 FF 00 00 00 FF 15 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_359_1_0 {
	meta:
		name = "__wspawnve"
		size = 323
		refs = "0011 _wcsrchr 002e _wcschr 003c _wcslen 0046 _malloc 0053 ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 0059 _wcscpy 0060 _wcscat 008c __waccess 00a6 _wcomexecmd 00e6 _ext_strings 0128 _free"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 0C 56 57 6A 5C 53 8B FB E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 46 85 F6 75 4C 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 75 3C 53 E8 ?? ?? ?? ?? 8D 44 00 06 50 E8 ?? ?? ?? ?? 8B F8 85 FF 59 59 74 78 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 53 57 E8 ?? ?? ?? ?? 83 C4 10 8D 77 04 EB 0A 85 F6 74 04 3B C6 76 02 8B F0 83 4D FC FF 6A 2E 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 2A 6A 00 57 E8 ?? ?? ?? ?? 83 F8 FF 59 59 0F 84 95 00 00 00 FF 75 14 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC EB 7E 57 E8 ?? ?? ?? ?? 8D 44 00 0A 50 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 75 05 83 C8 FF EB 6F 57 56 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8D 04 46 83 C4 0C 89 45 F8 BB ?? ?? ?? ?? FF 33 FF 75 F8 E8 ?? ?? ?? ?? 6A 00 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 0D 83 EB 04 81 FB ?? ?? ?? ?? 7D DB EB 15 FF 75 14 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 56 E8 ?? ?? ?? ?? 8B 5D 0C 59 3B FB 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "_$I10_OUTPUT"
		size = 654
		refs = "0007 ___security_cookie 00a5 ??_C@_06PGGFOGJG@1?$CDSNAN?$AA@ 00bf ??_C@_05PHHOCPM@1?$CDIND?$AA@ 00d0 ??_C@_05DNEBIAHO@1?$CDINF?$AA@ 00d9 _strcpy 00ed ??_C@_06IMKFLFPG@1?$CDQNAN?$AA@ 0142 ___multtenpow12 015b ___ld12mul 01a2 ___shl_12 01bf ___shr_12 01fb ___add_12 0262 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 89 45 FC 8B 45 10 53 8B 5D 1C 56 8B C8 BE FF 7F 00 00 81 E1 00 80 00 00 23 C6 66 85 C9 57 C6 45 E4 CC C6 45 E5 CC C6 45 E6 CC C6 45 E7 CC C6 45 E8 CC C6 45 E9 CC C6 45 EA CC C6 45 EB CC C6 45 EC CC C6 45 ED CC C6 45 EE FB C6 45 EF 3F C7 45 D4 01 00 00 00 8B D0 74 06 C6 43 02 2D EB 04 C6 43 02 20 66 85 D2 8B 7D 0C 75 0D 85 FF 75 09 39 7D 08 0F 84 F3 00 00 00 66 3B D6 75 78 B8 00 00 00 80 3B F8 66 C7 03 01 00 75 06 83 7D 08 00 74 0F F7 C7 00 00 00 40 75 07 68 ?? ?? ?? ?? EB 46 66 85 C9 74 15 81 FF 00 00 00 C0 75 0D 83 7D 08 00 75 2E 68 ?? ?? ?? ?? EB 0F 3B F8 75 23 83 7D 08 00 75 1D 68 ?? ?? ?? ?? 8D 43 04 50 E8 ?? ?? ?? ?? C6 43 03 05 83 65 D4 00 59 59 E9 6C 01 00 00 68 ?? ?? ?? ?? 8D 43 04 50 E8 ?? ?? ?? ?? C6 43 03 06 EB E1 0F B7 C2 8B F0 69 C0 10 4D 00 00 66 83 65 F0 00 8B CF C1 E9 18 C1 EE 08 8D 0C 4E 6B C9 4D 8D B4 01 0C ED BC EC 8B 45 08 89 45 F2 C1 FE 10 0F BF C6 F7 D8 6A 01 50 8D 45 F0 50 66 89 55 FA 89 7D F6 E8 ?? ?? ?? ?? 83 C4 0C 66 81 7D FA FF 3F 72 10 8D 45 E4 50 8D 45 F0 50 46 E8 ?? ?? ?? ?? 59 59 F6 45 18 01 8B 7D 14 66 89 33 74 12 0F BF C6 03 F8 85 FF 7F 09 C6 43 04 30 E9 FA 00 00 00 83 FF 15 7E 03 6A 15 5F 0F B7 75 FA 81 EE FE 3F 00 00 66 83 65 FA 00 C7 45 10 08 00 00 00 8D 45 F0 50 E8 ?? ?? ?? ?? FF 4D 10 59 75 F1 85 F6 7D 17 F7 DE 81 E6 FF 00 00 00 7E 0D 8D 45 F0 50 E8 ?? ?? ?? ?? 4E 59 75 F3 8D 4F 01 85 C9 8D 43 04 89 45 D0 7E 50 89 4D 10 8D 75 F0 8D 7D D8 A5 A5 8D 45 F0 50 A5 E8 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 8D 45 D8 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 8A 45 FB 8B 4D D0 04 30 83 C4 14 FF 45 D0 FF 4D 10 88 01 C6 45 FB 00 75 B6 8B 45 D0 48 8A 08 48 80 F9 35 8D 4B 04 7C 3E EB 09 80 38 39 75 08 C6 00 30 48 3B C1 73 F3 3B C1 73 04 40 66 FF 03 FE 00 2A C3 2C 03 88 43 03 0F BE C0 C6 44 18 04 00 8B 45 D4 8B 4D FC 5F 5E 5B E8 ?? ?? ?? ?? C9 C3 80 38 30 75 05 48 3B C1 73 F6 3B C1 73 D3 C6 01 30 66 83 23 00 33 C0 C6 43 02 20 C6 43 03 01 C6 43 05 00 40 EB CD }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "__putenv"
		size = 199
		refs = "000a ___env_initialized 0017 _strlen 001e _malloc 0030 _strcpy 003b ___crtsetenv 004f _free 005b __wenviron 0065 __imp__MultiByteToWideChar@24 00a3 ___crtwsetenv"
	strings:
		$1 = { 55 8B EC 51 51 57 33 FF 39 3D ?? ?? ?? ?? 89 7D F8 74 41 FF 75 08 E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 3B C7 59 59 89 45 F8 74 29 FF 75 08 50 E8 ?? ?? ?? ?? 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 13 39 7D F8 74 09 FF 75 F8 E8 ?? ?? ?? ?? 59 83 C8 FF EB 6B 39 3D ?? ?? ?? ?? 53 56 74 5D 8B 35 ?? ?? ?? ?? 57 57 6A FF FF 75 08 89 7D FC 57 57 FF D6 8B D8 3B DF 74 3E 8D 04 1B 50 E8 ?? ?? ?? ?? 3B C7 59 89 45 FC 74 2D 53 50 6A FF FF 75 08 57 57 FF D6 85 C0 74 15 8D 45 FC 57 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 13 39 7D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5E 5B 5F C9 C3 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "_write_char"
		size = 23
		refs = "0005 __putwch"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? 66 3D FF FF 59 75 04 83 0E FF C3 FF 06 C3 }
	condition:
		$1
}

rule file_363_1_0 {
	meta:
		name = "_write_multi_char"
		size = 33
		refs = "000e _write_char"
	strings:
		$1 = { 56 8B F0 EB 13 FF 74 24 08 FF 4C 24 10 E8 ?? ?? ?? ?? 83 3E FF 59 74 07 83 7C 24 0C 00 7F E6 5E C3 }
	condition:
		$1
}

rule file_363_2_0 {
	meta:
		name = "_write_string"
		size = 41
		refs = "0013 _write_char"
	strings:
		$1 = { 56 57 8B F0 8B F9 EB 17 FF 4C 24 0C 33 C0 66 8B 07 50 E8 ?? ?? ?? ?? 47 47 83 3E FF 59 74 07 83 7C 24 0C 00 7F E2 5F 5E C3 }
	condition:
		$1
}

rule file_363_5_0 {
	meta:
		name = "_output"
		size = 2028
		refs = "000f ___security_cookie 0070 ___lookuptable 0099 $L2720 0249 _write_char 02cc ___nullstring 02ed __pctype 0360 ___mb_cur_max 0374 _mbtowc 0443 _malloc 0482 __cfltcvt_tab 04c3 _strlen 0512 ___wnullstring 0660 __aulldvrm 06f5 _write_multi_char 0705 _write_string 0798 _free 07c0 @__security_check_cookie@4 07cc $NORMAL_STATE$2348 07d0 $L2349 07d4 $L2350 07d8 $L2360 07dc $L2364 07e0 $L2365 07e4 $L2369 07e8 $L2385"
	strings:
		$1 = { 55 8D AC 24 28 FC FF FF 81 EC 58 04 00 00 A1 ?? ?? ?? ?? 8B 8D E0 03 00 00 53 66 8B 19 56 8B B5 E4 03 00 00 89 85 D4 03 00 00 33 C0 57 33 FF 66 3B D8 89 45 C4 89 45 C0 89 45 A8 0F 84 72 07 00 00 EB 09 8B B5 E4 03 00 00 8B 7D 98 41 41 83 7D C0 00 89 8D E0 03 00 00 0F 8C 55 07 00 00 66 83 FB 20 72 17 66 83 FB 78 77 11 0F B7 C3 0F BE 80 ?? ?? ?? ?? 83 E0 0F 33 D2 EB 04 33 D2 33 C0 0F BE 84 C7 ?? ?? ?? ?? C1 F8 04 83 F8 07 89 45 98 0F 87 0B 07 00 00 FF 24 85 ?? ?? ?? ?? 83 4D CC FF 89 55 94 89 55 9C 89 55 B0 89 55 BC 89 55 D0 89 55 B8 E9 E9 06 00 00 0F B7 C3 83 E8 20 74 3B 83 E8 03 74 2D 83 E8 08 74 1F 48 48 74 12 83 E8 03 0F 85 CA 06 00 00 83 4D D0 08 E9 C1 06 00 00 83 4D D0 04 E9 B8 06 00 00 83 4D D0 01 E9 AF 06 00 00 80 4D D0 80 E9 A6 06 00 00 83 4D D0 02 E9 9D 06 00 00 66 83 FB 2A 75 25 83 C6 04 89 B5 E4 03 00 00 8B 76 FC 3B F2 89 75 B0 0F 8D 80 06 00 00 83 4D D0 04 F7 DE 89 75 B0 E9 72 06 00 00 8B 45 B0 0F B7 CB 8D 04 80 8D 44 41 D0 89 45 B0 E9 5D 06 00 00 89 55 CC E9 55 06 00 00 66 83 FB 2A 75 20 83 C6 04 89 B5 E4 03 00 00 8B 76 FC 3B F2 89 75 CC 0F 8D 38 06 00 00 83 4D CC FF E9 2F 06 00 00 8B 45 CC 0F B7 CB 8D 04 80 8D 44 41 D0 89 45 CC E9 1A 06 00 00 0F B7 C3 83 F8 49 74 2E 83 F8 68 74 20 83 F8 6C 74 12 83 F8 77 0F 85 FF 05 00 00 80 4D D1 08 E9 F6 05 00 00 83 4D D0 10 E9 ED 05 00 00 83 4D D0 20 E9 E4 05 00 00 66 8B 01 66 3D 36 00 75 19 66 83 79 02 34 75 12 83 C1 04 80 4D D1 80 89 8D E0 03 00 00 E9 C2 05 00 00 66 3D 33 00 75 19 66 83 79 02 32 75 12 83 C1 04 80 65 D1 7F 89 8D E0 03 00 00 E9 A3 05 00 00 66 3D 64 00 0F 84 99 05 00 00 66 3D 69 00 0F 84 8F 05 00 00 66 3D 6F 00 0F 84 85 05 00 00 66 3D 75 00 0F 84 7B 05 00 00 66 3D 78 00 0F 84 71 05 00 00 66 3D 58 00 0F 84 67 05 00 00 89 55 98 53 8D 75 C0 C7 45 B8 01 00 00 00 E8 ?? ?? ?? ?? E9 4E 05 00 00 0F B7 C3 83 F8 67 0F 8F 6F 02 00 00 83 F8 65 0F 8D AD 00 00 00 83 F8 58 0F 8F 14 01 00 00 0F 84 CB 02 00 00 83 E8 43 0F 84 B5 00 00 00 48 48 0F 84 83 00 00 00 48 48 74 7F 83 E8 0C 0F 85 10 04 00 00 66 F7 45 D0 30 08 75 04 83 4D D0 20 8B 55 CC 83 FA FF 75 05 BA FF FF FF 7F 83 C6 04 F6 45 D0 20 89 B5 E4 03 00 00 8B 76 FC 89 75 C8 0F 84 46 02 00 00 85 F6 75 09 8B 35 ?? ?? ?? ?? 89 75 C8 83 65 C4 00 85 D2 8B C6 0F 8E C3 03 00 00 8A 08 84 C9 0F 84 B9 03 00 00 8B 35 ?? ?? ?? ?? 0F B6 C9 F6 44 4E 01 80 74 01 40 40 FF 45 C4 39 55 C4 7C DC E9 9A 03 00 00 C7 45 94 01 00 00 00 83 C3 20 83 4D D0 40 83 7D CC 00 8D 7D D4 89 7D C8 0F 8D EA 00 00 00 C7 45 CC 06 00 00 00 E9 29 01 00 00 66 F7 45 D0 30 08 75 04 83 4D D0 20 83 C6 04 33 C0 66 8B 46 FC 33 FF 47 F6 45 D0 20 89 7D B8 89 B5 E4 03 00 00 89 45 90 74 59 FF 35 ?? ?? ?? ?? 88 45 AC 8D 45 AC 50 8D 45 D4 50 C6 45 AD 00 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7D 3C 89 7D 9C EB 37 83 E8 5A 74 40 83 E8 09 74 B2 48 0F 85 0F 03 00 00 83 4D D0 40 C7 45 C8 0A 00 00 00 F6 45 D1 80 0F 84 10 02 00 00 8B 06 8B 56 04 83 C6 08 E9 33 02 00 00 66 89 45 D4 8D 45 D4 89 45 C8 89 7D C4 E9 DB 02 00 00 8B 06 83 C6 04 3B C2 89 B5 E4 03 00 00 74 2C 8B 48 04 3B CA 74 25 F6 45 D1 08 0F BF 00 89 4D C8 74 11 99 2B C2 D1 F8 C7 45 B8 01 00 00 00 E9 A5 02 00 00 89 55 B8 E9 9D 02 00 00 A1 ?? ?? ?? ?? 89 45 C8 50 E9 B0 00 00 00 75 0F 66 83 FB 67 75 43 C7 45 CC 01 00 00 00 EB 3A B8 00 02 00 00 39 45 CC 7E 03 89 45 CC 81 7D CC A3 00 00 00 7E 24 8B 45 CC 05 5D 01 00 00 50 E8 ?? ?? ?? ?? 85 C0 59 89 45 A8 74 07 8B F8 89 7D C8 EB 07 C7 45 CC A3 00 00 00 8B 06 FF 75 94 83 C6 08 FF 75 CC 89 45 80 8B 46 FC 89 45 84 0F BE C3 50 8D 45 80 57 50 89 B5 E4 03 00 00 FF 15 ?? ?? ?? ?? 8B 75 D0 83 C4 14 81 E6 80 00 00 00 74 0E 83 7D CC 00 75 08 57 FF 15 ?? ?? ?? ?? 59 66 83 FB 67 75 0C 85 F6 75 08 57 FF 15 ?? ?? ?? ?? 59 80 3F 2D 75 08 80 4D D1 01 47 89 7D C8 57 E8 ?? ?? ?? ?? 59 E9 D4 01 00 00 83 E8 69 0F 84 BF FE FF FF 83 E8 05 0F 84 B0 00 00 00 48 0F 84 8F 00 00 00 48 74 51 83 E8 03 0F 84 AE FD FF FF 48 48 0F 84 9F FE FF FF 83 E8 03 0F 85 A1 01 00 00 C7 45 A4 27 00 00 00 EB 3C 85 F6 75 09 8B 35 ?? ?? ?? ?? 89 75 C8 C7 45 B8 01 00 00 00 8B C6 EB 09 4A 66 83 38 00 74 06 40 40 85 D2 75 F3 2B C6 D1 F8 E9 67 01 00 00 C7 45 CC 08 00 00 00 C7 45 A4 07 00 00 00 F6 45 D0 80 C7 45 C8 10 00 00 00 0F 84 47 FE FF FF 8B 45 A4 83 C0 51 66 C7 45 B4 30 00 66 89 45 B6 C7 45 BC 02 00 00 00 E9 2B FE FF FF F6 45 D0 80 C7 45 C8 08 00 00 00 0F 84 1A FE FF FF 80 4D D1 02 E9 11 FE FF FF 8B 06 83 C6 04 F6 45 D0 20 89 B5 E4 03 00 00 74 09 66 8B 4D C0 66 89 08 EB 05 8B 4D C0 89 08 C7 45 9C 01 00 00 00 E9 D4 01 00 00 83 C6 04 F6 45 D0 20 74 19 F6 45 D0 40 89 B5 E4 03 00 00 74 07 0F BF 46 FC 99 EB 1A 0F B7 46 FC EB F7 F6 45 D0 40 8B 46 FC 74 03 99 EB 02 33 D2 89 B5 E4 03 00 00 F6 45 D0 40 74 15 85 D2 7F 11 7C 04 85 C0 73 0B F7 D8 83 D2 00 F7 DA 80 4D D1 01 F6 45 D1 80 8B F0 8B DA 75 02 33 DB 83 7D CC 00 7D 09 C7 45 CC 01 00 00 00 EB 11 83 65 D0 F7 B8 00 02 00 00 39 45 CC 7E 03 89 45 CC 8B C6 0B C3 75 04 83 65 BC 00 8D BD D3 01 00 00 8B 45 CC FF 4D CC 85 C0 7F 06 8B C6 0B C3 74 24 8B 45 C8 99 52 50 53 56 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 5D 8C 8B F0 8B DA 7E 03 03 4D A4 88 0F 4F EB CC 8D 85 D3 01 00 00 2B C7 47 F6 45 D1 02 89 45 C4 89 7D C8 74 14 80 3F 30 75 04 85 C0 75 0B 4F 89 7D C8 C6 07 30 40 89 45 C4 83 7D 9C 00 0F 85 E0 00 00 00 8B 45 D0 A8 40 74 2A F6 C4 01 74 08 66 C7 45 B4 2D 00 EB 16 A8 01 74 08 66 C7 45 B4 2B 00 EB 0A A8 02 74 0D 66 C7 45 B4 20 00 C7 45 BC 01 00 00 00 8B 5D B0 2B 5D BC 2B 5D C4 F6 45 D0 0C 75 0D 53 6A 20 8D 45 C0 E8 ?? ?? ?? ?? 59 59 FF 75 BC 8D 45 C0 8D 4D B4 E8 ?? ?? ?? ?? F6 45 D0 08 59 74 13 F6 45 D0 04 75 0D 53 6A 30 8D 45 C0 E8 ?? ?? ?? ?? 59 59 83 7D B8 00 75 43 83 7D C4 00 7E 3D 8B 45 C4 8B 7D C8 89 45 A0 FF 35 ?? ?? ?? ?? FF 4D A0 8D 45 90 57 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 89 45 8C 7E 26 FF 75 90 8D 75 C0 E8 ?? ?? ?? ?? 03 7D 8C 83 7D A0 00 59 7F CE EB 0F FF 75 C4 8B 4D C8 8D 45 C0 E8 ?? ?? ?? ?? 59 F6 45 D0 04 74 0D 53 6A 20 8D 45 C0 E8 ?? ?? ?? ?? 59 59 83 7D A8 00 74 0D FF 75 A8 E8 ?? ?? ?? ?? 83 65 A8 00 59 8B 8D E0 03 00 00 66 8B 19 66 85 DB 0F 85 90 F8 FF FF 8B 8D D4 03 00 00 8B 45 C0 5F 5E 5B E8 ?? ?? ?? ?? 81 C5 D8 03 00 00 C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "_memmove"
		size = 829
		refs = "0038 TrailUpVec 0050 LeadUpVec 005f UnwindUpVec 0064 LeadUp1 0068 LeadUp2 006c LeadUp3 00e0 UnwindUp0 00e4 UnwindUp1 00e8 UnwindUp2 00ec UnwindUp3 00f0 UnwindUp4 00f4 UnwindUp5 00f8 UnwindUp6 00fc UnwindUp7 014c TrailUp0 0150 TrailUp1 0154 TrailUp2 0158 TrailUp3 01be TrailDownVec 01c9 UnwindDownVec 01e4 LeadDownVec 01f0 LeadDown1 01f4 LeadDown2 01f8 LeadDown3 027c UnwindDown7 0280 UnwindDown6 0284 UnwindDown5 0288 UnwindDown4 028c UnwindDown3 0290 UnwindDown2 0294 UnwindDown1 0298 UnwindDown0 02e8 TrailDown0 02ec TrailDown1 02f0 TrailDown2 02f4 TrailDown3"
		altNames = "_memcpy"
	strings:
		$1 = { 55 8B EC 57 56 8B 75 0C 8B 4D 10 8B 7D 08 8B C1 8B D1 03 C6 3B FE 76 08 3B F8 0F 82 7C 01 00 00 F7 C7 03 00 00 00 75 14 C1 E9 02 83 E2 03 83 F9 08 72 29 F3 A5 FF 24 95 ?? ?? ?? ?? 8B C7 BA 03 00 00 00 83 E9 04 72 0C 83 E0 03 03 C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 23 D1 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 C1 E9 02 88 47 02 83 C6 03 83 C7 03 83 F9 08 72 CC F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 23 D1 8A 06 88 07 8A 46 01 C1 E9 02 88 47 01 83 C6 02 83 C7 02 83 F9 08 72 A6 F3 A5 FF 24 95 ?? ?? ?? ?? 90 23 D1 8A 06 88 07 83 C6 01 C1 E9 02 83 C7 01 83 F9 08 72 88 F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E E4 89 44 8F E4 8B 44 8E E8 89 44 8F E8 8B 44 8E EC 89 44 8F EC 8B 44 8E F0 89 44 8F F0 8B 44 8E F4 89 44 8F F4 8B 44 8E F8 89 44 8F F8 8B 44 8E FC 89 44 8F FC 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 5E 5F C9 C3 90 8A 06 88 07 8B 45 08 5E 5F C9 C3 90 8A 06 88 07 8A 46 01 88 47 01 8B 45 08 5E 5F C9 C3 8D 49 00 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 88 47 02 8B 45 08 5E 5F C9 C3 90 8D 74 31 FC 8D 7C 39 FC F7 C7 03 00 00 00 75 24 C1 E9 02 83 E2 03 83 F9 08 72 0D FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8B FF F7 D9 FF 24 8D ?? ?? ?? ?? 8D 49 00 8B C7 BA 03 00 00 00 83 F9 04 72 0C 83 E0 03 2B C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8A 46 03 23 D1 88 47 03 83 EE 01 C1 E9 02 83 EF 01 83 F9 08 72 B2 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 8A 46 03 23 D1 88 47 03 8A 46 02 C1 E9 02 88 47 02 83 EE 02 83 EF 02 83 F9 08 72 88 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 90 8A 46 03 23 D1 88 47 03 8A 46 02 88 47 02 8A 46 01 C1 E9 02 88 47 01 83 EE 03 83 EF 03 83 F9 08 0F 82 56 FF FF FF FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E 1C 89 44 8F 1C 8B 44 8E 18 89 44 8F 18 8B 44 8E 14 89 44 8F 14 8B 44 8E 10 89 44 8F 10 8B 44 8E 0C 89 44 8F 0C 8B 44 8E 08 89 44 8F 08 8B 44 8E 04 89 44 8F 04 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 5E 5F C9 C3 90 8A 46 03 88 47 03 8B 45 08 5E 5F C9 C3 8D 49 00 8A 46 03 88 47 03 8A 46 02 88 47 02 8B 45 08 5E 5F C9 C3 90 8A 46 03 88 47 03 8A 46 02 88 47 02 8A 46 01 88 47 01 8B 45 08 5E 5F C9 C3 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "__mbsset"
		size = 89
		refs = "0002 ___ismbcodepage 0016 __strset"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 8B 4C 24 04 56 8B F1 75 0E FF 74 24 0C 51 E8 ?? ?? ?? ?? 59 59 5E C3 8B 44 24 0C 8B D0 C1 EA 08 84 D2 74 25 84 C0 75 17 B2 20 8A C2 EB 11 88 11 41 80 39 00 74 05 88 01 41 EB 04 C6 41 FF 20 80 39 00 75 EA EB 08 88 01 41 80 39 00 75 F8 8B C6 5E C3 }
	condition:
		$1
}

rule file_366_0_0 {
	meta:
		name = "__CIsin"
		size = 174
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003c ___fastflag 0043 __fast_exit 004e _NAME_ 0053 __math_exit 0059 __pi_by_2_to_61 006e __convertTOStoQNaN 0086 __indefinite 00a8 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 50 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FE 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 1E 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FE EB CD E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 1E 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "__getsystime"
		size = 91
		refs = "000c __imp__GetLocalTime@4 0050 _mktime"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 F0 50 FF 15 ?? ?? ?? ?? 8B 45 08 0F B7 4D FC 83 48 20 FF 89 08 0F B7 4D FA 89 48 04 0F B7 4D F8 89 48 08 0F B7 4D F6 89 48 0C 0F B7 4D F2 49 89 48 10 0F B7 4D F0 81 E9 6C 07 00 00 89 48 14 0F B7 4D F4 50 89 48 18 E8 ?? ?? ?? ?? 0F B7 45 FE 59 C9 C3 }
	condition:
		$1
}

rule file_367_1_0 {
	meta:
		name = "__setsystime"
		size = 105
		refs = "000c _mktime 0054 __imp__SetLocalTime@4 005f __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 8B 75 08 56 E8 ?? ?? ?? ?? 66 8B 46 14 66 05 6C 07 66 89 45 F0 66 8B 46 10 66 40 66 89 45 F2 66 8B 46 0C 66 89 45 F6 66 8B 46 08 66 89 45 F8 66 8B 46 04 66 89 45 FA 66 8B 06 66 89 45 FC 66 8B 45 0C 66 89 45 FE 59 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 5E 75 08 FF 15 ?? ?? ?? ?? C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "___ansicp"
		size = 67
		refs = "0007 ___security_cookie 0022 __imp__GetLocaleInfoA@16 0034 _atol 003d @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 6A 06 89 45 FC 8D 45 F4 50 68 04 10 00 00 FF 75 08 C6 45 FA 00 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 0A 8D 45 F4 50 E8 ?? ?? ?? ?? 59 8B 4D FC E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_368_1_0 {
	meta:
		name = "___convertcp"
		size = 457
		refs = "0003 $T20514 0008 __SEH_prolog 000d ___security_cookie 003a __imp__GetCPInfo@8 0076 _strlen 0098 __imp__MultiByteToWideChar@24 00b2 __alloca_probe 00c5 _memset 00da __resetstkoflw 00f1 _calloc 013b __imp__WideCharToMultiByte@32 018f _free 01bf @__security_check_cookie@4 01c4 __SEH_epilog"
	strings:
		$1 = { 6A 38 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 33 FF 89 7D CC 89 7D BC 8B 45 14 8B 18 89 5D C0 89 7D C4 8B 45 08 3B 45 0C 0F 84 73 01 00 00 8D 4D D0 51 50 8B 35 ?? ?? ?? ?? FF D6 85 C0 74 20 83 7D D0 01 75 1A 8D 45 D0 50 FF 75 0C FF D6 85 C0 74 0D 83 7D D0 01 75 07 C7 45 C4 01 00 00 00 39 7D C4 74 1A 83 FB FF 74 04 8B F3 EB 0C FF 75 10 E8 ?? ?? ?? ?? 59 8B F0 46 89 75 C8 EB 03 8B 75 C8 39 7D C4 75 1A 57 57 53 FF 75 10 6A 01 FF 75 08 FF 15 ?? ?? ?? ?? 8B F0 89 75 C8 3B F7 74 58 89 7D FC 8D 04 36 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B DC 89 5D B8 8D 04 36 50 57 53 E8 ?? ?? ?? ?? 83 C4 0C 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 FF 33 DB 83 4D FC FF 8B 75 C8 3B DF 75 1E 56 6A 02 E8 ?? ?? ?? ?? 59 59 8B D8 3B DF 75 07 33 C0 E9 B4 00 00 00 C7 45 BC 01 00 00 00 56 53 FF 75 C0 FF 75 10 6A 01 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 0F 84 83 00 00 00 39 7D 18 74 20 57 57 FF 75 1C FF 75 18 56 53 57 FF 75 0C FF 15 ?? ?? ?? ?? 85 C0 74 66 8B 45 18 89 45 CC EB 5E 39 7D C4 75 16 57 57 57 57 56 53 57 FF 75 0C FF 15 ?? ?? ?? ?? 8B F0 3B F7 74 43 56 6A 01 E8 ?? ?? ?? ?? 59 59 89 45 CC 3B C7 74 32 57 57 56 50 56 53 57 FF 75 0C FF 15 ?? ?? ?? ?? 3B C7 75 0E FF 75 CC E8 ?? ?? ?? ?? 59 89 7D CC EB 10 83 7D C0 FF 74 0A 8B 4D 14 89 01 EB 03 8B 5D B8 39 7D BC 74 07 53 E8 ?? ?? ?? ?? 59 8B 45 CC 8D 65 AC 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "__mbsupr"
		size = 114
		refs = "0014 __mbctype 0021 ___mbcodepage 0035 ___mblcid 003a ___crtLCMapStringA 005c __mbcasemap"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 08 80 3F 00 8B F7 74 59 0F B6 06 8A 88 ?? ?? ?? ?? F6 C1 04 74 37 6A 01 FF 35 ?? ?? ?? ?? 8D 45 08 6A 02 50 6A 02 56 68 00 02 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 29 83 F8 01 8B 4D 08 88 0E 7E 13 46 88 2E EB 0E F6 C1 20 74 07 0F B6 80 ?? ?? ?? ?? 88 06 46 80 3E 00 75 A7 8B C7 5F 5E 5D C3 33 C0 EB F8 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "__mbcjistojms"
		size = 98
		refs = "0002 ___mbcodepage"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 8B 44 24 04 75 51 0F B6 CC 25 FF 00 00 00 83 F9 21 8B D0 72 40 83 F9 7E 77 3B 83 FA 21 72 36 83 FA 7E 77 31 F6 C1 01 74 0F 83 FA 5F 77 05 83 C2 1F EB 08 83 C2 20 EB 03 83 C2 7E 8D 41 DF D1 E8 05 81 00 00 00 3D 9F 00 00 00 76 03 83 C0 40 C1 E0 08 0B C2 C3 33 C0 C3 }
	condition:
		$1
}

rule file_370_1_0 {
	meta:
		name = "__mbcjmstojis"
		size = 153
		refs = "0002 ___mbcodepage 0025 __mbctype"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 74 05 8B 44 24 04 C3 8B 4C 24 04 0F B6 C5 56 0F B6 F0 BA FF 00 00 00 23 CA F6 86 ?? ?? ?? ?? 04 74 69 0F B6 F1 F6 86 ?? ?? ?? ?? 08 74 5D 3D A0 00 00 00 1B F6 83 E6 C0 81 C6 C1 00 00 00 2B C6 81 F9 9F 00 00 00 72 0D 83 C0 11 C1 E0 09 83 C1 82 0B C1 EB 1A 6A 7E 5E 3B F1 1B F6 F7 DE C1 E0 09 83 C6 1F 05 00 21 00 00 2B CE 0B C8 8B C1 3D 7E 7E 00 00 77 15 3D 21 21 00 00 72 0E 8B C8 23 CA 83 F9 7E 77 05 83 F9 21 73 02 33 C0 5E C3 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__read"
		size = 494
		refs = "000d __nhandle 0020 ___pioinfo 0086 __imp__ReadFile@20 0090 __imp__GetLastError@0 009d __doserrno 00b4 __dosmaperr 019b __lseek 01de _errno"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 3B 35 ?? ?? ?? ?? 57 0F 83 BD 01 00 00 8B C6 C1 F8 05 8D 3C 85 ?? ?? ?? ?? 8B 07 83 E6 1F C1 E6 03 03 C6 8A 50 04 F6 C2 01 0F 84 9B 01 00 00 83 65 F4 00 83 7D 10 00 8B 5D 0C 8B CB 74 62 F6 C2 02 75 5D F6 C2 48 74 22 80 78 05 0A 74 1C 8B 07 8A 44 30 05 FF 4D 10 88 03 8B 07 8D 4B 01 C7 45 F4 01 00 00 00 C6 44 30 05 0A 6A 00 8D 45 F0 50 FF 75 10 8B 07 51 FF 34 30 FF 15 ?? ?? ?? ?? 85 C0 75 30 FF 15 ?? ?? ?? ?? 6A 05 59 3B C1 75 0B 89 0D ?? ?? ?? ?? E9 36 01 00 00 83 F8 6D 75 07 33 C0 E9 37 01 00 00 50 E8 ?? ?? ?? ?? 59 E9 28 01 00 00 8B 45 F0 8B 0F 01 45 F4 F6 44 31 04 80 0F 84 FF 00 00 00 85 C0 74 10 80 3B 0A 75 0B 8B C1 8D 44 30 04 80 08 04 EB 09 8B 07 8D 44 30 04 80 20 FB 8B 45 0C 8B 4D F4 03 C8 3B C1 89 45 F8 89 4D F4 0F 83 C6 00 00 00 8B 45 F8 8A 00 3C 1A 0F 84 A9 00 00 00 3C 0D 74 0B 88 03 43 FF 45 F8 E9 8C 00 00 00 49 39 4D F8 73 14 8B 45 F8 40 80 38 0A 75 06 83 45 F8 02 EB 59 89 45 F8 EB 6E FF 45 F8 6A 00 8D 45 F0 50 6A 01 8D 45 FF 50 8B 07 FF 34 30 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 85 C0 75 46 83 7D F0 00 74 40 8B 07 F6 44 30 04 48 74 12 8A 45 FF 3C 0A 74 16 C6 03 0D 8B 0F 88 44 31 05 EB 28 3B 5D 0C 75 0B 80 7D FF 0A 75 05 C6 03 0A EB 18 6A 01 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FF 0A 74 04 C6 03 0D 43 8B 4D F4 39 4D F8 0F 82 4C FF FF FF EB 10 8B 07 F6 44 30 04 40 75 07 8D 74 30 04 80 0E 02 2B 5D 0C 89 5D F4 8B 45 F4 EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "__CIpow_pentium4"
		size = 2896
		refs = "0023 SIGMASK 002b ONEMASK 005c rcp_t1 0070 log2_t1 00ab HALFSIG 00d7 rcp_t2 00eb log2_t2 011d LHN 0133 rcp_t3 0145 log2_t3 022e clv 0289 Shifter 02ad exp2_tbl 02b5 cev 0371 ABSVALMASK 042f NEG_ZERO 0642 NEG_INF 06be sNaN 06c6 QIND 07a0 INF 0845 ___libm_error_support 0a7e EMIN"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 E4 F0 D9 C9 DD 1C 24 DD 5C 24 08 E8 02 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 DB 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 0C 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 17 05 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 D9 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E E2 05 00 00 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 3F 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 0C F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 F2 0F 58 C5 83 EC 10 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 4C 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 DA 00 00 00 0B C1 83 F8 00 0F 84 13 04 00 00 83 FA 00 0F 8D 05 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A3 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 8C 02 00 00 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5E BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 26 FC FF FF 66 0F 12 7C 24 04 66 0F 12 64 24 04 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 91 02 00 00 0F 87 DE 01 00 00 83 FA 00 0F 87 D5 01 00 00 E9 7D 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 5C FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 10 81 E2 00 00 00 80 83 FA 00 74 31 C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 54 24 04 F2 0F 5E CA BA 1B 00 00 00 E9 9A 02 00 00 C1 E1 0D 23 C1 83 F8 00 0F 85 A4 00 00 00 D9 EE C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 BD 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 8D 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 65 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 23 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 3E 01 00 00 D9 EE C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 22 01 00 00 D9 EE C3 F2 0F 58 E4 F2 0F 10 C4 BA EE 03 00 00 E9 90 01 00 00 66 0F 12 54 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 80 FE FF FF 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C9 BA 1C 00 00 00 E9 49 01 00 00 66 0F 12 64 24 04 66 0F 12 54 24 0C 66 0F 7E E0 83 F8 00 75 3F 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 08 01 00 00 81 FA 00 00 F0 BF 75 22 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 3D FF 00 00 00 75 7C D9 E8 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 75 55 66 0F C5 C2 03 66 0F 12 64 24 04 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 99 00 00 00 83 F8 00 74 14 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 72 17 D9 EE C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 03 D9 EE C3 DD 05 ?? ?? ?? ?? C3 F2 0F 58 D2 F2 0F 10 C2 BA EE 03 00 00 EB 6D 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? BA 1A 00 00 00 83 F8 00 74 44 66 0F 7E E0 BA 1D 00 00 00 25 FF FF FF 7F 3D 00 00 F0 7F 77 2F 72 05 83 F9 00 77 28 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 44 24 0C F2 0F 58 C1 BA 1C 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 83 F8 00 7E 28 3D 00 00 04 00 0F 83 3C 02 00 00 56 8B D0 83 E0 7F 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 26 3D 00 02 FC FF 0F 8E F1 01 00 00 56 8B D0 83 E0 7F 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 3F 00 00 66 0F C4 F8 03 F2 0F 59 54 24 14 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 4E 5E F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 10 FE FF FF BA 19 00 00 00 83 F8 00 0F 84 02 FE FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 5E F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 C6 FD FF FF BA 19 00 00 00 83 F8 00 0F 84 B8 FD FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 BA 19 00 00 00 E9 84 FD FF FF BA 18 00 00 00 83 F9 00 74 0D 66 0F 12 05 ?? ?? ?? ?? E9 6D FD FF FF 66 0F 12 05 ?? ?? ?? ?? E9 60 FD FF FF 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 FA F6 FF FF 3D 00 00 00 80 72 20 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 64 24 04 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 39 FF FF FF E9 57 FF FF FF 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "__openfile"
		size = 360
		refs = "0009 __commode 0138 __sopen 014e __cflush"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B 35 ?? ?? ?? ?? 57 8B 7D 0C 8A 07 33 DB 3C 61 89 5D F8 89 5D FC 74 1A 3C 72 74 0F 3C 77 0F 85 1A 01 00 00 B9 01 03 00 00 EB 0C 33 C9 83 CE 01 EB 08 B9 09 01 00 00 83 CE 02 33 D2 42 E9 D7 00 00 00 3B D3 0F 84 DA 00 00 00 0F BE C0 83 F8 54 7F 71 74 62 83 E8 2B 74 47 83 E8 19 74 38 83 E8 0E 74 1F 48 0F 85 91 00 00 00 39 5D FC 0F 85 88 00 00 00 C7 45 FC 01 00 00 00 83 C9 20 E9 97 00 00 00 39 5D FC 75 74 C7 45 FC 01 00 00 00 83 C9 10 E9 83 00 00 00 F6 C1 40 75 60 83 C9 40 EB 79 F6 C1 02 75 56 83 E1 FE 83 E6 FC 83 C9 02 81 CE 80 00 00 00 EB 63 B8 00 10 00 00 85 C8 75 3C 0B C8 EB 56 83 E8 62 74 46 48 74 2B 83 E8 0B 74 12 83 E8 06 75 26 F6 C5 C0 75 21 81 C9 00 40 00 00 EB 37 39 5D F8 75 14 C7 45 F8 01 00 00 00 81 E6 FF BF FF FF EB 23 39 5D F8 74 04 33 D2 EB 1A C7 45 F8 01 00 00 00 81 CE 00 40 00 00 EB 0B F6 C5 C0 75 E8 81 C9 00 80 00 00 47 8A 07 3A C3 0F 85 1E FF FF FF 68 A4 01 00 00 FF 75 10 51 FF 75 08 E8 ?? ?? ?? ?? 8B C8 83 C4 10 3B CB 7D 04 33 C0 EB 1A 8B 45 14 FF 05 ?? ?? ?? ?? 89 70 0C 89 58 04 89 18 89 58 08 89 58 1C 89 48 10 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "__fstat64"
		size = 699
		refs = "000f __nhandle 0024 ___pioinfo 0044 __imp__GetFileType@4 006a _errno 00de __imp__PeekNamedPipe@24 0119 __imp__GetFileInformationByHandle@8 0123 __imp__GetLastError@0 0129 __dosmaperr 0151 __imp__FileTimeToLocalFileTime@8 0167 __imp__FileTimeToSystemTime@8 0196 ___loctotime64_t 0281 __allmul"
	strings:
		$1 = { 55 8B EC 83 EC 54 53 8B 5D 08 57 33 FF 3B 1D ?? ?? ?? ?? 89 7D FC 0F 83 8E 02 00 00 8B C3 C1 F8 05 8D 04 85 ?? ?? ?? ?? 83 E3 1F 89 45 F8 8B 00 C1 E3 03 03 C3 F6 40 04 01 0F 84 6B 02 00 00 56 FF 30 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 9C 00 00 00 83 F8 02 74 24 83 F8 03 74 2A 3B C7 0F 85 B9 00 00 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 4D FC FF 8B 45 FC 5E E9 38 02 00 00 8B 75 0C 66 C7 46 06 00 20 EB 09 8B 75 0C 66 C7 46 06 00 10 83 F8 02 8B 4D 08 89 0E 89 4E 10 66 C7 46 08 01 00 66 89 7E 04 66 89 7E 0C 66 89 7E 0A 89 7E 30 89 7E 34 89 7E 28 89 7E 2C 89 7E 20 89 7E 24 75 08 89 7E 18 89 7E 1C EB AA 57 8D 45 08 50 8B 45 F8 8B 00 57 57 57 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 74 DE 8B 45 08 99 89 46 18 89 56 1C EB 84 8B 75 0C 8D 45 AC 50 8B 45 F8 66 89 7E 06 66 89 7E 0C 66 89 7E 0A 66 89 7E 04 66 C7 46 08 01 00 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E9 3F FF FF FF F6 45 AC 01 74 08 66 81 4E 06 24 01 EB 06 66 81 4E 06 B6 01 8D 45 F0 50 8D 45 C0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 15 FF FF FF 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 FF FE FF FF 0F B7 45 EC 83 CB FF 53 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 39 7D B8 89 46 28 89 56 2C 75 0F 39 7D BC 75 0A 89 46 20 8B C2 89 46 24 EB 59 8D 45 F0 50 8D 45 B8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D5 00 00 00 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BF 00 00 00 0F B7 45 EC 53 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 89 56 24 39 7D B0 75 13 39 7D B4 75 0E 8B 46 28 89 46 30 8B 46 2C 89 46 34 EB 51 8D 45 F0 50 8D 45 B0 50 FF 15 ?? ?? ?? ?? 85 C0 74 68 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 74 56 0F B7 45 EC 53 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 30 89 56 34 6A 01 57 57 FF 75 CC E8 ?? ?? ?? ?? 8B 4D D0 33 DB 03 C1 13 D3 80 4E 07 80 89 46 18 89 56 1C 89 3E 89 7E 10 E9 D4 FD FF FF 89 5D FC E9 CC FD FF FF C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5B C9 C3 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "__stricmp"
		size = 67
		refs = "0002 ___lc_handle 000a ___ascii_stricmp 001e _tolower"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 05 E9 ?? ?? ?? ?? 53 56 8B 74 24 0C 57 8B 7C 24 14 0F B6 06 50 E8 ?? ?? ?? ?? 8B D8 0F B6 07 50 46 E8 ?? ?? ?? ?? 59 47 85 DB 59 8B C8 74 04 3B D9 74 DE 5F 8B C3 5E 2B C1 5B C3 }
	condition:
		$1
}

rule file_376_1_0 {
	meta:
		name = "__abs64"
		size = 28
	strings:
		$1 = { 8B 4C 24 08 85 C9 8B 44 24 04 7C 06 7F 0B 85 C0 73 07 F7 D8 83 D1 00 F7 D9 8B D1 C3 }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "__wfsopen"
		size = 42
		refs = "0001 __getstream 000b _errno 0022 __wopenfile"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 0B C7 05 ?? ?? ?? ?? 18 00 00 00 C3 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "__fsopen"
		size = 42
		refs = "0001 __getstream 000b _errno 0022 __openfile"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 0B C7 05 ?? ?? ?? ?? 18 00 00 00 C3 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_380_1_0 {
	meta:
		name = "__wfopen"
		size = 19
		refs = "000b __wfsopen"
	strings:
		$1 = { 6A 40 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_473_1_0 {
	meta:
		name = "_fopen"
		size = 19
		refs = "000b __fsopen"
	strings:
		$1 = { 6A 40 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "_evaluate"
		size = 77
	strings:
		$1 = { 55 8B EC 83 EC 10 DD 45 08 DC 0C C8 EB 06 DC 04 C8 DC 4D 08 49 DD 5D F8 85 C9 DD 45 F8 7F EF DC 00 8D 42 FF DD 5D F8 DD 45 08 DC 0C D6 EB 07 DC 04 C6 48 DC 4D 08 85 C0 DD 5D F0 DD 45 F0 7F EF DC 06 DD 5D F0 DD 45 F8 DC 75 F0 C9 C3 }
	condition:
		$1
}

rule file_382_1_0 {
	meta:
		name = "__j0"
		size = 243
		refs = "000b __real@0000000000000000 0024 __real@401e000000000000 0035 _J0q 003d _J0p 004b _evaluate 0056 __real@4020000000000000 005b _P0q 0063 _P0p 008a _Q0q 0094 _Q0p 00a8 __real@3fe921fb54442d18 00b4 __real@400921fb54442d18 00ba __real@4000000000000000 00c2 _sqrt 00d0 _cos 00e1 _sin"
	strings:
		$1 = { 55 8B EC 83 EC 20 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 08 DD 45 08 D9 E0 DD 5D 08 DD 45 08 56 DC 1D ?? ?? ?? ?? 51 51 DF E0 F6 C4 41 7A 23 DD 45 08 BE ?? ?? ?? ?? DC 4D 08 B8 ?? ?? ?? ?? DD 1C 24 6A 04 5A 6A 0B 59 E8 ?? ?? ?? ?? E9 9A 00 00 00 DD 05 ?? ?? ?? ?? BE ?? ?? ?? ?? DC 75 08 B8 ?? ?? ?? ?? DD 5D F8 DD 45 F8 DC 4D F8 DD 5D F0 DD 45 F0 DD 1C 24 6A 05 5A 8B CA E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 BE ?? ?? ?? ?? 8B CA DD 1C 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 4D F8 DD 5D F8 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DD 5D E0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DD 5D 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F8 DC 6D 08 DC 4D E0 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_382_2_0 {
	meta:
		name = "__j1"
		size = 275
		refs = "0012 __real@0000000000000000 002f __real@401e000000000000 0040 _J1q 0048 _J1p 0056 _evaluate 006d __real@4020000000000000 0072 _P1q 007a _P1p 00a1 _Q1q 00ab _Q1p 00bf __real@4002d97c7f3321d2 00cb __real@400921fb54442d18 00d1 __real@4000000000000000 00d9 _sqrt 00e7 _cos 00f8 _sin"
	strings:
		$1 = { 55 8B EC 83 EC 24 DD 45 08 C7 45 FC 01 00 00 00 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 0C DD 45 08 83 4D FC FF D9 E0 DD 5D 08 DD 45 08 56 DC 1D ?? ?? ?? ?? 51 51 DF E0 F6 C4 41 7A 2F DD 45 08 BE ?? ?? ?? ?? DC 4D 08 B8 ?? ?? ?? ?? DD 1C 24 6A 04 5A 6A 0A 59 E8 ?? ?? ?? ?? DB 45 FC DD 5D EC DC 4D EC DC 4D 08 E9 A3 00 00 00 DD 05 ?? ?? ?? ?? BE ?? ?? ?? ?? DC 75 08 B8 ?? ?? ?? ?? DD 5D F4 DD 45 F4 DC 4D F4 DD 5D EC DD 45 EC DD 1C 24 6A 05 5A 8B CA E8 ?? ?? ?? ?? DD 5D E4 DD 45 EC BE ?? ?? ?? ?? 8B CA DD 1C 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 4D F4 DD 5D F4 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D EC DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DD 5D DC DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DC 4D E4 DD 5D 08 DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DC 4D F4 DC 6D 08 DC 4D DC DB 45 FC DD 5D 08 DC 4D 08 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_382_3_0 {
	meta:
		name = "__jn"
		size = 387
		refs = "0028 __j0 003f __j1 004a __real@0000000000000000 0071 _fabs"
	strings:
		$1 = { 55 8B EC 83 EC 2C 56 8B 75 08 85 F6 7D 0F DD 45 0C F7 DE D9 E0 89 75 08 DD 5D 0C 85 F6 75 12 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 4D 01 00 00 83 FE 01 75 12 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 36 01 00 00 DD 05 ?? ?? ?? ?? D9 C0 DD 45 0C DA E9 DF E0 F6 C4 44 0F 8B 20 01 00 00 DD D8 51 DB 45 08 51 DD 5D E4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DC 5D E4 59 DD 45 0C D1 E6 59 DF E0 F6 C4 41 75 64 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D E4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DD 5D F4 59 DD 45 F4 59 DD 5D EC 6A 04 DD 45 F4 58 DC C0 89 45 FC 3B F0 EB 1F DD 45 EC DD 5D E4 DD 45 F4 DD 5D EC DB 45 FC 83 45 FC 02 39 75 FC DD 5D DC DD 45 DC DC 4D F4 DC 75 0C DC 65 E4 DD 5D F4 75 D6 DD 45 F4 E9 96 00 00 00 D9 C0 8D 46 24 D8 C9 89 75 08 89 45 FC 3B C6 DD 5D E4 D9 EE EB 16 DB 45 FC 83 6D FC 02 39 75 FC DD 5D DC DD 45 DC DC 65 EC DC 7D E4 DD 5D EC 7F E5 DB 45 08 83 C6 FE 89 75 FC DD 5D DC DD 45 DC DC 65 EC D8 F9 DD 5D F4 DD 45 F4 DD 5D D4 D9 E8 DD 5D EC DB 45 FC DD 5D DC DD 45 DC EB 18 DD 45 EC DD 5D F4 DD 45 E4 DD 5D EC DB 45 FC DD 5D DC DD 45 DC DC 4D E4 83 6D FC 02 D8 F1 DC 65 F4 DD 5D E4 75 DA 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D D4 DC 75 E4 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_382_4_0 {
	meta:
		name = "_domain_err"
		size = 51
		refs = "000b __ctrlfp 002b __except1"
	strings:
		$1 = { 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? DD 44 24 18 59 59 50 83 EC 10 DD 5C 24 08 DD 44 24 1C DD 1C 24 FF 74 24 18 6A 08 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_382_5_0 {
	meta:
		name = "__y0"
		size = 300
		refs = "000b __real@0000000000000000 0018 __d_ind 0029 _domain_err 0034 __real@401e000000000000 0045 _Y0q 004c _Y0p 005b _evaluate 0069 __j0 0077 _log 0080 __real@3fe45f306dc9c883 008e __real@4020000000000000 0093 _P0q 009a _P0p 00c3 _Q0q 00cd _Q0p 00e1 __real@3fe921fb54442d18 00ed __real@400921fb54442d18 00f3 __real@4000000000000000 00fb _sqrt 0109 _cos 011a _sin"
	strings:
		$1 = { 55 8B EC 83 EC 20 DD 45 08 DC 15 ?? ?? ?? ?? DF E0 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 22 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DC 15 ?? ?? ?? ?? 56 51 51 DF E0 F6 C4 41 7A 4A D9 C0 BE ?? ?? ?? ?? D8 C9 B8 ?? ?? ?? ?? DD 1C 24 6A 08 59 8B D1 DD D8 E8 ?? ?? ?? ?? DD 5D F8 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F0 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F0 DC 0D ?? ?? ?? ?? DC 45 F8 E9 9B 00 00 00 DD 05 ?? ?? ?? ?? BE ?? ?? ?? ?? D8 F1 B8 ?? ?? ?? ?? DD 5D F8 DD D8 DD 45 F8 DC 4D F8 DD 5D F0 DD 45 F0 DD 1C 24 6A 05 5A 8B CA E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 BE ?? ?? ?? ?? 8B CA DD 1C 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 4D F8 DD 5D F8 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DD 5D E0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F8 DD 5D 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DC 45 08 DC 4D E0 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_382_6_0 {
	meta:
		name = "__y1"
		size = 316
		refs = "000b __real@0000000000000000 0018 __d_ind 002c _domain_err 003b __real@401e000000000000 004f __j1 005d _log 0065 _Y1q 006c _Y1p 0077 __real@3fe45f306dc9c883 008e _evaluate 009f __real@4020000000000000 00a4 _P1q 00ac _P1p 00d3 _Q1q 00dd _Q1p 00f1 __real@4002d97c7f3321d2 00fd __real@400921fb54442d18 0103 __real@4000000000000000 010b _sqrt 0119 _cos 012a _sin"
	strings:
		$1 = { 55 8B EC 83 EC 20 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 1F DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 23 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 45 08 56 DC 1D ?? ?? ?? ?? 51 51 DF E0 F6 C4 41 7A 55 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F0 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F0 BE ?? ?? ?? ?? D9 E8 B8 ?? ?? ?? ?? DC 75 08 DE E9 DC 0D ?? ?? ?? ?? DD 5D F0 DD 45 08 DC 4D 08 DD 1C 24 6A 08 5A 6A 07 59 E8 ?? ?? ?? ?? DC 4D 08 DC 45 F0 E9 9A 00 00 00 DD 05 ?? ?? ?? ?? BE ?? ?? ?? ?? DC 75 08 B8 ?? ?? ?? ?? DD 5D F8 DD 45 F8 DC 4D F8 DD 5D F0 DD 45 F0 DD 1C 24 6A 05 5A 8B CA E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 BE ?? ?? ?? ?? 8B CA DD 1C 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 4D F8 DD 5D F8 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DD 5D E0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F8 DD 5D 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DC 45 08 DC 4D E0 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_382_7_0 {
	meta:
		name = "__yn"
		size = 234
		refs = "000b __real@0000000000000000 0018 __d_ind 002c _domain_err 005d __y0 0074 __y1 00a2 __real@4000000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 24 DD 45 0C DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 1F DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 0C DD 1C 24 6A 24 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 53 33 DB 43 83 7D 08 00 89 5D FC 7D 10 F7 5D 08 84 5D 08 74 04 83 4D FC FF 83 7D 08 00 DD 45 0C 51 51 DD 1C 24 75 12 E8 ?? ?? ?? ?? DB 45 FC 59 59 DD 5D 0C DC 4D 0C EB 79 39 5D 08 75 12 E8 ?? ?? ?? ?? DB 45 FC 59 59 DD 5D 0C DC 4D 0C EB 62 E8 ?? ?? ?? ?? DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DD 5D EC 8B 45 08 3B C3 DD 05 ?? ?? ?? ?? DC 75 0C 59 59 89 5D 10 DD 5D DC 7E 28 DB 45 10 FF 45 10 39 45 10 DD 5D E4 DD 45 EC DD 45 E4 DC 4D DC D8 C9 DC 65 F4 DD 5D E4 DD 5D F4 DD 45 E4 DD 5D EC 7C D8 DB 45 FC DD 5D 0C DD 45 0C DC 4D E4 5B C9 C3 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "__modf_default"
		size = 292
		refs = "000d __ctrlfp 0019 _newcw 003e __d_ind 004e __sptype 0073 __handle_qnan1 0094 __copysign 00ad __real@3ff0000000000000 00ce __except1 00de __frnd 00fa __real@0000000000000000"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 6A 00 6A 00 E8 ?? ?? ?? ?? BE FF FF 00 00 56 FF 35 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8B 7D 0E 83 C4 10 8B C7 66 25 F0 7F 66 3D F0 7F 51 51 0F 85 9B 00 00 00 DD 05 ?? ?? ?? ?? 8B 7D 10 DD 1F DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 7E 4F 83 F8 02 7E 22 83 F8 03 75 45 DD 45 08 53 51 DD 1F DD 45 08 51 DD 1C 24 6A 1C E8 ?? ?? ?? ?? 83 C4 10 E9 A0 00 00 00 DD 45 08 83 EC 10 DD 1F DD 45 08 DD 5C 24 08 D9 EE DD 1C 24 E8 ?? ?? ?? ?? DD 5D F8 56 53 E8 ?? ?? ?? ?? 83 C4 18 EB 75 DD 45 08 53 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5D F8 DD 45 F8 DD 1F DD 45 F8 DD 5C 24 08 DD 45 08 DD 1C 24 6A 1C 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 48 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 10 DD 5D F8 DD 45 F8 59 DD 18 59 DD 45 08 DC 65 F8 DD 5D F8 DD 05 ?? ?? ?? ?? DD 45 F8 DA E9 DF E0 F6 C4 44 7A 09 66 81 E7 00 80 66 09 7D FE 56 53 E8 ?? ?? ?? ?? 59 59 DD 45 F8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "__ismbcdigit"
		size = 144
		refs = "0023 ___ismbcodepage 0039 ___mblcid 0042 ___mbcodepage 0050 ___crtGetStringTypeA 006f ___mb_cur_max 007a __isctype 0083 __pctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5E 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 75 04 33 C0 C9 C3 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 D6 66 83 7D FE 00 75 CF F6 45 FC 04 74 C9 33 C0 40 C9 C3 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 51 E8 ?? ?? ?? ?? 59 59 C9 C3 A1 ?? ?? ?? ?? 0F B6 04 48 83 E0 04 C9 C3 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "__chkesp"
		size = 24
	strings:
		$1 = { 75 01 C3 55 8B EC 83 EC 00 50 52 53 56 57 CC 5F 5E 5B 5A 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "_store_dt"
		size = 26
	strings:
		$1 = { 56 99 6A 0A 5E F7 FE 5E 83 C0 30 66 89 01 41 41 83 C2 30 66 89 11 8D 41 02 C3 }
	condition:
		$1
}

rule file_390_1_0 {
	meta:
		name = "__wasctime"
		size = 189
		refs = "0012 _buf 0022 ___dnames 002e ___mnames 0051 _store_dt"
	strings:
		$1 = { 53 55 56 8B 74 24 10 8B 4E 18 8D 14 49 8B 4E 10 57 BF ?? ?? ?? ?? 8D 1C 49 8B C7 33 C9 66 0F BE AC 0A ?? ?? ?? ?? 66 89 28 66 0F BE AC 0B ?? ?? ?? ?? 66 89 68 08 41 40 40 83 F9 03 7C DF 6A 20 5B 66 89 18 83 C0 08 66 89 18 8D 48 02 8B 46 0C E8 ?? ?? ?? ?? 66 89 18 8D 48 02 8B 46 08 E8 ?? ?? ?? ?? 66 C7 00 3A 00 8D 48 02 8B 46 04 E8 ?? ?? ?? ?? 66 C7 00 3A 00 8D 48 02 8B 06 E8 ?? ?? ?? ?? 8B C8 66 89 19 8B 46 14 99 6A 64 5B F7 FB 83 C1 02 83 C0 13 E8 ?? ?? ?? ?? 8B C8 8B 46 14 99 53 5E F7 FE 8B C2 E8 ?? ?? ?? ?? 66 C7 00 0A 00 66 83 60 02 00 8B C7 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "__expand"
		size = 116
		refs = "0010 ___active_heap 001f ___sbh_find_block 002c ___sbh_threshold 0036 ___sbh_resize_block 0062 __crtheap 0068 __imp__HeapReAlloc@16"
	strings:
		$1 = { 56 8B 74 24 0C 83 FE E0 76 04 33 C0 5E C3 83 3D ?? ?? ?? ?? 03 53 57 75 3B 8B 5C 24 10 53 E8 ?? ?? ?? ?? 85 C0 59 74 1D 33 FF 3B 35 ?? ?? ?? ?? 77 3C 56 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 2D 8B FB EB 29 85 F6 75 01 46 83 C6 0F 83 E6 F0 56 53 EB 0A 85 F6 75 01 46 56 FF 74 24 14 6A 10 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 8B C7 5F 5B 5E C3 }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "__wfindfirst"
		size = 218
		refs = "000a ___security_cookie 001e __imp__FindFirstFileW@8 002b __imp__GetLastError@0 0047 _errno 008b ___timet_from_ft 00c5 _wcscpy 00d4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 89 45 FC 57 8D 85 AC FD FF FF 50 FF 75 08 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 3F FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 25 83 F8 08 74 14 83 F8 12 74 1B C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF EB 7B C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EF 89 0D ?? ?? ?? ?? EB E7 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 56 8B 75 0C 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 CC FD FF FF 89 46 10 8D 85 D8 FD FF FF 50 83 C6 14 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 5E 8B 4D FC 5F E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_392_1_0 {
	meta:
		name = "__wfindnext"
		size = 213
		refs = "000a ___security_cookie 001d __imp__FindNextFileW@8 0027 __imp__GetLastError@0 0043 _errno 0087 ___timet_from_ft 00c1 _wcscpy 00cf @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 89 45 FC 8D 85 AC FD FF FF 50 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 25 83 F8 08 74 14 83 F8 12 74 1B C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF EB 7B C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EF 89 0D ?? ?? ?? ?? EB E7 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 56 8B 75 0C 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 CC FD FF FF 89 46 10 8D 85 D8 FD FF FF 50 83 C6 14 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E 8B 4D FC E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "__lseeki64"
		size = 159
		refs = "000a __nhandle 001f ___pioinfo 003d __get_osfhandle 0054 __imp__SetFilePointer@16 0062 __imp__GetLastError@0 006c __dosmaperr 0086 __doserrno 008d _errno"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 08 3B 05 ?? ?? ?? ?? 56 57 73 72 8B C8 C1 F9 05 8B F0 83 E6 1F 8D 3C 8D ?? ?? ?? ?? 8B 0F C1 E6 03 F6 44 31 04 01 74 55 8B 4D 0C 89 4D F8 8B 4D 10 50 89 4D FC E8 ?? ?? ?? ?? 83 F8 FF 59 74 44 FF 75 14 8D 4D FC 51 FF 75 F8 50 FF 15 ?? ?? ?? ?? 83 F8 FF 89 45 F8 75 13 FF 15 ?? ?? ?? ?? 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 EB 22 8B 07 8D 44 30 04 80 20 FD 8B 45 F8 8B 55 FC EB 17 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 83 CA FF 5F 5E C9 C3 }
	condition:
		$1
}

rule file_394_0_0 {
	meta:
		name = "__set_exp"
		size = 42
	strings:
		$1 = { 55 8B EC 51 51 8B 45 10 DD 45 08 8B 4D 0E DD 5D F8 05 FE 03 00 00 C1 E0 04 81 E1 0F 80 FF FF 0B C1 66 89 45 FE DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_394_1_0 {
	meta:
		name = "__get_exp"
		size = 21
	strings:
		$1 = { 8B 44 24 0A C1 E8 04 25 FF 07 FF FF 2D FE 03 00 00 0F BF C0 C3 }
	condition:
		$1
}

rule file_394_2_0 {
	meta:
		name = "__add_exp"
		size = 42
		refs = "0022 __set_exp"
	strings:
		$1 = { 8B 44 24 0A DD 44 24 04 8B 4C 24 0C C1 E8 04 25 FF 07 00 00 8D 84 08 02 FC FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_394_3_0 {
	meta:
		name = "__set_bexp"
		size = 37
	strings:
		$1 = { 55 8B EC 51 51 8B 45 10 DD 45 08 8B 4D 0E DD 5D F8 C1 E0 04 81 E1 0F 80 FF FF 0B C1 66 89 45 FE DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_394_4_0 {
	meta:
		name = "__sptype"
		size = 91
	strings:
		$1 = { 55 8B EC 33 D2 81 7D 0C 00 00 F0 7F 75 0A 39 55 08 75 17 33 C0 40 5D C3 81 7D 0C 00 00 F0 FF 75 09 39 55 08 75 04 6A 02 EB 2A 8B 4D 0E B8 F8 7F 00 00 23 C8 66 3B C8 75 04 6A 03 EB 17 66 81 F9 F0 7F 75 13 F7 45 0C FF FF 07 00 75 05 39 55 08 74 05 6A 04 58 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_394_5_0 {
	meta:
		name = "__decomp"
		size = 188
		refs = "0007 __real@0000000000000000 0083 __set_exp"
	strings:
		$1 = { 55 8B EC 51 51 DD 05 ?? ?? ?? ?? DD 45 08 DA E9 DF E0 F6 C4 44 7A 09 D9 EE 33 D2 E9 8F 00 00 00 33 C9 66 F7 45 0E F0 7F 75 62 F7 45 0C FF FF 0F 00 75 05 39 4D 08 74 54 DD 45 08 BA 03 FC FF FF DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 05 33 C0 40 EB 15 33 C0 EB 11 D1 65 0C F6 45 0B 80 74 04 83 4D 0C 01 D1 65 08 4A F6 45 0E 10 74 E9 80 65 0E EF 3B C1 74 04 80 4D 0F 80 DD 45 08 51 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C EB 23 DD 45 08 51 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 55 0E C1 EA 04 81 E2 FF 07 00 00 83 C4 0C 81 EA FE 03 00 00 8B 45 10 DD 5D F8 DD 45 F8 89 10 C9 C3 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "__cintrindisp2"
		size = 62
		refs = "0014 __matherr_flag 001c __trandisp2 0022 intrinflag"
	strings:
		$1 = { 55 8B EC 81 C4 60 FD FF FF 53 9B D9 BD 5C FF FF FF 9B 83 3D ?? ?? ?? ?? 00 74 14 E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E8 89 00 00 00 5B C9 C3 D9 C9 DD 95 7A FF FF FF D9 C9 DD 55 82 EB DD }
	condition:
		$1
}

rule file_395_1_0 {
	meta:
		name = "__cintrindisp1"
		size = 54
		refs = "0013 __matherr_flag 001b __trandisp1 0021 intrinflag"
	strings:
		$1 = { 55 8B EC 81 C4 60 FD FF FF 53 9B D9 BD 5C FF FF FF 83 3D ?? ?? ?? ?? 00 74 14 E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 E8 4C 00 00 00 5B C9 C3 DD 95 7A FF FF FF EB E4 }
	condition:
		$1
}

rule file_395_2_0 {
	meta:
		name = "__ctrandisp2"
		size = 390
		refs = "002e __trandisp2 003c intrinflag 0043 ___fastflag 004c LocalFac 00d6 IeeeAdjU 00e6 DblMin 00f2 _zero 0104 IeeeAdjO 0114 DblMax 0120 _infinity 0175 __87except"
	strings:
		$1 = { 55 8B EC 81 C4 60 FD FF FF 53 FF 75 0C FF 75 08 E8 9D 01 00 00 83 C4 08 FF 75 14 FF 75 10 E8 8F 01 00 00 83 C4 08 9B D9 BD 5C FF FF FF E8 ?? ?? ?? ?? E8 03 00 00 00 5B C9 C3 C6 05 ?? ?? ?? ?? 00 83 3D ?? ?? ?? ?? 00 75 4F DD 15 ?? ?? ?? ?? 8A 85 70 FF FF FF 0A C0 74 1A 3C FF 74 5A 3C FE 74 3F 0A C0 74 33 0F BE C0 89 85 72 FF FF FF E9 B0 00 00 00 66 8B 85 5C FF FF FF 66 83 E0 20 75 18 9B DF E0 66 83 E0 20 74 0F C7 85 72 FF FF FF 08 00 00 00 E9 8B 00 00 00 D9 AD 5C FF FF FF 9B C3 66 A1 ?? ?? ?? ?? 66 25 F0 7F 66 0B C0 74 1A 66 3D F0 7F 74 42 EB BC 66 A1 ?? ?? ?? ?? 66 25 F0 7F 66 3D F0 7F 74 30 EB AA C7 85 72 FF FF FF 04 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 73 34 DC 0D ?? ?? ?? ?? EB 2C C7 85 72 FF FF FF 03 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 76 06 DC 0D ?? ?? ?? ?? 56 57 8B 9D 6C FF FF FF 43 89 9D 76 FF FF FF 80 3D ?? ?? ?? ?? 00 75 1A FC 8D 75 08 8D BD 7A FF FF FF A5 A5 80 7B 0C 01 74 08 8D 75 10 8D 7D 82 A5 A5 DD 5D 8A 8D 85 72 FF FF FF 8D 9D 5C FF FF FF 53 50 8B 9D 6C FF FF FF 8A 43 0E 0F BE C0 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E DD 45 8A E9 13 FF FF FF }
	condition:
		$1
}

rule file_395_3_0 {
	meta:
		name = "__ctrandisp1"
		size = 44
		refs = "0020 __trandisp1"
	strings:
		$1 = { 55 8B EC 81 C4 60 FD FF FF 53 FF 75 0C FF 75 08 E8 17 00 00 00 83 C4 08 9B D9 BD 5C FF FF FF E8 ?? ?? ?? ?? E8 8B FE FF FF 5B C9 C3 }
	condition:
		$1
}

rule file_395_4_0 {
	meta:
		name = "__fload"
		size = 60
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 66 8B 45 0E 66 8B D8 66 25 F0 7F 66 3D F0 7F 75 1E 66 81 CB FF 7F 66 89 5D FE 8B 45 0C 8B 5D 08 0F A4 D8 0B 89 45 FA 89 5D F6 DB 6D F6 EB 03 DD 45 08 5B C9 C3 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "_realloc"
		size = 354
		refs = "0010 _malloc 0025 _free 0031 ___active_heap 0049 ___sbh_find_block 005a ___sbh_threshold 0064 ___sbh_resize_block 0075 ___sbh_alloc_block 008e _memcpy 009d ___sbh_free_block 00b8 __crtheap 00be __imp__HeapAlloc@12 00ff __imp__HeapReAlloc@16 010b __newmode 0114 __callnewh"
	strings:
		$1 = { 53 8B 5C 24 08 85 DB 55 57 75 0F FF 74 24 14 E8 ?? ?? ?? ?? 59 E9 44 01 00 00 56 8B 74 24 18 85 F6 75 0C 53 E8 ?? ?? ?? ?? 59 E9 2C 01 00 00 83 3D ?? ?? ?? ?? 03 0F 85 EB 00 00 00 33 FF 83 FE E0 0F 87 C2 00 00 00 53 E8 ?? ?? ?? ?? 8B E8 85 ED 59 0F 84 90 00 00 00 3B 35 ?? ?? ?? ?? 77 48 56 53 55 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 04 8B FB EB 31 56 E8 ?? ?? ?? ?? 8B F8 85 FF 59 74 28 8B 43 FC 48 3B C6 72 02 8B C6 50 53 57 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B E8 53 55 E8 ?? ?? ?? ?? 83 C4 18 85 FF 75 3C 85 F6 75 01 46 83 C6 0F 83 E6 F0 56 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 74 1C 8B 43 FC 48 3B C6 72 02 8B C6 50 53 57 E8 ?? ?? ?? ?? 53 55 E8 ?? ?? ?? ?? 83 C4 14 85 ED 75 1D 85 F6 75 01 46 83 C6 0F 83 E6 F0 56 53 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 1A 83 3D ?? ?? ?? ?? 00 74 11 56 E8 ?? ?? ?? ?? 85 C0 59 0F 85 1B FF FF FF EB 38 8B C7 EB 36 33 C0 83 FE E0 77 19 85 F6 75 01 46 56 53 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 16 83 3D ?? ?? ?? ?? 00 74 0D 56 E8 ?? ?? ?? ?? 85 C0 59 75 CC 33 C0 5E 5F 5D 5B C3 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "__mbsnbcoll"
		size = 63
		refs = "000f ___mbcodepage 0023 ___mblcid 0028 ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 FF 35 ?? ?? ?? ?? FF 75 10 FF 75 0C FF 75 10 FF 75 08 6A 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 07 B8 FF FF FF 7F 5D C3 83 C0 FE 5D C3 }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
		size = 48
	strings:
		$1 = { 55 8B EC 51 53 8B 45 0C 83 C0 0C 89 45 FC 64 8B 1D 00 00 00 00 8B 03 64 A3 00 00 00 00 8B 45 08 8B 5D 0C 8B 63 FC 8B 6D FC FF E0 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_400_4_0 {
	meta:
		name = "?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z"
		size = 82
		refs = "0015 $ReturnPoint$18610 0025 _RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 64 8B 35 00 00 00 00 89 75 FC C7 45 F8 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 F8 FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 8B 40 04 83 E0 FD 8B 4D 0C 89 41 04 64 8B 3D 00 00 00 00 8B 5D FC 89 3B 64 89 1D 00 00 00 00 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_400_5_0 {
	meta:
		name = "___CxxFrameHandler"
		size = 54
		refs = "0022 ___InternalCxxFrameHandler"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 56 57 FC 89 45 FC 33 C0 50 50 50 FF 75 FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 5F 5E 5B 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_400_6_0 {
	meta:
		name = "___CxxLongjmpUnwind@4"
		size = 26
		refs = "0010 ___FrameUnwindToState"
	strings:
		$1 = { 8B 44 24 04 FF 70 1C FF 70 28 6A 00 FF 70 18 E8 ?? ?? ?? ?? 83 C4 10 C2 04 00 }
	condition:
		$1
}

rule file_400_7_0 {
	meta:
		name = "?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z"
		size = 59
		refs = "000a ___security_cookie 0033 ___InternalCxxFrameHandler"
	strings:
		$1 = { FC 8B 44 24 08 8B 48 08 3B 0D ?? ?? ?? ?? 74 0C 8B 44 24 04 83 48 04 08 33 C0 40 C3 6A 00 50 FF 70 14 FF 70 0C 6A 00 FF 74 24 20 FF 70 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 20 C3 }
	condition:
		$1
}

rule file_400_8_0 {
	meta:
		name = "?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
		size = 197
		refs = "0011 $ExceptionContinuation$18711 0029 ?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z 002e ___security_cookie 008f ?__pSETranslator@@3P6AXIPAU_EXCEPTION_POINTERS@@@ZA"
	strings:
		$1 = { 55 8B EC 83 EC 34 53 81 7D 08 23 01 00 00 75 12 B8 ?? ?? ?? ?? 8B 4D 0C 89 01 33 C0 40 E9 A0 00 00 00 83 65 D8 00 C7 45 DC ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E0 8B 45 18 89 45 E4 8B 45 0C 89 45 E8 8B 45 1C 89 45 EC 8B 45 20 89 45 F0 83 65 F4 00 83 65 F8 00 83 65 FC 00 89 65 F4 89 6D F8 64 A1 00 00 00 00 89 45 D8 8D 45 D8 64 A3 00 00 00 00 C7 45 CC 01 00 00 00 8B 45 08 89 45 D0 8B 45 10 89 45 D4 8D 45 D0 50 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 59 59 83 65 CC 00 83 7D FC 00 74 17 64 8B 1D 00 00 00 00 8B 03 8B 5D D8 89 03 64 89 1D 00 00 00 00 EB 09 8B 45 D8 64 A3 00 00 00 00 8B 45 CC 5B C9 C3 }
	condition:
		$1
}

rule file_400_9_0 {
	meta:
		name = "?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z"
		size = 178
		refs = "000e ___security_cookie 0068 ___InternalCxxFrameHandler 007f ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0097 ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
	strings:
		$1 = { 55 8B EC 51 53 FC 8B 45 0C 8B 40 08 3B 05 ?? ?? ?? ?? 74 17 8B 45 08 8B 40 04 83 C8 08 8B 4D 08 89 41 04 33 C0 40 E9 84 00 00 00 8B 45 08 8B 40 04 83 E0 66 74 0F 8B 45 0C C7 40 24 01 00 00 00 33 C0 40 EB 6A 6A 01 8B 45 0C FF 70 18 8B 45 0C FF 70 14 8B 45 0C FF 70 0C 6A 00 FF 75 10 8B 45 0C FF 70 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 8B 45 0C 83 78 24 00 75 0B FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 8D 45 FC 50 68 23 01 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 FC 8B 5D 0C 8B 63 1C 8B 6B 20 FF E0 33 C0 40 5B C9 C3 }
	condition:
		$1
}

rule file_400_10_0 {
	meta:
		name = "?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z"
		size = 122
		refs = "0024 ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 83 7D 0C 00 53 56 57 8B 7D 08 8B 77 0C 8B 5F 10 8B C6 89 45 FC 89 75 08 7C 38 83 FE FF 75 05 E8 ?? ?? ?? ?? 8B 4D 10 4E 8D 04 B6 8D 04 83 39 48 04 7D 05 3B 48 08 7E 05 83 FE FF 75 0C 8B 45 08 FF 4D 0C 89 45 FC 89 75 08 83 7D 0C 00 7D CB 8B 45 FC 8B 4D 14 46 89 31 8B 4D 18 89 01 3B 47 0C 77 04 3B F0 76 05 E8 ?? ?? ?? ?? 5F 8D 04 B6 5E 8D 04 83 5B C9 C3 }
	condition:
		$1
}

rule file_400_11_0 {
	meta:
		name = "?_CreateFrameInfo@@YAPAUFrameInfo@@PAU1@PAX@Z"
		size = 25
		refs = "000c _pFrameInfoChain"
	strings:
		$1 = { 8B 44 24 04 8B 4C 24 08 89 08 8B 0D ?? ?? ?? ?? 89 48 04 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_400_12_0 {
	meta:
		name = "?IsExceptionObjectToBeDestroyed@@YAHPAX@Z"
		size = 27
		refs = "0001 _pFrameInfoChain"
	strings:
		$1 = { A1 ?? ?? ?? ?? EB 0B 8B 08 3B 4C 24 04 74 09 8B 40 04 85 C0 75 F1 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_400_13_0 {
	meta:
		name = "?_FindAndUnlinkFrame@@YAXPAUFrameInfo@@@Z"
		size = 57
		refs = "0005 _pFrameInfoChain 002e ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 8B 54 24 04 A1 ?? ?? ?? ?? 3B D0 75 09 8B 42 04 A3 ?? ?? ?? ?? C3 8B C8 83 C0 04 EB 0B 8B 00 3B D0 74 0F 8B C8 8D 41 04 83 38 00 75 F0 E9 ?? ?? ?? ?? 8B 42 04 89 41 04 C3 }
	condition:
		$1
}

rule file_400_14_0 {
	meta:
		name = "?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 89
		refs = "0007 ___security_cookie 0022 ?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z 0046 __CallSettingFrame@12"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 83 65 E8 00 8B 4D 08 89 45 F0 8B 45 0C 89 45 F4 8B 45 14 40 C7 45 EC ?? ?? ?? ?? 89 4D F8 89 45 FC 64 A1 00 00 00 00 89 45 E8 8D 45 E8 64 A3 00 00 00 00 FF 75 18 51 FF 75 10 E8 ?? ?? ?? ?? 8B C8 8B 45 E8 64 A3 00 00 00 00 8B C1 C9 C3 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "_write_char"
		size = 51
		refs = "0022 __flsbuf"
	strings:
		$1 = { F6 41 0C 40 74 06 83 79 08 00 74 24 FF 49 04 78 0B 8B 11 88 02 FF 01 0F B6 C0 EB 0C 0F BE C0 51 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 03 09 06 C3 FF 06 C3 }
	condition:
		$1
}

rule file_401_1_0 {
	meta:
		name = "_write_multi_char"
		size = 36
		refs = "0012 _write_char"
	strings:
		$1 = { 55 8B EC 56 8B F0 EB 13 8B 4D 10 8A 45 08 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 74 06 83 7D 0C 00 7F E7 5E 5D C3 }
	condition:
		$1
}

rule file_401_2_0 {
	meta:
		name = "_write_string"
		size = 55
		refs = "0023 _write_char"
	strings:
		$1 = { F6 47 0C 40 53 56 8B F0 8B D9 74 21 83 7F 08 00 75 1B 8B 44 24 0C 01 06 EB 1A 8A 03 FF 4C 24 0C 8B CF E8 ?? ?? ?? ?? 43 83 3E FF 74 07 83 7C 24 0C 00 7F E6 5E 5B C3 }
	condition:
		$1
}

rule file_401_6_0 {
	meta:
		name = "__output"
		size = 2042
		refs = "000f ___security_cookie 0061 ___lookuptable 0088 $L2510 021e __pctype 023c _write_char 02d9 ___wnullstring 0344 _wctomb 03f9 ___nullstring 0437 _malloc 0478 __cfltcvt_tab 04b8 _strlen 0655 __aulldvrm 06f0 _write_multi_char 0707 _write_string 07a8 _free 07ce @__security_check_cookie@4 07da $NORMAL_STATE$2093 07de $L2099 07e2 $L2100 07e6 $L2110 07ea $L2114 07ee $L2115 07f2 $L2119 07f6 $L2135"
	strings:
		$1 = { 55 8D AC 24 2C FE FF FF 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 89 85 D0 01 00 00 33 C0 89 45 B8 89 45 B4 89 45 A0 8B 85 E0 01 00 00 53 8A 18 33 C9 84 DB 0F 84 8C 07 00 00 56 57 8B F8 EB 03 8B 4D 90 47 83 7D B4 00 89 BD E0 01 00 00 0F 8C 70 07 00 00 80 FB 20 7C 14 80 FB 78 7F 0F 0F BE C3 0F BE 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 0F BE 84 C1 ?? ?? ?? ?? 6A 07 C1 F8 04 59 3B C1 89 45 90 0F 87 2C 07 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 4D C0 FF 89 45 94 89 45 9C 89 45 A8 89 45 AC 89 45 C4 89 45 A4 E9 08 07 00 00 0F BE C3 83 E8 20 74 3B 83 E8 03 74 2D 83 E8 08 74 1F 48 48 74 12 83 E8 03 0F 85 E9 06 00 00 83 4D C4 08 E9 E0 06 00 00 83 4D C4 04 E9 D7 06 00 00 83 4D C4 01 E9 CE 06 00 00 80 4D C4 80 E9 C5 06 00 00 83 4D C4 02 E9 BC 06 00 00 80 FB 2A 75 27 83 85 E4 01 00 00 04 8B 85 E4 01 00 00 8B 40 FC 85 C0 89 45 A8 0F 8D 9C 06 00 00 83 4D C4 04 F7 5D A8 E9 90 06 00 00 8B 45 A8 0F BE CB 8D 04 80 8D 44 41 D0 89 45 A8 E9 7B 06 00 00 83 65 C0 00 E9 72 06 00 00 80 FB 2A 75 24 83 85 E4 01 00 00 04 8B 85 E4 01 00 00 8B 40 FC 85 C0 89 45 C0 0F 8D 52 06 00 00 83 4D C0 FF E9 49 06 00 00 8B 45 C0 0F BE CB 8D 04 80 8D 44 41 D0 89 45 C0 E9 34 06 00 00 80 FB 49 74 2E 80 FB 68 74 20 80 FB 6C 74 12 80 FB 77 0F 85 1C 06 00 00 80 4D C5 08 E9 13 06 00 00 83 4D C4 10 E9 0A 06 00 00 83 4D C4 20 E9 01 06 00 00 8A 07 3C 36 75 17 80 7F 01 34 75 11 47 47 80 4D C5 80 89 BD E0 01 00 00 E9 E4 05 00 00 3C 33 75 17 80 7F 01 32 75 11 47 47 80 65 C5 7F 89 BD E0 01 00 00 E9 C9 05 00 00 3C 64 0F 84 C1 05 00 00 3C 69 0F 84 B9 05 00 00 3C 6F 0F 84 B1 05 00 00 3C 75 0F 84 A9 05 00 00 3C 78 0F 84 A1 05 00 00 3C 58 0F 84 99 05 00 00 83 65 90 00 8B 0D ?? ?? ?? ?? 83 65 A4 00 0F B6 C3 F6 44 41 01 80 74 19 8B 8D DC 01 00 00 8D 75 B4 8A C3 E8 ?? ?? ?? ?? 8A 1F 47 89 BD E0 01 00 00 8B 8D DC 01 00 00 8D 75 B4 8A C3 E8 ?? ?? ?? ?? E9 53 05 00 00 0F BE C3 83 F8 67 0F 8F 58 02 00 00 83 F8 65 0F 8D 86 00 00 00 83 F8 58 0F 8F DE 00 00 00 0F 84 C1 02 00 00 83 E8 43 0F 84 8E 00 00 00 48 48 74 60 48 48 74 5C 83 E8 0C 0F 85 01 04 00 00 66 F7 45 C4 30 08 75 04 80 4D C5 08 8B 4D C0 83 F9 FF 75 05 B9 FF FF FF 7F 83 85 E4 01 00 00 04 66 F7 45 C4 10 08 8B 85 E4 01 00 00 8B 40 FC 89 45 BC 0F 84 44 02 00 00 85 C0 75 08 A1 ?? ?? ?? ?? 89 45 BC 8B 45 BC C7 45 A4 01 00 00 00 E9 1B 02 00 00 C7 45 94 01 00 00 00 80 C3 20 83 4D C4 40 83 7D C0 00 8D 75 C8 89 75 BC 0F 8D F9 00 00 00 C7 45 C0 06 00 00 00 E9 34 01 00 00 66 F7 45 C4 30 08 75 04 80 4D C5 08 83 85 E4 01 00 00 04 66 F7 45 C4 10 08 8B 85 E4 01 00 00 74 65 0F BF 40 FC 50 8D 45 C8 50 E8 ?? ?? ?? ?? 85 C0 59 59 89 45 B8 7D 5B C7 45 9C 01 00 00 00 EB 52 83 E8 5A 74 58 83 E8 09 74 C1 48 0F 85 32 03 00 00 83 4D C4 40 C7 45 B8 0A 00 00 00 8B 5D C4 BE 00 80 00 00 85 DE 0F 84 33 02 00 00 8B 8D E4 01 00 00 8B 01 8B 51 04 83 C1 08 89 8D E4 01 00 00 E9 48 02 00 00 8A 40 FC 88 45 C8 C7 45 B8 01 00 00 00 8D 45 C8 89 45 BC E9 E6 02 00 00 83 85 E4 01 00 00 04 8B 85 E4 01 00 00 8B 40 FC 85 C0 74 2D 8B 48 04 85 C9 74 26 F6 45 C5 08 0F BF 00 89 4D BC 74 11 99 2B C2 D1 F8 C7 45 A4 01 00 00 00 E9 AB 02 00 00 83 65 A4 00 E9 A2 02 00 00 A1 ?? ?? ?? ?? 89 45 BC 50 E9 B1 00 00 00 75 0E 80 FB 67 75 40 C7 45 C0 01 00 00 00 EB 37 B8 00 02 00 00 39 45 C0 7E 03 89 45 C0 BF A3 00 00 00 39 7D C0 7E 20 8B 45 C0 05 5D 01 00 00 50 E8 ?? ?? ?? ?? 85 C0 59 89 45 A0 74 07 89 45 BC 8B F0 EB 03 89 7D C0 8B 85 E4 01 00 00 8B 08 FF 75 94 83 C0 08 FF 75 C0 89 85 E4 01 00 00 8B 40 FC 89 45 84 0F BE C3 50 8D 45 80 56 50 89 4D 80 FF 15 ?? ?? ?? ?? 8B 7D C4 83 C4 14 81 E7 80 00 00 00 74 0E 83 7D C0 00 75 08 56 FF 15 ?? ?? ?? ?? 59 80 FB 67 75 0C 85 FF 75 08 56 FF 15 ?? ?? ?? ?? 59 80 3E 2D 75 08 80 4D C5 01 46 89 75 BC 56 E8 ?? ?? ?? ?? 59 E9 D8 01 00 00 83 E8 69 0F 84 A0 FE FF FF 83 E8 05 0F 84 B5 00 00 00 48 0F 84 94 00 00 00 48 74 5E 83 E8 03 0F 84 C1 FD FF FF 48 48 0F 84 80 FE FF FF 83 E8 03 0F 85 A5 01 00 00 C7 45 98 27 00 00 00 EB 45 49 66 83 38 00 74 06 40 40 85 C9 75 F3 2B 45 BC D1 F8 E9 82 01 00 00 85 C0 75 08 A1 ?? ?? ?? ?? 89 45 BC 8B 45 BC EB 07 49 80 38 00 74 05 40 85 C9 75 F5 2B 45 BC E9 5E 01 00 00 C7 45 C0 08 00 00 00 89 4D 98 F6 45 C4 80 C7 45 B8 10 00 00 00 0F 84 1F FE FF FF 8A 45 98 04 51 C6 45 B0 30 88 45 B1 C7 45 AC 02 00 00 00 E9 07 FE FF FF F6 45 C4 80 C7 45 B8 08 00 00 00 0F 84 F6 FD FF FF 80 4D C5 02 E9 ED FD FF FF 83 85 E4 01 00 00 04 F6 45 C4 20 8B 85 E4 01 00 00 8B 40 FC 74 09 66 8B 4D B4 66 89 08 EB 05 8B 4D B4 89 08 C7 45 9C 01 00 00 00 E9 E5 01 00 00 83 85 E4 01 00 00 04 F6 C3 20 8B 85 E4 01 00 00 74 12 F6 C3 40 74 07 0F BF 40 FC 99 EB 10 0F B7 40 FC EB F7 F6 C3 40 8B 40 FC 75 EF 33 D2 F6 C3 40 74 15 85 D2 7F 11 7C 04 85 C0 73 0B F7 D8 83 D2 00 F7 DA 80 4D C5 01 85 75 C4 8B D8 8B FA 75 02 33 FF 83 7D C0 00 7D 09 C7 45 C0 01 00 00 00 EB 11 83 65 C4 F7 B8 00 02 00 00 39 45 C0 7E 03 89 45 C0 8B C3 0B C7 75 04 83 65 AC 00 8D B5 C7 01 00 00 8B 45 C0 FF 4D C0 85 C0 7F 06 8B C3 0B C7 74 24 8B 45 B8 99 52 50 57 53 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 5D 8C 8B D8 8B FA 7E 03 03 4D 98 88 0E 4E EB CC 8D 85 C7 01 00 00 2B C6 46 F6 45 C5 02 89 45 B8 89 75 BC 74 18 8B CE 80 39 30 75 04 85 C0 75 0D FF 4D BC 8B 4D BC C6 01 30 40 89 45 B8 83 7D 9C 00 0F 85 F7 00 00 00 8B 5D C4 F6 C3 40 74 26 F6 C7 01 74 06 C6 45 B0 2D EB 14 F6 C3 01 74 06 C6 45 B0 2B EB 09 F6 C3 02 74 0B C6 45 B0 20 C7 45 AC 01 00 00 00 8B 75 A8 2B 75 AC 2B 75 B8 F6 C3 0C 75 14 FF B5 DC 01 00 00 8D 45 B4 56 6A 20 E8 ?? ?? ?? ?? 83 C4 0C FF 75 AC 8B BD DC 01 00 00 8D 45 B4 8D 4D B0 E8 ?? ?? ?? ?? F6 C3 08 59 74 14 F6 C3 04 75 0F 57 56 6A 30 8D 45 B4 E8 ?? ?? ?? ?? 83 C4 0C 83 7D A4 00 74 4A 83 7D B8 00 7E 44 8B 45 B8 8B 5D BC 89 45 8C FF 4D 8C 33 C0 66 8B 03 50 8D 85 C8 01 00 00 50 E8 ?? ?? ?? ?? 43 59 43 85 C0 59 7E 2D 8B BD DC 01 00 00 50 8D 45 B4 8D 8D C8 01 00 00 E8 ?? ?? ?? ?? 83 7D 8C 00 59 75 C7 EB 0F FF 75 B8 8B 4D BC 8D 45 B4 E8 ?? ?? ?? ?? 59 F6 45 C4 04 74 14 FF B5 DC 01 00 00 8D 45 B4 56 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 83 7D A0 00 74 0D FF 75 A0 E8 ?? ?? ?? ?? 83 65 A0 00 59 8B BD E0 01 00 00 8A 1F 84 DB 0F 85 7C F8 FF FF 5F 5E 8B 8D D0 01 00 00 8B 45 B4 5B E8 ?? ?? ?? ?? 81 C5 D4 01 00 00 C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "__gcvt"
		size = 140
		refs = "000b __fltout 0031 __cftof 0046 __cftoe 0053 ___decimal_point"
	strings:
		$1 = { 55 8B EC 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 48 04 8B 45 10 8D 51 FF 83 FA FF 7C 1B 8D 70 FF 3B D6 7F 14 2B C1 50 FF 75 14 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C EB 13 6A 00 48 50 FF 75 14 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B F0 EB 09 3A 0D ?? ?? ?? ?? 74 07 40 8A 08 84 C9 75 F1 8A 08 40 84 C9 74 20 EB 06 80 F9 65 74 07 40 8A 08 84 C9 75 F4 8B D0 48 80 38 30 74 FA 8A 0A 40 42 84 C9 88 08 75 F6 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "___ascii_memicmp"
		size = 89
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 45 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 83 C6 01 8A 07 83 C7 01 38 C4 74 18 38 FC 72 06 38 DC 77 02 02 E6 38 F8 72 06 38 D8 77 02 02 C6 38 C4 75 07 83 E9 01 75 D5 EB 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "__ftime64"
		size = 269
		refs = "000c ___security_cookie 0017 ___tzset 001c __timezone 0033 __imp__GetSystemTimeAsFileTime@4 0047 __aulldiv 004d _elapsed_minutes_cache 0067 __imp__GetTimeZoneInformation@4 0084 _dstflag_cache 00d6 __aullrem 0104 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC C0 00 00 00 A1 ?? ?? ?? ?? 53 56 57 89 45 70 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 6A 3C 99 59 F7 F9 8B 75 7C 66 89 46 0A 8D 45 BC 50 FF 15 ?? ?? ?? ?? 8B 7D C0 8B 5D BC 6A 00 68 00 46 C3 23 57 53 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 89 45 B4 89 55 B8 75 08 3B 15 ?? ?? ?? ?? 74 53 8D 45 C4 50 FF 15 ?? ?? ?? ?? 83 F8 FF 74 27 83 F8 02 75 19 66 83 7D 5E 00 74 12 83 7D 6C 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 10 83 25 ?? ?? ?? ?? 00 EB 07 83 0D ?? ?? ?? ?? FF 8B 45 B4 8B 7D C0 8B 5D BC A3 ?? ?? ?? ?? 8B 45 B8 A3 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 6A 00 68 10 27 00 00 57 53 66 89 46 0C E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 6A 00 81 C3 00 80 C1 2A 68 80 96 98 00 81 D7 21 4E 62 FE 57 53 66 89 46 08 E8 ?? ?? ?? ?? 8B 4D 70 5F 89 06 89 56 04 5E 5B E8 ?? ?? ?? ?? 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "__chsize"
		size = 348
		refs = "0009 __chkstk 000e ___security_cookie 001b __nhandle 0030 ___pioinfo 0049 __lseek 008c _memset 0097 __setmode 00b6 __write 00cc __doserrno 00d5 _errno 00fc __get_osfhandle 0106 __imp__SetEndOfFile@4 0124 __imp__GetLastError@0 0156 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC B8 08 10 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 53 8B 5D 08 56 33 F6 3B 1D ?? ?? ?? ?? 89 45 FC 0F 83 1B 01 00 00 8B C3 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B CB 83 E1 1F F6 44 C8 04 01 0F 84 FF 00 00 00 6A 01 56 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 89 85 F8 EF FF FF 0F 84 EE 00 00 00 6A 02 56 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 D9 00 00 00 57 8B 7D 0C 2B F8 85 FF 7E 6F 68 00 10 00 00 8D 85 FC EF FF FF 56 50 E8 ?? ?? ?? ?? 68 00 80 00 00 53 E8 ?? ?? ?? ?? 83 C4 14 89 45 08 B8 00 10 00 00 3B F8 7D 02 8B C7 50 8D 85 FC EF FF FF 50 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 08 2B F8 85 FF 7F D9 EB 16 83 3D ?? ?? ?? ?? 05 75 0A C7 05 ?? ?? ?? ?? 0D 00 00 00 83 CE FF FF 75 08 53 E8 ?? ?? ?? ?? 59 59 EB 40 7D 3E 6A 00 FF 75 0C 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 10 50 FF 15 ?? ?? ?? ?? 8B F0 F7 DE 1B F6 F7 DE 4E 83 FE FF 75 15 C7 05 ?? ?? ?? ?? 0D 00 00 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 00 FF B5 F8 EF FF FF 53 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 5F EB 0D C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 8B 4D FC 5E 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "_fread"
		size = 233
		refs = "0060 _memcpy 0092 __read 00ab __filbuf"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 08 57 8B 7D 0C 0F AF 7D 10 85 FF 8B CF 89 7D F8 89 4D 08 75 07 33 C0 E9 AB 00 00 00 56 8B 75 14 66 F7 46 0C 0C 01 74 08 8B 46 18 89 45 FC EB 0C C7 45 FC 00 10 00 00 EB 03 8B 4D 08 66 F7 46 0C 0C 01 74 2A 8B 46 04 85 C0 74 23 3B C8 8B F9 72 02 8B F8 57 FF 36 53 E8 ?? ?? ?? ?? 29 7D 08 29 7E 04 01 3E 83 C4 0C 03 DF 8B 7D F8 EB 4B 3B 4D FC 72 2E 83 7D FC 00 8B C1 74 09 33 D2 F7 75 FC 8B C1 2B C2 50 53 FF 76 10 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 36 83 F8 FF 74 41 29 45 08 03 D8 EB 18 56 E8 ?? ?? ?? ?? 83 F8 FF 59 74 22 88 03 8B 46 18 43 FF 4D 08 89 45 FC 83 7D 08 00 0F 85 76 FF FF FF 8B 45 10 5E 5F 5B C9 C3 83 4E 0C 10 8B C7 2B 45 08 33 D2 F7 75 0C EB EB 83 4E 0C 20 EB EE }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "_strtok"
		size = 173
		refs = "0007 ___security_cookie 0045 ?nextoken@?1??strtok@@9@9 00a7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 53 56 8B 75 0C 57 6A 08 59 89 45 FC 33 C0 8D 7D DC 6A 07 F3 AB 5F 8A 16 0F B6 CA 8B C1 23 CF B3 01 D2 E3 C1 E8 03 8D 44 05 DC 08 18 46 84 D2 75 E5 8B 55 08 85 D2 75 0D 8B 15 ?? ?? ?? ?? EB 05 84 C0 74 1A 42 8A 02 0F B6 F0 33 DB 8B CE 23 CF 43 D3 E3 C1 EE 03 8A 4C 35 DC 84 D9 75 E2 8B DA EB 18 0F B6 32 33 C0 8B CE 23 CF 40 D3 E0 C1 EE 03 8A 4C 35 DC 84 C1 75 08 42 80 3A 00 75 E3 EB 04 C6 02 00 42 8B 4D FC 8B C3 2B C2 F7 D8 5F 1B C0 23 C3 5E 89 15 ?? ?? ?? ?? 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "_towupper"
		size = 129
		refs = "0014 ___lc_handle 003e _iswctype 0050 ___lc_codepage 006c ___crtLCMapStringW"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 66 3D FF FF 75 05 66 0B C0 C9 C3 83 3D ?? ?? ?? ?? 00 75 19 66 3D 61 00 72 0E 66 3D 7A 00 77 08 0F B7 C0 83 E8 20 C9 C3 0F B7 C0 C9 C3 66 3D 00 01 73 14 6A 02 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 06 66 8B 45 08 C9 C3 FF 35 ?? ?? ?? ?? 8D 45 FC 6A 01 50 6A 01 8D 45 08 50 68 00 02 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 66 8B 45 08 74 04 66 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "__telli64"
		size = 19
		refs = "000b __lseeki64"
	strings:
		$1 = { 6A 01 6A 00 6A 00 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "_wcsncnt"
		size = 47
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8B 45 08 33 D2 3B CA 74 1B 66 39 10 74 05 40 40 49 75 F6 3B CA 74 0D 66 39 10 75 08 2B 45 08 D1 F8 40 5D C3 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "_wcstombs"
		size = 441
		refs = "0007 ___security_cookie 0033 ___lc_handle 006e ___mb_cur_max 00aa ___lc_codepage 00b0 __imp__WideCharToMultiByte@32 00fa __imp__GetLastError@0 0105 _errno 0117 @__security_check_cookie@4 0182 _wcslen"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 53 56 57 8B 7D 08 33 DB 33 F6 3B FB 89 45 FC 89 5D F0 0F 84 53 01 00 00 8B 55 10 3B D3 75 07 33 C0 E9 DF 00 00 00 39 1D ?? ?? ?? ?? 75 33 3B D3 0F 86 31 01 00 00 8B 4D 0C 66 81 39 FF 00 0F 87 B4 00 00 00 8A 01 88 04 3E 66 8B 01 41 41 66 85 C0 0F 84 10 01 00 00 46 3B F2 72 DD E9 06 01 00 00 83 3D ?? ?? ?? ?? 01 75 53 3B D3 76 23 8B 45 0C 8B CA 66 39 18 74 05 40 40 49 75 F6 3B CB 74 10 66 39 18 75 0B 2B 45 0C D1 F8 40 89 45 10 8B D0 8D 45 F0 50 53 52 57 52 FF 75 0C 53 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B C3 74 4B 39 5D F0 75 46 38 5C 38 FF 75 4D E9 EB 00 00 00 8D 45 F0 50 53 52 57 8B 3D ?? ?? ?? ?? 6A FF FF 75 0C 53 FF 35 ?? ?? ?? ?? FF D7 8B F0 3B F3 74 0A 39 5D F0 75 15 8D 46 FF EB 1D 39 5D F0 75 0B FF 15 ?? ?? ?? ?? 83 F8 7A 74 6A C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF 8B 4D FC 5F 5E 5B E8 ?? ?? ?? ?? C9 C3 8D 45 F0 50 53 FF 35 ?? ?? ?? ?? 8D 45 F4 50 6A 01 FF 75 0C 53 FF 35 ?? ?? ?? ?? FF D7 3B C3 89 45 EC 74 C2 39 5D F0 75 BD 8D 0C 30 3B 4D 10 77 24 33 D2 3B C3 7E 15 8A 4C 15 F4 3A CB 8B 45 08 88 0C 06 74 10 42 46 3B 55 EC 7C EB 83 45 0C 02 3B 75 10 72 AB 8B C6 EB 9A 39 1D ?? ?? ?? ?? 75 0B FF 75 0C E8 ?? ?? ?? ?? 59 EB 87 8D 45 F0 50 53 53 53 6A FF FF 75 0C 53 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B C3 0F 84 59 FF FF FF 39 5D F0 0F 85 50 FF FF FF 48 E9 57 FF FF FF }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "_swap"
		size = 32
	strings:
		$1 = { 3B C1 56 8B F2 74 17 85 F6 74 13 53 8D 64 24 00 8A 19 8A 10 88 18 40 88 11 41 4E 75 F3 5B 5E C3 }
	condition:
		$1
}

rule file_415_1_0 {
	meta:
		name = "_shortsort"
		size = 109
	strings:
		$1 = { 8B 4C 24 04 55 8B 6C 24 0C 57 8B F8 3B F9 76 5A 53 56 8D 34 29 3B F7 8B D9 77 1E EB 03 8D 49 00 53 56 FF 54 24 24 83 C4 08 85 C0 7E 02 8B DE 03 F5 3B F7 76 EB 8B 4C 24 14 3B DF 8B C7 74 23 85 ED 74 1F 8B CB 2B CF 8B F5 8D A4 24 00 00 00 00 8A 18 8A 14 01 88 1C 01 88 10 40 4E 75 F2 8B 4C 24 14 2B FD 3B F9 77 AA 5E 5B 5F 5D C3 }
	condition:
		$1
}

rule file_415_2_0 {
	meta:
		name = "_qsort"
		size = 643
		refs = "0060 _shortsort"
	strings:
		$1 = { 8B 44 24 08 81 EC 00 01 00 00 83 F8 02 0F 82 69 02 00 00 55 8B AC 24 10 01 00 00 85 ED 0F 84 58 02 00 00 53 8B 9C 24 0C 01 00 00 56 8D 70 FF 0F AF F5 03 F3 C7 44 24 14 00 00 00 00 89 5C 24 0C 89 74 24 10 57 8B C6 2B C3 33 D2 F7 F5 40 83 F8 08 77 3C 8B 84 24 20 01 00 00 50 55 53 8B C6 E8 ?? ?? ?? ?? 83 C4 0C 8B 44 24 18 48 89 44 24 18 0F 88 02 02 00 00 8B 54 84 20 8B 84 84 98 00 00 00 89 54 24 10 89 44 24 14 8B DA 8B F0 EB B6 D1 E8 0F AF C5 03 C3 8B F8 57 53 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E 22 3B DF 8B C7 74 1C 8B CB 2B CF 8B F5 8A 18 8A 14 01 88 1C 01 88 10 40 4E 75 F2 8B 5C 24 10 8B 74 24 14 56 53 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E 22 3B DE 8B C6 74 1C 8B CB 2B CE 8B F5 8A 18 8A 14 01 88 1C 01 88 10 40 4E 75 F2 8B 5C 24 10 8B 74 24 14 56 57 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E 1E 3B FE 8B C6 74 18 8B CF 2B CE 8B F5 8A 18 8A 14 01 88 1C 01 88 10 40 4E 75 F2 8B 5C 24 10 8B 74 24 14 8B FF 3B FB 76 1C 03 DD 3B DF 73 16 57 53 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E EA 3B FB 77 22 8B FF 8B 44 24 14 03 DD 3B D8 77 16 57 53 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E E6 8D 9B 00 00 00 00 2B F5 3B F7 76 10 57 56 FF 94 24 28 01 00 00 83 C4 08 85 C0 7F EA 3B DE 77 42 8B C6 74 2F 8B 8C 24 1C 01 00 00 8B EB 2B EE 89 4C 24 1C 8D 49 00 8A 0C 28 8A 10 88 14 28 88 08 8B 4C 24 1C 40 49 89 4C 24 1C 75 EA 8B AC 24 1C 01 00 00 3B FE 0F 85 6B FF FF FF 8B FB E9 64 FF FF FF 03 F5 3B FE 73 1E 2B F5 3B F7 76 18 57 56 FF 94 24 28 01 00 00 83 C4 08 85 C0 74 EA 3B FE 72 1E 8D 64 24 00 8B 44 24 10 2B F5 3B F0 76 14 57 56 FF 94 24 28 01 00 00 83 C4 08 85 C0 74 E6 8B 44 24 10 8B 54 24 14 8B CA 8B FE 2B CB 2B F8 3B F9 7C 2D 3B C6 73 14 8B 4C 24 18 89 44 8C 20 89 B4 8C 98 00 00 00 41 89 4C 24 18 3B DA 0F 83 29 FE FF FF 8B 74 24 14 89 5C 24 10 E9 FA FD FF FF 3B DA 73 14 8B 4C 24 18 89 5C 8C 20 89 94 8C 98 00 00 00 41 89 4C 24 18 3B C6 0F 83 FC FD FF FF 8B 5C 24 10 89 74 24 14 E9 CD FD FF FF 5F 5E 5B 5D 81 C4 00 01 00 00 C3 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "__mbschr"
		size = 103
		refs = "0005 ___ismbcodepage 000e _strchr 001c __mbctype"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 8B 4D 08 EB 31 0F B6 D0 F6 82 ?? ?? ?? ?? 04 74 1C 41 8A 11 84 D2 74 39 0F B7 C0 0F B6 D2 C1 E0 08 0B C2 39 45 0C 75 0D 8D 41 FF 5D C3 0F B7 D0 39 55 0C 74 0A 41 66 0F B6 01 66 85 C0 75 C6 0F B7 D0 8B 45 0C 2B C2 F7 D8 1B C0 F7 D0 23 C1 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "__make_time_t"
		size = 448
		refs = "004f __days 015f ___tzset 0164 __timezone 0170 _localtime 018d __dstbias 01a4 _gmtime"
	strings:
		$1 = { 55 8B EC 51 56 57 8B F8 8B 4F 14 83 F9 45 7C 72 BE 8B 00 00 00 3B CE 7F 69 8B 47 10 85 C0 7C 05 83 F8 0B 7E 21 53 6A 0C 99 5B F7 FB 5B 03 C8 85 D2 89 57 10 7D 07 83 C2 0C 89 57 10 49 83 F9 45 7C 40 3B CE 7F 3C F6 C1 03 8B 47 10 8B 14 85 ?? ?? ?? ?? 75 06 83 F8 01 7E 01 42 8D 41 FF 69 C9 6D 01 00 00 C1 F8 02 03 C2 8D 84 01 21 9C FF FF 85 C0 8B 4F 0C 8D 34 08 7C 0F 85 C9 7C 13 85 F6 7D 0F 83 C8 FF 5F 5E C9 C3 85 C9 7D 04 85 F6 7D F1 8D 0C 76 C1 E1 03 85 F6 74 11 8B C1 99 F7 FE 33 D2 83 F8 18 0F 95 C2 8B C2 EB 02 33 C0 85 C0 75 D0 85 C9 8B 47 08 8D 34 08 7C 0A 85 C0 7C 0E 85 F6 7C BE EB 08 85 C0 7D 04 85 F6 7D B4 8B CE 6B C9 3C 85 F6 74 11 8B C1 99 F7 FE 33 D2 83 F8 3C 0F 95 C2 8B C2 EB 02 33 C0 85 C0 75 94 85 C9 8B 47 04 8D 34 08 7C 0A 85 C0 7C 12 85 F6 7C 82 EB 0C 85 C0 7D 08 85 F6 0F 8D 74 FF FF FF 8B CE 6B C9 3C 85 F6 74 11 8B C1 99 F7 FE 33 D2 83 F8 3C 0F 95 C2 8B C2 EB 02 33 C0 85 C0 0F 85 50 FF FF FF 85 C9 8B 07 8D 14 08 89 55 FC 7C 0E 85 C0 7C 16 85 D2 0F 8C 38 FF FF FF EB 0C 85 C0 7D 08 85 D2 0F 8D 2A FF FF FF 83 7D 08 00 74 41 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 01 45 FC 8D 45 FC 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 05 FF FF FF 8B 4F 20 85 C9 7F 08 7D 2B 83 78 20 00 7E 25 A1 ?? ?? ?? ?? 01 45 FC 8D 45 FC 50 E8 ?? ?? ?? ?? EB 09 8D 45 FC 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 D1 FE FF FF 6A 09 8B F0 8B 45 FC 59 F3 A5 E9 C5 FE FF FF }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "__mbsicoll"
		size = 48
		refs = "0002 ___mbcodepage 0016 ___mblcid 001b ___crtCompareStringA"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? 6A FF FF 74 24 10 6A FF FF 74 24 14 6A 01 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 06 B8 FF FF FF 7F C3 83 C0 FE C3 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "_ftell"
		size = 345
		refs = "0021 __lseek 005a ___pioinfo 0091 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 57 8B 7D 08 8B 77 10 33 DB 39 5F 04 89 75 F4 7D 03 89 5F 04 6A 01 53 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 89 45 FC 7C 6A 8B 57 0C 66 F7 C2 08 01 75 08 2B 47 04 E9 13 01 00 00 8B 07 8B 4F 08 8B D8 2B D9 F6 C2 03 89 5D F8 74 39 8B D6 C1 FA 05 8B 14 95 ?? ?? ?? ?? 8B DE 83 E3 1F F6 44 DA 04 80 74 13 8B D1 3B D0 73 0D 80 3A 0A 75 03 FF 45 F8 42 3B 17 72 F3 83 7D FC 00 75 1E 8B 45 F8 E9 C9 00 00 00 84 D2 78 EE C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 B3 00 00 00 F6 47 0C 01 0F 84 A1 00 00 00 8B 57 04 85 D2 75 08 21 55 F8 E9 92 00 00 00 2B C1 03 C2 89 45 08 8B C6 C1 F8 05 83 E6 1F 8D 1C 85 ?? ?? ?? ?? 8B 03 C1 E6 03 F6 44 06 04 80 74 6A 6A 02 6A 00 FF 75 F4 E8 ?? ?? ?? ?? 83 C4 0C 3B 45 FC 75 1D 8B 47 08 8B 4D 08 03 C8 EB 09 80 38 0A 75 03 FF 45 08 40 3B C1 72 F3 F6 47 0D 20 EB 34 6A 00 FF 75 FC FF 75 F4 E8 ?? ?? ?? ?? B8 00 02 00 00 83 C4 0C 39 45 08 77 0D 8B 4F 0C F6 C1 08 74 05 F6 C5 04 74 03 8B 47 18 89 45 08 8B 03 F6 44 06 04 04 74 03 FF 45 08 8B 45 08 29 45 FC 8B 45 F8 8B 4D FC 03 C1 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_420_3_0 {
	meta:
		name = "__whiteout"
		size = 31
		refs = "0008 _fgetwc 0010 _iswspace"
	strings:
		$1 = { 57 FF 74 24 08 FF 06 E8 ?? ?? ?? ?? 8B F8 57 E8 ?? ?? ?? ?? 85 C0 59 59 75 E7 66 8B C7 5F C3 }
	condition:
		$1
}

rule file_420_4_0 {
	meta:
		name = "__winput"
		size = 3832
		refs = "0006 $T21100 000b __SEH_prolog 0010 ___security_cookie 0056 _iswctype 0073 __whiteout 007a __un_inc 008c _iswspace 010f ___mb_cur_max 011a __isctype 0127 __pctype 02cf _fgetwc 0433 ___decimal_point 043f _mbtowc 05dd _malloc 05f6 _wcstombs 060c __cfltcvt_tab 0612 _free 07c1 __alloca_probe 07de __resetstkoflw 082f _memset 0a18 _wctomb 0b8e __allmul 0bf2 __hextodec 0eb7 @__security_check_cookie@4 0ebc __SEH_epilog"
	strings:
		$1 = { 68 24 03 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 33 DB 89 9D E4 FC FF FF 89 9D D4 FC FF FF 89 9D 00 FD FF FF 89 9D 10 FD FF FF 88 9D 17 FD FF FF 89 9D 20 FD FF FF 89 9D E0 FC FF FF 8B 45 0C 0F B7 00 66 85 C0 0F 84 29 0E 00 00 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 37 FF 8D 20 FD FF FF FF 75 08 FF 75 08 8D B5 20 FD FF FF E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 59 59 83 45 0C 02 8B 45 0C 0F B7 00 50 E8 ?? ?? ?? ?? 59 85 C0 75 EB EB AC 8B 55 0C 66 83 3A 25 0F 85 1D 0E 00 00 33 C0 89 85 FC FC FF FF 89 85 EC FC FF FF 89 85 04 FD FF FF 89 85 E8 FC FF FF 89 85 18 FD FF FF 88 85 F3 FC FF FF 88 85 0F FD FF FF 88 85 1D FD FF FF 88 85 27 FD FF FF 88 85 16 FD FF FF 88 85 1F FD FF FF C6 85 1E FD FF FF 01 89 85 D8 FC FF FF BF FF 00 00 00 42 42 89 55 0C 0F B7 32 66 F7 C6 00 FF 75 4B 8B C6 23 C7 83 3D ?? ?? ?? ?? 01 7E 0F 6A 04 50 E8 ?? ?? ?? ?? 59 59 8B 55 0C EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 1E FF 85 E8 FC FF FF 8B 85 18 FD FF FF 8D 04 80 8D 44 46 D0 89 85 18 FD FF FF E9 D7 00 00 00 83 FE 4E 0F 8F 9D 00 00 00 0F 84 C8 00 00 00 83 FE 2A 0F 84 86 00 00 00 83 FE 46 0F 84 B6 00 00 00 83 FE 49 74 14 83 FE 4C 0F 85 86 00 00 00 FE 85 1E FD FF FF E9 9D 00 00 00 66 8B 4A 02 66 83 F9 36 75 24 8D 42 04 66 83 38 34 75 1B 8B D0 89 55 0C FF 85 D8 FC FF FF 83 A5 F4 FC FF FF 00 83 A5 F8 FC FF FF 00 EB 6F 66 83 F9 33 75 10 8D 42 04 66 83 38 32 75 07 8B D0 89 55 0C EB 59 66 83 F9 64 74 53 66 83 F9 69 74 4D 66 83 F9 6F 74 47 66 83 F9 78 74 41 66 83 F9 58 75 19 EB 39 FE 85 1D FD FF FF EB 31 83 FE 68 74 20 83 FE 6C 74 0D 83 FE 77 74 0E FE 85 27 FD FF FF EB 1A FE 85 1E FD FF FF FE 85 1F FD FF FF EB 0C FE 8D 1E FD FF FF FE 8D 1F FD FF FF 80 BD 27 FD FF FF 00 0F 84 C2 FE FF FF 80 BD 1D FD FF FF 00 75 1A 8B 45 10 89 85 CC FC FF FF 83 C0 04 89 45 10 8B 78 FC 89 BD 00 FD FF FF EB 06 8B BD 00 FD FF FF C6 85 27 FD FF FF 00 80 BD 1F FD FF FF 00 75 20 8B 45 0C 66 8B 00 66 3D 53 00 74 0D 66 3D 43 00 C6 85 1F FD FF FF 01 75 07 C6 85 1F FD FF FF FF 8B 45 0C 0F B7 30 83 CE 20 89 B5 08 FD FF FF 83 FE 6E 74 37 83 FE 63 74 1B 83 FE 7B 74 16 FF 75 08 8D B5 20 FD FF FF E8 ?? ?? ?? ?? 8B B5 08 FD FF FF EB 0E FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 8B D8 59 89 9D 10 FD FF FF 8B 8D E8 FC FF FF 85 C9 74 0D 83 BD 18 FD FF FF 00 0F 84 F8 0B 00 00 83 FE 6F 0F 8F 27 04 00 00 0F 84 90 07 00 00 83 FE 63 0F 84 13 03 00 00 83 FE 64 0F 84 7E 07 00 00 0F 8E 33 04 00 00 83 FE 67 7E 45 83 FE 69 74 21 83 FE 6E 0F 85 20 04 00 00 8B 85 20 FD FF FF 80 BD 1D FD FF FF 00 0F 84 E5 0A 00 00 E9 0C 0B 00 00 6A 64 5E 89 B5 08 FD FF FF 66 83 FB 2D 0F 85 C9 05 00 00 C6 85 0F FD FF FF 01 E9 C3 05 00 00 8D B5 28 FD FF FF 66 83 FB 2D 75 0F 66 89 9D 28 FD FF FF 8D B5 2A FD FF FF EB 06 66 83 FB 2B 75 1D FF 8D 18 FD FF FF FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF 83 BD E8 FC FF FF 00 74 0C 81 BD 18 FD FF FF 5D 01 00 00 7E 0A C7 85 18 FD FF FF 5D 01 00 00 F6 C7 FF 75 66 BF FF 00 00 00 8B C3 23 C7 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 37 8B 85 18 FD FF FF FF 8D 18 FD FF FF 85 C0 74 27 FF 85 04 FD FF FF 66 89 1E 46 46 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF F6 C7 FF 74 9F FF 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 DC FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B BD 18 FD FF FF 66 39 9D DC FC FF FF 0F 85 80 00 00 00 8B C7 4F 85 C0 74 79 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 8B D8 66 8B 85 DC FC FF FF 66 89 06 46 46 EB 4F 8B C3 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 2E 8B C7 4F 85 C0 74 27 FF 85 04 FD FF FF 66 89 1E 46 46 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 8B D8 59 89 9D 10 FD FF FF F6 C7 FF 74 A5 83 BD 04 FD FF FF 00 0F 84 B2 00 00 00 66 83 FB 65 74 0A 66 83 FB 45 0F 85 A2 00 00 00 8B C7 4F 85 C0 0F 84 97 00 00 00 66 C7 06 65 00 46 46 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF 66 83 FB 2D 75 07 66 89 1E 46 46 EB 06 66 83 FB 2B 75 61 8B C7 4F 85 C0 75 43 33 FF EB 56 8B C3 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 2E 8B C7 4F 85 C0 74 27 FF 85 04 FD FF FF 66 89 1E 46 46 FF 75 08 FF 85 20 FD FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 10 FD FF FF 59 F6 C7 FF 74 A5 FF 8D 20 FD FF FF FF 75 08 53 E8 ?? ?? ?? ?? 59 59 83 BD 04 FD FF FF 00 0F 84 C5 08 00 00 80 BD 1D FD FF FF 00 0F 85 8E 08 00 00 FF 85 E0 FC FF FF 66 83 26 00 8D 85 28 FD FF FF 2B F0 D1 FE 8D 74 36 02 56 E8 ?? ?? ?? ?? 59 8B F8 85 FF 0F 84 8F 08 00 00 56 8D 85 28 FD FF FF 50 57 E8 ?? ?? ?? ?? 57 FF B5 00 FD FF FF 0F BE 85 1E FD FF FF 48 50 FF 15 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 1C E9 33 08 00 00 85 C9 75 10 C7 85 E8 FC FF FF 01 00 00 00 FF 85 18 FD FF FF 80 BD 1F FD FF FF 00 7E 07 C6 85 16 FD FF FF 01 8B B5 00 FD FF FF FF 8D 20 FD FF FF FF 75 08 53 E8 ?? ?? ?? ?? 59 59 83 BD E8 FC FF FF 00 74 14 8B 85 18 FD FF FF FF 8D 18 FD FF FF 85 C0 0F 84 C9 03 00 00 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF 66 81 FB FF FF 0F 84 96 03 00 00 83 BD 08 FD FF FF 63 74 53 83 BD 08 FD FF FF 73 75 12 66 83 FB 09 72 06 66 83 FB 0D 76 06 66 83 FB 20 75 38 83 BD 08 FD FF FF 7B 0F 85 65 03 00 00 0F B7 C3 8B C8 83 E1 07 33 D2 42 D3 E2 C1 E8 03 8B 8D E4 FC FF FF 0F BE 04 08 0F BE 8D F3 FC FF FF 33 C1 85 D0 0F 84 3A 03 00 00 80 BD 1D FD FF FF 00 0F 85 26 03 00 00 80 BD 16 FD FF FF 00 0F 84 02 03 00 00 8B 85 00 FD FF FF 66 89 18 83 85 00 FD FF FF 02 E9 36 FF FF FF 8B C6 83 E8 70 0F 84 5D 03 00 00 83 E8 03 0F 84 FB FE FF FF 48 48 0F 84 53 03 00 00 83 E8 03 0F 84 06 FC FF FF 83 E8 03 74 2D 8B 45 0C 66 39 18 0F 85 92 07 00 00 FE 8D 17 FD FF FF 80 BD 1D FD FF FF 00 0F 85 E5 06 00 00 8B 85 CC FC FF FF 89 45 10 E9 D7 06 00 00 80 BD 1F FD FF FF 00 7E 07 C6 85 16 FD FF FF 01 8B 7D 0C 47 47 89 7D 0C 89 BD D0 FC FF FF 66 83 3F 5E 75 10 83 C7 02 89 BD D0 FC FF FF C6 85 F3 FC FF FF FF 83 BD E4 FC FF FF 00 75 69 83 65 FC 00 B8 00 20 00 00 E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 85 E4 FC FF FF 83 4D FC FF EB 4A 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 E4 FC FF FF 85 C0 75 0F 83 4D FC FF 8B 9D 10 FD FF FF E9 75 06 00 00 C7 85 D4 FC FF FF 01 00 00 00 83 4D FC FF 8B BD D0 FC FF FF 8B 9D 10 FD FF FF 68 00 20 00 00 6A 00 8B B5 E4 FC FF FF 56 E8 ?? ?? ?? ?? 83 C4 0C 83 BD 08 FD FF FF 7B 75 14 6A 5D 58 66 39 07 75 0C 89 85 EC FC FF FF 47 47 C6 46 0B 20 33 C0 E9 9C 00 00 00 47 47 66 3D 2D 00 75 75 66 83 BD EC FC FF FF 00 74 6B 33 C9 66 8B 0F 66 83 F9 5D 74 60 47 47 66 39 8D EC FC FF FF 73 04 8B C1 EB 0C 8B 85 EC FC FF FF 89 8D EC FC FF FF 66 39 85 EC FC FF FF 77 33 0F B7 B5 EC FC FF FF 2B 85 EC FC FF FF 40 0F B7 D0 8B C6 C1 E8 03 8B 8D E4 FC FF FF 03 C1 8B CE 83 E1 07 B3 01 D2 E3 08 18 46 4A 75 E4 8B 9D 10 FD FF FF 83 A5 EC FC FF FF 00 EB 1F 89 85 EC FC FF FF 0F B7 C8 8B C1 C1 E8 03 8B 95 E4 FC FF FF 03 C2 83 E1 07 B2 01 D2 E2 08 10 66 8B 07 66 3D 5D 00 0F 85 57 FF FF FF 66 85 C0 0F 84 6F 05 00 00 83 BD 08 FD FF FF 7B 0F 85 29 FD FF FF 89 7D 0C E9 21 FD FF FF 66 83 FB 2B 75 2C FF 8D 18 FD FF FF 75 0D 85 C9 74 09 C6 85 27 FD FF FF 01 EB 17 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF 66 83 FB 30 0F 85 76 01 00 00 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF 6A 78 5F 66 3B DF 74 53 66 83 FB 58 74 4D C7 85 04 FD FF FF 01 00 00 00 3B F7 74 26 83 BD E8 FC FF FF 00 74 0E FF 8D 18 FD FF FF 75 06 FE 85 27 FD FF FF C7 85 08 FD FF FF 6F 00 00 00 E9 1D 01 00 00 FF 8D 20 FD FF FF FF 75 08 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 FE 00 00 00 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF 83 BD E8 FC FF FF 00 74 16 83 AD 18 FD FF FF 02 83 BD 18 FD FF FF 01 7D 06 FE 85 27 FD FF FF 89 BD 08 FD FF FF E9 C3 00 00 00 53 FF B5 00 FD FF FF E8 ?? ?? ?? ?? 01 85 00 FD FF FF E9 30 FC FF FF 46 46 E9 2B FC FF FF FF 8D 20 FD FF FF FF 75 08 53 E8 ?? ?? ?? ?? 59 59 3B B5 00 FD FF FF 0F 84 30 04 00 00 80 BD 1D FD FF FF 00 0F 85 F9 03 00 00 FF 85 E0 FC FF FF 83 BD 08 FD FF FF 63 0F 84 E6 03 00 00 8B 85 00 FD FF FF 80 BD 16 FD FF FF 00 74 09 66 83 20 00 E9 CE 03 00 00 C6 00 00 E9 C6 03 00 00 C6 85 1E FD FF FF 01 66 83 FB 2D 75 09 C6 85 0F FD FF FF 01 EB 06 66 83 FB 2B 75 2C FF 8D 18 FD FF FF 75 0D 85 C9 74 09 C6 85 27 FD FF FF 01 EB 17 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF 83 BD D8 FC FF FF 00 0F 84 C3 01 00 00 80 BD 27 FD FF FF 00 0F 85 85 01 00 00 BF 80 00 00 00 83 BD 08 FD FF FF 78 0F 84 A1 00 00 00 83 BD 08 FD FF FF 70 0F 84 94 00 00 00 F6 C7 FF 0F 85 E5 00 00 00 8B C3 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 0F 84 B4 00 00 00 83 BD 08 FD FF FF 6F 75 2E 66 83 FB 38 0F 83 A1 00 00 00 8B 85 F4 FC FF FF 8B 8D F8 FC FF FF 0F A4 C1 03 C1 E0 03 89 85 F4 FC FF FF 89 8D F8 FC FF FF E9 83 00 00 00 6A 00 6A 0A FF B5 F8 FC FF FF FF B5 F4 FC FF FF E8 ?? ?? ?? ?? 89 85 F4 FC FF FF 89 95 F8 FC FF FF EB 60 F6 C7 FF 75 55 8B C3 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0B 57 50 E8 ?? ?? ?? ?? 59 59 EB 0C 8B 0D ?? ?? ?? ?? 0F B6 04 41 23 C7 85 C0 74 2A 8B 85 F4 FC FF FF 8B 8D F8 FC FF FF 0F A4 C1 04 C1 E0 04 89 85 F4 FC FF FF 89 8D F8 FC FF FF 8B F3 E8 ?? ?? ?? ?? 8B D8 EB 06 FE 85 27 FD FF FF 80 BD 27 FD FF FF 00 75 45 FF 85 04 FD FF FF 0F B7 C3 83 E8 30 99 01 85 F4 FC FF FF 11 95 F8 FC FF FF 83 BD E8 FC FF FF 00 74 11 FF 8D 18 FD FF FF 75 09 C6 85 27 FD FF FF 01 EB 23 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 8B D8 EB 10 FF 8D 20 FD FF FF FF 75 08 53 E8 ?? ?? ?? ?? 59 59 80 BD 27 FD FF FF 00 0F 84 86 FE FF FF 89 9D 10 FD FF FF 80 BD 0F FD FF FF 00 0F 84 72 01 00 00 8B 85 F4 FC FF FF F7 D8 8B 8D F8 FC FF FF 83 D1 00 F7 D9 89 85 F4 FC FF FF 89 8D F8 FC FF FF E9 4E 01 00 00 80 BD 27 FD FF FF 00 0F 85 32 01 00 00 BF 80 00 00 00 83 BD 08 FD FF FF 78 74 6A 83 BD 08 FD FF FF 70 74 61 F6 C7 FF 0F 85 9A 00 00 00 8B C3 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 6D 83 BD 08 FD FF FF 6F 75 0F 66 83 FB 38 73 5E C1 A5 FC FC FF FF 03 EB 5B 8B 85 FC FC FF FF 8D 04 80 D1 E0 89 85 FC FC FF FF EB 48 F6 C7 FF 75 3D 8B C3 25 FF 00 00 00 83 3D ?? ?? ?? ?? 01 7E 0B 57 50 E8 ?? ?? ?? ?? 59 59 EB 0C 8B 0D ?? ?? ?? ?? 0F B6 04 41 23 C7 85 C0 74 12 C1 A5 FC FC FF FF 04 8B F3 E8 ?? ?? ?? ?? 8B D8 EB 06 FE 85 27 FD FF FF 80 BD 27 FD FF FF 00 75 45 FF 85 04 FD FF FF 0F B7 C3 8B 8D FC FC FF FF 8D 44 01 D0 89 85 FC FC FF FF 83 BD E8 FC FF FF 00 74 11 FF 8D 18 FD FF FF 75 09 C6 85 27 FD FF FF 01 EB 23 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 8B D8 EB 10 FF 8D 20 FD FF FF FF 75 08 53 E8 ?? ?? ?? ?? 59 59 80 BD 27 FD FF FF 00 0F 84 D9 FE FF FF 89 9D 10 FD FF FF 80 BD 0F FD FF FF 00 74 06 F7 9D FC FC FF FF 83 BD 08 FD FF FF 46 75 07 83 A5 04 FD FF FF 00 83 BD 04 FD FF FF 00 74 71 80 BD 1D FD FF FF 00 75 3E FF 85 E0 FC FF FF 8B BD 00 FD FF FF 8B 85 FC FC FF FF 83 BD D8 FC FF FF 00 74 13 8B 85 F4 FC FF FF 89 07 8B 85 F8 FC FF FF 89 47 04 EB 10 80 BD 1E FD FF FF 00 74 04 89 07 EB 03 66 89 07 FE 85 17 FD FF FF 83 45 0C 02 0F B7 C3 83 F8 FF 0F 85 DC F1 FF FF 8B 45 0C 66 83 38 25 75 0B 66 83 78 02 6E 0F 84 C8 F1 FF FF 83 BD D4 FC FF FF 01 75 0C FF B5 E4 FC FF FF E8 ?? ?? ?? ?? 59 0F B7 C3 83 F8 FF 8B 85 E0 FC FF FF 75 0F 85 C0 75 0B 38 85 17 FD FF FF 75 03 83 C8 FF 8D A5 C0 FC FF FF 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 FF 85 20 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 89 9D 10 FD FF FF 8B 45 0C 66 8B 00 83 45 0C 02 66 3B C3 0F 84 70 FF FF FF FF 75 08 53 E8 ?? ?? ?? ?? 59 59 EB 83 }
	condition:
		$1
}

rule file_422_0_0 {
	meta:
		name = "_ungetc"
		size = 108
		refs = "0026 __getbuf"
	strings:
		$1 = { 53 8B 5C 24 08 83 FB FF 56 74 41 8B 74 24 10 8B 46 0C A8 01 75 08 84 C0 79 32 A8 02 75 2E 83 7E 08 00 75 07 56 E8 ?? ?? ?? ?? 59 8B 06 3B 46 08 75 09 83 7E 04 00 75 14 40 89 06 FF 0E F6 46 0C 40 8B 06 74 0D 38 18 74 0B 40 89 06 83 C8 FF 5E 5B C3 88 18 8B 46 0C FF 46 04 83 E0 EF 83 C8 01 89 46 0C 8B C3 25 FF 00 00 00 EB E3 }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "__chvalidator"
		size = 19
		refs = "0006 __pctype"
	strings:
		$1 = { 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B7 04 41 23 44 24 08 C3 }
	condition:
		$1
}

rule file_423_1_0 {
	meta:
		name = "__isctype"
		size = 126
		refs = "0014 __pctype 0052 ___lc_handle 005b ___lc_codepage 0068 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 8D 48 01 81 F9 00 01 00 00 77 0C 8B 0D ?? ?? ?? ?? 0F B7 04 41 EB 5B 8B C8 C1 F9 08 56 8B 35 ?? ?? ?? ?? 0F B6 D1 F6 44 56 01 80 5E 74 0F 6A 02 88 45 FD 88 4D FC C6 45 FE 00 58 EB 0A 88 45 FC 33 C0 C6 45 FD 00 40 6A 01 FF 35 ?? ?? ?? ?? 8D 4D 0A FF 35 ?? ?? ?? ?? 51 50 8D 45 FC 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 02 C9 C3 0F B7 45 0A 23 45 0C C9 C3 }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "__alldvrm"
		size = 223
	strings:
		$1 = { 57 56 55 33 FF 33 ED 8B 44 24 14 0B C0 7D 15 47 45 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 28 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B F0 8B C3 F7 64 24 18 8B C8 8B C6 F7 64 24 18 03 D1 EB 47 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 0F 3B 44 24 10 76 09 4E 2B 44 24 18 1B 54 24 1C 33 DB 2B 44 24 10 1B 54 24 14 4D 79 07 F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5D 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "_write_char"
		size = 21
		refs = "0005 __putch"
	strings:
		$1 = { 0F BE C0 50 E8 ?? ?? ?? ?? 83 F8 FF 59 75 03 09 06 C3 FF 06 C3 }
	condition:
		$1
}

rule file_425_1_0 {
	meta:
		name = "_write_multi_char"
		size = 32
		refs = "000e _write_char"
	strings:
		$1 = { 56 8B F0 EB 12 8A 44 24 08 FF 4C 24 0C E8 ?? ?? ?? ?? 83 3E FF 74 07 83 7C 24 0C 00 7F E7 5E C3 }
	condition:
		$1
}

rule file_425_2_0 {
	meta:
		name = "_write_string"
		size = 35
		refs = "000f _write_char"
	strings:
		$1 = { 56 57 8B F0 8B F9 EB 11 8A 07 FF 4C 24 0C E8 ?? ?? ?? ?? 47 83 3E FF 74 07 83 7C 24 0C 00 7F E8 5F 5E C3 }
	condition:
		$1
}

rule file_425_6_0 {
	meta:
		name = "_output"
		size = 1972
		refs = "000f ___security_cookie 0070 ___lookuptable 0095 $L2491 0224 __pctype 023c _write_char 02cf ___wnullstring 0336 _wctomb 03d7 ___nullstring 0414 _malloc 0453 __cfltcvt_tab 0493 _strlen 0636 __aulldvrm 06c7 _write_multi_char 06d7 _write_string 0762 _free 0788 @__security_check_cookie@4 0794 $NORMAL_STATE$2092 0798 $L2098 079c $L2099 07a0 $L2109 07a4 $L2113 07a8 $L2114 07ac $L2118 07b0 $L2134"
	strings:
		$1 = { 55 8D AC 24 30 FE FF FF 81 EC 50 02 00 00 A1 ?? ?? ?? ?? 53 56 8B B5 DC 01 00 00 57 8B BD D8 01 00 00 8A 1F 89 85 CC 01 00 00 33 C0 33 C9 84 DB 89 45 A8 89 45 B4 89 45 98 0F 84 3C 07 00 00 EB 09 8B B5 DC 01 00 00 8B 4D 88 47 83 7D B4 00 BA 00 08 00 00 89 BD D8 01 00 00 0F 8C 1B 07 00 00 80 FB 20 7C 14 80 FB 78 7F 0F 0F BE C3 0F BE 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 0F BE 84 C1 ?? ?? ?? ?? C1 F8 04 83 F8 07 89 45 88 0F 87 D9 06 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 4D BC FF 89 45 8C 89 45 94 89 45 9C 89 45 AC 89 45 C0 89 45 A0 E9 B5 06 00 00 0F BE C3 83 E8 20 74 3B 83 E8 03 74 2D 83 E8 08 74 1F 48 48 74 12 83 E8 03 0F 85 96 06 00 00 83 4D C0 08 E9 8D 06 00 00 83 4D C0 04 E9 84 06 00 00 83 4D C0 01 E9 7B 06 00 00 80 4D C0 80 E9 72 06 00 00 83 4D C0 02 E9 69 06 00 00 80 FB 2A 75 25 83 C6 04 89 B5 DC 01 00 00 8B 76 FC 85 F6 89 75 9C 0F 8D 4D 06 00 00 83 4D C0 04 F7 DE 89 75 9C E9 3F 06 00 00 8B 45 9C 0F BE CB 8D 04 80 8D 44 41 D0 89 45 9C E9 2A 06 00 00 83 65 BC 00 E9 21 06 00 00 80 FB 2A 75 20 83 C6 04 89 B5 DC 01 00 00 8B 76 FC 85 F6 89 75 BC 0F 8D 05 06 00 00 83 4D BC FF E9 FC 05 00 00 8B 45 BC 0F BE CB 8D 04 80 8D 44 41 D0 89 45 BC E9 E7 05 00 00 80 FB 49 74 2D 80 FB 68 74 1F 80 FB 6C 74 11 80 FB 77 0F 85 CF 05 00 00 09 55 C0 E9 C7 05 00 00 83 4D C0 10 E9 BE 05 00 00 83 4D C0 20 E9 B5 05 00 00 8A 07 3C 36 75 17 80 7F 01 34 75 11 47 47 80 4D C1 80 89 BD D8 01 00 00 E9 98 05 00 00 3C 33 75 17 80 7F 01 32 75 11 47 47 80 65 C1 7F 89 BD D8 01 00 00 E9 7D 05 00 00 3C 64 0F 84 75 05 00 00 3C 69 0F 84 6D 05 00 00 3C 6F 0F 84 65 05 00 00 3C 75 0F 84 5D 05 00 00 3C 78 0F 84 55 05 00 00 3C 58 0F 84 4D 05 00 00 83 65 88 00 8B 0D ?? ?? ?? ?? 83 65 A0 00 0F B6 C3 F6 44 41 01 80 74 13 8D 75 B4 8A C3 E8 ?? ?? ?? ?? 8A 1F 47 89 BD D8 01 00 00 8D 75 B4 8A C3 E8 ?? ?? ?? ?? E9 13 05 00 00 0F BE C3 83 F8 67 0F 8F 39 02 00 00 83 F8 65 0F 8D 81 00 00 00 83 F8 58 0F 8F D6 00 00 00 0F 84 A0 02 00 00 83 E8 43 0F 84 89 00 00 00 48 48 74 5B 48 48 74 57 83 E8 0C 0F 85 E4 03 00 00 66 F7 45 C0 30 08 75 03 09 55 C0 8B 4D BC 83 F9 FF 75 05 B9 FF FF FF 7F 83 C6 04 66 F7 45 C0 10 08 89 B5 DC 01 00 00 8B 76 FC 89 75 B8 0F 84 29 02 00 00 85 F6 75 09 8B 35 ?? ?? ?? ?? 89 75 B8 C7 45 A0 01 00 00 00 8B C6 E9 01 02 00 00 C7 45 8C 01 00 00 00 80 C3 20 83 4D C0 40 83 7D BC 00 8D 7D C4 89 7D B8 0F 8D E2 00 00 00 C7 45 BC 06 00 00 00 E9 20 01 00 00 66 F7 45 C0 30 08 75 03 09 55 C0 83 C6 04 66 F7 45 C0 10 08 89 B5 DC 01 00 00 74 59 33 C0 66 8B 46 FC 50 8D 45 C4 50 E8 ?? ?? ?? ?? 85 C0 59 59 89 45 A8 7D 4D C7 45 94 01 00 00 00 EB 44 83 E8 5A 74 4A 83 E8 09 74 C3 48 0F 85 1D 03 00 00 83 4D C0 40 C7 45 B8 0A 00 00 00 BF 00 80 00 00 85 7D C0 0F 84 1B 02 00 00 8B 06 8B 56 04 83 C6 08 E9 3E 02 00 00 8A 46 FC 88 45 C4 C7 45 A8 01 00 00 00 8D 45 C4 89 45 B8 E9 DF 02 00 00 8B 06 83 C6 04 85 C0 89 B5 DC 01 00 00 74 2C 8B 48 04 85 C9 74 25 85 55 C0 0F BF 00 89 4D B8 74 11 99 2B C2 D1 F8 C7 45 A0 01 00 00 00 E9 AA 02 00 00 83 65 A0 00 E9 A1 02 00 00 A1 ?? ?? ?? ?? 89 45 B8 50 E9 AE 00 00 00 75 0E 80 FB 67 75 43 C7 45 BC 01 00 00 00 EB 3A B8 00 02 00 00 39 45 BC 7E 03 89 45 BC 81 7D BC A3 00 00 00 7E 24 8B 45 BC 05 5D 01 00 00 50 E8 ?? ?? ?? ?? 85 C0 59 89 45 98 74 07 8B F8 89 7D B8 EB 07 C7 45 BC A3 00 00 00 8B 06 FF 75 8C 83 C6 08 FF 75 BC 89 45 80 8B 46 FC 89 45 84 0F BE C3 50 8D 45 80 57 50 89 B5 DC 01 00 00 FF 15 ?? ?? ?? ?? 8B 75 C0 83 C4 14 81 E6 80 00 00 00 74 0E 83 7D BC 00 75 08 57 FF 15 ?? ?? ?? ?? 59 80 FB 67 75 0C 85 F6 75 08 57 FF 15 ?? ?? ?? ?? 59 80 3F 2D 75 08 80 4D C1 01 47 89 7D B8 57 E8 ?? ?? ?? ?? 59 E9 DA 01 00 00 83 E8 69 0F 84 B7 FE FF FF 83 E8 05 0F 84 B7 00 00 00 48 0F 84 96 00 00 00 48 74 5C 83 E8 03 0F 84 DF FD FF FF 48 48 0F 84 97 FE FF FF 83 E8 03 0F 85 A7 01 00 00 C7 45 90 27 00 00 00 EB 47 49 66 83 38 00 74 06 40 40 85 C9 75 F3 2B C6 D1 F8 E9 85 01 00 00 85 F6 75 09 8B 35 ?? ?? ?? ?? 89 75 B8 8B C6 EB 07 49 80 38 00 74 05 40 85 C9 75 F5 2B C6 E9 62 01 00 00 C7 45 BC 08 00 00 00 C7 45 90 07 00 00 00 F6 45 C0 80 C7 45 B8 10 00 00 00 0F 84 34 FE FF FF 8A 45 90 04 51 C6 45 B0 30 88 45 B1 C7 45 AC 02 00 00 00 E9 1C FE FF FF F6 45 C0 80 C7 45 B8 08 00 00 00 0F 84 0B FE FF FF 80 4D C1 02 E9 02 FE FF FF 8B 06 83 C6 04 F6 45 C0 20 89 B5 DC 01 00 00 74 09 66 8B 4D B4 66 89 08 EB 05 8B 4D B4 89 08 C7 45 94 01 00 00 00 E9 C7 01 00 00 83 C6 04 F6 45 C0 20 74 19 F6 45 C0 40 89 B5 DC 01 00 00 74 07 0F BF 46 FC 99 EB 1A 0F B7 46 FC EB F7 F6 45 C0 40 8B 46 FC 74 03 99 EB 02 33 D2 89 B5 DC 01 00 00 F6 45 C0 40 74 15 85 D2 7F 11 7C 04 85 C0 73 0B F7 D8 83 D2 00 F7 DA 80 4D C1 01 85 7D C0 8B F0 8B DA 75 02 33 DB 83 7D BC 00 7D 09 C7 45 BC 01 00 00 00 EB 11 83 65 C0 F7 B8 00 02 00 00 39 45 BC 7E 03 89 45 BC 8B C6 0B C3 75 04 83 65 AC 00 8D BD C3 01 00 00 8B 45 BC FF 4D BC 85 C0 7F 06 8B C6 0B C3 74 24 8B 45 B8 99 52 50 53 56 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 5D A8 8B F0 8B DA 7E 03 03 4D 90 88 0F 4F EB CC 8D 85 C3 01 00 00 2B C7 47 F6 45 C1 02 89 45 A8 89 7D B8 74 14 80 3F 30 75 04 85 C0 75 0B 4F 89 7D B8 C6 07 30 40 89 45 A8 83 7D 94 00 0F 85 D4 00 00 00 8B 5D C0 F6 C3 40 74 26 F6 C7 01 74 06 C6 45 B0 2D EB 14 F6 C3 01 74 06 C6 45 B0 2B EB 09 F6 C3 02 74 0B C6 45 B0 20 C7 45 AC 01 00 00 00 8B 75 9C 2B 75 AC 2B 75 A8 F6 C3 0C 75 0D 56 6A 20 8D 45 B4 E8 ?? ?? ?? ?? 59 59 FF 75 AC 8D 45 B4 8D 4D B0 E8 ?? ?? ?? ?? F6 C3 08 59 74 12 F6 C3 04 75 0D 56 6A 30 8D 45 B4 E8 ?? ?? ?? ?? 59 59 83 7D A0 00 74 3D 83 7D A8 00 7E 37 8B 5D B8 8B 7D A8 33 C0 66 8B 03 4F 50 8D 85 C4 01 00 00 50 E8 ?? ?? ?? ?? 43 59 43 85 C0 59 7E 25 50 8D 45 B4 8D 8D C4 01 00 00 E8 ?? ?? ?? ?? 85 FF 59 75 D1 EB 0F FF 75 A8 8B 4D B8 8D 45 B4 E8 ?? ?? ?? ?? 59 F6 45 C0 04 74 0D 56 6A 20 8D 45 B4 E8 ?? ?? ?? ?? 59 59 83 7D 98 00 74 0D FF 75 98 E8 ?? ?? ?? ?? 83 65 98 00 59 8B BD D8 01 00 00 8A 1F 84 DB 0F 85 C6 F8 FF FF 8B 8D CC 01 00 00 8B 45 B4 5F 5E 5B E8 ?? ?? ?? ?? 81 C5 D0 01 00 00 C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "__spawnvpe"
		size = 355
		refs = "0012 __spawnve 0027 _errno 0038 __mbschr 0048 ??_C@_04HBHDLLBA@PATH?$AA@ 004d _getenv 0063 _malloc 008b _strlen 009e __mbsrchr 00ad ??_C@_01KICIPPFI@?2?$AA@ 00b3 _strcat 0142 __getpath 0156 _free"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 89 45 F8 0F 85 39 01 00 00 83 3D ?? ?? ?? ?? 02 0F 85 2C 01 00 00 6A 2F FF 75 0C E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 18 01 00 00 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 84 01 01 00 00 56 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 59 0F 84 EA 00 00 00 53 BB 03 01 00 00 53 56 57 E9 C1 00 00 00 80 3E 00 0F 84 CB 00 00 00 56 E8 ?? ?? ?? ?? 8D 7C 30 FF 8A 07 3C 5C 59 75 0E 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F8 EB 02 3C 2F 74 0D 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 56 E8 ?? ?? ?? ?? FF 75 0C 8B F8 E8 ?? ?? ?? ?? 03 F8 81 FF 04 01 00 00 59 59 73 7F FF 75 0C 56 E8 ?? ?? ?? ?? FF 75 14 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 83 F8 FF 89 45 F8 75 5C 83 3D ?? ?? ?? ?? 02 74 3B 6A 5C 56 E8 ?? ?? ?? ?? 3B F0 59 59 74 0E 6A 2F 56 E8 ?? ?? ?? ?? 3B F0 59 59 75 37 8D 7E 01 6A 5C 57 E8 ?? ?? ?? ?? 3B F8 59 59 74 0E 6A 2F 57 E8 ?? ?? ?? ?? 3B F8 59 59 75 18 53 56 FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 89 45 FC 0F 85 2C FF FF FF 56 E8 ?? ?? ?? ?? 59 5B 5E 5F 8B 45 F8 C9 C3 }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "_wcscat"
		size = 42
	strings:
		$1 = { 8B 44 24 04 66 83 38 00 8B D0 74 08 42 42 66 83 3A 00 75 F8 56 8B 74 24 0C 66 8B 0E 66 89 0A 42 42 46 46 66 85 C9 75 F1 5E C3 }
	condition:
		$1
}

rule file_427_1_0 {
	meta:
		name = "_wcscpy"
		size = 28
	strings:
		$1 = { 8B 4C 24 04 8B 54 24 08 66 8B 02 66 89 01 41 41 42 42 66 85 C0 75 F1 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "___strgtold12"
		size = 1159
		refs = "0007 ___security_cookie 0068 $L1134 007f ___decimal_point 0136 ___mb_cur_max 0142 __isctype 014f __pctype 03b3 ___mtold12 03f0 ___multtenpow12 0451 @__security_check_cookie@4 0457 $L845 045b $L858 045f $L871 0463 $L882 0467 $L902 046b $L923 046f $L930 0473 $L947 0477 $L941 047b $L956 047f $L1111 0483 $L974"
	strings:
		$1 = { 55 8B EC 83 EC 5C A1 ?? ?? ?? ?? 89 45 FC 53 8D 45 D0 56 89 45 C4 33 C0 33 D2 57 8B 7D 10 42 89 45 B0 89 55 B4 89 45 CC 89 45 BC 89 45 A8 89 45 A4 89 45 AC 89 45 C8 89 45 B8 89 7D C0 8A 0F 80 F9 20 74 0F 80 F9 09 74 0A 80 F9 0A 74 05 80 F9 0D 75 03 47 EB E7 6A 04 5E 8A 1F 47 83 F8 0B 0F 87 68 02 00 00 FF 24 85 ?? ?? ?? ?? 80 FB 31 7C 0C 80 FB 39 7F 07 6A 03 E9 08 02 00 00 3A 1D ?? ?? ?? ?? 75 07 6A 05 E9 37 02 00 00 0F BE C3 83 E8 2B 74 1F 48 48 74 0F 83 E8 03 0F 84 89 00 00 00 4F E9 B9 02 00 00 6A 02 58 C7 45 B0 00 80 00 00 EB A6 83 65 B0 00 6A 02 58 EB 9D 80 FB 31 89 55 BC 7C 05 80 FB 39 7E AD 3A 1D ?? ?? ?? ?? 0F 84 AE 00 00 00 80 FB 2B 74 25 80 FB 2D 74 20 80 FB 30 74 46 80 FB 43 7E B8 80 FB 45 7E 0A 80 FB 63 7E AE 80 FB 65 7F A9 6A 06 E9 C4 01 00 00 4F 6A 0B E9 BC 01 00 00 80 FB 31 7C 09 80 FB 39 0F 8E 61 FF FF FF 3A 1D ?? ?? ?? ?? 0F 84 64 FF FF FF 80 FB 30 0F 85 67 01 00 00 8B C2 E9 28 FF FF FF 89 55 BC 39 15 ?? ?? ?? ?? 0F B6 C3 7E 0E 56 50 E8 ?? ?? ?? ?? 59 33 D2 59 42 EB 0C 8B 0D ?? ?? ?? ?? 0F B6 04 41 23 C6 85 C0 74 1E 83 7D CC 19 73 10 8B 45 C4 FF 45 CC 80 EB 30 FF 45 C4 88 18 EB 03 FF 45 C8 8A 1F 47 EB B9 3A 1D ?? ?? ?? ?? 75 65 8B C6 E9 CF FE FF FF 83 7D CC 00 89 55 BC 89 55 A8 75 0D EB 06 FF 4D C8 8A 1F 47 80 FB 30 74 F5 39 15 ?? ?? ?? ?? 0F B6 C3 7E 0E 56 50 E8 ?? ?? ?? ?? 59 33 D2 59 42 EB 0C 8B 0D ?? ?? ?? ?? 0F B6 04 41 23 C6 85 C0 74 1C 83 7D CC 19 73 11 FF 45 CC 8B 45 C4 80 EB 30 FF 45 C4 FF 4D C8 88 18 8A 1F 47 EB BB 80 FB 2B 0F 84 0E FF FF FF 80 FB 2D 0F 84 05 FF FF FF E9 E5 FE FF FF 39 15 ?? ?? ?? ?? 89 55 A8 0F B6 C3 7E 0E 56 50 E8 ?? ?? ?? ?? 59 33 D2 59 42 EB 0C 8B 0D ?? ?? ?? ?? 0F B6 04 41 23 C6 85 C0 74 66 8B C6 EB 57 80 FB 31 8D 4F FE 89 4D C0 7C 05 80 FB 39 7E 44 0F BE C3 83 E8 2B 74 7A 48 48 74 6A 83 E8 03 0F 85 0A 01 00 00 6A 08 EB 6B 89 55 A4 EB 03 8A 1F 47 80 FB 30 74 F8 80 FB 31 0F 8C 33 FE FF FF 80 FB 39 0F 8F 2A FE FF FF EB 0A 80 FB 31 7C 0E 80 FB 39 7F 09 6A 09 58 4F E9 CD FD FF FF 80 FB 30 74 C3 8B 7D C0 E9 C7 00 00 00 83 7D 20 00 74 2A 0F BE C3 83 E8 2B 8D 4F FF 89 4D C0 74 14 48 48 0F 85 A9 00 00 00 83 4D B4 FF 6A 07 58 E9 98 FD FF FF 6A 07 58 E9 90 FD FF FF 6A 0A 58 4F 83 F8 0A 0F 85 83 FD FF FF E9 85 00 00 00 C7 45 A4 01 00 00 00 33 F6 83 3D ?? ?? ?? ?? 01 0F B6 C3 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 1C 0F BE CB 8D 04 B6 8D 74 41 D0 81 FE 50 14 00 00 7F 05 8A 1F 47 EB C0 BE 51 14 00 00 89 75 AC 83 3D ?? ?? ?? ?? 01 0F B6 C3 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 0F 84 48 FD FF FF 8A 1F 47 EB CE 8B F9 83 7D BC 00 8B 45 0C 89 38 0F 84 96 00 00 00 6A 18 58 39 45 CC 76 15 80 7D E7 05 7C 03 FE 45 E7 89 45 CC 8B 45 C4 48 FF 45 C8 EB 03 8B 45 C4 83 7D CC 00 0F 86 93 00 00 00 EB 06 FF 4D CC FF 45 C8 48 80 38 00 74 F4 8D 45 EC 50 FF 75 CC 8D 45 D0 50 E8 ?? ?? ?? ?? 8B 45 AC 33 C9 83 C4 0C 39 4D B4 7D 02 F7 D8 03 45 C8 39 4D A4 75 03 03 45 18 39 4D A8 75 03 2B 45 1C 3D 50 14 00 00 7F 2E 3D B0 EB FF FF 7C 3E FF 75 14 50 8D 45 EC 50 E8 ?? ?? ?? ?? 8B 55 EC 8B 5D EE 8B 75 F2 8B 45 F6 83 C4 0C EB 2F C7 45 B8 04 00 00 00 EB 1E 33 DB B8 FF 7F 00 00 BE 00 00 00 80 33 D2 C7 45 B8 02 00 00 00 EB 0F C7 45 B8 01 00 00 00 33 D2 33 C0 33 F6 33 DB 8B 4D 08 0B 45 B0 5F 89 71 06 89 59 02 66 89 41 0A 8B 45 B8 66 89 11 8B 4D FC 5E 5B E8 ?? ?? ?? ?? C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_1_0 {
	meta:
		name = "___STRINGTOLD"
		size = 76
		refs = "0007 ___security_cookie 0022 ___strgtold12 0030 __ld12told 0046 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 56 89 45 FC 33 C0 50 50 50 FF 75 14 8D 45 F0 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? FF 75 08 8B F0 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 24 83 F8 01 75 03 83 CE 02 8B 4D FC 8B C6 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "__mbsnbcmp"
		size = 174
		refs = "0011 ___ismbcodepage 001a _strncmp 0033 __mbctype"
	strings:
		$1 = { 55 8B EC 53 33 DB 39 5D 10 75 04 33 C0 EB 42 39 1D ?? ?? ?? ?? 75 07 5B 5D E9 ?? ?? ?? ?? 56 8B 75 0C 57 8B 7D 08 66 0F B6 17 FF 4D 10 0F B6 C2 47 F6 80 ?? ?? ?? ?? 04 74 2D 39 5D 10 75 15 0F B6 06 33 D2 F6 80 ?? ?? ?? ?? 04 74 48 33 C0 5F 5E 5B 5D C3 8A 07 3A C3 75 04 33 D2 EB 09 33 C9 8A EA 47 8A C8 8B D1 66 0F B6 06 0F B6 C8 46 F6 81 ?? ?? ?? ?? 04 74 1D 39 5D 10 74 09 8A 0E FF 4D 10 3A CB 75 04 33 C0 EB 0B 33 DB 8A F8 46 8A D9 8B C3 33 DB 66 3B C2 75 0C 66 3B D3 74 AE 39 5D 10 75 82 EB A7 1B C0 83 E0 02 48 EB A1 }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "__wcsnset"
		size = 41
	strings:
		$1 = { 55 8B EC 8B 4D 08 33 D2 39 55 10 8B C1 74 18 56 FF 4D 10 66 39 11 74 0E 66 8B 75 0C 66 89 31 41 41 39 55 10 75 EA 5E 5D C3 }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "__onexit"
		size = 130
		refs = "0003 ___onexitbegin 0008 __msize 000f ___onexitend 0035 _realloc"
	strings:
		$1 = { 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 0D ?? ?? ?? ?? 8B F0 A1 ?? ?? ?? ?? 8B D1 2B D0 83 C2 04 3B F2 73 4E B9 00 08 00 00 3B F1 73 02 8B CE 03 CE 51 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 17 83 C6 10 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 75 02 5E C3 8B 0D ?? ?? ?? ?? 2B 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? C1 F9 02 8D 0C 88 89 0D ?? ?? ?? ?? 8B 44 24 08 89 01 83 05 ?? ?? ?? ?? 04 5E C3 }
	condition:
		$1
}

rule file_432_1_0 {
	meta:
		name = "_atexit"
		size = 18
		refs = "0005 __onexit"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 59 48 C3 }
	condition:
		$1
}

rule file_432_2_0 {
	meta:
		name = "___onexitinit"
		size = 40
		refs = "0006 _malloc 000e ___onexitbegin 0021 ___onexitend"
	strings:
		$1 = { 68 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 59 A3 ?? ?? ?? ?? 75 04 6A 18 58 C3 83 20 00 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "___init_ctype"
		size = 476
		refs = "0007 ___security_cookie 0010 ___lc_handle 0022 ___lc_codepage 002d ___lc_id 003e ___getlocaleinfo 0053 _malloc 0097 __imp__GetCPInfo@8 00b5 ___mb_cur_max 00fb ___crtGetStringTypeA 0166 _memcpy 016e __pctype 0173 ___ctype1 0185 _free 01bf ___newctype 01d6 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 53 33 DB 39 1D ?? ?? ?? ?? 89 45 FC 89 5D E4 0F 84 8E 01 00 00 39 1D ?? ?? ?? ?? 56 57 75 23 0F B7 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 10 00 00 50 53 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 52 01 00 00 68 00 03 00 00 E8 ?? ?? ?? ?? 8B F0 C7 04 24 01 01 00 00 E8 ?? ?? ?? ?? 3B F3 59 89 45 E4 0F 84 31 01 00 00 3B C3 0F 84 29 01 00 00 33 C0 BF 00 01 00 00 8B 4D E4 88 04 08 40 3B C7 7C F5 8D 45 E8 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 FF 00 00 00 83 7D E8 05 0F 87 F5 00 00 00 0F B7 45 E8 83 F8 01 A3 ?? ?? ?? ?? 7E 2C 38 5D EE 74 27 8D 45 EF 8A 10 3A D3 74 1E 0F B6 48 FF 0F B6 D2 EB 0A 8B 55 E4 88 1C 11 0F B6 10 41 3B CA 7E F2 40 40 38 58 FF 75 DC 53 53 53 8D 86 00 01 00 00 50 57 FF 75 E4 89 45 E0 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 0F 84 98 00 00 00 8D BE FE 00 00 00 66 89 1F 83 3D ?? ?? ?? ?? 01 89 7D DC 7E 39 38 5D EE 74 34 8D 45 EF 8A 10 3A D3 74 2B 0F B6 48 FF 0F B6 D2 3B CA 7F 19 8D 94 4E 00 01 00 00 66 C7 02 00 80 0F B6 38 41 42 42 3B CF 7E F1 8B 7D DC 40 40 38 58 FF 75 CF 68 FE 00 00 00 8D 86 00 02 00 00 50 56 E8 ?? ?? ?? ?? 8B 45 E0 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0C 05 02 FF FF FF 50 E8 ?? ?? ?? ?? 59 89 3D ?? ?? ?? ?? FF 75 E4 E8 ?? ?? ?? ?? 59 5F 8B C3 5E EB 32 8B 75 E0 56 E8 ?? ?? ?? ?? 33 DB 59 43 EB E2 A1 ?? ?? ?? ?? 05 02 FF FF FF 50 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 1D ?? ?? ?? ?? 33 C0 8B 4D FC 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "__wcsicmp"
		size = 136
		refs = "0002 ___lc_handle 005b _towlower"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 53 75 40 8B 54 24 0C 8B 4C 24 08 33 DB 66 8B 19 66 83 FB 41 72 09 66 83 FB 5A 77 03 83 C3 20 33 C0 66 8B 02 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 41 41 42 42 66 85 DB 74 3B 66 3B D8 74 CA EB 34 56 8B 74 24 0C 57 8B 7C 24 14 33 C0 66 8B 06 50 E8 ?? ?? ?? ?? 46 46 8B D8 33 C0 66 8B 07 50 E8 ?? ?? ?? ?? 47 59 47 66 85 DB 59 74 05 66 3B D8 74 D8 5F 5E 0F B7 C8 0F B7 C3 2B C1 5B C3 }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "__dospawn"
		size = 465
		refs = "0035 _errno 003f __doserrno 006b _memset 0074 __nhandle 008a ___pioinfo 00af _calloc 015c __imp__CreateProcessA@40 0164 __imp__GetLastError@0 016e _free 0179 __dosmaperr 018b __exit 0194 __imp__CloseHandle@4 01a1 __imp__WaitForSingleObject@8 01ae __imp__GetExitCodeProcess@8"
	strings:
		$1 = { 55 8B EC 83 EC 68 8B 45 08 53 33 DB 3B C3 89 5D F4 88 5D FF 74 15 83 F8 01 74 10 7E 16 83 F8 03 7E 09 83 F8 04 75 0C C6 45 FF 01 8B 45 10 89 45 F0 EB 29 C7 05 ?? ?? ?? ?? 16 00 00 00 89 1D ?? ?? ?? ?? 83 C8 FF E9 83 01 00 00 40 38 18 75 FB 8D 48 01 38 19 74 05 C6 00 20 8B C1 38 18 75 EB 56 6A 44 5E 56 8D 45 98 53 50 E8 ?? ?? ?? ?? 89 75 98 8B 35 ?? ?? ?? ?? 83 C4 0C 3B F3 74 20 8D 46 FF 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 8B D0 83 E2 1F 38 5C D1 04 75 06 4E 48 3B F3 75 E3 8D 44 B6 04 66 89 45 CA 57 0F B7 C0 6A 01 50 E8 ?? ?? ?? ?? 3B F3 89 45 CC 59 89 30 8B 45 CC 59 89 5D F8 8D 48 04 8D 54 30 04 7E 39 8B 45 F8 8B 7D F8 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E7 1F 8D 3C F8 8A 47 04 A8 10 75 08 88 01 8B 07 89 02 EB 05 88 19 83 0A FF FF 45 F8 41 83 C2 04 39 75 F8 7C CA 8B 45 CC 38 5D FF 74 2C 8D 48 04 33 D2 8D 44 30 04 83 FE 03 7D 04 8B FE EB 03 6A 03 5F 3B D7 7D 0C 88 19 83 08 FF 42 41 83 C0 04 EB E4 C7 45 F4 08 00 00 00 8D 45 DC 50 8D 45 98 50 53 FF 75 14 89 1D ?? ?? ?? ?? FF 75 F4 89 1D ?? ?? ?? ?? 6A 01 53 53 FF 75 F0 FF 75 0C FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? FF 75 CC 8B F8 E8 ?? ?? ?? ?? 3B F3 59 75 0C 57 E8 ?? ?? ?? ?? 59 83 C8 FF EB 49 83 7D 08 02 75 06 53 E8 ?? ?? ?? ?? 39 5D 08 8B 35 ?? ?? ?? ?? 75 22 6A FF FF 75 DC FF 15 ?? ?? ?? ?? 8D 45 EC 50 FF 75 DC FF 15 ?? ?? ?? ?? 8B 5D EC FF 75 DC FF D6 EB 09 83 7D 08 04 74 F3 8B 5D DC FF 75 E0 FF D6 8B C3 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "_atol"
		size = 88
		refs = "000d __ismbcspace"
	strings:
		$1 = { 56 8B 74 24 08 EB 01 46 0F B6 06 50 E8 ?? ?? ?? ?? 85 C0 59 75 F1 0F B6 0E 46 83 F9 2D 8B D1 74 05 83 F9 2B 75 04 0F B6 0E 46 33 C0 83 F9 30 7C 0A 83 F9 39 7F 05 83 E9 30 EB 03 83 C9 FF 83 F9 FF 74 0C 8D 04 80 8D 04 41 0F B6 0E 46 EB DD 83 FA 2D 5E 75 02 F7 D8 C3 }
	condition:
		$1
}

rule file_436_2_0 {
	meta:
		name = "__atoi64"
		size = 121
		refs = "0010 __ismbcspace 004f __allmul"
	strings:
		$1 = { 53 55 56 57 8B 7C 24 14 EB 01 47 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 75 F1 0F B6 37 47 83 FE 2D 8B DE 74 05 83 FE 2B 75 04 0F B6 37 47 33 C0 33 D2 83 FE 30 7C 0A 83 FE 39 7F 05 83 EE 30 EB 03 83 CE FF 83 FE FF 74 20 6A 00 6A 0A 52 50 E8 ?? ?? ?? ?? 8B C8 8B EA 8B C6 0F B6 37 99 03 C8 13 EA 8B C1 8B D5 47 EB C9 5F 5E 5D 83 FB 2D 5B 75 07 F7 D8 83 D2 00 F7 DA C3 }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "_LoadOperand"
		size = 505
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 F8 1F 8B 4D 14 89 01 75 06 83 61 20 FE 5D C3 83 F8 15 74 3E 83 F8 14 74 39 83 F8 17 74 34 83 F8 1B 74 2F 80 7D 08 00 74 40 83 F8 12 6A 0D 5A 75 02 89 11 83 F8 13 75 06 C7 01 19 00 00 00 83 F8 0E 75 02 89 11 83 F8 0C 75 1F C7 01 0B 00 00 00 EB 17 80 7D 08 00 74 0B 83 F8 14 75 06 C7 01 08 00 00 00 8B 45 10 89 41 04 53 56 8B 75 18 57 33 C0 8D 51 10 8B FA AB AB AB AB 83 49 20 01 8B 39 83 FF 13 8B 41 20 8D 9E CC 00 00 00 0F 87 CE 00 00 00 0F 84 BD 00 00 00 83 EF 08 74 58 83 EF 03 74 4B 4F 74 3D 4F 74 28 4F 74 1D 83 EF 04 0F 85 39 01 00 00 83 E0 E1 89 41 20 8B 73 10 8B FA A5 A5 A5 A5 E9 25 01 00 00 83 E0 E1 E9 D3 00 00 00 83 E0 E1 89 41 20 8B 43 10 8B 00 89 02 E9 0B 01 00 00 83 E0 EB 83 C8 0A E9 B6 00 00 00 83 E0 EB 83 C8 0A EB DE 83 E0 EB 83 C8 0A 89 41 20 8B 45 10 83 E8 00 74 47 48 74 3C 48 74 31 48 74 26 48 48 74 1A 48 74 0F 48 0F 85 D0 00 00 00 8B 86 9C 00 00 00 EB B6 8B 86 A0 00 00 00 EB AE 8B 86 B4 00 00 00 EB A6 8B 86 A4 00 00 00 EB 9E 8B 86 A8 00 00 00 EB 96 8B 86 AC 00 00 00 EB 8E 8B 86 B0 00 00 00 EB 86 83 E0 E3 83 C8 02 E9 57 FF FF FF 83 EF 14 74 6A 4F 74 51 6A 02 5E 2B FE 74 43 2B FE 74 2B 4F 74 1D 4F 75 74 83 E0 EB 83 C8 0A 89 41 20 8B 45 10 83 C0 0A C1 E0 04 8B 04 18 E9 48 FF FF FF 83 E0 EB 83 C8 0A E9 19 FF FF FF 83 E0 E3 0B C6 89 41 20 8B 43 10 8B 08 89 0A 8B 40 04 EB 38 83 E0 E3 0B C6 EB 03 83 E0 E1 8B 75 10 83 C6 0A C1 E6 04 89 41 20 03 F3 E9 EE FE FF FF 83 E0 EB 83 C8 0A 89 41 20 8B 45 10 83 C0 02 C1 E0 04 8B 0C 18 89 0A 8B 44 18 04 89 42 04 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_437_1_0 {
	meta:
		name = "_LoadImm8"
		size = 79
	strings:
		$1 = { 56 8B 74 24 08 8B 0E 8B C1 C1 E8 0E 83 E0 03 83 F8 03 6A 02 5A 74 32 C1 E9 08 83 E1 07 83 F9 04 75 03 6A 03 5A 83 F8 01 75 01 42 83 F8 02 75 03 83 C2 04 85 C0 75 08 83 F9 05 75 03 83 C2 04 83 F8 01 75 05 85 C9 75 01 42 0F B6 04 32 5E C3 }
	condition:
		$1
}

rule file_437_2_0 {
	meta:
		name = "_AdjustExceptionResult"
		size = 454
		refs = "00c3 $L20746 00ca $L20755 00e9 $L20747 00f0 $L20756 0109 $L20748 0110 $L20757 012c $L20749 0133 $L20758 0186 $L20271 018a $L20270 01a6 $L20324 01aa $L20325"
	strings:
		$1 = { 8B 4C 24 08 8B 41 20 8B 50 60 F6 C2 01 0F 84 72 01 00 00 83 E2 1E 80 FA 0E 0F 85 66 01 00 00 8B 54 24 04 83 FA 52 53 56 57 0F 87 08 01 00 00 6A 07 83 CB FF 33 F6 83 FA 51 5F 73 3E 83 FA 39 0F 82 3D 01 00 00 83 FA 3A 76 08 83 FA 3C E9 ED 00 00 00 8B 50 50 2B D6 0F 84 82 00 00 00 4A 74 6E 4A 74 56 4A 75 14 8B 51 18 83 FA 02 76 09 83 FA 06 76 67 3B D7 75 03 89 70 50 8B 41 20 8B 50 50 2B D6 0F 84 9A 00 00 00 4A 0F 84 85 00 00 00 4A 74 6D 4A 0F 85 E9 00 00 00 8B 49 18 83 F9 02 76 0D 83 F9 06 76 4E 3B CF 0F 85 D4 00 00 00 89 70 50 89 70 54 E9 C9 00 00 00 8B 51 18 3B D7 77 BA 0F B6 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 51 18 83 FA 03 76 A1 3B D7 77 A0 89 58 50 EB 9B 8B 51 18 3B D7 77 94 0F B6 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 89 58 50 89 58 54 E9 83 00 00 00 8B 49 18 3B CF 77 7C 0F B6 89 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 49 18 83 F9 03 76 92 3B CF 77 62 EB D2 8B 49 18 3B CF 77 59 0F B6 89 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 83 FA 53 72 46 83 FA 54 77 41 8B 40 50 83 E8 00 74 2B 48 74 20 48 74 10 48 75 30 8B 41 1C 25 6F F7 FF FF 83 C8 45 EB 20 8B 41 1C 25 2B F7 FF FF 83 C8 01 EB 13 66 81 61 1C 2A F7 EB 0E 8B 41 1C 25 6A F7 FF FF 83 C8 40 89 41 1C 5F 5E 5B C3 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 }
	condition:
		$1
}

rule file_437_3_0 {
	meta:
		name = "_UpdateResult"
		size = 301
		refs = "0025 $L20762 002c $L20765 00f9 $L20357 00fd $L20359 0101 $L20353 0105 $L20351 0109 $L20345 010d $L20356 0111 $L20355 0115 $L20342"
	strings:
		$1 = { 8B 44 24 04 8B 10 8B 4C 24 08 53 56 83 C2 F8 83 FA 13 57 8B 78 04 8D 99 6C 01 00 00 0F 87 D3 00 00 00 0F B6 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B B9 DC 00 00 00 EB 2B 8B 50 10 8B 89 DC 00 00 00 89 11 8B 40 14 89 41 04 E9 A7 00 00 00 8B 89 DC 00 00 00 8B 40 10 89 01 E9 97 00 00 00 C1 E7 04 03 FB 8D 70 10 A5 A5 A5 A5 E9 86 00 00 00 8B 50 10 C1 E7 04 89 94 0F EC 00 00 00 8B 40 14 89 84 0F F0 00 00 00 EB 6D 83 EF 00 74 55 4F 74 47 4F 74 39 4F 74 2B 4F 4F 74 1C 4F 74 0E 4F 75 4B 8B 40 10 89 81 9C 00 00 00 EB 40 8B 40 10 89 81 A0 00 00 00 EB 35 8B 40 10 89 81 B4 00 00 00 EB 2A 8B 40 10 89 81 A4 00 00 00 EB 1F 8B 40 10 89 81 A8 00 00 00 EB 14 8B 40 10 89 81 AC 00 00 00 EB 09 8B 40 10 89 81 B0 00 00 00 8B 44 24 18 89 81 C0 00 00 00 5F 5E 5B C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 07 02 03 02 03 07 07 07 04 04 05 06 07 06 07 03 04 06 }
	condition:
		$1
}

rule file_437_4_0 {
	meta:
		name = "_ValidateResult"
		size = 78
	strings:
		$1 = { 8B 4C 24 04 8B 51 04 8B 09 53 8B D9 33 DA 32 C0 F6 C3 01 74 02 FE C0 8B D9 33 DA F6 C3 02 74 02 B0 01 8B D9 33 DA F6 C3 04 74 02 B0 01 8B D9 33 DA F6 C3 08 74 02 B0 01 8B D9 33 DA F6 C3 10 5B 74 02 B0 01 33 CA F6 C1 20 74 02 B0 01 C3 }
	condition:
		$1
}

rule file_437_5_0 {
	meta:
		name = "_ax0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 B0 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_437_6_0 {
	meta:
		name = "_ax8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 B0 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_437_7_0 {
	meta:
		name = "_ax32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 B0 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_437_8_0 {
	meta:
		name = "_cx0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 AC 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_437_9_0 {
	meta:
		name = "_cx8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 AC 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_437_10_0 {
	meta:
		name = "_cx32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 AC 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_437_11_0 {
	meta:
		name = "_dx0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 A8 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_437_12_0 {
	meta:
		name = "_dx8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 A8 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_437_13_0 {
	meta:
		name = "_dx32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 A8 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_437_14_0 {
	meta:
		name = "_bx0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 A4 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_437_15_0 {
	meta:
		name = "_bx8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 A4 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_437_16_0 {
	meta:
		name = "_bx32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 A4 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_437_17_0 {
	meta:
		name = "_sib0"
		size = 327
		refs = "0031 $L20810 00ab $L20811 0107 $L20497 010b $L20498 010f $L20499 0113 $L20500 0117 $L20501 011b $L20502 011f $L20503 0123 $L20504 0127 $L20514 012b $L20515 012f $L20516 0133 $L20517 0137 $L20518 013b $L20519 013f $L20520 0143 $L20521"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 10 0F B6 17 33 F6 8B C2 6A 07 8B CA C1 E9 06 C1 E8 03 46 5B D3 E6 8B 4D 0C 23 C3 83 F8 04 74 4D 23 C3 3B C3 77 47 FF 24 85 ?? ?? ?? ?? 8B 81 B0 00 00 00 EB 3A 8B 81 AC 00 00 00 EB 32 8B 81 A8 00 00 00 EB 2A 8B 81 A4 00 00 00 EB 22 8B 81 C4 00 00 00 EB 1A 8B 81 B4 00 00 00 EB 12 8B 81 A0 00 00 00 EB 0A 8B 81 9C 00 00 00 EB 02 33 C0 23 D3 83 FA 05 75 0F 8B 4D 08 0F AF C6 03 47 01 52 89 01 58 EB 75 83 FA 04 75 10 0F AF C6 03 81 C4 00 00 00 8B 4D 08 89 01 EB 5D 23 D3 3B D3 77 4C FF 24 95 ?? ?? ?? ?? 8B 91 B0 00 00 00 EB 36 8B 91 AC 00 00 00 EB 2E 8B 91 A8 00 00 00 EB 26 8B 91 A4 00 00 00 EB 1E 8B 91 C4 00 00 00 EB 16 8B 91 B4 00 00 00 EB 0E 8B 91 A0 00 00 00 EB 06 8B 91 9C 00 00 00 8B 4D 08 89 11 EB 06 8B 4D 08 83 21 00 0F AF C6 01 01 33 C0 40 5F 5E 5B 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_437_18_0 {
	meta:
		name = "_sib8"
		size = 319
		refs = "0031 $L20815 009d $L20816 00ff $L20540 0103 $L20541 0107 $L20542 010b $L20543 010f $L20544 0113 $L20545 0117 $L20546 011b $L20547 011f $L20556 0123 $L20557 0127 $L20558 012b $L20559 012f $L20560 0133 $L20561 0137 $L20562 013b $L20563"
	strings:
		$1 = { 55 8B EC 53 8B 5D 10 0F B6 13 56 57 33 F6 8B C2 6A 07 8B CA C1 E9 06 C1 E8 03 46 5F D3 E6 8B 4D 0C 23 C7 83 F8 04 74 4D 23 C7 3B C7 77 47 FF 24 85 ?? ?? ?? ?? 8B 81 B0 00 00 00 EB 3A 8B 81 AC 00 00 00 EB 32 8B 81 A8 00 00 00 EB 2A 8B 81 A4 00 00 00 EB 22 8B 81 C4 00 00 00 EB 1A 8B 81 B4 00 00 00 EB 12 8B 81 A0 00 00 00 EB 0A 8B 81 9C 00 00 00 EB 02 33 C0 23 D7 83 FA 04 75 16 0F B6 53 01 0F AF C6 03 C2 03 81 C4 00 00 00 8B 4D 08 89 01 EB 63 23 D7 3B D7 77 4C FF 24 95 ?? ?? ?? ?? 8B 91 B0 00 00 00 EB 36 8B 91 AC 00 00 00 EB 2E 8B 91 A8 00 00 00 EB 26 8B 91 A4 00 00 00 EB 1E 8B 91 C4 00 00 00 EB 16 8B 91 B4 00 00 00 EB 0E 8B 91 A0 00 00 00 EB 06 8B 91 9C 00 00 00 8B 4D 08 89 11 EB 06 8B 4D 08 83 21 00 0F B6 53 01 0F AF C6 03 C2 01 01 6A 02 58 5F 5E 5B 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_437_19_0 {
	meta:
		name = "_sib32"
		size = 313
		refs = "0031 $L20820 009a $L20821 00f9 $L20583 00fd $L20584 0101 $L20585 0105 $L20586 0109 $L20587 010d $L20588 0111 $L20589 0115 $L20590 0119 $L20599 011d $L20600 0121 $L20601 0125 $L20602 0129 $L20603 012d $L20604 0131 $L20605 0135 $L20606"
	strings:
		$1 = { 55 8B EC 53 8B 5D 10 0F B6 13 56 57 33 F6 8B C2 6A 07 8B CA C1 E9 06 C1 E8 03 46 5F D3 E6 8B 4D 0C 23 C7 83 F8 04 74 4D 23 C7 3B C7 77 47 FF 24 85 ?? ?? ?? ?? 8B 81 B0 00 00 00 EB 3A 8B 81 AC 00 00 00 EB 32 8B 81 A8 00 00 00 EB 2A 8B 81 A4 00 00 00 EB 22 8B 81 C4 00 00 00 EB 1A 8B 81 B4 00 00 00 EB 12 8B 81 A0 00 00 00 EB 0A 8B 81 9C 00 00 00 EB 02 33 C0 23 D7 83 FA 04 75 13 0F AF C6 03 81 C4 00 00 00 8B 4D 08 03 43 01 89 01 EB 60 23 D7 3B D7 77 4C FF 24 95 ?? ?? ?? ?? 8B 91 B0 00 00 00 EB 36 8B 91 AC 00 00 00 EB 2E 8B 91 A8 00 00 00 EB 26 8B 91 A4 00 00 00 EB 1E 8B 91 C4 00 00 00 EB 16 8B 91 B4 00 00 00 EB 0E 8B 91 A0 00 00 00 EB 06 8B 91 9C 00 00 00 8B 4D 08 89 11 EB 06 8B 4D 08 83 21 00 0F AF C6 03 43 01 01 01 6A 05 58 5F 5E 5B 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_437_20_0 {
	meta:
		name = "_d32"
		size = 16
	strings:
		$1 = { 8B 44 24 0C 8B 00 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_437_21_0 {
	meta:
		name = "_bp8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 B4 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_437_22_0 {
	meta:
		name = "_bp32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 B4 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_437_23_0 {
	meta:
		name = "_si0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 A0 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_437_24_0 {
	meta:
		name = "_si8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 A0 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_437_25_0 {
	meta:
		name = "_si32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 A0 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_437_26_0 {
	meta:
		name = "_di0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 9C 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_437_27_0 {
	meta:
		name = "_di8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 9C 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_437_28_0 {
	meta:
		name = "_di32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 9C 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_437_30_0 {
	meta:
		name = "_fpieee_flt_simd"
		size = 2159
		refs = "0018 $T20869 001d __except_handler3 0023 __except_list 0039 ___security_cookie 0184 _InstInfoTable5X 0195 _InstInfoTableCX 01a6 _InstInfoTable2X 01bb _InstInfoTableEX 023f _InstInfoTableX 02c5 _modrm32 02fe _LoadOperand 06bf _XMMI_FP_Emulation 06d4 _XMMI2_FP_Emulation 0757 _AdjustExceptionResult 080d _UpdateResult 0861 @__security_check_cookie@4"
	strings:
		$1 = { 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 51 51 53 81 EC B8 01 00 00 A1 ?? ?? ?? ?? 89 45 DC 53 56 57 89 65 E8 83 8D 60 FE FF FF FF 33 D2 89 95 88 FE FF FF 89 95 58 FE FF FF 8B 4B 0C 8B 01 8B 40 14 3B C2 74 0A 50 FF 53 10 59 E9 E2 07 00 00 8B 41 04 89 85 70 FE FF FF 8B 30 B9 20 00 01 00 23 F1 3B F1 0F 85 C6 07 00 00 8B 88 DC 00 00 00 89 8D 30 FE FF FF 89 95 78 FE FF FF C6 85 8F FE FF FF 00 89 55 FC 33 F6 46 C6 85 82 FE FF FF 01 C6 85 7E FE FF FF 00 8B 80 B8 00 00 00 89 85 84 FE FF FF 80 BD 82 FE FF FF 00 74 7B 8A 08 88 8D 83 FE FF FF 40 89 85 84 FE FF FF 0F B6 C9 83 F9 66 7F 29 74 5A 83 F9 26 74 19 83 F9 2E 74 14 83 F9 36 74 0F 83 F9 3E 74 0A 83 F9 63 7E 22 83 F9 65 7F 1D C6 85 8F FE FF FF 01 EB B7 83 E9 67 74 F2 81 E9 89 00 00 00 74 EA 49 49 74 1B 49 74 09 C6 85 82 FE FF FF 00 EB 9A C6 85 7E FE FF FF 01 FF 85 88 FE FF FF EB 8B C6 85 7E FE FF FF 01 89 B5 78 FE FF FF EB E9 83 4D FC FF 80 BD 8F FE FF FF 00 0F 85 F8 06 00 00 89 75 FC 89 85 64 FE FF FF 80 BD 83 FE FF FF 0F 0F 85 6B 02 00 00 8B 08 8B C1 C1 E8 04 83 E0 0F 83 F8 05 75 0C C7 85 68 FE FF FF ?? ?? ?? ?? EB 35 83 F8 0C 75 0C C7 85 68 FE FF FF ?? ?? ?? ?? EB 24 83 F8 02 75 0C C7 85 68 FE FF FF ?? ?? ?? ?? EB 13 83 F8 0E 0F 85 25 02 00 00 C7 85 68 FE FF FF ?? ?? ?? ?? 8B D1 BE 00 C0 00 00 23 D6 33 C0 3B D6 0F 95 C0 88 85 77 FE FF FF 0F B6 C0 C1 E0 04 83 E1 0F 0B C1 89 85 2C FE FF FF 83 F8 20 0F 87 EB 01 00 00 8B 8D 78 FE FF FF 8D 04 41 8B 8D 68 FE FF FF 8D 34 81 89 B5 6C FE FF FF 8B 06 B9 FF 0F 00 00 85 C1 75 0C C6 85 8F FE FF FF 01 E9 C9 01 00 00 8B D0 BF 00 F0 01 00 23 D7 81 FA 00 E0 01 00 75 34 C1 E8 11 83 E0 1F 80 BD 7E FE FF FF 00 8D 34 85 ?? ?? ?? ?? 75 07 8D 34 85 ?? ?? ?? ?? 89 B5 6C FE FF FF C6 85 7E FE FF FF 00 C7 85 78 FE FF FF 02 00 00 00 8B 06 23 C1 0F B6 8D 7E FE FF FF 03 C1 89 85 B8 FE FF FF 83 85 88 FE FF FF 03 80 BD 77 FE FF FF 00 74 4C 8B 85 84 FE FF FF 89 85 84 FE FF FF FF 85 84 FE FF FF 8B 85 84 FE FF FF 8A 00 88 85 83 FE FF FF FF 85 84 FE FF FF 0F B6 C8 FF B5 84 FE FF FF 8B 85 70 FE FF FF 50 05 DC 00 00 00 50 FF 14 8D ?? ?? ?? ?? 83 C4 0C 89 85 58 FE FF FF FF B5 70 FE FF FF 8D 85 D0 FE FF FF 50 8B 85 64 FE FF FF 8B 00 C1 E8 0B 83 E0 07 50 8B 06 C1 E8 0C 83 E0 1F 50 FF B5 7E FE FF FF E8 ?? ?? ?? ?? 83 C4 14 8B 06 8B C8 23 CF C1 E8 11 FF B5 70 FE FF FF 83 E0 1F 3B CF 75 2E 8D 8D D0 FE FF FF 51 8B 8D 64 FE FF FF 8B 09 C1 E9 08 83 E1 07 51 50 FF B5 7E FE FF FF E8 ?? ?? ?? ?? 83 C4 14 83 A5 20 FF FF FF FE EB 25 8D 8D 00 FF FF FF 51 8B 8D 64 FE FF FF 8B 09 C1 E9 08 83 E1 07 51 50 FF B5 7E FE FF FF E8 ?? ?? ?? ?? 83 C4 14 FF B5 70 FE FF FF 8D 85 30 FF FF FF 50 8B 85 64 FE FF FF 8B 00 C1 E8 0B 83 E0 07 50 8B 06 C1 E8 19 83 E0 1F 50 FF B5 7E FE FF FF E8 ?? ?? ?? ?? 83 C4 14 8B 85 58 FE FF FF 01 85 88 FE FF FF 8B 0E 81 E1 00 00 C0 01 81 F9 00 00 40 00 75 2A 01 85 84 FE FF FF 8B 85 84 FE FF FF 0F B6 00 89 85 BC FE FF FF FF 85 88 FE FF FF EB 0D C6 85 8F FE FF FF 01 8B B5 6C FE FF FF 83 4D FC FF 33 C0 38 85 8F FE FF FF 0F 85 5A 04 00 00 8B 95 70 FE FF FF 66 8B 82 CC 00 00 00 B9 00 03 00 00 23 C1 74 20 3D 00 02 00 00 74 0D 3B C1 75 1F 83 A5 48 FE FF FF 00 EB 16 C7 85 48 FE FF FF 01 00 00 00 EB 0A C7 85 48 FE FF FF 02 00 00 00 8B 82 E4 00 00 00 8B C8 C1 E9 0D 6A 03 5F 23 CF 83 E9 00 74 29 49 74 1A 49 74 0B 49 75 27 89 BD 44 FE FF FF EB 1F C7 85 44 FE FF FF 02 00 00 00 EB 13 C7 85 44 FE FF FF 01 00 00 00 EB 07 83 A5 44 FE FF FF 00 8B C8 C1 E9 07 83 E1 3F 89 8D 34 FE FF FF 8B C8 C1 E9 0F 83 E1 01 89 8D 3C FE FF FF 8B C8 C1 E9 06 83 E1 01 89 8D 40 FE FF FF 8B 8A C0 00 00 00 89 8D 50 FE FF FF 8B 8D BC FE FF FF 89 8D 4C FE FF FF 83 E0 3F 89 85 90 FE FF FF 33 FF 89 BD 94 FE FF FF 8B 36 C1 EE 1E 46 89 B5 5C FE FF FF 80 BD 7E FE FF FF 00 74 09 33 F6 46 89 B5 5C FE FF FF 3B F7 0F 86 01 03 00 00 8B 85 48 FE FF FF 83 A5 38 FE FF FF 00 83 A5 64 FF FF FF E0 83 A5 68 FF FF FF E0 83 A5 6C FF FF FF E0 8B 95 B8 FE FF FF 8B CA 81 E1 FF 0F 00 00 C1 E1 03 83 E0 07 0B C8 C1 E1 02 8B 85 60 FF FF FF 25 00 00 FE FF 0B C8 8B 85 44 FE FF FF 83 E0 03 0B C8 89 8D 60 FF FF FF 8B 45 80 33 85 F0 FE FF FF 83 E0 01 31 45 80 8B B5 78 FE FF FF 83 FE 01 75 1C 8B 84 FD E0 FE FF FF 89 85 70 FF FF FF 8B 84 FD E4 FE FF FF 89 85 74 FF FF FF EB 33 85 F6 74 22 83 FA 59 72 2A 83 FA 5A 76 11 83 FA 5C 76 20 83 FA 5F 76 0E 83 FA 61 77 16 EB C5 83 A5 74 FF FF FF 00 8B 84 BD E0 FE FF FF 89 85 70 FF FF FF 8B 45 80 33 85 F0 FE FF FF 83 E0 1E 31 45 80 8B 8D 20 FF FF FF 83 E1 01 74 68 8B 45 A0 83 E0 FE 0B C1 83 FE 01 75 16 8B 8C FD 10 FF FF FF 89 4D 90 8B 8C FD 14 FF FF FF 89 4D 94 EB 2D 85 F6 74 1F 83 FA 59 72 24 83 FA 5A 76 11 83 FA 5C 76 1A 83 FA 5F 76 0B 83 FA 61 77 10 EB CB 83 65 94 00 8B 8C BD 10 FF FF FF 89 4D 90 8B C8 33 8D 20 FF FF FF 83 E1 1E 33 C1 89 45 A0 8B 95 B8 FE FF FF EB 04 83 65 A0 FE 8B 85 50 FF FF FF 83 65 C0 FE 83 FE 01 75 16 8B 8C FD 40 FF FF FF 89 4D B0 8B 8C FD 44 FF FF FF 89 4D B4 EB 2D 85 F6 74 1F 83 FA 59 72 24 83 FA 5A 76 11 83 FA 5C 76 1A 83 FA 5F 76 0B 83 FA 61 77 10 EB CB 83 65 B4 00 8B 8C BD 40 FF FF FF 89 4D B0 33 45 C0 83 E0 1E 31 45 C0 8D 85 60 FF FF FF 89 85 54 FE FF FF 83 FE 01 74 1A 83 FE 02 74 15 8D B4 BD 98 FE FF FF 8D 85 34 FE FF FF 50 E8 ?? ?? ?? ?? EB 13 8D B4 BD 98 FE FF FF 8D 85 34 FE FF FF 50 E8 ?? ?? ?? ?? 59 89 06 8B 85 38 FE FF FF 89 84 BD A8 FE FF FF 83 3E 01 75 70 A8 20 74 07 83 8D 94 FE FF FF 20 A8 10 74 07 83 8D 94 FE FF FF 10 A8 08 74 07 83 8D 94 FE FF FF 08 A8 04 74 07 83 8D 94 FE FF FF 04 A8 02 74 07 83 8D 94 FE FF FF 02 A8 01 74 07 83 8D 94 FE FF FF 01 8D 85 60 FF FF FF 50 FF 53 10 59 89 85 60 FE FF FF 83 F8 FF 0F 85 0A 01 00 00 8D 85 34 FE FF FF 50 FF B5 B8 FE FF FF E8 ?? ?? ?? ?? 59 59 8B 85 50 FF FF FF 33 45 C0 83 E0 01 31 85 50 FF FF FF 8B 85 50 FE FF FF 89 85 C0 FE FF FF F6 85 50 FF FF FF 01 74 67 83 BD 78 FE FF FF 01 75 16 8B 45 B0 89 84 FD 40 FF FF FF 8B 45 B4 89 84 FD 44 FF FF FF EB 48 83 BD 78 FE FF FF 00 75 0C 8B 45 B0 89 84 BD 40 FF FF FF EB 33 8B 85 B8 FE FF FF 83 F8 59 72 28 83 F8 5A 76 11 83 F8 5C 76 1E 83 F8 5F 76 DA 83 F8 61 77 14 EB B4 8B 45 B0 89 84 FD 40 FF FF FF 83 A4 FD 44 FF FF FF 00 47 3B BD 5C FE FF FF 0F 82 FF FC FF FF FF B5 C0 FE FF FF 8B B5 70 FE FF FF 56 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 88 FE FF FF 01 86 B8 00 00 00 8B 85 30 FE FF FF 89 86 DC 00 00 00 8B 85 60 FE FF FF EB 1F 8B 5D E4 33 C0 40 C3 8B 5D E4 EB 0A 8B 5D E4 33 C0 40 C3 8B 5D E4 8B 65 E8 83 4D FC FF 33 C0 8B 4D F0 64 89 0D ?? ?? ?? ?? 8B 4D DC E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_438_0_0 {
	meta:
		name = "__pipe"
		size = 337
		refs = "0042 __imp__CreatePipe@16 004c __imp__GetLastError@0 0052 __dosmaperr 0061 __alloc_osfhnd 007a ___pioinfo 00c6 __fmode 00fe __set_osfhnd 0110 _errno 0130 __imp__CloseHandle@4 0147 __doserrno"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8B 45 08 83 65 E8 00 56 83 CE FF 89 70 04 89 30 8B 45 10 25 80 00 00 00 6A 00 89 45 F4 58 FF 75 0C 0F 94 C0 C7 45 E4 0C 00 00 00 89 45 EC 8D 45 E4 50 8D 45 F8 50 8D 45 FC 50 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 8B C6 E9 C3 00 00 00 53 57 E8 ?? ?? ?? ?? 3B C6 89 45 F0 0F 84 BB 00 00 00 8B C8 8B F0 C1 F9 05 8D 3C 8D ?? ?? ?? ?? 8B 07 83 E6 1F C1 E6 03 C6 44 06 04 89 E8 ?? ?? ?? ?? 8B D8 83 FB FF 0F 84 89 00 00 00 C1 F8 05 8D 0C 85 ?? ?? ?? ?? 8B 11 8B C3 83 E0 1F C1 E0 03 C6 44 10 04 89 BA 00 80 00 00 85 55 10 75 0E F6 45 11 40 75 1A 39 15 ?? ?? ?? ?? 75 12 8B 17 8D 54 16 04 80 22 7F 8B 11 8D 54 10 04 80 22 7F 83 7D F4 00 74 12 8B 17 8D 54 16 04 80 0A 10 8B 09 8D 44 08 04 80 08 10 FF 75 FC 8B 75 F0 56 E8 ?? ?? ?? ?? FF 75 F8 53 E8 ?? ?? ?? ?? 8B 45 08 83 25 ?? ?? ?? ?? 00 83 C4 10 89 30 89 58 04 33 C0 5F 5B 5E C9 C3 8B 07 C6 44 06 04 00 FF 75 FC 8B 35 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 18 00 00 00 FF D6 FF 75 F8 FF D6 83 25 ?? ?? ?? ?? 00 83 C8 FF EB CE }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "_wcschr"
		size = 34
	strings:
		$1 = { 8B 44 24 04 66 8B 54 24 08 EB 07 66 3B CA 74 11 40 40 66 8B 08 66 85 C9 75 F1 66 3B CA 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "__setmaxstdio"
		size = 195
		refs = "001b __nstream 002d ___piob 0032 _realloc 007d _free"
	strings:
		$1 = { 56 8B 74 24 08 83 FE 14 0F 8C B0 00 00 00 81 FE 00 08 00 00 0F 8F A4 00 00 00 A1 ?? ?? ?? ?? 3B F0 53 57 7E 37 8B C6 C1 E0 02 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 59 59 74 77 A1 ?? ?? ?? ?? 3B C6 7D 0B 8B CE 8D 3C 82 2B C8 33 C0 F3 AB 8B DE 89 15 ?? ?? ?? ?? EB 51 75 04 8B D8 EB 56 8B DE 8D 78 FF EB 1A A1 ?? ?? ?? ?? 8B 04 B8 85 C0 74 0D F6 40 0C 83 75 0E 50 E8 ?? ?? ?? ?? 59 4F 3B FE 7D E2 EB 03 83 CB FF 83 FB FF 74 27 8B C6 C1 E0 02 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 74 0D A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? EB 03 83 CB FF 5F 8B C3 5B 5E C3 83 C8 FF 5E C3 }
	condition:
		$1
}

rule file_441_0_0 {
	meta:
		name = "_bsearch"
		size = 140
	strings:
		$1 = { 55 8B EC 8B 45 10 8B 4D 0C 53 56 57 8D 78 FF 0F AF 7D 14 03 F9 3B CF 89 4D 0C 77 4B 8B D8 D1 EB 74 50 89 45 10 83 65 10 01 8B C3 75 03 8D 43 FF 0F AF 45 14 03 45 0C 8B F0 56 FF 75 08 FF 55 18 85 C0 59 59 74 28 7D 10 2B 75 14 83 7D 10 00 8B FE 75 0D 8D 43 FF EB 0A 8B 45 14 03 F0 89 75 0C 8B C3 39 7D 0C 76 B5 33 C0 5F 5E 5B 5D C3 8B C6 EB F7 85 C0 74 F1 FF 75 0C FF 75 08 FF 55 18 F7 D8 1B C0 59 F7 D0 23 45 0C 59 EB DD }
	condition:
		$1
}

rule file_442_1_0 {
	meta:
		name = "___crtCompareStringW"
		size = 594
		refs = "0003 $T20159 0008 __SEH_prolog 0013 ?f_use@?1??__crtCompareStringW@@9@9 001b ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0026 __imp__CompareStringW@24 0038 __imp__GetLastError@0 0057 _wcsncnt 00c2 ___lc_handle 00cf ___lc_codepage 00da ___ansicp 00fa __imp__WideCharToMultiByte@32 0116 __alloca_probe 0130 __resetstkoflw 0149 _malloc 020a __imp__CompareStringA@24 0218 _free 024d __SEH_epilog"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 33 DB 43 39 35 ?? ?? ?? ?? 75 32 53 B8 ?? ?? ?? ?? 50 53 50 56 56 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 1D ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 8B 7D 14 3B FE 7E 0F 57 8B 45 10 E8 ?? ?? ?? ?? 59 8B F8 89 7D 14 39 75 1C 7E 0F FF 75 1C 8B 45 18 E8 ?? ?? ?? ?? 59 89 45 1C 3B FE 0F 84 B3 01 00 00 39 75 1C 0F 84 AA 01 00 00 A1 ?? ?? ?? ?? 3B C3 75 1B FF 75 1C FF 75 18 57 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? E9 9F 01 00 00 83 F8 02 74 04 3B C6 75 52 89 75 D0 89 75 D4 89 75 D8 39 75 08 75 08 A1 ?? ?? ?? ?? 89 45 08 39 75 20 75 08 A1 ?? ?? ?? ?? 89 45 20 FF 75 08 E8 ?? ?? ?? ?? 59 39 45 20 74 08 83 F8 FF 74 03 89 45 20 56 56 56 56 57 FF 75 10 56 FF 75 20 FF 15 ?? ?? ?? ?? 89 45 DC 3B C6 75 07 33 C0 E9 3D 01 00 00 89 75 FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 E4 83 4D FC FF EB 18 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 F6 89 75 E4 83 4D FC FF 33 DB 43 39 75 E4 75 13 FF 75 DC E8 ?? ?? ?? ?? 59 89 45 E4 3B C6 74 B0 89 5D D4 56 56 FF 75 DC FF 75 E4 FF 75 14 FF 75 10 56 FF 75 20 8B 3D ?? ?? ?? ?? FF D7 85 C0 0F 84 A3 00 00 00 56 56 56 56 FF 75 1C FF 75 18 56 FF 75 20 FF D7 89 45 E0 3B C6 0F 84 88 00 00 00 89 5D FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D CC 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 F6 33 FF 83 4D FC FF 33 DB 43 3B FE 75 12 FF 75 E0 E8 ?? ?? ?? ?? 59 8B F8 3B FE 74 42 89 5D D8 56 56 FF 75 E0 57 FF 75 1C FF 75 18 56 FF 75 20 FF 15 ?? ?? ?? ?? 85 C0 74 19 FF 75 E0 57 FF 75 DC FF 75 E4 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 89 45 D0 39 75 D8 74 07 57 E8 ?? ?? ?? ?? 59 39 75 D4 74 09 FF 75 E4 E8 ?? ?? ?? ?? 59 8B 45 D0 EB 19 8B C7 2B 45 1C 75 05 6A 02 58 EB 0D 33 C9 3B C6 0F 9D C1 8D 4C 09 01 8B C1 8D 65 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "_strerror"
		size = 44
		refs = "0007 __sys_nerr 0017 __sys_errlist 001c ?errmsg@?1??strerror@@9@9 0022 _strcpy"
	strings:
		$1 = { 8B 4C 24 04 85 C9 A1 ?? ?? ?? ?? 7C 06 3B C8 7D 02 8B C1 56 FF 34 85 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E C3 }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "__wcsicoll"
		size = 140
		refs = "0001 ___lc_handle 0056 ___lc_codepage 006d ___crtCompareStringW 007a _errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 75 4B 8B 54 24 04 56 8B 74 24 0C 33 C0 66 8B 02 66 3D 41 00 72 09 66 3D 5A 00 8D 48 20 76 02 8B C8 33 C0 66 8B 06 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 42 42 46 46 66 85 C9 74 05 66 3B C8 74 C8 0F B7 D0 0F B7 C1 2B C2 5E C3 FF 35 ?? ?? ?? ?? 6A FF FF 74 24 10 6A FF FF 74 24 14 68 01 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 10 C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F C3 83 C0 FE C3 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "__fltin"
		size = 151
		refs = "0007 ___security_cookie 0025 ___strgtold12 0049 __ld12tod 006f _flt 0091 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 53 56 57 33 F6 56 56 56 56 FF 75 08 89 45 FC 8D 45 E4 50 8D 45 F0 50 33 FF E8 ?? ?? ?? ?? 8B D8 83 C4 1C F6 C3 04 74 0D BF 00 02 00 00 89 75 E8 89 75 EC EB 2E 8D 45 E8 50 8D 45 F0 50 E8 ?? ?? ?? ?? F6 C3 02 59 59 75 05 83 F8 01 75 05 BF 80 00 00 00 F6 C3 01 75 05 83 F8 02 75 06 81 CF 00 01 00 00 A1 ?? ?? ?? ?? 89 38 8B 4D E4 2B 4D 08 5F 89 48 04 8B 4D E8 89 48 10 8B 4D EC 89 48 14 8B 4D FC 5E 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_446_0_0 {
	meta:
		name = "__frnd"
		size = 17
	strings:
		$1 = { 51 51 DD 44 24 0C D9 FC DD 1C 24 DD 04 24 59 59 C3 }
	condition:
		$1
}

rule file_447_0_0 {
	meta:
		name = "_fputc"
		size = 36
		refs = "001d __flsbuf"
		altNames = "_putc"
	strings:
		$1 = { 8B 4C 24 08 FF 49 04 78 0E 8B 11 8A 44 24 04 88 02 FF 01 0F B6 C0 C3 51 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "__resetstkoflw"
		size = 227
		refs = "000d __alloca_probe 001c __imp__VirtualQuery@12 002d __imp__GetSystemInfo@4 0035 __osplatform 00b1 __imp__VirtualAlloc@16 00d7 __imp__VirtualProtect@16"
	strings:
		$1 = { 55 8B EC 83 EC 4C 53 56 57 6A 04 58 E8 ?? ?? ?? ?? 8B F4 6A 1C 8D 45 D8 50 56 FF 15 ?? ?? ?? ?? 85 C0 74 77 8B 5D DC 8D 45 B4 50 FF 15 ?? ?? ?? ?? 8B 4D B8 A1 ?? ?? ?? ?? 8D 79 FF F7 D7 23 FE 2B F9 8B F0 4E F7 DE 1B F6 83 E6 F1 83 C6 11 0F AF F1 03 F3 3B FE 89 4D F8 72 40 83 F8 01 74 5C 89 5D FC BB 00 10 00 00 6A 1C 8D 45 D8 50 FF 75 FC FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 45 E4 01 45 FC 85 5D E8 74 E2 F6 45 ED 01 8B 45 D8 89 45 FC 74 05 33 C0 40 EB 44 3B F8 73 04 33 C0 EB 3C 3B C6 73 03 89 75 FC 6A 04 53 FF 75 F8 FF 75 FC FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 03 89 7D FC 48 F7 D8 1B C0 25 03 01 00 00 8D 4D F4 51 40 50 FF 75 F8 FF 75 FC FF 15 ?? ?? ?? ?? 8D 65 A8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "__stricoll"
		size = 70
		refs = "0001 ___lc_handle 000a __stricmp 0010 ___lc_collate_cp 0027 ___crtCompareStringA 0034 _errno"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 75 05 E9 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 6A FF FF 74 24 10 6A FF FF 74 24 14 68 01 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 10 C7 05 ?? ?? ?? ?? 16 00 00 00 B8 FF FF FF 7F C3 83 C0 FE C3 }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "___wcserror"
		size = 135
		refs = "0007 ?bldmsg@?1??__wcserror@@9@9 0025 _wcsncat 002a ??_C@_15ELOONFKJ@?$AA?3?$AA?5?$AA?$AA@ 0030 _wcscat 0038 _errno 0040 __sys_nerr 004e _wcslen 005e __sys_errlist 0072 _mbstowcs 0077 ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@"
	strings:
		$1 = { 8B 44 24 04 66 83 25 ?? ?? ?? ?? 00 85 C0 56 57 BE ?? ?? ?? ?? 74 20 66 83 38 00 74 1A 68 82 00 00 00 50 56 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 14 A1 ?? ?? ?? ?? 85 C0 8B 3D ?? ?? ?? ?? 7C 06 3B C7 7D 02 8B F8 56 E8 ?? ?? ?? ?? 59 B9 84 00 00 00 2B C8 51 FF 34 BD ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 8D 04 45 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 14 5F 5E C3 }
	condition:
		$1
}

rule file_451_0_0 {
	meta:
		name = "__ftime"
		size = 247
		refs = "000c ___security_cookie 0017 ___tzset 001c __timezone 0033 __imp__GetSystemTimeAsFileTime@4 0047 __aulldiv 004d _elapsed_minutes_cache 005c __imp__GetTimeZoneInformation@4 0079 _dstflag_cache 00c3 __aullrem 00ee @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC B8 00 00 00 A1 ?? ?? ?? ?? 53 56 57 89 45 70 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 6A 3C 99 59 F7 F9 8B 75 7C 66 89 46 06 8D 45 BC 50 FF 15 ?? ?? ?? ?? 8B 7D C0 8B 5D BC 6A 00 68 00 46 C3 23 57 53 E8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 89 45 7C 74 4B 8D 45 C4 50 FF 15 ?? ?? ?? ?? 83 F8 FF 74 27 83 F8 02 75 19 66 83 7D 5E 00 74 12 83 7D 6C 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 10 83 25 ?? ?? ?? ?? 00 EB 07 83 0D ?? ?? ?? ?? FF 8B 45 7C 8B 7D C0 8B 5D BC A3 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 6A 00 68 10 27 00 00 57 53 66 89 46 08 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 6A 00 81 C3 00 80 C1 2A 68 80 96 98 00 81 D7 21 4E 62 FE 57 53 66 89 46 04 E8 ?? ?? ?? ?? 8B 4D 70 5F 89 06 5E 5B E8 ?? ?? ?? ?? 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "__raise_exc"
		size = 677
		refs = "00df __statfp 01e7 __clrfp 01f7 __imp__RaiseException@16"
	strings:
		$1 = { 55 8B EC 8B 4D 08 33 C0 89 41 04 8B 4D 08 89 41 08 8B 4D 08 53 33 DB 89 41 0C 8A 4D 10 56 43 F6 C1 10 57 74 0D 8B 45 08 09 58 04 C7 45 10 8F 00 00 C0 F6 C1 02 74 0E 8B 45 08 83 48 04 02 C7 45 10 93 00 00 C0 84 CB 74 0E 8B 45 08 83 48 04 04 C7 45 10 91 00 00 C0 F6 C1 04 74 0E 8B 45 08 83 48 04 08 C7 45 10 8E 00 00 C0 F6 C1 08 74 0E 8B 45 08 83 48 04 10 C7 45 10 90 00 00 C0 8B 75 0C 8B 0E 8B 45 08 C1 E1 04 F7 D1 33 48 08 6A 02 83 E1 10 31 48 08 8B 0E 8B 45 08 D1 E1 F7 D1 33 48 08 5F 83 E1 08 31 48 08 8B 0E 8B 45 08 D1 E9 F7 D1 33 48 08 83 E1 04 31 48 08 8B 0E 8B 45 08 C1 E9 03 F7 D1 33 48 08 23 CF 31 48 08 8B 0E 8B 45 08 C1 E9 05 F7 D1 33 48 08 23 CB 31 48 08 E8 ?? ?? ?? ?? 84 C3 74 07 8B 4D 08 83 49 0C 10 A8 04 74 07 8B 4D 08 83 49 0C 08 A8 08 74 07 8B 4D 08 83 49 0C 04 A8 10 74 06 8B 4D 08 09 79 0C A8 20 74 06 8B 45 08 09 58 0C 8B 06 B9 00 0C 00 00 23 C1 74 34 3D 00 04 00 00 74 1F 3D 00 08 00 00 74 0C 3B C1 75 28 8B 45 08 83 08 03 EB 20 8B 45 08 8B 08 83 E1 FE 0B CF EB 0A 8B 45 08 8B 08 83 E1 FD 0B CB 89 08 EB 06 8B 45 08 83 20 FC 8B 06 B9 00 03 00 00 23 C1 74 20 3D 00 02 00 00 74 0C 3B C1 75 22 8B 45 08 83 20 E3 EB 1A 8B 45 08 8B 08 83 E1 E7 83 C9 04 EB 0B 8B 45 08 8B 08 83 E1 EB 83 C9 08 89 08 8B 45 08 8B 4D 14 C1 E1 05 33 08 81 E1 E0 FF 01 00 31 08 8B 45 08 09 58 20 8B 45 08 8B 48 20 83 E1 E3 0B CF 89 48 20 8B 45 18 DD 00 8B 45 08 DD 58 10 8B 45 08 09 58 60 8B 45 08 8B 48 60 83 E1 E3 0B CF 8B 7D 1C 89 48 60 DD 07 8B 45 08 DD 58 50 E8 ?? ?? ?? ?? 8D 45 08 50 53 6A 00 FF 75 10 FF 15 ?? ?? ?? ?? 8B 45 08 F6 40 08 10 74 03 83 26 FE F6 40 08 08 74 03 83 26 FB F6 40 08 04 74 03 83 26 F7 F6 40 08 02 74 03 83 26 EF 84 58 08 74 03 83 26 DF 8B 08 83 E1 03 83 E9 00 BA FF F3 FF FF 74 31 49 74 1C 49 74 09 49 75 2A 80 4E 01 0C EB 24 8B 0E 81 E1 FF FB FF FF 81 C9 00 08 00 00 EB 0E 8B 0E 81 E1 FF F7 FF FF 81 C9 00 04 00 00 89 0E EB 02 21 16 8B 08 C1 E9 02 83 E1 07 83 E9 00 74 16 49 74 07 49 75 1C 21 16 EB 18 8B 0E 23 CA 81 C9 00 02 00 00 EB 0A 8B 0E 23 CA 81 C9 00 03 00 00 89 0E DD 40 50 DD 1F 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_452_1_0 {
	meta:
		name = "__handle_exc"
		size = 548
		refs = "0021 __set_statfp 008f __real@0000000000000000 0095 __d_max 00be __d_inf 0167 __decomp"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 08 53 56 33 DB 8B F0 83 E6 1F 43 A8 08 89 75 FC 74 14 84 5D 10 74 0F 53 E8 ?? ?? ?? ?? 59 83 E6 F7 E9 D4 01 00 00 A8 04 74 16 F6 45 10 04 74 10 6A 04 E8 ?? ?? ?? ?? 59 83 E6 FB E9 BA 01 00 00 84 C3 0F 84 D8 00 00 00 F6 45 10 08 0F 84 CE 00 00 00 6A 08 E8 ?? ?? ?? ?? 8B 45 10 59 B9 00 0C 00 00 23 C1 0F 84 8C 00 00 00 3D 00 04 00 00 74 5B 3D 00 08 00 00 74 2A 3B C1 0F 85 98 00 00 00 8B 4D 0C DD 01 DC 1D ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DF E0 F6 C4 41 74 02 D9 E0 DD 5D F0 DD 45 F0 EB 74 8B 4D 0C DD 01 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 08 DD 05 ?? ?? ?? ?? D9 E0 DD 5D F0 DD 45 F0 EB 4A 8B 4D 0C DD 01 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 08 DD 05 ?? ?? ?? ?? EB 08 DD 05 ?? ?? ?? ?? D9 E0 DD 5D F0 DD 45 F0 EB 20 8B 4D 0C DD 01 DC 1D ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DF E0 F6 C4 41 74 02 D9 E0 DD 5D F0 DD 45 F0 DD 19 83 E6 FE E9 DA 00 00 00 A8 02 0F 84 D2 00 00 00 F6 45 10 10 0F 84 C8 00 00 00 33 F6 A8 10 74 02 8B F3 DD 05 ?? ?? ?? ?? 57 8B 7D 0C DD 07 DA E9 DF E0 F6 C4 44 0F 8B 91 00 00 00 DD 07 8D 45 F8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 4D F8 DD 5D F0 DD 45 F0 81 C1 00 FA FF FF 83 C4 0C 81 F9 CE FB FF FF 7D 0A DC 0D ?? ?? ?? ?? 8B F3 EB 53 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 04 8B D3 EB 02 33 D2 33 C0 8A 45 F6 83 E0 0F 83 C8 10 66 89 45 F6 B8 03 FC FF FF 3B C8 7D 1F 2B C1 84 5D F0 74 06 85 F6 75 02 8B F3 D1 6D F0 84 5D F4 74 04 80 4D F3 80 D1 6D F4 48 75 E3 85 D2 74 08 DD 45 F0 D9 E0 DD 5D F0 DD 45 F0 DD 1F EB 02 8B F3 85 F6 5F 74 08 6A 10 E8 ?? ?? ?? ?? 59 83 65 FC FD 8B 75 FC F6 45 08 10 74 11 F6 45 10 20 74 0B 6A 20 E8 ?? ?? ?? ?? 59 83 E6 EF 33 C0 85 F6 5E 0F 94 C0 5B C9 C3 }
	condition:
		$1
}

rule file_452_2_0 {
	meta:
		name = "__set_errno"
		size = 38
		refs = "0012 _errno"
	strings:
		$1 = { 8B 44 24 04 83 F8 01 74 12 7E 1A 83 F8 03 7F 15 C7 05 ?? ?? ?? ?? 22 00 00 00 C3 C7 05 ?? ?? ?? ?? 21 00 00 00 C3 }
	condition:
		$1
}

rule file_452_3_0 {
	meta:
		name = "__get_fname"
		size = 32
		refs = "0005 ?_names@?1??_get_fname@@9@9"
	strings:
		$1 = { 33 C0 8B 0C C5 ?? ?? ?? ?? 3B 4C 24 04 74 09 40 83 F8 1D 7C ED 33 C0 C3 8B 04 C5 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_452_4_0 {
	meta:
		name = "__errcode"
		size = 45
	strings:
		$1 = { 8A 44 24 04 A8 20 74 04 6A 05 EB 16 A8 08 74 04 33 C0 40 C3 A8 04 74 04 6A 02 EB 06 A8 01 74 04 6A 03 58 C3 0F B6 C0 83 E0 02 D1 E0 C3 }
	condition:
		$1
}

rule file_452_5_0 {
	meta:
		name = "__umatherr"
		size = 160
		refs = "000b ?_names@?1??_get_fname@@9@9 0057 __ctrlfp 0060 __matherr 006d __set_errno"
	strings:
		$1 = { 55 8B EC 83 EC 20 33 C0 8B 0C C5 ?? ?? ?? ?? 3B 4D 0C 74 66 40 83 F8 1D 7C EE 33 C0 85 C0 89 45 E4 74 60 8B 45 10 89 45 E8 8B 45 14 89 45 EC 8B 45 18 89 45 F0 8B 45 1C 56 8B 75 08 89 45 F4 8B 45 20 89 45 F8 8B 45 24 68 FF FF 00 00 FF 75 28 89 75 E0 89 45 FC E8 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 09 56 E8 ?? ?? ?? ?? 83 C4 04 DD 45 F8 5E C9 C3 8B 04 C5 ?? ?? ?? ?? EB 99 68 FF FF 00 00 FF 75 28 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? DD 45 20 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_452_6_0 {
	meta:
		name = "__handle_qnan1"
		size = 82
		refs = "0005 __matherr_flag 002b __umatherr 003e _errno 0047 __ctrlfp"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 28 FF 75 14 DD 45 0C 83 EC 18 DD 5C 24 10 D9 EE DD 5C 24 08 DD 45 0C DD 1C 24 FF 75 08 6A 01 E8 ?? ?? ?? ?? 83 C4 24 5D C3 68 FF FF 00 00 FF 75 14 C7 05 ?? ?? ?? ?? 21 00 00 00 E8 ?? ?? ?? ?? DD 45 0C 59 59 5D C3 }
	condition:
		$1
}

rule file_452_7_0 {
	meta:
		name = "__handle_qnan2"
		size = 94
		refs = "0007 __matherr_flag 0037 __umatherr 004a _errno 0053 __ctrlfp"
	strings:
		$1 = { 55 8B EC 51 51 83 3D ?? ?? ?? ?? 00 DD 45 0C DC 45 14 DD 5D F8 75 29 FF 75 1C DD 45 F8 83 EC 18 DD 5C 24 10 DD 45 14 DD 5C 24 08 DD 45 0C DD 1C 24 FF 75 08 6A 01 E8 ?? ?? ?? ?? 83 C4 24 C9 C3 68 FF FF 00 00 FF 75 1C C7 05 ?? ?? ?? ?? 21 00 00 00 E8 ?? ?? ?? ?? DD 45 F8 59 59 C9 C3 }
	condition:
		$1
}

rule file_452_8_0 {
	meta:
		name = "__except1"
		size = 184
		refs = "000d ___security_cookie 0023 __handle_exc 004b __raise_exc 0056 __errcode 005f __matherr_flag 0088 __umatherr 0093 __set_errno 00a2 __ctrlfp 00b0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 E4 F0 81 EC 80 00 00 00 A1 ?? ?? ?? ?? FF 75 20 89 84 24 80 00 00 00 8D 45 18 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 24 83 64 24 40 FE 8D 45 18 50 8D 45 10 50 FF 75 0C 8D 45 20 FF 75 08 50 8D 44 24 14 50 E8 ?? ?? ?? ?? 83 C4 18 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 83 3D ?? ?? ?? ?? 00 75 2B 85 C0 74 27 FF 75 20 DD 45 18 83 EC 18 DD 5C 24 10 D9 EE DD 5C 24 08 DD 45 10 DD 1C 24 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 24 EB 1A 50 E8 ?? ?? ?? ?? C7 04 24 FF FF 00 00 FF 75 20 E8 ?? ?? ?? ?? DD 45 18 59 59 8B 4C 24 7C E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_452_9_0 {
	meta:
		name = "__except2"
		size = 201
		refs = "000d ___security_cookie 0023 __handle_exc 005b __raise_exc 0066 __errcode 006f __matherr_flag 0099 __umatherr 00a4 __set_errno 00b3 __ctrlfp 00c1 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 E4 F0 81 EC 80 00 00 00 A1 ?? ?? ?? ?? FF 75 28 89 84 24 80 00 00 00 8D 45 20 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 34 8B 44 24 40 DD 45 18 83 E0 E3 DD 5C 24 30 83 C8 03 89 44 24 40 8D 45 20 50 8D 45 10 50 FF 75 0C 8D 45 28 FF 75 08 50 8D 44 24 14 50 E8 ?? ?? ?? ?? 83 C4 18 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 83 3D ?? ?? ?? ?? 00 75 2C 85 C0 74 28 FF 75 28 DD 45 20 83 EC 18 DD 5C 24 10 DD 45 18 DD 5C 24 08 DD 45 10 DD 1C 24 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 24 EB 1A 50 E8 ?? ?? ?? ?? C7 04 24 FF FF 00 00 FF 75 28 E8 ?? ?? ?? ?? DD 45 20 59 59 8B 4C 24 7C E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_453_1_0 {
	meta:
		name = "?Constructor@HeapManager@@QAEXP6APAXI@ZP6AXPAX@Z@Z"
		size = 27
	strings:
		$1 = { 8B 44 24 04 89 01 8B 44 24 08 89 41 04 33 C0 89 41 10 89 41 08 89 41 0C C2 08 00 }
	condition:
		$1
}

rule file_453_2_0 {
	meta:
		name = "?Destructor@HeapManager@@QAEXXZ"
		size = 38
	strings:
		$1 = { 56 8B F1 83 7E 04 00 74 1B EB 0F 8B 46 0C 8B 00 FF 76 0C 89 46 08 FF 56 04 59 8B 46 08 85 C0 89 46 0C 75 E7 5E C3 }
	condition:
		$1
}

rule file_453_3_0 {
	meta:
		name = "?getNumberOfDimensions@UnDecorator@@CAHXZ"
		size = 99
		refs = "0002 ?gName@UnDecorator@@0PBDB"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 8A 11 84 D2 75 03 33 C0 C3 80 FA 30 7C 13 80 FA 39 7F 0E 0F BE C2 83 E8 2F 41 89 0D ?? ?? ?? ?? C3 33 C0 EB 21 84 D2 74 DD 80 FA 41 7C 2B 80 FA 50 7F 26 0F BE D2 C1 E0 04 41 8D 44 10 BF 89 0D ?? ?? ?? ?? 8A 11 80 FA 40 75 DA 8A 11 41 80 FA 40 89 0D ?? ?? ?? ?? 74 03 83 C8 FF C3 }
	condition:
		$1
}

rule file_453_4_0 {
	meta:
		name = "?getTypeEncoding@UnDecorator@@CAHXZ"
		size = 1074
		refs = "0002 ?gName@UnDecorator@@0PBDB 0085 $L22301 008c $L22303 02e8 $L22304 03fc $L20333 0400 $L20334 040e $L20369 0412 $L20372 0416 $L20375 041a $L20377 041e $L20381 0422 $L20379 0426 $L20383 042a $L20385 042e $L20387"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 53 55 56 57 BE 00 40 00 00 33 C0 80 39 5F 75 09 41 8B C6 89 0D ?? ?? ?? ?? 8A 11 80 FA 41 7C 09 80 FA 5A 0F 8E 8F 00 00 00 80 FA 24 0F 85 7E 02 00 00 41 89 0D ?? ?? ?? ?? 0F BE 11 83 FA 42 0F 8F 33 02 00 00 0F 84 26 02 00 00 85 D2 0F 84 17 02 00 00 83 FA 24 0F 85 4C 01 00 00 8D 51 01 80 3A 50 75 02 8B CA 41 89 0D ?? ?? ?? ?? 0F BE 11 83 C2 BA 83 FA 09 0F 87 28 02 00 00 0F B6 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 41 EB 20 41 89 0D ?? ?? ?? ?? 8A 01 3C 30 0F 8C C5 01 00 00 3C 39 0F 8F BD 01 00 00 0F BE C0 8D 4C 01 D1 89 0D ?? ?? ?? ?? E9 51 FF FF FF 0F BE 11 83 EA 41 BE 00 80 00 00 41 0B C6 F6 C2 01 89 0D ?? ?? ?? ?? 74 07 0D 00 20 00 00 EB 05 25 FF DF FF FF 83 FA 18 0F 8D 0B 03 00 00 85 C6 BD FF 9F FF FF BB FF EF FF FF BF 00 08 00 00 74 06 23 C3 0B C7 EB 02 23 C5 8B CA 83 E1 18 74 3A 83 F9 08 74 1B 83 F9 10 0F 85 B5 02 00 00 85 C6 74 07 25 3F FF FF FF EB 33 25 FF E7 FF FF EB 2C 85 C6 74 0A 83 E0 BF 0D 80 00 00 00 EB 1E 25 FF F7 FF FF 0D 00 10 00 00 EB 12 85 C6 74 0A 25 7F FF FF FF 83 C8 40 EB 04 23 C3 0B C7 83 E2 06 83 EA 00 0F 84 91 02 00 00 4A 4A 74 2A 4A 4A 74 17 4A 4A 0F 85 5B 02 00 00 25 FF FC FF FF 0D 00 04 00 00 E9 72 02 00 00 25 FF F9 FF FF 0D 00 01 00 00 E9 63 02 00 00 85 C6 74 0F 25 FF FA FF FF 0D 00 02 00 00 E9 50 02 00 00 23 C5 E9 49 02 00 00 83 FA 2F 0F 8E 1A 02 00 00 83 FA 35 7E 18 83 FA 41 0F 85 0C 02 00 00 25 FF F4 FF FF 0D 00 90 00 00 E9 D6 00 00 00 0F BE 11 BE 00 80 00 00 0B C6 83 EA 30 85 C6 BB FF EF FF FF BF 00 08 00 00 74 06 23 C3 0B C7 EB 05 25 FF 9F FF FF 25 FF FD FF FF 0D 00 05 00 00 F6 C2 01 74 07 0D 00 20 00 00 EB 05 25 FF DF FF FF 83 E2 06 83 EA 00 74 38 4A 4A 74 1A 4A 4A 0F 85 A8 01 00 00 85 C6 74 07 25 3F FF FF FF EB 76 25 FF E7 FF FF EB 6F 85 C6 74 0A 83 E0 BF 0D 80 00 00 00 EB 61 25 FF F7 FF FF 0D 00 10 00 00 EB 55 85 C6 74 0A 25 7F FF FF FF 83 C8 40 EB 47 23 C3 0B C7 EB 41 B8 FF FF 00 00 EB 3A B8 FE FF 00 00 EB 33 0D 00 98 00 00 EB 2C 83 EA 43 74 22 4A 74 13 4A 0F 85 44 01 00 00 25 FF F6 FF FF 0D 00 92 00 00 EB 11 25 FF F5 FF FF 0D 00 91 00 00 EB 05 0D 00 7C 00 00 41 89 0D ?? ?? ?? ?? E9 41 01 00 00 8A 11 80 FA 30 0F 8C 17 01 00 00 80 FA 38 0F 8F 0E 01 00 00 41 0F BE D2 89 0D ?? ?? ?? ?? 8D 4A D0 25 FF 7F FF FF 83 F9 08 0F 87 EC 00 00 00 FF 24 8D ?? ?? ?? ?? BE 00 80 00 00 85 C6 74 0C 25 FF FA FF FF 0D 00 02 00 00 EB 05 25 FF 9F FF FF 85 C6 74 0D 25 7F FF FF FF 83 C8 40 E9 E0 00 00 00 25 FF EF FF FF 0D 00 08 00 00 E9 D1 00 00 00 BE 00 80 00 00 85 C6 74 0C 25 FF FA FF FF 0D 00 02 00 00 EB 05 25 FF 9F FF FF 85 C6 74 0D 83 E0 BF 0D 80 00 00 00 E9 A6 00 00 00 25 FF F7 FF FF 0D 00 10 00 00 E9 97 00 00 00 BE 00 80 00 00 85 C6 74 0C 25 FF FA FF FF 0D 00 02 00 00 EB 05 25 FF 9F FF FF 85 C6 74 07 25 3F FF FF FF EB 72 25 FF E7 FF FF EB 6B 25 FF DF FF FF 0B C6 EB 62 25 FF E3 FF FF 0D 00 60 00 00 EB 56 25 FF BF FF FF 0D 00 20 00 00 EB 4A 25 FF EB FF FF 0D 00 68 00 00 EB 3E 25 FF F3 FF FF 0D 00 70 00 00 EB 32 25 FF FB FF FF 0D 00 78 00 00 EB 26 B8 FF FF 00 00 EB 1F 80 FA 39 75 0E 41 89 0D ?? ?? ?? ?? B8 FD FF 00 00 EB 0C 33 C0 84 D2 0F 95 C0 05 FE FF 00 00 5F 5E 5D 5B C3 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 01 01 00 00 01 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_11_0 {
	meta:
		name = "?doThisTypes@UnDecorator@@SAHXZ"
		size = 18
		refs = "0001 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 E0 60 33 C9 3C 60 0F 95 C1 8B C1 C3 }
	condition:
		$1
}

rule file_453_20_0 {
	meta:
		name = "?UScore@UnDecorator@@SAPBDW4Tokens@@@Z"
		size = 25
		refs = "0001 ?disableFlags@UnDecorator@@0KA 0010 _tokenTable"
	strings:
		$1 = { A1 ?? ?? ?? ?? F7 D0 A8 01 8B 44 24 04 8B 04 85 ?? ?? ?? ?? 75 02 40 40 C3 }
	condition:
		$1
}

rule file_453_21_0 {
	meta:
		name = "?getMemory@HeapManager@@QAEPAXIH@Z"
		size = 132
		refs = "003f _heap 0044 ?getMemory@HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 83 C7 07 83 E7 F8 83 7C 24 10 00 8B F1 74 06 57 FF 16 59 EB 64 85 FF 75 03 6A 08 5F 8B 46 10 3B C7 53 73 45 BB 00 10 00 00 3B FB 76 04 33 C0 EB 47 6A 01 68 04 10 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 05 83 20 00 EB 02 33 C0 85 C0 74 DC 8B 4E 0C 85 C9 74 04 89 01 EB 03 89 46 08 2B DF 89 46 0C 89 5E 10 EB 05 2B C7 89 46 10 8B 46 0C 8B 4E 10 8D 44 08 04 5B 5F 5E C2 08 00 }
	condition:
		$1
}

rule file_453_23_0 {
	meta:
		name = "??0DName@@QAE@PAVDNameNode@@@Z"
		size = 17
	strings:
		$1 = { 8B C1 8B 4C 24 04 66 81 60 04 00 FE 89 08 C2 04 00 }
	condition:
		$1
}

rule file_453_24_0 {
	meta:
		name = "??0DName@@QAE@ABV0@@Z"
		size = 105
	strings:
		$1 = { 8B C1 8B 4C 24 04 8B 51 04 C1 E2 1C C1 FA 1C 33 50 04 56 83 E2 0F 31 50 04 8B 70 04 8B 51 04 33 D6 83 E2 10 33 D6 89 50 04 8B 71 04 33 F2 83 E6 20 33 F2 89 70 04 8B 51 04 33 D6 83 E2 40 33 D6 89 50 04 8B 71 04 33 F2 81 E6 80 00 00 00 33 F2 89 70 04 8B 11 89 10 8B D6 33 51 04 5E 81 E2 00 01 00 00 31 50 04 C2 04 00 }
	condition:
		$1
}

rule file_453_33_0 {
	meta:
		name = "??4DName@@QAEAAV0@ABV0@@Z"
		size = 107
	strings:
		$1 = { 8B C1 56 8B 70 04 8B CE C1 E1 1C C1 F9 1C 74 05 83 F9 02 75 52 8B 4C 24 08 8B 51 04 C1 E2 1C C1 FA 1C 33 D6 83 E2 0F 33 D6 89 50 04 8B 71 04 33 F2 83 E6 10 33 F2 89 70 04 8B 51 04 33 D6 83 E2 20 33 D6 89 50 04 8B 71 04 33 F2 83 E6 40 33 F2 89 70 04 8B 51 04 33 D6 81 E2 80 00 00 00 33 D6 89 50 04 8B 09 89 08 5E C2 04 00 }
	condition:
		$1
}

rule file_453_35_0 {
	meta:
		name = "??AReplicator@@QBEABVDName@@H@Z"
		size = 41
	strings:
		$1 = { 8B 54 24 04 85 D2 7C 1B 83 FA 09 7F 16 8B 01 83 F8 FF 74 0A 3B D0 7F 06 8B 44 91 04 EB 08 8D 41 34 EB 03 8D 41 2C C2 04 00 }
	condition:
		$1
}

rule file_453_38_0 {
	meta:
		name = "??YDNameNode@@QAEAAV0@PAV0@@Z"
		size = 41
	strings:
		$1 = { 8B C1 8B 4C 24 04 85 C9 74 1C 8B 50 04 85 D2 74 12 56 EB 02 8B D6 8B 72 04 85 F6 75 F7 89 4A 04 5E EB 03 89 48 04 C2 04 00 }
	condition:
		$1
}

rule file_453_39_0 {
	meta:
		name = "??0charNode@@QAE@D@Z"
		size = 22
		refs = "000c ??_7charNode@@6B@"
	strings:
		$1 = { 8B C1 8A 4C 24 04 83 60 04 00 C7 00 ?? ?? ?? ?? 88 48 08 C2 04 00 }
	condition:
		$1
}

rule file_453_42_0 {
	meta:
		name = "?getString@charNode@@UBEPADPADH@Z"
		size = 27
	strings:
		$1 = { 8B 44 24 04 85 C0 74 0E 83 7C 24 08 00 74 07 8A 49 08 88 08 EB 02 33 C0 C2 08 00 }
	condition:
		$1
}

rule file_453_44_0 {
	meta:
		name = "??0pDNameNode@@QAE@PAVDName@@@Z"
		size = 47
		refs = "000e ??_7pDNameNode@@6B@"
	strings:
		$1 = { 8B 54 24 04 8B C1 83 60 04 00 85 D2 C7 00 ?? ?? ?? ?? 74 15 8B 4A 04 C1 E1 1C C1 F9 1C 83 F9 01 74 05 83 F9 03 75 02 33 D2 89 50 08 C2 04 00 }
	condition:
		$1
}

rule file_453_45_0 {
	meta:
		name = "??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
		size = 37
		refs = "000f ??_7DNameStatusNode@@6B@"
	strings:
		$1 = { 8B C1 8B 4C 24 04 83 60 04 00 83 F9 02 C7 00 ?? ?? ?? ?? 89 48 08 75 05 6A 04 59 EB 02 33 C9 89 48 0C C2 04 00 }
	condition:
		$1
}

rule file_453_49_0 {
	meta:
		name = "?und_strncpy@@YAPADPADPBDI@Z"
		size = 32
	strings:
		$1 = { 83 7C 24 08 00 8B 4C 24 04 74 10 8A 02 84 C0 88 01 74 08 41 42 FF 4C 24 08 75 F0 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_453_50_0 {
	meta:
		name = "?und_strncmp@@YAIPBD0I@Z"
		size = 37
	strings:
		$1 = { 83 7C 24 04 00 75 0F 33 C0 C3 8A 01 84 C0 74 0C 3A 02 75 08 41 42 FF 4C 24 04 75 EE 0F B6 01 0F B6 0A 2B C1 C3 }
	condition:
		$1
}

rule file_453_51_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ"
		size = 51
		refs = "0027 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C9 B8 00 FE FF FF 21 45 FC 21 45 F4 51 8D 45 F8 50 51 8D 45 F0 50 FF 75 08 89 4D F8 89 4D F0 E8 ?? ?? ?? ?? 8B 45 08 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_453_52_0 {
	meta:
		name = "?getThisType@UnDecorator@@CA?AVDName@@XZ"
		size = 52
		refs = "0028 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 B8 00 FE FF FF 21 45 FC 21 45 F4 6A 01 33 C9 8D 45 F8 50 51 8D 45 F0 50 FF 75 08 89 4D F8 89 4D F0 E8 ?? ?? ?? ?? 8B 45 08 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_453_53_0 {
	meta:
		name = "??2@YAPAXIAAVHeapManager@@H@Z"
		size = 19
		refs = "0005 _heap 000e ?getMemory@HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { FF 74 24 0C B9 ?? ?? ?? ?? FF 74 24 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_453_54_0 {
	meta:
		name = "??0DName@@QAE@PAV0@@Z"
		size = 85
		refs = "000f _heap 0014 ?getMemory@HeapManager@@QAEPAXIH@Z 0023 ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 83 7C 24 04 00 56 8B F1 74 38 6A 00 6A 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D FF 74 24 08 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 89 06 F7 D8 1B C0 83 E0 FD 83 C0 03 33 46 04 83 E0 0F 31 46 04 EB 07 83 66 04 F0 83 26 00 66 81 66 04 0F FE 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_55_0 {
	meta:
		name = "??0DName@@QAE@W4DNameStatus@@@Z"
		size = 96
		refs = "0028 _heap 002d ?getMemory@HeapManager@@QAEPAXIH@Z 0039 ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 83 FF 01 8B F1 74 09 83 FF 03 74 04 33 C0 EB 02 8B C7 8B 4E 04 33 C8 83 E1 0F 31 4E 04 6A 00 6A 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 57 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 66 81 66 04 0F FE 85 C0 8B 4E 04 89 06 75 09 83 E1 F3 83 C9 03 89 4E 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_56_0 {
	meta:
		name = "?isValid@DName@@QBEHXZ"
		size = 23
	strings:
		$1 = { 8B 41 04 C1 E0 1C C1 F8 1C 74 08 83 F8 02 74 03 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_453_57_0 {
	meta:
		name = "?isEmpty@DName@@QBEHXZ"
		size = 21
		refs = "0006 ?isValid@DName@@QBEHXZ"
	strings:
		$1 = { 83 39 00 74 0C E8 ?? ?? ?? ?? 85 C0 74 03 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_453_58_0 {
	meta:
		name = "?isUDC@DName@@QBEHXZ"
		size = 20
		refs = "0001 ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 08 F6 41 04 20 74 02 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_453_60_0 {
	meta:
		name = "?isUDTThunk@DName@@QBEHXZ"
		size = 20
		refs = "0001 ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 08 F6 41 04 40 74 02 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_453_61_0 {
	meta:
		name = "?length@DName@@QBEHXZ"
		size = 37
		refs = "0004 ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { 57 33 FF E8 ?? ?? ?? ?? 85 C0 75 15 56 8B 31 EB 0B 8B 06 8B CE FF 10 8B 76 04 03 F8 85 F6 75 F1 5E 8B C7 5F C3 }
	condition:
		$1
}

rule file_453_62_0 {
	meta:
		name = "?getLastChar@DName@@QBEDXZ"
		size = 56
		refs = "0005 ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { 56 57 33 FF E8 ?? ?? ?? ?? 85 C0 75 26 8B 31 85 F6 74 20 8B 06 8B CE FF 10 85 C0 74 02 8B FE 8B 76 04 85 F6 75 ED 85 FF 74 09 8B 07 8B CF 5F 5E FF 60 04 5F 32 C0 5E C3 }
	condition:
		$1
}

rule file_453_63_0 {
	meta:
		name = "?getString@DName@@QBEPADPADH@Z"
		size = 145
		refs = "0008 ?isEmpty@DName@@QBEHXZ 0016 ?length@DName@@QBEHXZ 0021 _heap 0026 ?getMemory@HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 E8 ?? ?? ?? ?? 85 C0 75 6C 39 45 08 75 1E E8 ?? ?? ?? ?? 8B F0 6A 00 46 56 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 45 08 74 57 EB 03 8B 75 0C 8B 45 08 53 8B DE 8B 37 89 45 0C EB 2F 85 DB 7E 2F 8B 06 8B CE FF 10 8B F8 85 FF 74 1C 8B C3 2B C7 79 02 8B FB 8B 06 57 FF 75 0C 8B CE FF 50 08 85 C0 74 05 2B DF 01 7D 0C 8B 76 04 85 F6 75 CD 8B 45 0C 5B EB 09 83 7D 08 00 74 06 8B 45 08 C6 00 00 8B 45 08 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_453_64_0 {
	meta:
		name = "??_5DName@@QAEAAV0@ABV0@@Z"
		size = 53
		refs = "0014 ?isValid@DName@@QBEHXZ"
	strings:
		$1 = { 8B D1 56 8B 72 04 8B C6 83 E0 0F 3C 03 74 20 8B 4C 24 08 E8 ?? ?? ?? ?? 85 C0 75 13 8B 41 04 C1 E0 1C C1 F8 1C 33 C6 83 E0 0F 33 C6 89 42 04 8B C2 5E C2 04 00 }
	condition:
		$1
}

rule file_453_65_0 {
	meta:
		name = "??4DName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 129
		refs = "002e _heap 0036 ?getMemory@HeapManager@@QAEPAXIH@Z 0042 ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 83 FF 01 8B F1 74 51 83 FF 03 74 4C 8B 46 04 8B C8 C1 E1 1C C1 F9 1C 74 05 83 F9 02 75 56 6A 00 25 0F FF FF FF 6A 10 B9 ?? ?? ?? ?? 89 46 04 E8 ?? ?? ?? ?? 85 C0 74 0A 57 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 85 C0 89 06 75 2A 8B 46 04 83 E0 F3 83 C8 03 89 46 04 EB 1C 8B 46 04 83 26 00 8B C8 83 E1 0F 80 F9 03 74 0C 8B C8 33 CF 83 E1 0F 33 C8 89 4E 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_66_0 {
	meta:
		name = "??0Replicator@@QAE@XZ"
		size = 30
		refs = "0009 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 8B F1 6A 03 8D 4E 2C E8 ?? ?? ?? ?? 6A 01 8D 4E 34 E8 ?? ?? ?? ?? 83 0E FF 8B C6 5E C3 }
	condition:
		$1
}

rule file_453_67_0 {
	meta:
		name = "??YReplicator@@QAEAAV0@ABVDName@@@Z"
		size = 71
		refs = "000d ?isEmpty@DName@@QBEHXZ 0019 _heap 001e ?getMemory@HeapManager@@QAEPAXIH@Z 002d ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 56 8B F1 83 3E 09 74 39 8B 4C 24 08 E8 ?? ?? ?? ?? 85 C0 75 2C 50 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D FF 74 24 08 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 08 FF 06 8B 0E 89 44 8E 04 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_68_0 {
	meta:
		name = "?clone@DNameNode@@QAEPAV1@XZ"
		size = 70
		refs = "0008 _heap 0011 ?getMemory@HeapManager@@QAEPAXIH@Z 003a ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 53 56 57 6A 00 8B F9 BE ?? ?? ?? ?? 6A 0C 8B CE E8 ?? ?? ?? ?? 8B D8 85 DB 74 25 6A 00 6A 08 8B CE E8 ?? ?? ?? ?? 85 C0 74 0A 66 81 60 04 00 FE 89 38 EB 02 33 C0 50 8B CB E8 ?? ?? ?? ?? EB 02 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule file_453_69_0 {
	meta:
		name = "??0pcharNode@@QAE@PBDH@Z"
		size = 103
		refs = "0016 ??_7pcharNode@@6B@ 0039 _heap 003e ?getMemory@HeapManager@@QAEPAXIH@Z 0051 ?und_strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 53 8B 5C 24 08 56 57 8B 7C 24 14 33 C0 3B F8 8B F1 89 46 04 C7 06 ?? ?? ?? ?? 75 16 3B D8 74 39 33 FF 80 3B 00 74 07 47 80 3C 1F 00 75 F9 3B F8 74 27 3B D8 74 23 50 57 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 46 08 89 7E 0C 74 13 57 50 8B D3 E8 ?? ?? ?? ?? 59 59 EB 06 89 46 08 89 46 0C 5F 8B C6 5E 5B C2 08 00 }
	condition:
		$1
}

rule file_453_70_0 {
	meta:
		name = "?getLastChar@pcharNode@@UBEDXZ"
		size = 18
	strings:
		$1 = { 8B 41 0C 85 C0 74 08 8B 49 08 8A 44 01 FF C3 32 C0 C3 }
	condition:
		$1
}

rule file_453_71_0 {
	meta:
		name = "?getString@pcharNode@@UBEPADPADH@Z"
		size = 49
		refs = "0028 ?und_strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 8B 41 0C 8B 54 24 08 3B D0 7E 02 8B D0 8B 49 08 33 C0 3B C8 74 18 39 44 24 04 74 12 3B D0 74 0E 52 FF 74 24 08 8B D1 E8 ?? ?? ?? ?? 59 59 C2 08 00 }
	condition:
		$1
}

rule file_453_74_0 {
	meta:
		name = "?getString@pDNameNode@@UBEPADPADH@Z"
		size = 29
		refs = "0016 ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 8B 49 08 33 C0 3B C8 74 11 39 44 24 04 74 0B 39 44 24 08 74 05 E9 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_453_75_0 {
	meta:
		name = "?getString@DNameStatusNode@@UBEPADPADH@Z"
		size = 51
		refs = "0025 ??_C@_04OKOHEJBO@?5?$DP?$DP?5?$AA@ 002a ?und_strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 8B 41 0C 8B 54 24 08 3B D0 7E 02 8B D0 33 C0 83 79 08 02 75 1B 39 44 24 04 74 15 3B D0 74 11 52 FF 74 24 08 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 C2 08 00 }
	condition:
		$1
}

rule file_453_76_0 {
	meta:
		name = "??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z"
		size = 115
		refs = "0008 ??0Replicator@@QAE@XZ 001a ?name@UnDecorator@@0PBDB 001f ?gName@UnDecorator@@0PBDB 0032 ?maxStringLength@UnDecorator@@0HA 0037 ?outputString@UnDecorator@@0PADA 004d ?disableFlags@UnDecorator@@0KA 0056 ?pZNameList@UnDecorator@@0PAVReplicator@@A 005b ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0062 ?pArgList@UnDecorator@@0PAVReplicator@@A 006a ?fExplicitTemplateParams@UnDecorator@@0_NA"
	strings:
		$1 = { 55 8B EC 56 57 8B F1 E8 ?? ?? ?? ?? 8D 7E 3C 8B CF E8 ?? ?? ?? ?? 8B 45 0C A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 45 08 33 C9 3B C1 74 11 8B 55 10 4A 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 0C 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 45 18 A3 ?? ?? ?? ?? 8B 45 14 89 3D ?? ?? ?? ?? A3 ?? ?? ?? ?? 5F 89 35 ?? ?? ?? ?? 8B C6 88 0D ?? ?? ?? ?? 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_453_77_0 {
	meta:
		name = "?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z"
		size = 47
		refs = "0004 ?gName@UnDecorator@@0PBDB 001a ??0DName@@QAE@PAV0@@Z 0024 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 80 38 40 FF 75 0C 75 10 8B 4D 08 FF 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_453_79_0 {
	meta:
		name = "??YDName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 123
		refs = "0005 ?isEmpty@DName@@QBEHXZ 0020 _heap 0025 ?getMemory@HeapManager@@QAEPAXIH@Z 0031 ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z 0042 ?clone@DNameNode@@QAEPAV1@XZ 0050 ??YDNameNode@@QAEAAV0@PAV0@@Z 0070 ??4DName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 57 8B F1 E8 ?? ?? ?? ?? 85 C0 8B 7C 24 0C 75 5B 83 FF 01 74 56 83 FF 03 74 51 6A 00 6A 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 57 8B C8 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 85 FF 74 17 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 12 57 8B C8 E8 ?? ?? ?? ?? EB 03 83 26 00 83 3E 00 75 16 8B 46 04 83 E0 F3 83 C8 03 89 46 04 EB 08 57 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_80_0 {
	meta:
		name = "??4DName@@QAEAAV0@PAV0@@Z"
		size = 104
		refs = "0026 _heap 002e ?getMemory@HeapManager@@QAEPAXIH@Z 003d ??0pDNameNode@@QAE@PAVDName@@@Z 005e ??4DName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 8B F1 8B 46 04 8B C8 C1 E1 1C C1 F9 1C 74 05 83 F9 02 75 4D 83 7C 24 08 00 74 3D 6A 00 25 0F FF FF FF 6A 0C B9 ?? ?? ?? ?? 89 46 04 E8 ?? ?? ?? ?? 85 C0 74 0D FF 74 24 08 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 85 C0 89 06 75 17 8B 46 04 83 E0 F3 83 C8 03 89 46 04 EB 09 6A 03 8B CE E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_81_0 {
	meta:
		name = "?doPchar@DName@@AAEXPBDH@Z"
		size = 166
		refs = "002c ??4DName@@QAEAAV0@W4DNameStatus@@@Z 004a _heap 0053 ?getMemory@HeapManager@@QAEPAXIH@Z 0063 ??0pcharNode@@QAE@PBDH@Z 007b ??_7charNode@@6B@"
	strings:
		$1 = { 56 8B F1 8B 46 04 8B C8 C1 E1 1C C1 F9 1C 83 F9 01 0F 84 8B 00 00 00 83 F9 03 0F 84 82 00 00 00 53 33 DB 39 1E 74 0B 6A 03 8B CE E8 ?? ?? ?? ?? EB 6F 57 8B 7C 24 10 3B FB 74 5C 8B 4C 24 14 3B CB 74 54 2B CB 74 48 49 53 B9 ?? ?? ?? ?? 74 19 6A 10 E8 ?? ?? ?? ?? 3B C3 74 29 FF 74 24 14 8B C8 57 E8 ?? ?? ?? ?? EB 1D 6A 0C E8 ?? ?? ?? ?? 3B C3 74 10 8A 0F 89 58 04 C7 00 ?? ?? ?? ?? 88 48 08 EB 02 33 C0 3B C3 89 06 75 14 8B 46 04 83 E0 F3 83 C8 03 EB 06 83 E0 F1 83 C8 01 89 46 04 5F 5B 5E C2 08 00 }
	condition:
		$1
}

rule file_453_82_0 {
	meta:
		name = "??0DName@@QAE@D@Z"
		size = 37
		refs = "001b ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 56 8B F1 83 26 00 66 81 66 04 00 FE 80 7C 24 08 00 74 0C 6A 01 8D 44 24 0C 50 E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_83_0 {
	meta:
		name = "??0DName@@QAE@PBD@Z"
		size = 48
		refs = "0026 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 8B 44 24 04 56 8B F1 66 81 66 04 00 FE 33 D2 3B C2 89 16 74 15 33 C9 38 10 74 06 41 38 14 01 75 FA 51 50 8B CE E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_84_0 {
	meta:
		name = "??0DName@@QAE@AAPBDD@Z"
		size = 205
		refs = "006a ?disableFlags@UnDecorator@@0KA 0081 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 66 81 66 04 00 FE 8B 46 04 33 DB 57 8B 7D 08 89 1E 8B 0F 3B CB 0F 84 84 00 00 00 38 19 0F 84 9B 00 00 00 89 4D 08 8B 07 8A 10 3A 55 0C 74 44 80 FA 5F 74 36 80 FA 24 74 31 80 FA 61 7C 05 80 FA 7A 7E 27 80 FA 41 7C 05 80 FA 5A 7E 1D 80 FA 30 7C 05 80 FA 39 7E 13 80 FA 80 72 05 80 FA FE 76 09 F6 05 ?? ?? ?? ?? 01 74 32 43 40 89 07 80 38 00 75 B3 53 FF 75 08 8B CE E8 ?? ?? ?? ?? 8B 07 8A 08 84 C9 74 31 40 3A 4D 0C 89 07 74 23 8B 46 04 83 E0 F3 83 C8 03 83 26 00 EB 09 8B 46 04 83 E0 F1 83 C8 01 89 46 04 5F 8B C6 5E 5B 5D C2 08 00 83 66 04 F0 EB F1 8B 46 04 A8 0F 75 EA 83 E0 F2 83 C8 02 EB DF }
	condition:
		$1
}

rule file_453_85_0 {
	meta:
		name = "??0DName@@QAE@_K@Z"
		size = 100
		refs = "0007 ___security_cookie 002f __aulldvrm 004f ?doPchar@DName@@AAEXPBDH@Z 005c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 53 56 57 8B F9 83 27 00 66 81 67 04 00 FE 89 45 FC 8D 75 F8 C6 45 F8 00 6A 00 6A 0A FF 75 0C 4E FF 75 08 E8 ?? ?? ?? ?? 80 C1 30 89 45 08 0B C2 89 5D E0 88 0E 89 55 0C 75 DE 8D 45 F8 2B C6 50 56 8B CF E8 ?? ?? ?? ?? 8B 4D FC 8B C7 5F 5E 5B E8 ?? ?? ?? ?? C9 C2 08 00 }
	condition:
		$1
}

rule file_453_86_0 {
	meta:
		name = "??0DName@@QAE@_J@Z"
		size = 146
		refs = "0007 ___security_cookie 0051 __aulldvrm 007e ?doPchar@DName@@AAEXPBDH@Z 008a @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 56 57 8B F9 66 81 67 04 00 FE 33 C9 89 45 FC 8B 45 0C 3B C1 8D 75 F9 89 0F 88 4D F9 88 4D E3 7F 17 7C 05 39 4D 08 73 10 8B 55 08 F7 DA 13 C1 C6 45 E3 01 F7 D8 89 55 08 53 EB 02 33 C9 51 6A 0A 50 FF 75 08 4E E8 ?? ?? ?? ?? 80 C1 30 89 45 08 88 0E 8B 4D 08 8B C2 0B C8 89 5D DC 75 DD 80 7D E3 00 5B 74 04 4E C6 06 2D 8D 45 F9 2B C6 50 56 8B CF E8 ?? ?? ?? ?? 8B 4D FC 8B C7 5F 5E E8 ?? ?? ?? ?? C9 C2 08 00 }
	condition:
		$1
}

rule file_453_87_0 {
	meta:
		name = "??HDName@@QBE?AV0@W4DNameStatus@@@Z"
		size = 60
		refs = "000a ??0DName@@QAE@ABV0@@Z 0012 ?isEmpty@DName@@QBEHXZ 001e ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0025 ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 51 51 51 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 FF 75 0C 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C2 08 00 }
	condition:
		$1
}

rule file_453_103_0 {
	meta:
		name = "??HDName@@QBE?AV0@D@Z"
		size = 60
		refs = "000a ??0DName@@QAE@ABV0@@Z 0012 ?isEmpty@DName@@QBEHXZ 001e ??4DName@@QAEAAV0@D@Z 0025 ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 55 8B EC 51 51 51 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 FF 75 0C 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C2 08 00 }
	condition:
		$1
}

rule file_453_95_0 {
	meta:
		name = "??HDName@@QBE?AV0@PAV0@@Z"
		size = 60
		refs = "000a ??0DName@@QAE@ABV0@@Z 0012 ?isEmpty@DName@@QBEHXZ 001e ??4DName@@QAEAAV0@PAV0@@Z 0025 ??YDName@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 51 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 FF 75 0C 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C2 08 00 }
	condition:
		$1
}

rule file_453_104_0 {
	meta:
		name = "??HDName@@QBE?AV0@PBD@Z"
		size = 60
		refs = "000a ??0DName@@QAE@ABV0@@Z 0012 ?isEmpty@DName@@QBEHXZ 001e ??4DName@@QAEAAV0@PBD@Z 0025 ??YDName@@QAEAAV0@PBD@Z"
	strings:
		$1 = { 55 8B EC 51 51 51 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 FF 75 0C 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C2 08 00 }
	condition:
		$1
}

rule file_453_88_0 {
	meta:
		name = "??YDName@@QAEAAV0@ABV0@@Z"
		size = 100
		refs = "000b ?isEmpty@DName@@QBEHXZ 0020 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0033 ??4DName@@QAEAAV0@ABV0@@Z 003c ?clone@DNameNode@@QAEPAV1@XZ 004b ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 8B F1 8B CF E8 ?? ?? ?? ?? 85 C0 8B CE 74 11 8B 47 04 C1 E0 1C C1 F8 1C 50 E8 ?? ?? ?? ?? EB 37 E8 ?? ?? ?? ?? 85 C0 74 0A 57 8B CE E8 ?? ?? ?? ?? EB 24 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 0B FF 37 8B C8 E8 ?? ?? ?? ?? EB 0C 8B 46 04 83 E0 F3 83 C8 03 89 46 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_89_0 {
	meta:
		name = "??YDName@@QAEAAV0@PAV0@@Z"
		size = 141
		refs = "000d ?isEmpty@DName@@QBEHXZ 0017 ??4DName@@QAEAAV0@PAV0@@Z 0031 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 003c _heap 0041 ?getMemory@HeapManager@@QAEPAXIH@Z 004d ??0pDNameNode@@QAE@PAVDName@@@Z 005e ?clone@DNameNode@@QAEPAV1@XZ 006c ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 85 FF 8B F1 74 7A E8 ?? ?? ?? ?? 85 C0 74 08 57 E8 ?? ?? ?? ?? EB 69 8B 47 04 C1 E0 1C C1 F8 1C 74 0F 83 F8 02 74 0A 50 8B CE E8 ?? ?? ?? ?? EB 4F 6A 00 6A 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 57 8B C8 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 85 FF 74 17 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 12 57 8B C8 E8 ?? ?? ?? ?? EB 03 83 26 00 83 3E 00 75 0C 8B 46 04 83 E0 F3 83 C8 03 89 46 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_90_0 {
	meta:
		name = "??4DName@@QAEAAV0@D@Z"
		size = 25
		refs = "000f ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 56 6A 01 8D 44 24 0C 8B F1 80 66 04 0F 50 E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_91_0 {
	meta:
		name = "??4DName@@QAEAAV0@PBD@Z"
		size = 39
		refs = "001d ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 8B 44 24 04 56 8B F1 80 66 04 0F 33 C9 38 08 74 07 41 80 3C 01 00 75 F9 51 50 8B CE E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_92_0 {
	meta:
		name = "?getCallingConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 165
		refs = "0006 ?gName@UnDecorator@@0PBDB 0027 ?disableFlags@UnDecorator@@0KA 0074 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0080 ??4DName@@QAEAAV0@PBD@Z 008c ??0DName@@QAE@ABV0@@Z 009c ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 82 00 00 00 0F BE C0 83 E8 41 FF 05 ?? ?? ?? ?? 83 F8 0C 77 6D 8B 0D ?? ?? ?? ?? 83 65 F8 00 66 81 65 FC 00 FE D1 E9 F7 D1 F6 C1 01 74 46 83 E0 FE 83 E8 00 74 2B 6A 02 59 2B C1 74 21 2B C1 74 19 2B C1 74 11 2B C1 74 09 83 E8 04 75 26 6A 06 EB 11 6A 05 EB 0D 6A 03 EB 09 6A 04 EB 05 51 EB 02 6A 01 E8 ?? ?? ?? ?? 83 C4 04 8D 4D F8 50 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? EB 0E 6A 01 EB 02 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_93_0 {
	meta:
		name = "?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ"
		size = 55
		refs = "0004 ?gName@UnDecorator@@0PBDB 0020 ??_C@_06EEGAIFAK@?$HLflat?$HN?$AA@ 0025 ??0DName@@QAE@PBD@Z 002e ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8A 00 84 C0 8B 4D 08 74 1A 3C 41 74 04 6A 01 EB 14 FF 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 07 6A 02 E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_453_94_0 {
	meta:
		name = "??HDName@@QBE?AV0@ABV0@@Z"
		size = 96
		refs = "000a ??0DName@@QAE@ABV0@@Z 0012 ?isEmpty@DName@@QBEHXZ 001e ??4DName@@QAEAAV0@ABV0@@Z 003e ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0049 ??YDName@@QAEAAV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 51 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0A FF 75 0C E8 ?? ?? ?? ?? EB 29 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 74 14 8B 41 04 C1 E0 1C C1 F8 1C 50 8D 4D F8 E8 ?? ?? ?? ?? EB 09 51 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C2 08 00 }
	condition:
		$1
}

rule file_453_96_0 {
	meta:
		name = "??YDName@@QAEAAV0@D@Z"
		size = 106
		refs = "000d ?isEmpty@DName@@QBEHXZ 0017 ??4DName@@QAEAAV0@D@Z 0020 ?clone@DNameNode@@QAEPAV1@XZ 002f _heap 0034 ?getMemory@HeapManager@@QAEPAXIH@Z 0042 ??_7charNode@@6B@ 0051 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 53 8B 5C 24 08 84 DB 56 8B F1 74 57 E8 ?? ?? ?? ?? 85 C0 74 08 53 E8 ?? ?? ?? ?? EB 46 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 2D 6A 00 6A 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0F 83 60 04 00 C7 00 ?? ?? ?? ?? 88 58 08 EB 02 33 C0 8B 0E 50 E8 ?? ?? ?? ?? EB 0C 8B 46 04 83 E0 F3 83 C8 03 89 46 04 8B C6 5E 5B C2 04 00 }
	condition:
		$1
}

rule file_453_97_0 {
	meta:
		name = "??YDName@@QAEAAV0@PBD@Z"
		size = 108
		refs = "0012 ?isEmpty@DName@@QBEHXZ 001c ??4DName@@QAEAAV0@PBD@Z 0025 ?clone@DNameNode@@QAEPAV1@XZ 0034 _heap 0039 ?getMemory@HeapManager@@QAEPAXIH@Z 0047 ??0pcharNode@@QAE@PBDH@Z 0053 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 85 FF 8B F1 74 59 80 3F 00 74 54 E8 ?? ?? ?? ?? 85 C0 74 08 57 E8 ?? ?? ?? ?? EB 43 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 2A 6A 00 6A 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 6A 00 57 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 8B 0E 50 E8 ?? ?? ?? ?? EB 0C 8B 46 04 83 E0 F3 83 C8 03 89 46 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_453_98_0 {
	meta:
		name = "?getArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 231
		refs = "0023 ?gName@UnDecorator@@0PBDB 0049 ??YDName@@QAEAAV0@D@Z 0069 ?pArgList@UnDecorator@@0PAVReplicator@@A 0073 ??AReplicator@@QBEABVDName@@H@Z 008b ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 00ad ??YReplicator@@QAEAAV0@ABVDName@@@Z 00b9 ??YDName@@QAEAAV0@ABV0@@Z 00cf ??YDName@@QAEAAV0@W4DNameStatus@@@Z 00dc ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 83 65 F8 00 53 56 33 DB BE 00 FE FF FF 21 75 FC 43 F6 45 FC 0F 0F 85 B3 00 00 00 57 A1 ?? ?? ?? ?? 8A 08 80 F9 40 0F 84 A1 00 00 00 80 F9 5A 0F 84 98 00 00 00 85 DB 74 04 33 DB EB 0F 6A 2C 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 08 84 C9 74 71 0F BE C9 83 E9 30 78 19 83 F9 09 7F 14 40 51 8B 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 3B 83 65 F0 00 21 75 F4 8B F8 8D 45 F0 50 8D 45 E8 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B C7 83 F8 01 59 59 7E 14 8B 0D ?? ?? ?? ?? 83 39 09 74 09 8D 45 E8 50 E8 ?? ?? ?? ?? 8D 45 E8 8D 4D F8 50 E8 ?? ?? ?? ?? F6 45 FC 0F 0F 84 5B FF FF FF EB 0A 6A 02 8D 4D F8 E8 ?? ?? ?? ?? 5F 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 5E 5B C9 C3 }
	condition:
		$1
}

rule file_453_99_0 {
	meta:
		name = "?getVdispMapType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 92
		refs = "000d ??0DName@@QAE@ABV0@@Z 0012 ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 001a ??YDName@@QAEAAV0@PBD@Z 0023 ?getScope@UnDecorator@@CA?AVDName@@XZ 002d ??YDName@@QAEAAV0@ABV0@@Z 0037 ??YDName@@QAEAAV0@D@Z 003c ?gName@UnDecorator@@0PBDB"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 6A 7D 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 75 06 FF 05 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_100_0 {
	meta:
		name = "??H@YA?AVDName@@DABV0@@Z"
		size = 34
		refs = "0012 ??0DName@@QAE@D@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_102_0 {
	meta:
		name = "??H@YA?AVDName@@PBDABV0@@Z"
		size = 34
		refs = "0012 ??0DName@@QAE@PBD@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_101_0 {
	meta:
		name = "??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
		size = 34
		refs = "0012 ??0DName@@QAE@W4DNameStatus@@@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_105_0 {
	meta:
		name = "?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
		size = 321
		refs = "0009 ?gName@UnDecorator@@0PBDB 001b ??_C@_0BN@IBLMMFAP@?$GAnon?9type?9template?9parameter?$AA@ 0031 ??0DName@@QAE@W4DNameStatus@@@Z 005b ??0DName@@QAE@_K@Z 0068 ??H@YA?AVDName@@PBDABV0@@Z 007e ??0DName@@QAE@ABV0@@Z 00ae __allmul 00f9 ??0DName@@QAE@_J@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 56 8B 35 ?? ?? ?? ?? 33 C9 80 3E 51 89 4D FC 75 0E 46 C7 45 FC ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 8A 06 3A C1 75 0F 8B 4D 08 6A 02 E8 ?? ?? ?? ?? E9 01 01 00 00 3C 30 7C 49 3C 39 7F 45 0F BE 06 83 E8 2F 99 46 39 4D FC 52 89 35 ?? ?? ?? ?? 50 74 1A 8D 4D F4 E8 ?? ?? ?? ?? 50 FF 75 FC 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C EB 08 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? E9 B4 00 00 00 53 57 33 FF EB 39 84 C0 74 52 3C 41 7C 42 3C 50 7F 3E 0F BE C0 83 E8 41 6A 00 99 6A 10 8B D8 57 8B C2 51 89 45 F8 E8 ?? ?? ?? ?? 03 D8 8B 45 F8 13 C2 46 8B F8 89 35 ?? ?? ?? ?? 8A 06 8B CB 3C 40 75 C3 8A 06 46 3C 40 89 35 ?? ?? ?? ?? 74 10 6A 01 8B 4D 08 E8 ?? ?? ?? ?? EB 56 6A 02 EB F2 33 C0 38 45 0C 57 51 74 29 39 45 FC 74 1A 8D 4D E4 E8 ?? ?? ?? ?? 50 FF 75 FC 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C EB 21 8D 4D F4 E8 ?? ?? ?? ?? EB 17 39 45 FC 74 0A 8D 4D E4 E8 ?? ?? ?? ?? EB D5 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 5F 5B 8B 45 08 5E C9 C3 }
	condition:
		$1
}

rule file_453_106_0 {
	meta:
		name = "?getEnumType@UnDecorator@@CA?AVDName@@XZ"
		size = 209
		refs = "0007 ?gName@UnDecorator@@0PBDB 002d $L23013 0032 ??_C@_05CIHEBHNO@char?5?$AA@ 0039 ??_C@_06EHJMALKF@short?5?$AA@ 0040 ??_C@_04LAHKHJMA@int?5?$AA@ 0047 ??_C@_05CJIMAING@long?5?$AA@ 004f ??4DName@@QAEAAV0@PBD@Z 007a ??_C@_09EBBEKKIH@unsigned?5?$AA@ 0080 ??H@YA?AVDName@@PBDABV0@@Z 008c ??4DName@@QAEAAV0@ABV0@@Z 0098 ??0DName@@QAE@ABV0@@Z 00a8 ??0DName@@QAE@W4DNameStatus@@@Z 00b1 $L20444 00b9 $L20446 00c1 $L20441 00c5 $L20449 00c9 $L20451"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 8A 00 83 65 F8 00 66 81 65 FC 00 FE 84 C0 0F 84 83 00 00 00 0F BE C0 83 C0 D0 83 F8 07 77 74 FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 13 68 ?? ?? ?? ?? EB 0C 68 ?? ?? ?? ?? EB 05 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 00 FF 05 ?? ?? ?? ?? 83 E8 31 74 0C 48 48 74 08 48 48 74 04 48 48 75 1E 8D 45 F8 50 8D 45 F0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? EB 0E 6A 01 EB 02 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_107_0 {
	meta:
		name = "?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 146
		refs = "0007 ?gName@UnDecorator@@0PBDB 001c ?getArgumentList@UnDecorator@@CA?AVDName@@XZ 0040 ??0DName@@QAE@W4DNameStatus@@@Z 004d ??_C@_04EENFHACM@?0?4?4?4?$AA@ 0059 ??HDName@@QBE?AV0@PBD@Z 006d ??0DName@@QAE@ABV0@@Z 0074 ??_C@_03KHICJKCI@?4?4?4?$AA@ 007b ??_C@_04GKJNKENE@void?$AA@ 0089 ??0DName@@QAE@PBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 0F BE 00 83 E8 58 74 67 48 48 74 5C 8D 45 F8 50 E8 ?? ?? ?? ?? F6 45 FC 0F 59 75 3E A1 ?? ?? ?? ?? 8A 00 84 C0 74 33 3C 40 74 29 3C 5A 74 0C 8B 4D 08 6A 01 E8 ?? ?? ?? ?? EB 47 FF 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? EB 09 FF 05 ?? ?? ?? ?? 8D 45 F8 8B 4D 08 50 E8 ?? ?? ?? ?? EB 1A 68 ?? ?? ?? ?? EB 05 68 ?? ?? ?? ?? 8B 4D 08 FF 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_108_0 {
	meta:
		name = "?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 125
		refs = "0007 ?gName@UnDecorator@@0PBDB 002d ??0DName@@QAE@ABV0@@Z 003a ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 0043 ??_C@_07HDJPLPEK@?5throw?$CI?$AA@ 0049 ??H@YA?AVDName@@PBDABV0@@Z 0066 ??0DName@@QAE@PBD@Z 006d ??HDName@@QBE?AV0@W4DNameStatus@@@Z 0074 ??HDName@@QBE?AV0@D@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 8A 00 84 C0 74 41 3C 5A 8D 45 F8 75 1B 8B 4D 08 FF 05 ?? ?? ?? ?? 83 65 F8 00 66 81 65 FC 00 FE 50 E8 ?? ?? ?? ?? EB 45 6A 29 FF 75 08 50 E8 ?? ?? ?? ?? 50 8D 45 F0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 EB 1F 6A 29 FF 75 08 8D 45 F0 6A 02 50 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_109_0 {
	meta:
		name = "?getArrayType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 347
		refs = "0007 ?gName@UnDecorator@@0PBDB 0016 ?getNumberOfDimensions@UnDecorator@@CAHXZ 0038 ??0DName@@QAE@D@Z 003f ??HDName@@QBE?AV0@W4DNameStatus@@@Z 0046 ??HDName@@QBE?AV0@D@Z 004f ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0070 ??_C@_02GPECMEKF@?$FL?$FN?$AA@ 0078 ??YDName@@QAEAAV0@PBD@Z 0089 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0095 ??H@YA?AVDName@@DABV0@@Z 00a8 ??YDName@@QAEAAV0@ABV0@@Z 00b2 ?isEmpty@DName@@QBEHXZ 00e9 ??HDName@@QBE?AV0@ABV0@@Z 00f2 ??4DName@@QAEAAV0@ABV0@@Z 00ff ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0111 ??0DName@@QAE@ABV0@@Z 0138 ??_C@_02GOGNNPBN@?$CJ?$FL?$AA@ 0152 ??HDName@@QBE?AV0@PBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 80 38 00 57 0F 84 06 01 00 00 E8 ?? ?? ?? ?? 8B F8 85 FF 7D 04 33 FF 85 FF 75 35 8D 45 F0 6A 5D 50 8D 45 F8 6A 02 50 8D 4D E8 6A 5B E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 5F C9 C3 83 65 F8 00 66 81 65 FC 00 FE 56 8B 75 0C F6 46 04 80 74 0D 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 6A 5D 8D 45 E8 50 8D 45 E0 6A 00 50 E8 ?? ?? ?? ?? 50 8D 45 D8 6A 5B 50 E8 ?? ?? ?? ?? 83 C4 14 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 4F 75 CD 8B CE E8 ?? ?? ?? ?? 85 C0 75 3C F6 46 04 80 8D 45 F8 50 8D 45 D8 50 74 02 EB 1E 6A 29 8D 45 E0 50 56 8D 45 E8 6A 28 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 4D F8 50 E8 ?? ?? ?? ?? 8D 45 F8 50 8D 45 F0 50 E8 ?? ?? ?? ?? 80 4D F4 80 59 59 8B 4D 08 8D 45 F0 50 E8 ?? ?? ?? ?? 5E E9 3A FF FF FF 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 8D 45 D8 6A 5D 50 8D 45 E0 0F 85 FB FE FF FF 6A 02 50 68 ?? ?? ?? ?? 8D 45 E8 50 51 8D 45 F0 6A 28 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? E9 E1 FE FF FF }
	condition:
		$1
}

rule file_453_110_0 {
	meta:
		name = "?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ"
		size = 49
		refs = "0012 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 001e ??H@YA?AVDName@@DABV0@@Z 0028 ??HDName@@QBE?AV0@D@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 27 FF 75 08 8D 45 F8 6A 00 50 E8 ?? ?? ?? ?? 50 8D 45 F0 6A 60 50 E8 ?? ?? ?? ?? 83 C4 14 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_111_0 {
	meta:
		name = "?getDisplacement@UnDecorator@@CA?AVDName@@XZ"
		size = 18
		refs = "0007 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
	strings:
		$1 = { 6A 01 FF 74 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 59 59 C3 }
	condition:
		$1
}

rule file_453_112_0 {
	meta:
		name = "?getCallIndex@UnDecorator@@CA?AVDName@@XZ"
		size = 18
		refs = "0007 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
		altNames = "?getGuardNumber@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 6A 00 FF 74 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 59 59 C3 }
	condition:
		$1
}

rule file_453_114_0 {
	meta:
		name = "?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 366
		refs = "000d ??0DName@@QAE@ABV0@@Z 0015 ?isValid@DName@@QBEHXZ 0022 ?gName@UnDecorator@@0PBDB 0034 ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ 004b ??HDName@@QBE?AV0@D@Z 0052 ??HDName@@QBE?AV0@ABV0@@Z 005b ??4DName@@QAEAAV0@ABV0@@Z 007e ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 009e ?getScope@UnDecorator@@CA?AVDName@@XZ 00aa ??H@YA?AVDName@@DABV0@@Z 00bd ??YDName@@QAEAAV0@ABV0@@Z 00e5 ??_C@_02MDINNEEG@s?5?$AA@ 00ed ??YDName@@QAEAAV0@PBD@Z 0116 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0120 ??YDName@@QAEAAV0@D@Z 014d ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 FF 75 0C 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 84 15 01 00 00 A1 ?? ?? ?? ?? 80 38 00 0F 84 07 01 00 00 8D 45 F0 50 E8 ?? ?? ?? ?? 59 8D 45 F8 50 8D 45 E8 50 6A 20 8D 45 E0 50 8D 4D F0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 84 EE 00 00 00 A1 ?? ?? ?? ?? 80 38 40 0F 84 B1 00 00 00 68 ?? ?? ?? ?? EB 65 A1 ?? ?? ?? ?? 8A 00 84 C0 74 6E 3C 40 74 6A 6A 27 8D 45 E0 50 8D 45 E8 50 E8 ?? ?? ?? ?? 50 8D 45 F0 6A 60 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 80 3A 40 75 07 42 89 15 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 12 80 3A 40 74 0D 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 87 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 1B A1 ?? ?? ?? ?? 80 38 00 75 07 6A 02 E8 ?? ?? ?? ?? 6A 7D 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 75 2F FF 05 ?? ?? ?? ?? EB 27 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 1B 8D 45 F8 50 8D 45 E0 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_115_0 {
	meta:
		name = "?getStringEncoding@UnDecorator@@CA?AVDName@@PADH@Z"
		size = 160
		refs = "000d ??0DName@@QAE@PBD@Z 0012 ?gName@UnDecorator@@0PBDB 0040 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 008b ??0DName@@QAE@ABV0@@Z 0097 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 FF 05 ?? ?? ?? ?? 3C 40 75 6F A1 ?? ?? ?? ?? 8A 00 FF 05 ?? ?? ?? ?? 3C 5F 75 5E FF 05 ?? ?? ?? ?? 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 08 83 C4 10 84 C9 74 16 80 F9 40 74 0C 40 A3 ?? ?? ?? ?? 8A 08 84 C9 75 EF 80 38 00 75 0A 48 A3 ?? ?? ?? ?? 6A 02 EB 16 8B 4D 08 40 A3 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? EB 0A 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_116_0 {
	meta:
		name = "?getSignedDimension@UnDecorator@@CA?AVDName@@XZ"
		size = 80
		refs = "0006 ?gName@UnDecorator@@0PBDB 0016 ??0DName@@QAE@W4DNameStatus@@@Z 002d ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0038 ??H@YA?AVDName@@DABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 00 84 C0 75 0C 8B 4D 08 6A 02 E8 ?? ?? ?? ?? EB 2F 3C 3F 6A 00 75 1F FF 05 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 50 6A 2D FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 EB 0A FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_117_0 {
	meta:
		name = "?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ"
		size = 664
		refs = "000c ___security_cookie 0014 ?gName@UnDecorator@@0PBDB 0059 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 006c ?isValid@DName@@QBEHXZ 0092 ?getString@DName@@QBEPADPADH@Z 00cd ??0DName@@QAE@PBD@Z 00d4 ??HDName@@QBE?AV0@D@Z 00eb ??_C@_04HIBGFPH@NULL?$AA@ 00f9 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0106 ??_C@_01HNPIGOCE@?$CG?$AA@ 0112 ??HDName@@QBE?AV0@ABV0@@Z 0161 ?disableFlags@UnDecorator@@0KA 017c _atol 0183 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 019f ??_C@_01GEODFPGF@?8?$AA@ 01ad ??_C@_0BE@EODMJLIF@?$GAtemplate?9parameter?$AA@ 01b7 ??_C@_0BN@IBLMMFAP@?$GAnon?9type?9template?9parameter?$AA@ 01c0 ??H@YA?AVDName@@PBDABV0@@Z 01ca ??HDName@@QBE?AV0@PBD@Z 01d9 ??0DName@@QAE@D@Z 01f6 ??YDName@@QAEAAV0@ABV0@@Z 0200 ??YDName@@QAEAAV0@D@Z 0277 ??0DName@@QAE@W4DNameStatus@@@Z 028f @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC D0 00 00 00 A1 ?? ?? ?? ?? 89 45 70 A1 ?? ?? ?? ?? 53 8A 18 FF 05 ?? ?? ?? ?? 56 0F BE F3 83 FE 44 0F 8F 07 01 00 00 0F 84 22 01 00 00 83 EE 00 0F 84 EB 00 00 00 83 EE 30 0F 84 D5 00 00 00 4E 0F 84 8D 00 00 00 4E 0F 85 1D 02 00 00 8D 45 F4 50 E8 ?? ?? ?? ?? 8D 45 68 50 E8 ?? ?? ?? ?? 59 59 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 0F 84 B6 00 00 00 8D 4D 68 E8 ?? ?? ?? ?? 85 C0 0F 84 A6 00 00 00 6A 64 8D 45 FD 50 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 0F 84 D3 01 00 00 8A 45 FD 3C 2D 88 45 FC 75 0C 8A 45 FE 88 45 FD C6 45 FE 2E EB 04 C6 45 FD 2E 8D 45 68 50 FF 75 7C 8D 45 CC 6A 65 50 8D 45 FC 50 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 35 A1 ?? ?? ?? ?? 80 38 40 75 10 FF 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 9A 00 00 00 8D 45 DC 50 E8 ?? ?? ?? ?? 59 50 FF 75 7C 8D 4D BC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 6B 01 00 00 FF 75 7C E8 ?? ?? ?? ?? E9 5D 01 00 00 FF 0D ?? ?? ?? ?? 6A 02 E9 3E 01 00 00 83 FE 45 0F 84 3F 01 00 00 0F 8E 2D 01 00 00 83 FE 4A 0F 8E 86 00 00 00 83 FE 51 0F 85 1B 01 00 00 8D 45 F4 50 E8 ?? ?? ?? ?? F6 05 ?? ?? ?? ?? 40 59 74 32 6A 10 8D 45 60 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 45 60 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 59 59 74 0E 50 8B 4D 7C E8 ?? ?? ?? ?? E9 EB 00 00 00 80 FB 44 68 ?? ?? ?? ?? FF 75 7C 8D 45 F4 50 75 0A 68 ?? ?? ?? ?? 8D 45 EC EB 08 68 ?? ?? ?? ?? 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? E9 B3 00 00 00 6A 7B 8D 4D F4 E8 ?? ?? ?? ?? 80 FB 48 7C 22 80 FB 4A 7F 1D 8D 45 E4 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 2C 8D 4D F4 E8 ?? ?? ?? ?? 83 EE 46 74 29 4E 74 09 4E 74 40 4E 74 20 4E 75 4D 8D 45 D4 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 2C 8D 4D F4 E8 ?? ?? ?? ?? 8D 45 C4 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 2C 8D 4D F4 E8 ?? ?? ?? ?? 8D 45 B4 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 7D FF 75 7C 8D 4D F4 E8 ?? ?? ?? ?? EB 15 6A 01 8B 4D 7C E8 ?? ?? ?? ?? EB 09 FF 75 7C E8 ?? ?? ?? ?? 59 8B 4D 70 8B 45 7C 5E 5B E8 ?? ?? ?? ?? 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_453_118_0 {
	meta:
		name = "?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z"
		size = 191
		refs = "0006 ?gName@UnDecorator@@0PBDB 0028 ?isEmpty@DName@@QBEHXZ 0034 ??_C@_04GKJNKENE@void?$AA@ 0039 ??0DName@@QAE@PBD@Z 0041 ??_C@_05BEFAKPML@void?5?$AA@ 0049 ??H@YA?AVDName@@PBDABV0@@Z 0060 ?getArrayType@UnDecorator@@CA?AVDName@@ABV2@@Z 0084 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 008a ??_C@_06FAHNNMP@__box?5?$AA@ 00b3 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 96 00 00 00 83 7D 10 00 74 35 3C 58 75 31 8B 4D 0C FF 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0F 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 7B 51 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? EB 68 3C 59 75 13 FF 75 0C FF 05 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? EB 40 3C 5F 75 31 A1 ?? ?? ?? ?? 80 78 01 5A 75 26 FF 75 0C 83 05 ?? ?? ?? ?? 02 8D 45 F8 50 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 EB 1F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 10 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_119_0 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 20
		refs = "0009 ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 59 59 C3 }
	condition:
		$1
}

rule file_453_120_0 {
	meta:
		name = "?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 442
		refs = "0007 ___security_cookie 002a ?fGetTemplateArgumentList@UnDecorator@@0_NA 0037 ?gName@UnDecorator@@0PBDB 005e ??YDName@@QAEAAV0@D@Z 007a ?pTemplateArgList@UnDecorator@@0PAVReplicator@@A 0084 ??AReplicator@@QBEABVDName@@H@Z 00a1 ??_C@_04GKJNKENE@void?$AA@ 00bb ?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ 00ce ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 00d4 ?disableFlags@UnDecorator@@0KA 00e6 ?getString@DName@@QBEPADPADH@Z 00ef _atol 00f6 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0105 ??4DName@@QAEAAV0@PBD@Z 010c ??_C@_01GEODFPGF@?8?$AA@ 012e ??_C@_0BE@EODMJLIF@?$GAtemplate?9parameter?$AA@ 0134 ??H@YA?AVDName@@PBDABV0@@Z 013e ??HDName@@QBE?AV0@PBD@Z 0153 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 015e ??4DName@@QAEAAV0@ABV0@@Z 017e ??YReplicator@@QAEAAV0@ABVDName@@@Z 018a ??YDName@@QAEAAV0@ABV0@@Z 01a7 ??0DName@@QAE@ABV0@@Z 01b4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 68 A1 ?? ?? ?? ?? 53 56 BE 00 FE FF FF 21 75 E0 33 DB F6 45 E0 0F 89 45 FC C7 45 D8 01 00 00 00 89 5D DC C6 05 ?? ?? ?? ?? 01 0F 85 64 01 00 00 57 A1 ?? ?? ?? ?? 8A 08 3A CB 0F 84 53 01 00 00 80 F9 40 0F 84 4A 01 00 00 39 5D D8 74 05 89 5D D8 EB 0F 6A 2C 8D 4D DC E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 10 0F BE CA 83 E9 30 78 1C 83 F9 09 7F 17 40 51 8B 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 F8 00 00 00 21 75 E8 80 FA 58 8B F8 89 5D E4 75 0D 40 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 5A 80 FA 24 75 18 40 38 10 74 13 A3 ?? ?? ?? ?? 8D 45 C0 50 E8 ?? ?? ?? ?? E9 94 00 00 00 80 FA 3F 75 7B 8D 45 C8 50 E8 ?? ?? ?? ?? F6 05 ?? ?? ?? ?? 40 59 74 41 6A 10 8D 45 EC 50 8D 4D C8 E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 3B C3 59 59 74 0B 50 8D 4D E4 E8 ?? ?? ?? ?? EB 57 68 ?? ?? ?? ?? 8D 45 98 50 8D 45 C8 50 8D 45 B0 EB 10 68 ?? ?? ?? ?? 8D 45 A0 50 8D 45 C8 50 8D 45 B8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? EB 15 21 75 D4 8D 45 D0 50 8D 45 A8 50 89 5D D0 E8 ?? ?? ?? ?? 59 59 8D 4D E4 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B C7 83 F8 01 7E 14 8B 0D ?? ?? ?? ?? 83 39 09 74 09 8D 45 E4 50 E8 ?? ?? ?? ?? 8D 45 E4 8D 4D DC 50 E8 ?? ?? ?? ?? F6 45 E0 0F 0F 84 9E FE FF FF 5F 8B 4D 08 8D 45 DC 50 88 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC 8B 45 08 5E 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_453_121_0 {
	meta:
		name = "?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z"
		size = 1242
		refs = "000a ?gName@UnDecorator@@0PBDB 0063 _nameTable 007f ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 008e ??H@YA?AVDName@@DABV0@@Z 009a ??YDName@@QAEAAV0@ABV0@@Z 00a2 ?getLastChar@DName@@QBEDXZ 00b0 ??YDName@@QAEAAV0@D@Z 00e7 ?getZName@UnDecorator@@CA?AVDName@@_N@Z 00f2 ??4DName@@QAEAAV0@ABV0@@Z 0100 ?isEmpty@DName@@QBEHXZ 01ee ??_C@_0BG@JNJLAMPM@?$GAanonymous?5namespace?8?$AA@ 021c ??_C@_08OBABFOLI@?$GAstring?8?$AA@ 0225 ?getStringEncoding@UnDecorator@@CA?AVDName@@PADH@Z 0247 ??4DName@@QAEAAV0@PBD@Z 0252 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 02bd ??0DName@@QAE@W4DNameStatus@@@Z 02e4 _rttiTable 032e ??HDName@@QBE?AV0@ABV0@@Z 033d ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 0345 ??HDName@@QBE?AV0@D@Z 039e ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 03cc ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 0426 ??_C@_08LHJFAFGD@operator?$AA@ 042c ??H@YA?AVDName@@PBDABV0@@Z 0444 ??0DName@@QAE@ABV0@@Z 049d ??0DName@@QAE@PBD@Z"
	strings:
		$1 = { 55 8B EC 81 EC 90 00 00 00 A1 ?? ?? ?? ?? 0F BE 10 53 33 DB B9 00 FE FF FF 21 4D FC 21 4D F4 56 33 F6 40 83 FA 41 89 5D F8 89 5D F0 A3 ?? ?? ?? ?? 0F 8F 20 01 00 00 0F 84 69 04 00 00 3B D3 0F 84 05 01 00 00 83 FA 2F 0F 8E 69 02 00 00 83 FA 31 7E 19 83 FA 39 0F 8F 5B 02 00 00 0F BE 40 FF FF 34 85 ?? ?? ?? ?? E9 9E 03 00 00 21 4D F4 38 5D 0C 89 5D F0 74 68 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 50 8D 85 70 FF FF FF 6A 3C 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 3C 3E 75 0A 6A 20 8D 4D F0 E8 ?? ?? ?? ?? 6A 3E 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 10 3B C3 74 03 C6 00 01 A1 ?? ?? ?? ?? 38 18 75 08 8D 45 F0 E9 66 03 00 00 40 A3 ?? ?? ?? ?? 8B F0 8D 45 C8 53 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 21 80 7E FF 31 75 1B 8D 45 F8 50 8D 45 98 6A 7E 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 0F 85 03 03 00 00 8D 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? E9 F2 02 00 00 48 A3 ?? ?? ?? ?? 6A 02 E9 62 01 00 00 83 FA 42 0F 84 43 03 00 00 0F 8E 51 01 00 00 83 FA 5A 0F 8E 37 03 00 00 83 FA 5F 0F 85 3F 01 00 00 0F BE 08 40 83 F9 50 A3 ?? ?? ?? ?? 0F 8F 02 01 00 00 0F 84 A8 00 00 00 83 F9 3F 7F 5F 74 3B 3B CB 74 AF 83 F9 2F 0F 8E 13 01 00 00 83 F9 36 7E 19 83 F9 39 0F 8F 05 01 00 00 0F BE 40 FF FF 34 85 ?? ?? ?? ?? E9 D7 02 00 00 0F BE 40 FF FF 34 85 ?? ?? ?? ?? E9 38 02 00 00 0F BE 08 40 3B CB A3 ?? ?? ?? ?? 0F 84 67 FF FF FF 83 F9 30 0F 85 CB 00 00 00 53 68 ?? ?? ?? ?? EB 2C 83 F9 41 0F 8C BA 00 00 00 83 F9 42 0F 8E 88 02 00 00 83 F9 43 74 0E 0F 8E A6 00 00 00 83 F9 4F E9 98 00 00 00 6A 01 68 ?? ?? ?? ?? 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 0C 80 4D ED 01 8D 45 E8 E9 07 02 00 00 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 53 8D 45 B8 53 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 75 0F E8 ?? ?? ?? ?? 85 C0 75 06 F6 45 F4 40 75 3A 8D 45 F0 50 FF 75 08 8D 4D F8 E9 6C 01 00 00 83 F9 56 0F 8F BA 01 00 00 83 F9 55 0F 8D 61 01 00 00 83 F9 51 0F 84 6B 01 00 00 83 F9 52 74 1A 7E 09 83 F9 54 0F 8E D7 01 00 00 6A 01 8B 4D 08 E8 ?? ?? ?? ?? E9 82 01 00 00 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 00 FF 34 85 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 00 FF 05 ?? ?? ?? ?? 83 F8 30 0F 84 BF 00 00 00 83 F8 31 74 16 7E 09 83 F8 34 0F 8E 66 FF FF FF FF 0D ?? ?? ?? ?? E9 2E FE FF FF 8D 45 F0 50 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 6A 2C 8D 45 D8 50 8D 45 A8 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 6A 2C 8D 45 88 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 6A 2C 8D 45 C0 50 8D 45 B0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 6A 29 8D 45 A0 50 8D 45 90 53 50 E8 ?? ?? ?? ?? 59 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E8 E8 ?? ?? ?? ?? 6A 27 FF 75 08 8D 4D E8 E8 ?? ?? ?? ?? E9 82 00 00 00 8D 45 E8 53 50 E8 ?? ?? ?? ?? 59 59 8D 45 F0 50 FF 75 08 8D 45 F8 50 8D 45 80 50 6A 20 8D 45 E0 50 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 49 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 1E 8D 45 F8 50 8D 45 E0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 8B 4D 08 50 E8 ?? ?? ?? ?? 8B 45 08 5E 5B C9 C3 83 F9 58 0F 8C 5F FE FF FF 83 F9 59 7E 31 83 F9 5F 0F 85 51 FE FF FF 0F BE 08 40 83 F9 41 A3 ?? ?? ?? ?? 0F 8C 3F FE FF FF 83 F9 44 0F 8F 36 FE FF FF 0F BE 40 FF FF 34 85 ?? ?? ?? ?? EB 0B 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? EB A5 33 F6 46 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 3B F3 0F 84 51 FF FF FF 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 85 6B FF FF FF 83 4D FC 20 E9 62 FF FF FF }
	condition:
		$1
}

rule file_453_122_0 {
	meta:
		name = "?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z"
		size = 338
		refs = "000c ?gName@UnDecorator@@0PBDB 0026 ?pTemplateArgList@UnDecorator@@0PAVReplicator@@A 002d ?pArgList@UnDecorator@@0PAVReplicator@@A 0036 ?pZNameList@UnDecorator@@0PAVReplicator@@A 0043 ??0Replicator@@QAE@XZ 0098 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 00a8 ?getZName@UnDecorator@@CA?AVDName@@_N@Z 00b3 ??4DName@@QAEAAV0@ABV0@@Z 00bb ?isEmpty@DName@@QBEHXZ 00c5 ?fExplicitTemplateParams@UnDecorator@@0_NA 00d5 ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 00e1 ??H@YA?AVDName@@DABV0@@Z 00ed ??YDName@@QAEAAV0@ABV0@@Z 00f5 ?getLastChar@DName@@QBEDXZ 0103 ??YDName@@QAEAAV0@D@Z 0137 ??0DName@@QAE@ABV0@@Z 0146 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8D 6C 24 90 81 EC D0 00 00 00 A1 ?? ?? ?? ?? 80 38 3F 0F 85 27 01 00 00 80 78 01 24 0F 85 1D 01 00 00 53 8B 1D ?? ?? ?? ?? 56 8B 35 ?? ?? ?? ?? 40 40 57 8B 3D ?? ?? ?? ?? 8D 4D DC A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D 18 E8 ?? ?? ?? ?? 8D 4D A0 E8 ?? ?? ?? ?? 83 65 64 00 66 81 65 68 00 FE 8D 45 DC A3 ?? ?? ?? ?? 8D 45 18 A3 ?? ?? ?? ?? 8D 45 A0 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 3F C6 45 6F 00 75 1A FF 05 ?? ?? ?? ?? 8D 45 6F 50 8D 45 5C 6A 01 50 E8 ?? ?? ?? ?? 83 C4 0C EB 0D 8D 45 5C 6A 01 50 E8 ?? ?? ?? ?? 59 59 8D 4D 64 50 E8 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? 85 C0 74 07 C6 05 ?? ?? ?? ?? 01 80 7D 6F 00 75 4D 8D 45 5C 50 E8 ?? ?? ?? ?? 50 8D 45 54 6A 3C 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D 64 E8 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? 3C 3E 75 0A 6A 20 8D 4D 64 E8 ?? ?? ?? ?? 6A 3E 8D 4D 64 E8 ?? ?? ?? ?? 80 7D 7C 00 74 06 FF 05 ?? ?? ?? ?? 8B 4D 78 8D 45 64 50 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B EB 0A 8B 4D 78 6A 01 E8 ?? ?? ?? ?? 8B 45 78 83 C5 70 C9 C3 }
	condition:
		$1
}

rule file_453_123_0 {
	meta:
		name = "?getZName@UnDecorator@@CA?AVDName@@_N@Z"
		size = 475
		refs = "0007 ___security_cookie 000f ?gName@UnDecorator@@0PBDB 0026 ?pZNameList@UnDecorator@@0PAVReplicator@@A 0030 ??AReplicator@@QBEABVDName@@H@Z 004f ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 005a ??4DName@@QAEAAV0@ABV0@@Z 0087 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0094 ??_C@_0BE@JAEOCHPE@template?9parameter?9?$AA@ 00c1 ??_C@_0O@KHGCOMHP@generic?9type?9?$AA@ 00fb ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 0101 ?disableFlags@UnDecorator@@0KA 0113 ?getString@DName@@QBEPADPADH@Z 011c _atol 0123 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0132 ??4DName@@QAEAAV0@PBD@Z 0139 ??_C@_01NLNLIGKH@?$GA?$AA@ 0143 ??_C@_01GEODFPGF@?8?$AA@ 0155 ??H@YA?AVDName@@PBDABV0@@Z 015f ??HDName@@QBE?AV0@PBD@Z 0168 ??YDName@@QAEAAV0@ABV0@@Z 0198 ??0DName@@QAE@AAPBDD@Z 01be ??YReplicator@@QAEAAV0@ABVDName@@@Z 01ca ??0DName@@QAE@ABV0@@Z 01d5 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 89 45 FC A1 ?? ?? ?? ?? 8A 10 0F BE CA 83 E9 30 78 1C 83 F9 09 7F 17 40 51 8B 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 8C 01 00 00 83 65 E4 00 66 81 65 E8 00 FE 80 FA 3F 75 48 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D E4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 08 40 80 F9 40 A3 ?? ?? ?? ?? 0F 84 34 01 00 00 48 33 C9 A3 ?? ?? ?? ?? 38 08 0F 94 C1 41 51 8D 4D E4 E8 ?? ?? ?? ?? E9 18 01 00 00 53 56 57 B9 ?? ?? ?? ?? 6A 12 8B F9 8B F0 5B 8A 16 84 D2 74 09 3A 17 75 05 46 47 4B 75 F1 0F B6 16 0F B6 37 2B D6 89 55 E0 75 05 83 C0 13 EB 2F B9 ?? ?? ?? ?? 6A 0C 8B F9 8B F0 5B 8A 16 84 D2 74 09 3A 17 75 05 46 47 4B 75 F1 0F B6 17 0F B6 36 2B F2 89 75 E0 0F 85 A1 00 00 00 83 C0 0D A3 ?? ?? ?? ?? 8D 45 DC 50 8B F1 E8 ?? ?? ?? ?? F6 05 ?? ?? ?? ?? 40 59 74 65 6A 10 8D 45 EC 50 8D 4D DC E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 59 59 8D 4D E4 74 08 50 E8 ?? ?? ?? ?? EB 6D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 CC 50 8D 45 DC 50 8D 45 D4 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? EB 37 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D4 50 8D 45 DC 50 8D 45 CC EB C5 6A 40 68 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? 5F 5E 5B 80 7D 0C 00 74 14 8B 0D ?? ?? ?? ?? 83 39 09 74 09 8D 45 E4 50 E8 ?? ?? ?? ?? 8D 45 E4 8B 4D 08 50 E8 ?? ?? ?? ?? 8B 4D FC 8B 45 08 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_453_124_0 {
	meta:
		name = "?getScopedName@UnDecorator@@CA?AVDName@@XZ"
		size = 252
		refs = "0018 ?getZName@UnDecorator@@CA?AVDName@@_N@Z 0023 ??4DName@@QAEAAV0@ABV0@@Z 002d ??_C@_02MOLJINC@?3?3?$AA@ 0035 ?gName@UnDecorator@@0PBDB 0056 ?getScope@UnDecorator@@CA?AVDName@@XZ 005e ??HDName@@QBE?AV0@PBD@Z 0065 ??HDName@@QBE?AV0@ABV0@@Z 00ab ?isEmpty@DName@@QBEHXZ 00b6 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 00cf ??0DName@@QAE@W4DNameStatus@@@Z 00f2 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 F8 00 66 81 65 FC 00 FE 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 FC A8 0F BE ?? ?? ?? ?? 75 42 8B 0D ?? ?? ?? ?? 8A 09 84 C9 74 36 80 F9 40 74 3E 8D 45 F8 50 8D 45 F0 50 56 8D 45 E8 50 8D 45 E0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 FC 8B 0D ?? ?? ?? ?? 8A 09 80 F9 40 75 08 FF 05 ?? ?? ?? ?? EB 60 84 C9 74 19 83 65 F8 00 8B C8 83 E1 0F 80 F9 03 74 4E 83 E0 F1 83 C8 01 89 45 FC EB 43 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 09 6A 02 E8 ?? ?? ?? ?? EB 2E 8D 45 F8 50 8D 45 E0 50 56 8D 45 E8 50 6A 02 8D 4D F0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 5E C9 C3 }
	condition:
		$1
}

rule file_453_126_0 {
	meta:
		name = "?getECSUDataType@UnDecorator@@CA?AVDName@@XZ"
		size = 255
		refs = "0007 ?disableFlags@UnDecorator@@0KA 0023 ?gName@UnDecorator@@0PBDB 005a ??_C@_0N@DLIEFKNA@cointerface?5?$AA@ 0061 ??_C@_08KOFANOFK@coclass?5?$AA@ 006e ?getEnumType@UnDecorator@@CA?AVDName@@XZ 0077 ??_C@_05LJGMCFOG@enum?5?$AA@ 007d ??H@YA?AVDName@@PBDABV0@@Z 0089 ??4DName@@QAEAAV0@ABV0@@Z 0090 ??_C@_06LJBABKPM@class?5?$AA@ 0097 ??_C@_07DIBCDNGL@struct?5?$AA@ 009e ??_C@_06MOJHIBMG@union?5?$AA@ 00a6 ??4DName@@QAEAAV0@PBD@Z 00c6 ?getScopedName@UnDecorator@@CA?AVDName@@XZ 00d3 ??YDName@@QAEAAV0@ABV0@@Z 00df ??0DName@@QAE@ABV0@@Z 00ef ??_C@_0P@GCIFDJCJ@?$GAunknown?5ecsu?8?$AA@ 00f4 ??0DName@@QAE@PBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 53 8B C8 C1 E9 0F 33 DB F7 D1 43 23 CB 56 74 05 F6 C4 10 74 02 33 DB A1 ?? ?? ?? ?? 0F BE 00 83 65 F8 00 BE 00 FE FF FF 21 75 FC FF 05 ?? ?? ?? ?? 83 E8 00 0F 84 A0 00 00 00 83 E8 54 74 53 48 74 49 48 74 3F 48 74 14 48 74 0A 48 75 51 68 ?? ?? ?? ?? EB 42 68 ?? ?? ?? ?? EB 3B 8D 45 F0 50 8B D9 E8 ?? ?? ?? ?? 50 8D 45 E8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F8 E8 ?? ?? ?? ?? EB 1B 68 ?? ?? ?? ?? EB 0C 68 ?? ?? ?? ?? EB 05 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 83 65 F0 00 21 75 F4 85 DB 74 0C 8D 45 F8 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 8D 45 F8 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F0 50 E8 ?? ?? ?? ?? EB 13 8B 4D 08 FF 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 5E 5B C9 C3 }
	condition:
		$1
}

rule file_453_127_0 {
	meta:
		name = "?getSymbolName@UnDecorator@@CA?AVDName@@XZ"
		size = 70
		refs = "0004 ?gName@UnDecorator@@0PBDB 0019 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 002c ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 003b ?getZName@UnDecorator@@CA?AVDName@@_N@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 80 38 3F 75 28 40 80 38 24 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? EB 20 6A 00 6A 00 FF 75 08 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_453_128_0 {
	meta:
		name = "?getBasedType@UnDecorator@@CA?AVDName@@XZ"
		size = 146
		refs = "0009 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0015 ??0DName@@QAE@PBD@Z 001a ?gName@UnDecorator@@0PBDB 0040 ??0DName@@QAE@W4DNameStatus@@@Z 004b ?getScopedName@UnDecorator@@CA?AVDName@@XZ 0055 ??YDName@@QAEAAV0@ABV0@@Z 005c ??_C@_04GKJNKENE@void?$AA@ 0064 ??YDName@@QAEAAV0@PBD@Z 0070 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0075 ??_C@_02KCKGHPCA@?$CJ?5?$AA@ 0089 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 74 47 0F BE 08 40 83 E9 30 A3 ?? ?? ?? ?? 74 2A 49 49 74 11 83 E9 03 75 3A 8B 4D 08 6A 01 E8 ?? ?? ?? ?? EB 47 8D 45 F0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? EB 19 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 0A 6A 02 8D 4D F8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_129_0 {
	meta:
		name = "?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 2580
		refs = "0015 ?getTypeEncoding@UnDecorator@@CAHXZ 001f ?isUDC@DName@@QBEHXZ 0034 ??0DName@@QAE@W4DNameStatus@@@Z 004e ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 0069 ??0DName@@QAE@ABV0@@Z 0101 ?disableFlags@UnDecorator@@0KA 011e ?getBasedType@UnDecorator@@CA?AVDName@@XZ 012a ??H@YA?AVDName@@DABV0@@Z 0136 ??4DName@@QAEAAV0@ABV0@@Z 014b ??_5DName@@QAEAAV0@ABV0@@Z 0182 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 01a0 ??HDName@@QBE?AV0@D@Z 01a7 ??HDName@@QBE?AV0@ABV0@@Z 01b7 ??YDName@@QAEAAV0@ABV0@@Z 01bc ??_C@_03OPGICMGF@?$HN?8?5?$AA@ 01c9 ?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ 01d1 ??HDName@@QBE?AV0@PBD@Z 020a ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 02d9 ?getThisType@UnDecorator@@CA?AVDName@@XZ 034c ?isEmpty@DName@@QBEHXZ 03a2 ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 03ab ??_C@_01CLKCMJKC@?5?$AA@ 03b1 ??H@YA?AVDName@@PBDABV0@@Z 03d2 _heap 03d7 ?getMemory@HeapManager@@QAEPAXIH@Z 0439 ??_C@_0L@GHPFDFH@?$GAvtordisp?$HL?$AA@ 0459 ??_C@_0L@HNGCOGAE@?$GAadjustor?$HL?$AA@ 0461 ??YDName@@QAEAAV0@PBD@Z 048a ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 04de ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ 0559 ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z 058c ??_C@_02IGFCGPIL@?$HN?8?$AA@ 05d0 ?getVdispMapType@UnDecorator@@CA?AVDName@@ABV2@@Z 0629 ??_C@_0CB@KJDOOODE@?$GAlocal?5static?5destructor?5helper?8@ 0687 ??_C@_0DB@ILEFOCIJ@?$GAtemplate?5static?5data?5member?5con@ 06da ??_C@_0DA@HGFJFBBE@?$GAtemplate?5static?5data?5member?5des@ 0779 ?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0806 ??_C@_07PGOEDBHP@static?5?$AA@ 08b3 ??_C@_08NIEOINHE@virtual?5?$AA@ 091c ??_C@_09LAPHOOG@private?3?5?$AA@ 095e ??_C@_0M@GAIFPFIP@protected?3?5?$AA@ 0999 ??_C@_08GPDDCMKI@public?3?5?$AA@ 09ea ??_C@_08KJLFOPNE@?$FLthunk?$FN?3?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 40 83 65 E0 00 56 57 BF 00 FE FF FF 21 7D E4 E8 ?? ?? ?? ?? 8B 4D 0C 8B F0 E8 ?? ?? ?? ?? 81 FE FF FF 00 00 89 45 EC 75 0F 8B 4D 08 6A 01 E8 ?? ?? ?? ?? E9 D0 09 00 00 81 FE FE FF 00 00 75 15 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 B3 09 00 00 81 FE FD FF 00 00 75 10 FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? E9 9B 09 00 00 89 75 FC 81 65 FC 00 80 00 00 53 BB 00 08 00 00 B9 00 10 00 00 0F 84 9D 04 00 00 33 C0 89 75 F4 81 65 F4 00 18 00 00 39 5D F4 0F 94 C0 89 45 F8 83 7D F8 00 8B C6 74 07 25 00 04 00 00 EB 02 23 C1 85 C0 74 0F 8B C6 25 00 1B 00 00 3B C1 0F 84 64 04 00 00 83 7D F8 00 8B C6 74 07 25 00 04 00 00 EB 02 23 C1 85 C0 74 1D 8B C6 25 00 1B 00 00 3D 00 11 00 00 0F 84 3D 04 00 00 3D 00 12 00 00 0F 84 32 04 00 00 F7 C6 00 40 00 00 74 4F A1 ?? ?? ?? ?? 8B C8 D1 E9 F7 D1 F6 C1 01 74 2C C1 E8 03 F7 D0 A8 01 74 23 8D 45 C8 50 E8 ?? ?? ?? ?? 50 8D 45 D0 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D E0 E8 ?? ?? ?? ?? EB 13 8D 45 C8 50 E8 ?? ?? ?? ?? 59 50 8D 4D E0 E8 ?? ?? ?? ?? 83 7D F8 00 BB 00 10 00 00 8B C6 74 07 25 00 04 00 00 EB 02 23 C3 33 C9 3B C1 0F 84 D9 00 00 00 81 7D F4 00 18 00 00 0F 85 CC 00 00 00 51 8D 45 C8 50 E8 ?? ?? ?? ?? 59 59 8B 4D 0C 6A 2C 8D 45 D0 50 8D 45 C8 50 8D 45 D8 50 6A 7B 8D 45 E8 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B C8 D1 E9 F7 D1 F6 C1 01 74 42 C1 E8 04 F7 D0 A8 01 74 39 8D 45 E0 50 8D 45 C8 50 6A 20 8D 45 D0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 50 8D 45 E8 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 4F 05 00 00 8D 45 C8 50 E8 ?? ?? ?? ?? 59 50 8D 4D E0 E8 ?? ?? ?? ?? E9 40 05 00 00 21 7D DC 21 7D D4 21 7D F4 39 4D F8 89 4D D8 89 4D D0 89 4D F0 8B C6 74 07 25 00 04 00 00 EB 02 23 C3 3B C1 74 47 39 4D F8 74 27 8B C6 25 00 07 00 00 3D 00 05 00 00 75 19 8D 45 C8 6A 01 50 E8 ?? ?? ?? ?? 59 59 8D 45 C8 50 8D 4D D8 E8 ?? ?? ?? ?? 8D 45 C8 6A 01 50 E8 ?? ?? ?? ?? 59 59 8D 45 C8 50 8D 4D D0 E8 ?? ?? ?? ?? 33 C9 39 4D F8 74 3E 8B C6 25 00 07 00 00 3D 00 02 00 00 74 30 A1 ?? ?? ?? ?? 83 E0 60 3C 60 8D 45 C8 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B C8 D1 E9 F7 D1 F6 C1 01 74 2D C1 E8 04 F7 D0 A8 01 74 24 8D 45 E0 50 8D 45 C8 50 8D 45 C0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E0 E8 ?? ?? ?? ?? EB 13 8D 45 C0 50 E8 ?? ?? ?? ?? 59 8D 4D E0 50 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 3B 8D 4D E0 E8 ?? ?? ?? ?? 85 C0 75 24 85 1D ?? ?? ?? ?? 75 1C FF 75 0C 8D 45 C0 6A 20 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E0 E8 ?? ?? ?? ?? EB 0B FF 75 0C 8D 4D E0 E8 ?? ?? ?? ?? 21 7D CC 33 DB 39 5D EC 89 5D C8 53 74 32 8D 45 C0 50 E8 ?? ?? ?? ?? 50 8D 45 E8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 14 50 8D 4D E0 E8 ?? ?? ?? ?? F6 05 ?? ?? ?? ?? 10 74 36 E9 31 06 00 00 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 83 20 00 21 78 04 8B D8 EB 02 33 DB 8D 45 C0 53 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D C8 E8 ?? ?? ?? ?? 8B 7D F8 85 FF 8B C6 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 74 66 85 FF 74 3B 8B C6 25 00 07 00 00 3D 00 05 00 00 75 2D 6A 2C 8D 45 C0 50 8D 45 D8 50 8D 45 E8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E0 E8 ?? ?? ?? ?? EB 0D 68 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C0 50 8D 4D D0 E8 ?? ?? ?? ?? 50 8D 4D E0 E8 ?? ?? ?? ?? 6A 29 8D 45 C0 50 8D 45 D0 50 E8 ?? ?? ?? ?? 50 8D 45 D8 6A 28 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E0 E8 ?? ?? ?? ?? 85 FF 74 1A 8B C6 25 00 07 00 00 3D 00 02 00 00 74 0C 8D 45 F0 50 8D 4D E0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 F7 D0 A8 01 8D 45 C0 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D E0 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D E0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 02 F7 D0 A8 01 0F 84 79 02 00 00 85 DB 0F 84 71 02 00 00 8D 45 E0 50 8B CB E8 ?? ?? ?? ?? 8D 45 C8 E9 55 02 00 00 FF 75 0C 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 FC 85 C0 B9 00 7C 00 00 0F 85 9A 00 00 00 8B D6 23 D1 81 FA 00 68 00 00 75 0E 8D 45 E0 50 FF 75 08 E8 ?? ?? ?? ?? EB 75 85 C0 75 7C 8B D6 23 D1 81 FA 00 70 00 00 74 E2 85 C0 75 6C 8B D6 23 D1 81 FA 00 60 00 00 75 3D 50 8D 45 C8 50 E8 ?? ?? ?? ?? 59 59 68 ?? ?? ?? ?? FF 75 08 8D 45 C8 50 8D 45 C0 50 6A 7B 8D 45 D0 50 8D 4D E0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 50 04 00 00 85 C0 75 1F 8B D6 23 D1 3B D1 75 13 8D 45 E0 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 31 04 00 00 85 C0 74 0B 8B C6 25 00 18 00 00 2B C3 EB 07 8B C6 25 00 60 00 00 F7 D8 1B C0 40 85 C0 BF 00 10 00 00 8B C6 74 07 25 00 04 00 00 EB 02 23 C7 85 C0 74 2C 8B 45 FC 8B D6 81 E2 00 1B 00 00 2B D7 F7 DA 1B D2 42 F7 D8 1B C0 85 C2 74 12 68 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? E9 BE 00 00 00 83 7D FC 00 8B C6 74 09 25 00 18 00 00 2B C3 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C6 74 07 25 00 04 00 00 EB 02 23 C7 85 C0 74 25 8B 45 FC 8B D6 81 E2 00 1B 00 00 81 EA 00 11 00 00 F7 DA 1B D2 42 F7 D8 1B C0 85 C2 74 07 68 ?? ?? ?? ?? EB A0 83 7D FC 00 8B C6 74 09 25 00 18 00 00 2B C3 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C6 74 07 25 00 04 00 00 EB 02 23 C7 85 C0 74 28 8B 45 FC 8B D6 81 E2 00 1B 00 00 81 EA 00 12 00 00 F7 DA 1B D2 42 F7 D8 1B C0 85 C2 74 0A 68 ?? ?? ?? ?? E9 4A FF FF FF 83 7D FC 00 75 15 8B C6 23 C1 3D 00 78 00 00 0F 84 08 03 00 00 83 7D FC 00 74 0B 8B C6 25 00 18 00 00 2B C3 EB 07 8B C6 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C6 74 07 25 00 04 00 00 EB 02 23 C7 85 C0 74 48 8B 4D FC 8B C6 25 00 1B 00 00 33 D2 3D 00 11 00 00 0F 94 C2 F7 D9 1B C9 85 CA 75 15 8B 4D FC 33 D2 3D 00 12 00 00 0F 94 C2 F7 D9 1B C9 85 CA 74 17 8D 45 E0 50 8D 45 C0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 8D 45 E0 50 8D 45 C0 50 E8 ?? ?? ?? ?? 59 59 8D 4D E0 50 E8 ?? ?? ?? ?? 33 D2 39 55 FC B9 00 60 00 00 BB 00 08 00 00 BF 00 18 00 00 8B C6 74 06 23 C7 2B C3 EB 02 23 C1 F7 D8 1B C0 40 3B C2 0F 84 02 02 00 00 A1 ?? ?? ?? ?? C1 E8 09 F7 D0 A8 01 0F 84 07 01 00 00 39 55 FC 8B C6 74 06 23 C7 2B C3 EB 02 23 C1 F7 D8 1B C0 40 3B C2 74 42 39 55 FC 74 13 8B C6 25 00 07 00 00 2D 00 02 00 00 F7 D8 1B C0 40 EB 03 33 C0 40 3B C2 74 23 8D 45 E0 50 8D 45 C0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E0 E8 ?? ?? ?? ?? B9 00 60 00 00 8B 55 FC 85 D2 74 1A 8B C6 25 00 07 00 00 3D 00 01 00 00 74 75 85 D2 74 08 8B C6 23 C7 2B C3 EB 04 8B C6 23 C1 F7 D8 1B C0 40 85 C0 8B C6 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 74 6D 85 D2 8B C6 74 06 23 C7 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 0E 8B C6 25 00 07 00 00 3D 00 05 00 00 74 25 85 D2 8B C6 74 06 23 C7 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 31 8B C6 25 00 07 00 00 3D 00 04 00 00 75 23 8D 45 E0 50 8D 45 C0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E0 E8 ?? ?? ?? ?? B9 00 60 00 00 A1 ?? ?? ?? ?? C1 E8 07 F7 D0 A8 01 0F 84 D7 00 00 00 8B 55 FC 85 D2 8B C6 74 06 23 C7 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 28 85 D2 8B C6 74 0A 24 C0 2C 40 F6 D8 1B C0 EB 08 23 C7 2B C3 F7 D8 1B C0 40 85 C0 74 0B 8D 45 E0 50 68 ?? ?? ?? ?? EB 7B 85 D2 8B C6 74 06 23 C7 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 2B 85 D2 8B C6 74 0A 24 C0 2C 80 F6 D8 1B C0 EB 0B 23 C7 2D 00 10 00 00 F7 D8 1B C0 40 85 C0 74 0B 8D 45 E0 50 68 ?? ?? ?? ?? EB 39 85 D2 8B C6 74 06 23 C7 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 3C 85 D2 8B C6 74 08 24 C0 F6 D8 1B C0 EB 06 23 C7 F7 D8 1B C0 40 85 C0 74 23 8D 45 E0 50 68 ?? ?? ?? ?? 8D 45 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 4D E0 50 E8 ?? ?? ?? ?? B9 00 60 00 00 83 7D FC 00 8B C6 74 06 23 C7 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 08 81 E6 00 04 00 00 EB 06 81 E6 00 10 00 00 85 F6 74 1E 8D 45 E0 50 8D 45 C0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D E0 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 E0 50 E8 ?? ?? ?? ?? 5B 8B 45 08 5F 5E C9 C3 }
	condition:
		$1
}

rule file_453_130_0 {
	meta:
		name = "?getDecoratedName@UnDecorator@@CA?AVDName@@XZ"
		size = 442
		refs = "000e ?disableFlags@UnDecorator@@0KA 0022 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 0037 ?gName@UnDecorator@@0PBDB 0050 ?getSymbolName@UnDecorator@@CA?AVDName@@XZ 0059 ?isEmpty@DName@@QBEHXZ 0072 ?isValid@DName@@QBEHXZ 009a ?getScope@UnDecorator@@CA?AVDName@@XZ 00ad ?fExplicitTemplateParams@UnDecorator@@0_NA 00c4 ??HDName@@QBE?AV0@ABV0@@Z 00cd ??4DName@@QAEAAV0@ABV0@@Z 0107 ??_C@_02MOLJINC@?3?3?$AA@ 0110 ??HDName@@QBE?AV0@PBD@Z 017e ?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z 018c ??0DName@@QAE@ABV0@@Z 01b0 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 BE 00 20 00 00 85 35 ?? ?? ?? ?? 74 22 80 25 ?? ?? ?? ?? DF 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 09 35 ?? ?? ?? ?? 59 59 8D 45 F0 E9 51 01 00 00 A1 ?? ?? ?? ?? 8A 00 3C 3F 0F 85 5D 01 00 00 FF 05 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 0B F6 45 FC 20 74 05 33 F6 46 EB 02 33 F6 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 84 06 01 00 00 A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 97 00 00 00 3C 40 0F 84 8F 00 00 00 8D 45 F0 50 E8 ?? ?? ?? ?? 59 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 75 79 38 05 ?? ?? ?? ?? 74 48 A2 ?? ?? ?? ?? 8D 45 F0 50 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 74 49 8D 45 E8 50 E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F8 50 8D 45 E8 50 8D 45 E0 EB 0B 8D 45 F8 50 8D 45 E0 50 8D 45 E8 68 ?? ?? ?? ?? 8D 4D F0 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 4D F8 50 E8 ?? ?? ?? ?? 85 F6 74 10 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 04 83 4D FC 20 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 40 F6 45 FD 01 75 3A A1 ?? ?? ?? ?? 8A 00 84 C0 74 0A 3C 40 75 4D FF 05 ?? ?? ?? ?? F6 05 ?? ?? ?? ?? 10 74 2A 85 F6 75 26 21 75 F0 66 81 65 F4 00 FE 8D 45 F0 50 8D 45 E0 50 E8 ?? ?? ?? ?? 59 59 8D 45 F8 8B 4D 08 50 E8 ?? ?? ?? ?? EB 22 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 12 84 C0 74 04 6A 01 EB 02 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 5E C9 C3 }
	condition:
		$1
}

rule file_453_131_0 {
	meta:
		name = "?getScope@UnDecorator@@CA?AVDName@@XZ"
		size = 679
		refs = "0021 ??_C@_02MOLJINC@?3?3?$AA@ 002c ?gName@UnDecorator@@0PBDB 0045 ?fExplicitTemplateParams@UnDecorator@@0_NA 004d ?fGetTemplateArgumentList@UnDecorator@@0_NA 005b ?isEmpty@DName@@QBEHXZ 006d ??H@YA?AVDName@@PBDABV0@@Z 0079 ??4DName@@QAEAAV0@ABV0@@Z 008d ??H@YA?AVDName@@DABV0@@Z 00ea ?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ 010b ?getZName@UnDecorator@@CA?AVDName@@_N@Z 0114 ??HDName@@QBE?AV0@D@Z 011b ??HDName@@QBE?AV0@ABV0@@Z 0153 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 0196 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 01cc ??_C@_0BG@JNJLAMPM@?$GAanonymous?5namespace?8?$AA@ 025d ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0276 ??0DName@@QAE@W4DNameStatus@@@Z 027d ??HDName@@QBE?AV0@PBD@Z 0299 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC 9C 00 00 00 8B 45 6C 53 33 DB 25 00 FE FF FF 56 89 5D 68 89 45 6C 88 5D 73 BE ?? ?? ?? ?? E9 F3 01 00 00 8B 0D ?? ?? ?? ?? 8A 09 3A CB 0F 84 EB 01 00 00 80 F9 40 0F 84 E2 01 00 00 38 1D ?? ?? ?? ?? 74 0C 38 1D ?? ?? ?? ?? 0F 84 3A 02 00 00 8D 4D 68 E8 ?? ?? ?? ?? 85 C0 75 3D 8D 45 68 50 8D 45 20 56 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D 68 E8 ?? ?? ?? ?? 38 5D 73 74 1E 8D 45 68 50 8D 45 F8 6A 5B 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D 68 E8 ?? ?? ?? ?? 88 5D 73 8B 15 ?? ?? ?? ?? 80 3A 3F 0F 85 46 01 00 00 42 89 15 ?? ?? ?? ?? 8A 0A 0F BE C1 83 E8 24 0F 84 1D 01 00 00 48 0F 84 E7 00 00 00 83 E8 1A 74 61 48 48 0F 84 DA 00 00 00 83 E8 08 8D 45 68 50 74 12 8D 45 E8 50 8D 45 D8 50 E8 ?? ?? ?? ?? E9 16 01 00 00 8D 45 F0 50 6A 5D 8D 45 30 50 8D 45 00 42 6A 01 50 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D 68 E8 ?? ?? ?? ?? C6 45 73 01 E9 E9 00 00 00 8D 42 01 80 38 5F 75 4A 80 7A 02 3F 75 44 A3 ?? ?? ?? ?? 8D 45 68 50 8D 45 48 50 53 8D 45 E0 53 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D 68 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 0F 85 A2 00 00 00 FF 05 ?? ?? ?? ?? E9 97 00 00 00 8D 45 68 50 8D 45 10 50 6A 27 8D 45 40 50 8D 45 38 50 E8 ?? ?? ?? ?? 50 8D 45 28 6A 60 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? EB 58 80 F9 40 74 0C 42 89 15 ?? ?? ?? ?? 80 3A 40 75 F4 8D 45 68 50 8D 45 18 42 68 ?? ?? ?? ?? 50 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB 30 8D 45 68 50 8D 45 08 4A 50 89 15 ?? ?? ?? ?? 8D 45 58 EB 0B 8D 45 68 50 8D 45 50 50 8D 45 60 6A 01 50 E8 ?? ?? ?? ?? 59 59 8B C8 E8 ?? ?? ?? ?? 8D 4D 68 50 E8 ?? ?? ?? ?? 8B 45 6C A8 0F 0F 84 05 FE FF FF 8B 0D ?? ?? ?? ?? 8A 09 3A CB 74 1D 80 F9 40 74 5B 8B C8 83 E1 0F 80 F9 03 89 5D 68 74 4E 83 E0 F1 83 C8 01 89 45 6C EB 43 8D 4D 68 E8 ?? ?? ?? ?? 85 C0 74 09 6A 02 E8 ?? ?? ?? ?? EB 2E 8D 45 68 50 8D 45 60 50 56 8D 45 50 50 6A 02 8D 4D 58 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D 68 E8 ?? ?? ?? ?? 8B 4D 7C 8D 45 68 50 E8 ?? ?? ?? ?? 8B 45 7C 5E 5B 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_453_132_0 {
	meta:
		name = "?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 833
		refs = "0007 ?gName@UnDecorator@@0PBDB 001a ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 003b ??0DName@@QAE@W4DNameStatus@@@Z 00bc ??0DName@@QAE@ABV0@@Z 00d3 ??_C@_02MOLJINC@?3?3?$AA@ 00d9 ??H@YA?AVDName@@PBDABV0@@Z 00e5 ??4DName@@QAEAAV0@ABV0@@Z 0100 ?getScope@UnDecorator@@CA?AVDName@@XZ 010c ??H@YA?AVDName@@DABV0@@Z 0116 ??HDName@@QBE?AV0@ABV0@@Z 0147 ?disableFlags@UnDecorator@@0KA 015d ?getThisType@UnDecorator@@CA?AVDName@@XZ 018e ?getBasedType@UnDecorator@@CA?AVDName@@XZ 01be ??_5DName@@QAEAAV0@ABV0@@Z 020e ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 023c ?isEmpty@DName@@QBEHXZ 025f ??HDName@@QBE?AV0@D@Z 0271 _heap 0276 ?getMemory@HeapManager@@QAEPAXIH@Z 0290 ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 02a1 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 02c0 ??YDName@@QAEAAV0@ABV0@@Z 02f3 ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 8A 08 84 C9 75 15 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 16 03 00 00 80 F9 36 7C 05 80 F9 39 7E 14 80 F9 5F 74 0F 8B 4D 08 6A 01 E8 ?? ?? ?? ?? E9 F8 02 00 00 53 0F BE D9 83 EB 36 40 83 FB 29 A3 ?? ?? ?? ?? 75 31 8A 08 84 C9 74 16 0F BE D9 83 EB 3D 40 83 FB 04 A3 ?? ?? ?? ?? 7C 23 83 FB 07 EB 1C FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 B4 02 00 00 85 DB 7C 05 83 FB 03 7E 03 83 CB FF 83 FB FF 75 0F 8B 4D 08 6A 01 E8 ?? ?? ?? ?? E9 94 02 00 00 83 65 F0 00 56 57 FF 75 0C BE 00 FE FF FF 21 75 F4 8D 4D F8 E8 ?? ?? ?? ?? 8B FB 83 E7 02 0F 84 A0 00 00 00 8D 45 F8 50 8D 45 E0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 8D 45 F8 50 74 25 8D 45 E0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 50 8D 45 D0 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? EB 0E 8D 45 D0 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 4D F8 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 89 00 00 00 3C 40 75 7E A1 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 83 E0 60 3C 60 8D 45 D0 50 74 57 E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? F6 C3 04 0F 84 80 00 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 74 60 8D 45 F8 50 8D 45 D0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 50 8D 45 E0 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 41 E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? EB A7 6A 01 E9 66 01 00 00 8D 45 F8 50 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 58 01 00 00 8D 45 D0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 74 24 8D 45 F8 50 8D 45 D0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 13 8D 45 D0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 28 6A 29 8D 45 D0 50 8D 45 F8 50 8D 45 D8 6A 28 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 6A 00 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 83 20 00 21 70 04 8B F0 EB 02 33 F6 8D 45 E8 56 50 E8 ?? ?? ?? ?? 59 59 6A 29 8D 45 D0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 50 8D 45 E0 6A 28 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E0 60 3C 60 74 10 85 FF 74 0C 8D 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 F7 D0 A8 01 8D 45 D0 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 85 F6 74 19 8D 45 F8 50 8B CE E8 ?? ?? ?? ?? 8B 4D 08 8D 45 E8 50 E8 ?? ?? ?? ?? EB 0A 6A 03 8B 4D 08 E8 ?? ?? ?? ?? 5F 5E 5B 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_133_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z"
		size = 1394
		refs = "0007 ?gName@UnDecorator@@0PBDB 0068 ??_C@_05LMIJICDI@__gc?$FL?$AA@ 006f ??4DName@@QAEAAV0@PBD@Z 007a ??_C@_01IHBHIGKO@?0?$AA@ 0086 ??HDName@@QBE?AV0@PBD@Z 008f ??4DName@@QAEAAV0@ABV0@@Z 0097 ??_C@_02PBFOLPKM@?$FN?5?$AA@ 00b4 ?isEmpty@DName@@QBEHXZ 00de ??H@YA?AVDName@@DABV0@@Z 00e8 ??HDName@@QBE?AV0@D@Z 00ef ??HDName@@QBE?AV0@ABV0@@Z 010b ??_C@_06CCOHJJDD@__pin?5?$AA@ 0112 ??_C@_05HAECCCAF@__gc?5?$AA@ 0167 ?disableFlags@UnDecorator@@0KA 0186 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0287 ??0DName@@QAE@D@Z 0324 ??_C@_02MOLJINC@?3?3?$AA@ 032a ??H@YA?AVDName@@PBDABV0@@Z 0351 ?getScope@UnDecorator@@CA?AVDName@@XZ 036c ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 038e ??_5DName@@QAEAAV0@ABV0@@Z 03a3 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 03e4 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 0422 ??_C@_09GAIEOBLP@volatile?5?$AA@ 0445 ??_C@_06LIJLOJAG@const?5?$AA@ 04d9 ??YDName@@QAEAAV0@ABV0@@Z 04e9 ??0DName@@QAE@ABV0@@Z 0567 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 48 A1 ?? ?? ?? ?? 8A 00 83 65 F0 00 53 56 BE 00 FE FF FF 21 75 F4 84 C0 0F 84 D0 04 00 00 3C 24 0F 85 F9 00 00 00 FF 05 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 00 8B C8 83 E9 41 0F 84 CD 00 00 00 49 8D 4D F0 0F 84 BC 00 00 00 8D B0 CD FF FF 0F A1 ?? ?? ?? ?? 0F BE 40 01 83 05 ?? ?? ?? ?? 02 C1 E6 04 68 ?? ?? ?? ?? 03 F0 E8 ?? ?? ?? ?? 83 FE 01 76 1E 4E 68 ?? ?? ?? ?? 8D 45 E0 50 8D 4D F0 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 4E 75 E3 68 ?? ?? ?? ?? 8D 45 E8 50 8D 4D F0 E8 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 40 F6 41 04 80 8D 45 F0 50 74 06 8D 45 F8 50 EB 22 8D 45 D8 50 6A 29 8D 45 D0 50 51 8D 45 C8 6A 28 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 4D F0 50 E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 8D 45 F0 E9 DA 03 00 00 68 ?? ?? ?? ?? EB 08 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 33 C9 3C 41 0F 9C C1 21 75 EC 83 65 E8 00 83 65 E0 00 0F BE D8 49 83 E1 2B 83 C1 16 2B D9 21 75 E4 6A 20 5E 8B C3 83 E8 04 0F 84 B7 00 00 00 48 74 3D 83 E8 03 0F 85 0B 01 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 74 79 8D 4D E8 E8 ?? ?? ?? ?? 85 C0 6A 08 0F 85 DF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 C8 50 8D 45 D0 E9 AE 00 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 74 45 8D 4D E0 E8 ?? ?? ?? ?? 85 C0 6A 09 75 26 E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 D8 50 56 8D 45 F8 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 4D E0 E9 81 00 00 00 E8 ?? ?? ?? ?? 8D 4D E0 83 C4 04 50 E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 33 C9 3C 41 0F 9C C1 0F BE D8 49 83 E1 2B 83 C1 16 2B D9 E9 3E FF FF FF A1 ?? ?? ?? ?? 8B C8 D1 E9 F7 D1 F6 C1 01 74 CB C1 E8 11 F7 D0 A8 01 74 C2 8D 4D E8 E8 ?? ?? ?? ?? 85 C0 6A 07 75 2C E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 C0 50 8D 45 B8 56 50 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 4D E8 50 E8 ?? ?? ?? ?? EB 88 E8 ?? ?? ?? ?? 8D 4D E8 E9 72 FF FF FF FF 05 ?? ?? ?? ?? 83 FB 1F 0F 87 6F 02 00 00 FF 75 10 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 8D 45 B8 50 8D 4D F0 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 85 C0 75 25 8D 45 E8 50 8D 45 B8 50 56 8D 45 C0 50 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 85 C0 75 22 8D 45 F8 50 8D 45 B8 50 56 8D 45 C0 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? F6 C3 10 0F 84 AB 00 00 00 83 7D 18 00 0F 85 D9 01 00 00 80 7D 10 00 74 59 8D 45 F8 50 8D 45 B8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 8D 45 F8 50 8D 45 B8 74 1D 50 8D 45 C0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 2A 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C EB E8 A1 ?? ?? ?? ?? 80 38 00 74 1E 8D 45 B8 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 84 C0 75 0C 6A 02 8D 4D F8 E8 ?? ?? ?? ?? EB 0E FF 05 ?? ?? ?? ?? 3C 40 0F 85 38 01 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 8B C3 74 35 83 E0 0C 3C 0C 75 48 83 7D 18 00 0F 85 18 01 00 00 8D 45 F8 50 8D 45 B8 50 8D 45 C0 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 1A 83 E0 0C 3C 0C 75 13 8D 45 B8 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? F6 C3 02 74 1E 8D 45 F8 50 8D 45 B8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? F6 C3 01 74 1E 8D 45 F8 50 8D 45 B8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 83 7D 18 00 75 7C 8B 55 0C 8B CA E8 ?? ?? ?? ?? 85 C0 75 4B 8B 5A 04 F6 C3 10 75 34 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 28 52 8D 45 B8 50 56 8D 45 C0 50 51 8D 45 C8 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 29 84 DB 52 79 17 8D 4D F8 E8 ?? ?? ?? ?? EB 23 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 17 51 8D 45 B8 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 4D F8 50 E8 ?? ?? ?? ?? 83 4D FC 10 8D 45 F8 8B 4D 08 50 E8 ?? ?? ?? ?? EB 7C 6A 01 EB 70 83 7D 18 00 75 68 8B 55 0C 8B CA E8 ?? ?? ?? ?? 85 C0 75 3E F6 42 04 10 75 35 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 29 52 FF 75 08 8D 45 B8 6A 20 50 51 8D 45 C0 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 29 52 EB 0D 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 10 51 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 0A 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 5E 5B C9 C3 }
	condition:
		$1
}

rule file_453_134_0 {
	meta:
		name = "??BUnDecorator@@QAEPADXZ"
		size = 331
		refs = "001a ?name@UnDecorator@@0PBDB 0030 ?gName@UnDecorator@@0PBDB 003a ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0043 ??_C@_04HEJADOOB@CV?3?5?$AA@ 0049 ??H@YA?AVDName@@PBDABV0@@Z 005d ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 0068 ??4DName@@QAEAAV0@ABV0@@Z 00b5 ?disableFlags@UnDecorator@@0KA 00cb ??4DName@@QAEAAV0@PBD@Z 00de ?outputString@UnDecorator@@0PADA 00ea ?length@DName@@QBEHXZ 00f0 ?maxStringLength@UnDecorator@@0HA 00fd _heap 0116 ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 F8 00 83 65 F0 00 B8 00 FE FF FF 21 45 FC 21 45 F4 A1 ?? ?? ?? ?? 85 C0 74 74 80 38 3F 75 5C 8A 40 01 3C 40 75 24 83 05 ?? ?? ?? ?? 02 8D 45 E8 50 E8 ?? ?? ?? ?? 50 8D 45 E0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 EB 3B 3C 24 75 2D 8D 45 E0 6A 00 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 FC 24 0F 3C 01 75 21 A1 ?? ?? ?? ?? 83 65 FC F0 A3 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 59 8D 4D F8 50 E8 ?? ?? ?? ?? 8B 45 FC C1 E0 1C C1 F8 1C 83 F8 03 75 04 33 C0 C9 C3 8B 0D ?? ?? ?? ?? 80 39 00 74 09 F6 05 ?? ?? ?? ?? 10 74 05 83 F8 01 75 10 FF 35 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? EB 0C 8D 45 F8 50 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 25 8D 4D F0 E8 ?? ?? ?? ?? 40 A3 ?? ?? ?? ?? 83 C0 07 83 E0 F8 50 FF 15 ?? ?? ?? ?? 85 C0 59 A3 ?? ?? ?? ?? 74 3E FF 35 ?? ?? ?? ?? 8D 4D F0 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B D0 EB 17 80 F9 20 75 0E 40 88 0A 42 EB 01 40 80 38 20 74 FA EB 04 88 0A 42 40 8A 08 84 C9 75 E3 8A C1 88 02 A1 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_453_135_0 {
	meta:
		name = "?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z"
		size = 278
		refs = "0006 ?gName@UnDecorator@@0PBDB 0028 ??0DName@@QAE@D@Z 0030 ?isEmpty@DName@@QBEHXZ 0053 ??YDName@@QAEAAV0@ABV0@@Z 0073 ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z 008f ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 00a5 ?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z 00b4 ??0DName@@QAE@W4DNameStatus@@@Z 00bf ??YDName@@QAEAAV0@D@Z 010d ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 9A 00 00 00 3C 36 7C 04 3C 39 7E 04 3C 5F 75 5F 56 FF 75 14 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 8B 75 10 75 1C 8B CE E8 ?? ?? ?? ?? 85 C0 75 06 F6 46 04 10 75 0B FF 75 0C 8D 4D F8 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 75 09 56 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5E E9 92 00 00 00 6A 00 FF 75 0C 8D 45 F8 FF 75 14 FF 75 10 50 E8 ?? ?? ?? ?? 33 C0 80 7D 14 2A 0F 94 C0 50 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 EB 63 6A 02 8D 4D F8 E8 ?? ?? ?? ?? FF 75 14 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 09 51 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 10 E8 ?? ?? ?? ?? 85 C0 75 21 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0A 6A 20 8D 4D F8 E8 ?? ?? ?? ?? FF 75 10 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_136_0 {
	meta:
		name = "?getPointerType@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 27
		refs = "000f ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z"
	strings:
		$1 = { 6A 2A FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 10 C3 }
	condition:
		$1
}

rule file_453_137_0 {
	meta:
		name = "?getPointerTypeArray@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 27
		refs = "000f ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 10 C3 }
	condition:
		$1
}

rule file_453_138_0 {
	meta:
		name = "?getReferenceType@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 27
		refs = "000f ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z"
	strings:
		$1 = { 6A 26 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 10 C3 }
	condition:
		$1
}

rule file_453_139_0 {
	meta:
		name = "___unDName"
		size = 96
		refs = "0013 _heap 0043 ??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z 004b ??BUnDecorator@@QAEPADXZ 0057 ?Destructor@HeapManager@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 78 8B 4D 14 33 C0 3B C8 75 02 C9 C3 89 0D ?? ?? ?? ?? 8B 4D 18 56 89 0D ?? ?? ?? ?? 0F B7 4D 1C 51 50 FF 75 10 8D 4D 88 FF 75 0C A3 ?? ?? ?? ?? FF 75 08 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D 88 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_453_140_0 {
	meta:
		name = "___unDNameEx"
		size = 99
		refs = "0018 _heap 0046 ??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z 004e ??BUnDecorator@@QAEPADXZ 005a ?Destructor@HeapManager@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 78 8B 45 14 33 C9 3B C1 75 04 33 C0 C9 C3 56 FF 75 20 A3 ?? ?? ?? ?? FF 75 1C 8B 45 18 FF 75 10 89 0D ?? ?? ?? ?? FF 75 0C 89 0D ?? ?? ?? ?? FF 75 08 89 0D ?? ?? ?? ?? 8D 4D 88 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D 88 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_453_141_0 {
	meta:
		name = "?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 883
		refs = "0007 ?gName@UnDecorator@@0PBDB 0048 $L24117 004d ??_C@_04ENMBGAPA@char?$AA@ 0055 ??4DName@@QAEAAV0@PBD@Z 005f ??_C@_05BFKKPKCG@short?$AA@ 0066 ??_C@_03JBIPMCLC@int?$AA@ 006d ??_C@_04GOKPGOLB@long?$AA@ 0074 ??_C@_05KNFBNCOH@float?$AA@ 00e7 ??_C@_06EBGKOKIG@__int8?$AA@ 00f8 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 00fe ??_C@_06GCICPBLB@__w64?5?$AA@ 0106 ??H@YA?AVDName@@PBDABV0@@Z 0113 ??_C@_07ICFHOGAF@__int16?$AA@ 012c ??_C@_07LFCOJCAC@__int64?$AA@ 0136 ??_C@_07OFLPPHGP@__int32?$AA@ 0140 ??_C@_08GAHOLHEO@__int128?$AA@ 016e ?getECSUDataType@UnDecorator@@CA?AVDName@@XZ 0178 ??4DName@@QAEAAV0@ABV0@@Z 0180 ?isEmpty@DName@@QBEHXZ 0192 ??_C@_07NFANNNEC@UNKNOWN?$AA@ 019c ??_C@_07CLGGIAMF@wchar_t?$AA@ 01b6 ??0DName@@QAE@ABV0@@Z 01d6 ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z 01e4 ??_C@_02GPECMEKF@?$FL?$FN?$AA@ 01ec ??YDName@@QAEAAV0@PBD@Z 0202 ??_C@_04DDKJGDCM@bool?$AA@ 021b ??_C@_05CJIMAING@long?5?$AA@ 0228 ??_C@_06BNJCAIGJ@double?$AA@ 027a ??_C@_09EBBEKKIH@unsigned?5?$AA@ 0296 ??_C@_07EDHNAJHC@signed?5?$AA@ 02c7 ??H@YA?AVDName@@DABV0@@Z 02d3 ??YDName@@QAEAAV0@ABV0@@Z 02ee ??_C@_05BNCCCJPP@const?$AA@ 0300 ??_C@_09EFNPDFFP@?5volatile?$AA@ 0314 ??_C@_08PABEKFH@volatile?$AA@ 0340 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 034f $L20637 035b $L20639 0363 $L20641 036b $L20643"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 8A 00 84 C0 53 56 57 0F 84 1F 03 00 00 FF 05 ?? ?? ?? ?? 83 65 F4 00 0F B6 F8 BE 00 FE FF FF 21 75 F8 8B C7 83 CB FF 83 F8 4D 7F 43 74 3A 83 E8 43 83 F8 08 0F 87 CD 01 00 00 FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? E9 DF 01 00 00 68 ?? ?? ?? ?? EB EC 68 ?? ?? ?? ?? EB E5 68 ?? ?? ?? ?? EB DE 68 ?? ?? ?? ?? EB D7 83 F8 4E 0F 84 A4 01 00 00 83 F8 4F 0F 84 8E 01 00 00 0F 8E 80 01 00 00 83 F8 53 0F 8E 70 01 00 00 83 F8 5F 0F 85 6E 01 00 00 A1 ?? ?? ?? ?? 8A 00 FF 05 ?? ?? ?? ?? 88 45 FF 0F B6 C0 83 F8 4D 0F 8F 89 00 00 00 83 F8 4C 7D 7A 83 F8 47 7F 52 83 F8 46 7D 43 83 F8 24 74 1C 83 F8 43 0F 8E B4 00 00 00 83 F8 45 0F 8F AB 00 00 00 68 ?? ?? ?? ?? E9 61 FF FF FF FF 75 0C 8D 45 E4 50 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 E9 35 02 00 00 68 ?? ?? ?? ?? E9 35 FF FF FF 83 F8 48 7C 70 83 F8 49 7E 0F 83 F8 4B 7F 66 68 ?? ?? ?? ?? E9 1C FF FF FF 68 ?? ?? ?? ?? E9 12 FF FF FF 68 ?? ?? ?? ?? E9 08 FF FF FF 83 F8 4E 0F 84 AF 00 00 00 83 F8 4F 74 4E 83 F8 57 74 3F 7E 33 83 F8 59 7F 2E 8D 45 EC FF 0D ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 0F 84 B1 00 00 00 8D 45 F4 EB 62 68 ?? ?? ?? ?? E9 B6 FE FF FF 68 ?? ?? ?? ?? E9 AC FE FF FF 6A FE 5B FF 75 0C 83 65 F4 00 21 75 F8 8D 4D EC E8 ?? ?? ?? ?? 83 FB FE 0F 85 19 01 00 00 80 4D F0 80 6A 00 8D 45 EC 50 8D 45 F4 50 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 10 F6 45 E8 80 75 0D 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8D 45 E4 8B 4D 08 50 E8 ?? ?? ?? ?? E9 46 01 00 00 68 ?? ?? ?? ?? E9 46 FE FF FF 8B DF 83 E3 03 EB 22 8D 45 DC E9 4C FF FF FF 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 83 FB FF 0F 85 6B FF FF FF 8B C7 83 E8 43 74 4D 6A 02 59 2B C1 74 38 2B C1 74 34 2B C1 74 30 2B C1 74 2C 83 E8 14 75 53 0F B6 45 FF 83 E8 45 74 10 2B C1 74 0C 2B C1 74 08 2B C1 74 04 2B C1 75 3A 8D 45 F4 50 68 ?? ?? ?? ?? 8D 45 DC EB 1A 8D 45 F4 50 68 ?? ?? ?? ?? 8D 45 E4 EB 0C 8D 45 F4 50 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 4D F4 50 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 0F 85 CD FE FF FF 51 8D 45 DC 6A 20 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? E9 B0 FE FF FF 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 74 38 F6 C3 01 74 21 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? F6 C3 02 74 21 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? EB 12 F6 C3 02 74 0D 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 6A 2A 8D 45 EC 50 8D 45 F4 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 10 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5F 5E 5B C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_142_0 {
	meta:
		name = "?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 304
		refs = "0009 ?gName@UnDecorator@@0PBDB 0035 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 003f ??_C@_08PABEKFH@volatile?$AA@ 0047 ??4DName@@QAEAAV0@PBD@Z 004f ?isEmpty@DName@@QBEHXZ 005d ??YDName@@QAEAAV0@D@Z 0068 ??0DName@@QAE@ABV0@@Z 0084 ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z 00a1 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 00ce ??0DName@@QAE@W4DNameStatus@@@Z 00ef ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 0111 ?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z 0125 ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 8B 35 ?? ?? ?? ?? 0F BE 06 33 D2 B9 00 FE FF FF 21 4D FC 2B C2 89 55 F8 74 77 83 E8 24 74 67 83 E8 1D 74 36 48 74 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? E9 EB 00 00 00 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0A 6A 20 8D 4D F8 E8 ?? ?? ?? ?? FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 83 4D F4 10 6A 26 8D 45 F0 50 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 1B 8A 46 01 3C 24 74 1A 3A C2 75 30 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5E C9 C3 46 46 89 35 ?? ?? ?? ?? 0F BE 06 2B C2 74 DB 83 E8 41 74 55 48 74 3C 48 74 0C 8B 4D 08 6A 01 E8 ?? ?? ?? ?? EB D4 21 4D F4 52 8D 45 F0 50 52 FF 75 0C 8D 45 E8 46 50 89 35 ?? ?? ?? ?? 89 55 F0 E8 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C EB A7 6A 01 FF 75 0C 46 FF 75 08 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 8E FF 75 0C 46 FF 75 08 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 E9 78 FF FF FF }
	condition:
		$1
}

rule file_453_143_0 {
	meta:
		name = "?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z"
		size = 174
		refs = "000d ??0DName@@QAE@PAV0@@Z 0012 ?gName@UnDecorator@@0PBDB 0030 ?isEmpty@DName@@QBEHXZ 003c ??_C@_04GKJNKENE@void?$AA@ 0041 ??0DName@@QAE@PBD@Z 004c ??_C@_05BEFAKPML@void?5?$AA@ 0054 ??H@YA?AVDName@@PBDABV0@@Z 0078 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 0084 ??4DName@@QAEAAV0@ABV0@@Z 0090 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 00a2 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 FF 75 0C 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 33 C9 3A C1 74 7A 3C 3F 74 38 3C 58 75 62 FF 05 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0F 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 62 8D 45 F8 50 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? EB 4C FF 05 ?? ?? ?? ?? 66 81 65 F4 00 FE 51 8D 45 F0 50 51 8D 45 F8 50 8D 45 E8 50 89 4D F0 E8 ?? ?? ?? ?? 83 C4 14 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 11 8D 45 F8 50 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_453_144_0 {
	meta:
		name = "?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 112
		refs = "000d _heap 0012 ?getMemory@HeapManager@@QAEPAXIH@Z 002a ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 0033 ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ 004b ??HDName@@QBE?AV0@D@Z 0052 ??HDName@@QBE?AV0@ABV0@@Z 005a ??4DName@@QAEAAV0@ABV0@@Z 0066 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 33 F6 56 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B C6 74 0A 66 81 60 04 00 FE 89 30 8B F0 8D 45 F0 56 50 E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C 8D 45 E8 50 6A 20 8D 45 E0 50 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 45 08 5E C9 C3 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "__wsopen"
		size = 721
		refs = "003f __fmode 008c _errno 0096 __doserrno 014b __umaskval 016b __osplatform 0194 __alloc_osfhnd 01ce __imp__CreateFileW@28 01db __imp__GetFileType@4 01e6 __imp__CloseHandle@4 01ec __imp__GetLastError@0 01f2 __dosmaperr 0210 __set_osfhnd 0228 ___pioinfo 024e __lseek 0291 __read 02a8 __chsize 02c7 __close"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 4D 0C 53 33 DB 84 C9 56 C7 45 E0 0C 00 00 00 89 5D E4 79 09 89 5D E8 C6 45 FF 10 EB 0B C7 45 E8 01 00 00 00 C6 45 FF 00 B8 00 80 00 00 85 C8 75 11 F6 C5 40 75 08 39 05 ?? ?? ?? ?? 74 04 80 4D FF 80 6A 03 8B C1 5E 23 C6 2B C3 74 18 48 74 0C 48 75 30 C7 45 F0 00 00 00 C0 EB 10 C7 45 F0 00 00 00 40 EB 07 C7 45 F0 00 00 00 80 8B 45 10 83 F8 10 74 3E 83 F8 20 74 30 83 F8 30 74 22 83 F8 40 74 18 C7 05 ?? ?? ?? ?? 16 00 00 00 89 1D ?? ?? ?? ?? 83 C8 FF E9 DF 01 00 00 89 75 F8 EB 15 C7 45 F8 02 00 00 00 EB 0C C7 45 F8 01 00 00 00 EB 03 89 5D F8 8B C1 BA 00 07 00 00 23 C2 B9 00 04 00 00 3B C1 57 BF 00 01 00 00 7F 2F 74 28 3B C3 74 24 3B C7 74 17 3D 00 02 00 00 74 48 3D 00 03 00 00 75 29 C7 45 F4 02 00 00 00 EB 48 C7 45 F4 04 00 00 00 EB 3F 89 75 F4 EB 3A 3D 00 05 00 00 74 2C 3D 00 06 00 00 74 1C 3B C2 74 21 C7 05 ?? ?? ?? ?? 16 00 00 00 89 1D ?? ?? ?? ?? 83 C8 FF E9 53 01 00 00 C7 45 F4 05 00 00 00 EB 07 C7 45 F4 01 00 00 00 8B 45 0C 85 C7 BE 80 00 00 00 74 12 8B 0D ?? ?? ?? ?? F7 D1 23 4D 14 84 C9 78 03 33 F6 46 A8 40 74 17 80 4D F2 01 81 CE 00 00 00 04 83 3D ?? ?? ?? ?? 02 75 04 83 4D F8 04 F6 C4 10 74 02 0B F7 A8 20 74 08 81 CE 00 00 00 08 EB 0A A8 10 74 06 81 CE 00 00 00 10 E8 ?? ?? ?? ?? 8B D8 83 CF FF 3B DF 75 18 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 18 00 00 00 8B C7 E9 C7 00 00 00 6A 00 56 FF 75 F4 8D 45 E0 50 FF 75 F8 FF 75 F0 FF 75 08 FF 15 ?? ?? ?? ?? 8B F0 3B F7 74 12 56 FF 15 ?? ?? ?? ?? 85 C0 75 16 56 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B9 83 F8 02 75 06 80 4D FF 40 EB 09 83 F8 03 75 04 80 4D FF 08 56 53 E8 ?? ?? ?? ?? 8A 45 FF 59 59 8B CB C1 F9 05 0C 01 8B F3 83 E6 1F 8D 3C 8D ?? ?? ?? ?? 8B 0F C1 E6 03 88 45 FF 80 65 FF 48 88 44 31 04 75 2B 84 C0 79 27 F6 45 0C 02 74 21 6A 02 6A FF 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 89 45 F0 75 28 81 3D ?? ?? ?? ?? 83 00 00 00 75 5C 80 7D FF 00 75 0F F6 45 0C 08 74 09 8B 07 8D 44 30 04 80 08 20 8B C3 5F 5E 5B C9 C3 83 65 EC 00 6A 01 8D 45 EC 50 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 17 66 83 7D EC 1A 75 10 FF 75 F0 53 E8 ?? ?? ?? ?? 83 F8 FF 59 59 74 12 6A 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 A4 53 E8 ?? ?? ?? ?? 59 E9 54 FE FF FF }
	condition:
		$1
}

rule file_454_1_0 {
	meta:
		name = "__wopen"
		size = 23
		refs = "000f __wsopen"
	strings:
		$1 = { FF 74 24 0C 6A 40 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_614_1_0 {
	meta:
		name = "__open"
		size = 23
		refs = "000f __sopen"
	strings:
		$1 = { FF 74 24 0C 6A 40 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "__gmtime64"
		size = 508
		refs = "0049 __alldiv 0092 __allmul 0132 _tb 015c __lpdays 0163 __days"
	strings:
		$1 = { 83 EC 10 8B 44 24 14 83 24 24 00 57 8B 38 8B 40 04 85 C0 89 44 24 10 0F 8C D8 01 00 00 7F 08 85 FF 0F 82 CE 01 00 00 3D 00 10 00 00 0F 8F C3 01 00 00 7C 08 85 FF 0F 87 B9 01 00 00 53 55 56 6A 00 68 80 33 E1 01 50 57 E8 ?? ?? ?? ?? 8B F0 83 C6 46 8D 86 2B 01 00 00 99 BB 90 01 00 00 F7 FB 6A 64 8D 4E FF 5D 6A 04 89 4C 24 18 8B D8 8B C1 99 F7 FD 2B D8 8B C1 99 59 F7 F9 6A FF 68 93 FE FF FF 8D 44 03 EF 99 8B D8 8B EA 8D 46 BA 99 52 50 E8 ?? ?? ?? ?? 2B C3 1B D5 6A 00 BD 80 51 01 00 55 52 50 E8 ?? ?? ?? ?? 8B 5C 24 1C 03 F8 13 DA 85 DB 7F 44 7C 04 85 FF 73 3E 8B 74 24 14 8B C6 81 C7 80 33 E1 01 6A 04 99 83 D3 00 59 F7 F9 85 D2 75 0C 8B C6 6A 64 99 59 F7 F9 85 D2 75 12 8D 86 6C 07 00 00 99 B9 90 01 00 00 F7 F9 85 D2 75 39 03 FD 83 D3 00 EB 2A 8B C6 6A 04 99 59 F7 F9 85 D2 75 0C 8B C6 6A 64 99 59 F7 F9 85 D2 75 12 8D 86 6C 07 00 00 99 B9 90 01 00 00 F7 F9 85 D2 75 08 C7 44 24 10 01 00 00 00 6A 00 55 53 57 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A FF 8B F0 99 68 80 AE FE FF 52 50 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 03 F8 13 DA 83 7C 24 10 00 B9 ?? ?? ?? ?? 75 05 B9 ?? ?? ?? ?? 33 C0 40 39 71 04 7D 06 40 39 34 81 7C FA 48 A3 ?? ?? ?? ?? 2B 34 81 8B 44 24 24 6A 00 55 89 35 ?? ?? ?? ?? FF 70 04 FF 30 E8 ?? ?? ?? ?? 6A 07 83 C0 04 59 99 F7 F9 33 F6 56 68 10 0E 00 00 53 57 89 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A FF A3 ?? ?? ?? ?? 99 68 F0 F1 FF FF 52 50 E8 ?? ?? ?? ?? 56 03 F8 6A 3C 13 DA 53 57 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6B C0 3C 89 35 ?? ?? ?? ?? 5E 2B F8 5D 89 3D ?? ?? ?? ?? B8 ?? ?? ?? ?? 5B EB 02 33 C0 5F 83 C4 10 C3 }
	condition:
		$1
}

rule file_457_0_0 {
	meta:
		name = "__memicmp"
		size = 92
		refs = "000e ___lc_handle 001e ___ascii_memicmp 0038 _tolower"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 33 C9 33 DB 39 0D ?? ?? ?? ?? 57 8B 7D 0C 75 0F FF 75 10 57 56 E8 ?? ?? ?? ?? 83 C4 0C EB 30 39 4D 10 74 27 FF 4D 10 3B D9 75 20 0F B6 06 50 E8 ?? ?? ?? ?? 8B D8 0F B6 07 50 46 E8 ?? ?? ?? ?? 59 47 83 7D 10 00 59 8B C8 75 D9 8B C3 2B C1 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "__wwincmdln"
		size = 70
		refs = "0001 __wcmdln 000c ??_C@_11LOCGONAA@?$AA?$AA@"
	strings:
		$1 = { A1 ?? ?? ?? ?? 33 D2 85 C0 75 05 B8 ?? ?? ?? ?? 66 8B 08 66 83 F9 20 77 09 66 85 C9 74 27 85 D2 74 1B 66 83 F9 22 75 09 33 C9 85 D2 0F 94 C1 8B D1 40 40 EB DB 66 83 F9 20 77 0A 40 40 66 8B 08 66 85 C9 75 F0 C3 }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "_clock"
		size = 67
		refs = "000c __imp__GetSystemTimeAsFileTime@4 001a __allmul 0020 _start_tics 003c __aulldiv"
	strings:
		$1 = { 55 8B EC 51 51 57 8D 45 F8 50 FF 15 ?? ?? ?? ?? 6A 01 6A 00 6A 00 FF 75 FC E8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 8B 4D F8 1B 15 ?? ?? ?? ?? 33 FF 57 03 C1 68 10 27 00 00 13 D7 52 50 E8 ?? ?? ?? ?? 5F C9 C3 }
	condition:
		$1
}

rule file_459_1_0 {
	meta:
		name = "___inittime"
		size = 55
		refs = "000c __imp__GetSystemTimeAsFileTime@4 001a __allmul 0028 _start_tics"
	strings:
		$1 = { 55 8B EC 51 51 56 8D 45 F8 50 FF 15 ?? ?? ?? ?? 6A 01 6A 00 6A 00 FF 75 FC E8 ?? ?? ?? ?? 8B 4D F8 33 F6 03 C1 13 D6 A3 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 33 C0 5E C9 C3 }
	condition:
		$1
}

rule file_460_1_0 {
	meta:
		name = "__wstati64"
		size = 781
		refs = "000f ___security_cookie 001b ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0027 _wcspbrk 0035 _errno 003a __doserrno 0075 _towlower 0083 __getdrive 0095 __imp__FindFirstFileW@8 00a8 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00c3 __wfullpath 00d2 _wcslen 00dd _IsRootUNCName 00e8 __imp__GetDriveTypeW@4 011c ___loctotime_t 0156 __imp__FileTimeToLocalFileTime@8 016c __imp__FileTimeToSystemTime@8 0284 __imp__FindClose@4 0295 ___wdtoxmode 02b0 __allmul 02e1 __imp__GetLastError@0 02e7 __dosmaperr 0301 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 04 FC FF FF 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 56 8B B5 04 04 00 00 68 ?? ?? ?? ?? 56 89 85 F8 03 00 00 E8 ?? ?? ?? ?? 85 C0 59 59 74 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 B3 02 00 00 57 33 FF 66 83 7E 02 3A 75 32 66 8B 06 66 3B C7 74 1B 66 39 7E 04 75 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 85 02 00 00 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 45 80 53 8D 85 A8 01 00 00 50 56 FF 15 ?? ?? ?? ?? 83 CB FF 3B C3 89 45 8C 0F 85 A2 00 00 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 7F 68 04 01 00 00 8D 45 A0 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 3B F7 74 67 56 E8 ?? ?? ?? ?? 83 F8 03 59 74 09 E8 ?? ?? ?? ?? 85 C0 74 52 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 46 53 57 57 57 6A 01 6A 01 68 BC 07 00 00 C7 85 A8 01 00 00 10 00 00 00 89 BD C4 01 00 00 89 BD C8 01 00 00 66 89 BD D4 01 00 00 E8 ?? ?? ?? ?? 8B B5 08 04 00 00 83 C4 1C 89 46 24 89 46 20 89 46 28 E9 51 01 00 00 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 AC 01 00 00 8D 45 84 50 8D 85 BC 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 7D 01 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 67 01 00 00 0F B7 45 9C 53 50 0F B7 45 9A 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 8B B5 08 04 00 00 83 C4 1C 39 BD B4 01 00 00 89 46 24 75 08 39 BD B8 01 00 00 74 56 8D 45 84 50 8D 85 B4 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 0E 01 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F8 00 00 00 0F B7 45 9C 53 50 0F B7 45 9A 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 83 C4 1C 39 BD AC 01 00 00 89 46 20 75 0D 39 BD B0 01 00 00 75 05 8B 46 24 EB 56 8D 45 84 50 8D 85 AC 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A0 00 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8A 00 00 00 0F B7 45 9C 53 50 0F B7 45 9A 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 83 C4 1C FF 75 8C 89 46 28 FF 15 ?? ?? ?? ?? FF B5 04 04 00 00 FF B5 A8 01 00 00 E8 ?? ?? ?? ?? 59 59 6A 01 57 57 FF B5 C4 01 00 00 66 89 46 06 66 C7 46 08 01 00 E8 ?? ?? ?? ?? 8B 8D C8 01 00 00 33 DB 03 C1 89 46 18 8B 45 80 13 D3 48 89 06 89 46 10 89 56 1C 66 89 7E 04 66 89 7E 0C 66 89 7E 0A 33 C0 EB 18 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF 75 8C FF 15 ?? ?? ?? ?? 8B C3 5B 5F 8B 8D F8 03 00 00 5E E8 ?? ?? ?? ?? 81 C5 FC 03 00 00 C9 C3 }
	condition:
		$1
}

rule file_461_0_0 {
	meta:
		name = "__getpath"
		size = 111
	strings:
		$1 = { 55 8B EC 8B 4D 08 EB 01 41 80 39 3B 74 FA FF 4D 10 56 8B 75 0C 8B C1 74 48 EB 38 80 FA 3B 74 3B 80 FA 22 74 0D 88 16 46 41 FF 4D 10 75 25 8B C1 EB 2F 41 8A 11 84 D2 74 23 80 FA 22 74 0F 88 16 46 41 FF 4D 10 74 E7 8A 11 84 D2 75 EC 80 39 00 74 0A 41 8A 11 84 D2 75 C2 EB 01 41 80 39 3B 74 FA 2B C1 F7 D8 1B C0 C6 06 00 23 C1 5E 5D C3 }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "__dosmaperr"
		size = 95
		refs = "0005 __doserrno 000e _errtable 0026 _errno"
	strings:
		$1 = { 8B 44 24 04 A3 ?? ?? ?? ?? 33 C9 3B 04 CD ?? ?? ?? ?? 74 1B 41 83 F9 2D 72 F1 83 F8 13 72 1D 83 F8 24 77 18 C7 05 ?? ?? ?? ?? 0D 00 00 00 C3 8B 04 CD ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 3D BC 00 00 00 72 11 3D CA 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 76 0A C7 05 ?? ?? ?? ?? 16 00 00 00 C3 }
	condition:
		$1
}

rule file_463_0_0 {
	meta:
		name = "__NMSG_WRITE"
		size = 375
		refs = "000f ___security_cookie 0029 _rterrs 0047 ___error_mode 005a ___app_type 0083 __imp__GetModuleFileNameA@12 008f ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 0095 _strcpy 00a2 _strlen 00c2 ??_C@_03KHICJKCI@?4?4?4?$AA@ 00c8 _strncpy 00ef __alloca_probe 00f6 ??_C@_0BK@OFGJDLJJ@Runtime?5Error?$CB?6?6Program?3?5?$AA@ 0103 _strcat 0108 ??_C@_02PHMGELLB@?6?6?$AA@ 0124 ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 012a ___crtMessageBoxA 0150 __imp__GetStdHandle@4 0157 __imp__WriteFile@20 0168 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 74 FF FF FF 81 EC 0C 01 00 00 A1 ?? ?? ?? ?? 8B 8D 94 00 00 00 53 56 89 85 88 00 00 00 33 D2 57 33 C0 3B 0C C5 ?? ?? ?? ?? 74 06 40 83 F8 13 72 F1 8B F0 C1 E6 03 3B 8E ?? ?? ?? ?? 0F 85 15 01 00 00 A1 ?? ?? ?? ?? 83 F8 01 0F 84 DF 00 00 00 3B C2 75 0D 83 3D ?? ?? ?? ?? 01 0F 84 CE 00 00 00 81 F9 FC 00 00 00 0F 84 EA 00 00 00 68 04 01 00 00 8D 45 80 50 52 88 95 84 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 10 8D 45 80 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 8D 7D 80 8B C7 50 E8 ?? ?? ?? ?? 40 83 F8 3C 59 76 22 8B C7 50 E8 ?? ?? ?? ?? 8B F8 8D 45 80 83 E8 3B 6A 03 03 F8 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 10 57 E8 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 8D 44 03 1C 59 83 C0 03 59 83 E0 FC E8 ?? ?? ?? ?? 8B DC 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 57 53 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? FF B6 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 68 10 20 01 00 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 2C EB 28 52 8D 85 94 00 00 00 50 8D B6 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 59 50 FF 36 6A F4 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8D A5 74 FF FF FF 8B 8D 88 00 00 00 E8 ?? ?? ?? ?? 5F 5E 5B 81 C5 8C 00 00 00 C9 C3 }
	condition:
		$1
}

rule file_463_1_0 {
	meta:
		name = "__GET_RTERRMSG"
		size = 42
		refs = "0009 _rterrs"
	strings:
		$1 = { 8B 4C 24 04 33 C0 3B 0C C5 ?? ?? ?? ?? 74 06 40 83 F8 13 72 F1 C1 E0 03 3B 88 ?? ?? ?? ?? 75 07 8B 80 ?? ?? ?? ?? C3 33 C0 C3 }
	condition:
		$1
}

rule file_463_2_0 {
	meta:
		name = "__FF_MSGBANNER"
		size = 57
		refs = "0001 ___error_mode 0010 ___app_type 001d __NMSG_WRITE 0022 __adbgmsg"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 01 74 0D 85 C0 75 2A 83 3D ?? ?? ?? ?? 01 75 21 68 FC 00 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 59 74 02 FF D0 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "@_RTC_Check_2_to_1@4"
		size = 35
		refs = "0019 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 53 8B D9 8B C3 B9 00 FF 00 00 23 C1 74 11 3B C1 74 0D 6A 01 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 8A C3 5B C3 }
	condition:
		$1
}

rule file_464_1_0 {
	meta:
		name = "@_RTC_Check_4_to_1@4"
		size = 35
		refs = "0019 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 53 8B D9 8B C3 B9 00 FF FF FF 23 C1 74 11 3B C1 74 0D 6A 01 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 8A C3 5B C3 }
	condition:
		$1
}

rule file_464_2_0 {
	meta:
		name = "@_RTC_Check_8_to_1@8"
		size = 52
		refs = "0027 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 B9 00 FF FF FF 56 23 C1 8B F0 0B F2 5E 74 16 3B C1 75 05 83 FA FF 74 0D 6A 01 FF 74 24 04 E8 ?? ?? ?? ?? 59 59 8A 44 24 04 C2 08 00 }
	condition:
		$1
}

rule file_464_3_0 {
	meta:
		name = "@_RTC_Check_4_to_2@4"
		size = 36
		refs = "0019 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 56 8B F1 8B C6 B9 00 00 FF FF 23 C1 74 11 3B C1 74 0D 6A 01 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 66 8B C6 5E C3 }
	condition:
		$1
}

rule file_464_4_0 {
	meta:
		name = "@_RTC_Check_8_to_2@8"
		size = 53
		refs = "0027 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 B9 00 00 FF FF 56 23 C1 8B F0 0B F2 5E 74 16 3B C1 75 05 83 FA FF 74 0D 6A 01 FF 74 24 04 E8 ?? ?? ?? ?? 59 59 66 8B 44 24 04 C2 08 00 }
	condition:
		$1
}

rule file_464_5_0 {
	meta:
		name = "@_RTC_Check_8_to_4@8"
		size = 41
		refs = "001c ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 8B 44 24 08 33 C9 8B D1 0B D0 74 16 85 C9 75 05 83 F8 FF 74 0D 6A 01 FF 74 24 04 E8 ?? ?? ?? ?? 59 59 8B 44 24 04 C2 08 00 }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "__mbscmp"
		size = 121
		refs = "0002 ___ismbcodepage 000a _strcmp 0023 __mbctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 05 E9 ?? ?? ?? ?? 56 8B 74 24 0C 57 8B 7C 24 0C 53 66 0F B6 17 0F B6 C2 47 F6 80 ?? ?? ?? ?? 04 74 13 8A 07 84 C0 75 04 33 D2 EB 09 33 C9 8A EA 47 8A C8 8B D1 66 0F B6 06 0F B6 C8 46 F6 81 ?? ?? ?? ?? 04 74 13 8A 0E 84 C9 75 04 33 C0 EB 09 33 DB 8A F8 46 8A D9 8B C3 66 3B C2 75 0B 66 85 D2 75 AE 33 C0 5B 5F 5E C3 1B C0 83 E0 02 48 EB F4 }
	condition:
		$1
}

rule file_467_0_0 {
	meta:
		name = "__fcloseall"
		size = 88
		refs = "0009 __nstream 0010 ___piob 0023 _fclose 003c _free"
	strings:
		$1 = { 56 57 6A 03 5E 33 FF 39 35 ?? ?? ?? ?? 7E 44 A1 ?? ?? ?? ?? 8B 04 B0 85 C0 74 2F F6 40 0C 83 74 0D 50 E8 ?? ?? ?? ?? 83 F8 FF 59 74 01 47 83 FE 14 7C 17 A1 ?? ?? ?? ?? FF 34 B0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 24 B0 00 59 46 3B 35 ?? ?? ?? ?? 7C BC 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_468_0_0 {
	meta:
		name = "__strrev"
		size = 53
	strings:
		$1 = { 55 8B EC 57 56 8B 7D 08 8B D7 8B F7 33 C0 83 C9 FF F2 AE 83 F9 FE 74 17 83 EF 02 3B F7 73 10 8A 26 8A 07 88 06 88 27 83 C6 01 83 EF 01 EB EC 8B C2 5E 5F C9 C3 }
	condition:
		$1
}

rule file_469_0_0 {
	meta:
		name = "__putwch"
		size = 185
		refs = "0007 ___security_cookie 0014 ?use_w@?1??_putwch@@9@9 001f __confh 0027 ___initconout 0042 __imp__WriteConsoleW@20 0055 __imp__GetLastError@0 0074 __imp__GetConsoleOutputCP@0 007b __imp__WideCharToMultiByte@32 008c __putch 00a5 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 56 57 33 FF 33 F6 47 39 35 ?? ?? ?? ?? 89 45 FC 74 47 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 74 7E 56 8D 4D F0 51 57 8D 4D 08 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 61 83 3D ?? ?? ?? ?? 02 75 60 FF 15 ?? ?? ?? ?? 83 F8 78 75 55 89 35 ?? ?? ?? ?? 56 56 6A 05 8D 45 F4 50 57 8D 45 08 50 56 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F8 3B FE 7E 16 0F BE 44 35 F4 50 E8 ?? ?? ?? ?? 83 F8 FF 59 74 1D 46 3B F7 7C EA 66 8B 45 08 8B 4D FC 5F 5E E8 ?? ?? ?? ?? C9 C3 89 3D ?? ?? ?? ?? EB E8 66 0D FF FF EB E6 }
	condition:
		$1
}

rule file_469_1_0 {
	meta:
		name = "__cputws"
		size = 56
		refs = "000b _wcslen 001c __putwch"
	strings:
		$1 = { 53 56 57 8B 7C 24 10 57 33 DB E8 ?? ?? ?? ?? 59 8B F0 EB 15 33 C0 66 8B 07 4E 50 E8 ?? ?? ?? ?? 47 47 66 3D FF FF 59 74 06 85 F6 75 E7 EB 03 83 CB FF 5F 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "_wparse_cmdline"
		size = 361
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 14 8B F0 8B 45 10 33 D2 39 55 0C 89 17 C7 00 01 00 00 00 8B 45 08 74 09 8B 4D 0C 83 45 0C 04 89 31 6A 02 5B 66 83 38 22 75 13 8B 7D 14 33 C9 85 D2 0F 94 C1 6A 22 03 C3 8B D1 59 EB 18 FF 07 85 F6 74 08 66 8B 08 66 89 0E 03 F3 66 8B 08 03 C3 66 85 C9 74 3B 85 D2 75 CB 66 83 F9 20 74 06 66 83 F9 09 75 BF 85 F6 74 05 66 83 66 FE 00 83 65 08 00 33 D2 66 39 10 0F 84 D1 00 00 00 66 8B 08 66 83 F9 20 74 06 66 83 F9 09 75 08 03 C3 EB ED 2B C3 EB DA 66 39 10 0F 84 B1 00 00 00 39 55 0C 74 09 8B 4D 0C 83 45 0C 04 89 31 8B 4D 10 FF 01 33 FF 47 33 D2 EB 03 03 C3 42 66 83 38 5C 74 F7 66 83 38 22 75 2A F6 C2 01 75 23 83 7D 08 00 74 0D 8D 48 02 66 83 39 22 75 04 8B C1 EB 02 33 FF 33 C9 39 4D 08 6A 02 0F 94 C1 5B 89 4D 08 D1 EA 85 D2 74 13 85 F6 74 07 66 C7 06 5C 00 03 F3 8B 4D 14 FF 01 4A 75 ED 66 8B 08 66 85 C9 74 2B 83 7D 08 00 75 0C 66 83 F9 20 74 1F 66 83 F9 09 74 19 85 FF 74 0E 85 F6 74 05 66 89 0E 03 F3 8B 4D 14 FF 01 03 C3 E9 76 FF FF FF 85 F6 74 06 66 83 26 00 03 F3 8B 4D 14 FF 01 E9 24 FF FF FF 8B 45 0C 3B C2 5F 5E 5B 74 02 89 10 8B 45 10 FF 00 5D C3 }
	condition:
		$1
}

rule file_470_1_0 {
	meta:
		name = "__wsetargv"
		size = 150
		refs = "000e ?_pgmname@?1??_wsetargv@@9@9 001f __imp__GetModuleFileNameW@12 0024 __wcmdln 002c __wpgmptr 0048 _wparse_cmdline 0059 _malloc 0085 ___argc 008b ___wargv"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 68 04 01 00 00 BE ?? ?? ?? ?? 33 FF 56 57 66 89 3D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B C7 89 35 ?? ?? ?? ?? 74 07 66 39 38 8B D8 75 02 8B DE 8D 45 F8 50 8D 45 FC 50 57 53 33 C0 E8 ?? ?? ?? ?? 8B 7D FC 8B 45 F8 8D 04 78 D1 E0 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 85 F6 75 05 83 C8 FF EB 26 8D 45 F8 50 8D 45 FC 50 56 8D 04 BE 53 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 10 48 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_471_0_0 {
	meta:
		name = "__mbsdec"
		size = 55
		refs = "000f ___ismbcodepage 0025 __mbctype"
	strings:
		$1 = { 8B 44 24 08 39 44 24 04 72 03 33 C0 C3 83 3D ?? ?? ?? ?? 00 74 1F 8D 48 FF 49 39 4C 24 04 77 0C 0F B6 11 F6 82 ?? ?? ?? ?? 04 75 ED 8B D0 2B D1 83 E2 01 2B C2 48 C3 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "___RTtypeid"
		size = 156
		refs = "0003 $T18980 0008 __SEH_prolog 0014 ??_C@_0CE@FFJAJLDK@Attempted?5a?5typeid?5of?5NULL?5point@ 001c ??0bad_typeid@@QAE@PBD@Z 0021 __TI2?AVbad_typeid@@ 003d __imp__IsBadReadPtr@8 004d __SEH_epilog 0053 ??_C@_0CB@EEENAAHH@Bad?5read?5pointer?5?9?5no?5RTTI?5data?$CB@ 005b ??0__non_rtti_object@@QAE@PBD@Z 0060 __TI3?AV__non_rtti_object@@ 0081 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 0097 __CxxThrowException@8"
	strings:
		$1 = { 6A 30 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 85 C0 75 17 68 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D8 EB 6B 83 65 FC 00 8B 00 8B 70 FC 89 75 E4 6A 08 FF 76 0C FF 15 ?? ?? ?? ?? 85 C0 75 0D 8B 46 0C 83 4D FC FF E8 ?? ?? ?? ?? C3 68 ?? ?? ?? ?? 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 CC EB 2C 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C0 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_472_1_0 {
	meta:
		name = "?FindCompleteObject@@YAPAXPAPAX@Z"
		size = 22
	strings:
		$1 = { 8B 01 8B 50 FC 8B C1 2B 42 04 8B 52 08 85 D2 74 04 2B CA 03 01 C3 }
	condition:
		$1
}

rule file_472_2_0 {
	meta:
		name = "?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 85
		refs = "002a _strcmp"
	strings:
		$1 = { 55 8B EC 51 8B 43 10 83 65 FC 00 83 78 08 00 56 8B 70 0C 57 76 35 8B 3E 8B 07 8B 4D 08 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 06 F6 47 14 01 74 17 FF 45 FC 8B 43 10 8B 4D FC 83 C6 04 3B 48 08 72 CB 33 C0 5F 5E C9 C3 8B C7 EB F8 }
	condition:
		$1
}

rule file_472_3_0 {
	meta:
		name = "?PMDtoOffset@@YAHPAXABUPMD@@@Z"
		size = 31
	strings:
		$1 = { 8B 50 04 33 C9 85 D2 7C 11 8B CA 8B 54 24 04 8B 14 11 56 8B 70 08 03 0C 32 5E 8B 00 03 C1 C3 }
	condition:
		$1
}

rule file_472_4_0 {
	meta:
		name = "___RTCastToVoid"
		size = 93
		refs = "0003 $T19013 0008 __SEH_prolog 0016 __SEH_epilog 0020 ?FindCompleteObject@@YAPAXPAPAX@Z 0042 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 004a ??0__non_rtti_object@@QAE@PBD@Z 004f __TI3?AV__non_rtti_object@@ 0058 __CxxThrowException@8"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 08 85 C9 75 08 33 C0 E8 ?? ?? ?? ?? C3 83 65 FC 00 E8 ?? ?? ?? ?? 83 4D FC FF EB EB 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_472_5_0 {
	meta:
		name = "?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 249
		refs = "0030 _strcmp 0078 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 43 10 83 65 FC 00 83 78 08 00 56 8B 70 0C 57 0F 86 8A 00 00 00 8B 3E 8B 07 8B 4D 14 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 57 83 65 F4 00 83 7F 04 00 8D 46 04 89 45 F8 76 47 8B 45 F8 8B 00 8B 08 8B 55 0C 3B CA 89 45 F0 74 16 83 C2 08 52 83 C1 08 51 E8 ?? ?? ?? ?? 85 C0 59 59 75 14 8B 45 F0 FF 75 08 83 C0 08 E8 ?? ?? ?? ?? 3B 45 10 59 74 6F FF 45 F4 8B 45 F4 83 45 F8 04 3B 47 04 72 B9 FF 45 FC 8B 43 10 8B 4D FC 83 C6 04 3B 48 08 0F 82 76 FF FF FF 8B 43 10 83 65 FC 00 83 78 08 00 8B 78 0C 76 35 8B 37 8B 06 8B 4D 14 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 06 F6 46 14 03 74 1B FF 45 FC 8B 43 10 8B 4D FC 83 C7 04 3B 48 08 72 CB 33 C0 5F 5E C9 C3 8B C7 EB F8 8B C6 EB F4 }
	condition:
		$1
}

rule file_472_6_0 {
	meta:
		name = "?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 309
		refs = "0037 _strcmp 0083 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 0C 8B 43 10 33 D2 39 50 08 56 57 8B 78 0C 89 55 F8 89 55 FC 0F 86 C4 00 00 00 8B 37 8B 06 8B 4D 18 3B C1 74 19 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 84 00 00 00 33 D2 39 56 04 8D 47 04 89 55 F0 89 45 F4 76 76 8B 45 F4 8B 00 8B 08 8B 55 10 3B CA 89 45 EC 74 16 83 C2 08 52 83 C1 08 51 E8 ?? ?? ?? ?? 85 C0 59 59 75 41 8B 45 EC FF 75 08 83 C0 08 E8 ?? ?? ?? ?? 3B 45 14 59 75 2D 83 7D F8 00 74 24 FF 75 08 8D 46 08 E8 ?? ?? ?? ?? FF 75 08 8B D8 8B 45 F8 83 C0 08 E8 ?? ?? ?? ?? 3B C3 59 59 75 76 8B 5D 0C 89 75 F8 FF 45 F0 8B 45 F0 83 45 F4 04 3B 46 04 72 8C 33 D2 FF 45 FC 8B 43 10 8B 4D FC 83 C7 04 3B 48 08 0F 82 43 FF FF FF 8B 45 F8 3B C2 75 45 8B 43 10 39 50 08 8B 78 0C 89 55 FC 76 35 8B 37 8B 06 8B 4D 18 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 06 F6 46 14 03 74 18 FF 45 FC 8B 43 10 8B 4D FC 83 C7 04 3B 48 08 72 CB 33 C0 5F 5E 5B C9 C3 8B C6 EB F7 }
	condition:
		$1
}

rule file_472_7_0 {
	meta:
		name = "___RTDynamicCast"
		size = 224
		refs = "0003 $T19059 0008 __SEH_prolog 0016 __SEH_epilog 0022 ?FindCompleteObject@@YAPAXPAPAX@Z 004c ?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 005d ?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 0069 ?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 007c ?PMDtoOffset@@YAHPAXABUPMD@@@Z 0097 ??_C@_0BC@JNJNLHBP@Bad?5dynamic_cast?$CB?$AA@ 009f ??0bad_cast@@QAE@PBD@Z 00a4 __TI2?AVbad_cast@@ 00c5 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 00cd ??0__non_rtti_object@@QAE@PBD@Z 00d2 __TI3?AV__non_rtti_object@@ 00db __CxxThrowException@8"
	strings:
		$1 = { 6A 34 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 75 08 33 C0 E8 ?? ?? ?? ?? C3 83 65 FC 00 8B CE E8 ?? ?? ?? ?? 8B F8 89 7D DC 8B 06 8B 58 FC 89 5D D8 2B 75 0C 89 75 08 2B F7 89 75 D4 8B 43 10 8B 40 04 FF 75 14 A8 01 75 08 E8 ?? ?? ?? ?? 59 EB 1D 56 FF 75 10 A8 02 75 0B 57 E8 ?? ?? ?? ?? 83 C4 10 EB 0A 53 57 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 85 C0 74 15 83 C0 08 57 E8 ?? ?? ?? ?? 59 03 C7 89 45 E0 83 4D FC FF EB 89 33 C0 89 45 E0 39 45 18 74 F0 68 ?? ?? ?? ?? 8D 4D C8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C8 EB 2C 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? 8D 4D BC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 BC 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_474_0_0 {
	meta:
		name = "__chkstk"
		size = 61
	strings:
		$1 = { 3D 00 10 00 00 73 0E F7 D8 03 C4 83 C0 04 85 00 94 8B 00 50 C3 51 8D 4C 24 08 81 E9 00 10 00 00 2D 00 10 00 00 85 01 3D 00 10 00 00 73 EC 2B C8 8B C4 85 01 8B E1 8B 08 8B 40 04 50 C3 }
	condition:
		$1
}

rule file_475_1_0 {
	meta:
		name = "__wstat64"
		size = 824
		refs = "000f ___security_cookie 001b ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0027 _wcspbrk 0035 _errno 003a __doserrno 0075 _towlower 0083 __getdrive 0095 __imp__FindFirstFileW@8 00a8 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00c7 __wfullpath 00d6 _wcslen 00e1 _IsRootUNCName 00ec __imp__GetDriveTypeW@4 0126 ___loctotime64_t 0165 __imp__FileTimeToLocalFileTime@8 017b __imp__FileTimeToSystemTime@8 02af __imp__FindClose@4 02c0 ___wdtoxmode 02db __allmul 030c __imp__GetLastError@0 0312 __dosmaperr 032c @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 04 FC FF FF 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 56 8B B5 04 04 00 00 68 ?? ?? ?? ?? 56 89 85 F8 03 00 00 E8 ?? ?? ?? ?? 85 C0 59 59 74 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 DE 02 00 00 57 33 FF 66 83 7E 02 3A 75 32 66 8B 06 66 3B C7 74 1B 66 39 7E 04 75 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 B0 02 00 00 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 45 80 53 8D 85 A8 01 00 00 50 56 FF 15 ?? ?? ?? ?? 83 CB FF 3B C3 89 45 8C 0F 85 B1 00 00 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 8A 00 00 00 68 04 01 00 00 8D 45 A0 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 3B F7 74 72 56 E8 ?? ?? ?? ?? 83 F8 03 59 74 09 E8 ?? ?? ?? ?? 85 C0 74 5D 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 51 8B B5 08 04 00 00 53 57 57 57 6A 01 6A 01 68 BC 07 00 00 C7 85 A8 01 00 00 10 00 00 00 89 BD C4 01 00 00 89 BD C8 01 00 00 66 89 BD D4 01 00 00 E8 ?? ?? ?? ?? 8B CA 83 C4 1C 89 46 28 89 56 2C 89 46 20 89 4E 24 89 46 30 89 4E 34 E9 6D 01 00 00 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 C8 01 00 00 8D 45 84 50 8D 85 BC 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 99 01 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 83 01 00 00 0F B7 45 9C 53 50 0F B7 45 9A 8B B5 08 04 00 00 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 83 C4 1C 39 BD B4 01 00 00 89 46 28 89 56 2C 75 12 39 BD B8 01 00 00 75 0A 89 46 20 8B C2 89 46 24 EB 5C 8D 45 84 50 8D 85 B4 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 1D 01 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 07 01 00 00 0F B7 45 9C 53 50 0F B7 45 9A 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 89 56 24 39 BD AC 01 00 00 75 16 39 BD B0 01 00 00 75 0E 8B 46 28 89 46 30 8B 46 2C 89 46 34 EB 5C 8D 45 84 50 8D 85 AC 01 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A3 00 00 00 8D 45 90 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8D 00 00 00 0F B7 45 9C 53 50 0F B7 45 9A 50 0F B7 45 98 50 0F B7 45 96 50 0F B7 45 92 50 0F B7 45 90 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 30 89 56 34 FF 75 8C FF 15 ?? ?? ?? ?? FF B5 04 04 00 00 FF B5 A8 01 00 00 E8 ?? ?? ?? ?? 59 59 6A 01 57 57 FF B5 C4 01 00 00 66 89 46 06 66 C7 46 08 01 00 E8 ?? ?? ?? ?? 8B 8D C8 01 00 00 33 DB 03 C1 89 46 18 8B 45 80 13 D3 48 89 06 89 46 10 89 56 1C 66 89 7E 04 66 89 7E 0C 66 89 7E 0A 33 C0 EB 18 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF 75 8C FF 15 ?? ?? ?? ?? 8B C3 5B 5F 8B 8D F8 03 00 00 5E E8 ?? ?? ?? ?? 81 C5 FC 03 00 00 C9 C3 }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "__mbsncoll"
		size = 85
		refs = "0015 __mbsnbcnt 0028 ___mbcodepage 0038 ___mblcid 003d ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 56 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? FF 75 10 8B F0 FF 75 0C E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 50 FF 75 0C 56 FF 75 08 6A 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 2C 85 C0 5E 75 07 B8 FF FF FF 7F 5D C3 83 C0 FE 5D C3 }
	condition:
		$1
}

rule file_479_0_0 {
	meta:
		name = "_fwscanf"
		size = 22
		refs = "000e __winput"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_496_0_0 {
	meta:
		name = "__spawnlp"
		size = 22
		refs = "000e __spawnvp"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_628_0_0 {
	meta:
		name = "__wspawnlp"
		size = 22
		refs = "000e __wspawnvp"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_565_0_0 {
	meta:
		name = "_fscanf"
		size = 22
		refs = "000e __input"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "_wcsxfrm"
		size = 163
		refs = "0019 ___lc_handle 0029 _wcsncpy 0031 _wcslen 003d ___lc_collate_cp 0052 ___crtLCMapStringW"
	strings:
		$1 = { 55 8B EC 53 57 8B 7D 10 BB FF FF FF 7F 3B FB 76 07 8B C3 E9 87 00 00 00 A1 ?? ?? ?? ?? 85 C0 75 19 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 EB 65 56 FF 35 ?? ?? ?? ?? BE 00 04 00 00 6A 00 6A 00 6A FF FF 75 0C 56 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 27 3B C7 77 3C FF 35 ?? ?? ?? ?? 57 8B 7D 08 57 6A FF FF 75 0C 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 8B C3 EB 16 8B C8 48 85 C9 76 0F 49 66 0F B6 14 0F 66 89 14 4F 75 F4 EB 01 48 5E 5F 5B 5D C3 }
	condition:
		$1
}

rule file_481_0_0 {
	meta:
		name = "__rmtmp"
		size = 60
		refs = "0008 __nstream 000f ___piob 0028 _fclose"
	strings:
		$1 = { 56 57 33 F6 33 FF 39 35 ?? ?? ?? ?? 7E 29 A1 ?? ?? ?? ?? 8B 04 B0 85 C0 74 14 F6 40 0C 83 74 0E 83 78 1C 00 74 08 50 E8 ?? ?? ?? ?? 59 47 46 3B 35 ?? ?? ?? ?? 7C D7 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_482_0_0 {
	meta:
		name = "_fgetc"
		size = 26
		refs = "0014 __filbuf"
		altNames = "_getc"
	strings:
		$1 = { 8B 54 24 04 FF 4A 04 78 09 8B 0A 0F B6 01 41 89 0A C3 52 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_483_0_0 {
	meta:
		name = "_idtab"
		size = 83
		refs = "0002 ___idtabsiz 0008 ___idpairs 0031 _realloc"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? C1 E2 03 56 8B C1 8D 34 0A EB 07 39 38 74 07 83 C0 08 3B C6 72 F5 3B C6 5E 72 2B 85 FF 75 25 83 C2 08 52 51 E8 ?? ?? ?? ?? 85 C0 59 59 74 15 8B 0D ?? ?? ?? ?? FF 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8D 04 C8 C3 33 C0 C3 }
	condition:
		$1
}

rule file_483_1_0 {
	meta:
		name = "__popen"
		size = 871
		refs = "0061 __pipe 0096 __imp__GetCurrentProcess@0 00b6 ___pioinfo 00c7 __imp__DuplicateHandle@28 00d9 __close 00ec __fdopen 0101 _idtab 0111 ??_C@_07CFPBBAOO@COMSPEC?$AA@ 0116 _getenv 0123 _errno 0133 __osver 013b ??_C@_0M@BOIIGAL@command?4com?$AA@ 0144 ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 0152 _memset 0192 _strlen 01a1 ??_C@_04NPFIMJFF@?5?1c?5?$AA@ 01b3 _malloc 01cc _strcpy 01d3 _strcat 01e5 __access 0206 __imp__CreateProcessA@40 0213 ??_C@_04HBHDLLBA@PATH?$AA@ 0235 _free 0265 __mbsrchr 0274 ??_C@_01KICIPPFI@?2?$AA@ 02be __getpath 0304 __imp__CloseHandle@4 0323 _fclose"
	strings:
		$1 = { 55 8D 6C 24 90 81 EC 88 00 00 00 53 33 DB 33 C9 39 5D 78 89 5D 64 89 5D 58 0F 84 3F 03 00 00 56 8B 75 7C 3B F3 0F 84 32 03 00 00 8A 06 3C 77 74 08 3C 72 0F 85 24 03 00 00 8A 46 01 3C 74 75 07 B9 00 40 00 00 EB 09 3C 62 75 05 B9 00 80 00 00 81 C9 80 00 00 00 51 8D 45 40 68 00 04 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 EC 02 00 00 57 33 FF 80 3E 77 75 0B 33 F6 46 89 5D 68 89 75 60 EB 0A 47 33 F6 89 7D 68 89 5D 60 46 89 75 50 89 75 4C FF 15 ?? ?? ?? ?? 6A 02 56 C1 E7 02 53 8D 4C 3D 40 89 4D 48 8B 09 8D 55 5C 52 8B D1 C1 FA 05 8B 14 95 ?? ?? ?? ?? 50 83 E1 1F FF 34 CA 89 7D 3C 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 62 02 00 00 8B 45 48 FF 30 E8 ?? ?? ?? ?? FF 75 7C 8B 45 60 FF 74 85 40 89 5C 3D 4C E8 ?? ?? ?? ?? 83 C4 0C 3B C3 89 45 64 0F 84 37 02 00 00 33 FF E8 ?? ?? ?? ?? 3B C3 89 45 54 0F 84 0F 02 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B C3 59 89 45 6C 75 26 A1 ?? ?? ?? ?? 83 F8 02 74 05 83 F8 0D 75 17 F6 05 ?? ?? ?? ?? 80 C7 45 6C ?? ?? ?? ?? 75 07 C7 45 6C ?? ?? ?? ?? 6A 44 5F 57 8D 45 E8 53 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C4 0C 39 5D 68 89 7D E8 C7 45 14 00 01 00 00 75 08 8B 4D 5C 89 4D 20 EB 0D 39 75 68 8B 08 89 4D 20 8B 4D 5C 74 03 8B 48 08 FF 75 6C 89 4D 24 8B 40 10 89 45 28 E8 ?? ?? ?? ?? FF 75 78 8B F8 E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 03 F8 E8 ?? ?? ?? ?? 8D 44 07 01 50 E8 ?? ?? ?? ?? 8B F8 83 C4 10 3B FB 89 7D 68 0F 84 58 01 00 00 FF 75 6C 57 E8 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? FF 75 78 57 E8 ?? ?? ?? ?? 53 FF 75 6C E8 ?? ?? ?? ?? 83 C4 20 83 F8 FF 74 21 8D 45 2C 50 8D 45 E8 50 53 53 53 6A 01 53 53 57 FF 75 6C FF 15 ?? ?? ?? ?? 89 45 58 E9 E6 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 C7 04 24 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 3B F3 59 75 0E FF 75 68 E8 ?? ?? ?? ?? 59 E9 E0 00 00 00 68 03 01 00 00 56 57 EB 75 38 1E 0F 84 9E 00 00 00 56 E8 ?? ?? ?? ?? 8D 7C 30 FF 8A 07 3C 5C 59 75 0E 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F8 EB 02 3C 2F 74 0D 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 FF 75 6C E8 ?? ?? ?? ?? 56 8B F8 E8 ?? ?? ?? ?? 03 F8 81 FF 04 01 00 00 59 59 73 52 FF 75 6C 56 E8 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 1E 68 03 01 00 00 56 FF 75 78 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 89 45 78 0F 85 78 FF FF FF EB 1C 8D 45 2C 50 8D 45 E8 50 53 53 53 6A 01 53 53 FF 75 68 56 FF 15 ?? ?? ?? ?? 89 45 58 56 E8 ?? ?? ?? ?? 8B 7D 68 59 57 E8 ?? ?? ?? ?? 59 FF 75 5C FF 15 ?? ?? ?? ?? 39 5D 58 8B 45 54 74 0D 8B 4D 2C 89 48 04 8B 4D 64 89 08 EB 3F 89 18 FF 75 64 E8 ?? ?? ?? ?? 8B 45 60 8B 7D 3C 59 89 5C 85 4C 89 5D 64 39 5C 3D 4C 74 0B 8B 45 48 FF 30 E8 ?? ?? ?? ?? 59 8B 45 60 C1 E0 02 39 5C 05 4C 74 0A FF 74 05 40 E8 ?? ?? ?? ?? 59 5F 5E 8B 45 64 5B 83 C5 70 C9 C3 }
	condition:
		$1
}

rule file_483_2_0 {
	meta:
		name = "__pclose"
		size = 80
		refs = "0011 _idtab 001d _fclose 002b __cwait 0038 _errno"
	strings:
		$1 = { 55 8B EC 53 57 8B 7D 08 83 CB FF 85 FF 74 3B 56 E8 ?? ?? ?? ?? 8B F0 85 F6 74 2E 57 E8 ?? ?? ?? ?? 6A 01 FF 76 04 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 3B C3 75 09 83 3D ?? ?? ?? ?? 04 75 03 8B 5D 08 83 26 00 83 66 04 00 5E 5F 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_484_0_0 {
	meta:
		name = "__mbsicmp"
		size = 321
		refs = "0006 ___ismbcodepage 0014 __stricmp 0034 __mbctype 004b ___mbcodepage 005c ___mblcid 0061 ___crtLCMapStringA 00a1 __mbcasemap"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 C9 C3 53 8B 5D 0C 57 BF 00 02 00 00 56 8B 4D 08 66 0F B6 01 0F B6 D0 41 F6 82 ?? ?? ?? ?? 04 89 4D 08 74 53 80 39 00 75 04 33 F6 EB 62 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC 6A 02 50 6A 02 49 51 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 07 66 0F B6 75 FC EB 18 83 F8 02 0F 85 B5 00 00 00 66 0F B6 75 FC 66 0F B6 45 FD C1 E6 08 03 F0 FF 45 08 EB 18 0F B7 C0 F6 80 ?? ?? ?? ?? 10 74 0A 66 0F B6 B0 ?? ?? ?? ?? EB 02 8B F0 66 0F B6 03 0F B6 C8 43 F6 81 ?? ?? ?? ?? 04 74 4F 80 3B 00 75 04 33 C0 EB 5A 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC 6A 02 50 6A 02 8D 43 FF 50 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 07 66 0F B6 45 FC EB 14 83 F8 02 75 3B 66 0F B6 45 FC 66 0F B6 4D FD C1 E0 08 03 C1 43 EB 14 0F B7 C0 F6 80 ?? ?? ?? ?? 10 74 08 66 0F B6 80 ?? ?? ?? ?? 66 3B C6 75 17 66 85 F6 0F 85 FC FE FF FF 33 C0 5E 5F 5B C9 C3 B8 FF FF FF 7F EB F4 1B C0 83 E0 02 48 EB EC }
	condition:
		$1
}

rule file_485_0_0 {
	meta:
		name = "__lrotl"
		size = 29
		altNames = "__rotl"
	strings:
		$1 = { 83 64 24 08 1F 8B 54 24 04 6A 20 59 2B 4C 24 08 8B C2 D3 E8 8B 4C 24 08 D3 E2 0B C2 C3 }
	condition:
		$1
}

rule file_486_0_0 {
	meta:
		name = "___lconv_init"
		size = 45
		refs = "0003 ___lconv_c"
	strings:
		$1 = { 0C FF A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_487_0_0 {
	meta:
		name = "_strcpy"
		size = 16
	strings:
		$1 = { 57 8B 7C 24 08 EB 6E 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_487_1_0 {
	meta:
		name = "_strcat"
		size = 232
	strings:
		$1 = { 8B 4C 24 04 57 F7 C1 03 00 00 00 74 13 8A 01 83 C1 01 84 C0 74 3D F7 C1 03 00 00 00 75 EF 8B FF 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 23 84 E4 74 1A A9 00 00 FF 00 74 0E A9 00 00 00 FF 74 02 EB CD 8D 79 FF EB 0D 8D 79 FE EB 08 8D 79 FD EB 03 8D 79 FC 8B 4C 24 0C F7 C1 03 00 00 00 74 1D 8A 11 83 C1 01 84 D2 74 66 88 17 83 C7 01 F7 C1 03 00 00 00 75 EA EB 05 89 17 83 C7 04 BA FF FE FE 7E 8B 01 03 D0 83 F0 FF 33 C2 8B 11 83 C1 04 A9 00 01 01 81 74 E1 84 D2 74 34 84 F6 74 27 F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 74 02 EB C7 89 17 8B 44 24 08 5F C3 66 89 17 8B 44 24 08 C6 47 02 00 5F C3 66 89 17 8B 44 24 08 5F C3 88 17 8B 44 24 08 5F C3 }
	condition:
		$1
}

rule file_488_0_0 {
	meta:
		name = "__RTC_InitBase"
		size = 38
		refs = "0004 ?init@?1??_RTC_InitBase@@9@4_NA 0018 __CRT_RTC_INIT 001e __RTC_SetErrorFunc"
	strings:
		$1 = { 33 C0 38 05 ?? ?? ?? ?? 75 1B 50 6A 01 50 50 50 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 C3 }
	condition:
		$1
}

rule file_488_1_0 {
	meta:
		name = "__RTC_Shutdown"
		size = 18
		refs = "000a __CRT_RTC_INIT"
	strings:
		$1 = { 6A 01 33 C0 6A 01 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_489_0_0 {
	meta:
		name = "_vwprintf"
		size = 48
		refs = "0004 __iob 000a __stbuf 001a __woutput 0023 __ftbuf"
	strings:
		$1 = { 53 56 57 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? FF 74 24 18 8B F8 FF 74 24 18 56 E8 ?? ?? ?? ?? 56 57 8B D8 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_623_0_0 {
	meta:
		name = "_vprintf"
		size = 48
		refs = "0004 __iob 000a __stbuf 001a __output 0023 __ftbuf"
	strings:
		$1 = { 53 56 57 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? FF 74 24 18 8B F8 FF 74 24 18 56 E8 ?? ?? ?? ?? 56 57 8B D8 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_490_0_0 {
	meta:
		name = "__ismbcprint"
		size = 137
		refs = "0023 ___ismbcodepage 0035 ___mblcid 003e ___mbcodepage 004c ___crtGetStringTypeA 0070 __pctype 007e __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5C 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 74 54 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 2E 66 83 7D FE 00 75 27 66 F7 45 FC 57 01 74 1F 33 C0 40 C9 C3 0F B6 C1 8B 0D ?? ?? ?? ?? 66 F7 04 41 57 01 75 EA F6 80 ?? ?? ?? ?? 03 75 E1 33 C0 C9 C3 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "__SEH_prolog"
		size = 59
		refs = "0001 __except_handler3"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 8B 45 F8 89 65 E8 50 8B 45 FC C7 45 FC FF FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_491_1_0 {
	meta:
		name = "__SEH_epilog"
		size = 17
	strings:
		$1 = { 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B C9 51 C3 }
	condition:
		$1
}

rule file_492_0_0 {
	meta:
		name = "__mbsnicoll"
		size = 85
		refs = "0015 __mbsnbcnt 0028 ___mbcodepage 0038 ___mblcid 003d ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 56 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? FF 75 10 8B F0 FF 75 0C E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 50 FF 75 0C 56 FF 75 08 6A 01 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 2C 85 C0 5E 75 07 B8 FF FF FF 7F 5D C3 83 C0 FE 5D C3 }
	condition:
		$1
}

rule file_493_0_0 {
	meta:
		name = "_fdiv_main_routine"
		size = 279
		refs = "0028 fdiv_risc_table 006e fdiv_scale_1 0085 fdiv_scale_2 00f8 one_shl_63"
	strings:
		$1 = { DB 6C 24 10 DB 6C 24 04 8B 44 24 08 03 C0 0F 83 86 00 00 00 35 00 00 00 0E A9 00 00 00 0E 74 03 DE F9 C3 C1 E8 1C 80 B8 ?? ?? ?? ?? 00 75 03 DE F9 C3 8B 44 24 0C 25 FF 7F 00 00 74 67 3D FF 7F 00 00 74 60 D9 7C 24 1C 8B 44 24 1C 0D 3F 03 00 00 25 FF F3 00 00 89 44 24 20 D9 6C 24 20 8B 44 24 18 25 FF 7F 00 00 83 F8 01 74 17 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 D9 6C 24 1C DE F9 C3 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 D9 6C 24 1C DE F9 C3 8B 44 24 04 0B 44 24 08 75 03 DE F9 C3 8B 44 24 0C 25 FF 7F 00 00 75 F2 D9 7C 24 1C 8B 44 24 1C 0D 3F 03 00 00 25 FF F3 00 00 89 44 24 20 D9 6C 24 20 8B 44 24 18 25 FF 7F 00 00 74 11 3D FF 7F 00 00 74 32 8B 44 24 14 03 C0 73 2A EB 08 8B 44 24 14 03 C0 72 20 D9 C9 DD D8 D9 C0 D8 0D ?? ?? ?? ?? DB 7C 24 04 DB 6C 24 10 D9 C9 9B D9 6C 24 1C E9 F8 FE FF FF D9 6C 24 1C DE F9 C3 }
	condition:
		$1
}

rule file_493_1_0 {
	meta:
		name = "__adj_fdiv_r"
		size = 1183
		refs = "0009 dispatch_table"
	strings:
		$1 = { 83 EC 2C 83 E0 3F FF 24 85 ?? ?? ?? ?? D8 F0 83 C4 2C C3 83 C4 2C CD 06 D8 F8 83 C4 2C C3 83 C4 2C CD 06 D8 F0 83 C4 2C C3 DE F8 83 C4 2C C3 D8 F8 83 C4 2C C3 DE F0 83 C4 2C C3 DB 7C 24 0C D9 C0 DB 3C 24 DB 7C 24 20 E8 9C FE FF FF DB 6C 24 20 D9 C9 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 DB 7C 24 0C E8 81 FE FF FF DB 6C 24 0C D9 C9 83 C4 2C C3 83 C4 2C CD 06 D9 C9 DB 7C 24 0C D9 C0 DB 3C 24 DB 7C 24 20 E8 5E FE FF FF DB 6C 24 20 83 C4 2C C3 DB 3C 24 DB 7C 24 0C E8 4A FE FF FF 83 C4 2C C3 DB 7C 24 0C DB 3C 24 E8 3A FE FF FF DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C DB 3C 24 E8 26 FE FF FF 83 C4 2C C3 DB 7C 24 0C D9 C9 D9 C0 DB 3C 24 DB 7C 24 20 E8 0E FE FF FF D9 C9 DB 6C 24 20 D9 CA 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 C9 DB 7C 24 0C E8 EF FD FF FF D9 C9 DB 6C 24 0C D9 CA 83 C4 2C C3 83 C4 2C CD 06 D9 CA DB 7C 24 0C D9 C9 D9 C0 DB 3C 24 DB 7C 24 20 E8 C8 FD FF FF D9 C9 DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 C9 DB 7C 24 0C E8 B0 FD FF FF D9 C9 83 C4 2C C3 DB 7C 24 0C D9 C9 DB 3C 24 E8 9C FD FF FF D9 C9 DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 C9 DB 3C 24 E8 84 FD FF FF D9 C9 83 C4 2C C3 DB 7C 24 0C D9 CA D9 C0 DB 3C 24 DB 7C 24 20 E8 6A FD FF FF D9 CA DB 6C 24 20 D9 CB 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CA DB 7C 24 0C E8 4B FD FF FF D9 CA DB 6C 24 0C D9 CB 83 C4 2C C3 83 C4 2C CD 06 D9 CB DB 7C 24 0C D9 CA D9 C0 DB 3C 24 DB 7C 24 20 E8 24 FD FF FF D9 CA DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CA DB 7C 24 0C E8 0C FD FF FF D9 CA 83 C4 2C C3 DB 7C 24 0C D9 CA DB 3C 24 E8 F8 FC FF FF D9 CA DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CA DB 3C 24 E8 E0 FC FF FF D9 CA 83 C4 2C C3 DB 7C 24 0C D9 CB D9 C0 DB 3C 24 DB 7C 24 20 E8 C6 FC FF FF D9 CB DB 6C 24 20 D9 CC 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CB DB 7C 24 0C E8 A7 FC FF FF D9 CB DB 6C 24 0C D9 CC 83 C4 2C C3 83 C4 2C CD 06 D9 CC DB 7C 24 0C D9 CB D9 C0 DB 3C 24 DB 7C 24 20 E8 80 FC FF FF D9 CB DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CB DB 7C 24 0C E8 68 FC FF FF D9 CB 83 C4 2C C3 DB 7C 24 0C D9 CB DB 3C 24 E8 54 FC FF FF D9 CB DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CB DB 3C 24 E8 3C FC FF FF D9 CB 83 C4 2C C3 DB 7C 24 0C D9 CC D9 C0 DB 3C 24 DB 7C 24 20 E8 22 FC FF FF D9 CC DB 6C 24 20 D9 CD 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CC DB 7C 24 0C E8 03 FC FF FF D9 CC DB 6C 24 0C D9 CD 83 C4 2C C3 83 C4 2C CD 06 D9 CD DB 7C 24 0C D9 CC D9 C0 DB 3C 24 DB 7C 24 20 E8 DC FB FF FF D9 CC DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CC DB 7C 24 0C E8 C4 FB FF FF D9 CC 83 C4 2C C3 DB 7C 24 0C D9 CC DB 3C 24 E8 B0 FB FF FF D9 CC DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CC DB 3C 24 E8 98 FB FF FF D9 CC 83 C4 2C C3 DB 7C 24 0C D9 CD D9 C0 DB 3C 24 DB 7C 24 20 E8 7E FB FF FF D9 CD DB 6C 24 20 D9 CE 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CD DB 7C 24 0C E8 5F FB FF FF D9 CD DB 6C 24 0C D9 CE 83 C4 2C C3 83 C4 2C CD 06 D9 CE DB 7C 24 0C D9 CD D9 C0 DB 3C 24 DB 7C 24 20 E8 38 FB FF FF D9 CD DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CD DB 7C 24 0C E8 20 FB FF FF D9 CD 83 C4 2C C3 DB 7C 24 0C D9 CD DB 3C 24 E8 0C FB FF FF D9 CD DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CD DB 3C 24 E8 F4 FA FF FF D9 CD 83 C4 2C C3 DB 7C 24 0C D9 CE D9 C0 DB 3C 24 DB 7C 24 20 E8 DA FA FF FF D9 CE DB 6C 24 20 D9 CF 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CE DB 7C 24 0C E8 BB FA FF FF D9 CE DB 6C 24 0C D9 CF 83 C4 2C C3 83 C4 2C CD 06 D9 CF DB 7C 24 0C D9 CE D9 C0 DB 3C 24 DB 7C 24 20 E8 94 FA FF FF D9 CE DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CE DB 7C 24 0C E8 7C FA FF FF D9 CE 83 C4 2C C3 DB 7C 24 0C D9 CE DB 3C 24 E8 68 FA FF FF D9 CE DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CE DB 3C 24 E8 50 FA FF FF D9 CE 83 C4 2C C3 }
	condition:
		$1
}

rule file_493_2_0 {
	meta:
		name = "__fdivp_sti_st"
		size = 19
	strings:
		$1 = { 83 EC 2C DB 3C 24 DB 7C 24 0C E8 3B FA FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_493_3_0 {
	meta:
		name = "__fdivrp_sti_st"
		size = 19
	strings:
		$1 = { 83 EC 2C DB 7C 24 0C DB 3C 24 E8 28 FA FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_493_4_0 {
	meta:
		name = "__adj_fdiv_m32"
		size = 76
	strings:
		$1 = { 50 8B 44 24 08 25 00 00 80 7F 3D 00 00 80 7F 74 33 DF E0 25 00 38 00 00 74 0D D9 44 24 08 E8 B7 FF FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 D9 44 24 14 E8 A2 FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 D8 74 24 08 58 C2 04 00 }
	condition:
		$1
}

rule file_493_5_0 {
	meta:
		name = "__adj_fdiv_m64"
		size = 76
	strings:
		$1 = { 50 8B 44 24 0C 25 00 00 F0 7F 3D 00 00 F0 7F 74 33 DF E0 25 00 38 00 00 74 0D DD 44 24 08 E8 6B FF FF FF 58 C2 08 00 D9 C9 83 EC 0C DB 3C 24 DD 44 24 14 E8 56 FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 08 00 DC 74 24 08 58 C2 08 00 }
	condition:
		$1
}

rule file_493_6_0 {
	meta:
		name = "__adj_fdiv_m16i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DF 44 24 08 E8 2F FF FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DF 44 24 14 E8 1A FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_493_7_0 {
	meta:
		name = "__adj_fdiv_m32i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DB 44 24 08 E8 FB FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DB 44 24 14 E8 E6 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_493_8_0 {
	meta:
		name = "__adj_fdivr_m32"
		size = 76
	strings:
		$1 = { 50 8B 44 24 08 25 00 00 80 7F 3D 00 00 80 7F 74 33 DF E0 25 00 38 00 00 74 0D D9 44 24 08 E8 CA FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 D9 44 24 14 E8 B5 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 D8 7C 24 08 58 C2 04 00 }
	condition:
		$1
}

rule file_493_9_0 {
	meta:
		name = "__adj_fdivr_m64"
		size = 76
	strings:
		$1 = { 50 8B 44 24 0C 25 00 00 F0 7F 3D 00 00 F0 7F 74 33 DF E0 25 00 38 00 00 74 0D DD 44 24 08 E8 7E FE FF FF 58 C2 08 00 D9 C9 83 EC 0C DB 3C 24 DD 44 24 14 E8 69 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 08 00 DC 7C 24 08 58 C2 08 00 }
	condition:
		$1
}

rule file_493_10_0 {
	meta:
		name = "__adj_fdivr_m16i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DF 44 24 08 E8 42 FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DF 44 24 14 E8 2D FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_493_11_0 {
	meta:
		name = "__adj_fdivr_m32i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DB 44 24 08 E8 0E FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DB 44 24 14 E8 F9 FD FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_493_12_0 {
	meta:
		name = "__safe_fdiv"
		size = 21
	strings:
		$1 = { 50 83 EC 2C DB 3C 24 DB 7C 24 0C E8 14 F8 FF FF 83 C4 2C 58 C3 }
	condition:
		$1
}

rule file_493_13_0 {
	meta:
		name = "__safe_fdivr"
		size = 21
	strings:
		$1 = { 50 83 EC 2C DB 7C 24 0C DB 3C 24 E8 FF F7 FF FF 83 C4 2C 58 C3 }
	condition:
		$1
}

rule file_493_14_0 {
	meta:
		name = "__fprem_common"
		size = 518
		refs = "001f fprem_risc_table 0163 half 017e big_number 01cf one_shr_64"
	strings:
		$1 = { 50 53 51 8B 44 24 16 35 00 07 00 00 A9 00 07 00 00 0F 85 83 01 00 00 C1 E8 0B 83 E0 0F 80 B8 ?? ?? ?? ?? 00 0F 84 70 01 00 00 8B 44 24 16 25 00 00 FF 7F 3D 00 00 FF 7F 0F 84 5C 01 00 00 8B 44 24 2E 25 00 00 FF 7F 0F 84 4D 01 00 00 3D 00 00 FF 7F 0F 84 42 01 00 00 8B 44 24 2C 03 C0 0F 85 36 01 00 00 8B 44 24 14 03 C0 0F 85 2A 01 00 00 8B 44 24 18 25 FF 7F 00 00 83 C0 3F 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 77 5E 8B 44 24 18 25 FF 7F 00 00 83 C0 0A 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 0F 88 F2 00 00 00 DB 6C 24 28 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 8B CB 2B D8 83 E3 07 83 CB 04 2B CB 8B D8 81 E3 00 80 00 00 0B CB 89 4C 24 18 DB 6C 24 10 89 44 24 18 D9 C9 D9 F8 DB 7C 24 28 DD D8 EB A2 F7 C2 02 00 00 00 75 08 DB 6C 24 10 DB 7C 24 1C D9 7C 24 34 8B 44 24 34 0D 3F 03 00 00 89 44 24 38 D9 6C 24 38 8B 44 24 18 25 FF 7F 00 00 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 83 E3 3F 83 CB 20 83 C3 01 8B CB 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 25 00 80 00 00 0B D8 89 5C 24 18 DB 6C 24 10 D9 E1 DB 6C 24 28 D9 E1 D8 D1 DF E0 25 00 01 00 00 75 02 D8 E1 D9 C9 DC 0D ?? ?? ?? ?? D9 C9 83 E9 01 75 E4 8B 5C 24 30 DB 7C 24 28 DD D8 DB 6C 24 1C DB 2D ?? ?? ?? ?? D9 F8 DD D8 DB 6C 24 28 D9 6C 24 34 81 E3 00 80 00 00 74 0E D9 E0 EB 0A DB 6C 24 10 DB 6C 24 28 D9 F8 F7 C2 03 00 00 00 74 56 DD 7C 24 3C F7 C2 01 00 00 00 74 1F D9 7C 24 34 8B 44 24 34 0D 00 03 00 00 89 44 24 38 D9 6C 24 38 DC 0D ?? ?? ?? ?? D9 6C 24 34 8B 44 24 3C D9 C9 DD D8 DB 6C 24 1C D9 C9 25 00 43 00 00 83 EC 1C D9 34 24 81 64 24 04 FF BC 00 00 09 44 24 04 D9 24 24 83 C4 1C 59 5B 58 C3 }
	condition:
		$1
}

rule file_493_15_0 {
	meta:
		name = "__adj_fprem"
		size = 178
		refs = "006a one_shl_64"
	strings:
		$1 = { 52 83 EC 30 DB 7C 24 18 DB 3C 24 33 D2 8B 44 24 06 A9 00 00 FF 7F 74 0A E8 DD FD FF FF 83 C4 30 5A C3 DB 2C 24 DB 6C 24 18 8B 04 24 0B 44 24 04 74 79 D9 C9 DB 7C 24 0C DB 2C 24 D9 C9 83 CA 02 D9 7C 24 24 8B 44 24 24 0D 3F 03 00 00 89 44 24 28 D9 6C 24 28 8B 44 24 20 25 FF 7F 00 00 3D BE 7F 00 00 77 18 83 CA 01 DC 0D ?? ?? ?? ?? DB 7C 24 18 DC 0D ?? ?? ?? ?? DB 3C 24 EB 20 D9 7C 24 24 8B 44 24 24 0D 00 03 00 00 89 44 24 28 D9 6C 24 28 DD D8 DC 0D ?? ?? ?? ?? DB 3C 24 D9 6C 24 24 E8 54 FD FF FF 83 C4 30 5A C3 D9 F8 83 C4 30 5A C3 }
	condition:
		$1
}

rule file_493_16_0 {
	meta:
		name = "__fprem1_common"
		size = 518
		refs = "001f fprem_risc_table 0163 half 017e big_number 01cf one_shr_64"
	strings:
		$1 = { 50 53 51 8B 44 24 16 35 00 07 00 00 A9 00 07 00 00 0F 85 83 01 00 00 C1 E8 0B 83 E0 0F 80 B8 ?? ?? ?? ?? 00 0F 84 70 01 00 00 8B 44 24 16 25 00 00 FF 7F 3D 00 00 FF 7F 0F 84 5C 01 00 00 8B 44 24 2E 25 00 00 FF 7F 0F 84 4D 01 00 00 3D 00 00 FF 7F 0F 84 42 01 00 00 8B 44 24 2C 03 C0 0F 85 36 01 00 00 8B 44 24 14 03 C0 0F 85 2A 01 00 00 8B 44 24 18 25 FF 7F 00 00 83 C0 3F 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 77 5E 8B 44 24 18 25 FF 7F 00 00 83 C0 0A 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 0F 88 F2 00 00 00 DB 6C 24 28 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 8B CB 2B D8 83 E3 07 83 CB 04 2B CB 8B D8 81 E3 00 80 00 00 0B CB 89 4C 24 18 DB 6C 24 10 89 44 24 18 D9 C9 D9 F8 DB 7C 24 28 DD D8 EB A2 F7 C3 02 00 00 00 75 08 DB 6C 24 10 DB 7C 24 1C D9 7C 24 34 8B 44 24 34 0D 3F 03 00 00 89 44 24 38 D9 6C 24 38 8B 44 24 18 25 FF 7F 00 00 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 83 E3 3F 83 CB 20 83 C3 01 8B CB 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 25 00 80 00 00 0B D8 89 5C 24 18 DB 6C 24 10 D9 E1 DB 6C 24 28 D9 E1 D8 D1 DF E0 25 00 01 00 00 75 02 D8 E1 D9 C9 DC 0D ?? ?? ?? ?? D9 C9 83 E9 01 75 E4 8B 5C 24 30 DB 7C 24 28 DD D8 DB 6C 24 1C DB 2D ?? ?? ?? ?? D9 F5 DD D8 DB 6C 24 28 D9 6C 24 34 81 E3 00 80 00 00 74 0E D9 E0 EB 0A DB 6C 24 10 DB 6C 24 28 D9 F5 F7 C2 03 00 00 00 74 56 DD 7C 24 3C F7 C2 01 00 00 00 74 1F D9 7C 24 34 8B 44 24 34 0D 00 03 00 00 89 44 24 38 D9 6C 24 38 DC 0D ?? ?? ?? ?? D9 6C 24 34 8B 44 24 3C D9 C9 DD D8 DB 6C 24 1C D9 C9 25 00 43 00 00 83 EC 1C D9 34 24 81 64 24 04 FF BC 00 00 09 44 24 04 D9 24 24 83 C4 1C 59 5B 58 C3 }
	condition:
		$1
}

rule file_493_17_0 {
	meta:
		name = "__adj_fprem1"
		size = 181
		refs = "006d one_shl_64"
	strings:
		$1 = { 52 83 EC 30 DB 7C 24 18 DB 3C 24 BA 00 00 00 00 8B 44 24 06 A9 00 00 FF 7F 74 0A E8 DA FD FF FF 83 C4 30 5A C3 DB 2C 24 DB 6C 24 18 8B 04 24 0B 44 24 04 74 79 D9 C9 DB 7C 24 0C DB 2C 24 D9 C9 83 CA 02 D9 7C 24 24 8B 44 24 24 0D 3F 03 00 00 89 44 24 28 D9 6C 24 28 8B 44 24 20 25 FF 7F 00 00 3D BE 7F 00 00 77 18 83 CA 01 DC 0D ?? ?? ?? ?? DB 7C 24 18 DC 0D ?? ?? ?? ?? DB 3C 24 EB 20 D9 7C 24 24 8B 44 24 24 0D 00 03 00 00 89 44 24 28 D9 6C 24 28 DD D8 DC 0D ?? ?? ?? ?? DB 3C 24 D9 6C 24 24 E8 51 FD FF FF 83 C4 30 5A C3 D9 F8 83 C4 30 5A C3 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "__setdefaultprecision"
		size = 18
		refs = "000b __controlfp"
	strings:
		$1 = { 68 00 00 03 00 68 00 00 01 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_498_0_0 {
	meta:
		name = "_report_failure"
		size = 49
		refs = "0003 $T19804 0008 __SEH_prolog 0015 ___security_error_handler 002c __imp__ExitProcess@4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 6A 00 6A 01 E8 ?? ?? ?? ?? 59 59 EB 07 33 C0 40 C3 8B 65 E8 83 4D FC FF 6A 03 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_500_0_0 {
	meta:
		name = "_vswprintf"
		size = 110
		refs = "0029 __woutput 0049 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 56 FF 75 10 89 45 E8 FF 75 0C 89 45 E0 8D 45 E0 50 C7 45 EC 42 00 00 00 C7 45 E4 FF FF FF 7F E8 ?? ?? ?? ?? 83 C4 0C FF 4D E4 8B F0 78 0B 8B 45 E0 C6 00 00 FF 45 E0 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_501_0_0 {
	meta:
		name = "__stripquote"
		size = 74
		refs = "0008 _strlen 000f _malloc 0040 _free"
	strings:
		$1 = { 56 57 8B F0 56 33 FF E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 2C 8A 0E 84 C9 8B D0 74 1D 80 F9 22 75 04 46 47 EB 04 88 08 40 46 8A 0E 84 C9 75 ED 85 FF 74 06 88 08 8B C2 EB 09 52 E8 ?? ?? ?? ?? 59 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_501_1_0 {
	meta:
		name = "__tempnam"
		size = 393
		refs = "000b ??_C@_03FICNPLNB@TMP?$AA@ 0016 _getenv 0027 __access 0034 __stripquote 0067 ??_C@_01KICIPPFI@?2?$AA@ 0078 ??_C@_01LFCBOECM@?4?$AA@ 0085 _strlen 00a8 _malloc 00bd _strcat 00d8 __mbsrchr 0113 __old_pfxlen 011c __tempoff 014d __ultoa 0162 _errno 016d _free"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 33 FF 68 ?? ?? ?? ?? 89 7D F8 89 7D FC E8 ?? ?? ?? ?? 8B F0 83 CB FF 3B F7 59 74 2D 57 56 E8 ?? ?? ?? ?? 3B C3 59 59 75 4B 8B C6 E8 ?? ?? ?? ?? 3B C7 89 45 FC 74 12 57 50 E8 ?? ?? ?? ?? 3B C3 59 59 74 05 8B 75 FC EB 2B 8B 75 08 3B F7 74 0D 57 56 E8 ?? ?? ?? ?? 3B C3 59 59 75 17 57 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 3B C3 59 59 75 05 BE ?? ?? ?? ?? 39 7D 0C 74 0C FF 75 0C E8 ?? ?? ?? ?? 59 89 45 F8 56 E8 ?? ?? ?? ?? 59 8B 4D F8 8D 44 08 0C 3D 04 01 00 00 0F 87 D0 00 00 00 50 E8 ?? ?? ?? ?? 8B D8 3B DF 59 0F 84 C2 00 00 00 56 53 C6 03 00 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8D 7C 30 FF 8A 07 83 C4 0C 3C 5C 75 0E 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F8 EB 02 3C 2F 74 0D 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 83 7D 0C 00 74 0B FF 75 0C 53 E8 ?? ?? ?? ?? 59 59 53 E8 ?? ?? ?? ?? 8B F0 8B 45 F8 03 F3 39 05 ?? ?? ?? ?? 59 73 0A C7 05 ?? ?? ?? ?? 01 00 00 00 8B 3D ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B C7 3D FF 7F 00 00 77 28 6A 0A 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 CF 83 3D ?? ?? ?? ?? 0D 74 C6 EB 0E 53 E8 ?? ?? ?? ?? 59 33 DB EB 03 8B 5D 0C FF 75 FC E8 ?? ?? ?? ?? 59 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_502_0_0 {
	meta:
		name = "_fputws"
		size = 61
		refs = "000b _wcslen 0020 _fputwc"
	strings:
		$1 = { 53 56 8B 74 24 0C 57 56 33 DB E8 ?? ?? ?? ?? 59 8B F8 EB 1A FF 74 24 14 33 C0 66 8B 06 4F 50 E8 ?? ?? ?? ?? 46 59 46 66 3D FF FF 59 74 06 85 FF 75 E2 EB 03 83 CB FF 5F 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_503_0_0 {
	meta:
		name = "__allshr"
		size = 33
	strings:
		$1 = { 80 F9 40 73 16 80 F9 20 73 06 0F AD D0 D3 FA C3 8B C2 C1 FA 1F 80 E1 1F D3 F8 C3 C1 FA 1F 8B C2 C3 }
	condition:
		$1
}

rule file_504_0_0 {
	meta:
		name = "___crtMessageBoxA"
		size = 249
		refs = "000b ?pfnMessageBoxA@?1??__crtMessageBoxA@@9@9 0014 ??_C@_0L@GMPLCCII@user32?4dll?$AA@ 001a __imp__LoadLibraryA@4 002a __imp__GetProcAddress@8 002f ??_C@_0M@CHKKJDAI@MessageBoxA?$AA@ 0040 ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 0048 ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 004e ?pfnGetActiveWindow@?1??__crtMessageBoxA@@9@9 0056 __osplatform 005c ?pfnGetLastActivePopup@?1??__crtMessageBoxA@@9@9 0063 ??_C@_0BK@CIDNPOGP@GetUserObjectInformationA?$AA@ 006d ?pfnGetUserObjectInformationA@?1??__crtMessageBoxA@@9@9 0074 ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 007c ?pfnGetProcessWindowStation@?1??__crtMessageBoxA@@9@9 00ae __winmajor"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 33 DB 39 1D ?? ?? ?? ?? 56 57 75 6D 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 3B FB 0F 84 93 00 00 00 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D6 85 C0 A3 ?? ?? ?? ?? 74 7C 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 83 3D ?? ?? ?? ?? 02 A3 ?? ?? ?? ?? 75 1E 68 ?? ?? ?? ?? 57 FF D6 85 C0 A3 ?? ?? ?? ?? 74 0D 68 ?? ?? ?? ?? 57 FF D6 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 3C FF D0 85 C0 74 1D 8D 4D FC 51 6A 0C 8D 4D F0 51 6A 01 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 F6 45 F8 01 75 19 83 3D ?? ?? ?? ?? 04 72 0A 80 4D 12 20 EB 29 33 C0 EB 35 80 4D 12 04 EB 1F A1 ?? ?? ?? ?? 85 C0 74 16 FF D0 8B D8 85 DB 74 0E A1 ?? ?? ?? ?? 85 C0 74 05 53 FF D0 8B D8 FF 75 10 FF 75 0C FF 75 08 53 FF 15 ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_505_0_0 {
	meta:
		name = "__except_handler3"
		size = 230
		refs = "0035 __ValidateEH3RN 0071 __global_unwind2 007e __local_unwind2 008f __NLG_Notify"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 0F 85 AB 00 00 00 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 FC 8B 73 0C 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 0B C0 74 7B 83 FE FF 74 7D 8D 0C 76 8B 44 8F 04 0B C0 74 59 56 55 8D 6B 10 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 5D 5E 8B 5D 0C 0B C0 74 3F 78 48 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8D 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 6A 01 8B 44 8F 08 E8 ?? ?? ?? ?? 8B 04 8F 89 43 0C 8B 44 8F 08 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 8B 7B 08 8D 0C 76 8B 34 8F EB 8C B8 00 00 00 00 EB 23 8B 45 08 83 48 04 08 B8 01 00 00 00 EB 15 55 8D 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_505_1_0 {
	meta:
		name = "__seh_longjmp_unwind@4"
		size = 27
		refs = "0010 __local_unwind2"
	strings:
		$1 = { 55 8B 4C 24 08 8B 29 8B 41 1C 50 8B 41 18 50 E8 ?? ?? ?? ?? 83 C4 08 5D C2 04 00 }
	condition:
		$1
}

rule file_506_0_0 {
	meta:
		name = "_wcstok"
		size = 163
		refs = "0011 ?nextoken@?1??wcstok@@9@9"
	strings:
		$1 = { 55 8B EC 8B 4D 08 53 33 DB 3B CB 56 57 75 06 8B 0D ?? ?? ?? ?? 66 8B 01 66 3B C3 74 30 8B 55 0C 33 FF 66 8B 3A 66 3B FB 8B 55 0C 74 11 8B F7 66 3B F0 74 0A 42 42 66 8B 32 66 3B F3 75 F1 66 39 1A 74 0A 41 41 66 8B 01 66 3B C3 75 D8 66 39 19 89 4D 08 74 37 8B 45 0C 33 FF 66 8B 38 66 3B FB 8B 55 0C 74 14 66 8B 31 8B C7 66 3B C6 74 0A 42 42 66 8B 02 66 3B C3 75 F1 66 39 1A 75 09 41 41 66 39 19 75 D8 EB 05 66 89 19 41 41 8B 45 08 2B C1 F7 D8 5F 1B C0 23 45 08 5E 89 0D ?? ?? ?? ?? 5B 5D C3 }
	condition:
		$1
}

rule file_507_0_0 {
	meta:
		name = "__EH_prolog2"
		size = 55
	strings:
		$1 = { 51 8B 4C 24 08 89 5C 24 08 8D 5C 24 08 F7 D9 23 E1 8B 4B F8 89 2C 24 8B EC 6A FF 50 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 51 8B 43 FC 8B 4B 04 89 4D 04 59 50 C3 }
	condition:
		$1
}

rule file_508_0_0 {
	meta:
		name = "__wgetdcwd"
		size = 238
		refs = "000a ___security_cookie 001b __validdrive 0026 __doserrno 0030 _errno 003f @__security_check_cookie@4 0077 __imp__GetFullPathNameW@16 008c __imp__GetCurrentDirectoryW@8 00ac _malloc 00e3 _wcscpy"
	strings:
		$1 = { 55 8B EC 81 EC 18 02 00 00 A1 ?? ?? ?? ?? 56 8B 75 08 85 F6 89 45 FC 74 64 56 E8 ?? ?? ?? ?? 85 C0 59 75 21 C7 05 ?? ?? ?? ?? 0F 00 00 00 C7 05 ?? ?? ?? ?? 0D 00 00 00 33 C0 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C3 66 83 65 FA 00 8D 85 E8 FD FF FF 50 83 C6 40 8D 85 EC FD FF FF 50 66 89 75 F4 BE 04 01 00 00 56 8D 45 F4 50 66 C7 45 F6 3A 00 66 C7 45 F8 2E 00 FF 15 ?? ?? ?? ?? EB 13 8D 85 EC FD FF FF 50 BE 04 01 00 00 56 FF 15 ?? ?? ?? ?? 85 C0 74 A4 40 3B C6 77 9F 8B 4D 0C 85 C9 75 26 3B 45 10 7F 03 8B 45 10 03 C0 50 E8 ?? ?? ?? ?? 59 8B C8 85 C9 75 23 C7 05 ?? ?? ?? ?? 0C 00 00 00 E9 72 FF FF FF 3B 45 10 7E 0F C7 05 ?? ?? ?? ?? 22 00 00 00 E9 5E FF FF FF 8D 85 EC FD FF FF 50 51 E8 ?? ?? ?? ?? 59 59 E9 4C FF FF FF }
	condition:
		$1
}

rule file_509_0_0 {
	meta:
		name = "__CIatan_pentium4"
		size = 748
		refs = "002a _mabs 0032 _in 0046 _in1 0050 _in0 006e _p01 007a _p23 0086 _p45 0092 _p60 00be _in2 00dc _d01 00e8 _d23 00f4 _d45 0100 _d67 010c _d89 0118 _d1011 0124 _d1213 0130 _d1400 0164 _in3 016e _cnst8 0176 _cntshf 0197 __atan_table 01ab _one 01c6 _onen 0254 _zero 0263 _minval 026b libm_small 029f _mexp 02bd _pi_2d 02df ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 3C 24 E8 08 00 00 00 C9 C3 F3 0F 7E 7C 24 04 66 0F 14 FF 66 0F 28 D7 66 0F 54 15 ?? ?? ?? ?? 66 0F 2F 15 ?? ?? ?? ?? 0F 8A 86 02 00 00 0F 83 55 02 00 00 66 0F 2F 15 ?? ?? ?? ?? 73 6E 66 0F 2F 15 ?? ?? ?? ?? 0F 82 F6 01 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 0F 83 90 00 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 F3 0F 7E F7 66 0F 57 F2 66 0F 2F 15 ?? ?? ?? ?? 73 4F F3 0F 7E 05 ?? ?? ?? ?? F3 0F 7E 2D ?? ?? ?? ?? F3 0F 7E DA F2 0F 58 D8 66 0F 73 D3 2C 66 0F FA DD 66 0F 7E D8 8D 04 40 F3 0F 7E 2C C5 ?? ?? ?? ?? F3 0F 7E DA F2 0F 5C D5 F2 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 0F 5E D3 66 0F 14 D2 EB 19 B8 00 03 00 00 F3 0F 7E C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 14 D2 F3 0F 7E 04 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EA F2 0F 5C EC F2 0F 5C EA F2 0F 5C C5 66 0F 56 C6 66 0F D6 44 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 75 05 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 73 1D DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 04 24 83 C4 08 DC 44 24 04 C3 DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 44 24 04 C3 F3 0F 7E C2 F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 C3 66 0F 2E C3 7A 15 8B 44 24 08 C1 E8 1F DD 05 ?? ?? ?? ?? DC 04 C5 ?? ?? ?? ?? C3 BA EB 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 90 }
	condition:
		$1
}

rule file_511_0_0 {
	meta:
		name = "__mbsstr"
		size = 143
		refs = "0005 ___ismbcodepage 000e _strstr 0029 _strlen 006c __mbctype"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 8B 45 0C 80 38 00 75 05 8B 45 08 5D C3 53 56 8B 75 08 57 50 8B FE E8 ?? ?? ?? ?? 8B DE 56 2B D8 E8 ?? ?? ?? ?? 59 03 D8 80 3E 00 59 74 44 2B 75 0C 3B FB 77 3D 8A 17 84 D2 8B 45 0C 74 12 8A 08 84 C9 74 35 38 0C 06 75 07 40 80 3C 06 00 75 EE 80 38 00 74 24 0F B6 C2 8A 80 ?? ?? ?? ?? 24 04 47 46 84 C0 74 07 80 3F 00 74 07 47 46 80 3F 00 75 BF 33 C0 5F 5E 5B 5D C3 8B C7 EB F7 }
	condition:
		$1
}

rule file_514_0_0 {
	meta:
		name = "_strlen"
		size = 139
	strings:
		$1 = { 8B 4C 24 04 F7 C1 03 00 00 00 74 24 8A 01 83 C1 01 84 C0 74 4E F7 C1 03 00 00 00 75 EF 05 00 00 00 00 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 32 84 E4 74 24 A9 00 00 FF 00 74 13 A9 00 00 00 FF 74 02 EB CD 8D 41 FF 8B 4C 24 04 2B C1 C3 8D 41 FE 8B 4C 24 04 2B C1 C3 8D 41 FD 8B 4C 24 04 2B C1 C3 8D 41 FC 8B 4C 24 04 2B C1 C3 }
	condition:
		$1
}

rule file_515_0_0 {
	meta:
		name = "__setjmp"
		size = 56
		refs = "001a __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 06 8B 40 0C 89 42 1C 2B C0 C3 }
	condition:
		$1
}

rule file_516_0_0 {
	meta:
		name = "__strupr"
		size = 251
		refs = "0003 $T19488 0008 __SEH_prolog 0012 ___lc_handle 0046 ___lc_codepage 0058 ___crtLCMapStringA 0074 __alloca_probe 008a __resetstkoflw 009e _malloc 00dd _strcpy 00ea _free 00f6 __SEH_epilog"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 A1 ?? ?? ?? ?? 3B C3 75 28 8B 45 08 8B D0 38 18 0F 84 CB 00 00 00 8A 0A 80 F9 61 7C 0A 80 F9 7A 7F 05 80 E9 20 88 0A 42 38 1A 75 EA E9 B0 00 00 00 6A 01 FF 35 ?? ?? ?? ?? 53 53 6A FF FF 75 08 68 00 02 00 00 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 E4 3B C3 0F 84 85 00 00 00 89 5D FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B F4 89 75 DC EB 10 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 33 F6 83 4D FC FF 3B F3 75 16 FF 75 E4 E8 ?? ?? ?? ?? 59 8B F0 C7 45 E0 01 00 00 00 3B F3 74 33 6A 01 FF 35 ?? ?? ?? ?? FF 75 E4 56 6A FF FF 75 08 68 00 02 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 0B 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 39 5D E0 74 07 56 E8 ?? ?? ?? ?? 59 8B 45 08 8D 65 D0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_517_0_0 {
	meta:
		name = "__mbsncmp"
		size = 143
		refs = "000f ___ismbcodepage 0018 _strncmp 0032 __mbctype"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 56 8B 75 08 57 8B 7D 0C 53 66 0F B6 0E FF 4D 10 0F B6 C1 46 F6 80 ?? ?? ?? ?? 04 74 13 8A 06 84 C0 75 04 33 C9 EB 09 33 D2 8A F1 46 8A D0 8B CA 66 0F B6 07 0F B6 D0 47 F6 82 ?? ?? ?? ?? 04 74 13 8A 17 84 D2 75 04 33 C0 EB 09 33 DB 8A F8 47 8A DA 8B C3 66 3B C1 75 12 66 85 C9 74 06 83 7D 10 00 75 A5 33 C0 5B 5F 5E 5D C3 1B C0 83 E0 02 48 EB F3 }
	condition:
		$1
}

rule file_518_0_0 {
	meta:
		name = "__wcenvarg"
		size = 563
		refs = "0015 _wcslen 002c _malloc 0042 _errno 004c __doserrno 0081 __wenvptr 008a ___crtGetEnvironmentStringsW 00ba _wcscpy 016c _free 01d8 _memcpy"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 8B 03 56 57 6A 02 8B FB 5E EB 10 50 E8 ?? ?? ?? ?? 83 C7 04 8D 74 06 01 8B 07 59 85 C0 75 EC 8D 04 36 50 E8 ?? ?? ?? ?? 85 C0 59 8B 4D 10 89 01 75 1C 8B 45 14 83 20 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 EB 41 8B 75 0C 85 F6 74 42 C7 45 FC 02 00 00 00 EB 14 50 E8 ?? ?? ?? ?? 59 8B 4D FC 8D 44 01 01 89 45 FC 83 C6 04 8B 06 85 C0 75 E6 A1 ?? ?? ?? ?? 85 C0 75 4B E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 75 3D 83 C8 FF E9 8F 01 00 00 8B 45 14 83 20 00 8B 7D 10 8B 45 10 8B 30 8B 03 85 C0 0F 84 F4 00 00 00 50 56 E8 ?? ?? ?? ?? FF 33 E8 ?? ?? ?? ?? 83 C4 0C 8D 74 46 02 83 C3 04 E9 D9 00 00 00 83 65 08 00 66 83 38 00 6A 3D 5E 74 2B 66 8B 10 8B C8 66 3B D6 74 21 51 E8 ?? ?? ?? ?? 59 8B 4D 08 8D 4C 01 01 A1 ?? ?? ?? ?? 89 4D 08 8D 0C 48 66 8B 11 66 85 D2 75 DA 8B 7D 08 8B CF 8D 0C 48 EB 2D 66 83 79 02 00 74 2B 66 83 7C 78 04 3A 75 23 66 39 74 78 06 75 1C 8D 44 78 08 50 E8 ?? ?? ?? ?? 8D 7C 07 05 A1 ?? ?? ?? ?? 59 8D 0C 78 66 39 31 74 CE 8B C7 2B 45 08 03 45 FC D1 E0 50 E8 ?? ?? ?? ?? 85 C0 59 8B 4D 14 89 01 0F 85 42 FF FF FF 8B 75 10 FF 36 E8 ?? ?? ?? ?? 83 26 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 C7 05 ?? ?? ?? ?? 08 00 00 00 83 C8 FF E9 9E 00 00 00 50 56 E8 ?? ?? ?? ?? FF 33 E8 ?? ?? ?? ?? 8D 34 46 83 C4 0C 83 C3 04 66 C7 06 20 00 46 46 8B 03 85 C0 75 DC 39 45 0C 8B 4D 14 66 89 46 FE 66 89 06 8B 31 74 40 8B 45 08 8B 0D ?? ?? ?? ?? 2B F8 D1 E7 57 8D 04 41 50 56 E8 ?? ?? ?? ?? 83 C4 0C 03 F7 8B 7D 0C EB 18 50 56 E8 ?? ?? ?? ?? FF 37 E8 ?? ?? ?? ?? 83 C4 0C 8D 74 46 02 83 C7 04 8B 07 85 C0 75 E2 85 F6 74 11 8B 45 14 3B 30 75 06 66 83 26 00 46 46 66 83 26 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 33 C0 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_519_0_0 {
	meta:
		name = "_strtoxq"
		size = 647
		refs = "001d ___mb_cur_max 002e __isctype 0038 __pctype 00e3 __aulldvrm 0153 _toupper 01a2 __allmul 0220 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 28 83 65 F0 00 83 65 F4 00 56 57 8B 7D 08 8A 07 8D 77 01 89 75 F8 83 3D ?? ?? ?? ?? 01 88 45 FF 0F B6 C0 7E 0C 6A 08 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 08 85 C0 74 05 8A 06 46 EB CF 80 7D FF 2D 89 75 F8 75 06 83 4D 14 02 EB 06 80 7D FF 2B 75 09 8A 06 46 88 45 FF 89 75 F8 8B 45 10 85 C0 0F 8C 01 02 00 00 83 F8 01 0F 84 F8 01 00 00 83 F8 24 0F 8F EF 01 00 00 85 C0 6A 10 59 75 25 80 7D FF 30 74 09 C7 45 10 0A 00 00 00 EB 35 8A 06 3C 78 74 0D 3C 58 74 09 C7 45 10 08 00 00 00 EB 22 89 4D 10 39 4D 10 75 1A 80 7D FF 30 75 14 8A 06 3C 78 74 04 3C 58 75 0A 46 8A 06 46 88 45 FF 89 75 F8 8B 45 10 53 99 52 8B F8 57 6A FF 6A FF 89 55 DC E8 ?? ?? ?? ?? 89 5D E4 89 4D E0 89 45 E8 89 55 EC BB 03 01 00 00 83 3D ?? ?? ?? ?? 01 0F B6 75 FF 7E 0C 6A 04 56 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 70 83 E0 04 85 C0 74 09 0F BE 75 FF 83 EE 30 EB 33 83 3D ?? ?? ?? ?? 01 7E 0B 53 56 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B7 04 70 23 C3 85 C0 74 75 0F BE 45 FF 50 E8 ?? ?? ?? ?? 8B F0 59 83 EE 37 3B 75 10 73 60 8B 4D F4 83 4D 14 08 3B 4D EC 72 2B 77 08 8B 45 F0 3B 45 E8 72 21 8B 45 E8 39 45 F0 75 13 3B 4D EC 75 0E 33 C0 3B 45 E4 72 0D 77 05 3B 75 E0 76 06 83 4D 14 04 EB 19 51 FF 75 F0 FF 75 DC 57 E8 ?? ?? ?? ?? 33 C9 03 C6 13 D1 89 45 F0 89 55 F4 8B 45 F8 8A 00 FF 45 F8 88 45 FF E9 36 FF FF FF 8B 5D 14 FF 4D F8 F6 C3 08 75 15 33 C0 39 45 0C 74 06 8B 4D 08 89 4D F8 89 45 F0 89 45 F4 EB 67 F6 C3 04 B9 FF FF FF 7F BA 00 00 00 80 75 2A F6 C3 01 75 53 8B C3 83 E0 02 74 0D 39 55 F4 77 19 72 06 83 7D F0 00 77 11 85 C0 75 3B 39 4D F4 72 36 77 06 83 7D F0 FF 76 2E F6 C3 01 C7 05 ?? ?? ?? ?? 22 00 00 00 74 0A 83 4D F0 FF 83 4D F4 FF EB 15 F6 C3 02 74 09 83 65 F0 00 89 55 F4 EB 07 83 4D F0 FF 89 4D F4 8B 45 0C 85 C0 74 05 8B 4D F8 89 08 F6 C3 02 5B 74 13 8B 45 F0 8B 4D F4 F7 D8 83 D1 00 F7 D9 89 45 F0 89 4D F4 8B 45 F0 8B 55 F4 EB 0D 8B 45 0C 85 C0 74 02 89 38 33 C0 33 D2 5F 5E C9 C3 }
	condition:
		$1
}

rule file_521_0_0 {
	meta:
		name = "_fgetws"
		size = 73
		refs = "0018 _fgetwc"
	strings:
		$1 = { 55 8B EC 83 7D 0C 00 56 57 8B 7D 08 8B F7 7F 22 33 C0 EB 29 FF 75 10 E8 ?? ?? ?? ?? 0F B7 C0 3D FF FF 00 00 59 74 1A 66 89 06 46 46 66 3D 0A 00 74 05 FF 4D 0C 75 DD 66 83 26 00 8B C7 5F 5E 5D C3 3B F7 75 F2 33 FF EB F2 }
	condition:
		$1
}

rule file_522_0_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 18
		refs = "000e ?terminate@@YAXXZ"
	strings:
		$1 = { 8B 00 81 38 63 73 6D E0 74 03 33 C0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_522_1_0 {
	meta:
		name = "?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
		size = 94
		refs = "0003 $T18548 0008 __SEH_prolog 0028 __SEH_epilog 0059 ?terminate@@YAXXZ"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 4D 10 78 0E 8B 4D 08 2B 4D 0C 89 4D 08 FF 55 14 EB ED 83 4D FC FF E8 ?? ?? ?? ?? C2 10 00 8B 45 EC 89 45 E4 8B 45 E4 8B 00 89 45 E0 8B 45 E0 81 38 63 73 6D E0 74 10 C7 45 DC 00 00 00 00 8B 45 DC C3 8B 65 E8 EB CB E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_522_2_0 {
	meta:
		name = "??_M@YGXPAXIHP6EX0@Z@Z"
		size = 96
		refs = "0003 $T18567 0008 __SEH_prolog 0041 __SEH_epilog 005b ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 8B 75 0C 8B C6 0F AF 45 10 01 45 08 83 65 FC 00 FF 4D 10 78 0B 29 75 08 8B 4D 08 FF 55 14 EB F0 C7 45 E4 01 00 00 00 83 4D FC FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 10 00 83 7D E4 00 75 11 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_525_0_0 {
	meta:
		name = "__87except"
		size = 248
		refs = "000d ___security_cookie 0062 __handle_exc 00ad __raise_exc 00be __ctrlfp 00cb __matherr_flag 00d4 __matherr 00e0 __set_errno 00ed @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 E4 F0 81 EC 84 00 00 00 A1 ?? ?? ?? ?? 89 84 24 80 00 00 00 8B 45 10 0F B7 08 53 56 8B 75 0C 8B 06 48 57 89 4C 24 0C 74 2B 48 74 24 48 74 1D 48 74 16 48 74 1F 48 48 74 07 48 75 74 6A 10 EB 16 C7 06 01 00 00 00 EB 68 6A 12 EB 0A 6A 11 EB 06 6A 04 EB 02 6A 08 5B 51 8D 7E 18 57 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 47 8B 45 08 83 F8 10 74 11 83 F8 16 74 0C 83 F8 1D 74 07 83 64 24 50 FE EB 15 8B 4C 24 50 DD 46 10 83 E1 E3 DD 5C 24 40 83 C9 03 89 4C 24 50 57 8D 4E 08 51 50 53 8D 44 24 1C 50 8D 44 24 24 50 E8 ?? ?? ?? ?? 83 C4 18 68 FF FF 00 00 FF 74 24 10 E8 ?? ?? ?? ?? 83 3E 08 59 59 74 14 83 3D ?? ?? ?? ?? 00 75 0B 56 E8 ?? ?? ?? ?? 85 C0 59 75 08 FF 36 E8 ?? ?? ?? ?? 59 8B 8C 24 8C 00 00 00 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_526_0_0 {
	meta:
		name = "__fstat"
		size = 634
		refs = "000f __nhandle 0024 ___pioinfo 0044 __imp__GetFileType@4 006a _errno 00d2 __imp__PeekNamedPipe@24 0109 __imp__GetFileInformationByHandle@8 0113 __imp__GetLastError@0 0119 __dosmaperr 0141 __imp__FileTimeToLocalFileTime@8 0157 __imp__FileTimeToSystemTime@8 0186 ___loctotime_t"
	strings:
		$1 = { 55 8B EC 83 EC 54 53 57 8B 7D 08 33 DB 3B 3D ?? ?? ?? ?? 89 5D FC 0F 83 4D 02 00 00 8B C7 C1 F8 05 8D 04 85 ?? ?? ?? ?? 83 E7 1F 89 45 F8 8B 00 C1 E7 03 03 C7 F6 40 04 01 0F 84 2A 02 00 00 56 FF 30 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 8C 00 00 00 83 F8 02 74 24 83 F8 03 74 2A 3B C3 0F 85 A9 00 00 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 4D FC FF 8B 45 FC 5E E9 F7 01 00 00 8B 75 0C 66 C7 46 06 00 20 EB 09 8B 75 0C 66 C7 46 06 00 10 83 F8 02 8B 4D 08 89 0E 89 4E 10 66 C7 46 08 01 00 66 89 5E 04 66 89 5E 0C 66 89 5E 0A 89 5E 20 89 5E 1C 89 5E 18 75 05 89 5E 14 EB B6 53 8D 45 08 50 8B 45 F8 8B 00 53 53 53 FF 34 38 FF 15 ?? ?? ?? ?? F7 D8 1B C0 23 45 08 89 46 14 EB 94 8B 75 0C 8D 45 AC 50 8B 45 F8 66 89 5E 06 66 89 5E 0C 66 89 5E 0A 66 89 5E 04 66 C7 46 08 01 00 8B 00 FF 34 38 FF 15 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E9 4F FF FF FF F6 45 AC 01 74 08 66 81 4E 06 24 01 EB 06 66 81 4E 06 B6 01 8D 45 F0 50 8D 45 C0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 25 FF FF FF 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 0F FF FF FF 0F B7 45 EC 83 CF FF 57 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 39 5D B8 89 46 1C 75 05 39 5D BC 74 53 8D 45 F0 50 8D 45 B8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B1 00 00 00 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 9B 00 00 00 0F B7 45 EC 57 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 39 5D B0 89 46 18 75 0A 39 5D B4 75 05 8B 46 1C EB 4B 8D 45 F0 50 8D 45 B0 50 FF 15 ?? ?? ?? ?? 85 C0 74 50 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 74 3E 0F B7 45 EC 57 50 0F B7 45 EA 50 0F B7 45 E8 50 0F B7 45 E6 50 0F B7 45 E2 50 0F B7 45 E0 50 E8 ?? ?? ?? ?? 83 C4 1C 80 4E 07 80 89 46 20 8B 45 D0 89 46 14 89 1E 89 5E 10 E9 15 FE FF FF 89 7D FC E9 0D FE FF FF C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5B C9 C3 }
	condition:
		$1
}

rule file_527_0_0 {
	meta:
		name = "_puts"
		size = 103
		refs = "0005 __iob 000e __stbuf 0019 _strlen 0028 _fwrite 004f __flsbuf 005a __ftbuf"
	strings:
		$1 = { 53 55 56 57 BE ?? ?? ?? ?? 56 83 CB FF E8 ?? ?? ?? ?? FF 74 24 18 8B E8 E8 ?? ?? ?? ?? 56 8B F8 57 6A 01 FF 74 24 28 E8 ?? ?? ?? ?? 83 C4 18 3B C7 75 24 FF 0D ?? ?? ?? ?? 78 10 A1 ?? ?? ?? ?? C6 00 0A FF 05 ?? ?? ?? ?? EB 0A 56 6A 0A E8 ?? ?? ?? ?? 59 59 33 DB 56 55 E8 ?? ?? ?? ?? 59 59 5F 5E 5D 8B C3 5B C3 }
	condition:
		$1
}

rule file_530_0_0 {
	meta:
		name = "_fputwc"
		size = 210
		refs = "0007 ___security_cookie 002e ___pioinfo 003b ___badioinfo 004d _wctomb 005c _errno 008f __flsbuf 00bf __flswbuf 00cc @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 53 56 8B 75 0C F6 46 0C 40 89 45 FC 57 0F 85 87 00 00 00 8B 46 10 83 F8 FF 74 14 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F 8D 04 C1 EB 05 B8 ?? ?? ?? ?? F6 40 04 80 74 60 FF 75 08 8D 45 F4 50 E8 ?? ?? ?? ?? 8B D8 83 FB FF 59 59 75 10 C7 05 ?? ?? ?? ?? 2A 00 00 00 66 0D FF FF EB 5B 33 FF 85 DB 7E 2F FF 4E 04 78 12 8B 06 8A 4C 3D F4 88 08 8B 0E 0F B6 01 41 89 0E EB 0E 0F BE 44 3D F4 56 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 CA 47 3B FB 7C D1 66 8B 45 08 EB 20 83 46 04 FE 78 0D 8B 0E 8B 45 08 66 89 01 83 06 02 EB 0D 0F B7 45 08 56 50 E8 ?? ?? ?? ?? 59 59 8B 4D FC 5F 5E 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_532_0_0 {
	meta:
		name = "_isleadbyte"
		size = 21
		refs = "0007 __pctype"
	strings:
		$1 = { 0F B6 44 24 04 8B 0D ?? ?? ?? ?? 0F B7 04 41 25 00 80 00 00 C3 }
	condition:
		$1
}

rule file_533_0_0 {
	meta:
		name = "__wsystem"
		size = 150
		refs = "0008 ??_C@_1BA@HMCCKBDK@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 000d __wgetenv 0029 __waccess 003b ??_C@_15JBFELBFC@?$AA?1?$AAc?$AA?$AA@ 004f __wspawnve 005d _errno 006d __osver 0075 ??_C@_1BI@LHBFHNF@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@ 007e ??_C@_1BA@DBKIDAPL@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 008c __wspawnvpe"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D 08 33 F6 3B CE 89 45 F0 75 18 3B C6 75 04 33 C0 EB 6D 56 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 40 EB 5D 3B C6 C7 45 F4 ?? ?? ?? ?? 89 4D F8 89 75 FC 74 24 56 8D 4D F0 51 50 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 38 8B 0D ?? ?? ?? ?? 83 F9 02 74 05 83 F9 0D 75 28 F6 05 ?? ?? ?? ?? 80 C7 45 F0 ?? ?? ?? ?? 75 07 C7 45 F0 ?? ?? ?? ?? 56 8D 45 F0 50 FF 75 F0 56 E8 ?? ?? ?? ?? 83 C4 10 5E C9 C3 }
	condition:
		$1
}

rule file_705_0_0 {
	meta:
		name = "_system"
		size = 150
		refs = "0008 ??_C@_07CFPBBAOO@COMSPEC?$AA@ 000d _getenv 0029 __access 003b ??_C@_02HNHPBPFE@?1c?$AA@ 004f __spawnve 005d _errno 006d __osver 0075 ??_C@_0M@BOIIGAL@command?4com?$AA@ 007e ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 008c __spawnvpe"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D 08 33 F6 3B CE 89 45 F0 75 18 3B C6 75 04 33 C0 EB 6D 56 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 40 EB 5D 3B C6 C7 45 F4 ?? ?? ?? ?? 89 4D F8 89 75 FC 74 24 56 8D 4D F0 51 50 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 38 8B 0D ?? ?? ?? ?? 83 F9 02 74 05 83 F9 0D 75 28 F6 05 ?? ?? ?? ?? 80 C7 45 F0 ?? ?? ?? ?? 75 07 C7 45 F0 ?? ?? ?? ?? 56 8D 45 F0 50 FF 75 F0 56 E8 ?? ?? ?? ?? 83 C4 10 5E C9 C3 }
	condition:
		$1
}

rule file_535_0_0 {
	meta:
		name = "_issnanf"
		size = 33
	strings:
		$1 = { 8B 44 24 04 25 00 00 C0 7F 3D 00 00 80 7F 75 0E F7 44 24 04 FF FF 3F 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_535_1_0 {
	meta:
		name = "_isnanf"
		size = 32
	strings:
		$1 = { 8B 4C 24 04 B8 00 00 80 7F 23 C8 3B C8 75 0E F7 44 24 04 FF FF 7F 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_535_5_0 {
	meta:
		name = "_XMMI_FP_Emulation"
		size = 3778
		refs = "0051 $L24529 0058 $L24587 0076 _isdenormalf 007c __real@00000000 00b4 $L24588 0123 __control87 017a __statusfp 019b _Fill_FPIEEE_RECORD 01bf _isnanf 0270 _MIN_SINGLE_NORMALA 0281 __real@0000000000000000 02a9 _NEGINFFA 02b1 _MAX_SINGLE_NORMALA 02d6 _POSINFFA 02fa _TWO_TO_192A 0335 _TWO_TO_M192A 0459 _ZEROFA 0475 _NZEROFA 061e $L24530 0625 $L24589 0631 _issnanf 06e8 $L24531 06ef $L24590 075b $L24532 0762 $L24591 0e3e $L24151 0e42 $L24439 0e46 $L24397 0e4a $L24251 0e4e $L24316 0e52 $L24351 0e56 $L24364 0e72 $L24161 0e7a $L24162 0e82 $L24163 0e8a $L24164 0e92 $L24261 0e96 $L24266 0ea2 $L24312 0ea6 $L24311"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 DB E3 8B 75 08 8B 46 20 8B 08 33 4E 10 83 65 EC 00 83 65 E8 00 83 E1 03 31 08 8B 4E 14 8B 46 20 C1 E1 02 33 08 BF FF 0F 00 00 83 E1 1C 31 08 8B 4E 20 8B 11 C1 EA 05 23 D7 8D 5A D5 83 FB 17 0F 87 EF 04 00 00 0F B6 83 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7E 0C 00 D9 41 10 D9 5D 08 D9 41 30 D9 5D FC 74 3E D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? D9 05 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 D9 45 08 D8 C9 D9 5D 08 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 D9 45 FC D8 C9 D9 5D FC DD D8 83 FB 07 77 39 FF 24 9D ?? ?? ?? ?? 8B 01 25 3F 00 FE FF 83 C8 20 EB 24 8B 01 25 5F 00 FE FF 83 C8 40 EB 18 8B 01 25 7F 00 FE FF 83 C8 60 EB 0C 8B 01 25 9F 00 FE FF 0D 80 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 15 B8 00 02 00 00 EB 0E B8 00 01 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 23 C7 48 59 59 74 36 48 74 24 48 74 12 48 75 3A DB E2 D9 45 08 D9 45 FC DE F9 DD 5D F4 EB 2B DB E2 D9 45 08 D9 45 FC DE C9 DD 5D F4 EB 1C DB E2 D9 45 08 D9 45 FC DE E9 DD 5D F4 EB 0D DB E2 D9 45 08 D9 45 FC DE C1 DD 5D F4 E8 ?? ?? ?? ?? A8 08 89 45 F0 74 04 80 65 F2 F7 8B 06 33 DB 43 84 C3 75 25 F6 45 F0 10 74 1F 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 09 5E 04 8B 76 20 83 4E 04 10 8B C3 E9 86 03 00 00 D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 0F 85 76 03 00 00 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 0F 85 61 03 00 00 8B 06 A8 02 BA 00 00 08 00 75 12 85 55 F0 74 0D 8B C6 E8 ?? ?? ?? ?? 83 4E 04 02 EB B2 A8 04 75 21 F6 45 F0 08 74 1B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 08 83 4E 04 04 8B 76 20 83 4E 04 08 EB 8D DD 45 F4 51 D9 55 F8 D9 45 F8 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 74 2B 8B 46 20 DD D8 09 58 60 D9 45 F8 8B 46 20 D9 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE E9 BE 09 00 00 85 55 F0 74 04 83 4E 04 02 DD 05 ?? ?? ?? ?? D9 E0 D8 D9 DF E0 F6 C4 05 7A 0D DC 15 ?? ?? ?? ?? DF E0 F6 C4 05 7B 18 D9 EE D8 D9 DF E0 F6 C4 05 7A 10 DC 15 ?? ?? ?? ?? DF E0 F6 C4 05 7A 03 89 5D EC D9 05 ?? ?? ?? ?? D8 D9 DD 05 ?? ?? ?? ?? DF E0 F6 C4 05 7A 0F D9 C0 D9 E0 D9 C2 DE D9 DF E0 F6 C4 05 7B 1C D8 D9 DF E0 F6 C4 05 7A 18 D9 05 ?? ?? ?? ?? D9 C1 DE D9 DF E0 F6 C4 05 7A 07 EB 02 DD D8 89 5D E8 8B 06 A8 10 75 37 83 7D EC 00 74 31 DD 05 ?? ?? ?? ?? 8B C6 D8 C9 DD 5D F4 DD D8 E8 ?? ?? ?? ?? 8B 46 20 DD 45 F4 83 48 0C 02 D9 5D 08 8B 46 20 D9 45 08 83 4E 04 10 83 48 04 02 EB 39 A8 08 75 59 83 7D E8 00 74 53 DD 05 ?? ?? ?? ?? 8B C6 D8 C9 DD 5D F4 DD D8 E8 ?? ?? ?? ?? 8B 46 20 DD 45 F4 83 48 0C 04 D9 5D 08 8B 46 20 D9 45 08 83 4E 04 08 83 48 04 04 8B 46 20 09 58 60 84 5D F0 8B 46 20 D9 58 50 0F 84 39 FE FF FF 8B 46 20 09 58 0C 83 4E 04 20 E9 2A FE FF FF 8B 46 20 DD D8 8B 00 C1 E8 05 23 C7 48 74 30 48 74 20 48 74 10 48 75 32 D9 45 08 D9 45 FC DE F9 D9 5D F8 EB 25 D9 45 08 D9 45 FC DE C9 D9 5D F8 EB 18 D9 45 08 D9 45 FC DE E9 D9 5D F8 EB 0B D9 45 08 D9 45 FC DE C1 D9 5D F8 E8 ?? ?? ?? ?? 33 FF F6 06 20 8B C8 0F 85 9F 00 00 00 84 CB 75 12 39 7E 08 0F 84 92 00 00 00 39 7D EC 0F 84 89 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 39 7D EC 74 0B 8B 46 20 83 48 0C 02 83 4E 04 10 39 7D E8 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 7E 08 0F 84 D9 05 00 00 39 7D EC 0F 84 D0 05 00 00 D9 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 08 D9 05 ?? ?? ?? ?? EB 1A D9 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 0F 8A A4 05 00 00 D9 05 ?? ?? ?? ?? D9 5D F8 E9 96 05 00 00 8B 46 20 09 58 60 F6 C1 02 8B 46 20 74 0A 83 48 0C 02 83 4E 04 10 EB 04 83 60 0C FD F6 C1 04 8B 46 20 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 84 CB 8B 46 20 74 09 09 58 0C 83 4E 04 20 EB 04 83 60 0C FE 39 7E 08 74 4B 39 7D EC 74 46 D9 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 08 D9 05 ?? ?? ?? ?? EB 16 D9 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 09 D9 05 ?? ?? ?? ?? D9 5D F8 8B 46 20 09 58 0C 83 4E 04 20 8B 46 20 83 48 0C 02 83 4E 04 10 F6 C1 08 D9 45 F8 8B 46 20 D9 58 50 8B 46 20 0F 84 89 07 00 00 83 48 0C 08 83 4E 04 04 8B 76 20 83 66 0C EF 33 C0 5F 5E 5B C9 C3 8B 46 20 D9 45 08 09 58 60 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 74 20 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 74 0F D9 45 08 D9 5D 08 80 4D 0A 40 D9 45 08 EB 09 DD 45 F4 D9 5D 08 D9 45 08 8B 46 20 D9 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 45 F0 10 74 8A E9 7B 06 00 00 83 7E 0C 00 D9 41 10 D9 5D 08 D9 41 30 D9 5D FC 74 3E D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? D9 05 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 D9 45 08 D8 C9 D9 5D 08 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 D9 45 FC D8 C9 D9 5D FC DD D8 8B 01 8B 7E 18 25 FF 00 FE FF 33 DB 83 E7 07 0D E0 00 00 00 43 83 FF 07 89 01 77 48 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 18 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 05 21 45 F0 EB 03 89 5D F0 E8 ?? ?? ?? ?? A8 10 74 03 89 5D F0 33 D2 39 55 F0 74 08 84 1E 0F 84 26 FB FF FF D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 0F 85 F6 00 00 00 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 0F 85 E1 00 00 00 D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 13 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 E9 06 00 00 D9 45 08 D8 5D FC DF E0 F6 C4 05 7A 4B 83 FF 07 0F 87 84 00 00 00 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 0F 85 58 FF FF FF D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 0F 85 43 FF FF FF 21 45 F0 33 D2 E9 4B FF FF FF D9 45 08 D8 5D FC DF E0 F6 C4 41 75 10 83 FF 03 76 2D 83 FF 07 77 2B 83 4D 08 FF EB 25 D9 45 FC D9 45 08 DA E9 DF E0 F6 C4 44 7A 16 83 FF 07 77 11 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 89 55 08 8B 46 20 D9 45 08 09 58 60 8B 46 20 D9 58 50 E9 20 05 00 00 83 FF 02 76 0A 83 FF 06 76 3B 83 FF 07 75 03 89 55 08 8B 46 20 D9 45 08 09 58 60 8B 46 20 D9 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 39 55 F0 E9 E6 FD FF FF 83 4D 08 FF EB C7 83 7E 0C 00 D9 41 10 D9 5D 08 D9 41 30 D9 5D FC 74 3E D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? D9 05 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 D9 45 08 D8 C9 D9 5D 08 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 D9 45 FC D8 C9 D9 5D FC DD D8 83 EA 3B 6A 01 5B 74 3C 4A 75 5F D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 17 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 FF EB 02 8B FB E8 ?? ?? ?? ?? A8 10 74 2D 8B FB EB 29 D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 75 EB D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 75 DA 33 FF EB 03 8B 7D F0 8B 46 20 8B 08 81 E1 FF 00 FE FF 81 C9 E0 00 00 00 85 FF 89 08 74 08 84 1E 0F 84 F4 F8 FF FF D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 0F 85 9F 00 00 00 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 0F 85 8A 00 00 00 D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 13 D9 45 FC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 B7 04 00 00 D9 45 08 D8 5D FC DF E0 F6 C4 41 75 0B 66 81 66 1C 2A F7 E9 84 03 00 00 D9 45 08 D8 5D FC DF E0 F6 C4 05 7A 0C 8B 46 1C 25 2B F7 FF FF 0B C3 EB 1E D9 45 FC D9 45 08 DA E9 DF E0 F6 C4 44 0F 8A 58 03 00 00 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C E9 45 03 00 00 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 85 FF E9 1F FC FF FF 8B 41 10 89 45 08 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 15 B8 00 02 00 00 EB 0E B8 00 01 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 DB 45 08 D9 5D F8 E8 ?? ?? ?? ?? 33 DB 43 F6 06 20 75 42 84 C3 74 3E 8B C6 E8 ?? ?? ?? ?? 8B 46 20 8B 08 81 E1 1F 01 FE FF 81 C9 00 01 00 00 89 08 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 8B 46 20 D9 45 F8 D9 58 50 E9 8B F7 FF FF 8B 4E 20 D9 45 F8 09 59 60 8B 4E 20 D9 59 50 84 C3 8B 46 20 0F 84 61 02 00 00 09 58 0C 83 4E 04 20 E9 59 02 00 00 83 7E 0C 00 D9 41 10 D9 5D 08 74 1F D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C D9 45 08 D8 0D ?? ?? ?? ?? D9 5D 08 83 FA 3F B8 00 01 00 00 72 26 83 FA 40 76 15 83 FA 42 77 1C 8B 11 81 E2 5F 05 FE FF 81 CA 40 05 00 00 EB 0A 8B 11 81 E2 1F 01 FE FF 0B D0 89 11 8B 4E 20 8B 09 C1 E9 05 23 CF 83 F9 08 74 0C 83 F9 2A 75 23 B8 00 03 00 00 EB 1F 8B 4E 10 83 E9 00 74 10 49 74 14 49 74 03 49 EB E6 B8 00 02 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 08 DB 5D E8 E8 ?? ?? ?? ?? 33 DB 43 84 1E 75 08 A8 10 0F 85 8A F6 FF FF 8B 4E 20 8B 55 E8 89 51 50 F6 06 20 75 08 84 C3 0F 85 B2 02 00 00 8B 4E 20 09 59 60 84 C3 8B 4E 20 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 E9 4E FA FF FF 83 7E 0C 00 D9 41 10 D9 5D 08 D9 41 30 D9 5D FC 74 3B D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C D9 45 08 D8 0D ?? ?? ?? ?? D9 5D 08 D9 45 FC 51 D9 14 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C D8 0D ?? ?? ?? ?? D9 5D FC D9 45 FC 83 FA 35 72 26 83 FA 36 76 13 83 FA 38 77 1C 8B 01 25 1F 05 FE FF 0D 00 05 00 00 EB 0C 8B 01 25 3F 05 FE FF 0D 20 05 00 00 89 01 D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 85 C0 59 75 0E 51 D9 14 24 E8 ?? ?? ?? ?? 85 C0 59 74 45 33 DB 43 84 1E 75 07 DD D8 E9 96 F5 FF FF 8B 46 20 09 58 60 8B 46 20 D9 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 8B 46 20 83 48 0C 10 09 5E 04 E9 02 F9 FF FF D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 10 51 D9 14 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 1A 83 4E 04 02 F6 06 02 75 11 8B C6 DD D8 E8 ?? ?? ?? ?? 33 C0 40 E9 C7 F8 FF FF D9 45 08 D8 D9 DF E0 F6 C4 05 7A 40 8B 4E 20 8B 01 C1 E8 05 23 C7 83 E8 28 74 2D 48 74 51 DD D8 8B 46 20 83 48 60 01 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 E9 76 F8 FF FF DD D8 EB 20 D9 45 08 D8 D9 DF E0 F6 C4 41 75 1C 8B 4E 20 8B 01 C1 E8 05 23 C7 83 E8 28 74 08 48 DD D8 75 B4 D9 45 08 D9 59 50 EB AC D9 C0 D9 45 08 DA E9 DF E0 F6 C4 44 7A 9C 8B 46 20 D9 58 50 EB 96 83 7E 0C 00 D9 41 10 D9 5D 08 74 1F D9 45 08 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C D9 45 08 D8 0D ?? ?? ?? ?? D9 5D 08 8B 01 25 BF 00 FE FF 0D A0 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 15 B8 00 02 00 00 EB 0E B8 00 01 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 08 D9 FA D9 5D F8 E8 ?? ?? ?? ?? A8 10 74 05 25 FF FF F7 FF 8B 0E 33 DB 43 84 CB 75 08 A8 10 0F 85 F7 F3 FF FF 8B D0 81 E2 00 00 08 00 74 04 83 4E 04 02 F6 C1 02 75 10 85 D2 74 0C 8B C6 E8 ?? ?? ?? ?? E9 EC F3 FF FF 8B 4E 20 D9 45 F8 D9 59 50 F6 06 20 75 26 84 C3 74 22 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 76 20 09 5E 60 E9 B8 F3 FF FF 8B 4E 20 09 59 60 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 84 C3 8B 4E 20 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C F7 A8 10 0F 84 05 F7 FF FF 8B 46 20 83 48 0C 10 89 5E 04 E9 FD F6 FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 01 02 02 02 02 03 03 04 04 05 05 06 06 06 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 00 01 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 }
	condition:
		$1
}

rule file_537_0_0 {
	meta:
		name = "_strspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 72 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_539_0_0 {
	meta:
		name = "__mbslen"
		size = 49
		refs = "0002 ___ismbcodepage 000a _strlen 001b __mbctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 05 E9 ?? ?? ?? ?? 8B 4C 24 04 33 C0 EB 14 0F B6 D2 F6 82 ?? ?? ?? ?? 04 74 06 41 80 39 00 74 08 40 41 8A 11 84 D2 75 E6 C3 }
	condition:
		$1
}

rule file_540_0_0 {
	meta:
		name = "_printf"
		size = 49
		refs = "0004 __iob 000a __stbuf 001b __output 0024 __ftbuf"
	strings:
		$1 = { 53 56 57 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8B F8 8D 44 24 18 50 FF 74 24 18 56 E8 ?? ?? ?? ?? 56 57 8B D8 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_599_0_0 {
	meta:
		name = "_wprintf"
		size = 49
		refs = "0004 __iob 000a __stbuf 001b __woutput 0024 __ftbuf"
	strings:
		$1 = { 53 56 57 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8B F8 8D 44 24 18 50 FF 74 24 18 56 E8 ?? ?? ?? ?? 56 57 8B D8 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_541_0_0 {
	meta:
		name = "_difftime"
		size = 17
	strings:
		$1 = { 55 8B EC 8B 45 08 2B 45 0C 89 45 08 DB 45 08 5D C3 }
	condition:
		$1
}

rule file_542_0_0 {
	meta:
		name = "_wcspbrk"
		size = 64
	strings:
		$1 = { 8B 44 24 04 66 8B 10 66 85 D2 53 56 57 74 2B 8B 5C 24 14 33 FF 66 8B 3B 66 85 FF 8B F3 74 11 8B CF 66 3B CA 74 16 46 46 66 8B 0E 66 85 C9 75 F1 40 40 66 8B 10 66 85 D2 75 DE 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule file_543_0_0 {
	meta:
		name = "__getdiskfree"
		size = 82
		refs = "003f __imp__GetDiskFreeSpaceA@20 004a __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 04 33 C9 EB 1E 83 F8 1A 76 05 6A 57 58 5D C3 04 40 8D 4D 08 88 45 08 C6 45 09 3A C6 45 0A 5C C6 45 0B 00 8B 45 0C 50 8D 50 04 52 8D 50 0C 52 83 C0 08 50 51 FF 15 ?? ?? ?? ?? 85 C0 75 07 5D FF 25 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_544_0_0 {
	meta:
		name = "_wcstoxq"
		size = 568
		refs = "0029 _iswctype 0070 __wchartodigit 00d4 __aulldvrm 010f _toupper 0160 __allmul 01d4 _errno"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 F8 00 83 65 FC 00 53 8B 5D 08 56 57 33 F6 66 8B 33 8D 7B 02 EB 07 33 F6 66 8B 37 47 47 6A 08 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 EB 66 83 FE 2D 75 06 83 4D 14 02 EB 06 66 83 FE 2B 75 05 66 8B 37 47 47 8B 45 10 85 C0 0F 8C D1 01 00 00 83 F8 01 0F 84 C8 01 00 00 83 F8 24 0F 8F BF 01 00 00 85 C0 6A 10 5B 75 2F 56 E8 ?? ?? ?? ?? 85 C0 59 74 09 C7 45 10 0A 00 00 00 EB 41 66 8B 07 66 3D 78 00 74 0F 66 3D 58 00 74 09 C7 45 10 08 00 00 00 EB 29 89 5D 10 39 5D 10 75 21 56 E8 ?? ?? ?? ?? 85 C0 59 75 16 66 8B 07 66 3D 78 00 74 06 66 3D 58 00 75 07 47 47 66 8B 37 47 47 8B 45 10 99 52 50 6A FF 6A FF 89 45 E0 89 55 E4 E8 ?? ?? ?? ?? 89 4D E8 89 5D EC 89 45 F0 89 55 F4 56 E8 ?? ?? ?? ?? 8B D8 83 FB FF 59 75 27 66 83 FE 41 72 06 66 83 FE 5A 76 0C 66 83 FE 61 72 76 66 83 FE 7A 77 70 0F B7 C6 50 E8 ?? ?? ?? ?? 8B D8 59 83 EB 37 3B 5D 10 73 5C 8B 4D FC 83 4D 14 08 3B 4D F4 72 2B 77 08 8B 45 F8 3B 45 F0 72 21 8B 45 F0 39 45 F8 75 13 3B 4D F4 75 0E 33 C0 3B 45 EC 72 0D 77 05 3B 5D E8 76 06 83 4D 14 04 EB 1B 51 FF 75 F8 FF 75 E4 FF 75 E0 E8 ?? ?? ?? ?? 33 C9 03 C3 13 D1 89 45 F8 89 55 FC 66 8B 37 47 47 E9 6A FF FF FF 8B 5D 14 4F 4F F6 C3 08 75 12 33 C0 39 45 0C 74 03 8B 7D 08 89 45 F8 89 45 FC EB 67 F6 C3 04 B9 FF FF FF 7F BA 00 00 00 80 75 2A F6 C3 01 75 53 8B C3 83 E0 02 74 0D 39 55 FC 77 19 72 06 83 7D F8 00 77 11 85 C0 75 3B 39 4D FC 72 36 77 06 83 7D F8 FF 76 2E F6 C3 01 C7 05 ?? ?? ?? ?? 22 00 00 00 74 0A 83 4D F8 FF 83 4D FC FF EB 15 F6 C3 02 74 09 83 65 F8 00 89 55 FC EB 07 83 4D F8 FF 89 4D FC 8B 45 0C 85 C0 74 02 89 38 F6 C3 02 74 13 8B 45 F8 8B 4D FC F7 D8 83 D1 00 F7 D9 89 45 F8 89 4D FC 8B 45 F8 8B 55 FC EB 0D 8B 45 0C 85 C0 74 02 89 18 33 C0 33 D2 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_546_0_0 {
	meta:
		name = "__wsetenvp"
		size = 202
		refs = "0004 __wenvptr 0022 _wcslen 003d _malloc 0048 __wenviron 007e _wcscpy 0096 _free 00a4 ___env_initialized"
	strings:
		$1 = { 55 56 8B 35 ?? ?? ?? ?? 57 33 ED 33 FF 3B F5 75 1A 83 C8 FF E9 97 00 00 00 66 3D 3D 00 74 01 47 56 E8 ?? ?? ?? ?? 59 8D 74 46 02 66 8B 06 66 3B C5 75 E6 8D 04 BD 04 00 00 00 53 50 E8 ?? ?? ?? ?? 8B D8 3B DD 59 89 1D ?? ?? ?? ?? 75 05 83 C8 FF EB 5C 8B 35 ?? ?? ?? ?? EB 2F 56 E8 ?? ?? ?? ?? 8B F8 47 66 83 3E 3D 59 74 1C 8D 04 3F 50 E8 ?? ?? ?? ?? 3B C5 59 89 03 74 39 56 50 E8 ?? ?? ?? ?? 59 59 83 C3 04 8D 34 7E 66 39 2E 75 CC FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 89 2B C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 59 5B 5F 5E 5D C3 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_547_0_0 {
	meta:
		name = "__vsnprintf"
		size = 86
		refs = "0029 __output 004a __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 0C 56 8B 75 08 57 FF 75 14 89 45 E4 FF 75 10 8D 45 E0 50 C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 E8 ?? ?? ?? ?? 83 C4 0C 85 F6 8B F8 74 1A FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E C9 C3 }
	condition:
		$1
}

rule file_549_0_0 {
	meta:
		name = "__mbsnset"
		size = 211
		refs = "000b ___ismbcodepage 001c __strnset 0059 __mbctype"
	strings:
		$1 = { 55 8B EC 8B 4D 08 56 33 F6 39 35 ?? ?? ?? ?? 57 8B F9 75 14 FF 75 10 FF 75 0C 51 E8 ?? ?? ?? ?? 83 C4 0C E9 A7 00 00 00 8B 45 0C 53 8B D8 C1 EB 08 84 DB 74 5F 84 C0 75 04 B3 20 8A C3 83 7D 10 00 0F 84 85 00 00 00 8A 11 FF 4D 10 84 D2 74 70 85 F6 75 0F 0F B6 D2 F6 82 ?? ?? ?? ?? 04 74 03 46 EB 02 33 F6 88 19 41 8A 11 84 D2 74 1A 85 F6 75 0F 0F B6 D2 F6 82 ?? ?? ?? ?? 04 74 03 46 EB 02 33 F6 88 01 41 EB 04 C6 41 FF 20 83 7D 10 00 75 B5 EB 2C 39 75 10 74 33 8A 11 FF 4D 10 84 D2 74 1E 85 F6 75 0F 0F B6 D2 F6 82 ?? ?? ?? ?? 04 74 03 46 EB 02 33 F6 88 01 41 83 7D 10 00 75 D9 85 F6 74 08 80 39 00 74 03 C6 01 20 8B C7 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_550_0_0 {
	meta:
		name = "__swab"
		size = 43
	strings:
		$1 = { 8B 44 24 0C 83 F8 01 7E 21 8B 4C 24 08 53 56 8D 70 FE 8B 44 24 0C D1 EE 46 8A 10 40 8A 18 40 88 19 41 88 11 41 4E 75 F1 5E 5B C3 }
	condition:
		$1
}

rule file_551_3_0 {
	meta:
		name = "__CIlog10_default"
		size = 213
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0032 __DEFAULT_CW_in_mem 004c ___fastflag 0053 __fast_exit 0059 LOG_name 0063 __math_exit 0089 __indefinite 0095 __convertTOStoQNaN 00ad __minfinity 00cf __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 4C 8B 44 24 0C 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? A9 00 00 F0 7F 74 5E A9 00 00 00 80 75 41 D9 EC D9 C9 D9 F1 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1B 00 00 00 E9 ?? ?? ?? ?? A9 00 00 00 80 75 17 EB D4 A9 FF FF 0F 00 75 1D 83 7C 24 08 00 75 16 25 00 00 00 80 74 C5 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 EB 22 E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 C5 83 7C 24 08 00 75 BE DD D8 DB 2D ?? ?? ?? ?? B8 02 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1B 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_552_0_0 {
	meta:
		name = "__alldiv"
		size = 170
	strings:
		$1 = { 57 56 53 33 FF 8B 44 24 14 0B C0 7D 14 47 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 18 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B D3 EB 41 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 07 3B 44 24 10 76 01 4E 33 D2 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5B 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_553_0_0 {
	meta:
		name = "___crtGetLocaleInfoW"
		size = 304
		refs = "0003 $T20072 0008 __SEH_prolog 0013 ?f_use@?1??__crtGetLocaleInfoW@@9@9 001f __imp__GetLocaleInfoW@16 0031 __imp__GetLastError@0 0079 ___lc_codepage 008a __imp__GetLocaleInfoA@16 00a6 __alloca_probe 00c0 __resetstkoflw 00d7 _malloc 0111 __imp__MultiByteToWideChar@24 011f _free 012b __SEH_epilog"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 33 DB 43 39 3D ?? ?? ?? ?? 75 2B 57 57 53 57 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 1D ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 A1 ?? ?? ?? ?? 3B C3 75 17 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? E9 C3 00 00 00 83 F8 02 74 04 3B C7 75 28 89 7D E4 89 7D DC 39 7D 18 75 08 A1 ?? ?? ?? ?? 89 45 18 57 57 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 89 45 E0 3B C7 75 07 33 C0 E9 8B 00 00 00 89 7D FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B F4 89 75 D8 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 FF 33 F6 83 4D FC FF 33 DB 43 3B F7 75 12 FF 75 E0 E8 ?? ?? ?? ?? 59 8B F0 3B F7 74 B3 89 5D DC FF 75 E0 56 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 1F 39 7D 14 75 04 57 57 EB 06 FF 75 14 FF 75 10 6A FF 56 53 FF 75 18 FF 15 ?? ?? ?? ?? 89 45 E4 39 7D DC 74 07 56 E8 ?? ?? ?? ?? 59 8B 45 E4 8D 65 CC E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_555_0_0 {
	meta:
		name = "_wcslen"
		size = 22
	strings:
		$1 = { 8B 44 24 04 66 8B 08 40 40 66 85 C9 75 F6 2B 44 24 04 D1 F8 48 C3 }
	condition:
		$1
}

rule file_558_0_0 {
	meta:
		name = "__findclose"
		size = 31
		refs = "0006 __imp__FindClose@4 0010 _errno"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 0E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_558_1_0 {
	meta:
		name = "___timet_from_ft"
		size = 100
		refs = "001b __imp__FileTimeToLocalFileTime@8 002d __imp__FileTimeToSystemTime@8 0056 ___loctotime_t"
	strings:
		$1 = { 55 8B EC 83 EC 18 8B 45 08 83 38 00 75 06 83 78 04 00 74 4B 8D 4D F8 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 3C 8D 45 E8 50 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 74 2A 0F B7 45 F4 6A FF 50 0F B7 45 F2 50 0F B7 45 F0 50 0F B7 45 EE 50 0F B7 45 EA 50 0F B7 45 E8 50 E8 ?? ?? ?? ?? 83 C4 1C C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_558_2_0 {
	meta:
		name = "__findfirst"
		size = 218
		refs = "000a ___security_cookie 001e __imp__FindFirstFileA@8 002b __imp__GetLastError@0 0047 _errno 008b ___timet_from_ft 00c5 _strcpy 00d4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 89 45 FC 57 8D 85 BC FE FF FF 50 FF 75 08 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 3F FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 25 83 F8 08 74 14 83 F8 12 74 1B C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF EB 7B C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EF 89 0D ?? ?? ?? ?? EB E7 8B 85 BC FE FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 BC FE FF FF 56 8B 75 0C 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 DC FE FF FF 89 46 10 8D 85 E8 FE FF FF 50 83 C6 14 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 5E 8B 4D FC 5F E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_558_3_0 {
	meta:
		name = "__findnext"
		size = 213
		refs = "000a ___security_cookie 001d __imp__FindNextFileA@8 0027 __imp__GetLastError@0 0043 _errno 0087 ___timet_from_ft 00c1 _strcpy 00cf @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 89 45 FC 8D 85 BC FE FF FF 50 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 25 83 F8 08 74 14 83 F8 12 74 1B C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF EB 7B C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EF 89 0D ?? ?? ?? ?? EB E7 8B 85 BC FE FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 BC FE FF FF 56 8B 75 0C 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 DC FE FF FF 89 46 10 8D 85 E8 FE FF FF 50 83 C6 14 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E 8B 4D FC E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "_xcptlookup"
		size = 55
		refs = "0002 __XcptActTabCount 0007 __XcptActTab"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? B8 ?? ?? ?? ?? 56 39 10 74 11 8D 34 49 83 C0 0C 8D 34 B5 ?? ?? ?? ?? 3B C6 72 EB 8D 0C 49 8D 0C 8D ?? ?? ?? ?? 3B C1 5E 73 04 39 10 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_559_1_0 {
	meta:
		name = "__XcptFilter"
		size = 369
		refs = "0007 __XcptActTabCount 000d __XcptActTab 0069 __pxcptinfoptrs 0085 __First_FPE_Indx 008b __Num_FPE 00b4 __fpecode 0169 __imp__UnhandledExceptionFilter@4"
	strings:
		$1 = { 55 8B EC 8B 55 08 A1 ?? ?? ?? ?? 53 B9 ?? ?? ?? ?? 56 39 11 74 11 8D 34 40 83 C1 0C 8D 34 B5 ?? ?? ?? ?? 3B CE 72 EB 8D 04 40 8D 04 85 ?? ?? ?? ?? 3B C8 73 04 39 11 74 02 33 C9 85 C9 0F 84 21 01 00 00 8B 59 08 85 DB 0F 84 16 01 00 00 83 FB 05 75 0C 83 61 08 00 33 C0 40 E9 0E 01 00 00 83 FB 01 0F 84 F7 00 00 00 A1 ?? ?? ?? ?? 89 45 08 8B 45 0C A3 ?? ?? ?? ?? 8B 41 04 83 F8 08 0F 85 CB 00 00 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 03 D0 3B C2 7D 15 8D 34 40 8D 34 B5 ?? ?? ?? ?? 2B D0 83 26 00 83 C6 0C 4A 75 F7 8B 09 81 F9 8E 00 00 C0 8B 35 ?? ?? ?? ?? 75 0C C7 05 ?? ?? ?? ?? 83 00 00 00 EB 76 81 F9 90 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 81 00 00 00 EB 62 81 F9 91 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 84 00 00 00 EB 4E 81 F9 93 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 85 00 00 00 EB 3A 81 F9 8D 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 82 00 00 00 EB 26 81 F9 8F 00 00 C0 75 0C C7 05 ?? ?? ?? ?? 86 00 00 00 EB 12 81 F9 92 00 00 C0 75 0A C7 05 ?? ?? ?? ?? 8A 00 00 00 FF 35 ?? ?? ?? ?? 6A 08 FF D3 59 89 35 ?? ?? ?? ?? EB 07 83 61 08 00 50 FF D3 8B 45 08 59 A3 ?? ?? ?? ?? 83 C8 FF EB 09 FF 75 0C FF 15 ?? ?? ?? ?? 5E 5B 5D C3 }
	condition:
		$1
}

rule file_559_2_0 {
	meta:
		name = "___CppXcptFilter"
		size = 27
		refs = "0011 __XcptFilter"
	strings:
		$1 = { B8 63 73 6D E0 39 44 24 04 75 0D FF 74 24 08 50 E8 ?? ?? ?? ?? 59 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_560_0_0 {
	meta:
		name = "_mblen"
		size = 119
		refs = "0019 __pctype 0029 ___mb_cur_max 0040 ___lc_codepage 0046 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 8B 4C 24 04 33 D2 3B CA 74 6A 8A 01 3A C2 74 64 39 54 24 08 74 5E 56 8B 35 ?? ?? ?? ?? 0F B6 C0 F6 44 46 01 80 5E 74 30 A1 ?? ?? ?? ?? 83 F8 01 7E 22 39 44 24 08 7C 1C 52 52 50 51 6A 09 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 06 A1 ?? ?? ?? ?? C3 83 C8 FF C3 52 52 6A 01 51 6A 09 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F7 D8 1B C0 83 E0 02 48 C3 33 C0 C3 }
	condition:
		$1
}

rule file_562_0_0 {
	meta:
		name = "_x_ismbbtype"
		size = 51
		refs = "000b __mbctype 001a __pctype"
	strings:
		$1 = { 0F B6 44 24 04 8A 4C 24 0C 84 88 ?? ?? ?? ?? 75 1E 83 7C 24 08 00 74 10 8B 0D ?? ?? ?? ?? 0F B7 04 41 23 44 24 08 EB 02 33 C0 85 C0 75 01 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_562_2_0 {
	meta:
		name = "__ismbbkprint"
		size = 17
		refs = "0009 _x_ismbbtype"
	strings:
		$1 = { 6A 03 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_3_0 {
	meta:
		name = "__ismbbkpunct"
		size = 17
		refs = "0009 _x_ismbbtype"
	strings:
		$1 = { 6A 02 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_4_0 {
	meta:
		name = "__ismbbalnum"
		size = 20
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 6A 01 68 07 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_5_0 {
	meta:
		name = "__ismbbalpha"
		size = 20
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 6A 01 68 03 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_6_0 {
	meta:
		name = "__ismbbgraph"
		size = 20
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 6A 03 68 17 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_7_0 {
	meta:
		name = "__ismbbprint"
		size = 20
		refs = "000c _x_ismbbtype"
	strings:
		$1 = { 6A 03 68 57 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_8_0 {
	meta:
		name = "__ismbbpunct"
		size = 17
		refs = "0009 _x_ismbbtype"
	strings:
		$1 = { 6A 02 6A 10 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_9_0 {
	meta:
		name = "__ismbblead"
		size = 17
		refs = "0009 _x_ismbbtype"
	strings:
		$1 = { 6A 04 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_10_0 {
	meta:
		name = "__ismbbtrail"
		size = 17
		refs = "0009 _x_ismbbtype"
	strings:
		$1 = { 6A 08 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_562_11_0 {
	meta:
		name = "__ismbbkana"
		size = 39
		refs = "0002 ___mbcodepage 0015 _x_ismbbtype"
	strings:
		$1 = { 81 3D ?? ?? ?? ?? A4 03 00 00 75 18 6A 03 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_564_0_0 {
	meta:
		name = "__strnset"
		size = 43
	strings:
		$1 = { 55 8B EC 57 53 8B 7D 08 8B D7 8B 5D 10 33 C0 8B CB E3 12 F2 AE 75 03 83 C1 01 2B D9 8B CB 8B FA 8A 45 0C F3 AA 8B C2 5B 5F C9 C3 }
	condition:
		$1
}

rule file_566_0_0 {
	meta:
		name = "?TypeMatch@@YAHPBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_ThrowInfo@@@Z"
		size = 79
		refs = "001c _strcmp"
	strings:
		$1 = { 8B 46 04 85 C0 74 44 8D 50 08 80 3A 00 74 3C 8B 4F 04 3B C1 74 10 83 C1 08 51 52 E8 ?? ?? ?? ?? 85 C0 59 59 75 22 F6 07 02 74 05 F6 06 08 74 18 8B 44 24 04 8B 00 A8 01 74 05 F6 06 01 74 09 A8 02 74 08 F6 06 02 75 03 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_566_1_0 {
	meta:
		name = "?FrameUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 25
		refs = "000f ?__ProcessingThrow@@3HA 0015 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B 00 81 38 63 73 6D E0 74 03 33 C0 C3 83 25 ?? ?? ?? ?? 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_566_2_0 {
	meta:
		name = "___FrameUnwindToState"
		size = 189
		refs = "0003 $T19715 0008 __SEH_prolog 0017 ?__ProcessingThrow@@3HA 0032 ?_inconsistency@@YAXXZ 0063 __CallSettingFrame@12 0071 ?FrameUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z 00a2 __SEH_epilog"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 8B 73 08 89 75 E4 FF 05 ?? ?? ?? ?? 83 65 FC 00 8B 7D 10 3B 75 14 74 64 83 FE FF 7E 05 3B 77 04 7C 05 E8 ?? ?? ?? ?? 8B C6 C1 E0 03 8B 4F 08 03 C8 8B 31 89 75 E0 C7 45 FC 01 00 00 00 83 79 04 00 74 15 89 73 08 68 03 01 00 00 53 8B 4F 08 FF 74 01 04 E8 ?? ?? ?? ?? 83 65 FC 00 EB 19 8B 45 EC E8 ?? ?? ?? ?? C3 8B 65 E8 83 65 FC 00 8B 7D 10 8B 5D 08 8B 75 E0 89 75 E4 EB 97 83 4D FC FF E8 19 00 00 00 3B 75 14 74 05 E8 ?? ?? ?? ?? 89 73 08 E8 ?? ?? ?? ?? C3 8B 5D 08 8B 75 E4 83 3D ?? ?? ?? ?? 00 7E 06 FF 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_566_3_0 {
	meta:
		name = "?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 48
	strings:
		$1 = { 8B 00 81 38 63 73 6D E0 75 23 83 78 10 03 75 1D 8B 48 14 81 F9 20 05 93 19 74 08 81 F9 21 05 93 19 75 0A 83 78 1C 00 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_566_4_0 {
	meta:
		name = "___DestructExceptionObject"
		size = 69
		refs = "0003 $T19736 0008 __SEH_prolog 0026 ?_CallMemberFunction0@@YGXPAX0@Z 002f __SEH_epilog 0041 ?terminate@@YAXXZ"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 85 C0 74 1B 8B 48 1C 8B 49 04 85 C9 74 11 83 65 FC 00 51 FF 70 18 E8 ?? ?? ?? ?? 83 4D FC FF E8 ?? ?? ?? ?? C3 33 C0 38 45 0C 0F 95 C0 C3 8B 65 E8 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_566_5_0 {
	meta:
		name = "?AdjustPointer@@YAPAXPAXABUPMD@@@Z"
		size = 31
	strings:
		$1 = { 56 8B F0 8B 01 03 C6 83 79 04 00 7C 10 8B 51 04 8B 49 08 8B 34 32 8B 0C 0E 03 CA 03 C1 5E C3 }
	condition:
		$1
}

rule file_566_7_0 {
	meta:
		name = "___CxxRegisterExceptionObject"
		size = 127
		refs = "003b ?_pCurrentException@@3PAUEHExceptionRecord@@A 0044 ?_CreateFrameInfo@@YAPAUFrameInfo@@PAU1@PAX@Z 0051 ?_pCurrentExContext@@3PAU_CONTEXT@@A 006c ?__ProcessingThrow@@3HA"
	strings:
		$1 = { 8B 44 24 04 85 C0 56 57 8B 7C 24 10 74 54 8B 30 85 F6 74 4E 81 3E 63 73 6D E0 75 23 83 7E 10 03 75 1D 8B 46 14 3D 20 05 93 19 74 07 3D 21 05 93 19 75 0C 83 7E 1C 00 75 06 8B 35 ?? ?? ?? ?? FF 76 18 57 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 47 08 A1 ?? ?? ?? ?? 59 89 47 0C 59 89 35 ?? ?? ?? ?? EB 08 83 4F 08 FF 83 4F 0C FF FF 0D ?? ?? ?? ?? 5F 5E 79 07 83 25 ?? ?? ?? ?? 00 33 C0 40 C3 }
	condition:
		$1
}

rule file_566_8_0 {
	meta:
		name = "___CxxDetectRethrow"
		size = 56
	strings:
		$1 = { 8B 44 24 04 85 C0 74 2D 8B 00 81 38 63 73 6D E0 75 23 83 78 10 03 75 1D 8B 48 14 81 F9 20 05 93 19 74 08 81 F9 21 05 93 19 75 0A 83 78 1C 00 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_566_9_0 {
	meta:
		name = "___CxxUnregisterExceptionObject"
		size = 109
		refs = "000d ?_FindAndUnlinkFrame@@YAXPAUFrameInfo@@@Z 001a ?_pCurrentException@@3PAUEHExceptionRecord@@A 0043 ?IsExceptionObjectToBeDestroyed@@YAHPAX@Z 0055 ___DestructExceptionObject 0067 ?_pCurrentExContext@@3PAU_CONTEXT@@A"
	strings:
		$1 = { 56 8B 74 24 08 83 7E 08 FF 74 60 56 E8 ?? ?? ?? ?? 83 7C 24 10 00 59 75 42 A1 ?? ?? ?? ?? 81 38 63 73 6D E0 75 35 83 78 10 03 75 2F 8B 48 14 81 F9 20 05 93 19 74 08 81 F9 21 05 93 19 75 1C FF 70 18 E8 ?? ?? ?? ?? 85 C0 59 74 0F 6A 01 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 8B 46 08 A3 ?? ?? ?? ?? 8B 46 0C A3 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_566_11_0 {
	meta:
		name = "___CxxCallUnwindDtor"
		size = 46
		refs = "0003 $T19768 0008 __SEH_prolog 001c ?FrameUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z 0029 __SEH_epilog"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 8B 4D 0C FF 55 08 EB 0C 8B 45 EC E8 ?? ?? ?? ?? C3 8B 65 E8 83 4D FC FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_566_12_0 {
	meta:
		name = "___CxxCallUnwindVecDtor"
		size = 55
		refs = "0003 $T19782 0008 __SEH_prolog 0025 ?FrameUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z 0032 __SEH_epilog"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 55 08 EB 0C 8B 45 EC E8 ?? ?? ?? ?? C3 8B 65 E8 83 4D FC FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_566_13_0 {
	meta:
		name = "?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 426
		refs = "0003 $T19809 0008 __SEH_prolog 0029 ?_CreateFrameInfo@@YAPAUFrameInfo@@PAU1@PAX@Z 0033 ?_pCurrentException@@3PAUEHExceptionRecord@@A 003b ?_pCurrentExContext@@3PAU_CONTEXT@@A 0067 ?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z 0119 ___FrameUnwindToState 0136 __SEH_epilog 014e ?_FindAndUnlinkFrame@@YAXPAUFrameInfo@@@Z 0192 ?IsExceptionObjectToBeDestroyed@@YAHPAX@Z 019c __abnormal_termination 01a3 ___DestructExceptionObject"
	strings:
		$1 = { 6A 40 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 8B 7D 0C 8B 75 08 89 5D E0 83 65 B8 00 8B 47 FC 89 45 C8 FF 76 18 8D 45 B0 50 E8 ?? ?? ?? ?? 59 59 89 45 C4 A1 ?? ?? ?? ?? 89 45 C0 A1 ?? ?? ?? ?? 89 45 BC 89 35 ?? ?? ?? ?? 8B 45 10 A3 ?? ?? ?? ?? 83 65 FC 00 C7 45 FC 01 00 00 00 FF 75 1C FF 75 18 53 FF 75 14 57 E8 ?? ?? ?? ?? 83 C4 14 89 45 E0 83 65 FC 00 E9 AF 00 00 00 8B 45 EC 8B 00 89 45 E4 8B 45 E4 81 38 63 73 6D E0 75 31 8B 45 E4 83 78 10 03 75 28 8B 45 E4 81 78 14 20 05 93 19 74 0C 8B 45 E4 81 78 14 21 05 93 19 75 10 8B 45 E4 83 78 1C 00 C7 45 DC 01 00 00 00 74 07 C7 45 DC 00 00 00 00 8B 45 DC C3 8B 65 E8 8B 4D 14 8B 41 08 89 45 D0 8B 7D 0C 8B 47 08 89 45 D8 8B 51 10 89 55 D4 33 D2 89 55 CC 3B 51 0C 73 24 8D 34 92 8B 5D D4 8D 34 B3 8B 5E 04 3B C3 7E 3D 3B 46 08 7F 38 8D 43 01 89 45 D8 8B 55 D0 8B 04 C2 89 45 D8 50 51 33 F6 56 57 E8 ?? ?? ?? ?? 83 C4 10 89 75 E0 89 75 FC 8B 75 08 83 4D FC FF E8 12 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 42 EB A8 8B 7D 0C 8B 75 08 8B 45 C8 89 47 FC FF 75 C4 E8 ?? ?? ?? ?? 59 8B 45 C0 A3 ?? ?? ?? ?? 8B 45 BC A3 ?? ?? ?? ?? 81 3E 63 73 6D E0 75 3E 83 7E 10 03 75 38 8B 46 14 3D 20 05 93 19 74 07 3D 21 05 93 19 75 27 83 7D B8 00 75 21 83 7D E0 00 74 1B FF 76 18 E8 ?? ?? ?? ?? 59 85 C0 74 0E E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_566_14_0 {
	meta:
		name = "?BuildCatchObject@@YAXPAUEHExceptionRecord@@PAXPBU_s_HandlerType@@PBU_s_CatchableType@@@Z"
		size = 380
		refs = "0003 $T19828 0008 __SEH_prolog 0054 ?_ValidateRead@@YAHPBXI@Z 0066 ?_ValidateWrite@@YAHPAXI@Z 007d ?AdjustPointer@@YAPAXPAXABUPMD@@@Z 00b6 _memmove 0129 ?_ValidateExecute@@YAHP6GHXZ@Z 014a ?_CallMemberFunction2@@YGXPAX00H@Z 015b ?_CallMemberFunction1@@YGXPAX00@Z 0162 ?_inconsistency@@YAXXZ 016b __SEH_epilog 0178 ?terminate@@YAXXZ"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 45 0C 8B FA 8B 5D 08 8B 48 04 85 C9 0F 84 49 01 00 00 80 79 08 00 0F 84 3F 01 00 00 8B 48 08 85 C9 75 0A F6 40 03 80 0F 84 2E 01 00 00 8B 00 85 C0 78 04 8D 7C 39 0C 83 65 FC 00 6A 01 FF 73 18 A8 08 74 35 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 FF 00 00 00 6A 01 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 ED 00 00 00 8B 43 18 89 07 8D 4E 08 E8 ?? ?? ?? ?? 89 07 E9 DE 00 00 00 F6 06 01 74 46 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 C5 00 00 00 6A 01 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 B3 00 00 00 FF 76 14 FF 73 18 57 E8 ?? ?? ?? ?? 83 C4 0C 83 7E 14 04 0F 85 9F 00 00 00 8B 07 85 C0 0F 84 95 00 00 00 EB A6 83 7E 18 00 75 33 E8 ?? ?? ?? ?? 59 59 85 C0 74 7D 6A 01 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 6F FF 76 14 8D 4E 08 8B 43 18 E8 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 0C EB 5A E8 ?? ?? ?? ?? 59 59 85 C0 74 4A 6A 01 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 3C FF 76 18 E8 ?? ?? ?? ?? 59 85 C0 74 2F 8B 43 18 8D 4E 08 F6 06 04 74 13 6A 01 E8 ?? ?? ?? ?? 50 FF 76 18 57 E8 ?? ?? ?? ?? EB 16 E8 ?? ?? ?? ?? 50 FF 76 18 57 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 83 4D FC FF E8 ?? ?? ?? ?? C3 33 C0 40 C3 8B 65 E8 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_566_15_0 {
	meta:
		name = "___CxxExceptionFilter"
		size = 264
		refs = "0058 ?_pCurrentException@@3PAUEHExceptionRecord@@A 0096 ?TypeMatch@@YAHPBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_ThrowInfo@@@Z 00b2 ?__ProcessingThrow@@3HA 00c2 ?BuildCatchObject@@YAXPAUEHExceptionRecord@@PAXPBU_s_HandlerType@@PBU_s_CatchableType@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 08 33 D2 3B C2 56 57 75 07 33 C0 E9 EC 00 00 00 53 8B 18 8B 45 0C 3B C2 0F 84 A4 00 00 00 80 78 08 00 0F 84 9A 00 00 00 81 3B 63 73 6D E0 75 28 83 7B 10 03 75 22 8B 4B 14 81 F9 20 05 93 19 74 08 81 F9 21 05 93 19 75 0F 39 53 1C 75 11 8B 1D ?? ?? ?? ?? 3B DA 75 07 33 C0 E9 9C 00 00 00 89 45 F0 8B 45 10 0D 00 00 00 80 89 45 EC 8B 43 1C 8B 40 0C 8D 48 04 8B 00 3B C2 89 4D 08 89 45 FC 7E D6 8B 45 08 FF 73 1C 8B 38 8D 75 EC E8 ?? ?? ?? ?? 85 C0 59 75 0E FF 4D FC 83 45 08 04 39 45 FC 7F DF EB B3 8B 55 14 FF 05 ?? ?? ?? ?? 85 D2 74 46 8D 45 EC 50 53 8B CF E8 ?? ?? ?? ?? 59 59 EB 36 81 3B 63 73 6D E0 75 28 83 7B 10 03 75 22 8B 43 14 3D 20 05 93 19 74 07 3D 21 05 93 19 75 11 39 53 1C 75 0C 39 15 ?? ?? ?? ?? 0F 84 66 FF FF FF FF 05 ?? ?? ?? ?? 33 C0 40 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_566_16_0 {
	meta:
		name = "?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
		size = 103
		refs = "000e ?BuildCatchObject@@YAXPAUEHExceptionRecord@@PAXPBU_s_HandlerType@@PBU_s_CatchableType@@@Z 0024 ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0032 ___FrameUnwindToState 0053 ?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 0061 ?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
	strings:
		$1 = { 55 8B EC 85 C9 74 0D 53 FF 75 08 8B D6 E8 ?? ?? ?? ?? 59 59 83 7D 1C 00 FF 75 08 75 03 56 EB 03 FF 75 1C E8 ?? ?? ?? ?? FF 37 FF 75 14 FF 75 10 56 E8 ?? ?? ?? ?? 8B 47 04 68 00 01 00 00 FF 75 18 40 FF 75 14 89 46 08 FF 75 0C 8B 4B 0C 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 85 C0 74 07 56 50 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_566_17_0 {
	meta:
		name = "?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
		size = 188
		refs = "0016 ?__pSETranslator@@3P6AXIPAU_EXCEPTION_POINTERS@@@ZA 0031 ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z 0051 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 009f ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 08 81 38 03 00 00 80 0F 84 A6 00 00 00 83 3D ?? ?? ?? ?? 00 74 1F FF 75 24 FF 75 20 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 7E 56 8B 75 1C 57 8D 45 F8 50 8D 45 FC 50 56 FF 75 20 FF 75 18 E8 ?? ?? ?? ?? 8B F8 8B 45 FC 83 C4 14 3B 45 F8 73 56 53 3B 37 7C 42 3B 77 04 7F 3D 8B 47 0C 8B 4F 10 C1 E0 04 03 C1 8B 48 F4 85 C9 74 06 80 79 08 00 75 25 FF 75 24 8B 75 0C FF 75 20 8D 58 F0 FF 75 18 33 C9 FF 75 14 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 8B 75 1C 83 C4 18 FF 45 FC 8B 45 FC 83 C7 14 3B 45 F8 72 AC 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_566_18_0 {
	meta:
		name = "?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
		size = 498
		refs = "0021 ?_inconsistency@@YAXXZ 0057 ?_pCurrentException@@3PAUEHExceptionRecord@@A 0066 ?_pCurrentExContext@@3PAU_CONTEXT@@A 0078 ?_ValidateRead@@YAHPBXI@Z 00f6 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 014c ?TypeMatch@@YAHPBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_ThrowInfo@@@Z 018e ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z 01b9 ___DestructExceptionObject 01e4 ?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z 01ee ?terminate@@YAXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 24 8B 45 0C 8B 40 08 83 F8 FF C6 45 FF 00 89 45 E4 7C 08 8B 4D 18 3B 41 04 7C 05 E8 ?? ?? ?? ?? 53 8B 5D 08 81 3B 63 73 6D E0 56 57 0F 85 90 01 00 00 83 7B 10 03 BF 20 05 93 19 75 79 8B 43 14 3B C7 74 07 3D 21 05 93 19 75 6B 83 7B 1C 00 75 65 A1 ?? ?? ?? ?? 85 C0 0F 84 5C 01 00 00 8B F0 A1 ?? ?? ?? ?? 6A 01 56 89 75 08 89 45 10 C6 45 FF 01 E8 ?? ?? ?? ?? 85 C0 59 59 75 05 E8 ?? ?? ?? ?? 81 3E 63 73 6D E0 0F 85 31 01 00 00 8B 45 08 83 78 10 03 75 1C 8B 40 14 3B C7 74 07 3D 21 05 93 19 75 0E 8B 45 08 83 78 1C 00 75 05 E8 ?? ?? ?? ?? 8B 5D 08 81 3B 63 73 6D E0 0F 85 00 01 00 00 83 7B 10 03 0F 85 F6 00 00 00 8B 43 14 3B C7 74 0B 3D 21 05 93 19 0F 85 E4 00 00 00 8B 75 E4 8D 45 E0 50 8D 45 F4 50 56 FF 75 20 FF 75 18 E8 ?? ?? ?? ?? 8B 4D F4 83 C4 14 3B 4D E0 89 45 F8 0F 83 A3 00 00 00 EB 03 8B 75 E4 39 30 0F 8F 81 00 00 00 3B 70 04 7F 7C 8B 48 0C 85 C9 8B 70 10 89 4D E8 7E 6F 8B 4B 1C 8B 49 0C 8D 51 04 8B 09 85 C9 89 55 F0 89 4D EC 7E 24 8B 45 F0 8B 38 FF 73 1C 89 7D DC E8 ?? ?? ?? ?? 85 C0 59 75 1D FF 4D EC 83 45 F0 04 39 45 EC 7F DF 8B 45 F8 FF 4D E8 83 C6 10 83 7D E8 00 7F BB EB 28 FF 75 24 8B 7D F8 FF 75 20 8B 4D DC FF 75 18 FF 75 14 FF 75 10 53 8B DE 8B 75 0C E8 ?? ?? ?? ?? 8B 5D 08 83 C4 18 8B C7 FF 45 F4 8B 4D F4 83 C0 14 3B 4D E0 89 45 F8 0F 82 5F FF FF FF 80 7D 1C 00 74 0A 6A 01 53 E8 ?? ?? ?? ?? 59 59 5F 5E 5B C9 C3 8B 5D 08 80 7D 1C 00 75 20 FF 75 24 FF 75 20 FF 75 E4 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 53 E8 ?? ?? ?? ?? 83 C4 20 EB D2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_566_19_0 {
	meta:
		name = "___InternalCxxFrameHandler"
		size = 162
		refs = "0019 ?_inconsistency@@YAXXZ 003c ___FrameUnwindToState 0094 ?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 18 8B 06 57 25 FF FF FF 1F BF 20 05 93 19 3B C7 74 05 E8 ?? ?? ?? ?? 8B 45 08 F6 40 04 66 74 1F 83 7E 04 00 74 6F 83 7D 1C 00 75 69 6A FF 56 FF 75 14 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 EB 56 83 7E 0C 00 74 50 81 38 63 73 6D E0 75 2C 39 78 14 76 27 8B 48 1C 8B 49 08 85 C9 74 1D 0F B6 55 24 52 FF 75 20 FF 75 1C 56 FF 75 14 FF 75 10 FF 75 0C 50 FF D1 83 C4 20 EB 1F FF 75 20 FF 75 1C FF 75 24 56 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 20 33 C0 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_567_0_0 {
	meta:
		name = "__fseeki64"
		size = 146
		refs = "002d __ftelli64 003c __flush 006f __lseeki64 0083 _errno"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 8B 46 0C A8 83 57 74 72 8B 7D 14 85 FF 74 0A 83 FF 01 74 05 83 FF 02 75 61 83 E0 EF 83 FF 01 89 46 0C 75 0F 56 E8 ?? ?? ?? ?? 01 45 0C 59 11 55 10 33 FF 56 E8 ?? ?? ?? ?? 8B 46 0C 84 C0 59 79 08 83 E0 FC 89 46 0C EB 14 A8 01 74 10 A8 08 74 0C F6 C4 04 75 07 C7 46 18 00 02 00 00 57 FF 75 10 FF 75 0C FF 76 10 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 74 0E 33 C0 EB 0D C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF 5F 5E 5D C3 }
	condition:
		$1
}

rule file_568_0_0 {
	meta:
		name = "__ismbclegal"
		size = 40
		refs = "000c __mbctype"
	strings:
		$1 = { 8B 44 24 04 C1 E8 08 0F B6 C0 F6 80 ?? ?? ?? ?? 04 74 12 0F B6 44 24 04 F6 80 ?? ?? ?? ?? 08 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_569_0_0 {
	meta:
		name = "?__CxxUnhandledExceptionFilter@@YGJPAU_EXCEPTION_POINTERS@@@Z"
		size = 78
		refs = "0027 ?terminate@@YAXXZ 002c _pOldExceptFilter 0036 ?_ValidateExecute@@YAHP6GHXZ@Z"
	strings:
		$1 = { 56 8B 74 24 08 8B 06 81 38 63 73 6D E0 75 1C 83 78 10 03 75 16 8B 40 14 3D 20 05 93 19 74 07 3D 21 05 93 19 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 14 50 E8 ?? ?? ?? ?? 85 C0 59 74 09 56 FF 15 ?? ?? ?? ?? EB 02 33 C0 5E C2 04 00 }
	condition:
		$1
}

rule file_569_1_0 {
	meta:
		name = "?__CxxSetUnhandledExceptionFilter@@YAHXZ"
		size = 19
		refs = "0001 ?__CxxUnhandledExceptionFilter@@YGJPAU_EXCEPTION_POINTERS@@@Z 0007 __imp__SetUnhandledExceptionFilter@4 000c _pOldExceptFilter"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_570_0_0 {
	meta:
		name = "__cgets"
		size = 203
		refs = "0012 __coninpfh 0020 ___initconin 003c __imp__GetConsoleMode@8 004a __imp__SetConsoleMode@8 0062 __imp__ReadConsoleA@20"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B 75 08 33 DB 57 88 5E 01 83 3D ?? ?? ?? ?? FE 8D 7E 02 89 7D 08 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 75 07 33 C0 E9 91 00 00 00 8D 4D F8 51 50 FF 15 ?? ?? ?? ?? 6A 07 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 53 8D 45 FC 50 0F B6 06 50 FF 75 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 03 89 5D 08 39 5D 08 74 42 8B 45 FC 8D 0C 30 80 39 0D 75 09 2C 02 88 46 01 88 19 EB 2E 0F B6 16 3B C2 75 10 80 79 01 0D 75 0A FE C8 88 46 01 88 59 01 EB 17 83 F8 01 75 0C 80 3F 0A 75 07 88 1F 88 5E 01 EB 06 88 46 01 88 59 02 FF 75 F8 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 45 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_572_0_0 {
	meta:
		name = "_fwrite"
		size = 263
		refs = "0060 _memcpy 007e __flush 00a0 __write 00c3 __flsbuf"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 08 53 57 8B 7D 0C 0F AF 7D 10 85 FF 89 45 08 89 7D F8 8B DF 75 07 33 C0 E9 CB 00 00 00 56 8B 75 14 66 F7 46 0C 0C 01 74 08 8B 46 18 89 45 FC EB 07 C7 45 FC 00 10 00 00 8B 4E 0C 81 E1 08 01 00 00 74 29 8B 46 04 85 C0 74 22 3B D8 8B FB 72 02 8B F8 57 FF 75 08 FF 36 E8 ?? ?? ?? ?? 29 7E 04 01 3E 83 C4 0C 2B DF 01 7D 08 EB 42 3B 5D FC 72 42 85 C9 74 0B 56 E8 ?? ?? ?? ?? 85 C0 59 75 6C 83 7D FC 00 8B FB 74 09 33 D2 8B C3 F7 75 FC 2B FA 57 FF 75 08 FF 76 10 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 52 01 45 08 2B D8 3B C7 72 49 8B 7D F8 EB 29 8B 45 08 0F BE 00 56 50 E8 ?? ?? ?? ?? 83 F8 FF 59 59 74 25 FF 45 08 8B 46 18 4B 85 C0 89 45 FC 7F 07 C7 45 FC 01 00 00 00 85 DB 0F 85 54 FF FF FF 8B 45 10 5E 5F 5B C9 C3 8B C7 2B C3 33 D2 F7 75 0C EB F0 83 4E 0C 20 8B 45 F8 EB EE }
	condition:
		$1
}

rule file_574_0_0 {
	meta:
		name = "__fpreset"
		size = 42
		refs = "0003 __pxcptinfoptrs 000a __setdefaultprecision"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? DB E3 E8 ?? ?? ?? ?? 85 F6 74 16 8B 46 04 F7 00 08 00 01 00 74 0B 83 60 20 00 C7 40 24 FF FF 00 00 5E C3 }
	condition:
		$1
}

rule file_574_1_0 {
	meta:
		name = "__abstract_cw"
		size = 146
	strings:
		$1 = { 33 C0 F6 C3 01 74 03 6A 10 58 F6 C3 04 74 03 83 C8 08 F6 C3 08 74 03 83 C8 04 F6 C3 10 74 03 83 C8 02 F6 C3 20 74 03 83 C8 01 F6 C3 02 74 05 0D 00 00 08 00 55 0F B7 D3 56 8B CA BE 00 0C 00 00 23 CE 57 BF 00 03 00 00 BD 00 02 00 00 74 21 81 F9 00 04 00 00 74 14 81 F9 00 08 00 00 74 08 3B CE 75 0D 0B C7 EB 09 0B C5 EB 05 0D 00 01 00 00 23 D7 74 0B 3B D5 75 0C 0D 00 00 01 00 EB 05 0D 00 00 02 00 F6 C7 10 5F 5E 5D 74 05 0D 00 00 04 00 C3 }
	condition:
		$1
}

rule file_574_2_0 {
	meta:
		name = "__hw_cw"
		size = 142
	strings:
		$1 = { 33 C0 F6 C3 10 74 01 40 F6 C3 08 74 03 83 C8 04 F6 C3 04 74 03 83 C8 08 F6 C3 02 74 03 83 C8 10 F6 C3 01 74 03 83 C8 20 F7 C3 00 00 08 00 74 03 83 C8 02 8B CB BA 00 03 00 00 23 CA 56 BE 00 02 00 00 74 23 81 F9 00 01 00 00 74 16 3B CE 74 0B 3B CA 75 13 0D 00 0C 00 00 EB 0C 0D 00 08 00 00 EB 05 0D 00 04 00 00 8B CB 81 E1 00 00 03 00 74 0C 81 F9 00 00 01 00 75 06 0B C6 EB 02 0B C2 F7 C3 00 00 04 00 5E 74 05 0D 00 10 00 00 C3 }
	condition:
		$1
}

rule file_574_3_0 {
	meta:
		name = "__abstract_sw"
		size = 57
	strings:
		$1 = { 8A 4C 24 04 33 C0 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 C3 }
	condition:
		$1
}

rule file_574_4_0 {
	meta:
		name = "__statusfp"
		size = 16
		refs = "0009 __abstract_sw"
	strings:
		$1 = { 51 9B DD 3C 24 FF 34 24 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_574_5_0 {
	meta:
		name = "__clearfp"
		size = 17
		refs = "000a __abstract_sw"
	strings:
		$1 = { 51 DD 3C 24 DB E2 FF 34 24 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_574_6_0 {
	meta:
		name = "__control87"
		size = 50
		refs = "000d __abstract_cw 0023 __hw_cw"
	strings:
		$1 = { 55 8B EC 51 53 9B D9 7D FC 8B 5D FC E8 ?? ?? ?? ?? 8B D8 8B 45 0C F7 D0 23 D8 8B 45 08 23 45 0C 0B D8 E8 ?? ?? ?? ?? 89 45 0C D9 6D 0C 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_574_7_0 {
	meta:
		name = "__controlfp"
		size = 22
		refs = "000f __control87"
	strings:
		$1 = { 8B 44 24 08 25 FF FF F7 FF 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_575_0_0 {
	meta:
		name = "_$$$00001"
		size = 252
		refs = "001f _tanhmaxarg 0070 __rttospop 0078 __infinity 007d __rtchsifneg 008c __rtinfnpop 00a2 __rtonenpop 00af __ffexpm1"
	strings:
		$1 = { C6 85 70 FF FF FF FF E8 9C 00 00 00 0A DB 74 7B E8 D6 00 00 00 DE E9 EB 4E D9 C0 D9 E1 DB 2D ?? ?? ?? ?? DE D9 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 41 75 64 E8 6D 00 00 00 0A DB 74 5B D9 C0 E8 93 00 00 00 D9 C9 E8 9E 00 00 00 DE E9 DE F1 C3 C6 85 70 FF FF FF FF E8 4A 00 00 00 0A DB 74 33 E8 72 00 00 00 D9 E8 D9 E0 D9 C9 D9 FD E9 ?? ?? ?? ?? DD D8 DB 2D ?? ?? ?? ?? E9 ?? ?? ?? ?? DD D8 DB 2D ?? ?? ?? ?? C3 C3 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? C6 85 70 FF FF FF 08 E8 ?? ?? ?? ?? EB E8 D9 EA DE C9 33 DB E8 ?? ?? ?? ?? F6 D3 F6 85 61 FF FF FF 01 74 09 E8 28 00 00 00 D9 C9 DD D8 F6 C2 40 75 08 F6 D7 D9 E8 DE C1 D9 FD E9 ?? ?? ?? ?? E8 0D 00 00 00 DE C1 0A FF 75 06 D9 E8 DC C1 DE C1 C3 D9 C0 D9 E8 0A FF 75 06 D8 C1 D9 E0 D9 C9 DE F1 C3 }
	condition:
		$1
}

rule file_577_0_0 {
	meta:
		name = "_localtime"
		size = 384
		refs = "0014 ___tzset 002a __timezone 0036 _gmtime 003c __daylight 004c __isindst 005a __dstbias"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 83 3E 00 7D 07 33 C0 E9 32 01 00 00 E8 ?? ?? ?? ?? 8B 06 3D 80 F4 03 00 7E 58 3D 7F 0B FC 7F 7D 51 2B 05 ?? ?? ?? ?? 89 45 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 59 8B F0 0F 84 F9 00 00 00 56 E8 ?? ?? ?? ?? 85 C0 59 0F 84 EA 00 00 00 A1 ?? ?? ?? ?? 29 45 08 8D 45 08 50 E8 ?? ?? ?? ?? 8B F0 59 C7 46 20 01 00 00 00 E9 CA 00 00 00 56 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 59 8B F0 74 28 56 E8 ?? ?? ?? ?? 85 C0 59 74 1D 8B 06 2B 05 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 89 45 08 C7 46 20 01 00 00 00 8B 45 08 EB 0B 8B 06 2B 05 ?? ?? ?? ?? 89 45 08 53 6A 3C 59 99 8B D9 F7 FB 85 D2 89 16 7D 07 03 D1 89 16 29 4D 08 8B 45 08 99 8B D9 F7 FB 03 46 04 89 45 08 99 F7 FB 5B 85 D2 89 56 04 7D 09 83 C2 3C 89 56 04 29 4D 08 8B 45 08 99 F7 F9 6A 18 59 03 46 08 89 45 08 99 F7 F9 85 D2 89 56 08 7D 08 03 D1 89 56 08 29 4D 08 8B 45 08 6A 18 99 59 F7 F9 8B C8 85 C9 89 4D 08 7E 1F 8B 46 18 03 C1 99 6A 07 59 F7 F9 89 56 18 8B 45 08 01 46 0C 8B 45 08 01 46 1C 8B C6 5E 5D C3 7D F9 8B 46 18 8D 44 08 07 99 6A 07 59 F7 F9 89 56 18 8B 45 08 01 46 0C 8B 46 0C 85 C0 7F D6 83 C0 1F FF 4E 14 89 46 0C C7 46 1C 6C 01 00 00 C7 46 10 0B 00 00 00 EB C3 }
	condition:
		$1
}

rule file_579_0_0 {
	meta:
		name = "__aullshr"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F AD D0 D3 EA C3 8B C2 33 D2 80 E1 1F D3 E8 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_580_0_0 {
	meta:
		name = "___heap_select"
		size = 26
		refs = "0002 __osplatform 000b __winmajor"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 75 0D 83 3D ?? ?? ?? ?? 05 72 04 33 C0 40 C3 6A 03 58 C3 }
	condition:
		$1
}

rule file_580_1_0 {
	meta:
		name = "__heap_init"
		size = 81
		refs = "0013 __imp__HeapCreate@12 001a __crtheap 0021 ___heap_select 0029 ___active_heap 0035 ___sbh_heap_init 0046 __imp__HeapDestroy@4"
	strings:
		$1 = { 33 C0 39 44 24 04 6A 00 0F 94 C0 68 00 10 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 74 2A E8 ?? ?? ?? ?? 83 F8 03 A3 ?? ?? ?? ?? 75 1E 68 F8 03 00 00 E8 ?? ?? ?? ?? 85 C0 59 75 0F FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_580_2_0 {
	meta:
		name = "__heap_term"
		size = 127
		refs = "0002 ___active_heap 000e ___sbh_cntHeaderList 0015 __imp__HeapFree@12 001e ___sbh_pHeaderList 0025 __imp__VirtualFree@12 004c __crtheap 007a __imp__HeapDestroy@4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 03 75 69 53 33 DB 39 1D ?? ?? ?? ?? 55 8B 2D ?? ?? ?? ?? 7E 45 56 8B 35 ?? ?? ?? ?? 57 8B 3D ?? ?? ?? ?? 83 C6 0C 68 00 40 00 00 68 00 00 10 00 FF 36 FF D7 68 00 80 00 00 6A 00 FF 36 FF D7 FF 76 04 6A 00 FF 35 ?? ?? ?? ?? FF D5 83 C6 14 43 3B 1D ?? ?? ?? ?? 7C CE 5F 5E FF 35 ?? ?? ?? ?? 6A 00 FF 35 ?? ?? ?? ?? FF D5 5D 5B FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_581_0_0 {
	meta:
		name = "__vsnwprintf"
		size = 111
		refs = "002a __woutput 004a __flsbuf"
		altNames = "?vswprintf@@YAHPA_WIPB_WPAD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 89 45 E8 89 45 E0 8B 45 0C 56 FF 75 14 03 C0 FF 75 10 89 45 E4 8D 45 E0 50 C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C FF 4D E4 8B F0 78 0B 8B 45 E0 C6 00 00 FF 45 E0 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_582_0_0 {
	meta:
		name = "__write"
		size = 496
		refs = "0016 __nhandle 001b ___security_cookie 0036 ___pioinfo 0074 __lseeki64 00f6 __imp__WriteFile@20 011f __imp__GetLastError@0 014a __doserrno 0190 __dosmaperr 01b1 _errno 01e4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 64 FC FF FF 81 EC 1C 04 00 00 8B 8D A4 03 00 00 3B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 53 56 89 85 98 03 00 00 57 0F 83 98 01 00 00 8B C1 C1 F8 05 8D 1C 85 ?? ?? ?? ?? 8B 03 8B F1 83 E6 1F C1 E6 03 8A 44 30 04 A8 01 89 5D 80 0F 84 73 01 00 00 33 FF 39 BD AC 03 00 00 89 7D 8C 89 7D 84 75 07 33 C0 E9 70 01 00 00 A8 20 74 0D 6A 02 57 57 51 E8 ?? ?? ?? ?? 83 C4 10 8B 03 03 C6 F6 40 04 80 0F 84 C7 00 00 00 39 BD AC 03 00 00 8B 85 A8 03 00 00 89 45 90 89 BD A4 03 00 00 0F 86 F3 00 00 00 8B 4D 90 2B 8D A8 03 00 00 8D 45 94 3B 8D AC 03 00 00 73 25 8B 55 90 FF 45 90 8A 12 41 80 FA 0A 75 08 FF 45 84 C6 00 0D 40 47 8B 5D 80 88 10 40 47 81 FF 00 04 00 00 7C D3 8B F8 8D 45 94 2B F8 6A 00 8D 45 88 50 57 8D 45 94 50 8B 03 FF 34 30 FF 15 ?? ?? ?? ?? 85 C0 74 1F 8B 45 88 01 45 8C 3B C7 7C 21 8B 45 90 2B 85 A8 03 00 00 33 FF 3B 85 AC 03 00 00 72 89 EB 0E FF 15 ?? ?? ?? ?? 89 85 A4 03 00 00 33 FF 8B 45 8C 3B C7 0F 85 8B 00 00 00 39 BD A4 03 00 00 74 59 6A 05 58 39 85 A4 03 00 00 75 40 A3 ?? ?? ?? ?? EB 7D 57 8D 4D 88 51 FF B5 AC 03 00 00 FF B5 A8 03 00 00 FF 30 FF 15 ?? ?? ?? ?? 85 C0 74 0E 8B 45 88 89 BD A4 03 00 00 89 45 8C EB B0 FF 15 ?? ?? ?? ?? 89 85 A4 03 00 00 EB A2 FF B5 A4 03 00 00 E8 ?? ?? ?? ?? 59 EB 40 8B 03 F6 44 30 04 40 74 0F 8B 85 A8 03 00 00 80 38 1A 0F 84 B4 FE FF FF C7 05 ?? ?? ?? ?? 1C 00 00 00 89 3D ?? ?? ?? ?? EB 16 2B 45 84 EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 8B 8D 98 03 00 00 5F 5E 5B E8 ?? ?? ?? ?? 81 C5 9C 03 00 00 C9 C3 }
	condition:
		$1
}

rule file_583_0_0 {
	meta:
		name = "__mbctohira"
		size = 50
		refs = "0007 __ismbckata"
	strings:
		$1 = { 56 8B 74 24 08 56 E8 ?? ?? ?? ?? 85 C0 59 74 1E 81 FE 93 83 00 00 77 16 81 FE 7F 83 00 00 73 08 81 EE A1 00 00 00 EB 06 81 EE A2 00 00 00 8B C6 5E C3 }
	condition:
		$1
}

rule file_584_0_0 {
	meta:
		name = "_fgets"
		size = 87
		refs = "002e __filbuf"
	strings:
		$1 = { 55 8B EC 83 7D 0C 00 53 8B 5D 08 57 8B FB 7F 04 33 C0 EB 36 FF 4D 0C 56 74 2A 8B 75 10 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 16 88 07 47 3C 0A 74 05 FF 4D 0C 75 D9 C6 07 00 8B C3 5E 5F 5B 5D C3 3B 7D 08 75 F1 33 DB EB F0 }
	condition:
		$1
}

rule file_585_0_0 {
	meta:
		name = "__ftelli64"
		size = 392
		refs = "0022 __lseeki64 0072 ___pioinfo 00ad _errno"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8B 7D 08 8B 77 10 33 C0 39 47 04 89 75 F8 7D 03 89 47 04 6A 01 50 50 56 E8 ?? ?? ?? ?? 8B CA 83 C4 10 85 C9 8B D8 89 5D F0 89 4D F4 7F 06 7C 7C 85 DB 72 78 66 F7 47 0C 08 01 75 11 8B 47 04 99 2B D8 1B CA 8B C3 8B D1 E9 2D 01 00 00 8B 07 8B 4F 08 8B D0 2B D1 89 55 FC 8B 57 0C F6 C2 03 74 3D 8B D6 C1 FA 05 8B 14 95 ?? ?? ?? ?? 8B DE 83 E3 1F F6 44 DA 04 80 74 13 8B D1 3B D0 73 0D 80 3A 0A 75 03 FF 45 FC 42 3B 17 72 F3 8B 5D F0 0B 5D F4 75 22 8B 45 FC 33 D2 E9 DC 00 00 00 84 D2 78 ED C7 05 ?? ?? ?? ?? 16 00 00 00 83 CA FF 8B C2 E9 C4 00 00 00 F6 47 0C 01 0F 84 AF 00 00 00 8B 57 04 85 D2 75 08 21 55 FC E9 A0 00 00 00 2B C1 03 C2 89 45 08 8B C6 C1 F8 05 83 E6 1F 8D 1C 85 ?? ?? ?? ?? 8B 03 C1 E6 03 F6 44 06 04 80 74 74 6A 02 6A 00 6A 00 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 10 3B 45 F0 75 22 3B 55 F4 75 1D 8B 47 08 8B 4D 08 03 C8 EB 09 80 38 0A 75 03 FF 45 08 40 3B C1 72 F3 F6 47 0D 20 EB 37 6A 00 FF 75 F4 FF 75 F0 FF 75 F8 E8 ?? ?? ?? ?? B8 00 02 00 00 83 C4 10 39 45 08 77 0D 8B 4F 0C F6 C1 08 74 05 F6 C5 04 74 03 8B 47 18 89 45 08 8B 03 F6 44 06 04 04 74 03 FF 45 08 8B 45 08 29 45 F0 83 5D F4 00 8B 45 FC 33 D2 03 45 F0 13 55 F4 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_586_0_0 {
	meta:
		name = "_fclose"
		size = 86
		refs = "001b __flush 0023 __freebuf 002b __close 0044 _free"
	strings:
		$1 = { 56 8B 74 24 08 8B 46 0C 57 83 CF FF A8 40 74 05 83 C8 FF EB 3A A8 83 74 34 56 E8 ?? ?? ?? ?? 56 8B F8 E8 ?? ?? ?? ?? FF 76 10 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7D 05 83 CF FF EB 12 8B 46 1C 85 C0 74 0B 50 E8 ?? ?? ?? ?? 83 66 1C 00 59 8B C7 83 66 0C 00 5F 5E C3 }
	condition:
		$1
}

rule file_589_0_0 {
	meta:
		name = "_has_osfxsr_set"
		size = 53
		refs = "0003 $T1049 0008 __SEH_prolog 0030 __SEH_epilog"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 83 65 FC 00 66 0F 28 C1 C7 45 E4 01 00 00 00 EB 07 33 C0 40 C3 8B 65 E8 83 4D FC FF 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_589_1_0 {
	meta:
		name = "___sse2_available_init"
		size = 206
		refs = "0007 ___security_cookie 004f ___sse2_available 0056 ___use_sse2_mathfcns 0062 _has_osfxsr_set 0074 ??_C@_0N@FFJGBINN@AuthenticAMD?$AA@ 007f _strncmp 00c6 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 20 A1 ?? ?? ?? ?? 89 45 FC 33 C0 53 56 89 45 E4 89 45 E8 88 45 EC 53 9C 58 8B C8 35 00 00 20 00 50 9D 9C 5A 2B D1 74 1F 51 9D 33 C0 0F A2 89 45 E0 89 5D EC 89 55 F0 89 4D F4 B8 01 00 00 00 0F A2 89 55 E4 89 45 E8 5B 83 25 ?? ?? ?? ?? 00 83 25 ?? ?? ?? ?? 00 F6 45 E7 04 74 5F E8 ?? ?? ?? ?? 85 C0 74 56 6A 0C 8D 45 EC 33 F6 50 46 68 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 30 8B 4D E8 8B C1 C1 F8 08 83 E0 0F C1 F9 14 8B D0 83 EA 0F 81 E1 FF 00 00 00 F7 DA 1B D2 F7 D2 23 D1 03 D0 83 EA 0F F7 DA 1B D2 42 89 55 E0 75 06 89 35 ?? ?? ?? ?? 8B 4D FC 33 C0 E8 ?? ?? ?? ?? 5E 5B C9 C3 }
	condition:
		$1
}

rule file_589_2_0 {
	meta:
		name = "__set_SSE2_enable"
		size = 20
		refs = "000a ___sse2_available 000f ___use_sse2_mathfcns"
	strings:
		$1 = { 8B 44 24 04 F7 D8 1B C0 23 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_590_0_0 {
	meta:
		name = "__ismbcspace"
		size = 144
		refs = "0023 ___ismbcodepage 0039 ___mblcid 0042 ___mbcodepage 0050 ___crtGetStringTypeA 006f ___mb_cur_max 007a __isctype 0083 __pctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5E 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 75 04 33 C0 C9 C3 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 D6 66 83 7D FE 00 75 CF F6 45 FC 08 74 C9 33 C0 40 C9 C3 83 3D ?? ?? ?? ?? 01 7E 0C 6A 08 51 E8 ?? ?? ?? ?? 59 59 C9 C3 A1 ?? ?? ?? ?? 0F B6 04 48 83 E0 08 C9 C3 }
	condition:
		$1
}

rule file_591_0_0 {
	meta:
		name = "_gmtime"
		size = 245
		refs = "0056 _tb 007a __lpdays 0081 __days"
	strings:
		$1 = { 53 8B 5C 24 08 8B 0B 56 33 F6 85 C9 7D 07 33 C0 E9 DD 00 00 00 8B C1 99 57 BF 80 1F 86 07 F7 FF 8B D0 69 D2 80 E0 79 F8 03 CA BA 80 33 E1 01 3B CA 8D 04 85 46 00 00 00 7C 1B 2B CA 40 3B CA 7C 14 2B CA BA 00 85 E2 01 40 3B CA 7C 05 40 2B CA EB 03 33 F6 46 A3 ?? ?? ?? ?? 8B C1 55 BF 80 51 01 00 99 8B EF F7 FD 5D 8B D0 69 D2 80 AE FE FF 03 CA 85 F6 A3 ?? ?? ?? ?? BE ?? ?? ?? ?? 75 05 BE ?? ?? ?? ?? 33 D2 42 39 46 04 7D 06 42 39 04 96 7C FA 4A 89 15 ?? ?? ?? ?? 2B 04 96 6A 07 A3 ?? ?? ?? ?? 8B 03 99 F7 FF 5E 6A 3C 83 C0 04 99 F7 FE 8B C1 BE 10 0E 00 00 89 15 ?? ?? ?? ?? 99 F7 FE 5E 5F A3 ?? ?? ?? ?? 69 C0 F0 F1 FF FF 03 C8 8B C1 99 F7 FE A3 ?? ?? ?? ?? 6B C0 3C 2B C8 83 25 ?? ?? ?? ?? 00 89 0D ?? ?? ?? ?? B8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule file_593_0_0 {
	meta:
		name = "_wcsspn"
		size = 70
	strings:
		$1 = { 8B 44 24 04 53 33 C9 66 8B 08 66 85 C9 56 57 74 2B 8B 5C 24 14 33 FF 66 8B 3B 66 3B F9 8B F3 74 11 8B D7 66 85 D2 74 14 46 46 66 8B 16 66 3B D1 75 F1 40 40 66 8B 08 66 85 C9 75 DE 2B 44 24 10 5F 5E D1 F8 5B C3 }
	condition:
		$1
}

rule file_594_0_0 {
	meta:
		name = "__lsearch"
		size = 63
		refs = "002f _memcpy"
	strings:
		$1 = { 55 8B EC 53 8B 5D 0C 56 8B 75 10 57 33 FF 39 3E 76 15 53 FF 75 08 FF 55 18 85 C0 59 59 74 19 03 5D 14 47 3B 3E 72 EB FF 75 14 FF 75 08 53 E8 ?? ?? ?? ?? 83 C4 0C FF 06 5F 5E 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_595_2_0 {
	meta:
		name = "__callnewh"
		size = 27
		refs = "0001 ?_pnhHeap@@3P6AHI@ZA"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 0F FF 74 24 04 FF D0 85 C0 59 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_596_0_0 {
	meta:
		name = "__CIlog_pentium4"
		size = 624
		refs = "0039 emask 0041 One 0049 Magic 0051 hi_mask 006f B_Tbl 0077 T_Tbl 00d9 coeff 0105 LOG_2 0111 place_L 0168 Zero 01b7 Infs 01e2 Two52 0233 ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F3 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 AE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 15 C9 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E8 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 02 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 2F FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 03 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E8 03 00 00 EB A6 8D 64 24 00 }
	condition:
		$1
}

rule file_597_0_0 {
	meta:
		name = "__tzset"
		size = 595
		refs = "0007 _dstend 000e _dststart 0018 ___lc_codepage 001f ??_C@_02CLFPBFFP@TZ?$AA@ 0028 _tzapiused 002d _getenv 0045 _lastTZ 0050 _strcmp 0069 _free 0070 _strlen 0077 _malloc 008d _strcpy 0096 __tzname 009b _strncpy 00bc _atol 00c8 __timezone 0131 __daylight 0170 _tzinfo 0176 __imp__GetTimeZoneInformation@4 01d2 __dstbias 01e6 __imp__WideCharToMultiByte@32"
	strings:
		$1 = { 55 8B EC 51 51 83 0D ?? ?? ?? ?? FF 83 0D ?? ?? ?? ?? FF 53 56 57 8B 3D ?? ?? ?? ?? 33 DB 68 ?? ?? ?? ?? 89 5D F8 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 3B F3 59 0F 84 1D 01 00 00 38 1E 0F 84 15 01 00 00 A1 ?? ?? ?? ?? 3B C3 74 21 50 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 F0 01 00 00 A1 ?? ?? ?? ?? 3B C3 74 07 50 E8 ?? ?? ?? ?? 59 56 E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 3B C3 59 59 A3 ?? ?? ?? ?? 0F 84 C4 01 00 00 56 50 E8 ?? ?? ?? ?? 6A 03 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C6 03 83 C4 14 88 58 03 80 3E 2D 75 08 C7 45 F8 01 00 00 00 46 56 E8 ?? ?? ?? ?? 69 C0 10 0E 00 00 59 A3 ?? ?? ?? ?? 8A 06 3C 2B 74 08 3C 30 7C 07 3C 39 7F 03 46 EB EF 80 3E 3A 75 3E 46 56 E8 ?? ?? ?? ?? 6B C0 3C 01 05 ?? ?? ?? ?? 59 EB 05 3C 39 7F 07 46 8A 06 3C 30 7D F5 80 3E 3A 75 1B 46 56 E8 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? 59 EB 05 3C 39 7F 07 46 8A 06 3C 30 7D F5 39 5D F8 74 06 F7 1D ?? ?? ?? ?? 0F BE 06 3B C3 A3 ?? ?? ?? ?? 0F 84 0C 01 00 00 6A 03 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C4 0C 88 58 03 E9 F5 00 00 00 A1 ?? ?? ?? ?? 3B C3 74 0D 50 E8 ?? ?? ?? ?? 59 89 1D ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 FF 0F 84 CB 00 00 00 A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 6B C0 3C 33 D2 42 66 39 1D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 74 0C 8B F1 6B F6 3C 03 C6 A3 ?? ?? ?? ?? 66 39 1D ?? ?? ?? ?? 74 1B A1 ?? ?? ?? ?? 3B C3 74 12 2B C1 6B C0 3C 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 0C 89 1D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8D 45 FC 50 53 6A 3F FF 35 ?? ?? ?? ?? 6A FF 68 ?? ?? ?? ?? 53 57 FF D6 85 C0 74 0F 39 5D FC 75 0A A1 ?? ?? ?? ?? 88 58 3F EB 07 A1 ?? ?? ?? ?? 88 18 8D 45 FC 50 53 6A 3F FF 35 ?? ?? ?? ?? 6A FF 68 ?? ?? ?? ?? 53 57 FF D6 85 C0 74 0F 39 5D FC 75 0A A1 ?? ?? ?? ?? 88 58 3F EB 07 A1 ?? ?? ?? ?? 88 18 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_597_1_0 {
	meta:
		name = "_cvtdate"
		size = 440
		refs = "004b __days 0058 __lpdays 0151 _dststart 016e __dstbias 0174 _dstend"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B 7D 10 8B F0 8B C7 6A 04 99 5B F7 FB 83 7D 0C 01 0F 85 E9 00 00 00 85 D2 89 55 F8 75 0C 8B C7 6A 64 99 5B F7 FB 85 D2 75 1F 8D 87 6C 07 00 00 99 BB 90 01 00 00 F7 FB 85 D2 74 0D 8B C6 C1 E0 02 8B B0 ?? ?? ?? ?? EB 0B 8B C6 C1 E0 02 8B B0 ?? ?? ?? ?? 89 45 0C 8D 87 2B 01 00 00 99 8D 5F FF BF 90 01 00 00 F7 FF 6A 64 5F 46 6A 04 89 45 FC 8B C3 99 F7 FF 8B 55 FC 5F 6A 07 2B D0 8B 45 10 48 8B DA 99 F7 FF 8B 7D 10 8B D7 69 D2 6D 01 00 00 03 C6 03 C3 8D 84 02 25 9C FF FF 99 5B F7 FB 8B 45 14 6B C0 07 2B C2 03 45 18 3B 55 18 7F 06 8D 74 06 F9 EB 02 03 F0 83 7D 14 05 75 76 83 7D F8 00 75 0C 8B C7 6A 64 99 5B F7 FB 85 D2 75 1D 8D 87 6C 07 00 00 99 BB 90 01 00 00 F7 FB 85 D2 74 0B 8B 45 0C 8B 80 ?? ?? ?? ?? EB 09 8B 45 0C 8B 80 ?? ?? ?? ?? 3B F0 7E 3A 83 EE 07 EB 35 85 D2 75 0C 8B C7 6A 64 99 5B F7 FB 85 D2 75 1B 8D 87 6C 07 00 00 99 BB 90 01 00 00 F7 FB 85 D2 74 09 8B 34 B5 ?? ?? ?? ?? EB 07 8B 34 B5 ?? ?? ?? ?? 03 75 1C 6B C9 3C 03 4D 20 6B C9 3C 83 7D 08 01 75 20 03 4D 24 89 35 ?? ?? ?? ?? 69 C9 E8 03 00 00 03 4D 28 89 3D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? EB 47 03 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 03 4D 24 69 C9 E8 03 00 00 03 4D 28 89 0D ?? ?? ?? ?? 79 09 81 C1 00 5C 26 05 4E EB 0C B8 00 5C 26 05 3B C8 7C 0F 2B C8 46 89 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_597_2_0 {
	meta:
		name = "__isindst"
		size = 397
		refs = "0005 __daylight 001e _dststart 0026 _dstend 0032 _tzapiused 003f _tzinfo 008e _cvtdate"
	strings:
		$1 = { 56 33 F6 39 35 ?? ?? ?? ?? 75 04 33 C0 5E C3 53 8B 5C 24 0C 55 33 ED 57 8B 7B 14 45 3B 3D ?? ?? ?? ?? 75 0C 3B 3D ?? ?? ?? ?? 0F 84 EC 00 00 00 39 35 ?? ?? ?? ?? 0F 84 B4 00 00 00 66 39 35 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 50 0F B7 05 ?? ?? ?? ?? 50 0F B7 05 ?? ?? ?? ?? 50 75 15 0F B7 05 ?? ?? ?? ?? 56 50 0F B7 05 ?? ?? ?? ?? 50 57 55 EB 0C 0F B7 05 ?? ?? ?? ?? 50 56 56 57 56 0F B7 05 ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 83 C4 24 66 39 35 ?? ?? ?? ?? 50 0F B7 05 ?? ?? ?? ?? 50 0F B7 05 ?? ?? ?? ?? 50 75 25 0F B7 05 ?? ?? ?? ?? 56 50 0F B7 05 ?? ?? ?? ?? 50 57 55 0F B7 05 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 24 EB 3A 0F B7 05 ?? ?? ?? ?? 50 56 56 57 56 EB E0 56 56 56 56 56 55 57 55 55 6A 02 59 6A 04 58 E8 ?? ?? ?? ?? 56 56 56 56 56 6A 05 57 55 56 6A 02 59 6A 0A 58 E8 ?? ?? ?? ?? 83 C4 48 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B D0 8B 4B 1C 7D 17 3B CA 7C 23 3B C8 7F 1F 3B CA 7E 1F 3B C8 7D 1B 8B C5 5F 5D 5B 5E C3 3B C8 7C F5 3B CA 7F F1 3B C8 7E 08 3B CA 7D 04 33 C0 EB E7 8B 43 08 6B C0 3C 03 43 04 6B C0 3C 03 03 69 C0 E8 03 00 00 3B CA 75 0D 33 C9 3B 05 ?? ?? ?? ?? 0F 9D C1 EB 0B 33 C9 3B 05 ?? ?? ?? ?? 0F 9C C1 8B C1 EB B3 }
	condition:
		$1
}

rule file_597_3_0 {
	meta:
		name = "___tzset"
		size = 21
		refs = "0002 ?first_time@?1??__tzset@@9@9 000a __tzset"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 0B E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_603_0_0 {
	meta:
		name = "__hypothlp"
		size = 635
		refs = "0015 __ctrlfp 0046 __real@0000000000000000 00de _sqrt 00e6 __decomp 0111 __get_exp 0133 __set_exp 0236 __except2 0252 __d_inf 026f __handle_qnan2"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B 55 0E 8B 7D 16 59 59 8B D8 B8 F0 7F 00 00 8B CA 66 23 C8 66 3B C8 0F 84 AE 01 00 00 8B CF 66 23 C8 66 3B C8 0F 84 A0 01 00 00 DD 05 ?? ?? ?? ?? DD 45 08 D8 D9 DF E0 F6 C4 05 7A 08 DD 45 08 D9 E0 DD 5D 08 DD 45 10 D8 D9 DF E0 F6 C4 05 7A 08 DD 45 10 D9 E0 DD 5D 10 DD 45 10 DC 5D 08 DF E0 F6 C4 41 75 05 DD 45 10 EB 03 DD 45 08 DD 5D F0 D9 C0 DD 45 F0 DA E9 DF E0 DD D8 F6 C4 44 7A 14 56 53 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 59 E9 C8 01 00 00 DD 45 08 8D 45 F8 DC 75 F0 50 51 51 DD 5D 08 DD 45 10 DC 75 F0 DD 5D 10 DD 45 08 DC 4D 08 DD 45 10 DC 4D 10 DE C1 DD 5D E8 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E8 DD 45 F0 8D 45 FC 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 83 C4 04 DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 03 45 FC DD 45 F0 59 03 45 F8 59 3D 00 04 00 00 7E 38 05 00 FA FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F0 83 C4 0C DD 45 F0 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 11 E9 D6 00 00 00 3D 03 FC FF FF 7D 38 05 00 06 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F0 83 C4 0C DD 45 F0 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 12 E9 97 00 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F0 F6 C3 20 74 11 56 53 E8 ?? ?? ?? ?? DD 45 F0 59 59 E9 B1 00 00 00 DD 45 F0 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 10 EB 51 B9 F8 7F 00 00 23 D1 66 3B D0 75 0F F7 45 0C FF FF 07 00 75 1C 83 7D 08 00 75 16 23 F9 66 3B F8 75 39 F7 45 14 FF FF 07 00 75 06 83 7D 10 00 74 2A DD 45 08 53 DC 45 10 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 08 E8 ?? ?? ?? ?? 83 C4 24 EB 37 66 3B D1 74 16 66 3B F9 74 11 56 53 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 59 EB 1C DD 45 10 53 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_603_1_0 {
	meta:
		name = "__hypot"
		size = 29
		refs = "0015 __hypothlp"
	strings:
		$1 = { DD 44 24 0C 6A 18 83 EC 10 DD 5C 24 08 DD 44 24 18 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_603_2_0 {
	meta:
		name = "__cabs"
		size = 29
		refs = "0015 __hypothlp"
	strings:
		$1 = { DD 44 24 0C 6A 11 83 EC 10 DD 5C 24 08 DD 44 24 18 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_604_0_0 {
	meta:
		name = "___dtoxmode"
		size = 189
		refs = "0053 __mbsrchr 0060 ??_C@_04JLMDILM@?4exe?$AA@ 0066 __mbsicmp 0071 ??_C@_04CPCBDHLK@?4cmd?$AA@ 0082 ??_C@_04NEEFLLOK@?4bat?$AA@ 0093 ??_C@_04PNGHFIJN@?4com?$AA@"
	strings:
		$1 = { 8B 44 24 04 56 8B 74 24 0C 25 FF 00 00 00 80 7E 01 3A 57 8B CE 75 03 8D 4E 02 8A 11 80 FA 5C 74 05 80 FA 2F 75 06 80 79 01 00 74 0D A8 10 75 09 84 D2 BF 00 80 00 00 75 05 BF 40 40 00 00 C1 E0 07 F6 D0 6A 2E 56 25 80 00 00 00 0D 00 01 00 00 0B F8 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 74 47 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 33 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 22 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 11 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 03 83 CF 40 8B C7 C1 E8 03 83 E0 38 0B F8 8B C7 C1 E8 06 83 E0 07 0B C7 5F 5E C3 }
	condition:
		$1
}

rule file_604_2_0 {
	meta:
		name = "__stat"
		size = 827
		refs = "000c ___security_cookie 0015 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 001e __mbspbrk 002c _errno 0031 __doserrno 006b __mbctolower 0076 __getdrive 008b __imp__FindFirstFileA@8 00a1 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 00bf __fullpath 00ce _strlen 00d9 _IsRootUNCName 00e4 __imp__GetDriveTypeA@4 0117 ___loctotime_t 0151 __imp__FileTimeToLocalFileTime@8 016d __imp__FileTimeToSystemTime@8 02cd __imp__FindClose@4 02db ___dtoxmode 0312 __imp__GetLastError@0 0318 __dosmaperr 0332 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 90 81 EC 68 02 00 00 A1 ?? ?? ?? ?? 56 8B 75 78 68 ?? ?? ?? ?? 56 89 45 6C E8 ?? ?? ?? ?? 85 C0 59 59 74 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 F0 02 00 00 53 33 DB 80 7E 01 3A 75 2F 8A 06 3A C3 74 1A 38 5E 02 75 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 C6 02 00 00 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 08 FE FF FF 57 8D 85 2C FF FF FF 50 56 FF 15 ?? ?? ?? ?? 83 CF FF 3B C7 89 85 14 FE FF FF 0F 85 A1 00 00 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 7E 68 04 01 00 00 8D 85 28 FE FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 3B F3 74 63 56 E8 ?? ?? ?? ?? 83 F8 03 59 74 09 E8 ?? ?? ?? ?? 85 C0 74 4E 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 42 57 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 85 2C FF FF FF 10 00 00 00 89 9D 48 FF FF FF 89 9D 4C FF FF FF 88 9D 58 FF FF FF E8 ?? ?? ?? ?? 8B 75 7C 83 C4 1C 89 46 1C 89 46 18 89 46 20 E9 A2 01 00 00 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 E8 01 00 00 8D 85 0C FE FF FF 50 8D 85 40 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B3 01 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 97 01 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 8B 75 7C 83 C4 1C 39 9D 38 FF FF FF 89 46 1C 75 08 39 9D 3C FF FF FF 74 71 8D 85 0C FE FF FF 50 8D 85 38 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 2C 01 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 10 01 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 39 9D 30 FF FF FF 89 46 18 75 0D 39 9D 34 FF FF FF 75 05 8B 46 1C EB 71 8D 85 0C FE FF FF 50 8D 85 30 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A3 00 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 87 00 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C FF B5 14 FE FF FF 89 46 20 FF 15 ?? ?? ?? ?? FF 75 78 FF B5 2C FF FF FF E8 ?? ?? ?? ?? 66 89 46 06 8B 85 4C FF FF FF 89 46 14 8B 85 08 FE FF FF 48 59 89 06 89 46 10 59 66 C7 46 08 01 00 66 89 5E 04 66 89 5E 0C 66 89 5E 0A 33 C0 EB 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 14 FE FF FF FF 15 ?? ?? ?? ?? 8B C7 5F 5B 8B 4D 6C 5E E8 ?? ?? ?? ?? 83 C5 70 C9 C3 }
	condition:
		$1
}

rule file_605_0_0 {
	meta:
		name = "??__D@YGXPAX0IHP6EX00@ZP6EX0@Z@Z"
		size = 102
		refs = "0003 $T334 0008 __SEH_prolog 0047 __SEH_epilog 0061 ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 45 E0 89 45 FC 89 45 E4 33 F6 46 8B 45 E4 3B 45 14 7D 18 56 FF 75 0C 8B 4D 08 FF 55 18 8B 45 10 01 45 08 01 45 0C FF 45 E4 EB E0 89 75 E0 83 4D FC FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 18 00 83 7D E0 00 75 11 FF 75 1C FF 75 E4 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_606_0_0 {
	meta:
		name = "___crtGetCommandLineW"
		size = 159
		refs = "0001 ?f_use@?1??__crtGetCommandLineW@@9@9 000d __imp__GetCommandLineW@0 0027 __imp__GetLastError@0 0052 __imp__GetCommandLineA@0 0058 __imp__MultiByteToWideChar@24 0073 _malloc 008f _free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 55 33 ED 3B C5 56 8B 35 ?? ?? ?? ?? 75 2D FF D6 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 20 FF 15 ?? ?? ?? ?? 83 F8 78 75 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 12 33 C0 EB 5C 83 F8 01 75 04 FF D6 EB 53 83 F8 02 75 EE 53 57 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 55 55 6A FF 8B D8 53 6A 01 55 FF D7 8B F0 3B F5 74 26 8D 04 36 50 E8 ?? ?? ?? ?? 8B E8 85 ED 59 74 16 56 55 6A FF 53 6A 01 6A 00 FF D7 85 C0 75 0B 55 E8 ?? ?? ?? ?? 59 33 C0 EB 02 8B C5 5F 5B 5E 5D C3 }
	condition:
		$1
}

rule file_608_0_0 {
	meta:
		name = "__wmakepath"
		size = 177
	strings:
		$1 = { 55 8B EC 8B 45 0C 85 C0 56 6A 02 5E 74 19 66 8B 08 66 85 C9 74 11 8B 45 08 66 89 08 03 C6 66 C7 00 3A 00 03 C6 EB 03 8B 45 08 8B 55 10 85 D2 74 32 33 C9 66 8B 0A 66 85 C9 74 28 66 89 08 03 D6 33 C9 66 8B 0A 03 C6 66 85 C9 75 EF 66 8B 52 FE 66 83 FA 2F 74 0D 66 83 FA 5C 74 07 66 C7 00 5C 00 03 C6 8B 55 14 85 D2 74 13 EB 07 66 89 08 03 C6 03 D6 33 C9 66 8B 0A 66 85 C9 75 EF 8B 55 18 85 D2 74 26 66 8B 0A 66 85 C9 74 0D 66 83 F9 2E 74 07 66 C7 00 2E 00 03 C6 66 8B 0A 66 89 08 03 C6 03 D6 66 85 C9 75 F1 EB 04 66 83 20 00 5E 5D C3 }
	condition:
		$1
}

rule file_610_1_0 {
	meta:
		name = "__wpopen"
		size = 871
		refs = "006b __pipe 00a0 __imp__GetCurrentProcess@0 00c0 ___pioinfo 00d1 __imp__DuplicateHandle@28 00e3 __close 00f6 __wfdopen 010b _idtab 011b ??_C@_1BA@HMCCKBDK@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 0120 __wgetenv 012d _errno 013d __osver 0145 ??_C@_1BI@LHBFHNF@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@ 014e ??_C@_1BA@DBKIDAPL@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 015c _memset 019c _wcslen 01ab ??_C@_19FNCMDGGJ@?$AA?5?$AA?1?$AAc?$AA?5?$AA?$AA@ 01bf _malloc 01d8 _wcscpy 01df _wcscat 01f1 __waccess 0212 __imp__CreateProcessW@40 021f ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 0241 _free 0278 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 02c2 __wgetpath 0304 __imp__CloseHandle@4 0323 _fclose"
	strings:
		$1 = { 55 8D 6C 24 90 81 EC 88 00 00 00 56 33 F6 33 C9 39 75 78 89 75 64 89 75 58 0F 84 3F 03 00 00 57 8B 7D 7C 3B FE 0F 84 32 03 00 00 66 8B 07 66 3D 77 00 74 0A 66 3D 72 00 0F 85 1F 03 00 00 66 8B 47 02 66 3D 74 00 75 07 B9 00 40 00 00 EB 0B 66 3D 62 00 75 05 B9 00 80 00 00 81 C9 80 00 00 00 51 8D 45 40 68 00 04 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 E2 02 00 00 53 33 DB 66 83 3F 77 75 0B 33 FF 43 89 75 68 89 5D 60 EB 09 43 89 5D 68 8B FB 89 75 60 89 5D 50 89 5D 4C FF 15 ?? ?? ?? ?? 6A 02 53 C1 E7 02 56 8D 4C 3D 40 89 4D 48 8B 09 8D 55 5C 52 8B D1 C1 FA 05 8B 14 95 ?? ?? ?? ?? 50 83 E1 1F FF 34 CA 89 7D 3C 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 58 02 00 00 8B 45 48 FF 30 E8 ?? ?? ?? ?? FF 75 7C 8B 45 60 FF 74 85 40 89 74 3D 4C E8 ?? ?? ?? ?? 83 C4 0C 3B C6 89 45 64 0F 84 2D 02 00 00 33 FF E8 ?? ?? ?? ?? 3B C6 89 45 54 0F 84 05 02 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B C6 59 89 45 6C 75 26 A1 ?? ?? ?? ?? 83 F8 02 74 05 83 F8 0D 75 17 F6 05 ?? ?? ?? ?? 80 C7 45 6C ?? ?? ?? ?? 75 07 C7 45 6C ?? ?? ?? ?? 6A 44 5F 57 8D 45 E8 56 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 C4 0C 39 75 68 89 7D E8 C7 45 14 00 01 00 00 75 08 8B 4D 5C 89 4D 20 EB 0D 39 5D 68 8B 08 89 4D 20 8B 4D 5C 74 03 8B 48 08 FF 75 6C 89 4D 24 8B 40 10 89 45 28 E8 ?? ?? ?? ?? FF 75 78 8B D8 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? 57 03 D8 E8 ?? ?? ?? ?? 03 D8 8D 44 1B 02 50 E8 ?? ?? ?? ?? 8B D8 83 C4 10 3B DE 89 5D 68 0F 84 4C 01 00 00 FF 75 6C 53 E8 ?? ?? ?? ?? 57 53 E8 ?? ?? ?? ?? FF 75 78 53 E8 ?? ?? ?? ?? 56 FF 75 6C E8 ?? ?? ?? ?? 83 C4 20 83 F8 FF 74 21 8D 45 2C 50 8D 45 E8 50 56 56 56 6A 01 56 56 53 FF 75 6C FF 15 ?? ?? ?? ?? 89 45 58 E9 DA 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 C7 04 24 08 02 00 00 E8 ?? ?? ?? ?? 8B F8 3B FE 59 75 0E FF 75 68 E8 ?? ?? ?? ?? 59 E9 D4 00 00 00 68 03 01 00 00 57 53 EB 6D 66 39 37 0F 84 91 00 00 00 57 E8 ?? ?? ?? ?? 8D 44 47 FE 66 8B 00 66 3D 5C 00 59 74 13 66 3D 2F 00 74 0D 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 FF 75 6C E8 ?? ?? ?? ?? 57 8B D8 E8 ?? ?? ?? ?? 03 D8 81 FB 04 01 00 00 59 59 73 4E FF 75 6C 57 E8 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 1A 68 03 01 00 00 57 FF 75 78 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 89 45 78 75 84 EB 1C 8D 45 2C 50 8D 45 E8 50 56 56 56 6A 01 56 56 FF 75 68 57 FF 15 ?? ?? ?? ?? 89 45 58 57 E8 ?? ?? ?? ?? 8B 5D 68 59 53 E8 ?? ?? ?? ?? 59 FF 75 5C FF 15 ?? ?? ?? ?? 39 75 58 8B 45 54 74 0D 8B 4D 2C 89 48 04 8B 4D 64 89 08 EB 3F 89 30 FF 75 64 E8 ?? ?? ?? ?? 8B 45 60 8B 7D 3C 59 89 74 85 4C 89 75 64 39 74 3D 4C 74 0B 8B 45 48 FF 30 E8 ?? ?? ?? ?? 59 8B 45 60 C1 E0 02 39 74 05 4C 74 0A FF 74 05 40 E8 ?? ?? ?? ?? 59 5B 5F 8B 45 64 5E 83 C5 70 C9 C3 }
	condition:
		$1
}

rule file_612_0_0 {
	meta:
		name = "__searchenv"
		size = 285
		refs = "000a ___security_cookie 0018 __access 002f __fullpath 0049 _getenv 0080 _strlen 00ba _strcpy 00e2 __getpath 0104 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 10 01 00 00 A1 ?? ?? ?? ?? 56 6A 00 FF 75 08 89 45 FC E8 ?? ?? ?? ?? 85 C0 59 59 75 23 8B 75 10 68 04 01 00 00 FF 75 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 C1 00 00 00 88 06 E9 BA 00 00 00 FF 75 0C E8 ?? ?? ?? ?? 85 C0 59 75 0B 8B 45 10 C6 00 00 E9 A2 00 00 00 53 57 BF 04 01 00 00 57 8D 8D F4 FE FF FF 51 50 EB 72 80 BD F4 FE FF FF 00 74 7F 8D 85 F4 FE FF FF 50 E8 ?? ?? ?? ?? 8B D8 8D B4 1D F4 FE FF FF 0F BE 46 FF 83 F8 2F 59 74 0F 83 F8 5C 74 0A 83 F8 3A 74 05 C6 06 5C 46 43 FF 75 08 E8 ?? ?? ?? ?? 03 C3 3B C7 59 73 1E FF 75 08 56 E8 ?? ?? ?? ?? 8D 85 F4 FE FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 37 57 8D 85 F4 FE FF FF 50 FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 89 85 F0 FE FF FF 0F 85 78 FF FF FF 8B 45 10 C6 00 00 5F 5B 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C3 8D 85 F4 FE FF FF 50 FF 75 10 E8 ?? ?? ?? ?? 59 59 EB E0 }
	condition:
		$1
}

rule file_614_0_0 {
	meta:
		name = "__sopen"
		size = 720
		refs = "003f __fmode 008c _errno 0096 __doserrno 014b __umaskval 016b __osplatform 0194 __alloc_osfhnd 01ce __imp__CreateFileA@28 01db __imp__GetFileType@4 01e6 __imp__CloseHandle@4 01ec __imp__GetLastError@0 01f2 __dosmaperr 0210 __set_osfhnd 0228 ___pioinfo 024e __lseek 0291 __read 02a7 __chsize 02c6 __close"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8B 4D 0C 53 33 DB 84 C9 56 C7 45 E4 0C 00 00 00 89 5D E8 79 09 89 5D EC C6 45 FF 10 EB 0B C7 45 EC 01 00 00 00 C6 45 FF 00 B8 00 80 00 00 85 C8 75 11 F6 C5 40 75 08 39 05 ?? ?? ?? ?? 74 04 80 4D FF 80 6A 03 8B C1 5E 23 C6 2B C3 74 18 48 74 0C 48 75 30 C7 45 F0 00 00 00 C0 EB 10 C7 45 F0 00 00 00 40 EB 07 C7 45 F0 00 00 00 80 8B 45 10 83 F8 10 74 3E 83 F8 20 74 30 83 F8 30 74 22 83 F8 40 74 18 C7 05 ?? ?? ?? ?? 16 00 00 00 89 1D ?? ?? ?? ?? 83 C8 FF E9 DF 01 00 00 89 75 F8 EB 15 C7 45 F8 02 00 00 00 EB 0C C7 45 F8 01 00 00 00 EB 03 89 5D F8 8B C1 BA 00 07 00 00 23 C2 B9 00 04 00 00 3B C1 57 BF 00 01 00 00 7F 2F 74 28 3B C3 74 24 3B C7 74 17 3D 00 02 00 00 74 48 3D 00 03 00 00 75 29 C7 45 F4 02 00 00 00 EB 48 C7 45 F4 04 00 00 00 EB 3F 89 75 F4 EB 3A 3D 00 05 00 00 74 2C 3D 00 06 00 00 74 1C 3B C2 74 21 C7 05 ?? ?? ?? ?? 16 00 00 00 89 1D ?? ?? ?? ?? 83 C8 FF E9 53 01 00 00 C7 45 F4 05 00 00 00 EB 07 C7 45 F4 01 00 00 00 8B 45 0C 85 C7 BE 80 00 00 00 74 12 8B 0D ?? ?? ?? ?? F7 D1 23 4D 14 84 C9 78 03 33 F6 46 A8 40 74 17 80 4D F2 01 81 CE 00 00 00 04 83 3D ?? ?? ?? ?? 02 75 04 83 4D F8 04 F6 C4 10 74 02 0B F7 A8 20 74 08 81 CE 00 00 00 08 EB 0A A8 10 74 06 81 CE 00 00 00 10 E8 ?? ?? ?? ?? 8B D8 83 CF FF 3B DF 75 18 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 18 00 00 00 8B C7 E9 C7 00 00 00 6A 00 56 FF 75 F4 8D 45 E4 50 FF 75 F8 FF 75 F0 FF 75 08 FF 15 ?? ?? ?? ?? 8B F0 3B F7 74 12 56 FF 15 ?? ?? ?? ?? 85 C0 75 16 56 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B9 83 F8 02 75 06 80 4D FF 40 EB 09 83 F8 03 75 04 80 4D FF 08 56 53 E8 ?? ?? ?? ?? 8A 45 FF 59 59 8B CB C1 F9 05 0C 01 8B F3 83 E6 1F 8D 3C 8D ?? ?? ?? ?? 8B 0F C1 E6 03 88 45 FF 80 65 FF 48 88 44 31 04 75 2B 84 C0 79 27 F6 45 0C 02 74 21 6A 02 6A FF 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 89 45 F0 75 28 81 3D ?? ?? ?? ?? 83 00 00 00 75 5B 80 7D FF 00 75 0F F6 45 0C 08 74 09 8B 07 8D 44 30 04 80 08 20 8B C3 5F 5E 5B C9 C3 6A 01 8D 45 FE 50 53 C6 45 FE 00 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 16 80 7D FE 1A 75 10 FF 75 F0 53 E8 ?? ?? ?? ?? 83 F8 FF 59 59 74 12 6A 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 A5 53 E8 ?? ?? ?? ?? 59 E9 55 FE FF FF }
	condition:
		$1
}

rule file_616_0_0 {
	meta:
		name = "__wfullpath"
		size = 168
		refs = "0024 _malloc 0031 _errno 0051 __imp__GetFullPathNameW@16 0060 _free 0084 __imp__GetLastError@0 008a __dosmaperr 009d __wgetcwd"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 0C 85 FF 0F 84 85 00 00 00 66 83 3F 00 74 7F 8B 5D 08 85 DB 75 26 68 08 02 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 59 75 0C C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 34 C7 45 10 04 01 00 00 EB 02 8B F3 8D 45 0C 50 56 FF 75 10 57 FF 15 ?? ?? ?? ?? 3B 45 10 72 19 85 DB 75 07 56 E8 ?? ?? ?? ?? 59 C7 05 ?? ?? ?? ?? 22 00 00 00 33 C0 EB 30 85 C0 75 1B 85 DB 75 07 56 E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 EB 10 8B C6 EB 0D FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_618_0_0 {
	meta:
		name = "__strdate"
		size = 112
		refs = "000f __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 8D 45 EC 50 FF 15 ?? ?? ?? ?? 0F B7 45 EC 99 6A 64 59 F7 F9 0F B7 75 EE 8B C6 6A 0A 5E 8B 4D 08 0F B7 7D F2 B3 30 C6 41 05 2F C6 41 02 2F C6 41 08 00 89 55 FC 99 F7 FE 02 C3 88 01 02 D3 88 51 01 8B C7 99 F7 FE 5F 02 C3 88 41 03 8B 45 FC 02 D3 88 51 04 99 F7 FE 5E 02 C3 02 D3 88 41 06 88 51 07 8B C1 5B C9 C3 }
	condition:
		$1
}

rule file_619_0_0 {
	meta:
		name = "___security_init_cookie"
		size = 102
		refs = "0007 ___security_cookie 001d __imp__GetSystemTimeAsFileTime@4 0029 __imp__GetCurrentProcessId@0 0031 __imp__GetCurrentThreadId@0 0039 __imp__GetTickCount@0 0045 __imp__QueryPerformanceCounter@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 85 C0 74 07 3D 4E E6 40 BB 75 4E 56 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 75 FC 33 75 F8 FF 15 ?? ?? ?? ?? 33 F0 FF 15 ?? ?? ?? ?? 33 F0 FF 15 ?? ?? ?? ?? 33 F0 8D 45 F0 50 FF 15 ?? ?? ?? ?? 8B 45 F4 33 45 F0 33 F0 89 35 ?? ?? ?? ?? 75 0A C7 05 ?? ?? ?? ?? 4E E6 40 BB 5E C9 C3 }
	condition:
		$1
}

rule file_620_0_0 {
	meta:
		name = "_winit_namebuf"
		size = 108
		refs = "0007 _namebuf0 000e _namebuf1 0013 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0019 _wcscpy 0052 __getpid 0058 __ultow 005d ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 0063 _wcscat"
	strings:
		$1 = { 83 7C 24 04 00 56 BE ?? ?? ?? ?? 74 05 BE ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 8D 46 02 59 66 8B 48 FE 66 83 F9 5C 74 0D 66 83 F9 2F 74 07 66 C7 00 5C 00 40 40 83 7C 24 08 00 74 07 66 C7 00 74 00 EB 05 66 C7 00 73 00 40 40 6A 20 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 14 5E C3 }
	condition:
		$1
}

rule file_620_1_0 {
	meta:
		name = "_wgenfname"
		size = 90
		refs = "0007 ___security_cookie 0015 _wcsrchr 0023 _wcstoul 003f __ultow 0046 _wcscpy 0054 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 56 6A 2E FF 75 08 89 45 FC E8 ?? ?? ?? ?? 8B F0 6A 20 46 46 6A 00 56 E8 ?? ?? ?? ?? 83 C4 14 40 3D FF 7F 00 00 72 05 83 C8 FF EB 18 6A 20 8D 4D F4 51 50 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_620_2_0 {
	meta:
		name = "__wtmpnam"
		size = 78
		refs = "0007 _namebuf0 0014 _winit_namebuf 001d _wgenfname 002a __waccess 0043 _wcscpy"
	strings:
		$1 = { 56 57 33 FF 66 39 3D ?? ?? ?? ?? BE ?? ?? ?? ?? 75 09 57 E8 ?? ?? ?? ?? 59 EB 0B 56 E8 ?? ?? ?? ?? 85 C0 59 75 23 6A 00 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 E7 8B 7C 24 0C 85 FF 75 04 8B FE EB 09 56 57 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_621_0_0 {
	meta:
		name = "_isalpha"
		size = 46
		refs = "0002 ___mb_cur_max 0013 __isctype 0020 __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 11 68 03 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B7 04 41 25 03 01 00 00 C3 }
	condition:
		$1
}

rule file_621_1_0 {
	meta:
		name = "_isupper"
		size = 41
		refs = "0002 ___mb_cur_max 0010 __isctype 001d __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 0E 6A 01 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 01 C3 }
	condition:
		$1
}

rule file_621_2_0 {
	meta:
		name = "_islower"
		size = 41
		refs = "0002 ___mb_cur_max 0010 __isctype 001d __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 0E 6A 02 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 02 C3 }
	condition:
		$1
}

rule file_621_3_0 {
	meta:
		name = "_isdigit"
		size = 41
		refs = "0002 ___mb_cur_max 0010 __isctype 001d __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 0E 6A 04 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 C3 }
	condition:
		$1
}

rule file_621_4_0 {
	meta:
		name = "_isxdigit"
		size = 46
		refs = "0002 ___mb_cur_max 0013 __isctype 0020 __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 11 68 80 00 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B6 04 41 25 80 00 00 00 C3 }
	condition:
		$1
}

rule file_621_5_0 {
	meta:
		name = "_isspace"
		size = 41
		refs = "0002 ___mb_cur_max 0010 __isctype 001d __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 0E 6A 08 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 08 C3 }
	condition:
		$1
}

rule file_621_6_0 {
	meta:
		name = "_ispunct"
		size = 41
		refs = "0002 ___mb_cur_max 0010 __isctype 001d __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 0E 6A 10 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 10 C3 }
	condition:
		$1
}

rule file_621_7_0 {
	meta:
		name = "_isalnum"
		size = 46
		refs = "0002 ___mb_cur_max 0013 __isctype 0020 __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 11 68 07 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B7 04 41 25 07 01 00 00 C3 }
	condition:
		$1
}

rule file_621_8_0 {
	meta:
		name = "_isprint"
		size = 46
		refs = "0002 ___mb_cur_max 0013 __isctype 0020 __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 11 68 57 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B7 04 41 25 57 01 00 00 C3 }
	condition:
		$1
}

rule file_621_9_0 {
	meta:
		name = "_isgraph"
		size = 46
		refs = "0002 ___mb_cur_max 0013 __isctype 0020 __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 11 68 17 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B7 04 41 25 17 01 00 00 C3 }
	condition:
		$1
}

rule file_621_10_0 {
	meta:
		name = "_iscntrl"
		size = 41
		refs = "0002 ___mb_cur_max 0010 __isctype 001d __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 0E 6A 20 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 20 C3 }
	condition:
		$1
}

rule file_621_13_0 {
	meta:
		name = "___iscsymf"
		size = 61
		refs = "0002 ___mb_cur_max 0013 __isctype 001c __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 12 68 03 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 EB 12 A1 ?? ?? ?? ?? 8B 4C 24 04 0F B7 04 48 25 03 01 00 00 85 C0 75 08 83 7C 24 04 5F 74 01 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_621_14_0 {
	meta:
		name = "___iscsym"
		size = 61
		refs = "0002 ___mb_cur_max 0013 __isctype 001c __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 7E 12 68 07 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 EB 12 A1 ?? ?? ?? ?? 8B 4C 24 04 0F B7 04 48 25 07 01 00 00 85 C0 75 08 83 7C 24 04 5F 74 01 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_622_0_0 {
	meta:
		name = "__mbbtype"
		size = 70
		refs = "000e __mbctype 001d __pctype"
	strings:
		$1 = { 8B 44 24 08 48 0F B6 44 24 04 74 29 8A 88 ?? ?? ?? ?? F6 C1 04 74 04 33 C0 40 C3 8B 15 ?? ?? ?? ?? 66 F7 04 42 57 01 75 09 F6 C1 03 75 04 83 C8 FF C3 33 C0 C3 8A 80 ?? ?? ?? ?? 24 08 F6 D8 1B C0 83 E0 03 48 C3 }
	condition:
		$1
}

rule file_624_0_0 {
	meta:
		name = "__mbspbrk"
		size = 121
		refs = "0005 ___ismbcodepage 000d _strpbrk 002c __mbctype"
	strings:
		$1 = { 53 33 DB 39 1D ?? ?? ?? ?? 75 06 5B E9 ?? ?? ?? ?? 8B 4C 24 08 38 19 74 56 56 8B 74 24 10 57 38 1E 8B C6 74 2E 8A 10 0F B6 FA F6 87 ?? ?? ?? ?? 04 74 17 3A 11 75 08 8A 50 01 3A 51 01 74 14 8D 50 01 38 1A 74 0D 8B C2 EB 04 3A 11 74 05 40 38 18 75 D2 38 18 75 16 0F B6 01 F6 80 ?? ?? ?? ?? 04 74 05 41 38 19 74 05 41 38 19 75 B2 5F 5E 8A 01 F6 D8 5B 1B C0 23 C1 C3 }
	condition:
		$1
}

rule file_625_0_0 {
	meta:
		name = "__wcslwr"
		size = 267
		refs = "0003 $T19490 0008 __SEH_prolog 0012 ___lc_handle 004d ___lc_codepage 005f ___crtLCMapStringW 0080 __alloca_probe 009a __resetstkoflw 00b2 _malloc 00ed _wcscpy 00fa _free 0106 __SEH_epilog"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 A1 ?? ?? ?? ?? 3B C3 75 31 8B 45 08 8B C8 66 39 18 0F 84 DA 00 00 00 33 D2 66 8B 11 66 83 FA 41 72 0C 66 83 FA 5A 77 06 83 C2 20 66 89 11 41 41 66 39 19 75 E2 E9 B7 00 00 00 FF 35 ?? ?? ?? ?? 53 53 6A FF FF 75 08 68 00 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 8B F0 89 75 E0 3B F3 0F 84 8C 00 00 00 89 5D FC 8D 04 36 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D DC 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 DB 33 FF 83 4D FC FF 8B 75 E0 3B FB 75 17 8D 04 36 50 E8 ?? ?? ?? ?? 59 8B F8 C7 45 E4 01 00 00 00 3B FB 74 2F FF 35 ?? ?? ?? ?? 56 57 6A FF FF 75 08 68 00 01 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 0B 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 39 5D E4 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 08 8D 65 D0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_626_0_0 {
	meta:
		name = "__CIacos"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 004a ___fastflag 0051 __fast_exit 005c _NAME_ 0061 __math_exit 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2D D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 C9 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 38 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 27 81 E1 00 00 00 80 DD D8 74 04 D9 EB EB C2 D9 EE EB BE E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_627_0_0 {
	meta:
		name = "__wsearchenv"
		size = 309
		refs = "000a ___security_cookie 001a __waccess 0031 __wfullpath 004c __wgetenv 0070 __wgetpath 0094 _wcslen 00d1 _wcscpy 011c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 18 02 00 00 A1 ?? ?? ?? ?? 53 56 33 DB 53 FF 75 08 89 45 FC E8 ?? ?? ?? ?? 85 C0 59 59 75 24 8B 75 10 68 04 01 00 00 FF 75 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 D6 00 00 00 66 89 1E E9 CE 00 00 00 FF 75 0C E8 ?? ?? ?? ?? 3B C3 59 75 0B 8B 45 10 66 89 18 E9 B6 00 00 00 57 BF 04 01 00 00 57 8D 8D EC FD FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 E9 84 00 00 00 66 83 BD EC FD FF FF 00 0F 84 82 00 00 00 8D 85 EC FD FF FF 50 E8 ?? ?? ?? ?? 8B D8 8D B4 5D EC FD FF FF 0F B7 46 FE 83 F8 2F 59 74 12 83 F8 5C 74 0D 83 F8 3A 74 08 66 C7 06 5C 00 46 46 43 FF 75 08 E8 ?? ?? ?? ?? 03 C3 3B C7 59 73 1E FF 75 08 56 E8 ?? ?? ?? ?? 8D 85 EC FD FF FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 38 57 8D 85 EC FD FF FF 50 FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 89 85 E8 FD FF FF 0F 85 70 FF FF FF 8B 45 10 66 83 20 00 5F 8B 4D FC 5E 5B E8 ?? ?? ?? ?? C9 C3 8D 85 EC FD FF FF 50 FF 75 10 E8 ?? ?? ?? ?? 59 59 EB E0 }
	condition:
		$1
}

rule file_630_0_0 {
	meta:
		name = "_pow"
		size = 63
		refs = "0002 ___use_sse2_mathfcns 003b __pow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 87 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 5A E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_630_3_0 {
	meta:
		name = "__CIpow_default"
		size = 527
		refs = "001e __fload_withFB 0032 __load_CW 0072 __twoToTOS 007f ___fastflag 0086 __fast_exit 008c POW_name 0096 __check_range_exit 00b3 __startTwoArgErrorHandling 0136 __powhlp 0194 __infinity 01d9 __indefinite 01f7 __half"
	strings:
		$1 = { 83 EC 14 D9 C9 DD 1C 24 DD 54 24 08 8B 44 24 0C E8 0D 00 00 00 83 C4 14 C3 8D 54 24 0C E8 ?? ?? ?? ?? 8B C8 50 9B D9 3C 24 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 81 E1 00 00 F0 7F 8D 54 24 08 81 F9 00 00 F0 7F 0F 84 9D 00 00 00 E8 ?? ?? ?? ?? 0F 84 8E 00 00 00 A9 00 00 F0 7F 0F 84 F6 00 00 00 8A 4C 24 0F 80 E1 80 0F 85 53 01 00 00 D9 F1 E8 ?? ?? ?? ?? 80 F9 01 75 02 D9 E0 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1D 00 00 00 E9 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1D 00 00 00 E8 ?? ?? ?? ?? 5A C3 8D 54 24 08 E8 ?? ?? ?? ?? F6 44 24 16 08 75 03 41 EB 33 DE C1 B8 01 00 00 00 EB C5 F6 44 24 0E 08 75 F0 DE C1 B8 07 00 00 00 EB B5 33 C9 EB 16 33 C9 25 FF FF 0F 00 0B 44 24 10 75 C3 8D 54 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 8B D0 25 00 00 F0 7F 81 E2 FF FF 0F 00 3D 00 00 F0 7F 75 06 0B 54 24 08 75 B8 85 C9 75 BB 83 EC 74 8B CC 51 83 EC 10 DD 1C 24 DD 5C 24 08 9B DD 71 08 E8 ?? ?? ?? ?? 83 C4 10 59 DD 61 08 DD 01 83 C4 74 85 C0 0F 84 ?? ?? ?? ?? B8 01 00 00 00 E9 42 FF FF FF 8B 44 24 0C 25 FF FF 0F 00 0B 44 24 08 0F 85 F7 FE FF FF DD D8 8B 44 24 14 25 FF FF FF 7F 0B 44 24 10 74 3D E8 66 00 00 00 8A 6C 24 0F C0 ED 07 F7 44 24 17 80 00 00 00 74 16 DB 2D ?? ?? ?? ?? 84 CD 74 02 D9 E0 B8 02 00 00 00 E9 F2 FE FF FF D9 EE 84 CD 0F 84 ?? ?? ?? ?? D9 E0 E9 ?? ?? ?? ?? DD D8 D9 E8 E9 ?? ?? ?? ?? D9 C1 E8 1E 00 00 00 D9 E0 84 C9 0F 85 9C FE FF FF DD D8 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 E9 B3 FE FF FF D9 C0 D9 FC D8 D9 B1 00 9B DF E0 9E 75 17 DC 0D ?? ?? ?? ?? FE C1 D9 C0 D9 FC DE D9 9B DF E0 9E 75 02 FE C1 C3 DD D8 C3 }
	condition:
		$1
}

rule file_631_0_0 {
	meta:
		name = "__mbsnbcnt"
		size = 50
		refs = "0018 __mbctype"
	strings:
		$1 = { 55 8B EC 8B 45 08 33 D2 EB 1B 8A 08 FF 4D 0C 3A CA 74 1A 0F B6 C9 F6 81 ?? ?? ?? ?? 04 74 05 40 38 10 74 08 40 39 55 0C 75 E0 EB 01 48 2B 45 08 5D C3 }
	condition:
		$1
}

rule file_632_0_0 {
	meta:
		name = "__allrem"
		size = 178
	strings:
		$1 = { 53 57 33 FF 8B 44 24 10 0B C0 7D 14 47 8B 54 24 0C F7 D8 F7 DA 83 D8 00 89 44 24 10 89 54 24 0C 8B 44 24 18 0B C0 7D 13 8B 54 24 14 F7 D8 F7 DA 83 D8 00 89 44 24 18 89 54 24 14 0B C0 75 1B 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B 44 24 0C F7 F1 8B C2 33 D2 4F 79 4E EB 53 8B D8 8B 4C 24 14 8B 54 24 10 8B 44 24 0C D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B C8 F7 64 24 18 91 F7 64 24 14 03 D1 72 0E 3B 54 24 10 77 08 72 0E 3B 44 24 0C 76 08 2B 44 24 14 1B 54 24 18 2B 44 24 0C 1B 54 24 10 4F 79 07 F7 DA F7 D8 83 DA 00 5F 5B C2 10 00 }
	condition:
		$1
}

rule file_633_0_0 {
	meta:
		name = "_atof"
		size = 75
		refs = "0007 ___mb_cur_max 0015 __isctype 001f __pctype 0037 _strlen 003f __fltin"
	strings:
		$1 = { 56 8B 74 24 08 83 3D ?? ?? ?? ?? 01 0F B6 06 7E 0C 6A 08 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 08 85 C0 74 03 46 EB D4 6A 00 6A 00 56 E8 ?? ?? ?? ?? 59 50 56 E8 ?? ?? ?? ?? DD 40 10 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_636_0_0 {
	meta:
		name = "___wrt2err"
		size = 34
		refs = "0013 ___pioinfo 001c __imp__WriteFile@20"
	strings:
		$1 = { 55 8B EC 6A 00 8D 45 08 50 8B 45 08 0F BE 08 51 40 50 A1 ?? ?? ?? ?? FF 70 10 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_637_0_0 {
	meta:
		name = "__makepath"
		size = 144
		refs = "003c __mbsdec"
	strings:
		$1 = { 55 8B EC 8B 45 0C 85 C0 56 74 12 8A 00 84 C0 74 0C 8B 75 08 88 06 46 C6 06 3A 46 EB 03 8B 75 08 8B 55 10 85 D2 8B CA 74 27 8A 02 84 C0 74 21 88 06 46 41 8A 01 84 C0 75 F6 51 52 E8 ?? ?? ?? ?? 8A 00 3C 2F 59 59 74 08 3C 5C 74 04 C6 06 5C 46 8B 45 14 85 C0 8B C8 74 0E 8A 00 EB 06 88 06 46 41 8A 01 84 C0 75 F6 8B 45 18 85 C0 8B C8 74 1A 8A 00 84 C0 74 08 3C 2E 74 04 C6 06 2E 46 8A 01 88 06 46 41 84 C0 75 F6 EB 03 C6 06 00 5E 5D C3 }
	condition:
		$1
}

rule file_639_0_0 {
	meta:
		name = "_calloc"
		size = 123
		refs = "001c ___active_heap 002b ___sbh_threshold 0033 ___sbh_alloc_block 0043 __crtheap 0049 __imp__HeapAlloc@12 0055 __newmode 005e __callnewh 006e _memset"
	strings:
		$1 = { 53 56 8B 74 24 0C 0F AF 74 24 10 85 F6 57 8B DE 75 01 46 33 FF 83 FE E0 77 39 83 3D ?? ?? ?? ?? 03 75 1B 83 C6 0F 83 E6 F0 3B 1D ?? ?? ?? ?? 77 0D 53 E8 ?? ?? ?? ?? 8B F8 85 FF 59 75 2B 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 22 83 3D ?? ?? ?? ?? 00 74 19 56 E8 ?? ?? ?? ?? 85 C0 59 75 AC EB 0E 53 6A 00 57 E8 ?? ?? ?? ?? 83 C4 0C 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule file_641_0_0 {
	meta:
		name = "__getdrive"
		size = 229
		refs = "0006 $T19926 000b __SEH_prolog 0010 ___security_cookie 002e __imp__GetCurrentDirectoryA@8 0050 __alloca_probe 0069 __resetstkoflw 0078 _malloc 00b5 _toupper 00ca _free 00db @__security_check_cookie@4 00e0 __SEH_epilog"
	strings:
		$1 = { 68 20 01 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 8D BD DC FE FF FF 83 A5 D8 FE FF FF 00 8B C7 50 68 05 01 00 00 FF 15 ?? ?? ?? ?? 8B F0 89 B5 D4 FE FF FF 81 FE 04 01 00 00 7E 62 83 65 FC 00 8D 46 01 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 BD D0 FE FF FF EB 30 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 8B B5 D4 FE FF FF 8D 46 01 50 E8 ?? ?? ?? ?? 59 8B F8 85 FF 75 04 33 F6 EB 0A C7 85 D8 FE FF FF 01 00 00 00 83 4D FC FF 85 F6 74 0B 57 46 56 FF 15 ?? ?? ?? ?? 8B F0 33 DB 85 F6 74 15 80 7F 01 3A 75 0F 0F B6 07 50 E8 ?? ?? ?? ?? 59 8B D8 83 EB 40 83 BD D8 FE FF FF 00 74 07 57 E8 ?? ?? ?? ?? 59 8B C3 8D A5 C4 FE FF FF 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_641_1_0 {
	meta:
		name = "__chdrive"
		size = 87
		refs = "0023 __imp__SetCurrentDirectoryA@4 0031 __imp__GetLastError@0 0037 __dosmaperr 0040 _errno 004a __doserrno"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 F8 01 7C 33 83 F8 1F 7F 2E 04 40 88 45 08 8D 45 08 50 C6 45 09 3A C6 45 0A 00 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 5D C3 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB 14 C7 05 ?? ?? ?? ?? 0D 00 00 00 C7 05 ?? ?? ?? ?? 0F 00 00 00 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_643_1_0 {
	meta:
		name = "_rand"
		size = 35
		refs = "0001 _holdrand"
	strings:
		$1 = { A1 ?? ?? ?? ?? 69 C0 FD 43 03 00 05 C3 9E 26 00 A3 ?? ?? ?? ?? 33 C0 66 A1 ?? ?? ?? ?? 25 FF 7F 00 00 C3 }
	condition:
		$1
}

rule file_644_2_0 {
	meta:
		name = "_wfind"
		size = 138
		refs = "0009 ?findbuf@?1??wfind@@9@9 0016 _malloc 0025 ?_WildFindHandle@?1??wfind@@9@9 0030 __imp__FindClose@4 0047 __imp__FindFirstFileW@8 006c __imp__FindNextFileW@8"
	strings:
		$1 = { 83 7C 24 04 00 74 57 83 3D ?? ?? ?? ?? 00 75 14 68 54 03 00 00 E8 ?? ?? ?? ?? 85 C0 59 A3 ?? ?? ?? ?? 74 63 A1 ?? ?? ?? ?? 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 FF 35 ?? ?? ?? ?? FF 74 24 08 FF 15 ?? ?? ?? ?? 83 F8 FF A3 ?? ?? ?? ?? 74 32 A1 ?? ?? ?? ?? 83 C0 2C C3 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 E1 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 33 C0 C3 }
	condition:
		$1
}

rule file_644_3_0 {
	meta:
		name = "_wmatch"
		size = 396
		refs = "0041 _wadd 006a _wfind 007a _argend 0082 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 0088 _wcscmp 0097 ??_C@_15DDHGOCBH@?$AA?4?$AA?4?$AA?$AA@ 00be __wcsdup 00df _wcslen 00eb _malloc 00ff _wcsncpy 010a _wcscpy 0148 _arghead 0157 __wcsicmp"
	strings:
		$1 = { 55 8B EC 51 51 8B 4D 08 56 8B 75 0C 57 33 FF 89 7D FC EB 1A 66 8B 06 66 3D 5C 00 74 15 66 3D 2F 00 74 0F 66 3D 3A 00 74 0F 4E 4E 89 75 0C 3B F1 75 E2 66 83 3E 3A 75 13 8D 41 02 3B F0 74 0C 51 E8 ?? ?? ?? ?? 59 E9 3D 01 00 00 66 8B 06 66 3D 5C 00 74 0C 66 3D 2F 00 74 06 66 3D 3A 00 75 07 8B FE 2B F9 D1 FF 47 53 51 E8 ?? ?? ?? ?? 8B D8 85 DB 59 0F 84 05 01 00 00 A1 ?? ?? ?? ?? 89 45 F8 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 8D 00 00 00 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 85 C0 59 59 74 7C 66 8B 06 66 3D 5C 00 74 2D 66 3D 3A 00 74 27 66 3D 2F 00 74 21 53 E8 ?? ?? ?? ?? 85 C0 59 89 45 08 74 0B 50 E8 ?? ?? ?? ?? 85 C0 59 74 4B 83 C8 FF E9 AA 00 00 00 53 E8 ?? ?? ?? ?? 03 C7 8D 44 00 02 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 E0 53 57 FF 75 08 8D 34 3F 50 E8 ?? ?? ?? ?? 03 C6 83 C4 0C 50 E8 ?? ?? ?? ?? 2B C6 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 B8 8B 75 0C FF 45 FC 6A 00 E8 ?? ?? ?? ?? 8B D8 85 DB 59 0F 85 4C FF FF FF 39 45 FC 74 44 8B 45 F8 85 C0 74 05 8B 70 04 EB 06 8B 35 ?? ?? ?? ?? 85 F6 74 2A EB 21 FF 36 FF 37 E8 ?? ?? ?? ?? 85 C0 59 59 7D 08 8B 0F 8B 06 89 0E 89 07 8B 7F 04 85 FF 75 E2 8B 76 04 8B 7E 04 85 FF 75 D8 33 C0 EB 09 FF 75 08 E8 ?? ?? ?? ?? 59 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_644_4_0 {
	meta:
		name = "__wcwild"
		size = 204
		refs = "0003 ___wargv 000c _argend 0012 _arghead 002c ??_C@_15EAECJAPL@?$AA?$CK?$AA?$DP?$AA?$AA@ 0032 _wcspbrk 0040 _wmatch 004a _wadd 0074 _malloc 0091 ___argc 00b6 _free"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 3E 8B 06 66 8B 08 83 C0 02 66 83 F9 22 89 06 75 03 50 EB 1E 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 3B C7 59 59 74 0B 50 FF 36 E8 ?? ?? ?? ?? 59 EB 07 FF 36 E8 ?? ?? ?? ?? 85 C0 59 75 2A 83 C6 04 39 3E 75 BE A1 ?? ?? ?? ?? 33 F6 EB 04 8B 40 04 46 3B C7 75 F8 8D 04 B5 04 00 00 00 50 E8 ?? ?? ?? ?? 3B C7 59 75 05 83 C8 FF EB 47 8B 0D ?? ?? ?? ?? 3B CF A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 8B D1 74 0E 8B 32 89 30 8B 52 04 83 C0 04 3B D7 75 F2 89 38 EB 16 8B 49 04 50 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 0D ?? ?? ?? ?? 3B CF 8B C1 75 E4 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_645_0_0 {
	meta:
		name = "_wcstod"
		size = 367
		refs = "0003 $T1758 0008 __SEH_prolog 0023 _iswctype 004b _wcslen 005b __alloca_probe 0076 __resetstkoflw 0089 _malloc 0098 _errno 00a7 __real@0000000000000000 00d6 _wctomb 00fe __fltin 0111 _free 0142 __HUGE 016a __SEH_epilog"
	strings:
		$1 = { 6A 1C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 89 5D DC 33 FF 89 7D D8 89 7D D4 6A 08 33 C0 66 8B 03 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 18 43 43 6A 08 33 C0 66 8B 03 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EB 89 5D DC 9B 89 7D FC 53 E8 ?? ?? ?? ?? 59 8D 44 00 02 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 E4 9B 83 4D FC FF EB 50 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 8B 5D DC 53 E8 ?? ?? ?? ?? 8D 44 00 02 50 E8 ?? ?? ?? ?? 59 59 89 45 E4 85 C0 75 1A C7 05 ?? ?? ?? ?? 0C 00 00 00 9B 83 4D FC FF DD 05 ?? ?? ?? ?? E9 B6 00 00 00 C7 45 D8 01 00 00 00 83 4D FC FF 8B 7D D4 66 83 3B 00 74 2B 8B C3 8B 4D E4 89 4D E0 8B F3 0F B7 00 50 FF 75 E0 E8 ?? ?? ?? ?? 59 59 85 C0 7E 0F 03 F8 FF 45 E0 46 46 8B C6 66 83 3E 00 75 DF 8B 45 E4 C6 04 38 00 6A 00 6A 00 47 57 50 E8 ?? ?? ?? ?? 83 C4 10 8B F0 83 7D D8 00 74 09 FF 75 E4 E8 ?? ?? ?? ?? 59 8B 45 0C 85 C0 74 08 8B 4E 04 8D 0C 4B 89 08 8B 0E 66 F7 C1 40 02 74 0D D9 EE 85 C0 74 32 8B 4D 08 89 08 EB 2B F6 C1 81 74 10 DD 05 ?? ?? ?? ?? 66 83 3B 2D 75 0B D9 E0 EB 07 F6 C5 01 74 0E D9 EE C7 05 ?? ?? ?? ?? 22 00 00 00 EB 03 DD 46 10 8D 65 C8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_646_0_0 {
	meta:
		name = "__strdup"
		size = 43
		refs = "000b _strlen 0012 _malloc 001f _strcpy"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 1E 56 E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 0B 56 50 E8 ?? ?? ?? ?? 59 59 5E C3 33 C0 5E C3 }
	condition:
		$1
}

rule file_647_0_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 77
		refs = "0003 $T18737 0008 __SEH_prolog 0032 __imp__RaiseException@16 0048 __SEH_epilog"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 88 45 E7 C7 45 CC 01 10 00 00 89 4D D0 8D 4D E7 89 4D D4 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 07 83 C8 FF C3 8B 65 E8 83 4D FC FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_647_1_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 95
		refs = "0003 $T18754 0008 __SEH_prolog 0044 __imp__RaiseException@16 005a __SEH_epilog"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 88 45 E7 C7 45 CC 02 10 00 00 89 4D D0 8B 4D 08 89 4D D4 8B 4D 0C 89 4D D8 8D 4D E7 89 4D DC 8B 4D 10 89 4D E0 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 07 83 C8 FF C3 8B 65 E8 83 4D FC FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_647_2_0 {
	meta:
		name = "?IntToString@@YAPADH@Z"
		size = 58
		refs = "000c ?buf@?1??IntToString@@YAPADH@Z@4PADA"
	strings:
		$1 = { 53 56 85 C0 6A 0E 0F 9C C3 59 C6 05 ?? ?? ?? ?? 00 6A 0A 99 5E F7 FE 49 80 C2 30 85 C0 88 91 ?? ?? ?? ?? 75 EC 5E 84 DB 5B 74 08 49 C6 81 ?? ?? ?? ?? 2D 8D 81 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_647_5_0 {
	meta:
		name = "?Win95IsDebuggerPresent@@YGHXZ"
		size = 17
	strings:
		$1 = { 64 A1 18 00 00 00 33 C9 39 48 20 0F 95 C1 8B C1 C3 }
	condition:
		$1
}

rule file_647_6_0 {
	meta:
		name = "?Initialize@@YAHXZ"
		size = 104
		refs = "0005 ??_C@_0N@HAOHNMDE@Kernel32?4dll?$AA@ 000b __imp__LoadLibraryA@4 0010 ??_C@_0BC@KNBMEBEO@IsDebuggerPresent?$AA@ 0017 __imp__GetProcAddress@8 001e _FnIsDebuggerPresent 002a __alloca_probe 0039 __imp__GetVersionExA@4 0053 ?Win95IsDebuggerPresent@@YGHXZ"
	strings:
		$1 = { 55 8B EC 56 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 75 33 B8 94 00 00 00 E8 ?? ?? ?? ?? 8B F4 56 C7 06 94 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 16 83 7E 10 01 75 10 83 7E 04 04 75 0A C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 33 C0 39 05 ?? ?? ?? ?? 0F 95 C0 8D 65 FC 5E 5D C3 }
	condition:
		$1
}

rule file_647_7_0 {
	meta:
		name = "?_IsDebuggerPresent@@YAHXZ"
		size = 48
		refs = "0002 ?fInited@?1??_IsDebuggerPresent@@YAHXZ@4HA 000a ?Initialize@@YAHXZ 001c __imp__RaiseException@16 002c _FnIsDebuggerPresent"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 21 E8 ?? ?? ?? ?? 85 C0 75 0E 50 50 50 68 35 01 00 C0 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_647_8_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 269
		refs = "000c ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 001a ?DebuggerProbe@@YAHK@Z 003d __alloca_probe 0069 __RTC_NoFalsePositives 006e ?DebuggerRuntime@@YAHKHPAXPB_W@Z 008e ?fInited@?1??_IsDebuggerPresent@@YAHXZ@4HA 0095 ?Initialize@@YAHXZ 00a7 __imp__RaiseException@16 00b7 _FnIsDebuggerPresent 00de ?_RTC_GetSrcLine@@YAHKPADHPAHPAPAD@Z 00e7 ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 0102 __imp__DebugBreak@0"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 57 8B F8 57 E8 ?? ?? ?? ?? 59 B9 02 10 00 00 89 45 FC E8 ?? ?? ?? ?? 33 DB 85 C0 74 5D 8B C6 8D 48 01 8A 10 40 3A D3 75 F9 2B C1 8D 44 00 04 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 8A 16 33 C0 3A D3 8B CC 74 12 33 DB 66 0F BE D2 66 89 14 41 40 8A 14 30 3A D3 75 F0 51 66 89 1C 41 8B 4D 0C 57 FF 34 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 89 00 00 00 32 C0 EB 02 B0 01 39 5D FC 74 78 3A C3 74 33 39 1D ?? ?? ?? ?? 75 21 E8 ?? ?? ?? ?? 85 C0 75 0E 53 53 53 68 35 01 00 C0 FF 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 41 B8 04 02 00 00 E8 ?? ?? ?? ?? 8B DC 8D 45 F8 50 8D 45 F4 50 68 00 02 00 00 53 83 C7 FB 57 E8 ?? ?? ?? ?? 56 FF 75 0C 68 ?? ?? ?? ?? FF 75 F8 FF 75 F4 53 FF 75 08 FF 55 FC 83 C4 30 83 F8 01 75 06 FF 15 ?? ?? ?? ?? 8D 65 EC 5F 5B C9 C3 }
	condition:
		$1
}

rule file_647_9_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 62
		refs = "0011 ?_RTC_ErrorLevels@@3PAHA 0018 __RTC_ErrorMessages 0036 ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 8B 44 24 08 83 F8 04 56 7D 14 85 C0 7C 10 8B 0C 85 ?? ?? ?? ?? 8B 34 85 ?? ?? ?? ?? EB 0C 8B 35 ?? ?? ?? ?? 33 C9 6A 04 41 58 83 F9 FF 74 0D 50 8B 44 24 0C 51 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_647_10_0 {
	meta:
		name = "?_RTC_MemFailure@@YAXPAXHPBX@Z"
		size = 404
		refs = "000f __alloca_probe 001d ?_RTC_ErrorLevels@@3PAHA 0048 ?_RTC_GetSrcLine@@YAHKPADHPAHPAPAD@Z 005a ?_RTC_Failure@@YAXPAXH@Z 0065 __RTC_ErrorMessages 00d1 ??_C@_0CI@INCLAPNB@Invalid?5pointer?5was?5assigned?5at?6@ 0107 ??_C@_08GJEJCAJD@?6?$ANLine?3?7?$AA@ 0112 ?IntToString@@YAPADH@Z 0148 ??_C@_0L@CJCNHJJG@?6?$ANModule?3?7?$AA@ 0186 ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 B8 04 02 00 00 E8 ?? ?? ?? ?? 8B 75 0C 8B FE C1 E7 02 8B 87 ?? ?? ?? ?? 83 F8 FF 89 65 FC 89 45 EC 0F 84 5C 01 00 00 8D 45 F4 50 8D 45 F8 50 8B 45 10 68 00 02 00 00 FF 75 FC 83 C0 FB 50 E8 ?? ?? ?? ?? 83 C4 14 83 7D F8 00 75 0E 56 FF 75 08 E8 ?? ?? ?? ?? E9 27 01 00 00 8B 87 ?? ?? ?? ?? 89 45 F0 8D 48 01 8A 10 40 84 D2 75 F9 2B C1 8B F0 8B 45 FC 8D 48 01 8A 10 40 84 D2 75 F9 2B C1 8B C8 8B 45 F4 8D 78 01 8A 10 40 84 D2 75 F9 2B C7 03 C1 8D 84 30 96 00 00 00 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 8B 4D F0 8B DC 8B D3 8A 01 41 88 02 42 84 C0 75 F6 8B FB 4F 8A 47 01 47 84 C0 75 F8 8B 45 FC 6A 0A 59 BE ?? ?? ?? ?? F3 A5 8B F0 8A 08 40 84 C9 75 F9 8B FB 2B C6 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 8B FB 4F 8A 47 01 47 84 C0 75 F8 BE ?? ?? ?? ?? A5 A5 A4 8B 45 F8 E8 ?? ?? ?? ?? 8B D0 8A 08 40 84 C9 75 F9 8B FB 2B C2 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 8B F2 F3 A5 8B C8 83 E1 03 F3 A4 8B FB 4F 8A 47 01 47 84 C0 75 F8 BE ?? ?? ?? ?? A5 A5 66 A5 A4 8B 45 F4 8B D0 8A 08 40 84 C9 75 F9 8B FB 2B C2 4F 8A 4F 01 47 84 C9 75 F8 FF 75 0C 8B C8 FF 75 EC C1 E9 02 8B F2 F3 A5 8B C8 8B 45 08 83 E1 03 F3 A4 8B F3 E8 ?? ?? ?? ?? 59 59 8D 65 E0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_647_11_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 140
		refs = "0006 ?_RTC_ErrorLevels@@3PAHA 0027 __alloca_probe 0034 ??_C@_0BM@FGFAMDLF@Stack?5around?5the?5variable?5?8?$AA@ 006f ??_C@_0BB@JEGFEAAM@?8?5was?5corrupted?4?$AA@ 007e ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 55 8B EC 53 8B 1D ?? ?? ?? ?? 83 FB FF 56 57 74 73 8B 45 0C 8D 48 01 8A 10 40 84 D2 75 F9 2B C1 83 C0 53 83 E0 FC E8 ?? ?? ?? ?? 8B 45 0C 8B D4 6A 07 59 BE ?? ?? ?? ?? 8B FA F3 A5 8B F0 8A 08 40 84 C9 75 F9 8B FA 2B C6 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 8B FA 4F 8A 47 01 47 84 C0 75 F8 8B 45 08 BE ?? ?? ?? ?? A5 A5 A5 A5 A4 6A 02 53 8B F2 E8 ?? ?? ?? ?? 59 59 8D 65 F4 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_647_12_0 {
	meta:
		name = "__RTC_UninitUse"
		size = 166
		refs = "0006 ?_RTC_ErrorLevels@@3PAHA 002b __alloca_probe 003d ??_C@_0P@HLKMHJCG@The?5variable?5?8?$AA@ 007a ??_C@_0CH@LOIIHGKM@?8?5is?5being?5used?5without?5being?5de@ 0089 ??_C@_0DA@BEGFPCGG@A?5variable?5is?5being?5used?5without@ 0098 ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 55 8B EC 53 8B 1D ?? ?? ?? ?? 83 FB FF 56 57 0F 84 89 00 00 00 8B 45 08 8D 50 01 8A 08 40 84 C9 75 F9 2B C2 83 C0 53 83 E0 FC E8 ?? ?? ?? ?? 83 7D 08 00 8B D4 8B FA 74 4C 8B 45 08 BE ?? ?? ?? ?? A5 A5 A5 66 A5 A4 8B F0 8A 08 40 84 C9 75 F9 8B FA 2B C6 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 8B FA 4F 8A 47 01 47 84 C0 75 F8 6A 09 59 BE ?? ?? ?? ?? F3 A5 66 A5 A4 EB 0A 6A 0C 59 BE ?? ?? ?? ?? F3 A5 8B 45 04 6A 03 53 8B F2 E8 ?? ?? ?? ?? 59 59 8D 65 F4 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_648_1_0 {
	meta:
		name = "___crtCompareStringA"
		size = 900
		refs = "0003 $T20196 0008 __SEH_prolog 000d ___security_cookie 001b ?f_use@?1??__crtCompareStringA@@9@9 0023 ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 002e __imp__CompareStringW@24 0040 __imp__GetLastError@0 005f _strncnt 00ac ___lc_codepage 00ea __imp__GetCPInfo@8 0178 __imp__MultiByteToWideChar@24 0196 __alloca_probe 01b0 __resetstkoflw 01d0 _malloc 02a9 _free 02ce ___lc_handle 02e6 ___ansicp 0308 ___convertcp 0357 __imp__CompareStringA@24 037a @__security_check_cookie@4 037f __SEH_epilog"
	strings:
		$1 = { 6A 40 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 33 FF 33 F6 46 39 3D ?? ?? ?? ?? 75 32 56 B8 ?? ?? ?? ?? 50 56 50 57 57 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 35 ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 39 7D 14 7E 0F FF 75 14 8B 45 10 E8 ?? ?? ?? ?? 59 89 45 14 8B 45 1C 3B C7 7E 0D 50 8B 45 18 E8 ?? ?? ?? ?? 59 89 45 1C 8B 0D ?? ?? ?? ?? 6A 02 5B 3B CB 0F 84 39 02 00 00 3B CF 0F 84 31 02 00 00 3B CE 0F 85 56 02 00 00 89 7D C4 89 7D BC 89 7D C0 39 7D 20 75 09 8B 0D ?? ?? ?? ?? 89 4D 20 39 7D 14 74 08 3B C7 0F 85 A9 00 00 00 39 45 14 75 07 8B C3 E9 A7 02 00 00 3B C6 0F 8F 9D 02 00 00 39 75 14 7E 08 6A 03 58 E9 92 02 00 00 8D 45 D0 50 FF 75 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 FC 01 00 00 39 7D 14 7E 2B 39 5D D0 72 D9 8D 45 D6 80 7D D6 00 74 D0 8A 50 01 84 D2 74 C9 8B 4D 10 8A 09 3A 08 72 04 3A CA 76 A8 03 C3 80 38 00 75 E5 EB B3 39 7D 1C 7E 3E 39 5D D0 0F 82 3D 02 00 00 8D 45 D6 80 7D D6 00 0F 84 30 02 00 00 8A 50 01 84 D2 0F 84 25 02 00 00 8B 4D 18 8A 09 3A 08 72 08 3A CA 0F 86 68 FF FF FF 03 C3 80 38 00 75 DD E9 08 02 00 00 57 57 FF 75 14 FF 75 10 6A 09 FF 75 20 FF 15 ?? ?? ?? ?? 8B D8 89 5D B8 3B DF 0F 84 69 01 00 00 89 7D FC 8D 04 1B 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 CC 83 4D FC FF EB 1C 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 83 65 CC 00 83 4D FC FF 8B 5D B8 33 F6 46 33 FF 8B 45 CC 3B C7 75 18 8D 04 1B 50 E8 ?? ?? ?? ?? 59 89 45 CC 3B C7 0F 84 12 01 00 00 89 75 C4 53 50 FF 75 14 FF 75 10 56 FF 75 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B1 00 00 00 6A 00 6A 00 FF 75 1C FF 75 18 6A 09 FF 75 20 FF 15 ?? ?? ?? ?? 8B F0 89 75 B4 85 F6 0F 84 8F 00 00 00 C7 45 FC 01 00 00 00 8D 04 36 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D B0 83 4D FC FF EB 18 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 FF 83 4D FC FF 8B 5D B8 8B 75 B4 85 FF 75 17 8D 04 36 50 E8 ?? ?? ?? ?? 59 8B F8 85 FF 74 40 C7 45 BC 01 00 00 00 56 57 FF 75 1C FF 75 18 6A 01 FF 75 20 FF 15 ?? ?? ?? ?? 85 C0 74 15 56 57 53 FF 75 CC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 89 45 C0 83 7D BC 00 74 07 57 E8 ?? ?? ?? ?? 59 83 7D C4 00 74 09 FF 75 CC E8 ?? ?? ?? ?? 59 8B 45 C0 E9 AE 00 00 00 89 7D C8 39 7D 08 75 08 A1 ?? ?? ?? ?? 89 45 08 8B 5D 20 3B DF 75 06 8B 1D ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 8B F0 83 FE FF 75 04 33 C0 EB 7D 3B F3 74 49 6A 00 6A 00 8D 45 14 50 FF 75 10 56 53 E8 ?? ?? ?? ?? 83 C4 18 8B F8 85 FF 74 DD 6A 00 6A 00 8D 45 1C 50 FF 75 18 56 53 E8 ?? ?? ?? ?? 83 C4 18 89 45 C8 85 C0 75 09 57 E8 ?? ?? ?? ?? 59 EB B8 89 7D 10 8B 45 C8 89 45 18 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 8B F0 85 FF 74 10 57 E8 ?? ?? ?? ?? FF 75 C8 E8 ?? ?? ?? ?? 59 59 8B C6 8D 65 A4 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_649_0_0 {
	meta:
		name = "__floor_default"
		size = 211
		refs = "000f _newcw 0014 __ctrlfp 0032 __sptype 0052 __handle_qnan1 006f __real@3ff0000000000000 0087 __frnd 00c8 __except1"
	strings:
		$1 = { 55 8B EC 51 51 53 56 BE FF FF 00 00 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 45 08 59 59 8B D8 8B 45 0E 51 66 25 F0 7F 66 3D F0 7F 51 DD 1C 24 75 55 E8 ?? ?? ?? ?? 85 C0 59 59 7E 2D 83 F8 02 7E 1A 83 F8 03 75 23 DD 45 08 53 51 51 DD 1C 24 6A 0B E8 ?? ?? ?? ?? 83 C4 10 EB 74 56 53 E8 ?? ?? ?? ?? DD 45 08 59 59 EB 66 DD 45 08 53 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0B 6A 08 EB 41 E8 ?? ?? ?? ?? DD 5D F8 DD 45 08 59 DD 45 F8 59 DA E9 DF E0 F6 C4 44 7A 0E 56 53 E8 ?? ?? ?? ?? DD 45 F8 59 59 EB 22 F6 C3 20 75 ED DD 45 F8 53 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0B 6A 10 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_651_0_0 {
	meta:
		name = "__allmul"
		size = 52
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 10 0B C8 8B 4C 24 0C 75 09 8B 44 24 04 F7 E1 C2 10 00 53 F7 E1 8B D8 8B 44 24 08 F7 64 24 14 03 D8 8B 44 24 08 F7 E1 03 D3 5B C2 10 00 }
	condition:
		$1
}

rule file_653_0_0 {
	meta:
		name = "__ismbstrail"
		size = 59
		refs = "0002 ___ismbcodepage 001a __mbctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 2B 8B 44 24 04 EB 1F 8A 08 84 C9 74 1F 0F B6 C9 F6 81 ?? ?? ?? ?? 04 74 0C 40 3B 44 24 08 74 0F 80 38 00 74 07 40 3B 44 24 08 76 DB 33 C0 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_654_0_0 {
	meta:
		name = "___crtGetLocaleInfoA"
		size = 320
		refs = "0003 $T20076 0008 __SEH_prolog 0010 ?f_use@?1??__crtGetLocaleInfoA@@9@9 001f __imp__GetLocaleInfoW@16 0031 __imp__GetLastError@0 006b ___lc_codepage 009d __alloca_probe 00b7 __resetstkoflw 00cf _malloc 010d __imp__WideCharToMultiByte@32 011b _free 0133 __imp__GetLocaleInfoA@16 013b __SEH_epilog"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 35 ?? ?? ?? ?? 75 2E 56 56 33 FF 47 57 56 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 3D ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 A1 ?? ?? ?? ?? 83 F8 02 0F 84 D3 00 00 00 3B C6 0F 84 CB 00 00 00 83 F8 01 75 2A 89 75 E4 89 75 E0 39 75 18 75 08 A1 ?? ?? ?? ?? 89 45 18 56 56 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 8B D8 89 5D DC 3B DE 75 07 33 C0 E9 A7 00 00 00 89 75 FC 8D 04 1B 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D D8 83 4D FC FF EB 17 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 F6 33 FF 83 4D FC FF 8B 5D DC 3B FE 75 17 8D 04 1B 50 E8 ?? ?? ?? ?? 59 8B F8 3B FE 74 AF C7 45 E0 01 00 00 00 53 57 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 21 56 56 39 75 14 75 04 56 56 EB 06 FF 75 14 FF 75 10 6A FF 57 56 FF 75 18 FF 15 ?? ?? ?? ?? 89 45 E4 39 75 E0 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 E4 EB 12 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 8D 65 CC E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_655_0_0 {
	meta:
		name = "___crtGetStringTypeW"
		size = 549
		refs = "0003 $T20132 0008 __SEH_prolog 0013 ?f_use@?1??__crtGetStringTypeW@@9@9 001f ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0026 __imp__GetStringTypeW@16 0038 __imp__GetLastError@0 0080 ___lc_handle 008d ___lc_codepage 0098 ___ansicp 00ba __imp__WideCharToMultiByte@32 00da __alloca_probe 00ea _memset 00ff __resetstkoflw 011b _calloc 0190 _malloc 01cf __imp__GetStringTypeA@20 01ed _memmove 0204 _free 0220 __SEH_epilog"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 33 FF 47 39 35 ?? ?? ?? ?? 75 32 8D 45 E4 50 57 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 3D ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 A1 ?? ?? ?? ?? 3B C7 75 17 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? E9 B1 01 00 00 83 F8 02 74 04 3B C6 75 53 89 75 D0 89 75 D4 39 75 1C 75 08 A1 ?? ?? ?? ?? 89 45 1C 39 75 18 75 08 A1 ?? ?? ?? ?? 89 45 18 FF 75 1C E8 ?? ?? ?? ?? 59 39 45 18 74 08 83 F8 FF 74 03 89 45 18 56 56 56 56 FF 75 10 FF 75 0C 56 FF 75 18 FF 15 ?? ?? ?? ?? 8B D8 89 5D D8 3B DE 75 07 33 C0 E9 4E 01 00 00 89 75 FC 8B C3 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 DC 53 56 50 E8 ?? ?? ?? ?? 83 C4 0C 83 4D FC FF EB 1C 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 83 65 DC 00 83 4D FC FF 33 FF 47 8B 5D D8 33 F6 39 75 DC 75 13 53 57 E8 ?? ?? ?? ?? 59 59 89 45 DC 3B C6 74 9F 89 7D D0 56 56 53 FF 75 DC FF 75 10 FF 75 0C 56 FF 75 18 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C2 00 00 00 89 7D FC 8D 44 1B 02 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B C4 89 45 E0 83 4D FC FF EB 1C 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 83 65 E0 00 83 4D FC FF 33 FF 47 8B 5D D8 33 F6 39 75 E0 75 15 8D 44 1B 02 50 E8 ?? ?? ?? ?? 59 89 45 E0 3B C6 74 6F 89 7D D4 39 75 1C 75 08 A1 ?? ?? ?? ?? 89 45 1C 8B 7D 10 03 FF 8B 45 E0 8D 34 07 66 81 0E FF FF 66 81 4E FE FF FF 50 53 FF 75 DC FF 75 08 FF 75 1C FF 15 ?? ?? ?? ?? 89 45 CC 66 81 7E FE FF FF 74 18 66 81 3E FF FF 75 11 57 FF 75 E0 FF 75 14 E8 ?? ?? ?? ?? 83 C4 0C EB 04 83 65 CC 00 83 7D D4 00 74 09 FF 75 E0 E8 ?? ?? ?? ?? 59 33 F6 39 75 D0 74 09 FF 75 DC E8 ?? ?? ?? ?? 59 8B 45 CC 8D 65 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_656_0_0 {
	meta:
		name = "__mbsninc"
		size = 30
		refs = "0013 __mbsnbcnt"
	strings:
		$1 = { 83 7C 24 04 00 75 03 33 C0 C3 FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 03 44 24 0C 59 59 C3 }
	condition:
		$1
}

rule file_657_0_0 {
	meta:
		name = "___wtomb_environ"
		size = 144
		refs = "000c __wenviron 001b __imp__WideCharToMultiByte@32 0033 _malloc 0057 ___crtsetenv 006a _free"
	strings:
		$1 = { 55 8B EC 51 51 53 56 33 F6 57 8B 3D ?? ?? ?? ?? 89 75 FC 8B 07 3B C6 74 62 8B 1D ?? ?? ?? ?? 56 56 56 56 6A FF 50 56 56 FF D3 3B C6 89 45 F8 74 5A 50 E8 ?? ?? ?? ?? 3B C6 59 89 45 FC 74 4C 56 56 FF 75 F8 50 6A FF FF 37 56 56 FF D3 85 C0 74 31 8D 45 FC 56 50 E8 ?? ?? ?? ?? 85 C0 59 59 7D 11 39 75 FC 74 0C FF 75 FC E8 ?? ?? ?? ?? 59 89 75 FC 83 C7 04 8B 07 3B C6 75 A4 33 C0 5F 5E 5B C9 C3 FF 75 FC E8 ?? ?? ?? ?? 59 83 C8 FF EB ED }
	condition:
		$1
}

rule file_659_0_0 {
	meta:
		name = "__mbccpy"
		size = 35
		refs = "0011 __mbctype"
	strings:
		$1 = { 8B 44 24 08 8A 10 8B 4C 24 04 88 11 0F B6 10 F6 82 ?? ?? ?? ?? 04 74 0A 8A 40 01 84 C0 74 03 88 41 01 C3 }
	condition:
		$1
}

rule file_660_0_0 {
	meta:
		name = "_fseek"
		size = 142
		refs = "002c _ftell 0039 __flush 006a __lseek 0080 _errno"
	strings:
		$1 = { 56 8B 74 24 08 8B 46 0C A8 83 57 74 71 8B 7C 24 14 85 FF 74 0A 83 FF 01 74 05 83 FF 02 75 5F 83 E0 EF 83 FF 01 89 46 0C 75 0D 56 E8 ?? ?? ?? ?? 01 44 24 14 59 33 FF 56 E8 ?? ?? ?? ?? 8B 46 0C 84 C0 59 79 08 83 E0 FC 89 46 0C EB 14 A8 01 74 10 A8 08 74 0C F6 C4 04 75 07 C7 46 18 00 02 00 00 57 FF 74 24 14 FF 76 10 E8 ?? ?? ?? ?? 33 C9 83 C4 0C 83 F8 FF 0F 95 C1 49 8B C1 EB 0D C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF 5F 5E C3 }
	condition:
		$1
}

rule file_661_0_0 {
	meta:
		name = "_getenv"
		size = 129
		refs = "0002 ___env_initialized 000a __environ 001c __wenviron 0023 ___wtomb_environ 003f _strlen 005f __mbsnbicoll"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 5E C3 85 F6 53 57 75 1B 39 35 ?? ?? ?? ?? 74 51 E8 ?? ?? ?? ?? 85 C0 75 48 8B 35 ?? ?? ?? ?? 85 F6 74 3E 8B 5C 24 10 85 DB 74 36 53 E8 ?? ?? ?? ?? 59 8B F8 EB 25 50 E8 ?? ?? ?? ?? 3B C7 59 76 17 8B 06 80 3C 38 3D 75 0F 57 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 06 85 C0 75 D5 33 C0 5F 5B 5E C3 8B 06 8D 44 38 01 EB F4 }
	condition:
		$1
}

rule file_662_0_0 {
	meta:
		name = "_store_dt"
		size = 22
	strings:
		$1 = { 56 99 6A 0A 5E F7 FE 5E 04 30 88 01 41 80 C2 30 88 11 8D 41 01 C3 }
	condition:
		$1
}

rule file_662_1_0 {
	meta:
		name = "_asctime"
		size = 234
		refs = "0012 _buf 001e ___dnames 0027 ___mnames"
	strings:
		$1 = { 8B 4C 24 04 8B 41 18 53 55 56 57 8D 3C 40 8B 41 10 BA ?? ?? ?? ?? 8D 2C 40 33 F6 8A 84 37 ?? ?? ?? ?? 88 02 8A 84 2E ?? ?? ?? ?? 88 86 ?? ?? ?? ?? 46 42 83 FE 03 7C E3 C6 02 20 83 C2 04 C6 02 20 8B 41 0C 8D 72 01 99 6A 0A 5F 8B DF F7 FB B3 30 8B EF 6A 64 02 C3 88 06 02 D3 46 88 16 C6 46 01 20 8B 41 08 99 F7 FD 83 C6 02 02 C3 88 06 02 D3 46 88 16 C6 46 01 3A 8B 41 04 99 F7 FD 83 C6 02 02 C3 88 06 02 D3 46 88 16 C6 46 01 3A 8B 01 99 F7 FD 83 C6 02 5D 6A 64 02 C3 88 06 02 D3 46 88 16 C6 46 01 20 8B 41 14 99 F7 FD 8B EF 83 C6 02 83 C0 13 99 F7 FD 02 C3 88 06 02 D3 46 88 16 8B 41 14 99 59 F7 F9 8D 4E 01 8B C2 99 F7 FF 5F 02 C3 88 01 41 02 D3 88 11 C6 41 01 0A C6 41 02 00 B8 ?? ?? ?? ?? 5E 5D 5B C3 }
	condition:
		$1
}

rule file_663_3_0 {
	meta:
		name = "_WinMainCRTStartup"
		size = 476
		refs = "0003 $T20513 0008 __SEH_prolog 0014 __alloca_probe 0022 __imp__GetVersionExA@4 002b __osplatform 0033 __winmajor 003c __winminor 004b __osver 0066 __winver 006f __imp__GetModuleHandleA@4 00c9 __heap_init 00d4 ___error_mode 00dc __FF_MSGBANNER 00e3 __NMSG_WRITE 00ed ___crtExitProcess 00f4 __RTC_Initialize 00fc __ioinit 0107 __amsg_exit 010e __imp__GetCommandLineA@0 0113 __acmdln 0118 ___crtGetEnvironmentStringsA 011d __aenvptr 0122 __setargv 0133 __setenvp 0146 __cinit 0162 __imp__GetStartupInfoA@4 0167 __wincmdln 0187 _WinMain@16 0197 _exit 019c __cexit 01af __XcptFilter 01c4 __exit 01c9 __c_exit 01d7 __SEH_epilog"
	strings:
		$1 = { 6A 60 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF 94 00 00 00 8B C7 E8 ?? ?? ?? ?? 89 65 E8 8B F4 89 3E 56 FF 15 ?? ?? ?? ?? 8B 4E 10 89 0D ?? ?? ?? ?? 8B 46 04 A3 ?? ?? ?? ?? 8B 56 08 89 15 ?? ?? ?? ?? 8B 76 0C 81 E6 FF 7F 00 00 89 35 ?? ?? ?? ?? 83 F9 02 74 0C 81 CE 00 80 00 00 89 35 ?? ?? ?? ?? C1 E0 08 03 C2 A3 ?? ?? ?? ?? 33 F6 56 8B 3D ?? ?? ?? ?? FF D7 66 81 38 4D 5A 75 1F 8B 48 3C 03 C8 81 39 50 45 00 00 75 12 0F B7 41 18 3D 0B 01 00 00 74 1F 3D 0B 02 00 00 74 05 89 75 E4 EB 27 83 B9 84 00 00 00 0E 76 F2 33 C0 39 B1 F8 00 00 00 EB 0E 83 79 74 0E 76 E2 33 C0 39 B1 E8 00 00 00 0F 95 C0 89 45 E4 56 E8 ?? ?? ?? ?? 59 85 C0 75 21 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? 6A 1C E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 89 75 FC E8 ?? ?? ?? ?? 85 C0 7D 08 6A 1B E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 89 45 D8 3B C6 74 07 50 E8 ?? ?? ?? ?? 59 89 75 BC 8D 45 90 50 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 F6 45 BC 01 74 06 0F B7 45 C0 EB 03 6A 0A 58 50 FF 75 E0 56 56 FF D7 50 E8 ?? ?? ?? ?? 8B F8 89 7D D4 39 75 E4 75 06 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2B 8B 45 EC 8B 08 8B 09 89 4D DC 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 7D DC 83 7D E4 00 75 06 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D FC FF 8B C7 8D 65 84 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_664_0_0 {
	meta:
		name = "__check_commonlanguageruntime_version"
		size = 605
		refs = "000f ___security_cookie 0044 ??_C@_0M@MBOPBNBK@mscoree?4dll?$AA@ 0052 __imp__GetModuleHandleA@4 006c __imp__GetProcAddress@8 0071 ??_C@_0BG@OFDLOIGJ@GetCORSystemDirectory?$AA@ 0084 ??_C@_0P@GOIJDIPK@GetFileVersion?$AA@ 00d6 _wcslen 0100 _rgwchMsCORLib 0129 _wcscat 0235 ??_C@_0DF@FKILAAGL@Load?5failed?5due?5to?5incompatible?5@ 023b __imp__OutputDebugStringA@4 0242 __amsg_exit 0251 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 D4 FC FF FF 81 EC AC 03 00 00 A1 ?? ?? ?? ?? 53 57 89 85 28 03 00 00 33 DB 6A 63 33 C0 59 66 89 9D 98 01 00 00 8D BD 9A 01 00 00 F3 AB 66 AB 66 89 5D 90 33 C0 B9 81 00 00 00 8D 7D 92 F3 AB 68 ?? ?? ?? ?? 89 5D 88 66 AB 89 5D 8C FF 15 ?? ?? ?? ?? 8B F8 3B FB 0F 84 E8 01 00 00 83 FF FF 0F 84 DF 01 00 00 56 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D6 3B C3 89 45 84 0F 84 B1 01 00 00 68 ?? ?? ?? ?? 57 FF D6 3B C3 89 45 80 0F 84 9E 01 00 00 8D 45 8C 50 BE 04 01 00 00 56 8D 45 90 50 FF 55 84 85 C0 0F 8C 98 01 00 00 8B 45 8C 3B C3 0F 84 8D 01 00 00 3B C6 0F 83 85 01 00 00 66 39 5D 90 0F 84 7B 01 00 00 66 89 5C 45 90 8D 45 90 50 E8 ?? ?? ?? ?? 59 8D 4C 45 90 66 83 79 FE 5C 89 45 8C 74 16 40 3B C6 0F 84 55 01 00 00 66 C7 01 5C 00 89 45 8C 66 89 5C 45 90 BF ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B D8 8D 45 90 50 E8 ?? ?? ?? ?? 8D 44 03 01 3B C6 59 59 0F 83 24 01 00 00 8D 45 90 57 50 E8 ?? ?? ?? ?? 59 59 8D 45 88 50 BE C8 00 00 00 56 8D 85 98 01 00 00 50 8D 45 90 50 FF 55 80 85 C0 0F 8C F8 00 00 00 8B 45 88 33 FF 3B C7 0F 84 EB 00 00 00 3B C6 0F 83 E3 00 00 00 66 39 BD 98 01 00 00 0F 84 D6 00 00 00 66 89 BC 45 98 01 00 00 8D 85 98 01 00 00 50 E8 ?? ?? ?? ?? 66 39 BD 98 01 00 00 89 45 88 59 8D 85 98 01 00 00 0F 84 AB 00 00 00 8B 8D 98 01 00 00 6A 30 5E 6A 02 5A 66 83 F9 20 74 11 66 83 F9 76 74 0B 66 83 F9 56 74 05 66 3B CE 75 0A 03 C2 66 8B 08 66 3B CF 75 DF 66 8B 08 66 3B CF 74 76 66 3B CE 72 71 66 83 F9 39 77 6B 66 83 F9 31 75 65 03 C2 66 83 38 2E 75 5D 03 C2 66 8B 08 66 3B CF 74 53 66 83 F9 20 74 06 66 83 F9 2E 75 0A 03 C2 66 8B 08 66 3B CF 75 EA 66 8B 08 66 3B CF 74 35 66 3B CE 75 0A 03 C2 66 8B 08 66 3B CF 75 F1 66 8B 00 66 3B C7 74 1E 66 3B C6 72 06 66 3D 39 00 76 13 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A 1D E8 ?? ?? ?? ?? 59 5E 8B 8D 28 03 00 00 5F 5B E8 ?? ?? ?? ?? 81 C5 2C 03 00 00 C9 C3 }
	condition:
		$1
}

rule file_665_0_0 {
	meta:
		name = "__make__time64_t"
		size = 592
		refs = "00a3 __days 00b9 __allrem 0128 __alldiv 0177 __allmul 01e6 ___tzset 01eb __timezone 01fb __localtime64 0213 __dstbias 022e __gmtime64"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 8B F8 8B 47 14 99 85 D2 89 45 F4 89 55 F8 0F 8C 29 02 00 00 7F 09 83 F8 45 0F 82 1E 02 00 00 83 7D F8 00 0F 8F 14 02 00 00 BE 4C 04 00 00 7C 09 39 75 F4 0F 87 04 02 00 00 8B 47 10 85 C0 7C 05 83 F8 0B 7E 4F 99 6A 0C 59 F7 F9 8B CA 99 01 45 F4 89 4F 10 11 55 F8 85 C9 7D 0E 83 C1 0C 83 45 F4 FF 89 4F 10 83 55 F8 FF 83 7D F8 00 0F 8C CA 01 00 00 7F 0A 83 7D F4 45 0F 82 BE 01 00 00 83 7D F8 00 0F 8F B4 01 00 00 7C 09 39 75 F4 0F 87 A9 01 00 00 8B 77 10 8B 04 B5 ?? ?? ?? ?? 6A 00 6A 04 FF 75 F8 99 FF 75 F4 89 45 EC 89 55 F0 E8 ?? ?? ?? ?? 0B C2 BB 90 01 00 00 75 13 6A 00 6A 64 FF 75 F8 FF 75 F4 E8 ?? ?? ?? ?? 0B C2 75 1C 8B 45 F4 8B 4D F8 6A 00 05 6C 07 00 00 53 83 D1 00 51 50 E8 ?? ?? ?? ?? 0B C2 75 0D 83 FE 01 7E 08 83 45 EC 01 83 55 F0 00 8B 75 F4 8B 45 F8 8B 55 F8 6A 00 59 83 EE 01 1B C1 89 45 E8 8B 45 F4 51 05 2B 01 00 00 53 13 D1 52 50 89 75 E4 E8 ?? ?? ?? ?? 8B D8 8B 47 0C 6A 00 8B CA 99 6A 64 FF 75 E8 03 D8 13 CA 56 89 4D FC E8 ?? ?? ?? ?? 6A 00 6A 04 FF 75 E8 2B D8 8B 45 FC 1B C2 56 89 45 FC E8 ?? ?? ?? ?? 6A 00 68 6D 01 00 00 FF 75 F8 03 D8 8B 45 FC FF 75 F4 13 C2 89 45 FC E8 ?? ?? ?? ?? 03 D8 8B 45 FC 13 C2 03 5D EC 6A 00 13 45 F0 81 EB DF 63 00 00 89 5D FC 5B 53 1B C3 6A 18 50 8B 45 FC 50 E8 ?? ?? ?? ?? 8B C8 8B 47 08 8B F2 99 53 03 C1 6A 3C 13 D6 52 50 E8 ?? ?? ?? ?? 8B C8 8B 47 04 8B F2 99 03 C1 13 D6 53 6A 3C 52 50 E8 ?? ?? ?? ?? 8B C8 8B 07 8B F2 99 03 C1 13 D6 39 5D 08 89 45 F4 89 55 F8 74 44 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 99 01 45 F4 8D 45 F4 50 11 55 F8 E8 ?? ?? ?? ?? 3B C3 59 74 42 8B 4F 20 3B CB 7F 07 7D 2A 39 58 20 7E 25 A1 ?? ?? ?? ?? 99 01 45 F4 8D 45 F4 50 11 55 F8 E8 ?? ?? ?? ?? EB 09 8D 45 F4 50 E8 ?? ?? ?? ?? 3B C3 59 74 0F 8B 55 F8 6A 09 8B F0 8B 45 F4 59 F3 A5 EB 05 83 CA FF 8B C2 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_666_0_0 {
	meta:
		name = "__flswbuf"
		size = 293
		refs = "0058 __iob 0068 __isatty 0073 __getbuf 00a0 __write 00b6 ___pioinfo 00c5 ___badioinfo 00d4 __lseek"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 75 0C 8B 46 0C A8 82 8B 4E 10 89 4D FC 0F 84 FC 00 00 00 A8 40 0F 85 F4 00 00 00 33 DB A8 01 74 16 A8 10 89 5E 04 0F 84 E3 00 00 00 8B 56 08 83 E0 FE 89 16 89 46 0C 8B 46 0C 83 E0 EF 83 C8 02 66 A9 0C 01 89 46 0C 89 5E 04 89 5D 0C 75 25 81 FE ?? ?? ?? ?? 74 08 81 FE ?? ?? ?? ?? 75 0B 51 E8 ?? ?? ?? ?? 85 C0 59 75 07 56 E8 ?? ?? ?? ?? 59 8B 4D FC 66 F7 46 0C 08 01 57 74 62 8B 46 08 8B 3E 8D 50 02 89 16 8B 56 18 2B F8 4A 4A 3B FB 89 56 04 7E 0D 57 50 51 E8 ?? ?? ?? ?? 89 45 0C EB 2F 83 F9 FF 74 16 8B C1 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B D1 83 E2 1F 8D 04 D0 EB 05 B8 ?? ?? ?? ?? F6 40 04 20 74 0C 6A 02 53 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 46 08 8B 5D 08 66 89 18 EB 1B 8B 5D 08 6A 02 5F 57 8D 45 0C 50 51 66 89 5D 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 0C 39 7D 0C 5F 74 06 83 4E 0C 20 EB 0F 8B C3 25 FF FF 00 00 EB 0B 83 C8 20 89 46 0C B8 FF FF 00 00 5E 5B C9 C3 }
	condition:
		$1
}

rule file_667_0_0 {
	meta:
		name = "__fpcvt"
		size = 59
		refs = "0013 _buf 0019 __fptostr"
	strings:
		$1 = { B8 5B 01 00 00 39 44 24 04 7F 04 8B 44 24 04 56 57 50 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8B 4C 24 1C 33 C0 83 C4 0C 83 3F 2D 0F 94 C0 89 01 8B 47 04 8B 4C 24 0C 89 01 8B C6 5E C3 }
	condition:
		$1
}

rule file_667_1_0 {
	meta:
		name = "__fcvt"
		size = 41
		refs = "000b __fltout 001f __fpcvt"
	strings:
		$1 = { 55 8B EC 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 18 8B 48 04 03 4D 10 FF 75 14 8B F8 51 E8 ?? ?? ?? ?? 83 C4 14 5F 5D C3 }
	condition:
		$1
}

rule file_667_2_0 {
	meta:
		name = "__ecvt"
		size = 53
		refs = "0016 __fltout 001f __fpcvt"
	strings:
		$1 = { 55 8B EC 56 8B 75 10 57 FF 75 18 FF 75 14 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F8 E8 ?? ?? ?? ?? 83 C4 0C 8D 0C 30 80 39 00 5F 5E 74 03 C6 01 00 5D C3 }
	condition:
		$1
}

rule file_668_0_0 {
	meta:
		name = "??0exception@@QAE@XZ"
		size = 17
		refs = "000c ??_7exception@@6B@"
	strings:
		$1 = { 8B C1 83 60 04 00 83 60 08 00 C7 00 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_668_1_0 {
	meta:
		name = "??0exception@@QAE@ABQBD@Z"
		size = 61
		refs = "000a ??_7exception@@6B@ 0011 _strlen 0018 _malloc 0029 _strcpy"
	strings:
		$1 = { 56 57 8B 7C 24 0C 8B F1 C7 06 ?? ?? ?? ?? FF 37 E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 85 C0 59 59 89 46 04 74 0A FF 37 50 E8 ?? ?? ?? ?? 59 59 5F C7 46 08 01 00 00 00 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_2_0 {
	meta:
		name = "??0exception@@QAE@ABV0@@Z"
		size = 74
		refs = "000a ??_7exception@@6B@ 001c _strlen 0023 _malloc 0035 _strcpy"
	strings:
		$1 = { 56 8B F1 57 8B 7C 24 0C C7 06 ?? ?? ?? ?? 8B 47 08 85 C0 89 46 08 74 25 FF 77 04 E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 85 C0 59 59 89 46 04 74 13 FF 77 04 50 E8 ?? ?? ?? ?? 59 59 EB 06 8B 47 04 89 46 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_3_0 {
	meta:
		name = "??1exception@@UAE@XZ"
		size = 22
		refs = "0006 ??_7exception@@6B@ 0010 _free"
	strings:
		$1 = { 83 79 08 00 C7 01 ?? ?? ?? ?? 74 09 FF 71 04 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_668_5_0 {
	meta:
		name = "??0bad_cast@@QAE@PBD@Z"
		size = 25
		refs = "0009 ??0exception@@QAE@ABQBD@Z 000f ??_7bad_cast@@6B@"
	strings:
		$1 = { 56 8D 44 24 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_8_0 {
	meta:
		name = "??0bad_typeid@@QAE@PBD@Z"
		size = 25
		refs = "0009 ??0exception@@QAE@ABQBD@Z 000f ??_7bad_typeid@@6B@"
	strings:
		$1 = { 56 8D 44 24 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_6_0 {
	meta:
		name = "??0bad_cast@@QAE@ABV0@@Z"
		size = 24
		refs = "0008 ??0exception@@QAE@ABV0@@Z 000e ??_7bad_cast@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_12_0 {
	meta:
		name = "??0__non_rtti_object@@QAE@ABV0@@Z"
		size = 24
		refs = "0008 ??0bad_typeid@@QAE@ABV0@@Z 000e ??_7__non_rtti_object@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_11_0 {
	meta:
		name = "??0__non_rtti_object@@QAE@PBD@Z"
		size = 24
		refs = "0008 ??0bad_typeid@@QAE@PBD@Z 000e ??_7__non_rtti_object@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_9_0 {
	meta:
		name = "??0bad_typeid@@QAE@ABV0@@Z"
		size = 24
		refs = "0008 ??0exception@@QAE@ABV0@@Z 000e ??_7bad_typeid@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_668_15_0 {
	meta:
		name = "??4exception@@QAEAAV0@ABV0@@Z"
		size = 31
		refs = "000a ??1exception@@UAE@XZ 0015 ??0exception@@QAE@ABV0@@Z"
	strings:
		$1 = { 56 8B F1 3B 74 24 08 74 10 E8 ?? ?? ?? ?? FF 74 24 08 8B CE E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_669_0_0 {
	meta:
		name = "__hextodec"
		size = 50
		refs = "0002 ___mb_cur_max 0010 __isctype 0019 __pctype"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 56 8B F0 7E 0C 6A 04 56 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 70 83 E0 04 85 C0 75 06 83 E6 DF 83 EE 07 8B C6 5E C3 }
	condition:
		$1
}

rule file_669_3_0 {
	meta:
		name = "__whiteout"
		size = 25
		refs = "0004 __getche 000c _isspace"
	strings:
		$1 = { 57 FF 06 E8 ?? ?? ?? ?? 8B F8 57 E8 ?? ?? ?? ?? 85 C0 59 75 EC 8B C7 5F C3 }
	condition:
		$1
}

rule file_669_4_0 {
	meta:
		name = "_input"
		size = 3514
		refs = "0006 $T20884 000b __SEH_prolog 0010 ___security_cookie 0055 ___mb_cur_max 0060 __isctype 006a __pctype 0088 __getche 0090 _isspace 009b __un_inc 0404 ___decimal_point 0586 __cfltcvt_tab 06b0 _mbtowc 0776 __alloca_probe 0793 __resetstkoflw 079a _malloc 07bd _free 07d2 @__security_check_cookie@4 07d7 __SEH_epilog 07fc _memset 0ac9 __allmul 0b20 __hextodec"
	strings:
		$1 = { 68 D0 01 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 33 C0 89 85 40 FE FF FF 89 85 24 FE FF FF 89 85 48 FE FF FF 89 85 6C FE FF FF 88 85 6A FE FF FF 89 85 7C FE FF FF 89 85 44 FE FF FF 8B 7D 08 8A 07 84 C0 0F 84 5D 07 00 00 0F B6 C0 83 3D ?? ?? ?? ?? 01 7E 0C 6A 08 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 08 33 F6 3B C6 74 3B FF 8D 7C FE FF FF FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 85 C0 75 E8 56 E8 ?? ?? ?? ?? 59 FF 45 08 8B 45 08 0F B6 00 50 E8 ?? ?? ?? ?? 59 85 C0 75 EC EB 8D 8B 7D 08 80 3F 25 0F 85 8C 0C 00 00 89 B5 58 FE FF FF C6 85 63 FE FF FF 00 89 B5 64 FE FF FF 89 B5 5C FE FF FF 89 B5 74 FE FF FF C6 85 57 FE FF FF 00 C6 85 69 FE FF FF 00 C6 85 72 FE FF FF 00 C6 85 83 FE FF FF 00 C6 85 6B FE FF FF 00 C6 85 7B FE FF FF 00 C6 85 73 FE FF FF 01 89 B5 34 FE FF FF 47 0F B6 1F 0F B6 C3 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 12 FF 85 5C FE FF FF 8D 04 B6 8D 74 43 D0 E9 BF 00 00 00 83 FB 4E 0F 8F 85 00 00 00 0F 84 B0 00 00 00 83 FB 2A 74 72 83 FB 46 0F 84 A2 00 00 00 83 FB 49 74 10 83 FB 4C 75 76 FE 85 73 FE FF FF E9 8D 00 00 00 8A 4F 01 80 F9 36 75 20 8D 47 02 80 38 34 75 18 8B F8 FF 85 34 FE FF FF 83 A5 4C FE FF FF 00 83 A5 50 FE FF FF 00 EB 65 80 F9 33 75 0C 8D 47 02 80 38 32 75 04 8B F8 EB 54 80 F9 64 74 4F 80 F9 69 74 4A 80 F9 6F 74 45 80 F9 78 74 40 80 F9 58 75 19 EB 39 FE 85 72 FE FF FF EB 31 83 FB 68 74 20 83 FB 6C 74 0D 83 FB 77 74 0E FE 85 83 FE FF FF EB 1A FE 85 73 FE FF FF FE 85 7B FE FF FF EB 0C FE 8D 73 FE FF FF FE 8D 7B FE FF FF 80 BD 83 FE FF FF 00 0F 84 F5 FE FF FF 89 B5 74 FE FF FF 89 7D 08 80 BD 72 FE FF FF 00 75 1A 8B 45 0C 89 85 20 FE FF FF 83 C0 04 89 45 0C 8B 70 FC 89 B5 48 FE FF FF EB 06 8B B5 48 FE FF FF C6 85 83 FE FF FF 00 80 BD 7B FE FF FF 00 75 18 8A 07 3C 53 74 0B 3C 43 C6 85 7B FE FF FF FF 75 07 C6 85 7B FE FF FF 01 8B 45 08 0F B6 38 83 CF 20 89 BD 3C FE FF FF 83 FF 6E 74 3B 83 FF 63 74 25 83 FF 7B 74 20 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 53 E8 ?? ?? ?? ?? 59 85 C0 75 E8 89 9D 6C FE FF FF EB 11 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 33 C0 39 85 5C FE FF FF 74 0C 39 85 74 FE FF FF 0F 84 1E 04 00 00 83 FF 6F 0F 8F DD 03 00 00 0F 84 FC 06 00 00 83 FF 63 0F 84 98 02 00 00 83 FF 64 0F 84 EA 06 00 00 0F 8E E9 03 00 00 83 FF 67 7E 44 83 FF 69 74 21 83 FF 6E 0F 85 D6 03 00 00 8B 85 7C FE FF FF 80 BD 72 FE FF FF 00 0F 84 E5 09 00 00 E9 0C 0A 00 00 6A 64 5F 8B 9D 6C FE FF FF 83 FB 2D 0F 85 66 05 00 00 C6 85 69 FE FF FF 01 E9 5F 05 00 00 8D B5 84 FE FF FF 8B 9D 6C FE FF FF 83 FB 2D 75 0E 88 9D 84 FE FF FF 8D B5 85 FE FF FF EB 05 83 FB 2B 75 19 FF 8D 74 FE FF FF FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 BD 5C FE FF FF 00 74 0C 81 BD 74 FE FF FF 5D 01 00 00 7E 0A C7 85 74 FE FF FF 5D 01 00 00 6A 04 5F 83 3D ?? ?? ?? ?? 01 7E 0B 57 53 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B6 04 58 23 C7 85 C0 74 2E 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 74 1E FF 85 64 FE FF FF 88 1E 46 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF EB AF 38 1D ?? ?? ?? ?? 75 76 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 74 66 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 A0 ?? ?? ?? ?? 88 06 46 89 9D 6C FE FF FF 83 3D ?? ?? ?? ?? 01 7E 0B 57 53 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B6 04 58 23 C7 85 C0 74 28 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 74 18 FF 85 64 FE FF FF 88 1E 46 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 EB AF 83 BD 64 FE FF FF 00 0F 84 B1 00 00 00 83 FB 65 74 09 83 FB 45 0F 85 A3 00 00 00 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 0F 84 8F 00 00 00 C6 06 65 46 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 FB 2D 75 05 88 06 46 EB 05 83 FB 2B 75 2B 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 75 08 21 85 74 FE FF FF EB 13 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 3D ?? ?? ?? ?? 01 7E 0B 57 53 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B6 04 58 23 C7 85 C0 74 1B 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 74 0B FF 85 64 FE FF FF 88 1E 46 EB AF FF 8D 7C FE FF FF 53 E8 ?? ?? ?? ?? 59 83 BD 64 FE FF FF 00 0F 84 55 02 00 00 80 BD 72 FE FF FF 00 0F 85 DB 07 00 00 FF 85 44 FE FF FF C6 06 00 8D 85 84 FE FF FF 50 FF B5 48 FE FF FF 0F BE 85 73 FE FF FF 48 50 FF 15 ?? ?? ?? ?? 83 C4 0C E9 AE 07 00 00 39 85 5C FE FF FF 75 10 C7 85 5C FE FF FF 01 00 00 00 FF 85 74 FE FF FF 80 BD 7B FE FF FF 00 7E 07 C6 85 6B FE FF FF 01 8B B5 48 FE FF FF 8B DE FF 8D 7C FE FF FF FF B5 6C FE FF FF E8 ?? ?? ?? ?? 59 83 BD 5C FE FF FF 00 74 14 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 0F 84 AD 03 00 00 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 83 BD 3C FE FF FF 63 74 4F 83 BD 3C FE FF FF 73 75 0F 83 F8 09 7C 05 83 F8 0D 7E 05 83 F8 20 75 37 83 BD 3C FE FF FF 7B 0F 85 61 03 00 00 8B C8 83 E1 07 33 D2 42 D3 E2 8B C8 C1 F9 03 8B BD 40 FE FF FF 0F BE 0C 39 0F BE BD 57 FE FF FF 33 CF 85 D1 0F 84 37 03 00 00 80 BD 72 FE FF FF 00 0F 85 24 03 00 00 80 BD 6B FE FF FF 00 0F 84 09 03 00 00 88 85 38 FE FF FF 0F B6 C0 8B 0D ?? ?? ?? ?? F6 44 41 01 80 74 11 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 88 85 39 FE FF FF FF 35 ?? ?? ?? ?? 8D 85 38 FE FF FF 50 8D 85 30 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 66 8B 85 30 FE FF FF 66 89 06 46 46 E9 B8 02 00 00 8B C7 83 E8 70 0F 84 13 03 00 00 83 E8 03 0F 84 CE FE FF FF 48 48 0F 84 09 03 00 00 83 E8 03 0F 84 4A FC FF FF 83 E8 03 74 3F 8B 45 08 0F B6 00 3B 85 6C FE FF FF 74 10 FF B5 6C FE FF FF E8 ?? ?? ?? ?? E9 99 06 00 00 FE 8D 6A FE FF FF 80 BD 72 FE FF FF 00 0F 85 1D 06 00 00 8B 85 20 FE FF FF 89 45 0C E9 0F 06 00 00 80 BD 7B FE FF FF 00 7E 07 C6 85 6B FE FF FF 01 8B 7D 08 47 89 7D 08 89 BD 2C FE FF FF 80 3F 5E 75 0E 47 89 BD 2C FE FF FF C6 85 57 FE FF FF FF 8B 9D 40 FE FF FF 85 DB 0F 85 87 00 00 00 21 5D FC 6A 20 58 E8 ?? ?? ?? ?? 89 65 E8 8B DC 89 9D 40 FE FF FF 83 4D FC FF EB 6B 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 6A 20 E8 ?? ?? ?? ?? 59 89 85 40 FE FF FF 85 C0 75 33 83 4D FC FF 83 BD 24 FE FF FF 01 75 0C FF B5 40 FE FF FF E8 ?? ?? ?? ?? 59 8B 85 44 FE FF FF 8D A5 14 FE FF FF 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 C7 85 24 FE FF FF 01 00 00 00 83 4D FC FF 8B BD 2C FE FF FF 8B 9D 40 FE FF FF 6A 20 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 83 BD 3C FE FF FF 7B 75 77 80 3F 5D 75 72 B2 5D 47 C6 43 0B 20 EB 6F 47 3C 2D 75 4B 84 D2 74 47 8A 0F 80 F9 5D 74 40 47 3A D1 73 04 8A C1 EB 04 8A C2 8A D1 3A D0 77 2B 0F B6 F2 2A C2 FE C0 0F B6 C0 89 85 28 FE FF FF 8B C6 C1 E8 03 03 C3 8B CE 83 E1 07 B2 01 D2 E2 08 10 46 FF 8D 28 FE FF FF 75 E5 32 D2 EB 1F 88 85 63 FE FF FF 0F B6 C8 8B C1 C1 E8 03 03 C3 83 E1 07 B2 01 D2 E2 08 10 8A 95 63 FE FF FF 8A 07 3C 5D 75 8B 84 C0 0F 84 16 FF FF FF 83 BD 3C FE FF FF 7B 0F 85 16 FD FF FF 89 7D 08 E9 0E FD FF FF 83 FB 2B 75 2D FF 8D 74 FE FF FF 75 12 83 BD 5C FE FF FF 00 74 09 C6 85 83 FE FF FF 01 EB 13 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 FB 30 0F 85 4C 01 00 00 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 80 FB 78 74 48 80 FB 58 74 43 C7 85 64 FE FF FF 01 00 00 00 83 FF 78 74 1F 83 BD 5C FE FF FF 00 74 0E FF 8D 74 FE FF FF 75 06 FE 85 83 FE FF FF 6A 6F 5F E9 01 01 00 00 FF 8D 7C FE FF FF 53 E8 ?? ?? ?? ?? 59 6A 30 5B E9 E6 00 00 00 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 BD 5C FE FF FF 00 74 16 83 AD 74 FE FF FF 02 83 BD 74 FE FF FF 01 7D 06 FE 85 83 FE FF FF 6A 78 EB AF 88 06 46 89 B5 48 FE FF FF E9 49 FC FF FF 43 E9 43 FC FF FF FF 8D 7C FE FF FF 50 E8 ?? ?? ?? ?? 59 3B DE 0F 84 07 FE FF FF 80 BD 72 FE FF FF 00 0F 85 8D 03 00 00 FF 85 44 FE FF FF 83 BD 3C FE FF FF 63 0F 84 7A 03 00 00 8B 85 48 FE FF FF 80 BD 6B FE FF FF 00 74 09 66 83 20 00 E9 62 03 00 00 C6 00 00 E9 5A 03 00 00 C6 85 73 FE FF FF 01 8B 9D 6C FE FF FF 83 FB 2D 75 09 C6 85 69 FE FF FF 01 EB 05 83 FB 2B 75 2D FF 8D 74 FE FF FF 75 12 83 BD 5C FE FF FF 00 74 09 C6 85 83 FE FF FF 01 EB 13 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 BD 34 FE FF FF 00 0F 84 87 01 00 00 80 BD 83 FE FF FF 00 0F 85 49 01 00 00 BE 80 00 00 00 83 FF 78 0F 84 80 00 00 00 83 FF 70 74 7B 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 53 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 58 83 E0 04 85 C0 0F 84 9F 00 00 00 83 FF 6F 75 2A 83 FB 38 0F 8D 91 00 00 00 8B 85 4C FE FF FF 8B 8D 50 FE FF FF 0F A4 C1 03 C1 E0 03 89 85 4C FE FF FF 89 8D 50 FE FF FF EB 76 6A 00 6A 0A FF B5 50 FE FF FF FF B5 4C FE FF FF E8 ?? ?? ?? ?? 89 85 4C FE FF FF 89 95 50 FE FF FF EB 53 83 3D ?? ?? ?? ?? 01 7E 0B 56 53 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B6 04 58 23 C6 85 C0 74 2A 8B 85 4C FE FF FF 8B 8D 50 FE FF FF 0F A4 C1 04 C1 E0 04 89 85 4C FE FF FF 89 8D 50 FE FF FF 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 06 FE 85 83 FE FF FF 80 BD 83 FE FF FF 00 75 3F FF 85 64 FE FF FF 8D 43 D0 99 01 85 4C FE FF FF 11 95 50 FE FF FF 83 BD 5C FE FF FF 00 74 11 FF 8D 74 FE FF FF 75 09 C6 85 83 FE FF FF 01 EB 1C FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 EB 0D FF 8D 7C FE FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 83 FE FF FF 00 0F 84 C2 FE FF FF 89 9D 6C FE FF FF 80 BD 69 FE FF FF 00 0F 84 3D 01 00 00 8B 85 4C FE FF FF F7 D8 8B 8D 50 FE FF FF 83 D1 00 F7 D9 89 85 4C FE FF FF 89 8D 50 FE FF FF E9 19 01 00 00 80 BD 83 FE FF FF 00 0F 85 FD 00 00 00 BE 80 00 00 00 83 FF 78 74 50 83 FF 70 74 4B 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 53 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 58 83 E0 04 85 C0 74 5B 83 FF 6F 75 0E 83 FB 38 7D 51 C1 A5 58 FE FF FF 03 EB 4E 8B 85 58 FE FF FF 8D 04 80 D1 E0 89 85 58 FE FF FF EB 3B 83 3D ?? ?? ?? ?? 01 7E 0B 56 53 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B6 04 58 23 C6 85 C0 74 12 C1 A5 58 FE FF FF 04 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 06 FE 85 83 FE FF FF 80 BD 83 FE FF FF 00 75 3F FF 85 64 FE FF FF 8B 85 58 FE FF FF 8D 44 18 D0 89 85 58 FE FF FF 83 BD 5C FE FF FF 00 74 11 FF 8D 74 FE FF FF 75 09 C6 85 83 FE FF FF 01 EB 1C FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 EB 0D FF 8D 7C FE FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 83 FE FF FF 00 0F 84 0E FF FF FF 89 9D 6C FE FF FF 80 BD 69 FE FF FF 00 74 06 F7 9D 58 FE FF FF 83 FF 46 75 07 83 A5 64 FE FF FF 00 83 BD 64 FE FF FF 00 0F 84 B4 FA FF FF 80 BD 72 FE FF FF 00 75 3E FF 85 44 FE FF FF 8B B5 48 FE FF FF 8B 85 58 FE FF FF 83 BD 34 FE FF FF 00 74 13 8B 85 4C FE FF FF 89 06 8B 85 50 FE FF FF 89 46 04 EB 10 80 BD 73 FE FF FF 00 74 04 89 06 EB 03 66 89 06 FE 85 6A FE FF FF FF 45 08 E9 F5 F2 FF FF FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 0F B6 07 47 89 7D 08 3B C3 74 06 53 E9 94 F9 FF FF 0F B6 C3 8B 0D ?? ?? ?? ?? F6 44 41 01 80 0F 84 C0 F2 FF FF FF 85 7C FE FF FF E8 ?? ?? ?? ?? 0F B6 0F 47 89 7D 08 3B C8 74 13 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 E9 FE F9 FF FF FF 8D 7C FE FF FF E9 8C F2 FF FF }
	condition:
		$1
}

rule file_670_0_0 {
	meta:
		name = "__wperror"
		size = 186
		refs = "001a _wcstombs 002c _malloc 0048 _free 005a _strlen 0062 __write 0068 ??_C@_02LMMGGCAJ@?3?5?$AA@ 007c _errno 0085 __sys_nerr 0094 __sys_errlist 00a9 ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 53 8B 5C 24 08 85 DB 56 57 74 44 66 83 3B 00 74 3E 68 FF FF FF 7F 53 6A 00 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 47 0F 84 8C 00 00 00 57 E8 ?? ?? ?? ?? 8B F0 85 F6 59 74 7F 57 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 77 0B 56 E8 ?? ?? ?? ?? 59 EB 67 33 F6 85 F6 6A 02 5F 74 1D 56 E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 1C 56 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 59 8B 0D ?? ?? ?? ?? 7C 04 3B C1 7C 02 8B C1 8B 34 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 1C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_671_3_0 {
	meta:
		name = "__CIlog_default"
		size = 213
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0032 __DEFAULT_CW_in_mem 004c ___fastflag 0053 __fast_exit 0059 LOG_name 0063 __math_exit 0089 __indefinite 0095 __convertTOStoQNaN 00ad __minfinity 00cf __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 4C 8B 44 24 0C 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? A9 00 00 F0 7F 74 5E A9 00 00 00 80 75 41 D9 ED D9 C9 D9 F1 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E9 ?? ?? ?? ?? A9 00 00 00 80 75 17 EB D4 A9 FF FF 0F 00 75 1D 83 7C 24 08 00 75 16 25 00 00 00 80 74 C5 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 EB 22 E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 C5 83 7C 24 08 00 75 BE DD D8 DB 2D ?? ?? ?? ?? B8 02 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_672_0_0 {
	meta:
		name = "__stbuf"
		size = 136
		refs = "0009 __isatty 0014 __iob 002b __cflush 003c __stdbuf 004c _malloc"
	strings:
		$1 = { 56 8B 74 24 08 FF 76 10 E8 ?? ?? ?? ?? 85 C0 59 74 72 81 FE ?? ?? ?? ?? 75 04 33 C0 EB 0B 81 FE ?? ?? ?? ?? 75 5E 33 C0 40 FF 05 ?? ?? ?? ?? 66 F7 46 0C 0C 01 75 4D 53 57 8D 3C 85 ?? ?? ?? ?? 83 3F 00 BB 00 10 00 00 75 20 53 E8 ?? ?? ?? ?? 85 C0 59 89 07 75 13 8D 46 14 6A 02 89 46 08 89 06 58 89 46 18 89 46 04 EB 0D 8B 3F 89 7E 08 89 3E 89 5E 18 89 5E 04 66 81 4E 0C 02 11 5F 33 C0 5B 40 5E C3 33 C0 5E C3 }
	condition:
		$1
}

rule file_672_1_0 {
	meta:
		name = "__ftbuf"
		size = 60
		refs = "0014 __flush"
	strings:
		$1 = { 83 7C 24 04 00 56 74 21 8B 74 24 0C F6 46 0D 10 74 28 56 E8 ?? ?? ?? ?? 80 66 0D EE 83 66 18 00 83 26 00 83 66 08 00 EB 10 8B 44 24 0C F6 40 0D 10 74 07 50 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_673_0_0 {
	meta:
		name = "__fdopen"
		size = 215
		refs = "0006 __nhandle 0015 ___pioinfo 004c __commode 00ac __getstream 00b8 _errno 00c7 __cflush"
	strings:
		$1 = { 8B 44 24 04 3B 05 ?? ?? ?? ?? 53 73 28 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F F6 44 C1 04 01 74 12 8B 4C 24 0C 8A 01 3C 61 74 11 3C 72 74 08 3C 77 74 09 33 C0 5B C3 33 DB 43 EB 03 6A 02 5B 56 33 F6 57 46 33 D2 33 FF 0B 1D ?? ?? ?? ?? EB 52 85 F6 74 55 0F BE C0 83 E8 2B 74 39 83 E8 37 74 0D 48 74 1F 83 E8 0B 74 0D 83 E8 06 75 04 85 FF 74 1E 33 F6 EB 2C 85 D2 75 F8 42 81 E3 FF BF FF FF EB 1F 85 D2 75 EB 42 81 CB 00 40 00 00 EB 12 33 FF 47 EB 0D 84 DB 78 D9 83 E3 FC 81 CB 80 00 00 00 41 8A 01 84 C0 75 A7 E8 ?? ?? ?? ?? 85 C0 5F 5E 75 0F C7 05 ?? ?? ?? ?? 18 00 00 00 E9 70 FF FF FF FF 05 ?? ?? ?? ?? 8B 4C 24 08 89 58 0C 89 48 10 5B C3 }
	condition:
		$1
}

rule file_674_0_0 {
	meta:
		name = "__mbscspn"
		size = 119
		refs = "0008 ___ismbcodepage 0011 _strcspn 002e __mbctype"
	strings:
		$1 = { 55 8B EC 53 33 DB 39 1D ?? ?? ?? ?? 75 07 5B 5D E9 ?? ?? ?? ?? 8B 45 08 38 18 74 55 56 8B 75 0C 57 38 1E 8B CE 74 2E 8A 11 0F B6 FA F6 87 ?? ?? ?? ?? 04 74 17 3A 10 75 08 8A 51 01 3A 50 01 74 14 8D 51 01 38 1A 74 0D 8B CA EB 04 3A 10 74 05 41 38 19 75 D2 38 19 75 16 0F B6 08 F6 81 ?? ?? ?? ?? 04 74 05 40 38 18 74 05 40 38 18 75 B2 5F 5E 2B 45 08 5B 5D C3 }
	condition:
		$1
}

rule file_675_0_0 {
	meta:
		name = "__snwscanf"
		size = 51
		refs = "002a __winput"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 89 45 E8 89 45 E0 8B 45 0C 03 C0 89 45 E4 8D 45 14 50 FF 75 10 8D 45 E0 50 C7 45 EC 49 00 00 00 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_676_1_0 {
	meta:
		name = "_toupper"
		size = 215
		refs = "0007 ___lc_handle 0018 ___lc_clike 0032 ___mb_cur_max 003d __isctype 0046 __pctype 0087 ___lc_codepage 00a2 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 51 51 83 3D ?? ?? ?? ?? 00 53 8B 5D 08 0F 84 AF 00 00 00 83 3D ?? ?? ?? ?? 00 74 09 83 FB 7F 0F 86 9D 00 00 00 81 FB 00 01 00 00 73 25 83 3D ?? ?? ?? ?? 01 7E 0C 6A 02 53 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 58 83 E0 02 85 C0 74 7D 8B 15 ?? ?? ?? ?? 8B C3 C1 F8 08 0F B6 C8 F6 44 4A 01 80 74 0F 6A 02 88 45 FC 88 5D FD C6 45 FE 00 58 EB 0A 33 C0 88 5D FC C6 45 FD 00 40 6A 01 FF 35 ?? ?? ?? ?? 8D 4D F8 6A 03 51 50 8D 45 FC 50 68 00 02 00 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 25 83 F8 01 75 06 0F B6 45 F8 EB 1C 0F B6 4D F9 33 C0 8A 65 F8 0B C1 EB 0F 83 FB 61 7C 08 83 FB 7A 8D 43 E0 7E 02 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_677_0_0 {
	meta:
		name = "__locking"
		size = 252
		refs = "000a __nhandle 001f ___pioinfo 003a __lseek 0068 __imp__GetLastError@0 007a __get_osfhandle 0087 __imp__UnlockFile@20 008f __imp__LockFile@20 00ab __imp__Sleep@4 00c6 __dosmaperr 00cf _errno 00d9 __doserrno"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 08 3B 05 ?? ?? ?? ?? 53 56 57 0F 83 CC 00 00 00 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 8B D0 83 E2 1F F6 44 D1 04 01 0F 84 B0 00 00 00 6A 01 33 F6 56 50 E8 ?? ?? ?? ?? 89 45 F8 83 C8 FF 83 C4 0C 39 45 F8 0F 84 A7 00 00 00 83 7D 0C 01 74 09 83 7D 0C 03 89 75 FC 75 07 C7 45 FC 09 00 00 00 8B 1D ?? ?? ?? ?? 56 FF 75 10 33 FF 56 FF 75 F8 FF 75 08 E8 ?? ?? ?? ?? 39 75 0C 59 50 75 08 FF 15 ?? ?? ?? ?? EB 06 FF 15 ?? ?? ?? ?? 85 C0 75 04 FF D3 8B F8 39 75 FC 7E 14 3B FE 74 3B 68 E8 03 00 00 FF 15 ?? ?? ?? ?? FF 4D FC EB B8 3B FE 74 27 83 7D 0C 01 74 0F 83 7D 0C 03 74 09 57 E8 ?? ?? ?? ?? 59 EB 27 C7 05 ?? ?? ?? ?? 24 00 00 00 89 3D ?? ?? ?? ?? EB 15 33 C0 EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_680_0_0 {
	meta:
		name = "__sleep"
		size = 17
		refs = "000c __imp__Sleep@4"
	strings:
		$1 = { 8B 44 24 04 85 C0 75 01 40 50 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_681_0_0 {
	meta:
		name = "__mbsrchr"
		size = 86
		refs = "0007 ___ismbcodepage 000f _strrchr 0022 __mbctype"
	strings:
		$1 = { 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 75 06 5D E9 ?? ?? ?? ?? 8B 55 08 53 56 8A 1A 0F B6 CB 0F B6 F1 F6 86 ?? ?? ?? ?? 04 74 1D 42 8A 1A 84 DB 74 12 0F B6 F3 C1 E1 08 0B CE 39 4D 0C 75 10 8D 42 FF EB 0B 85 C0 EB 03 39 4D 0C 75 02 8B C2 42 84 DB 75 C6 5E 5B 5D C3 }
	condition:
		$1
}

rule file_682_0_0 {
	meta:
		name = "_wctomb"
		size = 102
		refs = "0013 ___lc_handle 0032 ___mb_cur_max 0043 ___lc_codepage 0049 __imp__WideCharToMultiByte@32 0058 _errno"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 33 F6 3B C6 75 04 33 C0 EB 52 39 35 ?? ?? ?? ?? 75 12 66 8B 4D 0C 66 81 F9 FF 00 77 32 88 08 33 C0 40 EB 38 8D 4D 08 51 56 FF 35 ?? ?? ?? ?? 89 75 08 50 6A 01 8D 45 0C 50 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B C6 74 05 39 75 08 74 0D C7 05 ?? ?? ?? ?? 2A 00 00 00 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_683_0_0 {
	meta:
		name = "__ungetch"
		size = 33
		refs = "000b _chbuf"
	strings:
		$1 = { 8B 44 24 04 83 F8 FF 74 14 83 3D ?? ?? ?? ?? FF 75 0B 25 FF 00 00 00 A3 ?? ?? ?? ?? C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_683_1_0 {
	meta:
		name = "__getextendedkeycode"
		size = 173
		refs = "001b _EnhancedKeys 006e _NormalKeys"
	strings:
		$1 = { 8B 54 24 04 53 8B 5A 0C F6 C7 01 56 74 54 66 8B 52 08 33 C0 33 C9 33 F6 66 39 96 ?? ?? ?? ?? 74 0B 83 C6 0A 41 83 FE 78 72 EE EB 7E F6 C3 03 8D 04 89 74 09 8D 04 45 ?? ?? ?? ?? EB 6D F6 C3 0C 74 09 8D 04 45 ?? ?? ?? ?? EB 5F F6 C3 10 74 09 8D 04 45 ?? ?? ?? ?? EB 51 8D 04 45 ?? ?? ?? ?? EB 48 F6 C3 03 0F B7 42 08 74 09 8D 04 C5 ?? ?? ?? ?? EB 23 F6 C3 0C 74 09 8D 04 C5 ?? ?? ?? ?? EB 15 F6 C3 10 74 09 8D 04 C5 ?? ?? ?? ?? EB 07 8D 04 C5 ?? ?? ?? ?? 8A 08 84 C9 74 05 80 F9 E0 75 06 80 78 01 00 75 02 33 C0 5E 5B C3 }
	condition:
		$1
}

rule file_683_2_0 {
	meta:
		name = "__getch"
		size = 193
		refs = "0007 _chbuf 001e __coninpfh 0030 ___initconin 0043 __imp__GetConsoleMode@8 0049 __imp__SetConsoleMode@8 0059 __imp__ReadConsoleInputA@16 007f __getextendedkeycode"
	strings:
		$1 = { 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 83 C9 FF 3B C1 74 0B 0F B6 C0 89 0D ?? ?? ?? ?? C9 C3 A1 ?? ?? ?? ?? 3B C1 75 04 8B C1 C9 C3 83 F8 FE 75 05 E8 ?? ?? ?? ?? 53 56 57 8D 45 F8 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 6A 00 FF 35 ?? ?? ?? ?? FF D3 8B 35 ?? ?? ?? ?? EB 29 83 7D FC 00 74 39 66 83 7D E4 01 75 1C 83 7D E8 00 74 16 0F B6 7D F2 85 FF 75 27 8D 45 E8 50 E8 ?? ?? ?? ?? 85 C0 59 75 2B 8D 45 FC 50 6A 01 8D 45 E4 50 FF 35 ?? ?? ?? ?? FF D6 85 C0 75 C1 83 CF FF FF 75 F8 FF 35 ?? ?? ?? ?? FF D3 8B C7 5F 5E 5B C9 C3 0F B6 38 0F B6 40 01 A3 ?? ?? ?? ?? EB E0 }
	condition:
		$1
}

rule file_683_3_0 {
	meta:
		name = "__getche"
		size = 55
		refs = "0001 _chbuf 0017 __getch 0024 __putch"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 0B 0F B6 C0 83 0D ?? ?? ?? ?? FF C3 56 E8 ?? ?? ?? ?? 8B F0 83 FE FF 74 10 56 E8 ?? ?? ?? ?? 83 F8 FF 59 74 04 8B C6 5E C3 83 C8 FF 5E C3 }
	condition:
		$1
}

rule file_683_4_0 {
	meta:
		name = "__kbhit"
		size = 296
		refs = "0003 $T20418 0008 __SEH_prolog 0016 _chbuf 0027 __coninpfh 002f ___initconin 0048 __imp__GetNumberOfConsoleInputEvents@8 006f __alloca_probe 0089 __resetstkoflw 00a2 _malloc 00c9 __imp__PeekConsoleInputA@16 00f4 __getextendedkeycode 0113 _free 0123 __SEH_epilog"
	strings:
		$1 = { 6A 1C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D DC 89 7D D8 83 3D ?? ?? ?? ?? FF 74 08 33 C0 40 E9 FA 00 00 00 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 0F 84 DC 00 00 00 8D 4D E4 51 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C9 00 00 00 8B 75 E4 3B F7 0F 84 BE 00 00 00 89 7D FC 8D 04 B6 C1 E0 02 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 89 65 E8 8B FC 89 7D D4 83 4D FC FF EB 15 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 33 FF 83 4D FC FF 8B 75 E4 85 FF 75 1E 8D 04 B6 C1 E0 02 50 E8 ?? ?? ?? ?? 59 8B F8 85 FF 74 70 33 DB 43 89 5D DC 8B 75 E4 EB 03 33 DB 43 8D 45 E0 50 56 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 3A 8B 75 E0 85 F6 74 33 3B 75 E4 77 2E EB 28 66 39 1F 75 1C 8D 47 04 83 38 00 74 14 80 7F 0E 00 75 0B 50 E8 ?? ?? ?? ?? 59 85 C0 74 03 89 5D D8 4E 89 75 E0 83 C7 14 85 F6 77 D4 83 7D DC 00 74 07 57 E8 ?? ?? ?? ?? 59 8B 45 D8 EB 02 33 C0 8D 65 C8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_684_0_0 {
	meta:
		name = "?GetImageInfo@@YAPAUImageInfo@@K@Z"
		size = 849
		refs = "000b _lImages 003e __imp__GetProcessHeap@0 0045 __imp__HeapFree@12 0057 _imghlp 0063 __imp__LoadLibraryA@4 0068 ??_C@_0N@NHGLKGEC@KERNEL32?4DLL?$AA@ 006f ??_C@_0N@KBGMOMJO@IMAGEHLP?4DLL?$AA@ 0074 _kernel 0095 __imp__GetProcAddress@8 009a ??_C@_0O@CHDGJGFP@ImageNtHeader?$AA@ 00a4 _ImageNtHeader 00af ??_C@_0BJ@JEFKDHMD@CreateToolhelp32Snapshot?$AA@ 00be _CreateToolhelp32SnapshotW9x 00c5 ??_C@_09EPMADGLA@PSAPI?4DLL?$AA@ 00ce _psapi 00d9 ??_C@_0BD@FIEJBLME@EnumProcessModules?$AA@ 00e3 _EnumProcessModules 00ee ??_C@_0BF@OCLFCNKN@GetModuleInformation?$AA@ 00fb _GetModuleInformation 0102 ??_C@_0O@CNMFJJGO@Module32First?$AA@ 0111 _Module32FirstW9x 011c ??_C@_0N@KIGOLBLC@Module32Next?$AA@ 0129 _Module32NextW9x 0144 __imp__GetCurrentProcess@0 01a2 __imp__HeapAlloc@12 01f1 __alloca_probe 024c __imp__CloseHandle@4 029b __imp__GetModuleFileNameA@12"
	strings:
		$1 = { 55 8B EC 81 EC 14 08 00 00 8B 0D ?? ?? ?? ?? 53 33 DB 3B CB 56 57 8B C1 74 3B 8B 50 04 3B 55 08 77 0E 8B 75 08 2B F2 3B 70 08 0F 86 16 03 00 00 8B 40 1C 3B C3 75 E3 8B 71 1C 51 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 3B F3 8B CE 89 0D ?? ?? ?? ?? 75 E2 39 1D ?? ?? ?? ?? 0F 85 D4 00 00 00 8B 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D7 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF D7 39 1D ?? ?? ?? ?? A3 ?? ?? ?? ?? 0F 84 B9 02 00 00 3B C3 0F 84 B1 02 00 00 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 FF D6 3B C3 A3 ?? ?? ?? ?? 0F 84 96 02 00 00 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 3B C3 A3 ?? ?? ?? ?? 75 3D 68 ?? ?? ?? ?? FF D7 3B C3 A3 ?? ?? ?? ?? 0F 84 6C 02 00 00 68 ?? ?? ?? ?? 50 FF D6 3B C3 A3 ?? ?? ?? ?? 0F 84 57 02 00 00 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 A3 ?? ?? ?? ?? EB 2C 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 3B C3 A3 ?? ?? ?? ?? 0F 84 29 02 00 00 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 A3 ?? ?? ?? ?? 3B C3 0F 84 0F 02 00 00 A1 ?? ?? ?? ?? 3B C3 0F 85 96 00 00 00 FF 15 ?? ?? ?? ?? 8D 4D F8 51 68 00 08 00 00 8D 8D EC F7 FF FF 51 50 89 45 FC FF 15 ?? ?? ?? ?? 85 C0 0F 84 DA 01 00 00 C1 6D F8 02 8B FB 0F 84 DA 00 00 00 6A 0C 8D 45 EC 50 8D B4 BD EC F7 FF FF FF 36 FF 75 FC FF 15 ?? ?? ?? ?? 85 C0 0F 84 AE 01 00 00 6A 20 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 3B C3 0F 84 55 01 00 00 8B 0E 89 48 0C 8B 4D EC 89 48 04 8B 4D F0 89 48 08 8B 0D ?? ?? ?? ?? 47 89 58 18 89 48 1C 3B 7D F8 A3 ?? ?? ?? ?? 72 A0 EB 78 53 6A 08 FF D0 83 F8 FF 89 45 FC 0F 84 5B 01 00 00 BF 24 02 00 00 8B C7 E8 ?? ?? ?? ?? 8B F4 89 3E 8B 7D FC 56 57 FF 15 ?? ?? ?? ?? EB 3F 6A 20 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 3B C3 74 41 8B 4E 1C 89 48 0C 8B 4E 14 89 48 04 8B 4E 18 89 48 08 8B 0D ?? ?? ?? ?? 56 57 89 58 18 89 48 1C A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 BD 57 FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? E9 82 00 00 00 57 FF 15 ?? ?? ?? ?? E9 9C 00 00 00 FF 76 04 FF 15 ?? ?? ?? ?? 89 46 10 0F B7 48 14 8D 44 01 18 89 46 14 B8 04 02 00 00 E8 ?? ?? ?? ?? 8B FC 68 00 02 00 00 57 88 9F 00 02 00 00 FF 76 0C FF 15 ?? ?? ?? ?? 85 C0 74 60 33 C0 38 1F 74 06 40 38 1C 38 75 FA 40 50 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 3B C3 89 46 18 74 3D 33 C9 8B 56 18 8D 04 39 8A 18 88 1C 11 33 DB 41 38 18 75 EE 8B 76 1C 3B F3 75 86 A1 ?? ?? ?? ?? 3B C3 74 5A 8B 48 04 3B 4D 08 77 0A 8B 55 08 2B D1 3B 50 08 76 4A 8B 40 1C 3B C3 75 E7 A1 ?? ?? ?? ?? 3B C3 74 38 8B 70 1C 8B 40 18 3B C3 74 0F 50 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 3B F3 8B C6 A3 ?? ?? ?? ?? 75 C8 33 C0 8D A5 E0 F7 FF FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_684_1_0 {
	meta:
		name = "?GetPdbDll@@YAPAUHINSTANCE__@@XZ"
		size = 312
		refs = "000d ?alreadyTried@?1??GetPdbDll@@YAPAUHINSTANCE__@@XZ@4HA 0019 _mspdbName 001f __imp__LoadLibraryA@4 0038 ??_C@_0N@JJPEKNFO@ADVAPI32?4DLL?$AA@ 004a __imp__GetProcAddress@8 004f ??_C@_0O@DCOGKJGG@RegOpenKeyExA?$AA@ 0062 ??_C@_0BB@HHEIPGME@RegQueryValueExA?$AA@ 0075 ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 008b ??_C@_0CN@KGLAKABH@SOFTWARE?2Microsoft?2VisualStudio?2@ 009e __imp__FreeLibrary@4 00af ??_C@_0BF@BMIHBHCA@EnvironmentDirectory?$AA@ 00cc __alloca_probe"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 33 FF 39 3D ?? ?? ?? ?? 0F 85 E0 00 00 00 FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 FF D6 3B C7 0F 85 F9 00 00 00 68 ?? ?? ?? ?? FF D6 8B D8 3B DF 0F 84 AF 00 00 00 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 FF D6 3B C7 89 45 F0 0F 84 96 00 00 00 68 ?? ?? ?? ?? 53 FF D6 3B C7 89 45 F4 0F 84 83 00 00 00 68 ?? ?? ?? ?? 53 FF D6 3B C7 89 45 E8 74 74 8D 45 F8 50 6A 01 57 68 ?? ?? ?? ?? 68 02 00 00 80 FF 55 F0 85 C0 74 09 53 FF 15 ?? ?? ?? ?? EB 53 8D 45 FC 50 57 8D 45 EC 50 57 BE ?? ?? ?? ?? 56 FF 75 F8 FF 55 F4 85 C0 75 39 83 45 FC 0D 8B 45 FC 83 C0 03 83 E0 FC E8 ?? ?? ?? ?? 8B FC 8D 45 FC 50 57 8D 45 EC 50 6A 00 56 FF 75 F8 FF 55 F4 FF 75 F8 8B F0 FF 55 E8 53 FF 15 ?? ?? ?? ?? 85 F6 74 04 33 C0 EB 35 8B 45 FC 03 C7 80 78 FE 5C 74 06 C6 40 FF 5C EB 03 FF 4D FC 8B 0D ?? ?? ?? ?? 6A 0C 8B C7 2B CF 5E 8A 14 01 8B 5D FC 88 14 18 40 4E 75 F3 57 FF 15 ?? ?? ?? ?? 8D 65 DC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_684_2_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHKPADHPAHPAPAD@Z"
		size = 847
		refs = "000f __alloca_probe 002f ?GetImageInfo@@YAPAUImageInfo@@K@Z 004b ?PDBOK@?3??_RTC_GetSrcLine@@YAHKPADHPAHPAPAD@Z@4HA 005e _mspdb 006a ?GetPdbDll@@YAPAUHINSTANCE__@@XZ 007d __imp__GetProcAddress@8 0082 ??_C@_0BB@PENKIMFE@PDBOpenValidate3?$AA@ 008c _PDBOpenValidate3 0097 ??_C@_0L@KPMOCKEL@PDBOpenDBI?$AA@ 00a6 _PDBOpenDBI 00ad ??_C@_0BE@GDNPNLGH@DBIQueryModFromAddr?$AA@ 00bc _DBIQueryModFromAddr 00c3 ??_C@_0O@IPLOKOKN@ModQueryLines?$AA@ 00d2 _ModQueryLines 00d9 ??_C@_08LIGPJJNA@ModClose?$AA@ 00e8 _ModClose 00ef ??_C@_08NINFAAFA@DBIClose?$AA@ 00fe _DBIClose 0105 ??_C@_08ONJBEOFA@PDBClose?$AA@ 0114 _PDBClose 01a3 ??_C@_00CNPNBAHC@?$AA@ 01c3 ??_C@_01KDCPPGHE@r?$AA@ 022a __imp__GetProcessHeap@0 0231 __imp__HeapAlloc@12 0322 __imp__HeapFree@12"
	strings:
		$1 = { 55 8B EC 83 EC 34 53 56 57 B8 00 04 00 00 E8 ?? ?? ?? ?? 8B 4D 14 8B 5D 18 8B 75 08 33 C0 89 01 8B 4D 0C 89 65 F4 88 01 56 89 45 E0 89 03 E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 84 06 03 00 00 2B 77 04 8B 47 18 89 03 33 DB 43 83 3D ?? ?? ?? ?? 00 89 75 EC 89 5D E0 0F 85 CE 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 DB 02 00 00 E8 ?? ?? ?? ?? 85 C0 A3 ?? ?? ?? ?? 0F 84 C9 02 00 00 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 FF D6 85 C0 A3 ?? ?? ?? ?? 0F 84 84 00 00 00 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 85 C0 A3 ?? ?? ?? ?? 74 6E 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 85 C0 A3 ?? ?? ?? ?? 74 58 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 85 C0 A3 ?? ?? ?? ?? 74 42 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 85 C0 A3 ?? ?? ?? ?? 74 2C 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 85 C0 A3 ?? ?? ?? ?? 74 16 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 85 C0 A3 ?? ?? ?? ?? 75 07 33 C0 E9 26 02 00 00 8B 75 EC 89 1D ?? ?? ?? ?? 8B 47 10 0F B7 40 06 33 DB 66 85 C0 89 45 EC 0F 86 05 02 00 00 8B 4F 14 0F B7 C3 8D 04 80 C1 E0 03 39 74 01 0C 73 0F 8B 57 14 03 C2 8B D6 2B 50 0C 3B 50 10 72 0C 43 66 3B 5D EC 72 DB E9 D8 01 00 00 0F B7 C3 8D 04 80 2B 74 C1 0C 83 FE FF 89 75 EC 0F 84 C2 01 00 00 B8 04 01 00 00 E8 ?? ?? ?? ?? 8B C4 8D 4D E4 51 8D 4D D8 51 8D 4D D4 51 50 FF 75 F4 8D 45 D0 50 68 ?? ?? ?? ?? FF 77 18 FF 15 ?? ?? ?? ?? 83 C4 20 85 C0 0F 84 89 01 00 00 8D 45 E8 50 33 FF 57 68 ?? ?? ?? ?? FF 75 E4 FF 15 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 5F 01 00 00 8D 45 FC 50 8D 45 CC 50 8D 45 1A 50 8D 45 F0 50 56 43 53 FF 75 E8 FF 15 ?? ?? ?? ?? 83 C4 1C 85 C0 0F 84 2E 01 00 00 8D 45 FC 50 57 FF 75 F0 FF 15 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 0B 01 00 00 39 7D FC 0F 84 02 01 00 00 FF 75 FC 57 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F8 8D 45 FC 50 57 FF 75 F0 89 7D F4 FF 15 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 D3 00 00 00 0F B7 07 83 65 F8 00 85 C0 0F 8E B4 00 00 00 8B 45 F8 8B 44 87 04 03 C7 0F B7 08 8D 54 88 04 8D 34 CA 89 75 DC 33 F6 85 C9 7E 16 8B 7D EC 39 3C F2 77 06 3B 7C F2 04 76 15 46 3B F1 7C ED 8B 7D F4 0F B7 07 FF 45 F8 39 45 F8 7C C3 EB 75 8B 44 B0 04 03 45 F4 83 CB FF 0F B7 48 02 33 FF 85 C9 8D 74 88 04 89 5D F8 7E 57 8B 55 EC 2B 54 B8 04 3B D3 73 05 89 7D F8 8B DA 47 3B F9 7C EB 8B 45 F8 85 C0 7C 3B 0F B7 04 46 8B 4D 14 8B 7D 10 89 01 8B 45 DC 33 F6 80 38 00 74 15 8B 4D 0C 2B C8 3B F7 7D 12 8A 10 88 14 01 46 40 80 38 00 75 F0 3B F7 8B C6 7C 03 8D 47 FF 8B 4D 0C C6 04 08 00 8B 7D F4 57 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 75 F0 FF 15 ?? ?? ?? ?? 59 FF 75 E8 FF 15 ?? ?? ?? ?? 59 FF 75 E4 FF 15 ?? ?? ?? ?? 59 8B 45 E0 8D 65 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_685_0_0 {
	meta:
		name = "_$$$00001"
		size = 519
		refs = "0034 __adjust_fdiv 0040 __safe_fdivr 0052 __rttospop 006f __rtonepop 0074 __rtindfpop 007e __infinity 00af __minfinity 0105 __rtzeronpop 010c __rtindfnpop 0164 _log2max 01b1 _half 01ed __powhlp 0202 __rttosnpopde"
	strings:
		$1 = { C6 85 70 FF FF FF FE 0A ED 75 4B D9 C9 D9 F1 EB 0D C6 85 70 FF FF FF FE 32 ED D9 EA DE C9 E8 3B 01 00 00 D9 E8 DE C1 F6 85 61 FF FF FF 01 74 14 D9 E8 83 3D ?? ?? ?? ?? 01 74 04 DE F1 EB 05 E8 ?? ?? ?? ?? F6 C2 40 75 02 D9 FD 0A ED 74 02 D9 E0 E9 ?? ?? ?? ?? E8 46 01 00 00 0B C0 74 14 32 ED 83 F8 02 74 02 F6 D5 D9 C9 D9 E1 EB 9F E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? DD D8 DD D8 DB 2D ?? ?? ?? ?? C6 85 70 FF FF FF 02 C3 D9 ED D9 C9 D9 E4 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 41 75 D2 D9 F1 C3 C6 85 70 FF FF FF 02 DD D8 DB 2D ?? ?? ?? ?? C3 0A C9 75 53 C3 D9 EC EB 02 D9 ED D9 C9 0A C9 75 AE D9 F1 C3 E9 ?? ?? ?? ?? E8 CF 00 00 00 DD D8 DD D8 0A C9 75 0E D9 EE 83 F8 01 75 06 0A ED 74 02 D9 E0 C3 C6 85 70 FF FF FF 02 DB 2D ?? ?? ?? ?? 83 F8 01 75 ED 0A ED 74 E9 D9 E0 EB E5 DD D8 E9 ?? ?? ?? ?? DD D8 E9 ?? ?? ?? ?? 58 D9 E4 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 01 75 0F DD D8 DB 2D ?? ?? ?? ?? 0A ED 74 02 D9 E0 C3 C6 85 70 FF FF FF 04 E9 ?? ?? ?? ?? DD D8 DD D8 DB 2D ?? ?? ?? ?? C6 85 70 FF FF FF 03 C3 0A C9 75 AF DD D8 DB 2D ?? ?? ?? ?? C3 D9 C0 D9 E1 DB 2D ?? ?? ?? ?? DE D9 9B DD BD 60 FF FF FF 9B F6 85 61 FF FF FF 41 75 95 D9 C0 D9 FC D9 E4 9B DD BD 60 FF FF FF 9B 8A 95 61 FF FF FF D9 C9 D8 E1 D9 E4 9B DD BD 60 FF FF FF D9 E1 D9 F0 C3 D9 C0 D9 FC D8 D9 9B DF E0 9E 75 1A D9 C0 DC 0D ?? ?? ?? ?? D9 C0 D9 FC DE D9 9B DF E0 9E 74 0D B8 01 00 00 00 C3 B8 00 00 00 00 EB F8 B8 02 00 00 00 EB F1 56 83 EC 74 8B F4 56 83 EC 08 DD 1C 24 83 EC 08 DD 1C 24 9B DD 76 08 E8 ?? ?? ?? ?? 83 C4 14 DD 66 08 DD 06 83 C4 74 5E 85 C0 74 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_686_0_0 {
	meta:
		name = "__filbuf"
		size = 222
		refs = "0035 __getbuf 004b __read 0077 ___pioinfo 0084 ___badioinfo"
	strings:
		$1 = { 56 8B 74 24 08 8B 46 0C A8 83 0F 84 C9 00 00 00 A8 40 0F 85 C1 00 00 00 A8 02 74 0B 83 C8 20 89 46 0C E9 B2 00 00 00 83 C8 01 66 A9 0C 01 89 46 0C 75 09 56 E8 ?? ?? ?? ?? 59 EB 05 8B 46 08 89 06 FF 76 18 FF 76 08 FF 76 10 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 89 46 04 74 6F 83 F8 FF 74 6A 8B 56 0C F6 C2 82 75 37 8B 4E 10 83 F9 FF 57 74 14 8B F9 C1 FF 05 8B 3C BD ?? ?? ?? ?? 83 E1 1F 8D 3C CF EB 05 BF ?? ?? ?? ?? 8A 4F 04 80 E1 82 80 F9 82 5F 75 09 81 CA 00 20 00 00 89 56 0C 81 7E 18 00 02 00 00 75 14 8B 4E 0C F6 C1 08 74 0C F6 C5 04 75 07 C7 46 18 00 10 00 00 8B 0E 48 89 46 04 0F B6 01 41 89 0E 5E C3 F7 D8 1B C0 83 E0 10 83 C0 10 09 46 0C 83 66 04 00 83 C8 FF 5E C3 }
	condition:
		$1
}

rule file_687_0_0 {
	meta:
		name = "_fgetpos"
		size = 34
		refs = "0005 __ftelli64"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? 59 8B 4C 24 08 89 51 04 8B D0 23 51 04 89 01 83 C8 FF 3B D0 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_689_0_0 {
	meta:
		name = "___loctotime_t"
		size = 270
		refs = "0035 __days 0065 ___tzset 00c4 __timezone 00e7 __daylight 00f3 __isindst 00fe __dstbias"
	strings:
		$1 = { 55 8B EC 83 EC 24 56 8B 75 08 81 EE 6C 07 00 00 83 FE 46 0F 8C EF 00 00 00 81 FE 8A 00 00 00 0F 8F E3 00 00 00 53 57 8B C6 6A 04 99 5B F7 FB 8B 4D 0C 8B 3C 8D ?? ?? ?? ?? 03 7D 10 85 D2 75 0C 8B C6 6A 64 99 5B F7 FB 85 D2 75 12 8D 86 6C 07 00 00 99 BB 90 01 00 00 F7 FB 85 D2 75 06 83 F9 02 7E 01 47 E8 ?? ?? ?? ?? 8D 86 2B 01 00 00 99 BB 90 01 00 00 F7 FB 8D 4E FF 6A 64 89 75 F0 89 7D F8 8B D8 8B C1 99 59 F7 F9 6A 04 59 2B D8 8D 46 FF 99 F7 F9 8B 55 18 89 55 E0 8B C8 8B C6 69 C0 6D 01 00 00 03 CF 03 CB 03 C1 8B 75 0C 8D 0C 40 8B 45 14 8D 1C C8 8B 4D 1C 6B DB 3C 03 DA 6B DB 3C 03 1D ?? ?? ?? ?? 4E 83 7D 20 01 8D 9C 0B 80 81 55 7C 89 75 EC 89 45 E4 89 4D DC 74 1D 83 7D 20 FF 75 1D 83 3D ?? ?? ?? ?? 00 74 14 8D 45 DC 50 E8 ?? ?? ?? ?? 85 C0 59 74 06 03 1D ?? ?? ?? ?? 5F 8B C3 5B EB 03 83 C8 FF 5E C9 C3 }
	condition:
		$1
}

rule file_690_1_0 {
	meta:
		name = "__floor_pentium4"
		size = 225
		refs = "000a _Bns 0023 _S 0076 ___libm_error_support 00a7 _One 00c1 _NegZero 00d2 _NegOne"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 F8 66 0F 73 D0 34 66 0F 7E C0 66 0F 54 05 ?? ?? ?? ?? 66 0F FA D0 66 0F D3 CA A9 00 08 00 00 75 4C 3D FF 03 00 00 7C 7D 66 0F F3 CA 3D 32 04 00 00 7F 0B 66 0F D6 4C 24 04 DD 44 24 04 C3 66 0F 2E FF 7B 24 BA ED 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 F3 0F 7E 44 24 04 66 0F F3 CA 66 0F 28 D8 66 0F C2 C1 01 3D FF 0B 00 00 7C 21 3D 32 0C 00 00 7F B0 66 0F 54 05 ?? ?? ?? ?? F2 0F 5C C8 66 0F D6 4C 24 04 DD 44 24 04 C3 D9 EE C3 66 0F C2 1D ?? ?? ?? ?? 01 66 0F 56 1D ?? ?? ?? ?? 66 0F 54 1D ?? ?? ?? ?? 66 0F D6 5C 24 04 DD 44 24 04 C3 }
	condition:
		$1
}

rule file_691_0_0 {
	meta:
		name = "__mbclen"
		size = 30
		refs = "0009 __mbctype"
	strings:
		$1 = { 8B 44 24 04 0F B6 08 F6 81 ?? ?? ?? ?? 04 74 0A 80 78 01 00 74 04 6A 02 58 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_693_0_0 {
	meta:
		name = "__AdjustLocation"
		size = 28
	strings:
		$1 = { 8B 44 24 04 85 C0 7C 13 83 F8 07 7F 0E 2B 44 24 08 78 05 83 F8 07 7E 03 6A 1F 58 C3 }
	condition:
		$1
}

rule file_693_1_0 {
	meta:
		name = "__IsMemoryLocation"
		size = 21
	strings:
		$1 = { 83 7C 24 04 0A 7C 0B 83 7C 24 04 10 7F 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_693_2_0 {
	meta:
		name = "__GetFpRegVal"
		size = 46
		refs = "001d __zero80"
	strings:
		$1 = { 8B 44 24 0C 85 C0 56 57 7C 12 83 F8 08 7D 0D 8B 4C 24 10 8D 04 80 8D 74 41 1C EB 05 BE ?? ?? ?? ?? 8B 44 24 0C 8B F8 A5 A5 66 A5 5F 5E C3 }
	condition:
		$1
}

rule file_693_3_0 {
	meta:
		name = "__SetTag"
		size = 32
	strings:
		$1 = { 8B 4C 24 08 8B 54 24 0C 03 C9 6A 03 58 D3 E0 D3 E2 8B 4C 24 04 23 D0 F7 D0 23 01 0B D0 89 11 C3 }
	condition:
		$1
}

rule file_693_4_0 {
	meta:
		name = "__FillOperand"
		size = 397
		refs = "0111 __GetFpRegVal 0153 __zero80"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 4D 10 56 33 D2 57 8B 7D 08 42 09 57 10 83 F9 0D 8B 47 10 0F 8F 0E 01 00 00 0F 84 F6 00 00 00 85 C9 0F 8C 5B 01 00 00 83 F9 07 0F 8E C8 00 00 00 83 F9 08 0F 84 01 01 00 00 83 F9 09 74 62 83 F9 0A 74 43 83 F9 0B 74 26 83 F9 0C 0F 85 31 01 00 00 83 E0 ED 0B C1 89 47 10 8B 45 0C 8B 40 14 8B 08 89 0F 8B 40 04 89 47 04 E9 14 01 00 00 83 E0 EB 83 C8 0A 89 47 10 8B 45 0C 8B 40 14 8B 00 89 07 E9 FC 00 00 00 83 E0 E9 83 C8 08 89 47 10 8B 45 0C 8B 40 14 66 8B 00 66 89 07 E9 E2 00 00 00 83 E0 F7 83 C8 16 89 47 10 8B 45 0C 8B 48 04 8B C1 C1 E8 03 25 A0 00 00 00 81 E1 00 01 00 00 0B C1 C1 E8 05 83 E8 00 74 28 48 74 1A 2D FF 00 00 00 74 0B C7 07 03 00 00 00 E9 A4 00 00 00 83 27 00 E9 9C 00 00 00 C7 07 02 00 00 00 E9 91 00 00 00 89 17 E9 8A 00 00 00 83 E0 E5 83 C8 04 51 FF 75 0C 89 47 10 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 3B 83 E0 E1 89 47 10 8B 45 0C 8B 40 14 D9 00 D9 1F EB 5B 83 E9 0E 74 43 49 74 2F 49 74 24 49 74 0D 83 E9 0E 75 48 83 E0 FE 89 47 10 EB 40 83 E0 E5 83 C8 04 89 47 10 BE ?? ?? ?? ?? A5 A5 66 A5 EB 2C 83 E0 F5 83 C8 14 EB 06 83 E0 E5 83 C8 04 89 47 10 8B 45 0C 8B 70 14 EB E1 83 E0 E3 83 C8 02 89 47 10 8B 45 0C 8B 40 14 DD 00 DD 1F 5F 5E C9 C3 }
	condition:
		$1
}

rule file_693_5_0 {
	meta:
		name = "__AdjustStack"
		size = 233
		refs = "0007 ___security_cookie 0033 __SetTag 006c _memcpy 0085 _memmove 00e3 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? 53 8B 5D 0C 85 DB 56 8B 75 08 89 45 FC 0F 8E 81 00 00 00 57 8D 7E 08 89 5D 08 8B 46 04 C1 E8 0B 6A 03 83 E0 07 50 57 E8 ?? ?? ?? ?? 8B 46 04 8B C8 81 E1 00 F8 FF FF 81 C1 00 08 00 00 33 C8 81 E1 00 38 00 00 33 C8 83 C4 0C FF 4D 08 89 4E 04 75 C8 8D 3C 9B D1 E7 8D 46 1C 57 50 8D 45 AC 50 E8 ?? ?? ?? ?? 6A 08 58 2B C3 8D 04 80 D1 E0 50 8D 44 37 1C 50 8D 46 1C 50 E8 ?? ?? ?? ?? 57 8D 45 AC 2B F7 50 83 C6 6C 56 E8 ?? ?? ?? ?? 83 C4 24 5F EB 3E 7D 3C 8B 4E 04 8B C1 C1 E8 0B 48 C1 E0 0B 33 C1 25 00 38 00 00 33 C1 89 46 04 C1 E8 0B 83 E0 07 6A 00 50 8D 46 08 50 E8 ?? ?? ?? ?? 8D 46 1C 6A 46 50 83 C6 26 56 E8 ?? ?? ?? ?? 83 C4 18 8B 4D FC 5E 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_693_6_0 {
	meta:
		name = "__PreventStackOverwrite"
		size = 61
		refs = "0008 __IsMemoryLocation"
	strings:
		$1 = { 55 8B EC 51 FF 75 0C E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 25 8B 4D 08 8B 81 C4 00 00 00 3B 41 30 76 17 54 58 89 45 FC 8B 41 30 83 C0 04 39 45 FC 77 07 C7 45 0C 1F 00 00 00 8B 45 0C C9 C3 }
	condition:
		$1
}

rule file_693_7_0 {
	meta:
		name = "__SetFpRegVal"
		size = 108
		refs = "0061 __SetTag"
	strings:
		$1 = { 8B 4C 24 08 85 C9 7C 63 83 F9 08 7D 5E 8B 54 24 0C 53 8B 5C 24 08 56 8D 04 89 57 8D 7C 43 1C 8B F2 A5 A5 66 A5 8B 43 04 C1 E8 0B 03 C1 33 C9 66 8B 4A 08 BE FF 7F 00 00 83 E0 07 23 CE 74 08 3B CE 74 14 33 C9 EB 13 83 3A 00 75 0B 83 7A 04 00 75 05 33 C9 41 EB 03 6A 02 59 51 50 83 C3 08 53 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_693_8_0 {
	meta:
		name = "__UpdateResult"
		size = 283
		refs = "00c0 __SetFpRegVal"
	strings:
		$1 = { 55 8B EC 8B 45 10 83 F8 0C 56 57 0F 8F CD 00 00 00 0F 84 B2 00 00 00 85 C0 0F 8C F8 00 00 00 83 F8 07 0F 8E 90 00 00 00 83 F8 09 74 34 83 F8 0A 74 1B 83 F8 0B 0F 85 DC 00 00 00 8B 45 08 8B 4D 0C 8B 40 14 8B 09 89 08 E9 CA 00 00 00 8B 45 08 8B 4D 0C 8B 40 14 66 8B 09 66 89 08 E9 B6 00 00 00 8B 45 0C 8B 00 83 E8 00 74 39 48 74 2D 48 74 13 48 0F 85 9F 00 00 00 8B 45 08 80 48 05 45 E9 93 00 00 00 8B 45 08 8B 48 04 81 E1 FF BB FF FF 81 C9 00 01 00 00 89 48 04 EB 7C 8B 45 08 80 60 05 BA EB 73 8B 45 08 8B 48 04 81 E1 FF FA FF FF 81 C9 00 40 00 00 EB DE FF 75 0C 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 4E 8B 45 08 8B 48 14 8B 45 0C 8B 10 89 11 8B 40 04 89 41 04 EB 39 83 E8 0D 74 27 48 74 15 48 74 03 48 75 2B 8B 45 08 8B 78 14 8B 75 0C A5 A5 66 A5 EB 1C 8B 45 08 8B 4D 0C 8B 40 14 DD 01 DD 18 EB 0D 8B 45 08 8B 4D 0C 8B 40 14 D9 01 D9 18 5F 5E 5D C3 }
	condition:
		$1
}

rule file_693_9_0 {
	meta:
		name = "__UpdateFpCtxt"
		size = 57
		refs = "0010 __AdjustStack 0020 __UpdateResult"
	strings:
		$1 = { 55 8B EC 56 8B 75 14 85 F6 7D 0B 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 F6 7E 0B 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 5E 5D C3 }
	condition:
		$1
}

rule file_693_10_0 {
	meta:
		name = "__fpieee_flt"
		size = 1546
		refs = "000d ___security_cookie 00e3 _instr_info_table 030b __IsMemoryLocation 0322 __FillOperand 032f __GetFpRegVal 03de __PreventStackOverwrite 03fa __UpdateFpCtxt 040f __AdjustLocation 049c __UpdateResult 05f0 _fpieee_flt_simd 05ff @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 E4 F0 81 EC B4 00 00 00 A1 ?? ?? ?? ?? 53 89 84 24 B4 00 00 00 8B 45 08 3D 8E 00 00 C0 56 57 B9 B4 02 00 C0 BA B5 02 00 C0 74 24 3D 8F 00 00 C0 74 1D 3D 90 00 00 C0 74 16 3D 91 00 00 C0 74 0F 3D 93 00 00 C0 74 08 3B C1 74 04 3B C2 75 4E DB E3 3B C1 0F 84 8B 05 00 00 3B C2 0F 84 83 05 00 00 8B 4D 0C 8B 01 8B 49 04 83 C0 14 8B 00 85 C0 89 4C 24 1C 8D 59 1C 74 17 50 FF 55 10 83 F8 FF 59 0F 85 6C 05 00 00 C6 43 04 00 E9 63 05 00 00 8B 43 0C 8A 08 80 E1 F8 80 F9 D8 74 07 33 C0 E9 4F 05 00 00 66 8B 00 66 89 44 24 0C 8B 4C 24 0C 8B 74 24 40 B8 00 C0 00 00 23 C8 2B C8 8B 44 24 0C F7 D9 1B C9 83 E0 07 D1 E0 41 0B C8 8B 44 24 0C C1 E8 0B 83 E0 07 C1 E1 03 0B C8 8D 04 8D ?? ?? ?? ?? 89 44 24 18 8B 00 C1 E0 05 33 C6 25 E0 FF 01 00 33 F0 89 74 24 40 8B 03 8B 4B 04 8B D0 BF 00 0C 00 00 23 D7 74 29 81 FA 00 04 00 00 74 19 81 FA 00 08 00 00 74 09 3B D7 75 1C 83 CE 03 EB 13 83 E6 FE 83 CE 02 EB 0B 83 E6 FD 83 CE 01 EB 03 83 E6 FC 89 74 24 40 8B D0 BF 00 03 00 00 23 D7 74 19 81 FA 00 02 00 00 74 09 3B D7 75 17 83 E6 E3 EB 0E 83 E6 E7 83 CE 04 EB 06 83 E6 EB 83 CE 08 89 74 24 40 8B D0 C1 E2 04 8B F0 F7 D2 83 E2 10 C1 EE 05 F7 D6 33 FF 47 23 F7 0B D6 8D 34 00 F7 D6 83 E6 08 0B D6 8B F0 C1 E8 03 F7 D0 83 E0 02 D1 EE F7 D6 83 E6 04 0B D6 0B D0 8B 44 24 48 83 E0 E0 0B D0 89 54 24 48 8B C1 C1 E8 02 8B D1 83 E2 10 6A 08 5E 23 C6 0B C2 8B D1 23 D6 C1 E8 02 0B C2 8B D1 23 D7 C1 E2 03 83 E1 04 0B D1 8B 4C 24 4C D1 E8 D1 E2 0B C2 8A 54 24 48 83 E1 E0 0B C1 F6 C2 01 89 44 24 4C 74 08 A8 01 74 04 8B C7 EB 02 33 C0 8B 4C 24 44 33 C1 23 C7 33 C8 F6 C2 02 74 0B F6 44 24 4C 02 74 04 8B C7 EB 02 33 C0 03 C0 33 C1 83 E0 02 33 C8 F6 C2 04 74 0B F6 44 24 4C 04 74 04 8B C7 EB 02 33 C0 C1 E0 02 33 C1 83 E0 04 33 C8 F6 C2 08 74 0B F6 44 24 4C 08 74 04 8B C7 EB 02 33 C0 C1 E0 03 33 C1 23 C6 33 C8 F6 C2 10 74 0B F6 44 24 4C 10 74 04 8B C7 EB 02 33 C0 8B 7C 24 0C C1 E0 04 33 C1 83 E0 10 33 C8 8B 44 24 18 89 4C 24 44 8B 08 8B C1 C1 E8 0C 83 E0 1F 3B C6 75 0A 8B D7 C1 EA 08 83 E2 07 EB 02 8B D0 8B C1 C1 E8 11 83 E0 1F 3B C6 75 0A 8B F7 C1 EE 08 83 E6 07 EB 02 8B F0 8B C1 C1 E8 16 83 E0 1F 83 F8 08 75 0C C1 EF 08 83 E7 07 89 7C 24 0C EB 04 89 44 24 0C 8B 7D 08 81 FF 8E 00 00 C0 0F 84 CB 01 00 00 81 FF 8F 00 00 C0 0F 84 1D 01 00 00 81 FF 90 00 00 C0 0F 84 B3 01 00 00 81 FF 91 00 00 C0 74 0C 81 FF 93 00 00 C0 0F 85 18 02 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 EC 00 00 00 52 8D 44 24 54 53 50 E8 ?? ?? ?? ?? 6A 00 8D 44 24 30 53 50 E8 ?? ?? ?? ?? 8B F0 8B 84 24 B8 00 00 00 8D 7C 24 4C A5 A5 83 C4 18 83 C8 01 83 7C 24 0C 0D 66 A5 75 0D 83 E0 E1 C7 44 24 10 C0 00 00 00 EB 0E 83 E0 E3 83 C8 02 C7 44 24 10 00 06 00 00 81 7D 08 91 00 00 C0 89 84 24 A0 00 00 00 75 04 F7 5C 24 10 DB 44 24 10 DB 6C 24 34 D9 FD DD D9 DB 7C 24 34 83 7C 24 0C 0D 75 15 DB 6C 24 34 D9 5C 24 10 D9 44 24 10 D9 9C 24 90 00 00 00 EB 13 DB 6C 24 34 DD 5C 24 10 DD 44 24 10 DD 9C 24 90 00 00 00 DB E2 8D 44 24 40 50 FF 55 10 8B F8 83 FF FF 59 0F 85 0F 02 00 00 FF 74 24 0C FF 74 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 8B 09 C1 E1 02 C1 F9 1D 51 50 8D 84 24 A0 00 00 00 50 53 E8 ?? ?? ?? ?? 83 C4 18 E9 28 01 00 00 C1 E1 02 C1 F9 1D 51 52 E8 ?? ?? ?? ?? 51 56 8B F8 E8 ?? ?? ?? ?? 51 FF 74 24 20 89 44 24 28 E8 ?? ?? ?? ?? 8B F0 83 C4 18 3B FE 75 03 6A 1F 5F 39 74 24 10 75 08 C7 44 24 10 1F 00 00 00 56 8D 84 24 94 00 00 00 53 50 E8 ?? ?? ?? ?? 57 8D 44 24 60 53 50 E8 ?? ?? ?? ?? FF 74 24 28 8D 84 24 8C 00 00 00 53 50 E8 ?? ?? ?? ?? 8D 44 24 64 50 FF 55 10 8B F8 83 C4 28 83 FF FF 0F 85 5D 01 00 00 56 FF 74 24 20 E8 ?? ?? ?? ?? 50 8D 84 24 9C 00 00 00 50 53 E8 ?? ?? ?? ?? 83 C4 14 E9 86 00 00 00 52 8D 44 24 54 53 50 E8 ?? ?? ?? ?? 56 8D 84 24 80 00 00 00 53 50 E8 ?? ?? ?? ?? FF 74 24 24 8D 84 24 AC 00 00 00 53 50 E8 ?? ?? ?? ?? 83 A4 24 C4 00 00 00 FE 8D 44 24 64 50 FF 55 10 8B F8 83 C4 28 83 FF FF 0F 85 F1 00 00 00 FF 74 24 0C FF 74 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 8B 09 C1 E1 02 C1 F9 1D 51 50 8D 84 24 A0 00 00 00 50 53 E8 ?? ?? ?? ?? 83 C4 18 EB 04 8B 7C 24 18 83 FF FF 0F 85 B6 00 00 00 8B 0B C6 43 04 00 8B 54 24 40 8B C2 83 E0 03 83 E8 00 74 2D 48 74 1C 48 74 0B 48 75 2A 81 C9 00 0C 00 00 EB 22 81 E1 FF FB FF FF 81 C9 00 08 00 00 EB 14 81 E1 FF F7 FF FF 81 C9 00 04 00 00 EB 06 81 E1 FF F3 FF FF C1 EA 02 83 E2 07 83 EA 00 74 1C 4A 74 0B 4A 75 1C 81 E1 FF FC FF FF EB 14 81 E1 FF FE FF FF 81 C9 00 02 00 00 EB 06 81 C9 00 03 00 00 8A 44 24 48 A8 01 74 05 83 E1 DF EB 03 83 C9 20 A8 02 74 05 83 E1 EF EB 03 83 C9 10 A8 04 74 05 83 E1 F7 EB 03 83 C9 08 A8 08 74 05 83 E1 FB EB 03 83 C9 04 A8 10 74 05 83 E1 FE EB 03 83 C9 01 89 0B 8B C7 EB 0F FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8C 24 BC 00 00 00 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_696_1_0 {
	meta:
		name = "__inc"
		size = 22
		refs = "0010 __filbuf"
	strings:
		$1 = { FF 4A 04 78 09 8B 0A 0F B6 01 41 89 0A C3 52 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_696_3_0 {
	meta:
		name = "__whiteout"
		size = 29
		refs = "0008 __inc 0010 _isspace"
	strings:
		$1 = { 57 8B 54 24 08 FF 06 E8 ?? ?? ?? ?? 8B F8 57 E8 ?? ?? ?? ?? 85 C0 59 75 E8 8B C7 5F C3 }
	condition:
		$1
}

rule file_696_4_0 {
	meta:
		name = "__input"
		size = 3687
		refs = "0006 $T20875 000b __SEH_prolog 0010 ___security_cookie 0055 ___mb_cur_max 0060 __isctype 006a __pctype 008b __inc 0093 _isspace 00a6 _ungetc 0422 ___decimal_point 05b7 __cfltcvt_tab 068f __alloca_probe 06ac __resetstkoflw 06b3 _malloc 06eb _memset 08a4 _mbtowc 0aed __allmul 0b44 __hextodec 0e30 _free 0e5d @__security_check_cookie@4 0e62 __SEH_epilog"
	strings:
		$1 = { 68 CC 01 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 E4 33 C0 89 85 44 FE FF FF 89 85 28 FE FF FF 89 85 50 FE FF FF 89 85 6C FE FF FF 88 85 6B FE FF FF 89 85 7C FE FF FF 89 85 48 FE FF FF 8B 75 0C 8A 06 84 C0 0F 84 D0 0D 00 00 0F B6 C0 83 3D ?? ?? ?? ?? 01 7E 0C 6A 08 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 08 33 FF 3B C7 74 47 FF 8D 7C FE FF FF FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 85 C0 75 E5 83 FE FF 74 0B FF 75 08 56 E8 ?? ?? ?? ?? 59 59 FF 45 0C 8B 45 0C 0F B6 00 50 E8 ?? ?? ?? ?? 59 85 C0 75 EC EB 81 8B 75 0C 80 3E 25 0F 85 BC 0C 00 00 89 BD 60 FE FF FF C6 85 68 FE FF FF 00 89 BD 64 FE FF FF 89 BD 4C FE FF FF 89 BD 74 FE FF FF C6 85 5F FE FF FF 00 C6 85 69 FE FF FF 00 C6 85 72 FE FF FF 00 C6 85 83 FE FF FF 00 C6 85 6A FE FF FF 00 C6 85 7B FE FF FF 00 C6 85 73 FE FF FF 01 89 BD 38 FE FF FF 46 0F B6 1E 0F B6 C3 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 50 E8 ?? ?? ?? ?? 59 59 EB 0D 8B 0D ?? ?? ?? ?? 0F B6 04 41 83 E0 04 85 C0 74 12 FF 85 4C FE FF FF 8D 04 BF 8D 7C 43 D0 E9 BF 00 00 00 83 FB 4E 0F 8F 85 00 00 00 0F 84 B0 00 00 00 83 FB 2A 74 72 83 FB 46 0F 84 A2 00 00 00 83 FB 49 74 10 83 FB 4C 75 76 FE 85 73 FE FF FF E9 8D 00 00 00 8A 4E 01 80 F9 36 75 20 8D 46 02 80 38 34 75 18 8B F0 FF 85 38 FE FF FF 83 A5 54 FE FF FF 00 83 A5 58 FE FF FF 00 EB 65 80 F9 33 75 0C 8D 46 02 80 38 32 75 04 8B F0 EB 54 80 F9 64 74 4F 80 F9 69 74 4A 80 F9 6F 74 45 80 F9 78 74 40 80 F9 58 75 19 EB 39 FE 85 72 FE FF FF EB 31 83 FB 68 74 20 83 FB 6C 74 0D 83 FB 77 74 0E FE 85 83 FE FF FF EB 1A FE 85 73 FE FF FF FE 85 7B FE FF FF EB 0C FE 8D 73 FE FF FF FE 8D 7B FE FF FF 80 BD 83 FE FF FF 00 0F 84 F5 FE FF FF 89 BD 74 FE FF FF 89 75 0C 80 BD 72 FE FF FF 00 75 1A 8B 45 10 89 85 24 FE FF FF 83 C0 04 89 45 10 8B 58 FC 89 9D 50 FE FF FF EB 06 8B 9D 50 FE FF FF C6 85 83 FE FF FF 00 80 BD 7B FE FF FF 00 75 18 8A 06 3C 53 74 0B 3C 43 C6 85 7B FE FF FF FF 75 07 C6 85 7B FE FF FF 01 0F B6 3E 83 CF 20 89 BD 40 FE FF FF 83 FF 6E 74 44 83 FF 63 74 2B 83 FF 7B 74 26 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 85 C0 75 E5 89 B5 6C FE FF FF 8B 75 0C EB 14 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 89 85 6C FE FF FF 8B 8D 4C FE FF FF 85 C9 74 0D 83 BD 74 FE FF FF 00 0F 84 2C 03 00 00 83 FF 6F 0F 8F F2 02 00 00 0F 84 0F 07 00 00 83 FF 63 0F 84 B6 02 00 00 83 FF 64 0F 84 FD 06 00 00 0F 8E FA 02 00 00 83 FF 67 7E 44 83 FF 69 74 21 83 FF 6E 0F 85 E7 02 00 00 8B 85 7C FE FF FF 80 BD 72 FE FF FF 00 0F 84 0E 0A 00 00 E9 35 0A 00 00 6A 64 5F 8B 9D 6C FE FF FF 83 FB 2D 0F 85 63 05 00 00 C6 85 69 FE FF FF 01 E9 5C 05 00 00 8D B5 84 FE FF FF 8B 9D 6C FE FF FF 83 FB 2D 75 0E 88 9D 84 FE FF FF 8D B5 85 FE FF FF EB 05 83 FB 2B 75 20 FF 8D 74 FE FF FF FF 85 7C FE FF FF 8B 7D 08 8B D7 E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF EB 03 8B 7D 08 83 BD 4C FE FF FF 00 74 0C 81 BD 74 FE FF FF 5D 01 00 00 7E 0A C7 85 74 FE FF FF 5D 01 00 00 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 53 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 58 83 E0 04 85 C0 74 30 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 74 20 FF 85 64 FE FF FF 88 1E 46 FF 85 7C FE FF FF 8B D7 E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF EB AB 38 1D ?? ?? ?? ?? 75 7C 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 74 6C FF 85 7C FE FF FF 8B D7 E8 ?? ?? ?? ?? 8B D8 A0 ?? ?? ?? ?? 88 06 46 89 9D 6C FE FF FF 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 53 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 58 83 E0 04 85 C0 74 2A 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 74 1A FF 85 64 FE FF FF 88 1E 46 FF 85 7C FE FF FF 8B D7 E8 ?? ?? ?? ?? 8B D8 EB AB 83 BD 64 FE FF FF 00 0F 84 B7 00 00 00 83 FB 65 74 09 83 FB 45 0F 85 A9 00 00 00 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 0F 84 95 00 00 00 C6 06 65 46 FF 85 7C FE FF FF 8B D7 E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 FB 2D 75 05 88 06 46 EB 05 83 FB 2B 75 2D 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 75 08 21 85 74 FE FF FF EB 15 8B D7 FF 85 7C FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 53 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 58 83 E0 04 85 C0 74 1B 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 74 0B FF 85 64 FE FF FF 88 1E 46 EB AB FF 8D 7C FE FF FF 83 FB FF 74 09 57 53 E8 ?? ?? ?? ?? 59 59 83 BD 64 FE FF FF 00 0F 84 97 08 00 00 80 BD 72 FE FF FF 00 0F 85 E6 07 00 00 FF 85 48 FE FF FF C6 06 00 8D 85 84 FE FF FF 50 FF B5 50 FE FF FF 0F BE 85 73 FE FF FF 48 50 FF 15 ?? ?? ?? ?? 83 C4 0C E9 B9 07 00 00 85 C9 75 10 C7 85 4C FE FF FF 01 00 00 00 FF 85 74 FE FF FF 80 BD 7B FE FF FF 00 0F 8E BA 01 00 00 C6 85 6A FE FF FF 01 E9 AE 01 00 00 8B C7 83 E8 70 0F 84 11 04 00 00 83 E8 03 74 D7 48 48 0F 84 0B 04 00 00 83 E8 03 0F 84 39 FD FF FF 83 E8 03 74 38 0F B6 06 3B 85 6C FE FF FF 74 0C 83 BD 6C FE FF FF FF E9 BA 07 00 00 FE 8D 6B FE FF FF 80 BD 72 FE FF FF 00 0F 85 3C 07 00 00 8B 85 24 FE FF FF 89 45 10 E9 2E 07 00 00 80 BD 7B FE FF FF 00 7E 07 C6 85 6A FE FF FF 01 8B 7D 0C 47 89 7D 0C 89 BD 30 FE FF FF 80 3F 5E 75 0E 47 89 BD 30 FE FF FF C6 85 5F FE FF FF FF 8B 9D 44 FE FF FF 85 DB 75 5D 21 5D FC 6A 20 58 E8 ?? ?? ?? ?? 89 65 E8 8B DC 89 9D 44 FE FF FF 83 4D FC FF EB 41 33 C0 40 C3 8B 65 E8 E8 ?? ?? ?? ?? 6A 20 E8 ?? ?? ?? ?? 59 89 85 44 FE FF FF 85 C0 75 09 83 4D FC FF E9 55 07 00 00 C7 85 28 FE FF FF 01 00 00 00 83 4D FC FF 8B BD 30 FE FF FF 8B 9D 44 FE FF FF 6A 20 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 83 BD 40 FE FF FF 7B 75 77 80 3F 5D 75 72 B2 5D 47 C6 43 0B 20 EB 6F 47 3C 2D 75 4B 84 D2 74 47 8A 0F 80 F9 5D 74 40 47 3A D1 73 04 8A C1 EB 04 8A C2 8A D1 3A D0 77 2B 0F B6 F2 2A C2 FE C0 0F B6 C0 89 85 2C FE FF FF 8B C6 C1 E8 03 03 C3 8B CE 83 E1 07 B2 01 D2 E2 08 10 46 FF 8D 2C FE FF FF 75 E5 32 D2 EB 1F 88 85 68 FE FF FF 0F B6 C8 8B C1 C1 E8 03 03 C3 83 E1 07 B2 01 D2 E2 08 10 8A 95 68 FE FF FF 8A 07 3C 5D 75 8B 84 C0 0F 84 9A 06 00 00 8B 9D 50 FE FF FF 83 BD 40 FE FF FF 7B 75 03 89 7D 0C 8B BD 40 FE FF FF 8B F3 FF 8D 7C FE FF FF 83 BD 6C FE FF FF FF 74 10 FF 75 08 FF B5 6C FE FF FF E8 ?? ?? ?? ?? 59 59 83 BD 4C FE FF FF 00 74 14 8B 85 74 FE FF FF FF 8D 74 FE FF FF 85 C0 0F 84 E8 01 00 00 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 89 85 6C FE FF FF 83 F8 FF 0F 84 B5 01 00 00 83 FF 63 74 4D 83 FF 73 75 0F 83 F8 09 7C 05 83 F8 0D 7E 05 83 F8 20 75 39 83 FF 7B 0F 85 93 01 00 00 8B C8 83 E1 07 33 D2 42 D3 E2 8B C8 C1 F9 03 8B BD 44 FE FF FF 0F BE 0C 39 0F BE BD 5F FE FF FF 33 CF 85 D1 0F 84 69 01 00 00 8B BD 40 FE FF FF 80 BD 72 FE FF FF 00 0F 85 50 01 00 00 80 BD 6A FE FF FF 00 0F 84 35 01 00 00 88 85 3C FE FF FF 0F B6 C0 8B 0D ?? ?? ?? ?? F6 44 41 01 80 74 14 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 88 85 3D FE FF FF FF 35 ?? ?? ?? ?? 8D 85 3C FE FF FF 50 8D 85 34 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 66 8B 85 34 FE FF FF 66 89 03 43 43 E9 E1 00 00 00 83 FB 2B 75 2B FF 8D 74 FE FF FF 75 0D 85 C9 74 09 C6 85 83 FE FF FF 01 EB 16 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 FB 30 0F 85 62 01 00 00 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 80 FB 78 74 51 80 FB 58 74 4C C7 85 64 FE FF FF 01 00 00 00 83 FF 78 74 1F 83 BD 4C FE FF FF 00 74 0E FF 8D 74 FE FF FF 75 06 FE 85 83 FE FF FF 6A 6F 5F E9 14 01 00 00 FF 8D 7C FE FF FF 83 FB FF 74 0B FF 75 08 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 F0 00 00 00 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 BD 4C FE FF FF 00 74 16 83 AD 74 FE FF FF 02 83 BD 74 FE FF FF 01 7D 06 FE 85 83 FE FF FF 6A 78 EB A3 88 03 43 89 9D 50 FE FF FF E9 17 FE FF FF 46 E9 11 FE FF FF FF 8D 7C FE FF FF 83 F8 FF 74 0B FF 75 08 50 E8 ?? ?? ?? ?? 59 59 3B F3 0F 84 54 04 00 00 80 BD 72 FE FF FF 00 0F 85 A3 03 00 00 FF 85 48 FE FF FF 83 BD 40 FE FF FF 63 0F 84 90 03 00 00 8B 85 50 FE FF FF 80 BD 6A FE FF FF 00 74 09 66 83 20 00 E9 78 03 00 00 C6 00 00 E9 70 03 00 00 C6 85 73 FE FF FF 01 8B 9D 6C FE FF FF 83 FB 2D 75 09 C6 85 69 FE FF FF 01 EB 05 83 FB 2B 75 2B FF 8D 74 FE FF FF 75 0D 85 C9 74 09 C6 85 83 FE FF FF 01 EB 16 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 BD 38 FE FF FF 00 0F 84 93 01 00 00 80 BD 83 FE FF FF 00 0F 85 55 01 00 00 BE 80 00 00 00 83 FF 78 0F 84 80 00 00 00 83 FF 70 74 7B 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 53 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 58 83 E0 04 85 C0 0F 84 9F 00 00 00 83 FF 6F 75 2A 83 FB 38 0F 8D 91 00 00 00 8B 85 54 FE FF FF 8B 8D 58 FE FF FF 0F A4 C1 03 C1 E0 03 89 85 54 FE FF FF 89 8D 58 FE FF FF EB 76 6A 00 6A 0A FF B5 58 FE FF FF FF B5 54 FE FF FF E8 ?? ?? ?? ?? 89 85 54 FE FF FF 89 95 58 FE FF FF EB 53 83 3D ?? ?? ?? ?? 01 7E 0B 56 53 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B6 04 58 23 C6 85 C0 74 2A 8B 85 54 FE FF FF 8B 8D 58 FE FF FF 0F A4 C1 04 C1 E0 04 89 85 54 FE FF FF 89 8D 58 FE FF FF 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 06 FE 85 83 FE FF FF 80 BD 83 FE FF FF 00 75 42 FF 85 64 FE FF FF 8D 43 D0 99 01 85 54 FE FF FF 11 95 58 FE FF FF 83 BD 4C FE FF FF 00 74 11 FF 8D 74 FE FF FF 75 09 C6 85 83 FE FF FF 01 EB 28 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B D8 EB 16 FF 8D 7C FE FF FF 83 FB FF 74 0B FF 75 08 53 E8 ?? ?? ?? ?? 59 59 80 BD 83 FE FF FF 00 0F 84 B6 FE FF FF 89 9D 6C FE FF FF 80 BD 69 FE FF FF 00 0F 84 49 01 00 00 8B 85 54 FE FF FF F7 D8 8B 8D 58 FE FF FF 83 D1 00 F7 D9 89 85 54 FE FF FF 89 8D 58 FE FF FF E9 25 01 00 00 80 BD 83 FE FF FF 00 0F 85 09 01 00 00 BE 80 00 00 00 83 FF 78 74 50 83 FF 70 74 4B 83 3D ?? ?? ?? ?? 01 7E 0C 6A 04 53 E8 ?? ?? ?? ?? 59 59 EB 0C A1 ?? ?? ?? ?? 0F B6 04 58 83 E0 04 85 C0 74 5B 83 FF 6F 75 0E 83 FB 38 7D 51 C1 A5 60 FE FF FF 03 EB 4E 8B 85 60 FE FF FF 8D 04 80 D1 E0 89 85 60 FE FF FF EB 3B 83 3D ?? ?? ?? ?? 01 7E 0B 56 53 E8 ?? ?? ?? ?? 59 59 EB 0B A1 ?? ?? ?? ?? 0F B6 04 58 23 C6 85 C0 74 12 C1 A5 60 FE FF FF 04 8B C3 E8 ?? ?? ?? ?? 8B D8 EB 06 FE 85 83 FE FF FF 80 BD 83 FE FF FF 00 75 42 FF 85 64 FE FF FF 8B 85 60 FE FF FF 8D 44 18 D0 89 85 60 FE FF FF 83 BD 4C FE FF FF 00 74 11 FF 8D 74 FE FF FF 75 09 C6 85 83 FE FF FF 01 EB 28 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B D8 EB 16 FF 8D 7C FE FF FF 83 FB FF 74 0B FF 75 08 53 E8 ?? ?? ?? ?? 59 59 80 BD 83 FE FF FF 00 0F 84 02 FF FF FF 89 9D 6C FE FF FF 80 BD 69 FE FF FF 00 74 06 F7 9D 60 FE FF FF 83 FF 46 75 07 83 A5 64 FE FF FF 00 83 BD 64 FE FF FF 00 0F 84 EB 00 00 00 80 BD 72 FE FF FF 00 75 3E FF 85 48 FE FF FF 8B 9D 50 FE FF FF 8B 85 60 FE FF FF 83 BD 38 FE FF FF 00 74 13 8B 85 54 FE FF FF 89 03 8B 85 58 FE FF FF 89 43 04 EB 10 80 BD 73 FE FF FF 00 74 04 89 03 EB 03 66 89 03 FE 85 6B FE FF FF FF 45 0C 8B 75 0C EB 77 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 0F B6 06 46 89 75 0C 3B C3 75 39 0F B6 C3 8B 0D ?? ?? ?? ?? F6 44 41 01 80 74 46 FF 85 7C FE FF FF 8B 55 08 E8 ?? ?? ?? ?? 0F B6 0E 46 89 75 0C 3B C8 74 27 83 F8 FF 74 0B FF 75 08 50 E8 ?? ?? ?? ?? 59 59 83 FB FF 74 37 FF 75 08 FF B5 6C FE FF FF E8 ?? ?? ?? ?? 59 59 EB 25 FF 8D 7C FE FF FF 83 BD 6C FE FF FF FF 0F 85 38 F2 FF FF 80 3E 25 75 0D 8B 45 0C 80 78 01 6E 0F 84 23 F2 FF FF 83 BD 28 FE FF FF 01 75 0C FF B5 44 FE FF FF E8 ?? ?? ?? ?? 59 8B 85 48 FE FF FF 83 BD 6C FE FF FF FF 75 0F 85 C0 75 0B 38 85 6B FE FF FF 75 03 83 C8 FF 8D A5 18 FE FF FF 8B 4D E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_699_0_0 {
	meta:
		name = "__mbsnbicmp"
		size = 395
		refs = "0012 ___ismbcodepage 0022 __strnicmp 0032 ___mbulinfo 004a __mbctype 00d0 __mbcasemap"
	strings:
		$1 = { 55 8B EC 51 51 33 D2 39 55 10 75 04 33 C0 C9 C3 39 15 ?? ?? ?? ?? 75 13 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 8B 4D 08 56 66 8B 35 ?? ?? ?? ?? 57 8B 7D 0C 66 0F B6 01 FF 4D 10 41 89 45 F8 0F B6 C0 F6 80 ?? ?? ?? ?? 04 74 6E 39 55 10 75 19 0F B6 07 F6 80 ?? ?? ?? ?? 04 89 55 F8 0F 84 F1 00 00 00 33 C0 5F 5E C9 C3 8A 01 3A C2 75 05 89 55 F8 EB 5D 33 D2 8A 75 F8 41 8A D0 66 8B C2 66 3B C6 89 55 F8 72 13 66 3B 05 ?? ?? ?? ?? 77 0A A1 ?? ?? ?? ?? 01 45 F8 EB 37 66 3B 05 ?? ?? ?? ?? 72 2E 66 3B 05 ?? ?? ?? ?? 77 25 66 03 05 ?? ?? ?? ?? 66 89 45 F8 EB 18 0F B7 45 F8 F6 80 ?? ?? ?? ?? 10 74 08 66 0F B6 80 ?? ?? ?? ?? 89 45 F8 66 0F B6 07 47 89 45 FC 0F B6 C0 F6 80 ?? ?? ?? ?? 04 74 5A 33 D2 39 55 10 74 09 8A 07 FF 4D 10 3A C2 75 05 89 55 FC EB 5D 33 D2 8A 75 FC 47 8A D0 66 8B C2 66 3B C6 89 55 FC 72 13 66 3B 05 ?? ?? ?? ?? 77 0A A1 ?? ?? ?? ?? 01 45 FC EB 37 66 3B 05 ?? ?? ?? ?? 72 2E 66 3B 05 ?? ?? ?? ?? 77 25 66 03 05 ?? ?? ?? ?? 66 89 45 FC EB 18 0F B7 45 FC F6 80 ?? ?? ?? ?? 10 74 08 66 0F B6 80 ?? ?? ?? ?? 89 45 FC 66 8B 45 F8 66 39 45 FC 75 19 33 D2 66 3B C2 0F 84 F7 FE FF FF 39 55 10 0F 85 BF FE FF FF E9 E9 FE FF FF 1B C0 83 E0 02 48 E9 E0 FE FF FF }
	condition:
		$1
}

rule file_701_0_0 {
	meta:
		name = "___ascii_stricmp"
		size = 78
	strings:
		$1 = { 55 8B EC 57 56 53 8B 75 0C 8B 7D 08 B0 FF 8B FF 0A C0 74 32 8A 06 83 C6 01 8A 27 83 C7 01 38 C4 74 EE 2C 41 3C 1A 1A C9 80 E1 20 02 C1 04 41 86 E0 2C 41 3C 1A 1A C9 80 E1 20 02 C1 04 41 38 E0 74 CE 1A C0 1C FF 0F BE C0 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_703_0_0 {
	meta:
		name = "__findfirsti64"
		size = 247
		refs = "000f ___security_cookie 0026 __imp__FindFirstFileA@8 0033 __imp__GetLastError@0 004f _errno 0091 ___timet_from_ft 00bd __allmul 00d9 _strcpy 00eb @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 3C FF FF FF 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 89 85 C0 00 00 00 57 8D 45 80 50 FF B5 CC 00 00 00 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 42 FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 28 83 F8 08 74 17 83 F8 12 74 1E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 84 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EC 89 0D ?? ?? ?? ?? EB E4 8B 45 80 2D 80 00 00 00 F7 D8 1B C0 23 45 80 53 56 8B B5 D0 00 00 00 89 06 8D 45 84 50 E8 ?? ?? ?? ?? 89 46 04 8D 45 8C 50 E8 ?? ?? ?? ?? 89 46 08 8D 45 94 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 6A 00 6A 00 FF 75 9C 89 46 0C E8 ?? ?? ?? ?? 8B 4D A0 33 DB 03 C1 13 D3 89 46 10 8D 45 AC 89 56 14 50 83 C6 18 56 E8 ?? ?? ?? ?? 59 59 5E 8B C7 5B 8B 8D C0 00 00 00 5F E8 ?? ?? ?? ?? 81 C5 C4 00 00 00 C9 C3 }
	condition:
		$1
}

rule file_703_1_0 {
	meta:
		name = "__findnexti64"
		size = 242
		refs = "000f ___security_cookie 0025 __imp__FindNextFileA@8 002f __imp__GetLastError@0 004b _errno 008d ___timet_from_ft 00b9 __allmul 00d5 _strcpy 00e6 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 3C FF FF FF 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 89 85 C0 00 00 00 8D 45 80 50 FF B5 CC 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 42 FF 15 ?? ?? ?? ?? 6A 02 59 3B C1 72 0F 83 F8 03 76 28 83 F8 08 74 17 83 F8 12 74 1E C7 05 ?? ?? ?? ?? 16 00 00 00 83 C8 FF E9 84 00 00 00 C7 05 ?? ?? ?? ?? 0C 00 00 00 EB EC 89 0D ?? ?? ?? ?? EB E4 8B 45 80 2D 80 00 00 00 F7 D8 1B C0 23 45 80 56 8B B5 D0 00 00 00 89 06 8D 45 84 57 50 E8 ?? ?? ?? ?? 89 46 04 8D 45 8C 50 E8 ?? ?? ?? ?? 89 46 08 8D 45 94 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 6A 00 6A 00 FF 75 9C 89 46 0C E8 ?? ?? ?? ?? 8B 4D A0 33 FF 03 C1 13 D7 89 46 10 8D 45 AC 89 56 14 50 83 C6 18 56 E8 ?? ?? ?? ?? 59 59 5F 33 C0 5E 8B 8D C0 00 00 00 E8 ?? ?? ?? ?? 81 C5 C4 00 00 00 C9 C3 }
	condition:
		$1
}

rule file_704_0_0 {
	meta:
		name = "__freebuf"
		size = 43
		refs = "0014 _free"
	strings:
		$1 = { 56 8B 74 24 08 8B 46 0C A8 83 74 1D A8 08 74 19 FF 76 08 E8 ?? ?? ?? ?? 66 81 66 0C F7 FB 33 C0 59 89 06 89 46 08 89 46 04 5E C3 }
	condition:
		$1
}

rule file_706_0_0 {
	meta:
		name = "_rewind"
		size = 85
		refs = "000b __flush 0021 ___pioinfo 0030 ___badioinfo 004b __lseek"
	strings:
		$1 = { 56 8B 74 24 08 57 8B 7E 10 56 E8 ?? ?? ?? ?? 83 66 0C CF 83 FF FF 59 74 16 8B C7 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B CF 83 E1 1F 8D 04 C8 EB 05 B8 ?? ?? ?? ?? 80 60 04 FD 8B 46 0C 84 C0 79 06 83 E0 FC 89 46 0C 6A 00 6A 00 57 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C3 }
	condition:
		$1
}

rule file_708_0_0 {
	meta:
		name = "__eof"
		size = 152
		refs = "000b __nhandle 0019 ___pioinfo 0033 __lseeki64 0083 __doserrno 008a _errno"
	strings:
		$1 = { 55 8B EC 51 51 57 8B 7D 08 3B 3D ?? ?? ?? ?? 73 70 8B C7 C1 F8 05 8B 04 85 ?? ?? ?? ?? 8B CF 83 E1 1F F6 44 C8 04 01 74 58 53 56 6A 01 33 F6 56 56 57 E8 ?? ?? ?? ?? 8B D8 23 C2 83 C4 10 83 F8 FF 89 55 FC 74 32 6A 02 56 56 57 E8 ?? ?? ?? ?? 8B C8 23 CA 83 C4 10 83 F9 FF 74 1C 3B D8 75 08 39 55 FC 75 03 46 EB 13 56 FF 75 FC 53 57 E8 ?? ?? ?? ?? 83 C4 10 EB 03 83 CE FF 8B C6 5E 5B EB 14 83 25 ?? ?? ?? ?? 00 C7 05 ?? ?? ?? ?? 09 00 00 00 83 C8 FF 5F C9 C3 }
	condition:
		$1
}

rule file_710_2_0 {
	meta:
		name = "_$$$00003"
		size = 30
		refs = "0004 __adjust_fdiv 0010 __adj_fprem"
	strings:
		$1 = { D9 C9 83 3D ?? ?? ?? ?? 01 74 04 D9 F8 EB 05 E8 ?? ?? ?? ?? 9B DF E0 9B 9E 7A E7 DD D9 C3 }
	condition:
		$1
}

rule file_711_1_0 {
	meta:
		name = "__stati64"
		size = 851
		refs = "000c ___security_cookie 0015 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 001e __mbspbrk 002c _errno 0031 __doserrno 006b __mbctolower 0076 __getdrive 008b __imp__FindFirstFileA@8 00a1 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 00bf __fullpath 00ce _strlen 00d9 _IsRootUNCName 00e4 __imp__GetDriveTypeA@4 0117 ___loctotime_t 0151 __imp__FileTimeToLocalFileTime@8 016d __imp__FileTimeToSystemTime@8 02cd __imp__FindClose@4 02db ___dtoxmode 02f6 __allmul 032a __imp__GetLastError@0 0330 __dosmaperr 034a @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 90 81 EC 68 02 00 00 A1 ?? ?? ?? ?? 56 8B 75 78 68 ?? ?? ?? ?? 56 89 45 6C E8 ?? ?? ?? ?? 85 C0 59 59 74 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 08 03 00 00 53 33 DB 80 7E 01 3A 75 2F 8A 06 3A C3 74 1A 38 5E 02 75 15 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 C8 FF E9 DE 02 00 00 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 85 08 FE FF FF 57 8D 85 2C FF FF FF 50 56 FF 15 ?? ?? ?? ?? 83 CF FF 3B C7 89 85 14 FE FF FF 0F 85 A1 00 00 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 7E 68 04 01 00 00 8D 85 28 FE FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 3B F3 74 63 56 E8 ?? ?? ?? ?? 83 F8 03 59 74 09 E8 ?? ?? ?? ?? 85 C0 74 4E 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 42 57 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 85 2C FF FF FF 10 00 00 00 89 9D 48 FF FF FF 89 9D 4C FF FF FF 88 9D 58 FF FF FF E8 ?? ?? ?? ?? 8B 75 7C 83 C4 1C 89 46 24 89 46 20 89 46 28 E9 A2 01 00 00 6A 02 58 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? E9 00 02 00 00 8D 85 0C FE FF FF 50 8D 85 40 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CB 01 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 AF 01 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 8B 75 7C 83 C4 1C 39 9D 38 FF FF FF 89 46 24 75 08 39 9D 3C FF FF FF 74 71 8D 85 0C FE FF FF 50 8D 85 38 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 44 01 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 28 01 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 39 9D 30 FF FF FF 89 46 20 75 0D 39 9D 34 FF FF FF 75 05 8B 46 24 EB 71 8D 85 0C FE FF FF 50 8D 85 30 FF FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BB 00 00 00 8D 85 18 FE FF FF 50 8D 85 0C FE FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 9F 00 00 00 0F B7 85 24 FE FF FF 57 50 0F B7 85 22 FE FF FF 50 0F B7 85 20 FE FF FF 50 0F B7 85 1E FE FF FF 50 0F B7 85 1A FE FF FF 50 0F B7 85 18 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C FF B5 14 FE FF FF 89 46 28 FF 15 ?? ?? ?? ?? FF 75 78 FF B5 2C FF FF FF E8 ?? ?? ?? ?? 59 59 6A 01 53 53 FF B5 48 FF FF FF 66 89 46 06 66 C7 46 08 01 00 E8 ?? ?? ?? ?? 8B 8D 4C FF FF FF 33 FF 03 C1 89 46 18 8B 85 08 FE FF FF 13 D7 48 89 06 89 46 10 89 56 1C 66 89 5E 04 66 89 5E 0C 66 89 5E 0A 33 C0 EB 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 14 FE FF FF FF 15 ?? ?? ?? ?? 8B C7 5F 5B 8B 4D 6C 5E E8 ?? ?? ?? ?? 83 C5 70 C9 C3 }
	condition:
		$1
}

rule file_712_0_0 {
	meta:
		name = "_gets"
		size = 74
		refs = "000a __iob 0026 __filbuf"
	strings:
		$1 = { 56 57 8B 7C 24 0C 8B F7 FF 0D ?? ?? ?? ?? 78 10 A1 ?? ?? ?? ?? 0F B6 00 FF 05 ?? ?? ?? ?? EB 0B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 83 F8 0A 74 12 83 F8 FF 74 05 88 06 46 EB CE 3B F7 75 04 33 FF EB 03 C6 06 00 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_714_0_0 {
	meta:
		name = "__RTC_CheckEsp"
		size = 35
		refs = "0014 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 75 01 C3 55 8B EC 83 EC 00 50 52 53 56 57 6A 00 FF 75 04 E8 ?? ?? ?? ?? 59 59 5F 5E 5B 5A 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_714_1_0 {
	meta:
		name = "@_RTC_CheckStackVars@8"
		size = 90
		refs = "003f ?_RTC_StackFailure@@YAXPAXPBD@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B F2 33 DB 39 1E 8B D1 89 55 F8 89 5D FC 7E 3F 57 BF CC CC CC CC 8B 46 04 03 C3 8B 08 39 7C 11 FC 75 0A 8B 40 04 03 C1 39 3C 10 74 14 8B 46 04 FF 74 18 08 FF 75 04 E8 ?? ?? ?? ?? 8B 55 F8 59 59 FF 45 FC 8B 45 FC 83 C3 0C 3B 06 7C C8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_715_0_0 {
	meta:
		name = "__execvpe"
		size = 361
		refs = "0010 __execve 0019 _errno 0028 __mbschr 0057 ??_C@_04HBHDLLBA@PATH?$AA@ 005c _getenv 0073 _malloc 00b7 __mbsrchr 00c6 ??_C@_01KICIPPFI@?2?$AA@ 00cc _strcat 00d4 _strlen 015c _free"
	strings:
		$1 = { 55 8B EC 51 56 FF 75 10 8B 75 08 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 83 3D ?? ?? ?? ?? 02 0F 85 3F 01 00 00 6A 5C 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 2D 01 00 00 6A 2F 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 1B 01 00 00 38 06 74 0A 80 7E 01 3A 0F 84 0D 01 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 89 45 FC 0F 84 F7 00 00 00 53 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 59 8B DE 0F 84 DE 00 00 00 57 8B 4D FC EB 15 3C 3B 74 17 8D 96 02 01 00 00 3B DA 73 0D 88 03 43 41 89 4D FC 8A 01 84 C0 75 E5 8D 7B FF C6 03 00 8A 07 3C 5C 8B DE 75 0E 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F8 EB 02 3C 2F 74 0D 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 56 E8 ?? ?? ?? ?? FF 75 08 8B F8 E8 ?? ?? ?? ?? 03 F8 81 FF 04 01 00 00 59 59 73 6C FF 75 08 56 E8 ?? ?? ?? ?? FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 14 83 3D ?? ?? ?? ?? 02 74 3B 6A 5C 56 E8 ?? ?? ?? ?? 3B F0 59 59 74 0E 6A 2F 56 E8 ?? ?? ?? ?? 3B F0 59 59 75 2F 8D 7E 01 6A 5C 57 E8 ?? ?? ?? ?? 3B F8 59 59 74 0E 6A 2F 57 E8 ?? ?? ?? ?? 3B F8 59 59 75 10 8B 45 FC 80 38 00 74 08 FF 45 FC E9 2B FF FF FF 56 E8 ?? ?? ?? ?? 59 5F 5B 83 C8 FF 5E C9 C3 }
	condition:
		$1
}

rule file_717_0_0 {
	meta:
		name = "__ftol2"
		size = 117
	strings:
		$1 = { 55 8B EC 83 EC 20 83 E4 F0 D9 C0 D9 54 24 18 DF 7C 24 10 DF 6C 24 10 8B 54 24 18 8B 44 24 10 85 C0 74 3C DE E9 85 D2 79 1E D9 1C 24 8B 0C 24 81 F1 00 00 00 80 81 C1 FF FF FF 7F 83 D0 00 8B 54 24 14 83 D2 00 EB 2C D9 1C 24 8B 0C 24 81 C1 FF FF FF 7F 83 D8 00 8B 54 24 14 83 DA 00 EB 14 8B 54 24 14 F7 C2 FF FF FF 7F 75 B8 D9 5C 24 18 D9 5C 24 18 C9 C3 }
	condition:
		$1
}

rule file_719_0_0 {
	meta:
		name = "__ismbcalnum"
		size = 137
		refs = "0023 ___ismbcodepage 0035 ___mblcid 003e ___mbcodepage 004c ___crtGetStringTypeA 0070 __pctype 007e __mbctype"
	strings:
		$1 = { 55 8B EC 51 8B 4D 08 81 F9 FF 00 00 00 76 5C 66 83 65 FC 00 57 33 C0 8D 7D FE 66 AB 8B C1 C1 E8 08 83 3D ?? ?? ?? ?? 00 88 45 0A 88 4D 0B 5F 74 54 6A 01 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 02 8D 45 0A 50 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 2E 66 83 7D FE 00 75 27 66 F7 45 FC 07 01 74 1F 33 C0 40 C9 C3 0F B6 C1 8B 0D ?? ?? ?? ?? 66 F7 04 41 07 01 75 EA F6 80 ?? ?? ?? ?? 01 75 E1 33 C0 C9 C3 }
	condition:
		$1
}

rule file_720_0_0 {
	meta:
		name = "__wcsnicoll"
		size = 169
		refs = "001e _errno 002b ___lc_handle 0080 ___lc_collate_cp 0093 ___crtCompareStringW"
	strings:
		$1 = { 55 8B EC 57 8B 7D 10 85 FF 75 07 33 C0 E9 94 00 00 00 56 BE FF FF FF 7F 3B FE 76 0E C7 05 ?? ?? ?? ?? 16 00 00 00 8B C6 EB 7B A1 ?? ?? ?? ?? 85 C0 75 4B 8B 75 0C 8B 55 08 33 C0 66 8B 02 66 3D 41 00 72 09 66 3D 5A 00 8D 48 20 76 02 8B C8 33 C0 66 8B 06 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 42 42 46 46 4F 74 0A 66 85 C9 74 05 66 3B C8 74 C5 0F B7 D0 0F B7 C1 2B C2 EB 27 FF 35 ?? ?? ?? ?? 57 FF 75 0C 57 FF 75 08 68 01 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 0F 84 7A FF FF FF 83 C0 FE 5E 5F 5D C3 }
	condition:
		$1
}

rule file_721_0_0 {
	meta:
		name = "_time"
		size = 57
		refs = "000b __imp__GetSystemTimeAsFileTime@4 002a __aulldiv"
	strings:
		$1 = { 55 8B EC 51 51 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 45 F8 8B 4D FC 6A 00 05 00 80 C1 2A 68 80 96 98 00 81 D1 21 4E 62 FE 51 50 E8 ?? ?? ?? ?? 8B 4D 08 85 C9 74 02 89 01 C9 C3 }
	condition:
		$1
}