/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Null;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicQueue<T> {
    private final AtomicInteger writeIndex = new AtomicInteger();
    private final AtomicInteger readIndex = new AtomicInteger();
    private final AtomicReferenceArray<T> queue;

    public AtomicQueue(int capacity) {
        this.queue = new AtomicReferenceArray(capacity);
    }

    private int next(int idx) {
        return (idx + 1) % this.queue.length();
    }

    public boolean put(@Null T value) {
        int write2 = this.writeIndex.get();
        int read2 = this.readIndex.get();
        int next = this.next(write2);
        if (next == read2) {
            return false;
        }
        this.queue.set(write2, value);
        this.writeIndex.set(next);
        return true;
    }

    @Null
    public T poll() {
        int write2;
        int read2 = this.readIndex.get();
        if (read2 == (write2 = this.writeIndex.get())) {
            return null;
        }
        T value = this.queue.get(read2);
        this.readIndex.set(this.next(read2));
        return value;
    }
}

