/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/unciv/logic/map/MapVisualization;", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/GameInfo;Lcom/unciv/logic/civilization/Civilization;)V", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "isUnitPastVisible", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isUnitFutureVisible", "isAttackVisible", "attacker", "source", "Lcom/unciv/logic/map/HexCoord;", "target", "core"})
@SourceDebugExtension(value={"SMAP\nMapVisualization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapVisualization.kt\ncom/unciv/logic/map/MapVisualization\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,28:1\n1232#2,2:29\n*S KotlinDebug\n*F\n+ 1 MapVisualization.kt\ncom/unciv/logic/map/MapVisualization\n*L\n15#1:29,2\n*E\n"})
public final class MapVisualization {
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final Civilization viewingCiv;

    public MapVisualization(@NotNull GameInfo gameInfo, @NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        this.gameInfo = gameInfo;
        this.viewingCiv = viewingCiv;
    }

    @NotNull
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    public final boolean isUnitPastVisible(@NotNull MapUnit unit) {
        boolean bl;
        block2: {
            Sequence checkPositions;
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (Intrinsics.areEqual(unit.getCiv(), this.viewingCiv)) {
                return true;
            }
            Sequence[] sequenceArray = new Sequence[]{SequencesKt.map(CollectionsKt.asSequence((Iterable)unit.getMovementMemories()), MapVisualization::isUnitPastVisible$lambda$0), SequencesKt.sequenceOf(unit.getTile().getPosition())};
            Sequence $this$all$iv = checkPositions = SequencesKt.flatten(SequencesKt.sequenceOf(sequenceArray));
            boolean $i$f$all = false;
            Iterator iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                HexCoord it = (HexCoord)element$iv;
                boolean bl2 = false;
                if (this.viewingCiv.getViewableTiles().contains(this.gameInfo.getTileMap().get(it))) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl && (!unit.isInvisible(this.viewingCiv) || this.viewingCiv.getViewableInvisibleUnitsTiles().contains(unit.getTile()));
    }

    public final boolean isUnitFutureVisible(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return this.viewingCiv.isSpectator() || Intrinsics.areEqual(unit.getCiv(), this.viewingCiv);
    }

    public final boolean isAttackVisible(@NotNull Civilization attacker, @NotNull HexCoord source, @NotNull HexCoord target) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        return Intrinsics.areEqual(attacker, this.viewingCiv) || this.viewingCiv.getViewableTiles().contains(this.gameInfo.getTileMap().get(source)) || this.viewingCiv.getViewableTiles().contains(this.gameInfo.getTileMap().get(target));
    }

    private static final HexCoord isUnitPastVisible$lambda$0(MapUnit.UnitMovementMemory it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition();
    }
}

