/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.unciv.UncivGame;
import com.unciv.logic.event.EventBus;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.TextFieldWithFixes;
import com.unciv.ui.components.widgets.UncivTextField$VisibleAreaChangedListener$1$1$1$invokeSuspend$;
import com.unciv.ui.components.widgets.UncivTextField$addPopupCloseListener$;
import com.unciv.ui.components.widgets.UncivTextField$scrollAscendantToTextField$;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.UncivStage;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.text.NumberFormat;
import java.text.ParseException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B<\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012!\b\u0002\u0010\u0005\u001a\u001b\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002R'\u0010\u0005\u001a\u001b\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField;", "Lcom/unciv/ui/components/widgets/TextFieldWithFixes;", "hint", "", "preEnteredText", "onFocusChange", "Lkotlin/Function2;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField;", "", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "isAndroid", "hideKeyboard", "Lkotlin/Function0;", "addPopupCloseListener", "scrollAscendantToTextField", "UncivTextFieldFocusListener", "VisibleAreaChangedListener", "TextfieldPopup", "Numeric", "Integer", "core"})
@SourceDebugExtension(value={"SMAP\nUncivTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivTextField.kt\ncom/unciv/ui/components/widgets/UncivTextField\n+ 2 Scene2dExtensions.kt\ncom/unciv/ui/components/extensions/Scene2dExtensionsKt\n*L\n1#1,256:1\n170#2:257\n170#2:258\n*S KotlinDebug\n*F\n+ 1 UncivTextField.kt\ncom/unciv/ui/components/widgets/UncivTextField\n*L\n102#1:257\n116#1:258\n*E\n"})
public class UncivTextField
extends TextFieldWithFixes {
    @Nullable
    private final Function2<TextField, Boolean, Unit> onFocusChange;
    private final boolean isAndroid;
    @NotNull
    private final Function0<Unit> hideKeyboard;

    public UncivTextField(@NotNull String hint, @NotNull String preEnteredText, @Nullable Function2<? super TextField, ? super Boolean, Unit> onFocusChange) {
        Intrinsics.checkNotNullParameter(hint, "hint");
        Intrinsics.checkNotNullParameter(preEnteredText, "preEnteredText");
        super(preEnteredText, BaseScreen.Companion.getSkin());
        this.onFocusChange = onFocusChange;
        this.hideKeyboard = UncivTextField::hideKeyboard$lambda$0;
        this.setMessageText(TranslationsKt.tr$default(hint, false, false, 3, null));
        this.addListener(new UncivTextFieldFocusListener());
        if (this.isAndroid) {
            this.addListener(new VisibleAreaChangedListener());
        }
    }

    public /* synthetic */ UncivTextField(String string, String string2, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            function2 = null;
        }
        this(string, string2, function2);
    }

    private final void addPopupCloseListener() {
        Popup popup2;
        Actor $this$getAscendant$iv = this;
        boolean $i$f$getAscendant = false;
        Actor actor = Scene2dExtensionsKt.getAscendant($this$getAscendant$iv, addPopupCloseListener$$inlined$getAscendant$1.INSTANCE);
        if (!(actor instanceof Popup)) {
            actor = null;
        }
        if ((popup2 = (Popup)actor) != null && !popup2.getCloseListeners().contains(this.hideKeyboard)) {
            popup2.getCloseListeners().add(this.hideKeyboard);
        }
    }

    private final boolean scrollAscendantToTextField() {
        Stage stage = this.getStage();
        UncivStage uncivStage = stage instanceof UncivStage ? (UncivStage)stage : null;
        if (uncivStage == null) {
            return false;
        }
        UncivStage stage2 = uncivStage;
        Actor $this$getAscendant$iv = this;
        boolean $i$f$getAscendant = false;
        Actor actor = Scene2dExtensionsKt.getAscendant($this$getAscendant$iv, scrollAscendantToTextField$$inlined$getAscendant$1.INSTANCE);
        if (!(actor instanceof ScrollPane)) {
            actor = null;
        }
        ScrollPane scrollPane = (ScrollPane)actor;
        Rectangle visibleArea = stage2.getLastKnownVisibleArea();
        Rectangle textFieldStageBoundingBox = Scene2dExtensionsKt.getStageBoundingBox(this);
        if (scrollPane == null) {
            return visibleArea.contains(textFieldStageBoundingBox);
        }
        Rectangle scrollPaneBounds = Scene2dExtensionsKt.getStageBoundingBox(scrollPane);
        Rectangle visibleScrollPaneArea = Scene2dExtensionsKt.getOverlap(scrollPaneBounds, visibleArea);
        if (visibleScrollPaneArea == null) {
            return false;
        }
        if (visibleScrollPaneArea.contains(textFieldStageBoundingBox)) {
            return true;
        }
        Actor scrollContent = scrollPane.getActor();
        Vector2 textFieldScrollContentCoords = this.localToAscendantCoordinates(scrollContent, new Vector2(0.0f, 0.0f));
        float pixelsNotVisibleOnLeftSide = RangesKt.coerceAtLeast(visibleScrollPaneArea.x - scrollPaneBounds.x, 0.0f);
        float textFieldDistanceFromLeftSide = textFieldScrollContentCoords.x;
        float pixelsNotVisibleOnRightSide = RangesKt.coerceAtLeast(Scene2dExtensionsKt.getRight(scrollPaneBounds) - Scene2dExtensionsKt.getRight(visibleScrollPaneArea), 0.0f);
        float textFieldDistanceFromRightSide = scrollContent.getWidth() - (textFieldScrollContentCoords.x + this.getWidth());
        float pixelsNotVisibleOnTop = RangesKt.coerceAtLeast(Scene2dExtensionsKt.getTop(scrollPaneBounds) - Scene2dExtensionsKt.getTop(visibleScrollPaneArea), 0.0f);
        float textFieldDistanceFromTop = scrollContent.getHeight() - (textFieldScrollContentCoords.y + this.getHeight());
        float pixelsNotVisibleOnBottom = RangesKt.coerceAtLeast(visibleScrollPaneArea.y - scrollPaneBounds.y, 0.0f);
        float textFieldDistanceFromBottom = textFieldScrollContentCoords.y;
        if (visibleScrollPaneArea.width < this.getWidth() || visibleScrollPaneArea.height < this.getHeight() || pixelsNotVisibleOnLeftSide > textFieldDistanceFromLeftSide || pixelsNotVisibleOnRightSide > textFieldDistanceFromRightSide || pixelsNotVisibleOnTop > textFieldDistanceFromTop || pixelsNotVisibleOnBottom > textFieldDistanceFromBottom) {
            return false;
        }
        float scrollXMiddle = textFieldScrollContentCoords.x - this.getWidth() / (float)2 + visibleScrollPaneArea.width / (float)2;
        scrollPane.setScrollX(pixelsNotVisibleOnLeftSide + scrollXMiddle);
        float scrollYMiddleGdxOrigin = textFieldScrollContentCoords.y + this.getHeight() / (float)2 + visibleScrollPaneArea.height / (float)2;
        scrollPane.setScrollY(pixelsNotVisibleOnTop + scrollContent.getHeight() - scrollYMiddleGdxOrigin);
        return true;
    }

    private static final Unit hideKeyboard$lambda$0() {
        Gdx.input.setOnscreenKeyboardVisible(false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B<\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012!\b\u0002\u0010\u0006\u001a\u001b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0004\b\f\u0010\rR(\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField$Integer;", "Lcom/unciv/ui/components/widgets/UncivTextField$Numeric;", "hint", "", "initialValue", "", "onFocusChange", "Lkotlin/Function2;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField;", "", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/String;Ljava/lang/Integer;Lkotlin/jvm/functions/Function2;)V", "value", "intValue", "getIntValue", "()Ljava/lang/Integer;", "setIntValue", "(Ljava/lang/Integer;)V", "core"})
    public static final class Integer
    extends Numeric {
        public Integer(@NotNull String hint, @Nullable java.lang.Integer initialValue, @Nullable Function2<? super TextField, ? super Boolean, Unit> onFocusChange) {
            Intrinsics.checkNotNullParameter(hint, "hint");
            super(hint, initialValue, true, onFocusChange);
            this.setMaxLength(14);
        }

        public /* synthetic */ Integer(String string, java.lang.Integer n, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                function2 = null;
            }
            this(string, n, (Function2<? super TextField, ? super Boolean, Unit>)function2);
        }

        @Nullable
        public final java.lang.Integer getIntValue() {
            Number number = this.getValue();
            return number != null ? java.lang.Integer.valueOf(number.intValue()) : null;
        }

        public final void setIntValue(@Nullable java.lang.Integer value) {
            this.setValue(value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001BF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012!\b\u0002\u0010\b\u001a\u001b\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0017R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField$Numeric;", "Lcom/unciv/ui/components/widgets/UncivTextField;", "hint", "", "initialValue", "", "integerOnly", "", "onFocusChange", "Lkotlin/Function2;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/String;Ljava/lang/Number;ZLkotlin/jvm/functions/Function2;)V", "formatter", "Ljava/text/NumberFormat;", "symbols", "value", "getValue", "()Ljava/lang/Number;", "setValue", "(Ljava/lang/Number;)V", "setText", "str", "core"})
    @SourceDebugExtension(value={"SMAP\nUncivTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivTextField.kt\ncom/unciv/ui/components/widgets/UncivTextField$Numeric\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,256:1\n434#2:257\n507#2,5:258\n*S KotlinDebug\n*F\n+ 1 UncivTextField.kt\ncom/unciv/ui/components/widgets/UncivTextField$Numeric\n*L\n218#1:257\n218#1:258,5\n*E\n"})
    public static class Numeric
    extends UncivTextField {
        @NotNull
        private final NumberFormat formatter;
        @NotNull
        private final String symbols;

        /*
         * WARNING - void declaration
         */
        public Numeric(@NotNull String hint, @Nullable Number initialValue, boolean integerOnly, @Nullable Function2<? super TextField, ? super Boolean, Unit> onFocusChange) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter(hint, "hint");
            Object object = initialValue;
            if (object == null || (object = TranslationsKt.tr((Number)object)) == null) {
                object = "";
            }
            super(hint, (String)object, onFocusChange);
            this.formatter = UncivGame.Companion.getCurrent().getSettings().getCurrentNumberFormat();
            String string = this.formatter.format(integerOnly ? (Number)-9999 : (Number)-9999.9);
            Intrinsics.checkNotNullExpressionValue(string, "format(...)");
            String string2 = string;
            Numeric numeric = this;
            boolean $i$f$filter = false;
            CharSequence charSequence = (CharSequence)$this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(!Character.isDigit(it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            numeric.symbols = ((StringBuilder)destination$iv$iv).toString();
            this.setTextFieldFilter((arg_0, arg_1) -> Numeric._init_$lambda$0(this, arg_0, arg_1));
            this.formatter.setParseIntegerOnly(integerOnly);
            this.setMaxLength(26);
        }

        public /* synthetic */ Numeric(String string, Number number, boolean bl, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                function2 = null;
            }
            this(string, number, bl, function2);
        }

        @Nullable
        public Number getValue() {
            Number number;
            try {
                number = this.formatter.parse(this.text);
            }
            catch (ParseException parseException) {
                number = null;
            }
            return number;
        }

        public void setValue(@Nullable Number value) {
            Number number = value;
            super.setText(number != null ? TranslationsKt.tr(number) : null);
        }

        @Override
        @Deprecated(message="Don't assign `text` on a numeric UncivTextField!", replaceWith=@ReplaceWith(expression="value", imports={}), level=DeprecationLevel.ERROR)
        public void setText(@Nullable String str) {
            super.setText(str);
        }

        private static final boolean _init_$lambda$0(Numeric this$0, TextField textField, char c) {
            return Character.isDigit(c) || StringsKt.contains$default((CharSequence)this$0.symbols, c, false, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField$TextfieldPopup;", "Lcom/unciv/ui/popups/Popup;", "<init>", "(Lcom/unciv/ui/components/widgets/UncivTextField;)V", "popupTextfield", "Lcom/unciv/ui/components/widgets/TextFieldWithFixes;", "getPopupTextfield", "()Lcom/unciv/ui/components/widgets/TextFieldWithFixes;", "core"})
    private final class TextfieldPopup
    extends Popup {
        @NotNull
        private final TextFieldWithFixes popupTextfield;

        public TextfieldPopup() {
            Stage stage = UncivTextField.this.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            super(stage, null, 0.0f, 6, null);
            this.popupTextfield = new TextFieldWithFixes(UncivTextField.this);
            Popup popup2 = this;
            String string = this.popupTextfield.getMessageText();
            Intrinsics.checkNotNullExpressionValue(string, "getMessageText(...)");
            Popup.addGoodSizedLabel$default(popup2, string, 0, false, null, 14, null).colspan(2).row();
            this.add((Actor)this.popupTextfield).width(this.getStageToShowOn().getWidth() / (float)2).colspan(2).row();
            Popup.addCloseButton$default(this, "Cancel", null, null, null, 14, null).left();
            Popup.addOKButton$default(this, null, null, null, null, () -> TextfieldPopup._init_$lambda$0(UncivTextField.this, this), 15, null).right().row();
            this.getShowListeners().add(() -> TextfieldPopup._init_$lambda$1(this));
            this.getCloseListeners().add(() -> TextfieldPopup._init_$lambda$2(this));
        }

        @NotNull
        public final TextFieldWithFixes getPopupTextfield() {
            return this.popupTextfield;
        }

        private static final Unit _init_$lambda$0(UncivTextField this$0, TextfieldPopup this$1) {
            this$0.copyTextAndSelection(this$1.popupTextfield);
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$1(TextfieldPopup this$0) {
            this$0.getStageToShowOn().setKeyboardFocus(this$0.popupTextfield);
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$2(TextfieldPopup this$0) {
            this$0.getStageToShowOn().setKeyboardFocus(null);
            Gdx.input.setOnscreenKeyboardVisible(false);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField$UncivTextFieldFocusListener;", "Lcom/badlogic/gdx/scenes/scene2d/utils/FocusListener;", "<init>", "(Lcom/unciv/ui/components/widgets/UncivTextField;)V", "keyboardFocusChanged", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/utils/FocusListener$FocusEvent;", "actor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "focused", "", "core"})
    private final class UncivTextFieldFocusListener
    extends FocusListener {
        @Override
        public void keyboardFocusChanged(@NotNull FocusListener.FocusEvent event, @NotNull Actor actor, boolean focused) {
            block2: {
                Intrinsics.checkNotNullParameter(event, "event");
                Intrinsics.checkNotNullParameter(actor, "actor");
                if (focused) {
                    UncivTextField.this.scrollAscendantToTextField();
                    if (UncivTextField.this.isAndroid) {
                        UncivTextField.this.addPopupCloseListener();
                        Gdx.input.setOnscreenKeyboardVisible(true);
                    }
                }
                Function2 function2 = UncivTextField.this.onFocusChange;
                if (function2 == null) break block2;
                function2.invoke(UncivTextField.this, focused);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField$VisibleAreaChangedListener;", "Lcom/badlogic/gdx/scenes/scene2d/InputListener;", "<init>", "(Lcom/unciv/ui/components/widgets/UncivTextField;)V", "events", "Lcom/unciv/logic/event/EventBus$EventReceiver;", "touchDown", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "x", "", "y", "pointer", "", "button", "core"})
    private final class VisibleAreaChangedListener
    extends InputListener {
        @NotNull
        private final EventBus.EventReceiver events = new EventBus.EventReceiver();

        public VisibleAreaChangedListener() {
            EventBus.EventReceiver.receive$default(this.events, Reflection.getOrCreateKotlinClass(UncivStage.VisibleAreaChanged.class), null, arg_0 -> VisibleAreaChangedListener._init_$lambda$0(UncivTextField.this, arg_0), 2, null);
        }

        @Override
        public boolean touchDown(@NotNull InputEvent event, float x, float y, int pointer, int button) {
            Intrinsics.checkNotNullParameter(event, "event");
            UncivTextField.this.addPopupCloseListener();
            return false;
        }

        private static final Unit _init_$lambda$0(UncivTextField this$0, UncivStage.VisibleAreaChanged it) {
            Intrinsics.checkNotNullParameter(it, "it");
            if (this$0.getStage() == null || !this$0.hasKeyboardFocus()) {
                return Unit.INSTANCE;
            }
            Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                int label;
                final /* synthetic */ UncivTextField this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            this.label = 1;
                            v0 = DelayKt.delay(100L, this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = ConcurrencyKt.withGLContext((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ UncivTextField this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            if (this.this$0.getStage() == null) {
                                                return Unit.INSTANCE;
                                            }
                                            if (UncivTextField.access$scrollAscendantToTextField(this.this$0)) {
                                                ScrollPane scrollPane;
                                                Actor $this$getAscendant$iv = this.this$0;
                                                boolean $i$f$getAscendant = false;
                                                Actor actor = Scene2dExtensionsKt.getAscendant($this$getAscendant$iv, VisibleAreaChangedListener$1$1$1$invokeSuspend$$inlined$getAscendant$1.INSTANCE);
                                                if (!(actor instanceof ScrollPane)) {
                                                    actor = null;
                                                }
                                                ScrollPane scrollPane2 = scrollPane = (ScrollPane)actor;
                                                if (scrollPane2 != null) {
                                                    scrollPane2.updateVisualScroll();
                                                }
                                            } else {
                                                Popup.open$default(this.this$0.new TextfieldPopup(), false, 1, null);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, this);
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            return Unit.INSTANCE;
        }
    }
}

