/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.input.KeyboardBindings;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.KeyCapturingButton;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.popups.options.OptionsPopupTab;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\\\u0010\u0016\u001aV\u0012\u0004\u0012\u00020\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f0\u000bj*\u0012\u0004\u0012\u00020\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f`\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\u0006\u0010\u001e\u001a\u00020\u0018J \u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000Ro\u0010\n\u001aV\u0012\u0004\u0012\u00020\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f0\u000bj*\u0012\u0004\u0012\u00020\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f`\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/unciv/ui/popups/options/KeyBindingsTab;", "Lcom/unciv/ui/popups/options/OptionsPopupTab;", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "labelWidth", "", "<init>", "(Lcom/unciv/ui/popups/options/OptionsPopup;F)V", "keyBindings", "Lcom/unciv/ui/components/input/KeyboardBindings;", "groupedWidgets", "Ljava/util/LinkedHashMap;", "Lcom/unciv/ui/components/input/KeyboardBinding$Category;", "Lcom/unciv/ui/components/input/KeyboardBinding;", "Lcom/unciv/ui/components/widgets/KeyCapturingButton;", "Lkotlin/collections/LinkedHashMap;", "getGroupedWidgets", "()Ljava/util/LinkedHashMap;", "groupedWidgets$delegate", "Lkotlin/Lazy;", "disclaimer", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "createGroupedWidgets", "update", "", "getCategoryWidget", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "category", "bindings", "onKeyHit", "save", "activated", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "deactivated", "core"})
@SourceDebugExtension(value={"SMAP\nKeyBindingsTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyBindingsTab.kt\ncom/unciv/ui/popups/options/KeyBindingsTab\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n996#2:128\n1025#2,3:129\n1028#2,3:139\n382#3,7:132\n126#4:142\n153#4,3:143\n*S KotlinDebug\n*F\n+ 1 KeyBindingsTab.kt\ncom/unciv/ui/popups/options/KeyBindingsTab\n*L\n46#1:128\n46#1:129,3\n46#1:139,3\n46#1:132,7\n94#1:142\n94#1:143,3\n*E\n"})
public final class KeyBindingsTab
extends OptionsPopupTab {
    private final float labelWidth;
    @NotNull
    private final KeyboardBindings keyBindings;
    @NotNull
    private final Lazy groupedWidgets$delegate;
    @NotNull
    private final Table disclaimer;

    public KeyBindingsTab(@NotNull OptionsPopup optionsPopup, float labelWidth) {
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        super(optionsPopup);
        this.labelWidth = labelWidth;
        this.keyBindings = this.getSettings().getKeyBindings();
        this.groupedWidgets$delegate = LazyKt.lazy(() -> KeyBindingsTab.groupedWidgets_delegate$lambda$0(this));
        FormattedLine[] formattedLineArray = new FormattedLine[]{new FormattedLine("This is a work in progress.", null, null, null, 0.0f, 0, 0, 0, 0.0f, "FIREBRICK", false, false, true, false, 11774, null), new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null), new FormattedLine("Please see the Tutorial.", "Tutorial/Keyboard Bindings", null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null), new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, true, false, false, false, 15359, null)};
        this.disclaimer = MarkupRenderer.render$default(MarkupRenderer.INSTANCE, CollectionsKt.listOf(formattedLineArray), this.labelWidth, 0.0f, null, KeyBindingsTab::disclaimer$lambda$0, 12, null);
        this.top();
    }

    private final LinkedHashMap<KeyboardBinding.Category, LinkedHashMap<KeyboardBinding, KeyCapturingButton>> getGroupedWidgets() {
        Lazy lazy = this.groupedWidgets$delegate;
        return (LinkedHashMap)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashMap<KeyboardBinding.Category, LinkedHashMap<KeyboardBinding, KeyCapturingButton>> createGroupedWidgets() {
        void $this$groupByTo$iv$iv;
        Collator collator = this.getSettings().getCollatorFromLocale();
        Sequence<KeyboardBinding> $this$groupBy$iv = SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)KeyboardBinding.getEntries()), KeyBindingsTab::createGroupedWidgets$lambda$0);
        boolean $i$f$groupBy = false;
        Sequence<KeyboardBinding> sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            KeyboardBinding it = (KeyboardBinding)((Object)element$iv$iv);
            boolean bl = false;
            KeyboardBinding.Category key$iv$iv = it.getCategory();
            Map map2 = destination$iv$iv;
            KeyboardBinding.Category key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return (LinkedHashMap)MapsKt.toMap(SequencesKt.sortedWith(SequencesKt.map(MapsKt.asSequence(destination$iv$iv), arg_0 -> KeyBindingsTab.createGroupedWidgets$lambda$2(collator, this, arg_0)), new Comparator(collator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                Pair it = (Pair)b;
                String string = TranslationsKt.tr$default(((KeyboardBinding.Category)((Object)it.getFirst())).getLabel(), false, false, 3, null);
                bl = false;
                String string2 = TranslationsKt.tr$default(((KeyboardBinding.Category)((Object)it.getFirst())).getLabel(), false, false, 3, null);
                return comparator.compare(string, string2);
            }
        }), (Map)new LinkedHashMap());
    }

    private final void update() {
        this.clear();
        this.add((Actor)this.disclaimer).center().row();
        for (Map.Entry entry : ((Map)this.getGroupedWidgets()).entrySet()) {
            KeyboardBinding.Category category = (KeyboardBinding.Category)((Object)entry.getKey());
            LinkedHashMap bindings = (LinkedHashMap)entry.getValue();
            this.add((Actor)this.getCategoryWidget(category, bindings)).row();
        }
    }

    private final ExpanderTab getCategoryWidget(KeyboardBinding.Category category, LinkedHashMap<KeyboardBinding, KeyCapturingButton> bindings) {
        return new ExpanderTab(category.getLabel(), 0, null, false, 0.0f, 0.0f, 5.0f, 0.0f, 0.0f, "KeyBindings." + category.name(), null, null, arg_0 -> KeyBindingsTab.getCategoryWidget$lambda$0(bindings, this, arg_0), 3494, null);
    }

    private final void onKeyHit() {
        for (Map.Entry entry : ((Map)this.getGroupedWidgets()).entrySet()) {
            KeyboardBinding.Category category = (KeyboardBinding.Category)((Object)entry.getKey());
            LinkedHashMap bindings = (LinkedHashMap)entry.getValue();
            Sequence<KeyboardBinding.Category> scope2 = category.checkConflictsIn();
            if (SequencesKt.none(scope2)) continue;
            Set usedKeys = new LinkedHashSet();
            Set conflictingKeys = new LinkedHashSet();
            Sequence widgetsInScope = SequencesKt.flatMapIterable(SequencesKt.mapNotNull(scope2, arg_0 -> KeyBindingsTab.onKeyHit$lambda$0(this, arg_0)), KeyBindingsTab::onKeyHit$lambda$1);
            Iterator<Object> iterator2 = widgetsInScope.iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                KeyboardBinding.Category scopeCategory = (KeyboardBinding.Category)((Object)pair.component1());
                KeyCapturingButton widget = (KeyCapturingButton)pair.component2();
                KeyCharAndCode key = widget.getCurrent();
                if (usedKeys.contains(key) || scopeCategory != category) {
                    ((Collection)conflictingKeys).add(key);
                    continue;
                }
                ((Collection)usedKeys).add(key);
            }
            for (Object object : bindings.values()) {
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                KeyCapturingButton widget = (KeyCapturingButton)object;
                widget.setMarkConflict(conflictingKeys.contains(widget.getCurrent()));
            }
        }
    }

    public final void save() {
        if (!this.hasChildren()) {
            return;
        }
        Iterator iterator2 = SequencesKt.flatMapIterable(MapsKt.asSequence((Map)this.getGroupedWidgets()), KeyBindingsTab::save$lambda$0).iterator();
        while (iterator2.hasNext()) {
            Object r = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(r, "next(...)");
            Map.Entry entry = (Map.Entry)r;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "component1(...)");
            KeyboardBinding binding = (KeyboardBinding)((Object)k);
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
            KeyCapturingButton widget = (KeyCapturingButton)v;
            ((Map)this.keyBindings).put(binding, widget.getCurrent());
        }
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        super.activated(index, caption, pager);
        this.update();
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.save();
    }

    private static final LinkedHashMap groupedWidgets_delegate$lambda$0(KeyBindingsTab this$0) {
        return this$0.createGroupedWidgets();
    }

    private static final Unit disclaimer$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        GUI.INSTANCE.openCivilopedia(it);
        return Unit.INSTANCE;
    }

    private static final boolean createGroupedWidgets$lambda$0(KeyboardBinding it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getHidden();
    }

    private static final Pair createGroupedWidgets$lambda$2(Collator $collator, KeyBindingsTab this$0, Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        KeyboardBinding.Category category = (KeyboardBinding.Category)((Object)entry.getKey());
        List bindings = (List)entry.getValue();
        return TuplesKt.to(category, MapsKt.toMap(SequencesKt.map(SequencesKt.sortedWith(CollectionsKt.asSequence(bindings), new Comparator($collator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                KeyboardBinding keyboardBinding = (KeyboardBinding)((Object)a);
                Comparator comparator = this.$comparator;
                boolean bl = false;
                KeyboardBinding it = (KeyboardBinding)((Object)b);
                String string = TranslationsKt.tr$default(it.getLabel(), false, false, 3, null);
                bl = false;
                String string2 = TranslationsKt.tr$default(it.getLabel(), false, false, 3, null);
                return comparator.compare(string, string2);
            }
        }), arg_0 -> KeyBindingsTab.createGroupedWidgets$lambda$2$1(this$0, arg_0)), (Map)new LinkedHashMap()));
    }

    private static final Pair createGroupedWidgets$lambda$2$1(KeyBindingsTab this$0, KeyboardBinding it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return TuplesKt.to(it, new KeyCapturingButton(it.getDefaultKey(), null, arg_0 -> KeyBindingsTab.createGroupedWidgets$lambda$2$1$0(this$0, arg_0), 2, null));
    }

    private static final Unit createGroupedWidgets$lambda$2$1$0(KeyBindingsTab this$0, KeyCharAndCode it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.onKeyHit();
        return Unit.INSTANCE;
    }

    private static final Unit getCategoryWidget$lambda$0(LinkedHashMap $bindings, KeyBindingsTab this$0, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.defaults().padTop(5.0f);
        for (Map.Entry entry : ((Map)$bindings).entrySet()) {
            KeyboardBinding binding = (KeyboardBinding)((Object)entry.getKey());
            KeyCapturingButton widget = (KeyCapturingButton)entry.getValue();
            it.add((Actor)Scene2dExtensionsKt.toLabel(binding.getLabel())).padRight(10.0f).minWidth(this$0.labelWidth / (float)2);
            it.add((Actor)widget).row();
            widget.setCurrent((KeyCharAndCode)this$0.keyBindings.get((Object)binding));
        }
        return Unit.INSTANCE;
    }

    private static final LinkedHashMap onKeyHit$lambda$0(KeyBindingsTab this$0, KeyboardBinding.Category it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return this$0.getGroupedWidgets().get((Object)it);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable onKeyHit$lambda$1(LinkedHashMap scopeMap) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scopeMap, "scopeMap");
        Map $this$map$iv = scopeMap;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(((KeyboardBinding)((Object)it.getKey())).getCategory(), it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    private static final Iterable save$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Set set = ((LinkedHashMap)it.getValue()).entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
        return set;
    }
}

