/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityFlags;
import com.unciv.logic.city.CityFocus;
import com.unciv.logic.city.CityResources;
import com.unciv.logic.city.GreatPersonPointsBreakdown;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CitizenManagementTable;
import com.unciv.ui.screens.cityscreen.CityReligionInfoTable;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.cityscreen.DetailedStatsPopup;
import com.unciv.ui.screens.cityscreen.GreatPersonPointsBreakdownPopup;
import com.unciv.ui.screens.cityscreen.SpecialistAllocationTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0001H\u0002J.\u0010!\u001a\u00020\t*\u00020\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityStatsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "<init>", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "city", "Lcom/unciv/logic/city/City;", "expander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "miniStatsTable", "Lcom/unciv/ui/screens/cityscreen/CityStatsTable$MiniStatsTable;", "lowerTable", "lowerPane", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "lowerCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "detailedStatsButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "update", "", "height", "", "onContentResize", "addText", "addCitizenManagement", "addSpecialistInfo", "addReligionInfo", "addBuildingsInfo", "addBuildingButton", "building", "Lcom/unciv/models/ruleset/Building;", "destinationTable", "addCategory", "category", "", "showHideTable", "toggleKey", "Lcom/unciv/ui/components/input/KeyboardBinding;", "startsOpened", "", "addGreatPersonPointInfo", "MiniStatsTable", "core"})
@SourceDebugExtension(value={"SMAP\nCityStatsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityStatsTable.kt\ncom/unciv/ui/screens/cityscreen/CityStatsTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,447:1\n1#2:448\n1011#3,2:449\n1011#3,2:451\n1011#3,2:453\n*S KotlinDebug\n*F\n+ 1 CityStatsTable.kt\ncom/unciv/ui/screens/cityscreen/CityStatsTable\n*L\n248#1:449,2\n249#1:451,2\n250#1:453,2\n*E\n"})
public final class CityStatsTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final City city;
    @NotNull
    private final ExpanderTab expander;
    @NotNull
    private final MiniStatsTable miniStatsTable;
    @NotNull
    private final Table lowerTable;
    @NotNull
    private final AutoScrollPane lowerPane;
    @Nullable
    private Cell<AutoScrollPane> lowerCell;
    @NotNull
    private final TextButton detailedStatsButton;

    /*
     * WARNING - void declaration
     */
    public CityStatsTable(@NotNull CityScreen cityScreen) {
        Color color;
        void $this$detailedStatsButton_u24lambda_u24222;
        TextButton textButton;
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.city = this.cityScreen.getCity$core();
        this.miniStatsTable = new MiniStatsTable(ExpanderTab.Companion.wasOpen("CityStatsTable"));
        this.lowerTable = new Table();
        this.lowerPane = new AutoScrollPane((Actor)this.lowerTable, null, 2, null);
        TextButton textButton2 = textButton = Scene2dExtensionsKt.toTextButton$default("Stats", null, false, 3, null);
        Table table2 = this;
        boolean $i$a$-apply-CityStatsTable$detailedStatsButton$22 = false;
        $this$detailedStatsButton_u24lambda_u24222.getLabelCell().pad(10.0f);
        ActivationExtensionsKt.onActivation$default((Actor)$this$detailedStatsButton_u24lambda_u24222, null, KeyboardBinding.ShowStats, () -> CityStatsTable.detailedStatsButton$lambda$0$0(this), 1, null);
        ((CityStatsTable)table2).detailedStatsButton = textButton;
        this.pad(2.0f);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityStatsTable/Background", null, Scene2dExtensionsKt.colorFromRGB(194, 180, 131), 2, null));
        boolean bl = !this.cityScreen.isCrampedPortrait();
        float $this$detailedStatsButton_u24lambda_u24222 = this.cityScreen.isCrampedPortrait() ? 7.0f : 6.0f;
        float $i$a$-apply-CityStatsTable$detailedStatsButton$22 = this.miniStatsTable.getWidth();
        float f = this.miniStatsTable.getHeight();
        this.expander = new ExpanderTab("", 0, null, bl, 7.0f, 0.0f, $this$detailedStatsButton_u24lambda_u24222, $i$a$-apply-CityStatsTable$detailedStatsButton$22, f, "CityStatsTable", null, () -> CityStatsTable._init_$lambda$0(this), arg_0 -> CityStatsTable._init_$lambda$1(this, arg_0), 1030, null);
        this.expander.getHeaderContent().add((Actor)this.miniStatsTable).growX();
        Color $this$detailedStatsButton_u24lambda_u24222 = color = ImageGetter.INSTANCE.getCHARCOAL().cpy();
        String string = null;
        String string2 = "CityScreen/CityStatsTable/InnerTable";
        SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
        table2 = this.expander;
        boolean bl2 = false;
        $this$_init__u24lambda_u242.a = 0.8f;
        Unit unit = Unit.INSTANCE;
        table2.setBackground(SkinStrings.getUiBackground$default(skinStrings, string2, string, color, 2, null));
        this.expander.getHeader().setBackground((Drawable)null);
        this.expander.setDynamicHeaderSize();
        this.expander.toggleOnIconOnly();
        this.lowerPane.setOverscroll(false, false);
        this.lowerPane.setScrollingDisabled(true, false);
        this.lowerTable.defaults().space(4.0f);
        this.add((Actor)this.expander).growX();
    }

    public final void update(float height) {
        this.miniStatsTable.update();
        this.lowerTable.clear();
        this.lowerTable.add((Actor)this.detailedStatsButton).row();
        this.addText();
        this.addCitizenManagement();
        this.addGreatPersonPointInfo(this.city);
        if (!this.city.getPopulation().getMaxSpecialists().isEmpty()) {
            this.addSpecialistInfo();
        }
        if (!((Map)this.city.getReligion().getNumberOfFollowers()).isEmpty() && this.city.getCiv().getGameInfo().isReligionEnabled()) {
            this.addReligionInfo();
        }
        this.addBuildingsInfo();
        this.lowerTable.pack();
        this.lowerPane.layout();
        this.lowerPane.updateVisualScroll();
        this.expander.getHeader().pack();
        Cell<AutoScrollPane> cell = this.lowerCell;
        if (cell != null) {
            cell.maxHeight(height - this.expander.getHeader().getHeight() - 8.0f);
        }
        this.expander.pack();
        this.pack();
    }

    private final void onContentResize() {
        this.pack();
        this.setPosition(this.getStage().getWidth() - 5.0f, this.getStage().getHeight() - 5.0f, 18);
    }

    /*
     * WARNING - void declaration
     */
    private final void addText() {
        Pair<Object, Object> pair;
        Table resourceIcon;
        int amount;
        Table table2;
        Object it;
        String string;
        String turnsToExpansionString;
        String string2;
        String unassignedPopString = TranslationsKt.tr$default("{Unassigned population}: ", false, false, 3, null) + TranslationsKt.tr(this.city.getPopulation().getFreePopulation()) + '/' + TranslationsKt.tr(this.city.getPopulation().getPopulation());
        Label unassignedPopLabel = Scene2dExtensionsKt.toLabel(unassignedPopString);
        if (this.cityScreen.getCanChangeState()) {
            ActivationExtensionsKt.onClick(unassignedPopLabel, () -> CityStatsTable.addText$lambda$0(this));
        }
        if (this.city.getCityStats().getCurrentCityStats().getCulture() > 0.0f && SequencesKt.any(this.city.getExpansion().getChoosableTiles())) {
            int remainingCulture = this.city.getExpansion().getCultureToNextTile() - this.city.getExpansion().getCultureStored();
            int turnsToExpansion = (int)Math.ceil((float)remainingCulture / this.city.getCityStats().getCurrentCityStats().getCulture());
            if (turnsToExpansion < 1) {
                turnsToExpansion = 1;
            }
            string2 = TranslationsKt.tr$default("" + '[' + turnsToExpansion + "] turns to expansion", false, false, 3, null);
        } else {
            string2 = turnsToExpansionString = TranslationsKt.tr$default("Stopped expansion", false, false, 3, null);
        }
        if (SequencesKt.any(this.city.getExpansion().getChoosableTiles())) {
            turnsToExpansionString = turnsToExpansionString + " (" + this.city.getExpansion().getCultureStored() + "\u266a/" + this.city.getExpansion().getCultureToNextTile() + "\u266a)";
        }
        if (this.city.isStarving()) {
            string = "" + '[' + this.city.getPopulation().getNumTurnsToStarvation() + "] turns to lose population";
        } else {
            it = this.city.getRuleset().getUnits().get(this.city.getCityConstructions().currentConstructionName());
            boolean bl = false;
            string = it != null && IHasUniques.hasUnique$default((IHasUniques)it, UniqueType.ConvertFoodToProductionWhenConstructed, null, 2, null) ? "Food converts to production" : (this.city.isGrowing() ? "" + '[' + this.city.getPopulation().getNumTurnsToNewPopulation() + "] turns to new population" : "Stopped population growth");
        }
        String turnsToPopString = TranslationsKt.tr$default(string, false, false, 3, null);
        turnsToPopString = turnsToPopString + " (" + this.city.getPopulation().getFoodStored() + "\u2042/" + this.city.getPopulation().getFoodToNextPopulation() + "\u2042)";
        this.lowerTable.add((Actor)unassignedPopLabel).row();
        this.lowerTable.add((Actor)Scene2dExtensionsKt.toLabel(turnsToExpansionString)).row();
        this.lowerTable.add((Actor)Scene2dExtensionsKt.toLabel(turnsToPopString)).row();
        Table tableWithIcons = new Table();
        tableWithIcons.defaults().pad(2.0f);
        if (this.city.isInResistance()) {
            void $this$addText_u24lambda_u242;
            Object bl = it = new Table();
            table2 = tableWithIcons;
            boolean bl2 = false;
            $this$addText_u24lambda_u242.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "StatIcons/Resistance", null, 2, null)).size(20.0f).padRight(2.0f);
            $this$addText_u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel("In resistance for another [" + this.city.getFlag(CityFlags.Resistance) + "] turns"));
            table2.add((Actor)it);
        }
        Table resourceTable = new Table();
        Counter<TileResource> resourceCounter = new Counter<TileResource>(null, 1, null);
        Iterator iterator2 = CityResources.INSTANCE.getCityResourcesAvailableToCity(this.city).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Object object = iterator2;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            ResourceSupplyList.ResourceSupply resourceSupply = (ResourceSupplyList.ResourceSupply)e;
            if (!SequencesKt.none(resourceSupply.getResource().getMatchingUniques(UniqueType.NotShownOnWorldScreen, this.city.getState()))) continue;
            resourceCounter.add(resourceSupply.getResource(), resourceSupply.getAmount());
        }
        for (Map.Entry entry : ((Map)this.city.getResourceStockpiles()).entrySet()) {
            TileResource resourceObj;
            String resourceName = (String)entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            if (this.city.getRuleset().getTileResources().get(resourceName) == null || !SequencesKt.none(resourceObj.getMatchingUniques(UniqueType.NotShownOnWorldScreen, this.city.getState()))) continue;
            resourceCounter.add(resourceObj, amount);
        }
        for (Map.Entry entry : ((Map)resourceCounter).entrySet()) {
            Cell<Actor> cell;
            TileResource resource = (TileResource)entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            if (!resource.isCityWide()) continue;
            resourceIcon = new Table();
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, resourceIcon, resource.getName(), 0.0f, false, 4, 0, false, null, 118, null);
            ActivationExtensionsKt.onClick(resourceIcon, () -> CityStatsTable.addText$lambda$3(this, resource));
            resourceIcon.add((Actor)ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resource.getName(), 20.0f, 0, 4, null)).padRight(5.0f);
            resourceIcon.add((Actor)Scene2dExtensionsKt.toLabel(amount));
            Cell<Actor> $this$addText_u24lambda_u244 = cell = resourceTable.add((Actor)resourceIcon);
            boolean bl = false;
            Set set = resourceCounter.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            if (Intrinsics.areEqual(CollectionsKt.last(set), resource)) continue;
            $this$addText_u24lambda_u244.padRight(10.0f);
        }
        if (resourceTable.getCells().notEmpty()) {
            tableWithIcons.add((Actor)resourceTable);
        }
        if (this.city.isWeLoveTheKingDayActive()) {
            Image image = ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, "Food", 0.0f, 2, null);
            String string3 = "We Love The King Day for another [" + this.city.getFlag(CityFlags.WeLoveTheKing) + "] turns";
            Color color = Color.LIME;
            Intrinsics.checkNotNullExpressionValue(color, "LIME");
            pair = TuplesKt.to(image, Scene2dExtensionsKt.toLabel$default(string3, color, 0, 0, false, 14, null));
        } else if (((CharSequence)this.city.getDemandedResource()).length() > 0) {
            Group group = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, this.city.getDemandedResource(), 20.0f, 0, 4, null);
            String string4 = "Demanding [" + this.city.getDemandedResource() + ']';
            Color color = Color.CORAL;
            Intrinsics.checkNotNullExpressionValue(color, "CORAL");
            pair = TuplesKt.to(group, Scene2dExtensionsKt.toLabel$default(string4, color, 0, 0, true, 6, null));
        } else {
            pair = TuplesKt.to(null, null);
        }
        object = pair;
        Actor actor = (Actor)((Pair)object).component1();
        Label wltkLabel = (Label)((Pair)object).component2();
        if (wltkLabel != null) {
            void $this$addText_u24lambda_u245;
            Table table3;
            resourceIcon = table3 = new Table();
            table2 = tableWithIcons;
            boolean bl = false;
            Actor actor2 = actor;
            Intrinsics.checkNotNull(actor2);
            $this$addText_u24lambda_u245.add(actor2).size(20.0f).padRight(5.0f);
            $this$addText_u24lambda_u245.add((Actor)wltkLabel).row();
            table2.add((Actor)table3);
            ActivationExtensionsKt.onClick(wltkLabel, () -> CityStatsTable.addText$lambda$6(this));
        }
        this.lowerTable.add((Actor)tableWithIcons).row();
    }

    private final void addCitizenManagement() {
        ExpanderTab expanderTab = new CitizenManagementTable(this.cityScreen).asExpander(() -> CityStatsTable.addCitizenManagement$lambda$0(this));
        this.lowerTable.add((Actor)expanderTab).growX().row();
    }

    private final void addSpecialistInfo() {
        ExpanderTab expanderTab = new SpecialistAllocationTable(this.cityScreen).asExpander(() -> CityStatsTable.addSpecialistInfo$lambda$0(this));
        this.lowerTable.add((Actor)expanderTab).growX().row();
    }

    private final void addReligionInfo() {
        ExpanderTab expanderTab = new CityReligionInfoTable(this.city.getReligion(), false, 2, null).asExpander(() -> CityStatsTable.addReligionInfo$lambda$0(this));
        this.lowerTable.add((Actor)expanderTab).growX().row();
    }

    /*
     * WARNING - void declaration
     */
    private final void addBuildingsInfo() {
        Object building;
        Table table2;
        Iterator iterator2;
        List wonders = new ArrayList();
        List specialistBuildings = new ArrayList();
        List otherBuildings = new ArrayList();
        Iterator<Building> iterator3 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator3.hasNext()) {
            Building building2;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            boolean bl = building2.isAnyWonder() ? wonders.add(building2) : (!building2.newSpecialists().isEmpty() ? specialistBuildings.add(building2) : otherBuildings.add(building2));
        }
        List $this$sortBy$iv = wonders;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Building it = (Building)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Building)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            });
        }
        $this$sortBy$iv = specialistBuildings;
        $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Building it = (Building)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Building)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            });
        }
        $this$sortBy$iv = otherBuildings;
        $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Building it = (Building)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Building)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            });
        }
        Table totalTable = new Table();
        this.addCategory(this.lowerTable, "Buildings", totalTable, KeyboardBinding.BuildingsDetail, false);
        if (!((Collection)specialistBuildings).isEmpty()) {
            void $this$addBuildingsInfo_u24lambda_u243;
            Table specialistBuildingsTable = new Table();
            totalTable.add().row();
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color, 0, 0.0f, 6, null);
            iterator2 = Scene2dExtensionsKt.toLabel("Specialist Buildings");
            Label label = iterator2;
            table2 = totalTable;
            boolean bl = false;
            $this$addBuildingsInfo_u24lambda_u243.setAlignment(1);
            table2.add((Actor)((Object)iterator2)).growX();
            Color color2 = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color2, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color2, 0, 0.0f, 6, null);
            for (Object e : specialistBuildings) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                building = (Building)e;
                this.addBuildingButton((Building)building, specialistBuildingsTable);
            }
            totalTable.add((Actor)specialistBuildingsTable).growX().right().row();
        }
        if (!((Collection)wonders).isEmpty()) {
            void $this$addBuildingsInfo_u24lambda_u244;
            Table wondersTable = new Table();
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color, 0, 0.0f, 6, null);
            iterator2 = Scene2dExtensionsKt.toLabel("Wonders");
            building = iterator2;
            table2 = totalTable;
            boolean bl = false;
            $this$addBuildingsInfo_u24lambda_u244.setAlignment(1);
            table2.add((Actor)((Object)iterator2)).growX();
            Color color3 = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color3, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color3, 0, 0.0f, 6, null);
            for (Object e : wonders) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                building = (Building)e;
                this.addBuildingButton((Building)building, wondersTable);
            }
            totalTable.add((Actor)wondersTable).growX().right().row();
        }
        if (!((Collection)otherBuildings).isEmpty()) {
            void $this$addBuildingsInfo_u24lambda_u245;
            Table regularBuildingsTable = new Table();
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color, 0, 0.0f, 6, null);
            iterator2 = Scene2dExtensionsKt.toLabel("Other");
            building = iterator2;
            table2 = totalTable;
            boolean bl = false;
            $this$addBuildingsInfo_u24lambda_u245.setAlignment(1);
            table2.add((Actor)((Object)iterator2)).growX();
            Color color4 = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color4, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color4, 0, 0.0f, 6, null);
            for (Object e : otherBuildings) {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                building = (Building)e;
                this.addBuildingButton((Building)building, regularBuildingsTable);
            }
            totalTable.add((Actor)regularBuildingsTable).growX().right().row();
        }
    }

    private final void addBuildingButton(Building building, Table destinationTable) {
        Table button = new Table();
        Table info = new Table();
        Table statsAndSpecialists = new Table();
        Group icon = ImageGetter.INSTANCE.getConstructionPortrait(building.getName(), 50.0f);
        boolean isFree = this.cityScreen.hasFreeBuilding$core(building);
        String displayName = isFree ? '{' + building.getName() + "} ({Free})" : building.getName();
        info.add((Actor)Scene2dExtensionsKt.toLabel$default(displayName, null, 18, 0, true, 5, null)).padBottom(5.0f).right().row();
        String stats = CollectionsKt.joinToString$default(Building.getStats$default(building, this.city, null, 2, null), " ", null, null, 0, null, CityStatsTable::addBuildingButton$lambda$0, 30, null);
        statsAndSpecialists.add((Actor)Scene2dExtensionsKt.toLabel$default(stats, null, 18, 0, false, 13, null)).right();
        Object assignedSpec = this.city.getPopulation().getNewSpecialists().clone();
        Table specialistIcons = new Table();
        for (Map.Entry entry : ((Map)building.newSpecialists()).entrySet()) {
            String specialistName = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            if (this.city.getRuleset().getSpecialists().get(specialistName) == null) continue;
            for (int i = 0; i < amount; ++i) {
                int it = i;
                boolean bl = false;
                if (((Number)((Counter)assignedSpec).get(specialistName)).intValue() > 0) {
                    Specialist specialist;
                    specialistIcons.add((Actor)ImageGetter.INSTANCE.getSpecialistIcon(specialist.getColorObject())).size(20.0f);
                    ((Counter)assignedSpec).add(specialistName, -1);
                    continue;
                }
                Color color = Color.GRAY;
                Intrinsics.checkNotNullExpressionValue(color, "GRAY");
                specialistIcons.add((Actor)ImageGetter.INSTANCE.getSpecialistIcon(color)).size(20.0f);
            }
        }
        statsAndSpecialists.add((Actor)specialistIcons).right();
        info.add((Actor)statsAndSpecialists).right();
        button.add((Actor)info).right().top().padRight(10.0f).padTop(5.0f);
        button.add((Actor)icon).right();
        ActivationExtensionsKt.onClick(button, () -> CityStatsTable.addBuildingButton$lambda$2(this, building));
        destinationTable.add((Actor)button).pad(1.0f).padBottom(2.0f).padTop(2.0f).expandX().right().row();
    }

    private final ExpanderTab addCategory(Table $this$addCategory, String category, Table showHideTable, KeyboardBinding toggleKey, boolean startsOpened) {
        String string = "CityInfo." + category;
        ExpanderTab expanderTab = new ExpanderTab(category, 18, null, startsOpened, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, string, toggleKey, () -> CityStatsTable.addCategory$lambda$0(this), arg_0 -> CityStatsTable.addCategory$lambda$1(showHideTable, arg_0), 500, null);
        $this$addCategory.add((Actor)expanderTab).growX().row();
        return expanderTab;
    }

    static /* synthetic */ ExpanderTab addCategory$default(CityStatsTable cityStatsTable, Table table2, String string, Table table3, KeyboardBinding keyboardBinding, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return cityStatsTable.addCategory(table2, string, table3, keyboardBinding, bl);
    }

    private final void addGreatPersonPointInfo(City city) {
        Table greatPeopleTable = new Table();
        GreatPersonPointsBreakdown gppBreakdown = new GreatPersonPointsBreakdown(city);
        if (gppBreakdown.getAllNames().isEmpty()) {
            return;
        }
        Counter<String> greatPersonPoints = gppBreakdown.sum();
        Iterator<String> iterator2 = gppBreakdown.getAllNames().iterator();
        while (iterator2.hasNext()) {
            ImageGetter.ProgressBar progressBar;
            Color color;
            BaseUnit greatPerson;
            String greatPersonName;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            int gppPerTurn = ((Number)greatPersonPoints.get(greatPersonName)).intValue();
            Table info = new Table();
            if (city.getRuleset().getUnits().get(greatPersonName) == null) continue;
            Color color2 = Color.GOLD;
            Intrinsics.checkNotNullExpressionValue(color2, "GOLD");
            info.add((Actor)Scene2dExtensionsKt.toGroup(ImageGetter.INSTANCE.getUnitIcon(greatPerson, color2), 20.0f)).left().padBottom(4.0f).padRight(5.0f);
            info.add((Actor)Scene2dExtensionsKt.toLabel$default('{' + greatPersonName + "} (+" + gppPerTurn + ')', null, 0, 0, true, 7, null)).left().padBottom(4.0f).expandX().row();
            int gppCurrent = ((Number)city.getCiv().getGreatPeople().getGreatPersonPointsCounter().get(greatPersonName)).intValue();
            int gppNeeded = city.getCiv().getGreatPeople().getPointsRequiredForGreatPerson(greatPersonName);
            float percent = (float)gppCurrent / (float)gppNeeded;
            ImageGetter.ProgressBar progressBar2 = new ImageGetter.ProgressBar(300.0f, 25.0f, false);
            Color color3 = color = ImageGetter.INSTANCE.getCHARCOAL().cpy();
            ImageGetter.ProgressBar progressBar3 = progressBar2;
            boolean bl = false;
            $this$addGreatPersonPointInfo_u24lambda_u240.a = 0.8f;
            Color color4 = color;
            Intrinsics.checkNotNullExpressionValue(color4, "apply(...)");
            progressBar3.setBackground(color4);
            Color color5 = Color.ORANGE;
            Intrinsics.checkNotNullExpressionValue(color5, "ORANGE");
            ImageGetter.ProgressBar.setProgress$default(progressBar2, color5, percent, 0.0f, 4, null);
            ImageGetter.ProgressBar $this$addGreatPersonPointInfo_u24lambda_u241 = progressBar = progressBar2;
            boolean bl2 = false;
            Image bar = ImageGetter.INSTANCE.getWhiteDot();
            bar.setColor(Color.GRAY);
            bar.setSize($this$addGreatPersonPointInfo_u24lambda_u241.getWidth() + 5.0f, $this$addGreatPersonPointInfo_u24lambda_u241.getHeight() + 5.0f);
            Scene2dExtensionsKt.center((Actor)bar, $this$addGreatPersonPointInfo_u24lambda_u241);
            $this$addGreatPersonPointInfo_u24lambda_u241.addActor(bar);
            bar.toBack();
            Color color6 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color6, "WHITE");
            progressBar2.setLabel(color6, "" + gppCurrent + '/' + gppNeeded, 14);
            info.add((Actor)progressBar2).colspan(2).left().expandX().row();
            ActivationExtensionsKt.onClick(info, () -> CityStatsTable.addGreatPersonPointInfo$lambda$2(this, gppBreakdown, greatPersonName));
            greatPeopleTable.add((Actor)info).growX().top().padBottom(10.0f);
            Group icon = ImageGetter.INSTANCE.getConstructionPortrait(greatPersonName, 50.0f);
            ActivationExtensionsKt.onClick(icon, () -> CityStatsTable.addGreatPersonPointInfo$lambda$3(this, gppBreakdown));
            greatPeopleTable.add((Actor)icon).row();
        }
        CityStatsTable.addCategory$default(this, this.lowerTable, "Great People", greatPeopleTable, KeyboardBinding.GreatPeopleDetail, false, 8, null);
    }

    private static final Unit detailedStatsButton$lambda$0$0(CityStatsTable this$0) {
        Popup.open$default(new DetailedStatsPopup(this$0.cityScreen), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(CityStatsTable this$0) {
        this$0.cityScreen.updateWithoutConstructionAndMap$core();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CityStatsTable this$0, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.lowerCell = it.add((Actor)this$0.lowerPane).grow();
        return Unit.INSTANCE;
    }

    private static final Unit addText$lambda$0(CityStatsTable this$0) {
        City.reassignPopulation$default(this$0.city, false, 1, null);
        this$0.cityScreen.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit addText$lambda$3(CityStatsTable this$0, TileResource $resource) {
        this$0.cityScreen.openCivilopedia($resource.makeLink());
        return Unit.INSTANCE;
    }

    private static final Unit addText$lambda$6(CityStatsTable this$0) {
        this$0.cityScreen.openCivilopedia("Tutorial/We Love The King Day");
        return Unit.INSTANCE;
    }

    private static final Unit addCitizenManagement$lambda$0(CityStatsTable this$0) {
        this$0.onContentResize();
        return Unit.INSTANCE;
    }

    private static final Unit addSpecialistInfo$lambda$0(CityStatsTable this$0) {
        this$0.onContentResize();
        return Unit.INSTANCE;
    }

    private static final Unit addReligionInfo$lambda$0(CityStatsTable this$0) {
        this$0.onContentResize();
        return Unit.INSTANCE;
    }

    private static final CharSequence addBuildingButton$lambda$0(Stats.StatValuePair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "" + (int)it.getValue() + it.getKey().getCharacter();
    }

    private static final Unit addBuildingButton$lambda$2(CityStatsTable this$0, Building $building) {
        this$0.cityScreen.selectConstruction($building);
        this$0.cityScreen.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit addCategory$lambda$0(CityStatsTable this$0) {
        this$0.onContentResize();
        return Unit.INSTANCE;
    }

    private static final Unit addCategory$lambda$1(Table $showHideTable, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.add((Actor)$showHideTable).fillX().right();
        return Unit.INSTANCE;
    }

    private static final Unit addGreatPersonPointInfo$lambda$2(CityStatsTable this$0, GreatPersonPointsBreakdown $gppBreakdown, String $greatPersonName) {
        new GreatPersonPointsBreakdownPopup(this$0.cityScreen, $gppBreakdown, $greatPersonName);
        return Unit.INSTANCE;
    }

    private static final Unit addGreatPersonPointInfo$lambda$3(CityStatsTable this$0, GreatPersonPointsBreakdown $gppBreakdown) {
        new GreatPersonPointsBreakdownPopup(this$0.cityScreen, $gppBreakdown, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0017\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityStatsTable$MiniStatsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "wasOpen", "", "<init>", "(Lcom/unciv/ui/screens/cityscreen/CityStatsTable;Ljava/lang/Boolean;)V", "update", "", "expanderIsOpen", "(Ljava/lang/Boolean;)V", "core"})
    private final class MiniStatsTable
    extends Table {
        public MiniStatsTable(Boolean wasOpen) {
            this.update(wasOpen);
            this.pack();
        }

        public final void update() {
            this.update(CityStatsTable.this.expander.isOpen());
        }

        private final void update(Boolean expanderIsOpen) {
            this.clear();
            Color selected = BaseScreen.Companion.getSkin().getColor("selection");
            for (Stat stat : Stat.getEntries()) {
                float f;
                CityFocus toggledFocus;
                CityFocus cityFocus;
                float amount = CityStatsTable.this.city.getCityStats().getCurrentCityStats().get(stat);
                if (stat == Stat.Faith && !CityStatsTable.this.city.getCiv().getGameInfo().isReligionEnabled()) continue;
                Table icon = new Table();
                CityFocus focus = CityFocus.Companion.safeValueOf(stat);
                if (focus == CityStatsTable.this.city.getCityFocus()) {
                    Actor actor = ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, stat.name(), 0.0f, 2, null);
                    Intrinsics.checkNotNull(selected);
                    icon.add((Actor)Scene2dExtensionsKt.surroundWithCircle$default(actor, 27.0f, false, selected, null, 8, null));
                    cityFocus = CityFocus.NoFocus;
                } else {
                    Actor actor = ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, stat.name(), 0.0f, 2, null);
                    Color color = Color.CLEAR;
                    Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
                    icon.add((Actor)Scene2dExtensionsKt.surroundWithCircle$default(actor, 27.0f, false, color, null, 8, null));
                    cityFocus = toggledFocus = focus;
                }
                if (CityStatsTable.this.cityScreen.canCityBeChanged()) {
                    ActivationExtensionsKt.onActivation$default(icon, null, toggledFocus.getBinding(), () -> MiniStatsTable.update$lambda$0(CityStatsTable.this, toggledFocus), 1, null);
                }
                this.add((Actor)icon).size(27.0f).padRight(3.0f);
                if (stat == Stat.Happiness) {
                    Collection<Float> collection = CityStatsTable.this.city.getCityStats().getHappinessList().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    f = CollectionsKt.sumOfFloat((Iterable<Float>)collection);
                } else {
                    f = amount;
                }
                float valueToDisplay = f;
                this.add((Actor)Scene2dExtensionsKt.toLabel((int)Math.rint(valueToDisplay))).padRight(5.0f);
                if (!CityStatsTable.this.cityScreen.isCrampedPortrait() || expanderIsOpen != null && expanderIsOpen.booleanValue() || stat != Stat.Gold) continue;
                this.row();
            }
        }

        private static final Unit update$lambda$0(CityStatsTable this$0, CityFocus $toggledFocus) {
            this$0.city.setCityFocus($toggledFocus);
            City.reassignPopulation$default(this$0.city, false, 1, null);
            this$0.cityScreen.update$core();
            return Unit.INSTANCE;
        }
    }
}

