/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.validation.ModCompatibility;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.modmanager.ModManagementScreen;
import com.unciv.ui.screens.newgamescreen.NewGameModCheckHelpersKt;
import com.unciv.utils.Concurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00010BM\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0004J\u0006\u0010\"\u001a\u00020\rJ\b\u0010#\u001a\u00020\nH\u0002J\u0018\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012H\u0002J\u0012\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010&H\u0002J\b\u0010*\u001a\u00020\rH\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120,H\u0002J\u000e\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "mods", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "initialBaseRuleset", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "isPortrait", "", "onUpdate", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/LinkedHashSet;Ljava/lang/String;Lcom/unciv/ui/screens/basescreen/BaseScreen;ZLkotlin/jvm/functions/Function1;)V", "baseRulesetName", "baseRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "modWidgets", "Ljava/util/ArrayList;", "Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable$ModWithCheckBox;", "Lkotlin/collections/ArrayList;", "savedModcheckResult", "getSavedModcheckResult", "()Ljava/lang/String;", "setSavedModcheckResult", "(Ljava/lang/String;)V", "disableChangeEvents", "expanderPadTop", "", "updateSelection", "setBaseRuleset", "newBaseRulesetName", "disableAllCheckboxes", "complexModCheckReturnsErrors", "checkBoxChanged", "checkBox", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "mod", "deselectIncompatibleMods", "skipCheckBox", "disableIncompatibleMods", "getSelectedMods", "", "changeGameParameters", "newGameParameters", "Lcom/unciv/models/metadata/GameParameters;", "ModWithCheckBox", "core"})
@SourceDebugExtension(value={"SMAP\nModCheckboxTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModCheckboxTable.kt\ncom/unciv/ui/screens/newgamescreen/ModCheckboxTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n774#2:244\n865#2,2:245\n1056#2:247\n774#2:248\n865#2,2:249\n*S KotlinDebug\n*F\n+ 1 ModCheckboxTable.kt\ncom/unciv/ui/screens/newgamescreen/ModCheckboxTable\n*L\n55#1:244\n55#1:245,2\n59#1:247\n94#1:248\n94#1:249,2\n*E\n"})
public final class ModCheckboxTable
extends Table {
    @NotNull
    private LinkedHashSet<String> mods;
    @NotNull
    private final BaseScreen screen;
    @NotNull
    private final Function1<String, Unit> onUpdate;
    @NotNull
    private String baseRulesetName;
    private Ruleset baseRuleset;
    @NotNull
    private final ArrayList<ModWithCheckBox> modWidgets;
    @Nullable
    private String savedModcheckResult;
    private boolean disableChangeEvents;
    private final float expanderPadTop;

    /*
     * WARNING - void declaration
     */
    public ModCheckboxTable(@NotNull LinkedHashSet<String> mods, @NotNull String initialBaseRuleset, @NotNull BaseScreen screen, boolean isPortrait, @NotNull Function1<? super String, Unit> onUpdate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(mods, "mods");
        Intrinsics.checkNotNullParameter(initialBaseRuleset, "initialBaseRuleset");
        Intrinsics.checkNotNullParameter(screen, "screen");
        Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
        this.mods = mods;
        this.screen = screen;
        this.onUpdate = onUpdate;
        this.baseRulesetName = "";
        this.modWidgets = new ArrayList();
        this.expanderPadTop = isPortrait ? 0.0f : 16.0f;
        Collection<Ruleset> collection = RulesetCache.INSTANCE.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ruleset it = (Ruleset)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!ModCompatibility.INSTANCE.isExtensionMod(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modRulesets = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = modRulesets;
        boolean $i$f$sortedBy = false;
        for (Ruleset mod : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Ruleset it = (Ruleset)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Ruleset)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        })) {
            CheckBox checkBox = Scene2dExtensionsKt.toCheckBox$default(mod.getName(), this.mods.contains(mod.getName()), null, 2, null);
            checkBox.setText(ModManagementScreen.Companion.cleanModName(mod.getName()));
            ActivationExtensionsKt.onChange(checkBox, arg_0 -> ModCheckboxTable._init_$lambda$2(this, checkBox, mod, arg_0));
            checkBox.left();
            ((Collection)this.modWidgets).add(new ModWithCheckBox(mod, checkBox));
        }
        this.setBaseRuleset(initialBaseRuleset);
    }

    public /* synthetic */ ModCheckboxTable(LinkedHashSet linkedHashSet, String string, BaseScreen baseScreen, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(linkedHashSet, string, baseScreen, bl, function1);
    }

    @Nullable
    public final String getSavedModcheckResult() {
        return this.savedModcheckResult;
    }

    public final void setSavedModcheckResult(@Nullable String string) {
        this.savedModcheckResult = string;
    }

    public final void updateSelection() {
        this.savedModcheckResult = null;
        this.disableChangeEvents = true;
        Iterator<ModWithCheckBox> iterator2 = this.modWidgets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<ModWithCheckBox> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ModWithCheckBox mod;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            mod.getWidget().setChecked(this.mods.contains(mod.getMod().getName()));
        }
        this.disableChangeEvents = false;
        this.deselectIncompatibleMods(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBaseRuleset(@NotNull String newBaseRulesetName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(newBaseRulesetName, "newBaseRulesetName");
        Ruleset ruleset = (Ruleset)RulesetCache.INSTANCE.get((Object)newBaseRulesetName);
        if (ruleset == null) {
            this.setBaseRuleset(BaseRuleset.Civ_V_GnK.getFullName());
            return;
        }
        Ruleset newBaseRuleset = ruleset;
        this.baseRulesetName = newBaseRulesetName;
        this.baseRuleset = newBaseRuleset;
        this.savedModcheckResult = null;
        this.clear();
        this.mods.clear();
        Iterable iterable = this.modWidgets;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModWithCheckBox it = (ModWithCheckBox)element$iv$iv;
            boolean bl = false;
            Ruleset ruleset2 = it.getMod();
            Ruleset ruleset3 = this.baseRuleset;
            if (ruleset3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("baseRuleset");
                ruleset3 = null;
            }
            if (!ModCompatibility.INSTANCE.meetsBaseRequirements(ruleset2, ruleset3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List compatibleMods = (List)destination$iv$iv;
        if (CollectionsKt.none(compatibleMods)) {
            return;
        }
        for (ModWithCheckBox mod : compatibleMods) {
            if (!mod.getWidget().isChecked()) continue;
            ((Collection)this.mods).add(mod.getMod().getName());
        }
        this.add((Actor)new ExpanderTab("Extension mods", 0, null, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "NewGameExpansionMods", null, null, arg_0 -> ModCheckboxTable.setBaseRuleset$lambda$1(compatibleMods, arg_0), 3566, null)).padTop(this.expanderPadTop).growX().row();
        this.disableIncompatibleMods();
        Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ModCheckboxTable this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        ModCheckboxTable.access$complexModCheckReturnsErrors(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public final void disableAllCheckboxes() {
        this.disableChangeEvents = true;
        Iterator<ModWithCheckBox> iterator2 = this.modWidgets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<ModWithCheckBox> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ModWithCheckBox mod;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            mod.getWidget().setChecked(false);
        }
        this.mods.clear();
        this.disableChangeEvents = false;
        this.savedModcheckResult = null;
        this.disableIncompatibleMods();
        this.onUpdate.invoke("-");
    }

    private final boolean complexModCheckReturnsErrors() {
        RulesetErrorList complexModLinkCheck = (RulesetErrorList)RulesetCache.checkCombinedModLinks$default(RulesetCache.INSTANCE, this.mods, this.baseRulesetName, false, 4, null).component2();
        if (!complexModLinkCheck.isWarnUser()) {
            this.savedModcheckResult = null;
            return false;
        }
        this.savedModcheckResult = RulesetErrorList.getErrorText$default(complexModLinkCheck, false, 1, null);
        NewGameModCheckHelpersKt.showWarnOrErrorToast(complexModLinkCheck, this.screen);
        return complexModLinkCheck.isError();
    }

    private final void checkBoxChanged(CheckBox checkBox, Ruleset mod) {
        if (this.disableChangeEvents) {
            return;
        }
        if (checkBox.isChecked()) {
            RulesetErrorList modLinkErrors = Ruleset.getErrorList$default(mod, false, 1, null);
            if (modLinkErrors.isError()) {
                NewGameModCheckHelpersKt.showWarnOrErrorToast(modLinkErrors, this.screen);
                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(checkBox, null){
                    int label;
                    final /* synthetic */ CheckBox $checkBox;
                    {
                        this.$checkBox = $checkBox;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                this.$checkBox.setChecked(false);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
                return;
            }
            this.mods.add(mod.getName());
            if (this.complexModCheckReturnsErrors()) {
                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(checkBox, null){
                    int label;
                    final /* synthetic */ CheckBox $checkBox;
                    {
                        this.$checkBox = $checkBox;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                this.$checkBox.setChecked(false);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
                this.mods.remove(mod.getName());
                this.savedModcheckResult = null;
                return;
            }
        } else {
            this.mods.remove(mod.getName());
            if (this.complexModCheckReturnsErrors()) {
                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(checkBox, null){
                    int label;
                    final /* synthetic */ CheckBox $checkBox;
                    {
                        this.$checkBox = $checkBox;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                this.$checkBox.setChecked(true);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
                this.mods.add(mod.getName());
                this.savedModcheckResult = null;
                return;
            }
        }
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, mod, null){
            int label;
            final /* synthetic */ ModCheckboxTable this$0;
            final /* synthetic */ Ruleset $mod;
            {
                this.this$0 = $receiver;
                this.$mod = $mod;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        ModCheckboxTable.access$disableIncompatibleMods(this.this$0);
                        ModCheckboxTable.access$getOnUpdate$p(this.this$0).invoke(this.$mod.getName());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void deselectIncompatibleMods(CheckBox skipCheckBox) {
        this.disableChangeEvents = true;
        Iterator<ModWithCheckBox> iterator2 = this.modWidgets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<ModWithCheckBox> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ModWithCheckBox modWidget;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (Intrinsics.areEqual(modWidget.getWidget(), skipCheckBox)) continue;
            Ruleset ruleset = modWidget.getMod();
            Ruleset ruleset2 = this.baseRuleset;
            if (ruleset2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("baseRuleset");
                ruleset2 = null;
            }
            if (ModCompatibility.INSTANCE.meetsAllRequirements(ruleset, ruleset2, this.getSelectedMods())) continue;
            modWidget.getWidget().setChecked(false);
            this.mods.remove(modWidget.getMod().getName());
        }
        this.disableChangeEvents = false;
    }

    private final void disableIncompatibleMods() {
        Iterator<ModWithCheckBox> iterator2 = this.modWidgets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<ModWithCheckBox> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            boolean enable;
            ModWithCheckBox modWidget;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Ruleset ruleset = modWidget.getMod();
            Ruleset ruleset2 = this.baseRuleset;
            if (ruleset2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("baseRuleset");
                ruleset2 = null;
            }
            if (!(enable = ModCompatibility.INSTANCE.meetsAllRequirements(ruleset, ruleset2, this.getSelectedMods())) && modWidget.getWidget().isChecked()) {
                modWidget.getWidget().setChecked(false);
            }
            modWidget.getWidget().setDisabled(!enable);
        }
    }

    private final Iterable<Ruleset> getSelectedMods() {
        return SequencesKt.asIterable(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.modWidgets), ModCheckboxTable::getSelectedMods$lambda$0), ModCheckboxTable::getSelectedMods$lambda$1));
    }

    public final void changeGameParameters(@NotNull GameParameters newGameParameters) {
        Intrinsics.checkNotNullParameter(newGameParameters, "newGameParameters");
        this.mods = newGameParameters.getMods();
    }

    private static final Unit _init_$lambda$2(ModCheckboxTable this$0, CheckBox $checkBox, Ruleset $mod, ChangeListener.ChangeEvent it) {
        Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $checkBox, $mod, null){
            int label;
            final /* synthetic */ ModCheckboxTable this$0;
            final /* synthetic */ CheckBox $checkBox;
            final /* synthetic */ Ruleset $mod;
            {
                this.this$0 = $receiver;
                this.$checkBox = $checkBox;
                this.$mod = $mod;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        ModCheckboxTable.access$checkBoxChanged(this.this$0, this.$checkBox, this.$mod);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        return Unit.INSTANCE;
    }

    private static final Unit setBaseRuleset$lambda$1(List $compatibleMods, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Cell cell = it.defaults();
        Intrinsics.checkNotNullExpressionValue(cell, "defaults(...)");
        Scene2dExtensionsKt.pad(cell, 5.0f, 0.0f);
        UncivTextField searchModsTextField = new UncivTextField("Search mods", null, null, 6, null);
        if ($compatibleMods.size() > 10) {
            it.add((Actor)searchModsTextField).row();
        }
        Table modsTable = new Table();
        modsTable.defaults().pad(5.0f);
        it.add((Actor)modsTable);
        ModCheckboxTable.setBaseRuleset$lambda$1$populateModsTable(modsTable, searchModsTextField, $compatibleMods);
        ActivationExtensionsKt.onChange(searchModsTextField, arg_0 -> ModCheckboxTable.setBaseRuleset$lambda$1$0(modsTable, searchModsTextField, $compatibleMods, arg_0));
        return Unit.INSTANCE;
    }

    private static final void setBaseRuleset$lambda$1$populateModsTable(Table modsTable, UncivTextField searchModsTextField, List<ModWithCheckBox> compatibleMods) {
        modsTable.clear();
        String string = searchModsTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String searchText = string2;
        for (ModWithCheckBox mod : compatibleMods) {
            if (!(((CharSequence)searchText).length() == 0)) {
                String string3 = mod.getMod().getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                if (!StringsKt.contains$default((CharSequence)string3, searchText, false, 2, null)) continue;
            }
            modsTable.add((Actor)mod.getWidget()).left().row();
        }
    }

    private static final Unit setBaseRuleset$lambda$1$0(Table $modsTable, UncivTextField $searchModsTextField, List $compatibleMods, ChangeListener.ChangeEvent it) {
        ModCheckboxTable.setBaseRuleset$lambda$1$populateModsTable($modsTable, $searchModsTextField, $compatibleMods);
        return Unit.INSTANCE;
    }

    private static final boolean getSelectedMods$lambda$0(ModWithCheckBox it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getWidget().isChecked();
    }

    private static final Ruleset getSelectedMods$lambda$1(ModWithCheckBox it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getMod();
    }

    public static final /* synthetic */ boolean access$complexModCheckReturnsErrors(ModCheckboxTable $this) {
        return $this.complexModCheckReturnsErrors();
    }

    public static final /* synthetic */ void access$disableIncompatibleMods(ModCheckboxTable $this) {
        $this.disableIncompatibleMods();
    }

    public static final /* synthetic */ Function1 access$getOnUpdate$p(ModCheckboxTable $this) {
        return $this.onUpdate;
    }

    public static final /* synthetic */ void access$checkBoxChanged(ModCheckboxTable $this, CheckBox checkBox, Ruleset mod) {
        $this.checkBoxChanged(checkBox, mod);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable$ModWithCheckBox;", "", "mod", "Lcom/unciv/models/ruleset/Ruleset;", "widget", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;)V", "getMod", "()Lcom/unciv/models/ruleset/Ruleset;", "getWidget", "()Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "core"})
    private static final class ModWithCheckBox {
        @NotNull
        private final Ruleset mod;
        @NotNull
        private final CheckBox widget;

        public ModWithCheckBox(@NotNull Ruleset mod, @NotNull CheckBox widget) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(widget, "widget");
            this.mod = mod;
            this.widget = widget;
        }

        @NotNull
        public final Ruleset getMod() {
            return this.mod;
        }

        @NotNull
        public final CheckBox getWidget() {
            return this.widget;
        }
    }
}

