/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.VictoryManager;
import com.unciv.models.Counter;
import com.unciv.models.UncivSound;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B7\u0012&\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003j\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R.\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003j\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/unciv/ui/screens/pickerscreens/DiplomaticVoteResultScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "votesCast", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Ljava/util/HashMap;Lcom/unciv/logic/civilization/Civilization;)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "constructionNameUN", "civOwningUN", "addVote", "", "civ", "votesReceived", "", "core"})
public final class DiplomaticVoteResultScreen
extends PickerScreen {
    @NotNull
    private final HashMap<String, String> votesCast;
    @NotNull
    private final GameInfo gameInfo;
    @Nullable
    private final String constructionNameUN;
    @Nullable
    private final String civOwningUN;

    public DiplomaticVoteResultScreen(@NotNull HashMap<String, String> votesCast, @NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(votesCast, "votesCast");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        super(false, 1, null);
        this.votesCast = votesCast;
        this.gameInfo = viewingCiv.getGameInfo();
        this.getCloseButton().remove();
        this.getTopTable().pad(10.0f);
        this.getTopTable().defaults().space(15.0f);
        Pair<String, String> findUN = viewingCiv.getVictoryManager().getUNBuildingAndOwnerNames();
        this.constructionNameUN = findUN.getFirst();
        this.civOwningUN = findUN.getSecond();
        VictoryManager.DiplomaticVictoryVoteBreakdown diplomaticVictoryVoteBreakdown = viewingCiv.getVictoryManager().getDiplomaticVictoryVoteBreakdown();
        Counter<String> results = diplomaticVictoryVoteBreakdown.component1();
        String winnerText = diplomaticVictoryVoteBreakdown.component2();
        Sequence orderedCivs = GameInfo.getCivsSorted$default(this.gameInfo, false, false, viewingCiv, null, 11, null);
        Iterator iterator2 = orderedCivs.iterator();
        while (iterator2.hasNext()) {
            Civilization civ = (Civilization)iterator2.next();
            this.addVote(civ, ((Number)results.get(civ.getCivID())).intValue());
        }
        this.getDescriptionLabel().setAlignment(1);
        this.getDescriptionLabel().setText(TranslationsKt.tr$default(winnerText, false, false, 3, null));
        ActivationExtensionsKt.onActivation(this.getRightSideButton(), UncivSound.Companion.getClick(), () -> DiplomaticVoteResultScreen._init_$lambda$0(viewingCiv, this));
        ActivationExtensionsKt.getKeyShortcuts(this.getRightSideButton()).add(KeyCharAndCode.Companion.getBACK());
        ActivationExtensionsKt.getKeyShortcuts(this.getRightSideButton()).add(KeyCharAndCode.Companion.getSPACE());
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        this.getRightSideButton().setText(TranslationsKt.tr$default("Continue", false, false, 3, null));
        this.getBottomTable().getCells().get(0).minWidth(this.getRightSideButton().getPrefWidth() + 20.0f);
    }

    @NotNull
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    private final void addVote(Civilization civ, int votesReceived) {
        Cell<Actor> cell;
        String civName = civ.getCivName();
        Cell<Actor> cell2 = civ.isMajorCiv() ? this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel(votesReceived)) : this.getTopTable().add();
        this.getTopTable().add((Actor)ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 30.0f));
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel$default(civName, null, 0, 0, true, 7, null)).padLeft(20.0f).padRight(20.0f);
        if (Intrinsics.areEqual(civ.getCivID(), this.civOwningUN) && this.constructionNameUN != null) {
            this.getTopTable().add((Actor)ImageGetter.INSTANCE.getConstructionPortrait(this.constructionNameUN, 30.0f));
            cell = this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("[2] votes"));
        } else {
            cell = this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("[1] vote")).colspan(2);
        }
        String string = this.votesCast.get(civ.getCivID());
        if (string == null) {
            DiplomaticVoteResultScreen.addVote$abstained(this);
            return;
        }
        String votedCivName = string;
        Civilization votedCiv = this.gameInfo.getCivilization(votedCivName);
        if (votedCiv.isDefeated()) {
            DiplomaticVoteResultScreen.addVote$abstained(this);
            return;
        }
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("Voted for")).padLeft(20.0f);
        this.getTopTable().add((Actor)ImageGetter.INSTANCE.getNationPortrait(votedCiv.getNation(), 30.0f));
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel$default(votedCiv.getCivName(), null, 0, 0, true, 7, null));
        this.getTopTable().row();
    }

    private static final Unit _init_$lambda$0(Civilization $viewingCiv, DiplomaticVoteResultScreen this$0) {
        $viewingCiv.addFlag("ShowDiplomaticVotingResults", -1);
        UncivGame.popScreen$default(this$0.getGame(), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final void addVote$abstained(DiplomaticVoteResultScreen this$0) {
        this$0.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("Abstained")).colspan(3).row();
    }
}

