/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.GreatPersonManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.pickerscreens.PickerPane;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/pickerscreens/GreatPersonPickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lcom/unciv/logic/civilization/Civilization;)V", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "theChosenOne", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "confirmAction", "", "useMayaLongCount", "", "core"})
public final class GreatPersonPickerScreen
extends PickerScreen {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final Civilization civInfo;
    @Nullable
    private BaseUnit theChosenOne;

    public GreatPersonPickerScreen(@NotNull WorldScreen worldScreen, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        super(false, 1, null);
        this.worldScreen = worldScreen;
        this.civInfo = civInfo;
        this.worldScreen.getAutoPlay().stopAutoPlay();
        this.getCloseButton().setVisible(false);
        this.getRightSideButton().setText(TranslationsKt.tr$default("Choose a free great person", false, false, 3, null));
        HashSet<BaseUnit> greatPersonUnits = this.civInfo.getGreatPeople().getGreatPeople();
        boolean useMayaLongCount = this.civInfo.getGreatPeople().getMayaLimitedFreeGP() > 0;
        Iterator<BaseUnit> iterator2 = greatPersonUnits.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<BaseUnit> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            BaseUnit unit;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Button button = PickerPane.Companion.getPickerOptionButton(ImageGetter.getUnitIcon$default(ImageGetter.INSTANCE, unit, null, 2, null), unit.getName());
            button.pack();
            Scene2dExtensionsKt.setEnabled(button, !useMayaLongCount || this.civInfo.getGreatPeople().getLongCountGPPool().contains(unit.getName()));
            if (Scene2dExtensionsKt.isEnabled(button)) {
                ActivationExtensionsKt.onClick(button, () -> GreatPersonPickerScreen._init_$lambda$0(this, unit));
                ActivationExtensionsKt.onDoubleClick(button, UncivSound.Companion.getChoir(), () -> GreatPersonPickerScreen._init_$lambda$1(this, useMayaLongCount));
            }
            this.getTopTable().add((Actor)button).pad(10.0f).row();
        }
        ActivationExtensionsKt.onClick(this.getRightSideButton(), UncivSound.Companion.getChoir(), () -> GreatPersonPickerScreen._init_$lambda$2(this, useMayaLongCount));
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    private final void confirmAction(boolean useMayaLongCount) {
        UnitManager unitManager = this.civInfo.getUnits();
        BaseUnit baseUnit = this.theChosenOne;
        Intrinsics.checkNotNull(baseUnit);
        unitManager.addUnit(baseUnit, Civilization.getCapital$default(this.civInfo, false, 1, null));
        GreatPersonManager greatPersonManager = this.civInfo.getGreatPeople();
        int n = greatPersonManager.getFreeGreatPeople();
        greatPersonManager.setFreeGreatPeople(n + -1);
        if (useMayaLongCount) {
            greatPersonManager = this.civInfo.getGreatPeople();
            n = greatPersonManager.getMayaLimitedFreeGP();
            greatPersonManager.setMayaLimitedFreeGP(n + -1);
            HashSet<String> hashSet = this.civInfo.getGreatPeople().getLongCountGPPool();
            BaseUnit baseUnit2 = this.theChosenOne;
            Intrinsics.checkNotNull(baseUnit2);
            hashSet.remove(baseUnit2.getName());
        }
        UncivGame.popScreen$default(UncivGame.Companion.getCurrent(), false, 1, null);
    }

    private static final Unit _init_$lambda$0(GreatPersonPickerScreen this$0, BaseUnit $unit) {
        this$0.theChosenOne = $unit;
        this$0.pick(TranslationsKt.tr$default("Get [" + $unit.getName() + ']', false, false, 3, null));
        this$0.getDescriptionLabel().setText(BaseUnit.getShortDescription$default($unit, null, 1, null));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(GreatPersonPickerScreen this$0, boolean $useMayaLongCount) {
        this$0.confirmAction($useMayaLongCount);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(GreatPersonPickerScreen this$0, boolean $useMayaLongCount) {
        this$0.confirmAction($useMayaLongCount);
        return Unit.INSTANCE;
    }
}

