/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.NonTransformGroup;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.pickerscreens.TechButton;
import com.unciv.ui.screens.pickerscreens.TechPickerScreen;
import com.unciv.utils.Concurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008b\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003*\u0001\u001f\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010-\u001a\u00020\rH\u0016J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020/H\u0002J\b\u00101\u001a\u00020/H\u0002J\b\u00102\u001a\u00020/H\u0002J\b\u00103\u001a\u00020/H\u0002J0\u00104\u001a\u00020/2\b\u00105\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00106\u001a\u00020\u000b2\b\b\u0002\u00107\u001a\u00020\u000b2\b\b\u0002\u00108\u001a\u00020\u000bH\u0002J\u0016\u00109\u001a\u00020\u00102\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100;H\u0003J\u0010\u0010<\u001a\u00020/2\u0006\u00105\u001a\u00020\u0005H\u0002J\u0010\u0010=\u001a\u00020/2\u0006\u00105\u001a\u00020\u0005H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0017j\b\u0012\u0004\u0012\u00020\u0010`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u0017j\b\u0012\u0004\u0012\u00020\u001d`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R(\u0010!\u001a\u001c\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b#0\"j\r\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b#`$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/unciv/ui/screens/pickerscreens/TechPickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "centerOnTech", "Lcom/unciv/models/ruleset/tech/Technology;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/models/ruleset/tech/Technology;)V", "getCivInfo$core", "()Lcom/unciv/logic/civilization/Civilization;", "freeTechPick", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "techNameToButton", "Ljava/util/HashMap;", "", "Lcom/unciv/ui/screens/pickerscreens/TechButton;", "Lkotlin/collections/HashMap;", "selectedTech", "civTech", "Lcom/unciv/logic/civilization/managers/TechManager;", "tempTechsToResearch", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "lines", "Lcom/unciv/ui/components/NonTransformGroup;", "orderIndicators", "eraLabels", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "techTable", "com/unciv/ui/screens/pickerscreens/TechPickerScreen$techTable$1", "Lcom/unciv/ui/screens/pickerscreens/TechPickerScreen$techTable$1;", "researchableTechs", "Ljava/util/HashSet;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lkotlin/collections/HashSet;", "currentTechColor", "Lcom/badlogic/gdx/graphics/Color;", "researchedTechColor", "researchableTechColor", "queuedTechColor", "researchedFutureTechColor", "turnsToTech", "", "getCivilopediaRuleset", "tryExit", "", "createTechTable", "setButtonsInfo", "addConnectingLines", "addOrderIndicators", "selectTechnology", "tech", "queue", "center", "switchFromWorldScreen", "getTechProgressLabel", "techs", "", "centerOnTechnology", "selectTechnologyForFreeTech", "core"})
@SourceDebugExtension(value={"SMAP\nTechPickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TechPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/TechPickerScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,472:1\n774#2:473\n865#2,2:474\n1222#2,2:476\n1252#2,4:478\n774#2:483\n865#2,2:484\n1869#2,2:486\n774#2:488\n865#2,2:489\n1563#2:491\n1634#2,3:492\n1#3:482\n*S KotlinDebug\n*F\n+ 1 TechPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/TechPickerScreen\n*L\n63#1:473\n63#1:474,2\n71#1:476,2\n71#1:478,4\n352#1:483\n352#1:484,2\n353#1:486,2\n416#1:488\n416#1:489,2\n431#1:491\n431#1:492,3\n*E\n"})
public final class TechPickerScreen
extends PickerScreen {
    @NotNull
    private final Civilization civInfo;
    private final boolean freeTechPick;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private HashMap<String, TechButton> techNameToButton;
    @Nullable
    private Technology selectedTech;
    @NotNull
    private TechManager civTech;
    @NotNull
    private ArrayList<String> tempTechsToResearch;
    @NotNull
    private NonTransformGroup lines;
    @NotNull
    private NonTransformGroup orderIndicators;
    @NotNull
    private ArrayList<Label> eraLabels;
    @NotNull
    private final techTable.1 techTable;
    @NotNull
    private HashSet<String> researchableTechs;
    @NotNull
    private final Color currentTechColor;
    @NotNull
    private final Color researchedTechColor;
    @NotNull
    private final Color researchableTechColor;
    @NotNull
    private final Color queuedTechColor;
    @NotNull
    private final Color researchedFutureTechColor;
    @NotNull
    private final Map<String, String> turnsToTech;

    /*
     * WARNING - void declaration
     */
    public TechPickerScreen(@NotNull Civilization civInfo, @Nullable Technology centerOnTech) {
        Technology tech;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        super(false, 1, null);
        this.civInfo = civInfo;
        this.freeTechPick = this.civInfo.getTech().getFreeTechs() != 0;
        this.ruleset = this.civInfo.getGameInfo().getRuleset();
        this.techNameToButton = new HashMap();
        this.civTech = this.civInfo.getTech();
        this.lines = new NonTransformGroup();
        this.orderIndicators = new NonTransformGroup();
        this.eraLabels = new ArrayList();
        this.techTable = new Table(){

            public void draw(Batch batch, float parentAlpha) {
                super.draw(batch, parentAlpha);
            }
        };
        Set<String> set = this.ruleset.getTechnologies().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable iterable = set;
        TechPickerScreen techPickerScreen = this;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!this.civTech.canBeResearched(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        techPickerScreen.researchableTechs = CollectionsKt.toHashSet((List)destination$iv$iv);
        this.currentTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/CurrentTechColor", Scene2dExtensionsKt.colorFromRGB(72, 147, 175));
        this.researchedTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/ResearchedTechColor", Scene2dExtensionsKt.colorFromRGB(255, 215, 0));
        this.researchableTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/ResearchableTechColor", Scene2dExtensionsKt.colorFromRGB(28, 170, 0));
        this.queuedTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/QueuedTechColor", Scene2dExtensionsKt.colorFromRGB(14, 92, 86));
        this.researchedFutureTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/ResearchedFutureTechColor", Scene2dExtensionsKt.colorFromRGB(127, 50, 0));
        Collection<Technology> collection = this.ruleset.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        $this$filter$iv = collection;
        techPickerScreen = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Technology bl = (Technology)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Technology it = (Technology)element$iv$iv;
            String string = it.getName();
            boolean bl3 = false;
            String string2 = this.civTech.turnsToTech(it.getName());
            map2.put(string, string2);
        }
        techPickerScreen.turnsToTech = destination$iv$iv2;
        this.setDefaultCloseAction();
        this.getScrollPane().setOverscroll(false, false);
        ActivationExtensionsKt.onClick(this.getDescriptionLabel(), () -> TechPickerScreen._init_$lambda$0(this));
        this.tempTechsToResearch = new ArrayList(this.civTech.getTechsToResearch());
        this.createTechTable();
        this.setButtonsInfo();
        this.techTable.addActor(this.lines);
        this.techTable.addActor(this.orderIndicators);
        this.getTopTable().add((Actor)this.techTable);
        this.techTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "TechPickerScreen/Background", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getPickerPane().getBottomTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "TechPickerScreen/BottomTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getRightSideButton().setText(this.freeTechPick ? TranslationsKt.tr$default("Pick a free tech", false, false, 3, null) : TranslationsKt.tr$default("Pick a tech", false, false, 3, null));
        ActivationExtensionsKt.onClick(this.getRightSideButton(), UncivSound.Companion.getPaper(), () -> TechPickerScreen._init_$lambda$1(this));
        Technology technology = centerOnTech;
        if (technology == null) {
            technology = this.civInfo.getTech().currentTechnology();
        }
        if ((tech = technology) != null) {
            if (this.civInfo.getTech().isResearched(tech.getName()) || this.civInfo.getTech().getTechsToResearch().size() <= 1) {
                TechPickerScreen.selectTechnology$default(this, tech, false, true, false, 8, null);
            } else {
                this.centerOnTechnology(tech);
            }
        } else {
            String firstAvailable = (String)CollectionsKt.firstOrNull((Iterable)this.researchableTechs);
            Technology firstAvailableTech = (Technology)((Map)this.ruleset.getTechnologies()).get(firstAvailable);
            if (firstAvailableTech != null) {
                this.centerOnTechnology(firstAvailableTech);
            }
        }
    }

    public /* synthetic */ TechPickerScreen(Civilization civilization, Technology technology, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            technology = null;
        }
        this(civilization, technology);
    }

    @NotNull
    public final Civilization getCivInfo$core() {
        return this.civInfo;
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.ruleset;
    }

    private final void tryExit() {
        if (this.freeTechPick) {
            Technology technology = this.selectedTech;
            Intrinsics.checkNotNull(technology);
            String freeTech = technology.getName();
            if (!this.researchableTechs.contains(freeTech)) {
                return;
            }
            Technology technology2 = this.selectedTech;
            Intrinsics.checkNotNull(technology2);
            this.civTech.getFreeTechnology(technology2.getName());
        } else {
            this.civTech.setTechsToResearch(this.tempTechsToResearch);
        }
        this.civTech.updateResearchProgress();
        this.getGame().getSettings().addCompletedTutorialTask("Pick technology");
        UncivGame.popScreen$default(this.getGame(), false, 1, null);
    }

    private final void createTechTable() {
        int it532;
        Iterator<Label> iterator2 = this.eraLabels.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Label> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Label label;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            label.remove();
        }
        this.eraLabels.clear();
        Collection<Technology> collection = this.ruleset.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Collection<Technology> allTechs = collection;
        if (allTechs.isEmpty()) {
            return;
        }
        Iterator iterator4 = ((Iterable)allTechs).iterator();
        if (!iterator4.hasNext()) {
            throw new NoSuchElementException();
        }
        Technology it722262222 = (Technology)iterator4.next();
        boolean bl = false;
        TechColumn techColumn = it722262222.getColumn();
        Intrinsics.checkNotNull(techColumn);
        int it722262222 = techColumn.getColumnNumber();
        while (iterator4.hasNext()) {
            Technology it332 = (Technology)iterator4.next();
            boolean bl2 = false;
            TechColumn techColumn2 = it332.getColumn();
            Intrinsics.checkNotNull(techColumn2);
            int it332 = techColumn2.getColumnNumber();
            if (it722262222 >= it332) continue;
            it722262222 = it332;
        }
        int columns = it722262222 + 1;
        Iterator it722262222 = ((Iterable)allTechs).iterator();
        if (!it722262222.hasNext()) {
            throw new NoSuchElementException();
        }
        Technology it42422 = (Technology)it722262222.next();
        boolean bl2 = false;
        int it42422 = it42422.getRow();
        while (it722262222.hasNext()) {
            Technology it532 = (Technology)it722262222.next();
            boolean bl3 = false;
            it532 = it532.getRow();
            if (it42422 >= it532) continue;
            it42422 = it532;
        }
        int rows = it42422 + 1;
        int it722262222 = 0;
        Technology[][] it42422 = new Technology[columns][];
        while (it722262222 < columns) {
            it532 = it722262222++;
            it42422[it532] = new Technology[rows];
        }
        Technology[][] techMatrix = it42422;
        Iterator<Technology> it722262222 = allTechs.iterator();
        while (it722262222.hasNext()) {
            Iterator technology;
            Intrinsics.checkNotNullExpressionValue(it722262222.next(), "next(...)");
            TechColumn techColumn3 = ((Technology)((Object)technology)).getColumn();
            Intrinsics.checkNotNull(techColumn3);
            techMatrix[techColumn3.getColumnNumber()][((Technology)((Object)technology)).getRow() - 1] = technology;
        }
        LinkedHashMap erasNamesToColumns = new LinkedHashMap();
        for (Object e : allTechs) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Technology tech = (Technology)e;
            String era = tech.era();
            if (!erasNamesToColumns.containsKey(era)) {
                ((Map)erasNamesToColumns).put(era, new ArrayList());
            }
            TechColumn techColumn4 = tech.getColumn();
            Intrinsics.checkNotNull(techColumn4);
            int columnNumber = techColumn4.getColumnNumber();
            Object v = erasNamesToColumns.get(era);
            Intrinsics.checkNotNull(v);
            if (((ArrayList)v).contains(columnNumber)) continue;
            Object v2 = erasNamesToColumns.get(era);
            Intrinsics.checkNotNull(v2);
            ((ArrayList)v2).add(columnNumber);
        }
        for (Map.Entry tech : ((Map)erasNamesToColumns).entrySet()) {
            Label label;
            Color color;
            String era = (String)tech.getKey();
            ArrayList eraColumns = (ArrayList)tech.getValue();
            int columnSpan = eraColumns.size();
            if (Intrinsics.areEqual(this.civTech.getEra().getName(), era)) {
                color = this.queuedTechColor;
            } else {
                Era era2 = this.ruleset.getEras().get(era);
                Intrinsics.checkNotNull(era2);
                color = era2.getEraNumber() < this.civTech.getEra().getEraNumber() ? Scene2dExtensionsKt.colorFromRGB(255, 175, 0) : ImageGetter.INSTANCE.getCHARCOAL().cpy();
            }
            Color color2 = color;
            Table table1 = new Table().pad(1.0f);
            Table table2 = new Table();
            table1.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "General/Border", null, Color.WHITE, 2, null));
            table2.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "General/Border", null, color2, 2, null));
            Label $this$createTechTable_u24lambda_u242 = label = Scene2dExtensionsKt.toLabel(era);
            boolean bl3 = false;
            $this$createTechTable_u24lambda_u242.setAlignment(1);
            Era era3 = this.ruleset.getEras().get(era);
            Intrinsics.checkNotNull(era3);
            if (era3.getEraNumber() < this.civTech.getEra().getEraNumber()) {
                $this$createTechTable_u24lambda_u242.setColor(Scene2dExtensionsKt.colorFromRGB(120, 46, 16));
            }
            Label label2 = label;
            this.eraLabels.add(label2);
            table2.add((Actor)label2).growX();
            table1.add((Actor)table2).growX();
            this.techTable.add((Actor)table1).fill().colspan(columnSpan);
        }
        for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
            this.techTable.row();
            int n = ((Object[])techMatrix).length;
            for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
                Cell<Actor> cell;
                Technology tech = techMatrix[columnIndex][rowIndex];
                Table table2 = new Table().pad(2.0f).padRight(60.0f).padLeft(20.0f);
                if (rowIndex == 0) {
                    table2.padTop(7.0f);
                }
                ArrayList arrayList = (ArrayList)erasNamesToColumns.get(this.civTech.getEra().getName());
                boolean bl4 = arrayList != null ? arrayList.contains(columnIndex) : false;
                if (bl4) {
                    table2.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "TechPickerScreen/Background", null, Scene2dExtensionsKt.darken(this.queuedTechColor, 0.5f), 2, null));
                }
                if (tech == null) {
                    cell = this.techTable.add((Actor)table2).fill();
                    continue;
                }
                TechButton techButton = new TechButton(tech.getName(), this.civTech, false);
                table2.add((Actor)techButton);
                ((Map)this.techNameToButton).put(tech.getName(), techButton);
                ActivationExtensionsKt.onClick(techButton, () -> TechPickerScreen.createTechTable$lambda$3(this, tech));
                ActivationExtensionsKt.onRightClick$default(techButton, null, () -> TechPickerScreen.createTechTable$lambda$4(this, tech), 1, null);
                ActivationExtensionsKt.onDoubleClick(techButton, UncivSound.Companion.getPaper(), () -> TechPickerScreen.createTechTable$lambda$5(this));
                cell = this.techTable.add((Actor)table2).fillX();
            }
        }
    }

    private final void setButtonsInfo() {
        for (Map.Entry entry : ((Map)this.techNameToButton).entrySet()) {
            String techName = (String)entry.getKey();
            TechButton techButton = (TechButton)entry.getValue();
            boolean isResearched = this.civTech.isResearched(techName);
            Color color = isResearched && !Intrinsics.areEqual(techName, "Future Tech") ? this.researchedTechColor : (isResearched ? this.researchedFutureTechColor : (Intrinsics.areEqual(CollectionsKt.firstOrNull((List)this.tempTechsToResearch), techName) && !this.freeTechPick ? this.currentTechColor : (this.researchableTechs.contains(techName) ? this.researchableTechColor : (this.tempTechsToResearch.contains(techName) ? this.queuedTechColor : ImageGetter.INSTANCE.getCHARCOAL().cpy()))));
            Intrinsics.checkNotNull(color);
            techButton.setButtonColor(color);
            if (isResearched && !Intrinsics.areEqual(techName, "Future Tech")) {
                techButton.getText$core().setColor(Scene2dExtensionsKt.colorFromRGB(154, 98, 16));
            }
            if (!isResearched || Intrinsics.areEqual(techName, "Future Tech")) {
                techButton.getTurns$core().setText(this.turnsToTech.get(techName) + TranslationsKt.tr$default("\u23f3", false, false, 3, null));
            }
            techButton.getText$core().setText(TranslationsKt.tr$default(techName, true, false, 2, null));
        }
        this.addConnectingLines();
        this.addOrderIndicators();
    }

    /*
     * WARNING - void declaration
     */
    private final void addConnectingLines() {
        void $this$filterTo$iv$iv;
        Iterable techButton;
        Image line;
        this.techTable.pack();
        this.getScrollPane().updateVisualScroll();
        this.lines.clear();
        Iterator<Label> iterator2 = this.eraLabels.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Color color;
            Label eraLabel;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            Vector2 coords = new Vector2(0.0f, 0.0f);
            eraLabel.localToStageCoordinates(coords);
            this.techTable.stageToLocalCoordinates(coords);
            line = ImageGetter.INSTANCE.getLine(coords.x - 1.0f, coords.y, coords.x - 1.0f, coords.y - 1000.0f, 1.0f);
            Color color2 = color = Color.GRAY.cpy();
            Object image = line;
            boolean bl = false;
            $this$addConnectingLines_u24lambda_u240.a = 0.6f;
            ((Actor)image).setColor(color);
            line.toBack();
            this.lines.addActor(line);
        }
        for (Object object : this.ruleset.getTechnologies().values()) {
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            Technology tech = (Technology)object;
            if (!this.techNameToButton.containsKey(tech.getName())) {
                new ToastPopup("Tech " + tech.getName() + " appears to be missing - perhaps two techs have the same row & column", this, 0L, 4, null);
                continue;
            }
            Intrinsics.checkNotNull(this.techNameToButton.get(tech.getName()));
            Intrinsics.checkNotNullExpressionValue(tech.getPrerequisites().iterator(), "iterator(...)");
            while (line.hasNext()) {
                Image image;
                Object prerequisiteButton;
                Object e = line.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                String prerequisite = (String)e;
                if (!this.techNameToButton.containsKey(prerequisite)) {
                    new ToastPopup("Tech " + prerequisite + ". prerequisite of " + tech.getName() + ", appears to be missing - perhaps two techs have the same row & column", this, 0L, 4, null);
                    continue;
                }
                Intrinsics.checkNotNull(this.techNameToButton.get(prerequisite));
                Vector2 techButtonCoords = new Vector2(0.0f, ((Actor)((Object)techButton)).getHeight() / (float)2);
                ((Actor)((Object)techButton)).localToStageCoordinates(techButtonCoords);
                this.techTable.stageToLocalCoordinates(techButtonCoords);
                Vector2 prerequisiteCoords = new Vector2(((Actor)prerequisiteButton).getWidth(), ((Actor)prerequisiteButton).getHeight() / (float)2);
                ((Actor)prerequisiteButton).localToStageCoordinates(prerequisiteCoords);
                this.techTable.stageToLocalCoordinates(prerequisiteCoords);
                Color lineColor = this.civTech.isResearched(tech.getName()) && !tech.isContinuallyResearchable() ? Color.WHITE.cpy() : (this.civTech.isResearched(prerequisite) ? this.researchableTechColor : (this.tempTechsToResearch.contains(tech.getName()) ? this.currentTechColor : Color.WHITE.cpy()));
                float lineSize = this.tempTechsToResearch.contains(tech.getName()) && !this.civTech.isResearched(prerequisite) ? 4.0f : 2.0f;
                if (!(techButtonCoords.y == prerequisiteCoords.y)) {
                    Image image2;
                    float r = 6.0f;
                    float deltaX = techButtonCoords.x - prerequisiteCoords.x;
                    float deltaY = techButtonCoords.y - prerequisiteCoords.y;
                    float halfLength = deltaX / 2.0f;
                    Image $this$addConnectingLines_u24lambda_u241 = image2 = ImageGetter.INSTANCE.getWhiteDot();
                    boolean bl = false;
                    $this$addConnectingLines_u24lambda_u241.setWidth(halfLength - r - lineSize / (float)2);
                    $this$addConnectingLines_u24lambda_u241.setHeight(lineSize);
                    $this$addConnectingLines_u24lambda_u241.setX(prerequisiteCoords.x);
                    $this$addConnectingLines_u24lambda_u241.setY(prerequisiteCoords.y - lineSize / (float)2);
                    Image line2 = image2;
                    Image $this$addConnectingLines_u24lambda_u242 = $this$addConnectingLines_u24lambda_u241 = ImageGetter.INSTANCE.getWhiteDot();
                    boolean bl2 = false;
                    $this$addConnectingLines_u24lambda_u242.setWidth(halfLength - r - lineSize / (float)2);
                    $this$addConnectingLines_u24lambda_u242.setHeight(lineSize);
                    $this$addConnectingLines_u24lambda_u242.setX(techButtonCoords.x - $this$addConnectingLines_u24lambda_u242.getWidth());
                    $this$addConnectingLines_u24lambda_u242.setY(techButtonCoords.y - lineSize / (float)2);
                    Image line1 = $this$addConnectingLines_u24lambda_u241;
                    Image $this$addConnectingLines_u24lambda_u243 = $this$addConnectingLines_u24lambda_u242 = ImageGetter.INSTANCE.getWhiteDot();
                    boolean bl3 = false;
                    $this$addConnectingLines_u24lambda_u243.setWidth(lineSize);
                    $this$addConnectingLines_u24lambda_u243.setHeight(Math.abs(deltaY) - (float)2 * r - lineSize);
                    $this$addConnectingLines_u24lambda_u243.setX(techButtonCoords.x - halfLength - lineSize / (float)2);
                    $this$addConnectingLines_u24lambda_u243.setY(techButtonCoords.y + (deltaY > 0.0f ? -$this$addConnectingLines_u24lambda_u243.getHeight() - r - lineSize / (float)2 : r + lineSize / (float)2));
                    Image line22 = $this$addConnectingLines_u24lambda_u242;
                    Image line3 = null;
                    Image line4 = null;
                    if (deltaY < 0.0f) {
                        line3 = ImageGetter.INSTANCE.getLine(line22.getX() + lineSize / (float)2 + 0.3f, line22.getY() + line22.getHeight() - lineSize / (float)2, line2.getX() + line2.getWidth() - lineSize / (float)2, line2.getY() + lineSize / (float)2 + 0.3f, lineSize);
                        line4 = ImageGetter.INSTANCE.getLine(line22.getX() + lineSize / (float)2 - 0.3f, line22.getY() + lineSize / (float)2, line1.getX() + lineSize / (float)2, line1.getY() + lineSize / (float)2 - 0.3f, lineSize);
                    } else {
                        line3 = ImageGetter.INSTANCE.getLine(line22.getX() + lineSize / (float)2 + 0.3f, line22.getY() + lineSize / (float)2, line2.getX() + line2.getWidth() - lineSize / (float)2, line2.getY() + lineSize / (float)2 - 0.3f, lineSize);
                        line4 = ImageGetter.INSTANCE.getLine(line22.getX() + lineSize / (float)2 - 0.3f, line22.getY() + line22.getHeight() - lineSize / (float)2, line1.getX() + lineSize / (float)2, line1.getY() + lineSize / (float)2 + 0.3f, lineSize);
                    }
                    line2.setColor(lineColor);
                    line1.setColor(lineColor);
                    line22.setColor(lineColor);
                    line3.setColor(lineColor);
                    line4.setColor(lineColor);
                    this.lines.addActor(line2);
                    this.lines.addActor(line1);
                    this.lines.addActor(line22);
                    this.lines.addActor(line3);
                    this.lines.addActor(line4);
                    continue;
                }
                Image $this$addConnectingLines_u24lambda_u244 = image = ImageGetter.INSTANCE.getWhiteDot();
                boolean bl = false;
                $this$addConnectingLines_u24lambda_u244.setWidth(techButtonCoords.x - prerequisiteCoords.x);
                $this$addConnectingLines_u24lambda_u244.setHeight(lineSize);
                $this$addConnectingLines_u24lambda_u244.setX(prerequisiteCoords.x);
                $this$addConnectingLines_u24lambda_u244.setY(prerequisiteCoords.y - lineSize / (float)2);
                Image line3 = image;
                line3.setColor(lineColor);
                this.lines.addActor(line3);
            }
        }
        SnapshotArray<Actor> snapshotArray = this.lines.getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
        Iterable $this$filter$iv = snapshotArray;
        boolean $i$f$filter = false;
        techButton = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Actor it = (Actor)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(it.getColor(), this.currentTechColor) && !Intrinsics.areEqual(it.getColor(), Color.WHITE.cpy()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Actor it = (Actor)element$iv;
            boolean bl = false;
            it.toFront();
        }
    }

    private final void addOrderIndicators() {
        this.orderIndicators.clear();
        for (Map.Entry entry : ((Map)this.techNameToButton).entrySet()) {
            String techName = (String)entry.getKey();
            TechButton techButton = (TechButton)entry.getValue();
            Vector2 techButtonCoords = new Vector2(0.0f, techButton.getHeight() / (float)2);
            techButton.localToStageCoordinates(techButtonCoords);
            this.techTable.stageToLocalCoordinates(techButtonCoords);
            if (!this.tempTechsToResearch.contains(techName) || this.tempTechsToResearch.size() <= 1) continue;
            int index = this.tempTechsToResearch.indexOf(techName) + 1;
            Actor actor = Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr(index), null, 18, 0, false, 13, null);
            Label $this$addOrderIndicators_u24lambda_u240 = actor;
            boolean bl = false;
            $this$addOrderIndicators_u24lambda_u240.setAlignment(1);
            Actor $this$addOrderIndicators_u24lambda_u241 = actor = Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.surroundWithCircle$default(actor, 28.0f, false, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), null, 10, null), 30.0f, false, null, null, 12, null);
            boolean bl2 = false;
            $this$addOrderIndicators_u24lambda_u241.setPosition(techButtonCoords.x - $this$addOrderIndicators_u24lambda_u241.getWidth(), techButtonCoords.y - $this$addOrderIndicators_u24lambda_u241.getHeight() / (float)2);
            Actor orderIndicator = actor;
            this.orderIndicators.addActor(orderIndicator);
        }
        this.orderIndicators.toFront();
    }

    /*
     * WARNING - void declaration
     */
    private final void selectTechnology(Technology tech, boolean queue, boolean center, boolean switchFromWorldScreen) {
        Iterator iterator2;
        Technology previousSelectedTech = this.selectedTech;
        this.selectedTech = tech;
        Technology technology = tech;
        this.getDescriptionLabel().setText(technology != null ? technology.getDescription(this.civInfo) : null);
        if (!switchFromWorldScreen) {
            return;
        }
        if (tech == null) {
            return;
        }
        if (center) {
            this.centerOnTechnology(tech);
        }
        if (this.freeTechPick) {
            this.selectTechnologyForFreeTech(tech);
            this.setButtonsInfo();
            return;
        }
        if (this.civInfo.getGameInfo().getGameParameters().getGodMode() && !this.civInfo.getTech().isResearched(tech.getName()) && Intrinsics.areEqual(this.selectedTech, previousSelectedTech)) {
            TechManager.addTechnology$default(this.civInfo.getTech(), tech.getName(), false, 2, null);
        }
        if (this.civTech.isResearched(tech.getName()) && !tech.isContinuallyResearchable()) {
            this.getRightSideButton().setText(TranslationsKt.tr$default("Pick a tech", false, false, 3, null));
            Scene2dExtensionsKt.disable(this.getRightSideButton());
            this.setButtonsInfo();
            return;
        }
        if (!GUI.INSTANCE.isAllowedChangeState()) {
            Scene2dExtensionsKt.disable(this.getRightSideButton());
            return;
        }
        List<Technology> pathToTech = this.civTech.getRequiredTechsToDestination(tech);
        Object object = pathToTech.iterator();
        while (object.hasNext()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Technology requiredTech;
            Intrinsics.checkNotNullExpressionValue(object.next(), "next(...)");
            Iterable iterable = requiredTech.getUniqueObjects();
            boolean $i$f$filter = false;
            Iterator iterator3 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Unique it = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == UniqueType.OnlyAvailable && !it.conditionalsApply(this.civInfo.getState()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterator2 = ((List)destination$iv$iv).iterator();
            if (!iterator2.hasNext()) continue;
            Unique unique = (Unique)iterator2.next();
            this.getRightSideButton().setText(TranslationsKt.tr$default(unique.getDisplayText(), false, false, 3, null));
            Scene2dExtensionsKt.disable(this.getRightSideButton());
            return;
        }
        if (queue) {
            object = pathToTech.iterator();
            while (object.hasNext()) {
                Technology pathTech;
                Intrinsics.checkNotNullExpressionValue(object.next(), "next(...)");
                if (this.tempTechsToResearch.contains(pathTech.getName())) continue;
                this.tempTechsToResearch.add(pathTech.getName());
            }
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.tempTechsToResearch.clear();
            object = pathToTech;
            ArrayList<String> arrayList = this.tempTechsToResearch;
            boolean $i$f$map = false;
            iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Technology $i$f$filterTo = (Technology)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            arrayList.addAll((List)destination$iv$iv);
        }
        if (CollectionsKt.any((Iterable)this.tempTechsToResearch)) {
            String label = TranslationsKt.tr$default("Research [" + this.tempTechsToResearch.get(0) + ']', false, false, 3, null);
            String techProgression = this.getTechProgressLabel((List<String>)this.tempTechsToResearch);
            this.pick(label + '\n' + techProgression);
        } else {
            this.getRightSideButton().setText(TranslationsKt.tr$default("Unavailable", false, false, 3, null));
            Scene2dExtensionsKt.disable(this.getRightSideButton());
        }
        this.setButtonsInfo();
    }

    static /* synthetic */ void selectTechnology$default(TechPickerScreen techPickerScreen, Technology technology, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        techPickerScreen.selectTechnology(technology, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final String getTechProgressLabel(List<String> techs) {
        int n;
        int n2;
        String string;
        Object object2;
        Iterable iterable = techs;
        int n3 = 0;
        for (Object object2 : iterable) {
            void tech;
            string = (String)object2;
            n2 = n3;
            boolean bl = false;
            n = this.civTech.researchOfTech((String)tech);
            n3 = n2 + n;
        }
        int progress = n3 + this.civTech.getOverflowScience();
        Iterable iterable2 = techs;
        int n4 = 0;
        object2 = iterable2.iterator();
        while (object2.hasNext()) {
            void tech;
            String bl = string = object2.next();
            n2 = n4;
            boolean bl2 = false;
            n = this.civInfo.getTech().costOfTech((String)tech);
            n4 = n2 + n;
        }
        int techCost = n4;
        return "" + '(' + progress + '/' + techCost + ')';
    }

    private final void centerOnTechnology(Technology tech) {
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, tech, null){
            int label;
            final /* synthetic */ TechPickerScreen this$0;
            final /* synthetic */ Technology $tech;
            {
                this.this$0 = $receiver;
                this.$tech = $tech;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        Group group = (TechButton)TechPickerScreen.access$getTechNameToButton$p(this.this$0).get(this.$tech.getName());
                        if (group != null && (group = group.getParent()) != null) {
                            Group group2 = group;
                            TechPickerScreen techPickerScreen = this.this$0;
                            Group it = group2;
                            boolean bl = false;
                            techPickerScreen.getScrollPane().scrollTo(it.getX(), it.getY(), it.getWidth(), it.getHeight(), true, true);
                            techPickerScreen.getScrollPane().updateVisualScroll();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void selectTechnologyForFreeTech(Technology tech) {
        if (this.researchableTechs.contains(tech.getName())) {
            String label = TranslationsKt.tr$default("Pick [" + tech.getName() + "] as free tech", false, false, 3, null);
            String techProgression = this.getTechProgressLabel(CollectionsKt.listOf(tech.getName()));
            this.pick(label + '\n' + techProgression);
        } else {
            this.getRightSideButton().setText(TranslationsKt.tr$default("Pick a free tech", false, false, 3, null));
            Scene2dExtensionsKt.disable(this.getRightSideButton());
        }
    }

    private static final Unit _init_$lambda$0(TechPickerScreen this$0) {
        if (this$0.selectedTech != null) {
            Technology technology = this$0.selectedTech;
            Intrinsics.checkNotNull(technology);
            this$0.openCivilopedia(technology.makeLink());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TechPickerScreen this$0) {
        this$0.tryExit();
        return Unit.INSTANCE;
    }

    private static final Unit createTechTable$lambda$3(TechPickerScreen this$0, Technology $tech) {
        TechPickerScreen.selectTechnology$default(this$0, $tech, false, false, false, 8, null);
        return Unit.INSTANCE;
    }

    private static final Unit createTechTable$lambda$4(TechPickerScreen this$0, Technology $tech) {
        TechPickerScreen.selectTechnology$default(this$0, $tech, true, false, false, 8, null);
        return Unit.INSTANCE;
    }

    private static final Unit createTechTable$lambda$5(TechPickerScreen this$0) {
        this$0.tryExit();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ HashMap access$getTechNameToButton$p(TechPickerScreen $this) {
        return $this.techNameToButton;
    }
}

