/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.actions;

import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.UncivSound;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionModifiers;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0003J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0011J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsReligion;", "", "<init>", "()V", "getFoundReligionActions", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/UnitAction;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getFoundReligionActions$core", "getEnhanceReligionActions", "getEnhanceReligionActions$core", "getPressureAddedFromSpread", "", "getSpreadReligionActions", "getSpreadReligionActions$core", "getRemoveHeresyActions", "getRemoveHeresyActions$core", "core"})
@SourceDebugExtension(value={"SMAP\nUnitActionsReligion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitActionsReligion.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsReligion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,161:1\n1761#2,3:162\n1761#2,3:166\n1#3:165\n630#4,3:169\n*S KotlinDebug\n*F\n+ 1 UnitActionsReligion.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsReligion\n*L\n23#1:162,3\n52#1:166,3\n131#1:169,3\n*E\n"})
public final class UnitActionsReligion {
    @NotNull
    public static final UnitActionsReligion INSTANCE = new UnitActionsReligion();

    private UnitActionsReligion() {
    }

    @NotNull
    public final Sequence<UnitAction> getFoundReligionActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Function0<Unit> function0;
        boolean bl;
        Unique unique;
        block5: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!unit.getCiv().getReligionManager().mayFoundReligionAtAll()) {
                return SequencesKt.emptySequence();
            }
            Unique unique2 = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.MayFoundReligion));
            if (unique2 == null) {
                return SequencesKt.emptySequence();
            }
            unique = unique2;
            Iterable $this$any$iv = unique.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    Object object = it.getType();
                    boolean bl3 = object != null && (object = object.getTargetTypes()) != null ? ((HashSet)object).contains((Object)UniqueTarget.UnitActionModifier) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean hasActionModifiers = bl;
        Function0<Unit> $i$f$any = function0 = () -> UnitActionsReligion.getFoundReligionActions$lambda$1(unit, hasActionModifiers, unique);
        Unique unique3 = null;
        UncivSound uncivSound = null;
        boolean bl4 = false;
        String string = hasActionModifiers ? UnitActionModifiers.INSTANCE.actionTextWithSideEffects(UnitActionType.FoundReligion.getValue(), unique, unit) : UnitActionType.FoundReligion.getValue();
        float f = 80.0f;
        UnitActionType unitActionType = UnitActionType.FoundReligion;
        boolean bl5 = false;
        boolean bl6 = unit.getCiv().getReligionManager().mayFoundReligionHere(tile) && UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, unique);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Function0<Unit> function02 = bl6 ? function0 : null;
        Unique unique4 = unique3;
        UncivSound uncivSound2 = uncivSound;
        boolean bl7 = bl4;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return SequencesKt.sequenceOf(new UnitAction(unitActionType2, f2, string2, bl7, uncivSound2, unique4, function02, n, defaultConstructorMarker));
    }

    @NotNull
    public final Sequence<UnitAction> getEnhanceReligionActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        boolean bl;
        Unique unique;
        block5: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!unit.getCiv().getReligionManager().mayEnhanceReligionAtAll()) {
                return SequencesKt.emptySequence();
            }
            Unique unique2 = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.MayEnhanceReligion));
            if (unique2 == null) {
                return SequencesKt.emptySequence();
            }
            unique = unique2;
            Iterable $this$any$iv = unique.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    Object object = it.getType();
                    boolean bl3 = object != null && (object = object.getTargetTypes()) != null ? ((HashSet)object).contains((Object)UniqueTarget.UnitActionModifier) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean hasActionModifiers = bl;
        StringBuilder stringBuilder = new StringBuilder().append("Enhance [");
        Religion religion = unit.getCiv().getReligionManager().getReligion();
        Intrinsics.checkNotNull(religion);
        String baseTitle = stringBuilder.append(religion.getReligionDisplayName()).append(']').toString();
        Function0<Unit> function0 = () -> UnitActionsReligion.getEnhanceReligionActions$lambda$1(unit, hasActionModifiers, unique);
        Function0<Unit> function02 = function0;
        Unique unique3 = null;
        UncivSound uncivSound = null;
        boolean bl4 = false;
        String string = hasActionModifiers ? UnitActionModifiers.INSTANCE.actionTextWithSideEffects(baseTitle, unique, unit) : baseTitle;
        float f = 79.0f;
        UnitActionType unitActionType = UnitActionType.EnhanceReligion;
        boolean bl5 = false;
        boolean bl6 = unit.getCiv().getReligionManager().mayEnhanceReligionHere(tile) && UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, unique);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Function0<Unit> function03 = bl6 ? function0 : null;
        Unique unique4 = unique3;
        UncivSound uncivSound2 = uncivSound;
        boolean bl7 = bl4;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return SequencesKt.sequenceOf(new UnitAction(unitActionType2, f2, string2, bl7, uncivSound2, unique4, function03, n, defaultConstructorMarker));
    }

    @Readonly
    private final int getPressureAddedFromSpread(MapUnit unit) {
        float pressureAdded = unit.getBaseUnit().getReligiousStrength();
        Iterator iterator2 = MapUnit.getMatchingUniques$default(unit, UniqueType.SpreadReligionStrength, null, true, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            pressureAdded *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return (int)pressureAdded;
    }

    @NotNull
    public final Sequence<UnitAction> getSpreadReligionActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Function0<Unit> function0;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!unit.getCiv().getReligionManager().maySpreadReligionAtAll(unit)) {
            return SequencesKt.emptySequence();
        }
        City city = tile.getCity();
        if (city == null) {
            return SequencesKt.emptySequence();
        }
        City city2 = city;
        Unique unique = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.CanSpreadReligion));
        if (unique == null) {
            return SequencesKt.emptySequence();
        }
        Unique newStyleUnique = unique;
        StringBuilder stringBuilder = new StringBuilder().append("Spread [");
        String string = unit.getReligionDisplayName();
        Intrinsics.checkNotNull(string);
        String title = UnitActionModifiers.INSTANCE.actionTextWithSideEffects(stringBuilder.append(string).append(']').toString(), newStyleUnique, unit);
        Function0<Unit> function02 = function0 = () -> UnitActionsReligion.getSpreadReligionActions$lambda$0(city2, unit, newStyleUnique);
        Unique unique2 = null;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string2 = title;
        float f = 68.0f;
        UnitActionType unitActionType = UnitActionType.SpreadReligion;
        boolean bl2 = false;
        boolean bl3 = unit.getCiv().getReligionManager().maySpreadReligionNow(unit) && UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, newStyleUnique);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Function0<Unit> function03 = bl3 ? function0 : null;
        Unique unique3 = unique2;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string3 = string2;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return SequencesKt.sequenceOf(new UnitAction(unitActionType2, f2, string3, bl4, uncivSound2, unique3, function03, n, defaultConstructorMarker));
    }

    @NotNull
    public final Sequence<UnitAction> getRemoveHeresyActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        boolean hasNewStyleAbility;
        Object it;
        boolean bl;
        City city;
        block10: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!unit.getCiv().getGameInfo().isReligionEnabled()) {
                return SequencesKt.emptySequence();
            }
            Religion religion = (Religion)((Map)unit.getCiv().getGameInfo().getReligions()).get(unit.getReligion());
            if (religion == null) {
                return SequencesKt.emptySequence();
            }
            Religion religion2 = religion;
            if (religion2.isPantheon()) {
                return SequencesKt.emptySequence();
            }
            City city2 = tile.getCity();
            if (city2 == null) {
                return SequencesKt.emptySequence();
            }
            city = city2;
            if (!Intrinsics.areEqual(city.getCiv(), unit.getCiv())) {
                return SequencesKt.emptySequence();
            }
            Map $this$none$iv = city.getReligion().getPressures();
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                for (Map.Entry element$iv : $this$none$iv.entrySet()) {
                    it = element$iv;
                    boolean bl2 = false;
                    Object k = it.getKey();
                    String string = unit.getReligion();
                    Intrinsics.checkNotNull(string);
                    if (!(!Intrinsics.areEqual(k, string))) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            return SequencesKt.emptySequence();
        }
        Unique newStyleUnique = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.CanRemoveHeresy));
        boolean bl3 = hasNewStyleAbility = newStyleUnique != null;
        if (!hasNewStyleAbility) {
            return SequencesKt.emptySequence();
        }
        Unique unique = newStyleUnique;
        Intrinsics.checkNotNull(unique);
        String title = UnitActionModifiers.INSTANCE.actionTextWithSideEffects("Remove Heresy", unique, unit);
        Function0<Unit> function0 = () -> UnitActionsReligion.getRemoveHeresyActions$lambda$1(city, unit, newStyleUnique);
        it = function0;
        Unique unique2 = null;
        UncivSound uncivSound = null;
        boolean bl4 = false;
        String string = title;
        float f = 69.0f;
        UnitActionType unitActionType = UnitActionType.RemoveHeresy;
        boolean bl5 = false;
        boolean bl6 = UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, newStyleUnique);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Function0<Unit> function02 = bl6 ? function0 : null;
        Unique unique3 = unique2;
        UncivSound uncivSound2 = uncivSound;
        boolean bl7 = bl4;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return SequencesKt.sequenceOf(new UnitAction(unitActionType2, f2, string2, bl7, uncivSound2, unique3, function02, n, defaultConstructorMarker));
    }

    private static final Unit getFoundReligionActions$lambda$1(MapUnit $unit, boolean $hasActionModifiers, Unique $unique) {
        $unit.getCiv().getReligionManager().foundReligion($unit);
        if ($hasActionModifiers) {
            UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, $unit, $unique, false, 4, null);
        } else {
            $unit.consume();
        }
        return Unit.INSTANCE;
    }

    private static final Unit getEnhanceReligionActions$lambda$1(MapUnit $unit, boolean $hasActionModifiers, Unique $unique) {
        $unit.getCiv().getReligionManager().useProphetForEnhancingReligion($unit);
        if ($hasActionModifiers) {
            UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, $unit, $unique, false, 4, null);
        } else {
            $unit.consume();
        }
        return Unit.INSTANCE;
    }

    private static final Unit getSpreadReligionActions$lambda$0(City $city, MapUnit $unit, Unique $newStyleUnique) {
        Religion newReligion;
        CityReligionManager cityReligionManager = $city.getReligion();
        String string = $unit.getReligion();
        Intrinsics.checkNotNull(string);
        int followersOfOtherReligions = cityReligionManager.getFollowersOfOtherReligionsThan(string);
        Iterator iterator2 = MapUnit.getMatchingUniques$default($unit, UniqueType.StatsWhenSpreading, null, true, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            $unit.getCiv().addStat(Stat.valueOf(unique.getParams().get(1)), followersOfOtherReligions * Integer.parseInt(unique.getParams().get(0)));
        }
        Religion previousReligion = $city.getReligion().getMajorityReligion();
        CityReligionManager cityReligionManager2 = $city.getReligion();
        String string2 = $unit.getReligion();
        Intrinsics.checkNotNull(string2);
        CityReligionManager.addPressure$default(cityReligionManager2, string2, INSTANCE.getPressureAddedFromSpread($unit), false, 4, null);
        if (MapUnit.hasUnique$default($unit, UniqueType.RemoveOtherReligions, null, false, 6, null)) {
            CityReligionManager cityReligionManager3 = $city.getReligion();
            String string3 = $unit.getReligion();
            Intrinsics.checkNotNull(string3);
            cityReligionManager3.removeAllPressuresExceptFor(string3);
        }
        if (!Intrinsics.areEqual(previousReligion, newReligion = $city.getReligion().getMajorityReligion()) && newReligion != null && !Intrinsics.areEqual($city.getCiv(), $unit.getCiv())) {
            $city.getCiv().addNotification('[' + $unit.getCiv().getCivName() + "]'s [" + $unit.getName() + "] has converted [" + $city.getName() + "] to [" + newReligion.getName() + "]!", Notification.NotificationCategory.Religion, new String[0]);
        }
        UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, $unit, $newStyleUnique, false, 4, null);
        if (!Intrinsics.areEqual($city.getCiv(), $unit.getCiv())) {
            DiplomacyManager diplomacyManager = $city.getCiv().getDiplomacyManager($unit.getCiv());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setFlag(DiplomacyFlags.SpreadReligionInOurCities, 30);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getRemoveHeresyActions$lambda$1(City $city, MapUnit $unit, Unique $newStyleUnique) {
        CityReligionManager cityReligionManager = $city.getReligion();
        String string = $unit.getReligion();
        Intrinsics.checkNotNull(string);
        cityReligionManager.removeAllPressuresExceptFor(string);
        if ($city.getReligion().getReligionThisIsTheHolyCityOf() != null) {
            Object v = ((Map)$unit.getCiv().getGameInfo().getReligions()).get($city.getReligion().getReligionThisIsTheHolyCityOf());
            Intrinsics.checkNotNull(v);
            Religion holyCityReligion = (Religion)v;
            if (!Intrinsics.areEqual($city.getReligion().getReligionThisIsTheHolyCityOf(), $unit.getReligion()) && !$city.getReligion().isBlockedHolyCity()) {
                holyCityReligion.getFoundingCiv().addNotification("An [" + $unit.getBaseUnit().getName() + "] has removed your religion [" + holyCityReligion.getReligionDisplayName() + "] from its Holy City [" + $city.getName() + "]!", Notification.NotificationCategory.Religion, new String[0]);
                $city.getReligion().setBlockedHolyCity(true);
            } else if (Intrinsics.areEqual($city.getReligion().getReligionThisIsTheHolyCityOf(), $unit.getReligion()) && $city.getReligion().isBlockedHolyCity()) {
                holyCityReligion.getFoundingCiv().addNotification("An [" + $unit.getBaseUnit().getName() + "] has restored [" + $city.getName() + "] as the Holy City of your religion [" + holyCityReligion.getReligionDisplayName() + "]!", Notification.NotificationCategory.Religion, new String[0]);
                $city.getReligion().setBlockedHolyCity(false);
            }
        }
        UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, $unit, $newStyleUnique, false, 4, null);
        return Unit.INSTANCE;
    }
}

