/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.uuid.ExperimentalUuidApi;
import kotlin.uuid.Uuid;
import kotlin.uuid.UuidKt;
import kotlin.uuid.UuidKt__UuidJVMKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=5, xi=49, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a,\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0001\u001a\u0014\u0010\u000e\u001a\u00020\t*\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\u0010\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000fH\u0001\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000fH\u0001\u001a\u0019\u0010\u0016\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\b\u0018\u001a\u0019\u0010\u0016\u001a\u00020\u000f*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\b\u0018\u00a8\u0006\u001a"}, d2={"uuidFromRandomBytes", "Lkotlin/uuid/Uuid;", "randomBytes", "", "getLongAtCommonImpl", "", "index", "", "formatBytesIntoCommonImpl", "", "dst", "dstOffset", "startIndex", "endIndex", "checkHyphenAt", "", "setLongAtCommonImpl", "value", "uuidParseHexDashCommonImpl", "hexDashString", "uuidParseHexCommonImpl", "hexString", "truncateForErrorMessage", "maxLength", "truncateForErrorMessage$UuidKt__UuidKt", "maxSize", "kotlin-stdlib"}, xs="kotlin/uuid/UuidKt")
@SourceDebugExtension(value={"SMAP\nUuid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uuid.kt\nkotlin/uuid/UuidKt__UuidKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,648:1\n1#2:649\n*E\n"})
class UuidKt__UuidKt
extends UuidKt__UuidJVMKt {
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid uuidFromRandomBytes(@NotNull byte[] randomBytes) {
        Intrinsics.checkNotNullParameter(randomBytes, "randomBytes");
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return Uuid.Companion.fromByteArray(randomBytes);
    }

    public static final long getLongAtCommonImpl(@NotNull byte[] $this$getLongAtCommonImpl, int index) {
        Intrinsics.checkNotNullParameter($this$getLongAtCommonImpl, "<this>");
        return ((long)$this$getLongAtCommonImpl[index + 0] & 0xFFL) << 56 | ((long)$this$getLongAtCommonImpl[index + 1] & 0xFFL) << 48 | ((long)$this$getLongAtCommonImpl[index + 2] & 0xFFL) << 40 | ((long)$this$getLongAtCommonImpl[index + 3] & 0xFFL) << 32 | ((long)$this$getLongAtCommonImpl[index + 4] & 0xFFL) << 24 | ((long)$this$getLongAtCommonImpl[index + 5] & 0xFFL) << 16 | ((long)$this$getLongAtCommonImpl[index + 6] & 0xFFL) << 8 | (long)$this$getLongAtCommonImpl[index + 7] & 0xFFL;
    }

    @ExperimentalUuidApi
    public static final void formatBytesIntoCommonImpl(long $this$formatBytesIntoCommonImpl, @NotNull byte[] dst, int dstOffset, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        int dstIndex = dstOffset;
        int reversedIndex = 7 - startIndex;
        int n = 8 - endIndex;
        if (n <= reversedIndex) {
            while (true) {
                int shift = reversedIndex << 3;
                int n2 = (int)($this$formatBytesIntoCommonImpl >> shift & 0xFFL);
                int byteDigits = HexExtensionsKt.getBYTE_TO_LOWER_CASE_HEX_DIGITS()[n2];
                dst[dstIndex++] = (byte)(byteDigits >> 8);
                dst[dstIndex++] = (byte)byteDigits;
                if (reversedIndex == n) break;
                --reversedIndex;
            }
        }
    }

    public static final void checkHyphenAt(@NotNull String $this$checkHyphenAt, int index) {
        Intrinsics.checkNotNullParameter($this$checkHyphenAt, "<this>");
        if (!($this$checkHyphenAt.charAt(index) == '-')) {
            boolean bl = false;
            String string = "Expected '-' (hyphen) at index " + index + ", but was '" + $this$checkHyphenAt.charAt(index) + '\'';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void setLongAtCommonImpl(@NotNull byte[] $this$setLongAtCommonImpl, int index, long value) {
        Intrinsics.checkNotNullParameter($this$setLongAtCommonImpl, "<this>");
        int i = index;
        for (int reversedIndex = 7; -1 < reversedIndex; --reversedIndex) {
            int shift = reversedIndex << 3;
            $this$setLongAtCommonImpl[i++] = (byte)(value >> shift);
        }
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Uuid uuidParseHexDashCommonImpl(@NotNull String hexDashString) {
        Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
        long part12 = HexExtensionsKt.hexToLong$default(hexDashString, 0, 8, null, 4, null);
        UuidKt.checkHyphenAt(hexDashString, 8);
        long part2 = HexExtensionsKt.hexToLong$default(hexDashString, 9, 13, null, 4, null);
        UuidKt.checkHyphenAt(hexDashString, 13);
        long part3 = HexExtensionsKt.hexToLong$default(hexDashString, 14, 18, null, 4, null);
        UuidKt.checkHyphenAt(hexDashString, 18);
        long part4 = HexExtensionsKt.hexToLong$default(hexDashString, 19, 23, null, 4, null);
        UuidKt.checkHyphenAt(hexDashString, 23);
        long part5 = HexExtensionsKt.hexToLong$default(hexDashString, 24, 36, null, 4, null);
        long msb = part12 << 32 | part2 << 16 | part3;
        long lsb = part4 << 48 | part5;
        return Uuid.Companion.fromLongs(msb, lsb);
    }

    @ExperimentalUuidApi
    @NotNull
    public static final Uuid uuidParseHexCommonImpl(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        long msb = HexExtensionsKt.hexToLong$default(hexString, 0, 16, null, 4, null);
        long lsb = HexExtensionsKt.hexToLong$default(hexString, 16, 32, null, 4, null);
        return Uuid.Companion.fromLongs(msb, lsb);
    }

    private static final String truncateForErrorMessage$UuidKt__UuidKt(String $this$truncateForErrorMessage, int maxLength) {
        String string;
        if ($this$truncateForErrorMessage.length() <= maxLength) {
            string = $this$truncateForErrorMessage;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = $this$truncateForErrorMessage;
            int n = 0;
            Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
            String string3 = string2.substring(n, maxLength);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            string = stringBuilder.append(string3).append("...").toString();
        }
        return string;
    }

    private static final String truncateForErrorMessage$UuidKt__UuidKt(byte[] $this$truncateForErrorMessage, int maxSize) {
        return ArraysKt.joinToString$default($this$truncateForErrorMessage, null, (CharSequence)"[", (CharSequence)"]", maxSize, null, null, 49, null);
    }

    public static final /* synthetic */ String access$truncateForErrorMessage(String $receiver, int maxLength) {
        return UuidKt__UuidKt.truncateForErrorMessage$UuidKt__UuidKt($receiver, maxLength);
    }

    public static final /* synthetic */ String access$truncateForErrorMessage(byte[] $receiver, int maxSize) {
        return UuidKt__UuidKt.truncateForErrorMessage$UuidKt__UuidKt($receiver, maxSize);
    }
}

