#pragma once

#define BROKER_HAS_VARIANT

#define BROKER_APPLE
/* #undef BROKER_FREEBSD */
/* #undef BROKER_LINUX */
/* #undef BROKER_WINDOWS */
/* #undef BROKER_BIG_ENDIAN */
#define BROKER_HAS_STD_FILESYSTEM

#define BROKER_USE_SSE2

// GCC uses __SANITIZE_ADDRESS__, Clang uses __has_feature
#if defined(__SANITIZE_ADDRESS__)
#  define BROKER_ASAN
#endif

#if defined(__has_feature)
#  if __has_feature(address_sanitizer)
#    define BROKER_ASAN
#  endif
#endif

// FreeBSD and Windows don't support LeakSanitizer
#if defined(BROKER_ASAN) && !defined(__FreeBSD__) && !defined(_WIN32)
#  include <sanitizer/lsan_interface.h>
#  define BROKER_LSAN_CHECK(x) __lsan_do_leak_check(x)
#  define BROKER_LSAN_ENABLE() __lsan_enable()
#  define BROKER_LSAN_DISABLE() __lsan_disable()
#  define BROKER_LSAN_IGNORE(x) __lsan_ignore_object(x)
#else
#  define BROKER_LSAN_CHECK(x)
#  define BROKER_LSAN_ENABLE()
#  define BROKER_LSAN_DISABLE()
#  define BROKER_LSAN_IGNORE(x)
#endif

// TODO: the "proper" way of implementing the macro would be using
//       std::hardware_constructive_interference_size whenever available, but it
//       seems like the __cpp_lib_hardware_interference_size check macro is
//       buggy on the Clang versions shipped by FreeBSD. Hence, we hard-code 64
//       for now. This is the cache line size of X86/64 and on other common
//       hardware platforms.
#define BROKER_CONSTRUCTIVE_INTERFERENCE_SIZE 64
